#include <stdio.h>
#include <string.h>
#include "stations.h"

void numbering(const char *number, const char __attribute__((unused)) **carrier, const char **country, const char **national_number)
{
	static char digits[64];

	*country = "USA";
	strcpy(digits, "1");
	strcat(digits, number);
	*national_number = number;
}

/*
	1: the SID, system Identification number
	2: the BID, the billing identification number, or 0= if same as the SID
	3: a City in the area of the service (multiple cities may be listed)
	4: the Postal Code for the State or Province of the City in column 3 (Note: BH was used for Bahamas.)
	5: the telephone company name
	6: a customer service number for the area indicated by columns 3 and 4
	7: the clearing house that handles roamers' billing records
*/
static struct amps_stations {
	int sid, bid;
	const char *city, *state, *company, *customer_service, *clearing_house;
} amps_stations[] = {
	{ 1,		0,	"Chicago",		"IL",	"Cellular One",			"800 235 5663",	"GTEDS" },
	{ 2,		0,	"Los Angles",		"CA",	"Pactel Cellular",		"714 553 6100",	"GTEDS" },
	{ 2,		0,	"Palm Springs",		"CA",	"Pactel Cellular",		"714 553 6100",	"GTEDS" },
	{ 3,		0,	"Buffalo",		"NY",	"Buffalo Telephone Company",	"716 854 5076",	"BANK/IL" },
	{ 4,		0,	"San Diego",		"CA",	"Pactel Cellular",		"619 535 6464",	"GTEDS" },
	{ 5,		0,	"Milwaukee",		"WI",	"Cellular One",			"414 783 5500",	"APPEX" },
	{ 6,		0,	"Seattle",		"WA",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 6,		0,	"Tacoma",		"WA",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 7,		0,	"Boston",		"MA",	"Cellular One",			"617 890 1555",	"(Boston)" },
	{ 8,		0,	"Allentown",		"PA",	"Bell Atlantic Mobile",		"800 922 0204",	"GTEDS" },
	{ 8,		0,	"Philadelphia",		"PA",	"Bell Atlantic Mobile",		"800 953 2200",	"GTEDS" },
	{ 8,		0,	"Reading",		"PA",	"Bell Atlantic Mobile",		"800 922 0204",	"GTEDS" },
	{ 8,		0,	"Trenton",		"NJ",	"Bell Atlantic Mobile",		"800 922 0204",	"GTEDS" },
	{ 8,		0,	"Wilmington",		"DE",	"Bell Atlantic Mobile",		"800 922 0204",	"GTEDS" },
	{ 12,		0,	"Beaumont",		"TX",	"GTE Mobile",			"800 347 5665",	"GTEDS" },
	{ 12,		0,	"Bryan",		"TX",	"GTE Mobile",			"800 347 5665",	"GTEDS" },
	{ 12,		0,	"College Station",	"TX",	"GTE Mobile",			"800 347 5665",	"GTEDS" },
	{ 12,		0,	"Galveston",		"TX",	"GTE Mobile",			"800 347 5665",	"GTEDS" },
	{ 12,		0,	"Houston",		"TX",	"GTE Mobile",			"800 347 5665",	"GTEDS" },
	{ 12,		0,	"Port Arthur",		"TX",	"GTE Mobile",			"800 347 5665",	"GTEDS" },
	{ 13,		0,	"Baltimore",		"MD",	"Cellular One",			"301 220 0060",	"(Baltimore)" },
	{ 13,		0,	"Washington",		"DC",	"Cellular One",			"301 220 0060",	"(Baltimore)" },
	{ 15,		0,	"Cleveland",		"OH",	"Cellular One",			"216 351 1414",	"Commonwealth" },
	{ 15,		0,	"Elyria",		"OH",	"Cellular One",			"216 351 1414",	"Commonwealth" },
	{ 15,		0,	"Lorain",		"OH",	"Cellular One",			"216 351 1414",	"Commonwealth" },
	{ 17,		0,	"St. Louis",		"MO",	"Cybertel Cellular",		"314 423 6500",	"GTEDS" },
	{ 18,		0,	"Alexandria",		"VA",	"Bell Atlantic Mobile",		"800 922 0204",	"GTEDS" },
	{ 18,		0,	"Baltimore",		"MD",	"Bell Atlantic Mobile",		"800 922 0204",	"GTEDS" },
	{ 18,		30016,	"Frederick",		"MD",	"Bell Atlantic Mobile",		"",		"GTEDS" },
	{ 18,		0,	"Silver Spring",	"MD",	"Bell Atlantic Mobile",		"800 922 0204",	"GTEDS" },
	{ 18,		0,	"Washington",		"DC",	"Bell Atlantic Mobile",		"800 922 0204",	"GTEDS" },
	{ 19,		0,	"Indianapolis",		"IN",	"Cellular One",			"317 252 5367",	"CBIS" },
	{ 20,		0,	"Chicago",		"IL",	"Ameritech Mobile",		"800 221 0994",	"GTEDS" },
	{ 21,		0,	"Detroit",		"MI",	"Cellular One",			"313 737 5123",	"APPEX" },
	{ 21,		0,	"Flint",		"MI",	"Cellular One",			"313 239 6661",	"APPEX" },
	{ 21,		0,	"Grand Rapids",		"MI",	"Cellular One",			"616 451 3523",	"APPEX" },
	{ 21,		0,	"Lansing",		"MI",	"Cellular One",			"517 323 9462",	"APPEX" },
	{ 21,		0,	"Lima",			"OH",	"Cellular One",			"419 234 1091",	"APPEX" },
	{ 21,		0,	"Muskegon",		"WI",	"Cellular One",			"517 323 9492",	"APPEX" },
	{ 21,		0,	"Saginaw",		"MI",	"Cellular One",			"517 323 9462",	"APPEX" },
	{ 21,		0,	"Toledo",		"OH",	"Cellular One",			"419 243 1091",	"APPEX" },
	{ 22,		0,	"Brooklyn",		"NY",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 22,		0,	"Congers",		"NY",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 22,		0,	"Freehold",		"NJ",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 22,		0,	"Hackensack",		"NJ",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 22,		0,	"Madison",		"NJ",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 22,		0,	"Morristown",		"NJ",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 22,		0,	"Nassau County",	"NY",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 22,		0,	"New Brunswick",	"NJ",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 22,		0,	"Newark",		"NJ",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 22,		0,	"Paterson",		"NJ",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 22,		0,	"Pleasantville",	"NY",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 22,		0,	"Rahway",		"NY",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 22,		0,	"Suffolk County",	"NY",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 22,		0,	"White Plains",		"NY",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 22,		0,	"World Trade Center",	"NY",	"Nynex Mobile Com",		"800 227 1069",	"Nynex" },
	{ 23,		0,	"Minneapolis",		"MN",	"Cellular One",			"612 867 2273",	"APPEX" },
	{ 24,		0,	"Miami",		"FL",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 24,		0,	"West Palm Beach",	"FL",	"Bell South Mobile",		"305 577 4975",	"GTEDS" },
	{ 25,		0,	"New York",		"NY",	"Metro One",			"201 587 8000",	"APPEX" },
	{ 26,		0,	"Minneapolis",		"MN",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 27,		0,	"Los Angles",		"CA",	"LA Cellular Telephone Co.",	"213 721 8722",	"APPEX" },
	{ 27,		0,	"Oxnard",		"CA",	"Cellular One",			"805 987 0955",	"APPEX" },
	{ 28,		0,	"Auburn",		"MA",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 28,		0,	"Boston",		"MA",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 28,		0,	"Brockton",		"MA",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 28,		0,	"Framington",		"MA",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 28,		0,	"Lawrence",		"MA",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 28,		0,	"Lowell",		"MA",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 28,		0,	"Lynn",			"MA",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 28,		0,	"New Bedford",		"MA",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 28,		0,	"Providence",		"RI",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 28,		0,	"Worchester",		"MA",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 29,		0,	"Philadelphia",		"PA",	"Metrophone",			"800 327 9666",	"APPEX" },
	{ 30,		0,	"Portland",		"OR",	"GTE Mobile",			"800 366 5665",	"GTEDS" },
	{ 30,		0,	"Salem",		"OR",	"GTE Mobile",			"800 366 5665",	"GTEDS" },
	{ 31,		30015,	"Napa",			"CA",	"Cellular One",			"800 331 4322",	"APPEX" },
	{ 31,		30017,	"Santa Cruz",		"CA",	"Cellular One",			"415 344 1999",	"GTEDS" },
	{ 31,		0,	"Oakland",		"CA",	"Cellular One",			"415 344 1999",	"APPEX" },
	{ 31,		0,	"San Francisco",	"CA",	"Cellular One",			"415 344 1999",	"GTEDS" },
	{ 31,		0,	"San Jose",		"CA",	"Cellular One",			"415 344 1999",	"GTEDS" },
	{ 31,		0,	"San Rosa",		"CA",	"Cellular One",			"800 331 4322",	"GTEDS" },
	{ 31,		0,	"Vallejo",		"CA",	"Cellular One",			"800 331 4322",	"GTEDS" },
	{ 32,		0,	"Pittsburgh",		"PA",	"Bell Atlantic Mobile",		"800 922 0204",	"GTEDS" },
	{ 32,		30020,	"Altoona",		"PA",	"Bell Atlantic Mobile",		"814 944 3011",	"GTEDS" },
	{ 32,		30022,	"Charleston",		"WV",	"Bell Atlantic Mobile",		"304 925 4000",	"GTEDS" },
	{ 32,		30024,	"Huntington",		"WV",	"Bell Atlantic Mobile",		"304 525 4101",	"GTEDS" },
	{ 32,		30026,	"Johnstown",		"PA",	"Bell Atlantic Mobile",		"814 467 5521",	"GTEDS" },
	{ 32,		30030,	"Parkesburg",		"PA",	"Bell Atlantic Mobile",		"800 922 0204",	"GTEDS" },
	{ 32,		30034,	"State College",	"PA",	"Bell Atlantic Mobile",		"814 231 3900",	"GTEDS" },
	{ 32,		30032,	"Steubenville",		"OH",	"Bell Atlantic Mobile",		"614 282 6202",	"GTEDS" },
	{ 32,		30032,	"Weirton",		"WV",	"Bell Atlantic Mobile",		"614 282 6202",	"GTEDS" },
	{ 32,		30028,	"Wheeling",		"WV",	"Bell Atlantic Mobile",		"614 695 9611",	"GTEDS" },
	{ 33,		0,	"Dallas",		"TX",	"Metrocell Cellular",		"214 263 4921",	"APPEX" },
	{ 33,		0,	"Ft. Worth",		"TX",	"Metrocell Cellular",		"214 263 4921",	"APPEX" },
	{ 33,		0,	"Denton",		"TX",	"Metrocell Cellular",		"214 263 4921",	"APPEX" },
	{ 34,		0,	"Athens",		"GA",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 34,		0,	"Atlanta",		"GA",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 35,		0,	"Houston",		"TX",	"Houston Cellular Telephone",	"713 688 8020",	"APPEX" },
	{ 36,		0,	"New Orleans",		"LA",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 37,		0,	"Ft. Lauderdale",	"FL",	"McCaw Cellular",		"407 655 1948",	"APPEX" },
	{ 37,		0,	"Miami",		"FL",	"Cellular One",			"305 792 2355",	"APPEX" },
	{ 37,		0,	"Stuart",		"FL",	"Cellular One",			"407 833 1111",	"APPEX" },
	{ 37,		0,	"West Palm Beach",	"FL",	"Cellular One",			"407 833 1111",	"APPEX" },
	{ 38,		0,	"Ft. Worth",		"TX",	"Southwestern Bell Mobile",	"800 331 0500",	"GTEDS" },
	{ 38,		0,	"Dallas",		"TX",	"Southwestern Bell Mobile",	"800 331 0500",	"GTEDS" },
	{ 38,		0,	"Denison",		"TX",	"Southwestern Bell Mobile",	"800 331 0500",	"GTEDS" },
	{ 38,		0,	"Sherman",		"TX",	"Southwestern Bell Mobile",	"800 331 0500",	"GTEDS" },
	{ 39,		0,	"Johnstown",		"PA",	"Cellular One",			"814 242 0100",	"APPEX" },
	{ 39,		0,	"Pittsburgh",		"PA",	"Cellular One",			"412 471 3922",	"APPEX" },
	{ 39,		30059,	"Wheeling",		"WV",	"Cellular One",			"304 281 0100",	"APPEX" },
	{ 40,		0,	"Salinas",		"CA",	"GTE Mobile",			"800 366 5665",	"GTEDS" },
	{ 40,		0,	"San Francisco",	"CA",	"GTE Mobile",			"800 366 5665",	"GTEDS" },
	{ 40,		0,	"San Jose",		"CA",	"GTE Mobile",			"800 366 5665",	"GTEDS" },
	{ 40,		0,	"San Rosa",		"CA",	"GTE Mobile",			"800 366 5665",	"GTEDS" },
	{ 40,		30002,	"Santa Barbara",	"CA",	"GTE Mobile",			"800 366 5665",	"GTEDS" },
	{ 41,		0,	"Athens",		"GA",	"Pactel Cellular",		"404 449 3900",	"GTEDS" },
	{ 41,		0,	"Atlanta",		"GA",	"Pactel Cellular",		"404 449 3900",	"GTEDS" },
	{ 42,		0,	"Brandenton",		"FL",	"GTE Mobile",			"813 221 1662",	"GTEDS" },
	{ 42,		0,	"Ft. Meyers",		"FL",	"GTE Mobile",			"800 877 5665",	"GTEDS" },
	{ 42,		0,	"Lakeland",		"FL",	"GTE Mobile",			"800 877 5665",	"GTEDS" },
	{ 42,		0,	"Sarasota",		"FL",	"GTE Mobile",			"800 877 5665",	"GTEDS" },
	{ 42,		0,	"Tampa",		"FL",	"GTE Mobile",			"800 877 5665",	"GTEDS" },
	{ 42,		0,	"Venice",		"FL",	"GTE Mobile",			"800 877 5665",	"GTEDS" },
	{ 42,		0,	"Winter Haven",		"FL",	"GTE Mobile",			"800 877 5665",	"GTEDS" },
	{ 43,		0,	"San Diego",		"CA",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 45,		0,	"Colorado Springs",	"CO",	"Cellular One",			"303 831 1200",	"APPEX" },
	{ 45,		0,	"Denver",		"CO",	"Cellular One",			"303 831 1200",	"APPEX" },
	{ 45,		0,	"Ft. Collins",		"CO",	"Cellular One",			"303 831 1200",	"APPEX" },
	{ 45,		0,	"Greely",		"CO",	"Cellular One",			"303 831 1200",	"APPEX" },
	{ 46,		0,	"St. Louis",		"MO",	"Southwestern Bell Mobile",	"314 542 9999",	"GTEDS" },
	{ 47,		0,	"Bellingham",		"WA",	"Cellular One",			"206 285 2273",	"APPEX" },
	{ 47,		0,	"Bremerton",		"WA",	"Cellular One",			"206 285 2273",	"APPEX" },
	{ 47,		0,	"Olympia",		"WA",	"Cellular One",			"206 285 2273",	"APPEX" },
	{ 47,		0,	"Seattle",		"WA",	"Cellular One",			"206 285 2273",	"APPEX" },
	{ 47,		0,	"Tacoma",		"WA",	"Cellular One",			"206 285 2273",	"APPEX" },
	{ 48,		0,	"Phoenix",		"AZ",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 51,		0,	"Cincinnati",		"OH",	"Cellular One",			"513 733 5515",	"Commonwealth" },
	{ 51,		0,	"Hamilton",		"OH",	"Cellular One",			"513 733 5515",	"Commonwealth" },
	{ 52,		0,	"Kansas City",		"KS",	"Southwestern Bell Mobile",	"913 894 1600",	"GTEDS" },
	{ 52,		0,	"Kansas City",		"MO",	"Southwestern Bell Mobile",	"913 894 1600",	"GTEDS" },
	{ 52,		0,	"Lawrence",		"KS",	"Southwestern Bell Mobile",	"913 894 1600",	"GTEDS" },
	{ 52,		0,	"St. Joseph",		"MO",	"Southwestern Bell Mobile",	"913 894 1600",	"GTEDS" },
	{ 52,		0,	"Topeka",		"KS",	"Southwestern Bell Mobile",	"913 894 1600",	"GTEDS" },
	{ 53,		0,	"Phoenix",		"AZ",	"Metro Mobile",			"602 731 6000",	"APPEX" },
	{ 53,		30053,	"Tuscon",		"AZ",	"Metro Mobile",			"602 628 9541",	"APPEX" },
	{ 54,		0,	"Akron",		"OH",	"GTE Mobile",			"800 669 5665",	"GTEDS" },
	{ 54,		0,	"Canton",		"OH",	"GTE Mobile",			"800 669 5665",	"GTEDS" },
	{ 54,		0,	"Cleveland",		"OH",	"GTE Mobile",			"800 669 5665",	"GTEDS" },
	{ 54,		0,	"Elyria",		"OH",	"GTE Mobile",			"800 669 5665",	"GTEDS" },
	{ 54,		0,	"Erie",			"PA",	"GTE Mobile",			"800 669 5665",	"GTEDS" },
	{ 54,		0,	"Lorain",		"OH",	"GTE Mobile",			"800 669 5665",	"GTEDS" },
	{ 56,		0,	"Buffalo",		"NY",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 57,		0,	"New Orleans",		"LA",	"Cellular One",			"504 830 5400",	"GTEDS" },
	{ 58,		0,	"Denver",		"CO",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 59,		30057,	"Kansas City",		"KS",	"Cellular One",			"913 432 3141",	"APPEX" },
	{ 59,		30057,	"Kansas City",		"MO",	"Cellular One",			"913 432 3141",	"APPEX" },
	{ 59,		0,	"Lawrence",		"KS",	"Cellular One",			"913 842 0577",	"APPEX" },
	{ 59,		0,	"Topeka",		"KS",	"Cellular One",			"913 234 4984",	"APPEX" },
	{ 60,		0,	"Honolulu",		"HI",	"GTE Mobile",			"808 941 9934",	"GTEDS" },
	{ 61,		0,	"Eugene",		"OR",	"Cellular One",			"503 345 1818",	"APPEX" },
	{ 61,		0,	"Medford",		"OR",	"Cellular One",			"503 944 5555",	"APPEX" },
	{ 61,		0,	"Portland",		"OR",	"Cellular One",			"503 228 1717",	"APPEX" },
	{ 61,		0,	"Salem",		"OR",	"Cellular One",			"503 364 3335",	"APPEX" },
	{ 62,		0,	"Memphis",		"TN",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 63,		0,	"Albany",		"NY",	"Cellular One",			"518 465 7300",	"BANK/IL" },
	{ 64,		0,	"Las Vegas",		"NV",	"Centel Cellular",		"702 365 6500",	"GTEDS" },
	{ 65,		0,	"Louisville",		"KY",	"Cellular One",			"502 582 2355",	"APPEX" },
	{ 68,		0,	"Orlando",		"FL",	"Bell South Mobile",		"305 577 4975",	"GTEDS" },
	{ 69,		0,	"Durham",		"NC",	"Cellular One",			"919 481 1181",	"GTEDS" },
	{ 69,		0,	"Raleigh",		"NC",	"Cellular One",			"919 481 1181",	"GTEDS" },
	{ 70,		0,	"Wichita",		"KS",	"Southwestern Bell Mobile",	"316 687 2355",	"GTEDS" },
	{ 71,		0,	"Richmond",		"VA",	"Cellular One",			"804 288 3805",	"GTEDS" },
	{ 73,		0,	"Akron",		"OH",	"Cellular One",			"216 867 3900",	"Commonwealth" },
	{ 73,		0,	"Canton",		"OH",	"Cellular One",			"216 867 3900",	"Commonwealth" },
	{ 74,		0,	"Bristol",		"TX",	"Centel Cellular",		"",		"GTEDS" },
	{ 74,		0,	"Johnson City",		"TN",	"Centel Cellular",		"",		"GTEDS" },
	{ 74,		0,	"Kingsport",		"TN",	"Centel Cellular",		"",		"GTEDS" },
	{ 75,		0,	"Jacksonville",		"FL",	"Cellular One",			"904 731 2355",	"APPEX" },
	{ 76,		0,	"Louisville",		"KY",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 77,		0,	"Syracuse",		"NY",	"Cellular One",			"315 446 0400",	"Cell-T" },
	{ 78,		0,	"Albany",		"NY",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 79,		0,	"Albuquerque",		"NM",	"Metro Mobile",			"505 266 9000",	"APPEX" },
	{ 80,		0,	"Anderson",		"IN",	"GTE Mobile",			"800 669 3001",	"GTEDS" },
	{ 80,		0,	"Bloomington",		"IN",	"GTE Mobile",			"800 669 3001",	"GTEDS" },
	{ 80,		0,	"Ft. Wayne",		"IN",	"GTE Mobile",			"800 669 3001",	"GTEDS" },
	{ 80,		0,	"Indianapolis",		"IN",	"GTE Mobile",			"800 669 3001",	"GTEDS" },
	{ 80,		0,	"Kokomo",		"IN",	"GTE Mobile",			"800 669 3001",	"GTEDS" },
	{ 80,		0,	"Lafayette",		"IN",	"GTE Mobile",			"800 669 3001",	"GTEDS" },
	{ 80,		0,	"Muncie",		"IN",	"GTE Mobile",			"800 669 3001",	"GTEDS" },
	{ 80,		0,	"Terre Haute",		"IN",	"GTE Mobile",			"800 669 3001",	"GTEDS" },
	{ 81,		0,	"Mobile",		"AL",	"Gulf Coast Cellular",		"205 343 9700",	"Cell-T" },
	{ 83,		0,	"Newport News",		"VA",	"Centel Cellular",		"804 473 9600",	"GTEDS" },
	{ 83,		0,	"Norfolk",		"VA",	"Centel Cellular",		"804 473 9600",	"GTEDS" },
	{ 83,		0,	"Virginia Beach",	"VA",	"Centel Cellular",		"804 473 9600",	"GTEDS" },
	{ 84,		0,	"Aiken",		"GA",	"Cellular Phone of",		"404 738 2355",	"GTEDS" },
	{ 84,		0,	"Augusta",		"GA",	"Cellular Phone of",		"404 738 2355",	"GTEDS" },
	{ 85,		0,	"Baton Rouge",		"LA",	"Cellular One",			"504 291 9703",	"GTEDS" },
	{ 86,		0,	"Syracuse",		"NY",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 88,		0,	"SNET",			"CT",	"SNET Cellular",		"203 553 7594",	"GTEDS" },
	{ 88,		30006,	"Springfield",		"MA",	"SNET Cellular",		"203 553 7594",	"GTEDS" },
	{ 89,		0,	"Sharon",		"PA",	"Cellular One",			"412 866 5000",	"APPEX" },
	{ 89,		0,	"Warren",		"OH",	"Cellular One",			"216 565 5000",	"APPEX" },
	{ 89,		0,	"Youngstown",		"OH",	"Cellular One",			"216 565 5000",	"APPEX" },
	{ 91,		0,	"Provo",		"UT",	"Cellular One",			"801 359 2273",	"APPEX" },
	{ 91,		0,	"Salt Lake City",	"UT",	"Cellular One",			"801 359 2273",	"APPEX" },
	{ 92,		0,	"El Paso",		"TX",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 92,		0,	"Las Cruces",		"NM",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 93,		0,	"Knoxville",		"TN",	"Cellular One",			"615 584 2355",	"APPEX" },
	{ 94,		0,	"Salt Lake City",	"UT",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 95,		0,	"Greensboro",		"NC",	"Cellular One",			"919 668 3600",	"GTEDS" },
	{ 96,		0,	"Harrisburg",		"PA",	"Centel Cellular",		"717 545 3300",	"GTEDS" },
	{ 96,		0,	"Lancaster",		"PA",	"Centel Cellular",		"717 545 3300",	"GTEDS" },
	{ 96,		0,	"York",			"PA",	"Centel Cellular",		"717 545 3300",	"GTEDS" },
	{ 97,		30097,	"El Paso",		"TX",	"Metro Mobile",			"915 532 5559",	"APPEX" },
	{ 97,		30097,	"Las Cruces",		"NM",	"Metro Mobile",			"505 526 2233",	"APPEX" },
	{ 98,		0,	"Anniston",		"AL",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 98,		0,	"Birmingham",		"AL",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 98,		0,	"Tuscaloosa",		"AL",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 100,		0,	"Fayetteville",		"NC",	"Centel Cellular",		"919 833 7494",	"GTEDS" },
	{ 103,		0,	"Allentown",		"PA",	"Cellular One",			"215 434 2355",	"GTEDS" },
	{ 103,		30023,	"Reading",		"PA",	"Cellular One",			"215 434 2355",	"GTEDS" },
	{ 103,		0,	"York",			"PA",	"Cellular One",			"717 579 2355",	"GTEDS" },
	{ 104,		0,	"Knoxville",		"TN",	"US Cellular",			"615 584 9500",	"GTEDS" },
	{ 105,		0,	"NE PA",		"PA",	"Cellular One",			"717 434 2355",	"GTEDS" },
	{ 106,		0,	"Baton Rouge",		"LA",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 107,		0,	"Austin",		"TX",	"Cellular One",			"512 388 6777",	"APPEX" },
	{ 110,		0,	"Albuquerque",		"NM",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 111,		0,	"Tulsa",		"OK",	"Cellular One",			"918 584 7722",	"APPEX" },
	{ 112,		0,	"Sacramemto",		"CA",	"Pactel Cellular",		"916 520 0645",	"GTEDS" },
	{ 113,		30043,	"Anniston",		"AL",	"Cellular One",			"205 942 2355",	"APPEX" },
	{ 113,		0,	"Birmingham",		"AL",	"Cellular One",			"205 942 2355",	"APPEX" },
	{ 113,		30025,	"Florence",		"AL",	"Cellular One",			"205 942 2355",	"APPEX" },
	{ 113,		30029,	"Gadsden",		"AL",	"Cellular One",			"205 942 2355",	"APPEX" },
	{ 114,		0,	"Charlotte",		"NC",	"Alltel Mobile",		"704 529 0001",	"GTEDS" },
	{ 116,		0,	"Anderson",		"SC",	"Centel Cellular",		"803 297 8860",	"GTEDS" },
	{ 116,		0,	"Greenville",		"SC",	"Centel Cellular",		"803 297 8860",	"GTEDS" },
	{ 116,		0,	"Spartanburg",		"SC",	"Centel Cellular",		"803 297 8860",	"GTEDS" },
	{ 117,		0,	"Rochester",		"NY",	"Genesse Telephone",		"716 232 6600",	"BANK/IL" },
	{ 118,		0,	"Clarksville",		"TN",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 118,		0,	"Nashville",		"TN",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 119,		0,	"Bridgeport",		"CT",	"Metro Mobile",			"203 852 9292",	"APPEX" },
	{ 119,		0,	"Danbury",		"CT",	"Metro Mobile",			"203 852 9292",	"APPEX" },
	{ 119,		30119,	"Fairfield County",	"CT",	"Metro Mobile",			"203 852 9292",	"APPEX" },
	{ 119,		0,	"Hartford",		"CT",	"Metro Mobile",			"203 688 3737",	"APPEX" },
	{ 119,		0,	"New Bedford",		"MA",	"Metro Mobile",			"401 272 3800",	"APPEX" },
	{ 119,		0,	"New Haven",		"CT",	"Metro Mobile",			"203 852 9292",	"APPEX" },
	{ 119,		0,	"North Bedford",	"CT",	"Metro Mobile",			"203 852 9292",	"APPEX" },
	{ 119,		0,	"Norwalk",		"CT",	"Metro Mobile",			"203 852 9292",	"APPEX" },
	{ 119,		0,	"Norwich",		"CT",	"Metro Mobile",			"203 688 3737",	"APPEX" },
	{ 119,		0,	"Pittsfield",		"MA",	"Metro Mobile",			"203 688 3737",	"APPEX" },
	{ 119,		0,	"Providence",		"RI",	"Metro Mobile",			"401 272 3800",	"APPEX" },
	{ 119,		31119,	"Springfield",		"MA",	"Metro Mobile",			"203 688 3737",	"APPEX" },
	{ 119,		0,	"Waterbury",		"CT",	"Metro Mobile",			"203 852 9292",	"APPEX" },
	{ 120,		0,	"Mobile",		"AL",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 120,		0,	"Pensacola",		"FL",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 122,		0,	"San Antonio",		"TX",	"Southwestern Bell Mobile",	"512 646 9955",	"GTEDS" },
	{ 123,		0,	"Wilmington",		"DE",	"Cellular One",			"302 737 3333",	"APPEX" },
	{ 126,		0,	"Sharon",		"PA",	"Centel Cellular",		"216 758 4502",	"GTEDS" },
	{ 126,		0,	"Warren",		"OH",	"Centel Cellular",		"216 758 4502",	"GTEDS" },
	{ 126,		0,	"Youngstown",		"OH",	"Centel Cellular",		"216 758 4502",	"GTEDS" },
	{ 127,		0,	"Charleston",		"SC",	"Cellular One",			"803 763 6363",	"GTEDS" },
	{ 129,		0,	"Sacramemto",		"CA",	"Cellular One",			"916 923 2400",	"APPEX" },
	{ 129,		0,	"Yuba City",		"CA",	"Cellular One",			"916 923 2400",	"APPEX" },
	{ 130,		0,	"Toledo",		"OH",	"Centel Cellular",		"419 893 1077",	"GTEDS" },
	{ 131,		0,	"Abilene",		"TX",	"Cellular One",			"",		"GTEDS" },
	{ 133,		0,	"Columbus",		"OH",	"Cellular One",			"614 846 7317",	"Commonwealth" },
	{ 136,		0,	"Jacksonville",		"FL",	"Bell South Mobile",		"305 577 4975",	"GTEDS" },
	{ 137,		0,	"Omaha",		"NE",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 139,		0,	"Anderson",		"SC",	"Metro Mobile",			"803 234 7954",	"APPEX" },
	{ 139,		30139,	"Charlotte",		"NC",	"Metro Mobile",			"704 552 5185",	"APPEX" },
	{ 139,		31139,	"Greenville",		"SC",	"Metro Mobile",			"803 234 7954",	"APPEX" },
	{ 140,		0,	"Tuscon",		"AZ",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 142,		0,	"Greensboro",		"NC",	"Centel Cellular",		"919 299 3333",	"GTEDS" },
	{ 142,		0,	"Winston-Salem",	"NC",	"Centel Cellular",		"919 299 3333",	"GTEDS" },
	{ 143,		0,	"Memphis",		"TN",	"Cellular One",			"901 683 2355",	"APPEX" },
	{ 144,		0,	"Burlington",		"NC",	"Centel Cellular",		"919 833 7494",	"GTEDS" },
	{ 144,		0,	"Durham",		"NC",	"Centel Cellular",		"919 833 7494",	"GTEDS" },
	{ 144,		0,	"Raleigh",		"NC",	"Centel Cellular",		"919 833 7494",	"GTEDS" },
	{ 146,		0,	"Oklahoma City",	"OK",	"Southwestern Bell Mobile",	"405 720 2212",	"GTEDS" },
	{ 148,		0,	"Chattanooga",		"TN",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 149,		0,	"Bristol",		"TX",	"Cellular One",			"615 349 4500",	"APPEX" },
	{ 149,		0,	"Johnson City",		"TN",	"Cellular One",			"615 349 4500",	"APPEX" },
	{ 149,		0,	"Kingsport",		"TN",	"Cellular One",			"615 349 4500",	"APPEX" },
	{ 150,		0,	"Des Moines",		"IA",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 151,		0,	"San Antonio",		"TX",	"Cellular One",			"512 349 2600",	"APPEX" },
	{ 152,		0,	"Omaha",		"NE",	"Centel Cellular",		"402 330 6500",	"GTEDS" },
	{ 153,		0,	"Fresno",		"CA",	"Cellular One",			"209 438 8888",	"APPEX" },
	{ 153,		0,	"Visilia",		"CA",	"Cellular One",			"209 738 0999",	"APPEX" },
	{ 156,		0,	"Charleston",		"SC",	"Centel Cellular",		"803 767 1340",	"GTEDS" },
	{ 159,		0,	"Harrisburg",		"PA",	"Cellular One",			"717 579 2355",	"GTEDS" },
	{ 159,		30011,	"Lancaster",		"PA",	"Cellular One",			"717 579 2355",	"GTEDS" },
	{ 159,		30013,	"York",			"PA",	"Cellular One",			"717 579 2355",	"GTEDS" },
	{ 160,		0,	"Jackson",		"MS",	"Alltel Mobile",		"601 354 1212",	"GTEDS" },
	{ 161,		0,	"Chattanooga",		"TN",	"Cellular One",			"615 892 2355",	"APPEX" },
	{ 162,		0,	"Fresno",		"CA",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 162,		0,	"Visilia",		"CA",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 163,		0,	"Dayton",		"OH",	"Cellular One",			"513 477 1999",	"GTEDS" },
	{ 163,		0,	"Springfield",		"OH",	"Cellular One",			"513 434 2355",	"Commonwealth" },
	{ 164,		0,	"Austin",		"TX",	"GTE Mobile",			"800 347 5665",	"GTEDS" },
	{ 165,		0,	"Wichita",		"KS",	"Cellular One",			"316 686 8811",	"APPEX" },
	{ 166,		0,	"Tulsa",		"OK",	"US Cellular",			"918 665 0101",	"GTEDS" },
	{ 167,		0,	"Honolulu",		"HI",	"Honolulu Cellular",		"808 545 4755",	"APPEX" },
	{ 168,		0,	"Newport News",		"VA",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 168,		0,	"Norfolk",		"VA",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 169,		0,	"Oklahoma City",	"OK",	"Cellular One",			"405 843 9113",	"APPEX" },
	{ 170,		0,	"Petersburg",		"VA",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 170,		0,	"Richmond",		"VA",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 171,		0,	"Gulf of Mexico",	"XX",	"Petrocomm",			"800 257 3876",	"GTEDS" },
	{ 173,		0,	"Long Branch",		"NJ",	"Cellular One",			"800 227 9222",	"APPEX" },
	{ 173,		0,	"New Brunswick",	"NJ",	"Cellular One",			"800 227 9222",	"APPEX" },
	{ 175,		0,	"Brandenton",		"FL",	"Cellular One",			"813 221 1662",	"APPEX" },
	{ 175,		0,	"Lakeland",		"FL",	"Cellular One",			"813 221 1662",	"APPEX" },
	{ 175,		0,	"Melbourne",		"FL",	"Cellular One",			"407 258 7100",	"APPEX" },
	{ 175,		0,	"Orlando",		"FL",	"Cellular One",			"407 425 2355",	"APPEX" },
	{ 175,		0,	"Sarasota",		"FL",	"Cellular One",			"813 221 1662",	"APPEX" },
	{ 175,		0,	"Tampa",		"FL",	"Cellular One",			"813 221 1662",	"APPEX" },
	{ 179,		0,	"Clarksville",		"TN",	"Cellular One",			"615 645 2200",	"APPEX" },
	{ 179,		0,	"Mt. Juliet",		"TN",	"Cellular One",			"615 269 2273",	"APPEX" },
	{ 179,		0,	"Nashville",		"TN",	"Cellular One",			"615 269 2273",	"APPEX" },
	{ 180,		0,	"Colorado Springs",	"CO",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 181,		0,	"Augusta",		"GA",	"Cellular One",			"404 868 0086",	"GTEDS" },
	{ 182,		0,	"Columbia",		"SC",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 183,		0,	"Bakersfield",		"CA",	"Bakersfield Cellular",		"805 327 8700",	"Cell-T" },
	{ 184,		0,	"Corpus Christi",	"TX",	"Southwestern Bell Mobile",	"512 854 5678",	"GTEDS" },
	{ 185,		0,	"Beaumont",		"TX",	"Cellular One",			"409 898 8000",	"Cell-T" },
	{ 186,		0,	"Davenport",		"IA",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 186,		0,	"Bettendorf",		"IA",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 186,		0,	"Rock Island",		"IL",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 186,		0,	"Moline",		"IL",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 188,		0,	"Lansing",		"MI",	"Century Cellunet",		"517 393 0311",	"GTEDS" },
	{ 189,		0,	"Columbia",		"SC",	"Metro Mobile",			"803 731 8300",	"APPEX" },
	{ 190,		0,	"Evansville",		"IN",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 190,		0,	"Henderson",		"KY",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 190,		0,	"Owensboro",		"KY",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 191,		0,	"Corpus Christi",	"TX",	"Cellular One",			"512 937 8243",	"APPEX" },
	{ 193,		0,	"Davenport",		"IA",	"Cellular One",			"319 388 8000",	"GTEDS" },
	{ 193,		0,	"Bettendorf",		"IA",	"Cellular One",			"319 388 8000",	"GTEDS" },
	{ 193,		0,	"Rock Island",		"IL",	"Cellular One",			"319 388 8000",	"GTEDS" },
	{ 193,		0,	"Moline",		"IL",	"Cellular One",			"319 388 8000",	"GTEDS" },
	{ 194,		0,	"Gulf of Mexico",	"XX",	"Coastel Cellular",		"800 822 8400",	"GTEDS" },
	{ 195,		0,	"Des Moines",		"IA",	"Cellular One",			"515 223 6611",	"GTEDS" },
	{ 197,		0,	"Evansville",		"IN",	"Cellular One",			"812 464 5111",	"GTEDS" },
	{ 198,		0,	"Huntsville",		"AL",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 199,		0,	"Ft. Wayne",		"IN",	"Cellular One",			"219 484 2500",	"CBIS" },
	{ 203,		0,	"Huntsville",		"AL",	"Cellular One",			"205 830 6633",	"APPEX" },
	{ 204,		0,	"Albany",		"GA",	"Alltel Mobile",		"912 888 8200",	"GTEDS" },
	{ 206,		0,	"Georgetown",		"KY",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 206,		0,	"Lexington",		"KY",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 208,		0,	"Little Rock",		"AR",	"Alltel Mobile",		"501 666 6688",	"GTEDS" },
	{ 211,		0,	"Las Vegas",		"NV",	"Cellular One",			"702 732 2240",	"APPEX" },
	{ 212,		0,	"Alexandria",		"LA",	"US Cellular",			"318 445 2065",	"GTEDS" },
	{ 213,		0,	"Lexington",		"KY",	"Cellular One",			"606 223 3700",	"APPEX" },
	{ 214,		0,	"Peoria",		"IL",	"Centel Cellular",		"309 693 3800",	"GTEDS" },
	{ 215,		0,	"Little Rock",		"AR",	"Cellular One",			"501 225 2355",	"APPEX" },
	{ 215,		0,	"Pine Bluff",		"AR",	"Cellular One",			"501 221 1771",	"APPEX" },
	{ 216,		0,	"Saginaw",		"MI",	"Century Cellunet",		"517 792 1556",	"GTEDS" },
	{ 217,		30039,	"Appleton",		"WI",	"Cellular One",			"414 738 0110",	"APPEX" },
	{ 217,		30041,	"Beloit",		"WI",	"Cellular One",			"608 751 2273",	"APPEX" },
	{ 217,		30031,	"Green Bay",		"WI",	"Cellular One",			"414 496 2273",	"APPEX" },
	{ 217,		30041,	"Janesville",		"WI",	"Cellular One",			"608 751 2273",	"APPEX" },
	{ 217,		30035,	"Kenosha",		"WI",	"Cellular One",			"414 652 2022",	"APPEX" },
	{ 217,		0,	"Madison",		"WI",	"Cellular One",			"608 271 2273",	"APPEX" },
	{ 217,		0,	"Oshkosh",		"WI",	"Cellular One",			"414 738 0110",	"APPEX" },
	{ 217,		30037,	"Racine",		"WI",	"Cellular One",			"414 939 2273",	"APPEX" },
	{ 217,		30033,	"Rockford",		"IL",	"Cellular One",			"815 494 2273",	"APPEX" },
	{ 220,		0,	"Shreveport",		"LA",	"Century Cellunet",		"318 687 8502",	"GTEDS" },
	{ 221,		0,	"Peoria",		"IL",	"US Cellular",			"309 685 1234",	"GTEDS" },
	{ 222,		0,	"Spokane",		"WA",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 224,		0,	"Modesto",		"CA",	"Pactel Cellular",		"916 520 0645",	"GTEDS" },
	{ 224,		0,	"Stockton",		"CA",	"Pactel Cellular",		"916 520 0645",	"GTEDS" },
	{ 226,		0,	"Rome",			"NY",	"Avantage Cellular",		"315 797 2041",	"GTEDS" },
	{ 226,		0,	"Utica",		"NY",	"Avantage Cellular",		"315 797 2041",	"GTEDS" },
	{ 228,		0,	"Bakersfield",		"CA",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 229,		0,	"Longview",		"TX",	"Cellular One",			"318 636 9888",	"APPEX" },
	{ 229,		0,	"Marshall",		"TX",	"Cellular One",			"318 636 9888",	"APPEX" },
	{ 229,		0,	"Shreveport",		"LA",	"Cellular One",			"318 636 9888",	"APPEX" },
	{ 229,		0,	"Texarkana",		"TX",	"Cellular One",			"318 636 9888",	"APPEX" },
	{ 231,		0,	"Spokane",		"WA",	"Cellular One",			"509 838 2273",	"APPEX" },
	{ 233,		0,	"Modesto",		"CA",	"Cellular One",			"209 572 1004",	"APPEX" },
	{ 233,		0,	"Stockton",		"CA",	"Cellular One",			"209 476 1500",	"APPEX" },
	{ 235,		0,	"Rome",			"NY",	"Cellular One",			"315 768 4400",	"Cell-T" },
	{ 235,		0,	"Utica",		"NY",	"Cellular One",			"315 768 4400",	"Cell-T" },
	{ 240,		0,	"Appleton",		"WI",	"Cellulink",			"414 735 9707",	"GTEDS" },
	{ 240,		0,	"Oshkosh",		"WI",	"Cellulink",			"414 735 9797",	"GTEDS" },
	{ 241,		0,	"Albany",		"GA",	"Cellular One",			"912 888 8228",	"APPEX" },
	{ 244,		0,	"Grand Rapids",		"MI",	"Century Cellunet",		"616 940 0985",	"GTEDS" },
	{ 246,		0,	"Asheville",		"NC",	"US Cellular",			"704 258 0000",	"GTEDS" },
	{ 247,		0,	"Altoona",		"PA",	"Cellular One",			"814 946 4535",	"GTEDS" },
	{ 249,		0,	"Amarillo",		"TX",	"Cellular One",			"806 374 1900",	"Cell-T" },
	{ 250,		0,	"Atlantic City",	"NJ",	"Bell Atlantic Mobile",		"800 922 0204",	"GTEDS" },
	{ 250,		0,	"Vineland",		"NJ",	"Bell Atlantic Mobile",		"800 922 0204",	"GTEDS" },
	{ 251,		0,	"Anchorage",		"AK",	"Cellular One",			"907 561 1122",	"APPEX" },
	{ 255,		0,	"Anniston",		"AL",	"Cellular One",			"205 942 2355",	"Cell-T" },
	{ 256,		0,	"Battle Creek",		"MI",	"Century Cellunet",		"616 342 6655",	"GTEDS" },
	{ 258,		0,	"Bellingham",		"WA",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 260,		0,	"Benton Harbor",	"MI",	"Century Cellunet",		"616 342 6655",	"GTEDS" },
	{ 264,		0,	"Gulfport",		"MS",	"Cellular South",		"",		"GTEDS" },
	{ 266,		0,	"Binghamton",		"NY",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 266,		0,	"Elmira",		"NY",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 267,		0,	"Atlantic City",	"NJ",	"Cellular One",			"",		"APPEX" },
	{ 268,		0,	"Bismark",		"ND",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 269,		0,	"Asheville",		"NC",	"Cellular One",			"",		"Cell-T" },
	{ 271,		0,	"Bangor",		"ME",	"US Cellular",			"207 942 0700",	"GTEDS" },
	{ 272,		0,	"Boise",		"ID",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 276,		0,	"Bremerton",		"WA",	"Cellular One",			"800 626 6611",	"GTEDS" },
	{ 277,		0,	"Benton Harbor",	"MI",	"Cellular One",			"616 982 9900",	"Cincin" },
	{ 278,		0,	"Brownsville",		"TX",	"Southwestern Bell Mobile",	"512 541 6200",	"GTEDS" },
	{ 278,		0,	"Harlingen",		"TX",	"Southwestern Bell Mobile",	"512 428 6200",	"GTEDS" },
	{ 278,		0,	"McAllen",		"TX",	"Southwestern Bell Mobile",	"512 380 6200",	"GTEDS" },
	{ 279,		0,	"Billings",		"MT",	"Cellular One",			"406 652 0466",	"GTEDS" },
	{ 281,		0,	"Biloxi",		"MS",	"Cellular One",			"",		"GTEDS" },
	{ 283,		30007,	"Binghamton",		"NY",	"Cellular One",			"607 771 8000",	"APPEX" },
	{ 283,		30009,	"Elmira",		"NY",	"Cellular One",			"607 737 1000",	"APPEX" },
	{ 284,		0,	"Casper",		"WY",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 285,		0,	"Bismark",		"ND",	"Cellular One",			"701 224 1616",	"GTEDS" },
	{ 286,		0,	"Cedar Rapids",		"IA",	"Centel Cellular",		"319 366 5700",	"GTEDS" },
	{ 286,		0,	"Iowa City",		"IA",	"Centel Cellular",		"319 366 5700",	"GTEDS" },
	{ 287,		0,	"Bloomington",		"IN",	"Cellular One",			"502 528 2355",	"APPEX" },
	{ 289,		0,	"Boise",		"ID",	"Cellular One",			"208 345 2355",	"GTEDS" },
	{ 292,		0,	"Charlottesville",	"VA",	"Centel Cellular",		"804 973 9100",	"GTEDS" },
	{ 294,		0,	"Chico",		"CA",	"Pactel Cellular",		"916 920 0645",	"GTEDS" },
	{ 294,		0,	"Redding",		"CA",	"Pactel Cellular",		"916 920 0645",	"GTEDS" },
	{ 297,		0,	"Bryan",		"TX",	"Cellular One",			"409 696 2264",	"APPEX" },
	{ 297,		0,	"College Station",	"TX",	"Cellular One",			"512 338 6777",	"GTEDS" },
	{ 298,		0,	"Columbia",		"MO",	"US Cellular",			"314 474 0400",	"GTEDS" },
	{ 299,		0,	"Burlington",		"NC",	"Gencell",			"800 888 7868",	"GTEDS" },
	{ 300,		0,	"Burlington",		"VT",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 301,		0,	"Casper",		"WY",	"Cellular One",			"307 235 0110",	"GTEDS" },
	{ 302,		0,	"Columbus",		"GA",	"Public Service Cellular",	"912 841 4117",	"GTEDS" },
	{ 303,		0,	"Cedar Rapids",		"IA",	"US Cellular",			"319 365 1000",	"GTEDS" },
	{ 304,		0,	"Cumberland",		"MD",	"Gencell",			"800 888 7868",	"GTEDS" },
	{ 306,		0,	"Danville",		"VA",	"Centel Cellular",		"804 791 3100",	"GTEDS" },
	{ 307,		0,	"Charleston",		"WV",	"Cellular One",			"304 345 2355",	"GTEDS" },
	{ 307,		30047,	"Huntington",		"WV",	"Cellular One",			"304 345 2355",	"GTEDS" },
	{ 308,		0,	"Daytona Beach",	"FL",	"Bell South Mobile",		"305 577 4975",	"GTEDS" },
	{ 308,		0,	"New Smyrna",		"FL",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 312,		0,	"Dothan",		"AL",	"Graceba Cellular",		"205 793 9148",	"GTEDS" },
	{ 314,		0,	"Dubuque",		"IA",	"Centel Cellular",		"319 580 0010",	"GTEDS" },
	{ 316,		0,	"Duluth",		"MN",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 318,		0,	"Eau Claire",		"WI",	"Cellulink",			"715 835 7370",	"GTEDS" },
	{ 319,		0,	"Columbus",		"GA",	"Cellular One",			"404 596 9041",	"APPEX" },
	{ 321,		0,	"Cumberland",		"MD",	"Cellular One",			"814 946 4535",	"GTEDS" },
	{ 323,		0,	"Danville",		"VA",	"Cellular One",			"804 791 3453",	"GTEDS" },
	{ 324,		0,	"Enid",			"OK",	"Enid Cellular",		"405 375 4111",	"GTEDS" },
	{ 325,		0,	"Daytona Beach",	"FL",	"Cellular One",			"904 257 2355",	"APPEX" },
	{ 328,		0,	"Eugene",		"OR",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 329,		0,	"Dothan",		"AL",	"Cellular One",			"205 671 4111",	"Cell-T" },
	{ 330,		0,	"Fargo",		"ND",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 331,		0,	"Dubuque",		"IA",	"US Cellular",			"",		"GTEDS" },
	{ 333,		0,	"Duluth",		"MN",	"Cellular One",			"218 727 4700",	"GTEDS" },
	{ 334,		0,	"Muscle Shoals",	"LA",	"Shoals Cellular",		"205 383 5111",	"GTEDS" },
	{ 336,		0,	"Ft. Collins",		"CO",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 336,		0,	"Loveland",		"CO",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 340,		0,	"Ft. Pierce",		"FL",	"US Cellular",			"305 287 7888",	"GTEDS" },
	{ 342,		0,	"Fayetteville",		"AR",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 342,		0,	"Ft. Smith",		"AR",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 342,		0,	"Rogers",		"AR",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 343,		0,	"Erie",			"PA",	"Cellular One",			"814 881 0100",	"APPEX" },
	{ 344,		0,	"Ft. Walton Beach",	"FL",	"Centel Cellular",		"904 664 2000",	"GTEDS" },
	{ 348,		0,	"Gainesville",		"FL",	"Alltel Cellular",		"904 374 8500",	"GTEDS" },
	{ 348,		0,	"Ocala",		"FL",	"Alltel Mobile",		"904 237 1100",	"GTEDS" },
	{ 349,		0,	"Fayetteville",		"NC",	"Cellular One",			"919 483 1181",	"GTEDS" },
	{ 350,		0,	"Florence",		"SC",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 355,		0,	"Ft. Meyers",		"FL",	"Cellular One",			"813 936 4534",	"APPEX" },
	{ 356,		0,	"Grand Forks",		"ND",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 357,		0,	"Ft. Pierce",		"FL",	"Cellular One",			"407 833 1111",	"APPEX" },
	{ 358,		0,	"Great Falls",		"MT",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 359,		0,	"Ft. Smith",		"AR",	"Cellular One",			"501 783 4600",	"GTEDS" },
	{ 360,		0,	"Greely",		"CO",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 361,		0,	"Ft. Walton Beach",	"FL",	"Cellular One",			"904 433 7300",	"GTEDS" },
	{ 361,		30021,	"Pensacola",		"FL",	"Cellular One",			"904 433 7300",	"GTEDS" },
	{ 362,		0,	"Green Bay",		"WI",	"Cellcom",			"414 494 2355",	"GTEDS" },
	{ 364,		0,	"Hagerstown",		"MD",	"Bell Atlantic Mobile",		"800 922 0204",	"GTEDS" },
	{ 365,		0,	"Gainesville",		"FL",	"Centel Cellular",		"904 374 8100",	"GTEDS" },
	{ 368,		0,	"Hickory",		"NC",	"Centel Cellular",		"704 327 4000",	"GTEDS" },
	{ 370,		0,	"Houma",		"LA",	"Mobiletel",			"504 798 7894",	"GTEDS" },
	{ 370,		0,	"Thibodaux",		"LA",	"Mobiletel",			"504 798 7894",	"GTEDS" },
	{ 370,		0,	"Larose",		"LA",	"Mobiletel",			"504 798 7894",	"GTEDS" },
	{ 370,		0,	"Leeville",		"LA",	"Mobiletel",			"504 798 7894",	"GTEDS" },
	{ 373,		0,	"Great Falls",		"MT",	"Cellular One",			"406 727 2355",	"GTEDS" },
	{ 374,		0,	"Jackson",		"MI",	"Century Cellunet",		"517 393 0311",	"GTEDS" },
	{ 376,		0,	"Jacksonville",		"NC",	"Centel Cellular",		"919 833 7494",	"GTEDS" },
	{ 377,		0,	"Florence",		"SC",	"Cellular One",			"803 664 2898",	"GTEDS" },
	{ 381,		0,	"Hagerstown",		"MD",	"Cellular One",			"301 331 2355",	"GTEDS" },
	{ 384,		0,	"Joplin",		"MO",	"US Cellular",			"417 624 2255",	"GTEDS" },
	{ 385,		0,	"Hickory",		"NC",	"Cellcom",			"704 322 7557",	"APPEX" },
	{ 386,		0,	"Kalamazoo",		"MI",	"Century Cellunet",		"616 342 6655",	"GTEDS" },
	{ 387,		0,	"Houma",		"LA",	"Cellular One",			"504 686 0220",	"GTEDS" },
	{ 387,		0,	"Thibodaux",		"LA",	"Cellular One",			"504 686 0220",	"GTEDS" },
	{ 389,		0,	"Iowa City",		"IA",	"Allcell Cellular",		"319 351 5888",	"CBIS" },
	{ 392,		0,	"Killeen",		"TX",	"Centel Cellular",		"817 771 0077",	"GTEDS" },
	{ 392,		0,	"Temple",		"TX",	"Centel Cellular",		"817 771 0077",	"GTEDS" },
	{ 393,		0,	"Jacksonville",		"NC",	"Cellular One",			"919 455 9300",	"C-Tech" },
	{ 396,		0,	"La Crosse",		"WI",	"Century Cellunet",		"608 788 8000",	"GTEDS" },
	{ 400,		0,	"Lake Charles",		"LA",	"Mercury Cellular",		"318 433 6298",	"Lake Charles" },
	{ 401,		0,	"Joplin",		"MO",	"Cellular One",			"417 862 6611",	"APPEX" },
	{ 402,		0,	"Laredo",		"TX",	"Laredo Cellular",		"512 722 2333",	"GTEDS" },
	{ 403,		0,	"Kalamazoo",		"MI",	"Cellular One",			"616 388 8066",	"CBIS" },
	{ 408,		0,	"Lawton",		"OK",	"US Cellular",			"405 355 3535",	"GTEDS" },
	{ 409,		0,	"Killeen",		"TX",	"Cellular One",			"817 526 6800",	"APPEX" },
	{ 409,		0,	"Temple",		"TX",	"Cellular One",			"817 526 6800",	"APPEX" },
	{ 412,		0,	"Lima",			"OH",	"Centel Cellular",		"419 893 1077",	"GTEDS" },
	{ 413,		0,	"La Crosse",		"WI",	"US Cellular",			"608 781 2600",	"GTEDS" },
	{ 414,		0,	"Lafayette",		"LA",	"Bell South Mobile",		"305 577 4975",	"GTEDS" },
	{ 415,		0,	"Lafayette",		"IN",	"McCaw Cellular",		"502 582 2273",	"GTEDS" },
	{ 416,		0,	"Lincoln",		"NE",	"Lincoln Telephone Cellular",	"402 486 7266",	"GTEDS" },
	{ 417,		0,	"Lake Charles",		"LA",	"Celltelco",			"318 279 6532",	"GTEDS" },
	{ 418,		0,	"Longview",		"TX",	"Centel Cellular",		"214 561 5575",	"GTEDS" },
	{ 418,		0,	"Marshall",		"TX",	"Centel Cellular",		"214 561 5575",	"GTEDS" },
	{ 418,		0,	"Tyler",		"TX",	"Centel Cellular",		"214 561 5575",	"GTEDS" },
	{ 422,		0,	"Abilene",		"TX",	"Southwestern Bell Mobile",	"915 698 7626",	"GTEDS" },
	{ 422,		0,	"Amarillo",		"TX",	"Southwestern Bell Mobile",	"806 353 7447",	"GTEDS" },
	{ 422,		0,	"Lubbock",		"TX",	"Southwestern Bell Mobile",	"806 791 0011",	"GTEDS" },
	{ 422,		0,	"Midland",		"TX",	"Southwestern Bell Mobile",	"915 563 4611",	"GTEDS" },
	{ 422,		0,	"Odessa",		"TX",	"Southwestern Bell Mobile",	"915 563 4611",	"GTEDS" },
	{ 424,		0,	"Lynchburg",		"VA",	"Centel Cellular",		"804 528 3500",	"GTEDS" },
	{ 426,		0,	"Macon",		"GA",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 427,		0,	"Auburn",		"ME",	"US Cellular",			"207 782 8010",	"GTEDS" },
	{ 427,		0,	"Lewiston",		"ME",	"US Cellular",			"207 782 8010",	"GTEDS" },
	{ 428,		0,	"Manchester",		"NH",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 428,		0,	"Nashua",		"NH",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 430,		0,	"Mansfield",		"OH",	"Centel Cellular",		"419 893 1077",	"GTEDS" },
	{ 431,		0,	"Lafayette",		"LA",	"Cellular One",			"318 984 1777",	"APPEX" },
	{ 436,		0,	"Medford",		"OR",	"US Cellular",			"",		"GTEDS" },
	{ 439,		0,	"Lubbock",		"TX",	"Cellular One",			"806 797 2355",	"GTEDS" },
	{ 440,		0,	"Monroe",		"LA",	"Century Cellunet",		"318 325 3600",	"GTEDS" },
	{ 443,		0,	"Macon",		"GA",	"Cellular One",			"912 742 2355",	"GTEDS" },
	{ 443,		0,	"Warner Robins",	"GA",	"Cellular One",			"",		"GTEDS" },
	{ 444,		0,	"Montgomery",		"AL",	"Alltel Mobile",		"800 255 8351",	"GTEDS" },
	{ 445,		0,	"Manchester",		"NH",	"US Cellular",			"603 624 8000",	"GTEDS" },
	{ 447,		0,	"Mansfield",		"OH",	"Cellular One",			"419 564 5000",	"Commonwealth" },
	{ 448,		0,	"Muskegon",		"WI",	"Century Cellunet",		"616 940 0985",	"GTEDS" },
	{ 451,		0,	"Jackson",		"MS",	"Cellular One",			"512 686 2355",	"Cell-T" },
	{ 451,		0,	"McAllen",		"TX",	"Cellular One",			"512 686 2355",	"Cell-T" },
	{ 456,		0,	"Olympia",		"WA",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 462,		0,	"Palm Springs",		"FL",	"Centel Cellular",		"904 785 7000",	"GTEDS" },
	{ 462,		0,	"Panama City",		"FL",	"Centel Cellular",		"904 785 7000",	"GTEDS" },
	{ 465,		0,	"Montgomery",		"AL",	"Montgomery Cellular",		"205 265 2355",	"GTEDS" },
	{ 467,		0,	"Muncie",		"IN",	"Cellular One",			"502 582 2355",	"APPEX" },
	{ 473,		0,	"Ocala",		"FL",	"Cellular One",			"407 425 2355",	"GTEDS" },
	{ 475,		0,	"Odessa",		"TX",	"Cellular One",			"806 797 2355",	"GTEDS" },
	{ 476,		0,	"Melbourne",		"FL",	"Bell South Mobile",		"800 351 2400",	"GTEDS" },
	{ 478,		30018,	"Pine Bluff",		"AK",	"Pine Bluff Cellular",		"501 536 4200",	"GTEDS" },
	{ 479,		0,	"Orange County",	"NY",	"Cellular One",			"914 564 4447",	"GTEDS" },
	{ 480,		0,	"Pittsfield",		"NY",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 481,		0,	"Owensboro",		"KY",	"US Cellular",			"502 685 5111",	"GTEDS" },
	{ 483,		0,	"Palm Springs",		"FL",	"Palmer Comm",			"904 769 2269",	"GTEDS" },
	{ 484,		0,	"Biddeford",		"ME",	"Star Cellular",		"800 346 9172",	"GTEDS" },
	{ 484,		0,	"Dover",		"NH",	"Star Cellular",		"800 346 9172",	"GTEDS" },
	{ 484,		0,	"Portsmouth",		"NH",	"Star Cellular",		"800 346 9172",	"GTEDS" },
	{ 484,		0,	"Saco",			"ME",	"Star Cellular",		"800 346 9172",	"GTEDS" },
	{ 486,		0,	"Orange County",	"NY",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 486,		0,	"Poughkeepsie",		"NY",	"Nynex Mobile Com",		"",		"Nynex" },
	{ 488,		0,	"Provo",		"UT",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 494,		0,	"Rapid City",		"SD",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 498,		0,	"Reno",			"NV",	"Pactel Cellular",		"916 920 0645",	"GTEDS" },
	{ 499,		0,	"Portland",		"ME",	"Cellular One",			"207 772 9805",	"GTEDS" },
	{ 500,		0,	"Richland",		"WA",	"US Cellular",			"",		"GTEDS" },
	{ 501,		0,	"Portsmouth",		"NH",	"Cellular One",			"617 890 1555",	"(Boston)" },
	{ 502,		0,	"Roanke",		"VA",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 503,		0,	"Poughkeepsie",		"NY",	"US Cellular",			"914 297 3444",	"GTEDS" },
	{ 504,		0,	"Rochester",		"MN",	"US Cellular",			"507 388 3000",	"GTEDS" },
	{ 506,		0,	"Rockford",		"IL",	"Contel Cellular",		"800 792 8400",	"GTEDS" },
	{ 510,		0,	"San Angelo",		"TX",	"West Central Cellular",	"915 944 9016",	"GTEDS" },
	{ 511,		0,	"Rapid City",		"SD",	"Cellular One",			"",		"GTEDS" },
	{ 513,		0,	"Redding",		"CA",	"Cellular One",			"916 923 2222",	"APPEX" },
	{ 515,		0,	"Reno",			"NV",	"Cellular One",			"702 322 5511",	"APPEX" },
	{ 519,		0,	"Roanke",		"VA",	"Cellular One",			"703 345 0808",	"Cell-T" },
	{ 520,		0,	"Savannah",		"GA",	"Savannah Cellular",		"912 356 5224",	"GTEDS" },
	{ 521,		0,	"Rochester",		"MN",	"Cellular One",			"507 254 2273",	"APPEX" },
	{ 527,		0,	"Monterey",		"CA",	"Cellular One",			"408 754 8888",	"APPEX" },
	{ 527,		0,	"Salinas",		"CA",	"Cellular One",			"408 647 8888",	"APPEX" },
	{ 530,		0,	"Elkhart",		"IN",	"Centel Cellular",		"219 288 2355",	"GTEDS" },
	{ 530,		0,	"South Bend",		"IN",	"Centel Cellular",		"219 288 2355",	"GTEDS" },
	{ 531,		0,	"Santa Barbara",	"CA",	"Santa Barbara Cellular",	"800 722 7464",	"Cell-T" },
	{ 534,		0,	"St. Cloud",		"MN",	"US Cellular",			"612 252 9000",	"GTEDS" },
	{ 539,		0,	"Savannah",		"GA",	"Cellular One",			"912 352 3456",	"GTEDS" },
	{ 540,		0,	"Sioux Falls",		"SD",	"US West Cellular",		"800 626 6611",	"GTEDS" },
	{ 544,		0,	"Talahassee",		"FL",	"Centel Cellular",		"904 668 2200",	"GTEDS" },
	{ 545,		0,	"Denison",		"TX",	"Metrocell Cellular",		"214 263 4921",	"APPEX" },
	{ 545,		0,	"Sherman",		"TX",	"Metrocell Cellular",		"214 263 4921",	"APPEX" },
	{ 546,		0,	"Springfield",		"MO",	"Alltel Mobile",		"417 882 2020",	"GTEDS" },
	{ 547,		0,	"Sioux City",		"IA",	"Centel Cellular",		"712 274 2494",	"" },
	{ 549,		0,	"South Bend",		"IN",	"Cellular One",			"219 289 0933",	"Micro-T" },
	{ 550,		0,	"Texarkana",		"TX",	"Century Cellunet",		"214 793 0500",	"GTEDS" },
	{ 551,		30045,	"Bloomington",		"IL",	"Cellular One",			"217 744 3000",	"APPEX" },
	{ 551,		30005,	"Champaign",		"IL",	"Cellular One",			"217 744 3000",	"APPEX" },
	{ 551,		30003,	"Decatur",		"IL",	"Cellular One",			"217 744 3000",	"APPEX" },
	{ 551,		30001,	"Springfield",		"IL",	"Cellular One",			"217 744 3000",	"APPEX" },
	{ 551,		30005,	"Urbana",		"IL",	"Cellular One",			"217 744 3000",	"APPEX" },
	{ 555,		0,	"Sioux Falls",		"SD",	"Cellular One",			"605 336 0520",	"Cell-T" },
	{ 557,		0,	"St. Joseph",		"MO",	"Cellular One",			"816 232 6158",	"APPEX" },
	{ 561,		30019,	"State College",	"PA",	"Cellular One",			"717 579 2355",	"GTEDS" },
	{ 562,		0,	"Victoria",		"TX",	"GTE Mobile",			"800 347 5665",	"GTEDS" },
	{ 565,		0,	"Talahassee",		"FL",	"Cellular One",			"904 386 8999",	"APPEX" },
	{ 566,		0,	"Waco",			"TX",	"Centel Cellular",		"817 771 0077",	"GTEDS" },
	{ 567,		0,	"Terre Haute",		"IN",	"Cellular One",			"502 582 2355",	"APPEX" },
	{ 568,		0,	"Waterloo",		"IA",	"Centel Cellular",		"319 236 0400",	"GTEDS" },
	{ 570,		0,	"Wausau",		"WI",	"US Cellular",			"715 842 4200",	"GTEDS" },
	{ 574,		0,	"Wichita Falls",	"TX",	"US Cellular",			"817 696 5500",	"GTEDS" },
	{ 575,		0,	"Trenton",		"NJ",	"Cellular One",			"800 227 9222",	"APPEX" },
	{ 576,		0,	"Williamsport",		"PA",	"US Cellular",			"707 321 9500",	"GTEDS" },
	{ 577,		30027,	"Tuscaloosa",		"AL",	"Cellular One",			"205 942 2355",	"APPEX" },
	{ 578,		0,	"Wilmington",		"NC",	"Centel Cellular",		"919 833 7494",	"GTEDS" },
	{ 579,		0,	"Tyler",		"TX",	"Cellular One",			"214 561 2355",	"GTEDS" },
	{ 580,		0,	"Yakima",		"WA",	"US Cellular",			"509 248 3000",	"GTEDS" },
	{ 581,		0,	"Victoria",		"TX",	"Cellular One",			"512 573 1100",	"Cell-T" },
	{ 583,		0,	"Vineland",		"NJ",	"Cellular One",			"609 272 0900",	"GTEDS" },
	{ 587,		0,	"Waco",			"TX",	"Cellular One",			"817 776 3933",	"APPEX" },
	{ 589,		0,	"Waterloo",		"IA",	"Cellular One",			"319 234 4000",	"GTEDS" },
	{ 591,		0,	"Wausau",		"WI",	"Cellular One",			"715 842 7900",	"GTEDS" },
	{ 595,		0,	"Wichita Falls",	"TX",	"Cellular One",			"817 691 9100",	"Cell-T" },
	{ 599,		0,	"Wilmington",		"NC",	"Cellular One",			"919 799 5000",	"GTEDS" },
	{ 601,		0,	"Yakima",		"WA",	"Cellular One",			"509 454 2663",	"APPEX" },
	{ 607,		0,	"Fayetteville",		"AR",	"Cellular One",			"501 783 4600",	"Cell-T" },
	{ 1161,		0,	"Hawaii",		"HI",	"US Cellular",			"",		"GTEDS" },
	{ 1177,		0,	"Lasalle",		"IL",	"Cellular One",			"815 224 4470",	"GTEDS" },
	{ 1216,		0,	"Batavia",		"IA",	"US Cellular",			"515 662 7000",	"GTEDS" },
	{ 1704,		0,	"Gainesville",		"TX",	"Southwestern Bell Mobile",	"214 988 8484",	"GTEDS" },
	{ 1774,		0,	"North Sound",		"WA",	"US West",			"800 238 7848",	"GTEDS" },
	{ 1784,		0,	"Longview",		"WA",	"US Cellular",			"",		"GTEDS" },
	{ 16384,	0,	"Calgary",		"AB",	"AGT Cellular",			"403 248 2355",	"GTEDS" },
	{ 16384,	0,	"Lethbridge",		"AB",	"AGT Cellular",			"403 248 2355",	"GTEDS" },
	{ 16384,	0,	"Medicine Hat",		"AB",	"AGT Cellular",			"403 248 2355",	"GTEDS" },
	{ 16387,	0,	"Calgary",		"AB",	"Cantel, Inc.",			"403 266 1300",	"GTEDS" },
	{ 16389,	0,	"Chicoutimi",		"QU",	"Cantel, Inc.",			"514 340 9220",	"GTEDS" },
	{ 16390,	0,	"Amherst",		"NS",	"MT&T Cellular",		"902 421 2355",	"GTEDS" },
	{ 16390,	0,	"Bridgewater",		"NS",	"MT&T Cellular",		"902 421 2355",	"GTEDS" },
	{ 16390,	0,	"Chester",		"NS",	"MT&T Cellular",		"902 421 2355",	"GTEDS" },
	{ 16390,	0,	"Halifax",		"NS",	"MT&T Cellular",		"902 421 2355",	"GTEDS" },
	{ 16390,	0,	"Hantsport",		"NS",	"MT&T Cellular",		"902 421 2355",	"GTEDS" },
	{ 16390,	0,	"Kentville",		"NS",	"MT&T Cellular",		"902 421 2355",	"GTEDS" },
	{ 16390,	0,	"Moncton",		"NB",	"MT&T Cellular",		"902 421 2355",	"GTEDS" },
	{ 16390,	0,	"Sydney",		"NS",	"MT&T Cellular",		"902 421 2355",	"GTEDS" },
	{ 16390,	0,	"Truro",		"NS",	"MT&T Cellular",		"902 421 2355",	"GTEDS" },
	{ 16390,	0,	"Windsor",		"NS",	"MT&T Cellular",		"902 421 2355",	"GTEDS" },
	{ 16391,	0,	"Edmonton",		"AB",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16393,	0,	"Halifax",		"NS",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16395,	0,	"Hamilton",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16397,	0,	"Hespler",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16397,	0,	"Kitchener",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16399,	0,	"London",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16401,	0,	"Montreal",		"QU",	"Cantel, Inc.",			"514 340 9220",	"GTEDS" },
	{ 16403,	0,	"Oshawa",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16405,	0,	"Ottawa",		"ON",	"Cantel, Inc.",			"514 340 9220",	"GTEDS" },
	{ 16407,	0,	"Quebec City",		"QU",	"Cantel, Inc.",			"514 340 9220",	"GTEDS" },
	{ 16408,	0,	"Bathurst",		"NB",	"MT&T Cellular",		"",		"GTEDS" },
	{ 16408,	0,	"Newcastle",		"NB",	"MT&T Cellular",		"",		"GTEDS" },
	{ 16409,	0,	"Regina",		"SK",	"Cantel, Inc.",			"403 266 1300",	"GTEDS" },
	{ 16411,	0,	"St. John",		"NB",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16413,	0,	"Saskatoon",		"SK",	"Cantel, Inc.",			"403 266 1300",	"GTEDS" },
	{ 16415,	0,	"St. Catharines",	"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16419,	0,	"Sudbury",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16423,	0,	"Newmarket",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16423,	0,	"Toronto",		"ON",	"Cantel, Inc.",			"416",	":GTEDS" },
	{ 16425,	0,	"Abbotsford",		"BC",	"Cantel, Inc.",			"604 687 1440",	"GTEDS" },
	{ 16427,	0,	"Vancouver",		"BC",	"Cantel, Inc.",			"604 687 1440",	"GTEDS" },
	{ 16428,	0,	"Winnipeg",		"MB",	"MTS Cellular",			"204 941 7910",	"GTEDS" },
	{ 16431,	0,	"Windsor",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16431,	0,	"Winnipeg",		"MB",	"Cantel, Inc.",			"403 266 1300",	"GTEDS" },
	{ 16433,	0,	"Trois Rivieres",	"QU",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16435,	0,	"Barrie",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16437,	0,	"Brantford",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16439,	0,	"Sherbrooke",		"QU",	"Cantel, Inc.",			"514 340 9220",	"GTEDS" },
	{ 16441,	0,	"Peterborough",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16443,	0,	"Kingston",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16445,	0,	"Red Deer",		"AB",	"Cantel, Inc.",			"403 266 1300",	"GTEDS" },
	{ 16447,	0,	"Nanaimo",		"BC",	"Cantel, Inc.",			"604 687 1440",	"GTEDS" },
	{ 16449,	0,	"Belleville",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16451,	0,	"Cornwall",		"ON",	"Cantel, Inc.",			"514 340 9220",	"GTEDS" },
	{ 16453,	0,	"Portage",		"AB",	"Cantel, Inc.",			"403 266 1300",	"GTEDS" },
	{ 16455,	0,	"Selkirk",		"AB",	"Cantel, Inc.",			"403 266 1300",	"GTEDS" },
	{ 16457,	0,	"Chatham",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16459,	0,	"Sarnia",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16461,	0,	"Chiliwack",		"BC",	"Cantel, Inc.",			"604 687 1440",	"GTEDS" },
	{ 16463,	0,	"Whistler",		"BC",	"Cantel, Inc.",			"604 687 1440",	"GTEDS" },
	{ 16465,	0,	"Steinbach",		"MB",	"Cantel, Inc.",			"403 266 1300",	"GTEDS" },
	{ 16467,	0,	"Moncton",		"NB",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16469,	0,	"Fredericton",		"NB",	"Cantel, Inc.",			"",		"GTEDS" },
	{ 16471,	0,	"Brandon",		"MB",	"Cantel, Inc.",			"403 266 1300",	"GTEDS" },
	{ 16473,	0,	"Lethbridge",		"AB",	"Cantel, Inc.",			"403 266 1300",	"GTEDS" },
	{ 16475,	0,	"Truro",		"NS",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16477,	0,	"Collingwood",		"ON",	"Cantel, Inc.",			"",		"GTEDS" },
	{ 16481,	0,	"St. Marie",		"QU",	"Cantel, Inc.",			"514 340 9220",	"GTEDS" },
	{ 16485,	0,	"Coburg",		"ON",	"Cantel, Inc.",			"415 440 1300",	"GTEDS" },
	{ 16485,	0,	"Newtonville",		"ON",	"Cantel, Inc.",			"415 440 1300",	"GTEDS" },
	{ 16487,	0,	"Brockville",		"QU",	"Cantel, Inc.",			"514 340 9220",	"GTEDS" },
	{ 16491,	0,	"Ponoka",		"AB",	"Cantel, Inc.",			"604 687 1440",	"GTEDS" },
	{ 16493,	0,	"Bowden",		"QU",	"Cantel, Inc.",			"604 687 1440",	"GTEDS" },
	{ 16509,	0,	"Orillia",		"ON",	"Cantel, Inc.",			"416 440 1300",	"GTEDS" },
	{ 16521,	0,	"Kelowna",		"BC",	"Cantel, Inc.",			"",		"GTEDS" },
	{ 16525,	0,	"Penticton",		"BC",	"Cantel, Inc.",			"",		"GTEDS" },
	{ 16527,	0,	"Kamloops",		"BC",	"Cantel, Inc.",			"",		"GTEDS" },
	{ 16531,	0,	"Canmore",		"ON",	"Cantel, Inc.",			"",		"GTEDS" },
	{ 32752,	0,	"Nassau",		"Bahamas","Batelco",			"809 322 4848",	"GTEDS" },
	{ 0, 0, NULL, NULL, NULL, NULL, NULL }
};

void list_stations(void)
{
	int i;

	for (i = 0; amps_stations[i].city; i++) {
		printf("SID: %d  City: %s, %s (%s)\n", amps_stations[i].sid, amps_stations[i].city, amps_stations[i].state, amps_stations[i].company);
	}
}

void sid_stations(int sid)
{
	int i, first = 1;

	for (i = 0; amps_stations[i].city; i++) {
		if (sid == amps_stations[i].sid) {
			if (first)
				printf("Selected System ID (SID) %d belongs to:\n", amps_stations[i].sid);
			first = 0;
			printf("\t%s, %s (%s)\n",  amps_stations[i].city, amps_stations[i].state, amps_stations[i].company);
		}
	}
}

