"computeTestPartialPearson" <-
function(inData, outData, selection, testLevel = 0.95) {

  testResult <- numeric(length(selection))
  pvalues <- numeric(length(selection))

  # Direct application of cor.test ('stats' package) along the selection. 
  for (i in 1:length(selection)) {

    partialTest <- cor.test(inData[,selection[i]], outData, method = "pearson")
    testResult[i] <- ifelse(partialTest$p.value > 1 - testLevel, 1, 0)
    pvalues[i] <- as.numeric(partialTest$p.value)
  }   

  return(list(test = "Pearson",
              testResult = testResult,
              threshold = 1 - testLevel,
              pValue = pvalues))

}

