//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir Simulation
 *
 *  Copyright 2005-2024 Airbus-EDF-IMACS-ONERA-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTSIMULATION_HXX
#define OPENTURNS_OTSIMULATION_HXX

#include "openturns/DirectionalSampling.hxx"
#include "openturns/RootStrategy.hxx"
#include "openturns/RootStrategyImplementation.hxx"
#include "openturns/RiskyAndFast.hxx"
#include "openturns/MediumSafe.hxx"
#include "openturns/SafeAndSlow.hxx"
#include "openturns/SamplingStrategy.hxx"
#include "openturns/SamplingStrategyImplementation.hxx"
#include "openturns/RandomDirection.hxx"
#include "openturns/OrthogonalDirection.hxx"
#include "openturns/PostAnalyticalControlledImportanceSampling.hxx"
#include "openturns/PostAnalyticalImportanceSampling.hxx"
#include "openturns/PostAnalyticalSimulation.hxx"
#include "openturns/EventSimulation.hxx"
#include "openturns/SimulationResult.hxx"
#include "openturns/ProbabilitySimulationResult.hxx"
#include "openturns/SimulationSensitivityAnalysis.hxx"
#include "openturns/Wilks.hxx"
#include "openturns/SubsetSamplingResult.hxx"
#include "openturns/SubsetSampling.hxx"
#include "openturns/QuadrantSampling.hxx"
#include "openturns/AdaptiveDirectionalStratification.hxx"
#include "openturns/ProbabilitySimulationAlgorithm.hxx"
#include "openturns/ExpectationSimulationAlgorithm.hxx"
#include "openturns/SobolSimulationAlgorithm.hxx"
#include "openturns/NAISResult.hxx"
#include "openturns/NAIS.hxx"
#include "openturns/CrossEntropyResult.hxx"
#include "openturns/CrossEntropyImportanceSampling.hxx"
#include "openturns/StandardSpaceCrossEntropyImportanceSampling.hxx"
#include "openturns/PhysicalSpaceCrossEntropyImportanceSampling.hxx"

#endif /* OPENTURNS_OTSIMULATION_HXX */
