// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and / or modify it
// under the terms of the GNU Lesser General Public version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

//   Table de la matrice de passage de canonique a Legendre.
static const Standard_Real TransMatrix_C0[2][496] = {
 {0.10000000000000000000000000000000e+01,	
  0.96824583655185422129481634994560e+00,
 -0.83852549156242113615344012577423e+00,
  0.81639690485082070771553545928344e+00,
 -0.80850882706220344641712287159348e+00,
  0.80478467632289111882626187416566e+00,
 -0.80272902883712444496850976194931e+00,
  0.80147378330165133712905411455502e+00,
 -0.80065083023186782478844320271789e+00,
  0.80008198409950109256256409343704e+00,
 -0.79967233685330353466915284938555e+00,
  0.79936752558366180262906382920004e+00,
 -0.79913457569511231454718784458679e+00,
  0.79895253633520360691152734033876e+00,
 -0.79880757533676195074075785592221e+00,
  0.79869026062855611518558207175214e+00,
 -0.79859398068599324345565133968632e+00,
  0.79851398930194063832991014358169e+00,
 -0.79844680768416537075236956856114e+00,
  0.79838983884190498922276512808722e+00,
 -0.79834111226473515893026843847236e+00,
  0.79829911089091865590346266057580e+00,
 -0.79826265138502442110147857325014e+00,
  0.79823079974362042697192261162820e+00,
 -0.79820281079570798201513912486796e+00,
  0.79817808416585375754375471847499e+00,
 -0.79815613177145018225492521451763e+00,
  0.79813655352574241229032158550670e+00,
 -0.79811901896123873243374104815907e+00,
  0.79810325318014815004577037743940e+00,
 -0.79808902600524528424788699954697e+00,
 -0.96824583655185422129481634994560e+00,
  0.67082039324993690892275210061938e+01,
 -0.15511541192165593446595173726385e+02,
  0.27489300120114917178182177634178e+02,
 -0.42653587845113229297791879330780e+02,
  0.61007406191621457817606741908148e+02,
 -0.82551799680070087724292573799167e+02,
  0.10728721125107028852165138916420e+03,
 -0.13521385531281568464307333179086e+03,
  0.16633184606548713521118379267219e+03,
 -0.20064124892149911245989502112921e+03,
  0.23814210355714346973506197768686e+03,
 -0.27883443518098605881212304177823e+03,
  0.32271826043605182809926617379257e+03,
 -0.36979359067102148133092449922124e+03,
  0.42006043384083244605767260467500e+03,
 -0.47351879565605079852963671514394e+03,
  0.53016868030228580617957339352460e+03,
 -0.59001009090416778703562342965646e+03,
  0.65304302983255336000495958267039e+03,
 -0.71926749891271770896901985717879e+03,
  0.78868349956840412804826083037114e+03,
 -0.86129103292336644070270449794683e+03,
  0.93709009987416117088577333259498e+03,
 -0.10160807011431318333531997566187e+04,
  0.10982628373175154507827770951763e+04,
 -0.11836365088786759974265469113064e+04,
  0.12722017162242145394993832307656e+04,
 -0.13639584596848731884282215750439e+04,
  0.14589067395375883796051374351719e+04,
 -0.58696784409369479530740808804196e+01,
  0.41636242147391856093492308423455e+02,
 -0.14229755356294780656941362540045e+03,
  0.35571482693471787452120774838122e+03,
 -0.74252435167434011159587152980311e+03,
  0.13761304859289353458505859146910e+04,
 -0.23427043292584452553309848111525e+04,
  0.37411833576492671088225497009116e+04,
 -0.56832712980164282208936693005831e+04,
  0.82934380779304912022765372279504e+04,
 -0.11708919803084785632745396298886e+05,
  0.16079718746282307792701399251658e+05,
 -0.21568603341667909431951202867756e+05,
  0.28351108181531856420742606800986e+05,
 -0.36615534014452790212441613924618e+05,
  0.46562947744174762502293720292536e+05,
 -0.58407182428904381035906586309816e+05,
  0.72374837280857529178032881626235e+05,
 -0.88705277665959252979059986735541e+05,
  0.10765063510364038074858193977865e+06,
 -0.12947580726669680602939652014545e+06,
  0.15445845798119029623949399727267e+06,
 -0.18288901722637738708720076712450e+06,
  0.21507068113465762667767979640252e+06,
 -0.25131941199153537613751957692124e+06,
  0.29196393823559125461268566822945e+06,
 -0.33734575445846054247016393127168e+06,
  0.38781912140481666995914101642762e+06,
 -0.44375106597235846721165738582711e+06,
 -0.26941097860077083354612670156353e+02,
  0.23123352453979018567529714127574e+03,
 -0.10252956776353632853846576276870e+04,
  0.32751344376554677354715198287532e+04,
 -0.85429090562123016024585878070420e+04,
  0.19380553996592592566829056164989e+05,
 -0.39674465427526060177992428265356e+05,
  0.75041252090314003693353303386340e+05,
 -0.13327455070293601404333066692338e+06,
  0.22484290594842541059636767757725e+06,
 -0.36343871506366610956241231795606e+06,
  0.56657823703485851642140473204850e+06,
 -0.85625266640231678296312215724539e+06,
  0.12596302716758240028350334146006e+07,
 -0.18098095983611480024368681029439e+07,
  0.25466237365980302933843016725778e+07,
 -0.35174956534098179615033375671236e+07,
  0.47783445895648344656220107560631e+07,
 -0.63945435210495455267044756383708e+07,
  0.84419276851535540223304700680638e+07,
 -0.11007854171166444928377308969976e+08,
  0.14192312575686493686695166696620e+08,
 -0.18109086722541246695057918277893e+08,
  0.22886967447319979686123529541250e+08,
 -0.28671016446518037889666401187677e+08,
  0.35623881191293060651956080068888e+08,
 -0.43927160905833092376444076217476e+08,
  0.53782823610336581103804117947518e+08,
 -0.11561676226989509283764857063787e+03,
  0.11941854904236957216069117267084e+04,
 -0.64820369078597798931207163277407e+04,
  0.25110975104624038043590394463123e+05,
 -0.78374108469737077632891128227649e+05,
  0.20996551508723207172119369504068e+06,
 -0.50156248639776050997983935866311e+06,
  0.10953333519310125850524747119614e+07,
 -0.22251581464779301932051605875685e+07,
  0.42585536395503485446552225951808e+07,
 -0.77514985054331580777903434903386e+07,
  0.13518558670585223607024680258508e+08,
 -0.22720917133594296668543254613116e+08,
  0.36975116811339345479327762846817e+08,
 -0.58485529223461582078746291821361e+08,
  0.90203766085693174313071012362738e+08,
 -0.13601845514104026953676610716061e+09,
  0.20097900581626456216456625355047e+09,
 -0.29155719454955522497026486051926e+09,
  0.41595060389373060241321540452727e+09,
 -0.58443215375775663745724199268645e+09,
  0.80975016740781657355478249472152e+09,
 -0.11075836191076140419272020130894e+10,
  0.14970574145360392116750354956860e+10,
 -0.20013227593787752470037590265116e+10,
  0.26482078757488698821925513707422e+10,
 -0.34709445303497444910122212787199e+10,
 -0.48275583655425997256449622994594e+03,
  0.58770467964595337697627828038182e+04,
 -0.37709608662270462629034372441185e+05,
  0.17144336227754985732194934299798e+06,
 -0.62216775329529503460942671597945e+06,
  0.19201732152521524474475698219446e+07,
 -0.52388229460929001925081219080666e+07,
  0.12964848378565474550364314656335e+08,
 -0.29636056960952425586274100101156e+08,
  0.63414269180126539450465724634529e+08,
 -0.12831291318769184157418830357693e+09,
  0.24745991696578239622898545716583e+09,
 -0.45774816672572917137695886304569e+09,
  0.81630866320405952858845888159177e+09,
 -0.14093364217399547020801185865151e+10,
  0.23639069445201481326389695865154e+10,
 -0.38635425611950919485843400385508e+10,
  0.61684239042378404826702879247944e+10,
 -0.96412930749682887349665240689634e+10,
  0.14780262482133950395237145098146e+11,
 -0.22259927714358154684074103680862e+11,
  0.32982384957671174120945748239129e+11,
 -0.48139974206763156640829932882604e+11,
  0.69291809660573615520946269703806e+11,
 -0.98456419056394419607176388748408e+11,
  0.13822309509884551460805199966731e+12,
 -0.19878246517436658338903530071738e+04,
  0.27966456184937424437800611140592e+05,
 -0.20706795703652125624599076491964e+06,
  0.10799230229416922283395695792890e+07,
 -0.44644027254612544403155998360211e+07,
  0.15587115185288752424622930615359e+08,
 -0.47795177721608144423913586319279e+08,
  0.13213367545053808731134312185863e+09,
 -0.33554533754195055275339405121700e+09,
  0.79359165389110908210369609135340e+09,
 -0.17666153917750256780980467579136e+10,
  0.37324081286867147819967414986802e+10,
 -0.75339995372404601641439541373517e+10,
  0.14608479220943102159392588492407e+11,
 -0.27332176590849120159872799865636e+11,
  0.49529490750908636760799019889507e+11,
 -0.87207666523689061109588611426558e+11,
  0.14959839850701368410687935092797e+12,
 -0.25060991759235917107857499556168e+12,
  0.41082084342970303301595907770623e+12,
 -0.66018030943683085185747090688930e+12,
  0.10416184927517600977573473274226e+13,
 -0.16158185929928465299033271366492e+13,
  0.24674564614184542151608989854876e+13,
 -0.37132785275492801645392390969566e+13,
 -0.81192937311108651593614677504944e+04,
  0.12984871180347610857821966080923e+06,
 -0.10897751094043574694855245992950e+07,
  0.64104244263033397091711177132611e+07,
 -0.29726464485190008214849029820226e+08,
  0.11578950793270544512221922399968e+09,
 -0.39406237722859588870727992979079e+09,
  0.12032988598146325171757793699246e+10,
 -0.33600443076727192553461127209701e+10,
  0.87021496745370866203270767336530e+10,
 -0.21132255602332183402858183724748e+11,
  0.48532355522887029201345104704126e+11,
 -0.10614120793159071110401704948716e+12,
  0.22231072345923319021124262464971e+12,
 -0.44802317132232171428927888361591e+12,
  0.87220600985116426843724733245822e+12,
 -0.16457853769118160316704158990375e+13,
  0.30186471358527703802636602756435e+13,
 -0.53953169675126557471383319255053e+13,
  0.94173388629140062950595096945933e+13,
 -0.16083157416596462471356866763087e+14,
  0.26919952071720564943709918129174e+14,
 -0.44226518594255714347211989143467e+14,
  0.71412165210916907533113966359170e+14,
 -0.32994344802522617753482044959723e+05,
  0.59174094316383104632892338910761e+06,
 -0.55518854406377138552642715909494e+07,
  0.36355839200924851051047579148335e+08,
 -0.18684216052777469553812647509039e+09,
  0.80303364261643390673508751271165e+09,
 -0.30028752796266945406306279811958e+10,
  0.10035431668370627132929520698773e+11,
 -0.30555719324133334498767136359722e+11,
  0.85993003972140902943558452446190e+11,
 -0.22619278427173766868955128361911e+12,
  0.56100081358615860717632120034994e+12,
 -0.13213145418504424289168210836035e+13,
  0.29726513804311369491800067029838e+13,
 -0.64193379305977210361187058410661e+13,
  0.13360630679297235676034810231924e+14,
 -0.26895054903170165014517792455884e+14,
  0.52520907696637373084900720831530e+14,
 -0.99755785504220062796541113488135e+14,
  0.18470484012051144715150729344814e+15,
 -0.33405754683690409019749763448349e+15,
  0.59120065862171026283907906347805e+15,
 -0.10254193133706894328526228333003e+16,
 -0.13361892264989733304201495883075e+06,
  0.26575428994198719242502112648814e+07,
 -0.27566912077147038957793585082691e+08,
  0.19886486790224901314662784727931e+09,
 -0.11217089775265551761330326889589e+10,
  0.52720163280323867953153106638189e+10,
 -0.21483335334084305545366087347681e+11,
  0.77980742025131947418728629251373e+11,
 -0.25708789270427617097633796404897e+12,
  0.78113272830855289024373547356610e+12,
 -0.22122170013503679707733201519141e+13,
  0.58923590836163423271391629124817e+13,
 -0.14868513928714353334797051454575e+14,
  0.35757239764155635137293180162653e+14,
 -0.82366572398219329465927939466234e+14,
  0.18250085936999038274895237666481e+15,
 -0.39036786914686284739539791789874e+15,
  0.80859315122363398918782224148973e+15,
 -0.16263241572730108749370714064963e+16,
  0.31837035699785165687276034174478e+16,
 -0.60787081427432659421359760378955e+16,
  0.11340817945147421267574801868743e+17,
 -0.53981340144466148461332416317903e+06,
  0.11796045288823545942387552891151e+08,
 -0.13406119874261355645494956781875e+09,
  0.10562892505299851018493138550367e+10,
 -0.64870401670620972083973389896230e+10,
  0.33093898054377130513366833953811e+11,
 -0.14594711507440484474789421348310e+12,
  0.57172332610875244444067495790513e+12,
 -0.20287752804680470899385907438453e+13,
  0.66182923567369929748031694171371e+13,
 -0.20076865968064082794662379473425e+14,
  0.57153453398204546916836651739361e+14,
 -0.15381537787436734471583182324354e+15,
  0.39375030606627095505593942087460e+15,
 -0.96366625033573051027214749641686e+15,
  0.22646337983518042637996555005948e+16,
 -0.51291404246500224979941740052603e+16,
  0.11231981724220997611891837363109e+17,
 -0.23847513432918926389328436244761e+17,
  0.49211325342255878914894085986649e+17,
 -0.98913950033429839398341289948418e+17,
 -0.21769525640318131996680891601695e+07,
  0.51858552760361644751126131521724e+08,
 -0.64085222587770862125381332210276e+09,
  0.54756363539214687694055729954802e+10,
 -0.36368035349119242652293247702634e+11,
  0.20012320953397019769143199801563e+12,
 -0.94955787205888449467972971269461e+12,
  0.39924561669103814390235368648934e+13,
 -0.15171276189192858709086869779223e+14,
  0.52884290129514254452303858658408e+14,
 -0.17107200150787612401041819994013e+15,
  0.51830572102585049294524773428750e+15,
 -0.14818616393999028930605077562257e+16,
  0.40229049412411071411832870163411e+16,
 -0.10424205339823643748145534863115e+17,
  0.25896160121148693432865866989663e+17,
 -0.61910069913368297417082994339321e+17,
  0.14290350054599387107919908115198e+18,
 -0.31938889789107175346530632751031e+18,
  0.69291574726726139629323791492028e+18,
 -0.87674531645215730334637704371261e+07,
  0.22616570228709143294017556187068e+09,
 -0.30195976972117882293240311678540e+10,
  0.27808750947589362989892697306038e+11,
 -0.19860999055828800337996559349377e+12,
  0.11725191616169858732961970923086e+13,
 -0.59556653548452830870878044017184e+13,
  0.26749958948085225508832009978991e+14,
 -0.10837043892672772279642587054601e+15,
  0.40197234722369599538301517764641e+15,
 -0.13811669497791129613143249283002e+16,
  0.44371891015458848667562512700582e+16,
 -0.13430094229277824638910733778312e+17,
  0.38538163073788139341425580127286e+17,
 -0.10539931465237630731802010359755e+18,
  0.27597440776027790244502899993821e+18,
 -0.69447659139158995968666736490557e+18,
  0.16852086929539455516168705589351e+19,
 -0.39547803021063610740703791571351e+19,
 -0.35273549897986737247550316989005e+08,
  0.97969710224479121930867479211565e+09,
 -0.14054260421340558229010134515003e+11,
  0.13877964028900739752660159932188e+12,
 -0.10605588245896223293123166532640e+13,
  0.66861013789549921414783000386221e+13,
 -0.36196387965735405562996954088727e+14,
  0.17295704222677751135751184163523e+15,
 -0.74411635023944824340385157752667e+15,
  0.29262526144770657026527675403987e+16,
 -0.10642730940002152872099984033828e+17,
  0.36136423414995941616556285278502e+17,
 -0.11542965390686183702024112608868e+18,
  0.34908502110213331066581594843511e+18,
 -0.10048676737595132305707309291385e+19,
  0.27658356039074103009858207491107e+19,
 -0.73077244992061628508748645193339e+19,
  0.18597270989777339343663233527884e+20,
 -0.14179826479858820279467661464832e+09,
  0.42192762873193280173363396925940e+10,
 -0.64725216412535860163073850312960e+11,
  0.68218722284675179706205253970936e+12,
 -0.55543394267881314925301502925012e+13,
  0.37241016767055330687470170656945e+14,
 -0.21405430750820323403943950845536e+15,
  0.10841680004755675660894834842971e+16,
 -0.49364973837683397950649409342104e+16,
  0.20514458352191015048658533882402e+17,
 -0.78732014300305167483414901742050e+17,
  0.28170955655910040359516902883346e+18,
 -0.94703697345702374802882760736173e+18,
  0.30104705976715780197564529755067e+19,
 -0.90980919228320191641769956418022e+19,
  0.26261134585814770894934231235792e+20,
 -0.72684841382132876632877579721004e+20,
 -0.56965057426050424032687423767288e+09,
  0.18080208038436913655483746435008e+11,
 -0.29535308881870863244449018002742e+12,
  0.33094280532327511389932102921054e+13,
 -0.28599415062343260433638286011589e+14,
  0.20320620519456910984830803911358e+15,
 -0.12358617962938318059572313527758e+16,
  0.66136112343438765567548653078016e+16,
 -0.31772319080684875944798289287364e+17,
  0.13912191929767969460273734950382e+18,
 -0.56186890429273663164308150713909e+18,
  0.21130027700194229169812848795425e+19,
 -0.74571008961280943431654471345337e+19,
  0.24857286860594623787840720235638e+20,
 -0.78689781174250677137940183079085e+20,
  0.23767434068236185768736118532522e+21,
 -0.22872552337781637756937269586456e+10,
  0.77137070263493023153769041807762e+11,
 -0.13369016741975502404343577562771e+13,
  0.15869424983722320263078111133489e+14,
 -0.14507172274685780621928769615566e+15,
  0.10888454799045381293395776674363e+16,
 -0.69857102031108297929684549448899e+16,
  0.39384081659620016032184282566653e+17,
 -0.19907874374757906307132965343836e+18,
  0.91609416522388914178845017786120e+18,
 -0.38836880175997427249336936230198e+19,
  0.15314087897843370333432799274203e+20,
 -0.56608238849642684907524364228382e+20,
  0.19744115646059893915823141103566e+21,
 -0.65335685943828431503848559174297e+21,
 -0.91797223937016563966297083501244e+10,
  0.32782608910635453187391528779575e+12,
 -0.60082931138072702401192607239824e+13,
  0.75318053401460474001739908159100e+14,
 -0.72616661808991112495632670128545e+15,
  0.57409275057371574327084490349016e+16,
 -0.38748436800322610452345600253444e+17,
  0.22954990406913925547815633424772e+18,
 -0.12178632078749822957864886186633e+19,
  0.58756322838196837119083302144836e+19,
 -0.26088073545741110896745830559864e+20,
  0.10762974613837584652644695578732e+21,
 -0.41585500805459290024467376947588e+21,
  0.15146602317643574421286817000540e+22,
 -0.36828563807834132536468331382117e+11,
  0.13884591953574960728665173802104e+13,
 -0.26830858718077522545149076697898e+14,
  0.35419772595440390736266399438227e+15,
 -0.35919401474180331994546138836122e+16,
  0.29834551625627028350741741333085e+17,
 -0.21132527654234244360131496737225e+18,
  0.13124005345136795516237959543586e+19,
 -0.72917046307938281473229717884972e+19,
  0.36803781218561029638620754759505e+20,
 -0.17079274269845556866638061528692e+21,
  0.73577890086837844263411484726246e+21,
 -0.29659084233877688560167973696597e+22,
 -0.14770842503803149711345929576706e+12,
  0.58626053315612387963161033772435e+13,
 -0.11913402079616370281407730613787e+15,
  0.16519897572708719210353005585115e+16,
 -0.17578438950491783111990048156322e+17,
  0.15303955978094470741600057493387e+18,
 -0.11350807525763489778769060508404e+19,
  0.73740490024101260287483076828171e+19,
 -0.42817485837241111295200384549511e+20,
  0.22565236587290751327959434722419e+21,
 -0.10924194524147453392332081915426e+22,
  0.49053608356632638299144496447021e+22,
 -0.59225808336743972494753474015631e+12,
  0.24686009947277994124240242866327e+14,
 -0.52625804929221174439897159437067e+15,
  0.76477034714175845252326347130423e+16,
 -0.85198987045819968249167279650898e+17,
  0.77583732926701945092556513014190e+18,
 -0.60131517499504065012039371679211e+19,
  0.40784844571351136685311811724956e+20,
 -0.24703218665448693057906810807751e+21,
  0.13568975721761063941659617771129e+22,
 -0.68409948278436618706291035921147e+22,
 -0.23742048964357746376731635665181e+13,
  0.10368818048038736441999909792625e+15,
 -0.23138394129600983977124433073801e+16,
  0.35165435567005390536370486602732e+17,
 -0.40933137654524389516098494029310e+18,
  0.38912000261862476469721139005112e+19,
 -0.31456890415864464357082002477371e+20,
  0.22235839686574797011681621164717e+21,
 -0.14024955914163746527529637392586e+22,
  0.80158940427243312628110003276223e+22,
 -0.95156874491494733170252336704472e+13,
  0.43453552659864921633477166442777e+15,
 -0.10130266811605421015058101966287e+17,
  0.16070219760336056833730288428188e+18,
 -0.19509017614292417977236963491560e+19,
  0.19326147392273352443332253806506e+20,
 -0.16268081329461385117283096816927e+21,
  0.11964677370835202867869544796494e+22,
 -0.78461120453028072834622607283337e+22,
 -0.38131854310971146274314581931463e+14,
  0.18172952650716336260433518301789e+16,
 -0.44179434844253789557733899043621e+17,
  0.73025606380492002472124072194731e+18,
 -0.92301115491142894676253279879063e+19,
  0.95128049160584933516758882664348e+20,
 -0.83248141212219479644807346322757e+21,
  0.63607281900606298492868339565660e+22,
 -0.15278146033788070307444108306814e+15,
  0.75858712262870721444695435519172e+16,
 -0.19198616686073138228996103655278e+18,
  0.33012254863350746688321214697479e+19,
 -0.43375648222261222087754813794138e+20,
  0.46439122668748656437857117047308e+21,
 -0.42188336873376743985050450641040e+22,
 -0.61206295957817452510389960198843e+15,
  0.31610520900655122103775226528466e+17,
 -0.83155831964169521780364145342949e+18,
  0.14852436799914916799040740227185e+20,
 -0.20257184470034956404656035543011e+21,
  0.22498127177001459130019895371056e+22,
 -0.24517196180477993800367833828554e+16,
  0.13151120980538011776985081147384e+18,
 -0.35908480487381588664601139877142e+19,
  0.66527132066235902550306436695231e+20,
 -0.94060564496556636733405920285749e+21,
 -0.98197483944003297985862085329384e+16,
  0.54632486280456460567529775441195e+18,
 -0.15462493279837656804154724287753e+20,
  0.29676835313329478960969135666699e+21,
 -0.39326887011223522198416375317592e+17,
  0.22664322008392881731410981845412e+19,
 -0.66408950204812510999773093271360e+20,
 -0.15748622543596262230285576508896e+18,
  0.93903054828142395811496140660461e+19,
 -0.63061306571946642785372690398391e+18},
 {0.10000000000000000000000000000000e+01,	// TransMatrix_C0[1][0]
  0.25617376914898995958052596701303e+01,
 -0.42481613669916071115431253296155e+01,
  0.58827658115677186967215220563021e+01,
 -0.75003662019972398145047259908028e+01,
  0.91101787860298183269374484736582e+01,
 -0.10715756056577375587417750630019e+02,
  0.12318768836359751041906917188045e+02,
 -0.13920109146767119790101446945585e+02,
  0.15520297465951286042807968322630e+02,
 -0.17119658239948004096495058072023e+02,
  0.18718404360196700179403137405162e+02,
 -0.20316681371314084763577249781297e+02,
  0.21914592178368721836622855827085e+02,
 -0.23512211610699397710342223873843e+02,
  0.25109595393358932881464844088441e+02,
 -0.26706785882586364020603349831800e+02,
  0.28303815850695337557355909632137e+02,
 -0.29900711053250527384716382780041e+02,
  0.31497492012581329890848494154892e+02,
 -0.33094175283348347886732182514244e+02,
  0.34690774367623914198495379256241e+02,
 -0.36287300387777161492585018856923e+02,
  0.37883762588817868187940366234189e+02,
 -0.39480168718599910023922338009111e+02,
  0.41076525319192988816314390947103e+02,
 -0.42672837952736315388897486826348e+02,
  0.44269111378345985938416747287856e+02,
 -0.45865349692023261366085857956645e+02,
  0.47461556438289683317032673625944e+02,
 -0.49057734699999153512053308344632e+02,
 -0.25617376914898995958052596701303e+01,
  0.16992645467966428446172501318462e+02,
 -0.49023048429730989139346017135851e+02,
  0.10500512682796135740306616387124e+03,
 -0.19131375450662618486568641794682e+03,
  0.31432884432626968389758735181390e+03,
 -0.48043198461803029063436977033376e+03,
  0.69600545733835598950507234727923e+03,
 -0.96743187537763016333503002544391e+03,
  0.13010940262360483113336244134738e+04,
 -0.17033747967778997163256855038698e+04,
  0.21806571338543784312906248098592e+04,
 -0.27393240222960902295778569783856e+04,
  0.33857584719407132702892802378334e+04,
 -0.41263435096419846368540560452005e+04,
  0.49674621741610637078322230687149e+04,
 -0.59154975127953255494873851131165e+04,
  0.69768325790917897231004893153428e+04,
 -0.81578504312585644417297599861171e+04,
  0.94649341310376274956054041990739e+04,
 -0.10904466742889783696393714212878e+05,
  0.12482831333395343553449246486781e+05,
 -0.14206410970806700570477637337821e+05,
  0.16081588724709696683077699015711e+05,
 -0.18114747665764108067994646407672e+05,
  0.20312270865502486125115203729341e+05,
 -0.22680541396172593462448846860478e+05,
  0.25225942330612793751347221876155e+05,
 -0.27954856742152623473732244765681e+05,
  0.30873667704532800610252215384888e+05,
 -0.12744484100974821334629375988846e+02,
  0.99222650021775522018036338682962e+02,
 -0.39001904250385647035424575152174e+03,
  0.11114418118956378358863687137863e+04,
 -0.26110725591193538514674585701814e+04,
  0.53833019814892112053133228111757e+04,
 -0.10094863153235515271781569324938e+05,
  0.17610364191366059229906108056744e+05,
 -0.29017820716711866943559123432079e+05,
  0.45654188234519751737564252131191e+05,
 -0.69130894479458059088865521922492e+05,
  0.10135937174339101223874803277143e+06,
 -0.14457658919419059652089433460026e+06,
  0.20137058518960752206505422797460e+06,
 -0.27470599958828334031592605636990e+06,
  0.36794960605903938824562682521777e+06,
 -0.48489584438909003586096095069288e+06,
  0.62979235279156369116751564062707e+06,
 -0.80736550021256629504471832461750e+06,
  0.10228459186379352355045700922438e+07,
 -0.12819940353997793383715361311962e+07,
  0.15911256054828682274671329699092e+07,
 -0.19571372438309138063125607546797e+07,
  0.23875319576527732819594576594094e+07,
 -0.28904446787285943228669712701826e+07,
  0.34746677957159169876443510223747e+07,
 -0.41496766864557429767488912157991e+07,
  0.49256552502785799140082849342477e+07,
 -0.58135214403104663547411945676362e+07,
 -0.56082367403612251575411843603413e+02,
  0.52931155768380520976647637706522e+03,
 -0.26107169492536879376909316625941e+04,
  0.92298378833986461726291558759899e+04,
 -0.26448396691664385486974151202733e+05,
  0.65441217120781583557224922380583e+05,
 -0.14516651563153102878706386371100e+06,
  0.29582769438630151078743460348456e+06,
 -0.56322876502502148124102066031958e+06,
  0.10141255324084784918125540403451e+07,
 -0.17426746675344948029144534427968e+07,
  0.28780827988424918749275709399494e+07,
 -0.45935577511262143009794723991541e+07,
  0.71166640612763187660262570430792e+07,
 -0.10741184900075477821666338281757e+08,
  0.15840592529269135318048125891485e+08,
 -0.22883229423135313729858957696259e+08,
  0.32449302183777021979811319205772e+08,
 -0.45249790379360898957300476482485e+08,
  0.62147372434525780075952747375271e+08,
 -0.84179470702184906499113776617288e+08,
  0.11258351784594551715329140472411e+09,
 -0.14882454666236957694833754442052e+09,
  0.19462520547229940343016746803099e+09,
 -0.25199830121047196003225236323509e+09,
  0.32328197234264558816676980911044e+09,
 -0.41117759373946295323448115810288e+09,
  0.51879051563627398163751962381306e+09,
 -0.23679727580591285700079206342392e+03,
  0.26623412957078569082102438706115e+04,
 -0.15767639717472687211574807954816e+05,
  0.66394057771700271532197648004501e+05,
 -0.22411375726295062862063329582391e+06,
  0.64610998350755203796209572127107e+06,
 -0.16532453962317787555985277580153e+07,
  0.38511726461066524578537199549485e+07,
 -0.83139159213487529187274477458483e+07,
  0.16851335228517520499880328102516e+08,
 -0.32386276728252136958637857263130e+08,
  0.59472012520204627279143230591094e+08,
 -0.10498578186183681318016351996523e+09,
  0.17903986291305585784766306562907e+09,
 -0.29615762972286583811221442264791e+09,
  0.47676848331531083146695360071257e+09,
 -0.74908238838997830247930556275837e+09,
  0.11514119983272200630844078113251e+10,
 -0.17350180108800317366632352853080e+10,
  0.25675614651432104621310126781202e+10,
 -0.37372551671159845234333974349798e+10,
  0.53578153164167776772716449479903e+10,
 -0.75743237004681351748558538111484e+10,
  0.10570120524746097830393927893505e+11,
 -0.14574858058481464978863331055734e+11,
  0.19873855794510436787754379189957e+11,
 -0.26818908749799071141514738578470e+11,
 -0.98086258262921043986693195233054e+03,
  0.12865834625343567392149732433198e+05,
 -0.88906047876109700208962452487599e+05,
  0.43396572997280439905631720009540e+06,
 -0.16845589775930199040990652381306e+07,
  0.55406061927767720457896605944296e+07,
 -0.16053764625905259122064383182988e+08,
  0.42057507928940296698188561899596e+08,
 -0.10147418229181348597245009991311e+09,
  0.22856998377224811640974631143966e+09,
 -0.48566774906130144289353722394411e+09,
  0.98138883044760499277109377358804e+09,
 -0.18981999695143089434784515008130e+10,
  0.35329114615533361085319168548811e+10,
 -0.63548331163085346446785562888045e+10,
  0.11087570307027079611601501031353e+11,
 -0.18821961129538985812448105065172e+11,
  0.31169446370897412251634261967638e+11,
 -0.50467257251764696910471516416630e+11,
  0.80049234031055474723516903312758e+11,
 -0.12459888545225109752231994187291e+12,
  0.19060450020924876870396756172865e+12,
 -0.28693976429064178440823124570997e+12,
  0.42559746103404907450157146722375e+12,
 -0.62260847442969547864502007037950e+12,
  0.89918352273212907366635175289159e+12,
 -0.40205733204198648100467913853744e+04,
  0.60420976785246041849845336447112e+05,
 -0.47722125235362563926561425579288e+06,
  0.26480948603503510138351442376802e+07,
 -0.11613962981012849095982173169093e+08,
  0.42895472679668479018462306879362e+08,
 -0.13876298794389218910612531887892e+09,
  0.40368475789113811858249903507668e+09,
 -0.10762113187302531504321745320743e+10,
  0.26663583082881759628484997631761e+10,
 -0.62053970663687023389064544760720e+10,
  0.13681098773690927066467407747503e+11,
 -0.28768722667417700825978831614530e+11,
  0.58019874264762316957461825362414e+11,
 -0.11274202712195137241262847564551e+12,
  0.21189610538594116154466463982873e+12,
 -0.38646414001320091529214166470437e+12,
  0.68590080262530278622450975293740e+12,
 -0.11874899615310255754226543131274e+13,
  0.20096900079408713144094341955318e+13,
 -0.33308807554172592925274331297862e+13,
  0.54153330280042926251654179150232e+13,
 -0.86487241941042728163258536049995e+13,
  0.13586135367067166112656722564330e+14,
 -0.21016207355673503686786488545233e+14,
 -0.16375778754879768351827240719311e+05,
  0.27776224728827353534398609337169e+06,
 -0.24685630054113441654395412385155e+07,
  0.15343217149227984126802137030728e+08,
 -0.75003001931478997262591073245337e+08,
  0.30726090187576127587784892037476e+09,
 -0.10973589500810609349522069660358e+10,
  0.35091629729213941587551472894175e+10,
 -0.10241938878952541032095080279316e+11,
  0.27675165018622460796144844415183e+11,
 -0.70001991618382912072670350500594e+11,
  0.16719452438167325657671970909990e+12,
 -0.37972813592651947393709276986587e+12,
  0.82482492484031405005654134776500e+12,
 -0.17217410235057019782101850316630e+13,
  0.34676972429029065074689904585830e+13,
 -0.67619361458456083289121579428148e+13,
  0.12803728397101850016190797495007e+14,
 -0.23601776712776597628771615453325e+14,
  0.42448427567727345503480775859906e+14,
 -0.74633715503831262800658952208031e+14,
  0.12850316596498636376218008534375e+15,
 -0.21700147897493904485475441505038e+15,
  0.35989415791185297048298906901741e+15,
 -0.66421406960239323669214065806274e+05,
  0.12560629409887133547677665713623e+07,
 -0.12406821220137579484887594057323e+08,
  0.85373599561626025619724186483114e+08,
 -0.46016255560805424475634205010584e+09,
  0.20702847571838003030217681980766e+10,
 -0.80891367059621843291892549649441e+10,
  0.28198210833051064724906022053106e+11,
 -0.89412071598626411802929497341359e+11,
  0.26165378574432149451553002961502e+12,
 -0.71464008733923605173542372411502e+12,
  0.18379805333513713637566433780186e+13,
 -0.44834585531813357683350819171327e+13,
  0.10434580632393966290101553711906e+14,
 -0.23284717062044192074049456044235e+14,
  0.50027820586245088924004933237296e+14,
 -0.10385834232855756851976254331694e+15,
  0.20897293946432688873026218099034e+15,
 -0.40861240443972684881012951859736e+15,
  0.77824180892726961817007275594128e+15,
 -0.14467266313033928592938954781705e+16,
  0.26297382598502699861326227912371e+16,
 -0.46815665588642327170581580163705e+16,
 -0.26863773882417568859195007595610e+06,
  0.56063615810295407542794243682541e+07,
 -0.60934878993487328588703769760386e+08,
  0.45984802207722167179341905485628e+09,
 -0.27089671520228324419915978390053e+10,
  0.13276152176191776043339907082564e+11,
 -0.56325159293927623957154881321108e+11,
  0.21254974915112068068942012087288e+12,
 -0.72749502393391971811594478827366e+12,
  0.22918486765981331105217670452668e+13,
 -0.67215967866685581852367242103075e+13,
  0.18519103184912480111361952230757e+14,
 -0.48285429237624314350983219400306e+14,
  0.11986416649951484419547907348839e+15,
 -0.28473285067660533698792739371915e+15,
  0.65001059423199013605467278766083e+15,
 -0.14312908483110345413808182781386e+16,
  0.30495206409507553075942160722417e+16,
 -0.63041163471672523173763542941875e+16,
  0.12675070323155234912314080187721e+17,
 -0.24838803079691220663745578322063e+17,
  0.47531456420144233672622377002472e+17,
 -0.10842491736896753345540396183888e+07,
  0.24760087017364778876232604610807e+08,
 -0.29368445107452812652352813587460e+09,
  0.24116598935557026419512943435824e+10,
 -0.15414378608414970742627824809804e+11,
  0.81729678580137567556877927523441e+11,
 -0.37411893116267367043857342308621e+12,
  0.15192858437637996077184051552163e+13,
 -0.55822885622854527906280183031142e+13,
  0.18834855497390945753900616160552e+14,
 -0.59032390674946670568759477182129e+14,
  0.17345251279534947873654166192343e+15,
 -0.48136114445903310813654075054863e+15,
  0.12695131230437716404603298385786e+16,
 -0.31983108343056629082491113780923e+16,
  0.77307540234056271610967882864246e+16,
 -0.17995689035282750387095087094864e+17,
  0.40473172998085613990256475794044e+17,
 -0.88194907922977820599171460282930e+17,
  0.18666896523477825734031657025035e+18,
 -0.38459346709184012149530509853442e+18,
 -0.43694271207114315663939890489659e+07,
  0.10839809388786801091832115562212e+09,
 -0.13933910335935645350497480687753e+10,
  0.12368941716599467844574128999011e+11,
 -0.85245737979008474353375193055342e+11,
  0.48617387672830539781631039038740e+12,
 -0.23881591435365818285152469204184e+13,
  0.10383847420114861704588740130560e+14,
 -0.40763195283617383590332707233942e+14,
  0.14664765825772325080025822691292e+15,
 -0.48913200964310185554871055262496e+15,
  0.15266838664499511595336440372430e+16,
 -0.44928691826863216593280704930234e+16,
  0.12544822282439281363902732936352e+17,
 -0.33407913859084996135403453046950e+17,
  0.85233975819285552249701060060782e+17,
 -0.20912896382440991769078826973604e+18,
  0.49509670541335680474985362156909e+18,
 -0.11342095878753473365190438832849e+19,
  0.25207207419749005430922231065575e+19,
 -0.17587770200349445480124955713522e+08,
  0.47108392070957638168076271328002e+09,
 -0.65237161044103503947231995909832e+10,
  0.62249213314903862667348396789250e+11,
 -0.46014821195177157726406180443357e+12,
  0.28087426895729254816755103401758e+13,
 -0.14736206525528299767885626471754e+14,
  0.68301237645627859109614274577982e+14,
 -0.28528044450088358407467895168668e+15,
  0.10900277688352071578311405587154e+16,
 -0.38548767627861266778224511940385e+16,
  0.12736653911446657307039246498467e+17,
 -0.39617425444375633991160377892175e+17,
  0.11674822391200577889682242781987e+18,
 -0.32768468359898765829748352856180e+18,
  0.87996835984441225221083696992691e+18,
 -0.22697055418008693194045252664095e+19,
  0.56418973895795969599794752433508e+19,
 -0.13555351214861064467625432961618e+20,
 -0.70729313874242346258018197744592e+08,
  0.20344964127992253888901201976466e+10,
 -0.30197764704072530906894309096249e+11,
  0.30823297116453024010888997768602e+12,
 -0.24325771079221331730467918542697e+13,
  0.15822947419741301225694300990320e+14,
 -0.88304101945083258613386519818627e+14,
  0.43459972676346114071688301264598e+15,
 -0.19243228054681177395036179729029e+16,
  0.77821731448782125773150880667668e+16,
 -0.29085436334141086508758343463783e+17,
  0.10141383692812395196882506990347e+18,
 -0.33243680360835124043034901067061e+18,
  0.10310647512389199148706025109228e+19,
 -0.30420231419145371003693747193437e+19,
  0.85768263511164793215088072941219e+19,
 -0.23199993847792730045629606167457e+20,
  0.60412900096506694769722186839246e+20,
 -0.28423111649400942933023738055357e+09,
  0.87392629837229452044246630870520e+10,
 -0.13841224857795061925075687103374e+12,
  0.15048675675359773926928686612620e+13,
 -0.12628678667233844526949079750232e+14,
  0.87201882078989545731355749763780e+14,
 -0.51578394761508263388478499937941e+15,
  0.26862971616313028546956062835871e+16,
 -0.12568332851283562967383564335134e+17,
  0.53631653486565707294407825845789e+17,
 -0.21121704025229384942030523309181e+18,
  0.77503662631252899687629781181454e+18,
 -0.26703561229746903706562525621559e+19,
  0.86949711305906931050122932670202e+19,
 -0.26901484865125488646798842066434e+20,
  0.79451564866500404247732764863621e+20,
 -0.22489321210448323371719006096409e+21,
 -0.11415311392014981958670330798933e+10,
  0.37364257256187009271426727494678e+11,
 -0.62897341787357930099830219876805e+12,
  0.72568664473186766980167239931646e+13,
 -0.64525871851499201250550470391334e+14,
  0.47138877222327573844339919375664e+15,
 -0.29455999164600324087563493673513e+16,
  0.16184962717486945705448725187552e+17,
 -0.79783007514574282710698898847068e+17,
  0.35824178334300481246484179193400e+18,
 -0.14827801727519752288585434520907e+19,
  0.57115711470187109856013353775255e+19,
 -0.20634894126723452053382326518259e+20,
  0.70377755566505713846947938438316e+20,
 -0.22784084315564162357239717164232e+21,
  0.70342538522906034004775237113579e+21,
 -0.45824089087776520804579948814228e+10,
  0.15909285514699561428536885749306e+12,
 -0.28365541790072242267765248765895e+13,
  0.34614421909899695925126889369110e+14,
 -0.32508012673721794832138578025085e+15,
  0.25049671420715439541677971054319e+16,
 -0.16489236792479541422769785633682e+17,
  0.95323735049421954171003677312307e+17,
 -0.49378941105147613997695015838870e+18,
  0.23272856756693756520690011807494e+19,
 -0.10099791657741568845520932781419e+20,
  0.40746736762163158552727625873282e+20,
 -0.15402776497464353736021793022605e+21,
  0.54912007485488793540463590645508e+21,
 -0.18564834740846507270010282749578e+22,
 -0.18387616424024618736499918202716e+11,
  0.67493837502548416218516002431651e+12,
 -0.12706323347641962558725833608984e+14,
  0.16351003817132019566037306935039e+15,
 -0.16173104652212448917412212353285e+16,
  0.13109743940078335152204630051436e+17,
 -0.90671998228637914247880403583029e+17,
  0.55012780023184590091391762612433e+18,
 -0.29875960960780549885526157020359e+19,
  0.14746635606881728031956917182637e+20,
 -0.66954813906740406947740929247338e+20,
  0.28233725564066685532329620430281e+21,
 -0.11144903613558930026403055078241e+22,
  0.41453196498525374049872893742868e+22,
 -0.73758235594102311137001020621415e+11,
  0.28541018947028170328113230459747e+13,
 -0.56575621697390680007085871911433e+14,
  0.76568785130686878044342149919518e+15,
 -0.79561973020124058335879721028375e+16,
  0.67675720643223865622250638260297e+17,
 -0.49065452453110580351781842330007e+18,
  0.31173356687669666932424847714337e+19,
 -0.17710409018076632753937571509148e+20,
  0.91363231295746966363007892769309e+20,
 -0.43314412951236459934697021447424e+21,
  0.19054871422159300515583944469259e+22,
 -0.78402631652172226784128044297603e+22,
 -0.29578175759369705454437668174974e+12,
  0.12034077937794491759692826376664e+14,
 -0.25054354953373030243154085452881e+15,
  0.35575762513570274987278225968664e+16,
 -0.38744203780780407488849576095947e+17,
  0.34506137726910507925800202124448e+18,
 -0.26168512520591265463383383453475e+19,
  0.17374736386230583156320843392498e+20,
 -0.10306243825116735173791171321605e+21,
  0.55462571800659785426663646084144e+21,
 -0.27406320940484131087472977911510e+22,
  0.12556254958673421674039986780636e+23,
 -0.11858397967899681661011179276275e+13,
  0.50607950959276498957015062489396e+14,
 -0.11040979190315723382585723303308e+16,
  0.16412464365807173087025535003326e+17,
 -0.18694313582810233636270318857534e+18,
  0.17397322255928930734895309250850e+19,
 -0.13774026850764115846932968861646e+20,
  0.95394007371719580274856226064127e+20,
 -0.58974178826537084199302980934136e+21,
  0.33049889121638480522846212552247e+22,
 -0.16993822518377902095123325363206e+23,
 -0.47532329630259695152997572503852e+13,
  0.21232169719112196786715381190101e+15,
 -0.48439260162664460053382951877556e+16,
  0.75229630869857021279837031103309e+17,
 -0.89448103996414204547615747099043e+18,
  0.86820582735808997135523376471553e+19,
 -0.71634673329713496502224210096373e+20,
  0.51660686397762879459023558807789e+21,
 -0.33231005630854748152919012873134e+22,
  0.19362917323265531689528324461609e+23,
 -0.19049023235897031391307146430635e+14,
  0.88885805647462096199619234862706e+15,
 -0.21165204562523995065500989061368e+17,
  0.34280094840355626797742344231774e+18,
 -0.42472028586177456091513236760940e+19,
  0.42923381413996664236803685007647e+20,
 -0.36847205781677091467637672985751e+21,
  0.27626906823707216358465421381079e+22,
 -0.18462781703898848914705210204613e+23,
 -0.76328531165410664326542833261604e+14,
  0.37137585139184689126204796027810e+16,
 -0.92136290800630003171846443951554e+17,
  0.15536219786776688048276548084351e+19,
 -0.20025262913259427788157064013434e+20,
  0.21039084478141649924730033654428e+21,
 -0.18762473252665640956410410094843e+22,
  0.14604087473409513408144642024416e+23,
 -0.30580184707138496139574407595055e+15,
  0.15488485226936497597233094232430e+17,
 -0.39971699714629727334893998737573e+18,
  0.70062552714891491443303324624553e+19,
 -0.93807517298243213171774856513804e+20,
  0.10230889295067394865386984577609e+22,
 -0.94649941726584782146100123191630e+22,
 -0.12250094032267707574945516973182e+16,
  0.64488265343633488758909599393419e+17,
 -0.17286353105629400291479478105379e+19,
  0.31450631793381374294903164157170e+20,
 -0.43681214936734749366474682692258e+21,
  0.49386993927924061839482631821316e+22,
 -0.49067158413634176229605129973254e+16,
  0.26809221726464203880971422574142e+18,
 -0.74539312045978154262421136709698e+19,
  0.14057978676209909865083929800664e+21,
 -0.20227374102484421538164766465057e+22,
 -0.19651682368423659872400034032156e+17,
  0.11129321626339657446767454871459e+19,
 -0.32054569898826347132406654497447e+20,
  0.62589006026878297132633682364921e+21,
 -0.78699207996018854285652215298800e+17,
  0.46140058580995464268166399254145e+19,
 -0.13749880967979068629627858754832e+21,
 -0.31514225650767479973003319980940e+18,
  0.19105219164130619270955783772737e+20,
 -0.12618621827837363164768830985268e+19}
};
static const Standard_Real TransMatrix_C1[2][496] = {
 {0.10000000000000000000000000000000e+01,	
  0.00000000000000000000000000000000e+00,
  0.11092649593311780079813740546678e+01,
 -0.89431800132838654608058273689677e+00,
  0.84797121164650984865925183843688e+00,
 -0.82905497605424967378584129799260e+00,
  0.81928188432118262954175837633964e+00,
 -0.81352669697631406515461377445767e+00,
  0.80983641752507523568075158604827e+00,
 -0.80732269262739702791538009797478e+00,
  0.80553082057242021035033923530697e+00,
 -0.80420733282391756513576022881984e+00,
  0.80320144458432090152779606485394e+00,
 -0.80241872413406814232129144570293e+00,
  0.80179750809260569452812782254544e+00,
 -0.80129610853283071747119843470578e+00,
  0.80088550327474844638706105922586e+00,
 -0.80054497347936519657727352257766e+00,
  0.80025940208878134051518802640219e+00,
 -0.80001754662501314026022112565841e+00,
  0.79981090383540431104361860176626e+00,
 -0.79963294492196845731265397261691e+00,
  0.79947858910638143391233555760967e+00,
 -0.79934383416723736864328565570965e+00,
  0.79922549258707091799127939150858e+00,
 -0.79912100012861388444825121868816e+00,
  0.79902827495471936853569155522014e+00,
 -0.79894561258144908622288576057077e+00,
  0.79887160660507755531616181312940e+00,
 -0.79880508821524154491023935897815e+00,
  0.79874507956938328014180932824183e+00,
  0.10000000000000000000000000000000e+01,
 -0.22185299186623560159627481093356e+01,
  0.11626134017269025099047575579658e+02,
 -0.23743193926102275762459051476233e+02,
  0.38965583874549734667934541005652e+02,
 -0.57349731902482784067923086343775e+02,
  0.78912089606702464319997536122394e+02,
 -0.10365906144320963016713620301418e+03,
  0.13159359889826571555020695596989e+03,
 -0.16271722575562888249076852553201e+03,
  0.19703079654185980345826125606086e+03,
 -0.23453482181862170324611645093735e+03,
  0.27522962237798537281620296587611e+03,
 -0.31911540822085706642219487337308e+03,
  0.36619232159950363788433768466054e+03,
 -0.41646046170286919212127175079745e+03,
  0.46991989943238737039085955775309e+03,
 -0.52657068657441812205899372137264e+03,
  0.58641286167613463181074208510762e+03,
 -0.64944645391434830056741830463420e+03,
  0.71567148570516176929482530549214e+03,
 -0.78508797450246656810191351757269e+03,
  0.85769593406144569655424550857646e+03,
 -0.93349537534169883221381432928202e+03,
  0.10124863071629537915959342940779e+04,
 -0.10946687366879655348938974306516e+04,
  0.11800426697828003003512022683630e+04,
 -0.12686081112888631578420649592495e+04,
  0.13603650652305563509821376283398e+04,
 -0.14553135349754163364183765960566e+04,
  0.11092649593311780079813740546678e+01,
 -0.20569314030552890559853402948626e+02,
  0.10006060297428816214179171693555e+03,
 -0.28685302171477038712990108910544e+03,
  0.64149771542348599893119680867394e+03,
 -0.12373741061009736931001675509501e+04,
  0.21606435619569007287962452315768e+04,
 -0.35102390675439222773760726659943e+04,
  0.53978620286557878295576232157920e+04,
 -0.79479810702987772962367183414264e+04,
  0.11297831519523057800889979448235e+05,
 -0.15597415159718016550441263121574e+05,
  0.21009500104550547013720533334158e+05,
 -0.27709620729173819040871513070561e+05,
  0.35886077630734928385711431941792e+05,
 -0.45739937604717009871639099985997e+05,
  0.57485033630243430033227501500549e+05,
 -0.71347964860658546887827300649594e+05,
  0.87568096617323076398921626232981e+05,
 -0.10639756038542727899310711228846e+06,
  0.12810125381110460353720743873135e+06,
 -0.15295684069940337220199864007701e+06,
  0.18125475101283663934940627064145e+06,
 -0.21329818087032910358138942228737e+06,
  0.24940309254644142065915101220553e+06,
 -0.28989821447079138238506032110887e+06,
  0.33512504122761682430001924828416e+06,
 -0.38543783355544191976699887501542e+06,
  0.44120361834681981183521136045027e+06,
  0.98374980146122520068864101058645e+01,
 -0.13228350901685553639084328679615e+03,
  0.72791026897563121358396865963750e+03,
 -0.25961404350369635164919239429450e+04,
  0.72184223822708347001168880207629e+04,
 -0.17051915607407984162493905395832e+05,
  0.35874191169591014332447830033607e+05,
 -0.69178986870759447664887133528163e+05,
  0.12462302428225899678018492094679e+06,
 -0.21252388943123297326064872757609e+06,
  0.34640897772102202144895544485863e+06,
 -0.54361550329675429046729255117452e+06,
  0.82594157294297499184846008496203e+06,
 -0.12203483245522940154841486245221e+07,
  0.17597131301838257306651543300130e+07,
 -0.24836338637210080864171445867082e+07,
  0.34392842331339443651232334816379e+07,
 -0.46823201773491460916736796824226e+07,
  0.62778373277283482551537662984334e+07,
 -0.83013795341573987679772649637555e+07,
  0.10839998455745840191893202614643e+08,
 -0.13993364216137574750713521865813e+08,
  0.17874927123432865720215213046904e+08,
 -0.22613130454721842412197971966229e+08,
  0.28352674305229621313979574060118e+08,
 -0.35255830502073120454004844518852e+08,
  0.43503808582629620592960306214681e+08,
 -0.53298172837517111054735206067612e+08,
  0.55118128757023140162851369498397e+02,
 -0.74697853342487895608104300949133e+03,
  0.47103792657162074102873856089271e+04,
 -0.19924082335646907769701645950243e+05,
  0.65750618738860858384920221271259e+05,
 -0.18289895601473679667422936119619e+06,
  0.44868872236704378136724245745834e+06,
 -0.99919898125266904321586325124450e+06,
  0.20600888155377617113208631535524e+07,
 -0.39880812403506287224474925820020e+07,
  0.73253062226723953488069012401965e+07,
 -0.12868902844313091401135651222004e+08,
  0.21758484903429678442790230571949e+08,
 -0.35584278508215979584693175333177e+08,
  0.56518944474853811423330756211316e+08,
 -0.87476302600267879295210553338445e+08,
  0.13230037913867746639363935538602e+09,
 -0.19598840306938706111849749648671e+09,
  0.28495158100170649092760556948819e+09,
 -0.40731768482133918895077113053240e+09,
  0.57327969044102507640318265941672e+09,
 -0.79549491027667228634340660285474e+09,
  0.10895392663286596300476361852731e+10,
 -0.14744215550064393429450903640809e+10,
  0.19731627590930172581412624721799e+10,
 -0.26134456665043351512138748409384e+10,
  0.34283402597570275857606129540276e+10,
  0.26778475726552264463282673925161e+03,
 -0.39164951198089814422614217422540e+04,
  0.28085382159713290471332731335602e+05,
 -0.13708910875864473589603762848625e+06,
  0.52195834046439100045813069474364e+06,
 -0.16665304934494572763854028303572e+07,
  0.46615012720048263127794255585536e+07,
 -0.11755431446531637104908395422304e+08,
  0.27266436193461392903133460604042e+08,
 -0.59020983269818454407364725476174e+08,
  0.12053770836003835148948949351046e+09,
 -0.23423523814470992079472907763203e+09,
  0.43601451103383273982658509521509e+09,
 -0.78164881911473809335994505439885e+09,
  0.13555095797207922486974352953378e+10,
 -0.22822634981651713908819890643334e+10,
  0.37422981216381566877892675879039e+10,
 -0.59917686250703350683935973897787e+10,
  0.93883098299515962723274414550825e+10,
 -0.14423624753700679626359728305580e+11,
  0.21764345237236034979650400453224e+11,
 -0.32302762218939711488790344576107e+11,
  0.47219243831265665715223972908230e+11,
 -0.68058399508856077024940925282652e+11,
  0.96821308531227763814258750706685e+11,
 -0.13607641269590939888144830135460e+12,
  0.12172890237244131509731445955654e+04,
 -0.19553114161825708555991142069090e+05,
  0.15778116544133543096334963219305e+06,
 -0.87234446229160758454368481106567e+06,
  0.37584537579350039416547163074876e+07,
 -0.13526422172311045420164530780459e+08,
  0.42437974015697627514107875660912e+08,
 -0.11942408463214494731867259227444e+09,
  0.30755479267870735897656426743595e+09,
 -0.73564729098096981352780217511326e+09,
  0.16527874938373570989036213037402e+10,
 -0.35186466448419587406574307027423e+10,
  0.71479844861391175347204199510256e+10,
 -0.13934975110552278004978787606855e+11,
  0.26192350120277653999402870733757e+11,
 -0.47652256850962017405790985785417e+11,
  0.84190662660419144282849827440554e+11,
 -0.14485564310880610038527509647275e+12,
  0.24330257703113779436442148578930e+12,
 -0.39976680432859469369744694105832e+12,
  0.64373741990100749718617674806504e+12,
 -0.10175353877099568529968310095786e+13,
  0.15810459450509537808456434284422e+13,
 -0.24179102888932252541293942082029e+13,
  0.36435458346721226115561896147294e+13,
  0.53326674986797386970884932915700e+04,
 -0.94282628158119304529290701014260e+05,
  0.84749134370780110065355134066494e+06,
 -0.52340938949988583127001207092269e+07,
  0.25155449354509573597438943620000e+08,
 -0.10066924020575274684385189534373e+09,
  0.34984898851715842654663022199351e+09,
 -0.10861020051439334799673883798996e+10,
  0.30733853022490030301636568477993e+10,
 -0.80466084101680666123480050980906e+10,
  0.19716574721134696721072502777264e+11,
 -0.45622543454446278987793651462251e+11,
  0.10041296606377752997295545618724e+12,
 -0.21145518084002009874314109103698e+12,
  0.42813531540902892245048713449880e+12,
 -0.83685801070189017799973812038052e+12,
  0.15846516300396835717948188962209e+13,
 -0.29155024420745446515419434821846e+13,
  0.52251716752795582823890813556201e+13,
 -0.91424025408164003280211243846365e+13,
  0.15647232862594311945247758428868e+14,
 -0.26240750970293675541060912928914e+14,
  0.43185255245189575253452066612731e+14,
 -0.69839621352912757419844581411213e+14,
  0.22834074007044519065687591651891e+05,
 -0.44300683875635057534162910989304e+06,
  0.43960038284784472514551939736977e+07,
 -0.29997840821045017123360842699670e+08,
  0.15904564409364280837618108624767e+09,
 -0.70025480347164882766960216936640e+09,
  0.26689214753140881391477127704893e+10,
 -0.90570755458052092392331156587038e+10,
  0.27923795809343868974228193653870e+11,
 -0.79402675261224659057160335493565e+11,
  0.21067191628169985002313561588969e+12,
 -0.52633876062120578260648346796578e+12,
  0.12474259598891533341110986846936e+13,
 -0.28214974781079573429389005857303e+13,
  0.61212690063165661624479433770406e+13,
 -0.12791914079857791759587392447899e+14,
  0.25841788360638722495924198800668e+14,
 -0.50622331075047789739954584335966e+14,
  0.96416993573248031095323581667065e+14,
 -0.17896481322909352411690766481548e+15,
  0.32439294246030120160400397934519e+15,
 -0.57523855963552772289121304272817e+15,
  0.99952263851818085316761444649699e+15,
  0.96305834512250125074267197802834e+05,
 -0.20404944590656468709472692803212e+07,
  0.22176668336182494797803884876233e+08,
 -0.16572643808818906363459894573166e+09,
  0.96068639919774131331847335519792e+09,
 -0.46137487126988528969226085997338e+10,
  0.19130005839977046718593285703315e+11,
 -0.70428741510901134550453916870027e+11,
  0.23492422957399584013886011378581e+12,
 -0.72081279230841635438858010495411e+12,
  0.20583414067508344272293613356521e+13,
 -0.55213025359410694403079526064121e+13,
  0.14016920720309737400349321618377e+14,
 -0.33886670836973855172986765544237e+14,
  0.78415776432434947932383286749315e+14,
 -0.17444584379323106037963588742241e+15,
  0.37446161815000260534306738529240e+15,
 -0.77808372075201035462589125044937e+15,
  0.15693412960987146629489291854349e+16,
 -0.30798454840119547109036282461752e+16,
  0.58936321288652488423570541948217e+16,
 -0.11017815678125789036664811282017e+17,
  0.40191557527050620185325000976024e+06,
 -0.92515293552834206021405878454684e+07,
  0.10936968217123879230203437832213e+09,
 -0.88846223332190306790534452717125e+09,
  0.55896115951290469049587130758548e+10,
 -0.29074045427825584490950537106602e+11,
  0.13026400680736536320940220852022e+12,
 -0.51700473854138433928293054693271e+12,
  0.18547767803174314888318296393485e+13,
 -0.61068241344048462063880593915842e+13,
  0.18671763126860119828433012485576e+14,
 -0.53514475247398228092808417859728e+14,
  0.14486838495854286424503071248474e+15,
 -0.37274618607031257481139561915001e+15,
  0.91635658977132255976933608282741e+15,
 -0.21619796895259573123806358731021e+16,
  0.49138183048661941345214428231607e+16,
 -0.10794073933936132475862230477066e+17,
  0.22981780988332371099600167963208e+17,
 -0.47543786511216496406126517247137e+17,
  0.95778311765695949169420137751725e+17,
  0.16645010973940882254897291939546e+07,
 -0.41414652982175756018370351257981e+08,
  0.52935586387984831829749162721586e+09,
 -0.46452455597141659608956519254794e+10,
  0.31521395265538138750002626025329e+11,
 -0.17651403262456947454389746036808e+12,
  0.84973056037494851802937099792901e+12,
 -0.36161677121842572274500398220961e+13,
  0.13882368132488265845229262938178e+14,
 -0.48814250017714820069585551452896e+14,
  0.15909113079969199429868342106155e+15,
 -0.48513672494092439124365383396904e+15,
  0.13948767955793773396819828685274e+16,
 -0.38055408396388439029627020713029e+16,
  0.99040779967818522343409424040793e+16,
 -0.24699354141419414755494589947005e+17,
  0.59252519869796215340339892525806e+17,
 -0.13719106332838048627429727182290e+18,
  0.30747076754358258889356153867119e+18,
 -0.66872430970056417199455566147108e+18,
  0.68538334160642976509274877081870e+07,
 -0.18345651482365840469096832932503e+09,
  0.25220027337314308722278322365084e+10,
 -0.23778275043210124271530130650361e+11,
  0.17311035992473437168177612638653e+12,
 -0.10382937393371473477570778020137e+13,
  0.53441717164667011466797871180711e+13,
 -0.24273308986806346127007775393252e+14,
  0.99278440265199761152783327872288e+14,
 -0.37127531197507384682998231751119e+15,
  0.12847660481458108005451578444010e+16,
 -0.41530592777662880642514981660953e+16,
  0.12638371014608937762187198814429e+17,
 -0.36439860292845416076718605461043e+17,
  0.10008321575862795732785960837137e+18,
 -0.26304419020462395195536904759559e+18,
  0.66417276218971276518431166988946e+18,
 -0.16165582941629099165465486160439e+19,
  0.38040362008687764484897684717612e+19,
  0.28096943711731467385103257644374e+08,
 -0.80555718163714675926301725076877e+09,
  0.11855141742006401928272218984544e+11,
 -0.11952978097221994057043796468793e+12,
  0.92932025471058773535806996035038e+12,
 -0.59436902950226699352757199698692e+13,
  0.32570785106408830998191080155605e+14,
 -0.15725351280809675880465191708201e+15,
  0.68260326012261031825510333223407e+15,
 -0.27051100979343398811320214168061e+16,
  0.99047029162755987851990043190463e+16,
 -0.33829014878877366392767371415245e+17,
  0.10862126515405303228464307541708e+18,
 -0.33000875914291519913308290073000e+18,
  0.95385206108909267080334233684745e+18,
 -0.26350474873415517274858604491886e+19,
  0.69850879280004396632454554266588e+19,
 -0.17828945669785492781703587058321e+20,
  0.11478146370477479730431592951368e+09,
 -0.35109506365880118584943269833189e+10,
  0.55086021775590280461525487631777e+11,
 -0.59150039797676232577108392889645e+12,
  0.48914826003079485736768230840115e+13,
 -0.33230328080018259282823599252100e+14,
  0.19315149915292337300761902438292e+15,
 -0.98774901345984441623372213549870e+15,
  0.45350588973241202539750197517973e+16,
 -0.18983350142055247872763028524820e+17,
  0.73320339495251570753750087031060e+17,
 -0.26382018913113656813498597326986e+18,
  0.89131160167456107459733383844169e+18,
 -0.28458805987429698740227236328455e+19,
  0.86347386461729177755184461741712e+19,
 -0.25012299087619887371429266720679e+20,
  0.69450124669056620883655176006959e+20,
  0.46759839178034469447215641538558e+09,
 -0.15204739042131253883045496586147e+11,
  0.25339899712174995229992077317906e+12,
 -0.28872083569961827800656829469502e+13,
  0.25305424044640259461771305054779e+14,
 -0.18197733214546950419217260182571e+15,
  0.11182462990384451169626671182381e+16,
 -0.60379471591959057340929094165402e+16,
  0.29233612229735985628560433095579e+17,
 -0.12888263825574811596200716054599e+18,
  0.52365793184525049250622626844764e+18,
 -0.19798335499334866648821006169576e+19,
  0.70203758441469177273304314656251e+19,
 -0.23501066651179902970659142490284e+20,
  0.74680511364605228589327162061057e+20,
 -0.22634078172895061218706592633214e+21,
  0.19005923802664067353806870732683e+10,
 -0.65483244190524888106571896283032e+11,
  0.11554053501753838636695135658892e+13,
 -0.13923697764820954696834874607470e+14,
  0.12893289399296161301661912728602e+15,
 -0.97846779877893235742610194707996e+15,
  0.63378751272003034244294961838829e+16,
 -0.36030597301676648846483869314089e+17,
  0.18346211383847621886734977024242e+18,
 -0.84968186560920283963525776470120e+18,
  0.36227351719685727762161205260794e+19,
 -0.14357786347008943594234229345778e+20,
  0.53314662993866018944920243912458e+20,
 -0.18671270349822974108255021009176e+21,
  0.62012737557021994470725756998416e+21,
  0.77106807746312258403169016712885e+10,
 -0.28066046629597548073112354228440e+12,
  0.52272744861993115769517498829681e+13,
 -0.66431692308616420728516967314599e+14,
  0.64807403375464650110816585849370e+15,
 -0.51759919843768944145681615043859e+16,
  0.35246710162744247666080100504932e+17,
 -0.21043511620780300528678334770607e+18,
  0.11241276615645083582199838043939e+19,
 -0.54564249564891256784458744479603e+19,
  0.24358040242825147112415589997460e+20,
 -0.10097892390557024054322728649401e+21,
  0.39185355229161516758886494934115e+21,
 -0.14328285432532140846911524604113e+22,
  0.31233374775884418702052933389016e+11,
 -0.11977944702294516720241874458661e+13,
  0.23485560145683717889274521287771e+14,
 -0.31393349481291570991358244617164e+15,
  0.32182154023570802443675668812551e+16,
 -0.26983243435427641675906240299654e+17,
  0.19271217644734321569759373220565e+18,
 -0.12055405143551348396348504008246e+19,
  0.67412695823205710396366977444936e+19,
 -0.34221162622276874988519939481102e+20,
  0.15962373842008770182198255279986e+21,
 -0.69083336720939568312978734258439e+21,
  0.27963010361889951562113601504021e+22,
  0.12634962766133456455951344365677e+12,
 -0.50926310937806190690006391785259e+13,
  0.10486411234203687434703915149535e+15,
 -0.14708352738104553300469527646065e+16,
  0.15807450715495505365558801221300e+17,
 -0.13882737401347598074300018107383e+18,
  0.10376189686309626930870246448989e+19,
 -0.67869625747122441865664798376180e+19,
  0.39648202348145797017029849422218e+20,
 -0.21008539750802477911207598747946e+21,
  0.10220167067022284069174917950165e+22,
 -0.46093849160072985017933836809665e+22,
  0.51055565534095038889727220190806e+12,
 -0.21579282813952281067941725091963e+14,
  0.46561012033751748294025575933139e+15,
 -0.68377971926328702626650954759668e+16,
  0.76880583026186755539365068523725e+17,
 -0.70578925101871374443746222045525e+18,
  0.55096778360045391159171913924304e+19,
 -0.37609644698889194765589507007636e+20,
  0.22910560765620144985459322602682e+21,
 -0.12649015330380713413618694203974e+22,
  0.64067203902240374301383618544530e+22,
  0.20610822480529796647171037774832e+13,
 -0.91162518943342128600015306759824e+14,
  0.20569269718361779278344797902527e+16,
 -0.31565035805516112927060823652575e+17,
  0.37056992875691335796840446105043e+18,
 -0.35494416467022712545666592756140e+19,
  0.28887661148730664372244713830651e+20,
 -0.20542827825492075347569088337121e+21,
  0.13027190051150788651222294906700e+22,
 -0.74818955867150805783318364230674e+22,
  0.83135630482922066962278109938204e+13,
 -0.38406821325410168120715051179991e+15,
  0.90451651344977607478707330840502e+16,
 -0.14477891609019959282108699066075e+18,
  0.17715858601372494211231808059030e+19,
 -0.17674053884857942752941637727992e+20,
  0.14971519510396011889581685827006e+21,
 -0.11073587807874225733414055545911e+22,
  0.72988768902280681585443889910522e+22,
  0.33509307196666589635523199016099e+14,
 -0.16140753155667812316163109648332e+16,
  0.39608617036935499098492041312771e+17,
 -0.66016153173516490199366456016960e+18,
  0.84060174448419815855518953935174e+19,
 -0.87208607666166145683970546375141e+20,
  0.76771242532320218688909558863928e+21,
 -0.58972417810617197353039149943995e+22,
  0.13497988994616568398199783596757e+15,
 -0.67679744870112103008777032480251e+16,
  0.17277908781810262279124148120909e+18,
 -0.29939818490697299907255758146265e+19,
  0.39611049100411442490894120235444e+20,
 -0.42672025646210032995918167265263e+21,
  0.38982867944675812508846948086262e+22,
  0.54341400990600958620185938487793e+15,
 -0.28320250533253980575590882384559e+17,
  0.75102698655958682304727717574280e+18,
 -0.13510956565045691594909911260914e+20,
  0.18546935005705720770176492700287e+21,
 -0.20718855992504929949520077004469e+22,
  0.21866460306785307340973469907118e+16,
 -0.11828038017502959815749500447564e+18,
  0.32538825300536463888519543204621e+19,
 -0.60690999405542294109996642570037e+20,
  0.86330401756407532994051974656002e+21,
  0.87949969970313877712661330638590e+16,
 -0.49314056872103258700719810839815e+18,
  0.14055168567385818416396134843218e+20,
 -0.27146216917715525589855056413841e+21,
  0.35360854733872491704004515524673e+17,
 -0.20527164479263546750262145525969e+19,
  0.60541430428022207259805589790718e+20,
  0.14212064510025935438170660659159e+18,
 -0.85317657493632080735725345691158e+19,
  0.57102369188651392618398853415342e+18},
 {0.10000000000000000000000000000000e+01,	// TransMatrix_C1[1][0]
  0.00000000000000000000000000000000e+00,
  0.36790156631903594003486257104716e+01,
 -0.55185234947855391005229385657074e+01,
  0.72275337185200146252523913019207e+01,
 -0.88906241418606791478049072665513e+01,
  0.10531517291426606908417207884053e+02,
 -0.12159810320782979747439653327384e+02,
  0.13780205001550283144994580240337e+02,
 -0.15395299746534725734549127955775e+02,
  0.17006655960529746871381696138141e+02,
 -0.18615271870888306819073501372261e+02,
  0.20221816971153571481539335167415e+02,
 -0.21826757788124781510340502930167e+02,
  0.23430429757309958178586707127915e+02,
 -0.25033080450427071985419105065792e+02,
  0.26634896691938920702652583987845e+02,
 -0.28236022182445182413896102761727e+02,
  0.29836569303900369577807128408783e+02,
 -0.31436627236843516179258672656021e+02,
  0.33036267670685244605326304639966e+02,
 -0.34635548902465029231796959705023e+02,
  0.36234518832002544383892630653135e+02,
 -0.37833217185936230256022128356637e+02,
  0.39431677193173894032272901768661e+02,
 -0.41029926863671300207818929382844e+02,
  0.42627989976128403163083338172562e+02,
 -0.44225886849199055073141855809206e+02,
  0.45823634949702865667196163603912e+02,
 -0.47421249376718822015072867776007e+02,
  0.49018743250177387134627111450272e+02,
  0.10000000000000000000000000000000e+01,
 -0.73580313263807188006972514209432e+01,
  0.34950648800308414303311944249480e+02,
 -0.86730404622240175503028695623048e+02,
  0.16892185869535290380829323806447e+03,
 -0.28786147263232725549673701549745e+03,
  0.44991298186897025065526717311322e+03,
 -0.66144984007441359095973985153619e+03,
  0.92884975137426178598446405333175e+03,
 -0.12584925410792012684822455142224e+04,
  0.16567591965090593068975416221313e+04,
 -0.21300313876281761960554766376344e+04,
  0.26846912079393481257718818604106e+04,
 -0.33271210255380140613593124121639e+04,
  0.40637033931193280189663680556802e+04,
 -0.49008209913167614092880754537635e+04,
  0.58448565917661527596764932716774e+04,
 -0.69021930323022854956660490385651e+04,
  0.80792131998687836580694788725974e+04,
 -0.93823000184746094679126705177505e+04,
  0.10817836440536577463397917081202e+05,
 -0.12392205440544870179291279683372e+05,
  0.14111790010354213885496253877026e+05,
 -0.15982973155633151714414616183564e+05,
  0.18012137893151700791232509999068e+05,
 -0.20205667248684863099301502293794e+05,
  0.22569944255374584438993393747965e+05,
 -0.25111351952437170385623497654944e+05,
  0.27836273384133948522847773384516e+05,
 -0.30751091598944614195789407916471e+05,
  0.36790156631903594003486257104716e+01,
 -0.53345727116260211305055072801838e+02,
  0.27464628130376055575959086947299e+03,
 -0.88550616452932364312136876374851e+03,
  0.22249585531020611528516087856376e+04,
 -0.47788054560677110407437837576620e+04,
  0.92051769410355891408563796005453e+04,
 -0.16360071863984235213914206641003e+05,
  0.27322893466187091323561833015537e+05,
 -0.43421983166034064486170849300937e+05,
  0.66260153608813202554510554898562e+05,
 -0.97740221375222771603304772121289e+05,
  0.14009053951895623994976992191780e+06,
 -0.19589053001271195217176727556784e+06,
  0.26809621614238040022461984938805e+06,
 -0.36006575487054096614200310241754e+06,
  0.47558496918107059094705302445986e+06,
 -0.61889288041173830302106548857909e+06,
  0.79470724057893597012788745389718e+06,
 -0.10082500646971309916120713095358e+07,
  0.12652731630946968473411467697768e+07,
 -0.15720836737272081758284874996033e+07,
  0.19355695944889292117308358381510e+07,
 -0.23632253155229940808498715670213e+07,
  0.28631771515306260038935533417012e+07,
 -0.34442088740796409446344503994241e+07,
  0.41157872439124119884962250225762e+07,
 -0.48880875432534227356696810646152e+07,
  0.57720191081165042264593795676107e+07,
  0.23913601810737336102266067118065e+02,
 -0.31801148361488064351110521728451e+03,
  0.18741435691042311643572744517890e+04,
 -0.73102772025555887420293312325840e+04,
  0.22240293076712069958067125935786e+05,
 -0.57231159972152833084468919535298e+05,
  0.13044950651897090939074627754527e+06,
 -0.27109970133561258892732134179888e+06,
  0.52375556630493922300008821990967e+06,
 -0.95368785078223063583137043227550e+06,
  0.16532895954192997002822517349484e+07,
 -0.27497015145988674520062216017036e+07,
  0.44137395265959097421343699492949e+07,
 -0.68702265606360787571787696358919e+07,
  0.10409830770046430290895903997371e+08,
 -0.15402512280706285186904988693714e+08,
  0.22312680604012711948003890315046e+08,
 -0.31716164843578798779093149767597e+08,
  0.44319098824884998959876911793453e+08,
 -0.60978823277105091069062847148121e+08,
  0.82726907196329065738653362329318e+08,
 -0.11079439051940573487252513029542e+09,
  0.14663935023762817102777670711225e+09,
 -0.19197689207948528968379486726033e+09,
  0.24881166989170302457588250561626e+09,
 -0.31947303484779864004709554462910e+09,
  0.40665291661337178938345426102319e+09,
 -0.51344653859735597383431382240682e+09,
  0.12286807321484024862929065213265e+03,
 -0.17230029586925996188445910282576e+04,
  0.11601285414517962912381098044898e+05,
 -0.52858695464443612962120173014139e+05,
  0.18790293819971064659853324056289e+06,
 -0.56146658175612144753900669654711e+06,
  0.14742525839192500610900908167878e+07,
 -0.35009890729754605741086086618823e+07,
  0.76702497674547195331862652185664e+07,
 -0.15727379458022251941183401088847e+08,
  0.30506255531009264378812642573595e+08,
 -0.56440416586436634049766901869127e+08,
  0.10024929779373120533724284261821e+09,
 -0.17184092973561075696835235829113e+09,
  0.28547848311480102214756097713798e+09,
 -0.46126447583933807056160910545948e+09,
  0.72700330166019816803108569997625e+09,
 -0.11205099907098831396811503603766e+10,
  0.16924407719823713847175398393343e+10,
 -0.25097290760035225584943016011599e+10,
  0.36597190926665972965917684319225e+10,
 -0.52550978844500220631734117486059e+10,
  0.74397363489938931790846505318762e+10,
 -0.10395559027287973274627813685779e+11,
  0.14350572864517087787564480717084e+11,
 -0.19588195549919878669859928872253e+11,
  0.26458034989843817165026926287860e+11,
  0.57433431956419987294819700941921e+03,
 -0.87954551743643275740474557044106e+04,
  0.66995027681004771599416380900557e+05,
 -0.34872150984182882759754076978067e+06,
  0.14152899056989373367771013329744e+07,
 -0.48068564779575066223098023339825e+07,
  0.14265024310727928266587849060174e+08,
 -0.38062258850938841975888647453954e+08,
  0.93161164032094285565468927671066e+08,
 -0.21225987145765353687337648222468e+09,
  0.45521599362048356031952753085463e+09,
 -0.92689998755382107085008919875861e+09,
  0.18042302020096976464545083643985e+10,
 -0.33760088076720830927229692241996e+10,
  0.61002343385309121116903784979894e+10,
 -0.10684838439934075001872413711601e+11,
  0.18199308995629350540943870252166e+11,
 -0.30226448097006693757260708637971e+11,
  0.49065601961520398374329055675771e+11,
 -0.78001123176745148974012027629593e+11,
  0.12165261744860215742071935452468e+12,
 -0.18642672290795131832287209477353e+12,
  0.28109380715402007626624894557376e+12,
 -0.41751708439513451072413414730076e+12,
  0.61156629273010563092982759558109e+12,
 -0.88425327187464423110239723312486e+12,
  0.25568183646407928994323999140729e+04,
 -0.43095473214156769586721353178916e+05,
  0.36747222515093130378182780071189e+06,
 -0.21505812641317024030328096450098e+07,
  0.98014146328287972671584196152404e+07,
 -0.37252398070953036510352595035134e+08,
  0.12317785473937608328931191233556e+09,
 -0.36454291286554983336174148144463e+09,
  0.98524308106584096655115556621095e+09,
 -0.24681909940923126742783522636747e+10,
  0.57967875933950769815545620596758e+10,
 -0.12877516347463984791028138720051e+11,
  0.27252229455042497023026659713428e+11,
 -0.55260024924686375212477167880818e+11,
  0.10787867220751877700620477907786e+12,
 -0.20356942244947159103594690347076e+12,
  0.37257279923270015660190469829414e+12,
 -0.66326375575475247316415455454041e+12,
  0.11513807632187085651986598593808e+13,
 -0.19532046599481700089170026643077e+13,
  0.32440906128956173384947537568245e+13,
 -0.52841631107707416366313569700617e+13,
  0.84534840741580573269997964805054e+13,
 -0.13299614406329681167453275149400e+14,
  0.20601228174799677201141841419146e+14,
  0.11059900205403064761193975594589e+05,
 -0.20494702812015958771640171194127e+06,
  0.19376524260988605809503532445138e+07,
 -0.12594359133673749001025448041239e+08,
  0.63653738231211576671508144867760e+08,
 -0.26750902422686495617688878777369e+09,
  0.97466103489513270097272707813089e+09,
 -0.31668248331701059473949910287936e+10,
  0.93628171844976730860208686702830e+10,
 -0.25569351711455723723692818898105e+11,
  0.65248578469853853170819900549559e+11,
 -0.15700181241751876537311004195313e+12,
  0.35883202235520910000829202361617e+12,
 -0.78365198428276602951173940752359e+12,
  0.16434312169504522093587978532469e+13,
 -0.33233989518824401963354272172054e+13,
  0.65035381048181358576442708428152e+13,
 -0.12352860396333849561800718787179e+14,
  0.22833470973958914843768975695149e+14,
 -0.41167258146099597066506110670703e+14,
  0.72539491349767108982333242818761e+14,
 -0.12514230577516543888734190949517e+15,
  0.21169899725805030566530946224633e+15,
 -0.35165968869312259470970467755113e+15,
  0.46967027277536572185008725653207e+05,
 -0.95285655019696715381899239221971e+06,
  0.99044803700638538191185871327292e+07,
 -0.70800032257855952583015296403040e+08,
  0.39290035469033514307332908795368e+09,
 -0.18084534268544635574695972904676e+10,
  0.71957517366691962784366595778888e+10,
 -0.25456163765663784225781037699064e+11,
  0.81700275957743849725749182107545e+11,
 -0.24150490414569902581749755359031e+12,
  0.66521482546117520517245614310726e+12,
 -0.17232005397162374281318566587348e+13,
  0.42294119391865185649128678515792e+13,
 -0.98957228961762546735923343517096e+13,
  0.22184372660921955774214784289621e+14,
 -0.47856405283308161082815078510132e+14,
  0.99703700725391134398835244981023e+14,
 -0.20124405536450796974449991709719e+15,
  0.39459894617873120970042125454152e+15,
 -0.75342549662979717699550282804220e+15,
  0.14037236494453662409176411293065e+16,
 -0.25567015542194915771156962680033e+16,
  0.45598086365282108896378358083400e+16,
  0.19695917518037868542627217045882e+06,
 -0.43525038562197180529356607123825e+07,
  0.49375336179263338926970464180741e+08,
 -0.38503251402243684223576266641116e+09,
  0.23271770443167004971111167642435e+10,
 -0.11640722585432353566395796466776e+11,
  0.50211671641743965738446041649942e+11,
 -0.19207577168185000286401355093834e+12,
  0.66490004736925871762774757091140e+12,
 -0.21146741273488337632312301085393e+13,
  0.62522514353063197882640906535413e+13,
 -0.17345464643594889464789803329039e+14,
  0.45495896753330191860185918251704e+14,
 -0.11352618166510430491823056555253e+15,
  0.27090198362623253101944301316654e+15,
 -0.62090611117609284495853158831709e+15,
  0.13720309880975038138519052595401e+16,
 -0.29324297099194021260495158698209e+16,
  0.60790290644883461155574457313398e+16,
 -0.12253172066673948774845710635063e+17,
  0.24066226519538561973328545119739e+17,
 -0.46146925586558410955050276388521e+17,
  0.81859017479361669802918389544808e+06,
 -0.19602370014499007845250610898881e+08,
  0.24113062090357344547732878955210e+09,
 -0.20373648306719266900221878153971e+10,
  0.13321379430377374694767907465580e+11,
 -0.71944507000591245896312110572960e+11,
  0.33434409882702233922855365752400e+12,
 -0.13749369125755950505513735670022e+13,
  0.51055681549436039988765796902910e+13,
 -0.17381533706252277621024835160153e+14,
  0.54897105988536860764928065127643e+14,
 -0.16237352706352043171183807605781e+15,
  0.45321454131377443842094760191158e+15,
 -0.12013076224930283242833426120990e+16,
  0.30398952302112131969526401058052e+16,
 -0.73766330121518047541265320768329e+16,
  0.17231132405480112113627258176447e+17,
 -0.38874019992101818980050149399492e+17,
  0.84945992417987617087039781663715e+17,
 -0.18024271317641163430871129799103e+18,
  0.37219318168108539047512894903916e+18,
  0.33797189680170703181466570515312e+07,
 -0.87269535181762318034146996288720e+08,
  0.11575351041653474247640893944055e+10,
 -0.10535485064844440229407981936134e+11,
  0.74095507317792261158463074868820e+11,
 -0.42967055479285712670413848632732e+12,
  0.21399984269512116201818480111795e+13,
 -0.94136052912475380879536454032197e+13,
  0.37320616615020682085513968077471e+14,
 -0.13540084760130180816610403504496e+15,
  0.45491913397662956366436394466015e+15,
 -0.14289065008572528006742297336446e+16,
  0.42284345308860567046823208694285e+16,
 -0.11864017880281255080503276347877e+17,
  0.31730965826624099217014754965296e+17,
 -0.81265285739887146774740777564106e+17,
  0.20007211481597767495350697522591e+18,
 -0.47510421187668410288693743787434e+18,
  0.10914041976557735052951253989539e+19,
 -0.24316145786832450201568239709539e+19,
  0.13883789688007641505432476682296e+08,
 -0.38481516182160994298590465050968e+09,
  0.54764730906095051144434632183090e+10,
 -0.53424595183757324850085744107376e+11,
  0.40215215309315314328774010218258e+12,
 -0.24920656060804170194896997275785e+13,
  0.13241622158268241366900169169173e+14,
 -0.62037906140608420535741762485832e+14,
  0.26151683798533336042574129461660e+15,
 -0.10071966588228620007089635924911e+16,
  0.35865997621439551440873609309730e+16,
 -0.11921925817099686397831366522950e+17,
  0.37280333868211498043857261308367e+17,
 -0.11037715061837546829331064763917e+18,
  0.31109508112678414584323654984683e+18,
 -0.83852807776695629674417713905174e+18,
  0.21700316722425261677319758339786e+19,
 -0.54103163709602207907666543483944e+19,
  0.13034156070425718351603512373589e+20,
  0.56811152023803139215189265952682e+08,
 -0.16831921748421196120115766684335e+10,
  0.25589293645981606696296665323162e+11,
 -0.26638505154774146664946490383516e+12,
  0.21369893057620731124954561161675e+13,
 -0.14092658149405913559086092390362e+14,
  0.79570264890711856381347803408725e+14,
 -0.39554226469349733320296260875751e+15,
  0.17665195839769162788519357474986e+16,
 -0.71975872892664525459682605757475e+16,
  0.27076864671735797946768842762431e+17,
 -0.94954161305892073827239623785438e+17,
  0.31284581053130912736504208412395e+18,
 -0.97468740674855670344082155231997e+18,
  0.28872823921995018298809159025797e+19,
 -0.81699453146483495748203082695473e+19,
  0.22171189701081187054166961083081e+20,
 -0.57903207638658103686240710196767e+20,
  0.23174385015942226542188374420461e+09,
 -0.73117881964062446688600145307369e+10,
  0.11828605679207301400394295822685e+12,
 -0.13089215619162201179983857450284e+13,
  0.11148233494447276294776691637131e+14,
 -0.77952632227284337852611964230612e+14,
  0.46605976842889741503784408226707e+15,
 -0.24499303403452532135968496605029e+16,
  0.11555090747102490174878246090058e+17,
 -0.49656060388620062006515282852314e+17,
  0.19677322955336374450040510242567e+18,
 -0.72599436002939635413697966954634e+18,
  0.25135571921421714716516004468982e+19,
 -0.82199492005493888422131790485698e+19,
  0.25530719135359514682964202666081e+20,
 -0.75666862357769421846335680621313e+20,
  0.21485662566822198668111546784263e+21,
  0.94295788579446284312993844899567e+09,
 -0.31574365757246581427347323510753e+11,
  0.54165050105890369571442680239354e+12,
 -0.63494017384249883175603936512826e+13,
  0.57222612607276445061229228899775e+14,
 -0.42288092702818490519889262154211e+15,
  0.26688739069083398023802019820387e+16,
 -0.14791530597869080634900002088208e+17,
  0.73465998606939453247084722554019e+17,
 -0.33207077191001151497596619324370e+18,
  0.13825314798230174487427939744583e+19,
 -0.53531959680279010865041216229842e+19,
  0.19430122660893438314604152691095e+20,
 -0.66544899916141280673116369864950e+20,
  0.21623973396862505354811950898899e+21,
 -0.66986700452382155053549357423598e+21,
  0.38289809220541563298089105003712e+10,
 -0.13564428923237607985320934520667e+12,
  0.24598214282023165805475163778595e+13,
 -0.30451864272041379626096218555879e+14,
  0.28952712354482259288757798469550e+15,
 -0.22547922425332056376766013843373e+16,
  0.14979726264622828459905961727001e+17,
 -0.87296862931471734918184776330951e+17,
  0.45541850181083391285827154618687e+18,
 -0.21598952899299420089720195728170e+19,
  0.94255293572016914540338981722145e+19,
 -0.38215234670411416568720708400161e+20,
  0.14510062016952372133382953756612e+21,
 -0.51936228817517205692595049304854e+21,
  0.17622133051967702314421007511827e+22,
  0.15521485832560446948377188754992e+11,
 -0.58009498679371403193156308056953e+12,
  0.11089043707948559757843024748441e+14,
 -0.14457670119110816550609647474745e+15,
  0.14462514781281325374486119040042e+16,
 -0.11838473888814822012936019325160e+17,
  0.82582712387330013839699618017478e+17,
 -0.50482884193980695002241699627996e+18,
  0.27598607557093465588422041697067e+19,
 -0.13703134513296558758871723877328e+20,
  0.62545205070529423765361360051723e+20,
 -0.26498889750795067361412581986641e+21,
  0.10504541865847380042545696407960e+22,
 -0.39221207321629691206084731638626e+22,
  0.62829278985075852123151490922219e+11,
 -0.24709031169314783300483207998401e+13,
  0.49663069399931742189197457661560e+14,
 -0.68021147019896416254915903381482e+15,
  0.71417003294983272243755165648901e+16,
 -0.61300505227439673041204667098820e+17,
  0.44798686856888177558215160765442e+18,
 -0.28663467673834457459998798213029e+19,
  0.16386533294892177476375514620927e+20,
 -0.85006145193671636511626893482938e+20,
  0.40502284411180058050221426331246e+21,
 -0.17897941510507317193816487135183e+22,
  0.73941428493617689026702242355774e+22,
  0.25401807744155384701431335325459e+12,
 -0.10487279574603518572580833351276e+14,
  0.22111244727764686609321702846307e+15,
 -0.31742515685311403569536587874459e+16,
  0.34901977013843277064656474581778e+17,
 -0.31346714835589083046538605725115e+18,
  0.23949789484981774249773012567199e+19,
 -0.16006860382017167543293560884304e+20,
  0.95508958543522607797400838441008e+20,
 -0.51669358586435964821303893440968e+21,
  0.25653264157483655743147062549530e+22,
 -0.11803486731213837081052334570469e+23,
  0.10259295236025181212307336974074e+13,
 -0.44369305482292888496463558076870e+14,
  0.97922467626714792946044397383568e+15,
 -0.14703685291598423097054557572811e+17,
  0.16896967352776277364927533876983e+18,
 -0.15848211091887276615701621628751e+19,
  0.12635029172248564370193421557772e+20,
 -0.88049685452538912739028193985452e+20,
  0.54736793482120871689697607074834e+21,
 -0.30828707626420571316951992497166e+22,
  0.15923297441147793267942892080946e+23,
  0.41398364061414879497249203474577e+13,
 -0.18717742159105874325144256025488e+15,
  0.43157481198568605327274046025599e+16,
 -0.67653325029334986250091958236504e+17,
  0.81103925054761542955441597014991e+18,
 -0.79298212428051455849105264382911e+19,
  0.65855376922091787295580771108896e+20,
 -0.47770570853380117284794224938285e+21,
  0.30890206903265653889688486507536e+22,
 -0.18084363058128933817468004327954e+23,
  0.16692174871346921993365118098883e+14,
 -0.78757938735467438237907971381261e+15,
  0.18937434086430240705331419905804e+17,
 -0.30937371084037835306740457130033e+18,
  0.38624876552996865372104707325436e+19,
 -0.39302608018152348663738423509698e+20,
  0.33945802003788067123376245369554e+21,
 -0.25591764880638573170410568539160e+22,
  0.17187742129655162440176859586389e+23,
  0.67258845752052082241739589884823e+14,
 -0.33060415738657046011728668493014e+16,
  0.82763831307998489927865898933978e+17,
 -0.14067953138483666172811303807400e+19,
  0.18262634725969855469335740285294e+20,
 -0.19310257938853170595251196846380e+21,
  0.17319978098689134191753314853294e+22,
 -0.13551400284478084543017715105133e+23,
  0.27084968975082208303527709829580e+15,
 -0.13847938910819256987148141410054e+17,
  0.36037754661042492138807647179048e+18,
 -0.63639569215011427911969453224944e+19,
  0.85778232660100657028272488240015e+20,
 -0.94114940281932893678044524973304e+21,
  0.87542098386436764351765447973429e+22,
  0.10901339282874083832439300720307e+16,
 -0.57889991773380009347955855649512e+17,
  0.15638642684824214649538662841519e+19,
 -0.28651380617994548166035123399250e+20,
  0.40042990237983625451596729333493e+21,
 -0.45529707612857679316871109177984e+22,
  0.43856054373772734354512011855691e+16,
 -0.24156424329836823889067831554964e+18,
  0.67651405716402707992532997075789e+19,
 -0.12842215997086476996113650362590e+21,
  0.18586870434931111254544507953927e+22,
  0.17635969537523200294095067913537e+17,
 -0.10063150415454155151263599272275e+19,
  0.29180387317947395862477817470968e+20,
 -0.57325540596083365604875167139561e+21,
  0.70893765395655831177854533526629e+17,
 -0.41856410072403483975662852527252e+19,
  0.12552529223030017700587278016720e+21,
  0.28488656070222266580294088107554e+18,
 -0.17384627881743174449497147253921e+20,
  0.11444722381343439109843062120372e+19}
};
static const Standard_Real TransMatrix_C2[2][496] = {
 {0.10000000000000000000000000000000e+01,	
  0.00000000000000000000000000000000e+00,
  0.00000000000000000000000000000000e+00,
  0.12109122981248476857010221954881e+01,
 -0.94353526116542141659962602867164e+00,
  0.87934559331661608236419185442392e+00,
 -0.85117240159962484939373054225095e+00,
  0.83581922710498161610141902746677e+00,
 -0.82639920373943004950893933424038e+00,
  0.82015851631932918339227237485006e+00,
 -0.81579277339289945955386585846860e+00,
  0.81261098143852138758936141679395e+00,
 -0.81021643755250714374279196086506e+00,
  0.80836705406118269335850715357288e+00,
 -0.80690780525583574408799158806371e+00,
  0.80573545612438302214888173994948e+00,
 -0.80477899002158728203596568591038e+00,
  0.80398819355652012591889602509683e+00,
 -0.80332671652206729396173001464941e+00,
  0.80276770099443331495005852306951e+00,
 -0.80229094359780872613681446472157e+00,
  0.80188100374325510799279460846419e+00,
 -0.80152591278919579953974392684652e+00,
  0.80121627485456341528680152302585e+00,
 -0.80094462877993072077560569794625e+00,
  0.80070498780806224747296673366365e+00,
 -0.80049250245177567491248506170989e+00,
  0.80030321018350812846762046553909e+00,
 -0.80013384725100239715582446721245e+00,
  0.79998170556857401006367266467402e+00,
 -0.79984452273200534143218674563843e+00,
  0.10000000000000000000000000000000e+01,
  0.00000000000000000000000000000000e+00,
 -0.36327368943745430571030665864644e+01,
  0.16983634700977585498793268516089e+02,
 -0.32535786952714795047475098613685e+02,
  0.51070344095977490963623832535057e+02,
 -0.72716272758133400600823455389609e+02,
  0.97515106041252745842054841440365e+02,
 -0.12548425299685736505901767335206e+03,
  0.15663221249143669623434224482597e+03,
 -0.19096358063805252608349993294658e+03,
  0.22848103538980701453546733296395e+03,
 -0.26918622900237383688838288213977e+03,
  0.31308022843926426870614073616872e+03,
 -0.36016374888759921090055013775742e+03,
  0.41043728491100951383834249981429e+03,
 -0.46390118768211211265520300648087e+03,
  0.52055571230629960648720104949281e+03,
 -0.58040104781897528670889231217926e+03,
  0.64343733676544259836172520070670e+03,
 -0.70966468831278077057362322849081e+03,
  0.77908318723109831715263109689482e+03,
 -0.85169290017040091044987001897648e+03,
  0.92749388012715977465815139822176e+03,
 -0.10064861696747342450735191842152e+04,
  0.10886698033344149178809796839255e+04,
 -0.11740448093392064244619992229458e+04,
  0.12626112109620817827118910092612e+04,
 -0.13543690275275957990377978212931e+04,
  0.14493182751903936786751223830968e+04,
  0.10000000000000000000000000000000e+01,
  0.36327368943745430571030665864644e+01,
 -0.45289692535940227996782049376239e+02,
  0.18700749617866702018278480104082e+03,
 -0.48772178611658503870260760070979e+03,
  0.10205352762951825532598326325369e+04,
 -0.18715187300685625854545779456097e+04,
  0.31395668004703921140256186509260e+04,
 -0.49363620718004346297604423095935e+04,
  0.73863629509490132393914321581847e+04,
 -0.10626798794938683697330459358706e+05,
  0.14807667696292744576941134039148e+05,
 -0.20091735381601891415876294545590e+05,
  0.26654534624050714755707156839269e+05,
 -0.34684364911950368681186049131365e+05,
  0.44382292252836061671058844308078e+05,
 -0.55962149053076773899255998010522e+05,
  0.69650534041380017705011927637080e+05,
 -0.85686812218762232774681483004170e+05,
  0.10432311482499000303964659297197e+06,
 -0.12582433931556074580754854138029e+06,
  0.15046814934559539120305623042375e+06,
 -0.17854497475836459641385647097478e+06,
  0.21035801157698288140710792840118e+06,
 -0.24622322199830752925443964263633e+06,
  0.28646933438839691809311321326018e+06,
 -0.33143784327908822096906285740448e+06,
  0.38148300936538952245100991068222e+06,
 -0.43697185950347189013657369506393e+06,
 -0.12109122981248476857010221954881e+01,
  0.43402622013609385163582797318895e+02,
 -0.37460122275287845108714572998459e+03,
  0.16860022930885369016791014580907e+04,
 -0.53250042958858378761821406239908e+04,
  0.13590961304698666594224016290917e+05,
 -0.30080133744527717130094981620001e+05,
  0.60081506174840259397223112744495e+05,
 -0.11102362542782313539650657505861e+06,
  0.19297248979763083645379573248707e+06,
 -0.31918049782784174174183311555964e+06,
  0.50668645960112847379963708584238e+06,
 -0.77696667166346192634305591742459e+06,
  0.11566370560721174748847358722198e+07,
 -0.16782063637965893978770594557779e+07,
  0.23808804425869065162287203358976e+07,
 -0.33114175693697384186023063577203e+07,
  0.45250348472056321042507450086836e+07,
 -0.60863656668265210223312766798858e+07,
  0.80704682327648778020697368301464e+07,
 -0.10563885154081471118070988875608e+08,
  0.13665754099696101834686540096221e+08,
 -0.17488969518324134519063630369879e+08,
  0.22161395423020675988670215117908e+08,
 -0.27827129240333642138277330352595e+08,
  0.34647816724066559828902415042903e+08,
 -0.42804017933651690851673345259524e+08,
  0.52496624277133890929081720328583e+08,
 -0.14153028917481321248994390430075e+02,
  0.31392637681403194140401649202934e+03,
 -0.26296120175018810097169911372301e+04,
  0.13161645369222145508749045425519e+05,
 -0.48223935249068912374773077035787e+05,
  0.14374449653519557266354419472640e+06,
 -0.36999954920125597828281764464500e+06,
  0.85316384490062193432417594468220e+06,
 -0.18054644335981930014235565502087e+07,
  0.35659293764037436856450486438772e+07,
 -0.66539271782396989920771166734489e+07,
  0.11837896975272354533601526372263e+08,
 -0.20221873771520499074007827745794e+08,
  0.33352617277923712868894949624860e+08,
 -0.53350357165785898271781742152293e+08,
  0.83066371805044967375791006673447e+08,
 -0.12627082181631112858584152421018e+09,
  0.18787446402408687216691636816954e+09,
 -0.27418807565704196977245254441321e+09,
  0.39322362289967155365133495707262e+09,
 -0.55504141215811712064060195118274e+09,
  0.77214766666138041402702443610893e+09,
 -0.10599471752776092753221227945442e+10,
  0.14372558646835831197879357758615e+10,
 -0.19268783502839738990937306317143e+10,
  0.25562557255354064042468536054679e+10,
 -0.33581890535887896117892035510207e+10,
 -0.94676208880422331534544656326309e+02,
  0.19018596141342017634853515236055e+04,
 -0.16667071207700438406678396826715e+05,
  0.92601178966445953923855734075289e+05,
 -0.38456178340692363414599290163666e+06,
  0.13047854881067905388061294849615e+07,
 -0.38144110794946959595871913767612e+07,
  0.99429015817321128373543186068756e+07,
 -0.23656990367462107249184955851948e+08,
  0.52243259837691043018796579561039e+08,
 -0.10841972763884197514812669839807e+09,
  0.21345268198948235881720116137421e+09,
 -0.40162629147542460035832313967044e+09,
  0.72649503267305598430417915630207e+09,
 -0.12694435482104632258231096438969e+10,
  0.21511859854078869543921642250900e+10,
 -0.35469579884870291909052116510855e+10,
  0.57062901425365172254131663403467e+10,
 -0.89784026120021831440630860071931e+10,
  0.13844427797469536168886255297890e+11,
 -0.20957851868955673302692132105817e+11,
  0.31194767838862681736313258303205e+11,
 -0.45715753230198123758953597892665e+11,
  0.66041425192674251443520655113511e+11,
 -0.94143985937889964223498943928795e+11,
  0.13255735242201198777996081420575e+12,
 -0.52074727529865048285908434574913e+03,
  0.10476994011760944557831287509296e+05,
 -0.98321435550044218304647135105060e+05,
  0.60283759928512658968660742537587e+06,
 -0.27942452494976252998693057997681e+07,
  0.10607303789018468398372985088770e+08,
 -0.34640162096138901345065225995552e+08,
  0.10053555316948257954603462176250e+09,
 -0.26527290741217740934063557701145e+09,
  0.64697126201621220411083362360353e+09,
 -0.14767388107769068584767322335509e+10,
  0.31851493044263165131004911282287e+10,
 -0.65413636805951484137865556849921e+10,
  0.12870077616025383207389847997766e+11,
 -0.24380740697883705557493924863545e+11,
  0.44655290625321230803474358140987e+11,
 -0.79355461037403955450351526911402e+11,
  0.13722909698921604759543025537982e+12,
 -0.23151745181186398157896885347751e+12,
  0.38189281168750249006354969882984e+12,
 -0.61708873615438682780662112503510e+12,
  0.97842452141829313816761041300752e+12,
 -0.15244720706244779229713598188370e+13,
  0.23371681505959169505325348101171e+13,
 -0.35297390683124668430733749256177e+13,
 -0.25952187001609679179949060802843e+04,
  0.54333386505285413097928449971065e+05,
 -0.54983192603043165789136970789270e+06,
  0.36963244245322917352601840500869e+07,
 -0.18906791632314620046705555337107e+08,
  0.79300585239467428909569332374404e+08,
 -0.28575482085495594813142077412406e+09,
  0.91279091880880048328255692545844e+09,
 -0.26426855024487638203990608164294e+10,
  0.70488958607183853398134082066992e+10,
 -0.17538987321025542135890188504891e+11,
  0.41106986373441670406134917909193e+11,
 -0.91457288063198622527399727543074e+11,
  0.19437565558290672282352756255392e+12,
 -0.39667462338022014043145185563288e+12,
  0.78067805518947383207310301989962e+12,
 -0.14870921012417998642418585817300e+13,
  0.27503109856944332677625924133531e+13,
 -0.49518162493221559656045628128210e+13,
  0.86994569342258209950548761404157e+13,
 -0.14943177680830605920561013421928e+14,
  0.25141349291180355637531816590574e+14,
 -0.41496438527321111397022095296896e+14,
  0.67284550181255670028085932100501e+14,
 -0.12205325954085853666925956152920e+05,
  0.27017603261840176292937994267141e+06,
 -0.29504589602963114386808969114086e+07,
  0.21613691972820851262806575405682e+08,
 -0.12091638596614195820689535629343e+09,
  0.55495513726998090925060081496800e+09,
 -0.21855447503540323587831616578981e+10,
  0.76140994959576153492588073104863e+10,
 -0.23982381375959842358466164016679e+11,
  0.69408969664159476592059297780480e+11,
 -0.18688899737487985242399564698109e+12,
  0.47275710223942085948699271364766e+12,
 -0.11323513073422598629559849596369e+13,
  0.25845785856238474347511389499781e+13,
 -0.56514862607762008421620711332108e+13,
  0.11891246967140201483632566137549e+14,
 -0.24166711086062262128011014189700e+14,
  0.47591689467672899667604251115853e+14,
 -0.91069860236996320953270694083246e+14,
  0.16974518444976032142029063258644e+15,
 -0.30882911103016007481782912277640e+15,
  0.54947303387769030117968088336978e+15,
 -0.95763279950493837228709515953409e+15,
 -0.55299187962830770190223964874266e+05,
  0.13025143210256647067107315224116e+07,
 -0.15322337451982522159434536642958e+08,
  0.12161725592690091209637450376888e+09,
 -0.73874007516410257027859982475199e+09,
  0.36813200889423608942969083229120e+10,
 -0.15723266566074898738902575753055e+11,
  0.59302011886128607567264557723334e+11,
 -0.20179335326469089955972043761393e+12,
  0.62955232893106979900684955923951e+12,
 -0.18231660258431625183519727058225e+13,
  0.49492967813768117123711764391359e+13,
 -0.12694420129508599402109575034845e+14,
  0.30963164977506170878253196758105e+14,
 -0.72206785577085877547657090514840e+14,
  0.16172520565560064358980177303144e+15,
 -0.34923468084214049050345878338542e+15,
  0.72951329659420528404650786663172e+15,
 -0.14783202847595162445120663698329e+16,
  0.29134499122550426742792812996532e+16,
 -0.55963139212883573052210386565307e+16,
  0.10497663301257190444948812425545e+17,
 -0.24422143519231213250826216045217e+06,
  0.61321785662820796082036608486399e+07,
 -0.77486118681670751778332154072787e+08,
  0.66296850099748851905992933495204e+09,
 -0.43457977278310517584550304226256e+10,
  0.23363160641038252604164023277767e+11,
 -0.10753298794840094322121023174252e+12,
  0.43638123922008419654928678103981e+12,
 -0.15948743325386996666470365794399e+13,
  0.53340067956119550779582510598949e+13,
 -0.16527853451159061814606926580519e+14,
  0.47915481409620080247566290364111e+14,
 -0.13100263248487828551744463287902e+15,
  0.33998969960744186268290192047605e+15,
 -0.84216947919092468087908491297637e+15,
  0.20002257448915605808480436153661e+16,
 -0.45730765351891900257691807993782e+16,
  0.10098454417383440742490862758306e+17,
 -0.21601877326693985383053943521151e+17,
  0.44877756771584859869503154274199e+17,
 -0.90751331340168763077569326786642e+17,
 -0.10589705957836523018183028774760e+07,
  0.28334476234342289829390116041541e+08,
 -0.38335205178660922888802035936611e+09,
  0.35193101652271956236290609991897e+10,
 -0.24764973682055489617459161755209e+11,
  0.14285474856135072145388126666194e+12,
 -0.70476130357655343810625638871148e+12,
  0.30612867415172167438824917901500e+13,
 -0.11957094500923221323121816167381e+14,
  0.42667925101642829657146657984276e+14,
 -0.14082824250418196399313359200043e+15,
  0.43416596492609494920029306559173e+15,
 -0.12602655658652904914594455655590e+16,
  0.34670921944181798914030179477606e+16,
 -0.90898205671938983519592721871266e+16,
  0.22816779319354234643214495941245e+17,
 -0.55054388387541712629985306376938e+17,
  0.12813280353164047875361697541092e+18,
 -0.28850763179412681411821635501124e+18,
  0.63011473276668386326276177158752e+18,
 -0.45296611667145837482358348773893e+07,
  0.12895796674227495516434406508679e+09,
 -0.18620383289604179883652032859145e+10,
  0.18265586729089497457303757068435e+11,
 -0.13735403489198050254400640082366e+12,
  0.84619412439257929498317845960324e+12,
 -0.44540352219075021521296280210478e+13,
  0.20616315920980427690659222379740e+14,
 -0.85689821693947273687981385699696e+14,
  0.32491867340957856222032612179167e+15,
 -0.11378805950077514417150356146899e+16,
  0.37167564891090038295356034608453e+16,
 -0.11414332811363356842517500444659e+17,
  0.33176346799820273350245231344253e+17,
 -0.91771203177011896730269208761609e+17,
  0.24273185930114996544185292096149e+18,
 -0.61636771390729183875858600297050e+18,
  0.15078523179465514236704630716455e+19,
 -0.35645272532073535021688766016761e+19,
 -0.19174508174507354849508884313196e+08,
  0.57966538287754568800796343115107e+09,
 -0.89043499462868265443358696316195e+10,
  0.92983660158463800713578233469756e+11,
 -0.74422941522330416962253188738132e+12,
  0.48769291083813866774670840826073e+13,
 -0.27278955559491245772954929167703e+14,
  0.13402650226296482544334137921605e+15,
 -0.59057916218854785329728494287356e+15,
  0.23710185593033893799377541315640e+16,
 -0.87801855345616781289607994268139e+16,
  0.30286977820496780683415910229460e+17,
 -0.98101196277999293129905780679014e+17,
  0.30036153853861797233891497724000e+18,
 -0.87415720963315695128871646164023e+18,
  0.24297932445479987243144946860102e+19,
 -0.64766620501604148776131282973368e+19,
  0.16613681903191844249372636287585e+20,
 -0.80509080955214678889994920993204e+08,
  0.25786393455028672005349359011927e+10,
 -0.42014371346736940903649398496866e+11,
  0.46547236663678248472858991728097e+12,
 -0.39513832703266321711914431253716e+13,
  0.27444196382138775563252906720495e+14,
 -0.16255567874599510667622046123033e+15,
  0.84485980149042956179362223412951e+15,
 -0.39337542436750046329231476113199e+16,
  0.16668567777432543457077078521421e+17,
 -0.65072166275750658421830156402435e+17,
  0.23635908245328665562159883369088e+18,
 -0.80522923117786644908742870761158e+18,
  0.25902000161155816336454244245947e+19,
 -0.79113387931379499268857186947908e+19,
  0.23053822554591867696644377969533e+20,
 -0.64356797194267687633877502707040e+20,
 -0.33584927457984363097474882598316e+09,
  0.11370505974809588318858418703461e+11,
 -0.19595217797855688057259693711237e+12,
  0.22961943548867007542990694734960e+13,
 -0.20608498135381886303664356472308e+14,
  0.15122857880174348288068752909074e+15,
 -0.94558744247956735807185548072020e+15,
  0.51830497866799234132638543471207e+16,
 -0.25425438735939550939461812618507e+17,
  0.11338792388285193175536230904325e+18,
 -0.46538701462362283899091767743263e+18,
  0.17753639936496821431412060165741e+19,
 -0.63457491648987177897499525275820e+19,
  0.21394702508537449778663923052291e+20,
 -0.68423414000786602229433549560191e+20,
  0.20857568517362740352286942954523e+21,
 -0.13936612381575954554242808916693e+10,
  0.49761539934028260461198959029852e+11,
 -0.90467474365620115811776150257183e+12,
  0.11181656488011886971655509386628e+14,
 -0.10580171427070788879364494576303e+15,
  0.81796675343457657629103310111202e+15,
 -0.53840565785224943374639429798458e+16,
  0.31039576136542567815845369876564e+17,
 -0.15999929918166089793889656484483e+18,
  0.74907098159786180898170765588876e+18,
 -0.32244964713381854321732569988358e+19,
  0.12888841923157833809458943623542e+20,
 -0.48226011017384176134935776363416e+20,
  0.17005041479106081232270507671668e+21,
 -0.56827641952214794194253726532273e+21,
 -0.57582438265628557010368398186530e+10,
  0.21635893354277222132234338539339e+12,
 -0.41395131594898799310927879874901e+13,
  0.53829170956366818378707477482746e+14,
 -0.53559700727031079987703939304969e+15,
  0.43513907235718183358563253071059e+16,
 -0.30075960304213767421615768267712e+17,
  0.18192285199830710125111362106766e+18,
 -0.98306064270487754202385241094923e+18,
  0.48205670954933869909057672811783e+19,
 -0.21715545668726582037674266672661e+20,
  0.90756895972881799070273292473215e+20,
 -0.35475811290588197829191425860152e+21,
  0.13057176984767450696246633447479e+22,
 -0.23705994261630906965874043769955e+11,
  0.93537084744033954730070841391827e+12,
 -0.18791387378560079082034725609386e+14,
  0.25649324375827299895628529746118e+15,
 -0.26774257875240917620805996828275e+16,
  0.22806065547962158145955909671179e+17,
 -0.16514824059319504137604317660569e+18,
  0.10457859494711038143710233531028e+19,
 -0.59114566478065215293524523402711e+19,
  0.30298660989580974554553819020519e+20,
 -0.14254728550336891955518529933306e+21,
  0.62170594814013264019129851210293e+21,
 -0.25340423943152085493380359898489e+22,
 -0.97299325323197595072889224748779e+11,
  0.40236388338177170251550895911541e+13,
 -0.84701500788912551623179055195962e+14,
  0.12109720919673719939532492163168e+16,
 -0.13233433051454776840537036166036e+17,
  0.11793274510548436716501145870374e+18,
 -0.89288134425312045492994271504191e+18,
  0.59073076262175524776070735859743e+19,
 -0.34861887161287346603639829859426e+20,
  0.18640965488023430467127428190272e+21,
 -0.91426360656414928297257727155642e+21,
  0.41538082974188161770197522070066e+22,
 -0.39833016024009980574843618759546e+12,
  0.17231743371421262045234004671482e+14,
 -0.37936811249898224329253931683917e+15,
  0.56699733458974687875988355567687e+16,
 -0.64739535387642233452036849845682e+17,
  0.60245491263149833061545376195741e+18,
 -0.47599272982512422061281434423733e+19,
  0.32841572763046701451363197262271e+20,
 -0.20198444778472370770804241301885e+21,
  0.11247876331293740775129213920066e+22,
 -0.57413164108115732109906957748237e+22,
 -0.16271156994629860634293770053846e+13,
  0.73506244193396954363117728092792e+14,
 -0.16894210810077623540557695731329e+16,
  0.26348280464050908862926477240807e+17,
 -0.31377073495767990189487661960626e+18,
  0.30436381025787256663936718328642e+19,
 -0.25051469071443176051192483367632e+20,
  0.17994959009446737389589149586575e+21,
 -0.11514993591733526059141714783581e+22,
  0.66674289372603302410041087778081e+22,
 -0.66338622871634180804888406058848e+13,
  0.31245123202198514098329979867916e+15,
 -0.74843727661583343953400352400991e+16,
  0.12160171524713322428047464645904e+18,
 -0.15078325993471331731463642921429e+19,
  0.15221310331086081583459152874444e+20,
 -0.13030582211773220469006881001226e+21,
  0.97296968986994108672738560815477e+21,
 -0.64680403423976583453158561880621e+22,
 -0.27001958322887604776334550503137e+14,
  0.13239019851349893333375660579161e+16,
 -0.33000143721211076539566973476175e+17,
  0.55769712222313621623641380515572e+18,
 -0.71895270089860446368615291032344e+19,
  0.75416020886297353459718041208282e+20,
 -0.67051193002287267778154188573116e+21,
  0.51967822438483251194122151398149e+22,
 -0.10974754676075391506725024040317e+15,
  0.55934090327239841954319539226875e+16,
 -0.14487590793084813094508910341642e+18,
  0.25430368661841023178095286213214e+19,
 -0.34035025679537003440472865866468e+20,
  0.37046507091892941562841560799230e+21,
 -0.34160745438689203668120618754153e+22,
 -0.44549275481872440494590783455033e+15,
  0.23569949562082302538816968576444e+17,
 -0.63350779970144358635549575645773e+18,
  0.11534548663754508190997135186294e+20,
 -0.16005580210852564412523220532844e+21,
  0.18054540612725605665046650587894e+22,
 -0.18063279798322002689718361334626e+16,
  0.99083585640495016212607260608946e+17,
 -0.27600730900632616085213009216847e+19,
  0.52061674690834873719562564536824e+20,
 -0.74808473418910426104063265918135e+21,
 -0.73167313067860363938916334611161e+16,
  0.41561692638292421950740430257387e+18,
 -0.11984609788178283373950725909483e+20,
  0.23391713564611468452959103818195e+21,
 -0.29610705281453522699179639015212e+17,
  0.17398440916272547936835040282240e+19,
 -0.51876481883223710564738607660455e+20,
 -0.11973792372060700255751224610758e+18,
  0.72697820837999838929189302058856e+19,
 -0.48383896419026738437212119379216e+18},
 {0.10000000000000000000000000000000e+01,	// TransMatrix_C2[1][0]
  0.00000000000000000000000000000000e+00,
  0.00000000000000000000000000000000e+00,
  0.46898431643552857726090232235943e+01,
 -0.66913959883896798115968973531651e+01,
  0.84844427791016768656133841912849e+01,
 -0.10201293243439949484350463958681e+02,
  0.11880237080175374041841933729973e+02,
 -0.13537148805818713137005533326070e+02,
  0.15179970264205455676750583702659e+02,
 -0.16813172349364017485605103510241e+02,
  0.18439486329538928065888722367383e+02,
 -0.20060684387556143800117934738270e+02,
  0.21677971065463833972028421504313e+02,
 -0.23292195926944090010453233559759e+02,
  0.24903976544606024828978337070369e+02,
 -0.26513773296262308229485373139379e+02,
  0.28121936777782654295694836730682e+02,
 -0.29728738921153920431905739236557e+02,
  0.31334394032001695624680650301789e+02,
 -0.32939073380412897916048776924308e+02,
  0.34542915548833671132238496195493e+02,
 -0.36146033916451341512379718304056e+02,
  0.37748522167714823906460425668698e+02,
 -0.39350458410355005551051594354173e+02,
  0.40951908297428442960714242116032e+02,
 -0.42552927424536247366190167857293e+02,
  0.44153563191894803214978685717654e+02,
 -0.45753856266081578257190299718254e+02,
  0.47353841738697282967862934749772e+02,
 -0.48953550053022494684289404620155e+02,
  0.10000000000000000000000000000000e+01,
  0.00000000000000000000000000000000e+00,
 -0.14069529493065857317827069670783e+02,
  0.57992098566043891700506443727431e+02,
 -0.13292293687259293756127635233013e+03,
  0.24483103784255878762441113500835e+03,
 -0.39996798169923759274201176890908e+03,
  0.60465931332656918678624715523113e+03,
 -0.86525830505971097357478327105154e+03,
  0.11881308460217239023160939813903e+04,
 -0.15796493288971681709778005494725e+04,
  0.20461898075307266676120293433036e+04,
 -0.25941305375005054653194011066828e+04,
  0.32298511685362471481161817202866e+04,
 -0.39597322705923579478075555941887e+04,
  0.47901550421913903534603574138478e+04,
 -0.57275011237417339248898484141488e+04,
  0.67781524740230938584745085459349e+04,
 -0.79484912861177634567939916265537e+04,
  0.92448999287692200151043567234224e+04,
 -0.10673760904589604379861695324407e+05,
  0.12241456819704854325525931265640e+05,
 -0.13954370361331913237421537355529e+05,
  0.15818884280962712231522740930377e+05,
 -0.17841381381579658316551171481884e+05,
  0.20028244507815060427020172338166e+05,
 -0.22385856538290665229994193658850e+05,
  0.24920600379592432957416316579876e+05,
 -0.27638858961486314158909332915617e+05,
  0.30547015233086036682996588482977e+05,
  0.10000000000000000000000000000000e+01,
  0.14069529493065857317827069670783e+02,
 -0.13382791976779359623193794706330e+03,
  0.57354833186727335611546477133086e+03,
 -0.16587302813833357861553854396816e+04,
  0.38610770510569965635986284622411e+04,
 -0.78244720097632161931891982624685e+04,
  0.14390611810466771981559553350120e+05,
 -0.24624572222878540009417234601098e+05,
  0.39840354163601807979159173546968e+05,
 -0.61626422438572473753962295515966e+05,
  0.91871241375435728373456450335280e+05,
 -0.13278880897950825714959388452419e+06,
  0.18694419032973958598120878505243e+06,
 -0.25727905055761093413563426679528e+06,
  0.34713718758494908462605706460353e+06,
 -0.46029006471622615004719656059961e+06,
  0.60096234313976052038575019213801e+06,
 -0.77385741437006845848048354554892e+06,
  0.98418293265114942443128633820350e+06,
 -0.12376763473332103847253939344492e+07,
  0.15406304352309451080943693528166e+07,
 -0.18999188329687603780158730786082e+07,
  0.23230215693166068840122918125772e+07,
 -0.28180505975189431673269973902821e+07,
  0.33937753276186102595129067203160e+07,
 -0.40596481587768862756039809134013e+07,
  0.48258300115906401072549116803493e+07,
 -0.57032158604072584892058947907001e+07,
 -0.46898431643552857726090232235943e+01,
  0.12044512779101423660874415235697e+03,
 -0.10079518021572792116348700419246e+04,
  0.47823662725246483182634975038298e+04,
 -0.16328537278338181950937320630867e+05,
  0.45217944768236164367066197175739e+05,
 -0.10831559353664772859176259354006e+06,
  0.23317852467885968570436005956282e+06,
 -0.46234799232959317453848064689530e+06,
  0.85863741315617806693264784266745e+06,
 -0.15115182105105312875336537178098e+07,
  0.25447056795842517537706021281659e+07,
 -0.41250470015220137068530134223764e+07,
  0.64728135351075564537347165983162e+07,
 -0.98734995149323787926012743967954e+07,
  0.14691229285100159783357450592965e+08,
 -0.21383875197593269163802687672603e+08,
  0.30519988304467318197616655488454e+08,
 -0.42797643973062007541834359857272e+08,
  0.59065304553429571273740807916472e+08,
 -0.80344801227189992806417986319946e+08,
  0.10785653716702706252499943810043e+09,
 -0.14304701413604246576979133056631e+09,
  0.18761878465618712273135124396635e+09,
 -0.24356293187499035423588725968504e+09,
  0.31319417925980836384777494971348e+09,
 -0.39918873224881415825740707310602e+09,
  0.50462495398795146986666391154781e+09,
 -0.37917910600874852265715751667936e+02,
  0.78452814230760172084038425822081e+03,
 -0.66900081090479188718370342641032e+04,
  0.35300710169803007849375943943646e+05,
 -0.13801445520598983250632784214817e+06,
  0.44003264088442654759888113449161e+06,
 -0.12100051568742986971541436789483e+07,
  0.29730295231551401489195277638021e+07,
 -0.66842400986180946703430959727264e+07,
  0.13984206224668288883959194380848e+08,
 -0.27561749718288836483066972629589e+08,
  0.51654592200043017252691782883603e+08,
 -0.92723451331877457171750175256623e+08,
  0.16034082214643535964665396055908e+09,
 -0.26834170527356847815132805030050e+09,
  0.43628997801071993644128931132088e+09,
 -0.69132094684178134902172537603797e+09,
  0.10704278711838812428727202748725e+10,
 -0.16232679078333249884833612187856e+10,
  0.24155709937905728964699587937541e+10,
 -0.35332436618697094017041265484836e+10,
  0.50872686687403204452529833263688e+10,
 -0.72195106088090571925138368076318e+10,
  0.10109547389624421456533864340682e+11,
 -0.13982657555281461243944733082826e+11,
  0.19119103963613113469461017097182e+11,
 -0.25864865250781874943404034258071e+11,
 -0.22568617792410460462531601948818e+03,
  0.45048910963030816922891648841536e+04,
 -0.40791642603145016442238696742842e+05,
  0.23827315776641766365863596587216e+06,
 -0.10470926631530863247884313344041e+07,
  0.37646531130402898949514919584079e+07,
 -0.11652518685385434793532720265873e+08,
  0.32102792254455896025027929074698e+08,
 -0.80556816552020700895661709699820e+08,
  0.18720805667156071858354796126737e+09,
 -0.40795263818417055025683360157205e+09,
  0.84160443871890386914889427119022e+09,
 -0.16560876957772085091912585498863e+10,
  0.31271812682305085210394258460319e+10,
 -0.56944390758889166386854116752603e+10,
  0.10040176577291975709330352919324e+11,
 -0.17198920801091242466119963912108e+11,
  0.28706500425769013954419692624641e+11,
 -0.46800033344734700046448134249544e+11,
  0.74682484331894985093841287654524e+11,
 -0.11686824874350829648899272160963e+12,
  0.17962940519647808570219120769182e+12,
 -0.27156590802625048608127200093756e+12,
  0.40432709785826507935168635461810e+12,
 -0.59351653626863539765734113983168e+12,
  0.85981736033964860885348407741232e+12,
 -0.11731487229955941907003033552483e+04,
  0.24006564785582952260264878944352e+05,
 -0.23386391501252242566543987787452e+06,
  0.15026469070390929739236892635371e+07,
 -0.73257569945939260000795895443323e+07,
  0.29271344612136435142492225511062e+08,
 -0.10054752034540850215834950872125e+09,
  0.30653615165060881682591744034717e+09,
 -0.84823932262711049909136302385490e+09,
  0.21658373450508754772135075620734e+10,
 -0.51666971029054641113007240112140e+10,
  0.11627415892080436710335904037451e+11,
 -0.24875629196820703390895000439227e+11,
  0.50907802326700957931816622149521e+11,
 -0.10016827412086794926843900916152e+12,
  0.19030749485150397012804015185553e+12,
 -0.35035973859287215694562272049072e+12,
  0.62693969697715139477966884803121e+12,
 -0.10932616090441565500759295861541e+13,
  0.18620436208102653643949157973296e+13,
 -0.31036850412520389743084002327335e+13,
  0.50715078268239159112484641090109e+13,
 -0.81363505064911015361373880985769e+13,
  0.12833409294761243004024918635360e+14,
 -0.19924955853435996203292666036754e+14,
 -0.56600843803406960613632641413513e+04,
  0.12169896776431023110167974460137e+06,
 -0.12794993424009522209098719357783e+07,
  0.89857244896550531111476010770279e+07,
 -0.48115986613438895564987422155408e+08,
  0.21133505715781381303175681746551e+09,
 -0.79697268313806421612568270983480e+09,
  0.26613630945078981803046402630826e+10,
 -0.80444130860944177054229741462539e+10,
  0.22370846796690485646239747089840e+11,
 -0.57952178101047419636787383911684e+11,
  0.14121751555640301788194223324346e+12,
 -0.32623005980874623365322515115050e+12,
  0.71900340129916303329376688329267e+12,
 -0.15197946561643029209273147000096e+13,
  0.30944919737078644153497214202801e+13,
 -0.60919227644534067993999648054323e+13,
  0.11632024281223817016215018693520e+14,
 -0.21601158833521073367827999260824e+14,
  0.39106460280102181628791817981141e+14,
 -0.69162268934509061375266351132130e+14,
  0.11971006616016210983722416378374e+15,
 -0.20311084848960764183790052859094e+15,
  0.33829801387499805944350772731339e+15,
 -0.26078350235209335236074230986008e+05,
  0.59521013712955688757516194480825e+06,
 -0.67483623924065367843924362006043e+07,
  0.51492840525652382757394460666728e+08,
 -0.30042348858651707480630767700694e+09,
  0.14379940275541426441618049353481e+10,
 -0.59027650083032533993082339023379e+10,
  0.21414710555349207703996198688544e+11,
 -0.70163800880243695351585146028233e+11,
  0.21099022125688754989932183713241e+12,
 -0.58958781047352690221265564382941e+12,
  0.15460368964734829962264967560944e+13,
 -0.38343652432055226140606321391856e+13,
  0.90524158189819179990542394407589e+13,
 -0.20452773797119852449365053036802e+14,
  0.44422706708136551572466804766294e+14,
 -0.93105930211896042924332739027466e+14,
  0.18892410947355882487048120742040e+15,
 -0.37218685858852297059248482406955e+15,
  0.71361821800828019675823148464948e+15,
 -0.13345600939482917313965637584195e+16,
  0.24389526459524632065458231290230e+16,
 -0.43630885838395705524178495108722e+16,
 -0.11652261943806140127132799977728e+06,
  0.28335665294082695890266582941764e+07,
 -0.34560326639773355805022278219737e+08,
  0.28497841819829905858493383489214e+09,
 -0.17995118608535947105024227458894e+10,
  0.93209549463906687830843018852063e+10,
 -0.41357190732938604171311811877932e+11,
  0.16191315123346434379704301495784e+12,
 -0.57137691402051966451603812391069e+12,
  0.18468221316777755128735903914467e+13,
 -0.55355981959399413533699506748068e+13,
  0.15538127866073329449475271728823e+14,
 -0.41168678914158829322114742367561e+14,
  0.10363204374412835393674124976812e+15,
 -0.24919123014005346722099655694154e+15,
  0.57499784073258997197342134551786e+15,
 -0.12781559362969757720738065349120e+16,
  0.27462374180158700529900527229675e+16,
 -0.57198928929310663728408049074879e+16,
  0.11577973203964498156960464689550e+17,
 -0.22826436380329276492450731637051e+17,
  0.43919638008038019405288455030956e+17,
 -0.50954485835850461907935521956681e+06,
  0.13209074955993273482105828597022e+08,
 -0.17278097835320375096713568267152e+09,
  0.15321387825658500010757318462258e+10,
 -0.10412158139711404335512585076337e+11,
  0.58019223982088547288162753047088e+11,
 -0.27664297277919018225956461096117e+12,
  0.11621806712318371290262004067321e+13,
 -0.43935412686859002970857328139757e+13,
  0.15186381003146620577787446126994e+14,
 -0.48590991541127880025723850132552e+14,
  0.14533907947038436761375747999490e+15,
 -0.40962841516765671448972493631592e+15,
  0.10950303353111104034841978847445e+16,
 -0.27917034783186841633542816883121e+16,
  0.68191507242177169415569964041226e+16,
 -0.16022364614422988819822528903442e+17,
  0.36336114843192631865580197937154e+17,
 -0.79772276203681944043154655486268e+17,
  0.16997790206449122193325506527033e+18,
 -0.35233114584222218552808745931763e+18,
 -0.21933888303309863715673885124206e+07,
  0.60551127895023993199090459416819e+08,
 -0.84666003340965199797360156791667e+09,
  0.80385065870064827976417071938476e+10,
 -0.58505974907575055834321882598377e+11,
  0.34896190644700660134062667536521e+12,
 -0.17792044938722245116622017552249e+13,
  0.79819913956919308719093702664910e+13,
 -0.32177198567646761280466565632020e+14,
  0.11841763793544905862031183827402e+15,
 -0.40278123700071645057477722524661e+15,
  0.12787155893294811328957625271622e+16,
 -0.38194334711245178347202496257124e+16,
  0.10804615136562619328544944133826e+17,
 -0.29107465697747529902789565636499e+17,
  0.75026952731133754421455152266197e+17,
 -0.18577547648596116462461375729317e+18,
  0.44342558333832530431288465806884e+18,
 -0.10233470319662776632907887215650e+19,
  0.22895079252874894888720035721364e+19,
 -0.93302052416860870023755739352959e+07,
  0.27379618463649587500197972139093e+09,
 -0.40792250758546680370289871662062e+10,
  0.41304298783223790612709045149871e+11,
 -0.32059215902463617521475031690766e+12,
  0.20379468693763254964980556932326e+13,
 -0.11063140455158953854141092165897e+14,
  0.52782034789963966918513392386601e+14,
 -0.22598487660880522940994647600516e+15,
  0.88209051794870228874390903689916e+15,
 -0.31778481779586093043429032068438e+16,
  0.10671110191658036312992635117182e+17,
 -0.33668274400127426543758760403055e+17,
  0.10047228607187908615092660897782e+18,
 -0.28516887917209941830784463095816e+18,
  0.77346340826766197194761980030618e+18,
 -0.20128829064460783699980545064187e+19,
  0.50438313712400319091997138397500e+19,
 -0.12206561178948249003401993278062e+20,
 -0.39325739256732469851232859711977e+08,
  0.12240562152599994675869006075523e+10,
 -0.19372030081289501605363488702598e+11,
  0.20844896381019007126629366522124e+12,
 -0.17189318562076217825468509895658e+13,
  0.11601420949487155879070560210101e+14,
 -0.66804691864156783912226449673796e+14,
  0.33771800938164455642236682951403e+15,
 -0.15303044322761732631752284304720e+16,
  0.63141356639910285674367573082589e+16,
 -0.24016084787328309991404788355956e+17,
  0.85038505599635578322668804950369e+17,
 -0.28257951672287271293165788561304e+18,
  0.88709175838197671790131700872504e+18,
 -0.26456321353115319114601901712057e+19,
  0.75316488996222595377119009277597e+19,
 -0.20550650772493261511750757400046e+20,
  0.53935451996201453791378841538522e+20,
 -0.16455472705146219257654088356246e+09,
  0.54203338461271017040074163947680e+10,
 -0.90857739559405872155542987830191e+11,
  0.10356127290233682952559739425043e+13,
 -0.90428683996863293058774093336568e+13,
  0.64582218376726056199574055111179e+14,
 -0.39317179047248049851202248695411e+15,
  0.20992827430273463070981230777791e+16,
 -0.10036313491576425698288786654280e+17,
  0.43642930512003668143000764440189e+17,
 -0.17475333161758741460004574662322e+18,
  0.65070516881895139414903313142058e+18,
 -0.22713486283192463834802389059302e+19,
  0.74821288777025963096164750323599e+19,
 -0.23391089662113692651537927647966e+20,
  0.69733133181533134569740421967207e+20,
 -0.19905820662533847555828797091999e+21,
 -0.68455562031832961479182691528126e+09,
  0.23807642986154479869634258843205e+11,
 -0.42153873724294483782406111083245e+12,
  0.50747835230801253526474327144783e+13,
 -0.46781700812106814393438026699103e+14,
  0.35248202604791243386887574974018e+15,
 -0.22620441208091301982818633468277e+16,
  0.12719953345719476756354356995009e+17,
 -0.63982821286505847793593111615866e+17,
  0.29244587874178135179121983023024e+18,
 -0.12296014961112551245737852643754e+19,
  0.48028366386555492802167386330743e+19,
 -0.17568933993435415414979699948340e+20,
  0.60592209760723984679362985452428e+20,
 -0.19813632301868237767180769615697e+21,
  0.61727399593032711045700940481120e+21,
 -0.28342432126374380797183641480006e+10,
  0.10383989178365354010287422558298e+12,
 -0.19372130279276925315235876367879e+13,
  0.24566869087805366144997882008021e+14,
 -0.23844375694625572948786788063088e+15,
  0.18903144426141527772421200801133e+16,
 -0.12753987655882852494941507546001e+17,
  0.75337104576719532849138074598134e+17,
 -0.39772124649312929938385647361549e+18,
  0.19061553495611576144202500129432e+19,
 -0.83961087016634046829626587357122e+19,
  0.34325614356398933655170107162456e+20,
 -0.13130586474845159720353001528439e+21,
  0.47314311421425093823674877080755e+21,
 -0.16151186233616498961167800432714e+22,
 -0.11688340184456923763618795375572e+11,
  0.45016155629377842901258683468014e+12,
 -0.88279610738251774089446927158357e+13,
  0.11764500050203214942541873952936e+15,
 -0.11992928220222352808249700389483e+16,
  0.99794415833936682219146384487361e+16,
 -0.70620541595265220160307136315610e+17,
  0.43718344989739136602200726071339e+18,
 -0.24168357366827483545450025584305e+19,
  0.12119313405851902007197566474446e+20,
 -0.55806652278096322631810862432623e+20,
  0.23831628377447432327252161767015e+21,
 -0.95146144579806675832747468899056e+21,
  0.35753785294762014078035019724982e+22,
 -0.48043557908546528242571401946857e+11,
  0.19411386682407177859056207692564e+13,
 -0.39929034372523179828604212746321e+14,
  0.55792956796673414539519538930325e+15,
 -0.59604599092231067454114561253263e+16,
  0.51944108125442154364903855286557e+17,
 -0.38471111947940662192565250418595e+18,
  0.24907000128512818145025923006776e+19,
 -0.14388957193314293771067050446344e+20,
  0.75344372644908654459548590171971e+20,
 -0.36200552650577119622821117107405e+21,
  0.16117870976285443933435561937002e+22,
 -0.67041337179753346457837638674622e+22,
 -0.19692711127079745654114993311297e+12,
  0.83310702240515977428149972020472e+13,
 -0.17939216232887529098705717358290e+15,
  0.26229311109688286848725992113674e+16,
 -0.29305675721933281591528819657160e+17,
  0.26693785605031577602042997900991e+18,
 -0.20650269526953639191344988533419e+19,
  0.13955039344930097751271526269460e+20,
 -0.84091420496273519200079378016192e+20,
  0.45896225148693977180093628391668e+21,
 -0.22968697794892423848095859212367e+22,
  0.10644312711915058888954430467640e+23,
 -0.80527051091668188206207013528142e+12,
  0.35606503359626036311838506909796e+14,
 -0.80111635357778266134245540375509e+15,
  0.12233674672680898623129016606944e+17,
 -0.14268380191274524753021413875116e+18,
  0.13559211793685805556822765214150e+19,
 -0.10936605594488238180731082790045e+20,
  0.77008940639371728416880791892630e+20,
 -0.48320359371950459805135042547177e+21,
  0.27443338441849656812055961054681e+22,
 -0.14282084062864388156223257316042e+23,
 -0.32861593762955625260654430915664e+13,
  0.15161259636921774918175239291840e+15,
 -0.35580807454396333112351724896199e+16,
  0.56650303251106614617685314386887e+17,
 -0.68853390505779418890138120867868e+18,
  0.68147511785455656740219639132742e+19,
 -0.57214903671658659771623788905180e+20,
  0.41909931366223832698987293055100e+21,
 -0.27339410682519186315914588986850e+22,
  0.16132881022156802825717871156399e+23,
 -0.13386429639742440155928534692200e+14,
  0.64340350174334435896227774164130e+15,
 -0.15724655766695781329741388554588e+17,
  0.26061263209103363858243570561901e+18,
 -0.32955895707196253829728696203416e+19,
  0.33918987064142446312869776487981e+20,
 -0.29596969000215014109175427256134e+21,
  0.22519264451956542393449649966647e+22,
 -0.15250238110385942493663822164926e+23,
 -0.54446338182102843843031692422785e+14,
  0.27221703884381094825215049734398e+16,
 -0.69180043212479808435632246409865e+17,
  0.11917238707809330411852509623394e+19,
 -0.15656246334599068833460715112139e+20,
  0.16732195713077145435342830305332e+21,
 -0.15152558008336423173822263537715e+22,
  0.11958868060277072535861690354975e+23,
 -0.22114784562688159112611891325264e+15,
  0.11485592690515715499136170340004e+17,
 -0.30309631706067087659336445887166e+18,
  0.54194279213625638600439845615570e+19,
 -0.73866041690702357479452631369303e+20,
  0.81861737775325793101604747353312e+21,
 -0.76836940087051619069104624267900e+22,
 -0.89717313359790198407792204512023e+15,
  0.48339742424062655219519181351885e+17,
 -0.13228990956683315501232566247786e+19,
  0.24519717300844711926501288999299e+20,
 -0.34628356546928154551370549709673e+21,
  0.39746085438392791043245063368634e+22,
 -0.36358688786007011447346089125702e+16,
  0.20298379608351079341862208908154e+18,
 -0.57537147539946424384655160034387e+19,
  0.11041489389848007275951371991323e+21,
 -0.16138063787247043846546642692348e+22,
 -0.14720714419895327001084369733791e+17,
  0.85056325669125291394438095268276e+18,
 -0.24943676914254255421736861119640e+20,
  0.49503774867533292249601368641348e+21,
 -0.59549967785694906614445506600466e+17,
  0.35572357893101989433609817326331e+19,
 -0.10781168404723088360008633903490e+21,
 -0.24071520378790819917480327514058e+18,
  0.14850597624811314998469901472303e+20,
 -0.97236055876740752966171973925795e+18}
};

// Coefficients de Jqcobi pour C0
static const Standard_Real WeightsDB_C0[] = {
 0.339350899760562168358542462460598e+00,
 0.219855506883882118158113854613575e+00,
 0.786610670785738901620795920210783e-01,
 0.762975064488463751780832420182061e-02,
 0.164694608682536519162825315977163e+00,
 0.305693266475978881881015458286754e+00,
 0.165800332290899167736914460636874e+00,
 0.193848170267298772599508541436324e-01,
-0.224665097858217404701306665106006e+00,
 0.177698877358088118112295250872715e+00,
 0.234528153958433612874624054656395e+00,
 0.360448642916746433553047264500151e-01,
-0.245545559592830018993453062430701e+00,
-0.869125030404281024870394718260156e-01,
 0.248562582762451619411007710771705e+00,
 0.567850844850441557564847622311881e-01,
 0.123520971761124990578192874487093e+00,
-0.269564430588633255502996039964592e+00,
 0.190266896880133280743492853604946e+00,
 0.801798998294048063093919056681329e-01,
 0.288962993142226453692158649124241e+00,
-0.209313374140660398712652691330548e+00,
 0.707698773448244803610857112920900e-01,
 0.104361754047646869869394503497459e+00,
 0.279798214381424393261244369715301e+00,
 0.211745613545742595105803366821231e+00,
 0.114211060080756086349281717232628e+00,
 0.364174003215448537564136080623454e-01,
 0.332493603843488572380117146556015e-02,
 0.110208173489518365851238448827571e+00,
 0.242799469768038248579523289571562e+00,
 0.205299948978395339526064557673514e+00,
 0.833500531872661174006014022488989e-01,
 0.856741081761592855642889513301551e-02,
-0.204718814695597856114831801411806e+00,
 0.577309510036298107922672007368529e-01,
 0.220685449913879612738399782851598e+00,
 0.133670511707113344195027915194792e+00,
 0.162386998209540580300542695016748e-01,
-0.170607766558226555454621937981468e+00,
-0.175753344905342841651521072452125e+00,
 0.131003023158995126537169876588563e+00,
 0.172084967800985245237381674561209e+00,
 0.262195782021132805202756278671211e-01,
 0.145624051218879471687385631807154e+00,
-0.217227845270421479629150854850467e+00,
-0.267108146895899035417060864273147e-01,
 0.184547720405419181402217465224506e+00,
 0.381702262177425522093354380416334e-01,
 0.213132776688305276487726617219696e+00,
-0.229096553230284957341963225399620e-01,
-0.166780066211756882641753631337594e+00,
 0.162870989621313983022672577369250e+00,
 0.515650800790827694369560686614391e-01,
-0.788039492412144109511601641860638e-01,
 0.194659943961623928495498583364618e+00,
-0.207145883088594717206304241379413e+00,
 0.107695249589793688098205463849020e+00,
 0.657288688291550362791506183231160e-01,
-0.235772612483240482966629708519207e+00,
 0.195549680873667286973440687158847e+00,
-0.122552841747465411144482709134268e+00,
 0.289997344660592782722843709714153e-01,
 0.798788950815170054436196794397016e-01,
 0.184353198445827381521353495589588e+00,
 0.152246883272196304139111580109542e+00,
 0.108505415644422244138588051892271e+00,
 0.642204843989956836722444129720047e-01,
 0.291084200231973098623675645848933e-01,
 0.827925977438238622191296822191111e-02,
 0.710793148672013451654276020740368e-03,
 0.981329658883891950148284847777546e-01,
 0.158767075784479199888564828480828e+00,
 0.163913746752530996805776632678060e+00,
 0.123086853229287230902919480880934e+00,
 0.653234768330967026313340428082767e-01,
 0.205308446942647949487550018807583e-01,
 0.185800085165948290707403585645709e-02,
-0.114415885610809609332910774577047e+00,
 0.115351307431775038709969592740643e-01,
 0.120473614248917742389653035135320e+00,
 0.148689086316845495379988674607799e+00,
 0.101746594696863068508340201939734e+00,
 0.369212358814586767550592142834760e-01,
 0.359053141876726045806388971657320e-02,
-0.142973018723633774292415230320349e+00,
-0.140577070601064619553712205047324e+00,
-0.597252426495433461826944017587713e-02,
 0.117232887082566109754427228290668e+00,
 0.125481701792733149137082856351099e+00,
 0.556812408978681216516740064131077e-01,
 0.594164358137316212900266191464473e-02,
 0.505882366531488025552347132194008e-01,
-0.128361364767473459961699127475302e+00,
-0.124503178523144294695735558310879e+00,
 0.347625399826042549242727774807020e-01,
 0.125934626214926703890992669153109e+00,
 0.743766598212934235347764892344325e-01,
 0.891369365159989947778338459686138e-02,
 0.161977406225273811263566844766960e+00,
 0.331113264319962166043811153457335e-01,
-0.142099825690343120148169472806093e+00,
-0.630212039746267711601074287291719e-01,
 0.987947659737638068608774713355029e-01,
 0.902844729090318210736931866900887e-01,
 0.124816040391288536073572668253432e-01,
 0.170842833372133595637837277706841e-01,
 0.154026195091658035579053546100074e+00,
-0.439639616637481188189684331892371e-01,
-0.128544129647994416607612233717471e+00,
 0.480369292431956213314832902559620e-01,
 0.100793115500280635137944795759066e+00,
 0.165949465739378239648199437722780e-01,
-0.153882244866232058193673067140722e+00,
 0.914451400728255407961613067109244e-01,
 0.897617096553521690938316878162056e-01,
-0.128109792556251607448843513314065e+00,
-0.146999087271613399166980754744738e-01,
 0.103791269539785248268708245023941e+00,
 0.211800752471721494937980720218434e-01,
-0.801237850209436743142314861091095e-01,
-0.798358186003042830047447549301547e-01,
 0.148247162981493113337113291867633e+00,
-0.612484487203056250139227666618476e-01,
-0.732351678234277969541799057827785e-01,
 0.979963769893649156204730809799719e-01,
 0.261425867661180837211908587433101e-01,
 0.120608725065588171388355925233845e+00,
-0.155071505239083929844345662250639e+00,
 0.825232360175600093441674532213540e-01,
 0.375270349883772880314972056531099e-01,
-0.111562149530795276763887085921076e+00,
 0.831789622239728948971191086412624e-01,
 0.313701768817786835384972080374804e-01,
 0.129096333184811540322921260806012e+00,
-0.442377579775067637353052435157910e-01,
-0.523777934483557577836405763391872e-01,
 0.116185866355400240938199232308184e+00,
-0.118725317075739355037311423476598e+00,
 0.602512425603522582801702613183820e-01,
 0.367358858908700047189283993688396e-01,
-0.678363037465516915838150898222866e-01,
 0.119497937774767034924825562844395e+00,
-0.142848379380160868420247140063291e+00,
 0.132783547755545266172063727686077e+00,
-0.923415981520125978750355220283374e-01,
 0.312056001908122270195149634100031e-01,
 0.421016887654293862584232458797268e-01,
-0.156456268281906952199702082682600e+00,
 0.139284607403901931604287695281943e+00,
-0.112414323185547216244954350461529e+00,
 0.782469697171980822064073009503522e-01,
-0.396322220768311568702248881647446e-01,
-0.109217774530814808606154316336095e-02,
 0.473223620647575025640509532390761e-01,
 0.147036666510872118100012240793841e+00,
 0.136941853491083587530483569024168e+00,
 0.118369506726469037584100825556447e+00,
 0.942295558493038115321816350829729e-01,
 0.681424751130811419586915214622759e-01,
 0.437200657840504026132258841651798e-01,
 0.238577204978902160082187734722897e-01,
 0.101841513944304083217574183419015e-01,
 0.278165504861555517157842913582265e-02,
 0.233573952106535376293936262178036e-03,
 0.297705349858862404955564015243960e-01,
 0.825300230099123950034977331705222e-01,
 0.117035881784694546977904275189231e+00,
 0.127363215671110580649678488130405e+00,
 0.114672873258201957689638995631473e+00,
 0.863300187644275169944444961963982e-01,
 0.529664018932323932969192732715870e-01,
 0.245799121027344878575918403726730e-01,
 0.709441645900622492860383407772070e-02,
 0.613732211429371256107884879240299e-03,
-0.122117395229201360847549424383218e+00,
-0.755208106813953067207426741258817e-01,
-0.229689373320751079694317372477497e-02,
 0.674789763992130817240531121583488e-01,
 0.108109074761648963563886827519577e+00,
 0.109766930230583075955485936929444e+00,
 0.811749118540830192662220149018600e-01,
 0.425569934448947176178557167786045e-01,
 0.132607173410440641369104420979735e-01,
 0.119429336231622574173858872124463e-02,
-0.485014895894334146125005472808647e-01,
-0.115556957301564580654795255504188e+00,
-0.112767743505064671265915762126494e+00,
-0.458415808351081347336621217140219e-01,
 0.406365697969467563328238591819168e-01,
 0.960666555367299301142928290091187e-01,
 0.977032500335746578399234481000262e-01,
 0.609997048980648577040598875029840e-01,
 0.210321607460136985809034395384767e-01,
 0.199370302077819075275023365503452e-02,
 0.111048519172861927982659237364091e+00,
 0.178841420328360586407561344888009e-01,
-0.868494408577083667998239703880867e-01,
-0.115204514066480686172928114745210e+00,
-0.506169510755649949201739149297666e-01,
 0.446943820651542226641078327393914e-01,
 0.942776525954206489929381849823941e-01,
 0.761985521254596073488375563527494e-01,
 0.299481598255079418407538124372548e-01,
 0.302283606454346255095483549406688e-02,
 0.654512895176268900676827408353394e-01,
 0.122272821602090628463974150832671e+00,
 0.434831026178789722644190988743776e-01,
-0.773730869712432652113979891820671e-01,
-0.107035568653515311144705839194725e+00,
-0.251620962045888197890068749903578e-01,
 0.684690424016967014447140020454171e-01,
 0.846302088657327998754558611531945e-01,
 0.393849613679001030837903985866077e-01,
 0.428603350781737896565058402710896e-02,
-0.996497392415879879555195355049811e-01,
 0.397070632384817714810459557537041e-01,
 0.119510323620501674396192335826448e+00,
 0.326036669198275639327984875928481e-01,
-0.902233859938100090266588592948772e-01,
-0.829770098341881221672399976755113e-01,
 0.250767617258502552715074400541558e-01,
 0.836949000129953051414560954559663e-01,
 0.486101093064034224561418185380616e-01,
 0.578154029628965118566651922577164e-02,
-0.806435617493588647015622122256654e-01,
-0.102951580476374401060814077115777e+00,
 0.482728771872742036319769064825660e-01,
 0.110982830171941652810876614845161e+00,
-0.111971661616188708011576766081347e-01,
-0.101838748048357206885284031677334e+00,
-0.249257056838034064786994994556257e-01,
 0.722939840986543378945001205843065e-01,
 0.568441374624859565795827085133271e-01,
 0.750182444654383785174036223994976e-02,
 0.866092305855857758664447204759204e-01,
-0.873332675239777298801197165706034e-01,
-0.821821674074166140722283682874283e-01,
 0.831349721986828472318109385981148e-01,
 0.752882637727527338085159639484315e-01,
-0.723567367081818776938027322623528e-01,
-0.676016069914792630223176501085358e-01,
 0.511401949808821027197051265968228e-01,
 0.633260741136465124297736665469968e-01,
 0.943388198056182615320594133311959e-02,
 0.938375880113202461719174516225605e-01,
 0.621845107241108524293533922780256e-01,
-0.110510284905351673238751154580565e+00,
-0.243154211965617832679388386973047e-01,
 0.108456826154993301274263953262689e+00,
-0.822688840884533456230984991150870e-02,
-0.904136335141452384198447893524086e-01,
 0.227374871847914847943407301584615e-01,
 0.673782095351275733932767521334064e-01,
 0.115595661378865172732863791004847e-01,
-0.718347989692081047254806418762114e-01,
 0.115816602833886868719838742454601e+00,
-0.172337793047669542243388478528652e-02,
-0.108097046590616232630126914028657e+00,
 0.647083554950292942919157209104994e-01,
 0.597285613492589615990011537088688e-01,
-0.863250345788781734887932536637605e-01,
-0.897381556233047237620761461892817e-02,
 0.684653378851886987671348258031475e-01,
 0.138559578557590993348462825814994e-01,
-0.104770725113574309681763848114253e+00,
-0.870251947000200617073742565466052e-02,
 0.108989040277120733165726149249923e+00,
-0.874271306502090283127838596698319e-01,
-0.249961434695093409593345734926750e-01,
 0.983727050511525441827022928242082e-01,
-0.562758715148767989878419894338327e-01,
-0.392499592395346026959097203697512e-01,
 0.662439508160083200193126915498537e-01,
 0.162957847319506958707749696443122e-01,
 0.555311518374453906492336315440032e-01,
-0.119638649185986620072596074092999e+00,
 0.839720773614885473529126107681579e-01,
 0.177326222633441225704220740203941e-01,
-0.967139712610866538133152400241445e-01,
 0.886292391229253805285542385712554e-01,
-0.917187706618437175636717411181206e-02,
-0.633464831574036531283987824544601e-01,
 0.605975227023977680283936062439269e-01,
 0.188478902646625302769764681019618e-01,
 0.113209971663897045665523380184391e+00,
-0.462728843044876336584912398976556e-01,
-0.455599700750199195249039402880389e-01,
 0.105588266006260595863035513969237e+00,
-0.991052695842013831928756185156739e-01,
 0.351623562929584558162753712869490e-01,
 0.406824940981472474688814408235711e-01,
-0.773495126186120871280309189558459e-01,
 0.516550095904031915283127465685835e-01,
 0.214777517470492109040498915576604e-01,
-0.380185558698737883266133961976896e-01,
 0.982789169709094303611061929411986e-01,
-0.118190359331458528906255360191883e+00,
 0.909684449519113031734509171205220e-01,
-0.303924533654723165663006285437746e-01,
-0.356635822519727332450220164393395e-01,
 0.779433225526884515363973474950182e-01,
-0.788864735516804243840439509492989e-01,
 0.397909026403665128511695702954000e-01,
 0.241480428456029866944057013458123e-01,
-0.118970839774685958845522795289036e+00,
 0.913002774356935305965016379622865e-01,
-0.433949005281468165014408096364429e-01,
-0.119435553673938581599458322715325e-01,
 0.601051130077933208655220382261274e-01,
-0.887153105169522051934070509833620e-01,
 0.910169462454176598957103317289068e-01,
-0.675858777939067125089035254342792e-01,
 0.256065371229170685950969690446070e-01,
 0.268192351849595800465885872409528e-01,
 0.196763137735123458030844355524325e-01,
-0.563722650352730409550090900243899e-01,
 0.854830216688219202063958771278325e-01,
-0.103178244859682459183319225130818e+00,
 0.107277720703517639569671377726367e+00,
-0.975575406440544658470057759290514e-01,
 0.757521826149253424620978419907031e-01,
-0.451983081839714124382403197380863e-01,
 0.989375676662167590091396489911358e-02,
 0.294502319834587904065976224476952e-01,
 0.121926702431324312246140894861113e+00,
-0.117061597674092046473402306383917e+00,
 0.107594582344882231181674313906875e+00,
-0.940365708753708338960018401821917e-01,
 0.771146289420865737575076758797304e-01,
-0.577213827281727340506701587048823e-01,
 0.368335410600596871600798746810473e-01,
-0.153495798696344906498040213871371e-01,
-0.641663482755133675350108883301049e-02,
 0.319990258208317855346765268326495e-01,
 0.116573994436434116101914057406789e+00,
 0.108783971850616159919218596792317e+00,
 0.967040599256773676137384187121925e-01,
 0.815653749353016433403879218128577e-01,
 0.648605226383047528300925322086548e-01,
 0.481503807071881341840498150871809e-01,
 0.328638321356114796093743394226106e-01,
 0.201173369652520044974842540457647e-01,
 0.105785198502817893783586154569862e-01,
 0.439197851410319315927974171800704e-02,
 0.117708859416555680792405535855301e-02,
 0.978132230767453564393049849418572e-04,
 0.378946409401961944230635604793602e-01,
 0.701886291131755217016138463730787e-01,
 0.924077017779219864673085782503388e-01,
 0.102074792449738169373522185692332e+00,
 0.991297390093740606306224663984133e-01,
 0.858082687384321770508879009898132e-01,
 0.660172337606414318915254477401652e-01,
 0.443603761763550883301091250252542e-01,
 0.250491548584450128159648251544983e-01,
 0.109574427014525769584510904469900e-01,
 0.304160852243628105185756291337852e-02,
 0.257639653791877229183460714191704e-03,
-0.902880027857074386394844350447223e-01,
-0.549904371083776386839638109891587e-01,
-0.727620526105528250830878164748241e-02,
 0.399894840619732239376367484867698e-01,
 0.750364743621540523874269153984071e-01,
 0.907314030190910092413316423584081e-01,
 0.863880482436514199416152881880081e-01,
 0.672909765488522109063379467906878e-01,
 0.422066413793381299276380603755982e-01,
 0.198713725516236334467576151861678e-01,
 0.578717820559279157927984822233806e-02,
 0.502995032799492915608171826121222e-03,
-0.599952530488918769070722285741795e-01,
-0.956283308523682613828698102899788e-01,
-0.932721344739324103849748759792118e-01,
-0.556574869624444864517027801815974e-01,
 0.178095233391619650148475918660579e-03,
 0.513798528753072076849447173942899e-01,
 0.798552824416525646434314985891613e-01,
 0.797338451385555398687487324432548e-01,
 0.582810020132860000414687706668010e-01,
 0.303017880255661084384217947757558e-01,
 0.938988032145522270650247103791507e-02,
 0.843129736173303410834617091115394e-03,
 0.723228175057777788026152694762988e-01,
 0.424089044265378835552973649990699e-02,
-0.641288301505584354454086092355297e-01,
-0.945861016857195701101324216314091e-01,
-0.728387905923469049673836083190983e-01,
-0.151782615596328952854747042254526e-01,
 0.440618383390661246703067202020041e-01,
 0.749638373915277599304959907644607e-01,
 0.691725701767558615987574575777699e-01,
 0.410564141445285915453899727467481e-01,
 0.137519921456316660306310437112546e-01,
 0.128468721723161017415462750086918e-02,
 0.775767602774780704457121859781156e-01,
 0.963211560855506414359226807908576e-01,
 0.436334221463971338131614906426081e-01,
-0.383249591868819480340988794941286e-01,
-0.877641150588626458379209989680539e-01,
-0.718774323885260242657505630771155e-01,
-0.899524475926144574437726314888689e-02,
 0.515419853848057872970776580256798e-01,
 0.714824820245163310236630687412053e-01,
 0.507528826977184464713639473796663e-01,
 0.187124963318040999445134311879505e-01,
 0.183215097961681217258562011092294e-02,
-0.519744530861052115559241393805110e-01,
 0.442250129162615460822734996715820e-01,
 0.959976028533121586201110705346442e-01,
 0.563007664000529554337932384600697e-01,
-0.323817432670639867008646622264137e-01,
-0.847768654572542162990900091198329e-01,
-0.577159445793625394557881111559677e-01,
 0.143191853540571770278814904023828e-01,
 0.633861964128847497557637623621435e-01,
 0.580034673253451282894854731077507e-01,
 0.240574486855328960517092834147381e-01,
 0.248801985347169900279218505265792e-02,
-0.901503202100077558968465649422945e-01,
-0.736046174439509557554380665724022e-01,
 0.276626716476250208212790688902039e-01,
 0.926176335431973112596769183493101e-01,
 0.488807264035586833653202116247823e-01,
-0.455444438672764265508087694301879e-01,
-0.808148753578453017825362759787779e-01,
-0.267634616509082904718279168382421e-01,
 0.451734720433975283271464884992507e-01,
 0.616014385907770703509686059919470e-01,
 0.295321797879657524680111931738806e-01,
 0.325291341836835453450610973334412e-02,
 0.291539428401981579953459394315318e-01,
-0.806152057283494523015050992464315e-01,
-0.751869027072543124305684109747910e-01,
 0.332702257414606870800770820683053e-01,
 0.897981794053969769755674218946803e-01,
 0.218451061627274771461457698448104e-01,
-0.676426845905099707818902182664418e-01,
-0.597278219820733050561716245777701e-01,
 0.193297289684329527034967066670497e-01,
 0.606882373643564295465108328211622e-01,
 0.348552810065052148821295581848898e-01,
 0.412565225557258741097509284439985e-02,
 0.971235368713513920537106725242492e-01,
 0.334119717609432988047896913222543e-01,
-0.827435405964913663055102580404495e-01,
-0.603304041955274230633090519321969e-01,
 0.566801122654342469839226974720376e-01,
 0.752866698832066337035845509617118e-01,
-0.238080284272857940150194239473563e-01,
-0.744693321921772845664845695663279e-01,
-0.987078897617661796082469150672891e-02,
 0.548814218220517204664611554496419e-01,
 0.397338970302052641351856501615248e-01,
 0.510333027284276418244987488048630e-02,
-0.489584528419237187316805956975706e-02,
 0.969222482870091149568256076384902e-01,
 0.144303108014000346138886145494255e-01,
-0.910174541015247021002313120657392e-01,
-0.232135876791020008058059358373624e-01,
 0.809811728079481585207921541053489e-01,
 0.308359824062707712573695373493727e-01,
-0.662080655850186385316533391077789e-01,
-0.371839783760523479702480440111873e-01,
 0.443473961299683352356194444899598e-01,
 0.438796718074310363852233409349214e-01,
 0.618138756549373307452160482062217e-02,
-0.981480503822052478776734664952521e-01,
 0.144605451974710269908178785061657e-01,
 0.931212963346806349376720240072064e-01,
-0.268648989364003699225774197328539e-01,
-0.836902955707211252620999420372701e-01,
 0.351873757717592056319652941635339e-01,
 0.711150539147287882604971900556651e-01,
-0.372862939087878762688904612589647e-01,
-0.574595638925325311640301205894800e-01,
 0.298091606710911527692225362142969e-01,
 0.470246118498661033140443876423075e-01,
 0.735368842483562766092605131993780e-02,
-0.194640575845696058257927532486450e-01,
-0.896492497113629840923591877553494e-01,
 0.535116355808434437177531123663614e-01,
 0.652138001293307348333736148674692e-01,
-0.744519426530997707221489637719797e-01,
-0.329918025873460340226892957115962e-01,
 0.782512489312883378896140013432373e-01,
 0.334854308783083487447500226911164e-02,
-0.667254209192437930374590521961236e-01,
 0.124868664397528691363042737559023e-01,
 0.489361061930557794625898774677033e-01,
 0.861260707886357734721079664345795e-02,
 0.932013101572212069838457846372341e-01,
-0.585367336874102781378293526548131e-01,
-0.540237696968610024135271535923718e-01,
 0.890449304801869540218728379113327e-01,
-0.315792289081541701892302421394527e-02,
-0.799629446392659067776200310146968e-01,
 0.488042571504875888870523009012892e-01,
 0.428681922166040757183079274584847e-01,
-0.630592029152365477128619548808606e-01,
-0.602311636436795666070176246044804e-02,
 0.494303649101564122182239650712403e-01,
 0.994912255214099452247942676081498e-02,
 0.425161472946856851903021838535486e-01,
 0.607952125502179130629825386498881e-01,
-0.927697520570110770333246465310841e-01,
 0.197146008645522083047924528487092e-01,
 0.707000196256974342941764366548766e-01,
-0.755613073956017941252293119726826e-01,
-0.351135326197854282467114573307920e-02,
 0.686409587901791713263792976692492e-01,
-0.470547988264579560138758206590964e-01,
-0.239175424950603950403886888527543e-01,
 0.483836020814338825819389373121541e-01,
 0.113529232608543048771457732395442e-01,
-0.826061828378196564210857203146228e-01,
 0.883333396410383218384796076971695e-01,
-0.134732667822854634835973566218728e-01,
-0.701968911483113712303065233947551e-01,
 0.853724245452994961252450786608679e-01,
-0.225635651406417727579981611235517e-01,
-0.541298294403626327072676510263729e-01,
 0.723350970083681480930300527728455e-01,
-0.217740037038708053820091421067013e-01,
-0.393850561061652412345922851820338e-01,
 0.457403892933649326006128399204137e-01,
 0.128125214288586994313923189666042e-01,
-0.629032986214491750542054831504481e-01,
-0.174171611767191578034806748893878e-01,
 0.829146400292109609816820514496784e-01,
-0.864952046520631793190333314972528e-01,
 0.285594254090014150462329509633171e-01,
 0.449339218593918346344472171319208e-01,
-0.791685114204047060548376535119740e-01,
 0.526865483431490050806508003914551e-01,
 0.781854452291916118547004796560042e-02,
-0.508116194714323273340498518583140e-01,
 0.415187362104813744129975062139731e-01,
 0.143153770261825081862995891122340e-01,
 0.670184248687982739165573356779417e-01,
-0.968197398612359035129284421996774e-01,
 0.736718626367165225914293089237770e-01,
-0.120988227600969310231183088872434e-01,
-0.521528797842349274556030834045772e-01,
 0.833990640786095024343336768556117e-01,
-0.667512745735860647766355961647457e-01,
 0.159908124693309252823541024546973e-01,
 0.358293112149798886826514522003292e-01,
-0.569687058628203880298002248465958e-01,
 0.358116087169553149735651676351282e-01,
 0.158480306410862118929093115828202e-01,
 0.794172796893351315757400050796164e-01,
-0.300370763980228841529997526479785e-01,
-0.294043359638407852383318719917015e-01,
 0.749513008491689918654767988903191e-01,
-0.890829928094848730636783281737745e-01,
 0.679693989904154924762369920830468e-01,
-0.227138782576667489536264142243924e-01,
-0.258788136267162957439238686130203e-01,
 0.566223010280948438259590785180303e-01,
-0.571619922211984724710010699418663e-01,
 0.287847648688351717323219324115740e-01,
 0.173962444706982747787516081451763e-01,
-0.473902134825332679504042497085657e-01,
 0.820643035357846407592631671067037e-01,
-0.949704371758361280212982345323688e-01,
 0.833014109526336611990265164312257e-01,
-0.512306077550609865180662788997419e-01,
 0.859347342882969733774567640909541e-02,
 0.320827749025248115495053358587579e-01,
-0.593054759348460463700997567853660e-01,
 0.659734101688521653449460008339747e-01,
-0.513225400176762445402480152152628e-01,
 0.206709660978554016011597331464485e-01,
 0.189451504358384381081283649520430e-01,
-0.910775766504062986607575897395552e-01,
 0.702072046460361928191232716245237e-01,
-0.394757084520616565190430703274381e-01,
 0.418808581760877756742017788859526e-02,
 0.296302375480199462564452785718017e-01,
-0.563218087832315355684211593983487e-01,
 0.716134440279242129885108390277350e-01,
-0.733718768550497905630107813312215e-01,
 0.619510269201006155775023346057506e-01,
-0.400288535502452501931703605521736e-01,
 0.117607971234570568130186134174693e-01,
 0.204794042821085852302420519092252e-01,
 0.249142417846418903994426381867227e-01,
-0.476725339269887659093109974893399e-01,
 0.663221566933082404632185137634584e-01,
-0.792976547529889829109635362666849e-01,
 0.855682061522659798269730924751775e-01,
-0.847340630627305327676329013006568e-01,
 0.770619157917789530738628891605304e-01,
-0.634527474266194287371611132455263e-01,
 0.453351940806493822458284565382600e-01,
-0.244560314254368433023103400430853e-01,
 0.239049429173867305673479266085612e-02,
 0.219833444149347876082835129060887e-01,
 0.971932318339261017200106666829145e-01,
-0.935143428654354675743316089715497e-01,
 0.875284397924809080212372595344517e-01,
-0.794483786117444333922235587781745e-01,
 0.695610868059323613726073029285621e-01,
-0.582161974644502048790484863769119e-01,
 0.458103336548472436475110877062956e-01,
-0.327640938739701660733893375450435e-01,
 0.194818690458346314035196410330563e-01,
-0.625658542627732051306168810593411e-02,
-0.707266953971791957211047515852045e-02,
 0.234411541266688180676094788577636e-01,
 0.993228129861623158758986405593556e-01,
 0.961981948897880458632408292086695e-01,
 0.901783377687625047920135286338473e-01,
 0.817009769826452174584002813633568e-01,
 0.713721425982824806529935135777815e-01,
 0.599108391247699017660453302598616e-01,
 0.480836848717079412918902323673144e-01,
 0.366356733423660121598586560289590e-01,
 0.262235797253064189485333426528077e-01,
 0.173582786540495234546544866416477e-01,
 0.103613893638092480332463804502519e-01,
 0.534030175873326111523802994560875e-02,
 0.218389076264693565324222212814994e-02,
 0.579261401629105311962821819582649e-03,
 0.478601372439018193259376598721718e-04,
 0.135259490170395024279868969425145e-01,
 0.391624319056886841464902730889116e-01,
 0.607536855343724918398562525794043e-01,
 0.762408181722544604694144461108339e-01,
 0.844147009153988239608000132453518e-01,
 0.850598543133930446579197998660607e-01,
 0.789417724897390473895750536566011e-01,
 0.676418674102003873483354683879204e-01,
 0.532692200983673368575184393788116e-01,
 0.380983787990771963784313647621520e-01,
 0.241942140108240286973547140133711e-01,
 0.130863827037644157530260066198616e-01,
 0.554703691103842662244145270381077e-02,
 0.150755167884518977914239218403381e-02,
 0.126232655110416693247704787915453e-03,
-0.844208719781114040267797612439908e-01,
-0.695029632747410880706538074388694e-01,
-0.426502065289994298855955439200211e-01,
-0.914125294121251312514658143774398e-02,
 0.246544581617605670978469607382778e-01,
 0.527019189393686024817319808397533e-01,
 0.705980433484737334854316873772025e-01,
 0.764303230058101354686895568703752e-01,
 0.710008778211287858809804244731466e-01,
 0.573836956793382029780571734348648e-01,
 0.399523187376341654934224633752468e-01,
 0.231469654711384013858513687355756e-01,
 0.103104369543285669662397361394185e-01,
 0.289616561435133220896756033576088e-02,
 0.246888739710911301874148594126513e-03,
-0.222519721328750773715674478167141e-01,
-0.603307457315131872184488216674916e-01,
-0.811509849214664845680976635758859e-01,
-0.792467731338782737443442321587578e-01,
-0.560619108995947022321581276102245e-01,
-0.191981995368459511073517647924632e-01,
 0.203117826534328293948892868635264e-01,
 0.517094138271491608872297325735143e-01,
 0.678822695201085099589206601327349e-01,
 0.672564649306326191340408320619995e-01,
 0.536320726141962050784912400643461e-01,
 0.341478713164309120051180503494240e-01,
 0.162350596930196287106490257687886e-01,
 0.475700640943953702775533777787618e-02,
 0.414770632682398875081750738008275e-03,
 0.797718120645362333379976286845228e-01,
 0.480448834331345500887914748697860e-01,
-0.215789993057300103757721322508616e-02,
-0.501861611597304919910590607488080e-01,
-0.769825251826747995168403843706853e-01,
-0.730894099559257788402545624063775e-01,
-0.420908617272288363205613645118861e-01,
 0.186918461618025522881564435591530e-02,
 0.410482495696845826470496446280780e-01,
 0.620752053395119294437194287295564e-01,
 0.611623903383760804191136638188067e-01,
 0.443231246285183781986187395632260e-01,
 0.229095773422006208813963945502721e-01,
 0.707206469351655344333081358683893e-02,
 0.633703812503546145540746271409306e-03,
 0.304595524878721098693160246853326e-01,
 0.747986648143833844019752692260532e-01,
 0.787681299013138442167938388168859e-01,
 0.411894739088196723382893698947235e-01,
-0.164320596705057555485331431238634e-01,
-0.627410711278200435848265767486138e-01,
-0.743716163407091141745221731536529e-01,
-0.482045618852336607309610552415260e-01,
-0.124021975924018939957392158205860e-02,
 0.409667703352642878752204788901145e-01,
 0.595541005127155534170843564365507e-01,
 0.518302202676530036323471706816752e-01,
 0.297963457990321548800180788255357e-01,
 0.979686791857997918479053022021550e-02,
 0.906623804935466314624525444968375e-03,
-0.757689301917495220215235551197610e-01,
-0.238537150099607715871240747373183e-01,
 0.434861807844517407455479855807869e-01,
 0.796509256798877293388434595023690e-01,
 0.610951964645307086560476639998917e-01,
 0.297408471257825420695540012284281e-02,
-0.534555269260282238802274233092940e-01,
-0.712008897720920087459582994482305e-01,
-0.426146756800586025616905348161784e-01,
 0.858567886809662715516294608143025e-02,
 0.477839841303168324247640688631338e-01,
 0.550702852689288508270693664533004e-01,
 0.362827903896728571029859290043947e-01,
 0.128631756461871969681826243581605e-01,
 0.123566568600185608635470343587029e-02,
-0.382487252825309945181588641363511e-01,
-0.818287368597401026534260900398009e-01,
-0.555757343087746736289449246127310e-01,
 0.166172938661060005049841802753675e-01,
 0.722625406060456442726688736739951e-01,
 0.656010631399924010124875556292428e-01,
 0.594975208250035994882420097244095e-02,
-0.538757133516159488671824816260913e-01,
-0.657795279946897183964953083134074e-01,
-0.261123665507045108337215249657340e-01,
 0.272078240290030430194544958960498e-01,
 0.529741750033560933792458274222872e-01,
 0.417385245417906279962584233000675e-01,
 0.161820445118987890716754734221778e-01,
 0.162221516742323661795833584660439e-02,
 0.714062919438148664094591300095767e-01,
-0.192524492263193645715765203766901e-02,
-0.721366459084911534269330138520606e-01,
-0.673352896259892690746511151103844e-01,
 0.504359094866915664435364093787295e-02,
 0.688077925490734658991130957301337e-01,
 0.607360904758901837456309076798760e-01,
-0.577603360803622021384696344599315e-02,
-0.605436056080189900813634118825719e-01,
-0.527080452177070052924977175998794e-01,
 0.139022670501467794200241466895473e-02,
 0.452109754785385017342988469831524e-01,
 0.455743639409417558780318321984854e-01,
 0.196474285704421000402721881598390e-01,
 0.206694327954617979427570783091085e-02,
 0.455871620280921555015262687792839e-01,
 0.809502997676768539689596865050023e-01,
 0.180665113405184338375170552507029e-01,
-0.648152824989358591504134138675623e-01,
-0.674373215979506919404948540297552e-01,
 0.964260894895667005411548098916188e-02,
 0.706454564163064122829538220719610e-01,
 0.455038493225217363146595153683435e-01,
-0.288889256998872181468415671157975e-01,
-0.628158429482982467676776256769133e-01,
-0.246229404683239440932975545472970e-01,
 0.322852112455502225689995159986116e-01,
 0.472985638406696812755716359399752e-01,
 0.231402967640597942702705348782339e-01,
 0.256983324133716077942084197434349e-02,
-0.664685534997278536704137698474147e-01,
 0.271633917333167226990898563212559e-01,
 0.812756010852059753754527614008431e-01,
 0.208336908785225473575899477095305e-01,
-0.661263947046497186972757191640077e-01,
-0.581454387637521378343212532719519e-01,
 0.282602129027862231816489660204006e-01,
 0.701160039591911630208106796218280e-01,
 0.154382415404861782811096164405047e-01,
-0.530329077229702558536731415097873e-01,
-0.454273868485702004830539350327550e-01,
 0.155053031148855986619771744738405e-01,
 0.465655958661240870726644468428812e-01,
 0.265331784221007834760869703204952e-01,
 0.313020382466413148200181615985595e-02,
-0.524168165024167307496774011260262e-01,
-0.723364451774861959911115813512631e-01,
 0.238284828893829957295931337756986e-01,
 0.795494096358784972352715146703708e-01,
 0.751439098671724648776960296385376e-02,
-0.727331845290857005871891408421427e-01,
-0.350369876398479855482181337990076e-01,
 0.535529532242566029233223402975104e-01,
 0.528059192513264207012234524436126e-01,
-0.262912436777556790307677876197734e-01,
-0.565166795270276197878475979477749e-01,
-0.317476538976526437910450566055704e-02,
 0.432132762383634331853312762201448e-01,
 0.296950096291614769987872685559292e-01,
 0.374673165805436592205880165147662e-02,
 0.609161945652554866763274556289473e-01,
-0.495980603022638579751147486441603e-01,
-0.688953503432896501509869646223630e-01,
 0.358591397901187496428231162732034e-01,
 0.728066562687104882138465639603096e-01,
-0.207648768093122238599786094794157e-01,
-0.721213408596474945343932920818213e-01,
 0.546393914528678994201706875132651e-02,
 0.664603157961516998555173488452372e-01,
 0.890542495409592414156636298205415e-02,
-0.553719267924209560483232425042799e-01,
-0.214191461243824218610174545878583e-01,
 0.372849490719379789094233437196010e-01,
 0.324961305690407592786337440077716e-01,
 0.441747395232116840547466631751364e-02,
 0.586748090739178478665421102720781e-01,
 0.568532172495297686486296899725070e-01,
-0.591815424407792348297772830059671e-01,
-0.539402765748012029185742793257371e-01,
 0.581390734667600745934509139913192e-01,
 0.501675574649844484272789659216414e-01,
-0.552696314378365138448839774316415e-01,
-0.457951459120264141846612855883157e-01,
 0.501761522267289366499719463925660e-01,
 0.411582768631794488998626187459608e-01,
-0.421182947900514312154345134476053e-01,
-0.368412645113675172628258104447067e-01,
 0.290346215407139466361716993886290e-01,
 0.348132713096900198587960575352070e-01,
 0.513989257570698422393006499996212e-02,
-0.547686687535116669009100216182146e-01,
 0.671728301209381224294825608635548e-01,
 0.384615715679694206729039606732809e-01,
-0.741543650283455623671585331356851e-01,
-0.203663104244051961498705510039938e-01,
 0.749849335787397008837666782830858e-01,
 0.294630357617467095188322175860871e-02,
-0.698484709934811895026288122005870e-01,
 0.112273188137362854154294386428925e-01,
 0.598969252675901524385413032315321e-01,
-0.195799299674606013909650786889849e-01,
-0.473535073382017972484281168404725e-01,
 0.189143361582427409298715376050088e-01,
 0.365343589518489108525334183618712e-01,
 0.591088006118690217384337094394274e-02,
-0.643000391374079148283042697812272e-01,
-0.359976251735458479974367958266058e-01,
 0.788471986380466917031323313063525e-01,
 0.124226272915218759707193618346862e-02,
-0.764179591103870843522964657205890e-01,
 0.308802265499762798935343497472405e-01,
 0.589031877553278204913708645109850e-01,
-0.523705956952424003047094072738343e-01,
-0.327803242919047074191157404441027e-01,
 0.589052126762355814763910780003870e-01,
 0.729494697667862849946799953674011e-02,
-0.514828684898121629176407186353020e-01,
 0.754453143131443610028929395177115e-02,
 0.375629816599194453324608801025085e-01,
 0.672678790084556970441223319954188e-02,
 0.480718018519612253964349845702810e-01,
-0.782677286712884604241025315217384e-01,
 0.195516802766193825915515124156761e-02,
 0.749831033676213591567824673228944e-01,
-0.483701390550866474154829842227864e-01,
-0.415958810998651645756861695972241e-01,
 0.705848143442090101362352961246751e-01,
-0.372188307689824431904639273852383e-02,
-0.618494068209416404942246350588852e-01,
 0.384481031706816751779715848002836e-01,
 0.325177117315197232226660412458505e-01,
-0.486041695383111085243529674481435e-01,
-0.433043694462815025531721377916289e-02,
 0.378223541769696397155415863373865e-01,
 0.758345732427118086861249164531337e-02,
 0.692360436311699063160284153888078e-01,
 0.117637420259066873112058876378402e-01,
-0.777989252831051391973087580585551e-01,
 0.519293507344385659025406407205221e-01,
 0.328993651220606587979355584348458e-01,
-0.757382494513709331789458254654371e-01,
 0.291905090185235752219572063711302e-01,
 0.471173039508802613035966370380838e-01,
-0.627100207128165912528020834465876e-01,
 0.525477395354212453808026450391915e-02,
 0.504078022192437821337773560764155e-01,
-0.390540454166059896344846177973475e-01,
-0.158981850315214235872581044333077e-01,
 0.372586443879053195394675826724431e-01,
 0.847625264354892483498259196497937e-02,
-0.408861075939229010104994182044603e-01,
 0.818649275938100663435678737887457e-01,
-0.417622825535812408589330912233973e-01,
-0.381402210246284060096024315016308e-01,
 0.778985715110260753194193999509555e-01,
-0.400953332189300139532992573198291e-01,
-0.341505992228645393183654473546554e-01,
 0.697922830533046516587306438041287e-01,
-0.349318042058119395334142830950413e-01,
-0.296688735153542213877649915179560e-01,
 0.568951060309854786754840150772320e-01,
-0.241061629796146146275823380025219e-01,
-0.263411824428316817346447071605715e-01,
 0.358435406624993889215879940211792e-01,
 0.940009716152643789467975083061277e-02,
-0.734325557533834393102777167604780e-01,
 0.135423976320377182026167544815456e-01,
 0.564051829633018994767952171077061e-01,
-0.789261560940061557522011899970561e-01,
 0.370598885357512260449592926923306e-01,
 0.324884238960686086758067613103371e-01,
-0.717418019189511557902744910545739e-01,
 0.507296464145352501634329154501429e-01,
 0.881306055924748229593526002467469e-02,
-0.546877769910452066185435994192150e-01,
 0.504711081715903966337435667734265e-01,
-0.580858829551523222631677497925312e-02,
-0.349015745953527334237514036344920e-01,
 0.335759643064842419503352175433883e-01,
 0.103495115734242138373834443332562e-01,
 0.332816336049392650331619892910283e-01,
-0.776499402532350211501506081659432e-01,
 0.705840402338262864201896503318302e-01,
-0.177666316891609131635914950428221e-01,
-0.446056575080630916974876668275060e-01,
 0.750841343729011228781564140699524e-01,
-0.552448686036275699968646928324062e-01,
 0.131377515082463728494788137984867e-02,
 0.485041874454557152610445229067061e-01,
-0.614303911709729947944034498811475e-01,
 0.325615186878538057220056742689621e-01,
 0.132951961067428259617959987872799e-01,
-0.409426659914442944449058901845210e-01,
 0.304828595886801578540212709385143e-01,
 0.113186547388832816634356395603436e-01,
 0.768465039316196211842084753154399e-01,
-0.375190678728325763500405086860680e-01,
-0.203116822028702961377252408853054e-01,
 0.663225003384393520482994392970017e-01,
-0.770702214877750387846025427139164e-01,
 0.483935782984664208655724279171871e-01,
 0.291176080380802136649278100716321e-02,
-0.488726155807297481163377925413003e-01,
 0.659362385077832772642653011466889e-01,
-0.476148495227295433373591760399960e-01,
 0.722558787524553377459873876107111e-02,
 0.305224814558986285241760893009903e-01,
-0.440019881990804667388599567343415e-01,
 0.266190245128979461999633447790179e-01,
 0.123013666585446165771716519807445e-01,
-0.253351832208606622109157082044535e-01,
 0.660434142166922260981546533486366e-01,
-0.809415320674932720533658266023295e-01,
 0.646990805456044369727972715246350e-01,
-0.245388275274620178867554352956530e-01,
-0.229539538154896084814868339689745e-01,
 0.588542429875969722112092635355574e-01,
-0.697481805283632768108717605265764e-01,
 0.530900075612732126446976651312778e-01,
-0.178453430723468782380764355930419e-01,
-0.197562531901752113706620336163809e-01,
 0.434335591608705339132875042847572e-01,
-0.438314964501621196472046485611137e-01,
 0.220659777091949656909758817715737e-01,
 0.132912134538666963732816740447451e-01,
-0.794427145913320323122160093034371e-01,
 0.578948874169557414942644943575263e-01,
-0.210392171211856882172171650835040e-01,
-0.205285202373876570633985003308410e-01,
 0.550449031984969329103680848934162e-01,
-0.730907030980324989803185189304332e-01,
 0.703503881016439762838619628637370e-01,
-0.487810306433416876044635774845667e-01,
 0.158490989413840062782683709143871e-01,
 0.179055805063348040842959185319348e-01,
-0.422010416444109660756002278769717e-01,
 0.501842499014731873067870874485505e-01,
-0.404214290668762917569990699081358e-01,
 0.169298894298387975067174611747052e-01,
 0.142815341195329397317967471552046e-01,
 0.171284994956347602211643453306253e-01,
-0.481621649331144378004104744932959e-01,
 0.701785163878625934104290462814291e-01,
-0.792057029685004585501968449001903e-01,
 0.738842232573779327638155715478400e-01,
-0.557143171554742347243723538242052e-01,
 0.287109467941824874814528022064927e-01,
 0.145885796621061106678166405691221e-02,
-0.286729423621838728444019766879874e-01,
 0.476317655758486306999451902724965e-01,
-0.549457461539895263625740196344983e-01,
 0.497966618946420007294206917594208e-01,
-0.340056466456628764142131469977504e-01,
 0.113386365399068627572242409014188e-01,
 0.152654887934161823645969314418515e-01,
 0.811944239759790387292340422924306e-01,
-0.727428409663468390574821786502363e-01,
 0.568673445257556564008356468832051e-01,
-0.354924069874797631034869952157707e-01,
 0.111943668760104762862118173328518e-01,
 0.131261363750407363291001793935014e-01,
-0.346122960269027064117561817057678e-01,
 0.508125234747754619316732455476251e-01,
-0.599884808231615216420986302831427e-01,
 0.613295331815888504377723319835151e-01,
-0.550439156847264644466070496071585e-01,
 0.423075243866523967197518514769145e-01,
-0.250477411428227503727534529105785e-01,
 0.543807150365512560585961422178904e-02,
 0.162361082689257317198759906203962e-01,
-0.874687016259730151201268662917202e-02,
 0.257138094741474538605049561052380e-01,
-0.411351972248262105913429687506723e-01,
 0.540945404882618139158549390815344e-01,
-0.638382676526690027702061322356641e-01,
 0.698256357439053231321928903150849e-01,
-0.717645444051661013922559410924834e-01,
 0.696307701933625079876106622458848e-01,
-0.636690297801240775339462184047995e-01,
 0.543749456787279443614866854569265e-01,
-0.424566742414516558732611069844423e-01,
 0.287709999854100624680865187893802e-01,
-0.142087506025176512671785463365227e-01,
-0.612377342556896301027668400585294e-03,
 0.171863444581597624989046313794347e-01,
-0.820836446389121499489219185085943e-01,
 0.806618588664200120254849549677305e-01,
-0.778540358249509144018436028600461e-01,
 0.737308098736780381075377358685206e-01,
-0.683959807177917903359679401518786e-01,
 0.619839361800117060580437846603311e-01,
-0.546561932445096121383006829021910e-01,
 0.465969526142708686757302885794543e-01,
-0.380073496266507991960768257417858e-01,
 0.290975150401758474742597416275995e-01,
-0.200739144564453278201437611853483e-01,
 0.111140279165074829717099513926675e-01,
-0.229880845840074131163245423905074e-02,
-0.664463340747705543646351715565525e-02,
 0.181091215012668482822897783592024e-01,
 0.749319965461186456633532513813235e-01,
 0.735882978483889648884281324926414e-01,
 0.709571261098454794130103954734599e-01,
 0.671479990144230886899277767591395e-01,
 0.623180165795932078537144190281630e-01,
 0.566636820410041617033588754614168e-01,
 0.504106925082488179662770104127889e-01,
 0.438022474695464201004758916415105e-01,
 0.370865025747878639237953652579141e-01,
 0.305038416703822385084898831895112e-01,
 0.242746493435789225314401358654492e-01,
 0.185882387609900484902591858603619e-01,
 0.135935268399016743187077391627519e-01,
 0.939195415701641375268924230337540e-02,
 0.603302558162314449210188159016401e-02,
 0.351270596594978191383431699708378e-02,
 0.177475096888598349199172955853688e-02,
 0.714894520971735256856943546439498e-03,
 0.187659878715899401865371383962257e-03,
 0.154159879303218359666859310769953e-04,
 0.768668714156407894350221750747027e-02,
 0.226011431717170134917383670970296e-01,
 0.361760628612189984252693531585147e-01,
 0.476390876402367352521605272693329e-01,
 0.563872928387166789051575298927355e-01,
 0.620329553331323625961771400413375e-01,
 0.644298272350672289064907437164871e-01,
 0.636776647238203715363934929932711e-01,
 0.601048062149832518984674154255149e-01,
 0.542306533564743455163332068772793e-01,
 0.467117860717245532218458471692131e-01,
 0.382769606956970453039850632698264e-01,
 0.296572542998509885778661006920473e-01,
 0.215180328755493836238011805146628e-01,
 0.143991977242318034920732700006163e-01,
 0.866932569261578015396134962568225e-02,
 0.449794603571207249032616931990560e-02,
 0.184842183247063130605952790692428e-02,
 0.491896934954678815565675496456764e-03,
 0.407149919725772923172572770523782e-04,
-0.642101367415055834155989069861899e-01,
-0.577178376332556547258679969793717e-01,
-0.454780150294608574481123973330273e-01,
-0.288817580561274078290758801671436e-01,
-0.978351349278890554116691151588414e-02,
 0.974046668807703481163235312690449e-02,
 0.276582263789585901025050892518158e-01,
 0.422355150789599589083097903222088e-01,
 0.522414830622639512731479907408164e-01,
 0.570789167772496150198483975171811e-01,
 0.568225173221198492693243518201061e-01,
 0.521622698689018496311262052606781e-01,
 0.442627879852549314875693578577781e-01,
 0.345616027155695906838026862417587e-01,
 0.245379279905683563796918944477272e-01,
 0.154872269607342813189248376272573e-01,
 0.833539665540897178832061753800680e-02,
 0.351983949393789174058235574454071e-02,
 0.954106999616956292902876291063832e-03,
 0.797747254955498930506560668929099e-04,
-0.126894411778362563751904650951564e-01,
-0.359645792272289666536523440144673e-01,
-0.533083678778026224329636018705243e-01,
-0.619587580743648078778608347766513e-01,
-0.606977602393416392509719007706153e-01,
-0.500318942124678488822057790688048e-01,
-0.320441719068338250373887622353575e-01,
-0.995336694198707634546850854476979e-02,
 0.125255301207675939310091233295634e-01,
 0.318876256817190165193841683846776e-01,
 0.454687294853127527401997296541151e-01,
 0.518769178386926065426450709636624e-01,
 0.511460678363363569869985013500591e-01,
 0.445923071401762480133757330905424e-01,
 0.344170087480001510168386019785177e-01,
 0.231521116010568929361541729442473e-01,
 0.130742382729956757914937260827694e-01,
 0.571705179416570803249631200215328e-02,
 0.158625934293003243725179191704183e-02,
 0.134323061028247417659344012079822e-03,
 0.614755789364972929793965494211932e-01,
 0.473691439696783484666747279557025e-01,
 0.225626134798498790027496541211236e-01,
-0.700225298406607449429189317582190e-02,
-0.343564584870549985572917246787311e-01,
-0.532465731064428818030845979703347e-01,
-0.596516496030725581618288590636174e-01,
-0.526821740108612953059816353379513e-01,
-0.346434865587803813273965811524628e-01,
-0.102769615259874538011231378529869e-01,
 0.145855789025035521730425627950303e-01,
 0.345670087675419227916034109933747e-01,
 0.460622206208052121721794327909323e-01,
 0.479806163609285247506506319899763e-01,
 0.417423234030176112103766532027190e-01,
 0.305754058217414372774073358507787e-01,
 0.183596499682541749782491513178947e-01,
 0.838373828412500746423284857586361e-02,
 0.239323439226567514159277398095743e-02,
 0.205781251086827170924290031926991e-03,
 0.174574670495133923708548551785433e-01,
 0.468621407964651088209581702515753e-01,
 0.615450381838697101816238582987742e-01,
 0.571040866582161480621532687741493e-01,
 0.353120594208807247585399476191427e-01,
 0.340406251651285630549319565502474e-02,
-0.284309270943055464642507163008094e-01,
-0.504568428845506117047639856550493e-01,
-0.565093286836577725567077444825945e-01,
-0.457760677885648666046128811386386e-01,
-0.226914519033641377511649285252428e-01,
 0.491965664906070830588582508659391e-02,
 0.287037331067197839238004374721782e-01,
 0.425802355581497304007428403001643e-01,
 0.444950632969126723710026658196904e-01,
 0.365728434484675511077190647273886e-01,
 0.237356765011229807769627144619315e-01,
 0.114255168964656318939867673498946e-01,
 0.337367335491764917214874636577696e-02,
 0.295340718402387452623161649072456e-03,
-0.594861985166842209721493343965117e-01,
-0.356967201143571357049249376649731e-01,
 0.210453832795464598773072308070554e-02,
 0.385023007153905847064770583675223e-01,
 0.589208790646475611079186500225756e-01,
 0.556358609577829372248408410974794e-01,
 0.307613214885558573804211371668956e-01,
-0.498211059178602244975296081414576e-02,
-0.370519103181686421248704969844828e-01,
-0.532347404929951770334790870895875e-01,
-0.484683284529188782519852974850837e-01,
-0.263393415185424205028826847010155e-01,
 0.317865539470489149567120205670274e-02,
 0.284981166779283587844301624556382e-01,
 0.414095454367994968720315275733344e-01,
 0.400511614381614021207109986919384e-01,
 0.286908638101844080614379439718367e-01,
 0.147159463057097767024537763772910e-01,
 0.452039591837412584704088981903736e-02,
 0.403994520021975464270148426240796e-03,
-0.220675744103005650265409516386951e-01,
-0.550438983073062535526644302378698e-01,
-0.603134946385655253593846556918511e-01,
-0.355862788379163343600224876696258e-01,
 0.618886798221898245034266250570763e-02,
 0.437678615825354036025019858162896e-01,
 0.586809080877716995597530503828738e-01,
 0.445213830997383138588871528730197e-01,
 0.965640315898595824820676542901996e-02,
-0.277864363088017057075094227843951e-01,
-0.496565814517542802520599059316125e-01,
-0.468742342996015354636906870368708e-01,
-0.231482835698577159722780974254446e-01,
 0.824116689192918787623002040310960e-02,
 0.323034478108353686447963648390350e-01,
 0.401837540893916516565334721357739e-01,
 0.327084459215908407085777104272663e-01,
 0.181035894425680112880818426016253e-01,
 0.582076966979363287506416974068994e-02,
 0.532555382735668290250771800346094e-03,
 0.574678647413419292008422206423583e-01,
 0.225056470151268406200425035142515e-01,
-0.257890191110154036646354867517408e-01,
-0.577792130214827818856153477637922e-01,
-0.543344793724903042201433038154022e-01,
-0.184584752336143012371766299173223e-01,
 0.271717346347884655962557988902126e-01,
 0.548316681471874084248381454295711e-01,
 0.489402204806181305908611878822156e-01,
 0.149246073498380515227249897047345e-01,
-0.253844746904632392802138525591291e-01,
-0.481583909200626831057612423256260e-01,
-0.420792255751417763911458095361857e-01,
-0.138177154405191960001891535641079e-01,
 0.181904105982954662711096635308100e-01,
 0.365513523939071974390094819740201e-01,
 0.353174137031399061227009712801354e-01,
 0.214201341661863997388790437197626e-01,
 0.725711169128379676010594702744505e-02,
 0.681667444132407038498762908029042e-03,
 0.265201848679911034904531688243621e-01,
 0.601660451205020732314741458207179e-01,
 0.500126781646197335127547679643102e-01,
 0.398609562598122326547448127181571e-02,
-0.439229761712665293677839266482822e-01,
-0.591382816115432564096239408648995e-01,
-0.318131919316460519307894388452914e-01,
 0.168435077783093623386158917454315e-01,
 0.512865477003198614349224983264478e-01,
 0.480688078160434196081069382213463e-01,
 0.119764992225496793049074195947934e-01,
-0.294399437706387525035305295111981e-01,
-0.474314123031445803868135029835562e-01,
-0.325249671307393394435540729112246e-01,
 0.114661698713005779964492201399076e-02,
 0.292273752845395611443876465829116e-01,
 0.361401619549690090807876321876583e-01,
 0.244893098286857512848386103232774e-01,
 0.880714890917725606137521280893060e-02,
 0.851814500534829349914841431630518e-03,
-0.552372117658269609079021446590697e-01,
-0.829367864528535398315102615962476e-02,
 0.452542275355679870402650882812433e-01,
 0.597978306102079583603310945486769e-01,
 0.237531971459500452494597496888844e-01,
-0.311801753354403357324024017816832e-01,
-0.582476242452777714450302934091801e-01,
-0.359354426138312589981170755917907e-01,
 0.148522684137639632760591607394950e-01,
 0.505732932349263073475055123710930e-01,
 0.429728697866664521817239878481494e-01,
 0.159913890821734324210584463779997e-02,
-0.372940357931400272731914183088946e-01,
-0.432976300389530752834464834156753e-01,
-0.160477004849646099371170163196816e-01,
 0.187948011712790145128972586936010e-01,
 0.349325089582855138608139536094595e-01,
 0.271362331375226945764084155737170e-01,
 0.104445456283909887219365406118104e-01,
 0.104332617955436926054566952719016e-02,
-0.307994831054615065914982463930437e-01,
-0.619943081896189596372498385022644e-01,
-0.322759037001520963995185977606402e-01,
 0.284540102584706832331831794641805e-01,
 0.602665787372487522303596692336287e-01,
 0.329263022546197442868828727276003e-01,
-0.251616853876219748021550829667383e-01,
-0.567471125745967322100303866148427e-01,
-0.327838540984757990342791172463608e-01,
 0.207604119790089313823557993693672e-01,
 0.512634475646897490415915212555575e-01,
 0.318990700296985967636110570589761e-01,
-0.148636623590386923225908654895767e-01,
-0.433747122987456791883041277493154e-01,
-0.304247370720510934865248281749080e-01,
 0.629072271232153307583139184130562e-02,
 0.316124450319929784156105917193000e-01,
 0.291967655476581399818401043347398e-01,
 0.121394979878487937470399069087878e-01,
 0.125638285459680628862439670947844e-02,
 0.527392843979977076784567733774518e-01,
-0.625227162869152078552494388883701e-02,
-0.577433265643650360692286103449644e-01,
-0.442960104421016031949647292397528e-01,
 0.179061821912934818700662832220799e-01,
 0.586446677490063510650843060349602e-01,
 0.336102840746467367525405774941396e-01,
-0.270881486426372067829309625477993e-01,
-0.553831257657638633144047025337422e-01,
-0.223228701288967581280004812596779e-01,
 0.323887084390808825795605945469690e-01,
 0.485403765622439962769865906409586e-01,
 0.124839705311777757157806096876923e-01,
-0.326216248482510444729284188093955e-01,
-0.394030964967696246543211620639340e-01,
-0.691522142198079495344499921562335e-02,
 0.262748884433880782575600517378194e-01,
 0.305264466609447256177463486033407e-01,
 0.138593899611238257822466034720441e-01,
 0.149101981015633139553562965232929e-02,
 0.348849569626042429047708040577447e-01,
 0.604524957990829740585502628516325e-01,
 0.979329916699054223412326814924535e-02,
-0.523750706896327007496013525346343e-01,
-0.478396905465910402439890800134549e-01,
 0.160570176280636190191182762983302e-01,
 0.578770134718723744731815896820593e-01,
 0.266561522035918412524921077327209e-01,
-0.356809080199796495964774751720929e-01,
-0.509877593995337604237676721854596e-01,
-0.368713578450237025524389311295474e-02,
 0.443379024106346979089487314792855e-01,
 0.356077823915405299058512928975390e-01,
-0.136551743590245336996983506686149e-01,
-0.413051111929627807025364594975987e-01,
-0.192930206545333175482505146679925e-01,
 0.191909111636459918685190683921419e-01,
 0.310085772232381055216433122652104e-01,
 0.155695021440495111159324697268772e-01,
 0.174713099111215506304048839009201e-02,
-0.499599302189951040491673960806229e-01,
 0.203850379056214365846785988951017e-01,
 0.614863046572281182495303219670545e-01,
 0.159533244187074192228665421849499e-01,
-0.508521456498031716965613076241929e-01,
-0.451978266301479079965395287586450e-01,
 0.227567162221277478465541439896822e-01,
 0.565708448383766908342919636466038e-01,
 0.112892562442609116864266225430921e-01,
-0.467311444799018585964023848228790e-01,
-0.377586532501421733399950504604497e-01,
 0.210379668460997145984437965828057e-01,
 0.466894038452820406861122357223051e-01,
 0.876315806622275323441350045008575e-02,
-0.357123815513729997841303322647320e-01,
-0.293522528885584696113274468925784e-01,
 0.107912345161987402705977492472120e-01,
 0.305610579440211569241282110000130e-01,
 0.172337621937325824577426608647653e-01,
 0.202447256206326566663147668626662e-02,
-0.387548696460547367776970525022949e-01,
-0.556373649282436709525972098759715e-01,
 0.140669308784289171386022444773539e-01,
 0.609425328477138025909857027963476e-01,
 0.127887128350581229304039906338997e-01,
-0.536924962970405660980183323193709e-01,
-0.356972482365975587326525460956006e-01,
 0.359417856936596564273561433178205e-01,
 0.495718545448721865167191431172322e-01,
-0.122699769455700292215347916456517e-01,
-0.516012796935888772324927046094501e-01,
-0.113375682812979719774821233821479e-01,
 0.419286967040883346741453407806707e-01,
 0.289201805195834177435271062825821e-01,
-0.235846717616214076626317574329013e-01,
-0.358427668515343310282248276404928e-01,
 0.163516698264875276888764519794952e-02,
 0.291416436728110161666924483514036e-01,
 0.188155240882196599949703906315120e-01,
 0.232266643385398785139134475012890e-02,
 0.469016371922896159801737576906797e-01,
-0.333632447638162665259774964667067e-01,
-0.559896197253192538598195654959855e-01,
 0.169327053179214640957370529561086e-01,
 0.596144492653531368630094138831446e-01,
 0.472442439301561467507549107624026e-03,
-0.574309967721006623850734861467736e-01,
-0.168022355726195361251986797152320e-01,
 0.498044376414654472292821606702705e-01,
 0.301118184740443040139726538408430e-01,
-0.377678090800644399646456982095158e-01,
-0.387743128883486430839997666016310e-01,
 0.228975949443871523556578819623968e-01,
 0.416231044042094986663030249228864e-01,
-0.711299835206877184120993373830908e-02,
-0.379284557131580433723919661574476e-01,
-0.763255740700609733997434583804455e-02,
 0.267513433092523631135143810919232e-01,
 0.202783622058559586436367347156039e-01,
 0.264120386829754799468303644994915e-02,
 0.423876320353198896968619103147206e-01,
 0.478175007158006512167105558163074e-01,
-0.357496477860723372682721108169724e-01,
-0.517772876799145533842582362184734e-01,
 0.282081425191617499325484262467321e-01,
 0.540532800120875611609774166442532e-01,
-0.201018970123561259952559540740902e-01,
-0.544814820150798322071404843033608e-01,
 0.117933374047087091871467226466752e-01,
 0.529422703035940457806653124448885e-01,
-0.365592519242621735173829088916226e-02,
-0.493419432184699184004036717665989e-01,
-0.394242976830056589921898732399165e-02,
 0.435626529359321019711805307757789e-01,
 0.106700309187845673333334957594351e-01,
-0.353097218199560056079130486613973e-01,
-0.163334947431712402234450084321344e-01,
 0.234357805480400557864911040105761e-01,
 0.215868654960004272052480397587949e-01,
 0.297944924008820944737511882356449e-02,
-0.435751548115346272649711172733510e-01,
 0.445003038390309334417070020934655e-01,
 0.421181295883743773687920038028085e-01,
-0.448235906085480617135659255861493e-01,
-0.401987510840139705719999208565718e-01,
 0.444713471963294329419795860379043e-01,
 0.378883706071494797216348205011871e-01,
-0.433607487014549928142516569750724e-01,
-0.352625796258252245501274878273326e-01,
 0.413895136816592433732352643638260e-01,
 0.324053086559946211525227916673207e-01,
-0.384145752802957503928541252995017e-01,
-0.294185360530836852821266951865333e-01,
 0.342015818052930259783980849486031e-01,
 0.264511358308588550021560497916321e-01,
-0.282768573322627190023174338525253e-01,
-0.238114241619993213059626727477347e-01,
 0.192844250164573608681538674661743e-01,
 0.227074166815000344512588181014769e-01,
 0.333664401198352897770245892315963e-02,
-0.457624700239948430555906164111238e-01,
-0.374206664693924946392908734357575e-01,
 0.520355326272171792904034238121676e-01,
 0.276124876437286694493224521313578e-01,
-0.558089176247140890821186487569075e-01,
-0.170692818459011095790985084786904e-01,
 0.568556854302387589085633109756447e-01,
 0.660287574295927113708551654368422e-02,
-0.551735677827024150007234184734573e-01,
 0.294310473231687592516110687493625e-02,
 0.509940799703250870323929735696773e-01,
-0.107323533547833661272096038249199e-01,
-0.447848013389754699959460035679963e-01,
 0.159445003258538786322681768730133e-01,
 0.372620658369904417346209126661985e-01,
-0.176857133778932274421240860941814e-01,
-0.294877364115142611249358576161108e-01,
 0.144277030212906474769255242128383e-01,
 0.236089414679232476964420907785214e-01,
 0.371191096248395142329521931342053e-02,
 0.399960671543294802923458128195363e-01,
-0.532050992626402290779663115223177e-01,
-0.219696484389037684493534900928352e-01,
 0.596729369151060211441738428972245e-01,
 0.186196665838787023643562283313184e-02,
-0.586352954284931461389192033133924e-01,
 0.172714405328600205454173163136141e-01,
 0.506286362783365312746193392511324e-01,
-0.326079522014080249753621950463055e-01,
-0.374030391905660640206495748984642e-01,
 0.420740873167708442640100361898072e-01,
 0.216286989993856484602236390135888e-01,
-0.447408223441944626022168438397254e-01,
-0.646630241710088849642264318658127e-02,
 0.410491757953091225801643470970264e-01,
-0.485747654141482476836878270083242e-02,
-0.329114981598508330878382236376631e-01,
 0.903209724359100423666622263787522e-02,
 0.242636131115819232829887104599534e-01,
 0.410425869251698813140761732535306e-02,
 0.488598094826787586447616545992436e-01,
 0.250116656060465594771776915188285e-01,
-0.605154238737413553653725971557035e-01,
 0.451363684685567349219698318322651e-02,
 0.570684769107079031530821526021398e-01,
-0.316335138410061483265240864700385e-01,
-0.400904736175145288733624617730363e-01,
 0.492352126537679769040777659517510e-01,
 0.150645602613463184473518170808598e-01,
-0.533877747909530700138572006961135e-01,
 0.104435593870686036688644735903252e-01,
 0.445162915626921583145666994172864e-01,
-0.292807968909932797781355678172430e-01,
-0.271782399867265230679117999989128e-01,
 0.370751729671616202874668571999839e-01,
 0.858529655446023015802110531235267e-02,
-0.337998055045121575751241780102010e-01,
 0.329344055424462049058394186636201e-02,
 0.246474983961125971028861801439320e-01,
 0.451258642780493433030522697939499e-02,
-0.361831863492322682509971689784509e-01,
 0.590155100667245686786677864474889e-01,
-0.143543058242658085496115751663972e-02,
-0.572269420273361934339902175414824e-01,
 0.373004835720641585804798625671489e-01,
 0.323539552175816839122678653908277e-01,
-0.561266425245835499468964510013753e-01,
 0.366944837784618476080654467815020e-02,
 0.511145581041828264295909408879415e-01,
-0.345912105210021073519656058061101e-01,
-0.268205271656844629632155881776253e-01,
 0.478989411598448806960762710445576e-01,
-0.372085907601703222971757295144502e-02,
-0.407601361257119420428823418440865e-01,
 0.260726336909186526223780817919399e-01,
 0.209254275046938332670952375072578e-01,
-0.320648148675300610606337749515667e-01,
-0.257130388049906984900006951744752e-02,
 0.247411320630778826401104480308475e-01,
 0.493568912583459360185214121272312e-02,
-0.516615308120485953560277975079981e-01,
-0.112624093447607277051861801383820e-01,
 0.599449958060777401127827716304959e-01,
-0.352960627160573695088428635093307e-01,
-0.314638042314984649253042345843809e-01,
 0.584808919011635561176122578894147e-01,
-0.143101571382923787343735758517252e-01,
-0.451779198184137290793828659526211e-01,
 0.477489420681034354453136714746527e-01,
 0.674631420851872568408728193817285e-02,
-0.495726124217295074805840615644752e-01,
 0.302799642223307368442199564270376e-01,
 0.231182397264531988951889395608294e-01,
-0.436348222698760588661000888791603e-01,
 0.101163544935888461974507365999258e-01,
 0.305736174360610889532748543760846e-01,
-0.278249323216386378322442353496191e-01,
-0.833341002329262701587066514587586e-02,
 0.245300080104394346072033165019342e-01,
 0.537226289009704289036963356115770e-02,
 0.321576969527238285130941869777420e-01,
-0.616241247692161628233201680228857e-01,
 0.246019853860634244990637014604096e-01,
 0.382317302828214858201584822760415e-01,
-0.588728204621407088681632157409371e-01,
 0.161846153235602587940712664779550e-01,
 0.422495531265808790821108855846847e-01,
-0.534545087838096711322686432994992e-01,
 0.755767763067515915293472174075794e-02,
 0.436750545065173291412085952191584e-01,
-0.454966346098399820630881879471347e-01,
-0.622565741677468109081018348441440e-03,
 0.419534115518285745900837997542274e-01,
-0.350316928501770406271930197311189e-01,
-0.776393660119388817170817412353189e-02,
 0.362771904694032472683634150676842e-01,
-0.213989624345813955335770573697218e-01,
-0.137624802659783649549393201694138e-01,
 0.240049770854565795130169091230058e-01,
 0.582091068914057070789450833158708e-02,
 0.541511548526284620194645020012256e-01,
-0.308398741024592579941480811116563e-02,
-0.504268597573357025220694010614360e-01,
 0.558457053588746790045713007050946e-01,
-0.891489981329294506811502356142814e-02,
-0.450407197041029544168838905164042e-01,
 0.552321591160046276532924718964285e-01,
-0.137259611024634593754472585619591e-01,
-0.384563713159169815210234471098124e-01,
 0.521021468988679144513123332535316e-01,
-0.167894468722474670776751293055822e-01,
-0.312454175311238152783840393610761e-01,
 0.462557530237308103748585837670788e-01,
-0.172027922869278113913527879531624e-01,
-0.241581582010087599323898667885592e-01,
 0.372870484142001732558039042240008e-01,
-0.132834539049504381428531753328332e-01,
-0.186367988098106593706596934809292e-01,
 0.231625430238727911590736600709251e-01,
 0.628014837371121218480204349189022e-02,
-0.279426379406670901375169199816641e-01,
 0.608952210374752322788776196317259e-01,
-0.440784503604326612951787523479146e-01,
-0.820258815532837458700462249857177e-02,
 0.527498122108154021189314469309752e-01,
-0.535449982423673917815429140427445e-01,
 0.112488734366247174785922004398060e-01,
 0.383246653214535574372627104710453e-01,
-0.547826231275803235706168105796717e-01,
 0.265217589674534812165674844659558e-01,
 0.210071997038762642112786226999056e-01,
-0.481312929137048844185433682016457e-01,
 0.345234800189750241488985350952468e-01,
 0.515995987664345038438878625539725e-02,
-0.359282120909700074387608642363347e-01,
 0.334600841709686667626609272700837e-01,
-0.411490985277281076837236802994390e-02,
-0.227534684223328055320843561827656e-01,
 0.220050499902850558642100352367510e-01,
 0.674841098165146861136262214350684e-02,
-0.563139876369820232573640454737341e-01,
 0.172530508092151829653951498055139e-01,
 0.333930098984189007257724966266048e-01,
-0.602455337007417138432173307268449e-01,
 0.450744300214575187906408669297198e-01,
 0.622614119890883126585548664068212e-03,
-0.443307239472555068439227643595498e-01,
 0.559342531251689328700092345527201e-01,
-0.288146905974739078904717832407262e-01,
-0.163709552213646396490664266113894e-01,
 0.474129284307744225034269953882596e-01,
-0.438490357567602065171316334727081e-01,
 0.108161557325270764555036414969186e-01,
 0.261566189359288025265123186288689e-01,
-0.408124198659748459017120017009394e-01,
 0.252826994383780093164288499491025e-01,
 0.538016648458373133776189732484492e-02,
-0.259378571191563200023136204847143e-01,
 0.205407572176548077495292818782095e-01,
 0.722405931715125941392835401321191e-02,
 0.235625466452243411654012393816470e-01,
-0.568722955664392144531751871692187e-01,
 0.569683843798009609601857214477291e-01,
-0.241761017791966197617914393771449e-01,
-0.218472384935232269788095003972260e-01,
 0.540534611546075580193998679107735e-01,
-0.541669557678727509348133063842308e-01,
 0.232775254991508189039678337293537e-01,
 0.193996808656314739539719456999466e-01,
-0.485650017817592776759853111184594e-01,
 0.481086375091616000078648886363053e-01,
-0.202743659198739377532505455082161e-01,
-0.166428512167079570276773212670809e-01,
 0.402366431373643669307732642032475e-01,
-0.378646623782245824722319776934334e-01,
 0.138114839852537488674437034682638e-01,
 0.144433567698725820673835233879667e-01,
-0.280519086265188153622426738572934e-01,
 0.187837983870198193992268992224227e-01,
 0.770538678829590356313627814659832e-02,
 0.581372370722720806201023783242633e-01,
-0.304805385700149714169267302868380e-01,
-0.113902604151328612474422203775047e-01,
 0.472464034233633740074648128249754e-01,
-0.600409442110374693513829119439703e-01,
 0.441974210418699300143631504244045e-01,
-0.811109009517306431739893756289941e-02,
-0.302962833601209269199991075760608e-01,
 0.526240821470548866851139636173386e-01,
-0.490261241501068122220585015309562e-01,
 0.227109256838166386925250922157915e-01,
 0.122221316939631040550199800679149e-01,
-0.383162407159304209744200713067518e-01,
 0.436698625230513567074089717767335e-01,
-0.276420509309151524815440463789221e-01,
 0.538152109772988655913791236369819e-03,
 0.223457784342134991816278378146547e-01,
-0.290009187165970021086671990161082e-01,
 0.167540255899325410627888905534541e-01,
 0.819062648456056794728905625055849e-02,
-0.190431841799203317945706300822882e-01,
 0.497758332385967390956844799108864e-01,
-0.613593302393968965486574086482540e-01,
 0.495581753449105998220862141999276e-01,
-0.192981134825422621883845497155924e-01,
-0.174038242148924595347875234733342e-01,
 0.463094911944701555792664677632277e-01,
-0.566294882600015225711214875405464e-01,
 0.451912327522611512109060650265469e-01,
-0.174487207270979400304066262894746e-01,
-0.150060239716842369800264877066020e-01,
 0.393319707805062432473921987616198e-01,
-0.466672918454512924000873514858029e-01,
 0.355397752752272016405966739738682e-01,
-0.121032162916459191895711275157415e-01,
-0.128039848094268537209938211819209e-01,
 0.284478024526792268028086220099317e-01,
-0.287384465679370038864174846934176e-01,
 0.144767399333284053380464315283134e-01,
 0.867795847390482195321225689927056e-02,
-0.596101081046661792478261222847766e-01,
 0.420535101559784552416364007701601e-01,
-0.122994087887520423028422672959332e-01,
-0.206170626289323333400897484044199e-01,
 0.468118836943980370870870759613710e-01,
-0.586201204073430035332749922918505e-01,
 0.529294416687521701314753488382560e-01,
-0.320465763504425269751426200611100e-01,
 0.284141577045660394227480356909458e-02,
 0.255306870887105066762964549440679e-01,
-0.445744332164803422964709918775143e-01,
 0.491095112898162682169840397344188e-01,
-0.387856919241060076778369999631706e-01,
 0.179932184723772412126558780017409e-01,
 0.576472038851599846879177838637574e-02,
-0.244667796492378345180527211707331e-01,
 0.322520333461786018526278885575849e-01,
-0.272691132009244811424695617253185e-01,
 0.119823130365258603786693109431547e-01,
 0.916551729738416938670945340454493e-02,
 0.144113033002248206967254046673703e-01,
-0.399914839603520384894865468644056e-01,
 0.566053427387415759549031423964846e-01,
-0.606282139528473527147898565000694e-01,
 0.513670272399846347559964547076784e-01,
-0.311883860962914616359424052031268e-01,
 0.491617691974675982878335046357378e-02,
 0.213494627032275758821728486720600e-01,
-0.417000044425705969860506526000156e-01,
 0.518138040807139046107450525825974e-01,
-0.499405245531930364390113911112807e-01,
 0.372407094356709671888835104485473e-01,
-0.174077217274164025428630487643288e-01,
-0.432273887610329342490493546836484e-02,
 0.225196131999659548783408918006179e-01,
-0.329173815886532761901586292577536e-01,
 0.334450646083981861343324803723497e-01,
-0.246491340375752584229583054643200e-01,
 0.930570579051658450416677096437483e-02,
 0.965139963768723151123362563980948e-02,
 0.607238797650859889900858289420111e-01,
-0.513486500236918443564192365001011e-01,
 0.341471810014409287924261329034805e-01,
-0.119498965906951939432313871027742e-01,
-0.116192402479878889052427618984001e-01,
 0.327649302866894269083022062652036e-01,
-0.481675284196552949675301463755582e-01,
 0.555412947196878176002662001513571e-01,
-0.540065455102659395613092602470793e-01,
 0.442117663771329111266670222890634e-01,
-0.281864344249999360839624380876424e-01,
 0.895325143507765031564460161447408e-02,
 0.100288425522220703257870644014358e-01,
-0.254896902717603445227128964066399e-01,
 0.349279849594261925539941095760003e-01,
-0.370412067171512774067113817646873e-01,
 0.319244235588070601759111128232174e-01,
-0.209845354220452290133634450261104e-01,
 0.648589275955987557005851298556562e-02,
 0.101336721367045698499557891540200e-01,
-0.969443891840061523213317957304463e-02,
 0.280493102752507018183921539270510e-01,
-0.434213373220958250825095363232807e-01,
 0.542050374071060063951168481302531e-01,
-0.593216538203077946280867928803094e-01,
 0.583399773476663569943727248843084e-01,
-0.515203856605202510546357023457197e-01,
 0.397770785057535394439870782507440e-01,
-0.245632928867268140051873897875114e-01,
 0.769350453692140267020303539202229e-02,
 0.887584714406752460261118164437114e-02,
-0.232806330044318556088233935320133e-01,
 0.339700554364993579585617084508872e-01,
-0.398877239238839634421389016103321e-01,
 0.405906549801366273798918943730910e-01,
-0.362906271776004483274552537227101e-01,
 0.278083299385126535188880814826673e-01,
-0.164271108172846802772665206029950e-01,
 0.356520246535011687789819509525487e-02,
 0.106103793361203714920920186209991e-01,
-0.614719659068608214386284510033058e-01,
 0.578657714983489756035472473430159e-01,
-0.509018826537006147182221561966875e-01,
 0.410592746995596536357111216387334e-01,
-0.290126661875821443702817628301139e-01,
 0.155836170609045432571694833881329e-01,
-0.168102991832752780011618943340639e-02,
-0.117645991000460045874875150743260e-01,
 0.238683769713839526525394261299894e-01,
-0.338547484712344719224707179800523e-01,
 0.411131072885024326094161871427943e-01,
-0.452411995738331303685297810018544e-01,
 0.460730835741439448441266495296912e-01,
-0.436894177667700592895943153150692e-01,
 0.384088075522658581535907012461911e-01,
-0.307593208273456611865765187586886e-01,
 0.214273123192142743091785092158218e-01,
-0.111682765016397160169736135077420e-01,
 0.588585468467731298995525894463551e-03,
 0.110795517140778281050402031926755e-01,
 0.492071099141250725819656044463350e-02,
-0.145952387721419002273838556288906e-01,
 0.237753731446879165764557303951030e-01,
-0.321522478675981466142126072906604e-01,
 0.394472782958817339784170976371281e-01,
-0.454226802689756639352524120444939e-01,
 0.498904665745919341024255981430541e-01,
-0.527195843849929643372162905217703e-01,
 0.538409245120111158832830841671378e-01,
-0.532500081631063194221309718733606e-01,
 0.510072330377534704461999193670735e-01,
-0.472356276153728965314156358998118e-01,
 0.421160990532370581805850579935400e-01,
-0.358801151298421232011923367451848e-01,
 0.287994919899724897767485118440048e-01,
-0.211720109865811051793141185175646e-01,
 0.132982371807542948245601962518899e-01,
-0.543108412119057339175216027232380e-02,
-0.239717638229418435697039084720302e-02,
 0.115392137901924775884864357767621e-01,
 0.618499606226765432823281544514469e-01,
-0.612546919788830653678020561583005e-01,
 0.600727591815687580005953274703529e-01,
-0.583212585774749842574862082981207e-01,
 0.560255540766307270673029981772103e-01,
-0.532189429336540217186146791507243e-01,
 0.499422135900135723665172478369492e-01,
-0.462430968236468956349157857422496e-01,
 0.421756088132795610754629236528982e-01,
-0.377992783732712448342239801293180e-01,
 0.331782367097811353777367595540481e-01,
-0.283801179779009168836346818397937e-01,
 0.234746520948121885428511890312994e-01,
-0.185316745995557686347945652301130e-01,
 0.136178816322184505735336473529604e-01,
-0.879054330636044314910336772029337e-02,
 0.408278052313647948055364738797445e-02,
 0.539266118038996801361971301927044e-03,
-0.534430495347451136918719338310980e-02,
 0.119873922705667165435381373422749e-01,
 0.601440282110980285011664873872136e-01,
 0.594487140924802987291825490623870e-01,
 0.580768427506234930377167642404167e-01,
 0.560652974154244268825539513612555e-01,
 0.534678483479518031427997193457792e-01,
 0.503533476739344296574787997652748e-01,
 0.468034208057954012621831801645975e-01,
 0.429097343093496783856697921253790e-01,
 0.387709347035617810829357978326413e-01,
 0.344893640340412911241598015969602e-01,
 0.301676657392716287488611566136842e-01,
 0.259053980665450645996816132215754e-01,
 0.217957719626748684757033136790230e-01,
 0.179226259745701016986674070702893e-01,
 0.143577423994106343327966915262767e-01,
 0.111585970117895114382267440848215e-01,
 0.836661957973980349788054251471711e-02,
 0.600602458819855635965417436343067e-02,
 0.408325173531520932148141181719839e-02,
 0.258703454366871350290005720583504e-02,
 0.148909357177382870142708015952355e-02,
 0.745428978591169106065980162176997e-03,
 0.298166328747599032344205007374671e-03,
 0.778901587730315078032242830910110e-04,
 0.638138457246206720378870615100600e-05,
 0.494855858482513345182512300544255e-02,
 0.146551239316148977814780601582751e-01,
 0.238000052419053880086999999314947e-01,
 0.320413976554978028512234156899377e-01,
 0.390844544930890794079163634658846e-01,
 0.446961598474966579669491025855695e-01,
 0.487165776300744065478965411765761e-01,
 0.510658321157267878248733839782556e-01,
 0.517464343703269843433262856453326e-01,
 0.508408513530473458412063319927551e-01,
 0.485045026325660575141266450486816e-01,
 0.449546458658999820702757276236701e-01,
 0.404558595310416888191124778417797e-01,
 0.353030347343535389560910871751254e-01,
 0.298029348024569197150566749097662e-01,
 0.242554628688792506963319555662982e-01,
 0.189357888613784282570102488575245e-01,
 0.140784276019654107098913175510929e-01,
 0.986423292977816303655692349660840e-02,
 0.641108676028179453270901644044117e-02,
 0.376882835785920871346460681204753e-02,
 0.191870230321912546586613262202766e-02,
 0.777320173554710099807080207023587e-03,
 0.204848109950917444966587954368702e-03,
 0.168644174738647608326256014218193e-04,
-0.517336455639348870492217637096531e-01,
-0.483553733187577847468280426481450e-01,
-0.418494248813632685986702076172092e-01,
-0.326955704756473194231683109047651e-01,
-0.215618750984167981187428601472793e-01,
-0.924810499112270115008783739584739e-02,
 0.338141062781906300911413345721520e-02,
 0.154693541942734941668592834849391e-01,
 0.262349580328670749180161735360577e-01,
 0.350352764886950442942734472100549e-01,
 0.414127877619291268180866065167828e-01,
 0.451252488738892051192116036626706e-01,
 0.461554289663701840650805378284315e-01,
 0.447002587837722237289374051449933e-01,
 0.411408747875908358498187513390798e-01,
 0.359968198697921460255428975626473e-01,
 0.298691196336842131550823678007045e-01,
 0.233779460703011038631733704514582e-01,
 0.171010164832602258621516787271901e-01,
 0.115187157552864857771984689860839e-01,
 0.697119293278534811699137682754003e-02,
 0.363144255416241316510576310867301e-02,
 0.149675933445330368942457463263814e-02,
 0.399109938161633372354390709000980e-03,
 0.330709901286037312135583098582622e-04,
-0.818244706519732814328560818718289e-02,
-0.236698182563526100102993530672695e-01,
-0.366272133505337894834460152778408e-01,
-0.456969982771581075400185258235451e-01,
-0.499714190977887392017031127450357e-01,
-0.490911959354438475800091850882437e-01,
-0.432757827864068067023317443167018e-01,
-0.332823885699529512374821761474965e-01,
-0.203001381445148286239576733258503e-01,
-0.579411053583118386755702014293253e-02,
 0.867969034719495755329685183517806e-02,
 0.216639336284495857748727626836701e-01,
 0.319694995832798260034016109558751e-01,
 0.388035009520282957803247183480755e-01,
 0.418403407379575347030676037511372e-01,
 0.412283630514564965425736978858168e-01,
 0.375335377162052269531233386727370e-01,
 0.316301598661223276525568193845830e-01,
 0.245555743834626788126033928227113e-01,
 0.173505001772968024324487929625517e-01,
 0.109080261042864463375820892227295e-01,
 0.585260244777321903555639935603396e-02,
 0.246563386495592389471904666046806e-02,
 0.667276500388246373497996709930540e-03,
 0.557428368648342815529601849969717e-04,
 0.498304861829004755867011792749054e-01,
 0.424171338384974559895845438732631e-01,
 0.287521863021456895121953462402840e-01,
 0.109662673916101381115182451990868e-01,
-0.819330560748912222860886766888994e-02,
-0.258128019961380673563771267009432e-01,
-0.392826952185942952971750096706101e-01,
-0.467081589193485331992154724570227e-01,
-0.471905898527909224957716715576426e-01,
-0.409350045298568987207624547777615e-01,
-0.291695569745098502202344530026351e-01,
-0.138967708361239903169640838472416e-01,
 0.247468905585983209501502857849883e-02,
 0.175490098363672265811259175907122e-01,
 0.293372582360950897535153919013883e-01,
 0.365575919740476458571271296500386e-01,
 0.387920985505717762856928680510954e-01,
 0.364786394562853819828030094545407e-01,
 0.307473227520655900001149674137737e-01,
 0.231399043865259434145906248840849e-01,
 0.152712034624671172544128516011001e-01,
 0.850072833822961892922357956001628e-02,
 0.367860895456822284487345541831767e-02,
 0.101358781518639869668033052599877e-02,
 0.855052834578990680162642612114349e-04,
 0.112833608433040903331140267709170e-01,
 0.315355940082597923811809081026022e-01,
 0.453385674958677680117675162368211e-01,
 0.499303293034527985624243351340763e-01,
 0.444961562157940652015500385874775e-01,
 0.303140212005932170213741339915464e-01,
 0.104441990536087019089680707098625e-01,
-0.109607929818418925823220948479733e-01,
-0.295652750970990479373672986276549e-01,
-0.417714889303094311159647066795431e-01,
-0.454476647522944881218627666273907e-01,
-0.403072256315671422855397225395339e-01,
-0.278673562043808075417587107452348e-01,
-0.110137930941703905486341259709476e-01,
 0.671159794870546592416175418952294e-02,
 0.219240821772394379296219240328834e-01,
 0.321173565436154512987651384096617e-01,
 0.361299404875806947227695816178402e-01,
 0.342615342139461538384948860143160e-01,
 0.280327384040699137939509559655793e-01,
 0.196687454525732723705273850093781e-01,
 0.114522495806616688359242432777416e-01,
 0.511749371555783623896479028281186e-02,
 0.144027056391107938701931749943696e-02,
 0.122899917561771534290439150938395e-03,
-0.486256348743138585501731211024799e-01,
-0.359497958927347004153059663000414e-01,
-0.139970902442572766907576944537971e-01,
 0.113741806253592691720847153615609e-01,
 0.334583823098702626070303829279362e-01,
 0.465301345598228403866929703415888e-01,
 0.473738523280414728534833981965745e-01,
 0.360929237590879459394984660741680e-01,
 0.159877178042983791652784102467399e-01,
-0.743971497963746550702031628346500e-02,
-0.280496462833649624370046898575299e-01,
-0.407395285885265899464007368865607e-01,
-0.427549864224655058068264598202047e-01,
-0.342835775994347704432371645962581e-01,
-0.181984392542030610136724030278225e-01,
 0.929211338967941398135940001314206e-03,
 0.182221097047001726061858185579483e-01,
 0.298640638948422387645522271315329e-01,
 0.340422899237937291878774938605339e-01,
 0.312139700407563961910184982059859e-01,
 0.236651595484456365848932504584394e-01,
 0.145501675082239967054491369765569e-01,
 0.675240338574309395834841290182483e-02,
 0.194767912615451549023575571340292e-02,
 0.168398331593824515023935343456424e-03,
-0.143069752102119599144705721355862e-01,
-0.381905624241508408636647769271180e-01,
-0.494835643417445659783480990780642e-01,
-0.445730040866633948862293269273701e-01,
-0.252731132719968209688136078416416e-01,
 0.185644146592353658420311058859185e-02,
 0.277958280194929158935016285716131e-01,
 0.441402960162328563377493352434037e-01,
 0.458910476120597571447628315657587e-01,
 0.330096891627803249311072136445239e-01,
 0.102395946970432859910501298342541e-01,
-0.146830639247729564479311213084719e-01,
-0.337473482748444106012839883993687e-01,
-0.413340867488189862827094940605163e-01,
-0.359103332461620426406297675129162e-01,
-0.202176682743474355684212186006379e-01,
 0.174680578751759695025252568561703e-04,
 0.182958953618290256997374830947197e-01,
 0.296240412143504972049353843469365e-01,
 0.320303729295704062701773113491389e-01,
 0.268255036579445339576379678164030e-01,
 0.176142265677425990455194246290899e-01,
 0.854304437567414563378436026356258e-02,
 0.253439058907371641466109372632401e-02,
 0.222410152382032750633418493621620e-03,
 0.474945959992680434473687710753872e-01,
 0.285297473088387648443131408363741e-01,
-0.169298805263212577952459961339272e-02,
-0.309504663424589951099899309217159e-01,
-0.475397394322184539056846047525712e-01,
-0.450460379796113743171796870950284e-01,
-0.248620186338169172125386029789065e-01,
 0.455063710821533168373485526408192e-02,
 0.312817888567662119102027329164064e-01,
 0.449002317579416371003786723162169e-01,
 0.406064504991375456264783513499216e-01,
 0.209181444290671680793675881803719e-01,
-0.570898875604614941215398923059732e-02,
-0.286108783147788724140896241736615e-01,
-0.393227003284902650799796843611511e-01,
-0.347885098015016009087525123322274e-01,
-0.181077115809942923301613844939640e-01,
 0.331977181063667216026814561179732e-02,
 0.212591520505539189876329058390734e-01,
 0.300934349003634317820164688859307e-01,
 0.287597908330706182754633291425675e-01,
 0.204523334130026823966757538073277e-01,
 0.104402220324410200721391095646135e-01,
 0.319728890429095093518814424236251e-02,
 0.285288320011362709814541191022137e-03,
 0.172595968661250933514200619988465e-01,
 0.434625260373966637637383946813228e-01,
 0.487835388726590712595604918423091e-01,
 0.308387292322529566425348881093854e-01,
-0.149929815868706485849245149446898e-02,
-0.325566504571188314883248716381385e-01,
-0.475750625381552167460579857313686e-01,
-0.398322232596400045778466400563127e-01,
-0.136734596013567875940627334059686e-01,
 0.179304303125204629644691359482313e-01,
 0.399330086162043117280564408194437e-01,
 0.425099957935337104828757133807876e-01,
 0.254956298852525578944498668901131e-01,
-0.208420298640708430295952473292210e-02,
-0.268937453639720468772211863395482e-01,
-0.379227421858586116311307794060611e-01,
-0.314897148542601766405672060191506e-01,
-0.122581146888491487636170070713833e-01,
 0.991587523247908677340308202588023e-02,
 0.253486156838432069744483839337174e-01,
 0.291638539194833614544938117931357e-01,
 0.228727004760379918717007998065428e-01,
 0.123875790910315926311833919717085e-01,
 0.393165144688371862603390101382643e-02,
 0.357332782024492060249200442819700e-03,
-0.462855097287860814910068637370291e-01,
-0.202499036511578302030810236151869e-01,
 0.170019442768125771708861972739699e-01,
 0.443714384351401847670770531392383e-01,
 0.465788103948653654627590602322909e-01,
 0.227948085838535214880493496231032e-01,
-0.131329344638631095816884558758765e-01,
-0.408493287561275100894266752957990e-01,
-0.451808010287666281094611433385071e-01,
-0.245395442305095647615899266514440e-01,
 0.867780664207550424835180298267179e-02,
 0.356415065773173422977690389455081e-01,
 0.419433878112449373357407738407472e-01,
 0.253931554228551328533059268109563e-01,
-0.353846484455465724242152529742648e-02,
-0.284426780832373010058885414253061e-01,
-0.365297848184045952404300635567975e-01,
-0.253208648618526780072991645493240e-01,
-0.285598954911019904302157076368105e-02,
 0.181010987576785944973124226058949e-01,
 0.278529361584143502342280976798866e-01,
 0.246960769246374721286799058942012e-01,
 0.143235384729939291779284405360956e-01,
 0.473124415139099516302635058540263e-02,
 0.438793194703492019894950441942200e-03,
-0.201367880023518694004643640896321e-01,
-0.471927445526124065491995679479662e-01,
-0.433606362167020710752639643955837e-01,
-0.113920122428532574783029587302908e-01,
 0.275255210238495400249013841456622e-01,
 0.479604073428501086665822929994654e-01,
 0.370308138987394469453968602650865e-01,
 0.258960050097907340126751083237542e-02,
-0.324523217433051403000339758576629e-01,
-0.455487721527298985274762731925743e-01,
-0.291877749251445450137520936116512e-01,
 0.485668930510158150229235874970096e-02,
 0.340707850236074102076825604384529e-01,
 0.403174455305938632765667685554734e-01,
 0.212255573398329377338563504420728e-01,
-0.941637390059997647115798918431114e-02,
-0.317761171540142857257721353227449e-01,
-0.331400730724316477423699957395743e-01,
-0.151706787808218330745239436967069e-01,
 0.899372293774324513178328314362492e-02,
 0.247848399361502518743535272630408e-01,
 0.257673908165431971084433634002953e-01,
 0.161834058820639646604636628707590e-01,
 0.558842823071753347140318838836469e-02,
 0.529870973597207859453300958022885e-03,
 0.449485190111431231530437412743993e-01,
 0.113384317164284967662741948083688e-01,
-0.305382075749267988957329665758584e-01,
-0.492713972374407228150099675937617e-01,
-0.311482046553483619172934516519056e-01,
 0.973504535517498023531919927772020e-02,
 0.425324666653048316221839627174466e-01,
 0.431377295091875920695879675878377e-01,
 0.120502779910191036357865041003029e-01,
-0.267478469214900370239240952934835e-01,
-0.444839896944016975458446749368881e-01,
-0.291528867970048446170254053549628e-01,
 0.639167377571433751861623387301655e-02,
 0.352621865617679587571325541082541e-01,
 0.371618752790877106062558089720970e-01,
 0.127751842834050662130381728007643e-01,
-0.184201465415795466472660834031900e-01,
-0.340115019200710735272199834620237e-01,
-0.251217584039502747173137820548559e-01,
-0.106099721187499225757288171801435e-02,
 0.200703528111146612595060960582141e-01,
 0.259661397407447507461411194957092e-01,
 0.179015764676089136057637985491111e-01,
 0.649427976478488449069060719502226e-02,
 0.630720907204379920678689792742254e-03,
 0.229307293531351216848375759722230e-01,
 0.492641509011226234671268432352373e-01,
 0.337660154589764889173486074160108e-01,
-0.100881061478339143886232655889618e-01,
-0.448480776116525538332662164925720e-01,
-0.413126798422166764807488159251277e-01,
-0.323574324580115870482822858420112e-02,
 0.365487665156714420473015560108719e-01,
 0.446719422953178964551263905039809e-01,
 0.154341036027184674379591169857121e-01,
-0.253718122361571959647744582311362e-01,
-0.434162230740694668685853482667748e-01,
-0.249839775136315531028024952412891e-01,
 0.126818429421000961191596042165804e-01,
 0.376049102645301579117891853347042e-01,
 0.305736036601940565009709255314553e-01,
-0.443788322500495307480730518715857e-04,
-0.276769680848026643649811508817088e-01,
-0.311122638146099243235964197493272e-01,
-0.109867836394677928339687294014575e-01,
 0.139697841049135896725084491677342e-01,
 0.252149249064363139921371290293404e-01,
 0.194137829171628682702826781741403e-01,
 0.743872238816442446869716506134664e-02,
 0.741452474777523599028121741375399e-03,
-0.434655781917840989003512311570668e-01,
-0.207839040459405093909983576078770e-02,
 0.410444676073267178875851309675679e-01,
 0.448302901165883738929652576498189e-01,
 0.615052409135360025540025352480478e-02,
-0.376513723638901854634966238975174e-01,
-0.450536430602135780937350489387842e-01,
-0.996996481057078572416984554599671e-02,
 0.333664512717845478441570119660099e-01,
 0.440463525450326018700055861940690e-01,
 0.133726693753839762660468891650176e-01,
-0.282523351993474758336720835222418e-01,
-0.417001167782697341494627379785339e-01,
-0.162028791696348124495115108281683e-01,
 0.223199996336401589142490159639549e-01,
 0.378477926963658489426729257182922e-01,
 0.183247439524305338574883286065228e-01,
-0.154287830379349447765643566533775e-01,
-0.321410946142906278554747044221834e-01,
-0.196743514989706491159531530004798e-01,
 0.687568190656514079647184781167108e-02,
 0.234856193033511604260478040265658e-01,
 0.206593186612363294388441168070013e-01,
 0.841067259465456292549352206106303e-02,
 0.862130964808283172357818118628306e-03,
-0.256323972801064486505004102845964e-01,
-0.496121595288450869560116220927431e-01,
-0.209391591697404514278835278633409e-01,
 0.295738732189239980642508989845853e-01,
 0.482309108153060444708256179025783e-01,
 0.158478374858556491640559581421131e-01,
-0.324489588999899897283297902110449e-01,
-0.455456483248051658495300645565367e-01,
-0.107492984926195978797846491070300e-01,
 0.339824360159794045469839645191401e-01,
 0.417100653310788667955234731791999e-01,
 0.607511097564991957883078447270352e-02,
-0.339305539275942302500569531748111e-01,
-0.369551795745273903676109065725703e-01,
-0.232074355412549057072497927975616e-02,
 0.320503055290051361328407339677680e-01,
 0.316009870750773359614221823020908e-01,
 0.135374913205478456462136757811972e-03,
-0.279937343820425623746397600265868e-01,
-0.261204528150686789757285017476666e-01,
-0.716953607340018946481432995326337e-03,
 0.208027875541495032747848645313442e-01,
 0.215831689605250575428971749637746e-01,
 0.939819666697603568232347665775745e-02,
 0.992778462344966954092487489643606e-03,
 0.418311327566806456557451138921337e-01,
-0.722229585622603969999606593177144e-02,
-0.475397602545623779606385035815849e-01,
-0.319474545016993253230803809419535e-01,
 0.206608131008996628492688268909324e-01,
 0.483206551272377109050715158106130e-01,
 0.193406992077265987751285959169358e-01,
-0.312499404396410457795666313731332e-01,
-0.442512481096829527611149470393741e-01,
-0.592663380853743306983490762791580e-02,
 0.376276630636080033908077686570392e-01,
 0.362481091634946358319087052010580e-01,
-0.621577943125299760738401754130293e-02,
-0.391559518603816999180632376395272e-01,
-0.259669223128998027367070229066636e-01,
 0.151506890035886936097495595765762e-01,
 0.360689891255901387931586058347333e-01,
 0.156590983057732576170222365640805e-01,
-0.193013625632789077054644184697735e-01,
-0.295572913891560304269502822236611e-01,
-0.825050206909288192671906011236428e-02,
 0.172441256854712385161078749263245e-01,
 0.221379842313946275170290622203377e-01,
 0.103886778584295179906877487640054e-01,
 0.113337475439309938902057005604963e-02,
 0.282323935008514508090365991810381e-01,
 0.482294506748425403203498188552035e-01,
 0.612251861731252971508721374645875e-02,
-0.434301780931057884561354301135620e-01,
-0.367254696267997527972699984502080e-01,
 0.167547061582821513030892069771293e-01,
 0.477270083352462404063115757485030e-01,
 0.172581936702540053322088165761706e-01,
-0.341368323831925241563779916718674e-01,
-0.406007737907472576680182204336780e-01,
 0.428742645293042190491247939001246e-02,
 0.417276350848675321347155856198176e-01,
 0.251431045589505904092810468917033e-01,
-0.216751872584333930981556585232943e-01,
-0.386390884119395868761249289147156e-01,
-0.700558313630720692711665925663523e-02,
 0.304502159913007007455931054021733e-01,
 0.277569746649830747676736533304682e-01,
-0.745503304472981459515708978448295e-02,
-0.295553451431816503221919356093109e-01,
-0.151512062503863400309016893904926e-01,
 0.129378545202085946563319984019336e-01,
 0.222858338429118162082270325784785e-01,
 0.113689921612806487490661622241558e-01,
 0.128385818966620470296872949542842e-02,
-0.400454592725015561928196271287020e-01,
 0.162485816583893417384851876433940e-01,
 0.494210197738125266163855095125401e-01,
 0.130800035551213999406305914589609e-01,
-0.410397228083942015019575304138304e-01,
-0.370003928683176245360798941378928e-01,
 0.183995683320705009952149264859860e-01,
 0.468329685243379392862598537107731e-01,
 0.962469525960532262289720041487480e-02,
-0.395322270589361380775526872741378e-01,
-0.323728192567209036159148829322542e-01,
 0.187670323780550490551294219087222e-01,
 0.416576554172927698178373294155967e-01,
 0.670934399245982361125018695588752e-02,
-0.349618102284344342183763014387165e-01,
-0.267086306950996753666021317446468e-01,
 0.162916065749509198506456985240977e-01,
 0.337648288622736362285914639787630e-01,
 0.561310988192193021992105018610603e-02,
-0.260857953496419125554116669120703e-01,
-0.208782705941640154312934453938906e-01,
 0.805717130554060962872339059845870e-02,
 0.219996845804192328761628026952986e-01,
 0.123256907717853991735255429614902e-01,
 0.144412651978660021371172301798817e-02,
-0.307213249955556933848443863319611e-01,
-0.451673446270958678171518097714795e-01,
 0.925542585419312608779418482289089e-02,
 0.490860061290271847144674109777977e-01,
 0.139346297717649007008792464929385e-01,
-0.416809100046037501221049987100218e-01,
-0.331667098732908013720051925341973e-01,
 0.250613187056887249183996596193162e-01,
 0.438738936332843700800834096374659e-01,
-0.365711830656238492752420648039268e-02,
-0.438001118610099570268261422728409e-01,
-0.169854050554582552542841710538898e-01,
 0.335682755931164242998453248114572e-01,
 0.316985557462088380491310566282202e-01,
-0.164717793970910236204510245556159e-01,
-0.370720633407287889808909206227426e-01,
-0.244482707751780567775249471035607e-02,
 0.323405127711503932721703243980984e-01,
 0.177460588622088535987318260186635e-01,
-0.195337508551693778651919432303302e-01,
-0.249712490721710552780146799197006e-01,
 0.281203085420335933327856001540887e-02,
 0.212645557839885530994840771033208e-01,
 0.132451871913289146939307307472311e-01,
 0.161403774240515814918206540679989e-02,
 0.381119814175774180601565568003013e-01,
-0.246921104744130564718216389410606e-01,
-0.465238471696394259354949808344617e-01,
 0.821352151053148067872385655974734e-02,
 0.487540464719215770923217191247030e-01,
 0.890934124537630399515167103181643e-02,
-0.445908128418672031527147025382250e-01,
-0.241817404179349662707057570402391e-01,
 0.348166334608177280989522846457729e-01,
 0.354260831501210729524638807203690e-01,
-0.210819769805493181813496987744558e-01,
-0.411280803624566403411044687701547e-01,
 0.564166216420232701955470733823154e-02,
 0.406760132616284409116627210062130e-01,
 0.900165786621335926129588314586535e-02,
-0.344545231523518752490391865906992e-01,
-0.204844595280586395751692372935183e-01,
 0.237767721889360856616198295448797e-01,
 0.269224652090855799710603976772330e-01,
-0.106596445031276502763859314657271e-01,
-0.270914885625480325492628809884118e-01,
-0.256131954874821275034458628667362e-02,
 0.200783125676599097073717967066762e-01,
 0.141139467794189815360747257380849e-01,
 0.179341096180796863833827808386944e-02,
 0.330900062524433952809900078746420e-01,
 0.405345721349207346093347203263756e-01,
-0.237159433239942938674109612420634e-01,
-0.455086854374426073561986261485178e-01,
 0.131063796001911218364261852169560e-01,
 0.476665451988770238668472066494939e-01,
-0.205472048007868622677211942263147e-02,
-0.468847466904562310096198415881986e-01,
-0.860701592319184818821144990187936e-02,
 0.432725103581535830401230936371492e-01,
 0.180710512195089789020193766674635e-01,
-0.371641051372691584550554430260851e-01,
-0.256130568837652534051560866174532e-01,
 0.290940199885547996985398457942759e-01,
 0.306412677678608631042006275115240e-01,
-0.197565266099671260992973080653537e-01,
-0.327269599646679183844055927240306e-01,
 0.995135082851718277040202362329030e-02,
 0.315997647728515848525296371705402e-01,
-0.512783433470771297206841529676625e-03,
-0.270538629129614360860989289601396e-01,
-0.781249662455746655755635380110964e-02,
 0.184520692042950286141889544418318e-01,
 0.149186764924326517374999117454347e-01,
 0.198202727888297038316603870782953e-02,
-0.360360511550120803788048452651545e-01,
 0.322632280961706159960697497416124e-01,
 0.391394932783951059528360618288701e-01,
-0.279358797298621686365875775889957e-01,
-0.414738615884418593747810411868046e-01,
 0.231822026032494895868117025419540e-01,
 0.429558145176293361857577649656459e-01,
-0.181414515281377089796998360620912e-01,
-0.435186644633859756952639155339179e-01,
 0.129613208724039714310717924989572e-01,
 0.431113734171915539073080415258004e-01,
-0.779506085998459450547914427359416e-02,
-0.416954353369061589853174674644617e-01,
 0.279827661435161204745832805888752e-02,
 0.392378821074457156378779884089069e-01,
 0.187502672880632424630578959078161e-02,
-0.356959794979980983163458271076837e-01,
-0.607898027364289281907602746725006e-02,
 0.309803657742579277657359059872056e-01,
 0.969279041040420835552182483336209e-02,
-0.248458404650017093034085817627367e-01,
-0.126901733643098398164453019955783e-01,
 0.164101863867722747907575784215538e-01,
 0.156465124988684080977355930521811e-01,
 0.217963071948254001502667552521362e-02,
-0.353295819431613012778785828450072e-01,
-0.344937960275160874217576287358949e-01,
 0.358710800446853332492322771781711e-01,
 0.333919009940943605473226143048756e-01,
-0.360895790503998469189638082336553e-01,
-0.320521300238330621185064873680540e-01,
 0.359549529587896594507750810762812e-01,
 0.305032157774049013127549273536567e-01,
-0.354342545152351798040467381449275e-01,
-0.287748318390315594311326007317729e-01,
 0.344893764689413224626698792948818e-01,
 0.268982207054027124733131077167776e-01,
-0.330729706207855665558279762245151e-01,
-0.249073795442592620357725633045157e-01,
 0.311208412862972088039234035563781e-01,
 0.228417143970687109440775380192015e-01,
-0.285363727807063807923236780221601e-01,
-0.207528309915819725865168154956321e-01,
 0.251539327762017582694559766432415e-01,
 0.187250254911950528672083033908848e-01,
-0.206320055621830838282120551926401e-01,
-0.169555864050101410584717133738861e-01,
 0.139898582903091229855512071377058e-01,
 0.162852033550994700707849275206560e-01,
 0.238592920800191497847698961503620e-02,
 0.338243371556081747164990356479849e-01,
-0.387016870078125211804160491144130e-01,
-0.279874301216622949731131327112159e-01,
 0.423954951121900611604978704398683e-01,
 0.214665997779226269919607768408967e-01,
-0.447438416496317186246563390971458e-01,
-0.145768178021158757075810733008372e-01,
 0.456548573653254440084351363048763e-01,
 0.765894384412068085253925104717579e-02,
-0.451119819633298200606791069695317e-01,
-0.106616512570526380147060839071025e-02,
 0.431764951608853879386421749855421e-01,
-0.484820875647305286307340865871206e-02,
-0.399877783332342054558464453039286e-01,
 0.973919187917177576798496462801801e-02,
 0.357626636314497438626452074878347e-01,
-0.132699092862927715286084138013295e-01,
-0.307975516006548720113948002968325e-01,
 0.150897133228698501361472883036362e-01,
 0.254849929670874869626394771953269e-01,
-0.147434095889803169040800153767560e-01,
-0.203956123277604847388057449965324e-01,
 0.112402977885554542511121853230883e-01,
 0.168232864533891005938408682186032e-01,
 0.260059559123406540544256885566982e-02,
 0.374316100783375243628136539239949e-01,
 0.272561345695324652421424086601972e-01,
-0.445561757937311411373692057682312e-01,
-0.150223530965007740201365260443837e-01,
 0.479748319191280250046586135733873e-01,
 0.194494230372615821170541792358794e-02,
-0.474467407480209495088091609064890e-01,
 0.106807431294956083793264857165435e-01,
 0.431742579664440102886865644155530e-01,
-0.216298746369697677046154942150782e-01,
-0.357815502229447921959905904987890e-01,
 0.298921472981900790960272130589376e-01,
 0.262461456833359829834478729556036e-01,
-0.347928070640716511645657927849408e-01,
-0.157931773810231963808667987916978e-01,
 0.360786254305595224448787970979668e-01,
 0.576899420046161372788573884220335e-02,
-0.339636186820888537809901299389349e-01,
 0.247853136630827103938314846126618e-02,
 0.291434575922564106457591659722164e-01,
-0.765245023453633777000715442557623e-02,
-0.228346824187396289977092856044463e-01,
 0.822154043794765755009088325938398e-02,
 0.172502555145146232868471591289360e-01,
 0.282326871614357589014605500691583e-02,
-0.314844886232539542963573327442713e-01,
 0.437860243182065495323807639814164e-01,
 0.141465477032316489472681652628369e-01,
-0.488932588441803154160449419020160e-01,
 0.511070338557610227018401896013955e-02,
 0.460439140158890557546216133095792e-01,
-0.228479145961692309834218523222842e-01,
-0.360149722210080100210476745954466e-01,
 0.360062420418726615423312910723141e-01,
 0.209433990402248482599293868545783e-01,
-0.425275497074587654457345180934446e-01,
-0.386220640719919239915420144874972e-02,
 0.417618438259084026795540418917301e-01,
-0.119499547935939973418914897970403e-01,
-0.345781825868567797292864211096203e-01,
 0.236692652817739871805692665482431e-01,
 0.231611377332749288107743977482639e-01,
-0.295338867752490045808669329777437e-01,
-0.105499205651067994013332809722214e-01,
 0.292455361056520888863612013859373e-01,
 0.647469881313936091667338553433691e-04,
-0.241448618287340262346251315473001e-01,
 0.500289956604347351573179184234603e-02,
 0.175567169890484096339307691935107e-01,
 0.305355456404249621037035014305575e-02,
-0.393881236148927249184425117910070e-01,
-0.190739361334883834634541322019016e-01,
 0.489410564577660697313618608869007e-01,
-0.614995478848301245065624833998194e-02,
-0.451366420153528831954186812828323e-01,
 0.290199964732118170269071816565429e-01,
 0.294213899883443236755623255725821e-01,
-0.431510266731245325067836437215304e-01,
-0.675865195428927240675018061980178e-02,
 0.450161489144360448204482019199644e-01,
-0.160281723012066483226952507507097e-01,
-0.349650287639125679451806111029500e-01,
 0.324854972446753902414442767998825e-01,
 0.169539765622454696640694118748059e-01,
-0.385878332166002080754974873950453e-01,
 0.290676831349881004638724783828035e-02,
 0.339460666734622827254760408945147e-01,
-0.184911716104361664285544216095820e-01,
-0.217870499669351752246032698111151e-01,
 0.257699322172698306647687463314916e-01,
 0.777535594422437843038681536590979e-02,
-0.242535132838094668973972754353649e-01,
 0.166111562154785316440508321937407e-02,
 0.177345333523493940092148657388861e-01,
 0.329102744268994612680372747730857e-02,
 0.290249331471890040335006065088470e-01,
-0.473414407425624334250682294187096e-01,
 0.104824144535323177000162256066317e-02,
 0.462236547367799464167352334032879e-01,
-0.301035342196057174503416642948049e-01,
-0.265240138990779957287237839236631e-01,
 0.460425439334567164806759656779617e-01,
-0.289067691369058845919779296669419e-02,
-0.428341227283122837935047928937776e-01,
 0.293267807716527030773282149754289e-01,
 0.229998460837840924023934778705759e-01,
-0.421011207485724410401915787515131e-01,
 0.392013482901391777724683463697638e-02,
 0.372452495712079267407726363045764e-01,
-0.261020886992545084238609119447955e-01,
-0.188795070923281144883960856375544e-01,
 0.350406226421781743448187236556813e-01,
-0.330411645925851212123950683826777e-02,
-0.293213769017675476851340877005653e-01,
 0.191348308697741737036004306261562e-01,
 0.148423413545304300563622278487915e-01,
-0.231480925872285576892647855826391e-01,
-0.172174746567304076106639317929270e-02,
 0.177769514266477807469843290621905e-01,
 0.353523123703043493434721246309210e-02,
 0.411916791933320447404766549055264e-01,
 0.102320854624651240631248664053617e-01,
-0.486091941008955589233360497161524e-01,
 0.261575122372520214963078370816927e-01,
 0.284635846646781944977115190009152e-01,
-0.468486036910967362201521439096107e-01,
 0.688101923071860130564295027043342e-02,
 0.405397149285221896055512842629524e-01,
-0.365428781893742569783634634693487e-01,
-0.122668858242035000429614396564647e-01,
 0.440349062615767817860087305287826e-01,
-0.203756680053668128160821908094604e-01,
-0.269700553321020212704726834789669e-01,
 0.386145770085943288656735750859609e-01,
-0.245455126860236368564864056159516e-02,
-0.339892318564814583018119724945029e-01,
 0.261253674315208262874097144069595e-01,
 0.126225729331006324445130356866452e-01,
-0.318660914171137269944527059676019e-01,
 0.101491846217808285964671585355007e-01,
 0.206779513674135369677689509467434e-01,
-0.208777763152834011804260343976114e-01,
-0.506059810300430841663197772884347e-02,
 0.176787140370783580006995702114454e-01,
 0.378568071860065063188656545347822e-02,
-0.264547435070704643066874448922165e-01,
 0.492459787056884270059847069619696e-01,
-0.161339837344606686213911499442353e-01,
-0.348969049364972682374784386515248e-01,
 0.458570959111650835190795064083203e-01,
-0.497235228422878807713685819636587e-02,
-0.406128673268718828451236619971432e-01,
 0.394273486479907954411601106309597e-01,
 0.589254293163702019493756519810625e-02,
-0.430175442663163182375535777827930e-01,
 0.306215019654942533860287877965812e-01,
 0.153182998269233989388328913102046e-01,
-0.418309784127120769668911718052375e-01,
 0.203615008076010310898571387824422e-01,
 0.222404037298296241782097806694134e-01,
-0.370752268172011298568190764342885e-01,
 0.974252340488564824471712073273241e-02,
 0.257111860020269042936199474165184e-01,
-0.289815205744292833932719100026087e-01,
-0.850047401495157707364021437628366e-04,
 0.247936141140502908613343303653674e-01,
-0.175517930740969341099556800463020e-01,
-0.826973793515817194723424537317759e-02,
 0.174361535047415152778600305023080e-01,
 0.404186291304633578363261223537083e-02,
-0.428353974438991120817198517590605e-01,
-0.103815886478311843992772476675090e-02,
 0.435972261700952120638028008697834e-01,
-0.412566405328132016784142803720082e-01,
-0.307716125821953704601203455792028e-02,
 0.435012515129657121676099298089601e-01,
-0.388908054766659128148560213067262e-01,
-0.500468215211177430978151806813385e-02,
 0.424942158875398026460059510974476e-01,
-0.357523900565291487861191647823099e-01,
-0.674826109991556218388853147672507e-02,
 0.405025651287161781927938871846936e-01,
-0.318274973105509402288942496292721e-01,
-0.823994952362048184908367470128923e-02,
 0.374122139084900608505298017706494e-01,
-0.270403678127748280754064089352760e-01,
-0.942563220909936234748519917361009e-02,
 0.330160494812346841026149816834553e-01,
-0.211535961503995596956177794608307e-01,
-0.103075864317164526709622653316235e-01,
 0.268419067353783926973253654000750e-01,
-0.133345091493779124707542109068334e-01,
-0.112653364202786344724348386511095e-01,
 0.170472656962423376999247679693302e-01,
 0.430323852468121361803888092754710e-02,
 0.237835415249017778176931300866967e-01,
-0.494348208745203457836747330828581e-01,
 0.296599317484651224842742450812260e-01,
 0.170409576523308989081372960778657e-01,
-0.475556345499293133202263123590958e-01,
 0.342086854703870494653361820454948e-01,
 0.995863550545773993272533687756254e-02,
-0.439329968384820242284442380934821e-01,
 0.370508776801440649285016943932062e-01,
 0.310896312636191366568676250329906e-02,
-0.388336493635456812952933656550911e-01,
 0.379006191150049425696297615001508e-01,
-0.290315560380483672917993505720816e-02,
-0.326486053958139114130448195585580e-01,
 0.365612344230972461674731708426797e-01,
-0.743250816766881878554527024791409e-02,
-0.258937056275955731030861887313644e-01,
 0.328888559325869401139346933438135e-01,
-0.971399537306993696615237042269079e-02,
-0.192557443121740944751134056381494e-01,
 0.266469103567633129716673662341969e-01,
-0.843749752502747444336904209562218e-02,
-0.139678854834435477367712190587931e-01,
 0.165117635828754536178036836455242e-01,
 0.456924341657457473715533885090619e-02,
 0.443129972361733732853626707647967e-01,
-0.818822125632034691968586027002580e-02,
-0.343910417166453129517158794957633e-01,
 0.486260948601651868650405937822782e-01,
-0.232415640572179216708946300390909e-01,
-0.205079966116210455215440636676621e-01,
 0.467350028497596510652545735437534e-01,
-0.345791028271528333337984626274947e-01,
-0.505172622272042018050633442189458e-02,
 0.392187973033070314842704928756943e-01,
-0.405234263125556278579883327963309e-01,
 0.929520192074652217905871321540481e-02,
 0.277448968209412375258325142309412e-01,
-0.404488021267696297399527018836688e-01,
 0.200479049173259549017274573205691e-01,
 0.148063177863515137414242710617105e-01,
-0.349437020937866873334749627992691e-01,
 0.253533470391664912196650096591476e-01,
 0.338515493969316565994597654146407e-02,
-0.258207500447589500746570879746122e-01,
 0.242202354160327485643165459449031e-01,
-0.310898626577310654559214164177372e-02,
-0.163045606484541845370858868206623e-01,
 0.158311095107071015437441101020139e-01,
 0.483929014426217477091170098329012e-02,
-0.210214224856434646055907933379725e-01,
 0.479025788192806490718599317250243e-01,
-0.403265836969844686723072487399472e-01,
 0.399811717324681475869058318555811e-02,
 0.346902696572578511400730108237461e-01,
-0.479866390146587806125539302631291e-01,
 0.268679672294553639142625611697770e-01,
 0.127763894700292114163080116206662e-01,
-0.421519206125910665561850079141870e-01,
 0.406568319567512256926335999997278e-01,
-0.104934526166149539993323831891246e-01,
-0.256863675556900700318637701452548e-01,
 0.418883673963539686415906265357549e-01,
-0.276692884422197551419844874718219e-01,
-0.505513781455333900541314589558978e-02,
 0.317963752051878178352307449746383e-01,
-0.339789365780783656508626962041603e-01,
 0.121035673469190255890417461206060e-01,
 0.159039676764689611471404617566513e-01,
-0.291863746588347212394938402230563e-01,
 0.197612163634666255374075211675941e-01,
 0.237877109274495043683265128124909e-02,
-0.182114172521140145442600780823142e-01,
 0.150085256421248646565910937257911e-01,
 0.511276954082808171596308725352576e-02,
-0.456188251862577517536984807442433e-01,
 0.171264579639807730199693251084551e-01,
 0.218788153539053327284016237801463e-01,
-0.468927162195403101335767597280968e-01,
 0.424351022910709226754533933637848e-01,
-0.117368479829011791970776693841195e-01,
-0.255618811184853694697600718010914e-01,
 0.460860059408004866631330025106898e-01,
-0.375348012705385326724799941312310e-01,
 0.615100986223355561015704933320344e-02,
 0.277489795003292808655726114400462e-01,
-0.430359308173043002807115374155776e-01,
 0.311117033166086053953805471615315e-01,
-0.810136974205901658082066624076118e-03,
-0.279893173544204672601990154778184e-01,
 0.375132098260588686104897637333685e-01,
-0.232719884888932826541590254960492e-01,
-0.387519910826008747156640178107047e-02,
 0.256981178067653170747465744255607e-01,
-0.289315220634368435573215228910253e-01,
 0.136411290079680488863642040706316e-01,
 0.774354240425907374197873983943174e-02,
-0.196353546976846676904784793639660e-01,
 0.140489822967274180546132109535392e-01,
 0.538905235079646992105205827085868e-02,
 0.181788912464483971156290012590918e-01,
-0.447035028675790071129641930028218e-01,
 0.471101709704262780780809772783645e-01,
-0.242825249154056083900594367508563e-01,
-0.112086467657821949025773632653995e-01,
 0.400975366310935587243635704610542e-01,
-0.470050414931101993892252362929344e-01,
 0.287380256669738688510165069406547e-01,
 0.423016350577412131481475373141595e-02,
-0.337908397562725026070829735792077e-01,
 0.442628619145932262190135989119183e-01,
-0.308431553140255228770617925171030e-01,
 0.182440872246247200738503322246000e-02,
 0.264594598655643620628245850994040e-01,
-0.389207354346388131797642654052570e-01,
 0.299264633814526968025707927554250e-01,
-0.589040017401553112536131995260025e-02,
-0.189782434890416079867160971792805e-01,
 0.310870331752802335056018953038866e-01,
-0.250840352224218878560540066011221e-01,
 0.637266082841786916126381637550939e-02,
 0.127078373876391713808657392629570e-01,
-0.205357880868035451512497818470369e-01,
 0.129591641913723549295716617724532e-01,
 0.566749090999693184363194639808006e-02,
 0.467478811666342496044221071129902e-01,
-0.254660900757127768551435353749136e-01,
-0.726550196844412395356410175247260e-02,
 0.363862646957963369738362307234908e-01,
-0.486335889910525879859497594861043e-01,
 0.386747754482481372848122693352204e-01,
-0.114704009181102171796107416148777e-01,
-0.201979413772971705365059526700166e-01,
 0.418054795913201179004995160632110e-01,
-0.438508092924159289427813951280381e-01,
 0.261166433099364662833602026352073e-01,
 0.252328352421845997646109653864261e-02,
-0.285466535070491472807706430394812e-01,
 0.402565831433534548148208859944711e-01,
-0.331589444198471147594427633730966e-01,
 0.117240959007102086221596486907255e-01,
 0.131803588290635963606640781512927e-01,
-0.297948270034445706279207800917984e-01,
 0.311435067456054641679497382585822e-01,
-0.181186841301226785551059023428363e-01,
-0.143285513323883839770557674557133e-02,
 0.170135151589345141996599515850811e-01,
-0.208859748016958737725588672290468e-01,
 0.117474148524004393282642810567015e-01,
 0.594742086832061011339098917568225e-02,
-0.152668050845876984490272674513059e-01,
 0.399496119740787239559487362568436e-01,
-0.493606541764518008765604504671107e-01,
 0.400188924184578850533361028727487e-01,
-0.156973633366127273059573181410038e-01,
-0.141138267103698514269524912715211e-01,
 0.379663362175673077360086036240460e-01,
-0.469279299154365983627454141903745e-01,
 0.379978464473558604108421979435326e-01,
-0.151322796126112193634472409752099e-01,
-0.124805699485143153563536715282027e-01,
 0.341551847907407187282923398024716e-01,
-0.419252761136507979734258742026637e-01,
 0.335541273264603666917490874573748e-01,
-0.131728161620304417190931409381105e-01,
-0.106374039380872105983202829832220e-01,
 0.284662594707365931264124166103031e-01,
-0.338794273874409045368265635185651e-01,
 0.258545762845665061567392120543213e-01,
-0.889931855697459118344497448220783e-02,
-0.911686043832910219089854272906235e-02,
 0.204354919030201011269486007081470e-01,
-0.206739534559401023407654379324787e-01,
 0.104236597441083288040394104291646e-01,
 0.622816295206412932260655492440287e-02,
-0.476958402475922561400018424327370e-01,
 0.329175536250439465427867088596270e-01,
-0.804299787953888702870566498248166e-02,
-0.190761448316483097897514133254559e-01,
 0.399471506909245966740018701400522e-01,
-0.481535532384860088962780337698430e-01,
 0.413761330189464067842325946419022e-01,
-0.220673374815853684983775421510845e-01,
-0.342362757267720905687387985718861e-02,
 0.269673337747434671975464467634697e-01,
-0.413010730144979333160347669654485e-01,
 0.423314558406767544202178937912253e-01,
-0.303462587617846687895661561723942e-01,
 0.976323850810876811063916220058855e-02,
 0.124643505583622309702044916778478e-01,
-0.292219646788898753373610261271936e-01,
 0.355765803818063886678050238393162e-01,
-0.303061179928777369580780668468654e-01,
 0.161255343274478943023236233179850e-01,
 0.142781798364561400026616243935760e-02,
-0.160292942267911636921980277644540e-01,
 0.227938042598479772914559834982840e-01,
-0.199030638072116392628310444672635e-01,
 0.899930892307510514761304461881110e-02,
 0.650902476236137589955837954973740e-02,
 0.122963204555350618895702412288965e-01,
-0.338068122211706989950330858508841e-01,
 0.468638349401641287243850371722030e-01,
-0.482667326472795489408314537549798e-01,
 0.377938933724043407914026495622257e-01,
-0.182323776636904464981943179733535e-01,
-0.537374827199445586631499183883790e-02,
 0.270522666542748038963108707997137e-01,
-0.414536788712543852054271689402126e-01,
 0.452136280348600895887906239619923e-01,
-0.377711016629163872082609965031166e-01,
 0.214358437012932299242687552599639e-01,
-0.701252108134603157744752729832620e-03,
-0.189995321416802414916524619242988e-01,
 0.327509058029970710792084103206373e-01,
-0.374307669213538729925344485286589e-01,
 0.324665791714144690492296401032620e-01,
-0.198800341858897343297687100544463e-01,
 0.362589837316294332098471293624300e-02,
 0.115764486913708642292929911839198e-01,
-0.215838701924036748414409814137216e-01,
 0.239633672813944364374435792562954e-01,
-0.185920284034616414875418809492497e-01,
 0.748714028465383596501122214792353e-02,
 0.678930260602759600962202174898412e-02,
 0.484590713189133117604507335436505e-01,
-0.392222197477507140022283244545792e-01,
 0.225748841421965462024940716085921e-01,
-0.179789680233483645494651126180335e-02,
-0.190399682870088131413902667053925e-01,
 0.359048338828431897047752812315322e-01,
-0.456066202623088068570144524701081e-01,
 0.464275382333422965703082219763463e-01,
-0.384423137644301089840776522912786e-01,
 0.234674592244493025082225785402393e-01,
-0.465479789458902689392782968673873e-02,
-0.141814321943720934540589716454973e-01,
 0.293598427582017280523886975777143e-01,
-0.380815826713767516222927007308698e-01,
 0.389782872014956182518345024953516e-01,
-0.323468337899528201063380273371642e-01,
 0.200273390284377636651446651714183e-01,
-0.495729452717000222798441690839880e-02,
-0.949655872097448342014945218350929e-02,
 0.202805942790405098289721502783597e-01,
-0.253081691044411796081269613600690e-01,
 0.238808855863898351655534811770740e-01,
-0.167745895578325361971784616451037e-01,
 0.590116471261677774089690100416935e-02,
 0.706828335498441900523848229606528e-02,
-0.927884202150541106534932112877916e-02,
 0.264891410155930334509744644729609e-01,
-0.398616366906046768566906978679358e-01,
 0.474870573565630363364105736936151e-01,
-0.483234098481847565339991104517249e-01,
 0.423470761556126151538272093314836e-01,
-0.305459004164654092849702593536526e-01,
 0.147562853931387201921399086012769e-01,
 0.262908649613771708240639375525352e-02,
-0.190360171107484448266323481323658e-01,
 0.321064200946028811520270264623576e-01,
-0.400560127046765455058270642438733e-01,
 0.419361205970763762143723882207728e-01,
-0.377593816817330070561946796311102e-01,
 0.284712032027205549214083139086982e-01,
-0.157736580059909215752630831126593e-01,
 0.183210459056053950171972739366703e-02,
 0.110865970826833036591215121220713e-01,
-0.209847634334608974337321555248418e-01,
 0.264528389096931749661549488313457e-01,
-0.268842280384295764134719987138614e-01,
 0.225485262867157583699861506795866e-01,
-0.144987083395496888634135888431829e-01,
 0.425647467253474568614484821060067e-02,
 0.734524633029694718323517952367021e-02,
-0.490346525362033492264674255506950e-01,
 0.441613597958485980799133035779724e-01,
-0.349337570378417327462664348900597e-01,
 0.223319404389732173096151637413158e-01,
-0.768798101471589367346016519716733e-02,
-0.746204346648300834928986372228465e-02,
 0.215479982821033020838883562103071e-01,
-0.331383062649143999362231564567696e-01,
 0.410956619093004018282800077277275e-01,
-0.446982788543232316364798060271450e-01,
 0.437131168053679634946892772686435e-01,
-0.384130937201436627418275828471411e-01,
 0.295367522290928851539244502008130e-01,
-0.181954682519582193494143865047174e-01,
 0.573930049692676598988825926081429e-02,
 0.640270960942078410613076100210144e-02,
-0.168891044308857667625793203922815e-01,
 0.246200402293465902341748135233018e-01,
-0.288608579823992891546763583684511e-01,
 0.293206773890466195157168596586053e-01,
-0.261761021854726615829083554111491e-01,
 0.200341343894972092655629533355458e-01,
-0.118253452408221191869378866235794e-01,
 0.256907800110146820831800827382641e-02,
 0.761946520673390999792541973107520e-02,
 0.622597299947570446654863107436730e-02,
-0.182513382996036475902035039835371e-01,
 0.290286225072259501216874273074424e-01,
-0.378288797741112754076618725028358e-01,
 0.440695151003180401967015720198526e-01,
-0.473568644793719921314964394248274e-01,
 0.475143087645679600429496436069951e-01,
-0.445937913382233083405108698392017e-01,
 0.388698942011339678679180546183158e-01,
-0.308169761413511063649621345883956e-01,
 0.210711853887004356537225154422487e-01,
-0.103803260149191885221741771523726e-01,
-0.454508144305202750275931094060593e-03,
 0.106409882277076595045587578230218e-01,
-0.194564723185400036142123512152509e-01,
 0.263030674283543580276979745348759e-01,
-0.307525579485381359979698472499751e-01,
 0.325776924053615705939211036024768e-01,
-0.317673044154271836359025579725755e-01,
 0.285237712116933721256332330962004e-01,
-0.232419780305248050894729003432859e-01,
 0.164679564508445072424007880478718e-01,
-0.882685464814541138199909981137543e-02,
 0.855718834621839855689285312490102e-03,
 0.789020993365818664661504064941061e-02,
 0.494203836758328113409064347664701e-01,
-0.475637260034931444704690112464019e-01,
 0.439326156608892484048314560144053e-01,
-0.386876201828242844687932880473374e-01,
 0.320601656004806119558531560801237e-01,
-0.243417240992243665714654426054183e-01,
 0.158702023077238365529117185791660e-01,
-0.701417079951707398541080474583489e-02,
-0.184432320923433318500876959272351e-02,
 0.103275515911952487268641095935197e-01,
-0.180796728085056725454109007758627e-01,
 0.247832455875201709544259768468188e-01,
-0.301739128680361192931868405957939e-01,
 0.340525656771181593834837642906491e-01,
-0.362944129890458504259023549092064e-01,
 0.368545232352345997052772735802218e-01,
-0.357695541666172543415155431096550e-01,
 0.331555301905828207848198535773461e-01,
-0.292016187677650726603045600621746e-01,
 0.241597945102818394673292114875607e-01,
-0.183297339077034712147534215039684e-01,
 0.120360262793492310106811716846776e-01,
-0.558503683842439105609315544706789e-02,
-0.866312212143802306562856576943166e-03,
 0.815674866796703306949711452934387e-02,
-0.314946628871649890253632956830269e-02,
 0.938000367507347479194820781611879e-02,
-0.154070169552864147736675304404431e-01,
 0.211003218007111862088399571946913e-01,
-0.263378431097129275622750898179167e-01,
 0.310085853782608869110601669974273e-01,
-0.350153377154940791054113904993432e-01,
 0.382770488364282915135557103922820e-01,
-0.407308153196073277118521313307208e-01,
 0.423334356850412314864579076773728e-01,
-0.430624931363272922194039869402179e-01,
 0.429169407399185152298487219630945e-01,
-0.419171738560529665629138554245783e-01,
 0.401045849825563692325504621854828e-01,
-0.375406044336350207106044603095579e-01,
 0.343052337491966216621995603943182e-01,
-0.304950715792838039645735619771628e-01,
 0.262208001647339070733434736895420e-01,
-0.216040084811696486308768916962584e-01,
 0.167729726042036173811033567495969e-01,
-0.118562625371523622388707365248326e-01,
 0.697054726015873244159400717440107e-02,
-0.218890158857903080824964932190654e-02,
-0.257937636278427944983416915064834e-02,
 0.841834971472850624365545241996579e-02,
-0.496147954481253457274998702593932e-01,
 0.493114842763949874940278851740065e-01,
-0.487077045299244903735609618427424e-01,
 0.478091180924018027260522116388803e-01,
-0.466241596902587165530067683924871e-01,
 0.451639676559502332947004237006162e-01,
-0.434422923760675551669795859686845e-01,
 0.414753829892532336210116834561164e-01,
-0.392818529024890746008371590433675e-01,
 0.368825245563534279562802290898178e-01,
-0.343002534890534028452295285832686e-01,
 0.315597309418183139672461824764097e-01,
-0.286872626701724654889216245321724e-01,
 0.257105186071521822279700114720829e-01,
-0.226582422114578557775890944397622e-01,
 0.195598968594123679168261327871300e-01,
-0.164452031071703100985406521906885e-01,
 0.133434698561510401594195487387999e-01,
-0.102825054291811756939642008870285e-01,
 0.728660164429151166739495022427819e-02,
-0.437226792687404611916273424003080e-02,
 0.153776954125796874438450468795254e-02,
 0.126779368083878873257364928630534e-02,
-0.426569112189502082898785706261432e-02,
 0.867428347110235226335175934431274e-02,
 0.492657924584557021378885192982125e-01,
 0.486894487389594868074175665389527e-01,
 0.477405378697376084492536320158212e-01,
 0.464362749341188904727879172374230e-01,
 0.448002119023031466292593654204192e-01,
 0.428617039045132981429481578728815e-01,
 0.406552446328130893523470370349620e-01,
 0.382196863880009374405632441549517e-01,
 0.355973629785364912213410026493126e-01,
 0.328331359424411997511920643934065e-01,
 0.299733863475058475691158051546924e-01,
 0.270649756881455020506616062535047e-01,
 0.241542001092946607958151111630764e-01,
 0.212857623321747551678035657283730e-01,
 0.185017852302382432407649825837307e-01,
 0.158408900161260437527416518495704e-01,
 0.133373604752426766312980899886599e-01,
 0.110204126543344771543486406947216e-01,
 0.891358693179384991357802293295210e-02,
 0.703427651850032963267033351287178e-02,
 0.539340323132692836106087798982643e-02,
 0.399524792117135958362132165644946e-02,
 0.283743930463938166882339702500863e-02,
 0.191110122846683785202652110509824e-02,
 0.120115467558586146961835258544092e-02,
 0.686767188454834561378355656408338e-03,
 0.341938923209260005718520961608525e-03,
 0.136211333407285142582316278188270e-03,
 0.354815469934492949467167617347991e-04,
 0.290234893676218538502485291696192e-05,
 0.665527498127927549427214687126755e-02,
 0.131376746439752560044036106094440e-01,
 0.192804315001284734894966610207344e-01,
 0.249287509131118385005431062934595e-01,
 0.299452004829169703592016708839763e-01,
 0.342144105251452888053311953814534e-01,
 0.376469006865446538865387753722303e-01,
 0.401818836383404502902540975469556e-01,
 0.417889387829107603407843673483281e-01,
 0.424684952582242571502619994589189e-01,
 0.422511123064379035412838203675824e-01,
 0.411955942664185086557280447726603e-01,
 0.393860250167581349074173096243067e-01,
 0.369278506666196923229357591675685e-01,
 0.339431778473106325072853801986459e-01,
 0.305654865045688873935097255666929e-01,
 0.269339793289565562334132297115206e-01,
 0.231878039343843382075290939226135e-01,
 0.194603880332311126007314677288620e-01,
 0.158741220006487803521239287932450e-01,
 0.125356076261315993764745833357192e-01,
 0.953166717800456729327395510147731e-02,
 0.692627419429427059935274333607070e-02,
 0.475852803372877379442787912081432e-02,
 0.304174982243152692777393520343589e-02,
 0.176372987211438534189787806342728e-02,
 0.888107910159667944178956814095649e-03,
 0.356819573605030139782921120490064e-03,
 0.934974636273799249857274713659184e-04,
 0.767302374022204443444616545183454e-05,
-0.418868228443304399056395119133890e-01,
-0.390963390663541581302213015693287e-01,
-0.346011511776642720835909886129627e-01,
-0.286252377137309023965904975184273e-01,
-0.214638732883159342934022312403966e-01,
-0.134667006519261670055032393964888e-01,
-0.501782143075805508044594381659006e-02,
 0.348586797991692654359868802153445e-02,
 0.116567663536357458736774279055692e-01,
 0.191377362807195319129502834553139e-01,
 0.256210716832462988373162368592590e-01,
 0.308641324758386741851888086747103e-01,
 0.347007338818119317255262166995222e-01,
 0.370476539594191004530420473114977e-01,
 0.379059378280000190452504922469230e-01,
 0.373570105172904776763556214400779e-01,
 0.355539407586228544977331539262276e-01,
 0.327085041080873038629293097582163e-01,
 0.290749558805147133412623930225015e-01,
 0.249316257195289557775081665717655e-01,
 0.205615734532584437240460430798508e-01,
 0.162335922106895841706889574975843e-01,
 0.121848069360426711683031553814842e-01,
 0.860599725157887266928722846510223e-02,
 0.563058118311352960627367476039656e-02,
 0.332794342929783779804045879768179e-02,
 0.170149538408636960985709030434624e-02,
 0.691533562343364726432623785419875e-03,
 0.182639321237306232059399903642886e-03,
 0.150541591003901429065414183306087e-04,
-0.109502079369884173076233724599515e-01,
-0.211065777950508249200338454849515e-01,
-0.297380420111645066790197282168148e-01,
-0.362337088602417403749467095303980e-01,
-0.401500170715037514238929128511735e-01,
-0.412436697322365543032535767467406e-01,
-0.394876451334451017456030288408659e-01,
-0.350690862861597085383937405406079e-01,
-0.283694741902339364167525636998337e-01,
-0.199290467000821353470146464385196e-01,
-0.103987938464434663675425390662392e-01,
-0.484418286945575791013769723192176e-03,
 0.911269824354809768166127809294873e-02,
 0.177522917791586529770700472049057e-01,
 0.249048320593471812096631899123213e-01,
 0.301897462084367825848941189738073e-01,
 0.333991470626327924568981696511661e-01,
 0.345053414447502477217466529054935e-01,
 0.336519125943521572092945228299595e-01,
 0.311296884925025586398694067701994e-01,
 0.273402830718200766140456961294768e-01,
 0.227510034645121981126331086366684e-01,
 0.178456525612468160696253934669494e-01,
 0.130760564570581639548452794239151e-01,
 0.881898626194219453633078165630944e-02,
 0.534254200735793533648837715787659e-02,
 0.278508316639667743494828861709821e-02,
 0.114852142082908290573010337027962e-02,
 0.306358761268055629529653025341161e-03,
 0.253902042841070127763850302288315e-04,
 0.395995178318843241710937510923160e-01,
 0.335142343202059030729658150728919e-01,
 0.240921285727970259529159729491925e-01,
 0.123280702237953285869509039914579e-01,
-0.545128909814571369082100728158319e-03,
-0.131938435046700419313115565542776e-01,
-0.243304057741546952962387255288704e-01,
-0.328524444143343014238313998306075e-01,
-0.379587742066839834681924144807141e-01,
-0.392287961519140346916632727078431e-01,
-0.366568874786883825261077043243341e-01,
-0.306387570323614254900665673984598e-01,
-0.219125318097096838276009634345382e-01,
-0.114627107696686350558964035400124e-01,
-0.399416242992387739107966282285549e-03,
 0.101719257429446109364356196389558e-01,
 0.192745511913967260003023874726772e-01,
 0.261632316300440647056061291000995e-01,
 0.303943091057061096656975333351221e-01,
 0.318555439307847823150245244960747e-01,
 0.307536570448129159527495746801727e-01,
 0.275628410014809118357539118111206e-01,
 0.229423821543149326675436422287892e-01,
 0.176352697908296089530085032336174e-01,
 0.123618044095915352504427044805215e-01,
 0.772250381953568873090030095460739e-02,
 0.412302808710804016193147113512904e-02,
 0.173062775478002999348606029787985e-02,
 0.467198156319001320875822960225208e-03,
 0.389755048039477352183148323725227e-04,
 0.149919566900245756015123867667723e-01,
 0.278993222045409322445020920709978e-01,
 0.369393774898034561801149885889771e-01,
 0.408876421882517827092644974631971e-01,
 0.392503164492639169587659831148195e-01,
 0.323274230540584351529659522783399e-01,
 0.211582026537232982510458855922451e-01,
 0.735844009525316310972479763984690e-02,
-0.712414218265578074380610822803932e-02,
-0.202980796835206356663872968061326e-01,
-0.304155359460049133182809910465005e-01,
-0.362153933059248363994346278672821e-01,
-0.370863634748215361837205306311640e-01,
-0.331276397347273918266993015017683e-01,
-0.251011195314268928864787081235418e-01,
-0.142863306676026313339206384381924e-01,
-0.226414731477265268045078129312225e-02,
 0.933418065221796469261531409450519e-02,
 0.190718394781438904068315376730919e-01,
 0.259066346406370973428769422017864e-01,
 0.293166301075988986571992131093149e-01,
 0.293345400772291802491855270661027e-01,
 0.264897731071789562432060060212916e-01,
 0.216723984640525254345757384924912e-01,
 0.159458917770827965430011838529379e-01,
 0.103432708974209566531371543351103e-01,
 0.568293653545897251738310388597487e-02,
 0.243599793750219088859276573673250e-02,
 0.666954358398969646557431142555369e-03,
 0.560694193406960706416101262049941e-04,
-0.376388419747259234372258673129938e-01,
-0.273246785978084345027618126308977e-01,
-0.122351118446432844696042944985652e-01,
 0.489437362893102627459826493183861e-02,
 0.209824445885299207193855040448567e-01,
 0.331737750814370237425697342477848e-01,
 0.393617319583620174486108844194139e-01,
 0.385630377683761753598199070382471e-01,
 0.310754070379607012481312330015643e-01,
 0.183921545328081651781654872217522e-01,
 0.289526200212598388491944628734062e-02,
-0.126091174154137436435626081621981e-01,
-0.254196122449371111319429463362036e-01,
-0.334297617878921138504256635802602e-01,
-0.354865056750557313463823440856164e-01,
-0.315528328443009884387381033363533e-01,
-0.226510316218085784752471373142598e-01,
-0.106072001388127802491870763811926e-01,
 0.234355880516413156815596883582882e-02,
 0.140062678383966870870036538104882e-01,
 0.226370644384462501984590883218083e-01,
 0.272352767224400975328227682138165e-01,
 0.276637688743670929955363102439501e-01,
 0.245827378458160955773005041708971e-01,
 0.192219896006737454692367666787944e-01,
 0.130499920850631259923251213669602e-01,
 0.741780479248208534911497549843583e-02,
 0.325839898189330184922342065211015e-02,
 0.906742804150871010715042821570283e-03,
 0.769027907849071399524797225245966e-04,
-0.188303658798887550173792216294621e-01,
-0.334250613324126568735987786617649e-01,
-0.405238404687784201200184744961626e-01,
-0.385872881735996867559272579820813e-01,
-0.281376042786382976740600496121137e-01,
-0.116174066814535812124871647105365e-01,
 0.719552559688967671643763321408680e-02,
 0.240744371318530891664183600064050e-01,
 0.353178946968720896743631641287387e-01,
 0.385817875979229200470010891098491e-01,
 0.333767322473666752373375513510076e-01,
 0.211223375965244817058924696713666e-01,
 0.475803829303741536449547883527747e-02,
-0.119839021361723252250264937833731e-01,
-0.254599058185448041647358059485715e-01,
-0.329366898360721675490099657766568e-01,
-0.331605680455225593968980289050732e-01,
-0.265504136304639008625501887791745e-01,
-0.149868024792082615223688743330454e-01,
-0.126979738655517481339747150506773e-02,
 0.116038978135452233604402822369927e-01,
 0.211560824466888341387129164859879e-01,
 0.259574736767427585639674054653084e-01,
 0.258521747795191618557503282198012e-01,
 0.218396292449777930563248662879928e-01,
 0.156682754179975770606793683638117e-01,
 0.926826957685541820546681278303628e-02,
 0.418751484499068495998304196878231e-02,
 0.118703522581021377630237169864814e-02,
 0.101681784656440799224827677402064e-03,
 0.355053570982002293732027185582452e-01,
 0.202492499887955164444268032102580e-01,
-0.432022600941497371863400504313495e-03,
-0.208338992923007350304139781462275e-01,
-0.353780542768526967661718119006644e-01,
-0.401667664828495546108142926445633e-01,
-0.340461744111218899634449481523551e-01,
-0.188824220737124778279301559363426e-01,
 0.101547187145662300674388712787756e-02,
 0.201463104419183928210911401107365e-01,
 0.333714088934538166606999774513941e-01,
 0.373245118837772369453345620267782e-01,
 0.312808455972248084116500430656697e-01,
 0.172556900987206709116861825657353e-01,
-0.668246750859039499650552802486583e-03,
-0.175628881285654853538190499488800e-01,
-0.290538624380110973940469272627354e-01,
-0.324878632974491428288357034219345e-01,
-0.275449083281843978193846392605869e-01,
-0.161497900816929192522622403479430e-01,
-0.175075225368200678742537012693775e-02,
 0.117823462901837174342548080790091e-01,
 0.212881029338008377091698426771401e-01,
 0.251311984688088602492668450059669e-01,
 0.234824470595372621606453884633702e-01,
 0.180161043540763456789511696179704e-01,
 0.111652420251843083010629370385917e-01,
 0.520927366442562844511332804216348e-02,
 0.150768721501815000990942352455186e-02,
 0.130590445014810769961913017452545e-03,
 0.224501039005096301356496615779277e-01,
 0.375079913780434516700744415885642e-01,
 0.402529004439524534805975077630548e-01,
 0.298678275582657452637628421607836e-01,
 0.988264324400021372556840614052361e-02,
-0.130446931652664227194003842164651e-01,
-0.313822000801388920908693640908705e-01,
-0.392382544555057413536793912861636e-01,
-0.342830691158651334661879974857933e-01,
-0.184398070644896016864944781280685e-01,
 0.286111832714355379096679898478927e-02,
 0.225774053854406388676017132084484e-01,
 0.344285845987717309000066471523601e-01,
 0.349328621274133969193842905898869e-01,
 0.244323914685951915272498048433121e-01,
 0.680106571756285613266755423556534e-02,
-0.120088986856624921356391674603599e-01,
-0.260339016484039523215659795008210e-01,
-0.312457608163667539755036123891257e-01,
-0.267222946796886159467146716804539e-01,
-0.146896014038598109306243668996153e-01,
 0.502228319715608188562467947820303e-03,
 0.140365699273979168926078225906982e-01,
 0.222896593486362307555529390000409e-01,
 0.239008670950131008211369104980078e-01,
 0.199162982109379758591990240084753e-01,
 0.130328855216885464792731611307876e-01,
 0.630622509282794391336368648706406e-02,
 0.186796193566576855247229173173589e-02,
 0.163792500197989791220575253599112e-03,
-0.330916098907758248201962204385457e-01,
-0.124452675590176213890561658519667e-01,
 0.128831597443587129903037523744749e-01,
 0.330626432147037163692960276402623e-01,
 0.403475797043174718101096250502965e-01,
 0.320879995569275664306732808764352e-01,
 0.116996331440723332107443619152650e-01,
-0.127648378780550710026396627014631e-01,
-0.318407889084032785607606031266030e-01,
-0.383645657841441494481114424152674e-01,
-0.301968763223714057923687896760659e-01,
-0.109060131539758299598827680241314e-01,
 0.118011427248681455454494208316993e-01,
 0.292099613778098070155247918884780e-01,
 0.350006445525386250487630371619698e-01,
 0.275699606600786460225907630914296e-01,
 0.104035438917898525390328212341519e-01,
-0.955380858338033277270119136701919e-02,
-0.247784190863239504611846978583779e-01,
-0.300832636485988288375477447841638e-01,
-0.244062307549700222713141237006463e-01,
-0.108344526138384859348737624030602e-01,
 0.501178057525219552947218124815149e-02,
 0.174451620030510269163855177379960e-01,
 0.229392064453598697687389663292439e-01,
 0.212087957614264604612554960401295e-01,
 0.147918530140536584021100616210210e-01,
 0.745797250956030663292210201468750e-02,
 0.226655310269355150598573849907862e-02,
 0.201432688913838157699164785089820e-03,
-0.258231197691344514316654619803384e-01,
-0.400009269288713015864036839460524e-01,
-0.361957472362314516620110422410289e-01,
-0.162399365373613763461037070615475e-01,
 0.107539102562859183350351696281082e-01,
 0.326002618427608355690644383105483e-01,
 0.396023199346342496043005085603494e-01,
 0.289012929629750291657434590081014e-01,
 0.564011797764908848078025013487444e-02,
-0.195321606170393415373998059947334e-01,
-0.353960353560478167276187823211743e-01,
-0.352229878687443157655284199558809e-01,
-0.196497389278946567193385864818724e-01,
 0.387598328840826974213154415323213e-02,
 0.247039940110649597098190025720702e-01,
 0.338800101142402561717102235949943e-01,
 0.280461514033140271140650451274889e-01,
 0.106150428773043915733422112605562e-01,
-0.101715702366286127395462545714407e-01,
-0.252292256845055268866203485576820e-01,
-0.287049330295056573682369870381009e-01,
-0.202615106890134451570089112706339e-01,
-0.465633825791528787567902566611435e-02,
 0.109610679237760152682499997538515e-01,
 0.205546830151937005430487545041795e-01,
 0.217620191570135267317831138103941e-01,
 0.163626754562216377632677282365772e-01,
 0.864165838405957255236605294371709e-02,
 0.270160895380034909116045831934241e-02,
 0.243637763340534600430400722736871e-03,
 0.303772358362035775869823480656646e-01,
 0.418755699840488486708231961549643e-02,
-0.240205484698177049667567897441952e-01,
-0.396653395884989260511063176639155e-01,
-0.347979945095759961490223966635058e-01,
-0.121749544282724065176175203896963e-01,
 0.163094111258853632318097748049927e-01,
 0.359370635401233314131144409876431e-01,
 0.368447393943271194476723223781242e-01,
 0.190210662552751846307437200404403e-01,
-0.793396136319941026395895178998023e-02,
-0.300324490565420289918163389293003e-01,
-0.362388071537610415519659247507465e-01,
-0.240317968393090098571576201989412e-01,
-0.352988326680880171283609651466948e-03,
 0.223703897571552027029641265849937e-01,
 0.328427162606694463014629929987908e-01,
 0.265865285653850757179369421175770e-01,
 0.778972958146718555238070197245025e-02,
-0.134203483190619681437196392254458e-01,
-0.265556728177206322406238568322406e-01,
-0.260783976565130512794772984502148e-01,
-0.136795305238911741536847651677150e-01,
 0.341373793966951060931305010135529e-02,
 0.168264830241546819496646160915811e-01,
 0.214826122947767822052405428612096e-01,
 0.176691796602457549360768842078890e-01,
 0.983249719194736638347649862745188e-02,
 0.317075821468661232562783902284970e-02,
 0.290517267324359813262710247307713e-03,
 0.289189064798343090255689270140536e-01,
 0.408119664301148075769557602889773e-01,
 0.287550726344975752273869979578549e-01,
-0.131229981332322205387067582044237e-04,
-0.284715006155087019904781444142054e-01,
-0.399679544669344000629095012683351e-01,
-0.280395884334118873386731443846878e-01,
-0.630893953049753410190209523004095e-04,
 0.273396135456328967093519503089219e-01,
 0.382628966946337130333189716172578e-01,
 0.268258753670262330065920877683872e-01,
 0.331433137210586734699445366902159e-03,
-0.254211657724754288153908288019170e-01,
-0.356534400900026240627857714709191e-01,
-0.251665904731081163570363550195364e-01,
-0.932544653643944245746655600540072e-03,
 0.225488109688187120906612772520076e-01,
 0.320423226056031363328961207691637e-01,
 0.231232860629241459189460646454008e-01,
 0.211042827327068761624752517874090e-02,
-0.183827802068515224246241448160655e-01,
-0.271926184163147335802819829797985e-01,
-0.208048626988256725672929732505910e-01,
-0.446759842012431683642236089885492e-02,
 0.119539042026406674586654986395562e-01,
 0.203229341913777690761507250239006e-01,
 0.186418080742686860172520361722397e-01,
 0.110043477062591573649519396525018e-01,
 0.367113863302979912933793901592958e-02,
 0.342164154435538227066101574798976e-03,
-0.273710174091828748498995627194717e-01,
 0.420283612568223022718707598200903e-02,
 0.328395523119849448673687104043716e-01,
 0.396192462898716156320853434712559e-01,
 0.202696727743460644069672464108956e-01,
-0.121338432971951755822024765302502e-01,
-0.360656757594331393254845220658822e-01,
-0.359506746166552135392477444047740e-01,
-0.123656009442167903647537030083479e-01,
 0.186880083266960965063385003361216e-01,
 0.367226501758907616340206540095968e-01,
 0.303857854056432178317724089442996e-01,
 0.463458470140376106987869099641606e-02,
-0.230965536510902999757958279495163e-01,
-0.348076094233738165268596414816107e-01,
-0.237177016709778721210843850785850e-01,
 0.186810940367312375619864015398385e-02,
 0.247829472668263710561945667493136e-01,
 0.306630214441490082827856492634594e-01,
 0.170334166876280651272482566275337e-01,
-0.600894761156982538873219013051525e-02,
-0.233526728006451913968442589852672e-01,
-0.250091734735261868470871281046335e-01,
-0.118815626306405566994821160649182e-01,
 0.624355036452227453385584389047265e-02,
 0.182858159563667292500365207528640e-01,
 0.192207136316589658568411684444549e-01,
 0.121303146817448696644643284241406e-01,
 0.419942838580557377951852521977028e-02,
 0.398655290353506987544406065515679e-03,
-0.317077438574081995078188002263958e-01,
-0.399144360360004825002799720951706e-01,
-0.186393732310756080691705304016295e-01,
 0.161964793287668104472342196640999e-01,
 0.387562473357437948611129225313683e-01,
 0.325641799716028149562463420937339e-01,
 0.260451175705008637763942298012406e-02,
-0.286956978605393427229185235292231e-01,
-0.383617147310134247893164651753909e-01,
-0.198380581495664098118107726802686e-01,
 0.125841778354879391705671937504862e-01,
 0.348599724122816240977432097443278e-01,
 0.311497357284634301699215893435187e-01,
 0.513497792367652342599350705712065e-02,
-0.234431830332173759361348530092638e-01,
-0.338894589160817870713900332297475e-01,
-0.196591947373978499328313447611896e-01,
 0.766147206541757962220470789250582e-02,
 0.278333652831741957332991983691849e-01,
 0.271390553087843827718425249149390e-01,
 0.774041862311175111196207249106442e-02,
-0.152222179242692403511361168732227e-01,
-0.256634758025510430701533358370423e-01,
-0.180465351780423383198773763670616e-01,
 0.865272140757939893390007928842367e-04,
 0.154262506563271694925351334766830e-01,
 0.193585091627594614431978815015559e-01,
 0.131833686898517204444429545461209e-01,
 0.475188048094936075522253297686980e-02,
 0.460051871078139310149091168662869e-03,
 0.240947284266791313775559656723295e-01,
-0.123887302887192760406102192827663e-01,
-0.385398513996944155932021820957085e-01,
-0.329799837068330920669434527365720e-01,
-0.558286741066454571627144728986417e-03,
 0.318899417798394075483774325175799e-01,
 0.378738428724926874581848100739741e-01,
 0.129863248045159358375670372801176e-01,
-0.218846546561069288234435417895652e-01,
-0.381850576127600484472722195953259e-01,
-0.232088545270533852270658048381465e-01,
 0.997999721103402829781741246530357e-02,
 0.339889272395135561899397786839743e-01,
 0.298536618449672164156043237061261e-01,
 0.208148144989322462170056280544979e-02,
-0.260187055401850970065016093124797e-01,
-0.320528978958503512413566702129968e-01,
-0.125083204613671561896624271039585e-01,
 0.155623395679920532678606443852538e-01,
 0.295454298276358678548024508304801e-01,
 0.196837877842248776602148591791514e-01,
-0.427694121059405349333985830742883e-02,
-0.226406645129220801643670608279220e-01,
-0.222928405434545883386970509525452e-01,
-0.607250940282606130194416595590065e-02,
 0.118498684660173585961222212053045e-01,
 0.190225623595329153328766178846268e-01,
 0.141369720340503590605946639466263e-01,
 0.532436014297436572846393459108333e-02,
 0.526399779842421686883081411974131e-03,
 0.341620959050048670645827257888973e-01,
 0.373503140615532014444519565678397e-01,
 0.680077550665532687186245839648657e-02,
-0.296405128508008053615168543679936e-01,
-0.390165435254238152990688606271580e-01,
-0.132007564745807928223830956039535e-01,
 0.240473494696656308790073423463591e-01,
 0.390532621108629753241710365436231e-01,
 0.188162796066687075712810082666970e-01,
-0.177055322798559710623930098658313e-01,
-0.374369056545683669525706687690710e-01,
-0.232959117360776949634251444622656e-01,
 0.109839849027325497015804837200606e-01,
 0.342242426931294970668931645015247e-01,
 0.263308669807283751735802911585090e-01,
-0.428026667432019295995292952197188e-02,
-0.295393412868782191197041100673143e-01,
-0.276559879650010610155325858559925e-01,
-0.199857511389699157952281506911263e-02,
 0.235425405451215864952652353288608e-01,
 0.270291469782707140015987487190197e-01,
 0.745938784018033956553189271104603e-02,
-0.163483565888403935228957026602037e-01,
-0.241440878461276364059246530177497e-01,
-0.117718538825993232713913220236810e-01,
 0.770824366073964787921817995893162e-02,
 0.181967433270672309740996196073282e-01,
 0.149656982208558074544490370498400e-01,
 0.591238507401786108029907130126361e-02,
 0.597729899692438197043732395837523e-03,
-0.205773543559504894743543230088807e-01,
 0.200366879148637997504525618962708e-01,
 0.406061244838562224511406405015462e-01,
 0.208778244157797295277048489166592e-01,
-0.192492210677123243978596347030386e-01,
-0.398768581175371954553383847981684e-01,
-0.209419639179574581047954046059688e-01,
 0.182040575953242746086274979760560e-01,
 0.386500859772602452580726862931403e-01,
 0.207718410701832948620473782281281e-01,
-0.168832303070803145406227584148784e-01,
-0.369057622496778207656590288965625e-01,
-0.203684513722568834231728722755803e-01,
 0.152564050383241159348834921579828e-01,
 0.346082267311905640205656428052175e-01,
 0.197327464257660364024874999936755e-01,
-0.132698616275592355971023898263888e-01,
-0.316936355351200265568916175219923e-01,
-0.188683302000077781944259631307758e-01,
 0.108204115612765152294480586683958e-01,
 0.280399203614937390053816068272270e-01,
 0.177909928741451027290713674619583e-01,
-0.768015188859785436562188101258946e-02,
-0.233776751447022828481596244009176e-01,
-0.165716744277763692570292967809621e-01,
 0.319127330414389804464626336928555e-02,
 0.168825516429239861914452317267474e-01,
 0.156458323466791760251949249792801e-01,
 0.651116840594438042891062615926990e-02,
 0.674058394541607080661273063559359e-03,
-0.362573702191867203619705177129758e-01,
-0.332295087420917163109433888651446e-01,
 0.565187534175604030315045021936642e-02,
 0.381361974510614627007483110669537e-01,
 0.292315705334034296917721933628604e-01,
-0.109706204980109931493234015979653e-01,
-0.387587532882999908778083883738281e-01,
-0.245066687090075744039181062210419e-01,
 0.156373363531922822112325773484039e-01,
 0.380947212247936338048607483714032e-01,
 0.193530840841584380920484401303325e-01,
-0.193598930094950254000190026479577e-01,
-0.361932762992028480585655871336044e-01,
-0.141157776090070717212940615112033e-01,
 0.218815653179357169071070574470657e-01,
 0.331835632452153091493544255106886e-01,
 0.918247518349055591693535077436695e-02,
-0.229817916761279703422125525896176e-01,
-0.292752564775457624140322706309737e-01,
-0.499470748003294878841572321682268e-02,
 0.224588768087834726745244530864590e-01,
 0.247665814402579810551243299714729e-01,
 0.210872184086746105855458226582996e-02,
-0.200568117117000941705489616603199e-01,
-0.200919773653956564945346518756607e-01,
-0.148295190210929450372981991957648e-02,
 0.150995727703380934507492535101838e-01,
 0.161559399605025978015092985517366e-01,
 0.711566409906155240420620333721233e-02,
 0.755386968512040882634813579763962e-03,
 0.168525526708501065936339883199282e-01,
-0.268332715361215578164341025156093e-01,
-0.388584672685758303024477987731408e-01,
-0.533343121854915224544577406147175e-02,
 0.340694596179981668936927127352135e-01,
 0.332159439293698586692343798812941e-01,
-0.630264374646854970661356883124279e-02,
-0.377494388380128712735349180900420e-01,
-0.247045190083027553721638600482186e-01,
 0.166290631703185754969525905177367e-01,
 0.375793221536807357759149453100380e-01,
 0.145293711719509051436376719645565e-01,
-0.244259271886921038298227742006920e-01,
-0.338346444776570207023262428575792e-01,
-0.413095303400649064929360749404260e-02,
 0.288646296259567516062099083226115e-01,
 0.273369790448185171453578714812503e-01,
-0.501425630074484835860489005254918e-02,
-0.296420790125985862398539181029609e-01,
-0.193699313508356710501949059162180e-01,
 0.115840999922456709724588829277291e-01,
 0.270554211547117479745305524160741e-01,
 0.115835032922523027397119015601421e-01,
-0.145297063031769107635072904929738e-01,
-0.220462673616216713348792110314816e-01,
-0.608020729023709499358749260626783e-02,
 0.128852387366068729466172271663743e-01,
 0.164773924568712725996688784853477e-01,
 0.772061449468364047539423307247855e-02,
 0.841703111176821750929303655268011e-03,
 0.379724037075712414892181936956498e-01,
 0.277257936996461177669519046411515e-01,
-0.175553323762926128334940515555299e-01,
-0.402956082155001263904988535324397e-01,
-0.119460276576159910253361896338218e-01,
 0.310816373459011091311805121886064e-01,
 0.343183402981762741611403293785975e-01,
-0.560935510846896993751958696744892e-02,
-0.376333435717338797680808053661413e-01,
-0.217647440004529056296470734838653e-01,
 0.208396252351562917715911975286351e-01,
 0.361305434854066758812639202612263e-01,
 0.596593923063813239532783441350547e-02,
-0.304189393170982027876909689786961e-01,
-0.276236032904453420045341549636673e-01,
 0.907916789050305149214641987318835e-02,
 0.327006718588403450058191786862604e-01,
 0.149703814694081797604689323558335e-01,
-0.198291208853732533258242283694143e-01,
-0.281677425180841863589268591092337e-01,
-0.202597932479303643762429564942871e-02,
 0.242089243413594522708517743601692e-01,
 0.193425835888941671327413263458623e-01,
-0.739542504017240415813409885017487e-02,
-0.222678900643821529426521624250547e-01,
-0.103634236867361333570934841108164e-01,
 0.102938942270150320592501074818068e-01,
 0.165948378223875912523233674695434e-01,
 0.832059968967830962237697034715947e-02,
 0.932980334672581838597264424721593e-03,
-0.129572926087497641305649870473391e-01,
 0.324991674995768531334924043232049e-01,
 0.334701630791979285369080871221363e-01,
-0.110740507728217865445782048171233e-01,
-0.401153183954303293356118897564150e-01,
-0.143895645262445041821348453446510e-01,
 0.304020178075654178017703446009503e-01,
 0.332658793588256470211146906229767e-01,
-0.880819206723040685640943205450594e-02,
-0.379747150193692459435335564664467e-01,
-0.152895514034104511949650134405668e-01,
 0.271826895938628058729284008013780e-01,
 0.317966323864247269976353621466852e-01,
-0.619814037421729944337430319002381e-02,
-0.343045642108431299619475962649302e-01,
-0.155701118772023855643656291534016e-01,
 0.227536308689338150462022725605879e-01,
 0.289016076993299375368290219580830e-01,
-0.319894077646528056319559603849723e-02,
-0.288440619073536781733369185867973e-01,
-0.151519510661211955206980580793465e-01,
 0.167551311758838366560094608950655e-01,
 0.242284867699094427223444827680266e-01,
 0.560115976865191497970669953913895e-03,
-0.207266424612119077143806617904745e-01,
-0.141064236403980885893061126096049e-01,
 0.739519565217672939334206813481194e-02,
 0.164966065794061025512081464816921e-01,
 0.891008836962707954050779698592900e-02,
 0.102917840740196018209962441967891e-02,
-0.392898043791893197176066523489513e-01,
-0.210698541811209612333504770773725e-01,
 0.277996811209618738042620245369353e-01,
 0.357777292590762654495644767517898e-01,
-0.838743236333186202055345617426633e-02,
-0.397827958287853865870694524622925e-01,
-0.129641663516505078065987689109661e-01,
 0.321252859809579294577646604094996e-01,
 0.297836261287316710486407178746305e-01,
-0.154832219903021047261034232702985e-01,
-0.371755237415625396753805232455909e-01,
-0.475058296947195213937880317376874e-02,
 0.333470316168993571810085755744360e-01,
 0.222581762716315058861391537609379e-01,
-0.201011493492750443903559405528628e-01,
-0.318556835493389286370407526945926e-01,
 0.214705048001892722269203862916243e-02,
 0.311410186928043793105171605726627e-01,
 0.145286891473127220474024405048771e-01,
-0.211926609530731964788447005402167e-01,
-0.246762692454861568920727165739960e-01,
 0.610557620694448814241748998723388e-02,
 0.255046686415469466130943788082266e-01,
 0.845096316109370823962953241466347e-02,
-0.175340523384382856073048253838328e-01,
-0.171072854933311198779363201798009e-01,
 0.427189631332299545085899330526812e-02,
 0.161750440177819350146767164716336e-01,
 0.948348971225435847340586483134176e-02,
 0.113024358808126948570418440810895e-02,
 0.893097293212742917290916284532989e-02,
-0.368013403031091636701882172948249e-01,
-0.249519692306160905598718258597873e-01,
 0.256309887002357435487887456793753e-01,
 0.358564090512799017089620815401929e-01,
-0.968638529862972068203897712441584e-02,
-0.394952017134102716226256177593931e-01,
-0.765596857647687792057253541104174e-02,
 0.353101264348930431566986488751371e-01,
 0.227848955310425069279283344385439e-01,
-0.244375495111745557966248205541515e-01,
-0.326577448953949139506421577453746e-01,
 0.942947680607870993773046516811840e-02,
 0.354681467626871652215785803647194e-01,
 0.634241763919379218017369529103283e-02,
-0.310272239521063616734908828232817e-01,
-0.194617311163603724531161130157002e-01,
 0.207738076073801962215785957314775e-01,
 0.272426588644584629038465956004313e-01,
-0.741560737387066994807780833396138e-02,
-0.283276792127360106522067620245304e-01,
-0.570948185253333288492646413995970e-02,
 0.229705285353233824241937985319311e-01,
 0.153908867524882937984327891160809e-01,
-0.129366923222885919788293505889320e-01,
-0.192005293460744489527768031371042e-01,
 0.101709453796101984882885910416284e-02,
 0.156267612510029152095086071106410e-01,
 0.100352059536222732983149433567884e-01,
 0.123610886313438890070663430441477e-02,
 0.401962010720324229543762625354003e-01,
 0.135398516088051020932169113962653e-01,
-0.354312655873183491123521546765138e-01,
-0.253422615818957236544401975266091e-01,
 0.265498862020191234438100458798718e-01,
 0.339146578686877676822173562481313e-01,
-0.147562307208989284097762086004243e-01,
-0.382189760168746979937179471803468e-01,
 0.163792071998848949375818269892247e-02,
 0.378159476235734943707527736368699e-01,
 0.110607252083355672025639135340475e-01,
-0.329234131556868314754031423278527e-01,
-0.216872507583205869127300813709814e-01,
 0.243805437940161775866033866416755e-01,
 0.289155764486032076613070768828072e-01,
-0.135236131743723050947603423917559e-01,
-0.319326953367181382411675096008258e-01,
 0.199207100719569894689377750706894e-02,
 0.305507116642036344468859240104955e-01,
 0.850547077057098723979900846679108e-02,
-0.252280707912616281774616160113030e-01,
-0.164277455473442902961471667536045e-01,
 0.169962401552028023727402129631691e-01,
 0.205945780833530962951250371044826e-01,
-0.729792333496205085867869481154754e-02,
-0.202673803991017401763399574032704e-01,
-0.226895732334158988718819862137053e-02,
 0.148527992454410982424485263114930e-01,
 0.105596851957605294436514735197550e-01,
 0.134669418983607349219015983288095e-02,
-0.481474899400371627155595263754429e-02,
 0.395630067629012364119767075395044e-01,
 0.141047141000136972470200836950404e-01,
-0.359352059164587031039459983483804e-01,
-0.224026906789125823910621690423446e-01,
 0.301985886317039697282710932491846e-01,
 0.291339790742821172702155838654196e-01,
-0.227924319802747701275603834857254e-01,
-0.338467221834103651295156526521727e-01,
 0.142832095462563721507029809818985e-01,
 0.362474263229819130382951802695981e-01,
-0.532078919329770878314678591073026e-02,
-0.362241654798995766176251018665396e-01,
-0.341151754866602960001176782192748e-02,
 0.338556894661454445432075651827784e-01,
 0.112488512458561515376955577225333e-01,
-0.294057602359686579531566767011393e-01,
-0.175939760155253781621264905070354e-01,
 0.233031610409312989998257444630393e-01,
 0.219585036542692850045987184215322e-01,
-0.161087575436153002476871376818488e-01,
-0.239894413027302966564438122486999e-01,
 0.847116872167637016641736250572614e-02,
 0.234684604998747894704701349913273e-01,
-0.106946791000340215912450562137718e-02,
-0.202434717105718192035733891011238e-01,
-0.548236766979873484442003742561588e-02,
 0.138587017166186771215979551533286e-01,
 0.110514740255544567659461228253298e-01,
 0.146190674712821893075777009361892e-02,
-0.406824236162611810659342217026105e-01,
-0.544995322704066855981385087871372e-02,
 0.397411346995335394613839205939323e-01,
 0.107225891002132614793010881742959e-01,
-0.378904173007097436446022172080638e-01,
-0.156458863932261071620875012511065e-01,
 0.351930379765159075040075952180609e-01,
 0.200581973816373074393683287979108e-01,
-0.317407951300351894750904213920261e-01,
-0.238128816197100392927075339259096e-01,
 0.276517921726487903436073368246583e-01,
 0.267822534697059494323730271031776e-01,
-0.230669553148946287056945152949594e-01,
-0.288605560462375995855227220657691e-01,
 0.181459154501911238433584446724642e-01,
 0.299655658992449088773181143496166e-01,
-0.130623766646102173553437683636874e-01,
-0.300381670536675976463387955012002e-01,
 0.799904082939287733449468629963040e-02,
 0.290385459778682499538724347701115e-01,
-0.314191754457878362926981118679685e-02,
-0.269356978551456670233252505052082e-01,
-0.132711039790660067357517234100458e-02,
 0.236803783328382739752727153575129e-01,
 0.524489187464966522030915309406686e-02,
-0.191234940462975711283941719719301e-01,
-0.851931556452159796635152076329964e-02,
 0.126544946278161626955300736228809e-01,
 0.115052695105887288739620463270532e-01,
 0.158164119564327086655358124279473e-02,
 0.650957183417791750970162276537282e-03,
-0.406711429109270307246396275489153e-01,
-0.194476963121121563348954824167647e-02,
 0.402903723216766808919409041872775e-01,
 0.321428393995437093939145386952259e-02,
-0.396549501014604884324949925258681e-01,
-0.444332627642043546770716802745399e-02,
 0.387634263932196659867838928972415e-01,
 0.561575925736363215294629377834025e-02,
-0.376132404020921427265041005847025e-01,
-0.671549770695286719553848600022572e-02,
 0.362000684635546874670398185977558e-01,
 0.772653522881892744877654452223924e-02,
-0.345167627522351017907236050474184e-01,
-0.863300736049491539219907719488911e-02,
 0.325515911529732555900478293664639e-01,
 0.941935974190132872564378668260863e-02,
-0.302851845548392917008382873452525e-01,
-0.100708060985302846966704317924001e-01,
 0.276848663188810037789899694623259e-01,
 0.105746081955946210601096039901673e-01,
-0.246930389688436362759169456976294e-01,
-0.109238878520818381131382466868953e-01,
 0.211997945704880068040771623366483e-01,
 0.111304925680957848159350360400395e-01,
-0.169624767951041108635162377631038e-01,
-0.112798186451992595783767303729332e-01,
 0.112545719258623492974226680994628e-01,
 0.119159701380279374008914257598237e-01,
 0.170577994814939138144794952469791e-02,
 0.407436238333097784066086472169392e-01,
-0.286266912003880714266539233822730e-02,
-0.403307333845691776112241745853833e-01,
 0.566112598876208022041009909685066e-02,
 0.395126613901578221172925164896980e-01,
-0.833166816091168692561713065954977e-02,
-0.383047476227238424724485942486802e-01,
 0.108115461915219496821671764037330e-01,
 0.367298159453912600959748261283402e-01,
-0.130392608801555395483321188671594e-01,
-0.348179800526151291155860862920290e-01,
 0.149546041468859790118911006935516e-01,
 0.326064420136038367859493363608530e-01,
-0.164982685473799180041185157551978e-01,
-0.301393591679382455696581284061277e-01,
 0.176107158657075083854705532794028e-01,
 0.274679288896362833939071500160285e-01,
-0.182296985370870759221991096851020e-01,
-0.246510145486953404173688488465735e-01,
 0.182851126761619438790538856274979e-01,
 0.217570979816121250830048920906013e-01,
-0.176879125656403149478733760248869e-01,
-0.188697715463329988617498976750523e-01,
 0.163035044272996603877668605584134e-01,
 0.161043921923383637609792917076998e-01,
-0.138735805851448950720347628825354e-01,
-0.136714184603129393534812309013542e-01,
 0.967748906729890502843806391548338e-02,
 0.122787252673236121305853964519695e-01,
 0.183419345136688792807167223662376e-02,
 0.351741230071652381588992981172275e-02,
 0.400812713930204612594474667772549e-01,
-0.103905856392011739436792845074433e-01,
-0.379839474211340092053660739807937e-01,
 0.167875445921749833402720243031868e-01,
 0.346134308628843877473194742800388e-01,
-0.224195036067071324724518797596300e-01,
-0.301506233542935582507183730847285e-01,
 0.270391978859568719080467129567875e-01,
 0.248359292203482602725291927370363e-01,
-0.304545580931105791415980243482706e-01,
-0.189573464902247168038383047179948e-01,
 0.325396787523910166352586536865619e-01,
 0.128365072446990995738302030423698e-01,
-0.332426385231341534071480990907834e-01,
-0.681370893402516073164982347577486e-02,
 0.325900068702156763908042042961026e-01,
 0.123334241029693050316774396617164e-02,
-0.306882926161504268631389888312066e-01,
 0.356816474681470792062762533436064e-02,
 0.277233630982778282340946908220334e-01,
-0.726793570761672859638355261267477e-02,
-0.239607311066769076196465208051886e-01,
 0.954586778239526437846922862209839e-02,
 0.197557876781604661488687331074692e-01,
-0.100224876948002965280784407966921e-01,
-0.156126444813654891669176881175109e-01,
 0.794566778575361048125440221853062e-02,
 0.125889826763958953530207669294828e-01,
 0.196674047988324608702192523430573e-02,
-0.403793425058884862044327668790398e-01,
 0.110518161088482433013183429343561e-01,
 0.371487048437245256209783055661845e-01,
-0.211014339858325842856782597262932e-01,
-0.310113471278598725580571212503668e-01,
 0.292532969555376978304659157252188e-01,
 0.225799548497297949739012307350332e-01,
-0.348135883215559440634125198932477e-01,
-0.126894915258297383235347534647969e-01,
 0.373635170180371211703742631289969e-01,
 0.230656551596185000286277314227826e-02,
-0.368029344407506912753556726542503e-01,
 0.757556411083179841658090297732447e-02,
 0.333597317080325772048094367996096e-01,
-0.160450765217260466580160480002207e-01,
-0.275643390906831109627283433268673e-01,
 0.223713259218964251340860185900021e-01,
 0.201927573519276624278619992146697e-01,
-0.260860178871114058887014655968436e-01,
-0.121856967594285858268189686242074e-01,
 0.270384108555683601635910584229854e-01,
 0.455592102922555506948935446283394e-02,
-0.254220619345153449587471129118282e-01,
 0.169671130282124252683641558075159e-02,
 0.217807876522401658815866690803627e-01,
-0.561867844511255712632762560171129e-02,
-0.170361250728282101218499933224254e-01,
 0.608501738916754025995994023449358e-02,
 0.128425337937715372761059756327234e-01,
 0.210326844270611706266077326009228e-02,
-0.764721603386129139540529028697358e-02,
-0.378193603926740287624743985723110e-01,
 0.217490602942993942945407322852831e-01,
 0.294030165306522865618514725413935e-01,
-0.324806157401514170386830694193027e-01,
-0.169291953263212217937342257260302e-01,
 0.382487703730475246630050125207916e-01,
 0.243491551659636380391343642275878e-02,
-0.383155888638707258861723009576438e-01,
 0.117587942219511788621596897647198e-01,
 0.329133192230504152012348292980842e-01,
-0.234588486844816125849111013730142e-01,
-0.231834145999071127885838668713356e-01,
 0.309849485789003442651073481323400e-01,
 0.109515014677747872384178473251402e-01,
-0.334573792869814994080153613036331e-01,
 0.161978948240021182888991717440564e-02,
 0.309362637663043225621313124064905e-01,
-0.124362422283087694601520394820919e-01,
-0.243890828556137144987989963350859e-01,
 0.198622526760637143226306215708421e-01,
 0.154969836246471660356852685631359e-01,
-0.230278945137858242032735173514985e-01,
-0.634613744639988711863982658024369e-02,
 0.220085310288320288046145418675970e-01,
-0.904068458631021434230700746891853e-03,
-0.178912257091894737761170590002289e-01,
 0.412447961558014029376675941952725e-02,
 0.130355562257845791421504596821653e-01,
 0.224361370283306235704493586002508e-02,
 0.395935251329288959132677053565535e-01,
-0.187766247398645594609308208535013e-01,
-0.304953730150236627645368573758051e-01,
 0.330498844220502604385701014026516e-01,
 0.145716657728760124012379442940936e-01,
-0.394817263221402572281103820726922e-01,
 0.423706559655592646211775731444236e-02,
 0.367484864792137506525143537414067e-01,
-0.213654959392655804887704780008218e-01,
-0.258450854569577668911258422996832e-01,
 0.328190141078062561499489354989036e-01,
 0.976640783614883379720853700133220e-02,
-0.361951419072598909676473005102231e-01,
 0.734033371596281601812952746166081e-02,
 0.312546625948844155254105619619042e-01,
-0.213136102548539549505317531690657e-01,
-0.198927877107365923231158216286409e-01,
 0.290897513619783254211958028876587e-01,
 0.552779556124398103727182775483286e-02,
-0.294843759483270943900666258985706e-01,
 0.791492833129683241877165507222201e-02,
 0.234355458425532504528764389727416e-01,
-0.171375817953548773348310567455629e-01,
-0.136596984166519658330773597704501e-01,
 0.204163538600519939920058209596099e-01,
 0.386035821327611491058728636430210e-02,
-0.181461112923282382091974590977180e-01,
 0.209550568250017701734241667351262e-02,
 0.131646532081653825904176317880734e-01,
 0.238760191007854062954994481152960e-02,
 0.116956402619947877128383640963625e-01,
 0.339807711486466195361996207669782e-01,
-0.310706176374904815637115869495452e-01,
-0.159690767606166879459132289126830e-01,
 0.398512642133372285893526058152548e-01,
-0.693089136094877250432325864876507e-02,
-0.352753354772769061812065639366112e-01,
 0.268130726913966961270060135241516e-01,
 0.193249074634121932552269428056166e-01,
-0.370649298228879199958737302752354e-01,
 0.211122808370657918632336531459949e-02,
 0.347103931321348647766593531444418e-01,
-0.214982210114848027371304113466712e-01,
-0.213420327110140792910893548519521e-01,
 0.324568432450130485621485621418424e-01,
 0.232169989810599234144857629224314e-02,
-0.320310668829853545081570273796118e-01,
 0.154016518411605229274915368601639e-01,
 0.215713053329278819673725571677777e-01,
-0.259830379864047388690598983773359e-01,
-0.593415119252560289267032173530871e-02,
 0.268306426290836732781053740908223e-01,
-0.864294212561537459349257259588430e-02,
-0.194022114184446613810718294532800e-01,
 0.171326218000085376904436204730728e-01,
 0.840916122783317440534726342547502e-02,
-0.177891499500955866850359950585532e-01,
 0.314756041528950983812577552302888e-04,
 0.132268896349448717523247621666760e-01,
 0.253504834727847060320858905135518e-02,
-0.383944883219087888654106573909991e-01,
 0.257157168792439629467613764782201e-01,
 0.209944907218349212187937239219146e-01,
-0.395366538257635973505053869946070e-01,
 0.559296455843606294647367646784072e-02,
 0.352906827273265199594423889067927e-01,
-0.289631165010385827989420678257858e-01,
-0.154070153925926276601670776163607e-01,
 0.385365057412183113296417635372559e-01,
-0.104475362829508292432075574099689e-01,
-0.305637179702589919282608509100193e-01,
 0.302269240501411854304657711952512e-01,
 0.965675175714275333380538301309481e-02,
-0.353668112027480396747214057399059e-01,
 0.138213159595761678982863923353876e-01,
 0.247030134339834436266979215158276e-01,
-0.290729619929122864736509291722561e-01,
-0.455703510420709089479551601101284e-02,
 0.301220247398720242190034258955292e-01,
-0.149029771280922965458876578830333e-01,
-0.183547322409568659530700557698271e-01,
 0.250206350274949451058367882526547e-01,
 0.116601631692869870102088571064463e-02,
-0.229106790857110913043966578344134e-01,
 0.124268860658896276307204856524573e-01,
 0.124874624507868274253107424558156e-01,
-0.168295994455721093353934386492929e-01,
-0.203292890691089029243098576433960e-02,
 0.132198243443536524624143192833397e-01,
 0.268575828988752568787350438057933e-02,
-0.156206688161185855192351034050975e-01,
-0.287263068324094014700376192307585e-01,
 0.374861170482453238574635608169049e-01,
-0.973605102384841071609336561499151e-04,
-0.370187563031476084047736146016041e-01,
 0.282532550380245703126630611191674e-01,
 0.149724618945610104131288065971613e-01,
-0.390716380089054483647704766954993e-01,
 0.149186648222917590138548387606344e-01,
 0.268337340225035316808993042142369e-01,
-0.347213363519995612215134529934355e-01,
 0.116416987857350762766089825095469e-03,
 0.334153157545042571516307709513918e-01,
-0.251010131354723763892778342658074e-01,
-0.132619197016132392882572749990652e-01,
 0.337568763556517935441116907632738e-01,
-0.124103581390963826192644886007374e-01,
-0.226581000743083388624241559573929e-01,
 0.282072523101952279052792119705318e-01,
 0.525249866548224778025418674858973e-03,
-0.263568845278080724464860162245341e-01,
 0.183536608416117903976081152579340e-01,
 0.107967111465453602165458742491270e-01,
-0.237781779689056900503514041860635e-01,
 0.668809836522355161512028675061645e-02,
 0.158655007335716668524805891668382e-01,
-0.152975434296439949280563993446265e-01,
-0.406238561830888124857142136643819e-02,
 0.131415383710514780758087997328492e-01,
 0.283952737889158552315768395012427e-02,
 0.367948383723649972853122691581939e-01,
-0.315805414111715901291723820526783e-01,
-0.953489095482092012839527484387331e-02,
 0.394944887026471520441885046213260e-01,
-0.243203663584684533809314770504849e-01,
-0.182186826615877881273347588238701e-01,
 0.394547699537791219462286216070359e-01,
-0.156840838039201194862007384962236e-01,
-0.252786345582433019910389753595216e-01,
 0.367164026274776630801835229407459e-01,
-0.648212533585384574388628709928900e-02,
-0.300908166752384467131150517387714e-01,
 0.315832678889012436889350619280846e-01,
 0.240554467870360204777217846649796e-02,
-0.322350076565984628127611833218961e-01,
 0.245968175893401624105572898137360e-01,
 0.101025866492145310065558413515331e-01,
-0.315262414464916487546670745977255e-01,
 0.164897215679539945446501684504841e-01,
 0.157991204549951802423707480738212e-01,
-0.280118414151321827216375003351436e-01,
 0.812196297810201590150427900121228e-02,
 0.187812485170750558954888089045677e-01,
-0.219018287377302012472771142021510e-01,
 0.392642616433125503421368992284829e-03,
 0.183518727109600890654158301052928e-01,
-0.132430722693250940644251586643516e-01,
-0.602161392661116681513653536318245e-02,
 0.129906589063146765367796603089944e-01,
 0.299614200687547785279380595024215e-02,
 0.193815355684636086242156176086814e-01,
 0.222755323912240456131711852275724e-01,
-0.403981393467472124658282942681909e-01,
 0.161434818088238434115535851013991e-01,
 0.247135866069337911672766759181064e-01,
-0.392579788872424616058879376988110e-01,
 0.126789371046607731302026006646262e-01,
 0.265898760404264290728235716811929e-01,
-0.373766148734152999999400539472595e-01,
 0.911015061377873139355801610334311e-02,
 0.278039280151280057452286393177717e-01,
-0.347795335998274596098775545436235e-01,
 0.556271297541833985028304034110410e-02,
 0.282578936324817905606350104965351e-01,
-0.314955047630447073351596316065214e-01,
 0.216393647546532548466591465518297e-02,
 0.278498322687743060832125979123128e-01,
-0.275456910836583926332412095426387e-01,
-0.959521183815508235995012566571408e-03,
 0.264580024872579962785657945848500e-01,
-0.229183757823195173227964444824890e-01,
-0.368772084458330486981029854271730e-02,
 0.239006461723233860364367541225721e-01,
-0.174956909927344717413764958173769e-01,
-0.593517965285398614878479864174675e-02,
 0.198046793569060895524502430925957e-01,
-0.107347310663084866254897333708101e-01,
-0.787606435382031580789088354242424e-02,
 0.127663787424536659912700316758098e-01,
 0.315537971701268367976390353620741e-02,
-0.348113436420682577892005515662173e-01,
 0.361273534978016334053315284577705e-01,
-0.281251694430248864424611277697291e-02,
-0.329337251129094105613163740466311e-01,
 0.368201099474111512344077224191676e-01,
-0.549791898287935015433874926779401e-02,
-0.305674530624822532817332267189629e-01,
 0.368388028307263344559793512902774e-01,
-0.792825534561214002048493237849879e-02,
-0.277967634035564509030962472056763e-01,
 0.361419870260768787396898004225250e-01,
-0.997291103881884571305080614965284e-02,
-0.247170867373181804663838228665850e-01,
 0.346943098519148072113084236293318e-01,
-0.114941957381252771674252809399809e-01,
-0.214356058096635053371602762168696e-01,
 0.324597102989265879884187047288011e-01,
-0.123368372995226633503033639902502e-01,
-0.180741176209518311791281011787981e-01,
 0.293866749165504793245493833517619e-01,
-0.123015582065609363419615391402550e-01,
-0.147795857570804810625225900811642e-01,
 0.253716485913084096804259128678630e-01,
-0.110669134312675636904740029723913e-01,
-0.117669138418838364091336377014462e-01,
 0.201399143820395727622158109343710e-01,
-0.785728471135526423710919108966584e-02,
-0.959260152915783815339179484636433e-02,
 0.124684710144295469450085621515389e-01,
 0.331700961467775689223660513424813e-02,
-0.229391593057655897299839617956613e-01,
-0.148976464129815033304199166903509e-01,
 0.395364706977594779270734225582721e-01,
-0.295217403706098111098691702610047e-01,
-0.608818219811447764760744448067971e-02,
 0.359348198514679183685883604241452e-01,
-0.340980526633962816761360407541364e-01,
 0.271990436927731020976152936206778e-02,
 0.303315412427186370104185799222607e-01,
-0.363173753242363181951098802672208e-01,
 0.107504759657373995999130142212349e-01,
 0.232906612379729472305802057156177e-01,
-0.360617243459784653274920016236753e-01,
 0.172912698222111238809906537789369e-01,
 0.155365037367877812770119738819216e-01,
-0.334628362579296313037300764431676e-01,
 0.217558304180372429095778722570868e-01,
 0.790119943719467740814975222321225e-02,
-0.289011788521941995728729571931498e-01,
 0.237272284746885325617075786433214e-01,
 0.128073126162584393745291749793639e-02,
-0.229952210202239998570601727680055e-01,
 0.229673725268008785607011439068131e-01,
-0.335775244855519686607396712577765e-02,
-0.166142882237948457854137450089208e-01,
 0.193365866814927014857876246814696e-01,
-0.470887538655514902788722354380084e-02,
-0.111401668329563763544895949030817e-01,
 0.120972990900735424197653311761593e-01,
 0.348079279132278199430674592316729e-02,
 0.324647624986013979359685187150580e-01,
-0.391673317860502889708400514071124e-01,
 0.148946683192803704447701556624136e-01,
 0.209396878259684617265607407447560e-01,
-0.398976397675228611720054866845478e-01,
 0.272035091370281553671636326812385e-01,
 0.667331752040115660744821096402084e-02,
-0.346731907092744334764776314112559e-01,
 0.348717310677191933730918265437481e-01,
-0.775060703309031932758180318543279e-02,
-0.246731614552368513990143605461054e-01,
 0.367978613071371059515718133643675e-01,
-0.197798056377307873238002469254678e-01,
-0.119932515843020528939957495661479e-01,
 0.330618397332273090234892950543793e-01,
-0.274235206834885254297367290482559e-01,
 0.787020719076992934918742940146054e-03,
 0.249161180647183760040416585829147e-01,
-0.296727059399355150007677565265546e-01,
 0.111319408796950722538168949611140e-01,
 0.145534432250136282471498042143583e-01,
-0.267341847475933254099893995789356e-01,
 0.170530747905563753505406118151809e-01,
 0.473992986541922872677554752272539e-02,
-0.200703723247475654449618996243522e-01,
 0.174382559931342327334063287441499e-01,
-0.139767087259958754303602441007598e-02,
-0.124904071980168916206047909693705e-01,
 0.116538215001588799182700337877845e-01,
 0.364648276020541249144365889703015e-02,
 0.262565580609469728156117854489437e-01,
 0.690028669775050046131149159931818e-02,
-0.349830834745875429539329502820317e-01,
 0.380261965530691520116905429818811e-01,
-0.140909457755564380463221972607035e-01,
-0.195020797973109683257128347028674e-01,
 0.387723013943170629522995649774745e-01,
-0.303026232723618279831017731196383e-01,
 0.645397209693542364166830593321006e-03,
 0.287300758324349594504665193224480e-01,
-0.370665489129947629102306353208893e-01,
 0.190910665663321938714852059854905e-01,
 0.116553724394338990046866142962891e-01,
-0.330340716859577539052755239682618e-01,
 0.303594758467264833792053573489049e-01,
-0.657711768997196390723830358635194e-02,
-0.205522433096513474038265578106180e-01,
 0.317675164461563961206886193851423e-01,
-0.201184351407923473728451814902843e-01,
-0.471784746999192566965643635519848e-02,
 0.243140425551435138806069116831667e-01,
-0.252665860915710659638482174144899e-01,
 0.853130411674628175810895771720935e-02,
 0.122878344496322590713265229092422e-01,
-0.218440577310359962018762208058137e-01,
 0.145508678869189499543587133515829e-01,
 0.196187852178765351095632804482946e-02,
-0.136182571564688773472205266518546e-01,
 0.111395918404944199783373466294030e-01,
 0.381382590350720702477605956276897e-02,
-0.297796289581490105883802587071891e-01,
 0.405744122587553203846867136126147e-01,
-0.255838691674544564907790347176089e-01,
-0.549302489108120819654054703717410e-02,
 0.327695275720887297114639061595505e-01,
-0.389812310290043491576576467136305e-01,
 0.204924702359725357194124780406484e-01,
 0.105667235472906646590429123104128e-01,
-0.342969802859803301980048186771078e-01,
 0.358676533912445260938257528465904e-01,
-0.148616409283069472260312271769688e-01,
-0.148097539060817618477473747773541e-01,
 0.341589713306048794942691453169572e-01,
-0.313693744985178493260080424030866e-01,
 0.908171743215992055784653901911412e-02,
 0.178201481844912032114965069058253e-01,
-0.321901498056556971709708866292403e-01,
 0.256590897115708557811047640471971e-01,
-0.356210797781070854066632788781951e-02,
-0.191870623686919199477732581468790e-01,
 0.282057497105417135133629799665824e-01,
-0.188764464670673525528510499456187e-01,
-0.129540138431435305089744896967358e-02,
 0.184101027881945865613373142308432e-01,
-0.217849101230096537214896588015882e-01,
 0.108369891253385348947052274386436e-01,
 0.525304135478051539777942930596240e-02,
-0.145024620761727381346202516997878e-01,
 0.105567536198579040652182941122846e-01,
 0.398256193033654539400399466486087e-02,
-0.292992395674286919409415733184871e-01,
 0.138326355474852059086556830843360e-02,
 0.271642961375605952156860952476707e-01,
-0.402557888615994993746409246084099e-01,
 0.306627119266762671531138122884940e-01,
-0.404167511005599843514223593578669e-02,
-0.244134417386753543893537661413085e-01,
 0.387066462786305626315410446936765e-01,
-0.311078750078353569099230538153872e-01,
 0.637240812827521392830872817335239e-02,
 0.212148499820629295772776400751889e-01,
-0.361455185411343217638442153719947e-01,
 0.304876095336081336161000539405796e-01,
-0.814255614193779015051299474658851e-02,
-0.177523881132478312274600482675100e-01,
 0.325921792347563821024673824959266e-01,
-0.286321213425443082515570572846782e-01,
 0.908160099784043235649021002488526e-02,
 0.142336377995976558014337807325310e-01,
-0.280424211078632274632567006151386e-01,
 0.252874602426529424821161974359582e-01,
-0.880751592967710530134500224904475e-02,
-0.109234180042655231300726762236368e-01,
 0.223952319058302476598201729028541e-01,
-0.198962445716551277854915039363298e-01,
 0.650675473387257188275408689719400e-02,
 0.836092129010646800025953783682212e-02,
-0.151260316338892238116071072170168e-01,
 0.990803006961374031827726494083147e-02,
 0.415242434506989823110695334265794e-02,
 0.267839984522374647212292801876758e-01,
-0.402905126621746195650600207513712e-01,
 0.338829084066355536575303841792149e-01,
-0.108573193076148055506365579838941e-01,
-0.172620206368935157095837231882183e-01,
 0.365388683419986754598302240793122e-01,
-0.375954652531857760447193921124186e-01,
 0.202214728042364482916512879488064e-01,
 0.666678392900122243909301111252984e-02,
-0.296302847925315812693182147066261e-01,
 0.374862767363507463833891788204385e-01,
-0.268151578661712804593292898357500e-01,
 0.345399358079426859067089718746285e-02,
 0.206807163334745191477028146253222e-01,
-0.337216562612685143447943407246716e-01,
 0.297594942560228496791051387891920e-01,
-0.115566273837339680875995444097544e-01,
-0.112012651405911616031433543113763e-01,
 0.270726370285993516472327719832060e-01,
-0.286916265454426122048291886896133e-01,
 0.162622883414916702675139003119412e-01,
 0.297825191769825472821374546619995e-02,
-0.188781637701902260122461052742817e-01,
 0.237791222732455294128631111020019e-01,
-0.163352664004906220947487877168808e-01,
 0.180603143054948465942486259725083e-02,
 0.111765394910361575577199088174791e-01,
-0.154766139016433303407185492518644e-01,
 0.919670897291268536416050590405105e-02,
 0.432314092544826016986308010657870e-02,
 0.320355643953450729158591753235017e-01,
-0.960793596413928010794357756847935e-02,
-0.168108528104736279009642082890073e-01,
 0.358447642398361386601754519341022e-01,
-0.393908182072821135519758289272013e-01,
 0.261078301534973450909490487132125e-01,
-0.192541742915120718589377217616794e-02,
-0.226214141254242156777090362653526e-01,
 0.370277783329830798590387365616923e-01,
-0.353673150733780171689224849444360e-01,
 0.187628178206531342771733576105263e-01,
 0.526560713442514324255740615528815e-02,
-0.262255972714633892017453625414760e-01,
 0.352857259387656184453517094448553e-01,
-0.290521828952156309935338157973659e-01,
 0.108511837299953818679044148921768e-01,
 0.109749484505201926965160913700708e-01,
-0.269117846198981256812582680804872e-01,
 0.304829988593057759393433135128313e-01,
-0.209432312317641958436756028431723e-01,
 0.330900498907738327162974417015547e-02,
 0.141827371942831549388478186374298e-01,
-0.239401917922103888152925085503623e-01,
 0.223995169129748135519447645672860e-01,
-0.114002134857896190032933461700105e-01,
-0.299753304293770503630839191267650e-02,
 0.136007347120247724937397637388610e-01,
-0.155467819521437454770605136460204e-01,
 0.842662261309554190095492188996754e-02,
 0.449443420981182116295391580138765e-02,
-0.235091565135342346158751296088687e-01,
 0.383279301465976128618170634925082e-01,
-0.390179650827339903080613788428183e-01,
 0.254145455467601452465357155999629e-01,
-0.265732108769919041466411838584509e-02,
-0.207713267525569821841765721866356e-01,
 0.362453946343627171835296870894279e-01,
-0.382129686770361928975296422362958e-01,
 0.262179625431462543683589300526887e-01,
-0.497873297866253727304999996111608e-02,
-0.174762521599542704386954594168768e-01,
 0.328776159234420981090276591450192e-01,
-0.358054458025463001170813453957203e-01,
 0.256309805335845338039228561198944e-01,
-0.660108266038355925519209889287782e-02,
-0.139187292297759456003448100160842e-01,
 0.283231766912027810682032104348384e-01,
-0.316366601206746562621967024244050e-01,
 0.232756616683861795441875267432762e-01,
-0.706412169198801333538908812132138e-02,
-0.104433959428513621485088017869003e-01,
 0.226198216227944060470843262941530e-01,
-0.253325229268241004105005532375516e-01,
 0.184154006945785349700724200887185e-01,
-0.550553980568800509461665896580279e-02,
-0.762977848088476371468887770274307e-02,
 0.155477383186156046843114406986564e-01,
-0.153342265888861845850114201688877e-01,
 0.760212298196977164363677855768975e-02,
 0.466602199282518243191038449364688e-02,
-0.344370783962820008677826199621009e-01,
 0.174312265638378933671797677148231e-01,
 0.488965201505843960717132812141631e-02,
-0.255223998378476012058198218179051e-01,
 0.380459108115480584011752128280318e-01,
-0.386502934321452269971842613372822e-01,
 0.273159281005318442109106032226031e-01,
-0.777140168534310178864719895333953e-02,
-0.137430689206337178438392570386221e-01,
 0.304945219331778202156303789210048e-01,
-0.373984472550657858058620511875960e-01,
 0.325919244623757878106332839525753e-01,
-0.179429931670914136453746547431692e-01,
-0.164610226252620412678710158488449e-02,
 0.198899005631940148188713749653866e-01,
-0.311677873980189125599557565492414e-01,
 0.322946615663833202457998097487077e-01,
-0.234459929251566966074666062606651e-01,
 0.796012480216307542001291769549106e-02,
 0.888291248000197711345466441523052e-02,
-0.216713774368037117299911944297840e-01,
 0.266422407301936719162654072969781e-01,
-0.228403667563972597846201770776597e-01,
 0.122890033874392562173719671835105e-01,
 0.852799863759667358324275703055929e-03,
-0.118257416294613459964996194903280e-01,
 0.169482924298038678853014899469568e-01,
-0.148418506432496890318449916344280e-01,
 0.672805242865195368444458788141136e-02,
 0.483761782901740481689432956463013e-02,
 0.199892935157060857336820682262967e-01,
-0.347688124425104588025163406808177e-01,
 0.405106586597710483334279501554534e-01,
-0.357785571603895495920645321344411e-01,
 0.218947796221588976068170611426490e-01,
-0.256852026213606314782540454060566e-02,
-0.171095818968888358415220155595934e-01,
 0.320311657565023957655961296640909e-01,
-0.384217413555781550877611579660313e-01,
 0.348166518140289102364979460582911e-01,
-0.224038041156649434270172754953633e-01,
 0.465065364938927869666555948401552e-02,
 0.136714826060517896685794902120640e-01,
-0.277905421524671695285529288781328e-01,
 0.342044936041547890830610917834944e-01,
-0.315754555665444907181790083353975e-01,
 0.210127112066807123887704379003083e-01,
-0.568280724885064540240549968596993e-02,
-0.101283910550797260978025306912574e-01,
 0.222281317232309118905467704901201e-01,
-0.276602726918589733100486127634444e-01,
 0.254636867104548616312150776746366e-01,
-0.168447102753657825356233415636358e-01,
 0.473241351683213759188363777032253e-02,
 0.713905539950354303931076876495947e-02,
-0.153448993885838759387599950721809e-01,
 0.177521952382422192190373032452693e-01,
-0.140777622182075697736504931396655e-01,
 0.580970996833381492609794870505847e-02,
 0.500893154343572654921151684275864e-02,
 0.364788112662947135441463464653566e-01,
-0.245274375953343519457409051101327e-01,
 0.748650540857379316805202555449189e-02,
 0.109922762560113547414365628832048e-01,
-0.269742915614819734641848690511714e-01,
 0.370982547547796093036658819895024e-01,
-0.393000765975245712424268405228959e-01,
 0.332452543883666260306841568909351e-01,
-0.203768295775842134803284119542991e-01,
 0.357253094821607034105324433011387e-02,
 0.135079516030146996368718375319370e-01,
-0.272362745265790247398394056112363e-01,
 0.348059899536529497998731563720495e-01,
-0.348246515997039403956310789680170e-01,
 0.275790241581255326758728420203341e-01,
-0.149206301434501708072412472063898e-01,
-0.194508611690057954379650787040274e-03,
 0.144003798040674878254486191984057e-01,
-0.246870505077317796759403512610869e-01,
 0.290624228368962155317550029804825e-01,
-0.269611274072891056725146946395613e-01,
 0.193130694934640879722669081265357e-01,
-0.826445924219632882969396687981491e-02,
-0.337504805106053420968364976552981e-02,
 0.128228638212351920608667242598503e-01,
-0.179850614785711974225916827763285e-01,
 0.179301777625686597389973292791102e-01,
-0.130551662577960930517338877579227e-01,
 0.485281350730962229576454700620847e-02,
 0.517966974868875282522009021607678e-02,
-0.162611489277503367508045290874401e-01,
 0.297617246853599187875047618673331e-01,
-0.382225359023147681959043126276228e-01,
 0.402413989342208950782152641796437e-01,
-0.355327640590285810633103280985260e-01,
 0.249692879581690395478550468858047e-01,
-0.104190189791957031467311408871531e-01,
-0.559140158992167015309809016217257e-02,
 0.203260511465714309335970239690891e-01,
-0.313203100664140749077678516715684e-01,
 0.368065527061420298417568725014305e-01,
-0.360095122891439365146887770181923e-01,
 0.292602245928963305609273118075118e-01,
-0.179108619975484059867642466327209e-01,
 0.406907176323333901482469355300999e-02,
 0.979703748074046886988567961384057e-02,
-0.213092916557976106057993103358476e-01,
 0.286022471115141093387486615157948e-01,
-0.306417377238850919213980325907714e-01,
 0.273828968600958165019654904703681e-01,
-0.197418960500963211399540514380535e-01,
 0.939056479359283115457049693371776e-02,
 0.158412914068595099077284336071615e-02,
-0.110891117243800042831107586161884e-01,
 0.174240882237451105478145356198465e-01,
-0.195941026899109000145305248088390e-01,
 0.174750401006920394516359057671806e-01,
-0.117921558434140534042687800111712e-01,
 0.386345827558616999525243272826977e-02,
 0.534953636763417343873087319457184e-02,
-0.381395383022155891891785700348592e-01,
 0.306012189636305425923085357748736e-01,
-0.191627327143517279097484706486510e-01,
 0.534891875449112427149889031658822e-02,
 0.900824271331215559073415452022945e-02,
-0.220206472806851836806372412466516e-01,
 0.320011789308691184218217601125932e-01,
-0.376910002735308837825689195903805e-01,
 0.384254883846373883390716495006659e-01,
-0.342161286329255288723637018672924e-01,
 0.257377030249174197208513080180905e-01,
-0.142235825844719680396609373608594e-01,
 0.128492183511971047909833106152103e-02,
 0.113197993268368557177269301093442e-01,
-0.219316485590957844610450257737787e-01,
 0.292193059635023212542165788965304e-01,
-0.323561771823967009513309647445778e-01,
 0.311220798420142302491295783450807e-01,
-0.259161530603729928932158011560862e-01,
 0.176805924014926175406258090212894e-01,
-0.774771002771857942198424814797179e-02,
-0.236620246253545217371246273993618e-02,
 0.111892447003506267352430019831474e-01,
-0.175105951067675608984462359728245e-01,
 0.205535093025051798354986144237396e-01,
-0.200788468349343953123153296991147e-01,
 0.164020018248884761972197840142355e-01,
-0.103114066219814916549248523742224e-01,
 0.284807179108767900686897263601864e-02,
 0.551823316094749950873959260823948e-02,
 0.123636288416724661756500261940118e-01,
-0.235154548435169357699046605106074e-01,
 0.323678576898110825106502093822347e-01,
-0.380684668374238184356752808257746e-01,
 0.400864069506888330702337377139246e-01,
-0.382646798364649979560423094642000e-01,
 0.328332735181218733183342209905670e-01,
-0.243817956280236902487820174694707e-01,
 0.137947539545751000008475856042740e-01,
-0.215658429122976634982371392404574e-02,
-0.936327432198016355242358096858892e-02,
 0.196328783050880417059232013825342e-01,
-0.276747380424578359711242758798906e-01,
 0.327648050848631029088638192780352e-01,
-0.345030797843876750771290880797742e-01,
 0.328485695642214787372068186368962e-01,
-0.281152372485910613939629293045772e-01,
 0.209298310745263822226112764090783e-01,
-0.121566193422513120010214678704438e-01,
 0.279761408411352717841533886332175e-02,
 0.612052518864422436705029919944097e-02,
-0.136603421710117363933119458332460e-01,
 0.190756179088981809779023984732249e-01,
-0.218903520898725828047043108236602e-01,
 0.219459063124212884544480143300817e-01,
-0.194105771479334846847101902461491e-01,
 0.147482495258736584707790060266124e-01,
-0.863977971680618097639741857568160e-02,
 0.181336570958946834830298778111646e-02,
 0.568546025879183478642203646931589e-02,
 0.394020027523057710387990225937107e-01,
-0.353998460608603568730144526933756e-01,
 0.290497597106127182052678342476575e-01,
-0.208066603735752973865685081150769e-01,
 0.112587514858005240650190625394231e-01,
-0.108337647471969036230715002393717e-02,
-0.900366315183382178201421353987281e-02,
 0.183014283535426046756925812834955e-01,
-0.261757103668767252007175774167820e-01,
 0.321054774686250775717561223667235e-01,
-0.357203634481504520178075594470037e-01,
 0.368263655966259256168570111488435e-01,
-0.354178436885370940570113694315579e-01,
 0.316749813006701617378399920061282e-01,
-0.259470031257450355764325593868090e-01,
 0.187225481516759342390285476707590e-01,
-0.105895923255236665350976793080019e-01,
 0.218811820682271122871637469059346e-02,
 0.584071914857302650020706327827154e-02,
-0.129049233571563206910088096241670e-01,
 0.185075331659036899301028731776918e-01,
-0.222844513974941473075568557341626e-01,
 0.240312588028040032747724168019047e-01,
-0.237168625542358296707576434343570e-01,
 0.214827009588133080902225584330897e-01,
-0.176268417942465011345769068358640e-01,
 0.125716936405940128129819853285453e-01,
-0.680784032056058601568964625991914e-02,
 0.766284941809904441339830730368842e-03,
 0.585091669579423334871367287837479e-02,
-0.833740079762628448830485261564873e-02,
 0.162903155778121242467016989726689e-01,
-0.234935038384438959626670957142691e-01,
 0.296192191900551098001621818578454e-01,
-0.343935162985670713747074229926567e-01,
 0.376097730583615017926909367674689e-01,
-0.391387306035149912607531256224177e-01,
 0.389345359342385469535696111852903e-01,
-0.370364809819474007978148779760354e-01,
 0.335663568800272320371018573670732e-01,
-0.287215712350415313478648898785260e-01,
 0.227643972797943389152111670087435e-01,
-0.160079253315228446587552675441691e-01,
 0.879945840488479136123055956135924e-02,
-0.150222616246177295210081270519708e-02,
-0.552362227944982630473988885493756e-02,
 0.119397502852458013648946721270680e-01,
-0.174471102536836886778577410421889e-01,
 0.218012519370382790810166386762513e-01,
-0.248246636805646421902030493437091e-01,
 0.264155009064506210229942952921197e-01,
-0.265522366861106228907387048284114e-01,
 0.252939581959577545038493091716886e-01,
-0.227761949454058836473364212312588e-01,
 0.192022169988559327990338129249806e-01,
-0.148294371403038047266227451251600e-01,
 0.994897552224329993572586629389647e-02,
-0.484930088374232620050148885146783e-02,
-0.286045556673530319119906687141575e-03,
 0.601430094852167689896272779853208e-02,
-0.402530965346248094527465930147089e-01,
 0.387237233148324857508544470471983e-01,
-0.362254832400066969272825258007689e-01,
 0.328327683816119301588953245275685e-01,
-0.286464208568490022714315922809576e-01,
 0.237905524735587922707456007412631e-01,
-0.184086317786704175541730900984397e-01,
 0.126589627885932364617916994686997e-01,
-0.670969896232670194385479823170385e-02,
 0.733550679618184339734867511356535e-03,
 0.509764586155640238945731089651117e-02,
-0.106183261182633723157105218239730e-01,
 0.156743900308498727582402884472111e-01,
-0.201280258277770417830855108153079e-01,
 0.238620122791072648127787150425662e-01,
-0.267833635170365941314248381960785e-01,
 0.288262013717037147181514607274432e-01,
-0.299537643497914383096768317660637e-01,
 0.301594887826398575476336032769046e-01,
-0.294671246728988784476088594743436e-01,
 0.279298737804185631143210511800433e-01,
-0.256285556638283146048619148810786e-01,
 0.226688081580268832668495973416921e-01,
-0.191772856198456836932839622978603e-01,
 0.152966559883370384297876627552748e-01,
-0.111786730799597930361890692744374e-01,
 0.697279317292560611746607664144622e-02,
-0.280039935662566252716021123889531e-02,
-0.133637589604973775719853764781493e-02,
 0.617531147463907358993109654504754e-02,
 0.422447015790373469394364256399171e-02,
-0.838730449401501113704451790483131e-02,
 0.124278782720614924947034459145306e-01,
-0.162875726074166916605355060200291e-01,
 0.199107368632458348614803647771763e-01,
-0.232456031592861632822581234346514e-01,
 0.262451382646635105138565590934292e-01,
-0.288678191773867614623359016763953e-01,
 0.310783199494265261906319080864471e-01,
-0.328480987758236706929150425897853e-01,
 0.341558760027994887423506777100691e-01,
-0.349879954919249002616911246615590e-01,
 0.353386636671073447070546928449182e-01,
-0.352100625211134379593030336692388e-01,
 0.346123348058939228627767611343393e-01,
-0.335634414862131555706838133823983e-01,
 0.320888931575464951483115317693427e-01,
-0.302213582731666175029770573941088e-01,
 0.280001512368389661609662661916191e-01,
-0.254706017870407263595036578425487e-01,
 0.226833016922772822734196345996928e-01,
-0.196932112262840772832932848777229e-01,
 0.165585756590962464689125170187509e-01,
-0.133395236609240851384789222680081e-01,
 0.100960167934820647472820673313287e-01,
-0.688424108977020306479022318978070e-02,
 0.374863914741964743229198370631214e-02,
-0.699224286525270752731714799156688e-03,
-0.237738781928810925935489360237052e-02,
 0.633364725292288574206279332325179e-02,
 0.406839975044063440730737759429396e-01,
-0.404346766898834064849070980663311e-01,
 0.400209033192759670108816556182737e-01,
-0.394453093402995114688760617752644e-01,
 0.387115594768850532482416551779005e-01,
-0.378243313703738924044914488434037e-01,
 0.367892902478037713785744289780251e-01,
-0.356130582588718210633807977807797e-01,
 0.343031786425194217050321362799094e-01,
-0.328680748930073678414673512303582e-01,
 0.313170050880139203392208022531232e-01,
-0.296600115082967170533043003158143e-01,
 0.279078656043129250067144921825718e-01,
-0.260720082237745624266907652805545e-01,
 0.241644847604328324398691359129219e-01,
-0.221978744390237007631017067898116e-01,
 0.201852121703088341233624900841906e-01,
-0.181399000245721456659827507519127e-01,
 0.160756028618547496479236681714037e-01,
-0.140061179771852374339463839281012e-01,
 0.119451995690221108405651749792254e-01,
-0.990630053562040260937489052676918e-02,
 0.790215499977373584223072362183098e-02,
-0.594403559118947362744394447989726e-02,
 0.404029729997158729920487546016536e-02,
-0.219320414267862324584439294930700e-02,
 0.391065922004316040753357769329897e-03,
 0.141500031239303537992334913456074e-02,
-0.340175226747328156548532228607137e-02,
 0.648900832329699140908819604998360e-02
};
static const Standard_Real WeightsDB0_C0[] = {
 0.196145539320418982378623767812232e+00,
-0.169867019890482336776547667013587e+00,
 0.165384249698148984804912491794491e+00,
-0.163786296767558830870228753559914e+00,
 0.163031864858123160298579144326440e+00,
-0.162615435404437847268534987968649e+00,
 0.162361149970676795324024547133861e+00,
 0.119264701183779742796565160580433e+00,
-0.103286260999913269621915684555973e+00,
 0.100560549014228893657200237455637e+00,
-0.995889267207376630735056423034406e-01,
 0.991302005291857407417496791580609e-01,
-0.988769939840357573868783936211464e-01,
 0.987223777925181021498878650735335e-01,
-0.986210096809798828238672592063959e-01,
 0.985509414592172439260270812023700e-01,
-0.985004827280106125031227948842295e-01,
 0.984629372786847141669912658075800e-01,
-0.984342434306971100465301010686332e-01,
 0.494590812249492355151730238917771e-01,
-0.428328207886440100878458766925076e-01,
 0.417024678077729538765554496848855e-01,
-0.412995359640943827311568958400966e-01,
 0.411093021753640774277599822865956e-01,
-0.410042974006154780734510430140784e-01,
 0.409401780534904625983891145952170e-01,
-0.408981406894386893290772054937402e-01,
 0.408690833922078349933086400454585e-01,
-0.408481581522962283806894191098372e-01,
 0.408325880514247613722410917171081e-01,
-0.408206887103440471337895957247083e-01,
 0.408113899360576261689389320292473e-01,
-0.408039851659819723052653707370523e-01,
 0.407979925993599490362337718002734e-01,
-0.407930745121141429486660245124536e-01,
 0.407889884626711180243306613067289e-01,
-0.407855567504293143347286709938492e-01,
 0.407826467181934084763070102110228e-01,
-0.407801577100850556882604831928076e-01,
 0.407780122328924577862699038113311e-01,
-0.407761498405171223292233497301172e-01,
 0.407745228230181798134653447042318e-01,
-0.407730931162268422685514299174680e-01,
 0.407718300522938905180191474005966e-01,
-0.407707086994133502417602765058155e-01,
 0.407697086207059105840935623547798e-01,
-0.407688129355221559430302020463500e-01,
 0.407680076017751906152705824117712e-01,
-0.407672808617546723713899270255496e-01
};

// Coeficients de Jqcobi pour C1
static const Standard_Real WeightsDB_C1[] = {
 0.375693680937234041301644955593695e+00,
 0.182311890642854011583827835693142e+00,
 0.329219793988290852585859638846444e-01,
 0.680427331044466112674073984687531e-03,
 0.228565980318601683216333773333760e+00,
 0.317768498495851679611240750742674e+00,
 0.869878955761303448776395954570032e-01,
 0.216710739358986149713114465288040e-02,
-0.190783511698612271708815993321826e+00,
 0.299558538417145479812089898115759e+00,
 0.158762985244277593894523233318834e+00,
 0.501604558488795490295188646528907e-02,
-0.292858449528229292815105537317795e+00,
 0.938046379840627714370094667647698e-01,
 0.228378333812737869327264732903885e+00,
 0.973901953763600400356509664169095e-02,
 0.313444611609253142362757588963795e+00,
 0.197019940509845506614200321565504e+00,
 0.704474046872225736126113051696204e-01,
 0.104998249400853916315119147780958e-01,
 0.196196563554990035651698679147217e-03,
 0.154766512769294772540925018463729e+00,
 0.283198414600823729248877707542925e+00,
 0.158742421030158523565298005866873e+00,
 0.301249491127276930246475562840087e-01,
 0.633731093556109200807908673149971e-03,
-0.191097315611694223376872960385529e+00,
 0.169349551412467101976500579609415e+00,
 0.231591814720961358627361087973151e+00,
 0.612178385778512962431795315996164e-01,
 0.149216844811322343058078578141929e-02,
-0.209853610497642111249125817934968e+00,
-0.790392077886960182737963483969267e-01,
 0.238174406037591470969537308994975e+00,
 0.101345603227390744115371931795450e+00,
 0.295648896506319677663295659746717e-02,
 0.109185130902615756679582867610723e+00,
-0.239527646627568714075450921905079e+00,
 0.153382102767155808027375868917374e+00,
 0.144024906492031210742801264825147e+00,
 0.522172089553301898820557978980880e-02,
 0.239195487158580434966668172900973e+00,
-0.154968284362832261518166295790944e+00,
 0.194986647219853405326644713558033e-02,
 0.179717987908391773686067819306206e+00,
 0.847703252468553644524863711901897e-02,
 0.202653817058362402811966677979757e+00,
 0.147323536675769539120334093642517e+00,
 0.837828299044191257469790382630664e-01,
 0.349636676936853522887635951622353e-01,
 0.935560200250190846130107782588481e-02,
 0.115261397167404178528500113938514e-02,
 0.194383580796015245107284500692237e-04,
 0.135227917129543535931812047361352e+00,
 0.192589006951972108011541046413927e+00,
 0.158659583720837089039510395745876e+00,
 0.840044704326470868318208722560868e-01,
 0.263190203386965180895701792131754e-01,
 0.358299754482622267388978059153047e-02,
 0.636956210458480957525758907072846e-04,
-0.906344609835518727035858822959385e-01,
 0.842012949073787453688434613630945e-01,
 0.174685661923598208678472136444954e+00,
 0.134532722108614928037547583934758e+00,
 0.521504063586271670385937244740565e-01,
 0.805051545060561000042592977965876e-02,
 0.152601998169129251763837656431184e-03,
-0.167261529340972356377314809229184e+00,
-0.944053307664384667096502610155292e-01,
 0.982197927446023331774739594949028e-01,
 0.160538996372137766116982269891460e+00,
 0.836011482960002923177317896714413e-01,
 0.150848825105584006877258546448465e-01,
 0.308595086414065960149443878132227e-03,
 0.837335484075594559222623143434566e-02,
-0.165602464946353070433998065080418e+00,
-0.363730353494469210626537367237810e-01,
 0.140491271208987654387073455759615e+00,
 0.113994097609584897178535407620977e+00,
 0.249546901586345668982267425694398e-01,
 0.558042278185011328988176828293577e-03,
 0.165522889925639798891584711501895e+00,
-0.541994361301617404550947342416129e-01,
-0.141289082513007801857417524154344e+00,
 0.716073493677941540320470125914859e-01,
 0.134685263534618057941895664553450e+00,
 0.375496557547029773489703248618437e-01,
 0.930579472964015816141984271228227e-03,
 0.643939578851586159960514948041337e-01,
 0.115349163710053333540883641755982e+00,
-0.140259201911847700745218654702647e+00,
-0.243012793615878462392623890901351e-01,
 0.137531170038091194069649337695826e+00,
 0.523061738537549682344718398898396e-01,
 0.145820428236958138659527449173356e-02,
-0.135101558634509290248641022447504e+00,
 0.150848412725408329488091164844185e+00,
-0.327209554393540009708290508982467e-01,
-0.108224606307324613059888902125747e+00,
 0.117655171780351702231463003961060e+00,
 0.681952973696873348807394705341513e-01,
 0.217417811970250910271889360813750e-02,
-0.121245749119107443218983010535725e+00,
 0.120286321800250111803437168896546e-01,
 0.990081035373314248309435931578428e-01,
-0.142151900826873550463518807849075e+00,
 0.756052871900688536737872866845162e-01,
 0.837824580107415270351043821227978e-01,
 0.311177636662318188234666204273624e-02,
 0.826492492773788584241987387653795e-01,
-0.139533703789991475231216001533987e+00,
 0.151165315321377157841582430696999e+00,
-0.109044245529994234618420541728010e+00,
 0.181004010231966049640241766925624e-01,
 0.973577387857051725881773478948132e-01,
 0.430292808045555926257668367420314e-02,
 0.155075608993489281262109506440894e+00,
-0.126650301515361512058081023398554e+00,
 0.817036522021589866885958494189955e-01,
-0.236008537335409762639084234077464e-01,
-0.430532161932425850571306425902685e-01,
 0.107124756894381228543862943351220e+00,
 0.577679013172621311048410001838526e-02,
 0.167465158656542995065379389214204e+00,
 0.148746322297449425576468624738889e+00,
 0.116670620232278307010412953362970e+00,
 0.797792590619282915161661357102545e-01,
 0.464838874609574251788319199857504e-01,
 0.221882523544627736582311661494119e-01,
 0.808720005775368665825997856607112e-02,
 0.195812233998606140901321601241170e-02,
 0.225491011563304401158935013021125e-03,
 0.366483703933378281051040317914262e-05,
 0.425042912431745459966119350522345e-01,
 0.112374901435840658858448143223419e+00,
 0.144606569335110674815982074467766e+00,
 0.135174319732151956051917609096736e+00,
 0.980601501261043157169459817166840e-01,
 0.549226454610371965676727054692180e-01,
 0.225069701191045008840107235643852e-01,
 0.592437613173335233625026198005208e-02,
 0.720924797390047007309635829305354e-03,
 0.120713682604950774111967710140258e-04,
-0.126317160542840916410290962041166e+00,
-0.514769587797854189559811417153026e-01,
 0.504382602741275437759983616194441e-01,
 0.120332351122709636858455972429551e+00,
 0.129301715839288266741850709880033e+00,
 0.917178012767220327832662918354427e-01,
 0.439800283431167366187553539384432e-01,
 0.128724511259645760727821157200392e-01,
 0.167646715529347792434466807601318e-02,
 0.291017331028214915676548355719131e-04,
-0.621384683086135822846574062866199e-01,
-0.130662617492660528178908983919968e+00,
-0.856409899121446019172405525877712e-01,
 0.265486566434969151691643600052806e-01,
 0.110775399059473444330050415904316e+00,
 0.116467508980755789763560586038081e+00,
 0.692485994139016540633640814910621e-01,
 0.231590719777415474108054217929205e-01,
 0.327305062931303305802268670542551e-02,
 0.592822323392552013298334071901288e-04,
 0.108810660435376588444703375192700e+00,
-0.197913088168583332029001979082605e-01,
-0.121591231906885393517147825624634e+00,
-0.828355093806104285450774622732412e-01,
 0.397993681190170431065140039032758e-01,
 0.113383925729079755950043376492934e+00,
 0.922307489523328979288600417630453e-01,
 0.364888287070544219203742379133360e-01,
 0.568262627319634660308423326548644e-02,
 0.108106318064181674060876513348613e-03,
 0.786595342068137831852794093023748e-01,
 0.116321189429878675146793259252490e+00,
-0.184645092915459462420551513964686e-01,
-0.120010767567274714613774972430232e+00,
-0.507061596993424362412452376420520e-01,
 0.759956392031757847616150382401127e-01,
 0.105547360655798043978725060823084e+00,
 0.518028438274918047495052776018316e-01,
 0.904565191685180578660848284640843e-02,
 0.181997228662744467103352526709437e-03,
-0.932640671353313028823903506991128e-01,
 0.770972045589246980593439516948187e-01,
 0.103839964407723896767186506001192e+00,
-0.526334020612053533903480811946207e-01,
-0.109202792774968808937900334560391e+00,
 0.127593523304555896318261668989156e-01,
 0.102853090900896130752166802825349e+00,
 0.673179509732289499006034775998576e-01,
 0.134484040663952009275738232719623e-01,
 0.288233475519046207537098644682839e-03,
-0.927151125754473697243036584486839e-01,
-0.768042575179510606069374735272860e-01,
 0.101399423215273496156028115026566e+00,
 0.604308912193615898804138550028141e-01,
-0.990734979671318387024163302762633e-01,
-0.543621409853370736921925681178987e-01,
 0.812378090465621634113866660410870e-01,
 0.807309030858780504949183609337257e-01,
 0.189027534509814500476010835931116e-01,
 0.434843553484580734741425429512838e-03,
 0.771266017297659681921676979875440e-01,
-0.113268471752086584658457579618303e+00,
-0.223012572953185894625721574289640e-01,
 0.117445790015447634635882195379490e+00,
-0.256456818076785846104623880158341e-01,
-0.986008329844466200756072942431854e-01,
 0.428400011350409478933186887216282e-01,
 0.895656540018645353069955621961829e-01,
 0.253306734628466525521857593882446e-01,
 0.630472716996765062908776080824804e-03,
 0.104278597516680327512329180362939e+00,
 0.219208007778244470143865743271050e-01,
-0.117992800734294181990666405644289e+00,
 0.661359756285131934371189153124737e-01,
 0.639205288440816619288158355083349e-01,
-0.100694381036780039673727777047012e+00,
-0.500190837127507697499249235258370e-02,
 0.916095757278766163693495754537233e-01,
 0.325553976630115176641786460402348e-01,
 0.884224566269060043020961245361208e-03,
-0.599410396867838535166773296344160e-01,
 0.122887042718137075592059186764408e+00,
-0.698220401141775795793911126085236e-01,
-0.461530477576621081505456998483875e-01,
 0.110262191545275317528757505576381e+00,
-0.588325387255718491215710616184940e-01,
-0.512929900202011589349581276838606e-01,
 0.853613369275086413430240834687567e-01,
 0.403006373929688454062419155505464e-01,
 0.120548048363204207982050284157695e-02,
-0.113208423729739708703376605954967e+00,
 0.362568956828308253135087935022623e-01,
 0.632158361850100386500430058575626e-01,
-0.114666443994919872728737060469937e+00,
 0.818917628074227116885011950270662e-01,
 0.906470520476312597080434409524408e-02,
-0.842923276162898454693284379818030e-01,
 0.704039222521450424727125496709937e-01,
 0.481986296630957306812265932936069e-01,
 0.160370031100396062872813283126343e-02,
 0.417827392854718551919598498601472e-01,
-0.105278620265725987226013782272249e+00,
 0.118279303672908296559145449597600e+00,
-0.749980993878789614283097171825845e-01,
-0.222297803578532211324081257647866e-02,
 0.725331400547902144066971294148768e-01,
-0.949699054182073424409572000473071e-01,
 0.476234278983816736276060972905065e-01,
 0.558070543450227682936814989029804e-01,
 0.208820799468034277463206284258474e-02,
 0.119363124565646030518384065857660e+00,
-0.854477717752669533091160980078112e-01,
 0.279376317044816246637297299561451e-01,
 0.354313073563288900578880919078319e-01,
-0.844946814049501758172106855395020e-01,
 0.102316004036849358606668175065795e+00,
-0.799368057914942921053660732176096e-01,
 0.192173037810479714579775234457234e-01,
 0.626340951626056977787214339057219e-01,
 0.266796621832107622487940847524676e-02,
-0.229228779174693897894176241032881e-01,
 0.650413507308958970753136073471689e-01,
-0.965040084654537143867147119410731e-01,
 0.111880740961270893376073640971948e+00,
-0.107984194674853897584042927999399e+00,
 0.842715753369736079191419993641037e-01,
-0.428648173839091142208296123457931e-01,
-0.115289538053618971006864778659814e-01,
 0.681701827244506979573572324668397e-01,
 0.335134428626385406832887101781878e-02,
-0.122638941194742732887787904679594e+00,
 0.115524383669636367224385340565102e+00,
-0.101620959449945970294558973285773e+00,
 0.815537851186005945066955002221144e-01,
-0.561940869417981836150953436678175e-01,
 0.265796182953479482581167406044889e-01,
 0.616709095161629420627109741808396e-02,
-0.406760940499877160338460908222283e-01,
 0.719243109920934645595756308191413e-01,
 0.414588369875150285761259756587057e-02,
 0.131536218746332125109383787025210e+00,
 0.117215955520406193475381339320717e+00,
 0.963365752475641833643905944686949e-01,
 0.725383060214041813333560679937884e-01,
 0.495112080994251117952196517153609e-01,
 0.301361117501716438858306568943608e-01,
 0.159458359473095489032171958085323e-01,
 0.703803348897565608683132437123937e-02,
 0.241159479275077151145128356619723e-02,
 0.557500856670109056895909993880449e-03,
 0.622041730347788941461452002544282e-04,
 0.993552047294696336797690128027088e-06,
 0.536004942237756840510408876809576e-01,
 0.948060174490946555827326235236401e-01,
 0.115398984620853995700246383538992e+00,
 0.113796105850074019341487604592044e+00,
 0.948580876469156317790214570757711e-01,
 0.673230766155747309392101024678219e-01,
 0.401544547745741544162900585647833e-01,
 0.194546481843763298214772984407045e-01,
 0.715846378735573695057476696108753e-02,
 0.174357993731375130572773545218368e-02,
 0.201493484937926332632788596275370e-03,
 0.328059850258384660676315341043126e-05,
-0.884383132994414565043050088967871e-01,
-0.326807093135464412488466389982601e-01,
 0.337782440172134185049362220217214e-01,
 0.854453435717644323159636930175437e-01,
 0.106604466262596031039653661292689e+00,
 0.969578517385936531431881255127126e-01,
 0.686664366465526831255408449072434e-01,
 0.376820459730875817131388418481885e-01,
 0.151870765908193429873572102423110e-01,
 0.394690481564271644695625159270139e-02,
 0.476059485726417652458093464987468e-03,
 0.793214888743845452764823568320750e-05,
-0.751413395719994761447098522269182e-01,
-0.105560634748785871532868910635055e+00,
-0.752522174603102810474531650166129e-01,
-0.520556921167041043331109799242200e-02,
 0.634613883015194330127348087560446e-01,
 0.975508514081986705895761642080532e-01,
 0.902304764323874665160056474194226e-01,
 0.586571844716807812289679586769246e-01,
 0.265333427946539161664421954344231e-01,
 0.746218522480627992109657134612895e-02,
 0.947053774271952621809411761159156e-03,
 0.162139280802680401028357614069413e-04,
 0.625759102830764598264744085834730e-01,
-0.283470140838837486188116960025347e-01,
-0.946722720312487048234910601620849e-01,
-0.866924594601241842061286106804265e-01,
-0.165843457035409888914190619646060e-01,
 0.595139434597034454623704278054000e-01,
 0.927959932671320907510940101463357e-01,
 0.769506586468841986725638987746870e-01,
 0.403344015729107160062379661428798e-01,
 0.124763170309041546667513676388145e-01,
 0.168052354592649288011513992641662e-02,
 0.296841397879006052140655400996596e-04,
 0.898118986371907659521517223069920e-01,
 0.866831934215240173291077114608565e-01,
-0.344186471180009121268578250228198e-02,
-0.863745447540335558318232046053710e-01,
-0.827327395488593201376469529137595e-01,
-0.498647076335407397287322627755056e-02,
 0.697927285776955727801621253621813e-01,
 0.862354939623976583578590444653826e-01,
 0.548091937823204876266576103926601e-01,
 0.190088605081150079620639492628746e-01,
 0.274281768249708227265142090944797e-02,
 0.501958588997197449374810736784369e-04,
-0.371303937172651189190070342954684e-01,
 0.737863907716680548727313143818329e-01,
 0.898510699903561538912041896658191e-01,
-0.428371497215554559745890352635181e-02,
-0.879450693719318904254312080948089e-01,
-0.655064862572795497772151104397327e-01,
 0.247647842749805265724081006199875e-01,
 0.814080552909861587787979583801982e-01,
 0.674756200596271747615898299716144e-01,
 0.268683531462800521736114158180568e-01,
 0.419529834591813645422349741986091e-02,
 0.798913168834190949362316220889261e-04,
-0.981668711591463613484549852941729e-01,
-0.467105788519798896600584488580798e-01,
 0.729882648638723066708615927611424e-01,
 0.806540618988614581342520076157996e-01,
-0.275434979910603210254645601517140e-01,
-0.897261139908112693102165177444120e-01,
-0.283541878095155262890117072580457e-01,
 0.606568139659195781357950385385132e-01,
 0.755855773932036620069622579851458e-01,
 0.356337260117071054776389275062865e-01,
 0.608877390470030315892209895198408e-02,
 0.121189547198522686087769267537299e-03,
 0.111291525831924340345359140439905e-01,
-0.970599011136577111752871168949241e-01,
-0.329196016412885593844955170387416e-01,
 0.850904421807466680458943712545468e-01,
 0.531856376760507776488464151255014e-01,
-0.633595433813059362462614801122074e-01,
-0.701013571894503634873887091806588e-01,
 0.266996444701976761346138675195339e-01,
 0.766992860134594640704929688712438e-01,
 0.446664398646431390141924302890121e-01,
 0.845802723604274359687654543157514e-02,
 0.176767823566460170956076622342112e-03,
 0.100156243315052203039966722379458e+00,
-0.342573993600459381012417475540470e-02,
-0.973052234182707603238219581370502e-01,
 0.460889950892733398899700484767758e-02,
 0.918278188843319322895287373338800e-01,
-0.720018758787808522701277317076709e-03,
-0.836958496448011724818198425349676e-01,
-0.133715431715937108647850192653819e-01,
 0.692779343382196842651990146794309e-01,
 0.531549475875059406685051893639672e-01,
 0.113168109498867518351645497186191e-01,
 0.249537225249912973949726284604577e-03,
 0.146145275005597229650148614255168e-01,
 0.946356710564497774288956247192901e-01,
-0.406101709580813753278512338205922e-01,
-0.799459131568413252788147621654989e-01,
 0.578231921452561533440255437488063e-01,
 0.619029564424312157677155006254268e-01,
-0.629285439635922054941675898288036e-01,
-0.497556066426348486964583986951879e-01,
 0.531574213867605582058352597820169e-01,
 0.601887254433853350414675516382563e-01,
 0.146536648973447127121435390032741e-01,
 0.342612679523562825800467622193556e-03,
-0.958715118249212715338328279224531e-01,
 0.512711592968705385145059379044327e-01,
 0.663407552216231370517156835931651e-01,
-0.830102833187968669538490780870121e-01,
-0.220377110539306335782753785045449e-01,
 0.871925647944030160407075774700272e-01,
-0.158660075528559323575464542144522e-01,
-0.727084543147702846314670903352965e-01,
 0.297809225131685991298208481270867e-01,
 0.648548995194834112115657728308272e-01,
 0.184288761671737980093564687266716e-01,
 0.459277872159447817104785572094137e-03,
-0.388674106243817782020120444584169e-01,
-0.683922196413653915633261422794728e-01,
 0.898942643059433750048118285452557e-01,
-0.148067961403695536452388732257277e-02,
-0.838437912023346203224183145595566e-01,
 0.596307192234237496163705544926228e-01,
 0.377722793629383655448743388054818e-01,
-0.755803210123501675937503591453745e-01,
 0.211243930646702740475845144902098e-02,
 0.663469695027959958004430581633966e-01,
 0.225728480350962093601400882631360e-01,
 0.602945464002011148689466672961788e-03,
 0.856914957407171530273139482180333e-01,
-0.853858971495793046325540259713880e-01,
 0.688120124979135604282668107649132e-03,
 0.812601647228504003448543216869962e-01,
-0.776664268591911186389061491010188e-01,
-0.425219155271127188701284452030353e-02,
 0.747961043289873657633427340002289e-01,
-0.571295909379516278038435729106675e-01,
-0.257810911536169865454036365481335e-01,
 0.640727805654983637148300821485093e-01,
 0.269860742187535853085824496436130e-01,
 0.777113099897396035085080987418111e-03,
 0.603353599837515295394077835473446e-01,
 0.254828188284753441827818267151488e-01,
-0.891056229891708532848214415770707e-01,
 0.802896305297211622763044855769398e-01,
-0.841212143861256050003415043304167e-02,
-0.653185278345995707123687531656242e-01,
 0.787920457153103108961678366426950e-01,
-0.222872157851925822900119252006539e-01,
-0.494188263400619430941609897167183e-01,
 0.577480654416122025325476309655115e-01,
 0.315408316197631519405850168483138e-01,
 0.985315742745166029334657254160893e-03,
-0.703068427000117650005608493599000e-01,
 0.978722268136426697395947642359340e-01,
-0.665040937562251328388748191857858e-01,
-0.337908106357359057888220066259180e-02,
 0.675254472335684822546102563531116e-01,
-0.857377577924803576698933428079823e-01,
 0.477470511139596701957879615171302e-01,
 0.189915998756735557925415843635162e-01,
-0.647417973857026371250098669806900e-01,
 0.474627431329027153933567441012459e-01,
 0.360846126321789532506108981769773e-01,
 0.123107490866862891433567446423635e-02,
-0.778286434509243798765919927666637e-01,
 0.232784459791921331619935535365529e-01,
 0.398937047921756827432871651472552e-01,
-0.833729520264690708297883687914716e-01,
 0.879911631863595381921519974668003e-01,
-0.526714414502487621808050394822015e-01,
-0.464041052995922977443450694275581e-02,
 0.545372548678663006625112738704213e-01,
-0.689303435179935288343345154227116e-01,
 0.337096826383252002307437224112299e-01,
 0.404452217651747223205225482675588e-01,
 0.151784541812710386648823213884645e-02,
 0.506971686430384050665788745610035e-01,
-0.861239007518699541996492909409813e-01,
 0.957236929563768384648061100369022e-01,
-0.769467585352662849781395319634370e-01,
 0.361280061545838147010201111574909e-01,
 0.133164370776745857845611246908655e-01,
-0.548321537266254862026190675135597e-01,
 0.736210095113786917378495060479375e-01,
-0.610310093491232021698612933781137e-01,
 0.173695769734568396870840111033995e-01,
 0.444373657924477105841558656194951e-01,
 0.184896031135915904807866518551446e-02,
 0.903664465740661830807881880866411e-01,
-0.659467091293585217775321206046234e-01,
 0.304712125351783461456687523136516e-01,
 0.922918550637689632515530148111466e-02,
-0.454104362682569475569400400284825e-01,
 0.708232710554243693174805377946545e-01,
-0.800203322341774940791824834782198e-01,
 0.703180006997793730042513889761540e-01,
-0.422504772288921217963597696597842e-01,
-0.349501347940005512141623288926296e-03,
 0.478704769903675245126432857132085e-01,
 0.222757460416993697366589071375396e-02,
-0.280807306695098316860530062437413e-01,
 0.533463723374740501412413396179255e-01,
-0.732408572370306643880187939750929e-01,
 0.857006739270110970265348152365720e-01,
-0.893395079534328490368167361299487e-01,
 0.835644688961656148190380595335925e-01,
-0.686097786707760477648984298250328e-01,
 0.454819394805333105884270955620383e-01,
-0.158360572102035577835575114785258e-01,
-0.180139393594055171237699305076880e-01,
 0.505574301489103875481653912263011e-01,
 0.265660858121812858026044189796418e-02,
-0.972500405808939677304463491130482e-01,
 0.922464039660579541725994322494083e-01,
-0.840770579660640116946995948737456e-01,
 0.729878517689414954547233323994958e-01,
-0.593040199655620644211435945595936e-01,
 0.434098179593638765133809610453622e-01,
-0.257199212633296261561625365582169e-01,
 0.664185639646439604362638901829660e-02,
 0.134554864920217714912318344658310e-01,
-0.340987470944664120153787180656717e-01,
 0.523237503646065817565479205345828e-01,
 0.313869133819756852987138441628551e-02,
 0.113487111353742808596547953459773e+00,
 0.107599577543480264103828584919107e+00,
 0.966135011752302666299349563562728e-01,
 0.819563011484596813313222906996670e-01,
 0.654267980641692740882098946029255e-01,
 0.488715496130918306089675116691867e-01,
 0.338754650787996221114540039147136e-01,
 0.215315436702494217031897630096752e-01,
 0.123331394049849656435960695920869e-01,
 0.620099210868670151322906495958715e-02,
 0.262440382239518850358748281430691e-02,
 0.869706920533690839694489470632887e-03,
 0.196048721319260812883406284546113e-03,
 0.214995492260393592039688927077246e-04,
 0.340135592588411083388510973240353e-06,
 0.193737012975015536752157101013607e-01,
 0.549111600564180555347701750677420e-01,
 0.815934969214182997618431700849261e-01,
 0.958715989362653642244094372998492e-01,
 0.970046026241295111399027006399930e-01,
 0.869806531367244628207851683117382e-01,
 0.697174863246694067607248198993787e-01,
 0.498349354814146989660838945766144e-01,
 0.314054720408969478056658713023785e-01,
 0.170611515575841864233484654257965e-01,
 0.768195056431925508281146783014141e-02,
 0.267161619466068885913671808046746e-02,
 0.624225464315909747955906652667698e-03,
 0.701413781566160288903832720807133e-04,
 0.112459767120239775796317901319190e-05,
-0.888297726732991686165380786714005e-01,
-0.641568936621981376437337591644003e-01,
-0.223364251706781881527236569811766e-01,
 0.243425871477680303059308976334233e-01,
 0.632052179708330774737801125610802e-01,
 0.854074952917922973034907769264270e-01,
 0.883678139127624677269725724060201e-01,
 0.756335118544812364189474089599788e-01,
 0.545320522197554810019671590678835e-01,
 0.328459203084817126942518028169680e-01,
 0.160129369492758564687693912017774e-01,
 0.591537425878240732980988317430354e-02,
 0.144435777273495391187085323923840e-02,
 0.167157818808660815673920621151388e-03,
 0.272354839806986227974078678767454e-05,
-0.287269217227507472058711777425349e-01,
-0.739162597529890887562939451684090e-01,
-0.880018691732819572623109335762136e-01,
-0.662852350158669541003716277407031e-01,
-0.195023153425179062163822487015658e-01,
 0.323372841951207656909720463833819e-01,
 0.699156816027511838231748227421380e-01,
 0.829985668250445194164609727888912e-01,
 0.732260728071407474760831709718966e-01,
 0.507256323497402360856950219714827e-01,
 0.273702916530977615476555887555603e-01,
 0.108895141043414779893713981815003e-01,
 0.280319236230546665992463329120845e-02,
 0.335936473703109725350109949393410e-03,
 0.557764235214836588239679381761668e-05,
 0.808182247378915706644677106448447e-01,
 0.346174559358321850775987157568365e-01,
-0.304702282580798356194179796920497e-01,
-0.769672653053147177860653916905616e-01,
-0.800241384751972988780491209317990e-01,
-0.409847563111897425286354214140144e-01,
 0.162080825093828229277817362562757e-01,
 0.617864557255290130011935284436654e-01,
 0.778777496870018377380342320719223e-01,
 0.658464529512817785427028371324460e-01,
 0.404936002854521755863841328886136e-01,
 0.176379600157165715845999513365389e-01,
 0.483323292100425851190026415402137e-02,
 0.603154521171099758612397614916217e-03,
 0.102334892853617814070666663103549e-04,
 0.370563953350413378904514461672667e-01,
 0.833622219930078669993334910535301e-01,
 0.678154170951376479241595815239554e-01,
 0.359310938404781087113049072891675e-02,
-0.608837319192817466272649398704784e-01,
-0.803023031477381723386765285499644e-01,
-0.451991125945552782749929691565253e-01,
 0.158447114261278377705711462839553e-01,
 0.624678917374130013440570157759288e-01,
 0.727070506991550376212696056489636e-01,
 0.531951971194127520570703933197073e-01,
 0.258846362837514009473401054737114e-01,
 0.763228721845130796365920591396208e-02,
 0.997677529046579555182312365749584e-03,
 0.173469611965891040715041416278770e-04,
-0.748583641563947536824892523010763e-01,
-0.588955920647808631759259452153027e-02,
 0.674259171127905291808073161069180e-01,
 0.780123381720394156917752777107208e-01,
 0.189207291436230947658647498857298e-01,
-0.538466913301269070821043123639100e-01,
-0.769740451958791628053181533199030e-01,
-0.363094505398062053875907504679881e-01,
 0.283890486721541033040701769818879e-01,
 0.670765309577069082677173778770971e-01,
 0.627304701818664466342128776739458e-01,
 0.350063886212140237075972984681605e-01,
 0.112437657724476744537318913808369e-01,
 0.154917636287111715981656753492093e-02,
 0.276841736098491451005898367893289e-04,
-0.447305751354458260988109985905310e-01,
-0.839790557464148264010624633951814e-01,
-0.299123799906292947564142813901064e-01,
 0.554778665846580789441226596732636e-01,
 0.780555266374245675557086046737253e-01,
 0.170503973399888086139139387907572e-01,
-0.579635301469020331915038041230481e-01,
-0.699376988436042001129606718628960e-01,
-0.147254223302536507734812884846005e-01,
 0.477940929796409594206847208689806e-01,
 0.663928094087410710109862583778174e-01,
 0.440667607538648028107260968007404e-01,
 0.156402999213038238608783224774653e-01,
 0.228655026995904179263862724449602e-02,
 0.421206205982577714869422063261455e-04,
 0.690961039555453827510720500705629e-01,
-0.215674467320391355891167248873802e-01,
-0.827747183271135346235340558326918e-01,
-0.356202343858954938976692914844896e-01,
 0.552582299481680382827864764199489e-01,
 0.726044275489634003100968355627077e-01,
-0.166494516841062512983436098272397e-03,
-0.675619451536068465241003721302347e-01,
-0.520168872244079021205701529142939e-01,
 0.177479785506674254006597217234471e-01,
 0.622012588800617598986210649405566e-01,
 0.519120025364999759035131960325629e-01,
 0.207128056762201723117832687769204e-01,
 0.323622988890905974399895671380549e-02,
 0.616385773008855018017235543752104e-04,
 0.517985173919390454373349456745253e-01,
 0.762535154166498740608521499821422e-01,
-0.146281920092751553686912352540540e-01,
-0.813674895691619463758003706970673e-01,
-0.254684671390052500673623414285120e-01,
 0.649379927188304638350889548942526e-01,
 0.572253285134651639904815019806236e-01,
-0.297220648323786670980263888924772e-01,
-0.692922883577483324117337872368843e-01,
-0.164396086543324335967096490384566e-01,
 0.495096374199105617523297612894724e-01,
 0.573195685896248718679267207066850e-01,
 0.262666564476956688795696085377229e-01,
 0.442043740864757369500611137129349e-02,
 0.873228382865932602795506760683043e-04,
-0.630499981552888091764315621741992e-01,
 0.458873082525849654000617967301125e-01,
 0.744244042923424721163737344509064e-01,
-0.244858666087769895824266377516067e-01,
-0.786159115207607833742025000808536e-01,
 0.585390987886728950023446271779210e-03,
 0.742269154022039985580800349538332e-01,
 0.238273962481815619535825621327274e-01,
-0.593081124651338919595137538378436e-01,
-0.460670594035150726875303916640148e-01,
 0.293693584488044241833286556385647e-01,
 0.591793581392264809058610249902449e-01,
 0.320260101431987066346663322624139e-01,
 0.585548414754293522203606966757747e-02,
 0.120354854628645502851051218186549e-03,
-0.582392789647537717613047651799155e-01,
-0.611828898655375596317603328967842e-01,
 0.538509127792336418323485033312454e-01,
 0.630004482495702829410996508072064e-01,
-0.475623445662581986412088447498677e-01,
-0.639229697151118435408097760654177e-01,
 0.386224670281070124277237959458077e-01,
 0.640419133697910308103525895567820e-01,
-0.255356331545670962833233590949078e-01,
-0.629113120772877967083445029746625e-01,
 0.452582518226708540405952337767610e-02,
 0.566806897971063557649820456786755e-01,
 0.376465978338919874082198386045172e-01,
 0.755018630418886598298827647792162e-02,
 0.162005336276638523506590717235899e-03,
 0.565750306768662873192320127770792e-01,
-0.651155593840196091365880120289894e-01,
-0.457763621160135262338149011657687e-01,
 0.702509608575433198300109424653217e-01,
 0.343622027465615039918479479941481e-01,
-0.714032946923164805131211880312793e-01,
-0.244099116122734208886207611422628e-01,
 0.685503410203223543639746261824489e-01,
 0.185615365032285100395843322009585e-01,
-0.618905381215475782195395900171094e-01,
-0.209895432671958704570888802096182e-01,
 0.494748220235241875609052038339322e-01,
 0.427364830174712943813771798102582e-01,
 0.950447709829247752920667057998296e-02,
 0.213625393214088077834992580752480e-03,
 0.640117902639816104459785064734852e-01,
 0.403461525178758668055912394539712e-01,
-0.776258576866539167460740916625239e-01,
-0.118003779247068036925140274455086e-01,
 0.789809021281388969535111438632796e-01,
-0.151284509577173032885325212329119e-01,
-0.696340328875656423399276890912612e-01,
 0.345938608541019353738486434200499e-01,
 0.547533198412308746295980500882976e-01,
-0.429283512643001248525767499728972e-01,
-0.426117718721382124605722067868341e-01,
 0.377844397804444762904355733582844e-01,
 0.468835128396842514649152771411940e-01,
 0.117082879090305421242126756883295e-01,
 0.276636297150646941295190114873272e-03,
-0.496434289251135080988338324034403e-01,
 0.776430590030843425195256755059372e-01,
 0.510327253717986232649187137236723e-02,
-0.785671792366954920176673806414028e-01,
 0.381416868181602478586657948884035e-01,
 0.545351110387576419288395730257359e-01,
-0.642673791750080180286552436043783e-01,
-0.188357659678543338708703348226120e-01,
 0.676956931415552748940787352039994e-01,
-0.113237092615636707777855561448571e-01,
-0.561896776828361064048666605291420e-01,
 0.224379017576441121760129606483612e-01,
 0.496874773429602921954086309903548e-01,
 0.141407624482016671096824462883270e-01,
 0.352517954334625504497317134430102e-03,
-0.690704125173897510761028513761220e-01,
-0.158075856735187872251393074883220e-01,
 0.800807160088266006857933289419644e-01,
-0.449034269774370185953179593892964e-01,
-0.439036402250376094478931440522986e-01,
 0.749397437458990219914293990068557e-01,
-0.121073144013527881181685873640508e-01,
-0.613859756997708629345417536188965e-01,
 0.516864550095199685487524408708854e-01,
 0.236046349638412043049372396067427e-01,
-0.589197813670204960467933374891595e-01,
 0.481638367985505012063841588608931e-02,
 0.507944364790588489937256835074927e-01,
 0.167698567298900527346810686626022e-01,
 0.442796189046490410659931963305309e-03,
 0.422785286665164361524894693033475e-01,
-0.824341123455734512200755687340343e-01,
 0.365190348870256096136321959669564e-01,
 0.460744322272526676956856963989919e-01,
-0.781067502393458038392951081779336e-01,
 0.276477303071163053389668200653823e-01,
 0.487938750072976331502926199054548e-01,
-0.686218881976427039394033306854457e-01,
 0.134332419295546201459546039111339e-01,
 0.512568506985419873753890688168327e-01,
-0.500469755570719661949736867015251e-01,
-0.132851013035485823057618568774323e-01,
 0.499303224779231884427536570653747e-01,
 0.195523639840991949681027323052459e-01,
 0.549028946157382247647263975723922e-03,
 0.733712421246565100910755974166257e-01,
-0.100565268238010002794452652108849e-01,
-0.609887133482890898325984204284948e-01,
 0.779161011204157584388825225343001e-01,
-0.272947739699055297747664914175123e-01,
-0.445794899584908547424310396162103e-01,
 0.737518923398961530833904418191607e-01,
-0.362649559981378137357883891519546e-01,
-0.305819157606982813223781732145051e-01,
 0.630435649762908016398524149044650e-01,
-0.311532493223204933471167036380960e-01,
-0.298683926915874976036070743421192e-01,
 0.469308159318700595849788511480831e-01,
 0.224343881725493786837765865170292e-01,
 0.672791529595875726405254937321693e-03,
-0.345299151219136480524122860837798e-01,
 0.791522342689194811078369624601367e-01,
-0.680373098184961016661225920350776e-01,
 0.988122327516499094987053428637342e-02,
 0.531678136539943844978418187813811e-01,
-0.762455866294880758511435020321659e-01,
 0.443436768782490882933262043993379e-01,
 0.170494597161495735926524272122060e-01,
-0.611550377279799091072978250486319e-01,
 0.551704215286682480353212458544244e-01,
-0.594215181275250495414321125961633e-02,
-0.429882393080439780535868649427854e-01,
 0.417646460920224293988472401696971e-01,
 0.253522729430792447889107890850194e-01,
 0.815661001495613454889418777926892e-03,
-0.768751848998154996355946532602617e-01,
 0.347715452620612008000324840259755e-01,
 0.257240559994903679376388653283924e-01,
-0.707282585343997908199483183294770e-01,
 0.755155826882447785154799397174324e-01,
-0.385613332151485072578647465835940e-01,
-0.177752594895007648423155131344328e-01,
 0.603716079783112244154144813503051e-01,
-0.647993573790352677805115410541404e-01,
 0.299760301661861488153546680005367e-01,
 0.204603213809911211182349193289934e-01,
-0.510188790032976183138911914929401e-01,
 0.345478755017790617596004269497009e-01,
 0.282339753064277218308910641655876e-01,
 0.979199874062245742378940390677689e-03,
 0.264623945493607159302129356115227e-01,
-0.682032091119498759125801678943990e-01,
 0.812357486467080835328687867064078e-01,
-0.604579926368263432726417133163612e-01,
 0.153575795471401735776573517372410e-01,
 0.341863813758436492291577932347997e-01,
-0.666563084985803005831647863023782e-01,
 0.684092784184467998419108009510454e-01,
-0.398139802399738436830458621516522e-01,
-0.467270145367410202458802861509474e-02,
 0.425540086964070722494185129569398e-01,
-0.528927004439419716630367756238396e-01,
 0.255473698048721755419707310341649e-01,
 0.310008556745623915216298406061326e-01,
 0.116493923268982493053951340025171e-02,
 0.795496735694727892749510195749532e-01,
-0.559917764168012559639322569074562e-01,
 0.162070700339849994676743265046661e-01,
 0.274547809705979196832508136453940e-01,
-0.615252986637335893049844393288496e-01,
 0.756807654390474075438066717281761e-01,
-0.660311608787516394033269520250865e-01,
 0.364005258896972815837790433025779e-01,
 0.280594197872160702283682702948462e-02,
-0.377952588147909473693107256515372e-01,
 0.556402738493134849169636125830118e-01,
-0.482746175186239472891362799932719e-01,
 0.151724781810358468692811966810542e-01,
 0.335698388165186884514699040365578e-01,
 0.137436143448232778027304003721483e-02,
-0.181503351729809064850289530443638e-01,
 0.507014616152258121894611661054181e-01,
-0.728048447058076131273476708400332e-01,
 0.799956577185390641913761279486043e-01,
-0.710028590339547494878243748044641e-01,
 0.480346249601828717955068456967898e-01,
-0.163288019079206592210904482569537e-01,
-0.169357503813412268053816074787518e-01,
 0.441349665956343722401289076619489e-01,
-0.587829583642019307530674005569378e-01,
 0.568642166653172692167000607092183e-01,
-0.376434486685022953274189456428036e-01,
 0.395489398173095092363664956009591e-02,
 0.358558844100553448556240441362309e-01,
 0.160888253101849602336252432965845e-02,
-0.813697191936378556534103827988926e-01,
 0.717175010967743085190276998156116e-01,
-0.536779088742878442781084962515817e-01,
 0.296185602769725652254876654051115e-01,
-0.270668722526496480644584232767950e-02,
-0.234958105971544270228160380761831e-01,
 0.454864365460033346649192140415645e-01,
-0.602658677775798719307068410458260e-01,
 0.657125936605597641672331673825384e-01,
-0.608374639299113509414340549086981e-01,
 0.458827171390935893594749934605677e-01,
-0.222639078231516973984651859770461e-01,
-0.748234775455448618659132370254423e-02,
 0.377746918067797878851716998485791e-01,
 0.186983456787419450373891058742114e-02,
 0.967432887941389698338084775420915e-02,
-0.283667196024138097675097796775875e-01,
 0.451328393087956628082652604367248e-01,
-0.588273646047215114434368156877206e-01,
 0.685032407743837870977041632660017e-01,
-0.734715350761782024465261021426615e-01,
 0.733431162937549607991088163360220e-01,
-0.680486032185757202029267483360682e-01,
 0.578339170189213035963624106651610e-01,
-0.432296539680722139994121352678567e-01,
 0.249945917238737854350367299462063e-01,
-0.404810106647822710793175804556281e-02,
-0.184648315365820244243557114911591e-01,
 0.392455519410615856688833363580600e-01,
 0.215844791603452149680007326511682e-02,
 0.823185840491160814049475888140336e-01,
-0.804801995951506908748131692838152e-01,
 0.768439716347322133046352512951329e-01,
-0.714896091098126096996302050364511e-01,
 0.645331934185501535522116112601783e-01,
-0.561228371953243671646897562867477e-01,
 0.464325446577145431460556829958495e-01,
-0.356537853499827349084790642260906e-01,
 0.239838903800103977806383263414039e-01,
-0.116098651056774830718110050505665e-01,
-0.131323311570993969781474493205643e-02,
 0.146785035944994786636674455587902e-01,
-0.283129501946390253967752857938833e-01,
 0.401942504794450592523437508848553e-01,
 0.247583379184767280276963989830982e-02,
 0.857163351362678430908642915515351e-01,
 0.831699200035424667765392406481476e-01,
 0.782730515981067287777534996728598e-01,
 0.713961652848636590788534494972413e-01,
 0.630439877183472193630870937250688e-01,
 0.538018559866481003966493000832291e-01,
 0.442754038613378228124709691383754e-01,
 0.350311910372504653388423193670518e-01,
 0.265455102590340488512634077524727e-01,
 0.191672765304906835322601465956366e-01,
 0.130987860395280370431618059870812e-01,
 0.839554568433536449547929683636662e-02,
 0.498369769803054238109959109216747e-02,
 0.269118691764549208891639536861547e-02,
 0.128708100288031306441712602611248e-02,
 0.522597993796138706636085540668320e-03,
 0.167528952468358429591903470105887e-03,
 0.368253437831009972518842427902688e-04,
 0.396906801664707898943219519931995e-05,
 0.621935885719526055903654418625431e-07,
 0.110225687781203722029725653665160e-01,
 0.320210268879500637864938367383023e-01,
 0.500247435073828547686081679473413e-01,
 0.634969067219872820845084060531317e-01,
 0.715086568034778154659743517715548e-01,
 0.738349968059966233093006019117301e-01,
 0.709372187810955358892069448021402e-01,
 0.638400119068548172617939708623938e-01,
 0.539301616831826224178702016911602e-01,
 0.427167329592465332256923324456136e-01,
 0.315974386327562415163103841322742e-01,
 0.216718235331356159413932822040642e-01,
 0.136300611916507262413838055664715e-01,
 0.772925771505943179873632372420847e-02,
 0.385084759844310540792648902109767e-02,
 0.161680849148961172279466129377576e-02,
 0.532247970634215611834106566292101e-03,
 0.119358472809724828859617338993283e-03,
 0.130418304252591543679311298582329e-04,
 0.205909285110612231961476260234221e-06,
-0.679639490050926951614157373588570e-01,
-0.571143163425363700985738262305220e-01,
-0.373298329521983109118635214093154e-01,
-0.120325525460863927728049788058010e-01,
 0.145651588362363336503397208216039e-01,
 0.383163870438317307577575820223518e-01,
 0.559350356374773819999119524962538e-01,
 0.655536799377112825061484980820802e-01,
 0.669325589746162637762627689043911e-01,
 0.612993121086873748674207272079945e-01,
 0.508904824207209111880257284555367e-01,
 0.383335916849147098578111916969005e-01,
 0.260358979594428166407416727479422e-01,
 0.157276317479502380506129149068754e-01,
 0.825120443616709140614087717408444e-02,
 0.361146262848523297912814250112983e-02,
 0.122824451080464308314365664359790e-02,
 0.282211177150897914265405040434262e-03,
 0.313498109888755062037837967136245e-04,
 0.499478426741661492465884664812434e-06,
-0.164261466617535496816454389429465e-01,
-0.452267921848486401481145539201483e-01,
-0.629631269374517859077108792115739e-01,
-0.655677717816425078810745033183738e-01,
-0.528992634045572339925004265962863e-01,
-0.285825613369381535291713127050782e-01,
 0.119561107983304945874889500722659e-02,
 0.295222893888915291753286577779676e-01,
 0.506374416590764827254296385229039e-01,
 0.612949923215293509571690768337373e-01,
 0.612499597512803534827655296544487e-01,
 0.528237254672621210888960943887681e-01,
 0.397984790949838163066280223016106e-01,
 0.260805104352044468722820500982432e-01,
 0.145931130408747024993943635450741e-01,
 0.671930779594852301480262289358975e-02,
 0.237618386686411655896359879993824e-02,
 0.561908724100434146053505199487711e-03,
 0.636441340443172169850060381108699e-04,
 0.102483324707248393643595416216175e-05,
 0.629738725049632717392645177308581e-01,
 0.420535401746654327724201789999214e-01,
 0.743044655622362679465779492636281e-02,
-0.291158510678759498626961490916109e-01,
-0.555085771662760487475005959849298e-01,
-0.635902807046147198726055157762475e-01,
-0.517050451444182834325945293433200e-01,
-0.247676779869434272251913624210346e-01,
 0.802945857742866485804271726157604e-02,
 0.368101205159265577036200322290538e-01,
 0.544254057638787874778549716570073e-01,
 0.584137856991671612702742161243406e-01,
 0.509558494083281005499361080199914e-01,
 0.371425136848962281213967465736992e-01,
 0.225189143832103747783654721594817e-01,
 0.110223915367658968836057176416154e-01,
 0.408175819508635525530744158150603e-02,
 0.998098192595171128861276042516731e-03,
 0.115606939237483781592207443845580e-03,
 0.188436752239638790341346333122935e-05,
 0.213294631673610410418269513978559e-01,
 0.546234974212019762254447964843975e-01,
 0.640867676729253317601328252650869e-01,
 0.460098026982872774979075616336530e-01,
 0.884385346760618068757424914733009e-02,
-0.310111522847855151636744376542402e-01,
-0.568355131485474658404949168395035e-01,
-0.588894931869870261382470352178653e-01,
-0.380099909951884820994371028405739e-01,
-0.414336031372156520386785542342403e-02,
 0.290029936234996179240026246459487e-01,
 0.502582024245618578715359385310819e-01,
 0.551761739127888362762822723864703e-01,
 0.464752195362520060313994780141449e-01,
 0.311703710188954303878000317711269e-01,
 0.164214184367507961393599406884077e-01,
 0.641791586149679488665594016069897e-02,
 0.163089087267335079998186848343925e-02,
 0.193764816739549059944705802061099e-03,
 0.320201598206232976637427531831964e-05,
-0.597666806052004365595513006190669e-01,
-0.272957147413711643645567847790619e-01,
 0.196501263748513295148358304652124e-01,
 0.553555844558370345813497304917414e-01,
 0.608621562376944312866853551900280e-01,
 0.342055375127708811336050380113187e-01,
-0.928703425678478945864585337727356e-02,
-0.463071088585603084017244489514850e-01,
-0.585948281438623169404552540372678e-01,
-0.420569067592890171931361415152188e-01,
-0.723710988694921117830325322662221e-02,
 0.281411630344686722152620168195153e-01,
 0.493435131579910475584700007008011e-01,
 0.513994262140125970898052353435369e-01,
 0.392668340887212810175943627447668e-01,
 0.226085375382751923535651862006409e-01,
 0.940818005381301025068732820719701e-02,
 0.249778303239438257933195214558878e-02,
 0.305356290892344751835352837711823e-03,
 0.512400193308679894470783053760274e-05,
-0.259600325438039886335913641334110e-01,
-0.605499873558121470550079513454993e-01,
-0.549455480226126130082065327350692e-01,
-0.134412698421890125511312681399066e-01,
 0.359390308191485083047465748796294e-01,
 0.608735362338092821915085841165586e-01,
 0.463087808407746527984084063126085e-01,
 0.338039783518134379048038245343173e-02,
-0.395757958001760281681863155201030e-01,
-0.565344335043500109595039039798856e-01,
-0.398307185220743919643562026376770e-01,
-0.248281520228227334473359904900422e-02,
 0.329707674765314619774949086450005e-01,
 0.497274184355669271209684212886233e-01,
 0.452986770976564736328159875301380e-01,
 0.290719570529734976967595481469764e-01,
 0.130133637994195544760066463042203e-01,
 0.363039258031905463285001345624999e-02,
 0.458161914855760295839170378080934e-03,
 0.781934040283747851449032625110301e-05,
 0.569288120192092539632625700351064e-01,
 0.120763700792332915837028766411767e-01,
-0.418592537888676420919264607303565e-01,
-0.623422874722736613556454548271900e-01,
-0.340943287851959412540128900902881e-01,
 0.195835312322265932968112802742741e-01,
 0.565916627792500907158415912546703e-01,
 0.496979856616817653869456196752478e-01,
 0.652305811817737230932434160126016e-02,
-0.389550681015940658936551192950145e-01,
-0.542486546109773800019541661045149e-01,
-0.319050849218756679376390538797711e-01,
 0.886273866787806726085930545642365e-02,
 0.404753017302391820125605020543051e-01,
 0.478061574178774409734165741863729e-01,
 0.351354554874462836513783582259276e-01,
 0.171235466574016946248227379077868e-01,
 0.505122488069114958822846049723847e-02,
 0.660302056320993233326643981125472e-03,
 0.114801155833047707115435837406689e-04,
 0.303627936946478848082030305562337e-01,
 0.629500567495531921306074389614938e-01,
 0.375091264460648635894332302260599e-01,
-0.217927784221917663834040352605343e-01,
-0.601068955916771854342305956936186e-01,
-0.433059254198014949540329860280778e-01,
 0.115290374418012536405929954575009e-01,
 0.540070302315695221213725928759880e-01,
 0.476126372622042505194767998037887e-01,
 0.104523937825945155397104602800158e-02,
-0.434016864808811216632463465621886e-01,
-0.496969489872923555351919176513785e-01,
-0.173237517399773768707575588604547e-01,
 0.243393891968783107612672484085846e-01,
 0.456911022565159232055064640500036e-01,
 0.400303087804609998732133926578497e-01,
 0.215567015266671854241643936571916e-01,
 0.677068072338897157812715625270814e-02,
 0.920007640702559854146137761023270e-03,
 0.163215414003728317635314713860999e-04,
-0.540735793049808911800562871969598e-01,
 0.324945967446733980184368094207998e-02,
 0.566402242603482930091042484937961e-01,
 0.497161813605374590822101355693156e-01,
-0.901853351638405234174302898371006e-02,
-0.568191914972189106441246942659898e-01,
-0.445782222642120095711768205355418e-01,
 0.125434288184123739584490542355557e-01,
 0.543518330304624679556555016934857e-01,
 0.401463002056267995711040881740761e-01,
-0.119702868795001179798583335587196e-01,
-0.489913565528032009513115845918175e-01,
-0.385949979971609348026938064093269e-01,
 0.376843721540804962902623561090401e-02,
 0.384963882212026579292671997898845e-01,
 0.429917409209736949667003032794765e-01,
 0.260647437680285492390418579331216e-01,
 0.878451182377904680587020034492802e-02,
 0.124536966472530159697284708445527e-02,
 0.225818114134565724790651988181156e-04,
-0.345410806594941373055429288393916e-01,
-0.618153437162484806800833160801706e-01,
-0.146627279863925285944560594101743e-01,
 0.493201927565523377600402432210818e-01,
 0.533736516587238436944877259094357e-01,
-0.569724671012658113567710866690374e-02,
-0.561271751860680302852005003686844e-01,
-0.394103503890647136236377221659610e-01,
 0.217041302175764249946134999933552e-01,
 0.549097637736476093406166670663020e-01,
 0.251021417710725289538440343894474e-01,
-0.296630095115872068287126185462329e-01,
-0.487798437276624651876891093136373e-01,
-0.174350607058282604541313496634402e-01,
 0.265892579350808308355554699663015e-01,
 0.433675140258809287573087260169045e-01,
 0.303470586048903997847482747315507e-01,
 0.110719110019571817793119385441633e-01,
 0.164407382538816273089630689126519e-02,
 0.305217433768495950776472006369265e-04,
 0.510633197626018659938677106003268e-01,
-0.180497011319588867128033476240526e-01,
-0.622167155469771886051837154483700e-01,
-0.221859051953216180488276371349047e-01,
 0.466634220132082487935441330721187e-01,
 0.516944002625242948597840261233690e-01,
-0.116024148983458300507500047903208e-01,
-0.571944232184492552823583670051309e-01,
-0.266567679948854991389128133290415e-01,
 0.362126664435830368554905759501058e-01,
 0.496095743773670253566085143474571e-01,
 0.110434459656363575943816483131373e-02,
-0.446267733835717324113674400929578e-01,
-0.349225229781384459943785635590571e-01,
 0.111995924328471083571498236830676e-01,
 0.407234181297693675951393156493912e-01,
 0.340708097540778938887124073096003e-01,
 0.135943954515114496802879943518794e-01,
 0.212312704368161708843038420438126e-02,
 0.404242235704496613294146906752021e-04,
 0.384845928523180741336657545284558e-01,
 0.572750796720816679754563508898317e-01,
-0.100519464223304404201714529717305e-01,
-0.613730843637564856232609935628283e-01,
-0.203496102461575930520812798543595e-01,
 0.496728764003868869152254447167280e-01,
 0.443893605365055997729680333850942e-01,
-0.253771658057407779252187135551822e-01,
-0.552094405588691124471098321167438e-01,
-0.465415388698844663952960174238616e-02,
 0.492078263527684881016650633309985e-01,
 0.313203225929876967773253538590596e-01,
-0.270949204111361021798845653224211e-01,
-0.448331747271631898994147542004116e-01,
-0.570912698466550545936115362012155e-02,
 0.349297045314049057457076302051303e-01,
 0.368966130272239724657184128536752e-01,
 0.162956033696921562374676511796691e-01,
 0.268858296778192002901544375455869e-02,
 0.525934561111845723730887041061452e-04,
-0.478451869171647744817658649303848e-01,
 0.316268766238813044959746821035442e-01,
 0.580518083964234947239152123062570e-01,
-0.116286887516041032778633649651871e-01,
-0.607889159919565326414792655200692e-01,
-0.938880182987567615672762746569230e-02,
 0.555361208974346800452376654474785e-01,
 0.284249039997123805350097999886712e-01,
-0.427712972039980020356737574678569e-01,
-0.425129718151421157591279412692963e-01,
 0.239312546459975079983241354731223e-01,
 0.488836505275656534129166014524732e-01,
-0.132563865867522368907176251655657e-02,
-0.447938557894027860507655193455452e-01,
-0.217253011909611777367464267929999e-01,
 0.262141356697595459748116307991366e-01,
 0.385075430357790174802953445579268e-01,
 0.191020784219690530875468518764728e-01,
 0.334527370031015809038388850317779e-02,
 0.673540227545332993297146774102313e-04,
-0.421779571396604231098418478456749e-01,
-0.496169819807847033375303871301313e-01,
 0.329035620575521368040132748519700e-01,
 0.548354880694595466617224147641138e-01,
-0.222209373024729458318670953230151e-01,
-0.574882819218343123646296128521978e-01,
 0.105939970973688359827186730381241e-01,
 0.572530421448723642405750050604523e-01,
 0.148305213595342928693490822342390e-02,
-0.537813405702924334649286974031427e-01,
-0.134822758389738297594580560397866e-01,
 0.465718508739636969653383763225322e-01,
 0.247885226683918102429393702872617e-01,
-0.346143350654381097102011967144460e-01,
-0.343872458525798145051361425597151e-01,
 0.151711679100607492256890259950686e-01,
 0.386389912733337558405666855298768e-01,
 0.219250652565033333177024792577335e-01,
 0.409655499928734968715719243157061e-02,
 0.850497591183110990872793413630241e-04,
 0.444019101258931913030270949171311e-01,
-0.433100279495554359075487678460709e-01,
-0.449846437054472224723287067635519e-01,
 0.416084342184411225853261146324898e-01,
 0.451465718796340676292302472772366e-01,
-0.391728010603535382468706366968226e-01,
-0.449696533660953100807440239416033e-01,
 0.358328454674005427363657236677516e-01,
 0.445301501854861429031279219887025e-01,
-0.313262070511049134865546780936608e-01,
-0.438881030623839843944692319166666e-01,
 0.251908766252399973835887836229412e-01,
 0.430345064565814695152173799248116e-01,
-0.164718631563971888915133253707381e-01,
-0.416238531832645330394402393255870e-01,
 0.272238125540908164126306153674518e-02,
 0.371066582006743593740747505487751e-01,
 0.246632851061174954950776162810011e-01,
 0.494407204826162948083716675585449e-02,
 0.106042453765544103738325339332786e-03,
 0.456040813779407517566033988279764e-01,
 0.392827666091036216645922101127427e-01,
-0.504961544731395673872795156310325e-01,
-0.320066730632493376145901998161512e-01,
 0.536253668479557123346810737090438e-01,
 0.243659251924292307588707314250925e-01,
-0.548190803822060681035726354765984e-01,
-0.170431781810350449710465060688376e-01,
 0.540756645939157590214364579678840e-01,
 0.108063394296966037272103665896173e-01,
-0.515567875281389956508189671178792e-01,
-0.655088263086096931924318331608182e-02,
 0.475353273324754232814986623688792e-01,
 0.549675953239467854833521120573960e-02,
-0.421546811956458496639634225232738e-01,
-0.997011042939123527820058093125634e-02,
 0.338299704933495869747132676514108e-01,
 0.272066061593216066989748676067922e-01,
 0.588755257758731379811876591375129e-02,
 0.130710377140766574013274214737648e-03,
-0.407335831143878002696028609292955e-01,
 0.525112715796174864752760085911719e-01,
 0.251250017266960182270166835472632e-01,
-0.589918395706247588541178553997106e-01,
-0.778118936213168158315433647532688e-02,
 0.596091606282164469885455537656348e-01,
-0.895161305756587893407293797273025e-02,
-0.548158534823298345556261179964238e-01,
 0.228970645540963594469625515671302e-01,
 0.460398737273053074939495358967291e-01,
-0.324319065790997576956008582289513e-01,
-0.355168332227631768306838857398104e-01,
 0.367408786363282922906822745435476e-01,
 0.261236079665709694078143436855887e-01,
-0.357690981128065170279887680483576e-01,
-0.216288009484224802886077122668922e-01,
 0.288484756167511741595711796143819e-01,
 0.294404716559251028100231086404005e-01,
 0.692463364975012718764443310285019e-02,
 0.159446647943437986760019727236518e-03,
-0.487457136179511719701179387193333e-01,
-0.268494522877772789976525157063719e-01,
 0.602545687348582208941194969449448e-01,
-0.158639222479460869608813275418263e-03,
-0.589520606768592204506783143293929e-01,
 0.257504910375783508329238232584760e-01,
 0.459603679213213695422825228922642e-01,
-0.441379265730983563534513265539497e-01,
-0.255196602362246482791921316117975e-01,
 0.520253383856737427431018156140605e-01,
 0.358774908312227625075268699705633e-02,
-0.495866538747719226538854912150980e-01,
 0.140496953438777728526942131890454e-01,
 0.404443526569105748864631921961176e-01,
-0.234232520005618937764539701077310e-01,
-0.310101263060214385328750025931767e-01,
 0.223292647006414607325380292159770e-01,
 0.312509022986184713298987017450422e-01,
 0.805072780436472971494304115215682e-02,
 0.192657445127507059319174199174102e-03,
 0.368498685948136888966035935056069e-01,
-0.587662308315557346285304134816079e-01,
-0.154746411555357544160910310071225e-02,
 0.588317865917524382048522041442232e-01,
-0.331141594672517872585472893513141e-01,
-0.379269727409093985325952872297655e-01,
 0.539652106333666204646131153967331e-01,
 0.556524420544608672053710121582283e-02,
-0.545693656951028366729766536086879e-01,
 0.249116577468510577590474254933156e-01,
 0.376830936093078132108501368524291e-01,
-0.427926541776782192218823840517538e-01,
-0.132002383718973942991765846532074e-01,
 0.449336064948771115902975789059595e-01,
-0.712597951623804354510448438817060e-02,
-0.370594585142177149652055737423934e-01,
 0.145641744505717882647191546656734e-01,
 0.325298510863299765605067539394793e-01,
 0.925893350384757893235129689230977e-02,
 0.230760074324993177558344930844373e-03,
 0.515862705134417830698081648929859e-01,
 0.130009409455367038936211490088392e-01,
-0.607922690690424517779825424097548e-01,
 0.321156011391086707198014586519117e-01,
 0.359464392521502144313016559457650e-01,
-0.575121947493722683049480409262903e-01,
 0.689871682213542129467669287904190e-02,
 0.502837421884776118345296454766700e-01,
-0.422207592233353519855723196336248e-01,
-0.180587862637543211816805149368864e-01,
 0.519356979869432641715050630571967e-01,
-0.179353338837034671572334076516970e-01,
-0.360840946574343169376916474842648e-01,
 0.384214357961342141945229694083658e-01,
 0.103755960570053164090231373900499e-01,
-0.390514275935139232167375588333443e-01,
 0.595636334202824002759704379527379e-02,
 0.331806602398963637149708397250943e-01,
 0.105399939427748839312069272553477e-01,
 0.274180898093777958717346500214562e-03,
-0.327662606972351981285729962509180e-01,
 0.617631701025526202517678843968773e-01,
-0.221609931916919361229040683927544e-01,
-0.413464188734795728681365110509440e-01,
 0.579604665829919327250830379193156e-01,
-0.102692306496069229606571767117291e-01,
-0.471683560224874245941184025279069e-01,
 0.503541530543751118573153864568282e-01,
 0.217767287688806373377063534740706e-02,
-0.494446969164337008262367412256256e-01,
 0.387972962960733857596580257472918e-01,
 0.145014566388105059439898304191363e-01,
-0.470292821446045471694416407067619e-01,
 0.224422919150509955382582625308588e-01,
 0.260607031882907927834346640044597e-01,
-0.366961711809144942531129985676681e-01,
-0.300322439326540298880138108890662e-02,
 0.331233532182961964796309278069574e-01,
 0.118823072994070672466395479928582e-01,
 0.323353139977327821070639424870367e-03,
-0.541103281743883036965977050451348e-01,
 0.150727891441155534932312700983000e-02,
 0.521050282811033809684476849403589e-01,
-0.545056079160942415643401997322719e-01,
 0.416446207636295597665638293033937e-02,
 0.488706131906603028088186977714418e-01,
-0.529651064674954426410377472077504e-01,
 0.570357921120904429814834175598884e-02,
 0.448813584842645930909624195085657e-01,
-0.491361701176083492529047785994438e-01,
 0.516519899803911141872461101199713e-02,
 0.407408774086350786963636156824697e-01,
-0.423610017994569583809818084967566e-01,
 0.907043759573693779644866109436488e-03,
 0.371685332005888003531664999118728e-01,
-0.301957497486361940962497510580527e-01,
-0.117680812021958770078570574290112e-01,
 0.322994910750402651512570624282952e-01,
 0.132719904361301223296254341633811e-01,
 0.378714572929853114875469521367125e-03,
 0.285021104679158800328608573655710e-01,
-0.613618421216224297264227557178376e-01,
 0.424297263500531034705542636390680e-01,
 0.117845967546624924480782328840348e-01,
-0.550380925053166274267983850563886e-01,
 0.511171643512740885161908334177169e-01,
-0.456253652211939486669038063596906e-02,
-0.439833675023045664447780234455566e-01,
 0.533694590405803411658754544343293e-01,
-0.173020158935914008845702623181457e-01,
-0.311771215857464169499103277570196e-01,
 0.495744594109336583912205483548226e-01,
-0.235826583568845788574452051420324e-01,
-0.208379648464631730765973036487255e-01,
 0.417029822635578650634415970545177e-01,
-0.202409141030634919710413540046271e-01,
-0.197747945608911062525872537264268e-01,
 0.306763321209823016575236399706222e-01,
 0.146929969180627247855856399679395e-01,
 0.440705103198525418952771742993184e-03,
 0.563039399257974260325793932836876e-01,
-0.158878411772751784716915484766102e-01,
-0.355612810512614834692596851538314e-01,
 0.608479302126338782329759589733019e-01,
-0.421646184897815963182494783191336e-01,
-0.613234852789221468277688799086083e-02,
 0.484783441468919818871383386038356e-01,
-0.544936439673314686891423872187134e-01,
 0.211543121632475741469656551243299e-01,
 0.256287312448157650085378333996543e-01,
-0.509438442502196384429942884535754e-01,
 0.371887019381383692532309448770599e-01,
 0.306898979559948045113515348842458e-02,
-0.373389448516820117292454366221970e-01,
 0.388125083668878725681096766821976e-01,
-0.794593874626402890366347105102505e-02,
-0.264852297505079627878401680946231e-01,
 0.282500569270180451622957325005972e-01,
 0.161272890389007897305858529592962e-01,
 0.509764261259712165643651456834515e-03,
-0.240794841608747811820238045862868e-01,
 0.576021044893789060680721757748764e-01,
-0.562298903098786611207285858712628e-01,
 0.211452070705436026917056791897793e-01,
 0.259077899744382109737696530670339e-01,
-0.562050843988260637546172966063165e-01,
 0.518125163827723563960290460692500e-01,
-0.164601909433459670304808146167858e-01,
-0.271899195122910528462646548308736e-01,
 0.520394652919553386474619391312534e-01,
-0.436043889794573345100751220173351e-01,
 0.885830966222875734613662438122378e-02,
 0.286742543527414577137633465626528e-01,
-0.444166377263520695962893511863297e-01,
 0.289695899088482616701692298347099e-01,
 0.527263372088124928096714296139895e-02,
-0.314288921955407682646960343105052e-01,
 0.250478563407291504757712051839085e-01,
 0.175550623445058457520216766506109e-01,
 0.586328611874304538164482660037389e-03,
-0.581548564559203971304463270699126e-01,
 0.293632202519131001231114482482998e-01,
 0.136906134545469763324144907718493e-01,
-0.493791644646168980910158923384386e-01,
 0.600084737201314258511950170483147e-01,
-0.407701138008166064642073368338249e-01,
 0.202323066679812596212696760160685e-02,
 0.362240643056662498462329812241112e-01,
-0.547293802148413168481279982486326e-01,
 0.449026816091183022203822279072653e-01,
-0.130398688597162885097392113344192e-01,
-0.232643074486295988575824699718982e-01,
 0.446154834853970659262780369669134e-01,
-0.402465767858288857875089962326606e-01,
 0.139100481464283946683837329126249e-01,
 0.178598430501352260578688455754118e-01,
-0.342419643766626962313184378223212e-01,
 0.211287269918413777314609937948425e-01,
 0.189550199527752769993856668974068e-01,
 0.670829095754230173930303386772140e-03,
 0.195224416883283734481361690538487e-01,
-0.507023304085404262818423330427662e-01,
 0.615184341031426944820894604042183e-01,
-0.478227241466650886352091443450982e-01,
 0.154699945194536277879692555806218e-01,
 0.221740635964622248218519124425464e-01,
-0.498160064575997675345957394950601e-01,
 0.565694147585219138871093229946500e-01,
-0.403951957805342461422728193539520e-01,
 0.880213565341494366143528342246119e-02,
 0.244661603894537555046217368772958e-01,
-0.453490756042504123648683983089967e-01,
 0.454940088322573368505831466824807e-01,
-0.258523841013478097331973243781771e-01,
-0.366296319321358276065190756731403e-02,
 0.283091506327539187284285683074406e-01,
-0.346996483746084889572682079005857e-01,
 0.165828747309429509458576971112009e-01,
 0.203046928081331981079496047284842e-01,
 0.763688315714761755788725595090395e-03,
 0.596526856047984460815051471162247e-01,
-0.412070789449296667153844751793300e-01,
 0.101980458377137612133785831538593e-01,
 0.235210657000327680552589905779958e-01,
-0.493218351358890638911171903707816e-01,
 0.592356307671404932472975829341247e-01,
-0.505040514108934627211487447991682e-01,
 0.264134761611075352395119278073159e-01,
 0.485351829842041406070120362545102e-02,
-0.329659432461873551944879819196646e-01,
 0.488834085047616884187216762924360e-01,
-0.478536153137493177878946894783706e-01,
 0.309837992609514610007030898549029e-01,
-0.487382877416194285287815880442818e-02,
-0.205606004238851021489594573998303e-01,
 0.353489622498350928476166479334428e-01,
-0.327388749713926399770982870796153e-01,
 0.115296891011188789161150594695608e-01,
 0.215808009053923014597605176900018e-01,
 0.865317780522291304490698000885272e-03,
-0.148565386120709785605390955166226e-01,
 0.410479403457175061074289279118202e-01,
-0.575349426483995144036768663519132e-01,
 0.605036810297575924875974491325464e-01,
-0.494312113814310379901428147076868e-01,
 0.271937788862754588801393093068284e-01,
 0.664343348045111838130247988456528e-03,
-0.273188629109437768901261418601855e-01,
 0.463650371234869171539771544928309e-01,
-0.534067581293241436841851276017264e-01,
 0.471413519591971414713171463928353e-01,
-0.296724852884615504177519096949631e-01,
 0.597635181128456448211539975459865e-02,
 0.173422051478702413426488293364123e-01,
-0.336893525013571119391071706025473e-01,
 0.381048143191612527638229367157210e-01,
-0.284691359244782955694680031153386e-01,
 0.611431841993099746019606658740716e-02,
 0.227596494947576946395582337566674e-01,
 0.976115119932262581390057566005778e-03,
-0.607890112729239349568552453754204e-01,
 0.507829498193079133082312270012299e-01,
-0.325117320596129100632606263852613e-01,
 0.914714482299837513737495051697602e-02,
 0.152727708241242581748228107623824e-01,
-0.365620390033311028515624894738636e-01,
 0.511304315427033252700075423403391e-01,
-0.566197543535257294843678547890777e-01,
 0.523193292484285240748340602534067e-01,
-0.392869332681086393421254156806860e-01,
 0.201543549284801596088433849517256e-01,
 0.134659438031445782602907505806673e-02,
-0.210514094869347812728479525095195e-01,
 0.351022340872760818567863033912023e-01,
-0.406242790862559973794736430752049e-01,
 0.362156568772689301741899915164425e-01,
-0.221701057142769748427433698931225e-01,
 0.502942238256480916382199467635204e-03,
 0.238175533600285053435054278529132e-01,
 0.109646128464472468812672682195461e-02,
 0.101084524157839098690009743477566e-01,
-0.291707991175454253436021386223140e-01,
 0.449077021444456930990973764823992e-01,
-0.555463553480720215235603191617993e-01,
 0.599240462770024872305730857555192e-01,
-0.576268847997086071313801844149384e-01,
 0.490386370717885924407014472690151e-01,
-0.352939065756349161611379094168814e-01,
 0.181414595261252883265348228527482e-01,
 0.265632200457511868325748221915856e-03,
-0.176274567124180669469146276952676e-01,
 0.317708811629109165847240606642920e-01,
-0.409056664823308624343968695309261e-01,
 0.438310910008532681415518950836765e-01,
-0.400664452101985709916169810915419e-01,
 0.298880469918576810524150727444771e-01,
-0.142757710602851728510910022627068e-01,
-0.512309737085710760251642163211339e-02,
 0.247312814664374998738196902485183e-01,
 0.122671774508361025634682168422535e-02,
 0.615574821327380156846658435248158e-01,
-0.575781298487063261342647797728436e-01,
 0.499087239230835065149266174330276e-01,
-0.391067845780199936217335967194040e-01,
 0.259574499597534583263088217415483e-01,
-0.114163345577274688294953177242510e-01,
-0.345993939753692450186710712261180e-02,
 0.175904073990864066314798315330923e-01,
-0.299479417211230708583333409431263e-01,
 0.396331070429413259063858026304141e-01,
-0.459380993418108052938033960780664e-01,
 0.483957744508808399100712077989714e-01,
-0.468096436854303712660688296912324e-01,
 0.412617368916890662025925489476393e-01,
-0.320963554311882810625419521627303e-01,
 0.198797325116103232412631007732076e-01,
-0.534589502303922379064826715904503e-02,
-0.105740852193722631427851780194698e-01,
 0.254785136216264428438585163193917e-01,
 0.136722370302879377768118154359814e-02,
-0.530568056339387864229623820932567e-02,
 0.157206583217170405644411267052533e-01,
-0.255537671906138894192409411160100e-01,
 0.344410850631387698802342135230188e-01,
-0.420537041146061912169756036946278e-01,
 0.481098267433581531654388733120646e-01,
-0.523850266956003428635074319215655e-01,
 0.547202519686637557157595460379632e-01,
-0.550272098846679662751835546792515e-01,
 0.532908373400796002736374928029494e-01,
-0.495686071483649147518658464802553e-01,
 0.439864325472329042715738957050293e-01,
-0.367308711636590139780994145553804e-01,
 0.280371531885565530057378867319024e-01,
-0.181723023951397850174257120514581e-01,
 0.741309333849413443683095681394025e-02,
 0.397328522381498316583888761710143e-02,
-0.156593722389625660021254295637515e-01,
 0.260383002988954771900159047794282e-01,
 0.151829333019599985477458253223039e-02,
-0.619538762451916766147747911020358e-01,
 0.612309435873420362475424067890257e-01,
-0.597944898663909065458143046001775e-01,
 0.576631724931565873077323002941512e-01,
-0.548645604281305517812843562810880e-01,
 0.514346250709372557162522007330978e-01,
-0.474170441619367804928926993776726e-01,
 0.428622967971418980542175471033793e-01,
-0.378265108732115930250746946036302e-01,
 0.323699950714234898282620181305901e-01,
-0.265553361163723894586002938655968e-01,
 0.204448509345370973401787182068052e-01,
-0.140970225671226315973264639060835e-01,
 0.756127978478030146728438286964247e-02,
-0.870137928200175429715818172412662e-03,
-0.597194884519236893917367015615465e-02,
 0.129962837923049291168777884565625e-01,
-0.201951545183689009189875455877985e-01,
 0.263915164489845618346018571558378e-01,
 0.168021304786775581581247816011220e-02,
 0.688370033005485823422691818790886e-01,
 0.675157849460612832287154113688120e-01,
 0.649391253452503173799700805460434e-01,
 0.612339111607951411336906211076678e-01,
 0.565791961580980914814628839628948e-01,
 0.511937333954160833645428633113795e-01,
 0.453210203053203871643501397595738e-01,
 0.392130894591638600656341087408547e-01,
 0.331143610370431282226613554628534e-01,
 0.272468382405121307437739610885031e-01,
 0.217977784182179205269988222045955e-01,
 0.169107254481077118401471981897477e-01,
 0.126804669890242070814362352387402e-01,
 0.915211444717540547517488272347475e-02,
 0.632412861816540988194194460571815e-02,
 0.415476521453156889360654287210297e-02,
 0.257112429814333524384710786484949e-02,
 0.147978253129008196804587745565359e-02,
 0.777885263914449157886166598877218e-03,
 0.363584825296620144832121862948660e-03,
 0.144829227641152722546492473086943e-03,
 0.457185900065711491056600604904406e-04,
 0.993259586006342875081345676747361e-05,
 0.106192880418482637864661545370273e-05,
 0.165655739167889637097059918267518e-07,
 0.709995314129269542976800812193205e-02,
 0.208641008906440950223857012278780e-01,
 0.333601359271414307835881703991475e-01,
 0.438688898140115232613430485465072e-01,
 0.518460223575004584481752133784921e-01,
 0.569647226446882792889853719002457e-01,
 0.591352144407111308993934920318026e-01,
 0.584996099477990526620720553577003e-01,
 0.554035841070464448313818544868203e-01,
 0.503490249056063197769285960417788e-01,
 0.439339148894396057502287313443058e-01,
 0.367869576155532644853949951209920e-01,
 0.295047369874698110352076569650111e-01,
 0.225984765806569347862874746749440e-01,
 0.164558716765443166295437325359298e-01,
 0.113212344088392977774633980220524e-01,
 0.729463851058920174423882437093836e-02,
 0.434822756409843046229495571536391e-02,
 0.235570026399330791365633369691672e-02,
 0.112949028050307106840284593727406e-02,
 0.459502530476589111161334752595182e-03,
 0.147516797475646418125106911151419e-03,
 0.324602177394608477931198730316725e-04,
 0.350099987812650129121408197475572e-05,
 0.548795113450541355284649569107751e-07,
-0.549077672221060945124298635208407e-01,
-0.492347933152290900122949073838529e-01,
-0.385388477004634757341012451116517e-01,
-0.240300287351618096744449568338490e-01,
-0.731278261274850599762505026669718e-02,
 0.982993441559285984232436115548567e-02,
 0.256694711860808614528036156626395e-01,
 0.387463245911370159002300264386388e-01,
 0.480359686985848150588065106960884e-01,
 0.530435060195349324559254838124569e-01,
 0.538171987727876916739264472179101e-01,
 0.508843285209810353325585388523882e-01,
 0.451250621712190572501347742890464e-01,
 0.376090058337523424895067497570638e-01,
 0.294234692018421631315863768389236e-01,
 0.215215794319713828746142470584293e-01,
 0.146126674917926031147651097942845e-01,
 0.910805426720074666190565755381339e-02,
 0.512434979092576261865891539567296e-02,
 0.253575766288972961533276670517541e-02,
 0.105860948183777048482456590953660e-02,
 0.346889091869259140568824408481783e-03,
 0.775178114255648602692947461387269e-04,
 0.844946894318411709752540900931912e-05,
 0.133223038954755805255993768123746e-06,
-0.106052980347561576750649941496275e-01,
-0.301187919468497564152654532286130e-01,
-0.448379536823408958440728065131901e-01,
-0.524985882393278005204177815704042e-01,
-0.520441478287046529697764964201803e-01,
-0.437692607487149240978569420048130e-01,
-0.292106472416248346295419365948415e-01,
-0.108155656378962426331680666335267e-01,
 0.853808732529889184567449211277780e-02,
 0.260689601554957992895744824477253e-01,
 0.395611068837721415553329384676063e-01,
 0.476869746910335622841656160293995e-01,
 0.501327711920733322499250447137717e-01,
 0.475193190371876281387023024744649e-01,
 0.411550005474767536945367631870853e-01,
 0.326898508882580533669951629311990e-01,
 0.237545569190315097343854715374199e-01,
 0.156627730968875829210658602202181e-01,
 0.923229776421111457009957841744958e-02,
 0.474681453662885876309771267234041e-02,
 0.204394968019955278493751425743684e-02,
 0.686251568193757952069614593939160e-03,
 0.156166021887729920793647493586829e-03,
 0.172341869519320989133679696719640e-04,
 0.273589269890916942248296556180691e-06,
 0.513020804503950420460051508131094e-01,
 0.402150447717275016952439865220236e-01,
 0.205342441029995318991034259056029e-01,
-0.335287553524076618829482603075643e-02,
-0.262085728165661999525486543570482e-01,
-0.431668370883319683400064039229471e-01,
-0.508266765013606463064608116098227e-01,
-0.479514134428492807648152369322250e-01,
-0.356191785488431818933525479370409e-01,
-0.168171947852653172312386645345887e-01,
 0.438449296981882144165609131726357e-02,
 0.238442594825460999239332635400316e-01,
 0.382780995750927917360322260866187e-01,
 0.458819722144314313259665836425765e-01,
 0.465224362464417553074290491305827e-01,
 0.414969842626769107350360570763238e-01,
 0.329807181471104135380972892783429e-01,
 0.233482067262197731143855115729647e-01,
 0.145709717277815980821800473611901e-01,
 0.784348987080846624060795474239207e-02,
 0.350291384143343705561155844363494e-02,
 0.120989840196107700307483225182490e-02,
 0.281172614299873385944738399108967e-03,
 0.314741841469334694567246300636235e-04,
 0.503558332983039467313848737620838e-06,
 0.138133944129411625305531804265394e-01,
 0.374822572161949113784218986866927e-01,
 0.504551885496716390949756123697376e-01,
 0.491596874446200471832811828258084e-01,
 0.341929077969482618030653447648869e-01,
 0.100475414330258674499831871333504e-01,
-0.163233364982541134457122376198387e-01,
-0.376204815362298286734093701528905e-01,
-0.483123480863250662918549178609568e-01,
-0.460997014821608730233008670382198e-01,
-0.323220629791248593661187607297513e-01,
-0.112576767181955384093104032139821e-01,
 0.113764835221945941518773270667106e-01,
 0.301877212134190271089510647120702e-01,
 0.415605614469771481152785084682657e-01,
 0.443836518664689596878498794088235e-01,
 0.399167925369810225632985936772259e-01,
 0.309639359468511833002914033032233e-01,
 0.207289147400395992926934263971325e-01,
 0.117861040979377008678166668085173e-01,
 0.549299539150271411187425164714789e-02,
 0.196018085290379620476299449100610e-02,
 0.466567336219298464883362537166096e-03,
 0.530747131180954278307546517473325e-04,
 0.856645606102889852594589281405461e-06,
-0.492214181808484249062482561400674e-01,
-0.317064368149032118597615633381075e-01,
-0.304370204514906080126036443982778e-02,
 0.264213240090875649220107383042954e-01,
 0.462133914274161782819417842164865e-01,
 0.495507077735464078756504902079717e-01,
 0.356967902081714797059822619819510e-01,
 0.100012372222975341969648080646464e-01,
-0.182919793259773408104481367035502e-01,
-0.395367496044179204124422047136756e-01,
-0.470958944729590461366832530797609e-01,
-0.394051227323605281610060530860298e-01,
-0.200295832092860799978752903950645e-01,
 0.412377180020997427055179618795759e-02,
 0.255797649851353552140824680587620e-01,
 0.389019320650207095795072042820789e-01,
 0.421745130074136655753666328897777e-01,
 0.369615955431773286943738559284843e-01,
 0.270047903931007985368534015403841e-01,
 0.163915829592538498619153466546256e-01,
 0.802749291680024953610313168625429e-02,
 0.297328022834200342134571248493588e-02,
 0.727066772183507512624212443216128e-03,
 0.842112421457343455372617140103868e-04,
 0.137257423731859051307573285262972e-05,
-0.168765335663150110340035343628623e-01,
-0.432218187025711638668371306429706e-01,
-0.506632648201104598276049480549826e-01,
-0.361366809076188717546835775925280e-01,
-0.626391971193075296869448905593134e-02,
 0.257674734321165935896619310900886e-01,
 0.461837588618125675447455153204258e-01,
 0.466701735546569265893205071807878e-01,
 0.277525381331132302970795370137457e-01,
-0.187931402473673032942972431021370e-02,
-0.295761120170526072826231500930957e-01,
-0.443543115603153527896631247282178e-01,
-0.413331749274973216404933050695929e-01,
-0.231225656487933178251909221314427e-01,
 0.214360377687208962739699288936597e-02,
 0.248717511681020652774202086542261e-01,
 0.380957894769669306817665770986008e-01,
 0.397629305114406338861811237676366e-01,
 0.324854446351945090585771423024395e-01,
 0.213306122256470808893932661523222e-01,
 0.110644545400290807566367893186705e-01,
 0.427495014654394639530370006264328e-02,
 0.107740449857197017352280129679744e-02,
 0.127305120218180403045969353824170e-03,
 0.209749552775676404666595319394975e-05,
 0.475288144636687288067395587798563e-01,
 0.227971539891017567512660996651247e-01,
-0.136242800024511686263906681811563e-01,
-0.426540529847095695020004165787198e-01,
-0.493366858682537246237118622288868e-01,
-0.306437176661069700424474738184012e-01,
 0.323355521410968834828983729253484e-02,
 0.346098882867234949223683390552269e-01,
 0.477490299985602910453561734023312e-01,
 0.368514278260656254268677280485447e-01,
 0.844629871353181838931455802978659e-02,
-0.227189042328282933088483615358930e-01,
-0.416658657110161338771987486076306e-01,
-0.405611668172335381252089517280906e-01,
-0.217137355729429791885155627579167e-01,
 0.486646054706672814184511104241937e-02,
 0.273927802321332140271972151222546e-01,
 0.381405395306255845141582315306124e-01,
 0.361810057781886714128010465088998e-01,
 0.261476712746436883222888522535567e-01,
 0.145004955121007132430476246478594e-01,
 0.587656611497978457370685314616160e-02,
 0.153159485433791455009628593298989e-02,
 0.184991579782204872138067621320059e-03,
 0.308416235459478319972380473280067e-05,
 0.198293445865165028861787340193069e-01,
 0.472947155569317171060847509600965e-01,
 0.457752498013201367156669445425761e-01,
 0.164593483682669915282125546999412e-01,
-0.224235332414622086931533143468362e-01,
-0.471301429895934126383879593610011e-01,
-0.430964812637510307102236930182728e-01,
-0.135517140149300234440460121842181e-01,
 0.230906406965776824651116813552203e-01,
 0.449884076053155155032372373141692e-01,
 0.400912899409711159884955295078110e-01,
 0.126566017069489444041777139981098e-01,
-0.204354276986011716235999148257857e-01,
-0.405129063174488170334850061446910e-01,
-0.379063255498257573241338495873051e-01,
-0.162502156426650755437272894460690e-01,
 0.114650654761278107461864398380463e-01,
 0.315705308966527248114421218457186e-01,
 0.371963495119934093439255776219460e-01,
 0.303033962273452354899947578158367e-01,
 0.181706619105954829798239442005328e-01,
 0.777180534339418828234107641213333e-02,
 0.210216019586952456165906342748729e-02,
 0.260080685328624342923584723628620e-03,
 0.439205800995113894356001406698684e-05,
-0.459087943764803967274466710964964e-01,
-0.134461703571827444502668534014429e-01,
 0.283162655178000698387091401286246e-01,
 0.497696682792078659622166908633804e-01,
 0.360686692480828284626372593923590e-01,
-0.255044915723107536506708162065494e-02,
-0.385728223057806242156937783777310e-01,
-0.470802445533850706753266335620382e-01,
-0.231192325800040837758291129389614e-01,
 0.156860304572379016885947244517153e-01,
 0.424273383846947210824717092185181e-01,
 0.398732961866454578189899417733636e-01,
 0.114719835515243012968526227591860e-01,
-0.226308247147306294690037814832764e-01,
-0.404657099993505880285451705817235e-01,
-0.326777553517710937055951952753712e-01,
-0.674507024627310245602535404421198e-02,
 0.204644454643338161013957399902224e-01,
 0.349090010801244949401131648476689e-01,
 0.332352759250244172186140927001778e-01,
 0.218549313159546222836983279630073e-01,
 0.993424840670537139831517520411141e-02,
 0.279935320996030753935749189161843e-02,
 0.355511896031547239060455170170736e-03,
 0.608748198705864453295883562138173e-05,
-0.226793531067758212467444445511500e-01,
-0.496283529028465245659302500621881e-01,
-0.364226473542307760742743643876247e-01,
 0.592944472529713199297837793262753e-02,
 0.429660438249876766529774355024759e-01,
 0.450916533355681592304092203293696e-01,
 0.113822259621540539266451119841589e-01,
-0.304450205234300934808257267655591e-01,
-0.471496787228054135159720431981465e-01,
-0.266107219799290017973175200864114e-01,
 0.136072745259613398191657431924864e-01,
 0.416548034294998765908995437271279e-01,
 0.370129188434552941012700400214688e-01,
 0.534245726345371286343506839173550e-02,
-0.281500966507008908533957344242594e-01,
-0.395221148689105051363939215718794e-01,
-0.233676726893492423969892191384144e-01,
 0.620938655368827415048805423232015e-02,
 0.291196019656283891747226124653118e-01,
 0.344296370274617169734964850393176e-01,
 0.252912760944620179799899341570436e-01,
 0.123161441193785382653189318887025e-01,
 0.363040673374563468095265515796053e-02,
 0.474302991641049651295304646767424e-03,
 0.824359386848919794190167539987159e-05,
 0.442444155381581567047430161558763e-01,
 0.383832718353686276645593868220937e-02,
-0.398352119361023286444036986047654e-01,
-0.468995824569899537785266841137361e-01,
-0.113963780957870560962046631086739e-01,
 0.337724190628923340651829790064113e-01,
 0.476429063493783922035922068714953e-01,
 0.185935420612037199130030438990566e-01,
-0.260918107898602052613280574654998e-01,
-0.462251675078068316237575219981861e-01,
-0.251624779233041251738734636465780e-01,
 0.167145197034597597802168952944825e-01,
 0.421900403958407221662124052901023e-01,
 0.307398973168728548103574356551331e-01,
-0.531481412711344013648329084940753e-02,
-0.345088272094451999366422828662217e-01,
-0.345552933850344868200055185836533e-01,
-0.901369269420385974836643022832317e-02,
 0.201434646511194182471481111601048e-01,
 0.334956768104211329702975668037659e-01,
 0.281945275460339890675748491982555e-01,
 0.148485116890566220571169883874150e-01,
 0.459884335237200251501487293620249e-02,
 0.619494192687898270747964259070760e-03,
 0.109404162711593271279136953133458e-04,
 0.254249039831274897431919640476957e-01,
 0.501789003933291548305519583100849e-01,
 0.235956508862847865513302459139508e-01,
-0.267448975885270358759355244233338e-01,
-0.492822991106862423770879318578877e-01,
-0.216176691886901567221476741865186e-01,
 0.272132091955132474843614147088609e-01,
 0.475342196603779498697144016026347e-01,
 0.199006909752041728671774659181632e-01,
-0.264629986831429457494139955545932e-01,
-0.450089769229806322837142222062021e-01,
-0.189498701639667613163020279074363e-01,
 0.240058218976854558633126370277653e-01,
 0.417506364612498775859467480908711e-01,
 0.194683965304181732149446936296689e-01,
-0.189416800871441930586260884571908e-01,
-0.375201709548841726603435317067003e-01,
-0.226121794608374456330157358512754e-01,
 0.882034863695207154622076225695499e-02,
 0.302313032611003705740030582767083e-01,
 0.302796364923080956369389785309200e-01,
 0.174426734827249966017633897846150e-01,
 0.570387575270248147361083132870306e-02,
 0.794088382067313357707547356434748e-03,
 0.142647976935414723373815402095212e-04,
-0.424858087165892188768476155430903e-01,
 0.576049752510834467808332590037586e-02,
 0.472056126866192674655398104342081e-01,
 0.349080873592218325980004411218652e-01,
-0.165588289788730916521674332475480e-01,
-0.485393109683908168251393695903342e-01,
-0.255422474471838340981950587055518e-01,
 0.253062836386326102023397355056891e-01,
 0.465959144255337263484490106208089e-01,
 0.158489672767550368418400428035607e-01,
-0.310010486423842504623008190160672e-01,
-0.421486014031655984355757594628126e-01,
-0.752592750228528006936660610461928e-02,
 0.330914017219195729969914177663363e-01,
 0.366177264668266192216974271796454e-01,
 0.249155250701360040147085335474339e-02,
-0.313645122742692073106039716643336e-01,
-0.320932963801041022764950350957677e-01,
-0.356689613594588949270543123517138e-02,
 0.246709366430931271018782583182003e-01,
 0.312873926350757796949786642458984e-01,
 0.199932222069892376904814024325195e-01,
 0.693992641130456907432344453696915e-02,
 0.100098840184806816871256722586823e-02,
 0.183103360568343291346951306934563e-04,
-0.280606117789235140529444743247518e-01,
-0.489501328859512086653222941540273e-01,
-0.858053594404573344174993777953985e-02,
 0.420962300908578745037388525588402e-01,
 0.397970222701578926389424635748177e-01,
-0.117438467399389498184817871677418e-01,
-0.476931216666701344547812523811390e-01,
-0.241303456573580328308080530809573e-01,
 0.282237792979269393179464427659285e-01,
 0.444532693996847681801014295426107e-01,
 0.636208984319095002423072870514612e-02,
-0.376378418341442414349191234745583e-01,
-0.347411281141225788065343478780301e-01,
 0.874329275093277055278576205066248e-02,
 0.393366478777996681250860966491399e-01,
 0.230786399191204284316748222186209e-01,
-0.174492958201490781990037026486713e-01,
-0.355977230629357057050849974125966e-01,
-0.154580450078494758501157128409547e-01,
 0.171072228951914226536864163167497e-01,
 0.310102973183678325784855151343833e-01,
 0.223823332975934051649767135977086e-01,
 0.829629174167016041317728687552616e-02,
 0.124293245453264048731463637873393e-02,
 0.231772637156225936346551127091780e-04,
 0.406108015065064797117906534817660e-01,
-0.150547289201827837765336596330403e-01,
-0.498128910504924629108255782763512e-01,
-0.162752163609820760327024409160076e-01,
 0.389594243229618136069109624853744e-01,
 0.403914696505332662184699506896179e-01,
-0.128026066360810351123509189204130e-01,
-0.473987897079752904173435078452045e-01,
-0.174389624114943140294547237543684e-01,
 0.347268729478677805491606706213077e-01,
 0.388217458902582159305840345975925e-01,
-0.832036184175956384619734387970444e-02,
-0.422258419079173634145078099263684e-01,
-0.197349898745340415229518898231462e-01,
 0.264402363980247078193763808085579e-01,
 0.362058532708444368448227901014715e-01,
 0.835530199590221155603687231514469e-03,
-0.323353910622904106941922078925374e-01,
-0.252429334487694042740988728387848e-01,
 0.808162161961771692950623115859783e-02,
 0.293161240207411589674945630098660e-01,
 0.244852424950150331650040991883323e-01,
 0.975697141368199020606827559039812e-02,
 0.152242868041462258494343608989523e-02,
 0.289722947238199728277951897105578e-04,
 0.305794669221932202731340792136016e-01,
 0.460000669080544792455103246125806e-01,
-0.715021071292594450918107457642051e-02,
-0.491763785871555530232785006860196e-01,
-0.177979864900329502760347437016191e-01,
 0.393218314015356497604497775687095e-01,
 0.373439822502711465193137414638952e-01,
-0.193390251703182325169336426708436e-01,
-0.460875926759691837751693362776478e-01,
-0.496147140786045686208678078125281e-02,
 0.417005314125589051406553666908768e-01,
 0.264512517570117986756753516032022e-01,
-0.256600765072818722854214229018222e-01,
-0.386513725815699980844458659791746e-01,
 0.298761328972486032519515062678925e-02,
 0.375497482126035720681970155904789e-01,
 0.188718238779542531872672045063587e-01,
-0.228182430830655828736687689786108e-01,
-0.315153132103347519497903781752505e-01,
-0.165729928153041693057009041754428e-02,
 0.261667712269142053998416438807864e-01,
 0.261766256114272299972279151412129e-01,
 0.113006783177578564248258258212255e-01,
 0.184169001098995380510339197530047e-02,
 0.358084351711875096418029014451487e-04,
-0.386103977190356469291470357642805e-01,
 0.237451272441503887364305518330122e-01,
 0.474790844896453626537569188810239e-01,
-0.535095944137505938237058692235935e-02,
-0.488942801881564185890011915082756e-01,
-0.134998342613409658015533726466680e-01,
 0.426552255569824745507830609169403e-01,
 0.296329552121226676947114136304328e-01,
-0.298641654698300741071366126074502e-01,
-0.402907270266206004162801456166056e-01,
 0.127708913172370833050644668804639e-01,
 0.435842952400505281458833923549425e-01,
 0.555186508314187507334569658427296e-02,
-0.388092884977133008105545329531455e-01,
-0.216306660303686552863211023397916e-01,
 0.265836695219290143266350428357563e-01,
 0.319916783833270313336438048614775e-01,
-0.882492564471675319096779393373346e-02,
-0.333108622334651116725183612495251e-01,
-0.112247934540828000810060906134761e-01,
 0.216303152700876612543588547633643e-01,
 0.273375476804677430099791181213123e-01,
 0.129010387374301183947556312054468e-01,
 0.220257041175291086644533795551160e-02,
 0.438047574493633558538949557945926e-04,
-0.329737924919386444222471317496870e-01,
-0.414420296424190761860972004334897e-01,
 0.220721955821499212647340621429380e-01,
 0.467591949153398578283412453953094e-01,
-0.965688361363474928626002451836474e-02,
-0.484620386311531912688622350414906e-01,
-0.321694827805916925933849245204363e-02,
 0.463757042702468072046169748803122e-01,
 0.154322579455566400008519666327524e-01,
-0.406262372424515880658655055588357e-01,
-0.258826526940285312522250168245613e-01,
 0.316311472170448391338430421634013e-01,
 0.335319343296144624196411753182797e-01,
-0.200708176095686501895918293735622e-01,
-0.374413585791138796021851094142216e-01,
 0.685072080546586682100272855493007e-02,
 0.367222641486842190223449613927140e-01,
 0.691020242151278054666258816324892e-02,
-0.302873382567662179777647405506514e-01,
-0.196929743396727708642482536229848e-01,
 0.158846863364930581995192699893832e-01,
 0.278625966632019090802379689395153e-01,
 0.145269859030863151901799861112636e-01,
 0.260650362560736590980380970236766e-02,
 0.530861393604109504829917509105548e-04,
 0.364826039672996734906198176873038e-01,
-0.315459721385338344067602562291834e-01,
-0.404866613767585307574907651937686e-01,
 0.258270173924648346309573945318609e-01,
 0.434224387287242441794269393149628e-01,
-0.194892170517566734253060641367982e-01,
-0.451684081451394481960254905700317e-01,
 0.127069020542043024184102792405031e-01,
 0.456141012143857451045693708733368e-01,
-0.566236075223398088305431206187988e-02,
-0.446521549541233110843209837226504e-01,
-0.145680894036445062127688288619441e-02,
 0.421609380253932603212705595534997e-01,
 0.845818106029629377522164914734803e-02,
-0.379665003141887023178258441304533e-01,
-0.151363584531265452041562397382187e-01,
 0.317523454596314583746448742865381e-01,
 0.212293171622796341830689974679215e-01,
-0.228126363274744507524469348694142e-01,
-0.261955398004027405446113590737455e-01,
 0.921207850254291840217485826959747e-02,
 0.276667863375701125900219726264414e-01,
 0.161433434310755645036376265583821e-01,
 0.305444551027648850431862129543939e-02,
 0.637829690425869312411040939929699e-04,
 0.352357355908811245863680709794670e-01,
 0.354422931212296545544099608579799e-01,
-0.347510430537496844814399077354652e-01,
-0.354067031889004946028725288067935e-01,
 0.339487540448769673846874759773299e-01,
 0.351633786519024875238840876414790e-01,
-0.327830231986257436399078122121240e-01,
-0.347464741339645255153873851362503e-01,
 0.311968426135012484150497605372444e-01,
 0.341907706018212976309940536369747e-01,
-0.291136317451551844845565458132671e-01,
-0.335319030809819877579999522365615e-01,
 0.264212769157992333243811846400356e-01,
 0.328046681010731445438662222752283e-01,
-0.229389793631212360587865978199332e-01,
-0.320342603467800317458862039721576e-01,
 0.183399535568192252553293048700548e-01,
 0.311977186287931609671113198228286e-01,
-0.119407310732736551161969018896134e-01,
-0.300316684959728268455164905442946e-01,
 0.198400651394796546726991242809331e-02,
 0.266918064025206563708036592847101e-01,
 0.177115884237736365288769687907178e-01,
 0.354682102948161878986890393605576e-02,
 0.760308167551812155489758948259054e-04,
-0.342295110322553839751560022451544e-01,
 0.381982215978122432486148273954493e-01,
 0.295542966358232482636777551941446e-01,
-0.412794927183309854713374555425350e-01,
-0.243983310022243857553295263953796e-01,
 0.433447363171409492369978174588896e-01,
 0.190238083204468053062472308156780e-01,
-0.443236577627992560377036240408937e-01,
-0.137213077029491173145469389000496e-01,
 0.442081005905338257560472808590169e-01,
 0.880404622090379015621947298849944e-02,
-0.430532736534321615855568411652285e-01,
-0.460830170022377527597167200562593e-02,
 0.409752211831573496071645885176307e-01,
 0.150874215781293763421628476563531e-02,
-0.381402985932307044107458553444866e-01,
 0.278600870071256681050631749716151e-04,
 0.347274366801292612775638880293164e-01,
 0.726107312107653370917734128207540e-03,
-0.307560211211504787357816783643831e-01,
-0.536223228966543149559925094215218e-02,
 0.249112162928185156014411405846183e-01,
 0.191907774404183547143705751130709e-01,
 0.408347690850924277636716504605370e-02,
 0.899700746351776684149463983607459e-04,
-0.373575463872558789046687835770422e-01,
-0.282151711911156935118893493780249e-01,
 0.439768588404671774803392644347545e-01,
 0.173467887683123619962961293184139e-01,
-0.475493673507372877147557139002142e-01,
-0.572908689552212871969430346178605e-02,
 0.478875110090862954550231803359671e-01,
-0.559576201050508163272319866576986e-02,
-0.451655233027573770313638031421853e-01,
 0.156418002160128935777272811804587e-01,
 0.399064300726725322918551963108274e-01,
-0.235945113273135285161600241103846e-01,
-0.329353353756106122108002317816264e-01,
 0.289055845846939484730435202818982e-01,
 0.253124890901374303424481945514925e-01,
-0.313526831054452254883083826985566e-01,
-0.182758711358941139359700291010233e-01,
 0.310400444596886662614605245298232e-01,
 0.132709341435452552407751953108875e-01,
-0.282429018308437370306984531436437e-01,
-0.123541194447663729145676311774673e-01,
 0.223342223784469936702353825191759e-01,
 0.205386123668033573994794082423912e-01,
 0.466364090055417531133434624685240e-02,
 0.105745565611745511507883896416493e-03,
 0.318557918230503825090412788591190e-01,
-0.434801698288622997116311356243970e-01,
-0.157692309740686666215776760240532e-01,
 0.488180522506223495134714517398284e-01,
-0.216326589232731305035372943185133e-02,
-0.471946180575582093061769196937403e-01,
 0.190545827557478256995813221025202e-01,
 0.392039685103944482812651240465991e-01,
-0.323224283024503487899789486707948e-01,
-0.265661401076897622840800994581016e-01,
 0.402000945807324821653410168041861e-01,
 0.117530703713882638091138111228923e-01,
-0.420784435827060550401987172456189e-01,
 0.253567628267304566125155110269627e-02,
 0.386157468064566120744399841810658e-01,
-0.139324092265472721602113411933679e-01,
-0.316142733391183770858417926647781e-01,
 0.208615321359381274246052345420011e-01,
 0.237565059330646693057963442336430e-01,
-0.227153498015104866791760316611705e-01,
-0.185192241345540772789014462010020e-01,
 0.190077442996257160588846799152473e-01,
 0.217126176265757768753309425653837e-01,
 0.528588853160189492982299993713169e-02,
 0.123506122739068193624684095449822e-03,
 0.393317508266490000246353825232499e-01,
 0.200160968706001423102712091399086e-01,
-0.488777390242806346533279460252562e-01,
 0.395572584975920844714242507941265e-02,
 0.463096203527514486662674198730214e-01,
-0.262433562354651450947996016417684e-01,
-0.327191286525570866314268416465559e-01,
 0.411953239717487825103558855743754e-01,
 0.122137218151748445667634209920979e-01,
-0.455152678634092362864868706000260e-01,
 0.944489402492269860169367334952127e-02,
 0.391421927942139731087725501118354e-01,
-0.266889124725182528288405788571150e-01,
-0.250740484713887842805157551530866e-01,
 0.358731558762956367805740897091511e-01,
 0.822018158917392935231146644841657e-02,
-0.363382514361064770033125089236159e-01,
 0.629799284539936756051581872721168e-02,
 0.305335479625189955604572257482647e-01,
-0.147339441718451658029850409794507e-01,
-0.234224550546348155644395602716799e-01,
 0.150165619622871249367586026919075e-01,
 0.226713953843594283386970274025602e-01,
 0.594811809949093866621929606836420e-02,
 0.143404140282805320082932081248740e-03,
-0.293678704220987777942096384956750e-01,
 0.472160488682042619723759125333234e-01,
 0.483676372323036515696901935770419e-03,
-0.470634367573834909306822025255928e-01,
 0.279784710681106458352058474700843e-01,
 0.293996226045141069584256485122454e-01,
-0.450153417203689477381150061414901e-01,
-0.179093193864165228148850091865019e-02,
 0.447341284012905123915474182396106e-01,
-0.246187155650778656185099702388362e-01,
-0.285937650975414713999428489540515e-01,
 0.400561249622008789133572879860407e-01,
 0.427266315987752888943860706975070e-02,
-0.402001884580480650527997882708266e-01,
 0.181966180503575750702946595071906e-01,
 0.275505993912025310634983861628839e-01,
-0.311265256921508995515996153716901e-01,
-0.958987119591660865137984444731590e-02,
 0.325119352280382316276749796807691e-01,
-0.514494477703701078605454689617248e-02,
-0.267021535770050271837234538978833e-01,
 0.104814357580043752883271856107263e-01,
 0.233759215652329288373386519243021e-01,
 0.664753459827417953837461793397384e-02,
 0.165595097969767335805849032566714e-03,
-0.411512657912778366307734314272102e-01,
-0.111330832564462193937449036062834e-01,
 0.490011939703410158768919798829948e-01,
-0.244543101046370466080725848566299e-01,
-0.306949038908084756774475092922308e-01,
 0.461194001763454403571578354114188e-01,
-0.301266296357237515259365740469549e-02,
-0.427965589897920931027629879373508e-01,
 0.333007254619670005228542617895276e-01,
 0.178288380905968464655855079268802e-01,
-0.444809977454576120311674796259928e-01,
 0.138613376760602181905900982228793e-01,
 0.327185763516155527403197630356958e-01,
-0.352944964453771986412140363361302e-01,
-0.706340268382731741265014892403576e-02,
 0.374303132883805475736190731254382e-01,
-0.173773399728957799648677576552722e-01,
-0.234280914238611988773400558642182e-01,
 0.293483306158755913160618867493711e-01,
 0.500753885068569153320766485537072e-02,
-0.281018939731685992287600788212459e-01,
 0.555520344990230460502104042359762e-02,
 0.237908428019343407758791121209006e-01,
 0.738064312335651027967387073780420e-02,
 0.190237059883478960860224504366016e-03,
 0.267734312082270767922976447013831e-01,
-0.492826428677707741275152044053393e-01,
 0.148143505012033484060907792734946e-01,
 0.363924881506091681980177692105439e-01,
-0.450574096508270783286995705793861e-01,
 0.180241231854494331997614671262621e-02,
 0.426033778628449129929822551879955e-01,
-0.370099304356293888228087130531332e-01,
-0.108520968620059796888180758098639e-01,
 0.446276797953737022853522556893881e-01,
-0.259040780876487967174445133213055e-01,
-0.217108886912664584572272523762527e-01,
 0.419943852342853627288223096942351e-01,
-0.127824939181498493823212254630781e-01,
-0.293568135850158048315464012910740e-01,
 0.344463055966878079206503444235321e-01,
 0.114902096784144873092388157458942e-02,
-0.322511843951734914642383533450288e-01,
 0.215164728406958195763788471424837e-01,
 0.145959997602997772499082030204539e-01,
-0.274951008054730433777324164454782e-01,
 0.416971754148358594438363230899973e-03,
 0.238857329328857331268197869737402e-01,
 0.814325218757345902926009575114626e-02,
 0.217490149559623818348052311812001e-03,
 0.428094808746271102067939138696890e-01,
 0.187694666716981261513199314577061e-02,
-0.443555893607027539163750492902039e-01,
 0.402799614804123702475770285973089e-01,
 0.560087245858987968330194325499019e-02,
-0.448796408697569483717417309133289e-01,
 0.367779423276140644848485823267819e-01,
 0.923854276714925953633381161534243e-02,
-0.443141250812603683166721947695338e-01,
 0.322724825574220636178337630192434e-01,
 0.127460708550781123821727041500308e-01,
-0.425433287150088125922997606040807e-01,
 0.266500737395253971497182362452662e-01,
 0.161058794748614753096123302370717e-01,
-0.393408520205823598821102211967246e-01,
 0.196019611473243666000421771447821e-01,
 0.193494290296618322387837381224696e-01,
-0.341477492208895294945251961964560e-01,
 0.102451344252736076065337975980178e-01,
 0.225376194857332745026282302390309e-01,
-0.249001017809605034684878484346541e-01,
-0.473536754372269840249762460420537e-02,
 0.236362674856784563270994374940612e-01,
 0.893048724498552592598071725231752e-02,
 0.247516002904380898139322920666926e-03,
-0.240811100117260114490307631171790e-01,
 0.496138640643336760805414118224127e-01,
-0.286431708912820493076832064570254e-01,
-0.188556924441824012432318621059830e-01,
 0.481544674630128564361616712340992e-01,
-0.321232195552534449307743357312323e-01,
-0.134481110047028945052823636704068e-01,
 0.453625195819927571807690146113611e-01,
-0.341695473294946911744033664650486e-01,
-0.839937322982645687013719560127294e-02,
 0.414913606184396739047916790818912e-01,
-0.344905741003430634511138369923667e-01,
-0.432625972022637013886811171955843e-02,
 0.369236231218434101035208590150993e-01,
-0.328108214228960272042180397778745e-01,
-0.200068484801826534389957212408016e-02,
 0.321835183935583764166685590807236e-01,
-0.286866998110176408630855540596281e-01,
-0.266930108738552052454098431910167e-02,
 0.279208782802094133387004236224733e-01,
-0.204839694138302580710537655024978e-01,
-0.969396455097447598001993559980941e-02,
 0.230252757266768536069828929443081e-01,
 0.973681457941795992963520482611219e-02,
 0.280477200624925812895806495749512e-03,
-0.443003194800160071565692566014187e-01,
 0.742932448124698678177918124896377e-02,
 0.354076126409601090368793045458310e-01,
-0.484631146741800731768246654585572e-01,
 0.211830886369276549343205008329034e-01,
 0.231675434461547672124799323652995e-01,
-0.474136964381978437621828274972084e-01,
 0.318387012830607845409019930337702e-01,
 0.959884990861651705024449454934716e-02,
-0.416802588807013415749749595759808e-01,
 0.380151421684338112864830943334878e-01,
-0.301146288967563945201934424426034e-02,
-0.327493157442976350047461538100844e-01,
 0.392361930807590973783491441643676e-01,
-0.124925547668750368435250090185465e-01,
-0.229031345887853386595732408594748e-01,
 0.360770669302529834337338650830189e-01,
-0.170265513308393039192761893742531e-01,
-0.151473611942320327958666892925693e-01,
 0.301152884253618744602268011235149e-01,
-0.145544085280977058358068374095167e-01,
-0.142507617432431737191856320674798e-01,
 0.220436323305634320165358800141294e-01,
 0.105560755705005761774252728080138e-01,
 0.316536681924469461934307449913596e-03,
 0.213002871966136479760609551126914e-01,
-0.482032239911107932572663130086839e-01,
 0.396688416395491793441019828458022e-01,
-0.221621712848555627624689102591098e-02,
-0.363602204502183025042735239075208e-01,
 0.477525419809288572304048652126299e-01,
-0.240919601269153643942311562413987e-01,
-0.165281590077487528542071847852493e-01,
 0.439011941768488254184606858011186e-01,
-0.383334997429959125896556663459662e-01,
 0.501065929997600581118996298640263e-02,
 0.305036248406827560748560807739811e-01,
-0.419078504933726393590072037202517e-01,
 0.218701274986759011633900431636464e-01,
 0.130766728505528972763566069271109e-01,
-0.358644653375157084247392492305627e-01,
 0.299293350759972124569295746744280e-01,
-0.167854036113958572387609171749042e-02,
-0.251627750055171741959788022666635e-01,
 0.288504757199418958823219733363179e-01,
-0.753994417546737020148418590982915e-02,
-0.182076819522359832978284815185813e-01,
 0.206909544743155895469801865700520e-01,
 0.113815312030623023042074025160689e-01,
 0.355857141273780350408971283909072e-03,
 0.456182862589682745771305794946173e-01,
-0.164616612406882705566187195413484e-01,
-0.230360217009265386284655555321332e-01,
 0.474842261139671631371500896096822e-01,
-0.413845445541472517415440503788063e-01,
 0.906799127172724002693348348450272e-02,
 0.283318889715454916736201739702125e-01,
-0.467834933725194322776957770916462e-01,
 0.349539829795881229066796869538662e-01,
-0.129696897630604695117223915882551e-02,
-0.318773463565502826364877627994718e-01,
 0.432571408255758299267923979847867e-01,
-0.264037924736102801504020251069185e-01,
-0.646996518572925683820986914414161e-02,
 0.331262994063151779739753330959295e-01,
-0.363775908944838443126048479138102e-01,
 0.154368240043067486936866680060062e-01,
 0.140294398905648518023159020433144e-01,
-0.310754675187744438683434656944019e-01,
 0.242542253720658046195769942261405e-01,
 0.403290775905521317634218067386206e-04,
-0.213867264892281515165039768054356e-01,
 0.189760750972660532499491891033598e-01,
 0.122059165381706936010243620247116e-01,
 0.398600410126858679228240066105703e-03,
-0.184409399961946635920708865211104e-01,
 0.451041645664565457603851895701909e-01,
-0.468322245726576096001661769995606e-01,
 0.228422380470995098011726544837656e-01,
 0.133553443456857532571201774548289e-01,
-0.416200206397117008243136368831600e-01,
 0.464996188162330505119677776348621e-01,
-0.257953206225309924431963494456810e-01,
-0.842833714146284949326102647276002e-02,
 0.368687322849020726116560174178870e-01,
-0.439661337295382533970589428640528e-01,
 0.265620761829171397914762493630212e-01,
 0.464414879925879153578388455270124e-02,
-0.315502036711384013023657175410838e-01,
 0.391920041217532290813835306362413e-01,
-0.242494606145601613520356097446897e-01,
-0.336480689663198074484047025510744e-02,
 0.266740177154974321257547342088080e-01,
-0.319056098998382041776290220551978e-01,
 0.168438827228424304504581680421568e-01,
 0.761524825780912583083903242035310e-02,
-0.236394427128809490131415709976209e-01,
 0.169172690624623246946033197736031e-01,
 0.130215047178671759556493288370568e-01,
 0.444926825500007889392539673825986e-03,
-0.467585049215719512353256771224798e-01,
 0.249060666790941131482228017920113e-01,
 0.844613533014658962947862867653702e-02,
-0.375512939824051767410591541347271e-01,
 0.487913566798036960556567075199743e-01,
-0.371382642002660124218676808187053e-01,
 0.845419633040871297383486796662074e-02,
 0.234435287828922535160431308181545e-01,
-0.434920928383638046463845065019284e-01,
 0.425944597105162025377034619987438e-01,
-0.218471301015040190175528904999503e-01,
-0.821927516750668391678689584366934e-02,
 0.329466588553714031419144737445303e-01,
-0.407549091564892206315490199157977e-01,
 0.287005245006496392519931486279913e-01,
-0.368635959503167173650353526123985e-02,
-0.212192713590437368211150209983232e-01,
 0.334857983644930511909737996428546e-01,
-0.275019421039286154783546400908616e-01,
 0.747109040566173191410851067672832e-02,
 0.146053801720083726896112779634346e-01,
-0.248552365776287196088575316747149e-01,
 0.145422158388460751413007255310573e-01,
 0.138201799327267937782024681494720e-01,
 0.494994587380719844708976102115049e-03,
 0.155135303953344981991165708713220e-01,
-0.404282663737143825733720979721250e-01,
 0.494495574425106403448420207706658e-01,
-0.391394936002162824995042123871986e-01,
 0.137427642040462661844695415007988e-01,
 0.165658921989933082828991955839361e-01,
-0.398026151627528635160458386436147e-01,
 0.469833452447933424673978550591974e-01,
-0.356713340357074611716316304757123e-01,
 0.108398912296040948033088274414808e-01,
 0.172699627792775144024646027727304e-01,
-0.373906733618123025482634218243716e-01,
 0.418139268246704419339737623442009e-01,
-0.294424887538416337442133926592107e-01,
 0.607578535035548736236944101407822e-02,
 0.181558632327219724332867394807685e-01,
-0.331192932301644439927970153714358e-01,
 0.329618205149298447099849819114064e-01,
-0.185745683971935807471740199969753e-01,
-0.277443067752131216142633022394472e-02,
 0.204686312949114147272304108603631e-01,
-0.249680513237793415601927494590654e-01,
 0.118876899022726165065499644314431e-01,
 0.145935186437359472413850011160254e-01,
 0.548959106975317599401798860366477e-03,
 0.477167488154464244039076469950538e-01,
-0.324694336565978005544214273331344e-01,
 0.694671187714463977976496620592641e-02,
 0.205536864450190239687645033180219e-01,
-0.411499110456862597275804347900300e-01,
 0.482975416739571140699267681342205e-01,
-0.399177846450613431269911449322655e-01,
 0.190283388659922516890086838631541e-01,
 0.732246668402718271004163899985148e-02,
-0.304481908617363421169319261317527e-01,
 0.429309548107605951355328959601111e-01,
-0.410629560624305894487214634698546e-01,
 0.260073962554082019834634710980799e-01,
-0.330124332118075934599439275747132e-02,
-0.191150796539126365743789064516097e-01,
 0.336593103139739461816348455786674e-01,
-0.357156368998595011964138389955067e-01,
 0.252040523147942754331268365007651e-01,
-0.658478024862475159337675614406324e-02,
-0.126912030622327318761061696712358e-01,
 0.247439369570487063689301518683552e-01,
-0.239610066952680190696539560545497e-01,
 0.899897810433619877903751223996846e-02,
 0.153328782195526571780507023845122e-01,
 0.606972347841974069244918910540111e-03,
-0.125289149167421160154920709157454e-01,
 0.343414134596993779225696764537825e-01,
-0.472769210905947826300118970395267e-01,
 0.480501887641360251091800774234727e-01,
-0.365803860815461214230559514461408e-01,
 0.159911418888667067992834530952203e-01,
 0.824412102130933028353355229387965e-02,
-0.297778098571338009180723747999867e-01,
 0.430843613418481071843400518989473e-01,
-0.449189162109703243433360035634192e-01,
 0.351469585302900397882701882575588e-01,
-0.167258721913753600277218226036570e-01,
-0.514948787780451881058255867579567e-02,
 0.244983286177470199707257988976248e-01,
-0.362029509953289164205925991842615e-01,
 0.374045591915246974983143966462466e-01,
-0.282671811913502487828814505221982e-01,
 0.119062287463725570233897439359786e-01,
 0.649154001817672482261851446327255e-02,
-0.211076532532746913443158459587515e-01,
 0.270893637047419233529974730163069e-01,
-0.218686905166488786655079072018887e-01,
 0.592903154095758115266345799571574e-02,
 0.160294920288357422132365624269745e-01,
 0.669182161988358640801755393232001e-03,
-0.484894657389676031282073707987984e-01,
 0.388896471067815612654244182858801e-01,
-0.216535597691613022347827038147149e-01,
 0.297938720989188492932235501465139e-03,
 0.208412765521881617736549552915021e-01,
-0.375114764152556255156892612558429e-01,
 0.464240381370345503999003026391950e-01,
-0.459277372371928530637946160084144e-01,
 0.363339150973818987986838969686635e-01,
-0.198265917689642481937967541763095e-01,
-0.211127139668957609185551480539165e-04,
 0.190195107156810162608692232285301e-01,
-0.332582578728912314839509137804811e-01,
 0.399346736026358246166843834850261e-01,
-0.379388832071572481666546890667472e-01,
 0.280729795964653398618452845231841e-01,
-0.128602618800969535178991847453488e-01,
-0.401131434941625702205024593255951e-02,
 0.184888098245923448889680308551136e-01,
-0.270221863052248573533299533481018e-01,
 0.273113398066927520442651843691625e-01,
-0.187769113263774343795786181444491e-01,
 0.273736771587191925026419807107993e-02,
 0.166745699167463176705368062140970e-01,
 0.735731623040591652795251756053700e-03,
 0.949826822592048143164295671860388e-02,
-0.270580583255213472946753857576455e-01,
 0.405324732359436107706885934198566e-01,
-0.479116727864938775929902347971152e-01,
 0.481368609064043055172841800282809e-01,
-0.412613005258135177275537856675335e-01,
 0.284347473101315928717409924603255e-01,
-0.117142314288740044628761034256445e-01,
-0.626811831434649787405104573251594e-02,
 0.227267136972787674926458286696270e-01,
-0.351659395450134900374873083698899e-01,
 0.417744268387118654555106144639706e-01,
-0.417073397608126318182237106329354e-01,
 0.352120644056454814802461575416707e-01,
-0.235780503457455891865205013448218e-01,
 0.891998711789572246671901652604108e-02,
 0.616956429138984550042866307350514e-02,
-0.190408160972079899009547410374911e-01,
 0.274113847927737728796130773938175e-01,
-0.297246417678282502728362104244490e-01,
 0.253823989686045384766948112780462e-01,
-0.148198510678407329423241588531453e-01,
-0.511253218136247563448123956610819e-03,
 0.172594028965578642140635084601175e-01,
 0.806758358612264698027577081127814e-03,
 0.490737979076210528210966959666388e-01,
-0.439446170085197486370763603497916e-01,
 0.342549767799395569799074256055292e-01,
-0.210773981033696461044073529955003e-01,
 0.586583454593800696701711430377250e-02,
 0.971004768205451861472033001991059e-02,
-0.239548686907129970569443602199567e-01,
 0.353399603150153670976358408333609e-01,
-0.426761137856518303325803313365420e-01,
 0.452468484769796133439851039978122e-01,
-0.428869911333982618510897991244229e-01,
 0.359977018341284063633258194409412e-01,
-0.254964524569271933982640190478844e-01,
 0.127080053321078521903215830572400e-01,
 0.790712890819527127713699052029513e-03,
-0.133535755103095648118173095517653e-01,
 0.234544962324819718367518530805490e-01,
-0.298605097823115439876970969937417e-01,
 0.317678532491153941274160710088580e-01,
-0.288840947661626061592343906791767e-01,
 0.214457299042214835069232065256268e-01,
-0.101746937341668769783093840363891e-01,
-0.374834689678783614340776302551189e-02,
 0.177754708030344153244657643252481e-01,
 0.882393884018889039686491970165558e-03,
-0.643301564770136180003699602046350e-02,
 0.188337928594190993548055461266243e-01,
-0.298743752490448750167271665198568e-01,
 0.387637733120119132855378482969635e-01,
-0.448752933543533460507856997627546e-01,
 0.477941798332547667640921944311982e-01,
-0.473488802765605298517215542126518e-01,
 0.436235313387826141071900596594326e-01,
-0.369507253204929028344942184582291e-01,
 0.278851509774681399438696803062958e-01,
-0.171601918868574213495764654441521e-01,
 0.563089515349103428903845460560892e-02,
 0.579220886731329297362664057886147e-02,
-0.162132289305581163959655434045620e-01,
 0.248194370002412991997774615520549e-01,
-0.309427292968503006457968497574208e-01,
 0.341090206839248999710467239785773e-01,
-0.340713496134959628329126518247380e-01,
 0.308234693883404912531420288384202e-01,
-0.245918550709446371609214524005167e-01,
 0.158058963962803470752884647938584e-01,
-0.505394199632851254168870320855125e-02,
-0.690337992341787744546957696004789e-02,
 0.182145515851583555413135470978303e-01,
 0.962762939494160963351252232963948e-03,
-0.494675976629330933190645879905222e-01,
 0.474599266477311557856290528775258e-01,
-0.435372618534607717695260672417265e-01,
 0.378806106617962625758843766193744e-01,
-0.307508221784003050732778766481529e-01,
 0.224763593696013080844218756026807e-01,
-0.134379109865730102543439881564051e-01,
 0.405057282079266153449462507389820e-02,
 0.525555577056184522027893792650284e-02,
-0.140554368331295106899145263533520e-01,
 0.219488619750546528583472433597498e-01,
-0.285789733724308044451845303519541e-01,
 0.336486364019781261920966614423010e-01,
-0.369338480653419216772289369173397e-01,
 0.382934783327352086368892302466483e-01,
-0.376747683138176553593818594331354e-01,
 0.351141285227640583121785472972887e-01,
-0.307328606250763470161551165689540e-01,
 0.247274281745676774711763868507183e-01,
-0.173538462381495771376113350942719e-01,
 0.890624012825803121473273430515316e-02,
 0.304238238228528093238638499448623e-03,
-0.990555814580008223532562354474329e-02,
 0.185688308630331480336713630931878e-01,
 0.104798283306979655145212701522172e-02,
 0.334477156215561607836121244281283e-02,
-0.995648740196188823810633099607422e-02,
 0.163365870647130591681418720290431e-01,
-0.223368328013597929763097622782309e-01,
 0.278180868294757511692820122932078e-01,
-0.326536357560031138747436089431326e-01,
 0.367322077114653216317935418258472e-01,
-0.399606058314954223852235883130222e-01,
 0.422658895829543474389384461149418e-01,
-0.435970441718927146457276325236748e-01,
 0.439260872272566298043273323050798e-01,
-0.432485701459288462368750641523884e-01,
 0.415834373907117289867804022901568e-01,
-0.389722081783260816691439477073692e-01,
 0.354774371634865010958961166446059e-01,
-0.311803864918597336432864471626754e-01,
 0.261777877674262073203666983679827e-01,
-0.205774667888202767206463647260673e-01,
 0.144924179693422426949773032304555e-01,
-0.803267612637255376805722737982655e-02,
 0.129460495725692819263271279819193e-02,
 0.564719283432927109563682491148273e-02,
-0.126856798612731911205441666206414e-01,
 0.188310103382741226509119840138102e-01,
 0.113816279128032279032537068501945e-02,
 0.496694393110537824511080233326038e-01,
-0.493148296631736109673357342641015e-01,
 0.486086583876910182225500577498846e-01,
-0.475569891755617768332720636834423e-01,
 0.461688364449923503000083732267981e-01,
-0.444560672480669970545894943328064e-01,
 0.424332690113153875374668887106038e-01,
-0.401175813765951082512532825835586e-01,
 0.375284892710911518199589768626551e-01,
-0.346875725223288448202540353949942e-01,
 0.316182044295996633866032715192010e-01,
-0.283451870083365494634484573951824e-01,
 0.248943029358678224644365417356864e-01,
-0.212917514273698526717807359491136e-01,
 0.175634135559422794694684251553238e-01,
-0.137338549848947357005051350078446e-01,
 0.982490820338818383905035118501573e-02,
-0.585356084618838462115809556229985e-02,
 0.182868406996322177429720493623311e-02,
 0.225411079303906446756733133602030e-02,
-0.641997039090524540268310826494639e-02,
 0.107199307503377373149195374604027e-01,
-0.151780025972622211112027764839224e-01,
 0.189944136296394949975784198527348e-01,
 0.123340331984806900991947023514136e-02,
 0.562939132710922119472747581229162e-01,
 0.552006031084638814131059989386977e-01,
 0.534192804721846147555085348958318e-01,
 0.510091782030557202215405212837115e-01,
 0.480492255335845242855370740536774e-01,
 0.446343248983712455795410713706686e-01,
 0.408709368149682504448922709820805e-01,
 0.368722198538142627867620272765820e-01,
 0.327529947362129338854845460876991e-01,
 0.286248072443938618835280086677163e-01,
 0.245913536655696955112045090464142e-01,
 0.207445057397412488519038884731914e-01,
 0.171611313495109173003502567680178e-01,
 0.139008551643636682523264297232833e-01,
 0.110048435158988736898163110006877e-01,
 0.849563379782346548774897740343943e-02,
 0.637796474789257731068828488009144e-02,
 0.464050413624837990578205917156818e-02,
 0.325831841753761110901441446692893e-02,
 0.219588802724422735572518973235940e-02,
 0.141044469724398619214415965031741e-02,
 0.855395012994875847706785911161219e-03,
 0.483598018139619668036406265552556e-03,
 0.250283543509576534330621367866219e-03,
 0.115430651384912317151987759548424e-03,
 0.454697990360929643012118484389727e-04,
 0.142249537683940941093760518630853e-04,
 0.306931488100928557039890783341552e-05,
 0.326600071378050562967313398997688e-06,
 0.508142220212763281848034871032717e-08,
 0.953299342670065366325541930725661e-02,
 0.186713100228471941389784835011375e-01,
 0.270442410476213135645648668888929e-01,
 0.343272326688183887297537588530842e-01,
 0.402606582716432745889566269685087e-01,
 0.446638260238152647074457325036699e-01,
 0.474432645140380201519125630309831e-01,
 0.485947978398322820283639599194836e-01,
 0.481994245753787690867728027532349e-01,
 0.464135088243379318582587817192727e-01,
 0.434542334682868455057224420568886e-01,
 0.395816181849848606799252580080441e-01,
 0.350786386258353573026714966540344e-01,
 0.302310800406846398734116993561169e-01,
 0.253087128476163671638658423375030e-01,
 0.205491962911310443327143358221288e-01,
 0.161458186556344012985528290316473e-01,
 0.122397979703153816028111037708150e-01,
 0.891743263292502935493790455764494e-02,
 0.621194769978464348047767395329840e-02,
 0.410947065783752775558375573526039e-02,
 0.255822755104781705500057324839346e-02,
 0.147980651432033266825389345696189e-02,
 0.781211374799756860745219968329983e-03,
 0.366431688853003098707471693342866e-03,
 0.146383757269438269771283231860846e-03,
 0.463143298823881448884193656639562e-04,
 0.100791566046525737195053022265197e-04,
 0.107884953995967592864025533126950e-05,
 0.168402882421252391460763017240943e-07,
-0.440840749156811882678372235199446e-01,
-0.394124533678662901582300162350448e-01,
-0.320295470818712383470363619906685e-01,
-0.225003577614611169065655545448484e-01,
-0.115408334724428090453674787052112e-01,
 0.475848558853983461488677124723607e-04,
 0.114496402442750610750985758727999e-01,
 0.219068065985180079434457985832686e-01,
 0.307796453473420340798788900085263e-01,
 0.375959823007709946584819567692976e-01,
 0.420806273412449565439071790435782e-01,
 0.441645021055781077594233744253400e-01,
 0.439733556604796299799233785639458e-01,
 0.417984615328212030162710592967074e-01,
 0.380535453038266216605727288568510e-01,
 0.332234828821604584907483097820632e-01,
 0.278109011658601658258089155046450e-01,
 0.222866589100456006240779822824059e-01,
 0.170493322443354366342538354560808e-01,
 0.123974070972632361999474111183432e-01,
 0.851608712486805873599351958590751e-02,
 0.547869854763779392008650882647017e-02,
 0.326086032293148769486960858143271e-02,
 0.176411530451187615399428837255731e-02,
 0.844761346916270036484685587918647e-03,
 0.343284930107412198107998607785022e-03,
 0.110104321761061508542409106507285e-03,
 0.242102187935272287827710917335873e-04,
 0.260986217024145500976481574513070e-05,
 0.408988670182126529169278095117090e-07,
-0.141379480592024649764236247440546e-01,
-0.267446801070570584146735079815469e-01,
-0.364704648435550117347419854686936e-01,
-0.423045537682660071144316269419416e-01,
-0.436881404538516492091785900829438e-01,
-0.405685786633395876946597739177002e-01,
-0.333889654080644202029747010431191e-01,
-0.230162168369880532996231884194379e-01,
-0.106191601449187997959743779310129e-01,
 0.248529370263817877800066606602704e-02,
 0.149960703520572672769082718474442e-01,
 0.257796257776942788970900342196881e-01,
 0.339898470641420769246733225466986e-01,
 0.391420792266647866973597425970553e-01,
 0.411344938242566184279909038097648e-01,
 0.402179513809545069322313942445584e-01,
 0.369228514605766998168773431540630e-01,
 0.319571120876055610085437069055397e-01,
 0.260925796139432628287533677049714e-01,
 0.200574698412510870109326825385037e-01,
 0.144499803940147888237363875161533e-01,
 0.968353246454543336999288822503412e-02,
 0.596807562442807917430532551860240e-02,
 0.332558542663792444126528774784230e-02,
 0.163236605750053650927242515326379e-02,
 0.676930512391982579044941571226489e-03,
 0.220640107879740507707519376692567e-03,
 0.491071890544832967229299798438034e-04,
 0.533790491484069949055845499538138e-05,
 0.840341593395305138075088598526623e-07,
 0.401356549697553819476681976278225e-01,
 0.310832754909431542019192014914633e-01,
 0.175383444981360896766669310091426e-01,
 0.154955122202456127177954187934727e-02,
-0.144969063280316784265605214041701e-01,
-0.282568589209450847724667112744105e-01,
-0.377912216825542952262151083312685e-01,
-0.418518544691170610548120823166771e-01,
-0.400446407589452952540383524738999e-01,
-0.328471413616096432838356268517255e-01,
-0.214844954070014471739975069491420e-01,
-0.769194968650653057619761753151741e-02,
 0.658904813252946758129066563406343e-02,
 0.195250976117402576314718285956173e-01,
 0.296609146122385716466972732285486e-01,
 0.361022371334318390886402974554584e-01,
 0.385874138770700782602651116729417e-01,
 0.374456689102821480804665484729077e-01,
 0.334610472118444735695346681608118e-01,
 0.276768962265069778874968092526097e-01,
 0.211836227057816806980512508503189e-01,
 0.149313169045574674371296708341168e-01,
 0.959948063799438462512363632730145e-02,
 0.554099794424310133883090995630134e-02,
 0.280017843943406882871849753153820e-02,
 0.118899765217949754431507261835290e-02,
 0.394833332533222560653634338664719e-03,
 0.891122695724517488701221051343331e-04,
 0.977912767689485840249364080729629e-05,
 0.154761770556221718029992564485864e-06,
 0.182417707004888739347846141494466e-01,
 0.329327197041045383515469645969984e-01,
 0.412403045811227469866358526793574e-01,
 0.416158508864361950317555332913663e-01,
 0.340888260634332364148366187073023e-01,
 0.202314010418174106771254190916489e-01,
 0.280736767518947502550896093597838e-02,
-0.148124343753464572597393203042976e-01,
-0.293377008184029427118208932228390e-01,
-0.382007428678283425122402615863669e-01,
-0.400201067372374906138067846575371e-01,
-0.347973394444413261264545972953523e-01,
-0.238208937465249497690996298859002e-01,
-0.931639739314029508273361429818204e-02,
 0.606450655904754972088409600356984e-02,
 0.197954323201679815697649912345439e-01,
 0.299455736851540963064045019421767e-01,
 0.354759006194196157342044890237067e-01,
 0.363153415068576263666031633671510e-01,
 0.332252846664494086086206218999906e-01,
 0.275084377637094466599096568906777e-01,
 0.206481939002401271146709167321348e-01,
 0.139711066465227931009579041602848e-01,
 0.840810271463142850362985722697955e-02,
 0.439581113530497123426169575575850e-02,
 0.191806365303867158046084956048934e-02,
 0.650632814565652348536796629415328e-03,
 0.149189598576143133173410972170716e-03,
 0.165490867337350227367141440723541e-04,
 0.263453814642389561239329011663706e-06,
-0.372103734230214273510563421824083e-01,
-0.230699156188854548589768873609629e-01,
-0.342726405745599676093754389727073e-02,
 0.168884851960987660066183333026882e-01,
 0.329431997014775154361952886225143e-01,
 0.409299373136045440167864896126573e-01,
 0.390896475858694111398054713264278e-01,
 0.280899889545039305618062867081012e-01,
 0.107808141667476904754590849010250e-01,
-0.858838354827299218616048898966938e-02,
-0.254653817984866637861685201203375e-01,
-0.361098145872271070184055419011748e-01,
-0.384387723262589238133949275193070e-01,
-0.324036019244494001885965740481969e-01,
-0.198342570272546550910229759533578e-01,
-0.383283970281333600374657521485912e-02,
 0.120884858540801771373598560268845e-01,
 0.248780250839138838231106536361642e-01,
 0.325964762547605953144577400084153e-01,
 0.347047031578141906625762031814938e-01,
 0.319568591765269693600566969707838e-01,
 0.259811065241042215590338334152009e-01,
 0.187078922528916250541474665727102e-01,
 0.118284637756442499093933422193050e-01,
 0.643211863001453733148239479726945e-02,
 0.289525782866340725838910784961515e-02,
 0.100601200379177160958598655456248e-02,
 0.234813254503072939980730734628218e-03,
 0.263617321876126417383664737959660e-04,
 0.422435968474572629300176026371984e-06,
-0.220263087527815937695735842921703e-01,
-0.374547009989416789625790839470575e-01,
-0.417059546016990083631912136611345e-01,
-0.336038867900622740008116436882195e-01,
-0.156960741672474329764749581625064e-01,
 0.657625283801965403808142093772163e-02,
 0.265803003730466672484956596767603e-01,
 0.385167047154534491885015690247450e-01,
 0.391302290744690795673217126585689e-01,
 0.285874833944120919350750129780528e-01,
 0.102838492842231511815269000466082e-01,
-0.103116881952993988973306160413698e-01,
-0.273682079488028452238175832635307e-01,
-0.364028256788569275212666481400332e-01,
-0.354654482217251514137185816691341e-01,
-0.254755463617025069045960487223280e-01,
-0.967956459336757417607074334117332e-02,
 0.752211210860601836325438605755024e-02,
 0.219525259025586699109284933366043e-01,
 0.307910745874733686850288677919644e-01,
 0.331404794692388917417332639575992e-01,
 0.299277391159184071615118643096090e-01,
 0.232705298206014778051036408807756e-01,
 0.156009307065078950089947847799556e-01,
 0.887824382448205619595689646225180e-02,
 0.413999856894408460659912934175743e-02,
 0.147784126329330114547383570497381e-02,
 0.351825859448785108091761041818881e-03,
 0.400263328301608908716655083861953e-04,
 0.646070999963526232923684897344002e-06,
 0.343880806684997478257318056911656e-01,
 0.147019733556676709811207473919648e-01,
-0.101061033000768996782273449765403e-01,
-0.311408880993709126409167131682410e-01,
-0.409594783081308502636266099438211e-01,
-0.362421354199980046796492351604924e-01,
-0.189113224462414567599741799735552e-01,
 0.468049760785018037455838884856344e-02,
 0.261452561518986149690113077733367e-01,
 0.381088670819489267004237527860600e-01,
 0.367780169768088194701733118419861e-01,
 0.231107411782484104558476219046838e-01,
 0.223566983887118014858837720932581e-02,
-0.185701447798821955234851113040358e-01,
-0.325219333754748536579400741837519e-01,
-0.355904790542815626400035455446980e-01,
-0.276050686826395717980295801729833e-01,
-0.119058599304055556129314179566937e-01,
 0.618178265668607991371353411846968e-02,
 0.213684845409129679302713328251899e-01,
 0.301249760381833236936876589514349e-01,
 0.315229170029014527139832021910312e-01,
 0.270176585220698030078521834060142e-01,
 0.194295238595764955104867281197459e-01,
 0.116544440000641937540553002299129e-01,
 0.565618580718514245155811407607879e-02,
 0.208070396590450515505523669772636e-02,
 0.506272172801223718821784020282379e-03,
 0.584424680829399547272891576561200e-04,
 0.950830430945677418286962383268106e-06,
 0.255162069093645103566312298076241e-01,
 0.402672319357337612023464090719034e-01,
 0.380907527467885640547795784397395e-01,
 0.200298816037640742199152670301067e-01,
-0.618001626042204372302224694355513e-02,
-0.294844528878173185816006210970048e-01,
-0.402437562210479414598693992835513e-01,
-0.342638282515972227340452521257790e-01,
-0.144118532474798347481421822527407e-01,
 0.108020798286283865446041542320911e-01,
 0.309660084222642542331905429755410e-01,
 0.381453158624364984049896601942579e-01,
 0.300162227733450334526002473595517e-01,
 0.104992243106993236227833696948545e-01,
-0.122200685290588634532144363702501e-01,
-0.292718774349454187468424559187807e-01,
-0.346639267085550020218881605269171e-01,
-0.273419511751200501325560783687754e-01,
-0.110406826598010103435676578306873e-01,
 0.776836942909484480471212889249304e-02,
 0.227436341188289576325831145916468e-01,
 0.300460887108694483516593607305816e-01,
 0.292961013081973390686401871581395e-01,
 0.229461613638868674361123571113495e-01,
 0.146316405736040795781201467545006e-01,
 0.742919356048159667555612133052597e-02,
 0.282571743549224538676428466764487e-02,
 0.704212263427801205989647669558862e-03,
 0.825931805421927675818565483449814e-04,
 0.135535511517782233510298404195317e-05,
-0.314292490189039975248993880206909e-01,
-0.603362457545707087015672748511208e-02,
 0.221618662795084049336532568848603e-01,
 0.393986446415778041954165737749285e-01,
 0.374153915782951324064412562979020e-01,
 0.174339410238932940424806379930053e-01,
-0.105984777144704646566178261240963e-01,
-0.330447627573373385873623027783527e-01,
-0.392986189656096968595391815615883e-01,
-0.268268495825895908002746234109955e-01,
-0.210978240089371555153857378454269e-02,
 0.228215032907817037048257767282639e-01,
 0.363634923577710154975560601182187e-01,
 0.327984790075000106606822752094113e-01,
 0.146205654588474259815892256504160e-01,
-0.918391652030518112805262514696951e-02,
-0.277716817622640687605199138691994e-01,
-0.335287755582038619548204242924856e-01,
-0.251399732049383813205171887056869e-01,
-0.739876890608679128621891795977372e-02,
 0.117580301906823449730390294518798e-01,
 0.252063588511492806416635178690416e-01,
 0.295460909313813044305114152683204e-01,
 0.257465691914875346232394599288811e-01,
 0.176361892038406328540035665595862e-01,
 0.942396188477203844369352743539187e-02,
 0.371942083019117003114063317399629e-02,
 0.951519307059370176487372429631492e-03,
 0.113536384472406755546571417142725e-03,
 0.188050523235505920555666022079911e-05,
-0.287015936336532447476554053394267e-01,
-0.413180263890785410005656583501768e-01,
-0.308614655588295181583970623039783e-01,
-0.333785051705971121679974521343571e-02,
 0.257498930275266258544252140052653e-01,
 0.402286042143686588482298152822088e-01,
 0.323251590597309062796013261753598e-01,
 0.683852390104855675687450832646430e-02,
-0.218329902328286226137309014542879e-01,
-0.379424236878297393773371820573339e-01,
-0.331239641699200718552525824705485e-01,
-0.107019475266911246146079430617960e-01,
 0.166325130624745422613004279335542e-01,
 0.341637950073517920318083416902001e-01,
 0.331778593665775132522986457398104e-01,
 0.152168965762215630553026575994594e-01,
-0.949343663096661392418035321700105e-02,
-0.281126327544344704017558756073076e-01,
-0.320461809202551171249817236258365e-01,
-0.208133096396603459115462494818571e-01,
-0.119359272768533144950618455407365e-02,
 0.172624675630545967183919976422023e-01,
 0.274046390585380871063206553966948e-01,
 0.274357491759059826868289551588930e-01,
 0.204598514839284903968718286583417e-01,
 0.115844207243346136814722360154860e-01,
 0.476279075599727892424301499107140e-02,
 0.125366748304186660930712029639631e-02,
 0.152394635797756601795656254162935e-03,
 0.254940006360630948156564715014234e-05,
 0.282610937092649089035799469415495e-01,
-0.269348717639581009924573496278656e-02,
-0.317872224733731900682086082680929e-01,
-0.406182034301037730080536101743838e-01,
-0.238147497425321928659297830386842e-01,
 0.770379774357703031115925509005047e-02,
 0.339084467180225621901106480285992e-01,
 0.385052007538215572598807094374869e-01,
 0.191198978510538689788549770029425e-01,
-0.115916645943500607428437122258094e-01,
-0.343355465898340819092234303519732e-01,
-0.354292567994793689839800574948054e-01,
-0.150348935008446502370424692008521e-01,
 0.136005520511385065043693228715163e-01,
 0.329432174369322989007155525116921e-01,
 0.320541512931620085913819544311270e-01,
 0.126855098701926738522333955420458e-01,
-0.127812602329774853875913242010625e-01,
-0.295697666047184935573804628234872e-01,
-0.292865331418995642876750108414265e-01,
-0.138695142337268946508440165530941e-01,
 0.704541417192031357304016280123793e-02,
 0.227891196301695685800339593596215e-01,
 0.276777978010554912709504138023440e-01,
 0.228744132212495335941753735678161e-01,
 0.138343929490855429593905688911519e-01,
 0.595044147219727763016807084719783e-02,
 0.161551577580604959241754552046804e-02,
 0.200343381862479341778050123065352e-03,
 0.338744783303877926486407615609574e-05,
 0.315626070248029657530051723693736e-01,
 0.405989359348923468536705747484755e-01,
 0.207661032475268514719928544778882e-01,
-0.136267353944740950225816577200981e-01,
-0.380291163400792413580781805417504e-01,
-0.352977398862052988825562340189738e-01,
-0.779386332922750334083945740825937e-02,
 0.246588953615009737554140475365310e-01,
 0.392013451944466614412222553666957e-01,
 0.261446283478406323373926267077186e-01,
-0.462719361456472942441623004402053e-02,
-0.312622605901285236347452406227825e-01,
-0.356299456461792577027779974165240e-01,
-0.156929052384731741808774043087960e-01,
 0.139315430916563018886421807995310e-01,
 0.329234134149319952891095205416095e-01,
 0.293739018878348815616069826239629e-01,
 0.710058935201088932103158647525604e-02,
-0.182622042162180146755021145266578e-01,
-0.306448706674394096593343749690125e-01,
-0.238722045497305026706127656931420e-01,
-0.413060108477422721750243684706914e-02,
 0.159450826702824133787893678214139e-01,
 0.262438964712824104544733557794645e-01,
 0.246498885336965060196636677441914e-01,
 0.160800254559517443893964583807560e-01,
 0.727006005338356400745511025893826e-02,
 0.204109369634161887906422649593671e-02,
 0.258597822649358195144177841003790e-03,
 0.442236584723291518575165224660054e-05,
-0.248688856135074195899142785305474e-01,
 0.111751483500113288562966233399803e-01,
 0.381882798376254547122508504272090e-01,
 0.348226155810092791232917293698211e-01,
 0.404048102142391525416816412934639e-02,
-0.295170893929560421725844291586854e-01,
-0.393965960236284449722789059342389e-01,
-0.182934900427043091744226336554027e-01,
 0.166054982887428648295927864614498e-01,
 0.377645053159965863978569965969537e-01,
 0.291738604978956389451920155292720e-01,
-0.155928046225171303773785494778953e-02,
-0.300389971580824982531186897116551e-01,
-0.346581526608448983111962611728557e-01,
-0.130325986807903685046227430822133e-01,
 0.172795683021778037316128102137022e-01,
 0.333268588820438593337044982652425e-01,
 0.243204703158693984478984517145280e-01,
-0.142231742261988121845809152894599e-02,
-0.244011368349249971824214634423526e-01,
-0.291752273971163071033557296674383e-01,
-0.146610043427308276283672654840830e-01,
 0.744710736865858353853886020236971e-02,
 0.230520861050954024327832680959108e-01,
 0.255748238747164696245968623255463e-01,
 0.182136917855424865363884838855686e-01,
 0.870211800832901686894579274877263e-02,
 0.253339501493817443079701944412700e-02,
 0.328398528437636136038516500554899e-03,
 0.568419112934857013554962231497950e-05,
-0.340770395548842169051468558934548e-01,
-0.381620521133001240937455326070323e-01,
-0.879027121744223741229444425117036e-02,
 0.280415163434240587591597255862683e-01,
 0.400174164450850057228769721564327e-01,
 0.169922754092582288527985292977627e-01,
-0.204262897955450937683497839702177e-01,
-0.394611755061968444196658443767347e-01,
-0.240304469650860816952160814432380e-01,
 0.116820054317975850168614550653856e-01,
 0.364036654165000484356149510283204e-01,
 0.293459977770385728143641708119160e-01,
-0.232564398462483804811440401529094e-02,
-0.308258079490313821245902913845179e-01,
-0.323769616891328390558969372946350e-01,
-0.706475536084377066151005522568975e-02,
 0.227263314989084854018799362473046e-01,
 0.324735903382923030852373332308990e-01,
 0.158141759896817747008886831637676e-01,
-0.120004022337467188656131491894749e-01,
-0.286070538937489028048457757545422e-01,
-0.229174969393622056728272349379845e-01,
-0.185152390495260151287815301520768e-02,
 0.181930558130900611412806380529993e-01,
 0.254769156237138059235409611031438e-01,
 0.201192041363634526383450309474019e-01,
 0.102198899425508524776471568098657e-01,
 0.309418553188105006813069235100333e-02,
 0.410995971561365535920577143582375e-03,
 0.720528172111390463611537935746365e-05,
 0.212631683136765645065292759058150e-01,
-0.190922549055353536499399646995413e-01,
-0.408415696688297322691564644783859e-01,
-0.231347373119440432563428267148204e-01,
 0.165987992707683171760619296422741e-01,
 0.399132395250521577546700612551904e-01,
 0.247206174264842803684985778225748e-01,
-0.137451095862046322228408100843833e-01,
-0.383264411639069576882687940837420e-01,
-0.260265117131671790396964129580299e-01,
 0.104691836372493345905827880747002e-01,
 0.360068020112550939623726344050208e-01,
 0.270474834616426684842991252956617e-01,
-0.666544176415936407919170756688387e-02,
-0.328088869139600435320484574947781e-01,
-0.277549856273658072164803546098736e-01,
 0.214436471376220115743509113974894e-02,
 0.284324241029782307658545846571996e-01,
 0.280481790046043698898141722743331e-01,
 0.345999652391427621594843040318279e-02,
-0.221715605951835880739632856031171e-01,
-0.275413725864885350951730511985277e-01,
-0.109164550486100200255757291427971e-01,
 0.119375734365883998437239667646501e-01,
 0.242420124689214169838192822483872e-01,
 0.216780739871975251079494297218196e-01,
 0.117897973040948124262672885469789e-01,
 0.372383070555214640829791356284163e-02,
 0.507634141657731866203421920798179e-03,
 0.902030881108189791487562048467225e-05,
 0.362234321616514609878773190259885e-01,
 0.341237242712687507125940889752823e-01,
-0.392384247755146769562190108282328e-02,
-0.375488893846183738426204045787976e-01,
-0.314003365191966359132676843013900e-01,
 0.756675742164467082232161043166859e-02,
 0.380094108190048487636733145108434e-01,
 0.282617752360994174031834157625416e-01,
-0.106510219897291261525568403275356e-01,
-0.375748984112458198708413745333557e-01,
-0.249739062302353098400161216361947e-01,
 0.128999063577242731910138071617340e-01,
 0.362727247716353650065968386048682e-01,
 0.218653979076269019540053768791660e-01,
-0.140200400934627113980370712823439e-01,
-0.341750835862988235326541089547067e-01,
-0.193495118180634732927103564305730e-01,
 0.136412249201634554644853801944566e-01,
 0.313555544539164224351529701321378e-01,
 0.179883235762581211032118137812972e-01,
-0.111172941103716302480291608781599e-01,
-0.277077941129170527874599096852362e-01,
-0.186653865187239838814014392093836e-01,
 0.472321950775780095198505218275902e-02,
 0.218296089291507189847939566165283e-01,
 0.227764755191825858302765081646671e-01,
 0.133720815634483044667360616468441e-01,
 0.442114860926822541429059226780382e-02,
 0.619533424314929258324032235083978e-03,
 0.111662398389537872797261012597314e-04,
-0.174674465206545280984509884884923e-01,
 0.261372249403055031316477832279083e-01,
 0.395565727898857898173532167699997e-01,
 0.760468089829068627389448066672759e-02,
-0.327021079520276508599699683086178e-01,
-0.352055247599665374122056626489805e-01,
 0.237031348450612878976076488998512e-02,
 0.365580591491007972883441069446468e-01,
 0.286539145052126905222517752176434e-01,
-0.113688519843239787210339278534239e-01,
-0.375075939992187270311271104379687e-01,
-0.208573305461570791527607627020489e-01,
 0.184536876992043367170255169915337e-01,
 0.358079934117891192794301377303700e-01,
 0.129872583753189175371251602657670e-01,
-0.229698283215362345598528913005523e-01,
-0.321717993261896148626718114116046e-01,
-0.632681881649463352332328468533262e-02,
 0.246095653021348201329328403790672e-01,
 0.277438860012282022376798515448767e-01,
 0.227646392936433832804770148967978e-02,
-0.233076109516273031581049382587304e-01,
-0.241184556558150078444390687526789e-01,
-0.287947568993719371442968788154052e-02,
 0.182831523550172462502594586448107e-01,
 0.233125006857849007804265001558291e-01,
 0.149217968980097872164923570075675e-01,
 0.518329320457289452012928555341399e-02,
 0.747872932136537121674754505989940e-03,
 0.136823127219533769127134034243149e-04,
-0.379825809053851559277070558305109e-01,
-0.286625521906444256885797468573907e-01,
 0.161783795706290573135605541418226e-01,
 0.406283126604897190952768379045149e-01,
 0.145801615680290673963226899757931e-01,
-0.291233515331554745778250295713093e-01,
-0.362706147681803991576763112513804e-01,
 0.127533528018416208612002929436868e-02,
 0.364509698056767101107631421289174e-01,
 0.262357607153320021072621796141278e-01,
-0.156377623663028806673106820739321e-01,
-0.372455141843588877121922180428677e-01,
-0.131279020387447499183721359056004e-01,
 0.258410223587420133093110293361944e-01,
 0.322853785086877557298783039973557e-01,
 0.112305077390849719192738639276627e-03,
-0.305382758405406513548029656126855e-01,
-0.238380551479809333393301353447388e-01,
 0.992277351297728843548602443728342e-02,
 0.300864591711409854276009350869455e-01,
 0.151620124879983867620794093932071e-01,
-0.150064909702828421154800775329929e-01,
-0.265437679439080627735297370009923e-01,
-0.102188406093513774360223744366630e-01,
 0.137338691495780255340612575493763e-01,
 0.232032539992968811076092543351795e-01,
 0.163900981633031437777945350413526e-01,
 0.600567230832421666207451725486259e-02,
 0.893772484769293377008769831097897e-03,
 0.166100013490852649743180232956782e-04,
 0.135127344605143455766224929298115e-01,
-0.320324543944294280816981351459358e-01,
-0.344990491146169397251398847744413e-01,
 0.912250542726918611699996552291049e-02,
 0.401310813611085804465044125254725e-01,
 0.173424250679277008098730289765552e-01,
-0.281110805141108113023582752273892e-01,
-0.354846208497337611809685161497000e-01,
 0.418061835643243351446482876967960e-02,
 0.373653359285708999902809310970052e-01,
 0.205647977001791943755694276739079e-01,
-0.226218849968695840237318570304983e-01,
-0.348383457671354397930347229824045e-01,
-0.140120414397578243235565734402266e-02,
 0.324282362567179621583505894173711e-01,
 0.231071924956072476028853375586362e-01,
-0.151377309390962092877881919307114e-01,
-0.321257983820837534605676538559827e-01,
-0.797389399792644027452322826490712e-02,
 0.243317746753271997416684430553181e-01,
 0.247375464753468971270461174812320e-01,
-0.416306548891048120859159082407243e-02,
-0.255754725073488572255744293642848e-01,
-0.166268151710963386812287733767257e-01,
 0.839733730650196569937790663614134e-02,
 0.223913223033694423408144270324371e-01,
 0.177257862322429628350646301764173e-01,
 0.688190390563762462170079711879335e-02,
 0.105827444026096611587899507386368e-02,
 0.199929724918025518404090725673446e-04,
 0.393383779476408273588011500243243e-01,
 0.220134094147164392973389738353212e-01,
-0.268280499271914975446850758885833e-01,
-0.368339950498768573239832314134659e-01,
 0.597367215405036016426314530644944e-02,
 0.396905279345132342405774618054835e-01,
 0.163002932060402772691186213888826e-01,
-0.298372587492484735650506993245333e-01,
-0.326532419779170252714735396790522e-01,
 0.107971441097545676272020222683719e-01,
 0.378153945513860531985968594056334e-01,
 0.108413474259125111410125023584085e-01,
-0.303808667437917476653714724673597e-01,
-0.276737625250966109329129599135637e-01,
 0.133000953284775985488694248579697e-01,
 0.340247420219062660697262344500369e-01,
 0.709920593611068317674530033518420e-02,
-0.279418636028239619924935065607350e-01,
-0.232407658071201114280890814767739e-01,
 0.119873295841282973736208034597280e-01,
 0.288761570666082678119046024217851e-01,
 0.738558652079927758402031354007867e-02,
-0.212848359831952118854367256700477e-01,
-0.214897992198410975484253524090905e-01,
 0.256264858267826665795984217427951e-02,
 0.208501716804823119665209558543952e-01,
 0.188770602521889458794066614053951e-01,
 0.780381363522621295264406605291256e-02,
 0.124232558411978640840673359837629e-02,
 0.238770342845221588086905512664882e-04,
-0.943476785287041296391623981367142e-02,
 0.365445552285582882307332840760629e-01,
 0.261779862263334404165612285817152e-01,
-0.242385675289163381900706768576702e-01,
-0.370378220923270261158853803593613e-01,
 0.690866694659707806084947990121878e-02,
 0.396291159437618379845000856251981e-01,
 0.114559596441051569303861288500857e-01,
-0.334970771006867206165905512108272e-01,
-0.266466068720857749893669568194971e-01,
 0.202282745345130121988910486284244e-01,
 0.352218472838759230915056520228873e-01,
-0.308796707508808431315571029694188e-02,
-0.353229004241640484134375549591277e-01,
-0.137330248102115618246355309267772e-01,
 0.271320764319679316885376443287062e-01,
 0.260888327911175735304931986414342e-01,
-0.128751228918328275686616005810334e-01,
-0.308445752200222744883414358705089e-01,
-0.361643074201132856418002089176020e-02,
 0.266227852439002693872467897128341e-01,
 0.176365960923859462693676968988328e-01,
-0.141910595053735541081797543330980e-01,
-0.243176525541809571498630722388453e-01,
-0.342533842665895432059534413035764e-02,
 0.185880700384719308237502858475268e-01,
 0.197934155522617910837207588016438e-01,
 0.876147536509024238209052903413885e-02,
 0.144675928455697614283270874475576e-02,
 0.283100764350763229239949605948260e-04,
-0.402783267234079342508065877987073e-01,
-0.144584890776680387378872838657631e-01,
 0.348844240289829321159551298282798e-01,
 0.268577418125459628475805567747738e-01,
-0.248883627181695374907368881432969e-01,
-0.354415012128721800524851272606869e-01,
 0.117586449906808711003095051827863e-01,
 0.390158992985442743136666969542209e-01,
 0.257276739273940282696626249158189e-02,
-0.371281596945062369830599214808788e-01,
-0.159911451090470730320326578343467e-01,
 0.301394435081907126473293760946669e-01,
 0.265064259410487119913341548039139e-01,
-0.191826486553045339622255287271569e-01,
-0.325429943628954759769084659422977e-01,
 0.601398140515489005574712317083432e-02,
 0.331703772607470173222442347455722e-01,
 0.721439261480667533999512395061793e-02,
-0.282433449185769733801319994528666e-01,
-0.182139434642744726260231638102817e-01,
 0.184380154175374027017949952291561e-01,
 0.247770643053916794606511301897640e-01,
-0.520723549409921900007536060096772e-02,
-0.248027226359375928432282606243694e-01,
-0.918951190540329576693157154178981e-02,
 0.156502077810730759268820672152964e-01,
 0.204276173158811120081821482202080e-01,
 0.974329580411958890230222073975686e-02,
 0.167227812255329261512800981113007e-02,
 0.333420023331979238431475845853081e-04,
 0.527236734344781042310642808324787e-02,
-0.394954360173570637127997218539481e-01,
-0.153992589892804282446939784368764e-01,
 0.352301691806108067638307972913943e-01,
 0.243053780403704375744315088253051e-01,
-0.285076523594516560987928131591653e-01,
-0.312834968343554045200565237712568e-01,
 0.198766728556757034506504732303026e-01,
 0.357775366615165644568686447658335e-01,
-0.100470760888007444726689663035079e-01,
-0.374261878634086926442053306007670e-01,
-0.162371908127335757765423719316418e-03,
 0.360913417654745190298071822475169e-01,
 0.988216791379725774836804137395486e-02,
-0.318692788370357093788789561566877e-01,
-0.182496587534308257671003040762439e-01,
 0.250842560094101674182442816537681e-01,
 0.244569498797820732757947753430004e-01,
-0.162666555274275959302627618942891e-01,
-0.277743516841908873935396006377946e-01,
 0.612328974388728036384278308843220e-02,
 0.275173250305298599265685040448928e-01,
 0.447342104511455424180693740492410e-02,
-0.228615693031674101339991709065198e-01,
-0.143480791653345060075708287209568e-01,
 0.121187864478881096136433390966812e-01,
 0.207376741212253279054177977322275e-01,
 0.107361430799540164990364728762699e-01,
 0.191943720356579076522555799898585e-02,
 0.390246532342022598683458181222030e-04,
 0.407938728226486298823016403812659e-01,
 0.631606205320466049669889537864014e-02,
-0.396060777983788419405090770984951e-01,
-0.124064657958235235923491287215384e-01,
 0.372686604772782491600494409096664e-01,
 0.180513394137886734095118004453522e-01,
-0.338567446002346428834830297268462e-01,
-0.230419767760314046429796782582883e-01,
 0.294800049726467755497444298525212e-01,
 0.271853455430011843210773907394635e-01,
-0.242791810808349947868927103164016e-01,
-0.303071128932882055143149139197130e-01,
 0.184216615418361990984996201568815e-01,
 0.322522412688855566013923307575529e-01,
-0.120964177523648871926937577841654e-01,
-0.328814294256157103103850285979508e-01,
 0.550887035416118530594549313878078e-02,
 0.320597669933139833226218051011896e-01,
 0.112276957578432229909112100636914e-02,
-0.296288447551847283610316812795572e-01,
-0.756458778111985535572991430718089e-02,
 0.253379576972951871876181422686975e-01,
 0.135365988434500237782384166606419e-01,
-0.186537617907139147978162166767680e-01,
-0.185440534472729203194064012571075e-01,
 0.811096087350563939940611908542280e-02,
 0.206887323533802407551154795677640e-01,
 0.117255181776010786750224811568765e-01,
 0.218862835387051949465765184366575e-02,
 0.454117247049035380147428256358341e-04,
-0.106634272106791862000821609094465e-02,
 0.407704458035691996216392254992178e-01,
 0.319111178813090081745645815073233e-02,
-0.402874748376912051677230567884000e-01,
-0.529223008667859123007088740467090e-02,
 0.394789937752380182376988485119878e-01,
 0.735426190145041945052061938629374e-02,
-0.383389976703858041268956210652782e-01,
-0.936228000198308977689923058965673e-02,
 0.368574810621307409902877790593830e-01,
 0.113020844991528060911143986081937e-01,
-0.350183479659427087831484675843941e-01,
-0.131604089381365600540822174104827e-01,
 0.327957656769428807728775347216910e-01,
 0.149250224022923664314006888369616e-01,
-0.301475834177874237306805956089585e-01,
-0.165844076454837496074509409466379e-01,
 0.270027191183345764693056835040050e-01,
 0.181258968663216697102216172525774e-01,
-0.232348666047940119131200311367341e-01,
-0.195280637084696242652436293659972e-01,
 0.186011127852772528776859260824869e-01,
 0.207292538750677542074996390128162e-01,
-0.125745687497784687419325233510398e-01,
-0.214742473920538451505282343919882e-01,
 0.377464754712654214166329495785947e-02,
 0.202548125031905467985555445333072e-01,
 0.126957670998000687964078811334413e-01,
 0.248006539873007274212071953454976e-02,
 0.525586755292894834912838571403602e-04,
-0.408806151980752208672057725649013e-01,
 0.207243603360388693173155642052133e-02,
 0.405659896936222728883712576687345e-01,
-0.408533702667267199155418575338767e-02,
-0.399438238539141440321663817736394e-01,
 0.597902623837731600252906357152965e-02,
 0.390282642421863654513074781980144e-01,
-0.769337817359572146550847938465972e-02,
-0.378404778661738026032249830132931e-01,
 0.916713142902489446418821937839733e-02,
 0.364086043712456364433033590626540e-01,
-0.103364812577366593733861708730804e-01,
-0.347677044412184028253812898317740e-01,
 0.111323349214586268216698526668380e-01,
 0.329596621733657547823746879534688e-01,
-0.114749904286384811011741306764342e-01,
-0.310328210131255856742126778202453e-01,
 0.112634992325117809200524397218158e-01,
 0.290404641795015761282073802582703e-01,
-0.103529833047926928541985997291342e-01,
-0.270345768959999431027529903572280e-01,
 0.850109085286244076335437196830368e-02,
 0.250390439931314671797288450777184e-01,
-0.522127830844471847170016618681531e-02,
-0.229153040296950012449709071370857e-01,
-0.717657150043253898219133517406528e-03,
 0.194203115653227261186959533575924e-01,
 0.136303306021581167046687226511028e-01,
 0.279377071181174511422842644218885e-02,
 0.605226292824049242027808461835400e-04,
-0.314133068947634729312003726655052e-02,
-0.403235511588126539195179420754327e-01,
 0.929123033114990238916918122196986e-02,
 0.385960526521916956424981103141434e-01,
-0.150501779834685590189159071820270e-01,
-0.358228149190071027652234880638147e-01,
 0.201816202524597486089662519379088e-01,
 0.321575471786152650001460413404992e-01,
-0.244838764471645729723502251230516e-01,
-0.278055189576861365281461553097611e-01,
 0.278016612070086812627144669134788e-01,
 0.230147004355626397630069084789453e-01,
-0.300353375894109195916672178387644e-01,
-0.180660443457996775622430312461941e-01,
 0.311474354410672700969517793323620e-01,
 0.132645956097754393523008602656166e-01,
-0.311659750362205848387604959930907e-01,
-0.893449454417729871595559864425936e-02,
 0.301837340123756048547445342384710e-01,
 0.542445819262232067547748988151307e-02,
-0.283504346370987105064246402493180e-01,
-0.314090599691308987370011428842911e-02,
 0.258441063533843913293287588751939e-01,
 0.266406092762894605420366744564851e-02,
-0.227444489898692210630431556232665e-01,
-0.517677832569625592572587383627711e-02,
 0.181812020821546249058863664605656e-01,
 0.145120273966342801196383841491700e-01,
 0.312956321561227015910470797939590e-02,
 0.693622687921243791799356368301553e-04,
 0.405384295093248417172391795626474e-01,
-0.103563766633441658396932806388723e-01,
-0.376898346816091182651783350235343e-01,
 0.198606801942078729327448931292998e-01,
 0.322651142614210148988532544017486e-01,
-0.277505563060816081249403085142111e-01,
-0.247797793029537778397702389535706e-01,
 0.334335113734929172139070387065348e-01,
 0.159367148147017476428896795376239e-01,
-0.365489916619031835789490927906112e-01,
-0.655029739542318793902508811602998e-02,
 0.370060018730679614858398941854371e-01,
-0.254149085317294508164243701290489e-02,
-0.349927866469970924937907238499663e-01,
 0.105674306994980513944470730105467e-01,
 0.309587044776371181544920546242031e-01,
-0.169060283522723937739236283247070e-01,
-0.255727746716285736897942269122113e-01,
 0.211515113069708653533404680874230e-01,
 0.196693582026321503098050212435374e-01,
-0.231530280718452361317495059272900e-01,
-0.142030432342706325379707040370408e-01,
 0.230100624183022723556016676088926e-01,
 0.102698554564488254831620778217678e-01,
-0.209530080768719510541235707678588e-01,
-0.940609838750371101125640534078819e-02,
 0.165458676754703660478126880996864e-01,
 0.153233658282145872861035592522247e-01,
 0.348704800113765121739352222866495e-02,
 0.791377237199050149955252833174079e-04,
 0.730818929090634747681224574995609e-02,
 0.381794818671036741455132453287226e-01,
-0.208727636013184528952571838577253e-01,
-0.304644692889577609867326858443054e-01,
 0.314587779517425169100399592729651e-01,
 0.189470299608497975424657212643054e-01,
-0.376381194184200397625265623560446e-01,
-0.539006245067956660181124170874953e-02,
 0.387132309592055223695185547611922e-01,
-0.818872710665780409193514254431483e-02,
-0.348177123568475092580660040347477e-01,
 0.198672880172128724621119223933150e-01,
 0.268682991467285412522967226085409e-01,
-0.281482200448047922178848454398751e-01,
-0.163781874897237618793138497616516e-01,
 0.322079097662607728211200496462875e-01,
 0.516712482535218255369705339358364e-02,
-0.320236617075772927705834714898236e-01,
 0.497712239101614740905881945725296e-02,
 0.283626183227205513097350975469136e-01,
-0.126207567979318087393123066825040e-01,
-0.226513620212425077132013771634357e-01,
 0.169183863269030318753501743653633e-01,
 0.168002506257572078967576773877754e-01,
-0.176512771566508388786034136655455e-01,
-0.132116469722776838882791659690252e-01,
 0.145355268683988524879640664379652e-01,
 0.160468782325606064909284152494758e-01,
 0.386560772182866878242383158927040e-02,
 0.899104515031020670516393610791077e-04,
-0.397715203898813092763687716551437e-01,
 0.181903479223106042054924042110585e-01,
 0.312615888796846461252263576740305e-01,
-0.322960473308959392242721543935500e-01,
-0.162540172756468766372220603595681e-01,
 0.392470332037042731602529740594988e-01,
-0.174733054324997161524738814235233e-02,
-0.377320086802240538615547117295652e-01,
 0.186470548964837187272629948181778e-01,
 0.284761229206131689603594535113480e-01,
-0.307939530859409547160273567362104e-01,
-0.139839050982866444132892471683306e-01,
 0.358740253665466578306334415521402e-01,
-0.217497198632066179438193138423028e-02,
-0.334243746280015815448947057373010e-01,
 0.163364240631858034169645822743866e-01,
 0.248385502539271422201994375303270e-01,
-0.257025660801529886185036345512789e-01,
-0.128758861266136876077345359634665e-01,
 0.290359582573737955904612183404068e-01,
 0.825808254591827574151606717272855e-03,
-0.269184950835663622582626879454606e-01,
 0.842014666262955003583130687082439e-02,
 0.215611790379986417745257590045364e-01,
-0.130640144705502878736886857464896e-01,
-0.164124955099453887236004312181287e-01,
 0.121842112183446185845739759457555e-01,
 0.166654714962622043811902225853146e-01,
 0.426439590181893798859351493412227e-02,
 0.101743111912909747477087301541275e-03,
-0.113918736181574164773432791759394e-01,
-0.344328344113828045872330865733277e-01,
 0.304676580457048047448618963120123e-01,
 0.172671147889320734928508205288287e-01,
-0.397106838080554160087350864554487e-01,
 0.488748036704410920708288494048975e-02,
 0.363940721138444287810956088344665e-01,
-0.247828598092835694969080305805989e-01,
-0.220503363609976387860123372345185e-01,
 0.361996023577430249932861083466765e-01,
 0.179081843277149913955781967213745e-02,
-0.360487601565697230984706390312884e-01,
 0.176316743395629882270922750367843e-01,
 0.252683561257184484305208015192075e-01,
-0.302655299739451026394268784283473e-01,
-0.822215383431912797343281778990062e-02,
 0.329846247947958852614084860538719e-01,
-0.911929011883052110593310634995902e-02,
-0.263555939392005881380185953948733e-01,
 0.214834835123443472141350673322970e-01,
 0.140760713744007461681649090031892e-01,
-0.262008631334255655789616105669679e-01,
-0.127981812745289960580223043396236e-02,
 0.240374972987326352130476986976110e-01,
-0.751659356599048127543353211542788e-02,
-0.188508686736650206212117141192432e-01,
 0.953827975368190047552458587250761e-02,
 0.171627867831627136407583022653955e-01,
 0.468233228218399279602338314435479e-02,
 0.114699435493383630475729531118407e-03,
 0.385884121983922935094911027436145e-01,
-0.252483800642347482421762158378663e-01,
-0.218959298248100087406329986218796e-01,
 0.393333120817564175864429073246907e-01,
-0.393259149421912035679665997293377e-02,
-0.362678361445933214356746864238968e-01,
 0.273701980816320656050397492904972e-01,
 0.179094396088159391211066023348934e-01,
-0.383221983893260298705961197506079e-01,
 0.713341736789064889630747889110410e-02,
 0.327031766436436567072617155495712e-01,
-0.277390775439421257146839897661414e-01,
-0.140029126182035018894293010701285e-01,
 0.355043078750018749725532847383261e-01,
-0.880299656524527795115464467883786e-02,
-0.283934038079059878757819766347193e-01,
 0.258145666765394158622491012555834e-01,
 0.111054249837198648479051417553364e-01,
-0.308771162843571446999442689883579e-01,
 0.783473513112049221907658663115658e-02,
 0.240491769579529146978640356985021e-01,
-0.206167286422819784573420811085743e-01,
-0.107926689272219546915216230659981e-01,
 0.239522767874431755380861085420870e-01,
-0.141264369677202929705327358152241e-02,
-0.204013807879389761285054432896260e-01,
 0.665546884984465030439013210155661e-02,
 0.175235609745847593844068943756689e-01,
 0.511810031102318573844468581795477e-02,
 0.128844086158236484203942197162181e-03,
 0.153506664888093030383870633894528e-01,
 0.292442135992998141200273362268957e-01,
-0.371797875909631400574936929718910e-01,
-0.121221057060746574403574727804300e-02,
 0.377007128521067599392823706924506e-01,
-0.268911437609045239131964468735622e-01,
-0.171187629413191216309131023257193e-01,
 0.390869649731377882079561403466994e-01,
-0.121508704850551210020271548766061e-01,
-0.291754816089353784232911303964636e-01,
 0.332490005519444507776282774426420e-01,
 0.394577437814118683225890154028404e-02,
-0.349815903850948793466152016597846e-01,
 0.215568370494267419638686224750579e-01,
 0.179810787751620366802288963927744e-01,
-0.334223774650878885022781660659254e-01,
 0.664934643688742438241295062138286e-02,
 0.268772233421381267954163853538818e-01,
-0.248911294114713351540901788176565e-01,
-0.803828432031249435397793749101197e-02,
 0.284141575421406728384428803592680e-01,
-0.111929484913091384873389365524439e-01,
-0.187452136517769312793154820741338e-01,
 0.213011131584410594412661968562210e-01,
 0.479525393515306334018883789303875e-02,
-0.209788363500910089812009136890472e-01,
 0.360349435401188153407332264328122e-02,
 0.177339821098106805715795138997582e-01,
 0.557014686416166935387297463466951e-02,
 0.144242518233117059951985422002592e-03,
-0.370018842529518853189446289175599e-01,
 0.312373828099987346444380885029087e-01,
 0.104800197322479489799663430357376e-01,
-0.398168298870928158885087589221715e-01,
 0.230801525128021907591606548990431e-01,
 0.199463395785747821454756209451309e-01,
-0.394081096851730628644307932953893e-01,
 0.133215881943900847863596508159552e-01,
 0.274724192385986499952559640297324e-01,
-0.358071364298966219395517668553640e-01,
 0.292009986423362772306999426826784e-02,
 0.322950345862755540366165226779361e-01,
-0.293451646998855230206642262980987e-01,
-0.707652987683482530450750480528908e-02,
 0.338671866368845959808298624811310e-01,
-0.206184286144812965305219895047681e-01,
-0.156038131279908108942671386786016e-01,
 0.318698956971895777728755087990712e-01,
-0.104253381384685174820514349838069e-01,
-0.216165488494943054629878541221985e-01,
 0.261408012432986517886124822011341e-01,
 0.319608599749314131882144086091476e-03,
-0.239803788010151275907886583095517e-01,
 0.163569912458569477233477989844708e-01,
 0.106396166224948490324496385015131e-01,
-0.205440992291464084959189556194527e-01,
 0.458240298444420559004441858025543e-03,
 0.177820310143332060640715636990580e-01,
 0.603668426313053453600559172964604e-02,
 0.160960828241825398308229203207955e-03,
-0.191439919036541419393397907838383e-01,
-0.228335975281434824311823364489591e-01,
 0.403854803413708635770909068804561e-01,
-0.150263542991517458557834618535092e-01,
-0.259713076869912565527634751906860e-01,
 0.389799334392454060215490737706963e-01,
-0.106078592454598323665116512437092e-01,
-0.284371874977138708452628865678677e-01,
 0.366479453507561224669792071434630e-01,
-0.601672952822223659375381351341366e-02,
-0.301134008557317247265337672401053e-01,
 0.333981697096867395642151298521164e-01,
-0.137837226536751058503460612352913e-02,
-0.308776813188960688789382913019373e-01,
 0.292241561959504578798988814170905e-01,
 0.319080209861273019506998060210393e-02,
-0.305857919469710647139573874804865e-01,
 0.240712333510284306666781328743380e-01,
 0.759376072896053746805999097623476e-02,
-0.290221422621311588520865079899109e-01,
 0.177494661452800497377881604017171e-01,
 0.117693167077942113058099937498265e-01,
-0.257287533253254344272313281499189e-01,
 0.964449565557497458651450920689651e-02,
 0.156742001764149387803699376342068e-01,
-0.191076318025640437446950387128830e-01,
-0.269841475042115612902223874045822e-02,
 0.176578013722695465741016586744570e-01,
 0.651569463605374963896318655454479e-02,
 0.179065601745339150746482470968267e-03,
 0.350288548011187444532355008035925e-01,
-0.359092282694335175874896287974117e-01,
 0.190988888089909658555706350704309e-02,
 0.336806558992463546604640806213689e-01,
-0.362592073863234158860288574563463e-01,
 0.369074584818065730165068943099538e-02,
 0.319382075167503353429728865638608e-01,
-0.360251607487893514471638446554836e-01,
 0.520938388016612127077357893633296e-02,
 0.298878399352138083165748341391361e-01,
-0.351588454921035919648471227498640e-01,
 0.632193696422726665125131364434156e-02,
 0.276311051721953027263931027856668e-01,
-0.336102211478545581582866918722838e-01,
 0.686078346468065643424503162908801e-02,
 0.252895174259508234239010513418091e-01,
-0.313110417600365288410795384866535e-01,
 0.660448985672067788596516047344068e-02,
 0.230144527179651594223246289491787e-01,
-0.281308481126761763529091230886596e-01,
 0.519782713734238171290717770418495e-02,
 0.210060945975157833466177289271320e-01,
-0.237252417715934596529193715180822e-01,
 0.188562635956226518249566024136056e-02,
 0.195093249574374282711820827975442e-01,
-0.167304282816451002943126875123950e-01,
-0.578106743930982325521112814384870e-02,
 0.173537907374668459197440395208450e-01,
 0.700493664532501637843466476904572e-02,
 0.198623755552578308646211836013518e-03,
 0.227328814951163352476390330320538e-01,
 0.154712165786294501007426923490601e-01,
-0.397908065345075839029570226933887e-01,
 0.287524394133118793586613759944114e-01,
 0.756229123426712210208068700671150e-02,
-0.367341750511587519647949797816931e-01,
 0.330625105634722565419938875350719e-01,
-0.328410916662153300064210468720531e-03,
-0.319961499754676182694069307680874e-01,
 0.353701020039243330352891968898656e-01,
-0.752602864277476069692481839634592e-02,
-0.260840252750677139589855612262567e-01,
 0.355899127426683207279053312226234e-01,
-0.134048411897021634105748274110172e-01,
-0.196602188121480656387494485234450e-01,
 0.338627094766737902881497630925978e-01,
-0.174338014636252415653679770679925e-01,
-0.135139981633554819246417969107105e-01,
 0.305609047775602526404141586635278e-01,
-0.191881820307960246475910572387833e-01,
-0.857205825261709052954286297898043e-02,
 0.262872067544322388391473441706617e-01,
-0.182526470831562541646575956928752e-01,
-0.607723628161822897759357543121546e-02,
 0.218434772708891009403774643585573e-01,
-0.135222090750616170294226381651018e-01,
-0.870347608779679095637365504055822e-02,
 0.168651553831484949482554581472787e-01,
 0.750195458368826784731626733505920e-02,
 0.219702375631479722498448211613883e-03,
-0.326902171752073512848102539285019e-01,
 0.390709728808407574107786782685074e-01,
-0.141092459100233994784860664340314e-01,
-0.219555957630335881261251866236553e-01,
 0.400891197382656303509991310637291e-01,
-0.259511911765431448860940312835179e-01,
-0.868885461997948509859631600705660e-02,
 0.357555813979346942871830050496123e-01,
-0.337237450950391265236753840994480e-01,
 0.485033812258512597635458730271824e-02,
 0.270976502470295454460375868835884e-01,
-0.364615531341966008365315752264695e-01,
 0.164316499717197514106483813233864e-01,
 0.159483586677525159231288697644079e-01,
-0.342414184162880186050303902112336e-01,
 0.243192140176004316699800558080495e-01,
 0.457685957807714201968581878224470e-02,
-0.281897327529684946690791559942040e-01,
 0.276431803039924020934905533946434e-01,
-0.474824970992648714798980360182901e-02,
-0.203221362236563246290824758099981e-01,
 0.266093767575098188869524234416276e-01,
-0.101046700559165231509349888654432e-01,
-0.133729574276642320947578586010658e-01,
 0.224885139861388043971601374722813e-01,
-0.963689724038088646443584012909151e-02,
-0.113813740135627572535132748581628e-01,
 0.161899224567788090694860646782216e-01,
 0.800408981774090466443464929507579e-02,
 0.242368551058150616246521968554560e-03,
-0.260804108797054729133958783377845e-01,
-0.746633480090889029826954086233826e-02,
 0.354581043910854900261763140279810e-01,
-0.376931873445249993043056052743274e-01,
 0.127781252706015433740278454781582e-01,
 0.210034864675759501332283391093549e-01,
-0.391631601164223910526252612185368e-01,
 0.288609911448900051239907499193588e-01,
 0.194067716646034691032934938518632e-02,
-0.306013607150138718212347012137574e-01,
 0.365172960014147312461560138606497e-01,
-0.160453673474535997252310836095970e-01,
-0.152461001101293960252993137947463e-01,
 0.344030522828785799156226100318455e-01,
-0.280246038241570392259907036287826e-01,
 0.176073922096193840118696746627801e-02,
 0.244458487298318716861231398810166e-01,
-0.315088412413843276190302454493088e-01,
 0.152530643597511534501439354680920e-01,
 0.110513273074339818574308418495611e-01,
-0.272810569366603744962487176104779e-01,
 0.219031970617791675908535541223837e-01,
-0.472789699811018320268053324602030e-03,
-0.191977864916777046943446644584961e-01,
 0.213862674807005869621805492107429e-01,
-0.526555500574798902732525258938469e-02,
-0.137353125252387893184919549978295e-01,
 0.153291536259464511102841332480795e-01,
 0.850849453516225607938439939848389e-02,
 0.266689204350587890510446641892755e-03,
 0.300106312838073462135827268395934e-01,
-0.405927910848808235072593715733729e-01,
 0.249740031316171530775930138646140e-01,
 0.659547531151916016968685567905907e-02,
-0.336001629959460410278040423543808e-01,
 0.386700470949251686055430709164870e-01,
-0.188338938771879782291768431483163e-01,
-0.127224674498757772609623241320794e-01,
 0.354465812607267839666385970813299e-01,
-0.348875292497063881333307666879144e-01,
 0.119713189808955119359754504800131e-01,
 0.179209664769708644180146509170894e-01,
-0.352949116474737894050214359265176e-01,
 0.293482898555726673999178578450780e-01,
-0.478185958189803671134418556124189e-02,
-0.217365898885814218651305538903890e-01,
 0.328878203978093729379392331972940e-01,
-0.221272698571441802517428729833411e-01,
-0.236659405061554175490898535527592e-02,
 0.236735069395825019679074058314056e-01,
-0.278009486265403256820145576578254e-01,
 0.130514604872303210637170331882880e-01,
 0.922702282572863279500119766053838e-02,
-0.229052370539906027467884938511983e-01,
 0.186150130440889975970914524562421e-01,
-0.627108791228124475862895031358377e-03,
-0.156934324929433374767288851019070e-01,
 0.142870552598959843849415443777298e-01,
 0.901214772933725583610575161354036e-02,
 0.292730918541656183911118865662285e-03,
 0.291521058377878940196759143647873e-01,
-0.845594131804374689337688309478920e-03,
-0.277993147103847690253522060493625e-01,
 0.403733705309376901321728546909315e-01,
-0.298168524877452297743088118433735e-01,
 0.242172248093846039534209544638773e-02,
 0.259236212100324294383051820057658e-01,
-0.390050043392758937561637846950960e-01,
 0.296330515233528213207190743341856e-01,
-0.364336120373708249080573330277062e-02,
-0.237070767411546128706898062223630e-01,
 0.367396943773404029051506363586819e-01,
-0.284246499554793716669582145854596e-01,
 0.423509628941961613010073415205899e-02,
 0.213634836349255186489816309026015e-01,
-0.335838476439697094808856565020946e-01,
 0.259511573897473213034767559406910e-01,
-0.382235854105798542444803785462436e-02,
-0.191708562308947757068428631538910e-01,
 0.294861142145381815284239937307530e-01,
-0.217517039192430144818435799406086e-01,
 0.172636160467761127707671438090243e-02,
 0.175625579244153750290076666393020e-01,
-0.240794686590756058444901846460085e-01,
 0.143850692802107001869882907757928e-01,
 0.404267389603564454721247085953364e-02,
-0.171940631964768976363266890009148e-01,
 0.130710311741328421228282231042641e-01,
 0.951187333270403251388915219367523e-02,
 0.320559761353683872815713885745309e-03,
-0.270182735663818496394031482407037e-01,
 0.404132897994266214112277854431713e-01,
-0.334872927169098056486333223167230e-01,
 0.984826431388227399129851166240913e-02,
 0.184751338780585687426141100765797e-01,
-0.371973857522510832817826467600742e-01,
 0.370423176356359454049077310393607e-01,
-0.183894286395303034023885882051960e-01,
-0.905004737427366110084757965854179e-02,
 0.313068933084094979524862795552740e-01,
-0.373216075859398556851761512092177e-01,
 0.245060575629592105077022401487713e-01,
 0.126855186871805137930979924216062e-03,
-0.237697072233611654991319929473372e-01,
 0.345145940281017304573085701766629e-01,
-0.274274358948497325638921662759383e-01,
 0.687516764097891651198340666215931e-02,
 0.160223961804028816282054885137973e-01,
-0.293860980644510911731677250395628e-01,
 0.268106271025086051310084987437871e-01,
-0.105574451819923054168087760195792e-01,
-0.992481880645144390333363893601427e-02,
 0.232978239978371031761654703205599e-01,
-0.225836491333638255025572567156653e-01,
 0.902368812603774641009615900179382e-02,
 0.850338115275592902200279544580064e-02,
-0.181880507095752658071160147661974e-01,
 0.116916750536954042204312447539768e-01,
 0.100043603883102829419423270558949e-01,
 0.350241106844136306471686719928645e-03,
-0.319163169302904685807023838149304e-01,
 0.911685877472856101243227896223308e-02,
 0.175367874818784070988746169609438e-01,
-0.363571245498959082379146862156326e-01,
 0.391795431985845075078625800307290e-01,
-0.249441799279900350016826874350468e-01,
 0.986679466931936848066670353547406e-04,
 0.243342303581215538296990633271453e-01,
-0.376873647529325490570212197460659e-01,
 0.343588545228514294278951747840242e-01,
-0.162019845354513798362908890671231e-01,
-0.844071959239704496530589541860502e-02,
 0.285773436887738042311976610212260e-01,
-0.355139327081242005104104020761604e-01,
 0.266696445597821682514208843975259e-01,
-0.656391707070691630325626339692432e-02,
-0.154159527805922948323010710515637e-01,
 0.293935084189896647866296195771005e-01,
-0.294964023080116791456345514205410e-01,
 0.164114034355926432796358646961671e-01,
 0.313567234364698573091137590563768e-02,
-0.196866034954518349884150937195233e-01,
 0.255779521473650781472146629982329e-01,
-0.185775004531312026384443958346039e-01,
 0.295028130781101366060096045405275e-02,
 0.125226720568056042830634158124798e-01,
-0.186407253512515965964145672767602e-01,
 0.101627008431374204345731361567204e-01,
 0.104861851279204896423553981358689e-01,
 0.381839454898335718154542387926706e-03,
 0.237445486616075826375177154235616e-01,
-0.385419824193631764014921062061799e-01,
 0.388540644483327067887088871180536e-01,
-0.246496627877619223629483085769330e-01,
 0.138915129977561965146365751798767e-02,
 0.220907478103848076629934106773048e-01,
-0.369678728659611380375939237090108e-01,
 0.377899681863904154151162210860480e-01,
-0.245056156846149467002838669906382e-01,
 0.240316623500307260675793806491314e-02,
 0.199951058583491074982614403381283e-01,
-0.342465511850917234938336345279626e-01,
 0.352143877889572750309711848852790e-01,
-0.229612370996335652255193794728854e-01,
 0.259810195168079420926168413381072e-02,
 0.178180097697219600449535638711344e-01,
-0.304850419123879250309072538218857e-01,
 0.308852961338506937852810539835757e-01,
-0.194582842105946906275339578397333e-01,
 0.128145207970837262414164661054937e-02,
 0.160834095507983402350122495055892e-01,
-0.256975672516092582061665098889423e-01,
 0.240585923913491569995443531186471e-01,
-0.125016628475507043111262611766865e-01,
-0.335615083962407516499664580626724e-02,
 0.158888116171106799942587498917896e-01,
-0.185334285263880307196056764641258e-01,
 0.850081062482051282678981806913469e-02,
 0.109538348047733075442928154255436e-01,
 0.415418248951095658403701842090201e-03,
 0.343445604985857952486965602611324e-01,
-0.170019281081562452210841969962951e-01,
-0.563525078881308256914054726156481e-02,
 0.263175971579023279376902703520318e-01,
-0.384702951151404396558845017770932e-01,
 0.383131387766369426244509118696010e-01,
-0.260578117491190585086246120104145e-01,
 0.579714987571279697194484414575757e-02,
 0.158670664722464919934880577100667e-01,
-0.319971875675529184115840852389820e-01,
 0.375735565014002873117665933517746e-01,
-0.310891667693542033475332233675873e-01,
 0.149698694065478148718060364839542e-01,
 0.530187372760389313320327356459653e-02,
-0.230516552761808936862971361382381e-01,
 0.326344614364597277671316222762538e-01,
-0.312703677762519497377151786742403e-01,
 0.198899149132598980260318583378784e-01,
-0.272237003615076207026044192646182e-02,
-0.142163209716350845750640444837348e-01,
 0.252121935244534183906450473080753e-01,
-0.268071552730266386423199526576842e-01,
 0.189599126621523516370693791450310e-01,
-0.503026466929978458416432722633572e-02,
-0.939484473339376108435502461539210e-02,
 0.184223214189534539800745821005882e-01,
-0.178645332555809623244407074959323e-01,
 0.672550077698474917128079928928861e-02,
 0.114037331099385169888489190579338e-01,
 0.451039692324404698593100993598181e-03,
-0.202237662391953858439965879701077e-01,
 0.350588196331589277359356468448816e-01,
-0.405748918804737732918181942223775e-01,
 0.353590927590942722202177865360601e-01,
-0.208861997681834873089938879321999e-01,
 0.110125700654046826512810891923624e-02,
 0.186675562777750202571489692260135e-01,
-0.331640851145205345189407392359292e-01,
 0.386260285199437131157063346355726e-01,
-0.337838373454317731053108623239163e-01,
 0.201665177826216773693900371365342e-01,
-0.163764660295156870597877335485411e-02,
-0.167017113269992418060904198477548e-01,
 0.299326076325031747232022733000513e-01,
-0.346635014150458068595920646780782e-01,
 0.299292156360090694635802012060176e-01,
-0.173997564902513945036542362227827e-01,
 0.850304619114582001260216529526005e-03,
 0.149493186593570176736074302051563e-01,
-0.256065550187764338010308466385911e-01,
 0.283502913573729694656855375897244e-01,
-0.227982407293548971662695144938718e-01,
 0.110364755373854296919581666782651e-01,
 0.300326949515380116190828607597696e-02,
-0.146833332800176739334847845169730e-01,
 0.199860778159772209728146688104201e-01,
-0.166499094013619933981654835955483e-01,
 0.485880848332947730548602822228272e-02,
 0.118322669833504923118787755853921e-01,
 0.488764563572911694180027148760638e-03,
-0.364118237240949193641923591472498e-01,
 0.241717945224364407799315725072206e-01,
-0.678868735148092121191523413194128e-02,
-0.119234475184118886576683372876787e-01,
 0.278816761861232998053333563879069e-01,
-0.376422272652758424556712236766392e-01,
 0.391601714925579193109824556307439e-01,
-0.322303504635674157017440442112676e-01,
 0.185121868826087388414628754428802e-01,
-0.113588897108607742116907622965876e-02,
-0.160174309211557694064700058466934e-01,
 0.291957720566008321435687026831819e-01,
-0.356152806004509181010146229216628e-01,
 0.340681585697268606010571849846414e-01,
-0.251636584314320702003573255906946e-01,
 0.111514343937422482453288979276813e-01,
 0.462740226506532018732249148775896e-02,
-0.185312128492723528982911853204913e-01,
 0.274660594699907907309914580848294e-01,
-0.295951054969375172826705550663305e-01,
 0.247469594946437895900712176866399e-01,
-0.144319124556542636389164624565449e-01,
 0.146686638395161862318406820100301e-02,
 0.106990255824137502567820302623566e-01,
-0.187964885079074005170344340173367e-01,
 0.204932644193828358616133576329124e-01,
-0.149228034665607906971071252898861e-01,
 0.292500192998898884796624323731454e-02,
 0.122358146141750910813482225579553e-01,
 0.528652031232917049958235940940356e-03,
 0.164927866757821563379378913655235e-01,
-0.301107969926609645314847240097252e-01,
 0.384921054378422400945593338512997e-01,
-0.402075140764626261320689742883641e-01,
 0.350115027880792600062629368784523e-01,
-0.238792100815757302693475037806389e-01,
 0.882350964590291982978721880712345e-02,
 0.747363895420569711300951165584595e-02,
-0.221476383863103595276795132913392e-01,
 0.326663757957735356844546349190852e-01,
-0.372801111505498753331494408113587e-01,
 0.353246851687421124287861798669181e-01,
-0.273239567417493503008792682674857e-01,
 0.148745405195279119126273658060714e-01,
-0.335995264740523460492016496391170e-03,
-0.136147906726381232510097589504572e-01,
 0.244817106595464055453488523428982e-01,
-0.304077087440415508704192247952521e-01,
 0.305089653363833596489461319922417e-01,
-0.250244178684378624738784390493513e-01,
 0.152548117148556935503333428647092e-01,
-0.330489063703391683929623890098326e-02,
-0.832091788702311113407118102986768e-02,
 0.171916575871740828512207646847884e-01,
-0.214013319946103565039160312044646e-01,
 0.199126960617760234865936885999216e-01,
-0.127331232123951358615676855719553e-01,
 0.950218747274768728837303464688143e-03,
 0.126107744103627909357021303639360e-01,
 0.570759468373846934924780424828348e-03,
 0.380968314024243683782463672046682e-01,
-0.303276246744840818514445563135674e-01,
 0.185710487828088090608681435792765e-01,
-0.443869714353671240963704664710635e-02,
-0.101403678742077763214579778327313e-01,
 0.231900345444418454309996667241485e-01,
-0.329629768696677303653185183709600e-01,
 0.381827105161466638322443205552171e-01,
-0.382176139555287486956086798508562e-01,
 0.331625001901680389426099499955260e-01,
-0.238166424607974749829616142396181e-01,
 0.115620280219686451186329273953788e-01,
 0.184010776087753721405873084964695e-02,
-0.145047849881923992245211882385759e-01,
 0.246938268598143645773846834150765e-01,
-0.310625071325547205075979468463528e-01,
 0.328470299067670246126099795573941e-01,
-0.299663312364050581437342587170387e-01,
 0.230242498446708187912898488759728e-01,
-0.132126485338681325971560059425872e-01,
 0.213047668865688637694265597294977e-02,
 0.845402369136290866982630024941765e-02,
-0.168624860685567588875757754930943e-01,
 0.217482791102750618871307768966494e-01,
-0.222847034415569429626032010857473e-01,
 0.182711715819119768354322501091813e-01,
-0.101461384932947003582409115341600e-01,
-0.103794159366817109237000108536157e-02,
 0.129535947042034715214468767553546e-01,
 0.615142267353767707138536807202820e-03,
-0.125906394910038955532600297958101e-01,
 0.239057808537890517798972527078288e-01,
-0.328039933962136936422079995356812e-01,
 0.383975986492502294724010658666042e-01,
-0.401451472876077148214105607241951e-01,
 0.379068084081989533364451256446040e-01,
-0.319568044683147583554477598162571e-01,
 0.229516694956714486970484410396608e-01,
-0.118578788582380668855143694085566e-01,
-0.153222391833997833421044906708577e-03,
 0.118317541072651794405453801349475e-01,
-0.219831963769001380363159356029006e-01,
 0.295953718707422834862178063083021e-01,
-0.339448438100334157100041652113629e-01,
 0.346713447105743081493536761357420e-01,
-0.318123707059093017596780275450005e-01,
 0.257944442322402854068649890100193e-01,
-0.173822879740173955157535800205254e-01,
 0.759175020587204842708272103723479e-02,
 0.242372070204208023179094161487978e-02,
-0.115003593732559775493758149261480e-01,
 0.185908969076567461959966010106373e-01,
-0.228766444940572948068383313786798e-01,
 0.238520194671518816730702785597959e-01,
-0.213714304987494174789561304697061e-01,
 0.156526750665526487258452828832796e-01,
-0.724063086590907685415320001535964e-02,
-0.301086466007050603422775273932843e-02,
 0.132608039495638458182648759324428e-01,
 0.661853655182375054975665602372373e-03,
-0.393822722273604698739700860622584e-01,
 0.352131505778477301718856298193590e-01,
-0.286092554722546226015027573340255e-01,
 0.200597453475296436169424080364031e-01,
-0.101960597867328021722636477952253e-01,
-0.256450841309202081910527971611912e-03,
 0.105339972952882188850242631964126e-01,
-0.198926207088412098031031934023833e-01,
 0.276647428822853077790120461737466e-01,
-0.333096218633151252724580155815482e-01,
 0.364538190587449425263535386477798e-01,
-0.369185697422527727471334255777457e-01,
 0.347319765239743552206806656997050e-01,
-0.301251347212284821949406694001143e-01,
 0.235125566976418696335630907501768e-01,
-0.154584910449490634617763562377193e-01,
 0.663183654752148256827010099852990e-02,
 0.224675486477160821118842542329612e-02,
-0.104613751154623600649676803162481e-01,
 0.173564505060483753544475677566855e-01,
-0.223869610848189394567365707790582e-01,
 0.251591863956849845681633559252633e-01,
-0.254585066425875802583105459451554e-01,
 0.232616084669882455179632431601338e-01,
-0.187313999663066403372892245418376e-01,
 0.121944205625725994613071566456075e-01,
-0.410654492172401223355398597213402e-02,
-0.493939950142828606064292388464789e-02,
 0.135290411573779825641733712054346e-01,
 0.710944509896057299421741675142313e-03,
 0.855811868248131618039206562244483e-02,
-0.167038100023321934703025937247479e-01,
 0.240457889225830109998942380723898e-01,
-0.302339524135105116901527159722056e-01,
 0.349772717324175230050838933163245e-01,
-0.380586052765339105156176902566941e-01,
 0.393456616432035537048477098155843e-01,
-0.387975446302244809627640718971541e-01,
 0.364665438409598925437830704699293e-01,
-0.324950841585721166664726785795803e-01,
 0.271080015421292342299624383992769e-01,
-0.206005580762024842919605170800020e-01,
 0.133228331696565592013342765609973e-01,
-0.566131863069816194165193726436391e-02,
-0.198130673979535740556715155353554e-02,
 0.920714976806182904146429963892871e-02,
-0.156437065935533862840797635462539e-01,
 0.209629942530103594621104723559490e-01,
-0.248981731468022354409479162429724e-01,
 0.272567356532445861089973671670685e-01,
-0.279294822041720675082359076011802e-01,
 0.268946665983855938949597597231767e-01,
-0.242168387334334434069905217798644e-01,
 0.200400107042065061803370722950473e-01,
-0.145748309074106679481902324164679e-01,
 0.807991379881223725464937985573021e-02,
-0.842213152740311128364366857602958e-03,
-0.679436014334685899062940627937510e-02,
 0.137550863089786612691009447981713e-01,
 0.762463178350077292521937872313411e-03,
 0.402549826302291983222393810456695e-01,
-0.386252860441435095168634696635445e-01,
 0.359650223197802027711438443551212e-01,
-0.323561794752090179043029598120484e-01,
 0.279098860194750196006067214674859e-01,
-0.227628966136565501766705149841675e-01,
 0.170732691799869467143191930754614e-01,
-0.110153715559426758485973498483840e-01,
 0.477437731617867809576218040651999e-02,
 0.145957310546517902174896609918987e-02,
-0.749735886016025846140392479713148e-02,
 0.131568203643755034538209154295606e-01,
-0.182684645774438479930438837751615e-01,
 0.226807486627992725717411029763199e-01,
-0.262647685604165378332331401466584e-01,
 0.289181953288721371267376146006583e-01,
-0.305683219219988065755306934040731e-01,
 0.311741046931404481685761746957674e-01,
-0.307271048793317335213674752222248e-01,
 0.292512517081548794007247647982190e-01,
-0.268013541930961598788750490424391e-01,
 0.234602723305951025919471611351402e-01,
-0.193346025856533716283392231552656e-01,
 0.145486149934572684013349471534497e-01,
-0.923602018292394675438379228086110e-02,
 0.352937586258058922781734377803698e-02,
 0.244875723099407352872059573114982e-02,
-0.854704097025508113134022901429083e-02,
 0.139358904820887021428295730108568e-01,
 0.816455295832636323029675929295455e-03,
-0.443735929640327299463790096753608e-02,
 0.880623520608030969405187140654232e-02,
-0.130392553936310455852819960814511e-01,
 0.170712512943929491533457404298852e-01,
-0.208403144487654219595711783053368e-01,
 0.242887989489476849942208232529993e-01,
-0.273642533043188551905154095603116e-01,
 0.300202660769671981609764639882898e-01,
-0.322172108905121681296750718652151e-01,
 0.339228778326384951961942202427578e-01,
-0.351129798002714355486810100232933e-01,
 0.357715239025791056088542235166845e-01,
-0.358910395391613919992397341832808e-01,
 0.354726560626727324216996881057914e-01,
-0.345260237980635999385825591267405e-01,
 0.330690722835202264836874646141115e-01,
-0.311275983671428048151923261186826e-01,
 0.287346733055174406515475666743645e-01,
-0.259298506434616671007956378452392e-01,
 0.227581425138788969839469880865100e-01,
-0.192687058332988846141479117922025e-01,
 0.155131321984235829953809295275879e-01,
-0.115431499566505346566340648972452e-01,
 0.740740321663451537154297400516238e-02,
-0.314678983370023556120800773952694e-02,
-0.121197194571343537038599795602993e-02,
 0.566083340121243847050905724304648e-02,
-0.101697363625185708828685186049537e-01,
 0.140686054218044791723439927772733e-01,
 0.872963607904571883206071253749218e-03,
-0.407060865463380741476589025732266e-01,
 0.404225276657228142782732481996114e-01,
-0.399517921269904642335934535039581e-01,
 0.392966605308678710721536467153652e-01,
-0.384609990869792540987497162812497e-01,
 0.374497328634686727947293580760490e-01,
-0.362688111919778293282995860452818e-01,
 0.349251650166881590918280300864804e-01,
-0.334266558524668892726428157569316e-01,
 0.317820158312008245242783443957685e-01,
-0.300007780367584461346856939540327e-01,
 0.280931959113496271777202601868803e-01,
-0.260701498872242011322133802487720e-01,
 0.239430384431492189400472221211635e-01,
-0.217236493194699660780740484950811e-01,
 0.194240043422570591453191306792036e-01,
-0.170561676886535481173457628302270e-01,
 0.146320015797438089311075959804103e-01,
-0.121628437424203365116234059427361e-01,
 0.965906471703891361332012206390913e-02,
-0.712943507847991779903904761588927e-02,
 0.458018362809443400860816410591693e-02,
-0.201354183295984923036343053256074e-02,
-0.574573129437158135516536393206803e-03,
 0.319826708420058857588949060206783e-02,
-0.588713485642916401893700245653133e-02,
 0.869002953268616899383879136682736e-02,
-0.116362546655176039546713678315008e-01,
 0.141506122887467200425613653445967e-01,
 0.932027794866696068097791608666759e-03
};

static const Standard_Real WeightsDB0_C1[] = {
 0.224712945290939265035185233386492e+00,
-0.181169368431486317542623533557901e+00,
 0.171780517258837992948232893658993e+00,
-0.167948499508708198415142968724267e+00,
 0.165968683767246239832670875869561e+00,
-0.164802808032970527158344894050198e+00,
 0.136634880227740012288584150215595e+00,
-0.110158562180394121459639839325337e+00,
 0.104449747524478496063087606979045e+00,
-0.102119720272859049689582442080951e+00,
 0.100915909400470664826766989032717e+00,
-0.100207008134871821693693002493587e+00,
 0.997524540749194336222870744069930e-01,
-0.994428233618688404024159610895130e-01,
 0.992221076333536158993210142108538e-01,
-0.990590856353374044054138967888968e-01,
 0.989351842914937745443169427521255e-01,
 0.566624958790747703949019265085386e-01,
-0.456827646439005207134541504128271e-01,
 0.433153187444635788498555873898820e-01,
-0.423490562548052854330943908402544e-01,
 0.418498357886827273681142172586490e-01,
-0.415558543765153949277963138075646e-01,
 0.413673507710967852594280502404831e-01,
-0.412389468893572066141738712887655e-01,
 0.411474160588943287476791718225856e-01,
-0.410798108231346478964558860696499e-01,
 0.410284289258237285378542169754723e-01,
-0.409884466890156213777475196858584e-01,
 0.409567142782031456785301934826954e-01,
-0.409311022274027224466139069328435e-01,
 0.409101280511716071067828941538149e-01,
-0.408927334080204888320266316101616e-01,
 0.408781461017092034678222173698157e-01,
-0.408657918538770532870107416564696e-01,
 0.408552363088594674246427082744355e-01,
-0.408461459683466980449358598542294e-01,
 0.408382613004943173315929087721439e-01,
-0.408313778673526634554616462705792e-01,
 0.408253328469613696123477859592317e-01,
-0.408199952552102644899788813911087e-01,
 0.408152587495273910504897188971103e-01,
-0.408110362629651129056228039389189e-01,
 0.408072559548467467327316895791484e-01,
-0.408038581210305247052197303800108e-01,
 0.408007928122239588413962075706306e-01
};

// Coefficients de Jacobi Pour C2

static const Standard_Real WeightsDB_C2[] = {
 0.396320480216379147641761558479570e+00,
 0.144052361182505130848899984065313e+00,
 0.131292459415739298593344566233794e-01,
 0.578203737578765418998616263243096e-04,
 0.281561650684809260829575792995744e+00,
 0.293201045908880500974854972162680e+00,
 0.405099732443208944936725478602602e-01,
 0.215044760544698117585469533171885e-03,
 0.334583421303093473842799989484162e+00,
 0.174676179487600931912659677801890e+00,
 0.414046934310615620400711109323430e-01,
 0.288458217870532205613376623338135e-02,
 0.110313137547950402313163428023921e-04,
 0.192916730701233906522494864072078e+00,
 0.293199756699775998009323858062076e+00,
 0.108949906473640375548487314996555e+00,
 0.966443493790936402440835622090424e-02,
 0.416092745187115507089479587124437e-04,
-0.174032903192486871137825505820540e+00,
 0.247370108922729524789886493708647e+00,
 0.191120453285188435529199830264280e+00,
 0.229822477917242474330026471576184e-01,
 0.113696595639761778003514856595157e-03,
-0.240680915538750664729181303867297e+00,
 0.269318047606781808479596257110342e-01,
 0.251160269186405092367630145090844e+00,
 0.446843385622820033492567946813940e-01,
 0.259720751989667210630314032807919e-03,
 0.212269031963283203051431859782776e+00,
 0.135838726406542690011207114201187e+00,
 0.616433702925269408986848270222060e-01,
 0.181379470805613968142317109407839e-01,
 0.286518443373659953449203420754863e-02,
 0.152898769239171220641215683900530e-03,
 0.506528239698080474600373441061079e-06,
 0.165404567042817025178935956056825e+00,
 0.207363467173963938726463557688332e+00,
 0.136316035662673690574217392599703e+00,
 0.508888728704363983843598493503055e-01,
 0.941238865031634502864114575452110e-02,
 0.555029296520305301786079737946403e-03,
 0.193821945352998132841571810736498e-05,
-0.649709317916673937666329252783094e-01,
 0.140808279297044736842159805550336e+00,
 0.186851618875541675640226794757199e+00,
 0.971177833876034876893518444829491e-01,
 0.218605597166952135411515783459886e-01,
 0.145076686878103201873655567873166e-02,
 0.538424962953539252147726670192287e-05,
-0.181863447229842685413811559396690e+00,
-0.354010105555142641629246937508413e-01,
 0.164811091061987455069510962419633e+00,
 0.143309647935103064662114082021597e+00,
 0.413211898659829721383695904517816e-01,
 0.315025561653262148227440140596919e-02,
 0.125312286441044939539090311740836e-04,
-0.308093209821129442213584263862471e-01,
-0.166068706661047675774510037769206e+00,
 0.608222000186021497719668210343114e-01,
 0.168704735565713790144778969507078e+00,
 0.671393033233751564596108804354805e-01,
 0.602032439740842934003676534831025e-02,
 0.258952326420323027719870271809239e-04,
 0.158849164905307227861539339970744e+00,
-0.122235046860132267944812436539894e+00,
-0.745624073890737863872131747274191e-01,
 0.154508858865237065420389656386230e+00,
 0.963014491881084588088440341316645e-01,
 0.104433131578440172773925399751389e-01,
 0.490234589955026835552992879961272e-04,
 0.103565465732591547159985002246164e+00,
 0.495798032030116725663582811534206e-01,
-0.157106415953537093194338281567135e+00,
 0.949647381159171638100402334432758e-01,
 0.123487955734175685414210262659582e+00,
 0.167578997333694680313931363869491e-01,
 0.866926850409991568654702400998443e-04,
-0.108150419571513918415020580643786e+00,
 0.163368217243666842131089261218807e+00,
-0.129286642566784128767556821914369e+00,
 0.412646228348392924890677115734530e-02,
 0.141943969179045156768378343240899e+00,
 0.251881152705572046293088097292274e-01,
 0.145093839665840772689954567046659e-03,
-0.149832756428058083751947223808136e+00,
 0.937609003100119432618523473154652e-01,
-0.902866186875399659101727920321736e-02,
-0.866389573004651684689057535684091e-01,
 0.145081368306149989010600978054158e+00,
 0.357699031758404650632185329432509e-01,
 0.231990966795263813702848233027727e-03,
 0.181740208496436970519551707020885e+00,
 0.153951530748500300020561462949014e+00,
 0.109574857645228643081802200739324e+00,
 0.643606753636794077116520100730876e-01,
 0.302144517034509007165951914797544e-01,
 0.107298370400989121808352133006198e-01,
 0.261213228293439136910844543300440e-02,
 0.358742258042677345053526206335246e-03,
 0.174173844099142288382366681634964e-04,
 0.547914339677178978669243900724073e-07,
 0.538652428750875842011274292263277e-01,
 0.135817704330356648253692540197263e+00,
 0.158593987418946726851153408535664e+00,
 0.127342705844980758529364864144083e+00,
 0.744310451370744812865115465698969e-01,
 0.310149270664391385327467855847509e-01,
 0.848913228636013292252573410037230e-02,
 0.126746106064055820785141642579863e-02,
 0.650268854145989276797134332392396e-04,
 0.210748156651593777874403540099624e-06,
-0.129171079141236279330271855461075e+00,
-0.265951939680359648190313131472261e-01,
 0.934777926469502404053226652240666e-01,
 0.146174387593161909743264003546358e+00,
 0.119326403733416813052468788908043e+00,
 0.614937913011098503595339118911017e-01,
 0.194615946361512937736265141049182e-01,
 0.320972086128601800057955703682243e-02,
 0.175596806625226078700190483575797e-03,
 0.588933365991128074517580010360340e-06,
-0.743036380958948435964105130992284e-01,
-0.136806084139661742096138649379685e+00,
-0.472052068002327361837405687669536e-01,
 0.870144555241656009006146756057755e-01,
 0.137262997810404045137972946399572e+00,
 0.954240809523379673134625473598968e-01,
 0.362153435854847865876468184535417e-01,
 0.671933962484745850707000280396482e-02,
 0.395769277586799068711944602211962e-03,
 0.137989415971565186942693469933450e-05,
 0.106185721814007204353562838075038e+00,
-0.530228863206237870719346810369925e-01,
-0.131165423678839454551681556827547e+00,
-0.252369615798354741617703861913585e-01,
 0.106785076924678223410702706248548e+00,
 0.120512089163961947855982229585699e+00,
 0.577396463690330856687491239287849e-01,
 0.123135050532721631717136410922448e-01,
 0.788932440423127821858946424519152e-03,
 0.287287803873587098433760368566746e-05,
 0.903083616728277965577468607140241e-01,
 0.101818153008653451076173252098966e+00,
-0.717790587437343144959932623311404e-01,
-0.113806125878031082700241009577005e+00,
 0.308628472468645432494842729152741e-01,
 0.123299439454516225508635444330795e+00,
 0.809195011292282707830685510008416e-01,
 0.203614399745527601250860394094021e-01,
 0.143503529630352847915578998531870e-02,
 0.548383219370112079294673495816269e-05,
-0.868372817755744606519803675763747e-01,
 0.104838907776181198021683906161955e+00,
 0.650688354510243512601338850755072e-01,
-0.109723101616399860933869603553794e+00,
-0.580686488620123327717463612303452e-01,
 0.956808312050886646350289556233533e-01,
 0.100784557553338907085916197812580e+00,
 0.309395074916610589504429977183247e-01,
 0.242824209243807414786590932190853e-02,
 0.978558901894334330104995508155214e-05,
-0.103143036606999407451428526747149e+00,
-0.456106725748821438160026151078505e-01,
 0.124862154436005960367595839739761e+00,
-0.151650249138351442085739545481006e-01,
-0.113340160581659684494237570513707e+00,
 0.404899562887544182213413306864840e-01,
 0.111515393423394505236126594173326e+00,
 0.437038953882054036099761943466692e-01,
 0.387220762874661702820856810274088e-02,
 0.165395469629914413203465551394462e-04,
 0.678097915553900433860064347334776e-01,
-0.125931248489451165048486205124328e+00,
 0.393291413412769005211039483195112e-01,
 0.906054886120526449149983116139672e-01,
-0.102455931258902089623615107569010e+00,
-0.271051566392796870104626024898855e-01,
 0.108037113225724795445251075523619e+00,
 0.578142866457571268012709270567303e-01,
 0.587296896903343374381083425324746e-02,
 0.267279971727121398996842655727161e-04,
 0.113005166468397264802422202597412e+00,
-0.175947306885799610392288653087757e-01,
-0.910453962459010499837350102550160e-01,
 0.115902189688534258196577287715018e+00,
-0.303872309591443448330138861723291e-01,
-0.840383383682145547074235083470337e-01,
 0.877753776485928215236808952810611e-01,
 0.719373652113343654450129688749505e-01,
 0.852970540392086683969493067029511e-02,
 0.415861473383921346518614258739168e-04,
-0.483973549317647981982557492031063e-01,
 0.115869522506168584511153001189158e+00,
-0.112255230658661175006581331487574e+00,
 0.380965820729118490627896285936335e-01,
 0.596227790108223371200806333908756e-01,
-0.108449914718427528550155046858785e+00,
 0.520065419283731286987298522758572e-01,
 0.843474119309718918352667435478601e-01,
 0.119238815000363575832164998477156e-01,
 0.626328203318781813429211258758048e-04,
-0.119883647976054006986693274971887e+00,
 0.738267860884645358770154131009982e-01,
 0.578661816778540304618725530500624e-03,
-0.732568766627001209152909065848603e-01,
 0.111137232074921682874640172165202e+00,
-0.896699202966170697621711754141802e-01,
 0.627042104379099224258692967765395e-02,
 0.931241644362441523521610666541997e-01,
 0.161075308080515353251603473697979e-01,
 0.916987547163945961364484526751843e-04,
 0.285778005813276671432490652601853e-01,
-0.793346785547539250421999758592968e-01,
 0.111866074435266419260136895535324e+00,
-0.117167652673015025721489731998498e+00,
 0.907241426740529240079093735988826e-01,
-0.342805107685227227783855147135033e-01,
-0.404565385141268273613294926097547e-01,
 0.964284436025097386308291238195232e-01,
 0.210916347221598144345227553458513e-01,
 0.130951407864077565168468674385082e-03,
 0.123735920249230094501006963169430e+00,
-0.111439892651935436098479656303489e+00,
 0.875136578419303533567705118639979e-01,
-0.533317610978028115924942236301621e-01,
 0.111564294860330157928535530030633e-01,
 0.351943186491005019080061055611030e-01,
-0.777632683633193187473360563395966e-01,
 0.928175245747228692893324647198526e-01,
 0.268356792662644779228962800212687e-01,
 0.182915161220522534428137984062408e-03,
 0.141421932645385341517519419949370e+00,
 0.120347283731971797745924576130352e+00,
 0.914461526662732723081243851617612e-01,
 0.614690811792303375601516041527892e-01,
 0.360125888496124108004110174907640e-01,
 0.179722499390820223703128058848821e-01,
 0.737231901052603251544301992124726e-02,
 0.234617232303017114239670179139759e-02,
 0.523855501515530294786471962039858e-03,
 0.674308463899361594628501800559860e-04,
 0.313225874033426124806718946990429e-05,
 0.961637554009061989650016924674966e-08,
 0.672960379492836480899686378519321e-01,
 0.113667092359463779408844329417292e+00,
 0.127916188362457338094204604531590e+00,
 0.112607158480448178634172516911385e+00,
 0.805702054753635005993984774281186e-01,
 0.468844119996766554653254944526287e-01,
 0.216790300852555896859890392534179e-01,
 0.757323174529133655926090933659261e-02,
 0.181583461633016295774881420502899e-02,
 0.246265867077981887570888217179818e-03,
 0.118480916295045510589275793783652e-04,
 0.370785858236454463603165778403492e-07,
-0.852429495813992929919130604824353e-01,
-0.101214001413800894949338410247666e-01,
 0.681676413186785925317862580145173e-01,
 0.112842478226923885996672327386989e+00,
 0.112395135513262840765595123362521e+00,
 0.812976809664090344974924463519959e-01,
 0.439286075557125528677658465462566e-01,
 0.172198179883304978658857248224289e-01,
 0.449622224304428791562073138431343e-02,
 0.648260219678506798141721289969396e-03,
 0.324801989757627675469794023491114e-04,
 0.103905739740484122811342511833877e-06,
-0.878034218122951007776043247069641e-01,
-0.107523885910526557751597194380910e+00,
-0.475999872795299006880764748946695e-01,
 0.430283750892057239641131461317709e-01,
 0.102418648263076239519782865876308e+00,
 0.105085012286314870734026339873748e+00,
 0.701116688875452651143292004681827e-01,
 0.317269175338385299816109179988559e-01,
 0.916901514358409349680699791750226e-02,
 0.141910854997633943624810802336075e-02,
 0.744697747341094822733628697416405e-04,
 0.244223404899238848939277888002654e-06,
 0.525076669592725127552290146872076e-01,
-0.560389629955992450635315031221547e-01,
-0.106455861951033366882236479761126e+00,
-0.543479832572511100453637564323208e-01,
 0.429748600601357398464447939825723e-01,
 0.100966077274929899437090471010971e+00,
 0.919757786042186330542500212533093e-01,
 0.499753929753584147795160286916103e-01,
 0.162994878971406091847924347602715e-01,
 0.273711533686165056385130772602917e-02,
 0.151331888149517264106629943179147e-03,
 0.510248573528497422038083821449298e-06,
 0.992045636893698361199473709895794e-01,
 0.700765288950801115740516194202343e-01,
-0.462095208175738811418250504188599e-01,
-0.102358189227112067560590052237496e+00,
-0.386022279676946607084279884523721e-01,
 0.617889706023815569015398907203651e-01,
 0.995310955119940221898261608289351e-01,
 0.689980942444621701678253092715143e-01,
 0.260205321162118859915589379131746e-01,
 0.479775358771244504452162963369782e-02,
 0.281225536064575257140577994759298e-03,
 0.977749956469750867533795514951975e-06,
-0.227011435357654775624807967063815e-01,
 0.936754183799391461926135130356752e-01,
 0.645356358258072732674811755179135e-01,
-0.591074380675101919711098405365393e-01,
-0.930507847104847963478744656763710e-01,
-0.169981301523528087701814776369209e-02,
 0.853406793344669453620264440384953e-01,
 0.843147377356435852578227835453425e-01,
 0.379577429075500973289891941523274e-01,
 0.778960425372115135096205121938351e-02,
 0.487272400369431761502903783504249e-03,
 0.175213132906487877183628340731831e-05,
-0.103141528732537160244383136229417e+00,
-0.169548629975946691333027760426708e-01,
 0.976262770408981530627495663894530e-01,
 0.369528369651051705673920973465778e-01,
-0.834042823739153020086865610206770e-01,
-0.629067859611571305632525287397464e-01,
 0.487960608491915293990922203962480e-01,
 0.909428222155823905853732667189785e-01,
 0.511273885403537591829230369589728e-01,
 0.118635744590144018659360122271986e-01,
 0.797545479624604853778333732378874e-03,
 0.297507209256313668973112263297655e-05,
-0.574210539471513392244727356516781e-02,
-0.101132506409023564431262719912836e+00,
 0.146297765038339599161659502825533e-01,
 0.967075510895409172472843273617636e-01,
-0.152096043256465254149804609181950e-01,
-0.920651995652193256236238790764997e-01,
-0.184250100526761040012478646677794e-02,
 0.848798350115399687082811001158220e-01,
 0.639532941987690977665786252982329e-01,
 0.170986926633703603067244727185390e-01,
 0.124466054658326839956384582158746e-02,
 0.483163315680328790403653600182272e-05,
 0.100147430281790290203816805173189e+00,
-0.370732709607743630492761343446853e-01,
-0.847247376170745482031511004279406e-01,
 0.633324006534501909421378801925043e-01,
 0.630653477281627777546225090103888e-01,
-0.732270139594688988980366038773288e-01,
-0.511585353919484450169452467215407e-01,
 0.646274103502127753589736795029501e-01,
 0.744275284329473806828186462434442e-01,
 0.234689295044271983045900939012723e-01,
 0.186492401498530440194382225663297e-02,
 0.755771874076130549687955631507965e-05,
 0.322108188976479897890427489125000e-01,
 0.804969400203515409868977918498494e-01,
-0.804507939138354755810110618634295e-01,
-0.310200632750749034291232029876311e-01,
 0.935964304028794209968235178867379e-01,
-0.153323802275301576223435735591764e-01,
-0.819378808325995563826412660648816e-01,
 0.322267220726888196601924099225358e-01,
 0.804087521169282021028041292460968e-01,
 0.308161376602040792849896945119082e-01,
 0.269701712933275194158066842500528e-02,
 0.114477695312655844511472783243354e-04,
-0.907743500619808057814557080454238e-01,
 0.786770734266453084260317606107127e-01,
 0.218653969806651097792778158906094e-01,
-0.941023454843039605662632501065807e-01,
 0.530341779930512082302043914095954e-01,
 0.504905232450333017451931807281179e-01,
-0.822346522416319087908696447922395e-01,
-0.664733379609729345609787071255531e-02,
 0.800175870576851970197861826494832e-01,
 0.388341855290755954251104572309090e-01,
 0.378022678338717881431280233758796e-02,
 0.168625493666129050349655369594485e-04,
-0.556174507087866547492405377251390e-01,
-0.392035535590160606171498011713684e-01,
 0.965892321115029840999962910591316e-01,
-0.635991369690050894462037864430605e-01,
-0.279261867187070803413398986705577e-01,
 0.873321429749723479308416425653334e-01,
-0.510795493703503155996388807140147e-01,
-0.437312999503413448214451556524605e-01,
 0.720584144885587767250541228716012e-01,
 0.470686070489335928009069643234552e-01,
 0.515226595342114430542611034994851e-02,
 0.242368762933785193548426506174666e-04,
 0.758030523258676664586512405423639e-01,
-0.983260825927948317244402458570740e-01,
 0.517804830411559058009189716459658e-01,
 0.301210754183745343868505634963838e-01,
-0.866918366733854315233910446493474e-01,
 0.737776969833893404321065320717166e-01,
-0.393945356748626594454233860110976e-05,
-0.701942919765127766189839092441226e-01,
 0.563794247893167790383396350239422e-01,
 0.549346309505837799200102528946124e-01,
 0.684675972897665630504320852686708e-02,
 0.340871396276948936050091832345772e-04,
 0.748417343052973962209691315286047e-01,
-0.112619604371724566940285188671154e-01,
-0.568779701615471358525405244995933e-01,
 0.931218236396261433950917311829614e-01,
-0.771830508229819234944634911604658e-01,
 0.172874677260999421915477226116548e-01,
 0.508013814715926462129008603554689e-01,
-0.791185859082221418539484260964586e-01,
 0.340831811665671536821018342110510e-01,
 0.617544150822105792116886354509306e-01,
 0.889050415187926939540615414796286e-02,
 0.470184376829752163813628679125754e-04,
-0.562737869568239016663307136767193e-01,
 0.921498299553894532262830773194774e-01,
-0.944060471568303474565350504820037e-01,
 0.619152157138127082545201767354854e-01,
-0.672550369765069531995679481810402e-02,
-0.491483271331633991428944018233503e-01,
 0.804795294997422862345281773378959e-01,
-0.677034113047066130674730213417901e-01,
 0.752043734897124113512177103600615e-02,
 0.668119130287135408694551353875893e-01,
 0.113006324488842912167754267414345e-01,
 0.637311662332734007163455501525075e-04,
-0.889191036078892522418495955110807e-01,
 0.579214732554819076422185315840218e-01,
-0.142062476739785861107183568949686e-01,
-0.318943417802554071024896703317266e-01,
 0.688077940138896997240303331231238e-01,
-0.860203867960075249916394621951584e-01,
 0.763889442577060414342100649570917e-01,
-0.384602157942241409873879957629028e-01,
-0.199619873793779032289744119468226e-01,
 0.694213258239857951713241617469857e-01,
 0.140818448016371961624499857985548e-01,
 0.850268856702312533550731072542451e-04,
 0.334552627442232538218812000539293e-01,
-0.625818807887824973010861973877256e-01,
 0.834597317392470493085587571118816e-01,
-0.929530844148499370707268743617905e-01,
 0.890300790873475331970895267324352e-01,
-0.710266365457990628156609525583624e-01,
 0.399226080078495677380135645192108e-01,
 0.108215484913031291627337200406307e-02,
-0.444995392701574974452156636845420e-01,
 0.690028595027642398253874927015558e-01,
 0.172238718173917115842893752648431e-01,
 0.111813295259905578242164977343462e-03,
 0.971457918961247815233968814582152e-01,
-0.892682775056632299918667586110074e-01,
 0.764146952645504922576398913819985e-01,
-0.589979057366761958534567570231744e-01,
 0.376039705572291231964474684163463e-01,
-0.130319062658031012121969509712469e-01,
-0.135660435474489955616432205975133e-01,
 0.402094651558803285861878659589962e-01,
-0.623447233903513439033465413917658e-01,
 0.651578320790686475574374523074499e-01,
 0.206993469732268894099629154290642e-01,
 0.145108145962681690387403533022260e-03,
 0.123558268132290118224664991989025e+00,
 0.114678485627803975754502197354190e+00,
 0.986282109589355168157635548766162e-01,
 0.783366849232426809942541423994546e-01,
 0.571492241350605462209245734593602e-01,
 0.379869615180066421885664106217577e-01,
 0.227405272715823870916944050613438e-01,
 0.120579615770791437640786972512380e-01,
 0.552691829759299862743567734242913e-02,
 0.211078228743112608990468785093120e-02,
 0.633389805193155263944854925866237e-03,
 0.134960846493972689959176335995223e-03,
 0.167696831279793125779866634864220e-04,
 0.760347036318311302927961665251375e-06,
 0.230333952354232157670122034667483e-08,
 0.246312899716211500881044743231651e-01,
 0.683409936177210040310948161869733e-01,
 0.972675928103895260775334701895911e-01,
 0.107009441372530045014359681015101e+00,
 0.989455574975188443513377800499499e-01,
 0.789496844276346610538527764249004e-01,
 0.546520265862334144964137769216443e-01,
 0.325898165596430080858958101715510e-01,
 0.164347846039713126616996683155319e-01,
 0.678172055352960069470994136386891e-02,
 0.216501645837398954725596816212803e-02,
 0.484125793670988817021743376063351e-03,
 0.623521754381489177360413948699921e-04,
 0.289671711210282029388827178629072e-05,
 0.889308302169488534602102435146239e-08,
-0.924498006270539436856351813062674e-01,
-0.576226643380435946118413910804975e-01,
-0.210574453509313370403220576227893e-02,
 0.528607372027178944554882941226282e-01,
 0.889532203169061650131785592165980e-01,
 0.982540223974708209010499864418046e-01,
 0.846235620800058008436905541237276e-01,
 0.592378910919510478672990959365318e-01,
 0.337728894812090670139940144317544e-01,
 0.153331062075121846040305573819451e-01,
 0.527276062687486648475065673310039e-02,
 0.124801476020651656459834430159283e-02,
 0.167577279697637071041818114320503e-03,
 0.800649896857250791084142887252561e-05,
 0.249594651970667430360827599164015e-07,
-0.346159355591964422046639196050056e-01,
-0.844258576655417459291799249145563e-01,
-0.877884941402186321823769158137947e-01,
-0.450500689486036350902966018013229e-01,
 0.186945547878003531773246585358460e-01,
 0.711690933723870691014560497077047e-01,
 0.921657371591723395885752936053870e-01,
 0.818208864574044829334282350351837e-01,
 0.548797774850130246572344403100009e-01,
 0.280574905897679957938569372093889e-01,
 0.105453959543142804905656653124304e-01,
 0.266704961379045496225226043034559e-02,
 0.375659056392153662152038850200114e-03,
 0.185285455021589969516972401653503e-04,
 0.587670318272165459535705380455753e-07,
 0.817115527103160947888099810165394e-01,
 0.212666580726372469560806657789347e-01,
-0.538530916029168377227559091256923e-01,
-0.889383123900248112199351903944578e-01,
-0.620350308835675713551830863728034e-01,
 0.378851266775446164329850713193627e-02,
 0.639327635071759123974839815054859e-01,
 0.873604431684050950863368581187484e-01,
 0.737315955819906350446397460070983e-01,
 0.438260730437415672352433524987163e-01,
 0.183242240047262651681957189179929e-01,
 0.500471838321534874598643213458450e-02,
 0.744297735536496256361156986597157e-03,
 0.380460485864182505187215786999957e-04,
 0.123016539451093086263120236006547e-06,
 0.430736478611296720560575462961861e-01,
 0.884019031374077544730304833051493e-01,
 0.511232287985485698340790496082593e-01,
-0.317669784533870909089467370117677e-01,
-0.839538058791717000535786952917709e-01,
-0.630990266960710867478575038851634e-01,
 0.657798427500011295713174984283485e-02,
 0.672108016806233868411157611272280e-01,
 0.825500336705487404488227446037399e-01,
 0.598792155253886232751591756146134e-01,
 0.284831651468963088866436903181275e-01,
 0.850341413307797354645332363170272e-02,
 0.134466075716750143884380620356813e-02,
 0.715225593829569707184439837209921e-04,
 0.236227027120143471635035929299538e-06,
-0.739779308007716352126332259578128e-01,
 0.108008015669352535857677946319846e-01,
 0.821650583567408142113367686484743e-01,
 0.602359362356540745491437606484941e-01,
-0.265494817201705310052670651955308e-01,
-0.817966101752399227731003007412036e-01,
-0.524660799588636990063558653010009e-01,
 0.236624644109506593329509449179614e-01,
 0.748735273403587280145735525551924e-01,
 0.721950437936560458376465395384460e-01,
 0.402664420589853396388058185882035e-01,
 0.133283568665491590791960801470439e-01,
 0.225817415783154537073411768258339e-02,
 0.125508471466497725541567680078440e-03,
 0.424300682213738436081465273109320e-06,
-0.506330453590192952439662057629898e-01,
-0.825668988418616759679617585451392e-01,
-0.277995629103980604560883294961491e-02,
 0.788778204180790014920318766039386e-01,
 0.552304120879716471009946129074596e-01,
-0.372787448907543819142644603709162e-01,
-0.797664267920128835393506529631797e-01,
-0.284205678673680905373087490749217e-01,
 0.489084986994282315885337078564532e-01,
 0.764595969417830393296893680602836e-01,
 0.522502340979483580991423358165916e-01,
 0.195081359512706703990799500879619e-01,
 0.357102097188651559117311249931236e-02,
 0.208299107591833634591600358921434e-03,
 0.722263234466743219100998093034127e-06,
 0.668782042233407438249084913503591e-01,
-0.387107849411575554218628629892361e-01,
-0.822489498856052614457170247908725e-01,
 0.239477157345724924740314239768561e-02,
 0.806890574967224303460880289716779e-01,
 0.360672042379661088196631776545971e-01,
-0.579770136076269281143665162879530e-01,
-0.671105375732881798299491781194620e-01,
 0.954631982514002491652339321333150e-02,
 0.694220622121009370564726293207458e-01,
 0.624724282248949739562829492460457e-01,
 0.268827288858358544925053053879888e-01,
 0.536648979236424612596124967555161e-02,
 0.330025327578204006944536845716017e-03,
 0.117616705186728891997870669971781e-05,
 0.574262031871629824249971880449408e-01,
 0.684110413753739813767238999766489e-01,
-0.429365992255478376537964750118155e-01,
-0.759226342714466429737728338625528e-01,
 0.242179923380278801529908942702099e-01,
 0.789642899113067327163365292793650e-01,
 0.177851093358642780018456648550634e-03,
-0.741219304830669927527353470932744e-01,
-0.322330738608792452403700454240911e-01,
 0.502215266386211310798812739023762e-01,
 0.687361649666002367755618739544140e-01,
 0.350705509844751450455931524062239e-01,
 0.771559310906682930392869633419105e-02,
 0.502659022682072217828758503866049e-03,
 0.184514043053622555386225273516456e-05,
-0.597505442030670878664261964755407e-01,
 0.609734810019694722554264822325116e-01,
 0.577456786342188498172826997012076e-01,
-0.601120685054535157612061507491456e-01,
-0.564340640179042157652182205408720e-01,
 0.557142947706029368403000773236862e-01,
 0.575615704944641103043298772820188e-01,
-0.451870965766704273334045537104241e-01,
-0.628045925540946267359056878205852e-01,
 0.211998279447085538929684294879541e-01,
 0.690462796784907605357159444113771e-01,
 0.434647221797415525887192088628094e-01,
 0.106666406056060131756922269455978e-01,
 0.739918444889564132017074881733288e-03,
 0.280356326058515729594058913439240e-05,
-0.634714381641742097216695438043348e-01,
-0.477386152266768779811140509249933e-01,
 0.739608695284470266322149576032720e-01,
 0.299267367633796984714065752755989e-01,
-0.778991276433369463988063461582048e-01,
-0.143607142489107766650858129559888e-01,
 0.761411620938935684956050411800483e-01,
 0.606673377252239480478870100564891e-02,
-0.710906514133352735555939615419102e-01,
-0.121852914525331555915280160701134e-01,
 0.620947040384799015190797181005679e-01,
 0.512652896632399889604730546199349e-01,
 0.142346760472560420678226856717562e-01,
 0.105706191182528888601120833999119e-02,
 0.414334617608054728956357953769876e-05,
 0.523716662287107668280521719585357e-01,
-0.760892532858549088330754273824775e-01,
-0.173738356134831326610325553184181e-01,
 0.820406580010136999843568515135578e-01,
-0.178354867671409992454872113742161e-01,
-0.716347949097141554574060610636416e-01,
 0.430617022107383637460704958687203e-01,
 0.538233703599587397134075329151894e-01,
-0.534104855914226998676627747019982e-01,
-0.424748274622101871229631864853322e-01,
 0.476835836901539456018956987277459e-01,
 0.575489910272865506215384226759928e-01,
 0.183918398366680726755067287552385e-01,
 0.147056290060065801722472999394056e-02,
 0.597628745742613798555097017074039e-05,
 0.687513340656090140059904530854438e-01,
 0.227676307971255596459419929491231e-01,
-0.828164910590460729468709955925944e-01,
 0.312341737158203877260162875626574e-01,
 0.606076371416729731411413037687415e-01,
-0.667299691667577378509015559413538e-01,
-0.193565878444550471242021139850025e-01,
 0.731167541667902792185574571641256e-01,
-0.157654982025106287345319834857251e-01,
-0.621376922902823438428129766949079e-01,
 0.269725912511751699093469628047444e-01,
 0.613719951260900187632487615320401e-01,
 0.230597802318696305616390147811861e-01,
 0.199766473169419551912411563970606e-02,
 0.843647936776140538373171127488142e-05,
-0.446759558543259219436912766700627e-01,
 0.830267457486166289186785005249139e-01,
-0.269175754145645757560524236652026e-01,
-0.585144351077935167293920633285959e-01,
 0.745265406092371562609905202274879e-01,
-0.379893638338821337537100222894828e-02,
-0.680070754865294999844680063723301e-01,
 0.534062501513885872382437302499782e-01,
 0.277564059988698801697647449612519e-01,
-0.657900004170166396992767132433141e-01,
 0.246336428512761295735713249648363e-02,
 0.618948719564503258687386882993196e-01,
 0.281051898437535844762113707416365e-01,
 0.265581874525776623887685311078821e-02,
 0.116827332942794611051373210092143e-04,
-0.732372072234558541814137784414721e-01,
 0.399015646871662833583961479529464e-02,
 0.681400930101906369607648496584704e-01,
-0.741523553206275097743297508257963e-01,
 0.917776637259775563817569337556499e-02,
 0.621738649261556925935666528484286e-01,
-0.687778875278531946050176320057742e-01,
 0.497441897206058467882620444733726e-02,
 0.601568114453980757678783414304534e-01,
-0.520142375642546185604675736285516e-01,
-0.223142286180193375123152826968592e-01,
 0.585138693366418288857956744291951e-01,
 0.333393852034267308041690085512982e-01,
 0.346201585522147420011762523246348e-02,
 0.159009910535611991482033519998393e-04,
 0.366673587043124023703283521184681e-01,
-0.814269374083326650384421820476350e-01,
 0.628725786771327106982492833811634e-01,
 0.393143896581767694282609149094172e-02,
-0.657092115352432215193255959517289e-01,
 0.731234358967544830344040310087990e-01,
-0.209554732086314254285132450790363e-01,
-0.459834528105831130218303256429337e-01,
 0.683408865182297278140659650953018e-01,
-0.241422469225225735854634438826648e-01,
-0.433824480041486058902862215817664e-01,
 0.509793886105031732925167110754814e-01,
 0.385225814120445145950997860287780e-01,
 0.443202737757147475713152645847682e-02,
 0.213066880286390581089936412563545e-04,
 0.768989133475801965245714412115815e-01,
-0.299276421781772423951283708452050e-01,
-0.347498918327983255088656576127652e-01,
 0.767738978500294577278128283382472e-01,
-0.699880352192053045094520575836056e-01,
 0.193114799919220701961615005446637e-01,
 0.416122369502783632915912961525273e-01,
-0.714230239902254921067714704414774e-01,
 0.487259400927915536133284015918866e-01,
 0.103564548864638369440789448076942e-01,
-0.570642821827792698951084592323668e-01,
 0.394820846909096410216431541750610e-01,
 0.433731573939050566241596500747753e-01,
 0.557957680250402103732470209782960e-02,
 0.281470324541413509137509955833893e-04,
-0.283852088153854471752587842233677e-01,
 0.716770866392171135306979355741444e-01,
-0.809609445563976049842007189064990e-01,
 0.520011496440512516023683367832640e-01,
 0.903429915269788723924962847971607e-03,
-0.515068726526794140569177797385920e-01,
 0.742187721049805143283036863913783e-01,
-0.570841196101929178566996135097142e-01,
 0.911888637380200947964726021431889e-02,
 0.418134923990854246913531601032969e-01,
-0.607515217915515824457863507237020e-01,
 0.246896135204010978771725181144828e-01,
 0.475817861215715972875502424173171e-01,
 0.691546944863863535176702627543577e-02,
 0.367031641718042403628755114965759e-04,
-0.797094917988799442619968795277811e-01,
 0.525676922317050916828316655678433e-01,
-0.780412632607451957535048579454537e-02,
-0.387964141031044596603265069614880e-01,
 0.706389144226404406262449097536707e-01,
-0.761941186920404746780485160349476e-01,
 0.533589253173273483445820497542587e-01,
-0.108163336492128566458278089633766e-01,
-0.341786864216957023184402553034606e-01,
 0.611187672471914971046445641135526e-01,
-0.535234851435426101197298135340256e-01,
 0.772258865738084327087407591715672e-02,
 0.508298523600503894287895824811427e-01,
 0.844671144335908556655514035315267e-02,
 0.472921555565468145575901106307359e-04,
 0.198887630340329046866029836774796e-01,
-0.548906214254327927055281031708630e-01,
 0.766922108069052221780250177566870e-01,
-0.800037857083525520187169217470628e-01,
 0.639945507721776781138616300772450e-01,
-0.326388257605742667881404679157715e-01,
-0.600373471248690614517610119221207e-02,
 0.414415453237496906886979436123872e-01,
-0.630272429776322807477994590313568e-01,
 0.624797243241394129729826574821070e-01,
-0.364653951034609484406810625252388e-01,
-0.993381928331996124686093945434272e-02,
 0.528111372070797327498247384241229e-01,
 0.101756529791690563025150474916014e-01,
 0.602688170750304550790332732523196e-04,
 0.816476425434444209209825680248781e-01,
-0.697834970255523028571500019980308e-01,
 0.478404233336483139464549658078511e-01,
-0.191549496322103702904466113266941e-01,
-0.118231763815262740553805519016461e-01,
 0.401180764630161788608130093025520e-01,
-0.608915888114659876854387573885548e-01,
 0.701075804270710193971797309452167e-01,
-0.651372829534435580994572002803614e-01,
 0.453072849952824431294779090911110e-01,
-0.125900949113242372707329437122829e-01,
-0.265770286873868820394761796262654e-01,
 0.532553551254802736368945985755487e-01,
 0.120991930948281326267626158057989e-01,
 0.760272700930021646364815373834730e-04,
-0.112492378813327944979409498860700e-01,
 0.328091690161800096424084546431771e-01,
-0.516144610987614292674448635566650e-01,
 0.660281514977866924177955944342830e-01,
-0.746994080514330273345288488283124e-01,
 0.766534825902487059602002486890933e-01,
-0.713615688389444927614834712250673e-01,
 0.587935011150968250241590121815857e-01,
-0.394707358809703283695075087162562e-01,
 0.145792016716744740928693955189669e-01,
 0.136516595036086687524534794535610e-01,
-0.404781555377181715319674219632789e-01,
 0.519518246750143495185287421294351e-01,
 0.142080841551140457000665577808976e-01,
 0.950022501004342430649056009565720e-04,
-0.826991554472042483412701865568366e-01,
 0.799891613284484597844868439940589e-01,
-0.746263357061361977629496348960626e-01,
 0.667238769719002781701005777755771e-01,
-0.564491272938458105954970158945775e-01,
 0.440219023630584628860848825432920e-01,
-0.297154555155616385949363987451139e-01,
 0.138661819456025932632139143193192e-01,
 0.309131434713431287524006568246747e-02,
-0.205139682598462666865842945817473e-01,
 0.371958356522022216827469238766211e-01,
-0.500945459388334351122682583745268e-01,
 0.487713727592611240154717832633905e-01,
 0.164863736355987042214528896899817e-01,
 0.117670104476937039268206256405835e-03,
 0.934302742439135052733599203525570e-01,
 0.895677263048430116102607707527961e-01,
 0.822727954240828109755434908379649e-01,
 0.723343256203027412271593598991918e-01,
 0.607717116831835619623051804663378e-01,
 0.486762892494086782211128247238320e-01,
 0.370535769539028877651579558507515e-01,
 0.266956900783147242628135181708712e-01,
 0.181048118519339404342580504758093e-01,
 0.114760919347500096903601499734703e-01,
 0.673498869583700356745193844165133e-02,
 0.361316134880185441181150241229123e-02,
 0.174100080738298313516243602478329e-02,
 0.734783679450652691129149541822513e-03,
 0.261640116174195741468875789464071e-03,
 0.740834873330381574348623314286823e-04,
 0.150685014275489054662642871091340e-04,
 0.180750451521578314991206822668451e-05,
 0.799895753189121726080049740874073e-07,
 0.239082402164317090389251540171120e-09,
 0.140299503388150044464458961789707e-01,
 0.402689038700935372836506036912306e-01,
 0.614013819009223807253775789482591e-01,
 0.751227376891678310020400025292844e-01,
 0.804944060966629308300391678735036e-01,
 0.780066725194114976835915546494641e-01,
 0.693251872998960438802780772903965e-01,
 0.568104847163596574389561300480397e-01,
 0.429520550319524346410247828192919e-01,
 0.298662658710635622220134894783470e-01,
 0.189717323408200691401810691637440e-01,
 0.108913864813365953349626856220426e-01,
 0.556025070853141930879288546545591e-02,
 0.246435184383886113057904835380146e-02,
 0.914121810853118615623235253391457e-03,
 0.267646487302406764036926551655929e-03,
 0.559040783325243985264003890995236e-04,
 0.684124464619098471761578340533657e-05,
 0.306925297659007839581384658858196e-06,
 0.924330347827263622260318514916723e-09,
-0.711586728019977600455819103998254e-01,
-0.556836475806641432918092020779076e-01,
-0.284000937101918841452758799933549e-01,
 0.442918216419918177288504033876374e-02,
 0.357230253862510822519780791866256e-01,
 0.594790369839808974963144983189817e-01,
 0.721923010012621845919387670461636e-01,
 0.734011373568761137381254876850193e-01,
 0.652926287908250621731138591062740e-01,
 0.516217240029744139793551450423004e-01,
 0.363932734326496556016511931869767e-01,
 0.227660543820944707750066858459376e-01,
 0.124802089898848244777514175054991e-01,
 0.586754277824916575976160453311346e-02,
 0.228469818543652751676698139489233e-02,
 0.695711922747021394552127934756636e-03,
 0.149866535744951969496883778988241e-03,
 0.187676608543663664375506089350337e-04,
 0.855323378182142279253245190882719e-06,
 0.259824078386751939787926063782842e-08,
-0.198471920706486800540119426669964e-01,
-0.530677132557000377321482762506511e-01,
-0.691726662320859098411989704778705e-01,
-0.635102470063782232074552685137487e-01,
-0.387298957220540577977290194002404e-01,
-0.331577768853713969808153141217897e-02,
 0.318878764351384793916097689898211e-01,
 0.576186199025493375644500345002228e-01,
 0.690209342473960411260240080117979e-01,
 0.664181633579848838684946940734058e-01,
 0.540727399618129160055787313979518e-01,
 0.378023769514887133177404889158864e-01,
 0.226356330153668584806597277325127e-01,
 0.114250484031885799377160770468391e-01,
 0.471022898573906227827308831448730e-02,
 0.150106675037778440196990771664340e-02,
 0.334985750737141310114748146039576e-03,
 0.430642481567081454751556341828200e-04,
 0.199779660480494526895491342750926e-05,
 0.612817765425122651470903802546387e-08,
 0.643962728097684416360985792355280e-01,
 0.365139047370947235848849215966942e-01,
-0.681382680734032209107012352708151e-02,
-0.466506357988288228756763344268590e-01,
-0.663648223951256901639172404229281e-01,
-0.588583267788625333206927033012346e-01,
-0.288184997623909315503923650025203e-01,
 0.106422626207357095124439038954405e-01,
 0.447146951261209813482453667221378e-01,
 0.633259203145374838509975712219015e-01,
 0.642798481558797226256879175877205e-01,
 0.522452519321583883878692551918816e-01,
 0.349745154079073068755263527240344e-01,
 0.192347683114018999913613131082227e-01,
 0.848017531617401897321911329613365e-02,
 0.284777538939024971492450579154892e-02,
 0.661546845838981753634319701729651e-03,
 0.875899369724627292367478775774687e-04,
 0.414484984721364084146827550962061e-05,
 0.128528364877449446293571769465039e-07,
 0.248999372246564420646545417581999e-01,
 0.607678686355193784927931981976351e-01,
 0.629093466417061284274956978641245e-01,
 0.308136510796647968216739267219767e-01,
-0.171274193555723313705659390616750e-01,
-0.548895615128602889441468093795734e-01,
-0.636290885778246884890811488659538e-01,
-0.410693252865158756916318239242296e-01,
-0.602589498508858340441698594809179e-03,
 0.380252543707411919385770909632309e-01,
 0.598223995776394501856294942471472e-01,
 0.608406585469108995772697706921506e-01,
 0.471385979374957847377902302140403e-01,
 0.287978031170412396470052225868693e-01,
 0.137388622559633640363055493478492e-01,
 0.489927081127601772629976283017514e-02,
 0.119079909260465772640955566809645e-02,
 0.162932650062739189154467885638138e-03,
 0.788143538824632994677039717117968e-05,
 0.247336143111360874449056436915396e-07,
-0.601054618577443643966578261537545e-01,
-0.190672555544318217622010696219459e-01,
 0.345668733413108689310164478504123e-01,
 0.642214320453036143207532732981360e-01,
 0.507230577052879338475615178773761e-01,
 0.456664159459677802895807876824481e-02,
-0.430287796914803736145910006779240e-01,
-0.623705475967624944507455679517670e-01,
-0.441337917011664330198614986218815e-01,
-0.234002266489911560048352992548483e-02,
 0.381742040223761124939832925283717e-01,
 0.586898665574970954976146527406529e-01,
 0.558369464224358973049488607919497e-01,
 0.389227002659303992403711767513581e-01,
 0.203889439841364596358456701633045e-01,
 0.778849813303739879848374808500645e-02,
 0.199166320061610668538192641355739e-02,
 0.282617283998649297320213500037726e-03,
 0.140048861121765359224383941828136e-04,
 0.445286096553131557650983560821629e-07,
-0.295610125226144032993904248797382e-01,
-0.643168996958908811383819095171977e-01,
-0.464154140646328627841793531717560e-01,
 0.871123570260563163435048734773774e-02,
 0.558018963501031080080917051121122e-01,
 0.578481195572702884751577440289617e-01,
 0.152966087620923556639957077501793e-01,
-0.371074429988665137031736233714771e-01,
-0.603150736782290933295872657229625e-01,
-0.406681449630042858926107910031357e-01,
 0.414162815121514332134373192708119e-02,
 0.435041154166346632866293123295968e-01,
 0.577047465738449009938070195731148e-01,
 0.478156723401556553151856735207208e-01,
 0.280218301146491767926155670294619e-01,
 0.115838097002275422474094944565551e-01,
 0.313540052553633489235291036025783e-02,
 0.463128249245935043255325807391407e-03,
 0.235628524007098324066596791281927e-04,
 0.759894794621945108571176847975239e-07,
 0.564858019824013733837223347971161e-01,
 0.220680375388664160935143950634583e-02,
-0.537294298769263208697719930670798e-01,
-0.578955085155694919257992464079071e-01,
-0.759102635231272233220965541288973e-02,
 0.484672944909704788309981839098507e-01,
 0.585993870359162523695407909718977e-01,
 0.161406372531158640714572901159331e-01,
-0.383940777167602958805017050588899e-01,
-0.581550012746562667129438276346856e-01,
-0.308219139531834011531380907203709e-01,
 0.172721424971550724202909830777984e-01,
 0.504347874186203544368466920502579e-01,
 0.533779544867282038539699965225168e-01,
 0.358993829334740492939081269171830e-01,
 0.162557804906188375412858694611280e-01,
 0.468844676269738679086945012925496e-02,
 0.723706807753521202984808647995894e-03,
 0.378896539352238759018356175503914e-04,
 0.124080909954463014017159865394030e-06,
 0.339203940477994068537204599425338e-01,
 0.639680372607777048977385372270366e-01,
 0.231797476977762553745103657163163e-01,
-0.424473923589499700765537424172814e-01,
-0.606764562496010468777739607324329e-01,
-0.132930776521500127534317594188809e-01,
 0.466579149117891856434276907694313e-01,
 0.559262660454802491602214423349211e-01,
 0.817104486333332686775239579566278e-02,
-0.451327379419021648536467448947242e-01,
-0.529746492418141101227750596226523e-01,
-0.135714895501936623778180332156824e-01,
 0.338140368179276639041018888399902e-01,
 0.536701742043311702598079389565904e-01,
 0.430037187538145316628950408306250e-01,
 0.216509488495230430054138543129503e-01,
 0.670387199590399411872159244528082e-02,
 0.108589459401937869517641056573716e-02,
 0.586393504034024693178140704811660e-04,
 0.195222174056265421205390345572818e-06,
-0.530131577240072553494157755873027e-01,
 0.138306779936086855157383724075645e-01,
 0.627557657280669193334608219453636e-01,
 0.326982401434677911869137966495833e-01,
-0.372416680348160398197363415523355e-01,
-0.597820311879376534288168802715209e-01,
-0.933549931444818504106085178000677e-02,
 0.503062456142052604177255779734041e-01,
 0.487545148029242941963523450225455e-01,
-0.789767164741429631333475275375664e-02,
-0.526097786560316305228456636250197e-01,
-0.398548799010218438310498784084881e-01,
 0.102611501829368705178543305011490e-01,
 0.474442519437269155280958834332996e-01,
 0.481591957432635525701146835835451e-01,
 0.274784066761167522616118512866078e-01,
 0.921216862307889530474471079497331e-02,
 0.157280913924371757203118923374071e-02,
 0.878137858095602244675570147925890e-04,
 0.297549990214914736176553327037780e-06,
-0.380014860244853949374312858029099e-01,
-0.599517794393783709887578805712559e-01,
 0.287064357597178505211617310316877e-02,
 0.607929004114800969215526570452840e-01,
 0.329076325850067808982740759541318e-01,
-0.396817154841561068410862708624742e-01,
-0.558663120965965291271486410969534e-01,
 0.364604976498898259984018899726399e-02,
 0.557139540808848642043980857735225e-01,
 0.333804925170079052528485141904678e-01,
-0.292668986615422741297014691395365e-01,
-0.528297384936893938713404401942123e-01,
-0.154252669247661874102645916361519e-01,
 0.346046588277791905349695394763275e-01,
 0.502149335157337826831196307928522e-01,
 0.333140640206502579930256831346715e-01,
 0.122122583603731959614044483934161e-01,
 0.220815406345216405659451752954548e-02,
 0.127783866885688987156420143953103e-03,
 0.441201650295594206908573479168813e-06,
 0.494884528562552189356307224504714e-01,
-0.284837522604998237939165182941914e-01,
-0.611088657621942702973601563587834e-01,
 0.211657376843289232355323882515426e-02,
 0.608250163123733938225824295576256e-01,
 0.245130650573963776250744698298416e-01,
-0.479623875823600343241617239717935e-01,
-0.456781695027207805101523714795261e-01,
 0.239817217635319274320612472369136e-01,
 0.554014056121232726747009893682326e-01,
 0.707474513541250410275032537430967e-02,
-0.476362126548502235150585649007668e-01,
-0.371561551476728298346416696260016e-01,
 0.164574816296830650427988569964761e-01,
 0.482607390709878547165418049686157e-01,
 0.386253595165438594450810997397376e-01,
 0.156637231785858264964169238398162e-01,
 0.301498490705656625950979783838648e-02,
 0.181302397531992130865935167291043e-03,
 0.638617145351406134130491197510050e-06,
 0.418049990599410697404508498100705e-01,
 0.526064991163719584761122317804469e-01,
-0.276651250757158998770325800636659e-01,
-0.592136337241401161628474013846365e-01,
 0.111319739451095203929556521155363e-01,
 0.608041186217967231739849128250580e-01,
 0.669294153310789028697563613287503e-02,
-0.565092016841005621933585434102113e-01,
-0.244086894695603741556279364338294e-01,
 0.452728744050123033191513720459918e-01,
 0.399247870973289170630832053533698e-01,
-0.256263811949238543990953026170971e-01,
-0.492332625853570978825041095152490e-01,
-0.435665540410772691326922104783449e-02,
 0.418376513248569229945267580168880e-01,
 0.428164067144286505675163417437764e-01,
 0.194812830061944437746366605648231e-01,
 0.401427027427566975373351906978180e-02,
 0.251506908204467489075185486305504e-03,
 0.904858787616917410517875656553892e-06,
-0.458277958994518444598556801080864e-01,
 0.411314127777454144395869333563536e-01,
 0.496102551239419961801440523579839e-01,
-0.353847918510333610376077527753538e-01,
-0.525219504887179244745162126265277e-01,
 0.283495350456645335099224502206671e-01,
 0.544835879305810677463456880179879e-01,
-0.196430117275149320476571509417164e-01,
-0.551914185188876875829679660360910e-01,
 0.865417102170203417903838388873368e-02,
 0.538241317367729655344184434644654e-01,
 0.557930054510816575358883127687494e-02,
-0.481322959678902078692245063156193e-01,
-0.242771069662908580168720152223692e-01,
 0.310995176401218047227468628493109e-01,
 0.452904216628746595230052618269122e-01,
 0.235324543907102431119273536751197e-01,
 0.522330591593979135455237078157700e-02,
 0.341911090395874764619798646717469e-03,
 0.125794660571877052004608747432405e-05,
-0.453225662840555534966133939276176e-01,
-0.424058588061331998044909922603868e-01,
 0.474851733624056661101891065743158e-01,
 0.391481045216433385172181394428631e-01,
-0.485578873013802987154919757489253e-01,
-0.360537806718445825956627538256870e-01,
 0.482509881441142475232257293858917e-01,
 0.337338516833664300623788000820966e-01,
-0.462386506518771884045148560526849e-01,
-0.329345477550469078353262389482956e-01,
 0.419334262388330645695245243080458e-01,
 0.345701213253898312279515422578066e-01,
-0.338005322556175672679861944893971e-01,
-0.395255884783480018523459026148134e-01,
 0.168859256117522671016232216386703e-01,
 0.455232239410477191446442733617793e-01,
 0.276391283909423127644604597902441e-01,
 0.665405543501987987072972815144007e-02,
 0.456383669144059056382357947670196e-03,
 0.171920757871378322005645748852102e-05,
 0.419969882880417406421676438053027e-01,
-0.512015634360272712716639481796801e-01,
-0.304000361401182444520884661931641e-01,
 0.570637084012827590459297039114928e-01,
 0.178043283892825016933817766354146e-01,
-0.592431949280255116230470147463357e-01,
-0.582898735581231853394738078915270e-02,
 0.580884253641556062928261852683104e-01,
-0.388799892031201004523905039600983e-02,
-0.546137059226580803180565265003880e-01,
 0.977076928260640162575302754751392e-02,
 0.503605805602500119800877439519541e-01,
-0.998159838134463349241535547248139e-02,
-0.469516082669063411557839104879127e-01,
 0.679558192119610328868164730859810e-03,
 0.431391229406778516268449094405760e-01,
 0.315835130873844214903975190664521e-01,
 0.831150435295865224982790919998198e-02,
 0.599113816803955421104156006023017e-03,
 0.231363657409657392263931414896831e-05,
 0.485421051338559579589914900603082e-01,
 0.299517533865215490494892923992103e-01,
-0.594581324097869175416422652405897e-01,
-0.732213393025062892469108000070354e-02,
 0.610056006860050846779387277486454e-01,
-0.148417326076144041889734477124661e-01,
-0.539202754020716673409769135432878e-01,
 0.324894922257832284848085725341916e-01,
 0.411495346894087108393995180479492e-01,
-0.431874079135991586047470624503649e-01,
-0.270725278571322083686703475117068e-01,
 0.467310839818323493028035693189853e-01,
 0.166380168414642113993575408005315e-01,
-0.448210737061204481545038328833741e-01,
-0.155591431469995824172090483482770e-01,
 0.379790286010326264566841987534463e-01,
 0.351185171312300519121297614837100e-01,
 0.101921233429350416814899781397395e-01,
 0.774562523786171044234092849744603e-03,
 0.307026666633236029959568938124450e-05,
-0.379864400978599418336382640529849e-01,
 0.582310256717426524355522834100062e-01,
 0.664920925838466665779673579403300e-02,
-0.609503539721076793813325328164348e-01,
 0.253343565557824328835487246721402e-01,
 0.463861656723897874713702932998916e-01,
-0.479801621246487470944306378535344e-01,
-0.210505153744254140996528429266120e-01,
 0.559311667433483833255476681723531e-01,
-0.547780937786018237696989444278797e-02,
-0.504053491964052307510385559407497e-01,
 0.248992653108695902451078274442497e-01,
 0.382857632866232553042124493775742e-01,
-0.333416178848601626558738308394100e-01,
-0.296636615776659165343955484868455e-01,
 0.301504803536171897027639361231209e-01,
 0.379822357131835391938262760795866e-01,
 0.122825407085029234829247100090516e-01,
 0.987399690034393231486955160886880e-03,
 0.402254633673138747900494768748956e-05,
-0.514502978589570786170197270947735e-01,
-0.159506610445356971536039424786221e-01,
 0.619435609689955452998418855882276e-01,
-0.263621459749521857700501313450032e-01,
-0.430012934564153983358625163078218e-01,
 0.543384289892379992391690058782128e-01,
 0.603862392507545898354310926632938e-02,
-0.562303057118445538999006914511345e-01,
 0.295274603546926242574389271890852e-01,
 0.354938949344035959418493052530313e-01,
-0.485113331134477421924364668469212e-01,
-0.669283454138478635424121977960834e-02,
 0.484348332777286306296268302966812e-01,
-0.147664557388453483052740288580336e-01,
-0.396004781620068346731956825207122e-01,
 0.200506168597866929099640049879601e-01,
 0.399157759390631481195441957368296e-01,
 0.145585230827868367485559082380189e-01,
 0.124242707704158018268676210991931e-02,
 0.520872089353522038241417576867306e-05,
 0.338001110747670117369663285177688e-01,
-0.619033688544829017451784030778170e-01,
 0.178964153215151796773792353051888e-01,
 0.462835876929541217123639244003699e-01,
-0.554992216951949301181621907655833e-01,
-0.731790129076663603541794520617802e-04,
 0.538656037629264420154504391728046e-01,
-0.424933625615570394810312059787984e-01,
-0.186325689090199526741686698981621e-01,
 0.544801892504776147629522305958129e-01,
-0.222201772451918755473156320085271e-01,
-0.355475943492629977622785382854105e-01,
 0.438822449029157384743102460235813e-01,
 0.698663088931770957725282479924537e-02,
-0.438195165314886811334432508050699e-01,
 0.835585305800315612284102876098720e-02,
 0.406832650924137223283101714160923e-01,
 0.169843565359604534251572510042205e-01,
 0.154448765562007000387922563081855e-02,
 0.667221530384503975516140257927128e-05,
 0.540338864964045950130720665943053e-01,
 0.118032491732792735430569334384891e-02,
-0.547452616087777448783957741785326e-01,
 0.517630522729331792804010797543515e-01,
 0.398656497969257470284737730575438e-02,
-0.542904915459109763805086970826861e-01,
 0.473414265958894175863948175548321e-01,
 0.822967245663142046892902293169221e-02,
-0.528759554247164010730387868311006e-01,
 0.396594153289012213288729406590421e-01,
 0.152675864709040718730859153551172e-01,
-0.500638194162126535451447199836953e-01,
 0.258781793493144926495615088877486e-01,
 0.271450170124773072302343102356758e-01,
-0.415523629496187101147929215303987e-01,
-0.402408087524584737562453449172427e-02,
 0.400925627309398308125736863858203e-01,
 0.195127077983162199832936069867331e-01,
 0.189836229012738979091901232288862e-02,
 0.846201549735796556972038424136807e-05,
-0.294500857420851173854085716155276e-01,
 0.620721280871041422576441063444012e-01,
-0.394609769235340064195421840487234e-01,
-0.177836287097951696600592215223815e-01,
 0.581901999952594744870602794181752e-01,
-0.459166351952292357860112975502540e-01,
-0.694910092568174742792951189185693e-02,
 0.516741227392612233418321828673984e-01,
-0.477097647006257183161859126189281e-01,
 0.175795331712197125947178794823160e-03,
 0.449133850204090460051960606038341e-01,
-0.442870429193244686524301665679384e-01,
-0.116105805160721521018857487789517e-03,
 0.411493115504379670199818649330708e-01,
-0.329988811253436571423925144430756e-01,
-0.160255091667644513950541450806841e-01,
 0.380149820869306704327997246791043e-01,
 0.220850274374582067374782577161799e-01,
 0.230865510554872104806963623946280e-02,
 0.106330450866068386964174870077839e-04,
-0.562804169676961889600220705992737e-01,
 0.135492769177429989848743359761543e-01,
 0.391146855669958700750415520866039e-01,
-0.614263079982898581811454342338788e-01,
 0.366954760563946406026037225949340e-01,
 0.153694545154201735485569265135503e-01,
-0.541262599680702688335577323266274e-01,
 0.498173363340176995551245745177504e-01,
-0.694288065204306662788114442809226e-02,
-0.393538745527538706202259676053895e-01,
 0.515246898479172335203709309978526e-01,
-0.204689376805373579812374543256059e-01,
-0.260320449573129083776156403209699e-01,
 0.457314275970663000133952262917248e-01,
-0.193589428829930304370527210642288e-01,
-0.265366871991572435496163497433192e-01,
 0.344022462482391963764707519541100e-01,
 0.246325341861448997753309157206922e-01,
 0.277966927956542948431143151096336e-02,
 0.132465343502793133647889137266940e-04,
 0.249536668959631523530459313399973e-01,
-0.587718127198316049264551074787784e-01,
 0.547869673789103445728816515866168e-01,
-0.158600489138834033679242122746487e-01,
-0.324923769592442207693097014133243e-01,
 0.588295190692565238569865583947317e-01,
-0.464260986673358586000071670894399e-01,
 0.426807214639751762665434282478135e-02,
 0.389604810143183325879363268181825e-01,
-0.541468335385673551995276736888687e-01,
 0.316364563378756391070278833686267e-01,
 0.117080145058502848785227486020848e-01,
-0.436959651078168821851828268729097e-01,
 0.397356005380081783551210398432437e-01,
-0.269169731049221421312375740783563e-02,
-0.345191603313086355328968682689378e-01,
 0.292989777440864182578598623227914e-01,
 0.270777931082511671114053553185439e-01,
 0.331527537721958668807946630927772e-02,
 0.163703782459142475023845776198858e-04,
 0.581787009066795617398235762609326e-01,
-0.274376362261585411111720282141039e-01,
-0.175446167639725761019045265184708e-01,
 0.526771547033737653625160241365895e-01,
-0.592971709720338117355828248759857e-01,
 0.342674412002116663136743235175358e-01,
 0.834208288668509566962989106345292e-02,
-0.449719177456532771133874230284365e-01,
 0.555781883916428377469029311806039e-01,
-0.348592456656625004892910140050741e-01,
-0.455673119267120503123156846094820e-02,
 0.390157748128246976431256320990888e-01,
-0.474459324408949087195863233725304e-01,
 0.244646379244506144497496628318333e-01,
 0.143842536580774470956186733795714e-01,
-0.391306174200303380252390863483679e-01,
 0.228492510856847416602651942736564e-01,
 0.293368710758390205690550295625843e-01,
 0.391877469088290102194238962573783e-02,
 0.200794801564552333960840912926816e-04,
-0.203316908527994200050025682667745e-01,
 0.522176761049907340327570170817862e-01,
-0.616047864335746979758919135015926e-01,
 0.445987882014799127388936460160070e-01,
-0.883202734139017065373564483800454e-02,
-0.298928726268141489738830314679130e-01,
 0.545752258078670241026300429014824e-01,
-0.545703742798770598791976146096088e-01,
 0.303959706335380859447889770010174e-01,
 0.639470716334046330091353675721336e-02,
-0.383461450062637620943173916684254e-01,
 0.501272929854572011281368297161058e-01,
-0.360080067364424826799389896008531e-01,
 0.344210455016961919127142987264860e-02,
 0.291058929523730167571683873620452e-01,
-0.398339416541506940815296559518839e-01,
 0.152961169791007773667125153305167e-01,
 0.313220224771887936990946269677606e-01,
 0.459276035320254762284949375069485e-02,
 0.244560780323228415566873969644011e-04,
-0.597191200271134558588301621461759e-01,
 0.397354076083302514659186949112240e-01,
-0.661615661349115373709489328466109e-02,
-0.282991883277211443329603306232873e-01,
 0.530905318800962500124086230541230e-01,
-0.593850178433934107869461223834173e-01,
 0.452824572642628437783545759497625e-01,
-0.160553321747532588186936377339897e-01,
-0.176530577807444249094044077544926e-01,
 0.435602536631242945141878670173324e-01,
-0.521668597436457400645330194749119e-01,
 0.403685157327845669958390549330512e-01,
-0.129901872941258654710429361766027e-01,
-0.183764567437673896451939066097661e-01,
 0.390280210287769504935522521070168e-01,
-0.364777966126020448803995260176060e-01,
 0.697351073008921238897907663591842e-02,
 0.329448276928743477239703977987888e-01,
 0.533897924639020841626913065151884e-02,
 0.295900495673065556908717284133773e-04,
 0.156074751709569868302524456647730e-01,
-0.427949924044523361910740336290009e-01,
 0.589540419981722149484263659127539e-01,
-0.599722618595892721332952243969495e-01,
 0.457116464373670254420564636850579e-01,
-0.200592493116452738083120510433154e-01,
-0.100791270873714527780861977944897e-01,
 0.365936183456613397615064912691799e-01,
-0.523354513704360321031342812537447e-01,
 0.530797519001015763659305832641793e-01,
-0.387769327360167978667960339231316e-01,
 0.137550582107279841063422556371018e-01,
 0.142096565062037896714593207535531e-01,
-0.357692128321737383930938547203187e-01,
 0.424519412307949530766904196424590e-01,
-0.293367086948300888289333298638788e-01,
-0.170945048135731207516788317135830e-02,
 0.341196782433187745152185197733762e-01,
 0.615819792935075498613096092123888e-02,
 0.355791930430460107999173531882701e-04,
 0.608938354390165553942136985024491e-01,
-0.497836242308489597241268019198728e-01,
 0.296698620139148598754754233404461e-01,
-0.436956041999094758044458443782342e-02,
-0.213100700274586163869627389391755e-01,
 0.424837803366741660539384917343966e-01,
-0.551250742750739568762322437729720e-01,
 0.568549813327762053086350278995732e-01,
-0.474361290457692837337491746925717e-01,
 0.288779252038848873872126861494075e-01,
-0.512803736355185936144936610524160e-02,
-0.186014827697117317790904923748972e-01,
 0.367631389660038152454066778208325e-01,
-0.445138511328964556003660796282073e-01,
 0.387416391420217245421892082631741e-01,
-0.191029906193026980035871295286067e-01,
-0.102911425984837081621589981326633e-01,
 0.347674771964417312816105415664041e-01,
 0.705007593747406624801745153290433e-02,
 0.425294804934510042586937972519379e-04,
-0.108061116003615840290883862277631e-01,
 0.310387883199255711243190102124569e-01,
-0.473098338759686987863433064489918e-01,
 0.575464933108351227443635063903485e-01,
-0.604552073863355558365862828322417e-01,
 0.556958333084716079715425067117076e-01,
-0.439386214396530175016275387393640e-01,
 0.267965469292438452433842005104230e-01,
-0.664065159977108693804213425904703e-02,
-0.136799316697400826538284805131461e-01,
 0.311805157434803137165253615403978e-01,
-0.431069208148211737482576955494484e-01,
 0.472868238136074833104802162918236e-01,
-0.424406512780423015868927463907074e-01,
 0.284652256123501992556471394185813e-01,
-0.682851363246683248772103259747873e-02,
-0.182858196339958183599513202697893e-01,
 0.348194029075020833807812398813502e-01,
 0.801304987244486557579233037443422e-02,
 0.505552798772905012883154241103266e-04,
-0.616969350294917127159594436718782e-01,
 0.570482109038817831805333018821650e-01,
-0.481232992394429007985423895135114e-01,
 0.356398087279536455982010680918452e-01,
-0.206075095506668345009129756257979e-01,
 0.425386227954884768496253794243569e-02,
 0.120665540299303014844419250150559e-01,
-0.269721011177886692517089007434919e-01,
 0.391563927644998384863038492973565e-01,
-0.474856432102539204349847601312766e-01,
 0.510846644582667255054107738294090e-01,
-0.494071361934663209754844517282461e-01,
 0.422900814708578964801453795616727e-01,
-0.300026959467565821112827885450945e-01,
 0.133286511905036142111983775057152e-01,
 0.617940278350925015068091643975548e-02,
-0.252158882443876498092065022661548e-01,
 0.342205697548705451055856693475257e-01,
 0.904423168658446137067126747869430e-02,
 0.597795430044576141568381453059010e-04,
 0.595395605505135396689535658313842e-02,
-0.176053195026083389763224442950848e-01,
 0.284964478904836198132022460106628e-01,
-0.381515285063918777314990251665982e-01,
 0.461400226229283846608026442464714e-01,
-0.520923450185048161991196124140695e-01,
 0.557132418935715502062977746705945e-01,
-0.567924030782253145184067846463663e-01,
 0.552120187944402274703151031958822e-01,
-0.509512717605522631985059908650219e-01,
 0.440882704449449255563665014241901e-01,
-0.348010300627300757660179010987096e-01,
 0.233718137189107502229208721300083e-01,
-0.102066632896173227629250217776434e-01,
-0.409451955188698304283801127864518e-02,
 0.184976538507518147666512712307460e-01,
-0.306458110828079168816123502812381e-01,
 0.329334123016815149235589190741393e-01,
 0.101393244750054931583772455987031e-01,
 0.703339560390891398748271075017875e-04,
 0.621245373699934913910790433276120e-01,
-0.611478774210334383819709668171932e-01,
 0.592061977679800801024533013561276e-01,
-0.563225760394129007203709714508097e-01,
 0.525311263874802351287453626746232e-01,
-0.478764127894220391830997776735306e-01,
 0.424127024456300223157951023058388e-01,
-0.362031139228136329397874855559759e-01,
 0.293187776538378632587202027436015e-01,
-0.218382699238354587218835321515348e-01,
 0.138479222229207247796115060875534e-01,
-0.544445744750381734476249874182265e-02,
-0.325634396387790081733429771433371e-02,
 0.120947999831922256057189819644834e-01,
-0.207958068274023371438763305706535e-01,
 0.287471864727443969231578280697878e-01,
-0.342150995422849226746051949912254e-01,
 0.309406200131519687583844890860979e-01,
 0.112925589178844237473782790633571e-01,
 0.823590495006860580697226089037976e-04,
 0.750721993268243289329409133908393e-01,
 0.730627335895352624358357864935847e-01,
 0.691890887495288922450051015863014e-01,
 0.637261393489321292552737040465210e-01,
 0.570490711819384240886556834195720e-01,
 0.495944405046156375845345137667531e-01,
 0.418166752802921120408213169582305e-01,
 0.341455438686052506694912552572960e-01,
 0.269497181386210479290989471038530e-01,
 0.205104306999072864432939818907067e-01,
 0.150075742017184609209398012441968e-01,
 0.105186970440231504879693168129837e-01,
 0.702952499959832009313876225971180e-02,
 0.445316700628322508726083880819545e-02,
 0.265425699352842576749756094165771e-02,
 0.147404628274694322008942223420881e-02,
 0.752876709600715963243399221651091e-03,
 0.347405289206781756600929565797619e-03,
 0.141205844706635383463778413082894e-03,
 0.486896900679343410825028585810779e-04,
 0.134220292250198542018034311641615e-04,
 0.267181955222138005161327466573584e-05,
 0.315278729663315635768256148537693e-06,
 0.137954525710338225145026649802296e-07,
 0.409756446619466450562190411799103e-10,
 0.904194691122761856765790041014756e-02,
 0.263657152206785515612776716344472e-01,
 0.415057508122628889264210543030672e-01,
 0.533128058413418341194226945387635e-01,
 0.610459047639302216828459174498282e-01,
 0.644423644773676833876926040586578e-01,
 0.637155277753122987164497841685236e-01,
 0.594846939825056287702478181925060e-01,
 0.526532272516763945838252239527339e-01,
 0.442587371495512634678964218444141e-01,
 0.353221765642000665873848090005654e-01,
 0.267203945824345613917194295281018e-01,
 0.190999296012997184237007528100135e-01,
 0.128403242410744421032346953502384e-01,
 0.806515011868791230705834992483863e-02,
 0.469037647182623195831294964122946e-02,
 0.249432966475409881422295993231332e-02,
 0.119206539755360436219957991659580e-02,
 0.499351600629855629359777162896804e-03,
 0.176629421300626691175567076902157e-03,
 0.497277901187578552527756188510421e-04,
 0.100671156577522407123733684474844e-04,
 0.120318559150826454301455360786688e-05,
 0.531106888252703048744874341420997e-07,
 0.158518090036532142011735019955366e-09,
-0.576472114896022064556486773718390e-01,
-0.495164320347980786748230400910536e-01,
-0.345106916760496405870979123474482e-01,
-0.149021185142465096556945928215642e-01,
 0.644680233776702880440977930427965e-02,
 0.266025474170893389648214108270382e-01,
 0.430628042191747839603677735396640e-01,
 0.541401658072895338568057364650762e-01,
 0.591579033462070751270498618581069e-01,
 0.584348086884076680919905415282598e-01,
 0.530845391428795558676430616500968e-01,
 0.446933694068266645204585930707642e-01,
 0.349600172297680508668574664699654e-01,
 0.253789660983206783038342877572398e-01,
 0.170271591730898244041101170922201e-01,
 0.104806294654359639920572248860933e-01,
 0.585252422627461242339934136514819e-02,
 0.291650299279768517561368838996048e-02,
 0.126593283478983078389639752825914e-02,
 0.461330213861876470592022207128120e-03,
 0.133099039213045157541796514168220e-03,
 0.274743241491744221057321663881633e-04,
 0.333213644919153856531769739743249e-05,
 0.148571793626277681256092692750906e-06,
 0.445906324755729796388549962424103e-09,
-0.128302100920868889456581733601777e-01,
-0.357675575897036884127601383348280e-01,
-0.511688661423811833823891033884743e-01,
-0.559539382799940474516092718442752e-01,
-0.494231414790642410526129864099000e-01,
-0.332987202361608346324716495328216e-01,
-0.111765143590191715678201531853718e-01,
 0.124347879822593670708766193906549e-01,
 0.332083313587763874500668331436287e-01,
 0.479339632162634378633571087310219e-01,
 0.550697653488095293001850722424241e-01,
 0.548150804530709947632492307082305e-01,
 0.487528139911025237881390974972537e-01,
 0.392216063839597456850897154464641e-01,
 0.286298916003727819798193222994161e-01,
 0.189052332453567087023261984424063e-01,
 0.111984881235104992686863747509802e-01,
 0.586441078445352751700459675411550e-02,
 0.265349175641065816866457205673929e-02,
 0.100086919279577618078380768635323e-02,
 0.296971308863231600684354397770950e-03,
 0.626727531574041874891773603365883e-04,
 0.772834336449219841648998110365714e-05,
 0.348518271973623569186490917345413e-06,
 0.105256138790369535624213963805898e-08,
 0.527291649065370010180684668708761e-01,
 0.378266208021511813172715050813511e-01,
 0.123737373187374877030992373840654e-01,
-0.162900330249375119654337685763301e-01,
-0.401030973396316906941352981441997e-01,
-0.526871374646959833871425597549899e-01,
-0.511119501889519379629440325621660e-01,
-0.364913288229788470859101455287062e-01,
-0.133051810832512950517949534151301e-01,
 0.122240742416917653904160342412592e-01,
 0.340873534221256448078793210753077e-01,
 0.481172865282970935973041272721247e-01,
 0.528180408026247562959391677792990e-01,
 0.492569391647471064308047110498459e-01,
 0.402153500990089921114056215097853e-01,
 0.290143116634620456720788803956836e-01,
 0.184644745263652858536845955490237e-01,
 0.102548634590970295117672780258716e-01,
 0.486972979387905333286810169774466e-02,
 0.191080000786775800287126015662560e-02,
 0.585282518719957740778205009889374e-03,
 0.126634348837621823794443830287443e-03,
 0.159086266903884737295306042036170e-04,
 0.726548160790582075550379079792862e-06,
 0.220956207884969191897180908620869e-08,
 0.161579004326286735442677603231079e-01,
 0.425488984607131558726300027600903e-01,
 0.534196699087306087780067361356601e-01,
 0.450313916064992759540549480438394e-01,
 0.207721653488633084649181344537649e-01,
-0.103464589100987975253882488644932e-01,
-0.372629956466391015846019587652451e-01,
-0.509987638438547365675053352898334e-01,
-0.477036798029607596059247248670496e-01,
-0.295273913351476575126615862866518e-01,
-0.319546165843717264977215993126346e-02,
 0.228995946915236936765090875575388e-01,
 0.417852691215532701428161827879714e-01,
 0.499714673157509351322909120091986e-01,
 0.478777286105303273139828946902597e-01,
 0.387745585344331338696411022876056e-01,
 0.269605572500498487777640694153008e-01,
 0.160589216514066674346079108095765e-01,
 0.806600541711983717001362465735071e-02,
 0.331085064839225510170427755458544e-02,
 0.105112369145077843637022814705433e-02,
 0.233841866931423397332395697972344e-03,
 0.299888142889361068302896953682942e-04,
 0.138885561005187710769407246004543e-05,
 0.425623203236298404821944517079493e-08,
-0.498803558980844222170255851910955e-01,
-0.274670751619072849124687337666238e-01,
 0.711456423312074163324189800053318e-02,
 0.382124015284637512208195670979066e-01,
 0.520606245286136148797854629362665e-01,
 0.429895814881588004839689724580849e-01,
 0.156484367218188129351516181776596e-01,
-0.176084643394711566763298750491239e-01,
-0.426474432519792302677353162586034e-01,
-0.497923881971902779824936668547887e-01,
-0.374759464958341870632908527044603e-01,
-0.119191312997709951719602510975980e-01,
 0.165144680504849228677878616529548e-01,
 0.381643209693433278491443962409278e-01,
 0.477452259579765592862105806076345e-01,
 0.454207765250959163351190999039815e-01,
 0.353422527108840943519427037643527e-01,
 0.229025992060645448325482783716724e-01,
 0.122800199484089185690832618842514e-01,
 0.530595362506840539635406346427847e-02,
 0.175359336331642211028709727670746e-02,
 0.402347094946138685972014874469708e-03,
 0.527836829231771750558548887727464e-04,
 0.248224340638939698115172845586431e-05,
 0.767090755936862696690157931672704e-08,
-0.192702736128847634149190049406584e-01,
-0.473079662143282119380949606734496e-01,
-0.496735554556966839953573381576034e-01,
-0.253711386179477354578485469567196e-01,
 0.121231029250006142159038811589954e-01,
 0.425941550633288908838883938128450e-01,
 0.502506642169837977082435000311262e-01,
 0.319492547421136744695304032813392e-01,
-0.189145821907067217893390854274783e-02,
-0.336692491344739252744714744678977e-01,
-0.481863401232832456632123421818940e-01,
-0.399698314276057498275998001249294e-01,
-0.146962864198229470859757331348851e-01,
 0.152201083842734593244022285553897e-01,
 0.376425828492631194601287975317367e-01,
 0.462107574903985146792006610820318e-01,
 0.417861749099305345927110602184114e-01,
 0.300327833873010082838025016431020e-01,
 0.173847792364640385871596795841329e-01,
 0.796364349896804994964108781565054e-02,
 0.275285570278496215996470991015136e-02,
 0.653507857678402445372311236743324e-03,
 0.878909670946542084316933883578591e-04,
 0.420266415064686224703788398109283e-05,
 0.131060094261276213065589916870643e-07,
 0.476549279209713403205146365708859e-01,
 0.172205425830871249029292736242221e-01,
-0.240066891806528588571408986674608e-01,
-0.496466701146592096556763378277442e-01,
-0.437119333852158522993041008204385e-01,
-0.106012927524796750533304335200860e-01,
 0.283671853768195008507294853224503e-01,
 0.490820681496799436727055492437214e-01,
 0.397674032860594583809879736977718e-01,
 0.739569844433989512085527922173074e-02,
-0.279793190189137941242315673369078e-01,
-0.462905876446577202106823664469812e-01,
-0.390246615322907592188121187438718e-01,
-0.124090607167648422609785064414213e-01,
 0.184477173465736270224513635250883e-01,
 0.393860623079981774430209805528091e-01,
 0.443699967520123944955273896370648e-01,
 0.363724407315510415954723387410529e-01,
 0.230569311048781921109045334180920e-01,
 0.112908614440130244204206930822516e-01,
 0.410362432196512151028024787737826e-02,
 0.101135937704250130800719971815497e-02,
 0.139751625828593311710899790980461e-03,
 0.680410411737261739873745025451585e-05,
 0.214274721178660170489138696865572e-07,
 0.222305203663868279338676920981000e-01,
 0.501398086459196514471727469793328e-01,
 0.408628884036709702911909687648281e-01,
 0.162435907858913570017611905017950e-02,
-0.382917627888694434228344692077075e-01,
-0.497502339897999162702160526173278e-01,
-0.252018738893519555615494804523520e-01,
 0.166516978779692537574105356594297e-01,
 0.456171110688854845633088955040430e-01,
 0.421809794431602702117283035716038e-01,
 0.104231684706590080100112494768986e-01,
-0.268123123681682188795486312746607e-01,
-0.452212533025353489643751703799555e-01,
-0.351541406952818039226038184957174e-01,
-0.554571042474898474223525133963688e-02,
 0.250149497530982298452580092958750e-01,
 0.415829479332062162218891968324292e-01,
 0.406722468552307905191303624312037e-01,
 0.287759590418248645233880696222762e-01,
 0.152138885721168882646938629676309e-01,
 0.584752961913470671278018354646105e-02,
 0.150160027519990823892353296630203e-02,
 0.213678853063369002589127995836301e-03,
 0.106075980098307130159187158095520e-04,
 0.337585460073037693996884923326790e-07,
-0.456270583811797113585510923138364e-01,
-0.695233913850273819465034682168358e-02,
 0.373844872399919329966345915677666e-01,
 0.498437501664021189400592220257921e-01,
 0.204056641698426746398088040725214e-01,
-0.255108897763555413494706831473013e-01,
-0.494275625017482122259986984476790e-01,
-0.323774785885332072429285159251000e-01,
 0.103033775352220019307908933849027e-01,
 0.433659198229776712799115703178652e-01,
 0.413229384521410127140890199951319e-01,
 0.784645440657592290707290323230093e-02,
-0.298266804772465560893067214252190e-01,
-0.441678492001486065686024619849143e-01,
-0.276220652802414977717705450394797e-01,
 0.537551948675322133740341663100104e-02,
 0.328355015321630394144409534864732e-01,
 0.417413647329892378423243841876730e-01,
 0.338613456411982090902614854192290e-01,
 0.195652982331237451960509650518170e-01,
 0.800503994332219852994318756753816e-02,
 0.215020273963489008868695128253798e-02,
 0.315849032279721209988100589135744e-03,
 0.160101421470641539363826898693113e-04,
 0.515279539337674633860251283358990e-07,
-0.250586545974752071280883552274818e-01,
-0.510646860825201175043164986240594e-01,
-0.281164444200156201587004833384365e-01,
 0.213948555551077107044225698676549e-01,
 0.499870994595153018303653871346675e-01,
 0.310073213140359226851312553371819e-01,
-0.165769295523120502932090632481283e-01,
-0.476163107847722827932756479375906e-01,
-0.340939010555292031134421056437016e-01,
 0.983007155480408565395544429590237e-02,
 0.433276682015925045627095935153158e-01,
 0.375628760829393961812136605319314e-01,
 0.980134103857013041775767138227491e-04,
-0.354262302593460516455992782283731e-01,
-0.408082501605473523438881011163902e-01,
-0.153495457772278251053856730620263e-01,
 0.188127359818809370289429950973559e-01,
 0.387163093767612732890674415196040e-01,
 0.375482685161960366277056114847885e-01,
 0.240813815197153237476503350020579e-01,
 0.105677677741581320046617272514592e-01,
 0.298168798011504141482832049195317e-02,
 0.453248934926907736315356684743559e-03,
 0.234932575387076266279631541459268e-04,
 0.765223510900984161171262794122861e-07,
 0.436300282965162530732629125718852e-01,
-0.318937618851067764445970226345363e-02,
-0.463368994962100306187520874533852e-01,
-0.396675675906250717128080069198469e-01,
 0.903435473926536153906928408855188e-02,
 0.473777435986026087778787476469554e-01,
 0.352252350559728116567022266167824e-01,
-0.132841829276050517321570265721680e-01,
-0.466959656000861599689736211800356e-01,
-0.314246461603832454338722072956810e-01,
 0.148226740052000616623660898120785e-01,
 0.444563600219402245116522515831220e-01,
 0.297472484581487016221469898587288e-01,
-0.120931339383513274625016611483901e-01,
-0.404772556945079409412404966082500e-01,
-0.320763858265473299238423500168431e-01,
 0.153764186255839242463650021213455e-02,
 0.313100535663447952756880304910746e-01,
 0.390947468105790631046782651760288e-01,
 0.284124593494083664956912569273024e-01,
 0.134920779187906115357061785949571e-01,
 0.401713985438711639668074533666350e-02,
 0.633574911852660745775159812417129e-03,
 0.336309430166503330566998735447052e-04,
 0.110943005296422026787908832703475e-06,
 0.277596449370267752628051719311851e-01,
 0.501165185706452074278552008619764e-01,
 0.128159606835986961700721331399609e-01,
-0.393148594807077482460332697006429e-01,
-0.444123224532243575817064988994111e-01,
 0.268155697666930697335193212219094e-02,
 0.456732552760461208990668651088373e-01,
 0.347253029573839555760064016774005e-01,
-0.157569907443981087486152564404843e-01,
-0.466607912807883846715048149508485e-01,
-0.240738862423849053936887949287720e-01,
 0.241153198681292857861343178745933e-01,
 0.438768548240712153522822457009740e-01,
 0.162317811895755501820854074893903e-01,
-0.263645198062055530228712256324340e-01,
-0.402772669747245242308843024752569e-01,
-0.159225073917277902959961378039201e-01,
 0.199790051726421849862332447630984e-01,
 0.379058464938073938450178644451968e-01,
 0.321469425943912802549065381171209e-01,
 0.166949085727422585998061200913743e-01,
 0.527205907002520557441471078256250e-02,
 0.865081582066816155798084229308869e-03,
 0.470967523610091013308184937268489e-04,
 0.157466583604279585411553559635160e-06,
-0.415884250483627942707051868508539e-01,
 0.129594633587476223689691476053300e-01,
 0.502507863403228650652237757012861e-01,
 0.216572936657920035051639284896374e-01,
-0.347043923268477549855486634651315e-01,
-0.452399329278057126280691774376868e-01,
 0.262273409488280331828390037632258e-02,
 0.459509434244348830964406366123262e-01,
 0.297875173111347795614304304723227e-01,
-0.232310528288548485666195047191732e-01,
-0.454065200991559139312941066449080e-01,
-0.110683179189882587889920442155191e-01,
 0.349273579788633443656347042848221e-01,
 0.373567733021861242518177928371413e-01,
-0.309101755664999909873742644558341e-02,
-0.374504300172066427217683922959679e-01,
-0.300770408932781102818464724615007e-01,
 0.595588657516358030889401318118337e-02,
 0.336550821568519735917174951623212e-01,
 0.348481190356671538189045198943383e-01,
 0.200526098557405571195042409896727e-01,
 0.675418536203078473507273037896493e-02,
 0.115637952541219170276008699081859e-02,
 0.646697283961051001645157005208011e-04,
 0.219309900717465314248283730862663e-06,
-0.303321105477197112915208999141322e-01,
-0.473698158894877661642853413398234e-01,
 0.348145728495273544749998800963821e-02,
 0.488969653411710673781789261068202e-01,
 0.242055058961912787510454861874337e-01,
-0.343368658418404159279358182082236e-01,
-0.433132369181416715449072448655771e-01,
 0.855620817331496075814582295707106e-02,
 0.470369837668954550963086846289954e-01,
 0.194439672503497345608743378537731e-01,
-0.336069237729740619585266963846951e-01,
-0.391525217481485942401473427282224e-01,
 0.744618225852932491774071171169402e-02,
 0.418687644299130210431932141590143e-01,
 0.211852121571645339394354898764012e-01,
-0.241012417822942819238820971731249e-01,
-0.378304263005929846653422177619781e-01,
-0.887897385037466336526770090119745e-02,
 0.263808086182522915839588722517278e-01,
 0.361006783066862743257140321718456e-01,
 0.234034001050699277304506343673146e-01,
 0.846143336284020295283458965385778e-02,
 0.151618366496294529610811781791268e-02,
 0.872389314826272018816508263498629e-04,
 0.300298454970414495507917567049548e-06,
 0.394658353441902116411254027394701e-01,
-0.220817026511028622800874337548705e-01,
-0.489341005624857052816875395296813e-01,
 0.378042470480688930517319361213284e-03,
 0.484678579065822184614648945994411e-01,
 0.211217868124299419792631031811883e-01,
-0.380262838573033282605802415161521e-01,
-0.377732264437564918431497249311279e-01,
 0.196421901171404939013555622040504e-01,
 0.456550839266018687845235552841814e-01,
 0.278490936576369486422454009538729e-02,
-0.423447658345662257353230124796306e-01,
-0.239344962156798652551335153756903e-01,
 0.275707257684715455638674570578934e-01,
 0.376218105660309608993014291624777e-01,
-0.384772146369123284182845677976549e-02,
-0.372956534448247934904340017876127e-01,
-0.222813216218434049547821132264617e-01,
 0.165369738914425575770439131802345e-01,
 0.355622133403495568032449892017380e-01,
 0.265537502732228223377909994523532e-01,
 0.103800977236677018760154348402932e-01,
 0.195301630150921565665815666634260e-02,
 0.115806309755006235034228348514464e-03,
 0.404938548622510444780119120872327e-06,
 0.327717191073229645993913701130215e-01,
 0.429482785490505497024951521240457e-01,
-0.191685643326535626247604299477670e-01,
-0.485626287864772013326986767938816e-01,
 0.361253129720968840099981949054035e-02,
 0.488984643993025137503342448829504e-01,
 0.121808849460378098397684866939049e-01,
-0.437190924675471912765447040959343e-01,
-0.263547887306559159080416894335464e-01,
 0.333082402059094833571198625094495e-01,
 0.369987545758491782319405217205663e-01,
-0.185060965050647911625869904674952e-01,
-0.421999518816994491390551370253933e-01,
 0.787603342126022255862182589071352e-03,
 0.400221164304604202884344548596848e-01,
 0.174721527509765369153054611425874e-01,
-0.283780341671288917012673724037823e-01,
-0.320385372585604989125992939486954e-01,
 0.498321777025234526586455472356374e-02,
 0.330136345602515087420189429166474e-01,
 0.292886535550661188267677598430031e-01,
 0.124834830868331909799853427298367e-01,
 0.247487104967748769296089614694964e-02,
 0.151487673821475170935900556886292e-03,
 0.538492761069112792775261950810056e-06,
-0.372448581961235381456429088395491e-01,
 0.302807014612534462610496142331239e-01,
 0.426584336141716496632045219074067e-01,
-0.220400271850899950990847508392556e-01,
-0.462638177777685559753392369830352e-01,
 0.128200438316509588994383411599658e-01,
 0.478106727566698489573077772133525e-01,
-0.294937193263698737038923923469035e-02,
-0.470401518989987410765689524602722e-01,
-0.719570772826059335690507038958293e-02,
 0.436564871832264635231612684394793e-01,
 0.171531119047391900020376715840824e-01,
-0.372755771968368839503963653741125e-01,
-0.262785523851545413268819791359810e-01,
 0.273336775839238709183945550853753e-01,
 0.334811106082842144716482530435339e-01,
-0.129464458643191122219598817849965e-01,
-0.364036579077466880071815358685737e-01,
-0.709170105470716376475489834037641e-02,
 0.284018320058179232971249860035730e-01,
 0.313853513284379368468571984336089e-01,
 0.147311040040742938793430901696948e-01,
 0.308884613251620677781486197966730e-02,
 0.195511559342761366926689448423604e-03,
 0.707058516306025080747680361828615e-06,
-0.350727385963296531397012196600028e-01,
-0.370256917768301123152839575919084e-01,
 0.327289066201409987189752437379573e-01,
 0.386307216750369345207533367561694e-01,
-0.299318802753947152233012492610482e-01,
-0.399125334529892733212925651967159e-01,
 0.265942629538038604468140170848489e-01,
 0.408733995590379793261097099445021e-01,
-0.225920337581775720953937716032676e-01,
-0.414801517000870553243541546976309e-01,
 0.177438382829549163344391249105585e-01,
 0.416323803607708267174636586962714e-01,
-0.117745993957000551064138923971658e-01,
-0.410840122328790994844448498313026e-01,
 0.425342162627946191008752496845911e-02,
 0.392329963549600992946525847766250e-01,
 0.549279974543643824340752984826203e-02,
-0.344780332215803053889660885981032e-01,
-0.183081255781997145367492300557316e-01,
 0.218681708893616999657130825690507e-01,
 0.326297036459121174248055379106870e-01,
 0.170685787613109750445759932881113e-01,
 0.380075752748984317482281171690160e-02,
 0.249215786729215981960018953306294e-03,
 0.917649459686350959173587815052454e-06,
 0.349183378819042289725045377846403e-01,
-0.373013873276890549203988206816483e-01,
-0.321429372733568545822877780542186e-01,
 0.391385357904722945998045028807301e-01,
 0.291628962938351454814435876478384e-01,
-0.403099410820816547169081466882144e-01,
-0.261999227203022074316010223229253e-01,
 0.407258943128568933143853697074120e-01,
 0.235113438762468102268342856895152e-01,
-0.403161641153942250811067558506014e-01,
-0.213967266064515478867914841642702e-01,
 0.390037034761352585367470493963663e-01,
 0.202143376729848068805319859552482e-01,
-0.366404010272072910217274794068233e-01,
-0.204133203109447254336929409335309e-01,
 0.328376224226544045377205206771046e-01,
 0.225732037278224701199530809544649e-01,
-0.264554227563099453986219889310430e-01,
-0.272790994373163254280683814508922e-01,
 0.137575503587380094166558022354082e-01,
 0.328340511486717295997565451696208e-01,
 0.194283099174533369265231408577902e-01,
 0.461474423316057335271510311123826e-02,
 0.314041557853137356877375947091817e-03,
 0.117827933375263343790722773856430e-05,
 0.372288323577585956192446947327058e-01,
 0.298225809698927039150434918835331e-01,
-0.428735098957883866942235194287168e-01,
-0.212134317543444513009832087246889e-01,
 0.463964246181704846787436167787701e-01,
 0.120948234579454858309060269136502e-01,
-0.476803024718837831245689148157265e-01,
-0.321996451002561022416200277390975e-02,
 0.468714177611619095704563744331435e-01,
-0.467302822021570301858281753349321e-02,
-0.443759596938004594123972232156548e-01,
 0.109198427401016503594616503505295e-01,
 0.408359736932660080614102558496224e-01,
-0.149458584394839051028794760996752e-01,
-0.370913889125169388113775768487078e-01,
 0.161783201655767010004992532148074e-01,
 0.341215185444647750255400129825602e-01,
-0.136630352834080294956031954863391e-01,
-0.328136484039728596658370802230403e-01,
 0.460471528555502958804344353645692e-02,
 0.318551522718124773571825997552262e-01,
 0.217310044947500647435239106825142e-01,
 0.553287935975698574771376677515816e-02,
 0.391524964785978663441007591035654e-03,
 0.149804801878949081874363560508930e-05,
-0.324851062603097088298433285465135e-01,
 0.429227277219362332402256254193880e-01,
 0.184898247145273688288417860904996e-01,
-0.484488419713623063605064135626818e-01,
-0.286717132643805055550267901579707e-02,
 0.485444830490098367954504133216804e-01,
-0.122496635402477816405705080460907e-01,
-0.436175127632549362971016023698449e-01,
 0.249373219269223497306252354190039e-01,
 0.349131679730075319389011465674943e-01,
-0.338505398037869849214262244676626e-01,
-0.242704023086731104084825582722194e-01,
 0.384725620276057520646726349203757e-01,
 0.137944422278440929466458701356907e-01,
-0.391986493597495197946125339269659e-01,
-0.556685270224354883874662201305746e-02,
 0.372234301960640285380721037222164e-01,
 0.162584642802751135454551467828351e-02,
-0.341082892465287581963292108153439e-01,
-0.490290947507089421014906683355190e-02,
 0.296106267484470210099738324078339e-01,
 0.238880401110043660628202040537341e-01,
 0.655480176487131240097497829776605e-02,
 0.483285824681357193710158090020591e-03,
 0.188722938079953648457100204804617e-05,
-0.392335053222780925840467030998605e-01,
-0.216000767217910217404098875948939e-01,
 0.486578209433676776500012080773276e-01,
-0.211169446304515509968695686804408e-03,
-0.479405671703608450132548209868712e-01,
 0.212135302066361907304102361131914e-01,
 0.377531597990979599247222865295887e-01,
-0.368859400253294618569511617588638e-01,
-0.210833921569255597568771904430240e-01,
 0.444242839819496512553864429766883e-01,
 0.225845803764545093391683362256219e-02,
-0.434392128412451381324281286741936e-01,
 0.143966946095797242557468634716059e-01,
 0.359126006631747641425765380723127e-01,
-0.258265432580660313760669345361351e-01,
-0.255003334120393280898526390849911e-01,
 0.310164314843652818213999524806752e-01,
 0.165851239777066370581468779619551e-01,
-0.308945396141266528986704093341984e-01,
-0.139836885810827300127767254760795e-01,
 0.260923169630460403620823203364721e-01,
 0.258046324059145197543812893247541e-01,
 0.767738349636511496348240740686929e-02,
 0.591013797501592193354147394559337e-03,
 0.235736054793443729440534021534809e-05,
 0.299477426590738965303283214909772e-01,
-0.469679582125070769694538123346181e-01,
-0.308099873334264446275420644445225e-02,
 0.482853545649362085073564495763870e-01,
-0.241703244309129951579009597936223e-01,
-0.339481605351285267334650400306598e-01,
 0.425454659543235971835242896678846e-01,
 0.969152762770771179965226906055888e-02,
-0.466080842746917686709021673659677e-01,
 0.156540388830691276333037623402956e-01,
 0.366025153679487032775399361353125e-01,
-0.339150702324846753040615870121830e-01,
-0.178029157349966547049137489677585e-01,
 0.407941336292785916922959231121150e-01,
-0.221293679109737263394526221941641e-02,
-0.372005626208098294744579072264044e-01,
 0.169821202910534136816554933496278e-01,
 0.283661245331929589634671477049540e-01,
-0.235149376209723379160840952156973e-01,
-0.218365062746094166554805698586903e-01,
 0.213751046681754184227730157085054e-01,
 0.273837067861316831278202145662062e-01,
 0.889444832162184049773423284913018e-02,
 0.716451788726943816343074550543936e-03,
 0.292133221608839822146316872322647e-05,
 0.410803741619946529505075059504299e-01,
 0.126517765824092073392230074918109e-01,
-0.495667357646654388491864757075763e-01,
 0.214701481449729326725486920275422e-01,
 0.342661193167157800378434706337769e-01,
-0.444009723239078320686334654882731e-01,
-0.358690724231672525238865103447864e-02,
 0.457230885128855591946520530042371e-01,
-0.268679893098946527912853162892790e-01,
-0.265885995605834969477740058271424e-01,
 0.430829441073664115199536149682903e-01,
-0.195886500223277645544073279055746e-02,
-0.398353129838120210448127217503002e-01,
 0.260391509420331483307769225516065e-01,
 0.222538755481034240436609969975737e-01,
-0.368297605978665492713458138039662e-01,
-0.136562007524498115687641975469384e-02,
 0.346616648367077975110683149638914e-01,
-0.129098911721943778734198111319450e-01,
-0.277242590468809062572513072359619e-01,
 0.156199909372659865183584041010602e-01,
 0.285303269508178265651957422763077e-01,
 0.101965560859017191054661242989413e-01,
 0.861376686831550465687510274359447e-03,
 0.359347956545603593469619823181970e-05,
-0.273113140840422849558433833195146e-01,
 0.493121307120602791176684669215431e-01,
-0.125528334004551086293833381055035e-01,
-0.387863010095926976365552422253444e-01,
 0.434158045363032412136021242015391e-01,
 0.358055768887365824260001196977695e-02,
-0.453678499886597453459099497550354e-01,
 0.321906176595843906906519204410273e-01,
 0.189591303268128629595741115115075e-01,
-0.457948463349014932393961511834562e-01,
 0.167431403502564914128646031681417e-01,
 0.312591085132347155195517143668501e-01,
-0.391135804904662323089866999179129e-01,
-0.127847517723954733003030235473601e-02,
 0.377552667229608296138693392261504e-01,
-0.244460960551896544551241796641611e-01,
-0.193402399170255682656638610982448e-01,
 0.341871098827662138384832322938167e-01,
-0.511205993759299525572392599010690e-03,
-0.310569227003705768472123789506184e-01,
 0.907064727981050684634277064474674e-02,
 0.291564870850512016604428777711543e-01,
 0.115708665416177898847057965199013e-01,
 0.102757753444564906488526887656090e-02,
 0.438967335244085771202151002436411e-05,
-0.427633417482325751667198788228859e-01,
-0.329415806950926745050500422745370e-02,
 0.455591927451388831078193321213595e-01,
-0.384853068993878933999004441314834e-01,
-0.983477117274729903266538213510290e-02,
 0.467960909441529126274654849276836e-01,
-0.327145889578348505539022938629422e-01,
-0.162272078350351262869460754359177e-01,
 0.462891873643906304022296625811501e-01,
-0.253290499842768319428529375510121e-01,
-0.223442142064905611107296096317454e-01,
 0.436525009514541059078627546231383e-01,
-0.160119394300878831379962430185973e-01,
-0.279467509168410018875463919839350e-01,
 0.380096133891399474957752089816882e-01,
-0.405509322167566438225990592980240e-02,
-0.322812847559579749871633638159405e-01,
 0.269728195161311667781737780941454e-01,
 0.119467120550054042872407583715607e-01,
-0.314643517921574393930621453870027e-01,
 0.204314785755200556967138826143000e-02,
 0.291860371193536692926913038908659e-01,
 0.130010946333336893761534433052211e-01,
 0.121683128199589243358489137908857e-02,
 0.532741072544170904555759021950596e-05,
 0.245826240460255335425335659651555e-01,
-0.498872599473402051481989857453965e-01,
 0.268773568611768987803198951513089e-01,
 0.218587119971428625615869749300127e-01,
-0.488936571378679074500804057772448e-01,
 0.283203657502365634458281256928142e-01,
 0.191749041884322483545874363557942e-01,
-0.469883426895143957486253359073287e-01,
 0.285009140155865603216701865417731e-01,
 0.170783451572731231371696220989611e-01,
-0.443139977746389041661496788526921e-01,
 0.269413788190049110821494905492964e-01,
 0.162529714847596527609755991265874e-01,
-0.409940843657537255128252336959565e-01,
 0.228675483571994587011038256136877e-01,
 0.176533830282797953346445492430525e-01,
-0.367820253892826554777295899810842e-01,
 0.143973857986397968712813230574949e-01,
 0.226727304472226246524891085119634e-01,
-0.288495051829711325144098293547840e-01,
-0.509084216694383471753071262592305e-02,
 0.285594838247919842324613971201749e-01,
 0.144675670386286323265125863007970e-01,
 0.143087632243944970868652098641626e-02,
 0.642590529880645847041877578560167e-05,
 0.442767161783068022482555990560251e-01,
-0.614398560161525821636429546085858e-02,
-0.370679396873456223601022539049518e-01,
 0.480349450901002041328162313906842e-01,
-0.175947032984155263137145850906085e-01,
-0.274675235874045835400966446670492e-01,
 0.479977151167414496497819199163829e-01,
-0.266894568703085557898886042152182e-01,
-0.170634949057240552504199425941923e-01,
 0.446209714823405563281214394745073e-01,
-0.323390494738508781872402466390677e-01,
-0.774441682564059701703735364746987e-02,
 0.391424838463620637694645238508999e-01,
-0.340289212242030050283385294424890e-01,
-0.155830817887052450158860494875575e-02,
 0.334917153218216899706995177282213e-01,
-0.316156245740263299336500919430163e-01,
-0.105666752584960897088899883540303e-02,
 0.300858258909006423880489900610830e-01,
-0.234145244764147509555287755070708e-01,
-0.119265659331223532020964067558411e-01,
 0.272383970136703531650930119217576e-01,
 0.159473871008110153184693008544609e-01,
 0.167138405467845509845853408497099e-02,
 0.770617600668488389920188573393940e-05,
-0.217697397549444603582704749668256e-01,
 0.486851584938938538382291062639553e-01,
-0.384999573125657737663546229304377e-01,
-0.796599989747479753252158290588878e-03,
 0.389940501111983549338694996662680e-01,
-0.469874259072132751743978652311757e-01,
 0.191388679556406143105630620747150e-01,
 0.226012716345160493332539073372960e-01,
-0.459356245608243926191628572903291e-01,
 0.333580418843250733525894331367703e-01,
 0.441876699918978016075978465488435e-02,
-0.372213978948697497803437376883538e-01,
 0.394551007074239863893655060222512e-01,
-0.104221031602859832162685899690952e-01,
-0.253283393975405436169581865543366e-01,
 0.381687836063994997972686038225251e-01,
-0.181001092909890414595629017977510e-01,
-0.162842638945629256058428475185468e-01,
 0.330613440207405960745927275322820e-01,
-0.156548760319772154812256620301270e-01,
-0.180529595175814088021789507978238e-01,
 0.252091513489309228372668618181702e-01,
 0.174147122126313578070849344545441e-01,
 0.193992877054669962761157993564896e-02,
 0.919113424769206714875127375239274e-05,
-0.456152957861336899371356654628407e-01,
 0.153326454890123608856891762001699e-01,
 0.249544908603591174790680427128154e-01,
-0.483473693944760206868900378204408e-01,
 0.394156248792640720753162395052072e-01,
-0.450180950164749241380242815494285e-02,
-0.327018321683811738601126728950600e-01,
 0.472725217898110307148178854977312e-01,
-0.299119596602116377163374800721733e-01,
-0.692067278503249249902419060735875e-02,
 0.377567453710029628798998883658194e-01,
-0.417386181934364521922919523403846e-01,
 0.169841841157687765286534144280244e-01,
 0.182780921770793825537801144485443e-01,
-0.387152739639496231926686914990580e-01,
 0.300866260816861584444900608449995e-01,
 0.212481963354807374337432244786904e-03,
-0.281831734369600697789899826076240e-01,
 0.311163710930298581616892551722955e-01,
-0.632031229499172261705244432296928e-02,
-0.230818594290419006829631541811324e-01,
 0.224857510417634430870404321174519e-01,
 0.188411443045687998733237754705827e-01,
 0.223795620509177296043760728617841e-02,
 0.109056688222609628116416757450294e-04,
 0.188816785708043869489395910275543e-01,
-0.457580042952084447298947629699033e-01,
 0.463011228234603442216323532536782e-01,
-0.203542195442004760983430430638981e-01,
-0.169119989897681100890342713805441e-01,
 0.438959035600558461901086319186019e-01,
-0.451808994278956324993792212105716e-01,
 0.204779243981179101962929361465389e-01,
 0.153442697219754249273605199845251e-01,
-0.411439397428572865259263763232785e-01,
 0.420530104086187551530613019253108e-01,
-0.182476699100334491362565773077448e-01,
-0.152964118512930856120425544095934e-01,
 0.379740698270070323366105101825351e-01,
-0.362042620344705751731761393540260e-01,
 0.119187296374073198554407741860657e-01,
 0.184556268162916123712284422335611e-01,
-0.342958607332649107734778040822717e-01,
 0.245019136612568729114862200219099e-01,
 0.365468815265766772263933226573714e-02,
-0.266774421845267946890400219267528e-01,
 0.191115169710688728551915232505563e-01,
 0.201962304556822412812349742583531e-01,
 0.256675113144092837289270563144664e-02,
 0.128767281573647904665751908618057e-04,
 0.467744321018354351427113433163248e-01,
-0.239518050591827661433056999910066e-01,
-0.104236260302273201560293652361430e-01,
 0.394177881536465791015054515159517e-01,
-0.488473033916761304984631495789455e-01,
 0.343055238200695166643069651744942e-01,
-0.329416055818994378656279484132145e-02,
-0.285995340729028567834449878968013e-01,
 0.455590725792946537877135986298228e-01,
-0.394797314847155957681766839430404e-01,
 0.139905482087676024546628532441436e-01,
 0.174882310543279152221165542166335e-01,
-0.386925563256842149034138317155839e-01,
 0.389531648985787962609044795513058e-01,
-0.187978578616366990529168610775517e-01,
-0.102485393238119867011535303532139e-01,
 0.317404486118524774062800295773816e-01,
-0.333321354387247481252890399534289e-01,
 0.141833414432839411499054163078348e-01,
 0.132445491771664698741945048179841e-01,
-0.285835452452843080339080125781270e-01,
 0.151594625135683329078922055066441e-01,
 0.214480668901592018293930998594883e-01,
 0.292740441907387941691061655333895e-02,
 0.151333993079680975423929801969529e-04,
-0.159281890342986592658514770361678e-01,
 0.412167002510986771583432782485788e-01,
-0.495393644323457285171358516511541e-01,
 0.375647122304762017419501673609155e-01,
-0.103966591536555607906414434331335e-01,
-0.205892122052503852562988302242420e-01,
 0.425326710524719835583057042239338e-01,
-0.464866562859275443487729835708418e-01,
 0.311525039639915821183166622893181e-01,
-0.337337129746642895959503041125040e-02,
-0.248305978977768523979189999611488e-01,
 0.414384818465976844788148862152825e-01,
-0.396193623096892679661318466254769e-01,
 0.207084488767659553578459663263587e-01,
 0.635161735232858159860158704112317e-02,
-0.289430612713636138122483513477855e-01,
 0.364759120928804955849037234997792e-01,
-0.254581286432911628701311434885344e-01,
 0.170799850146052569482656813249697e-02,
 0.214406372294972240395534656632023e-01,
-0.286465504006812261497742503064899e-01,
 0.107312437591769740035346653060760e-01,
 0.225639958679771937913725870605825e-01,
 0.332078000710689908228155047739242e-02,
 0.177069832211561080366454598472777e-04,
-0.477500777274551538061207380570231e-01,
 0.317023428524299988085399402051608e-01,
-0.509433458480320862902325838830058e-02,
-0.229922002149226616921554832867588e-01,
 0.430133817391144407635482757331363e-01,
-0.482513301018621490864702540083082e-01,
 0.371199655685151929887772610113602e-01,
-0.136881748242209754948698842364072e-01,
-0.137640369608610266776098518015510e-01,
 0.356583736972778373948262527046475e-01,
-0.444882757240932696067793920809873e-01,
 0.374676021367827321855279579911343e-01,
-0.175196707545250818745883819277064e-01,
-0.776382653450164140627450282569553e-02,
 0.288616248847960107653420891169650e-01,
-0.378293035158261392272423846773314e-01,
 0.313566476676565954384568200071238e-01,
-0.122839265083907640697788536624031e-01,
-0.110227516433244853186969234517489e-01,
 0.273618672802343756480719334534374e-01,
-0.268317418023337356664036079568567e-01,
 0.595463910984596732011725153810134e-02,
 0.235113813479154252404733321416446e-01,
 0.374748227154809205009791274208127e-02,
 0.206310657474262268084443769258434e-04,
 0.129195898893021179257133543665440e-01,
-0.352271289605622811852166293660154e-01,
 0.479196816278300214613795575282011e-01,
-0.475807052071127860349484667686173e-01,
 0.344041331437285465499360035425832e-01,
-0.121311746062309670725493914031549e-01,
-0.130033064210464601389547741978421e-01,
 0.340221193573767872397112766689548e-01,
-0.451662611662670152638838397966595e-01,
 0.435152904820882209489303905993095e-01,
-0.298098683520870061983124709414617e-01,
 0.823824550351614627702985147429024e-02,
 0.147641999334709488239932450910224e-01,
-0.323770877230887639681218979957038e-01,
 0.394048069243287949283476748804429e-01,
-0.338711917600718348686715537835693e-01,
 0.177416448732250985626829214248848e-01,
 0.345478399700806471412868730852189e-02,
-0.220435599829327042525300586016382e-01,
 0.303551747670827360432546475538614e-01,
-0.232314715930801392088589008789458e-01,
 0.979589127706828815304009432033822e-03,
 0.242584459209387617460181500065692e-01,
 0.420782428680437218571562049160655e-02,
 0.239415838841286150050034404891220e-04,
 0.485388233304865860132171257257738e-01,
-0.383162366619777343009118477354363e-01,
 0.200821727352132855759437661656624e-01,
 0.222404453024820878917892060412759e-02,
-0.237955072712437040998190996542854e-01,
 0.400085103884642821715309850574818e-01,
-0.474340797939824762037522116302609e-01,
 0.445886883146589752783414334770284e-01,
-0.322585684231568264864568704232715e-01,
 0.133241284749530842557275606987755e-01,
 0.788057246212797111973949450550232e-02,
-0.265368943883538369682736599635817e-01,
 0.384303126255791012652766295488987e-01,
-0.409219681727940402335973598123110e-01,
 0.335892671898991470830992037416867e-01,
-0.183906555663236598860264911929807e-01,
-0.690478198176246455478183983933134e-03,
 0.184598053247785726138580216607114e-01,
-0.296324415846348779959886843798365e-01,
 0.300738000436405786275489124325929e-01,
-0.180640496465058311900552702648798e-01,
-0.402709401726421821644123568862126e-02,
 0.247751485040412515719403915606362e-01,
 0.470179749647028436566267733042776e-02,
 0.276768867385341290577187176450859e-04,
-0.986664566672119999555687226076488e-02,
 0.280044604858922317585595561550989e-01,
-0.416191280387868327030445322112747e-01,
 0.485294519905050214210461487204397e-01,
-0.476608600463182765213093816248341e-01,
 0.392229175702698604136011522138168e-01,
-0.246744332143078662866556667192956e-01,
 0.648111134118683955613113739710210e-02,
 0.122953010971454702873495262489192e-01,
-0.285096924043299512548474697335720e-01,
 0.394644515472105367344465270123860e-01,
-0.433714790781514131818316668770864e-01,
 0.396690255555163316450194071673531e-01,
-0.291401675014603241267543674978859e-01,
 0.138114886772353256215021689010573e-01,
 0.335435603433637420033101426992766e-02,
-0.189261615449573054038891760558100e-01,
 0.295626330395060053464918543700288e-01,
-0.325864169577447003753683138931455e-01,
 0.265234635858798499046633409580046e-01,
-0.116629780534843768054529383792292e-01,
-0.888816130531602538637647187658174e-02,
 0.250340797640687379311436368313697e-01,
 0.522904331615348283131382919547144e-02,
 0.318777907025012678320112816690100e-04,
-0.491379263672356664700860660799594e-01,
 0.435657063656881729918130290723628e-01,
-0.330820466726079953766304721519323e-01,
 0.189298759428038349411799453999864e-01,
-0.278622080583723861142722892139156e-02,
-0.134379088548581800411944616091852e-01,
 0.278262258985735409597200607802399e-01,
-0.386876060988901153944465910284813e-01,
 0.447611519686850729605073616539667e-01,
-0.453716783109774662984602840200819e-01,
 0.405171510398061748137934731132717e-01,
-0.308775011543031324786674931577970e-01,
 0.177433583454945025086948570286405e-01,
-0.287252191497391501132241825719173e-02,
-0.117097222562775595644978236721524e-01,
 0.239441258451844804498983796074418e-01,
-0.319795119794829661239183610144856e-01,
 0.343995827532413997722925780525555e-01,
-0.304201336160672843128393971165566e-01,
 0.200699268898608657112755821563666e-01,
-0.445692099389641572778469436344727e-02,
-0.134232487865623916939803048035902e-01,
 0.250113503116725982267457325038799e-01,
 0.578882719142824140374845266707153e-02,
 0.365876283372167397405668211767896e-04,
 0.678046590072165752097742589131464e-02,
-0.198057280510905999489778078921742e-01,
 0.312671594549982666064589096068072e-01,
-0.402627440521639117418655775382529e-01,
 0.460896737566079893797690346750640e-01,
-0.483017671508555836297913925974443e-01,
 0.467467262524662314061463644560811e-01,
-0.415802896635633819047453223926268e-01,
 0.332561466034146903031816949186675e-01,
-0.224923712292594900562566405572163e-01,
 0.102169709492228753639011705703787e-01,
 0.250323056269715500415782158018307e-02,
-0.145448705558815166543014130897746e-01,
 0.248151577672039210504636345076331e-01,
-0.323372426141576668139310270316959e-01,
 0.363277419118469708653688401303771e-01,
-0.362617849446209029086407262688738e-01,
 0.319242355280364264900238745714890e-01,
-0.234534805394754888132007043676392e-01,
 0.114057673633070543371432241890674e-01,
 0.305842623463159260844505152294027e-02,
-0.174567689730770298416142998545716e-01,
 0.246874454561946672762171208439892e-01,
 0.638001562669157415608323892159144e-02,
 0.418522904749983914999242475183256e-04,
 0.495453332040948125736949073795765e-01,
-0.472709729920481342224027856236050e-01,
 0.428354116150276567362801060455901e-01,
-0.364596174952267964722874699498295e-01,
 0.284619231171914894617441926545808e-01,
-0.192429801429304516550780526619436e-01,
 0.926682961177654669833375757305478e-02,
 0.961013402720760768411281468686435e-03,
-0.109174194558683175718636342490592e-01,
 0.200863158416127516624382798942734e-01,
-0.279830006014158311324367149899104e-01,
 0.341769561324114997532341586399313e-01,
-0.383121115009391656812194573458526e-01,
 0.401236750879373011227090986880549e-01,
-0.394509454765997967266479476723287e-01,
 0.362460005098510407893036267707700e-01,
-0.305791206078975155286755248040720e-01,
 0.226439836848926356478634164466081e-01,
-0.127714862627614518440594601504374e-01,
 0.147894977490434797579470299916705e-02,
 0.103546946376942859811993954395100e-01,
-0.208260073925484984425363149829444e-01,
 0.240480198133575375083076827690049e-01,
 0.700105668556502797333169835683523e-02,
 0.477202610556699210530379308083634e-04,
-0.367241998113872980370485548471352e-02,
 0.109209403823809053579030733144557e-01,
-0.178827801572608632510717801851236e-01,
 0.243743557263164033594451362293309e-01,
-0.302231916881714803012026733695853e-01,
 0.352719746531003149351807121518843e-01,
-0.393822285981227905399805554816363e-01,
 0.424375191635262387747355393418050e-01,
-0.443461059457989957866700539350744e-01,
 0.450429763960381173907496875036005e-01,
-0.444912133776871773358044425004745e-01,
 0.426826732522982502883718568801909e-01,
-0.396379885381325878202861528253772e-01,
 0.354059730998848026039948881121553e-01,
-0.300626336669663229042386493991028e-01,
 0.237102687447305884328830256254001e-01,
-0.164778048782602900432931321727334e-01,
 0.852527121044883585553687439078329e-02,
-0.603086469264533361188968084115989e-04,
-0.860961382698413366165414892186951e-02,
 0.169089658039446655216282442104156e-01,
-0.233890305911221695093127999150362e-01,
 0.230846053582530586881166586847019e-01,
 0.764996444048610206003555289531234e-02,
 0.542426442275332115987245765814954e-04,
-0.497596957287866707771997667907349e-01,
 0.493063618829774221753607422971967e-01,
-0.484032394999683199863124569411113e-01,
 0.470573765510619113770527303838523e-01,
-0.452792382972949292637156925240655e-01,
 0.430825790494080290392511246206511e-01,
-0.404842709305809278414226905926021e-01,
 0.375040896993948571861687348954708e-01,
-0.341644583017023523947125222768130e-01,
 0.304901503943940262166585519700316e-01,
-0.265079597976754964122230959233907e-01,
 0.222463502724634569532399735769929e-01,
-0.177351189913178209028321699296721e-01,
 0.130051499910769342491530265649035e-01,
-0.808843297467718884280085202122735e-02,
 0.301875916844835591794788322469286e-02,
 0.216590407482756264705957927281983e-02,
-0.741679497139360302625146552142245e-02,
 0.126564589070654993869291114322670e-01,
-0.177284268534359452749131721148305e-01,
 0.222427982730541876935589128946319e-01,
-0.250320020640005430538767498789352e-01,
 0.217952076418274129971074314152012e-01,
 0.832430781832533506748339365302208e-02,
 0.614731832574592223265086248013228e-04,
 0.612921909728347368402213874684600e-01,
 0.596321582149808525811907641851973e-01,
 0.569556090125363155684622871530058e-01,
 0.533908726620335297389634572716882e-01,
 0.491044052798523302594824213664409e-01,
 0.442890381575203812169061591192508e-01,
 0.391507734122627643913707076533294e-01,
 0.338952771884641124454626229629465e-01,
 0.287152064805047874370708983680860e-01,
 0.237793794264507186118356963101245e-01,
 0.192245772990216151253693391822021e-01,
 0.151504761423872030751296760718408e-01,
 0.116178806439201314824237066312990e-01,
 0.865010875427966084197253428067772e-02,
 0.623708764992140300886480842509845e-02,
 0.434149923650309085511530198016941e-02,
 0.290617712094256589113382219104286e-02,
 0.186191654507721154087372952639396e-02,
 0.113491224495192308070164148371583e-02,
 0.653173692747989121533010389709472e-03,
 0.351460864882730284019951049130408e-03,
 0.174508840692710953108017318219980e-03,
 0.785362542737848922598147085888182e-04,
 0.312326358864861070938799978260071e-04,
 0.105699053015168344879230871303288e-04,
 0.286856220074091316690365498844899e-05,
 0.563872516253534520113810794976733e-06,
 0.659018164601987293732281554278225e-07,
 0.286455881446997287862498134863365e-08,
 0.847712674866653352601611113572807e-11,
 0.121205488678664046117004436863030e-01,
 0.235537890963412558024409026875287e-01,
 0.336715067718356505805020100768864e-01,
 0.419572265887671929235314490358717e-01,
 0.480467727489527306965944278843186e-01,
 0.517526375568780320480844970622237e-01,
 0.530700632262505704502836376978416e-01,
 0.521649711924189021748734268803791e-01,
 0.493460129640733691623273488345704e-01,
 0.450247836485111077454221582560027e-01,
 0.396694102562579339624559285064597e-01,
 0.337571693319423636843546282319510e-01,
 0.277314777258817503722143266248528e-01,
 0.219676195939547370433001929693206e-01,
 0.167500967953044219130011151964993e-01,
 0.122627555960544407588454543690713e-01,
 0.859111084019548965721478796230958e-02,
 0.573480405125326339592387341089007e-02,
 0.362708624694996381778706315088999e-02,
 0.215772240689463415301830418808717e-02,
 0.119579320669761906074926565710185e-02,
 0.609451539145811909342851799429165e-03,
 0.280633746028817901392538784345254e-03,
 0.113839816814479671515623908299577e-03,
 0.391825107222828912336319159138501e-04,
 0.107840877660152084572122349683971e-04,
 0.214385167639764903621351329538230e-05,
 0.252714068919423413119695972365308e-06,
 0.110497292288220432978085146165172e-07,
 0.328066740379690373189713148156312e-10,
-0.458908861102190469276050614977457e-01,
-0.392158634362728934739453882360379e-01,
-0.288686583849753738942602175541040e-01,
-0.159101842873369507172115102245062e-01,
-0.163045141148023941908273569930829e-02,
 0.126112241945928632125955389747709e-01,
 0.255476662771263754604949981921024e-01,
 0.361443254329505164300347100845911e-01,
 0.437003623819254691001202540900131e-01,
 0.478988011281342536261124466223217e-01,
 0.488026238514875892422555791273603e-01,
 0.468020757352032542859139432435471e-01,
 0.425254276481957417317523529083423e-01,
 0.367299131787130610338920154522167e-01,
 0.301909250860852037786744497951710e-01,
 0.236058245493198002296050737219319e-01,
 0.175244412591307016198028813180401e-01,
 0.123125007483278591482687177368148e-01,
 0.814799545300514018231739443690553e-02,
 0.504507709301543660475670198241729e-02,
 0.289629991070839481136472080080731e-02,
 0.152248902566589402459395640474346e-02,
 0.720172012090403029497878187465727e-03,
 0.298978226948665189453761615828934e-03,
 0.104941176744518168228872604567187e-03,
 0.293547161497451434555591153046472e-04,
 0.591180774061666717163718139849003e-05,
 0.703753943557995351777020585789581e-06,
 0.309796435773950459736065697530756e-07,
 0.923231193958058123054153235481096e-10,
-0.170379356763514382470742029613515e-01,
-0.316254952967880132078829012498545e-01,
-0.416987716104902506308463173434154e-01,
-0.458976331733722124750129209537229e-01,
-0.437583965694545595308555600361869e-01,
-0.357508470886514453453863103739384e-01,
-0.231586305903377770845578064582638e-01,
-0.783137829653106013069745384985966e-02,
 0.814042313534217086274066013015686e-02,
 0.227652295571631920179622053421153e-01,
 0.344436933437066704655474498814715e-01,
 0.421675197139796275789273896145619e-01,
 0.455979361591968395796772688716031e-01,
 0.450230511805755033383114388873641e-01,
 0.412165263034401494724980072922935e-01,
 0.352363371268086275470484038723701e-01,
 0.282091134478667841241392529639491e-01,
 0.211421382984982179607254191058424e-01,
 0.147933584675911523533391475923183e-01,
 0.961322252430273843633216026813842e-02,
 0.575506817877322157678457423363952e-02,
 0.313705777729411169224974088574466e-02,
 0.153100456544283715814683770810708e-02,
 0.652767476593625231997753452392551e-03,
 0.234316382259001890448660043539468e-03,
 0.667651227219145127805091716127095e-04,
 0.136450581261424265078013933836686e-04,
 0.164246540846806246800755770956496e-05,
 0.728549255807629600068021292596925e-07,
 0.218032246389156470529326773066437e-09,
 0.405967565785028156451801352968355e-01,
 0.284947693536267173096998008951940e-01,
 0.110119040956206536139786901379200e-01,
-0.842530268893674597660521489996942e-02,
-0.260834515660539348546843408763393e-01,
-0.386855675035649858325436834338369e-01,
-0.440478828745134949087640924554019e-01,
-0.414555295556550044442518643297510e-01,
-0.317088067690587102924220865105116e-01,
-0.168511286309952413911626891347334e-01,
 0.337933267249766262958154672142674e-03,
 0.169534590820846229958267667112366e-01,
 0.305361088219717172231735391586541e-01,
 0.394823864905040548882682641431338e-01,
 0.432234628138602587960665471762014e-01,
 0.421638823884882565626647802415700e-01,
 0.374287858205717995770199996352541e-01,
 0.305066468289779897828400785939833e-01,
 0.228861982201912527292196590538493e-01,
 0.157713910641524371216408427427059e-01,
 0.992425659566146232090176312368361e-02,
 0.564418320531441614529275817225089e-02,
 0.285575353850751575466984757677114e-02,
 0.125525394535358377258753238007719e-02,
 0.462180829369778260193544779858906e-03,
 0.134457631026016952793133850929131e-03,
 0.279360585158346264538613048800024e-04,
 0.340461926044927941307094829604928e-05,
 0.152305174530061663894128380449514e-06,
 0.457940415809023816982301920049610e-09,
 0.212072817600086129318273325958205e-01,
 0.371202083962430491649666454946558e-01,
 0.438167687861045870941485790654829e-01,
 0.397433916302780952105935767510505e-01,
 0.260679786463968509576033748548290e-01,
 0.630840758140246251913139375586041e-02,
-0.146400318864331567346116112687391e-01,
-0.317915461667322371070885776332674e-01,
-0.413097780892786636694399453401259e-01,
-0.413720607443102086828937817390272e-01,
-0.324542596986225434411598452861926e-01,
-0.170077414996521635687226194816408e-01,
 0.132954093418844629957867997428979e-02,
 0.187303655950941640143540140427701e-01,
 0.320957908204513744731113543527495e-01,
 0.396603930399917781043429623947455e-01,
 0.411693957809732113177456697756670e-01,
 0.376479809946723695413396119033583e-01,
 0.308949160976504144247266042008651e-01,
 0.228890218554717170565007705196144e-01,
 0.152880209277609035642982308717350e-01,
 0.913729511500589267400056941314887e-02,
 0.481905990491064129785587094200625e-02,
 0.219282110072600847306001562545756e-02,
 0.830809874326294646986269859754163e-03,
 0.247375750515107532087932890653469e-03,
 0.523458905051431516279779522366369e-04,
 0.646754954851176005729028160429117e-05,
 0.292044123526528972659049190072243e-06,
 0.882633833094832934308657631841443e-09,
-0.367975891149435064650458566862969e-01,
-0.188467468919670670286382720072506e-01,
 0.477363626164293456887178109469773e-02,
 0.267625689438880803628941207022411e-01,
 0.404437075358310544750829036456707e-01,
 0.418378250353186406948347136126937e-01,
 0.308136406581895518864390614986090e-01,
 0.109780624427590617912093958455925e-01,
-0.116001944520112183238760131710188e-01,
-0.303584269345427749582908130416806e-01,
-0.402247333673835907715007418853171e-01,
-0.389871119554451803858589338213039e-01,
-0.276670610570789317939659375158051e-01,
-0.987844498041882457735150534562917e-02,
 0.951367403488166224357644872265614e-02,
 0.259263177373398275029946453171841e-01,
 0.362770900832163532368744530264126e-01,
 0.395545913308595814105867251542846e-01,
 0.366716556954828691018971462721864e-01,
 0.297813892165082423780261111005636e-01,
 0.213826498983203168265806932898258e-01,
 0.135481246976150304453920381091099e-01,
 0.749482220297882080708166674061003e-02,
 0.354669729474567210048258489973990e-02,
 0.138747124916483933115075587839110e-02,
 0.423904981909928748325961824715571e-03,
 0.915284324951530927540063646405846e-04,
 0.114801658105650401988322472907166e-04,
 0.523723243064533264061478147159481e-06,
 0.159176003233054706655136032097424e-08,
-0.249383522757476623796290497117949e-01,
-0.405722811699178400238601461424333e-01,
-0.411387971228531554262151110145830e-01,
-0.265699026643755185374872531720926e-01,
-0.243298084661939817208719948167546e-02,
 0.222779384584386229699029540230684e-01,
 0.385896296724490523384015945312918e-01,
 0.408671330090448450919914032111425e-01,
 0.287372591128570038710113796390722e-01,
 0.695774043032813477540757839375495e-02,
-0.165939821470409138736858600195506e-01,
-0.339236119570885525075429036322459e-01,
-0.397120958626540271829185280608023e-01,
-0.328798541456117775684692330310144e-01,
-0.164750640542540958738258370510766e-01,
 0.387378837115842159789659377672476e-02,
 0.221836463556851638579853999707931e-01,
 0.341081609794987667747026681555599e-01,
 0.380079351748865008661897127682168e-01,
 0.348782342717038595311701633004013e-01,
 0.273911966283029342927761402815819e-01,
 0.186009201125558532841613047967696e-01,
 0.108729193565503502561063237949529e-01,
 0.537856640891448722392698384733936e-02,
 0.218059362337190090860969383022488e-02,
 0.685450691193986030210892474113317e-03,
 0.151310798612030004749460060871448e-03,
 0.192925437816871652033203344169400e-04,
 0.889967366381512492385672075164087e-06,
 0.272144765617214909880969441652907e-08,
 0.333170191369191093322255733299308e-01,
 0.935334263638452055961296531034856e-02,
-0.185791511175557637982549722560320e-01,
-0.382061136626323732115174576520179e-01,
-0.410739426948094398822692349850944e-01,
-0.262140055518540160426147211570364e-01,
-0.379585930145836862133286250349172e-03,
 0.251443306915302882045660605128865e-01,
 0.395982026586647503037930461876948e-01,
 0.373356251301399086313914469581584e-01,
 0.199411553624077329217112288690516e-01,
-0.488960812723594486654246712706961e-02,
-0.269752197039352756004369390590039e-01,
-0.379940496852745426828377678673787e-01,
-0.346139666079219450528022256726254e-01,
-0.192089624769730289714542853346206e-01,
 0.183447531540280798559831660890947e-02,
 0.211645029425074222363117466858402e-01,
 0.333715479521301141165887690457605e-01,
 0.365665171894775437303322477796726e-01,
 0.322341353052612071809259926369990e-01,
 0.238011662958589448407441949026994e-01,
 0.148320957999506182593783614925437e-01,
 0.771493866558155762117339594522591e-02,
 0.325467551774699242826414343685262e-02,
 0.105561523747923708350100103174618e-02,
 0.238716045668085842138023210408160e-03,
 0.309837276158569181254290156413954e-04,
 0.144656837091656660035907117285176e-05,
 0.445268767375079692384950832202209e-08,
 0.282965574116531625589813448244340e-01,
 0.420801858437244583926718462822065e-01,
 0.343730694895739170328492789232633e-01,
 0.928761164249104768304624552402132e-02,
-0.202328577372894527150758677487160e-01,
-0.392129343492056979548706737519601e-01,
-0.383348437934411989449436782549442e-01,
-0.184991581339454966928767230600287e-01,
 0.998766898054283529121639547689138e-02,
 0.329491272778406156535830945550801e-01,
 0.395312418014636802157575310500124e-01,
 0.273098825053753629045823517573777e-01,
 0.289283964379328864565252952715127e-02,
-0.219191936943282184418191193624517e-01,
-0.361042167963601177503355304814646e-01,
-0.343722456529865066507489122550000e-01,
-0.188168016583977817972503507558914e-01,
 0.308190054995437404589333401526230e-02,
 0.225870006284510949556866337791156e-01,
 0.336366192776960668553267310059289e-01,
 0.347540613796740010726970471971444e-01,
 0.284699023334776500298047812426389e-01,
 0.191257798860819090993390603403731e-01,
 0.105324495255654827084492066509846e-01,
 0.464428034407397567124928075124160e-02,
 0.155896733543259931570986547508629e-02,
 0.361915925920173110009439496805048e-03,
 0.478863002495508817457265955110747e-04,
 0.226480788005574096270378510881849e-05,
 0.702069276329294355792922061273354e-08,
-0.298259952460385139721267713590346e-01,
 0.627056187885745465720026877710733e-05,
 0.296839920105985725149240664788481e-01,
 0.418392433451148667458689394819272e-01,
 0.295884786179210014900012220075679e-01,
 0.406450078795977523800819335626348e-03,
-0.285570484102432988348338098627233e-01,
-0.407125251848934611981106287684471e-01,
-0.295957173783693835387461540065860e-01,
-0.217915136348881049286971486803535e-02,
 0.257007783395058028570926403326761e-01,
 0.387142675667492696727038067899122e-01,
 0.305157992907831415600929461966043e-01,
 0.657261026777193445918257416318156e-02,
-0.197612890331825327897028276552997e-01,
-0.350626829329163930824449323526411e-01,
-0.327847050900658597462186146099478e-01,
-0.156408140177484505236801855238699e-01,
 0.719613672939853492632978428121278e-02,
 0.257127471235250585578316939924336e-01,
 0.339654722457586886140454019320681e-01,
 0.318261249365321503208050710784165e-01,
 0.233863864351287370233079856644905e-01,
 0.137465029380290678985093315302293e-01,
 0.636763109116520671332786859523194e-02,
 0.221943172888549743746240470335206e-02,
 0.530104170935503117633631653913182e-03,
 0.716062544813893379416500135960270e-04,
 0.343387549616023003364189189020692e-05,
 0.107252460364144735418782525299188e-07,
-0.312912551572608993192229219746410e-01,
-0.416934345105749450021386300863442e-01,
-0.243769738652053884335894185227671e-01,
 0.893625276607482201713990250934071e-02,
 0.360192714174023282759901598378006e-01,
 0.391158251291084080563417356058215e-01,
 0.166283615326742908490801585895089e-01,
-0.162365659210992806788217866831637e-01,
-0.379540296608658988062328438323525e-01,
-0.349236369058746282624728623425363e-01,
-0.991216520074840736679486719532665e-02,
 0.205280595843199593973965386235080e-01,
 0.373179120082748121704508841097945e-01,
 0.309268551646289740098571748182600e-01,
 0.649593669053720756640993875708988e-02,
-0.205785087752640191052623540656965e-01,
-0.348222594523867102909989799260306e-01,
-0.296304838794009371205916407735509e-01,
-0.969252259794603415264095485199081e-02,
 0.135312405307752477297415971195861e-01,
 0.293174106586713868845429299355119e-01,
 0.331092061052687330078986710156325e-01,
 0.271511860295524719243024670309878e-01,
 0.172055914170121936879039645247410e-01,
 0.842044759722887871598410806116077e-02,
 0.305836385695903920598573062469682e-02,
 0.753284291372579238273791993863452e-03,
 0.104036723143403256171992280538694e-03,
 0.506334509094817132603316094682766e-05,
 0.159420449835437290629461538384095e-07,
 0.262128394991072545788003801565599e-01,
-0.902278445178622694750090839794530e-02,
-0.373502255129356795211815113019767e-01,
-0.376783595452187165823661425640268e-01,
-0.100688404652213948926140166342976e-01,
 0.246220607013201778503984718002769e-01,
 0.406824343357627850283656704758512e-01,
 0.267237903417821978673738653272299e-01,
-0.633787635954998308634059013419393e-02,
-0.340418914734299089338710157649567e-01,
-0.367052110624620240766674731063846e-01,
-0.133792393442724905358745525547673e-01,
 0.184850604837697126500581572268986e-01,
 0.364791771540044035047504646766469e-01,
 0.291635296088668500019360487637678e-01,
 0.297386557226152362569359235758523e-02,
-0.238236806202048519763204619709465e-01,
-0.344450884134114298889933376812958e-01,
-0.241017777673504832301323000987916e-01,
-0.104499264177763517361432203884028e-02,
 0.209042367633316130675965360073307e-01,
 0.317229337479437051522724961781528e-01,
 0.299094196277957469389988930707424e-01,
 0.206931847267455117023512637827399e-01,
 0.107707419900443862841884141850473e-01,
 0.409240942478236938998659549061002e-02,
 0.104197002095561663461701046500623e-02,
 0.147364202447908836114149242428963e-03,
 0.728566817701292523839727839705477e-05,
 0.231350413556612403535985814320988e-07,
 0.339141267240068430287115344106150e-01,
 0.394915822496278955422264825813600e-01,
 0.122098847550177926498158932927143e-01,
-0.249892387299367263450953692434673e-01,
-0.411522014671064864521170147136232e-01,
-0.232158555386938045599311376012854e-01,
 0.134793081263831386313093477551141e-01,
 0.385102486134657444146448840822425e-01,
 0.317891422556427156325775481957073e-01,
-0.364549816048146331895709676321161e-03,
-0.313574818890453690689939334079060e-01,
-0.366173544955838160377451717165840e-01,
-0.130769855625123437693283571113061e-01,
 0.196706851897235848885380026361482e-01,
 0.361559934076307793330503083632164e-01,
 0.250187420162850746196313375552195e-01,
-0.371347370044369813112786584527457e-02,
-0.282770462720075633072110544032016e-01,
-0.322759768286427245495547479041017e-01,
-0.153240494190777377761709428322133e-01,
 0.956284762854501577758826491392121e-02,
 0.273750841777649252178963347573186e-01,
 0.311665146422717337311505415716480e-01,
 0.239383065983978874664474652402387e-01,
 0.133552902321507536089742337594391e-01,
 0.533127973301313278055001230956012e-02,
 0.140680114001718379232320895779499e-02,
 0.204066027557803106923445264397694e-03,
 0.102586404027004067257111945175648e-04,
 0.328697726321264245266526968486241e-07,
-0.224439837267085834461842629510661e-01,
 0.174161211249382543668396601155794e-01,
 0.410577078756127931553004651010686e-01,
 0.268505509006776674152689870137653e-01,
-0.117751337450191382332389433872303e-01,
-0.391717665746168019256134255787952e-01,
-0.305779637406108044643284323126119e-01,
 0.549178887826486239849782910969790e-02,
 0.358670266769550582092206559909930e-01,
 0.334871458946220450526446818118194e-01,
 0.149370640114601326122603175802781e-02,
-0.308444094645572372772885012367768e-01,
-0.352786863395806543144011258309538e-01,
-0.925108883271257822203108270385479e-02,
 0.235381958096276109799248225804805e-01,
 0.352840635931585914120408789486847e-01,
 0.177561949709857726276379633135391e-01,
-0.128707480582249560291461723672188e-01,
-0.318481976018111863663958893365960e-01,
-0.263553829633929683766248476473954e-01,
-0.318560206835123383074664087761136e-02,
 0.201833907240964922670698236087794e-01,
 0.305176616999250777665678318878822e-01,
 0.266348897376077296105889697282815e-01,
 0.160784228368178391012400417206033e-01,
 0.677559751853248184126098311261666e-02,
 0.185808227504706990606918008432389e-02,
 0.276898031787296007408310049568484e-03,
 0.141677947916672728030358490610810e-04,
 0.458276757450791454043740770281008e-07,
-0.361512047643196404148055248664020e-01,
-0.356065840233286644369560478070695e-01,
 0.921477511082845910760380953442349e-03,
 0.362428643876582427876830071770099e-01,
 0.347587654210832556490161322729818e-01,
-0.154773491108517120529286147283545e-02,
-0.357472322490802608785196925915431e-01,
-0.337824318791149631887459970616400e-01,
 0.155894194706349373698247832748647e-02,
 0.345200962053741476828522536080582e-01,
 0.328756288139890619243969518834367e-01,
-0.571576055175216110126487126588302e-03,
-0.323463640954237572851918077098497e-01,
-0.322377541375467596271983214618065e-01,
-0.193845961224968529641072861273138e-02,
 0.287831064102553614743257473777376e-01,
 0.319734191888750012744614967073857e-01,
 0.679298501764293875806281913977013e-02,
-0.227023833329230239416720619320241e-01,
-0.316472464683923279410498951171178e-01,
-0.153582612491882794472983220646052e-01,
 0.107215911900061894161338729652662e-01,
 0.277203044766755541654619558480177e-01,
 0.284688308467240698093029295562859e-01,
 0.188136264406668346153343155802369e-01,
 0.841498252168418217140168875315637e-02,
 0.240525715471877537811069035258731e-02,
 0.368871537441097475383289621631936e-03,
 0.192286735248687500406395114518543e-04,
 0.628213688330543898503810249223881e-07,
 0.185202950628718249615838681434777e-01,
-0.248950560620511456102530063584608e-01,
-0.406052472834947580172434561577112e-01,
-0.114624927502453744942386496229842e-01,
 0.299792535667168567292865249960183e-01,
 0.380485024338630471942748859317109e-01,
 0.445665576049730750784255466143400e-02,
-0.333692348451577885286088537877930e-01,
-0.342895766853433441620825815047315e-01,
 0.171695065039291623352041555099936e-02,
 0.349144224898234893214237194259941e-01,
 0.300407171337001558356379314994142e-01,
-0.629010047281598815685931969175554e-02,
-0.347171023115132249350411243338218e-01,
-0.262398872326566430080399141585914e-01,
 0.847919731114710089431503859874676e-02,
 0.330322325877288434411569551438452e-01,
 0.240478373430139486828693842629546e-01,
-0.720946926182907346537353344751774e-02,
-0.298468673525625919242884141779467e-01,
-0.248667578748884921088105793841862e-01,
-0.120382469597190969239916309001656e-04,
 0.227538472375744934489473993249683e-01,
 0.291505062004701022835845984650803e-01,
 0.214082287857601663260197478311667e-01,
 0.102265491861757589863319681640963e-01,
 0.305633546736758325124718540569291e-02,
 0.483219082719852277547112068145224e-03,
 0.256889288681031538305357231949881e-04,
 0.848108819793676584374501388192623e-07,
 0.379876919415345003648403148634144e-01,
 0.302275740206404705034755465271266e-01,
-0.137562737222316277265763346254908e-01,
-0.409377312485462088393329645409532e-01,
-0.189539432068052413452385359417736e-01,
 0.253196617195920673008039108129039e-01,
 0.388572180757362478244966325408485e-01,
 0.620377046507397044383371492695818e-02,
-0.330665731670843838847822932592818e-01,
-0.326648883993829142978174825138797e-01,
 0.576463399180863448859476147747602e-02,
 0.363657796276739870622251044196599e-01,
 0.242075580103045454712411656176905e-01,
-0.150221711175079641341356172969001e-01,
-0.357543924254564482836188715312873e-01,
-0.158776305731815051223053569733383e-01,
 0.203563347346942053026843549187486e-01,
 0.328413927324931008447281060496454e-01,
 0.103035756914760695322584552814962e-01,
-0.211889415790809706091844877908986e-01,
-0.299400622059157790391616702898365e-01,
-0.107078520822196215741445581000460e-01,
 0.158554621648605026834714783100228e-01,
 0.284495124674549388043289852411721e-01,
 0.236911691538439859282196990072319e-01,
 0.121739796919973096045406914114229e-01,
 0.381729366664549978502928978872389e-02,
 0.623348579741336455606702642135765e-03,
 0.338302033082438550314139033299238e-04,
 0.112920813156355024199177083063560e-06,
-0.144601491031621814191287401021534e-01,
 0.311880103899656663336482404273863e-01,
 0.361491748392365673467170106295286e-01,
-0.572538593947111844931441462549514e-02,
-0.397798086513692842818590704775537e-01,
-0.221603220500393912172650301455899e-01,
 0.236421878440918449494970795023711e-01,
 0.383618680271500679916431297916135e-01,
 0.388915237343842444949083813893631e-02,
-0.346908361063535089673292523444245e-01,
-0.284688249727806480027685567397721e-01,
 0.132531124100302873331927693816804e-01,
 0.370822636548203991482786086177055e-01,
 0.142725687708551568109585998812290e-01,
-0.250373608914696633570396980313081e-01,
-0.323674554681634780872737213892518e-01,
-0.847735113578411159131296597347323e-03,
 0.299597284022577488412167575792505e-01,
 0.247467497481061728498250863177468e-01,
-0.756443261195457193689425875155658e-02,
-0.295235791226477354871916239166500e-01,
-0.199281539566263234385541660392072e-01,
 0.752336559016917694750115901739335e-02,
 0.262277156324790912877339198949244e-01,
 0.254835572042322809076207873971412e-01,
 0.142073136228896116102123344794323e-01,
 0.469147457830144111064773112113035e-02,
 0.792785916852606855972139519278814e-03,
 0.439697390950560724908276135004234e-04,
 0.148458380948256482452276610742468e-06,
-0.394102416222415050671476819321938e-01,
-0.235977947224183148570772435367230e-01,
 0.250866098783251810434376695311311e-01,
 0.384389608407486407007439136850345e-01,
-0.179583546891261995425105183667826e-02,
-0.390260271326773640622109502380303e-01,
-0.217125212457403812094286158473107e-01,
 0.252115310819664028029892065914612e-01,
 0.365355284982048063466918751893399e-01,
-0.235338062560485543513016807572026e-02,
-0.369924098798026980605980758990366e-01,
-0.205667489360236742243499631416241e-01,
 0.229302483404864628487548877048214e-01,
 0.342604980805736737702270219156864e-01,
-0.985980697848673893164687714065000e-04,
-0.327858720096791103698776985877131e-01,
-0.216364970674788734520187229782904e-01,
 0.163203242195235982915376694021160e-01,
 0.317854292677020395423721205066055e-01,
 0.784420133164618348543232570112475e-02,
-0.235603296852987936634610565492138e-01,
-0.263340655303805163091858859300611e-01,
-0.151690406651727575566021963743875e-02,
 0.224664418695487050473230823230409e-01,
 0.266114228114559820735812824334591e-01,
 0.162635615707971655136025471430445e-01,
 0.567901326042328226479549243153038e-02,
 0.995106356402397530840739983843589e-03,
 0.564616682052044413366486207297628e-04,
 0.192932341068252982148822334218344e-06,
 0.102917795958996506496654282918859e-01,
-0.360626500786710296678350233276344e-01,
-0.281970111828274123591481581986930e-01,
 0.217410356729142856181150253483204e-01,
 0.387566178352480258821908816890150e-01,
-0.208817795341122698144692807678250e-02,
-0.392055575142644658658456200135658e-01,
-0.176857232960018454873647222935377e-01,
 0.294349633195102914812440046780571e-01,
 0.322471984443475633203467334555878e-01,
-0.121002563383073486639671437774807e-01,
-0.375388979966659177589718047009230e-01,
-0.795456749044818415347659913279230e-02,
 0.319281635630232779950334862090867e-01,
 0.248397062801659702033812395273604e-01,
-0.168449930328600091367662026979216e-01,
-0.330933997675248598148148250727090e-01,
-0.321817736895678104642425752428194e-02,
 0.292125072402264719974915600266950e-01,
 0.212971765396172528109210872742698e-01,
-0.130789519261800821682008548207244e-01,
-0.289181472958668068313978370156310e-01,
-0.103823674080099227689408850214636e-01,
 0.172838992704797892089501207261868e-01,
 0.269197872773040565606726269934991e-01,
 0.182682053649011591572343110583195e-01,
 0.677631808259152224906608341305615e-02,
 0.123385542860286558254918332375208e-02,
 0.716979352556238800697511270245220e-04,
 0.248072729224693470927947593857308e-06,
 0.404081742644301869588682135353805e-01,
 0.160069930616890729419249825763938e-01,
-0.338632756109164465448841217902222e-01,
-0.293136516408709082193874796080737e-01,
 0.218737228018720967287342502955034e-01,
 0.376548526374206627465728429112545e-01,
-0.647402946528168127796815660420281e-02,
-0.395739819143139898750186935193814e-01,
-0.967536884586829108128822761558574e-02,
 0.346819229624462237603300415236993e-01,
 0.236953938526723012434070226801848e-01,
-0.237672064785812098868958541377083e-01,
-0.329385263335823598206314683198323e-01,
 0.874694080162402753712613839181480e-02,
 0.354239508743800071693739106326969e-01,
 0.752379050098543327911401954805607e-02,
-0.302127937350344816762742047719019e-01,
-0.215362598271234962213707639632618e-01,
 0.177181424693619347754219560288946e-01,
 0.294276602697218775339323590008627e-01,
-0.519283278282660462396756540046930e-04,
-0.272002290945915895396871265651233e-01,
-0.181321223653937133104615366754523e-01,
 0.109396895764083504228888471169265e-01,
 0.262869709188893930956802883566459e-01,
 0.201375946995673482261741973128730e-01,
 0.797563627795259094625767220153873e-02,
 0.151246037405829259399597635818962e-02,
 0.901088080922990652255798759011285e-04,
 0.315851388534378328355550441714402e-06,
-0.604934886824933992249498481477863e-02,
 0.393395959458372401802032286028843e-01,
 0.175638764778423752078286951799580e-01,
-0.338785568548080760107781905929160e-01,
-0.273733678663240953291714428240449e-01,
 0.253427923961507912211632909340431e-01,
 0.344959776969049682952371540290364e-01,
-0.145399756081511475596679690052115e-01,
-0.381706363377670866497004707583270e-01,
 0.252277334488028262032409871225062e-02,
 0.379239299740329075594369210699988e-01,
 0.947872780734226504351942615751128e-02,
-0.336195117661694477161133965935667e-01,
-0.201285845773691465216872110741221e-01,
 0.254920282188616112481868953446964e-01,
 0.280478854053515497400746838131402e-01,
-0.141770433744476897024057353094452e-01,
-0.318507875896951515783197542651629e-01,
 0.772254042411513008517534870869106e-03,
 0.301272867012523576332209198789932e-01,
 0.129619508868887523326886873908633e-01,
-0.213471108665003979537064376579542e-01,
-0.238848067878252963782137905815470e-01,
 0.382450014592627209052241009568484e-02,
 0.246379187062047420279032756744635e-01,
 0.217821917556771669672826837597011e-01,
 0.926473219686589975493912720043890e-02,
 0.183413353263516893207284843299278e-02,
 0.112162933657544528944541217428008e-03,
 0.398503235433930764769648370095777e-06,
-0.409741803651362185898745137514251e-01,
-0.778081721023292280208180394555171e-02,
 0.392883652989162294472843064288784e-01,
 0.152160093946819895290583211259480e-01,
-0.359732416923611159367459460050718e-01,
-0.219657364714861027548502403947218e-01,
 0.311408626867598897722352310221888e-01,
 0.277007445433093120383145887510212e-01,
-0.249572654992869279700644756488820e-01,
-0.321050067551303021276248482978678e-01,
 0.176412000727443260352710677447697e-01,
 0.348745528238088589684263572068264e-01,
-0.946509485654361315722901271223754e-02,
-0.357098585781226445257699871537796e-01,
 0.762616836436566991640757808749068e-03,
 0.342972301340017191817101427286086e-01,
 0.804662950861155793163540258554814e-02,
-0.302709609543091993713458803615399e-01,
-0.163870124076675665462647601927070e-01,
 0.231425681514070587388234996481588e-01,
 0.233257540460971959163366369615751e-01,
-0.121879318377472081942739855848644e-01,
-0.269385233485773032010127556514640e-01,
-0.356535868703006977120381188047852e-02,
 0.219552933822601863229021082178309e-01,
 0.231105555379452177254116175566459e-01,
 0.106267041169347690291092354004476e-01,
 0.220176940511357567244150876728713e-02,
 0.138366900276360962175222297379879e-03,
 0.498548213911205736324590554726158e-06,
 0.177067816809850365154711508268094e-02,
-0.409019880435057287480925014050894e-01,
-0.529844220595628314229522759779683e-02,
 0.401306174117187511184057828060405e-01,
 0.878497049181428260920952752914993e-02,
-0.388320047244386210732344686002054e-01,
-0.122010682304781415632191362660681e-01,
 0.369845346591308469129606097459777e-01,
 0.155142882933437460438739968202331e-01,
-0.345531917487628075771417253039319e-01,
-0.186858763177117110806765182472162e-01,
 0.314834318273378434598340632225637e-01,
 0.216648412637239929514986970881974e-01,
-0.276907650433788450315562998754806e-01,
-0.243757206315397160448561333813720e-01,
 0.230428730295325816477559283728919e-01,
 0.266915995899419703389074881593325e-01,
-0.173284564893193944366083657540881e-01,
-0.283695257552403098762917226180082e-01,
 0.102036641965353807963247758681669e-01,
 0.288787297738781985026389254976831e-01,
-0.111446766021820946270029502185547e-02,
-0.268760471339444596622308824291623e-01,
-0.106671556294362369911547199756202e-01,
 0.182871650613735592812955222818051e-01,
 0.240338999890025444885940840541688e-01,
 0.120399617657521272758537423268815e-01,
 0.261783741710707573833780823997405e-02,
 0.169264271675083502578963926134214e-03,
 0.618813883875043162883421103463184e-06,
 0.411047427503580382854228182121063e-01,
-0.731819240987710320237368169344027e-03,
-0.408853740928772621143076669691041e-01,
 0.140111806030414435154219263081840e-02,
 0.404498748574899131580404232754637e-01,
-0.194363349311919396680687976529673e-02,
-0.398041764136940383383137367273545e-01,
 0.229121303912327413923312649993120e-02,
 0.389556133131293002700292725517307e-01,
-0.236874422205089134459171707925020e-02,
-0.379103651223467139483469750845055e-01,
 0.208936582046161661038584322529361e-02,
 0.366684364494837424788105527505668e-01,
-0.134661536266931790790282059063563e-02,
-0.352133945780989353899274651383102e-01,
 0.113142356818847013395381396745210e-05,
 0.334899616260514744471170749169086e-01,
 0.214223286038864372128932124144633e-02,
-0.313507281282135877734894078690197e-01,
-0.537271369432539721135302372000093e-02,
 0.284149868325198230893495318188612e-01,
 0.101235860003936157040339728934393e-01,
-0.236389527760317228217101918855338e-01,
-0.169015414697838746310174618566029e-01,
 0.137503185657795645865514101781466e-01,
 0.244710084725549862581855678042083e-01,
 0.134783817731021489407931893054952e-01,
 0.308427268300800455544449238412687e-02,
 0.205434062820656444808302327962615e-03,
 0.762458585611326585225080795040440e-06,
 0.250421747423533208836707979550231e-02,
 0.407014892530256693719568634510226e-01,
-0.741349714657932304073025585085491e-02,
-0.395041943824209788203891488346584e-01,
 0.120302701044289666165083857688974e-01,
 0.375920481586546513464707880173766e-01,
-0.161756700194260118516975777811472e-01,
-0.350870651317392195977703581304528e-01,
 0.196936223216177043671559546786764e-01,
 0.321545636825663069073705514365050e-01,
-0.224569354747190094961687402681475e-01,
-0.289989285184649243842066446423644e-01,
 0.243697229711230955343579461788781e-01,
 0.258602328963749585620084428720910e-01,
-0.253634961202318504956790933609403e-01,
-0.230138396043332189205276998569206e-01,
 0.253809787017703484715694218649970e-01,
 0.207762761610356174108029163724225e-01,
-0.243320608165494086043242070874772e-01,
-0.195211605631625481819883786740893e-01,
 0.219749379700053330621053798101702e-01,
 0.196979909562200948041804607734279e-01,
-0.175576788959853633902869820882103e-01,
-0.217283308417370664673218488227019e-01,
 0.852849517897555467673628853092055e-02,
 0.243532457457147236822273594358134e-01,
 0.149116522305606765072003187778712e-01,
 0.360236729270679158774295759260290e-02,
 0.247488633006616351775781505179064e-03,
 0.932995118544206966560539151117780e-06,
-0.408003862715244928530544697734099e-01,
 0.917263102575993003394327397005256e-02,
 0.385399301058523683274001283230310e-01,
-0.177007189973633143999180086761137e-01,
-0.342253304895144803605577098434340e-01,
 0.250072297399044218877782204142205e-01,
 0.282477938621725402565201819904216e-01,
-0.306431832392904082465802375116243e-01,
-0.211430902078994769403921917041066e-01,
 0.343351126614633287098125629895306e-01,
 0.135371532497618146828106313667386e-01,
-0.360149327703699624265807901369743e-01,
-0.608453897364906455851505865370794e-02,
 0.358299962728906943355876326777206e-01,
-0.591277413337468192378791423390832e-03,
-0.341339124487961889614095000995762e-01,
 0.594376280710007321204899355859775e-02,
 0.314617073429220330307715717535177e-01,
-0.951584195502022421179689334238956e-02,
-0.284946263062742519968177386678396e-01,
 0.108748177967436265699881610368536e-01,
 0.260098429799444841784294447575498e-01,
-0.933014048488883295678883392165209e-02,
-0.247025919810486675068088056830456e-01,
 0.286526438886493309520841847665913e-02,
 0.236293804266860553815554367625094e-01,
 0.163058105948754459642635615042181e-01,
 0.417266481782974063089298519481118e-02,
 0.296070977465526067927625721688599e-03,
 0.113431486894146040565453756432001e-05,
-0.673417640983731217912750472027815e-02,
-0.387609353655885663716691116792849e-01,
 0.193583141484801469131204815538333e-01,
 0.321684837262342252846732177058818e-01,
-0.295854942134394220376554017851485e-01,
-0.222262749522075865846968430075713e-01,
 0.362461288351274527362963369010420e-01,
 0.103136545863317325057586157158877e-01,
-0.387339635369438017246813969906690e-01,
 0.198037110202835941152003282445308e-02,
 0.370881064561625354851844860156270e-01,
-0.131244832890374910490584090913353e-01,
-0.319644803811096103868708186481330e-01,
 0.218978230371088646409364482976379e-01,
 0.245055942673530457337499379043768e-01,
-0.275844531075774788308117727932231e-01,
-0.161389022113764368926105779380602e-01,
 0.300773994452312942865425133480806e-01,
 0.835486638924451766107453287392663e-02,
-0.298764379109146002674220114056291e-01,
-0.254411049354110342257959374852256e-02,
 0.279717900699380876668069081380953e-01,
 0.514173912714572581188451087268202e-04,
-0.255249161320644148493428959489053e-01,
-0.294834496231879707146620658418938e-02,
 0.222699188874245063571745089569896e-01,
 0.176239715718903113472329239069608e-01,
 0.479486085051319537590311847937994e-02,
 0.351851405103973890540997182202103e-03,
 0.137071231778019296078886248599892e-05,
 0.400658090869894051985116598260744e-01,
-0.171884083909407290478047077387650e-01,
-0.325072645997180237259649890570831e-01,
 0.309339593767431232312362785269882e-01,
 0.190227058748958410881524648805464e-01,
-0.385967167488964250459020102694598e-01,
-0.247178775385695225788054514373828e-02,
 0.389346370935087437049369961861055e-01,
-0.137617383199920638925097126249056e-01,
-0.323390453169709784295956726568512e-01,
 0.265848273303810593175323442965616e-01,
 0.206562303844483258902639075486403e-01,
-0.339090378225021271223729443539670e-01,
-0.665178465705308946585829858500815e-02,
 0.350827066186090453314758297173875e-01,
-0.673148599447888885411886571875538e-02,
-0.309429384335631069713155176849615e-01,
 0.171195151724043276765068886634702e-01,
 0.235016325768008558029667079240691e-01,
-0.232574329056080365040428252927330e-01,
-0.154016712312019485402543273586368e-01,
 0.252122397301887678491016177593305e-01,
 0.941805612091189509932811921614686e-02,
-0.240799642891536456959763846671189e-01,
-0.859087112893055049431857844241966e-02,
 0.202706572504729344993971256019328e-01,
 0.188272336445512942925754374075496e-01,
 0.546771244073885485613725589905712e-02,
 0.415523596676099673771377685575878e-03,
 0.164690985673131613017528866286190e-05,
 0.108777058871101252226590023594733e-01,
 0.351737501876349071403760719191431e-01,
-0.294062841157685757362014450586575e-01,
-0.194118248894544860210337392027596e-01,
 0.393082605345642883523874278361169e-01,
-0.141018489044615637332469124532402e-02,
-0.379709156561073815055358503181762e-01,
 0.210735792076239819364585000993541e-01,
 0.263177480680040786871918103606196e-01,
-0.340442416891313238594547254866915e-01,
-0.833044580395937754202839781592145e-02,
 0.372155425258488336764767930044440e-01,
-0.104477047453847499900632297307643e-01,
-0.307260588880959589887304941715448e-01,
 0.248533318274182011785951555065939e-01,
 0.176049762828509324795782908678391e-01,
-0.317758081628804846779796134515291e-01,
-0.243991137758751101664532297170983e-02,
 0.309846691098838911765067743625966e-01,
-0.103816938547384521435893914872407e-01,
-0.248994076182825840593668961258080e-01,
 0.181609849880805381902338073329395e-01,
 0.175720649708866593831333963114922e-01,
-0.204583142776694468631520202088829e-01,
-0.137310862479271505345305520211633e-01,
 0.176551824856195855709882116462941e-01,
 0.198757448754023242786154736661793e-01,
 0.618895928379936899517971182197125e-02,
 0.487800044770183229375853063910319e-03,
 0.196808283713608229033936489286134e-05,
-0.389099246321619536427683627559793e-01,
 0.244453491077128765677888981190694e-01,
 0.233857103803838973993461834267235e-01,
-0.388930541793058998967829947055389e-01,
 0.111773930344344885750788899696114e-02,
 0.377052762928872622470778932662435e-01,
-0.244635116835314487917084634827277e-01,
-0.219341334561401859622863801568363e-01,
 0.374170842798702165918344624797970e-01,
-0.141615620643212538389667496413123e-02,
-0.355596813722205014284345276100391e-01,
 0.227499603895216318722830509900191e-01,
 0.208337762866144997463193589484441e-01,
-0.341851479903284486323202754764424e-01,
-0.129983554935199571082435151621781e-03,
 0.327468691505760693675839017138245e-01,
-0.182340326469602208935022925830947e-01,
-0.210390321781890111989888616046231e-01,
 0.283333145198246555544805498660857e-01,
 0.529390559709842458699821204950859e-02,
-0.289401472633813765515248268212920e-01,
 0.799568730607363196875384319706260e-02,
 0.234457559455503960817971776835111e-01,
-0.149581883273133001196904988925700e-01,
-0.180509107173882593065025739661129e-01,
 0.144760960815353380576477296493290e-01,
 0.207299008518690618665034339370870e-01,
 0.695525942483646432291644662397413e-02,
 0.569406884310448143613703535621287e-03,
 0.233988477394299740807677235655429e-05,
-0.148936600925692603770105644579037e-01,
-0.301002717135968778370156894860221e-01,
 0.366152776049266856253863171882166e-01,
 0.341595921384715680038672431544958e-02,
-0.387090157874241522755577352742546e-01,
 0.244484040957798474924411926633186e-01,
 0.206041730977443285991532379475468e-01,
-0.387107269255599021020772713721664e-01,
 0.732377050604403200912902833545938e-02,
 0.326184113343068367967936350637697e-01,
-0.300448249066191167995295902650225e-01,
-0.106833260003506472729835564955927e-01,
 0.364446127752712864729085360543356e-01,
-0.146924040970312028159492817626438e-01,
-0.250185748442076769343041883827676e-01,
 0.307740534864102572433053799676876e-01,
 0.356733526281184221815816386783494e-02,
-0.314472294751762561628047276287447e-01,
 0.163871145065858080264279567411849e-01,
 0.195192253710519148618703549402281e-01,
-0.266062583550578918337000264506564e-01,
-0.354654088074367522305474217175179e-02,
 0.262491273694867617203391209721512e-01,
-0.806568366551498644720541960658189e-02,
-0.212689021543632149178319388493282e-01,
 0.108147928351461875642719366103688e-01,
 0.213516404865312603955647042484339e-01,
 0.776214209148069033860359899933687e-02,
 0.661078129798921069455002685980071e-03,
 0.276847262385590549781749914323737e-05,
 0.373458310454828266300165874090131e-01,
-0.306426417232646368256091474866514e-01,
-0.120587175745122042831464821944264e-01,
 0.402708995019472844985986643746067e-01,
-0.209097627700796193994261178487785e-01,
-0.227518533570866118566771819976929e-01,
 0.390431512289164070139620439149119e-01,
-0.921296578970182790175890941620026e-02,
-0.308161002127476029541407723571427e-01,
 0.336900776405034634550302050755108e-01,
 0.313881033298649642971414627237823e-02,
-0.351746602777434424399384827002690e-01,
 0.246396093388293890238095772372747e-01,
 0.146645537022870048202038021379286e-01,
-0.349814955675994208099513476989371e-01,
 0.126979222922200986225187715041232e-01,
 0.237332064784103254199503237304682e-01,
-0.295908274664174344187886382713823e-01,
-0.946799265410482284817508695011419e-03,
 0.284055846471816540829948746680480e-01,
-0.183840821143868949453893407031913e-01,
-0.144631227872459198155915863872451e-01,
 0.255849352777610060493625177529609e-01,
-0.414444303560904782974331458809388e-03,
-0.231624907585202263382358260466855e-01,
 0.677970025810322588145915997549045e-02,
 0.217057991598089229696178713106126e-01,
 0.860398003897301243949879449220504e-02,
 0.763549343162364949552895703883365e-03,
 0.326053205442099881858431743518388e-05,
 0.187418297968821185059221025627270e-01,
 0.237612102826056122939196566798871e-01,
-0.403167566004127630453069299097353e-01,
 0.131141772411982778569840831688763e-01,
 0.280007710156220271539703960485468e-01,
-0.383188583804506904280528035186864e-01,
 0.704858127867491228798757212804117e-02,
 0.312826307230741442482716076659777e-01,
-0.349767256533794793550177654700161e-01,
 0.716371920638829138825935769869896e-03,
 0.334096237756448372154396125655707e-01,
-0.302548997756595916337797794680221e-01,
-0.570645144908253831854566267307707e-02,
 0.341338005486614743182885974999262e-01,
-0.240606163493302976847116448514917e-01,
-0.120242553174347778214028925641167e-01,
 0.330764915269911666318252414565511e-01,
-0.161715104111016685240774064824212e-01,
-0.179577042496316955534458372978722e-01,
 0.294998806860377949629394203786447e-01,
-0.607683310727940768855651636451932e-02,
-0.228356308621975259540259043616305e-01,
 0.215134610876401259213992158665204e-01,
 0.727195388259262412270708271812958e-02,
-0.235871232757309164507780946790975e-01,
 0.250296724256955079805883522532205e-02,
 0.217614737008731187431426002709832e-01,
 0.947398349701482761584472083181445e-02,
 0.877550763746529138414657340198081e-03,
 0.382330261845869867152190923563228e-05,
-0.353907185091068871971705117421126e-01,
 0.355247140331537537866756893623992e-01,
-0.389185909164923267918190543022931e-03,
-0.348693374930878821096726243208609e-01,
 0.351992659438195186333795625015552e-01,
-0.632985396960218264899663540125343e-03,
-0.340343819105765816567815771278015e-01,
 0.343381001442018461022606084294481e-01,
-0.575029547112220567597853064945684e-03,
-0.329635212716025921669317337066977e-01,
 0.328480826053665612674871599000513e-01,
-0.321995708338639410058777734666768e-04,
-0.317359771419973429091592683264438e-01,
 0.305914819519958238124425684516220e-01,
 0.123388593004147193202770800183360e-02,
-0.304189244932615903637442112796538e-01,
 0.273185608692034440856617890155142e-01,
 0.357522583359035421359333872574373e-02,
-0.290107956826729702337942146675282e-01,
 0.224775162104584157574096617664151e-01,
 0.758177930728889846061792869654594e-02,
-0.271730465874297226513388423537063e-01,
 0.145558012631744160721977169230452e-01,
 0.142495499969209537087720793393857e-01,
-0.224906223288752114216414411322968e-01,
-0.186432056021987883151596520829358e-02,
 0.214933502092276473605139098632772e-01,
 0.103642174479219227369255437721535e-01,
 0.100379993963169016312745002618728e-02,
 0.446460274613221072380239029343248e-05,
-0.223834694859922680501065699748482e-01,
-0.164285504991848916440790307804749e-01,
 0.401761195527357946710270255857168e-01,
-0.274034737926531317721774590198796e-01,
-0.100181060439092390325208948463605e-01,
 0.379133912110641694615369975964176e-01,
-0.311139847468490955429962724596275e-01,
-0.369599330632081312347777950144060e-02,
 0.344433151612662979622546318784146e-01,
-0.332783548857131323564628766049843e-01,
 0.196970451036279657160200717295214e-02,
 0.302020105972365029484565248738124e-01,
-0.338175609779418985019582540462326e-01,
 0.641516681106310890423679201628308e-02,
 0.257771093311495724744196151783986e-01,
-0.328071890380198813555723074108155e-01,
 0.907279684363015921806531170073089e-02,
 0.219082848193308948662443822731981e-01,
-0.304226035193156722209382408870245e-01,
 0.925399736367878137621322391124212e-02,
 0.195317508126798841159405948873968e-01,
-0.266858277651192627854088625120976e-01,
 0.563296953550567330142158484250186e-02,
 0.198285433466366794827422565484050e-01,
-0.199213623016850273381455981349556e-01,
-0.615823180146830291360729840634206e-02,
 0.208829439404295167655058492752656e-01,
 0.112656435470501163655428536898150e-01,
 0.114299390694586334852522301633665e-02,
 0.519285446504418528577992286666198e-05,
 0.330657216709257391527313743085773e-01,
-0.388916255900648874593837696960232e-01,
 0.127746450425943541345147026829157e-01,
 0.236230194722229597322771187685706e-01,
-0.402941027739739278261049856422265e-01,
 0.237348893611311637764917403160944e-01,
 0.120249546101914792864085853383430e-01,
-0.372879469717043429042224192224962e-01,
 0.314399941162712465366996553856434e-01,
 0.901273838039223857450858323114708e-04,
-0.307130142887425971646609252713052e-01,
 0.351235405113812070789770459800273e-01,
-0.103724025510201734607625414386570e-01,
-0.220813451903222497584797437106430e-01,
 0.348656234834583414305499609747140e-01,
-0.179172010466366779296206068607245e-01,
-0.133195946868225482248294490665345e-01,
 0.316142079779485220760850681209494e-01,
-0.217039933099739807411366736539173e-01,
-0.652564064171503898357509581075496e-02,
 0.270751433816100291814638552078805e-01,
-0.214388283457125412214769252690674e-01,
-0.405269378232730448266552275306086e-02,
 0.234450337446359339263204017701670e-01,
-0.160292896383714844675807342590608e-01,
-0.102091354750585088103649399805005e-01,
 0.199197005714041169105735639249596e-01,
 0.121681875260876265650256336094325e-01,
 0.129580097114085354006283820379879e-02,
 0.601710775707204517421891836024967e-05,
 0.257817754285009769619572973305821e-01,
 0.841429913692659163229903176089110e-02,
-0.362218573362958679289433200108417e-01,
 0.370675951773265733486862311189623e-01,
-0.105365965820385772759770114778964e-01,
-0.234403522794729941423626238918082e-01,
 0.395964102456472847203616968088454e-01,
-0.262172991166034068673373022475751e-01,
-0.626662790519347813536171697093960e-02,
 0.333525672789966400974492545420347e-01,
-0.350022558427440118212312629399476e-01,
 0.106029153222040066516829339785219e-01,
 0.208975960217304273940980318054430e-01,
-0.356416760756923590184402453674751e-01,
 0.230393943809613288356339846485128e-01,
 0.641412397361833383948539580188431e-02,
-0.295922331879345872145017251807615e-01,
 0.288557208131517276360496566718223e-01,
-0.574579182621864948297189160628331e-02,
-0.204861714009843518872115170141666e-01,
 0.284924665680281896084474361770274e-01,
-0.123520747970581673900958374748674e-01,
-0.131787151088544947139252521295821e-01,
 0.247221241823658882634409598250645e-01,
-0.110593445189687345679580631342772e-01,
-0.138495759585279126386821851595770e-01,
 0.186019102122538074807550247433642e-01,
 0.130608324062944038252218477282268e-01,
 0.146285215118756726030900367075897e-02,
 0.694706445919653758684083713353525e-05,
-0.303957226012893790877162703096596e-01,
 0.406071657266658254670580170936796e-01,
-0.239264172614577749841771462074273e-01,
-0.843622482739932414515529621699856e-02,
 0.349059350747310296828909146774189e-01,
-0.379960357823381777588308776318521e-01,
 0.159452036443942156961829235526391e-01,
 0.162502279872103779642102081696699e-01,
-0.370378255230021032278679703892559e-01,
 0.328127256021471213808984217992668e-01,
-0.693084321270118639539122086097168e-02,
-0.228001681522742765129538656930617e-01,
 0.363574474375919458296936719407473e-01,
-0.250876103232572428405456730522158e-01,
-0.261387345275952993250462125212475e-02,
 0.273490654673647632187521997532188e-01,
-0.322641616333143865136038924015228e-01,
 0.147054663542603570260440268573325e-01,
 0.121275302464102890816007965327133e-01,
-0.287368986870929609204671608191835e-01,
 0.234442395020816937854543966513533e-01,
-0.104578925366431279131275113261318e-02,
-0.204845118807016255608786073252528e-01,
 0.235134032143015539472762065908236e-01,
-0.533743239368978834140525737479967e-02,
-0.169224916026073626033093291942275e-01,
 0.169373895566918998464873633414455e-01,
 0.139317373020295411579820660585875e-01,
 0.164473235425804198918543633870629e-02,
 0.799310161435187564697413568301518e-05,
-0.289023212677566756472236105474364e-01,
-0.575615154193855405684739688855858e-04,
 0.288408996148597012692372534623513e-01,
-0.405060863027555359974606226771679e-01,
 0.283205587686971463134268788290602e-01,
 0.307486550888739368965584906406470e-03,
-0.283240739008549582845586426147137e-01,
 0.392323624996284833015528212645182e-01,
-0.268847966450437323604047570078398e-01,
-0.981934101101636325442893478115984e-03,
 0.275402157429985158587447074338795e-01,
-0.370571636130176734931887368731270e-01,
 0.243090121368374585378408940211890e-01,
 0.244567493648766478602242183183811e-02,
-0.266864832284679752406034383279734e-01,
 0.338207323223529071577250226132360e-01,
-0.200935838238320616443894987843142e-01,
-0.525489365654747901365875670401936e-02,
 0.259296917024435429789412807540033e-01,
-0.289632447609863346617435098299528e-01,
 0.130617580549095546078736367298781e-01,
 0.104451266431203424177750041580517e-01,
-0.249487732172794112376490467529097e-01,
 0.199234926197792567099081152547423e-01,
 0.750299273145004425676013236167114e-03,
-0.192893512395058260415512468671454e-01,
 0.149438934991598003484898214719613e-01,
 0.147683810259680036334905605763432e-01,
 0.184197135461185168308852913268492e-02,
 0.916629417733399379057876944915985e-05,
 0.274091088804843241011441114114566e-01,
-0.406043172766658553314938367302182e-01,
 0.327946911642909299276041829643216e-01,
-0.813931824002479362027870524363883e-02,
-0.204663999653582882615653448984044e-01,
 0.381693586453135346268096528970839e-01,
-0.359285151098344777561288402922618e-01,
 0.151905448218439337631921540539703e-01,
 0.129711311063392473079571141329185e-01,
-0.337688275622777529149245364459533e-01,
 0.365148690293684152308487008401954e-01,
-0.201953310417668442876801450906889e-01,
-0.613496173133207725921351104406862e-02,
 0.283121497987771083478568470259900e-01,
-0.346995937854995624824973033361655e-01,
 0.223954831114995400032150066560466e-01,
 0.132729963010027855032383054733098e-02,
-0.231267037337365634727892464304586e-01,
 0.310208884988980143227840813207658e-01,
-0.210864006872804767306323970801328e-01,
-0.298682085717457365635055168373051e-03,
 0.200370847066048292317875130925817e-01,
-0.259366494927015049171848236706851e-01,
 0.143026740222516037892087272036921e-01,
 0.678355185591991022842044143065023e-02,
-0.208377653754529997452092837647880e-01,
 0.126492252524808512108117172640641e-01,
 0.155577291281780023271933447843914e-01,
 0.205503465601622980127441532810688e-02,
 0.104784369800500463454135164467877e-04,
 0.317134538684980906727084066703791e-01,
-0.828950736829098920087348857899811e-02,
-0.187406811647588028759321040621155e-01,
 0.371633951675420613921704615988337e-01,
-0.387333089501195920938349551137001e-01,
 0.229056361983247144404417995761302e-01,
 0.296732621422465309223366339499991e-02,
-0.270517770052621166143845671441710e-01,
 0.384767633696138069033649492073380e-01,
-0.322956630805128704346369404449370e-01,
 0.116838495478845640304295194398144e-01,
 0.136254440787537286277210778430915e-01,
-0.319222356309574681337253255137357e-01,
 0.349761030146885589017962214033279e-01,
-0.218224128556793502503572392760212e-01,
-0.887031914781620679195027746087093e-03,
 0.221288699637459266198969060431219e-01,
-0.318194520308383258241247161937043e-01,
 0.256768002149230313468017453285979e-01,
-0.730006798284414574781766433121135e-02,
-0.135862237619113478656252561976133e-01,
 0.259781507564875824023578108216546e-01,
-0.232948870168676859265139206478471e-01,
 0.721535583097960203207048748550901e-02,
 0.123375194317787826164377289117009e-01,
-0.214881358634407055514374344164444e-01,
 0.100910232598130129017122211155306e-01,
 0.162864224242642946705616819346964e-01,
 0.228431432202846160280762099458466e-02,
 0.119420658598809764532327062928730e-04,
-0.241374910306164932258883387311734e-01,
 0.388878577078613804526371029652430e-01,
-0.385486473769969728894733573109453e-01,
 0.233316119623360358899995939241500e-01,
 0.741533138023914081896790209731027e-03,
-0.242313871164172314271171113921527e-01,
 0.380098269090859808210479112226548e-01,
-0.368466769752472721920212165608640e-01,
 0.214347778963193674475973631405358e-01,
 0.194266481565551172499369218412151e-02,
-0.239595033349925308915337670152922e-01,
 0.359843773033983728847535571945231e-01,
-0.335113739688321755573809105931915e-01,
 0.179110269293655787773659095313374e-01,
 0.419692894387356186728763699595406e-02,
-0.236919113721079730505599021175337e-01,
 0.327083569173984087439908293627885e-01,
-0.278716339495623585645329021063933e-01,
 0.116841568527373752316111349129482e-01,
 0.853280019969708369119536946038465e-02,
-0.237516928116553931501819516118984e-01,
 0.271725796573139551807313137795750e-01,
-0.173800497962736425164795047769191e-01,
-0.614988095535132204953024577989116e-03,
 0.170139123226959780129822424737951e-01,
-0.211989401947079881415540383754440e-01,
 0.731621372383559333162493537572476e-02,
 0.169409845060135318798276719628549e-01,
 0.253011986278642488816965362557444e-02,
 0.135704778546629538808568264103693e-04,
-0.341866499764155773868699162873445e-01,
 0.162762875564394262409847817952879e-01,
 0.688154959659363609350579787723773e-02,
-0.276156049299289943459928753163288e-01,
 0.390991067613590031361171090778049e-01,
-0.376262078376096140962737393155022e-01,
 0.238324915848149156845976190456747e-01,
-0.245145344071670793978668121550929e-02,
-0.193063139205733149184313840944366e-01,
 0.341992043526911314289837615624912e-01,
-0.373955035691665197443449069499824e-01,
 0.280815113464936486985516783194933e-01,
-0.969280524506422138505030005893043e-02,
-0.113067560582004929856017782673406e-01,
 0.276783368949064096210519790603765e-01,
-0.339197648427558608847704661524344e-01,
 0.281696776452125790356078369239849e-01,
-0.128412651702268884538903445562797e-01,
-0.624661096744595875743789519773050e-02,
 0.219591259485375017015083572090679e-01,
-0.284504145182682433805608860489563e-01,
 0.233884588564069961174754310339572e-01,
-0.901435171190635695151538370460954e-02,
-0.837910576269814647540855602842166e-02,
 0.204709918504295435763910996391140e-01,
-0.199703034021431063983717201440233e-01,
 0.438012902935022302022151948851647e-02,
 0.175080451944386708772086291121842e-01,
 0.279266927052449522772115943345660e-02,
 0.153777503677754290237179919137431e-04,
 0.206153833885235631760369377755416e-01,
-0.355339895884918862059807011293193e-01,
 0.406532394179356845963325660310716e-01,
-0.346095930207269245314918800304947e-01,
 0.191516896337012253294470244547648e-01,
 0.136243416503142695681129505640030e-02,
-0.212006931023129266013867359339264e-01,
 0.348745065996158419265293222005281e-01,
-0.386803454153600965764655596152966e-01,
 0.317289668056310804963126781628362e-01,
-0.161716220580158241921790173298883e-01,
-0.343928936456924774994068671035273e-02,
 0.214713843786482862738093968765906e-01,
-0.328370017363069891972127731534875e-01,
 0.344556725934449036760481586610109e-01,
-0.261333194453236779730158577978119e-01,
 0.106019715496980416220446203642063e-01,
 0.729748484993901401400261163556139e-02,
-0.220616478909846283493228704587048e-01,
 0.291896233184084561416822380487266e-01,
-0.265885608895879328737446234874016e-01,
 0.153081112530661857099010207991524e-01,
 0.625950626136078505015138346404495e-03,
-0.152660154733168995219135589802750e-01,
 0.224502387519703522157648848283011e-01,
-0.178455896524117274371782751653969e-01,
 0.134530431863962275821888797877514e-02,
 0.179745764026559729315301904314484e-01,
 0.307208029879929891924472442419299e-02,
 0.173787592070556921934654039645407e-04,
 0.362968330606584896979493813282597e-01,
-0.235682054786273583128809071878765e-01,
 0.561411625182718416523997784493203e-02,
 0.134695281074226847514150319493344e-01,
-0.293472366107317347762393877655438e-01,
 0.384438343037653073568344872018193e-01,
-0.387655974515288824249891912572962e-01,
 0.303519830762268423707626685289210e-01,
-0.152533552228380751734630690396250e-01,
-0.295942524711390421954346643202421e-02,
 0.200384652273760933571122690309385e-01,
-0.320577276409661528034810524030844e-01,
 0.363330946151226577245523307490710e-01,
-0.320472970881394844317737963945232e-01,
 0.204318711797599768057041509590097e-01,
-0.446151969569240453383446343764258e-02,
-0.118696696405176930810354406600424e-01,
 0.245222541642980172351314518240886e-01,
-0.304079405897930829947900767865107e-01,
 0.281735148147237806121460205115980e-01,
-0.185842854508806865813603156185964e-01,
 0.440963730500880421880628463590011e-02,
 0.101747046191724575156714315575036e-01,
-0.205489570524574454234302637666421e-01,
 0.227974621990211572447897801351094e-01,
-0.149108432342169588260624343219962e-01,
-0.172002343746395058972015349157908e-02,
 0.183281364370076639892879488979263e-01,
 0.336836208232162005443823557652367e-02,
 0.195891954017438800432115276773901e-04,
-0.168798525449664978152438000858314e-01,
 0.306870164811969357078609386808908e-01,
-0.389181235275941169588768555217024e-01,
 0.401021365393830959488020065052485e-01,
-0.340706099749466283244791946139032e-01,
 0.219847901354371592108906411008466e-01,
-0.611461573477481897253245505247299e-02,
-0.105888977157660115938550003154080e-01,
 0.250477011562225815102160954658411e-01,
-0.346332449094196817976998530598687e-01,
 0.376572248207522546557778501733159e-01,
-0.336841771374858479633106376053578e-01,
 0.236067838081282611058287738583701e-01,
-0.946912008607008433144714993272643e-02,
-0.592966827680639183704205876901220e-02,
 0.195774426826172751399476801754899e-01,
-0.288354122983827600509333009853119e-01,
 0.319584160834884734438789812711497e-01,
-0.284505278185399566104781573790938e-01,
 0.191874402280259762463894276750990e-01,
-0.627986582486414452932946193429988e-02,
-0.730058256451532456481322198358609e-02,
 0.182696671562526834924851461552364e-01,
-0.236639437596116407633193322405967e-01,
 0.214765259526715267815913690779313e-01,
-0.112920199174204919728781491746626e-01,
-0.474367779516422751916481597652386e-02,
 0.185571183908684442303495508497387e-01,
 0.368140719530309897167019385556090e-02,
 0.220255807023995465690583678382380e-04,
-0.380226491141586269078738954507738e-01,
 0.298605674743141827703537079082383e-01,
-0.175675582057410960485622320254496e-01,
 0.290825061032884808824089792964304e-02,
 0.120187393824850111538239680250409e-01,
-0.250865704486687426941387385678270e-01,
 0.344497595876010473897686489007063e-01,
-0.388122783443964594276214448185964e-01,
 0.376148697994402151812591497434277e-01,
-0.311140543595273633244648124334865e-01,
 0.203410859202580123122684457264347e-01,
-0.694665090167042336680089431397620e-02,
-0.704618050954899891558359250661562e-02,
 0.195447746893898277391897279681554e-01,
-0.287012991469317188870317785566743e-01,
 0.331925779047402645885965096279163e-01,
-0.324242582110782042240198565853910e-01,
 0.266289803985908239887889474263140e-01,
-0.168435254404498255900122994931303e-01,
 0.476735287408773607480378777308128e-02,
 0.747810774242179031456673722490613e-02,
-0.176563568275844087278044471788766e-01,
 0.237483079090228065330648160998964e-01,
-0.242721959945567186866846931301223e-01,
 0.185743985446903448452227373916442e-01,
-0.715006867341785341470932754505495e-02,
-0.765151960915646604497894225093886e-02,
 0.186509979872055203792735776124692e-01,
 0.401098424630303614677000088513896e-02,
 0.247052816697219131467006845333969e-04,
 0.129701375786664231322110015013417e-01,
-0.245532035074989876768257087299564e-01,
 0.335142709827452427601615899985073e-01,
-0.389059324089071489530165156811707e-01,
 0.401719741191354629961708607069699e-01,
-0.372079032690896594186856336692870e-01,
 0.303716180412551091100321111670401e-01,
-0.204429907570566815831757293149469e-01,
 0.853675076917445282830413791615755e-02,
 0.402180566148009994004379133747655e-02,
-0.158446517175730050538075371809743e-01,
 0.256361771158430331666067016124455e-01,
-0.323385797389348349807639143493095e-01,
 0.352514754398797786528737874232062e-01,
-0.341124975721517667603778161437110e-01,
 0.291299081565988256678983216555410e-01,
-0.209634788723690197747502474233267e-01,
 0.106555435016360360694293871861625e-01,
 0.480459289191661050957949195611074e-03,
-0.110020758767609701125716546450481e-01,
 0.194955861399853848694516157460605e-01,
-0.247334139152012114448370110777219e-01,
 0.258171527363353477885564549647350e-01,
-0.222993102274585717827720218548309e-01,
 0.142968869284716782307116244470449e-01,
-0.267404396099568401260886965642897e-02,
-0.103695815161535278433167728263485e-01,
 0.186005760124583567612454529627397e-01,
 0.435673110667385532637072140063289e-02,
 0.276465222594509099602305275022304e-04,
 0.393466999612500997725474934146205e-01,
-0.348911404352544587851041781739318e-01,
 0.278541885136175205529847358288712e-01,
-0.187868789505211073975993061400558e-01,
 0.839841818639184353794962845357031e-02,
 0.250013149662227813462945177143674e-02,
-0.130603166757793704298959611703418e-01,
 0.224638240783537765515363603594578e-01,
-0.299877519202200342288094134399446e-01,
 0.350624694043440984810889990525366e-01,
-0.373174925038592363630096106175738e-01,
 0.366117441076381542753773493988084e-01,
-0.330457927554201172377351154221643e-01,
 0.269550801695005489077640452567625e-01,
-0.188846420030797484817757123762684e-01,
 0.954728021648465646596889369256805e-02,
 0.231557621430822956750061686764734e-03,
-0.957790519618945625142176980421769e-02,
 0.176374531294466670625800245558098e-01,
-0.236425955840570301660099949120460e-01,
 0.269735076241414850126616132276237e-01,
-0.272095257298945477244263596608159e-01,
 0.241695990545915867845432523292454e-01,
-0.179464262241588805750190986292030e-01,
 0.895513777394618222810619116947712e-02,
 0.192745665252628161834946271010658e-02,
-0.128262953811588191276183099492830e-01,
 0.183982103633842997377741205735690e-01,
 0.471814886783459841198602950430854e-02,
 0.308683948120247754936044322666413e-04,
-0.892724644826112101435988024725901e-02,
 0.173920789396758715113549203842130e-01,
-0.249568111496617606692414392829627e-01,
 0.312319071112586896547272439257074e-01,
-0.358968629290800676001271185802206e-01,
 0.387174453638684758983710876175221e-01,
-0.395583772939306843323777723912256e-01,
 0.383908002175713814818799597797206e-01,
-0.352941195204732723765016485834686e-01,
 0.304521346963637230042098058926425e-01,
-0.241436584710088052591029690871918e-01,
 0.167281199277450275790956416042565e-01,
-0.862691185780345875159912105366949e-02,
 0.301467493097861099241558354406940e-03,
 0.777077580968654386736235304909622e-02,
-0.151212586646185144682534324954146e-01,
 0.213147215501567201672706201816532e-01,
-0.259719005312658453221660961516043e-01,
 0.287893607621405881213393958710218e-01,
-0.295555768011691920188020550879794e-01,
 0.281627971123502156917037999731681e-01,
-0.246150354971153272748938107229278e-01,
 0.190342913208238679357816508167863e-01,
-0.116716513614023504545220810167351e-01,
 0.294372993851656015658651971425107e-02,
 0.643613259638313318120112540852200e-02,
-0.149547419187459242351055694328048e-01,
 0.180380327061476269800220936740345e-01,
 0.509459661974037939904234460835318e-02,
 0.343908693574214195579914421425573e-04,
-0.402557326341551590673372616704126e-01,
 0.384509574879238728060588325188122e-01,
-0.355087323189938746119652996934299e-01,
 0.315254598712720915542031671420841e-01,
-0.266317817199251259806631328653960e-01,
 0.209884227653322249276827422954401e-01,
-0.147810807347532654387893635665649e-01,
 0.821452473408684663402360441805097e-02,
-0.150609243779755696063858664576966e-02,
-0.512120495061762916717065683700169e-02,
 0.114457479225621659621774734962790e-01,
-0.172543161897443045856433573584120e-01,
 0.223488121369655950314104758509487e-01,
-0.265524828393625338481230764229626e-01,
 0.297154399671823652958107772920604e-01,
-0.317193017511984485819493921429922e-01,
 0.324808156777124493966042106121426e-01,
-0.319543687693307412611390959194055e-01,
 0.301333646030031627066892420850337e-01,
-0.270505691009223029628775358127640e-01,
 0.227777692656816593464676869566824e-01,
-0.174256364263693510297424898714300e-01,
 0.111460753168877164146131846481643e-01,
-0.414325835112058773693046522633141e-02,
-0.328812482418972005903464257106854e-02,
 0.106346176684755451763563979530660e-01,
-0.166948479670284055588585920325994e-01,
 0.175161448271529843469157171752163e-01,
 0.548528713906157446540561561699980e-02,
 0.382348011476135768450458829312902e-04,
 0.479353304344595289683666254624770e-02,
-0.950553946021474436749269909696227e-02,
 0.140557974880095671182307128822661e-01,
-0.183666731603015096443234657785197e-01,
 0.223643596990215337747412732789991e-01,
-0.259800524109814057596250974262341e-01,
 0.291510390868339693573385995228536e-01,
-0.318216871481241318358567142513012e-01,
 0.339443103034947972193249505312098e-01,
-0.354798992374158704654780756861064e-01,
 0.363987028480920475337406031613094e-01,
-0.366806487791627992371620922170561e-01,
 0.363155945030424371648662857482273e-01,
-0.353034031672905245019653068814106e-01,
 0.336538421918406746655588634442188e-01,
-0.313863080846449457067419566913027e-01,
 0.285293901151531186025376593267212e-01,
-0.251203028739573213758825710362450e-01,
 0.212042538877828335910030626119151e-01,
-0.168338927553356199216648417695661e-01,
 0.120691768610909834622123757408668e-01,
-0.697845710306704556555420184715321e-02,
 0.164282716752203255317898514068808e-02,
 0.383066982539347991622490745232878e-02,
-0.927016649695264705497934281464790e-02,
 0.143173747143261091415160253662544e-01,
-0.179954556819572372178291503853082e-01,
 0.168307899399133277413862822365497e-01,
 0.588928357074880623568864608292669e-02,
 0.424219363313200493721360708272817e-04,
 0.407407835484380194127530632145698e-01,
-0.403929010704845770475643983257206e-01,
 0.398151841352797992310397783906610e-01,
-0.390107458061957709518479757370210e-01,
 0.379839088244356383454109373536750e-01,
-0.367401698426792383754638015457632e-01,
 0.352861531053646245533226883128442e-01,
-0.336295532878538780074322558124138e-01,
 0.317790671053874908998767793494787e-01,
-0.297443131876618053192397341728236e-01,
 0.275357395994808984726903351006121e-01,
-0.251645183080453491543701303594148e-01,
 0.226424259363531536807785250928792e-01,
-0.199817104837455110918447297787265e-01,
 0.171949447370674414799758140160856e-01,
-0.142948697017583791514689086272766e-01,
 0.112942374422158341796131439890783e-01,
-0.820567647013292059278914563326551e-02,
 0.504163403394615725091486014713917e-02,
-0.181452179272387323231183882671665e-02,
-0.146263659697508832985354158869204e-02,
 0.477432817676938682975279541641880e-02,
-0.809757913765617519502057267541782e-02,
 0.113887752639863351107745005143551e-01,
-0.145469164287580375458487130891847e-01,
 0.173012763235710266573826532647434e-01,
-0.188161893680937347777612280858287e-01,
 0.159824945014062157037528536233194e-01,
 0.630549718085729344152712137497775e-02,
 0.469749156882345934031014312986152e-04
};

static const Standard_Real WeightsDB0_C2[] = {
 0.245304484480172770561464997165472e+00,
-0.191139714401666377930496301274007e+00,
 0.178136284339069668689740479411420e+00,
-0.172429008691609799715475070508339e+00,
 0.169318789594508605864545701233480e+00,
 0.149155398292166716250990088960560e+00,
-0.116220950022362443223032176460115e+00,
 0.108314320046717977953192396158496e+00,
-0.104844057470132811109820163169752e+00,
 0.102952914023704998859428124775724e+00,
-0.101792592719522904188151702272729e+00,
 0.101023889470572922663698107219107e+00,
-0.100486134485309987058782558616901e+00,
 0.100094213908590282708682136877216e+00,
-0.997992634422356142093297855180819e-01,
 0.618547557328322736835729995361351e-01,
-0.481968373721843093643902263018781e-01,
 0.449179572819350891541413776740975e-01,
-0.434788391108112910355210611882716e-01,
 0.426945817706551874537228641261079e-01,
-0.422133964319844509074108616843274e-01,
 0.418946151324856665678136784351517e-01,
-0.416716080966129422860820790086590e-01,
 0.415090786017556233791097754444432e-01,
-0.413867626195079254101897705906408e-01,
 0.412922940404957629377688146849320e-01,
-0.412177539779760108237969645598773e-01,
 0.411578690719659723517486376893258e-01,
-0.411090117127279998422722835087001e-01,
 0.410686169440425529146374092920818e-01,
-0.410348279566383307452506946000755e-01,
 0.410062728177020053346952871033186e-01,
-0.409819195161807464254487463949885e-01,
 0.409609793295067545270664005820795e-01,
-0.409428408860701082602404384998466e-01,
 0.409270242337477530848130580613150e-01,
-0.409131482481638196893301237830920e-01,
 0.409009071190569001145472421041385e-01,
-0.408900531291930076869098937224986e-01,
 0.408803838682284158000996245029333e-01,
-0.408717326200442487242948957884301e-01,
 0.408639610525922021174682189163711e-01,
-0.408569535997322120997291328426552e-01
};


//
//---------------- Table des maximums de (1-t2*Ji(t) ---------------
//
static const Standard_Real MaxValuesDB_C0[57] = {
  0.968245836551854221294816349945600,
  0.986013297183269340427888048593603,
  1.07810420343739860362585159028115,
  1.17325804490920057010925920756025,
  1.26476561266905634732910520370741,
  1.35169950227289626684434056681946,
  1.43424378958284137759129885012494,
  1.51281316274895465689402798226634,
  1.58783643295919088005339365870120,
  1.65970112228228167018443636171226,
  1.72874345388622461848433443013543,
  1.79525156114638775440776323042160,
  1.85947199025328260370244491818047,
  1.92161634324190018916351663207101,
  1.98186713586472025397859895825157,
  2.04038269834980146276967984252188,
  2.09730119173852573441223706382076,
  2.15274387655763462685970799663412,
  2.20681777186342079455059961912859,
  2.25961782459354604684402726624239,
  2.31122868752403808176824020121524,
  2.36172618435386566570998793688131,
  2.41117852396114589446497298177554,
  2.45964731268663657873849811095449,
  2.50718840313973523778244737914028,
  2.55385260994795361951813645784034,
  2.59968631659221867834697883938297,
  2.64473199258285846332860663371298,
  2.68902863641518586789566216064557,
  2.73261215675199397407027673053895,
  2.77551570192374483822124304745691,
  2.81776994597143153710376281275450,
  2.85940333797200948896046563785957,
  2.90044232019793636101516293333324,
  2.94091151970640874812265419871976,
  2.98083391718088702956696303389061,
  3.02023099621926980436221568258656,
  3.05912287574998661724731962377847,
  3.09752842783622025614245706196447,
  3.13546538278134559341444834866301,
  3.17295042316122606504398054547289,
  3.20999926816996135137752596702140,
  3.24662674946606137764916854570219,
  3.28284687953866689817670991319787,
  3.31867291347259485044591136879087,
  3.35411740487202127264475726990106,
  3.38919225660177218727305224515862,
  3.42390876691942143189170489271753,
  3.45827767149820230182596660024454,
  3.49230918177808483937957161007792,
  3.52601302002857241495403528297560,
  3.55939845146044235497103883695448,
  3.59247431368364585025958062194665,
  3.62524904377393592090180712976368,
  3.65773070318071087226169680450936,
  3.68992700068237648299565823810245,
  3.72184531357268220291630708234186
};
//
//---------------- Table des maximums de ((1-t2)2)*Ji(t) ---------------
//
static const Standard_Real MaxValuesDB_C1[55] = {
  1.10926495933117800798137405466780,
  1.05299572648705464724876659688996,
  1.09497153514341787092816986458130,
  1.15078388379719068145021100764647,
  1.20948630847187015962782198118690,
  1.26806623151369531323304177532868,
  1.32549784426476978866302826176202,
  1.38142537365039019558329304432581,
  1.43575531950773585146867625840552,
  1.48850442653629641402403231015299,
  1.53973611681876234549146350844736,
  1.58953193485272191557448229046492,
  1.63797820416306624705258190017418,
  1.68515974143594899185621942934906,
  1.73115699602477936547107755854868,
  1.77604489805513552087086912113251,
  1.81989256661534438347398400420601,
  1.86276344480103110090865609776681,
  1.90471563564740808542244678597105,
  1.94580231994751044968731427898046,
  1.98607219357764450634552790950067,
  2.02556989246317857340333585562678,
  2.06433638992049685189059517340452,
  2.10240936014742726236706004607473,
  2.13982350649113222745523925190532,
  2.17661085564771614285379929798896,
  2.21280102016879766322589373557048,
  2.24842143214569565978037943337910,
  2.28349755104077956674135810027654,
  2.31805304852593774867640120860446,
  2.35210997297725685169643559615022,
  2.38568889602346315560143377261814,
  2.41880904328694215730192284109322,
  2.45148841120796359750021227795539,
  2.48374387161372199992570528025315,
  2.51559126548737739539590985018930,
  2.54704548720896557684101746505398,
  2.57812056037881628390134077704127,
  2.60882970619319538196517982945269,
  2.63918540521920497868347679257107,
  2.66919945330942891495458446613851,
  2.69888301230439621709803756505788,
  2.72824665609081486737132853370048,
  2.75730041251405791603760003778285,
  2.78605380158311346185098508516203,
  2.81451587035387403267676338931454,
  2.84269522483114290814009184272637,
  2.87060005919012917988363332454033,
  2.89823818258367657739520912946934,
  2.92561704377132528239806135133273,
  2.95274375377994262301217318010209,
  2.97962510678256471794289060402033,
  3.00626759936182712291041810228171,
  3.03267744830655121818899164295959,
  3.05886060707437081434964933864149
};
//
// --------------- Table des maximums de ((1-t2)3)*Ji(t) ---------------
//
static const Standard_Real MaxValuesDB_C2[53] = {
  1.21091229812484768570102219548814,
  1.11626917091567929907256116528817,
  1.13271408102908841062785104742030,
  1.16794527226680287535220980221710,
  1.20910611986279066645602153641334,
  1.25228283758701572089625983127043,
  1.29591971597287895911380446311508,
  1.33931381574818842583080285849170,
  1.38212887289996719206776174913850,
  1.42420414683357356104823573391816,
  1.46546895108549501306970087318319,
  1.50590085198398789708599726315869,
  1.54550385142820987194251585145013,
  1.58429644271680300005206185490937,
  1.62230484071440103826322971668038,
  1.65955905239130512405565733793667,
  1.69609056468292429853775667485212,
  1.73193098017228915881592458573809,
  1.76711122069903254298634266353970,
  1.80166107681586964987277458875667,
  1.83560897003644959204940535551721,
  1.86898184653271388435058371983316,
  1.90180515174518670797686768515502,
  1.93410285411785808749237200054739,
  1.96589749778987993293150856865539,
  1.99721027139062501070081653790635,
  2.02806108474738744005306947877164,
  2.05846864831762572089033752595401,
  2.08845055210580131460156962214748,
  2.11802334209486194329576724042253,
  2.14720259305166593214642386780469,
  2.17600297710595096918495785742803,
  2.20443832785205516555772788192013,
  2.23252169994573795304169982447060,
  2.26026542430750831685999530743450,
  2.28768115912702794202525264301585,
  2.31477993690926840212749467553480,
  2.34157220782483457076721300512406,
  2.36806787963276257263034969490066,
  2.39427635443992520016789041085844,
  2.42020656255081863955040620243062,
  2.44586699364757383088888037359254,
  2.47126572552427660024678584642791,
  2.49641045058324178349347438430311,
  2.52130850028451113942299097584818,
  2.54596686772399937214920135190177,
  2.57039222850067540893289982222750,
  2.59459096001908861492582631591134,
  2.61856915936049852435394597597773,
  2.64233265984385295286445444361827,
  2.66588704638685848486056711408168,
  2.68923766976735295746679957665724,
  2.71238965987606292679677228666411
};

//#include <PLib_JacobiPolynomial_1.cxx>
