/* 
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include "mforms/mforms.h"
#include "wf_view.h"
#include "wf_imagebox.h"

#include "base/string_utilities.h"
#include "ConvUtils.h"

using namespace System;
using namespace Drawing;
using namespace Windows::Forms;

using namespace mforms;
using namespace MySQL::Forms;

//--------------------------------------------------------------------------------------------------

ImageBoxImpl::ImageBoxImpl(ImageBox *image)
  : ViewImpl(image)
{
}

//--------------------------------------------------------------------------------------------------

bool ImageBoxImpl::create(ImageBox *self)
{
  ImageBoxImpl ^imageBox= gcnew ImageBoxImpl(self);

  if (imageBox != nullptr)
  {
    PictureBox ^pb= ViewImpl::create<PictureBox>(self, imageBox);
    pb->SizeMode = PictureBoxSizeMode::AutoSize;
    return true;
  }
  return false;
}

//--------------------------------------------------------------------------------------------------

void ImageBoxImpl::set_image(ImageBox *self, const std::string &file)
{
  ImageBoxImpl^ imageBox= (ImageBoxImpl^) ObjectImpl::FromUnmanaged(self);

  if (imageBox != nullptr && !file.empty())
  {
    PictureBox^ box= imageBox->get_control<PictureBox>();
    String^ name= CppStringToNative(mforms::App::get()->get_resource_path(file));

    try
    {
      if (IO::File::Exists(name))
        box->Load(IO::Path::GetFullPath(name));
      else
        box->Load(Application::StartupPath + "/" + name);
    }
    catch (...)
    {
      mforms::Utilities::show_error(_("Error while loading image"), _("An error occured while loading image ")
        + file, _("Close"));
    }
  }
}

//--------------------------------------------------------------------------------------------------

void ImageBoxImpl::set_image_align(ImageBox *self, Alignment alignment)
{
  // Alignment within a picture box is only partially adjustable. Embed the box in an own container
  // to have more control over the alignment.
  ImageBoxImpl^ imageBox= (ImageBoxImpl^) ObjectImpl::FromUnmanaged(self);
  switch (alignment)
  {
  case TopLeft:
    {
      PictureBox^ box= imageBox->get_control<PictureBox>();
      box->SizeMode = PictureBoxSizeMode::Normal;
      break;
    }

  case MiddleCenter:
    {
      PictureBox^ box= imageBox->get_control<PictureBox>();
      box->SizeMode = PictureBoxSizeMode::CenterImage;
      break;
    }
  }
}

//--------------------------------------------------------------------------------------------------

void ImageBoxImpl::set_scale_contents(ImageBox *self, bool flag)
{
  ImageBoxImpl^ imageBox= (ImageBoxImpl^) ObjectImpl::FromUnmanaged(self);

  if (imageBox != nullptr)
  {
    PictureBox^ box= imageBox->get_control<PictureBox>();
    if (flag)
      box->SizeMode = PictureBoxSizeMode::StretchImage;
    else
      box->SizeMode = PictureBoxSizeMode::AutoSize;
  }
}

//--------------------------------------------------------------------------------------------------
