unit tfce_clustering;
//USED by stats to select only regions with a given number of connected/contiguous voxels
interface
uses define_types,dialogs,SysUtils,nifti_hdr,nifti_img, math, windows;

//procedure FindClusters (lMultiBuf: SingleP; lXdim, lYDim, lZDim, lThreshClusterSz: integer; lMinNeg, lMinPos: single);

//function ClusterTFCE (var lHdr: TMRIcroHdr;  lThreshClusterSz: integer; lThresh: double ): boolean;

function doTFCE (var lHdr: TMRIcroHdr;  lImg: SingleP ): boolean;

implementation
uses
npmform;

procedure countClusterSize (lX,lY,lZ, numConn: integer; var lClusterBuff: LongIntP);
//input CountImg is volume X*Y*Z where voxels are either 0 or 1
// output: CountImg voxels report number of connected neighbors
const
 lClusterSign = 1; //
 lClusterFillValue = -1; //impossible cluster size - used to denote actively growing cluster
var
  lQHead,lV,lXY, lXYZ,lClusterSz, lQTail: integer;
  lQra: LongIntP;
  ConnOffset : ARRAY [1..26] of integer;


 (*procedure Check(lPixel: integer);
 begin
    if (lClusterBuff^[lPixel]=lClusterSign) then begin//add item
        inc(lQHead);
        inc(lClusterSz);
        lClusterBuff^[lPixel] := lClusterFillValue;
        lQra^[lQHead] := lPixel;
   end;
 end; *)

PROCEDURE RetirePixel; //FIFO cleanup , 1410: added 18-voxel check
VAR
   lVal,i, lPixel: integer;
BEGIN
   lVal := lQra^[lQTail];
   for i := 1 to numConn do begin
      //Check(lVal+ConnOffset[i]);
      lPixel := lVal+ConnOffset[i];
      if (lClusterBuff^[lPixel]=lClusterSign) then begin//add item
        inc(lQHead);
        inc(lClusterSz);
        lClusterBuff^[lPixel] := lClusterFillValue;
        lQra^[lQHead] := lPixel;
      end; //
   end;
   inc(lQTail); //done with this pixel
END;

procedure FillStart (lPt: integer); {FIFO algorithm: keep memory VERY low}
var lI: integer;
begin
  if (lClusterBuff^[lPt]<>lClusterSign) then exit;

  lClusterSz := 0;
  lQHead := 1;
  lQTail := 1;
  lQra^[lQTail] := lPt;
  //Check(lPt); // lQHead now equals 1
  while (lQHead >= lQTail) do
    RetirePixel; //lQTail incremented once per retire pixel, lQHead is incremented 0..nummConn


  for lI := lPt to lXYZ do
      if (lClusterBuff^[lI]=lClusterFillValue) then
        lClusterBuff^[lI] := lClusterSz;
end;

procedure InitConn;
var
  lValX: integer;
begin
    //first 6 share face
    ConnOffset[1] := -1;//L
    ConnOffset[2] := 1; //R
    ConnOffset[3] := -lX; //A
    ConnOffset[4] := lX; //P
    ConnOffset[5] := -lXY;//I
    ConnOffset[6] := lXY;//S
    //share edge
    //..check plane above
    ConnOffset[7] := (lXY-1); //left
    ConnOffset[8] := (lXY+1); //right
    ConnOffset[9] := (lXY-lX); //up
    ConnOffset[10] := (lXY+lX); //down
    //..check plane below
    ConnOffset[11] := (-lXY-1); //left
    ConnOffset[12] := (-lXY+1); //right
    ConnOffset[13] := (-lXY-lX); //up
    ConnOffset[14] := (-lXY+lX); //down
    //..check diagonals of current plane
    ConnOffset[15] := (-lX-1); //up, left
    ConnOffset[16] := (-lX+1); //up, right
    ConnOffset[17] := (+lX-1); //down, left
    ConnOffset[18] := (+lX+1); //down, right
    //share corner
    //..check plane above
    ConnOffset[19] := (lXY-1-lX); //left
    ConnOffset[20] := (lXY-1+lX); //right
    ConnOffset[21] := (lXY+1-lX); //up
    ConnOffset[22] := (lXY+1+lX); //down
    //..check plane BELOW
    ConnOffset[23] := (-lXY-1-lX); //left
    ConnOffset[24] := (-lXY-1+lX); //right
    ConnOffset[25] := (-lXY+1-lX); //up
    ConnOffset[26] := (-lXY+1+lX); //down
end;
begin
  lXY := lX * lY;
  lXYZ := lX*lY*lZ;
  InitConn;
  if lXYZ < 1 then exit;
  GetMem(lQra,lXYZ * sizeof(longint) );
  //check every voxel to see if it is isolated
  for lV := 1 to lXYZ do
      FillStart(lV);
    freemem(lQra);
end;

procedure ZeroFaces (var lHdr: TMRIcroHdr;  lImg: SingleP );
var
  lV,lXYZ,lX,lY,lZ,lZi,lYi,lXi: integer;
begin
  lX := lHdr.NIFTIhdr.Dim[1];
  lY := lHdr.NIFTIhdr.Dim[2];
  lZ := lHdr.NIFTIhdr.Dim[3];
  if (lX < 3) or (lY < 3) or (lZ < 3) then exit;
  for lV := 1 to (lX*lY) do lImg[lV] := 0; //bottom slice
  for lV := ((lX*lY*lZ)-(lX*lY)) to (lX*lY*lZ) do lImg[lV] := 0; //top slice
  //left side
  lV := 1;
  for lZi := 1 to lZ do begin
    for lYi := 1 to lY do begin
      lImg[lV] := 0;
      lV := lV+lX;
    end;
  end;
  //right side
  lV := lX;
  for lZi := 1 to lZ do begin
    for lYi := 1 to lY do begin
      lImg[lV] := 0;
      lV := lV+lX;
    end;
  end;
  //anterior
  for lZi := 1 to lZ do begin
    lV := (lZi-1) * lX*lY;
    for lXi := 1 to lX do begin
      lV := lV+1;
      lImg[lV] := 0;
    end;
  end;
  //posterior
  for lZi := 1 to lZ do begin
    lV := (lZi-1) * lX*lY;
    lV := lV + ((lY-1) *lX);
    for lXi := 1 to lX do begin
      lV := lV+1;
      lImg[lV] := 0;
    end;
  end;

end;


function doTFCE (var lHdr: TMRIcroHdr;  lImg: SingleP ): boolean;
//function computeTFCE (lX,lY,lZ: integer; lImg: SingleP): boolean;
const
  kSteps = 100;
var
  lV,lXYZ,lX,lY,lZ: integer;
  lMax, lThresh,E,H, ThreshPowerHxdh, dh: single;
  lThreshImg: SingleP;
  lCountImg: LongIntP;
  lStartTime: DWord;
begin
  lX := lHdr.NIFTIhdr.Dim[1];
  lY := lHdr.NIFTIhdr.Dim[2];
  lZ := lHdr.NIFTIhdr.Dim[3];
  lStartTime := GetTickCount;
  result := false;//assume failure
  lXYZ := lX*lY*lZ;
  if lXYZ < 1 then exit;
  E := 0.5; //0.5
  H := 2;//2
  getmem(lThreshImg,lXYZ*sizeof(single));
  getmem(lCountImg,lXYZ*sizeof(longint));
  ZeroFaces (lHdr,  lImg );
  lMax := lImg[1];
  for lV := 1 to lXYZ do begin
    lThreshImg[lV] := lImg[lV];
    if lImg[lV] > lMax then lMax := lImg[lV];
    lImg[lV] := 0; //initialize sum map to zero
  end;
  MainForm.NPMmsg('max = '+floattostr(lMax));
  if (lMax <= 0) then exit;

  dh := lMax / kSteps;
  lThresh := 0;
  while lThresh < lMax do begin
    lThresh := lThresh + dh;
    //MainForm.NPMmsg('thresh = '+floattostr(lThresh));
    for lV := 1 to lXYZ do begin
      if (lThreshImg[lV] <= lThresh) then
        lCountImg[lV] := 0
      else
        lCountImg[lV] := 1;
    end;
    countClusterSize (lX,lY,lZ,6, lCountImg);
    ThreshPowerHxdh := power(lThresh,H)*dh;
    for lV := 1 to lXYZ do
      if (lCountImg[lV] > 0) then
        lImg[lV] := lImg[lV] + (power(lCountImg[lV],E) * ThreshPowerHxdh);
  end;
  MainForm.NPMmsg('Time = '+inttostr(GetTickCount - lStartTime));

  freemem(lCountImg);
  freemem(lThreshImg);

  result := true; //report success!
end;

(*function doTFCE (var lHdr: TMRIcroHdr;  lImg: SingleP ): boolean;
//function ClusterTFCE (var lHdr: TMRIcroHdr; lThreshClusterSz: integer; lThresh: double ): boolean;
begin
  result := computeTFCE (lHdr.NIFTIhdr.Dim[1],lHdr.NIFTIhdr.Dim[2],lHdr.NIFTIhdr.Dim[3], lImg);
end; *)

end.
