/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.OutputStreamConverter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class LaTeXOutputHandler
implements DocumentHandler,
OutputStreamConverter {
    private boolean skipeoln = true;
    private Writer writer;
    private OutputStream out;
    private final CharacterHandler eolnCharacterHandler = new EolnCharacterHandler();
    private final CharacterHandler textCharacterHandler = new TextCharacterHandler();
    private final CharacterHandler verbCharacterHandler = new VerbCharacterHandler();
    private final CharacterHandler codeCharacterHandler = new CodeCharacterHandler();
    private CharacterHandler characterHandler;
    private int depth = 0;
    private CharacterHandler[] characterHandlers = new CharacterHandler[1];

    public LaTeXOutputHandler() {
        this.characterHandler = this.textCharacterHandler;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.writer == null) {
            this.writer = new BufferedWriter(new OutputStreamWriter(this.out));
        }
        try {
            this.characterHandler.characters(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            if (this.writer != null) {
                this.writer.close();
            } else {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string) throws SAXException {
        this.pop();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void pop() {
        this.characterHandler = this.characterHandlers[--this.depth];
    }

    public void processingInstruction(String string, String string2) {
    }

    public void push(CharacterHandler characterHandler) {
        if (this.depth >= this.characterHandlers.length) {
            CharacterHandler[] characterHandlerArray = this.characterHandlers;
            this.characterHandlers = new CharacterHandler[characterHandlerArray.length * 2];
            System.arraycopy(characterHandlerArray, 0, this.characterHandlers, 0, characterHandlerArray.length);
        }
        this.characterHandlers[this.depth++] = this.characterHandler;
        this.characterHandler = characterHandler;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void startDocument() {
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (string.equals("document")) {
            this.push(this.textCharacterHandler);
        } else if (string.equals("text")) {
            this.push(this.textCharacterHandler);
        } else if (string.equals("verb")) {
            this.push(this.verbCharacterHandler);
        } else if (string.equals("eoln")) {
            try {
                this.writer.write(10);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            this.skipeoln = true;
            this.push(this.eolnCharacterHandler);
        } else if (string.equals("code") || string.equals("latex")) {
            this.push(this.codeCharacterHandler);
        } else {
            throw new SAXException("unexpected element: " + string);
        }
    }

    class CharacterHandler {
        CharacterHandler() {
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
        }
    }

    class EolnCharacterHandler
    extends CharacterHandler {
        EolnCharacterHandler() {
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
            if (n2 > 0) {
                throw new IOException("chars in eoln element");
            }
            LaTeXOutputHandler.this.skipeoln = true;
        }
    }

    class CodeCharacterHandler
    extends CharacterHandler {
        CodeCharacterHandler() {
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
            LaTeXOutputHandler.this.writer.write(cArray, n, n2);
            LaTeXOutputHandler.this.skipeoln = false;
        }
    }

    class TextCharacterHandler
    extends CharacterHandler {
        private StringBuffer buf = new StringBuffer();

        TextCharacterHandler() {
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 < n2) {
                char c = cArray[n3];
                if (c == '\n') {
                    if (!LaTeXOutputHandler.this.skipeoln) {
                        LaTeXOutputHandler.this.skipeoln = true;
                        this.buf.append(c);
                    }
                } else if (c == '#' || c == '$' || c == '%' || c == '&' || c == '~' || c == '_' || c == '^' || c == '\\' || c == '{' || c == '}' || c == '<' || c == '>' || c == '|') {
                    this.buf.append("\\usechar{\\").append(c).append("}");
                    LaTeXOutputHandler.this.skipeoln = false;
                } else {
                    this.buf.append(c);
                    LaTeXOutputHandler.this.skipeoln = false;
                }
                ++n3;
            }
            LaTeXOutputHandler.this.writer.write(this.buf.toString(), 0, this.buf.length());
            this.buf.setLength(0);
        }
    }

    class VerbCharacterHandler
    extends CharacterHandler {
        private StringBuffer buf = new StringBuffer();

        VerbCharacterHandler() {
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 < n2) {
                char c = cArray[n3];
                if (c == '#' || c == '$' || c == '%' || c == '&' || c == '~' || c == '_' || c == '^' || c == '\\' || c == '{' || c == '}' || c == '<' || c == '>' || c == '|') {
                    this.buf.append("\\usevchar{\\").append(c).append("}");
                } else {
                    this.buf.append(c);
                }
                ++n3;
            }
            LaTeXOutputHandler.this.writer.write(this.buf.toString(), 0, this.buf.length());
            this.buf.setLength(0);
            LaTeXOutputHandler.this.skipeoln = false;
        }
    }
}

