//
// The Open Toolkit Library License
//
// Copyright (c) 2006 - 2010 the Open Toolkit library.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights to
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
// the Software, and to permit persons to whom the Software is furnished to do
// so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//



namespace MonoMac.OpenGL
{
    using System;
    using System.Text;
    using System.Runtime.InteropServices;
#pragma warning disable 3019
#pragma warning disable 1591
#pragma warning disable 1572
#pragma warning disable 1573

    partial class GL
    {


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Operate on the accumulation buffer
        /// </summary>
        /// <param name="op">
        /// <para>
        /// Specifies the accumulation buffer operation. Symbolic constants GL_ACCUM, GL_LOAD, GL_ADD, GL_MULT, and GL_RETURN are accepted.
        /// </para>
        /// </param>
        /// <param name="value">
        /// <para>
        /// Specifies a floating-point value used in the accumulation buffer operation. op determines how value is used.
        /// </para>
        /// </param>
//      [AutoGenerated(Category = "VERSION_1_0_DEPRECATED", Version = "1.0", EntryPoint = "glAccum")]
        public static
        void Accum(MonoMac.OpenGL.AccumOp op, Single value)
        {
                Core.Accum((MonoMac.OpenGL.AccumOp)op, (Single)value);
        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Set the active program object for a program pipeline object
//        /// </summary>
//        /// <param name="pipeline">
//        /// <para>
//        /// Specifies the program pipeline object to set the active program object for.
//        /// </para>
//        /// </param>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the program object to set as the active program pipeline object pipeline.
//        /// </para>
//        /// </param>
//        public static
//        void ActiveShaderProgram(Int32 pipeline, Int32 program)
//        {
//                Core.ActiveShaderProgram((UInt32)pipeline, (UInt32)program);
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Set the active program object for a program pipeline object
//        /// </summary>
//        /// <param name="pipeline">
//        /// <para>
//        /// Specifies the program pipeline object to set the active program object for.
//        /// </para>
//        /// </param>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the program object to set as the active program pipeline object pipeline.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void ActiveShaderProgram(UInt32 pipeline, UInt32 program)
//        {
//                Core.ActiveShaderProgram((UInt32)pipeline, (UInt32)program);
//        }


        /// <summary>[requires: v1.3]
        /// Select active texture unit
        /// </summary>
        /// <param name="texture">
        /// <para>
        /// Specifies which texture unit to make active. The number of texture units is implementation dependent, but must be at least two. texture must be one of GL_TEXTUREi, where i ranges from 0 (GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS - 1). The initial value is GL_TEXTURE0.
        /// </para>
        /// </param>
        public static
        void ActiveTexture(MonoMac.OpenGL.TextureUnit texture)
        {
            Core.ActiveTexture((MonoMac.OpenGL.TextureUnit)texture);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Specify the alpha test function
        /// </summary>
        /// <param name="func">
        /// <para>
        /// Specifies the alpha comparison function. Symbolic constants GL_NEVER, GL_LESS, GL_EQUAL, GL_LEQUAL, GL_GREATER, GL_NOTEQUAL, GL_GEQUAL, and GL_ALWAYS are accepted. The initial value is GL_ALWAYS.
        /// </para>
        /// </param>
        /// <param name="ref">
        /// <para>
        /// Specifies the reference value that incoming alpha values are compared to. This value is clamped to the range [0,1], where 0 represents the lowest possible alpha value and 1 the highest possible value. The initial reference value is 0.
        /// </para>
        /// </param>
        public static
        void AlphaFunc(MonoMac.OpenGL.AlphaFunction func, Single @ref)
        {
                Core.AlphaFunc((MonoMac.OpenGL.AlphaFunction)func, (Single)@ref);
        }


        /// <summary>[requires: v1.1][deprecated: v3.1]
        /// Determine if textures are loaded in texture memory
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be queried.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array containing the names of the textures to be queried.
        /// </para>
        /// </param>
        /// <param name="residences">
        /// <para>
        /// Specifies an array in which the texture residence status is returned. The residence status of a texture named by an element of textures is returned in the corresponding element of residences.
        /// </para>
        /// </param>
        public static
        bool AreTexturesResident(Int32 n, Int32[] textures, [OutAttribute] bool[] residences)
        {
                unsafe
                {
                    fixed (Int32* textures_ptr = textures)
                    fixed (bool* residences_ptr = residences)
                    {
                        return Core.AreTexturesResident((Int32)n, (UInt32*)textures_ptr, (bool*)residences_ptr);
                    }
                }
        }


//        /// <summary>[requires: v1.1][deprecated: v3.1]
//        /// Determine if textures are loaded in texture memory
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of textures to be queried.
//        /// </para>
//        /// </param>
//        /// <param name="textures">
//        /// <para>
//        /// Specifies an array containing the names of the textures to be queried.
//        /// </para>
//        /// </param>
//        /// <param name="residences">
//        /// <para>
//        /// Specifies an array in which the texture residence status is returned. The residence status of a texture named by an element of textures is returned in the corresponding element of residences.
//        /// </para>
//        /// </param>
//        public static
//        bool AreTexturesResident(Int32 n, ref Int32 textures, [OutAttribute] out bool residences)
//        {
//                unsafe
//                {
//                    fixed (Int32* textures_ptr = &textures)
//                    fixed (bool* residences_ptr = &residences)
//                    {
//                        bool retval = Core.AreTexturesResident((Int32)n, (UInt32*)textures_ptr, (bool*)residences_ptr);
//                        residences = *residences_ptr;
//                        return retval;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.1][deprecated: v3.1]
//        /// Determine if textures are loaded in texture memory
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of textures to be queried.
//        /// </para>
//        /// </param>
//        /// <param name="textures">
//        /// <para>
//        /// Specifies an array containing the names of the textures to be queried.
//        /// </para>
//        /// </param>
//        /// <param name="residences">
//        /// <para>
//        /// Specifies an array in which the texture residence status is returned. The residence status of a texture named by an element of textures is returned in the corresponding element of residences.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe bool AreTexturesResident(Int32 n, Int32* textures, [OutAttribute] bool* residences)
//        {
//                return Core.AreTexturesResident((Int32)n, (UInt32*)textures, (bool*)residences);
//        }


//        /// <summary>[requires: v1.1][deprecated: v3.1]
//        /// Determine if textures are loaded in texture memory
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of textures to be queried.
//        /// </para>
//        /// </param>
//        /// <param name="textures">
//        /// <para>
//        /// Specifies an array containing the names of the textures to be queried.
//        /// </para>
//        /// </param>
//        /// <param name="residences">
//        /// <para>
//        /// Specifies an array in which the texture residence status is returned. The residence status of a texture named by an element of textures is returned in the corresponding element of residences.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        bool AreTexturesResident(Int32 n, UInt32[] textures, [OutAttribute] bool[] residences)
//        {
//                unsafe
//                {
//                    fixed (UInt32* textures_ptr = textures)
//                    fixed (bool* residences_ptr = residences)
//                    {
//                        return Core.AreTexturesResident((Int32)n, (UInt32*)textures_ptr, (bool*)residences_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.1][deprecated: v3.1]
//        /// Determine if textures are loaded in texture memory
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of textures to be queried.
//        /// </para>
//        /// </param>
//        /// <param name="textures">
//        /// <para>
//        /// Specifies an array containing the names of the textures to be queried.
//        /// </para>
//        /// </param>
//        /// <param name="residences">
//        /// <para>
//        /// Specifies an array in which the texture residence status is returned. The residence status of a texture named by an element of textures is returned in the corresponding element of residences.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        bool AreTexturesResident(Int32 n, ref UInt32 textures, [OutAttribute] out bool residences)
//        {
//                unsafe
//                {
//                    fixed (UInt32* textures_ptr = &textures)
//                    fixed (bool* residences_ptr = &residences)
//                    {
//                        bool retval = Core.AreTexturesResident((Int32)n, (UInt32*)textures_ptr, (bool*)residences_ptr);
//                        residences = *residences_ptr;
//                        return retval;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.1][deprecated: v3.1]
//        /// Determine if textures are loaded in texture memory
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of textures to be queried.
//        /// </para>
//        /// </param>
//        /// <param name="textures">
//        /// <para>
//        /// Specifies an array containing the names of the textures to be queried.
//        /// </para>
//        /// </param>
//        /// <param name="residences">
//        /// <para>
//        /// Specifies an array in which the texture residence status is returned. The residence status of a texture named by an element of textures is returned in the corresponding element of residences.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe bool AreTexturesResident(Int32 n, UInt32* textures, [OutAttribute] bool* residences)
//        {
//                return Core.AreTexturesResident((Int32)n, (UInt32*)textures, (bool*)residences);
//        }


        /// <summary>[requires: v1.1][deprecated: v3.1]
        /// Render a vertex using the specified vertex array element
        /// </summary>
        /// <param name="i">
        /// <para>
        /// Specifies an index into the enabled vertex data arrays.
        /// </para>
        /// </param>
        public static
        void ArrayElement(Int32 i)
        {
                Core.ArrayElement((Int32)i);
        }


        /// <summary>[requires: v2.0]
        /// Attaches a shader object to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to which a shader object will be attached.
        /// </para>
        /// </param>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object that is to be attached.
        /// </para>
        /// </param>
        public static
        void AttachShader(Int32 program, Int32 shader)
        {
            Core.AttachShader((UInt32)program, (UInt32)shader);
        }


        /// <summary>[requires: v2.0]
        /// Attaches a shader object to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to which a shader object will be attached.
        /// </para>
        /// </param>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object that is to be attached.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void AttachShader(UInt32 program, UInt32 shader)
        {
            Core.AttachShader((UInt32)program, (UInt32)shader);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Delimit the vertices of a primitive or a group of like primitives
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies the primitive or primitives that will be created from vertices presented between glBegin and the subsequent glEnd. Ten symbolic constants are accepted: GL_POINTS, GL_LINES, GL_LINE_STRIP, GL_LINE_LOOP, GL_TRIANGLES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_QUADS, GL_QUAD_STRIP, and GL_POLYGON.
        /// </para>
        /// </param>
        public static
        void Begin(MonoMac.OpenGL.BeginMode mode)
        {
                Core.Begin((MonoMac.OpenGL.BeginMode)mode);
        }


//        /// <summary>[requires: v3.0]
//        /// Start conditional rendering
//        /// </summary>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of an occlusion query object whose results are used to determine if the rendering commands are discarded.
//        /// </para>
//        /// </param>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies how glBeginConditionalRender interprets the results of the occlusion query.
//        /// </para>
//        /// </param>
//        public static
//        void BeginConditionalRender(Int32 id, MonoMac.OpenGL.ConditionalRenderType mode)
//        {
//                Core.BeginConditionalRender((UInt32)id, (MonoMac.OpenGL.ConditionalRenderType)mode);
//        }


//        /// <summary>[requires: v3.0]
//        /// Start conditional rendering
//        /// </summary>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of an occlusion query object whose results are used to determine if the rendering commands are discarded.
//        /// </para>
//        /// </param>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies how glBeginConditionalRender interprets the results of the occlusion query.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BeginConditionalRender(UInt32 id, MonoMac.OpenGL.ConditionalRenderType mode)
//        {
//                Core.BeginConditionalRender((UInt32)id, (MonoMac.OpenGL.ConditionalRenderType)mode);
//        }


        /// <summary>[requires: v1.5]
        /// Delimit the boundaries of a query object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target type of query object established between glBeginQuery and the subsequent glEndQuery. The symbolic constant must be one of GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, or GL_TIME_ELAPSED.
        /// </para>
        /// </param>
        /// <param name="id">
        /// <para>
        /// Specifies the name of a query object.
        /// </para>
        /// </param>
        public static
        void BeginQuery(MonoMac.OpenGL.QueryTarget target, Int32 id)
        {
            Core.BeginQuery((MonoMac.OpenGL.QueryTarget)target, (UInt32)id);
        }


        /// <summary>[requires: v1.5]
        /// Delimit the boundaries of a query object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target type of query object established between glBeginQuery and the subsequent glEndQuery. The symbolic constant must be one of GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, or GL_TIME_ELAPSED.
        /// </para>
        /// </param>
        /// <param name="id">
        /// <para>
        /// Specifies the name of a query object.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void BeginQuery(MonoMac.OpenGL.QueryTarget target, UInt32 id)
        {
            Core.BeginQuery((MonoMac.OpenGL.QueryTarget)target, (UInt32)id);
        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback3]
//        /// Delimit the boundaries of a query object on an indexed target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the target type of query object established between glBeginQueryIndexed and the subsequent glEndQueryIndexed. The symbolic constant must be one of GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, or GL_TIME_ELAPSED.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the query target upon which to begin the query.
//        /// </para>
//        /// </param>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a query object.
//        /// </para>
//        /// </param>
//        public static
//        void BeginQueryIndexed(MonoMac.OpenGL.QueryTarget target, Int32 index, Int32 id)
//        {
//                Core.BeginQueryIndexed((MonoMac.OpenGL.QueryTarget)target, (UInt32)index, (UInt32)id);
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback3]
//        /// Delimit the boundaries of a query object on an indexed target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the target type of query object established between glBeginQueryIndexed and the subsequent glEndQueryIndexed. The symbolic constant must be one of GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, or GL_TIME_ELAPSED.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the query target upon which to begin the query.
//        /// </para>
//        /// </param>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a query object.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BeginQueryIndexed(MonoMac.OpenGL.QueryTarget target, UInt32 index, UInt32 id)
//        {
//                Core.BeginQueryIndexed((MonoMac.OpenGL.QueryTarget)target, (UInt32)index, (UInt32)id);
//        }


//        /// <summary>[requires: v3.0]
//        /// Start transform feedback operation
//        /// </summary>
//        /// <param name="primitiveMode">
//        /// <para>
//        /// Specify the output type of the primitives that will be recorded into the buffer objects that are bound for transform feedback.
//        /// </para>
//        /// </param>
//        public static
//        void BeginTransformFeedback(MonoMac.OpenGL.BeginFeedbackMode primitiveMode)
//        {
//                Core.BeginTransformFeedback((MonoMac.OpenGL.BeginFeedbackMode)primitiveMode);
//        }


        /// <summary>[requires: v2.0]
        /// Associates a generic vertex attribute index with a named attribute variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object in which the association is to be made.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be bound.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Specifies a null terminated string containing the name of the vertex shader attribute variable to which index is to be bound.
        /// </para>
        /// </param>
        public static
        void BindAttribLocation(Int32 program, Int32 index, String name)
        {
            Core.BindAttribLocation((UInt32)program, (UInt32)index, (String)name);
        }


        /// <summary>[requires: v2.0]
        /// Associates a generic vertex attribute index with a named attribute variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the handle of the program object in which the association is to be made.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be bound.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Specifies a null terminated string containing the name of the vertex shader attribute variable to which index is to be bound.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void BindAttribLocation(UInt32 program, UInt32 index, String name)
        {
            Core.BindAttribLocation((UInt32)program, (UInt32)index, (String)name);
        }


        /// <summary>[requires: v1.5]
        /// Bind a named buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the buffer object is bound. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="buffer">
        /// <para>
        /// Specifies the name of a buffer object.
        /// </para>
        /// </param>
        public static
        void BindBuffer(MonoMac.OpenGL.BufferTarget target, Int32 buffer)
        {
            Core.BindBuffer((MonoMac.OpenGL.BufferTarget)target, (UInt32)buffer);
        }


        /// <summary>[requires: v1.5]
        /// Bind a named buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the buffer object is bound. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="buffer">
        /// <para>
        /// Specifies the name of a buffer object.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void BindBuffer(MonoMac.OpenGL.BufferTarget target, UInt32 buffer)
        {
            Core.BindBuffer((MonoMac.OpenGL.BufferTarget)target, (UInt32)buffer);
        }


//        /// <summary>[requires: v3.0]
//        /// Bind a buffer object to an indexed buffer target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specify the target of the bind operation. target must be either GL_TRANSFORM_FEEDBACK_BUFFER or GL_UNIFORM_BUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specify the index of the binding point within the array specified by target.
//        /// </para>
//        /// </param>
//        /// <param name="buffer">
//        /// <para>
//        /// The name of a buffer object to bind to the specified binding point.
//        /// </para>
//        /// </param>
//        public static
//        void BindBufferBase(MonoMac.OpenGL.BufferTarget target, Int32 index, Int32 buffer)
//        {
//                Core.BindBufferBase((MonoMac.OpenGL.BufferTarget)target, (UInt32)index, (UInt32)buffer);
//        }


//        /// <summary>[requires: v3.0]
//        /// Bind a buffer object to an indexed buffer target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specify the target of the bind operation. target must be either GL_TRANSFORM_FEEDBACK_BUFFER or GL_UNIFORM_BUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specify the index of the binding point within the array specified by target.
//        /// </para>
//        /// </param>
//        /// <param name="buffer">
//        /// <para>
//        /// The name of a buffer object to bind to the specified binding point.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BindBufferBase(MonoMac.OpenGL.BufferTarget target, UInt32 index, UInt32 buffer)
//        {
//                Core.BindBufferBase((MonoMac.OpenGL.BufferTarget)target, (UInt32)index, (UInt32)buffer);
//        }


//        /// <summary>[requires: v3.0]
//        /// Bind a range within a buffer object to an indexed buffer target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specify the target of the bind operation. target must be either GL_TRANSFORM_FEEDBACK_BUFFER or GL_UNIFORM_BUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specify the index of the binding point within the array specified by target.
//        /// </para>
//        /// </param>
//        /// <param name="buffer">
//        /// <para>
//        /// The name of a buffer object to bind to the specified binding point.
//        /// </para>
//        /// </param>
//        /// <param name="offset">
//        /// <para>
//        /// The starting offset in basic machine units into the buffer object buffer.
//        /// </para>
//        /// </param>
//        /// <param name="size">
//        /// <para>
//        /// The amount of data in machine units that can be read from the buffet object while used as an indexed target.
//        /// </para>
//        /// </param>
//        public static
//        void BindBufferRange(MonoMac.OpenGL.BufferTarget target, Int32 index, Int32 buffer, IntPtr offset, IntPtr size)
//        {
//                Core.BindBufferRange((MonoMac.OpenGL.BufferTarget)target, (UInt32)index, (UInt32)buffer, (IntPtr)offset, (IntPtr)size);
//        }


//        /// <summary>[requires: v3.0]
//        /// Bind a range within a buffer object to an indexed buffer target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specify the target of the bind operation. target must be either GL_TRANSFORM_FEEDBACK_BUFFER or GL_UNIFORM_BUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specify the index of the binding point within the array specified by target.
//        /// </para>
//        /// </param>
//        /// <param name="buffer">
//        /// <para>
//        /// The name of a buffer object to bind to the specified binding point.
//        /// </para>
//        /// </param>
//        /// <param name="offset">
//        /// <para>
//        /// The starting offset in basic machine units into the buffer object buffer.
//        /// </para>
//        /// </param>
//        /// <param name="size">
//        /// <para>
//        /// The amount of data in machine units that can be read from the buffet object while used as an indexed target.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BindBufferRange(MonoMac.OpenGL.BufferTarget target, UInt32 index, UInt32 buffer, IntPtr offset, IntPtr size)
//        {
//                Core.BindBufferRange((MonoMac.OpenGL.BufferTarget)target, (UInt32)index, (UInt32)buffer, (IntPtr)offset, (IntPtr)size);
//        }


//        /// <summary>[requires: v3.0]
//        /// Bind a user-defined varying out variable to a fragment shader color number
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// The name of the program containing varying out variable whose binding to modify
//        /// </para>
//        /// </param>
//        /// <param name="colorNumber">
//        /// <para>
//        /// The color number to bind the user-defined varying out variable to
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// The name of the user-defined varying out variable whose binding to modify
//        /// </para>
//        /// </param>
//        public static
//        void BindFragDataLocation(Int32 program, Int32 color, String name)
//        {
//                Core.BindFragDataLocation((UInt32)program, (UInt32)color, (String)name);
//        }


//        /// <summary>[requires: v3.0]
//        /// Bind a user-defined varying out variable to a fragment shader color number
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// The name of the program containing varying out variable whose binding to modify
//        /// </para>
//        /// </param>
//        /// <param name="colorNumber">
//        /// <para>
//        /// The color number to bind the user-defined varying out variable to
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// The name of the user-defined varying out variable whose binding to modify
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BindFragDataLocation(UInt32 program, UInt32 color, String name)
//        {
//                Core.BindFragDataLocation((UInt32)program, (UInt32)color, (String)name);
//        }


//        /// <summary>[requires: v1.2 and ARB_blend_func_extended]
//        /// Bind a user-defined varying out variable to a fragment shader color number and index
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// The name of the program containing varying out variable whose binding to modify
//        /// </para>
//        /// </param>
//        /// <param name="colorNumber">
//        /// <para>
//        /// The color number to bind the user-defined varying out variable to
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// The index of the color input to bind the user-defined varying out variable to
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// The name of the user-defined varying out variable whose binding to modify
//        /// </para>
//        /// </param>
//        public static
//        void BindFragDataLocationIndexed(Int32 program, Int32 colorNumber, Int32 index, String name)
//        {
//                Core.BindFragDataLocationIndexed((UInt32)program, (UInt32)colorNumber, (UInt32)index, (String)name);
//        }


//        /// <summary>[requires: v1.2 and ARB_blend_func_extended]
//        /// Bind a user-defined varying out variable to a fragment shader color number and index
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// The name of the program containing varying out variable whose binding to modify
//        /// </para>
//        /// </param>
//        /// <param name="colorNumber">
//        /// <para>
//        /// The color number to bind the user-defined varying out variable to
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// The index of the color input to bind the user-defined varying out variable to
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// The name of the user-defined varying out variable whose binding to modify
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BindFragDataLocationIndexed(UInt32 program, UInt32 colorNumber, UInt32 index, String name)
//        {
//                Core.BindFragDataLocationIndexed((UInt32)program, (UInt32)colorNumber, (UInt32)index, (String)name);
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Bind a framebuffer to a framebuffer target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the framebuffer target of the binding operation.
//        /// </para>
//        /// </param>
//        /// <param name="framebuffer">
//        /// <para>
//        /// Specifies the name of the framebuffer object to bind.
//        /// </para>
//        /// </param>
//        public static
//        void BindFramebuffer(MonoMac.OpenGL.FramebufferTarget target, Int32 framebuffer)
//        {
//                Core.BindFramebuffer((MonoMac.OpenGL.FramebufferTarget)target, (UInt32)framebuffer);
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Bind a framebuffer to a framebuffer target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the framebuffer target of the binding operation.
//        /// </para>
//        /// </param>
//        /// <param name="framebuffer">
//        /// <para>
//        /// Specifies the name of the framebuffer object to bind.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BindFramebuffer(MonoMac.OpenGL.FramebufferTarget target, UInt32 framebuffer)
//        {
//                Core.BindFramebuffer((MonoMac.OpenGL.FramebufferTarget)target, (UInt32)framebuffer);
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Bind a program pipeline to the current context
//        /// </summary>
//        /// <param name="pipeline">
//        /// <para>
//        /// Specifies the name of the pipeline object to bind to the context.
//        /// </para>
//        /// </param>
//        public static
//        void BindProgramPipeline(Int32 pipeline)
//        {
//                Core.BindProgramPipeline((UInt32)pipeline);
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Bind a program pipeline to the current context
//        /// </summary>
//        /// <param name="pipeline">
//        /// <para>
//        /// Specifies the name of the pipeline object to bind to the context.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BindProgramPipeline(UInt32 pipeline)
//        {
//                Core.BindProgramPipeline((UInt32)pipeline);
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Bind a renderbuffer to a renderbuffer target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the renderbuffer target of the binding operation. target must be GL_RENDERBUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffer">
//        /// <para>
//        /// Specifies the name of the renderbuffer object to bind.
//        /// </para>
//        /// </param>
//        public static
//        void BindRenderbuffer(MonoMac.OpenGL.RenderbufferTarget target, Int32 renderbuffer)
//        {
//                Core.BindRenderbuffer((MonoMac.OpenGL.RenderbufferTarget)target, (UInt32)renderbuffer);
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Bind a renderbuffer to a renderbuffer target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the renderbuffer target of the binding operation. target must be GL_RENDERBUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffer">
//        /// <para>
//        /// Specifies the name of the renderbuffer object to bind.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BindRenderbuffer(MonoMac.OpenGL.RenderbufferTarget target, UInt32 renderbuffer)
//        {
//                Core.BindRenderbuffer((MonoMac.OpenGL.RenderbufferTarget)target, (UInt32)renderbuffer);
//        }


//        /// <summary>[requires: v1.2 and ARB_sampler_objects]
//        /// Bind a named sampler to a texturing target
//        /// </summary>
//        /// <param name="unit">
//        /// <para>
//        /// Specifies the index of the texture unit to which the sampler is bound.
//        /// </para>
//        /// </param>
//        /// <param name="sampler">
//        /// <para>
//        /// Specifies the name of a sampler.
//        /// </para>
//        /// </param>
//        public static
//        void BindSampler(Int32 unit, Int32 sampler)
//        {
//                Core.BindSampler((UInt32)unit, (UInt32)sampler);
//        }


//        /// <summary>[requires: v1.2 and ARB_sampler_objects]
//        /// Bind a named sampler to a texturing target
//        /// </summary>
//        /// <param name="unit">
//        /// <para>
//        /// Specifies the index of the texture unit to which the sampler is bound.
//        /// </para>
//        /// </param>
//        /// <param name="sampler">
//        /// <para>
//        /// Specifies the name of a sampler.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BindSampler(UInt32 unit, UInt32 sampler)
//        {
//                Core.BindSampler((UInt32)unit, (UInt32)sampler);
//        }


        /// <summary>[requires: v1.1]
        /// Bind a named texture to a texturing target
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the texture is bound. Must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_RECTANGLE, GL_TEXTURE_CUBE_MAP, GL_TEXTURE_2D_MULTISAMPLE or GL_TEXTURE_2D_MULTISAMPLE_ARRAY.
        /// </para>
        /// </param>
        /// <param name="texture">
        /// <para>
        /// Specifies the name of a texture.
        /// </para>
        /// </param>
        public static
        void BindTexture(MonoMac.OpenGL.TextureTarget target, Int32 texture)
        {
                Core.BindTexture((MonoMac.OpenGL.TextureTarget)target, (UInt32)texture);
        }


        /// <summary>[requires: v1.1]
        /// Bind a named texture to a texturing target
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target to which the texture is bound. Must be either GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, or GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY, GL_TEXTURE_RECTANGLE, GL_TEXTURE_CUBE_MAP, GL_TEXTURE_2D_MULTISAMPLE or GL_TEXTURE_2D_MULTISAMPLE_ARRAY.
        /// </para>
        /// </param>
        /// <param name="texture">
        /// <para>
        /// Specifies the name of a texture.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void BindTexture(MonoMac.OpenGL.TextureTarget target, UInt32 texture)
        {
            Core.BindTexture((MonoMac.OpenGL.TextureTarget)target, (UInt32)texture);
        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Bind a transform feedback object
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the target to which to bind the transform feedback object id. target must be GL_TRANSFORM_FEEDBACK.
//        /// </para>
//        /// </param>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a transform feedback object reserved by glGenTransformFeedbacks.
//        /// </para>
//        /// </param>
//        public static
//        void BindTransformFeedback(MonoMac.OpenGL.TransformFeedbackTarget target, Int32 id)
//        {
//                Core.BindTransformFeedback((MonoMac.OpenGL.TransformFeedbackTarget)target, (UInt32)id);
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Bind a transform feedback object
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the target to which to bind the transform feedback object id. target must be GL_TRANSFORM_FEEDBACK.
//        /// </para>
//        /// </param>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a transform feedback object reserved by glGenTransformFeedbacks.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BindTransformFeedback(MonoMac.OpenGL.TransformFeedbackTarget target, UInt32 id)
//        {
//                Core.BindTransformFeedback((MonoMac.OpenGL.TransformFeedbackTarget)target, (UInt32)id);
//        }


//        /// <summary>[requires: v3.0 and ARB_vertex_array_object]
//        /// Bind a vertex array object
//        /// </summary>
//        /// <param name="array">
//        /// <para>
//        /// Specifies the name of the vertex array to bind.
//        /// </para>
//        /// </param>
//        public static
//        void BindVertexArray(Int32 array)
//        {
//                Core.BindVertexArray((UInt32)array);
//        }


//        /// <summary>[requires: v3.0 and ARB_vertex_array_object]
//        /// Bind a vertex array object
//        /// </summary>
//        /// <param name="array">
//        /// <para>
//        /// Specifies the name of the vertex array to bind.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BindVertexArray(UInt32 array)
//        {
//                Core.BindVertexArray((UInt32)array);
//        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Draw a bitmap
        /// </summary>
        /// <param name="width">
        /// <para>
        /// Specify the pixel width and height of the bitmap image.
        /// </para>
        /// </param>
        /// <param name="xorig">
        /// <para>
        /// Specify the location of the origin in the bitmap image. The origin is measured from the lower left corner of the bitmap, with right and up being the positive axes.
        /// </para>
        /// </param>
        /// <param name="xmove">
        /// <para>
        /// Specify the x and y offsets to be added to the current raster position after the bitmap is drawn.
        /// </para>
        /// </param>
        /// <param name="bitmap">
        /// <para>
        /// Specifies the address of the bitmap image.
        /// </para>
        /// </param>
        public static
        void Bitmap(Int32 width, Int32 height, Single xorig, Single yorig, Single xmove, Single ymove, Byte[] bitmap)
        {
                unsafe
                {
                    fixed (Byte* bitmap_ptr = bitmap)
                    {
                        Core.Bitmap((Int32)width, (Int32)height, (Single)xorig, (Single)yorig, (Single)xmove, (Single)ymove, (Byte*)bitmap_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Draw a bitmap
        /// </summary>
        /// <param name="width">
        /// <para>
        /// Specify the pixel width and height of the bitmap image.
        /// </para>
        /// </param>
        /// <param name="xorig">
        /// <para>
        /// Specify the location of the origin in the bitmap image. The origin is measured from the lower left corner of the bitmap, with right and up being the positive axes.
        /// </para>
        /// </param>
        /// <param name="xmove">
        /// <para>
        /// Specify the x and y offsets to be added to the current raster position after the bitmap is drawn.
        /// </para>
        /// </param>
        /// <param name="bitmap">
        /// <para>
        /// Specifies the address of the bitmap image.
        /// </para>
        /// </param>
        public static
        void Bitmap(Int32 width, Int32 height, Single xorig, Single yorig, Single xmove, Single ymove, ref Byte bitmap)
        {
            unsafe
            {
                fixed (Byte* bitmap_ptr = &bitmap)
                {
                    Core.Bitmap((Int32)width, (Int32)height, (Single)xorig, (Single)yorig, (Single)xmove, (Single)ymove, (Byte*)bitmap_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Draw a bitmap
        /// </summary>
        /// <param name="width">
        /// <para>
        /// Specify the pixel width and height of the bitmap image.
        /// </para>
        /// </param>
        /// <param name="xorig">
        /// <para>
        /// Specify the location of the origin in the bitmap image. The origin is measured from the lower left corner of the bitmap, with right and up being the positive axes.
        /// </para>
        /// </param>
        /// <param name="xmove">
        /// <para>
        /// Specify the x and y offsets to be added to the current raster position after the bitmap is drawn.
        /// </para>
        /// </param>
        /// <param name="bitmap">
        /// <para>
        /// Specifies the address of the bitmap image.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Bitmap(Int32 width, Int32 height, Single xorig, Single yorig, Single xmove, Single ymove, Byte* bitmap)
        {
            Core.Bitmap((Int32)width, (Int32)height, (Single)xorig, (Single)yorig, (Single)xmove, (Single)ymove, (Byte*)bitmap);
        }


        /// <summary>[requires: v1.2]
        /// Set the blend color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// specify the components of GL_BLEND_COLOR
        /// </para>
        /// </param>
        public static
        void BlendColor(Single red, Single green, Single blue, Single alpha)
        {
                Core.BlendColor((Single)red, (Single)green, (Single)blue, (Single)alpha);
        }


        /// <summary>[requires: v1.2]
        /// Specify the equation used for both the RGB blend equation and the Alpha blend equation
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// specifies how source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
        /// </para>
        /// </param>
        public static
        void BlendEquation(MonoMac.OpenGL.BlendEquationMode mode)
        {
                Core.BlendEquation((MonoMac.OpenGL.BlendEquationMode)mode);
        }


//        /// <summary>[requires: v1.2]
//        /// Specify the equation used for both the RGB blend equation and the Alpha blend equation
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// specifies how source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
//        /// </para>
//        /// </param>
//        public static
//        void BlendEquation(Int32 buf, MonoMac.OpenGL.Version40 mode)
//        {
//                Core.BlendEquationi((UInt32)buf, (MonoMac.OpenGL.Version40)mode);
//        }


//        /// <summary>[requires: v1.2]
//        /// Specify the equation used for both the RGB blend equation and the Alpha blend equation
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// specifies how source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BlendEquation(UInt32 buf, MonoMac.OpenGL.Version40 mode)
//        {
//                Core.BlendEquationi((UInt32)buf, (MonoMac.OpenGL.Version40)mode);
//        }


        /// <summary>[requires: v2.0]
        /// Set the RGB blend equation and the alpha blend equation separately
        /// </summary>
        /// <param name="modeRGB">
        /// <para>
        /// specifies the RGB blend equation, how the red, green, and blue components of the source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
        /// </para>
        /// </param>
        /// <param name="modeAlpha">
        /// <para>
        /// specifies the alpha blend equation, how the alpha component of the source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
        /// </para>
        /// </param>
        public static
        void BlendEquationSeparate(MonoMac.OpenGL.BlendEquationMode modeRGB, MonoMac.OpenGL.BlendEquationMode modeAlpha)
        {
            Core.BlendEquationSeparate((MonoMac.OpenGL.BlendEquationMode)modeRGB, (MonoMac.OpenGL.BlendEquationMode)modeAlpha);
        }


        ///// <summary>[requires: v1.2]
        ///// Set the RGB blend equation and the alpha blend equation separately
        ///// </summary>
        ///// <param name="modeRGB">
        ///// <para>
        ///// specifies the RGB blend equation, how the red, green, and blue components of the source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
        ///// </para>
        ///// </param>
        ///// <param name="modeAlpha">
        ///// <para>
        ///// specifies the alpha blend equation, how the alpha component of the source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
        ///// </para>
        ///// </param>
        //publics static
        //void BlendEquationSeparate(Int32 buf, MonoMac.OpenGL.BlendEquationMode modeRGB, MonoMac.OpenGL.BlendEquationMode modeAlpha)
        //{
        //        Core.BlendEquationSeparatei((UInt32)buf, (MonoMac.OpenGL.BlendEquationMode)modeRGB, (MonoMac.OpenGL.BlendEquationMode)modeAlpha);
        //}


//        /// <summary>[requires: v1.2]
//        /// Set the RGB blend equation and the alpha blend equation separately
//        /// </summary>
//        /// <param name="modeRGB">
//        /// <para>
//        /// specifies the RGB blend equation, how the red, green, and blue components of the source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
//        /// </para>
//        /// </param>
//        /// <param name="modeAlpha">
//        /// <para>
//        /// specifies the alpha blend equation, how the alpha component of the source and destination colors are combined. It must be GL_FUNC_ADD, GL_FUNC_SUBTRACT, GL_FUNC_REVERSE_SUBTRACT, GL_MIN, GL_MAX.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BlendEquationSeparate(UInt32 buf, MonoMac.OpenGL.BlendEquationMode modeRGB, MonoMac.OpenGL.BlendEquationMode modeAlpha)
//        {
//                Core.BlendEquationSeparatei((UInt32)buf, (MonoMac.OpenGL.BlendEquationMode)modeRGB, (MonoMac.OpenGL.BlendEquationMode)modeAlpha);
//        }


        /// <summary>[requires: v1.0]
        /// Specify pixel arithmetic
        /// </summary>
        /// <param name="sfactor">
        /// <para>
        /// Specifies how the red, green, blue, and alpha source blending factors are computed. The initial value is GL_ONE.
        /// </para>
        /// </param>
        /// <param name="dfactor">
        /// <para>
        /// Specifies how the red, green, blue, and alpha destination blending factors are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA. GL_CONSTANT_COLOR, GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, and GL_ONE_MINUS_CONSTANT_ALPHA. The initial value is GL_ZERO.
        /// </para>
        /// </param>
        public static
        void BlendFunc(MonoMac.OpenGL.BlendingFactorSrc sfactor, MonoMac.OpenGL.BlendingFactorDest dfactor)
        {
                Core.BlendFunc((MonoMac.OpenGL.BlendingFactorSrc)sfactor, (MonoMac.OpenGL.BlendingFactorDest)dfactor);
        }


//        /// <summary>[requires: v1.2]
//        /// Specify pixel arithmetic
//        /// </summary>
//        /// <param name="sfactor">
//        /// <para>
//        /// Specifies how the red, green, blue, and alpha source blending factors are computed. The initial value is GL_ONE.
//        /// </para>
//        /// </param>
//        /// <param name="dfactor">
//        /// <para>
//        /// Specifies how the red, green, blue, and alpha destination blending factors are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA. GL_CONSTANT_COLOR, GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, and GL_ONE_MINUS_CONSTANT_ALPHA. The initial value is GL_ZERO.
//        /// </para>
//        /// </param>
//        public static
//        void BlendFunc(Int32 buf, MonoMac.OpenGL.Version40 src, MonoMac.OpenGL.Version40 dst)
//        {
//                Core.BlendFunci((UInt32)buf, (MonoMac.OpenGL.Version40)src, (MonoMac.OpenGL.Version40)dst);
//        }


//        /// <summary>[requires: v1.2]
//        /// Specify pixel arithmetic
//        /// </summary>
//        /// <param name="sfactor">
//        /// <para>
//        /// Specifies how the red, green, blue, and alpha source blending factors are computed. The initial value is GL_ONE.
//        /// </para>
//        /// </param>
//        /// <param name="dfactor">
//        /// <para>
//        /// Specifies how the red, green, blue, and alpha destination blending factors are computed. The following symbolic constants are accepted: GL_ZERO, GL_ONE, GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR, GL_DST_COLOR, GL_ONE_MINUS_DST_COLOR, GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_DST_ALPHA, GL_ONE_MINUS_DST_ALPHA. GL_CONSTANT_COLOR, GL_ONE_MINUS_CONSTANT_COLOR, GL_CONSTANT_ALPHA, and GL_ONE_MINUS_CONSTANT_ALPHA. The initial value is GL_ZERO.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BlendFunc(UInt32 buf, MonoMac.OpenGL.Version40 src, MonoMac.OpenGL.Version40 dst)
//        {
//                Core.BlendFunci((UInt32)buf, (MonoMac.OpenGL.Version40)src, (MonoMac.OpenGL.Version40)dst);
//        }


        /// <summary>[requires: v1.4]
        /// Specify pixel arithmetic for RGB and alpha components separately
        /// </summary>
        /// <param name="srcRGB">
        /// <para>
        /// Specifies how the red, green, and blue blending factors are computed. The initial value is GL_ONE.
        /// </para>
        /// </param>
        /// <param name="dstRGB">
        /// <para>
        /// Specifies how the red, green, and blue destination blending factors are computed. The initial value is GL_ZERO.
        /// </para>
        /// </param>
        /// <param name="srcAlpha">
        /// <para>
        /// Specified how the alpha source blending factor is computed. The initial value is GL_ONE.
        /// </para>
        /// </param>
        /// <param name="dstAlpha">
        /// <para>
        /// Specified how the alpha destination blending factor is computed. The initial value is GL_ZERO.
        /// </para>
        /// </param>
        public static
        void BlendFuncSeparate(MonoMac.OpenGL.BlendingFactorSrc sfactorRGB, MonoMac.OpenGL.BlendingFactorDest dfactorRGB, MonoMac.OpenGL.BlendingFactorSrc sfactorAlpha, MonoMac.OpenGL.BlendingFactorDest dfactorAlpha)
        {
            Core.BlendFuncSeparate((MonoMac.OpenGL.BlendingFactorSrc)sfactorRGB, (MonoMac.OpenGL.BlendingFactorDest)dfactorRGB, (MonoMac.OpenGL.BlendingFactorSrc)sfactorAlpha, (MonoMac.OpenGL.BlendingFactorDest)dfactorAlpha);
        }


//        /// <summary>[requires: v1.2]
//        /// Specify pixel arithmetic for RGB and alpha components separately
//        /// </summary>
//        /// <param name="srcRGB">
//        /// <para>
//        /// Specifies how the red, green, and blue blending factors are computed. The initial value is GL_ONE.
//        /// </para>
//        /// </param>
//        /// <param name="dstRGB">
//        /// <para>
//        /// Specifies how the red, green, and blue destination blending factors are computed. The initial value is GL_ZERO.
//        /// </para>
//        /// </param>
//        /// <param name="srcAlpha">
//        /// <para>
//        /// Specified how the alpha source blending factor is computed. The initial value is GL_ONE.
//        /// </para>
//        /// </param>
//        /// <param name="dstAlpha">
//        /// <para>
//        /// Specified how the alpha destination blending factor is computed. The initial value is GL_ZERO.
//        /// </para>
//        /// </param>
//        public static
//        void BlendFuncSeparate(Int32 buf, MonoMac.OpenGL.Version40 srcRGB, MonoMac.OpenGL.Version40 dstRGB, MonoMac.OpenGL.Version40 srcAlpha, MonoMac.OpenGL.Version40 dstAlpha)
//        {
//                Core.BlendFuncSeparatei((UInt32)buf, (MonoMac.OpenGL.Version40)srcRGB, (MonoMac.OpenGL.Version40)dstRGB, (MonoMac.OpenGL.Version40)srcAlpha, (MonoMac.OpenGL.Version40)dstAlpha);
//        }


//        /// <summary>[requires: v1.2]
//        /// Specify pixel arithmetic for RGB and alpha components separately
//        /// </summary>
//        /// <param name="srcRGB">
//        /// <para>
//        /// Specifies how the red, green, and blue blending factors are computed. The initial value is GL_ONE.
//        /// </para>
//        /// </param>
//        /// <param name="dstRGB">
//        /// <para>
//        /// Specifies how the red, green, and blue destination blending factors are computed. The initial value is GL_ZERO.
//        /// </para>
//        /// </param>
//        /// <param name="srcAlpha">
//        /// <para>
//        /// Specified how the alpha source blending factor is computed. The initial value is GL_ONE.
//        /// </para>
//        /// </param>
//        /// <param name="dstAlpha">
//        /// <para>
//        /// Specified how the alpha destination blending factor is computed. The initial value is GL_ZERO.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void BlendFuncSeparate(UInt32 buf, MonoMac.OpenGL.Version40 srcRGB, MonoMac.OpenGL.Version40 dstRGB, MonoMac.OpenGL.Version40 srcAlpha, MonoMac.OpenGL.Version40 dstAlpha)
//        {
//                Core.BlendFuncSeparatei((UInt32)buf, (MonoMac.OpenGL.Version40)srcRGB, (MonoMac.OpenGL.Version40)dstRGB, (MonoMac.OpenGL.Version40)srcAlpha, (MonoMac.OpenGL.Version40)dstAlpha);
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Copy a block of pixels from the read framebuffer to the draw framebuffer
//        /// </summary>
//        /// <param name="srcX0">
//        /// <para>
//        /// Specify the bounds of the source rectangle within the read buffer of the read framebuffer.
//        /// </para>
//        /// </param>
//        /// <param name="dstX0">
//        /// <para>
//        /// Specify the bounds of the destination rectangle within the write buffer of the write framebuffer.
//        /// </para>
//        /// </param>
//        /// <param name="mask">
//        /// <para>
//        /// The bitwise OR of the flags indicating which buffers are to be copied. The allowed flags are GL_COLOR_BUFFER_BIT, GL_DEPTH_BUFFER_BIT and GL_STENCIL_BUFFER_BIT.
//        /// </para>
//        /// </param>
//        /// <param name="filter">
//        /// <para>
//        /// Specifies the interpolation to be applied if the image is stretched. Must be GL_NEAREST or GL_LINEAR.
//        /// </para>
//        /// </param>
//        public static
//        void BlitFramebuffer(Int32 srcX0, Int32 srcY0, Int32 srcX1, Int32 srcY1, Int32 dstX0, Int32 dstY0, Int32 dstX1, Int32 dstY1, MonoMac.OpenGL.ClearBufferMask mask, MonoMac.OpenGL.BlitFramebufferFilter filter)
//        {
//                Core.BlitFramebuffer((Int32)srcX0, (Int32)srcY0, (Int32)srcX1, (Int32)srcY1, (Int32)dstX0, (Int32)dstY0, (Int32)dstX1, (Int32)dstY1, (MonoMac.OpenGL.ClearBufferMask)mask, (MonoMac.OpenGL.BlitFramebufferFilter)filter);
//        }


        /// <summary>[requires: v1.5]
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        public static
        void BufferData(MonoMac.OpenGL.BufferTarget target, IntPtr size, IntPtr data, MonoMac.OpenGL.BufferUsageHint usage)
        {
            Core.BufferData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)size, (IntPtr)data, (MonoMac.OpenGL.BufferUsageHint)usage);
        }


        /// <summary>[requires: v1.5]
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        public static
        void BufferData<T2>(MonoMac.OpenGL.BufferTarget target, IntPtr size, [InAttribute, OutAttribute] T2[] data, MonoMac.OpenGL.BufferUsageHint usage)
            where T2 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.BufferData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (MonoMac.OpenGL.BufferUsageHint)usage);
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.5]
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        public static
        void BufferData<T2>(MonoMac.OpenGL.BufferTarget target, IntPtr size, [InAttribute, OutAttribute] T2[,] data, MonoMac.OpenGL.BufferUsageHint usage)
            where T2 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.BufferData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (MonoMac.OpenGL.BufferUsageHint)usage);
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.5]
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        public static
        void BufferData<T2>(MonoMac.OpenGL.BufferTarget target, IntPtr size, [InAttribute, OutAttribute] T2[, ,] data, MonoMac.OpenGL.BufferUsageHint usage)
            where T2 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.BufferData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (MonoMac.OpenGL.BufferUsageHint)usage);
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.5]
        /// Creates and initializes a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the buffer object's new data store.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to data that will be copied into the data store for initialization, or NULL if no data is to be copied.
        /// </para>
        /// </param>
        /// <param name="usage">
        /// <para>
        /// Specifies the expected usage pattern of the data store. The symbolic constant must be GL_STREAM_DRAW, GL_STREAM_READ, GL_STREAM_COPY, GL_STATIC_DRAW, GL_STATIC_READ, GL_STATIC_COPY, GL_DYNAMIC_DRAW, GL_DYNAMIC_READ, or GL_DYNAMIC_COPY.
        /// </para>
        /// </param>
        public static
        void BufferData<T2>(MonoMac.OpenGL.BufferTarget target, IntPtr size, [InAttribute, OutAttribute] ref T2 data, MonoMac.OpenGL.BufferUsageHint usage)
            where T2 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.BufferData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject(), (MonoMac.OpenGL.BufferUsageHint)usage);
                data = (T2)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.5]
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        public static
        void BufferSubData(MonoMac.OpenGL.BufferTarget target, IntPtr offset, IntPtr size, IntPtr data)
        {
            Core.BufferSubData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data);
        }


        /// <summary>[requires: v1.5]
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        public static
        void BufferSubData<T3>(MonoMac.OpenGL.BufferTarget target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[] data)
            where T3 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.BufferSubData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.5]
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        public static
        void BufferSubData<T3>(MonoMac.OpenGL.BufferTarget target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[,] data)
            where T3 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.BufferSubData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.5]
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        public static
        void BufferSubData<T3>(MonoMac.OpenGL.BufferTarget target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[, ,] data)
            where T3 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.BufferSubData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.5]
        /// Updates a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store where data replacement will begin, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being replaced.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the new data that will be copied into the data store.
        /// </para>
        /// </param>
        public static
        void BufferSubData<T3>(MonoMac.OpenGL.BufferTarget target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] ref T3 data)
            where T3 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.BufferSubData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T3)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Execute a display list
        /// </summary>
        /// <param name="list">
        /// <para>
        /// Specifies the integer name of the display list to be executed.
        /// </para>
        /// </param>
        public static
        void CallList(Int32 list)
        {
                Core.CallList((UInt32)list);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Execute a display list
        /// </summary>
        /// <param name="list">
        /// <para>
        /// Specifies the integer name of the display list to be executed.
        /// </para>
        /// </param>
        public static
        void CallList(UInt32 list)
        {
                Core.CallList((UInt32)list);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Execute a list of display lists
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of display lists to be executed.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of values in lists. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, GL_2_BYTES, GL_3_BYTES, and GL_4_BYTES are accepted.
        /// </para>
        /// </param>
        /// <param name="lists">
        /// <para>
        /// Specifies the address of an array of name offsets in the display list. The pointer type is void because the offsets can be bytes, shorts, ints, or floats, depending on the value of type.
        /// </para>
        /// </param>
        public static
        void CallLists(Int32 n, MonoMac.OpenGL.ListNameType type, IntPtr lists)
        {
                Core.CallLists((Int32)n, (MonoMac.OpenGL.ListNameType)type, (IntPtr)lists);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Execute a list of display lists
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of display lists to be executed.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of values in lists. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, GL_2_BYTES, GL_3_BYTES, and GL_4_BYTES are accepted.
        /// </para>
        /// </param>
        /// <param name="lists">
        /// <para>
        /// Specifies the address of an array of name offsets in the display list. The pointer type is void because the offsets can be bytes, shorts, ints, or floats, depending on the value of type.
        /// </para>
        /// </param>
        public static
        void CallLists<T2>(Int32 n, MonoMac.OpenGL.ListNameType type, [InAttribute, OutAttribute] T2[] lists)
            where T2 : struct
        {
                GCHandle lists_ptr = GCHandle.Alloc(lists, GCHandleType.Pinned);
                try
                {
                    Core.CallLists((Int32)n, (MonoMac.OpenGL.ListNameType)type, (IntPtr)lists_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    lists_ptr.Free();
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Execute a list of display lists
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of display lists to be executed.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of values in lists. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, GL_2_BYTES, GL_3_BYTES, and GL_4_BYTES are accepted.
        /// </para>
        /// </param>
        /// <param name="lists">
        /// <para>
        /// Specifies the address of an array of name offsets in the display list. The pointer type is void because the offsets can be bytes, shorts, ints, or floats, depending on the value of type.
        /// </para>
        /// </param>
        public static
        void CallLists<T2>(Int32 n, MonoMac.OpenGL.ListNameType type, [InAttribute, OutAttribute] T2[,] lists)
            where T2 : struct
        {
                GCHandle lists_ptr = GCHandle.Alloc(lists, GCHandleType.Pinned);
                try
                {
                    Core.CallLists((Int32)n, (MonoMac.OpenGL.ListNameType)type, (IntPtr)lists_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    lists_ptr.Free();
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Execute a list of display lists
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of display lists to be executed.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of values in lists. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, GL_2_BYTES, GL_3_BYTES, and GL_4_BYTES are accepted.
        /// </para>
        /// </param>
        /// <param name="lists">
        /// <para>
        /// Specifies the address of an array of name offsets in the display list. The pointer type is void because the offsets can be bytes, shorts, ints, or floats, depending on the value of type.
        /// </para>
        /// </param>
        public static
        void CallLists<T2>(Int32 n, MonoMac.OpenGL.ListNameType type, [InAttribute, OutAttribute] T2[, ,] lists)
            where T2 : struct
        {
                GCHandle lists_ptr = GCHandle.Alloc(lists, GCHandleType.Pinned);
                try
                {
                    Core.CallLists((Int32)n, (MonoMac.OpenGL.ListNameType)type, (IntPtr)lists_ptr.AddrOfPinnedObject());
                }
                finally
                {
                    lists_ptr.Free();
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Execute a list of display lists
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of display lists to be executed.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of values in lists. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, GL_2_BYTES, GL_3_BYTES, and GL_4_BYTES are accepted.
        /// </para>
        /// </param>
        /// <param name="lists">
        /// <para>
        /// Specifies the address of an array of name offsets in the display list. The pointer type is void because the offsets can be bytes, shorts, ints, or floats, depending on the value of type.
        /// </para>
        /// </param>
        public static
        void CallLists<T2>(Int32 n, MonoMac.OpenGL.ListNameType type, [InAttribute, OutAttribute] ref T2 lists)
            where T2 : struct
        {
                GCHandle lists_ptr = GCHandle.Alloc(lists, GCHandleType.Pinned);
                try
                {
                    Core.CallLists((Int32)n, (MonoMac.OpenGL.ListNameType)type, (IntPtr)lists_ptr.AddrOfPinnedObject());
                    lists = (T2)lists_ptr.Target;
                }
                finally
                {
                    lists_ptr.Free();
                }
        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Check the completeness status of a framebuffer
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specify the target of the framebuffer completeness check.
//        /// </para>
//        /// </param>
//        public static
//        MonoMac.OpenGL.FramebufferErrorCode CheckFramebufferStatus(MonoMac.OpenGL.FramebufferTarget target)
//        {
//                return Core.CheckFramebufferStatus((MonoMac.OpenGL.FramebufferTarget)target);
//        }


//        /// <summary>[requires: v3.0]
//        /// Specify whether data read via glReadPixels should be clamped
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Target for color clamping. target must be GL_CLAMP_READ_COLOR.
//        /// </para>
//        /// </param>
//        /// <param name="clamp">
//        /// <para>
//        /// Specifies whether to apply color clamping. clamp must be GL_TRUE or GL_FALSE.
//        /// </para>
//        /// </param>
//        public static
//        void ClampColor(MonoMac.OpenGL.ClampColorTarget target, MonoMac.OpenGL.ClampColorMode clamp)
//        {
//                Core.ClampColor((MonoMac.OpenGL.ClampColorTarget)target, (MonoMac.OpenGL.ClampColorMode)clamp);
//        }


        /// <summary>[requires: v1.0]
        /// Clear buffers to preset values
        /// </summary>
        /// <param name="mask">
        /// <para>
        /// Bitwise OR of masks that indicate the buffers to be cleared. The three masks are GL_COLOR_BUFFER_BIT, GL_DEPTH_BUFFER_BIT, and GL_STENCIL_BUFFER_BIT.
        /// </para>
        /// </param>
        public static
        void Clear(MonoMac.OpenGL.ClearBufferMask mask)
        {
                Core.Clear((MonoMac.OpenGL.ClearBufferMask)mask);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Specify clear values for the accumulation buffer
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify the red, green, blue, and alpha values used when the accumulation buffer is cleared. The initial values are all 0.
        /// </para>
        /// </param>
        public static
        void ClearAccum(Single red, Single green, Single blue, Single alpha)
        {
                Core.ClearAccum((Single)red, (Single)green, (Single)blue, (Single)alpha);
        }


//        /// <summary>[requires: v3.0]
//        /// Clear individual buffers of the currently bound draw framebuffer
//        /// </summary>
//        /// <param name="buffer">
//        /// <para>
//        /// Specify the buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="drawBuffer">
//        /// <para>
//        /// Specify a particular draw buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="value">
//        /// <para>
//        /// For color buffers, a pointer to a four-element vector specifying R, G, B and A values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="depth">
//        /// <para>
//        /// The value to clear a depth render buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="stencil">
//        /// <para>
//        /// The value to clear a stencil render buffer to.
//        /// </para>
//        /// </param>
//        public static
//        void ClearBuffer(MonoMac.OpenGL.ClearBuffer buffer, Int32 drawbuffer, Single depth, Int32 stencil)
//        {
//                Core.ClearBufferfi((MonoMac.OpenGL.ClearBuffer)buffer, (Int32)drawbuffer, (Single)depth, (Int32)stencil);
//        }


//        /// <summary>[requires: v3.0]
//        /// Clear individual buffers of the currently bound draw framebuffer
//        /// </summary>
//        /// <param name="buffer">
//        /// <para>
//        /// Specify the buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="drawBuffer">
//        /// <para>
//        /// Specify a particular draw buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="value">
//        /// <para>
//        /// For color buffers, a pointer to a four-element vector specifying R, G, B and A values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="depth">
//        /// <para>
//        /// The value to clear a depth render buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="stencil">
//        /// <para>
//        /// The value to clear a stencil render buffer to.
//        /// </para>
//        /// </param>
//        public static
//        void ClearBuffer(MonoMac.OpenGL.ClearBuffer buffer, Int32 drawbuffer, Single[] value)
//        {
//                unsafe
//                {
//                    fixed (Single* value_ptr = value)
//                    {
//                        Core.ClearBufferfv((MonoMac.OpenGL.ClearBuffer)buffer, (Int32)drawbuffer, (Single*)value_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0]
//        /// Clear individual buffers of the currently bound draw framebuffer
//        /// </summary>
//        /// <param name="buffer">
//        /// <para>
//        /// Specify the buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="drawBuffer">
//        /// <para>
//        /// Specify a particular draw buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="value">
//        /// <para>
//        /// For color buffers, a pointer to a four-element vector specifying R, G, B and A values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="depth">
//        /// <para>
//        /// The value to clear a depth render buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="stencil">
//        /// <para>
//        /// The value to clear a stencil render buffer to.
//        /// </para>
//        /// </param>
//        public static
//        void ClearBuffer(MonoMac.OpenGL.ClearBuffer buffer, Int32 drawbuffer, ref Single value)
//        {
//                unsafe
//                {
//                    fixed (Single* value_ptr = &value)
//                    {
//                        Core.ClearBufferfv((MonoMac.OpenGL.ClearBuffer)buffer, (Int32)drawbuffer, (Single*)value_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0]
//        /// Clear individual buffers of the currently bound draw framebuffer
//        /// </summary>
//        /// <param name="buffer">
//        /// <para>
//        /// Specify the buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="drawBuffer">
//        /// <para>
//        /// Specify a particular draw buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="value">
//        /// <para>
//        /// For color buffers, a pointer to a four-element vector specifying R, G, B and A values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="depth">
//        /// <para>
//        /// The value to clear a depth render buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="stencil">
//        /// <para>
//        /// The value to clear a stencil render buffer to.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void ClearBuffer(MonoMac.OpenGL.ClearBuffer buffer, Int32 drawbuffer, Single* value)
//        {
//                Core.ClearBufferfv((MonoMac.OpenGL.ClearBuffer)buffer, (Int32)drawbuffer, (Single*)value);
//        }


//        /// <summary>[requires: v3.0]
//        /// Clear individual buffers of the currently bound draw framebuffer
//        /// </summary>
//        /// <param name="buffer">
//        /// <para>
//        /// Specify the buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="drawBuffer">
//        /// <para>
//        /// Specify a particular draw buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="value">
//        /// <para>
//        /// For color buffers, a pointer to a four-element vector specifying R, G, B and A values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="depth">
//        /// <para>
//        /// The value to clear a depth render buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="stencil">
//        /// <para>
//        /// The value to clear a stencil render buffer to.
//        /// </para>
//        /// </param>
//        public static
//        void ClearBuffer(MonoMac.OpenGL.ClearBuffer buffer, Int32 drawbuffer, Int32[] value)
//        {
//                unsafe
//                {
//                    fixed (Int32* value_ptr = value)
//                    {
//                        Core.ClearBufferiv((MonoMac.OpenGL.ClearBuffer)buffer, (Int32)drawbuffer, (Int32*)value_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0]
//        /// Clear individual buffers of the currently bound draw framebuffer
//        /// </summary>
//        /// <param name="buffer">
//        /// <para>
//        /// Specify the buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="drawBuffer">
//        /// <para>
//        /// Specify a particular draw buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="value">
//        /// <para>
//        /// For color buffers, a pointer to a four-element vector specifying R, G, B and A values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="depth">
//        /// <para>
//        /// The value to clear a depth render buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="stencil">
//        /// <para>
//        /// The value to clear a stencil render buffer to.
//        /// </para>
//        /// </param>
//        public static
//        void ClearBuffer(MonoMac.OpenGL.ClearBuffer buffer, Int32 drawbuffer, ref Int32 value)
//        {
//                unsafe
//                {
//                    fixed (Int32* value_ptr = &value)
//                    {
//                        Core.ClearBufferiv((MonoMac.OpenGL.ClearBuffer)buffer, (Int32)drawbuffer, (Int32*)value_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0]
//        /// Clear individual buffers of the currently bound draw framebuffer
//        /// </summary>
//        /// <param name="buffer">
//        /// <para>
//        /// Specify the buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="drawBuffer">
//        /// <para>
//        /// Specify a particular draw buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="value">
//        /// <para>
//        /// For color buffers, a pointer to a four-element vector specifying R, G, B and A values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="depth">
//        /// <para>
//        /// The value to clear a depth render buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="stencil">
//        /// <para>
//        /// The value to clear a stencil render buffer to.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void ClearBuffer(MonoMac.OpenGL.ClearBuffer buffer, Int32 drawbuffer, Int32* value)
//        {
//                Core.ClearBufferiv((MonoMac.OpenGL.ClearBuffer)buffer, (Int32)drawbuffer, (Int32*)value);
//        }


//        /// <summary>[requires: v3.0]
//        /// Clear individual buffers of the currently bound draw framebuffer
//        /// </summary>
//        /// <param name="buffer">
//        /// <para>
//        /// Specify the buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="drawBuffer">
//        /// <para>
//        /// Specify a particular draw buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="value">
//        /// <para>
//        /// For color buffers, a pointer to a four-element vector specifying R, G, B and A values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="depth">
//        /// <para>
//        /// The value to clear a depth render buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="stencil">
//        /// <para>
//        /// The value to clear a stencil render buffer to.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void ClearBuffer(MonoMac.OpenGL.ClearBuffer buffer, Int32 drawbuffer, UInt32[] value)
//        {
//                unsafe
//                {
//                    fixed (UInt32* value_ptr = value)
//                    {
//                        Core.ClearBufferuiv((MonoMac.OpenGL.ClearBuffer)buffer, (Int32)drawbuffer, (UInt32*)value_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0]
//        /// Clear individual buffers of the currently bound draw framebuffer
//        /// </summary>
//        /// <param name="buffer">
//        /// <para>
//        /// Specify the buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="drawBuffer">
//        /// <para>
//        /// Specify a particular draw buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="value">
//        /// <para>
//        /// For color buffers, a pointer to a four-element vector specifying R, G, B and A values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="depth">
//        /// <para>
//        /// The value to clear a depth render buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="stencil">
//        /// <para>
//        /// The value to clear a stencil render buffer to.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void ClearBuffer(MonoMac.OpenGL.ClearBuffer buffer, Int32 drawbuffer, ref UInt32 value)
//        {
//                unsafe
//                {
//                    fixed (UInt32* value_ptr = &value)
//                    {
//                        Core.ClearBufferuiv((MonoMac.OpenGL.ClearBuffer)buffer, (Int32)drawbuffer, (UInt32*)value_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0]
//        /// Clear individual buffers of the currently bound draw framebuffer
//        /// </summary>
//        /// <param name="buffer">
//        /// <para>
//        /// Specify the buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="drawBuffer">
//        /// <para>
//        /// Specify a particular draw buffer to clear.
//        /// </para>
//        /// </param>
//        /// <param name="value">
//        /// <para>
//        /// For color buffers, a pointer to a four-element vector specifying R, G, B and A values to clear the buffer to. For depth buffers, a pointer to a single depth value to clear the buffer to. For stencil buffers, a pointer to a single stencil value to clear the buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="depth">
//        /// <para>
//        /// The value to clear a depth render buffer to.
//        /// </para>
//        /// </param>
//        /// <param name="stencil">
//        /// <para>
//        /// The value to clear a stencil render buffer to.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void ClearBuffer(MonoMac.OpenGL.ClearBuffer buffer, Int32 drawbuffer, UInt32* value)
//        {
//                Core.ClearBufferuiv((MonoMac.OpenGL.ClearBuffer)buffer, (Int32)drawbuffer, (UInt32*)value);
//        }


        /// <summary>[requires: v1.0]
        /// Specify clear values for the color buffers
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify the red, green, blue, and alpha values used when the color buffers are cleared. The initial values are all 0.
        /// </para>
        /// </param>
        public static
        void ClearColor(Single red, Single green, Single blue, Single alpha)
        {
                Core.ClearColor((Single)red, (Single)green, (Single)blue, (Single)alpha);

        }


        /// <summary>[requires: v1.0]
        /// Specify the clear value for the depth buffer
        /// </summary>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth value used when the depth buffer is cleared. The initial value is 1.
        /// </para>
        /// </param>
        public static
        void ClearDepth(Double depth)
        {
                Core.ClearDepth((Double)depth);
        }


//        /// <summary>[requires: v4.1 and ARB_ES2_compatibility]
//        /// Specify the clear value for the depth buffer
//        /// </summary>
//        /// <param name="depth">
//        /// <para>
//        /// Specifies the depth value used when the depth buffer is cleared. The initial value is 1.
//        /// </para>
//        /// </param>
//        public static
//        void ClearDepth(Single d)
//        {
//                Core.ClearDepthf((Single)d);
//        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Specify the clear value for the color index buffers
        /// </summary>
        /// <param name="c">
        /// <para>
        /// Specifies the index used when the color index buffers are cleared. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void ClearIndex(Single c)
        {
                Core.ClearIndex((Single)c);
        }


        /// <summary>[requires: v1.0]
        /// Specify the clear value for the stencil buffer
        /// </summary>
        /// <param name="s">
        /// <para>
        /// Specifies the index used when the stencil buffer is cleared. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void ClearStencil(Int32 s)
        {
                Core.ClearStencil((Int32)s);
        }


        /// <summary>[requires: v1.3][deprecated: v3.1]
        /// Select active texture unit
        /// </summary>
        /// <param name="texture">
        /// <para>
        /// Specifies which texture unit to make active. The number of texture units is implementation dependent, but must be at least two. texture must be one of GL_TEXTURE, where i ranges from 0 to the value of GL_MAX_TEXTURE_COORDS - 1, which is an implementation-dependent value. The initial value is GL_TEXTURE0.
        /// </para>
        /// </param>
        public static
        void ClientActiveTexture(MonoMac.OpenGL.TextureUnit texture)
        {
            Core.ClientActiveTexture((MonoMac.OpenGL.TextureUnit)texture);
        }


//        /// <summary>[requires: v1.2 and ARB_sync]
//        /// Block and wait for a sync object to become signaled
//        /// </summary>
//        /// <param name="sync">
//        /// <para>
//        /// The sync object whose status to wait on.
//        /// </para>
//        /// </param>
//        /// <param name="flags">
//        /// <para>
//        /// A bitfield controlling the command flushing behavior. flags may be GL_SYNC_FLUSH_COMMANDS_BIT.
//        /// </para>
//        /// </param>
//        public static
//        MonoMac.OpenGL.ArbSync ClientWaitSync(IntPtr sync, Int32 flags, Int64 timeout)
//        {
//                return Core.ClientWaitSync((IntPtr)sync, (UInt32)flags, (UInt64)timeout);
//        }


//        /// <summary>[requires: v1.2 and ARB_sync]
//        /// Block and wait for a sync object to become signaled
//        /// </summary>
//        /// <param name="sync">
//        /// <para>
//        /// The sync object whose status to wait on.
//        /// </para>
//        /// </param>
//        /// <param name="flags">
//        /// <para>
//        /// A bitfield controlling the command flushing behavior. flags may be GL_SYNC_FLUSH_COMMANDS_BIT.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        MonoMac.OpenGL.ArbSync ClientWaitSync(IntPtr sync, UInt32 flags, UInt64 timeout)
//        {
//                return Core.ClientWaitSync((IntPtr)sync, (UInt32)flags, (UInt64)timeout);
//        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Specify a plane against which all geometry is clipped
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies which clipping plane is being positioned. Symbolic names of the form GL_CLIP_PLANEi, where i is an integer between 0 and GL_MAX_CLIP_PLANES - 1, are accepted.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Specifies the address of an array of four double-precision floating-point values. These values are interpreted as a plane equation.
        /// </para>
        /// </param>
        public static
        void ClipPlane(MonoMac.OpenGL.ClipPlaneName plane, Double[] equation)
        {
                unsafe
                {
                    fixed (Double* equation_ptr = equation)
                    {
                        Core.ClipPlane((MonoMac.OpenGL.ClipPlaneName)plane, (Double*)equation_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Specify a plane against which all geometry is clipped
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies which clipping plane is being positioned. Symbolic names of the form GL_CLIP_PLANEi, where i is an integer between 0 and GL_MAX_CLIP_PLANES - 1, are accepted.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Specifies the address of an array of four double-precision floating-point values. These values are interpreted as a plane equation.
        /// </para>
        /// </param>
        public static
        void ClipPlane(MonoMac.OpenGL.ClipPlaneName plane, ref Double equation)
        {
                unsafe
                {
                    fixed (Double* equation_ptr = &equation)
                    {
                        Core.ClipPlane((MonoMac.OpenGL.ClipPlaneName)plane, (Double*)equation_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Specify a plane against which all geometry is clipped
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies which clipping plane is being positioned. Symbolic names of the form GL_CLIP_PLANEi, where i is an integer between 0 and GL_MAX_CLIP_PLANES - 1, are accepted.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Specifies the address of an array of four double-precision floating-point values. These values are interpreted as a plane equation.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void ClipPlane(MonoMac.OpenGL.ClipPlaneName plane, Double* equation)
        {
                Core.ClipPlane((MonoMac.OpenGL.ClipPlaneName)plane, (Double*)equation);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Color3(SByte red, SByte green, SByte blue)
        {
                Core.Color3b((SByte)red, (SByte)green, (SByte)blue);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Color3(SByte[] v)
        {
                unsafe
                {
                    fixed (SByte* v_ptr = v)
                    {
                        Core.Color3bv((SByte*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Color3(ref SByte v)
        {
                unsafe
                {
                    fixed (SByte* v_ptr = &v)
                    {
                        Core.Color3bv((SByte*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Color3(SByte* v)
        {
                Core.Color3bv((SByte*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(Double red, Double green, Double blue)
        {
                Core.Color3d((Double)red, (Double)green, (Double)blue);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(Double[] v)
        {
                unsafe
                {
                    fixed (Double* v_ptr = v)
                    {
                        Core.Color3dv((Double*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(ref Double v)
        {
                unsafe
                {
                    fixed (Double* v_ptr = &v)
                    {
                        Core.Color3dv((Double*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Color3(Double* v)
        {
                Core.Color3dv((Double*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(Single red, Single green, Single blue)
        {
                Core.Color3f((Single)red, (Single)green, (Single)blue);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(Single[] v)
        {
                unsafe
                {
                    fixed (Single* v_ptr = v)
                    {
                        Core.Color3fv((Single*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(ref Single v)
        {
                unsafe
                {
                    fixed (Single* v_ptr = &v)
                    {
                        Core.Color3fv((Single*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Color3(Single* v)
        {
                Core.Color3fv((Single*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(Int32 red, Int32 green, Int32 blue)
        {
                Core.Color3i((Int32)red, (Int32)green, (Int32)blue);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(Int32[] v)
        {
                unsafe
                {
                    fixed (Int32* v_ptr = v)
                    {
                        Core.Color3iv((Int32*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(ref Int32 v)
        {
                unsafe
                {
                    fixed (Int32* v_ptr = &v)
                    {
                        Core.Color3iv((Int32*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Color3(Int32* v)
        {
                Core.Color3iv((Int32*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(Int16 red, Int16 green, Int16 blue)
        {
                Core.Color3s((Int16)red, (Int16)green, (Int16)blue);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(Int16[] v)
        {
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Core.Color3sv((Int16*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(ref Int16 v)
        {
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Core.Color3sv((Int16*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Color3(Int16* v)
        {
                Core.Color3sv((Int16*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(Byte red, Byte green, Byte blue)
        {
                Core.Color3ub((Byte)red, (Byte)green, (Byte)blue);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(Byte[] v)
        {
                unsafe
                {
                    fixed (Byte* v_ptr = v)
                    {
                        Core.Color3ubv((Byte*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color3(ref Byte v)
        {
                unsafe
                {
                    fixed (Byte* v_ptr = &v)
                    {
                        Core.Color3ubv((Byte*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Color3(Byte* v)
        {
                Core.Color3ubv((Byte*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Color3(UInt32 red, UInt32 green, UInt32 blue)
        {
                Core.Color3ui((UInt32)red, (UInt32)green, (UInt32)blue);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Color3(UInt32[] v)
        {
                unsafe
                {
                    fixed (UInt32* v_ptr = v)
                    {
                        Core.Color3uiv((UInt32*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Color3(ref UInt32 v)
        {
                unsafe
                {
                    fixed (UInt32* v_ptr = &v)
                    {
                        Core.Color3uiv((UInt32*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Color3(UInt32* v)
        {
                Core.Color3uiv((UInt32*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Color3(UInt16 red, UInt16 green, UInt16 blue)
        {
                Core.Color3us((UInt16)red, (UInt16)green, (UInt16)blue);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Color3(UInt16[] v)
        {
                unsafe
                {
                    fixed (UInt16* v_ptr = v)
                    {
                        Core.Color3usv((UInt16*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Color3(ref UInt16 v)
        {
                unsafe
                {
                    fixed (UInt16* v_ptr = &v)
                    {
                        Core.Color3usv((UInt16*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Color3(UInt16* v)
        {
                Core.Color3usv((UInt16*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Color4(SByte red, SByte green, SByte blue, SByte alpha)
        {
                Core.Color4b((SByte)red, (SByte)green, (SByte)blue, (SByte)alpha);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Color4(SByte[] v)
        {
                unsafe
                {
                    fixed (SByte* v_ptr = v)
                    {
                        Core.Color4bv((SByte*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Color4(ref SByte v)
        {
                unsafe
                {
                    fixed (SByte* v_ptr = &v)
                    {
                        Core.Color4bv((SByte*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Color4(SByte* v)
        {
                Core.Color4bv((SByte*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color4(Double red, Double green, Double blue, Double alpha)
        {
                Core.Color4d((Double)red, (Double)green, (Double)blue, (Double)alpha);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color4(Double[] v)
        {
                unsafe
                {
                    fixed (Double* v_ptr = v)
                    {
                        Core.Color4dv((Double*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color4(ref Double v)
        {
                unsafe
                {
                    fixed (Double* v_ptr = &v)
                    {
                        Core.Color4dv((Double*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Color4(Double* v)
        {
                Core.Color4dv((Double*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color4(Single red, Single green, Single blue, Single alpha)
        {
                Core.Color4f((Single)red, (Single)green, (Single)blue, (Single)alpha);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color4(Single[] v)
        {
                unsafe
                {
                    fixed (Single* v_ptr = v)
                    {
                        Core.Color4fv((Single*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color4(ref Single v)
        {
                unsafe
                {
                    fixed (Single* v_ptr = &v)
                    {
                        Core.Color4fv((Single*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Color4(Single* v)
        {
                Core.Color4fv((Single*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color4(Int32 red, Int32 green, Int32 blue, Int32 alpha)
        {
                Core.Color4i((Int32)red, (Int32)green, (Int32)blue, (Int32)alpha);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color4(Int32[] v)
        {
                unsafe
                {
                    fixed (Int32* v_ptr = v)
                    {
                        Core.Color4iv((Int32*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color4(ref Int32 v)
        {
                unsafe
                {
                    fixed (Int32* v_ptr = &v)
                    {
                        Core.Color4iv((Int32*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Color4(Int32* v)
        {
                Core.Color4iv((Int32*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color4(Int16 red, Int16 green, Int16 blue, Int16 alpha)
        {
                Core.Color4s((Int16)red, (Int16)green, (Int16)blue, (Int16)alpha);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color4(Int16[] v)
        {
                unsafe
                {
                    fixed (Int16* v_ptr = v)
                    {
                        Core.Color4sv((Int16*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color4(ref Int16 v)
        {
                unsafe
                {
                    fixed (Int16* v_ptr = &v)
                    {
                        Core.Color4sv((Int16*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Color4(Int16* v)
        {
                Core.Color4sv((Int16*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
//      [AutoGenerated(Category = "VERSION_1_0_DEPRECATED", Version = "1.0", EntryPoint = "glColor4ub")]
        public static
        void Color4(Byte red, Byte green, Byte blue, Byte alpha)
        {
                Core.Color4ub((Byte)red, (Byte)green, (Byte)blue, (Byte)alpha);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color4(Byte[] v)
        {
                unsafe
                {
                    fixed (Byte* v_ptr = v)
                    {
                        Core.Color4ubv((Byte*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        public static
        void Color4(ref Byte v)
        {
                unsafe
                {
                    fixed (Byte* v_ptr = &v)
                    {
                        Core.Color4ubv((Byte*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Color4(Byte* v)
        {
                Core.Color4ubv((Byte*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
//      [AutoGenerated(Category = "VERSION_1_0_DEPRECATED", Version = "1.0", EntryPoint = "glColor4ui")]
        public static
        void Color4(UInt32 red, UInt32 green, UInt32 blue, UInt32 alpha)
        {
                Core.Color4ui((UInt32)red, (UInt32)green, (UInt32)blue, (UInt32)alpha);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Color4(UInt32[] v)
        {
                unsafe
                {
                    fixed (UInt32* v_ptr = v)
                    {
                        Core.Color4uiv((UInt32*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Color4(ref UInt32 v)
        {
                unsafe
                {
                    fixed (UInt32* v_ptr = &v)
                    {
                        Core.Color4uiv((UInt32*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
//      [AutoGenerated(Category = "VERSION_1_0_DEPRECATED", Version = "1.0", EntryPoint = "glColor4uiv")]
        public static
        unsafe void Color4(UInt32* v)
        {
                Core.Color4uiv((UInt32*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
//      [AutoGenerated(Category = "VERSION_1_0_DEPRECATED", Version = "1.0", EntryPoint = "glColor4us")]
        public static
        void Color4(UInt16 red, UInt16 green, UInt16 blue, UInt16 alpha)
        {
                Core.Color4us((UInt16)red, (UInt16)green, (UInt16)blue, (UInt16)alpha);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
//      [AutoGenerated(Category = "VERSION_1_0_DEPRECATED", Version = "1.0", EntryPoint = "glColor4usv")]
        public static
        void Color4(UInt16[] v)
        {
                unsafe
                {
                    fixed (UInt16* v_ptr = v)
                    {
                        Core.Color4usv((UInt16*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
//      [AutoGenerated(Category = "VERSION_1_0_DEPRECATED", Version = "1.0", EntryPoint = "glColor4usv")]
        public static
        void Color4(ref UInt16 v)
        {
                unsafe
                {
                    fixed (UInt16* v_ptr = &v)
                    {
                        Core.Color4usv((UInt16*)v_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Set the current color
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify new red, green, and blue values for the current color.
        /// </para>
        /// </param>
        /// <param name="alpha">
        /// <para>
        /// Specifies a new alpha value for the current color. Included only in the four-argument glColor4 commands.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
//      [AutoGenerated(Category = "VERSION_1_0_DEPRECATED", Version = "1.0", EntryPoint = "glColor4usv")]
        public static
        unsafe void Color4(UInt16* v)
        {
                Core.Color4usv((UInt16*)v);
        }


        /// <summary>[requires: v1.0]
        /// Enable and disable writing of frame buffer color components
        /// </summary>
        /// <param name="red">
        /// <para>
        /// Specify whether red, green, blue, and alpha can or cannot be written into the frame buffer. The initial values are all GL_TRUE, indicating that the color components can be written.
        /// </para>
        /// </param>
        //      [AutoGenerated(Category = "VERSION_1_0", Version = "1.0", EntryPoint = "glColorMask")]
        public static
        void ColorMask(bool red, bool green, bool blue, bool alpha)
        {
                Core.ColorMask((bool)red, (bool)green, (bool)blue, (bool)alpha);
        }


//        /// <summary>[requires: v3.0]
//        /// Enable and disable writing of frame buffer color components
//        /// </summary>
//        /// <param name="red">
//        /// <para>
//        /// Specify whether red, green, blue, and alpha can or cannot be written into the frame buffer. The initial values are all GL_TRUE, indicating that the color components can be written.
//        /// </para>
//        /// </param>
//        public static
//        void ColorMask(Int32 index, bool r, bool g, bool b, bool a)
//        {
//                Core.ColorMaski((UInt32)index, (bool)r, (bool)g, (bool)b, (bool)a);
//        }


//        /// <summary>[requires: v3.0]
//        /// Enable and disable writing of frame buffer color components
//        /// </summary>
//        /// <param name="red">
//        /// <para>
//        /// Specify whether red, green, blue, and alpha can or cannot be written into the frame buffer. The initial values are all GL_TRUE, indicating that the color components can be written.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void ColorMask(UInt32 index, bool r, bool g, bool b, bool a)
//        {
//                Core.ColorMaski((UInt32)index, (bool)r, (bool)g, (bool)b, (bool)a);
//        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Cause a material color to track the current color
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies whether front, back, or both front and back material parameters should track the current color. Accepted values are GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK. The initial value is GL_FRONT_AND_BACK.
        /// </para>
        /// </param>
        /// <param name="mode">
        /// <para>
        /// Specifies which of several material parameters track the current color. Accepted values are GL_EMISSION, GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, and GL_AMBIENT_AND_DIFFUSE. The initial value is GL_AMBIENT_AND_DIFFUSE.
        /// </para>
        /// </param>
        public static
        void ColorMaterial(MonoMac.OpenGL.MaterialFace face, MonoMac.OpenGL.ColorMaterialParameter mode)
        {
            Core.ColorMaterial((MonoMac.OpenGL.MaterialFace)face, (MonoMac.OpenGL.ColorMaterialParameter)mode);
        }

//        /// <summary>[requires: v1.2 and ARB_vertex_type_2_10_10_10_rev]</summary>
//        public static
//        void ColorP3(MonoMac.OpenGL.PackedPointerType type, Int32 color)
//        {
//                Core.ColorP3ui((MonoMac.OpenGL.PackedPointerType)type, (UInt32)color);
//        }

//        /// <summary>[requires: v1.2 and ARB_vertex_type_2_10_10_10_rev]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void ColorP3(MonoMac.OpenGL.PackedPointerType type, UInt32 color)
//        {
//                Core.ColorP3ui((MonoMac.OpenGL.PackedPointerType)type, (UInt32)color);
//        }

//        /// <summary>[requires: v1.2 and ARB_vertex_type_2_10_10_10_rev]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void ColorP3(MonoMac.OpenGL.PackedPointerType type, Int32* color)
//        {
//                Core.ColorP3uiv((MonoMac.OpenGL.PackedPointerType)type, (UInt32*)color);
//        }

//        /// <summary>[requires: v1.2 and ARB_vertex_type_2_10_10_10_rev]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void ColorP3(MonoMac.OpenGL.PackedPointerType type, UInt32* color)
//        {
//                Core.ColorP3uiv((MonoMac.OpenGL.PackedPointerType)type, (UInt32*)color);
//        }

//        /// <summary>[requires: v1.2 and ARB_vertex_type_2_10_10_10_rev]</summary>
//        public static
//        void ColorP4(MonoMac.OpenGL.PackedPointerType type, Int32 color)
//        {
//                Core.ColorP4ui((MonoMac.OpenGL.PackedPointerType)type, (UInt32)color);
//        }

//        /// <summary>[requires: v1.2 and ARB_vertex_type_2_10_10_10_rev]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void ColorP4(MonoMac.OpenGL.PackedPointerType type, UInt32 color)
//        {
//                Core.ColorP4ui((MonoMac.OpenGL.PackedPointerType)type, (UInt32)color);
//        }

//        /// <summary>[requires: v1.2 and ARB_vertex_type_2_10_10_10_rev]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void ColorP4(MonoMac.OpenGL.PackedPointerType type, Int32* color)
//        {
//                Core.ColorP4uiv((MonoMac.OpenGL.PackedPointerType)type, (UInt32*)color);
//        }

//        /// <summary>[requires: v1.2 and ARB_vertex_type_2_10_10_10_rev]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void ColorP4(MonoMac.OpenGL.PackedPointerType type, UInt32* color)
//        {
//                Core.ColorP4uiv((MonoMac.OpenGL.PackedPointerType)type, (UInt32*)color);
//        }


        /// <summary>[requires: v1.1][deprecated: v3.1]
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void ColorPointer(Int32 size, MonoMac.OpenGL.ColorPointerType type, Int32 stride, IntPtr pointer)
        {
            Core.ColorPointer((Int32)size, (MonoMac.OpenGL.ColorPointerType)type, (Int32)stride, (IntPtr)pointer);
        }


        /// <summary>[requires: v1.1][deprecated: v3.1]
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void ColorPointer<T3>(Int32 size, MonoMac.OpenGL.ColorPointerType type, Int32 stride, [InAttribute, OutAttribute] T3[] pointer)
            where T3 : struct
        {
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Core.ColorPointer((Int32)size, (MonoMac.OpenGL.ColorPointerType)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
        }


        /// <summary>[requires: v1.1][deprecated: v3.1]
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void ColorPointer<T3>(Int32 size, MonoMac.OpenGL.ColorPointerType type, Int32 stride, [InAttribute, OutAttribute] T3[,] pointer)
            where T3 : struct
        {
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Core.ColorPointer((Int32)size, (MonoMac.OpenGL.ColorPointerType)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
        }


        /// <summary>[requires: v1.1][deprecated: v3.1]
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void ColorPointer<T3>(Int32 size, MonoMac.OpenGL.ColorPointerType type, Int32 stride, [InAttribute, OutAttribute] T3[, ,] pointer)
            where T3 : struct
        {
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Core.ColorPointer((Int32)size, (MonoMac.OpenGL.ColorPointerType)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
        }


        /// <summary>[requires: v1.1][deprecated: v3.1]
        /// Define an array of colors
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the number of components per color. Must be 3 or 4. The initial value is 4.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each color component in the array. Symbolic constants GL_BYTE, GL_UNSIGNED_BYTE, GL_SHORT, GL_UNSIGNED_SHORT, GL_INT, GL_UNSIGNED_INT, GL_FLOAT, and GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive colors. If stride is 0, the colors are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first component of the first color element in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void ColorPointer<T3>(Int32 size, MonoMac.OpenGL.ColorPointerType type, Int32 stride, [InAttribute, OutAttribute] ref T3 pointer)
            where T3 : struct
        {
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Core.ColorPointer((Int32)size, (MonoMac.OpenGL.ColorPointerType)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                pointer = (T3)pointer_ptr.Target;
            }
            finally
            {
                pointer_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Respecify a portion of a color table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// The starting index of the portion of the color table to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// The number of table entries to replace.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. The allowable values are GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to replace the specified region of the color table.
        /// </para>
        /// </param>
        public static
        void ColorSubTable(MonoMac.OpenGL.ColorTableTarget target, Int32 start, Int32 count, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, IntPtr data)
        {
            Core.ColorSubTable((MonoMac.OpenGL.ColorTableTarget)target, (Int32)start, (Int32)count, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)data);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Respecify a portion of a color table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// The starting index of the portion of the color table to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// The number of table entries to replace.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. The allowable values are GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to replace the specified region of the color table.
        /// </para>
        /// </param>
        public static
        void ColorSubTable<T5>(MonoMac.OpenGL.ColorTableTarget target, Int32 start, Int32 count, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T5[] data)
            where T5 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.ColorSubTable((MonoMac.OpenGL.ColorTableTarget)target, (Int32)start, (Int32)count, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Respecify a portion of a color table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// The starting index of the portion of the color table to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// The number of table entries to replace.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. The allowable values are GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to replace the specified region of the color table.
        /// </para>
        /// </param>
        public static
        void ColorSubTable<T5>(MonoMac.OpenGL.ColorTableTarget target, Int32 start, Int32 count, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T5[,] data)
            where T5 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.ColorSubTable((MonoMac.OpenGL.ColorTableTarget)target, (Int32)start, (Int32)count, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Respecify a portion of a color table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// The starting index of the portion of the color table to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// The number of table entries to replace.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. The allowable values are GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to replace the specified region of the color table.
        /// </para>
        /// </param>
        public static
        void ColorSubTable<T5>(MonoMac.OpenGL.ColorTableTarget target, Int32 start, Int32 count, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T5[, ,] data)
            where T5 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.ColorSubTable((MonoMac.OpenGL.ColorTableTarget)target, (Int32)start, (Int32)count, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Respecify a portion of a color table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// The starting index of the portion of the color table to be replaced.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// The number of table entries to replace.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. The allowable values are GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to replace the specified region of the color table.
        /// </para>
        /// </param>
        public static
        void ColorSubTable<T5>(MonoMac.OpenGL.ColorTableTarget target, Int32 start, Int32 count, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] ref T5 data)
            where T5 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.ColorSubTable((MonoMac.OpenGL.ColorTableTarget)target, (Int32)start, (Int32)count, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T5)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a color lookup table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, GL_POST_COLOR_MATRIX_COLOR_TABLE, GL_PROXY_COLOR_TABLE, GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, or GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the color table. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, and GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The number of entries in the color lookup table specified by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. The allowable values are GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the color table.
        /// </para>
        /// </param>
        public static
        void ColorTable(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, IntPtr table)
        {
            Core.ColorTable((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)table);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a color lookup table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, GL_POST_COLOR_MATRIX_COLOR_TABLE, GL_PROXY_COLOR_TABLE, GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, or GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the color table. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, and GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The number of entries in the color lookup table specified by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. The allowable values are GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the color table.
        /// </para>
        /// </param>
        public static
        void ColorTable<T5>(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T5[] table)
            where T5 : struct
        {
            GCHandle table_ptr = GCHandle.Alloc(table, GCHandleType.Pinned);
            try
            {
                Core.ColorTable((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)table_ptr.AddrOfPinnedObject());
            }
            finally
            {
                table_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a color lookup table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, GL_POST_COLOR_MATRIX_COLOR_TABLE, GL_PROXY_COLOR_TABLE, GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, or GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the color table. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, and GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The number of entries in the color lookup table specified by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. The allowable values are GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the color table.
        /// </para>
        /// </param>
        public static
        void ColorTable<T5>(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T5[,] table)
            where T5 : struct
        {
            GCHandle table_ptr = GCHandle.Alloc(table, GCHandleType.Pinned);
            try
            {
                Core.ColorTable((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)table_ptr.AddrOfPinnedObject());
            }
            finally
            {
                table_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a color lookup table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, GL_POST_COLOR_MATRIX_COLOR_TABLE, GL_PROXY_COLOR_TABLE, GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, or GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the color table. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, and GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The number of entries in the color lookup table specified by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. The allowable values are GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the color table.
        /// </para>
        /// </param>
        public static
        void ColorTable<T5>(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T5[, ,] table)
            where T5 : struct
        {
            GCHandle table_ptr = GCHandle.Alloc(table, GCHandleType.Pinned);
            try
            {
                Core.ColorTable((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)table_ptr.AddrOfPinnedObject());
            }
            finally
            {
                table_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a color lookup table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, GL_POST_COLOR_MATRIX_COLOR_TABLE, GL_PROXY_COLOR_TABLE, GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, or GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the color table. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, and GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The number of entries in the color lookup table specified by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. The allowable values are GL_UNSIGNED_BYTE, GL_BYTE, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the color table.
        /// </para>
        /// </param>
        public static
        void ColorTable<T5>(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] ref T5 table)
            where T5 : struct
        {
            GCHandle table_ptr = GCHandle.Alloc(table, GCHandleType.Pinned);
            try
            {
                Core.ColorTable((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)table_ptr.AddrOfPinnedObject());
                table = (T5)table_ptr.Target;
            }
            finally
            {
                table_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Set color lookup table parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target color table. Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The symbolic name of a texture color lookup table parameter. Must be one of GL_COLOR_TABLE_SCALE or GL_COLOR_TABLE_BIAS.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to an array where the values of the parameters are stored.
        /// </para>
        /// </param>
        public static
        void ColorTableParameter(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.ColorTableParameterPName pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Core.ColorTableParameterfv((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.ColorTableParameterPName)pname, (Single*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Set color lookup table parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target color table. Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The symbolic name of a texture color lookup table parameter. Must be one of GL_COLOR_TABLE_SCALE or GL_COLOR_TABLE_BIAS.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to an array where the values of the parameters are stored.
        /// </para>
        /// </param>
        public static
        void ColorTableParameter(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.ColorTableParameterPName pname, ref Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Core.ColorTableParameterfv((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.ColorTableParameterPName)pname, (Single*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Set color lookup table parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target color table. Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The symbolic name of a texture color lookup table parameter. Must be one of GL_COLOR_TABLE_SCALE or GL_COLOR_TABLE_BIAS.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to an array where the values of the parameters are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void ColorTableParameter(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.ColorTableParameterPName pname, Single* @params)
        {
            Core.ColorTableParameterfv((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.ColorTableParameterPName)pname, (Single*)@params);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Set color lookup table parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target color table. Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The symbolic name of a texture color lookup table parameter. Must be one of GL_COLOR_TABLE_SCALE or GL_COLOR_TABLE_BIAS.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to an array where the values of the parameters are stored.
        /// </para>
        /// </param>
        public static
        void ColorTableParameter(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.ColorTableParameterPName pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Core.ColorTableParameteriv((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.ColorTableParameterPName)pname, (Int32*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Set color lookup table parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target color table. Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The symbolic name of a texture color lookup table parameter. Must be one of GL_COLOR_TABLE_SCALE or GL_COLOR_TABLE_BIAS.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to an array where the values of the parameters are stored.
        /// </para>
        /// </param>
        public static
        void ColorTableParameter(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.ColorTableParameterPName pname, ref Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Core.ColorTableParameteriv((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.ColorTableParameterPName)pname, (Int32*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Set color lookup table parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target color table. Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The symbolic name of a texture color lookup table parameter. Must be one of GL_COLOR_TABLE_SCALE or GL_COLOR_TABLE_BIAS.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to an array where the values of the parameters are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void ColorTableParameter(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.ColorTableParameterPName pname, Int32* @params)
        {
            Core.ColorTableParameteriv((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.ColorTableParameterPName)pname, (Int32*)@params);
        }


        /// <summary>[requires: v2.0]
        /// Compiles a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be compiled.
        /// </para>
        /// </param>
        public static
        void CompileShader(Int32 shader)
        {
            Core.CompileShader((UInt32)shader);
        }


        /// <summary>[requires: v2.0]
        /// Compiles a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be compiled.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void CompileShader(UInt32 shader)
        {
            Core.CompileShader((UInt32)shader);
        }


        /// <summary>[requires: v1.3]
        /// Specify a one-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support texture images that are at least 64 texels wide. The height of the 1D texture image is 1.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage1D(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 border, Int32 imageSize, IntPtr data)
        {
            Core.CompressedTexImage1D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)border, (Int32)imageSize, (IntPtr)data);
        }


        /// <summary>[requires: v1.3]
        /// Specify a one-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support texture images that are at least 64 texels wide. The height of the 1D texture image is 1.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage1D<T6>(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T6[] data)
            where T6 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexImage1D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a one-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support texture images that are at least 64 texels wide. The height of the 1D texture image is 1.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage1D<T6>(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T6[,] data)
            where T6 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexImage1D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a one-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support texture images that are at least 64 texels wide. The height of the 1D texture image is 1.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage1D<T6>(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T6[, ,] data)
            where T6 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexImage1D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a one-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D or GL_PROXY_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support texture images that are at least 64 texels wide. The height of the 1D texture image is 1.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage1D<T6>(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] ref T6 data)
            where T6 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexImage1D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T6)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_PROXY_TEXTURE_1D_ARRAY, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image. All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage2D(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, IntPtr data)
        {
            Core.CompressedTexImage2D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data);
        }


        /// <summary>[requires: v1.3]
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_PROXY_TEXTURE_1D_ARRAY, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image. All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage2D<T7>(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[] data)
            where T7 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexImage2D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_PROXY_TEXTURE_1D_ARRAY, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image. All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage2D<T7>(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[,] data)
            where T7 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexImage2D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_PROXY_TEXTURE_1D_ARRAY, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image. All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage2D<T7>(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T7[, ,] data)
            where T7 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexImage2D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a two-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_PROXY_TEXTURE_2D, GL_TEXTURE_1D_ARRAY, GL_PROXY_TEXTURE_1D_ARRAY, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, or GL_PROXY_TEXTURE_CUBE_MAP.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support 2D texture images that are at least 64 texels wide and cube-mapped texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image. All implementations support 2D texture images that are at least 64 texels high and cube-mapped texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage2D<T7>(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] ref T7 data)
            where T7 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexImage2D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T7)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D, GL_PROXY_TEXTURE_3D, GL_TEXTURE_2D_ARRAY or GL_PROXY_TEXTURE_2D_ARRAY.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image. All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image. All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage3D(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, IntPtr data)
        {
            Core.CompressedTexImage3D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data);
        }


        /// <summary>[requires: v1.3]
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D, GL_PROXY_TEXTURE_3D, GL_TEXTURE_2D_ARRAY or GL_PROXY_TEXTURE_2D_ARRAY.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image. All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image. All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage3D<T8>(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T8[] data)
            where T8 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexImage3D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D, GL_PROXY_TEXTURE_3D, GL_TEXTURE_2D_ARRAY or GL_PROXY_TEXTURE_2D_ARRAY.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image. All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image. All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage3D<T8>(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T8[,] data)
            where T8 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexImage3D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D, GL_PROXY_TEXTURE_3D, GL_TEXTURE_2D_ARRAY or GL_PROXY_TEXTURE_2D_ARRAY.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image. All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image. All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage3D<T8>(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] T8[, ,] data)
            where T8 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexImage3D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a three-dimensional texture image in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D, GL_PROXY_TEXTURE_3D, GL_TEXTURE_2D_ARRAY or GL_PROXY_TEXTURE_2D_ARRAY.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. All implementations support 3D texture images that are at least 16 texels wide.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image. All implementations support 3D texture images that are at least 16 texels high.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture image. All implementations support 3D texture images that are at least 16 texels deep.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// This value must be 0.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexImage3D<T8>(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, Int32 depth, Int32 border, Int32 imageSize, [InAttribute, OutAttribute] ref T8 data)
            where T8 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexImage3D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (Int32)depth, (Int32)border, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T8)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a one-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage1D(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 width, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, IntPtr data)
        {
            Core.CompressedTexSubImage1D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data);
        }


        /// <summary>[requires: v1.3]
        /// Specify a one-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage1D<T6>(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 width, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T6[] data)
            where T6 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexSubImage1D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a one-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage1D<T6>(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 width, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T6[,] data)
            where T6 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexSubImage1D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a one-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage1D<T6>(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 width, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T6[, ,] data)
            where T6 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexSubImage1D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a one-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage1D<T6>(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 width, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] ref T6 data)
            where T6 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexSubImage1D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T6)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage2D(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, IntPtr data)
        {
            Core.CompressedTexSubImage2D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data);
        }


        /// <summary>[requires: v1.3]
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage2D<T8>(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T8[] data)
            where T8 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexSubImage2D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage2D<T8>(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T8[,] data)
            where T8 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexSubImage2D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage2D<T8>(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T8[, ,] data)
            where T8 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexSubImage2D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a two-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage2D<T8>(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] ref T8 data)
            where T8 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexSubImage2D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T8)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage3D(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, IntPtr data)
        {
            Core.CompressedTexSubImage3D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data);
        }


        /// <summary>[requires: v1.3]
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage3D<T10>(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T10[] data)
            where T10 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexSubImage3D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage3D<T10>(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T10[,] data)
            where T10 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexSubImage3D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage3D<T10>(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] T10[, ,] data)
            where T10 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexSubImage3D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.3]
        /// Specify a three-dimensional texture subimage in a compressed format
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="depth">
        /// <para>
        /// Specifies the depth of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the compressed image data stored at address data.
        /// </para>
        /// </param>
        /// <param name="imageSize">
        /// <para>
        /// Specifies the number of unsigned bytes of image data starting at the address specified by data.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the compressed image data in memory.
        /// </para>
        /// </param>
        public static
        void CompressedTexSubImage3D<T10>(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 width, Int32 height, Int32 depth, MonoMac.OpenGL.PixelFormat format, Int32 imageSize, [InAttribute, OutAttribute] ref T10 data)
            where T10 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.CompressedTexSubImage3D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)width, (Int32)height, (Int32)depth, (MonoMac.OpenGL.PixelFormat)format, (Int32)imageSize, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T10)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a one-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_CONVOLUTION_1D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The width of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_INTENSITY, GL_RGB, and GL_RGBA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the convolution filter kernel.
        /// </para>
        /// </param>
        public static
        void ConvolutionFilter1D(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, IntPtr image)
        {
            Core.ConvolutionFilter1D((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a one-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_CONVOLUTION_1D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The width of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_INTENSITY, GL_RGB, and GL_RGBA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the convolution filter kernel.
        /// </para>
        /// </param>
        public static
        void ConvolutionFilter1D<T5>(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T5[] image)
            where T5 : struct
        {
            GCHandle image_ptr = GCHandle.Alloc(image, GCHandleType.Pinned);
            try
            {
                Core.ConvolutionFilter1D((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image_ptr.AddrOfPinnedObject());
            }
            finally
            {
                image_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a one-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_CONVOLUTION_1D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The width of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_INTENSITY, GL_RGB, and GL_RGBA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the convolution filter kernel.
        /// </para>
        /// </param>
        public static
        void ConvolutionFilter1D<T5>(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T5[,] image)
            where T5 : struct
        {
            GCHandle image_ptr = GCHandle.Alloc(image, GCHandleType.Pinned);
            try
            {
                Core.ConvolutionFilter1D((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image_ptr.AddrOfPinnedObject());
            }
            finally
            {
                image_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a one-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_CONVOLUTION_1D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The width of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_INTENSITY, GL_RGB, and GL_RGBA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the convolution filter kernel.
        /// </para>
        /// </param>
        public static
        void ConvolutionFilter1D<T5>(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T5[, ,] image)
            where T5 : struct
        {
            GCHandle image_ptr = GCHandle.Alloc(image, GCHandleType.Pinned);
            try
            {
                Core.ConvolutionFilter1D((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image_ptr.AddrOfPinnedObject());
            }
            finally
            {
                image_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a one-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_CONVOLUTION_1D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The width of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_INTENSITY, GL_RGB, and GL_RGBA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data that is processed to build the convolution filter kernel.
        /// </para>
        /// </param>
        public static
        void ConvolutionFilter1D<T5>(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] ref T5 image)
            where T5 : struct
        {
            GCHandle image_ptr = GCHandle.Alloc(image, GCHandleType.Pinned);
            try
            {
                Core.ConvolutionFilter1D((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image_ptr.AddrOfPinnedObject());
                image = (T5)image_ptr.Target;
            }
            finally
            {
                image_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a two-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_CONVOLUTION_2D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The width of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// The height of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a two-dimensional array of pixel data that is processed to build the convolution filter kernel.
        /// </para>
        /// </param>
        public static
        void ConvolutionFilter2D(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, IntPtr image)
        {
            Core.ConvolutionFilter2D((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a two-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_CONVOLUTION_2D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The width of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// The height of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a two-dimensional array of pixel data that is processed to build the convolution filter kernel.
        /// </para>
        /// </param>
        public static
        void ConvolutionFilter2D<T6>(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T6[] image)
            where T6 : struct
        {
            GCHandle image_ptr = GCHandle.Alloc(image, GCHandleType.Pinned);
            try
            {
                Core.ConvolutionFilter2D((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image_ptr.AddrOfPinnedObject());
            }
            finally
            {
                image_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a two-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_CONVOLUTION_2D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The width of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// The height of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a two-dimensional array of pixel data that is processed to build the convolution filter kernel.
        /// </para>
        /// </param>
        public static
        void ConvolutionFilter2D<T6>(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T6[,] image)
            where T6 : struct
        {
            GCHandle image_ptr = GCHandle.Alloc(image, GCHandleType.Pinned);
            try
            {
                Core.ConvolutionFilter2D((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image_ptr.AddrOfPinnedObject());
            }
            finally
            {
                image_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a two-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_CONVOLUTION_2D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The width of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// The height of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a two-dimensional array of pixel data that is processed to build the convolution filter kernel.
        /// </para>
        /// </param>
        public static
        void ConvolutionFilter2D<T6>(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T6[, ,] image)
            where T6 : struct
        {
            GCHandle image_ptr = GCHandle.Alloc(image, GCHandleType.Pinned);
            try
            {
                Core.ConvolutionFilter2D((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image_ptr.AddrOfPinnedObject());
            }
            finally
            {
                image_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Define a two-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_CONVOLUTION_2D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The width of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// The height of the pixel array referenced by data.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in data. The allowable values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Pointer to a two-dimensional array of pixel data that is processed to build the convolution filter kernel.
        /// </para>
        /// </param>
        public static
        void ConvolutionFilter2D<T6>(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] ref T6 image)
            where T6 : struct
        {
            GCHandle image_ptr = GCHandle.Alloc(image, GCHandleType.Pinned);
            try
            {
                Core.ConvolutionFilter2D((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image_ptr.AddrOfPinnedObject());
                image = (T6)image_ptr.Target;
            }
            finally
            {
                image_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Set convolution parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target for the convolution parameter. Must be one of GL_CONVOLUTION_1D, GL_CONVOLUTION_2D, or GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be set. Must be GL_CONVOLUTION_BORDER_MODE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// The parameter value. Must be one of GL_REDUCE, GL_CONSTANT_BORDER, GL_REPLICATE_BORDER.
        /// </para>
        /// <para>
        ///
        /// </para>
        /// </param>
        public static
        void ConvolutionParameter(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.ConvolutionParameter pname, Single @params)
        {
            Core.ConvolutionParameterf((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.ConvolutionParameter)pname, (Single)@params);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Set convolution parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target for the convolution parameter. Must be one of GL_CONVOLUTION_1D, GL_CONVOLUTION_2D, or GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be set. Must be GL_CONVOLUTION_BORDER_MODE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// The parameter value. Must be one of GL_REDUCE, GL_CONSTANT_BORDER, GL_REPLICATE_BORDER.
        /// </para>
        /// <para>
        ///
        /// </para>
        /// </param>
        public static
        void ConvolutionParameter(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.ConvolutionParameter pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Core.ConvolutionParameterfv((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.ConvolutionParameter)pname, (Single*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Set convolution parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target for the convolution parameter. Must be one of GL_CONVOLUTION_1D, GL_CONVOLUTION_2D, or GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be set. Must be GL_CONVOLUTION_BORDER_MODE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// The parameter value. Must be one of GL_REDUCE, GL_CONSTANT_BORDER, GL_REPLICATE_BORDER.
        /// </para>
        /// <para>
        ///
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void ConvolutionParameter(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.ConvolutionParameter pname, Single* @params)
        {
            Core.ConvolutionParameterfv((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.ConvolutionParameter)pname, (Single*)@params);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Set convolution parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target for the convolution parameter. Must be one of GL_CONVOLUTION_1D, GL_CONVOLUTION_2D, or GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be set. Must be GL_CONVOLUTION_BORDER_MODE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// The parameter value. Must be one of GL_REDUCE, GL_CONSTANT_BORDER, GL_REPLICATE_BORDER.
        /// </para>
        /// <para>
        ///
        /// </para>
        /// </param>
        public static
        void ConvolutionParameter(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.ConvolutionParameter pname, Int32 @params)
        {
            Core.ConvolutionParameteri((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.ConvolutionParameter)pname, (Int32)@params);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Set convolution parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target for the convolution parameter. Must be one of GL_CONVOLUTION_1D, GL_CONVOLUTION_2D, or GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be set. Must be GL_CONVOLUTION_BORDER_MODE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// The parameter value. Must be one of GL_REDUCE, GL_CONSTANT_BORDER, GL_REPLICATE_BORDER.
        /// </para>
        /// <para>
        ///
        /// </para>
        /// </param>
        public static
        void ConvolutionParameter(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.ConvolutionParameter pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Core.ConvolutionParameteriv((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.ConvolutionParameter)pname, (Int32*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Set convolution parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target for the convolution parameter. Must be one of GL_CONVOLUTION_1D, GL_CONVOLUTION_2D, or GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be set. Must be GL_CONVOLUTION_BORDER_MODE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// The parameter value. Must be one of GL_REDUCE, GL_CONSTANT_BORDER, GL_REPLICATE_BORDER.
        /// </para>
        /// <para>
        ///
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void ConvolutionParameter(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.ConvolutionParameter pname, Int32* @params)
        {
            Core.ConvolutionParameteriv((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.ConvolutionParameter)pname, (Int32*)@params);
        }


        /// <summary>[requires: v3.0 and ARB_copy_buffer]
        /// Copy part of the data store of a buffer object to the data store of another buffer object
        /// </summary>
        /// <param name="readtarget">
        /// <para>
        /// Specifies the target from whose data store data should be read.
        /// </para>
        /// </param>
        /// <param name="writetarget">
        /// <para>
        /// Specifies the target to whose data store data should be written.
        /// </para>
        /// </param>
        /// <param name="readoffset">
        /// <para>
        /// Specifies the offset, in basic machine units, within the data store of readtarget from which data should be read.
        /// </para>
        /// </param>
        /// <param name="writeoffset">
        /// <para>
        /// Specifies the offset, in basic machine units, within the data store of writetarget to which data should be written.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size, in basic machine units, of the data to be copied from readtarget to writetarget.
        /// </para>
        /// </param>
        public static
        void CopyBufferSubData(MonoMac.OpenGL.BufferTarget readTarget, MonoMac.OpenGL.BufferTarget writeTarget, IntPtr readOffset, IntPtr writeOffset, IntPtr size)
        {
            Core.CopyBufferSubData((MonoMac.OpenGL.BufferTarget)readTarget, (MonoMac.OpenGL.BufferTarget)writeTarget, (IntPtr)readOffset, (IntPtr)writeOffset, (IntPtr)size);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Respecify a portion of a color table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// The starting index of the portion of the color table to be replaced.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// The window coordinates of the left corner of the row of pixels to be copied.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The number of table entries to replace.
        /// </para>
        /// </param>
        public static
        void CopyColorSubTable(MonoMac.OpenGL.ColorTableTarget target, Int32 start, Int32 x, Int32 y, Int32 width)
        {
            Core.CopyColorSubTable((MonoMac.OpenGL.ColorTableTarget)target, (Int32)start, (Int32)x, (Int32)y, (Int32)width);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Copy pixels into a color table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The color table target. Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal storage format of the texture image. Must be one of the following symbolic constants: GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// The x coordinate of the lower-left corner of the pixel rectangle to be transferred to the color table.
        /// </para>
        /// </param>
        /// <param name="y">
        /// <para>
        /// The y coordinate of the lower-left corner of the pixel rectangle to be transferred to the color table.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The width of the pixel rectangle.
        /// </para>
        /// </param>
        public static
        void CopyColorTable(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 x, Int32 y, Int32 width)
        {
            Core.CopyColorTable((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)x, (Int32)y, (Int32)width);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Copy pixels into a one-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_CONVOLUTION_1D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// The window space coordinates of the lower-left coordinate of the pixel array to copy.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The width of the pixel array to copy.
        /// </para>
        /// </param>
        public static
        void CopyConvolutionFilter1D(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 x, Int32 y, Int32 width)
        {
            Core.CopyConvolutionFilter1D((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)x, (Int32)y, (Int32)width);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Copy pixels into a two-dimensional convolution filter
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_CONVOLUTION_2D.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// The internal format of the convolution filter kernel. The allowable values are GL_ALPHA, GL_ALPHA4, GL_ALPHA8, GL_ALPHA12, GL_ALPHA16, GL_LUMINANCE, GL_LUMINANCE4, GL_LUMINANCE8, GL_LUMINANCE12, GL_LUMINANCE16, GL_LUMINANCE_ALPHA, GL_LUMINANCE4_ALPHA4, GL_LUMINANCE6_ALPHA2, GL_LUMINANCE8_ALPHA8, GL_LUMINANCE12_ALPHA4, GL_LUMINANCE12_ALPHA12, GL_LUMINANCE16_ALPHA16, GL_INTENSITY, GL_INTENSITY4, GL_INTENSITY8, GL_INTENSITY12, GL_INTENSITY16, GL_R3_G3_B2, GL_RGB, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, or GL_RGBA16.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// The window space coordinates of the lower-left coordinate of the pixel array to copy.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// The width of the pixel array to copy.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// The height of the pixel array to copy.
        /// </para>
        /// </param>
        public static
        void CopyConvolutionFilter2D(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 x, Int32 y, Int32 width, Int32 height)
        {
            Core.CopyConvolutionFilter2D((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)x, (Int32)y, (Int32)width, (Int32)height);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Copy pixels in the frame buffer
        /// </summary>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the lower left corner of the rectangular region of pixels to be copied.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the rectangular region of pixels to be copied. Both must be nonnegative.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies whether color values, depth values, or stencil values are to be copied. Symbolic constants GL_COLOR, GL_DEPTH, and GL_STENCIL are accepted.
        /// </para>
        /// </param>
        public static
        void CopyPixels(Int32 x, Int32 y, Int32 width, Int32 height, MonoMac.OpenGL.PixelCopyType type)
        {
            Core.CopyPixels((Int32)x, (Int32)y, (Int32)width, (Int32)height, (MonoMac.OpenGL.PixelCopyType)type);
        }


        /// <summary>[requires: v1.1]
        /// Copy pixels into a 1D texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the internal format of the texture. Must be one of the following symbolic constants: GL_COMPRESSED_RED, GL_COMPRESSED_RG, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA. GL_COMPRESSED_SRGB, GL_COMPRESSED_SRGB_ALPHA. GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_RED, GL_RG, GL_RGB, GL_R3_G3_B2, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the left corner of the row of pixels to be copied.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. Must be 0 or 2 sup n + 2 ( border ) for some integer . The height of the texture image is 1.
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        public static
        void CopyTexImage1D(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 x, Int32 y, Int32 width, Int32 border)
        {
            Core.CopyTexImage1D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)x, (Int32)y, (Int32)width, (Int32)border);
        }


        /// <summary>[requires: v1.1]
        /// Copy pixels into a 2D texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="internalformat">
        /// <para>
        /// Specifies the internal format of the texture. Must be one of the following symbolic constants: GL_COMPRESSED_RED, GL_COMPRESSED_RG, GL_COMPRESSED_RGB, GL_COMPRESSED_RGBA. GL_COMPRESSED_SRGB, GL_COMPRESSED_SRGB_ALPHA. GL_DEPTH_COMPONENT, GL_DEPTH_COMPONENT16, GL_DEPTH_COMPONENT24, GL_DEPTH_COMPONENT32, GL_RED, GL_RG, GL_RGB, GL_R3_G3_B2, GL_RGB4, GL_RGB5, GL_RGB8, GL_RGB10, GL_RGB12, GL_RGB16, GL_RGBA, GL_RGBA2, GL_RGBA4, GL_RGB5_A1, GL_RGBA8, GL_RGB10_A2, GL_RGBA12, GL_RGBA16, GL_SRGB, GL_SRGB8, GL_SRGB_ALPHA, or GL_SRGB8_ALPHA8.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the lower left corner of the rectangular region of pixels to be copied.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture image. Must be 0 or 2 sup n + 2 ( border ) for some integer .
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture image. Must be 0 or 2 sup m + 2 ( border ) for some integer .
        /// </para>
        /// </param>
        /// <param name="border">
        /// <para>
        /// Specifies the width of the border. Must be either 0 or 1.
        /// </para>
        /// </param>
        public static
        void CopyTexImage2D(MonoMac.OpenGL.TextureTarget target, Int32 level, MonoMac.OpenGL.PixelInternalFormat internalformat, Int32 x, Int32 y, Int32 width, Int32 height, Int32 border)
        {
            Core.CopyTexImage2D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (MonoMac.OpenGL.PixelInternalFormat)internalformat, (Int32)x, (Int32)y, (Int32)width, (Int32)height, (Int32)border);
        }


        /// <summary>[requires: v1.1]
        /// Copy a one-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_1D.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies the texel offset within the texture array.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the left corner of the row of pixels to be copied.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        public static
        void CopyTexSubImage1D(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 x, Int32 y, Int32 width)
        {
            Core.CopyTexSubImage1D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)x, (Int32)y, (Int32)width);
        }


        /// <summary>[requires: v1.1]
        /// Copy a two-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, or GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the lower left corner of the rectangular region of pixels to be copied.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        public static
        void CopyTexSubImage2D(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 x, Int32 y, Int32 width, Int32 height)
        {
            Core.CopyTexSubImage2D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)x, (Int32)y, (Int32)width, (Int32)height);
        }


        /// <summary>[requires: v1.2]
        /// Copy a three-dimensional texture subimage
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target texture. Must be GL_TEXTURE_3D
        /// </para>
        /// </param>
        /// <param name="level">
        /// <para>
        /// Specifies the level-of-detail number. Level 0 is the base image level. Level n is the nth mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="xoffset">
        /// <para>
        /// Specifies a texel offset in the x direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="yoffset">
        /// <para>
        /// Specifies a texel offset in the y direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="zoffset">
        /// <para>
        /// Specifies a texel offset in the z direction within the texture array.
        /// </para>
        /// </param>
        /// <param name="x">
        /// <para>
        /// Specify the window coordinates of the lower left corner of the rectangular region of pixels to be copied.
        /// </para>
        /// </param>
        /// <param name="width">
        /// <para>
        /// Specifies the width of the texture subimage.
        /// </para>
        /// </param>
        /// <param name="height">
        /// <para>
        /// Specifies the height of the texture subimage.
        /// </para>
        /// </param>
        public static
        void CopyTexSubImage3D(MonoMac.OpenGL.TextureTarget target, Int32 level, Int32 xoffset, Int32 yoffset, Int32 zoffset, Int32 x, Int32 y, Int32 width, Int32 height)
        {
            Core.CopyTexSubImage3D((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (Int32)xoffset, (Int32)yoffset, (Int32)zoffset, (Int32)x, (Int32)y, (Int32)width, (Int32)height);
        }


        /// <summary>[requires: v2.0]
        /// Creates a program object
        /// </summary>
        public static
        Int32 CreateProgram()
        {
            return Core.CreateProgram();
        }


        /// <summary>[requires: v2.0]
        /// Creates a shader object
        /// </summary>
        /// <param name="shaderType">
        /// <para>
        /// Specifies the type of shader to be created. Must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER, or GL_FRAGMENT_SHADER.
        /// </para>
        /// </param>
        public static
        Int32 CreateShader(MonoMac.OpenGL.ShaderType type)
        {
            return Core.CreateShader((MonoMac.OpenGL.ShaderType)type);
        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Create a stand-alone program from an array of null-terminated source code strings
//        /// </summary>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of shader to create.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of source code strings in the array strings.
//        /// </para>
//        /// </param>
//        /// <param name="strings">
//        /// <para>
//        /// Specifies the address of an array of pointers to source code strings from which to create the program object.
//        /// </para>
//        /// </param>
//        public static
//        Int32 CreateShaderProgram(MonoMac.OpenGL.ShaderType type, Int32 count, String[] strings)
//        {
//                return Core.CreateShaderProgramv((MonoMac.OpenGL.ShaderType)type, (Int32)count, (String[])strings);
//        }


        /// <summary>[requires: v1.0]
        /// Specify whether front- or back-facing facets can be culled
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies whether front- or back-facing facets are candidates for culling. Symbolic constants GL_FRONT, GL_BACK, and GL_FRONT_AND_BACK are accepted. The initial value is GL_BACK.
        /// </para>
        /// </param>
        public static
        void CullFace(MonoMac.OpenGL.CullFaceMode mode)
        {
            Core.CullFace((MonoMac.OpenGL.CullFaceMode)mode);
        }


        /// <summary>[requires: v1.5]
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        public static
        void DeleteBuffers(Int32 n, Int32[] buffers)
        {
            unsafe
            {
                fixed (Int32* buffers_ptr = buffers)
                {
                    Core.DeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        public static
        void DeleteBuffers(Int32 n, ref Int32 buffers)
        {
            unsafe
            {
                fixed (Int32* buffers_ptr = &buffers)
                {
                    Core.DeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void DeleteBuffers(Int32 n, Int32* buffers)
        {
            Core.DeleteBuffers((Int32)n, (UInt32*)buffers);
        }


        /// <summary>[requires: v1.5]
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void DeleteBuffers(Int32 n, UInt32[] buffers)
        {
            unsafe
            {
                fixed (UInt32* buffers_ptr = buffers)
                {
                    Core.DeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void DeleteBuffers(Int32 n, ref UInt32 buffers)
        {
            unsafe
            {
                fixed (UInt32* buffers_ptr = &buffers)
                {
                    Core.DeleteBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Delete named buffer objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array of buffer objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void DeleteBuffers(Int32 n, UInt32* buffers)
        {
            Core.DeleteBuffers((Int32)n, (UInt32*)buffers);
        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Delete framebuffer objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of framebuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="framebuffers">
//        /// <para>
//        /// A pointer to an array containing n framebuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        public static
//        void DeleteFramebuffers(Int32 n, Int32[] framebuffers)
//        {
//                unsafe
//                {
//                    fixed (Int32* framebuffers_ptr = framebuffers)
//                    {
//                        Core.DeleteFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Delete framebuffer objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of framebuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="framebuffers">
//        /// <para>
//        /// A pointer to an array containing n framebuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        public static
//        void DeleteFramebuffers(Int32 n, ref Int32 framebuffers)
//        {
//                unsafe
//                {
//                    fixed (Int32* framebuffers_ptr = &framebuffers)
//                    {
//                        Core.DeleteFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Delete framebuffer objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of framebuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="framebuffers">
//        /// <para>
//        /// A pointer to an array containing n framebuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void DeleteFramebuffers(Int32 n, Int32* framebuffers)
//        {
//                Core.DeleteFramebuffers((Int32)n, (UInt32*)framebuffers);
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Delete framebuffer objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of framebuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="framebuffers">
//        /// <para>
//        /// A pointer to an array containing n framebuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DeleteFramebuffers(Int32 n, UInt32[] framebuffers)
//        {
//                unsafe
//                {
//                    fixed (UInt32* framebuffers_ptr = framebuffers)
//                    {
//                        Core.DeleteFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Delete framebuffer objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of framebuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="framebuffers">
//        /// <para>
//        /// A pointer to an array containing n framebuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DeleteFramebuffers(Int32 n, ref UInt32 framebuffers)
//        {
//                unsafe
//                {
//                    fixed (UInt32* framebuffers_ptr = &framebuffers)
//                    {
//                        Core.DeleteFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Delete framebuffer objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of framebuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="framebuffers">
//        /// <para>
//        /// A pointer to an array containing n framebuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void DeleteFramebuffers(Int32 n, UInt32* framebuffers)
//        {
//                Core.DeleteFramebuffers((Int32)n, (UInt32*)framebuffers);
//        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Delete a contiguous group of display lists
        /// </summary>
        /// <param name="list">
        /// <para>
        /// Specifies the integer name of the first display list to delete.
        /// </para>
        /// </param>
        /// <param name="range">
        /// <para>
        /// Specifies the number of display lists to delete.
        /// </para>
        /// </param>
        public static
        void DeleteLists(Int32 list, Int32 range)
        {
            Core.DeleteLists((UInt32)list, (Int32)range);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Delete a contiguous group of display lists
        /// </summary>
        /// <param name="list">
        /// <para>
        /// Specifies the integer name of the first display list to delete.
        /// </para>
        /// </param>
        /// <param name="range">
        /// <para>
        /// Specifies the number of display lists to delete.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void DeleteLists(UInt32 list, Int32 range)
        {
            Core.DeleteLists((UInt32)list, (Int32)range);
        }


//        /// <summary>[requires: v2.0]
//        /// Deletes a program object
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the program object to be deleted.
//        /// </para>
//        /// </param>
//        public static
//        void DeleteProgram(Int32 program)
//        {
//                Core.DeleteProgram((UInt32)program);
//        }


//        /// <summary>[requires: v2.0]
//        /// Deletes a program object
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the program object to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DeleteProgram(UInt32 program)
//        {
//                Core.DeleteProgram((UInt32)program);
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Delete program pipeline objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of program pipeline objects to delete.
//        /// </para>
//        /// </param>
//        /// <param name="pipelines">
//        /// <para>
//        /// Specifies an array of names of program pipeline objects to delete.
//        /// </para>
//        /// </param>
//        public static
//        void DeleteProgramPipelines(Int32 n, Int32[] pipelines)
//        {
//                unsafe
//                {
//                    fixed (Int32* pipelines_ptr = pipelines)
//                    {
//                        Core.DeleteProgramPipelines((Int32)n, (UInt32*)pipelines_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Delete program pipeline objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of program pipeline objects to delete.
//        /// </para>
//        /// </param>
//        /// <param name="pipelines">
//        /// <para>
//        /// Specifies an array of names of program pipeline objects to delete.
//        /// </para>
//        /// </param>
//        public static
//        void DeleteProgramPipelines(Int32 n, ref Int32 pipelines)
//        {
//                unsafe
//                {
//                    fixed (Int32* pipelines_ptr = &pipelines)
//                    {
//                        Core.DeleteProgramPipelines((Int32)n, (UInt32*)pipelines_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Delete program pipeline objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of program pipeline objects to delete.
//        /// </para>
//        /// </param>
//        /// <param name="pipelines">
//        /// <para>
//        /// Specifies an array of names of program pipeline objects to delete.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void DeleteProgramPipelines(Int32 n, Int32* pipelines)
//        {
//                Core.DeleteProgramPipelines((Int32)n, (UInt32*)pipelines);
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Delete program pipeline objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of program pipeline objects to delete.
//        /// </para>
//        /// </param>
//        /// <param name="pipelines">
//        /// <para>
//        /// Specifies an array of names of program pipeline objects to delete.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DeleteProgramPipelines(Int32 n, UInt32[] pipelines)
//        {
//                unsafe
//                {
//                    fixed (UInt32* pipelines_ptr = pipelines)
//                    {
//                        Core.DeleteProgramPipelines((Int32)n, (UInt32*)pipelines_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Delete program pipeline objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of program pipeline objects to delete.
//        /// </para>
//        /// </param>
//        /// <param name="pipelines">
//        /// <para>
//        /// Specifies an array of names of program pipeline objects to delete.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DeleteProgramPipelines(Int32 n, ref UInt32 pipelines)
//        {
//                unsafe
//                {
//                    fixed (UInt32* pipelines_ptr = &pipelines)
//                    {
//                        Core.DeleteProgramPipelines((Int32)n, (UInt32*)pipelines_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Delete program pipeline objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of program pipeline objects to delete.
//        /// </para>
//        /// </param>
//        /// <param name="pipelines">
//        /// <para>
//        /// Specifies an array of names of program pipeline objects to delete.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void DeleteProgramPipelines(Int32 n, UInt32* pipelines)
//        {
//                Core.DeleteProgramPipelines((Int32)n, (UInt32*)pipelines);
//        }


        /// <summary>[requires: v1.5]
        /// Delete named query objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array of query objects to be deleted.
        /// </para>
        /// </param>
        public static
        void DeleteQueries(Int32 n, Int32[] ids)
        {
            unsafe
            {
                fixed (Int32* ids_ptr = ids)
                {
                    Core.DeleteQueries((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Delete named query objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array of query objects to be deleted.
        /// </para>
        /// </param>
        public static
        void DeleteQueries(Int32 n, ref Int32 ids)
        {
            unsafe
            {
                fixed (Int32* ids_ptr = &ids)
                {
                    Core.DeleteQueries((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Delete named query objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array of query objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void DeleteQueries(Int32 n, Int32* ids)
        {
            Core.DeleteQueries((Int32)n, (UInt32*)ids);
        }


        /// <summary>[requires: v1.5]
        /// Delete named query objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array of query objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void DeleteQueries(Int32 n, UInt32[] ids)
        {
            unsafe
            {
                fixed (UInt32* ids_ptr = ids)
                {
                    Core.DeleteQueries((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Delete named query objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array of query objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void DeleteQueries(Int32 n, ref UInt32 ids)
        {
            unsafe
            {
                fixed (UInt32* ids_ptr = &ids)
                {
                    Core.DeleteQueries((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Delete named query objects
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query objects to be deleted.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array of query objects to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void DeleteQueries(Int32 n, UInt32* ids)
        {
            Core.DeleteQueries((Int32)n, (UInt32*)ids);
        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Delete renderbuffer objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of renderbuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffers">
//        /// <para>
//        /// A pointer to an array containing n renderbuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        public static
//        void DeleteRenderbuffers(Int32 n, Int32[] renderbuffers)
//        {
//                unsafe
//                {
//                    fixed (Int32* renderbuffers_ptr = renderbuffers)
//                    {
//                        Core.DeleteRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Delete renderbuffer objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of renderbuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffers">
//        /// <para>
//        /// A pointer to an array containing n renderbuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        public static
//        void DeleteRenderbuffers(Int32 n, ref Int32 renderbuffers)
//        {
//                unsafe
//                {
//                    fixed (Int32* renderbuffers_ptr = &renderbuffers)
//                    {
//                        Core.DeleteRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Delete renderbuffer objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of renderbuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffers">
//        /// <para>
//        /// A pointer to an array containing n renderbuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void DeleteRenderbuffers(Int32 n, Int32* renderbuffers)
//        {
//                Core.DeleteRenderbuffers((Int32)n, (UInt32*)renderbuffers);
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Delete renderbuffer objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of renderbuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffers">
//        /// <para>
//        /// A pointer to an array containing n renderbuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DeleteRenderbuffers(Int32 n, UInt32[] renderbuffers)
//        {
//                unsafe
//                {
//                    fixed (UInt32* renderbuffers_ptr = renderbuffers)
//                    {
//                        Core.DeleteRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Delete renderbuffer objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of renderbuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffers">
//        /// <para>
//        /// A pointer to an array containing n renderbuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DeleteRenderbuffers(Int32 n, ref UInt32 renderbuffers)
//        {
//                unsafe
//                {
//                    fixed (UInt32* renderbuffers_ptr = &renderbuffers)
//                    {
//                        Core.DeleteRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Delete renderbuffer objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of renderbuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffers">
//        /// <para>
//        /// A pointer to an array containing n renderbuffer objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void DeleteRenderbuffers(Int32 n, UInt32* renderbuffers)
//        {
//                Core.DeleteRenderbuffers((Int32)n, (UInt32*)renderbuffers);
//        }


//        /// <summary>[requires: v1.2 and ARB_sampler_objects]
//        /// Delete named sampler objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of sampler objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of sampler objects to be deleted.
//        /// </para>
//        /// </param>
//        public static
//        void DeleteSamplers(Int32 count, Int32[] samplers)
//        {
//                unsafe
//                {
//                    fixed (Int32* samplers_ptr = samplers)
//                    {
//                        Core.DeleteSamplers((Int32)count, (UInt32*)samplers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_sampler_objects]
//        /// Delete named sampler objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of sampler objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of sampler objects to be deleted.
//        /// </para>
//        /// </param>
//        public static
//        void DeleteSamplers(Int32 count, ref Int32 samplers)
//        {
//                unsafe
//                {
//                    fixed (Int32* samplers_ptr = &samplers)
//                    {
//                        Core.DeleteSamplers((Int32)count, (UInt32*)samplers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_sampler_objects]
//        /// Delete named sampler objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of sampler objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of sampler objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void DeleteSamplers(Int32 count, Int32* samplers)
//        {
//                Core.DeleteSamplers((Int32)count, (UInt32*)samplers);
//        }


//        /// <summary>[requires: v1.2 and ARB_sampler_objects]
//        /// Delete named sampler objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of sampler objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of sampler objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DeleteSamplers(Int32 count, UInt32[] samplers)
//        {
//                unsafe
//                {
//                    fixed (UInt32* samplers_ptr = samplers)
//                    {
//                        Core.DeleteSamplers((Int32)count, (UInt32*)samplers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_sampler_objects]
//        /// Delete named sampler objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of sampler objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of sampler objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DeleteSamplers(Int32 count, ref UInt32 samplers)
//        {
//                unsafe
//                {
//                    fixed (UInt32* samplers_ptr = &samplers)
//                    {
//                        Core.DeleteSamplers((Int32)count, (UInt32*)samplers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_sampler_objects]
//        /// Delete named sampler objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of sampler objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of sampler objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void DeleteSamplers(Int32 count, UInt32* samplers)
//        {
//                Core.DeleteSamplers((Int32)count, (UInt32*)samplers);
//        }


        /// <summary>[requires: v2.0]
        /// Deletes a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be deleted.
        /// </para>
        /// </param>
        public static
        void DeleteShader(Int32 shader)
        {
            Core.DeleteShader((UInt32)shader);
        }


        /// <summary>[requires: v2.0]
        /// Deletes a shader object
        /// </summary>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void DeleteShader(UInt32 shader)
        {
            Core.DeleteShader((UInt32)shader);
        }


//        /// <summary>[requires: v1.2 and ARB_sync]
//        /// Delete a sync object
//        /// </summary>
//        /// <param name="sync">
//        /// <para>
//        /// The sync object to be deleted.
//        /// </para>
//        /// </param>
//        public static
//        void DeleteSync(IntPtr sync)
//        {
//                Core.DeleteSync((IntPtr)sync);
//        }


        /// <summary>[requires: v1.1]
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        public static
        void DeleteTextures(Int32 n, Int32[] textures)
        {
                unsafe
                {
                    fixed (Int32* textures_ptr = textures)
                    {
                        Core.DeleteTextures((Int32)n, (UInt32*)textures_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.1]
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        public static
        void DeleteTextures(Int32 n, ref Int32 textures)
        {
                unsafe
                {
                    fixed (Int32* textures_ptr = &textures)
                    {
                        Core.DeleteTextures((Int32)n, (UInt32*)textures_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.1]
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void DeleteTextures(Int32 n, Int32* textures)
        {
                Core.DeleteTextures((Int32)n, (UInt32*)textures);
        }


        /// <summary>[requires: v1.1]
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void DeleteTextures(Int32 n, UInt32[] textures)
        {
                unsafe
                {
                    fixed (UInt32* textures_ptr = textures)
                    {
                        Core.DeleteTextures((Int32)n, (UInt32*)textures_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.1]
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void DeleteTextures(Int32 n, ref UInt32 textures)
        {
                unsafe
                {
                    fixed (UInt32* textures_ptr = &textures)
                    {
                        Core.DeleteTextures((Int32)n, (UInt32*)textures_ptr);
                    }
                }
        }


        /// <summary>[requires: v1.1]
        /// Delete named textures
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of textures to be deleted.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array of textures to be deleted.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void DeleteTextures(Int32 n, UInt32* textures)
        {
                Core.DeleteTextures((Int32)n, (UInt32*)textures);
        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Delete transform feedback objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of transform feedback objects to delete.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of names of transform feedback objects to delete.
//        /// </para>
//        /// </param>
//        public static
//        void DeleteTransformFeedback(Int32 n, Int32[] ids)
//        {
//                unsafe
//                {
//                    fixed (Int32* ids_ptr = ids)
//                    {
//                        Core.DeleteTransformFeedbacks((Int32)n, (UInt32*)ids_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Delete transform feedback objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of transform feedback objects to delete.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of names of transform feedback objects to delete.
//        /// </para>
//        /// </param>
//        public static
//        void DeleteTransformFeedback(Int32 n, ref Int32 ids)
//        {
//                unsafe
//                {
//                    fixed (Int32* ids_ptr = &ids)
//                    {
//                        Core.DeleteTransformFeedbacks((Int32)n, (UInt32*)ids_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Delete transform feedback objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of transform feedback objects to delete.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of names of transform feedback objects to delete.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void DeleteTransformFeedback(Int32 n, Int32* ids)
//        {
//                Core.DeleteTransformFeedbacks((Int32)n, (UInt32*)ids);
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Delete transform feedback objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of transform feedback objects to delete.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of names of transform feedback objects to delete.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DeleteTransformFeedback(Int32 n, UInt32[] ids)
//        {
//                unsafe
//                {
//                    fixed (UInt32* ids_ptr = ids)
//                    {
//                        Core.DeleteTransformFeedbacks((Int32)n, (UInt32*)ids_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Delete transform feedback objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of transform feedback objects to delete.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of names of transform feedback objects to delete.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DeleteTransformFeedback(Int32 n, ref UInt32 ids)
//        {
//                unsafe
//                {
//                    fixed (UInt32* ids_ptr = &ids)
//                    {
//                        Core.DeleteTransformFeedbacks((Int32)n, (UInt32*)ids_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Delete transform feedback objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of transform feedback objects to delete.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of names of transform feedback objects to delete.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void DeleteTransformFeedback(Int32 n, UInt32* ids)
//        {
//                Core.DeleteTransformFeedbacks((Int32)n, (UInt32*)ids);
//        }


//        /// <summary>[requires: v3.0 and ARB_vertex_array_object]
//        /// Delete vertex array objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of vertex array objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="arrays">
//        /// <para>
//        /// Specifies the address of an array containing the n names of the objects to be deleted.
//        /// </para>
//        /// </param>
//        public static
//        void DeleteVertexArrays(Int32 n, Int32[] arrays)
//        {
//                unsafe
//                {
//                    fixed (Int32* arrays_ptr = arrays)
//                    {
//                        Core.DeleteVertexArrays((Int32)n, (UInt32*)arrays_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_vertex_array_object]
//        /// Delete vertex array objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of vertex array objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="arrays">
//        /// <para>
//        /// Specifies the address of an array containing the n names of the objects to be deleted.
//        /// </para>
//        /// </param>
//        public static
//        void DeleteVertexArrays(Int32 n, ref Int32 arrays)
//        {
//                unsafe
//                {
//                    fixed (Int32* arrays_ptr = &arrays)
//                    {
//                        Core.DeleteVertexArrays((Int32)n, (UInt32*)arrays_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_vertex_array_object]
//        /// Delete vertex array objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of vertex array objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="arrays">
//        /// <para>
//        /// Specifies the address of an array containing the n names of the objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void DeleteVertexArrays(Int32 n, Int32* arrays)
//        {
//                Core.DeleteVertexArrays((Int32)n, (UInt32*)arrays);
//        }


//        /// <summary>[requires: v3.0 and ARB_vertex_array_object]
//        /// Delete vertex array objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of vertex array objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="arrays">
//        /// <para>
//        /// Specifies the address of an array containing the n names of the objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DeleteVertexArrays(Int32 n, UInt32[] arrays)
//        {
//                unsafe
//                {
//                    fixed (UInt32* arrays_ptr = arrays)
//                    {
//                        Core.DeleteVertexArrays((Int32)n, (UInt32*)arrays_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_vertex_array_object]
//        /// Delete vertex array objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of vertex array objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="arrays">
//        /// <para>
//        /// Specifies the address of an array containing the n names of the objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DeleteVertexArrays(Int32 n, ref UInt32 arrays)
//        {
//                unsafe
//                {
//                    fixed (UInt32* arrays_ptr = &arrays)
//                    {
//                        Core.DeleteVertexArrays((Int32)n, (UInt32*)arrays_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_vertex_array_object]
//        /// Delete vertex array objects
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of vertex array objects to be deleted.
//        /// </para>
//        /// </param>
//        /// <param name="arrays">
//        /// <para>
//        /// Specifies the address of an array containing the n names of the objects to be deleted.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void DeleteVertexArrays(Int32 n, UInt32* arrays)
//        {
//                Core.DeleteVertexArrays((Int32)n, (UInt32*)arrays);
//        }


        /// <summary>[requires: v1.0]
        /// Specify the value used for depth buffer comparisons
        /// </summary>
        /// <param name="func">
        /// <para>
        /// Specifies the depth comparison function. Symbolic constants GL_NEVER, GL_LESS, GL_EQUAL, GL_LEQUAL, GL_GREATER, GL_NOTEQUAL, GL_GEQUAL, and GL_ALWAYS are accepted. The initial value is GL_LESS.
        /// </para>
        /// </param>
        public static
        void DepthFunc(MonoMac.OpenGL.DepthFunction func)
        {
            Core.DepthFunc((MonoMac.OpenGL.DepthFunction)func);
        }


        /// <summary>[requires: v1.0]
        /// Enable or disable writing into the depth buffer
        /// </summary>
        /// <param name="flag">
        /// <para>
        /// Specifies whether the depth buffer is enabled for writing. If flag is GL_FALSE, depth buffer writing is disabled. Otherwise, it is enabled. Initially, depth buffer writing is enabled.
        /// </para>
        /// </param>
        public static
        void DepthMask(bool flag)
        {
            Core.DepthMask((bool)flag);
        }


        /// <summary>[requires: v1.0]
        /// Specify mapping of depth values from normalized device coordinates to window coordinates
        /// </summary>
        /// <param name="nearVal">
        /// <para>
        /// Specifies the mapping of the near clipping plane to window coordinates. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="farVal">
        /// <para>
        /// Specifies the mapping of the far clipping plane to window coordinates. The initial value is 1.
        /// </para>
        /// </param>
        public static
        void DepthRange(Double near, Double far)
        {
            Core.DepthRange((Double)near, (Double)far);
        }


//        /// <summary>[requires: v4.1 and ARB_viewport_array]
//        /// Specify mapping of depth values from normalized device coordinates to window coordinates for a specified set of viewports
//        /// </summary>
//        /// <param name="first">
//        /// <para>
//        /// Specifies the index of the first viewport whose depth range to update.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of viewports whose depth range to update.
//        /// </para>
//        /// </param>
//        /// <param name="v">
//        /// <para>
//        /// Specifies the address of an array containing the near and far values for the depth range of each modified viewport.
//        /// </para>
//        /// </param>
//        public static
//        void DepthRangeArray(Int32 first, Int32 count, Double[] v)
//        {
//                unsafe
//                {
//                    fixed (Double* v_ptr = v)
//                    {
//                        Core.DepthRangeArrayv((UInt32)first, (Int32)count, (Double*)v_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_viewport_array]
//        /// Specify mapping of depth values from normalized device coordinates to window coordinates for a specified set of viewports
//        /// </summary>
//        /// <param name="first">
//        /// <para>
//        /// Specifies the index of the first viewport whose depth range to update.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of viewports whose depth range to update.
//        /// </para>
//        /// </param>
//        /// <param name="v">
//        /// <para>
//        /// Specifies the address of an array containing the near and far values for the depth range of each modified viewport.
//        /// </para>
//        /// </param>
//        public static
//        void DepthRangeArray(Int32 first, Int32 count, ref Double v)
//        {
//                unsafe
//                {
//                    fixed (Double* v_ptr = &v)
//                    {
//                        Core.DepthRangeArrayv((UInt32)first, (Int32)count, (Double*)v_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_viewport_array]
//        /// Specify mapping of depth values from normalized device coordinates to window coordinates for a specified set of viewports
//        /// </summary>
//        /// <param name="first">
//        /// <para>
//        /// Specifies the index of the first viewport whose depth range to update.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of viewports whose depth range to update.
//        /// </para>
//        /// </param>
//        /// <param name="v">
//        /// <para>
//        /// Specifies the address of an array containing the near and far values for the depth range of each modified viewport.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void DepthRangeArray(Int32 first, Int32 count, Double* v)
//        {
//                Core.DepthRangeArrayv((UInt32)first, (Int32)count, (Double*)v);
//        }


//        /// <summary>[requires: v4.1 and ARB_viewport_array]
//        /// Specify mapping of depth values from normalized device coordinates to window coordinates for a specified set of viewports
//        /// </summary>
//        /// <param name="first">
//        /// <para>
//        /// Specifies the index of the first viewport whose depth range to update.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of viewports whose depth range to update.
//        /// </para>
//        /// </param>
//        /// <param name="v">
//        /// <para>
//        /// Specifies the address of an array containing the near and far values for the depth range of each modified viewport.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DepthRangeArray(UInt32 first, Int32 count, Double[] v)
//        {
//                unsafe
//                {
//                    fixed (Double* v_ptr = v)
//                    {
//                        Core.DepthRangeArrayv((UInt32)first, (Int32)count, (Double*)v_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_viewport_array]
//        /// Specify mapping of depth values from normalized device coordinates to window coordinates for a specified set of viewports
//        /// </summary>
//        /// <param name="first">
//        /// <para>
//        /// Specifies the index of the first viewport whose depth range to update.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of viewports whose depth range to update.
//        /// </para>
//        /// </param>
//        /// <param name="v">
//        /// <para>
//        /// Specifies the address of an array containing the near and far values for the depth range of each modified viewport.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DepthRangeArray(UInt32 first, Int32 count, ref Double v)
//        {
//                unsafe
//                {
//                    fixed (Double* v_ptr = &v)
//                    {
//                        Core.DepthRangeArrayv((UInt32)first, (Int32)count, (Double*)v_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_viewport_array]
//        /// Specify mapping of depth values from normalized device coordinates to window coordinates for a specified set of viewports
//        /// </summary>
//        /// <param name="first">
//        /// <para>
//        /// Specifies the index of the first viewport whose depth range to update.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of viewports whose depth range to update.
//        /// </para>
//        /// </param>
//        /// <param name="v">
//        /// <para>
//        /// Specifies the address of an array containing the near and far values for the depth range of each modified viewport.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void DepthRangeArray(UInt32 first, Int32 count, Double* v)
//        {
//                Core.DepthRangeArrayv((UInt32)first, (Int32)count, (Double*)v);
//        }


//        /// <summary>[requires: v4.1 and ARB_ES2_compatibility]
//        /// Specify mapping of depth values from normalized device coordinates to window coordinates
//        /// </summary>
//        /// <param name="nearVal">
//        /// <para>
//        /// Specifies the mapping of the near clipping plane to window coordinates. The initial value is 0.
//        /// </para>
//        /// </param>
//        /// <param name="farVal">
//        /// <para>
//        /// Specifies the mapping of the far clipping plane to window coordinates. The initial value is 1.
//        /// </para>
//        /// </param>
//        public static
//        void DepthRange(Single n, Single f)
//        {
//                Core.DepthRangef((Single)n, (Single)f);
//        }


//        /// <summary>[requires: v4.1 and ARB_viewport_array]
//        /// Specify mapping of depth values from normalized device coordinates to window coordinates for a specified viewport
//        /// </summary>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the viewport whose depth range to update.
//        /// </para>
//        /// </param>
//        /// <param name="nearVal">
//        /// <para>
//        /// Specifies the mapping of the near clipping plane to window coordinates. The initial value is 0.
//        /// </para>
//        /// </param>
//        /// <param name="farVal">
//        /// <para>
//        /// Specifies the mapping of the far clipping plane to window coordinates. The initial value is 1.
//        /// </para>
//        /// </param>
//        public static
//        void DepthRangeIndexed(Int32 index, Double n, Double f)
//        {
//                Core.DepthRangeIndexed((UInt32)index, (Double)n, (Double)f);
//        }


//        /// <summary>[requires: v4.1 and ARB_viewport_array]
//        /// Specify mapping of depth values from normalized device coordinates to window coordinates for a specified viewport
//        /// </summary>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the viewport whose depth range to update.
//        /// </para>
//        /// </param>
//        /// <param name="nearVal">
//        /// <para>
//        /// Specifies the mapping of the near clipping plane to window coordinates. The initial value is 0.
//        /// </para>
//        /// </param>
//        /// <param name="farVal">
//        /// <para>
//        /// Specifies the mapping of the far clipping plane to window coordinates. The initial value is 1.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DepthRangeIndexed(UInt32 index, Double n, Double f)
//        {
//                Core.DepthRangeIndexed((UInt32)index, (Double)n, (Double)f);
//        }


        /// <summary>[requires: v2.0]
        /// Detaches a shader object from a program object to which it is attached
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object from which to detach the shader object.
        /// </para>
        /// </param>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be detached.
        /// </para>
        /// </param>
        public static
        void DetachShader(Int32 program, Int32 shader)
        {
            Core.DetachShader((UInt32)program, (UInt32)shader);
        }


        /// <summary>[requires: v2.0]
        /// Detaches a shader object from a program object to which it is attached
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object from which to detach the shader object.
        /// </para>
        /// </param>
        /// <param name="shader">
        /// <para>
        /// Specifies the shader object to be detached.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void DetachShader(UInt32 program, UInt32 shader)
        {
            Core.DetachShader((UInt32)program, (UInt32)shader);
        }

        /// <summary>[requires: v1.0]</summary>
        public static
        void Disable(MonoMac.OpenGL.EnableCap cap)
        {
            Core.Disable((MonoMac.OpenGL.EnableCap)cap);
        }

        /// <summary>[requires: v1.1][deprecated: v3.1]</summary>
        public static
        void DisableClientState(MonoMac.OpenGL.ArrayCap array)
        {
            Core.DisableClientState((MonoMac.OpenGL.ArrayCap)array);
        }

        /// <summary>[requires: v3.0]</summary>
        public static
        void Disable(MonoMac.OpenGL.IndexedEnableCap target, Int32 index)
        {
            Core.Disablei((MonoMac.OpenGL.IndexedEnableCap)target, (UInt32)index);
        }

        /// <summary>[requires: v3.0]</summary>
        [System.CLSCompliant(false)]
        public static
        void Disable(MonoMac.OpenGL.IndexedEnableCap target, UInt32 index)
        {
            Core.Disablei((MonoMac.OpenGL.IndexedEnableCap)target, (UInt32)index);
        }

        /// <summary>[requires: v2.0]</summary>
        public static
        void DisableVertexAttribArray(Int32 index)
        {
            Core.DisableVertexAttribArray((UInt32)index);
        }

        /// <summary>[requires: v2.0]</summary>
        [System.CLSCompliant(false)]
        public static
        void DisableVertexAttribArray(UInt32 index)
        {
            Core.DisableVertexAttribArray((UInt32)index);
        }


        /// <summary>[requires: v1.1]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="first">
        /// <para>
        /// Specifies the starting index in the enabled arrays.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of indices to be rendered.
        /// </para>
        /// </param>
        public static
        void DrawArrays(MonoMac.OpenGL.BeginMode mode, Int32 first, Int32 count)
        {
            Core.DrawArrays((MonoMac.OpenGL.BeginMode)mode, (Int32)first, (Int32)count);
        }


//        /// <summary>[requires: v1.2 and ARB_draw_indirect]
//        /// Render primitives from array data, taking parameters from memory
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="indirect">
//        /// <para>
//        /// Specifies the address of a structure containing the draw parameters.
//        /// </para>
//        /// </param>
//        public static
//        void DrawArraysIndirect(MonoMac.OpenGL.ArbDrawIndirect mode, IntPtr indirect)
//        {
//                Core.DrawArraysIndirect((MonoMac.OpenGL.ArbDrawIndirect)mode, (IntPtr)indirect);
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_indirect]
//        /// Render primitives from array data, taking parameters from memory
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="indirect">
//        /// <para>
//        /// Specifies the address of a structure containing the draw parameters.
//        /// </para>
//        /// </param>
//        public static
//        void DrawArraysIndirect<T1>(MonoMac.OpenGL.ArbDrawIndirect mode, [InAttribute, OutAttribute] T1[] indirect)
//            where T1 : struct
//        {
//                GCHandle indirect_ptr = GCHandle.Alloc(indirect, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawArraysIndirect((MonoMac.OpenGL.ArbDrawIndirect)mode, (IntPtr)indirect_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    indirect_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_indirect]
//        /// Render primitives from array data, taking parameters from memory
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="indirect">
//        /// <para>
//        /// Specifies the address of a structure containing the draw parameters.
//        /// </para>
//        /// </param>
//        public static
//        void DrawArraysIndirect<T1>(MonoMac.OpenGL.ArbDrawIndirect mode, [InAttribute, OutAttribute] T1[,] indirect)
//            where T1 : struct
//        {
//                GCHandle indirect_ptr = GCHandle.Alloc(indirect, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawArraysIndirect((MonoMac.OpenGL.ArbDrawIndirect)mode, (IntPtr)indirect_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    indirect_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_indirect]
//        /// Render primitives from array data, taking parameters from memory
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="indirect">
//        /// <para>
//        /// Specifies the address of a structure containing the draw parameters.
//        /// </para>
//        /// </param>
//        public static
//        void DrawArraysIndirect<T1>(MonoMac.OpenGL.ArbDrawIndirect mode, [InAttribute, OutAttribute] T1[, ,] indirect)
//            where T1 : struct
//        {
//                GCHandle indirect_ptr = GCHandle.Alloc(indirect, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawArraysIndirect((MonoMac.OpenGL.ArbDrawIndirect)mode, (IntPtr)indirect_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    indirect_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_indirect]
//        /// Render primitives from array data, taking parameters from memory
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="indirect">
//        /// <para>
//        /// Specifies the address of a structure containing the draw parameters.
//        /// </para>
//        /// </param>
//        public static
//        void DrawArraysIndirect<T1>(MonoMac.OpenGL.ArbDrawIndirect mode, [InAttribute, OutAttribute] ref T1 indirect)
//            where T1 : struct
//        {
//                GCHandle indirect_ptr = GCHandle.Alloc(indirect, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawArraysIndirect((MonoMac.OpenGL.ArbDrawIndirect)mode, (IntPtr)indirect_ptr.AddrOfPinnedObject());
//                    indirect = (T1)indirect_ptr.Target;
//                }
//                finally
//                {
//                    indirect_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v3.1]
//        /// Draw multiple instances of a range of elements
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="first">
//        /// <para>
//        /// Specifies the starting index in the enabled arrays.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of indices to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="primcount">
//        /// <para>
//        /// Specifies the number of instances of the specified range of indices to be rendered.
//        /// </para>
//        /// </param>
//        public static
//        void DrawArraysInstanced(MonoMac.OpenGL.BeginMode mode, Int32 first, Int32 count, Int32 primcount)
//        {
//                Core.DrawArraysInstanced((MonoMac.OpenGL.BeginMode)mode, (Int32)first, (Int32)count, (Int32)primcount);
//        }


        /// <summary>[requires: v1.0]
        /// Specify which color buffers are to be drawn into
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies up to four color buffers to be drawn into. Symbolic constants GL_NONE, GL_FRONT_LEFT, GL_FRONT_RIGHT, GL_BACK_LEFT, GL_BACK_RIGHT, GL_FRONT, GL_BACK, GL_LEFT, GL_RIGHT, and GL_FRONT_AND_BACK are accepted. The initial value is GL_FRONT for single-buffered contexts, and GL_BACK for double-buffered contexts.
        /// </para>
        /// </param>
        public static
        void DrawBuffer(MonoMac.OpenGL.DrawBufferMode mode)
        {
            Core.DrawBuffer((MonoMac.OpenGL.DrawBufferMode)mode);
        }


        /// <summary>[requires: v2.0]
        /// Specifies a list of color buffers to be drawn into
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffers in bufs.
        /// </para>
        /// </param>
        /// <param name="bufs">
        /// <para>
        /// Points to an array of symbolic constants specifying the buffers into which fragment colors or data values will be written.
        /// </para>
        /// </param>
        public static
        void DrawBuffers(Int32 n, MonoMac.OpenGL.DrawBuffersEnum[] bufs)
        {
            unsafe
            {
                fixed (MonoMac.OpenGL.DrawBuffersEnum* bufs_ptr = bufs)
                {
                    Core.DrawBuffers((Int32)n, (MonoMac.OpenGL.DrawBuffersEnum*)bufs_ptr);
                }
            }
        }


        /// <summary>[requires: v2.0]
        /// Specifies a list of color buffers to be drawn into
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffers in bufs.
        /// </para>
        /// </param>
        /// <param name="bufs">
        /// <para>
        /// Points to an array of symbolic constants specifying the buffers into which fragment colors or data values will be written.
        /// </para>
        /// </param>
        public static
        void DrawBuffers(Int32 n, ref MonoMac.OpenGL.DrawBuffersEnum bufs)
        {
            unsafe
            {
                fixed (MonoMac.OpenGL.DrawBuffersEnum* bufs_ptr = &bufs)
                {
                    Core.DrawBuffers((Int32)n, (MonoMac.OpenGL.DrawBuffersEnum*)bufs_ptr);
                }
            }
        }


        /// <summary>[requires: v2.0]
        /// Specifies a list of color buffers to be drawn into
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffers in bufs.
        /// </para>
        /// </param>
        /// <param name="bufs">
        /// <para>
        /// Points to an array of symbolic constants specifying the buffers into which fragment colors or data values will be written.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void DrawBuffers(Int32 n, MonoMac.OpenGL.DrawBuffersEnum* bufs)
        {
            Core.DrawBuffers((Int32)n, (MonoMac.OpenGL.DrawBuffersEnum*)bufs);
        }


        /// <summary>[requires: v1.1]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        public static
        void DrawElements(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, IntPtr indices)
        {
            Core.DrawElements((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices);
        }


        /// <summary>[requires: v1.1]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        public static
        void DrawElements<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[] indices)
            where T3 : struct
        {
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Core.DrawElements((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
        }


        /// <summary>[requires: v1.1]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        public static
        void DrawElements<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[,] indices)
            where T3 : struct
        {
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Core.DrawElements((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
        }


        /// <summary>[requires: v1.1]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        public static
        void DrawElements<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[, ,] indices)
            where T3 : struct
        {
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Core.DrawElements((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
        }


        /// <summary>[requires: v1.1]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        public static
        void DrawElements<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] ref T3 indices)
            where T3 : struct
        {
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Core.DrawElements((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
                indices = (T3)indices_ptr.Target;
            }
            finally
            {
                indices_ptr.Free();
            }
        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsBaseVertex(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, IntPtr indices, Int32 basevertex)
//        {
//                Core.DrawElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices, (Int32)basevertex);
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsBaseVertex<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[] indices, Int32 basevertex)
//            where T3 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)basevertex);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsBaseVertex<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[,] indices, Int32 basevertex)
//            where T3 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)basevertex);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsBaseVertex<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[, ,] indices, Int32 basevertex)
//            where T3 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)basevertex);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsBaseVertex<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] ref T3 indices, Int32 basevertex)
//            where T3 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)basevertex);
//                    indices = (T3)indices_ptr.Target;
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_indirect]
//        /// Render indexed primitives from array data, taking parameters from memory
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of data in the buffer bound to the GL_ELEMENT_ARRAY_BUFFER binding.
//        /// </para>
//        /// </param>
//        /// <param name="indirect">
//        /// <para>
//        /// Specifies the address of a structure containing the draw parameters.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsIndirect(MonoMac.OpenGL.ArbDrawIndirect mode, MonoMac.OpenGL.ArbDrawIndirect type, IntPtr indirect)
//        {
//                Core.DrawElementsIndirect((MonoMac.OpenGL.ArbDrawIndirect)mode, (MonoMac.OpenGL.ArbDrawIndirect)type, (IntPtr)indirect);
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_indirect]
//        /// Render indexed primitives from array data, taking parameters from memory
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of data in the buffer bound to the GL_ELEMENT_ARRAY_BUFFER binding.
//        /// </para>
//        /// </param>
//        /// <param name="indirect">
//        /// <para>
//        /// Specifies the address of a structure containing the draw parameters.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsIndirect<T2>(MonoMac.OpenGL.ArbDrawIndirect mode, MonoMac.OpenGL.ArbDrawIndirect type, [InAttribute, OutAttribute] T2[] indirect)
//            where T2 : struct
//        {
//                GCHandle indirect_ptr = GCHandle.Alloc(indirect, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsIndirect((MonoMac.OpenGL.ArbDrawIndirect)mode, (MonoMac.OpenGL.ArbDrawIndirect)type, (IntPtr)indirect_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    indirect_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_indirect]
//        /// Render indexed primitives from array data, taking parameters from memory
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of data in the buffer bound to the GL_ELEMENT_ARRAY_BUFFER binding.
//        /// </para>
//        /// </param>
//        /// <param name="indirect">
//        /// <para>
//        /// Specifies the address of a structure containing the draw parameters.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsIndirect<T2>(MonoMac.OpenGL.ArbDrawIndirect mode, MonoMac.OpenGL.ArbDrawIndirect type, [InAttribute, OutAttribute] T2[,] indirect)
//            where T2 : struct
//        {
//                GCHandle indirect_ptr = GCHandle.Alloc(indirect, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsIndirect((MonoMac.OpenGL.ArbDrawIndirect)mode, (MonoMac.OpenGL.ArbDrawIndirect)type, (IntPtr)indirect_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    indirect_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_indirect]
//        /// Render indexed primitives from array data, taking parameters from memory
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of data in the buffer bound to the GL_ELEMENT_ARRAY_BUFFER binding.
//        /// </para>
//        /// </param>
//        /// <param name="indirect">
//        /// <para>
//        /// Specifies the address of a structure containing the draw parameters.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsIndirect<T2>(MonoMac.OpenGL.ArbDrawIndirect mode, MonoMac.OpenGL.ArbDrawIndirect type, [InAttribute, OutAttribute] T2[, ,] indirect)
//            where T2 : struct
//        {
//                GCHandle indirect_ptr = GCHandle.Alloc(indirect, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsIndirect((MonoMac.OpenGL.ArbDrawIndirect)mode, (MonoMac.OpenGL.ArbDrawIndirect)type, (IntPtr)indirect_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    indirect_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_indirect]
//        /// Render indexed primitives from array data, taking parameters from memory
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of data in the buffer bound to the GL_ELEMENT_ARRAY_BUFFER binding.
//        /// </para>
//        /// </param>
//        /// <param name="indirect">
//        /// <para>
//        /// Specifies the address of a structure containing the draw parameters.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsIndirect<T2>(MonoMac.OpenGL.ArbDrawIndirect mode, MonoMac.OpenGL.ArbDrawIndirect type, [InAttribute, OutAttribute] ref T2 indirect)
//            where T2 : struct
//        {
//                GCHandle indirect_ptr = GCHandle.Alloc(indirect, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsIndirect((MonoMac.OpenGL.ArbDrawIndirect)mode, (MonoMac.OpenGL.ArbDrawIndirect)type, (IntPtr)indirect_ptr.AddrOfPinnedObject());
//                    indirect = (T2)indirect_ptr.Target;
//                }
//                finally
//                {
//                    indirect_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v3.1]
//        /// Draw multiple instances of a set of elements
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="primcount">
//        /// <para>
//        /// Specifies the number of instances of the specified range of indices to be rendered.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsInstanced(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, IntPtr indices, Int32 primcount)
//        {
//                Core.DrawElementsInstanced((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices, (Int32)primcount);
//        }


//        /// <summary>[requires: v3.1]
//        /// Draw multiple instances of a set of elements
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="primcount">
//        /// <para>
//        /// Specifies the number of instances of the specified range of indices to be rendered.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsInstanced<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[] indices, Int32 primcount)
//            where T3 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsInstanced((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v3.1]
//        /// Draw multiple instances of a set of elements
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="primcount">
//        /// <para>
//        /// Specifies the number of instances of the specified range of indices to be rendered.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsInstanced<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[,] indices, Int32 primcount)
//            where T3 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsInstanced((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v3.1]
//        /// Draw multiple instances of a set of elements
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="primcount">
//        /// <para>
//        /// Specifies the number of instances of the specified range of indices to be rendered.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsInstanced<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[, ,] indices, Int32 primcount)
//            where T3 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsInstanced((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v3.1]
//        /// Draw multiple instances of a set of elements
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="primcount">
//        /// <para>
//        /// Specifies the number of instances of the specified range of indices to be rendered.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsInstanced<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] ref T3 indices, Int32 primcount)
//            where T3 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsInstanced((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount);
//                    indices = (T3)indices_ptr.Target;
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render multiple instances of a set of primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="primcount">
//        /// <para>
//        /// Specifies the number of instances of the indexed geometry that should be drawn.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsInstancedBaseVertex(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, IntPtr indices, Int32 primcount, Int32 basevertex)
//        {
//                Core.DrawElementsInstancedBaseVertex((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices, (Int32)primcount, (Int32)basevertex);
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render multiple instances of a set of primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="primcount">
//        /// <para>
//        /// Specifies the number of instances of the indexed geometry that should be drawn.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsInstancedBaseVertex<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[] indices, Int32 primcount, Int32 basevertex)
//            where T3 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsInstancedBaseVertex((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount, (Int32)basevertex);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render multiple instances of a set of primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="primcount">
//        /// <para>
//        /// Specifies the number of instances of the indexed geometry that should be drawn.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsInstancedBaseVertex<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[,] indices, Int32 primcount, Int32 basevertex)
//            where T3 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsInstancedBaseVertex((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount, (Int32)basevertex);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render multiple instances of a set of primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="primcount">
//        /// <para>
//        /// Specifies the number of instances of the indexed geometry that should be drawn.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsInstancedBaseVertex<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T3[, ,] indices, Int32 primcount, Int32 basevertex)
//            where T3 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsInstancedBaseVertex((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount, (Int32)basevertex);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render multiple instances of a set of primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="primcount">
//        /// <para>
//        /// Specifies the number of instances of the indexed geometry that should be drawn.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawElementsInstancedBaseVertex<T3>(MonoMac.OpenGL.BeginMode mode, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] ref T3 indices, Int32 primcount, Int32 basevertex)
//            where T3 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawElementsInstancedBaseVertex((MonoMac.OpenGL.BeginMode)mode, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)primcount, (Int32)basevertex);
//                    indices = (T3)indices_ptr.Target;
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Write a block of pixels to the frame buffer
        /// </summary>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle to be written into the frame buffer.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. Symbolic constants GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA are accepted.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type for data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the pixel data.
        /// </para>
        /// </param>
        public static
        void DrawPixels(Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, IntPtr pixels)
        {
            Core.DrawPixels((Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)pixels);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Write a block of pixels to the frame buffer
        /// </summary>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle to be written into the frame buffer.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. Symbolic constants GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA are accepted.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type for data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the pixel data.
        /// </para>
        /// </param>
        public static
        void DrawPixels<T4>(Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T4[] pixels)
            where T4 : struct
        {
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Core.DrawPixels((Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Write a block of pixels to the frame buffer
        /// </summary>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle to be written into the frame buffer.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. Symbolic constants GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA are accepted.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type for data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the pixel data.
        /// </para>
        /// </param>
        public static
        void DrawPixels<T4>(Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T4[,] pixels)
            where T4 : struct
        {
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Core.DrawPixels((Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Write a block of pixels to the frame buffer
        /// </summary>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle to be written into the frame buffer.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. Symbolic constants GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA are accepted.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type for data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the pixel data.
        /// </para>
        /// </param>
        public static
        void DrawPixels<T4>(Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T4[, ,] pixels)
            where T4 : struct
        {
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Core.DrawPixels((Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pixels_ptr.Free();
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Write a block of pixels to the frame buffer
        /// </summary>
        /// <param name="width">
        /// <para>
        /// Specify the dimensions of the pixel rectangle to be written into the frame buffer.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Specifies the format of the pixel data. Symbolic constants GL_COLOR_INDEX, GL_STENCIL_INDEX, GL_DEPTH_COMPONENT, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, and GL_LUMINANCE_ALPHA are accepted.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the data type for data. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the pixel data.
        /// </para>
        /// </param>
        public static
        void DrawPixels<T4>(Int32 width, Int32 height, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] ref T4 pixels)
            where T4 : struct
        {
            GCHandle pixels_ptr = GCHandle.Alloc(pixels, GCHandleType.Pinned);
            try
            {
                Core.DrawPixels((Int32)width, (Int32)height, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)pixels_ptr.AddrOfPinnedObject());
                pixels = (T4)pixels_ptr.Target;
            }
            finally
            {
                pixels_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// Specifies the minimum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="end">
        /// <para>
        /// Specifies the maximum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        public static
        void DrawRangeElements(MonoMac.OpenGL.BeginMode mode, Int32 start, Int32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, IntPtr indices)
        {
            Core.DrawRangeElements((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices);
        }


        /// <summary>[requires: v1.2]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// Specifies the minimum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="end">
        /// <para>
        /// Specifies the maximum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        public static
        void DrawRangeElements<T5>(MonoMac.OpenGL.BeginMode mode, Int32 start, Int32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T5[] indices)
            where T5 : struct
        {
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Core.DrawRangeElements((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// Specifies the minimum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="end">
        /// <para>
        /// Specifies the maximum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        public static
        void DrawRangeElements<T5>(MonoMac.OpenGL.BeginMode mode, Int32 start, Int32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T5[,] indices)
            where T5 : struct
        {
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Core.DrawRangeElements((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// Specifies the minimum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="end">
        /// <para>
        /// Specifies the maximum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        public static
        void DrawRangeElements<T5>(MonoMac.OpenGL.BeginMode mode, Int32 start, Int32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T5[, ,] indices)
            where T5 : struct
        {
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Core.DrawRangeElements((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// Specifies the minimum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="end">
        /// <para>
        /// Specifies the maximum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        public static
        void DrawRangeElements<T5>(MonoMac.OpenGL.BeginMode mode, Int32 start, Int32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] ref T5 indices)
            where T5 : struct
        {
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Core.DrawRangeElements((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
                indices = (T5)indices_ptr.Target;
            }
            finally
            {
                indices_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// Specifies the minimum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="end">
        /// <para>
        /// Specifies the maximum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void DrawRangeElements(MonoMac.OpenGL.BeginMode mode, UInt32 start, UInt32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, IntPtr indices)
        {
            Core.DrawRangeElements((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices);
        }


        /// <summary>[requires: v1.2]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// Specifies the minimum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="end">
        /// <para>
        /// Specifies the maximum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void DrawRangeElements<T5>(MonoMac.OpenGL.BeginMode mode, UInt32 start, UInt32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T5[] indices)
            where T5 : struct
        {
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Core.DrawRangeElements((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// Specifies the minimum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="end">
        /// <para>
        /// Specifies the maximum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void DrawRangeElements<T5>(MonoMac.OpenGL.BeginMode mode, UInt32 start, UInt32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T5[,] indices)
            where T5 : struct
        {
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Core.DrawRangeElements((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// Specifies the minimum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="end">
        /// <para>
        /// Specifies the maximum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void DrawRangeElements<T5>(MonoMac.OpenGL.BeginMode mode, UInt32 start, UInt32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T5[, ,] indices)
            where T5 : struct
        {
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Core.DrawRangeElements((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
            }
            finally
            {
                indices_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2]
        /// Render primitives from array data
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY and GL_PATCHES are accepted.
        /// </para>
        /// </param>
        /// <param name="start">
        /// <para>
        /// Specifies the minimum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="end">
        /// <para>
        /// Specifies the maximum array index contained in indices.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Specifies the number of elements to be rendered.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
        /// </para>
        /// </param>
        /// <param name="indices">
        /// <para>
        /// Specifies a pointer to the location where the indices are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void DrawRangeElements<T5>(MonoMac.OpenGL.BeginMode mode, UInt32 start, UInt32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] ref T5 indices)
            where T5 : struct
        {
            GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
            try
            {
                Core.DrawRangeElements((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject());
                indices = (T5)indices_ptr.Target;
            }
            finally
            {
                indices_ptr.Free();
            }
        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="start">
//        /// <para>
//        /// Specifies the minimum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="end">
//        /// <para>
//        /// Specifies the maximum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawRangeElementsBaseVertex(MonoMac.OpenGL.BeginMode mode, Int32 start, Int32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, IntPtr indices, Int32 basevertex)
//        {
//                Core.DrawRangeElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices, (Int32)basevertex);
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="start">
//        /// <para>
//        /// Specifies the minimum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="end">
//        /// <para>
//        /// Specifies the maximum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawRangeElementsBaseVertex<T5>(MonoMac.OpenGL.BeginMode mode, Int32 start, Int32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T5[] indices, Int32 basevertex)
//            where T5 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawRangeElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)basevertex);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="start">
//        /// <para>
//        /// Specifies the minimum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="end">
//        /// <para>
//        /// Specifies the maximum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawRangeElementsBaseVertex<T5>(MonoMac.OpenGL.BeginMode mode, Int32 start, Int32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T5[,] indices, Int32 basevertex)
//            where T5 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawRangeElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)basevertex);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="start">
//        /// <para>
//        /// Specifies the minimum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="end">
//        /// <para>
//        /// Specifies the maximum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawRangeElementsBaseVertex<T5>(MonoMac.OpenGL.BeginMode mode, Int32 start, Int32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T5[, ,] indices, Int32 basevertex)
//            where T5 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawRangeElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)basevertex);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="start">
//        /// <para>
//        /// Specifies the minimum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="end">
//        /// <para>
//        /// Specifies the maximum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        public static
//        void DrawRangeElementsBaseVertex<T5>(MonoMac.OpenGL.BeginMode mode, Int32 start, Int32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] ref T5 indices, Int32 basevertex)
//            where T5 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawRangeElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)basevertex);
//                    indices = (T5)indices_ptr.Target;
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="start">
//        /// <para>
//        /// Specifies the minimum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="end">
//        /// <para>
//        /// Specifies the maximum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DrawRangeElementsBaseVertex(MonoMac.OpenGL.BeginMode mode, UInt32 start, UInt32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, IntPtr indices, Int32 basevertex)
//        {
//                Core.DrawRangeElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices, (Int32)basevertex);
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="start">
//        /// <para>
//        /// Specifies the minimum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="end">
//        /// <para>
//        /// Specifies the maximum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DrawRangeElementsBaseVertex<T5>(MonoMac.OpenGL.BeginMode mode, UInt32 start, UInt32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T5[] indices, Int32 basevertex)
//            where T5 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawRangeElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)basevertex);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="start">
//        /// <para>
//        /// Specifies the minimum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="end">
//        /// <para>
//        /// Specifies the maximum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DrawRangeElementsBaseVertex<T5>(MonoMac.OpenGL.BeginMode mode, UInt32 start, UInt32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T5[,] indices, Int32 basevertex)
//            where T5 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawRangeElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)basevertex);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="start">
//        /// <para>
//        /// Specifies the minimum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="end">
//        /// <para>
//        /// Specifies the maximum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DrawRangeElementsBaseVertex<T5>(MonoMac.OpenGL.BeginMode mode, UInt32 start, UInt32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] T5[, ,] indices, Int32 basevertex)
//            where T5 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawRangeElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)basevertex);
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_draw_elements_base_vertex]
//        /// Render primitives from array data with a per-element offset
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_LINES_ADJACENCY, GL_LINE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, GL_TRIANGLE_STRIP_ADJACENCY and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="start">
//        /// <para>
//        /// Specifies the minimum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="end">
//        /// <para>
//        /// Specifies the maximum array index contained in indices.
//        /// </para>
//        /// </param>
//        /// <param name="count">
//        /// <para>
//        /// Specifies the number of elements to be rendered.
//        /// </para>
//        /// </param>
//        /// <param name="type">
//        /// <para>
//        /// Specifies the type of the values in indices. Must be one of GL_UNSIGNED_BYTE, GL_UNSIGNED_SHORT, or GL_UNSIGNED_INT.
//        /// </para>
//        /// </param>
//        /// <param name="indices">
//        /// <para>
//        /// Specifies a pointer to the location where the indices are stored.
//        /// </para>
//        /// </param>
//        /// <param name="basevertex">
//        /// <para>
//        /// Specifies a constant that should be added to each element of indices when chosing elements from the enabled vertex arrays.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DrawRangeElementsBaseVertex<T5>(MonoMac.OpenGL.BeginMode mode, UInt32 start, UInt32 end, Int32 count, MonoMac.OpenGL.DrawElementsType type, [InAttribute, OutAttribute] ref T5 indices, Int32 basevertex)
//            where T5 : struct
//        {
//                GCHandle indices_ptr = GCHandle.Alloc(indices, GCHandleType.Pinned);
//                try
//                {
//                    Core.DrawRangeElementsBaseVertex((MonoMac.OpenGL.BeginMode)mode, (UInt32)start, (UInt32)end, (Int32)count, (MonoMac.OpenGL.DrawElementsType)type, (IntPtr)indices_ptr.AddrOfPinnedObject(), (Int32)basevertex);
//                    indices = (T5)indices_ptr.Target;
//                }
//                finally
//                {
//                    indices_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Render primitives using a count derived from a transform feedback object
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a transform feedback object from which to retrieve a primitive count.
//        /// </para>
//        /// </param>
//        public static
//        void DrawTransformFeedback(MonoMac.OpenGL.BeginMode mode, Int32 id)
//        {
//                Core.DrawTransformFeedback((MonoMac.OpenGL.BeginMode)mode, (UInt32)id);
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Render primitives using a count derived from a transform feedback object
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a transform feedback object from which to retrieve a primitive count.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DrawTransformFeedback(MonoMac.OpenGL.BeginMode mode, UInt32 id)
//        {
//                Core.DrawTransformFeedback((MonoMac.OpenGL.BeginMode)mode, (UInt32)id);
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback3]
//        /// Render primitives using a count derived from a specifed stream of a transform feedback object
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a transform feedback object from which to retrieve a primitive count.
//        /// </para>
//        /// </param>
//        /// <param name="stream">
//        /// <para>
//        /// Specifies the index of the transform feedback stream from which to retrieve a primitive count.
//        /// </para>
//        /// </param>
//        public static
//        void DrawTransformFeedbackStream(MonoMac.OpenGL.BeginMode mode, Int32 id, Int32 stream)
//        {
//                Core.DrawTransformFeedbackStream((MonoMac.OpenGL.BeginMode)mode, (UInt32)id, (UInt32)stream);
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback3]
//        /// Render primitives using a count derived from a specifed stream of a transform feedback object
//        /// </summary>
//        /// <param name="mode">
//        /// <para>
//        /// Specifies what kind of primitives to render. Symbolic constants GL_POINTS, GL_LINE_STRIP, GL_LINE_LOOP, GL_LINES, GL_LINE_STRIP_ADJACENCY, GL_LINES_ADJACENCY, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN, GL_TRIANGLES, GL_TRIANGLE_STRIP_ADJACENCY, GL_TRIANGLES_ADJACENCY, and GL_PATCHES are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a transform feedback object from which to retrieve a primitive count.
//        /// </para>
//        /// </param>
//        /// <param name="stream">
//        /// <para>
//        /// Specifies the index of the transform feedback stream from which to retrieve a primitive count.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void DrawTransformFeedbackStream(MonoMac.OpenGL.BeginMode mode, UInt32 id, UInt32 stream)
//        {
//                Core.DrawTransformFeedbackStream((MonoMac.OpenGL.BeginMode)mode, (UInt32)id, (UInt32)stream);
//        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Flag edges as either boundary or nonboundary
        /// </summary>
        /// <param name="flag">
        /// <para>
        /// Specifies the current edge flag value, either GL_TRUE or GL_FALSE. The initial value is GL_TRUE.
        /// </para>
        /// </param>
        public static
        void EdgeFlag(bool flag)
        {
            Core.EdgeFlag((bool)flag);
        }


        /// <summary>[requires: v1.1][deprecated: v3.1]
        /// Define an array of edge flags
        /// </summary>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive edge flags. If stride is 0, the edge flags are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first edge flag in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void EdgeFlagPointer(Int32 stride, IntPtr pointer)
        {
            Core.EdgeFlagPointer((Int32)stride, (IntPtr)pointer);
        }


        /// <summary>[requires: v1.1][deprecated: v3.1]
        /// Define an array of edge flags
        /// </summary>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive edge flags. If stride is 0, the edge flags are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first edge flag in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void EdgeFlagPointer<T1>(Int32 stride, [InAttribute, OutAttribute] T1[] pointer)
            where T1 : struct
        {
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Core.EdgeFlagPointer((Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
        }


        /// <summary>[requires: v1.1][deprecated: v3.1]
        /// Define an array of edge flags
        /// </summary>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive edge flags. If stride is 0, the edge flags are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first edge flag in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void EdgeFlagPointer<T1>(Int32 stride, [InAttribute, OutAttribute] T1[,] pointer)
            where T1 : struct
        {
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Core.EdgeFlagPointer((Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
        }


        /// <summary>[requires: v1.1][deprecated: v3.1]
        /// Define an array of edge flags
        /// </summary>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive edge flags. If stride is 0, the edge flags are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first edge flag in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void EdgeFlagPointer<T1>(Int32 stride, [InAttribute, OutAttribute] T1[, ,] pointer)
            where T1 : struct
        {
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Core.EdgeFlagPointer((Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
        }


        /// <summary>[requires: v1.1][deprecated: v3.1]
        /// Define an array of edge flags
        /// </summary>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive edge flags. If stride is 0, the edge flags are understood to be tightly packed in the array. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first edge flag in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void EdgeFlagPointer<T1>(Int32 stride, [InAttribute, OutAttribute] ref T1 pointer)
            where T1 : struct
        {
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Core.EdgeFlagPointer((Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                pointer = (T1)pointer_ptr.Target;
            }
            finally
            {
                pointer_ptr.Free();
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Flag edges as either boundary or nonboundary
        /// </summary>
        /// <param name="flag">
        /// <para>
        /// Specifies the current edge flag value, either GL_TRUE or GL_FALSE. The initial value is GL_TRUE.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void EdgeFlag(bool* flag)
        {
            Core.EdgeFlagv((bool*)flag);
        }


        /// <summary>[requires: v1.0]
        /// Enable or disable server-side GL capabilities
        /// </summary>
        /// <param name="cap">
        /// <para>
        /// Specifies a symbolic constant indicating a GL capability.
        /// </para>
        /// </param>
        public static
        void Enable(MonoMac.OpenGL.EnableCap cap)
        {
            Core.Enable((MonoMac.OpenGL.EnableCap)cap);
        }


        /// <summary>[requires: v1.1][deprecated: v3.1]
        /// Enable or disable client-side capability
        /// </summary>
        /// <param name="cap">
        /// <para>
        /// Specifies the capability to enable. Symbolic constants GL_COLOR_ARRAY, GL_EDGE_FLAG_ARRAY, GL_FOG_COORD_ARRAY, GL_INDEX_ARRAY, GL_NORMAL_ARRAY, GL_SECONDARY_COLOR_ARRAY, GL_TEXTURE_COORD_ARRAY, and GL_VERTEX_ARRAY are accepted.
        /// </para>
        /// </param>
        public static
        void EnableClientState(MonoMac.OpenGL.ArrayCap array)
        {
            Core.EnableClientState((MonoMac.OpenGL.ArrayCap)array);
        }


        /// <summary>[requires: v3.0]
        /// Enable or disable server-side GL capabilities
        /// </summary>
        /// <param name="cap">
        /// <para>
        /// Specifies a symbolic constant indicating a GL capability.
        /// </para>
        /// </param>
        public static
        void Enable(MonoMac.OpenGL.IndexedEnableCap target, Int32 index)
        {
            Core.Enablei((MonoMac.OpenGL.IndexedEnableCap)target, (UInt32)index);
        }


        /// <summary>[requires: v3.0]
        /// Enable or disable server-side GL capabilities
        /// </summary>
        /// <param name="cap">
        /// <para>
        /// Specifies a symbolic constant indicating a GL capability.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void Enable(MonoMac.OpenGL.IndexedEnableCap target, UInt32 index)
        {
            Core.Enablei((MonoMac.OpenGL.IndexedEnableCap)target, (UInt32)index);
        }


        /// <summary>[requires: v2.0]
        /// Enable or disable a generic vertex attribute array
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be enabled or disabled.
        /// </para>
        /// </param>
        public static
        void EnableVertexAttribArray(Int32 index)
        {
            Core.EnableVertexAttribArray((UInt32)index);
        }


        /// <summary>[requires: v2.0]
        /// Enable or disable a generic vertex attribute array
        /// </summary>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the generic vertex attribute to be enabled or disabled.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void EnableVertexAttribArray(UInt32 index)
        {
            Core.EnableVertexAttribArray((UInt32)index);
        }

        /// <summary>[requires: v1.0][deprecated: v3.1]</summary>
        public static
        void End()
        {
            Core.End();
        }

//        /// <summary>[requires: v3.0]</summary>
//        public static
//        void EndConditionalRender()
//        {
//                Core.EndConditionalRender();
//        }

        /// <summary>[requires: v1.0][deprecated: v3.1]</summary>
        public static
        void EndList()
        {
            Core.EndList();
        }

        /// <summary>[requires: v1.5]</summary>
        public static
        void EndQuery(MonoMac.OpenGL.QueryTarget target)
        {
            Core.EndQuery((MonoMac.OpenGL.QueryTarget)target);
        }

//        /// <summary>[requires: v1.2 and ARB_transform_feedback3]</summary>
//        public static
//        void EndQueryIndexed(MonoMac.OpenGL.QueryTarget target, Int32 index)
//        {
//                Core.EndQueryIndexed((MonoMac.OpenGL.QueryTarget)target, (UInt32)index);
//        }

//        /// <summary>[requires: v1.2 and ARB_transform_feedback3]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void EndQueryIndexed(MonoMac.OpenGL.QueryTarget target, UInt32 index)
//        {
//                Core.EndQueryIndexed((MonoMac.OpenGL.QueryTarget)target, (UInt32)index);
//        }

//        /// <summary>[requires: v3.0]</summary>
//        public static
//        void EndTransformFeedback()
//        {
//                Core.EndTransformFeedback();
//        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Evaluate enabled one- and two-dimensional maps
        /// </summary>
        /// <param name="u">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap1 or glMap2 command.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap2 command. This argument is not present in a glEvalCoord1 command.
        /// </para>
        /// </param>
        public static
        void EvalCoord1(Double u)
        {
            Core.EvalCoord1d((Double)u);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Evaluate enabled one- and two-dimensional maps
        /// </summary>
        /// <param name="u">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap1 or glMap2 command.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap2 command. This argument is not present in a glEvalCoord1 command.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void EvalCoord1(Double* u)
        {
            Core.EvalCoord1dv((Double*)u);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Evaluate enabled one- and two-dimensional maps
        /// </summary>
        /// <param name="u">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap1 or glMap2 command.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap2 command. This argument is not present in a glEvalCoord1 command.
        /// </para>
        /// </param>
        public static
        void EvalCoord1(Single u)
        {
            Core.EvalCoord1f((Single)u);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Evaluate enabled one- and two-dimensional maps
        /// </summary>
        /// <param name="u">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap1 or glMap2 command.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap2 command. This argument is not present in a glEvalCoord1 command.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void EvalCoord1(Single* u)
        {
            Core.EvalCoord1fv((Single*)u);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Evaluate enabled one- and two-dimensional maps
        /// </summary>
        /// <param name="u">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap1 or glMap2 command.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap2 command. This argument is not present in a glEvalCoord1 command.
        /// </para>
        /// </param>
        public static
        void EvalCoord2(Double u, Double v)
        {
            Core.EvalCoord2d((Double)u, (Double)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Evaluate enabled one- and two-dimensional maps
        /// </summary>
        /// <param name="u">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap1 or glMap2 command.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap2 command. This argument is not present in a glEvalCoord1 command.
        /// </para>
        /// </param>
        public static
        void EvalCoord2(Double[] u)
        {
            unsafe
            {
                fixed (Double* u_ptr = u)
                {
                    Core.EvalCoord2dv((Double*)u_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Evaluate enabled one- and two-dimensional maps
        /// </summary>
        /// <param name="u">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap1 or glMap2 command.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap2 command. This argument is not present in a glEvalCoord1 command.
        /// </para>
        /// </param>
        public static
        void EvalCoord2(ref Double u)
        {
            unsafe
            {
                fixed (Double* u_ptr = &u)
                {
                    Core.EvalCoord2dv((Double*)u_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Evaluate enabled one- and two-dimensional maps
        /// </summary>
        /// <param name="u">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap1 or glMap2 command.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap2 command. This argument is not present in a glEvalCoord1 command.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void EvalCoord2(Double* u)
        {
            Core.EvalCoord2dv((Double*)u);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Evaluate enabled one- and two-dimensional maps
        /// </summary>
        /// <param name="u">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap1 or glMap2 command.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap2 command. This argument is not present in a glEvalCoord1 command.
        /// </para>
        /// </param>
        public static
        void EvalCoord2(Single u, Single v)
        {
            Core.EvalCoord2f((Single)u, (Single)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Evaluate enabled one- and two-dimensional maps
        /// </summary>
        /// <param name="u">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap1 or glMap2 command.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap2 command. This argument is not present in a glEvalCoord1 command.
        /// </para>
        /// </param>
        public static
        void EvalCoord2(Single[] u)
        {
            unsafe
            {
                fixed (Single* u_ptr = u)
                {
                    Core.EvalCoord2fv((Single*)u_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Evaluate enabled one- and two-dimensional maps
        /// </summary>
        /// <param name="u">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap1 or glMap2 command.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap2 command. This argument is not present in a glEvalCoord1 command.
        /// </para>
        /// </param>
        public static
        void EvalCoord2(ref Single u)
        {
            unsafe
            {
                fixed (Single* u_ptr = &u)
                {
                    Core.EvalCoord2fv((Single*)u_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Evaluate enabled one- and two-dimensional maps
        /// </summary>
        /// <param name="u">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap1 or glMap2 command.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Specifies a value that is the domain coordinate to the basis function defined in a previous glMap2 command. This argument is not present in a glEvalCoord1 command.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void EvalCoord2(Single* u)
        {
            Core.EvalCoord2fv((Single*)u);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Compute a one- or two-dimensional grid of points or lines
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// In glEvalMesh1, specifies whether to compute a one-dimensional mesh of points or lines. Symbolic constants GL_POINT and GL_LINE are accepted.
        /// </para>
        /// </param>
        /// <param name="i1">
        /// <para>
        /// Specify the first and last integer values for grid domain variable .
        /// </para>
        /// </param>
        public static
        void EvalMesh1(MonoMac.OpenGL.MeshMode1 mode, Int32 i1, Int32 i2)
        {
            Core.EvalMesh1((MonoMac.OpenGL.MeshMode1)mode, (Int32)i1, (Int32)i2);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Compute a one- or two-dimensional grid of points or lines
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// In glEvalMesh1, specifies whether to compute a one-dimensional mesh of points or lines. Symbolic constants GL_POINT and GL_LINE are accepted.
        /// </para>
        /// </param>
        /// <param name="i1">
        /// <para>
        /// Specify the first and last integer values for grid domain variable .
        /// </para>
        /// </param>
        public static
        void EvalMesh2(MonoMac.OpenGL.MeshMode2 mode, Int32 i1, Int32 i2, Int32 j1, Int32 j2)
        {
            Core.EvalMesh2((MonoMac.OpenGL.MeshMode2)mode, (Int32)i1, (Int32)i2, (Int32)j1, (Int32)j2);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Generate and evaluate a single point in a mesh
        /// </summary>
        /// <param name="i">
        /// <para>
        /// Specifies the integer value for grid domain variable .
        /// </para>
        /// </param>
        /// <param name="j">
        /// <para>
        /// Specifies the integer value for grid domain variable (glEvalPoint2 only).
        /// </para>
        /// </param>
        public static
        void EvalPoint1(Int32 i)
        {
            Core.EvalPoint1((Int32)i);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Generate and evaluate a single point in a mesh
        /// </summary>
        /// <param name="i">
        /// <para>
        /// Specifies the integer value for grid domain variable .
        /// </para>
        /// </param>
        /// <param name="j">
        /// <para>
        /// Specifies the integer value for grid domain variable (glEvalPoint2 only).
        /// </para>
        /// </param>
        public static
        void EvalPoint2(Int32 i, Int32 j)
        {
            Core.EvalPoint2((Int32)i, (Int32)j);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Controls feedback mode
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the maximum number of values that can be written into buffer.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies a symbolic constant that describes the information that will be returned for each vertex. GL_2D, GL_3D, GL_3D_COLOR, GL_3D_COLOR_TEXTURE, and GL_4D_COLOR_TEXTURE are accepted.
        /// </para>
        /// </param>
        /// <param name="buffer">
        /// <para>
        /// Returns the feedback data.
        /// </para>
        /// </param>
        public static
        void FeedbackBuffer(Int32 size, MonoMac.OpenGL.FeedbackType type, [OutAttribute] Single[] buffer)
        {
            unsafe
            {
                fixed (Single* buffer_ptr = buffer)
                {
                    Core.FeedbackBuffer((Int32)size, (MonoMac.OpenGL.FeedbackType)type, (Single*)buffer_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Controls feedback mode
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the maximum number of values that can be written into buffer.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies a symbolic constant that describes the information that will be returned for each vertex. GL_2D, GL_3D, GL_3D_COLOR, GL_3D_COLOR_TEXTURE, and GL_4D_COLOR_TEXTURE are accepted.
        /// </para>
        /// </param>
        /// <param name="buffer">
        /// <para>
        /// Returns the feedback data.
        /// </para>
        /// </param>
        public static
        void FeedbackBuffer(Int32 size, MonoMac.OpenGL.FeedbackType type, [OutAttribute] out Single buffer)
        {
            unsafe
            {
                fixed (Single* buffer_ptr = &buffer)
                {
                    Core.FeedbackBuffer((Int32)size, (MonoMac.OpenGL.FeedbackType)type, (Single*)buffer_ptr);
                    buffer = *buffer_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Controls feedback mode
        /// </summary>
        /// <param name="size">
        /// <para>
        /// Specifies the maximum number of values that can be written into buffer.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Specifies a symbolic constant that describes the information that will be returned for each vertex. GL_2D, GL_3D, GL_3D_COLOR, GL_3D_COLOR_TEXTURE, and GL_4D_COLOR_TEXTURE are accepted.
        /// </para>
        /// </param>
        /// <param name="buffer">
        /// <para>
        /// Returns the feedback data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void FeedbackBuffer(Int32 size, MonoMac.OpenGL.FeedbackType type, [OutAttribute] Single* buffer)
        {
            Core.FeedbackBuffer((Int32)size, (MonoMac.OpenGL.FeedbackType)type, (Single*)buffer);
        }


//        /// <summary>[requires: v1.2 and ARB_sync]
//        /// Create a new sync object and insert it into the GL command stream
//        /// </summary>
//        /// <param name="condition">
//        /// <para>
//        /// Specifies the condition that must be met to set the sync object's state to signaled. condition must be GL_SYNC_GPU_COMMANDS_COMPLETE.
//        /// </para>
//        /// </param>
//        /// <param name="flags">
//        /// <para>
//        /// Specifies a bitwise combination of flags controlling the behavior of the sync object. No flags are presently defined for this operation and flags must be zero. flags is a placeholder for anticipated future extensions of fence sync object capabilities.
//        /// </para>
//        /// </param>
//        public static
//        IntPtr FenceSync(MonoMac.OpenGL.ArbSync condition, Int32 flags)
//        {
//                return Core.FenceSync((MonoMac.OpenGL.ArbSync)condition, (UInt32)flags);
//        }


//        /// <summary>[requires: v1.2 and ARB_sync]
//        /// Create a new sync object and insert it into the GL command stream
//        /// </summary>
//        /// <param name="condition">
//        /// <para>
//        /// Specifies the condition that must be met to set the sync object's state to signaled. condition must be GL_SYNC_GPU_COMMANDS_COMPLETE.
//        /// </para>
//        /// </param>
//        /// <param name="flags">
//        /// <para>
//        /// Specifies a bitwise combination of flags controlling the behavior of the sync object. No flags are presently defined for this operation and flags must be zero. flags is a placeholder for anticipated future extensions of fence sync object capabilities.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        IntPtr FenceSync(MonoMac.OpenGL.ArbSync condition, UInt32 flags)
//        {
//                return Core.FenceSync((MonoMac.OpenGL.ArbSync)condition, (UInt32)flags);
//        }


        /// <summary>[requires: v1.0]
        /// Block until all GL execution is complete
        /// </summary>
        public static
        void Finish()
        {
            Core.Finish();
        }


        /// <summary>[requires: v1.0]
        /// Force execution of GL commands in finite time
        /// </summary>
        public static
        void Flush()
        {
            Core.Flush();
        }


//        /// <summary>[requires: v3.0 and ARB_map_buffer_range]
//        /// Indicate modifications to a range of a mapped buffer
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the target of the flush operation. target must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="offset">
//        /// <para>
//        /// Specifies the start of the buffer subrange, in basic machine units.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the length of the buffer subrange, in basic machine units.
//        /// </para>
//        /// </param>
//        public static
//        void FlushMappedBufferRange(MonoMac.OpenGL.BufferTarget target, IntPtr offset, IntPtr length)
//        {
//                Core.FlushMappedBufferRange((MonoMac.OpenGL.BufferTarget)target, (IntPtr)offset, (IntPtr)length);
//        }


        /// <summary>[requires: v1.4][deprecated: v3.1]
        /// Set the current fog coordinates
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specify the fog distance.
        /// </para>
        /// </param>
        public static
        void FogCoord(Double coord)
        {
            Core.FogCoordd((Double)coord);
        }


        /// <summary>[requires: v1.4][deprecated: v3.1]
        /// Set the current fog coordinates
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specify the fog distance.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void FogCoord(Double* coord)
        {
            Core.FogCoorddv((Double*)coord);
        }


        /// <summary>[requires: v1.4][deprecated: v3.1]
        /// Set the current fog coordinates
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specify the fog distance.
        /// </para>
        /// </param>
        public static
        void FogCoord(Single coord)
        {
            Core.FogCoordf((Single)coord);
        }


        /// <summary>[requires: v1.4][deprecated: v3.1]
        /// Set the current fog coordinates
        /// </summary>
        /// <param name="coord">
        /// <para>
        /// Specify the fog distance.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void FogCoord(Single* coord)
        {
            Core.FogCoordfv((Single*)coord);
        }


        /// <summary>[requires: v1.4][deprecated: v3.1]
        /// Define an array of fog coordinates
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each fog coordinate. Symbolic constants GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive fog coordinates. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first fog coordinate in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void FogCoordPointer(MonoMac.OpenGL.FogPointerType type, Int32 stride, IntPtr pointer)
        {
            Core.FogCoordPointer((MonoMac.OpenGL.FogPointerType)type, (Int32)stride, (IntPtr)pointer);
        }


        /// <summary>[requires: v1.4][deprecated: v3.1]
        /// Define an array of fog coordinates
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each fog coordinate. Symbolic constants GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive fog coordinates. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first fog coordinate in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void FogCoordPointer<T2>(MonoMac.OpenGL.FogPointerType type, Int32 stride, [InAttribute, OutAttribute] T2[] pointer)
            where T2 : struct
        {
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Core.FogCoordPointer((MonoMac.OpenGL.FogPointerType)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
        }


        /// <summary>[requires: v1.4][deprecated: v3.1]
        /// Define an array of fog coordinates
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each fog coordinate. Symbolic constants GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive fog coordinates. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first fog coordinate in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void FogCoordPointer<T2>(MonoMac.OpenGL.FogPointerType type, Int32 stride, [InAttribute, OutAttribute] T2[,] pointer)
            where T2 : struct
        {
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Core.FogCoordPointer((MonoMac.OpenGL.FogPointerType)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
        }


        /// <summary>[requires: v1.4][deprecated: v3.1]
        /// Define an array of fog coordinates
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each fog coordinate. Symbolic constants GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive fog coordinates. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first fog coordinate in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void FogCoordPointer<T2>(MonoMac.OpenGL.FogPointerType type, Int32 stride, [InAttribute, OutAttribute] T2[, ,] pointer)
            where T2 : struct
        {
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Core.FogCoordPointer((MonoMac.OpenGL.FogPointerType)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
            }
            finally
            {
                pointer_ptr.Free();
            }
        }


        /// <summary>[requires: v1.4][deprecated: v3.1]
        /// Define an array of fog coordinates
        /// </summary>
        /// <param name="type">
        /// <para>
        /// Specifies the data type of each fog coordinate. Symbolic constants GL_FLOAT, or GL_DOUBLE are accepted. The initial value is GL_FLOAT.
        /// </para>
        /// </param>
        /// <param name="stride">
        /// <para>
        /// Specifies the byte offset between consecutive fog coordinates. If stride is 0, the array elements are understood to be tightly packed. The initial value is 0.
        /// </para>
        /// </param>
        /// <param name="pointer">
        /// <para>
        /// Specifies a pointer to the first coordinate of the first fog coordinate in the array. The initial value is 0.
        /// </para>
        /// </param>
        public static
        void FogCoordPointer<T2>(MonoMac.OpenGL.FogPointerType type, Int32 stride, [InAttribute, OutAttribute] ref T2 pointer)
            where T2 : struct
        {
            GCHandle pointer_ptr = GCHandle.Alloc(pointer, GCHandleType.Pinned);
            try
            {
                Core.FogCoordPointer((MonoMac.OpenGL.FogPointerType)type, (Int32)stride, (IntPtr)pointer_ptr.AddrOfPinnedObject());
                pointer = (T2)pointer_ptr.Target;
            }
            finally
            {
                pointer_ptr.Free();
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Specify fog parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued fog parameter. GL_FOG_MODE, GL_FOG_DENSITY, GL_FOG_START, GL_FOG_END, GL_FOG_INDEX, and GL_FOG_COORD_SRC are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        public static
        void Fog(MonoMac.OpenGL.FogParameter pname, Single param)
        {
            Core.Fogf((MonoMac.OpenGL.FogParameter)pname, (Single)param);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Specify fog parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued fog parameter. GL_FOG_MODE, GL_FOG_DENSITY, GL_FOG_START, GL_FOG_END, GL_FOG_INDEX, and GL_FOG_COORD_SRC are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        public static
        void Fog(MonoMac.OpenGL.FogParameter pname, Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Core.Fogfv((MonoMac.OpenGL.FogParameter)pname, (Single*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Specify fog parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued fog parameter. GL_FOG_MODE, GL_FOG_DENSITY, GL_FOG_START, GL_FOG_END, GL_FOG_INDEX, and GL_FOG_COORD_SRC are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Fog(MonoMac.OpenGL.FogParameter pname, Single* @params)
        {
            Core.Fogfv((MonoMac.OpenGL.FogParameter)pname, (Single*)@params);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Specify fog parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued fog parameter. GL_FOG_MODE, GL_FOG_DENSITY, GL_FOG_START, GL_FOG_END, GL_FOG_INDEX, and GL_FOG_COORD_SRC are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        public static
        void Fog(MonoMac.OpenGL.FogParameter pname, Int32 param)
        {
            Core.Fogi((MonoMac.OpenGL.FogParameter)pname, (Int32)param);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Specify fog parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued fog parameter. GL_FOG_MODE, GL_FOG_DENSITY, GL_FOG_START, GL_FOG_END, GL_FOG_INDEX, and GL_FOG_COORD_SRC are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        public static
        void Fog(MonoMac.OpenGL.FogParameter pname, Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Core.Fogiv((MonoMac.OpenGL.FogParameter)pname, (Int32*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Specify fog parameters
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies a single-valued fog parameter. GL_FOG_MODE, GL_FOG_DENSITY, GL_FOG_START, GL_FOG_END, GL_FOG_INDEX, and GL_FOG_COORD_SRC are accepted.
        /// </para>
        /// </param>
        /// <param name="param">
        /// <para>
        /// Specifies the value that pname will be set to.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void Fog(MonoMac.OpenGL.FogParameter pname, Int32* @params)
        {
            Core.Fogiv((MonoMac.OpenGL.FogParameter)pname, (Int32*)@params);
        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Attach a renderbuffer as a logical buffer to the currently bound framebuffer object
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER, GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="attachment">
//        /// <para>
//        /// Specifies the attachment point of the framebuffer.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffertarget">
//        /// <para>
//        /// Specifies the renderbuffer target and must be GL_RENDERBUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffer">
//        /// <para>
//        /// Specifies the name of an existing renderbuffer object of type renderbuffertarget to attach.
//        /// </para>
//        /// </param>
//        public static
//        void FramebufferRenderbuffer(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, MonoMac.OpenGL.RenderbufferTarget renderbuffertarget, Int32 renderbuffer)
//        {
//                Core.FramebufferRenderbuffer((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (MonoMac.OpenGL.RenderbufferTarget)renderbuffertarget, (UInt32)renderbuffer);
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Attach a renderbuffer as a logical buffer to the currently bound framebuffer object
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER, GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="attachment">
//        /// <para>
//        /// Specifies the attachment point of the framebuffer.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffertarget">
//        /// <para>
//        /// Specifies the renderbuffer target and must be GL_RENDERBUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffer">
//        /// <para>
//        /// Specifies the name of an existing renderbuffer object of type renderbuffertarget to attach.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void FramebufferRenderbuffer(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, MonoMac.OpenGL.RenderbufferTarget renderbuffertarget, UInt32 renderbuffer)
//        {
//                Core.FramebufferRenderbuffer((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (MonoMac.OpenGL.RenderbufferTarget)renderbuffertarget, (UInt32)renderbuffer);
//        }


//        /// <summary>[requires: v1.2]
//        /// Attach a level of a texture object as a logical buffer to the currently bound framebuffer object
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER, GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="attachment">
//        /// <para>
//        /// Specifies the attachment point of the framebuffer. attachment must be GL_COLOR_ATTACHMENTi, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT or GL_DEPTH_STENCIL_ATTACHMMENT.
//        /// </para>
//        /// </param>
//        /// <param name="texture">
//        /// <para>
//        /// Specifies the texture object to attach to the framebuffer attachment point named by attachment.
//        /// </para>
//        /// </param>
//        /// <param name="level">
//        /// <para>
//        /// Specifies the mipmap level of texture to attach.
//        /// </para>
//        /// </param>
//        public static
//        void FramebufferTexture(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, Int32 texture, Int32 level)
//        {
//                Core.FramebufferTexture((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (UInt32)texture, (Int32)level);
//        }


//        /// <summary>[requires: v1.2]
//        /// Attach a level of a texture object as a logical buffer to the currently bound framebuffer object
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER, GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="attachment">
//        /// <para>
//        /// Specifies the attachment point of the framebuffer. attachment must be GL_COLOR_ATTACHMENTi, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT or GL_DEPTH_STENCIL_ATTACHMMENT.
//        /// </para>
//        /// </param>
//        /// <param name="texture">
//        /// <para>
//        /// Specifies the texture object to attach to the framebuffer attachment point named by attachment.
//        /// </para>
//        /// </param>
//        /// <param name="level">
//        /// <para>
//        /// Specifies the mipmap level of texture to attach.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void FramebufferTexture(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, UInt32 texture, Int32 level)
//        {
//                Core.FramebufferTexture((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (UInt32)texture, (Int32)level);
//        }

//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]</summary>
//        public static
//        void FramebufferTexture1D(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, MonoMac.OpenGL.TextureTarget textarget, Int32 texture, Int32 level)
//        {
//                Core.FramebufferTexture1D((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (MonoMac.OpenGL.TextureTarget)textarget, (UInt32)texture, (Int32)level);
//        }

//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void FramebufferTexture1D(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, MonoMac.OpenGL.TextureTarget textarget, UInt32 texture, Int32 level)
//        {
//                Core.FramebufferTexture1D((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (MonoMac.OpenGL.TextureTarget)textarget, (UInt32)texture, (Int32)level);
//        }

//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]</summary>
//        public static
//        void FramebufferTexture2D(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, MonoMac.OpenGL.TextureTarget textarget, Int32 texture, Int32 level)
//        {
//                Core.FramebufferTexture2D((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (MonoMac.OpenGL.TextureTarget)textarget, (UInt32)texture, (Int32)level);
//        }

//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void FramebufferTexture2D(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, MonoMac.OpenGL.TextureTarget textarget, UInt32 texture, Int32 level)
//        {
//                Core.FramebufferTexture2D((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (MonoMac.OpenGL.TextureTarget)textarget, (UInt32)texture, (Int32)level);
//        }

//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]</summary>
//        public static
//        void FramebufferTexture3D(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, MonoMac.OpenGL.TextureTarget textarget, Int32 texture, Int32 level, Int32 zoffset)
//        {
//                Core.FramebufferTexture3D((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (MonoMac.OpenGL.TextureTarget)textarget, (UInt32)texture, (Int32)level, (Int32)zoffset);
//        }

//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void FramebufferTexture3D(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, MonoMac.OpenGL.TextureTarget textarget, UInt32 texture, Int32 level, Int32 zoffset)
//        {
//                Core.FramebufferTexture3D((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (MonoMac.OpenGL.TextureTarget)textarget, (UInt32)texture, (Int32)level, (Int32)zoffset);
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Attach a single layer of a texture to a framebuffer
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER, GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="attachment">
//        /// <para>
//        /// Specifies the attachment point of the framebuffer. attachment must be GL_COLOR_ATTACHMENTi, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT or GL_DEPTH_STENCIL_ATTACHMMENT.
//        /// </para>
//        /// </param>
//        /// <param name="texture">
//        /// <para>
//        /// Specifies the texture object to attach to the framebuffer attachment point named by attachment.
//        /// </para>
//        /// </param>
//        /// <param name="level">
//        /// <para>
//        /// Specifies the mipmap level of texture to attach.
//        /// </para>
//        /// </param>
//        /// <param name="layer">
//        /// <para>
//        /// Specifies the layer of texture to attach.
//        /// </para>
//        /// </param>
//        public static
//        void FramebufferTextureLayer(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, Int32 texture, Int32 level, Int32 layer)
//        {
//                Core.FramebufferTextureLayer((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (UInt32)texture, (Int32)level, (Int32)layer);
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Attach a single layer of a texture to a framebuffer
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the framebuffer target. target must be GL_DRAW_FRAMEBUFFER, GL_READ_FRAMEBUFFER, or GL_FRAMEBUFFER. GL_FRAMEBUFFER is equivalent to GL_DRAW_FRAMEBUFFER.
//        /// </para>
//        /// </param>
//        /// <param name="attachment">
//        /// <para>
//        /// Specifies the attachment point of the framebuffer. attachment must be GL_COLOR_ATTACHMENTi, GL_DEPTH_ATTACHMENT, GL_STENCIL_ATTACHMENT or GL_DEPTH_STENCIL_ATTACHMMENT.
//        /// </para>
//        /// </param>
//        /// <param name="texture">
//        /// <para>
//        /// Specifies the texture object to attach to the framebuffer attachment point named by attachment.
//        /// </para>
//        /// </param>
//        /// <param name="level">
//        /// <para>
//        /// Specifies the mipmap level of texture to attach.
//        /// </para>
//        /// </param>
//        /// <param name="layer">
//        /// <para>
//        /// Specifies the layer of texture to attach.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void FramebufferTextureLayer(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, UInt32 texture, Int32 level, Int32 layer)
//        {
//                Core.FramebufferTextureLayer((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (UInt32)texture, (Int32)level, (Int32)layer);
//        }


        /// <summary>[requires: v1.0]
        /// Define front- and back-facing polygons
        /// </summary>
        /// <param name="mode">
        /// <para>
        /// Specifies the orientation of front-facing polygons. GL_CW and GL_CCW are accepted. The initial value is GL_CCW.
        /// </para>
        /// </param>
        public static
        void FrontFace(MonoMac.OpenGL.FrontFaceDirection mode)
        {
            Core.FrontFace((MonoMac.OpenGL.FrontFaceDirection)mode);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Multiply the current matrix by a perspective matrix
        /// </summary>
        /// <param name="left">
        /// <para>
        /// Specify the coordinates for the left and right vertical clipping planes.
        /// </para>
        /// </param>
        /// <param name="bottom">
        /// <para>
        /// Specify the coordinates for the bottom and top horizontal clipping planes.
        /// </para>
        /// </param>
        /// <param name="nearVal">
        /// <para>
        /// Specify the distances to the near and far depth clipping planes. Both distances must be positive.
        /// </para>
        /// </param>
        public static
        void Frustum(Double left, Double right, Double bottom, Double top, Double zNear, Double zFar)
        {
            Core.Frustum((Double)left, (Double)right, (Double)bottom, (Double)top, (Double)zNear, (Double)zFar);
        }


        /// <summary>[requires: v1.5]
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        public static
        void GenBuffers(Int32 n, [OutAttribute] Int32[] buffers)
        {
            unsafe
            {
                fixed (Int32* buffers_ptr = buffers)
                {
                    Core.GenBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        public static
        void GenBuffers(Int32 n, [OutAttribute] out Int32 buffers)
        {
            unsafe
            {
                fixed (Int32* buffers_ptr = &buffers)
                {
                    Core.GenBuffers((Int32)n, (UInt32*)buffers_ptr);
                    buffers = *buffers_ptr;
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GenBuffers(Int32 n, [OutAttribute] Int32* buffers)
        {
            Core.GenBuffers((Int32)n, (UInt32*)buffers);
        }


        /// <summary>[requires: v1.5]
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GenBuffers(Int32 n, [OutAttribute] UInt32[] buffers)
        {
            unsafe
            {
                fixed (UInt32* buffers_ptr = buffers)
                {
                    Core.GenBuffers((Int32)n, (UInt32*)buffers_ptr);
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GenBuffers(Int32 n, [OutAttribute] out UInt32 buffers)
        {
            unsafe
            {
                fixed (UInt32* buffers_ptr = &buffers)
                {
                    Core.GenBuffers((Int32)n, (UInt32*)buffers_ptr);
                    buffers = *buffers_ptr;
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Generate buffer object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of buffer object names to be generated.
        /// </para>
        /// </param>
        /// <param name="buffers">
        /// <para>
        /// Specifies an array in which the generated buffer object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GenBuffers(Int32 n, [OutAttribute] UInt32* buffers)
        {
            Core.GenBuffers((Int32)n, (UInt32*)buffers);
        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Generate mipmaps for a specified texture target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the target to which the texture whose mimaps to generate is bound. target must be GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY or GL_TEXTURE_CUBE_MAP.
//        /// </para>
//        /// </param>
//        public static
//        void GenerateMipmap(MonoMac.OpenGL.GenerateMipmapTarget target)
//        {
//                Core.GenerateMipmap((MonoMac.OpenGL.GenerateMipmapTarget)target);
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Generate framebuffer object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of framebuffer object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array in which the generated framebuffer object names are stored.
//        /// </para>
//        /// </param>
//        public static
//        void GenFramebuffers(Int32 n, [OutAttribute] Int32[] framebuffers)
//        {
//                unsafe
//                {
//                    fixed (Int32* framebuffers_ptr = framebuffers)
//                    {
//                        Core.GenFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Generate framebuffer object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of framebuffer object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array in which the generated framebuffer object names are stored.
//        /// </para>
//        /// </param>
//        public static
//        void GenFramebuffers(Int32 n, [OutAttribute] out Int32 framebuffers)
//        {
//                unsafe
//                {
//                    fixed (Int32* framebuffers_ptr = &framebuffers)
//                    {
//                        Core.GenFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
//                        framebuffers = *framebuffers_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Generate framebuffer object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of framebuffer object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array in which the generated framebuffer object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GenFramebuffers(Int32 n, [OutAttribute] Int32* framebuffers)
//        {
//                Core.GenFramebuffers((Int32)n, (UInt32*)framebuffers);
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Generate framebuffer object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of framebuffer object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array in which the generated framebuffer object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GenFramebuffers(Int32 n, [OutAttribute] UInt32[] framebuffers)
//        {
//                unsafe
//                {
//                    fixed (UInt32* framebuffers_ptr = framebuffers)
//                    {
//                        Core.GenFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Generate framebuffer object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of framebuffer object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array in which the generated framebuffer object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GenFramebuffers(Int32 n, [OutAttribute] out UInt32 framebuffers)
//        {
//                unsafe
//                {
//                    fixed (UInt32* framebuffers_ptr = &framebuffers)
//                    {
//                        Core.GenFramebuffers((Int32)n, (UInt32*)framebuffers_ptr);
//                        framebuffers = *framebuffers_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Generate framebuffer object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of framebuffer object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array in which the generated framebuffer object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GenFramebuffers(Int32 n, [OutAttribute] UInt32* framebuffers)
//        {
//                Core.GenFramebuffers((Int32)n, (UInt32*)framebuffers);
//        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Generate a contiguous set of empty display lists
        /// </summary>
        /// <param name="range">
        /// <para>
        /// Specifies the number of contiguous empty display lists to be generated.
        /// </para>
        /// </param>
        public static
        Int32 GenLists(Int32 range)
        {
            return Core.GenLists((Int32)range);
        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Reserve program pipeline object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of program pipeline object names to reserve.
//        /// </para>
//        /// </param>
//        /// <param name="pipelines">
//        /// <para>
//        /// Specifies an array of into which the reserved names will be written.
//        /// </para>
//        /// </param>
//        public static
//        void GenProgramPipelines(Int32 n, [OutAttribute] Int32[] pipelines)
//        {
//                unsafe
//                {
//                    fixed (Int32* pipelines_ptr = pipelines)
//                    {
//                        Core.GenProgramPipelines((Int32)n, (UInt32*)pipelines_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Reserve program pipeline object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of program pipeline object names to reserve.
//        /// </para>
//        /// </param>
//        /// <param name="pipelines">
//        /// <para>
//        /// Specifies an array of into which the reserved names will be written.
//        /// </para>
//        /// </param>
//        public static
//        void GenProgramPipelines(Int32 n, [OutAttribute] out Int32 pipelines)
//        {
//                unsafe
//                {
//                    fixed (Int32* pipelines_ptr = &pipelines)
//                    {
//                        Core.GenProgramPipelines((Int32)n, (UInt32*)pipelines_ptr);
//                        pipelines = *pipelines_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Reserve program pipeline object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of program pipeline object names to reserve.
//        /// </para>
//        /// </param>
//        /// <param name="pipelines">
//        /// <para>
//        /// Specifies an array of into which the reserved names will be written.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GenProgramPipelines(Int32 n, [OutAttribute] Int32* pipelines)
//        {
//                Core.GenProgramPipelines((Int32)n, (UInt32*)pipelines);
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Reserve program pipeline object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of program pipeline object names to reserve.
//        /// </para>
//        /// </param>
//        /// <param name="pipelines">
//        /// <para>
//        /// Specifies an array of into which the reserved names will be written.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GenProgramPipelines(Int32 n, [OutAttribute] UInt32[] pipelines)
//        {
//                unsafe
//                {
//                    fixed (UInt32* pipelines_ptr = pipelines)
//                    {
//                        Core.GenProgramPipelines((Int32)n, (UInt32*)pipelines_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Reserve program pipeline object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of program pipeline object names to reserve.
//        /// </para>
//        /// </param>
//        /// <param name="pipelines">
//        /// <para>
//        /// Specifies an array of into which the reserved names will be written.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GenProgramPipelines(Int32 n, [OutAttribute] out UInt32 pipelines)
//        {
//                unsafe
//                {
//                    fixed (UInt32* pipelines_ptr = &pipelines)
//                    {
//                        Core.GenProgramPipelines((Int32)n, (UInt32*)pipelines_ptr);
//                        pipelines = *pipelines_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Reserve program pipeline object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of program pipeline object names to reserve.
//        /// </para>
//        /// </param>
//        /// <param name="pipelines">
//        /// <para>
//        /// Specifies an array of into which the reserved names will be written.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GenProgramPipelines(Int32 n, [OutAttribute] UInt32* pipelines)
//        {
//                Core.GenProgramPipelines((Int32)n, (UInt32*)pipelines);
//        }


        /// <summary>[requires: v1.5]
        /// Generate query object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query object names to be generated.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array in which the generated query object names are stored.
        /// </para>
        /// </param>
        public static
        void GenQueries(Int32 n, [OutAttribute] Int32[] ids)
        {
            unsafe
            {
                fixed (Int32* ids_ptr = ids)
                {
                    Core.GenQueries((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Generate query object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query object names to be generated.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array in which the generated query object names are stored.
        /// </para>
        /// </param>
        public static
        void GenQueries(Int32 n, [OutAttribute] out Int32 ids)
        {
            unsafe
            {
                fixed (Int32* ids_ptr = &ids)
                {
                    Core.GenQueries((Int32)n, (UInt32*)ids_ptr);
                    ids = *ids_ptr;
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Generate query object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query object names to be generated.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array in which the generated query object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GenQueries(Int32 n, [OutAttribute] Int32* ids)
        {
            Core.GenQueries((Int32)n, (UInt32*)ids);
        }


        /// <summary>[requires: v1.5]
        /// Generate query object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query object names to be generated.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array in which the generated query object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GenQueries(Int32 n, [OutAttribute] UInt32[] ids)
        {
            unsafe
            {
                fixed (UInt32* ids_ptr = ids)
                {
                    Core.GenQueries((Int32)n, (UInt32*)ids_ptr);
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Generate query object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query object names to be generated.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array in which the generated query object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GenQueries(Int32 n, [OutAttribute] out UInt32 ids)
        {
            unsafe
            {
                fixed (UInt32* ids_ptr = &ids)
                {
                    Core.GenQueries((Int32)n, (UInt32*)ids_ptr);
                    ids = *ids_ptr;
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Generate query object names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of query object names to be generated.
        /// </para>
        /// </param>
        /// <param name="ids">
        /// <para>
        /// Specifies an array in which the generated query object names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GenQueries(Int32 n, [OutAttribute] UInt32* ids)
        {
            Core.GenQueries((Int32)n, (UInt32*)ids);
        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Generate renderbuffer object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of renderbuffer object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffers">
//        /// <para>
//        /// Specifies an array in which the generated renderbuffer object names are stored.
//        /// </para>
//        /// </param>
//        public static
//        void GenRenderbuffers(Int32 n, [OutAttribute] Int32[] renderbuffers)
//        {
//                unsafe
//                {
//                    fixed (Int32* renderbuffers_ptr = renderbuffers)
//                    {
//                        Core.GenRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Generate renderbuffer object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of renderbuffer object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffers">
//        /// <para>
//        /// Specifies an array in which the generated renderbuffer object names are stored.
//        /// </para>
//        /// </param>
//        public static
//        void GenRenderbuffers(Int32 n, [OutAttribute] out Int32 renderbuffers)
//        {
//                unsafe
//                {
//                    fixed (Int32* renderbuffers_ptr = &renderbuffers)
//                    {
//                        Core.GenRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
//                        renderbuffers = *renderbuffers_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Generate renderbuffer object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of renderbuffer object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffers">
//        /// <para>
//        /// Specifies an array in which the generated renderbuffer object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GenRenderbuffers(Int32 n, [OutAttribute] Int32* renderbuffers)
//        {
//                Core.GenRenderbuffers((Int32)n, (UInt32*)renderbuffers);
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Generate renderbuffer object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of renderbuffer object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffers">
//        /// <para>
//        /// Specifies an array in which the generated renderbuffer object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GenRenderbuffers(Int32 n, [OutAttribute] UInt32[] renderbuffers)
//        {
//                unsafe
//                {
//                    fixed (UInt32* renderbuffers_ptr = renderbuffers)
//                    {
//                        Core.GenRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Generate renderbuffer object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of renderbuffer object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffers">
//        /// <para>
//        /// Specifies an array in which the generated renderbuffer object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GenRenderbuffers(Int32 n, [OutAttribute] out UInt32 renderbuffers)
//        {
//                unsafe
//                {
//                    fixed (UInt32* renderbuffers_ptr = &renderbuffers)
//                    {
//                        Core.GenRenderbuffers((Int32)n, (UInt32*)renderbuffers_ptr);
//                        renderbuffers = *renderbuffers_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Generate renderbuffer object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of renderbuffer object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="renderbuffers">
//        /// <para>
//        /// Specifies an array in which the generated renderbuffer object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GenRenderbuffers(Int32 n, [OutAttribute] UInt32* renderbuffers)
//        {
//                Core.GenRenderbuffers((Int32)n, (UInt32*)renderbuffers);
//        }


//        /// <summary>[requires: v1.2 and ARB_sampler_objects]
//        /// Generate sampler object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of sampler object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="samplers">
//        /// <para>
//        /// Specifies an array in which the generated sampler object names are stored.
//        /// </para>
//        /// </param>
//        public static
//        void GenSamplers(Int32 count, [OutAttribute] Int32[] samplers)
//        {
//                unsafe
//                {
//                    fixed (Int32* samplers_ptr = samplers)
//                    {
//                        Core.GenSamplers((Int32)count, (UInt32*)samplers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_sampler_objects]
//        /// Generate sampler object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of sampler object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="samplers">
//        /// <para>
//        /// Specifies an array in which the generated sampler object names are stored.
//        /// </para>
//        /// </param>
//        public static
//        void GenSamplers(Int32 count, [OutAttribute] out Int32 samplers)
//        {
//                unsafe
//                {
//                    fixed (Int32* samplers_ptr = &samplers)
//                    {
//                        Core.GenSamplers((Int32)count, (UInt32*)samplers_ptr);
//                        samplers = *samplers_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_sampler_objects]
//        /// Generate sampler object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of sampler object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="samplers">
//        /// <para>
//        /// Specifies an array in which the generated sampler object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GenSamplers(Int32 count, [OutAttribute] Int32* samplers)
//        {
//                Core.GenSamplers((Int32)count, (UInt32*)samplers);
//        }


//        /// <summary>[requires: v1.2 and ARB_sampler_objects]
//        /// Generate sampler object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of sampler object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="samplers">
//        /// <para>
//        /// Specifies an array in which the generated sampler object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GenSamplers(Int32 count, [OutAttribute] UInt32[] samplers)
//        {
//                unsafe
//                {
//                    fixed (UInt32* samplers_ptr = samplers)
//                    {
//                        Core.GenSamplers((Int32)count, (UInt32*)samplers_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_sampler_objects]
//        /// Generate sampler object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of sampler object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="samplers">
//        /// <para>
//        /// Specifies an array in which the generated sampler object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GenSamplers(Int32 count, [OutAttribute] out UInt32 samplers)
//        {
//                unsafe
//                {
//                    fixed (UInt32* samplers_ptr = &samplers)
//                    {
//                        Core.GenSamplers((Int32)count, (UInt32*)samplers_ptr);
//                        samplers = *samplers_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_sampler_objects]
//        /// Generate sampler object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of sampler object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="samplers">
//        /// <para>
//        /// Specifies an array in which the generated sampler object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GenSamplers(Int32 count, [OutAttribute] UInt32* samplers)
//        {
//                Core.GenSamplers((Int32)count, (UInt32*)samplers);
//        }


        /// <summary>[requires: v1.1]
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        public static
        void GenTextures(Int32 n, [OutAttribute] Int32[] textures)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = textures)
                {
                    Core.GenTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
        }


        /// <summary>[requires: v1.1]
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        public static
        void GenTextures(Int32 n, [OutAttribute] out Int32 textures)
        {
            unsafe
            {
                fixed (Int32* textures_ptr = &textures)
                {
                    Core.GenTextures((Int32)n, (UInt32*)textures_ptr);
                    textures = *textures_ptr;
                }
            }
        }


        /// <summary>[requires: v1.1]
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GenTextures(Int32 n, [OutAttribute] Int32* textures)
        {
            Core.GenTextures((Int32)n, (UInt32*)textures);
        }


        /// <summary>[requires: v1.1]
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GenTextures(Int32 n, [OutAttribute] UInt32[] textures)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = textures)
                {
                    Core.GenTextures((Int32)n, (UInt32*)textures_ptr);
                }
            }
        }


        /// <summary>[requires: v1.1]
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GenTextures(Int32 n, [OutAttribute] out UInt32 textures)
        {
            unsafe
            {
                fixed (UInt32* textures_ptr = &textures)
                {
                    Core.GenTextures((Int32)n, (UInt32*)textures_ptr);
                    textures = *textures_ptr;
                }
            }
        }


        /// <summary>[requires: v1.1]
        /// Generate texture names
        /// </summary>
        /// <param name="n">
        /// <para>
        /// Specifies the number of texture names to be generated.
        /// </para>
        /// </param>
        /// <param name="textures">
        /// <para>
        /// Specifies an array in which the generated texture names are stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GenTextures(Int32 n, [OutAttribute] UInt32* textures)
        {
            Core.GenTextures((Int32)n, (UInt32*)textures);
        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Reserve transform feedback object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of transform feedback object names to reserve.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of into which the reserved names will be written.
//        /// </para>
//        /// </param>
//        public static
//        void GenTransformFeedback(Int32 n, [OutAttribute] Int32[] ids)
//        {
//                unsafe
//                {
//                    fixed (Int32* ids_ptr = ids)
//                    {
//                        Core.GenTransformFeedbacks((Int32)n, (UInt32*)ids_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Reserve transform feedback object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of transform feedback object names to reserve.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of into which the reserved names will be written.
//        /// </para>
//        /// </param>
//        public static
//        void GenTransformFeedback(Int32 n, [OutAttribute] out Int32 ids)
//        {
//                unsafe
//                {
//                    fixed (Int32* ids_ptr = &ids)
//                    {
//                        Core.GenTransformFeedbacks((Int32)n, (UInt32*)ids_ptr);
//                        ids = *ids_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Reserve transform feedback object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of transform feedback object names to reserve.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of into which the reserved names will be written.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GenTransformFeedback(Int32 n, [OutAttribute] Int32* ids)
//        {
//                Core.GenTransformFeedbacks((Int32)n, (UInt32*)ids);
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Reserve transform feedback object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of transform feedback object names to reserve.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of into which the reserved names will be written.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GenTransformFeedback(Int32 n, [OutAttribute] UInt32[] ids)
//        {
//                unsafe
//                {
//                    fixed (UInt32* ids_ptr = ids)
//                    {
//                        Core.GenTransformFeedbacks((Int32)n, (UInt32*)ids_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Reserve transform feedback object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of transform feedback object names to reserve.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of into which the reserved names will be written.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GenTransformFeedback(Int32 n, [OutAttribute] out UInt32 ids)
//        {
//                unsafe
//                {
//                    fixed (UInt32* ids_ptr = &ids)
//                    {
//                        Core.GenTransformFeedbacks((Int32)n, (UInt32*)ids_ptr);
//                        ids = *ids_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback2]
//        /// Reserve transform feedback object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of transform feedback object names to reserve.
//        /// </para>
//        /// </param>
//        /// <param name="ids">
//        /// <para>
//        /// Specifies an array of into which the reserved names will be written.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GenTransformFeedback(Int32 n, [OutAttribute] UInt32* ids)
//        {
//                Core.GenTransformFeedbacks((Int32)n, (UInt32*)ids);
//        }


//        /// <summary>[requires: v3.0 and ARB_vertex_array_object]
//        /// Generate vertex array object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of vertex array object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="arrays">
//        /// <para>
//        /// Specifies an array in which the generated vertex array object names are stored.
//        /// </para>
//        /// </param>
//        public static
//        void GenVertexArrays(Int32 n, [OutAttribute] Int32[] arrays)
//        {
//                unsafe
//                {
//                    fixed (Int32* arrays_ptr = arrays)
//                    {
//                        Core.GenVertexArrays((Int32)n, (UInt32*)arrays_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_vertex_array_object]
//        /// Generate vertex array object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of vertex array object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="arrays">
//        /// <para>
//        /// Specifies an array in which the generated vertex array object names are stored.
//        /// </para>
//        /// </param>
//        public static
//        void GenVertexArrays(Int32 n, [OutAttribute] out Int32 arrays)
//        {
//                unsafe
//                {
//                    fixed (Int32* arrays_ptr = &arrays)
//                    {
//                        Core.GenVertexArrays((Int32)n, (UInt32*)arrays_ptr);
//                        arrays = *arrays_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_vertex_array_object]
//        /// Generate vertex array object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of vertex array object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="arrays">
//        /// <para>
//        /// Specifies an array in which the generated vertex array object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GenVertexArrays(Int32 n, [OutAttribute] Int32* arrays)
//        {
//                Core.GenVertexArrays((Int32)n, (UInt32*)arrays);
//        }


//        /// <summary>[requires: v3.0 and ARB_vertex_array_object]
//        /// Generate vertex array object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of vertex array object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="arrays">
//        /// <para>
//        /// Specifies an array in which the generated vertex array object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GenVertexArrays(Int32 n, [OutAttribute] UInt32[] arrays)
//        {
//                unsafe
//                {
//                    fixed (UInt32* arrays_ptr = arrays)
//                    {
//                        Core.GenVertexArrays((Int32)n, (UInt32*)arrays_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_vertex_array_object]
//        /// Generate vertex array object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of vertex array object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="arrays">
//        /// <para>
//        /// Specifies an array in which the generated vertex array object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GenVertexArrays(Int32 n, [OutAttribute] out UInt32 arrays)
//        {
//                unsafe
//                {
//                    fixed (UInt32* arrays_ptr = &arrays)
//                    {
//                        Core.GenVertexArrays((Int32)n, (UInt32*)arrays_ptr);
//                        arrays = *arrays_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_vertex_array_object]
//        /// Generate vertex array object names
//        /// </summary>
//        /// <param name="n">
//        /// <para>
//        /// Specifies the number of vertex array object names to generate.
//        /// </para>
//        /// </param>
//        /// <param name="arrays">
//        /// <para>
//        /// Specifies an array in which the generated vertex array object names are stored.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GenVertexArrays(Int32 n, [OutAttribute] UInt32* arrays)
//        {
//                Core.GenVertexArrays((Int32)n, (UInt32*)arrays);
//        }


        /// <summary>[requires: v2.0]
        /// Returns information about an active attribute variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the attribute variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the attribute variable.
        /// </para>
        /// </param>
        public static
        void GetActiveAttrib(Int32 program, Int32 index, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out Int32 size, [OutAttribute] out MonoMac.OpenGL.ActiveAttribType type, [OutAttribute] StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (MonoMac.OpenGL.ActiveAttribType* type_ptr = &type)
                {
                    Core.GetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length_ptr, (Int32*)size_ptr, (MonoMac.OpenGL.ActiveAttribType*)type_ptr, (StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
        }


        /// <summary>[requires: v2.0]
        /// Returns information about an active attribute variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the attribute variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the attribute variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetActiveAttrib(Int32 program, Int32 index, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] Int32* size, [OutAttribute] MonoMac.OpenGL.ActiveAttribType* type, [OutAttribute] StringBuilder name)
        {
            Core.GetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length, (Int32*)size, (MonoMac.OpenGL.ActiveAttribType*)type, (StringBuilder)name);
        }


        /// <summary>[requires: v2.0]
        /// Returns information about an active attribute variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the attribute variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the attribute variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GetActiveAttrib(UInt32 program, UInt32 index, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out Int32 size, [OutAttribute] out MonoMac.OpenGL.ActiveAttribType type, [OutAttribute] StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (MonoMac.OpenGL.ActiveAttribType* type_ptr = &type)
                {
                    Core.GetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length_ptr, (Int32*)size_ptr, (MonoMac.OpenGL.ActiveAttribType*)type_ptr, (StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
        }


        /// <summary>[requires: v2.0]
        /// Returns information about an active attribute variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the attribute variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the attribute variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the attribute variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetActiveAttrib(UInt32 program, UInt32 index, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] Int32* size, [OutAttribute] MonoMac.OpenGL.ActiveAttribType* type, [OutAttribute] StringBuilder name)
        {
            Core.GetActiveAttrib((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length, (Int32*)size, (MonoMac.OpenGL.ActiveAttribType*)type, (StringBuilder)name);
        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Query the name of an active shader subroutine
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing the subroutine.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query the subroutine name.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the shader subroutine uniform.
//        /// </para>
//        /// </param>
//        /// <param name="bufsize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given in name.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable which is to receive the length of the shader subroutine uniform name.
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// Specifies the address of an array into which the name of the shader subroutine uniform will be written.
//        /// </para>
//        /// </param>
//        public static
//        void GetActiveSubroutineName(Int32 program, MonoMac.OpenGL.ShaderType shadertype, Int32 index, Int32 bufsize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder name)
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    {
//                        Core.GetActiveSubroutineName((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (UInt32)index, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)name);
//                        length = *length_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Query the name of an active shader subroutine
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing the subroutine.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query the subroutine name.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the shader subroutine uniform.
//        /// </para>
//        /// </param>
//        /// <param name="bufsize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given in name.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable which is to receive the length of the shader subroutine uniform name.
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// Specifies the address of an array into which the name of the shader subroutine uniform will be written.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetActiveSubroutineName(Int32 program, MonoMac.OpenGL.ShaderType shadertype, Int32 index, Int32 bufsize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder name)
//        {
//                Core.GetActiveSubroutineName((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (UInt32)index, (Int32)bufsize, (Int32*)length, (StringBuilder)name);
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Query the name of an active shader subroutine
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing the subroutine.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query the subroutine name.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the shader subroutine uniform.
//        /// </para>
//        /// </param>
//        /// <param name="bufsize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given in name.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable which is to receive the length of the shader subroutine uniform name.
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// Specifies the address of an array into which the name of the shader subroutine uniform will be written.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetActiveSubroutineName(UInt32 program, MonoMac.OpenGL.ShaderType shadertype, UInt32 index, Int32 bufsize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder name)
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    {
//                        Core.GetActiveSubroutineName((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (UInt32)index, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)name);
//                        length = *length_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Query the name of an active shader subroutine
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing the subroutine.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query the subroutine name.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the shader subroutine uniform.
//        /// </para>
//        /// </param>
//        /// <param name="bufsize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given in name.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable which is to receive the length of the shader subroutine uniform name.
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// Specifies the address of an array into which the name of the shader subroutine uniform will be written.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetActiveSubroutineName(UInt32 program, MonoMac.OpenGL.ShaderType shadertype, UInt32 index, Int32 bufsize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder name)
//        {
//                Core.GetActiveSubroutineName((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (UInt32)index, (Int32)bufsize, (Int32*)length, (StringBuilder)name);
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Query a property of an active shader subroutine uniform
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing the subroutine.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query for the subroutine parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the shader subroutine uniform.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the parameter of the shader subroutine uniform to query. pname must be GL_NUM_COMPATIBLE_SUBROUTINES, GL_COMPATIBLE_SUBROUTINES, GL_UNIFORM_SIZE or GL_UNIFORM_NAME_LENGTH.
//        /// </para>
//        /// </param>
//        /// <param name="values">
//        /// <para>
//        /// Specifies the address of a into which the queried value or values will be placed.
//        /// </para>
//        /// </param>
//        public static
//        void GetActiveSubroutineUniform(Int32 program, MonoMac.OpenGL.ShaderType shadertype, Int32 index, MonoMac.OpenGL.ActiveSubroutineUniformParameter pname, [OutAttribute] Int32[] values)
//        {
//                unsafe
//                {
//                    fixed (Int32* values_ptr = values)
//                    {
//                        Core.GetActiveSubroutineUniformiv((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (UInt32)index, (MonoMac.OpenGL.ActiveSubroutineUniformParameter)pname, (Int32*)values_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Query a property of an active shader subroutine uniform
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing the subroutine.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query for the subroutine parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the shader subroutine uniform.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the parameter of the shader subroutine uniform to query. pname must be GL_NUM_COMPATIBLE_SUBROUTINES, GL_COMPATIBLE_SUBROUTINES, GL_UNIFORM_SIZE or GL_UNIFORM_NAME_LENGTH.
//        /// </para>
//        /// </param>
//        /// <param name="values">
//        /// <para>
//        /// Specifies the address of a into which the queried value or values will be placed.
//        /// </para>
//        /// </param>
//        public static
//        void GetActiveSubroutineUniform(Int32 program, MonoMac.OpenGL.ShaderType shadertype, Int32 index, MonoMac.OpenGL.ActiveSubroutineUniformParameter pname, [OutAttribute] out Int32 values)
//        {
//                unsafe
//                {
//                    fixed (Int32* values_ptr = &values)
//                    {
//                        Core.GetActiveSubroutineUniformiv((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (UInt32)index, (MonoMac.OpenGL.ActiveSubroutineUniformParameter)pname, (Int32*)values_ptr);
//                        values = *values_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Query a property of an active shader subroutine uniform
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing the subroutine.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query for the subroutine parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the shader subroutine uniform.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the parameter of the shader subroutine uniform to query. pname must be GL_NUM_COMPATIBLE_SUBROUTINES, GL_COMPATIBLE_SUBROUTINES, GL_UNIFORM_SIZE or GL_UNIFORM_NAME_LENGTH.
//        /// </para>
//        /// </param>
//        /// <param name="values">
//        /// <para>
//        /// Specifies the address of a into which the queried value or values will be placed.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetActiveSubroutineUniform(Int32 program, MonoMac.OpenGL.ShaderType shadertype, Int32 index, MonoMac.OpenGL.ActiveSubroutineUniformParameter pname, [OutAttribute] Int32* values)
//        {
//                Core.GetActiveSubroutineUniformiv((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (UInt32)index, (MonoMac.OpenGL.ActiveSubroutineUniformParameter)pname, (Int32*)values);
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Query a property of an active shader subroutine uniform
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing the subroutine.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query for the subroutine parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the shader subroutine uniform.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the parameter of the shader subroutine uniform to query. pname must be GL_NUM_COMPATIBLE_SUBROUTINES, GL_COMPATIBLE_SUBROUTINES, GL_UNIFORM_SIZE or GL_UNIFORM_NAME_LENGTH.
//        /// </para>
//        /// </param>
//        /// <param name="values">
//        /// <para>
//        /// Specifies the address of a into which the queried value or values will be placed.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetActiveSubroutineUniform(UInt32 program, MonoMac.OpenGL.ShaderType shadertype, UInt32 index, MonoMac.OpenGL.ActiveSubroutineUniformParameter pname, [OutAttribute] Int32[] values)
//        {
//                unsafe
//                {
//                    fixed (Int32* values_ptr = values)
//                    {
//                        Core.GetActiveSubroutineUniformiv((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (UInt32)index, (MonoMac.OpenGL.ActiveSubroutineUniformParameter)pname, (Int32*)values_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Query a property of an active shader subroutine uniform
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing the subroutine.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query for the subroutine parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the shader subroutine uniform.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the parameter of the shader subroutine uniform to query. pname must be GL_NUM_COMPATIBLE_SUBROUTINES, GL_COMPATIBLE_SUBROUTINES, GL_UNIFORM_SIZE or GL_UNIFORM_NAME_LENGTH.
//        /// </para>
//        /// </param>
//        /// <param name="values">
//        /// <para>
//        /// Specifies the address of a into which the queried value or values will be placed.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetActiveSubroutineUniform(UInt32 program, MonoMac.OpenGL.ShaderType shadertype, UInt32 index, MonoMac.OpenGL.ActiveSubroutineUniformParameter pname, [OutAttribute] out Int32 values)
//        {
//                unsafe
//                {
//                    fixed (Int32* values_ptr = &values)
//                    {
//                        Core.GetActiveSubroutineUniformiv((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (UInt32)index, (MonoMac.OpenGL.ActiveSubroutineUniformParameter)pname, (Int32*)values_ptr);
//                        values = *values_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Query a property of an active shader subroutine uniform
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing the subroutine.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query for the subroutine parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the shader subroutine uniform.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the parameter of the shader subroutine uniform to query. pname must be GL_NUM_COMPATIBLE_SUBROUTINES, GL_COMPATIBLE_SUBROUTINES, GL_UNIFORM_SIZE or GL_UNIFORM_NAME_LENGTH.
//        /// </para>
//        /// </param>
//        /// <param name="values">
//        /// <para>
//        /// Specifies the address of a into which the queried value or values will be placed.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetActiveSubroutineUniform(UInt32 program, MonoMac.OpenGL.ShaderType shadertype, UInt32 index, MonoMac.OpenGL.ActiveSubroutineUniformParameter pname, [OutAttribute] Int32* values)
//        {
//                Core.GetActiveSubroutineUniformiv((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (UInt32)index, (MonoMac.OpenGL.ActiveSubroutineUniformParameter)pname, (Int32*)values);
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Query the name of an active shader subroutine uniform
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing the subroutine.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query for the subroutine parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the shader subroutine uniform.
//        /// </para>
//        /// </param>
//        /// <param name="bufsize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given in name.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable into which is written the number of characters copied into name.
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// Specifies the address of a buffer that will receive the name of the specified shader subroutine uniform.
//        /// </para>
//        /// </param>
//        public static
//        void GetActiveSubroutineUniformName(Int32 program, MonoMac.OpenGL.ShaderType shadertype, Int32 index, Int32 bufsize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder name)
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    {
//                        Core.GetActiveSubroutineUniformName((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (UInt32)index, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)name);
//                        length = *length_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Query the name of an active shader subroutine uniform
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing the subroutine.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query for the subroutine parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the shader subroutine uniform.
//        /// </para>
//        /// </param>
//        /// <param name="bufsize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given in name.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable into which is written the number of characters copied into name.
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// Specifies the address of a buffer that will receive the name of the specified shader subroutine uniform.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetActiveSubroutineUniformName(Int32 program, MonoMac.OpenGL.ShaderType shadertype, Int32 index, Int32 bufsize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder name)
//        {
//                Core.GetActiveSubroutineUniformName((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (UInt32)index, (Int32)bufsize, (Int32*)length, (StringBuilder)name);
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Query the name of an active shader subroutine uniform
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing the subroutine.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query for the subroutine parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the shader subroutine uniform.
//        /// </para>
//        /// </param>
//        /// <param name="bufsize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given in name.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable into which is written the number of characters copied into name.
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// Specifies the address of a buffer that will receive the name of the specified shader subroutine uniform.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetActiveSubroutineUniformName(UInt32 program, MonoMac.OpenGL.ShaderType shadertype, UInt32 index, Int32 bufsize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder name)
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    {
//                        Core.GetActiveSubroutineUniformName((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (UInt32)index, (Int32)bufsize, (Int32*)length_ptr, (StringBuilder)name);
//                        length = *length_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Query the name of an active shader subroutine uniform
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing the subroutine.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query for the subroutine parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the shader subroutine uniform.
//        /// </para>
//        /// </param>
//        /// <param name="bufsize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given in name.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable into which is written the number of characters copied into name.
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// Specifies the address of a buffer that will receive the name of the specified shader subroutine uniform.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetActiveSubroutineUniformName(UInt32 program, MonoMac.OpenGL.ShaderType shadertype, UInt32 index, Int32 bufsize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder name)
//        {
//                Core.GetActiveSubroutineUniformName((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (UInt32)index, (Int32)bufsize, (Int32*)length, (StringBuilder)name);
//        }


        /// <summary>[requires: v2.0]
        /// Returns information about an active uniform variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the uniform variable.
        /// </para>
        /// </param>
        public static
        void GetActiveUniform(Int32 program, Int32 index, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out Int32 size, [OutAttribute] out MonoMac.OpenGL.ActiveUniformType type, [OutAttribute] StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (MonoMac.OpenGL.ActiveUniformType* type_ptr = &type)
                {
                    Core.GetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length_ptr, (Int32*)size_ptr, (MonoMac.OpenGL.ActiveUniformType*)type_ptr, (StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
        }


        /// <summary>[requires: v2.0]
        /// Returns information about an active uniform variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetActiveUniform(Int32 program, Int32 index, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] Int32* size, [OutAttribute] MonoMac.OpenGL.ActiveUniformType* type, [OutAttribute] StringBuilder name)
        {
            Core.GetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length, (Int32*)size, (MonoMac.OpenGL.ActiveUniformType*)type, (StringBuilder)name);
        }


        /// <summary>[requires: v2.0]
        /// Returns information about an active uniform variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GetActiveUniform(UInt32 program, UInt32 index, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out Int32 size, [OutAttribute] out MonoMac.OpenGL.ActiveUniformType type, [OutAttribute] StringBuilder name)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                fixed (Int32* size_ptr = &size)
                fixed (MonoMac.OpenGL.ActiveUniformType* type_ptr = &type)
                {
                    Core.GetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length_ptr, (Int32*)size_ptr, (MonoMac.OpenGL.ActiveUniformType*)type_ptr, (StringBuilder)name);
                    length = *length_ptr;
                    size = *size_ptr;
                    type = *type_ptr;
                }
            }
        }


        /// <summary>[requires: v2.0]
        /// Returns information about an active uniform variable for the specified program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="index">
        /// <para>
        /// Specifies the index of the uniform variable to be queried.
        /// </para>
        /// </param>
        /// <param name="bufSize">
        /// <para>
        /// Specifies the maximum number of characters OpenGL is allowed to write in the character buffer indicated by name.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the number of characters actually written by OpenGL in the string indicated by name (excluding the null terminator) if a value other than NULL is passed.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Returns the size of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Returns the data type of the uniform variable.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Returns a null terminated string containing the name of the uniform variable.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetActiveUniform(UInt32 program, UInt32 index, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] Int32* size, [OutAttribute] MonoMac.OpenGL.ActiveUniformType* type, [OutAttribute] StringBuilder name)
        {
            Core.GetActiveUniform((UInt32)program, (UInt32)index, (Int32)bufSize, (Int32*)length, (Int32*)size, (MonoMac.OpenGL.ActiveUniformType*)type, (StringBuilder)name);
        }


//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]
//        /// Query information about an active uniform block
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program containing the uniform block.
//        /// </para>
//        /// </param>
//        /// <param name="uniformBlockIndex">
//        /// <para>
//        /// Specifies the index of the uniform block within program.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the name of the parameter to query.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable to receive the result of the query.
//        /// </para>
//        /// </param>
//        public static
//        void GetActiveUniformBlock(Int32 program, Int32 uniformBlockIndex, MonoMac.OpenGL.ActiveUniformBlockParameter pname, [OutAttribute] Int32[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = @params)
//                    {
//                        Core.GetActiveUniformBlockiv((UInt32)program, (UInt32)uniformBlockIndex, (MonoMac.OpenGL.ActiveUniformBlockParameter)pname, (Int32*)@params_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]
//        /// Query information about an active uniform block
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program containing the uniform block.
//        /// </para>
//        /// </param>
//        /// <param name="uniformBlockIndex">
//        /// <para>
//        /// Specifies the index of the uniform block within program.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the name of the parameter to query.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable to receive the result of the query.
//        /// </para>
//        /// </param>
//        public static
//        void GetActiveUniformBlock(Int32 program, Int32 uniformBlockIndex, MonoMac.OpenGL.ActiveUniformBlockParameter pname, [OutAttribute] out Int32 @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = &@params)
//                    {
//                        Core.GetActiveUniformBlockiv((UInt32)program, (UInt32)uniformBlockIndex, (MonoMac.OpenGL.ActiveUniformBlockParameter)pname, (Int32*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]
//        /// Query information about an active uniform block
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program containing the uniform block.
//        /// </para>
//        /// </param>
//        /// <param name="uniformBlockIndex">
//        /// <para>
//        /// Specifies the index of the uniform block within program.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the name of the parameter to query.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable to receive the result of the query.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetActiveUniformBlock(Int32 program, Int32 uniformBlockIndex, MonoMac.OpenGL.ActiveUniformBlockParameter pname, [OutAttribute] Int32* @params)
//        {
//                Core.GetActiveUniformBlockiv((UInt32)program, (UInt32)uniformBlockIndex, (MonoMac.OpenGL.ActiveUniformBlockParameter)pname, (Int32*)@params);
//        }


//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]
//        /// Query information about an active uniform block
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program containing the uniform block.
//        /// </para>
//        /// </param>
//        /// <param name="uniformBlockIndex">
//        /// <para>
//        /// Specifies the index of the uniform block within program.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the name of the parameter to query.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable to receive the result of the query.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetActiveUniformBlock(UInt32 program, UInt32 uniformBlockIndex, MonoMac.OpenGL.ActiveUniformBlockParameter pname, [OutAttribute] Int32[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = @params)
//                    {
//                        Core.GetActiveUniformBlockiv((UInt32)program, (UInt32)uniformBlockIndex, (MonoMac.OpenGL.ActiveUniformBlockParameter)pname, (Int32*)@params_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]
//        /// Query information about an active uniform block
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program containing the uniform block.
//        /// </para>
//        /// </param>
//        /// <param name="uniformBlockIndex">
//        /// <para>
//        /// Specifies the index of the uniform block within program.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the name of the parameter to query.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable to receive the result of the query.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetActiveUniformBlock(UInt32 program, UInt32 uniformBlockIndex, MonoMac.OpenGL.ActiveUniformBlockParameter pname, [OutAttribute] out Int32 @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = &@params)
//                    {
//                        Core.GetActiveUniformBlockiv((UInt32)program, (UInt32)uniformBlockIndex, (MonoMac.OpenGL.ActiveUniformBlockParameter)pname, (Int32*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]
//        /// Query information about an active uniform block
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program containing the uniform block.
//        /// </para>
//        /// </param>
//        /// <param name="uniformBlockIndex">
//        /// <para>
//        /// Specifies the index of the uniform block within program.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the name of the parameter to query.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable to receive the result of the query.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetActiveUniformBlock(UInt32 program, UInt32 uniformBlockIndex, MonoMac.OpenGL.ActiveUniformBlockParameter pname, [OutAttribute] Int32* @params)
//        {
//                Core.GetActiveUniformBlockiv((UInt32)program, (UInt32)uniformBlockIndex, (MonoMac.OpenGL.ActiveUniformBlockParameter)pname, (Int32*)@params);
//        }


//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]
//        /// Retrieve the name of an active uniform block
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program containing the uniform block.
//        /// </para>
//        /// </param>
//        /// <param name="uniformBlockIndex">
//        /// <para>
//        /// Specifies the index of the uniform block within program.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer addressed by uniformBlockName.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of characters that were written to uniformBlockName.
//        /// </para>
//        /// </param>
//        /// <param name="uniformBlockName">
//        /// <para>
//        /// Specifies the address an array of characters to receive the name of the uniform block at uniformBlockIndex.
//        /// </para>
//        /// </param>
//        public static
//        void GetActiveUniformBlockName(Int32 program, Int32 uniformBlockIndex, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder uniformBlockName)
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    {
//                        Core.GetActiveUniformBlockName((UInt32)program, (UInt32)uniformBlockIndex, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)uniformBlockName);
//                        length = *length_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]
//        /// Retrieve the name of an active uniform block
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program containing the uniform block.
//        /// </para>
//        /// </param>
//        /// <param name="uniformBlockIndex">
//        /// <para>
//        /// Specifies the index of the uniform block within program.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer addressed by uniformBlockName.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of characters that were written to uniformBlockName.
//        /// </para>
//        /// </param>
//        /// <param name="uniformBlockName">
//        /// <para>
//        /// Specifies the address an array of characters to receive the name of the uniform block at uniformBlockIndex.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetActiveUniformBlockName(Int32 program, Int32 uniformBlockIndex, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder uniformBlockName)
//        {
//                Core.GetActiveUniformBlockName((UInt32)program, (UInt32)uniformBlockIndex, (Int32)bufSize, (Int32*)length, (StringBuilder)uniformBlockName);
//        }


//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]
//        /// Retrieve the name of an active uniform block
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program containing the uniform block.
//        /// </para>
//        /// </param>
//        /// <param name="uniformBlockIndex">
//        /// <para>
//        /// Specifies the index of the uniform block within program.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer addressed by uniformBlockName.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of characters that were written to uniformBlockName.
//        /// </para>
//        /// </param>
//        /// <param name="uniformBlockName">
//        /// <para>
//        /// Specifies the address an array of characters to receive the name of the uniform block at uniformBlockIndex.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetActiveUniformBlockName(UInt32 program, UInt32 uniformBlockIndex, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder uniformBlockName)
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    {
//                        Core.GetActiveUniformBlockName((UInt32)program, (UInt32)uniformBlockIndex, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)uniformBlockName);
//                        length = *length_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]
//        /// Retrieve the name of an active uniform block
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program containing the uniform block.
//        /// </para>
//        /// </param>
//        /// <param name="uniformBlockIndex">
//        /// <para>
//        /// Specifies the index of the uniform block within program.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer addressed by uniformBlockName.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of characters that were written to uniformBlockName.
//        /// </para>
//        /// </param>
//        /// <param name="uniformBlockName">
//        /// <para>
//        /// Specifies the address an array of characters to receive the name of the uniform block at uniformBlockIndex.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetActiveUniformBlockName(UInt32 program, UInt32 uniformBlockIndex, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder uniformBlockName)
//        {
//                Core.GetActiveUniformBlockName((UInt32)program, (UInt32)uniformBlockIndex, (Int32)bufSize, (Int32*)length, (StringBuilder)uniformBlockName);
//        }


//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]
//        /// Query the name of an active uniform
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the program containing the active uniform index uniformIndex.
//        /// </para>
//        /// </param>
//        /// <param name="uniformIndex">
//        /// <para>
//        /// Specifies the index of the active uniform whose name to query.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer, in units of GLchar, of the buffer whose address is specified in uniformName.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable that will receive the number of characters that were or would have been written to the buffer addressed by uniformName.
//        /// </para>
//        /// </param>
//        /// <param name="uniformName">
//        /// <para>
//        /// Specifies the address of a buffer into which the GL will place the name of the active uniform at uniformIndex within program.
//        /// </para>
//        /// </param>
//        public static
//        void GetActiveUniformName(Int32 program, Int32 uniformIndex, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder uniformName)
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    {
//                        Core.GetActiveUniformName((UInt32)program, (UInt32)uniformIndex, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)uniformName);
//                        length = *length_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]
//        /// Query the name of an active uniform
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the program containing the active uniform index uniformIndex.
//        /// </para>
//        /// </param>
//        /// <param name="uniformIndex">
//        /// <para>
//        /// Specifies the index of the active uniform whose name to query.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer, in units of GLchar, of the buffer whose address is specified in uniformName.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable that will receive the number of characters that were or would have been written to the buffer addressed by uniformName.
//        /// </para>
//        /// </param>
//        /// <param name="uniformName">
//        /// <para>
//        /// Specifies the address of a buffer into which the GL will place the name of the active uniform at uniformIndex within program.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetActiveUniformName(Int32 program, Int32 uniformIndex, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder uniformName)
//        {
//                Core.GetActiveUniformName((UInt32)program, (UInt32)uniformIndex, (Int32)bufSize, (Int32*)length, (StringBuilder)uniformName);
//        }


//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]
//        /// Query the name of an active uniform
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the program containing the active uniform index uniformIndex.
//        /// </para>
//        /// </param>
//        /// <param name="uniformIndex">
//        /// <para>
//        /// Specifies the index of the active uniform whose name to query.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer, in units of GLchar, of the buffer whose address is specified in uniformName.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable that will receive the number of characters that were or would have been written to the buffer addressed by uniformName.
//        /// </para>
//        /// </param>
//        /// <param name="uniformName">
//        /// <para>
//        /// Specifies the address of a buffer into which the GL will place the name of the active uniform at uniformIndex within program.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetActiveUniformName(UInt32 program, UInt32 uniformIndex, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder uniformName)
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    {
//                        Core.GetActiveUniformName((UInt32)program, (UInt32)uniformIndex, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)uniformName);
//                        length = *length_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]
//        /// Query the name of an active uniform
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the program containing the active uniform index uniformIndex.
//        /// </para>
//        /// </param>
//        /// <param name="uniformIndex">
//        /// <para>
//        /// Specifies the index of the active uniform whose name to query.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer, in units of GLchar, of the buffer whose address is specified in uniformName.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable that will receive the number of characters that were or would have been written to the buffer addressed by uniformName.
//        /// </para>
//        /// </param>
//        /// <param name="uniformName">
//        /// <para>
//        /// Specifies the address of a buffer into which the GL will place the name of the active uniform at uniformIndex within program.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetActiveUniformName(UInt32 program, UInt32 uniformIndex, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder uniformName)
//        {
//                Core.GetActiveUniformName((UInt32)program, (UInt32)uniformIndex, (Int32)bufSize, (Int32*)length, (StringBuilder)uniformName);
//        }

//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]</summary>
//        public static
//        void GetActiveUniforms(Int32 program, Int32 uniformCount, Int32[] uniformIndices, MonoMac.OpenGL.ActiveUniformParameter pname, [OutAttribute] Int32[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* uniformIndices_ptr = uniformIndices)
//                    fixed (Int32* @params_ptr = @params)
//                    {
//                        Core.GetActiveUniformsiv((UInt32)program, (Int32)uniformCount, (UInt32*)uniformIndices_ptr, (MonoMac.OpenGL.ActiveUniformParameter)pname, (Int32*)@params_ptr);
//                    }
//                }
//        }

//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]</summary>
//        public static
//        void GetActiveUniforms(Int32 program, Int32 uniformCount, ref Int32 uniformIndices, MonoMac.OpenGL.ActiveUniformParameter pname, [OutAttribute] out Int32 @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* uniformIndices_ptr = &uniformIndices)
//                    fixed (Int32* @params_ptr = &@params)
//                    {
//                        Core.GetActiveUniformsiv((UInt32)program, (Int32)uniformCount, (UInt32*)uniformIndices_ptr, (MonoMac.OpenGL.ActiveUniformParameter)pname, (Int32*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }

//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetActiveUniforms(Int32 program, Int32 uniformCount, Int32* uniformIndices, MonoMac.OpenGL.ActiveUniformParameter pname, [OutAttribute] Int32* @params)
//        {
//                Core.GetActiveUniformsiv((UInt32)program, (Int32)uniformCount, (UInt32*)uniformIndices, (MonoMac.OpenGL.ActiveUniformParameter)pname, (Int32*)@params);
//        }

//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void GetActiveUniforms(UInt32 program, Int32 uniformCount, UInt32[] uniformIndices, MonoMac.OpenGL.ActiveUniformParameter pname, [OutAttribute] Int32[] @params)
//        {
//                unsafe
//                {
//                    fixed (UInt32* uniformIndices_ptr = uniformIndices)
//                    fixed (Int32* @params_ptr = @params)
//                    {
//                        Core.GetActiveUniformsiv((UInt32)program, (Int32)uniformCount, (UInt32*)uniformIndices_ptr, (MonoMac.OpenGL.ActiveUniformParameter)pname, (Int32*)@params_ptr);
//                    }
//                }
//        }

//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void GetActiveUniforms(UInt32 program, Int32 uniformCount, ref UInt32 uniformIndices, MonoMac.OpenGL.ActiveUniformParameter pname, [OutAttribute] out Int32 @params)
//        {
//                unsafe
//                {
//                    fixed (UInt32* uniformIndices_ptr = &uniformIndices)
//                    fixed (Int32* @params_ptr = &@params)
//                    {
//                        Core.GetActiveUniformsiv((UInt32)program, (Int32)uniformCount, (UInt32*)uniformIndices_ptr, (MonoMac.OpenGL.ActiveUniformParameter)pname, (Int32*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }

//        /// <summary>[requires: v2.0 and ARB_uniform_buffer_object]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetActiveUniforms(UInt32 program, Int32 uniformCount, UInt32* uniformIndices, MonoMac.OpenGL.ActiveUniformParameter pname, [OutAttribute] Int32* @params)
//        {
//                Core.GetActiveUniformsiv((UInt32)program, (Int32)uniformCount, (UInt32*)uniformIndices, (MonoMac.OpenGL.ActiveUniformParameter)pname, (Int32*)@params);
//        }


        /// <summary>[requires: v2.0]
        /// Returns the handles of the shader objects attached to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="maxCount">
        /// <para>
        /// Specifies the size of the array for storing the returned object names.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Returns the number of names actually returned in objects.
        /// </para>
        /// </param>
        /// <param name="shaders">
        /// <para>
        /// Specifies an array that is used to return the names of attached shader objects.
        /// </para>
        /// </param>
        public static
        void GetAttachedShaders(Int32 program, Int32 maxCount, [OutAttribute] out Int32 count, [OutAttribute] out Int32 obj)
        {
            unsafe
            {
                fixed (Int32* count_ptr = &count)
                fixed (Int32* obj_ptr = &obj)
                {
                    Core.GetAttachedShaders((UInt32)program, (Int32)maxCount, (Int32*)count_ptr, (UInt32*)obj_ptr);
                    count = *count_ptr;
                    obj = *obj_ptr;
                }
            }
        }


        /// <summary>[requires: v2.0]
        /// Returns the handles of the shader objects attached to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="maxCount">
        /// <para>
        /// Specifies the size of the array for storing the returned object names.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Returns the number of names actually returned in objects.
        /// </para>
        /// </param>
        /// <param name="shaders">
        /// <para>
        /// Specifies an array that is used to return the names of attached shader objects.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetAttachedShaders(Int32 program, Int32 maxCount, [OutAttribute] Int32* count, [OutAttribute] Int32[] obj)
        {
            fixed (Int32* obj_ptr = obj)
            {
                Core.GetAttachedShaders((UInt32)program, (Int32)maxCount, (Int32*)count, (UInt32*)obj_ptr);
            }
        }


        /// <summary>[requires: v2.0]
        /// Returns the handles of the shader objects attached to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="maxCount">
        /// <para>
        /// Specifies the size of the array for storing the returned object names.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Returns the number of names actually returned in objects.
        /// </para>
        /// </param>
        /// <param name="shaders">
        /// <para>
        /// Specifies an array that is used to return the names of attached shader objects.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetAttachedShaders(Int32 program, Int32 maxCount, [OutAttribute] Int32* count, [OutAttribute] Int32* obj)
        {
            Core.GetAttachedShaders((UInt32)program, (Int32)maxCount, (Int32*)count, (UInt32*)obj);
        }


        /// <summary>[requires: v2.0]
        /// Returns the handles of the shader objects attached to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="maxCount">
        /// <para>
        /// Specifies the size of the array for storing the returned object names.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Returns the number of names actually returned in objects.
        /// </para>
        /// </param>
        /// <param name="shaders">
        /// <para>
        /// Specifies an array that is used to return the names of attached shader objects.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GetAttachedShaders(UInt32 program, Int32 maxCount, [OutAttribute] out Int32 count, [OutAttribute] out UInt32 obj)
        {
            unsafe
            {
                fixed (Int32* count_ptr = &count)
                fixed (UInt32* obj_ptr = &obj)
                {
                    Core.GetAttachedShaders((UInt32)program, (Int32)maxCount, (Int32*)count_ptr, (UInt32*)obj_ptr);
                    count = *count_ptr;
                    obj = *obj_ptr;
                }
            }
        }


        /// <summary>[requires: v2.0]
        /// Returns the handles of the shader objects attached to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="maxCount">
        /// <para>
        /// Specifies the size of the array for storing the returned object names.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Returns the number of names actually returned in objects.
        /// </para>
        /// </param>
        /// <param name="shaders">
        /// <para>
        /// Specifies an array that is used to return the names of attached shader objects.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetAttachedShaders(UInt32 program, Int32 maxCount, [OutAttribute] Int32* count, [OutAttribute] UInt32[] obj)
        {
            fixed (UInt32* obj_ptr = obj)
            {
                Core.GetAttachedShaders((UInt32)program, (Int32)maxCount, (Int32*)count, (UInt32*)obj_ptr);
            }
        }


        /// <summary>[requires: v2.0]
        /// Returns the handles of the shader objects attached to a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="maxCount">
        /// <para>
        /// Specifies the size of the array for storing the returned object names.
        /// </para>
        /// </param>
        /// <param name="count">
        /// <para>
        /// Returns the number of names actually returned in objects.
        /// </para>
        /// </param>
        /// <param name="shaders">
        /// <para>
        /// Specifies an array that is used to return the names of attached shader objects.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetAttachedShaders(UInt32 program, Int32 maxCount, [OutAttribute] Int32* count, [OutAttribute] UInt32* obj)
        {
            Core.GetAttachedShaders((UInt32)program, (Int32)maxCount, (Int32*)count, (UInt32*)obj);
        }


        /// <summary>[requires: v2.0]
        /// Returns the location of an attribute variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Points to a null terminated string containing the name of the attribute variable whose location is to be queried.
        /// </para>
        /// </param>
        public static
        Int32 GetAttribLocation(Int32 program, String name)
        {
            return Core.GetAttribLocation((UInt32)program, (String)name);
        }


        /// <summary>[requires: v2.0]
        /// Returns the location of an attribute variable
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="name">
        /// <para>
        /// Points to a null terminated string containing the name of the attribute variable whose location is to be queried.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        Int32 GetAttribLocation(UInt32 program, String name)
        {
            return Core.GetAttribLocation((UInt32)program, (String)name);
        }

        /// <summary>[requires: v3.0]</summary>
        public static
        void GetBoolean(MonoMac.OpenGL.GetIndexedPName target, Int32 index, [OutAttribute] bool[] data)
        {
            unsafe
            {
                fixed (bool* data_ptr = data)
                {
                    Core.GetBooleani_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (bool*)data_ptr);
                }
            }
        }

        /// <summary>[requires: v3.0]</summary>
        public static
        void GetBoolean(MonoMac.OpenGL.GetIndexedPName target, Int32 index, [OutAttribute] out bool data)
        {
            unsafe
            {
                fixed (bool* data_ptr = &data)
                {
                    Core.GetBooleani_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (bool*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        /// <summary>[requires: v3.0]</summary>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetBoolean(MonoMac.OpenGL.GetIndexedPName target, Int32 index, [OutAttribute] bool* data)
        {
            Core.GetBooleani_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (bool*)data);
        }

        /// <summary>[requires: v3.0]</summary>
        [System.CLSCompliant(false)]
        public static
        void GetBoolean(MonoMac.OpenGL.GetIndexedPName target, UInt32 index, [OutAttribute] bool[] data)
        {
            unsafe
            {
                fixed (bool* data_ptr = data)
                {
                    Core.GetBooleani_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (bool*)data_ptr);
                }
            }
        }

        /// <summary>[requires: v3.0]</summary>
        [System.CLSCompliant(false)]
        public static
        void GetBoolean(MonoMac.OpenGL.GetIndexedPName target, UInt32 index, [OutAttribute] out bool data)
        {
            unsafe
            {
                fixed (bool* data_ptr = &data)
                {
                    Core.GetBooleani_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (bool*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        /// <summary>[requires: v3.0]</summary>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetBoolean(MonoMac.OpenGL.GetIndexedPName target, UInt32 index, [OutAttribute] bool* data)
        {
            Core.GetBooleani_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (bool*)data);
        }

        /// <summary>[requires: v1.0]</summary>
        public static
        void GetBoolean(MonoMac.OpenGL.GetPName pname, [OutAttribute] bool[] @params)
        {
            unsafe
            {
                fixed (bool* @params_ptr = @params)
                {
                    Core.GetBooleanv((MonoMac.OpenGL.GetPName)pname, (bool*)@params_ptr);
                }
            }
        }

        /// <summary>[requires: v1.0]</summary>
        public static
        void GetBoolean(MonoMac.OpenGL.GetPName pname, [OutAttribute] out bool @params)
        {
            unsafe
            {
                fixed (bool* @params_ptr = &@params)
                {
                    Core.GetBooleanv((MonoMac.OpenGL.GetPName)pname, (bool*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        /// <summary>[requires: v1.0]</summary>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetBoolean(MonoMac.OpenGL.GetPName pname, [OutAttribute] bool* @params)
        {
            Core.GetBooleanv((MonoMac.OpenGL.GetPName)pname, (bool*)@params);
        }

//        /// <summary>[requires: v3.2]</summary>
//        public static
//        void GetBufferParameteri64(MonoMac.OpenGL.Version32 target, MonoMac.OpenGL.Version32 pname, [OutAttribute] Int64[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int64* @params_ptr = @params)
//                    {
//                        Core.GetBufferParameteri64v((MonoMac.OpenGL.Version32)target, (MonoMac.OpenGL.Version32)pname, (Int64*)@params_ptr);
//                    }
//                }
//        }

//        /// <summary>[requires: v3.2]</summary>
//        public static
//        void GetBufferParameteri64(MonoMac.OpenGL.Version32 target, MonoMac.OpenGL.Version32 pname, [OutAttribute] out Int64 @params)
//        {
//                unsafe
//                {
//                    fixed (Int64* @params_ptr = &@params)
//                    {
//                        Core.GetBufferParameteri64v((MonoMac.OpenGL.Version32)target, (MonoMac.OpenGL.Version32)pname, (Int64*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }

//        /// <summary>[requires: v3.2]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetBufferParameteri64(MonoMac.OpenGL.Version32 target, MonoMac.OpenGL.Version32 pname, [OutAttribute] Int64* @params)
//        {
//                Core.GetBufferParameteri64v((MonoMac.OpenGL.Version32)target, (MonoMac.OpenGL.Version32)pname, (Int64*)@params);
//        }


        /// <summary>[requires: v1.5]
        /// Return parameters of a buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="value">
        /// <para>
        /// Specifies the symbolic name of a buffer object parameter. Accepted values are GL_BUFFER_ACCESS, GL_BUFFER_MAPPED, GL_BUFFER_SIZE, or GL_BUFFER_USAGE.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the requested parameter.
        /// </para>
        /// </param>
        public static
        void GetBufferParameter(MonoMac.OpenGL.BufferTarget target, MonoMac.OpenGL.BufferParameterName pname, [OutAttribute] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Core.GetBufferParameteriv((MonoMac.OpenGL.BufferTarget)target, (MonoMac.OpenGL.BufferParameterName)pname, (Int32*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Return parameters of a buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="value">
        /// <para>
        /// Specifies the symbolic name of a buffer object parameter. Accepted values are GL_BUFFER_ACCESS, GL_BUFFER_MAPPED, GL_BUFFER_SIZE, or GL_BUFFER_USAGE.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the requested parameter.
        /// </para>
        /// </param>
        public static
        void GetBufferParameter(MonoMac.OpenGL.BufferTarget target, MonoMac.OpenGL.BufferParameterName pname, [OutAttribute] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Core.GetBufferParameteriv((MonoMac.OpenGL.BufferTarget)target, (MonoMac.OpenGL.BufferParameterName)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v1.5]
        /// Return parameters of a buffer object
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, or GL_PIXEL_UNPACK_BUFFER.
        /// </para>
        /// </param>
        /// <param name="value">
        /// <para>
        /// Specifies the symbolic name of a buffer object parameter. Accepted values are GL_BUFFER_ACCESS, GL_BUFFER_MAPPED, GL_BUFFER_SIZE, or GL_BUFFER_USAGE.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the requested parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetBufferParameter(MonoMac.OpenGL.BufferTarget target, MonoMac.OpenGL.BufferParameterName pname, [OutAttribute] Int32* @params)
        {
            Core.GetBufferParameteriv((MonoMac.OpenGL.BufferTarget)target, (MonoMac.OpenGL.BufferParameterName)pname, (Int32*)@params);
        }


        /// <summary>[requires: v1.5]
        /// Return the pointer to a mapped buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the pointer to be returned. The symbolic constant must be GL_BUFFER_MAP_POINTER.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        public static
        void GetBufferPointer(MonoMac.OpenGL.BufferTarget target, MonoMac.OpenGL.BufferPointer pname, [OutAttribute] IntPtr @params)
        {
            Core.GetBufferPointerv((MonoMac.OpenGL.BufferTarget)target, (MonoMac.OpenGL.BufferPointer)pname, (IntPtr)@params);
        }


        /// <summary>[requires: v1.5]
        /// Return the pointer to a mapped buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the pointer to be returned. The symbolic constant must be GL_BUFFER_MAP_POINTER.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        public static
        void GetBufferPointer<T2>(MonoMac.OpenGL.BufferTarget target, MonoMac.OpenGL.BufferPointer pname, [InAttribute, OutAttribute] T2[] @params)
            where T2 : struct
        {
            GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
            try
            {
                Core.GetBufferPointerv((MonoMac.OpenGL.BufferTarget)target, (MonoMac.OpenGL.BufferPointer)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
            }
            finally
            {
                @params_ptr.Free();
            }
        }


        /// <summary>[requires: v1.5]
        /// Return the pointer to a mapped buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the pointer to be returned. The symbolic constant must be GL_BUFFER_MAP_POINTER.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        public static
        void GetBufferPointer<T2>(MonoMac.OpenGL.BufferTarget target, MonoMac.OpenGL.BufferPointer pname, [InAttribute, OutAttribute] T2[,] @params)
            where T2 : struct
        {
            GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
            try
            {
                Core.GetBufferPointerv((MonoMac.OpenGL.BufferTarget)target, (MonoMac.OpenGL.BufferPointer)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
            }
            finally
            {
                @params_ptr.Free();
            }
        }


        /// <summary>[requires: v1.5]
        /// Return the pointer to a mapped buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the pointer to be returned. The symbolic constant must be GL_BUFFER_MAP_POINTER.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        public static
        void GetBufferPointer<T2>(MonoMac.OpenGL.BufferTarget target, MonoMac.OpenGL.BufferPointer pname, [InAttribute, OutAttribute] T2[, ,] @params)
            where T2 : struct
        {
            GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
            try
            {
                Core.GetBufferPointerv((MonoMac.OpenGL.BufferTarget)target, (MonoMac.OpenGL.BufferPointer)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
            }
            finally
            {
                @params_ptr.Free();
            }
        }


        /// <summary>[requires: v1.5]
        /// Return the pointer to a mapped buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the pointer to be returned. The symbolic constant must be GL_BUFFER_MAP_POINTER.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        public static
        void GetBufferPointer<T2>(MonoMac.OpenGL.BufferTarget target, MonoMac.OpenGL.BufferPointer pname, [InAttribute, OutAttribute] ref T2 @params)
            where T2 : struct
        {
            GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
            try
            {
                Core.GetBufferPointerv((MonoMac.OpenGL.BufferTarget)target, (MonoMac.OpenGL.BufferPointer)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                @params = (T2)@params_ptr.Target;
            }
            finally
            {
                @params_ptr.Free();
            }
        }


        /// <summary>[requires: v1.5]
        /// Returns a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store from which data will be returned, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being returned.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the location where buffer object data is returned.
        /// </para>
        /// </param>
        public static
        void GetBufferSubData(MonoMac.OpenGL.BufferTarget target, IntPtr offset, IntPtr size, [OutAttribute] IntPtr data)
        {
            Core.GetBufferSubData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data);
        }


        /// <summary>[requires: v1.5]
        /// Returns a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store from which data will be returned, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being returned.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the location where buffer object data is returned.
        /// </para>
        /// </param>
        public static
        void GetBufferSubData<T3>(MonoMac.OpenGL.BufferTarget target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[] data)
            where T3 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.GetBufferSubData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.5]
        /// Returns a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store from which data will be returned, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being returned.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the location where buffer object data is returned.
        /// </para>
        /// </param>
        public static
        void GetBufferSubData<T3>(MonoMac.OpenGL.BufferTarget target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[,] data)
            where T3 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.GetBufferSubData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.5]
        /// Returns a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store from which data will be returned, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being returned.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the location where buffer object data is returned.
        /// </para>
        /// </param>
        public static
        void GetBufferSubData<T3>(MonoMac.OpenGL.BufferTarget target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] T3[, ,] data)
            where T3 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.GetBufferSubData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.5]
        /// Returns a subset of a buffer object's data store
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the target buffer object. The symbolic constant must be GL_ARRAY_BUFFER, GL_COPY_READ_BUFFER, GL_COPY_WRITE_BUFFER, GL_ELEMENT_ARRAY_BUFFER, GL_PIXEL_PACK_BUFFER, GL_PIXEL_UNPACK_BUFFER, GL_TEXTURE_BUFFER, GL_TRANSFORM_FEEDBACK_BUFFER, or GL_UNIFORM_BUFFER.
        /// </para>
        /// </param>
        /// <param name="offset">
        /// <para>
        /// Specifies the offset into the buffer object's data store from which data will be returned, measured in bytes.
        /// </para>
        /// </param>
        /// <param name="size">
        /// <para>
        /// Specifies the size in bytes of the data store region being returned.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Specifies a pointer to the location where buffer object data is returned.
        /// </para>
        /// </param>
        public static
        void GetBufferSubData<T3>(MonoMac.OpenGL.BufferTarget target, IntPtr offset, IntPtr size, [InAttribute, OutAttribute] ref T3 data)
            where T3 : struct
        {
            GCHandle data_ptr = GCHandle.Alloc(data, GCHandleType.Pinned);
            try
            {
                Core.GetBufferSubData((MonoMac.OpenGL.BufferTarget)target, (IntPtr)offset, (IntPtr)size, (IntPtr)data_ptr.AddrOfPinnedObject());
                data = (T3)data_ptr.Target;
            }
            finally
            {
                data_ptr.Free();
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the coefficients of the specified clipping plane
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies a clipping plane. The number of clipping planes depends on the implementation, but at least six clipping planes are supported. They are identified by symbolic names of the form GL_CLIP_PLANE where i ranges from 0 to the value of GL_MAX_CLIP_PLANES - 1.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Returns four double-precision values that are the coefficients of the plane equation of plane in eye coordinates. The initial value is (0, 0, 0, 0).
        /// </para>
        /// </param>
        public static
        void GetClipPlane(MonoMac.OpenGL.ClipPlaneName plane, [OutAttribute] Double[] equation)
        {
            unsafe
            {
                fixed (Double* equation_ptr = equation)
                {
                    Core.GetClipPlane((MonoMac.OpenGL.ClipPlaneName)plane, (Double*)equation_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the coefficients of the specified clipping plane
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies a clipping plane. The number of clipping planes depends on the implementation, but at least six clipping planes are supported. They are identified by symbolic names of the form GL_CLIP_PLANE where i ranges from 0 to the value of GL_MAX_CLIP_PLANES - 1.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Returns four double-precision values that are the coefficients of the plane equation of plane in eye coordinates. The initial value is (0, 0, 0, 0).
        /// </para>
        /// </param>
        public static
        void GetClipPlane(MonoMac.OpenGL.ClipPlaneName plane, [OutAttribute] out Double equation)
        {
            unsafe
            {
                fixed (Double* equation_ptr = &equation)
                {
                    Core.GetClipPlane((MonoMac.OpenGL.ClipPlaneName)plane, (Double*)equation_ptr);
                    equation = *equation_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the coefficients of the specified clipping plane
        /// </summary>
        /// <param name="plane">
        /// <para>
        /// Specifies a clipping plane. The number of clipping planes depends on the implementation, but at least six clipping planes are supported. They are identified by symbolic names of the form GL_CLIP_PLANE where i ranges from 0 to the value of GL_MAX_CLIP_PLANES - 1.
        /// </para>
        /// </param>
        /// <param name="equation">
        /// <para>
        /// Returns four double-precision values that are the coefficients of the plane equation of plane in eye coordinates. The initial value is (0, 0, 0, 0).
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetClipPlane(MonoMac.OpenGL.ClipPlaneName plane, [OutAttribute] Double* equation)
        {
            Core.GetClipPlane((MonoMac.OpenGL.ClipPlaneName)plane, (Double*)equation);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Retrieve contents of a color lookup table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in table. The possible values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in table. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="table">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data containing the contents of the color table.
        /// </para>
        /// </param>
        public static
        void GetColorTable(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [OutAttribute] IntPtr table)
        {
            Core.GetColorTable((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)table);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Retrieve contents of a color lookup table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in table. The possible values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in table. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="table">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data containing the contents of the color table.
        /// </para>
        /// </param>
        public static
        void GetColorTable<T3>(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T3[] table)
            where T3 : struct
        {
            GCHandle table_ptr = GCHandle.Alloc(table, GCHandleType.Pinned);
            try
            {
                Core.GetColorTable((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)table_ptr.AddrOfPinnedObject());
            }
            finally
            {
                table_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Retrieve contents of a color lookup table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in table. The possible values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in table. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="table">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data containing the contents of the color table.
        /// </para>
        /// </param>
        public static
        void GetColorTable<T3>(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T3[,] table)
            where T3 : struct
        {
            GCHandle table_ptr = GCHandle.Alloc(table, GCHandleType.Pinned);
            try
            {
                Core.GetColorTable((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)table_ptr.AddrOfPinnedObject());
            }
            finally
            {
                table_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Retrieve contents of a color lookup table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in table. The possible values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in table. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="table">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data containing the contents of the color table.
        /// </para>
        /// </param>
        public static
        void GetColorTable<T3>(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T3[, ,] table)
            where T3 : struct
        {
            GCHandle table_ptr = GCHandle.Alloc(table, GCHandleType.Pinned);
            try
            {
                Core.GetColorTable((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)table_ptr.AddrOfPinnedObject());
            }
            finally
            {
                table_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Retrieve contents of a color lookup table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, or GL_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the pixel data in table. The possible values are GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, GL_RGB, GL_BGR, GL_RGBA, and GL_BGRA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of the pixel data in table. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="table">
        /// <para>
        /// Pointer to a one-dimensional array of pixel data containing the contents of the color table.
        /// </para>
        /// </param>
        public static
        void GetColorTable<T3>(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] ref T3 table)
            where T3 : struct
        {
            GCHandle table_ptr = GCHandle.Alloc(table, GCHandleType.Pinned);
            try
            {
                Core.GetColorTable((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)table_ptr.AddrOfPinnedObject());
                table = (T3)table_ptr.Target;
            }
            finally
            {
                table_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get color lookup table parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target color table. Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, GL_POST_COLOR_MATRIX_COLOR_TABLE, GL_PROXY_COLOR_TABLE, GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, or GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The symbolic name of a color lookup table parameter. Must be one of GL_COLOR_TABLE_BIAS, GL_COLOR_TABLE_SCALE, GL_COLOR_TABLE_FORMAT, GL_COLOR_TABLE_WIDTH, GL_COLOR_TABLE_RED_SIZE, GL_COLOR_TABLE_GREEN_SIZE, GL_COLOR_TABLE_BLUE_SIZE, GL_COLOR_TABLE_ALPHA_SIZE, GL_COLOR_TABLE_LUMINANCE_SIZE, or GL_COLOR_TABLE_INTENSITY_SIZE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to an array where the values of the parameter will be stored.
        /// </para>
        /// </param>
        public static
        void GetColorTableParameter(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.GetColorTableParameterPName pname, [OutAttribute] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Core.GetColorTableParameterfv((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.GetColorTableParameterPName)pname, (Single*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get color lookup table parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target color table. Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, GL_POST_COLOR_MATRIX_COLOR_TABLE, GL_PROXY_COLOR_TABLE, GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, or GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The symbolic name of a color lookup table parameter. Must be one of GL_COLOR_TABLE_BIAS, GL_COLOR_TABLE_SCALE, GL_COLOR_TABLE_FORMAT, GL_COLOR_TABLE_WIDTH, GL_COLOR_TABLE_RED_SIZE, GL_COLOR_TABLE_GREEN_SIZE, GL_COLOR_TABLE_BLUE_SIZE, GL_COLOR_TABLE_ALPHA_SIZE, GL_COLOR_TABLE_LUMINANCE_SIZE, or GL_COLOR_TABLE_INTENSITY_SIZE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to an array where the values of the parameter will be stored.
        /// </para>
        /// </param>
        public static
        void GetColorTableParameter(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.GetColorTableParameterPName pname, [OutAttribute] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Core.GetColorTableParameterfv((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.GetColorTableParameterPName)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get color lookup table parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target color table. Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, GL_POST_COLOR_MATRIX_COLOR_TABLE, GL_PROXY_COLOR_TABLE, GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, or GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The symbolic name of a color lookup table parameter. Must be one of GL_COLOR_TABLE_BIAS, GL_COLOR_TABLE_SCALE, GL_COLOR_TABLE_FORMAT, GL_COLOR_TABLE_WIDTH, GL_COLOR_TABLE_RED_SIZE, GL_COLOR_TABLE_GREEN_SIZE, GL_COLOR_TABLE_BLUE_SIZE, GL_COLOR_TABLE_ALPHA_SIZE, GL_COLOR_TABLE_LUMINANCE_SIZE, or GL_COLOR_TABLE_INTENSITY_SIZE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to an array where the values of the parameter will be stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetColorTableParameter(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.GetColorTableParameterPName pname, [OutAttribute] Single* @params)
        {
            Core.GetColorTableParameterfv((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.GetColorTableParameterPName)pname, (Single*)@params);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get color lookup table parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target color table. Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, GL_POST_COLOR_MATRIX_COLOR_TABLE, GL_PROXY_COLOR_TABLE, GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, or GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The symbolic name of a color lookup table parameter. Must be one of GL_COLOR_TABLE_BIAS, GL_COLOR_TABLE_SCALE, GL_COLOR_TABLE_FORMAT, GL_COLOR_TABLE_WIDTH, GL_COLOR_TABLE_RED_SIZE, GL_COLOR_TABLE_GREEN_SIZE, GL_COLOR_TABLE_BLUE_SIZE, GL_COLOR_TABLE_ALPHA_SIZE, GL_COLOR_TABLE_LUMINANCE_SIZE, or GL_COLOR_TABLE_INTENSITY_SIZE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to an array where the values of the parameter will be stored.
        /// </para>
        /// </param>
        public static
        void GetColorTableParameter(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.GetColorTableParameterPName pname, [OutAttribute] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Core.GetColorTableParameteriv((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.GetColorTableParameterPName)pname, (Int32*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get color lookup table parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target color table. Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, GL_POST_COLOR_MATRIX_COLOR_TABLE, GL_PROXY_COLOR_TABLE, GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, or GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The symbolic name of a color lookup table parameter. Must be one of GL_COLOR_TABLE_BIAS, GL_COLOR_TABLE_SCALE, GL_COLOR_TABLE_FORMAT, GL_COLOR_TABLE_WIDTH, GL_COLOR_TABLE_RED_SIZE, GL_COLOR_TABLE_GREEN_SIZE, GL_COLOR_TABLE_BLUE_SIZE, GL_COLOR_TABLE_ALPHA_SIZE, GL_COLOR_TABLE_LUMINANCE_SIZE, or GL_COLOR_TABLE_INTENSITY_SIZE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to an array where the values of the parameter will be stored.
        /// </para>
        /// </param>
        public static
        void GetColorTableParameter(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.GetColorTableParameterPName pname, [OutAttribute] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Core.GetColorTableParameteriv((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.GetColorTableParameterPName)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get color lookup table parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The target color table. Must be GL_COLOR_TABLE, GL_POST_CONVOLUTION_COLOR_TABLE, GL_POST_COLOR_MATRIX_COLOR_TABLE, GL_PROXY_COLOR_TABLE, GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, or GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The symbolic name of a color lookup table parameter. Must be one of GL_COLOR_TABLE_BIAS, GL_COLOR_TABLE_SCALE, GL_COLOR_TABLE_FORMAT, GL_COLOR_TABLE_WIDTH, GL_COLOR_TABLE_RED_SIZE, GL_COLOR_TABLE_GREEN_SIZE, GL_COLOR_TABLE_BLUE_SIZE, GL_COLOR_TABLE_ALPHA_SIZE, GL_COLOR_TABLE_LUMINANCE_SIZE, or GL_COLOR_TABLE_INTENSITY_SIZE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to an array where the values of the parameter will be stored.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetColorTableParameter(MonoMac.OpenGL.ColorTableTarget target, MonoMac.OpenGL.GetColorTableParameterPName pname, [OutAttribute] Int32* @params)
        {
            Core.GetColorTableParameteriv((MonoMac.OpenGL.ColorTableTarget)target, (MonoMac.OpenGL.GetColorTableParameterPName)pname, (Int32*)@params);
        }


        /// <summary>[requires: v1.3]
        /// Return a compressed texture image
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies which texture is to be obtained. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, and GL_TEXTURE_CUBE_MAP_NEGATIVE_Z are accepted.
        /// </para>
        /// </param>
        /// <param name="lod">
        /// <para>
        /// Specifies the level-of-detail number of the desired image. Level 0 is the base image level. Level is the th mipmap reduction image.
        /// </para>
        /// </param>
        /// <param name="img">
        /// <para>
        /// Returns the compressed texture image.
        /// </para>
        /// </param>
        public static
        void GetCompressedTexImage(MonoMac.OpenGL.TextureTarget target, Int32 level, [OutAttribute] IntPtr img)
        {
            Core.GetCompressedTexImage((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (IntPtr)img);
        }


//        /// <summary>[requires: v1.3]
//        /// Return a compressed texture image
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies which texture is to be obtained. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, and GL_TEXTURE_CUBE_MAP_NEGATIVE_Z are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="lod">
//        /// <para>
//        /// Specifies the level-of-detail number of the desired image. Level 0 is the base image level. Level is the th mipmap reduction image.
//        /// </para>
//        /// </param>
//        /// <param name="img">
//        /// <para>
//        /// Returns the compressed texture image.
//        /// </para>
//        /// </param>
//        public static
//        void GetCompressedTexImage<T2>(MonoMac.OpenGL.TextureTarget target, Int32 level, [InAttribute, OutAttribute] T2[] img)
//            where T2 : struct
//        {
//                GCHandle img_ptr = GCHandle.Alloc(img, GCHandleType.Pinned);
//                try
//                {
//                    Core.GetCompressedTexImage((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (IntPtr)img_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    img_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.3]
//        /// Return a compressed texture image
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies which texture is to be obtained. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, and GL_TEXTURE_CUBE_MAP_NEGATIVE_Z are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="lod">
//        /// <para>
//        /// Specifies the level-of-detail number of the desired image. Level 0 is the base image level. Level is the th mipmap reduction image.
//        /// </para>
//        /// </param>
//        /// <param name="img">
//        /// <para>
//        /// Returns the compressed texture image.
//        /// </para>
//        /// </param>
//        public static
//        void GetCompressedTexImage<T2>(MonoMac.OpenGL.TextureTarget target, Int32 level, [InAttribute, OutAttribute] T2[,] img)
//            where T2 : struct
//        {
//                GCHandle img_ptr = GCHandle.Alloc(img, GCHandleType.Pinned);
//                try
//                {
//                    Core.GetCompressedTexImage((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (IntPtr)img_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    img_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.3]
//        /// Return a compressed texture image
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies which texture is to be obtained. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, and GL_TEXTURE_CUBE_MAP_NEGATIVE_Z are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="lod">
//        /// <para>
//        /// Specifies the level-of-detail number of the desired image. Level 0 is the base image level. Level is the th mipmap reduction image.
//        /// </para>
//        /// </param>
//        /// <param name="img">
//        /// <para>
//        /// Returns the compressed texture image.
//        /// </para>
//        /// </param>
//        public static
//        void GetCompressedTexImage<T2>(MonoMac.OpenGL.TextureTarget target, Int32 level, [InAttribute, OutAttribute] T2[, ,] img)
//            where T2 : struct
//        {
//                GCHandle img_ptr = GCHandle.Alloc(img, GCHandleType.Pinned);
//                try
//                {
//                    Core.GetCompressedTexImage((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (IntPtr)img_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    img_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v1.3]
//        /// Return a compressed texture image
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies which texture is to be obtained. GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_CUBE_MAP_POSITIVE_X, GL_TEXTURE_CUBE_MAP_NEGATIVE_X, GL_TEXTURE_CUBE_MAP_POSITIVE_Y, GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, GL_TEXTURE_CUBE_MAP_POSITIVE_Z, and GL_TEXTURE_CUBE_MAP_NEGATIVE_Z are accepted.
//        /// </para>
//        /// </param>
//        /// <param name="lod">
//        /// <para>
//        /// Specifies the level-of-detail number of the desired image. Level 0 is the base image level. Level is the th mipmap reduction image.
//        /// </para>
//        /// </param>
//        /// <param name="img">
//        /// <para>
//        /// Returns the compressed texture image.
//        /// </para>
//        /// </param>
//        public static
//        void GetCompressedTexImage<T2>(MonoMac.OpenGL.TextureTarget target, Int32 level, [InAttribute, OutAttribute] ref T2 img)
//            where T2 : struct
//        {
//                GCHandle img_ptr = GCHandle.Alloc(img, GCHandleType.Pinned);
//                try
//                {
//                    Core.GetCompressedTexImage((MonoMac.OpenGL.TextureTarget)target, (Int32)level, (IntPtr)img_ptr.AddrOfPinnedObject());
//                    img = (T2)img_ptr.Target;
//                }
//                finally
//                {
//                    img_ptr.Free();
//                }
//        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get current 1D or 2D convolution filter kernel
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The filter to be retrieved. Must be one of GL_CONVOLUTION_1D or GL_CONVOLUTION_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output image. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output image. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="image">
        /// <para>
        /// Pointer to storage for the output image.
        /// </para>
        /// </param>
        public static
        void GetConvolutionFilter(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [OutAttribute] IntPtr image)
        {
            Core.GetConvolutionFilter((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get current 1D or 2D convolution filter kernel
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The filter to be retrieved. Must be one of GL_CONVOLUTION_1D or GL_CONVOLUTION_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output image. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output image. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="image">
        /// <para>
        /// Pointer to storage for the output image.
        /// </para>
        /// </param>
        public static
        void GetConvolutionFilter<T3>(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T3[] image)
            where T3 : struct
        {
            GCHandle image_ptr = GCHandle.Alloc(image, GCHandleType.Pinned);
            try
            {
                Core.GetConvolutionFilter((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image_ptr.AddrOfPinnedObject());
            }
            finally
            {
                image_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get current 1D or 2D convolution filter kernel
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The filter to be retrieved. Must be one of GL_CONVOLUTION_1D or GL_CONVOLUTION_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output image. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output image. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="image">
        /// <para>
        /// Pointer to storage for the output image.
        /// </para>
        /// </param>
        public static
        void GetConvolutionFilter<T3>(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T3[,] image)
            where T3 : struct
        {
            GCHandle image_ptr = GCHandle.Alloc(image, GCHandleType.Pinned);
            try
            {
                Core.GetConvolutionFilter((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image_ptr.AddrOfPinnedObject());
            }
            finally
            {
                image_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get current 1D or 2D convolution filter kernel
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The filter to be retrieved. Must be one of GL_CONVOLUTION_1D or GL_CONVOLUTION_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output image. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output image. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="image">
        /// <para>
        /// Pointer to storage for the output image.
        /// </para>
        /// </param>
        public static
        void GetConvolutionFilter<T3>(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T3[, ,] image)
            where T3 : struct
        {
            GCHandle image_ptr = GCHandle.Alloc(image, GCHandleType.Pinned);
            try
            {
                Core.GetConvolutionFilter((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image_ptr.AddrOfPinnedObject());
            }
            finally
            {
                image_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get current 1D or 2D convolution filter kernel
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The filter to be retrieved. Must be one of GL_CONVOLUTION_1D or GL_CONVOLUTION_2D.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// Format of the output image. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// Data type of components in the output image. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="image">
        /// <para>
        /// Pointer to storage for the output image.
        /// </para>
        /// </param>
        public static
        void GetConvolutionFilter<T3>(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] ref T3 image)
            where T3 : struct
        {
            GCHandle image_ptr = GCHandle.Alloc(image, GCHandleType.Pinned);
            try
            {
                Core.GetConvolutionFilter((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)image_ptr.AddrOfPinnedObject());
                image = (T3)image_ptr.Target;
            }
            finally
            {
                image_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get convolution parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The filter whose parameters are to be retrieved. Must be one of GL_CONVOLUTION_1D, GL_CONVOLUTION_2D, or GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be retrieved. Must be one of GL_CONVOLUTION_BORDER_MODE, GL_CONVOLUTION_BORDER_COLOR, GL_CONVOLUTION_FILTER_SCALE, GL_CONVOLUTION_FILTER_BIAS, GL_CONVOLUTION_FORMAT, GL_CONVOLUTION_WIDTH, GL_CONVOLUTION_HEIGHT, GL_MAX_CONVOLUTION_WIDTH, or GL_MAX_CONVOLUTION_HEIGHT.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Pointer to storage for the parameters to be retrieved.
        /// </para>
        /// </param>
        public static
        void GetConvolutionParameter(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.GetConvolutionParameterPName pname, [OutAttribute] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Core.GetConvolutionParameterfv((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.GetConvolutionParameterPName)pname, (Single*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get convolution parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The filter whose parameters are to be retrieved. Must be one of GL_CONVOLUTION_1D, GL_CONVOLUTION_2D, or GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be retrieved. Must be one of GL_CONVOLUTION_BORDER_MODE, GL_CONVOLUTION_BORDER_COLOR, GL_CONVOLUTION_FILTER_SCALE, GL_CONVOLUTION_FILTER_BIAS, GL_CONVOLUTION_FORMAT, GL_CONVOLUTION_WIDTH, GL_CONVOLUTION_HEIGHT, GL_MAX_CONVOLUTION_WIDTH, or GL_MAX_CONVOLUTION_HEIGHT.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Pointer to storage for the parameters to be retrieved.
        /// </para>
        /// </param>
        public static
        void GetConvolutionParameter(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.GetConvolutionParameterPName pname, [OutAttribute] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Core.GetConvolutionParameterfv((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.GetConvolutionParameterPName)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get convolution parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The filter whose parameters are to be retrieved. Must be one of GL_CONVOLUTION_1D, GL_CONVOLUTION_2D, or GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be retrieved. Must be one of GL_CONVOLUTION_BORDER_MODE, GL_CONVOLUTION_BORDER_COLOR, GL_CONVOLUTION_FILTER_SCALE, GL_CONVOLUTION_FILTER_BIAS, GL_CONVOLUTION_FORMAT, GL_CONVOLUTION_WIDTH, GL_CONVOLUTION_HEIGHT, GL_MAX_CONVOLUTION_WIDTH, or GL_MAX_CONVOLUTION_HEIGHT.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Pointer to storage for the parameters to be retrieved.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetConvolutionParameter(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.GetConvolutionParameterPName pname, [OutAttribute] Single* @params)
        {
            Core.GetConvolutionParameterfv((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.GetConvolutionParameterPName)pname, (Single*)@params);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get convolution parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The filter whose parameters are to be retrieved. Must be one of GL_CONVOLUTION_1D, GL_CONVOLUTION_2D, or GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be retrieved. Must be one of GL_CONVOLUTION_BORDER_MODE, GL_CONVOLUTION_BORDER_COLOR, GL_CONVOLUTION_FILTER_SCALE, GL_CONVOLUTION_FILTER_BIAS, GL_CONVOLUTION_FORMAT, GL_CONVOLUTION_WIDTH, GL_CONVOLUTION_HEIGHT, GL_MAX_CONVOLUTION_WIDTH, or GL_MAX_CONVOLUTION_HEIGHT.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Pointer to storage for the parameters to be retrieved.
        /// </para>
        /// </param>
        public static
        void GetConvolutionParameter(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.GetConvolutionParameterPName pname, [OutAttribute] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Core.GetConvolutionParameteriv((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.GetConvolutionParameterPName)pname, (Int32*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get convolution parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The filter whose parameters are to be retrieved. Must be one of GL_CONVOLUTION_1D, GL_CONVOLUTION_2D, or GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be retrieved. Must be one of GL_CONVOLUTION_BORDER_MODE, GL_CONVOLUTION_BORDER_COLOR, GL_CONVOLUTION_FILTER_SCALE, GL_CONVOLUTION_FILTER_BIAS, GL_CONVOLUTION_FORMAT, GL_CONVOLUTION_WIDTH, GL_CONVOLUTION_HEIGHT, GL_MAX_CONVOLUTION_WIDTH, or GL_MAX_CONVOLUTION_HEIGHT.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Pointer to storage for the parameters to be retrieved.
        /// </para>
        /// </param>
        public static
        void GetConvolutionParameter(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.GetConvolutionParameterPName pname, [OutAttribute] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Core.GetConvolutionParameteriv((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.GetConvolutionParameterPName)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get convolution parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// The filter whose parameters are to be retrieved. Must be one of GL_CONVOLUTION_1D, GL_CONVOLUTION_2D, or GL_SEPARABLE_2D.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be retrieved. Must be one of GL_CONVOLUTION_BORDER_MODE, GL_CONVOLUTION_BORDER_COLOR, GL_CONVOLUTION_FILTER_SCALE, GL_CONVOLUTION_FILTER_BIAS, GL_CONVOLUTION_FORMAT, GL_CONVOLUTION_WIDTH, GL_CONVOLUTION_HEIGHT, GL_MAX_CONVOLUTION_WIDTH, or GL_MAX_CONVOLUTION_HEIGHT.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Pointer to storage for the parameters to be retrieved.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetConvolutionParameter(MonoMac.OpenGL.ConvolutionTarget target, MonoMac.OpenGL.GetConvolutionParameterPName pname, [OutAttribute] Int32* @params)
        {
            Core.GetConvolutionParameteriv((MonoMac.OpenGL.ConvolutionTarget)target, (MonoMac.OpenGL.GetConvolutionParameterPName)pname, (Int32*)@params);
        }

        /// <summary>[requires: v4.1 and ARB_viewport_array]</summary>
        public static
        void GetDouble(MonoMac.OpenGL.GetIndexedPName target, Int32 index, [OutAttribute] Double[] data)
        {
            unsafe
            {
                fixed (Double* data_ptr = data)
                {
                    Core.GetDoublei_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Double*)data_ptr);
                }
            }
        }

        /// <summary>[requires: v4.1 and ARB_viewport_array]</summary>
        public static
        void GetDouble(MonoMac.OpenGL.GetIndexedPName target, Int32 index, [OutAttribute] out Double data)
        {
            unsafe
            {
                fixed (Double* data_ptr = &data)
                {
                    Core.GetDoublei_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Double*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        /// <summary>[requires: v4.1 and ARB_viewport_array]</summary>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetDouble(MonoMac.OpenGL.GetIndexedPName target, Int32 index, [OutAttribute] Double* data)
        {
            Core.GetDoublei_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Double*)data);
        }

        /// <summary>[requires: v4.1 and ARB_viewport_array]</summary>
        [System.CLSCompliant(false)]
        public static
        void GetDouble(MonoMac.OpenGL.GetIndexedPName target, UInt32 index, [OutAttribute] Double[] data)
        {
            unsafe
            {
                fixed (Double* data_ptr = data)
                {
                    Core.GetDoublei_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Double*)data_ptr);
                }
            }
        }

        /// <summary>[requires: v4.1 and ARB_viewport_array]</summary>
        [System.CLSCompliant(false)]
        public static
        void GetDouble(MonoMac.OpenGL.GetIndexedPName target, UInt32 index, [OutAttribute] out Double data)
        {
            unsafe
            {
                fixed (Double* data_ptr = &data)
                {
                    Core.GetDoublei_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Double*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        /// <summary>[requires: v4.1 and ARB_viewport_array]</summary>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetDouble(MonoMac.OpenGL.GetIndexedPName target, UInt32 index, [OutAttribute] Double* data)
        {
            Core.GetDoublei_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Double*)data);
        }

        /// <summary>[requires: v1.0]</summary>
        public static
        void GetDouble(MonoMac.OpenGL.GetPName pname, [OutAttribute] Double[] @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = @params)
                {
                    Core.GetDoublev((MonoMac.OpenGL.GetPName)pname, (Double*)@params_ptr);
                }
            }
        }

        /// <summary>[requires: v1.0]</summary>
        public static
        void GetDouble(MonoMac.OpenGL.GetPName pname, [OutAttribute] out Double @params)
        {
            unsafe
            {
                fixed (Double* @params_ptr = &@params)
                {
                    Core.GetDoublev((MonoMac.OpenGL.GetPName)pname, (Double*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        /// <summary>[requires: v1.0]</summary>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetDouble(MonoMac.OpenGL.GetPName pname, [OutAttribute] Double* @params)
        {
            Core.GetDoublev((MonoMac.OpenGL.GetPName)pname, (Double*)@params);
        }


        /// <summary>[requires: v1.0]
        /// Return error information
        /// </summary>
        public static
        MonoMac.OpenGL.ErrorCode GetError()
        {
            return Core.GetError();
        }

        /// <summary>[requires: v4.1 and ARB_viewport_array]</summary>
        public static
        void GetFloat(MonoMac.OpenGL.GetIndexedPName target, Int32 index, [OutAttribute] Single[] data)
        {
            unsafe
            {
                fixed (Single* data_ptr = data)
                {
                    Core.GetFloati_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Single*)data_ptr);
                }
            }
        }

        /// <summary>[requires: v4.1 and ARB_viewport_array]</summary>
        public static
        void GetFloat(MonoMac.OpenGL.GetIndexedPName target, Int32 index, [OutAttribute] out Single data)
        {
            unsafe
            {
                fixed (Single* data_ptr = &data)
                {
                    Core.GetFloati_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Single*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        /// <summary>[requires: v4.1 and ARB_viewport_array]</summary>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetFloat(MonoMac.OpenGL.GetIndexedPName target, Int32 index, [OutAttribute] Single* data)
        {
            Core.GetFloati_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Single*)data);
        }

        /// <summary>[requires: v4.1 and ARB_viewport_array]</summary>
        [System.CLSCompliant(false)]
        public static
        void GetFloat(MonoMac.OpenGL.GetIndexedPName target, UInt32 index, [OutAttribute] Single[] data)
        {
            unsafe
            {
                fixed (Single* data_ptr = data)
                {
                    Core.GetFloati_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Single*)data_ptr);
                }
            }
        }

        /// <summary>[requires: v4.1 and ARB_viewport_array]</summary>
        [System.CLSCompliant(false)]
        public static
        void GetFloat(MonoMac.OpenGL.GetIndexedPName target, UInt32 index, [OutAttribute] out Single data)
        {
            unsafe
            {
                fixed (Single* data_ptr = &data)
                {
                    Core.GetFloati_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Single*)data_ptr);
                    data = *data_ptr;
                }
            }
        }

        /// <summary>[requires: v4.1 and ARB_viewport_array]</summary>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetFloat(MonoMac.OpenGL.GetIndexedPName target, UInt32 index, [OutAttribute] Single* data)
        {
            Core.GetFloati_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Single*)data);
        }

        /// <summary>[requires: v1.0]</summary>
        public static
        void GetFloat(MonoMac.OpenGL.GetPName pname, [OutAttribute] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Core.GetFloatv((MonoMac.OpenGL.GetPName)pname, (Single*)@params_ptr);
                }
            }
        }

        /// <summary>[requires: v1.0]</summary>
        public static
        void GetFloat(MonoMac.OpenGL.GetPName pname, [OutAttribute] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Core.GetFloatv((MonoMac.OpenGL.GetPName)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        /// <summary>[requires: v1.0]</summary>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetFloat(MonoMac.OpenGL.GetPName pname, [OutAttribute] Single* @params)
        {
            Core.GetFloatv((MonoMac.OpenGL.GetPName)pname, (Single*)@params);
        }


//        /// <summary>[requires: v1.2 and ARB_blend_func_extended]
//        /// Query the bindings of color indices to user-defined varying out variables
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// The name of the program containing varying out variable whose binding to query
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// The name of the user-defined varying out variable whose index to query
//        /// </para>
//        /// </param>
//        public static
//        Int32 GetFragDataIndex(Int32 program, String name)
//        {
//                return Core.GetFragDataIndex((UInt32)program, (String)name);
//        }


//        /// <summary>[requires: v1.2 and ARB_blend_func_extended]
//        /// Query the bindings of color indices to user-defined varying out variables
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// The name of the program containing varying out variable whose binding to query
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// The name of the user-defined varying out variable whose index to query
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        Int32 GetFragDataIndex(UInt32 program, String name)
//        {
//                return Core.GetFragDataIndex((UInt32)program, (String)name);
//        }


//        /// <summary>[requires: v3.0]
//        /// Query the bindings of color numbers to user-defined varying out variables
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// The name of the program containing varying out variable whose binding to query
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// The name of the user-defined varying out variable whose binding to query
//        /// </para>
//        /// </param>
//        public static
//        Int32 GetFragDataLocation(Int32 program, String name)
//        {
//                return Core.GetFragDataLocation((UInt32)program, (String)name);
//        }


//        /// <summary>[requires: v3.0]
//        /// Query the bindings of color numbers to user-defined varying out variables
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// The name of the program containing varying out variable whose binding to query
//        /// </para>
//        /// </param>
//        /// <param name="name">
//        /// <para>
//        /// The name of the user-defined varying out variable whose binding to query
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        Int32 GetFragDataLocation(UInt32 program, String name)
//        {
//                return Core.GetFragDataLocation((UInt32)program, (String)name);
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Retrieve information about attachments of a bound framebuffer object
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the target of the query operation.
//        /// </para>
//        /// </param>
//        /// <param name="attachment">
//        /// <para>
//        /// Specifies the attachment within target
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the parameter of attachment to query.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable receive the value of pname for attachment.
//        /// </para>
//        /// </param>
//        public static
//        void GetFramebufferAttachmentParameter(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, MonoMac.OpenGL.FramebufferParameterName pname, [OutAttribute] Int32[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = @params)
//                    {
//                        Core.GetFramebufferAttachmentParameteriv((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (MonoMac.OpenGL.FramebufferParameterName)pname, (Int32*)@params_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Retrieve information about attachments of a bound framebuffer object
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the target of the query operation.
//        /// </para>
//        /// </param>
//        /// <param name="attachment">
//        /// <para>
//        /// Specifies the attachment within target
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the parameter of attachment to query.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable receive the value of pname for attachment.
//        /// </para>
//        /// </param>
//        public static
//        void GetFramebufferAttachmentParameter(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, MonoMac.OpenGL.FramebufferParameterName pname, [OutAttribute] out Int32 @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = &@params)
//                    {
//                        Core.GetFramebufferAttachmentParameteriv((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (MonoMac.OpenGL.FramebufferParameterName)pname, (Int32*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v3.0 and ARB_framebuffer_object]
//        /// Retrieve information about attachments of a bound framebuffer object
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies the target of the query operation.
//        /// </para>
//        /// </param>
//        /// <param name="attachment">
//        /// <para>
//        /// Specifies the attachment within target
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the parameter of attachment to query.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable receive the value of pname for attachment.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetFramebufferAttachmentParameter(MonoMac.OpenGL.FramebufferTarget target, MonoMac.OpenGL.FramebufferAttachment attachment, MonoMac.OpenGL.FramebufferParameterName pname, [OutAttribute] Int32* @params)
//        {
//                Core.GetFramebufferAttachmentParameteriv((MonoMac.OpenGL.FramebufferTarget)target, (MonoMac.OpenGL.FramebufferAttachment)attachment, (MonoMac.OpenGL.FramebufferParameterName)pname, (Int32*)@params);
//        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get histogram table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_HISTOGRAM.
        /// </para>
        /// </param>
        /// <param name="reset">
        /// <para>
        /// If GL_TRUE, each component counter that is actually returned is reset to zero. (Other counters are unaffected.) If GL_FALSE, none of the counters in the histogram table is modified.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of values to be returned in values. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of values to be returned in values. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="values">
        /// <para>
        /// A pointer to storage for the returned histogram table.
        /// </para>
        /// </param>
        public static
        void GetHistogram(MonoMac.OpenGL.HistogramTarget target, bool reset, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [OutAttribute] IntPtr values)
        {
            Core.GetHistogram((MonoMac.OpenGL.HistogramTarget)target, (bool)reset, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)values);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get histogram table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_HISTOGRAM.
        /// </para>
        /// </param>
        /// <param name="reset">
        /// <para>
        /// If GL_TRUE, each component counter that is actually returned is reset to zero. (Other counters are unaffected.) If GL_FALSE, none of the counters in the histogram table is modified.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of values to be returned in values. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of values to be returned in values. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="values">
        /// <para>
        /// A pointer to storage for the returned histogram table.
        /// </para>
        /// </param>
        public static
        void GetHistogram<T4>(MonoMac.OpenGL.HistogramTarget target, bool reset, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T4[] values)
            where T4 : struct
        {
            GCHandle values_ptr = GCHandle.Alloc(values, GCHandleType.Pinned);
            try
            {
                Core.GetHistogram((MonoMac.OpenGL.HistogramTarget)target, (bool)reset, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)values_ptr.AddrOfPinnedObject());
            }
            finally
            {
                values_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get histogram table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_HISTOGRAM.
        /// </para>
        /// </param>
        /// <param name="reset">
        /// <para>
        /// If GL_TRUE, each component counter that is actually returned is reset to zero. (Other counters are unaffected.) If GL_FALSE, none of the counters in the histogram table is modified.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of values to be returned in values. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of values to be returned in values. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="values">
        /// <para>
        /// A pointer to storage for the returned histogram table.
        /// </para>
        /// </param>
        public static
        void GetHistogram<T4>(MonoMac.OpenGL.HistogramTarget target, bool reset, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T4[,] values)
            where T4 : struct
        {
            GCHandle values_ptr = GCHandle.Alloc(values, GCHandleType.Pinned);
            try
            {
                Core.GetHistogram((MonoMac.OpenGL.HistogramTarget)target, (bool)reset, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)values_ptr.AddrOfPinnedObject());
            }
            finally
            {
                values_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get histogram table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_HISTOGRAM.
        /// </para>
        /// </param>
        /// <param name="reset">
        /// <para>
        /// If GL_TRUE, each component counter that is actually returned is reset to zero. (Other counters are unaffected.) If GL_FALSE, none of the counters in the histogram table is modified.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of values to be returned in values. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of values to be returned in values. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="values">
        /// <para>
        /// A pointer to storage for the returned histogram table.
        /// </para>
        /// </param>
        public static
        void GetHistogram<T4>(MonoMac.OpenGL.HistogramTarget target, bool reset, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T4[, ,] values)
            where T4 : struct
        {
            GCHandle values_ptr = GCHandle.Alloc(values, GCHandleType.Pinned);
            try
            {
                Core.GetHistogram((MonoMac.OpenGL.HistogramTarget)target, (bool)reset, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)values_ptr.AddrOfPinnedObject());
            }
            finally
            {
                values_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get histogram table
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_HISTOGRAM.
        /// </para>
        /// </param>
        /// <param name="reset">
        /// <para>
        /// If GL_TRUE, each component counter that is actually returned is reset to zero. (Other counters are unaffected.) If GL_FALSE, none of the counters in the histogram table is modified.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of values to be returned in values. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="type">
        /// <para>
        /// The type of values to be returned in values. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="values">
        /// <para>
        /// A pointer to storage for the returned histogram table.
        /// </para>
        /// </param>
        public static
        void GetHistogram<T4>(MonoMac.OpenGL.HistogramTarget target, bool reset, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] ref T4 values)
            where T4 : struct
        {
            GCHandle values_ptr = GCHandle.Alloc(values, GCHandleType.Pinned);
            try
            {
                Core.GetHistogram((MonoMac.OpenGL.HistogramTarget)target, (bool)reset, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)values_ptr.AddrOfPinnedObject());
                values = (T4)values_ptr.Target;
            }
            finally
            {
                values_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get histogram parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_HISTOGRAM or GL_PROXY_HISTOGRAM.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The name of the parameter to be retrieved. Must be one of GL_HISTOGRAM_WIDTH, GL_HISTOGRAM_FORMAT, GL_HISTOGRAM_RED_SIZE, GL_HISTOGRAM_GREEN_SIZE, GL_HISTOGRAM_BLUE_SIZE, GL_HISTOGRAM_ALPHA_SIZE, GL_HISTOGRAM_LUMINANCE_SIZE, or GL_HISTOGRAM_SINK.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Pointer to storage for the returned values.
        /// </para>
        /// </param>
        public static
        void GetHistogramParameter(MonoMac.OpenGL.HistogramTarget target, MonoMac.OpenGL.GetHistogramParameterPName pname, [OutAttribute] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Core.GetHistogramParameterfv((MonoMac.OpenGL.HistogramTarget)target, (MonoMac.OpenGL.GetHistogramParameterPName)pname, (Single*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get histogram parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_HISTOGRAM or GL_PROXY_HISTOGRAM.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The name of the parameter to be retrieved. Must be one of GL_HISTOGRAM_WIDTH, GL_HISTOGRAM_FORMAT, GL_HISTOGRAM_RED_SIZE, GL_HISTOGRAM_GREEN_SIZE, GL_HISTOGRAM_BLUE_SIZE, GL_HISTOGRAM_ALPHA_SIZE, GL_HISTOGRAM_LUMINANCE_SIZE, or GL_HISTOGRAM_SINK.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Pointer to storage for the returned values.
        /// </para>
        /// </param>
        public static
        void GetHistogramParameter(MonoMac.OpenGL.HistogramTarget target, MonoMac.OpenGL.GetHistogramParameterPName pname, [OutAttribute] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Core.GetHistogramParameterfv((MonoMac.OpenGL.HistogramTarget)target, (MonoMac.OpenGL.GetHistogramParameterPName)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get histogram parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_HISTOGRAM or GL_PROXY_HISTOGRAM.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The name of the parameter to be retrieved. Must be one of GL_HISTOGRAM_WIDTH, GL_HISTOGRAM_FORMAT, GL_HISTOGRAM_RED_SIZE, GL_HISTOGRAM_GREEN_SIZE, GL_HISTOGRAM_BLUE_SIZE, GL_HISTOGRAM_ALPHA_SIZE, GL_HISTOGRAM_LUMINANCE_SIZE, or GL_HISTOGRAM_SINK.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Pointer to storage for the returned values.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetHistogramParameter(MonoMac.OpenGL.HistogramTarget target, MonoMac.OpenGL.GetHistogramParameterPName pname, [OutAttribute] Single* @params)
        {
            Core.GetHistogramParameterfv((MonoMac.OpenGL.HistogramTarget)target, (MonoMac.OpenGL.GetHistogramParameterPName)pname, (Single*)@params);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get histogram parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_HISTOGRAM or GL_PROXY_HISTOGRAM.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The name of the parameter to be retrieved. Must be one of GL_HISTOGRAM_WIDTH, GL_HISTOGRAM_FORMAT, GL_HISTOGRAM_RED_SIZE, GL_HISTOGRAM_GREEN_SIZE, GL_HISTOGRAM_BLUE_SIZE, GL_HISTOGRAM_ALPHA_SIZE, GL_HISTOGRAM_LUMINANCE_SIZE, or GL_HISTOGRAM_SINK.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Pointer to storage for the returned values.
        /// </para>
        /// </param>
        public static
        void GetHistogramParameter(MonoMac.OpenGL.HistogramTarget target, MonoMac.OpenGL.GetHistogramParameterPName pname, [OutAttribute] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Core.GetHistogramParameteriv((MonoMac.OpenGL.HistogramTarget)target, (MonoMac.OpenGL.GetHistogramParameterPName)pname, (Int32*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get histogram parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_HISTOGRAM or GL_PROXY_HISTOGRAM.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The name of the parameter to be retrieved. Must be one of GL_HISTOGRAM_WIDTH, GL_HISTOGRAM_FORMAT, GL_HISTOGRAM_RED_SIZE, GL_HISTOGRAM_GREEN_SIZE, GL_HISTOGRAM_BLUE_SIZE, GL_HISTOGRAM_ALPHA_SIZE, GL_HISTOGRAM_LUMINANCE_SIZE, or GL_HISTOGRAM_SINK.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Pointer to storage for the returned values.
        /// </para>
        /// </param>
        public static
        void GetHistogramParameter(MonoMac.OpenGL.HistogramTarget target, MonoMac.OpenGL.GetHistogramParameterPName pname, [OutAttribute] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Core.GetHistogramParameteriv((MonoMac.OpenGL.HistogramTarget)target, (MonoMac.OpenGL.GetHistogramParameterPName)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get histogram parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be one of GL_HISTOGRAM or GL_PROXY_HISTOGRAM.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The name of the parameter to be retrieved. Must be one of GL_HISTOGRAM_WIDTH, GL_HISTOGRAM_FORMAT, GL_HISTOGRAM_RED_SIZE, GL_HISTOGRAM_GREEN_SIZE, GL_HISTOGRAM_BLUE_SIZE, GL_HISTOGRAM_ALPHA_SIZE, GL_HISTOGRAM_LUMINANCE_SIZE, or GL_HISTOGRAM_SINK.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Pointer to storage for the returned values.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetHistogramParameter(MonoMac.OpenGL.HistogramTarget target, MonoMac.OpenGL.GetHistogramParameterPName pname, [OutAttribute] Int32* @params)
        {
            Core.GetHistogramParameteriv((MonoMac.OpenGL.HistogramTarget)target, (MonoMac.OpenGL.GetHistogramParameterPName)pname, (Int32*)@params);
        }

//        /// <summary>[requires: v3.2]</summary>
//        public static
//        void GetInteger64(MonoMac.OpenGL.Version32 target, Int32 index, [OutAttribute] Int64[] data)
//        {
//                unsafe
//                {
//                    fixed (Int64* data_ptr = data)
//                    {
//                        Core.GetInteger64i_v((MonoMac.OpenGL.Version32)target, (UInt32)index, (Int64*)data_ptr);
//                    }
//                }
//        }

//        /// <summary>[requires: v3.2]</summary>
//        public static
//        void GetInteger64(MonoMac.OpenGL.Version32 target, Int32 index, [OutAttribute] out Int64 data)
//        {
//                unsafe
//                {
//                    fixed (Int64* data_ptr = &data)
//                    {
//                        Core.GetInteger64i_v((MonoMac.OpenGL.Version32)target, (UInt32)index, (Int64*)data_ptr);
//                        data = *data_ptr;
//                    }
//                }
//        }

//        /// <summary>[requires: v3.2]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetInteger64(MonoMac.OpenGL.Version32 target, Int32 index, [OutAttribute] Int64* data)
//        {
//                Core.GetInteger64i_v((MonoMac.OpenGL.Version32)target, (UInt32)index, (Int64*)data);
//        }

//        /// <summary>[requires: v3.2]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void GetInteger64(MonoMac.OpenGL.Version32 target, UInt32 index, [OutAttribute] Int64[] data)
//        {
//                unsafe
//                {
//                    fixed (Int64* data_ptr = data)
//                    {
//                        Core.GetInteger64i_v((MonoMac.OpenGL.Version32)target, (UInt32)index, (Int64*)data_ptr);
//                    }
//                }
//        }

//        /// <summary>[requires: v3.2]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void GetInteger64(MonoMac.OpenGL.Version32 target, UInt32 index, [OutAttribute] out Int64 data)
//        {
//                unsafe
//                {
//                    fixed (Int64* data_ptr = &data)
//                    {
//                        Core.GetInteger64i_v((MonoMac.OpenGL.Version32)target, (UInt32)index, (Int64*)data_ptr);
//                        data = *data_ptr;
//                    }
//                }
//        }

//        /// <summary>[requires: v3.2]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetInteger64(MonoMac.OpenGL.Version32 target, UInt32 index, [OutAttribute] Int64* data)
//        {
//                Core.GetInteger64i_v((MonoMac.OpenGL.Version32)target, (UInt32)index, (Int64*)data);
//        }

//        /// <summary>[requires: v1.2 and ARB_sync]</summary>
//        public static
//        void GetInteger64(MonoMac.OpenGL.ArbSync pname, [OutAttribute] Int64[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int64* @params_ptr = @params)
//                    {
//                        Core.GetInteger64v((MonoMac.OpenGL.ArbSync)pname, (Int64*)@params_ptr);
//                    }
//                }
//        }

//        /// <summary>[requires: v1.2 and ARB_sync]</summary>
//        public static
//        void GetInteger64(MonoMac.OpenGL.ArbSync pname, [OutAttribute] out Int64 @params)
//        {
//                unsafe
//                {
//                    fixed (Int64* @params_ptr = &@params)
//                    {
//                        Core.GetInteger64v((MonoMac.OpenGL.ArbSync)pname, (Int64*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }

//        /// <summary>[requires: v1.2 and ARB_sync]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetInteger64(MonoMac.OpenGL.ArbSync pname, [OutAttribute] Int64* @params)
//        {
//                Core.GetInteger64v((MonoMac.OpenGL.ArbSync)pname, (Int64*)@params);
//        }

//        /// <summary>[requires: v3.0]</summary>
//        public static
//        void GetInteger(MonoMac.OpenGL.GetIndexedPName target, Int32 index, [OutAttribute] Int32[] data)
//        {
//                unsafe
//                {
//                    fixed (Int32* data_ptr = data)
//                    {
//                        Core.GetIntegeri_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Int32*)data_ptr);
//                    }
//                }
//        }

//        /// <summary>[requires: v3.0]</summary>
//        public static
//        void GetInteger(MonoMac.OpenGL.GetIndexedPName target, Int32 index, [OutAttribute] out Int32 data)
//        {
//                unsafe
//                {
//                    fixed (Int32* data_ptr = &data)
//                    {
//                        Core.GetIntegeri_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Int32*)data_ptr);
//                        data = *data_ptr;
//                    }
//                }
//        }

//        /// <summary>[requires: v3.0]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetInteger(MonoMac.OpenGL.GetIndexedPName target, Int32 index, [OutAttribute] Int32* data)
//        {
//                Core.GetIntegeri_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Int32*)data);
//        }

//        /// <summary>[requires: v3.0]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void GetInteger(MonoMac.OpenGL.GetIndexedPName target, UInt32 index, [OutAttribute] Int32[] data)
//        {
//                unsafe
//                {
//                    fixed (Int32* data_ptr = data)
//                    {
//                        Core.GetIntegeri_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Int32*)data_ptr);
//                    }
//                }
//        }

//        /// <summary>[requires: v3.0]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void GetInteger(MonoMac.OpenGL.GetIndexedPName target, UInt32 index, [OutAttribute] out Int32 data)
//        {
//                unsafe
//                {
//                    fixed (Int32* data_ptr = &data)
//                    {
//                        Core.GetIntegeri_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Int32*)data_ptr);
//                        data = *data_ptr;
//                    }
//                }
//        }

//        /// <summary>[requires: v3.0]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetInteger(MonoMac.OpenGL.GetIndexedPName target, UInt32 index, [OutAttribute] Int32* data)
//        {
//                Core.GetIntegeri_v((MonoMac.OpenGL.GetIndexedPName)target, (UInt32)index, (Int32*)data);
//        }

        /// <summary>[requires: v1.0]</summary>
        public static
        void GetInteger(MonoMac.OpenGL.GetPName pname, [OutAttribute] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Core.GetIntegerv((MonoMac.OpenGL.GetPName)pname, (Int32*)@params_ptr);
                }
            }
        }

        /// <summary>[requires: v1.0]</summary>
        public static
        void GetInteger(MonoMac.OpenGL.GetPName pname, [OutAttribute] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Core.GetIntegerv((MonoMac.OpenGL.GetPName)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }

        /// <summary>[requires: v1.0]</summary>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetInteger(MonoMac.OpenGL.GetPName pname, [OutAttribute] Int32* @params)
        {
            Core.GetIntegerv((MonoMac.OpenGL.GetPName)pname, (Int32*)@params);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return light source parameter values
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light source. The number of possible lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT where ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a light source parameter for light. Accepted symbolic names are GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_POSITION, GL_SPOT_DIRECTION, GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        public static
        void GetLight(MonoMac.OpenGL.LightName light, MonoMac.OpenGL.LightParameter pname, [OutAttribute] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Core.GetLightfv((MonoMac.OpenGL.LightName)light, (MonoMac.OpenGL.LightParameter)pname, (Single*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return light source parameter values
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light source. The number of possible lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT where ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a light source parameter for light. Accepted symbolic names are GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_POSITION, GL_SPOT_DIRECTION, GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        public static
        void GetLight(MonoMac.OpenGL.LightName light, MonoMac.OpenGL.LightParameter pname, [OutAttribute] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Core.GetLightfv((MonoMac.OpenGL.LightName)light, (MonoMac.OpenGL.LightParameter)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return light source parameter values
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light source. The number of possible lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT where ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a light source parameter for light. Accepted symbolic names are GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_POSITION, GL_SPOT_DIRECTION, GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetLight(MonoMac.OpenGL.LightName light, MonoMac.OpenGL.LightParameter pname, [OutAttribute] Single* @params)
        {
            Core.GetLightfv((MonoMac.OpenGL.LightName)light, (MonoMac.OpenGL.LightParameter)pname, (Single*)@params);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return light source parameter values
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light source. The number of possible lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT where ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a light source parameter for light. Accepted symbolic names are GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_POSITION, GL_SPOT_DIRECTION, GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        public static
        void GetLight(MonoMac.OpenGL.LightName light, MonoMac.OpenGL.LightParameter pname, [OutAttribute] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Core.GetLightiv((MonoMac.OpenGL.LightName)light, (MonoMac.OpenGL.LightParameter)pname, (Int32*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return light source parameter values
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light source. The number of possible lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT where ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a light source parameter for light. Accepted symbolic names are GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_POSITION, GL_SPOT_DIRECTION, GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        public static
        void GetLight(MonoMac.OpenGL.LightName light, MonoMac.OpenGL.LightParameter pname, [OutAttribute] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Core.GetLightiv((MonoMac.OpenGL.LightName)light, (MonoMac.OpenGL.LightParameter)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return light source parameter values
        /// </summary>
        /// <param name="light">
        /// <para>
        /// Specifies a light source. The number of possible lights depends on the implementation, but at least eight lights are supported. They are identified by symbolic names of the form GL_LIGHT where ranges from 0 to the value of GL_MAX_LIGHTS - 1.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies a light source parameter for light. Accepted symbolic names are GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_POSITION, GL_SPOT_DIRECTION, GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, and GL_QUADRATIC_ATTENUATION.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetLight(MonoMac.OpenGL.LightName light, MonoMac.OpenGL.LightParameter pname, [OutAttribute] Int32* @params)
        {
            Core.GetLightiv((MonoMac.OpenGL.LightName)light, (MonoMac.OpenGL.LightParameter)pname, (Int32*)@params);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return evaluator parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of a map. Accepted values are GL_MAP1_COLOR_4, GL_MAP1_INDEX, GL_MAP1_NORMAL, GL_MAP1_TEXTURE_COORD_1, GL_MAP1_TEXTURE_COORD_2, GL_MAP1_TEXTURE_COORD_3, GL_MAP1_TEXTURE_COORD_4, GL_MAP1_VERTEX_3, GL_MAP1_VERTEX_4, GL_MAP2_COLOR_4, GL_MAP2_INDEX, GL_MAP2_NORMAL, GL_MAP2_TEXTURE_COORD_1, GL_MAP2_TEXTURE_COORD_2, GL_MAP2_TEXTURE_COORD_3, GL_MAP2_TEXTURE_COORD_4, GL_MAP2_VERTEX_3, and GL_MAP2_VERTEX_4.
        /// </para>
        /// </param>
        /// <param name="query">
        /// <para>
        /// Specifies which parameter to return. Symbolic names GL_COEFF, GL_ORDER, and GL_DOMAIN are accepted.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        public static
        void GetMap(MonoMac.OpenGL.MapTarget target, MonoMac.OpenGL.GetMapQuery query, [OutAttribute] Double[] v)
        {
            unsafe
            {
                fixed (Double* v_ptr = v)
                {
                    Core.GetMapdv((MonoMac.OpenGL.MapTarget)target, (MonoMac.OpenGL.GetMapQuery)query, (Double*)v_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return evaluator parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of a map. Accepted values are GL_MAP1_COLOR_4, GL_MAP1_INDEX, GL_MAP1_NORMAL, GL_MAP1_TEXTURE_COORD_1, GL_MAP1_TEXTURE_COORD_2, GL_MAP1_TEXTURE_COORD_3, GL_MAP1_TEXTURE_COORD_4, GL_MAP1_VERTEX_3, GL_MAP1_VERTEX_4, GL_MAP2_COLOR_4, GL_MAP2_INDEX, GL_MAP2_NORMAL, GL_MAP2_TEXTURE_COORD_1, GL_MAP2_TEXTURE_COORD_2, GL_MAP2_TEXTURE_COORD_3, GL_MAP2_TEXTURE_COORD_4, GL_MAP2_VERTEX_3, and GL_MAP2_VERTEX_4.
        /// </para>
        /// </param>
        /// <param name="query">
        /// <para>
        /// Specifies which parameter to return. Symbolic names GL_COEFF, GL_ORDER, and GL_DOMAIN are accepted.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        public static
        void GetMap(MonoMac.OpenGL.MapTarget target, MonoMac.OpenGL.GetMapQuery query, [OutAttribute] out Double v)
        {
            unsafe
            {
                fixed (Double* v_ptr = &v)
                {
                    Core.GetMapdv((MonoMac.OpenGL.MapTarget)target, (MonoMac.OpenGL.GetMapQuery)query, (Double*)v_ptr);
                    v = *v_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return evaluator parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of a map. Accepted values are GL_MAP1_COLOR_4, GL_MAP1_INDEX, GL_MAP1_NORMAL, GL_MAP1_TEXTURE_COORD_1, GL_MAP1_TEXTURE_COORD_2, GL_MAP1_TEXTURE_COORD_3, GL_MAP1_TEXTURE_COORD_4, GL_MAP1_VERTEX_3, GL_MAP1_VERTEX_4, GL_MAP2_COLOR_4, GL_MAP2_INDEX, GL_MAP2_NORMAL, GL_MAP2_TEXTURE_COORD_1, GL_MAP2_TEXTURE_COORD_2, GL_MAP2_TEXTURE_COORD_3, GL_MAP2_TEXTURE_COORD_4, GL_MAP2_VERTEX_3, and GL_MAP2_VERTEX_4.
        /// </para>
        /// </param>
        /// <param name="query">
        /// <para>
        /// Specifies which parameter to return. Symbolic names GL_COEFF, GL_ORDER, and GL_DOMAIN are accepted.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetMap(MonoMac.OpenGL.MapTarget target, MonoMac.OpenGL.GetMapQuery query, [OutAttribute] Double* v)
        {
            Core.GetMapdv((MonoMac.OpenGL.MapTarget)target, (MonoMac.OpenGL.GetMapQuery)query, (Double*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return evaluator parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of a map. Accepted values are GL_MAP1_COLOR_4, GL_MAP1_INDEX, GL_MAP1_NORMAL, GL_MAP1_TEXTURE_COORD_1, GL_MAP1_TEXTURE_COORD_2, GL_MAP1_TEXTURE_COORD_3, GL_MAP1_TEXTURE_COORD_4, GL_MAP1_VERTEX_3, GL_MAP1_VERTEX_4, GL_MAP2_COLOR_4, GL_MAP2_INDEX, GL_MAP2_NORMAL, GL_MAP2_TEXTURE_COORD_1, GL_MAP2_TEXTURE_COORD_2, GL_MAP2_TEXTURE_COORD_3, GL_MAP2_TEXTURE_COORD_4, GL_MAP2_VERTEX_3, and GL_MAP2_VERTEX_4.
        /// </para>
        /// </param>
        /// <param name="query">
        /// <para>
        /// Specifies which parameter to return. Symbolic names GL_COEFF, GL_ORDER, and GL_DOMAIN are accepted.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        public static
        void GetMap(MonoMac.OpenGL.MapTarget target, MonoMac.OpenGL.GetMapQuery query, [OutAttribute] Single[] v)
        {
            unsafe
            {
                fixed (Single* v_ptr = v)
                {
                    Core.GetMapfv((MonoMac.OpenGL.MapTarget)target, (MonoMac.OpenGL.GetMapQuery)query, (Single*)v_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return evaluator parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of a map. Accepted values are GL_MAP1_COLOR_4, GL_MAP1_INDEX, GL_MAP1_NORMAL, GL_MAP1_TEXTURE_COORD_1, GL_MAP1_TEXTURE_COORD_2, GL_MAP1_TEXTURE_COORD_3, GL_MAP1_TEXTURE_COORD_4, GL_MAP1_VERTEX_3, GL_MAP1_VERTEX_4, GL_MAP2_COLOR_4, GL_MAP2_INDEX, GL_MAP2_NORMAL, GL_MAP2_TEXTURE_COORD_1, GL_MAP2_TEXTURE_COORD_2, GL_MAP2_TEXTURE_COORD_3, GL_MAP2_TEXTURE_COORD_4, GL_MAP2_VERTEX_3, and GL_MAP2_VERTEX_4.
        /// </para>
        /// </param>
        /// <param name="query">
        /// <para>
        /// Specifies which parameter to return. Symbolic names GL_COEFF, GL_ORDER, and GL_DOMAIN are accepted.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        public static
        void GetMap(MonoMac.OpenGL.MapTarget target, MonoMac.OpenGL.GetMapQuery query, [OutAttribute] out Single v)
        {
            unsafe
            {
                fixed (Single* v_ptr = &v)
                {
                    Core.GetMapfv((MonoMac.OpenGL.MapTarget)target, (MonoMac.OpenGL.GetMapQuery)query, (Single*)v_ptr);
                    v = *v_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return evaluator parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of a map. Accepted values are GL_MAP1_COLOR_4, GL_MAP1_INDEX, GL_MAP1_NORMAL, GL_MAP1_TEXTURE_COORD_1, GL_MAP1_TEXTURE_COORD_2, GL_MAP1_TEXTURE_COORD_3, GL_MAP1_TEXTURE_COORD_4, GL_MAP1_VERTEX_3, GL_MAP1_VERTEX_4, GL_MAP2_COLOR_4, GL_MAP2_INDEX, GL_MAP2_NORMAL, GL_MAP2_TEXTURE_COORD_1, GL_MAP2_TEXTURE_COORD_2, GL_MAP2_TEXTURE_COORD_3, GL_MAP2_TEXTURE_COORD_4, GL_MAP2_VERTEX_3, and GL_MAP2_VERTEX_4.
        /// </para>
        /// </param>
        /// <param name="query">
        /// <para>
        /// Specifies which parameter to return. Symbolic names GL_COEFF, GL_ORDER, and GL_DOMAIN are accepted.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetMap(MonoMac.OpenGL.MapTarget target, MonoMac.OpenGL.GetMapQuery query, [OutAttribute] Single* v)
        {
            Core.GetMapfv((MonoMac.OpenGL.MapTarget)target, (MonoMac.OpenGL.GetMapQuery)query, (Single*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return evaluator parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of a map. Accepted values are GL_MAP1_COLOR_4, GL_MAP1_INDEX, GL_MAP1_NORMAL, GL_MAP1_TEXTURE_COORD_1, GL_MAP1_TEXTURE_COORD_2, GL_MAP1_TEXTURE_COORD_3, GL_MAP1_TEXTURE_COORD_4, GL_MAP1_VERTEX_3, GL_MAP1_VERTEX_4, GL_MAP2_COLOR_4, GL_MAP2_INDEX, GL_MAP2_NORMAL, GL_MAP2_TEXTURE_COORD_1, GL_MAP2_TEXTURE_COORD_2, GL_MAP2_TEXTURE_COORD_3, GL_MAP2_TEXTURE_COORD_4, GL_MAP2_VERTEX_3, and GL_MAP2_VERTEX_4.
        /// </para>
        /// </param>
        /// <param name="query">
        /// <para>
        /// Specifies which parameter to return. Symbolic names GL_COEFF, GL_ORDER, and GL_DOMAIN are accepted.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        public static
        void GetMap(MonoMac.OpenGL.MapTarget target, MonoMac.OpenGL.GetMapQuery query, [OutAttribute] Int32[] v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = v)
                {
                    Core.GetMapiv((MonoMac.OpenGL.MapTarget)target, (MonoMac.OpenGL.GetMapQuery)query, (Int32*)v_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return evaluator parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of a map. Accepted values are GL_MAP1_COLOR_4, GL_MAP1_INDEX, GL_MAP1_NORMAL, GL_MAP1_TEXTURE_COORD_1, GL_MAP1_TEXTURE_COORD_2, GL_MAP1_TEXTURE_COORD_3, GL_MAP1_TEXTURE_COORD_4, GL_MAP1_VERTEX_3, GL_MAP1_VERTEX_4, GL_MAP2_COLOR_4, GL_MAP2_INDEX, GL_MAP2_NORMAL, GL_MAP2_TEXTURE_COORD_1, GL_MAP2_TEXTURE_COORD_2, GL_MAP2_TEXTURE_COORD_3, GL_MAP2_TEXTURE_COORD_4, GL_MAP2_VERTEX_3, and GL_MAP2_VERTEX_4.
        /// </para>
        /// </param>
        /// <param name="query">
        /// <para>
        /// Specifies which parameter to return. Symbolic names GL_COEFF, GL_ORDER, and GL_DOMAIN are accepted.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        public static
        void GetMap(MonoMac.OpenGL.MapTarget target, MonoMac.OpenGL.GetMapQuery query, [OutAttribute] out Int32 v)
        {
            unsafe
            {
                fixed (Int32* v_ptr = &v)
                {
                    Core.GetMapiv((MonoMac.OpenGL.MapTarget)target, (MonoMac.OpenGL.GetMapQuery)query, (Int32*)v_ptr);
                    v = *v_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return evaluator parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Specifies the symbolic name of a map. Accepted values are GL_MAP1_COLOR_4, GL_MAP1_INDEX, GL_MAP1_NORMAL, GL_MAP1_TEXTURE_COORD_1, GL_MAP1_TEXTURE_COORD_2, GL_MAP1_TEXTURE_COORD_3, GL_MAP1_TEXTURE_COORD_4, GL_MAP1_VERTEX_3, GL_MAP1_VERTEX_4, GL_MAP2_COLOR_4, GL_MAP2_INDEX, GL_MAP2_NORMAL, GL_MAP2_TEXTURE_COORD_1, GL_MAP2_TEXTURE_COORD_2, GL_MAP2_TEXTURE_COORD_3, GL_MAP2_TEXTURE_COORD_4, GL_MAP2_VERTEX_3, and GL_MAP2_VERTEX_4.
        /// </para>
        /// </param>
        /// <param name="query">
        /// <para>
        /// Specifies which parameter to return. Symbolic names GL_COEFF, GL_ORDER, and GL_DOMAIN are accepted.
        /// </para>
        /// </param>
        /// <param name="v">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetMap(MonoMac.OpenGL.MapTarget target, MonoMac.OpenGL.GetMapQuery query, [OutAttribute] Int32* v)
        {
            Core.GetMapiv((MonoMac.OpenGL.MapTarget)target, (MonoMac.OpenGL.GetMapQuery)query, (Int32*)v);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return material parameters
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which of the two materials is being queried. GL_FRONT or GL_BACK are accepted, representing the front and back materials, respectively.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the material parameter to return. GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_EMISSION, GL_SHININESS, and GL_COLOR_INDEXES are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        public static
        void GetMaterial(MonoMac.OpenGL.MaterialFace face, MonoMac.OpenGL.MaterialParameter pname, [OutAttribute] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Core.GetMaterialfv((MonoMac.OpenGL.MaterialFace)face, (MonoMac.OpenGL.MaterialParameter)pname, (Single*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return material parameters
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which of the two materials is being queried. GL_FRONT or GL_BACK are accepted, representing the front and back materials, respectively.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the material parameter to return. GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_EMISSION, GL_SHININESS, and GL_COLOR_INDEXES are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        public static
        void GetMaterial(MonoMac.OpenGL.MaterialFace face, MonoMac.OpenGL.MaterialParameter pname, [OutAttribute] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Core.GetMaterialfv((MonoMac.OpenGL.MaterialFace)face, (MonoMac.OpenGL.MaterialParameter)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return material parameters
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which of the two materials is being queried. GL_FRONT or GL_BACK are accepted, representing the front and back materials, respectively.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the material parameter to return. GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_EMISSION, GL_SHININESS, and GL_COLOR_INDEXES are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetMaterial(MonoMac.OpenGL.MaterialFace face, MonoMac.OpenGL.MaterialParameter pname, [OutAttribute] Single* @params)
        {
            Core.GetMaterialfv((MonoMac.OpenGL.MaterialFace)face, (MonoMac.OpenGL.MaterialParameter)pname, (Single*)@params);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return material parameters
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which of the two materials is being queried. GL_FRONT or GL_BACK are accepted, representing the front and back materials, respectively.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the material parameter to return. GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_EMISSION, GL_SHININESS, and GL_COLOR_INDEXES are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        public static
        void GetMaterial(MonoMac.OpenGL.MaterialFace face, MonoMac.OpenGL.MaterialParameter pname, [OutAttribute] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Core.GetMaterialiv((MonoMac.OpenGL.MaterialFace)face, (MonoMac.OpenGL.MaterialParameter)pname, (Int32*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return material parameters
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which of the two materials is being queried. GL_FRONT or GL_BACK are accepted, representing the front and back materials, respectively.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the material parameter to return. GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_EMISSION, GL_SHININESS, and GL_COLOR_INDEXES are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        public static
        void GetMaterial(MonoMac.OpenGL.MaterialFace face, MonoMac.OpenGL.MaterialParameter pname, [OutAttribute] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Core.GetMaterialiv((MonoMac.OpenGL.MaterialFace)face, (MonoMac.OpenGL.MaterialParameter)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return material parameters
        /// </summary>
        /// <param name="face">
        /// <para>
        /// Specifies which of the two materials is being queried. GL_FRONT or GL_BACK are accepted, representing the front and back materials, respectively.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the material parameter to return. GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_EMISSION, GL_SHININESS, and GL_COLOR_INDEXES are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested data.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetMaterial(MonoMac.OpenGL.MaterialFace face, MonoMac.OpenGL.MaterialParameter pname, [OutAttribute] Int32* @params)
        {
            Core.GetMaterialiv((MonoMac.OpenGL.MaterialFace)face, (MonoMac.OpenGL.MaterialParameter)pname, (Int32*)@params);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get minimum and maximum pixel values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_MINMAX.
        /// </para>
        /// </param>
        /// <param name="reset">
        /// <para>
        /// If GL_TRUE, all entries in the minmax table that are actually returned are reset to their initial values. (Other entries are unaltered.) If GL_FALSE, the minmax table is unaltered.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the data to be returned in values. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="types">
        /// <para>
        /// The type of the data to be returned in values. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="values">
        /// <para>
        /// A pointer to storage for the returned values.
        /// </para>
        /// </param>
        public static
        void GetMinmax(MonoMac.OpenGL.MinmaxTarget target, bool reset, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [OutAttribute] IntPtr values)
        {
            Core.GetMinmax((MonoMac.OpenGL.MinmaxTarget)target, (bool)reset, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)values);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get minimum and maximum pixel values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_MINMAX.
        /// </para>
        /// </param>
        /// <param name="reset">
        /// <para>
        /// If GL_TRUE, all entries in the minmax table that are actually returned are reset to their initial values. (Other entries are unaltered.) If GL_FALSE, the minmax table is unaltered.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the data to be returned in values. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="types">
        /// <para>
        /// The type of the data to be returned in values. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="values">
        /// <para>
        /// A pointer to storage for the returned values.
        /// </para>
        /// </param>
        public static
        void GetMinmax<T4>(MonoMac.OpenGL.MinmaxTarget target, bool reset, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T4[] values)
            where T4 : struct
        {
            GCHandle values_ptr = GCHandle.Alloc(values, GCHandleType.Pinned);
            try
            {
                Core.GetMinmax((MonoMac.OpenGL.MinmaxTarget)target, (bool)reset, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)values_ptr.AddrOfPinnedObject());
            }
            finally
            {
                values_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get minimum and maximum pixel values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_MINMAX.
        /// </para>
        /// </param>
        /// <param name="reset">
        /// <para>
        /// If GL_TRUE, all entries in the minmax table that are actually returned are reset to their initial values. (Other entries are unaltered.) If GL_FALSE, the minmax table is unaltered.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the data to be returned in values. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="types">
        /// <para>
        /// The type of the data to be returned in values. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="values">
        /// <para>
        /// A pointer to storage for the returned values.
        /// </para>
        /// </param>
        public static
        void GetMinmax<T4>(MonoMac.OpenGL.MinmaxTarget target, bool reset, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T4[,] values)
            where T4 : struct
        {
            GCHandle values_ptr = GCHandle.Alloc(values, GCHandleType.Pinned);
            try
            {
                Core.GetMinmax((MonoMac.OpenGL.MinmaxTarget)target, (bool)reset, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)values_ptr.AddrOfPinnedObject());
            }
            finally
            {
                values_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get minimum and maximum pixel values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_MINMAX.
        /// </para>
        /// </param>
        /// <param name="reset">
        /// <para>
        /// If GL_TRUE, all entries in the minmax table that are actually returned are reset to their initial values. (Other entries are unaltered.) If GL_FALSE, the minmax table is unaltered.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the data to be returned in values. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="types">
        /// <para>
        /// The type of the data to be returned in values. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="values">
        /// <para>
        /// A pointer to storage for the returned values.
        /// </para>
        /// </param>
        public static
        void GetMinmax<T4>(MonoMac.OpenGL.MinmaxTarget target, bool reset, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] T4[, ,] values)
            where T4 : struct
        {
            GCHandle values_ptr = GCHandle.Alloc(values, GCHandleType.Pinned);
            try
            {
                Core.GetMinmax((MonoMac.OpenGL.MinmaxTarget)target, (bool)reset, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)values_ptr.AddrOfPinnedObject());
            }
            finally
            {
                values_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get minimum and maximum pixel values
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_MINMAX.
        /// </para>
        /// </param>
        /// <param name="reset">
        /// <para>
        /// If GL_TRUE, all entries in the minmax table that are actually returned are reset to their initial values. (Other entries are unaltered.) If GL_FALSE, the minmax table is unaltered.
        /// </para>
        /// </param>
        /// <param name="format">
        /// <para>
        /// The format of the data to be returned in values. Must be one of GL_RED, GL_GREEN, GL_BLUE, GL_ALPHA, GL_RGB, GL_BGR, GL_RGBA, GL_BGRA, GL_LUMINANCE, or GL_LUMINANCE_ALPHA.
        /// </para>
        /// </param>
        /// <param name="types">
        /// <para>
        /// The type of the data to be returned in values. Symbolic constants GL_UNSIGNED_BYTE, GL_BYTE, GL_BITMAP, GL_UNSIGNED_SHORT, GL_SHORT, GL_UNSIGNED_INT, GL_INT, GL_FLOAT, GL_UNSIGNED_BYTE_3_3_2, GL_UNSIGNED_BYTE_2_3_3_REV, GL_UNSIGNED_SHORT_5_6_5, GL_UNSIGNED_SHORT_5_6_5_REV, GL_UNSIGNED_SHORT_4_4_4_4, GL_UNSIGNED_SHORT_4_4_4_4_REV, GL_UNSIGNED_SHORT_5_5_5_1, GL_UNSIGNED_SHORT_1_5_5_5_REV, GL_UNSIGNED_INT_8_8_8_8, GL_UNSIGNED_INT_8_8_8_8_REV, GL_UNSIGNED_INT_10_10_10_2, and GL_UNSIGNED_INT_2_10_10_10_REV are accepted.
        /// </para>
        /// </param>
        /// <param name="values">
        /// <para>
        /// A pointer to storage for the returned values.
        /// </para>
        /// </param>
        public static
        void GetMinmax<T4>(MonoMac.OpenGL.MinmaxTarget target, bool reset, MonoMac.OpenGL.PixelFormat format, MonoMac.OpenGL.PixelType type, [InAttribute, OutAttribute] ref T4 values)
            where T4 : struct
        {
            GCHandle values_ptr = GCHandle.Alloc(values, GCHandleType.Pinned);
            try
            {
                Core.GetMinmax((MonoMac.OpenGL.MinmaxTarget)target, (bool)reset, (MonoMac.OpenGL.PixelFormat)format, (MonoMac.OpenGL.PixelType)type, (IntPtr)values_ptr.AddrOfPinnedObject());
                values = (T4)values_ptr.Target;
            }
            finally
            {
                values_ptr.Free();
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get minmax parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_MINMAX.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be retrieved. Must be one of GL_MINMAX_FORMAT or GL_MINMAX_SINK.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to storage for the retrieved parameters.
        /// </para>
        /// </param>
        public static
        void GetMinmaxParameter(MonoMac.OpenGL.MinmaxTarget target, MonoMac.OpenGL.GetMinmaxParameterPName pname, [OutAttribute] Single[] @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = @params)
                {
                    Core.GetMinmaxParameterfv((MonoMac.OpenGL.MinmaxTarget)target, (MonoMac.OpenGL.GetMinmaxParameterPName)pname, (Single*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get minmax parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_MINMAX.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be retrieved. Must be one of GL_MINMAX_FORMAT or GL_MINMAX_SINK.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to storage for the retrieved parameters.
        /// </para>
        /// </param>
        public static
        void GetMinmaxParameter(MonoMac.OpenGL.MinmaxTarget target, MonoMac.OpenGL.GetMinmaxParameterPName pname, [OutAttribute] out Single @params)
        {
            unsafe
            {
                fixed (Single* @params_ptr = &@params)
                {
                    Core.GetMinmaxParameterfv((MonoMac.OpenGL.MinmaxTarget)target, (MonoMac.OpenGL.GetMinmaxParameterPName)pname, (Single*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get minmax parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_MINMAX.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be retrieved. Must be one of GL_MINMAX_FORMAT or GL_MINMAX_SINK.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to storage for the retrieved parameters.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetMinmaxParameter(MonoMac.OpenGL.MinmaxTarget target, MonoMac.OpenGL.GetMinmaxParameterPName pname, [OutAttribute] Single* @params)
        {
            Core.GetMinmaxParameterfv((MonoMac.OpenGL.MinmaxTarget)target, (MonoMac.OpenGL.GetMinmaxParameterPName)pname, (Single*)@params);
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get minmax parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_MINMAX.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be retrieved. Must be one of GL_MINMAX_FORMAT or GL_MINMAX_SINK.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to storage for the retrieved parameters.
        /// </para>
        /// </param>
        public static
        void GetMinmaxParameter(MonoMac.OpenGL.MinmaxTarget target, MonoMac.OpenGL.GetMinmaxParameterPName pname, [OutAttribute] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Core.GetMinmaxParameteriv((MonoMac.OpenGL.MinmaxTarget)target, (MonoMac.OpenGL.GetMinmaxParameterPName)pname, (Int32*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get minmax parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_MINMAX.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be retrieved. Must be one of GL_MINMAX_FORMAT or GL_MINMAX_SINK.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to storage for the retrieved parameters.
        /// </para>
        /// </param>
        public static
        void GetMinmaxParameter(MonoMac.OpenGL.MinmaxTarget target, MonoMac.OpenGL.GetMinmaxParameterPName pname, [OutAttribute] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Core.GetMinmaxParameteriv((MonoMac.OpenGL.MinmaxTarget)target, (MonoMac.OpenGL.GetMinmaxParameterPName)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v1.2][deprecated: v3.1]
        /// Get minmax parameters
        /// </summary>
        /// <param name="target">
        /// <para>
        /// Must be GL_MINMAX.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// The parameter to be retrieved. Must be one of GL_MINMAX_FORMAT or GL_MINMAX_SINK.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// A pointer to storage for the retrieved parameters.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetMinmaxParameter(MonoMac.OpenGL.MinmaxTarget target, MonoMac.OpenGL.GetMinmaxParameterPName pname, [OutAttribute] Int32* @params)
        {
            Core.GetMinmaxParameteriv((MonoMac.OpenGL.MinmaxTarget)target, (MonoMac.OpenGL.GetMinmaxParameterPName)pname, (Int32*)@params);
        }


//        /// <summary>[requires: v1.2 and ARB_texture_multisample]
//        /// Retrieve the location of a sample
//        /// </summary>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the sample parameter name. pname must be GL_SAMPLE_POSITION.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the sample whose position to query.
//        /// </para>
//        /// </param>
//        /// <param name="val">
//        /// <para>
//        /// Specifies the address of an array to receive the position of the sample.
//        /// </para>
//        /// </param>
//        public static
//        void GetMultisample(MonoMac.OpenGL.GetMultisamplePName pname, Int32 index, [OutAttribute] Single[] val)
//        {
//                unsafe
//                {
//                    fixed (Single* val_ptr = val)
//                    {
//                        Core.GetMultisamplefv((MonoMac.OpenGL.GetMultisamplePName)pname, (UInt32)index, (Single*)val_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_texture_multisample]
//        /// Retrieve the location of a sample
//        /// </summary>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the sample parameter name. pname must be GL_SAMPLE_POSITION.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the sample whose position to query.
//        /// </para>
//        /// </param>
//        /// <param name="val">
//        /// <para>
//        /// Specifies the address of an array to receive the position of the sample.
//        /// </para>
//        /// </param>
//        public static
//        void GetMultisample(MonoMac.OpenGL.GetMultisamplePName pname, Int32 index, [OutAttribute] out Single val)
//        {
//                unsafe
//                {
//                    fixed (Single* val_ptr = &val)
//                    {
//                        Core.GetMultisamplefv((MonoMac.OpenGL.GetMultisamplePName)pname, (UInt32)index, (Single*)val_ptr);
//                        val = *val_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_texture_multisample]
//        /// Retrieve the location of a sample
//        /// </summary>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the sample parameter name. pname must be GL_SAMPLE_POSITION.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the sample whose position to query.
//        /// </para>
//        /// </param>
//        /// <param name="val">
//        /// <para>
//        /// Specifies the address of an array to receive the position of the sample.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetMultisample(MonoMac.OpenGL.GetMultisamplePName pname, Int32 index, [OutAttribute] Single* val)
//        {
//                Core.GetMultisamplefv((MonoMac.OpenGL.GetMultisamplePName)pname, (UInt32)index, (Single*)val);
//        }


//        /// <summary>[requires: v1.2 and ARB_texture_multisample]
//        /// Retrieve the location of a sample
//        /// </summary>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the sample parameter name. pname must be GL_SAMPLE_POSITION.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the sample whose position to query.
//        /// </para>
//        /// </param>
//        /// <param name="val">
//        /// <para>
//        /// Specifies the address of an array to receive the position of the sample.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetMultisample(MonoMac.OpenGL.GetMultisamplePName pname, UInt32 index, [OutAttribute] Single[] val)
//        {
//                unsafe
//                {
//                    fixed (Single* val_ptr = val)
//                    {
//                        Core.GetMultisamplefv((MonoMac.OpenGL.GetMultisamplePName)pname, (UInt32)index, (Single*)val_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_texture_multisample]
//        /// Retrieve the location of a sample
//        /// </summary>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the sample parameter name. pname must be GL_SAMPLE_POSITION.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the sample whose position to query.
//        /// </para>
//        /// </param>
//        /// <param name="val">
//        /// <para>
//        /// Specifies the address of an array to receive the position of the sample.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetMultisample(MonoMac.OpenGL.GetMultisamplePName pname, UInt32 index, [OutAttribute] out Single val)
//        {
//                unsafe
//                {
//                    fixed (Single* val_ptr = &val)
//                    {
//                        Core.GetMultisamplefv((MonoMac.OpenGL.GetMultisamplePName)pname, (UInt32)index, (Single*)val_ptr);
//                        val = *val_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_texture_multisample]
//        /// Retrieve the location of a sample
//        /// </summary>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the sample parameter name. pname must be GL_SAMPLE_POSITION.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the sample whose position to query.
//        /// </para>
//        /// </param>
//        /// <param name="val">
//        /// <para>
//        /// Specifies the address of an array to receive the position of the sample.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetMultisample(MonoMac.OpenGL.GetMultisamplePName pname, UInt32 index, [OutAttribute] Single* val)
//        {
//                Core.GetMultisamplefv((MonoMac.OpenGL.GetMultisamplePName)pname, (UInt32)index, (Single*)val);
//        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        public static
        void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] Single[] values)
        {
            unsafe
            {
                fixed (Single* values_ptr = values)
                {
                    Core.GetPixelMapfv((MonoMac.OpenGL.PixelMap)map, (Single*)values_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        public static
        void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] out Single values)
        {
            unsafe
            {
                fixed (Single* values_ptr = &values)
                {
                    Core.GetPixelMapfv((MonoMac.OpenGL.PixelMap)map, (Single*)values_ptr);
                    values = *values_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] Single* values)
        {
            Core.GetPixelMapfv((MonoMac.OpenGL.PixelMap)map, (Single*)values);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        public static
        void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] Int32[] values)
        {
            unsafe
            {
                fixed (Int32* values_ptr = values)
                {
                    Core.GetPixelMapuiv((MonoMac.OpenGL.PixelMap)map, (UInt32*)values_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        public static
        void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] out Int32 values)
        {
            unsafe
            {
                fixed (Int32* values_ptr = &values)
                {
                    Core.GetPixelMapuiv((MonoMac.OpenGL.PixelMap)map, (UInt32*)values_ptr);
                    values = *values_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] Int32* values)
        {
            Core.GetPixelMapuiv((MonoMac.OpenGL.PixelMap)map, (UInt32*)values);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] UInt32[] values)
        {
            unsafe
            {
                fixed (UInt32* values_ptr = values)
                {
                    Core.GetPixelMapuiv((MonoMac.OpenGL.PixelMap)map, (UInt32*)values_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] out UInt32 values)
        {
            unsafe
            {
                fixed (UInt32* values_ptr = &values)
                {
                    Core.GetPixelMapuiv((MonoMac.OpenGL.PixelMap)map, (UInt32*)values_ptr);
                    values = *values_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] UInt32* values)
        {
            Core.GetPixelMapuiv((MonoMac.OpenGL.PixelMap)map, (UInt32*)values);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        public static
        void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] Int16[] values)
        {
            unsafe
            {
                fixed (Int16* values_ptr = values)
                {
                    Core.GetPixelMapusv((MonoMac.OpenGL.PixelMap)map, (UInt16*)values_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        public static
        void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] out Int16 values)
        {
            unsafe
            {
                fixed (Int16* values_ptr = &values)
                {
                    Core.GetPixelMapusv((MonoMac.OpenGL.PixelMap)map, (UInt16*)values_ptr);
                    values = *values_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] Int16* values)
        {
            Core.GetPixelMapusv((MonoMac.OpenGL.PixelMap)map, (UInt16*)values);
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] UInt16[] values)
        {
            unsafe
            {
                fixed (UInt16* values_ptr = values)
                {
                    Core.GetPixelMapusv((MonoMac.OpenGL.PixelMap)map, (UInt16*)values_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] out UInt16 values)
        {
            unsafe
            {
                fixed (UInt16* values_ptr = &values)
                {
                    Core.GetPixelMapusv((MonoMac.OpenGL.PixelMap)map, (UInt16*)values_ptr);
                    values = *values_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the specified pixel map
        /// </summary>
        /// <param name="map">
        /// <para>
        /// Specifies the name of the pixel map to return. Accepted values are GL_PIXEL_MAP_I_TO_I, GL_PIXEL_MAP_S_TO_S, GL_PIXEL_MAP_I_TO_R, GL_PIXEL_MAP_I_TO_G, GL_PIXEL_MAP_I_TO_B, GL_PIXEL_MAP_I_TO_A, GL_PIXEL_MAP_R_TO_R, GL_PIXEL_MAP_G_TO_G, GL_PIXEL_MAP_B_TO_B, and GL_PIXEL_MAP_A_TO_A.
        /// </para>
        /// </param>
        /// <param name="data">
        /// <para>
        /// Returns the pixel map contents.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetPixelMap(MonoMac.OpenGL.PixelMap map, [OutAttribute] UInt16* values)
        {
            Core.GetPixelMapusv((MonoMac.OpenGL.PixelMap)map, (UInt16*)values);
        }


        /// <summary>[requires: v1.1]
        /// Return the address of the specified pointer
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies the array or buffer pointer to be returned. Symbolic constants GL_COLOR_ARRAY_POINTER, GL_EDGE_FLAG_ARRAY_POINTER, GL_FOG_COORD_ARRAY_POINTER, GL_FEEDBACK_BUFFER_POINTER, GL_INDEX_ARRAY_POINTER, GL_NORMAL_ARRAY_POINTER, GL_SECONDARY_COLOR_ARRAY_POINTER, GL_SELECTION_BUFFER_POINTER, GL_TEXTURE_COORD_ARRAY_POINTER, or GL_VERTEX_ARRAY_POINTER are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        public static
        void GetPointer(MonoMac.OpenGL.GetPointervPName pname, [OutAttribute] IntPtr @params)
        {
            Core.GetPointerv((MonoMac.OpenGL.GetPointervPName)pname, (IntPtr)@params);
        }


        /// <summary>[requires: v1.1]
        /// Return the address of the specified pointer
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies the array or buffer pointer to be returned. Symbolic constants GL_COLOR_ARRAY_POINTER, GL_EDGE_FLAG_ARRAY_POINTER, GL_FOG_COORD_ARRAY_POINTER, GL_FEEDBACK_BUFFER_POINTER, GL_INDEX_ARRAY_POINTER, GL_NORMAL_ARRAY_POINTER, GL_SECONDARY_COLOR_ARRAY_POINTER, GL_SELECTION_BUFFER_POINTER, GL_TEXTURE_COORD_ARRAY_POINTER, or GL_VERTEX_ARRAY_POINTER are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        public static
        void GetPointer<T1>(MonoMac.OpenGL.GetPointervPName pname, [InAttribute, OutAttribute] T1[] @params)
            where T1 : struct
        {
            GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
            try
            {
                Core.GetPointerv((MonoMac.OpenGL.GetPointervPName)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
            }
            finally
            {
                @params_ptr.Free();
            }
        }


        /// <summary>[requires: v1.1]
        /// Return the address of the specified pointer
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies the array or buffer pointer to be returned. Symbolic constants GL_COLOR_ARRAY_POINTER, GL_EDGE_FLAG_ARRAY_POINTER, GL_FOG_COORD_ARRAY_POINTER, GL_FEEDBACK_BUFFER_POINTER, GL_INDEX_ARRAY_POINTER, GL_NORMAL_ARRAY_POINTER, GL_SECONDARY_COLOR_ARRAY_POINTER, GL_SELECTION_BUFFER_POINTER, GL_TEXTURE_COORD_ARRAY_POINTER, or GL_VERTEX_ARRAY_POINTER are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        public static
        void GetPointer<T1>(MonoMac.OpenGL.GetPointervPName pname, [InAttribute, OutAttribute] T1[,] @params)
            where T1 : struct
        {
            GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
            try
            {
                Core.GetPointerv((MonoMac.OpenGL.GetPointervPName)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
            }
            finally
            {
                @params_ptr.Free();
            }
        }


        /// <summary>[requires: v1.1]
        /// Return the address of the specified pointer
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies the array or buffer pointer to be returned. Symbolic constants GL_COLOR_ARRAY_POINTER, GL_EDGE_FLAG_ARRAY_POINTER, GL_FOG_COORD_ARRAY_POINTER, GL_FEEDBACK_BUFFER_POINTER, GL_INDEX_ARRAY_POINTER, GL_NORMAL_ARRAY_POINTER, GL_SECONDARY_COLOR_ARRAY_POINTER, GL_SELECTION_BUFFER_POINTER, GL_TEXTURE_COORD_ARRAY_POINTER, or GL_VERTEX_ARRAY_POINTER are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        public static
        void GetPointer<T1>(MonoMac.OpenGL.GetPointervPName pname, [InAttribute, OutAttribute] T1[, ,] @params)
            where T1 : struct
        {
            GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
            try
            {
                Core.GetPointerv((MonoMac.OpenGL.GetPointervPName)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
            }
            finally
            {
                @params_ptr.Free();
            }
        }


        /// <summary>[requires: v1.1]
        /// Return the address of the specified pointer
        /// </summary>
        /// <param name="pname">
        /// <para>
        /// Specifies the array or buffer pointer to be returned. Symbolic constants GL_COLOR_ARRAY_POINTER, GL_EDGE_FLAG_ARRAY_POINTER, GL_FOG_COORD_ARRAY_POINTER, GL_FEEDBACK_BUFFER_POINTER, GL_INDEX_ARRAY_POINTER, GL_NORMAL_ARRAY_POINTER, GL_SECONDARY_COLOR_ARRAY_POINTER, GL_SELECTION_BUFFER_POINTER, GL_TEXTURE_COORD_ARRAY_POINTER, or GL_VERTEX_ARRAY_POINTER are accepted.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the pointer value specified by pname.
        /// </para>
        /// </param>
        public static
        void GetPointer<T1>(MonoMac.OpenGL.GetPointervPName pname, [InAttribute, OutAttribute] ref T1 @params)
            where T1 : struct
        {
            GCHandle @params_ptr = GCHandle.Alloc(@params, GCHandleType.Pinned);
            try
            {
                Core.GetPointerv((MonoMac.OpenGL.GetPointervPName)pname, (IntPtr)@params_ptr.AddrOfPinnedObject());
                @params = (T1)@params_ptr.Target;
            }
            finally
            {
                @params_ptr.Free();
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the polygon stipple pattern
        /// </summary>
        /// <param name="pattern">
        /// <para>
        /// Returns the stipple pattern. The initial value is all 1's.
        /// </para>
        /// </param>
        public static
        void GetPolygonStipple([OutAttribute] Byte[] mask)
        {
            unsafe
            {
                fixed (Byte* mask_ptr = mask)
                {
                    Core.GetPolygonStipple((Byte*)mask_ptr);
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the polygon stipple pattern
        /// </summary>
        /// <param name="pattern">
        /// <para>
        /// Returns the stipple pattern. The initial value is all 1's.
        /// </para>
        /// </param>
        public static
        void GetPolygonStipple([OutAttribute] out Byte mask)
        {
            unsafe
            {
                fixed (Byte* mask_ptr = &mask)
                {
                    Core.GetPolygonStipple((Byte*)mask_ptr);
                    mask = *mask_ptr;
                }
            }
        }


        /// <summary>[requires: v1.0][deprecated: v3.1]
        /// Return the polygon stipple pattern
        /// </summary>
        /// <param name="pattern">
        /// <para>
        /// Returns the stipple pattern. The initial value is all 1's.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetPolygonStipple([OutAttribute] Byte* mask)
        {
            Core.GetPolygonStipple((Byte*)mask);
        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        public static
//        void GetProgramBinary(Int32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out MonoMac.OpenGL.BinaryFormat binaryFormat, [OutAttribute] IntPtr binary)
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    fixed (MonoMac.OpenGL.BinaryFormat* binaryFormat_ptr = &binaryFormat)
//                    {
//                        Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (MonoMac.OpenGL.BinaryFormat*)binaryFormat_ptr, (IntPtr)binary);
//                        length = *length_ptr;
//                        binaryFormat = *binaryFormat_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        public static
//        void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out MonoMac.OpenGL.BinaryFormat binaryFormat, [InAttribute, OutAttribute] T4[] binary)
//            where T4 : struct
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    fixed (MonoMac.OpenGL.BinaryFormat* binaryFormat_ptr = &binaryFormat)
//                    {
//                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                        try
//                        {
//                            Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (MonoMac.OpenGL.BinaryFormat*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                            length = *length_ptr;
//                            binaryFormat = *binaryFormat_ptr;
//                        }
//                        finally
//                        {
//                            binary_ptr.Free();
//                        }
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        public static
//        void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out MonoMac.OpenGL.BinaryFormat binaryFormat, [InAttribute, OutAttribute] T4[,] binary)
//            where T4 : struct
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    fixed (MonoMac.OpenGL.BinaryFormat* binaryFormat_ptr = &binaryFormat)
//                    {
//                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                        try
//                        {
//                            Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (MonoMac.OpenGL.BinaryFormat*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                            length = *length_ptr;
//                            binaryFormat = *binaryFormat_ptr;
//                        }
//                        finally
//                        {
//                            binary_ptr.Free();
//                        }
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        public static
//        void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out MonoMac.OpenGL.BinaryFormat binaryFormat, [InAttribute, OutAttribute] T4[, ,] binary)
//            where T4 : struct
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    fixed (MonoMac.OpenGL.BinaryFormat* binaryFormat_ptr = &binaryFormat)
//                    {
//                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                        try
//                        {
//                            Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (MonoMac.OpenGL.BinaryFormat*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                            length = *length_ptr;
//                            binaryFormat = *binaryFormat_ptr;
//                        }
//                        finally
//                        {
//                            binary_ptr.Free();
//                        }
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        public static
//        void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out MonoMac.OpenGL.BinaryFormat binaryFormat, [InAttribute, OutAttribute] ref T4 binary)
//            where T4 : struct
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    fixed (MonoMac.OpenGL.BinaryFormat* binaryFormat_ptr = &binaryFormat)
//                    {
//                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                        try
//                        {
//                            Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (MonoMac.OpenGL.BinaryFormat*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                            length = *length_ptr;
//                            binaryFormat = *binaryFormat_ptr;
//                            binary = (T4)binary_ptr.Target;
//                        }
//                        finally
//                        {
//                            binary_ptr.Free();
//                        }
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramBinary(Int32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] MonoMac.OpenGL.BinaryFormat* binaryFormat, [OutAttribute] IntPtr binary)
//        {
//                Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length, (MonoMac.OpenGL.BinaryFormat*)binaryFormat, (IntPtr)binary);
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] MonoMac.OpenGL.BinaryFormat* binaryFormat, [InAttribute, OutAttribute] T4[] binary)
//            where T4 : struct
//        {
//                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                try
//                {
//                    Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length, (MonoMac.OpenGL.BinaryFormat*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    binary_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] MonoMac.OpenGL.BinaryFormat* binaryFormat, [InAttribute, OutAttribute] T4[,] binary)
//            where T4 : struct
//        {
//                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                try
//                {
//                    Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length, (MonoMac.OpenGL.BinaryFormat*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    binary_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] MonoMac.OpenGL.BinaryFormat* binaryFormat, [InAttribute, OutAttribute] T4[, ,] binary)
//            where T4 : struct
//        {
//                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                try
//                {
//                    Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length, (MonoMac.OpenGL.BinaryFormat*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    binary_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramBinary<T4>(Int32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] MonoMac.OpenGL.BinaryFormat* binaryFormat, [InAttribute, OutAttribute] ref T4 binary)
//            where T4 : struct
//        {
//                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                try
//                {
//                    Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length, (MonoMac.OpenGL.BinaryFormat*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                    binary = (T4)binary_ptr.Target;
//                }
//                finally
//                {
//                    binary_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetProgramBinary(UInt32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out MonoMac.OpenGL.BinaryFormat binaryFormat, [OutAttribute] IntPtr binary)
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    fixed (MonoMac.OpenGL.BinaryFormat* binaryFormat_ptr = &binaryFormat)
//                    {
//                        Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (MonoMac.OpenGL.BinaryFormat*)binaryFormat_ptr, (IntPtr)binary);
//                        length = *length_ptr;
//                        binaryFormat = *binaryFormat_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out MonoMac.OpenGL.BinaryFormat binaryFormat, [InAttribute, OutAttribute] T4[] binary)
//            where T4 : struct
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    fixed (MonoMac.OpenGL.BinaryFormat* binaryFormat_ptr = &binaryFormat)
//                    {
//                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                        try
//                        {
//                            Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (MonoMac.OpenGL.BinaryFormat*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                            length = *length_ptr;
//                            binaryFormat = *binaryFormat_ptr;
//                        }
//                        finally
//                        {
//                            binary_ptr.Free();
//                        }
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out MonoMac.OpenGL.BinaryFormat binaryFormat, [InAttribute, OutAttribute] T4[,] binary)
//            where T4 : struct
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    fixed (MonoMac.OpenGL.BinaryFormat* binaryFormat_ptr = &binaryFormat)
//                    {
//                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                        try
//                        {
//                            Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (MonoMac.OpenGL.BinaryFormat*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                            length = *length_ptr;
//                            binaryFormat = *binaryFormat_ptr;
//                        }
//                        finally
//                        {
//                            binary_ptr.Free();
//                        }
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out MonoMac.OpenGL.BinaryFormat binaryFormat, [InAttribute, OutAttribute] T4[, ,] binary)
//            where T4 : struct
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    fixed (MonoMac.OpenGL.BinaryFormat* binaryFormat_ptr = &binaryFormat)
//                    {
//                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                        try
//                        {
//                            Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (MonoMac.OpenGL.BinaryFormat*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                            length = *length_ptr;
//                            binaryFormat = *binaryFormat_ptr;
//                        }
//                        finally
//                        {
//                            binary_ptr.Free();
//                        }
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] out MonoMac.OpenGL.BinaryFormat binaryFormat, [InAttribute, OutAttribute] ref T4 binary)
//            where T4 : struct
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    fixed (MonoMac.OpenGL.BinaryFormat* binaryFormat_ptr = &binaryFormat)
//                    {
//                        GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                        try
//                        {
//                            Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (MonoMac.OpenGL.BinaryFormat*)binaryFormat_ptr, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                            length = *length_ptr;
//                            binaryFormat = *binaryFormat_ptr;
//                            binary = (T4)binary_ptr.Target;
//                        }
//                        finally
//                        {
//                            binary_ptr.Free();
//                        }
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramBinary(UInt32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] MonoMac.OpenGL.BinaryFormat* binaryFormat, [OutAttribute] IntPtr binary)
//        {
//                Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length, (MonoMac.OpenGL.BinaryFormat*)binaryFormat, (IntPtr)binary);
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] MonoMac.OpenGL.BinaryFormat* binaryFormat, [InAttribute, OutAttribute] T4[] binary)
//            where T4 : struct
//        {
//                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                try
//                {
//                    Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length, (MonoMac.OpenGL.BinaryFormat*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    binary_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] MonoMac.OpenGL.BinaryFormat* binaryFormat, [InAttribute, OutAttribute] T4[,] binary)
//            where T4 : struct
//        {
//                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                try
//                {
//                    Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length, (MonoMac.OpenGL.BinaryFormat*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    binary_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] MonoMac.OpenGL.BinaryFormat* binaryFormat, [InAttribute, OutAttribute] T4[, ,] binary)
//            where T4 : struct
//        {
//                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                try
//                {
//                    Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length, (MonoMac.OpenGL.BinaryFormat*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                }
//                finally
//                {
//                    binary_ptr.Free();
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_get_program_binary]
//        /// Return a binary representation of a program object's compiled and linked executable source
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of a program object whose binary representation to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the size of the buffer whose address is given by binary.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable to receive the number of bytes written into binary.
//        /// </para>
//        /// </param>
//        /// <param name="binaryFormat">
//        /// <para>
//        /// Specifies the address of a variable to receive a token indicating the format of the binary data returned by the GL.
//        /// </para>
//        /// </param>
//        /// <param name="binary">
//        /// <para>
//        /// Specifies the address an array into which the GL will return program's binary representation.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramBinary<T4>(UInt32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] MonoMac.OpenGL.BinaryFormat* binaryFormat, [InAttribute, OutAttribute] ref T4 binary)
//            where T4 : struct
//        {
//                GCHandle binary_ptr = GCHandle.Alloc(binary, GCHandleType.Pinned);
//                try
//                {
//                    Core.GetProgramBinary((UInt32)program, (Int32)bufSize, (Int32*)length, (MonoMac.OpenGL.BinaryFormat*)binaryFormat, (IntPtr)binary_ptr.AddrOfPinnedObject());
//                    binary = (T4)binary_ptr.Target;
//                }
//                finally
//                {
//                    binary_ptr.Free();
//                }
//        }


        /// <summary>[requires: v2.0]
        /// Returns the information log for a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        public static
        void GetProgramInfoLog(Int32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder infoLog)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Core.GetProgramInfoLog((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)infoLog);
                    length = *length_ptr;
                }
            }
        }


        /// <summary>[requires: v2.0]
        /// Returns the information log for a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetProgramInfoLog(Int32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder infoLog)
        {
            Core.GetProgramInfoLog((UInt32)program, (Int32)bufSize, (Int32*)length, (StringBuilder)infoLog);
        }


        /// <summary>[requires: v2.0]
        /// Returns the information log for a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GetProgramInfoLog(UInt32 program, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder infoLog)
        {
            unsafe
            {
                fixed (Int32* length_ptr = &length)
                {
                    Core.GetProgramInfoLog((UInt32)program, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)infoLog);
                    length = *length_ptr;
                }
            }
        }


        /// <summary>[requires: v2.0]
        /// Returns the information log for a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object whose information log is to be queried.
        /// </para>
        /// </param>
        /// <param name="maxLength">
        /// <para>
        /// Specifies the size of the character buffer for storing the returned information log.
        /// </para>
        /// </param>
        /// <param name="length">
        /// <para>
        /// Returns the length of the string returned in infoLog (excluding the null terminator).
        /// </para>
        /// </param>
        /// <param name="infoLog">
        /// <para>
        /// Specifies an array of characters that is used to return the information log.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetProgramInfoLog(UInt32 program, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder infoLog)
        {
            Core.GetProgramInfoLog((UInt32)program, (Int32)bufSize, (Int32*)length, (StringBuilder)infoLog);
        }


        /// <summary>[requires: v2.0]
        /// Returns a parameter from a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS, GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS, GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS, GL_ACTIVE_UNIFORM_BLOCKS, GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH, GL_ACTIVE_UNIFORM_MAX_LENGTH, GL_PROGRAM_BINARY_LENGTH, GL_TRANSFORM_FEEDBACK_BUFFER_MODE, GL_TRANSFORM_FEEDBACK_VARYINGS, GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH, GL_GEOMETRY_VERTICES_OUT, GL_GEOMETRY_INPUT_TYPE, and GL_GEOMETRY_OUTPUT_TYPE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        public static
        void GetProgram(Int32 program, MonoMac.OpenGL.ProgramParameter pname, [OutAttribute] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Core.GetProgramiv((UInt32)program, (MonoMac.OpenGL.ProgramParameter)pname, (Int32*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v2.0]
        /// Returns a parameter from a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS, GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS, GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS, GL_ACTIVE_UNIFORM_BLOCKS, GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH, GL_ACTIVE_UNIFORM_MAX_LENGTH, GL_PROGRAM_BINARY_LENGTH, GL_TRANSFORM_FEEDBACK_BUFFER_MODE, GL_TRANSFORM_FEEDBACK_VARYINGS, GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH, GL_GEOMETRY_VERTICES_OUT, GL_GEOMETRY_INPUT_TYPE, and GL_GEOMETRY_OUTPUT_TYPE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        public static
        void GetProgram(Int32 program, MonoMac.OpenGL.ProgramParameter pname, [OutAttribute] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Core.GetProgramiv((UInt32)program, (MonoMac.OpenGL.ProgramParameter)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v2.0]
        /// Returns a parameter from a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS, GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS, GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS, GL_ACTIVE_UNIFORM_BLOCKS, GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH, GL_ACTIVE_UNIFORM_MAX_LENGTH, GL_PROGRAM_BINARY_LENGTH, GL_TRANSFORM_FEEDBACK_BUFFER_MODE, GL_TRANSFORM_FEEDBACK_VARYINGS, GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH, GL_GEOMETRY_VERTICES_OUT, GL_GEOMETRY_INPUT_TYPE, and GL_GEOMETRY_OUTPUT_TYPE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetProgram(Int32 program, MonoMac.OpenGL.ProgramParameter pname, [OutAttribute] Int32* @params)
        {
            Core.GetProgramiv((UInt32)program, (MonoMac.OpenGL.ProgramParameter)pname, (Int32*)@params);
        }


        /// <summary>[requires: v2.0]
        /// Returns a parameter from a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS, GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS, GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS, GL_ACTIVE_UNIFORM_BLOCKS, GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH, GL_ACTIVE_UNIFORM_MAX_LENGTH, GL_PROGRAM_BINARY_LENGTH, GL_TRANSFORM_FEEDBACK_BUFFER_MODE, GL_TRANSFORM_FEEDBACK_VARYINGS, GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH, GL_GEOMETRY_VERTICES_OUT, GL_GEOMETRY_INPUT_TYPE, and GL_GEOMETRY_OUTPUT_TYPE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GetProgram(UInt32 program, MonoMac.OpenGL.ProgramParameter pname, [OutAttribute] Int32[] @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = @params)
                {
                    Core.GetProgramiv((UInt32)program, (MonoMac.OpenGL.ProgramParameter)pname, (Int32*)@params_ptr);
                }
            }
        }


        /// <summary>[requires: v2.0]
        /// Returns a parameter from a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS, GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS, GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS, GL_ACTIVE_UNIFORM_BLOCKS, GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH, GL_ACTIVE_UNIFORM_MAX_LENGTH, GL_PROGRAM_BINARY_LENGTH, GL_TRANSFORM_FEEDBACK_BUFFER_MODE, GL_TRANSFORM_FEEDBACK_VARYINGS, GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH, GL_GEOMETRY_VERTICES_OUT, GL_GEOMETRY_INPUT_TYPE, and GL_GEOMETRY_OUTPUT_TYPE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        void GetProgram(UInt32 program, MonoMac.OpenGL.ProgramParameter pname, [OutAttribute] out Int32 @params)
        {
            unsafe
            {
                fixed (Int32* @params_ptr = &@params)
                {
                    Core.GetProgramiv((UInt32)program, (MonoMac.OpenGL.ProgramParameter)pname, (Int32*)@params_ptr);
                    @params = *@params_ptr;
                }
            }
        }


        /// <summary>[requires: v2.0]
        /// Returns a parameter from a program object
        /// </summary>
        /// <param name="program">
        /// <para>
        /// Specifies the program object to be queried.
        /// </para>
        /// </param>
        /// <param name="pname">
        /// <para>
        /// Specifies the object parameter. Accepted symbolic names are GL_DELETE_STATUS, GL_LINK_STATUS, GL_VALIDATE_STATUS, GL_INFO_LOG_LENGTH, GL_ATTACHED_SHADERS, GL_ACTIVE_ATTRIBUTES, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, GL_ACTIVE_UNIFORMS, GL_ACTIVE_UNIFORM_BLOCKS, GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH, GL_ACTIVE_UNIFORM_MAX_LENGTH, GL_PROGRAM_BINARY_LENGTH, GL_TRANSFORM_FEEDBACK_BUFFER_MODE, GL_TRANSFORM_FEEDBACK_VARYINGS, GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH, GL_GEOMETRY_VERTICES_OUT, GL_GEOMETRY_INPUT_TYPE, and GL_GEOMETRY_OUTPUT_TYPE.
        /// </para>
        /// </param>
        /// <param name="params">
        /// <para>
        /// Returns the requested object parameter.
        /// </para>
        /// </param>
        [System.CLSCompliant(false)]
        public static
        unsafe void GetProgram(UInt32 program, MonoMac.OpenGL.ProgramParameter pname, [OutAttribute] Int32* @params)
        {
            Core.GetProgramiv((UInt32)program, (MonoMac.OpenGL.ProgramParameter)pname, (Int32*)@params);
        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Retrieve the info log string from a program pipeline object
//        /// </summary>
//        /// <param name="pipeline">
//        /// <para>
//        /// Specifies the name of a program pipeline object from which to retrieve the info log.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the maximum number of characters, including the null terminator, that may be written into infoLog.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable into which will be written the number of characters written into infoLog.
//        /// </para>
//        /// </param>
//        /// <param name="infoLog">
//        /// <para>
//        /// Specifies the address of an array of characters into which will be written the info log for pipeline.
//        /// </para>
//        /// </param>
//        public static
//        void GetProgramPipelineInfoLog(Int32 pipeline, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder infoLog)
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    {
//                        Core.GetProgramPipelineInfoLog((UInt32)pipeline, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)infoLog);
//                        length = *length_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Retrieve the info log string from a program pipeline object
//        /// </summary>
//        /// <param name="pipeline">
//        /// <para>
//        /// Specifies the name of a program pipeline object from which to retrieve the info log.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the maximum number of characters, including the null terminator, that may be written into infoLog.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable into which will be written the number of characters written into infoLog.
//        /// </para>
//        /// </param>
//        /// <param name="infoLog">
//        /// <para>
//        /// Specifies the address of an array of characters into which will be written the info log for pipeline.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramPipelineInfoLog(Int32 pipeline, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder infoLog)
//        {
//                Core.GetProgramPipelineInfoLog((UInt32)pipeline, (Int32)bufSize, (Int32*)length, (StringBuilder)infoLog);
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Retrieve the info log string from a program pipeline object
//        /// </summary>
//        /// <param name="pipeline">
//        /// <para>
//        /// Specifies the name of a program pipeline object from which to retrieve the info log.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the maximum number of characters, including the null terminator, that may be written into infoLog.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable into which will be written the number of characters written into infoLog.
//        /// </para>
//        /// </param>
//        /// <param name="infoLog">
//        /// <para>
//        /// Specifies the address of an array of characters into which will be written the info log for pipeline.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetProgramPipelineInfoLog(UInt32 pipeline, Int32 bufSize, [OutAttribute] out Int32 length, [OutAttribute] StringBuilder infoLog)
//        {
//                unsafe
//                {
//                    fixed (Int32* length_ptr = &length)
//                    {
//                        Core.GetProgramPipelineInfoLog((UInt32)pipeline, (Int32)bufSize, (Int32*)length_ptr, (StringBuilder)infoLog);
//                        length = *length_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Retrieve the info log string from a program pipeline object
//        /// </summary>
//        /// <param name="pipeline">
//        /// <para>
//        /// Specifies the name of a program pipeline object from which to retrieve the info log.
//        /// </para>
//        /// </param>
//        /// <param name="bufSize">
//        /// <para>
//        /// Specifies the maximum number of characters, including the null terminator, that may be written into infoLog.
//        /// </para>
//        /// </param>
//        /// <param name="length">
//        /// <para>
//        /// Specifies the address of a variable into which will be written the number of characters written into infoLog.
//        /// </para>
//        /// </param>
//        /// <param name="infoLog">
//        /// <para>
//        /// Specifies the address of an array of characters into which will be written the info log for pipeline.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramPipelineInfoLog(UInt32 pipeline, Int32 bufSize, [OutAttribute] Int32* length, [OutAttribute] StringBuilder infoLog)
//        {
//                Core.GetProgramPipelineInfoLog((UInt32)pipeline, (Int32)bufSize, (Int32*)length, (StringBuilder)infoLog);
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Retrieve properties of a program pipeline object
//        /// </summary>
//        /// <param name="pipeline">
//        /// <para>
//        /// Specifies the name of a program pipeline object whose parameter retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the name of the parameter to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable into which will be written the value or values of pname for pipeline.
//        /// </para>
//        /// </param>
//        public static
//        void GetProgramPipeline(Int32 pipeline, MonoMac.OpenGL.ProgramPipelineParameter pname, [OutAttribute] Int32[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = @params)
//                    {
//                        Core.GetProgramPipelineiv((UInt32)pipeline, (MonoMac.OpenGL.ProgramPipelineParameter)pname, (Int32*)@params_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Retrieve properties of a program pipeline object
//        /// </summary>
//        /// <param name="pipeline">
//        /// <para>
//        /// Specifies the name of a program pipeline object whose parameter retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the name of the parameter to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable into which will be written the value or values of pname for pipeline.
//        /// </para>
//        /// </param>
//        public static
//        void GetProgramPipeline(Int32 pipeline, MonoMac.OpenGL.ProgramPipelineParameter pname, [OutAttribute] out Int32 @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = &@params)
//                    {
//                        Core.GetProgramPipelineiv((UInt32)pipeline, (MonoMac.OpenGL.ProgramPipelineParameter)pname, (Int32*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Retrieve properties of a program pipeline object
//        /// </summary>
//        /// <param name="pipeline">
//        /// <para>
//        /// Specifies the name of a program pipeline object whose parameter retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the name of the parameter to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable into which will be written the value or values of pname for pipeline.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramPipeline(Int32 pipeline, MonoMac.OpenGL.ProgramPipelineParameter pname, [OutAttribute] Int32* @params)
//        {
//                Core.GetProgramPipelineiv((UInt32)pipeline, (MonoMac.OpenGL.ProgramPipelineParameter)pname, (Int32*)@params);
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Retrieve properties of a program pipeline object
//        /// </summary>
//        /// <param name="pipeline">
//        /// <para>
//        /// Specifies the name of a program pipeline object whose parameter retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the name of the parameter to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable into which will be written the value or values of pname for pipeline.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetProgramPipeline(UInt32 pipeline, MonoMac.OpenGL.ProgramPipelineParameter pname, [OutAttribute] Int32[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = @params)
//                    {
//                        Core.GetProgramPipelineiv((UInt32)pipeline, (MonoMac.OpenGL.ProgramPipelineParameter)pname, (Int32*)@params_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Retrieve properties of a program pipeline object
//        /// </summary>
//        /// <param name="pipeline">
//        /// <para>
//        /// Specifies the name of a program pipeline object whose parameter retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the name of the parameter to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable into which will be written the value or values of pname for pipeline.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetProgramPipeline(UInt32 pipeline, MonoMac.OpenGL.ProgramPipelineParameter pname, [OutAttribute] out Int32 @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = &@params)
//                    {
//                        Core.GetProgramPipelineiv((UInt32)pipeline, (MonoMac.OpenGL.ProgramPipelineParameter)pname, (Int32*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v4.1 and ARB_separate_shader_objects]
//        /// Retrieve properties of a program pipeline object
//        /// </summary>
//        /// <param name="pipeline">
//        /// <para>
//        /// Specifies the name of a program pipeline object whose parameter retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the name of the parameter to retrieve.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Specifies the address of a variable into which will be written the value or values of pname for pipeline.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramPipeline(UInt32 pipeline, MonoMac.OpenGL.ProgramPipelineParameter pname, [OutAttribute] Int32* @params)
//        {
//                Core.GetProgramPipelineiv((UInt32)pipeline, (MonoMac.OpenGL.ProgramPipelineParameter)pname, (Int32*)@params);
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Retrieve properties of a program object corresponding to a specified shader stage
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing shader stage.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query for the subroutine parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the parameter of the shader to query. pname must be GL_ACTIVE_SUBROUTINE_UNIFORMS, GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS, GL_ACTIVE_SUBROUTINES, GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH, or GL_ACTIVE_SUBROUTINE_MAX_LENGTH.
//        /// </para>
//        /// </param>
//        /// <param name="values">
//        /// <para>
//        /// Specifies the address of a variable into which the queried value or values will be placed.
//        /// </para>
//        /// </param>
//        public static
//        void GetProgramStage(Int32 program, MonoMac.OpenGL.ShaderType shadertype, MonoMac.OpenGL.ProgramStageParameter pname, [OutAttribute] out Int32 values)
//        {
//                unsafe
//                {
//                    fixed (Int32* values_ptr = &values)
//                    {
//                        Core.GetProgramStageiv((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (MonoMac.OpenGL.ProgramStageParameter)pname, (Int32*)values_ptr);
//                        values = *values_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Retrieve properties of a program object corresponding to a specified shader stage
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing shader stage.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query for the subroutine parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the parameter of the shader to query. pname must be GL_ACTIVE_SUBROUTINE_UNIFORMS, GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS, GL_ACTIVE_SUBROUTINES, GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH, or GL_ACTIVE_SUBROUTINE_MAX_LENGTH.
//        /// </para>
//        /// </param>
//        /// <param name="values">
//        /// <para>
//        /// Specifies the address of a variable into which the queried value or values will be placed.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramStage(Int32 program, MonoMac.OpenGL.ShaderType shadertype, MonoMac.OpenGL.ProgramStageParameter pname, [OutAttribute] Int32* values)
//        {
//                Core.GetProgramStageiv((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (MonoMac.OpenGL.ProgramStageParameter)pname, (Int32*)values);
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Retrieve properties of a program object corresponding to a specified shader stage
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing shader stage.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query for the subroutine parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the parameter of the shader to query. pname must be GL_ACTIVE_SUBROUTINE_UNIFORMS, GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS, GL_ACTIVE_SUBROUTINES, GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH, or GL_ACTIVE_SUBROUTINE_MAX_LENGTH.
//        /// </para>
//        /// </param>
//        /// <param name="values">
//        /// <para>
//        /// Specifies the address of a variable into which the queried value or values will be placed.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetProgramStage(UInt32 program, MonoMac.OpenGL.ShaderType shadertype, MonoMac.OpenGL.ProgramStageParameter pname, [OutAttribute] out Int32 values)
//        {
//                unsafe
//                {
//                    fixed (Int32* values_ptr = &values)
//                    {
//                        Core.GetProgramStageiv((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (MonoMac.OpenGL.ProgramStageParameter)pname, (Int32*)values_ptr);
//                        values = *values_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_shader_subroutine]
//        /// Retrieve properties of a program object corresponding to a specified shader stage
//        /// </summary>
//        /// <param name="program">
//        /// <para>
//        /// Specifies the name of the program containing shader stage.
//        /// </para>
//        /// </param>
//        /// <param name="shadertype">
//        /// <para>
//        /// Specifies the shader stage from which to query for the subroutine parameter. shadertype must be one of GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER or GL_FRAGMENT_SHADER.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the parameter of the shader to query. pname must be GL_ACTIVE_SUBROUTINE_UNIFORMS, GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS, GL_ACTIVE_SUBROUTINES, GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH, or GL_ACTIVE_SUBROUTINE_MAX_LENGTH.
//        /// </para>
//        /// </param>
//        /// <param name="values">
//        /// <para>
//        /// Specifies the address of a variable into which the queried value or values will be placed.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetProgramStage(UInt32 program, MonoMac.OpenGL.ShaderType shadertype, MonoMac.OpenGL.ProgramStageParameter pname, [OutAttribute] Int32* values)
//        {
//                Core.GetProgramStageiv((UInt32)program, (MonoMac.OpenGL.ShaderType)shadertype, (MonoMac.OpenGL.ProgramStageParameter)pname, (Int32*)values);
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback3]
//        /// Return parameters of an indexed query object target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies a query object target. Must be GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, GL_TIME_ELAPSED, or GL_TIMESTAMP.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the query object target.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object target parameter. Accepted values are GL_CURRENT_QUERY or GL_QUERY_COUNTER_BITS.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        public static
//        void GetQueryIndexed(MonoMac.OpenGL.QueryTarget target, Int32 index, MonoMac.OpenGL.GetQueryParam pname, [OutAttribute] Int32[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = @params)
//                    {
//                        Core.GetQueryIndexediv((MonoMac.OpenGL.QueryTarget)target, (UInt32)index, (MonoMac.OpenGL.GetQueryParam)pname, (Int32*)@params_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback3]
//        /// Return parameters of an indexed query object target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies a query object target. Must be GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, GL_TIME_ELAPSED, or GL_TIMESTAMP.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the query object target.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object target parameter. Accepted values are GL_CURRENT_QUERY or GL_QUERY_COUNTER_BITS.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        public static
//        void GetQueryIndexed(MonoMac.OpenGL.QueryTarget target, Int32 index, MonoMac.OpenGL.GetQueryParam pname, [OutAttribute] out Int32 @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = &@params)
//                    {
//                        Core.GetQueryIndexediv((MonoMac.OpenGL.QueryTarget)target, (UInt32)index, (MonoMac.OpenGL.GetQueryParam)pname, (Int32*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback3]
//        /// Return parameters of an indexed query object target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies a query object target. Must be GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, GL_TIME_ELAPSED, or GL_TIMESTAMP.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the query object target.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object target parameter. Accepted values are GL_CURRENT_QUERY or GL_QUERY_COUNTER_BITS.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetQueryIndexed(MonoMac.OpenGL.QueryTarget target, Int32 index, MonoMac.OpenGL.GetQueryParam pname, [OutAttribute] Int32* @params)
//        {
//                Core.GetQueryIndexediv((MonoMac.OpenGL.QueryTarget)target, (UInt32)index, (MonoMac.OpenGL.GetQueryParam)pname, (Int32*)@params);
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback3]
//        /// Return parameters of an indexed query object target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies a query object target. Must be GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, GL_TIME_ELAPSED, or GL_TIMESTAMP.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the query object target.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object target parameter. Accepted values are GL_CURRENT_QUERY or GL_QUERY_COUNTER_BITS.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetQueryIndexed(MonoMac.OpenGL.QueryTarget target, UInt32 index, MonoMac.OpenGL.GetQueryParam pname, [OutAttribute] Int32[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = @params)
//                    {
//                        Core.GetQueryIndexediv((MonoMac.OpenGL.QueryTarget)target, (UInt32)index, (MonoMac.OpenGL.GetQueryParam)pname, (Int32*)@params_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback3]
//        /// Return parameters of an indexed query object target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies a query object target. Must be GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, GL_TIME_ELAPSED, or GL_TIMESTAMP.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the query object target.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object target parameter. Accepted values are GL_CURRENT_QUERY or GL_QUERY_COUNTER_BITS.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetQueryIndexed(MonoMac.OpenGL.QueryTarget target, UInt32 index, MonoMac.OpenGL.GetQueryParam pname, [OutAttribute] out Int32 @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = &@params)
//                    {
//                        Core.GetQueryIndexediv((MonoMac.OpenGL.QueryTarget)target, (UInt32)index, (MonoMac.OpenGL.GetQueryParam)pname, (Int32*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.2 and ARB_transform_feedback3]
//        /// Return parameters of an indexed query object target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies a query object target. Must be GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, GL_TIME_ELAPSED, or GL_TIMESTAMP.
//        /// </para>
//        /// </param>
//        /// <param name="index">
//        /// <para>
//        /// Specifies the index of the query object target.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object target parameter. Accepted values are GL_CURRENT_QUERY or GL_QUERY_COUNTER_BITS.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetQueryIndexed(MonoMac.OpenGL.QueryTarget target, UInt32 index, MonoMac.OpenGL.GetQueryParam pname, [OutAttribute] Int32* @params)
//        {
//                Core.GetQueryIndexediv((MonoMac.OpenGL.QueryTarget)target, (UInt32)index, (MonoMac.OpenGL.GetQueryParam)pname, (Int32*)@params);
//        }


//        /// <summary>[requires: v1.5]
//        /// Return parameters of a query object target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies a query object target. Must be GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, GL_TIME_ELAPSED, or GL_TIMESTAMP.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object target parameter. Accepted values are GL_CURRENT_QUERY or GL_QUERY_COUNTER_BITS.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        public static
//        void GetQuery(MonoMac.OpenGL.QueryTarget target, MonoMac.OpenGL.GetQueryParam pname, [OutAttribute] Int32[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = @params)
//                    {
//                        Core.GetQueryiv((MonoMac.OpenGL.QueryTarget)target, (MonoMac.OpenGL.GetQueryParam)pname, (Int32*)@params_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.5]
//        /// Return parameters of a query object target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies a query object target. Must be GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, GL_TIME_ELAPSED, or GL_TIMESTAMP.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object target parameter. Accepted values are GL_CURRENT_QUERY or GL_QUERY_COUNTER_BITS.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        public static
//        void GetQuery(MonoMac.OpenGL.QueryTarget target, MonoMac.OpenGL.GetQueryParam pname, [OutAttribute] out Int32 @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = &@params)
//                    {
//                        Core.GetQueryiv((MonoMac.OpenGL.QueryTarget)target, (MonoMac.OpenGL.GetQueryParam)pname, (Int32*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.5]
//        /// Return parameters of a query object target
//        /// </summary>
//        /// <param name="target">
//        /// <para>
//        /// Specifies a query object target. Must be GL_SAMPLES_PASSED, GL_ANY_SAMPLES_PASSED, GL_PRIMITIVES_GENERATED, GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, GL_TIME_ELAPSED, or GL_TIMESTAMP.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object target parameter. Accepted values are GL_CURRENT_QUERY or GL_QUERY_COUNTER_BITS.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetQuery(MonoMac.OpenGL.QueryTarget target, MonoMac.OpenGL.GetQueryParam pname, [OutAttribute] Int32* @params)
//        {
//                Core.GetQueryiv((MonoMac.OpenGL.QueryTarget)target, (MonoMac.OpenGL.GetQueryParam)pname, (Int32*)@params);
//        }

//        /// <summary>[requires: v1.2 and ARB_timer_query]</summary>
//        public static
//        void GetQueryObjecti64(Int32 id, MonoMac.OpenGL.ArbTimerQuery pname, [OutAttribute] Int64[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int64* @params_ptr = @params)
//                    {
//                        Core.GetQueryObjecti64v((UInt32)id, (MonoMac.OpenGL.ArbTimerQuery)pname, (Int64*)@params_ptr);
//                    }
//                }
//        }

//        /// <summary>[requires: v1.2 and ARB_timer_query]</summary>
//        public static
//        void GetQueryObjecti64(Int32 id, MonoMac.OpenGL.ArbTimerQuery pname, [OutAttribute] out Int64 @params)
//        {
//                unsafe
//                {
//                    fixed (Int64* @params_ptr = &@params)
//                    {
//                        Core.GetQueryObjecti64v((UInt32)id, (MonoMac.OpenGL.ArbTimerQuery)pname, (Int64*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }

//        /// <summary>[requires: v1.2 and ARB_timer_query]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetQueryObjecti64(Int32 id, MonoMac.OpenGL.ArbTimerQuery pname, [OutAttribute] Int64* @params)
//        {
//                Core.GetQueryObjecti64v((UInt32)id, (MonoMac.OpenGL.ArbTimerQuery)pname, (Int64*)@params);
//        }

//        /// <summary>[requires: v1.2 and ARB_timer_query]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void GetQueryObjecti64(UInt32 id, MonoMac.OpenGL.ArbTimerQuery pname, [OutAttribute] Int64[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int64* @params_ptr = @params)
//                    {
//                        Core.GetQueryObjecti64v((UInt32)id, (MonoMac.OpenGL.ArbTimerQuery)pname, (Int64*)@params_ptr);
//                    }
//                }
//        }

//        /// <summary>[requires: v1.2 and ARB_timer_query]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void GetQueryObjecti64(UInt32 id, MonoMac.OpenGL.ArbTimerQuery pname, [OutAttribute] out Int64 @params)
//        {
//                unsafe
//                {
//                    fixed (Int64* @params_ptr = &@params)
//                    {
//                        Core.GetQueryObjecti64v((UInt32)id, (MonoMac.OpenGL.ArbTimerQuery)pname, (Int64*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }

//        /// <summary>[requires: v1.2 and ARB_timer_query]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetQueryObjecti64(UInt32 id, MonoMac.OpenGL.ArbTimerQuery pname, [OutAttribute] Int64* @params)
//        {
//                Core.GetQueryObjecti64v((UInt32)id, (MonoMac.OpenGL.ArbTimerQuery)pname, (Int64*)@params);
//        }


//        /// <summary>[requires: v1.5]
//        /// Return parameters of a query object
//        /// </summary>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a query object.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        public static
//        void GetQueryObject(Int32 id, MonoMac.OpenGL.GetQueryObjectParam pname, [OutAttribute] Int32[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = @params)
//                    {
//                        Core.GetQueryObjectiv((UInt32)id, (MonoMac.OpenGL.GetQueryObjectParam)pname, (Int32*)@params_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.5]
//        /// Return parameters of a query object
//        /// </summary>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a query object.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        public static
//        void GetQueryObject(Int32 id, MonoMac.OpenGL.GetQueryObjectParam pname, [OutAttribute] out Int32 @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = &@params)
//                    {
//                        Core.GetQueryObjectiv((UInt32)id, (MonoMac.OpenGL.GetQueryObjectParam)pname, (Int32*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.5]
//        /// Return parameters of a query object
//        /// </summary>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a query object.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetQueryObject(Int32 id, MonoMac.OpenGL.GetQueryObjectParam pname, [OutAttribute] Int32* @params)
//        {
//                Core.GetQueryObjectiv((UInt32)id, (MonoMac.OpenGL.GetQueryObjectParam)pname, (Int32*)@params);
//        }


//        /// <summary>[requires: v1.5]
//        /// Return parameters of a query object
//        /// </summary>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a query object.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetQueryObject(UInt32 id, MonoMac.OpenGL.GetQueryObjectParam pname, [OutAttribute] Int32[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = @params)
//                    {
//                        Core.GetQueryObjectiv((UInt32)id, (MonoMac.OpenGL.GetQueryObjectParam)pname, (Int32*)@params_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.5]
//        /// Return parameters of a query object
//        /// </summary>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a query object.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetQueryObject(UInt32 id, MonoMac.OpenGL.GetQueryObjectParam pname, [OutAttribute] out Int32 @params)
//        {
//                unsafe
//                {
//                    fixed (Int32* @params_ptr = &@params)
//                    {
//                        Core.GetQueryObjectiv((UInt32)id, (MonoMac.OpenGL.GetQueryObjectParam)pname, (Int32*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.5]
//        /// Return parameters of a query object
//        /// </summary>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a query object.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetQueryObject(UInt32 id, MonoMac.OpenGL.GetQueryObjectParam pname, [OutAttribute] Int32* @params)
//        {
//                Core.GetQueryObjectiv((UInt32)id, (MonoMac.OpenGL.GetQueryObjectParam)pname, (Int32*)@params);
//        }

//        /// <summary>[requires: v1.2 and ARB_timer_query]</summary>
//        public static
//        void GetQueryObjectui64(Int32 id, MonoMac.OpenGL.ArbTimerQuery pname, [OutAttribute] Int64[] @params)
//        {
//                unsafe
//                {
//                    fixed (Int64* @params_ptr = @params)
//                    {
//                        Core.GetQueryObjectui64v((UInt32)id, (MonoMac.OpenGL.ArbTimerQuery)pname, (UInt64*)@params_ptr);
//                    }
//                }
//        }

//        /// <summary>[requires: v1.2 and ARB_timer_query]</summary>
//        public static
//        void GetQueryObjectui64(Int32 id, MonoMac.OpenGL.ArbTimerQuery pname, [OutAttribute] out Int64 @params)
//        {
//                unsafe
//                {
//                    fixed (Int64* @params_ptr = &@params)
//                    {
//                        Core.GetQueryObjectui64v((UInt32)id, (MonoMac.OpenGL.ArbTimerQuery)pname, (UInt64*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }

//        /// <summary>[requires: v1.2 and ARB_timer_query]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetQueryObjectui64(Int32 id, MonoMac.OpenGL.ArbTimerQuery pname, [OutAttribute] Int64* @params)
//        {
//                Core.GetQueryObjectui64v((UInt32)id, (MonoMac.OpenGL.ArbTimerQuery)pname, (UInt64*)@params);
//        }

//        /// <summary>[requires: v1.2 and ARB_timer_query]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void GetQueryObjectui64(UInt32 id, MonoMac.OpenGL.ArbTimerQuery pname, [OutAttribute] UInt64[] @params)
//        {
//                unsafe
//                {
//                    fixed (UInt64* @params_ptr = @params)
//                    {
//                        Core.GetQueryObjectui64v((UInt32)id, (MonoMac.OpenGL.ArbTimerQuery)pname, (UInt64*)@params_ptr);
//                    }
//                }
//        }

//        /// <summary>[requires: v1.2 and ARB_timer_query]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        void GetQueryObjectui64(UInt32 id, MonoMac.OpenGL.ArbTimerQuery pname, [OutAttribute] out UInt64 @params)
//        {
//                unsafe
//                {
//                    fixed (UInt64* @params_ptr = &@params)
//                    {
//                        Core.GetQueryObjectui64v((UInt32)id, (MonoMac.OpenGL.ArbTimerQuery)pname, (UInt64*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }

//        /// <summary>[requires: v1.2 and ARB_timer_query]</summary>
//        [System.CLSCompliant(false)]
//        public static
//        unsafe void GetQueryObjectui64(UInt32 id, MonoMac.OpenGL.ArbTimerQuery pname, [OutAttribute] UInt64* @params)
//        {
//                Core.GetQueryObjectui64v((UInt32)id, (MonoMac.OpenGL.ArbTimerQuery)pname, (UInt64*)@params);
//        }


//        /// <summary>[requires: v1.5]
//        /// Return parameters of a query object
//        /// </summary>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a query object.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetQueryObject(UInt32 id, MonoMac.OpenGL.GetQueryObjectParam pname, [OutAttribute] UInt32[] @params)
//        {
//                unsafe
//                {
//                    fixed (UInt32* @params_ptr = @params)
//                    {
//                        Core.GetQueryObjectuiv((UInt32)id, (MonoMac.OpenGL.GetQueryObjectParam)pname, (UInt32*)@params_ptr);
//                    }
//                }
//        }


//        /// <summary>[requires: v1.5]
//        /// Return parameters of a query object
//        /// </summary>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a query object.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        [System.CLSCompliant(false)]
//        public static
//        void GetQueryObject(UInt32 id, MonoMac.OpenGL.GetQueryObjectParam pname, [OutAttribute] out UInt32 @params)
//        {
//                unsafe
//                {
//                    fixed (UInt32* @params_ptr = &@params)
//                    {
//                        Core.GetQueryObjectuiv((UInt32)id, (MonoMac.OpenGL.GetQueryObjectParam)pname, (UInt32*)@params_ptr);
//                        @params = *@params_ptr;
//                    }
//                }
//        }


//        /// <summary>[requires: v1.5]
//        /// Return parameters of a query object
//        /// </summary>
//        /// <param name="id">
//        /// <para>
//        /// Specifies the name of a query object.
//        /// </para>
//        /// </param>
//        /// <param name="pname">
//        /// <para>
//        /// Specifies the symbolic name of a query object parameter. Accepted values are GL_QUERY_RESULT or GL_QUERY_RESULT_AVAILABLE.
//        /// </para>
//        /// </param>
//        /// <param name="params">
//        /// <para>
//        /// Returns the requested data.
//        /// </para>
//        /// </param>
//        [System.CL