/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.ganglia;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.Metric;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.sink.ganglia.AbstractGangliaSink;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaConf;
import org.apache.hadoop.metrics2.util.MetricsCache;

public class GangliaSink30
extends AbstractGangliaSink {
    public final Log LOG = LogFactory.getLog(this.getClass());
    protected MetricsCache metricsCache = new MetricsCache();

    @Override
    public void putMetrics(MetricsRecord record) {
        try {
            String recordName = record.name();
            String contextName = record.context();
            StringBuilder sb = new StringBuilder();
            sb.append(contextName);
            sb.append('.');
            sb.append(recordName);
            String groupName = sb.toString();
            sb.append('.');
            int sbBaseLen = sb.length();
            String type = null;
            AbstractGangliaSink.GangliaSlope slopeFromMetric = null;
            AbstractGangliaSink.GangliaSlope calculatedSlope = null;
            MetricsCache.Record cachedMetrics = null;
            if (!this.isSupportSparseMetrics()) {
                cachedMetrics = this.metricsCache.update(record);
                if (cachedMetrics != null && cachedMetrics.metricsEntrySet() != null) {
                    for (Map.Entry<String, Metric> entry : cachedMetrics.metricsEntrySet()) {
                        Metric metric = entry.getValue();
                        sb.append(metric.name());
                        String name = sb.toString();
                        metric.visit(this.gangliaMetricVisitor);
                        type = this.gangliaMetricVisitor.getType();
                        slopeFromMetric = this.gangliaMetricVisitor.getSlope();
                        GangliaConf gConf = this.getGangliaConfForMetric(name);
                        calculatedSlope = this.calculateSlope(gConf, slopeFromMetric);
                        this.emitMetric(groupName, name, type, metric.value().toString(), gConf, calculatedSlope);
                        sb.setLength(sbBaseLen);
                    }
                }
            } else {
                Collection metrics = (Collection)record.metrics();
                if (metrics.size() > 0) {
                    for (Metric metric : record.metrics()) {
                        sb.append(metric.name());
                        String name = sb.toString();
                        metric.visit(this.gangliaMetricVisitor);
                        type = this.gangliaMetricVisitor.getType();
                        slopeFromMetric = this.gangliaMetricVisitor.getSlope();
                        GangliaConf gConf = this.getGangliaConfForMetric(name);
                        calculatedSlope = this.calculateSlope(gConf, slopeFromMetric);
                        this.emitMetric(groupName, name, type, metric.value().toString(), gConf, calculatedSlope);
                        sb.setLength(sbBaseLen);
                    }
                }
            }
        }
        catch (IOException io) {
            throw new MetricsException("Failed to putMetrics", io);
        }
    }

    private AbstractGangliaSink.GangliaSlope calculateSlope(GangliaConf gConf, AbstractGangliaSink.GangliaSlope slopeFromMetric) {
        if (gConf.getSlope() != null) {
            return gConf.getSlope();
        }
        if (slopeFromMetric != null) {
            return slopeFromMetric;
        }
        return DEFAULT_SLOPE;
    }

    protected void emitMetric(String groupName, String name, String type, String value, GangliaConf gConf, AbstractGangliaSink.GangliaSlope gSlope) throws IOException {
        if (name == null) {
            this.LOG.warn((Object)"Metric was emitted with no name.");
            return;
        }
        if (value == null) {
            this.LOG.warn((Object)("Metric name " + name + " was emitted with a null value."));
            return;
        }
        if (type == null) {
            this.LOG.warn((Object)("Metric name " + name + ", value " + value + " has no type."));
            return;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Emitting metric " + name + ", type " + type + ", value " + value + ", slope " + gSlope.name() + " from hostname " + this.getHostName()));
        }
        this.xdr_int(0);
        this.xdr_string(type);
        this.xdr_string(name);
        this.xdr_string(value);
        this.xdr_string(gConf.getUnits());
        this.xdr_int(gSlope.ordinal());
        this.xdr_int(gConf.getTmax());
        this.xdr_int(gConf.getDmax());
        this.emitToGangliaHosts();
    }
}

