
# This file was based on Dartware, LLC IPv6 regular expression test.
# IPv6 regular expression courtesy of Dartware, LLC (http://intermapper.com)
# For full details see http://intermapper.com/ipv6regex


# ipv4
# 1 
{
   type => "op",
   name => "ipMatch",
   param => "10.10.10.10",
   input => "10.10.10.10",
   ret => 1
},
# 2
{
   type => "op",
   name => "ipMatch",
   param => "10.10.10.10",
   input => "10.10.10.11",
   ret => 0
},
# 3
{
   type => "op",
   name => "ipMatch",
   param => "10.10.10.0/21",
   input => "10.10.10.11",
   ret => 1
},
# 4
{
   type => "op",
   name => "ipMatch",
   param => "10.10.10.0/21",
# min valid: 10.10.8.1 
   input => "10.10.7.254",  
   ret => 0
},
# 5
{
   type => "op",
   name => "ipMatch",
   param => "10.10.10.0/21",
   input => "10.10.8.1",
   ret => 1
},
# 6
{
   type => "op",
   name => "ipMatch",
   param => "10.10.10.0/21",
# max valid: 10.10.15.254
   input => "10.10.16.1",  
   ret => 0
},
# 7
{
   type => "op",
   name => "ipMatch",
   param => "10.10.10.0/21",
   input => "10.10.15.254",
   ret => 1
},
# 8
{
   type => "op",
   name => "ipMatch",
   param => "192.168.1.0/24",
   input => "192.168.1.254",
   ret => 1
},
# 9
{
   type => "op",
   name => "ipMatch",
   param => "156.149.249.1/8",
   input => "10.10.10.11",
   ret => 0
},
# 10
{
   type => "op",
   name => "ipMatch",
   param => "156.149.249.1/8",
   input => "156.149.152.152",
   ret => 1
},
# 11
{
   type => "op",
   name => "ipMatch",
   param => "10.0.0.0/24",
   input => "10.10.10.11",
   ret => 0
},
# 12
{
   type => "op",
   name => "ipMatch",
   param => "10.0.0.0/24",
   input => "10.0.0.11",
   ret => 1
},
# 13
{
   type => "op",
   name => "ipMatch",
   param => "10.0.0.0/8",
   input => "10.10.10.11",
   ret => 1
},
# 14
{
   type => "op",
   name => "ipMatch",
   param => "10.0.0.0/8",
   input => "10.10.10.11",
   ret => 1
},
# 15
{
   type => "op",
   name => "ipMatch",
   param => "10.0.0.0/4",
   input => "10.10.10.11",
   ret => 1
},
# 16
{
   type => "op",
   name => "ipMatch",
   param => "10.0.0.0/2",
   input => "10.10.10.11",
   ret => 1
},
# 17
{
   type => "op",
   name => "ipMatch",
   param => "10.0.0.0/100",
   input => "10.10.10.11",
   ret => 0
},

# ipv6
# 18
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/32",
   input => "2001:0db8:ffff:ffff:ffff:ffff:ff00:00ff",
   ret => 1
},
# 19
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/63",
   input => "2001:0db8:ffff:ffff:ffff:ffff:ff00:00ff",
   ret => 0
},


{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::",
   input => "::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/43",
   input => "0000:0000:001f:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/43",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/43",
   input => "0000:0000:0020:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/43",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/71",
   input => "0000:0000:0000:0000:01ff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/71",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/71",
   input => "0000:0000:0000:0000:0200:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/71",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0:0:0:0:0:0:0:1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:1",
   input => "0:0:0:0:0:0:0:1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:0",
   input => "0:0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8:0:0:8:800:200C:417A",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:DB8:0:0:8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8:0:0:8:800:200C:417A",
   input => "2001:DB8:0:0:8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01:0:0:0:0:0:0:101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "FF01:0:0:0:0:0:0:101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01:0:0:0:0:0:0:101",
   input => "FF01:0:0:0:0:0:0:101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8::8:800:200C:417A",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:DB8::8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8::8:800:200C:417A",
   input => "2001:DB8::8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01::101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "FF01::101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01::101",
   input => "FF01::101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:fe07:ed62",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80::217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:fe07:ed62",
   input => "fe80::217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   input => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   input => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   input => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   input => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "FF02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF02:0000:0000:0000:0000:0000:0000:0001",
   input => "FF02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2::10",
   input => "0002:0000:0000:0000:0000:0000:0000:0010",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0002:0000:0000:0000:0000:0000:0000:0010",
   input => "2::10",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0002:0000:0000:0000:0000:0000:0000:0010",
   input => "0002:0000:0000:0000:0000:0000:0000:0010",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2::10",
   input => "2::10",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02::1",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02::1",
   input => "ff02::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/127",
   input => "fe80:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/127",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/127",
   input => "fe80:0000:0000:0000:0000:0000:0000:0002",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/127",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/26",
   input => "fe80:003f:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/26",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/26",
   input => "fe80:0040:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/26",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002:0000:0000:0000:0000:0000:0000:0000",
   input => "2002::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002:0000:0000:0000:0000:0000:0000:0000",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::",
   input => "2002::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/52",
   input => "2002:0000:0000:0fff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/52",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/52",
   input => "2002:0000:0000:1000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/52",
   input => "2001:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/110",
   input => "2002:0000:0000:0000:0000:0000:0003:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/110",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/110",
   input => "2002:0000:0000:0000:0000:0000:0004:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/110",
   input => "2001:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::",
   input => "2001:0db8:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:0000:0000",
   input => "2001:db8::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:0000:0000",
   input => "2001:0db8:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::",
   input => "2001:db8::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/113",
   input => "2001:0db8:0000:0000:0000:0000:0000:7fff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/113",
   input => "2001:0db8:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/113",
   input => "2001:0db8:0000:0000:0000:0000:0000:8000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/113",
   input => "2001:0db7:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::",
   input => "2001:0db8:1234::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/81",
   input => "2001:0db8:1234:0000:0000:7fff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/81",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/81",
   input => "2001:0db8:1234:0000:0000:8000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/81",
   input => "2001:0db8:1233:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/106",
   input => "2001:0db8:1234:0000:0000:0000:003f:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/106",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/106",
   input => "2001:0db8:1234:0000:0000:0000:0040:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/106",
   input => "2001:0db8:1233:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0:0",
   input => "0000:0000:0000:0000:0000:ffff:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0000:0000",
   input => "::ffff:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0000:0000",
   input => "0000:0000:0000:0000:0000:ffff:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0:0",
   input => "::ffff:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:7:8",
   input => "0001:0002:0003:0004:0005:0006:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0007:0008",
   input => "1:2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0007:0008",
   input => "0001:0002:0003:0004:0005:0006:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:7:8",
   input => "1:2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::8",
   input => "0001:0002:0003:0004:0005:0006:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0008",
   input => "1:2:3:4:5:6::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0008",
   input => "0001:0002:0003:0004:0005:0006:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::8",
   input => "1:2:3:4:5:6::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::8",
   input => "0001:0002:0003:0004:0005:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0008",
   input => "1:2:3:4:5::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0008",
   input => "0001:0002:0003:0004:0005:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::8",
   input => "1:2:3:4:5::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::8",
   input => "0001:0002:0003:0004:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0008",
   input => "1:2:3:4::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0008",
   input => "0001:0002:0003:0004:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::8",
   input => "1:2:3:4::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::8",
   input => "0001:0002:0003:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0008",
   input => "1:2:3::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0008",
   input => "0001:0002:0003:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::8",
   input => "1:2:3::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::8",
   input => "0001:0002:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0008",
   input => "1:2::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0008",
   input => "0001:0002:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::8",
   input => "1:2::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6:7",
   input => "0001:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0002:0003:0004:0005:0006:0007",
   input => "1::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0002:0003:0004:0005:0006:0007",
   input => "0001:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6:7",
   input => "1::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6",
   input => "0001:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0002:0003:0004:0005:0006",
   input => "1::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0002:0003:0004:0005:0006",
   input => "0001:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6",
   input => "1::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5",
   input => "0001:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0002:0003:0004:0005",
   input => "1::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0002:0003:0004:0005",
   input => "0001:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5",
   input => "1::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4",
   input => "0001:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0002:0003:0004",
   input => "1::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0002:0003:0004",
   input => "0001:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4",
   input => "1::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3",
   input => "0001:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0002:0003",
   input => "1::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0002:0003",
   input => "0001:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3",
   input => "1::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7",
   input => "0000:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0002:0003:0004:0005:0006:0007",
   input => "::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0002:0003:0004:0005:0006:0007",
   input => "0000:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7",
   input => "::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6",
   input => "0000:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0002:0003:0004:0005:0006",
   input => "::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0002:0003:0004:0005:0006",
   input => "0000:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6",
   input => "::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5",
   input => "0000:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0002:0003:0004:0005",
   input => "::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0002:0003:0004:0005",
   input => "0000:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5",
   input => "::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4",
   input => "0000:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0002:0003:0004",
   input => "::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0002:0003:0004",
   input => "0000:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4",
   input => "::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3",
   input => "0000:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0002:0003",
   input => "::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0002:0003",
   input => "0000:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3",
   input => "::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8",
   input => "0000:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0008",
   input => "::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0008",
   input => "0000:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8",
   input => "::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::",
   input => "0001:0002:0003:0004:0005:0006:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0000",
   input => "1:2:3:4:5:6::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0000",
   input => "0001:0002:0003:0004:0005:0006:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::",
   input => "1:2:3:4:5:6::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::",
   input => "0001:0002:0003:0004:0005:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0000",
   input => "1:2:3:4:5::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0000",
   input => "0001:0002:0003:0004:0005:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::",
   input => "1:2:3:4:5::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::/116",
   input => "0001:0002:0003:0004:0005:0000:0000:0fff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::/116",
   input => "0001:0002:0003:0004:0005:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::/116",
   input => "0001:0002:0003:0004:0005:0000:0000:1000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::/116",
   input => "0001:0002:0003:0004:0004:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::/109",
   input => "0001:0002:0003:0004:0005:0000:0007:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::/109",
   input => "0001:0002:0003:0004:0005:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::/109",
   input => "0001:0002:0003:0004:0005:0000:0008:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::/109",
   input => "0001:0002:0003:0004:0004:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::",
   input => "0001:0002:0003:0004:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0000",
   input => "1:2:3:4::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0000",
   input => "0001:0002:0003:0004:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::",
   input => "1:2:3:4::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::",
   input => "0001:0002:0003:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0000",
   input => "1:2:3::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0000",
   input => "0001:0002:0003:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::",
   input => "1:2:3::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/117",
   input => "0001:0002:0003:0000:0000:0000:0000:07ff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/117",
   input => "0001:0002:0003:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/117",
   input => "0001:0002:0003:0000:0000:0000:0000:0800",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/117",
   input => "0001:0002:0002:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/119",
   input => "0001:0002:0003:0000:0000:0000:0000:01ff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/119",
   input => "0001:0002:0003:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/119",
   input => "0001:0002:0003:0000:0000:0000:0000:0200",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/119",
   input => "0001:0002:0002:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::",
   input => "0001:0002:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0000",
   input => "1:2::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0000",
   input => "0001:0002:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::",
   input => "1:2::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/126",
   input => "0001:0002:0000:0000:0000:0000:0000:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/126",
   input => "0001:0002:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/126",
   input => "0001:0002:0000:0000:0000:0000:0000:0004",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/126",
   input => "0001:0001:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/76",
   input => "0001:0002:0000:0000:000f:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/76",
   input => "0001:0002:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/76",
   input => "0001:0002:0000:0000:0010:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/76",
   input => "0001:0001:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0000",
   input => "1::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0000",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::",
   input => "1::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/48",
   input => "0001:0000:0000:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/48",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/48",
   input => "0001:0000:0001:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/48",
   input => "0000:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/47",
   input => "0001:0000:0001:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/47",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/47",
   input => "0001:0000:0002:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/47",
   input => "0000:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::7:8",
   input => "0001:0002:0003:0004:0005:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0007:0008",
   input => "1:2:3:4:5::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0007:0008",
   input => "0001:0002:0003:0004:0005:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::7:8",
   input => "1:2:3:4:5::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::7:8",
   input => "0001:0002:0003:0004:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0007:0008",
   input => "1:2:3:4::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0007:0008",
   input => "0001:0002:0003:0004:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::7:8",
   input => "1:2:3:4::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::7:8",
   input => "0001:0002:0003:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0007:0008",
   input => "1:2:3::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0007:0008",
   input => "0001:0002:0003:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::7:8",
   input => "1:2:3::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::7:8",
   input => "0001:0002:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0007:0008",
   input => "1:2::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0007:0008",
   input => "0001:0002:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::7:8",
   input => "1:2::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::7:8",
   input => "0001:0000:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0007:0008",
   input => "1::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0007:0008",
   input => "0001:0000:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::7:8",
   input => "1::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::7:8/127",
   input => "0001:0000:0000:0000:0000:0000:0007:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::7:8/127",
   input => "0001:0000:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::7:8/127",
   input => "0001:0000:0000:0000:0000:0000:0007:000a",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::7:8/127",
   input => "0001:0000:0000:0000:0000:0000:0007:0007",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:1.2.3.4",
   input => "0001:0002:0003:0004:0005:0006:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0102:0304",
   input => "1:2:3:4:5:6:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0102:0304",
   input => "0001:0002:0003:0004:0005:0006:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:1.2.3.4",
   input => "1:2:3:4:5:6:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::1.2.3.4",
   input => "0001:0002:0003:0004:0005:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0102:0304",
   input => "1:2:3:4:5::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0102:0304",
   input => "0001:0002:0003:0004:0005:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::1.2.3.4",
   input => "1:2:3:4:5::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::1.2.3.4",
   input => "0001:0002:0003:0004:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0102:0304",
   input => "1:2:3:4::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0102:0304",
   input => "0001:0002:0003:0004:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::1.2.3.4",
   input => "1:2:3:4::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::1.2.3.4",
   input => "0001:0002:0003:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0102:0304",
   input => "1:2:3::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0102:0304",
   input => "0001:0002:0003:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::1.2.3.4",
   input => "1:2:3::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::1.2.3.4",
   input => "0001:0002:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0102:0304",
   input => "1:2::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0102:0304",
   input => "0001:0002:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::1.2.3.4",
   input => "1:2::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::1.2.3.4",
   input => "0001:0000:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0102:0304",
   input => "1::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0102:0304",
   input => "0001:0000:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::1.2.3.4",
   input => "1::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::5:1.2.3.4",
   input => "0001:0002:0003:0004:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0005:0102:0304",
   input => "1:2:3:4::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0005:0102:0304",
   input => "0001:0002:0003:0004:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::5:1.2.3.4",
   input => "1:2:3:4::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::5:1.2.3.4",
   input => "0001:0002:0003:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0005:0102:0304",
   input => "1:2:3::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0005:0102:0304",
   input => "0001:0002:0003:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::5:1.2.3.4",
   input => "1:2:3::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::5:1.2.3.4",
   input => "0001:0002:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0005:0102:0304",
   input => "1:2::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0005:0102:0304",
   input => "0001:0002:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::5:1.2.3.4",
   input => "1:2::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:1.2.3.4",
   input => "0001:0000:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0102:0304",
   input => "1::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0102:0304",
   input => "0001:0000:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:1.2.3.4",
   input => "1::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:11.22.33.44",
   input => "0001:0000:0000:0000:0000:0005:0b16:212c",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0b16:212c",
   input => "1::5:11.22.33.44",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0b16:212c",
   input => "0001:0000:0000:0000:0000:0005:0b16:212c",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:11.22.33.44",
   input => "1::5:11.22.33.44",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:254.7.237.98",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80::217:f2ff:254.7.237.98",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:254.7.237.98",
   input => "fe80::217:f2ff:254.7.237.98",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.26",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   input => "::ffff:192.168.1.26",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.26",
   input => "::ffff:192.168.1.26",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.1",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   input => "::ffff:192.168.1.1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.1",
   input => "::ffff:192.168.1.1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:13.1.68.3",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "0:0:0:0:0:0:13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:13.1.68.3",
   input => "0:0:0:0:0:0:13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:FFFF:129.144.52.38",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "0:0:0:0:0:FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:FFFF:129.144.52.38",
   input => "0:0:0:0:0:FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::13.1.68.3",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "::13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::13.1.68.3",
   input => "::13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::FFFF:129.144.52.38",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "::FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::FFFF:129.144.52.38",
   input => "::FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:254.157.241.86",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0:0:0:204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:254.157.241.86",
   input => "fe80:0:0:0:204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:254.157.241.86",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80::204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:254.157.241.86",
   input => "fe80::204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:12.34.56.78",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "::ffff:12.34.56.78",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:12.34.56.78",
   input => "::ffff:12.34.56.78",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "::ffff:192.0.2.128",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128",
   input => "::ffff:192.0.2.128",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128/124",
   input => "0000:0000:0000:0000:0000:ffff:c000:028f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128/124",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128/124",
   input => "0000:0000:0000:0000:0000:ffff:c000:0290",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128/124",
   input => "0000:0000:0000:0000:0000:ffff:c000:027f",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0:0:0:204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:fe9d:f156",
   input => "fe80:0:0:0:204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80::204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:fe9d:f156",
   input => "fe80::204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/70",
   input => "fe80:0000:0000:0000:03ff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/70",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/70",
   input => "fe80:0000:0000:0000:0400:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/70",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/76",
   input => "fe80:0000:0000:0000:000f:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/76",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/76",
   input => "fe80:0000:0000:0000:0010:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/76",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::1",
   input => "fe80:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0001",
   input => "fe80::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0001",
   input => "fe80:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::1",
   input => "fe80::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:c000:280",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "::ffff:c000:280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:c000:280",
   input => "::ffff:c000:280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3:0:0:8a2e:370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:db8:85a3:0:0:8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3:0:0:8a2e:370:7334",
   input => "2001:db8:85a3:0:0:8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3::8a2e:370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:db8:85a3::8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3::8a2e:370:7334",
   input => "2001:db8:85a3::8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000::1428:57ab",
   input => "2001:0db8:0000:0000:0000::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0:0:0:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0:0:0:0:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0:0:0:1428:57ab",
   input => "2001:0db8:0:0:0:0:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0:0::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0::1428:57ab",
   input => "2001:0db8:0:0::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8::1428:57ab",
   input => "2001:0db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::1428:57ab",
   input => "2001:db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0c22:384e",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "::ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0c22:384e",
   input => "::ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:a::123",
   input => "2001:0db8:000a:0000:0000:0000:0000:0123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:000a:0000:0000:0000:0000:0123",
   input => "2001:db8:a::123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:000a:0000:0000:0000:0000:0123",
   input => "2001:0db8:000a:0000:0000:0000:0000:0123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:a::123",
   input => "2001:db8:a::123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/52",
   input => "fe80:0000:0000:0fff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/52",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/52",
   input => "fe80:0000:0000:1000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/52",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/9",
   input => "feff:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/9",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/9",
   input => "ff00:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/9",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::",
   input => "1111:2222:3333:4444:5555:6666:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:0000",
   input => "1111:2222:3333:4444:5555:6666::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:0000",
   input => "1111:2222:3333:4444:5555:6666:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::",
   input => "1111:2222:3333:4444:5555:6666::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::/111",
   input => "1111:2222:3333:4444:5555:6666:0001:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::/111",
   input => "1111:2222:3333:4444:5555:6666:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::/111",
   input => "1111:2222:3333:4444:5555:6666:0002:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::/111",
   input => "1111:2222:3333:4444:5555:6665:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::",
   input => "1111:2222:3333:4444:5555:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:0000",
   input => "1111:2222:3333:4444:5555::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:0000",
   input => "1111:2222:3333:4444:5555:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::",
   input => "1111:2222:3333:4444:5555::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::",
   input => "1111:2222:3333:4444:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:0000",
   input => "1111:2222:3333:4444::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:0000",
   input => "1111:2222:3333:4444:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::",
   input => "1111:2222:3333:4444::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::",
   input => "1111:2222:3333:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:0000",
   input => "1111:2222:3333::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:0000",
   input => "1111:2222:3333:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::",
   input => "1111:2222:3333::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/55",
   input => "1111:2222:3333:01ff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/55",
   input => "1111:2222:3333:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/55",
   input => "1111:2222:3333:0200:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/55",
   input => "1111:2222:3332:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::",
   input => "1111:2222:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:0000",
   input => "1111:2222::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:0000",
   input => "1111:2222:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::",
   input => "1111:2222::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/111",
   input => "1111:2222:0000:0000:0000:0000:0001:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/111",
   input => "1111:2222:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/111",
   input => "1111:2222:0000:0000:0000:0000:0002:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/111",
   input => "1111:2221:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:0000",
   input => "1111::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:0000",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::",
   input => "1111::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/39",
   input => "1111:0000:01ff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/39",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/39",
   input => "1111:0000:0200:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/39",
   input => "1110:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888",
   input => "1111:2222:3333:4444:5555:6666:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:8888",
   input => "1111:2222:3333:4444:5555:6666::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:8888",
   input => "1111:2222:3333:4444:5555:6666:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888",
   input => "1111:2222:3333:4444:5555:6666::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::8888",
   input => "1111:2222:3333:4444:5555:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:8888",
   input => "1111:2222:3333:4444:5555::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:8888",
   input => "1111:2222:3333:4444:5555:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::8888",
   input => "1111:2222:3333:4444:5555::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::8888",
   input => "1111:2222:3333:4444:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:8888",
   input => "1111:2222:3333:4444::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:8888",
   input => "1111:2222:3333:4444:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::8888",
   input => "1111:2222:3333:4444::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::8888",
   input => "1111:2222:3333:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:8888",
   input => "1111:2222:3333::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:8888",
   input => "1111:2222:3333:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::8888",
   input => "1111:2222:3333::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::8888",
   input => "1111:2222:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:8888",
   input => "1111:2222::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:8888",
   input => "1111:2222:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::8888",
   input => "1111:2222::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::8888",
   input => "1111:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:8888",
   input => "1111::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:8888",
   input => "1111:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::8888",
   input => "1111::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8888",
   input => "0000:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:8888",
   input => "::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:8888",
   input => "0000:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8888",
   input => "::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::7777:8888",
   input => "1111:2222:3333:4444:5555:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7777:8888",
   input => "1111:2222:3333:4444:5555::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7777:8888",
   input => "1111:2222:3333:4444:5555:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::7777:8888",
   input => "1111:2222:3333:4444:5555::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::7777:8888",
   input => "1111:2222:3333:4444:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7777:8888",
   input => "1111:2222:3333:4444::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7777:8888",
   input => "1111:2222:3333:4444:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::7777:8888",
   input => "1111:2222:3333:4444::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::7777:8888",
   input => "1111:2222:3333:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7777:8888",
   input => "1111:2222:3333::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7777:8888",
   input => "1111:2222:3333:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::7777:8888",
   input => "1111:2222:3333::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::7777:8888",
   input => "1111:2222:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7777:8888",
   input => "1111:2222::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7777:8888",
   input => "1111:2222:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::7777:8888",
   input => "1111:2222::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::7777:8888",
   input => "1111:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7777:8888",
   input => "1111::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7777:8888",
   input => "1111:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::7777:8888",
   input => "1111::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::7777:8888",
   input => "0000:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7777:8888",
   input => "::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7777:8888",
   input => "0000:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::7777:8888",
   input => "::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::7777:8888/125",
   input => "0000:0000:0000:0000:0000:0000:7777:888f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::7777:8888/125",
   input => "0000:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::7777:8888/125",
   input => "0000:0000:0000:0000:0000:0000:7777:8890",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::7777:8888/125",
   input => "0000:0000:0000:0000:0000:0000:7777:8887",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:7777:8888",
   input => "1111:2222:3333:4444:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7777:8888",
   input => "1111:2222:3333:4444::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7777:8888",
   input => "1111:2222:3333:4444:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:7777:8888",
   input => "1111:2222:3333:4444::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:7777:8888",
   input => "1111:2222:3333:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7777:8888",
   input => "1111:2222:3333::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7777:8888",
   input => "1111:2222:3333:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:7777:8888",
   input => "1111:2222:3333::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:7777:8888",
   input => "1111:2222:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7777:8888",
   input => "1111:2222::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7777:8888",
   input => "1111:2222:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:7777:8888",
   input => "1111:2222::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:7777:8888",
   input => "1111:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7777:8888",
   input => "1111::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7777:8888",
   input => "1111:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:7777:8888",
   input => "1111::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:7777:8888",
   input => "0000:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7777:8888",
   input => "::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7777:8888",
   input => "0000:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:7777:8888",
   input => "::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:7777:8888",
   input => "1111:2222:3333:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7777:8888",
   input => "1111:2222:3333::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7777:8888",
   input => "1111:2222:3333:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:7777:8888",
   input => "1111:2222:3333::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:7777:8888",
   input => "1111:2222:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7777:8888",
   input => "1111:2222::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7777:8888",
   input => "1111:2222:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:7777:8888",
   input => "1111:2222::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:7777:8888",
   input => "1111:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7777:8888",
   input => "1111::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7777:8888",
   input => "1111:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:7777:8888",
   input => "1111::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:7777:8888",
   input => "0000:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7777:8888",
   input => "::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7777:8888",
   input => "0000:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:7777:8888",
   input => "::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:7777:8888",
   input => "1111:2222:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7777:8888",
   input => "1111:2222::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7777:8888",
   input => "1111:2222:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:7777:8888",
   input => "1111:2222::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:7777:8888",
   input => "1111:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7777:8888",
   input => "1111::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7777:8888",
   input => "1111:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:7777:8888",
   input => "1111::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:7777:8888",
   input => "0000:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7777:8888",
   input => "::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7777:8888",
   input => "0000:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:7777:8888",
   input => "::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:7777:8888",
   input => "1111:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7777:8888",
   input => "1111::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7777:8888",
   input => "1111:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:7777:8888",
   input => "1111::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::3333:4444:5555:6666:7777:8888",
   input => "0000:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:3333:4444:5555:6666:7777:8888",
   input => "::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:3333:4444:5555:6666:7777:8888",
   input => "0000:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::3333:4444:5555:6666:7777:8888",
   input => "::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   input => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   input => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::123.123.123.123",
   input => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::123.123.123.123",
   input => "1111:2222:3333:4444:5555::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::123.123.123.123",
   input => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::123.123.123.123",
   input => "1111:2222:3333:4444::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::123.123.123.123",
   input => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::123.123.123.123",
   input => "1111:2222:3333::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::123.123.123.123",
   input => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::123.123.123.123",
   input => "1111:2222::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::123.123.123.123",
   input => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::123.123.123.123",
   input => "1111::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::123.123.123.123",
   input => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::123.123.123.123",
   input => "::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:123.123.123.123",
   input => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:123.123.123.123",
   input => "1111:2222:3333:4444::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:123.123.123.123",
   input => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:123.123.123.123",
   input => "1111:2222:3333::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:123.123.123.123",
   input => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:123.123.123.123",
   input => "1111:2222::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:123.123.123.123",
   input => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:123.123.123.123",
   input => "1111::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:123.123.123.123",
   input => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:123.123.123.123",
   input => "::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:123.123.123.123",
   input => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:123.123.123.123",
   input => "1111:2222:3333::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:123.123.123.123",
   input => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:123.123.123.123",
   input => "1111:2222::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:123.123.123.123",
   input => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:123.123.123.123",
   input => "1111::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:123.123.123.123",
   input => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:123.123.123.123",
   input => "::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:123.123.123.123",
   input => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:123.123.123.123",
   input => "1111:2222::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:123.123.123.123",
   input => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:123.123.123.123",
   input => "1111::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:123.123.123.123",
   input => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:123.123.123.123",
   input => "::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:123.123.123.123",
   input => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111::3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:123.123.123.123",
   input => "1111::3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0",
   input => "::0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/52",
   input => "0000:0000:0000:0fff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/52",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/52",
   input => "0000:0000:0000:1000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/52",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/51",
   input => "0000:0000:0000:1fff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/51",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/51",
   input => "0000:0000:0000:2000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/51",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0",
   input => "::0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/48",
   input => "0000:0000:0000:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/48",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/48",
   input => "0000:0000:0001:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/48",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/28",
   input => "0000:000f:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/28",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/28",
   input => "0000:0010:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/28",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0",
   input => "::0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/34",
   input => "0000:0000:3fff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/34",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/34",
   input => "0000:0000:4000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/34",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/64",
   input => "0000:0000:0000:0000:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/64",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/64",
   input => "0000:0000:0000:0001:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/64",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0",
   input => "::0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/35",
   input => "0000:0000:1fff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/35",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/35",
   input => "0000:0000:2000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/35",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/16",
   input => "0000:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/16",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/16",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/16",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0",
   input => "::0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/94",
   input => "0000:0000:0000:0000:0000:0003:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/94",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/94",
   input => "0000:0000:0000:0000:0000:0004:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/94",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/64",
   input => "0000:0000:0000:0000:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/64",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/64",
   input => "0000:0000:0000:0001:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/64",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0",
   input => "::0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/74",
   input => "0000:0000:0000:0000:003f:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/74",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/74",
   input => "0000:0000:0000:0000:0040:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/74",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/18",
   input => "0000:3fff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/18",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/18",
   input => "0000:4000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/18",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::",
   input => "0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/118",
   input => "0000:0000:0000:0000:0000:0000:0000:03ff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/118",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/118",
   input => "0000:0000:0000:0000:0000:0000:0000:0400",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/118",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/121",
   input => "0000:0000:0000:0000:0000:0000:0000:007f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/121",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/121",
   input => "0000:0000:0000:0000:0000:0000:0000:0080",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/121",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::",
   input => "0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/51",
   input => "0000:0000:0000:1fff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/51",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/51",
   input => "0000:0000:0000:2000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/51",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/91",
   input => "0000:0000:0000:0000:0000:001f:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/91",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/91",
   input => "0000:0000:0000:0000:0000:0020:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/91",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::",
   input => "0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/4",
   input => "0fff:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/4",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/4",
   input => "1000:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/4",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/6",
   input => "03ff:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/6",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/6",
   input => "0400:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/6",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::",
   input => "0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/44",
   input => "0000:0000:000f:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/44",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/44",
   input => "0000:0000:0010:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/44",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/4",
   input => "0fff:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/4",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/4",
   input => "1000:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/4",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::",
   input => "0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/80",
   input => "0000:0000:0000:0000:0000:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/80",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/80",
   input => "0000:0000:0000:0000:0001:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/80",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/87",
   input => "0000:0000:0000:0000:0000:01ff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/87",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/87",
   input => "0000:0000:0000:0000:0000:0200:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/87",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::",
   input => "0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/58",
   input => "0000:0000:0000:003f:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/58",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/58",
   input => "0000:0000:0000:0040:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/58",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/78",
   input => "0000:0000:0000:0000:0003:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/78",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/78",
   input => "0000:0000:0000:0000:0004:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/78",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0:0:0:0:0:0:0:1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:1",
   input => "0:0:0:0:0:0:0:1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:0",
   input => "0:0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8:0:0:8:800:200C:417A",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:DB8:0:0:8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8:0:0:8:800:200C:417A",
   input => "2001:DB8:0:0:8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01:0:0:0:0:0:0:101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "FF01:0:0:0:0:0:0:101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01:0:0:0:0:0:0:101",
   input => "FF01:0:0:0:0:0:0:101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8::8:800:200C:417A",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:DB8::8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8::8:800:200C:417A",
   input => "2001:DB8::8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01::101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "FF01::101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01::101",
   input => "FF01::101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:fe07:ed62",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80::217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:fe07:ed62",
   input => "fe80::217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   input => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   input => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   input => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   input => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "FF02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF02:0000:0000:0000:0000:0000:0000:0001",
   input => "FF02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2::10",
   input => "0002:0000:0000:0000:0000:0000:0000:0010",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0002:0000:0000:0000:0000:0000:0000:0010",
   input => "2::10",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0002:0000:0000:0000:0000:0000:0000:0010",
   input => "0002:0000:0000:0000:0000:0000:0000:0010",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2::10",
   input => "2::10",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02::1",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02::1",
   input => "ff02::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/94",
   input => "fe80:0000:0000:0000:0000:0003:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/94",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/94",
   input => "fe80:0000:0000:0000:0000:0004:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/94",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002:0000:0000:0000:0000:0000:0000:0000",
   input => "2002::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002:0000:0000:0000:0000:0000:0000:0000",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::",
   input => "2002::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/45",
   input => "2002:0000:0007:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/45",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/45",
   input => "2002:0000:0008:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/45",
   input => "2001:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/103",
   input => "2002:0000:0000:0000:0000:0000:01ff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/103",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/103",
   input => "2002:0000:0000:0000:0000:0000:0200:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/103",
   input => "2001:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::",
   input => "2001:0db8:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:0000:0000",
   input => "2001:db8::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:0000:0000",
   input => "2001:0db8:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::",
   input => "2001:db8::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/118",
   input => "2001:0db8:0000:0000:0000:0000:0000:03ff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/118",
   input => "2001:0db8:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/118",
   input => "2001:0db8:0000:0000:0000:0000:0000:0400",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/118",
   input => "2001:0db7:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::",
   input => "2001:0db8:1234::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/69",
   input => "2001:0db8:1234:0000:07ff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/69",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/69",
   input => "2001:0db8:1234:0000:0800:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/69",
   input => "2001:0db8:1233:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/110",
   input => "2001:0db8:1234:0000:0000:0000:0003:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/110",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/110",
   input => "2001:0db8:1234:0000:0000:0000:0004:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/110",
   input => "2001:0db8:1233:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0:0",
   input => "0000:0000:0000:0000:0000:ffff:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0000:0000",
   input => "::ffff:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0000:0000",
   input => "0000:0000:0000:0000:0000:ffff:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0:0",
   input => "::ffff:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:7:8",
   input => "0001:0002:0003:0004:0005:0006:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0007:0008",
   input => "1:2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0007:0008",
   input => "0001:0002:0003:0004:0005:0006:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:7:8",
   input => "1:2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::8",
   input => "0001:0002:0003:0004:0005:0006:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0008",
   input => "1:2:3:4:5:6::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0008",
   input => "0001:0002:0003:0004:0005:0006:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::8",
   input => "1:2:3:4:5:6::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::8",
   input => "0001:0002:0003:0004:0005:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0008",
   input => "1:2:3:4:5::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0008",
   input => "0001:0002:0003:0004:0005:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::8",
   input => "1:2:3:4:5::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::8",
   input => "0001:0002:0003:0004:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0008",
   input => "1:2:3:4::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0008",
   input => "0001:0002:0003:0004:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::8",
   input => "1:2:3:4::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::8",
   input => "0001:0002:0003:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0008",
   input => "1:2:3::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0008",
   input => "0001:0002:0003:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::8",
   input => "1:2:3::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::8",
   input => "0001:0002:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0008",
   input => "1:2::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0008",
   input => "0001:0002:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::8",
   input => "1:2::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6:7",
   input => "0001:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0002:0003:0004:0005:0006:0007",
   input => "1::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0002:0003:0004:0005:0006:0007",
   input => "0001:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6:7",
   input => "1::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6",
   input => "0001:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0002:0003:0004:0005:0006",
   input => "1::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0002:0003:0004:0005:0006",
   input => "0001:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6",
   input => "1::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5",
   input => "0001:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0002:0003:0004:0005",
   input => "1::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0002:0003:0004:0005",
   input => "0001:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5",
   input => "1::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4",
   input => "0001:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0002:0003:0004",
   input => "1::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0002:0003:0004",
   input => "0001:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4",
   input => "1::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3",
   input => "0001:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0002:0003",
   input => "1::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0002:0003",
   input => "0001:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3",
   input => "1::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7",
   input => "0000:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0002:0003:0004:0005:0006:0007",
   input => "::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0002:0003:0004:0005:0006:0007",
   input => "0000:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7",
   input => "::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6",
   input => "0000:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0002:0003:0004:0005:0006",
   input => "::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0002:0003:0004:0005:0006",
   input => "0000:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6",
   input => "::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5",
   input => "0000:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0002:0003:0004:0005",
   input => "::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0002:0003:0004:0005",
   input => "0000:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5",
   input => "::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4",
   input => "0000:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0002:0003:0004",
   input => "::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0002:0003:0004",
   input => "0000:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4",
   input => "::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3",
   input => "0000:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0002:0003",
   input => "::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0002:0003",
   input => "0000:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3",
   input => "::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8",
   input => "0000:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0008",
   input => "::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0008",
   input => "0000:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8",
   input => "::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::",
   input => "0001:0002:0003:0004:0005:0006:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0000",
   input => "1:2:3:4:5:6::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0000",
   input => "0001:0002:0003:0004:0005:0006:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::",
   input => "1:2:3:4:5:6::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::",
   input => "0001:0002:0003:0004:0005:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0000",
   input => "1:2:3:4:5::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0000",
   input => "0001:0002:0003:0004:0005:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::",
   input => "1:2:3:4:5::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::",
   input => "0001:0002:0003:0004:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0000",
   input => "1:2:3:4::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0000",
   input => "0001:0002:0003:0004:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::",
   input => "1:2:3:4::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/68",
   input => "0001:0002:0003:0004:0fff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/68",
   input => "0001:0002:0003:0004:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/68",
   input => "0001:0002:0003:0004:1000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/68",
   input => "0001:0002:0003:0003:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/84",
   input => "0001:0002:0003:0004:0000:0fff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/84",
   input => "0001:0002:0003:0004:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/84",
   input => "0001:0002:0003:0004:0000:1000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/84",
   input => "0001:0002:0003:0003:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::",
   input => "0001:0002:0003:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0000",
   input => "1:2:3::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0000",
   input => "0001:0002:0003:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::",
   input => "1:2:3::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/116",
   input => "0001:0002:0003:0000:0000:0000:0000:0fff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/116",
   input => "0001:0002:0003:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/116",
   input => "0001:0002:0003:0000:0000:0000:0000:1000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/116",
   input => "0001:0002:0002:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::",
   input => "0001:0002:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0000",
   input => "1:2::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0000",
   input => "0001:0002:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::",
   input => "1:2::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/59",
   input => "0001:0002:0000:001f:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/59",
   input => "0001:0002:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/59",
   input => "0001:0002:0000:0020:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/59",
   input => "0001:0001:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/119",
   input => "0001:0002:0000:0000:0000:0000:0000:01ff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/119",
   input => "0001:0002:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/119",
   input => "0001:0002:0000:0000:0000:0000:0000:0200",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/119",
   input => "0001:0001:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0000",
   input => "1::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0000",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::",
   input => "1::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/101",
   input => "0001:0000:0000:0000:0000:0000:07ff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/101",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/101",
   input => "0001:0000:0000:0000:0000:0000:0800:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/101",
   input => "0000:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/94",
   input => "0001:0000:0000:0000:0000:0003:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/94",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/94",
   input => "0001:0000:0000:0000:0000:0004:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/94",
   input => "0000:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::7:8",
   input => "0001:0002:0003:0004:0005:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0007:0008",
   input => "1:2:3:4:5::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0007:0008",
   input => "0001:0002:0003:0004:0005:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::7:8",
   input => "1:2:3:4:5::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::7:8",
   input => "0001:0002:0003:0004:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0007:0008",
   input => "1:2:3:4::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0007:0008",
   input => "0001:0002:0003:0004:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::7:8",
   input => "1:2:3:4::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::7:8",
   input => "0001:0002:0003:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0007:0008",
   input => "1:2:3::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0007:0008",
   input => "0001:0002:0003:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::7:8",
   input => "1:2:3::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::7:8/127",
   input => "0001:0002:0003:0000:0000:0000:0007:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::7:8/127",
   input => "0001:0002:0003:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::7:8/127",
   input => "0001:0002:0003:0000:0000:0000:0007:000a",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::7:8/127",
   input => "0001:0002:0003:0000:0000:0000:0007:0007",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::7:8",
   input => "0001:0002:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0007:0008",
   input => "1:2::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0007:0008",
   input => "0001:0002:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::7:8",
   input => "1:2::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::7:8",
   input => "0001:0000:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0007:0008",
   input => "1::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0007:0008",
   input => "0001:0000:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::7:8",
   input => "1::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:1.2.3.4",
   input => "0001:0002:0003:0004:0005:0006:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0102:0304",
   input => "1:2:3:4:5:6:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0102:0304",
   input => "0001:0002:0003:0004:0005:0006:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:1.2.3.4",
   input => "1:2:3:4:5:6:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::1.2.3.4",
   input => "0001:0002:0003:0004:0005:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0102:0304",
   input => "1:2:3:4:5::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0102:0304",
   input => "0001:0002:0003:0004:0005:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::1.2.3.4",
   input => "1:2:3:4:5::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::1.2.3.4",
   input => "0001:0002:0003:0004:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0102:0304",
   input => "1:2:3:4::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0102:0304",
   input => "0001:0002:0003:0004:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::1.2.3.4",
   input => "1:2:3:4::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::1.2.3.4",
   input => "0001:0002:0003:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0102:0304",
   input => "1:2:3::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0102:0304",
   input => "0001:0002:0003:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::1.2.3.4",
   input => "1:2:3::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::1.2.3.4",
   input => "0001:0002:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0102:0304",
   input => "1:2::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0102:0304",
   input => "0001:0002:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::1.2.3.4",
   input => "1:2::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::1.2.3.4/126",
   input => "0001:0002:0000:0000:0000:0000:0102:0307",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::1.2.3.4/126",
   input => "0001:0002:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::1.2.3.4/126",
   input => "0001:0002:0000:0000:0000:0000:0102:0308",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::1.2.3.4/126",
   input => "0001:0002:0000:0000:0000:0000:0102:0303",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::1.2.3.4",
   input => "0001:0000:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0102:0304",
   input => "1::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0102:0304",
   input => "0001:0000:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::1.2.3.4",
   input => "1::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::5:1.2.3.4",
   input => "0001:0002:0003:0004:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0005:0102:0304",
   input => "1:2:3:4::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0005:0102:0304",
   input => "0001:0002:0003:0004:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::5:1.2.3.4",
   input => "1:2:3:4::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::5:1.2.3.4",
   input => "0001:0002:0003:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0005:0102:0304",
   input => "1:2:3::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0005:0102:0304",
   input => "0001:0002:0003:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::5:1.2.3.4",
   input => "1:2:3::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::5:1.2.3.4",
   input => "0001:0002:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0005:0102:0304",
   input => "1:2::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0005:0102:0304",
   input => "0001:0002:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::5:1.2.3.4",
   input => "1:2::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:1.2.3.4",
   input => "0001:0000:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0102:0304",
   input => "1::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0102:0304",
   input => "0001:0000:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:1.2.3.4",
   input => "1::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:11.22.33.44",
   input => "0001:0000:0000:0000:0000:0005:0b16:212c",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0b16:212c",
   input => "1::5:11.22.33.44",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0b16:212c",
   input => "0001:0000:0000:0000:0000:0005:0b16:212c",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:11.22.33.44",
   input => "1::5:11.22.33.44",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:254.7.237.98",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80::217:f2ff:254.7.237.98",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:254.7.237.98",
   input => "fe80::217:f2ff:254.7.237.98",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.26",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   input => "::ffff:192.168.1.26",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.26",
   input => "::ffff:192.168.1.26",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.1",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   input => "::ffff:192.168.1.1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.1",
   input => "::ffff:192.168.1.1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:13.1.68.3",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "0:0:0:0:0:0:13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:13.1.68.3",
   input => "0:0:0:0:0:0:13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:FFFF:129.144.52.38",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "0:0:0:0:0:FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:FFFF:129.144.52.38",
   input => "0:0:0:0:0:FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::13.1.68.3",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "::13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::13.1.68.3",
   input => "::13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::FFFF:129.144.52.38",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "::FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::FFFF:129.144.52.38",
   input => "::FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:254.157.241.86",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0:0:0:204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:254.157.241.86",
   input => "fe80:0:0:0:204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:254.157.241.86",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80::204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:254.157.241.86",
   input => "fe80::204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:12.34.56.78",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "::ffff:12.34.56.78",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:12.34.56.78",
   input => "::ffff:12.34.56.78",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "::ffff:192.0.2.128",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128",
   input => "::ffff:192.0.2.128",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0:0:0:204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:fe9d:f156",
   input => "fe80:0:0:0:204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80::204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:fe9d:f156",
   input => "fe80::204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/37",
   input => "fe80:0000:07ff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/37",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/37",
   input => "fe80:0000:0800:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/37",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::1",
   input => "fe80:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0001",
   input => "fe80::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0001",
   input => "fe80:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::1",
   input => "fe80::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:c000:280",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "::ffff:c000:280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:c000:280",
   input => "::ffff:c000:280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3:0:0:8a2e:370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:db8:85a3:0:0:8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3:0:0:8a2e:370:7334",
   input => "2001:db8:85a3:0:0:8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3::8a2e:370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:db8:85a3::8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3::8a2e:370:7334",
   input => "2001:db8:85a3::8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000::1428:57ab",
   input => "2001:0db8:0000:0000:0000::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0:0:0:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0:0:0:0:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0:0:0:1428:57ab",
   input => "2001:0db8:0:0:0:0:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0:0::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0::1428:57ab",
   input => "2001:0db8:0:0::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8::1428:57ab",
   input => "2001:0db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::1428:57ab",
   input => "2001:db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0c22:384e",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "::ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0c22:384e",
   input => "::ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:a::123",
   input => "2001:0db8:000a:0000:0000:0000:0000:0123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:000a:0000:0000:0000:0000:0123",
   input => "2001:db8:a::123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:000a:0000:0000:0000:0000:0123",
   input => "2001:0db8:000a:0000:0000:0000:0000:0123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:a::123",
   input => "2001:db8:a::123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/92",
   input => "fe80:0000:0000:0000:0000:000f:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/92",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/92",
   input => "fe80:0000:0000:0000:0000:0010:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/92",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/35",
   input => "fe80:0000:1fff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/35",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/35",
   input => "fe80:0000:2000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/35",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::",
   input => "1111:2222:3333:4444:5555:6666:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:0000",
   input => "1111:2222:3333:4444:5555:6666::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:0000",
   input => "1111:2222:3333:4444:5555:6666:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::",
   input => "1111:2222:3333:4444:5555:6666::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::",
   input => "1111:2222:3333:4444:5555:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:0000",
   input => "1111:2222:3333:4444:5555::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:0000",
   input => "1111:2222:3333:4444:5555:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::",
   input => "1111:2222:3333:4444:5555::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::/95",
   input => "1111:2222:3333:4444:5555:0001:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::/95",
   input => "1111:2222:3333:4444:5555:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::/95",
   input => "1111:2222:3333:4444:5555:0002:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::/95",
   input => "1111:2222:3333:4444:5554:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::",
   input => "1111:2222:3333:4444:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:0000",
   input => "1111:2222:3333:4444::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:0000",
   input => "1111:2222:3333:4444:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::",
   input => "1111:2222:3333:4444::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::/72",
   input => "1111:2222:3333:4444:00ff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::/72",
   input => "1111:2222:3333:4444:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::/72",
   input => "1111:2222:3333:4444:0100:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::/72",
   input => "1111:2222:3333:4443:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::",
   input => "1111:2222:3333:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:0000",
   input => "1111:2222:3333::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:0000",
   input => "1111:2222:3333:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::",
   input => "1111:2222:3333::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/93",
   input => "1111:2222:3333:0000:0000:0007:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/93",
   input => "1111:2222:3333:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/93",
   input => "1111:2222:3333:0000:0000:0008:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/93",
   input => "1111:2222:3332:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::",
   input => "1111:2222:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:0000",
   input => "1111:2222::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:0000",
   input => "1111:2222:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::",
   input => "1111:2222::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/109",
   input => "1111:2222:0000:0000:0000:0000:0007:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/109",
   input => "1111:2222:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/109",
   input => "1111:2222:0000:0000:0000:0000:0008:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/109",
   input => "1111:2221:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/119",
   input => "1111:2222:0000:0000:0000:0000:0000:01ff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/119",
   input => "1111:2222:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/119",
   input => "1111:2222:0000:0000:0000:0000:0000:0200",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/119",
   input => "1111:2221:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:0000",
   input => "1111::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:0000",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::",
   input => "1111::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/36",
   input => "1111:0000:0fff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/36",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/36",
   input => "1111:0000:1000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/36",
   input => "1110:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/86",
   input => "1111:0000:0000:0000:0000:03ff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/86",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/86",
   input => "1111:0000:0000:0000:0000:0400:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/86",
   input => "1110:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888",
   input => "1111:2222:3333:4444:5555:6666:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:8888",
   input => "1111:2222:3333:4444:5555:6666::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:8888",
   input => "1111:2222:3333:4444:5555:6666:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888",
   input => "1111:2222:3333:4444:5555:6666::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888/125",
   input => "1111:2222:3333:4444:5555:6666:0000:888f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888/125",
   input => "1111:2222:3333:4444:5555:6666:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888/125",
   input => "1111:2222:3333:4444:5555:6666:0000:8890",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888/125",
   input => "1111:2222:3333:4444:5555:6666:0000:8887",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::8888",
   input => "1111:2222:3333:4444:5555:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:8888",
   input => "1111:2222:3333:4444:5555::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:8888",
   input => "1111:2222:3333:4444:5555:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::8888",
   input => "1111:2222:3333:4444:5555::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::8888",
   input => "1111:2222:3333:4444:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:8888",
   input => "1111:2222:3333:4444::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:8888",
   input => "1111:2222:3333:4444:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::8888",
   input => "1111:2222:3333:4444::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::8888",
   input => "1111:2222:3333:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:8888",
   input => "1111:2222:3333::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:8888",
   input => "1111:2222:3333:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::8888",
   input => "1111:2222:3333::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::8888",
   input => "1111:2222:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:8888",
   input => "1111:2222::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:8888",
   input => "1111:2222:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::8888",
   input => "1111:2222::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::8888",
   input => "1111:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:8888",
   input => "1111::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:8888",
   input => "1111:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::8888",
   input => "1111::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8888",
   input => "0000:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:8888",
   input => "::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:8888",
   input => "0000:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8888",
   input => "::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::7777:8888",
   input => "1111:2222:3333:4444:5555:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7777:8888",
   input => "1111:2222:3333:4444:5555::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7777:8888",
   input => "1111:2222:3333:4444:5555:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::7777:8888",
   input => "1111:2222:3333:4444:5555::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::7777:8888",
   input => "1111:2222:3333:4444:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7777:8888",
   input => "1111:2222:3333:4444::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7777:8888",
   input => "1111:2222:3333:4444:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::7777:8888",
   input => "1111:2222:3333:4444::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::7777:8888",
   input => "1111:2222:3333:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7777:8888",
   input => "1111:2222:3333::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7777:8888",
   input => "1111:2222:3333:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::7777:8888",
   input => "1111:2222:3333::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::7777:8888",
   input => "1111:2222:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7777:8888",
   input => "1111:2222::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7777:8888",
   input => "1111:2222:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::7777:8888",
   input => "1111:2222::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::7777:8888/125",
   input => "1111:2222:0000:0000:0000:0000:7777:888f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::7777:8888/125",
   input => "1111:2222:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::7777:8888/125",
   input => "1111:2222:0000:0000:0000:0000:7777:8890",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::7777:8888/125",
   input => "1111:2222:0000:0000:0000:0000:7777:8887",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::7777:8888",
   input => "1111:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7777:8888",
   input => "1111::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7777:8888",
   input => "1111:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::7777:8888",
   input => "1111::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::7777:8888",
   input => "0000:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7777:8888",
   input => "::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7777:8888",
   input => "0000:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::7777:8888",
   input => "::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:7777:8888",
   input => "1111:2222:3333:4444:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7777:8888",
   input => "1111:2222:3333:4444::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7777:8888",
   input => "1111:2222:3333:4444:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:7777:8888",
   input => "1111:2222:3333:4444::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:7777:8888",
   input => "1111:2222:3333:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7777:8888",
   input => "1111:2222:3333::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7777:8888",
   input => "1111:2222:3333:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:7777:8888",
   input => "1111:2222:3333::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:7777:8888",
   input => "1111:2222:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7777:8888",
   input => "1111:2222::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7777:8888",
   input => "1111:2222:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:7777:8888",
   input => "1111:2222::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:7777:8888",
   input => "1111:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7777:8888",
   input => "1111::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7777:8888",
   input => "1111:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:7777:8888",
   input => "1111::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:7777:8888",
   input => "0000:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7777:8888",
   input => "::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7777:8888",
   input => "0000:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:7777:8888",
   input => "::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:7777:8888",
   input => "1111:2222:3333:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7777:8888",
   input => "1111:2222:3333::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7777:8888",
   input => "1111:2222:3333:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:7777:8888",
   input => "1111:2222:3333::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:7777:8888",
   input => "1111:2222:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7777:8888",
   input => "1111:2222::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7777:8888",
   input => "1111:2222:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:7777:8888",
   input => "1111:2222::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:7777:8888/125",
   input => "1111:2222:0000:0000:5555:6666:7777:888f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:7777:8888/125",
   input => "1111:2222:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:7777:8888/125",
   input => "1111:2222:0000:0000:5555:6666:7777:8890",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:7777:8888/125",
   input => "1111:2222:0000:0000:5555:6666:7777:8887",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:7777:8888",
   input => "1111:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7777:8888",
   input => "1111::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7777:8888",
   input => "1111:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:7777:8888",
   input => "1111::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:7777:8888",
   input => "0000:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7777:8888",
   input => "::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7777:8888",
   input => "0000:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:7777:8888",
   input => "::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:7777:8888",
   input => "1111:2222:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7777:8888",
   input => "1111:2222::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7777:8888",
   input => "1111:2222:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:7777:8888",
   input => "1111:2222::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:7777:8888",
   input => "1111:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7777:8888",
   input => "1111::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7777:8888",
   input => "1111:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:7777:8888",
   input => "1111::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:7777:8888",
   input => "0000:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7777:8888",
   input => "::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7777:8888",
   input => "0000:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:7777:8888",
   input => "::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:7777:8888",
   input => "1111:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7777:8888",
   input => "1111::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7777:8888",
   input => "1111:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:7777:8888",
   input => "1111::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::3333:4444:5555:6666:7777:8888",
   input => "0000:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:3333:4444:5555:6666:7777:8888",
   input => "::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:3333:4444:5555:6666:7777:8888",
   input => "0000:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::3333:4444:5555:6666:7777:8888",
   input => "::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   input => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   input => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::123.123.123.123",
   input => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::123.123.123.123",
   input => "1111:2222:3333:4444:5555::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::123.123.123.123",
   input => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::123.123.123.123",
   input => "1111:2222:3333:4444::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::123.123.123.123",
   input => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::123.123.123.123",
   input => "1111:2222:3333::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::123.123.123.123",
   input => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::123.123.123.123",
   input => "1111:2222::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::123.123.123.123",
   input => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::123.123.123.123",
   input => "1111::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::123.123.123.123",
   input => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::123.123.123.123",
   input => "::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:123.123.123.123",
   input => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:123.123.123.123",
   input => "1111:2222:3333:4444::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:123.123.123.123",
   input => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:123.123.123.123",
   input => "1111:2222:3333::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:123.123.123.123",
   input => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:123.123.123.123",
   input => "1111:2222::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:123.123.123.123",
   input => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:123.123.123.123",
   input => "1111::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:123.123.123.123",
   input => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:123.123.123.123",
   input => "::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:123.123.123.123",
   input => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:123.123.123.123",
   input => "1111:2222:3333::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:123.123.123.123",
   input => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:123.123.123.123",
   input => "1111:2222::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:123.123.123.123",
   input => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:123.123.123.123",
   input => "1111::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:123.123.123.123",
   input => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:123.123.123.123",
   input => "::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:123.123.123.123",
   input => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:123.123.123.123",
   input => "1111:2222::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:123.123.123.123",
   input => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:123.123.123.123",
   input => "1111::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:123.123.123.123",
   input => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:123.123.123.123",
   input => "::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:123.123.123.123",
   input => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111::3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:123.123.123.123",
   input => "1111::3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0",
   input => "::0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/45",
   input => "0000:0000:0007:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/45",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/45",
   input => "0000:0000:0008:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/45",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/3",
   input => "1fff:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/3",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/3",
   input => "2000:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/3",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0",
   input => "::0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/96",
   input => "0000:0000:0000:0000:0000:0000:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/96",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/96",
   input => "0000:0000:0000:0000:0000:0001:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/96",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/40",
   input => "0000:0000:00ff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/40",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/40",
   input => "0000:0000:0100:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/40",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0",
   input => "::0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/116",
   input => "0000:0000:0000:0000:0000:0000:0000:0fff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/116",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/116",
   input => "0000:0000:0000:0000:0000:0000:0000:1000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/116",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/88",
   input => "0000:0000:0000:0000:0000:00ff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/88",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/88",
   input => "0000:0000:0000:0000:0000:0100:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/88",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0",
   input => "::0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/120",
   input => "0000:0000:0000:0000:0000:0000:0000:00ff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/120",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/120",
   input => "0000:0000:0000:0000:0000:0000:0000:0100",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/120",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/67",
   input => "0000:0000:0000:0000:1fff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/67",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/67",
   input => "0000:0000:0000:0000:2000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/67",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0",
   input => "::0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/34",
   input => "0000:0000:3fff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/34",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/34",
   input => "0000:0000:4000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/34",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/88",
   input => "0000:0000:0000:0000:0000:00ff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/88",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/88",
   input => "0000:0000:0000:0000:0000:0100:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/88",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0",
   input => "::0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/92",
   input => "0000:0000:0000:0000:0000:000f:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/92",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/92",
   input => "0000:0000:0000:0000:0000:0010:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/92",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/18",
   input => "0000:3fff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/18",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/18",
   input => "0000:4000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/18",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::",
   input => "0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/7",
   input => "01ff:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/7",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/7",
   input => "0200:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/7",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/60",
   input => "0000:0000:0000:000f:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/60",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/60",
   input => "0000:0000:0000:0010:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/60",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::",
   input => "0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/126",
   input => "0000:0000:0000:0000:0000:0000:0000:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/126",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/126",
   input => "0000:0000:0000:0000:0000:0000:0000:0004",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/126",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/76",
   input => "0000:0000:0000:0000:000f:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/76",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/76",
   input => "0000:0000:0000:0000:0010:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/76",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::",
   input => "0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/63",
   input => "0000:0000:0000:0001:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/63",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/63",
   input => "0000:0000:0000:0002:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/63",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/11",
   input => "001f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/11",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/11",
   input => "0020:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/11",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::",
   input => "0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/71",
   input => "0000:0000:0000:0000:01ff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/71",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/71",
   input => "0000:0000:0000:0000:0200:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/71",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/72",
   input => "0000:0000:0000:0000:00ff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/72",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/72",
   input => "0000:0000:0000:0000:0100:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/72",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::",
   input => "0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/23",
   input => "0000:01ff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/23",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/23",
   input => "0000:0200:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/23",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/76",
   input => "0000:0000:0000:0000:000f:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/76",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/76",
   input => "0000:0000:0000:0000:0010:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/76",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::",
   input => "0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/102",
   input => "0000:0000:0000:0000:0000:0000:03ff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/102",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/102",
   input => "0000:0000:0000:0000:0000:0000:0400:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/102",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/42",
   input => "0000:0000:003f:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/42",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/42",
   input => "0000:0000:0040:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/42",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::",
   input => "::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/100",
   input => "0000:0000:0000:0000:0000:0000:0fff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/100",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/100",
   input => "0000:0000:0000:0000:0000:0000:1000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/100",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/59",
   input => "0000:0000:0000:001f:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/59",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/59",
   input => "0000:0000:0000:0020:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/59",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0:0:0:0:0:0:0:1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:1",
   input => "0:0:0:0:0:0:0:1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:0",
   input => "0:0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8:0:0:8:800:200C:417A",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:DB8:0:0:8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8:0:0:8:800:200C:417A",
   input => "2001:DB8:0:0:8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01:0:0:0:0:0:0:101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "FF01:0:0:0:0:0:0:101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01:0:0:0:0:0:0:101",
   input => "FF01:0:0:0:0:0:0:101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8::8:800:200C:417A",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:DB8::8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8::8:800:200C:417A",
   input => "2001:DB8::8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01::101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "FF01::101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01::101",
   input => "FF01::101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:fe07:ed62",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80::217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:fe07:ed62",
   input => "fe80::217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   input => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   input => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   input => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   input => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "FF02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF02:0000:0000:0000:0000:0000:0000:0001",
   input => "FF02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2::10",
   input => "0002:0000:0000:0000:0000:0000:0000:0010",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0002:0000:0000:0000:0000:0000:0000:0010",
   input => "2::10",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0002:0000:0000:0000:0000:0000:0000:0010",
   input => "0002:0000:0000:0000:0000:0000:0000:0010",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2::10",
   input => "2::10",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02::1",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02::1",
   input => "ff02::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/111",
   input => "fe80:0000:0000:0000:0000:0000:0001:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/111",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/111",
   input => "fe80:0000:0000:0000:0000:0000:0002:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/111",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/57",
   input => "fe80:0000:0000:007f:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/57",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/57",
   input => "fe80:0000:0000:0080:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/57",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002:0000:0000:0000:0000:0000:0000:0000",
   input => "2002::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002:0000:0000:0000:0000:0000:0000:0000",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::",
   input => "2002::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/125",
   input => "2002:0000:0000:0000:0000:0000:0000:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/125",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/125",
   input => "2002:0000:0000:0000:0000:0000:0000:0008",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/125",
   input => "2001:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/94",
   input => "2002:0000:0000:0000:0000:0003:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/94",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/94",
   input => "2002:0000:0000:0000:0000:0004:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/94",
   input => "2001:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::",
   input => "2001:0db8:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:0000:0000",
   input => "2001:db8::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:0000:0000",
   input => "2001:0db8:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::",
   input => "2001:db8::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/100",
   input => "2001:0db8:0000:0000:0000:0000:0fff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/100",
   input => "2001:0db8:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/100",
   input => "2001:0db8:0000:0000:0000:0000:1000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/100",
   input => "2001:0db7:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::",
   input => "2001:0db8:1234::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/70",
   input => "2001:0db8:1234:0000:03ff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/70",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/70",
   input => "2001:0db8:1234:0000:0400:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::/70",
   input => "2001:0db8:1233:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0:0",
   input => "0000:0000:0000:0000:0000:ffff:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0000:0000",
   input => "::ffff:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0000:0000",
   input => "0000:0000:0000:0000:0000:ffff:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0:0",
   input => "::ffff:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:7:8",
   input => "0001:0002:0003:0004:0005:0006:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0007:0008",
   input => "1:2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0007:0008",
   input => "0001:0002:0003:0004:0005:0006:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:7:8",
   input => "1:2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::8",
   input => "0001:0002:0003:0004:0005:0006:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0008",
   input => "1:2:3:4:5:6::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0008",
   input => "0001:0002:0003:0004:0005:0006:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::8",
   input => "1:2:3:4:5:6::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::8",
   input => "0001:0002:0003:0004:0005:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0008",
   input => "1:2:3:4:5::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0008",
   input => "0001:0002:0003:0004:0005:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::8",
   input => "1:2:3:4:5::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::8",
   input => "0001:0002:0003:0004:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0008",
   input => "1:2:3:4::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0008",
   input => "0001:0002:0003:0004:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::8",
   input => "1:2:3:4::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::8",
   input => "0001:0002:0003:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0008",
   input => "1:2:3::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0008",
   input => "0001:0002:0003:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::8",
   input => "1:2:3::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::8",
   input => "0001:0002:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0008",
   input => "1:2::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0008",
   input => "0001:0002:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::8",
   input => "1:2::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6:7",
   input => "0001:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0002:0003:0004:0005:0006:0007",
   input => "1::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0002:0003:0004:0005:0006:0007",
   input => "0001:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6:7",
   input => "1::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6",
   input => "0001:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0002:0003:0004:0005:0006",
   input => "1::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0002:0003:0004:0005:0006",
   input => "0001:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6",
   input => "1::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5",
   input => "0001:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0002:0003:0004:0005",
   input => "1::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0002:0003:0004:0005",
   input => "0001:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5",
   input => "1::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4",
   input => "0001:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0002:0003:0004",
   input => "1::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0002:0003:0004",
   input => "0001:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4",
   input => "1::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3",
   input => "0001:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0002:0003",
   input => "1::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0002:0003",
   input => "0001:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3",
   input => "1::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7",
   input => "0000:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0002:0003:0004:0005:0006:0007",
   input => "::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0002:0003:0004:0005:0006:0007",
   input => "0000:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7",
   input => "::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6",
   input => "0000:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0002:0003:0004:0005:0006",
   input => "::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0002:0003:0004:0005:0006",
   input => "0000:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6",
   input => "::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5",
   input => "0000:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0002:0003:0004:0005",
   input => "::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0002:0003:0004:0005",
   input => "0000:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5",
   input => "::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4",
   input => "0000:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0002:0003:0004",
   input => "::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0002:0003:0004",
   input => "0000:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4",
   input => "::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3",
   input => "0000:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0002:0003",
   input => "::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0002:0003",
   input => "0000:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3",
   input => "::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8",
   input => "0000:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0008",
   input => "::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0008",
   input => "0000:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8",
   input => "::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::",
   input => "0001:0002:0003:0004:0005:0006:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0000",
   input => "1:2:3:4:5:6::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0000",
   input => "0001:0002:0003:0004:0005:0006:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::",
   input => "1:2:3:4:5:6::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::",
   input => "0001:0002:0003:0004:0005:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0000",
   input => "1:2:3:4:5::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0000",
   input => "0001:0002:0003:0004:0005:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::",
   input => "1:2:3:4:5::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::",
   input => "0001:0002:0003:0004:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0000",
   input => "1:2:3:4::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0000",
   input => "0001:0002:0003:0004:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::",
   input => "1:2:3:4::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/94",
   input => "0001:0002:0003:0004:0000:0003:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/94",
   input => "0001:0002:0003:0004:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/94",
   input => "0001:0002:0003:0004:0000:0004:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/94",
   input => "0001:0002:0003:0003:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/114",
   input => "0001:0002:0003:0004:0000:0000:0000:3fff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/114",
   input => "0001:0002:0003:0004:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/114",
   input => "0001:0002:0003:0004:0000:0000:0000:4000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/114",
   input => "0001:0002:0003:0003:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::",
   input => "0001:0002:0003:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0000",
   input => "1:2:3::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0000",
   input => "0001:0002:0003:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::",
   input => "1:2:3::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/120",
   input => "0001:0002:0003:0000:0000:0000:0000:00ff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/120",
   input => "0001:0002:0003:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/120",
   input => "0001:0002:0003:0000:0000:0000:0000:0100",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/120",
   input => "0001:0002:0002:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::",
   input => "0001:0002:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0000",
   input => "1:2::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0000",
   input => "0001:0002:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::",
   input => "1:2::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0000",
   input => "1::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0000",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::",
   input => "1::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/37",
   input => "0001:0000:07ff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/37",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/37",
   input => "0001:0000:0800:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/37",
   input => "0000:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/90",
   input => "0001:0000:0000:0000:0000:003f:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/90",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/90",
   input => "0001:0000:0000:0000:0000:0040:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/90",
   input => "0000:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::7:8",
   input => "0001:0002:0003:0004:0005:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0007:0008",
   input => "1:2:3:4:5::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0007:0008",
   input => "0001:0002:0003:0004:0005:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::7:8",
   input => "1:2:3:4:5::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::7:8",
   input => "0001:0002:0003:0004:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0007:0008",
   input => "1:2:3:4::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0007:0008",
   input => "0001:0002:0003:0004:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::7:8",
   input => "1:2:3:4::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::7:8/125",
   input => "0001:0002:0003:0004:0000:0000:0007:000f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::7:8/125",
   input => "0001:0002:0003:0004:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::7:8/125",
   input => "0001:0002:0003:0004:0000:0000:0007:0010",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::7:8/125",
   input => "0001:0002:0003:0004:0000:0000:0007:0007",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::7:8",
   input => "0001:0002:0003:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0007:0008",
   input => "1:2:3::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0007:0008",
   input => "0001:0002:0003:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::7:8",
   input => "1:2:3::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::7:8",
   input => "0001:0002:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0007:0008",
   input => "1:2::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0007:0008",
   input => "0001:0002:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::7:8",
   input => "1:2::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::7:8",
   input => "0001:0000:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0007:0008",
   input => "1::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0007:0008",
   input => "0001:0000:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::7:8",
   input => "1::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:1.2.3.4",
   input => "0001:0002:0003:0004:0005:0006:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0102:0304",
   input => "1:2:3:4:5:6:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0102:0304",
   input => "0001:0002:0003:0004:0005:0006:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:1.2.3.4",
   input => "1:2:3:4:5:6:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::1.2.3.4",
   input => "0001:0002:0003:0004:0005:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0102:0304",
   input => "1:2:3:4:5::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0102:0304",
   input => "0001:0002:0003:0004:0005:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::1.2.3.4",
   input => "1:2:3:4:5::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::1.2.3.4",
   input => "0001:0002:0003:0004:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0102:0304",
   input => "1:2:3:4::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0102:0304",
   input => "0001:0002:0003:0004:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::1.2.3.4",
   input => "1:2:3:4::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::1.2.3.4",
   input => "0001:0002:0003:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0102:0304",
   input => "1:2:3::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0102:0304",
   input => "0001:0002:0003:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::1.2.3.4",
   input => "1:2:3::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::1.2.3.4",
   input => "0001:0002:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0102:0304",
   input => "1:2::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0102:0304",
   input => "0001:0002:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::1.2.3.4",
   input => "1:2::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::1.2.3.4",
   input => "0001:0000:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0102:0304",
   input => "1::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0102:0304",
   input => "0001:0000:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::1.2.3.4",
   input => "1::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::1.2.3.4/127",
   input => "0001:0000:0000:0000:0000:0000:0102:0305",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::1.2.3.4/127",
   input => "0001:0000:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::1.2.3.4/127",
   input => "0001:0000:0000:0000:0000:0000:0102:0306",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::1.2.3.4/127",
   input => "0001:0000:0000:0000:0000:0000:0102:0303",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::5:1.2.3.4",
   input => "0001:0002:0003:0004:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0005:0102:0304",
   input => "1:2:3:4::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0005:0102:0304",
   input => "0001:0002:0003:0004:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::5:1.2.3.4",
   input => "1:2:3:4::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::5:1.2.3.4/127",
   input => "0001:0002:0003:0004:0000:0005:0102:0305",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::5:1.2.3.4/127",
   input => "0001:0002:0003:0004:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::5:1.2.3.4/127",
   input => "0001:0002:0003:0004:0000:0005:0102:0306",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::5:1.2.3.4/127",
   input => "0001:0002:0003:0004:0000:0005:0102:0303",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::5:1.2.3.4",
   input => "0001:0002:0003:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0005:0102:0304",
   input => "1:2:3::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0005:0102:0304",
   input => "0001:0002:0003:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::5:1.2.3.4",
   input => "1:2:3::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::5:1.2.3.4",
   input => "0001:0002:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0005:0102:0304",
   input => "1:2::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0005:0102:0304",
   input => "0001:0002:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::5:1.2.3.4",
   input => "1:2::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:1.2.3.4",
   input => "0001:0000:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0102:0304",
   input => "1::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0102:0304",
   input => "0001:0000:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:1.2.3.4",
   input => "1::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:11.22.33.44",
   input => "0001:0000:0000:0000:0000:0005:0b16:212c",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0b16:212c",
   input => "1::5:11.22.33.44",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0b16:212c",
   input => "0001:0000:0000:0000:0000:0005:0b16:212c",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:11.22.33.44",
   input => "1::5:11.22.33.44",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:254.7.237.98",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80::217:f2ff:254.7.237.98",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:254.7.237.98",
   input => "fe80::217:f2ff:254.7.237.98",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.26",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   input => "::ffff:192.168.1.26",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.26",
   input => "::ffff:192.168.1.26",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.1",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   input => "::ffff:192.168.1.1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.1",
   input => "::ffff:192.168.1.1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:13.1.68.3",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "0:0:0:0:0:0:13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:13.1.68.3",
   input => "0:0:0:0:0:0:13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:FFFF:129.144.52.38",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "0:0:0:0:0:FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:FFFF:129.144.52.38",
   input => "0:0:0:0:0:FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::13.1.68.3",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "::13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::13.1.68.3",
   input => "::13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::FFFF:129.144.52.38",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "::FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::FFFF:129.144.52.38",
   input => "::FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:254.157.241.86",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0:0:0:204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:254.157.241.86",
   input => "fe80:0:0:0:204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:254.157.241.86",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80::204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:254.157.241.86",
   input => "fe80::204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:12.34.56.78",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "::ffff:12.34.56.78",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:12.34.56.78",
   input => "::ffff:12.34.56.78",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:12.34.56.78/127",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:12.34.56.78/127",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:12.34.56.78/127",
   input => "0000:0000:0000:0000:0000:ffff:0c22:3850",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:12.34.56.78/127",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384d",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "::ffff:192.0.2.128",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128",
   input => "::ffff:192.0.2.128",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128/127",
   input => "0000:0000:0000:0000:0000:ffff:c000:0281",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128/127",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128/127",
   input => "0000:0000:0000:0000:0000:ffff:c000:0282",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128/127",
   input => "0000:0000:0000:0000:0000:ffff:c000:027f",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0:0:0:204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:fe9d:f156",
   input => "fe80:0:0:0:204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80::204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:fe9d:f156",
   input => "fe80::204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/75",
   input => "fe80:0000:0000:0000:001f:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/75",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/75",
   input => "fe80:0000:0000:0000:0020:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/75",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/112",
   input => "fe80:0000:0000:0000:0000:0000:0000:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/112",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/112",
   input => "fe80:0000:0000:0000:0000:0000:0001:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/112",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::1",
   input => "fe80:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0001",
   input => "fe80::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0001",
   input => "fe80:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::1",
   input => "fe80::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:c000:280",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "::ffff:c000:280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:c000:280",
   input => "::ffff:c000:280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3:0:0:8a2e:370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:db8:85a3:0:0:8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3:0:0:8a2e:370:7334",
   input => "2001:db8:85a3:0:0:8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3::8a2e:370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:db8:85a3::8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3::8a2e:370:7334",
   input => "2001:db8:85a3::8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000::1428:57ab",
   input => "2001:0db8:0000:0000:0000::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0:0:0:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0:0:0:0:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0:0:0:1428:57ab",
   input => "2001:0db8:0:0:0:0:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0:0::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0::1428:57ab",
   input => "2001:0db8:0:0::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8::1428:57ab",
   input => "2001:0db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::1428:57ab",
   input => "2001:db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0c22:384e",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "::ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0c22:384e",
   input => "::ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:a::123",
   input => "2001:0db8:000a:0000:0000:0000:0000:0123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:000a:0000:0000:0000:0000:0123",
   input => "2001:db8:a::123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:000a:0000:0000:0000:0000:0123",
   input => "2001:0db8:000a:0000:0000:0000:0000:0123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:a::123",
   input => "2001:db8:a::123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::",
   input => "1111:2222:3333:4444:5555:6666:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:0000",
   input => "1111:2222:3333:4444:5555:6666::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:0000",
   input => "1111:2222:3333:4444:5555:6666:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::",
   input => "1111:2222:3333:4444:5555:6666::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::",
   input => "1111:2222:3333:4444:5555:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:0000",
   input => "1111:2222:3333:4444:5555::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:0000",
   input => "1111:2222:3333:4444:5555:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::",
   input => "1111:2222:3333:4444:5555::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::/84",
   input => "1111:2222:3333:4444:5555:0fff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::/84",
   input => "1111:2222:3333:4444:5555:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::/84",
   input => "1111:2222:3333:4444:5555:1000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::/84",
   input => "1111:2222:3333:4444:5554:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::",
   input => "1111:2222:3333:4444:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:0000",
   input => "1111:2222:3333:4444::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:0000",
   input => "1111:2222:3333:4444:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::",
   input => "1111:2222:3333:4444::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::/114",
   input => "1111:2222:3333:4444:0000:0000:0000:3fff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::/114",
   input => "1111:2222:3333:4444:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::/114",
   input => "1111:2222:3333:4444:0000:0000:0000:4000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::/114",
   input => "1111:2222:3333:4443:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::/87",
   input => "1111:2222:3333:4444:0000:01ff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::/87",
   input => "1111:2222:3333:4444:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::/87",
   input => "1111:2222:3333:4444:0000:0200:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::/87",
   input => "1111:2222:3333:4443:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::",
   input => "1111:2222:3333:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:0000",
   input => "1111:2222:3333::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:0000",
   input => "1111:2222:3333:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::",
   input => "1111:2222:3333::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/79",
   input => "1111:2222:3333:0000:0001:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/79",
   input => "1111:2222:3333:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/79",
   input => "1111:2222:3333:0000:0002:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/79",
   input => "1111:2222:3332:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/78",
   input => "1111:2222:3333:0000:0003:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/78",
   input => "1111:2222:3333:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/78",
   input => "1111:2222:3333:0000:0004:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/78",
   input => "1111:2222:3332:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::",
   input => "1111:2222:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:0000",
   input => "1111:2222::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:0000",
   input => "1111:2222:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::",
   input => "1111:2222::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/94",
   input => "1111:2222:0000:0000:0000:0003:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/94",
   input => "1111:2222:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/94",
   input => "1111:2222:0000:0000:0000:0004:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/94",
   input => "1111:2221:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:0000",
   input => "1111::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:0000",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::",
   input => "1111::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/52",
   input => "1111:0000:0000:0fff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/52",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/52",
   input => "1111:0000:0000:1000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/52",
   input => "1110:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/44",
   input => "1111:0000:000f:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/44",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/44",
   input => "1111:0000:0010:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/44",
   input => "1110:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888",
   input => "1111:2222:3333:4444:5555:6666:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:8888",
   input => "1111:2222:3333:4444:5555:6666::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:8888",
   input => "1111:2222:3333:4444:5555:6666:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888",
   input => "1111:2222:3333:4444:5555:6666::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888/125",
   input => "1111:2222:3333:4444:5555:6666:0000:888f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888/125",
   input => "1111:2222:3333:4444:5555:6666:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888/125",
   input => "1111:2222:3333:4444:5555:6666:0000:8890",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888/125",
   input => "1111:2222:3333:4444:5555:6666:0000:8887",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::8888",
   input => "1111:2222:3333:4444:5555:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:8888",
   input => "1111:2222:3333:4444:5555::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:8888",
   input => "1111:2222:3333:4444:5555:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::8888",
   input => "1111:2222:3333:4444:5555::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::8888",
   input => "1111:2222:3333:4444:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:8888",
   input => "1111:2222:3333:4444::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:8888",
   input => "1111:2222:3333:4444:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::8888",
   input => "1111:2222:3333:4444::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::8888",
   input => "1111:2222:3333:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:8888",
   input => "1111:2222:3333::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:8888",
   input => "1111:2222:3333:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::8888",
   input => "1111:2222:3333::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::8888",
   input => "1111:2222:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:8888",
   input => "1111:2222::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:8888",
   input => "1111:2222:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::8888",
   input => "1111:2222::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::8888/125",
   input => "1111:2222:0000:0000:0000:0000:0000:888f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::8888/125",
   input => "1111:2222:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::8888/125",
   input => "1111:2222:0000:0000:0000:0000:0000:8890",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::8888/125",
   input => "1111:2222:0000:0000:0000:0000:0000:8887",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::8888",
   input => "1111:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:8888",
   input => "1111::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:8888",
   input => "1111:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::8888",
   input => "1111::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8888",
   input => "0000:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:8888",
   input => "::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:8888",
   input => "0000:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8888",
   input => "::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::7777:8888",
   input => "1111:2222:3333:4444:5555:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7777:8888",
   input => "1111:2222:3333:4444:5555::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7777:8888",
   input => "1111:2222:3333:4444:5555:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::7777:8888",
   input => "1111:2222:3333:4444:5555::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::7777:8888",
   input => "1111:2222:3333:4444:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7777:8888",
   input => "1111:2222:3333:4444::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7777:8888",
   input => "1111:2222:3333:4444:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::7777:8888",
   input => "1111:2222:3333:4444::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::7777:8888",
   input => "1111:2222:3333:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7777:8888",
   input => "1111:2222:3333::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7777:8888",
   input => "1111:2222:3333:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::7777:8888",
   input => "1111:2222:3333::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::7777:8888",
   input => "1111:2222:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7777:8888",
   input => "1111:2222::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7777:8888",
   input => "1111:2222:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::7777:8888",
   input => "1111:2222::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::7777:8888",
   input => "1111:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7777:8888",
   input => "1111::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7777:8888",
   input => "1111:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::7777:8888",
   input => "1111::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::7777:8888",
   input => "0000:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7777:8888",
   input => "::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7777:8888",
   input => "0000:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::7777:8888",
   input => "::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:7777:8888",
   input => "1111:2222:3333:4444:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7777:8888",
   input => "1111:2222:3333:4444::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7777:8888",
   input => "1111:2222:3333:4444:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:7777:8888",
   input => "1111:2222:3333:4444::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:7777:8888",
   input => "1111:2222:3333:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7777:8888",
   input => "1111:2222:3333::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7777:8888",
   input => "1111:2222:3333:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:7777:8888",
   input => "1111:2222:3333::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:7777:8888/125",
   input => "1111:2222:3333:0000:0000:6666:7777:888f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:7777:8888/125",
   input => "1111:2222:3333:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:7777:8888/125",
   input => "1111:2222:3333:0000:0000:6666:7777:8890",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:7777:8888/125",
   input => "1111:2222:3333:0000:0000:6666:7777:8887",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:7777:8888",
   input => "1111:2222:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7777:8888",
   input => "1111:2222::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7777:8888",
   input => "1111:2222:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:7777:8888",
   input => "1111:2222::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:7777:8888",
   input => "1111:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7777:8888",
   input => "1111::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7777:8888",
   input => "1111:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:7777:8888",
   input => "1111::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:7777:8888",
   input => "0000:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7777:8888",
   input => "::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7777:8888",
   input => "0000:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:7777:8888",
   input => "::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:7777:8888",
   input => "1111:2222:3333:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7777:8888",
   input => "1111:2222:3333::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7777:8888",
   input => "1111:2222:3333:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:7777:8888",
   input => "1111:2222:3333::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:7777:8888",
   input => "1111:2222:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7777:8888",
   input => "1111:2222::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7777:8888",
   input => "1111:2222:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:7777:8888",
   input => "1111:2222::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:7777:8888",
   input => "1111:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7777:8888",
   input => "1111::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7777:8888",
   input => "1111:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:7777:8888",
   input => "1111::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:7777:8888",
   input => "0000:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7777:8888",
   input => "::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7777:8888",
   input => "0000:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:7777:8888",
   input => "::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:7777:8888",
   input => "1111:2222:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7777:8888",
   input => "1111:2222::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7777:8888",
   input => "1111:2222:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:7777:8888",
   input => "1111:2222::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:7777:8888/127",
   input => "1111:2222:0000:4444:5555:6666:7777:8889",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:7777:8888/127",
   input => "1111:2222:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:7777:8888/127",
   input => "1111:2222:0000:4444:5555:6666:7777:888a",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:7777:8888/127",
   input => "1111:2222:0000:4444:5555:6666:7777:8887",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:7777:8888",
   input => "1111:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7777:8888",
   input => "1111::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7777:8888",
   input => "1111:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:7777:8888",
   input => "1111::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:7777:8888",
   input => "0000:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7777:8888",
   input => "::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7777:8888",
   input => "0000:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:7777:8888",
   input => "::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:7777:8888",
   input => "1111:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7777:8888",
   input => "1111::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7777:8888",
   input => "1111:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:7777:8888",
   input => "1111::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::3333:4444:5555:6666:7777:8888",
   input => "0000:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:3333:4444:5555:6666:7777:8888",
   input => "::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:3333:4444:5555:6666:7777:8888",
   input => "0000:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::3333:4444:5555:6666:7777:8888",
   input => "::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   input => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   input => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::123.123.123.123",
   input => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::123.123.123.123",
   input => "1111:2222:3333:4444:5555::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::123.123.123.123",
   input => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::123.123.123.123",
   input => "1111:2222:3333:4444::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::123.123.123.123",
   input => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::123.123.123.123",
   input => "1111:2222:3333::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::123.123.123.123",
   input => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::123.123.123.123",
   input => "1111:2222::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::123.123.123.123",
   input => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::123.123.123.123",
   input => "1111::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::123.123.123.123",
   input => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::123.123.123.123",
   input => "::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:123.123.123.123",
   input => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:123.123.123.123",
   input => "1111:2222:3333:4444::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:123.123.123.123",
   input => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:123.123.123.123",
   input => "1111:2222:3333::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:123.123.123.123",
   input => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:123.123.123.123",
   input => "1111:2222::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:123.123.123.123",
   input => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:123.123.123.123",
   input => "1111::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:123.123.123.123",
   input => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:123.123.123.123",
   input => "::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:123.123.123.123",
   input => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:123.123.123.123",
   input => "1111:2222:3333::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:123.123.123.123",
   input => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:123.123.123.123",
   input => "1111:2222::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:123.123.123.123",
   input => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:123.123.123.123",
   input => "1111::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:123.123.123.123",
   input => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:123.123.123.123",
   input => "::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:123.123.123.123",
   input => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:123.123.123.123",
   input => "1111:2222::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:123.123.123.123",
   input => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:123.123.123.123",
   input => "1111::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:123.123.123.123",
   input => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:123.123.123.123",
   input => "::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:123.123.123.123",
   input => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111::3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:123.123.123.123",
   input => "1111::3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0",
   input => "::0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/25",
   input => "0000:007f:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/25",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/25",
   input => "0000:0080:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/25",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/103",
   input => "0000:0000:0000:0000:0000:0000:01ff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/103",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/103",
   input => "0000:0000:0000:0000:0000:0000:0200:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/103",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0",
   input => "::0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/35",
   input => "0000:0000:1fff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/35",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/35",
   input => "0000:0000:2000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/35",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/38",
   input => "0000:0000:03ff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/38",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/38",
   input => "0000:0000:0400:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/38",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0",
   input => "::0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/100",
   input => "0000:0000:0000:0000:0000:0000:0fff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/100",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/100",
   input => "0000:0000:0000:0000:0000:0000:1000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/100",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/46",
   input => "0000:0000:0003:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/46",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/46",
   input => "0000:0000:0004:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/46",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0",
   input => "::0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/15",
   input => "0001:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/15",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/15",
   input => "0002:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/15",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/115",
   input => "0000:0000:0000:0000:0000:0000:0000:1fff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/115",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/115",
   input => "0000:0000:0000:0000:0000:0000:0000:2000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/115",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0",
   input => "::0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/72",
   input => "0000:0000:0000:0000:00ff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/72",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/72",
   input => "0000:0000:0000:0000:0100:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/72",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/81",
   input => "0000:0000:0000:0000:0000:7fff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/81",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/81",
   input => "0000:0000:0000:0000:0000:8000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/81",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0",
   input => "::0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/119",
   input => "0000:0000:0000:0000:0000:0000:0000:01ff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/119",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/119",
   input => "0000:0000:0000:0000:0000:0000:0000:0200",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/119",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/15",
   input => "0001:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/15",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/15",
   input => "0002:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/15",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::",
   input => "0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/34",
   input => "0000:0000:3fff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/34",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/34",
   input => "0000:0000:4000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/34",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/114",
   input => "0000:0000:0000:0000:0000:0000:0000:3fff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/114",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/114",
   input => "0000:0000:0000:0000:0000:0000:0000:4000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/114",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::",
   input => "0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/54",
   input => "0000:0000:0000:03ff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/54",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/54",
   input => "0000:0000:0000:0400:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/54",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/72",
   input => "0000:0000:0000:0000:00ff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/72",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/72",
   input => "0000:0000:0000:0000:0100:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/72",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::",
   input => "0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/12",
   input => "000f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/12",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/12",
   input => "0010:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/12",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/17",
   input => "0000:7fff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/17",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/17",
   input => "0000:8000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/17",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::",
   input => "0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/63",
   input => "0000:0000:0000:0001:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/63",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/63",
   input => "0000:0000:0000:0002:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/63",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/83",
   input => "0000:0000:0000:0000:0000:1fff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/83",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/83",
   input => "0000:0000:0000:0000:0000:2000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/83",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::",
   input => "0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/62",
   input => "0000:0000:0000:0003:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/62",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/62",
   input => "0000:0000:0000:0004:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/62",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/95",
   input => "0000:0000:0000:0000:0000:0001:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/95",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/95",
   input => "0000:0000:0000:0000:0000:0002:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/95",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::",
   input => "0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/13",
   input => "0007:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/13",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/13",
   input => "0008:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/13",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/56",
   input => "0000:0000:0000:00ff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/56",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/56",
   input => "0000:0000:0000:0100:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/56",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::",
   input => "::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/40",
   input => "0000:0000:00ff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/40",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/40",
   input => "0000:0000:0100:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/40",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/13",
   input => "0007:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/13",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/13",
   input => "0008:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::/13",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0:0:0:0:0:0:0:1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:1",
   input => "0:0:0:0:0:0:0:1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0:0",
   input => "0:0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8:0:0:8:800:200C:417A",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:DB8:0:0:8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8:0:0:8:800:200C:417A",
   input => "2001:DB8:0:0:8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01:0:0:0:0:0:0:101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "FF01:0:0:0:0:0:0:101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01:0:0:0:0:0:0:101",
   input => "FF01:0:0:0:0:0:0:101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8::8:800:200C:417A",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:DB8::8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0008:0800:200c:417a",
   input => "2001:0db8:0000:0000:0008:0800:200c:417a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:DB8::8:800:200C:417A",
   input => "2001:DB8::8:800:200C:417A",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01::101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "FF01::101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff01:0000:0000:0000:0000:0000:0000:0101",
   input => "ff01:0000:0000:0000:0000:0000:0000:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF01::101",
   input => "FF01::101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:fe07:ed62",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80::217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:fe07:ed62",
   input => "fe80::217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   input => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   input => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   input => "2001:0000:1234:0000:0000:c1c0:abcd:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   input => "2001:0000:1234:0000:0000:C1C0:ABCD:0876",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   input => "3ffe:0b00:0000:0000:0001:0000:0000:000a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "FF02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "FF02:0000:0000:0000:0000:0000:0000:0001",
   input => "FF02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2::10",
   input => "0002:0000:0000:0000:0000:0000:0000:0010",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0002:0000:0000:0000:0000:0000:0000:0010",
   input => "2::10",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0002:0000:0000:0000:0000:0000:0000:0010",
   input => "0002:0000:0000:0000:0000:0000:0000:0010",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2::10",
   input => "2::10",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02::1",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02:0000:0000:0000:0000:0000:0000:0001",
   input => "ff02:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "ff02::1",
   input => "ff02::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/9",
   input => "feff:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/9",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/9",
   input => "ff00:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/9",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/47",
   input => "fe80:0000:0001:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/47",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/47",
   input => "fe80:0000:0002:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/47",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002:0000:0000:0000:0000:0000:0000:0000",
   input => "2002::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002:0000:0000:0000:0000:0000:0000:0000",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::",
   input => "2002::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/16",
   input => "2002:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/16",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/16",
   input => "2003:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/16",
   input => "2001:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/25",
   input => "2002:007f:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/25",
   input => "2002:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/25",
   input => "2002:0080:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2002::/25",
   input => "2001:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::",
   input => "2001:0db8:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:0000:0000",
   input => "2001:db8::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:0000:0000",
   input => "2001:0db8:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::",
   input => "2001:db8::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/105",
   input => "2001:0db8:0000:0000:0000:0000:007f:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/105",
   input => "2001:0db8:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/105",
   input => "2001:0db8:0000:0000:0000:0000:0080:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/105",
   input => "2001:0db7:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/122",
   input => "2001:0db8:0000:0000:0000:0000:0000:003f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/122",
   input => "2001:0db8:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/122",
   input => "2001:0db8:0000:0000:0000:0000:0000:0040",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::/122",
   input => "2001:0db7:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234::",
   input => "2001:0db8:1234::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0:0",
   input => "0000:0000:0000:0000:0000:ffff:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0000:0000",
   input => "::ffff:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0000:0000",
   input => "0000:0000:0000:0000:0000:ffff:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0:0",
   input => "::ffff:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0:0/114",
   input => "0000:0000:0000:0000:0000:ffff:0000:3fff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0:0/114",
   input => "0000:0000:0000:0000:0000:ffff:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0:0/114",
   input => "0000:0000:0000:0000:0000:ffff:0000:4000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0:0/114",
   input => "0000:0000:0000:0000:0000:fffe:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:7:8",
   input => "0001:0002:0003:0004:0005:0006:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0007:0008",
   input => "1:2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0007:0008",
   input => "0001:0002:0003:0004:0005:0006:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:7:8",
   input => "1:2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::8",
   input => "0001:0002:0003:0004:0005:0006:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0008",
   input => "1:2:3:4:5:6::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0008",
   input => "0001:0002:0003:0004:0005:0006:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::8",
   input => "1:2:3:4:5:6::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::8",
   input => "0001:0002:0003:0004:0005:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0008",
   input => "1:2:3:4:5::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0008",
   input => "0001:0002:0003:0004:0005:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::8",
   input => "1:2:3:4:5::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::8",
   input => "0001:0002:0003:0004:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0008",
   input => "1:2:3:4::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0008",
   input => "0001:0002:0003:0004:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::8",
   input => "1:2:3:4::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::8",
   input => "0001:0002:0003:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0008",
   input => "1:2:3::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0008",
   input => "0001:0002:0003:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::8",
   input => "1:2:3::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::8",
   input => "0001:0002:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0008",
   input => "1:2::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0008",
   input => "0001:0002:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::8",
   input => "1:2::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6:7",
   input => "0001:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0002:0003:0004:0005:0006:0007",
   input => "1::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0002:0003:0004:0005:0006:0007",
   input => "0001:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6:7",
   input => "1::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6",
   input => "0001:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0002:0003:0004:0005:0006",
   input => "1::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0002:0003:0004:0005:0006",
   input => "0001:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5:6",
   input => "1::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5",
   input => "0001:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0002:0003:0004:0005",
   input => "1::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0002:0003:0004:0005",
   input => "0001:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4:5",
   input => "1::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4",
   input => "0001:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0002:0003:0004",
   input => "1::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0002:0003:0004",
   input => "0001:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3:4",
   input => "1::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3",
   input => "0001:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0002:0003",
   input => "1::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0002:0003",
   input => "0001:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::2:3",
   input => "1::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0008",
   input => "0001:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::8",
   input => "1::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7:8",
   input => "::2:3:4:5:6:7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7",
   input => "0000:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0002:0003:0004:0005:0006:0007",
   input => "::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0002:0003:0004:0005:0006:0007",
   input => "0000:0000:0002:0003:0004:0005:0006:0007",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6:7",
   input => "::2:3:4:5:6:7",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6",
   input => "0000:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0002:0003:0004:0005:0006",
   input => "::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0002:0003:0004:0005:0006",
   input => "0000:0000:0000:0002:0003:0004:0005:0006",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5:6",
   input => "::2:3:4:5:6",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5",
   input => "0000:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0002:0003:0004:0005",
   input => "::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0002:0003:0004:0005",
   input => "0000:0000:0000:0000:0002:0003:0004:0005",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4:5",
   input => "::2:3:4:5",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4",
   input => "0000:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0002:0003:0004",
   input => "::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0002:0003:0004",
   input => "0000:0000:0000:0000:0000:0002:0003:0004",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3:4",
   input => "::2:3:4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3",
   input => "0000:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0002:0003",
   input => "::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0002:0003",
   input => "0000:0000:0000:0000:0000:0000:0002:0003",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2:3",
   input => "::2:3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8",
   input => "0000:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0008",
   input => "::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0008",
   input => "0000:0000:0000:0000:0000:0000:0000:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8",
   input => "::8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::",
   input => "0001:0002:0003:0004:0005:0006:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0000",
   input => "1:2:3:4:5:6::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0000:0000",
   input => "0001:0002:0003:0004:0005:0006:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::",
   input => "1:2:3:4:5:6::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::/106",
   input => "0001:0002:0003:0004:0005:0006:003f:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::/106",
   input => "0001:0002:0003:0004:0005:0006:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::/106",
   input => "0001:0002:0003:0004:0005:0006:0040:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6::/106",
   input => "0001:0002:0003:0004:0005:0005:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::",
   input => "0001:0002:0003:0004:0005:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0000",
   input => "1:2:3:4:5::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0000:0000",
   input => "0001:0002:0003:0004:0005:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::",
   input => "1:2:3:4:5::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::",
   input => "0001:0002:0003:0004:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0000",
   input => "1:2:3:4::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0000:0000",
   input => "0001:0002:0003:0004:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::",
   input => "1:2:3:4::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/68",
   input => "0001:0002:0003:0004:0fff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/68",
   input => "0001:0002:0003:0004:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/68",
   input => "0001:0002:0003:0004:1000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::/68",
   input => "0001:0002:0003:0003:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::",
   input => "0001:0002:0003:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0000",
   input => "1:2:3::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0000:0000",
   input => "0001:0002:0003:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::",
   input => "1:2:3::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/56",
   input => "0001:0002:0003:00ff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/56",
   input => "0001:0002:0003:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/56",
   input => "0001:0002:0003:0100:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/56",
   input => "0001:0002:0002:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/65",
   input => "0001:0002:0003:0000:7fff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/65",
   input => "0001:0002:0003:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/65",
   input => "0001:0002:0003:0000:8000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::/65",
   input => "0001:0002:0002:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::",
   input => "0001:0002:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0000",
   input => "1:2::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0000:0000",
   input => "0001:0002:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::",
   input => "1:2::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/32",
   input => "0001:0002:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/32",
   input => "0001:0002:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/32",
   input => "0001:0003:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/32",
   input => "0001:0001:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/79",
   input => "0001:0002:0000:0000:0001:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/79",
   input => "0001:0002:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/79",
   input => "0001:0002:0000:0000:0002:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::/79",
   input => "0001:0001:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0000",
   input => "1::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0000:0000",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::",
   input => "1::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/103",
   input => "0001:0000:0000:0000:0000:0000:01ff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/103",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/103",
   input => "0001:0000:0000:0000:0000:0000:0200:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/103",
   input => "0000:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/36",
   input => "0001:0000:0fff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/36",
   input => "0001:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/36",
   input => "0001:0000:1000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::/36",
   input => "0000:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::7:8",
   input => "0001:0002:0003:0004:0005:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0007:0008",
   input => "1:2:3:4:5::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0007:0008",
   input => "0001:0002:0003:0004:0005:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::7:8",
   input => "1:2:3:4:5::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::7:8",
   input => "0001:0002:0003:0004:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0007:0008",
   input => "1:2:3:4::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0007:0008",
   input => "0001:0002:0003:0004:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::7:8",
   input => "1:2:3:4::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::7:8",
   input => "0001:0002:0003:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0007:0008",
   input => "1:2:3::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0007:0008",
   input => "0001:0002:0003:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::7:8",
   input => "1:2:3::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::7:8",
   input => "0001:0002:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0007:0008",
   input => "1:2::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0007:0008",
   input => "0001:0002:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::7:8",
   input => "1:2::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::7:8/126",
   input => "0001:0002:0000:0000:0000:0000:0007:000b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::7:8/126",
   input => "0001:0002:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::7:8/126",
   input => "0001:0002:0000:0000:0000:0000:0007:000c",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::7:8/126",
   input => "0001:0002:0000:0000:0000:0000:0007:0007",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::7:8",
   input => "0001:0000:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0007:0008",
   input => "1::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0007:0008",
   input => "0001:0000:0000:0000:0000:0000:0007:0008",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::7:8",
   input => "1::7:8",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:1.2.3.4",
   input => "0001:0002:0003:0004:0005:0006:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0102:0304",
   input => "1:2:3:4:5:6:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0006:0102:0304",
   input => "0001:0002:0003:0004:0005:0006:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5:6:1.2.3.4",
   input => "1:2:3:4:5:6:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::1.2.3.4",
   input => "0001:0002:0003:0004:0005:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0102:0304",
   input => "1:2:3:4:5::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0005:0000:0102:0304",
   input => "0001:0002:0003:0004:0005:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4:5::1.2.3.4",
   input => "1:2:3:4:5::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::1.2.3.4",
   input => "0001:0002:0003:0004:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0102:0304",
   input => "1:2:3:4::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0000:0102:0304",
   input => "0001:0002:0003:0004:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::1.2.3.4",
   input => "1:2:3:4::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::1.2.3.4",
   input => "0001:0002:0003:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0102:0304",
   input => "1:2:3::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0000:0102:0304",
   input => "0001:0002:0003:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::1.2.3.4",
   input => "1:2:3::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::1.2.3.4",
   input => "0001:0002:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0102:0304",
   input => "1:2::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0000:0102:0304",
   input => "0001:0002:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::1.2.3.4",
   input => "1:2::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::1.2.3.4",
   input => "0001:0000:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0102:0304",
   input => "1::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0000:0102:0304",
   input => "0001:0000:0000:0000:0000:0000:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::1.2.3.4",
   input => "1::1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::5:1.2.3.4",
   input => "0001:0002:0003:0004:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0005:0102:0304",
   input => "1:2:3:4::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0004:0000:0005:0102:0304",
   input => "0001:0002:0003:0004:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3:4::5:1.2.3.4",
   input => "1:2:3:4::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::5:1.2.3.4",
   input => "0001:0002:0003:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0005:0102:0304",
   input => "1:2:3::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0003:0000:0000:0005:0102:0304",
   input => "0001:0002:0003:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2:3::5:1.2.3.4",
   input => "1:2:3::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::5:1.2.3.4",
   input => "0001:0002:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0005:0102:0304",
   input => "1:2::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0002:0000:0000:0000:0005:0102:0304",
   input => "0001:0002:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1:2::5:1.2.3.4",
   input => "1:2::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:1.2.3.4",
   input => "0001:0000:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0102:0304",
   input => "1::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0102:0304",
   input => "0001:0000:0000:0000:0000:0005:0102:0304",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:1.2.3.4",
   input => "1::5:1.2.3.4",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:11.22.33.44",
   input => "0001:0000:0000:0000:0000:0005:0b16:212c",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0b16:212c",
   input => "1::5:11.22.33.44",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0001:0000:0000:0000:0000:0005:0b16:212c",
   input => "0001:0000:0000:0000:0000:0005:0b16:212c",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1::5:11.22.33.44",
   input => "1::5:11.22.33.44",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:254.7.237.98",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80::217:f2ff:254.7.237.98",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   input => "fe80:0000:0000:0000:0217:f2ff:fe07:ed62",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::217:f2ff:254.7.237.98",
   input => "fe80::217:f2ff:254.7.237.98",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.26",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   input => "::ffff:192.168.1.26",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:011a",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.26",
   input => "::ffff:192.168.1.26",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.1",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   input => "::ffff:192.168.1.1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   input => "0000:0000:0000:0000:0000:ffff:c0a8:0101",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.168.1.1",
   input => "::ffff:192.168.1.1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:13.1.68.3",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "0:0:0:0:0:0:13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:13.1.68.3",
   input => "0:0:0:0:0:0:13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:FFFF:129.144.52.38",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "0:0:0:0:0:FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:FFFF:129.144.52.38",
   input => "0:0:0:0:0:FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::13.1.68.3",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "::13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0d01:4403",
   input => "0000:0000:0000:0000:0000:0000:0d01:4403",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::13.1.68.3",
   input => "::13.1.68.3",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::FFFF:129.144.52.38",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "::FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:8190:3426",
   input => "0000:0000:0000:0000:0000:ffff:8190:3426",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::FFFF:129.144.52.38",
   input => "::FFFF:129.144.52.38",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:254.157.241.86",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0:0:0:204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:254.157.241.86",
   input => "fe80:0:0:0:204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:254.157.241.86",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80::204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:254.157.241.86",
   input => "fe80::204:61ff:254.157.241.86",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:12.34.56.78",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "::ffff:12.34.56.78",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:12.34.56.78",
   input => "::ffff:12.34.56.78",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "::ffff:192.0.2.128",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:192.0.2.128",
   input => "::ffff:192.0.2.128",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0:0:0:204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0:0:0:204:61ff:fe9d:f156",
   input => "fe80:0:0:0:204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80::204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   input => "fe80:0000:0000:0000:0204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::204:61ff:fe9d:f156",
   input => "fe80::204:61ff:fe9d:f156",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/51",
   input => "fe80:0000:0000:1fff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/51",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/51",
   input => "fe80:0000:0000:2000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/51",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::1",
   input => "fe80:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0001",
   input => "fe80::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0001",
   input => "fe80:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::1",
   input => "fe80::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:c000:280",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "::ffff:c000:280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:c000:0280",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:c000:280",
   input => "::ffff:c000:280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:c000:280/126",
   input => "0000:0000:0000:0000:0000:ffff:c000:0283",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:c000:280/126",
   input => "0000:0000:0000:0000:0000:ffff:c000:0280",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:c000:280/126",
   input => "0000:0000:0000:0000:0000:ffff:c000:0284",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:c000:280/126",
   input => "0000:0000:0000:0000:0000:ffff:c000:027f",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3:0:0:8a2e:370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:db8:85a3:0:0:8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3:0:0:8a2e:370:7334",
   input => "2001:db8:85a3:0:0:8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3::8a2e:370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:db8:85a3::8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   input => "2001:0db8:85a3:0000:0000:8a2e:0370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:85a3::8a2e:370:7334",
   input => "2001:db8:85a3::8a2e:370:7334",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000::1428:57ab",
   input => "2001:0db8:0000:0000:0000::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0:0:0:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0:0:0:0:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0:0:0:1428:57ab",
   input => "2001:0db8:0:0:0:0:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0:0::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0:0::1428:57ab",
   input => "2001:0db8:0:0::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8::1428:57ab",
   input => "2001:0db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   input => "2001:0db8:0000:0000:0000:0000:1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8::1428:57ab",
   input => "2001:db8::1428:57ab",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0001",
   input => "0000:0000:0000:0000:0000:0000:0000:0001",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::1",
   input => "::1",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0c22:384e",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "::ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   input => "0000:0000:0000:0000:0000:ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::ffff:0c22:384e",
   input => "::ffff:0c22:384e",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:0000:0000:0000:0000:0000",
   input => "2001:0db8:1234:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   input => "2001:0db8:1234:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:a::123",
   input => "2001:0db8:000a:0000:0000:0000:0000:0123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:000a:0000:0000:0000:0000:0123",
   input => "2001:db8:a::123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:0db8:000a:0000:0000:0000:0000:0123",
   input => "2001:0db8:000a:0000:0000:0000:0000:0123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "2001:db8:a::123",
   input => "2001:db8:a::123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80:0000:0000:0000:0000:0000:0000:0000",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::",
   input => "fe80::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/13",
   input => "fe87:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/13",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/13",
   input => "fe88:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/13",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/44",
   input => "fe80:0000:000f:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/44",
   input => "fe80:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/44",
   input => "fe80:0000:0010:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "fe80::/44",
   input => "fe7f:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777:8888",
   input => "1111:2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7777::",
   input => "1111:2222:3333:4444:5555:6666:7777::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::",
   input => "1111:2222:3333:4444:5555:6666:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:0000",
   input => "1111:2222:3333:4444:5555:6666::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:0000",
   input => "1111:2222:3333:4444:5555:6666:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::",
   input => "1111:2222:3333:4444:5555:6666::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::/120",
   input => "1111:2222:3333:4444:5555:6666:0000:00ff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::/120",
   input => "1111:2222:3333:4444:5555:6666:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::/120",
   input => "1111:2222:3333:4444:5555:6666:0000:0100",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::/120",
   input => "1111:2222:3333:4444:5555:6665:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::",
   input => "1111:2222:3333:4444:5555:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:0000",
   input => "1111:2222:3333:4444:5555::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:0000",
   input => "1111:2222:3333:4444:5555:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::",
   input => "1111:2222:3333:4444:5555::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::/85",
   input => "1111:2222:3333:4444:5555:07ff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::/85",
   input => "1111:2222:3333:4444:5555:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::/85",
   input => "1111:2222:3333:4444:5555:0800:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::/85",
   input => "1111:2222:3333:4444:5554:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::",
   input => "1111:2222:3333:4444:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:0000",
   input => "1111:2222:3333:4444::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:0000",
   input => "1111:2222:3333:4444:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::",
   input => "1111:2222:3333:4444::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::",
   input => "1111:2222:3333:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:0000",
   input => "1111:2222:3333::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:0000",
   input => "1111:2222:3333:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::",
   input => "1111:2222:3333::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/50",
   input => "1111:2222:3333:3fff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/50",
   input => "1111:2222:3333:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/50",
   input => "1111:2222:3333:4000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::/50",
   input => "1111:2222:3332:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::",
   input => "1111:2222:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:0000",
   input => "1111:2222::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:0000",
   input => "1111:2222:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::",
   input => "1111:2222::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/88",
   input => "1111:2222:0000:0000:0000:00ff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/88",
   input => "1111:2222:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/88",
   input => "1111:2222:0000:0000:0000:0100:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::/88",
   input => "1111:2221:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:0000",
   input => "1111::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:0000",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::",
   input => "1111::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/37",
   input => "1111:0000:07ff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/37",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/37",
   input => "1111:0000:0800:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/37",
   input => "1110:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/54",
   input => "1111:0000:0000:03ff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/54",
   input => "1111:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/54",
   input => "1111:0000:0000:0400:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::/54",
   input => "1110:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888",
   input => "1111:2222:3333:4444:5555:6666:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:8888",
   input => "1111:2222:3333:4444:5555:6666::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:0000:8888",
   input => "1111:2222:3333:4444:5555:6666:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666::8888",
   input => "1111:2222:3333:4444:5555:6666::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::8888",
   input => "1111:2222:3333:4444:5555:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:8888",
   input => "1111:2222:3333:4444:5555::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:0000:8888",
   input => "1111:2222:3333:4444:5555:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::8888",
   input => "1111:2222:3333:4444:5555::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::8888",
   input => "1111:2222:3333:4444:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:8888",
   input => "1111:2222:3333:4444::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:0000:8888",
   input => "1111:2222:3333:4444:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::8888",
   input => "1111:2222:3333:4444::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::8888",
   input => "1111:2222:3333:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:8888",
   input => "1111:2222:3333::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:0000:8888",
   input => "1111:2222:3333:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::8888",
   input => "1111:2222:3333::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::8888/127",
   input => "1111:2222:3333:0000:0000:0000:0000:8889",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::8888/127",
   input => "1111:2222:3333:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::8888/127",
   input => "1111:2222:3333:0000:0000:0000:0000:888a",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::8888/127",
   input => "1111:2222:3333:0000:0000:0000:0000:8887",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::8888",
   input => "1111:2222:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:8888",
   input => "1111:2222::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:0000:8888",
   input => "1111:2222:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::8888",
   input => "1111:2222::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::8888",
   input => "1111:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:8888",
   input => "1111::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:0000:8888",
   input => "1111:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::8888",
   input => "1111::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8888",
   input => "0000:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:8888",
   input => "::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:8888",
   input => "0000:0000:0000:0000:0000:0000:0000:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::8888",
   input => "::8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::7777:8888",
   input => "1111:2222:3333:4444:5555:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7777:8888",
   input => "1111:2222:3333:4444:5555::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7777:8888",
   input => "1111:2222:3333:4444:5555:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::7777:8888",
   input => "1111:2222:3333:4444:5555::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::7777:8888",
   input => "1111:2222:3333:4444:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7777:8888",
   input => "1111:2222:3333:4444::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7777:8888",
   input => "1111:2222:3333:4444:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::7777:8888",
   input => "1111:2222:3333:4444::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::7777:8888",
   input => "1111:2222:3333:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7777:8888",
   input => "1111:2222:3333::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7777:8888",
   input => "1111:2222:3333:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::7777:8888",
   input => "1111:2222:3333::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::7777:8888",
   input => "1111:2222:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7777:8888",
   input => "1111:2222::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7777:8888",
   input => "1111:2222:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::7777:8888",
   input => "1111:2222::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::7777:8888",
   input => "1111:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7777:8888",
   input => "1111::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7777:8888",
   input => "1111:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::7777:8888",
   input => "1111::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::7777:8888",
   input => "0000:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7777:8888",
   input => "::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7777:8888",
   input => "0000:0000:0000:0000:0000:0000:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::7777:8888",
   input => "::7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:7777:8888",
   input => "1111:2222:3333:4444:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7777:8888",
   input => "1111:2222:3333:4444::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7777:8888",
   input => "1111:2222:3333:4444:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:7777:8888",
   input => "1111:2222:3333:4444::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:7777:8888",
   input => "1111:2222:3333:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7777:8888",
   input => "1111:2222:3333::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7777:8888",
   input => "1111:2222:3333:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:7777:8888",
   input => "1111:2222:3333::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:7777:8888",
   input => "1111:2222:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7777:8888",
   input => "1111:2222::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7777:8888",
   input => "1111:2222:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:7777:8888",
   input => "1111:2222::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:7777:8888",
   input => "1111:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7777:8888",
   input => "1111::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7777:8888",
   input => "1111:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:7777:8888",
   input => "1111::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:7777:8888",
   input => "0000:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7777:8888",
   input => "::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7777:8888",
   input => "0000:0000:0000:0000:0000:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:7777:8888",
   input => "::6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:7777:8888",
   input => "1111:2222:3333:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7777:8888",
   input => "1111:2222:3333::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7777:8888",
   input => "1111:2222:3333:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:7777:8888",
   input => "1111:2222:3333::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:7777:8888",
   input => "1111:2222:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7777:8888",
   input => "1111:2222::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7777:8888",
   input => "1111:2222:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:7777:8888",
   input => "1111:2222::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:7777:8888",
   input => "1111:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7777:8888",
   input => "1111::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7777:8888",
   input => "1111:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:7777:8888",
   input => "1111::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:7777:8888",
   input => "0000:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7777:8888",
   input => "::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7777:8888",
   input => "0000:0000:0000:0000:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:7777:8888",
   input => "::5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:7777:8888",
   input => "1111:2222:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7777:8888",
   input => "1111:2222::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7777:8888",
   input => "1111:2222:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:7777:8888",
   input => "1111:2222::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:7777:8888",
   input => "1111:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7777:8888",
   input => "1111::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7777:8888",
   input => "1111:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:7777:8888",
   input => "1111::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:7777:8888",
   input => "0000:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7777:8888",
   input => "::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7777:8888",
   input => "0000:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:7777:8888",
   input => "::4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:7777:8888/126",
   input => "0000:0000:0000:4444:5555:6666:7777:888b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:7777:8888/126",
   input => "0000:0000:0000:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:7777:8888/126",
   input => "0000:0000:0000:4444:5555:6666:7777:888c",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:7777:8888/126",
   input => "0000:0000:0000:4444:5555:6666:7777:8887",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:7777:8888",
   input => "1111:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7777:8888",
   input => "1111::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7777:8888",
   input => "1111:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:7777:8888",
   input => "1111::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::3333:4444:5555:6666:7777:8888",
   input => "0000:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:3333:4444:5555:6666:7777:8888",
   input => "::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:3333:4444:5555:6666:7777:8888",
   input => "0000:0000:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::3333:4444:5555:6666:7777:8888",
   input => "::3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:7777:8888",
   input => "::2222:3333:4444:5555:6666:7777:8888",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   input => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   input => "1111:2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::123.123.123.123",
   input => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444:5555:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:5555::123.123.123.123",
   input => "1111:2222:3333:4444:5555::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::123.123.123.123",
   input => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333:4444:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::123.123.123.123",
   input => "1111:2222:3333:4444::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::123.123.123.123",
   input => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222:3333:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::123.123.123.123",
   input => "1111:2222:3333::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::123.123.123.123",
   input => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111:2222:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::123.123.123.123",
   input => "1111:2222::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::123.123.123.123",
   input => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "1111:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::123.123.123.123",
   input => "1111::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::123.123.123.123",
   input => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   input => "0000:0000:0000:0000:0000:0000:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::123.123.123.123",
   input => "::123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:123.123.123.123",
   input => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333:4444:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:4444::6666:123.123.123.123",
   input => "1111:2222:3333:4444::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:123.123.123.123",
   input => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222:3333:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::6666:123.123.123.123",
   input => "1111:2222:3333::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:123.123.123.123",
   input => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111:2222:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::6666:123.123.123.123",
   input => "1111:2222::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:123.123.123.123",
   input => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "1111:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::6666:123.123.123.123",
   input => "1111::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:123.123.123.123",
   input => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   input => "0000:0000:0000:0000:0000:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::6666:123.123.123.123",
   input => "::6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:123.123.123.123",
   input => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222:3333:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:3333::5555:6666:123.123.123.123",
   input => "1111:2222:3333::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:123.123.123.123",
   input => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111:2222:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::5555:6666:123.123.123.123",
   input => "1111:2222::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:123.123.123.123",
   input => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "1111:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::5555:6666:123.123.123.123",
   input => "1111::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:123.123.123.123",
   input => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   input => "0000:0000:0000:0000:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::5555:6666:123.123.123.123",
   input => "::5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:123.123.123.123",
   input => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111:2222:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:2222::4444:5555:6666:123.123.123.123",
   input => "1111:2222::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:123.123.123.123",
   input => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "1111:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::4444:5555:6666:123.123.123.123",
   input => "1111::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:123.123.123.123",
   input => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   input => "0000:0000:0000:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::4444:5555:6666:123.123.123.123",
   input => "::4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:123.123.123.123",
   input => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111::3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   input => "1111:0000:3333:4444:5555:6666:7b7b:7b7b",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "1111::3333:4444:5555:6666:123.123.123.123",
   input => "1111::3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::2222:3333:4444:5555:6666:123.123.123.123",
   input => "::2222:3333:4444:5555:6666:123.123.123.123",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0:0",
   input => "::0:0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0",
   input => "::0:0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/34",
   input => "0000:0000:3fff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/34",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/34",
   input => "0000:0000:4000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/34",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/91",
   input => "0000:0000:0000:0000:0000:001f:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/91",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/91",
   input => "0000:0000:0000:0000:0000:0020:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0:0/91",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0",
   input => "::0:0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/24",
   input => "0000:00ff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/24",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/24",
   input => "0000:0100:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/24",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/52",
   input => "0000:0000:0000:0fff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/52",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/52",
   input => "0000:0000:0000:1000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0:0/52",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0",
   input => "::0:0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/3",
   input => "1fff:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/3",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/3",
   input => "2000:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/3",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/29",
   input => "0000:0007:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/29",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/29",
   input => "0000:0008:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0:0/29",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0",
   input => "::0:0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/88",
   input => "0000:0000:0000:0000:0000:00ff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/88",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/88",
   input => "0000:0000:0000:0000:0000:0100:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/88",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/78",
   input => "0000:0000:0000:0000:0003:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/78",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/78",
   input => "0000:0000:0000:0000:0004:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0:0/78",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0",
   input => "::0:0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/47",
   input => "0000:0000:0001:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/47",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/47",
   input => "0000:0000:0002:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/47",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/30",
   input => "0000:0003:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/30",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/30",
   input => "0000:0004:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:0/30",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "::0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0",
   input => "::0",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/39",
   input => "0000:0000:01ff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/39",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/39",
   input => "0000:0000:0200:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/39",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/63",
   input => "0000:0000:0000:0001:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/63",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/63",
   input => "0000:0000:0000:0002:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0/63",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0:0::",
   input => "0:0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::",
   input => "0:0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/33",
   input => "0000:0000:7fff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/33",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/33",
   input => "0000:0000:8000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/33",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/33",
   input => "0000:0000:7fff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/33",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/33",
   input => "0000:0000:8000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0:0::/33",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::",
   input => "0:0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/55",
   input => "0000:0000:0000:01ff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/55",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/55",
   input => "0000:0000:0000:0200:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/55",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/97",
   input => "0000:0000:0000:0000:0000:0000:7fff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/97",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/97",
   input => "0000:0000:0000:0000:0000:0000:8000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0:0::/97",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::",
   input => "0:0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/13",
   input => "0007:ffff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/13",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/13",
   input => "0008:0000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/13",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/22",
   input => "0000:03ff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/22",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/22",
   input => "0000:0400:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0:0::/22",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::",
   input => "0:0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/89",
   input => "0000:0000:0000:0000:0000:007f:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/89",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/89",
   input => "0000:0000:0000:0000:0000:0080:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/89",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/90",
   input => "0000:0000:0000:0000:0000:003f:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/90",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/90",
   input => "0000:0000:0000:0000:0000:0040:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0:0::/90",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::",
   input => "0:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/105",
   input => "0000:0000:0000:0000:0000:0000:007f:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/105",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/105",
   input => "0000:0000:0000:0000:0000:0000:0080:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/105",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/19",
   input => "0000:1fff:ffff:ffff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/19",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/19",
   input => "0000:2000:0000:0000:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:0::/19",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0000:0000:0000:0000:0000:0000:0000:0000",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::",
   input => "0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/73",
   input => "0000:0000:0000:0000:007f:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/73",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/73",
   input => "0000:0000:0000:0000:0080:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/73",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/53",
   input => "0000:0000:0000:07ff:ffff:ffff:ffff:ffff",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/53",
   input => "0000:0000:0000:0000:0000:0000:0000:0000",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/53",
   input => "0000:0000:0000:0800:0000:0000:0000:0000",
   ret => 0,
},
{
   type => "op",
   name => "ipMatch",
   param => "0::/53",
   input => "0000:0000:0000:0000:0000:0000:0000:0009",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "0:a:b:c:d:e:f::",
   input => "0:a:b:c:d:e:f::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "::0:a:b:c:d:e:f",
   input => "::0:a:b:c:d:e:f",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
{
   type => "op",
   name => "ipMatch",
   param => "a:b:c:d:e:f:0::",
   input => "a:b:c:d:e:f:0::",
   ret => 1,
},
