/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef uPlot_H
#define uPlot_H

#include "uPlotBase.h"

class MvRequest;

class QAction;
class QComboBox;
class QGraphicsRectItem;
class QGraphicsScene;
class QGraphicsView;
class QLabel;
class QScrollArea;
class QSlider;
class QSplitter;
class QTabWidget;
class QTreeView;
class QTimer;
class QVBoxLayout;
class QWidgetAction;

class ExportDialog;
class MgQPlotScene;
class MgQSceneItem;
class MvQCursorDataWidget;
class MvQDataWidget;
class MvQStepModel;
class MvQLayerWidget;
class MvQFeatureWidget;
class MvQPlotView;
class MvQStepWidget;
class MvQTreeView;
class MvQZoomStackWidget;
class LayerControlWidget;

using namespace std;

class MvQSceneComboBox : public QComboBox
{
    Q_OBJECT

public:
    MvQSceneComboBox(QWidget* parent = 0) :
        QComboBox(parent) {}
    void hidePopup();
signals:
    void cursorLeft();
};

class uPlot : public uPlotBase
{
    Q_OBJECT

public:
    uPlot(QWidget* parent = 0);
    ~uPlot();

    void newRequestForDriversBegin() override;
    void newRequestForDriversEnd() override;
    void progressMessage(const string&) override;

public slots:
    void slotShowControlPanel(bool);
    void slotPlay();
    void slotStop();
    void slotToFirst();
    void slotToLast();
    void slotToNext();
    void slotToPrev();
    void slotStepTo(int);
    void slotStepTo(const QModelIndex&);
    void slotSetSpeed(int);
    void slotLayerUpdate();
    void slotSelectActiveScene();
    void slotActiveSceneSelected(QPointF);
    void slotSetActiveScene(MgQSceneItem*) override;
    void slotSetActiveSceneByIndex(int);
    void slotHighlightActiveScene(bool);
    void slotHighlightScene(int);
    void slotNotHighlightScene();
    void slotAnimatedScenes(bool);
    void slotLayerTransparencyChanged(QString, int);
    void slotLayerVisibilityChanged(QString, bool);
    void slotLayerStackingOrderChanged(QList<QPair<QString, int> >);
    void slotControlTabChanged(int);
    void slotPlotScaleChanged();
    void slotShareTarget();

protected slots:
    void  slotAddRibbonEditor(QWidget* w) override;

protected:
    void setupFileActions();
    void setupShareActions();
    void setupViewActions() override;
    void setupToolsActions();
    void setupAnimationActions();
    void setupEditActions();
    void setupProgressBarActions();

    bool setDropTarget(QPoint) override;
    bool setDropTargetInView(QPoint) override;

    void updateAnimationActionState();
    int currentStep() override;
    int stepNum() override;

    void loadStarted() override;
    void loadFinished() override;

    void readSettings() override;
    void writeSettings() override;

    QVBoxLayout* plotLayout_;

    QWidget* controlWidget_;
    QTabWidget* controlTab_;

    MvQStepWidget* stepWidget_;
    MvQLayerWidget* layerWidget_;
    MvQDataWidget* dataWidget_;
    LayerControlWidget* layerControlWidget_;
    MvQCursorDataWidget* cursorWidget_;
    MvQFeatureWidget* symbolWidget_;
    
    QAction* actionAntialias_;
    QAction* actionControlPanel_;

    //Animation control
    QAction* actionPlay_;
    QAction* actionStop_;
    QAction* actionNext_;
    QAction* actionPrevious_;
    QAction* actionFirst_;
    QAction* actionLast_;
    QSlider* speedSlider_;
    QTimer* timer_;
    vector<float> speed_;
    int actSpeedIndex_;
    QLabel* speedLabel_;

    QAction* actionHighlightScene_;
    QList<MgQSceneItem*> animatedScenes_;
    QAction* actionAnimatedScenes_;
    MvQSceneComboBox* sceneCb_;
    QWidget* sceneWidget_;
    bool ignoreResetEnd_{false};

    //	MvQProgressItem* progressItem_;

    // Progress Bar
//    MvQProgressBarPanel* progressBar_;
//    QWidgetAction* acltb_;
//    QWidgetAction* acptb_;

    QSplitter* mainSplitter_;

    bool weatherRoom_;
};

#endif
