"""
Hook to log changesets pushed and pulled
"""

from mercurial.i18n import _
import mercurial.util
import mercurial.node

import os
import time
import fcntl

try:
    import json
    json.dumps
except ImportError:
    import simplejson as json

from mercurialserver import ruleset, changes

def hook(ui, repo, hooktype, node=None, source=None, **kwargs):
    if hooktype == 'changegroup':
        op = "push"
    elif hooktype == 'outgoing':
        op = "pull"
    else:
        raise mercurial.util.Abort(_('servelog installed as wrong hook type,'
            ' must be changegroup or outgoing but is %s') % hooktype)
    log = open(repo.join("mercurial-server.log"), "a+")
    try:
        fcntl.flock(log.fileno(), fcntl.LOCK_EX)
        log.seek(0, os.SEEK_END)
        # YAML log file format
        log.write("- %s\n" % json.dumps(dict(
            timestamp=time.strftime("%Y-%m-%d_%H:%M:%S Z", time.gmtime()),
            op=op,
            key=ruleset.rules.get('user'),
            ssh_connection=os.environ['SSH_CONNECTION'],
            nodes=[mercurial.node.hex(ctx.node())
                for ctx in changes.changes(repo, node)],
         )))
    finally:
        log.close()
