/*-------------------------------------------------------------------------
 * Copyright (c) 2000-2002 Kenneth W. Sodemann (stufflehead@bigfoot.com)
 *-------------------------------------------------------------------------
 * about_dlg
 *
 * Synopsis:
 *   MathWars obligatory about dialog
 *
 * $Id: about_dlg.c,v 1.4 2002/11/18 16:10:53 stuffle Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330 
 * Boston, MA  02111-1307  USA
 *
 *-------------------------------------------------------------------------
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#define MSG "A simple, but fun, math game for grade school aged kids.  \
Based loosly on the popular 'War' card game."
#define LOGO "%s/pixmaps/mw_logo.png"

static GtkWidget *
create_about_dlg (GtkWidget *parent)
{
   GtkWidget  *about_dlg;
   GString    *logo_str;
   const gchar *authors[] = {
      "Ken Sodemann <stufflehead@bigfoot.com>",
      NULL
   };

   logo_str = g_string_new ("");
   g_string_sprintf (logo_str, LOGO, PACKAGE_DATA_DIR);
   about_dlg = gnome_about_new (PACKAGE, VERSION,
         _("Copyright (c) 2000-2002 Kenneth W. Sodemann"),
        authors,
        _(MSG),
        logo_str->str);
   g_string_free (logo_str, TRUE);

   if (parent != NULL)
      {
      gnome_dialog_set_parent (GNOME_DIALOG (about_dlg),
                               GTK_WINDOW (parent));
      }

   return about_dlg;
}

void
show_about_dlg (GtkWidget *parent)
{
   static GtkWidget  *about_dlg = NULL;

   /*
    * If the dialog box exists, just make sure it is visable, otherwise
    * create it.
    */
   if (about_dlg)
      {
      gdk_window_show(about_dlg->window);
      gdk_window_raise(about_dlg->window);
      }
   else
      {
      about_dlg = create_about_dlg (parent);

      /*
       * When the dialog is destroyed, call gtk_widget_destroyed(), 
       * which will set the "user_data" (&about_dlg in this case) to 
       * NULL.
       */
      gtk_signal_connect (GTK_OBJECT (about_dlg),
                          "destroy",
                          GTK_SIGNAL_FUNC (gtk_widget_destroyed),
                          &about_dlg);

      gtk_widget_show (about_dlg);
      }
}
