/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Calendar;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.Options;

public class TimestampParameter
extends NotLongDataParameterHolder {
    private Timestamp ts;
    private Calendar calendar;
    private boolean fractionalSeconds;
    private Options options;

    public TimestampParameter(Timestamp ts, Calendar cal, boolean fractionalSeconds, Options options) {
        this.ts = ts;
        this.calendar = cal;
        this.fractionalSeconds = fractionalSeconds;
        this.options = options;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        ParameterWriter.writeTimestamp(os, this.ts, this.calendar, this.fractionalSeconds);
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        return 27L;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        if (this.options.useLegacyDatetimeCode) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.setTimeInMillis(this.ts.getTime());
        writeBuffer.writeTimestampLength(this.calendar, this.ts, this.fractionalSeconds);
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.DATETIME;
    }

    @Override
    public String toString() {
        return "'" + this.ts.toString() + "'";
    }
}

