# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1LimitRangeItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'max': 'str',
            'min': 'str',
            'default': 'str'
        }

        self.attribute_map = {
            'type': 'type',
            'max': 'max',
            'min': 'min',
            'default': 'default'
        }

        self._type = None
        self._max = None
        self._min = None
        self._default = None

    @property
    def type(self):
        """
        Gets the type of this V1LimitRangeItem.
        type of resource that this limit applies to

        :return: The type of this V1LimitRangeItem.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this V1LimitRangeItem.
        type of resource that this limit applies to

        :param type: The type of this V1LimitRangeItem.
        :type: str
        """
        self._type = type

    @property
    def max(self):
        """
        Gets the max of this V1LimitRangeItem.
        max usage constraints on this kind by resource name

        :return: The max of this V1LimitRangeItem.
        :rtype: str
        """
        return self._max

    @max.setter
    def max(self, max):
        """
        Sets the max of this V1LimitRangeItem.
        max usage constraints on this kind by resource name

        :param max: The max of this V1LimitRangeItem.
        :type: str
        """
        self._max = max

    @property
    def min(self):
        """
        Gets the min of this V1LimitRangeItem.
        min usage constraints on this kind by resource name

        :return: The min of this V1LimitRangeItem.
        :rtype: str
        """
        return self._min

    @min.setter
    def min(self, min):
        """
        Sets the min of this V1LimitRangeItem.
        min usage constraints on this kind by resource name

        :param min: The min of this V1LimitRangeItem.
        :type: str
        """
        self._min = min

    @property
    def default(self):
        """
        Gets the default of this V1LimitRangeItem.
        default values on this kind by resource name if omitted

        :return: The default of this V1LimitRangeItem.
        :rtype: str
        """
        return self._default

    @default.setter
    def default(self, default):
        """
        Sets the default of this V1LimitRangeItem.
        default values on this kind by resource name if omitted

        :param default: The default of this V1LimitRangeItem.
        :type: str
        """
        self._default = default

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
