# - Find OOo SDK

set(OO_SDK_HOME "$ENV{OO_SDK_HOME}")
set(OO_SDK_HOME_LIB_DIR "$ENV{OO_SDK_HOME}/lib")
set(OO_SDK_URE_HOME "$ENV{OO_SDK_URE_HOME}")
set(OFFICE_BASE_PROGRAM_PATH "$ENV{OFFICE_BASE_PROGRAM_PATH}")
set(OO_SDK_URE_LIB_DIR "$ENV{OO_SDK_URE_LIB_DIR}")
set(SDK_GXX_INCLUDE_PATH "$ENV{SDK_GXX_INCLUDE_PATH}")
set(OOSDK_INCLUDE_DIR "$ENV{OO_SDK_INC_SUSE}")

if(OOSDK_INCLUDE_DIR)
  message(STATUS "Using SUSE include dir: ${OOSDK_INCLUDE_DIR}")
else(OOSDK_INCLUDE_DIR)
  set(OOSDK_INCLUDE_DIR "${OO_SDK_HOME}/include")
endif(OOSDK_INCLUDE_DIR)

if(NOT OO_SDK_HOME)
  message(FATAL_ERROR "Run setsdkenv to set environment variables.")
endif(NOT OO_SDK_HOME)

message(STATUS "Searching for OpenOffice.org libraries in: ${OO_SDK_URE_LIB_DIR} ${OO_SDK_HOME_LIB_DIR}")

if(APPLE)
  set(ENV_LIB_VAR DYLD_LIBRARY_PATH)
else(APPLE)
  set(ENV_LIB_VAR LD_LIBRARY_PATH)
endif(APPLE)


IF(CPPUMAKER)
  # Already in cache, be silent.
  SET(CPPUMAKER_FIND_QUIETLY TRUE)
ENDIF(CPPUMAKER)

FIND_PROGRAM(CPPUMAKER NAMES cppumaker PATHS "${OO_SDK_HOME}/bin")
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(CppuMaker DEFAULT_MSG CPPUMAKER)
MARK_AS_ADVANCED(CPPUMAKER)


IF(CPPU_LIBRARY)
  # Already in cache, be silent.
  SET(CPPU_FIND_QUIETLY TRUE)
ENDIF(CPPU_LIBRARY)

SET(CPPU_NAMES icppu uno_cppu cppu)
FIND_LIBRARY(CPPU_LIBRARY NAMES ${CPPU_NAMES} PATHS ${OO_SDK_URE_LIB_DIR} ${OO_SDK_HOME_LIB_DIR} ENV ${ENV_LIB_VAR})
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Cppu DEFAULT_MSG CPPU_LIBRARY)


IF(CPPUHELPER_LIBRARY)
  # Already in cache, be silent.
  SET(CPPUHELPER_FIND_QUIETLY TRUE)
ENDIF(CPPUHELPER_LIBRARY)

SET(CPPUHELPER_NAMES uno_cppuhelpergcc3 icppuhelper cppuhelper)
FIND_LIBRARY(CPPUHELPER_LIBRARY NAMES ${CPPUHELPER_NAMES} PATHS ${OO_SDK_URE_LIB_DIR} ${OO_SDK_HOME_LIB_DIR} ENV ${ENV_LIB_VAR})
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(CppuHelper DEFAULT_MSG CPPUHELPER_LIBRARY)


IF(SAL_LIBRARY)
  # Already in cache, be silent.
  SET(SAL_FIND_QUIETLY TRUE)
ENDIF(SAL_LIBRARY)

SET(SAL_NAMES isal uno_sal sal)
FIND_LIBRARY(SAL_LIBRARY NAMES ${SAL_NAMES} PATHS ${OO_SDK_URE_LIB_DIR} ${OO_SDK_HOME_LIB_DIR} ENV ${ENV_LIB_VAR})
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Sal DEFAULT_MSG SAL_LIBRARY)


IF(SALHELPER_LIBRARY)
  # Already in cache, be silent.
  SET(SALHELPER_FIND_QUIETLY TRUE)
ENDIF(SALHELPER_LIBRARY)

SET(SALHELPER_NAMES isalhelper uno_salhelpergcc3 salhelper)
FIND_LIBRARY(SALHELPER_LIBRARY NAMES ${SALHELPER_NAMES} PATHS ${OO_SDK_URE_LIB_DIR} ${OO_SDK_HOME_LIB_DIR} ENV ${ENV_LIB_VAR})
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(SalHelper DEFAULT_MSG SALHELPER_LIBRARY)


IF(STLPORT_LIBRARY)
  # Already in cache, be silent.
  SET(STLPORT_FIND_QUIETLY TRUE)
ENDIF(STLPORT_LIBRARY)

SET(STLPORT_NAMES istlport_vc71 stlport_gcc stlport_vc71 stlport)
FIND_LIBRARY(STLPORT_LIBRARY NAMES ${STLPORT_NAMES} PATHS ${OO_SDK_URE_LIB_DIR} ${OO_SDK_HOME_LIB_DIR} ENV ${ENV_LIB_VAR})
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(STLPort DEFAULT_MSG STLPORT_LIBRARY)
