/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.math.BigInteger;
import javax.naming.ldap.BasicControl;
import org.apache.harmony.jndi.internal.PagedResultSearchControlValue;
import org.apache.harmony.security.asn1.ASN1Integer;
import org.apache.harmony.security.asn1.ASN1OctetString;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;

public final class PagedResultsControl
extends BasicControl {
    private static final long serialVersionUID = 6684806685736844298L;
    public static final String OID = "1.2.840.113556.1.4.319";
    static ASN1Type ASN1_ENCODER = new ASN1Sequence(new ASN1Type[]{ASN1Integer.getInstance(), ASN1OctetString.getInstance()}){

        public Object getDecodedObject(BerInputStream in) {
            Object[] values = (Object[])in.content;
            int size = new BigInteger((byte[])values[0]).intValue();
            byte[] cookie = (byte[])values[1];
            return new PagedResultSearchControlValue(size, cookie);
        }

        public void getValues(Object object, Object[] values) {
            PagedResultSearchControlValue pg = (PagedResultSearchControlValue)object;
            values[0] = BigInteger.valueOf(pg.getSize()).toByteArray();
            values[1] = pg.getCookie() == null ? (Object)"".getBytes() : (Object)pg.getCookie();
        }
    };

    public PagedResultsControl(int pageSize, boolean criticality) throws IOException {
        super(OID, criticality, null);
        this.value = ASN1_ENCODER.encode((Object)new PagedResultSearchControlValue(pageSize, "".getBytes()));
    }

    public PagedResultsControl(int pageSize, byte[] cookie, boolean criticality) throws IOException {
        super(OID, criticality, null);
        this.value = ASN1_ENCODER.encode((Object)new PagedResultSearchControlValue(pageSize, cookie));
    }
}

