# - Find LIBRADOS
# Find the LIBRADOS includes and libraries.
# This module defines:
#  LIBRADOS_FOUND
#  LIBRADOS_INCLUDE_DIRS
#  LIBRADOS_LIBRARIES

find_package(PkgConfig QUIET)
pkg_check_modules(LIBRADOS QUIET rados)

find_path(LIBRADOS_INCLUDE_DIR
  NAMES librados.h
  PATHS ${LIBRADOS_INCLUDE_DIRS}
  PATH_SUFFIXES rados
)

if((NOT LIBRADOS_INCLUDE_DIRS) AND (LIBRADOS_INCLUDE_DIR))
  set(LIBRADOS_INCLUDE_DIRS ${LIBRADOS_INCLUDE_DIR})
elseif(LIBRADOS_INCLUDE_DIRS AND LIBRADOS_INCLUDE_DIR)
  list(APPEND LIBRADOS_INCLUDE_DIRS ${LIBRADOS_INCLUDE_DIR})
endif()

find_library(LIBRADOS_LIBRARY
  NAMES ${LIBRADOS_LIBRARIES} rados
)

if((NOT LIBRADOS_LIBRARIES) AND (LIBRADOS_LIBRARY))
  set(LIBRADOS_LIBRARIES ${LIBRADOS_LIBRARY})
elseif(LIBRADOS_LIBRARIES AND LIBRADOS_LIBRARY)
  list(APPEND LIBRADOS_LIBRARIES ${LIBRADOS_LIBRARY})
endif()

message(VERBOSE "LIBRADOS_INCLUDE_DIRS=${LIBRADOS_INCLUDE_DIRS}")
message(VERBOSE "LIBRADOS_INCLUDE_DIR=${LIBRADOS_INCLUDE_DIR}")
message(VERBOSE "LIBRADOS_LIBRARIES=${LIBRADOS_LIBRARIES}")
message(VERBOSE "LIBRADOS_LIBRARY=${LIBRADOS_LIBRARY}")

if((NOT LIBRADOS_FOUND) AND (LIBRADOS_INCLUDE_DIRS) AND (LIBRADOS_LIBRARIES))
  set(LIBRADOS_FOUND True)
endif()

if((NOT LIBRADOS_VERSION) AND (LIBRADOS_FOUND))
  file(STRINGS "${LIBRADOS_INCLUDE_DIR}/librados.h" _contents REGEX "#define LIBRADOS_VER_[A-Z]+[ \t]+")
  if(_contents)
    string(REGEX REPLACE ".*#define LIBRADOS_VER_MAJOR[ \t]+([0-9]+).*" "\\1" LIBRADOS_MAJOR_VERSION "${_contents}")
    string(REGEX REPLACE ".*#define LIBRADOS_VER_MINOR[ \t]+([0-9]+).*" "\\1" LIBRADOS_MINOR_VERSION "${_contents}")
    string(REGEX REPLACE ".*#define LIBRADOS_VER_EXTRA[ \t]+([0-9]+).*" "\\1" LIBRADOS_EXTRA_VERSION "${_contents}")

    set(LIBRADOS_VERSION ${LIBRADOS_MAJOR_VERSION}.${LIBRADOS_MINOR_VERSION}.${LIBRADOS_EXTRA_VERSION})
  endif()
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(LIBRADOS
  FOUND_VAR LIBRADOS_FOUND
  REQUIRED_VARS LIBRADOS_FOUND LIBRADOS_INCLUDE_DIRS LIBRADOS_LIBRARIES
  VERSION_VAR LIBRADOS_VERSION
)

mark_as_advanced(LIBRADOS_INCLUDE_DIR LIBRADOS_LIBRARY)
