/**
 * Looking Glass
 * Copyright (C) 2017-2021 The Looking Glass Authors
 * https://looking-glass.io
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <linux/input.h>
#include <SDL2/SDL.h>

//FIXME: this should be made static once config.c is no longer using SDL
//scancodes
uint32_t sdl_to_xfree86[SDL_NUM_SCANCODES] =
{
  [SDL_SCANCODE_UNKNOWN]             /* = USB   0 */ = KEY_RESERVED,
  [SDL_SCANCODE_A]                   /* = USB   4 */ = KEY_A,
  [SDL_SCANCODE_B]                   /* = USB   5 */ = KEY_B,
  [SDL_SCANCODE_C]                   /* = USB   6 */ = KEY_C,
  [SDL_SCANCODE_D]                   /* = USB   7 */ = KEY_D,
  [SDL_SCANCODE_E]                   /* = USB   8 */ = KEY_E,
  [SDL_SCANCODE_F]                   /* = USB   9 */ = KEY_F,
  [SDL_SCANCODE_G]                   /* = USB  10 */ = KEY_G,
  [SDL_SCANCODE_H]                   /* = USB  11 */ = KEY_H,
  [SDL_SCANCODE_I]                   /* = USB  12 */ = KEY_I,
  [SDL_SCANCODE_J]                   /* = USB  13 */ = KEY_J,
  [SDL_SCANCODE_K]                   /* = USB  14 */ = KEY_K,
  [SDL_SCANCODE_L]                   /* = USB  15 */ = KEY_L,
  [SDL_SCANCODE_M]                   /* = USB  16 */ = KEY_M,
  [SDL_SCANCODE_N]                   /* = USB  17 */ = KEY_N,
  [SDL_SCANCODE_O]                   /* = USB  18 */ = KEY_O,
  [SDL_SCANCODE_P]                   /* = USB  19 */ = KEY_P,
  [SDL_SCANCODE_Q]                   /* = USB  20 */ = KEY_Q,
  [SDL_SCANCODE_R]                   /* = USB  21 */ = KEY_R,
  [SDL_SCANCODE_S]                   /* = USB  22 */ = KEY_S,
  [SDL_SCANCODE_T]                   /* = USB  23 */ = KEY_T,
  [SDL_SCANCODE_U]                   /* = USB  24 */ = KEY_U,
  [SDL_SCANCODE_V]                   /* = USB  25 */ = KEY_V,
  [SDL_SCANCODE_W]                   /* = USB  26 */ = KEY_W,
  [SDL_SCANCODE_X]                   /* = USB  27 */ = KEY_X,
  [SDL_SCANCODE_Y]                   /* = USB  28 */ = KEY_Y,
  [SDL_SCANCODE_Z]                   /* = USB  29 */ = KEY_Z,
  [SDL_SCANCODE_1]                   /* = USB  30 */ = KEY_1,
  [SDL_SCANCODE_2]                   /* = USB  31 */ = KEY_2,
  [SDL_SCANCODE_3]                   /* = USB  32 */ = KEY_3,
  [SDL_SCANCODE_4]                   /* = USB  33 */ = KEY_4,
  [SDL_SCANCODE_5]                   /* = USB  34 */ = KEY_5,
  [SDL_SCANCODE_6]                   /* = USB  35 */ = KEY_6,
  [SDL_SCANCODE_7]                   /* = USB  36 */ = KEY_7,
  [SDL_SCANCODE_8]                   /* = USB  37 */ = KEY_8,
  [SDL_SCANCODE_9]                   /* = USB  38 */ = KEY_9,
  [SDL_SCANCODE_0]                   /* = USB  39 */ = KEY_0,
  [SDL_SCANCODE_RETURN]              /* = USB  40 */ = KEY_ENTER,
  [SDL_SCANCODE_ESCAPE]              /* = USB  41 */ = KEY_ESC,
  [SDL_SCANCODE_BACKSPACE]           /* = USB  42 */ = KEY_BACKSPACE,
  [SDL_SCANCODE_TAB]                 /* = USB  43 */ = KEY_TAB,
  [SDL_SCANCODE_SPACE]               /* = USB  44 */ = KEY_SPACE,
  [SDL_SCANCODE_MINUS]               /* = USB  45 */ = KEY_MINUS,
  [SDL_SCANCODE_EQUALS]              /* = USB  46 */ = KEY_EQUAL,
  [SDL_SCANCODE_LEFTBRACKET]         /* = USB  47 */ = KEY_LEFTBRACE,
  [SDL_SCANCODE_RIGHTBRACKET]        /* = USB  48 */ = KEY_RIGHTBRACE,
  [SDL_SCANCODE_BACKSLASH]           /* = USB  49 */ = KEY_BACKSLASH,
  [SDL_SCANCODE_SEMICOLON]           /* = USB  51 */ = KEY_SEMICOLON,
  [SDL_SCANCODE_APOSTROPHE]          /* = USB  52 */ = KEY_APOSTROPHE,
  [SDL_SCANCODE_GRAVE]               /* = USB  53 */ = KEY_GRAVE,
  [SDL_SCANCODE_COMMA]               /* = USB  54 */ = KEY_COMMA,
  [SDL_SCANCODE_PERIOD]              /* = USB  55 */ = KEY_DOT,
  [SDL_SCANCODE_SLASH]               /* = USB  56 */ = KEY_SLASH,
  [SDL_SCANCODE_CAPSLOCK]            /* = USB  57 */ = KEY_CAPSLOCK,
  [SDL_SCANCODE_F1]                  /* = USB  58 */ = KEY_F1,
  [SDL_SCANCODE_F2]                  /* = USB  59 */ = KEY_F2,
  [SDL_SCANCODE_F3]                  /* = USB  60 */ = KEY_F3,
  [SDL_SCANCODE_F4]                  /* = USB  61 */ = KEY_F4,
  [SDL_SCANCODE_F5]                  /* = USB  62 */ = KEY_F5,
  [SDL_SCANCODE_F6]                  /* = USB  63 */ = KEY_F6,
  [SDL_SCANCODE_F7]                  /* = USB  64 */ = KEY_F7,
  [SDL_SCANCODE_F8]                  /* = USB  65 */ = KEY_F8,
  [SDL_SCANCODE_F9]                  /* = USB  66 */ = KEY_F9,
  [SDL_SCANCODE_F10]                 /* = USB  67 */ = KEY_F10,
  [SDL_SCANCODE_F11]                 /* = USB  68 */ = KEY_F11,
  [SDL_SCANCODE_F12]                 /* = USB  69 */ = KEY_F12,
  [SDL_SCANCODE_PRINTSCREEN]         /* = USB  70 */ = KEY_SYSRQ,
  [SDL_SCANCODE_SCROLLLOCK]          /* = USB  71 */ = KEY_SCROLLLOCK,
  [SDL_SCANCODE_PAUSE]               /* = USB  72 */ = KEY_PAUSE,
  [SDL_SCANCODE_INSERT]              /* = USB  73 */ = KEY_INSERT,
  [SDL_SCANCODE_HOME]                /* = USB  74 */ = KEY_HOME,
  [SDL_SCANCODE_PAGEUP]              /* = USB  75 */ = KEY_PAGEUP,
  [SDL_SCANCODE_DELETE]              /* = USB  76 */ = KEY_DELETE,
  [SDL_SCANCODE_END]                 /* = USB  77 */ = KEY_END,
  [SDL_SCANCODE_PAGEDOWN]            /* = USB  78 */ = KEY_PAGEDOWN,
  [SDL_SCANCODE_RIGHT]               /* = USB  79 */ = KEY_RIGHT,
  [SDL_SCANCODE_LEFT]                /* = USB  80 */ = KEY_LEFT,
  [SDL_SCANCODE_DOWN]                /* = USB  81 */ = KEY_DOWN,
  [SDL_SCANCODE_UP]                  /* = USB  82 */ = KEY_UP,
  [SDL_SCANCODE_NUMLOCKCLEAR]        /* = USB  83 */ = KEY_NUMLOCK,
  [SDL_SCANCODE_KP_DIVIDE]           /* = USB  84 */ = KEY_KPSLASH,
  [SDL_SCANCODE_KP_MULTIPLY]         /* = USB  85 */ = KEY_KPASTERISK,
  [SDL_SCANCODE_KP_MINUS]            /* = USB  86 */ = KEY_KPMINUS,
  [SDL_SCANCODE_KP_PLUS]             /* = USB  87 */ = KEY_KPPLUS,
  [SDL_SCANCODE_KP_ENTER]            /* = USB  88 */ = KEY_KPENTER,
  [SDL_SCANCODE_KP_1]                /* = USB  89 */ = KEY_KP1,
  [SDL_SCANCODE_KP_2]                /* = USB  90 */ = KEY_KP2,
  [SDL_SCANCODE_KP_3]                /* = USB  91 */ = KEY_KP3,
  [SDL_SCANCODE_KP_4]                /* = USB  92 */ = KEY_KP4,
  [SDL_SCANCODE_KP_5]                /* = USB  93 */ = KEY_KP5,
  [SDL_SCANCODE_KP_6]                /* = USB  94 */ = KEY_KP6,
  [SDL_SCANCODE_KP_7]                /* = USB  95 */ = KEY_KP7,
  [SDL_SCANCODE_KP_8]                /* = USB  96 */ = KEY_KP8,
  [SDL_SCANCODE_KP_9]                /* = USB  97 */ = KEY_KP9,
  [SDL_SCANCODE_KP_0]                /* = USB  98 */ = KEY_KP0,
  [SDL_SCANCODE_KP_PERIOD]           /* = USB  99 */ = KEY_KPDOT,
  [SDL_SCANCODE_NONUSBACKSLASH]      /* = USB 100 */ = KEY_102ND,
  [SDL_SCANCODE_APPLICATION]         /* = USB 101 */ = KEY_COMPOSE,
  [SDL_SCANCODE_POWER]               /* = USB 102 */ = KEY_POWER,
  [SDL_SCANCODE_KP_EQUALS]           /* = USB 103 */ = KEY_KPEQUAL,
  [SDL_SCANCODE_F13]                 /* = USB 104 */ = KEY_CONFIG,
  [SDL_SCANCODE_F14]                 /* = USB 105 */ = KEY_F14,
  [SDL_SCANCODE_F15]                 /* = USB 106 */ = KEY_F15,
  [SDL_SCANCODE_F16]                 /* = USB 107 */ = KEY_F16,
  [SDL_SCANCODE_F17]                 /* = USB 108 */ = KEY_F17,
  [SDL_SCANCODE_F18]                 /* = USB 109 */ = KEY_F18,
  [SDL_SCANCODE_F19]                 /* = USB 110 */ = KEY_F19,
  [SDL_SCANCODE_F20]                 /* = USB 111 */ = KEY_F20,
  [SDL_SCANCODE_HELP]                /* = USB 117 */ = KEY_HELP,
  [SDL_SCANCODE_MENU]                /* = USB 118 */ = KEY_MENU,
  [SDL_SCANCODE_STOP]                /* = USB 120 */ = KEY_CANCEL,
  [SDL_SCANCODE_AGAIN]               /* = USB 121 */ = KEY_AGAIN,
  [SDL_SCANCODE_UNDO]                /* = USB 122 */ = KEY_UNDO,
  [SDL_SCANCODE_CUT]                 /* = USB 123 */ = KEY_CUT,
  [SDL_SCANCODE_COPY]                /* = USB 124 */ = KEY_COPY,
  [SDL_SCANCODE_PASTE]               /* = USB 125 */ = KEY_PASTE,
  [SDL_SCANCODE_FIND]                /* = USB 126 */ = KEY_FIND,
  [SDL_SCANCODE_MUTE]                /* = USB 127 */ = KEY_MUTE,
  [SDL_SCANCODE_VOLUMEUP]            /* = USB 128 */ = KEY_VOLUMEUP,
  [SDL_SCANCODE_VOLUMEDOWN]          /* = USB 129 */ = KEY_VOLUMEDOWN,
  [SDL_SCANCODE_KP_COMMA]            /* = USB 133 */ = KEY_KPCOMMA,
  [SDL_SCANCODE_INTERNATIONAL1]      /* = USB 135 */ = KEY_RO,
  [SDL_SCANCODE_INTERNATIONAL2]      /* = USB 136 */ = KEY_KATAKANAHIRAGANA,
  [SDL_SCANCODE_INTERNATIONAL3]      /* = USB 137 */ = KEY_YEN,
  [SDL_SCANCODE_INTERNATIONAL4]      /* = USB 138 */ = KEY_HENKAN,
  [SDL_SCANCODE_INTERNATIONAL5]      /* = USB 139 */ = KEY_MUHENKAN,
  [SDL_SCANCODE_LANG1]               /* = USB 144 */ = KEY_HANGEUL,
  [SDL_SCANCODE_LANG2]               /* = USB 145 */ = KEY_HANJA,
  [SDL_SCANCODE_SYSREQ]              /* = USB 154 */ = KEY_RIGHTSHIFT,
  [SDL_SCANCODE_CANCEL]              /* = USB 155 */ = KEY_STOP,
  [SDL_SCANCODE_KP_LEFTPAREN]        /* = USB 182 */ = KEY_KPLEFTPAREN,
  [SDL_SCANCODE_KP_RIGHTPAREN]       /* = USB 183 */ = KEY_KPRIGHTPAREN,
  [SDL_SCANCODE_KP_PLUSMINUS]        /* = USB 215 */ = KEY_KPPLUSMINUS,
  [SDL_SCANCODE_LCTRL]               /* = USB 224 */ = KEY_LEFTCTRL,
  [SDL_SCANCODE_LSHIFT]              /* = USB 225 */ = KEY_LEFTSHIFT,
  [SDL_SCANCODE_LALT]                /* = USB 226 */ = KEY_LEFTALT,
  [SDL_SCANCODE_LGUI]                /* = USB 227 */ = KEY_LEFTMETA,
  [SDL_SCANCODE_RCTRL]               /* = USB 228 */ = KEY_RIGHTCTRL,
  [SDL_SCANCODE_RSHIFT]              /* = USB 229 */ = KEY_RIGHTSHIFT,
  [SDL_SCANCODE_RALT]                /* = USB 230 */ = KEY_RIGHTALT,
  [SDL_SCANCODE_RGUI]                /* = USB 231 */ = KEY_RIGHTMETA,
  [SDL_SCANCODE_MODE]                /* = USB 257 */ = KEY_ZENKAKUHANKAKU,
  [SDL_SCANCODE_AUDIONEXT]           /* = USB 258 */ = KEY_NEXTSONG,
  [SDL_SCANCODE_AUDIOPREV]           /* = USB 259 */ = KEY_PREVIOUSSONG,
  [SDL_SCANCODE_AUDIOSTOP]           /* = USB 260 */ = KEY_STOPCD,
  [SDL_SCANCODE_AUDIOPLAY]           /* = USB 261 */ = KEY_PLAYPAUSE,
  [SDL_SCANCODE_MEDIASELECT]         /* = USB 263 */ = KEY_MEDIA,
  [SDL_SCANCODE_WWW]                 /* = USB 264 */ = KEY_WWW,
  [SDL_SCANCODE_MAIL]                /* = USB 265 */ = KEY_MAIL,
  [SDL_SCANCODE_CALCULATOR]          /* = USB 266 */ = KEY_CALC,
  [SDL_SCANCODE_COMPUTER]            /* = USB 267 */ = KEY_COMPUTER,
  [SDL_SCANCODE_AC_SEARCH]           /* = USB 268 */ = KEY_SEARCH,
  [SDL_SCANCODE_AC_HOME]             /* = USB 269 */ = KEY_HOMEPAGE,
  [SDL_SCANCODE_AC_BACK]             /* = USB 270 */ = KEY_BACK,
  [SDL_SCANCODE_AC_FORWARD]          /* = USB 271 */ = KEY_FORWARD,
  [SDL_SCANCODE_AC_REFRESH]          /* = USB 273 */ = KEY_REFRESH,
  [SDL_SCANCODE_AC_BOOKMARKS]        /* = USB 274 */ = KEY_BOOKMARKS,
  [SDL_SCANCODE_BRIGHTNESSDOWN]      /* = USB 275 */ = KEY_BRIGHTNESSDOWN,
  [SDL_SCANCODE_BRIGHTNESSUP]        /* = USB 276 */ = KEY_BRIGHTNESSUP,
  [SDL_SCANCODE_DISPLAYSWITCH]       /* = USB 277 */ = KEY_SWITCHVIDEOMODE,
  [SDL_SCANCODE_KBDILLUMTOGGLE]      /* = USB 278 */ = KEY_KBDILLUMTOGGLE,
  [SDL_SCANCODE_KBDILLUMDOWN]        /* = USB 279 */ = KEY_KBDILLUMDOWN,
  [SDL_SCANCODE_KBDILLUMUP]          /* = USB 280 */ = KEY_KBDILLUMUP,
  [SDL_SCANCODE_EJECT]               /* = USB 281 */ = KEY_EJECTCD,
  [SDL_SCANCODE_SLEEP]               /* = USB 282 */ = KEY_SLEEP,
  [SDL_SCANCODE_APP1]                /* = USB 283 */ = KEY_PROG1,
  [SDL_SCANCODE_APP2]                /* = USB 284 */ = KEY_PROG2,
  [SDL_SCANCODE_AUDIOREWIND]         /* = USB 285 */ = KEY_REWIND,
  [SDL_SCANCODE_AUDIOFASTFORWARD]    /* = USB 286 */ = KEY_FASTFORWARD,
};
