; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC
;
; Test cases specifically designed for the "returned" argument attribute.
; We use FIXME's to indicate problems and missing attributes.
;

; TEST SCC test returning an integer value argument
;
; int scc_r1(int a, int b, int r);
; int scc_r2(int a, int b, int r);
;
; __attribute__((noinline)) int sink_r0(int r) {
;   return r;
; }
;
; __attribute__((noinline)) int scc_r1(int a, int r, int b) {
;   return scc_r2(r, a, sink_r0(r));
; }
;
; __attribute__((noinline)) int scc_r2(int a, int b, int r) {
;   if (a > b)
;     return scc_r2(b, a, sink_r0(r));
;   if (a < b)
;     return scc_r1(sink_r0(b), scc_r2(scc_r1(a, b, r), scc_r1(a, scc_r2(r, r, r), r), scc_r2(a, b, r)), scc_r1(a, b, r));
;   return a == b ? r : scc_r2(a, b, r);
; }
; __attribute__((noinline)) int scc_rX(int a, int b, int r) {
;   if (a > b)
;     return scc_r2(b, a, sink_r0(r));
;   if (a < b)                                                                         // V Diff to scc_r2
;     return scc_r1(sink_r0(b), scc_r2(scc_r1(a, b, r), scc_r1(a, scc_r2(r, r, r), r), scc_r1(a, b, r)), scc_r1(a, b, r));
;   return a == b ? r : scc_r2(a, b, r);
; }
target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

;.
; CHECK: @G = external global i8
; CHECK: @_ZTI1X = external dso_local constant { ptr, ptr }, align 8
; CHECK: @_ZTI1Y = external dso_local constant { ptr, ptr, ptr }, align 8
;.
define i32 @sink_r0(i32 %r) #0 {
; CHECK: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; CHECK-LABEL: define {{[^@]+}}@sink_r0
; CHECK-SAME: (i32 returned [[R:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 [[R]]
;
entry:
  ret i32 %r
}

define i32 @scc_r1(i32 %a, i32 %r, i32 %b) #0 {
; TUNIT: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; TUNIT-LABEL: define {{[^@]+}}@scc_r1
; TUNIT-SAME: (i32 [[A:%.*]], i32 returned [[R:%.*]], i32 [[B:%.*]]) #[[ATTR1:[0-9]+]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CALL1:%.*]] = call i32 @scc_r2(i32 [[R]], i32 [[A]], i32 [[R]]) #[[ATTR8:[0-9]+]]
; TUNIT-NEXT:    ret i32 [[R]]
;
; CGSCC: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; CGSCC-LABEL: define {{[^@]+}}@scc_r1
; CGSCC-SAME: (i32 [[A:%.*]], i32 returned [[R:%.*]], i32 [[B:%.*]]) #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CALL1:%.*]] = call i32 @scc_r2(i32 [[R]], i32 [[A]], i32 [[R]]) #[[ATTR7:[0-9]+]]
; CGSCC-NEXT:    ret i32 [[R]]
;
entry:
  %call = call i32 @sink_r0(i32 %r)
  %call1 = call i32 @scc_r2(i32 %r, i32 %a, i32 %call)
  ret i32 %call1
}

define i32 @scc_r2(i32 %a, i32 %b, i32 %r) #0 {
; TUNIT: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; TUNIT-LABEL: define {{[^@]+}}@scc_r2
; TUNIT-SAME: (i32 [[A:%.*]], i32 [[B:%.*]], i32 returned [[R:%.*]]) #[[ATTR1]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], [[B]]
; TUNIT-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; TUNIT:       if.then:
; TUNIT-NEXT:    [[CALL1:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[A]], i32 [[R]]) #[[ATTR8]]
; TUNIT-NEXT:    br label [[RETURN:%.*]]
; TUNIT:       if.end:
; TUNIT-NEXT:    [[CMP2:%.*]] = icmp slt i32 [[A]], [[B]]
; TUNIT-NEXT:    br i1 [[CMP2]], label [[IF_THEN3:%.*]], label [[IF_END12:%.*]]
; TUNIT:       if.then3:
; TUNIT-NEXT:    [[CALL5:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[B]], i32 undef) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL6:%.*]] = call i32 @scc_r2(i32 [[R]], i32 [[R]], i32 [[R]]) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL7:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[R]], i32 undef) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL8:%.*]] = call i32 @scc_r2(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL9:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[R]], i32 [[R]]) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL11:%.*]] = call i32 @scc_r1(i32 [[B]], i32 [[R]], i32 undef) #[[ATTR8]]
; TUNIT-NEXT:    br label [[RETURN]]
; TUNIT:       if.end12:
; TUNIT-NEXT:    [[CMP13:%.*]] = icmp eq i32 [[A]], [[B]]
; TUNIT-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
; TUNIT:       cond.true:
; TUNIT-NEXT:    br label [[COND_END:%.*]]
; TUNIT:       cond.false:
; TUNIT-NEXT:    [[CALL14:%.*]] = call i32 @scc_r2(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR8]]
; TUNIT-NEXT:    br label [[COND_END]]
; TUNIT:       cond.end:
; TUNIT-NEXT:    [[COND:%.*]] = phi i32 [ [[R]], [[COND_TRUE]] ], [ [[R]], [[COND_FALSE]] ]
; TUNIT-NEXT:    br label [[RETURN]]
; TUNIT:       return:
; TUNIT-NEXT:    [[RETVAL_0:%.*]] = phi i32 [ [[R]], [[IF_THEN]] ], [ [[R]], [[IF_THEN3]] ], [ [[R]], [[COND_END]] ]
; TUNIT-NEXT:    ret i32 [[R]]
;
; CGSCC: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; CGSCC-LABEL: define {{[^@]+}}@scc_r2
; CGSCC-SAME: (i32 [[A:%.*]], i32 [[B:%.*]], i32 returned [[R:%.*]]) #[[ATTR1]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], [[B]]
; CGSCC-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CGSCC:       if.then:
; CGSCC-NEXT:    [[CALL1:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[A]], i32 [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    br label [[RETURN:%.*]]
; CGSCC:       if.end:
; CGSCC-NEXT:    [[CMP2:%.*]] = icmp slt i32 [[A]], [[B]]
; CGSCC-NEXT:    br i1 [[CMP2]], label [[IF_THEN3:%.*]], label [[IF_END12:%.*]]
; CGSCC:       if.then3:
; CGSCC-NEXT:    [[CALL5:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[B]], i32 undef) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL6:%.*]] = call i32 @scc_r2(i32 [[R]], i32 [[R]], i32 [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL7:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[R]], i32 undef) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL8:%.*]] = call i32 @scc_r2(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL9:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[R]], i32 [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL11:%.*]] = call i32 @scc_r1(i32 [[B]], i32 [[R]], i32 undef) #[[ATTR7]]
; CGSCC-NEXT:    br label [[RETURN]]
; CGSCC:       if.end12:
; CGSCC-NEXT:    [[CMP13:%.*]] = icmp eq i32 [[A]], [[B]]
; CGSCC-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
; CGSCC:       cond.true:
; CGSCC-NEXT:    br label [[COND_END:%.*]]
; CGSCC:       cond.false:
; CGSCC-NEXT:    [[CALL14:%.*]] = call i32 @scc_r2(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    br label [[COND_END]]
; CGSCC:       cond.end:
; CGSCC-NEXT:    [[COND:%.*]] = phi i32 [ [[R]], [[COND_TRUE]] ], [ [[R]], [[COND_FALSE]] ]
; CGSCC-NEXT:    br label [[RETURN]]
; CGSCC:       return:
; CGSCC-NEXT:    [[RETVAL_0:%.*]] = phi i32 [ [[R]], [[IF_THEN]] ], [ [[R]], [[IF_THEN3]] ], [ [[R]], [[COND_END]] ]
; CGSCC-NEXT:    ret i32 [[R]]
;
entry:
  %cmp = icmp sgt i32 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  %call = call i32 @sink_r0(i32 %r)
  %call1 = call i32 @scc_r2(i32 %b, i32 %a, i32 %call)
  br label %return

if.end:                                           ; preds = %entry
  %cmp2 = icmp slt i32 %a, %b
  br i1 %cmp2, label %if.then3, label %if.end12

if.then3:                                         ; preds = %if.end
  %call4 = call i32 @sink_r0(i32 %b)
  %call5 = call i32 @scc_r1(i32 %a, i32 %b, i32 %r)
  %call6 = call i32 @scc_r2(i32 %r, i32 %r, i32 %r)
  %call7 = call i32 @scc_r1(i32 %a, i32 %call6, i32 %r)
  %call8 = call i32 @scc_r2(i32 %a, i32 %b, i32 %r)
  %call9 = call i32 @scc_r2(i32 %call5, i32 %call7, i32 %call8)
  %call10 = call i32 @scc_r1(i32 %a, i32 %b, i32 %r)
  %call11 = call i32 @scc_r1(i32 %call4, i32 %call9, i32 %call10)
  br label %return

if.end12:                                         ; preds = %if.end
  %cmp13 = icmp eq i32 %a, %b
  br i1 %cmp13, label %cond.true, label %cond.false

cond.true:                                        ; preds = %if.end12
  br label %cond.end

cond.false:                                       ; preds = %if.end12
  %call14 = call i32 @scc_r2(i32 %a, i32 %b, i32 %r)
  br label %cond.end

cond.end:                                         ; preds = %cond.false, %cond.true
  %cond = phi i32 [ %r, %cond.true ], [ %call14, %cond.false ]
  br label %return

return:                                           ; preds = %cond.end, %if.then3, %if.then
  %retval.0 = phi i32 [ %call1, %if.then ], [ %call11, %if.then3 ], [ %cond, %cond.end ]
  ret i32 %retval.0
}

define i32 @scc_rX(i32 %a, i32 %b, i32 %r) #0 {
; TUNIT: Function Attrs: nofree noinline norecurse nosync nounwind memory(none) uwtable
; TUNIT-LABEL: define {{[^@]+}}@scc_rX
; TUNIT-SAME: (i32 [[A:%.*]], i32 [[B:%.*]], i32 [[R:%.*]]) #[[ATTR2:[0-9]+]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], [[B]]
; TUNIT-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; TUNIT:       if.then:
; TUNIT-NEXT:    [[CALL1:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[A]], i32 [[R]]) #[[ATTR8]]
; TUNIT-NEXT:    br label [[RETURN:%.*]]
; TUNIT:       if.end:
; TUNIT-NEXT:    [[CMP2:%.*]] = icmp slt i32 [[A]], [[B]]
; TUNIT-NEXT:    br i1 [[CMP2]], label [[IF_THEN3:%.*]], label [[IF_END12:%.*]]
; TUNIT:       if.then3:
; TUNIT-NEXT:    [[CALL5:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[B]], i32 undef) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL6:%.*]] = call i32 @scc_r2(i32 [[R]], i32 [[R]], i32 [[R]]) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL7:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[R]], i32 undef) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL8:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[B]], i32 undef) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL9:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[R]], i32 [[B]]) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL11:%.*]] = call i32 @scc_r1(i32 [[B]], i32 [[B]], i32 undef) #[[ATTR8]]
; TUNIT-NEXT:    br label [[RETURN]]
; TUNIT:       if.end12:
; TUNIT-NEXT:    [[CMP13:%.*]] = icmp eq i32 [[A]], [[B]]
; TUNIT-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
; TUNIT:       cond.true:
; TUNIT-NEXT:    br label [[COND_END:%.*]]
; TUNIT:       cond.false:
; TUNIT-NEXT:    [[CALL14:%.*]] = call i32 @scc_r2(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR8]]
; TUNIT-NEXT:    br label [[COND_END]]
; TUNIT:       cond.end:
; TUNIT-NEXT:    [[COND:%.*]] = phi i32 [ [[R]], [[COND_TRUE]] ], [ [[R]], [[COND_FALSE]] ]
; TUNIT-NEXT:    br label [[RETURN]]
; TUNIT:       return:
; TUNIT-NEXT:    [[RETVAL_0:%.*]] = phi i32 [ [[R]], [[IF_THEN]] ], [ [[B]], [[IF_THEN3]] ], [ [[R]], [[COND_END]] ]
; TUNIT-NEXT:    ret i32 [[RETVAL_0]]
;
; CGSCC: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; CGSCC-LABEL: define {{[^@]+}}@scc_rX
; CGSCC-SAME: (i32 [[A:%.*]], i32 [[B:%.*]], i32 [[R:%.*]]) #[[ATTR1]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], [[B]]
; CGSCC-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CGSCC:       if.then:
; CGSCC-NEXT:    [[CALL1:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[A]], i32 [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    br label [[RETURN:%.*]]
; CGSCC:       if.end:
; CGSCC-NEXT:    [[CMP2:%.*]] = icmp slt i32 [[A]], [[B]]
; CGSCC-NEXT:    br i1 [[CMP2]], label [[IF_THEN3:%.*]], label [[IF_END12:%.*]]
; CGSCC:       if.then3:
; CGSCC-NEXT:    [[CALL5:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL6:%.*]] = call i32 @scc_r2(i32 [[R]], i32 [[R]], i32 [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL7:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[R]], i32 [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL8:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL9:%.*]] = call i32 @scc_r2(i32 [[B]], i32 [[R]], i32 [[B]]) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL10:%.*]] = call i32 @scc_r1(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL11:%.*]] = call i32 @scc_r1(i32 [[B]], i32 [[B]], i32 [[B]]) #[[ATTR7]]
; CGSCC-NEXT:    br label [[RETURN]]
; CGSCC:       if.end12:
; CGSCC-NEXT:    [[CMP13:%.*]] = icmp eq i32 [[A]], [[B]]
; CGSCC-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
; CGSCC:       cond.true:
; CGSCC-NEXT:    br label [[COND_END:%.*]]
; CGSCC:       cond.false:
; CGSCC-NEXT:    [[CALL14:%.*]] = call i32 @scc_r2(i32 [[A]], i32 [[B]], i32 [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    br label [[COND_END]]
; CGSCC:       cond.end:
; CGSCC-NEXT:    [[COND:%.*]] = phi i32 [ [[R]], [[COND_TRUE]] ], [ [[CALL14]], [[COND_FALSE]] ]
; CGSCC-NEXT:    br label [[RETURN]]
; CGSCC:       return:
; CGSCC-NEXT:    [[RETVAL_0:%.*]] = phi i32 [ [[CALL1]], [[IF_THEN]] ], [ [[CALL11]], [[IF_THEN3]] ], [ [[R]], [[COND_END]] ]
; CGSCC-NEXT:    ret i32 [[RETVAL_0]]
;
entry:
  %cmp = icmp sgt i32 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  %call = call i32 @sink_r0(i32 %r)
  %call1 = call i32 @scc_r2(i32 %b, i32 %a, i32 %call)
  br label %return

if.end:                                           ; preds = %entry
  %cmp2 = icmp slt i32 %a, %b
  br i1 %cmp2, label %if.then3, label %if.end12

if.then3:                                         ; preds = %if.end
  %call4 = call i32 @sink_r0(i32 %b)
  %call5 = call i32 @scc_r1(i32 %a, i32 %b, i32 %r)
  %call6 = call i32 @scc_r2(i32 %r, i32 %r, i32 %r)
  %call7 = call i32 @scc_r1(i32 %a, i32 %call6, i32 %r)
  %call8 = call i32 @scc_r1(i32 %a, i32 %b, i32 %r)
  %call9 = call i32 @scc_r2(i32 %call5, i32 %call7, i32 %call8)
  %call10 = call i32 @scc_r1(i32 %a, i32 %b, i32 %r)
  %call11 = call i32 @scc_r1(i32 %call4, i32 %call9, i32 %call10)
  br label %return

if.end12:                                         ; preds = %if.end
  %cmp13 = icmp eq i32 %a, %b
  br i1 %cmp13, label %cond.true, label %cond.false

cond.true:                                        ; preds = %if.end12
  br label %cond.end

cond.false:                                       ; preds = %if.end12
  %call14 = call i32 @scc_r2(i32 %a, i32 %b, i32 %r)
  br label %cond.end

cond.end:                                         ; preds = %cond.false, %cond.true
  %cond = phi i32 [ %r, %cond.true ], [ %call14, %cond.false ]
  br label %return

return:                                           ; preds = %cond.end, %if.then3, %if.then
  %retval.0 = phi i32 [ %call1, %if.then ], [ %call11, %if.then3 ], [ %cond, %cond.end ]
  ret i32 %retval.0
}


; TEST SCC test returning a pointer value argument
;
; double* ptr_scc_r1(double* a, double* b, double* r);
; double* ptr_scc_r2(double* a, double* b, double* r);
;
; __attribute__((noinline)) double* ptr_sink_r0(double* r) {
;   return r;
; }
;
; __attribute__((noinline)) double* ptr_scc_r1(double* a, double* r, double* b) {
;   return ptr_scc_r2(r, a, ptr_sink_r0(r));
; }
;
; __attribute__((noinline)) double* ptr_scc_r2(double* a, double* b, double* r) {
;   if (a > b)
;     return ptr_scc_r2(b, a, ptr_sink_r0(r));
;   if (a < b)
;     return ptr_scc_r1(ptr_sink_r0(b), ptr_scc_r2(ptr_scc_r1(a, b, r), ptr_scc_r1(a, ptr_scc_r2(r, r, r), r), ptr_scc_r2(a, b, r)), ptr_scc_r1(a, b, r));
;   return a == b ? r : ptr_scc_r2(a, b, r);
; }
define ptr @ptr_sink_r0(ptr %r) #0 {
; CHECK: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; CHECK-LABEL: define {{[^@]+}}@ptr_sink_r0
; CHECK-SAME: (ptr nofree readnone returned "no-capture-maybe-returned" [[R:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret ptr [[R]]
;
entry:
  ret ptr %r
}

define ptr @ptr_scc_r1(ptr %a, ptr %r, ptr %b) #0 {
; TUNIT: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; TUNIT-LABEL: define {{[^@]+}}@ptr_scc_r1
; TUNIT-SAME: (ptr nocapture nofree readnone [[A:%.*]], ptr nofree readnone returned "no-capture-maybe-returned" [[R:%.*]], ptr nocapture nofree readnone [[B:%.*]]) #[[ATTR1]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CALL1:%.*]] = call ptr @ptr_scc_r2(ptr noalias nocapture nofree readnone [[R]], ptr noalias nocapture nofree readnone [[A]], ptr noalias nofree readnone "no-capture-maybe-returned" [[R]]) #[[ATTR8]]
; TUNIT-NEXT:    ret ptr [[R]]
;
; CGSCC: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; CGSCC-LABEL: define {{[^@]+}}@ptr_scc_r1
; CGSCC-SAME: (ptr nocapture nofree readnone [[A:%.*]], ptr nofree readnone returned [[R:%.*]], ptr nocapture nofree readnone [[B:%.*]]) #[[ATTR1]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CALL1:%.*]] = call ptr @ptr_scc_r2(ptr noalias nocapture nofree readnone [[R]], ptr noalias nocapture nofree readnone [[A]], ptr noalias nofree readnone [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    ret ptr [[R]]
;
entry:
  %call = call ptr @ptr_sink_r0(ptr %r)
  %call1 = call ptr @ptr_scc_r2(ptr %r, ptr %a, ptr %call)
  ret ptr %call1
}

define ptr @ptr_scc_r2(ptr %a, ptr %b, ptr %r) #0 {
; TUNIT: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; TUNIT-LABEL: define {{[^@]+}}@ptr_scc_r2
; TUNIT-SAME: (ptr nocapture nofree readnone [[A:%.*]], ptr nocapture nofree readnone [[B:%.*]], ptr nofree readnone returned "no-capture-maybe-returned" [[R:%.*]]) #[[ATTR1]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CMP:%.*]] = icmp ugt ptr [[A]], [[B]]
; TUNIT-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; TUNIT:       if.then:
; TUNIT-NEXT:    [[CALL1:%.*]] = call ptr @ptr_scc_r2(ptr noalias nocapture nofree readnone [[B]], ptr noalias nocapture nofree nonnull readnone [[A]], ptr noalias nofree readnone "no-capture-maybe-returned" [[R]]) #[[ATTR8]]
; TUNIT-NEXT:    br label [[RETURN:%.*]]
; TUNIT:       if.end:
; TUNIT-NEXT:    [[CMP2:%.*]] = icmp ult ptr [[A]], [[B]]
; TUNIT-NEXT:    br i1 [[CMP2]], label [[IF_THEN3:%.*]], label [[IF_END12:%.*]]
; TUNIT:       if.then3:
; TUNIT-NEXT:    [[CALL5:%.*]] = call ptr @ptr_scc_r1(ptr noalias nocapture nofree readnone [[A]], ptr noalias nofree nonnull readnone "no-capture-maybe-returned" [[B]], ptr noalias nocapture nofree readnone undef) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL6:%.*]] = call ptr @ptr_scc_r2(ptr noalias nocapture nofree readnone [[R]], ptr noalias nocapture nofree readnone [[R]], ptr noalias nofree readnone "no-capture-maybe-returned" [[R]]) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL7:%.*]] = call ptr @ptr_scc_r1(ptr noalias nocapture nofree readnone [[A]], ptr noalias nofree readnone "no-capture-maybe-returned" [[R]], ptr noalias nocapture nofree readnone undef) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL8:%.*]] = call ptr @ptr_scc_r2(ptr noalias nocapture nofree readnone [[A]], ptr noalias nocapture nofree nonnull readnone [[B]], ptr noalias nofree readnone "no-capture-maybe-returned" [[R]]) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL9:%.*]] = call ptr @ptr_scc_r2(ptr noalias nocapture nofree readnone [[B]], ptr noalias nocapture nofree readnone [[R]], ptr noalias nofree readnone "no-capture-maybe-returned" [[R]]) #[[ATTR8]]
; TUNIT-NEXT:    [[CALL11:%.*]] = call ptr @ptr_scc_r1(ptr noalias nocapture nofree readnone [[B]], ptr noalias nofree readnone "no-capture-maybe-returned" [[R]], ptr noalias nocapture nofree readnone undef) #[[ATTR8]]
; TUNIT-NEXT:    br label [[RETURN]]
; TUNIT:       if.end12:
; TUNIT-NEXT:    [[CMP13:%.*]] = icmp eq ptr [[A]], [[B]]
; TUNIT-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
; TUNIT:       cond.true:
; TUNIT-NEXT:    br label [[COND_END:%.*]]
; TUNIT:       cond.false:
; TUNIT-NEXT:    [[CALL14:%.*]] = call ptr @ptr_scc_r2(ptr noalias nocapture nofree readnone [[A]], ptr noalias nocapture nofree readnone [[B]], ptr noalias nofree readnone "no-capture-maybe-returned" [[R]]) #[[ATTR8]]
; TUNIT-NEXT:    br label [[COND_END]]
; TUNIT:       cond.end:
; TUNIT-NEXT:    [[COND:%.*]] = phi ptr [ [[R]], [[COND_TRUE]] ], [ [[R]], [[COND_FALSE]] ]
; TUNIT-NEXT:    br label [[RETURN]]
; TUNIT:       return:
; TUNIT-NEXT:    [[RETVAL_0:%.*]] = phi ptr [ [[R]], [[IF_THEN]] ], [ [[R]], [[IF_THEN3]] ], [ [[R]], [[COND_END]] ]
; TUNIT-NEXT:    ret ptr [[R]]
;
; CGSCC: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; CGSCC-LABEL: define {{[^@]+}}@ptr_scc_r2
; CGSCC-SAME: (ptr nocapture nofree readnone [[A:%.*]], ptr nocapture nofree readnone [[B:%.*]], ptr nofree readnone returned [[R:%.*]]) #[[ATTR1]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CMP:%.*]] = icmp ugt ptr [[A]], [[B]]
; CGSCC-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CGSCC:       if.then:
; CGSCC-NEXT:    [[CALL1:%.*]] = call ptr @ptr_scc_r2(ptr noalias nocapture nofree readnone [[B]], ptr noalias nocapture nofree nonnull readnone [[A]], ptr noalias nofree readnone [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    br label [[RETURN:%.*]]
; CGSCC:       if.end:
; CGSCC-NEXT:    [[CMP2:%.*]] = icmp ult ptr [[A]], [[B]]
; CGSCC-NEXT:    br i1 [[CMP2]], label [[IF_THEN3:%.*]], label [[IF_END12:%.*]]
; CGSCC:       if.then3:
; CGSCC-NEXT:    [[CALL5:%.*]] = call ptr @ptr_scc_r1(ptr noalias nocapture nofree readnone [[A]], ptr noalias nofree nonnull readnone [[B]], ptr noalias nocapture nofree readnone undef) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL6:%.*]] = call ptr @ptr_scc_r2(ptr noalias nocapture nofree readnone [[R]], ptr noalias nocapture nofree readnone [[R]], ptr noalias nofree readnone [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL7:%.*]] = call ptr @ptr_scc_r1(ptr noalias nocapture nofree readnone [[A]], ptr noalias nofree readnone [[R]], ptr noalias nocapture nofree readnone undef) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL8:%.*]] = call ptr @ptr_scc_r2(ptr noalias nocapture nofree readnone [[A]], ptr noalias nocapture nofree nonnull readnone [[B]], ptr noalias nofree readnone [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL9:%.*]] = call ptr @ptr_scc_r2(ptr noalias nocapture nofree readnone [[B]], ptr noalias nocapture nofree readnone [[R]], ptr noalias nofree readnone [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    [[CALL11:%.*]] = call ptr @ptr_scc_r1(ptr noalias nocapture nofree nonnull readnone [[B]], ptr noalias nofree readnone [[R]], ptr noalias nocapture nofree readnone undef) #[[ATTR7]]
; CGSCC-NEXT:    br label [[RETURN]]
; CGSCC:       if.end12:
; CGSCC-NEXT:    [[CMP13:%.*]] = icmp eq ptr [[A]], [[B]]
; CGSCC-NEXT:    br i1 [[CMP13]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
; CGSCC:       cond.true:
; CGSCC-NEXT:    br label [[COND_END:%.*]]
; CGSCC:       cond.false:
; CGSCC-NEXT:    [[CALL14:%.*]] = call ptr @ptr_scc_r2(ptr noalias nocapture nofree readnone [[A]], ptr noalias nocapture nofree readnone [[B]], ptr noalias nofree readnone [[R]]) #[[ATTR7]]
; CGSCC-NEXT:    br label [[COND_END]]
; CGSCC:       cond.end:
; CGSCC-NEXT:    [[COND:%.*]] = phi ptr [ [[R]], [[COND_TRUE]] ], [ [[R]], [[COND_FALSE]] ]
; CGSCC-NEXT:    br label [[RETURN]]
; CGSCC:       return:
; CGSCC-NEXT:    [[RETVAL_0:%.*]] = phi ptr [ [[R]], [[IF_THEN]] ], [ [[R]], [[IF_THEN3]] ], [ [[R]], [[COND_END]] ]
; CGSCC-NEXT:    ret ptr [[R]]
;
entry:
  %cmp = icmp ugt ptr %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  %call = call ptr @ptr_sink_r0(ptr %r)
  %call1 = call ptr @ptr_scc_r2(ptr %b, ptr %a, ptr %call)
  br label %return

if.end:                                           ; preds = %entry
  %cmp2 = icmp ult ptr %a, %b
  br i1 %cmp2, label %if.then3, label %if.end12

if.then3:                                         ; preds = %if.end
  %call4 = call ptr @ptr_sink_r0(ptr %b)
  %call5 = call ptr @ptr_scc_r1(ptr %a, ptr %b, ptr %r)
  %call6 = call ptr @ptr_scc_r2(ptr %r, ptr %r, ptr %r)
  %call7 = call ptr @ptr_scc_r1(ptr %a, ptr %call6, ptr %r)
  %call8 = call ptr @ptr_scc_r2(ptr %a, ptr %b, ptr %r)
  %call9 = call ptr @ptr_scc_r2(ptr %call5, ptr %call7, ptr %call8)
  %call10 = call ptr @ptr_scc_r1(ptr %a, ptr %b, ptr %r)
  %call11 = call ptr @ptr_scc_r1(ptr %call4, ptr %call9, ptr %call10)
  br label %return

if.end12:                                         ; preds = %if.end
  %cmp13 = icmp eq ptr %a, %b
  br i1 %cmp13, label %cond.true, label %cond.false

cond.true:                                        ; preds = %if.end12
  br label %cond.end

cond.false:                                       ; preds = %if.end12
  %call14 = call ptr @ptr_scc_r2(ptr %a, ptr %b, ptr %r)
  br label %cond.end

cond.end:                                         ; preds = %cond.false, %cond.true
  %cond = phi ptr [ %r, %cond.true ], [ %call14, %cond.false ]
  br label %return

return:                                           ; preds = %cond.end, %if.then3, %if.then
  %retval.0 = phi ptr [ %call1, %if.then ], [ %call11, %if.then3 ], [ %cond, %cond.end ]
  ret ptr %retval.0
}


; TEST a no-return singleton SCC
;
; int* rt0(int *a) {
;   return *a ? a : rt0(a);
; }
;
define ptr @rt0(ptr %a) #0 {
; TUNIT: Function Attrs: nofree noinline nosync nounwind memory(argmem: read) uwtable
; TUNIT-LABEL: define {{[^@]+}}@rt0
; TUNIT-SAME: (ptr nofree noundef nonnull readonly returned align 4 dereferenceable(4) "no-capture-maybe-returned" [[A:%.*]]) #[[ATTR3:[0-9]+]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CALL:%.*]] = call ptr @rt0(ptr nofree noundef nonnull readonly align 4 dereferenceable(4) "no-capture-maybe-returned" [[A]]) #[[ATTR9:[0-9]+]]
; TUNIT-NEXT:    ret ptr [[A]]
;
; CGSCC: Function Attrs: nofree noinline nosync nounwind memory(argmem: read) uwtable
; CGSCC-LABEL: define {{[^@]+}}@rt0
; CGSCC-SAME: (ptr nofree noundef nonnull readonly returned align 4 dereferenceable(4) "no-capture-maybe-returned" [[A:%.*]]) #[[ATTR2:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CALL:%.*]] = call ptr @rt0(ptr nofree noundef nonnull readonly align 4 dereferenceable(4) "no-capture-maybe-returned" [[A]]) #[[ATTR8:[0-9]+]]
; CGSCC-NEXT:    ret ptr [[A]]
;
entry:
  %v = load i32, ptr %a, align 4
  %tobool = icmp ne i32 %v, 0
  %call = call ptr @rt0(ptr %a)
  %sel = select i1 %tobool, ptr %a, ptr %call
  ret ptr %sel
}

; TEST a no-return singleton SCC
;
; int* rt1(int *a) {
;   return *a ? undef : rt1(a);
; }
;
define ptr @rt1(ptr %a) #0 {
; TUNIT: Function Attrs: mustprogress nofree noinline nosync nounwind willreturn memory(none) uwtable
; TUNIT-LABEL: define {{[^@]+}}@rt1
; TUNIT-SAME: (ptr nocapture nofree nonnull readnone align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR4:[0-9]+]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    ret ptr undef
;
; CGSCC: Function Attrs: mustprogress nofree noinline nosync nounwind willreturn memory(none) uwtable
; CGSCC-LABEL: define {{[^@]+}}@rt1
; CGSCC-SAME: (ptr nocapture nofree nonnull readnone align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR3:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    ret ptr undef
;
entry:
  %v = load i32, ptr %a, align 4
  %tobool = icmp ne i32 %v, 0
  %call = call ptr @rt1(ptr %a)
  %sel = select i1 %tobool, ptr undef, ptr %call
  ret ptr %sel
}

; TEST another SCC test
;
define ptr @rt2_helper(ptr %a) #0 {
; TUNIT: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; TUNIT-LABEL: define {{[^@]+}}@rt2_helper
; TUNIT-SAME: (ptr nofree readnone returned [[A:%.*]]) #[[ATTR1]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CALL:%.*]] = call ptr @rt2(ptr noalias nofree readnone [[A]], ptr noalias nofree readnone "no-capture-maybe-returned" [[A]]) #[[ATTR8]]
; TUNIT-NEXT:    ret ptr [[A]]
;
; CGSCC: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; CGSCC-LABEL: define {{[^@]+}}@rt2_helper
; CGSCC-SAME: (ptr nofree readnone returned [[A:%.*]]) #[[ATTR1]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CALL:%.*]] = call ptr @rt2(ptr noalias nofree readnone [[A]], ptr noalias nofree readnone "no-capture-maybe-returned" [[A]]) #[[ATTR7]]
; CGSCC-NEXT:    ret ptr [[A]]
;
entry:
  %call = call ptr @rt2(ptr %a, ptr %a)
  ret ptr %call
}

define ptr @rt2(ptr %a, ptr %b) #0 {
; TUNIT: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; TUNIT-LABEL: define {{[^@]+}}@rt2
; TUNIT-SAME: (ptr nofree readnone [[A:%.*]], ptr nofree readnone "no-capture-maybe-returned" [[B:%.*]]) #[[ATTR1]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CMP:%.*]] = icmp eq ptr [[A]], null
; TUNIT-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; TUNIT:       if.then:
; TUNIT-NEXT:    [[CALL:%.*]] = call ptr @rt2_helper(ptr noalias nofree readnone [[A]]) #[[ATTR8]]
; TUNIT-NEXT:    br label [[IF_END]]
; TUNIT:       if.end:
; TUNIT-NEXT:    [[SEL:%.*]] = phi ptr [ [[B]], [[ENTRY:%.*]] ], [ [[A]], [[IF_THEN]] ]
; TUNIT-NEXT:    ret ptr [[SEL]]
;
; CGSCC: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; CGSCC-LABEL: define {{[^@]+}}@rt2
; CGSCC-SAME: (ptr nofree readnone [[A:%.*]], ptr nofree readnone "no-capture-maybe-returned" [[B:%.*]]) #[[ATTR1]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CMP:%.*]] = icmp eq ptr [[A]], null
; CGSCC-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CGSCC:       if.then:
; CGSCC-NEXT:    [[CALL:%.*]] = call ptr @rt2_helper(ptr noalias nofree readnone [[A]]) #[[ATTR7]]
; CGSCC-NEXT:    br label [[IF_END]]
; CGSCC:       if.end:
; CGSCC-NEXT:    [[SEL:%.*]] = phi ptr [ [[B]], [[ENTRY:%.*]] ], [ [[A]], [[IF_THEN]] ]
; CGSCC-NEXT:    ret ptr [[SEL]]
;
entry:
  %cmp = icmp eq ptr %a, null
  br i1 %cmp, label %if.then, label %if.end

if.then:
  %call = call ptr @rt2_helper(ptr %a)
  br label %if.end

if.end:
  %sel = phi ptr [ %b, %entry], [%call, %if.then]
  ret ptr %sel
}

; TEST another SCC test
;
define ptr @rt3_helper(ptr %a, ptr %b) #0 {
; TUNIT: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; TUNIT-LABEL: define {{[^@]+}}@rt3_helper
; TUNIT-SAME: (ptr nocapture nofree readnone [[A:%.*]], ptr nofree readnone returned "no-capture-maybe-returned" [[B:%.*]]) #[[ATTR1]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CALL:%.*]] = call ptr @rt3(ptr noalias nocapture nofree readnone [[A]], ptr noalias nofree readnone "no-capture-maybe-returned" [[B]]) #[[ATTR8]]
; TUNIT-NEXT:    ret ptr [[B]]
;
; CGSCC: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; CGSCC-LABEL: define {{[^@]+}}@rt3_helper
; CGSCC-SAME: (ptr nocapture nofree readnone [[A:%.*]], ptr nofree readnone returned "no-capture-maybe-returned" [[B:%.*]]) #[[ATTR1]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CALL:%.*]] = call ptr @rt3(ptr noalias nocapture nofree readnone [[A]], ptr noalias nofree readnone "no-capture-maybe-returned" [[B]]) #[[ATTR7]]
; CGSCC-NEXT:    ret ptr [[B]]
;
entry:
  %call = call ptr @rt3(ptr %a, ptr %b)
  ret ptr %call
}

define ptr @rt3(ptr %a, ptr %b) #0 {
; TUNIT: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; TUNIT-LABEL: define {{[^@]+}}@rt3
; TUNIT-SAME: (ptr nocapture nofree readnone [[A:%.*]], ptr nofree readnone returned "no-capture-maybe-returned" [[B:%.*]]) #[[ATTR1]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CMP:%.*]] = icmp eq ptr [[A]], null
; TUNIT-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; TUNIT:       if.then:
; TUNIT-NEXT:    [[CALL:%.*]] = call ptr @rt3_helper(ptr noalias nocapture nofree readnone [[A]], ptr noalias nofree readnone "no-capture-maybe-returned" [[B]]) #[[ATTR8]]
; TUNIT-NEXT:    br label [[IF_END]]
; TUNIT:       if.end:
; TUNIT-NEXT:    [[SEL:%.*]] = phi ptr [ [[B]], [[ENTRY:%.*]] ], [ [[B]], [[IF_THEN]] ]
; TUNIT-NEXT:    ret ptr [[B]]
;
; CGSCC: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; CGSCC-LABEL: define {{[^@]+}}@rt3
; CGSCC-SAME: (ptr nocapture nofree readnone [[A:%.*]], ptr nofree readnone returned "no-capture-maybe-returned" [[B:%.*]]) #[[ATTR1]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CMP:%.*]] = icmp eq ptr [[A]], null
; CGSCC-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CGSCC:       if.then:
; CGSCC-NEXT:    [[CALL:%.*]] = call ptr @rt3_helper(ptr noalias nocapture nofree readnone [[A]], ptr noalias nofree readnone "no-capture-maybe-returned" [[B]]) #[[ATTR7]]
; CGSCC-NEXT:    br label [[IF_END]]
; CGSCC:       if.end:
; CGSCC-NEXT:    [[SEL:%.*]] = phi ptr [ [[B]], [[ENTRY:%.*]] ], [ [[B]], [[IF_THEN]] ]
; CGSCC-NEXT:    ret ptr [[B]]
;
entry:
  %cmp = icmp eq ptr %a, null
  br i1 %cmp, label %if.then, label %if.end

if.then:
  %call = call ptr @rt3_helper(ptr %a, ptr %b)
  br label %if.end

if.end:
  %sel = phi ptr [ %b, %entry], [%call, %if.then]
  ret ptr %sel
}

; TEST address taken function with call to an external functions
;
;  void unknown_fn(void *);
;
;  int* calls_unknown_fn(int *r) {
;    unknown_fn(&calls_unknown_fn);
;    return r;
;  }
;
declare void @unknown_fn(ptr) #0

define ptr @calls_unknown_fn(ptr %r) #0 {
; TUNIT: Function Attrs: noinline nounwind uwtable
; TUNIT-LABEL: define {{[^@]+}}@calls_unknown_fn
; TUNIT-SAME: (ptr nofree readnone returned "no-capture-maybe-returned" [[R:%.*]]) #[[ATTR5:[0-9]+]] {
; TUNIT-NEXT:    tail call void @unknown_fn(ptr noundef nonnull @calls_unknown_fn) #[[ATTR10:[0-9]+]]
; TUNIT-NEXT:    ret ptr [[R]]
;
; CGSCC: Function Attrs: noinline nounwind uwtable
; CGSCC-LABEL: define {{[^@]+}}@calls_unknown_fn
; CGSCC-SAME: (ptr nofree readnone returned "no-capture-maybe-returned" [[R:%.*]]) #[[ATTR4:[0-9]+]] {
; CGSCC-NEXT:    tail call void @unknown_fn(ptr noundef nonnull @calls_unknown_fn) #[[ATTR9:[0-9]+]]
; CGSCC-NEXT:    ret ptr [[R]]
;
  tail call void @unknown_fn(ptr nonnull @calls_unknown_fn)
  ret ptr %r
}


; TEST call to a function that might be redifined at link time
;
;  int *maybe_redefined_fn(int *r) {
;    return r;
;  }
;
;  int *calls_maybe_redefined_fn(int *r) {
;    maybe_redefined_fn(r);
;    return r;
;  }
;
; Verify the maybe-redefined function is not annotated:
;
define linkonce_odr ptr @maybe_redefined_fn(ptr %r) #0 {
; TUNIT: Function Attrs: noinline nounwind uwtable
; TUNIT-LABEL: define {{[^@]+}}@maybe_redefined_fn
; TUNIT-SAME: (ptr [[R:%.*]]) #[[ATTR5]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    ret ptr [[R]]
;
; CGSCC: Function Attrs: noinline nounwind uwtable
; CGSCC-LABEL: define {{[^@]+}}@maybe_redefined_fn
; CGSCC-SAME: (ptr [[R:%.*]]) #[[ATTR4]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    ret ptr [[R]]
;
entry:
  ret ptr %r
}

define ptr @calls_maybe_redefined_fn(ptr %r) #0 {
; TUNIT: Function Attrs: noinline nounwind uwtable
; TUNIT-LABEL: define {{[^@]+}}@calls_maybe_redefined_fn
; TUNIT-SAME: (ptr returned [[R:%.*]]) #[[ATTR5]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CALL:%.*]] = call ptr @maybe_redefined_fn(ptr [[R]]) #[[ATTR10]]
; TUNIT-NEXT:    ret ptr [[R]]
;
; CGSCC: Function Attrs: noinline nounwind uwtable
; CGSCC-LABEL: define {{[^@]+}}@calls_maybe_redefined_fn
; CGSCC-SAME: (ptr returned [[R:%.*]]) #[[ATTR4]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CALL:%.*]] = call ptr @maybe_redefined_fn(ptr [[R]]) #[[ATTR9]]
; CGSCC-NEXT:    ret ptr [[R]]
;
entry:
  %call = call ptr @maybe_redefined_fn(ptr %r)
  ret ptr %r
}

; TEST return call to a function that might be redifined at link time
;
;  int *maybe_redefined_fn2(int *r) {
;    return r;
;  }
;
;  int *calls_maybe_redefined_fn2(int *r) {
;    return maybe_redefined_fn2(r);
;  }
;
; Verify the maybe-redefined function is not annotated:
;
define linkonce_odr ptr @maybe_redefined_fn2(ptr %r) #0 {
; TUNIT: Function Attrs: noinline nounwind uwtable
; TUNIT-LABEL: define {{[^@]+}}@maybe_redefined_fn2
; TUNIT-SAME: (ptr [[R:%.*]]) #[[ATTR5]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    ret ptr [[R]]
;
; CGSCC: Function Attrs: noinline nounwind uwtable
; CGSCC-LABEL: define {{[^@]+}}@maybe_redefined_fn2
; CGSCC-SAME: (ptr [[R:%.*]]) #[[ATTR4]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    ret ptr [[R]]
;
entry:
  ret ptr %r
}

define ptr @calls_maybe_redefined_fn2(ptr %r) #0 {
; TUNIT: Function Attrs: noinline nounwind uwtable
; TUNIT-LABEL: define {{[^@]+}}@calls_maybe_redefined_fn2
; TUNIT-SAME: (ptr [[R:%.*]]) #[[ATTR5]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CALL:%.*]] = call ptr @maybe_redefined_fn2(ptr [[R]]) #[[ATTR10]]
; TUNIT-NEXT:    ret ptr [[CALL]]
;
; CGSCC: Function Attrs: noinline nounwind uwtable
; CGSCC-LABEL: define {{[^@]+}}@calls_maybe_redefined_fn2
; CGSCC-SAME: (ptr [[R:%.*]]) #[[ATTR4]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CALL:%.*]] = call ptr @maybe_redefined_fn2(ptr [[R]]) #[[ATTR9]]
; CGSCC-NEXT:    ret ptr [[CALL]]
;
entry:
  %call = call ptr @maybe_redefined_fn2(ptr %r)
  ret ptr %call
}


; TEST returned argument goes through select and phi
;
; double select_and_phi(double b) {
;   double x = b;
;   if (b > 0)
;     x = b;
;   return b == 0? b : x;
; }
;
define double @select_and_phi(double %b) #0 {
; CHECK: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; CHECK-LABEL: define {{[^@]+}}@select_and_phi
; CHECK-SAME: (double returned [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt double [[B]], 0.000000e+00
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[PHI:%.*]] = phi double [ [[B]], [[IF_THEN]] ], [ [[B]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret double [[B]]
;
entry:
  %cmp = fcmp ogt double %b, 0.000000e+00
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  %phi = phi double [ %b, %if.then ], [ %b, %entry ]
  %cmp1 = fcmp oeq double %b, 0.000000e+00
  %sel = select i1 %cmp1, double %b, double %phi
  ret double %sel
}


; TEST returned argument goes through recursion, select, and phi
;
; double recursion_select_and_phi(int a, double b) {
;   double x = b;
;   if (a-- > 0)
;     x = recursion_select_and_phi(a, b);
;   return b == 0? b : x;
; }
;
define double @recursion_select_and_phi(i32 %a, double %b) #0 {
; TUNIT: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; TUNIT-LABEL: define {{[^@]+}}@recursion_select_and_phi
; TUNIT-SAME: (i32 [[A:%.*]], double returned [[B:%.*]]) #[[ATTR1]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[DEC:%.*]] = add nsw i32 [[A]], -1
; TUNIT-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], 0
; TUNIT-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; TUNIT:       if.then:
; TUNIT-NEXT:    [[CALL:%.*]] = call double @recursion_select_and_phi(i32 [[DEC]], double [[B]]) #[[ATTR8]]
; TUNIT-NEXT:    br label [[IF_END]]
; TUNIT:       if.end:
; TUNIT-NEXT:    [[PHI:%.*]] = phi double [ [[B]], [[IF_THEN]] ], [ [[B]], [[ENTRY:%.*]] ]
; TUNIT-NEXT:    ret double [[B]]
;
; CGSCC: Function Attrs: nofree noinline nosync nounwind memory(none) uwtable
; CGSCC-LABEL: define {{[^@]+}}@recursion_select_and_phi
; CGSCC-SAME: (i32 [[A:%.*]], double returned [[B:%.*]]) #[[ATTR1]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[DEC:%.*]] = add nsw i32 [[A]], -1
; CGSCC-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], 0
; CGSCC-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CGSCC:       if.then:
; CGSCC-NEXT:    [[CALL:%.*]] = call double @recursion_select_and_phi(i32 [[DEC]], double [[B]]) #[[ATTR7]]
; CGSCC-NEXT:    br label [[IF_END]]
; CGSCC:       if.end:
; CGSCC-NEXT:    [[PHI:%.*]] = phi double [ [[B]], [[IF_THEN]] ], [ [[B]], [[ENTRY:%.*]] ]
; CGSCC-NEXT:    ret double [[B]]
;
entry:
  %dec = add nsw i32 %a, -1
  %cmp = icmp sgt i32 %a, 0
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  %call = call double @recursion_select_and_phi(i32 %dec, double %b)
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  %phi = phi double [ %call, %if.then ], [ %b, %entry ]
  %cmp1 = fcmp oeq double %b, 0.000000e+00
  %sel = select i1 %cmp1, double %b, double %phi
  ret double %sel
}


; TEST returned argument goes through bitcasts
;
; double* bitcast(int* b) {
;   return (double*)b;
; }
;
define ptr @bitcast(ptr %b) #0 {
; CHECK: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; CHECK-LABEL: define {{[^@]+}}@bitcast
; CHECK-SAME: (ptr nofree readnone returned "no-capture-maybe-returned" [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret ptr [[B]]
;
entry:
  ret ptr %b
}


; TEST returned argument goes through select and phi interleaved with bitcasts
;
; double* bitcasts_select_and_phi(int* b) {
;   double* x = b;
;   if (b == 0)
;     x = b;
;   return b != 0 ? b : x;
; }
;
define ptr @bitcasts_select_and_phi(ptr %b) #0 {
; CHECK: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; CHECK-LABEL: define {{[^@]+}}@bitcasts_select_and_phi
; CHECK-SAME: (ptr nofree readnone returned [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr [[B]], null
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[PHI:%.*]] = phi ptr [ [[B]], [[IF_THEN]] ], [ [[B]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret ptr [[B]]
;
entry:
  %cmp = icmp eq ptr %b, null
  br i1 %cmp, label %if.then, label %if.end

if.then:                                          ; preds = %entry
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  %phi = phi ptr [ %b, %if.then ], [ %b, %entry ]
  %cmp2 = icmp ne ptr %b, null
  %sel = select i1 %cmp2, ptr %phi, ptr %b
  ret ptr %sel
}


; TEST return argument or argument or undef
;
; double* ret_arg_arg_undef(int* b) {
;   if (b == 0)
;     return (double*)b;
;   if (b == 0)
;     return (double*)b;
;   /* return undef */
; }
;
define ptr @ret_arg_arg_undef(ptr %b) #0 {
; CHECK: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; CHECK-LABEL: define {{[^@]+}}@ret_arg_arg_undef
; CHECK-SAME: (ptr nofree readnone returned [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr [[B]], null
; CHECK-NEXT:    br i1 [[CMP]], label [[RET_ARG0:%.*]], label [[IF_END:%.*]]
; CHECK:       ret_arg0:
; CHECK-NEXT:    ret ptr [[B]]
; CHECK:       if.end:
; CHECK-NEXT:    br i1 [[CMP]], label [[RET_ARG1:%.*]], label [[RET_UNDEF:%.*]]
; CHECK:       ret_arg1:
; CHECK-NEXT:    ret ptr [[B]]
; CHECK:       ret_undef:
; CHECK-NEXT:    ret ptr undef
;
entry:
  %cmp = icmp eq ptr %b, null
  br i1 %cmp, label %ret_arg0, label %if.end

ret_arg0:
  ret ptr %b

if.end:
  br i1 %cmp, label %ret_arg1, label %ret_undef

ret_arg1:
  ret ptr %b

ret_undef:
  ret ptr undef
}


; TEST return undef or argument or argument
;
; double* ret_undef_arg_arg(int* b) {
;   if (b == 0)
;     return (double*)b;
;   if (b == 0)
;     return (double*)b;
;   /* return undef */
; }
;
define ptr @ret_undef_arg_arg(ptr %b) #0 {
; CHECK: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; CHECK-LABEL: define {{[^@]+}}@ret_undef_arg_arg
; CHECK-SAME: (ptr nofree readnone returned [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr [[B]], null
; CHECK-NEXT:    br i1 [[CMP]], label [[RET_UNDEF:%.*]], label [[IF_END:%.*]]
; CHECK:       ret_undef:
; CHECK-NEXT:    ret ptr undef
; CHECK:       if.end:
; CHECK-NEXT:    br i1 [[CMP]], label [[RET_ARG0:%.*]], label [[RET_ARG1:%.*]]
; CHECK:       ret_arg0:
; CHECK-NEXT:    ret ptr [[B]]
; CHECK:       ret_arg1:
; CHECK-NEXT:    ret ptr [[B]]
;
entry:
  %cmp = icmp eq ptr %b, null
  br i1 %cmp, label %ret_undef, label %if.end

ret_undef:
  ret ptr undef

if.end:
  br i1 %cmp, label %ret_arg0, label %ret_arg1

ret_arg0:
  ret ptr %b

ret_arg1:
  ret ptr %b
}


; TEST return undef or argument or undef
;
; double* ret_undef_arg_undef(int* b) {
;   if (b == 0)
;     /* return undef */
;   if (b == 0)
;     return (double*)b;
;   /* return undef */
; }
;
define ptr @ret_undef_arg_undef(ptr %b) #0 {
; CHECK: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; CHECK-LABEL: define {{[^@]+}}@ret_undef_arg_undef
; CHECK-SAME: (ptr nofree readnone returned [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq ptr [[B]], null
; CHECK-NEXT:    br i1 [[CMP]], label [[RET_UNDEF0:%.*]], label [[IF_END:%.*]]
; CHECK:       ret_undef0:
; CHECK-NEXT:    ret ptr undef
; CHECK:       if.end:
; CHECK-NEXT:    br i1 [[CMP]], label [[RET_ARG:%.*]], label [[RET_UNDEF1:%.*]]
; CHECK:       ret_arg:
; CHECK-NEXT:    ret ptr [[B]]
; CHECK:       ret_undef1:
; CHECK-NEXT:    ret ptr undef
;
entry:
  %cmp = icmp eq ptr %b, null
  br i1 %cmp, label %ret_undef0, label %if.end

ret_undef0:
  ret ptr undef

if.end:
  br i1 %cmp, label %ret_arg, label %ret_undef1

ret_arg:
  ret ptr %b

ret_undef1:
  ret ptr undef
}

; TEST return argument or unknown call result
;
; int* ret_arg_or_unknown(int* b) {
;   if (b == 0)
;     return b;
;   return unknown();
; }
;
; Verify we do not assume b is returned
;
declare ptr @unknown(ptr)

define ptr @ret_arg_or_unknown(ptr %b) #0 {
; TUNIT: Function Attrs: noinline nounwind uwtable
; TUNIT-LABEL: define {{[^@]+}}@ret_arg_or_unknown
; TUNIT-SAME: (ptr [[B:%.*]]) #[[ATTR5]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CMP:%.*]] = icmp eq ptr [[B]], null
; TUNIT-NEXT:    br i1 [[CMP]], label [[RET_ARG:%.*]], label [[RET_UNKNOWN:%.*]]
; TUNIT:       ret_arg:
; TUNIT-NEXT:    ret ptr [[B]]
; TUNIT:       ret_unknown:
; TUNIT-NEXT:    [[CALL:%.*]] = call ptr @unknown(ptr nonnull [[B]])
; TUNIT-NEXT:    ret ptr [[CALL]]
;
; CGSCC: Function Attrs: noinline nounwind uwtable
; CGSCC-LABEL: define {{[^@]+}}@ret_arg_or_unknown
; CGSCC-SAME: (ptr [[B:%.*]]) #[[ATTR4]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CMP:%.*]] = icmp eq ptr [[B]], null
; CGSCC-NEXT:    br i1 [[CMP]], label [[RET_ARG:%.*]], label [[RET_UNKNOWN:%.*]]
; CGSCC:       ret_arg:
; CGSCC-NEXT:    ret ptr [[B]]
; CGSCC:       ret_unknown:
; CGSCC-NEXT:    [[CALL:%.*]] = call ptr @unknown(ptr nonnull [[B]])
; CGSCC-NEXT:    ret ptr [[CALL]]
;
entry:
  %cmp = icmp eq ptr %b, null
  br i1 %cmp, label %ret_arg, label %ret_unknown

ret_arg:
  ret ptr %b

ret_unknown:
  %call = call ptr @unknown(ptr %b)
  ret ptr %call
}

define ptr @ret_arg_or_unknown_through_phi(ptr %b) #0 {
; TUNIT: Function Attrs: noinline nounwind uwtable
; TUNIT-LABEL: define {{[^@]+}}@ret_arg_or_unknown_through_phi
; TUNIT-SAME: (ptr [[B:%.*]]) #[[ATTR5]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CMP:%.*]] = icmp eq ptr [[B]], null
; TUNIT-NEXT:    br i1 [[CMP]], label [[RET_ARG:%.*]], label [[RET_UNKNOWN:%.*]]
; TUNIT:       ret_arg:
; TUNIT-NEXT:    br label [[R:%.*]]
; TUNIT:       ret_unknown:
; TUNIT-NEXT:    [[CALL:%.*]] = call ptr @unknown(ptr nonnull [[B]])
; TUNIT-NEXT:    br label [[R]]
; TUNIT:       r:
; TUNIT-NEXT:    [[PHI:%.*]] = phi ptr [ [[B]], [[RET_ARG]] ], [ [[CALL]], [[RET_UNKNOWN]] ]
; TUNIT-NEXT:    ret ptr [[PHI]]
;
; CGSCC: Function Attrs: noinline nounwind uwtable
; CGSCC-LABEL: define {{[^@]+}}@ret_arg_or_unknown_through_phi
; CGSCC-SAME: (ptr [[B:%.*]]) #[[ATTR4]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CMP:%.*]] = icmp eq ptr [[B]], null
; CGSCC-NEXT:    br i1 [[CMP]], label [[RET_ARG:%.*]], label [[RET_UNKNOWN:%.*]]
; CGSCC:       ret_arg:
; CGSCC-NEXT:    br label [[R:%.*]]
; CGSCC:       ret_unknown:
; CGSCC-NEXT:    [[CALL:%.*]] = call ptr @unknown(ptr nonnull [[B]])
; CGSCC-NEXT:    br label [[R]]
; CGSCC:       r:
; CGSCC-NEXT:    [[PHI:%.*]] = phi ptr [ [[B]], [[RET_ARG]] ], [ [[CALL]], [[RET_UNKNOWN]] ]
; CGSCC-NEXT:    ret ptr [[PHI]]
;
entry:
  %cmp = icmp eq ptr %b, null
  br i1 %cmp, label %ret_arg, label %ret_unknown

ret_arg:
  br label %r

ret_unknown:
  %call = call ptr @unknown(ptr %b)
  br label %r

r:
  %phi = phi ptr [ %b, %ret_arg ], [ %call, %ret_unknown ]
  ret ptr %phi
}

; TEST inconsistent IR in dead code.
;
define i32 @deadblockcall1(i32 %A) #0 {
; CHECK: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; CHECK-LABEL: define {{[^@]+}}@deadblockcall1
; CHECK-SAME: (i32 returned [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 [[A]]
; CHECK:       unreachableblock:
; CHECK-NEXT:    unreachable
;
entry:
  ret i32 %A
unreachableblock:
  %B = call i32 @deadblockcall1(i32 %B)
  ret i32 %B
}

declare i32 @deadblockcall_helper(i32 returned %A);

define i32 @deadblockcall2(i32 %A) #0 {
; CHECK: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; CHECK-LABEL: define {{[^@]+}}@deadblockcall2
; CHECK-SAME: (i32 returned [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 [[A]]
; CHECK:       unreachableblock1:
; CHECK-NEXT:    unreachable
; CHECK:       unreachableblock2:
; CHECK-NEXT:    unreachable
;
entry:
  ret i32 %A
unreachableblock1:
  %B = call i32 @deadblockcall_helper(i32 %B)
  ret i32 %B
unreachableblock2:
  %C = call i32 @deadblockcall1(i32 %C)
  ret i32 %C
}

define i32 @deadblockphi1(i32 %A) #0 {
; CHECK: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; CHECK-LABEL: define {{[^@]+}}@deadblockphi1
; CHECK-SAME: (i32 returned [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[R:%.*]]
; CHECK:       unreachableblock1:
; CHECK-NEXT:    unreachable
; CHECK:       unreachableblock2:
; CHECK-NEXT:    unreachable
; CHECK:       r:
; CHECK-NEXT:    ret i32 [[A]]
;
entry:
  br label %r
unreachableblock1:
  %B = call i32 @deadblockcall_helper(i32 %B)
  ret i32 %B
unreachableblock2:
  %C = call i32 @deadblockcall1(i32 %C)
  br label %r
r:
  %PHI = phi i32 [%A, %entry], [%C, %unreachableblock2]
  ret i32 %PHI
}

define i32 @deadblockphi2(i32 %A) #0 {
; CHECK: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; CHECK-LABEL: define {{[^@]+}}@deadblockphi2
; CHECK-SAME: (i32 returned [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[R:%.*]]
; CHECK:       unreachableblock1:
; CHECK-NEXT:    unreachable
; CHECK:       unreachableblock2:
; CHECK-NEXT:    unreachable
; CHECK:       unreachableblock3:
; CHECK-NEXT:    unreachable
; CHECK:       r:
; CHECK-NEXT:    ret i32 [[A]]
;
entry:
  br label %r
unreachableblock1:
  %B = call i32 @deadblockcall_helper(i32 %B)
  br label %unreachableblock3
unreachableblock2:
  %C = call i32 @deadblockcall1(i32 %C)
  br label %unreachableblock3
unreachableblock3:
  %PHI1 = phi i32 [%B, %unreachableblock1], [%C, %unreachableblock2]
  br label %r
r:
  %PHI2 = phi i32 [%A, %entry], [%PHI1, %unreachableblock3]
  ret i32 %PHI2
}

declare void @noreturn() noreturn;

define i32 @deadblockphi3(i32 %A, i1 %c) #0 {
; TUNIT: Function Attrs: noinline nounwind uwtable
; TUNIT-LABEL: define {{[^@]+}}@deadblockphi3
; TUNIT-SAME: (i32 returned [[A:%.*]], i1 noundef [[C:%.*]]) #[[ATTR5]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    br i1 [[C]], label [[R:%.*]], label [[UNREACHABLECALL:%.*]]
; TUNIT:       unreachablecall:
; TUNIT-NEXT:    call void @noreturn() #[[ATTR6:[0-9]+]]
; TUNIT-NEXT:    unreachable
; TUNIT:       unreachableblock2:
; TUNIT-NEXT:    unreachable
; TUNIT:       unreachableblock3:
; TUNIT-NEXT:    unreachable
; TUNIT:       r:
; TUNIT-NEXT:    ret i32 [[A]]
;
; CGSCC: Function Attrs: noinline nounwind uwtable
; CGSCC-LABEL: define {{[^@]+}}@deadblockphi3
; CGSCC-SAME: (i32 returned [[A:%.*]], i1 noundef [[C:%.*]]) #[[ATTR4]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    br i1 [[C]], label [[R:%.*]], label [[UNREACHABLECALL:%.*]]
; CGSCC:       unreachablecall:
; CGSCC-NEXT:    call void @noreturn() #[[ATTR5:[0-9]+]]
; CGSCC-NEXT:    unreachable
; CGSCC:       unreachableblock2:
; CGSCC-NEXT:    unreachable
; CGSCC:       unreachableblock3:
; CGSCC-NEXT:    unreachable
; CGSCC:       r:
; CGSCC-NEXT:    ret i32 [[A]]
;
entry:
  br i1 %c, label %r, label %unreachablecall
unreachablecall:
  call void @noreturn();
  %B = call i32 @deadblockcall_helper(i32 0)
  br label %unreachableblock3
unreachableblock2:
  %C = call i32 @deadblockcall1(i32 %C)
  br label %unreachableblock3
unreachableblock3:
  %PHI1 = phi i32 [%B, %unreachablecall], [%C, %unreachableblock2]
  br label %r
r:
  %PHI2 = phi i32 [%A, %entry], [%PHI1, %unreachableblock3]
  ret i32 %PHI2
}

define weak_odr i32 @non_exact_0() {
; CHECK-LABEL: define {{[^@]+}}@non_exact_0() {
; CHECK-NEXT:    ret i32 0
;
  ret i32 0
}
define weak_odr i32 @non_exact_1(i32 %a) {
; CHECK-LABEL: define {{[^@]+}}@non_exact_1
; CHECK-SAME: (i32 [[A:%.*]]) {
; CHECK-NEXT:    ret i32 [[A]]
;
  ret i32 %a
}
define weak_odr i32 @non_exact_2(i32 returned %a) {
; CHECK-LABEL: define {{[^@]+}}@non_exact_2
; CHECK-SAME: (i32 returned [[A:%.*]]) {
; CHECK-NEXT:    ret i32 [[A]]
;
  ret i32 %a
}
define weak_odr align 16 ptr @non_exact_3(ptr align 32 returned %a) {
; CHECK-LABEL: define {{[^@]+}}@non_exact_3
; CHECK-SAME: (ptr returned align 32 [[A:%.*]]) {
; CHECK-NEXT:    ret ptr [[A]]
;
  ret ptr %a
}
define weak_odr align 16 ptr @non_exact_4(ptr align 32 %a) {
; CHECK-LABEL: define {{[^@]+}}@non_exact_4
; CHECK-SAME: (ptr align 32 [[A:%.*]]) {
; CHECK-NEXT:    ret ptr [[A]]
;
  ret ptr %a
}
; We can use the alignment information of the weak function non_exact_3 argument
; because it was given to us and not derived.
; We can use the return information of the weak function non_exact_4.
; %c2 and %c3 should be replaced but not %c0 or %c1!
define i32 @exact(ptr align 8 %a, ptr align 8 %b) {
; CHECK-LABEL: define {{[^@]+}}@exact
; CHECK-SAME: (ptr align 8 [[A:%.*]], ptr align 8 [[B:%.*]]) {
; CHECK-NEXT:    [[C0:%.*]] = call i32 @non_exact_0()
; CHECK-NEXT:    [[C1:%.*]] = call i32 @non_exact_1(i32 noundef 1)
; CHECK-NEXT:    [[C2:%.*]] = call i32 @non_exact_2(i32 noundef 2)
; CHECK-NEXT:    [[C3:%.*]] = call align 32 ptr @non_exact_3(ptr align 32 [[A]])
; CHECK-NEXT:    [[C4:%.*]] = call align 16 ptr @non_exact_4(ptr align 32 [[B]])
; CHECK-NEXT:    [[C3L:%.*]] = load i32, ptr [[A]], align 32
; CHECK-NEXT:    [[C4L:%.*]] = load i32, ptr [[C4]], align 16
; CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[C0]], [[C1]]
; CHECK-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], 2
; CHECK-NEXT:    [[ADD3:%.*]] = add i32 [[ADD2]], [[C3L]]
; CHECK-NEXT:    [[ADD4:%.*]] = add i32 [[ADD3]], [[C4L]]
; CHECK-NEXT:    ret i32 [[ADD4]]
;
  %c0 = call i32 @non_exact_0()
  %c1 = call i32 @non_exact_1(i32 1)
  %c2 = call i32 @non_exact_2(i32 2)
  %c3 = call ptr @non_exact_3(ptr %a)
  %c4 = call ptr @non_exact_4(ptr %b)
  %c3l = load i32, ptr %c3
  %c4l = load i32, ptr %c4
  %add1 = add i32 %c0, %c1
  %add2 = add i32 %add1, %c2
  %add3 = add i32 %add2, %c3l
  %add4 = add i32 %add3, %c4l
  ret i32 %add4
}

@G = external global i8
define ptr @ret_const() #0 {
; CHECK: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; CHECK-LABEL: define {{[^@]+}}@ret_const
; CHECK-SAME: () #[[ATTR0]] {
; CHECK-NEXT:    ret ptr @G
;
  ret ptr @G
}
define ptr @use_const() #0 {
; TUNIT: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; TUNIT-LABEL: define {{[^@]+}}@use_const
; TUNIT-SAME: () #[[ATTR0]] {
; TUNIT-NEXT:    ret ptr @G
;
; CGSCC: Function Attrs: mustprogress nofree noinline nosync nounwind willreturn memory(none) uwtable
; CGSCC-LABEL: define {{[^@]+}}@use_const
; CGSCC-SAME: () #[[ATTR3]] {
; CGSCC-NEXT:    [[C:%.*]] = call noundef nonnull dereferenceable(1) ptr @ret_const() #[[ATTR10:[0-9]+]]
; CGSCC-NEXT:    ret ptr [[C]]
;
  %c = call ptr @ret_const()
  ret ptr %c
}
define ptr @dont_use_const() #0 {
; TUNIT: Function Attrs: mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable
; TUNIT-LABEL: define {{[^@]+}}@dont_use_const
; TUNIT-SAME: () #[[ATTR0]] {
; TUNIT-NEXT:    ret ptr @G
;
; CGSCC: Function Attrs: mustprogress nofree noinline nosync nounwind willreturn memory(none) uwtable
; CGSCC-LABEL: define {{[^@]+}}@dont_use_const
; CGSCC-SAME: () #[[ATTR3]] {
; CGSCC-NEXT:    [[C:%.*]] = musttail call noundef nonnull dereferenceable(1) ptr @ret_const() #[[ATTR10]]
; CGSCC-NEXT:    ret ptr [[C]]
;
  %c = musttail call ptr @ret_const()
  ret ptr %c
}

; UTC_ARGS: --disable
;
; Verify we do not derive constraints for @_Z3fooP1X as if it was returning `null`.
;
; CHEKC-NOT: noalias
; CHECK-NOT: align 536870912

%struct.Y = type { %struct.X }
%struct.X = type { ptr }

@_ZTI1X = external dso_local constant { ptr, ptr }, align 8
@_ZTI1Y = external dso_local constant { ptr, ptr, ptr }, align 8

define internal ptr @_ZN1Y3barEv(ptr %this) align 2 {
entry:
  ret ptr %this
}

define dso_local ptr @_Z3fooP1X(ptr %x) {
entry:
  %0 = icmp eq ptr %x, null
  br i1 %0, label %dynamic_cast.null, label %dynamic_cast.notnull

dynamic_cast.notnull:                             ; preds = %entry
  %1 = call ptr @__dynamic_cast(ptr %x, ptr @_ZTI1X, ptr @_ZTI1Y, i64 0) #2
  br label %dynamic_cast.end

dynamic_cast.null:                                ; preds = %entry
  br label %dynamic_cast.end

dynamic_cast.end:                                 ; preds = %dynamic_cast.null, %dynamic_cast.notnull
  %QQ5 = phi ptr [ %1, %dynamic_cast.notnull ], [ null, %dynamic_cast.null ]
  %call = call ptr @_ZN1Y3barEv(ptr %QQ5)
  ret ptr %call
}

declare dso_local ptr @__dynamic_cast(ptr, ptr, ptr, i64)

; UTC_ARGS: --enable

attributes #0 = { noinline nounwind uwtable }
;.
; TUNIT: attributes #[[ATTR0]] = { mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable }
; TUNIT: attributes #[[ATTR1]] = { nofree noinline nosync nounwind memory(none) uwtable }
; TUNIT: attributes #[[ATTR2]] = { nofree noinline norecurse nosync nounwind memory(none) uwtable }
; TUNIT: attributes #[[ATTR3]] = { nofree noinline nosync nounwind memory(argmem: read) uwtable }
; TUNIT: attributes #[[ATTR4]] = { mustprogress nofree noinline nosync nounwind willreturn memory(none) uwtable }
; TUNIT: attributes #[[ATTR5]] = { noinline nounwind uwtable }
; TUNIT: attributes #[[ATTR6]] = { noreturn }
; TUNIT: attributes #[[ATTR7:[0-9]+]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR8]] = { nofree nosync nounwind memory(none) }
; TUNIT: attributes #[[ATTR9]] = { nofree nosync nounwind memory(read) }
; TUNIT: attributes #[[ATTR10]] = { nounwind }
; TUNIT: attributes #[[ATTR11:[0-9]+]] = { nounwind memory(none) }
;.
; CGSCC: attributes #[[ATTR0]] = { mustprogress nofree noinline norecurse nosync nounwind willreturn memory(none) uwtable }
; CGSCC: attributes #[[ATTR1]] = { nofree noinline nosync nounwind memory(none) uwtable }
; CGSCC: attributes #[[ATTR2]] = { nofree noinline nosync nounwind memory(argmem: read) uwtable }
; CGSCC: attributes #[[ATTR3]] = { mustprogress nofree noinline nosync nounwind willreturn memory(none) uwtable }
; CGSCC: attributes #[[ATTR4]] = { noinline nounwind uwtable }
; CGSCC: attributes #[[ATTR5]] = { noreturn }
; CGSCC: attributes #[[ATTR6:[0-9]+]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR7]] = { nofree nosync nounwind memory(none) }
; CGSCC: attributes #[[ATTR8]] = { nofree nosync nounwind memory(read) }
; CGSCC: attributes #[[ATTR9]] = { nounwind }
; CGSCC: attributes #[[ATTR10]] = { nofree nosync willreturn }
;.
