; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=simplifycfg -simplifycfg-require-and-preserve-domtree=1 -S | FileCheck %s

; This looks like a normal sign extension, but it's not.
; This comes up in JPEG decoding. This check is really unpredictable,
; so it is likely beneficial to avoid the branch.

define i32 @extend_value(i32 %storage, i32 %nbits) {
; CHECK-LABEL: @extend_value(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[SKIPNBITS:%.*]] = sub i32 32, [[NBITS:%.*]]
; CHECK-NEXT:    [[VALUE:%.*]] = lshr i32 [[STORAGE:%.*]], [[SKIPNBITS]]
; CHECK-NEXT:    [[SHOULDEXTEND:%.*]] = icmp sgt i32 [[STORAGE]], -1
; CHECK-NEXT:    [[HIGHBITMASK:%.*]] = shl nsw i32 -1, [[NBITS]]
; CHECK-NEXT:    [[HIGHBITMASKPLUSONE:%.*]] = add nsw i32 [[HIGHBITMASK]], 1
; CHECK-NEXT:    [[EXTENDED:%.*]] = add i32 [[HIGHBITMASKPLUSONE]], [[VALUE]]
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[SHOULDEXTEND]], i32 [[EXTENDED]], i32 [[VALUE]]
; CHECK-NEXT:    ret i32 [[RES]]
;
bb:
  %skipnbits = sub i32 32, %nbits
  %value = lshr i32 %storage, %skipnbits
  %shouldextend = icmp sgt i32 %storage, -1
  br i1 %shouldextend, label %extend, label %end

extend:                                              ; preds = %bb
  %highbitmask = shl nsw i32 -1, %nbits
  %highbitmaskplusone = add nsw i32 %highbitmask, 1
  %extended = add i32 %highbitmaskplusone, %value
  br label %end

end:                                              ; preds = %extend, %bb
  %res = phi i32 [ %extended, %extend ], [ %value, %bb ]
  ret i32 %res
}
