; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -rewrite-statepoints-for-gc < %s | FileCheck %s

target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128-ni:1-p2:32:8:8:32-ni:2"
target triple = "x86_64-unknown-linux-gnu"

declare void @foo() gc "statepoint-example"
declare i1 @runtime_value() "gc-leaf-function"

define i8 addrspace(1)* @test1(i8 addrspace(1)* %b1, i8 addrspace(1)* %b2) gc "statepoint-example" {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[B5:%.*]] = phi i8 addrspace(1)* [ [[B1:%.*]], [[ENTRY:%.*]] ], [ [[B6:%.*]], [[INNER_LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C1:%.*]] = call i1 @runtime_value()
; CHECK-NEXT:    br i1 [[C1]], label [[INNER_LOOP:%.*]], label [[EXIT:%.*]]
; CHECK:       inner_loop:
; CHECK-NEXT:    [[B6]] = phi i8 addrspace(1)* [ [[B5]], [[LOOP]] ], [ [[B6]], [[INNER_LOOP]] ]
; CHECK-NEXT:    [[C2:%.*]] = call i1 @runtime_value()
; CHECK-NEXT:    br i1 [[C2]], label [[INNER_LOOP]], label [[INNER_LOOP_LATCH]]
; CHECK:       inner_loop_latch:
; CHECK-NEXT:    [[C3:%.*]] = call i1 @runtime_value()
; CHECK-NEXT:    br i1 [[C3]], label [[LOOP]], label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[MERGE:%.*]] = phi i8 addrspace(1)* [ [[B5]], [[LOOP]] ], [ [[B6]], [[INNER_LOOP_LATCH]] ]
; CHECK-NEXT:    [[STATEPOINT_TOKEN:%.*]] = call token (i64, i32, void ()*, i32, i32, ...) @llvm.experimental.gc.statepoint.p0f_isVoidf(i64 2882400000, i32 0, void ()* elementtype(void ()) @foo, i32 0, i32 0, i32 0, i32 0) [ "deopt"(), "gc-live"(i8 addrspace(1)* [[MERGE]], i8 addrspace(1)* [[B1]]) ]
; CHECK-NEXT:    [[MERGE_RELOCATED:%.*]] = call coldcc i8 addrspace(1)* @llvm.experimental.gc.relocate.p1i8(token [[STATEPOINT_TOKEN]], i32 1, i32 0)
; CHECK-NEXT:    [[B1_RELOCATED:%.*]] = call coldcc i8 addrspace(1)* @llvm.experimental.gc.relocate.p1i8(token [[STATEPOINT_TOKEN]], i32 1, i32 1)
; CHECK-NEXT:    ret i8 addrspace(1)* [[MERGE_RELOCATED]]
;
entry:
  br label %loop

loop:
  %b5 = phi i8 addrspace(1)* [ %b1, %entry ], [ %b6, %inner_loop_latch ]
  %c1 = call i1 @runtime_value()
  br i1 %c1, label %inner_loop, label %exit

inner_loop:
  %b6 = phi i8 addrspace(1)* [ %b5, %loop ], [ %b6, %inner_loop ]
  %c2 = call i1 @runtime_value()
  br i1 %c2, label %inner_loop, label %inner_loop_latch

inner_loop_latch:
  %c3 = call i1 @runtime_value()
  br i1 %c3, label %loop, label %exit

exit:
  %merge = phi i8 addrspace(1)* [ %b5, %loop ], [ %b6, %inner_loop_latch ]
  call void @foo() [ "deopt"() ]
  ret i8 addrspace(1)* %merge
}

define i8 addrspace(1)* @swap(i8 addrspace(1)* %b1, i8 addrspace(1)* %b2) gc "statepoint-example" {
; CHECK-LABEL: @swap(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[B5:%.*]] = phi i8 addrspace(1)* [ [[B1:%.*]], [[ENTRY:%.*]] ], [ [[B6:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[B6]] = phi i8 addrspace(1)* [ [[B1]], [[ENTRY]] ], [ [[B5]], [[LOOP]] ]
; CHECK-NEXT:    [[C1:%.*]] = call i1 @runtime_value()
; CHECK-NEXT:    br i1 [[C1]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[STATEPOINT_TOKEN:%.*]] = call token (i64, i32, void ()*, i32, i32, ...) @llvm.experimental.gc.statepoint.p0f_isVoidf(i64 2882400000, i32 0, void ()* elementtype(void ()) @foo, i32 0, i32 0, i32 0, i32 0) [ "deopt"(), "gc-live"(i8 addrspace(1)* [[B6]], i8 addrspace(1)* [[B1]]) ]
; CHECK-NEXT:    [[B6_RELOCATED:%.*]] = call coldcc i8 addrspace(1)* @llvm.experimental.gc.relocate.p1i8(token [[STATEPOINT_TOKEN]], i32 1, i32 0)
; CHECK-NEXT:    [[B1_RELOCATED:%.*]] = call coldcc i8 addrspace(1)* @llvm.experimental.gc.relocate.p1i8(token [[STATEPOINT_TOKEN]], i32 1, i32 1)
; CHECK-NEXT:    ret i8 addrspace(1)* [[B6_RELOCATED]]
;
entry:
  br label %loop

loop:
  %b5 = phi i8 addrspace(1)* [ %b1, %entry ], [ %b6, %loop ]
  %b6 = phi i8 addrspace(1)* [ %b1, %entry ], [ %b5, %loop ]
  %c1 = call i1 @runtime_value()
  br i1 %c1, label %loop, label %exit

exit:
  call void @foo() [ "deopt"() ]
  ret i8 addrspace(1)* %b6
}
