/*
 * Copyright (c) 2002, Jens Maurer under the Boost Software License, Version 1.0
 * Copyright (c) 2007-2010, Erik Lindroos <gliptic@gmail.com> under the
 * BSD-2-Clause License
 *
 *
 * Boost Software License - Version 1.0 - August 17th, 2003
 *
 * Permission is hereby granted, free of charge, to any person or organization
 * obtaining a copy of the software and accompanying documentation covered by
 * this license (the "Software") to use, reproduce, display, distribute,
 * execute, and transmit the Software, and to prepare derivative works of the
 * Software, and to permit third-parties to whom the Software is furnished to
 * do so, all subject to the following:
 *
 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer,
 * must be included in all copies of the Software, in whole or in part, and
 * all derivative works of the Software, unless such copies or derivative
 * works are solely in the form of machine-executable object code generated by
 * a source language processor.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 *
 * BSD-2-Clause License:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef LIERO_LFS_HPP
#define LIERO_LFS_HPP

// Tausworte 1965
template<class UIntType, int w, int k, int q, int s, UIntType val>
struct LFS
{
	typedef unsigned int UIntType;
	typedef UIntType result_type;
	/*
	// avoid the warning trouble when using (1<<w) on 32 bit machines
	BOOST_STATIC_CONSTANT(bool, has_fixed_range = false);
	BOOST_STATIC_CONSTANT(int, word_size = w);
	BOOST_STATIC_CONSTANT(int, exponent1 = k);
	BOOST_STATIC_CONSTANT(int, exponent2 = q);
	BOOST_STATIC_CONSTANT(int, step_size = s);
	*/

	result_type min() const { return 0; }
	result_type max() const { return wordmask; }

	// MSVC 6 and possibly others crash when encountering complicated integral
	// constant expressions.  Avoid the checks for now.
	// BOOST_STATIC_ASSERT(w > 0);
	// BOOST_STATIC_ASSERT(q > 0);
	// BOOST_STATIC_ASSERT(k < w);
	// BOOST_STATIC_ASSERT(0 < 2*q && 2*q < k);
	// BOOST_STATIC_ASSERT(0 < s && s <= k-q);

	explicit LFS(UIntType s0 = 341)
	: wordmask(0)
	{

		for(int i = 0; i < w; ++i)
			wordmask |= (1u << i);
		seed(s0);
	}

/*
	template<class It>
	LFS(It& first, It last)
	: wordmask(0)
	{
		// avoid "left shift count >= with of type" warning
		for(int i = 0; i < w; ++i)
			wordmask |= (1u << i);
		seed(first, last);
	}
*/
	void seed(UIntType s0)
	{
		assert(s0 >= (1 << (w-k)));
		value = s0;
	}

	/*
	template<class It> void seed(It& first, It last)
	{
	if(first == last)
		throw std::invalid_argument("linear_feedback_shift::seed");
	value = *first++;
	assert(value >= (1 << (w-k)));
	}*/

	result_type operator()()
	{
		UIntType const b = (((value << q) ^ value) & wordmask) >> (k-s);
		UIntType const mask = ( (~static_cast<UIntType>(0)) << (w-k) ) & wordmask;
		value = ((value & mask) << s) ^ b;
		return value;
	}

	UIntType wordmask; // avoid "left shift count >= width of type" warnings
	UIntType value;
};


#endif // BOOST_RANDOM_LINEAR_FEEDBACK_SHIFT_HPP
