package junit.test.svg;

import latexDraw.parsers.svg.MalformedSVGDocument;
import latexDraw.parsers.svg.SVGAttributes;
import latexDraw.parsers.svg.SVGElements;
import latexDraw.parsers.svg.elements.SVGImageElement;

import org.junit.Test;

/** 
 * This class contains tests for the SVGImageElement class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/15/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestSVGImageElement extends AbstractTestSVGElement
{
	@Test
	public void testContructor()
	{
		try
		{ 
			new SVGImageElement(null, "");
			fail();
		}
		catch(Exception e){/**/}
		
		try 
		{ 
			new SVGImageElement(node, null); 
			fail(); 
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{ 
			node.setAttribute(SVGAttributes.SVG_WIDTH, "dsd");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "dsd");
			new SVGImageElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{ 
			node.setAttribute(SVGAttributes.SVG_WIDTH, "1");
			new SVGImageElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{ 
			node.setAttribute(SVGAttributes.SVG_WIDTH, "-1");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "10");
			new SVGImageElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{ 
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "-1");
			new SVGImageElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			new SVGImageElement(node, null);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	
	@Test
	public void testGetHeight()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			SVGImageElement e = new SVGImageElement(node, null);
			assertEquals(e.getHeight(), 20.);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Test
	public void testGetWidth()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			SVGImageElement e = new SVGImageElement(node, null);
			assertEquals(e.getWidth(), 10.);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetURI()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			SVGImageElement e = new SVGImageElement(node, null);
			assertNull(e.getURI());
			
			node.setAttribute("xlink:href", "/dir/file");
			e = new SVGImageElement(node, null);
			assertEquals(e.getURI(), "/dir/file");
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testEnableRendering()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			SVGImageElement e = new SVGImageElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute("xlink:href", "/rerzerojcsf/dsqdsdfgdre");
			e = new SVGImageElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute("xlink:href", "build.xml");
			e = new SVGImageElement(node, null);
			assertTrue(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_WIDTH, "0");
			e = new SVGImageElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "0");
			e = new SVGImageElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_WIDTH, "20");
			e = new SVGImageElement(node, null);
			assertFalse(e.enableRendering());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetY()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			SVGImageElement e = new SVGImageElement(node, null);
			assertEquals(e.getY(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_Y, "1");
			e = new SVGImageElement(node, null);
			assertEquals(1., e.getY());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Test
	public void testGetX()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			SVGImageElement e = new SVGImageElement(node, null);
			assertEquals(e.getX(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_X, "1");
			e = new SVGImageElement(node, null);
			assertEquals(1., e.getX());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Override
	public String getNameNode()
	{
		return SVGElements.SVG_IMAGE;
	}
}
