/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "profilepskoptions.h"

#include <QtGui/QCheckBox>
#include <QtGui/QLabel>
#include <QtGui/QSpinBox>

#include <kcombobox.h>
#include <klineedit.h>
#include <klocale.h>
#include <kurlrequester.h>

#include "widgetnotifyhelper.h"

ProfilePskOptions::ProfilePskOptions(QWidget *parent) : QWidget(parent)
{
    setupUi(this);
    WidgetNotifyHelper h;
    h.setupChangedAction(this);
    dialogModified = false;
}


ProfilePskOptions::~ProfilePskOptions()
{}

void ProfilePskOptions::pskIsInFileToggled(bool)
{
    if (PskInFileCheckBox->isChecked()) {
        LabelPskFile->setEnabled(true);
        PSKFileURLRequester->setEnabled(true);
        LabelPsk->setEnabled(false);
        PSKLineEdit->setEnabled(false);
    } else {
        LabelPskFile->setEnabled(false);
        PSKFileURLRequester->setEnabled(false);
        LabelPsk->setEnabled(true);
        PSKLineEdit->setEnabled(true);

    }
}

void ProfilePskOptions::dialogChanged()
{
    dialogModified = true;
}

