/**
 * This file is part of JS8Call.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * (C) 2018 Jordan Sherer <kn4crd@gmail.com> - All Rights Reserved
 *
 **/
#include "jsc.h"

const Tuple JSC::list[262144] = {
    // str, len, index
	{"~", 1, 66},
	{"}", 1, 61},
	{"|", 1, 62},
	{"{", 1, 60},
	{"`", 1, 65},
	{"_", 1, 48},
	{"^", 1, 64},
	{"]", 1, 59},
    {" ", 1, 67},
	{"[", 1, 58},
	{"ZZZZ", 4, 91474},
	{"ZZZ", 3, 70901},
	{"ZZYY", 4, 171515},
	{"ZZYW", 4, 183602},
	{"ZZYT", 4, 195566},
	{"ZZYS", 4, 133423},
	{"ZZYP", 4, 253527},
	{"ZZYO", 4, 172771},
	{"ZZYL", 4, 212405},
	{"ZZYI", 4, 129011},
	{"ZZYH", 4, 226963},
	{"ZZYG", 4, 198689},
	{"ZZYF", 4, 204648},
	{"ZZYD", 4, 206269},
	{"ZZYC", 4, 218635},
	{"ZZYB", 4, 188415},
	{"ZZYA", 4, 135438},
	{"ZZY", 3, 204198},
	{"ZZWO", 4, 125670},
	{"ZZWI", 4, 141529},
	{"ZZWH", 4, 197251},
	{"ZZWE", 4, 253872},
	{"ZZWA", 4, 180768},
	{"ZZW", 3, 205370},
	{"ZZV", 3, 50324},
	{"ZZUT", 4, 241579},
	{"ZZUR", 4, 199524},
	{"ZZU", 3, 31155},
	{"ZZTR", 4, 188554},
	{"ZZTO", 4, 144459},
	{"ZZTH", 4, 131310},
	{"ZZT", 3, 7286},
	{"ZZST", 4, 152201},
	{"ZZSO", 4, 209673},
	{"ZZSI", 4, 184603},
	{"ZZSE", 4, 249107},
	{"ZZSC", 4, 222846},
	{"ZZSA", 4, 168719},
	{"ZZS", 3, 6535},
	{"ZZRO", 4, 170163},
	{"ZZRIL", 5, 257997},
	{"ZZRE", 4, 179216},
	{"ZZR", 3, 142495},
	{"ZZQ", 3, 68030},
	{"ZZPR", 4, 245105},
	{"ZZPI", 4, 183372},
	{"ZZP", 3, 30118},
	{"ZZOW", 4, 159173},
	{"ZZOV", 4, 252822},
	{"ZZOUNDS", 7, 118475},
	{"ZZOU", 4, 142449},
	{"ZZOT", 4, 149578},
	{"ZZOS", 4, 108775},
	{"ZZOR", 4, 148895},
	{"ZZOP", 4, 189278},
	{"ZZOO", 4, 258885},
	{"ZZON", 4, 124188},
	{"ZZOM", 4, 260438},
	{"ZZOL", 4, 131547},
	{"ZZOI", 4, 175062},
	{"ZZOH", 4, 221929},
	{"ZZOF", 4, 149973},
	{"ZZOD", 4, 217699},
	{"ZZOC", 4, 195567},
	{"ZZOB", 4, 245106},
	{"ZZOA", 4, 139687},
	{"ZZO", 3, 2147},
	{"ZZMU", 4, 110740},
	{"ZZMA", 4, 167645},
	{"ZZM", 3, 8398},
	{"ZZLY", 4, 109073},
	{"ZZLI", 4, 58510},
	{"ZZLE", 4, 40970},
	{"ZZLA", 4, 244191},
	{"ZZL", 3, 1181},
	{"ZZJ", 3, 254362},
	{"ZZIW", 4, 160879},
	{"ZZIT", 4, 164560},
	{"ZZIS", 4, 101738},
	{"ZZIPLIB", 7, 229604},
	{"ZZIO", 4, 197568},
	{"ZZIN", 4, 66925},
	{"ZZIM", 4, 235769},
	{"ZZIL", 4, 249767},
	{"ZZII", 4, 184604},
	{"ZZIH", 4, 229975},
	{"ZZIF", 4, 226964},
	{"ZZIE", 4, 69128},
	{"ZZIC", 4, 159959},
	{"ZZIA", 4, 125104},
	{"ZZI", 3, 1563},
	{"ZZHE", 4, 261557},
	{"ZZHA", 4, 156233},
	{"ZZH", 3, 33488},
	{"ZZGU", 4, 207720},
	{"ZZGR", 4, 210477},
	{"ZZGL", 4, 172754},
	{"ZZG", 3, 35024},
	{"ZZFU", 4, 196769},
	{"ZZFR", 4, 251450},
	{"ZZFO", 4, 167996},
	{"ZZFE", 4, 114334},
	{"ZZFA", 4, 242435},
	{"ZZF", 3, 7070},
	{"ZZET", 4, 169989},
	{"ZZES", 4, 123803},
	{"ZZER", 4, 74005},
	{"ZZEN", 4, 148529},
	{"ZZEL", 4, 140523},
	{"ZZE", 3, 2560},
	{"ZZD", 3, 37628},
	{"ZZCO", 4, 124849},
	{"ZZCL", 4, 163411},
	{"ZZCA", 4, 214023},
	{"ZZC", 3, 8101},
	{"ZZBU", 4, 236072},
	{"ZZBO", 4, 261185},
	{"ZZBE", 4, 196290},
	{"ZZBA", 4, 100625},
	{"ZZB", 3, 6792},
	{"ZZAW", 4, 134177},
	{"ZZAT", 4, 108439},
	{"ZZAS", 4, 87280},
	{"ZZAR", 4, 55321},
	{"ZZAO", 4, 164887},
	{"ZZAN", 4, 69406},
	{"ZZAM", 4, 138576},
	{"ZZAL", 4, 130964},
	{"ZZAK", 4, 261937},
	{"ZZAI", 4, 127735},
	{"ZZAH", 4, 123100},
	{"ZZAG", 4, 200545},
	{"ZZAF", 4, 146764},
	{"ZZAD", 4, 136505},
	{"ZZAC", 4, 145673},
	{"ZZAB", 4, 127483},
	{"ZZAA", 4, 99625},
	{"ZZ", 2, 282},
	{"ZYZE", 4, 133638},
	{"ZYZ", 3, 241749},
	{"ZYY", 3, 55882},
	{"ZYXEL", 5, 75426},
	{"ZYX", 3, 116509},
	{"ZYWO", 4, 186269},
	{"ZYWI", 4, 142736},
	{"ZYWH", 4, 151529},
	{"ZYWE", 4, 228964},
	{"ZYWALL", 6, 178142},
	{"ZYWA", 4, 156110},
	{"ZYW", 3, 7308},
	{"ZYVEX", 5, 222367},
	{"ZYV", 3, 57002},
	{"ZYUGANOV", 8, 257960},
	{"ZYU", 3, 38846},
	{"ZYTO", 4, 107223},
	{"ZYTH", 4, 106596},
	{"ZYTEL", 5, 211854},
	{"ZYTE", 4, 254211},
	{"ZYT", 3, 5575},
	{"ZYSZ", 4, 221021},
	{"ZYSU", 4, 200546},
	{"ZYST", 4, 142559},
	{"ZYSP", 4, 218868},
	{"ZYSO", 4, 206426},
	{"ZYSK", 4, 183232},
	{"ZYSI", 4, 251140},
	{"ZYSH", 4, 199345},
	{"ZYSE", 4, 191919},
	{"ZYSC", 4, 243604},
	{"ZYSA", 4, 151030},
	{"ZYS", 3, 4372},
	{"ZYRTEC", 6, 64654},
	{"ZYRI", 4, 244192},
	{"ZYRE", 4, 163580},
	{"ZYR", 3, 31423},
	{"ZYQ", 3, 68154},
	{"ZYPREXA", 7, 82251},
	{"ZYPR", 4, 196921},
	{"ZYPO", 4, 210478},
	{"ZYPE", 4, 168882},
	{"ZYPA", 4, 224626},
	{"ZYP", 3, 9756},
	{"ZYOU", 4, 144764},
	{"ZYOS", 4, 227706},
	{"ZYOR", 4, 179870},
	{"ZYON", 4, 179326},
	{"ZYOF", 4, 164888},
	{"ZYO", 3, 7149},
	{"ZYNS", 4, 92441},
	{"ZYNO", 4, 222416},
	{"ZYNG", 4, 193934},
	{"ZYNE", 4, 247230},
	{"ZYNA", 4, 210866},
	{"ZYN", 3, 5574},
	{"ZYMOL", 5, 214538},
	{"ZYMO", 4, 182268},
	{"ZYME", 4, 163806},
	{"ZYMA", 4, 124285},
	{"ZYM", 3, 3460},
	{"ZYLOPRIM", 8, 134669},
	{"ZYLO", 4, 179327},
	{"ZYLISS", 6, 148073},
	{"ZYLI", 4, 180769},
	{"ZYLE", 4, 254589},
	{"ZYL", 3, 130719},
	{"ZYKS", 4, 238759},
	{"ZYKO", 4, 248145},
	{"ZYKLON", 6, 175139},
	{"ZYKI", 4, 260845},
	{"ZYKA", 4, 196922},
	{"ZYK", 3, 9523},
	{"ZYJ", 3, 44428},
	{"ZYIS", 4, 156548},
	{"ZYIN", 4, 105081},
	{"ZYI", 3, 6990},
	{"ZYHO", 4, 153585},
	{"ZYHE", 4, 172585},
	{"ZYHA", 4, 159414},
	{"ZYH", 3, 10076},
	{"ZYGOTIC", 7, 198428},
	{"ZYGOTE", 6, 141318},
	{"ZYGOMATIC", 9, 237871},
	{"ZYGO", 4, 229422},
	{"ZYGMUNT", 7, 184266},
	{"ZYGI", 4, 180998},
	{"ZYGA", 4, 239029},
	{"ZYG", 3, 7916},
	{"ZYFR", 4, 234874},
	{"ZYFO", 4, 155160},
	{"ZYFE", 4, 255277},
	{"ZYFA", 4, 241290},
	{"ZYF", 3, 250055},
	{"ZYEN", 4, 245734},
	{"ZYE", 3, 30944},
	{"ZYDR", 4, 163680},
	{"ZYDONE", 6, 226411},
	{"ZYDO", 4, 246033},
	{"ZYDI", 4, 231309},
	{"ZYDECO", 6, 82964},
	{"ZYDE", 4, 160401},
	{"ZYDA", 4, 218869},
	{"ZYD", 3, 9242},
	{"ZYCO", 4, 140969},
	{"ZYCA", 4, 176553},
	{"ZYC", 3, 8444},
	{"ZYBU", 4, 128134},
	{"ZYBO", 4, 210867},
	{"ZYBI", 4, 228215},
	{"ZYBE", 4, 168178},
	{"ZYBAN", 5, 46321},
	{"ZYBA", 4, 212612},
	{"ZYB", 3, 6930},
	{"ZYAT", 4, 206427},
	{"ZYAS", 4, 154376},
	{"ZYAR", 4, 234875},
	{"ZYAN", 4, 78441},
	{"ZYAL", 4, 182269},
	{"ZYAIR", 5, 179041},
	{"ZYAB", 4, 151590},
	{"ZYA", 3, 3419},
	{"ZXX", 3, 258108},
	{"ZXVF", 4, 231031},
	{"ZXV", 3, 230191},
	{"ZXU", 3, 168972},
	{"ZXSP", 4, 231560},
	{"ZXP", 3, 120418},
	{"ZXM", 3, 117814},
	{"ZXL", 3, 118681},
	{"ZXK", 3, 262075},
	{"ZXG", 3, 149137},
	{"ZXD", 3, 166060},
	{"ZXC", 3, 102702},
	{"ZXB", 3, 127823},
	{"ZWZ", 3, 149138},
	{"ZWY", 3, 97264},
	{"ZWW", 3, 76175},
	{"ZWV", 3, 239953},
	{"ZWU", 3, 135566},
	{"ZWRO", 4, 203612},
	{"ZWRI", 4, 256326},
	{"ZWR", 3, 40560},
	{"ZWP", 3, 112909},
	{"ZWOU", 4, 114364},
	{"ZWOR", 4, 101767},
	{"ZWON", 4, 134020},
	{"ZWOLLE", 6, 135672},
	{"ZWM", 3, 122410},
	{"ZWL", 3, 91646},
	{"ZWK", 3, 151205},
	{"ZWJ", 3, 160447},
	{"ZWIT", 4, 82768},
	{"ZWISCHEN", 8, 94066},
	{"ZWINGLI", 7, 210397},
	{"ZWIN", 4, 136120},
	{"ZWILLING", 8, 246819},
	{"ZWIL", 4, 82834},
	{"ZWIKI", 5, 160292},
	{"ZWIESEL", 7, 241529},
	{"ZWICKY", 6, 222221},
	{"ZWICKER", 7, 228079},
	{"ZWICKAU", 7, 235265},
	{"ZWICK", 5, 138618},
	{"ZWIC", 4, 197899},
	{"ZWHO", 4, 58050},
	{"ZWHI", 4, 103056},
	{"ZWHE", 4, 118200},
	{"ZWHA", 4, 192907},
	{"ZWG", 3, 175467},
	{"ZWF", 3, 151206},
	{"ZWER", 4, 109717},
	{"ZWEMBADEN", 9, 188809},
	{"ZWEMBAD", 7, 100724},
	{"ZWEL", 4, 190065},
	{"ZWEITEN", 7, 226173},
	{"ZWEITE", 6, 185899},
	{"ZWEIG", 5, 161418},
	{"ZWEIFEL", 7, 177333},
	{"ZWEI", 4, 82837},
	{"ZWECKFORM", 9, 240224},
	{"ZWEB", 4, 243115},
	{"ZWE", 3, 4686},
	{"ZWD", 3, 98800},
	{"ZWC", 3, 96846},
	{"ZWB", 3, 118682},
	{"ZWAT", 4, 234876},
	{"ZWAS", 4, 48811},
	{"ZWARTE", 6, 163279},
	{"ZWART", 5, 111475},
	{"ZWAR", 4, 137235},
	{"ZWANE", 5, 214872},
	{"ZWAN", 4, 142863},
	{"ZWAL", 4, 153586},
	{"ZWA", 3, 1783},
	{"ZVZ", 3, 132797},
	{"ZVY", 3, 106122},
	{"ZVW", 3, 182973},
	{"ZVV", 3, 155525},
	{"ZVU", 3, 104333},
	{"ZVR", 3, 111406},
	{"ZVP", 3, 191875},
	{"ZVOU", 4, 94366},
	{"ZVONENIA", 8, 204369},
	{"ZVON", 4, 139761},
	{"ZVO", 3, 5872},
	{"ZVM", 3, 123412},
	{"ZVL", 3, 131454},
	{"ZVK", 3, 262076},
	{"ZVJ", 3, 147236},
	{"ZVIN", 4, 241291},
	{"ZVIL", 4, 196603},
	{"ZVG", 3, 222256},
	{"ZVF", 3, 230192},
	{"ZVEZDA", 6, 152316},
	{"ZVER", 4, 192483},
	{"ZVENTS", 6, 187616},
	{"ZVE", 3, 32975},
	{"ZVD", 3, 153328},
	{"ZVC", 3, 166061},
	{"ZVB", 3, 163227},
	{"ZVAL", 4, 193993},
	{"ZVAH", 4, 145956},
	{"ZVA", 3, 30679},
	{"ZUZU", 4, 232525},
	{"ZUZT", 4, 257017},
	{"ZUZANA", 6, 165318},
	{"ZUZA", 4, 205731},
	{"ZUZ", 3, 28877},
	{"ZUYA", 4, 175821},
	{"ZUY", 3, 38521},
	{"ZUX", 3, 187231},
	{"ZUWA", 4, 226223},
	{"ZUW", 3, 42281},
	{"ZUV", 3, 78098},
	{"ZUU", 3, 71966},
	{"ZUTPHEN", 7, 235241},
	{"ZUTONS", 6, 134485},
	{"ZUTANO", 6, 146914},
	{"ZUSTAND", 7, 258324},
	{"ZUSH", 4, 208108},
	{"ZUSE", 4, 240527},
	{"ZUSATZKOSTEN", 12, 159693},
	{"ZUSAMMENFASSUNG", 15, 153478},
	{"ZUSAMMENARBEIT", 14, 178008},
	{"ZUSAMMEN", 8, 131689},
	{"ZUSA", 4, 144136},
	{"ZUS", 3, 9322},
	{"ZURU", 4, 171669},
	{"ZURR", 4, 180200},
	{"ZURICH", 6, 41104},
	{"ZURG", 4, 246611},
	{"ZUREK", 5, 226421},
	{"ZURE", 4, 63226},
	{"ZURCHER", 7, 226903},
	{"ZURAB", 5, 254143},
	{"ZUR", 3, 46061},
	{"ZUQ", 3, 120419},
	{"ZUPREEM", 7, 244259},
	{"ZUPPA", 5, 256647},
	{"ZUPKO", 5, 221156},
	{"ZUPAN", 5, 202660},
	{"ZUPALO", 6, 253478},
	{"ZUP", 3, 216231},
	{"ZUOK", 4, 235770},
	{"ZUNT", 4, 241580},
	{"ZUNO", 4, 170089},
	{"ZUNIGA", 6, 154536},
	{"ZUNI", 4, 91820},
	{"ZUNE", 4, 91486},
	{"ZUNDEL", 6, 145697},
	{"ZUND", 4, 185606},
	{"ZUNCH", 5, 180848},
	{"ZUNA", 4, 133857},
	{"ZUMWALT", 7, 174798},
	{"ZUMW", 4, 187456},
	{"ZUMU", 4, 256651},
	{"ZUMO", 4, 185607},
	{"ZUMI", 4, 102941},
	{"ZUME", 4, 225782},
	{"ZUMBROTA", 8, 243758},
	{"ZUMB", 4, 166545},
	{"ZUMANITY", 8, 160325},
	{"ZUMA", 4, 72846},
	{"ZUM", 3, 4684},
	{"ZULUS", 5, 207056},
	{"ZULULAND", 8, 136433},
	{"ZULUBABY", 8, 228078},
	{"ZULU", 4, 59314},
	{"ZULLEN", 6, 206402},
	{"ZULL", 4, 170809},
	{"ZULK", 4, 237671},
	{"ZULI", 4, 161607},
	{"ZULF", 4, 222847},
	{"ZULETZT", 7, 124896},
	{"ZULA", 4, 164213},
	{"ZUL", 3, 204555},
	{"ZUKUNFT", 7, 144381},
	{"ZUKOWSKI", 8, 219918},
	{"ZUKERMAN", 8, 189508},
	{"ZUKA", 4, 101594},
	{"ZUK", 3, 203734},
	{"ZUJI", 4, 193821},
	{"ZUJ", 3, 80354},
	{"ZUIS", 4, 229221},
	{"ZUIKO", 5, 131917},
	{"ZUIDERDAM", 9, 255449},
	{"ZUID", 4, 100210},
	{"ZUHO", 4, 185479},
	{"ZUHI", 4, 243605},
	{"ZUHA", 4, 214594},
	{"ZUH", 3, 33026},
	{"ZUGANG", 6, 216306},
	{"ZUG", 3, 107698},
	{"ZUF", 3, 48072},
	{"ZUERST", 6, 195537},
	{"ZUERICH", 7, 192328},
	{"ZUEL", 4, 54782},
	{"ZUE", 3, 2651},
	{"ZUDEM", 5, 144347},
	{"ZUCKTE", 6, 218984},
	{"ZUCKERMAN", 9, 95579},
	{"ZUCKER", 6, 88566},
	{"ZUCK", 4, 221786},
	{"ZUCH", 4, 174452},
	{"ZUCCHINO", 8, 209159},
	{"ZUCCHINI", 8, 67372},
	{"ZUCCHERO", 8, 167527},
	{"ZUCCA", 5, 156866},
	{"ZUC", 3, 5738},
	{"ZUBO", 4, 261938},
	{"ZUBIN", 5, 200670},
	{"ZUBI", 4, 210669},
	{"ZUBER", 5, 163973},
	{"ZUBAIR", 6, 204612},
	{"ZUAN", 4, 171096},
	{"ZTWO", 4, 260040},
	{"ZTUR", 4, 142737},
	{"ZTU", 3, 35373},
	{"ZTTORNEY", 8, 243447},
	{"ZTRU", 4, 230579},
	{"ZTRI", 4, 158355},
	{"ZTRA", 4, 128171},
	{"ZTOW", 4, 177065},
	{"ZTORIES", 7, 234466},
	{"ZTOR", 4, 175822},
	{"ZTOP", 4, 160646},
	{"ZTOM", 4, 187025},
	{"ZTOL", 4, 132101},
	{"ZTOG", 4, 191495},
	{"ZTOF", 4, 170264},
	{"ZTOD", 4, 212406},
	{"ZTOC", 4, 197569},
	{"ZTOB", 4, 186499},
	{"ZTIM", 4, 254917},
	{"ZTHR", 4, 142787},
	{"ZTER", 4, 212201},
	{"ZTEL", 4, 207917},
	{"ZTEC", 4, 80293},
	{"ZTAL", 4, 190627},
	{"ZTAK", 4, 195688},
	{"ZSWI", 4, 205913},
	{"ZSUZSA", 6, 235349},
	{"ZSUR", 4, 203802},
	{"ZSUP", 4, 237059},
	{"ZSU", 3, 28914},
	{"ZSTU", 4, 191219},
	{"ZSTR", 4, 130694},
	{"ZSRE", 4, 164150},
	{"ZSPR", 4, 182062},
	{"ZSPO", 4, 162950},
	{"ZSPI", 4, 231823},
	{"ZSPE", 4, 148601},
	{"ZSPA", 4, 167327},
	{"ZSOU", 4, 221494},
	{"ZSOM", 4, 234877},
	{"ZSOLT", 5, 151399},
	{"ZSOL", 4, 210093},
	{"ZSOF", 4, 244193},
	{"ZSNES", 5, 212770},
	{"ZSMO", 4, 226965},
	{"ZSMI", 4, 242712},
	{"ZSMA", 4, 232643},
	{"ZSLI", 4, 245431},
	{"ZSLA", 4, 189673},
	{"ZSIM", 4, 148952},
	{"ZSIG", 4, 206428},
	{"ZSHOPS", 6, 33525},
	{"ZSFI", 4, 190194},
	{"ZSFA", 4, 188416},
	{"ZSF", 3, 32596},
	{"ZSERVER", 7, 186415},
	{"ZSERIES", 7, 100139},
	{"ZSER", 4, 142934},
	{"ZSEF", 4, 257385},
	{"ZSEC", 4, 250453},
	{"ZSDE", 4, 184350},
	{"ZSCO", 4, 108978},
	{"ZSCHECH", 7, 214336},
	{"ZSCH", 4, 84710},
	{"ZSCE", 4, 234287},
	{"ZSCA", 4, 172586},
	{"ZSC", 3, 4220},
	{"ZSAY", 4, 99258},
	{"ZSAW", 4, 178963},
	{"ZSAR", 4, 232644},
	{"ZSAL", 4, 239581},
	{"ZRZ", 3, 125576},
	{"ZRY", 3, 74429},
	{"ZRW", 3, 72677},
	{"ZRV", 3, 127824},
	{"ZRUN", 4, 250800},
	{"ZRU", 3, 35999},
	{"ZRSQ", 4, 214212},
	{"ZRR", 3, 74259},
	{"ZROY", 4, 141581},
	{"ZROD", 4, 218405},
	{"ZROC", 4, 181951},
	{"ZRM", 3, 75636},
	{"ZRL", 3, 112910},
	{"ZRK", 3, 121438},
	{"ZRJ", 3, 202336},
	{"ZRIV", 4, 246612},
	{"ZRIN", 4, 189397},
	{"ZRIC", 4, 119031},
	{"ZRI", 3, 7158},
	{"ZRG", 3, 116980},
	{"ZRF", 3, 70875},
	{"ZREV", 4, 253171},
	{"ZRET", 4, 149007},
	{"ZRES", 4, 151830},
	{"ZREP", 4, 142138},
	{"ZREN", 4, 209674},
	{"ZREM", 4, 185996},
	{"ZREL", 4, 208109},
	{"ZREG", 4, 209675},
	{"ZREF", 4, 210868},
	{"ZREC", 4, 116938},
	{"ZREA", 4, 165995},
	{"ZRE", 3, 3435},
	{"ZRD", 3, 82142},
	{"ZRB", 3, 71134},
	{"ZRAT", 4, 137819},
	{"ZRAS", 4, 244194},
	{"ZRAP", 4, 255976},
	{"ZRAN", 4, 149378},
	{"ZRAI", 4, 209098},
	{"ZRAH", 4, 177931},
	{"ZRAE", 4, 261186},
	{"ZRAD", 4, 226713},
	{"ZRAC", 4, 212613},
	{"ZRA", 3, 4486},
	{"ZQUI", 4, 190917},
	{"ZQUE", 4, 82685},
	{"ZQU", 3, 6187},
	{"ZQB", 3, 208378},
	{"ZPZ", 3, 132798},
	{"ZPY", 3, 117815},
	{"ZPX", 3, 182974},
	{"ZPW", 3, 88667},
	{"ZPV", 3, 208379},
	{"ZPUT", 4, 225544},
	{"ZPUB", 4, 229737},
	{"ZPU", 3, 34035},
	{"ZPRO", 4, 83377},
	{"ZPRI", 4, 229497},
	{"ZPRE", 4, 142738},
	{"ZPR", 3, 5341},
	{"ZPOS", 4, 207721},
	{"ZPOP", 4, 257771},
	{"ZPOL", 4, 201057},
	{"ZPOI", 4, 236073},
	{"ZPO", 3, 28470},
	{"ZPLA", 4, 113358},
	{"ZPL", 3, 167641},
	{"ZPK", 3, 137022},
	{"ZPJ", 3, 166062},
	{"ZPIT", 4, 197107},
	{"ZPIC", 4, 218406},
	{"ZPIA", 4, 183843},
	{"ZPER", 4, 130813},
	{"ZPB", 3, 96395},
	{"ZPAT", 4, 97166},
	{"ZPASS", 5, 233350},
	{"ZPAS", 4, 171472},
	{"ZPAR", 4, 156549},
	{"ZPAN", 4, 239030},
	{"ZPAL", 4, 250454},
	{"ZPAH", 4, 207918},
	{"ZPAC", 4, 209676},
	{"ZPA", 3, 4704},
	{"ZOYSIA", 6, 260980},
	{"ZOYA", 4, 196825},
	{"ZOWS", 4, 232360},
	{"ZOWN", 4, 251451},
	{"ZOWIE", 5, 194417},
	{"ZOWI", 4, 165648},
	{"ZOWH", 4, 168796},
	{"ZOWA", 4, 135439},
	{"ZOVS", 4, 188127},
	{"ZOVIRAX", 7, 74982},
	{"ZOVI", 4, 193622},
	{"ZOVE", 4, 176651},
	{"ZOVA", 4, 210094},
	{"ZOV", 3, 8724},
	{"ZOUS", 4, 248483},
	{"ZOULAS", 6, 254753},
	{"ZOUK", 4, 104881},
	{"ZOUCH", 5, 156281},
	{"ZOUB", 4, 232087},
	{"ZOUAVE", 6, 191756},
	{"ZOUA", 4, 192908},
	{"ZOTOB", 5, 215294},
	{"ZOSW", 4, 254918},
	{"ZOSV", 4, 257386},
	{"ZOSTER", 6, 98209},
	{"ZOSTA", 5, 258504},
	{"ZOSP", 4, 226490},
	{"ZOSC", 4, 181229},
	{"ZORYNADREAMS", 12, 198905},
	{"ZORW", 4, 189674},
	{"ZORTIC", 6, 179311},
	{"ZORT", 4, 142394},
	{"ZORS", 4, 111646},
	{"ZORRO", 5, 61916},
	{"ZORRAS", 6, 166866},
	{"ZORRA", 5, 241201},
	{"ZORR", 4, 138763},
	{"ZORPIA", 6, 199664},
	{"ZORP", 4, 256917},
	{"ZOROASTRIANS", 12, 239658},
	{"ZOROASTRIANISM", 14, 151615},
	{"ZOROASTRIAN", 11, 151648},
	{"ZOROASTER", 9, 194336},
	{"ZORO", 4, 199835},
	{"ZORN", 4, 82841},
	{"ZORL", 4, 238760},
	{"ZORKMIDDEN", 10, 134206},
	{"ZORK", 4, 144000},
	{"ZORIN", 5, 246104},
	{"ZORG", 4, 182746},
	{"ZORE", 4, 110717},
	{"ZORC", 4, 159561},
	{"ZORBA", 5, 151085},
	{"ZORB", 4, 221626},
	{"ZORAN", 5, 99209},
	{"ZORAK", 5, 261690},
	{"ZORA", 4, 91801},
	{"ZOPYRUS", 7, 118347},
	{"ZOPPINI", 7, 128052},
	{"ZOPICLONE", 9, 261162},
	{"ZOPE", 4, 31242},
	{"ZOOW", 4, 142646},
	{"ZOOSCAPE", 8, 223446},
	{"ZOOROPA", 7, 225155},
	{"ZOOR", 4, 161121},
	{"ZOOPLANKTON", 11, 92939},
	{"ZOOPHILIE", 9, 121963},
	{"ZOOPHILE", 8, 159912},
	{"ZOOPER", 6, 245990},
	{"ZOOP", 4, 253244},
	{"ZOONOTIC", 8, 150177},
	{"ZOONOSES", 8, 164544},
	{"ZOOMTEXT", 8, 255577},
	{"ZOOMS", 5, 90003},
	{"ZOOMLEVEL", 9, 200957},
	{"ZOOMING", 7, 73656},
	{"ZOOMINFO", 8, 166781},
	{"ZOOMIN", 6, 113550},
	{"ZOOMER", 6, 168267},
	{"ZOOMED", 6, 90843},
	{"ZOOMBROWSER", 11, 252276},
	{"ZOOMBINIS", 9, 253710},
	{"ZOOMABLE", 8, 181666},
	{"ZOOM", 4, 3985},
	{"ZOOLOGY", 7, 51413},
	{"ZOOLOGISTS", 10, 213260},
	{"ZOOLOGIST", 9, 143756},
	{"ZOOLOGICAL", 10, 70089},
	{"ZOOLANDER", 9, 142497},
	{"ZOOL", 4, 86267},
	{"ZOOKEEPER", 9, 124276},
	{"ZOOK", 4, 128650},
	{"ZOOG", 4, 216180},
	{"ZOOFILIA", 8, 42850},
	{"ZOOEY", 5, 156569},
	{"ZOOD", 4, 250099},
	{"ZOOC", 4, 145957},
	{"ZOOBOOKS", 8, 142253},
	{"ZOOBAB", 6, 142025},
	{"ZOOBA", 5, 191771},
	{"ZONW", 4, 83064},
	{"ZONV", 4, 217252},
	{"ZONU", 4, 239582},
	{"ZONTA", 5, 177681},
	{"ZONR", 4, 119980},
	{"ZONP", 4, 141727},
	{"ZONM", 4, 137179},
	{"ZONL", 4, 139358},
	{"ZONKER", 6, 228120},
	{"ZONK", 4, 228786},
	{"ZONJ", 4, 217253},
	{"ZONING", 6, 32008},
	{"ZONG", 4, 131710},
	{"ZONF", 4, 125153},
	{"ZONET", 5, 151397},
	{"ZONES", 5, 28976},
	{"ZONER", 5, 226557},
	{"ZONEPERFECT", 11, 210742},
	{"ZONELABS", 8, 223112},
	{"ZONEINFO", 8, 81617},
	{"ZONED", 5, 63569},
	{"ZONECHECK", 9, 257896},
	{"ZONECD", 6, 259987},
	{"ZONECAST", 8, 217002},
	{"ZONEALARM", 9, 75044},
	{"ZONE", 4, 5470},
	{"ZONDERVAN", 9, 89538},
	{"ZONDER", 6, 116450},
	{"ZONDAG", 6, 142124},
	{"ZONC", 4, 70655},
	{"ZONB", 4, 121655},
	{"ZONATION", 8, 178565},
	{"ZONAS", 5, 203344},
	{"ZONAL", 5, 78341},
	{"ZOMO", 4, 216644},
	{"ZOMIG", 5, 204317},
	{"ZOMI", 4, 211990},
	{"ZOMG", 4, 257906},
	{"ZOMETA", 6, 242555},
	{"ZOMER", 5, 253396},
	{"ZOMBO", 5, 139063},
	{"ZOMBIES", 7, 55608},
	{"ZOMBIE", 6, 37980},
	{"ZOMBI", 5, 193143},
	{"ZOMBA", 5, 156912},
	{"ZOMB", 4, 60261},
	{"ZOLTAN", 6, 98279},
	{"ZOLT", 4, 191774},
	{"ZOLPIDEM", 8, 108372},
	{"ZOLOFT", 6, 36457},
	{"ZOLMITRIPTAN", 12, 243867},
	{"ZOLLVEREIN", 10, 151859},
	{"ZOLLINGER", 9, 169971},
	{"ZOLLHOF", 7, 250660},
	{"ZOLLER", 6, 122641},
	{"ZOLL", 4, 123371},
	{"ZOLI", 4, 240629},
	{"ZOLEDRONIC", 10, 251741},
	{"ZOLD", 4, 225315},
	{"ZOLADEX", 7, 216544},
	{"ZOLA", 4, 95802},
	{"ZOKU", 4, 210095},
	{"ZOJIRUSHI", 9, 126521},
	{"ZOINKS", 6, 238304},
	{"ZOIL", 4, 229976},
	{"ZOIDS", 5, 90717},
	{"ZOIDBERG", 8, 199768},
	{"ZOID", 4, 185066},
	{"ZOHAR", 5, 115957},
	{"ZOGI", 4, 257018},
	{"ZOGBY", 5, 100068},
	{"ZOGB", 4, 202568},
	{"ZOGA", 4, 223057},
	{"ZOFW", 4, 260439},
	{"ZOFTWARE", 8, 253855},
	{"ZOFT", 4, 119059},
	{"ZOFS", 4, 189163},
	{"ZOFRAN", 6, 194060},
	{"ZOFR", 4, 254212},
	{"ZOFP", 4, 256327},
	{"ZOFM", 4, 234878},
	{"ZOFL", 4, 243606},
	{"ZOFI", 4, 219937},
	{"ZOFF", 4, 129305},
	{"ZOFE", 4, 207355},
	{"ZOFC", 4, 207722},
	{"ZOFB", 4, 261187},
	{"ZOFA", 4, 192909},
	{"ZOEY", 4, 123390},
	{"ZOETROPE", 8, 177863},
	{"ZOETERMEER", 10, 195794},
	{"ZOELLICK", 8, 127860},
	{"ZOELLER", 7, 193152},
	{"ZOEL", 4, 147093},
	{"ZOEKT", 5, 215378},
	{"ZOEKMACHINE", 11, 213285},
	{"ZOEKEN", 6, 73296},
	{"ZOEK", 4, 95773},
	{"ZOEGIRL", 7, 238894},
	{"ZODO", 4, 259266},
	{"ZODIAQUE", 8, 248325},
	{"ZODIACS", 7, 209458},
	{"ZODIACO", 7, 207772},
	{"ZODIACAL", 8, 144282},
	{"ZODIAC", 6, 40807},
	{"ZODE", 4, 182389},
	{"ZODB", 4, 78912},
	{"ZODA", 4, 229977},
	{"ZOCOR", 5, 70777},
	{"ZOCO", 4, 185480},
	{"ZOCH", 4, 236334},
	{"ZOCALO", 6, 202802},
	{"ZOCA", 4, 179549},
	{"ZOBR", 4, 155293},
	{"ZOBO", 4, 260041},
	{"ZOBEL", 5, 179273},
	{"ZOBE", 4, 152257},
	{"ZOBACZ", 6, 171662},
	{"ZOBA", 4, 224401},
	{"ZOAR", 4, 193396},
	{"ZOALS", 5, 163643},
	{"ZOAL", 4, 226714},
	{"ZNOW", 4, 165144},
	{"ZNOR", 4, 188871},
	{"ZNIK", 4, 171280},
	{"ZNIC", 4, 163507},
	{"ZNER", 4, 125304},
	{"ZNAV", 4, 191920},
	{"ZNAR", 4, 241581},
	{"ZNAJDZIESZ", 10, 222569},
	{"ZMZ", 3, 257984},
	{"ZMY", 3, 52836},
	{"ZMX", 3, 239954},
	{"ZMW", 3, 84601},
	{"ZMV", 3, 179143},
	{"ZMUS", 4, 92185},
	{"ZMUD", 4, 253330},
	{"ZMU", 3, 7463},
	{"ZMR", 3, 73477},
	{"ZMOV", 4, 163681},
	{"ZMOU", 4, 184090},
	{"ZMOT", 4, 256328},
	{"ZMOS", 4, 181694},
	{"ZMOR", 4, 173719},
	{"ZMON", 4, 173059},
	{"ZMODEM", 6, 198132},
	{"ZMOD", 4, 142139},
	{"ZMO", 3, 5256},
	{"ZML", 3, 91647},
	{"ZMK", 3, 89741},
	{"ZMJ", 3, 239955},
	{"ZMIS", 4, 184725},
	{"ZMIR", 4, 128508},
	{"ZMIL", 4, 175618},
	{"ZMIG", 4, 214402},
	{"ZMIE", 4, 232645},
	{"ZMIC", 4, 242436},
	{"ZMG", 3, 125577},
	{"ZMEX", 4, 249768},
	{"ZMET", 4, 209279},
	{"ZMER", 4, 181952},
	{"ZMEN", 4, 209099},
	{"ZMEM", 4, 251452},
	{"ZMED", 4, 215648},
	{"ZMEA", 4, 241860},
	{"ZME", 3, 7689},
	{"ZMC", 3, 52837},
	{"ZMAY", 4, 163032},
	{"ZMAX", 4, 188511},
	{"ZMAU", 4, 244514},
	{"ZMAT", 4, 137588},
	{"ZMAS", 4, 172949},
	{"ZMAR", 4, 112619},
	{"ZMAN", 4, 248740},
	{"ZMAK", 4, 191220},
	{"ZMAILER", 7, 83510},
	{"ZMAI", 4, 202569},
	{"ZMAD", 4, 134382},
	{"ZMAC", 4, 204476},
	{"ZLZ", 3, 131455},
	{"ZLYB", 4, 162213},
	{"ZLY", 3, 28978},
	{"ZLX", 3, 179144},
	{"ZLWK", 4, 142220},
	{"ZLW", 3, 61115},
	{"ZLV", 3, 132799},
	{"ZLU", 3, 42111},
	{"ZLR", 3, 85410},
	{"ZLP", 3, 233147},
	{"ZLOW", 4, 191221},
	{"ZLOV", 4, 162863},
	{"ZLOTYS", 6, 150368},
	{"ZLOTYCH", 7, 195353},
	{"ZLOTY", 5, 71557},
	{"ZLOT", 4, 222848},
	{"ZLOS", 4, 177474},
	{"ZLOO", 4, 222795},
	{"ZLON", 4, 230835},
	{"ZLO", 3, 5741},
	{"ZLM", 3, 77874},
	{"ZLK", 3, 96396},
	{"ZLJ", 3, 125578},
	{"ZLIV", 4, 239583},
	{"ZLIT", 4, 181953},
	{"ZLIS", 4, 177066},
	{"ZLIN", 4, 202144},
	{"ZLIK", 4, 199843},
	{"ZLIE", 4, 85244},
	{"ZLIC", 4, 261558},
	{"ZLIB", 4, 59650},
	{"ZLI", 3, 2397},
	{"ZLG", 3, 117816},
	{"ZLF", 3, 85956},
	{"ZLEZ", 4, 129551},
	{"ZLEY", 4, 166715},
	{"ZLEW", 4, 127849},
	{"ZLEV", 4, 202045},
	{"ZLET", 4, 92840},
	{"ZLES", 4, 69502},
	{"ZLER", 4, 90205},
	{"ZLEP", 4, 175918},
	{"ZLEO", 4, 129597},
	{"ZLEM", 4, 119392},
	{"ZLEL", 4, 166214},
	{"ZLEI", 4, 130338},
	{"ZLEH", 4, 205914},
	{"ZLEG", 4, 158356},
	{"ZLEF", 4, 125759},
	{"ZLEE", 4, 229978},
	{"ZLED", 4, 67738},
	{"ZLEC", 4, 190628},
	{"ZLEB", 4, 148216},
	{"ZLEA", 4, 101943},
	{"ZLD", 3, 93579},
	{"ZLAU", 4, 223058},
	{"ZLATKO", 6, 221131},
	{"ZLATA", 5, 222570},
	{"ZLAT", 4, 136284},
	{"ZLAS", 4, 189164},
	{"ZLAR", 4, 219493},
	{"ZLAN", 4, 142140},
	{"ZLAF", 4, 169448},
	{"ZLAC", 4, 214595},
	{"ZKZ", 3, 166063},
	{"ZKYW", 4, 239031},
	{"ZKYS", 4, 189009},
	{"ZKYA", 4, 209280},
	{"ZKY", 3, 9033},
	{"ZKW", 3, 83566},
	{"ZKV", 3, 191876},
	{"ZKU", 3, 55732},
	{"ZKRI", 4, 183233},
	{"ZKOW", 4, 157665},
	{"ZKOS", 4, 171473},
	{"ZKOP", 4, 239320},
	{"ZKOI", 4, 249430},
	{"ZKOA", 4, 211806},
	{"ZKO", 3, 6476},
	{"ZKNO", 4, 210670},
	{"ZKM", 3, 233148},
	{"ZKLFK", 5, 217188},
	{"ZKL", 3, 65857},
	{"ZKK", 3, 151207},
	{"ZKJ", 3, 239956},
	{"ZKIW", 4, 253873},
	{"ZKIT", 4, 208110},
	{"ZKIS", 4, 191921},
	{"ZKIN", 4, 252134},
	{"ZKIL", 4, 244195},
	{"ZKID", 4, 186373},
	{"ZKIA", 4, 215860},
	{"ZKI", 3, 6132},
	{"ZKHA", 4, 209886},
	{"ZKG", 3, 153329},
	{"ZKF", 3, 114465},
	{"ZKER", 4, 211991},
	{"ZKEL", 4, 258886},
	{"ZKE", 3, 29323},
	{"ZKD", 3, 157876},
	{"ZKC", 3, 104334},
	{"ZKB", 3, 108695},
	{"ZKA", 3, 28409},
	{"ZJZ", 3, 214983},
	{"ZJW", 3, 157877},
	{"ZJUS", 4, 211442},
	{"ZJU", 3, 38185},
	{"ZJR", 3, 42851},
	{"ZJOS", 4, 163763},
	{"ZJOI", 4, 216250},
	{"ZJOH", 4, 248484},
	{"ZJO", 3, 29490},
	{"ZJM", 3, 179145},
	{"ZJL", 3, 222257},
	{"ZJK", 3, 262077},
	{"ZJJ", 3, 187232},
	{"ZJG", 3, 208380},
	{"ZJF", 3, 262078},
	{"ZJD", 3, 166064},
	{"ZJC", 3, 141793},
	{"ZJB", 3, 202337},
	{"ZIZS", 4, 255636},
	{"ZIZEK", 5, 169141},
	{"ZIZA", 4, 155488},
	{"ZIZ", 3, 7910},
	{"ZIYI", 4, 108826},
	{"ZIYANG", 6, 258291},
	{"ZIWI", 4, 178847},
	{"ZIWH", 4, 173254},
	{"ZIWE", 4, 198856},
	{"ZIWA", 4, 128087},
	{"ZIW", 3, 7975},
	{"ZIVKOVIC", 8, 255156},
	{"ZIUS", 4, 219281},
	{"ZIUA", 4, 228129},
	{"ZITW", 4, 261939},
	{"ZITTING", 7, 190912},
	{"ZITHROMAX", 9, 64019},
	{"ZITHER", 6, 171615},
	{"ZITAT", 5, 147527},
	{"ZISY", 4, 242713},
	{"ZISW", 4, 137930},
	{"ZISU", 4, 185228},
	{"ZISSOU", 6, 137893},
	{"ZISR", 4, 162778},
	{"ZISP", 4, 149687},
	{"ZISOFS", 6, 216219},
	{"ZISM", 4, 115901},
	{"ZISL", 4, 155228},
	{"ZISG", 4, 203273},
	{"ZISF", 4, 168081},
	{"ZISD", 4, 170810},
	{"ZISC", 4, 96940},
	{"ZISB", 4, 156317},
	{"ZIRLINES", 8, 232605},
	{"ZIRKIN", 6, 241782},
	{"ZIRK", 4, 178645},
	{"ZIRIN", 5, 246407},
	{"ZIRI", 4, 110258},
	{"ZIRH", 4, 121860},
	{"ZIRE", 4, 56454},
	{"ZIRCONS", 7, 216424},
	{"ZIRCONIUM", 9, 90472},
	{"ZIRCONIAS", 9, 240556},
	{"ZIRCONIA", 8, 49757},
	{"ZIRCON", 6, 79027},
	{"ZIRB", 4, 168992},
	{"ZIPZOOMFLY", 10, 126243},
	{"ZIPWHAA", 7, 202706},
	{"ZIPU", 4, 251141},
	{"ZIPT", 4, 211807},
	{"ZIPS", 4, 71344},
	{"ZIPREALTY", 9, 167925},
	{"ZIPRASIDONE", 11, 225030},
	{"ZIPR", 4, 172175},
	{"ZIPPY", 5, 83720},
	{"ZIPPOS", 6, 240014},
	{"ZIPPO", 5, 59614},
	{"ZIPPING", 7, 126927},
	{"ZIPPERS", 7, 83417},
	{"ZIPPERED", 8, 63799},
	{"ZIPPER", 6, 45305},
	{"ZIPPEL", 6, 216146},
	{"ZIPPED", 6, 60754},
	{"ZIPP", 4, 142735},
	{"ZIPO", 4, 201393},
	{"ZIPLY", 5, 119579},
	{"ZIPLOCK", 7, 150083},
	{"ZIPLOC", 6, 165610},
	{"ZIPLABS", 7, 188962},
	{"ZIPL", 4, 154579},
	{"ZIPING", 6, 205320},
	{"ZIPI", 4, 178964},
	{"ZIPFILE", 7, 197461},
	{"ZIPF", 4, 181942},
	{"ZIPE", 4, 218162},
	{"ZIPDATA", 7, 195897},
	{"ZIPCODES", 8, 134542},
	{"ZIPCODE", 7, 55313},
	{"ZIPC", 4, 92212},
	{"ZIPA", 4, 103112},
	{"ZIP", 3, 284},
	{"ZIOW", 4, 201565},
	{"ZIOR", 4, 179771},
	{"ZIOP", 4, 253172},
	{"ZIONSVILLE", 10, 99531},
	{"ZIONS", 5, 185652},
	{"ZIONISTS", 8, 100125},
	{"ZIONIST", 7, 60407},
	{"ZIONISM", 7, 70576},
	{"ZIOL", 4, 219938},
	{"ZIOF", 4, 166453},
	{"ZIOC", 4, 145082},
	{"ZIOB", 4, 237962},
	{"ZINW", 4, 157893},
	{"ZINV", 4, 219939},
	{"ZINTA", 5, 173952},
	{"ZINSSER", 7, 243875},
	{"ZINR", 4, 194205},
	{"ZINP", 4, 200547},
	{"ZINOVIEV", 8, 235662},
	{"ZINNIAS", 7, 199337},
	{"ZINNIA", 6, 141748},
	{"ZINNI", 5, 175569},
	{"ZINNER", 6, 227649},
	{"ZINMAN", 6, 210728},
	{"ZINM", 4, 185091},
	{"ZINL", 4, 237963},
	{"ZINKLE", 6, 66967},
	{"ZINK", 4, 111620},
	{"ZINJ", 4, 258522},
	{"ZINIO", 5, 193211},
	{"ZINIK", 5, 218963},
	{"ZINGY", 5, 119164},
	{"ZINGIBER", 8, 246232},
	{"ZINGERS", 7, 261510},
	{"ZINGER", 6, 135825},
	{"ZING", 4, 95181},
	{"ZINFANDEL", 9, 80603},
	{"ZINESTER", 8, 230515},
	{"ZINES", 5, 61636},
	{"ZINEDINE", 8, 227578},
	{"ZINDEL", 6, 239784},
	{"ZINDAGI", 7, 211509},
	{"ZINDA", 5, 175120},
	{"ZINCO", 5, 234096},
	{"ZINC", 4, 35241},
	{"ZINB", 4, 199346},
	{"ZIMU", 4, 158041},
	{"ZIMS", 4, 258523},
	{"ZIMR", 4, 249108},
	{"ZIMP", 4, 214213},
	{"ZIMO", 4, 178414},
	{"ZIMMERMANN", 10, 79728},
	{"ZIMMERMAN", 9, 53483},
	{"ZIMMERLI", 8, 223980},
	{"ZIMMER", 6, 56556},
	{"ZIMM", 4, 233412},
	{"ZIMI", 4, 128387},
	{"ZIME", 4, 216448},
	{"ZIMBRA", 6, 140743},
	{"ZIMBALIST", 9, 209838},
	{"ZIMBABWEANS", 11, 139393},
	{"ZIMBABWEAN", 10, 92913},
	{"ZIMBABWE", 8, 28311},
	{"ZIMBABAWE", 9, 228606},
	{"ZIMB", 4, 53822},
	{"ZIMAGE", 6, 230394},
	{"ZIMA", 4, 149303},
	{"ZILY", 4, 188128},
	{"ZILW", 4, 104092},
	{"ZILVER", 6, 170228},
	{"ZILT", 4, 110368},
	{"ZILS", 4, 84867},
	{"ZILR", 4, 187026},
	{"ZILPHA", 6, 221137},
	{"ZILP", 4, 182633},
	{"ZILOG", 5, 137529},
	{"ZILO", 4, 134228},
	{"ZILN", 4, 240725},
	{"ZILM", 4, 198347},
	{"ZILLIONS", 8, 149081},
	{"ZILLION", 7, 61615},
	{"ZILLER", 6, 199930},
	{"ZILLAPEDIA", 10, 149843},
	{"ZILLAH", 6, 170299},
	{"ZILLA", 5, 97370},
	{"ZILKER", 6, 217781},
	{"ZILINA", 6, 257755},
	{"ZILI", 4, 47201},
	{"ZILH", 4, 139632},
	{"ZILF", 4, 170090},
	{"ZILERI", 6, 257673},
	{"ZILE", 4, 206507},
	{"ZILDJIAN", 8, 92602},
	{"ZILD", 4, 178848},
	{"ZILCH", 5, 147907},
	{"ZILC", 4, 135286},
	{"ZILB", 4, 139795},
	{"ZILA", 4, 232019},
	{"ZIKS", 4, 176457},
	{"ZIKR", 4, 220433},
	{"ZIKI", 4, 216251},
	{"ZIKE", 4, 253874},
	{"ZIJN", 4, 64605},
	{"ZIJLSTRA", 8, 237804},
	{"ZIJE", 4, 228702},
	{"ZIJA", 4, 223525},
	{"ZIHUATANEJO", 11, 122361},
	{"ZIGZAG", 6, 88889},
	{"ZIGZ", 4, 127377},
	{"ZIGW", 4, 214024},
	{"ZIGU", 4, 254590},
	{"ZIGT", 4, 250100},
	{"ZIGS", 4, 227196},
	{"ZIGR", 4, 235477},
	{"ZIGO", 4, 184351},
	{"ZIGLER", 6, 257232},
	{"ZIGLAR", 6, 122934},
	{"ZIGI", 4, 180314},
	{"ZIGH", 4, 195395},
	{"ZIGGY", 5, 74828},
	{"ZIGGURAT", 8, 214301},
	{"ZIGG", 4, 115066},
	{"ZIGE", 4, 82266},
	{"ZIGBEE", 6, 125170},
	{"ZIGB", 4, 238485},
	{"ZIFO", 4, 217700},
	{"ZIFI", 4, 222161},
	{"ZIFF", 4, 42073},
	{"ZIFA", 4, 216855},
	{"ZIEW", 4, 125947},
	{"ZIERING", 7, 204117},
	{"ZIEP", 4, 189675},
	{"ZIEMBA", 6, 174749},
	{"ZIEMAN", 6, 253256},
	{"ZIEM", 4, 142560},
	{"ZIELONA", 7, 218524},
	{"ZIELINSKI", 9, 147385},
	{"ZIEL", 4, 127758},
	{"ZIEKENHUIS", 10, 252754},
	{"ZIEK", 4, 160176},
	{"ZIEHEN", 6, 177240},
	{"ZIEGLER", 7, 72320},
	{"ZIEGFELD", 8, 171758},
	{"ZIEFERT", 7, 208629},
	{"ZIEF", 4, 194341},
	{"ZIED", 4, 115183},
	{"ZIEC", 4, 145674},
	{"ZIEB", 4, 147646},
	{"ZIDOVUDINE", 10, 109938},
	{"ZIDO", 4, 221687},
	{"ZIDI", 4, 155489},
	{"ZIDERGIRL", 9, 153303},
	{"ZIDANE", 6, 118857},
	{"ZIDA", 4, 179799},
	{"ZICO", 4, 221185},
	{"ZICK", 4, 208891},
	{"ZICH", 4, 136770},
	{"ZICAM", 5, 210338},
	{"ZICA", 4, 137728},
	{"ZIBO", 4, 241248},
	{"ZIBE", 4, 226224},
	{"ZIBA", 4, 248910},
	{"ZIAW", 4, 203113},
	{"ZIAU", 4, 189936},
	{"ZIATECH", 7, 176524},
	{"ZIAR", 4, 154962},
	{"ZIAK", 4, 254591},
	{"ZIAGEN", 6, 240946},
	{"ZIAG", 4, 236722},
	{"ZIAD", 4, 175965},
	{"ZIAB", 4, 203970},
	{"ZHUZ", 4, 253875},
	{"ZHUT", 4, 245432},
	{"ZHUS", 4, 195396},
	{"ZHURNAL", 7, 185166},
	{"ZHUR", 4, 200010},
	{"ZHUO", 4, 246853},
	{"ZHUN", 4, 222162},
	{"ZHUMELL", 7, 163712},
	{"ZHUKOV", 6, 200485},
	{"ZHUHAI", 6, 117726},
	{"ZHUG", 4, 129836},
	{"ZHUANG", 6, 115160},
	{"ZHUAN", 5, 242220},
	{"ZHUA", 4, 125337},
	{"ZHOU", 4, 55958},
	{"ZHOP", 4, 256329},
	{"ZHONKA", 6, 261313},
	{"ZHONGWEN", 8, 189780},
	{"ZHONGSHAN", 9, 106245},
	{"ZHONGHUA", 8, 159538},
	{"ZHONGGUO", 8, 161475},
	{"ZHONG", 5, 81946},
	{"ZHOM", 4, 210291},
	{"ZHOL", 4, 206620},
	{"ZHO", 3, 2134},
	{"ZHNY", 4, 177168},
	{"ZHKO", 4, 209677},
	{"ZHIVAGO", 7, 139975},
	{"ZHIV", 4, 242993},
	{"ZHIRINOVSKY", 11, 218616},
	{"ZHIR", 4, 210096},
	{"ZHIM", 4, 184228},
	{"ZHIL", 4, 158424},
	{"ZHIK", 4, 204131},
	{"ZHIG", 4, 203613},
	{"ZHEW", 4, 253876},
	{"ZHEV", 4, 243893},
	{"ZHER", 4, 143361},
	{"ZHENJIANG", 9, 251732},
	{"ZHENGZHOU", 9, 152788},
	{"ZHENG", 5, 67446},
	{"ZHEL", 4, 166363},
	{"ZHEJIANG", 8, 54929},
	{"ZHEJ", 4, 172870},
	{"ZHDA", 4, 224187},
	{"ZHAV", 4, 123663},
	{"ZHARK", 5, 214999},
	{"ZHAR", 4, 107371},
	{"ZHAOXING", 8, 213194},
	{"ZHAOQING", 8, 212106},
	{"ZHAOPIN", 7, 102229},
	{"ZHANGJIAGANG", 12, 199459},
	{"ZHANG", 5, 39237},
	{"ZHAM", 4, 253877},
	{"ZHAL", 4, 177169},
	{"ZHAK", 4, 149447},
	{"ZHAG", 4, 236723},
	{"ZHAD", 4, 72076},
	{"ZHAB", 4, 243308},
	{"ZGZ", 3, 214984},
	{"ZGY", 3, 108696},
	{"ZGW", 3, 111407},
	{"ZGV", 3, 208381},
	{"ZGUJ", 4, 259361},
	{"ZGUI", 4, 187457},
	{"ZGU", 3, 36873},
	{"ZGRO", 4, 145571},
	{"ZGRE", 4, 187860},
	{"ZGRA", 4, 163834},
	{"ZGR", 3, 9735},
	{"ZGP", 3, 113672},
	{"ZGOV", 4, 235478},
	{"ZGOT", 4, 158513},
	{"ZGO", 3, 28363},
	{"ZGM", 3, 58436},
	{"ZGL", 3, 45396},
	{"ZGIV", 4, 242437},
	{"ZGIB", 4, 208698},
	{"ZGI", 3, 35354},
	{"ZGG", 3, 140083},
	{"ZGF", 3, 122411},
	{"ZGET", 4, 179660},
	{"ZGER", 4, 60831},
	{"ZGEN", 4, 239852},
	{"ZGE", 3, 3122},
	{"ZGD", 3, 135567},
	{"ZGB", 3, 103750},
	{"ZGAV", 4, 184968},
	{"ZGAR", 4, 239032},
	{"ZGAN", 4, 261188},
	{"ZGAL", 4, 194961},
	{"ZGA", 3, 9985},
	{"ZFZ", 3, 187233},
	{"ZFY", 3, 141794},
	{"ZFX", 3, 141142},
	{"ZFV", 3, 160448},
	{"ZFUS", 4, 209678},
	{"ZFUN", 4, 249109},
	{"ZFU", 3, 38529},
	{"ZFSY", 4, 238486},
	{"ZFRO", 4, 106951},
	{"ZFRE", 4, 178415},
	{"ZFRA", 4, 245433},
	{"ZFR", 3, 8479},
	{"ZFOU", 4, 154058},
	{"ZFOL", 4, 196604},
	{"ZFO", 3, 4651},
	{"ZFM", 3, 48598},
	{"ZFL", 3, 40736},
	{"ZFK", 3, 179146},
	{"ZFISH", 5, 214680},
	{"ZFIR", 4, 170343},
	{"ZFIN", 4, 216838},
	{"ZFIL", 4, 243309},
	{"ZFIG", 4, 237964},
	{"ZFIE", 4, 187861},
	{"ZFI", 3, 8351},
	{"ZFG", 3, 172120},
	{"ZFF", 3, 134162},
	{"ZFES", 4, 115501},
	{"ZFER", 4, 200178},
	{"ZFEL", 4, 144765},
	{"ZFE", 3, 7313},
	{"ZFD", 3, 131456},
	{"ZFC", 3, 220865},
	{"ZFB", 3, 153330},
	{"ZFAN", 4, 211992},
	{"ZFAM", 4, 164007},
	{"ZFAI", 4, 148673},
	{"ZFAC", 4, 210869},
	{"ZEZI", 4, 215243},
	{"ZEYO", 4, 84669},
	{"ZEYNEP", 6, 240967},
	{"ZEYAD", 5, 229193},
	{"ZEXP", 4, 163318},
	{"ZEXI", 4, 217937},
	{"ZEWS", 4, 94696},
	{"ZEWO", 4, 121277},
	{"ZEWI", 4, 61581},
	{"ZEWH", 4, 70214},
	{"ZEWE", 4, 104066},
	{"ZEWA", 4, 71300},
	{"ZEVON", 5, 116063},
	{"ZEVE", 4, 120642},
	{"ZEVA", 4, 156746},
	{"ZEUTHEN", 7, 191153},
	{"ZEUS", 4, 53551},
	{"ZEUP", 4, 140764},
	{"ZEUN", 4, 147314},
	{"ZEUGMA", 6, 250722},
	{"ZETW", 4, 230580},
	{"ZETTERBERG", 10, 237835},
	{"ZETTEL", 6, 199632},
	{"ZETR", 4, 139546},
	{"ZETIA", 5, 174790},
	{"ZETH", 4, 28949},
	{"ZETEX", 5, 203247},
	{"ZETEC", 5, 108588},
	{"ZETASIZER", 9, 245917},
	{"ZETAFAX", 7, 238673},
	{"ZETADOCS", 8, 258623},
	{"ZESZ", 4, 259640},
	{"ZESY", 4, 201566},
	{"ZESW", 4, 77071},
	{"ZESV", 4, 201909},
	{"ZESU", 4, 107632},
	{"ZESTY", 5, 114833},
	{"ZESTRIL", 7, 152971},
	{"ZESTRA", 6, 215526},
	{"ZESR", 4, 127850},
	{"ZESP", 4, 92603},
	{"ZESM", 4, 94878},
	{"ZESL", 4, 139462},
	{"ZESK", 4, 193046},
	{"ZESJ", 4, 252477},
	{"ZESG", 4, 173720},
	{"ZESF", 4, 83912},
	{"ZESD", 4, 133986},
	{"ZESC", 4, 86299},
	{"ZESB", 4, 112343},
	{"ZERZ", 4, 257387},
	{"ZERW", 4, 76477},
	{"ZERV", 4, 219940},
	{"ZERUBBABEL", 10, 238543},
	{"ZERU", 4, 146689},
	{"ZERT", 4, 76566},
	{"ZERS", 4, 38988},
	{"ZERP", 4, 79754},
	{"ZEROTH", 6, 169671},
	{"ZEROS", 5, 57926},
	{"ZEROPAID", 8, 155539},
	{"ZEROMANCER", 10, 127185},
	{"ZEROING", 7, 140445},
	{"ZEROES", 6, 90514},
	{"ZEROED", 6, 134367},
	{"ZERODEGREES", 11, 43109},
	{"ZEROCONF", 8, 223500},
	{"ZERO", 4, 4060},
	{"ZERNIKE", 7, 247422},
	{"ZERMATT", 7, 90210},
	{"ZERM", 4, 96550},
	{"ZERL", 4, 47970},
	{"ZERK", 4, 152918},
	{"ZERJ", 4, 198505},
	{"ZERIT", 5, 216849},
	{"ZERH", 4, 105713},
	{"ZERG", 4, 130955},
	{"ZERF", 4, 95690},
	{"ZERE", 4, 77706},
	{"ZERD", 4, 103035},
	{"ZERC", 4, 93653},
	{"ZERBISIAS", 9, 197062},
	{"ZERBE", 5, 225668},
	{"ZERB", 4, 61227},
	{"ZEQU", 4, 187172},
	{"ZEPU", 4, 189010},
	{"ZEPS", 4, 183115},
	{"ZEPR", 4, 98543},
	{"ZEPPO", 5, 259104},
	{"ZEPPLIN", 7, 142987},
	{"ZEPPELINS", 9, 247938},
	{"ZEPPELIN", 8, 41755},
	{"ZEPP", 4, 138737},
	{"ZEPO", 4, 104790},
	{"ZEPL", 4, 140615},
	{"ZEPI", 4, 136669},
	{"ZEPHYRUS", 8, 242421},
	{"ZEPHYRS", 7, 213035},
	{"ZEPHYRHILLS", 11, 132917},
	{"ZEPHYR", 6, 55642},
	{"ZEPHANIAH", 9, 65285},
	{"ZEPH", 4, 211732},
	{"ZEPEDA", 6, 200470},
	{"ZEPE", 4, 124341},
	{"ZEPA", 4, 102726},
	{"ZEOV", 4, 153391},
	{"ZEOU", 4, 106176},
	{"ZEOR", 4, 91056},
	{"ZEOP", 4, 203274},
	{"ZEOLITES", 8, 134942},
	{"ZEOLITE", 7, 100347},
	{"ZEOF", 4, 40365},
	{"ZEOB", 4, 239033},
	{"ZENY", 4, 245709},
	{"ZENWORKS", 8, 132261},
	{"ZENWALK", 7, 192461},
	{"ZENW", 4, 79976},
	{"ZENV", 4, 150965},
	{"ZENU", 4, 159638},
	{"ZENTURI", 7, 170387},
	{"ZENTRUM", 7, 98443},
	{"ZENTRALE", 8, 227618},
	{"ZENTRALBLATT", 12, 176829},
	{"ZENTRALBL", 9, 192298},
	{"ZENSONIC", 8, 203795},
	{"ZENR", 4, 85091},
	{"ZENP", 4, 76030},
	{"ZENON", 5, 101780},
	{"ZENOBIA", 7, 210151},
	{"ZENM", 4, 83978},
	{"ZENL", 4, 101289},
	{"ZENJ", 4, 142048},
	{"ZENITH", 6, 45845},
	{"ZENIT", 5, 103648},
	{"ZENICA", 6, 250640},
	{"ZENIA", 5, 186446},
	{"ZENGER", 6, 220044},
	{"ZENG", 4, 103434},
	{"ZENF", 4, 85027},
	{"ZENER", 5, 110941},
	{"ZENEGRA", 7, 139659},
	{"ZENECA", 6, 163095},
	{"ZENDO", 5, 253497},
	{"ZENDER", 6, 184922},
	{"ZENDA", 5, 188972},
	{"ZEND", 4, 57986},
	{"ZENCUDO", 7, 121697},
	{"ZENC", 4, 74602},
	{"ZENB", 4, 72667},
	{"ZENAWI", 6, 243823},
	{"ZENAS", 5, 223933},
	{"ZENAIDA", 7, 242807},
	{"ZEMY", 4, 151100},
	{"ZEMU", 4, 165996},
	{"ZEMS", 4, 222628},
	{"ZEMP", 4, 247231},
	{"ZEMLYA", 6, 252657},
	{"ZEML", 4, 236724},
	{"ZEMIN", 5, 102865},
	{"ZEMI", 4, 114482},
	{"ZEMECKIS", 8, 151677},
	{"ZEME", 4, 59911},
	{"ZEMBLA", 6, 187901},
	{"ZEMB", 4, 212202},
	{"ZEMANOVA", 8, 109487},
	{"ZEMAN", 5, 144566},
	{"ZELW", 4, 108064},
	{"ZELS", 4, 93200},
	{"ZELR", 4, 232088},
	{"ZELP", 4, 217060},
	{"ZELO", 4, 112371},
	{"ZELNORM", 7, 205006},
	{"ZELN", 4, 173255},
	{"ZELMAN", 6, 227808},
	{"ZELMA", 5, 235580},
	{"ZELM", 4, 149448},
	{"ZELLWEGER", 9, 88771},
	{"ZELLNER", 7, 206534},
	{"ZELLERS", 7, 175100},
	{"ZELLERBACH", 10, 256997},
	{"ZELLER", 6, 108265},
	{"ZELLA", 5, 211665},
	{"ZELL", 4, 78875},
	{"ZELJKO", 6, 140440},
	{"ZELINSKY", 8, 245408},
	{"ZELIG", 5, 183822},
	{"ZELIENOPLE", 10, 201213},
	{"ZELI", 4, 85218},
	{"ZELH", 4, 163033},
	{"ZELG", 4, 231310},
	{"ZELF", 4, 128738},
	{"ZELENKA", 7, 212174},
	{"ZELDMAN", 7, 121641},
	{"ZELDERS", 7, 191352},
	{"ZELDA", 5, 42012},
	{"ZELD", 4, 98099},
	{"ZELCO", 5, 159124},
	{"ZELC", 4, 179871},
	{"ZELB", 4, 152919},
	{"ZELAZNY", 7, 168472},
	{"ZELAYA", 6, 258102},
	{"ZELANDA", 7, 251563},
	{"ZELAND", 6, 165647},
	{"ZELA", 4, 73467},
	{"ZEKW", 4, 259641},
	{"ZEKS", 4, 214596},
	{"ZEKO", 4, 205186},
	{"ZEKI", 4, 244944},
	{"ZEKER", 5, 239458},
	{"ZEKE", 4, 89235},
	{"ZEKA", 4, 166981},
	{"ZEJU", 4, 178046},
	{"ZEJO", 4, 240445},
	{"ZEJE", 4, 219282},
	{"ZEJ", 3, 29125},
	{"ZEITZ", 5, 257202},
	{"ZEITUNG", 7, 92415},
	{"ZEITSCHRIFTEN", 13, 159221},
	{"ZEITSCHRIFT", 11, 84492},
	{"ZEITRAUM", 8, 229318},
	{"ZEITNER", 7, 191899},
	{"ZEITLIN", 7, 173240},
	{"ZEITLER", 7, 259022},
	{"ZEITGEIST", 9, 66640},
	{"ZEITEN", 6, 203204},
	{"ZEIST", 5, 221313},
	{"ZEISS", 5, 61843},
	{"ZEIR", 4, 168883},
	{"ZEIM", 4, 180076},
	{"ZEILENGA", 8, 186176},
	{"ZEILE", 5, 183964},
	{"ZEIGT", 5, 177736},
	{"ZEIGLER", 7, 119408},
	{"ZEIGER", 6, 174121},
	{"ZEIGEN", 6, 101806},
	{"ZEIGEFREUDIG", 12, 194063},
	{"ZEIGE", 5, 138645},
	{"ZEIF", 4, 185092},
	{"ZEIDLER", 7, 239008},
	{"ZEICHEN", 7, 149900},
	{"ZEIC", 4, 246923},
	{"ZEHU", 4, 244795},
	{"ZEHR", 4, 204271},
	{"ZEHNDER", 7, 156495},
	{"ZEGU", 4, 259267},
	{"ZEGR", 4, 161122},
	{"ZEGO", 4, 88126},
	{"ZEGNA", 5, 93407},
	{"ZEGL", 4, 243607},
	{"ZEGI", 4, 197417},
	{"ZEGGEN", 6, 257248},
	{"ZEGERS", 6, 253414},
	{"ZEGE", 4, 154188},
	{"ZEGA", 4, 160328},
	{"ZEFU", 4, 171281},
	{"ZEFR", 4, 94849},
	{"ZEFO", 4, 57623},
	{"ZEFL", 4, 223985},
	{"ZEFI", 4, 98560},
	{"ZEFFIRELLI", 10, 214309},
	{"ZEFE", 4, 179442},
	{"ZEFAL", 5, 180555},
	{"ZEFA", 4, 161444},
	{"ZEEX", 4, 158863},
	{"ZEEW", 4, 254213},
	{"ZEEV", 4, 137040},
	{"ZEEUW", 5, 255483},
	{"ZEETV", 5, 258136},
	{"ZEESHAN", 7, 233581},
	{"ZEESE", 5, 260763},
	{"ZEER", 4, 173598},
	{"ZEEMAN", 6, 151120},
	{"ZEEM", 4, 190066},
	{"ZEELAND", 7, 94055},
	{"ZEEL", 4, 122810},
	{"ZEEKS", 5, 219779},
	{"ZEEK", 4, 206982},
	{"ZEEF", 4, 248808},
	{"ZEED", 4, 244796},
	{"ZEEBRUGGE", 9, 170962},
	{"ZEEBERG", 7, 246807},
	{"ZEDZ", 4, 192484},
	{"ZEDY", 4, 137895},
	{"ZEDW", 4, 50564},
	{"ZEDV", 4, 78800},
	{"ZEDU", 4, 72153},
	{"ZEDT", 4, 29870},
	{"ZEDS", 4, 46155},
	{"ZEDR", 4, 60276},
	{"ZEDQ", 4, 211443},
	{"ZEDP", 4, 51530},
	{"ZEDONG", 6, 139036},
	{"ZEDO", 4, 50706},
	{"ZEDN", 4, 78035},
	{"ZEDM", 4, 55512},
	{"ZEDL", 4, 68118},
	{"ZEDK", 4, 129635},
	{"ZEDJ", 4, 121278},
	{"ZEDILLO", 7, 205678},
	{"ZEDI", 4, 38910},
	{"ZEDH", 4, 50593},
	{"ZEDG", 4, 76031},
	{"ZEDF", 4, 43589},
	{"ZEDEKIAH", 8, 205805},
	{"ZEDE", 4, 58317},
	{"ZEDD", 4, 231752},
	{"ZEDC", 4, 46338},
	{"ZEDB", 4, 35583},
	{"ZEDA", 4, 32826},
	{"ZECU", 4, 216040},
	{"ZECT", 4, 207919},
	{"ZECR", 4, 164808},
	{"ZECO", 4, 73337},
	{"ZECL", 4, 171953},
	{"ZECK", 4, 210536},
	{"ZECI", 4, 156049},
	{"ZECHEEZIE", 9, 211715},
	{"ZECHARIAH", 9, 61248},
	{"ZECH", 4, 157030},
	{"ZECE", 4, 202570},
	{"ZEBY", 4, 132102},
	{"ZEBULUN", 7, 244055},
	{"ZEBULON", 7, 125845},
	{"ZEBU", 4, 255469},
	{"ZEBRAS", 6, 104427},
	{"ZEBRAHEAD", 9, 151153},
	{"ZEBRAFISH", 9, 98113},
	{"ZEBRACLUB", 9, 160291},
	{"ZEBRA", 5, 42951},
	{"ZEBR", 4, 87522},
	{"ZEBL", 4, 187726},
	{"ZEBI", 4, 183006},
	{"ZEBEDEE", 7, 169779},
	{"ZEBE", 4, 93443},
	{"ZEBALLOS", 8, 215592},
	{"ZEAXANTHIN", 10, 175346},
	{"ZEAW", 4, 170439},
	{"ZEAV", 4, 256652},
	{"ZEAU", 4, 176764},
	{"ZEARCH", 6, 160160},
	{"ZEAR", 4, 100249},
	{"ZEAP", 4, 133814},
	{"ZEAM", 4, 140524},
	{"ZEALOUSLY", 9, 157403},
	{"ZEALOUS", 7, 86571},
	{"ZEALOTS", 7, 92558},
	{"ZEALOTRY", 8, 206354},
	{"ZEALOT", 6, 94432},
	{"ZEALANDS", 8, 203224},
	{"ZEALANDNIUENORFOLK", 18, 103912},
	{"ZEALANDERS", 10, 85678},
	{"ZEALANDER", 9, 136742},
	{"ZEALAND", 7, 3076},
	{"ZEAL", 4, 60001},
	{"ZEAG", 4, 99218},
	{"ZEAF", 4, 141095},
	{"ZEAD", 4, 141780},
	{"ZEAC", 4, 110445},
	{"ZEAB", 4, 84693},
	{"ZDY", 3, 88668},
	{"ZDX", 3, 95977},
	{"ZDW", 3, 81504},
	{"ZDV", 3, 142175},
	{"ZDUR", 4, 120811},
	{"ZDU", 3, 29927},
	{"ZDRU", 4, 249431},
	{"ZDRO", 4, 208494},
	{"ZDRIVE", 6, 146906},
	{"ZDRA", 4, 247232},
	{"ZDR", 3, 32277},
	{"ZDP", 3, 182260},
	{"ZDOW", 4, 260440},
	{"ZDOU", 4, 226966},
	{"ZDOE", 4, 159639},
	{"ZDO", 3, 8827},
	{"ZDNET", 5, 28137},
	{"ZDNE", 4, 208911},
	{"ZDM", 3, 104949},
	{"ZDL", 3, 103234},
	{"ZDK", 3, 147237},
	{"ZDJECIA", 7, 210957},
	{"ZDJ", 3, 105527},
	{"ZDIS", 4, 145920},
	{"ZDIR", 4, 206270},
	{"ZDIE", 4, 184847},
	{"ZDID", 4, 119258},
	{"ZDI", 3, 6351},
	{"ZDG", 3, 110698},
	{"ZDF", 3, 153060},
	{"ZDEV", 4, 215244},
	{"ZDES", 4, 149188},
	{"ZDER", 4, 231311},
	{"ZDEP", 4, 239321},
	{"ZDENKA", 6, 144386},
	{"ZDENEK", 6, 134708},
	{"ZDEN", 4, 162696},
	{"ZDEM", 4, 214025},
	{"ZDEL", 4, 139305},
	{"ZDEF", 4, 193935},
	{"ZDEC", 4, 142882},
	{"ZDEA", 4, 210870},
	{"ZDB", 3, 237399},
	{"ZDAT", 4, 212203},
	{"ZDAS", 4, 170700},
	{"ZDAN", 4, 162532},
	{"ZDAM", 4, 217477},
	{"ZDAI", 4, 237965},
	{"ZDAA", 4, 255637},
	{"ZCZY", 4, 259268},
	{"ZCZE", 4, 149379},
	{"ZCZC", 4, 180630},
	{"ZCZ", 3, 30864},
	{"ZCY", 3, 78716},
	{"ZCV", 3, 132800},
	{"ZCUT", 4, 261559},
	{"ZCU", 3, 37790},
	{"ZCRI", 4, 198061},
	{"ZCREENSAVERS", 12, 235914},
	{"ZCRE", 4, 193773},
	{"ZCP", 3, 70876},
	{"ZCOVER", 6, 206694},
	{"ZCOU", 4, 114208},
	{"ZCOR", 4, 177475},
	{"ZCONFIG", 7, 157712},
	{"ZCON", 4, 93900},
	{"ZCOM", 4, 209093},
	{"ZCOL", 4, 181121},
	{"ZCOA", 4, 196923},
	{"ZCO", 3, 2763},
	{"ZCM", 3, 189888},
	{"ZCLU", 4, 175919},
	{"ZCLASS", 6, 247859},
	{"ZCLA", 4, 139155},
	{"ZCL", 3, 29060},
	{"ZCK", 3, 134163},
	{"ZCJ", 3, 196833},
	{"ZCIT", 4, 216645},
	{"ZCIN", 4, 259196},
	{"ZCIENCE", 7, 234143},
	{"ZCHO", 4, 234879},
	{"ZCHI", 4, 194813},
	{"ZCHE", 4, 206832},
	{"ZCHA", 4, 118801},
	{"ZCH", 3, 8260},
	{"ZCG", 3, 214985},
	{"ZCF", 3, 100097},
	{"ZCEN", 4, 218407},
	{"ZCD", 3, 89255},
	{"ZCB", 3, 116138},
	{"ZCATALOG", 8, 173963},
	{"ZCAT", 4, 198408},
	{"ZCAS", 4, 202387},
	{"ZCAP", 4, 229222},
	{"ZCAN", 4, 95171},
	{"ZCAM", 4, 134514},
	{"ZCAL", 4, 129334},
	{"ZCA", 3, 3199},
	{"ZBZ", 3, 132801},
	{"ZBY", 3, 33766},
	{"ZBV", 3, 135568},
	{"ZBUT", 4, 101018},
	{"ZBUR", 4, 89865},
	{"ZBUL", 4, 183234},
	{"ZBU", 3, 4293},
	{"ZBRY", 4, 199679},
	{"ZBRUSH", 6, 137556},
	{"ZBRO", 4, 149860},
	{"ZBRI", 4, 215034},
	{"ZBRE", 4, 254592},
	{"ZBRA", 4, 217938},
	{"ZBR", 3, 9636},
	{"ZBP", 3, 121439},
	{"ZBOY", 4, 240446},
	{"ZBOW", 4, 239853},
	{"ZBOU", 4, 246321},
	{"ZBOT", 4, 194206},
	{"ZBOR", 4, 150482},
	{"ZBOO", 4, 243608},
	{"ZBOL", 4, 76047},
	{"ZBOARD", 6, 149113},
	{"ZBO", 3, 3560},
	{"ZBM", 3, 106123},
	{"ZBLU", 4, 229979},
	{"ZBL", 3, 219118},
	{"ZBK", 3, 191877},
	{"ZBJ", 3, 175468},
	{"ZBIGNIEW", 8, 117604},
	{"ZBIG", 4, 212858},
	{"ZBG", 3, 196834},
	{"ZBF", 3, 121440},
	{"ZBET", 4, 253528},
	{"ZBER", 4, 119060},
	{"ZBEL", 4, 186374},
	{"ZBEK", 4, 81956},
	{"ZBEI", 4, 228459},
	{"ZBEG", 4, 153912},
	{"ZBEF", 4, 196291},
	{"ZBEC", 4, 116694},
	{"ZBEA", 4, 198348},
	{"ZBE", 3, 2837},
	{"ZBD", 3, 124474},
	{"ZBB", 3, 85681},
	{"ZBAT", 4, 242994},
	{"ZBAS", 4, 174660},
	{"ZBAN", 4, 90395},
	{"ZBAL", 4, 139204},
	{"ZBAC", 4, 157044},
	{"ZAZZLE", 6, 130938},
	{"ZAZZ", 4, 211444},
	{"ZAZIE", 5, 211425},
	{"ZAZI", 4, 209485},
	{"ZAZEN", 5, 173874},
	{"ZAZE", 4, 200365},
	{"ZAZA", 4, 161352},
	{"ZAYED", 5, 118042},
	{"ZAYE", 4, 176505},
	{"ZAYD", 4, 261713},
	{"ZAYAS", 5, 226582},
	{"ZAYA", 4, 181456},
	{"ZAXWERKS", 8, 255888},
	{"ZAWYA", 5, 167758},
	{"ZAWODNY", 7, 115064},
	{"ZAWO", 4, 194661},
	{"ZAWINUL", 7, 244584},
	{"ZAWI", 4, 112922},
	{"ZAWH", 4, 101873},
	{"ZAWE", 4, 168619},
	{"ZAWAHRI", 7, 122470},
	{"ZAWAHIRI", 8, 103743},
	{"ZAWADZKI", 8, 254894},
	{"ZAWA", 4, 67117},
	{"ZAVOD", 5, 237753},
	{"ZAVO", 4, 209486},
	{"ZAVI", 4, 130163},
	{"ZAVENTEM", 8, 184013},
	{"ZAVE", 4, 175920},
	{"ZAVALA", 6, 126346},
	{"ZAVA", 4, 138168},
	{"ZAV", 3, 7431},
	{"ZAUS", 4, 199018},
	{"ZAURUS", 6, 89982},
	{"ZAUN", 4, 221067},
	{"ZAUBERFLOTE", 11, 233614},
	{"ZAU", 3, 9518},
	{"ZATZ", 4, 235449},
	{"ZATTEVRIENDEN", 13, 227107},
	{"ZATR", 4, 201058},
	{"ZATOICHI", 8, 128576},
	{"ZATL", 4, 219941},
	{"ZATIONS", 7, 165103},
	{"ZATION", 6, 111743},
	{"ZATI", 4, 4055},
	{"ZATHURA", 7, 87207},
	{"ZATERDAG", 8, 141768},
	{"ZATCH", 5, 142594},
	{"ZASW", 4, 157601},
	{"ZASUKHIN", 8, 225063},
	{"ZASU", 4, 186270},
	{"ZASTAVA", 7, 259727},
	{"ZASSHI", 6, 125663},
	{"ZASSENHAUS", 10, 235592},
	{"ZASR", 4, 246322},
	{"ZASP", 4, 137972},
	{"ZASM", 4, 191630},
	{"ZASL", 4, 189011},
	{"ZASK", 4, 183844},
	{"ZASF", 4, 197900},
	{"ZASD", 4, 240447},
	{"ZASC", 4, 146926},
	{"ZASB", 4, 195086},
	{"ZARZUELA", 8, 253257},
	{"ZARW", 4, 146626},
	{"ZARU", 4, 104436},
	{"ZARS", 4, 90899},
	{"ZARQAWI", 7, 71908},
	{"ZARQ", 4, 186896},
	{"ZARP", 4, 219494},
	{"ZARO", 4, 258292},
	{"ZARN", 4, 163835},
	{"ZARM", 4, 182063},
	{"ZARLINK", 7, 157349},
	{"ZARL", 4, 244797},
	{"ZARKO", 5, 247110},
	{"ZARK", 4, 203796},
	{"ZARISKI", 7, 229117},
	{"ZARINA", 6, 156656},
	{"ZARIA", 5, 256295},
	{"ZARI", 4, 193520},
	{"ZARH", 4, 176978},
	{"ZARG", 4, 167060},
	{"ZARF", 4, 246924},
	{"ZARETSKII", 9, 123044},
	{"ZAREMBA", 7, 243958},
	{"ZARE", 4, 256062},
	{"ZARDOZ", 6, 140736},
	{"ZARD", 4, 36027},
	{"ZARC", 4, 172684},
	{"ZARATHUSTRA", 11, 123785},
	{"ZARATE", 6, 207459},
	{"ZARAH", 5, 168605},
	{"ZARAGOZA", 8, 70509},
	{"ZARA", 4, 77903},
	{"ZAPU", 4, 204649},
	{"ZAPTHINK", 8, 156789},
	{"ZAPTEL", 6, 159242},
	{"ZAPS", 4, 175166},
	{"ZAPRUDER", 8, 246195},
	{"ZAPR", 4, 137044},
	{"ZAPPY", 5, 251244},
	{"ZAPPOS", 6, 62108},
	{"ZAPPING", 7, 141187},
	{"ZAPPERS", 7, 254907},
	{"ZAPPER", 6, 91550},
	{"ZAPPED", 6, 135776},
	{"ZAPPA", 5, 58994},
	{"ZAPP", 4, 128117},
	{"ZAPOTEC", 7, 201178},
	{"ZAPOROZHYE", 10, 217848},
	{"ZAPO", 4, 127305},
	{"ZAPL", 4, 186760},
	{"ZAPIRO", 6, 178721},
	{"ZAPI", 4, 169617},
	{"ZAPHOD", 6, 132908},
	{"ZAPH", 4, 226715},
	{"ZAPF", 4, 93113},
	{"ZAPE", 4, 234288},
	{"ZAPATOS", 7, 183911},
	{"ZAPATISTAS", 10, 131932},
	{"ZAPATISTA", 9, 108825},
	{"ZAPATERO", 8, 156939},
	{"ZAPATA", 6, 88384},
	{"ZAPACHY", 7, 255552},
	{"ZAPA", 4, 84401},
	{"ZAOUI", 5, 238686},
	{"ZAOU", 4, 250801},
	{"ZAOR", 4, 169262},
	{"ZAOF", 4, 132225},
	{"ZANZIE", 6, 213507},
	{"ZANZIBAR", 8, 56886},
	{"ZANZ", 4, 148674},
	{"ZANY", 4, 92756},
	{"ZANW", 4, 160647},
	{"ZANUSSI", 7, 62083},
	{"ZANUCK", 6, 221738},
	{"ZANU", 4, 109511},
	{"ZANTREX", 7, 136531},
	{"ZANTE", 5, 84615},
	{"ZANTAC", 6, 109162},
	{"ZANSKAR", 7, 247394},
	{"ZANR", 4, 248146},
	{"ZANP", 4, 201059},
	{"ZANOTTI", 7, 158407},
	{"ZANONI", 6, 260673},
	{"ZANON", 5, 256437},
	{"ZANNA", 5, 248977},
	{"ZANM", 4, 254919},
	{"ZANL", 4, 252823},
	{"ZANJ", 4, 231312},
	{"ZANGO", 5, 197522},
	{"ZANG", 4, 130712},
	{"ZANF", 4, 253173},
	{"ZANETTI", 7, 172641},
	{"ZANESVILLE", 10, 96079},
	{"ZANDVOORT", 9, 182584},
	{"ZANDT", 5, 88147},
	{"ZANDER", 6, 88709},
	{"ZANDBERGEN", 10, 220419},
	{"ZAND", 4, 103125},
	{"ZANC", 4, 121248},
	{"ZANB", 4, 202571},
	{"ZANAX", 5, 145942},
	{"ZANARDI", 7, 219380},
	{"ZANAMIVIR", 9, 225475},
	{"ZANAFLEX", 8, 86125},
	{"ZAMW", 4, 257772},
	{"ZAMU", 4, 179081},
	{"ZAMS", 4, 192204},
	{"ZAMP", 4, 181122},
	{"ZAMORA", 6, 93191},
	{"ZAMO", 4, 89700},
	{"ZAMMIT", 6, 206063},
	{"ZAMM", 4, 185741},
	{"ZAMIR", 5, 209864},
	{"ZAMI", 4, 185346},
	{"ZAME", 4, 143665},
	{"ZAMBRANO", 8, 137800},
	{"ZAMBONI", 7, 117904},
	{"ZAMBON", 6, 259024},
	{"ZAMBOANGA", 9, 125864},
	{"ZAMBIAN", 7, 80132},
	{"ZAMBIA", 6, 31275},
	{"ZAMBEZI", 7, 73955},
	{"ZAMB", 4, 60568},
	{"ZAMAWIAM", 8, 233023},
	{"ZAMAN", 5, 108632},
	{"ZAMALEK", 7, 237798},
	{"ZAMA", 4, 194033},
	{"ZALW", 4, 239034},
	{"ZALU", 4, 235200},
	{"ZALT", 4, 189398},
	{"ZALS", 4, 89176},
	{"ZALP", 4, 261189},
	{"ZALMAY", 6, 236469},
	{"ZALMAN", 6, 67327},
	{"ZALL", 4, 119166},
	{"ZALK", 4, 261560},
	{"ZALI", 4, 103036},
	{"ZALEWSKI", 8, 179629},
	{"ZALESKI", 7, 194863},
	{"ZALES", 5, 96750},
	{"ZALE", 4, 172248},
	{"ZALD", 4, 155847},
	{"ZALC", 4, 216449},
	{"ZALB", 4, 202572},
	{"ZALAMAN", 7, 243680},
	{"ZAKYNTHOS", 9, 89203},
	{"ZAKW", 4, 169809},
	{"ZAKUPY", 6, 235070},
	{"ZAKT", 4, 202388},
	{"ZAKR", 4, 245735},
	{"ZAKOPANE", 8, 119846},
	{"ZAKON", 5, 232034},
	{"ZAKO", 4, 166902},
	{"ZAKK", 4, 115420},
	{"ZAKIR", 5, 175726},
	{"ZAKIM", 5, 172407},
	{"ZAKI", 4, 138150},
	{"ZAKHAROV", 8, 209381},
	{"ZAKH", 4, 74090},
	{"ZAKEN", 5, 191135},
	{"ZAKE", 4, 238187},
	{"ZAKAT", 5, 133465},
	{"ZAKARIA", 7, 135422},
	{"ZAKAH", 5, 248080},
	{"ZAKA", 4, 76893},
	{"ZAJO", 4, 259269},
	{"ZAJAC", 5, 160860},
	{"ZAJA", 4, 190769},
	{"ZAIW", 4, 187727},
	{"ZAITSEV", 7, 163184},
	{"ZAITCEV", 7, 255488},
	{"ZAIRE", 5, 47246},
	{"ZAIR", 4, 115470},
	{"ZAINO", 5, 256894},
	{"ZAINAB", 6, 215636},
	{"ZAIM", 4, 222849},
	{"ZAIL", 4, 255977},
	{"ZAIDI", 5, 174116},
	{"ZAID", 4, 149816},
	{"ZAIC", 4, 245736},
	{"ZAIBATSU", 8, 241982},
	{"ZAIB", 4, 210871},
	{"ZAHU", 4, 144074},
	{"ZAHRA", 5, 126736},
	{"ZAHR", 4, 170164},
	{"ZAHLUNG", 7, 222904},
	{"ZAHLEN", 6, 180109},
	{"ZAHL", 4, 180797},
	{"ZAHIR", 5, 145452},
	{"ZAHID", 5, 164720},
	{"ZAHEER", 6, 170784},
	{"ZAHARA", 6, 192975},
	{"ZAHAR", 5, 217053},
	{"ZAGU", 4, 215245},
	{"ZAGS", 4, 181881},
	{"ZAGREB", 6, 60337},
	{"ZAGR", 4, 93451},
	{"ZAGORA", 6, 121746},
	{"ZAGH", 4, 104240},
	{"ZAGE", 4, 170344},
	{"ZAGATO", 6, 255453},
	{"ZAGAT", 5, 110883},
	{"ZAGA", 4, 78929},
	{"ZAFR", 4, 144137},
	{"ZAFON", 5, 244404},
	{"ZAFO", 4, 118146},
	{"ZAFIRA", 6, 122315},
	{"ZAFF", 4, 170701},
	{"ZAFE", 4, 208291},
	{"ZAFAR", 5, 150644},
	{"ZAFA", 4, 135984},
	{"ZAENTZ", 6, 255330},
	{"ZADW", 4, 255278},
	{"ZADU", 4, 224402},
	{"ZADS", 4, 227197},
	{"ZADR", 4, 206833},
	{"ZADOK", 5, 165906},
	{"ZADO", 4, 131272},
	{"ZADM", 4, 223059},
	{"ZADINA", 6, 162941},
	{"ZADIE", 5, 161878},
	{"ZADI", 4, 118719},
	{"ZADEH", 5, 162199},
	{"ZADD", 4, 135239},
	{"ZADAR", 5, 129322},
	{"ZACT", 4, 189937},
	{"ZACS", 4, 194493},
	{"ZACR", 4, 166625},
	{"ZACO", 4, 110885},
	{"ZACL", 4, 224403},
	{"ZACKY", 5, 205647},
	{"ZACKS", 5, 83804},
	{"ZACKARY", 7, 209582},
	{"ZACK", 4, 55075},
	{"ZACI", 4, 130121},
	{"ZACHRY", 6, 239166},
	{"ZACHERY", 7, 143908},
	{"ZACHARY", 7, 59130},
	{"ZACHARIAS", 9, 112939},
	{"ZACHARIAH", 9, 122115},
	{"ZACHARIA", 8, 245299},
	{"ZACH", 4, 49082},
	{"ZACE", 4, 190482},
	{"ZACD", 4, 217254},
	{"ZACCHIROLI", 10, 244691},
	{"ZACCHAEUS", 9, 247069},
	{"ZACC", 4, 131694},
	{"ZACATECAS", 9, 142778},
	{"ZACARIAS", 8, 152561},
	{"ZACA", 4, 109626},
	{"ZABY", 4, 243894},
	{"ZABU", 4, 119902},
	{"ZABRISKIE", 9, 186823},
	{"ZABR", 4, 144075},
	{"ZABO", 4, 98192},
	{"ZABL", 4, 57508},
	{"ZABIELA", 7, 248075},
	{"ZABI", 4, 143458},
	{"ZABEL", 5, 147749},
	{"ZABE", 4, 39166},
	{"ZABAWEB", 7, 98332},
	{"ZABASEARCH", 10, 91004},
	{"ZABA", 4, 190961},
	{"ZAAR", 4, 100959},
	{"ZAAP", 4, 255638},
	{"ZAANDAM", 7, 167555},
	{"ZAAF", 4, 228216},
	{"ZAADZSTERS", 10, 240807},
	{"ZAADZ", 5, 124883},
	{"ZAAD", 4, 198483},
	{"ZAAC", 4, 218870},
	{"ZAA", 3, 1879},
	{"Z", 1, 40},
	{"YZY", 3, 47233},
	{"YZX", 3, 93580},
	{"YZW", 3, 45329},
	{"YZV", 3, 80355},
	{"YZU", 3, 36839},
	{"YZST", 4, 109876},
	{"YZS", 3, 28304},
	{"YZP", 3, 52681},
	{"YZOR", 4, 198506},
	{"YZOO", 4, 140661},
	{"YZON", 4, 89115},
	{"YZOM", 4, 206834},
	{"YZO", 3, 4897},
	{"YZM", 3, 51818},
	{"YZL", 3, 59173},
	{"YZK", 3, 75304},
	{"YZJ", 3, 123413},
	{"YZIT", 4, 194342},
	{"YZIP", 4, 196770},
	{"YZIN", 4, 75031},
	{"YZIM", 4, 162291},
	{"YZIE", 4, 243895},
	{"YZI", 3, 3600},
	{"YZHA", 4, 178646},
	{"YZH", 3, 33234},
	{"YZGA", 4, 250802},
	{"YZG", 3, 48882},
	{"YZF", 3, 110942},
	{"YZEW", 4, 120006},
	{"YZET", 4, 102038},
	{"YZES", 4, 109668},
	{"YZERMAN", 7, 180734},
	{"YZER", 4, 80325},
	{"YZEP", 4, 230277},
	{"YZEN", 4, 162122},
	{"YZEL", 4, 205555},
	{"YZEI", 4, 174139},
	{"YZEH", 4, 242161},
	{"YZEE", 4, 241582},
	{"YZED", 4, 62565},
	{"YZEC", 4, 251770},
	{"YZEA", 4, 130403},
	{"YZE", 3, 1537},
	{"YZD", 3, 57889},
	{"YZC", 3, 54598},
	{"YZB", 3, 47699},
	{"YZAT", 4, 212204},
	{"YZAR", 4, 204132},
	{"YZAP", 4, 234562},
	{"YZAN", 4, 56327},
	{"YZAM", 4, 182167},
	{"YZAK", 4, 241009},
	{"YZAC", 4, 142788},
	{"YZA", 3, 2070},
	{"YYZ", 3, 129511},
	{"YYYYMMDDHHMMSST", 15, 195804},
	{"YYYYMMDD", 8, 144620},
	{"YYYY", 4, 47343},
	{"YYY", 3, 100077},
	{"YYX", 3, 105528},
	{"YYW", 3, 73948},
	{"YYVSP", 5, 166280},
	{"YYV", 3, 57890},
	{"YYUR", 4, 227452},
	{"YYUN", 4, 245107},
	{"YYUM", 4, 216252},
	{"YYUK", 4, 216646},
	{"YYUB", 4, 232361},
	{"YYU", 3, 7510},
	{"YYTEXT", 6, 190658},
	{"YYR", 3, 55025},
	{"YYP", 3, 62928},
	{"YYOU", 4, 8310},
	{"YYOS", 4, 188701},
	{"YYOR", 4, 148217},
	{"YYON", 4, 255978},
	{"YYOG", 4, 199844},
	{"YYO", 3, 832},
	{"YYNN", 4, 160514},
	{"YYMMDD", 6, 127946},
	{"YYMC", 4, 172685},
	{"YYM", 3, 39555},
	{"YYLEX", 5, 234395},
	{"YYL", 3, 86543},
	{"YYK", 3, 61116},
	{"YYIP", 4, 227453},
	{"YYIE", 4, 110524},
	{"YYID", 4, 165328},
	{"YYI", 3, 7150},
	{"YYG", 3, 93581},
	{"YYF", 3, 87733},
	{"YYET", 4, 68510},
	{"YYES", 4, 69858},
	{"YYEL", 4, 95796},
	{"YYEA", 4, 8045},
	{"YYE", 3, 814},
	{"YYD", 3, 77499},
	{"YYC", 3, 208574},
	{"YYB", 3, 67696},
	{"YYAV", 4, 234563},
	{"YYAT", 4, 185860},
	{"YYAS", 4, 176979},
	{"YYAR", 4, 59672},
	{"YYAP", 4, 246323},
	{"YYAN", 4, 97463},
	{"YYAM", 4, 136910},
	{"YYAL", 4, 187728},
	{"YYAK", 4, 234289},
	{"YYAH", 4, 108462},
	{"YYAF", 4, 203275},
	{"YYAD", 4, 128623},
	{"YYAC", 4, 186118},
	{"YYAA", 4, 236725},
	{"YYA", 3, 1645},
	{"YXZ", 3, 108697},
	{"YXX", 3, 48628},
	{"YXW", 3, 49883},
	{"YXV", 3, 56774},
	{"YXU", 3, 57774},
	{"YXRA", 4, 241292},
	{"YXR", 3, 47609},
	{"YXQ", 3, 166065},
	{"YXP", 3, 50258},
	{"YXME", 4, 153772},
	{"YXM", 3, 34874},
	{"YXL", 3, 61645},
	{"YXK", 3, 125579},
	{"YXJ", 3, 108033},
	{"YXIS", 4, 243310},
	{"YXIN", 4, 209281},
	{"YXII", 4, 177932},
	{"YXIA", 4, 137045},
	{"YXI", 3, 8657},
	{"YXG", 3, 81711},
	{"YXF", 3, 55990},
	{"YXEN", 4, 236074},
	{"YXD", 3, 62052},
	{"YXC", 3, 53957},
	{"YXBOOM", 6, 201217},
	{"YXBO", 4, 254593},
	{"YXB", 3, 47357},
	{"YXAN", 4, 159015},
	{"YXA", 3, 33826},
	{"YWZ", 3, 120420},
	{"YWYO", 4, 254214},
	{"YWYN", 4, 203435},
	{"YWY", 3, 32465},
	{"YWX", 3, 100619},
	{"YWWW", 4, 163139},
	{"YWW", 3, 34523},
	{"YWV", 3, 49674},
	{"YWU", 3, 38385},
	{"YWRO", 4, 49986},
	{"YWRI", 4, 40031},
	{"YWRE", 4, 86199},
	{"YWRA", 4, 95995},
	{"YWR", 3, 1048},
	{"YWQ", 3, 108698},
	{"YWP", 3, 50955},
	{"YWOW", 4, 186271},
	{"YWOV", 4, 215861},
	{"YWOU", 4, 6454},
	{"YWOR", 4, 7554},
	{"YWOO", 4, 34455},
	{"YWON", 4, 34943},
	{"YWOM", 4, 49409},
	{"YWOL", 4, 82471},
	{"YWOK", 4, 185608},
	{"YWOE", 4, 200732},
	{"YWO", 3, 714},
	{"YWM", 3, 46811},
	{"YWL", 3, 55636},
	{"YWK", 3, 64849},
	{"YWJ", 3, 74107},
	{"YWIZ", 4, 160961},
	{"YWIV", 4, 204650},
	{"YWIT", 4, 2964},
	{"YWIS", 4, 53433},
	{"YWIR", 4, 90379},
	{"YWIP", 4, 113529},
	{"YWIN", 4, 35389},
	{"YWIM", 4, 243609},
	{"YWIL", 4, 5031},
	{"YWIK", 4, 203436},
	{"YWII", 4, 245108},
	{"YWIG", 4, 132387},
	{"YWIF", 4, 51539},
	{"YWIE", 4, 143202},
	{"YWID", 4, 50653},
	{"YWIC", 4, 107034},
	{"YWI", 3, 698},
	{"YWHY", 4, 62641},
	{"YWHOO", 5, 177660},
	{"YWHO", 4, 8364},
	{"YWHI", 4, 6234},
	{"YWHE", 4, 4512},
	{"YWHA", 4, 33837},
	{"YWH", 3, 704},
	{"YWF", 3, 58437},
	{"YWEW", 4, 57544},
	{"YWEV", 4, 90007},
	{"YWEU", 4, 191062},
	{"YWET", 4, 81941},
	{"YWES", 4, 44770},
	{"YWER", 4, 3727},
	{"YWEP", 4, 105968},
	{"YWEO", 4, 187729},
	{"YWEN", 4, 39728},
	{"YWEM", 4, 97806},
	{"YWEL", 4, 29630},
	{"YWEK", 4, 140525},
	{"YWEJ", 4, 194662},
	{"YWEI", 4, 43959},
	{"YWEH", 4, 57587},
	{"YWEG", 4, 106800},
	{"YWEF", 4, 120427},
	{"YWEE", 4, 43658},
	{"YWED", 4, 50303},
	{"YWEC", 4, 60916},
	{"YWEB", 4, 59030},
	{"YWEA", 4, 36705},
	{"YWE", 3, 703},
	{"YWD", 3, 56944},
	{"YWCA", 4, 79121},
	{"YWC", 3, 34761},
	{"YWB", 3, 48044},
	{"YWAY", 4, 9899},
	{"YWAX", 4, 185352},
	{"YWAV", 4, 94725},
	{"YWAT", 4, 40803},
	{"YWAS", 4, 2978},
	{"YWARE", 5, 202817},
	{"YWAR", 4, 37130},
	{"YWAN", 4, 28073},
	{"YWAM", 4, 166797},
	{"YWAL", 4, 39932},
	{"YWAK", 4, 104563},
	{"YWAI", 4, 60037},
	{"YWAG", 4, 82132},
	{"YWAD", 4, 122383},
	{"YWAC", 4, 169538},
	{"YWA", 3, 699},
	{"YVZ", 3, 130208},
	{"YVY", 3, 50917},
	{"YVX", 3, 141795},
	{"YVW", 3, 57054},
	{"YVV", 3, 72837},
	{"YVUL", 4, 90866},
	{"YVU", 3, 8231},
	{"YVST", 4, 216647},
	{"YVSS", 4, 239322},
	{"YVS", 3, 7976},
	{"YVR", 3, 164607},
	{"YVQ", 3, 249999},
	{"YVP", 3, 48715},
	{"YVOY", 4, 201394},
	{"YVOW", 4, 144729},
	{"YVOT", 4, 41625},
	{"YVOR", 4, 219283},
	{"YVONNE", 6, 52240},
	{"YVON", 4, 127341},
	{"YVOL", 4, 50342},
	{"YVOI", 4, 69768},
	{"YVOD", 4, 248147},
	{"YVOC", 4, 98930},
	{"YVM", 3, 52961},
	{"YVLA", 4, 166982},
	{"YVL", 3, 39061},
	{"YVK", 3, 87734},
	{"YVJ", 3, 88352},
	{"YVIV", 4, 147315},
	{"YVIT", 4, 114335},
	{"YVIS", 4, 43473},
	{"YVIR", 4, 60217},
	{"YVIP", 4, 215862},
	{"YVIO", 4, 64380},
	{"YVIN", 4, 82096},
	{"YVIL", 4, 51230},
	{"YVIK", 4, 156391},
	{"YVII", 4, 88903},
	{"YVIG", 4, 147415},
	{"YVIE", 4, 50554},
	{"YVID", 4, 73626},
	{"YVIC", 4, 55605},
	{"YVIB", 4, 141323},
	{"YVIA", 4, 65386},
	{"YVI", 3, 848},
	{"YVG", 3, 71967},
	{"YVF", 3, 53302},
	{"YVEW", 4, 131476},
	{"YVETTE", 6, 73834},
	{"YVET", 4, 61462},
	{"YVES", 4, 45450},
	{"YVER", 4, 36851},
	{"YVEP", 4, 111960},
	{"YVEO", 4, 176554},
	{"YVEN", 4, 61928},
	{"YVEM", 4, 119116},
	{"YVELINES", 8, 206204},
	{"YVEL", 4, 88181},
	{"YVEK", 4, 231066},
	{"YVEJ", 4, 207920},
	{"YVEI", 4, 125154},
	{"YVEH", 4, 57023},
	{"YVEG", 4, 61655},
	{"YVEF", 4, 140424},
	{"YVEE", 4, 101799},
	{"YVED", 4, 88659},
	{"YVEC", 4, 97291},
	{"YVEB", 4, 57764},
	{"YVEA", 4, 80184},
	{"YVD", 3, 66597},
	{"YVC", 3, 46298},
	{"YVB", 3, 64420},
	{"YVAU", 4, 127956},
	{"YVAT", 4, 222629},
	{"YVAS", 4, 116217},
	{"YVAR", 4, 48919},
	{"YVAP", 4, 218163},
	{"YVAN", 4, 149732},
	{"YVAM", 4, 181340},
	{"YVAL", 4, 43052},
	{"YVAI", 4, 170440},
	{"YVAG", 4, 139731},
	{"YVAC", 4, 84943},
	{"YVA", 3, 1001},
	{"YUZU", 4, 249717},
	{"YUZT", 4, 261190},
	{"YUZ", 3, 28310},
	{"YUYU", 4, 216982},
	{"YUYAO", 5, 205056},
	{"YUX", 3, 66083},
	{"YUWI", 4, 256653},
	{"YUWH", 4, 200906},
	{"YUWE", 4, 125397},
	{"YUWA", 4, 156890},
	{"YUW", 3, 8138},
	{"YUVRAJ", 6, 204024},
	{"YUVR", 4, 198208},
	{"YUVAL", 5, 146221},
	{"YUVA", 4, 254472},
	{"YUV", 3, 119593},
	{"YUUZ", 4, 188417},
	{"YUUS", 4, 184229},
	{"YUUKI", 5, 253810},
	{"YUUK", 4, 235479},
	{"YUUGI", 5, 162100},
	{"YUU", 3, 159301},
	{"YUTT", 4, 122384},
	{"YUTO", 4, 153913},
	{"YUTI", 4, 79488},
	{"YUTH", 4, 142096},
	{"YUTE", 4, 227707},
	{"YUTC", 4, 226225},
	{"YUTAKA", 6, 125145},
	{"YUT", 3, 2617},
	{"YUSW", 4, 182751},
	{"YUSUKE", 6, 173179},
	{"YUSUFALI", 8, 195742},
	{"YUSUF", 5, 71814},
	{"YUSU", 4, 59318},
	{"YUST", 4, 112451},
	{"YUSS", 4, 105636},
	{"YUSR", 4, 166903},
	{"YUSP", 4, 136374},
	{"YUSO", 4, 142698},
	{"YUSN", 4, 176245},
	{"YUSM", 4, 129047},
	{"YUSL", 4, 225983},
	{"YUSI", 4, 42996},
	{"YUSHCHENKO", 10, 88557},
	{"YUSH", 4, 81727},
	{"YUSG", 4, 197570},
	{"YUSF", 4, 145572},
	{"YUSEF", 5, 168930},
	{"YUSE", 4, 9007},
	{"YUSD", 4, 144193},
	{"YUSC", 4, 107715},
	{"YUSB", 4, 130814},
	{"YURY", 4, 138650},
	{"YURV", 4, 148788},
	{"YURU", 4, 245434},
	{"YURTS", 5, 220273},
	{"YURT", 4, 145757},
	{"YUROK", 5, 240270},
	{"YURMAN", 6, 136621},
	{"YURL", 4, 186622},
	{"YURIY", 5, 161426},
	{"YURIKO", 6, 218265},
	{"YURI", 4, 60889},
	{"YURG", 4, 95380},
	{"YURE", 4, 138256},
	{"YURB", 4, 99854},
	{"YURASOV", 7, 91979},
	{"YURA", 4, 212673},
	{"YUR", 3, 147297},
	{"YUQ", 3, 60115},
	{"YUPW", 4, 109455},
	{"YUPU", 4, 192910},
	{"YUPT", 4, 51812},
	{"YUPS", 4, 63713},
	{"YUPR", 4, 130339},
	{"YUPPIES", 7, 127299},
	{"YUPPIE", 6, 105815},
	{"YUPP", 4, 100881},
	{"YUPO", 4, 66744},
	{"YUPN", 4, 260441},
	{"YUPM", 4, 209887},
	{"YUPL", 4, 132145},
	{"YUPI", 4, 108440},
	{"YUPH", 4, 124342},
	{"YUPG", 4, 97311},
	{"YUPF", 4, 93635},
	{"YUPE", 4, 226226},
	{"YUPD", 4, 79412},
	{"YUPC", 4, 175619},
	{"YUPB", 4, 110313},
	{"YUPA", 4, 78596},
	{"YUP", 3, 52119},
	{"YUONG", 5, 192757},
	{"YUNW", 4, 105616},
	{"YUNV", 4, 130470},
	{"YUNUS", 5, 154981},
	{"YUNU", 4, 84841},
	{"YUNT", 4, 41320},
	{"YUNS", 4, 56929},
	{"YUNR", 4, 72170},
	{"YUNQUE", 6, 251541},
	{"YUNQ", 4, 237966},
	{"YUNP", 4, 69608},
	{"YUNO", 4, 122942},
	{"YUNNAN", 6, 77344},
	{"YUNN", 4, 91450},
	{"YUNM", 4, 129907},
	{"YUNL", 4, 56862},
	{"YUNK", 4, 75040},
	{"YUNJ", 4, 185997},
	{"YUNIS", 5, 194267},
	{"YUNH", 4, 91546},
	{"YUNG", 4, 69712},
	{"YUNF", 4, 67286},
	{"YUNDI", 5, 248781},
	{"YUND", 4, 31309},
	{"YUNC", 4, 55870},
	{"YUNB", 4, 98445},
	{"YUNA", 4, 91138},
	{"YUMP", 4, 228965},
	{"YUMN", 4, 149638},
	{"YUMMY", 5, 52081},
	{"YUMMI", 5, 181505},
	{"YUMIKO", 6, 207489},
	{"YUMI", 4, 101702},
	{"YUME", 4, 154982},
	{"YUMB", 4, 195689},
	{"YUMA", 4, 55707},
	{"YUM", 3, 45848},
	{"YULT", 4, 96471},
	{"YULIYA", 6, 227919},
	{"YULIN", 5, 254325},
	{"YULIA", 5, 117505},
	{"YULETIDE", 8, 120503},
	{"YULEE", 5, 184004},
	{"YULE", 4, 83169},
	{"YULA", 4, 170345},
	{"YUL", 3, 128776},
	{"YUKY", 4, 183116},
	{"YUKU", 4, 258144},
	{"YUKT", 4, 204320},
	{"YUKS", 4, 204133},
	{"YUKR", 4, 157170},
	{"YUKOS", 5, 97700},
	{"YUKON", 5, 34361},
	{"YUKO", 4, 123535},
	{"YUKIO", 5, 140059},
	{"YUKIKO", 6, 214127},
	{"YUKIHIRO", 8, 169317},
	{"YUKI", 4, 81894},
	{"YUKH", 4, 239323},
	{"YUKAWA", 6, 150519},
	{"YUKATA", 6, 243669},
	{"YUKARI", 6, 216174},
	{"YUKAI", 5, 247436},
	{"YUKA", 4, 166397},
	{"YUK", 3, 96676},
	{"YUJIN", 5, 190035},
	{"YUJI", 4, 132118},
	{"YUJ", 3, 31887},
	{"YUIS", 4, 143823},
	{"YUIN", 4, 160482},
	{"YUICHI", 6, 206326},
	{"YUIC", 4, 174030},
	{"YUHO", 4, 249769},
	{"YUHE", 4, 261561},
	{"YUHA", 4, 137087},
	{"YUGOSLAVIAN", 11, 130056},
	{"YUGOSLAVIA", 10, 35644},
	{"YUGOSLAV", 8, 52135},
	{"YUGO", 4, 78976},
	{"YUGL", 4, 135908},
	{"YUGIOH", 6, 54527},
	{"YUGI", 4, 110077},
	{"YUGA", 4, 165171},
	{"YUG", 3, 159845},
	{"YUFO", 4, 227198},
	{"YUFFIE", 6, 195326},
	{"YUF", 3, 36289},
	{"YUES", 4, 243896},
	{"YUENGLING", 9, 259921},
	{"YUEN", 4, 74202},
	{"YUEH", 4, 197545},
	{"YUEF", 4, 221495},
	{"YUDO", 4, 214214},
	{"YUDKOWSKY", 9, 204716},
	{"YUDIT", 5, 253825},
	{"YUDI", 4, 214809},
	{"YUDHOYONO", 9, 171370},
	{"YUDH", 4, 152791},
	{"YUDEN", 5, 106740},
	{"YUDE", 4, 211993},
	{"YUD", 3, 258475},
	{"YUCO", 4, 182634},
	{"YUCL", 4, 219942},
	{"YUCKY", 5, 130848},
	{"YUCK", 4, 85664},
	{"YUCH", 4, 150336},
	{"YUCCA", 5, 66684},
	{"YUCC", 4, 145464},
	{"YUCATAN", 7, 73752},
	{"YUCAIPA", 7, 130103},
	{"YUC", 3, 4982},
	{"YUBU", 4, 251453},
	{"YUBO", 4, 220794},
	{"YUBI", 4, 153914},
	{"YUBE", 4, 197418},
	{"YUBA", 4, 71404},
	{"YUB", 3, 220319},
	{"YUASA", 5, 107143},
	{"YUAS", 4, 220795},
	{"YUAN", 4, 42627},
	{"YTYR", 4, 140811},
	{"YTYP", 4, 51351},
	{"YTYL", 4, 137321},
	{"YTYI", 4, 160805},
	{"YTYC", 4, 210292},
	{"YTWO", 4, 30003},
	{"YTWI", 4, 62839},
	{"YTWE", 4, 69132},
	{"YTWA", 4, 235201},
	{"YTW", 3, 884},
	{"YTVW", 4, 130261},
	{"YTVT", 4, 231561},
	{"YTVS", 4, 96390},
	{"YTVP", 4, 217939},
	{"YTVM", 4, 255979},
	{"YTVI", 4, 195397},
	{"YTVC", 4, 179443},
	{"YTVA", 4, 155637},
	{"YTUT", 4, 164008},
	{"YTUS", 4, 151167},
	{"YTUR", 4, 38338},
	{"YTUN", 4, 71933},
	{"YTUM", 4, 141324},
	{"YTUL", 4, 145573},
	{"YTUI", 4, 183488},
	{"YTUG", 4, 243311},
	{"YTUE", 4, 71148},
	{"YTUD", 4, 243610},
	{"YTUC", 4, 119186},
	{"YTUB", 4, 121686},
	{"YTU", 3, 1022},
	{"YTTRIUM", 7, 141390},
	{"YTTERBIUM", 9, 220260},
	{"YTSU", 4, 189676},
	{"YTSK", 4, 220363},
	{"YTRY", 4, 45947},
	{"YTRU", 4, 43378},
	{"YTRO", 4, 51426},
	{"YTRI", 4, 36786},
	{"YTRE", 4, 43299},
	{"YTRA", 4, 8385},
	{"YTOZ", 4, 193936},
	{"YTOY", 4, 66296},
	{"YTOX", 4, 123904},
	{"YTOW", 4, 31267},
	{"YTOV", 4, 63604},
	{"YTOU", 4, 36154},
	{"YTOT", 4, 5912},
	{"YTOS", 4, 8028},
	{"YTOR", 4, 29747},
	{"YTOQ", 4, 99739},
	{"YTOP", 4, 9871},
	{"YTOO", 4, 28961},
	{"YTON", 4, 33609},
	{"YTOM", 4, 30110},
	{"YTOL", 4, 33843},
	{"YTOK", 4, 46618},
	{"YTOJ", 4, 57903},
	{"YTOH", 4, 31874},
	{"YTOG", 4, 29660},
	{"YTOF", 4, 34214},
	{"YTOD", 4, 28859},
	{"YTOC", 4, 28702},
	{"YTOB", 4, 9182},
	{"YTOA", 4, 28648},
	{"YTMND", 5, 116973},
	{"YTLE", 4, 150483},
	{"YTKO", 4, 205732},
	{"YTIZ", 4, 159483},
	{"YTIR", 4, 93745},
	{"YTIP", 4, 94927},
	{"YTIM", 4, 8869},
	{"YTIL", 4, 92107},
	{"YTIG", 4, 68664},
	{"YTIF", 4, 246034},
	{"YTID", 4, 162214},
	{"YTIC", 4, 48163},
	{"YTIB", 4, 170981},
	{"YTHY", 4, 174453},
	{"YTHW", 4, 113267},
	{"YTHU", 4, 53883},
	{"YTHR", 4, 7385},
	{"YTHP", 4, 173623},
	{"YTHO", 4, 9563},
	{"YTHM", 4, 45373},
	{"YTHL", 4, 229738},
	{"YTHJ", 4, 250803},
	{"YTHI", 4, 2304},
	{"YTHG", 4, 172055},
	{"YTHF", 4, 172772},
	{"YTHD", 4, 183603},
	{"YTHC", 4, 53026},
	{"YTHB", 4, 121687},
	{"YTHA", 4, 2624},
	{"YTEX", 4, 62687},
	{"YTEW", 4, 176016},
	{"YTEV", 4, 260042},
	{"YTER", 4, 41731},
	{"YTEP", 4, 185742},
	{"YTEM", 4, 60442},
	{"YTEL", 4, 38217},
	{"YTEK", 4, 206271},
	{"YTEG", 4, 171282},
	{"YTEF", 4, 223291},
	{"YTED", 4, 113971},
	{"YTEC", 4, 47429},
	{"YTEB", 4, 183117},
	{"YTEA", 4, 33487},
	{"YTCH", 4, 218636},
	{"YTAY", 4, 85186},
	{"YTAX", 4, 43137},
	{"YTAV", 4, 197901},
	{"YTAU", 4, 85324},
	{"YTAR", 4, 55684},
	{"YTAP", 4, 83589},
	{"YTAM", 4, 93287},
	{"YTAL", 4, 39117},
	{"YTAK", 4, 31729},
	{"YTAG", 4, 108685},
	{"YTAD", 4, 244798},
	{"YTAC", 4, 76306},
	{"YTAB", 4, 81117},
	{"YSZT", 4, 234880},
	{"YSZO", 4, 243611},
	{"YSZE", 4, 221220},
	{"YSZC", 4, 250455},
	{"YSZA", 4, 196605},
	{"YSYS", 4, 43351},
	{"YSYR", 4, 144020},
	{"YSYO", 4, 61426},
	{"YSYN", 4, 76307},
	{"YSYM", 4, 68657},
	{"YSYL", 4, 152135},
	{"YSYE", 4, 93701},
	{"YSYD", 4, 169902},
	{"YSYA", 4, 99449},
	{"YSY", 3, 1049},
	{"YSWU", 4, 225783},
	{"YSWR", 4, 112894},
	{"YSWO", 4, 46553},
	{"YSWI", 4, 35434},
	{"YSWH", 4, 39314},
	{"YSWE", 4, 37209},
	{"YSWA", 4, 42452},
	{"YSW", 3, 789},
	{"YSVO", 4, 88456},
	{"YSVI", 4, 62516},
	{"YSVE", 4, 84294},
	{"YSVA", 4, 95598},
	{"YSV", 3, 1874},
	{"YSUZ", 4, 184352},
	{"YSUV", 4, 232945},
	{"YSUT", 4, 125815},
	{"YSUS", 4, 46573},
	{"YSUR", 4, 35656},
	{"YSUP", 4, 31872},
	{"YSUN", 4, 43469},
	{"YSUM", 4, 56032},
	{"YSUL", 4, 98460},
	{"YSUK", 4, 213210},
	{"YSUI", 4, 62870},
	{"YSUG", 4, 53023},
	{"YSUF", 4, 57700},
	{"YSUE", 4, 105012},
	{"YSUD", 4, 102973},
	{"YSUC", 4, 34158},
	{"YSUB", 4, 41119},
	{"YSUA", 4, 172176},
	{"YSTYRIED", 8, 163387},
	{"YSTY", 4, 57164},
	{"YSTW", 4, 65776},
	{"YSTV", 4, 193774},
	{"YSTU", 4, 32913},
	{"YSTRAD", 6, 251659},
	{"YSTR", 4, 8331},
	{"YSTP", 4, 120209},
	{"YSTORE", 6, 245496},
	{"YSTOD", 5, 128359},
	{"YSTO", 4, 6748},
	{"YSTM", 4, 112735},
	{"YSTL", 4, 122706},
	{"YSTK", 4, 221688},
	{"YSTJ", 4, 120967},
	{"YSTI", 4, 32173},
	{"YSTH", 4, 5802},
	{"YSTG", 4, 180661},
	{"YSTF", 4, 78773},
	{"YSTEMS", 6, 163198},
	{"YSTEM", 5, 124421},
	{"YSTE", 4, 1931},
	{"YSTD", 4, 138019},
	{"YSTC", 4, 100239},
	{"YSTB", 4, 127017},
	{"YSTADEGAU", 9, 243399},
	{"YSTA", 4, 4087},
	{"YSSY", 4, 143666},
	{"YSSW", 4, 112509},
	{"YSSU", 4, 52034},
	{"YSSQ", 4, 193314},
	{"YSSP", 4, 65975},
	{"YSSM", 4, 103759},
	{"YSSL", 4, 113374},
	{"YSSK", 4, 216535},
	{"YSSC", 4, 66294},
	{"YSRY", 4, 257019},
	{"YSRU", 4, 77087},
	{"YSRS", 4, 178172},
	{"YSRO", 4, 63075},
	{"YSRI", 4, 69792},
	{"YSRH", 4, 254920},
	{"YSRE", 4, 37508},
	{"YSRD", 4, 255980},
	{"YSRA", 4, 63594},
	{"YSQU", 4, 52612},
	{"YSQL", 4, 134058},
	{"YSQ", 3, 2266},
	{"YSPY", 4, 179082},
	{"YSPU", 4, 64502},
	{"YSPS", 4, 209888},
	{"YSPR", 4, 36677},
	{"YSPO", 4, 35261},
	{"YSPM", 4, 120454},
	{"YSPL", 4, 48098},
	{"YSPI", 4, 48136},
	{"YSPH", 4, 91422},
	{"YSPE", 4, 28212},
	{"YSPC", 4, 261940},
	{"YSPA", 4, 37174},
	{"YSOY", 4, 119853},
	{"YSOX", 4, 196452},
	{"YSOW", 4, 66075},
	{"YSOV", 4, 72270},
	{"YSOU", 4, 34540},
	{"YSOR", 4, 45212},
	{"YSOP", 4, 57593},
	{"YSON", 4, 30963},
	{"YSOM", 4, 28984},
	{"YSOL", 4, 38655},
	{"YSOK", 4, 184848},
	{"YSOG", 4, 161212},
	{"YSOF", 4, 29683},
	{"YSOD", 4, 104845},
	{"YSOC", 4, 46822},
	{"YSOB", 4, 85081},
	{"YSNY", 4, 180558},
	{"YSNU", 4, 110069},
	{"YSNF", 4, 242714},
	{"YSND", 4, 227454},
	{"YSMY", 4, 116218},
	{"YSMU", 4, 71496},
	{"YSMS", 4, 146627},
	{"YSMR", 4, 112344},
	{"YSMO", 4, 42074},
	{"YSMI", 4, 44429},
	{"YSME", 4, 54179},
	{"YSMD", 4, 246613},
	{"YSMC", 4, 135728},
	{"YSMA", 4, 31722},
	{"YSLY", 4, 197571},
	{"YSLU", 4, 93186},
	{"YSLO", 4, 38977},
	{"YSLI", 4, 40407},
	{"YSLE", 4, 40052},
	{"YSLD", 4, 240726},
	{"YSLA", 4, 36137},
	{"YSKY", 4, 100382},
	{"YSKU", 4, 147711},
	{"YSKR", 4, 189938},
	{"YSKO", 4, 147416},
	{"YSKN", 4, 80294},
	{"YSKI", 4, 45704},
	{"YSKE", 4, 63922},
	{"YSKA", 4, 86593},
	{"YSK", 3, 1171},
	{"YSJU", 4, 76259},
	{"YSJO", 4, 72853},
	{"YSJI", 4, 169990},
	{"YSJE", 4, 106496},
	{"YSJA", 4, 88397},
	{"YSJ", 3, 2022},
	{"YSIZE", 5, 153010},
	{"YSIZ", 4, 69780},
	{"YSIX", 4, 47287},
	{"YSIW", 4, 115847},
	{"YSIV", 4, 158585},
	{"YSIU", 4, 115096},
	{"YSIT", 4, 34098},
	{"YSIR", 4, 74233},
	{"YSIQ", 4, 121307},
	{"YSIP", 4, 138803},
	{"YSIN", 4, 7020},
	{"YSIM", 4, 36070},
	{"YSIL", 4, 61385},
	{"YSIK", 4, 147417},
	{"YSIG", 4, 39441},
	{"YSIF", 4, 86977},
	{"YSIDRO", 6, 122596},
	{"YSID", 4, 40401},
	{"YSIC", 4, 6688},
	{"YSIB", 4, 133176},
	{"YSHY", 4, 115641},
	{"YSHU", 4, 58641},
	{"YSHR", 4, 77852},
	{"YSHOO", 5, 175421},
	{"YSHO", 4, 5246},
	{"YSHE", 4, 6717},
	{"YSHA", 4, 28860},
	{"YSH", 3, 709},
	{"YSGU", 4, 94045},
	{"YSGT", 4, 187990},
	{"YSGR", 4, 59546},
	{"YSGOO", 5, 257487},
	{"YSGOLION", 8, 126393},
	{"YSGOL", 5, 88425},
	{"YSGO", 4, 48564},
	{"YSGL", 4, 129694},
	{"YSGI", 4, 77653},
	{"YSGE", 4, 61543},
	{"YSGA", 4, 50907},
	{"YSFU", 4, 60100},
	{"YSFR", 4, 50566},
	{"YSFO", 4, 38746},
	{"YSFL", 4, 87911},
	{"YSFI", 4, 43831},
	{"YSFE", 4, 65952},
	{"YSFA", 4, 51986},
	{"YSF", 3, 850},
	{"YSEY", 4, 145352},
	{"YSEW", 4, 113081},
	{"YSEV", 4, 38912},
	{"YSEU", 4, 168538},
	{"YSER", 4, 28383},
	{"YSEQ", 4, 103597},
	{"YSEP", 4, 44925},
	{"YSEN", 4, 33452},
	{"YSEM", 4, 65803},
	{"YSEL", 4, 28868},
	{"YSEK", 4, 213799},
	{"YSEG", 4, 87229},
	{"YSEF", 4, 114921},
	{"YSEE", 4, 28957},
	{"YSED", 4, 250980},
	{"YSEC", 4, 35127},
	{"YSEB", 4, 126741},
	{"YSEA", 4, 33589},
	{"YSDY", 4, 247233},
	{"YSDU", 4, 80793},
	{"YSDR", 4, 68564},
	{"YSDO", 4, 51298},
	{"YSDI", 4, 54430},
	{"YSDE", 4, 44096},
	{"YSDA", 4, 61923},
	{"YSD", 3, 952},
	{"YSCY", 4, 244196},
	{"YSCU", 4, 70522},
	{"YSCR", 4, 43965},
	{"YSCO", 4, 30156},
	{"YSCL", 4, 61066},
	{"YSCI", 4, 55755},
	{"YSCE", 4, 55925},
	{"YSCA", 4, 37902},
	{"YSBYTY", 6, 230632},
	{"YSBY", 4, 76366},
	{"YSBU", 4, 45176},
	{"YSBR", 4, 62440},
	{"YSBO", 4, 57035},
	{"YSBL", 4, 86206},
	{"YSBI", 4, 67416},
	{"YSBE", 4, 30747},
	{"YSBA", 4, 50256},
	{"YSAY", 4, 30164},
	{"YSAX", 4, 183235},
	{"YSAW", 4, 42803},
	{"YSAV", 4, 48459},
	{"YSAU", 4, 69461},
	{"YSATIS", 6, 218329},
	{"YSAR", 4, 37222},
	{"YSAP", 4, 59623},
	{"YSAN", 4, 8094},
	{"YSAM", 4, 48744},
	{"YSAL", 4, 39473},
	{"YSAK", 4, 126370},
	{"YSAJ", 4, 234564},
	{"YSAI", 4, 6512},
	{"YSAG", 4, 53288},
	{"YSAF", 4, 40839},
	{"YSAD", 4, 51634},
	{"YSAC", 4, 48827},
	{"YSABEL", 6, 219634},
	{"YSAB", 4, 54658},
	{"YRZ", 3, 71402},
	{"YRYA", 4, 88541},
	{"YRY", 3, 5596},
	{"YRX", 3, 105529},
	{"YRWH", 4, 232946},
	{"YRWA", 4, 210872},
	{"YRW", 3, 35841},
	{"YRUT", 4, 120773},
	{"YRUS", 4, 48389},
	{"YRUR", 4, 104211},
	{"YRUP", 4, 76356},
	{"YRUN", 4, 38754},
	{"YRUM", 4, 97981},
	{"YRUL", 4, 52680},
	{"YRUI", 4, 108304},
	{"YRUG", 4, 129281},
	{"YRUF", 4, 176458},
	{"YRUD", 4, 109415},
	{"YRUB", 4, 92941},
	{"YRU", 3, 899},
	{"YRTO", 4, 164458},
	{"YRTL", 4, 100865},
	{"YRTH", 4, 211255},
	{"YRSW", 4, 236726},
	{"YRST", 4, 163240},
	{"YRSS", 4, 213800},
	{"YRSQ", 4, 47936},
	{"YRSO", 4, 154963},
	{"YRSI", 4, 200548},
	{"YRSH", 4, 133226},
	{"YRSC", 4, 196292},
	{"YRSB", 4, 243612},
	{"YRSA", 4, 135985},
	{"YRS", 3, 281},
	{"YRRH", 4, 133739},
	{"YRRE", 4, 154964},
	{"YRRA", 4, 249432},
	{"YRR", 3, 8883},
	{"YRQ", 3, 149139},
	{"YRP", 3, 37292},
	{"YROY", 4, 73773},
	{"YROX", 4, 190918},
	{"YROW", 4, 96113},
	{"YROV", 4, 143362},
	{"YROU", 4, 46257},
	{"YROT", 4, 71018},
	{"YROS", 4, 51439},
	{"YROR", 4, 212992},
	{"YROP", 4, 137771},
	{"YROO", 4, 44610},
	{"YRON", 4, 51014},
	{"YROM", 4, 55077},
	{"YROL", 4, 40463},
	{"YROK", 4, 256654},
	{"YROI", 4, 103269},
	{"YROH", 4, 209100},
	{"YROG", 4, 79547},
	{"YROF", 4, 145675},
	{"YROE", 4, 162617},
	{"YROD", 4, 63712},
	{"YROC", 4, 51914},
	{"YROB", 4, 46268},
	{"YROA", 4, 44710},
	{"YRNE", 4, 69015},
	{"YRNA", 4, 116194},
	{"YRN", 3, 3622},
	{"YRMI", 4, 208292},
	{"YRMA", 4, 245737},
	{"YRM", 3, 30770},
	{"YRJ", 3, 51819},
	{"YRIZ", 4, 258524},
	{"YRIV", 4, 57173},
	{"YRIT", 4, 92108},
	{"YRIS", 4, 52108},
	{"YRIP", 4, 101815},
	{"YRIO", 4, 116770},
	{"YRIN", 4, 61038},
	{"YRIM", 4, 177476},
	{"YRIL", 4, 79758},
	{"YRIK", 4, 238761},
	{"YRIG", 4, 37255},
	{"YRIF", 4, 125984},
	{"YRIE", 4, 100729},
	{"YRID", 4, 52382},
	{"YRICS", 5, 165495},
	{"YRIB", 4, 155490},
	{"YRIA", 4, 41650},
	{"YRI", 3, 783},
	{"YRHY", 4, 111183},
	{"YRHO", 4, 118824},
	{"YRHI", 4, 181820},
	{"YRHE", 4, 140970},
	{"YRHA", 4, 215035},
	{"YRH", 3, 4995},
	{"YRGY", 4, 87808},
	{"YRG", 3, 6994},
	{"YRF", 3, 36805},
	{"YREZ", 4, 210097},
	{"YREY", 4, 114797},
	{"YREX", 4, 157725},
	{"YREW", 4, 60269},
	{"YREV", 4, 38705},
	{"YREU", 4, 65943},
	{"YRET", 4, 32242},
	{"YRER", 4, 69665},
	{"YREQ", 4, 42433},
	{"YREP", 4, 28283},
	{"YREO", 4, 64522},
	{"YREN", 4, 39186},
	{"YREM", 4, 33830},
	{"YREL", 4, 29039},
	{"YREKA", 5, 131995},
	{"YREK", 4, 120688},
	{"YREJ", 4, 57639},
	{"YREI", 4, 48312},
	{"YREH", 4, 69124},
	{"YREG", 4, 31817},
	{"YREF", 4, 32927},
	{"YREETING", 8, 235652},
	{"YREE", 4, 58421},
	{"YRED", 4, 37997},
	{"YREC", 4, 8425},
	{"YREB", 4, 51534},
	{"YREA", 4, 7619},
	{"YRDW", 4, 156828},
	{"YRDT", 4, 208699},
	{"YRDO", 4, 117509},
	{"YRDI", 4, 165649},
	{"YRDH", 4, 219045},
	{"YRDE", 4, 223526},
	{"YRDD", 4, 224188},
	{"YRDC", 4, 231067},
	{"YRDB", 4, 214597},
	{"YRDA", 4, 125249},
	{"YRD", 3, 230947},
	{"YRCO", 4, 244799},
	{"YRCA", 4, 176364},
	{"YRBS", 4, 250547},
	{"YRBI", 4, 248148},
	{"YRB", 3, 32241},
	{"YRAZ", 4, 173822},
	{"YRAY", 4, 74211},
	{"YRAW", 4, 116750},
	{"YRAVEL", 6, 255203},
	{"YRAV", 4, 117478},
	{"YRAU", 4, 161608},
	{"YRAT", 4, 39859},
	{"YRAS", 4, 96696},
	{"YRAR", 4, 57571},
	{"YRAP", 4, 71441},
	{"YRAO", 4, 255981},
	{"YRANOITCID", 10, 203238},
	{"YRAN", 4, 37591},
	{"YRAM", 4, 49788},
	{"YRAL", 4, 80117},
	{"YRAK", 4, 166122},
	{"YRAJ", 4, 143253},
	{"YRAI", 4, 40183},
	{"YRAH", 4, 126250},
	{"YRAG", 4, 126401},
	{"YRAF", 4, 125558},
	{"YRAE", 4, 189399},
	{"YRAD", 4, 56102},
	{"YRAC", 4, 40036},
	{"YRAB", 4, 98213},
	{"YRAA", 4, 157382},
	{"YR", 2, 280},
	{"YQY", 3, 172121},
	{"YQX", 3, 196835},
	{"YQW", 3, 66364},
	{"YQV", 3, 119527},
	{"YQUR", 4, 245109},
	{"YQUO", 4, 92417},
	{"YQUI", 4, 40542},
	{"YQUEM", 5, 227358},
	{"YQUE", 4, 43804},
	{"YQUA", 4, 47619},
	{"YQU", 3, 934},
	{"YQR", 3, 106124},
	{"YQQ", 3, 137023},
	{"YQP", 3, 95145},
	{"YQM", 3, 93960},
	{"YQL", 3, 108699},
	{"YQK", 3, 196836},
	{"YQJ", 3, 208382},
	{"YQG", 3, 168973},
	{"YQF", 3, 108034},
	{"YQD", 3, 121441},
	{"YQC", 3, 83567},
	{"YPZ", 3, 102155},
	{"YPYT", 4, 149861},
	{"YPYR", 4, 203971},
	{"YPY", 3, 30066},
	{"YPX", 3, 89569},
	{"YPW", 3, 45090},
	{"YPV", 3, 53136},
	{"YPUZ", 4, 181695},
	{"YPUT", 4, 39396},
	{"YPUS", 4, 61806},
	{"YPUR", 4, 45195},
	{"YPUP", 4, 114542},
	{"YPUN", 4, 66143},
	{"YPUM", 4, 111037},
	{"YPUL", 4, 56753},
	{"YPUG", 4, 252824},
	{"YPUF", 4, 220595},
	{"YPUE", 4, 199174},
	{"YPUD", 4, 240448},
	{"YPUC", 4, 178173},
	{"YPUB", 4, 39601},
	{"YPTW", 4, 106154},
	{"YPTU", 4, 134021},
	{"YPTT", 4, 98544},
	{"YPTS", 4, 88660},
	{"YPTR", 4, 212993},
	{"YPTP", 4, 205381},
	{"YPTO", 4, 59639},
	{"YPTM", 4, 203803},
	{"YPTL", 4, 237672},
	{"YPTI", 4, 41905},
	{"YPTH", 4, 97536},
	{"YPTF", 4, 156456},
	{"YPTE", 4, 88912},
	{"YPTD", 4, 218164},
	{"YPTC", 4, 169810},
	{"YPTB", 4, 145574},
	{"YPTA", 4, 70366},
	{"YPSY", 4, 68889},
	{"YPSU", 4, 149189},
	{"YPSO", 4, 130404},
	{"YPSILANTI", 9, 83264},
	{"YPSERV", 6, 179188},
	{"YPSE", 4, 78105},
	{"YPSA", 4, 216041},
	{"YPRY", 4, 214215},
	{"YPRU", 4, 69334},
	{"YPRO", 4, 4109},
	{"YPRI", 4, 31999},
	{"YPRES", 5, 150749},
	{"YPRE", 4, 7887},
	{"YPRA", 4, 45828},
	{"YPQ", 3, 90225},
	{"YPPT", 4, 246925},
	{"YPPP", 4, 260043},
	{"YPPEDIA", 7, 226665},
	{"YPPA", 4, 226967},
	{"YPOYRGOS", 8, 129937},
	{"YPOYRGO", 7, 259129},
	{"YPOYRGEIOY", 10, 244938},
	{"YPOYRGEIO", 9, 228045},
	{"YPOX", 4, 200366},
	{"YPOW", 4, 45335},
	{"YPOV", 4, 163581},
	{"YPOU", 4, 74056},
	{"YPOT", 4, 42997},
	{"YPOS", 4, 152149},
	{"YPOR", 4, 47570},
	{"YPOP", 4, 38472},
	{"YPOO", 4, 54048},
	{"YPON", 4, 85597},
	{"YPOM", 4, 144880},
	{"YPOL", 4, 31630},
	{"YPOK", 4, 115748},
	{"YPOI", 4, 38117},
	{"YPOG", 4, 103824},
	{"YPOE", 4, 91919},
	{"YPOD", 4, 131811},
	{"YPOC", 4, 57333},
	{"YPOA", 4, 190919},
	{"YPNO", 4, 75840},
	{"YPMW", 4, 214810},
	{"YPMT", 4, 120610},
	{"YPMS", 4, 163682},
	{"YPMP", 4, 193473},
	{"YPMO", 4, 186500},
	{"YPMM", 4, 208912},
	{"YPMI", 4, 193170},
	{"YPMF", 4, 197902},
	{"YPME", 4, 144237},
	{"YPMC", 4, 227927},
	{"YPMB", 4, 235202},
	{"YPMA", 4, 127378},
	{"YPM", 3, 249034},
	{"YPLY", 4, 236727},
	{"YPLUS", 5, 250041},
	{"YPLU", 4, 66860},
	{"YPLO", 4, 86997},
	{"YPLI", 4, 209487},
	{"YPLE", 4, 50536},
	{"YPLA", 4, 6020},
	{"YPK", 3, 45907},
	{"YPJ", 3, 58506},
	{"YPIZ", 4, 184849},
	{"YPIX", 4, 154580},
	{"YPIV", 4, 209889},
	{"YPIT", 4, 58372},
	{"YPIS", 4, 115989},
	{"YPIR", 4, 107913},
	{"YPIP", 4, 117349},
	{"YPIO", 4, 112085},
	{"YPIN", 4, 51545},
	{"YPIM", 4, 244197},
	{"YPIL", 4, 75213},
	{"YPIK", 4, 181341},
	{"YPIG", 4, 129282},
	{"YPIF", 4, 137859},
	{"YPIE", 4, 56727},
	{"YPIC", 4, 7608},
	{"YPIA", 4, 118971},
	{"YPI", 3, 780},
	{"YPHY", 4, 62947},
	{"YPHU", 4, 161286},
	{"YPHS", 4, 127613},
	{"YPHR", 4, 154189},
	{"YPHO", 4, 42863},
	{"YPHI", 4, 55139},
	{"YPHE", 4, 78045},
	{"YPHD", 4, 191922},
	{"YPHA", 4, 68928},
	{"YPH", 3, 1004},
	{"YPGA", 4, 256330},
	{"YPG", 3, 147116},
	{"YPF", 3, 178567},
	{"YPEY", 4, 180871},
	{"YPEW", 4, 64443},
	{"YPEV", 4, 139306},
	{"YPEU", 4, 140316},
	{"YPET", 4, 44494},
	{"YPEP", 4, 78144},
	{"YPEO", 4, 7040},
	{"YPEN", 4, 47634},
	{"YPEM", 4, 85443},
	{"YPEL", 4, 74176},
	{"YPEK", 4, 183968},
	{"YPEI", 4, 60323},
	{"YPEH", 4, 104375},
	{"YPEG", 4, 106546},
	{"YPEF", 4, 74234},
	{"YPEE", 4, 79816},
	{"YPED", 4, 56094},
	{"YPEC", 4, 52576},
	{"YPEB", 4, 88500},
	{"YPEA", 4, 46368},
	{"YPDF", 4, 231562},
	{"YPDA", 4, 252478},
	{"YPD", 3, 176935},
	{"YPCS", 4, 250101},
	{"YPCO", 4, 259270},
	{"YPCA", 4, 235203},
	{"YPC", 3, 157769},
	{"YPBPR", 5, 235568},
	{"YPBIND", 6, 203185},
	{"YPB", 3, 37340},
	{"YPAY", 4, 45346},
	{"YPAW", 4, 162951},
	{"YPAV", 4, 102269},
	{"YPAU", 4, 61471},
	{"YPAT", 4, 42599},
	{"YPAS", 4, 36189},
	{"YPARXOYN", 8, 244792},
	{"YPARXEI", 7, 177972},
	{"YPAR", 4, 7902},
	{"YPAP", 4, 70080},
	{"YPAN", 4, 58542},
	{"YPAM", 4, 151780},
	{"YPAL", 4, 56356},
	{"YPAK", 4, 106456},
	{"YPAI", 4, 44638},
	{"YPAG", 4, 64975},
	{"YPAD", 4, 89345},
	{"YPAC", 4, 49895},
	{"YPAB", 4, 231563},
	{"YOYO", 4, 98670},
	{"YOYA", 4, 234290},
	{"YOXY", 4, 208495},
	{"YOXI", 4, 238487},
	{"YOXF", 4, 150543},
	{"YOX", 3, 30148},
	{"YOWO", 4, 245435},
	{"YOWN", 4, 33641},
	{"YOWIE", 5, 250303},
	{"YOWI", 4, 130262},
	{"YOWH", 4, 131943},
	{"YOWERI", 6, 236916},
	{"YOWE", 4, 81422},
	{"YOWA", 4, 131944},
	{"YOVI", 4, 235480},
	{"YOVE", 4, 9716},
	{"YOVA", 4, 142561},
	{"YOV", 3, 868},
	{"YOUZ", 4, 181588},
	{"YOUY", 4, 72543},
	{"YOUW", 4, 4747},
	{"YOUVILLE", 8, 209278},
	{"YOUVE", 5, 82072},
	{"YOUV", 4, 32595},
	{"YOUTUBE", 7, 145513},
	{"YOUTHS", 6, 48987},
	{"YOUTHFULNESS", 12, 210840},
	{"YOUTHFUL", 8, 54971},
	{"YOUTHBUILD", 10, 222082},
	{"YOUTH", 5, 4157},
	{"YOUT", 4, 180275},
	{"YOUSUF", 6, 147609},
	{"YOUSSOU", 7, 166700},
	{"YOUSSEF", 7, 119204},
	{"YOUSKO", 6, 240308},
	{"YOUSIF", 6, 163474},
	{"YOUSENDIT", 9, 239498},
	{"YOUSELF", 7, 169373},
	{"YOUSEFZADEH", 11, 142851},
	{"YOUSEF", 6, 127257},
	{"YOUSE", 5, 155706},
	{"YOUSAVE", 7, 192858},
	{"YOUS", 4, 112031},
	{"YOURSITE", 8, 215593},
	{"YOURSELVES", 10, 47576},
	{"YOURSELFERS", 11, 153871},
	{"YOURSELFER", 10, 171146},
	{"YOURSELF", 8, 2767},
	{"YOURS", 5, 633},
	{"YOURNAME", 8, 196056},
	{"YOURMUSIC", 9, 252720},
	{"YOURISH", 7, 135373},
	{"YOURGUIDE", 9, 108661},
	{"YOURE", 5, 55280},
	{"YOURDON", 7, 245006},
	{"YOURDIRTYMIND", 13, 141404},
	{"YOURBODYNATURALLY", 17, 240691},
	{"YOUR", 4, 632},
	{"YOUQ", 4, 113017},
	{"YOUP", 4, 33613},
	{"YOUO", 4, 39136},
	{"YOUNTVILLE", 10, 123574},
	{"YOUNT", 5, 146063},
	{"YOUNKIN", 7, 252214},
	{"YOUNIS", 6, 128148},
	{"YOUNGTOWN", 9, 211971},
	{"YOUNGSVILLE", 11, 143746},
	{"YOUNGSTOWN", 10, 55195},
	{"YOUNGSTERS", 10, 52976},
	{"YOUNGSTER", 9, 35406},
	{"YOUNGS", 6, 59341},
	{"YOUNGMODELS", 11, 133106},
	{"YOUNGMAN", 8, 127406},
	{"YOUNGISH", 8, 261774},
	{"YOUNGGIRLS", 10, 126783},
	{"YOUNGEST", 8, 42100},
	{"YOUNGER", 7, 9302},
	{"YOUNGE", 6, 166115},
	{"YOUNGBOY", 8, 206715},
	{"YOUNGBLOODZ", 11, 186948},
	{"YOUNGBLOOD", 10, 92926},
	{"YOUNGADVENTUROUS", 16, 205780},
	{"YOUNG", 5, 1148},
	{"YOUNES", 6, 211917},
	{"YOUN", 4, 130465},
	{"YOUMANS", 7, 182145},
	{"YOULL", 5, 70013},
	{"YOUKAI", 6, 214204},
	{"YOUJ", 4, 44644},
	{"YOUIE", 5, 106988},
	{"YOUI", 4, 37529},
	{"YOUH", 4, 5380},
	{"YOUGOV", 6, 242835},
	{"YOUGHAL", 7, 185426},
	{"YOUGER", 6, 148362},
	{"YOUG", 4, 178730},
	{"YOUF", 4, 32237},
	{"YOUD", 4, 122738},
	{"YOUC", 4, 3439},
	{"YOUB", 4, 34073},
	{"YOUA", 4, 4598},
	{"YOU'VE", 6, 694},
	{"YOU'RE", 6, 693},
	{"YOU'LL", 6, 692},
	{"YOU'D", 5, 691},
	{"YOU", 3, 631},
	{"YOTR", 4, 142049},
	{"YOTH", 4, 7804},
	{"YOSW", 4, 125278},
	{"YOSU", 4, 136987},
	{"YOSSI", 5, 116825},
	{"YOSSEF", 6, 235065},
	{"YOSSARIAN", 9, 194450},
	{"YOSP", 4, 198507},
	{"YOSM", 4, 177712},
	{"YOSHKAR", 7, 248637},
	{"YOSHIZAWA", 9, 234156},
	{"YOSHIYUKI", 9, 193827},
	{"YOSHITOSHI", 10, 189502},
	{"YOSHITAKA", 9, 212274},
	{"YOSHIRO", 7, 247721},
	{"YOSHIOKA", 8, 182212},
	{"YOSHIO", 6, 148882},
	{"YOSHINORI", 9, 156453},
	{"YOSHINOBU", 9, 239501},
	{"YOSHINO", 7, 141697},
	{"YOSHIMURA", 9, 117064},
	{"YOSHIMOTO", 9, 188397},
	{"YOSHIMI", 7, 187350},
	{"YOSHIKO", 7, 178501},
	{"YOSHIKI", 7, 202685},
	{"YOSHIKAZU", 9, 246907},
	{"YOSHIKAWA", 9, 143993},
	{"YOSHII", 6, 255331},
	{"YOSHIHIRO", 9, 148019},
	{"YOSHIHIDE", 9, 238363},
	{"YOSHIE", 6, 166943},
	{"YOSHIDA", 7, 77143},
	{"YOSHIAKI", 8, 170573},
	{"YOSHI", 5, 76329},
	{"YOSF", 4, 221221},
	{"YOSEMITE", 8, 48981},
	{"YOSEF", 5, 95799},
	{"YOSC", 4, 119673},
	{"YOSB", 4, 134178},
	{"YORY", 4, 121975},
	{"YORW", 4, 56922},
	{"YORV", 4, 106361},
	{"YORUBA", 6, 89705},
	{"YORU", 4, 183528},
	{"YORT", 4, 43238},
	{"YORS", 4, 41268},
	{"YORR", 4, 62328},
	{"YORQ", 4, 199019},
	{"YORP", 4, 57313},
	{"YORN", 4, 177389},
	{"YORM", 4, 49540},
	{"YORL", 4, 71615},
	{"YORKVILLE", 9, 88698},
	{"YORKUSA", 7, 197537},
	{"YORKTOWN", 8, 66265},
	{"YORKTON", 7, 123891},
	{"YORKSHIRE", 9, 10060},
	{"YORKS", 5, 85079},
	{"YORKNEW", 7, 258494},
	{"YORKIES", 7, 152508},
	{"YORKIE", 6, 79127},
	{"YORKERS", 7, 69421},
	{"YORKER", 6, 50913},
	{"YORKE", 5, 84439},
	{"YORK", 4, 1125},
	{"YORJ", 4, 77509},
	{"YORICK", 6, 154885},
	{"YORI", 4, 135022},
	{"YORH", 4, 65755},
	{"YORG", 4, 41629},
	{"YORF", 4, 62896},
	{"YORE", 4, 108496},
	{"YORD", 4, 43443},
	{"YORC", 4, 48539},
	{"YORBA", 5, 93507},
	{"YORB", 4, 56081},
	{"YORAM", 5, 144847},
	{"YORA", 4, 39557},
	{"YOPY", 4, 174745},
	{"YOPU", 4, 227708},
	{"YOPT", 4, 53535},
	{"YOPR", 4, 158425},
	{"YOPP", 4, 45323},
	{"YOPO", 4, 166215},
	{"YOPI", 4, 54088},
	{"YOPH", 4, 223060},
	{"YOPER", 5, 139602},
	{"YOPE", 4, 33527},
	{"YOPA", 4, 139732},
	{"YOOX", 4, 81427},
	{"YOOR", 4, 178849},
	{"YOOP", 4, 173508},
	{"YOONOO", 6, 150575},
	{"YOONG", 5, 246222},
	{"YOOGLE", 6, 212843},
	{"YOOF", 4, 190067},
	{"YONY", 4, 92297},
	{"YONW", 4, 52450},
	{"YONV", 4, 103145},
	{"YONU", 4, 111131},
	{"YONT", 4, 7655},
	{"YONSEI", 6, 163119},
	{"YONR", 4, 68890},
	{"YONP", 4, 59478},
	{"YONM", 4, 49394},
	{"YONL", 4, 35313},
	{"YONKERS", 7, 72233},
	{"YONKA", 5, 199310},
	{"YONK", 4, 105166},
	{"YONJ", 4, 63686},
	{"YONHAP", 6, 173104},
	{"YONGSAN", 7, 241827},
	{"YONGKANG", 8, 151643},
	{"YONGE", 5, 87300},
	{"YONG", 4, 58668},
	{"YONF", 4, 56218},
	{"YONEZAWA", 8, 254387},
	{"YONEX", 5, 100095},
	{"YONEDA", 6, 222766},
	{"YONDER", 6, 76303},
	{"YOND", 4, 211434},
	{"YONCALLA", 8, 260946},
	{"YONC", 4, 40353},
	{"YONB", 4, 57880},
	{"YONAH", 5, 149548},
	{"YOMO", 4, 162463},
	{"YOMN", 4, 250804},
	{"YOMK", 4, 149257},
	{"YOMIURI", 7, 132212},
	{"YOMI", 4, 183202},
	{"YOMEGA", 6, 261710},
	{"YOME", 4, 245970},
	{"YOLY", 4, 116025},
	{"YOLS", 4, 145520},
	{"YOLO", 4, 80884},
	{"YOLKS", 5, 96448},
	{"YOLK", 4, 83754},
	{"YOLI", 4, 94836},
	{"YOLEN", 5, 143133},
	{"YOLE", 4, 147418},
	{"YOLD", 4, 48589},
	{"YOLANDE", 7, 190308},
	{"YOLANDA", 7, 72688},
	{"YOKU", 4, 130122},
	{"YOKOZUNA", 8, 246595},
	{"YOKOYAMA", 8, 134951},
	{"YOKOTA", 6, 127641},
	{"YOKOSUKA", 8, 137153},
	{"YOKOI", 5, 235359},
	{"YOKOHAMA", 8, 59223},
	{"YOKOGAWA", 8, 133720},
	{"YOKO", 4, 69522},
	{"YOKL", 4, 124156},
	{"YOKES", 5, 137915},
	{"YOKEL", 5, 204995},
	{"YOKED", 5, 184774},
	{"YOKE", 4, 60347},
	{"YOKA", 4, 123441},
	{"YOJIMBO", 7, 119380},
	{"YOJI", 4, 186734},
	{"YOJANA", 6, 240327},
	{"YOJA", 4, 143767},
	{"YOJ", 3, 28889},
	{"YOIL", 4, 83193},
	{"YOICHI", 6, 179314},
	{"YOIC", 4, 234565},
	{"YOHW", 4, 226227},
	{"YOHM", 4, 246926},
	{"YOHKO", 5, 211729},
	{"YOHJI", 5, 97071},
	{"YOHIMBINE", 9, 158675},
	{"YOHIMBE", 7, 104137},
	{"YOHAN", 5, 193245},
	{"YOGYAKARTA", 10, 116326},
	{"YOGY", 4, 240449},
	{"YOGURTS", 7, 215145},
	{"YOGURT", 6, 49820},
	{"YOGU", 4, 98784},
	{"YOGR", 4, 184474},
	{"YOGIS", 5, 154869},
	{"YOGIC", 5, 136849},
	{"YOGIBEAR", 8, 262141},
	{"YOGI", 4, 66146},
	{"YOGHURT", 7, 83496},
	{"YOGH", 4, 194494},
	{"YOGESH", 6, 179827},
	{"YOGE", 4, 127877},
	{"YOGAWITHMOBY", 12, 168690},
	{"YOGANANDA", 9, 175955},
	{"YOGALATES", 9, 151453},
	{"YOGA", 4, 7789},
	{"YOFZ", 4, 107135},
	{"YOFY", 4, 54733},
	{"YOFX", 4, 195690},
	{"YOFW", 4, 34341},
	{"YOFV", 4, 48618},
	{"YOFU", 4, 47013},
	{"YOFT", 4, 2300},
	{"YOFS", 4, 8771},
	{"YOFR", 4, 37897},
	{"YOFQ", 4, 90970},
	{"YOFP", 4, 30696},
	{"YOFO", 4, 37671},
	{"YOFN", 4, 38061},
	{"YOFM", 4, 29128},
	{"YOFL", 4, 34380},
	{"YOFK", 4, 50437},
	{"YOFJ", 4, 52668},
	{"YOFI", 4, 35120},
	{"YOFH", 4, 30188},
	{"YOFG", 4, 39438},
	{"YOFFSET", 7, 260343},
	{"YOFE", 4, 36956},
	{"YOFD", 4, 37821},
	{"YOFC", 4, 10108},
	{"YOFB", 4, 36044},
	{"YOFA", 4, 8366},
	{"YOEST", 5, 240557},
	{"YOEL", 4, 217232},
	{"YODO", 4, 101309},
	{"YODL", 4, 192312},
	{"YODI", 4, 151716},
	{"YODH", 4, 140045},
	{"YODER", 5, 81774},
	{"YODELING", 8, 208064},
	{"YODEL", 5, 181213},
	{"YODE", 4, 102588},
	{"YODD", 4, 112641},
	{"YODA", 4, 63133},
	{"YOCU", 4, 258145},
	{"YOCT", 4, 55353},
	{"YOCL", 4, 125635},
	{"YOCHANAN", 8, 237614},
	{"YOCHAI", 6, 246583},
	{"YOCH", 4, 162123},
	{"YOCE", 4, 128231},
	{"YOCC", 4, 44225},
	{"YOCA", 4, 137549},
	{"YOBV", 4, 75864},
	{"YOBU", 4, 219284},
	{"YOBT", 4, 80595},
	{"YOBS", 4, 145327},
	{"YOBR", 4, 135066},
	{"YOBLING", 7, 254771},
	{"YOBL", 4, 90329},
	{"YOBJ", 4, 67177},
	{"YOBI", 4, 213608},
	{"YOBE", 4, 103958},
	{"YOBBO", 5, 237125},
	{"YOBANG", 6, 255264},
	{"YOBA", 4, 66824},
	{"YOAV", 4, 148455},
	{"YOAR", 4, 185998},
	{"YOANN", 5, 249406},
	{"YOAL", 4, 228217},
	{"YOAKUM", 6, 137646},
	{"YOAKAM", 6, 113935},
	{"YOAK", 4, 91298},
	{"YOAD", 4, 211632},
	{"YNYSOEDD", 8, 103503},
	{"YNYS", 4, 131103},
	{"YNYR", 4, 171187},
	{"YNYC", 4, 254921},
	{"YNYA", 4, 172587},
	{"YNY", 3, 5679},
	{"YNXA", 4, 221496},
	{"YNX", 3, 9987},
	{"YNWO", 4, 171865},
	{"YNWI", 4, 150725},
	{"YNWH", 4, 133227},
	{"YNWE", 4, 194814},
	{"YNWA", 4, 102126},
	{"YNW", 3, 4854},
	{"YNVI", 4, 247234},
	{"YNUT", 4, 115990},
	{"YNUR", 4, 96681},
	{"YNUN", 4, 166983},
	{"YNUM", 4, 46679},
	{"YNUL", 4, 205733},
	{"YNUD", 4, 178647},
	{"YNUC", 4, 119061},
	{"YNUA", 4, 257020},
	{"YNU", 3, 1420},
	{"YNTR", 4, 217061},
	{"YNT", 3, 1241},
	{"YNSW", 4, 200907},
	{"YNSU", 4, 252479},
	{"YNSP", 4, 209282},
	{"YNSM", 4, 205015},
	{"YNSK", 4, 85259},
	{"YNSF", 4, 235771},
	{"YNSC", 4, 166716},
	{"YNSB", 4, 201060},
	{"YNRO", 4, 178965},
	{"YNRI", 4, 237967},
	{"YNRE", 4, 146690},
	{"YNRA", 4, 147366},
	{"YNR", 3, 7888},
	{"YNPR", 4, 206081},
	{"YNPO", 4, 252135},
	{"YNPE", 4, 240135},
	{"YNPA", 4, 157103},
	{"YNOY", 4, 137180},
	{"YNOW", 4, 37143},
	{"YNOV", 4, 50345},
	{"YNOU", 4, 136250},
	{"YNOR", 4, 40359},
	{"YNOP", 4, 70782},
	{"YNOM", 4, 50214},
	{"YNOL", 4, 48901},
	{"YNOK", 4, 186375},
	{"YNOG", 4, 151244},
	{"YNOF", 4, 120062},
	{"YNOD", 4, 68968},
	{"YNOC", 4, 91780},
	{"YNOB", 4, 80074},
	{"YNNY", 4, 170605},
	{"YNNW", 4, 101185},
	{"YNNR", 4, 152335},
	{"YNNP", 4, 166216},
	{"YNNM", 4, 147034},
	{"YNNL", 4, 177170},
	{"YNNJ", 4, 219728},
	{"YNNG", 4, 208913},
	{"YNNF", 4, 149117},
	{"YNND", 4, 165145},
	{"YNNC", 4, 139156},
	{"YNNB", 4, 151831},
	{"YNMU", 4, 214598},
	{"YNMO", 4, 136722},
	{"YNMI", 4, 215448},
	{"YNME", 4, 213609},
	{"YNMC", 4, 206994},
	{"YNMA", 4, 90578},
	{"YNM", 3, 4763},
	{"YNLO", 4, 238209},
	{"YNLI", 4, 260442},
	{"YNLE", 4, 188555},
	{"YNLA", 4, 180315},
	{"YNL", 3, 28593},
	{"YNKI", 4, 194495},
	{"YNKE", 4, 239035},
	{"YNKA", 4, 252825},
	{"YNK", 3, 30683},
	{"YNJO", 4, 172056},
	{"YNJA", 4, 212614},
	{"YNJ", 3, 29891},
	{"YNIX", 4, 150266},
	{"YNIR", 4, 260443},
	{"YNIP", 4, 211065},
	{"YNIM", 4, 210098},
	{"YNIL", 4, 146565},
	{"YNIK", 4, 123831},
	{"YNIG", 4, 9429},
	{"YNIC", 4, 43877},
	{"YNIB", 4, 259642},
	{"YNI", 3, 801},
	{"YNHL", 4, 207723},
	{"YNGWIE", 6, 100663},
	{"YNGVE", 5, 245558},
	{"YNGU", 4, 199175},
	{"YNGS", 4, 173429},
	{"YNGR", 4, 195568},
	{"YNGO", 4, 151889},
	{"YNGLYN", 6, 239384},
	{"YNGL", 4, 248485},
	{"YNGI", 4, 189939},
	{"YNGHYLCH", 8, 196693},
	{"YNGHYD", 6, 208430},
	{"YNGE", 4, 128897},
	{"YNGA", 4, 124850},
	{"YNFR", 4, 218165},
	{"YNFO", 4, 163412},
	{"YNFL", 4, 123442},
	{"YNFI", 4, 234291},
	{"YNFA", 4, 227928},
	{"YNF", 3, 7147},
	{"YNEZ", 4, 115354},
	{"YNEY", 4, 206429},
	{"YNEX", 4, 52633},
	{"YNEV", 4, 43961},
	{"YNEU", 4, 79817},
	{"YNETNEWS", 8, 230906},
	{"YNER", 4, 55208},
	{"YNEP", 4, 96551},
	{"YNEM", 4, 98521},
	{"YNEL", 4, 84010},
	{"YNEK", 4, 151297},
	{"YNEJ", 4, 153643},
	{"YNEG", 4, 56036},
	{"YNEF", 4, 118201},
	{"YNEE", 4, 29234},
	{"YNED", 4, 86789},
	{"YNEC", 4, 54054},
	{"YNEB", 4, 85436},
	{"YNDS", 4, 171954},
	{"YNDR", 4, 55585},
	{"YNDP", 4, 248809},
	{"YNDO", 4, 88339},
	{"YNDI", 4, 53419},
	{"YNDH", 4, 126770},
	{"YNDE", 4, 101580},
	{"YNDA", 4, 74358},
	{"YND", 3, 1195},
	{"YNCW", 4, 137215},
	{"YNCT", 4, 183969},
	{"YNCS", 4, 166809},
	{"YNCR", 4, 98138},
	{"YNCO", 4, 95754},
	{"YNCL", 4, 205915},
	{"YNCI", 4, 133353},
	{"YNCH", 4, 41910},
	{"YNCE", 4, 157966},
	{"YNCC", 4, 251771},
	{"YNCA", 4, 109296},
	{"YNBU", 4, 211066},
	{"YNBR", 4, 136950},
	{"YNBO", 4, 179772},
	{"YNBI", 4, 230581},
	{"YNBE", 4, 144076},
	{"YNBC", 4, 146283},
	{"YNBA", 4, 120340},
	{"YNB", 3, 4547},
	{"YNAZ", 4, 141728},
	{"YNAY", 4, 239854},
	{"YNAW", 4, 210873},
	{"YNAV", 4, 80285},
	{"YNAU", 4, 135869},
	{"YNAR", 4, 59904},
	{"YNAP", 4, 81346},
	{"YNAM", 4, 29701},
	{"YNAL", 4, 121066},
	{"YNAK", 4, 135832},
	{"YNAJ", 4, 232089},
	{"YNAG", 4, 65018},
	{"YNAF", 4, 207198},
	{"YNAD", 4, 138577},
	{"YNAC", 4, 146822},
	{"YNAB", 4, 138486},
	{"YMZ", 3, 81034},
	{"YMYW", 4, 153644},
	{"YMYT", 4, 110788},
	{"YMYS", 4, 70340},
	{"YMYR", 4, 134726},
	{"YMYP", 4, 123558},
	{"YMYO", 4, 135552},
	{"YMYN", 4, 182390},
	{"YMYM", 4, 131652},
	{"YMYL", 4, 140714},
	{"YMYK", 4, 260846},
	{"YMYI", 4, 210671},
	{"YMYH", 4, 138683},
	{"YMYG", 4, 156234},
	{"YMYF", 4, 99238},
	{"YMYE", 4, 131195},
	{"YMYD", 4, 143145},
	{"YMYC", 4, 116632},
	{"YMYB", 4, 118561},
	{"YMYA", 4, 156747},
	{"YMY", 3, 1417},
	{"YMWNEUD", 7, 178266},
	{"YMWI", 4, 178850},
	{"YMWH", 4, 175266},
	{"YMWELD", 6, 217033},
	{"YMWA", 4, 167828},
	{"YMW", 3, 10074},
	{"YMV", 3, 46361},
	{"YMUT", 4, 86207},
	{"YMUS", 4, 32471},
	{"YMUR", 4, 60855},
	{"YMUN", 4, 78645},
	{"YMUM", 4, 113660},
	{"YMUL", 4, 64174},
	{"YMUH", 4, 187309},
	{"YMUG", 4, 173060},
	{"YMUD", 4, 140715},
	{"YMUC", 4, 35381},
	{"YMU", 3, 812},
	{"YMTV", 4, 214811},
	{"YMTO", 4, 161445},
	{"YMTH", 4, 135100},
	{"YMTE", 4, 251454},
	{"YMT", 3, 7287},
	{"YMSW", 4, 225316},
	{"YMSU", 4, 260444},
	{"YMST", 4, 166984},
	{"YMSS", 4, 195997},
	{"YMSP", 4, 219046},
	{"YMSO", 4, 185861},
	{"YMSN", 4, 228460},
	{"YMSM", 4, 230278},
	{"YMSL", 4, 252480},
	{"YMSI", 4, 182863},
	{"YMSH", 4, 178297},
	{"YMSF", 4, 194077},
	{"YMSE", 4, 240136},
	{"YMSC", 4, 199525},
	{"YMSB", 4, 256331},
	{"YMSA", 4, 129079},
	{"YMRW", 4, 206995},
	{"YMRU", 4, 172871},
	{"YMRT", 4, 210672},
	{"YMRS", 4, 88510},
	{"YMRR", 4, 198062},
	{"YMRP", 4, 160240},
	{"YMRO", 4, 187991},
	{"YMRM", 4, 149911},
	{"YMRL", 4, 215649},
	{"YMRK", 4, 215449},
	{"YMRJ", 4, 224862},
	{"YMRI", 4, 224404},
	{"YMRH", 4, 188129},
	{"YMRG", 4, 197108},
	{"YMRF", 4, 220172},
	{"YMRE", 4, 205556},
	{"YMRD", 4, 194207},
	{"YMRC", 4, 168458},
	{"YMRB", 4, 143575},
	{"YMRA", 4, 147197},
	{"YMR", 3, 2168},
	{"YMQ", 3, 121442},
	{"YMPU", 4, 118842},
	{"YMPT", 4, 44974},
	{"YMPS", 4, 161609},
	{"YMPO", 4, 89384},
	{"YMPL", 4, 154965},
	{"YMPI", 4, 28693},
	{"YMPH", 4, 44317},
	{"YMPE", 4, 226716},
	{"YMPA", 4, 44912},
	{"YMP", 3, 238838},
	{"YMOZ", 4, 193623},
	{"YMOY", 4, 223061},
	{"YMOW", 4, 150412},
	{"YMOV", 4, 33981},
	{"YMOU", 4, 33425},
	{"YMOT", 4, 43291},
	{"YMOS", 4, 41181},
	{"YMOR", 4, 5904},
	{"YMOP", 4, 234292},
	{"YMOO", 4, 58442},
	{"YMON", 4, 31875},
	{"YMOM", 4, 50995},
	{"YMOL", 4, 67240},
	{"YMOI", 4, 159884},
	{"YMOH", 4, 148278},
	{"YMOG", 4, 250102},
	{"YMOF", 4, 119317},
	{"YMOE", 4, 199845},
	{"YMOD", 4, 41675},
	{"YMOC", 4, 119435},
	{"YMOB", 4, 78472},
	{"YMOA", 4, 175063},
	{"YMNT", 4, 202756},
	{"YMNS", 4, 94298},
	{"YMNO", 4, 142050},
	{"YMNI", 4, 221497},
	{"YMNE", 4, 215650},
	{"YMNA", 4, 51114},
	{"YMN", 3, 1732},
	{"YMMV", 4, 150437},
	{"YMMO", 4, 196924},
	{"YMMI", 4, 228461},
	{"YMME", 4, 56278},
	{"YMMA", 4, 179976},
	{"YMM", 3, 2374},
	{"YMLE", 4, 208700},
	{"YMLB", 4, 252481},
	{"YMLAEN", 6, 162063},
	{"YMLA", 4, 204850},
	{"YMK", 3, 38386},
	{"YMJ", 3, 46178},
	{"YMIZ", 4, 195569},
	{"YMIY", 4, 228218},
	{"YMIX", 4, 73821},
	{"YMIT", 4, 62178},
	{"YMIS", 4, 38269},
	{"YMIR", 4, 239772},
	{"YMIO", 4, 214026},
	{"YMIN", 4, 135312},
	{"YMIM", 4, 148104},
	{"YMIL", 4, 34550},
	{"YMIK", 4, 71251},
	{"YMIH", 4, 257021},
	{"YMIG", 4, 42349},
	{"YMIE", 4, 111062},
	{"YMID", 4, 51848},
	{"YMIC", 4, 47158},
	{"YMIA", 4, 129112},
	{"YMHE", 4, 250805},
	{"YMHA", 4, 218871},
	{"YMH", 3, 35791},
	{"YMGYNGHORI", 10, 198413},
	{"YMGM", 4, 223743},
	{"YMG", 3, 239092},
	{"YMFO", 4, 97515},
	{"YMEY", 4, 161287},
	{"YMEX", 4, 96310},
	{"YMEW", 4, 151781},
	{"YMET", 4, 40573},
	{"YMES", 4, 54023},
	{"YMER", 4, 46175},
	{"YMEP", 4, 189551},
	{"YMEO", 4, 149639},
	{"YMEN", 4, 6120},
	{"YMEM", 4, 32298},
	{"YMEL", 4, 67097},
	{"YMEI", 4, 108954},
	{"YMEH", 4, 169085},
	{"YMEG", 4, 104721},
	{"YMEF", 4, 198209},
	{"YMEE", 4, 45705},
	{"YMED", 4, 40862},
	{"YMEC", 4, 82566},
	{"YMEB", 4, 180662},
	{"YMEA", 4, 33153},
	{"YMDDIRIEDOLAETH", 15, 232613},
	{"YMDDANGOS", 9, 241289},
	{"YMDA", 4, 76590},
	{"YMD", 3, 200790},
	{"YMCV", 4, 257773},
	{"YMCS", 4, 250103},
	{"YMCP", 4, 212615},
	{"YMCO", 4, 225070},
	{"YMCN", 4, 129798},
	{"YMCM", 4, 140213},
	{"YMCL", 4, 118586},
	{"YMCK", 4, 114798},
	{"YMCI", 4, 150086},
	{"YMCHWILIO", 9, 223435},
	{"YMCHWIL", 7, 139827},
	{"YMCH", 4, 213801},
	{"YMCG", 4, 88772},
	{"YMCF", 4, 196606},
	{"YMCE", 4, 212616},
	{"YMCD", 4, 109434},
	{"YMCC", 4, 63709},
	{"YMCB", 4, 198063},
	{"YMCAS", 5, 210964},
	{"YMCA", 4, 46750},
	{"YMBU", 4, 240137},
	{"YMBO", 4, 35083},
	{"YMBI", 4, 82234},
	{"YMBE", 4, 188278},
	{"YMBA", 4, 103978},
	{"YMB", 3, 1020},
	{"YMAZ", 4, 168179},
	{"YMAY", 4, 31154},
	{"YMAX", 4, 131544},
	{"YMAV", 4, 223744},
	{"YMAU", 4, 102308},
	{"YMATEB", 6, 160363},
	{"YMAT", 4, 37705},
	{"YMAS", 4, 48772},
	{"YMARFER", 7, 211204},
	{"YMAR", 4, 9542},
	{"YMAP", 4, 86865},
	{"YMAO", 4, 206430},
	{"YMAN", 4, 6975},
	{"YMAM", 4, 112603},
	{"YMAL", 4, 53644},
	{"YMAK", 4, 29593},
	{"YMAJ", 4, 50688},
	{"YMAI", 4, 43905},
	{"YMAH", 4, 109704},
	{"YMAG", 4, 50944},
	{"YMAF", 4, 217062},
	{"YMAE", 4, 183118},
	{"YMAD", 4, 33221},
	{"YMAB", 4, 206835},
	{"YLZ", 3, 72429},
	{"YLYS", 4, 221222},
	{"YLYR", 4, 152013},
	{"YLYO", 4, 176765},
	{"YLYN", 4, 94686},
	{"YLYL", 4, 244515},
	{"YLYI", 4, 133385},
	{"YLYC", 4, 174239},
	{"YLYA", 4, 244198},
	{"YLY", 3, 3518},
	{"YLX", 3, 185971},
	{"YLWI", 4, 180077},
	{"YLWH", 4, 237343},
	{"YLWA", 4, 160880},
	{"YLW", 3, 188934},
	{"YLVI", 4, 81000},
	{"YLVE", 4, 97239},
	{"YLV", 3, 1074},
	{"YLUX", 4, 150966},
	{"YLUT", 4, 120664},
	{"YLUS", 4, 91350},
	{"YLUR", 4, 133177},
	{"YLUP", 4, 236335},
	{"YLUN", 4, 84829},
	{"YLUM", 4, 60419},
	{"YLUL", 4, 244199},
	{"YLUK", 4, 128172},
	{"YLUI", 4, 160730},
	{"YLUG", 4, 189801},
	{"YLUD", 4, 160036},
	{"YLUC", 4, 63284},
	{"YLUB", 4, 207199},
	{"YLU", 3, 243448},
	{"YLTR", 4, 207541},
	{"YLTO", 4, 148602},
	{"YLTH", 4, 176884},
	{"YLTD", 4, 122707},
	{"YLTC", 4, 225784},
	{"YLTA", 4, 255279},
	{"YLSU", 4, 170091},
	{"YLST", 4, 106837},
	{"YLSQ", 4, 242995},
	{"YLSM", 4, 188556},
	{"YLSI", 4, 182391},
	{"YLSH", 4, 248486},
	{"YLSA", 4, 172259},
	{"YLRO", 4, 237968},
	{"YLRICS", 6, 179359},
	{"YLRE", 4, 148105},
	{"YLRA", 4, 259643},
	{"YLR", 3, 30751},
	{"YLQ", 3, 103235},
	{"YLPR", 4, 246324},
	{"YLPH", 4, 176555},
	{"YLPE", 4, 253529},
	{"YLP", 3, 29013},
	{"YLOY", 4, 87315},
	{"YLOW", 4, 40271},
	{"YLOV", 4, 44764},
	{"YLOU", 4, 61513},
	{"YLOT", 4, 88437},
	{"YLOS", 4, 35845},
	{"YLOR", 4, 31283},
	{"YLOP", 4, 118532},
	{"YLOO", 4, 36650},
	{"YLON", 4, 35481},
	{"YLOM", 4, 180663},
	{"YLOL", 4, 183489},
	{"YLOI", 4, 159016},
	{"YLOH", 4, 139733},
	{"YLOG", 4, 64812},
	{"YLOF", 4, 147419},
	{"YLOE", 4, 246927},
	{"YLOD", 4, 133740},
	{"YLOC", 4, 37111},
	{"YLOB", 4, 91901},
	{"YLOA", 4, 54783},
	{"YLO", 3, 721},
	{"YLNE", 4, 255280},
	{"YLMO", 4, 236075},
	{"YLME", 4, 156619},
	{"YLMA", 4, 170092},
	{"YLM", 3, 253832},
	{"YLLY", 4, 230582},
	{"YLLW", 4, 141781},
	{"YLLU", 4, 167238},
	{"YLLT", 4, 111253},
	{"YLLS", 4, 84681},
	{"YLLR", 4, 138917},
	{"YLLP", 4, 109684},
	{"YLLOW", 5, 257559},
	{"YLLO", 4, 101564},
	{"YLLN", 4, 122007},
	{"YLLM", 4, 143620},
	{"YLLL", 4, 129968},
	{"YLLK", 4, 194078},
	{"YLLJ", 4, 198349},
	{"YLLI", 4, 71432},
	{"YLLH", 4, 88320},
	{"YLLG", 4, 102003},
	{"YLLF", 4, 127054},
	{"YLLE", 4, 109074},
	{"YLLD", 4, 126102},
	{"YLLC", 4, 101874},
	{"YLLB", 4, 66351},
	{"YLLA", 4, 54806},
	{"YLKI", 4, 145205},
	{"YLK", 3, 33455},
	{"YLJ", 3, 45466},
	{"YLIZ", 4, 100806},
	{"YLIV", 4, 38278},
	{"YLIU", 4, 167906},
	{"YLIT", 4, 38872},
	{"YLIS", 4, 40020},
	{"YLIQ", 4, 115502},
	{"YLIP", 4, 118802},
	{"YLIOPISTO", 9, 202267},
	{"YLIO", 4, 78653},
	{"YLIN", 4, 8667},
	{"YLIL", 4, 117858},
	{"YLIK", 4, 33834},
	{"YLIGHTING", 9, 247648},
	{"YLIG", 4, 46022},
	{"YLIF", 4, 33686},
	{"YLIE", 4, 58514},
	{"YLID", 4, 165650},
	{"YLIC", 4, 68499},
	{"YLIB", 4, 55330},
	{"YLIA", 4, 97208},
	{"YLHE", 4, 198508},
	{"YLHA", 4, 159093},
	{"YLH", 3, 31254},
	{"YLGR", 4, 142562},
	{"YLG", 3, 30746},
	{"YLFO", 4, 235204},
	{"YLEY", 4, 87253},
	{"YLEX", 4, 159337},
	{"YLEW", 4, 47438},
	{"YLEV", 4, 43214},
	{"YLEU", 4, 122708},
	{"YLET", 4, 39906},
	{"YLER", 4, 40101},
	{"YLEQ", 4, 226717},
	{"YLEP", 4, 59201},
	{"YLEO", 4, 41441},
	{"YLEN", 4, 48623},
	{"YLEM", 4, 64266},
	{"YLEL", 4, 82238},
	{"YLEK", 4, 106617},
	{"YLEJ", 4, 138972},
	{"YLEI", 4, 50747},
	{"YLEH", 4, 62578},
	{"YLEG", 4, 45213},
	{"YLEF", 4, 40212},
	{"YLEE", 4, 55304},
	{"YLED", 4, 42237},
	{"YLEC", 4, 54070},
	{"YLEB", 4, 54288},
	{"YLEA", 4, 7440},
	{"YLDQ", 4, 123259},
	{"YLDI", 4, 216856},
	{"YLDE", 4, 144969},
	{"YLDA", 4, 225785},
	{"YLD", 3, 145382},
	{"YLCR", 4, 206082},
	{"YLCO", 4, 144583},
	{"YLCH", 4, 139940},
	{"YLCA", 4, 204851},
	{"YLC", 3, 212976},
	{"YLBU", 4, 240727},
	{"YLBE", 4, 197572},
	{"YLB", 3, 28738},
	{"YLAZ", 4, 144685},
	{"YLAY", 4, 67019},
	{"YLAX", 4, 163508},
	{"YLAW", 4, 40502},
	{"YLAV", 4, 134472},
	{"YLAU", 4, 49108},
	{"YLAT", 4, 40725},
	{"YLAS", 4, 38870},
	{"YLAR", 4, 39437},
	{"YLAP", 4, 76391},
	{"YLAO", 4, 222417},
	{"YLANG", 5, 86369},
	{"YLAN", 4, 28601},
	{"YLAM", 4, 74285},
	{"YLAL", 4, 124887},
	{"YLAK", 4, 74892},
	{"YLAI", 4, 79696},
	{"YLAH", 4, 140765},
	{"YLAG", 4, 119084},
	{"YLAF", 4, 143093},
	{"YLAE", 4, 183970},
	{"YLAD", 4, 78365},
	{"YLAC", 4, 56643},
	{"YLABEL", 6, 184721},
	{"YLAA", 4, 145521},
	{"YLA", 3, 730},
	{"YL", 2, 279},
	{"YKZ", 3, 99122},
	{"YKYO", 4, 247864},
	{"YKYL", 4, 142935},
	{"YKY", 3, 28612},
	{"YKX", 3, 135569},
	{"YKWH", 4, 242715},
	{"YKWA", 4, 179444},
	{"YKW", 3, 33115},
	{"YKV", 3, 58438},
	{"YKUS", 4, 202046},
	{"YKUR", 4, 114717},
	{"YKUN", 4, 173624},
	{"YKUM", 4, 173625},
	{"YKUL", 4, 233504},
	{"YKUB", 4, 144819},
	{"YKU", 3, 4492},
	{"YKTH", 4, 243613},
	{"YKST", 4, 159174},
	{"YKSO", 4, 241010},
	{"YKSA", 4, 183971},
	{"YKRU", 4, 165720},
	{"YKRO", 4, 136723},
	{"YKRI", 4, 111713},
	{"YKRE", 4, 144520},
	{"YKRA", 4, 102430},
	{"YKR", 3, 4037},
	{"YKQ", 3, 138455},
	{"YKP", 3, 41368},
	{"YKOW", 4, 204651},
	{"YKOV", 4, 174345},
	{"YKOU", 4, 181230},
	{"YKOT", 4, 155638},
	{"YKOS", 4, 121392},
	{"YKOR", 4, 93400},
	{"YKOP", 4, 232362},
	{"YKOO", 4, 202937},
	{"YKON", 4, 96783},
	{"YKOM", 4, 192780},
	{"YKOL", 4, 147367},
	{"YKOI", 4, 261562},
	{"YKOH", 4, 227929},
	{"YKOF", 4, 235772},
	{"YKOE", 4, 249433},
	{"YKOD", 4, 208914},
	{"YKOC", 4, 213399},
	{"YKOB", 4, 194496},
	{"YKO", 3, 2110},
	{"YKNU", 4, 242996},
	{"YKNO", 4, 28522},
	{"YKNI", 4, 84054},
	{"YKNE", 4, 50443},
	{"YKNA", 4, 225071},
	{"YKN", 3, 853},
	{"YKMS", 4, 215450},
	{"YKMN", 4, 258146},
	{"YKMM", 4, 210874},
	{"YKMF", 4, 200179},
	{"YKMA", 4, 187730},
	{"YKLO", 4, 194208},
	{"YKLI", 4, 194663},
	{"YKLE", 4, 147198},
	{"YKLA", 4, 167408},
	{"YKL", 3, 8651},
	{"YKK", 3, 180232},
	{"YKJA", 4, 140103},
	{"YKJ", 3, 35757},
	{"YKIT", 4, 86510},
	{"YKIS", 4, 87166},
	{"YKIR", 4, 104272},
	{"YKIN", 4, 40814},
	{"YKIM", 4, 93918},
	{"YKIL", 4, 43163},
	{"YKIE", 4, 169086},
	{"YKID", 4, 52893},
	{"YKIC", 4, 66178},
	{"YKIA", 4, 250806},
	{"YKI", 3, 891},
	{"YKHO", 4, 221689},
	{"YKHA", 4, 107611},
	{"YKH", 3, 6891},
	{"YKG", 3, 41120},
	{"YKF", 3, 49046},
	{"YKEY", 4, 74580},
	{"YKEW", 4, 181954},
	{"YKEV", 4, 98233},
	{"YKET", 4, 176459},
	{"YKES", 4, 85325},
	{"YKER", 4, 77083},
	{"YKEP", 4, 64708},
	{"YKEO", 4, 239584},
	{"YKEN", 4, 61631},
	{"YKEM", 4, 159175},
	{"YKEL", 4, 81059},
	{"YKEI", 4, 101151},
	{"YKEH", 4, 228703},
	{"YKEE", 4, 49628},
	{"YKEA", 4, 119674},
	{"YKD", 3, 45308},
	{"YKC", 3, 38095},
	{"YKB", 3, 41938},
	{"YKAZ", 4, 168278},
	{"YKAY", 4, 114314},
	{"YKAW", 4, 233841},
	{"YKAU", 4, 178298},
	{"YKAT", 4, 75774},
	{"YKAS", 4, 123877},
	{"YKAR", 4, 77510},
	{"YKAP", 4, 157726},
	{"YKAN", 4, 72458},
	{"YKAM", 4, 128469},
	{"YKAL", 4, 114264},
	{"YKAK", 4, 260044},
	{"YKAI", 4, 131577},
	{"YKAH", 4, 134179},
	{"YKAD", 4, 201567},
	{"YKAB", 4, 203276},
	{"YKA", 3, 1388},
	{"YJZ", 3, 93173},
	{"YJY", 3, 78099},
	{"YJW", 3, 51548},
	{"YJV", 3, 66365},
	{"YJUV", 4, 176556},
	{"YJUS", 4, 33424},
	{"YJUR", 4, 98461},
	{"YJUN", 4, 45406},
	{"YJUM", 4, 69585},
	{"YJUL", 4, 50344},
	{"YJUI", 4, 171388},
	{"YJUG", 4, 212795},
	{"YJUD", 4, 59551},
	{"YJUA", 4, 156550},
	{"YJU", 3, 838},
	{"YJRW", 4, 187992},
	{"YJRT", 4, 248149},
	{"YJRS", 4, 199347},
	{"YJRO", 4, 250807},
	{"YJRI", 4, 231068},
	{"YJRH", 4, 250456},
	{"YJRA", 4, 155229},
	{"YJR", 3, 5576},
	{"YJQ", 3, 250000},
	{"YJPM", 4, 231564},
	{"YJP", 3, 39658},
	{"YJOY", 4, 120007},
	{"YJOU", 4, 65590},
	{"YJOS", 4, 67832},
	{"YJOR", 4, 105519},
	{"YJON", 4, 56097},
	{"YJOL", 4, 180664},
	{"YJOK", 4, 104112},
	{"YJOI", 4, 51897},
	{"YJOH", 4, 41107},
	{"YJOG", 4, 246928},
	{"YJOE", 4, 69031},
	{"YJOD", 4, 229739},
	{"YJOC", 4, 191775},
	{"YJOB", 4, 48856},
	{"YJOA", 4, 133048},
	{"YJO", 3, 864},
	{"YJM", 3, 44416},
	{"YJL", 3, 55580},
	{"YJK", 3, 52838},
	{"YJJ", 3, 51155},
	{"YJIN", 4, 129012},
	{"YJIM", 4, 75607},
	{"YJIL", 4, 221690},
	{"YJIG", 4, 237673},
	{"YJI", 3, 3677},
	{"YJG", 3, 56536},
	{"YJF", 3, 57616},
	{"YJEW", 4, 74576},
	{"YJET", 4, 106401},
	{"YJES", 4, 90369},
	{"YJER", 4, 77376},
	{"YJEO", 4, 238762},
	{"YJEN", 4, 86110},
	{"YJEL", 4, 217940},
	{"YJEF", 4, 87200},
	{"YJEE", 4, 216648},
	{"YJED", 4, 253530},
	{"YJEA", 4, 79196},
	{"YJE", 3, 1412},
	{"YJD", 3, 46143},
	{"YJC", 3, 41766},
	{"YJBL", 4, 242438},
	{"YJAZ", 4, 115403},
	{"YJAY", 4, 105595},
	{"YJAW", 4, 200011},
	{"YJAV", 4, 170982},
	{"YJAS", 4, 99636},
	{"YJAR", 4, 112452},
	{"YJAP", 4, 72252},
	{"YJAN", 4, 47813},
	{"YJAM", 4, 54711},
	{"YJAL", 4, 241293},
	{"YJAK", 4, 139990},
	{"YJAI", 4, 69485},
	{"YJAG", 4, 171567},
	{"YJAF", 4, 198064},
	{"YJAD", 4, 208915},
	{"YJAC", 4, 53998},
	{"YJAB", 4, 214599},
	{"YJA", 3, 956},
	{"YIZKOR", 6, 208146},
	{"YIZH", 4, 259644},
	{"YIYI", 4, 198686},
	{"YIXING", 6, 189727},
	{"YIWU", 4, 155673},
	{"YIWR", 4, 214403},
	{"YIWO", 4, 71472},
	{"YIWI", 4, 98769},
	{"YIWH", 4, 223986},
	{"YIWE", 4, 150783},
	{"YIWA", 4, 55232},
	{"YIW", 3, 1691},
	{"YIVI", 4, 199846},
	{"YIVE", 4, 78425},
	{"YIVA", 4, 134980},
	{"YIV", 3, 3418},
	{"YIUS", 4, 165812},
	{"YIUN", 4, 242439},
	{"YITZHAK", 7, 114326},
	{"YITZCHAK", 8, 154863},
	{"YITZ", 4, 157240},
	{"YITY", 4, 242997},
	{"YITW", 4, 37045},
	{"YITV", 4, 219285},
	{"YITU", 4, 129248},
	{"YITS", 4, 29178},
	{"YITR", 4, 80834},
	{"YITP", 4, 81937},
	{"YITM", 4, 73022},
	{"YITL", 4, 97012},
	{"YITK", 4, 249110},
	{"YITJ", 4, 168797},
	{"YITG", 4, 118886},
	{"YITF", 4, 92088},
	{"YITD", 4, 72395},
	{"YITC", 4, 62573},
	{"YITB", 4, 72976},
	{"YISY", 4, 118720},
	{"YISW", 4, 53481},
	{"YISV", 4, 76430},
	{"YISU", 4, 55220},
	{"YIST", 4, 9887},
	{"YISS", 4, 31480},
	{"YISROEL", 7, 149090},
	{"YISRAEL", 7, 102227},
	{"YISR", 4, 44931},
	{"YISQ", 4, 123993},
	{"YISP", 4, 46305},
	{"YISN", 4, 36238},
	{"YISM", 4, 49028},
	{"YISL", 4, 43324},
	{"YISK", 4, 82618},
	{"YISJ", 4, 81280},
	{"YISHUN", 6, 237242},
	{"YISG", 4, 50791},
	{"YISF", 4, 50237},
	{"YISD", 4, 49277},
	{"YISC", 4, 43124},
	{"YISB", 4, 46346},
	{"YISA", 4, 9186},
	{"YIRV", 4, 183604},
	{"YIRS", 4, 187458},
	{"YIRR", 4, 77388},
	{"YIRO", 4, 93570},
	{"YIRI", 4, 98358},
	{"YIRE", 4, 80538},
	{"YIRA", 4, 73572},
	{"YIPU", 4, 239036},
	{"YIPR", 4, 151717},
	{"YIPPIE", 6, 178380},
	{"YIPPEE", 6, 99386},
	{"YIPP", 4, 227930},
	{"YIPO", 4, 137973},
	{"YIPL", 4, 179445},
	{"YIPI", 4, 244200},
	{"YIPH", 4, 109456},
	{"YIPEE", 5, 228338},
	{"YIPE", 4, 187993},
	{"YIPA", 4, 152920},
	{"YIOW", 4, 127306},
	{"YIORG", 5, 97164},
	{"YIOR", 4, 164809},
	{"YIOF", 4, 205382},
	{"YINZ", 4, 147199},
	{"YINY", 4, 73215},
	{"YINX", 4, 243614},
	{"YINW", 4, 38607},
	{"YINV", 4, 31888},
	{"YINU", 4, 70712},
	{"YINT", 4, 2213},
	{"YINS", 4, 8460},
	{"YINR", 4, 44910},
	{"YINQ", 4, 87721},
	{"YINP", 4, 38526},
	{"YINM", 4, 38287},
	{"YINL", 4, 43252},
	{"YINK", 4, 65831},
	{"YINJ", 4, 41786},
	{"YINH", 4, 35868},
	{"YING", 4, 56477},
	{"YINF", 4, 31315},
	{"YIND", 4, 29402},
	{"YINC", 4, 7144},
	{"YINB", 4, 41093},
	{"YINA", 4, 8484},
	{"YIMW", 4, 222630},
	{"YIMU", 4, 218408},
	{"YIMT", 4, 160402},
	{"YIMS", 4, 113945},
	{"YIMR", 4, 203437},
	{"YIMP", 4, 28624},
	{"YIMOU", 5, 176808},
	{"YIMO", 4, 162618},
	{"YIMN", 4, 113815},
	{"YIMM", 4, 58073},
	{"YIML", 4, 226968},
	{"YIMJ", 4, 249111},
	{"YIMI", 4, 109316},
	{"YIMH", 4, 171474},
	{"YIMF", 4, 230279},
	{"YIME", 4, 130738},
	{"YIMD", 4, 226491},
	{"YIMC", 4, 223062},
	{"YIMB", 4, 160177},
	{"YIMA", 4, 54109},
	{"YILO", 4, 98325},
	{"YILMAZ", 6, 141065},
	{"YILL", 4, 45680},
	{"YILE", 4, 166810},
	{"YILDIZ", 6, 194164},
	{"YILDIRIM", 8, 262131},
	{"YILA", 4, 200908},
	{"YIKN", 4, 106457},
	{"YIKES", 5, 71710},
	{"YIKERS", 6, 257659},
	{"YIKE", 4, 160962},
	{"YIKA", 4, 168620},
	{"YIJU", 4, 126183},
	{"YIJI", 4, 216042},
	{"YIJ", 3, 30340},
	{"YIGU", 4, 176365},
	{"YIGO", 4, 116494},
	{"YIGN", 4, 61203},
	{"YIGE", 4, 170346},
	{"YIGAL", 5, 187503},
	{"YIGA", 4, 199020},
	{"YIFY", 4, 55833},
	{"YIFW", 4, 98711},
	{"YIFU", 4, 182752},
	{"YIFT", 4, 46794},
	{"YIFS", 4, 96203},
	{"YIFR", 4, 181821},
	{"YIFP", 4, 146008},
	{"YIFO", 4, 101723},
	{"YIFN", 4, 91185},
	{"YIFM", 4, 152388},
	{"YIFL", 4, 208496},
	{"YIFI", 4, 61676},
	{"YIFH", 4, 76810},
	{"YIFG", 4, 212407},
	{"YIFF", 4, 219384},
	{"YIFE", 4, 86137},
	{"YIFD", 4, 199526},
	{"YIFC", 4, 143203},
	{"YIFB", 4, 180316},
	{"YIFA", 4, 79648},
	{"YIEX", 4, 238488},
	{"YIELDS", 6, 35256},
	{"YIELDING", 8, 50350},
	{"YIELDED", 7, 49600},
	{"YIELD", 5, 8298},
	{"YIEL", 4, 37784},
	{"YIDT", 4, 257774},
	{"YIDS", 4, 162464},
	{"YIDR", 4, 178750},
	{"YIDO", 4, 61231},
	{"YIDL", 4, 144970},
	{"YIDI", 4, 78958},
	{"YIDE", 4, 43697},
	{"YIDDISH", 7, 55533},
	{"YIDD", 4, 94735},
	{"YIDB", 4, 203114},
	{"YIDA", 4, 123942},
	{"YICO", 4, 81957},
	{"YICHANG", 7, 209858},
	{"YICH", 4, 140214},
	{"YICE", 4, 91991},
	{"YICA", 4, 70599},
	{"YIC", 3, 2181},
	{"YIBR", 4, 222850},
	{"YIBO", 4, 216450},
	{"YIBM", 4, 165329},
	{"YIBE", 4, 108130},
	{"YIBA", 4, 217701},
	{"YIB", 3, 5718},
	{"YIAP", 4, 244516},
	{"YIANNIS", 7, 194041},
	{"YIAM", 4, 70775},
	{"YIAL", 4, 153645},
	{"YIAG", 4, 198350},
	{"YIAC", 4, 241011},
	{"YHYP", 4, 93423},
	{"YHYM", 4, 253878},
	{"YHYD", 4, 107412},
	{"YHYB", 4, 181231},
	{"YHY", 3, 4413},
	{"YHWH", 4, 139427},
	{"YHVH", 4, 205985},
	{"YHUT", 4, 125398},
	{"YHUS", 4, 55824},
	{"YHUR", 4, 56172},
	{"YHUN", 4, 50927},
	{"YHUM", 4, 48783},
	{"YHUL", 4, 140616},
	{"YHUG", 4, 75344},
	{"YHUF", 4, 167481},
	{"YHUE", 4, 203115},
	{"YHUD", 4, 127164},
	{"YHUB", 4, 130041},
	{"YHUA", 4, 219495},
	{"YHTM", 4, 258525},
	{"YHOY", 4, 170165},
	{"YHOW", 4, 35917},
	{"YHOV", 4, 179661},
	{"YHOU", 4, 35578},
	{"YHOR", 4, 57061},
	{"YHOP", 4, 43995},
	{"YHOM", 4, 38084},
	{"YHOL", 4, 39738},
	{"YHOG", 4, 155848},
	{"YHOF", 4, 147420},
	{"YHOD", 4, 150835},
	{"YHOC", 4, 112110},
	{"YHOB", 4, 127767},
	{"YHO", 3, 748},
	{"YHIV", 4, 215451},
	{"YHIS", 4, 7258},
	{"YHIR", 4, 64868},
	{"YHIP", 4, 111749},
	{"YHIM", 4, 42758},
	{"YHIL", 4, 49048},
	{"YHIK", 4, 121037},
	{"YHIJ", 4, 242162},
	{"YHIG", 4, 31962},
	{"YHID", 4, 76204},
	{"YHIC", 4, 149324},
	{"YHIB", 4, 193624},
	{"YHI", 3, 733},
	{"YHEZ", 4, 250808},
	{"YHEY", 4, 110508},
	{"YHEW", 4, 37931},
	{"YHEV", 4, 198351},
	{"YHEU", 4, 133639},
	{"YHES", 4, 35201},
	{"YHER", 4, 29509},
	{"YHEP", 4, 72127},
	{"YHEM", 4, 60596},
	{"YHEL", 4, 32176},
	{"YHEK", 4, 126371},
	{"YHEJ", 4, 134265},
	{"YHEG", 4, 87866},
	{"YHEF", 4, 78151},
	{"YHED", 4, 52864},
	{"YHEC", 4, 54133},
	{"YHEB", 4, 72479},
	{"YHEA", 4, 10022},
	{"YHAZ", 4, 107716},
	{"YHAY", 4, 88827},
	{"YHAW", 4, 60582},
	{"YHAV", 4, 3165},
	{"YHAU", 4, 104650},
	{"YHAS", 4, 4957},
	{"YHAR", 4, 33058},
	{"YHAP", 4, 43031},
	{"YHAOO", 5, 148478},
	{"YHAM", 4, 62372},
	{"YHAL", 4, 37166},
	{"YHAK", 4, 249434},
	{"YHAG", 4, 138973},
	{"YHAD", 4, 5255},
	{"YHAC", 4, 126578},
	{"YHAB", 4, 102589},
	{"YGZ", 3, 126667},
	{"YGYM", 4, 135440},
	{"YGY", 3, 29090},
	{"YGX", 3, 145364},
	{"YGWY", 4, 222631},
	{"YGW", 3, 36000},
	{"YGV", 3, 67583},
	{"YGUY", 4, 61259},
	{"YGUT", 4, 103442},
	{"YGUS", 4, 137181},
	{"YGUR", 4, 127530},
	{"YGUN", 4, 68887},
	{"YGUM", 4, 226969},
	{"YGUL", 4, 129908},
	{"YGUI", 4, 57374},
	{"YGUE", 4, 64606},
	{"YGUA", 4, 47777},
	{"YGU", 3, 1014},
	{"YGRU", 4, 106194},
	{"YGRO", 4, 32098},
	{"YGRI", 4, 59687},
	{"YGRE", 4, 36978},
	{"YGRA", 4, 33676},
	{"YGR", 3, 787},
	{"YGQ", 3, 137024},
	{"YGPS", 4, 248150},
	{"YGP", 3, 40061},
	{"YGOW", 4, 132264},
	{"YGOV", 4, 41858},
	{"YGOU", 4, 97376},
	{"YGOT", 4, 35521},
	{"YGOS", 4, 91299},
	{"YGOR", 4, 74127},
	{"YGOP", 4, 133771},
	{"YGOO", 4, 10083},
	{"YGON", 4, 58188},
	{"YGOM", 4, 153915},
	{"YGOLD", 5, 241178},
	{"YGOL", 4, 53406},
	{"YGOK", 4, 221498},
	{"YGOI", 4, 40993},
	{"YGOH", 4, 169618},
	{"YGOG", 4, 198690},
	{"YGOF", 4, 115585},
	{"YGOE", 4, 54423},
	{"YGOD", 4, 53029},
	{"YGOB", 4, 101152},
	{"YGOA", 4, 48422},
	{"YGNU", 4, 216253},
	{"YGNO", 4, 238489},
	{"YGNE", 4, 251772},
	{"YGNACIO", 7, 217112},
	{"YGNA", 4, 224863},
	{"YGN", 3, 31929},
	{"YGMY", 4, 210479},
	{"YGMI", 4, 242440},
	{"YGMA", 4, 149008},
	{"YGLU", 4, 161288},
	{"YGLO", 4, 67932},
	{"YGLI", 4, 122744},
	{"YGLESIAS", 8, 87664},
	{"YGLE", 4, 99882},
	{"YGLA", 4, 63228},
	{"YGL", 3, 1817},
	{"YGK", 3, 74610},
	{"YGJ", 3, 81930},
	{"YGIV", 4, 36229},
	{"YGIU", 4, 131155},
	{"YGIS", 4, 217702},
	{"YGIR", 4, 54301},
	{"YGIO", 4, 160881},
	{"YGIN", 4, 118439},
	{"YGIM", 4, 230280},
	{"YGIL", 4, 77630},
	{"YGIG", 4, 135200},
	{"YGIF", 4, 79232},
	{"YGIE", 4, 81001},
	{"YGID", 4, 213610},
	{"YGIB", 4, 116539},
	{"YGIA", 4, 87989},
	{"YGI", 3, 910},
	{"YGHU", 4, 162384},
	{"YGHO", 4, 108979},
	{"YGHE", 4, 242441},
	{"YGHA", 4, 175267},
	{"YGH", 3, 6957},
	{"YGGDRASIL", 9, 218124},
	{"YGGD", 4, 219047},
	{"YGG", 3, 36021},
	{"YGF", 3, 57238},
	{"YGET", 4, 30706},
	{"YGES", 4, 148437},
	{"YGER", 4, 54311},
	{"YGEO", 4, 53154},
	{"YGEN", 4, 31281},
	{"YGEM", 4, 172479},
	{"YGEL", 4, 152659},
	{"YGEI", 4, 132622},
	{"YGEE", 4, 146070},
	{"YGEA", 4, 107224},
	{"YGE", 3, 788},
	{"YGDA", 4, 216649},
	{"YGD", 3, 39082},
	{"YGC", 3, 46158},
	{"YGB", 3, 42672},
	{"YGAZ", 4, 130471},
	{"YGAY", 4, 84203},
	{"YGAX", 4, 258526},
	{"YGAV", 4, 48283},
	{"YGAU", 4, 126714},
	{"YGAT", 4, 62558},
	{"YGAS", 4, 83570},
	{"YGAR", 4, 49776},
	{"YGAP", 4, 123322},
	{"YGAO", 4, 239324},
	{"YGAN", 4, 79956},
	{"YGAM", 4, 37530},
	{"YGAL", 4, 66287},
	{"YGAI", 4, 54606},
	{"YGAG", 4, 104564},
	{"YGAE", 4, 226228},
	{"YGAD", 4, 166454},
	{"YGAB", 4, 132103},
	{"YGAA", 4, 226492},
	{"YGA", 3, 829},
	{"YFZ", 3, 253498},
	{"YFY", 3, 39685},
	{"YFX", 3, 59174},
	{"YFW", 3, 55438},
	{"YFV", 3, 114466},
	{"YFUZ", 4, 257775},
	{"YFUT", 4, 71151},
	{"YFUS", 4, 97616},
	{"YFUR", 4, 55272},
	{"YFUN", 4, 37875},
	{"YFUM", 4, 155557},
	{"YFUL", 4, 49765},
	{"YFUJ", 4, 241861},
	{"YFUG", 4, 167829},
	{"YFUE", 4, 92089},
	{"YFUC", 4, 177606},
	{"YFSY", 4, 213211},
	{"YFRY", 4, 180872},
	{"YFRU", 4, 71828},
	{"YFRO", 4, 3889},
	{"YFRI", 4, 31852},
	{"YFRE", 4, 38193},
	{"YFRA", 4, 42213},
	{"YFR", 3, 715},
	{"YFQ", 3, 230193},
	{"YFP", 3, 218273},
	{"YFOY", 4, 258527},
	{"YFOX", 4, 79987},
	{"YFOW", 4, 222851},
	{"YFOU", 4, 29238},
	{"YFOS", 4, 106336},
	{"YFOO", 4, 41085},
	{"YFON", 4, 94128},
	{"YFOL", 4, 38595},
	{"YFOI", 4, 219286},
	{"YFOG", 4, 163413},
	{"YFOE", 4, 217478},
	{"YFOC", 4, 49526},
	{"YFOA", 4, 234881},
	{"YFO", 3, 697},
	{"YFLY", 4, 73259},
	{"YFLU", 4, 83367},
	{"YFLO", 4, 46520},
	{"YFLI", 4, 63581},
	{"YFLE", 4, 59245},
	{"YFLA", 4, 47816},
	{"YFK", 3, 68535},
	{"YFJ", 3, 72838},
	{"YFIX", 4, 81751},
	{"YFIV", 4, 41726},
	{"YFIT", 4, 59485},
	{"YFIS", 4, 53671},
	{"YFIR", 4, 31535},
	{"YFIO", 4, 179662},
	{"YFIN", 4, 30783},
	{"YFIL", 4, 41177},
	{"YFIG", 4, 44866},
	{"YFIF", 4, 79722},
	{"YFIE", 4, 48229},
	{"YFID", 4, 166364},
	{"YFIC", 4, 106801},
	{"YFIB", 4, 146927},
	{"YFIA", 4, 146872},
	{"YFI", 3, 741},
	{"YFG", 3, 55026},
	{"YFFE", 4, 261191},
	{"YFF", 3, 34524},
	{"YFEW", 4, 46539},
	{"YFEV", 4, 189012},
	{"YFEU", 4, 142335},
	{"YFET", 4, 158357},
	{"YFES", 4, 77592},
	{"YFER", 4, 65246},
	{"YFEN", 4, 107259},
	{"YFEM", 4, 68911},
	{"YFEL", 4, 42673},
	{"YFEI", 4, 169619},
	{"YFEE", 4, 37870},
	{"YFED", 4, 63911},
	{"YFEB", 4, 56252},
	{"YFEA", 4, 43262},
	{"YFE", 3, 803},
	{"YFD", 3, 45506},
	{"YFC", 3, 188358},
	{"YFBI", 4, 228462},
	{"YFB", 3, 42713},
	{"YFAY", 4, 187027},
	{"YFAX", 4, 253879},
	{"YFAW", 4, 218409},
	{"YFAV", 4, 44928},
	{"YFAU", 4, 98961},
	{"YFAT", 4, 47279},
	{"YFAS", 4, 50909},
	{"YFAR", 4, 39881},
	{"YFAN", 4, 49311},
	{"YFAM", 4, 38082},
	{"YFAL", 4, 46619},
	{"YFAK", 4, 144077},
	{"YFAI", 4, 40190},
	{"YFAD", 4, 110864},
	{"YFAC", 4, 37839},
	{"YFAB", 4, 102014},
	{"YFA", 3, 753},
	{"YF", 2, 278},
	{"YEZI", 4, 225786},
	{"YEZDK", 5, 180712},
	{"YEYE", 4, 56318},
	{"YEYA", 4, 226493},
	{"YEXU", 4, 250809},
	{"YEXT", 4, 44986},
	{"YEXP", 4, 9827},
	{"YEXO", 4, 144521},
	{"YEXI", 4, 50008},
	{"YEXH", 4, 74212},
	{"YEXE", 4, 50816},
	{"YEXC", 4, 39617},
	{"YEXA", 4, 53903},
	{"YEX", 3, 766},
	{"YEWU", 4, 234882},
	{"YEWO", 4, 167907},
	{"YEWI", 4, 75711},
	{"YEWH", 4, 103717},
	{"YEWE", 4, 85166},
	{"YEWA", 4, 90182},
	{"YEVW", 4, 183972},
	{"YEVT", 4, 235773},
	{"YEVS", 4, 125212},
	{"YEVO", 4, 75820},
	{"YEVI", 4, 59176},
	{"YEVGENY", 7, 145202},
	{"YEVG", 4, 187583},
	{"YEVE", 4, 8440},
	{"YEVAUD", 6, 256079},
	{"YEVA", 4, 60096},
	{"YEUX", 4, 121538},
	{"YEUS", 4, 200367},
	{"YEUR", 4, 62160},
	{"YEUP", 4, 227931},
	{"YEUNG", 5, 91997},
	{"YEUN", 4, 178174},
	{"YEUG", 4, 168621},
	{"YEUC", 4, 195570},
	{"YETY", 4, 112943},
	{"YETW", 4, 62222},
	{"YETV", 4, 158209},
	{"YETU", 4, 86900},
	{"YETTER", 6, 254987},
	{"YETT", 4, 32328},
	{"YETR", 4, 74893},
	{"YETP", 4, 85598},
	{"YETM", 4, 73474},
	{"YETL", 4, 104596},
	{"YETK", 4, 117131},
	{"YETJ", 4, 168180},
	{"YETISPORTS", 10, 255863},
	{"YETG", 4, 119675},
	{"YETF", 4, 74555},
	{"YETD", 4, 79730},
	{"YETC", 4, 61780},
	{"YETB", 4, 53161},
	{"YET", 3, 1232},
	{"YESY", 4, 89287},
	{"YESW", 4, 50996},
	{"YESV", 4, 122484},
	{"YESTERYEARS", 11, 257123},
	{"YESTERYEAR", 10, 87517},
	{"YESTERDAYS", 10, 83994},
	{"YESTERDAY", 9, 4421},
	{"YESTER", 6, 188737},
	{"YESSY", 5, 260236},
	{"YESSSS", 6, 245626},
	{"YESSS", 5, 204457},
	{"YESSIR", 6, 249978},
	{"YESR", 4, 96323},
	{"YESQ", 4, 187584},
	{"YESP", 4, 49972},
	{"YESNO", 5, 221017},
	{"YESM", 4, 78381},
	{"YESL", 4, 89221},
	{"YESK", 4, 141632},
	{"YESJ", 4, 150152},
	{"YESHUA", 6, 117123},
	{"YESHIVA", 7, 89836},
	{"YESHE", 5, 249228},
	{"YESHA", 5, 237762},
	{"YESG", 4, 104437},
	{"YESF", 4, 77859},
	{"YESDIRECT", 9, 116821},
	{"YESD", 4, 93901},
	{"YESC", 4, 51866},
	{"YESB", 4, 63865},
	{"YESASIA", 7, 248694},
	{"YES", 3, 1153},
	{"YERY", 4, 124415},
	{"YERW", 4, 37602},
	{"YERV", 4, 109394},
	{"YERUSHALAYIM", 12, 185015},
	{"YERU", 4, 82215},
	{"YERT", 4, 38467},
	{"YERSINIA", 8, 105509},
	{"YERSELF", 7, 241814},
	{"YERS", 4, 224514},
	{"YERR", 4, 54465},
	{"YERQ", 4, 241862},
	{"YERP", 4, 57534},
	{"YERO", 4, 37312},
	{"YERN", 4, 61204},
	{"YERMO", 5, 224510},
	{"YERM", 4, 46157},
	{"YERL", 4, 64459},
	{"YERKES", 6, 151528},
	{"YERK", 4, 102727},
	{"YERJ", 4, 89069},
	{"YERINGTON", 9, 185009},
	{"YERI", 4, 35681},
	{"YERH", 4, 47947},
	{"YERG", 4, 66953},
	{"YEREVAN", 7, 77515},
	{"YERD", 4, 54472},
	{"YERC", 4, 44032},
	{"YERBA", 5, 85619},
	{"YERB", 4, 50429},
	{"YERA", 4, 34646},
	{"YEQU", 4, 49461},
	{"YEQ", 3, 2141},
	{"YEPT", 4, 182518},
	{"YEPS", 4, 209488},
	{"YEPR", 4, 145409},
	{"YEPPOON", 7, 199447},
	{"YEPP", 4, 106668},
	{"YEPO", 4, 125487},
	{"YEPL", 4, 236076},
	{"YEPI", 4, 63223},
	{"YEPH", 4, 215452},
	{"YEPE", 4, 196293},
	{"YEPA", 4, 116153},
	{"YEOW", 4, 260426},
	{"YEOVIL", 6, 79442},
	{"YEOV", 4, 183007},
	{"YEOU", 4, 143254},
	{"YEOR", 4, 153840},
	{"YEOP", 4, 114588},
	{"YEONG", 5, 108431},
	{"YEOMEN", 6, 201375},
	{"YEOMANS", 7, 149062},
	{"YEOMANRY", 8, 196748},
	{"YEOMAN", 6, 93194},
	{"YEOF", 4, 79479},
	{"YENW", 4, 153073},
	{"YENV", 4, 65351},
	{"YENU", 4, 192485},
	{"YENTA", 5, 198482},
	{"YENROTTA", 8, 247164},
	{"YENR", 4, 80855},
	{"YENQ", 4, 247235},
	{"YENP", 4, 185093},
	{"YENM", 4, 185862},
	{"YENL", 4, 98627},
	{"YENK", 4, 217703},
	{"YENJ", 4, 52841},
	{"YENF", 4, 88265},
	{"YENC", 4, 137534},
	{"YENB", 4, 164889},
	{"YEMU", 4, 168362},
	{"YEMS", 4, 223987},
	{"YEMO", 4, 75174},
	{"YEMM", 4, 140317},
	{"YEMENITE", 8, 221684},
	{"YEMENI", 6, 105611},
	{"YEMEN", 5, 34230},
	{"YEME", 4, 50273},
	{"YEMB", 4, 60370},
	{"YEMASSEE", 8, 256063},
	{"YEMA", 4, 205261},
	{"YELVERTON", 9, 161602},
	{"YELV", 4, 164298},
	{"YELU", 4, 173145},
	{"YELTSIN", 7, 83845},
	{"YELTON", 6, 228549},
	{"YELT", 4, 121688},
	{"YELS", 4, 53675},
	{"YELPS", 5, 244071},
	{"YELPING", 7, 237580},
	{"YELPED", 6, 199992},
	{"YELP", 4, 84384},
	{"YELOW", 5, 198257},
	{"YELO", 4, 170240},
	{"YELM", 4, 164408},
	{"YELLVILLE", 9, 249383},
	{"YELLSINGER", 10, 233944},
	{"YELLS", 5, 87261},
	{"YELLOWTHROAT", 12, 239211},
	{"YELLOWTAIL", 10, 132068},
	{"YELLOWSTONE", 11, 47569},
	{"YELLOWS", 7, 98669},
	{"YELLOWPAGES", 11, 73270},
	{"YELLOWMAN", 9, 206002},
	{"YELLOWLEGS", 10, 184578},
	{"YELLOWKNIFE", 11, 97941},
	{"YELLOWJACKETS", 13, 166111},
	{"YELLOWJACKET", 12, 249991},
	{"YELLOWISH", 9, 81160},
	{"YELLOWING", 9, 100163},
	{"YELLOWHEAD", 10, 180953},
	{"YELLOWHAMMER", 12, 257153},
	{"YELLOWFIN", 9, 121297},
	{"YELLOWED", 8, 154079},
	{"YELLOWDOG", 9, 153172},
	{"YELLOWCARD", 10, 81044},
	{"YELLOWCAKE", 10, 185443},
	{"YELLOWBRIX", 10, 157563},
	{"YELLOW", 6, 5027},
	{"YELLOE", 6, 254439},
	{"YELLO", 5, 103502},
	{"YELLING", 7, 54773},
	{"YELLIN", 6, 163945},
	{"YELLER", 6, 165743},
	{"YELLEN", 6, 244167},
	{"YELLED", 6, 57762},
	{"YELLA", 5, 250724},
	{"YELL", 4, 8017},
	{"YELK", 4, 230836},
	{"YELI", 4, 52316},
	{"YELF", 4, 245110},
	{"YELEY", 5, 247722},
	{"YELENA", 6, 157377},
	{"YELE", 4, 36079},
	{"YELD", 4, 111488},
	{"YELC", 4, 259271},
	{"YELB", 4, 188279},
	{"YELA", 4, 89070},
	{"YEKI", 4, 235774},
	{"YEKATERINBURG", 13, 188256},
	{"YEKA", 4, 161679},
	{"YEJE", 4, 200733},
	{"YEJ", 3, 35146},
	{"YEILOW", 6, 236498},
	{"YEIL", 4, 249112},
	{"YEIG", 4, 54453},
	{"YEHUDIT", 7, 242117},
	{"YEHUDI", 6, 186310},
	{"YEHUDAH", 7, 192061},
	{"YEHUDA", 6, 99764},
	{"YEHU", 4, 146339},
	{"YEHOSHUA", 8, 163260},
	{"YEHEY", 5, 243554},
	{"YEGY", 4, 135729},
	{"YEGR", 4, 183236},
	{"YEGO", 4, 130472},
	{"YEGL", 4, 145745},
	{"YEGI", 4, 235481},
	{"YEGG", 4, 115016},
	{"YEGA", 4, 160403},
	{"YEFR", 4, 160483},
	{"YEFO", 4, 94744},
	{"YEFI", 4, 152921},
	{"YEFF", 4, 41894},
	{"YEFA", 4, 176885},
	{"YEF", 3, 1315},
	{"YEEX", 4, 224189},
	{"YEEW", 4, 89182},
	{"YEEV", 4, 250457},
	{"YEEU", 4, 195571},
	{"YEESH", 5, 217110},
	{"YEER", 4, 103693},
	{"YEEP", 4, 134344},
	{"YEEM", 4, 143892},
	{"YEEL", 4, 158138},
	{"YEEHAW", 6, 242228},
	{"YEEG", 4, 202047},
	{"YEEF", 4, 130617},
	{"YEED", 4, 133858},
	{"YEEC", 4, 116514},
	{"YEEB", 4, 123538},
	{"YEDY", 4, 114033},
	{"YEDW", 4, 37799},
	{"YEDV", 4, 88118},
	{"YEDU", 4, 43173},
	{"YEDT", 4, 29428},
	{"YEDS", 4, 43992},
	{"YEDR", 4, 64895},
	{"YEDQ", 4, 154966},
	{"YEDP", 4, 55425},
	{"YEDO", 4, 37944},
	{"YEDN", 4, 75007},
	{"YEDM", 4, 49606},
	{"YEDL", 4, 64128},
	{"YEDK", 4, 124622},
	{"YEDJ", 4, 93300},
	{"YEDIOT", 6, 247703},
	{"YEDI", 4, 29257},
	{"YEDH", 4, 44255},
	{"YEDG", 4, 56018},
	{"YEDF", 4, 38142},
	{"YEDE", 4, 61562},
	{"YEDD", 4, 57502},
	{"YEDC", 4, 56617},
	{"YEDB", 4, 31607},
	{"YEDA", 4, 9081},
	{"YECU", 4, 239037},
	{"YECO", 4, 50952},
	{"YECL", 4, 130965},
	{"YECK", 4, 224864},
	{"YECC", 4, 160963},
	{"YECA", 4, 89448},
	{"YEBY", 4, 141418},
	{"YEBU", 4, 148530},
	{"YEBR", 4, 81198},
	{"YEBO", 4, 169620},
	{"YEBL", 4, 211067},
	{"YEBI", 4, 221499},
	{"YEBA", 4, 91266},
	{"YEB", 3, 2575},
	{"YEATS", 5, 67363},
	{"YEATES", 6, 169037},
	{"YEASTY", 6, 261848},
	{"YEASTS", 6, 103658},
	{"YEAST", 5, 34304},
	{"YEARWOOD", 8, 113747},
	{"YEARS", 5, 901},
	{"YEAROLD", 7, 218707},
	{"YEARNS", 6, 147639},
	{"YEARNINGS", 9, 179860},
	{"YEARNING", 8, 69606},
	{"YEARNED", 7, 145846},
	{"YEARN", 5, 98754},
	{"YEARLY", 6, 34904},
	{"YEARLONG", 8, 124810},
	{"YEARLINGS", 9, 146484},
	{"YEARLING", 8, 86693},
	{"YEAREND", 7, 181556},
	{"YEARBOOKS", 9, 87941},
	{"YEARBOOK", 8, 47577},
	{"YEAR", 4, 630},
	{"YEAP", 4, 189745},
	{"YEAMAN", 6, 215981},
	{"YEAM", 4, 216451},
	{"YEAL", 4, 154445},
	{"YEAHS", 5, 107163},
	{"YEAH", 4, 1429},
	{"YEAGER", 6, 84537},
	{"YEAG", 4, 85900},
	{"YEAF", 4, 226970},
	{"YEADON", 6, 130713},
	{"YEAD", 4, 199176},
	{"YEAC", 4, 51156},
	{"YEAB", 4, 252826},
	{"YDZ", 3, 51333},
	{"YDYS", 4, 171670},
	{"YDYNT", 5, 226676},
	{"YDYN", 4, 108239},
	{"YDYM", 4, 258668},
	{"YDYL", 4, 225317},
	{"YDYI", 4, 127484},
	{"YDYE", 4, 191776},
	{"YDYCH", 5, 132754},
	{"YDX", 3, 90932},
	{"YDWR", 4, 165813},
	{"YDWO", 4, 198210},
	{"YDWI", 4, 127800},
	{"YDWH", 4, 166123},
	{"YDWE", 4, 100250},
	{"YDWA", 4, 106517},
	{"YDVD", 4, 136506},
	{"YDV", 3, 30481},
	{"YDUT", 4, 66577},
	{"YDUS", 4, 118587},
	{"YDUR", 4, 35928},
	{"YDUP", 4, 133911},
	{"YDUO", 4, 205734},
	{"YDUN", 4, 77920},
	{"YDUM", 4, 85288},
	{"YDUL", 4, 149258},
	{"YDUK", 4, 123559},
	{"YDUG", 4, 141900},
	{"YDUF", 4, 158944},
	{"YDUE", 4, 43631},
	{"YDUD", 4, 144820},
	{"YDUC", 4, 101530},
	{"YDUB", 4, 93561},
	{"YDUA", 4, 157894},
	{"YDU", 3, 865},
	{"YDTO", 4, 171283},
	{"YDTH", 4, 135201},
	{"YDTA", 4, 227199},
	{"YDT", 3, 8210},
	{"YDSW", 4, 256655},
	{"YDST", 4, 115991},
	{"YDSS", 4, 233842},
	{"YDSR", 4, 256656},
	{"YDSP", 4, 206272},
	{"YDSO", 4, 189013},
	{"YDSM", 4, 236336},
	{"YDSI", 4, 221930},
	{"YDSH", 4, 189279},
	{"YDSE", 4, 164459},
	{"YDSC", 4, 192205},
	{"YDSB", 4, 204134},
	{"YDSA", 4, 106993},
	{"YDRY", 4, 88321},
	{"YDRW", 4, 232090},
	{"YDRU", 4, 60458},
	{"YDRT", 4, 260045},
	{"YDRS", 4, 166217},
	{"YDRR", 4, 201061},
	{"YDRP", 4, 243615},
	{"YDRO", 4, 35132},
	{"YDRM", 4, 154899},
	{"YDRL", 4, 247236},
	{"YDRK", 4, 257776},
	{"YDRJ", 4, 179083},
	{"YDRI", 4, 39524},
	{"YDRH", 4, 229498},
	{"YDRG", 4, 237060},
	{"YDRE", 4, 48385},
	{"YDRD", 4, 207724},
	{"YDRC", 4, 201395},
	{"YDRB", 4, 194343},
	{"YDR", 3, 794},
	{"YDQ", 3, 204809},
	{"YDPR", 4, 176886},
	{"YDPL", 4, 255639},
	{"YDPA", 4, 187731},
	{"YDOZ", 4, 132265},
	{"YDOY", 4, 66514},
	{"YDOW", 4, 39836},
	{"YDOV", 4, 142992},
	{"YDOU", 4, 48949},
	{"YDOT", 4, 55442},
	{"YDOS", 4, 63345},
	{"YDOR", 4, 74335},
	{"YDOP", 4, 105773},
	{"YDOO", 4, 69781},
	{"YDON", 4, 8235},
	{"YDOM", 4, 55102},
	{"YDOL", 4, 66968},
	{"YDOK", 4, 206836},
	{"YDOJ", 4, 256657},
	{"YDOI", 4, 46655},
	{"YDOH", 4, 91587},
	{"YDOG", 4, 63104},
	{"YDOF", 4, 113018},
	{"YDOE", 4, 35596},
	{"YDOD", 4, 101642},
	{"YDOC", 4, 48090},
	{"YDOB", 4, 97094},
	{"YDOA", 4, 72433},
	{"YDO", 3, 722},
	{"YDNS", 4, 199021},
	{"YDNO", 4, 188702},
	{"YDNE", 4, 40930},
	{"YDNA", 4, 146071},
	{"YDMO", 4, 226229},
	{"YDMI", 4, 194497},
	{"YDMA", 4, 102669},
	{"YDM", 3, 7022},
	{"YDLO", 4, 174853},
	{"YDLI", 4, 121100},
	{"YDLE", 4, 191631},
	{"YDLA", 4, 177368},
	{"YDL", 3, 144234},
	{"YDK", 3, 42714},
	{"YDJU", 4, 226494},
	{"YDJO", 4, 232646},
	{"YDJ", 3, 29504},
	{"YDIX", 4, 170166},
	{"YDIV", 4, 41523},
	{"YDIT", 4, 149974},
	{"YDIS", 4, 7329},
	{"YDIR", 4, 43842},
	{"YDIP", 4, 98492},
	{"YDIO", 4, 128657},
	{"YDIN", 4, 66734},
	{"YDIM", 4, 225650},
	{"YDIL", 4, 100475},
	{"YDIG", 4, 68336},
	{"YDIF", 4, 29251},
	{"YDIERESIS", 9, 231304},
	{"YDIE", 4, 47401},
	{"YDID", 4, 8544},
	{"YDIC", 4, 70949},
	{"YDIA", 4, 55497},
	{"YDHO", 4, 225787},
	{"YDHI", 4, 247237},
	{"YDHE", 4, 223745},
	{"YDHA", 4, 90553},
	{"YDH", 3, 6140},
	{"YDGR", 4, 257388},
	{"YDGO", 4, 172588},
	{"YDGE", 4, 127851},
	{"YDGA", 4, 196453},
	{"YDG", 3, 8542},
	{"YDFO", 4, 204852},
	{"YDFI", 4, 178966},
	{"YDF", 3, 29923},
	{"YDEX", 4, 184353},
	{"YDEW", 4, 107886},
	{"YDEV", 4, 35991},
	{"YDEU", 4, 153773},
	{"YDET", 4, 42695},
	{"YDES", 4, 29673},
	{"YDER", 4, 41469},
	{"YDEP", 4, 35717},
	{"YDEO", 4, 173061},
	{"YDEN", 4, 42122},
	{"YDEM", 4, 40709},
	{"YDEL", 4, 43573},
	{"YDEK", 4, 226971},
	{"YDEJ", 4, 226230},
	{"YDEI", 4, 124485},
	{"YDEH", 4, 141848},
	{"YDEG", 4, 66541},
	{"YDEF", 4, 33969},
	{"YDEE", 4, 58714},
	{"YDED", 4, 75188},
	{"YDEC", 4, 29928},
	{"YDEB", 4, 54551},
	{"YDEA", 4, 40673},
	{"YDDO", 4, 171772},
	{"YDDI", 4, 185481},
	{"YDDE", 4, 207542},
	{"YDDA", 4, 158042},
	{"YDD", 3, 6661},
	{"YDCO", 4, 118774},
	{"YDCH", 4, 243616},
	{"YDCC", 4, 210293},
	{"YDCA", 4, 165997},
	{"YDBU", 4, 241583},
	{"YDBR", 4, 183973},
	{"YDBO", 4, 254922},
	{"YDBL", 4, 255640},
	{"YDBE", 4, 80388},
	{"YDBA", 4, 159094},
	{"YDB", 3, 4422},
	{"YDAZ", 4, 227455},
	{"YDAW", 4, 106838},
	{"YDAV", 4, 47155},
	{"YDAU", 4, 59499},
	{"YDAT", 4, 51542},
	{"YDAS", 4, 114860},
	{"YDAR", 4, 54746},
	{"YDAP", 4, 197109},
	{"YDAN", 4, 42301},
	{"YDAM", 4, 47212},
	{"YDAL", 4, 71864},
	{"YDAI", 4, 82069},
	{"YDAH", 4, 143255},
	{"YDAG", 4, 199177},
	{"YDAF", 4, 231824},
	{"YDAD", 4, 58172},
	{"YDAC", 4, 179084},
	{"YDAB", 4, 208916},
	{"YCZE", 4, 181457},
	{"YCZA", 4, 214404},
	{"YCZ", 3, 34196},
	{"YCYR", 4, 130263},
	{"YCYP", 4, 253880},
	{"YCYN", 4, 153074},
	{"YCYL", 4, 250104},
	{"YCYC", 4, 90466},
	{"YCYB", 4, 178299},
	{"YCY", 3, 4152},
	{"YCX", 3, 124475},
	{"YCW", 3, 41439},
	{"YCUT", 4, 45350},
	{"YCUS", 4, 63722},
	{"YCUR", 4, 47897},
	{"YCUP", 4, 55171},
	{"YCUN", 4, 150667},
	{"YCUL", 4, 60238},
	{"YCUE", 4, 187862},
	{"YCUB", 4, 105935},
	{"YCU", 3, 938},
	{"YCTO", 4, 253531},
	{"YCTH", 4, 223292},
	{"YCRY", 4, 85068},
	{"YCRU", 4, 59372},
	{"YCRO", 4, 43008},
	{"YCRI", 4, 38962},
	{"YCRE", 4, 35540},
	{"YCRA", 4, 47591},
	{"YCR", 3, 813},
	{"YCQ", 3, 103751},
	{"YCOY", 4, 188280},
	{"YCOX", 4, 117859},
	{"YCOW", 4, 82449},
	{"YCOV", 4, 51154},
	{"YCOU", 4, 4963},
	{"YCOT", 4, 57359},
	{"YCOR", 4, 38053},
	{"YCOO", 4, 43971},
	{"YCON", 4, 3295},
	{"YCOMP", 5, 171060},
	{"YCOM", 4, 3770},
	{"YCOL", 4, 29037},
	{"YCOK", 4, 232363},
	{"YCOI", 4, 84830},
	{"YCOH", 4, 106654},
	{"YCOG", 4, 127614},
	{"YCOF", 4, 96855},
	{"YCOE", 4, 127379},
	{"YCOD", 4, 73113},
	{"YCOC", 4, 87039},
	{"YCOB", 4, 112129},
	{"YCOA", 4, 45776},
	{"YCO", 3, 644},
	{"YCNN", 4, 147150},
	{"YCMI", 4, 246325},
	{"YCMA", 4, 245738},
	{"YCM", 3, 30490},
	{"YCLY", 4, 240728},
	{"YCLU", 4, 44280},
	{"YCLO", 4, 31100},
	{"YCLI", 4, 31330},
	{"YCLA", 4, 34519},
	{"YCL", 3, 245572},
	{"YCKO", 4, 229223},
	{"YCKI", 4, 197252},
	{"YCKE", 4, 239855},
	{"YCK", 3, 8683},
	{"YCJ", 3, 48179},
	{"YCIV", 4, 75718},
	{"YCIT", 4, 40157},
	{"YCIS", 4, 163241},
	{"YCIR", 4, 58185},
	{"YCIN", 4, 90316},
	{"YCIG", 4, 185863},
	{"YCID", 4, 229980},
	{"YCIC", 4, 232364},
	{"YCIA", 4, 142602},
	{"YCI", 3, 1043},
	{"YCHYDIG", 7, 255958},
	{"YCHWANEGU", 9, 210167},
	{"YCHWANEGOL", 10, 175440},
	{"YCHW", 4, 176652},
	{"YCHU", 4, 53335},
	{"YCHT", 4, 206996},
	{"YCHS", 4, 164460},
	{"YCHR", 4, 43584},
	{"YCHO", 4, 29437},
	{"YCHL", 4, 179446},
	{"YCHI", 4, 30248},
	{"YCHH", 4, 249435},
	{"YCHE", 4, 36080},
	{"YCHA", 4, 6850},
	{"YCG", 3, 48573},
	{"YCF", 3, 37876},
	{"YCEW", 4, 121942},
	{"YCEU", 4, 152580},
	{"YCET", 4, 123323},
	{"YCES", 4, 84490},
	{"YCER", 4, 51838},
	{"YCEP", 4, 149579},
	{"YCEO", 4, 106253},
	{"YCEN", 4, 123162},
	{"YCEM", 4, 80493},
	{"YCEL", 4, 48955},
	{"YCEK", 4, 215651},
	{"YCEJ", 4, 227709},
	{"YCEI", 4, 135024},
	{"YCEH", 4, 144730},
	{"YCEG", 4, 192620},
	{"YCEF", 4, 182635},
	{"YCEE", 4, 120545},
	{"YCED", 4, 111824},
	{"YCEC", 4, 112130},
	{"YCEB", 4, 143459},
	{"YCEA", 4, 78460},
	{"YCE", 3, 849},
	{"YCDS", 4, 219729},
	{"YCD", 3, 30643},
	{"YCCO", 4, 257389},
	{"YCC", 3, 200335},
	{"YCBS", 4, 136285},
	{"YCBCR", 5, 147857},
	{"YCBC", 4, 207200},
	{"YCB", 3, 9806},
	{"YCAV", 4, 90554},
	{"YCAU", 4, 41895},
	{"YCAT", 4, 43165},
	{"YCAS", 4, 37030},
	{"YCAP", 4, 40821},
	{"YCAO", 4, 228463},
	{"YCAN", 4, 5159},
	{"YCAM", 4, 32833},
	{"YCAL", 4, 29496},
	{"YCAK", 4, 132927},
	{"YCAI", 4, 150087},
	{"YCAH", 4, 227200},
	{"YCAG", 4, 165814},
	{"YCAF", 4, 128232},
	{"YCAE", 4, 162697},
	{"YCAD", 4, 109514},
	{"YCAC", 4, 163319},
	{"YCAB", 4, 74078},
	{"YBZ", 3, 96847},
	{"YBYZ", 4, 193625},
	{"YBYY", 4, 179872},
	{"YBYW", 4, 77907},
	{"YBYV", 4, 115642},
	{"YBYU", 4, 104882},
	{"YBYT", 4, 37573},
	{"YBYS", 4, 54983},
	{"YBYR", 4, 66961},
	{"YBYP", 4, 54742},
	{"YBYO", 4, 87927},
	{"YBYN", 4, 86558},
	{"YBYM", 4, 63439},
	{"YBYL", 4, 82580},
	{"YBYK", 4, 126473},
	{"YBYJ", 4, 96540},
	{"YBYI", 4, 79845},
	{"YBYH", 4, 64815},
	{"YBYG", 4, 88276},
	{"YBYF", 4, 77287},
	{"YBYE", 4, 79663},
	{"YBYD", 4, 68849},
	{"YBYC", 4, 61392},
	{"YBYB", 4, 70929},
	{"YBYA", 4, 48216},
	{"YBY", 3, 791},
	{"YBX", 3, 134164},
	{"YBV", 3, 73003},
	{"YBUZ", 4, 148603},
	{"YBUY", 4, 57562},
	{"YBUT", 4, 5612},
	{"YBUS", 4, 38821},
	{"YBUR", 4, 44948},
	{"YBUO", 4, 211994},
	{"YBUN", 4, 85000},
	{"YBUM", 4, 105901},
	{"YBUL", 4, 63964},
	{"YBUI", 4, 37954},
	{"YBUG", 4, 104306},
	{"YBUF", 4, 97969},
	{"YBUE", 4, 237344},
	{"YBUD", 4, 61374},
	{"YBUC", 4, 73399},
	{"YBUB", 4, 137589},
	{"YBU", 3, 724},
	{"YBRY", 4, 116339},
	{"YBRU", 4, 62752},
	{"YBRO", 4, 33199},
	{"YBRI", 4, 31013},
	{"YBRE", 4, 41663},
	{"YBRA", 4, 43001},
	{"YBR", 3, 773},
	{"YBQ", 3, 137025},
	{"YBP", 3, 239240},
	{"YBOY", 4, 47173},
	{"YBOX", 4, 71421},
	{"YBOW", 4, 66214},
	{"YBOU", 4, 48376},
	{"YBOT", 4, 37754},
	{"YBOS", 4, 73956},
	{"YBOR", 4, 143127},
	{"YBOP", 4, 254215},
	{"YBOO", 4, 39930},
	{"YBON", 4, 56784},
	{"YBOM", 4, 73078},
	{"YBOL", 4, 82814},
	{"YBOI", 4, 127055},
	{"YBOH", 4, 196150},
	{"YBOG", 4, 117008},
	{"YBOE", 4, 147479},
	{"YBOD", 4, 28891},
	{"YBOC", 4, 200909},
	{"YBOB", 4, 75092},
	{"YBOA", 4, 36667},
	{"YBO", 3, 726},
	{"YBMW", 4, 244800},
	{"YBMG", 4, 176887},
	{"YBLV", 4, 184850},
	{"YBLU", 4, 56009},
	{"YBLO", 4, 42444},
	{"YBLI", 4, 81942},
	{"YBLE", 4, 70448},
	{"YBLA", 4, 41040},
	{"YBL", 3, 929},
	{"YBK", 3, 54138},
	{"YBJ", 3, 41066},
	{"YBIZ", 4, 147817},
	{"YBIU", 4, 222852},
	{"YBIT", 4, 60475},
	{"YBIS", 4, 78433},
	{"YBIR", 4, 56700},
	{"YBIP", 4, 224627},
	{"YBIO", 4, 81950},
	{"YBIN", 4, 78454},
	{"YBIL", 4, 42784},
	{"YBIK", 4, 100758},
	{"YBIG", 4, 46874},
	{"YBIE", 4, 192911},
	{"YBID", 4, 109601},
	{"YBIC", 4, 118174},
	{"YBIB", 4, 111714},
	{"YBIA", 4, 112306},
	{"YBI", 3, 885},
	{"YBHA", 4, 168884},
	{"YBH", 3, 34027},
	{"YBG", 3, 54540},
	{"YBF", 3, 51334},
	{"YBEY", 4, 55941},
	{"YBEW", 4, 52647},
	{"YBEV", 4, 89939},
	{"YBEU", 4, 54622},
	{"YBET", 4, 8988},
	{"YBES", 4, 36543},
	{"YBER", 4, 36841},
	{"YBEQ", 4, 158514},
	{"YBEP", 4, 50445},
	{"YBEO", 4, 52447},
	{"YBEN", 4, 39828},
	{"YBEM", 4, 48820},
	{"YBEL", 4, 31909},
	{"YBEK", 4, 118562},
	{"YBEJ", 4, 90806},
	{"YBEI", 4, 30929},
	{"YBEH", 4, 40398},
	{"YBEG", 4, 34245},
	{"YBEF", 4, 32420},
	{"YBEE", 4, 30607},
	{"YBED", 4, 46795},
	{"YBEC", 4, 6048},
	{"YBEB", 4, 54889},
	{"YBEA", 4, 10035},
	{"YBDE", 4, 194079},
	{"YBD", 3, 37261},
	{"YBCW", 4, 249770},
	{"YBCT", 4, 157666},
	{"YBCS", 4, 240138},
	{"YBCO", 4, 185979},
	{"YBCI", 4, 259272},
	{"YBCE", 4, 126434},
	{"YBCA", 4, 156457},
	{"YBBC", 4, 145746},
	{"YBB", 3, 30222},
	{"YBAZ", 4, 241584},
	{"YBAY", 4, 78090},
	{"YBAX", 4, 247865},
	{"YBAU", 4, 138020},
	{"YBAT", 4, 49125},
	{"YBAS", 4, 32778},
	{"YBARRA", 6, 193741},
	{"YBAR", 4, 40920},
	{"YBAP", 4, 107453},
	{"YBAN", 4, 41701},
	{"YBAM", 4, 211808},
	{"YBAL", 4, 39774},
	{"YBAK", 4, 82590},
	{"YBAI", 4, 92156},
	{"YBAH", 4, 171284},
	{"YBAG", 4, 81491},
	{"YBAF", 4, 223527},
	{"YBAE", 4, 203972},
	{"YBAD", 4, 50529},
	{"YBAC", 4, 33459},
	{"YBAA", 4, 250810},
	{"YAZZIE", 6, 200502},
	{"YAZZ", 4, 230904},
	{"YAZOO", 5, 97029},
	{"YAZO", 4, 161123},
	{"YAZID", 5, 251704},
	{"YAZI", 4, 146284},
	{"YAZE", 4, 184726},
	{"YAZD", 4, 195548},
	{"YAZAKI", 6, 247443},
	{"YAZA", 4, 116195},
	{"YAYU", 4, 261563},
	{"YAYOO", 5, 190617},
	{"YAYOI", 5, 175444},
	{"YAYO", 4, 126860},
	{"YAYE", 4, 62304},
	{"YAYASAN", 7, 241830},
	{"YAYA", 4, 150330},
	{"YAXLEY", 6, 235730},
	{"YAXIS", 5, 201837},
	{"YAXI", 4, 162952},
	{"YAXE", 4, 203804},
	{"YAXAY", 5, 161894},
	{"YAWS", 4, 220654},
	{"YAWR", 4, 143950},
	{"YAWO", 4, 70081},
	{"YAWNS", 5, 158495},
	{"YAWNING", 7, 98870},
	{"YAWNER", 6, 261720},
	{"YAWNED", 6, 152370},
	{"YAWN", 4, 70970},
	{"YAWL", 4, 201003},
	{"YAWKEY", 6, 261920},
	{"YAWI", 4, 70785},
	{"YAWH", 4, 73363},
	{"YAWF", 4, 153646},
	{"YAWE", 4, 63500},
	{"YAVUZ", 5, 252616},
	{"YAVO", 4, 60761},
	{"YAVIN", 5, 203194},
	{"YAVI", 4, 65110},
	{"YAVE", 4, 49061},
	{"YAVAPAI", 7, 105307},
	{"YAVA", 4, 41739},
	{"YAV", 3, 997},
	{"YAUX", 4, 255982},
	{"YAUT", 4, 45590},
	{"YAUS", 4, 57930},
	{"YAUR", 4, 165238},
	{"YAUOO", 5, 177767},
	{"YAUN", 4, 85367},
	{"YAUM", 4, 233843},
	{"YAUG", 4, 51631},
	{"YAUD", 4, 68302},
	{"YAUC", 4, 118504},
	{"YAUB", 4, 189280},
	{"YATZ", 4, 250105},
	{"YATY", 4, 99369},
	{"YATW", 4, 55252},
	{"YATV", 4, 102499},
	{"YATU", 4, 79709},
	{"YATTON", 6, 204468},
	{"YATTA", 5, 201701},
	{"YATT", 4, 5763},
	{"YATSURA", 7, 95728},
	{"YATRA", 5, 127480},
	{"YATR", 4, 51179},
	{"YATQ", 4, 171188},
	{"YATP", 4, 44390},
	{"YATM", 4, 56138},
	{"YATL", 4, 48273},
	{"YATK", 4, 91171},
	{"YATJ", 4, 117038},
	{"YATG", 4, 81590},
	{"YATF", 4, 67694},
	{"YATES", 5, 48522},
	{"YATELEY", 7, 188039},
	{"YATD", 4, 80342},
	{"YATC", 4, 57609},
	{"YATB", 4, 60196},
	{"YASY", 4, 71065},
	{"YASW", 4, 40018},
	{"YASV", 4, 122423},
	{"YASUYUKI", 8, 241214},
	{"YASUSHI", 7, 175058},
	{"YASUO", 5, 167022},
	{"YASUNORI", 8, 235958},
	{"YASUKUNI", 8, 152625},
	{"YASUKO", 6, 257598},
	{"YASUI", 5, 212542},
	{"YASUHIRO", 8, 154852},
	{"YASUHIKO", 8, 259601},
	{"YASUDA", 6, 128122},
	{"YASU", 4, 253252},
	{"YASSIR", 6, 218765},
	{"YASSIN", 6, 116391},
	{"YASSER", 6, 75274},
	{"YASR", 4, 76911},
	{"YASQ", 4, 134727},
	{"YASP", 4, 39243},
	{"YASMINE", 7, 97260},
	{"YASMIN", 6, 67116},
	{"YASMEEN", 7, 214284},
	{"YASL", 4, 59954},
	{"YASK", 4, 42858},
	{"YASJ", 4, 109032},
	{"YASIR", 5, 158088},
	{"YASIN", 5, 152611},
	{"YASHIN", 6, 210800},
	{"YASHICA", 7, 91824},
	{"YASHA", 5, 97773},
	{"YASG", 4, 81289},
	{"YASF", 4, 64061},
	{"YASER", 5, 177405},
	{"YASD", 4, 69506},
	{"YASC", 4, 49891},
	{"YASB", 4, 64984},
	{"YARW", 4, 185864},
	{"YARU", 4, 94036},
	{"YART", 4, 41741},
	{"YARROW", 6, 91458},
	{"YARRAWONGA", 10, 208735},
	{"YARRA", 5, 72497},
	{"YARR", 4, 241386},
	{"YARP", 4, 227201},
	{"YAROSLAVL", 9, 171354},
	{"YAROSLAV", 8, 145343},
	{"YARON", 5, 122551},
	{"YARO", 4, 249537},
	{"YARNS", 5, 57659},
	{"YARNELL", 7, 183327},
	{"YARN", 4, 36497},
	{"YARMULKE", 8, 253034},
	{"YARMOUTH", 8, 55463},
	{"YARM", 4, 157618},
	{"YARL", 4, 164009},
	{"YARK", 4, 116695},
	{"YARIS", 5, 113334},
	{"YARI", 4, 255598},
	{"YARH", 4, 239038},
	{"YARG", 4, 55880},
	{"YARED", 5, 232834},
	{"YARE", 4, 255034},
	{"YARDSTICKS", 10, 216575},
	{"YARDSTICK", 9, 94198},
	{"YARDS", 5, 7758},
	{"YARDMASTER", 10, 222009},
	{"YARDLINE", 8, 245507},
	{"YARDLEY", 7, 83147},
	{"YARDER", 6, 155056},
	{"YARDBIRDS", 9, 121761},
	{"YARDBIRD", 8, 250901},
	{"YARDAGE", 7, 76163},
	{"YARD", 4, 3026},
	{"YARC", 4, 53881},
	{"YARBROUGH", 9, 110609},
	{"YARBOROUGH", 10, 151124},
	{"YARB", 4, 90206},
	{"YARA", 4, 177473},
	{"YAQUINA", 7, 214731},
	{"YAQUI", 5, 175242},
	{"YAQU", 4, 67669},
	{"YAQ", 3, 4474},
	{"YAPU", 4, 91159},
	{"YAPT", 4, 175921},
	{"YAPR", 4, 40191},
	{"YAPPING", 7, 190724},
	{"YAPP", 4, 173948},
	{"YAPO", 4, 50975},
	{"YAPL", 4, 77377},
	{"YAPHANK", 7, 251939},
	{"YAPH", 4, 99259},
	{"YAPE", 4, 62055},
	{"YAPC", 4, 176455},
	{"YAPA", 4, 47586},
	{"YAOW", 4, 220364},
	{"YAOUNDE", 7, 154538},
	{"YAOU", 4, 221500},
	{"YAOR", 4, 123155},
	{"YAOOO", 5, 256430},
	{"YAOOH", 5, 209269},
	{"YAOM", 4, 134900},
	{"YAOL", 4, 194664},
	{"YAOHO", 5, 258097},
	{"YAOF", 4, 139079},
	{"YAOC", 4, 252482},
	{"YAOB", 4, 237345},
	{"YANZ", 4, 143204},
	{"YANY", 4, 36214},
	{"YANX", 4, 130618},
	{"YANW", 4, 63644},
	{"YANV", 4, 150337},
	{"YANUKOVYCH", 10, 176840},
	{"YANUKOVICH", 10, 238971},
	{"YANUK", 5, 184176},
	{"YANU", 4, 51516},
	{"YANTRAS", 7, 197971},
	{"YANTRA", 6, 128843},
	{"YANTIS", 6, 182475},
	{"YANTAI", 6, 176164},
	{"YANT", 4, 35793},
	{"YANR", 4, 77753},
	{"YANQ", 4, 245111},
	{"YANP", 4, 77449},
	{"YANOO", 5, 192731},
	{"YANOMAMI", 8, 240988},
	{"YANNIS", 6, 142317},
	{"YANNICK", 7, 124265},
	{"YANNI", 5, 114669},
	{"YANMAR", 6, 132047},
	{"YANM", 4, 56846},
	{"YANL", 4, 81127},
	{"YANKTON", 7, 97524},
	{"YANKS", 5, 78662},
	{"YANKOVIC", 8, 92299},
	{"YANKING", 7, 150140},
	{"YANKERS", 7, 227409},
	{"YANKEES", 7, 37260},
	{"YANKEE", 6, 37752},
	{"YANKED", 6, 101471},
	{"YANK", 4, 72785},
	{"YANJ", 4, 120341},
	{"YANIV", 5, 169061},
	{"YANIK", 5, 227667},
	{"YANGZHOU", 8, 167515},
	{"YANGTZE", 7, 84086},
	{"YANGSHUO", 8, 188611},
	{"YANGON", 6, 75382},
	{"YANGJIANG", 9, 256094},
	{"YANG", 4, 35732},
	{"YANF", 4, 82182},
	{"YANEZ", 5, 229281},
	{"YANDELL", 7, 192263},
	{"YANCY", 5, 145717},
	{"YANCEYVILLE", 11, 251322},
	{"YANCEY", 6, 86620},
	{"YANC", 4, 182615},
	{"YANBU", 5, 252618},
	{"YANB", 4, 71974},
	{"YANAI", 5, 262140},
	{"YANAGISAWA", 10, 171937},
	{"YANAGI", 6, 249235},
	{"YAMY", 4, 112755},
	{"YAMW", 4, 161362},
	{"YAMUNA", 6, 169180},
	{"YAMU", 4, 69679},
	{"YAMT", 4, 96100},
	{"YAMS", 4, 102247},
	{"YAMR", 4, 163509},
	{"YAMPA", 5, 144226},
	{"YAMP", 4, 92213},
	{"YAMO", 4, 39149},
	{"YAMN", 4, 152581},
	{"YAMM", 4, 116026},
	{"YAML", 4, 124940},
	{"YAMK", 4, 241294},
	{"YAMILA", 6, 214897},
	{"YAMI", 4, 129463},
	{"YAMHILL", 7, 119114},
	{"YAMH", 4, 170606},
	{"YAMG", 4, 260046},
	{"YAMF", 4, 200549},
	{"YAMES", 5, 226641},
	{"YAME", 4, 237904},
	{"YAMD", 4, 182636},
	{"YAMC", 4, 145268},
	{"YAMBOL", 6, 136055},
	{"YAMBA", 5, 176237},
	{"YAMB", 4, 69462},
	{"YAMAZAKI", 8, 111205},
	{"YAMAUCHI", 8, 156308},
	{"YAMATO", 6, 93087},
	{"YAMASHITA", 9, 107269},
	{"YAMASAKI", 8, 172325},
	{"YAMAOKA", 7, 219176},
	{"YAMANOUCHI", 10, 237189},
	{"YAMANE", 6, 192945},
	{"YAMANASHI", 9, 168700},
	{"YAMANAKA", 8, 172045},
	{"YAMAN", 5, 254526},
	{"YAMAMURA", 8, 215295},
	{"YAMAMOTO", 8, 59135},
	{"YAMAL", 5, 247451},
	{"YAMAKAWA", 8, 137317},
	{"YAMAHA", 6, 29604},
	{"YAMAGUCHI", 9, 83470},
	{"YAMAGATA", 8, 114638},
	{"YAMADA", 6, 69009},
	{"YAMA", 4, 118196},
	{"YALY", 4, 159095},
	{"YALW", 4, 55976},
	{"YALV", 4, 116802},
	{"YALTA", 5, 111798},
	{"YALT", 4, 33693},
	{"YALS", 4, 8423},
	{"YALR", 4, 55169},
	{"YALQ", 4, 163242},
	{"YALP", 4, 67756},
	{"YALOBUSHA", 9, 253311},
	{"YALO", 4, 36718},
	{"YALN", 4, 66020},
	{"YALMIP", 6, 241418},
	{"YALM", 4, 52975},
	{"YALLOCK", 7, 251960},
	{"YALLINGUP", 9, 217820},
	{"YALL", 4, 73716},
	{"YALK", 4, 152582},
	{"YALJ", 4, 192621},
	{"YALI", 4, 209469},
	{"YALH", 4, 80643},
	{"YALG", 4, 79614},
	{"YALF", 4, 58269},
	{"YALETOWN", 8, 206023},
	{"YALE", 4, 34308},
	{"YALDEX", 6, 258812},
	{"YALD", 4, 80262},
	{"YALC", 4, 51278},
	{"YALB", 4, 52699},
	{"YALAFORGE", 9, 250217},
	{"YALA", 4, 173458},
	{"YAKW", 4, 209283},
	{"YAKUZA", 6, 112022},
	{"YAKUTSK", 7, 177855},
	{"YAKUTIA", 7, 222708},
	{"YAKUTAT", 7, 136564},
	{"YAKUMO", 6, 100820},
	{"YAKUBU", 6, 243430},
	{"YAKU", 4, 80572},
	{"YAKTRAX", 7, 184188},
	{"YAKT", 4, 240587},
	{"YAKS", 4, 179862},
	{"YAKR", 4, 168720},
	{"YAKP", 4, 258147},
	{"YAKOVLEV", 8, 146218},
	{"YAKOVENKO", 9, 254498},
	{"YAKOV", 5, 109771},
	{"YAKO", 4, 84274},
	{"YAKN", 4, 117247},
	{"YAKM", 4, 246929},
	{"YAKK", 4, 155031},
	{"YAKIMA", 6, 50935},
	{"YAKI", 4, 169674},
	{"YAKH", 4, 152922},
	{"YAKC", 4, 220796},
	{"YAKB", 4, 232647},
	{"YAKAMA", 6, 192273},
	{"YAJU", 4, 96591},
	{"YAJOO", 5, 192720},
	{"YAJO", 4, 112642},
	{"YAJI", 4, 146628},
	{"YAJE", 4, 167728},
	{"YAJA", 4, 98727},
	{"YAJ", 3, 3299},
	{"YAIR", 4, 137171},
	{"YAIM", 4, 80251},
	{"YAIL", 4, 182168},
	{"YAIK", 4, 158864},
	{"YAIG", 4, 249436},
	{"YAID", 4, 80000},
	{"YAIB", 4, 261941},
	{"YAHYA", 5, 102904},
	{"YAHY", 4, 127424},
	{"YAHWEH", 6, 69193},
	{"YAHW", 4, 132310},
	{"YAHU", 4, 63113},
	{"YAHTZEE", 7, 110665},
	{"YAHSHUA", 7, 219638},
	{"YAHPP", 5, 256099},
	{"YAHPO", 5, 239670},
	{"YAHP", 4, 233221},
	{"YAHOOTRAVEL", 11, 184062},
	{"YAHOOS", 6, 153541},
	{"YAHOOOO", 7, 253331},
	{"YAHOOOM", 7, 246457},
	{"YAHOOO", 6, 215436},
	{"YAHOOMAPS", 9, 252056},
	{"YAHOOMAILCOM", 12, 256556},
	{"YAHOOMAIL", 9, 175893},
	{"YAHOOLIGANS", 11, 62336},
	{"YAHOOGROUPS", 11, 93459},
	{"YAHOOGROUP", 10, 181064},
	{"YAHOOGROU", 9, 235899},
	{"YAHOOGRO", 8, 225427},
	{"YAHOOGAMES", 10, 191831},
	{"YAHOOCOM", 8, 183930},
	{"YAHOOCHAT", 9, 250386},
	{"YAHOO", 5, 1205},
	{"YAHM", 4, 152865},
	{"YAHLL", 5, 256726},
	{"YAHKK", 5, 256959},
	{"YAHIO", 5, 236154},
	{"YAHIII", 6, 257379},
	{"YAHII", 5, 255581},
	{"YAHHOO", 6, 237038},
	{"YAHB", 4, 241012},
	{"YAGY", 4, 199847},
	{"YAGU", 4, 85910},
	{"YAGR", 4, 37926},
	{"YAGOTTA", 7, 193155},
	{"YAGOO", 5, 177231},
	{"YAGN", 4, 164561},
	{"YAGL", 4, 130887},
	{"YAGI", 4, 101744},
	{"YAGH", 4, 189014},
	{"YAGG", 4, 76616},
	{"YAGER", 5, 117729},
	{"YAGE", 4, 37794},
	{"YAGA", 4, 199165},
	{"YAFU", 4, 85252},
	{"YAFT", 4, 6715},
	{"YAFRO", 5, 126903},
	{"YAFR", 4, 54030},
	{"YAFL", 4, 84189},
	{"YAFI", 4, 61634},
	{"YAFG", 4, 131653},
	{"YAFFS", 5, 258706},
	{"YAFFE", 5, 180367},
	{"YAFFA", 5, 247048},
	{"YAFF", 4, 42371},
	{"YAFE", 4, 43025},
	{"YAEX", 4, 255281},
	{"YAEV", 4, 232091},
	{"YAEU", 4, 236728},
	{"YAESU", 5, 290},
	{"YAEM", 4, 253881},
	{"YAEL", 4, 140191},
	{"YAEGER", 6, 194118},
	{"YAEG", 4, 261564},
	{"YADY", 4, 219287},
	{"YADW", 4, 217479},
	{"YADV", 4, 39883},
	{"YADU", 4, 74359},
	{"YADT", 4, 172260},
	{"YADS", 4, 114386},
	{"YADR", 4, 76346},
	{"YADO", 4, 48832},
	{"YADM", 4, 45284},
	{"YADL", 4, 210480},
	{"YADKINVILLE", 11, 230949},
	{"YADKIN", 6, 133215},
	{"YADK", 4, 218410},
	{"YADJ", 4, 69552},
	{"YADH", 4, 95608},
	{"YADE", 4, 48903},
	{"YADDA", 5, 96987},
	{"YADD", 4, 38412},
	{"YADC", 4, 203438},
	{"YADAV", 5, 91390},
	{"YADA", 4, 86461},
	{"YACY", 4, 208701},
	{"YACUTE", 6, 211395},
	{"YACU", 4, 93097},
	{"YACT", 4, 32371},
	{"YACR", 4, 49475},
	{"YACQ", 4, 61143},
	{"YACOUB", 6, 230571},
	{"YACOM", 5, 249943},
	{"YACOLT", 6, 246772},
	{"YACO", 4, 39230},
	{"YACL", 4, 81934},
	{"YACK", 4, 225772},
	{"YACI", 4, 74106},
	{"YACHTSMEN", 9, 246589},
	{"YACHTSMAN", 9, 170650},
	{"YACHTS", 6, 42860},
	{"YACHTMASTER", 11, 202892},
	{"YACHTING", 8, 58299},
	{"YACHTCHARTER", 12, 257312},
	{"YACHT", 5, 34652},
	{"YACHATS", 7, 178269},
	{"YACH", 4, 43864},
	{"YACE", 4, 73397},
	{"YACC", 4, 104280},
	{"YACAS", 5, 249659},
	{"YACA", 4, 47749},
	{"YABY", 4, 154762},
	{"YABR", 4, 58350},
	{"YABOOT", 6, 226924},
	{"YABOO", 5, 191492},
	{"YABO", 4, 8354},
	{"YABN", 4, 211809},
	{"YABLOKO", 7, 203845},
	{"YABLANITSA", 10, 222153},
	{"YABL", 4, 43476},
	{"YABI", 4, 56006},
	{"YABH", 4, 145621},
	{"YABE", 4, 212883},
	{"YABD", 4, 128261},
	{"YABC", 4, 134642},
	{"YABBA", 5, 201668},
	{"YABB", 4, 62672},
	{"YABA", 4, 253418},
	{"YAAR", 4, 175462},
	{"YAAP", 4, 217941},
	{"YAAM", 4, 204853},
	{"YAAL", 4, 125816},
	{"YAAKOV", 6, 107697},
	{"YAAHOO", 6, 230777},
	{"YAAG", 4, 233222},
	{"YAAF", 4, 197573},
	{"YAACOV", 6, 194705},
	{"YAAC", 4, 157792},
	{"YAAB", 4, 212994},
	{"Y'ALL", 5, 690},
	{"Y", 1, 17},
	{"XZZZF", 5, 107255},
	{"XZZ", 3, 191878},
	{"XZY", 3, 196837},
	{"XZX", 3, 168974},
	{"XZW", 3, 143506},
	{"XZVFF", 5, 107249},
	{"XZU", 3, 112158},
	{"XZR", 3, 230194},
	{"XZP", 3, 172122},
	{"XZOO", 4, 234883},
	{"XZM", 3, 132802},
	{"XZL", 3, 160449},
	{"XZJ", 3, 191879},
	{"XZIBIT", 6, 76745},
	{"XZC", 3, 166066},
	{"XYZZY", 5, 145811},
	{"XYZ", 3, 53059},
	{"XYX", 3, 256201},
	{"XYWI", 4, 214600},
	{"XYWH", 4, 215453},
	{"XYWA", 4, 196151},
	{"XYW", 3, 32586},
	{"XYV", 3, 55287},
	{"XYU", 3, 49884},
	{"XYTO", 4, 152923},
	{"XYTHOS", 6, 122947},
	{"XYTH", 4, 142993},
	{"XYT", 3, 10134},
	{"XYST", 4, 190195},
	{"XYSE", 4, 178047},
	{"XYS", 3, 7837},
	{"XYRON", 5, 131113},
	{"XYRE", 4, 222418},
	{"XYR", 3, 38387},
	{"XYQ", 3, 88043},
	{"XYP", 3, 36874},
	{"XYOU", 4, 97722},
	{"XYOR", 4, 244201},
	{"XYOF", 4, 211633},
	{"XYO", 3, 7344},
	{"XYMOX", 5, 193206},
	{"XYMO", 4, 154763},
	{"XYMA", 4, 227932},
	{"XYM", 3, 30482},
	{"XYLOSE", 6, 157818},
	{"XYLOPHONES", 10, 247165},
	{"XYLOPHONE", 9, 105465},
	{"XYLOCAINE", 9, 225700},
	{"XYLO", 4, 164653},
	{"XYLITOL", 7, 129092},
	{"XYLICHEW", 8, 249731},
	{"XYLENES", 7, 182378},
	{"XYLENE", 6, 98092},
	{"XYLEM", 5, 131289},
	{"XYLELLA", 7, 202738},
	{"XYLE", 4, 233844},
	{"XYLANASE", 8, 226068},
	{"XYLAN", 5, 245953},
	{"XYLA", 4, 168181},
	{"XYL", 3, 277},
	{"XYK", 3, 64132},
	{"XYJ", 3, 91648},
	{"XYIS", 4, 167830},
	{"XYIN", 4, 151718},
	{"XYIENCE", 7, 143231},
	{"XYI", 3, 30617},
	{"XYHA", 4, 231565},
	{"XYGE", 4, 52367},
	{"XYG", 3, 2401},
	{"XYFO", 4, 152526},
	{"XYFI", 4, 252483},
	{"XYF", 3, 31604},
	{"XYET", 4, 261565},
	{"XYES", 4, 160439},
	{"XYEA", 4, 43094},
	{"XYE", 3, 1526},
	{"XYD", 3, 41099},
	{"XYCO", 4, 118326},
	{"XYCA", 4, 246614},
	{"XYC", 3, 10040},
	{"XYBU", 4, 235482},
	{"XYBERNAUT", 9, 164787},
	{"XYBE", 4, 246035},
	{"XYB", 3, 34018},
	{"XYAS", 4, 215246},
	{"XYAR", 4, 122485},
	{"XYAN", 4, 98761},
	{"XYAC", 4, 261566},
	{"XYA", 3, 5188},
	{"XXY", 3, 197890},
	{"XXVIII", 6, 97123},
	{"XXVII", 5, 98439},
	{"XXVI", 4, 92886},
	{"XXV", 3, 86756},
	{"XXTH", 4, 231717},
	{"XXR", 3, 53995},
	{"XXQ", 3, 196838},
	{"XXP", 3, 54937},
	{"XXON", 4, 79052},
	{"XXM", 3, 45883},
	{"XXLARGE", 7, 124044},
	{"XXL", 3, 46710},
	{"XXK", 3, 95547},
	{"XXJ", 3, 92394},
	{"XXIX", 4, 106592},
	{"XXIV", 4, 84812},
	{"XXIS", 4, 195998},
	{"XXIN", 4, 161846},
	{"XXIII", 5, 76452},
	{"XXII", 4, 76798},
	{"XXIAO", 5, 258131},
	{"XXG", 3, 67338},
	{"XXF", 3, 49026},
	{"XXEU", 4, 232947},
	{"XXCO", 4, 216043},
	{"XXC", 3, 39840},
	{"XXB", 3, 49885},
	{"XXASDF", 6, 124915},
	{"XXAN", 4, 151530},
	{"XXA", 3, 31565},
	{"XWY", 3, 114467},
	{"XWX", 3, 123414},
	{"XWW", 3, 87119},
	{"XWV", 3, 129032},
	{"XWU", 3, 99622},
	{"XWRWN", 5, 238755},
	{"XWRIS", 5, 210654},
	{"XWRI", 4, 176766},
	{"XWRES", 5, 217242},
	{"XWRAS", 5, 191618},
	{"XWRA", 4, 174444},
	{"XWR", 3, 36823},
	{"XWOU", 4, 85397},
	{"XWOR", 4, 78938},
	{"XWOO", 4, 154377},
	{"XWON", 4, 143768},
	{"XWOM", 4, 202389},
	{"XWO", 3, 3000},
	{"XWM", 3, 78100},
	{"XWL", 3, 153331},
	{"XWK", 3, 222258},
	{"XWJ", 3, 222259},
	{"XWIT", 4, 49889},
	{"XWINDOWS", 8, 178512},
	{"XWINDOW", 7, 225118},
	{"XWIN", 4, 203905},
	{"XWIL", 4, 73298},
	{"XWIKI", 5, 127754},
	{"XWIF", 4, 91754},
	{"XWIC", 4, 220365},
	{"XWI", 3, 1432},
	{"XWHO", 4, 78200},
	{"XWHI", 4, 59889},
	{"XWHE", 4, 77959},
	{"XWHA", 4, 157727},
	{"XWH", 3, 1841},
	{"XWG", 3, 166067},
	{"XWF", 3, 121443},
	{"XWES", 4, 211256},
	{"XWER", 4, 86745},
	{"XWEN", 4, 165421},
	{"XWEM", 4, 141560},
	{"XWEL", 4, 68382},
	{"XWEI", 4, 261942},
	{"XWEE", 4, 60102},
	{"XWEB", 4, 157895},
	{"XWEA", 4, 223988},
	{"XWE", 3, 1648},
	{"XWD", 3, 150402},
	{"XWC", 3, 130209},
	{"XWB", 3, 88353},
	{"XWAY", 4, 206431},
	{"XWAVE", 5, 164847},
	{"XWAT", 4, 172057},
	{"XWAS", 4, 47740},
	{"XWAR", 4, 171389},
	{"XWAN", 4, 214812},
	{"XWAL", 4, 154378},
	{"XWA", 3, 1718},
	{"XVY", 3, 138456},
	{"XVX", 3, 87735},
	{"XVW", 3, 59980},
	{"XVV", 3, 116139},
	{"XVU", 3, 92395},
	{"XVP", 3, 68031},
	{"XVOT", 4, 239585},
	{"XVOL", 4, 175064},
	{"XVO", 3, 31853},
	{"XVNC", 4, 242024},
	{"XVL", 3, 89256},
	{"XVK", 3, 172123},
	{"XVJ", 3, 155526},
	{"XVIT", 4, 259273},
	{"XVIS", 4, 172375},
	{"XVIR", 4, 190629},
	{"XVIO", 4, 242998},
	{"XVIN", 4, 242442},
	{"XVIL", 4, 72324},
	{"XVIII", 5, 58802},
	{"XVII", 4, 61633},
	{"XVIEWG", 6, 85749},
	{"XVIEW", 5, 172352},
	{"XVIDEO", 6, 255001},
	{"XVID", 4, 51733},
	{"XVIC", 4, 156620},
	{"XVIA", 4, 182864},
	{"XVG", 3, 103752},
	{"XVFB", 4, 222065},
	{"XVF", 3, 170132},
	{"XVER", 4, 108109},
	{"XVEN", 4, 192069},
	{"XVE", 3, 8497},
	{"XVCD", 4, 214181},
	{"XVC", 3, 54305},
	{"XVB", 3, 77875},
	{"XVAR", 4, 185229},
	{"XVAN", 4, 190334},
	{"XVA", 3, 8801},
	{"XUZHOU", 6, 255618},
	{"XUZ", 3, 59763},
	{"XUY", 3, 69514},
	{"XUXA", 4, 107405},
	{"XUX", 3, 65973},
	{"XUW", 3, 60485},
	{"XUV", 3, 201208},
	{"XUU", 3, 172124},
	{"XUSW", 4, 236729},
	{"XUST", 4, 215652},
	{"XUSS", 4, 182865},
	{"XUSR", 4, 253532},
	{"XUSO", 4, 119411},
	{"XUSL", 4, 241013},
	{"XUSI", 4, 153392},
	{"XUSH", 4, 228704},
	{"XUSE", 4, 99855},
	{"XUSC", 4, 234566},
	{"XUSB", 4, 234293},
	{"XUSA", 4, 143621},
	{"XURY", 4, 47595},
	{"XURI", 4, 77826},
	{"XUR", 3, 1623},
	{"XUQ", 3, 151208},
	{"XUPT", 4, 194815},
	{"XUPITER", 7, 186827},
	{"XUPA", 4, 247866},
	{"XUP", 3, 9459},
	{"XUNT", 4, 157171},
	{"XUNI", 4, 113530},
	{"XUNG", 4, 249015},
	{"XUND", 4, 137550},
	{"XUM", 3, 42945},
	{"XULT", 4, 185609},
	{"XULRUNNER", 9, 256312},
	{"XUL", 3, 84459},
	{"XUK", 3, 67584},
	{"XUJ", 3, 90594},
	{"XUGANA", 6, 89804},
	{"XUG", 3, 88044},
	{"XUF", 3, 74804},
	{"XUDE", 4, 136507},
	{"XUD", 3, 33952},
	{"XUCHUN", 6, 192572},
	{"XUC", 3, 54223},
	{"XUBE", 4, 103292},
	{"XUB", 3, 29032},
	{"XUAN", 4, 108869},
	{"XTYY", 4, 143824},
	{"XTYT", 4, 154638},
	{"XTYS", 4, 143094},
	{"XTYP", 4, 135357},
	{"XTYO", 4, 137415},
	{"XTYM", 4, 213212},
	{"XTYF", 4, 87406},
	{"XTYE", 4, 33652},
	{"XTY", 3, 969},
	{"XTWO", 4, 118357},
	{"XTWI", 4, 92511},
	{"XTWH", 4, 121038},
	{"XTWE", 4, 42098},
	{"XTWA", 4, 104417},
	{"XTW", 3, 1272},
	{"XTVS", 4, 185865},
	{"XTVI", 4, 141945},
	{"XTVE", 4, 171285},
	{"XTVA", 4, 246036},
	{"XTUS", 4, 129249},
	{"XTUR", 4, 38710},
	{"XTUP", 4, 98303},
	{"XTUN", 4, 174854},
	{"XTUA", 4, 90713},
	{"XTU", 3, 1152},
	{"XTTW", 4, 52527},
	{"XTTU", 4, 128059},
	{"XTTR", 4, 120939},
	{"XTTP", 4, 98156},
	{"XTTORNEY", 8, 247087},
	{"XTSW", 4, 125155},
	{"XTSU", 4, 81307},
	{"XTSR", 4, 255641},
	{"XTSP", 4, 101768},
	{"XTSM", 4, 210875},
	{"XTSL", 4, 258887},
	{"XTSF", 4, 158358},
	{"XTSETARG", 8, 155073},
	{"XTSD", 4, 254216},
	{"XTSC", 4, 100551},
	{"XTSB", 4, 198352},
	{"XTRU", 4, 111625},
	{"XTRO", 4, 70552},
	{"XTRI", 4, 83290},
	{"XTREMETONES", 11, 207969},
	{"XTREMEMUSIC", 11, 238986},
	{"XTREMEMAC", 9, 104106},
	{"XTREME", 6, 43080},
	{"XTRE", 4, 9070},
	{"XTRAS", 5, 113913},
	{"XTRAORDINARY", 12, 224049},
	{"XTRAMSN", 7, 227663},
	{"XTRADIUS", 8, 162321},
	{"XTRA", 4, 55587},
	{"XTQU", 4, 129837},
	{"XTQ", 3, 35882},
	{"XTPU", 4, 241014},
	{"XTPR", 4, 77120},
	{"XTPOINTER", 9, 219547},
	{"XTPO", 4, 90739},
	{"XTPL", 4, 87849},
	{"XTPI", 4, 152527},
	{"XTPH", 4, 131613},
	{"XTPE", 4, 139585},
	{"XTPA", 4, 109795},
	{"XTOY", 4, 177067},
	{"XTOW", 4, 133912},
	{"XTOV", 4, 242716},
	{"XTOU", 4, 102853},
	{"XTORIES", 7, 232556},
	{"XTOR", 4, 63522},
	{"XTOP", 4, 94436},
	{"XTOM", 4, 137820},
	{"XTOL", 4, 106618},
	{"XTOG", 4, 136157},
	{"XTOF", 4, 50905},
	{"XTOD", 4, 147035},
	{"XTOC", 4, 125817},
	{"XTOB", 4, 116803},
	{"XTMU", 4, 252136},
	{"XTMO", 4, 44442},
	{"XTMI", 4, 118382},
	{"XTME", 4, 58380},
	{"XTMA", 4, 83970},
	{"XTLO", 4, 145622},
	{"XTLI", 4, 134180},
	{"XTLE", 4, 75054},
	{"XTLA", 4, 136624},
	{"XTKI", 4, 242999},
	{"XTJU", 4, 173626},
	{"XTJO", 4, 179085},
	{"XTJA", 4, 213802},
	{"XTJ", 3, 31198},
	{"XTIR", 4, 210673},
	{"XTINE", 5, 193253},
	{"XTINA", 5, 201620},
	{"XTIM", 4, 68926},
	{"XTIL", 4, 62982},
	{"XTIDE", 5, 218495},
	{"XTIC", 4, 250458},
	{"XTHY", 4, 146765},
	{"XTHW", 4, 101186},
	{"XTHU", 4, 171286},
	{"XTHR", 4, 79413},
	{"XTHP", 4, 88386},
	{"XTHM", 4, 114615},
	{"XTHL", 4, 142141},
	{"XTHG", 4, 77887},
	{"XTHF", 4, 90034},
	{"XTHD", 4, 140526},
	{"XTHC", 4, 93187},
	{"XTHB", 4, 115378},
	{"XTGU", 4, 173823},
	{"XTGR", 4, 125462},
	{"XTGO", 4, 126937},
	{"XTGE", 4, 60345},
	{"XTGA", 4, 84749},
	{"XTG", 3, 2046},
	{"XTFR", 4, 98962},
	{"XTFO", 4, 62891},
	{"XTFL", 4, 214405},
	{"XTFI", 4, 62474},
	{"XTFE", 4, 52910},
	{"XTFA", 4, 113198},
	{"XTEX", 4, 148106},
	{"XTEV", 4, 159562},
	{"XTERRA", 6, 90603},
	{"XTERMINATOR", 11, 252976},
	{"XTERM", 5, 73503},
	{"XTER", 4, 31968},
	{"XTEP", 4, 157241},
	{"XTENSIONS", 9, 252461},
	{"XTENSION", 8, 155543},
	{"XTENSA", 6, 223256},
	{"XTEND", 5, 170507},
	{"XTEM", 4, 149640},
	{"XTEL", 4, 145247},
	{"XTEDDY", 6, 170875},
	{"XTED", 4, 118327},
	{"XTEC", 4, 129250},
	{"XTDR", 4, 136911},
	{"XTDO", 4, 62537},
	{"XTDI", 4, 159960},
	{"XTDE", 4, 76317},
	{"XTDA", 4, 43362},
	{"XTCR", 4, 194209},
	{"XTCO", 4, 65008},
	{"XTCL", 4, 126771},
	{"XTCH", 4, 100821},
	{"XTCE", 4, 153987},
	{"XTCA", 4, 101077},
	{"XTBY", 4, 175496},
	{"XTBU", 4, 116804},
	{"XTBR", 4, 188557},
	{"XTBO", 4, 57828},
	{"XTBL", 4, 225318},
	{"XTBI", 4, 94579},
	{"XTBE", 4, 103996},
	{"XTBA", 4, 94452},
	{"XTB", 3, 1700},
	{"XTAV", 4, 237346},
	{"XTAU", 4, 240450},
	{"XTASY", 5, 208742},
	{"XTAR", 4, 106266},
	{"XTAP", 4, 76096},
	{"XTAM", 4, 195999},
	{"XTAL", 4, 276},
	{"XTAK", 4, 155230},
	{"XTAG", 4, 239586},
	{"XTAF", 4, 198509},
	{"XTAD", 4, 143095},
	{"XTAC", 4, 126905},
	{"XTAB", 4, 166300},
	{"XSYS", 4, 83163},
	{"XSYN", 4, 246615},
	{"XSYM", 4, 173337},
	{"XSY", 3, 5848},
	{"XSWI", 4, 164151},
	{"XSWE", 4, 218166},
	{"XSWA", 4, 178967},
	{"XSW", 3, 9770},
	{"XSVCD", 5, 241275},
	{"XSUR", 4, 150726},
	{"XSUP", 4, 128858},
	{"XSUC", 4, 155491},
	{"XSU", 3, 4283},
	{"XSTY", 4, 202390},
	{"XSTU", 4, 120940},
	{"XSTREAM", 7, 132451},
	{"XSTRATA", 7, 211954},
	{"XSRE", 4, 186272},
	{"XSRC", 4, 164702},
	{"XSQU", 4, 191777},
	{"XSPR", 4, 155363},
	{"XSPO", 4, 83817},
	{"XSPI", 4, 222163},
	{"XSPF", 4, 211659},
	{"XSPEC", 5, 142080},
	{"XSPE", 4, 89449},
	{"XSPA", 4, 155492},
	{"XSOU", 4, 157313},
	{"XSOR", 4, 252484},
	{"XSONIC", 6, 177099},
	{"XSOM", 4, 137216},
	{"XSOL", 4, 128859},
	{"XSOF", 4, 160329},
	{"XSOC", 4, 163582},
	{"XSO", 3, 3040},
	{"XSMO", 4, 192070},
	{"XSMI", 4, 133951},
	{"XSMALL", 6, 141875},
	{"XSMA", 4, 164375},
	{"XSLTPROC", 8, 196976},
	{"XSLT", 4, 44437},
	{"XSLO", 4, 209101},
	{"XSLI", 4, 153122},
	{"XSLA", 4, 143460},
	{"XSKI", 4, 255983},
	{"XSIZE", 5, 148271},
	{"XSITE", 5, 158713},
	{"XSIM", 4, 196925},
	{"XSIG", 4, 155908},
	{"XSID", 4, 183605},
	{"XSHU", 4, 211995},
	{"XSFI", 4, 205187},
	{"XSFA", 4, 200550},
	{"XSEV", 4, 172058},
	{"XSESSION", 8, 201896},
	{"XSERVER", 7, 83742},
	{"XSERVE", 6, 85537},
	{"XSERIES", 7, 78127},
	{"XSER", 4, 80668},
	{"XSEP", 4, 253533},
	{"XSEM", 4, 219496},
	{"XSELECT", 7, 222998},
	{"XSEL", 4, 92938},
	{"XSED", 4, 217368},
	{"XSDE", 4, 187863},
	{"XSCREENSAVER", 12, 113185},
	{"XSCR", 4, 171671},
	{"XSCO", 4, 94422},
	{"XSCI", 4, 247238},
	{"XSCH", 4, 108564},
	{"XSCE", 4, 159640},
	{"XSCAPE", 6, 146664},
	{"XSCALE", 6, 100164},
	{"XSCA", 4, 113756},
	{"XSAY", 4, 129838},
	{"XSAV", 4, 144929},
	{"XSARA", 5, 114683},
	{"XSAR", 4, 238763},
	{"XSANE", 5, 162080},
	{"XSAM", 4, 246930},
	{"XSAL", 4, 126013},
	{"XSAC", 4, 186119},
	{"XRZ", 3, 196839},
	{"XRYA", 4, 137896},
	{"XRW", 3, 70736},
	{"XRV", 3, 229668},
	{"XRUN", 4, 87167},
	{"XRUL", 4, 217255},
	{"XRU", 3, 6501},
	{"XRSQ", 4, 256332},
	{"XRR", 3, 82607},
	{"XRQ", 3, 262079},
	{"XRP", 3, 154886},
	{"XROU", 4, 147931},
	{"XROT", 4, 251773},
	{"XROS", 4, 106075},
	{"XROO", 4, 209679},
	{"XRONIA", 6, 196386},
	{"XROM", 4, 251774},
	{"XROL", 4, 172686},
	{"XROD", 4, 100363},
	{"XROC", 4, 251142},
	{"XROB", 4, 241015},
	{"XROA", 4, 171955},
	{"XRO", 3, 3399},
	{"XRLQ", 4, 189225},
	{"XRK", 3, 99123},
	{"XRJ", 3, 239957},
	{"XRIV", 4, 138764},
	{"XRIO", 4, 214813},
	{"XRIG", 4, 203805},
	{"XRID", 4, 210876},
	{"XRG", 3, 114468},
	{"XRF", 3, 120595},
	{"XREV", 4, 68390},
	{"XRET", 4, 79339},
	{"XREQ", 4, 228705},
	{"XREPORTER", 9, 229897},
	{"XREP", 4, 113082},
	{"XREN", 4, 258528},
	{"XREM", 4, 144354},
	{"XREL", 4, 75556},
	{"XREG", 4, 109226},
	{"XREFS", 5, 192711},
	{"XREF", 4, 65502},
	{"XRED", 4, 154236},
	{"XRECORD", 7, 234857},
	{"XREC", 4, 88392},
	{"XREB", 4, 94342},
	{"XREA", 4, 114691},
	{"XRE", 3, 1263},
	{"XRD", 3, 123941},
	{"XRC", 3, 195949},
	{"XRBI", 4, 215247},
	{"XRAYS", 5, 227384},
	{"XRAY", 4, 80781},
	{"XRATED", 6, 144489},
	{"XRAT", 4, 62468},
	{"XRANGE", 6, 209885},
	{"XRAN", 4, 156951},
	{"XRAMP", 5, 221605},
	{"XRAI", 4, 185353},
	{"XRAD", 4, 187459},
	{"XRACER", 6, 258446},
	{"XRAC", 4, 125760},
	{"XRAB", 4, 251775},
	{"XQY", 3, 179147},
	{"XQX", 3, 202338},
	{"XQW", 3, 166068},
	{"XQV", 3, 182975},
	{"XQUI", 4, 93733},
	{"XQUERY", 6, 75813},
	{"XQUE", 4, 169182},
	{"XQUARE", 6, 242815},
	{"XQUA", 4, 185230},
	{"XQU", 3, 6814},
	{"XQR", 3, 160450},
	{"XQQ", 3, 250001},
	{"XQM", 3, 222260},
	{"XQL", 3, 230128},
	{"XQES", 4, 149251},
	{"XQC", 3, 182976},
	{"XQB", 3, 179148},
	{"XPZ", 3, 262080},
	{"XPY", 3, 73633},
	{"XPX", 3, 79937},
	{"XPV", 3, 63599},
	{"XPUZZLES", 8, 194066},
	{"XPUT", 4, 226972},
	{"XPUR", 4, 157172},
	{"XPUN", 4, 163034},
	{"XPUL", 4, 84305},
	{"XPUB", 4, 186761},
	{"XPU", 3, 192766},
	{"XPTH", 4, 258529},
	{"XPRT", 4, 190038},
	{"XPRINT", 6, 150720},
	{"XPRI", 4, 100730},
	{"XPRESSO", 7, 214110},
	{"XPRESS", 6, 49623},
	{"XPRES", 5, 222589},
	{"XPRE", 4, 8193},
	{"XPRA", 4, 242443},
	{"XPR", 3, 234552},
	{"XPQ", 3, 157878},
	{"XPPRO", 5, 238172},
	{"XPPMATH", 7, 138637},
	{"XPPEDIT", 7, 193695},
	{"XPP", 3, 104608},
	{"XPOWER", 6, 101043},
	{"XPOW", 4, 139359},
	{"XPOU", 4, 118358},
	{"XPOT", 4, 170441},
	{"XPOSURE", 7, 199576},
	{"XPOSTFACTO", 10, 232076},
	{"XPOSED", 6, 184172},
	{"XPOS", 4, 147066},
	{"XPORT", 5, 163953},
	{"XPOR", 4, 37472},
	{"XPOP", 4, 184230},
	{"XPOO", 4, 239325},
	{"XPON", 4, 72364},
	{"XPOL", 4, 96877},
	{"XPOINTER", 8, 139039},
	{"XPOI", 4, 67807},
	{"XPOC", 4, 197253},
	{"XPOA", 4, 187028},
	{"XPM", 3, 99893},
	{"XPLU", 4, 150836},
	{"XPLOSION", 8, 198660},
	{"XPLORETECH", 10, 188501},
	{"XPLORER", 7, 169563},
	{"XPLORE", 6, 99054},
	{"XPLOR", 5, 126467},
	{"XPLODE", 6, 191968},
	{"XPLOD", 5, 179749},
	{"XPLO", 4, 6798},
	{"XPLI", 4, 48652},
	{"XPLE", 4, 121308},
	{"XPLANET", 7, 177102},
	{"XPLAIN", 6, 239424},
	{"XPLA", 4, 6848},
	{"XPL", 3, 211567},
	{"XPKGWEDGE", 9, 232609},
	{"XPK", 3, 101650},
	{"XPJ", 3, 121444},
	{"XPIX", 4, 185231},
	{"XPIT", 4, 152458},
	{"XPIS", 4, 148675},
	{"XPIR", 4, 45766},
	{"XPIN", 4, 201062},
	{"XPILOT", 6, 156948},
	{"XPIE", 4, 173062},
	{"XPIC", 4, 186120},
	{"XPHONE", 6, 124269},
	{"XPHOME", 6, 259485},
	{"XPHO", 4, 202205},
	{"XPHA", 4, 231069},
	{"XPF", 3, 101421},
	{"XPET", 4, 237674},
	{"XPERTVISION", 11, 142626},
	{"XPERTHR", 7, 212364},
	{"XPERT", 5, 112864},
	{"XPERIENCE", 9, 137111},
	{"XPER", 4, 2897},
	{"XPEO", 4, 110051},
	{"XPEN", 4, 8600},
	{"XPEL", 4, 56795},
	{"XPED", 4, 42296},
	{"XPEC", 4, 3555},
	{"XPDF", 4, 91416},
	{"XPD", 3, 133300},
	{"XPCSPY", 6, 198395},
	{"XPCOM", 5, 140471},
	{"XPC", 3, 84753},
	{"XPB", 3, 256514},
	{"XPAY", 4, 38970},
	{"XPATH", 5, 57480},
	{"XPAT", 4, 205357},
	{"XPASS", 5, 62542},
	{"XPAS", 4, 116413},
	{"XPAR", 4, 82148},
	{"XPAP", 4, 217704},
	{"XPANDAX", 7, 189759},
	{"XPAND", 5, 212900},
	{"XPAL", 4, 259274},
	{"XPAI", 4, 166455},
	{"XPAG", 4, 201063},
	{"XPAC", 4, 111102},
	{"XP", 2, 3465},
	{"XOXOXO", 6, 191101},
	{"XOXOX", 5, 202299},
	{"XOXO", 4, 73388},
	{"XOWNLOADS", 9, 229436},
	{"XOWNLOAD", 8, 191453},
	{"XOWN", 4, 174855},
	{"XOVER", 5, 219329},
	{"XOVE", 4, 105969},
	{"XOV", 3, 29846},
	{"XOUR", 4, 181696},
	{"XOU", 3, 8584},
	{"XOSOFT", 6, 135268},
	{"XOSM", 4, 180559},
	{"XOSK", 4, 200551},
	{"XORW", 4, 219730},
	{"XORT", 4, 140158},
	{"XORS", 4, 94482},
	{"XORR", 4, 246326},
	{"XORP", 4, 184675},
	{"XORO", 4, 176933},
	{"XORN", 4, 214601},
	{"XORM", 4, 159713},
	{"XORI", 4, 140318},
	{"XORH", 4, 253174},
	{"XORG", 4, 60144},
	{"XORF", 4, 252137},
	{"XORE", 4, 147870},
	{"XORD", 4, 177824},
	{"XORC", 4, 96449},
	{"XORB", 4, 117391},
	{"XORA", 4, 104171},
	{"XOPL", 4, 240729},
	{"XOPH", 4, 79712},
	{"XOPE", 4, 104597},
	{"XOOPS", 5, 51249},
	{"XOONIPS", 7, 217870},
	{"XOOM", 4, 220162},
	{"XONY", 4, 95856},
	{"XONW", 4, 90396},
	{"XONV", 4, 150413},
	{"XONU", 4, 260047},
	{"XONR", 4, 134691},
	{"XONP", 4, 115358},
	{"XONM", 4, 87693},
	{"XONL", 4, 105396},
	{"XONK", 4, 224405},
	{"XONJ", 4, 193474},
	{"XONIX", 5, 181931},
	{"XONG", 4, 150860},
	{"XONF", 4, 123289},
	{"XOND", 4, 133562},
	{"XONC", 4, 93746},
	{"XONB", 4, 129213},
	{"XOLO", 4, 149118},
	{"XOGE", 4, 232092},
	{"XOFY", 4, 243897},
	{"XOFW", 4, 137285},
	{"XOFV", 4, 224190},
	{"XOFU", 4, 195248},
	{"XOFTWARE", 8, 248715},
	{"XOFTSPY", 7, 137361},
	{"XOFT", 4, 54975},
	{"XOFS", 4, 85082},
	{"XOFR", 4, 123664},
	{"XOFP", 4, 101749},
	{"XOFO", 4, 142647},
	{"XOFN", 4, 137088},
	{"XOFM", 4, 114094},
	{"XOFL", 4, 132266},
	{"XOFJ", 4, 261192},
	{"XOFI", 4, 117551},
	{"XOFH", 4, 104212},
	{"XOFG", 4, 161519},
	{"XOFF", 4, 147082},
	{"XOFE", 4, 128937},
	{"XOFD", 4, 142840},
	{"XOFC", 4, 92688},
	{"XOFB", 4, 124623},
	{"XOFA", 4, 98052},
	{"XODU", 4, 80772},
	{"XOCC", 4, 239856},
	{"XOC", 3, 33180},
	{"XOBA", 4, 169704},
	{"XOB", 3, 32082},
	{"XOANON", 6, 167229},
	{"XNXX", 4, 30806},
	{"XNVIEW", 6, 238558},
	{"XNUM", 4, 125602},
	{"XNULL", 5, 230357},
	{"XNOW", 4, 148384},
	{"XNOV", 4, 161771},
	{"XNIG", 4, 233505},
	{"XNEX", 4, 232093},
	{"XNEST", 5, 217429},
	{"XNER", 4, 179663},
	{"XNE", 3, 2387},
	{"XNAR", 4, 146691},
	{"XNAM", 4, 195398},
	{"XMY", 3, 47006},
	{"XMX", 3, 92035},
	{"XMW", 3, 58959},
	{"XMV", 3, 127825},
	{"XMUS", 4, 126845},
	{"XMUL", 4, 175268},
	{"XMTR", 4, 275},
	{"XMSR", 4, 227762},
	{"XMSA", 4, 228706},
	{"XMRE", 4, 176557},
	{"XMRA", 4, 237347},
	{"XMPUZZLES", 9, 198939},
	{"XMPP", 4, 104208},
	{"XMP", 3, 128427},
	{"XMOV", 4, 133563},
	{"XMOU", 4, 194498},
	{"XMOT", 4, 169353},
	{"XMOS", 4, 178751},
	{"XMOR", 4, 97190},
	{"XMOO", 4, 223989},
	{"XMODS", 5, 179867},
	{"XMODMAP", 7, 183186},
	{"XMODEM", 6, 179001},
	{"XMOD", 4, 194633},
	{"XMO", 3, 1182},
	{"XMMS", 4, 65083},
	{"XMML", 4, 188806},
	{"XMM", 3, 111326},
	{"XMLWRITER", 9, 176389},
	{"XMLTV", 5, 152286},
	{"XMLSUBSCRIBE", 12, 236830},
	{"XMLSPY", 6, 164422},
	{"XMLSERIALIZER", 13, 215698},
	{"XMLSEC", 6, 189593},
	{"XMLSCHEMA", 9, 196420},
	{"XMLS", 4, 185232},
	{"XMLRPC", 6, 107447},
	{"XMLREADER", 9, 158196},
	{"XMLPARSERCTXTPTR", 16, 253409},
	{"XMLPARSER", 9, 220297},
	{"XMLNS", 5, 96278},
	{"XMLNODEPTR", 10, 179485},
	{"XMLNODE", 7, 174735},
	{"XMLJ", 4, 120833},
	{"XMLI", 4, 248151},
	{"XMLHTTPREQUEST", 14, 133931},
	{"XMLHTTP", 7, 231214},
	{"XMLFREE", 7, 233135},
	{"XMLF", 4, 190068},
	{"XMLELEMENT", 10, 230405},
	{"XMLDOC", 6, 250949},
	{"XMLD", 4, 190196},
	{"XMLCHAR", 7, 130500},
	{"XMLCH", 5, 256794},
	{"XMLC", 4, 129001},
	{"XMLBLASTER", 10, 186075},
	{"XMLBEANS", 8, 150374},
	{"XMLA", 4, 216857},
	{"XML", 3, 2330},
	{"XMK", 3, 102703},
	{"XMJ", 3, 250002},
	{"XMIX", 4, 254217},
	{"XMIT", 4, 174079},
	{"XMIS", 4, 157602},
	{"XMIN", 4, 110357},
	{"XMIL", 4, 83600},
	{"XMIG", 4, 197110},
	{"XMID", 4, 211257},
	{"XMIC", 4, 209890},
	{"XMF", 3, 54045},
	{"XMEX", 4, 259645},
	{"XMETAL", 6, 112801},
	{"XMET", 4, 100691},
	{"XMER", 4, 192486},
	{"XMEN", 4, 129584},
	{"XMEM", 4, 113988},
	{"XMEE", 4, 208917},
	{"XMED", 4, 149912},
	{"XMEA", 4, 132499},
	{"XME", 3, 1956},
	{"XMD", 3, 59557},
	{"XMCD", 4, 199261},
	{"XMC", 3, 260269},
	{"XMB", 3, 93789},
	{"XMAY", 4, 121656},
	{"XMAX", 4, 104703},
	{"XMAT", 4, 121359},
	{"XMAS", 4, 39454},
	{"XMAR", 4, 69529},
	{"XMAN", 4, 235245},
	{"XMAME", 5, 153298},
	{"XMALLOC", 7, 207531},
	{"XMAL", 4, 232648},
	{"XMAK", 4, 152070},
	{"XMAJ", 4, 177477},
	{"XMAIL", 5, 186750},
	{"XMAI", 4, 171866},
	{"XMAG", 4, 144138},
	{"XMAD", 4, 148896},
	{"XMAC", 4, 110772},
	{"XLW", 3, 57107},
	{"XLVIII", 6, 187842},
	{"XLVII", 5, 188179},
	{"XLVI", 4, 188752},
	{"XLV", 3, 152158},
	{"XLUT", 4, 163140},
	{"XLSHOP", 6, 245885},
	{"XLR", 3, 60095},
	{"XLPE", 4, 261266},
	{"XLOV", 4, 171568},
	{"XLOS", 4, 109840},
	{"XLOO", 4, 153123},
	{"XLON", 4, 214027},
	{"XLOGMASTER", 10, 132291},
	{"XLOG", 4, 181444},
	{"XLOCKMORE", 9, 252642},
	{"XLOCK", 5, 216834},
	{"XLOC", 4, 153715},
	{"XLOADIMAGE", 10, 207773},
	{"XLNT", 4, 240321},
	{"XLM", 3, 246305},
	{"XLIX", 4, 190984},
	{"XLIV", 4, 181222},
	{"XLIS", 4, 201396},
	{"XLIPART", 7, 235644},
	{"XLINK", 5, 102647},
	{"XLIN", 4, 109515},
	{"XLIK", 4, 120267},
	{"XLIII", 5, 176713},
	{"XLII", 4, 163459},
	{"XLIG", 4, 252827},
	{"XLIFF", 5, 230781},
	{"XLIF", 4, 143461},
	{"XLIE", 4, 189677},
	{"XLIBS", 5, 40042},
	{"XLIBRIS", 7, 180306},
	{"XLIBMESA", 8, 56855},
	{"XLIB", 4, 103881},
	{"XLIA", 4, 178752},
	{"XLG", 3, 184835},
	{"XLF", 3, 165976},
	{"XLEY", 4, 85469},
	{"XLEW", 4, 178519},
	{"XLEV", 4, 119708},
	{"XLET", 4, 162292},
	{"XLES", 4, 112564},
	{"XLER", 4, 111514},
	{"XLEO", 4, 229981},
	{"XLENT", 5, 188243},
	{"XLEN", 4, 216044},
	{"XLEI", 4, 237969},
	{"XLEG", 4, 157967},
	{"XLEF", 4, 177933},
	{"XLED", 4, 186623},
	{"XLEA", 4, 103146},
	{"XLC", 3, 165097},
	{"XLAW", 4, 121542},
	{"XLAU", 4, 231313},
	{"XLAT", 4, 174543},
	{"XLAS", 4, 147587},
	{"XLARGE", 6, 83311},
	{"XLAR", 4, 204135},
	{"XLAP", 4, 248487},
	{"XLAN", 4, 111626},
	{"XLAC", 4, 244517},
	{"XLABEL", 6, 179323},
	{"XLAB", 4, 245317},
	{"XKY", 3, 83306},
	{"XKX", 3, 135570},
	{"XKW", 3, 73790},
	{"XKV", 3, 187234},
	{"XKU", 3, 63600},
	{"XKR", 3, 171830},
	{"XKP", 3, 102704},
	{"XKNO", 4, 174140},
	{"XKMS", 4, 250255},
	{"XKMN", 4, 258888},
	{"XKM", 3, 35155},
	{"XKLA", 4, 153310},
	{"XKL", 3, 38296},
	{"XKK", 3, 182977},
	{"XKJ", 3, 262081},
	{"XKIN", 4, 169354},
	{"XKIL", 4, 139850},
	{"XKID", 4, 186273},
	{"XKI", 3, 8956},
	{"XKG", 3, 81266},
	{"XKF", 3, 138457},
	{"XKEY", 4, 252138},
	{"XKER", 4, 160806},
	{"XKEN", 4, 226231},
	{"XKD", 3, 117817},
	{"XKC", 3, 90226},
	{"XKB", 3, 131967},
	{"XJZ", 3, 191880},
	{"XJX", 3, 168975},
	{"XJW", 3, 117818},
	{"XJV", 3, 239958},
	{"XJUS", 4, 156318},
	{"XJUN", 4, 241295},
	{"XJUM", 4, 224191},
	{"XJUD", 4, 199178},
	{"XJU", 3, 28649},
	{"XJR", 3, 163057},
	{"XJP", 3, 109382},
	{"XJON", 4, 179873},
	{"XJOI", 4, 254218},
	{"XJOH", 4, 241585},
	{"XJO", 3, 31141},
	{"XJM", 3, 135571},
	{"XJL", 3, 191881},
	{"XJK", 3, 191882},
	{"XJJ", 3, 151209},
	{"XJG", 3, 182978},
	{"XJF", 3, 157879},
	{"XJEW", 4, 140319},
	{"XJELL", 5, 134444},
	{"XJE", 3, 32346},
	{"XJD", 3, 175469},
	{"XJC", 3, 99124},
	{"XJB", 3, 107353},
	{"XJACK", 5, 204932},
	{"XJA", 3, 35451},
	{"XIZANG", 6, 259087},
	{"XIXTH", 5, 259965},
	{"XIXI", 4, 197555},
	{"XIWI", 4, 240139},
	{"XIWH", 4, 221022},
	{"XIWA", 4, 131548},
	{"XIW", 3, 28893},
	{"XIVT", 4, 247239},
	{"XIVS", 4, 244202},
	{"XIVO", 4, 229224},
	{"XIVI", 4, 212408},
	{"XIVE", 4, 138860},
	{"XIVA", 4, 202206},
	{"XIUS", 4, 177478},
	{"XITY", 4, 58954},
	{"XITW", 4, 113877},
	{"XITU", 4, 155779},
	{"XITR", 4, 147647},
	{"XITP", 4, 105714},
	{"XITM", 4, 203614},
	{"XITL", 4, 209102},
	{"XITF", 4, 109490},
	{"XITEL", 5, 197692},
	{"XITD", 4, 193315},
	{"XITC", 4, 174661},
	{"XITB", 4, 161941},
	{"XISW", 4, 117009},
	{"XISV", 4, 217942},
	{"XISU", 4, 50337},
	{"XISR", 4, 119737},
	{"XISP", 4, 101724},
	{"XISM", 4, 77938},
	{"XISL", 4, 122453},
	{"XISK", 4, 221501},
	{"XISJ", 4, 247867},
	{"XISHUANGBANNA", 13, 261158},
	{"XISG", 4, 142284},
	{"XISF", 4, 115443},
	{"XISD", 4, 107035},
	{"XISC", 4, 96450},
	{"XISB", 4, 112319},
	{"XIRO", 4, 219497},
	{"XIRLINES", 8, 235930},
	{"XIRI", 4, 243898},
	{"XIRE", 4, 238210},
	{"XIRCOM", 6, 109545},
	{"XIRA", 4, 227202},
	{"XIR", 3, 29802},
	{"XIPR", 4, 184475},
	{"XIPO", 4, 241667},
	{"XIPH", 4, 173391},
	{"XIOU", 4, 55914},
	{"XIONG", 5, 112304},
	{"XIOM", 4, 83745},
	{"XIOLITA", 7, 201126},
	{"XINY", 4, 238764},
	{"XINW", 4, 125887},
	{"XINV", 4, 151832},
	{"XINTEX", 6, 215320},
	{"XINR", 4, 198510},
	{"XINP", 4, 144194},
	{"XINM", 4, 139633},
	{"XINL", 4, 170983},
	{"XINJIANG", 8, 86786},
	{"XINJ", 4, 113398},
	{"XINITRC", 7, 198558},
	{"XINING", 6, 234482},
	{"XINHUANET", 9, 135727},
	{"XINHUA", 6, 64240},
	{"XINHA", 5, 253759},
	{"XINGTONE", 8, 179760},
	{"XING", 4, 81378},
	{"XINF", 4, 111146},
	{"XINETD", 6, 111140},
	{"XINERAMA", 8, 179789},
	{"XINDICE", 7, 155203},
	{"XIND", 4, 78172},
	{"XINCLUDE", 8, 154023},
	{"XINC", 4, 51679},
	{"XINB", 4, 158139},
	{"XIMU", 4, 38618},
	{"XIMS", 4, 174141},
	{"XIMP", 4, 150727},
	{"XIMO", 4, 171773},
	{"XIMM", 4, 224628},
	{"XIMIAN", 6, 90407},
	{"XIMI", 4, 46271},
	{"XIMETA", 6, 201171},
	{"XIME", 4, 142192},
	{"XIMAGE", 6, 94317},
	{"XIMA", 4, 30082},
	{"XILO", 4, 169318},
	{"XILL", 4, 133599},
	{"XILISOFT", 8, 77782},
	{"XILINX", 6, 72820},
	{"XILI", 4, 61731},
	{"XILE", 4, 46886},
	{"XILA", 4, 168885},
	{"XIKAR", 5, 233962},
	{"XIIW", 4, 258889},
	{"XIIC", 4, 255642},
	{"XIGL", 4, 218411},
	{"XIGE", 4, 206273},
	{"XIG", 3, 33918},
	{"XIFY", 4, 220797},
	{"XIFT", 4, 241863},
	{"XIFR", 4, 259275},
	{"XIFO", 4, 227203},
	{"XIFI", 4, 163583},
	{"XIFE", 4, 243312},
	{"XIEW", 4, 187029},
	{"XIER", 4, 158865},
	{"XIEM", 4, 215653},
	{"XIEL", 4, 146692},
	{"XIED", 4, 178175},
	{"XIEC", 4, 152202},
	{"XIEB", 4, 225788},
	{"XIDR", 4, 103270},
	{"XIDI", 4, 105429},
	{"XIDE", 4, 50385},
	{"XIDA", 4, 82382},
	{"XICW", 4, 156551},
	{"XICTIONARY", 10, 202862},
	{"XICT", 4, 138302},
	{"XICS", 4, 126313},
	{"XICR", 4, 241296},
	{"XICP", 4, 186501},
	{"XICOR", 5, 218821},
	{"XICO", 4, 212597},
	{"XICM", 4, 169621},
	{"XICL", 4, 210481},
	{"XICI", 4, 100626},
	{"XICH", 4, 188418},
	{"XICG", 4, 243313},
	{"XICF", 4, 216858},
	{"XICE", 4, 177607},
	{"XICD", 4, 204854},
	{"XICC", 4, 128812},
	{"XICB", 4, 223990},
	{"XICA", 4, 36905},
	{"XIBL", 4, 55009},
	{"XIBI", 4, 57121},
	{"XIAXUE", 6, 203150},
	{"XIAW", 4, 240140},
	{"XIAR", 4, 234567},
	{"XIAOPING", 8, 106776},
	{"XIAOLIN", 7, 249984},
	{"XIAODONG", 8, 254027},
	{"XIANG", 5, 90920},
	{"XIAMEN", 6, 74066},
	{"XIAM", 4, 194080},
	{"XIAL", 4, 100383},
	{"XIAD", 4, 251143},
	{"XIAC", 4, 257777},
	{"XHUS", 4, 109841},
	{"XHUN", 4, 133228},
	{"XHUM", 4, 127699},
	{"XHU", 3, 5766},
	{"XHTML", 5, 9372},
	{"XHTM", 4, 163035},
	{"XHOU", 4, 76481},
	{"XHOST", 5, 224952},
	{"XHOSA", 5, 112535},
	{"XHOR", 4, 107953},
	{"XHOM", 4, 130340},
	{"XHOL", 4, 102521},
	{"XHO", 3, 2504},
	{"XHIM", 4, 202391},
	{"XHILARATION", 11, 195725},
	{"XHIL", 4, 98770},
	{"XHIK", 4, 115557},
	{"XHIG", 4, 148438},
	{"XHIB", 4, 32106},
	{"XHI", 3, 940},
	{"XHEW", 4, 199179},
	{"XHER", 4, 112131},
	{"XHEL", 4, 157667},
	{"XHE", 3, 4258},
	{"XHAV", 4, 85457},
	{"XHAU", 4, 45695},
	{"XHAR", 4, 144292},
	{"XHAM", 4, 111869},
	{"XHAL", 4, 91536},
	{"XHAD", 4, 79042},
	{"XHA", 3, 1130},
	{"XGZ", 3, 230195},
	{"XGY", 3, 89899},
	{"XGX", 3, 123415},
	{"XGW", 3, 107354},
	{"XGV", 3, 202339},
	{"XGUY", 4, 235775},
	{"XGUN", 4, 228219},
	{"XGUI", 4, 231825},
	{"XGU", 3, 32295},
	{"XGRO", 4, 121515},
	{"XGRE", 4, 148727},
	{"XGR", 3, 6130},
	{"XGP", 3, 171439},
	{"XGOV", 4, 214028},
	{"XGOT", 4, 183008},
	{"XGON", 4, 223746},
	{"XGOL", 4, 135441},
	{"XGOE", 4, 227710},
	{"XGOA", 4, 120903},
	{"XGO", 3, 5263},
	{"XGM", 3, 68792},
	{"XGLO", 4, 202938},
	{"XGL", 3, 148924},
	{"XGK", 3, 208383},
	{"XGIV", 4, 192487},
	{"XGIR", 4, 108164},
	{"XGF", 3, 123416},
	{"XGETTEXT", 8, 185701},
	{"XGET", 4, 171867},
	{"XGEO", 4, 250811},
	{"XGEN", 4, 234012},
	{"XGE", 3, 10059},
	{"XGD", 3, 110699},
	{"XGCC", 4, 164951},
	{"XGC", 3, 89257},
	{"XGBOX", 5, 213151},
	{"XGB", 3, 76176},
	{"XGAV", 4, 239326},
	{"XGAR", 4, 217256},
	{"XGAM", 4, 58063},
	{"XGAL", 4, 252828},
	{"XGAI", 4, 143096},
	{"XFZ", 3, 239959},
	{"XFX", 3, 67296},
	{"XFW", 3, 78507},
	{"XFV", 3, 196840},
	{"XFUT", 4, 199180},
	{"XFUR", 4, 220798},
	{"XFUN", 4, 110276},
	{"XFUL", 4, 181697},
	{"XFUE", 4, 258148},
	{"XFU", 3, 7234},
	{"XFSPROGS", 8, 205092},
	{"XFSDUMP", 7, 259841},
	{"XFRO", 4, 79351},
	{"XFRI", 4, 185233},
	{"XFREE", 5, 88138},
	{"XFRE", 4, 86988},
	{"XFRA", 4, 133354},
	{"XFR", 3, 178439},
	{"XFQ", 3, 214986},
	{"XFP", 3, 224498},
	{"XFOU", 4, 132587},
	{"XFORMS", 6, 81416},
	{"XFORM", 5, 236413},
	{"XFOO", 4, 112510},
	{"XFONTS", 6, 134238},
	{"XFOL", 4, 130264},
	{"XFO", 3, 1080},
	{"XFM", 3, 52971},
	{"XFLO", 4, 196926},
	{"XFLA", 4, 116633},
	{"XFL", 3, 156689},
	{"XFK", 3, 196841},
	{"XFJ", 3, 230196},
	{"XFIX", 4, 261943},
	{"XFIRE", 5, 100755},
	{"XFIR", 4, 120874},
	{"XFIN", 4, 86779},
	{"XFILES", 6, 250056},
	{"XFIL", 4, 94938},
	{"XFIG", 4, 122146},
	{"XFIE", 4, 161847},
	{"XFG", 3, 141796},
	{"XFF", 3, 53858},
	{"XFER", 4, 125866},
	{"XFEE", 4, 107036},
	{"XFEA", 4, 163320},
	{"XFD", 3, 232309},
	{"XFCE", 4, 89197},
	{"XFC", 3, 168251},
	{"XFAR", 4, 206083},
	{"XFAN", 4, 126875},
	{"XFAM", 4, 118721},
	{"XFAL", 4, 139080},
	{"XFAIL", 5, 135274},
	{"XFAI", 4, 174240},
	{"XFACES", 6, 135713},
	{"XFAC", 4, 90491},
	{"XEXT", 4, 178851},
	{"XEXP", 4, 162058},
	{"XEXE", 4, 98750},
	{"XEXC", 4, 197737},
	{"XEVIOUS", 7, 235617},
	{"XEVE", 4, 99949},
	{"XEVA", 4, 121459},
	{"XEUR", 4, 192488},
	{"XETRA", 5, 83823},
	{"XETEX", 5, 229339},
	{"XESY", 4, 205557},
	{"XESW", 4, 63305},
	{"XESU", 4, 144078},
	{"XESR", 4, 117769},
	{"XESP", 4, 99670},
	{"XESM", 4, 114769},
	{"XESL", 4, 121851},
	{"XESG", 4, 148789},
	{"XESF", 4, 71961},
	{"XESD", 4, 112002},
	{"XESC", 4, 90434},
	{"XESB", 4, 85010},
	{"XERYUS", 6, 233104},
	{"XERXES", 6, 124732},
	{"XERX", 4, 168721},
	{"XERW", 4, 133987},
	{"XERU", 4, 249771},
	{"XERT", 4, 180050},
	{"XERS", 4, 203104},
	{"XERR", 4, 139991},
	{"XERP", 4, 230837},
	{"XEROXED", 7, 248588},
	{"XEROX", 5, 34443},
	{"XEROSTOMIA", 10, 259900},
	{"XERODERMA", 9, 221305},
	{"XERO", 4, 156991},
	{"XERM", 4, 221223},
	{"XERISCAPING", 11, 259793},
	{"XERISCAPE", 9, 208170},
	{"XERIC", 5, 184562},
	{"XERI", 4, 132786},
	{"XERH", 4, 222419},
	{"XERG", 4, 261193},
	{"XERF", 4, 188703},
	{"XERE", 4, 187310},
	{"XERD", 4, 232365},
	{"XERCES", 6, 85374},
	{"XERC", 4, 34595},
	{"XERB", 4, 198857},
	{"XERA", 4, 110468},
	{"XEQU", 4, 205016},
	{"XEPI", 4, 147995},
	{"XENV", 4, 239039},
	{"XENU", 4, 172348},
	{"XENOTRANSPLANTATION", 19, 152911},
	{"XENOSAGA", 8, 131808},
	{"XENOS", 5, 113243},
	{"XENOPUS", 7, 76626},
	{"XENOPHON", 8, 138786},
	{"XENOPHOBIC", 10, 140450},
	{"XENOPHOBIA", 10, 94621},
	{"XENON", 5, 54701},
	{"XENOGRAFTS", 10, 209967},
	{"XENOGRAFT", 9, 211201},
	{"XENOGEARS", 9, 203186},
	{"XENOBIOTICS", 11, 185202},
	{"XENOBIOTIC", 10, 189869},
	{"XENIX", 5, 216637},
	{"XENIUM", 6, 112877},
	{"XENICAL", 7, 39931},
	{"XENIA", 5, 92482},
	{"XENG", 4, 133913},
	{"XEND", 4, 240617},
	{"XENC", 4, 221502},
	{"XENAKIS", 7, 199978},
	{"XENADRINE", 9, 94950},
	{"XEMP", 4, 44570},
	{"XEME", 4, 186376},
	{"XEMB", 4, 80773},
	{"XEMACS", 6, 43955},
	{"XEMA", 4, 223293},
	{"XELW", 4, 212205},
	{"XELT", 4, 215454},
	{"XELS", 4, 77783},
	{"XELR", 4, 117270},
	{"XELP", 4, 228966},
	{"XELODA", 6, 215619},
	{"XELO", 4, 175269},
	{"XELM", 4, 254219},
	{"XELL", 4, 147316},
	{"XELIBRI", 7, 82262},
	{"XELI", 4, 153647},
	{"XELH", 4, 238211},
	{"XELE", 4, 146766},
	{"XELD", 4, 195249},
	{"XELC", 4, 134550},
	{"XELB", 4, 203973},
	{"XELA", 4, 248040},
	{"XEIR", 4, 85356},
	{"XEIORVOBIBEWO", 13, 255630},
	{"XEGE", 4, 151245},
	{"XEG", 3, 34071},
	{"XEFF", 4, 205188},
	{"XEED", 4, 207543},
	{"XEDW", 4, 61673},
	{"XEDV", 4, 141280},
	{"XEDU", 4, 76009},
	{"XEDT", 4, 57678},
	{"XEDS", 4, 71696},
	{"XEDR", 4, 63902},
	{"XEDP", 4, 75332},
	{"XEDO", 4, 72931},
	{"XEDN", 4, 132146},
	{"XEDM", 4, 75313},
	{"XEDL", 4, 97617},
	{"XEDI", 4, 58624},
	{"XEDH", 4, 113531},
	{"XEDG", 4, 123468},
	{"XEDF", 4, 80622},
	{"XEDE", 4, 99538},
	{"XEDD", 4, 96979},
	{"XEDC", 4, 83612},
	{"XEDB", 4, 63762},
	{"XEDA", 4, 54966},
	{"XECUTIVE", 8, 181173},
	{"XECUTER", 7, 183452},
	{"XECU", 4, 6206},
	{"XECS", 4, 119738},
	{"XECO", 4, 152924},
	{"XECA", 4, 252485},
	{"XEARCH", 6, 162088},
	{"XEAR", 4, 152583},
	{"XEAC", 4, 217257},
	{"XDZ", 3, 135572},
	{"XDY", 3, 62139},
	{"XDX", 3, 248424},
	{"XDW", 3, 86243},
	{"XDVI", 4, 162808},
	{"XDUR", 4, 144079},
	{"XDUE", 4, 219288},
	{"XDSL", 4, 98937},
	{"XDRU", 4, 204477},
	{"XDRS", 4, 203588},
	{"XDRO", 4, 151591},
	{"XDRIVE", 6, 227117},
	{"XDRI", 4, 135358},
	{"XDRA", 4, 190920},
	{"XDR", 3, 98637},
	{"XDQ", 3, 175470},
	{"XDOW", 4, 165422},
	{"XDOU", 4, 214602},
	{"XDOT", 4, 260445},
	{"XDON", 4, 201397},
	{"XDOM", 4, 253534},
	{"XDOL", 4, 78656},
	{"XDOE", 4, 124318},
	{"XDOCS", 5, 144314},
	{"XDOCLET", 7, 104870},
	{"XDOC", 4, 216793},
	{"XDO", 3, 3251},
	{"XDMCP", 5, 194542},
	{"XDM", 3, 99679},
	{"XDJ", 3, 112911},
	{"XDIV", 4, 149737},
	{"XDIS", 4, 84831},
	{"XDIM", 4, 244053},
	{"XDIG", 4, 170702},
	{"XDIFF", 5, 227132},
	{"XDIF", 4, 118617},
	{"XDIE", 4, 188419},
	{"XDID", 4, 131733},
	{"XDICT", 5, 207142},
	{"XDG", 3, 157442},
	{"XDF", 3, 221450},
	{"XDEV", 4, 145083},
	{"XDET", 4, 210099},
	{"XDES", 4, 108543},
	{"XDER", 4, 185094},
	{"XDEP", 4, 159484},
	{"XDEN", 4, 211068},
	{"XDEM", 4, 201568},
	{"XDELTA", 6, 174595},
	{"XDEL", 4, 152136},
	{"XDEG", 4, 172950},
	{"XDED", 4, 113172},
	{"XDEC", 4, 101902},
	{"XDEBUG", 6, 155631},
	{"XDEB", 4, 197903},
	{"XDEA", 4, 158586},
	{"XDD", 3, 162014},
	{"XDCC", 4, 165205},
	{"XDCARD", 6, 218353},
	{"XDCAM", 5, 203917},
	{"XDC", 3, 198307},
	{"XDB", 3, 195289},
	{"XDAY", 4, 70359},
	{"XDATA", 5, 253317},
	{"XDAT", 4, 162124},
	{"XDAN", 4, 214216},
	{"XDAII", 5, 233899},
	{"XCZ", 3, 157880},
	{"XCYL", 4, 159338},
	{"XCY", 3, 37738},
	{"XCX", 3, 106756},
	{"XCW", 3, 78286},
	{"XCVR", 4, 274},
	{"XCUT", 4, 57239},
	{"XCUS", 4, 44717},
	{"XCUR", 4, 83521},
	{"XCUP", 4, 138861},
	{"XCUL", 4, 215455},
	{"XCRU", 4, 118359},
	{"XCRO", 4, 175365},
	{"XCRI", 4, 139734},
	{"XCREENSAVERS", 12, 235867},
	{"XCRE", 4, 57558},
	{"XCRA", 4, 211810},
	{"XCR", 3, 107183},
	{"XCQ", 3, 179149},
	{"XCP", 3, 131835},
	{"XCOY", 4, 169622},
	{"XCOV", 4, 200552},
	{"XCOU", 4, 58742},
	{"XCOS", 4, 216045},
	{"XCORAL", 6, 200311},
	{"XCOPY", 5, 120445},
	{"XCOP", 4, 208111},
	{"XCOO", 4, 254220},
	{"XCONQ", 5, 169112},
	{"XCONFIG", 7, 209763},
	{"XCOM", 4, 204470},
	{"XCOL", 4, 81498},
	{"XCODE", 5, 101097},
	{"XCOD", 4, 118995},
	{"XCOA", 4, 174454},
	{"XCO", 3, 1141},
	{"XCLUSIVE", 8, 246585},
	{"XCLU", 4, 32546},
	{"XCLO", 4, 117585},
	{"XCLI", 4, 144686},
	{"XCLE", 4, 219048},
	{"XCLA", 4, 71048},
	{"XCK", 3, 179150},
	{"XCJ", 3, 153332},
	{"XCITE", 5, 163656},
	{"XCIT", 4, 30678},
	{"XCIS", 4, 95732},
	{"XCIR", 4, 234884},
	{"XCIN", 4, 200828},
	{"XCIENCE", 7, 233740},
	{"XCHU", 4, 81728},
	{"XCHR", 4, 113757},
	{"XCHO", 4, 242444},
	{"XCHI", 4, 91203},
	{"XCHG", 4, 256965},
	{"XCHE", 4, 110335},
	{"XCHAT", 5, 108498},
	{"XCHANGE", 7, 78464},
	{"XCHA", 4, 28775},
	{"XCG", 3, 95978},
	{"XCF", 3, 184166},
	{"XCES", 4, 40637},
	{"XCER", 4, 72425},
	{"XCEP", 4, 8119},
	{"XCEN", 4, 123077},
	{"XCELITE", 7, 210231},
	{"XCEL", 4, 82693},
	{"XCEED", 5, 167528},
	{"XCEE", 4, 42651},
	{"XCDROAST", 8, 215800},
	{"XCD", 3, 93228},
	{"XCCESSORY", 9, 127685},
	{"XCC", 3, 183046},
	{"XCB", 3, 185568},
	{"XCAV", 4, 57226},
	{"XCAU", 4, 240730},
	{"XCAT", 4, 200487},
	{"XCAS", 4, 136330},
	{"XCARET", 6, 179504},
	{"XCAP", 4, 253138},
	{"XCAN", 4, 82842},
	{"XCAMS", 5, 143337},
	{"XCALIA", 6, 234949},
	{"XCAL", 4, 253650},
	{"XCAB", 4, 221691},
	{"XBYT", 4, 176888},
	{"XBYS", 4, 204652},
	{"XBYC", 4, 228220},
	{"XBYA", 4, 192489},
	{"XBY", 3, 6414},
	{"XBX", 3, 166753},
	{"XBV", 3, 117819},
	{"XBUT", 4, 67898},
	{"XBUS", 4, 148167},
	{"XBUR", 4, 75566},
	{"XBUL", 4, 235205},
	{"XBUI", 4, 158426},
	{"XBU", 3, 2319},
	{"XBRO", 4, 102411},
	{"XBRL", 4, 130611},
	{"XBRITE", 6, 181888},
	{"XBRI", 4, 106862},
	{"XBRE", 4, 76288},
	{"XBRA", 4, 118175},
	{"XBR", 3, 179835},
	{"XBQ", 3, 160451},
	{"XBP", 3, 92036},
	{"XBOY", 4, 116771},
	{"XBOXES", 6, 232426},
	{"XBOX", 4, 3044},
	{"XBOW", 4, 187732},
	{"XBOU", 4, 194344},
	{"XBOT", 4, 179217},
	{"XBOR", 4, 98272},
	{"XBOO", 4, 149862},
	{"XBON", 4, 249772},
	{"XBOM", 4, 201064},
	{"XBOARD", 6, 172020},
	{"XBOA", 4, 169087},
	{"XBMC", 4, 170807},
	{"XBM", 3, 158767},
	{"XBLU", 4, 256658},
	{"XBLO", 4, 144821},
	{"XBLAST", 6, 208092},
	{"XBLA", 4, 155294},
	{"XBL", 3, 125772},
	{"XBK", 3, 115326},
	{"XBJ", 3, 172125},
	{"XBIZ", 4, 231373},
	{"XBIT", 4, 240141},
	{"XBIS", 4, 252486},
	{"XBIL", 4, 95517},
	{"XBIG", 4, 236337},
	{"XBI", 3, 5911},
	{"XBG", 3, 129033},
	{"XBF", 3, 215570},
	{"XBET", 4, 145206},
	{"XBER", 4, 244801},
	{"XBEN", 4, 133229},
	{"XBEL", 4, 219832},
	{"XBEI", 4, 174346},
	{"XBEH", 4, 236338},
	{"XBEG", 4, 160404},
	{"XBEF", 4, 132347},
	{"XBEC", 4, 98286},
	{"XBEA", 4, 144195},
	{"XBD", 3, 218708},
	{"XBC", 3, 220859},
	{"XBB", 3, 231174},
	{"XBAU", 4, 188704},
	{"XBAT", 4, 143825},
	{"XBASE", 5, 124609},
	{"XBAS", 4, 81990},
	{"XBAN", 4, 144460},
	{"XBAL", 4, 193047},
	{"XBAI", 4, 211396},
	{"XBAC", 4, 167729},
	{"XAXIS", 5, 178595},
	{"XAXI", 4, 191362},
	{"XAWTV", 5, 187902},
	{"XAWA", 4, 167559},
	{"XAVO", 4, 251144},
	{"XAVIX", 5, 256499},
	{"XAVIER", 6, 43875},
	{"XAVI", 4, 239396},
	{"XAVERIAN", 8, 257295},
	{"XAVER", 5, 215888},
	{"XAVA", 4, 251145},
	{"XAUTH", 5, 160681},
	{"XAUT", 4, 175270},
	{"XATTR", 5, 196575},
	{"XATR", 4, 252139},
	{"XATOM", 5, 203326},
	{"XATL", 4, 225545},
	{"XASY", 4, 232649},
	{"XASW", 4, 66167},
	{"XASV", 4, 181698},
	{"XASU", 4, 126474},
	{"XASR", 4, 73585},
	{"XASP", 4, 74205},
	{"XASM", 4, 92616},
	{"XASL", 4, 89237},
	{"XASK", 4, 185354},
	{"XASJ", 4, 183009},
	{"XASG", 4, 120210},
	{"XASF", 4, 90265},
	{"XASER", 5, 213890},
	{"XASD", 4, 95154},
	{"XASC", 4, 71108},
	{"XASB", 4, 83265},
	{"XART", 4, 107413},
	{"XARR", 4, 172177},
	{"XARO", 4, 209680},
	{"XARM", 4, 159641},
	{"XARK", 4, 204653},
	{"XARI", 4, 136951},
	{"XARGS", 5, 130875},
	{"XARG", 4, 246931},
	{"XARE", 4, 67298},
	{"XARDS", 5, 200312},
	{"XARCH", 5, 194855},
	{"XARAYA", 6, 104527},
	{"XARA", 4, 108961},
	{"XAPR", 4, 196607},
	{"XAPPACK", 7, 226916},
	{"XAPP", 4, 93180},
	{"XAPOOL", 6, 234644},
	{"XAPO", 4, 237061},
	{"XAPIAN", 6, 128640},
	{"XAPA", 4, 202207},
	{"XANY", 4, 174544},
	{"XANTREX", 7, 88919},
	{"XANTIA", 6, 220152},
	{"XANTHUS", 7, 220300},
	{"XANTHINE", 8, 148746},
	{"XANTHIA", 7, 140062},
	{"XANTHI", 6, 196045},
	{"XANTHAN", 7, 154574},
	{"XANTH", 5, 240054},
	{"XANTECH", 7, 226069},
	{"XANTE", 5, 202300},
	{"XANGO", 5, 95495},
	{"XANGA", 5, 54280},
	{"XANEX", 5, 169788},
	{"XANDROS", 7, 96426},
	{"XANDRIA", 7, 234356},
	{"XANDER", 6, 72186},
	{"XAND", 4, 259747},
	{"XANAX", 5, 29188},
	{"XANANA", 6, 256264},
	{"XANADU", 6, 95738},
	{"XAMW", 4, 181232},
	{"XAMT", 4, 149975},
	{"XAMS", 4, 66607},
	{"XAMR", 4, 197111},
	{"XAMPP", 5, 172445},
	{"XAMPLE", 6, 224147},
	{"XAMP", 4, 4227},
	{"XAMO", 4, 139258},
	{"XAML", 4, 127418},
	{"XAMI", 4, 33936},
	{"XAMF", 4, 226232},
	{"XAME", 4, 128135},
	{"XAMC", 4, 253535},
	{"XAMB", 4, 208497},
	{"XAMA", 4, 115503},
	{"XALT", 4, 102110},
	{"XALS", 4, 95407},
	{"XALO", 4, 138804},
	{"XALL", 4, 96576},
	{"XALI", 4, 145207},
	{"XALE", 4, 216650},
	{"XALB", 4, 169539},
	{"XALAPA", 6, 245676},
	{"XALAN", 5, 93958},
	{"XALA", 4, 182392},
	{"XAKANAXA", 8, 181328},
	{"XAIR", 4, 151101},
	{"XAGR", 4, 166626},
	{"XAGO", 4, 121827},
	{"XAGG", 4, 65002},
	{"XAGE", 4, 172589},
	{"XAGA", 4, 143667},
	{"XAFT", 4, 115522},
	{"XAFS", 4, 258465},
	{"XAFF", 4, 166904},
	{"XADV", 4, 130739},
	{"XADM", 4, 217063},
	{"XADE", 4, 171672},
	{"XADD", 4, 259748},
	{"XADA", 4, 202757},
	{"XACTI", 5, 120978},
	{"XACT", 4, 96470},
	{"XACR", 4, 199348},
	{"XACO", 4, 131156},
	{"XACML", 5, 145219},
	{"XACH", 4, 140457},
	{"XACE", 4, 79405},
	{"XACC", 4, 134692},
	{"XACA", 4, 127079},
	{"XABU", 4, 164079},
	{"XABO", 4, 149976},
	{"XABL", 4, 90440},
	{"XABA", 4, 190335},
	{"X", 1, 30},
	{"WZZM", 4, 221573},
	{"WZZ", 3, 69757},
	{"WZY", 3, 112912},
	{"WZX", 3, 202340},
	{"WZV", 3, 116981},
	{"WZU", 3, 67010},
	{"WZR", 3, 238371},
	{"WZP", 3, 132803},
	{"WZON", 4, 210482},
	{"WZM", 3, 83080},
	{"WZL", 3, 116140},
	{"WZK", 3, 85134},
	{"WZJ", 3, 145365},
	{"WZG", 3, 135573},
	{"WZF", 3, 127826},
	{"WZER", 4, 154059},
	{"WZEA", 4, 37238},
	{"WZE", 3, 1173},
	{"WZDFTPD", 7, 186575},
	{"WZD", 3, 110046},
	{"WZC", 3, 131457},
	{"WYZ", 3, 51933},
	{"WYY", 3, 91649},
	{"WYX", 3, 258971},
	{"WYVERN", 6, 93482},
	{"WYVE", 4, 208112},
	{"WYV", 3, 43852},
	{"WYU", 3, 45779},
	{"WYTRYSKI", 8, 225740},
	{"WYTHNOS", 7, 166933},
	{"WYTHEVILLE", 10, 138893},
	{"WYTHENSHAWE", 11, 190595},
	{"WYTHE", 5, 127323},
	{"WYTE", 4, 246577},
	{"WYSS", 4, 151882},
	{"WYSONG", 6, 189110},
	{"WYSOKIE", 7, 123499},
	{"WYSOCKI", 7, 141361},
	{"WYSO", 4, 239327},
	{"WYSIWYG", 7, 58179},
	{"WYSI", 4, 239328},
	{"WYSE", 4, 80853},
	{"WYRM", 4, 174095},
	{"WYRICK", 6, 171555},
	{"WYRI", 4, 261567},
	{"WYRE", 4, 99758},
	{"WYRD", 4, 164729},
	{"WYR", 3, 33557},
	{"WYQ", 3, 175471},
	{"WYP", 3, 258229},
	{"WYOU", 4, 33170},
	{"WYOR", 4, 4465},
	{"WYONG", 5, 150954},
	{"WYOMISSING", 10, 150130},
	{"WYOMING", 7, 6911},
	{"WYOM", 4, 63197},
	{"WYNYARD", 7, 140278},
	{"WYNY", 4, 260048},
	{"WYNW", 4, 211811},
	{"WYNTON", 6, 109334},
	{"WYNTER", 6, 136834},
	{"WYNT", 4, 172261},
	{"WYNS", 4, 218872},
	{"WYNONNA", 7, 141676},
	{"WYNONA", 6, 223451},
	{"WYNO", 4, 224629},
	{"WYNNUM", 6, 177011},
	{"WYNNSTER", 8, 230822},
	{"WYNNS", 5, 230637},
	{"WYNNEWOOD", 9, 147862},
	{"WYNNE", 5, 73436},
	{"WYNN", 4, 59601},
	{"WYNM", 4, 210674},
	{"WYNKOOP", 7, 210288},
	{"WYNI", 4, 230583},
	{"WYNETTE", 7, 156404},
	{"WYNE", 4, 100743},
	{"WYNDHAM", 7, 50123},
	{"WYNDAM", 6, 148137},
	{"WYND", 4, 202253},
	{"WYNCOTE", 7, 234800},
	{"WYNC", 4, 245739},
	{"WYNBERG", 7, 235166},
	{"WYNB", 4, 221692},
	{"WYNA", 4, 160102},
	{"WYMORE", 6, 235970},
	{"WYMONDHAM", 9, 158580},
	{"WYMO", 4, 213400},
	{"WYMAN", 5, 80998},
	{"WYMA", 4, 139688},
	{"WYM", 3, 30974},
	{"WYLUG", 5, 174287},
	{"WYLLIE", 6, 168604},
	{"WYLIE", 5, 69160},
	{"WYLI", 4, 145855},
	{"WYLER", 5, 149769},
	{"WYLE", 4, 157204},
	{"WYLDER", 6, 157691},
	{"WYLDE", 5, 107974},
	{"WYLD", 4, 158701},
	{"WYLAND", 6, 210342},
	{"WYLA", 4, 228221},
	{"WYL", 3, 9330},
	{"WYKONAWCY", 9, 258831},
	{"WYKONAWCA", 9, 250396},
	{"WYKE", 4, 193585},
	{"WYK", 3, 133664},
	{"WYJ", 3, 88354},
	{"WYIN", 4, 230838},
	{"WYIE", 4, 199680},
	{"WYFO", 4, 257390},
	{"WYFI", 4, 250812},
	{"WYF", 3, 254520},
	{"WYETH", 5, 70236},
	{"WYET", 4, 105731},
	{"WYES", 4, 151464},
	{"WYEL", 4, 229499},
	{"WYEAST", 6, 255369},
	{"WYEA", 4, 31904},
	{"WYDI", 4, 232948},
	{"WYDEN", 5, 119537},
	{"WYDE", 4, 206432},
	{"WYDAWNICTWO", 11, 218238},
	{"WYDAWCA", 7, 232294},
	{"WYD", 3, 187782},
	{"WYCOMBE", 7, 64382},
	{"WYCO", 4, 141901},
	{"WYCLIFFE", 8, 64751},
	{"WYCLEF", 6, 105931},
	{"WYCL", 4, 164562},
	{"WYCKOFF", 7, 111158},
	{"WYCK", 4, 171313},
	{"WYCHWOOD", 8, 127569},
	{"WYCHE", 5, 207486},
	{"WYCHAVON", 8, 151202},
	{"WYCH", 4, 240832},
	{"WYC", 3, 227859},
	{"WYBODAETH", 9, 110029},
	{"WYBOD", 5, 156944},
	{"WYBIERZ", 7, 139406},
	{"WYB", 3, 39561},
	{"WYATT", 5, 51493},
	{"WYAT", 4, 85851},
	{"WYAR", 4, 129452},
	{"WYANT", 5, 195327},
	{"WYANDOTTE", 9, 90819},
	{"WYANDOT", 7, 157516},
	{"WYAN", 4, 79260},
	{"WYALUSING", 9, 245888},
	{"WYAL", 4, 248152},
	{"WYAHOO", 6, 175161},
	{"WYA", 3, 2972},
	{"WXYZ", 4, 139910},
	{"WXX", 3, 85957},
	{"WXWINDOWS", 9, 138010},
	{"WXWIDGETS", 9, 150467},
	{"WXW", 3, 64220},
	{"WXV", 3, 151210},
	{"WXU", 3, 121445},
	{"WXSTRING", 8, 178449},
	{"WXR", 3, 69758},
	{"WXPYTHON", 8, 104105},
	{"WXPP", 4, 185978},
	{"WXPORT", 6, 115313},
	{"WXPN", 4, 197625},
	{"WXPH", 4, 249977},
	{"WXP", 3, 130566},
	{"WXME", 4, 255984},
	{"WXMAP", 5, 153694},
	{"WXK", 3, 87736},
	{"WXJ", 3, 151211},
	{"WXIA", 4, 209973},
	{"WXHXD", 5, 92180},
	{"WXGTK", 5, 172349},
	{"WXGA", 4, 69963},
	{"WXG", 3, 90227},
	{"WXF", 3, 74805},
	{"WXDXH", 5, 82539},
	{"WXC", 3, 82847},
	{"WXB", 3, 55776},
	{"WX", 2, 273},
	{"WWZ", 3, 64221},
	{"WWYO", 4, 224192},
	{"WWYC", 4, 243279},
	{"WWYAHOO", 7, 151320},
	{"WWY", 3, 39442},
	{"WWX", 3, 85958},
	{"WWWYAHOOMAILCOM", 15, 257475},
	{"WWWYAHOOGAMESCOM", 16, 257488},
	{"WWWYAHOOFR", 10, 255353},
	{"WWWYAHOOES", 10, 257484},
	{"WWWYAHOOCOUK", 12, 257476},
	{"WWWYAHOOCOMMX", 13, 257485},
	{"WWWYAHOOCOMAR", 13, 257489},
	{"WWWYAHOOCOM", 11, 255955},
	{"WWWYAHOOCA", 10, 257462},
	{"WWWYAHOO", 8, 140042},
	{"WWWYAHHOOCHATCOM", 16, 257465},
	{"WWWY", 4, 186121},
	{"WWWWYAHOO", 9, 213039},
	{"WWWWEATHER", 10, 257272},
	{"WWWWE", 5, 252100},
	{"WWWW", 4, 137060},
	{"WWWVZW", 6, 257466},
	{"WWWVOILAFR", 10, 257347},
	{"WWWVODAFONEIE", 13, 257467},
	{"WWWVIRGIN", 9, 256991},
	{"WWWVIRGILIOIT", 13, 257367},
	{"WWWVIDEO", 8, 220784},
	{"WWWVIAGRA", 9, 257134},
	{"WWWVERIZONWIRELESS", 18, 257372},
	{"WWWVERIZONNET", 13, 257323},
	{"WWWVERIZONCOM", 13, 257324},
	{"WWWVERIZON", 10, 221291},
	{"WWWVDABBE", 9, 257477},
	{"WWWVAGOV", 8, 257332},
	{"WWWV", 4, 142500},
	{"WWWUTEXASEDU", 12, 257368},
	{"WWWUSPSGOV", 10, 257298},
	{"WWWUSMINTGOV", 12, 257468},
	{"WWWUSARMYMIL", 12, 257380},
	{"WWWUSAJOBSOPMGOV", 16, 257214},
	{"WWWUSAJOBSGOV", 13, 257469},
	{"WWWUPSCGOVIN", 12, 257470},
	{"WWWUNIPBR", 9, 257478},
	{"WWWUH", 5, 257327},
	{"WWWU", 4, 152203},
	{"WWWTSPGOV", 9, 257381},
	{"WWWTSAGOV", 9, 257282},
	{"WWWTOYOTA", 9, 257276},
	{"WWWTORONTOCA", 12, 257479},
	{"WWWTOMMYS", 9, 257373},
	{"WWWTMFNL", 8, 257463},
	{"WWWTHUMBNAIL", 12, 217369},
	{"WWWTHEHUNNET", 12, 257348},
	{"WWWTHEHUN", 9, 256411},
	{"WWWTHE", 6, 248070},
	{"WWWTGP", 6, 250039},
	{"WWWTERRAES", 10, 250356},
	{"WWWTEEN", 7, 232631},
	{"WWWSYMPATICOCA", 14, 234052},
	{"WWWSTATEPAUS", 12, 234074},
	{"WWWSTARWARSCOM", 14, 234013},
	{"WWWSTARTPAGINANL", 16, 233971},
	{"WWWSSAGOV", 9, 233976},
	{"WWWSQUIRTORG", 12, 234061},
	{"WWWSOUTHWEST", 12, 233678},
	{"WWWSONY", 7, 233903},
	{"WWWSMSAC", 8, 234023},
	{"WWWSEZNAMCZ", 11, 233933},
	{"WWWSEARSCA", 10, 233953},
	{"WWWSEARCH", 9, 244074},
	{"WWWSCIFICOM", 11, 234075},
	{"WWWSCIFI", 8, 234044},
	{"WWWS", 4, 70979},
	{"WWWRTLDE", 8, 233498},
	{"WWWROTTENCO", 11, 234120},
	{"WWWROTTEN", 9, 233720},
	{"WWWROOT", 7, 59946},
	{"WWWRIGHTMOVECOUK", 16, 234033},
	{"WWWRICHARDS", 11, 233934},
	{"WWWREMAXCOM", 11, 234105},
	{"WWWREMAX", 8, 234034},
	{"WWWREDWAYORG", 12, 234053},
	{"WWWRECEITAFEDERALGOVBR", 22, 234121},
	{"WWWRECEITAFAZENDAGOVBR", 22, 234122},
	{"WWWREALCOM", 10, 234004},
	{"WWWREAL", 7, 233031},
	{"WWWRAMBLERRU", 12, 233098},
	{"WWWRABOBANKNL", 13, 234084},
	{"WWWR", 4, 102590},
	{"WWWPROIBIDASFRST", 16, 234106},
	{"WWWPOST", 7, 217340},
	{"WWWPORTALEDURO", 14, 234123},
	{"WWWPOGO", 7, 233954},
	{"WWWPICTURES", 11, 249722},
	{"WWWPICS", 7, 249280},
	{"WWWPBSORG", 9, 233770},
	{"WWWPBSKIDSORG", 13, 233982},
	{"WWWP", 4, 222558},
	{"WWWOVERTURECOM", 14, 233687},
	{"WWWOVERTURE", 11, 206772},
	{"WWWOSYMGOVTR", 12, 234144},
	{"WWWOSAPGOVONCA", 14, 234145},
	{"WWWOSAPCA", 9, 234146},
	{"WWWORBITZ", 9, 231885},
	{"WWWORANGEFR", 11, 234124},
	{"WWWORANGECOUK", 13, 234147},
	{"WWWOPMGOV", 9, 233602},
	{"WWWONTARIOCA", 12, 234130},
	{"WWWONETPL", 9, 234014},
	{"WWWONELT", 8, 234097},
	{"WWWONEC", 7, 234131},
	{"WWWOLGCLOTTERIESCA", 18, 234132},
	{"WWWOLGANET", 10, 234133},
	{"WWWOFIRDK", 9, 234125},
	{"WWWOFFLE", 8, 118931},
	{"WWWOCEANFREENET", 15, 234134},
	{"WWWO", 4, 118045},
	{"WWWNETSCAPECOM", 14, 233839},
	{"WWWN", 4, 94467},
	{"WWWMSNCOUK", 10, 234085},
	{"WWWMSNCOM", 9, 233315},
	{"WWWMSNCA", 8, 234107},
	{"WWWMSN", 6, 186029},
	{"WWWMOVIES", 9, 233621},
	{"WWWMORPHEUS", 11, 234126},
	{"WWWMOBILEDE", 11, 233900},
	{"WWWMLSCA", 8, 234108},
	{"WWWMICROSOFTCOM", 15, 232500},
	{"WWWMICROSOFT", 12, 233790},
	{"WWWMETACRAWLERCOM", 17, 234045},
	{"WWWMETACRAWLER", 14, 206775},
	{"WWWMEBGOVTR", 11, 234127},
	{"WWWMARKTPLAATSNL", 16, 234086},
	{"WWWMAPQUEST", 11, 233815},
	{"WWWM", 4, 224177},
	{"WWWLYCOSNL", 10, 234128},
	{"WWWLYCOSDE", 10, 234098},
	{"WWWLYCOSCOUK", 12, 234076},
	{"WWWLYCOSCOM", 11, 233636},
	{"WWWLYCOS", 8, 206745},
	{"WWWLUNARSTORMSE", 15, 234109},
	{"WWWLOTTERY", 10, 233703},
	{"WWWLITEROTICA", 13, 234077},
	{"WWWLIL", 6, 234035},
	{"WWWLIBEROIT", 11, 234078},
	{"WWWLDSORG", 9, 234036},
	{"WWWLABORSTATENYUS", 17, 234054},
	{"WWWL", 4, 106839},
	{"WWWKRO", 6, 234079},
	{"WWWKQEDORG", 10, 234148},
	{"WWWKPNNL", 8, 234149},
	{"WWWKOHLSCOM", 11, 234135},
	{"WWWKOHL", 7, 234136},
	{"WWWKIDS", 7, 233725},
	{"WWWKAZAACOM", 11, 233972},
	{"WWWKAZAA", 8, 233904},
	{"WWWKACHINGOCONZ", 15, 234137},
	{"WWWKAARTENHUISNL", 16, 234138},
	{"WWWK", 4, 136588},
	{"WWWJUMPYIT", 10, 234139},
	{"WWWJUBIIDK", 10, 234087},
	{"WWWJOYCEMEYERORG", 16, 234110},
	{"WWWJOS", 6, 234111},
	{"WWWJOHNSTON", 11, 234140},
	{"WWWJOBSEARCHGOVAU", 17, 234141},
	{"WWWJOBSEARCH", 12, 233306},
	{"WWWJOBCENTREPLUSGOVUK", 21, 234024},
	{"WWWJOBBANKGCCA", 14, 234112},
	{"WWWJENNIFER", 11, 233741},
	{"WWWJEN", 6, 234025},
	{"WWWJAMBONLINEORG", 16, 234142},
	{"WWWJA", 5, 233983},
	{"WWWJ", 4, 225218},
	{"WWWIWONCOM", 10, 234055},
	{"WWWIWON", 7, 234056},
	{"WWWIUBEDU", 9, 234062},
	{"WWWISKONHR", 10, 234080},
	{"WWWIRSGOV", 9, 232757},
	{"WWWIOLIT", 8, 234113},
	{"WWWINTERIAPL", 12, 234099},
	{"WWWINSUSDOJGOV", 14, 234046},
	{"WWWINSGOV", 9, 234100},
	{"WWWINGR", 7, 234081},
	{"WWWINGOV", 8, 234101},
	{"WWWINGDIRECTCA", 14, 234114},
	{"WWWINFOSPACECOM", 15, 234063},
	{"WWWIMDBCOM", 10, 233927},
	{"WWWILSENL", 9, 234064},
	{"WWWIINFOSPACE", 13, 234102},
	{"WWWIG", 5, 234026},
	{"WWWIBANKBARCLAYSCOUK", 20, 234037},
	{"WWWI", 4, 102995},
	{"WWWHUSH", 7, 234027},
	{"WWWHSBCCOUK", 11, 234019},
	{"WWWHOTMAILCOUK", 14, 234065},
	{"WWWHOTMAILCOM", 13, 226786},
	{"WWWHOTMAILCO", 12, 234088},
	{"WWWHOTMAIL", 10, 229638},
	{"WWWHOTELS", 9, 206605},
	{"WWWHOTBOT", 9, 234115},
	{"WWWHOT", 6, 228946},
	{"WWWHARRY", 8, 233984},
	{"WWWHALIFAXCOUK", 14, 234089},
	{"WWWH", 4, 220694},
	{"WWWGOOGLES", 10, 234090},
	{"WWWGOOGLENL", 11, 234047},
	{"WWWGOOGLEIT", 11, 234048},
	{"WWWGOOGLEFR", 11, 234001},
	{"WWWGOOGLEDE", 11, 233905},
	{"WWWGOOGLECOUK", 13, 233963},
	{"WWWGOOGLECOM", 12, 204772},
	{"WWWGOOGLECA", 11, 234002},
	{"WWWGOOGLE", 9, 180921},
	{"WWWGOO", 6, 206248},
	{"WWWGOMNETEG", 11, 234082},
	{"WWWGOGPILE", 10, 234083},
	{"WWWGOCOM", 8, 234020},
	{"WWWGO", 5, 233609},
	{"WWWGMXDE", 8, 234066},
	{"WWWGLOBOCOM", 11, 234028},
	{"WWWGLOBO", 8, 234029},
	{"WWWGEOCITIES", 12, 233705},
	{"WWWGALLERIES", 12, 249849},
	{"WWWG", 4, 225031},
	{"WWWFUTURE", 9, 233973},
	{"WWWFUNDANL", 10, 234057},
	{"WWWFRIENDSREUNITEDCOUK", 22, 234038},
	{"WWWFREE", 7, 259395},
	{"WWWFOX", 6, 233802},
	{"WWWFORD", 7, 232907},
	{"WWWFGTSCAIXAGOVBR", 17, 234067},
	{"WWWFETISH", 9, 249765},
	{"WWWFANFICTIONNET", 16, 233582},
	{"WWWFAMILYSEARCHORG", 18, 234068},
	{"WWWFAMILYCA", 11, 234049},
	{"WWWFAFSAGOV", 11, 234058},
	{"WWWFAFSAEDGOV", 13, 233796},
	{"WWWFACIALS", 10, 250173},
	{"WWWEXPEDIA", 10, 233779},
	{"WWWEXCITE", 9, 233955},
	{"WWWESTUPROSREAISCATC", 20, 234069},
	{"WWWESTRUPOSREAISCATC", 20, 234070},
	{"WWWEDDCAGOV", 11, 234091},
	{"WWWEBAYDE", 9, 234015},
	{"WWWEBAYCOUK", 11, 233897},
	{"WWWEBAYCOM", 10, 231370},
	{"WWWEBAYCA", 9, 233821},
	{"WWWEBAY", 7, 231636},
	{"WWWEASTENDERSCOUK", 17, 234116},
	{"WWWEARTHLINKNET", 15, 234059},
	{"WWWEAMCETAPNICIN", 16, 234117},
	{"WWWE", 4, 214125},
	{"WWWDRAGONBALL", 13, 233935},
	{"WWWDOWNLOAD", 11, 233591},
	{"WWWDOGPILECOM", 13, 233831},
	{"WWWDOCS", 7, 213725},
	{"WWWDMVGOV", 9, 234103},
	{"WWWDMVCAGOV", 11, 234071},
	{"WWWDLISTATEPAUS", 15, 234104},
	{"WWWDISNEY", 9, 232637},
	{"WWWDISCOVERY", 12, 234005},
	{"WWWDIGIMON", 10, 234050},
	{"WWWDELLCOM", 10, 233038},
	{"WWWDELL", 7, 232526},
	{"WWWDAUMNET", 10, 233936},
	{"WWWD", 4, 224173},
	{"WWWCOM", 6, 227923},
	{"WWWCNNCOM", 9, 233771},
	{"WWWCHAT", 7, 232030},
	{"WWWCCASFR", 9, 234030},
	{"WWWCARTOONNETWORK", 17, 233136},
	{"WWWCARTOON", 10, 232352},
	{"WWWCAPITALONE", 13, 233937},
	{"WWWCAIXAGOVBR", 13, 234021},
	{"WWWC", 4, 224146},
	{"WWWBRITNEY", 10, 233832},
	{"WWWBOOK", 7, 233552},
	{"WWWBOARD", 8, 99841},
	{"WWWBINGO", 8, 233928},
	{"WWWBELLSOUTHNET", 15, 233956},
	{"WWWBBCCOUK", 10, 233670},
	{"WWWBARNES", 9, 233791},
	{"WWWBARBIE", 9, 233752},
	{"WWWBANKOFAMERICA", 16, 233062},
	{"WWWB", 4, 223643},
	{"WWWAUTOTRADERCOUK", 17, 233945},
	{"WWWATTNET", 9, 233929},
	{"WWWATTBICOM", 11, 233957},
	{"WWWATOGOVAU", 11, 233985},
	{"WWWAT", 5, 233772},
	{"WWWASKJEEVESCOUK", 16, 233986},
	{"WWWASKJEEVESCC", 14, 233987},
	{"WWWASKJEEVES", 12, 233316},
	{"WWWASKCOUK", 10, 233938},
	{"WWWASKCOM", 9, 233736},
	{"WWWASK", 6, 233604},
	{"WWWASIAN", 8, 247697},
	{"WWWARWROCPL", 11, 233988},
	{"WWWAOLCOM", 9, 232283},
	{"WWWAOL", 6, 206141},
	{"WWWANWBNL", 9, 233989},
	{"WWWAMAZONCOM", 12, 233562},
	{"WWWAMAZON", 9, 233196},
	{"WWWALTAVISTACOM", 15, 233730},
	{"WWWALTAVISTA", 12, 204630},
	{"WWWAKSJEEVESCOM", 15, 233977},
	{"WWWAIRMILESCA", 13, 233990},
	{"WWWAIRCANADACA", 14, 233939},
	{"WWWAGUIUCEDU", 12, 233991},
	{"WWWABNAMRONL", 12, 233974},
	{"WWWA", 4, 79053},
	{"WWW", 3, 3048},
	{"WWVI", 4, 208113},
	{"WWV", 3, 230480},
	{"WWUS", 4, 246616},
	{"WWUN", 4, 260847},
	{"WWU", 3, 158094},
	{"WWTR", 4, 201398},
	{"WWTP", 4, 109027},
	{"WWTO", 4, 214406},
	{"WWTI", 4, 196294},
	{"WWTH", 4, 116437},
	{"WWTA", 4, 240142},
	{"WWSYMPA", 7, 100078},
	{"WWSU", 4, 226495},
	{"WWST", 4, 138638},
	{"WWSP", 4, 229225},
	{"WWSO", 4, 193048},
	{"WWSLOG", 6, 189650},
	{"WWSI", 4, 260049},
	{"WWSH", 4, 220366},
	{"WWSE", 4, 172872},
	{"WWSC", 4, 223063},
	{"WWSA", 4, 162698},
	{"WWRO", 4, 122324},
	{"WWRITE", 6, 101961},
	{"WWRI", 4, 96340},
	{"WWRE", 4, 127485},
	{"WWRA", 4, 196000},
	{"WWR", 3, 161664},
	{"WWQ", 3, 66270},
	{"WWPR", 4, 201399},
	{"WWPO", 4, 227933},
	{"WWPI", 4, 260446},
	{"WWPE", 4, 229226},
	{"WWPA", 4, 172951},
	{"WWP", 3, 107905},
	{"WWOW", 4, 139499},
	{"WWOU", 4, 53199},
	{"WWOR", 4, 220926},
	{"WWOOD", 5, 243860},
	{"WWOO", 4, 123588},
	{"WWON", 4, 94046},
	{"WWOM", 4, 109877},
	{"WWOL", 4, 183010},
	{"WWNO", 4, 179550},
	{"WWNETSCAPE", 10, 233964},
	{"WWNE", 4, 184969},
	{"WWNA", 4, 184091},
	{"WWMY", 4, 185095},
	{"WWMO", 4, 179551},
	{"WWMI", 4, 182270},
	{"WWME", 4, 178852},
	{"WWMA", 4, 136952},
	{"WWM", 3, 247677},
	{"WWLO", 4, 252140},
	{"WWLI", 4, 199349},
	{"WWLE", 4, 224630},
	{"WWLA", 4, 190770},
	{"WWL", 3, 151334},
	{"WWKI", 4, 260848},
	{"WWJD", 4, 145562},
	{"WWJ", 3, 252907},
	{"WWIT", 4, 34836},
	{"WWIS", 4, 159961},
	{"WWIR", 4, 171868},
	{"WWIN", 4, 67717},
	{"WWIL", 4, 45131},
	{"WWIII", 5, 231715},
	{"WWII", 4, 41014},
	{"WWIF", 4, 134266},
	{"WWID", 4, 105013},
	{"WWIC", 4, 245112},
	{"WWHY", 4, 61047},
	{"WWHO", 4, 44237},
	{"WWHI", 4, 45052},
	{"WWHE", 4, 38159},
	{"WWHA", 4, 31419},
	{"WWGR", 4, 181458},
	{"WWGO", 4, 183974},
	{"WWGE", 4, 243617},
	{"WWGA", 4, 230281},
	{"WWFW", 4, 225072},
	{"WWFT", 4, 211445},
	{"WWFS", 4, 202573},
	{"WWFR", 4, 183119},
	{"WWFO", 4, 203806},
	{"WWFL", 4, 255643},
	{"WWFI", 4, 165423},
	{"WWFC", 4, 199350},
	{"WWFA", 4, 153528},
	{"WWF", 3, 46757},
	{"WWEW", 4, 76846},
	{"WWEV", 4, 108199},
	{"WWEU", 4, 193775},
	{"WWET", 4, 114365},
	{"WWES", 4, 72190},
	{"WWER", 4, 52473},
	{"WWEP", 4, 134415},
	{"WWEO", 4, 219289},
	{"WWEN", 4, 93159},
	{"WWEM", 4, 126074},
	{"WWEL", 4, 52630},
	{"WWEK", 4, 144238},
	{"WWEJ", 4, 221224},
	{"WWEI", 4, 112345},
	{"WWEH", 4, 67396},
	{"WWEG", 4, 122196},
	{"WWEF", 4, 149190},
	{"WWEE", 4, 44902},
	{"WWED", 4, 87882},
	{"WWEC", 4, 70851},
	{"WWEA", 4, 60815},
	{"WWDO", 4, 222853},
	{"WWDI", 4, 231826},
	{"WWDE", 4, 197574},
	{"WWDC", 4, 156545},
	{"WWDA", 4, 223528},
	{"WWD", 3, 156084},
	{"WWCR", 4, 220173},
	{"WWCO", 4, 135202},
	{"WWCL", 4, 237675},
	{"WWCI", 4, 211446},
	{"WWCH", 4, 157104},
	{"WWCA", 4, 136286},
	{"WWC", 3, 125132},
	{"WWBU", 4, 250813},
	{"WWBR", 4, 182866},
	{"WWBO", 4, 213213},
	{"WWBL", 4, 250106},
	{"WWBI", 4, 231566},
	{"WWBE", 4, 194499},
	{"WWBC", 4, 249979},
	{"WWBA", 4, 172952},
	{"WWB", 3, 215520},
	{"WWAV", 4, 89762},
	{"WWAT", 4, 70942},
	{"WWAS", 4, 37121},
	{"WWAR", 4, 81560},
	{"WWAN", 4, 254162},
	{"WWAM", 4, 227456},
	{"WWAL", 4, 81350},
	{"WWAI", 4, 156111},
	{"WWAG", 4, 123878},
	{"WWAD", 4, 221503},
	{"WWAC", 4, 218412},
	{"WVY", 3, 115327},
	{"WVX", 3, 149140},
	{"WVW", 3, 59558},
	{"WVV", 3, 92781},
	{"WVUL", 4, 243314},
	{"WVU", 3, 79727},
	{"WVSTREAM", 8, 255562},
	{"WVQ", 3, 151212},
	{"WVP", 3, 66271},
	{"WVOT", 4, 106840},
	{"WVOL", 4, 89422},
	{"WVOI", 4, 144139},
	{"WVOC", 4, 189802},
	{"WVK", 3, 103753},
	{"WVJ", 3, 122412},
	{"WVIT", 4, 229982},
	{"WVIS", 4, 87407},
	{"WVIR", 4, 133772},
	{"WVIO", 4, 131578},
	{"WVIN", 4, 191778},
	{"WVIL", 4, 117552},
	{"WVIE", 4, 117665},
	{"WVID", 4, 123156},
	{"WVIC", 4, 110935},
	{"WVIA", 4, 192622},
	{"WVG", 3, 73478},
	{"WVF", 3, 72839},
	{"WVET", 4, 183606},
	{"WVES", 4, 217943},
	{"WVER", 4, 59741},
	{"WVEN", 4, 106994},
	{"WVEL", 4, 237676},
	{"WVEH", 4, 117010},
	{"WVEG", 4, 175620},
	{"WVEC", 4, 213253},
	{"WVDIAL", 6, 158416},
	{"WVC", 3, 203598},
	{"WVAW", 4, 218637},
	{"WVAT", 4, 254594},
	{"WVAS", 4, 215456},
	{"WVAR", 4, 110936},
	{"WVAN", 4, 139205},
	{"WVAL", 4, 85611},
	{"WVAC", 4, 169263},
	{"WVAA", 4, 204654},
	{"WUZZY", 5, 254672},
	{"WUZZADEM", 8, 184702},
	{"WUZ", 3, 103380},
	{"WUYI", 4, 225936},
	{"WUY", 3, 45240},
	{"WUXIA", 5, 204115},
	{"WUXI", 4, 117703},
	{"WUXGA", 5, 223046},
	{"WUX", 3, 47125},
	{"WUWA", 4, 212796},
	{"WUW", 3, 37178},
	{"WUV", 3, 213720},
	{"WUU", 3, 77876},
	{"WUTS", 4, 228856},
	{"WUTI", 4, 245113},
	{"WUTHERING", 9, 101167},
	{"WUTC", 4, 160087},
	{"WUTA", 4, 160807},
	{"WUSW", 4, 226973},
	{"WUSU", 4, 138487},
	{"WUSTL", 5, 244093},
	{"WUSTHOF", 7, 93303},
	{"WUST", 4, 95536},
	{"WUSSY", 5, 212968},
	{"WUSSES", 6, 202376},
	{"WUSS", 4, 144861},
	{"WUSP", 4, 225984},
	{"WUSO", 4, 207201},
	{"WUSI", 4, 128136},
	{"WUSHU", 5, 121969},
	{"WUSH", 4, 146463},
	{"WUSE", 4, 64081},
	{"WUSB", 4, 253882},
	{"WUSAGE", 6, 216243},
	{"WUSA", 4, 146792},
	{"WURZBURG", 8, 166269},
	{"WURZ", 4, 244272},
	{"WURTZEL", 7, 247490},
	{"WURTZ", 5, 223611},
	{"WURTTEMBERG", 11, 167892},
	{"WURTH", 5, 244737},
	{"WURT", 4, 220596},
	{"WURSTER", 7, 222096},
	{"WURST", 5, 163896},
	{"WURS", 4, 168182},
	{"WURMAN", 6, 260730},
	{"WURM", 4, 158613},
	{"WURLITZER", 9, 114126},
	{"WURL", 4, 223529},
	{"WURG", 4, 255282},
	{"WURFL", 5, 231467},
	{"WURDEN", 6, 119222},
	{"WURDE", 5, 85347},
	{"WURB", 4, 168622},
	{"WUR", 3, 224450},
	{"WUQ", 3, 88045},
	{"WUPW", 4, 74735},
	{"WUPU", 4, 219049},
	{"WUPT", 4, 58699},
	{"WUPS", 4, 85148},
	{"WUPR", 4, 132536},
	{"WUPQ", 4, 224406},
	{"WUPPERTAL", 9, 96939},
	{"WUPP", 4, 109516},
	{"WUPO", 4, 69194},
	{"WUPN", 4, 170265},
	{"WUPM", 4, 155558},
	{"WUPL", 4, 139307},
	{"WUPI", 4, 47119},
	{"WUPH", 4, 119062},
	{"WUPG", 4, 200553},
	{"WUPF", 4, 102500},
	{"WUPE", 4, 153124},
	{"WUPD", 4, 137250},
	{"WUPC", 4, 147094},
	{"WUPB", 4, 129453},
	{"WUPA", 4, 55783},
	{"WUORNOS", 7, 185158},
	{"WUNZHANG", 8, 226395},
	{"WUNUSED", 7, 175570},
	{"WUNT", 4, 86857},
	{"WUNSCH", 6, 138467},
	{"WUNS", 4, 173925},
	{"WUNR", 4, 256333},
	{"WUNP", 4, 222164},
	{"WUNL", 4, 151465},
	{"WUNI", 4, 63452},
	{"WUNG", 4, 80589},
	{"WUNF", 4, 186624},
	{"WUNE", 4, 158866},
	{"WUNDERLICH", 10, 135425},
	{"WUNDERKIND", 10, 195543},
	{"WUNDERGROUND", 12, 148159},
	{"WUNDERBLOG", 10, 162179},
	{"WUNDER", 6, 58551},
	{"WUNDEF", 6, 91787},
	{"WUND", 4, 65199},
	{"WUNC", 4, 245873},
	{"WUNA", 4, 194962},
	{"WUMPUS", 6, 256925},
	{"WUMPSCUT", 8, 187297},
	{"WUMM", 4, 167796},
	{"WUMI", 4, 252829},
	{"WUMA", 4, 259276},
	{"WUM", 3, 152829},
	{"WULT", 4, 234568},
	{"WULI", 4, 251146},
	{"WULFF", 5, 138674},
	{"WULF", 4, 93898},
	{"WUK", 3, 195016},
	{"WUJIANG", 7, 236999},
	{"WUJI", 4, 258890},
	{"WUJ", 3, 46323},
	{"WUITE", 5, 257948},
	{"WUIS", 4, 251776},
	{"WUIN", 4, 252830},
	{"WUHRER", 6, 169988},
	{"WUHN", 4, 218512},
	{"WUHAN", 5, 86651},
	{"WUHA", 4, 162533},
	{"WUGNET", 6, 167936},
	{"WUGGAWOO", 8, 180541},
	{"WUFTPD", 6, 170936},
	{"WUFEI", 5, 240912},
	{"WUF", 3, 42282},
	{"WUERZBURG", 9, 173241},
	{"WUERTTEMBERG", 12, 190393},
	{"WUER", 4, 214217},
	{"WUDI", 4, 251777},
	{"WUD", 3, 272},
	{"WUCH", 4, 202661},
	{"WUC", 3, 92381},
	{"WUB", 3, 169344},
	{"WUAN", 4, 164461},
	{"WTZR", 4, 181326},
	{"WTYP", 4, 89427},
	{"WTWO", 4, 71350},
	{"WTWI", 4, 116313},
	{"WTWE", 4, 190921},
	{"WTVS", 4, 201569},
	{"WTUR", 4, 82500},
	{"WTUN", 4, 149580},
	{"WTUE", 4, 202208},
	{"WTUC", 4, 132226},
	{"WTUB", 4, 216046},
	{"WTTW", 4, 220262},
	{"WTTS", 4, 263},
	{"WTTORNEY", 8, 243522},
	{"WTTC", 4, 209799},
	{"WTRY", 4, 120180},
	{"WTRU", 4, 92358},
	{"WTRI", 4, 71380},
	{"WTRE", 4, 78046},
	{"WTRADITIONAL", 12, 117067},
	{"WTRA", 4, 51567},
	{"WTOY", 4, 131985},
	{"WTOW", 4, 53493},
	{"WTOV", 4, 147648},
	{"WTOU", 4, 61347},
	{"WTORIES", 7, 234196},
	{"WTOR", 4, 55209},
	{"WTOP", 4, 117153},
	{"WTOM", 4, 53283},
	{"WTOK", 4, 103801},
	{"WTOJ", 4, 162619},
	{"WTOG", 4, 59592},
	{"WTOF", 4, 66511},
	{"WTOD", 4, 52116},
	{"WTOB", 4, 52998},
	{"WTMP", 4, 206752},
	{"WTMJ", 4, 206880},
	{"WTLS", 4, 249410},
	{"WTIR", 4, 138974},
	{"WTIP", 4, 191923},
	{"WTIM", 4, 53907},
	{"WTIL", 4, 211447},
	{"WTIG", 4, 163036},
	{"WTID", 4, 147200},
	{"WTHY", 4, 250107},
	{"WTHW", 4, 72645},
	{"WTHU", 4, 124753},
	{"WTHR", 4, 219817},
	{"WTHP", 4, 81397},
	{"WTHM", 4, 105936},
	{"WTHL", 4, 160484},
	{"WTHI", 4, 31922},
	{"WTHG", 4, 195399},
	{"WTHF", 4, 78688},
	{"WTHD", 4, 115992},
	{"WTHC", 4, 91588},
	{"WTHB", 4, 99320},
	{"WTHA", 4, 5982},
	{"WTGI", 4, 169903},
	{"WTEX", 4, 126846},
	{"WTER", 4, 76308},
	{"WTEM", 4, 98176},
	{"WTEL", 4, 97223},
	{"WTCC", 4, 257589},
	{"WTAX", 4, 82741},
	{"WTAR", 4, 129013},
	{"WTAMU", 5, 231504},
	{"WTAM", 4, 215457},
	{"WTAL", 4, 86178},
	{"WTAK", 4, 80453},
	{"WTAG", 4, 215036},
	{"WTAC", 4, 163836},
	{"WTAB", 4, 148728},
	{"WSZYSTKO", 8, 238561},
	{"WSZYSTKIE", 9, 155840},
	{"WSYS", 4, 74255},
	{"WSYO", 4, 62056},
	{"WSYN", 4, 167135},
	{"WSYM", 4, 150668},
	{"WSYE", 4, 162465},
	{"WSYA", 4, 228222},
	{"WSXP", 4, 96324},
	{"WSXGA", 5, 171432},
	{"WSWS", 4, 113748},
	{"WSWR", 4, 162028},
	{"WSWO", 4, 68595},
	{"WSWI", 4, 45364},
	{"WSWH", 4, 42210},
	{"WSWE", 4, 45569},
	{"WSWA", 4, 65489},
	{"WSVO", 4, 208918},
	{"WSVI", 4, 80356},
	{"WSVE", 4, 117860},
	{"WSVA", 4, 151031},
	{"WSUT", 4, 228707},
	{"WSUS", 4, 169444},
	{"WSUR", 4, 73788},
	{"WSUP", 4, 48489},
	{"WSUNIT", 6, 245645},
	{"WSUN", 4, 80691},
	{"WSUL", 4, 171475},
	{"WSUI", 4, 41218},
	{"WSUG", 4, 137897},
	{"WSUF", 4, 154379},
	{"WSUD", 4, 194963},
	{"WSUC", 4, 77496},
	{"WSUB", 4, 81541},
	{"WSTY", 4, 101711},
	{"WSTW", 4, 130665},
	{"WSTV", 4, 235483},
	{"WSTU", 4, 52762},
	{"WSTRICT", 7, 66254},
	{"WSTP", 4, 260050},
	{"WSTOSO", 6, 249509},
	{"WSTNSAND", 8, 74454},
	{"WSTH", 4, 8477},
	{"WSTAT", 5, 253052},
	{"WSSY", 4, 183845},
	{"WSSW", 4, 238212},
	{"WSSU", 4, 243418},
	{"WSSP", 4, 97915},
	{"WSSL", 4, 176366},
	{"WSSK", 4, 244802},
	{"WSSD", 4, 116210},
	{"WSSC", 4, 234490},
	{"WSRU", 4, 133600},
	{"WSRT", 4, 176544},
	{"WSRP", 4, 125461},
	{"WSRO", 4, 82070},
	{"WSRI", 4, 134850},
	{"WSRF", 4, 172010},
	{"WSRE", 4, 45339},
	{"WSRC", 4, 171709},
	{"WSRA", 4, 94129},
	{"WSQU", 4, 98053},
	{"WSQ", 3, 9966},
	{"WSPU", 4, 118046},
	{"WSPR", 4, 54749},
	{"WSPO", 4, 63807},
	{"WSPL", 4, 90781},
	{"WSPI", 4, 95537},
	{"WSPH", 4, 115504},
	{"WSPE", 4, 51275},
	{"WSPD", 4, 218030},
	{"WSPA", 4, 219670},
	{"WSOW", 4, 139634},
	{"WSOV", 4, 103629},
	{"WSOU", 4, 48353},
	{"WSOR", 4, 61153},
	{"WSOP", 4, 50739},
	{"WSON", 4, 36330},
	{"WSOM", 4, 44581},
	{"WSOL", 4, 79569},
	{"WSOF", 4, 36646},
	{"WSOD", 4, 170703},
	{"WSOB", 4, 153186},
	{"WSMY", 4, 153841},
	{"WSMV", 4, 237045},
	{"WSMU", 4, 109395},
	{"WSMS", 4, 103653},
	{"WSMO", 4, 213649},
	{"WSML", 4, 237568},
	{"WSMI", 4, 83586},
	{"WSME", 4, 62546},
	{"WSMC", 4, 242445},
	{"WSMA", 4, 50879},
	{"WSLU", 4, 174241},
	{"WSLO", 4, 80901},
	{"WSLI", 4, 61905},
	{"WSLE", 4, 57682},
	{"WSLA", 4, 78718},
	{"WSKY", 4, 107662},
	{"WSKN", 4, 201065},
	{"WSKI", 4, 40521},
	{"WSKE", 4, 138975},
	{"WSKA", 4, 116725},
	{"WSJU", 4, 98037},
	{"WSJR", 4, 252831},
	{"WSJO", 4, 132147},
	{"WSJE", 4, 205735},
	{"WSJA", 4, 139851},
	{"WSIZ", 4, 241016},
	{"WSIX", 4, 121460},
	{"WSIW", 4, 223294},
	{"WSIR", 4, 190336},
	{"WSIN", 4, 35228},
	{"WSIM", 4, 80636},
	{"WSIL", 4, 110580},
	{"WSIGN", 5, 162608},
	{"WSIG", 4, 74521},
	{"WSIF", 4, 213112},
	{"WSID", 4, 108912},
	{"WSIC", 4, 170266},
	{"WSIB", 4, 176425},
	{"WSHR", 4, 220174},
	{"WSHADOW", 7, 158182},
	{"WSGU", 4, 193316},
	{"WSGR", 4, 94887},
	{"WSGO", 4, 101531},
	{"WSGI", 4, 252358},
	{"WSGE", 4, 125055},
	{"WSGA", 4, 110581},
	{"WSFU", 4, 150153},
	{"WSFR", 4, 52187},
	{"WSFO", 4, 42506},
	{"WSFI", 4, 80573},
	{"WSFE", 4, 98801},
	{"WSEY", 4, 250459},
	{"WSEW", 4, 176653},
	{"WSEV", 4, 67556},
	{"WSER", 4, 40868},
	{"WSEQ", 4, 220799},
	{"WSEP", 4, 136542},
	{"WSEM", 4, 124121},
	{"WSEL", 4, 84832},
	{"WSEG", 4, 162779},
	{"WSEF", 4, 246617},
	{"WSED", 4, 113849},
	{"WSEC", 4, 62415},
	{"WSEAS", 5, 252767},
	{"WSDU", 4, 111961},
	{"WSDR", 4, 133178},
	{"WSDOT", 5, 92835},
	{"WSDO", 4, 75065},
	{"WSDM", 4, 209953},
	{"WSDL", 4, 53055},
	{"WSDI", 4, 82686},
	{"WSDE", 4, 70786},
	{"WSDA", 4, 234729},
	{"WSCY", 4, 184476},
	{"WSCU", 4, 125529},
	{"WSCR", 4, 78930},
	{"WSCO", 4, 40332},
	{"WSCL", 4, 100476},
	{"WSCF", 4, 258746},
	{"WSCE", 4, 103457},
	{"WSCC", 4, 160212},
	{"WSBY", 4, 87309},
	{"WSBU", 4, 55670},
	{"WSBR", 4, 84975},
	{"WSBPEL", 6, 223638},
	{"WSBO", 4, 96639},
	{"WSBL", 4, 132459},
	{"WSBK", 4, 173459},
	{"WSBI", 4, 141049},
	{"WSBE", 4, 61428},
	{"WSBA", 4, 217030},
	{"WSAZ", 4, 172059},
	{"WSAY", 4, 70994},
	{"WSAV", 4, 115097},
	{"WSAU", 4, 114692},
	{"WSAR", 4, 46515},
	{"WSAP", 4, 78401},
	{"WSAN", 4, 30528},
	{"WSAM", 4, 87509},
	{"WSAL", 4, 54371},
	{"WSAK", 4, 252487},
	{"WSAG", 4, 66941},
	{"WSAF", 4, 80825},
	{"WSAD", 4, 194794},
	{"WSABI", 5, 245945},
	{"WSAB", 4, 62737},
	{"WRZB", 4, 180770},
	{"WRZ", 3, 40630},
	{"WRYW", 4, 173926},
	{"WRYT", 4, 215037},
	{"WRYS", 4, 147761},
	{"WRYO", 4, 242446},
	{"WRYLY", 5, 162998},
	{"WRYL", 4, 203807},
	{"WRYI", 4, 225789},
	{"WRYH", 4, 256334},
	{"WRYC", 4, 254221},
	{"WRYA", 4, 127238},
	{"WRY", 3, 87519},
	{"WRX", 3, 73583},
	{"WRUS", 4, 112062},
	{"WRUNG", 5, 145502},
	{"WRUN", 4, 75151},
	{"WRUL", 4, 74289},
	{"WRUB", 4, 223295},
	{"WRU", 3, 163001},
	{"WRTY", 4, 250375},
	{"WRTT", 4, 126938},
	{"WRTH", 4, 95700},
	{"WRTE", 4, 255512},
	{"WRST", 4, 249437},
	{"WRSQ", 4, 165424},
	{"WRR", 3, 150515},
	{"WRQ", 3, 164194},
	{"WRP", 3, 153689},
	{"WROY", 4, 187864},
	{"WROXHAM", 7, 250588},
	{"WROX", 4, 105913},
	{"WROW", 4, 188281},
	{"WROUGHT", 7, 45957},
	{"WROU", 4, 68692},
	{"WROTH", 5, 164936},
	{"WROTE", 5, 2349},
	{"WROS", 4, 115659},
	{"WROO", 4, 72755},
	{"WRONGS", 6, 67776},
	{"WRONGNESS", 9, 195385},
	{"WRONGLY", 7, 61952},
	{"WRONGHEADED", 11, 242871},
	{"WRONGFULLY", 10, 99431},
	{"WRONGFUL", 8, 46661},
	{"WRONGED", 7, 104539},
	{"WRONGDOINGS", 11, 231621},
	{"WRONGDOING", 10, 72925},
	{"WRONGDOERS", 10, 194994},
	{"WRONGDOER", 9, 199589},
	{"WRONG", 5, 2120},
	{"WRON", 4, 8943},
	{"WROM", 4, 133640},
	{"WROL", 4, 91884},
	{"WROG", 4, 228223},
	{"WROD", 4, 198829},
	{"WROCLAW", 7, 85490},
	{"WROC", 4, 126160},
	{"WROBLEWSKI", 10, 239146},
	{"WROBEL", 6, 192037},
	{"WROB", 4, 109416},
	{"WROA", 4, 80279},
	{"WRNTY", 5, 226599},
	{"WRMA", 4, 228967},
	{"WRM", 3, 168437},
	{"WRLD", 4, 218589},
	{"WRL", 3, 137585},
	{"WRK", 3, 271},
	{"WRIV", 4, 95207},
	{"WRITTLE", 7, 225697},
	{"WRITTING", 8, 113257},
	{"WRITTEN", 7, 29697},
	{"WRITS", 5, 104906},
	{"WRITINGS", 8, 34919},
	{"WRITING", 7, 4593},
	{"WRITIN", 6, 178238},
	{"WRITHING", 8, 116273},
	{"WRITHED", 7, 170207},
	{"WRITHE", 6, 182861},
	{"WRITEWORDS", 10, 180726},
	{"WRITEUPS", 8, 83897},
	{"WRITEUP", 7, 97146},
	{"WRITESHIELD", 11, 63545},
	{"WRITES", 6, 7972},
	{"WRITERSUA", 9, 212341},
	{"WRITERS", 7, 6045},
	{"WRITERMOM", 9, 243707},
	{"WRITERLY", 8, 255933},
	{"WRITER", 6, 2983},
	{"WRITEN", 6, 140708},
	{"WRITELY", 7, 227912},
	{"WRITELOG", 8, 121061},
	{"WRITELN", 7, 118555},
	{"WRITELINE", 9, 153582},
	{"WRITEFILE", 9, 178735},
	{"WRITEBACKS", 10, 233555},
	{"WRITEBACK", 9, 170769},
	{"WRITEABLE", 9, 121998},
	{"WRITE", 5, 1140},
	{"WRITABLE", 8, 75126},
	{"WRIT", 4, 49348},
	{"WRISTWATCHES", 12, 94948},
	{"WRISTWATCH", 10, 83401},
	{"WRISTS", 6, 67099},
	{"WRISTOP", 7, 256434},
	{"WRISTLET", 8, 157284},
	{"WRISTBANDS", 10, 65213},
	{"WRISTBAND", 9, 72394},
	{"WRIST", 5, 29857},
	{"WRIS", 4, 51416},
	{"WRINKLY", 7, 149060},
	{"WRINKLING", 9, 146682},
	{"WRINKLES", 8, 57221},
	{"WRINKLED", 8, 83966},
	{"WRINKLE", 7, 52772},
	{"WRINGING", 8, 114787},
	{"WRINGER", 7, 170077},
	{"WRING", 5, 120107},
	{"WRIN", 4, 71518},
	{"WRIGLEYVILLE", 12, 123028},
	{"WRIGLEY", 7, 76494},
	{"WRIGHTWOOD", 10, 159981},
	{"WRIGHTSVILLE", 12, 113623},
	{"WRIGHTSTOWN", 11, 152421},
	{"WRIGHTSON", 9, 159880},
	{"WRIGHTSOCK", 10, 242798},
	{"WRIGHTS", 7, 116713},
	{"WRIGHT", 6, 8712},
	{"WRIGGLING", 9, 179492},
	{"WRIGGLED", 8, 198681},
	{"WRIGGLE", 7, 163401},
	{"WRIG", 4, 36198},
	{"WRIE", 4, 104960},
	{"WRID", 4, 100627},
	{"WRIB", 4, 209103},
	{"WRIA", 4, 199465},
	{"WRG", 3, 181621},
	{"WRF", 3, 142763},
	{"WREY", 4, 191063},
	{"WREXHAM", 7, 64285},
	{"WREX", 4, 142142},
	{"WREV", 4, 77893},
	{"WRETURN", 7, 206327},
	{"WRETCHES", 8, 183349},
	{"WRETCHEDNESS", 12, 176551},
	{"WRETCHED", 8, 68520},
	{"WRETCH", 6, 41192},
	{"WRET", 4, 71326},
	{"WRESTLING", 9, 9970},
	{"WRESTLES", 8, 143710},
	{"WRESTLERS", 9, 67962},
	{"WRESTLER", 8, 66185},
	{"WRESTLEMANIA", 12, 86304},
	{"WRESTLED", 8, 100440},
	{"WRESTLE", 7, 69876},
	{"WRESTING", 8, 150252},
	{"WRESTER", 7, 114045},
	{"WRESTED", 7, 190438},
	{"WREST", 5, 121033},
	{"WRES", 4, 70022},
	{"WREQ", 4, 76572},
	{"WREP", 4, 61492},
	{"WRENTHAM", 8, 136011},
	{"WRENS", 5, 117656},
	{"WRENN", 5, 149628},
	{"WRENCHING", 9, 86705},
	{"WRENCHES", 8, 72614},
	{"WRENCHED", 8, 157026},
	{"WRENCH", 6, 48035},
	{"WREN", 4, 57765},
	{"WREM", 4, 76763},
	{"WREL", 4, 67844},
	{"WREKIN", 6, 105143},
	{"WREI", 4, 172687},
	{"WREG", 4, 259860},
	{"WREF", 4, 88438},
	{"WREE", 4, 191363},
	{"WREDE", 5, 180846},
	{"WRED", 4, 208185},
	{"WRECSAM", 7, 213664},
	{"WRECKS", 6, 78942},
	{"WRECKLESS", 9, 179695},
	{"WRECKING", 8, 72047},
	{"WRECKERS", 8, 114690},
	{"WRECKER", 7, 105930},
	{"WRECKED", 7, 69931},
	{"WRECKAGE", 8, 77528},
	{"WRECK", 5, 45315},
	{"WREC", 4, 40080},
	{"WREBBIT", 7, 261172},
	{"WREB", 4, 192071},
	{"WREATHS", 7, 71406},
	{"WREATHED", 8, 215348},
	{"WREATH", 6, 55712},
	{"WREAKS", 6, 191581},
	{"WREAKING", 8, 144748},
	{"WREAKED", 7, 151712},
	{"WREAK", 5, 96752},
	{"WRDE", 4, 228968},
	{"WRD", 3, 107988},
	{"WRCO", 4, 239040},
	{"WRC", 3, 65615},
	{"WRBR", 4, 260447},
	{"WRB", 3, 164064},
	{"WRAY", 4, 73189},
	{"WRAV", 4, 243000},
	{"WRATTEN", 7, 191737},
	{"WRATHFUL", 8, 182621},
	{"WRATHER", 7, 228630},
	{"WRATH", 5, 45097},
	{"WRASSE", 6, 147477},
	{"WRAR", 4, 162029},
	{"WRAPUPS", 7, 239158},
	{"WRAPUP", 6, 136414},
	{"WRAPS", 5, 43487},
	{"WRAPPINGS", 9, 168782},
	{"WRAPPING", 8, 32819},
	{"WRAPPERS", 8, 57102},
	{"WRAPPER", 7, 43788},
	{"WRAPPED", 7, 34833},
	{"WRAPAROUND", 10, 95450},
	{"WRAPABLES", 9, 175589},
	{"WRAP", 4, 6423},
	{"WRANGLING", 9, 118088},
	{"WRANGLERS", 9, 121406},
	{"WRANGLER", 8, 52960},
	{"WRANGLE", 7, 149685},
	{"WRANGELL", 8, 112529},
	{"WRAL", 4, 172731},
	{"WRAITHS", 7, 191344},
	{"WRAITH", 6, 87287},
	{"WRAI", 4, 80389},
	{"WRAH", 4, 185999},
	{"WRAGGSTER", 9, 157770},
	{"WRAGGE", 6, 258759},
	{"WRAGG", 5, 197090},
	{"WRAG", 4, 249438},
	{"WRAD", 4, 115042},
	{"WRACKING", 8, 159557},
	{"WRACKED", 7, 149111},
	{"WRACK", 5, 187964},
	{"WRAB", 4, 247549},
	{"WQY", 3, 163228},
	{"WQX", 3, 101139},
	{"WQW", 3, 108035},
	{"WQV", 3, 175472},
	{"WQUI", 4, 72760},
	{"WQUE", 4, 92371},
	{"WQUA", 4, 83022},
	{"WQU", 3, 2633},
	{"WQR", 3, 117820},
	{"WQQ", 3, 182979},
	{"WQP", 3, 153333},
	{"WQL", 3, 132804},
	{"WQK", 3, 147238},
	{"WQF", 3, 166069},
	{"WQD", 3, 147239},
	{"WQB", 3, 66272},
	{"WPZ", 3, 179151},
	{"WPY", 3, 64754},
	{"WPX", 3, 141359},
	{"WPVI", 4, 230136},
	{"WPV", 3, 69039},
	{"WPUZ", 4, 206621},
	{"WPUT", 4, 125105},
	{"WPUS", 4, 190483},
	{"WPUR", 4, 122619},
	{"WPUP", 4, 178853},
	{"WPUN", 4, 158587},
	{"WPUL", 4, 174242},
	{"WPUB", 4, 81241},
	{"WPU", 3, 252020},
	{"WPSY", 4, 251455},
	{"WPRI", 4, 56295},
	{"WPRE", 4, 49527},
	{"WPRA", 4, 90728},
	{"WPR", 3, 202559},
	{"WPQ", 3, 143507},
	{"WPP", 3, 131879},
	{"WPOW", 4, 69286},
	{"WPOU", 4, 167136},
	{"WPOT", 4, 129405},
	{"WPOS", 4, 61546},
	{"WPOR", 4, 57455},
	{"WPOP", 4, 102295},
	{"WPOO", 4, 135392},
	{"WPON", 4, 204655},
	{"WPOL", 4, 59064},
	{"WPOK", 4, 201570},
	{"WPOINTER", 8, 90609},
	{"WPOI", 4, 57389},
	{"WPOE", 4, 187585},
	{"WPM", 3, 270},
	{"WPLY", 4, 210877},
	{"WPLUG", 5, 126249},
	{"WPLU", 4, 154121},
	{"WPLO", 4, 135442},
	{"WPLE", 4, 123395},
	{"WPLA", 4, 44338},
	{"WPL", 3, 121379},
	{"WPJ", 3, 86823},
	{"WPIX", 4, 190876},
	{"WPIT", 4, 92590},
	{"WPIS", 4, 228224},
	{"WPIP", 4, 195691},
	{"WPIN", 4, 138169},
	{"WPIL", 4, 135393},
	{"WPIE", 4, 100570},
	{"WPIC", 4, 115705},
	{"WPIA", 4, 126275},
	{"WPHY", 4, 156748},
	{"WPHO", 4, 101875},
	{"WPHI", 4, 116027},
	{"WPHE", 4, 169623},
	{"WPHA", 4, 134132},
	{"WPG", 3, 143056},
	{"WPFW", 4, 253135},
	{"WPF", 3, 133363},
	{"WPET", 4, 115611},
	{"WPER", 4, 51120},
	{"WPEO", 4, 46615},
	{"WPEN", 4, 112483},
	{"WPEE", 4, 238213},
	{"WPED", 4, 221693},
	{"WPEA", 4, 125488},
	{"WPDB", 4, 143062},
	{"WPD", 3, 139331},
	{"WPCP", 4, 243586},
	{"WPC", 3, 103355},
	{"WPB", 3, 153686},
	{"WPAY", 4, 102942},
	{"WPAW", 4, 202048},
	{"WPAV", 4, 231070},
	{"WPAU", 4, 179552},
	{"WPAT", 4, 73784},
	{"WPAS", 4, 71370},
	{"WPARAM", 6, 110548},
	{"WPAR", 4, 47824},
	{"WPAP", 4, 142143},
	{"WPAL", 4, 114514},
	{"WPAK", 4, 256335},
	{"WPAI", 4, 95708},
	{"WPAG", 4, 109669},
	{"WPAFB", 5, 213865},
	{"WPAD", 4, 217258},
	{"WPAC", 4, 87040},
	{"WOZNIAK", 7, 123579},
	{"WOZN", 4, 253989},
	{"WOYO", 4, 72545},
	{"WOYE", 4, 9172},
	{"WOYAA", 5, 250045},
	{"WOYA", 4, 122008},
	{"WOXTER", 6, 198894},
	{"WOXF", 4, 211996},
	{"WOWY", 4, 187030},
	{"WOWWIKI", 7, 232332},
	{"WOWW", 4, 119541},
	{"WOWTVD", 6, 259429},
	{"WOWS", 4, 127985},
	{"WOWR", 4, 149191},
	{"WOWP", 4, 256336},
	{"WOWO", 4, 55129},
	{"WOWNLOADS", 9, 236604},
	{"WOWNLOAD", 8, 236139},
	{"WOWN", 4, 66053},
	{"WOWM", 4, 219290},
	{"WOWL", 4, 253883},
	{"WOWK", 4, 238829},
	{"WOWING", 6, 210978},
	{"WOWH", 4, 72396},
	{"WOWF", 4, 201910},
	{"WOWED", 5, 140186},
	{"WOWE", 4, 35890},
	{"WOWD", 4, 250814},
	{"WOWCOM", 6, 233780},
	{"WOWC", 4, 230584},
	{"WOWBB", 5, 131214},
	{"WOWA", 4, 52653},
	{"WOW", 3, 30134},
	{"WOVO", 4, 91250},
	{"WOVI", 4, 84958},
	{"WOVERLOADED", 11, 195472},
	{"WOVENS", 6, 186187},
	{"WOVEN", 5, 38350},
	{"WOVE", 4, 118676},
	{"WOVA", 4, 107978},
	{"WOUTERS", 7, 146260},
	{"WOUTER", 6, 109613},
	{"WOUT", 4, 246018},
	{"WOUS", 4, 260565},
	{"WOUR", 4, 66903},
	{"WOUP", 4, 165815},
	{"WOUNDS", 6, 41590},
	{"WOUNDING", 8, 83486},
	{"WOUNDED", 7, 37303},
	{"WOUND", 5, 28561},
	{"WOUN", 4, 31571},
	{"WOULDVE", 7, 257562},
	{"WOULDST", 7, 120148},
	{"WOULDNT", 7, 58093},
	{"WOULDN'T", 8, 689},
	{"WOULDN", 6, 106414},
	{"WOULDEST", 8, 254850},
	{"WOULDA", 6, 119582},
	{"WOULD", 5, 747},
	{"WOUL", 4, 184512},
	{"WOUK", 4, 256171},
	{"WOUDL", 5, 203240},
	{"WOUD", 4, 209451},
	{"WOTY", 4, 168318},
	{"WOTW", 4, 211691},
	{"WOTU", 4, 120155},
	{"WOTTON", 6, 144376},
	{"WOTSAP", 6, 207687},
	{"WOTD", 4, 135676},
	{"WOTC", 4, 147977},
	{"WOTAN", 5, 214728},
	{"WOSY", 4, 129306},
	{"WOSW", 4, 138433},
	{"WOSQ", 4, 154237},
	{"WOSP", 4, 66449},
	{"WOSL", 4, 131477},
	{"WOSK", 4, 184354},
	{"WOSC", 4, 65448},
	{"WORZEL", 6, 261075},
	{"WORY", 4, 246932},
	{"WORX", 4, 84713},
	{"WORW", 4, 124486},
	{"WORU", 4, 42898},
	{"WORTON", 6, 249529},
	{"WORTMAN", 7, 185438},
	{"WORTLEY", 7, 165685},
	{"WORTHY", 6, 629},
	{"WORTHWHILE", 10, 42600},
	{"WORTHPLAYING", 12, 200137},
	{"WORTHLESSNESS", 13, 183179},
	{"WORTHLESS", 9, 53384},
	{"WORTHINGTON", 11, 56090},
	{"WORTHING", 8, 72414},
	{"WORTHINESS", 10, 102265},
	{"WORTHILY", 8, 184118},
	{"WORTHIES", 8, 211671},
	{"WORTHEN", 7, 182575},
	{"WORTHAM", 7, 151392},
	{"WORTH", 5, 4168},
	{"WORTE", 5, 215567},
	{"WORT", 4, 64853},
	{"WORSTED", 7, 106102},
	{"WORSTALL", 8, 146415},
	{"WORST", 5, 6893},
	{"WORSLEY", 7, 101883},
	{"WORSHIPS", 8, 118492},
	{"WORSHIPPING", 11, 79456},
	{"WORSHIPPERS", 11, 88422},
	{"WORSHIPPER", 10, 134824},
	{"WORSHIPPED", 10, 73164},
	{"WORSHIPING", 10, 125901},
	{"WORSHIPFUL", 10, 136658},
	{"WORSHIPERS", 10, 130415},
	{"WORSHIPER", 9, 215763},
	{"WORSHIPED", 9, 119265},
	{"WORSHIP", 7, 8384},
	{"WORSHAM", 7, 187438},
	{"WORSENS", 7, 108127},
	{"WORSENING", 9, 71777},
	{"WORSENED", 8, 85066},
	{"WORSEN", 6, 74728},
	{"WORSE", 5, 7363},
	{"WORRYINGLY", 10, 194872},
	{"WORRYING", 8, 47787},
	{"WORRY", 5, 628},
	{"WORRISOME", 9, 99135},
	{"WORRIES", 7, 42777},
	{"WORRIER", 7, 248109},
	{"WORRIED", 7, 28741},
	{"WORRELL", 7, 123551},
	{"WORRALL", 7, 120413},
	{"WORP", 4, 139547},
	{"WORO", 4, 59386},
	{"WORN", 4, 32065},
	{"WORMY", 5, 223429},
	{"WORMWOOD", 8, 111096},
	{"WORMS", 5, 38911},
	{"WORMLEY", 7, 235312},
	{"WORMING", 7, 159380},
	{"WORMHOLES", 9, 180106},
	{"WORMHOLE", 8, 111738},
	{"WORMERS", 7, 175574},
	{"WORMER", 6, 141708},
	{"WORMED", 6, 158405},
	{"WORMBASE", 8, 156196},
	{"WORMALD", 7, 247845},
	{"WORM", 4, 34987},
	{"WORLWIDE", 8, 180045},
	{"WORLEY", 6, 83544},
	{"WORLDWORKS", 10, 140067},
	{"WORLDWIND", 9, 190448},
	{"WORLDWIDESHOW", 13, 135460},
	{"WORLDWIDE", 9, 33948},
	{"WORLDWEB", 8, 245846},
	{"WORLDWATCH", 10, 147994},
	{"WORLDVILLAGE", 12, 200411},
	{"WORLDVIEWS", 10, 123894},
	{"WORLDVIEW", 9, 64556},
	{"WORLDSTREAM", 11, 259600},
	{"WORLDSTOCK", 10, 98981},
	{"WORLDSPAN", 9, 187944},
	{"WORLDSPACE", 10, 193517},
	{"WORLDSCOPE", 10, 142820},
	{"WORLDS", 6, 28199},
	{"WORLDRES", 8, 118787},
	{"WORLDPERKS", 10, 219610},
	{"WORLDPAY", 8, 89363},
	{"WORLDOFHOTELS", 13, 217386},
	{"WORLDNOW", 8, 75724},
	{"WORLDNEWS", 9, 206980},
	{"WORLDNETDAILY", 13, 109596},
	{"WORLDNET", 8, 117705},
	{"WORLDMUSIC", 10, 196714},
	{"WORLDMATE", 9, 206163},
	{"WORLDMARK", 9, 183809},
	{"WORLDMAP", 8, 205100},
	{"WORLDLY", 7, 59529},
	{"WORLDLINGO", 10, 237481},
	{"WORLDLINESS", 11, 203737},
	{"WORLDLII", 8, 159171},
	{"WORLDISROUND", 12, 157718},
	{"WORLDHOTELS", 11, 186497},
	{"WORLDGUIDE", 10, 251063},
	{"WORLDFORGE", 10, 195313},
	{"WORLDE", 6, 158783},
	{"WORLDCUP", 8, 137515},
	{"WORLDCONNECT", 12, 108507},
	{"WORLDCON", 8, 171923},
	{"WORLDCOM", 8, 67274},
	{"WORLDCLASS", 10, 222275},
	{"WORLDCHANGING", 13, 135981},
	{"WORLDCAT", 8, 33549},
	{"WORLDCALL", 9, 221215},
	{"WORLDBUILDER", 12, 215338},
	{"WORLDBEAT", 9, 259607},
	{"WORLD", 5, 907},
	{"WORLAND", 7, 133319},
	{"WORL", 4, 120701},
	{"WORKWEEK", 8, 106567},
	{"WORKWEAR", 8, 80762},
	{"WORKUP", 6, 128454},
	{"WORKTOPS", 8, 136903},
	{"WORKTOP", 7, 152125},
	{"WORKTHING", 9, 250920},
	{"WORKTABLE", 9, 230390},
	{"WORKSURFACE", 11, 224582},
	{"WORKSTREAM", 10, 255948},
	{"WORKSTATIONS", 12, 40282},
	{"WORKSTATIONPLANET", 17, 236548},
	{"WORKSTATION", 11, 35134},
	{"WORKSTANDS", 10, 240063},
	{"WORKSPACES", 10, 89447},
	{"WORKSPACE", 9, 43976},
	{"WORKSOURCE", 10, 187118},
	{"WORKSOP", 7, 112599},
	{"WORKSMART", 9, 244309},
	{"WORKSITES", 9, 160237},
	{"WORKSITE", 8, 82488},
	{"WORKSHY", 7, 194853},
	{"WORKSHOPS", 9, 6973},
	{"WORKSHOP", 8, 28077},
	{"WORKSHEETS", 10, 51429},
	{"WORKSHEET", 9, 42456},
	{"WORKSDOTMP", 10, 213887},
	{"WORKSAFE", 8, 140004},
	{"WORKS", 5, 4968},
	{"WORKROOM", 8, 144369},
	{"WORKRITE", 8, 219468},
	{"WORKREST", 8, 151985},
	{"WORKPLANS", 9, 230358},
	{"WORKPLAN", 8, 102063},
	{"WORKPLACES", 10, 58713},
	{"WORKPLACE", 9, 33057},
	{"WORKPIECES", 10, 215809},
	{"WORKPIECE", 9, 111831},
	{"WORKPAPERS", 10, 229682},
	{"WORKPAD", 7, 158646},
	{"WORKPACKAGE", 11, 172808},
	{"WORKOVER", 8, 214386},
	{"WORKOUTS", 8, 53920},
	{"WORKOUT", 7, 32621},
	{"WORKOPOLIS", 10, 123240},
	{"WORKMEN", 7, 79314},
	{"WORKMATES", 9, 184195},
	{"WORKMATE", 8, 257756},
	{"WORKMANSHIP", 11, 57204},
	{"WORKMANS", 8, 252910},
	{"WORKMANLIKE", 11, 193541},
	{"WORKMAN", 7, 64785},
	{"WORKLOG", 7, 249332},
	{"WORKLOADS", 9, 78358},
	{"WORKLOAD", 8, 43287},
	{"WORKLIST", 8, 160843},
	{"WORKLIFE", 8, 135827},
	{"WORKKEYS", 8, 223452},
	{"WORKINGTON", 10, 113628},
	{"WORKINGS", 8, 56310},
	{"WORKINGMEN", 10, 247479},
	{"WORKINGMAN", 10, 230516},
	{"WORKINGFORCHANGE", 16, 247096},
	{"WORKING", 7, 9201},
	{"WORKIN", 6, 82257},
	{"WORKHOUSE", 9, 113968},
	{"WORKHORSES", 10, 254721},
	{"WORKHORSE", 9, 92887},
	{"WORKHOLDING", 11, 197681},
	{"WORKHAVEN", 9, 159051},
	{"WORKGROUPS", 10, 79375},
	{"WORKGROUP", 9, 49013},
	{"WORKFORCES", 10, 144394},
	{"WORKFORCE", 9, 9805},
	{"WORKFLOWS", 9, 80284},
	{"WORKFLOWGEN", 11, 238630},
	{"WORKFLOW", 8, 36207},
	{"WORKFIRST", 9, 243232},
	{"WORKFARE", 8, 176952},
	{"WORKETH", 7, 177849},
	{"WORKERS", 7, 2718},
	{"WORKER", 6, 1855},
	{"WORKED", 6, 3333},
	{"WORKE", 5, 217914},
	{"WORKDIR", 7, 244090},
	{"WORKDAYS", 8, 110183},
	{"WORKDAY", 7, 79678},
	{"WORKCOVER", 9, 112835},
	{"WORKCENTRE", 10, 95861},
	{"WORKCENTERS", 11, 261430},
	{"WORKCENTER", 10, 148528},
	{"WORKBOOKS", 9, 78685},
	{"WORKBOOK", 8, 44436},
	{"WORKBOARD", 9, 251896},
	{"WORKBENCHES", 11, 136843},
	{"WORKBENCH", 9, 60965},
	{"WORKAROUNDS", 11, 85892},
	{"WORKAROUND", 10, 49824},
	{"WORKAMPING", 10, 147779},
	{"WORKAHOLIC", 10, 139353},
	{"WORKADAY", 8, 232550},
	{"WORKABLE", 8, 63591},
	{"WORKABILITY", 11, 157476},
	{"WORK", 4, 897},
	{"WORI", 4, 72800},
	{"WORH", 4, 155979},
	{"WORG", 4, 91920},
	{"WORF", 4, 120331},
	{"WORE", 4, 40591},
	{"WORDY", 5, 122245},
	{"WORDWRAP", 8, 216128},
	{"WORDWIDE", 8, 236300},
	{"WORDWEB", 7, 110192},
	{"WORDWARE", 8, 257099},
	{"WORDTRANS", 9, 226064},
	{"WORDTRACKER", 11, 159292},
	{"WORDTHEQUE", 10, 228169},
	{"WORDT", 5, 97334},
	{"WORDSWORTH", 10, 61950},
	{"WORDSTAR", 8, 223495},
	{"WORDSMITHS", 10, 246801},
	{"WORDSMITH", 9, 128256},
	{"WORDSEARCH", 10, 118453},
	{"WORDS", 5, 1631},
	{"WORDREFERENCE", 13, 157130},
	{"WORDPROCESSING", 14, 225652},
	{"WORDPRESS", 9, 29734},
	{"WORDPLAY", 8, 112148},
	{"WORDPERFECT", 11, 55951},
	{"WORDPAD", 7, 131842},
	{"WORDNET", 7, 64406},
	{"WORDMARK", 8, 109529},
	{"WORDMAP", 7, 186165},
	{"WORDLY", 6, 217014},
	{"WORDLISTS", 9, 249284},
	{"WORDLIST", 8, 140035},
	{"WORDLET", 7, 62465},
	{"WORDLESS", 8, 139918},
	{"WORDINGS", 8, 167281},
	{"WORDING", 7, 44892},
	{"WORDINDEX", 9, 203561},
	{"WORDFINDER", 10, 203513},
	{"WORDFAST", 8, 100945},
	{"WORDES", 6, 179529},
	{"WORDEN", 6, 69377},
	{"WORDED", 6, 79572},
	{"WORDE", 5, 192880},
	{"WORDCOUNT", 9, 190763},
	{"WORDART", 7, 238384},
	{"WORD", 4, 627},
	{"WORCS", 5, 114740},
	{"WORCHESTER", 10, 181804},
	{"WORCESTERSHIRE", 14, 48596},
	{"WORCESTER", 9, 35514},
	{"WORC", 4, 260318},
	{"WORB", 4, 70538},
	{"WORA", 4, 64391},
	{"WOQU", 4, 79391},
	{"WOQ", 3, 6552},
	{"WOPU", 4, 87902},
	{"WOPT", 4, 114718},
	{"WOPS", 4, 233845},
	{"WOPR", 4, 50407},
	{"WOPP", 4, 96552},
	{"WOPO", 4, 46184},
	{"WOPL", 4, 55306},
	{"WOPI", 4, 70255},
	{"WOPH", 4, 105104},
	{"WOPE", 4, 44422},
	{"WOPA", 4, 47025},
	{"WOOZY", 5, 183467},
	{"WOOZ", 4, 255644},
	{"WOOW", 4, 213401},
	{"WOOV", 4, 131695},
	{"WOOU", 4, 54110},
	{"WOOTTON", 7, 102612},
	{"WOOTTEN", 7, 251036},
	{"WOOTON", 6, 189003},
	{"WOOTEN", 6, 91154},
	{"WOOSTER", 7, 67152},
	{"WOOSNAM", 7, 251647},
	{"WOOSLEY", 7, 223285},
	{"WOOSH", 5, 234188},
	{"WOORDENBOEK", 11, 245353},
	{"WOORD", 5, 233726},
	{"WOOR", 4, 46792},
	{"WOOPS", 5, 172101},
	{"WOOP", 4, 176486},
	{"WOOOO", 5, 193966},
	{"WOONSOCKET", 10, 106612},
	{"WOONKAMER", 9, 197365},
	{"WOOMERA", 7, 168313},
	{"WOOLY", 5, 105633},
	{"WOOLWORTHS", 10, 97165},
	{"WOOLWORTH", 9, 146421},
	{"WOOLWICH", 8, 89853},
	{"WOOLSTON", 8, 195827},
	{"WOOLSHED", 8, 234816},
	{"WOOLSEY", 7, 98241},
	{"WOOLS", 5, 163285},
	{"WOOLRIDGE", 9, 248009},
	{"WOOLRICH", 8, 94806},
	{"WOOLOVERS", 9, 153568},
	{"WOOLMER", 7, 209152},
	{"WOOLMAN", 7, 238279},
	{"WOOLLY", 6, 86107},
	{"WOOLLOONGABBA", 13, 254002},
	{"WOOLLOOMOOLOO", 13, 240579},
	{"WOOLLEY", 7, 79496},
	{"WOOLLEN", 7, 97556},
	{"WOOLLARD", 8, 210440},
	{"WOOLLAHRA", 9, 210264},
	{"WOOLIES", 7, 188063},
	{"WOOLFORD", 8, 197938},
	{"WOOLFOLK", 8, 222908},
	{"WOOLF", 5, 68069},
	{"WOOLEY", 6, 131326},
	{"WOOLER", 6, 208588},
	{"WOOLEN", 6, 95027},
	{"WOOLDRIDGE", 10, 111463},
	{"WOOLCOCK", 8, 247967},
	{"WOOLARD", 7, 191317},
	{"WOOLACOMBE", 10, 186189},
	{"WOOL", 4, 31451},
	{"WOOKIEE", 7, 200138},
	{"WOOKIE", 6, 143646},
	{"WOOKEY", 6, 220445},
	{"WOOK", 4, 132307},
	{"WOOING", 6, 115534},
	{"WOOHOO", 6, 82378},
	{"WOOGIE", 6, 112166},
	{"WOOFERS", 7, 106074},
	{"WOOFER", 6, 71035},
	{"WOOF", 4, 69843},
	{"WOOED", 5, 142162},
	{"WOODYARD", 8, 245047},
	{"WOODY", 5, 38090},
	{"WOODWORTH", 9, 111973},
	{"WOODWORM", 8, 213294},
	{"WOODWORKS", 9, 141464},
	{"WOODWORKING", 11, 44992},
	{"WOODWORKERS", 11, 101963},
	{"WOODWORKER", 10, 111501},
	{"WOODWORK", 8, 65118},
	{"WOODWINDS", 9, 94655},
	{"WOODWIND", 8, 65256},
	{"WOODWEB", 7, 132950},
	{"WOODWAY", 7, 144446},
	{"WOODWARE", 8, 261053},
	{"WOODWARD", 8, 44472},
	{"WOODVILLE", 9, 83309},
	{"WOODVIEW", 8, 214364},
	{"WOODVALE", 8, 256480},
	{"WOODTURNING", 11, 109964},
	{"WOODSY", 6, 155963},
	{"WOODSTOWN", 9, 206145},
	{"WOODSTOVE", 9, 174218},
	{"WOODSTOCK", 9, 44748},
	{"WOODSON", 7, 80866},
	{"WOODSMAN", 8, 127319},
	{"WOODSLANE", 9, 221398},
	{"WOODSIDE", 8, 65273},
	{"WOODSHOP", 8, 205159},
	{"WOODSHED", 8, 166735},
	{"WOODSBORO", 9, 213465},
	{"WOODS", 5, 7796},
	{"WOODRUFF", 8, 57960},
	{"WOODROW", 7, 64269},
	{"WOODROFFE", 9, 204230},
	{"WOODRING", 8, 162203},
	{"WOODRIDGE", 9, 99643},
	{"WOODPILE", 8, 242805},
	{"WOODPECKERS", 11, 112901},
	{"WOODPECKER", 10, 64453},
	{"WOODMOOR", 8, 250447},
	{"WOODMONT", 8, 183440},
	{"WOODMERE", 8, 152385},
	{"WOODMEN", 7, 189087},
	{"WOODMAN", 7, 81781},
	{"WOODLOTS", 8, 203600},
	{"WOODLOT", 7, 158120},
	{"WOODLORE", 8, 260921},
	{"WOODLING", 8, 250218},
	{"WOODLINE", 8, 146029},
	{"WOODLEY", 7, 102835},
	{"WOODLEIGH", 9, 254418},
	{"WOODLAWN", 8, 79986},
	{"WOODLANDS", 9, 48298},
	{"WOODLAND", 8, 37379},
	{"WOODLAKE", 8, 139749},
	{"WOODINVILLE", 11, 92978},
	{"WOODING", 7, 208892},
	{"WOODIN", 6, 240658},
	{"WOODIES", 7, 145240},
	{"WOODIE", 6, 140464},
	{"WOODHULL", 8, 161396},
	{"WOODHOUSE", 9, 80961},
	{"WOODHILL", 8, 215844},
	{"WOODHEAD", 8, 128832},
	{"WOODHAVEN", 9, 121086},
	{"WOODHAM", 7, 152048},
	{"WOODHALL", 8, 180978},
	{"WOODGRAIN", 9, 141621},
	{"WOODGATE", 8, 136314},
	{"WOODFORD", 8, 69655},
	{"WOODFLOOR", 9, 228580},
	{"WOODFIN", 7, 129266},
	{"WOODFIELD", 9, 120046},
	{"WOODENWARE", 10, 179605},
	{"WOODEND", 7, 182329},
	{"WOODEN", 6, 7817},
	{"WOODED", 6, 58844},
	{"WOODCUTTER", 10, 234956},
	{"WOODCUTS", 8, 139615},
	{"WOODCUT", 7, 110168},
	{"WOODCREST", 9, 180374},
	{"WOODCREEK", 9, 233594},
	{"WOODCRAFTS", 10, 212077},
	{"WOODCRAFT", 9, 102851},
	{"WOODCOCK", 8, 85176},
	{"WOODCLIFF", 9, 168453},
	{"WOODCHUCKS", 10, 243390},
	{"WOODCHUCK", 9, 136220},
	{"WOODCHIPS", 9, 245291},
	{"WOODCHIP", 8, 241419},
	{"WOODCARVINGS", 12, 252373},
	{"WOODCARVING", 11, 133214},
	{"WOODCARVER", 10, 257534},
	{"WOODBURY", 8, 59263},
	{"WOODBURNING", 11, 131875},
	{"WOODBURN", 8, 88498},
	{"WOODBRIDGE", 10, 55904},
	{"WOODBOURNE", 10, 251926},
	{"WOODBLOCK", 9, 121534},
	{"WOODBINE", 8, 82111},
	{"WOODBERRY", 9, 192879},
	{"WOODARD", 7, 83373},
	{"WOODALL", 7, 109887},
	{"WOODACRE", 8, 239022},
	{"WOOD", 4, 3655},
	{"WOOC", 4, 104961},
	{"WOOB", 4, 144080},
	{"WONY", 4, 156169},
	{"WONWINGLO", 9, 82690},
	{"WONW", 4, 67643},
	{"WONV", 4, 145144},
	{"WONU", 4, 161793},
	{"WONTON", 6, 178043},
	{"WONTFIX", 7, 253959},
	{"WONTED", 6, 237446},
	{"WONR", 4, 72365},
	{"WONP", 4, 79174},
	{"WONM", 4, 63286},
	{"WONL", 4, 59242},
	{"WONKY", 5, 142968},
	{"WONKS", 5, 142816},
	{"WONKO", 5, 245991},
	{"WONKETTE", 8, 74501},
	{"WONKA", 5, 71728},
	{"WONK", 4, 126800},
	{"WONJ", 4, 107338},
	{"WONINGBOUW", 10, 223192},
	{"WONGA", 5, 218834},
	{"WONG", 4, 38420},
	{"WONF", 4, 53819},
	{"WONEN", 5, 210520},
	{"WONDROUSLY", 10, 251241},
	{"WONDROUS", 8, 68773},
	{"WONDIR", 6, 181394},
	{"WONDERWOMAN", 11, 230346},
	{"WONDERWARE", 10, 204311},
	{"WONDERWALL", 10, 91494},
	{"WONDERSWAN", 10, 95410},
	{"WONDERS", 7, 37673},
	{"WONDEROUS", 9, 162605},
	{"WONDERMENT", 10, 147780},
	{"WONDERLAND", 10, 47109},
	{"WONDERING", 9, 29518},
	{"WONDERIN", 8, 166171},
	{"WONDERFULLY", 11, 49007},
	{"WONDERFULL", 10, 108493},
	{"WONDERFULBUYS", 13, 182513},
	{"WONDERFUL", 9, 626},
	{"WONDERFOOLS", 11, 261921},
	{"WONDERFALLS", 11, 190288},
	{"WONDERED", 8, 38824},
	{"WONDERBRA", 9, 114935},
	{"WONDERBOY", 9, 198394},
	{"WONDER", 6, 2408},
	{"WONDEFUL", 8, 237430},
	{"WONC", 4, 68476},
	{"WONB", 4, 47081},
	{"WONA", 4, 33553},
	{"WON'T", 5, 688},
	{"WON", 3, 4158},
	{"WOMYN", 5, 147704},
	{"WOMWN", 5, 229927},
	{"WOMU", 4, 109297},
	{"WOMS", 4, 249985},
	{"WOMO", 4, 36726},
	{"WOMMEN", 6, 254686},
	{"WOMMA", 5, 221651},
	{"WOMM", 4, 221931},
	{"WOMI", 4, 45853},
	{"WOMENSWEAR", 10, 121385},
	{"WOMENSUITS", 10, 186587},
	{"WOMENS", 6, 6279},
	{"WOMENLIT", 8, 246251},
	{"WOMENFOLK", 9, 242597},
	{"WOMEN", 5, 993},
	{"WOMEM", 5, 253480},
	{"WOME", 4, 175863},
	{"WOMBS", 5, 216403},
	{"WOMBLES", 7, 257107},
	{"WOMBLE", 6, 126973},
	{"WOMBATS", 7, 175140},
	{"WOMBAT", 6, 83716},
	{"WOMB", 4, 58316},
	{"WOMANS", 6, 67563},
	{"WOMANLY", 7, 134767},
	{"WOMANKIND", 9, 234352},
	{"WOMANIZING", 10, 228679},
	{"WOMANIZER", 9, 209548},
	{"WOMANHOOD", 9, 101912},
	{"WOMAN", 5, 878},
	{"WOMAD", 5, 180509},
	{"WOMACK", 6, 73288},
	{"WOLY", 4, 193626},
	{"WOLVIX", 6, 224611},
	{"WOLVES", 6, 41424},
	{"WOLVERTON", 9, 118984},
	{"WOLVERINES", 10, 67238},
	{"WOLVERINE", 9, 52845},
	{"WOLVERHAMPTON", 13, 50745},
	{"WOLV", 4, 43334},
	{"WOLUWE", 6, 239159},
	{"WOLU", 4, 208293},
	{"WOLTLAB", 7, 255422},
	{"WOLTERS", 7, 119510},
	{"WOLTER", 6, 149630},
	{"WOLT", 4, 199848},
	{"WOLSTENHOLME", 12, 208080},
	{"WOLSTENCROFT", 12, 227423},
	{"WOLSKI", 6, 215111},
	{"WOLSEY", 6, 142318},
	{"WOLSELEY", 8, 108932},
	{"WOLS", 4, 119520},
	{"WOLRD", 5, 226814},
	{"WOLPERT", 7, 164059},
	{"WOLPE", 5, 221661},
	{"WOLP", 4, 218167},
	{"WOLOF", 5, 142222},
	{"WOLMAN", 6, 176332},
	{"WOLM", 4, 207921},
	{"WOLLTEN", 7, 235832},
	{"WOLLTE", 6, 148722},
	{"WOLLSTONECRAFT", 14, 137405},
	{"WOLLONGONG", 10, 65349},
	{"WOLLMAN", 7, 199568},
	{"WOLLEY", 6, 255113},
	{"WOLLEN", 6, 100725},
	{"WOLLE", 5, 160014},
	{"WOLLATON", 8, 255519},
	{"WOLLASTON", 9, 163665},
	{"WOLL", 4, 191672},
	{"WOLKY", 5, 181202},
	{"WOLK", 4, 162575},
	{"WOLINSKY", 8, 248701},
	{"WOLIN", 5, 165620},
	{"WOLI", 4, 68039},
	{"WOLFY", 5, 220261},
	{"WOLFVILLE", 9, 162072},
	{"WOLFSON", 7, 86314},
	{"WOLFSHEIM", 9, 141022},
	{"WOLFSBURG", 9, 133556},
	{"WOLFS", 5, 168956},
	{"WOLFRUM", 7, 241128},
	{"WOLFRAM", 7, 56730},
	{"WOLFPACK", 8, 73185},
	{"WOLFOWITZ", 9, 76103},
	{"WOLFORD", 7, 106009},
	{"WOLFMOTHER", 10, 191257},
	{"WOLFMAN", 7, 114498},
	{"WOLFIE", 6, 132193},
	{"WOLFHOUND", 9, 129617},
	{"WOLFGANG", 8, 42148},
	{"WOLFFORTH", 9, 259892},
	{"WOLFF", 5, 56660},
	{"WOLFERT", 7, 220768},
	{"WOLFER", 6, 234652},
	{"WOLFENSTEIN", 11, 65105},
	{"WOLFENSOHN", 10, 156861},
	{"WOLFEN", 6, 190127},
	{"WOLFEBORO", 9, 132873},
	{"WOLFE", 5, 44933},
	{"WOLFCRAFT", 9, 239546},
	{"WOLFCAMERA", 10, 182859},
	{"WOLF", 4, 32044},
	{"WOLE", 4, 209563},
	{"WOLDS", 5, 174058},
	{"WOLDE", 5, 206731},
	{"WOLD", 4, 88329},
	{"WOLCOTT", 7, 67594},
	{"WOLC", 4, 186502},
	{"WOLBACHIA", 9, 199874},
	{"WOLA", 4, 234968},
	{"WOKS", 4, 131436},
	{"WOKO", 4, 181699},
	{"WOKN", 4, 148790},
	{"WOKINGHAM", 9, 75231},
	{"WOKING", 6, 72037},
	{"WOKI", 4, 71519},
	{"WOKEN", 5, 91296},
	{"WOKE", 4, 44264},
	{"WOKA", 4, 156552},
	{"WOJU", 4, 119117},
	{"WOJTYLA", 7, 193980},
	{"WOJTEK", 6, 184753},
	{"WOJT", 4, 204656},
	{"WOJO", 4, 116696},
	{"WOJI", 4, 130740},
	{"WOJE", 4, 177479},
	{"WOJCIK", 6, 181993},
	{"WOJCIECHOWSKI", 13, 114013},
	{"WOJCIECH", 8, 124802},
	{"WOJC", 4, 186625},
	{"WOJA", 4, 148046},
	{"WOIR", 4, 202939},
	{"WOIM", 4, 105825},
	{"WOIL", 4, 135730},
	{"WOIF", 4, 225319},
	{"WOID", 4, 155422},
	{"WOHY", 4, 239587},
	{"WOHU", 4, 80357},
	{"WOHNUNGEN", 9, 171818},
	{"WOHNUNG", 7, 155346},
	{"WOHNORT", 7, 238593},
	{"WOHNHEIM", 8, 217403},
	{"WOHNEN", 6, 205376},
	{"WOHLERS", 7, 224698},
	{"WOHLER", 6, 253438},
	{"WOHL", 4, 110376},
	{"WOHIN", 5, 187442},
	{"WOGU", 4, 80222},
	{"WOGS", 4, 243557},
	{"WOGR", 4, 57266},
	{"WOGO", 4, 53122},
	{"WOGL", 4, 179874},
	{"WOGI", 4, 92841},
	{"WOGG", 4, 220175},
	{"WOGE", 4, 88182},
	{"WOGAN", 5, 194480},
	{"WOGA", 4, 45024},
	{"WOFY", 4, 160580},
	{"WOFW", 4, 83295},
	{"WOFV", 4, 160964},
	{"WOFU", 4, 69956},
	{"WOFTWARE", 8, 253127},
	{"WOFT", 4, 33911},
	{"WOFS", 4, 67468},
	{"WOFR", 4, 53960},
	{"WOFP", 4, 78739},
	{"WOFO", 4, 49292},
	{"WOFN", 4, 101334},
	{"WOFM", 4, 75989},
	{"WOFL", 4, 74150},
	{"WOFK", 4, 165146},
	{"WOFJ", 4, 142994},
	{"WOFI", 4, 51536},
	{"WOFH", 4, 67195},
	{"WOFG", 4, 108065},
	{"WOFFORD", 7, 94264},
	{"WOFE", 4, 64241},
	{"WOFD", 4, 100490},
	{"WOFC", 4, 71066},
	{"WOFB", 4, 90153},
	{"WOFA", 4, 47352},
	{"WOEY", 4, 223747},
	{"WOEXP", 5, 229626},
	{"WOEX", 4, 73939},
	{"WOEV", 4, 95346},
	{"WOEU", 4, 220800},
	{"WOERNER", 7, 210560},
	{"WOER", 4, 142883},
	{"WOEQ", 4, 207544},
	{"WOEP", 4, 107037},
	{"WOENSDAG", 8, 140983},
	{"WOEM", 4, 122261},
	{"WOEL", 4, 93545},
	{"WOEG", 4, 244203},
	{"WOEFULLY", 8, 102313},
	{"WOEFUL", 6, 130142},
	{"WOEF", 4, 103598},
	{"WOED", 4, 163837},
	{"WOEC", 4, 241586},
	{"WODY", 4, 198280},
	{"WODU", 4, 144355},
	{"WODR", 4, 90652},
	{"WODONGA", 7, 109787},
	{"WODO", 4, 56357},
	{"WODNA", 5, 210816},
	{"WODI", 4, 46049},
	{"WODEN", 5, 120766},
	{"WODEHOUSE", 9, 103466},
	{"WODE", 4, 46059},
	{"WODD", 4, 250815},
	{"WODA", 4, 191218},
	{"WOCY", 4, 171189},
	{"WOCU", 4, 111366},
	{"WOCT", 4, 215654},
	{"WOCR", 4, 90356},
	{"WOCO", 4, 38615},
	{"WOCL", 4, 74925},
	{"WOCK", 4, 195837},
	{"WOCI", 4, 95941},
	{"WOCHENSCHR", 10, 137103},
	{"WOCHENENDE", 10, 140188},
	{"WOCHENEND", 9, 154613},
	{"WOCHEN", 6, 152408},
	{"WOCHE", 5, 132043},
	{"WOCH", 4, 46534},
	{"WOCE", 4, 185702},
	{"WOCD", 4, 213611},
	{"WOCC", 4, 98304},
	{"WOCA", 4, 50245},
	{"WOBY", 4, 122532},
	{"WOBV", 4, 199351},
	{"WOBURN", 6, 70159},
	{"WOBU", 4, 68540},
	{"WOBS", 4, 131311},
	{"WOBR", 4, 60712},
	{"WOBO", 4, 60386},
	{"WOBL", 4, 78223},
	{"WOBJ", 4, 164810},
	{"WOBI", 4, 67570},
	{"WOBENZYM", 8, 221411},
	{"WOBEI", 5, 257223},
	{"WOBEGON", 7, 223471},
	{"WOBE", 4, 59907},
	{"WOBBLY", 6, 95148},
	{"WOBBLING", 8, 148574},
	{"WOBBLES", 7, 187910},
	{"WOBBLERS", 8, 228309},
	{"WOBBLER", 7, 147814},
	{"WOBBLED", 7, 211222},
	{"WOBBLE", 6, 85538},
	{"WOBB", 4, 96257},
	{"WOBA", 4, 53038},
	{"WOAX", 4, 259277},
	{"WOAW", 4, 151466},
	{"WOAU", 4, 136158},
	{"WOAR", 4, 56998},
	{"WOAP", 4, 101376},
	{"WOAM", 4, 114366},
	{"WOAL", 4, 74355},
	{"WOAK", 4, 203439},
	{"WOAG", 4, 115505},
	{"WOAF", 4, 129406},
	{"WOAD", 4, 214787},
	{"WOAC", 4, 85384},
	{"WOAB", 4, 128509},
	{"WNZO", 4, 225546},
	{"WNYW", 4, 208975},
	{"WNYO", 4, 78064},
	{"WNYE", 4, 104273},
	{"WNYC", 4, 134604},
	{"WNYA", 4, 109580},
	{"WNWV", 4, 225320},
	{"WNWR", 4, 127643},
	{"WNWO", 4, 53379},
	{"WNWI", 4, 38401},
	{"WNWH", 4, 42257},
	{"WNWE", 4, 58091},
	{"WNWA", 4, 39269},
	{"WNVO", 4, 102728},
	{"WNVI", 4, 76716},
	{"WNVE", 4, 75071},
	{"WNVA", 4, 104638},
	{"WNUT", 4, 188705},
	{"WNUS", 4, 88726},
	{"WNUP", 4, 50740},
	{"WNUN", 4, 53582},
	{"WNUM", 4, 97420},
	{"WNUC", 4, 168279},
	{"WNTY", 4, 193776},
	{"WNTW", 4, 88642},
	{"WNTV", 4, 209489},
	{"WNTU", 4, 50659},
	{"WNTR", 4, 259529},
	{"WNTO", 4, 5402},
	{"WNTH", 4, 5979},
	{"WNSY", 4, 92982},
	{"WNSW", 4, 57021},
	{"WNSV", 4, 87876},
	{"WNSU", 4, 57652},
	{"WNST", 4, 35074},
	{"WNSR", 4, 86858},
	{"WNSQ", 4, 113147},
	{"WNSP", 4, 52301},
	{"WNSM", 4, 72965},
	{"WNSL", 4, 70716},
	{"WNSK", 4, 106782},
	{"WNSJ", 4, 178520},
	{"WNSH", 4, 32336},
	{"WNSG", 4, 113514},
	{"WNSF", 4, 66655},
	{"WNSD", 4, 88677},
	{"WNSC", 4, 57372},
	{"WNSB", 4, 71337},
	{"WNSA", 4, 35185},
	{"WNRU", 4, 65013},
	{"WNRS", 4, 189165},
	{"WNRO", 4, 68267},
	{"WNRI", 4, 52012},
	{"WNRE", 4, 42450},
	{"WNRA", 4, 71633},
	{"WNQU", 4, 95691},
	{"WNQ", 3, 9745},
	{"WNPU", 4, 86326},
	{"WNPS", 4, 225985},
	{"WNPR", 4, 44283},
	{"WNPP", 4, 193527},
	{"WNPO", 4, 50217},
	{"WNPL", 4, 56768},
	{"WNPI", 4, 92698},
	{"WNPH", 4, 103516},
	{"WNPE", 4, 46331},
	{"WNPA", 4, 41862},
	{"WNOW", 4, 84937},
	{"WNOV", 4, 72247},
	{"WNOU", 4, 53839},
	{"WNOR", 4, 48059},
	{"WNOP", 4, 86099},
	{"WNOM", 4, 146873},
	{"WNOL", 4, 133179},
	{"WNOF", 4, 32374},
	{"WNOD", 4, 193777},
	{"WNOC", 4, 154639},
	{"WNOB", 4, 111387},
	{"WNNY", 4, 249439},
	{"WNNU", 4, 122345},
	{"WNMY", 4, 109858},
	{"WNMR", 4, 221694},
	{"WNMO", 4, 49601},
	{"WNMI", 4, 63034},
	{"WNME", 4, 53936},
	{"WNMD", 4, 179977},
	{"WNMC", 4, 184605},
	{"WNMA", 4, 47163},
	{"WNM", 3, 985},
	{"WNLY", 4, 170347},
	{"WNLU", 4, 165054},
	{"WNLO", 4, 37140},
	{"WNLI", 4, 49087},
	{"WNLE", 4, 64260},
	{"WNLA", 4, 54495},
	{"WNKN", 4, 137974},
	{"WNKI", 4, 90266},
	{"WNKE", 4, 129942},
	{"WNKA", 4, 150338},
	{"WNK", 3, 4050},
	{"WNJU", 4, 85785},
	{"WNJO", 4, 98462},
	{"WNJE", 4, 117770},
	{"WNJA", 4, 107778},
	{"WNJ", 3, 3069},
	{"WNIW", 4, 200734},
	{"WNIR", 4, 180665},
	{"WNIP", 4, 247240},
	{"WNIN", 4, 7217},
	{"WNIM", 4, 94602},
	{"WNIL", 4, 176558},
	{"WNIK", 4, 214029},
	{"WNIG", 4, 95709},
	{"WNIF", 4, 78445},
	{"WNID", 4, 104113},
	{"WNIC", 4, 101606},
	{"WNHY", 4, 231314},
	{"WNHU", 4, 120665},
	{"WNH", 3, 882},
	{"WNGU", 4, 112111},
	{"WNGR", 4, 55391},
	{"WNGP", 4, 259646},
	{"WNGO", 4, 68424},
	{"WNGL", 4, 141050},
	{"WNGI", 4, 124851},
	{"WNGE", 4, 94812},
	{"WNGA", 4, 76220},
	{"WNFU", 4, 90357},
	{"WNFR", 4, 129576},
	{"WNFO", 4, 29212},
	{"WNFL", 4, 95125},
	{"WNFI", 4, 55846},
	{"WNFE", 4, 86251},
	{"WNFC", 4, 246618},
	{"WNFA", 4, 49120},
	{"WNEY", 4, 74404},
	{"WNEX", 4, 60608},
	{"WNEW", 4, 242530},
	{"WNEV", 4, 71971},
	{"WNEUD", 5, 116843},
	{"WNEU", 4, 174759},
	{"WNESTED", 7, 153584},
	{"WNER", 4, 5521},
	{"WNEQ", 4, 193937},
	{"WNEP", 4, 235464},
	{"WNEM", 4, 101532},
	{"WNEL", 4, 94967},
	{"WNEG", 4, 140812},
	{"WNEF", 4, 137371},
	{"WNEB", 4, 232650},
	{"WNE", 3, 719},
	{"WNDW", 4, 228464},
	{"WNDU", 4, 169443},
	{"WNDR", 4, 78982},
	{"WNDO", 4, 70682},
	{"WNDI", 4, 62561},
	{"WNDE", 4, 47829},
	{"WNDA", 4, 70971},
	{"WNCY", 4, 227711},
	{"WNCU", 4, 92324},
	{"WNCR", 4, 73616},
	{"WNCO", 4, 37054},
	{"WNCL", 4, 69250},
	{"WNCI", 4, 97565},
	{"WNCH", 4, 52604},
	{"WNCE", 4, 62646},
	{"WNCA", 4, 47803},
	{"WNBY", 4, 39969},
	{"WNBU", 4, 44998},
	{"WNBR", 4, 66072},
	{"WNBO", 4, 58754},
	{"WNBL", 4, 204192},
	{"WNBI", 4, 93930},
	{"WNBE", 4, 44949},
	{"WNBC", 4, 157435},
	{"WNBAWNBA", 8, 197953},
	{"WNBA", 4, 50994},
	{"WNB", 3, 841},
	{"WNAY", 4, 175172},
	{"WNAW", 4, 82619},
	{"WNAV", 4, 119521},
	{"WNAU", 4, 106092},
	{"WNAS", 4, 5447},
	{"WNAR", 4, 49403},
	{"WNAP", 4, 67921},
	{"WNAN", 4, 9162},
	{"WNAM", 4, 56834},
	{"WNAL", 4, 50679},
	{"WNAK", 4, 185610},
	{"WNAJ", 4, 215655},
	{"WNAG", 4, 62892},
	{"WNAF", 4, 61000},
	{"WNAD", 4, 67046},
	{"WNAC", 4, 57662},
	{"WNAB", 4, 53539},
	{"WMYW", 4, 227204},
	{"WMYT", 4, 186762},
	{"WMYS", 4, 109878},
	{"WMYP", 4, 187733},
	{"WMYO", 4, 249773},
	{"WMYN", 4, 249113},
	{"WMYM", 4, 181342},
	{"WMYL", 4, 222854},
	{"WMYH", 4, 210100},
	{"WMYG", 4, 246619},
	{"WMYF", 4, 153187},
	{"WMYD", 4, 204855},
	{"WMYC", 4, 184231},
	{"WMYB", 4, 200554},
	{"WMYA", 4, 216859},
	{"WMY", 3, 3163},
	{"WMX", 3, 247705},
	{"WMW", 3, 230711},
	{"WMV", 3, 43386},
	{"WMUT", 4, 141051},
	{"WMUS", 4, 62668},
	{"WMUN", 4, 167646},
	{"WMUL", 4, 117405},
	{"WMUC", 4, 32765},
	{"WMU", 3, 103879},
	{"WMST", 4, 205001},
	{"WMRS", 4, 204856},
	{"WMR", 3, 178398},
	{"WMP", 3, 79844},
	{"WMOV", 4, 70756},
	{"WMOU", 4, 115126},
	{"WMOT", 4, 85567},
	{"WMOS", 4, 82472},
	{"WMOR", 4, 43189},
	{"WMOO", 4, 100477},
	{"WMON", 4, 41047},
	{"WMOM", 4, 96185},
	{"WMOL", 4, 181822},
	{"WMOD", 4, 70304},
	{"WMOB", 4, 92512},
	{"WMNS", 4, 172619},
	{"WMNF", 4, 256447},
	{"WMM", 3, 185676},
	{"WML", 3, 74319},
	{"WMK", 3, 178117},
	{"WMIX", 4, 174243},
	{"WMIT", 4, 210675},
	{"WMISSING", 8, 69203},
	{"WMIS", 4, 86090},
	{"WMIR", 4, 119542},
	{"WMIN", 4, 50023},
	{"WMIL", 4, 51380},
	{"WMIK", 4, 185355},
	{"WMII", 4, 188594},
	{"WMIG", 4, 117510},
	{"WMID", 4, 114749},
	{"WMIC", 4, 98390},
	{"WMIA", 4, 205189},
	{"WMG", 3, 209547},
	{"WMF", 3, 62377},
	{"WMEX", 4, 52682},
	{"WMEW", 4, 183237},
	{"WMETH", 5, 187621},
	{"WMET", 4, 66527},
	{"WMES", 4, 129479},
	{"WMER", 4, 115017},
	{"WMEO", 4, 171673},
	{"WMEM", 4, 51762},
	{"WMEL", 4, 115643},
	{"WMEI", 4, 174545},
	{"WMEH", 4, 239588},
	{"WMEG", 4, 216254},
	{"WMEE", 4, 130508},
	{"WMED", 4, 70388},
	{"WMEC", 4, 178176},
	{"WMEA", 4, 72611},
	{"WMDS", 4, 89281},
	{"WMDA", 4, 169624},
	{"WMD", 3, 48057},
	{"WMCG", 4, 259647},
	{"WMCD", 4, 242163},
	{"WMCC", 4, 120812},
	{"WMC", 3, 95016},
	{"WMB", 3, 200172},
	{"WMAZ", 4, 246138},
	{"WMAY", 4, 77144},
	{"WMATA", 5, 175599},
	{"WMAT", 4, 56490},
	{"WMASS", 5, 210191},
	{"WMAS", 4, 241553},
	{"WMAR", 4, 52035},
	{"WMAQ", 4, 256507},
	{"WMAP", 4, 135608},
	{"WMAL", 4, 205251},
	{"WMAKER", 6, 239547},
	{"WMAK", 4, 42397},
	{"WMAJ", 4, 120211},
	{"WMAI", 4, 90993},
	{"WMAG", 4, 114515},
	{"WMAD", 4, 86614},
	{"WMA", 3, 36049},
	{"WLZ", 3, 115328},
	{"WLYW", 4, 86117},
	{"WLYU", 4, 165330},
	{"WLYT", 4, 82414},
	{"WLYS", 4, 88526},
	{"WLYR", 4, 69368},
	{"WLYP", 4, 96114},
	{"WLYO", 4, 99114},
	{"WLYN", 4, 153125},
	{"WLYM", 4, 85962},
	{"WLYL", 4, 109647},
	{"WLYI", 4, 73509},
	{"WLYH", 4, 145623},
	{"WLYG", 4, 128583},
	{"WLYF", 4, 67342},
	{"WLYE", 4, 71659},
	{"WLYD", 4, 72550},
	{"WLYC", 4, 67974},
	{"WLYB", 4, 69911},
	{"WLYA", 4, 62157},
	{"WLXX", 4, 124953},
	{"WLXL", 4, 114944},
	{"WLX", 3, 7717},
	{"WLWT", 4, 258674},
	{"WLWO", 4, 236730},
	{"WLWI", 4, 87912},
	{"WLWH", 4, 121689},
	{"WLWE", 4, 188872},
	{"WLWA", 4, 142395},
	{"WLW", 3, 222347},
	{"WLVI", 4, 137729},
	{"WLUX", 4, 247550},
	{"WLUS", 4, 252832},
	{"WLUN", 4, 169991},
	{"WLUG", 4, 140393},
	{"WLUC", 4, 128860},
	{"WLU", 3, 175680},
	{"WLTR", 4, 200180},
	{"WLTO", 4, 111274},
	{"WLTI", 4, 150602},
	{"WLTE", 4, 160330},
	{"WLSW", 4, 132177},
	{"WLSU", 4, 139735},
	{"WLST", 4, 105917},
	{"WLSS", 4, 174142},
	{"WLSP", 4, 146566},
	{"WLSO", 4, 115342},
	{"WLSM", 4, 232366},
	{"WLSL", 4, 237970},
	{"WLSI", 4, 123589},
	{"WLSH", 4, 138303},
	{"WLSF", 4, 174455},
	{"WLSE", 4, 188458},
	{"WLSD", 4, 243001},
	{"WLSC", 4, 164979},
	{"WLSB", 4, 189552},
	{"WLSA", 4, 89222},
	{"WLRU", 4, 222420},
	{"WLRI", 4, 168886},
	{"WLRE", 4, 134515},
	{"WLR", 3, 147413},
	{"WLQU", 4, 252833},
	{"WLQ", 3, 53341},
	{"WLPR", 4, 188558},
	{"WLPL", 4, 203277},
	{"WLPA", 4, 186274},
	{"WLP", 3, 125320},
	{"WLOX", 4, 216202},
	{"WLOW", 4, 89403},
	{"WLOV", 4, 112268},
	{"WLOU", 4, 123048},
	{"WLOT", 4, 155909},
	{"WLOS", 4, 95584},
	{"WLOR", 4, 104735},
	{"WLOO", 4, 64047},
	{"WLON", 4, 46107},
	{"WLOF", 4, 90339},
	{"WLOD", 4, 187586},
	{"WLOC", 4, 68983},
	{"WLOA", 4, 130509},
	{"WLNZIP", 6, 236534},
	{"WLNO", 4, 254222},
	{"WLMV", 4, 205558},
	{"WLMO", 4, 231071},
	{"WLMA", 4, 173509},
	{"WLM", 3, 141832},
	{"WLLO", 4, 141052},
	{"WLLI", 4, 219498},
	{"WLLE", 4, 232949},
	{"WLLA", 4, 194816},
	{"WLL", 3, 103572},
	{"WLIV", 4, 62845},
	{"WLIT", 4, 74783},
	{"WLIS", 4, 88688},
	{"WLIQ", 4, 261944},
	{"WLIN", 4, 36351},
	{"WLIM", 4, 117586},
	{"WLIK", 4, 79448},
	{"WLIG", 4, 82581},
	{"WLIF", 4, 64407},
	{"WLIE", 4, 152336},
	{"WLIC", 4, 151656},
	{"WLHO", 4, 230282},
	{"WLHI", 4, 195250},
	{"WLHE", 4, 202758},
	{"WLHA", 4, 153774},
	{"WLG", 3, 243868},
	{"WLFR", 4, 225790},
	{"WLFO", 4, 128262},
	{"WLFI", 4, 239329},
	{"WLF", 3, 177332},
	{"WLEY", 4, 56497},
	{"WLEX", 4, 223748},
	{"WLEW", 4, 219943},
	{"WLEV", 4, 59830},
	{"WLET", 4, 66758},
	{"WLES", 4, 53990},
	{"WLER", 4, 44013},
	{"WLEO", 4, 121943},
	{"WLEN", 4, 85599},
	{"WLEMB", 5, 177584},
	{"WLEL", 4, 173824},
	{"WLEI", 4, 233506},
	{"WLEG", 4, 84595},
	{"WLEF", 4, 100601},
	{"WLEE", 4, 175621},
	{"WLED", 4, 8288},
	{"WLEA", 4, 56695},
	{"WLDJ", 4, 115859},
	{"WLDE", 4, 186275},
	{"WLD", 3, 137854},
	{"WLCO", 4, 110755},
	{"WLCH", 4, 98947},
	{"WLCA", 4, 190484},
	{"WLC", 3, 171012},
	{"WLBY", 4, 225073},
	{"WLBU", 4, 176367},
	{"WLBO", 4, 257022},
	{"WLBI", 4, 243899},
	{"WLBE", 4, 126184},
	{"WLBA", 4, 189553},
	{"WLB", 3, 219345},
	{"WLAY", 4, 150728},
	{"WLAW", 4, 66708},
	{"WLAU", 4, 127380},
	{"WLAT", 4, 87219},
	{"WLAR", 4, 78366},
	{"WLAP", 4, 107819},
	{"WLANS", 5, 106279},
	{"WLAN", 4, 45870},
	{"WLAM", 4, 159885},
	{"WLAL", 4, 178648},
	{"WLAK", 4, 111825},
	{"WLAI", 4, 246620},
	{"WLAG", 4, 166124},
	{"WLAF", 4, 184851},
	{"WLADYSLAW", 9, 210387},
	{"WLADIMIR", 8, 216707},
	{"WLAD", 4, 179728},
	{"WLAC", 4, 160331},
	{"WLAB", 4, 86919},
	{"WL", 2, 269},
	{"WKZ", 3, 107355},
	{"WKYT", 4, 248630},
	{"WKY", 3, 187884},
	{"WKX", 3, 112913},
	{"WKWI", 4, 206622},
	{"WKWH", 4, 252834},
	{"WKWA", 4, 59226},
	{"WKW", 3, 2981},
	{"WKVA", 4, 219499},
	{"WKV", 3, 47234},
	{"WKU", 3, 129596},
	{"WKTS", 4, 172943},
	{"WKTO", 4, 248810},
	{"WKTH", 4, 202049},
	{"WKSW", 4, 83684},
	{"WKSU", 4, 140123},
	{"WKST", 4, 94299},
	{"WKSS", 4, 111553},
	{"WKSR", 4, 142648},
	{"WKSO", 4, 125463},
	{"WKSN", 4, 186626},
	{"WKSM", 4, 144639},
	{"WKSL", 4, 143769},
	{"WKSI", 4, 115232},
	{"WKSH", 4, 100649},
	{"WKSG", 4, 163321},
	{"WKSF", 4, 116912},
	{"WKSE", 4, 183120},
	{"WKSD", 4, 141633},
	{"WKSC", 4, 115067},
	{"WKSB", 4, 106721},
	{"WKSA", 4, 78969},
	{"WKRI", 4, 218638},
	{"WKRE", 4, 207922},
	{"WKRA", 4, 254595},
	{"WKQ", 3, 89258},
	{"WKPA", 4, 209061},
	{"WKOR", 4, 239857},
	{"WKON", 4, 229227},
	{"WKO", 3, 28565},
	{"WKNO", 4, 55430},
	{"WKNI", 4, 162125},
	{"WKNE", 4, 175173},
	{"WKND", 4, 224343},
	{"WKMO", 4, 224631},
	{"WKMA", 4, 188282},
	{"WKLY", 4, 154183},
	{"WKLV", 4, 166788},
	{"WKK", 3, 63930},
	{"WKJ", 3, 64588},
	{"WKIT", 4, 155493},
	{"WKIS", 4, 127110},
	{"WKIR", 4, 183121},
	{"WKIN", 4, 49266},
	{"WKIM", 4, 250460},
	{"WKIL", 4, 111887},
	{"WKID", 4, 109559},
	{"WKIC", 4, 199849},
	{"WKI", 3, 1553},
	{"WKHE", 4, 212617},
	{"WKHA", 4, 176460},
	{"WKG", 3, 268},
	{"WKF", 3, 41408},
	{"WKEY", 4, 63213},
	{"WKES", 4, 100043},
	{"WKER", 4, 91204},
	{"WKEP", 4, 206433},
	{"WKEN", 4, 123905},
	{"WKEL", 4, 195087},
	{"WKEI", 4, 250108},
	{"WKEE", 4, 146823},
	{"WKED", 4, 234885},
	{"WKEA", 4, 207725},
	{"WKE", 3, 1829},
	{"WKDW", 4, 124362},
	{"WKD", 3, 267},
	{"WKCO", 4, 227457},
	{"WKBT", 4, 230990},
	{"WKB", 3, 189918},
	{"WKAT", 4, 156749},
	{"WKAS", 4, 241587},
	{"WKAN", 4, 115877},
	{"WKAL", 4, 253884},
	{"WK", 2, 266},
	{"WJZ", 3, 223625},
	{"WJY", 3, 143508},
	{"WJX", 3, 95979},
	{"WJV", 3, 127827},
	{"WJUS", 4, 69388},
	{"WJUR", 4, 198691},
	{"WJUN", 4, 139586},
	{"WJUM", 4, 150154},
	{"WJUL", 4, 192206},
	{"WJUD", 4, 130510},
	{"WJR", 3, 208887},
	{"WJQ", 3, 196842},
	{"WJOU", 4, 108565},
	{"WJOS", 4, 194081},
	{"WJON", 4, 70479},
	{"WJOI", 4, 134810},
	{"WJOH", 4, 97877},
	{"WJOE", 4, 190485},
	{"WJOB", 4, 65171},
	{"WJO", 3, 1717},
	{"WJM", 3, 259943},
	{"WJLA", 4, 155188},
	{"WJL", 3, 63766},
	{"WJK", 3, 116141},
	{"WJIM", 4, 187734},
	{"WJF", 3, 69903},
	{"WJEW", 4, 162293},
	{"WJET", 4, 214030},
	{"WJES", 4, 174546},
	{"WJER", 4, 38334},
	{"WJEN", 4, 225791},
	{"WJEF", 4, 217944},
	{"WJEA", 4, 256337},
	{"WJE", 3, 1198},
	{"WJC", 3, 205673},
	{"WJAS", 4, 260849},
	{"WJAP", 4, 154380},
	{"WJAN", 4, 169540},
	{"WJAM", 4, 141946},
	{"WJAI", 4, 214031},
	{"WJAC", 4, 75579},
	{"WIZZY", 5, 256136},
	{"WIZZARD", 7, 159211},
	{"WIZZ", 4, 144450},
	{"WIZKIDS", 7, 111498},
	{"WIZENED", 7, 227404},
	{"WIZDOM", 6, 257954},
	{"WIZDATA", 7, 157983},
	{"WIZCOM", 6, 155634},
	{"WIZBANG", 7, 81277},
	{"WIZARDS", 7, 39631},
	{"WIZARDRY", 8, 89498},
	{"WIZARDING", 9, 158330},
	{"WIZARD", 6, 9174},
	{"WIYA", 4, 179553},
	{"WIXVORLAGE", 10, 220078},
	{"WIXON", 5, 210995},
	{"WIXOM", 5, 141211},
	{"WIXEN", 5, 157311},
	{"WIXCOM", 6, 216616},
	{"WIWO", 4, 102015},
	{"WIWI", 4, 119318},
	{"WIWH", 4, 231827},
	{"WIWA", 4, 182904},
	{"WIVES", 5, 34417},
	{"WIVENHOE", 8, 139599},
	{"WIVE", 4, 181188},
	{"WIUS", 4, 249774},
	{"WIUN", 4, 243315},
	{"WITZEL", 6, 236930},
	{"WITZ", 4, 190403},
	{"WITY", 4, 215038},
	{"WITWATERSRAND", 13, 134769},
	{"WITW", 4, 47545},
	{"WITU", 4, 124025},
	{"WITTY", 5, 50526},
	{"WITTON", 6, 186474},
	{"WITTNER", 7, 181274},
	{"WITTNAUER", 9, 140836},
	{"WITTMANN", 8, 170215},
	{"WITTMAN", 7, 146354},
	{"WITTILY", 7, 256456},
	{"WITTIG", 6, 157958},
	{"WITTICISMS", 10, 259247},
	{"WITTGENSTEIN", 12, 86915},
	{"WITTERING", 9, 216998},
	{"WITTER", 6, 101657},
	{"WITTENBURG", 10, 245813},
	{"WITTENBERG", 10, 82130},
	{"WITTEN", 6, 94219},
	{"WITTEKIND", 9, 232142},
	{"WITTED", 6, 116547},
	{"WITTE", 5, 88281},
	{"WITSAND", 7, 248650},
	{"WITR", 4, 113920},
	{"WITP", 4, 135359},
	{"WITOLD", 6, 139981},
	{"WITNEY", 6, 100469},
	{"WITNESSING", 10, 63289},
	{"WITNESSETH", 10, 259771},
	{"WITNESSES", 9, 31883},
	{"WITNESSED", 9, 42524},
	{"WITNESS", 7, 5875},
	{"WITMER", 6, 135384},
	{"WITM", 4, 101876},
	{"WITLESS", 7, 161279},
	{"WITL", 4, 116414},
	{"WITKOWSKI", 9, 206703},
	{"WITKIN", 6, 184027},
	{"WITK", 4, 192623},
	{"WITJ", 4, 243002},
	{"WITHVAL", 7, 162374},
	{"WITHUT", 6, 254714},
	{"WITHTHE", 7, 135143},
	{"WITHT", 5, 202701},
	{"WITHSTOOD", 9, 117942},
	{"WITHSTANDS", 10, 137726},
	{"WITHSTANDING", 12, 106408},
	{"WITHSTAND", 9, 50770},
	{"WITHROW", 7, 167208},
	{"WITHOUT", 7, 625},
	{"WITHOU", 6, 184666},
	{"WITHNAIL", 8, 229966},
	{"WITHINGTON", 10, 137659},
	{"WITHING", 7, 154720},
	{"WITHIN", 6, 1354},
	{"WITHIIN", 7, 243253},
	{"WITHHOLDS", 9, 154670},
	{"WITHHOLDINGS", 12, 185317},
	{"WITHHOLDING", 11, 47003},
	{"WITHHOLD", 8, 57818},
	{"WITHHELD", 8, 43928},
	{"WITHEVENTS", 10, 248603},
	{"WITHERSPOON", 11, 63074},
	{"WITHERS", 7, 73880},
	{"WITHERNSEA", 10, 233322},
	{"WITHERINGTON", 12, 250061},
	{"WITHERING", 9, 112052},
	{"WITHERED", 8, 95528},
	{"WITHER", 6, 94508},
	{"WITHE", 5, 183073},
	{"WITHDREW", 8, 55248},
	{"WITHDRAWS", 9, 76174},
	{"WITHDRAWN", 9, 37728},
	{"WITHDRAWLS", 10, 173299},
	{"WITHDRAWL", 9, 72987},
	{"WITHDRAWING", 11, 62109},
	{"WITHDRAWEL", 10, 222713},
	{"WITHDRAWALS", 11, 56261},
	{"WITHDRAWAL", 10, 32224},
	{"WITHDRAW", 8, 9099},
	{"WITHAM", 6, 104223},
	{"WITHAL", 6, 101195},
	{"WITHA", 5, 150890},
	{"WITH", 4, 624},
	{"WITG", 4, 124157},
	{"WITD", 4, 105732},
	{"WITCHY", 6, 132481},
	{"WITCHWOOD", 9, 260674},
	{"WITCHVOX", 8, 159534},
	{"WITCHITA", 8, 240954},
	{"WITCHING", 8, 144174},
	{"WITCHES", 7, 49178},
	{"WITCHERY", 8, 143288},
	{"WITCHER", 7, 176677},
	{"WITCHED", 7, 187269},
	{"WITCHCRAFT", 10, 55305},
	{"WITCHBLADE", 10, 141296},
	{"WITCH", 5, 33083},
	{"WITBANK", 7, 192158},
	{"WITB", 4, 105669},
	{"WISY", 4, 172060},
	{"WISW", 4, 65526},
	{"WISV", 4, 138578},
	{"WISU", 4, 114959},
	{"WISTS", 5, 67295},
	{"WISTFULLY", 9, 148983},
	{"WISTFUL", 7, 112664},
	{"WISTERIA", 8, 99700},
	{"WISTER", 6, 182491},
	{"WISTAR", 6, 99645},
	{"WISSENSCHAFTLICHE", 17, 192543},
	{"WISSENSCHAFTEN", 14, 130495},
	{"WISSENSCHAFT", 12, 109241},
	{"WISSEN", 6, 108062},
	{"WISSE", 5, 249622},
	{"WISSAHICKON", 11, 210420},
	{"WISR", 4, 83248},
	{"WISPY", 5, 146379},
	{"WISPS", 5, 118988},
	{"WISPER", 6, 213918},
	{"WISPA", 5, 222373},
	{"WISP", 4, 72559},
	{"WISNIEWSKI", 10, 130592},
	{"WISNER", 6, 133023},
	{"WISMAR", 6, 208057},
	{"WISMA", 5, 192595},
	{"WISM", 4, 85175},
	{"WISLEY", 6, 244391},
	{"WISLA", 5, 256777},
	{"WISL", 4, 86239},
	{"WISKUNDE", 8, 191467},
	{"WISK", 4, 256565},
	{"WISJ", 4, 140617},
	{"WISHY", 5, 146582},
	{"WISHMASTER", 10, 203883},
	{"WISHLISTS", 9, 105588},
	{"WISHLIST", 8, 8077},
	{"WISHING", 7, 623},
	{"WISHIN", 6, 215031},
	{"WISHFUL", 7, 80801},
	{"WISHES", 6, 622},
	{"WISHERS", 7, 153242},
	{"WISHER", 6, 205361},
	{"WISHED", 6, 40517},
	{"WISHBONES", 9, 228908},
	{"WISHBONE", 8, 90234},
	{"WISHAW", 6, 152199},
	{"WISHART", 7, 121034},
	{"WISHARD", 7, 247437},
	{"WISH", 4, 621},
	{"WISG", 4, 101212},
	{"WISF", 4, 89036},
	{"WISEST", 6, 99328},
	{"WISES", 5, 190042},
	{"WISERADVISOR", 12, 228546},
	{"WISER", 5, 65810},
	{"WISENUT", 7, 80366},
	{"WISEMAN", 7, 71953},
	{"WISELY", 6, 51675},
	{"WISEGUY", 7, 107130},
	{"WISECRACKS", 10, 230575},
	{"WISECRACKING", 12, 229134},
	{"WISECOMM", 8, 240522},
	{"WISECO", 6, 225716},
	{"WISE", 4, 28861},
	{"WISDOT", 6, 240638},
	{"WISDOMS", 7, 171018},
	{"WISDOM", 6, 9660},
	{"WISDEN", 6, 87600},
	{"WISCONSIN", 9, 3731},
	{"WISCO", 5, 231045},
	{"WISCASSET", 9, 145871},
	{"WISC", 4, 90964},
	{"WISBECH", 7, 119623},
	{"WISB", 4, 76822},
	{"WIRY", 4, 146685},
	{"WIRTZ", 5, 116283},
	{"WIRTSCHAFTS", 11, 223137},
	{"WIRTSCHAFT", 10, 97261},
	{"WIRTH", 5, 92585},
	{"WIRT", 4, 125599},
	{"WIRST", 5, 182434},
	{"WIRS", 4, 176889},
	{"WIRRAL", 6, 71099},
	{"WIRR", 4, 160965},
	{"WIRO", 4, 168722},
	{"WIRLINES", 8, 232538},
	{"WIRLESS", 7, 178017},
	{"WIRL", 4, 73036},
	{"WIRKUNG", 7, 222072},
	{"WIRKSWORTH", 10, 137724},
	{"WIRKLICH", 8, 155542},
	{"WIRING", 6, 34709},
	{"WIREWOUND", 9, 211122},
	{"WIRETAPS", 8, 86002},
	{"WIRETAPPING", 11, 88974},
	{"WIRETAP", 7, 84853},
	{"WIRES", 5, 35875},
	{"WIREPLAY", 8, 228665},
	{"WIRELINE", 8, 76416},
	{"WIRELESSLY", 10, 78932},
	{"WIRELESS", 8, 1703},
	{"WIRELES", 7, 150857},
	{"WIREIMAGE", 9, 127719},
	{"WIREHAIRED", 10, 139479},
	{"WIREFREE", 8, 218800},
	{"WIREFRAMES", 10, 258336},
	{"WIREFRAME", 9, 122834},
	{"WIREFLY", 7, 136075},
	{"WIREDRED", 8, 236951},
	{"WIRED", 5, 30499},
	{"WIREBOUND", 9, 219374},
	{"WIRE", 4, 265},
	{"WIRD", 4, 60287},
	{"WIRA", 4, 178389},
	{"WIPS", 4, 166955},
	{"WIPRO", 5, 97178},
	{"WIPR", 4, 158789},
	{"WIPPIT", 6, 145325},
	{"WIPP", 4, 137404},
	{"WIPO", 4, 65045},
	{"WIPING", 6, 68001},
	{"WIPI", 4, 96577},
	{"WIPH", 4, 131945},
	{"WIPES", 5, 55422},
	{"WIPERS", 6, 65794},
	{"WIPER", 5, 57100},
	{"WIPEOUT", 7, 95283},
	{"WIPED", 5, 53491},
	{"WIPE", 4, 8411},
	{"WIPA", 4, 193475},
	{"WINZIP", 6, 55542},
	{"WINZ", 4, 254376},
	{"WINY", 4, 108317},
	{"WINXP", 5, 39320},
	{"WINX", 4, 132208},
	{"WINWORD", 7, 226809},
	{"WINWOOD", 7, 124371},
	{"WINW", 4, 46195},
	{"WINVNC", 6, 222381},
	{"WINV", 4, 64709},
	{"WINU", 4, 109929},
	{"WINTV", 5, 96161},
	{"WINTRY", 6, 110541},
	{"WINTOUR", 7, 240120},
	{"WINTON", 6, 76737},
	{"WINTHROP", 8, 58594},
	{"WINTHER", 7, 157029},
	{"WINTERY", 7, 200626},
	{"WINTERVILLE", 11, 151312},
	{"WINTERTON", 9, 130874},
	{"WINTERTIME", 10, 110568},
	{"WINTERTHUR", 10, 109865},
	{"WINTERSPORTS", 12, 201357},
	{"WINTERSON", 9, 178837},
	{"WINTERSET", 9, 167928},
	{"WINTERS", 7, 46509},
	{"WINTERNATIONALS", 15, 255836},
	{"WINTERMUTE", 10, 240918},
	{"WINTERM", 7, 196486},
	{"WINTERLAND", 10, 212789},
	{"WINTERIZING", 11, 173619},
	{"WINTERIZE", 9, 211858},
	{"WINTERING", 9, 95433},
	{"WINTERHAVEN", 11, 237403},
	{"WINTERGREEN", 11, 105009},
	{"WINTERFEST", 10, 141847},
	{"WINTERED", 8, 227416},
	{"WINTERBOURNE", 12, 175761},
	{"WINTERBOTTOM", 12, 156036},
	{"WINTERBERG", 10, 192876},
	{"WINTER", 6, 3716},
	{"WINTEL", 6, 125088},
	{"WINTEC", 6, 221631},
	{"WINTASKS", 8, 92478},
	{"WINTASK", 7, 259437},
	{"WINSYSTEMS", 10, 166670},
	{"WINSUP", 6, 162154},
	{"WINSTRONICS", 11, 215537},
	{"WINSTROL", 8, 108042},
	{"WINSTONE", 8, 154489},
	{"WINSTON", 7, 33012},
	{"WINSTED", 7, 133765},
	{"WINSTEAD", 8, 145988},
	{"WINSTAR", 7, 130791},
	{"WINSTANLEY", 10, 165739},
	{"WINSPEAR", 8, 240710},
	{"WINSOR", 6, 85055},
	{"WINSON", 6, 243147},
	{"WINSOME", 7, 111706},
	{"WINSOCK", 7, 91377},
	{"WINSLOW", 7, 59953},
	{"WINSLEY", 7, 246248},
	{"WINSLET", 7, 82365},
	{"WINSITE", 7, 94767},
	{"WINSHIP", 7, 155524},
	{"WINSFORD", 8, 155906},
	{"WINS", 4, 7836},
	{"WINROUTE", 8, 150444},
	{"WINROCK", 7, 221219},
	{"WINRAR", 6, 80845},
	{"WINR", 4, 68257},
	{"WINQ", 4, 192624},
	{"WINPROXY", 8, 182098},
	{"WINPOPUP", 8, 200975},
	{"WINPLANET", 9, 166151},
	{"WINPCAP", 7, 182934},
	{"WINPATROL", 9, 199839},
	{"WINP", 4, 58404},
	{"WINOOSKI", 8, 141915},
	{"WINONA", 6, 58143},
	{"WINOKUR", 7, 252215},
	{"WINOGRAD", 8, 179287},
	{"WINNY", 5, 216618},
	{"WINNT", 5, 39765},
	{"WINNSBORO", 9, 123739},
	{"WINNS", 5, 226609},
	{"WINNOWING", 9, 208162},
	{"WINNOW", 6, 201704},
	{"WINNOV", 6, 179545},
	{"WINNIPESAUKEE", 13, 168320},
	{"WINNIPEG", 8, 37476},
	{"WINNINGS", 8, 64997},
	{"WINNINGHAM", 10, 252374},
	{"WINNINGEST", 10, 172984},
	{"WINNING", 7, 3841},
	{"WINNIFRED", 9, 223966},
	{"WINNIE", 6, 44715},
	{"WINNICOTT", 9, 258978},
	{"WINNICK", 7, 187171},
	{"WINNI", 5, 230895},
	{"WINNFIELD", 9, 212550},
	{"WINNETT", 7, 250360},
	{"WINNETKA", 8, 102732},
	{"WINNESHIEK", 10, 206786},
	{"WINNERS", 7, 7596},
	{"WINNERO", 7, 252815},
	{"WINNER", 6, 5789},
	{"WINNEMUCCA", 10, 125232},
	{"WINNECONNE", 10, 257328},
	{"WINNEBAGO", 9, 70411},
	{"WINNE", 5, 198827},
	{"WINNABLE", 8, 200958},
	{"WINMX", 5, 95673},
	{"WINMPG", 6, 234989},
	{"WINMODEM", 8, 157706},
	{"WINME", 5, 46605},
	{"WINMATRIX", 9, 240374},
	{"WINM", 4, 54475},
	{"WINLOGON", 8, 130120},
	{"WINLOCK", 7, 200477},
	{"WINLINE", 7, 162577},
	{"WINLESS", 7, 148121},
	{"WINLAW", 6, 242145},
	{"WINL", 4, 56812},
	{"WINKY", 5, 137888},
	{"WINKWORTH", 9, 223453},
	{"WINKSITE", 8, 155758},
	{"WINKS", 5, 85982},
	{"WINKLER", 7, 67282},
	{"WINKLE", 6, 105628},
	{"WINKING", 7, 115036},
	{"WINKELWAGEN", 11, 132413},
	{"WINKELS", 7, 187455},
	{"WINKELMANN", 10, 210972},
	{"WINKELMAN", 9, 196226},
	{"WINKELEN", 8, 205645},
	{"WINKEL", 6, 82614},
	{"WINKED", 6, 120058},
	{"WINK", 4, 46986},
	{"WINJ", 4, 81556},
	{"WINING", 6, 83409},
	{"WININFO", 7, 118294},
	{"WININET", 7, 241140},
	{"WINIFRED", 8, 94406},
	{"WINICK", 6, 184592},
	{"WINHELP", 7, 178944},
	{"WINHEC", 6, 236911},
	{"WINGTIPS", 8, 204263},
	{"WINGTIP", 7, 190526},
	{"WINGSPAN", 8, 99035},
	{"WINGS", 5, 7219},
	{"WINGO", 5, 144996},
	{"WINGNUTS", 8, 130578},
	{"WINGNUT", 7, 100583},
	{"WINGMAN", 7, 106577},
	{"WINGLESS", 8, 143289},
	{"WINGING", 7, 160515},
	{"WINGHAM", 7, 163961},
	{"WINGFIELD", 9, 111261},
	{"WINGET", 6, 213128},
	{"WINGERT", 7, 248984},
	{"WINGERS", 7, 97673},
	{"WINGER", 6, 71609},
	{"WINGED", 6, 49393},
	{"WINGDINGS", 9, 254314},
	{"WINGATE", 7, 59428},
	{"WINGARD", 7, 247145},
	{"WINGAP", 6, 250745},
	{"WING", 4, 5847},
	{"WINFX", 5, 120765},
	{"WINFUEL", 7, 252052},
	{"WINFS", 5, 152820},
	{"WINFRIED", 8, 169143},
	{"WINFREY", 7, 71440},
	{"WINFREE", 7, 240275},
	{"WINFRED", 7, 202377},
	{"WINFORMS", 8, 125363},
	{"WINFO", 5, 234865},
	{"WINFIXER", 8, 181489},
	{"WINFIELD", 8, 59527},
	{"WINFAX", 6, 134053},
	{"WINFAST", 7, 106292},
	{"WINF", 4, 42575},
	{"WINEX", 5, 174194},
	{"WINETEST", 8, 236663},
	{"WINESBURG", 9, 240722},
	{"WINES", 5, 29822},
	{"WINERY", 6, 43467},
	{"WINERIES", 8, 53047},
	{"WINER", 5, 79974},
	{"WINEMAKING", 10, 97646},
	{"WINEMAKERS", 10, 109983},
	{"WINEMAKER", 9, 98269},
	{"WINELEGEND", 10, 229075},
	{"WINELANDS", 9, 72192},
	{"WINEHQ", 6, 241704},
	{"WINEGLASS", 9, 226642},
	{"WINEGARD", 8, 249633},
	{"WINEFETCH", 9, 127373},
	{"WINEDT", 6, 217214},
	{"WINED", 5, 255940},
	{"WINE", 4, 4347},
	{"WINDY", 5, 47192},
	{"WINDWARD", 8, 76598},
	{"WINDVD", 6, 108649},
	{"WINDUS", 6, 195119},
	{"WINDUP", 6, 161350},
	{"WINDU", 5, 157774},
	{"WINDTUNNEL", 10, 152789},
	{"WINDTALKERS", 11, 202830},
	{"WINDSWEPT", 9, 130560},
	{"WINDSURFING", 11, 54779},
	{"WINDSURFERS", 11, 177061},
	{"WINDSURFER", 10, 184930},
	{"WINDSURF", 8, 118708},
	{"WINDSTORM", 9, 144717},
	{"WINDSTOPPER", 11, 128759},
	{"WINDSTAR", 8, 76946},
	{"WINDSPEED", 9, 151089},
	{"WINDSOR", 7, 31272},
	{"WINDSONG", 8, 160856},
	{"WINDSOCKS", 9, 164513},
	{"WINDSOCK", 8, 179856},
	{"WINDSHIRTS", 10, 178284},
	{"WINDSHIRT", 9, 163201},
	{"WINDSHIELDS", 11, 112937},
	{"WINDSHIELD", 10, 49441},
	{"WINDSCREENS", 11, 136853},
	{"WINDSCREEN", 10, 70097},
	{"WINDS", 5, 8886},
	{"WINDRUSH", 8, 225729},
	{"WINDROW", 7, 205241},
	{"WINDRIVERS", 10, 179212},
	{"WINDRIVER", 9, 211048},
	{"WINDRES", 7, 250391},
	{"WINDPROOF", 9, 114762},
	{"WINDPOWER", 9, 168839},
	{"WINDPIPE", 8, 185299},
	{"WINDOZE", 7, 117290},
	{"WINDOWTEXT", 10, 145455},
	{"WINDOWSXP", 9, 105513},
	{"WINDOWSUPDATE", 13, 249253},
	{"WINDOWSNT", 9, 195870},
	{"WINDOWSMEDIA", 12, 177162},
	{"WINDOWSINSTALLCOOKBOOK", 22, 229664},
	{"WINDOWSILL", 10, 152108},
	{"WINDOWSCE", 9, 235042},
	{"WINDOWS", 7, 1158},
	{"WINDOWPANE", 10, 162850},
	{"WINDOWMAKER", 11, 124369},
	{"WINDOWLESS", 10, 161114},
	{"WINDOWING", 9, 111100},
	{"WINDOWEVENT", 11, 257296},
	{"WINDOWED", 8, 121380},
	{"WINDOWBLINDS", 12, 104647},
	{"WINDOW", 6, 1881},
	{"WINDOM", 6, 131839},
	{"WINDO", 5, 170976},
	{"WINDMILLS", 9, 74203},
	{"WINDMILL", 8, 61657},
	{"WINDLEY", 7, 149114},
	{"WINDLE", 6, 186239},
	{"WINDLASSES", 10, 217904},
	{"WINDLASS", 8, 148315},
	{"WINDJAMMER", 10, 114283},
	{"WINDIR", 6, 118980},
	{"WINDINGS", 8, 111284},
	{"WINDING", 7, 44199},
	{"WINDIES", 7, 190541},
	{"WINDHORST", 9, 258640},
	{"WINDHOEK", 8, 82045},
	{"WINDHAM", 7, 56166},
	{"WINDGATE", 8, 161800},
	{"WINDFARMS", 9, 214255},
	{"WINDFARM", 8, 168673},
	{"WINDFALLS", 9, 204189},
	{"WINDFALL", 8, 73588},
	{"WINDEX", 6, 163795},
	{"WINDERS", 7, 75863},
	{"WINDERMERE", 10, 63293},
	{"WINDER", 6, 73552},
	{"WINDEMERE", 9, 229809},
	{"WINDELERZIEHUNG", 15, 189253},
	{"WINDEL", 6, 130450},
	{"WINDED", 6, 97637},
	{"WINDCREST", 9, 252471},
	{"WINDCHIMES", 10, 120770},
	{"WINDCHIME", 9, 142486},
	{"WINDCHILL", 9, 54007},
	{"WINDCHASER", 10, 235043},
	{"WINDBREAKS", 10, 201349},
	{"WINDBREAKERS", 12, 253324},
	{"WINDBREAKER", 11, 137489},
	{"WINDBREAK", 9, 203874},
	{"WINDBLOWN", 9, 189367},
	{"WINDBER", 7, 246516},
	{"WINDBAG", 7, 230375},
	{"WINDAGE", 7, 198037},
	{"WIND", 4, 3218},
	{"WINCVS", 6, 217199},
	{"WINCUSTOMIZE", 12, 231926},
	{"WINCRAFT", 8, 122978},
	{"WINCOR", 6, 190829},
	{"WINCO", 5, 148946},
	{"WINCKLER", 8, 226801},
	{"WINCING", 7, 199791},
	{"WINCHMORE", 9, 226072},
	{"WINCHESTER", 10, 38344},
	{"WINCHES", 7, 81126},
	{"WINCHENDON", 10, 148130},
	{"WINCHELSEA", 10, 221149},
	{"WINCHELL", 8, 137918},
	{"WINCHCOMBE", 10, 228418},
	{"WINCH", 5, 61418},
	{"WINCED", 6, 125473},
	{"WINCE", 5, 69932},
	{"WINCANTON", 9, 175265},
	{"WINC", 4, 37404},
	{"WINBOOK", 7, 87615},
	{"WINBOND", 7, 132968},
	{"WINBOARD", 8, 165637},
	{"WINBIND", 7, 142362},
	{"WINBACKUP", 9, 103262},
	{"WINB", 4, 45560},
	{"WINAVI", 6, 143243},
	{"WINARRANGER", 11, 150231},
	{"WINAPI", 6, 137393},
	{"WINANS", 6, 100049},
	{"WINAMP", 6, 44714},
	{"WINAMAC", 7, 247788},
	{"WINALL", 6, 177109},
	{"WINACE", 6, 249104},
	{"WINA", 4, 30767},
	{"WIN", 3, 620},
	{"WIMW", 4, 130001},
	{"WIMU", 4, 182867},
	{"WIMT", 4, 93526},
	{"WIMSEY", 6, 223660},
	{"WIMS", 4, 243116},
	{"WIMR", 4, 199527},
	{"WIMPY", 5, 105192},
	{"WIMPS", 5, 124916},
	{"WIMPOLE", 7, 256091},
	{"WIMP", 4, 101995},
	{"WIMO", 4, 145958},
	{"WIMN", 4, 131352},
	{"WIMMERA", 7, 165565},
	{"WIMMER", 6, 107796},
	{"WIML", 4, 175622},
	{"WIMJ", 4, 222855},
	{"WIMI", 4, 106802},
	{"WIMH", 4, 205736},
	{"WIMG", 4, 140159},
	{"WIMF", 4, 156235},
	{"WIMEN", 5, 253265},
	{"WIME", 4, 149380},
	{"WIMD", 4, 199681},
	{"WIMC", 4, 132739},
	{"WIMBORNE", 8, 122260},
	{"WIMBLEDON", 9, 50651},
	{"WIMBERLY", 8, 161760},
	{"WIMBERLEY", 9, 121877},
	{"WIMB", 4, 62669},
	{"WIMAX", 5, 53826},
	{"WILY", 4, 93137},
	{"WILTZ", 5, 246466},
	{"WILTSHIRE", 9, 43480},
	{"WILTS", 5, 104655},
	{"WILTRADE", 8, 191409},
	{"WILTON", 6, 50441},
	{"WILTING", 7, 146910},
	{"WILTERN", 7, 229077},
	{"WILTEL", 6, 233357},
	{"WILTED", 6, 131026},
	{"WILT", 4, 56684},
	{"WILSONVILLE", 11, 96266},
	{"WILSONS", 7, 94897},
	{"WILSONIAN", 9, 211313},
	{"WILSONART", 9, 181100},
	{"WILSON", 6, 4788},
	{"WILSHIRE", 8, 61528},
	{"WILSEY", 6, 208854},
	{"WILS", 4, 238611},
	{"WILP", 4, 180317},
	{"WILO", 4, 142144},
	{"WILNER", 6, 169600},
	{"WILN", 4, 195838},
	{"WILMSLOW", 8, 108152},
	{"WILMS", 5, 137177},
	{"WILMOTT", 7, 212963},
	{"WILMOTH", 7, 247179},
	{"WILMOT", 6, 81845},
	{"WILMORE", 7, 149712},
	{"WILMINGTON", 10, 37626},
	{"WILMETTE", 8, 104018},
	{"WILMERDING", 10, 249996},
	{"WILMER", 6, 94084},
	{"WILMAR", 6, 199748},
	{"WILMA", 5, 56563},
	{"WILM", 4, 168068},
	{"WILLYS", 6, 97008},
	{"WILLY", 5, 46409},
	{"WILLUNGA", 8, 225383},
	{"WILLST", 6, 161838},
	{"WILLSON", 7, 88802},
	{"WILLS", 5, 38036},
	{"WILLPOWER", 9, 99566},
	{"WILLOWY", 7, 249312},
	{"WILLOWTIP", 9, 256196},
	{"WILLOWS", 7, 66494},
	{"WILLOWICK", 9, 229150},
	{"WILLOWDALE", 10, 159917},
	{"WILLOWBROOK", 11, 101932},
	{"WILLOWBANK", 10, 218243},
	{"WILLOW", 6, 36306},
	{"WILLOUGHBY", 10, 68169},
	{"WILLO", 5, 153432},
	{"WILLNER", 7, 216562},
	{"WILLMS", 6, 240825},
	{"WILLMOTT", 8, 168233},
	{"WILLMORE", 8, 206983},
	{"WILLMAR", 7, 122914},
	{"WILLMAN", 7, 212055},
	{"WILLL", 5, 200439},
	{"WILLKOMMEN", 10, 113187},
	{"WILLKIE", 7, 236293},
	{"WILLITS", 7, 102873},
	{"WILLISTON", 9, 72274},
	{"WILLISON", 8, 132171},
	{"WILLISMS", 8, 246254},
	{"WILLIS", 6, 38331},
	{"WILLIRAYE", 9, 216928},
	{"WILLINGTON", 10, 140698},
	{"WILLINGNESS", 11, 32551},
	{"WILLINGLY", 9, 60782},
	{"WILLINGHAM", 10, 105915},
	{"WILLINGER", 9, 249065},
	{"WILLINGDON", 10, 213596},
	{"WILLINGBORO", 11, 167314},
	{"WILLING", 7, 3902},
	{"WILLIN", 6, 217932},
	{"WILLIMANTIC", 11, 134432},
	{"WILLIG", 6, 210821},
	{"WILLIFORD", 9, 182119},
	{"WILLIES", 7, 158137},
	{"WILLIE", 6, 38222},
	{"WILLIBALD", 9, 248573},
	{"WILLIAMTOWN", 11, 227146},
	{"WILLIAMSVILLE", 13, 100689},
	{"WILLIAMSTOWN", 12, 72792},
	{"WILLIAMSTON", 11, 121507},
	{"WILLIAMSPORT", 12, 73154},
	{"WILLIAMSON", 10, 39692},
	{"WILLIAMSBURG", 12, 42814},
	{"WILLIAMS", 8, 3578},
	{"WILLIAM", 7, 2243},
	{"WILLIA", 6, 166961},
	{"WILLI", 5, 89568},
	{"WILLHELM", 8, 236797},
	{"WILLGOTO", 8, 231764},
	{"WILLFULNESS", 11, 231292},
	{"WILLFULLY", 9, 78282},
	{"WILLFUL", 7, 67134},
	{"WILLEY", 6, 95313},
	{"WILLETTS", 8, 177010},
	{"WILLETT", 7, 90707},
	{"WILLETS", 7, 212127},
	{"WILLET", 6, 163382},
	{"WILLESDEN", 9, 135192},
	{"WILLER", 6, 235735},
	{"WILLENHALL", 10, 167621},
	{"WILLEN", 6, 163546},
	{"WILLEMSTAD", 10, 158827},
	{"WILLEMS", 7, 133152},
	{"WILLEM", 6, 64410},
	{"WILLED", 6, 83482},
	{"WILLEBRAND", 10, 130833},
	{"WILLE", 5, 129440},
	{"WILLD", 5, 182041},
	{"WILLCOX", 7, 114637},
	{"WILLBE", 6, 162737},
	{"WILLARD", 7, 51099},
	{"WILLAPA", 7, 180536},
	{"WILLAN", 6, 216508},
	{"WILLAMINA", 9, 226876},
	{"WILLAMETTE", 10, 62436},
	{"WILLAM", 6, 215578},
	{"WILLACY", 7, 174533},
	{"WILLA", 5, 91907},
	{"WILL", 4, 619},
	{"WILKS", 5, 110312},
	{"WILKO", 5, 181072},
	{"WILKINSONS", 10, 257965},
	{"WILKINSON", 9, 45865},
	{"WILKINSBURG", 11, 218003},
	{"WILKINS", 7, 51741},
	{"WILKIN", 6, 127552},
	{"WILKIE", 6, 91180},
	{"WILKESBORO", 10, 129628},
	{"WILKES", 6, 50404},
	{"WILKERSON", 9, 81749},
	{"WILKENS", 7, 144728},
	{"WILKEN", 6, 153366},
	{"WILKE", 5, 125230},
	{"WILK", 4, 137557},
	{"WILIAM", 6, 203421},
	{"WILI", 4, 61555},
	{"WILHOIT", 7, 252569},
	{"WILHITE", 7, 187224},
	{"WILHELMSHAVEN", 13, 250299},
	{"WILHELMSEN", 10, 248782},
	{"WILHELMS", 8, 205424},
	{"WILHELMINE", 10, 233454},
	{"WILHELMINA", 10, 127118},
	{"WILHELMI", 8, 220941},
	{"WILHELM", 7, 50697},
	{"WILFULLY", 8, 122967},
	{"WILFUL", 6, 109446},
	{"WILFRIED", 8, 134685},
	{"WILFRID", 7, 89667},
	{"WILFREDO", 8, 185696},
	{"WILFRED", 7, 75477},
	{"WILFORD", 7, 113406},
	{"WILF", 4, 133523},
	{"WILEY", 5, 36433},
	{"WILES", 5, 93140},
	{"WILENTZ", 7, 247011},
	{"WILENSKY", 8, 184395},
	{"WILE", 4, 111866},
	{"WILDWOOD", 8, 59971},
	{"WILDTYPE", 8, 195141},
	{"WILDTANGENT", 11, 229215},
	{"WILDSTROM", 9, 161550},
	{"WILDSTORM", 9, 127468},
	{"WILDSIDE", 8, 126228},
	{"WILDS", 5, 94714},
	{"WILDROSE", 8, 244604},
	{"WILDOMAR", 8, 167687},
	{"WILDNESS", 8, 138008},
	{"WILDMON", 7, 245036},
	{"WILDMAN", 7, 111829},
	{"WILDLY", 6, 53364},
	{"WILDLIFE", 8, 31027},
	{"WILDLANDS", 9, 137658},
	{"WILDLAND", 8, 76489},
	{"WILDL", 5, 160781},
	{"WILDING", 7, 133575},
	{"WILDHORSE", 9, 219907},
	{"WILDHEARTS", 10, 169841},
	{"WILDFOWL", 8, 148124},
	{"WILDFLOWERS", 11, 64772},
	{"WILDFLOWER", 10, 71186},
	{"WILDFIRES", 9, 90385},
	{"WILDFIRE", 8, 59834},
	{"WILDEST", 7, 71553},
	{"WILDES", 6, 251336},
	{"WILDERS", 7, 147393},
	{"WILDERNET", 9, 199586},
	{"WILDERNESSES", 12, 203498},
	{"WILDERNESS", 10, 30264},
	{"WILDERMUTH", 10, 239188},
	{"WILDER", 6, 52096},
	{"WILDENHUES", 10, 186847},
	{"WILDEN", 6, 160396},
	{"WILDEBEEST", 10, 130380},
	{"WILDE", 5, 49918},
	{"WILDCRAFTED", 11, 246484},
	{"WILDCHILD", 9, 259808},
	{"WILDCATS", 8, 44914},
	{"WILDCAT", 7, 62568},
	{"WILDCARDS", 9, 82028},
	{"WILDCARD", 8, 59887},
	{"WILDBLUE", 8, 227062},
	{"WILD", 4, 3930},
	{"WILCZEK", 7, 239257},
	{"WILCOXON", 8, 140643},
	{"WILCOX", 6, 51282},
	{"WILCOCK", 7, 208276},
	{"WILCO", 5, 72149},
	{"WILC", 4, 85547},
	{"WILBY", 5, 169937},
	{"WILBURYS", 8, 202024},
	{"WILBURTON", 9, 200535},
	{"WILBURN", 7, 128731},
	{"WILBUR", 6, 61132},
	{"WILBRAHAM", 9, 125905},
	{"WILBON", 6, 203650},
	{"WILBERT", 7, 115416},
	{"WILBERFORCE", 11, 118356},
	{"WILBER", 6, 94197},
	{"WILBARGER", 9, 218794},
	{"WILBANKS", 8, 169561},
	{"WILB", 4, 81273},
	{"WILAYAH", 7, 185771},
	{"WILA", 4, 133267},
	{"WIKTOR", 6, 240723},
	{"WIKTIONARY", 10, 93781},
	{"WIKT", 4, 115878},
	{"WIKN", 4, 110582},
	{"WIKKA", 5, 151396},
	{"WIKIWORDS", 9, 126343},
	{"WIKIWORD", 8, 106717},
	{"WIKIWIKIWEB", 11, 185766},
	{"WIKIWIKI", 8, 194318},
	{"WIKIWEBMASTER", 13, 126029},
	{"WIKIWEBLIST", 11, 212771},
	{"WIKIVERSITY", 11, 237228},
	{"WIKIVERSION", 11, 131922},
	{"WIKIUSERSTOPIC", 14, 145174},
	{"WIKIUSERNAME", 12, 89012},
	{"WIKITRAVEL", 10, 175249},
	{"WIKITOOLNAME", 12, 111221},
	{"WIKITEXT", 8, 223015},
	{"WIKITECH", 8, 106226},
	{"WIKISYNTAX", 10, 148780},
	{"WIKISPECIES", 11, 222959},
	{"WIKISOURCE", 10, 154660},
	{"WIKISANDBOX", 11, 229071},
	{"WIKIS", 5, 72213},
	{"WIKIQUOTE", 9, 137004},
	{"WIKIPROJECT", 11, 115390},
	{"WIKIPREFSTOPIC", 14, 142521},
	{"WIKIPEDIANS", 11, 144510},
	{"WIKIPEDIAN", 10, 260203},
	{"WIKIPEDIA", 9, 6000},
	{"WIKINOTATION", 12, 249619},
	{"WIKINEWS", 8, 118795},
	{"WIKINAMES", 9, 244955},
	{"WIKINAME", 8, 66369},
	{"WIKIMEDIA", 9, 38364},
	{"WIKIHOW", 7, 137121},
	{"WIKIHOMEURL", 11, 145590},
	{"WIKIHOME", 8, 222018},
	{"WIKIHELP", 8, 236205},
	{"WIKIFORMATTING", 14, 205259},
	{"WIKIDB", 6, 160220},
	{"WIKIDATA", 8, 171371},
	{"WIKICULTURE", 11, 174902},
	{"WIKICITIES", 10, 107622},
	{"WIKIBOOKS", 9, 116258},
	{"WIKIA", 5, 213509},
	{"WIKI", 4, 7643},
	{"WIKA", 4, 251259},
	{"WIJU", 4, 164376},
	{"WIJNEN", 6, 146684},
	{"WIJN", 4, 154027},
	{"WIJK", 4, 165973},
	{"WIIW", 4, 134728},
	{"WIIV", 4, 174662},
	{"WIIR", 4, 141530},
	{"WIIP", 4, 182169},
	{"WIIM", 4, 146824},
	{"WIIF", 4, 153648},
	{"WIID", 4, 255985},
	{"WIIC", 4, 164080},
	{"WIIB", 4, 177480},
	{"WIHTE", 5, 253334},
	{"WIGWAM", 6, 90562},
	{"WIGW", 4, 132537},
	{"WIGV", 4, 178048},
	{"WIGU", 4, 250786},
	{"WIGTOWNSHIRE", 12, 140195},
	{"WIGTOWN", 7, 223697},
	{"WIGTON", 6, 157098},
	{"WIGT", 4, 163510},
	{"WIGSTON", 7, 152685},
	{"WIGS", 4, 44680},
	{"WIGRAM", 6, 240130},
	{"WIGR", 4, 211069},
	{"WIGO", 4, 204982},
	{"WIGNER", 6, 124784},
	{"WIGNALL", 7, 239464},
	{"WIGN", 4, 165816},
	{"WIGMORE", 7, 125776},
	{"WIGM", 4, 179447},
	{"WIGLEY", 6, 148660},
	{"WIGL", 4, 190771},
	{"WIGI", 4, 153075},
	{"WIGHTMAN", 8, 142696},
	{"WIGHT", 5, 46998},
	{"WIGHNOMY", 8, 193757},
	{"WIGH", 4, 57103},
	{"WIGGY", 5, 201358},
	{"WIGGUM", 6, 181327},
	{"WIGGS", 5, 218854},
	{"WIGGLY", 6, 114900},
	{"WIGGLING", 8, 143930},
	{"WIGGLESWORTH", 12, 201049},
	{"WIGGLES", 7, 75110},
	{"WIGGLERS", 8, 255017},
	{"WIGGLER", 7, 171050},
	{"WIGGLED", 7, 171442},
	{"WIGGLE", 6, 72775},
	{"WIGGINTON", 9, 147217},
	{"WIGGINS", 7, 68070},
	{"WIGGIN", 6, 128444},
	{"WIGGERS", 7, 231947},
	{"WIGGER", 6, 242417},
	{"WIGF", 4, 220801},
	{"WIGET", 5, 249353},
	{"WIGEON", 6, 166675},
	{"WIGE", 4, 156891},
	{"WIGDERSON", 9, 242585},
	{"WIGB", 4, 214032},
	{"WIGAND", 6, 221490},
	{"WIGAN", 5, 51432},
	{"WIGA", 4, 75438},
	{"WIFY", 4, 89331},
	{"WIFW", 4, 117799},
	{"WIFT", 4, 45187},
	{"WIFS", 4, 141849},
	{"WIFR", 4, 215458},
	{"WIFN", 4, 257391},
	{"WIFM", 4, 210676},
	{"WIFLYER", 7, 244255},
	{"WIFI", 4, 32356},
	{"WIFH", 4, 106213},
	{"WIFFLE", 6, 242091},
	{"WIFEY", 5, 122527},
	{"WIFES", 5, 76830},
	{"WIFELOVERS", 10, 224348},
	{"WIFE", 4, 1641},
	{"WIFA", 4, 96391},
	{"WIEW", 4, 164736},
	{"WIETSE", 6, 131366},
	{"WIEST", 5, 173852},
	{"WIESNER", 7, 143437},
	{"WIESER", 6, 207785},
	{"WIESENTHAL", 10, 133296},
	{"WIESEL", 6, 108141},
	{"WIESE", 5, 124008},
	{"WIESBADEN", 9, 87716},
	{"WIERSMA", 7, 225269},
	{"WIERDO", 6, 216195},
	{"WIERDNESS", 9, 210428},
	{"WIERD", 5, 66901},
	{"WIER", 4, 157547},
	{"WIENS", 5, 152965},
	{"WIENONLINE", 10, 196105},
	{"WIENERS", 7, 223423},
	{"WIENER", 6, 63889},
	{"WIELKIE", 7, 130501},
	{"WIELKANOC", 9, 256608},
	{"WIELKA", 6, 251042},
	{"WIELE", 5, 185414},
	{"WIELDS", 6, 134997},
	{"WIELDING", 8, 79729},
	{"WIELDER", 7, 182141},
	{"WIELDED", 7, 110998},
	{"WIELD", 5, 86298},
	{"WIELAND", 7, 113655},
	{"WIELAARD", 8, 195769},
	{"WIEL", 4, 252264},
	{"WIEK", 4, 195839},
	{"WIEGHT", 6, 161898},
	{"WIEGAND", 7, 134068},
	{"WIEG", 4, 160731},
	{"WIEERS", 6, 135182},
	{"WIEDMANN", 8, 251117},
	{"WIEDERSEHEN", 11, 198049},
	{"WIEDERHOLD", 10, 237754},
	{"WIEDER", 6, 72741},
	{"WIEDEMANN", 9, 160946},
	{"WIECZOREK", 9, 228310},
	{"WIECK", 5, 154216},
	{"WIEC", 4, 125846},
	{"WIEBETECH", 9, 173034},
	{"WIEBE", 5, 109643},
	{"WIEB", 4, 162126},
	{"WIDTHS", 6, 56203},
	{"WIDTH", 5, 4881},
	{"WIDT", 4, 50748},
	{"WIDOWS", 6, 62757},
	{"WIDOWMAKER", 10, 136103},
	{"WIDOWHOOD", 9, 171387},
	{"WIDOWERS", 8, 143058},
	{"WIDOWER", 7, 86970},
	{"WIDOWED", 7, 64552},
	{"WIDOW", 5, 35095},
	{"WIDOM", 5, 203015},
	{"WIDO", 4, 47899},
	{"WIDNES", 6, 113370},
	{"WIDN", 4, 181589},
	{"WIDMER", 6, 142283},
	{"WIDMARK", 7, 193010},
	{"WIDM", 4, 142336},
	{"WIDL", 4, 234569},
	{"WIDI", 4, 207074},
	{"WIDGETS", 7, 47786},
	{"WIDGET", 6, 39154},
	{"WIDGER", 6, 230271},
	{"WIDGEON", 7, 194000},
	{"WIDG", 4, 89784},
	{"WIDEST", 6, 50902},
	{"WIDESPREAD", 10, 28638},
	{"WIDESCREEN", 10, 30353},
	{"WIDES", 5, 220519},
	{"WIDER", 5, 30731},
	{"WIDEOUT", 7, 230433},
	{"WIDENS", 6, 94032},
	{"WIDENING", 8, 48309},
	{"WIDENER", 7, 94012},
	{"WIDENED", 7, 70672},
	{"WIDEN", 5, 58217},
	{"WIDEMAN", 7, 180408},
	{"WIDELY", 6, 6761},
	{"WIDEFIELD", 9, 228451},
	{"WIDEBODY", 8, 219699},
	{"WIDEBAND", 8, 72823},
	{"WIDEANGLE", 9, 258721},
	{"WIDE", 4, 2888},
	{"WIDDOWSON", 9, 249390},
	{"WIDDECOMBE", 10, 213676},
	{"WIDD", 4, 131848},
	{"WIDCTLPAR", 9, 93947},
	{"WIDA", 4, 219500},
	{"WID", 3, 264},
	{"WICZ", 4, 68998},
	{"WICTIONARY", 10, 203225},
	{"WICOMICO", 8, 119285},
	{"WICKSTROM", 9, 255892},
	{"WICKS", 5, 71845},
	{"WICKREMESINGHE", 14, 259192},
	{"WICKRAMASINGHE", 14, 251552},
	{"WICKMAN", 7, 183364},
	{"WICKLOW", 7, 67297},
	{"WICKLIFFE", 9, 138018},
	{"WICKING", 7, 92754},
	{"WICKHAM", 7, 82505},
	{"WICKFORD", 8, 130158},
	{"WICKETT", 7, 220660},
	{"WICKETS", 7, 72811},
	{"WICKETKEEPER", 12, 241085},
	{"WICKET", 6, 63377},
	{"WICKES", 6, 115762},
	{"WICKERSHAM", 10, 175611},
	{"WICKERS", 7, 203550},
	{"WICKER", 6, 49642},
	{"WICKENS", 7, 181683},
	{"WICKENBURG", 10, 142079},
	{"WICKEDNESS", 10, 80007},
	{"WICKEDLY", 8, 110571},
	{"WICKED", 6, 33438},
	{"WICK", 4, 57417},
	{"WICIPEDIA", 9, 191456},
	{"WICHTIGE", 8, 218537},
	{"WICHTIG", 7, 163614},
	{"WICHSVORLAGEN", 13, 158347},
	{"WICHSVORLAGE", 12, 158762},
	{"WICHSTE", 7, 158895},
	{"WICHSEN", 7, 257106},
	{"WICHSE", 6, 218703},
	{"WICHMANN", 8, 168390},
	{"WICHITA", 7, 31708},
	{"WICHERT", 7, 147916},
	{"WICHARD", 7, 166691},
	{"WICH", 4, 72494},
	{"WICCANS", 7, 134017},
	{"WICCAN", 6, 68475},
	{"WICCA", 5, 60714},
	{"WICB", 4, 238868},
	{"WICA", 4, 87895},
	{"WIBRO", 5, 249510},
	{"WIBERG", 6, 237512},
	{"WIBE", 4, 164081},
	{"WIBC", 4, 242660},
	{"WIBBLE", 6, 163454},
	{"WIBAUX", 6, 222142},
	{"WIBA", 4, 250816},
	{"WIARTON", 7, 222329},
	{"WIAR", 4, 200910},
	{"WIAM", 4, 96230},
	{"WIAL", 4, 226496},
	{"WIAK", 4, 193938},
	{"WIADOMO", 7, 254464},
	{"WIAC", 4, 175604},
	{"WHYY", 4, 215416},
	{"WHYW", 4, 41578},
	{"WHYV", 4, 172061},
	{"WHYU", 4, 160332},
	{"WHYTELEAFE", 10, 246172},
	{"WHYTE", 5, 76924},
	{"WHYT", 4, 35004},
	{"WHYS", 4, 132921},
	{"WHYR", 4, 103979},
	{"WHYP", 4, 67997},
	{"WHYO", 4, 79095},
	{"WHYNOT", 6, 257605},
	{"WHYN", 4, 49357},
	{"WHYM", 4, 67230},
	{"WHYL", 4, 109796},
	{"WHYK", 4, 154381},
	{"WHYJ", 4, 133952},
	{"WHYI", 4, 37579},
	{"WHYH", 4, 44636},
	{"WHYG", 4, 98574},
	{"WHYF", 4, 104307},
	{"WHYE", 4, 88287},
	{"WHYD", 4, 37869},
	{"WHYC", 4, 59874},
	{"WHYB", 4, 73419},
	{"WHYALLA", 7, 112163},
	{"WHYA", 4, 45257},
	{"WHY", 3, 978},
	{"WHUT", 4, 168483},
	{"WHUS", 4, 149119},
	{"WHUR", 4, 145959},
	{"WHUP", 4, 234670},
	{"WHUN", 4, 69107},
	{"WHUM", 4, 102234},
	{"WHUG", 4, 173825},
	{"WHTTP", 5, 227047},
	{"WHTIE", 5, 256315},
	{"WHSMITHS", 8, 183914},
	{"WHSMITH", 7, 92103},
	{"WHSLE", 5, 62383},
	{"WHQL", 4, 142166},
	{"WHOY", 4, 67616},
	{"WHOV", 4, 50618},
	{"WHOULD", 6, 211907},
	{"WHOU", 4, 38892},
	{"WHOTOWN", 7, 113642},
	{"WHOTEL", 6, 164145},
	{"WHOT", 4, 28519},
	{"WHOSOEVER", 9, 86853},
	{"WHOSO", 5, 154151},
	{"WHOSE", 5, 1772},
	{"WHORLS", 6, 186183},
	{"WHORLED", 7, 250297},
	{"WHORL", 5, 108352},
	{"WHORING", 7, 135544},
	{"WHORF", 5, 229954},
	{"WHORES", 6, 49234},
	{"WHOREHOUSE", 10, 173470},
	{"WHORE", 5, 36314},
	{"WHOR", 4, 29911},
	{"WHOQ", 4, 90477},
	{"WHOPPING", 8, 74738},
	{"WHOPPERS", 8, 154871},
	{"WHOPPER", 7, 127180},
	{"WHOOZIT", 7, 222906},
	{"WHOOSHING", 9, 251103},
	{"WHOOSH", 6, 140605},
	{"WHOOPS", 6, 79219},
	{"WHOOPING", 8, 85730},
	{"WHOOPIE", 7, 205234},
	{"WHOOPI", 6, 104783},
	{"WHOOPEE", 7, 145401},
	{"WHOOPED", 7, 219484},
	{"WHOOP", 5, 94898},
	{"WHOOO", 5, 210991},
	{"WHOMSOEVER", 10, 118297},
	{"WHOMEVER", 8, 69165},
	{"WHOME", 5, 164401},
	{"WHOM", 4, 3131},
	{"WHOLSALE", 8, 238016},
	{"WHOLLY", 6, 37797},
	{"WHOLISTIC", 9, 157282},
	{"WHOLEVIEW", 9, 234660},
	{"WHOLESOMENESS", 13, 207416},
	{"WHOLESOME", 9, 67095},
	{"WHOLESALING", 11, 106014},
	{"WHOLESALES", 10, 139335},
	{"WHOLESALERS", 11, 40130},
	{"WHOLESALER", 10, 49939},
	{"WHOLESALEHUNTER", 15, 213533},
	{"WHOLESALE", 9, 3636},
	{"WHOLESAL", 8, 260996},
	{"WHOLES", 6, 148943},
	{"WHOLENESS", 9, 88019},
	{"WHOLEMEAL", 9, 180983},
	{"WHOLEHEARTEDLY", 14, 83929},
	{"WHOLEHEARTED", 12, 182924},
	{"WHOLEGRAIN", 10, 240642},
	{"WHOLEFOOD", 9, 223614},
	{"WHOLE", 5, 1637},
	{"WHOL", 4, 99552},
	{"WHOK", 4, 42304},
	{"WHOJ", 4, 60181},
	{"WHOIS", 5, 38783},
	{"WHOH", 4, 3740},
	{"WHOG", 4, 38476},
	{"WHOF", 4, 35393},
	{"WHOEVER", 7, 32933},
	{"WHODUNNIT", 9, 209752},
	{"WHODUNIT", 8, 133551},
	{"WHOC", 4, 7524},
	{"WHOB", 4, 35182},
	{"WHOAMI", 6, 185478},
	{"WHOAH", 5, 201702},
	{"WHO'VE", 6, 687},
	{"WHO'S", 5, 684},
	{"WHO'RE", 6, 686},
	{"WHO'LL", 6, 685},
	{"WHO", 3, 736},
	{"WHMIS", 5, 144654},
	{"WHLTE", 5, 235657},
	{"WHIZZING", 8, 176284},
	{"WHIZZES", 7, 206889},
	{"WHIZZER", 7, 216973},
	{"WHIZZED", 7, 218831},
	{"WHIZZ", 5, 149406},
	{"WHIZLABS", 8, 173704},
	{"WHIZ", 4, 76378},
	{"WHITWORTH", 9, 88372},
	{"WHITWELL", 8, 168327},
	{"WHITW", 5, 257914},
	{"WHITTY", 6, 162551},
	{"WHITTON", 7, 140030},
	{"WHITTLING", 9, 203895},
	{"WHITTLESEY", 10, 181330},
	{"WHITTLESEA", 10, 186542},
	{"WHITTLED", 8, 162401},
	{"WHITTLE", 7, 82758},
	{"WHITTINGTON", 11, 89236},
	{"WHITTINGHAM", 11, 175891},
	{"WHITTIER", 8, 61865},
	{"WHITTEN", 7, 100331},
	{"WHITTEMORE", 10, 125807},
	{"WHITTED", 7, 254451},
	{"WHITTAM", 7, 201023},
	{"WHITTAKER", 9, 75858},
	{"WHITT", 5, 131610},
	{"WHITSUNDAYS", 11, 114768},
	{"WHITSUNDAY", 10, 107330},
	{"WHITSTABLE", 10, 130461},
	{"WHITSON", 7, 147144},
	{"WHITSETT", 8, 195556},
	{"WHITS", 5, 261441},
	{"WHITNEY", 7, 37830},
	{"WHITMORE", 8, 79770},
	{"WHITMIRE", 8, 124053},
	{"WHITMER", 7, 174614},
	{"WHITMARSH", 9, 254545},
	{"WHITMAN", 7, 44746},
	{"WHITLOW", 7, 164332},
	{"WHITLOCK", 8, 86453},
	{"WHITLEY", 7, 63288},
	{"WHITLAM", 7, 135120},
	{"WHITISH", 7, 117789},
	{"WHITINSVILLE", 12, 223583},
	{"WHITING", 7, 60818},
	{"WHITIANGA", 9, 203226},
	{"WHITHER", 7, 76805},
	{"WHITHAM", 7, 206514},
	{"WHITH", 5, 141815},
	{"WHITFORD", 8, 114263},
	{"WHITFIELD", 9, 66419},
	{"WHITEY", 6, 93491},
	{"WHITEWOOD", 9, 142272},
	{"WHITEWOLF", 9, 255450},
	{"WHITEWATER", 10, 49008},
	{"WHITEWASHING", 12, 232301},
	{"WHITEWASHED", 11, 133098},
	{"WHITEWASH", 9, 111373},
	{"WHITEVILLE", 10, 151198},
	{"WHITETOP", 8, 213383},
	{"WHITETHORN", 10, 253367},
	{"WHITETAILS", 10, 180345},
	{"WHITETAIL", 9, 80348},
	{"WHITESVILLE", 11, 199311},
	{"WHITESTRIPS", 11, 197066},
	{"WHITESTOWN", 10, 261449},
	{"WHITESTONE", 10, 127477},
	{"WHITEST", 7, 197003},
	{"WHITESPACES", 11, 255756},
	{"WHITESPACE", 10, 59651},
	{"WHITESNAKE", 10, 105876},
	{"WHITESIDES", 10, 211521},
	{"WHITESIDE", 9, 86205},
	{"WHITESELL", 9, 213775},
	{"WHITESBURG", 10, 161824},
	{"WHITESBORO", 10, 141472},
	{"WHITES", 6, 39907},
	{"WHITER", 6, 102010},
	{"WHITEPAPERS", 11, 62529},
	{"WHITEPAPER", 10, 60653},
	{"WHITEPAGES", 10, 102990},
	{"WHITEOUT", 8, 170127},
	{"WHITENING", 9, 54374},
	{"WHITENESS", 9, 97939},
	{"WHITENER", 8, 135371},
	{"WHITENED", 8, 205059},
	{"WHITEN", 6, 156305},
	{"WHITEMARSH", 10, 261845},
	{"WHITEMAN", 8, 98792},
	{"WHITELY", 7, 240962},
	{"WHITELIST", 9, 116997},
	{"WHITELEY", 8, 106899},
	{"WHITELAW", 8, 134868},
	{"WHITELAND", 9, 197173},
	{"WHITEHURST", 10, 134802},
	{"WHITEHOUSE", 10, 69013},
	{"WHITEHORSE", 10, 79659},
	{"WHITEHORN", 9, 228940},
	{"WHITEHILL", 9, 163535},
	{"WHITEHEADS", 10, 232192},
	{"WHITEHEAD", 9, 56389},
	{"WHITEHAVEN", 10, 95916},
	{"WHITEHAUS", 9, 198048},
	{"WHITEHALL", 9, 58690},
	{"WHITEGOODS", 10, 202446},
	{"WHITEFRIARS", 11, 187012},
	{"WHITEFORD", 9, 166584},
	{"WHITEFLY", 8, 171171},
	{"WHITEFLIES", 10, 198381},
	{"WHITEFISH", 9, 76388},
	{"WHITEFIELD", 10, 103523},
	{"WHITEFACE", 9, 148214},
	{"WHITEELO", 8, 165532},
	{"WHITED", 6, 156513},
	{"WHITECROSS", 10, 236254},
	{"WHITECOURT", 10, 142930},
	{"WHITECHAPEL", 11, 109958},
	{"WHITECAPS", 9, 179379},
	{"WHITECAP", 8, 232801},
	{"WHITEBOX", 8, 144495},
	{"WHITEBOARDS", 11, 92839},
	{"WHITEBOARD", 10, 62793},
	{"WHITEBLAZE", 10, 234969},
	{"WHITEBEAR", 9, 145195},
	{"WHITEBALANCE", 12, 175792},
	{"WHITE", 5, 1278},
	{"WHITCOMB", 8, 110094},
	{"WHITCHURCH", 10, 100288},
	{"WHITBY", 6, 65564},
	{"WHITBURN", 8, 182100},
	{"WHITBREAD", 9, 100778},
	{"WHITBOURNE", 10, 228370},
	{"WHITAKERS", 9, 228012},
	{"WHITAKER", 8, 59407},
	{"WHITACRE", 8, 166676},
	{"WHISTON", 7, 195646},
	{"WHISTLING", 9, 74175},
	{"WHISTLES", 8, 63101},
	{"WHISTLERS", 9, 258389},
	{"WHISTLER", 8, 41398},
	{"WHISTLED", 8, 123228},
	{"WHISTLEBLOWING", 14, 161961},
	{"WHISTLEBLOWERS", 14, 118713},
	{"WHISTLEBLOWER", 13, 82550},
	{"WHISTLE", 7, 44443},
	{"WHIST", 5, 127728},
	{"WHISPERS", 8, 58579},
	{"WHISPERINGS", 11, 249236},
	{"WHISPERING", 10, 61258},
	{"WHISPERER", 9, 112548},
	{"WHISPERED", 9, 50962},
	{"WHISPER", 7, 7015},
	{"WHISKY", 6, 51355},
	{"WHISKS", 6, 160596},
	{"WHISKING", 8, 177246},
	{"WHISKIES", 8, 119485},
	{"WHISKEYTOWN", 11, 166980},
	{"WHISKEY", 7, 47284},
	{"WHISKERS", 8, 86153},
	{"WHISKERED", 9, 203478},
	{"WHISKER", 7, 107212},
	{"WHISKED", 7, 116511},
	{"WHISKAS", 7, 233778},
	{"WHISK", 5, 75415},
	{"WHISH", 5, 208019},
	{"WHIRRING", 8, 175655},
	{"WHIRPOOL", 8, 255516},
	{"WHIRLY", 6, 236007},
	{"WHIRLWINDS", 10, 260754},
	{"WHIRLWIND", 9, 68014},
	{"WHIRLS", 6, 191343},
	{"WHIRLPOOLS", 10, 101997},
	{"WHIRLPOOL", 9, 38481},
	{"WHIRLING", 8, 94768},
	{"WHIRLIGIG", 9, 210548},
	{"WHIRLED", 7, 119813},
	{"WHIRL", 5, 73865},
	{"WHIR", 4, 158272},
	{"WHIPTAIL", 8, 166925},
	{"WHIPS", 5, 64572},
	{"WHIPPOORWILL", 12, 255895},
	{"WHIPPLE", 7, 79470},
	{"WHIPPING", 8, 52124},
	{"WHIPPETS", 8, 204631},
	{"WHIPPET", 7, 112959},
	{"WHIPPER", 7, 172536},
	{"WHIPPEDASS", 10, 192251},
	{"WHIPPED", 7, 49478},
	{"WHIPPANY", 8, 157308},
	{"WHIPP", 5, 255370},
	{"WHIPLASH", 8, 72770},
	{"WHIPING", 7, 201263},
	{"WHIPED", 6, 260334},
	{"WHIP", 4, 32923},
	{"WHINY", 5, 111448},
	{"WHINING", 7, 62030},
	{"WHINGING", 8, 176710},
	{"WHINGER", 7, 260422},
	{"WHINGE", 6, 184874},
	{"WHINEY", 6, 162573},
	{"WHINES", 6, 138741},
	{"WHINERS", 7, 150987},
	{"WHINER", 6, 167990},
	{"WHINED", 6, 136445},
	{"WHINE", 5, 66077},
	{"WHIMSY", 6, 91763},
	{"WHIMSIES", 8, 227555},
	{"WHIMSICALLY", 11, 241123},
	{"WHIMSICAL", 9, 63773},
	{"WHIMS", 5, 93081},
	{"WHIMPERS", 8, 241142},
	{"WHIMPERING", 10, 157154},
	{"WHIMPERED", 9, 158557},
	{"WHIMPER", 7, 118295},
	{"WHIM", 4, 72353},
	{"WHILST", 6, 29159},
	{"WHILEY", 6, 247609},
	{"WHILES", 6, 157836},
	{"WHILE", 5, 980},
	{"WHIL", 4, 242595},
	{"WHIGS", 5, 127607},
	{"WHIGHAM", 7, 229205},
	{"WHIG", 4, 98765},
	{"WHIFF", 5, 107302},
	{"WHIF", 4, 116913},
	{"WHIDDEN", 7, 234436},
	{"WHIDBEY", 7, 84672},
	{"WHID", 4, 119676},
	{"WHICHEVER", 9, 41567},
	{"WHICHE", 6, 160275},
	{"WHICH", 5, 771},
	{"WHIC", 4, 150264},
	{"WHEY", 4, 52379},
	{"WHEW", 4, 77850},
	{"WHEU", 4, 235776},
	{"WHETTED", 7, 227998},
	{"WHETSTONE", 9, 104645},
	{"WHETHER", 7, 1308},
	{"WHERRY", 6, 193421},
	{"WHEREWITHAL", 11, 137433},
	{"WHEREWITH", 9, 116559},
	{"WHEREVER", 8, 31001},
	{"WHEREUPON", 9, 73923},
	{"WHEREUNTO", 9, 232582},
	{"WHERES", 6, 104815},
	{"WHEREON", 7, 143177},
	{"WHEREOF", 7, 76182},
	{"WHEREIS", 7, 215366},
	{"WHEREIN", 7, 38007},
	{"WHEREHOUSE", 10, 240133},
	{"WHEREFORE", 9, 67207},
	{"WHEREEVER", 9, 155331},
	{"WHEREBY", 7, 40038},
	{"WHEREAT", 7, 229693},
	{"WHEREAS", 7, 8279},
	{"WHEREAMI", 8, 201836},
	{"WHEREAFTER", 10, 186083},
	{"WHEREABOUTS", 11, 67160},
	{"WHERE'S", 7, 683},
	{"WHERE", 5, 1013},
	{"WHER", 4, 138053},
	{"WHEP", 4, 127452},
	{"WHENUA", 6, 162015},
	{"WHENU", 5, 231522},
	{"WHENS", 5, 223220},
	{"WHENEVER", 8, 7374},
	{"WHENCE", 6, 58012},
	{"WHEN", 4, 618},
	{"WHEM", 4, 114431},
	{"WHELPING", 8, 163920},
	{"WHELP", 5, 185936},
	{"WHELMING", 8, 235293},
	{"WHELK", 5, 260510},
	{"WHELEN", 6, 167318},
	{"WHELDON", 7, 156676},
	{"WHELAN", 6, 73904},
	{"WHEL", 4, 39254},
	{"WHEK", 4, 188706},
	{"WHEJ", 4, 251778},
	{"WHEG", 4, 119495},
	{"WHEF", 4, 109560},
	{"WHEEZY", 6, 238937},
	{"WHEEZING", 8, 93832},
	{"WHEEZE", 6, 155015},
	{"WHEELY", 6, 254726},
	{"WHEELWRIGHT", 11, 144453},
	{"WHEELSKINS", 10, 172147},
	{"WHEELSETS", 9, 172751},
	{"WHEELSET", 8, 168115},
	{"WHEELS", 6, 6247},
	{"WHEELOCK", 8, 106032},
	{"WHEELMEN", 8, 244063},
	{"WHEELINPUTCURRENT", 17, 260025},
	{"WHEELING", 8, 55175},
	{"WHEELIN", 7, 216608},
	{"WHEELIES", 8, 173217},
	{"WHEELIE", 7, 109903},
	{"WHEELHOUSE", 10, 158324},
	{"WHEELERSBURG", 12, 242534},
	{"WHEELERS", 8, 86058},
	{"WHEELER", 7, 39371},
	{"WHEELED", 7, 51800},
	{"WHEELCHAIRS", 11, 56567},
	{"WHEELCHAIR", 10, 34195},
	{"WHEELBASE", 9, 79240},
	{"WHEELBARROWS", 12, 164922},
	{"WHEELBARROW", 11, 110932},
	{"WHEEL", 5, 6035},
	{"WHEEE", 5, 219936},
	{"WHEDONESQUE", 11, 178738},
	{"WHEDON", 6, 84998},
	{"WHED", 4, 77647},
	{"WHEB", 4, 134229},
	{"WHEATUS", 7, 124002},
	{"WHEATSTONE", 10, 194763},
	{"WHEATSHEAF", 10, 177464},
	{"WHEATS", 6, 183412},
	{"WHEATON", 7, 50322},
	{"WHEATLEY", 8, 75549},
	{"WHEATLAND", 9, 92601},
	{"WHEATIES", 8, 155549},
	{"WHEATHER", 8, 203234},
	{"WHEATGRASS", 10, 116128},
	{"WHEATFIELD", 10, 160214},
	{"WHEATEN", 7, 135925},
	{"WHEATEAR", 8, 201219},
	{"WHEATCROFT", 10, 222157},
	{"WHEATBELT", 9, 183554},
	{"WHEAT", 5, 34052},
	{"WHEAL", 5, 209337},
	{"WHDH", 4, 200825},
	{"WHCIH", 5, 236144},
	{"WHAY", 4, 241168},
	{"WHAX", 4, 241364},
	{"WHAW", 4, 160333},
	{"WHAV", 4, 46295},
	{"WHAU", 4, 220597},
	{"WHATWG", 6, 177871},
	{"WHATTHEFONT", 11, 120349},
	{"WHATTA", 6, 211763},
	{"WHATSUP", 7, 144166},
	{"WHATSONWHEN", 11, 162928},
	{"WHATSOEVER", 10, 37192},
	{"WHATSNEW", 8, 174899},
	{"WHATS", 5, 33491},
	{"WHATPC", 6, 225002},
	{"WHATNOT", 7, 87187},
	{"WHATMORE", 8, 224820},
	{"WHATMAN", 7, 173036},
	{"WHATLINKSHERE", 13, 240302},
	{"WHATLEY", 7, 136146},
	{"WHATIS", 6, 117058},
	{"WHATEVS", 7, 184708},
	{"WHATEVER", 8, 2442},
	{"WHATEVA", 7, 209656},
	{"WHATELY", 7, 177798},
	{"WHATCOUNTS", 10, 255073},
	{"WHATCOM", 7, 87494},
	{"WHATCHA", 7, 111975},
	{"WHAT'VE", 7, 682},
	{"WHAT'S", 6, 681},
	{"WHAT'RE", 7, 680},
	{"WHAT'LL", 7, 679},
	{"WHAT", 4, 617},
	{"WHASSUP", 7, 209727},
	{"WHARVES", 7, 136393},
	{"WHARTON", 7, 52669},
	{"WHARFEDALE", 10, 93494},
	{"WHARF", 5, 46726},
	{"WHARE", 5, 137210},
	{"WHAR", 4, 244683},
	{"WHANT", 5, 234150},
	{"WHANGAREI", 9, 92483},
	{"WHANGANUI", 9, 193917},
	{"WHANGAMATA", 10, 220155},
	{"WHANG", 5, 215693},
	{"WHANAU", 6, 149481},
	{"WHAMPOA", 7, 197867},
	{"WHAMMY", 6, 111954},
	{"WHAM", 4, 70005},
	{"WHALLEY", 7, 114509},
	{"WHALING", 7, 65050},
	{"WHALEY", 6, 95917},
	{"WHALETOWN", 9, 249599},
	{"WHALES", 6, 44150},
	{"WHALERS", 7, 114041},
	{"WHALER", 6, 98175},
	{"WHALEN", 6, 85655},
	{"WHALEBONE", 9, 256245},
	{"WHALE", 5, 31716},
	{"WHAKATANE", 9, 151989},
	{"WHAKAPAPA", 9, 217804},
	{"WHAK", 4, 221695},
	{"WHADDYA", 7, 159111},
	{"WHADDAYA", 8, 249670},
	{"WHAD", 4, 59618},
	{"WHACKY", 6, 159976},
	{"WHACKS", 6, 193422},
	{"WHACKO", 6, 226877},
	{"WHACKING", 8, 126627},
	{"WHACKER", 7, 225456},
	{"WHACKED", 7, 104044},
	{"WHACK", 5, 69612},
	{"WHAC", 4, 249237},
	{"WHABAM", 6, 232527},
	{"WHAB", 4, 226718},
	{"WGZ", 3, 129034},
	{"WGYM", 4, 207356},
	{"WGY", 3, 43398},
	{"WGX", 3, 141797},
	{"WGV", 3, 92782},
	{"WGUY", 4, 109685},
	{"WGUN", 4, 153916},
	{"WGUI", 4, 75372},
	{"WGUE", 4, 177713},
	{"WGUA", 4, 153393},
	{"WGU", 3, 228105},
	{"WGTD", 4, 143518},
	{"WGRO", 4, 58813},
	{"WGRI", 4, 136415},
	{"WGRE", 4, 65617},
	{"WGRA", 4, 63184},
	{"WGR", 3, 219476},
	{"WGP", 3, 178618},
	{"WGOV", 4, 67787},
	{"WGOT", 4, 108664},
	{"WGOR", 4, 179773},
	{"WGOO", 4, 61126},
	{"WGON", 4, 139736},
	{"WGOL", 4, 106909},
	{"WGOI", 4, 110228},
	{"WGOE", 4, 136778},
	{"WGOD", 4, 123208},
	{"WGOA", 4, 144687},
	{"WGNSAT", 6, 251043},
	{"WGM", 3, 199431},
	{"WGLO", 4, 116663},
	{"WGLI", 4, 166218},
	{"WGLE", 4, 196295},
	{"WGLA", 4, 126314},
	{"WGL", 3, 236285},
	{"WGK", 3, 229124},
	{"WGJ", 3, 140084},
	{"WGIV", 4, 97566},
	{"WGIR", 4, 94543},
	{"WGIL", 4, 174347},
	{"WGIG", 4, 220493},
	{"WGIA", 4, 253885},
	{"WGHE", 4, 258891},
	{"WGG", 3, 64677},
	{"WGET", 4, 76613},
	{"WGER", 4, 114287},
	{"WGEO", 4, 125847},
	{"WGEN", 4, 59099},
	{"WGEA", 4, 202209},
	{"WGD", 3, 62291},
	{"WGC", 3, 157656},
	{"WGBH", 4, 76890},
	{"WGAY", 4, 214814},
	{"WGAV", 4, 170607},
	{"WGAU", 4, 125788},
	{"WGAT", 4, 140813},
	{"WGAS", 4, 159339},
	{"WGAR", 4, 102981},
	{"WGAN", 4, 171390},
	{"WGAM", 4, 71445},
	{"WGAI", 4, 162385},
	{"WFZ", 3, 157881},
	{"WFY", 3, 98184},
	{"WFX", 3, 71821},
	{"WFV", 3, 110047},
	{"WFUV", 4, 235416},
	{"WFUT", 4, 183011},
	{"WFUR", 4, 130923},
	{"WFUN", 4, 88561},
	{"WFUL", 4, 44258},
	{"WFUE", 4, 181955},
	{"WFU", 3, 155090},
	{"WFTV", 4, 215084},
	{"WFTU", 4, 246798},
	{"WFTC", 4, 252593},
	{"WFRU", 4, 167061},
	{"WFRO", 4, 39981},
	{"WFRI", 4, 71950},
	{"WFRE", 4, 65622},
	{"WFRA", 4, 81295},
	{"WFR", 3, 256862},
	{"WFQ", 3, 223396},
	{"WFP", 3, 67511},
	{"WFOX", 4, 182393},
	{"WFOU", 4, 51330},
	{"WFORMAT", 7, 143299},
	{"WFOR", 4, 215441},
	{"WFOO", 4, 80252},
	{"WFON", 4, 225986},
	{"WFOL", 4, 95208},
	{"WFOC", 4, 119085},
	{"WFMY", 4, 258501},
	{"WFMU", 4, 114299},
	{"WFMC", 4, 258301},
	{"WFM", 3, 156287},
	{"WFLY", 4, 140104},
	{"WFLU", 4, 168887},
	{"WFLO", 4, 85806},
	{"WFLI", 4, 118116},
	{"WFLE", 4, 138208},
	{"WFLA", 4, 213075},
	{"WFL", 3, 205280},
	{"WFK", 3, 114469},
	{"WFJ", 3, 112914},
	{"WFIX", 4, 225792},
	{"WFIV", 4, 123627},
	{"WFIT", 4, 135631},
	{"WFIS", 4, 91116},
	{"WFIR", 4, 53882},
	{"WFIN", 4, 65806},
	{"WFIL", 4, 83940},
	{"WFIG", 4, 106362},
	{"WFIF", 4, 253175},
	{"WFG", 3, 261644},
	{"WFF", 3, 130178},
	{"WFEW", 4, 161680},
	{"WFEV", 4, 176654},
	{"WFES", 4, 200911},
	{"WFER", 4, 148385},
	{"WFEN", 4, 237971},
	{"WFEM", 4, 166456},
	{"WFEL", 4, 114117},
	{"WFEE", 4, 80554},
	{"WFED", 4, 115127},
	{"WFEA", 4, 64235},
	{"WFD", 3, 124424},
	{"WFCH", 4, 232950},
	{"WFC", 3, 91103},
	{"WFB", 3, 218999},
	{"WFAV", 4, 151467},
	{"WFAT", 4, 119572},
	{"WFAS", 4, 82176},
	{"WFAR", 4, 60292},
	{"WFAM", 4, 80972},
	{"WFALL", 5, 175885},
	{"WFAL", 4, 78029},
	{"WFAI", 4, 108709},
	{"WFAC", 4, 55651},
	{"WFAA", 4, 133999},
	{"WEYW", 4, 218168},
	{"WEYS", 4, 173338},
	{"WEYRICH", 7, 174989},
	{"WEYR", 4, 195235},
	{"WEYO", 4, 177481},
	{"WEYMOUTH", 8, 50847},
	{"WEYM", 4, 106863},
	{"WEYLAND", 7, 246147},
	{"WEYL", 4, 112617},
	{"WEYI", 4, 260850},
	{"WEYH", 4, 256659},
	{"WEYERS", 6, 228891},
	{"WEYERHAEUSER", 12, 103144},
	{"WEYER", 5, 181096},
	{"WEYE", 4, 114209},
	{"WEYD", 4, 226233},
	{"WEYBURN", 7, 120762},
	{"WEYBRIDGE", 9, 93299},
	{"WEYB", 4, 185482},
	{"WEYA", 4, 146229},
	{"WEXT", 4, 82945},
	{"WEXP", 4, 61995},
	{"WEXO", 4, 257492},
	{"WEXNER", 6, 228758},
	{"WEXLER", 6, 100521},
	{"WEXL", 4, 182271},
	{"WEXI", 4, 123231},
	{"WEXH", 4, 156319},
	{"WEXFORD", 7, 59767},
	{"WEXF", 4, 124530},
	{"WEXE", 4, 118250},
	{"WEXC", 4, 80926},
	{"WEXA", 4, 68604},
	{"WEWR", 4, 118440},
	{"WEWOKA", 6, 249657},
	{"WEWO", 4, 36585},
	{"WEWI", 4, 33105},
	{"WEWH", 4, 111367},
	{"WEWE", 4, 9948},
	{"WEVO", 4, 184953},
	{"WEVI", 4, 89606},
	{"WEVER", 5, 201292},
	{"WEVE", 4, 114685},
	{"WEUS", 4, 58412},
	{"WEUR", 4, 117350},
	{"WEUN", 4, 86457},
	{"WETZEL", 6, 93352},
	{"WETZ", 4, 157728},
	{"WETY", 4, 213612},
	{"WETW", 4, 108776},
	{"WETUMPKA", 8, 180356},
	{"WETU", 4, 109797},
	{"WETTON", 6, 193510},
	{"WETTING", 7, 70102},
	{"WETTEST", 7, 137001},
	{"WETTERLING", 10, 191830},
	{"WETTER", 6, 86319},
	{"WETTEN", 6, 172721},
	{"WETTED", 6, 117679},
	{"WETTBEWERB", 10, 259396},
	{"WETTABLE", 8, 255565},
	{"WETTABILITY", 11, 241796},
	{"WETSUITS", 8, 65385},
	{"WETSUIT", 7, 76192},
	{"WETR", 4, 53389},
	{"WETPIXEL", 8, 244612},
	{"WETP", 4, 176127},
	{"WETNESS", 7, 101098},
	{"WETMORE", 7, 118653},
	{"WETM", 4, 151946},
	{"WETLANDS", 8, 36788},
	{"WETLAND", 7, 42227},
	{"WETL", 4, 69129},
	{"WETHERSFIELD", 12, 109959},
	{"WETHERILL", 9, 182749},
	{"WETHERELL", 9, 186944},
	{"WETHERBY", 8, 103798},
	{"WETHER", 6, 88930},
	{"WETG", 4, 246933},
	{"WETFEET", 7, 216572},
	{"WETF", 4, 160485},
	{"WETENSCHAPPEN", 13, 128382},
	{"WETENSCHAPPELIJK", 16, 236499},
	{"WETENSCHAP", 10, 130021},
	{"WETEN", 5, 172643},
	{"WETD", 4, 170984},
	{"WETCANVAS", 9, 171329},
	{"WETC", 4, 116515},
	{"WETB", 4, 150484},
	{"WETASKIWIN", 10, 132819},
	{"WESW", 4, 93702},
	{"WESU", 4, 71359},
	{"WESTY", 5, 137580},
	{"WESTWORLD", 9, 198596},
	{"WESTWORD", 8, 133950},
	{"WESTWOOD", 8, 44946},
	{"WESTWIND", 8, 150149},
	{"WESTWEGO", 8, 197940},
	{"WESTWAY", 7, 199993},
	{"WESTWATER", 9, 260617},
	{"WESTWARDS", 9, 163711},
	{"WESTWARD", 8, 60974},
	{"WESTVILLE", 9, 100863},
	{"WESTVIEW", 8, 85768},
	{"WESTTOWN", 8, 210282},
	{"WESTSOUND", 9, 254793},
	{"WESTSIDE", 8, 62295},
	{"WESTSHORE", 9, 148008},
	{"WESTS", 5, 145614},
	{"WESTRIM", 7, 244453},
	{"WESTRIDGE", 9, 154996},
	{"WESTRAY", 7, 199755},
	{"WESTRA", 6, 229119},
	{"WESTPORT", 8, 51284},
	{"WESTPOINT", 9, 154671},
	{"WESTPHALIAN", 11, 237214},
	{"WESTPHALIA", 10, 97628},
	{"WESTPHAL", 8, 130289},
	{"WESTPARK", 8, 164557},
	{"WESTPAC", 7, 89063},
	{"WESTOVER", 8, 102026},
	{"WESTONS", 7, 114269},
	{"WESTON", 6, 40607},
	{"WESTNET", 7, 210157},
	{"WESTMOUNT", 9, 149904},
	{"WESTMORLAND", 11, 92915},
	{"WESTMORELAND", 12, 62381},
	{"WESTMORE", 8, 210258},
	{"WESTMONT", 8, 93682},
	{"WESTMINSTER", 11, 36110},
	{"WESTMINISTER", 12, 151270},
	{"WESTMEATH", 9, 78830},
	{"WESTMEAD", 8, 157287},
	{"WESTMARK", 8, 203728},
	{"WESTMAN", 7, 137872},
	{"WESTLY", 6, 220337},
	{"WESTLUND", 8, 260542},
	{"WESTLOCK", 8, 146712},
	{"WESTLIFE", 8, 48543},
	{"WESTLEY", 7, 125509},
	{"WESTLB", 6, 217834},
	{"WESTLAW", 7, 73155},
	{"WESTLANDS", 9, 253308},
	{"WESTLAND", 8, 80805},
	{"WESTLAKE", 8, 59368},
	{"WESTJET", 7, 135096},
	{"WESTINHOTELS", 12, 161896},
	{"WESTINHOTEL", 11, 161909},
	{"WESTINGHOUSE", 12, 59454},
	{"WESTIN", 6, 45448},
	{"WESTIES", 7, 168873},
	{"WESTIE", 6, 110281},
	{"WESTHOUGHTON", 12, 242813},
	{"WESTHOST", 8, 250233},
	{"WESTHOFF", 8, 197889},
	{"WESTHILL", 8, 185636},
	{"WESTHEIMER", 10, 124438},
	{"WESTHAVEN", 9, 192380},
	{"WESTHAMPTON", 11, 115010},
	{"WESTGATE", 8, 71120},
	{"WESTFORD", 8, 97699},
	{"WESTFIELD", 9, 50560},
	{"WESTFALL", 8, 114351},
	{"WESTFALIA", 9, 134316},
	{"WESTFALEN", 9, 110412},
	{"WESTERVILLE", 11, 96948},
	{"WESTERVELT", 10, 224471},
	{"WESTERNS", 8, 46948},
	{"WESTERNPORT", 11, 249645},
	{"WESTERNMOST", 11, 151092},
	{"WESTERNIZED", 11, 183194},
	{"WESTERNIZATION", 14, 233124},
	{"WESTERNERS", 10, 80518},
	{"WESTERNER", 9, 130176},
	{"WESTERN", 7, 3162},
	{"WESTERMANN", 10, 191041},
	{"WESTERMAN", 9, 168671},
	{"WESTERLY", 8, 65698},
	{"WESTERLUND", 10, 204975},
	{"WESTERLO", 8, 248218},
	{"WESTERHAM", 9, 166496},
	{"WESTERGAARD", 11, 257118},
	{"WESTERFIELD", 11, 173058},
	{"WESTERDAM", 9, 246220},
	{"WESTERBERG", 10, 157642},
	{"WESTER", 6, 109462},
	{"WESTENRA", 8, 209425},
	{"WESTENDORF", 10, 196235},
	{"WESTEND", 7, 152037},
	{"WESTEN", 6, 174283},
	{"WESTELL", 7, 171220},
	{"WESTED", 6, 198822},
	{"WESTDALE", 8, 218865},
	{"WESTCOUNTRY", 11, 166257},
	{"WESTCOTT", 8, 61113},
	{"WESTCOAST", 9, 94754},
	{"WESTCLOX", 8, 248726},
	{"WESTCLIFFE", 10, 194193},
	{"WESTCLIFF", 9, 136713},
	{"WESTCHESTER", 11, 48855},
	{"WESTCHASE", 9, 161468},
	{"WESTBY", 6, 154158},
	{"WESTBURY", 8, 68785},
	{"WESTBROOK", 9, 67641},
	{"WESTBOURNE", 10, 131443},
	{"WESTBOUND", 9, 81205},
	{"WESTBOROUGH", 11, 103359},
	{"WESTBORO", 8, 153145},
	{"WESTBERG", 8, 208968},
	{"WESTBANK", 8, 126533},
	{"WESTAT", 6, 242106},
	{"WESTAR", 6, 173018},
	{"WESTAMPTON", 10, 232005},
	{"WESTALL", 7, 192178},
	{"WESTAIR", 7, 247657},
	{"WESTAFF", 7, 224087},
	{"WEST", 4, 2142},
	{"WESSON", 6, 73428},
	{"WESSINGTON", 10, 216396},
	{"WESSELS", 7, 123004},
	{"WESSEL", 6, 120892},
	{"WESR", 4, 169449},
	{"WESP", 4, 59303},
	{"WESNOTH", 7, 89532},
	{"WESM", 4, 106379},
	{"WESLO", 5, 156781},
	{"WESLEYAN", 8, 51128},
	{"WESLEY", 6, 35466},
	{"WESLACO", 7, 123922},
	{"WESL", 4, 55202},
	{"WESK", 4, 171774},
	{"WESITE", 6, 233468},
	{"WESHALB", 7, 227285},
	{"WESG", 4, 253536},
	{"WESF", 4, 153587},
	{"WESER", 5, 211721},
	{"WESD", 4, 178649},
	{"WESCOTT", 7, 149779},
	{"WESCO", 5, 119992},
	{"WESCHLER", 8, 227108},
	{"WESB", 4, 136159},
	{"WERY", 4, 239517},
	{"WERW", 4, 39463},
	{"WERV", 4, 67587},
	{"WERU", 4, 60679},
	{"WERTZ", 5, 157027},
	{"WERTUNG", 7, 260649},
	{"WERTS", 5, 228054},
	{"WERTHER", 7, 177650},
	{"WERTHEIMER", 10, 164995},
	{"WERTHEIM", 8, 171034},
	{"WERTH", 5, 122558},
	{"WERTE", 5, 255714},
	{"WERT", 4, 83628},
	{"WERSJI", 6, 231241},
	{"WERSJA", 6, 126526},
	{"WERROR", 6, 132821},
	{"WERRINGTON", 10, 215550},
	{"WERRIBEE", 8, 128633},
	{"WERR", 4, 44953},
	{"WERQ", 4, 79846},
	{"WERP", 4, 34095},
	{"WERO", 4, 33635},
	{"WERNICKE", 8, 189447},
	{"WERNICK", 7, 216694},
	{"WERNHER", 7, 228863},
	{"WERNER", 6, 44112},
	{"WERM", 4, 45562},
	{"WERL", 4, 43327},
	{"WERKZEUGE", 9, 261753},
	{"WERKT", 5, 209418},
	{"WERKS", 5, 155740},
	{"WERKEN", 6, 157423},
	{"WERKE", 5, 125049},
	{"WERK", 4, 98062},
	{"WERJ", 4, 100088},
	{"WERI", 4, 29313},
	{"WERH", 4, 42747},
	{"WERG", 4, 52952},
	{"WERF", 4, 207427},
	{"WEREWOLVES", 10, 90678},
	{"WEREWOLF", 8, 61987},
	{"WERENT", 6, 111823},
	{"WEREN'T", 7, 678},
	{"WEREN", 5, 173143},
	{"WERELDWIJD", 10, 184761},
	{"WERELD", 6, 131438},
	{"WERE", 4, 807},
	{"WERDER", 6, 149662},
	{"WERDEN", 6, 52454},
	{"WERDE", 5, 168535},
	{"WERD", 4, 129581},
	{"WERC", 4, 211326},
	{"WERBUNG", 7, 92143},
	{"WERBEN", 6, 257515},
	{"WERBACH", 7, 179864},
	{"WERA", 4, 184441},
	{"WEQU", 4, 91559},
	{"WEPU", 4, 65746},
	{"WEPT", 4, 74742},
	{"WEPR", 4, 56712},
	{"WEPO", 4, 113850},
	{"WEPL", 4, 52145},
	{"WEPI", 4, 81703},
	{"WEPE", 4, 128782},
	{"WEPA", 4, 69884},
	{"WEOW", 4, 116287},
	{"WEOV", 4, 189803},
	{"WEOU", 4, 112839},
	{"WEOR", 4, 131380},
	{"WEOP", 4, 116862},
	{"WEOF", 4, 79205},
	{"WEOBLEY", 7, 246212},
	{"WEOB", 4, 130002},
	{"WENZHOU", 7, 106132},
	{"WENZEL", 6, 86098},
	{"WENY", 4, 187587},
	{"WENX", 4, 230283},
	{"WENW", 4, 96258},
	{"WENV", 4, 126219},
	{"WENTZVILLE", 10, 156810},
	{"WENTZEL", 7, 220983},
	{"WENTZ", 5, 139187},
	{"WENTWORTH", 9, 56215},
	{"WENTE", 5, 200664},
	{"WENT", 4, 2004},
	{"WENSLEYDALE", 11, 190969},
	{"WENSEN", 6, 255582},
	{"WENR", 4, 121309},
	{"WENP", 4, 164563},
	{"WENONAH", 7, 193876},
	{"WENONA", 6, 223861},
	{"WENNER", 6, 154102},
	{"WENM", 4, 152660},
	{"WENLOCK", 7, 160832},
	{"WENL", 4, 145208},
	{"WENK", 4, 209601},
	{"WENJ", 4, 112453},
	{"WENIGER", 7, 174704},
	{"WENIG", 5, 105726},
	{"WENHAM", 6, 117219},
	{"WENGER", 6, 62938},
	{"WENGEN", 6, 144397},
	{"WENGE", 5, 206007},
	{"WENG", 4, 118770},
	{"WENF", 4, 44853},
	{"WENE", 4, 30284},
	{"WENDYS", 6, 162350},
	{"WENDY", 5, 34787},
	{"WENDT", 5, 104239},
	{"WENDOVER", 8, 106494},
	{"WENDOUREE", 9, 224730},
	{"WENDLING", 8, 195640},
	{"WENDLER", 7, 255610},
	{"WENDLAND", 8, 174637},
	{"WENDIGO", 7, 228587},
	{"WENDIE", 6, 238730},
	{"WENDI", 5, 109698},
	{"WENDERS", 7, 154952},
	{"WENDEN", 6, 199148},
	{"WENDELL", 7, 59495},
	{"WENDELIN", 8, 209826},
	{"WENDEL", 6, 113117},
	{"WENDE", 5, 183596},
	{"WEND", 4, 146105},
	{"WENCHES", 7, 190064},
	{"WENCH", 5, 97483},
	{"WENCESLAS", 9, 135222},
	{"WENC", 4, 88369},
	{"WENB", 4, 131157},
	{"WENAUS", 6, 229341},
	{"WENATCHEE", 9, 72520},
	{"WEMYSS", 6, 179627},
	{"WEMY", 4, 241864},
	{"WEMU", 4, 48940},
	{"WEMPLE", 6, 240203},
	{"WEMP", 4, 76573},
	{"WEMON", 5, 94463},
	{"WEMO", 4, 71536},
	{"WEMM", 4, 260699},
	{"WEMI", 4, 58549},
	{"WEMEN", 5, 97621},
	{"WEME", 4, 65363},
	{"WEMBLEY", 7, 62391},
	{"WEMB", 4, 86938},
	{"WEMAN", 5, 111965},
	{"WEMA", 4, 43260},
	{"WELZ", 4, 246227},
	{"WELWYN", 6, 89225},
	{"WELW", 4, 143462},
	{"WELV", 4, 43719},
	{"WELU", 4, 195400},
	{"WELTY", 5, 118162},
	{"WELTWEIT", 8, 95374},
	{"WELTS", 5, 180260},
	{"WELTON", 6, 111696},
	{"WELTERWEIGHT", 12, 126866},
	{"WELTER", 6, 135563},
	{"WELTEN", 6, 213078},
	{"WELTED", 6, 258869},
	{"WELTE", 5, 150476},
	{"WELTANSCHAUUNG", 14, 244043},
	{"WELT", 4, 61698},
	{"WELSLEY", 7, 186110},
	{"WELSHPOOL", 9, 118959},
	{"WELSHOFER", 9, 258707},
	{"WELSHMAN", 8, 180638},
	{"WELSH", 5, 31921},
	{"WELSCH", 6, 173762},
	{"WELS", 4, 109681},
	{"WELR", 4, 57977},
	{"WELP", 4, 208006},
	{"WELO", 4, 45033},
	{"WELM", 4, 156750},
	{"WELLYLUG", 8, 152570},
	{"WELLY", 5, 152690},
	{"WELLWOOD", 8, 238446},
	{"WELLSVILLE", 10, 108689},
	{"WELLSTONE", 9, 95340},
	{"WELLSTON", 8, 157635},
	{"WELLSPRINGS", 11, 230667},
	{"WELLSPRING", 10, 104659},
	{"WELLSLEY", 8, 185810},
	{"WELLSFORD", 9, 259813},
	{"WELLSFARGO", 10, 260972},
	{"WELLSBURG", 9, 182303},
	{"WELLSBORO", 9, 176124},
	{"WELLS", 5, 8074},
	{"WELLPOINT", 9, 152573},
	{"WELLNIGH", 8, 256418},
	{"WELLNESSDICKE", 13, 115114},
	{"WELLNESS", 8, 29324},
	{"WELLNESDICKE", 12, 155811},
	{"WELLNES", 7, 152895},
	{"WELLMARK", 8, 181906},
	{"WELLMAN", 7, 91674},
	{"WELLL", 5, 214712},
	{"WELLKNOWN", 9, 218531},
	{"WELLINGTONS", 11, 201832},
	{"WELLINGTON", 10, 32403},
	{"WELLINGS", 8, 252771},
	{"WELLINGBOROUGH", 14, 97281},
	{"WELLING", 7, 84874},
	{"WELLIES", 7, 148399},
	{"WELLHEAD", 8, 110354},
	{"WELLGO", 6, 195821},
	{"WELLFORMED", 10, 221775},
	{"WELLFORD", 8, 261159},
	{"WELLFLEET", 9, 116736},
	{"WELLFIELD", 9, 225410},
	{"WELLESLY", 8, 185842},
	{"WELLESLEY", 9, 57132},
	{"WELLES", 6, 70733},
	{"WELLER", 6, 59961},
	{"WELLEMENTS", 10, 224455},
	{"WELLED", 6, 182466},
	{"WELLE", 5, 98721},
	{"WELLCRAFT", 9, 179272},
	{"WELLCOME", 8, 75490},
	{"WELLBUTRIN", 10, 48444},
	{"WELLBORN", 8, 185663},
	{"WELLBORE", 8, 142582},
	{"WELLBEING", 9, 54028},
	{"WELLAND", 7, 88120},
	{"WELLA", 5, 113805},
	{"WELL-KNOWN", 10, 33946},
	{"WELL-BEING", 10, 33428},
	{"WELL", 4, 616},
	{"WELKOM", 6, 126690},
	{"WELKIN", 6, 254054},
	{"WELKER", 6, 135654},
	{"WELKE", 5, 152515},
	{"WELK", 4, 126854},
	{"WELIVETOGETHER", 14, 67076},
	{"WELI", 4, 48958},
	{"WELFORD", 7, 177301},
	{"WELFARE", 7, 615},
	{"WELF", 4, 246467},
	{"WELESLEY", 8, 186066},
	{"WELEDA", 6, 119137},
	{"WELE", 4, 46328},
	{"WELDTITE", 8, 200318},
	{"WELDS", 5, 91088},
	{"WELDON", 6, 60946},
	{"WELDING", 7, 35716},
	{"WELDERS", 7, 72961},
	{"WELDER", 6, 68325},
	{"WELDED", 6, 53298},
	{"WELD", 4, 49343},
	{"WELCOMING", 9, 44615},
	{"WELCOMEUROPE", 12, 261182},
	{"WELCOMES", 8, 39460},
	{"WELCOMEGUEST", 12, 107861},
	{"WELCOMED", 8, 37560},
	{"WELCOME", 7, 614},
	{"WELCOM", 6, 148665},
	{"WELCHES", 7, 146743},
	{"WELCHER", 7, 199300},
	{"WELCHE", 6, 124018},
	{"WELCH", 5, 42400},
	{"WELC", 4, 32272},
	{"WELBY", 5, 180126},
	{"WELBUTRIN", 9, 232588},
	{"WELBORN", 7, 145696},
	{"WELBECK", 7, 197463},
	{"WELB", 4, 133953},
	{"WELA", 4, 72086},
	{"WEKN", 4, 38136},
	{"WEKIVA", 6, 227426},
	{"WEKI", 4, 105251},
	{"WEKE", 4, 76422},
	{"WEKALIST", 8, 181789},
	{"WEKA", 4, 152147},
	{"WEJU", 4, 44620},
	{"WEJO", 4, 165574},
	{"WEJ", 3, 1628},
	{"WEIZMANN", 8, 106634},
	{"WEIZ", 4, 140425},
	{"WEIY", 4, 247868},
	{"WEIW", 4, 168363},
	{"WEITZMAN", 8, 101221},
	{"WEITZEL", 7, 188165},
	{"WEITZ", 5, 89204},
	{"WEITHIO", 7, 243089},
	{"WEITERLESEN", 11, 187294},
	{"WEITERLEITEN", 12, 196678},
	{"WEITEREN", 8, 156230},
	{"WEITEREMPFEHLEN", 15, 211569},
	{"WEITERE", 7, 62104},
	{"WEITERBILDUNG", 13, 245338},
	{"WEITER", 6, 80044},
	{"WEISZ", 5, 92597},
	{"WEIST", 5, 239722},
	{"WEISSTEIN", 9, 176011},
	{"WEISSMANN", 9, 177799},
	{"WEISSMAN", 8, 95780},
	{"WEISSER", 7, 218261},
	{"WEISSE", 6, 181554},
	{"WEISS", 5, 43656},
	{"WEISMAN", 7, 103946},
	{"WEISKOPF", 8, 254383},
	{"WEISGERBER", 10, 182144},
	{"WEISER", 6, 96182},
	{"WEISEL", 6, 164957},
	{"WEISE", 5, 121490},
	{"WEISBROD", 8, 248598},
	{"WEISBERGER", 10, 238113},
	{"WEISBERG", 8, 132069},
	{"WEIRTON", 7, 129991},
	{"WEIRS", 5, 127608},
	{"WEIRICH", 7, 245294},
	{"WEIRDOS", 7, 146057},
	{"WEIRDO", 6, 95656},
	{"WEIRDNESS", 9, 76644},
	{"WEIRDLY", 7, 142330},
	{"WEIRDEST", 8, 108460},
	{"WEIRDER", 7, 137845},
	{"WEIRD", 5, 30543},
	{"WEIR", 4, 51293},
	{"WEIPA", 5, 148950},
	{"WEINTRAUB", 9, 105024},
	{"WEINSTOCK", 9, 153442},
	{"WEINSTEINS", 10, 253124},
	{"WEINSTEIN", 9, 64925},
	{"WEINRICH", 8, 202140},
	{"WEINREB", 7, 249671},
	{"WEINMANN", 8, 205657},
	{"WEINMAN", 7, 146216},
	{"WEINHEIM", 8, 158109},
	{"WEINGARTNER", 11, 199599},
	{"WEINGARTEN", 10, 120704},
	{"WEINGART", 8, 233833},
	{"WEINERT", 7, 194383},
	{"WEINER", 6, 62364},
	{"WEINBERGER", 10, 84022},
	{"WEINBERG", 8, 62789},
	{"WEIMER", 6, 116724},
	{"WEIMARANER", 10, 104762},
	{"WEIMAR", 6, 79739},
	{"WEIM", 4, 237908},
	{"WEILL", 5, 85821},
	{"WEILER", 6, 114028},
	{"WEILAND", 7, 111985},
	{"WEIL", 4, 56616},
	{"WEIHNACHTEN", 11, 162585},
	{"WEIHAI", 6, 228921},
	{"WEIGTH", 6, 218371},
	{"WEIGLE", 6, 254200},
	{"WEIGHTY", 7, 92560},
	{"WEIGHTWATCHERS", 14, 221979},
	{"WEIGHTS", 7, 33422},
	{"WEIGHTMAN", 9, 260130},
	{"WEIGHTLOSS", 10, 73089},
	{"WEIGHTLIFTING", 13, 78974},
	{"WEIGHTLIFTER", 12, 251437},
	{"WEIGHTLESSNESS", 14, 164181},
	{"WEIGHTLESS", 10, 122800},
	{"WEIGHTINGS", 10, 117178},
	{"WEIGHTING", 9, 51362},
	{"WEIGHTIER", 9, 261457},
	{"WEIGHTED", 8, 34199},
	{"WEIGHT", 6, 2848},
	{"WEIGHS", 6, 45286},
	{"WEIGHING", 8, 41281},
	{"WEIGHERS", 8, 201959},
	{"WEIGHER", 7, 228517},
	{"WEIGHED", 7, 48932},
	{"WEIGHBRIDGES", 12, 172680},
	{"WEIGHBRIDGE", 11, 225682},
	{"WEIGH", 5, 8059},
	{"WEIGEL", 6, 98034},
	{"WEIGAND", 7, 140026},
	{"WEIG", 4, 240438},
	{"WEIFANG", 7, 209134},
	{"WEIF", 4, 195401},
	{"WEIERSTRASS", 11, 184053},
	{"WEIER", 5, 225542},
	{"WEIDNER", 7, 113308},
	{"WEIDMAN", 7, 154086},
	{"WEIDER", 6, 82976},
	{"WEIDENFELD", 10, 144010},
	{"WEIDEN", 6, 214179},
	{"WEIDEMANN", 9, 253505},
	{"WEIDE", 5, 167265},
	{"WEID", 4, 102821},
	{"WEICK", 5, 238823},
	{"WEICHERT", 8, 116779},
	{"WEIC", 4, 146629},
	{"WEIBULL", 7, 129861},
	{"WEIBLICHE", 9, 199279},
	{"WEIBER", 6, 158423},
	{"WEIBEL", 6, 177916},
	{"WEIB", 4, 140385},
	{"WEHU", 4, 138536},
	{"WEHRMACHT", 9, 155831},
	{"WEHR", 4, 196686},
	{"WEHNER", 6, 193008},
	{"WEHAVE", 6, 213088},
	{"WEHA", 4, 4280},
	{"WEGU", 4, 213402},
	{"WEGR", 4, 105495},
	{"WEGNER", 6, 114073},
	{"WEGN", 4, 248153},
	{"WEGMANS", 7, 194379},
	{"WEGMAN", 6, 151926},
	{"WEGM", 4, 174856},
	{"WEGL", 4, 224193},
	{"WEGI", 4, 50156},
	{"WEGH", 4, 228225},
	{"WEGENER", 7, 108364},
	{"WEGEN", 5, 115603},
	{"WEGE", 4, 158130},
	{"WEGA", 4, 71025},
	{"WEFU", 4, 159176},
	{"WEFT", 4, 124166},
	{"WEFR", 4, 182753},
	{"WEFL", 4, 159340},
	{"WEFI", 4, 53155},
	{"WEFF", 4, 100384},
	{"WEFE", 4, 58679},
	{"WEFAN", 5, 120651},
	{"WEEZY", 5, 223215},
	{"WEEZER", 6, 39425},
	{"WEEZ", 4, 252742},
	{"WEEX", 4, 57376},
	{"WEEW", 4, 205916},
	{"WEEVILS", 7, 143109},
	{"WEEVIL", 6, 89806},
	{"WEEV", 4, 75889},
	{"WEETZIE", 7, 176529},
	{"WEETABIX", 8, 182472},
	{"WEESE", 5, 203356},
	{"WEERT", 5, 261544},
	{"WEERGEVEN", 9, 172752},
	{"WEERAWARANA", 11, 238333},
	{"WEER", 4, 109028},
	{"WEEPY", 5, 191270},
	{"WEEPS", 5, 101369},
	{"WEEPING", 7, 58270},
	{"WEEPIES", 7, 251397},
	{"WEEP", 4, 60926},
	{"WEENY", 5, 206597},
	{"WEENIES", 7, 175364},
	{"WEENIE", 6, 106357},
	{"WEEMS", 5, 117128},
	{"WEEMEE", 6, 186175},
	{"WEEM", 4, 112484},
	{"WEEL", 4, 140805},
	{"WEEKS", 5, 1887},
	{"WEEKNIGHTS", 10, 162511},
	{"WEEKNIGHT", 9, 148345},
	{"WEEKLY", 6, 28657},
	{"WEEKLONG", 8, 115158},
	{"WEEKLIES", 8, 106557},
	{"WEEKLEY", 7, 186567},
	{"WEEKI", 5, 198986},
	{"WEEKES", 6, 142815},
	{"WEEKENDS", 8, 28769},
	{"WEEKENDERS", 10, 203945},
	{"WEEKENDER", 9, 72958},
	{"WEEKEND", 7, 3503},
	{"WEEKE", 5, 219824},
	{"WEEKDAYS", 8, 53044},
	{"WEEKDAY", 7, 50257},
	{"WEEK", 4, 1040},
	{"WEEHAWKEN", 9, 144798},
	{"WEEF", 4, 253886},
	{"WEEDY", 5, 128798},
	{"WEEDSPORT", 9, 229655},
	{"WEEDS", 5, 44247},
	{"WEEDON", 6, 154417},
	{"WEEDING", 7, 87612},
	{"WEEDER", 6, 252268},
	{"WEEDEN", 6, 191740},
	{"WEEDED", 6, 155140},
	{"WEED", 4, 34259},
	{"WEEC", 4, 173510},
	{"WEEBLS", 6, 240603},
	{"WEEBLES", 7, 245359},
	{"WEEBLE", 6, 241932},
	{"WEEBL", 5, 191485},
	{"WEDY", 4, 117511},
	{"WEDW", 4, 48791},
	{"WEDV", 4, 111441},
	{"WEDU", 4, 43914},
	{"WEDT", 4, 7584},
	{"WEDS", 4, 88639},
	{"WEDR", 4, 60870},
	{"WEDQ", 4, 207726},
	{"WEDP", 4, 58376},
	{"WEDO", 4, 223113},
	{"WEDNESFIELD", 11, 246028},
	{"WEDNESDAYS", 10, 51295},
	{"WEDNESDAY", 9, 2035},
	{"WEDNESBURY", 10, 164849},
	{"WEDN", 4, 8495},
	{"WEDMORE", 7, 243689},
	{"WEDM", 4, 51157},
	{"WEDLOCK", 7, 103501},
	{"WEDL", 4, 60204},
	{"WEDK", 4, 134643},
	{"WEDJ", 4, 78224},
	{"WEDING", 6, 250188},
	{"WEDI", 4, 64413},
	{"WEDH", 4, 40348},
	{"WEDGWOOD", 8, 59338},
	{"WEDGING", 7, 230720},
	{"WEDGIE", 6, 142902},
	{"WEDGEWOOD", 9, 93214},
	{"WEDGES", 6, 59531},
	{"WEDGED", 6, 111204},
	{"WEDGE", 5, 41863},
	{"WEDG", 4, 50814},
	{"WEDF", 4, 46403},
	{"WEDER", 5, 207666},
	{"WEDEL", 5, 184067},
	{"WEDE", 4, 36197},
	{"WEDDLE", 6, 156272},
	{"WEDDINGTON", 10, 167967},
	{"WEDDINGS", 8, 9586},
	{"WEDDINGBELLS", 12, 172710},
	{"WEDDINGBELLER", 13, 141394},
	{"WEDDING", 7, 6831},
	{"WEDDIN", 6, 198753},
	{"WEDDIG", 6, 261289},
	{"WEDDERBURN", 10, 148828},
	{"WEDDELL", 7, 159297},
	{"WEDDED", 6, 98151},
	{"WEDD", 4, 147985},
	{"WEDB", 4, 30426},
	{"WEDA", 4, 33975},
	{"WED", 3, 2044},
	{"WECU", 4, 117946},
	{"WECR", 4, 94423},
	{"WECL", 4, 111663},
	{"WECKL", 5, 252817},
	{"WECKER", 6, 233296},
	{"WECK", 4, 239247},
	{"WECHT", 5, 216178},
	{"WECHSLER", 8, 119643},
	{"WECHSELN", 8, 250335},
	{"WECHSEL", 7, 219666},
	{"WECH", 4, 69144},
	{"WECE", 4, 96231},
	{"WECC", 4, 223170},
	{"WEBZINES", 8, 256234},
	{"WEBZINE", 7, 95964},
	{"WEBY", 4, 223296},
	{"WEBX", 4, 78835},
	{"WEBWORLD", 8, 214381},
	{"WEBWORKS", 8, 108559},
	{"WEBWORK", 7, 105412},
	{"WEBWML", 6, 162019},
	{"WEBWISE", 7, 238895},
	{"WEBWEAVER", 9, 97833},
	{"WEBWATCH", 8, 96371},
	{"WEBWARPER", 9, 183825},
	{"WEBWARE", 7, 164974},
	{"WEBW", 4, 110201},
	{"WEBVIEWER", 9, 184022},
	{"WEBVIEW", 7, 176007},
	{"WEBVERZEICHNIS", 14, 196687},
	{"WEBV", 4, 162864},
	{"WEBUSER", 7, 187789},
	{"WEBUI", 5, 167008},
	{"WEBTV", 5, 88636},
	{"WEBTRENDS", 9, 61423},
	{"WEBTRADE", 8, 211022},
	{"WEBTOURIST", 10, 121680},
	{"WEBTOPICVIEWTEMPLATE", 20, 189992},
	{"WEBTOPICLIST", 12, 86217},
	{"WEBTOPICEDITTEMPLATE", 20, 139106},
	{"WEBTOP", 6, 208855},
	{"WEBTOOLS", 8, 135354},
	{"WEBTEST", 7, 132472},
	{"WEBTENDER", 9, 191217},
	{"WEBTECH", 7, 174945},
	{"WEBTEAM", 7, 121892},
	{"WEBT", 4, 90617},
	{"WEBSVN", 6, 147848},
	{"WEBSTUFF", 8, 229561},
	{"WEBSTORE", 8, 94930},
	{"WEBSTERS", 8, 140564},
	{"WEBSTER", 7, 30359},
	{"WEBSTATS", 8, 146323},
	{"WEBSTATISTIK", 12, 223837},
	{"WEBSTATISTICS", 13, 59543},
	{"WEBSTAT", 7, 88830},
	{"WEBSTARTER", 10, 255445},
	{"WEBSTART", 8, 163951},
	{"WEBSTAR", 7, 153969},
	{"WEBSPHERE", 9, 37975},
	{"WEBSPAM", 7, 238878},
	{"WEBSPACE", 8, 56520},
	{"WEBSOLARIUM", 11, 146382},
	{"WEBSOC", 6, 248131},
	{"WEBSITES", 8, 3176},
	{"WEBSITE", 7, 992},
	{"WEBSIT", 6, 195281},
	{"WEBSIDESTORY", 12, 178012},
	{"WEBSIDE", 7, 244331},
	{"WEBSHOTS", 8, 31293},
	{"WEBSHOP", 7, 100268},
	{"WEBSHITES", 9, 149612},
	{"WEBSHIELD", 9, 248727},
	{"WEBSHELL", 8, 227569},
	{"WEBSHARE", 8, 226450},
	{"WEBSERVICES", 11, 82820},
	{"WEBSERVICE", 10, 96865},
	{"WEBSERVERS", 10, 138282},
	{"WEBSERVER", 9, 56699},
	{"WEBSENSE", 8, 94017},
	{"WEBSEND", 7, 140957},
	{"WEBSEITEN", 9, 149444},
	{"WEBSEITE", 8, 136579},
	{"WEBSEARCHADVANCED", 17, 139052},
	{"WEBSEARCH", 9, 66124},
	{"WEBS", 4, 40555},
	{"WEBRSS", 6, 98529},
	{"WEBRPG", 6, 240003},
	{"WEBROOT", 7, 81035},
	{"WEBRINGS", 8, 70500},
	{"WEBRINGALAN", 11, 235879},
	{"WEBRING", 7, 40899},
	{"WEBREFERENCE", 12, 252636},
	{"WEBREF", 6, 197896},
	{"WEBRADIO", 8, 163195},
	{"WEBR", 4, 79782},
	{"WEBQUESTS", 9, 145167},
	{"WEBQUEST", 8, 99905},
	{"WEBPROTECT", 10, 234752},
	{"WEBPRONEWS", 10, 127651},
	{"WEBPREFSTOPIC", 13, 134718},
	{"WEBPREFERENCES", 14, 57495},
	{"WEBPOSITION", 11, 95749},
	{"WEBPORTAL", 9, 257313},
	{"WEBPATH", 7, 241069},
	{"WEBPAGES", 8, 53135},
	{"WEBPAGE", 7, 34765},
	{"WEBP", 4, 61454},
	{"WEBOPEDIA", 9, 141564},
	{"WEBOBJECTS", 10, 137791},
	{"WEBOBILL", 8, 142481},
	{"WEBNOTIFY", 9, 68312},
	{"WEBNEWS", 7, 255615},
	{"WEBNET", 6, 190246},
	{"WEBN", 4, 214218},
	{"WEBMOTIF", 8, 224787},
	{"WEBMONKEY", 9, 127688},
	{"WEBMONEY", 8, 213272},
	{"WEBMISTRESS", 11, 117497},
	{"WEBMINERAL", 10, 214530},
	{"WEBMIN", 6, 50985},
	{"WEBMETHODS", 10, 113630},
	{"WEBMD", 5, 43104},
	{"WEBMASTERWORLD", 14, 70287},
	{"WEBMASTERUK", 11, 217680},
	{"WEBMASTERSERVICE", 16, 254394},
	{"WEBMASTERS", 10, 33450},
	{"WEBMASTERING", 12, 160207},
	{"WEBMASTER", 9, 4679},
	{"WEBMAP", 6, 227189},
	{"WEBMANAGER", 10, 186174},
	{"WEBMAIL", 7, 41480},
	{"WEBMAGIC", 8, 140244},
	{"WEBLOGS", 7, 32830},
	{"WEBLOGIC", 8, 50073},
	{"WEBLOGGING", 10, 86727},
	{"WEBLOGGERS", 10, 156420},
	{"WEBLOGGER", 9, 146225},
	{"WEBLOGG", 7, 128727},
	{"WEBLOG", 6, 5292},
	{"WEBLISTS", 8, 156425},
	{"WEBLIST", 7, 88692},
	{"WEBLIOGRAPHY", 12, 253671},
	{"WEBLINKS", 8, 61668},
	{"WEBLINK", 7, 96415},
	{"WEBLEY", 6, 192822},
	{"WEBLEFTBAR", 10, 123981},
	{"WEBL", 4, 95060},
	{"WEBKIT", 6, 98078},
	{"WEBKING", 7, 164877},
	{"WEBKATALOG", 10, 229285},
	{"WEBK", 4, 177068},
	{"WEBJUNCTION", 11, 196677},
	{"WEBJAY", 6, 77541},
	{"WEBITE", 6, 247454},
	{"WEBISTE", 7, 171906},
	{"WEBINDEX", 8, 80859},
	{"WEBINARS", 8, 63421},
	{"WEBINAR", 7, 49911},
	{"WEBIMMUNE", 9, 226185},
	{"WEBID", 5, 171420},
	{"WEBHOSTS", 8, 171548},
	{"WEBHOSTINGTALK", 14, 132730},
	{"WEBHOSTING", 10, 44777},
	{"WEBHOSTER", 9, 253380},
	{"WEBHOST", 7, 102918},
	{"WEBHOME", 7, 54321},
	{"WEBH", 4, 129799},
	{"WEBGUIDE", 8, 137951},
	{"WEBGUI", 6, 138997},
	{"WEBG", 4, 189678},
	{"WEBFORMS", 8, 132854},
	{"WEBFORM", 7, 84925},
	{"WEBFODDER", 9, 220931},
	{"WEBFOCUS", 8, 143292},
	{"WEBFINDER", 9, 121994},
	{"WEBFEEDS", 8, 126492},
	{"WEBFEED", 7, 132941},
	{"WEBF", 4, 115543},
	{"WEBEX", 5, 71702},
	{"WEBERS", 6, 244183},
	{"WEBERN", 6, 199108},
	{"WEBER", 5, 37369},
	{"WEBELOS", 7, 164725},
	{"WEBELEMENTS", 11, 108902},
	{"WEBEDITOR", 9, 192940},
	{"WEBE", 4, 41886},
	{"WEBDISPLAY", 10, 209470},
	{"WEBDIRECTORY", 12, 181312},
	{"WEBDIARY", 8, 165036},
	{"WEBDEVELOPMENT", 14, 213944},
	{"WEBDEVELOPER", 12, 186107},
	{"WEBDEV", 6, 94644},
	{"WEBDESIGNS", 10, 248304},
	{"WEBDESIGNER", 11, 166875},
	{"WEBDESIGN", 9, 49625},
	{"WEBDAV", 6, 71246},
	{"WEBDATE", 7, 256269},
	{"WEBDATA", 7, 193997},
	{"WEBCT", 5, 53726},
	{"WEBCRAWLERS", 11, 225689},
	{"WEBCRAWLER", 10, 64703},
	{"WEBCOUNTER", 10, 131971},
	{"WEBCORE", 7, 118237},
	{"WEBCOPYRIGHT", 12, 143945},
	{"WEBCONTROLS", 11, 190056},
	{"WEBCONTROL", 10, 257917},
	{"WEBCONCEPTS", 11, 210779},
	{"WEBCOMICS", 9, 92111},
	{"WEBCOMIC", 8, 99447},
	{"WEBCOM", 6, 130503},
	{"WEBCLOTHES", 10, 242302},
	{"WEBCLIENT", 9, 229354},
	{"WEBCITY", 7, 176111},
	{"WEBCHATS", 8, 147921},
	{"WEBCHAT", 7, 124525},
	{"WEBCHANGESALERT", 15, 223390},
	{"WEBCHANGES", 10, 75505},
	{"WEBCHALKBOARD", 13, 253846},
	{"WEBCGM", 6, 258286},
	{"WEBCENTER", 9, 258386},
	{"WEBCD", 5, 165554},
	{"WEBCATALOG", 10, 199981},
	{"WEBCAT", 6, 122574},
	{"WEBCASTS", 8, 39880},
	{"WEBCASTING", 10, 94922},
	{"WEBCASTERS", 10, 186870},
	{"WEBCAST", 7, 36358},
	{"WEBCALENDAR", 11, 105464},
	{"WEBCAL", 6, 134690},
	{"WEBCAB", 6, 164876},
	{"WEBBY", 5, 74714},
	{"WEBBUILDER", 10, 257116},
	{"WEBBROWSER", 10, 143377},
	{"WEBBOOK", 7, 225177},
	{"WEBBOARD", 8, 97493},
	{"WEBBLOG", 7, 210841},
	{"WEBBING", 7, 67034},
	{"WEBBIE", 6, 177514},
	{"WEBBGCOLOR", 10, 117050},
	{"WEBBERS", 7, 254895},
	{"WEBBER", 6, 53728},
	{"WEBBED", 6, 126799},
	{"WEBBEAMS", 8, 260618},
	{"WEBBE", 5, 180634},
	{"WEBBBS", 6, 99365},
	{"WEBBASED", 8, 186559},
	{"WEBB", 4, 37506},
	{"WEBAWARD", 8, 215794},
	{"WEBATTACK", 9, 174528},
	{"WEBAPPS", 7, 104604},
	{"WEBAPP", 6, 64796},
	{"WEBALIZER", 9, 94731},
	{"WEBALIAS", 8, 212186},
	{"WEBAIR", 6, 238290},
	{"WEBAIM", 6, 169172},
	{"WEBADVISOR", 10, 153708},
	{"WEBADMIN", 8, 120717},
	{"WEBACTIVE", 9, 80128},
	{"WEBACT", 6, 245013},
	{"WEBACCESS", 9, 165457},
	{"WEBA", 4, 59101},
	{"WEB", 3, 32625},
	{"WEAW", 4, 223749},
	{"WEAVINGS", 8, 174481},
	{"WEAVING", 7, 48257},
	{"WEAVES", 6, 78495},
	{"WEAVERVILLE", 11, 133365},
	{"WEAVERS", 7, 72385},
	{"WEAVER", 6, 40692},
	{"WEAVED", 6, 155752},
	{"WEAVE", 5, 35823},
	{"WEAV", 4, 49680},
	{"WEATHERZONE", 11, 205823},
	{"WEATHERWAX", 10, 240057},
	{"WEATHERVANES", 12, 98436},
	{"WEATHERVANE", 11, 106692},
	{"WEATHERTECH", 11, 155842},
	{"WEATHERSTRIPPING", 16, 136174},
	{"WEATHERSTRIP", 12, 127178},
	{"WEATHERSPOON", 12, 212523},
	{"WEATHERSBY", 10, 261410},
	{"WEATHERS", 8, 101286},
	{"WEATHERPROOFING", 15, 250430},
	{"WEATHERPROOF", 12, 77475},
	{"WEATHERPIXIE", 12, 126198},
	{"WEATHERNET", 10, 196353},
	{"WEATHERMEN", 10, 220643},
	{"WEATHERMATRIX", 13, 207988},
	{"WEATHERMAN", 10, 116815},
	{"WEATHERLY", 9, 128736},
	{"WEATHERLINK", 11, 256734},
	{"WEATHERLEY", 10, 213855},
	{"WEATHERIZATION", 14, 120240},
	{"WEATHERING", 10, 75275},
	{"WEATHERHOST", 11, 191772},
	{"WEATHERHILL", 11, 218355},
	{"WEATHERHEAD", 11, 162672},
	{"WEATHERGOTH", 11, 177192},
	{"WEATHERGIRL", 11, 149436},
	{"WEATHERFORD", 11, 67983},
	{"WEATHERED", 9, 68947},
	{"WEATHERCOM", 10, 232247},
	{"WEATHERCITY", 11, 212129},
	{"WEATHERBY", 9, 137610},
	{"WEATHERBUG", 10, 101366},
	{"WEATHERBOY", 10, 158010},
	{"WEATHERALOUD", 12, 181037},
	{"WEATHERALL", 10, 145987},
	{"WEATHER", 7, 613},
	{"WEATHE", 6, 261133},
	{"WEATER", 6, 246521},
	{"WEASLEY", 7, 104127},
	{"WEASIE", 6, 153436},
	{"WEASELS", 7, 104998},
	{"WEASELFISH", 10, 124934},
	{"WEASEL", 6, 64645},
	{"WEARY", 5, 51832},
	{"WEARSIDE", 8, 188166},
	{"WEARS", 5, 46648},
	{"WEARISOME", 9, 195200},
	{"WEARING", 7, 9024},
	{"WEARINESS", 9, 111506},
	{"WEARIN", 6, 176967},
	{"WEARILY", 7, 117928},
	{"WEARIED", 7, 150659},
	{"WEARHOUSE", 9, 173082},
	{"WEAREVER", 8, 208958},
	{"WEARERS", 7, 121592},
	{"WEARER", 6, 76235},
	{"WEARE", 5, 119473},
	{"WEARCH", 6, 162000},
	{"WEARABLES", 9, 107006},
	{"WEARABLE", 8, 67190},
	{"WEAR", 4, 1723},
	{"WEAPONSMITH", 11, 258750},
	{"WEAPONS", 7, 5511},
	{"WEAPONRY", 8, 67198},
	{"WEAPON", 6, 2782},
	{"WEAP", 4, 233782},
	{"WEANLING", 8, 186877},
	{"WEANING", 7, 71126},
	{"WEANED", 6, 104506},
	{"WEAM", 4, 164082},
	{"WEALTHY", 7, 10062},
	{"WEALTHIEST", 10, 90384},
	{"WEALTHIER", 9, 102381},
	{"WEALTH", 6, 8153},
	{"WEALE", 5, 246260},
	{"WEALDSTONE", 10, 210398},
	{"WEALDEN", 7, 167604},
	{"WEALD", 5, 128169},
	{"WEAL", 4, 144043},
	{"WEAKNESSES", 10, 36819},
	{"WEAKNESS", 8, 29816},
	{"WEAKLY", 6, 55015},
	{"WEAKLING", 8, 184709},
	{"WEAKLEY", 7, 149441},
	{"WEAKEST", 7, 64482},
	{"WEAKERTHANS", 11, 169900},
	{"WEAKER", 6, 46139},
	{"WEAKENS", 7, 92770},
	{"WEAKENING", 9, 64483},
	{"WEAKENED", 8, 55245},
	{"WEAKEN", 6, 34267},
	{"WEAK", 4, 6565},
	{"WEAG", 4, 101956},
	{"WEAF", 4, 167239},
	{"WEAB", 4, 153453},
	{"WE'VE", 5, 677},
	{"WE'RE", 5, 676},
	{"WE'D", 4, 675},
	{"WDZ", 3, 71968},
	{"WDYS", 4, 221023},
	{"WDYO", 4, 217945},
	{"WDYN", 4, 176890},
	{"WDYA", 4, 225074},
	{"WDY", 3, 6472},
	{"WDX", 3, 118683},
	{"WDWO", 4, 254596},
	{"WDWI", 4, 126939},
	{"WDWH", 4, 130042},
	{"WDWE", 4, 167997},
	{"WDWA", 4, 100491},
	{"WDW", 3, 100726},
	{"WDVL", 4, 215971},
	{"WDVD", 4, 228708},
	{"WDV", 3, 41233},
	{"WDUT", 4, 200735},
	{"WDUS", 4, 152584},
	{"WDUR", 4, 86300},
	{"WDUN", 4, 168082},
	{"WDUM", 4, 213214},
	{"WDUE", 4, 128023},
	{"WDUB", 4, 249114},
	{"WDTO", 4, 114014},
	{"WDSW", 4, 139206},
	{"WDST", 4, 113946},
	{"WDSS", 4, 203808},
	{"WDSP", 4, 240451},
	{"WDSO", 4, 99654},
	{"WDSL", 4, 251779},
	{"WDSI", 4, 142396},
	{"WDSH", 4, 161289},
	{"WDSG", 4, 231072},
	{"WDSF", 4, 207727},
	{"WDSE", 4, 174857},
	{"WDSB", 4, 219501},
	{"WDSA", 4, 92455},
	{"WDRY", 4, 144971},
	{"WDRU", 4, 105496},
	{"WDRO", 4, 92711},
	{"WDRI", 4, 70964},
	{"WDRE", 4, 97240},
	{"WDRA", 4, 91219},
	{"WDR", 3, 126565},
	{"WDQ", 3, 92396},
	{"WDPL", 4, 164229},
	{"WDP", 3, 152835},
	{"WDOZ", 4, 131986},
	{"WDOY", 4, 50642},
	{"WDOW", 4, 41018},
	{"WDOU", 4, 109243},
	{"WDOT", 4, 105849},
	{"WDOS", 4, 165509},
	{"WDOR", 4, 142649},
	{"WDOP", 4, 246327},
	{"WDOO", 4, 149259},
	{"WDON", 4, 80515},
	{"WDOM", 4, 122291},
	{"WDOL", 4, 127270},
	{"WDOI", 4, 90688},
	{"WDOG", 4, 141634},
	{"WDOF", 4, 63150},
	{"WDOE", 4, 53338},
	{"WDOD", 4, 233223},
	{"WDOC", 4, 102956},
	{"WDNR", 4, 183470},
	{"WDNO", 4, 202050},
	{"WDNE", 4, 203615},
	{"WDMO", 4, 205559},
	{"WDM", 3, 71688},
	{"WDLI", 4, 234294},
	{"WDLE", 4, 183846},
	{"WDL", 3, 217382},
	{"WDIT", 4, 193171},
	{"WDIS", 4, 55741},
	{"WDIO", 4, 244204},
	{"WDIN", 4, 69204},
	{"WDIM", 4, 144881},
	{"WDIG", 4, 124286},
	{"WDIFF", 5, 225492},
	{"WDIF", 4, 77077},
	{"WDIE", 4, 119187},
	{"WDID", 4, 51874},
	{"WDIC", 4, 176017},
	{"WDIA", 4, 136375},
	{"WDHU", 4, 214603},
	{"WDHE", 4, 184092},
	{"WDHA", 4, 144021},
	{"WDGO", 4, 225793},
	{"WDGA", 4, 175065},
	{"WDG", 3, 174619},
	{"WDFW", 4, 127633},
	{"WDFO", 4, 163322},
	{"WDFA", 4, 191496},
	{"WDF", 3, 139955},
	{"WDEV", 4, 70290},
	{"WDES", 4, 65160},
	{"WDER", 4, 47380},
	{"WDEP", 4, 85728},
	{"WDEN", 4, 66144},
	{"WDEM", 4, 67670},
	{"WDEL", 4, 71021},
	{"WDEG", 4, 85866},
	{"WDEF", 4, 67880},
	{"WDEE", 4, 102898},
	{"WDED", 4, 55481},
	{"WDECLARATION", 12, 103349},
	{"WDEC", 4, 66921},
	{"WDEB", 4, 128173},
	{"WDEA", 4, 67061},
	{"WDDX", 4, 144060},
	{"WDDI", 4, 243316},
	{"WDD", 3, 244950},
	{"WDCS", 4, 167167},
	{"WDCO", 4, 138765},
	{"WDCH", 4, 163838},
	{"WDCC", 4, 223252},
	{"WDCA", 4, 190337},
	{"WDC", 3, 90217},
	{"WDBY", 4, 257778},
	{"WDBU", 4, 172480},
	{"WDBO", 4, 258530},
	{"WDBE", 4, 155559},
	{"WDB", 3, 174719},
	{"WDAY", 4, 170128},
	{"WDAW", 4, 184606},
	{"WDAV", 4, 120875},
	{"WDAU", 4, 241865},
	{"WDAT", 4, 75322},
	{"WDAS", 4, 143046},
	{"WDAR", 4, 97688},
	{"WDAN", 4, 69183},
	{"WDAM", 4, 154190},
	{"WDAL", 4, 138257},
	{"WDAI", 4, 168539},
	{"WDAF", 4, 226719},
	{"WDAD", 4, 190069},
	{"WDAC", 4, 261568},
	{"WCZ", 3, 45868},
	{"WCYC", 4, 186897},
	{"WCY", 3, 35579},
	{"WCWW", 4, 219944},
	{"WCWS", 4, 237677},
	{"WCWI", 4, 252141},
	{"WCWA", 4, 208702},
	{"WCW", 3, 81965},
	{"WCVB", 4, 208685},
	{"WCV", 3, 53958},
	{"WCUT", 4, 118251},
	{"WCUS", 4, 95692},
	{"WCUR", 4, 100385},
	{"WCUO", 4, 219291},
	{"WCUL", 4, 126075},
	{"WCUB", 4, 247869},
	{"WCU", 3, 160434},
	{"WCRY", 4, 231315},
	{"WCRU", 4, 141681},
	{"WCRP", 4, 213987},
	{"WCRO", 4, 79540},
	{"WCRI", 4, 91147},
	{"WCREENSAVERS", 12, 235908},
	{"WCRA", 4, 104616},
	{"WCR", 3, 145718},
	{"WCPO", 4, 94865},
	{"WCP", 3, 132008},
	{"WCOW", 4, 190486},
	{"WCOV", 4, 87302},
	{"WCOU", 4, 45799},
	{"WCOT", 4, 224194},
	{"WCOS", 4, 59508},
	{"WCOR", 4, 82104},
	{"WCOP", 4, 139463},
	{"WCOO", 4, 95609},
	{"WCONVERSION", 11, 176165},
	{"WCON", 4, 226088},
	{"WCOL", 4, 60924},
	{"WCOI", 4, 206837},
	{"WCOH", 4, 247241},
	{"WCOF", 4, 248488},
	{"WCOD", 4, 145522},
	{"WCOC", 4, 194500},
	{"WCOA", 4, 65607},
	{"WCNC", 4, 260265},
	{"WCMC", 4, 153877},
	{"WCM", 3, 104391},
	{"WCLU", 4, 100216},
	{"WCLO", 4, 63782},
	{"WCLI", 4, 91789},
	{"WCLE", 4, 85738},
	{"WCLA", 4, 65524},
	{"WCL", 3, 138073},
	{"WCIV", 4, 158043},
	{"WCITIES", 7, 69307},
	{"WCIT", 4, 68903},
	{"WCIS", 4, 201400},
	{"WCIR", 4, 136724},
	{"WCIN", 4, 173927},
	{"WCIENCE", 7, 234214},
	{"WCHU", 4, 91902},
	{"WCHR", 4, 99420},
	{"WCHO", 4, 106745},
	{"WCHI", 4, 62267},
	{"WCHE", 4, 86998},
	{"WCHAR", 5, 123206},
	{"WCHA", 4, 123380},
	{"WCG", 3, 112597},
	{"WCF", 3, 125800},
	{"WCET", 4, 212762},
	{"WCEO", 4, 157105},
	{"WCEN", 4, 69658},
	{"WCEM", 4, 178049},
	{"WCEL", 4, 116028},
	{"WCED", 4, 244856},
	{"WCDMA", 5, 106762},
	{"WCD", 3, 138511},
	{"WCCP", 4, 148841},
	{"WCCO", 4, 147058},
	{"WCCC", 4, 235648},
	{"WCC", 3, 72202},
	{"WCBS", 4, 137548},
	{"WCB", 3, 95535},
	{"WCAV", 4, 212995},
	{"WCAST", 5, 111339},
	{"WCAR", 4, 186330},
	{"WCAN", 4, 40966},
	{"WCAM", 4, 69032},
	{"WCAL", 4, 54824},
	{"WCAG", 4, 76870},
	{"WCAF", 4, 221225},
	{"WCAD", 4, 202940},
	{"WBZ", 3, 141578},
	{"WBYW", 4, 231567},
	{"WBYT", 4, 93991},
	{"WBYS", 4, 151782},
	{"WBYR", 4, 192207},
	{"WBYP", 4, 120941},
	{"WBYO", 4, 230284},
	{"WBYN", 4, 126402},
	{"WBYM", 4, 162030},
	{"WBYL", 4, 211634},
	{"WBYJ", 4, 250461},
	{"WBYI", 4, 210878},
	{"WBYH", 4, 186627},
	{"WBYG", 4, 252835},
	{"WBYF", 4, 226234},
	{"WBYE", 4, 207545},
	{"WBYD", 4, 216255},
	{"WBYC", 4, 173928},
	{"WBYB", 4, 177171},
	{"WBYA", 4, 118441},
	{"WBX", 3, 131458},
	{"WBW", 3, 254585},
	{"WBV", 3, 86244},
	{"WBUY", 4, 145747},
	{"WBUT", 4, 43076},
	{"WBUS", 4, 44889},
	{"WBUR", 4, 195039},
	{"WBUN", 4, 215248},
	{"WBUM", 4, 260851},
	{"WBUL", 4, 159485},
	{"WBUI", 4, 63023},
	{"WBUG", 4, 255645},
	{"WBUF", 4, 247551},
	{"WBUD", 4, 91525},
	{"WBUC", 4, 142603},
	{"WBU", 3, 247624},
	{"WBRY", 4, 234886},
	{"WBRU", 4, 76431},
	{"WBRO", 4, 66215},
	{"WBRI", 4, 60589},
	{"WBRE", 4, 70762},
	{"WBRA", 4, 73290},
	{"WBR", 3, 133303},
	{"WBQ", 3, 116142},
	{"WBP", 3, 253318},
	{"WBOX", 4, 135870},
	{"WBOW", 4, 143097},
	{"WBOU", 4, 109396},
	{"WBOT", 4, 86053},
	{"WBOS", 4, 123157},
	{"WBOR", 4, 67969},
	{"WBOO", 4, 68619},
	{"WBON", 4, 112944},
	{"WBOM", 4, 220598},
	{"WBOL", 4, 160581},
	{"WBOI", 4, 239330},
	{"WBOG", 4, 219731},
	{"WBOD", 4, 112511},
	{"WBOB", 4, 166985},
	{"WBOA", 4, 59423},
	{"WBNS", 4, 208799},
	{"WBMP", 4, 169247},
	{"WBM", 3, 228033},
	{"WBLU", 4, 128747},
	{"WBLO", 4, 67501},
	{"WBLI", 4, 170608},
	{"WBLE", 4, 162780},
	{"WBLA", 4, 86939},
	{"WBL", 3, 158507},
	{"WBK", 3, 224349},
	{"WBJ", 3, 71403},
	{"WBIZ", 4, 118947},
	{"WBIT", 4, 158715},
	{"WBIS", 4, 166365},
	{"WBIO", 4, 168364},
	{"WBIN", 4, 201401},
	{"WBIL", 4, 98662},
	{"WBIK", 4, 177714},
	{"WBIG", 4, 76134},
	{"WBIE", 4, 135677},
	{"WBIB", 4, 158427},
	{"WBGO", 4, 243886},
	{"WBG", 3, 205824},
	{"WBF", 3, 162506},
	{"WBEY", 4, 196001},
	{"WBET", 4, 70054},
	{"WBER", 4, 58605},
	{"WBEP", 4, 215863},
	{"WBEM", 4, 159222},
	{"WBEL", 4, 152373},
	{"WBEI", 4, 68387},
	{"WBEH", 4, 127271},
	{"WBEG", 4, 78156},
	{"WBEF", 4, 74330},
	{"WBEE", 4, 72011},
	{"WBED", 4, 108200},
	{"WBEC", 4, 53652},
	{"WBEA", 4, 77658},
	{"WBD", 3, 200991},
	{"WBCW", 4, 251780},
	{"WBCSD", 5, 170086},
	{"WBCOM", 5, 233786},
	{"WBCA", 4, 237545},
	{"WBC", 3, 76169},
	{"WBBM", 4, 184516},
	{"WBB", 3, 157984},
	{"WBAY", 4, 216825},
	{"WBAW", 4, 234887},
	{"WBAT", 4, 93053},
	{"WBAS", 4, 70472},
	{"WBAR", 4, 74852},
	{"WBAN", 4, 255780},
	{"WBAL", 4, 214674},
	{"WBAK", 4, 215039},
	{"WBAI", 4, 119082},
	{"WBAG", 4, 219502},
	{"WBAF", 4, 250109},
	{"WBAD", 4, 243565},
	{"WBAC", 4, 53272},
	{"WBAB", 4, 128024},
	{"WBAA", 4, 234888},
	{"WAZZUP", 6, 205332},
	{"WAZU", 4, 172953},
	{"WAZS", 4, 211258},
	{"WAZOO", 5, 163897},
	{"WAZIRISTAN", 10, 185697},
	{"WAZIR", 5, 201476},
	{"WAZI", 4, 98479},
	{"WAZA", 4, 173494},
	{"WAYZATA", 7, 108518},
	{"WAYY", 4, 55349},
	{"WAYWARD", 7, 72298},
	{"WAYW", 4, 30173},
	{"WAYV", 4, 87369},
	{"WAYU", 4, 55120},
	{"WAYT", 4, 3751},
	{"WAYSIDE", 7, 72483},
	{"WAYS", 4, 2298},
	{"WAYR", 4, 50267},
	{"WAYQ", 4, 162781},
	{"WAYPORT", 7, 163784},
	{"WAYPOINTS", 9, 84893},
	{"WAYPOINT", 8, 75278},
	{"WAYP", 4, 41752},
	{"WAYO", 4, 28195},
	{"WAYNESVILLE", 11, 101056},
	{"WAYNESBURG", 10, 108106},
	{"WAYNESBORO", 10, 84005},
	{"WAYNES", 6, 203869},
	{"WAYNE", 5, 7199},
	{"WAYN", 4, 37021},
	{"WAYMAN", 6, 146673},
	{"WAYM", 4, 45482},
	{"WAYLON", 6, 100888},
	{"WAYLAND", 7, 77654},
	{"WAYLAID", 7, 244397},
	{"WAYL", 4, 46999},
	{"WAYK", 4, 98163},
	{"WAYJ", 4, 76267},
	{"WAYI", 4, 10024},
	{"WAYH", 4, 38229},
	{"WAYG", 4, 62337},
	{"WAYFINDING", 10, 141655},
	{"WAYFINDER", 9, 169391},
	{"WAYFARING", 9, 197845},
	{"WAYFARERS", 9, 211591},
	{"WAYFARER", 8, 130963},
	{"WAYF", 4, 7225},
	{"WAYD", 4, 46778},
	{"WAYCROSS", 8, 125690},
	{"WAYC", 4, 42547},
	{"WAYBILL", 7, 171264},
	{"WAYBACK", 7, 88699},
	{"WAYB", 4, 34329},
	{"WAYANS", 6, 118038},
	{"WAYANG", 6, 241495},
	{"WAYAN", 5, 209406},
	{"WAYA", 4, 8292},
	{"WAY", 3, 612},
	{"WAXY", 4, 100702},
	{"WAXWINGS", 8, 227162},
	{"WAXWING", 7, 168874},
	{"WAXW", 4, 162127},
	{"WAXT", 4, 221226},
	{"WAXP", 4, 196608},
	{"WAXO", 4, 248154},
	{"WAXMAN", 6, 79950},
	{"WAXM", 4, 124058},
	{"WAXING", 6, 61006},
	{"WAXI", 4, 140971},
	{"WAXHAW", 6, 206314},
	{"WAXES", 5, 76371},
	{"WAXED", 5, 76151},
	{"WAXE", 4, 131614},
	{"WAXC", 4, 221696},
	{"WAXAHACHIE", 10, 117125},
	{"WAXA", 4, 161772},
	{"WAX", 3, 33468},
	{"WAWR", 4, 160334},
	{"WAWONA", 6, 224603},
	{"WAWO", 4, 106076},
	{"WAWI", 4, 107278},
	{"WAWH", 4, 96024},
	{"WAWE", 4, 112176},
	{"WAWANESA", 8, 246474},
	{"WAWA", 4, 127090},
	{"WAVY", 4, 73504},
	{"WAVS", 4, 111352},
	{"WAVRE", 5, 255065},
	{"WAVO", 4, 195088},
	{"WAVING", 6, 54705},
	{"WAVI", 4, 72505},
	{"WAVEY", 5, 226188},
	{"WAVETEK", 7, 229573},
	{"WAVETABLE", 9, 196741},
	{"WAVES", 5, 9960},
	{"WAVERUNNER", 10, 176580},
	{"WAVERTREE", 9, 252060},
	{"WAVERS", 6, 153105},
	{"WAVERLY", 7, 57276},
	{"WAVERLEY", 8, 75980},
	{"WAVERING", 8, 116860},
	{"WAVERED", 7, 143306},
	{"WAVER", 5, 113222},
	{"WAVENUMBERS", 11, 258654},
	{"WAVENUMBER", 10, 145539},
	{"WAVENEY", 7, 165137},
	{"WAVEMASTER", 10, 201729},
	{"WAVELL", 6, 202632},
	{"WAVELETS", 8, 93799},
	{"WAVELET", 7, 60913},
	{"WAVELENGTHS", 11, 60150},
	{"WAVELENGTH", 10, 41813},
	{"WAVELAND", 8, 128015},
	{"WAVELAN", 7, 195376},
	{"WAVELAB", 7, 198945},
	{"WAVEGUIDES", 10, 111728},
	{"WAVEGUIDE", 9, 76931},
	{"WAVEFUNCTIONS", 13, 188615},
	{"WAVEFUNCTION", 12, 138621},
	{"WAVEFRONT", 9, 91813},
	{"WAVEFORMS", 9, 79877},
	{"WAVEFORM", 8, 48999},
	{"WAVEFLUX", 8, 251046},
	{"WAVED", 5, 65066},
	{"WAVECREST", 9, 235634},
	{"WAVE", 4, 4315},
	{"WAV", 3, 32977},
	{"WAUWATOSA", 9, 119617},
	{"WAUW", 4, 248489},
	{"WAUU", 4, 254432},
	{"WAUTOMA", 7, 203179},
	{"WAUT", 4, 100537},
	{"WAUSHARA", 8, 165381},
	{"WAUSEON", 7, 186552},
	{"WAUSAU", 6, 68546},
	{"WAUS", 4, 104577},
	{"WAURIKA", 7, 261757},
	{"WAUPUN", 6, 174082},
	{"WAUPACA", 7, 113764},
	{"WAUNAKEE", 8, 167365},
	{"WAUKON", 6, 242419},
	{"WAUKESHA", 8, 57615},
	{"WAUKEGAN", 8, 83611},
	{"WAUKEE", 6, 206018},
	{"WAUK", 4, 46182},
	{"WAUGH", 5, 64387},
	{"WAUG", 4, 110469},
	{"WAUCONDA", 8, 156232},
	{"WAUCHULA", 8, 201962},
	{"WAUCHOPE", 8, 221543},
	{"WAUC", 4, 212618},
	{"WAUB", 4, 224195},
	{"WATY", 4, 188873},
	{"WATW", 4, 115153},
	{"WATV", 4, 165239},
	{"WATU", 4, 120428},
	{"WATTS", 5, 262},
	{"WATTON", 6, 167853},
	{"WATTLES", 7, 193865},
	{"WATTLE", 6, 102167},
	{"WATTERSON", 9, 129243},
	{"WATTERS", 7, 99755},
	{"WATTER", 6, 223840},
	{"WATTENBERG", 10, 168608},
	{"WATTEAU", 7, 235181},
	{"WATTAGE", 7, 79062},
	{"WATT", 4, 30866},
	{"WATSONVILLE", 11, 85521},
	{"WATSONS", 7, 152644},
	{"WATSON", 6, 30639},
	{"WATSEKA", 7, 199569},
	{"WATROUS", 7, 169935},
	{"WATP", 4, 104464},
	{"WATONWAN", 8, 242085},
	{"WATONGA", 7, 217054},
	{"WATM", 4, 119882},
	{"WATLINGTON", 10, 202540},
	{"WATLING", 7, 152980},
	{"WATLEY", 6, 202156},
	{"WATL", 4, 89186},
	{"WATKINSVILLE", 12, 179208},
	{"WATKINSON", 9, 162559},
	{"WATKINS", 7, 46120},
	{"WATKIN", 6, 164131},
	{"WATK", 4, 73271},
	{"WATING", 6, 256882},
	{"WATIER", 6, 245630},
	{"WATHER", 6, 249511},
	{"WATHEN", 6, 242892},
	{"WATG", 4, 196927},
	{"WATFORD", 7, 57713},
	{"WATF", 4, 98164},
	{"WATEVER", 7, 259461},
	{"WATES", 5, 231701},
	{"WATERY", 6, 73745},
	{"WATERWORLD", 10, 132134},
	{"WATERWORKS", 10, 89922},
	{"WATERWISE", 9, 247374},
	{"WATERWHEEL", 10, 227043},
	{"WATERWAYS", 9, 49742},
	{"WATERWAY", 8, 60548},
	{"WATERWATCH", 10, 221905},
	{"WATERVLIET", 10, 148997},
	{"WATERVILLE", 10, 72232},
	{"WATERVIEW", 9, 156639},
	{"WATERTOWN", 9, 50764},
	{"WATERTON", 8, 141026},
	{"WATERTIGHT", 10, 93808},
	{"WATERTHRUSH", 11, 247358},
	{"WATERSTONES", 11, 232530},
	{"WATERSTONE", 10, 171459},
	{"WATERSTON", 9, 163969},
	{"WATERSPORTS", 11, 50401},
	{"WATERSPORT", 10, 81929},
	{"WATERSON", 8, 172217},
	{"WATERSMEET", 10, 215345},
	{"WATERSLIDES", 11, 165470},
	{"WATERSLIDE", 10, 162642},
	{"WATERSKIS", 9, 214555},
	{"WATERSKIING", 11, 73786},
	{"WATERSKI", 8, 180401},
	{"WATERSIDE", 9, 79655},
	{"WATERSHIP", 9, 160024},
	{"WATERSHEDS", 10, 57556},
	{"WATERSHED", 9, 34536},
	{"WATERSCAPES", 11, 201202},
	{"WATERSCAPE", 10, 245670},
	{"WATERS", 6, 7228},
	{"WATERPROOFS", 11, 137806},
	{"WATERPROOFING", 13, 71674},
	{"WATERPROOF", 10, 35342},
	{"WATERPOLO", 9, 158853},
	{"WATERPIK", 8, 153149},
	{"WATERPARKS", 10, 255830},
	{"WATERPARK", 9, 106130},
	{"WATERMILL", 9, 165123},
	{"WATERMEN", 8, 251591},
	{"WATERMELONS", 11, 121006},
	{"WATERMELON", 10, 64695},
	{"WATERMASYSK", 11, 233556},
	{"WATERMARKS", 10, 82345},
	{"WATERMARKING", 12, 86311},
	{"WATERMARKED", 11, 115581},
	{"WATERMARK", 9, 55503},
	{"WATERMAN", 8, 64516},
	{"WATERLOW", 8, 256764},
	{"WATERLOOVILLE", 13, 144106},
	{"WATERLOO", 8, 38248},
	{"WATERLOGGING", 12, 230972},
	{"WATERLOGGED", 11, 152822},
	{"WATERLINE", 9, 111943},
	{"WATERLILY", 9, 178483},
	{"WATERLILIES", 11, 236176},
	{"WATERLESS", 9, 121045},
	{"WATERLAND", 9, 251723},
	{"WATERKANT", 9, 177595},
	{"WATERJET", 8, 144791},
	{"WATERING", 8, 47987},
	{"WATERHOUSE", 10, 68174},
	{"WATERHOLE", 9, 149820},
	{"WATERHEMP", 9, 193824},
	{"WATERGATE", 9, 68944},
	{"WATERFRONTS", 11, 231879},
	{"WATERFRONT", 10, 37365},
	{"WATERFOWL", 9, 62159},
	{"WATERFORD", 9, 41084},
	{"WATERFIELD", 10, 171039},
	{"WATERFALLS", 10, 53109},
	{"WATERFALL", 9, 47479},
	{"WATERERS", 8, 194315},
	{"WATERER", 7, 230488},
	{"WATERED", 7, 71872},
	{"WATERDOWN", 9, 158238},
	{"WATERDEEP", 9, 235283},
	{"WATERCRESS", 10, 125482},
	{"WATERCRAFT", 10, 58859},
	{"WATERCOURSES", 12, 108844},
	{"WATERCOURSE", 11, 101661},
	{"WATERCOOLING", 12, 134150},
	{"WATERCOOLER", 11, 85927},
	{"WATERCOOLED", 11, 205475},
	{"WATERCOLOURS", 12, 104657},
	{"WATERCOLOUR", 11, 67764},
	{"WATERCOLORS", 11, 77035},
	{"WATERCOLOR", 10, 49140},
	{"WATERCHUTES", 11, 210182},
	{"WATERBURY", 9, 65237},
	{"WATERBUCK", 9, 233029},
	{"WATERBROOK", 10, 189715},
	{"WATERBOYS", 9, 180924},
	{"WATERBOY", 8, 180375},
	{"WATERBORO", 9, 202165},
	{"WATERBORNE", 10, 84387},
	{"WATERBODY", 9, 91777},
	{"WATERBODIES", 11, 139143},
	{"WATERBLOCK", 10, 234550},
	{"WATERBIRTH", 10, 256236},
	{"WATERBIRDS", 10, 150891},
	{"WATERBIRD", 9, 177902},
	{"WATERBERG", 9, 161191},
	{"WATERBEDS", 9, 170696},
	{"WATERBED", 8, 119160},
	{"WATERBASED", 10, 239265},
	{"WATERAID", 8, 184643},
	{"WATER", 5, 1126},
	{"WATD", 4, 171391},
	{"WATCOM", 6, 180552},
	{"WATCHZONE", 9, 159904},
	{"WATCHWORD", 9, 169487},
	{"WATCHUNG", 8, 183590},
	{"WATCHTOWERS", 11, 253025},
	{"WATCHTOWER", 10, 84655},
	{"WATCHMEN", 8, 109980},
	{"WATCHMAN", 8, 83983},
	{"WATCHMAKING", 11, 136059},
	{"WATCHMAKERS", 11, 174423},
	{"WATCHMAKER", 10, 110330},
	{"WATCHLISTS", 10, 227853},
	{"WATCHLIST", 9, 51304},
	{"WATCHING", 8, 5606},
	{"WATCHIN", 7, 120196},
	{"WATCHGUARD", 10, 89761},
	{"WATCHFULNESS", 12, 217558},
	{"WATCHFUL", 8, 77748},
	{"WATCHFIRE", 9, 193105},
	{"WATCHET", 7, 234501},
	{"WATCHES", 7, 2740},
	{"WATCHERS", 8, 50047},
	{"WATCHERHOST", 11, 242367},
	{"WATCHER", 7, 54199},
	{"WATCHED", 7, 28472},
	{"WATCHE", 6, 212694},
	{"WATCHDOGS", 9, 122280},
	{"WATCHDOG", 8, 45831},
	{"WATCHBLOG", 9, 214562},
	{"WATCHBANDS", 10, 254552},
	{"WATCHBAND", 9, 231961},
	{"WATCHABLE", 9, 123316},
	{"WATCHA", 6, 203586},
	{"WATCH", 5, 1291},
	{"WATC", 4, 194005},
	{"WATB", 4, 142397},
	{"WATAUGA", 7, 100547},
	{"WATASHI", 7, 161282},
	{"WATASE", 6, 256545},
	{"WATARU", 6, 229618},
	{"WATARA", 6, 163628},
	{"WATANABE", 8, 63540},
	{"WATAN", 5, 220302},
	{"WASZ", 4, 131946},
	{"WASX", 4, 241297},
	{"WASW", 4, 6598},
	{"WASV", 4, 32590},
	{"WASU", 4, 7516},
	{"WASTING", 7, 43447},
	{"WASTIN", 6, 231216},
	{"WASTEWATERS", 11, 164705},
	{"WASTEWATER", 10, 37323},
	{"WASTES", 6, 40447},
	{"WASTERS", 7, 126212},
	{"WASTER", 6, 134607},
	{"WASTEPAPER", 10, 240639},
	{"WASTELANDS", 10, 150695},
	{"WASTELAND", 9, 66388},
	{"WASTEGATE", 9, 229563},
	{"WASTEFUL", 8, 78534},
	{"WASTED", 6, 40347},
	{"WASTEBASKETS", 12, 166682},
	{"WASTEBASKET", 11, 131400},
	{"WASTE", 5, 5832},
	{"WASTAGE", 7, 108473},
	{"WASSUP", 6, 129772},
	{"WASSON", 6, 124911},
	{"WASSILY", 7, 129200},
	{"WASSERSTEIN", 11, 129813},
	{"WASSERMAN", 9, 89074},
	{"WASSER", 6, 111994},
	{"WASSENAAR", 9, 181388},
	{"WASSAT", 6, 248308},
	{"WASSAIL", 7, 200059},
	{"WASR", 4, 3025},
	{"WASQ", 4, 44235},
	{"WASPS", 5, 70000},
	{"WASP", 4, 53692},
	{"WASON", 5, 253995},
	{"WASNT", 5, 56777},
	{"WASMACHINE", 10, 212327},
	{"WASL", 4, 149531},
	{"WASKOM", 6, 242308},
	{"WASK", 4, 30604},
	{"WASJ", 4, 32103},
	{"WASIM", 5, 174390},
	{"WASILLA", 7, 117607},
	{"WASHY", 5, 152621},
	{"WASHU", 5, 190455},
	{"WASHTENAW", 9, 99444},
	{"WASHSTAND", 9, 261301},
	{"WASHROOMS", 9, 136101},
	{"WASHROOM", 8, 87158},
	{"WASHOUT", 7, 118493},
	{"WASHOUGAL", 9, 152686},
	{"WASHOE", 6, 85629},
	{"WASHLAW", 7, 197203},
	{"WASHITA", 7, 167017},
	{"WASHINTON", 9, 163567},
	{"WASHINGTONVILLE", 15, 177632},
	{"WASHINGTONUSA", 13, 260186},
	{"WASHINGTONPOSRCOM", 17, 233965},
	{"WASHINGTONIANS", 14, 248763},
	{"WASHINGTONIAN", 13, 170915},
	{"WASHINGTON", 10, 1370},
	{"WASHINGS", 8, 164173},
	{"WASHING", 7, 30688},
	{"WASHIN", 6, 209239},
	{"WASHI", 5, 190878},
	{"WASHES", 6, 63905},
	{"WASHERS", 7, 47062},
	{"WASHER", 6, 35535},
	{"WASHED", 6, 38742},
	{"WASHDOWN", 8, 173292},
	{"WASHCLOTHS", 10, 140442},
	{"WASHCLOTH", 9, 121895},
	{"WASHBURN", 8, 55586},
	{"WASHBOARD", 9, 156400},
	{"WASHBASIN", 9, 149369},
	{"WASHAKIE", 8, 182025},
	{"WASHABLE", 8, 47757},
	{"WASH", 4, 6651},
	{"WASG", 4, 170048},
	{"WASF", 4, 3628},
	{"WASEDA", 6, 147728},
	{"WASECA", 6, 139878},
	{"WASE", 4, 4579},
	{"WASCO", 5, 108926},
	{"WASCHK", 6, 134719},
	{"WASCANA", 7, 239684},
	{"WASC", 4, 142351},
	{"WASB", 4, 3519},
	{"WASATCH", 7, 79775},
	{"WASAT", 5, 233212},
	{"WASANAETHAU", 11, 233138},
	{"WASALLAM", 8, 185932},
	{"WASAGA", 6, 155943},
	{"WASABI", 6, 88006},
	{"WAS", 3, 718},
	{"WARZONE", 7, 111681},
	{"WARZ", 4, 197245},
	{"WARY", 4, 56111},
	{"WARWICKSHIRE", 12, 44729},
	{"WARWICK", 7, 38250},
	{"WARW", 4, 40284},
	{"WARV", 4, 72028},
	{"WARUNKI", 7, 247774},
	{"WARUM", 5, 112800},
	{"WARU", 4, 92722},
	{"WARTY", 5, 150993},
	{"WARTS", 5, 59267},
	{"WARTON", 6, 185133},
	{"WARTIME", 7, 56492},
	{"WARTHOGS", 8, 242086},
	{"WARTHOG", 7, 105510},
	{"WARTEN", 6, 227795},
	{"WARTBURG", 8, 104752},
	{"WART", 4, 80701},
	{"WARSZAWA", 8, 87764},
	{"WARSZ", 5, 254066},
	{"WARSONG", 7, 208569},
	{"WARSHIPS", 8, 82095},
	{"WARSHIP", 7, 89745},
	{"WARSHAW", 7, 205953},
	{"WARSCHAU", 8, 122184},
	{"WARSAW", 6, 39760},
	{"WARS", 4, 4471},
	{"WARROAD", 7, 206808},
	{"WARRNAMBOOL", 11, 103957},
	{"WARRIORS", 8, 34020},
	{"WARRIOR", 7, 30189},
	{"WARRINGTON", 10, 54721},
	{"WARRINGAH", 9, 179285},
	{"WARRING", 7, 85528},
	{"WARRINER", 8, 230439},
	{"WARRIER", 7, 214951},
	{"WARRICK", 7, 84735},
	{"WARRI", 5, 205649},
	{"WARRENVILLE", 11, 121923},
	{"WARRENTY", 8, 148372},
	{"WARRENTON", 9, 83939},
	{"WARRENSVILLE", 12, 172719},
	{"WARRENSBURG", 11, 107162},
	{"WARRENS", 7, 170435},
	{"WARRENDALE", 10, 185513},
	{"WARREN", 6, 8732},
	{"WARRE", 5, 225872},
	{"WARRANTY", 8, 3693},
	{"WARRANTS", 8, 41536},
	{"WARRANTLESS", 11, 94587},
	{"WARRANTING", 10, 146307},
	{"WARRANTIES", 10, 31335},
	{"WARRANTEES", 10, 179040},
	{"WARRANTEE", 9, 145649},
	{"WARRANTED", 9, 49399},
	{"WARRANTECH", 10, 161648},
	{"WARRANT", 7, 29565},
	{"WARRANDYTE", 10, 227582},
	{"WARRAGUL", 8, 184463},
	{"WARRA", 5, 257117},
	{"WARR", 4, 95734},
	{"WARPS", 5, 142709},
	{"WARPLANES", 9, 129324},
	{"WARPLANE", 8, 234846},
	{"WARPING", 7, 94193},
	{"WARPED", 6, 62543},
	{"WARPATH", 7, 171213},
	{"WARP", 4, 45600},
	{"WARO", 4, 40389},
	{"WARNUNG", 7, 196521},
	{"WARNS", 5, 43507},
	{"WARNOCK", 7, 100668},
	{"WARNKE", 6, 205075},
	{"WARNINGSRC", 10, 254455},
	{"WARNINGS", 8, 30374},
	{"WARNING", 7, 6698},
	{"WARNICK", 7, 230189},
	{"WARNG", 5, 228185},
	{"WARNES", 6, 178579},
	{"WARNERS", 7, 120296},
	{"WARNER", 6, 9164},
	{"WARNELL", 7, 235828},
	{"WARNED", 6, 36122},
	{"WARNE", 5, 83182},
	{"WARN", 4, 5592},
	{"WARMWATER", 9, 214762},
	{"WARMUPS", 7, 206486},
	{"WARMUP", 6, 108397},
	{"WARMTH", 6, 34912},
	{"WARMS", 5, 82167},
	{"WARMONGERS", 10, 202810},
	{"WARMONGERING", 12, 223523},
	{"WARMONGER", 9, 151433},
	{"WARMLY", 6, 63795},
	{"WARMINSTER", 10, 99102},
	{"WARMING", 7, 32616},
	{"WARMEST", 7, 74470},
	{"WARMERS", 7, 62355},
	{"WARMERDAM", 9, 176359},
	{"WARMER", 6, 43578},
	{"WARMED", 6, 65437},
	{"WARMBLOOD", 9, 152612},
	{"WARMASTER", 9, 245212},
	{"WARMAN", 6, 163296},
	{"WARMACHINE", 10, 198460},
	{"WARM", 4, 4035},
	{"WARLORDS", 8, 80476},
	{"WARLORD", 7, 76478},
	{"WARLOCKS", 8, 136666},
	{"WARLOCK", 7, 65904},
	{"WARLINGHAM", 10, 244277},
	{"WARLIKE", 7, 116113},
	{"WARLICK", 7, 230901},
	{"WARLEY", 6, 176752},
	{"WARLAND", 7, 234960},
	{"WARL", 4, 58061},
	{"WARKWORTH", 9, 151796},
	{"WARKS", 5, 219644},
	{"WARKENTIN", 9, 231191},
	{"WARKANOID", 9, 211744},
	{"WARK", 4, 139248},
	{"WARJ", 4, 126579},
	{"WARIS", 5, 209221},
	{"WARIOWARE", 9, 175209},
	{"WARIO", 5, 121318},
	{"WARING", 6, 75262},
	{"WARINESS", 8, 205348},
	{"WARINER", 7, 217202},
	{"WARILY", 6, 148248},
	{"WARHORSE", 8, 208279},
	{"WARHOLS", 7, 105324},
	{"WARHOL", 6, 61445},
	{"WARHEADS", 8, 85760},
	{"WARHEAD", 7, 92496},
	{"WARHAWK", 7, 203527},
	{"WARHAMMER", 9, 56848},
	{"WARH", 4, 44765},
	{"WARGO", 5, 191329},
	{"WARGAMING", 9, 124243},
	{"WARGAMES", 8, 78766},
	{"WARGAMER", 8, 219246},
	{"WARGAME", 7, 120131},
	{"WARFIGHTING", 11, 119812},
	{"WARFIGHTERS", 11, 206398},
	{"WARFIGHTER", 10, 98420},
	{"WARFIELD", 8, 97078},
	{"WARFARIN", 8, 79561},
	{"WARFARE", 7, 36632},
	{"WARF", 4, 160028},
	{"WAREZ", 5, 45761},
	{"WAREWULF", 8, 137916},
	{"WAREWASHING", 11, 153888},
	{"WARESDIRECT", 11, 251935},
	{"WARES", 5, 57526},
	{"WARENKORB", 9, 86843},
	{"WAREN", 5, 112753},
	{"WAREING", 7, 191697},
	{"WAREHOUSING", 11, 41793},
	{"WAREHOUSES", 10, 52008},
	{"WAREHOUSEMAN", 12, 228114},
	{"WAREHOUSED", 10, 233698},
	{"WAREHOUSE", 9, 35814},
	{"WAREHAM", 7, 84314},
	{"WARE", 4, 36124},
	{"WARDWELL", 8, 257590},
	{"WARDS", 5, 50461},
	{"WARDROP", 7, 234349},
	{"WARDROBES", 9, 85277},
	{"WARDROBE", 8, 40104},
	{"WARDRIVING", 10, 137604},
	{"WARDOUR", 7, 229663},
	{"WARDNER", 7, 214399},
	{"WARDMAN", 7, 218973},
	{"WARDLOW", 7, 231271},
	{"WARDLEY", 7, 197851},
	{"WARDLE", 6, 137202},
	{"WARDLAW", 7, 156929},
	{"WARDING", 7, 162803},
	{"WARDERS", 7, 223216},
	{"WARDER", 6, 147796},
	{"WARDENS", 7, 84902},
	{"WARDEN", 6, 52503},
	{"WARDELL", 7, 127791},
	{"WARDED", 6, 222499},
	{"WARDE", 5, 232214},
	{"WARDA", 5, 179243},
	{"WARD", 4, 7712},
	{"WARCRY", 6, 87643},
	{"WARCRAFT", 8, 34111},
	{"WARCHILD", 8, 190626},
	{"WARC", 4, 208459},
	{"WARBURTON", 9, 101558},
	{"WARBURG", 7, 101162},
	{"WARBLOGGING", 11, 261545},
	{"WARBLOG", 7, 226119},
	{"WARBLING", 8, 173954},
	{"WARBLES", 7, 219434},
	{"WARBLERS", 8, 105228},
	{"WARBLER", 7, 57570},
	{"WARBLE", 6, 188761},
	{"WARBIRDS", 8, 136478},
	{"WARBIRD", 7, 129439},
	{"WARB", 4, 46029},
	{"WARATAHS", 8, 185148},
	{"WARATAH", 7, 151231},
	{"WARANTY", 7, 225442},
	{"WARANGAL", 8, 217144},
	{"WARA", 4, 214198},
	{"WAR", 3, 1332},
	{"WAQU", 4, 169088},
	{"WAQT", 4, 211317},
	{"WAQF", 4, 247125},
	{"WAQAR", 5, 193844},
	{"WAQ", 3, 35651},
	{"WAPW", 4, 198211},
	{"WAPU", 4, 157896},
	{"WAPS", 4, 237936},
	{"WAPR", 4, 82216},
	{"WAPPINGERS", 10, 168209},
	{"WAPPING", 7, 154983},
	{"WAPP", 4, 118742},
	{"WAPO", 4, 107073},
	{"WAPM", 4, 195251},
	{"WAPLES", 6, 249749},
	{"WAPL", 4, 125761},
	{"WAPITI", 6, 168333},
	{"WAPH", 4, 176018},
	{"WAPF", 4, 260448},
	{"WAPENS", 6, 191900},
	{"WAPEN", 5, 169942},
	{"WAPELLO", 7, 165095},
	{"WAPE", 4, 95724},
	{"WAPDA", 5, 228358},
	{"WAPD", 4, 224632},
	{"WAPB", 4, 248155},
	{"WAPATO", 6, 198670},
	{"WAPAKONETA", 10, 160466},
	{"WAPA", 4, 235697},
	{"WAOR", 4, 180873},
	{"WAOF", 4, 188874},
	{"WANZ", 4, 156621},
	{"WANY", 4, 52580},
	{"WANW", 4, 85875},
	{"WANV", 4, 241017},
	{"WANU", 4, 97631},
	{"WANTS", 5, 3845},
	{"WANTONNESSE", 11, 203886},
	{"WANTONNESS", 10, 256868},
	{"WANTONLY", 8, 177252},
	{"WANTON", 6, 80104},
	{"WANTLIST", 8, 164558},
	{"WANTIRNA", 8, 190980},
	{"WANTING", 7, 31750},
	{"WANTIN", 6, 250740},
	{"WANTED", 6, 2130},
	{"WANTAGH", 7, 140140},
	{"WANTAGE", 7, 118376},
	{"WANTA", 5, 212353},
	{"WANT", 4, 810},
	{"WANSTEAD", 8, 163675},
	{"WANSBECK", 8, 184009},
	{"WANR", 4, 99571},
	{"WANP", 4, 110525},
	{"WANNSEE", 7, 257967},
	{"WANNEROO", 8, 196728},
	{"WANNER", 6, 187374},
	{"WANNEER", 7, 176818},
	{"WANNABES", 8, 112790},
	{"WANNABEES", 9, 216351},
	{"WANNABEE", 8, 259914},
	{"WANNABE", 7, 65184},
	{"WANNA", 5, 28497},
	{"WANM", 4, 119459},
	{"WANLESS", 7, 188909},
	{"WANL", 4, 115749},
	{"WANKSTA", 7, 160624},
	{"WANKING", 7, 64704},
	{"WANKERS", 7, 144067},
	{"WANKER", 6, 110067},
	{"WANKEL", 6, 261775},
	{"WANK", 4, 68815},
	{"WANJ", 4, 156320},
	{"WANITA", 6, 188637},
	{"WANING", 6, 66576},
	{"WANGI", 5, 223893},
	{"WANGARI", 7, 225759},
	{"WANGARATTA", 10, 131675},
	{"WANGANUI", 8, 74878},
	{"WANG", 4, 33066},
	{"WANF", 4, 124754},
	{"WANESSA", 7, 103286},
	{"WANES", 5, 178961},
	{"WANED", 5, 121560},
	{"WANDSWORTH", 10, 73377},
	{"WANDS", 5, 72308},
	{"WANDO", 5, 249037},
	{"WANDERS", 7, 88047},
	{"WANDERLUST", 10, 90517},
	{"WANDERINGS", 10, 100280},
	{"WANDERING", 9, 46045},
	{"WANDERERS", 9, 64810},
	{"WANDERER", 8, 71340},
	{"WANDERED", 8, 61297},
	{"WANDER", 6, 28174},
	{"WANDEL", 6, 190317},
	{"WANDA", 5, 54160},
	{"WAND", 4, 49318},
	{"WANCHAI", 7, 160440},
	{"WANC", 4, 58494},
	{"WANB", 4, 106380},
	{"WANAQUE", 7, 240230},
	{"WANANGA", 7, 154013},
	{"WANAMAKER", 9, 151626},
	{"WANAKA", 6, 94010},
	{"WANADOO", 7, 82515},
	{"WAMY", 4, 133304},
	{"WAMU", 4, 135180},
	{"WAMT", 4, 163764},
	{"WAMSUTTA", 8, 130481},
	{"WAMPUM", 6, 119993},
	{"WAMPLER", 7, 154078},
	{"WAMPANOAG", 9, 190871},
	{"WAMP", 4, 157493},
	{"WAMO", 4, 84579},
	{"WAMEGO", 6, 205986},
	{"WAME", 4, 62398},
	{"WAMBACH", 7, 257303},
	{"WAMB", 4, 123324},
	{"WALZER", 6, 156572},
	{"WALZ", 4, 115604},
	{"WALWORTH", 8, 92639},
	{"WALW", 4, 113788},
	{"WALVIS", 6, 176294},
	{"WALVERINE", 9, 158833},
	{"WALV", 4, 260051},
	{"WALU", 4, 161773},
	{"WALTZING", 8, 130804},
	{"WALTZES", 7, 120378},
	{"WALTZ", 5, 50829},
	{"WALTRIP", 7, 90683},
	{"WALTONS", 7, 123867},
	{"WALTON", 6, 39236},
	{"WALTMAN", 7, 192034},
	{"WALTHERS", 8, 149026},
	{"WALTHER", 7, 75341},
	{"WALTHAMSTOW", 11, 102053},
	{"WALTHAM", 7, 50878},
	{"WALTHALL", 8, 180804},
	{"WALTERS", 7, 47700},
	{"WALTERBORO", 10, 152452},
	{"WALTER", 6, 9111},
	{"WALTARI", 7, 257879},
	{"WALT", 4, 34004},
	{"WALSTON", 7, 180908},
	{"WALSINGHAM", 10, 150171},
	{"WALSHE", 6, 211700},
	{"WALSHAM", 7, 156686},
	{"WALSH", 5, 38016},
	{"WALSER", 6, 140958},
	{"WALSENBURG", 10, 190610},
	{"WALSCH", 6, 201630},
	{"WALSALL", 7, 60935},
	{"WALRUSES", 8, 231797},
	{"WALRUS", 6, 81958},
	{"WALRATH", 7, 243516},
	{"WALRASIAN", 9, 258876},
	{"WALR", 4, 106104},
	{"WALPOLE", 7, 74485},
	{"WALPAPER", 8, 193003},
	{"WALO", 4, 54402},
	{"WALNUTS", 7, 73367},
	{"WALNUT", 6, 35621},
	{"WALN", 4, 74506},
	{"WALMSLEY", 8, 130616},
	{"WALMER", 6, 196239},
	{"WALMART", 7, 46435},
	{"WALM", 4, 247329},
	{"WALLY", 5, 53928},
	{"WALLSTREET", 10, 141831},
	{"WALLSEND", 8, 131787},
	{"WALLS", 5, 7709},
	{"WALLPLATES", 10, 164531},
	{"WALLPLATE", 9, 227366},
	{"WALLPAPERZONE", 13, 261414},
	{"WALLPAPERS", 10, 7509},
	{"WALLPAPERING", 12, 201266},
	{"WALLPAPER", 9, 5915},
	{"WALLPAPE", 8, 258625},
	{"WALLOWING", 9, 143381},
	{"WALLOWA", 7, 123428},
	{"WALLOW", 6, 122436},
	{"WALLOPS", 7, 155024},
	{"WALLOP", 6, 117825},
	{"WALLOON", 7, 134443},
	{"WALLONIA", 8, 195560},
	{"WALLNER", 7, 197334},
	{"WALLMOUNTING", 12, 92957},
	{"WALLMOUNT", 9, 160144},
	{"WALLLPAPER", 10, 234151},
	{"WALLKILL", 8, 181447},
	{"WALLIS", 6, 40480},
	{"WALLINGTON", 10, 111138},
	{"WALLINGFORD", 11, 66730},
	{"WALLING", 7, 90150},
	{"WALLIN", 6, 128130},
	{"WALLIES", 7, 151945},
	{"WALLIE", 6, 225884},
	{"WALLICE", 7, 133834},
	{"WALLHANGINGS", 12, 251425},
	{"WALLHANGING", 11, 188756},
	{"WALLHACK", 8, 205856},
	{"WALLFLOWERS", 11, 131502},
	{"WALLFLOWER", 10, 137642},
	{"WALLEYES", 8, 162494},
	{"WALLEYE", 7, 67283},
	{"WALLEY", 6, 151227},
	{"WALLETS", 7, 42718},
	{"WALLET", 6, 34266},
	{"WALLERSTEIN", 11, 159058},
	{"WALLER", 6, 60334},
	{"WALLENSTEIN", 11, 169575},
	{"WALLENBERG", 10, 156793},
	{"WALLEN", 6, 153738},
	{"WALLED", 6, 60081},
	{"WALLE", 5, 182461},
	{"WALLDORF", 8, 230908},
	{"WALLCOVERINGS", 13, 113436},
	{"WALLCOVERING", 12, 128796},
	{"WALLCLOCK", 9, 232924},
	{"WALLBOARD", 9, 135614},
	{"WALLASEY", 8, 138158},
	{"WALLAROO", 8, 189604},
	{"WALLACH", 7, 111125},
	{"WALLACEBURG", 11, 187263},
	{"WALLACE", 7, 30227},
	{"WALLABY", 7, 115041},
	{"WALLABIES", 9, 112240},
	{"WALLA", 5, 52938},
	{"WALL", 4, 1834},
	{"WALKY", 5, 201054},
	{"WALKWAYS", 8, 75600},
	{"WALKWAY", 7, 67315},
	{"WALKUP", 6, 142546},
	{"WALKTHRU", 8, 223364},
	{"WALKTHROUGHS", 12, 57967},
	{"WALKTHROUGH", 11, 53347},
	{"WALKS", 5, 31348},
	{"WALKOVER", 8, 201695},
	{"WALKOUT", 7, 122873},
	{"WALKMEN", 7, 150131},
	{"WALKMANS", 8, 158849},
	{"WALKMAN", 7, 49510},
	{"WALKLEY", 7, 222154},
	{"WALKING", 7, 30364},
	{"WALKIN", 6, 77806},
	{"WALKIE", 6, 75867},
	{"WALKETH", 7, 249697},
	{"WALKERVILLE", 11, 175708},
	{"WALKERTON", 9, 135807},
	{"WALKERTEK", 9, 222536},
	{"WALKERSVILLE", 12, 197077},
	{"WALKERS", 7, 53037},
	{"WALKERA", 7, 176582},
	{"WALKER", 6, 7720},
	{"WALKEN", 6, 99862},
	{"WALKED", 6, 10043},
	{"WALKE", 5, 209048},
	{"WALKDEN", 7, 256895},
	{"WALKATHON", 9, 242964},
	{"WALKAROUND", 10, 155664},
	{"WALKABOUTS", 10, 196880},
	{"WALKABOUT", 9, 95775},
	{"WALKABLE", 8, 137350},
	{"WALK", 4, 1359},
	{"WALID", 5, 122148},
	{"WALIBI", 6, 226709},
	{"WALI", 4, 136645},
	{"WALHALLA", 8, 141344},
	{"WALH", 4, 165240},
	{"WALGREENS", 9, 73522},
	{"WALGREEN", 8, 105209},
	{"WALG", 4, 115750},
	{"WALFORD", 7, 118083},
	{"WALF", 4, 86828},
	{"WALESKA", 7, 254304},
	{"WALESA", 6, 189532},
	{"WALES", 5, 4193},
	{"WALEED", 6, 165573},
	{"WALE", 4, 98242},
	{"WALDWICK", 8, 193146},
	{"WALDROP", 7, 140297},
	{"WALDRON", 7, 77242},
	{"WALDPORT", 8, 192467},
	{"WALDORF", 7, 56430},
	{"WALDON", 6, 216996},
	{"WALDOCK", 7, 173464},
	{"WALDOBORO", 9, 221015},
	{"WALDO", 5, 56435},
	{"WALDNER", 7, 158325},
	{"WALDMANN", 8, 193701},
	{"WALDMAN", 7, 100787},
	{"WALDHEIM", 8, 226145},
	{"WALDER", 6, 193469},
	{"WALDENBOOKS", 11, 175418},
	{"WALDEN", 6, 51638},
	{"WALDEMAR", 8, 130594},
	{"WALDECK", 7, 211242},
	{"WALDBUSSER", 10, 163807},
	{"WALD", 4, 69725},
	{"WALCZAK", 7, 226817},
	{"WALCOTT", 7, 90776},
	{"WALCH", 5, 200609},
	{"WALC", 4, 92030},
	{"WALBURG", 7, 244635},
	{"WALBRO", 6, 207327},
	{"WALBRIDGE", 9, 198169},
	{"WALBERG", 7, 204748},
	{"WALBAUM", 7, 236043},
	{"WALB", 4, 235407},
	{"WALANG", 6, 170511},
	{"WALA", 4, 107753},
	{"WAL", 3, 31062},
	{"WAKW", 4, 170882},
	{"WAKUNAGA", 8, 228888},
	{"WAKULLA", 7, 136447},
	{"WAKU", 4, 256208},
	{"WAKTU", 5, 238979},
	{"WAKT", 4, 250817},
	{"WAKS", 4, 164564},
	{"WAKO", 4, 169287},
	{"WAKKA", 5, 139883},
	{"WAKK", 4, 255283},
	{"WAKING", 6, 46248},
	{"WAKH", 4, 242164},
	{"WAKEY", 5, 243384},
	{"WAKEUP", 6, 91460},
	{"WAKESKATES", 10, 244099},
	{"WAKES", 5, 64781},
	{"WAKER", 5, 115693},
	{"WAKENED", 7, 216558},
	{"WAKEN", 5, 200257},
	{"WAKEMAN", 7, 95143},
	{"WAKELY", 6, 211570},
	{"WAKELING", 8, 205528},
	{"WAKELIN", 7, 212385},
	{"WAKELEY", 7, 229031},
	{"WAKEHAM", 7, 215594},
	{"WAKEFULNESS", 11, 146919},
	{"WAKEFUL", 7, 243154},
	{"WAKEFORD", 8, 260028},
	{"WAKEFIELD", 9, 45324},
	{"WAKED", 5, 163957},
	{"WAKEBOARDS", 10, 123241},
	{"WAKEBOARDING", 12, 71400},
	{"WAKEBOARD", 9, 82181},
	{"WAKE", 4, 5275},
	{"WAKAYAMA", 8, 156263},
	{"WAKATIPU", 8, 258319},
	{"WAKARUSA", 8, 186577},
	{"WAKAMATSU", 9, 201812},
	{"WAKABAYASHI", 11, 222703},
	{"WAKA", 4, 118478},
	{"WAJU", 4, 178177},
	{"WAJO", 4, 246934},
	{"WAJI", 4, 202392},
	{"WAJDA", 5, 225411},
	{"WAJ", 3, 7027},
	{"WAIW", 4, 253537},
	{"WAIVING", 7, 91963},
	{"WAIVES", 6, 95449},
	{"WAIVERS", 7, 56133},
	{"WAIVERED", 8, 201351},
	{"WAIVER", 6, 35352},
	{"WAIVED", 6, 48723},
	{"WAIVE", 5, 50185},
	{"WAIV", 4, 56408},
	{"WAITT", 5, 232621},
	{"WAITSTAFF", 9, 174387},
	{"WAITSFIELD", 10, 164589},
	{"WAITS", 5, 45852},
	{"WAITROSE", 8, 130711},
	{"WAITRESSES", 10, 103821},
	{"WAITRESS", 8, 59450},
	{"WAITPID", 7, 196529},
	{"WAITOMO", 7, 160380},
	{"WAITLISTED", 10, 209143},
	{"WAITLIST", 8, 114442},
	{"WAITLEY", 7, 247186},
	{"WAITING", 7, 4139},
	{"WAITIN", 6, 102497},
	{"WAITH", 5, 140827},
	{"WAITES", 6, 201362},
	{"WAITERS", 7, 76330},
	{"WAITER", 6, 54915},
	{"WAITEMATA", 9, 237292},
	{"WAITED", 6, 39169},
	{"WAITEC", 6, 161755},
	{"WAITE", 5, 67766},
	{"WAITARA", 7, 236972},
	{"WAITANGI", 8, 112261},
	{"WAITAKI", 7, 178382},
	{"WAITAKERE", 9, 112831},
	{"WAIT", 4, 1441},
	{"WAISTS", 6, 170031},
	{"WAISTLINES", 10, 258447},
	{"WAISTLINE", 9, 118019},
	{"WAISTED", 7, 143845},
	{"WAISTCOATS", 10, 142492},
	{"WAISTCOAT", 9, 105058},
	{"WAISTBAND", 9, 69542},
	{"WAIST", 5, 32653},
	{"WAIROA", 6, 206015},
	{"WAIRAU", 6, 253981},
	{"WAIRARAPA", 9, 88194},
	{"WAIR", 4, 69553},
	{"WAIPIO", 6, 227653},
	{"WAIPARA", 7, 258858},
	{"WAIPAHU", 7, 127975},
	{"WAIP", 4, 178753},
	{"WAINWRIGHT", 10, 62099},
	{"WAINSCOTT", 9, 196335},
	{"WAINSCOTING", 11, 195832},
	{"WAINSCOT", 8, 242531},
	{"WAINFLEET", 9, 251748},
	{"WAIMEA", 6, 101472},
	{"WAIMATE", 7, 217237},
	{"WAIMANALO", 9, 171133},
	{"WAIM", 4, 136508},
	{"WAILUKU", 7, 115418},
	{"WAILUA", 6, 180627},
	{"WAILS", 5, 156594},
	{"WAILPAPER", 9, 236476},
	{"WAILING", 7, 83926},
	{"WAILERS", 7, 106063},
	{"WAILED", 6, 147449},
	{"WAILEA", 6, 88535},
	{"WAIL", 4, 95572},
	{"WAIKOLOA", 8, 107250},
	{"WAIKIKI", 7, 53880},
	{"WAIKATO", 7, 55339},
	{"WAIKANAE", 8, 225459},
	{"WAIK", 4, 105715},
	{"WAIHOPAI", 8, 224583},
	{"WAIHI", 5, 192963},
	{"WAIHEKE", 7, 144051},
	{"WAIG", 4, 259254},
	{"WAIFS", 5, 196580},
	{"WAIF", 4, 166493},
	{"WAID", 4, 180935},
	{"WAIBEL", 6, 231940},
	{"WAIB", 4, 252142},
	{"WAIANAE", 7, 147621},
	{"WAIALUA", 7, 192823},
	{"WAIALAE", 7, 215568},
	{"WAHW", 4, 194964},
	{"WAHU", 4, 160882},
	{"WAHRHEIT", 8, 171352},
	{"WAHRE", 5, 130575},
	{"WAHPETON", 8, 138197},
	{"WAHP", 4, 239589},
	{"WAHOO", 5, 91114},
	{"WAHMS", 5, 178470},
	{"WAHM", 4, 109544},
	{"WAHLBERG", 8, 106734},
	{"WAHL", 4, 70984},
	{"WAHKIAKUM", 9, 200124},
	{"WAHINE", 6, 144655},
	{"WAHID", 5, 142518},
	{"WAHIAWA", 7, 156031},
	{"WAHHABISM", 9, 208402},
	{"WAHHABI", 7, 169320},
	{"WAHEED", 6, 218630},
	{"WAHC", 4, 199682},
	{"WAHANOL", 7, 234366},
	{"WAHAB", 5, 190277},
	{"WAGU", 4, 150029},
	{"WAGTAIL", 7, 154795},
	{"WAGT", 4, 222856},
	{"WAGSTAFF", 8, 149353},
	{"WAGS", 4, 135313},
	{"WAGRAM", 6, 164791},
	{"WAGR", 4, 86111},
	{"WAGONS", 6, 56711},
	{"WAGONLIT", 8, 188182},
	{"WAGONER", 7, 89192},
	{"WAGONEER", 8, 134394},
	{"WAGON", 5, 32317},
	{"WAGNERIAN", 9, 247714},
	{"WAGNER", 6, 36560},
	{"WAGNALLS", 8, 254173},
	{"WAGMAN", 6, 246799},
	{"WAGLE", 5, 217179},
	{"WAGL", 4, 198692},
	{"WAGING", 6, 79881},
	{"WAGI", 4, 100759},
	{"WAGH", 4, 215864},
	{"WAGGONER", 8, 108737},
	{"WAGGON", 6, 177037},
	{"WAGGLE", 6, 245246},
	{"WAGGING", 7, 117647},
	{"WAGGENER", 8, 246753},
	{"WAGGED", 6, 229301},
	{"WAGGA", 5, 69182},
	{"WAGES", 5, 30054},
	{"WAGERS", 6, 90140},
	{"WAGERING", 8, 49686},
	{"WAGERED", 7, 151929},
	{"WAGER", 5, 55191},
	{"WAGENINGEN", 10, 99788},
	{"WAGENER", 7, 127766},
	{"WAGENAAR", 8, 238678},
	{"WAGEN", 5, 206342},
	{"WAGED", 5, 76145},
	{"WAGE", 4, 8068},
	{"WAGAR", 5, 229660},
	{"WAGA", 4, 237324},
	{"WAFU", 4, 160103},
	{"WAFTS", 5, 240441},
	{"WAFTING", 7, 167975},
	{"WAFTED", 6, 177597},
	{"WAFT", 4, 198383},
	{"WAFS", 4, 213101},
	{"WAFR", 4, 111627},
	{"WAFO", 4, 99200},
	{"WAFI", 4, 119167},
	{"WAFFLING", 8, 185326},
	{"WAFFLES", 7, 72905},
	{"WAFFLER", 7, 257338},
	{"WAFFLE", 6, 57859},
	{"WAFFEN", 6, 133789},
	{"WAFF", 4, 247416},
	{"WAFERS", 6, 70371},
	{"WAFER", 5, 52724},
	{"WAFE", 4, 86497},
	{"WAFA", 4, 166428},
	{"WAEL", 4, 174803},
	{"WAECO", 5, 246241},
	{"WAECHTER", 8, 255472},
	{"WADW", 4, 247552},
	{"WADV", 4, 92665},
	{"WADU", 4, 158790},
	{"WADSWORTH", 9, 62620},
	{"WADS", 4, 140137},
	{"WADR", 4, 150837},
	{"WADO", 4, 236710},
	{"WADM", 4, 91481},
	{"WADLEY", 6, 153382},
	{"WADLER", 6, 189106},
	{"WADLEIGH", 8, 243092},
	{"WADL", 4, 198693},
	{"WADJ", 4, 218413},
	{"WADING", 6, 70252},
	{"WADIA", 5, 212056},
	{"WADI", 4, 92438},
	{"WADHURST", 8, 215974},
	{"WADHAM", 6, 203004},
	{"WADH", 4, 153248},
	{"WADESBORO", 9, 222568},
	{"WADES", 5, 176157},
	{"WADERS", 6, 93683},
	{"WADER", 5, 123452},
	{"WADENA", 6, 137228},
	{"WADED", 5, 130216},
	{"WADEBRIDGE", 10, 160088},
	{"WADE", 4, 37157},
	{"WADDY", 5, 188673},
	{"WADDOUPS", 8, 247842},
	{"WADDLING", 8, 213524},
	{"WADDLE", 6, 124751},
	{"WADDINGTON", 10, 107289},
	{"WADDING", 7, 187797},
	{"WADDEN", 6, 162823},
	{"WADDELL", 7, 82241},
	{"WADA", 4, 89564},
	{"WACU", 4, 187311},
	{"WACT", 4, 70892},
	{"WACS", 4, 174852},
	{"WACR", 4, 101652},
	{"WACQ", 4, 185096},
	{"WACONIA", 7, 175488},
	{"WACOM", 5, 65061},
	{"WACOAL", 6, 123252},
	{"WACO", 4, 49782},
	{"WACL", 4, 140527},
	{"WACKY", 5, 49542},
	{"WACKOS", 6, 140454},
	{"WACKO", 5, 106471},
	{"WACKINESS", 9, 212294},
	{"WACKIEST", 8, 175758},
	{"WACKIES", 7, 237872},
	{"WACKER", 6, 91534},
	{"WACKENHUT", 9, 198674},
	{"WACKEN", 6, 249593},
	{"WACKED", 6, 185928},
	{"WACK", 4, 94609},
	{"WACHUSETT", 9, 169113},
	{"WACHTWOORD", 10, 177356},
	{"WACHTER", 7, 144374},
	{"WACHTEL", 7, 190398},
	{"WACHT", 5, 251877},
	{"WACHS", 5, 213882},
	{"WACHOWSKI", 9, 142242},
	{"WACHOVIA", 8, 61533},
	{"WACHEE", 6, 200494},
	{"WACH", 4, 198014},
	{"WACCAMAW", 8, 173900},
	{"WACC", 4, 142431},
	{"WACA", 4, 137434},
	{"WABY", 4, 247242},
	{"WABU", 4, 111347},
	{"WABS", 4, 220685},
	{"WABR", 4, 131478},
	{"WABL", 4, 51348},
	{"WABISABI", 8, 185143},
	{"WABI", 4, 142014},
	{"WABER", 5, 256936},
	{"WABCAMS", 7, 143989},
	{"WABC", 4, 122256},
	{"WABBIT", 6, 169179},
	{"WABB", 4, 172262},
	{"WABAUNSEE", 9, 236165},
	{"WABASSO", 7, 238830},
	{"WABASHA", 7, 148191},
	{"WABASH", 6, 66406},
	{"WABA", 4, 215443},
	{"WAAROM", 6, 213050},
	{"WAARD", 5, 239559},
	{"WAAR", 4, 117084},
	{"WAAP", 4, 243317},
	{"WAALS", 5, 121060},
	{"WAAL", 4, 126916},
	{"WAAG", 4, 255619},
	{"WAAD", 4, 252143},
	{"WAAAY", 5, 173654},
	{"WAAAAY", 6, 186201},
	{"W1AW", 4, 261},
	{"W", 1, 14},
	{"VZY", 3, 262082},
	{"VZW", 3, 154497},
	{"VZV", 3, 194851},
	{"VZU", 3, 104950},
	{"VZR", 3, 120421},
	{"VZQ", 3, 58902},
	{"VZP", 3, 187235},
	{"VZM", 3, 132805},
	{"VZL", 3, 157882},
	{"VZK", 3, 222261},
	{"VZG", 3, 163229},
	{"VZF", 3, 89570},
	{"VZD", 3, 141798},
	{"VZC", 3, 116143},
	{"VZB", 3, 175473},
	{"VYZ", 3, 108700},
	{"VYYA", 4, 113312},
	{"VYY", 3, 30035},
	{"VYWO", 4, 132500},
	{"VYWI", 4, 111826},
	{"VYWH", 4, 120968},
	{"VYWE", 4, 52268},
	{"VYWA", 4, 96831},
	{"VYW", 3, 1740},
	{"VYVO", 4, 219945},
	{"VYVE", 4, 138434},
	{"VYV", 3, 30089},
	{"VYUS", 4, 133707},
	{"VYUN", 4, 154304},
	{"VYU", 3, 28092},
	{"VYTR", 4, 103769},
	{"VYTO", 4, 84900},
	{"VYTH", 4, 92562},
	{"VYTE", 4, 180999},
	{"VYTAUTAS", 8, 224141},
	{"VYTA", 4, 126906},
	{"VYT", 3, 2790},
	{"VYSYA", 5, 250713},
	{"VYSW", 4, 242165},
	{"VYSU", 4, 142097},
	{"VYST", 4, 112392},
	{"VYSS", 4, 215040},
	{"VYSP", 4, 163765},
	{"VYSO", 4, 147762},
	{"VYSN", 4, 126940},
	{"VYSM", 4, 174547},
	{"VYSL", 4, 230285},
	{"VYSI", 4, 177172},
	{"VYSH", 4, 107165},
	{"VYSF", 4, 243618},
	{"VYSC", 4, 172954},
	{"VYRO", 4, 144766},
	{"VYRI", 4, 251456},
	{"VYRE", 4, 98785},
	{"VYRA", 4, 72516},
	{"VYR", 3, 3224},
	{"VYQ", 3, 73004},
	{"VYPU", 4, 210294},
	{"VYPRESS", 7, 241761},
	{"VYPR", 4, 114820},
	{"VYPO", 4, 166717},
	{"VYPL", 4, 190630},
	{"VYPI", 4, 170609},
	{"VYPE", 4, 164152},
	{"VYPA", 4, 156458},
	{"VYP", 3, 4913},
	{"VYOV", 4, 244205},
	{"VYOU", 4, 151032},
	{"VYOTECH", 7, 153417},
	{"VYOR", 4, 159017},
	{"VYOP", 4, 258531},
	{"VYON", 4, 105850},
	{"VYOM", 4, 233721},
	{"VYOI", 4, 240731},
	{"VYOF", 4, 93098},
	{"VYNS", 4, 243003},
	{"VYNO", 4, 200012},
	{"VYNE", 4, 220176},
	{"VYNA", 4, 180201},
	{"VYN", 3, 8784},
	{"VYMU", 4, 248811},
	{"VYMO", 4, 174348},
	{"VYMI", 4, 169264},
	{"VYME", 4, 78867},
	{"VYMA", 4, 97083},
	{"VYM", 3, 3488},
	{"VYLO", 4, 96249},
	{"VYLI", 4, 105479},
	{"VYLE", 4, 91560},
	{"VYLA", 4, 169265},
	{"VYL", 3, 3549},
	{"VYK", 3, 46424},
	{"VYJO", 4, 205017},
	{"VYJ", 3, 38943},
	{"VYIT", 4, 221504},
	{"VYIS", 4, 118383},
	{"VYING", 5, 92992},
	{"VYIN", 4, 59603},
	{"VYI", 3, 2664},
	{"VYHO", 4, 191632},
	{"VYHI", 4, 160241},
	{"VYHE", 4, 136209},
	{"VYHA", 4, 87220},
	{"VYH", 3, 4935},
	{"VYGU", 4, 176368},
	{"VYGR", 4, 187588},
	{"VYGOTSKY", 8, 154510},
	{"VYGO", 4, 199850},
	{"VYGE", 4, 255284},
	{"VYGA", 4, 205190},
	{"VYG", 3, 9880},
	{"VYFR", 4, 146464},
	{"VYFO", 4, 103208},
	{"VYFL", 4, 181700},
	{"VYFI", 4, 98243},
	{"VYFA", 4, 151947},
	{"VYF", 3, 3956},
	{"VYEX", 4, 189281},
	{"VYES", 4, 250462},
	{"VYEQ", 4, 136465},
	{"VYEN", 4, 154446},
	{"VYEM", 4, 208294},
	{"VYEL", 4, 261194},
	{"VYEA", 4, 225075},
	{"VYDU", 4, 100167},
	{"VYDR", 4, 135678},
	{"VYDO", 4, 141281},
	{"VYDI", 4, 159177},
	{"VYDE", 4, 99093},
	{"VYDA", 4, 137898},
	{"VYD", 3, 3398},
	{"VYCR", 4, 105653},
	{"VYCO", 4, 69436},
	{"VYCL", 4, 197738},
	{"VYCH", 4, 96341},
	{"VYCA", 4, 88756},
	{"VYBU", 4, 122503},
	{"VYBR", 4, 166811},
	{"VYBO", 4, 116697},
	{"VYBL", 4, 117479},
	{"VYBA", 4, 128783},
	{"VYB", 3, 3728},
	{"VYAT", 4, 121762},
	{"VYAS", 4, 151935},
	{"VYAR", 4, 116219},
	{"VYAP", 4, 234295},
	{"VYAN", 4, 61336},
	{"VYAM", 4, 227712},
	{"VYAL", 4, 165651},
	{"VYAI", 4, 159642},
	{"VYAF", 4, 243004},
	{"VYAD", 4, 204857},
	{"VYACHESLAV", 10, 163655},
	{"VYAC", 4, 159563},
	{"VYA", 3, 1801},
	{"VY", 2, 259},
	{"VXY", 3, 172126},
	{"VXX", 3, 72840},
	{"VXWORKS", 7, 107067},
	{"VXW", 3, 216850},
	{"VXVM", 4, 197038},
	{"VXV", 3, 82361},
	{"VXU", 3, 155527},
	{"VXR", 3, 174392},
	{"VXQ", 3, 134165},
	{"VXP", 3, 95980},
	{"VXML", 4, 258853},
	{"VXM", 3, 95548},
	{"VXL", 3, 243467},
	{"VXJ", 3, 99125},
	{"VXG", 3, 163230},
	{"VXFS", 4, 222247},
	{"VXD", 3, 163021},
	{"VXC", 3, 73634},
	{"VWY", 3, 127828},
	{"VWXYZ", 5, 163165},
	{"VWW", 3, 64509},
	{"VWV", 3, 89900},
	{"VWU", 3, 119528},
	{"VWRO", 4, 249775},
	{"VWRI", 4, 139207},
	{"VWR", 3, 178802},
	{"VWP", 3, 240857},
	{"VWOU", 4, 141682},
	{"VWOR", 4, 112086},
	{"VWON", 4, 185483},
	{"VWK", 3, 157883},
	{"VWJ", 3, 113673},
	{"VWIT", 4, 86273},
	{"VWIN", 4, 215041},
	{"VWIL", 4, 103073},
	{"VWIC", 4, 216420},
	{"VWI", 3, 4709},
	{"VWHP", 4, 237460},
	{"VWHO", 4, 91537},
	{"VWHI", 4, 93242},
	{"VWHE", 4, 104907},
	{"VWHA", 4, 248812},
	{"VWH", 3, 3674},
	{"VWG", 3, 74430},
	{"VWF", 3, 165715},
	{"VWER", 4, 135203},
	{"VWEN", 4, 229983},
	{"VWEB", 4, 261195},
	{"VWD", 3, 163816},
	{"VWC", 3, 250350},
	{"VWAT", 4, 200736},
	{"VWAS", 4, 57745},
	{"VWAR", 4, 212760},
	{"VWAN", 4, 226720},
	{"VWAL", 4, 246037},
	{"VWAD", 4, 189400},
	{"VVZ", 3, 145366},
	{"VVYT", 4, 199022},
	{"VVYS", 4, 228709},
	{"VVYP", 4, 232651},
	{"VVYI", 4, 223750},
	{"VVYC", 4, 220367},
	{"VVYA", 4, 154581},
	{"VVY", 3, 4999},
	{"VVW", 3, 81505},
	{"VVVV", 4, 154234},
	{"VVV", 3, 260},
	{"VVU", 3, 79502},
	{"VVQ", 3, 262083},
	{"VVK", 3, 127829},
	{"VVJ", 3, 94755},
	{"VVIS", 4, 209891},
	{"VVIR", 4, 244518},
	{"VVIN", 4, 194210},
	{"VVIE", 4, 127272},
	{"VVID", 4, 161446},
	{"VVF", 3, 247088},
	{"VVED", 4, 208919},
	{"VVD", 3, 226209},
	{"VVC", 3, 236529},
	{"VVB", 3, 96397},
	{"VVAW", 4, 255333},
	{"VVAR", 4, 219292},
	{"VVAN", 4, 235206},
	{"VUZE", 4, 160732},
	{"VUZ", 3, 39635},
	{"VUX", 3, 125580},
	{"VUW", 3, 205442},
	{"VUVU", 4, 164654},
	{"VUV", 3, 92016},
	{"VUTO", 4, 235207},
	{"VUTH", 4, 247243},
	{"VUTECH", 6, 208896},
	{"VUST", 4, 258892},
	{"VUSE", 4, 162953},
	{"VUSA", 4, 156170},
	{"VURE", 4, 228465},
	{"VURA", 4, 216047},
	{"VUQ", 3, 118684},
	{"VUPOINT", 7, 169289},
	{"VUOTO", 5, 219927},
	{"VUONG", 5, 211882},
	{"VUOLE", 5, 219166},
	{"VUOKKO", 6, 193703},
	{"VUOI", 4, 166265},
	{"VUNT", 4, 258149},
	{"VUNI", 4, 124816},
	{"VUNG", 4, 187100},
	{"VUND", 4, 212206},
	{"VUMC", 4, 197361},
	{"VULVVA", 6, 197199},
	{"VULTURES", 8, 84194},
	{"VULTURE", 7, 72920},
	{"VULS", 4, 111442},
	{"VULPUTATE", 9, 177879},
	{"VULPES", 6, 177765},
	{"VULNWATCH", 9, 175288},
	{"VULNS", 5, 148839},
	{"VULNIFICUS", 10, 180494},
	{"VULNERABLE", 10, 9788},
	{"VULNERABILITY", 13, 29738},
	{"VULNERABILITIES", 15, 38904},
	{"VULN", 4, 109172},
	{"VULKAN", 6, 207528},
	{"VULGATE", 7, 64827},
	{"VULGARITY", 9, 123964},
	{"VULGARIS", 8, 76976},
	{"VULGARE", 7, 126214},
	{"VULGAR", 6, 58065},
	{"VULG", 4, 76759},
	{"VULE", 4, 191364},
	{"VULCANS", 7, 175723},
	{"VULCANO", 7, 196648},
	{"VULCANIZED", 10, 170058},
	{"VULCAN", 6, 61638},
	{"VULC", 4, 92347},
	{"VULA", 4, 136670},
	{"VUL", 3, 95461},
	{"VUKR", 4, 253887},
	{"VUKOVIC", 7, 258024},
	{"VUKOVAR", 7, 218745},
	{"VUKO", 4, 211070},
	{"VUKA", 4, 245740},
	{"VUK", 3, 226890},
	{"VUJA", 4, 193049},
	{"VUJ", 3, 44010},
	{"VUITTON", 7, 39645},
	{"VUIT", 4, 180771},
	{"VUIS", 4, 251781},
	{"VUG", 3, 236065},
	{"VUF", 3, 51884},
	{"VUEW", 4, 200013},
	{"VUET", 4, 244206},
	{"VUESCAN", 7, 233576},
	{"VUES", 4, 226810},
	{"VUELVE", 6, 199126},
	{"VUELTA", 6, 129296},
	{"VUELOS", 6, 112996},
	{"VUELO", 5, 167580},
	{"VUEL", 4, 122811},
	{"VUEI", 4, 258532},
	{"VUEH", 4, 230585},
	{"VUEC", 4, 235484},
	{"VUEA", 4, 187735},
	{"VUD", 3, 40410},
	{"VUC", 3, 42125},
	{"VUB", 3, 185475},
	{"VUARNET", 7, 141567},
	{"VUAN", 4, 203278},
	{"VTWO", 4, 244519},
	{"VTWI", 4, 194082},
	{"VTW", 3, 35850},
	{"VTUR", 4, 159962},
	{"VTUNE", 5, 210184},
	{"VTRS", 4, 204414},
	{"VTRI", 4, 217946},
	{"VTRE", 4, 203279},
	{"VTRA", 4, 117717},
	{"VTOW", 4, 196771},
	{"VTOV", 4, 251782},
	{"VTOU", 4, 234570},
	{"VTOR", 4, 166301},
	{"VTOP", 4, 190922},
	{"VTOM", 4, 185484},
	{"VTOL", 4, 232069},
	{"VTOG", 4, 247553},
	{"VTOF", 4, 181459},
	{"VTOD", 4, 189282},
	{"VTOB", 4, 199181},
	{"VTKUSERS", 8, 87360},
	{"VTKOBJECTBASE", 13, 183413},
	{"VTKOBJECT", 9, 125448},
	{"VTKINDENT", 9, 225528},
	{"VTKIMAGEDATA", 12, 253368},
	{"VTKIDTYPE", 9, 216734},
	{"VTKDATAOBJECT", 13, 214304},
	{"VTKALGORITHM", 12, 182501},
	{"VTIM", 4, 133180},
	{"VTHR", 4, 179086},
	{"VTED", 4, 203809},
	{"VTECH", 5, 69875},
	{"VTEC", 4, 100523},
	{"VTAM", 4, 158923},
	{"VTAL", 4, 177265},
	{"VTAK", 4, 255646},
	{"VTAC", 4, 229952},
	{"VTABLE", 6, 119588},
	{"VSYS", 4, 157603},
	{"VSYNC", 5, 146064},
	{"VSYA", 4, 139242},
	{"VSY", 3, 35278},
	{"VSWR", 4, 135649},
	{"VSWO", 4, 175729},
	{"VSWI", 4, 116838},
	{"VSWH", 4, 161848},
	{"VSWE", 4, 123185},
	{"VSWA", 4, 153988},
	{"VSVI", 4, 186628},
	{"VSUS", 4, 190772},
	{"VSUR", 4, 235485},
	{"VSUP", 4, 147267},
	{"VSUN", 4, 178968},
	{"VSUC", 4, 215249},
	{"VSUB", 4, 206838},
	{"VSTUDIO", 7, 246826},
	{"VSTU", 4, 159415},
	{"VSSU", 4, 185743},
	{"VSRO", 4, 194083},
	{"VSRI", 4, 240452},
	{"VSRE", 4, 124380},
	{"VSRA", 4, 189015},
	{"VSQU", 4, 211997},
	{"VSPRINTF", 8, 240957},
	{"VSPR", 4, 138435},
	{"VSPO", 4, 116314},
	{"VSPL", 4, 193317},
	{"VSPI", 4, 226497},
	{"VSPH", 4, 227458},
	{"VSPE", 4, 111489},
	{"VSPACE", 6, 148040},
	{"VSPA", 4, 143525},
	{"VSOU", 4, 168798},
	{"VSOR", 4, 174955},
	{"VSOP", 4, 181550},
	{"VSOM", 4, 242717},
	{"VSOLJ", 5, 127819},
	{"VSOL", 4, 217947},
	{"VSOF", 4, 163414},
	{"VSOCIAL", 7, 260319},
	{"VSNPRINTF", 9, 225533},
	{"VSNL", 4, 156074},
	{"VSNET", 5, 34477},
	{"VSMO", 4, 152729},
	{"VSMI", 4, 122812},
	{"VSME", 4, 205383},
	{"VSMA", 4, 119412},
	{"VSLO", 4, 156553},
	{"VSLIVE", 6, 250068},
	{"VSLI", 4, 171869},
	{"VSLE", 4, 198353},
	{"VSLA", 4, 150088},
	{"VSKY", 4, 57203},
	{"VSKO", 4, 208295},
	{"VSKIP", 5, 217370},
	{"VSKI", 4, 81951},
	{"VSKE", 4, 236077},
	{"VSKA", 4, 109798},
	{"VSJO", 4, 251783},
	{"VSJA", 4, 249440},
	{"VSIZE", 5, 68372},
	{"VSIM", 4, 230286},
	{"VSIG", 4, 169183},
	{"VSGR", 4, 205018},
	{"VSGO", 4, 184852},
	{"VSGE", 4, 224865},
	{"VSFTPD", 6, 156301},
	{"VSFR", 4, 195252},
	{"VSFO", 4, 138170},
	{"VSFL", 4, 240732},
	{"VSFI", 4, 167328},
	{"VSFA", 4, 159018},
	{"VSEVOLOD", 8, 242068},
	{"VSEV", 4, 179554},
	{"VSERVERS", 8, 234801},
	{"VSERVER", 7, 76216},
	{"VSER", 4, 58277},
	{"VSEL", 4, 246621},
	{"VSED", 4, 140567},
	{"VSEC", 4, 208920},
	{"VSEARCH", 7, 199488},
	{"VSDO", 4, 194501},
	{"VSDI", 4, 194345},
	{"VSDE", 4, 129969},
	{"VSCR", 4, 125081},
	{"VSCO", 4, 98992},
	{"VSCL", 4, 206623},
	{"VSCH", 4, 119596},
	{"VSCE", 4, 191365},
	{"VSCA", 4, 110652},
	{"VSBU", 4, 183122},
	{"VSBR", 4, 192781},
	{"VSBO", 4, 185097},
	{"VSBL", 4, 237062},
	{"VSBI", 4, 210879},
	{"VSBE", 4, 158210},
	{"VSBA", 4, 184093},
	{"VSAY", 4, 162620},
	{"VSAR", 4, 90358},
	{"VSAM", 4, 146257},
	{"VSAL", 4, 133601},
	{"VSAC", 4, 231828},
	{"VRX", 3, 205097},
	{"VRWC", 4, 207270},
	{"VRW", 3, 49675},
	{"VRUS", 4, 181701},
	{"VRU", 3, 210586},
	{"VRSQ", 4, 257023},
	{"VRSN", 4, 238161},
	{"VRRP", 4, 145813},
	{"VRP", 3, 166784},
	{"VROV", 4, 208498},
	{"VROUWEN", 7, 166759},
	{"VROUW", 5, 80950},
	{"VROU", 4, 248813},
	{"VROS", 4, 136376},
	{"VROOM", 5, 115061},
	{"VROO", 4, 205917},
	{"VRONSKY", 7, 208781},
	{"VRON", 4, 87105},
	{"VROMAN", 6, 190821},
	{"VROL", 4, 66650},
	{"VROD", 4, 178754},
	{"VROC", 4, 167062},
	{"VROB", 4, 180318},
	{"VROA", 4, 250818},
	{"VRMS", 4, 158504},
	{"VRML", 4, 70747},
	{"VRM", 3, 145641},
	{"VRLA", 4, 228452},
	{"VRL", 3, 225144},
	{"VRK", 3, 70999},
	{"VRJ", 3, 102705},
	{"VRIT", 4, 215250},
	{"VRIS", 4, 201402},
	{"VRINDAVAN", 9, 225962},
	{"VRIN", 4, 135909},
	{"VRIL", 4, 138171},
	{"VRIJE", 5, 109831},
	{"VRIJDAG", 7, 142360},
	{"VRIJ", 4, 152991},
	{"VRIG", 4, 213613},
	{"VRIES", 5, 82783},
	{"VRIENDEN", 8, 213324},
	{"VRIEND", 6, 164697},
	{"VRID", 4, 234571},
	{"VRIC", 4, 146567},
	{"VRGAS", 5, 257543},
	{"VRG", 3, 211943},
	{"VRFY", 4, 251228},
	{"VRF", 3, 100012},
	{"VREW", 4, 102649},
	{"VREV", 4, 186898},
	{"VREU", 4, 207357},
	{"VRET", 4, 97601},
	{"VRES", 4, 67534},
	{"VRER", 4, 188283},
	{"VREP", 4, 104131},
	{"VREO", 4, 176246},
	{"VREN", 4, 153917},
	{"VREME", 5, 217316},
	{"VREM", 4, 127700},
	{"VREL", 4, 146693},
	{"VREID", 5, 254404},
	{"VREH", 4, 130043},
	{"VREF", 4, 157299},
	{"VREETING", 8, 234737},
	{"VREELAND", 8, 165141},
	{"VREE", 4, 109749},
	{"VREDESTEIN", 10, 197815},
	{"VREDENBURG", 10, 247509},
	{"VREDE", 5, 228960},
	{"VRED", 4, 127381},
	{"VREC", 4, 109317},
	{"VREB", 4, 160582},
	{"VREA", 4, 85001},
	{"VRD", 3, 188753},
	{"VRC", 3, 113442},
	{"VRBO", 4, 108537},
	{"VRB", 3, 194387},
	{"VRAY", 4, 237497},
	{"VRATSA", 6, 199587},
	{"VRAT", 4, 109151},
	{"VRAS", 4, 229984},
	{"VRANA", 5, 192301},
	{"VRAN", 4, 125671},
	{"VRAM", 4, 115958},
	{"VRAJ", 4, 160335},
	{"VRAIN", 5, 212599},
	{"VRAIMENT", 8, 148150},
	{"VRAI", 4, 158652},
	{"VRAH", 4, 213803},
	{"VRAGEN", 6, 143427},
	{"VRAD", 4, 154060},
	{"VRAC", 4, 239102},
	{"VRABEL", 6, 242843},
	{"VRAB", 4, 161774},
	{"VRAAG", 5, 119850},
	{"VRAA", 4, 251457},
	{"VQW", 3, 163231},
	{"VQV", 3, 166070},
	{"VQUI", 4, 261945},
	{"VQU", 3, 42890},
	{"VQQ", 3, 202341},
	{"VQL", 3, 163232},
	{"VQF", 3, 160602},
	{"VQD", 3, 116144},
	{"VQC", 3, 175474},
	{"VQB", 3, 196843},
	{"VPZ", 3, 147240},
	{"VPY", 3, 81506},
	{"VPX", 3, 101174},
	{"VPWI", 4, 236078},
	{"VPWH", 4, 240143},
	{"VPVO", 4, 227459},
	{"VPV", 3, 47358},
	{"VPUR", 4, 232367},
	{"VPUB", 4, 242447},
	{"VPU", 3, 95175},
	{"VPTS", 4, 115092},
	{"VPTO", 4, 194346},
	{"VPTH", 4, 180441},
	{"VPSP", 4, 162225},
	{"VPSE", 4, 259648},
	{"VPRINTF", 7, 186809},
	{"VPRI", 4, 175174},
	{"VPRE", 4, 108686},
	{"VPRA", 4, 260852},
	{"VPR", 3, 99439},
	{"VPQ", 3, 98638},
	{"VPPON", 5, 196189},
	{"VPP", 3, 110255},
	{"VPOW", 4, 178178},
	{"VPOS", 4, 122846},
	{"VPOR", 4, 233846},
	{"VPOPMAIL", 8, 136018},
	{"VPOP", 4, 193112},
	{"VPON", 4, 139114},
	{"VPOL", 4, 185485},
	{"VPOF", 4, 112872},
	{"VPNS", 4, 69948},
	{"VPNC", 4, 198120},
	{"VPN", 3, 33414},
	{"VPM", 3, 167794},
	{"VPLS", 4, 190164},
	{"VPLA", 4, 119460},
	{"VPL", 3, 78067},
	{"VPJ", 3, 60752},
	{"VPIS", 4, 199352},
	{"VPIN", 4, 146694},
	{"VPIM", 4, 176103},
	{"VPHO", 4, 159800},
	{"VPHI", 4, 228466},
	{"VPHA", 4, 243005},
	{"VPG", 3, 259542},
	{"VPFO", 4, 186000},
	{"VPF", 3, 231243},
	{"VPET", 4, 229500},
	{"VPER", 4, 125915},
	{"VPDN", 4, 122000},
	{"VPD", 3, 136980},
	{"VPCO", 4, 221932},
	{"VPCH", 4, 245436},
	{"VPCA", 4, 155364},
	{"VPC", 3, 89171},
	{"VPBS", 4, 169693},
	{"VPB", 3, 220866},
	{"VPAW", 4, 125848},
	{"VPATH", 5, 173687},
	{"VPAT", 4, 128025},
	{"VPAS", 4, 213614},
	{"VPAR", 4, 117666},
	{"VPAP", 4, 255937},
	{"VPAN", 4, 119709},
	{"VPAL", 4, 151890},
	{"VOYW", 4, 138805},
	{"VOYUSER", 7, 103707},
	{"VOYURE", 6, 141270},
	{"VOYUERWEB", 9, 74773},
	{"VOYUER", 6, 36215},
	{"VOYT", 4, 106466},
	{"VOYS", 4, 80815},
	{"VOYR", 4, 214407},
	{"VOYP", 4, 247870},
	{"VOYOUR", 6, 124923},
	{"VOYO", 4, 119739},
	{"VOYLES", 6, 252721},
	{"VOYL", 4, 243006},
	{"VOYI", 4, 167908},
	{"VOYH", 4, 202574},
	{"VOYFORUMS", 9, 79242},
	{"VOYF", 4, 184232},
	{"VOYETRA", 7, 155419},
	{"VOYER", 5, 49356},
	{"VOYENCE", 7, 238403},
	{"VOYE", 4, 119981},
	{"VOYCE", 5, 208888},
	{"VOYC", 4, 190773},
	{"VOYB", 4, 200014},
	{"VOYAGING", 8, 193836},
	{"VOYAGEURS", 9, 101346},
	{"VOYAGEUR", 8, 130193},
	{"VOYAGES", 7, 56924},
	{"VOYAGERS", 8, 143106},
	{"VOYAGER", 7, 40251},
	{"VOYAGE", 6, 38686},
	{"VOXSON", 6, 164549},
	{"VOXLINKS", 8, 235748},
	{"VOXILLA", 7, 133831},
	{"VOXENGO", 7, 204235},
	{"VOXELS", 6, 137892},
	{"VOXEL", 5, 110118},
	{"VOWT", 4, 131896},
	{"VOWS", 4, 50579},
	{"VOWO", 4, 179875},
	{"VOWNLOADS", 9, 236713},
	{"VOWNLOAD", 8, 236682},
	{"VOWN", 4, 220802},
	{"VOWLAN", 6, 245864},
	{"VOWING", 6, 128544},
	{"VOWH", 4, 156554},
	{"VOWELS", 6, 71564},
	{"VOWELL", 6, 181155},
	{"VOWEL", 5, 61049},
	{"VOWED", 5, 65174},
	{"VOWA", 4, 122687},
	{"VOVI", 4, 184607},
	{"VOVE", 4, 175175},
	{"VOUYER", 6, 79638},
	{"VOUT", 4, 139428},
	{"VOUS", 4, 42047},
	{"VOUR", 4, 32732},
	{"VOULEZ", 6, 145815},
	{"VOUGHT", 6, 185683},
	{"VOUG", 4, 253538},
	{"VOUCHSAFED", 10, 216209},
	{"VOUCHSAFE", 9, 234805},
	{"VOUCHERS", 8, 36900},
	{"VOUCHER", 7, 37912},
	{"VOUCHED", 7, 241756},
	{"VOUCH", 5, 88921},
	{"VOUC", 4, 81641},
	{"VOTZENBILDER", 12, 219435},
	{"VOTZEN", 6, 109370},
	{"VOTZE", 5, 150830},
	{"VOTRE", 5, 52544},
	{"VOTR", 4, 237348},
	{"VOTOS", 5, 125051},
	{"VOTOMS", 6, 215826},
	{"VOTOLATO", 8, 222411},
	{"VOTIVO", 6, 261068},
	{"VOTIVES", 7, 109090},
	{"VOTIVE", 6, 70370},
	{"VOTING", 6, 32234},
	{"VOTES", 5, 3900},
	{"VOTERS", 6, 28652},
	{"VOTER", 5, 4154},
	{"VOTED", 5, 28068},
	{"VOTE", 4, 3007},
	{"VOTAW", 5, 250259},
	{"VOTAR", 5, 222550},
	{"VOTABLE", 7, 220156},
	{"VOSW", 4, 216256},
	{"VOSTRO", 6, 178923},
	{"VOSTRA", 6, 235469},
	{"VOSTOK", 6, 113833},
	{"VOSR", 4, 260449},
	{"VOSONIC", 7, 110685},
	{"VOSM", 4, 261946},
	{"VOSKA", 5, 204064},
	{"VOSK", 4, 224866},
	{"VOSGES", 6, 134953},
	{"VOSG", 4, 236339},
	{"VOSF", 4, 227460},
	{"VOSC", 4, 195402},
	{"VOSB", 4, 242718},
	{"VORY", 4, 67940},
	{"VORW", 4, 83971},
	{"VORV", 4, 210880},
	{"VORU", 4, 200368},
	{"VORTRAG", 7, 206682},
	{"VORTICITY", 9, 97558},
	{"VORTICES", 8, 97322},
	{"VORTEX", 6, 46603},
	{"VORTECH", 7, 155805},
	{"VORTEC", 6, 149944},
	{"VORTAC", 6, 208586},
	{"VORT", 4, 204366},
	{"VORSTER", 7, 194712},
	{"VORST", 5, 232641},
	{"VORSPIEL", 8, 203068},
	{"VORSITZENDE", 11, 207971},
	{"VORSCHAU", 8, 142163},
	{"VORREI", 6, 222004},
	{"VORR", 4, 116540},
	{"VORPOMMERN", 10, 194929},
	{"VORP", 4, 259486},
	{"VORONTSOV", 9, 238845},
	{"VORONOI", 7, 126865},
	{"VORONIN", 7, 184045},
	{"VORONEZH", 8, 163398},
	{"VORO", 4, 42194},
	{"VORNICU", 7, 244266},
	{"VORNADO", 7, 150628},
	{"VORMETRIC", 9, 192068},
	{"VORM", 4, 247936},
	{"VORLON", 6, 222773},
	{"VORL", 4, 123469},
	{"VORKOSIGAN", 10, 216529},
	{"VORJ", 4, 239858},
	{"VORIGE", 6, 142356},
	{"VORICONAZOLE", 12, 229468},
	{"VORI", 4, 30208},
	{"VORHERIGES", 10, 184328},
	{"VORHERIGE", 9, 183484},
	{"VORHANDEN", 9, 167276},
	{"VORH", 4, 102280},
	{"VORG", 4, 128813},
	{"VORF", 4, 96130},
	{"VORES", 5, 177399},
	{"VORE", 4, 211388},
	{"VORDERMAN", 9, 189736},
	{"VORC", 4, 39958},
	{"VORBIS", 6, 61081},
	{"VORBEI", 6, 160166},
	{"VORBEHALTEN", 11, 99315},
	{"VORB", 4, 101847},
	{"VORARLBERG", 10, 160937},
	{"VORACIOUSLY", 11, 232165},
	{"VORACIOUS", 9, 114573},
	{"VORA", 4, 235155},
	{"VOPR", 4, 209787},
	{"VOPE", 4, 163584},
	{"VOORWAARDEN", 11, 165742},
	{"VOORRAAD", 8, 77692},
	{"VOORN", 5, 212776},
	{"VOORHIS", 7, 220980},
	{"VOORHIES", 8, 262042},
	{"VOORHEES", 8, 88345},
	{"VOORDELIG", 9, 224501},
	{"VOORBURG", 8, 249702},
	{"VOORBEHOUDEN", 12, 216516},
	{"VOORBEELD", 9, 191436},
	{"VOOR", 4, 41802},
	{"VOOM", 4, 117023},
	{"VOOGLE", 6, 212756},
	{"VOOF", 4, 233224},
	{"VOODOO", 6, 45254},
	{"VOOD", 4, 98586},
	{"VONZIPPER", 9, 209004},
	{"VONZ", 4, 260853},
	{"VONW", 4, 100950},
	{"VONR", 4, 112538},
	{"VONP", 4, 129214},
	{"VONNIE", 6, 226460},
	{"VONNEGUT", 8, 87174},
	{"VONM", 4, 106105},
	{"VONL", 4, 105062},
	{"VONK", 4, 222055},
	{"VONJ", 4, 195089},
	{"VONGO", 5, 238588},
	{"VONG", 4, 160098},
	{"VONF", 4, 134644},
	{"VONDELPARK", 10, 254447},
	{"VONDA", 5, 144494},
	{"VONC", 4, 119883},
	{"VONB", 4, 88398},
	{"VONAGE", 6, 36785},
	{"VOMS", 4, 186563},
	{"VOMO", 4, 182170},
	{"VOMITS", 6, 220108},
	{"VOMITING", 8, 47717},
	{"VOMITED", 7, 152887},
	{"VOMIT", 5, 68138},
	{"VOMI", 4, 81002},
	{"VOME", 4, 229740},
	{"VOMBAT", 6, 230420},
	{"VOMA", 4, 166219},
	{"VOLZ", 4, 158697},
	{"VOLY", 4, 229741},
	{"VOLX", 4, 239859},
	{"VOLW", 4, 258150},
	{"VOLVULUS", 8, 204589},
	{"VOLVOS", 6, 229556},
	{"VOLVO", 5, 32221},
	{"VOLVER", 6, 98519},
	{"VOLVED", 6, 148311},
	{"VOLVE", 5, 250956},
	{"VOLV", 4, 4008},
	{"VOLUTPAT", 8, 149086},
	{"VOLUTION", 8, 202709},
	{"VOLUTE", 6, 240659},
	{"VOLUSION", 8, 100783},
	{"VOLUSIA", 7, 91193},
	{"VOLUPTUOUSNESS", 14, 227845},
	{"VOLUPTUOUS", 10, 87425},
	{"VOLUPTUA", 8, 188840},
	{"VOLUNTEERS", 10, 6941},
	{"VOLUNTEERMATCH", 14, 101038},
	{"VOLUNTEERISM", 12, 80522},
	{"VOLUNTEERING", 12, 40759},
	{"VOLUNTEERED", 11, 54006},
	{"VOLUNTEER", 9, 7174},
	{"VOLUNTARY", 9, 34602},
	{"VOLUNTARISM", 11, 182215},
	{"VOLUNTARIOS", 11, 225392},
	{"VOLUNTARINESS", 13, 216312},
	{"VOLUNTARILY", 11, 44905},
	{"VOLUN", 5, 145655},
	{"VOLUMIZING", 10, 183921},
	{"VOLUMINOUS", 10, 95177},
	{"VOLUMETRIC", 10, 72276},
	{"VOLUMES", 7, 29665},
	{"VOLUMEN", 7, 140074},
	{"VOLUME", 6, 5857},
	{"VOLUM", 5, 95606},
	{"VOLTZ", 5, 257277},
	{"VOLTS", 5, 45279},
	{"VOLTRON", 7, 148557},
	{"VOLTMETERS", 10, 231704},
	{"VOLTMETER", 9, 114284},
	{"VOLTEXX", 7, 228951},
	{"VOLTERRA", 8, 122932},
	{"VOLTE", 5, 155518},
	{"VOLTAREN", 8, 170220},
	{"VOLTAR", 6, 213742},
	{"VOLTAMMETRY", 11, 207136},
	{"VOLTAIRE", 8, 69714},
	{"VOLTAIC", 7, 187813},
	{"VOLTAGES", 8, 59142},
	{"VOLTAGE", 7, 6860},
	{"VOLTA", 5, 62771},
	{"VOLT", 4, 30704},
	{"VOLSER", 6, 94752},
	{"VOLS", 4, 48418},
	{"VOLQ", 4, 214033},
	{"VOLPI", 5, 247162},
	{"VOLPE", 5, 102378},
	{"VOLP", 4, 98602},
	{"VOLOS", 5, 188226},
	{"VOLOKH", 6, 63836},
	{"VOLOGDA", 7, 218133},
	{"VOLODYMYR", 9, 169879},
	{"VOLO", 4, 90471},
	{"VOLNEY", 6, 232260},
	{"VOLN", 4, 81296},
	{"VOLM", 4, 235208},
	{"VOLLRATH", 8, 194307},
	{"VOLLMER", 7, 114399},
	{"VOLLMANN", 8, 229216},
	{"VOLLEYS", 7, 161178},
	{"VOLLEYBALLS", 11, 214199},
	{"VOLLEYBALL", 10, 31456},
	{"VOLLEY", 6, 77568},
	{"VOLLER", 6, 181046},
	{"VOLLENWEIDER", 12, 201214},
	{"VOLLEDIGE", 9, 167608},
	{"VOLLE", 5, 189243},
	{"VOLLBUSIG", 9, 190891},
	{"VOLL", 4, 134587},
	{"VOLKSWAGON", 10, 130460},
	{"VOLKSWAGENS", 11, 241805},
	{"VOLKSWAGEN", 10, 32161},
	{"VOLKSKRANT", 10, 248030},
	{"VOLKSGEZONDHEID", 15, 194330},
	{"VOLKSBLAD", 9, 190446},
	{"VOLKS", 5, 174110},
	{"VOLKOV", 6, 160557},
	{"VOLKMER", 7, 233209},
	{"VOLKMAR", 7, 240934},
	{"VOLKMANN", 8, 241164},
	{"VOLKMAN", 7, 256549},
	{"VOLKL", 5, 103591},
	{"VOLKERDI", 8, 163210},
	{"VOLKER", 6, 72498},
	{"VOLK", 4, 90429},
	{"VOLITIONS", 9, 236437},
	{"VOLITIONAL", 10, 176835},
	{"VOLITION", 8, 94279},
	{"VOLI", 4, 80417},
	{"VOLH", 4, 194347},
	{"VOLGOGRAD", 9, 117035},
	{"VOLGENS", 7, 195931},
	{"VOLGENDE", 8, 110419},
	{"VOLGA", 5, 90608},
	{"VOLF", 4, 236615},
	{"VOLES", 5, 143990},
	{"VOLENDAM", 8, 183631},
	{"VOLEIBOL", 8, 232591},
	{"VOLE", 4, 116708},
	{"VOLDEMORT", 9, 88231},
	{"VOLD", 4, 186994},
	{"VOLCOM", 6, 80867},
	{"VOLCKER", 7, 132613},
	{"VOLCANOS", 8, 165003},
	{"VOLCANOLOGY", 11, 152159},
	{"VOLCANOES", 9, 55819},
	{"VOLCANO", 7, 42234},
	{"VOLCANISM", 9, 117658},
	{"VOLCANICS", 9, 186299},
	{"VOLCANIC", 8, 46907},
	{"VOLCAN", 6, 181943},
	{"VOLC", 4, 49483},
	{"VOLB", 4, 259278},
	{"VOLATILIZATION", 14, 163408},
	{"VOLATILITY", 10, 44585},
	{"VOLATILITIES", 12, 170948},
	{"VOLATILES", 9, 128600},
	{"VOLATILE", 8, 40956},
	{"VOLARE", 6, 146726},
	{"VOLAR", 5, 221209},
	{"VOLAPUK", 7, 199895},
	{"VOLANTE", 7, 121456},
	{"VOLANT", 6, 118553},
	{"VOLA", 4, 209455},
	{"VOL", 3, 2867},
	{"VOKOUN", 6, 245616},
	{"VOKO", 4, 223064},
	{"VOKI", 4, 79107},
	{"VOKEY", 5, 259423},
	{"VOKAL", 5, 245587},
	{"VOKA", 4, 208499},
	{"VOK", 3, 1433},
	{"VOJVODINA", 9, 166798},
	{"VOJV", 4, 168540},
	{"VOJTECH", 7, 177851},
	{"VOJISLAV", 8, 203702},
	{"VOJ", 3, 32731},
	{"VOIX", 4, 103259},
	{"VOIVODSHIP", 10, 186077},
	{"VOIVOD", 6, 159849},
	{"VOIV", 4, 122123},
	{"VOITURES", 8, 110436},
	{"VOITURE", 7, 84111},
	{"VOITH", 5, 226351},
	{"VOISIN", 6, 156496},
	{"VOISEY", 6, 229058},
	{"VOIR", 4, 52505},
	{"VOIPTEST", 8, 239107},
	{"VOIP", 4, 6161},
	{"VOINOVICH", 9, 134379},
	{"VOILES", 6, 238922},
	{"VOILE", 5, 108179},
	{"VOILA", 5, 80158},
	{"VOIGTLANDER", 11, 167474},
	{"VOIGT", 5, 93560},
	{"VOIGHT", 6, 102715},
	{"VOIG", 4, 142337},
	{"VOIDS", 5, 82460},
	{"VOIDOIDS", 8, 227600},
	{"VOIDING", 7, 125832},
	{"VOIDED", 6, 103169},
	{"VOIDABLE", 8, 189831},
	{"VOID", 4, 3849},
	{"VOICINGS", 8, 209029},
	{"VOICING", 7, 80433},
	{"VOICI", 5, 155827},
	{"VOICEXML", 8, 110015},
	{"VOICESTREAM", 11, 154350},
	{"VOICES", 6, 9868},
	{"VOICEPULSE", 10, 250938},
	{"VOICEPRINT", 10, 198607},
	{"VOICEOVERS", 10, 162383},
	{"VOICEOVER", 9, 98686},
	{"VOICEMESSAGE", 12, 216955},
	{"VOICEMAILS", 10, 170120},
	{"VOICEMAIL", 9, 51650},
	{"VOICELESS", 9, 120634},
	{"VOICEFINDER", 11, 202536},
	{"VOICED", 6, 53398},
	{"VOICECON", 8, 185508},
	{"VOICECHAT", 9, 202638},
	{"VOICEBOX", 8, 253292},
	{"VOICE", 5, 1552},
	{"VOIC", 4, 8520},
	{"VOHRA", 5, 222692},
	{"VOGUE", 5, 47220},
	{"VOGU", 4, 92672},
	{"VOGT", 4, 73180},
	{"VOGON", 5, 189185},
	{"VOGO", 4, 248814},
	{"VOGLIO", 6, 199656},
	{"VOGLER", 6, 167881},
	{"VOGL", 4, 230823},
	{"VOGES", 5, 261006},
	{"VOGELSTEIN", 10, 237463},
	{"VOGELSANG", 9, 220720},
	{"VOGELS", 6, 99807},
	{"VOGEL", 5, 57041},
	{"VOGE", 4, 107260},
	{"VOFT", 4, 138488},
	{"VOFS", 4, 200369},
	{"VOFO", 4, 186763},
	{"VOFF", 4, 125985},
	{"VOFE", 4, 256660},
	{"VOFA", 4, 192208},
	{"VOEUX", 5, 200117},
	{"VOETSCH", 7, 152901},
	{"VOETBAL", 7, 102685},
	{"VOESTALPINE", 11, 225413},
	{"VOELKER", 7, 153046},
	{"VOEL", 4, 238765},
	{"VOEGELN", 7, 113845},
	{"VOEGELIN", 8, 248572},
	{"VOEG", 4, 71642},
	{"VODS", 4, 175176},
	{"VODOU", 5, 256470},
	{"VODO", 4, 189401},
	{"VODKAS", 6, 146040},
	{"VODKAPUNDIT", 11, 115791},
	{"VODKA", 5, 47241},
	{"VODK", 4, 94899},
	{"VODI", 4, 135443},
	{"VODE", 4, 111604},
	{"VODCAST", 7, 212383},
	{"VODAVI", 6, 193153},
	{"VODAPHONE", 9, 147741},
	{"VODAFONE", 8, 37668},
	{"VODACOM", 7, 98811},
	{"VODA", 4, 132943},
	{"VOCW", 4, 173146},
	{"VOCT", 4, 212409},
	{"VOCS", 4, 84855},
	{"VOCOPRO", 7, 119430},
	{"VOCODER", 7, 153702},
	{"VOCO", 4, 100538},
	{"VOCIFEROUSLY", 12, 199931},
	{"VOCIFEROUS", 10, 151910},
	{"VOCI", 4, 209014},
	{"VOCH", 4, 180874},
	{"VOCES", 5, 183965},
	{"VOCED", 5, 164290},
	{"VOCE", 4, 90177},
	{"VOCATIONS", 9, 89643},
	{"VOCATIONALLY", 12, 190143},
	{"VOCATIONAL", 10, 31178},
	{"VOCATION", 8, 63271},
	{"VOCALSCOMEDY", 12, 104863},
	{"VOCALS", 6, 32620},
	{"VOCALLY", 7, 129889},
	{"VOCALIZING", 10, 253385},
	{"VOCALIZE", 8, 235123},
	{"VOCALIZATIONS", 13, 153203},
	{"VOCALIZATION", 12, 169961},
	{"VOCALISTS", 9, 74043},
	{"VOCALIST", 8, 54952},
	{"VOCALISE", 8, 230150},
	{"VOCALIC", 7, 231299},
	{"VOCALE", 6, 255077},
	{"VOCAL", 5, 34063},
	{"VOCABULARY", 10, 33411},
	{"VOCABULARIO", 11, 174941},
	{"VOCABULARIES", 12, 89633},
	{"VOCABULA", 8, 165106},
	{"VOCAB", 5, 87275},
	{"VOCA", 4, 150862},
	{"VOBU", 4, 253888},
	{"VOBO", 4, 185098},
	{"VOBL", 4, 223297},
	{"VOBIS", 5, 131097},
	{"VOBE", 4, 221024},
	{"VOBA", 4, 251147},
	{"VOAR", 4, 237063},
	{"VOAL", 4, 192625},
	{"VNUNET", 6, 156857},
	{"VNPT", 4, 247838},
	{"VNOW", 4, 169705},
	{"VNOV", 4, 242166},
	{"VNOR", 4, 198694},
	{"VNODE", 5, 146124},
	{"VNIK", 4, 143146},
	{"VNIC", 4, 185099},
	{"VNEXPRESS", 9, 258989},
	{"VNER", 4, 177069},
	{"VNDM", 4, 237972},
	{"VNDB", 4, 247244},
	{"VNCVIEWER", 9, 260525},
	{"VNCSERVER", 9, 253037},
	{"VNBIZ", 5, 171021},
	{"VNAR", 4, 189679},
	{"VMY", 3, 64510},
	{"VMX", 3, 139539},
	{"VMWARE", 6, 53003},
	{"VMWA", 4, 125305},
	{"VMW", 3, 32834},
	{"VMUS", 4, 181590},
	{"VMU", 3, 124903},
	{"VMTN", 4, 145702},
	{"VMSTAT", 6, 206024},
	{"VMR", 3, 218508},
	{"VMQ", 3, 230197},
	{"VMPS", 4, 141355},
	{"VMP", 3, 151612},
	{"VMOV", 4, 100185},
	{"VMOS", 4, 235209},
	{"VMOR", 4, 211259},
	{"VMON", 4, 171956},
	{"VMOD", 4, 161026},
	{"VMM", 3, 196106},
	{"VMLINUZ", 7, 163557},
	{"VMLINUX", 7, 166944},
	{"VML", 3, 132796},
	{"VMJ", 3, 65463},
	{"VMIT", 4, 195253},
	{"VMIS", 4, 202941},
	{"VMIN", 4, 257179},
	{"VMIL", 4, 219503},
	{"VMIKLOS", 7, 191130},
	{"VMIK", 4, 189166},
	{"VMIC", 4, 200370},
	{"VMG", 3, 209536},
	{"VMF", 3, 230818},
	{"VMET", 4, 246622},
	{"VMEN", 4, 219946},
	{"VMED", 4, 230287},
	{"VMEBUS", 6, 151994},
	{"VMD", 3, 105409},
	{"VMC", 3, 106099},
	{"VMB", 3, 217757},
	{"VMAY", 4, 197419},
	{"VMAX", 4, 121861},
	{"VMAT", 4, 198511},
	{"VMASSOL", 7, 256806},
	{"VMAS", 4, 115229},
	{"VMAR", 4, 97723},
	{"VMAN", 4, 140716},
	{"VMAK", 4, 209681},
	{"VMAH", 4, 260450},
	{"VMAD", 4, 173511},
	{"VLY", 3, 159747},
	{"VLX", 3, 246383},
	{"VLW", 3, 65060},
	{"VLV", 3, 187763},
	{"VLUCHTEN", 8, 184299},
	{"VLUCHT", 6, 164362},
	{"VLU", 3, 44699},
	{"VLTAVA", 6, 205520},
	{"VLSI", 4, 73125},
	{"VLR", 3, 157378},
	{"VLP", 3, 153882},
	{"VLOV", 4, 125986},
	{"VLOS", 4, 216305},
	{"VLOOKUP", 7, 239569},
	{"VLON", 4, 217948},
	{"VLOGS", 5, 155808},
	{"VLOGGING", 8, 189641},
	{"VLOG", 4, 97070},
	{"VLOEREN", 7, 203105},
	{"VLOER", 5, 188207},
	{"VLOCK", 5, 254807},
	{"VLM", 3, 167766},
	{"VLJ", 3, 51042},
	{"VLIW", 4, 176611},
	{"VLIV", 4, 231829},
	{"VLIST", 5, 189773},
	{"VLISSINGEN", 10, 253975},
	{"VLIS", 4, 200912},
	{"VLIPART", 7, 235880},
	{"VLINK", 5, 252048},
	{"VLIN", 4, 88553},
	{"VLIK", 4, 114645},
	{"VLIG", 4, 211448},
	{"VLIET", 5, 136297},
	{"VLIEGTUIGEN", 11, 261535},
	{"VLIEGTUIG", 9, 166580},
	{"VLIEGER", 7, 180646},
	{"VLIE", 4, 183720},
	{"VLG", 3, 163188},
	{"VLF", 3, 138113},
	{"VLEV", 4, 179555},
	{"VLET", 4, 189940},
	{"VLES", 4, 213352},
	{"VLER", 4, 228710},
	{"VLED", 4, 260451},
	{"VLECK", 5, 192712},
	{"VLEA", 4, 185100},
	{"VLDL", 4, 151052},
	{"VLDB", 4, 122685},
	{"VLD", 3, 153503},
	{"VLC", 3, 57642},
	{"VLBI", 4, 123042},
	{"VLBA", 4, 163738},
	{"VLB", 3, 202880},
	{"VLAU", 4, 233225},
	{"VLAT", 4, 165331},
	{"VLASOV", 6, 182896},
	{"VLAS", 4, 132080},
	{"VLAR", 4, 161775},
	{"VLANS", 5, 74155},
	{"VLAN", 4, 44815},
	{"VLADO", 5, 168159},
	{"VLADIVOSTOK", 11, 100355},
	{"VLADISLAV", 9, 136655},
	{"VLADIMIROVICH", 13, 261065},
	{"VLADIMIR", 8, 42377},
	{"VLADE", 5, 249713},
	{"VLAD", 4, 70125},
	{"VLAC", 4, 179876},
	{"VLAANDEREN", 10, 79792},
	{"VLAAMSE", 7, 198997},
	{"VLAAMS", 6, 148068},
	{"VLAA", 4, 181460},
	{"VKZ", 3, 239960},
	{"VKY", 3, 81931},
	{"VKW", 3, 83568},
	{"VKV", 3, 71671},
	{"VKU", 3, 52391},
	{"VKOV", 4, 207923},
	{"VKO", 3, 35512},
	{"VKLO", 4, 258533},
	{"VKL", 3, 45780},
	{"VKK", 3, 134166},
	{"VKJ", 3, 168976},
	{"VKIN", 4, 179448},
	{"VKG", 3, 138458},
	{"VKF", 3, 108036},
	{"VKD", 3, 105530},
	{"VKAT", 4, 220368},
	{"VKAR", 4, 230839},
	{"VKA", 3, 9622},
	{"VJW", 3, 122413},
	{"VJV", 3, 137026},
	{"VJUS", 4, 251458},
	{"VJU", 3, 40179},
	{"VJR", 3, 93174},
	{"VJP", 3, 127830},
	{"VJON", 4, 205191},
	{"VJOH", 4, 137322},
	{"VJO", 3, 9435},
	{"VJM", 3, 93175},
	{"VJL", 3, 141799},
	{"VJK", 3, 191883},
	{"VJJ", 3, 172127},
	{"VJIM", 4, 188130},
	{"VJF", 3, 110700},
	{"VJER", 4, 190774},
	{"VJEN", 4, 249115},
	{"VJE", 3, 33099},
	{"VJD", 3, 74806},
	{"VJB", 3, 132806},
	{"VJAN", 4, 161610},
	{"VJAM", 4, 190197},
	{"VJACHESLAV", 10, 164066},
	{"VJA", 3, 29876},
	{"VIZSLA", 6, 133847},
	{"VIZQUEL", 7, 222222},
	{"VIZQ", 4, 206084},
	{"VIZM", 4, 252836},
	{"VIZITATI", 8, 124105},
	{"VIZION", 6, 227668},
	{"VIZIO", 5, 169797},
	{"VIZIER", 6, 116848},
	{"VIZCAYA", 7, 131363},
	{"VIZCAINO", 8, 211603},
	{"VIZC", 4, 189283},
	{"VIZARD", 6, 257519},
	{"VIZAG", 5, 209593},
	{"VIXIE", 5, 131725},
	{"VIXI", 4, 242448},
	{"VIXENS", 6, 110318},
	{"VIXEN", 5, 64569},
	{"VIXE", 4, 178050},
	{"VIWO", 4, 261569},
	{"VIWI", 4, 211260},
	{"VIWH", 4, 145084},
	{"VIWE", 4, 246935},
	{"VIWA", 4, 116395},
	{"VIW", 3, 7391},
	{"VIVW", 4, 240733},
	{"VIVU", 4, 202942},
	{"VIVT", 4, 245741},
	{"VIVS", 4, 223065},
	{"VIVRE", 5, 96778},
	{"VIVR", 4, 213215},
	{"VIVOS", 5, 143648},
	{"VIVO", 4, 38075},
	{"VIVIUN", 6, 140496},
	{"VIVITAR", 7, 65180},
	{"VIVISIMO", 8, 200621},
	{"VIVISECTION", 11, 152840},
	{"VIVISECT", 8, 198840},
	{"VIVIR", 5, 149350},
	{"VIVIER", 6, 191205},
	{"VIVIENNE", 8, 79143},
	{"VIVIENDAS", 9, 225368},
	{"VIVIENDA", 8, 177312},
	{"VIVIEN", 6, 90790},
	{"VIVIDNESS", 9, 188032},
	{"VIVIDLY", 7, 71175},
	{"VIVID", 5, 37819},
	{"VIVICAM", 7, 123451},
	{"VIVICA", 6, 139665},
	{"VIVIANNE", 8, 255578},
	{"VIVIANE", 7, 139886},
	{"VIVIANA", 7, 171994},
	{"VIVIAN", 6, 51365},
	{"VIVI", 4, 80821},
	{"VIVES", 5, 147414},
	{"VIVERE", 6, 220031},
	{"VIVENDI", 7, 65396},
	{"VIVELLE", 7, 224237},
	{"VIVEKANANDA", 11, 149714},
	{"VIVEKA", 6, 209855},
	{"VIVEK", 5, 88524},
	{"VIVE", 4, 79536},
	{"VIVAX", 5, 165625},
	{"VIVATAR", 7, 187810},
	{"VIVASTREET", 10, 149240},
	{"VIVAS", 5, 213158},
	{"VIVARIUM", 8, 178997},
	{"VIVANT", 6, 129319},
	{"VIVANCO", 7, 79766},
	{"VIVAMUS", 7, 224577},
	{"VIVALDI", 7, 70434},
	{"VIVAL", 5, 259370},
	{"VIVACITY", 8, 166393},
	{"VIVACIOUSLY", 11, 167472},
	{"VIVACIOUS", 9, 124636},
	{"VIVACE", 6, 123141},
	{"VIVA", 4, 45156},
	{"VIUS", 4, 100386},
	{"VIUM", 4, 198065},
	{"VITW", 4, 181702},
	{"VITUS", 5, 147009},
	{"VITU", 4, 117587},
	{"VITTORIO", 8, 89245},
	{"VITTORIA", 8, 101039},
	{"VITTON", 6, 231482},
	{"VITTLES", 7, 212511},
	{"VITTER", 6, 145070},
	{"VITTADINI", 9, 114494},
	{"VITRY", 5, 243107},
	{"VITRUVIUS", 9, 239122},
	{"VITROS", 6, 247646},
	{"VITRONECTIN", 11, 225864},
	{"VITRO", 5, 36719},
	{"VITRIOLIC", 9, 158987},
	{"VITRIOL", 7, 110753},
	{"VITRINE", 7, 240588},
	{"VITRIFIED", 9, 173798},
	{"VITRIFICATION", 13, 167095},
	{"VITRIC", 6, 255236},
	{"VITREX", 6, 243075},
	{"VITREOUS", 8, 90928},
	{"VITRECTOMY", 10, 198188},
	{"VITRA", 5, 156858},
	{"VITR", 4, 78152},
	{"VITOSHA", 7, 248018},
	{"VITORIA", 7, 114496},
	{"VITOR", 5, 183036},
	{"VITON", 5, 128494},
	{"VITOL", 5, 168046},
	{"VITIS", 5, 138108},
	{"VITILIGO", 8, 141507},
	{"VITIELLO", 8, 260369},
	{"VITICULTURE", 11, 104123},
	{"VITICULTURAL", 12, 187765},
	{"VITIATED", 8, 227401},
	{"VITIATE", 7, 185821},
	{"VITF", 4, 245114},
	{"VITEX", 5, 148464},
	{"VITESSE", 7, 85981},
	{"VITERBO", 7, 117887},
	{"VITERBI", 7, 132097},
	{"VITELLOGENIN", 12, 239948},
	{"VITELLO", 7, 216785},
	{"VITELIC", 7, 239452},
	{"VITEL", 5, 258613},
	{"VITEK", 5, 169565},
	{"VITEBSK", 7, 181499},
	{"VITASPRINGS", 11, 159146},
	{"VITAS", 5, 218229},
	{"VITARA", 6, 89739},
	{"VITANET", 7, 110197},
	{"VITAMINSHOPPE", 13, 246187},
	{"VITAMINS", 8, 28579},
	{"VITAMINLIFE", 11, 253283},
	{"VITAMINIC", 9, 166868},
	{"VITAMINE", 8, 116432},
	{"VITAMINDER", 10, 154090},
	{"VITAMINAS", 9, 172739},
	{"VITAMINA", 8, 130960},
	{"VITAMIN", 7, 29864},
	{"VITAM", 5, 211035},
	{"VITALY", 6, 130463},
	{"VITALSTREAM", 11, 242229},
	{"VITALSTATE", 10, 237569},
	{"VITALS", 6, 117197},
	{"VITALLY", 7, 82712},
	{"VITALIY", 7, 220864},
	{"VITALITY", 8, 46455},
	{"VITALIS", 7, 227681},
	{"VITALIC", 7, 209270},
	{"VITALI", 6, 137839},
	{"VITALE", 6, 73670},
	{"VITAL", 5, 9440},
	{"VITAE", 5, 50513},
	{"VITADIGEST", 10, 260603},
	{"VITACOST", 8, 109022},
	{"VITABATH", 8, 219717},
	{"VISY", 4, 200639},
	{"VISWANATHAN", 11, 149036},
	{"VISWANATH", 9, 258116},
	{"VISW", 4, 60060},
	{"VISV", 4, 121332},
	{"VISUM", 5, 113864},
	{"VISUELLE", 8, 248915},
	{"VISUALWORKS", 11, 222672},
	{"VISUALSOFT", 10, 106884},
	{"VISUALS", 7, 52693},
	{"VISUALLY", 8, 40078},
	{"VISUALIZZA", 10, 132512},
	{"VISUALIZING", 11, 82901},
	{"VISUALIZES", 10, 211867},
	{"VISUALIZERS", 11, 227135},
	{"VISUALIZER", 10, 122891},
	{"VISUALIZED", 10, 78399},
	{"VISUALIZE", 9, 54464},
	{"VISUALIZATIONS", 14, 97115},
	{"VISUALIZATION", 13, 38708},
	{"VISUALIZAR", 10, 255535},
	{"VISUALIZADOR", 12, 181578},
	{"VISUALITY", 9, 237868},
	{"VISUALISING", 11, 174271},
	{"VISUALISER", 10, 135269},
	{"VISUALISED", 10, 180590},
	{"VISUALISE", 9, 121809},
	{"VISUALISATIONS", 14, 216421},
	{"VISUALISATION", 13, 73080},
	{"VISUALBASIC", 11, 188624},
	{"VISUALAGE", 9, 159164},
	{"VISUAL", 6, 6342},
	{"VISU", 4, 185003},
	{"VISTULA", 7, 194419},
	{"VISTOS", 6, 185156},
	{"VISTORS", 7, 157576},
	{"VISTOR", 6, 205316},
	{"VISTO", 5, 100762},
	{"VISTING", 7, 167085},
	{"VISTEON", 7, 111795},
	{"VISTEK", 6, 145722},
	{"VISTED", 6, 191285},
	{"VISTE", 5, 237559},
	{"VISTAS", 6, 67946},
	{"VISTARIL", 8, 250369},
	{"VISTAPRINT", 10, 123685},
	{"VISTANA", 7, 173466},
	{"VISTALITE", 9, 213935},
	{"VISTA", 5, 8120},
	{"VISSIM", 6, 182687},
	{"VISSER", 6, 82189},
	{"VISSEN", 6, 165295},
	{"VISSCHER", 8, 172639},
	{"VISR", 4, 86927},
	{"VISP", 4, 220951},
	{"VISORS", 6, 76900},
	{"VISOR", 5, 49659},
	{"VISONIK", 7, 174310},
	{"VISON", 5, 218493},
	{"VISNU", 5, 255071},
	{"VISNJIC", 7, 217412},
	{"VISNETIC", 8, 174207},
	{"VISM", 4, 167029},
	{"VISK", 4, 150838},
	{"VISJ", 4, 127878},
	{"VISITTEAM", 9, 196557},
	{"VISITSCOTLAND", 13, 207172},
	{"VISITS", 6, 6562},
	{"VISITORS", 8, 2926},
	{"VISITOR", 7, 5234},
	{"VISITINT", 8, 202168},
	{"VISITING", 8, 5762},
	{"VISITEZ", 7, 192266},
	{"VISITEURS", 9, 165044},
	{"VISITEUROPE", 11, 182695},
	{"VISITES", 7, 218297},
	{"VISITER", 7, 148469},
	{"VISITED", 7, 7719},
	{"VISITE", 6, 87699},
	{"VISITBRITAIN", 12, 147178},
	{"VISITATIONS", 11, 128275},
	{"VISITATION", 10, 45974},
	{"VISITAS", 7, 126609},
	{"VISITAR", 7, 212284},
	{"VISITANTES", 10, 175699},
	{"VISITA", 6, 92413},
	{"VISIT", 5, 2794},
	{"VISIPRISE", 9, 212667},
	{"VISIONTEK", 9, 129240},
	{"VISIONS", 7, 38131},
	{"VISIONNEUSE", 11, 249226},
	{"VISIONNER", 9, 185195},
	{"VISIONING", 9, 110350},
	{"VISIONGAIN", 10, 235671},
	{"VISIONEER", 9, 84342},
	{"VISIONE", 7, 176504},
	{"VISIONARY", 9, 51506},
	{"VISIONARIES", 11, 93272},
	{"VISION", 6, 3588},
	{"VISIO", 5, 58687},
	{"VISINE", 6, 238089},
	{"VISIGOTHS", 9, 212147},
	{"VISIBROKER", 10, 202739},
	{"VISIBLY", 7, 69433},
	{"VISIBLE", 7, 7279},
	{"VISIBILITY", 10, 31801},
	{"VISIBILITIES", 12, 156409},
	{"VISIBILIDAD", 11, 208049},
	{"VISHWA", 6, 199449},
	{"VISHNY", 6, 222481},
	{"VISHNU", 6, 85239},
	{"VISHAY", 6, 97338},
	{"VISHAL", 6, 114556},
	{"VISHAKHAPATNAM", 14, 248778},
	{"VISHA", 5, 194552},
	{"VISG", 4, 114799},
	{"VISF", 4, 90277},
	{"VISEU", 5, 256100},
	{"VISES", 5, 133882},
	{"VISER", 5, 191895},
	{"VISEGRAD", 8, 158018},
	{"VISED", 5, 227179},
	{"VISD", 4, 89303},
	{"VISCOUS", 7, 70982},
	{"VISCOUNT", 8, 80211},
	{"VISCOSITY", 9, 52810},
	{"VISCOSITIES", 11, 208462},
	{"VISCOSE", 7, 87238},
	{"VISCONTI", 8, 112466},
	{"VISCONTE", 8, 240393},
	{"VISCOMETER", 10, 219839},
	{"VISCOELASTICITY", 15, 255258},
	{"VISCOELASTIC", 12, 119726},
	{"VISCO", 5, 97557},
	{"VISCLOSKY", 9, 228779},
	{"VISCHER", 7, 251372},
	{"VISCERALLY", 10, 245909},
	{"VISCERAL", 8, 73648},
	{"VISCERA", 7, 136789},
	{"VISC", 4, 50092},
	{"VISBY", 5, 151972},
	{"VISB", 4, 80161},
	{"VISAYAS", 7, 136259},
	{"VISAYA", 6, 246139},
	{"VISAS", 5, 43072},
	{"VISARI", 6, 244370},
	{"VISAR", 5, 184757},
	{"VISANT", 6, 183751},
	{"VISALIA", 7, 72199},
	{"VISAKHAPATNAM", 13, 84270},
	{"VISAGES", 7, 262056},
	{"VISAGE", 6, 82740},
	{"VISABLE", 7, 184010},
	{"VISA", 4, 5303},
	{"VIRUSWALL", 9, 113116},
	{"VIRUSSCAN", 9, 80027},
	{"VIRUSES", 7, 30004},
	{"VIRUS", 5, 8608},
	{"VIRULENTLY", 10, 261483},
	{"VIRULENT", 8, 86456},
	{"VIRULENCE", 9, 76304},
	{"VIRU", 4, 198811},
	{"VIRTUS", 6, 177453},
	{"VIRTUOZZO", 9, 153437},
	{"VIRTUOUS", 8, 69889},
	{"VIRTUOSO", 8, 70548},
	{"VIRTUOSITY", 10, 117893},
	{"VIRTUOSIC", 9, 211205},
	{"VIRTUOSI", 8, 219037},
	{"VIRTUOSA", 8, 260560},
	{"VIRTUES", 7, 50751},
	{"VIRTUEMART", 10, 217666},
	{"VIRTUELLE", 9, 142086},
	{"VIRTUEL", 7, 160513},
	{"VIRTUE", 6, 28845},
	{"VIRTUANEWS", 10, 212193},
	{"VIRTUALTOURIST", 14, 191615},
	{"VIRTUALLY", 9, 6304},
	{"VIRTUALIZED", 11, 181928},
	{"VIRTUALIZE", 10, 253083},
	{"VIRTUALIZATION", 14, 62169},
	{"VIRTUALITY", 10, 176113},
	{"VIRTUALISATION", 14, 163090},
	{"VIRTUALI", 8, 260768},
	{"VIRTUALHOST", 11, 189516},
	{"VIRTUALES", 9, 205051},
	{"VIRTUALE", 8, 163120},
	{"VIRTUALDUB", 10, 137109},
	{"VIRTUALCENTER", 13, 237177},
	{"VIRTUALBOY", 10, 198789},
	{"VIRTUAL", 7, 30454},
	{"VIRTUAGIRL", 10, 166520},
	{"VIRTUA", 6, 85454},
	{"VIRTU", 5, 215310},
	{"VIRTON", 6, 248964},
	{"VIRTEX", 6, 109463},
	{"VIRTEK", 6, 216244},
	{"VIRTANEN", 8, 180160},
	{"VIRT", 4, 133166},
	{"VIRSYN", 6, 190309},
	{"VIROQUA", 7, 189621},
	{"VIRONMENTAL", 11, 226483},
	{"VIRONMENT", 9, 193464},
	{"VIROLOGY", 8, 60659},
	{"VIROLOGIST", 10, 225960},
	{"VIROLOGICAL", 11, 171464},
	{"VIROLOGIC", 9, 147750},
	{"VIROL", 5, 68816},
	{"VIRO", 4, 134402},
	{"VIRN", 4, 243900},
	{"VIRIONS", 7, 134935},
	{"VIRION", 6, 137036},
	{"VIRILITY", 8, 97090},
	{"VIRILIO", 7, 251072},
	{"VIRILE", 6, 156385},
	{"VIRII", 5, 171928},
	{"VIRIDIS", 7, 144448},
	{"VIRIDIPLANTAE", 13, 159069},
	{"VIRIDIAN", 8, 125470},
	{"VIRIAL", 6, 184342},
	{"VIRI", 4, 246019},
	{"VIRGO", 5, 56808},
	{"VIRGINS", 7, 44964},
	{"VIRGINMEGASTORES", 16, 170833},
	{"VIRGINITY", 9, 74716},
	{"VIRGINIS", 8, 261391},
	{"VIRGINIE", 8, 115243},
	{"VIRGINICA", 9, 190176},
	{"VIRGINIAUSA", 11, 217173},
	{"VIRGINIANUS", 11, 244487},
	{"VIRGINIANS", 10, 129963},
	{"VIRGINIANA", 10, 139895},
	{"VIRGINIAN", 9, 84734},
	{"VIRGINIA", 8, 2048},
	{"VIRGINAL", 8, 145704},
	{"VIRGINA", 7, 103726},
	{"VIRGIN", 6, 5000},
	{"VIRGILIO", 8, 128248},
	{"VIRGIL", 6, 60250},
	{"VIRGIE", 6, 193726},
	{"VIRGENES", 8, 212859},
	{"VIRGEN", 6, 128878},
	{"VIRGE", 5, 168714},
	{"VIRGA", 5, 244080},
	{"VIRG", 4, 172627},
	{"VIREX", 5, 202514},
	{"VIRESCENS", 9, 258268},
	{"VIRES", 5, 168910},
	{"VIREOS", 6, 254901},
	{"VIREO", 5, 100378},
	{"VIRENS", 6, 242514},
	{"VIRENDER", 8, 212700},
	{"VIREN", 5, 141757},
	{"VIREMIA", 7, 170828},
	{"VIREAD", 6, 229194},
	{"VIRDEN", 6, 143396},
	{"VIRD", 4, 223751},
	{"VIRCO", 5, 204592},
	{"VIRCHOW", 7, 222092},
	{"VIRC", 4, 228711},
	{"VIRASORO", 8, 225066},
	{"VIRAMUNE", 8, 204700},
	{"VIRAL", 5, 34560},
	{"VIRAGO", 6, 120800},
	{"VIRAGE", 6, 182255},
	{"VIRACEPT", 8, 224914},
	{"VIRA", 4, 182256},
	{"VIPUL", 5, 216985},
	{"VIPT", 4, 206085},
	{"VIPS", 4, 98075},
	{"VIPR", 4, 170985},
	{"VIPPS", 5, 114007},
	{"VIPOWER", 7, 254787},
	{"VIPO", 4, 202051},
	{"VIPNET", 6, 257001},
	{"VIPL", 4, 228712},
	{"VIPIX", 5, 76505},
	{"VIPIN", 5, 260303},
	{"VIPERS", 6, 94571},
	{"VIPERA", 6, 257242},
	{"VIPER", 5, 46905},
	{"VIPE", 4, 88062},
	{"VIPASSANA", 9, 143443},
	{"VIP", 3, 32762},
	{"VIOXX", 5, 43785},
	{"VIOX", 4, 245336},
	{"VIOUSLY", 7, 183702},
	{"VIOUS", 5, 157815},
	{"VIOU", 4, 3767},
	{"VIORST", 6, 213746},
	{"VIONNET", 7, 172250},
	{"VIOLS", 5, 250606},
	{"VIOLONCELLO", 11, 104903},
	{"VIOLON", 6, 180544},
	{"VIOLIST", 7, 208356},
	{"VIOLINS", 7, 72845},
	{"VIOLINO", 7, 249614},
	{"VIOLINISTS", 10, 159009},
	{"VIOLINIST", 9, 81724},
	{"VIOLIN", 6, 36051},
	{"VIOLETTE", 8, 133118},
	{"VIOLETTA", 8, 180700},
	{"VIOLETS", 7, 79228},
	{"VIOLETA", 7, 176168},
	{"VIOLET", 6, 38884},
	{"VIOLENZ", 7, 249413},
	{"VIOLENTLY", 9, 61835},
	{"VIOLENT", 7, 6868},
	{"VIOLENCIA", 9, 169077},
	{"VIOLENCE", 8, 3082},
	{"VIOLE", 5, 241578},
	{"VIOLATORS", 9, 75369},
	{"VIOLATOR", 8, 92353},
	{"VIOLATIVE", 9, 134490},
	{"VIOLATIONS", 10, 29858},
	{"VIOLATION", 9, 9237},
	{"VIOLATING", 9, 47172},
	{"VIOLATES", 8, 47078},
	{"VIOLATED", 8, 39584},
	{"VIOLATE", 7, 9478},
	{"VIOLAS", 6, 142958},
	{"VIOLACION", 9, 158309},
	{"VIOLACEA", 8, 243747},
	{"VIOLA", 5, 45250},
	{"VIOL", 4, 85230},
	{"VIOGNIER", 8, 127052},
	{"VIOF", 4, 136509},
	{"VIOD", 4, 226974},
	{"VIOBIN", 6, 246842},
	{"VIOB", 4, 160883},
	{"VINZ", 4, 246936},
	{"VINYLS", 6, 111090},
	{"VINYLIDENE", 10, 258749},
	{"VINYL", 5, 6883},
	{"VINYASA", 7, 177560},
	{"VINYARD", 7, 211027},
	{"VINY", 4, 262028},
	{"VINW", 4, 66260},
	{"VINV", 4, 148107},
	{"VINUM", 5, 138626},
	{"VINU", 4, 157528},
	{"VINTON", 6, 86281},
	{"VINTNERS", 8, 127628},
	{"VINTNER", 7, 167543},
	{"VINTEN", 6, 187540},
	{"VINTAGES", 8, 81539},
	{"VINTAGE", 7, 3934},
	{"VINSON", 6, 83538},
	{"VINSCHEN", 8, 166338},
	{"VINR", 4, 73667},
	{"VINPOCETINE", 11, 203557},
	{"VINP", 4, 79175},
	{"VINOS", 5, 151234},
	{"VINORELBINE", 11, 218136},
	{"VINOGRAPHY", 10, 242695},
	{"VINOGRADOV", 10, 238042},
	{"VINOD", 5, 102139},
	{"VINNY", 5, 81032},
	{"VINNITSA", 8, 216582},
	{"VINNIE", 6, 78882},
	{"VINNI", 5, 221314},
	{"VINM", 4, 62574},
	{"VINLAND", 7, 215711},
	{"VINL", 4, 82704},
	{"VINK", 4, 179944},
	{"VINJ", 4, 90918},
	{"VINITA", 6, 156098},
	{"VININGS", 7, 141414},
	{"VINING", 6, 111588},
	{"VINIFERA", 8, 178339},
	{"VINICIUS", 8, 199655},
	{"VINHO", 5, 210332},
	{"VINGT", 5, 169137},
	{"VINGE", 5, 187376},
	{"VING", 4, 123797},
	{"VINF", 4, 75189},
	{"VINEYARDS", 9, 46055},
	{"VINEYARD", 8, 40385},
	{"VINEY", 5, 184944},
	{"VINES", 5, 48766},
	{"VINER", 5, 143574},
	{"VINELAND", 8, 81978},
	{"VINEGARS", 8, 126126},
	{"VINEGAR", 7, 45197},
	{"VINEET", 6, 169040},
	{"VINDT", 5, 223183},
	{"VINDSL", 6, 237315},
	{"VINDO", 5, 203056},
	{"VINDIGO", 7, 214912},
	{"VINDICTIVENESS", 14, 238962},
	{"VINDICTIVE", 10, 117227},
	{"VINDICATOR", 10, 203937},
	{"VINDICATION", 11, 103394},
	{"VINDICATING", 11, 226686},
	{"VINDICATES", 10, 254909},
	{"VINDICATED", 10, 96334},
	{"VINDICATE", 9, 134044},
	{"VINDEN", 6, 162578},
	{"VINDALOO", 8, 205156},
	{"VIND", 4, 107275},
	{"VINCRISTINE", 11, 127942},
	{"VINCI", 5, 43281},
	{"VINCENZO", 8, 87763},
	{"VINCENTS", 8, 194467},
	{"VINCENTIAN", 10, 215815},
	{"VINCENTELLI", 11, 261679},
	{"VINCENTE", 8, 146455},
	{"VINCENT", 7, 8991},
	{"VINCENNES", 9, 93486},
	{"VINCE", 5, 40144},
	{"VINCCI", 6, 179524},
	{"VINCA", 5, 139336},
	{"VINBLASTINE", 11, 166562},
	{"VINB", 4, 71433},
	{"VINAYAK", 7, 205965},
	{"VINAYA", 6, 208982},
	{"VINAY", 5, 117260},
	{"VINATIERI", 9, 191439},
	{"VINAL", 5, 232804},
	{"VINAIGRETTE", 11, 81490},
	{"VIMY", 4, 201857},
	{"VIMU", 4, 246038},
	{"VIMS", 4, 189606},
	{"VIMRC", 5, 230694},
	{"VIMPELCOM", 9, 202472},
	{"VIMP", 4, 234889},
	{"VIMO", 4, 201223},
	{"VIMI", 4, 202210},
	{"VIMES", 5, 180070},
	{"VIMEO", 5, 147729},
	{"VIMENTIN", 8, 169838},
	{"VIME", 4, 142841},
	{"VIMAX", 5, 109870},
	{"VIMAGEDIMENSION", 15, 223273},
	{"VIMA", 4, 119139},
	{"VILW", 4, 39820},
	{"VILV", 4, 180442},
	{"VILU", 4, 103177},
	{"VILT", 4, 75444},
	{"VILSACK", 7, 143712},
	{"VILS", 4, 37959},
	{"VILR", 4, 52428},
	{"VILP", 4, 73242},
	{"VILO", 4, 86112},
	{"VILNIUS", 7, 63268},
	{"VILNA", 5, 179182},
	{"VILN", 4, 94957},
	{"VILMA", 5, 165467},
	{"VILM", 4, 78903},
	{"VILLUS", 6, 200293},
	{"VILLOUS", 7, 221321},
	{"VILLOSA", 7, 218593},
	{"VILLON", 6, 202362},
	{"VILLIGER", 8, 255176},
	{"VILLIERS", 8, 95685},
	{"VILLIANS", 8, 144676},
	{"VILLIAN", 7, 138885},
	{"VILLIAGE", 8, 229876},
	{"VILLI", 5, 172522},
	{"VILLEURBANNE", 12, 239754},
	{"VILLETTE", 8, 161880},
	{"VILLES", 6, 149134},
	{"VILLERS", 7, 193129},
	{"VILLEROY", 8, 70834},
	{"VILLEPIN", 8, 158251},
	{"VILLENEUVE", 10, 85735},
	{"VILLEGAS", 8, 134748},
	{"VILLEFRANCHE", 12, 167198},
	{"VILLE", 5, 46810},
	{"VILLAWARE", 9, 108604},
	{"VILLAS", 6, 29141},
	{"VILLARS", 7, 140671},
	{"VILLARREAL", 10, 98292},
	{"VILLAREAL", 9, 197241},
	{"VILLARD", 7, 123923},
	{"VILLARAIGOSA", 12, 166576},
	{"VILLAR", 6, 170041},
	{"VILLANUEVA", 10, 102578},
	{"VILLANOVA", 9, 59832},
	{"VILLANI", 7, 226346},
	{"VILLANELLE", 10, 258669},
	{"VILLAMARTIN", 11, 219806},
	{"VILLALON", 8, 218317},
	{"VILLALOBOS", 10, 132529},
	{"VILLALBA", 8, 229972},
	{"VILLAINY", 8, 144949},
	{"VILLAINS", 8, 53510},
	{"VILLAINOUS", 10, 114193},
	{"VILLAIN", 7, 56131},
	{"VILLAHERMOSA", 12, 201846},
	{"VILLAGGIO", 9, 178246},
	{"VILLAGEWARE", 11, 225767},
	{"VILLAGES", 8, 32529},
	{"VILLAGERS", 9, 52078},
	{"VILLAGER", 8, 77303},
	{"VILLAGE", 7, 3757},
	{"VILLAFRANCA", 11, 236873},
	{"VILLACH", 7, 214148},
	{"VILLA", 5, 6671},
	{"VILL", 4, 88009},
	{"VILKET", 6, 212600},
	{"VILKA", 5, 229369},
	{"VILK", 4, 172481},
	{"VILJOEN", 7, 183653},
	{"VILJ", 4, 154640},
	{"VILIFY", 6, 209568},
	{"VILIFIED", 8, 151699},
	{"VILIFICATION", 12, 151827},
	{"VILH", 4, 100923},
	{"VILG", 4, 104155},
	{"VILF", 4, 103489},
	{"VILEST", 6, 180431},
	{"VILES", 5, 217884},
	{"VILE", 4, 63391},
	{"VILD", 4, 70835},
	{"VILC", 4, 69967},
	{"VILB", 4, 96419},
	{"VILAS", 5, 96215},
	{"VILAR", 5, 217211},
	{"VILANOVA", 8, 242791},
	{"VILANCULOS", 10, 205796},
	{"VILAMOURA", 9, 135613},
	{"VILAINE", 7, 224738},
	{"VILA", 4, 68191},
	{"VIKW", 4, 219293},
	{"VIKTORIA", 8, 126708},
	{"VIKTOR", 6, 64993},
	{"VIKT", 4, 99931},
	{"VIKS", 4, 110673},
	{"VIKRAM", 6, 86732},
	{"VIKR", 4, 111628},
	{"VIKP", 4, 251459},
	{"VIKO", 4, 202052},
	{"VIKLUND", 7, 240198},
	{"VIKKI", 5, 105996},
	{"VIKK", 4, 261947},
	{"VIKINGS", 7, 45994},
	{"VIKING", 6, 36492},
	{"VIKI", 4, 152524},
	{"VIKES", 5, 180365},
	{"VIKE", 4, 253859},
	{"VIKAS", 5, 107134},
	{"VIKA", 4, 122559},
	{"VIJVER", 6, 191813},
	{"VIJO", 4, 234890},
	{"VIJAYAWADA", 10, 88944},
	{"VIJAYAN", 7, 193931},
	{"VIJAYA", 6, 152378},
	{"VIJAY", 5, 64315},
	{"VIIX", 4, 252092},
	{"VIIW", 4, 182754},
	{"VIIV", 4, 122888},
	{"VIIP", 4, 209682},
	{"VIIM", 4, 257779},
	{"VIII", 4, 33286},
	{"VIID", 4, 249116},
	{"VIIC", 4, 190198},
	{"VIHARA", 6, 253628},
	{"VIHAR", 5, 134041},
	{"VIGUEUR", 7, 172735},
	{"VIGU", 4, 260452},
	{"VIGRX", 5, 88900},
	{"VIGRA", 5, 219881},
	{"VIGR", 4, 231830},
	{"VIGOUR", 6, 94466},
	{"VIGOTTI", 7, 211123},
	{"VIGOROUSLY", 10, 58775},
	{"VIGOROUS", 8, 50818},
	{"VIGORISH", 8, 90315},
	{"VIGORELLE", 9, 260254},
	{"VIGOR", 5, 62303},
	{"VIGO", 4, 78661},
	{"VIGNON", 6, 256998},
	{"VIGNETTING", 10, 148514},
	{"VIGNETTES", 9, 79945},
	{"VIGNETTE", 8, 65676},
	{"VIGNES", 6, 186797},
	{"VIGNE", 5, 165142},
	{"VIGNAUD", 7, 123486},
	{"VIGNA", 5, 143425},
	{"VIGN", 4, 73338},
	{"VIGLEN", 6, 170325},
	{"VIGL", 4, 213403},
	{"VIGINA", 6, 130430},
	{"VIGILS", 6, 121119},
	{"VIGILANZA", 9, 209339},
	{"VIGILANTLY", 10, 261044},
	{"VIGILANTES", 10, 119768},
	{"VIGILANTE", 9, 89409},
	{"VIGILANT", 8, 67943},
	{"VIGILANCE", 9, 66999},
	{"VIGIL", 5, 58127},
	{"VIGI", 4, 60861},
	{"VIGGO", 5, 88252},
	{"VIGGEN", 6, 227450},
	{"VIGG", 4, 234572},
	{"VIGE", 4, 161363},
	{"VIGD", 4, 258893},
	{"VIFO", 4, 176980},
	{"VIFI", 4, 217259},
	{"VIEY", 4, 169266},
	{"VIEWTOPIC", 9, 182502},
	{"VIEWTIFUL", 9, 104675},
	{"VIEWSTATION", 11, 200864},
	{"VIEWSTATE", 9, 157160},
	{"VIEWSONIC", 9, 43582},
	{"VIEWSJAN", 8, 221484},
	{"VIEWSCREEN", 10, 214143},
	{"VIEWS", 5, 1831},
	{"VIEWREF", 7, 129010},
	{"VIEWPORTS", 9, 198392},
	{"VIEWPORT", 8, 92677},
	{"VIEWPOINTS", 10, 49243},
	{"VIEWPOINT", 9, 39956},
	{"VIEWPICTURE", 11, 32218},
	{"VIEWPERF", 8, 187960},
	{"VIEWMOL", 7, 177415},
	{"VIEWMASTER", 10, 112908},
	{"VIEWLOADER", 10, 243407},
	{"VIEWINGS", 8, 110551},
	{"VIEWING", 7, 4400},
	{"VIEWGREATER", 11, 120677},
	{"VIEWFRAMETABLE", 14, 245513},
	{"VIEWFINDERS", 11, 235351},
	{"VIEWFINDER", 10, 60299},
	{"VIEWFILE", 8, 235822},
	{"VIEWERSHIP", 10, 145111},
	{"VIEWERS", 7, 36288},
	{"VIEWER", 6, 7847},
	{"VIEWED", 6, 3532},
	{"VIEWCVS", 7, 55802},
	{"VIEWCOM", 7, 188343},
	{"VIEWCAST", 8, 208232},
	{"VIEWCART", 8, 233747},
	{"VIEWCAM", 7, 215968},
	{"VIEWBOOK", 8, 177150},
	{"VIEWAUTH", 8, 158188},
	{"VIEWABLE", 8, 55484},
	{"VIEW", 4, 1662},
	{"VIEV", 4, 98428},
	{"VIEUX", 5, 82514},
	{"VIEU", 4, 152866},
	{"VIETS", 5, 254511},
	{"VIETRI", 6, 223888},
	{"VIETOR", 6, 246148},
	{"VIETNAMNET", 10, 171844},
	{"VIETNAMESE", 10, 34171},
	{"VIETNAM", 7, 6419},
	{"VIETH", 5, 139720},
	{"VIETCONG", 8, 95479},
	{"VIETA", 5, 189131},
	{"VIESTURS", 8, 254867},
	{"VIERNES", 7, 128780},
	{"VIERLING", 8, 206133},
	{"VIERI", 5, 220852},
	{"VIERGE", 6, 189062},
	{"VIERA", 5, 117142},
	{"VIER", 4, 105059},
	{"VIEQUES", 7, 106027},
	{"VIEQ", 4, 182519},
	{"VIEP", 4, 83271},
	{"VIENTOS", 7, 129030},
	{"VIENTO", 6, 81670},
	{"VIENTIANE", 9, 92197},
	{"VIENT", 5, 166926},
	{"VIENS", 5, 172540},
	{"VIENNESE", 8, 101703},
	{"VIENNE", 6, 116878},
	{"VIENNAAUTOSHOW", 14, 214672},
	{"VIENNA", 6, 29694},
	{"VIENE", 5, 135080},
	{"VIENDO", 6, 142629},
	{"VIENA", 5, 215706},
	{"VIEM", 4, 80343},
	{"VIELLEICHT", 10, 158928},
	{"VIELLE", 6, 204183},
	{"VIELES", 6, 120529},
	{"VIELEN", 6, 129199},
	{"VIELE", 5, 106081},
	{"VIEL", 4, 97122},
	{"VIEK", 4, 196772},
	{"VIEJO", 5, 59888},
	{"VIEJAS", 6, 164618},
	{"VIEJA", 5, 128157},
	{"VIEJ", 4, 120035},
	{"VIEIRA", 6, 92362},
	{"VIEILLES", 8, 229053},
	{"VIEILLE", 7, 125979},
	{"VIEG", 4, 94566},
	{"VIEF", 4, 78970},
	{"VIEDOS", 6, 226320},
	{"VIEDO", 5, 146609},
	{"VIED", 4, 184680},
	{"VIEC", 4, 176877},
	{"VIEB", 4, 73986},
	{"VIDZ", 4, 143818},
	{"VIDYALAYA", 9, 212598},
	{"VIDYA", 5, 118623},
	{"VIDY", 4, 100744},
	{"VIDW", 4, 58967},
	{"VIDV", 4, 111103},
	{"VIDUKA", 6, 249375},
	{"VIDUALS", 7, 142634},
	{"VIDUAL", 6, 109598},
	{"VIDU", 4, 6298},
	{"VIDT", 4, 70819},
	{"VIDSVIDSVIDS", 12, 64791},
	{"VIDS", 4, 34282},
	{"VIDRO", 5, 158942},
	{"VIDR", 4, 65506},
	{"VIDPRO", 6, 227518},
	{"VIDP", 4, 65181},
	{"VIDOS", 5, 216976},
	{"VIDOR", 5, 148084},
	{"VIDOES", 6, 106030},
	{"VIDOE", 5, 135419},
	{"VIDO", 4, 139904},
	{"VIDN", 4, 102446},
	{"VIDMAR", 6, 209537},
	{"VIDM", 4, 60046},
	{"VIDLER", 6, 261749},
	{"VIDL", 4, 58591},
	{"VIDK", 4, 84888},
	{"VIDJ", 4, 89785},
	{"VIDIX", 5, 230755},
	{"VIDIOS", 6, 97803},
	{"VIDIO", 5, 73482},
	{"VIDING", 6, 151268},
	{"VIDIN", 5, 161006},
	{"VIDIKRON", 8, 233149},
	{"VIDIEO", 6, 163958},
	{"VIDI", 4, 132920},
	{"VIDH", 4, 60990},
	{"VIDG", 4, 67788},
	{"VIDF", 4, 75072},
	{"VIDEX", 5, 169649},
	{"VIDETTE", 7, 232568},
	{"VIDES", 5, 97788},
	{"VIDERE", 6, 252904},
	{"VIDER", 5, 248631},
	{"VIDEOWAVE", 9, 234822},
	{"VIDEOTRON", 9, 240305},
	{"VIDEOTEX", 8, 205089},
	{"VIDEOTAPING", 11, 126293},
	{"VIDEOTAPES", 10, 73733},
	{"VIDEOTAPED", 10, 91409},
	{"VIDEOTAPE", 9, 50718},
	{"VIDEOSZ", 7, 167612},
	{"VIDEOSTUDIO", 11, 159141},
	{"VIDEOSPIELE", 11, 203369},
	{"VIDEOSEVEN", 10, 148753},
	{"VIDEOS", 6, 1593},
	{"VIDEOROLL", 9, 196129},
	{"VIDEOREDO", 9, 187346},
	{"VIDEORECORDING", 14, 87297},
	{"VIDEORECORDER", 13, 112068},
	{"VIDEORAMA", 9, 246297},
	{"VIDEOPROJECTOR", 14, 178147},
	{"VIDEOPOKER", 10, 121813},
	{"VIDEOPHONES", 11, 256723},
	{"VIDEOPHONE", 10, 129399},
	{"VIDEOPAL", 8, 195132},
	{"VIDEONTSC", 9, 196123},
	{"VIDEONOW", 8, 191201},
	{"VIDEONICS", 9, 198342},
	{"VIDEOMAKER", 10, 180151},
	{"VIDEOLOGIC", 10, 152426},
	{"VIDEOLIB", 8, 233144},
	{"VIDEOLAN", 8, 101083},
	{"VIDEOJUEGOS", 11, 119073},
	{"VIDEOHOUND", 10, 159248},
	{"VIDEOHELP", 9, 232475},
	{"VIDEOGUARD", 10, 243259},
	{"VIDEOGRAPHY", 11, 66490},
	{"VIDEOGRAPHERS", 13, 69778},
	{"VIDEOGRAPHER", 12, 80970},
	{"VIDEOGIOCHI", 11, 184758},
	{"VIDEOGAMES", 10, 47793},
	{"VIDEOGAME", 9, 68509},
	{"VIDEOFREE", 9, 243221},
	{"VIDEOFLICKS", 11, 236048},
	{"VIDEOETA", 8, 147951},
	{"VIDEOES", 7, 246384},
	{"VIDEODROME", 10, 210596},
	{"VIDEODISC", 9, 159763},
	{"VIDEOCONFERENCING", 17, 68693},
	{"VIDEOCONFERENCES", 16, 201165},
	{"VIDEOCONFERENCE", 15, 101080},
	{"VIDEOCLIPS", 10, 96866},
	{"VIDEOCLIP", 9, 102691},
	{"VIDEOCHIP", 9, 173005},
	{"VIDEOCHAT", 9, 94338},
	{"VIDEOCD", 7, 229409},
	{"VIDEOCAST", 9, 249063},
	{"VIDEOCASSETTES", 14, 137237},
	{"VIDEOCASSETTE", 13, 103030},
	{"VIDEOCARDS", 10, 134010},
	{"VIDEOCARD", 9, 150948},
	{"VIDEOCAMS", 9, 193411},
	{"VIDEOCAMERAACCESSORY", 20, 231063},
	{"VIDEOCAMERA", 11, 146864},
	{"VIDEOCAM", 8, 196823},
	{"VIDEOCABLEPLUG", 14, 166527},
	{"VIDEOCABLE", 10, 138663},
	{"VIDEOBUSH", 9, 243763},
	{"VIDEOBLOGGING", 13, 167644},
	{"VIDEOBLOG", 9, 161341},
	{"VIDEO", 5, 3334},
	{"VIDEL", 5, 108974},
	{"VIDEK", 5, 205702},
	{"VIDED", 5, 94137},
	{"VIDEAL", 6, 185021},
	{"VIDE", 4, 58240},
	{"VIDD", 4, 70407},
	{"VIDCO", 5, 222620},
	{"VIDCAST", 7, 203589},
	{"VIDCAPS", 7, 173988},
	{"VIDC", 4, 54873},
	{"VIDB", 4, 52978},
	{"VIDAS", 5, 186418},
	{"VIDARE", 6, 242032},
	{"VIDAR", 5, 110491},
	{"VIDALIA", 7, 112930},
	{"VIDAL", 5, 60674},
	{"VIDA", 4, 47331},
	{"VID", 3, 28586},
	{"VICW", 4, 102501},
	{"VICV", 4, 211071},
	{"VICU", 4, 156622},
	{"VICTUALS", 8, 191186},
	{"VICTROLA", 8, 200307},
	{"VICTORY", 7, 611},
	{"VICTORVILLE", 11, 83729},
	{"VICTORS", 7, 107107},
	{"VICTORIOUSLY", 12, 149934},
	{"VICTORIOUS", 10, 62931},
	{"VICTORIO", 8, 199499},
	{"VICTORINOX", 10, 62276},
	{"VICTORIES", 9, 50617},
	{"VICTORIAVILLE", 13, 216014},
	{"VICTORIAS", 9, 120990},
	{"VICTORIANS", 10, 107360},
	{"VICTORIANA", 10, 181559},
	{"VICTORIAN", 9, 30085},
	{"VICTORIA", 8, 4662},
	{"VICTORI", 7, 244655},
	{"VICTOR", 6, 29267},
	{"VICTOIRES", 9, 247816},
	{"VICTOIRE", 8, 150719},
	{"VICTO", 5, 207985},
	{"VICTIONARY", 10, 203088},
	{"VICTIMS", 7, 7368},
	{"VICTIMOLOGY", 11, 242709},
	{"VICTIMLESS", 10, 233030},
	{"VICTIMIZED", 10, 89130},
	{"VICTIMIZE", 9, 238039},
	{"VICTIMIZATION", 13, 84613},
	{"VICTIMISED", 10, 189453},
	{"VICTIMISATION", 13, 128911},
	{"VICTIMHOOD", 10, 218347},
	{"VICTIME", 7, 230181},
	{"VICTIM", 6, 3192},
	{"VICT", 4, 150657},
	{"VICS", 4, 140798},
	{"VICROADS", 8, 232805},
	{"VICR", 4, 133181},
	{"VICOR", 5, 218271},
	{"VICOPROFEN", 10, 136490},
	{"VICON", 5, 185799},
	{"VICOMTE", 7, 196405},
	{"VICODINE", 8, 243688},
	{"VICODIN", 7, 37450},
	{"VICO", 4, 135759},
	{"VICNET", 6, 223228},
	{"VICN", 4, 205737},
	{"VICM", 4, 132178},
	{"VICKY", 5, 53097},
	{"VICKSBURG", 9, 71945},
	{"VICKS", 5, 119847},
	{"VICKREY", 7, 203776},
	{"VICKIE", 6, 77123},
	{"VICKI", 5, 48644},
	{"VICKERY", 7, 107627},
	{"VICKERS", 7, 61945},
	{"VICKERMAN", 9, 251961},
	{"VICK", 4, 69976},
	{"VICISSITUDES", 12, 143981},
	{"VICIOUSNESS", 11, 204062},
	{"VICIOUSLY", 9, 118298},
	{"VICIOUS", 7, 46018},
	{"VICIOSOS", 8, 251880},
	{"VICIO", 5, 255902},
	{"VICINO", 6, 150309},
	{"VICINITY", 8, 39623},
	{"VICINI", 6, 179023},
	{"VICIA", 5, 174506},
	{"VICI", 4, 147638},
	{"VICHY", 5, 101360},
	{"VICH", 4, 238373},
	{"VICG", 4, 140573},
	{"VICF", 4, 135731},
	{"VICEVERSA", 9, 211228},
	{"VICES", 5, 61885},
	{"VICEROY", 7, 98635},
	{"VICENZA", 7, 100998},
	{"VICENTE", 7, 66373},
	{"VICE", 4, 3881},
	{"VICD", 4, 130003},
	{"VICCO", 5, 225707},
	{"VICCA", 5, 218538},
	{"VICB", 4, 135519},
	{"VICARS", 6, 164775},
	{"VICARIOUSLY", 11, 132733},
	{"VICARIOUS", 9, 101062},
	{"VICARIO", 7, 241556},
	{"VICARIATE", 9, 260016},
	{"VICARAGE", 8, 110764},
	{"VICAR", 5, 66283},
	{"VICA", 4, 194485},
	{"VIC", 3, 29262},
	{"VIBURNUM", 8, 119233},
	{"VIBU", 4, 248156},
	{"VIBS", 4, 103104},
	{"VIBRO", 5, 135150},
	{"VIBRIO", 6, 90546},
	{"VIBRATO", 7, 109060},
	{"VIBRATIONS", 10, 54201},
	{"VIBRATIONAL", 11, 71602},
	{"VIBRATION", 9, 38660},
	{"VIBRATING", 9, 50964},
	{"VIBRATES", 8, 128932},
	{"VIBRATER", 8, 138011},
	{"VIBRATED", 8, 179299},
	{"VIBRATE", 7, 87702},
	{"VIBRAPOD", 8, 215952},
	{"VIBRAPHONE", 10, 119702},
	{"VIBRANTLY", 9, 197829},
	{"VIBRANT", 7, 39550},
	{"VIBRANCY", 8, 122807},
	{"VIBRANCE", 8, 203187},
	{"VIBRAM", 6, 179284},
	{"VIBRA", 5, 132373},
	{"VIBR", 4, 49719},
	{"VIBORG", 6, 171072},
	{"VIBO", 4, 257606},
	{"VIBH", 4, 233226},
	{"VIBES", 5, 60226},
	{"VIBERT", 6, 183537},
	{"VIBE", 4, 46367},
	{"VIBBER", 6, 169167},
	{"VIBA", 4, 258151},
	{"VIAY", 4, 202053},
	{"VIAW", 4, 76905},
	{"VIAVOICE", 8, 157874},
	{"VIAV", 4, 138537},
	{"VIATOR", 6, 123058},
	{"VIATICAL", 8, 111334},
	{"VIATALK", 7, 206348},
	{"VIAT", 4, 32502},
	{"VIASAT", 6, 197695},
	{"VIAREGGIO", 9, 169337},
	{"VIARAMA", 7, 188690},
	{"VIAR", 4, 74996},
	{"VIAQ", 4, 194502},
	{"VIAPAL", 6, 259239},
	{"VIAP", 4, 82100},
	{"VIANNEY", 7, 193030},
	{"VIANDE", 6, 222334},
	{"VIANA", 5, 155746},
	{"VIAMICHELIN", 11, 245982},
	{"VIAM", 4, 84726},
	{"VIALTA", 6, 175239},
	{"VIALS", 5, 68721},
	{"VIALE", 5, 108966},
	{"VIAL", 4, 61458},
	{"VIAK", 4, 152459},
	{"VIAJES", 6, 75978},
	{"VIAJEROS", 8, 98379},
	{"VIAJE", 5, 106147},
	{"VIAJAR", 6, 196042},
	{"VIAJANTES", 9, 244960},
	{"VIAJ", 4, 172376},
	{"VIAGRA", 6, 4597},
	{"VIAGGIO", 7, 86443},
	{"VIAGGIATORI", 11, 144741},
	{"VIAGGIATORE", 11, 109679},
	{"VIAGGIA", 7, 189656},
	{"VIAGGI", 6, 93017},
	{"VIAGEM", 6, 239312},
	{"VIAGARA", 7, 173876},
	{"VIAG", 4, 227704},
	{"VIAF", 4, 89790},
	{"VIADUCT", 7, 92426},
	{"VIAD", 4, 73114},
	{"VIACREME", 8, 195932},
	{"VIACOM", 6, 67629},
	{"VIACK", 5, 232193},
	{"VIACCESS", 8, 178710},
	{"VIAC", 4, 66435},
	{"VIABLE", 6, 37131},
	{"VIABILITY", 9, 45839},
	{"VHTF", 4, 230359},
	{"VHS", 3, 3862},
	{"VHOW", 4, 206997},
	{"VHOSTS", 6, 60516},
	{"VHOST", 5, 182220},
	{"VHOL", 4, 212619},
	{"VHFCONTESTING", 13, 182377},
	{"VHEW", 4, 253889},
	{"VHER", 4, 214815},
	{"VHEL", 4, 222165},
	{"VHDL", 4, 78363},
	{"VHDCI", 5, 193014},
	{"VHCS", 4, 224987},
	{"VHAV", 4, 156459},
	{"VHAR", 4, 211449},
	{"VHAL", 4, 188284},
	{"VHAD", 4, 102522},
	{"VGZ", 3, 250003},
	{"VGY", 3, 89901},
	{"VGX", 3, 260394},
	{"VGW", 3, 55991},
	{"VGV", 3, 100098},
	{"VGUI", 4, 92031},
	{"VGU", 3, 8040},
	{"VGROUP", 6, 50370},
	{"VGRO", 4, 213404},
	{"VGRE", 4, 186899},
	{"VGRD", 4, 192615},
	{"VGRA", 4, 168541},
	{"VGR", 3, 196091},
	{"VGP", 3, 119045},
	{"VGOV", 4, 260052},
	{"VGOT", 4, 247871},
	{"VGOR", 4, 129251},
	{"VGM", 3, 208847},
	{"VGL", 3, 240684},
	{"VGJ", 3, 153334},
	{"VGG", 3, 73005},
	{"VGF", 3, 191862},
	{"VGEX", 4, 177343},
	{"VGER", 4, 240004},
	{"VGEO", 4, 197420},
	{"VGEN", 4, 98976},
	{"VGCHEATE", 8, 143866},
	{"VGC", 3, 77011},
	{"VGAV", 4, 243619},
	{"VGAS", 4, 250684},
	{"VGAR", 4, 196296},
	{"VGAN", 4, 132426},
	{"VGAM", 4, 150729},
	{"VFX", 3, 121775},
	{"VFWP", 4, 176128},
	{"VFWA", 4, 256338},
	{"VFW", 3, 79513},
	{"VFV", 3, 104335},
	{"VFUNC", 5, 140607},
	{"VFU", 3, 173245},
	{"VFTOOL", 6, 244413},
	{"VFRO", 4, 110070},
	{"VFRE", 4, 207202},
	{"VFRA", 4, 186377},
	{"VFR", 3, 69117},
	{"VFPRINTF", 8, 249754},
	{"VFP", 3, 102037},
	{"VFOU", 4, 201571},
	{"VFORK", 5, 208216},
	{"VFOO", 4, 200555},
	{"VFO", 3, 258},
	{"VFM", 3, 131942},
	{"VFLA", 4, 234573},
	{"VFL", 3, 149306},
	{"VFK", 3, 168977},
	{"VFJ", 3, 137027},
	{"VFIR", 4, 217260},
	{"VFIN", 4, 181233},
	{"VFILE", 5, 242869},
	{"VFIL", 4, 141325},
	{"VFF", 3, 241475},
	{"VFD", 3, 72244},
	{"VFC", 3, 149434},
	{"VFB", 3, 154759},
	{"VFAT", 4, 144156},
	{"VFAN", 4, 234891},
	{"VFAM", 4, 236731},
	{"VFAC", 4, 252488},
	{"VEZW", 4, 144930},
	{"VEZT", 4, 174143},
	{"VEZS", 4, 113038},
	{"VEZR", 4, 216651},
	{"VEZP", 4, 255986},
	{"VEZO", 4, 109277},
	{"VEZM", 4, 158211},
	{"VEZINA", 6, 256134},
	{"VEZI", 4, 251127},
	{"VEZH", 4, 158044},
	{"VEZF", 4, 251784},
	{"VEZE", 4, 116698},
	{"VEZD", 4, 192343},
	{"VEZC", 4, 201224},
	{"VEZB", 4, 261196},
	{"VEZA", 4, 101739},
	{"VEYZ", 4, 257024},
	{"VEYW", 4, 80174},
	{"VEYU", 4, 141531},
	{"VEYT", 4, 69682},
	{"VEYS", 4, 240686},
	{"VEYRON", 6, 167940},
	{"VEYR", 4, 90531},
	{"VEYP", 4, 109778},
	{"VEYN", 4, 164890},
	{"VEYM", 4, 109755},
	{"VEYL", 4, 150784},
	{"VEYK", 4, 199023},
	{"VEYJ", 4, 194503},
	{"VEYI", 4, 64247},
	{"VEYH", 4, 107372},
	{"VEYG", 4, 171097},
	{"VEYF", 4, 95838},
	{"VEYE", 4, 28316},
	{"VEYD", 4, 111847},
	{"VEYC", 4, 89844},
	{"VEYB", 4, 91413},
	{"VEXTREC", 7, 187494},
	{"VEXTRA", 6, 228006},
	{"VEXT", 4, 217064},
	{"VEXP", 4, 146399},
	{"VEXING", 6, 131844},
	{"VEXI", 4, 141582},
	{"VEXED", 5, 107873},
	{"VEXE", 4, 160884},
	{"VEXCOM", 6, 193157},
	{"VEXC", 4, 215656},
	{"VEXATIOUS", 9, 146392},
	{"VEXATION", 8, 159307},
	{"VEXA", 4, 186122},
	{"VEWY", 4, 259649},
	{"VEWR", 4, 58927},
	{"VEWO", 4, 34392},
	{"VEWI", 4, 28613},
	{"VEWH", 4, 36940},
	{"VEWE", 4, 40099},
	{"VEWA", 4, 32511},
	{"VEVS", 4, 257025},
	{"VEVRIER", 7, 201991},
	{"VEVO", 4, 56636},
	{"VEVI", 4, 45127},
	{"VEVEY", 5, 203391},
	{"VEVENT", 6, 107070},
	{"VEVE", 4, 49931},
	{"VEVAY", 5, 244993},
	{"VEVA", 4, 59959},
	{"VEUX", 4, 150442},
	{"VEUVE", 5, 144516},
	{"VEUT", 4, 164507},
	{"VEUS", 4, 38561},
	{"VEURE", 5, 229835},
	{"VEUR", 4, 119903},
	{"VEUP", 4, 33437},
	{"VEUN", 4, 42840},
	{"VEUM", 4, 200556},
	{"VEUL", 4, 197739},
	{"VEUK", 4, 260453},
	{"VEUILLEZ", 8, 124512},
	{"VEU", 3, 831},
	{"VETZ", 4, 246039},
	{"VETYVER", 7, 253780},
	{"VETY", 4, 90230},
	{"VETW", 4, 47403},
	{"VETV", 4, 120482},
	{"VETUS", 5, 194788},
	{"VETU", 4, 58409},
	{"VETTRIANO", 9, 129027},
	{"VETTORI", 7, 230503},
	{"VETTING", 7, 105511},
	{"VETTER", 6, 122213},
	{"VETTED", 6, 111988},
	{"VETTE", 5, 103382},
	{"VETTA", 5, 191425},
	{"VETRO", 5, 216308},
	{"VETRI", 5, 228147},
	{"VETR", 4, 35561},
	{"VETP", 4, 216257},
	{"VETOING", 7, 240380},
	{"VETOES", 6, 135259},
	{"VETOED", 6, 81299},
	{"VETM", 4, 179218},
	{"VETL", 4, 135780},
	{"VETK", 4, 228969},
	{"VETIVER", 7, 109322},
	{"VETH", 4, 1739},
	{"VETF", 4, 252489},
	{"VETERINARY", 10, 30761},
	{"VETERINARIANS", 13, 52606},
	{"VETERINARIAN", 12, 52343},
	{"VETERINARIA", 11, 228881},
	{"VETERE", 6, 244374},
	{"VETERANS", 8, 9363},
	{"VETERAN", 7, 7420},
	{"VETER", 5, 213724},
	{"VETD", 4, 171569},
	{"VETCH", 5, 132371},
	{"VETC", 4, 120063},
	{"VETB", 4, 174548},
	{"VESZ", 4, 203440},
	{"VESY", 4, 47887},
	{"VESW", 4, 30314},
	{"VESV", 4, 79682},
	{"VESUVIUS", 8, 123151},
	{"VESUVIO", 7, 208161},
	{"VESU", 4, 31060},
	{"VESTS", 5, 47942},
	{"VESTRY", 6, 110766},
	{"VESTRON", 7, 179724},
	{"VESTNIK", 7, 257278},
	{"VESTN", 5, 189080},
	{"VESTMENTS", 9, 127211},
	{"VESTMENT", 8, 164726},
	{"VESTITI", 7, 254527},
	{"VESTING", 7, 78893},
	{"VESTIGIAL", 9, 167705},
	{"VESTIGES", 8, 116325},
	{"VESTIGE", 7, 138843},
	{"VESTIDOS", 8, 152577},
	{"VESTIDO", 7, 184029},
	{"VESTIBULUM", 10, 155515},
	{"VESTIBULE", 9, 108158},
	{"VESTIBULAR", 10, 94216},
	{"VESTI", 5, 178672},
	{"VESTFOLD", 8, 216148},
	{"VESTER", 6, 180545},
	{"VESTEL", 6, 209946},
	{"VESTED", 6, 48610},
	{"VESTAX", 6, 100683},
	{"VESTAVIA", 8, 176511},
	{"VESTAS", 6, 136948},
	{"VESTAL", 6, 82401},
	{"VESTA", 5, 88326},
	{"VESSEY", 6, 253110},
	{"VESSELS", 7, 31346},
	{"VESSEL", 6, 9401},
	{"VESR", 4, 48680},
	{"VESQ", 4, 89964},
	{"VESPUCCI", 8, 195035},
	{"VESPOLI", 7, 260739},
	{"VESPERS", 7, 122987},
	{"VESPER", 6, 125067},
	{"VESPASIAN", 9, 179823},
	{"VESPA", 5, 71803},
	{"VESP", 4, 32335},
	{"VESO", 4, 6021},
	{"VESNA", 5, 165888},
	{"VESM", 4, 38973},
	{"VESK", 4, 63510},
	{"VESJ", 4, 78461},
	{"VESICULAR", 9, 107213},
	{"VESICLES", 8, 71302},
	{"VESICLE", 7, 89396},
	{"VESI", 4, 6643},
	{"VESH", 4, 9505},
	{"VESG", 4, 59119},
	{"VESF", 4, 34460},
	{"VESEY", 5, 192405},
	{"VESELY", 6, 227040},
	{"VESE", 4, 7401},
	{"VESD", 4, 45950},
	{"VESC", 4, 34675},
	{"VESB", 4, 38297},
	{"VESALIUS", 8, 246233},
	{"VERZORGING", 10, 192431},
	{"VERZEND", 7, 204098},
	{"VERZEKERINGEN", 13, 153365},
	{"VERZEKERING", 11, 144115},
	{"VERZEICHNIS", 11, 5060},
	{"VERZE", 5, 191604},
	{"VERZAMELINGEN", 13, 259842},
	{"VERZ", 4, 97516},
	{"VERYGOOD", 8, 239764},
	{"VERYAN", 6, 231547},
	{"VERY", 4, 610},
	{"VERX", 4, 169267},
	{"VERWOOD", 7, 211977},
	{"VERWENDUNG", 10, 196348},
	{"VERWENDET", 9, 147611},
	{"VERWENDEN", 9, 167819},
	{"VERWANDTE", 9, 195605},
	{"VERWALTUNG", 10, 220270},
	{"VERW", 4, 5353},
	{"VERVIEW", 7, 177992},
	{"VERVIERS", 8, 197557},
	{"VERVET", 6, 248248},
	{"VERVE", 5, 57533},
	{"VERVAIN", 7, 170638},
	{"VERV", 4, 39809},
	{"VERUS", 5, 200333},
	{"VERUM", 5, 180996},
	{"VERUCA", 6, 111791},
	{"VERU", 4, 35345},
	{"VERTUES", 7, 243391},
	{"VERTUE", 6, 159328},
	{"VERTU", 5, 91395},
	{"VERTS", 5, 152972},
	{"VERTRIEB", 8, 194606},
	{"VERTRAG", 7, 157446},
	{"VERTPOS", 7, 113485},
	{"VERTO", 5, 164070},
	{"VERTMARKETS", 11, 227434},
	{"VERTLINE", 8, 225200},
	{"VERTIGO", 7, 52984},
	{"VERTICLE", 8, 174273},
	{"VERTICILLIUM", 12, 223410},
	{"VERTICILLATA", 12, 220243},
	{"VERTICES", 8, 47742},
	{"VERTICENT", 9, 241853},
	{"VERTICALS", 9, 110148},
	{"VERTICALRESPONSE", 16, 187081},
	{"VERTICALLY", 10, 49186},
	{"VERTICALLINE", 12, 258781},
	{"VERTICALE", 9, 253232},
	{"VERTICAL", 8, 257},
	{"VERTI", 5, 208151},
	{"VERTEX", 6, 35330},
	{"VERTEL", 6, 256978},
	{"VERTED", 6, 254718},
	{"VERTEBROPLASTY", 14, 251948},
	{"VERTEBRATES", 11, 75938},
	{"VERTEBRATE", 10, 64272},
	{"VERTEBRATA", 10, 88053},
	{"VERTEBRAL", 9, 82172},
	{"VERTEBRAE", 9, 83950},
	{"VERTEBRA", 8, 116956},
	{"VERTE", 5, 118674},
	{"VERTAR", 6, 155671},
	{"VERT", 4, 256},
	{"VERSUSLAW", 9, 196532},
	{"VERSUS", 6, 10104},
	{"VERSURI", 7, 175082},
	{"VERSUFFIX", 9, 175554},
	{"VERSUCH", 7, 248463},
	{"VERSTUUR", 8, 236574},
	{"VERSTRING", 9, 200597},
	{"VERSTEHEN", 9, 194709},
	{"VERSTECKTE", 10, 179917},
	{"VERSTAPPEN", 10, 259516},
	{"VERSON", 6, 204749},
	{"VERSO", 5, 67432},
	{"VERSITY", 7, 94294},
	{"VERSITILE", 9, 206487},
	{"VERSIONTRACKER", 14, 69883},
	{"VERSIONS", 8, 4951},
	{"VERSIONPRINTER", 14, 119563},
	{"VERSIONPRINTABLE", 16, 128146},
	{"VERSIONPRINT", 12, 119724},
	{"VERSIONING", 10, 74504},
	{"VERSIONID", 9, 222625},
	{"VERSIONES", 9, 252035},
	{"VERSIONEN", 9, 192285},
	{"VERSIONED", 9, 131387},
	{"VERSIONE", 8, 85036},
	{"VERSION", 7, 3393},
	{"VERSIO", 6, 161805},
	{"VERSILIA", 8, 196093},
	{"VERSIJA", 7, 133299},
	{"VERSIE", 6, 124858},
	{"VERSICOLOR", 10, 154896},
	{"VERSICHERUNGEN", 14, 232785},
	{"VERSICHERUNG", 12, 145834},
	{"VERSI", 5, 146220},
	{"VERSES", 6, 42127},
	{"VERSENDEN", 9, 136528},
	{"VERSED", 6, 77582},
	{"VERSE", 5, 31742},
	{"VERSCHILLENDE", 13, 225643},
	{"VERSCHIL", 8, 137519},
	{"VERSCHIEDENEN", 13, 142469},
	{"VERSCHIEDENE", 12, 187434},
	{"VERSCHICKEN", 11, 170661},
	{"VERSAUTE", 8, 181302},
	{"VERSAUT", 7, 185431},
	{"VERSATILITY", 11, 52281},
	{"VERSATILE", 9, 37296},
	{"VERSATEL", 8, 254156},
	{"VERSATA", 7, 160054},
	{"VERSAR", 6, 135750},
	{"VERSANT", 7, 200635},
	{"VERSANDKOSTENFREI", 17, 235585},
	{"VERSANDKOSTEN", 13, 141090},
	{"VERSANDHANDEL", 13, 215857},
	{"VERSANDFERTIG", 13, 191657},
	{"VERSAND", 7, 100932},
	{"VERSAMAIL", 9, 242054},
	{"VERSAL", 6, 159949},
	{"VERSAILLES", 10, 56161},
	{"VERSACE", 7, 46939},
	{"VERSA", 5, 41552},
	{"VERS", 4, 58669},
	{"VERRY", 5, 126009},
	{"VERRIER", 7, 211026},
	{"VERRE", 5, 152036},
	{"VERRAZANO", 9, 250897},
	{"VERQ", 4, 68129},
	{"VERPLANK", 8, 222728},
	{"VERONIQUE", 9, 116040},
	{"VERONIKA", 8, 97356},
	{"VERONICAS", 9, 167902},
	{"VERONICA", 8, 43274},
	{"VERONESE", 8, 185306},
	{"VERONA", 6, 48217},
	{"VERON", 5, 152864},
	{"VEROMAX", 7, 183043},
	{"VERO", 4, 60031},
	{"VERNOR", 6, 211725},
	{"VERNONIA", 8, 178337},
	{"VERNON", 6, 33547},
	{"VERNIS", 6, 133008},
	{"VERNIER", 7, 112390},
	{"VERNIA", 6, 230220},
	{"VERNEY", 6, 129995},
	{"VERNET", 6, 156641},
	{"VERNER", 6, 123348},
	{"VERNE", 5, 64367},
	{"VERNALIS", 8, 204463},
	{"VERNAL", 6, 80257},
	{"VERNACULAR", 10, 71143},
	{"VERNA", 5, 90525},
	{"VERN", 4, 75124},
	{"VERMOX", 6, 151098},
	{"VERMOUTH", 8, 135415},
	{"VERMONTERS", 10, 162205},
	{"VERMONTER", 9, 251955},
	{"VERMONT", 7, 6008},
	{"VERMIN", 6, 92645},
	{"VERMILLION", 10, 73506},
	{"VERMILION", 9, 70581},
	{"VERMICULITE", 11, 129135},
	{"VERMICELLI", 10, 183181},
	{"VERMEULEN", 9, 114987},
	{"VERMELHO", 8, 257154},
	{"VERMEIL", 7, 86863},
	{"VERMEER", 7, 88391},
	{"VERMA", 5, 88743},
	{"VERM", 4, 249703},
	{"VERLOREN", 8, 213288},
	{"VERLINDEN", 9, 189132},
	{"VERLICHTING", 11, 163926},
	{"VERLEIH", 7, 176230},
	{"VERLAUF", 7, 231175},
	{"VERLAINE", 8, 181574},
	{"VERLAGSGRUPPE", 13, 259053},
	{"VERLAG", 6, 40953},
	{"VERLA", 5, 218373},
	{"VERL", 4, 252652},
	{"VERKRIJGBARE", 12, 233128},
	{"VERKOOP", 7, 159218},
	{"VERKHOVNA", 9, 226766},
	{"VERKEHR", 7, 150885},
	{"VERKAUFEN", 9, 82116},
	{"VERKAUF", 7, 145850},
	{"VERKAIK", 7, 200429},
	{"VERJAARDAG", 10, 150510},
	{"VERJ", 4, 47130},
	{"VERIZONWIRELESS", 15, 220647},
	{"VERIZONNET", 10, 233359},
	{"VERIZONCOM", 10, 233442},
	{"VERIZON", 7, 29448},
	{"VERIUNI", 7, 179254},
	{"VERITY", 6, 71490},
	{"VERITON", 7, 199217},
	{"VERITEST", 8, 203206},
	{"VERITE", 6, 160563},
	{"VERITAS", 7, 47453},
	{"VERITABLE", 9, 80399},
	{"VERISON", 7, 142750},
	{"VERISIMILITUDE", 14, 196967},
	{"VERISIGN", 8, 41804},
	{"VERION", 6, 206256},
	{"VERIO", 5, 113118},
	{"VERINT", 6, 261795},
	{"VERINO", 6, 204543},
	{"VERIMED", 7, 147132},
	{"VERILY", 6, 72795},
	{"VERILUX", 7, 223505},
	{"VERILOG", 7, 79229},
	{"VERIFYING", 9, 50252},
	{"VERIFY", 6, 7849},
	{"VERIFONE", 8, 122786},
	{"VERIFIES", 8, 67067},
	{"VERIFIERS", 9, 139053},
	{"VERIFIER", 8, 73985},
	{"VERIFIED", 8, 28541},
	{"VERIFICATIONS", 13, 104714},
	{"VERIFICATION", 12, 9348},
	{"VERIFICA", 8, 185646},
	{"VERIFIABLE", 10, 71308},
	{"VERIFIABILITY", 13, 213472},
	{"VERIE", 5, 235355},
	{"VERIDICAL", 9, 243814},
	{"VERIDIAN", 8, 240645},
	{"VERIDATA", 8, 178293},
	{"VERI", 4, 125238},
	{"VERHUUR", 7, 223037},
	{"VERHOEVEN", 9, 139347},
	{"VERHOEF", 7, 206205},
	{"VERHINDERN", 10, 194309},
	{"VERHEYEN", 8, 216031},
	{"VERHEUGEN", 9, 225481},
	{"VERHELST", 8, 223797},
	{"VERHALEN", 8, 220564},
	{"VERHAGEN", 8, 239808},
	{"VERHAAL", 7, 173009},
	{"VERH", 4, 243674},
	{"VERGNE", 6, 167697},
	{"VERGLEICHEN", 11, 98894},
	{"VERGLEICH", 9, 129241},
	{"VERGIST", 7, 213271},
	{"VERGING", 7, 169510},
	{"VERGINE", 7, 243882},
	{"VERGIL", 6, 152914},
	{"VERGHESE", 8, 218842},
	{"VERGEWALTIGT", 12, 215311},
	{"VERGETEN", 8, 219260},
	{"VERGESSEN", 9, 123955},
	{"VERGES", 6, 134737},
	{"VERGER", 6, 190579},
	{"VERGENNES", 9, 147786},
	{"VERGENCE", 8, 184796},
	{"VERGELIJKING", 12, 236028},
	{"VERGELIJK", 9, 222140},
	{"VERGE", 5, 54394},
	{"VERGATA", 7, 207425},
	{"VERGARA", 7, 117986},
	{"VERGA", 5, 216815},
	{"VERFAHREN", 9, 184139},
	{"VERES", 5, 240586},
	{"VERENIGING", 10, 151917},
	{"VERENIGDE", 9, 166934},
	{"VERENIGD", 8, 223201},
	{"VERENA", 6, 169776},
	{"VEREINIGUNG", 11, 178475},
	{"VEREINIGTE", 10, 168499},
	{"VEREIN", 6, 114222},
	{"VEREENIGING", 11, 202085},
	{"VEREEN", 6, 250332},
	{"VERED", 5, 400},
	{"VERE", 4, 84356},
	{"VERDURE", 7, 176503},
	{"VERDUN", 6, 119344},
	{"VERDUGO", 7, 153525},
	{"VERDOT", 6, 239237},
	{"VERDON", 6, 150290},
	{"VERDISSIMA", 10, 249992},
	{"VERDIN", 6, 231667},
	{"VERDIGRIS", 9, 134290},
	{"VERDIER", 7, 210409},
	{"VERDIENEN", 9, 139019},
	{"VERDICTS", 8, 79639},
	{"VERDICT", 7, 32407},
	{"VERDI", 5, 63843},
	{"VERDES", 6, 77950},
	{"VERDER", 6, 139901},
	{"VERDENS", 7, 254575},
	{"VERDEN", 6, 154436},
	{"VERDELHO", 8, 261750},
	{"VERDECENTRAL", 12, 103891},
	{"VERDEAN", 7, 223619},
	{"VERDE", 5, 33744},
	{"VERDATE", 7, 79651},
	{"VERDANT", 7, 109715},
	{"VERDANA", 7, 55832},
	{"VERDAD", 6, 133146},
	{"VERDA", 5, 241546},
	{"VERCELLI", 8, 210049},
	{"VERC", 4, 6448},
	{"VERBUM", 6, 191280},
	{"VERBS", 5, 50279},
	{"VERBOTENER", 10, 146363},
	{"VERBOTEN", 8, 138999},
	{"VERBOSITY", 9, 95068},
	{"VERBOSE", 7, 55459},
	{"VERBO", 5, 162974},
	{"VERBINSKI", 9, 234750},
	{"VERBINDUNGEN", 12, 228406},
	{"VERBINDUNG", 10, 132915},
	{"VERBIER", 7, 126964},
	{"VERBIAGE", 8, 131231},
	{"VERBENA", 7, 102051},
	{"VERBEEK", 7, 183772},
	{"VERBATIM", 8, 44014},
	{"VERBANIA", 8, 244586},
	{"VERBAND", 7, 154046},
	{"VERBALLY", 8, 64926},
	{"VERBALIZE", 9, 189653},
	{"VERBAL", 6, 31240},
	{"VERBA", 5, 170302},
	{"VERB", 4, 39766},
	{"VERATEX", 7, 261173},
	{"VERAS", 5, 178440},
	{"VERAPAMIL", 9, 98619},
	{"VERANTWORTLICH", 14, 179065},
	{"VERANSTALTUNGEN", 15, 142680},
	{"VERANO", 6, 110731},
	{"VERANDAS", 8, 175021},
	{"VERANDAHS", 9, 172567},
	{"VERANDAH", 8, 92730},
	{"VERANDA", 7, 81411},
	{"VERAMENTE", 9, 239404},
	{"VERAGE", 6, 228529},
	{"VERADALE", 8, 242255},
	{"VERACRUZ", 8, 95476},
	{"VERACITY", 8, 87344},
	{"VERACHTERT", 10, 177880},
	{"VERA", 4, 38809},
	{"VER", 3, 32248},
	{"VEQU", 4, 52946},
	{"VEQ", 3, 2494},
	{"VEPU", 4, 44959},
	{"VEPS", 4, 126610},
	{"VEPR", 4, 28813},
	{"VEPO", 4, 34805},
	{"VEPM", 4, 82419},
	{"VEPL", 4, 34152},
	{"VEPI", 4, 55772},
	{"VEPH", 4, 70702},
	{"VEPE", 4, 35813},
	{"VEPA", 4, 34694},
	{"VEOX", 4, 246937},
	{"VEOW", 4, 93562},
	{"VEOV", 4, 56425},
	{"VEOU", 4, 39627},
	{"VEOR", 4, 37343},
	{"VEOP", 4, 51922},
	{"VEOM", 4, 256661},
	{"VEOLIA", 6, 205956},
	{"VEOL", 4, 92666},
	{"VEOK", 4, 250819},
	{"VEOF", 4, 7465},
	{"VEOD", 4, 192626},
	{"VEOC", 4, 71540},
	{"VEOB", 4, 71114},
	{"VENZ", 4, 140814},
	{"VENY", 4, 41008},
	{"VENW", 4, 29583},
	{"VENV", 4, 71902},
	{"VENUTO", 6, 142018},
	{"VENUTI", 6, 241938},
	{"VENUSIAN", 8, 211413},
	{"VENUS", 5, 37510},
	{"VENUGOPAL", 9, 238178},
	{"VENUES", 6, 29317},
	{"VENUE", 5, 8013},
	{"VENU", 4, 133376},
	{"VENTUS", 6, 157035},
	{"VENTURINI", 9, 242523},
	{"VENTURING", 9, 83988},
	{"VENTURI", 7, 73963},
	{"VENTURES", 8, 35418},
	{"VENTURERS", 9, 166351},
	{"VENTURER", 8, 96936},
	{"VENTURED", 8, 71893},
	{"VENTUREBLOG", 11, 235436},
	{"VENTURE", 7, 28671},
	{"VENTURA", 7, 41197},
	{"VENTSPILS", 9, 209482},
	{"VENTSHADE", 9, 145267},
	{"VENTS", 5, 53451},
	{"VENTRILOQUIST", 13, 150046},
	{"VENTRILOQUISM", 13, 218069},
	{"VENTRILO", 8, 167362},
	{"VENTRICULAR", 11, 52058},
	{"VENTRICLES", 10, 105665},
	{"VENTRICLE", 9, 84960},
	{"VENTRE", 6, 158394},
	{"VENTRALLY", 9, 245194},
	{"VENTRAL", 7, 72929},
	{"VENTOUX", 7, 237046},
	{"VENTOLIN", 8, 161605},
	{"VENTO", 5, 88240},
	{"VENTNOR", 7, 118145},
	{"VENTLESS", 8, 202796},
	{"VENTIONS", 8, 253434},
	{"VENTIONAL", 9, 221210},
	{"VENTION", 7, 131994},
	{"VENTING", 7, 67408},
	{"VENTIMIGLIA", 11, 201334},
	{"VENTILO", 7, 253012},
	{"VENTILATORY", 11, 143168},
	{"VENTILATORS", 11, 113547},
	{"VENTILATOR", 10, 74370},
	{"VENTILATION", 11, 37675},
	{"VENTILATING", 11, 93105},
	{"VENTILATED", 10, 67054},
	{"VENTILATE", 9, 142414},
	{"VENTI", 5, 136424},
	{"VENTES", 6, 120329},
	{"VENTERS", 7, 247350},
	{"VENTER", 6, 99584},
	{"VENTED", 6, 63474},
	{"VENTE", 5, 67527},
	{"VENTAS", 6, 135386},
	{"VENTANAS", 8, 228816},
	{"VENTANA", 7, 84930},
	{"VENTA", 5, 75315},
	{"VENS", 4, 7681},
	{"VENR", 4, 40174},
	{"VENQ", 4, 113972},
	{"VENP", 4, 35652},
	{"VENOUS", 6, 58280},
	{"VENOMS", 6, 146958},
	{"VENOMOUS", 8, 96627},
	{"VENOM", 5, 49345},
	{"VENNOOTSCHAP", 12, 254663},
	{"VENNER", 6, 215949},
	{"VENNE", 5, 232196},
	{"VENM", 4, 28642},
	{"VENLO", 5, 201282},
	{"VENLAFAXINE", 11, 121130},
	{"VENLA", 5, 192307},
	{"VENL", 4, 39195},
	{"VENKMAN", 7, 224941},
	{"VENKATESH", 9, 140785},
	{"VENKATESAN", 10, 235401},
	{"VENKATARAMAN", 12, 226369},
	{"VENKATA", 7, 208969},
	{"VENKAT", 6, 143763},
	{"VENK", 4, 51314},
	{"VENJ", 4, 71750},
	{"VENIZELOS", 9, 214507},
	{"VENIT", 5, 251064},
	{"VENISON", 7, 84999},
	{"VENISE", 6, 138634},
	{"VENIS", 5, 233150},
	{"VENIRE", 6, 234664},
	{"VENIR", 5, 166737},
	{"VENIPUNCTURE", 12, 205131},
	{"VENICE", 6, 29892},
	{"VENIAM", 6, 165962},
	{"VENIAL", 6, 230269},
	{"VENH", 4, 33387},
	{"VENGONO", 7, 242382},
	{"VENGENCE", 8, 181303},
	{"VENGEFUL", 8, 108995},
	{"VENGEANCE", 9, 46464},
	{"VENGANZA", 8, 222831},
	{"VENGABOYS", 9, 130792},
	{"VENGA", 5, 235157},
	{"VENF", 4, 36673},
	{"VENEZUELANS", 11, 160283},
	{"VENEZUELAN", 10, 54882},
	{"VENEZUELA", 9, 10121},
	{"VENEZOLANA", 10, 235833},
	{"VENEZIANO", 9, 175453},
	{"VENEZIANA", 9, 161711},
	{"VENEZIA", 7, 59131},
	{"VENEZ", 5, 204016},
	{"VENETO", 6, 60237},
	{"VENETIANS", 9, 178407},
	{"VENETIAN", 8, 50482},
	{"VENETIA", 7, 124725},
	{"VENETA", 6, 127298},
	{"VENERIS", 7, 252916},
	{"VENEREOLOGY", 11, 261070},
	{"VENEREAL", 8, 123695},
	{"VENERE", 6, 179387},
	{"VENERATION", 10, 122116},
	{"VENERATED", 9, 136555},
	{"VENERATE", 8, 212875},
	{"VENERABLE", 9, 64651},
	{"VENERA", 6, 222956},
	{"VENEMAN", 7, 163564},
	{"VENEMA", 6, 127527},
	{"VENEGAS", 7, 207178},
	{"VENEERS", 7, 73953},
	{"VENEERING", 9, 258734},
	{"VENEERED", 8, 164368},
	{"VENEER", 6, 55945},
	{"VENEDIG", 7, 121789},
	{"VENECIA", 7, 169651},
	{"VENDREDI", 8, 122633},
	{"VENDRE", 6, 129340},
	{"VENDORS", 7, 7787},
	{"VENDOR", 6, 34506},
	{"VENDOME", 7, 103464},
	{"VENDO", 5, 125527},
	{"VENDITA", 7, 76198},
	{"VENDIO", 6, 56966},
	{"VENDING", 7, 44169},
	{"VENDEUR", 7, 205432},
	{"VENDETTA", 8, 67290},
	{"VENDERS", 7, 209020},
	{"VENDER", 6, 127471},
	{"VENDEEN", 7, 214137},
	{"VENDEE", 6, 154161},
	{"VENDE", 5, 222994},
	{"VENDA", 5, 97562},
	{"VEND", 4, 120286},
	{"VENCE", 5, 156814},
	{"VENC", 4, 34439},
	{"VENB", 4, 29329},
	{"VENAS", 5, 242155},
	{"VENANGO", 7, 129005},
	{"VENAL", 5, 195162},
	{"VENABLES", 8, 120374},
	{"VENABLE", 7, 127476},
	{"VEMY", 4, 51723},
	{"VEMV", 4, 194084},
	{"VEMU", 4, 43130},
	{"VEMS", 4, 198695},
	{"VEMR", 4, 133859},
	{"VEMP", 4, 122124},
	{"VEMO", 4, 29788},
	{"VEMM", 4, 259279},
	{"VEMI", 4, 36682},
	{"VEME", 4, 3712},
	{"VEMD", 4, 207924},
	{"VEMC", 4, 89153},
	{"VEMBER", 6, 232506},
	{"VEMB", 4, 6833},
	{"VEMA", 4, 28105},
	{"VELZ", 4, 155423},
	{"VELW", 4, 46035},
	{"VELVIA", 6, 175526},
	{"VELVETY", 7, 93827},
	{"VELVETS", 7, 171995},
	{"VELVETLEAF", 10, 221890},
	{"VELVETEEN", 9, 114932},
	{"VELVET", 6, 35432},
	{"VELVEL", 6, 255066},
	{"VELVEETA", 8, 209391},
	{"VELVA", 5, 234353},
	{"VELV", 4, 70382},
	{"VELUX", 5, 153833},
	{"VELTRI", 6, 229907},
	{"VELTMAN", 7, 250238},
	{"VELR", 4, 63363},
	{"VELQ", 4, 198512},
	{"VELOX", 5, 156941},
	{"VELOURS", 7, 254442},
	{"VELOUR", 6, 63553},
	{"VELOSO", 6, 137545},
	{"VELOPMENT", 9, 119154},
	{"VELOPING", 8, 243750},
	{"VELOPED", 7, 176693},
	{"VELOP", 5, 186710},
	{"VELOMOBILE", 10, 199166},
	{"VELODYNE", 8, 137765},
	{"VELODROME", 9, 151909},
	{"VELOCIWORLD", 11, 194557},
	{"VELOCITY", 8, 29461},
	{"VELOCITIES", 10, 58249},
	{"VELOCIRAPTOR", 12, 192587},
	{"VELOCIMETRY", 11, 209216},
	{"VELOCIDAD", 9, 185703},
	{"VELOCET", 7, 246894},
	{"VELOCE", 6, 127598},
	{"VELOC", 5, 217559},
	{"VELO", 4, 86184},
	{"VELN", 4, 89747},
	{"VELMONT", 7, 208236},
	{"VELMA", 5, 100596},
	{"VELM", 4, 61171},
	{"VELLUM", 6, 74942},
	{"VELLORE", 7, 139579},
	{"VELLEMAN", 8, 180936},
	{"VELLA", 5, 105001},
	{"VELL", 4, 194200},
	{"VELKOMMEN", 9, 238094},
	{"VELK", 4, 124319},
	{"VELJ", 4, 120643},
	{"VELIT", 5, 154616},
	{"VELINGRAD", 9, 192155},
	{"VELIKOVSKY", 10, 227181},
	{"VELIKO", 6, 106013},
	{"VELIKI", 6, 237633},
	{"VELI", 4, 191610},
	{"VELHO", 5, 204218},
	{"VELHA", 5, 216942},
	{"VELH", 4, 60146},
	{"VELG", 4, 183917},
	{"VELFORM", 7, 236270},
	{"VELF", 4, 55061},
	{"VELEZ", 5, 99177},
	{"VELE", 4, 221287},
	{"VELDT", 5, 245339},
	{"VELDEN", 6, 195729},
	{"VELDE", 5, 123620},
	{"VELDA", 5, 239154},
	{"VELD", 4, 163312},
	{"VELCRO", 6, 51428},
	{"VELCADE", 7, 238896},
	{"VELC", 4, 47646},
	{"VELBON", 6, 102275},
	{"VELBA", 5, 220323},
	{"VELB", 4, 49179},
	{"VELAZQUEZ", 9, 116996},
	{"VELASQUEZ", 9, 98082},
	{"VELASCO", 7, 110287},
	{"VELAS", 5, 158976},
	{"VELARO", 6, 182003},
	{"VELARDE", 7, 189335},
	{"VELAR", 5, 211536},
	{"VELA", 4, 89011},
	{"VEKY", 4, 220177},
	{"VEKW", 4, 260854},
	{"VEKU", 4, 173339},
	{"VEKS", 4, 234574},
	{"VEKR", 4, 159486},
	{"VEKO", 4, 133602},
	{"VEKN", 4, 56763},
	{"VEKM", 4, 258152},
	{"VEKL", 4, 246938},
	{"VEKI", 4, 55157},
	{"VEKE", 4, 64752},
	{"VEJU", 4, 44795},
	{"VEJO", 4, 49453},
	{"VEJLE", 5, 177874},
	{"VEJJ", 4, 227461},
	{"VEJI", 4, 160336},
	{"VEJE", 4, 91172},
	{"VEJA", 4, 133413},
	{"VEIW", 4, 144175},
	{"VEIV", 4, 186123},
	{"VEITH", 5, 199259},
	{"VEITCH", 6, 147748},
	{"VEIS", 4, 35842},
	{"VEIRS", 5, 214666},
	{"VEIR", 4, 83007},
	{"VEIP", 4, 177173},
	{"VEINS", 5, 46341},
	{"VEINING", 7, 261719},
	{"VEINED", 6, 124961},
	{"VEIM", 4, 46486},
	{"VEILSIDE", 8, 182262},
	{"VEILS", 5, 72446},
	{"VEILLEUX", 8, 251307},
	{"VEILLE", 6, 93913},
	{"VEILLARD", 8, 94448},
	{"VEILINGEN", 9, 239505},
	{"VEILING", 7, 171348},
	{"VEILIGHEID", 10, 254494},
	{"VEILED", 6, 75159},
	{"VEIL", 4, 48672},
	{"VEIK", 4, 199683},
	{"VEIGA", 5, 208736},
	{"VEIG", 4, 104705},
	{"VEIF", 4, 69318},
	{"VEID", 4, 68728},
	{"VEIC", 4, 117838},
	{"VEIB", 4, 203616},
	{"VEHY", 4, 132928},
	{"VEHU", 4, 57950},
	{"VEHICULOS", 9, 254139},
	{"VEHICULE", 8, 178585},
	{"VEHICULAR", 9, 60961},
	{"VEHICROSS", 9, 213321},
	{"VEHICLES", 8, 3392},
	{"VEHICLE", 7, 3936},
	{"VEHICAL", 7, 237425},
	{"VEHEMENTLY", 10, 93819},
	{"VEHEMENT", 8, 129231},
	{"VEHEMENCE", 9, 141441},
	{"VEHE", 4, 10114},
	{"VEHA", 4, 9672},
	{"VEGWEB", 6, 229432},
	{"VEGU", 4, 62796},
	{"VEGTABLES", 9, 242098},
	{"VEGSS", 5, 257100},
	{"VEGSOURCE", 9, 158630},
	{"VEGSINGLES", 10, 220298},
	{"VEGSCIENCE", 10, 220101},
	{"VEGS", 4, 208756},
	{"VEGREVILLE", 10, 145351},
	{"VEGR", 4, 39506},
	{"VEGP", 4, 248157},
	{"VEGM", 4, 246328},
	{"VEGLIFE", 7, 189991},
	{"VEGL", 4, 89658},
	{"VEGICAPS", 8, 205535},
	{"VEGI", 4, 243566},
	{"VEGGIETALES", 11, 123034},
	{"VEGGIES", 7, 61194},
	{"VEGGIE", 6, 57025},
	{"VEGF", 4, 88826},
	{"VEGETATIVE", 10, 67122},
	{"VEGETATION", 10, 34347},
	{"VEGETATED", 9, 107085},
	{"VEGETARIANS", 11, 72974},
	{"VEGETARIANISM", 13, 94886},
	{"VEGETARIAN", 10, 34297},
	{"VEGETAL", 7, 135216},
	{"VEGETABLES", 10, 29676},
	{"VEGETABLE", 9, 5758},
	{"VEGETA", 6, 102108},
	{"VEGEMITE", 8, 186257},
	{"VEGE", 4, 167094},
	{"VEGBANK", 7, 203365},
	{"VEGASTRIKE", 10, 213861},
	{"VEGAS", 5, 2876},
	{"VEGARD", 6, 256106},
	{"VEGANS", 6, 109191},
	{"VEGANISM", 8, 134160},
	{"VEGAN", 5, 44203},
	{"VEGAD", 5, 257175},
	{"VEGAA", 5, 260919},
	{"VEGA", 4, 44550},
	{"VEFU", 4, 46457},
	{"VEFR", 4, 37159},
	{"VEFO", 4, 8082},
	{"VEFL", 4, 57635},
	{"VEFI", 4, 39090},
	{"VEFE", 4, 46241},
	{"VEFAS", 5, 261849},
	{"VEFA", 4, 38734},
	{"VEEY", 4, 153011},
	{"VEEX", 4, 38612},
	{"VEEW", 4, 229742},
	{"VEEV", 4, 36452},
	{"VEEU", 4, 139992},
	{"VEESHAN", 7, 262050},
	{"VEERS", 5, 146169},
	{"VEERING", 7, 151484},
	{"VEERED", 6, 137583},
	{"VEER", 4, 82064},
	{"VEEQ", 4, 89094},
	{"VEEP", 4, 180075},
	{"VEENSTRA", 8, 186708},
	{"VEENDAM", 7, 222797},
	{"VEENA", 5, 153829},
	{"VEEM", 4, 57517},
	{"VEEL", 4, 121027},
	{"VEEG", 4, 143893},
	{"VEEF", 4, 57382},
	{"VEEDER", 6, 218608},
	{"VEED", 4, 68891},
	{"VEECO", 5, 172029},
	{"VEEC", 4, 82966},
	{"VEEB", 4, 164655},
	{"VEE", 3, 255},
	{"VEDZ", 4, 255987},
	{"VEDY", 4, 75095},
	{"VEDW", 4, 32040},
	{"VEDV", 4, 62259},
	{"VEDU", 4, 39000},
	{"VEDT", 4, 3427},
	{"VEDS", 4, 36071},
	{"VEDRAL", 6, 196086},
	{"VEDRA", 5, 106230},
	{"VEDR", 4, 39359},
	{"VEDQ", 4, 106214},
	{"VEDP", 4, 43100},
	{"VEDN", 4, 48222},
	{"VEDM", 4, 39386},
	{"VEDL", 4, 50220},
	{"VEDK", 4, 106995},
	{"VEDJ", 4, 65297},
	{"VEDIUS", 6, 259557},
	{"VEDIOS", 6, 165399},
	{"VEDIO", 5, 147407},
	{"VEDIC", 5, 70809},
	{"VEDI", 4, 142066},
	{"VEDH", 4, 32689},
	{"VEDG", 4, 61474},
	{"VEDF", 4, 9740},
	{"VEDERE", 6, 93830},
	{"VEDEO", 5, 247118},
	{"VEDDER", 6, 126360},
	{"VEDD", 4, 46170},
	{"VEDC", 4, 43721},
	{"VEDB", 4, 28826},
	{"VEDAS", 5, 106297},
	{"VEDANTA", 7, 116602},
	{"VEDA", 4, 87100},
	{"VECY", 4, 131515},
	{"VECU", 4, 56805},
	{"VECTREX", 7, 101239},
	{"VECTRA", 6, 77126},
	{"VECTORWORKS", 11, 141086},
	{"VECTORS", 7, 38656},
	{"VECTORLINUX", 11, 236958},
	{"VECTORIZED", 10, 164397},
	{"VECTORIZATION", 13, 196206},
	{"VECTORING", 9, 238890},
	{"VECTORIAL", 9, 171523},
	{"VECTORED", 8, 209556},
	{"VECTOR", 6, 7266},
	{"VECTIS", 6, 132653},
	{"VECT", 4, 149294},
	{"VECR", 4, 43883},
	{"VECP", 4, 249577},
	{"VECN", 4, 253539},
	{"VECL", 4, 46244},
	{"VECI", 4, 66530},
	{"VECHTEN", 7, 224454},
	{"VECH", 4, 33887},
	{"VECES", 5, 137746},
	{"VECE", 4, 54899},
	{"VECD", 4, 155365},
	{"VECC", 4, 117994},
	{"VECA", 4, 32637},
	{"VEBY", 4, 49580},
	{"VEBU", 4, 37603},
	{"VEBR", 4, 42844},
	{"VEBO", 4, 39858},
	{"VEBLEN", 6, 165790},
	{"VEBL", 4, 55221},
	{"VEBI", 4, 46799},
	{"VEBE", 4, 2057},
	{"VEBA", 4, 188498},
	{"VEAZEY", 6, 261056},
	{"VEAZ", 4, 200371},
	{"VEAY", 4, 97043},
	{"VEAX", 4, 216258},
	{"VEAW", 4, 43179},
	{"VEAV", 4, 48194},
	{"VEAU", 4, 252633},
	{"VEATCH", 6, 163019},
	{"VEAT", 4, 30872},
	{"VEAQ", 4, 105558},
	{"VEAM", 4, 36354},
	{"VEALE", 5, 189445},
	{"VEAL", 4, 61701},
	{"VEAK", 4, 101019},
	{"VEAJ", 4, 91402},
	{"VEAG", 4, 36934},
	{"VEAF", 4, 38473},
	{"VEAD", 4, 36768},
	{"VEACH", 5, 245723},
	{"VEAC", 4, 28469},
	{"VEAB", 4, 35885},
	{"VDY", 3, 61181},
	{"VDWI", 4, 170267},
	{"VDWH", 4, 197904},
	{"VDWA", 4, 167909},
	{"VDW", 3, 183656},
	{"VDVI", 4, 234892},
	{"VDVE", 4, 195840},
	{"VDUR", 4, 200737},
	{"VDU", 3, 191551},
	{"VDTO", 4, 211998},
	{"VDTH", 4, 133386},
	{"VDSW", 4, 208296},
	{"VDSU", 4, 246040},
	{"VDST", 4, 162954},
	{"VDSO", 4, 163839},
	{"VDSL", 4, 126766},
	{"VDSI", 4, 204321},
	{"VDSH", 4, 239041},
	{"VDSF", 4, 254597},
	{"VDSE", 4, 146518},
	{"VDSC", 4, 246623},
	{"VDSA", 4, 110820},
	{"VDRO", 4, 214034},
	{"VDRI", 4, 196297},
	{"VDRE", 4, 86341},
	{"VDRA", 4, 138684},
	{"VDR", 3, 63585},
	{"VDQ", 3, 85411},
	{"VDPR", 4, 228970},
	{"VDPL", 4, 109686},
	{"VDP", 3, 133932},
	{"VDOT", 4, 123340},
	{"VDOR", 4, 188285},
	{"VDON", 4, 140618},
	{"VDOF", 4, 139852},
	{"VDOE", 4, 189554},
	{"VDOC", 4, 202393},
	{"VDMO", 4, 247245},
	{"VDMA", 4, 261709},
	{"VDM", 3, 157222},
	{"VDL", 3, 172678},
	{"VDIV", 4, 198513},
	{"VDIS", 4, 118533},
	{"VDIN", 4, 102352},
	{"VDIMENSION", 10, 238401},
	{"VDIE", 4, 197740},
	{"VDID", 4, 176981},
	{"VDHA", 4, 208114},
	{"VDFO", 4, 156171},
	{"VDF", 3, 191684},
	{"VDEX", 4, 237678},
	{"VDEV", 4, 135679},
	{"VDET", 4, 208744},
	{"VDES", 4, 155494},
	{"VDEP", 4, 235486},
	{"VDEO", 4, 235379},
	{"VDEN", 4, 196609},
	{"VDEF", 4, 254223},
	{"VDEC", 4, 155424},
	{"VDEB", 4, 195692},
	{"VDEA", 4, 179328},
	{"VDDR", 4, 222632},
	{"VDDI", 4, 251785},
	{"VDD", 3, 86613},
	{"VDCO", 4, 109627},
	{"VDCA", 4, 197254},
	{"VDC", 3, 53048},
	{"VDBU", 4, 215251},
	{"VDBO", 4, 201752},
	{"VDBL", 4, 248490},
	{"VDB", 3, 207653},
	{"VDAV", 4, 150030},
	{"VDAU", 4, 243318},
	{"VDATA", 5, 50940},
	{"VDAT", 4, 199528},
	{"VDAS", 4, 165055},
	{"VDAR", 4, 206998},
	{"VDAN", 4, 94826},
	{"VDAM", 4, 258534},
	{"VDAL", 4, 191064},
	{"VCZ", 3, 122414},
	{"VCY", 3, 73479},
	{"VCX", 3, 107777},
	{"VCU", 3, 85971},
	{"VCTO", 4, 229985},
	{"VCSEL", 5, 198327},
	{"VCRS", 4, 56932},
	{"VCRI", 4, 206624},
	{"VCRE", 4, 157968},
	{"VCRA", 4, 219504},
	{"VCR", 3, 34122},
	{"VCQ", 3, 262084},
	{"VCP", 3, 115842},
	{"VCOV", 4, 200372},
	{"VCOU", 4, 141419},
	{"VCOS", 4, 253058},
	{"VCORE", 5, 193842},
	{"VCOR", 4, 130966},
	{"VCON", 4, 221457},
	{"VCOM", 4, 167191},
	{"VCOL", 4, 207358},
	{"VCOC", 4, 202394},
	{"VCOA", 4, 241588},
	{"VCM", 3, 131882},
	{"VCLI", 4, 261197},
	{"VCLA", 4, 145465},
	{"VCL", 3, 72470},
	{"VCK", 3, 83569},
	{"VCJD", 4, 126429},
	{"VCJ", 3, 80141},
	{"VCIT", 4, 236732},
	{"VCIN", 4, 228467},
	{"VCHR", 4, 164010},
	{"VCHO", 4, 250463},
	{"VCHKPW", 6, 208824},
	{"VCHI", 4, 181823},
	{"VCHA", 4, 73339},
	{"VCG", 3, 160925},
	{"VCF", 3, 123641},
	{"VCEN", 4, 182394},
	{"VCDS", 4, 91746},
	{"VCDIMAGER", 9, 178713},
	{"VCD", 3, 37246},
	{"VCCS", 4, 168241},
	{"VCCO", 4, 256662},
	{"VCCI", 4, 142549},
	{"VCC", 3, 65119},
	{"VCB", 3, 221590},
	{"VCAT", 4, 190181},
	{"VCAST", 5, 253856},
	{"VCASH", 5, 128255},
	{"VCAS", 4, 174663},
	{"VCARDS", 6, 255825},
	{"VCARD", 5, 75051},
	{"VCAPS", 5, 127193},
	{"VCAN", 4, 110629},
	{"VCAM", 4, 220706},
	{"VCALENDAR", 9, 142480},
	{"VCAL", 4, 162334},
	{"VCAA", 4, 257890},
	{"VBZ", 3, 152538},
	{"VBY", 3, 37843},
	{"VBV", 3, 193000},
	{"VBUT", 4, 103363},
	{"VBUS", 4, 224867},
	{"VBULLETIN", 9, 7592},
	{"VBU", 3, 7729},
	{"VBSEO", 5, 74165},
	{"VBSCRIPT", 8, 60555},
	{"VBRO", 4, 118775},
	{"VBRICK", 6, 215028},
	{"VBRI", 4, 205918},
	{"VBRE", 4, 238490},
	{"VBRA", 4, 184853},
	{"VBR", 3, 62155},
	{"VBPORTAL", 8, 175845},
	{"VBP", 3, 169176},
	{"VBOX", 4, 133900},
	{"VBOR", 4, 225076},
	{"VBOOKIE", 7, 155578},
	{"VBOB", 4, 178969},
	{"VBOA", 4, 214816},
	{"VBNEWLINE", 9, 215616},
	{"VBM", 3, 234558},
	{"VBLA", 4, 218414},
	{"VBL", 3, 256601},
	{"VBK", 3, 231034},
	{"VBJ", 3, 88046},
	{"VBIL", 4, 173430},
	{"VBG", 3, 159409},
	{"VBFORUMS", 8, 203719},
	{"VBET", 4, 244803},
	{"VBER", 4, 243620},
	{"VBEL", 4, 251148},
	{"VBEG", 4, 178051},
	{"VBEF", 4, 218639},
	{"VBEC", 4, 126435},
	{"VBEA", 4, 261948},
	{"VBD", 3, 125446},
	{"VBCRLF", 6, 138779},
	{"VBC", 3, 161231},
	{"VBAS", 4, 181123},
	{"VBAR", 4, 231316},
	{"VBAN", 4, 208703},
	{"VBAL", 4, 211635},
	{"VBADVANCED", 10, 116800},
	{"VBAC", 4, 137494},
	{"VAZQUEZ", 7, 86708},
	{"VAZQ", 4, 107339},
	{"VAZO", 4, 222166},
	{"VAZIRANI", 8, 199255},
	{"VAZH", 4, 222857},
	{"VAYO", 4, 216452},
	{"VAYIKRA", 7, 254512},
	{"VAYE", 4, 254224},
	{"VAYA", 4, 136373},
	{"VAWTER", 6, 212924},
	{"VAWO", 4, 148531},
	{"VAWI", 4, 114543},
	{"VAWH", 4, 89580},
	{"VAWE", 4, 151657},
	{"VAWA", 4, 180910},
	{"VAVUNIYA", 8, 259870},
	{"VAVRA", 5, 248113},
	{"VAVO", 4, 252490},
	{"VAVIN", 5, 209436},
	{"VAVI", 4, 139548},
	{"VAVA", 4, 156050},
	{"VAUXHALL", 8, 44612},
	{"VAUX", 4, 112926},
	{"VAUS", 4, 162294},
	{"VAUNTED", 7, 125526},
	{"VAUN", 4, 106746},
	{"VAULTS", 6, 49811},
	{"VAULTING", 8, 119644},
	{"VAULTED", 7, 82166},
	{"VAULT", 5, 35856},
	{"VAUL", 4, 54611},
	{"VAUGHT", 6, 165891},
	{"VAUGHN", 6, 47704},
	{"VAUGHAN", 7, 45717},
	{"VAUG", 4, 62764},
	{"VAUDREUIL", 9, 173996},
	{"VAUDEVILLE", 10, 90777},
	{"VAUDE", 5, 190741},
	{"VAUD", 4, 143985},
	{"VAUCLUSE", 8, 142978},
	{"VAUCANSON", 9, 212792},
	{"VAUC", 4, 257780},
	{"VAUBAN", 6, 237576},
	{"VATW", 4, 199684},
	{"VATU", 4, 90391},
	{"VATTON", 6, 215353},
	{"VATTEROTT", 9, 192192},
	{"VATTENFALL", 10, 245360},
	{"VATR", 4, 101408},
	{"VATP", 4, 156236},
	{"VATM", 4, 237973},
	{"VATL", 4, 244804},
	{"VATIVE", 6, 260213},
	{"VATIONS", 7, 177202},
	{"VATION", 6, 115890},
	{"VATICANO", 8, 162690},
	{"VATICANA", 8, 256085},
	{"VATICAN", 7, 35231},
	{"VATI", 4, 3642},
	{"VATER", 5, 127896},
	{"VATED", 5, 183583},
	{"VATD", 4, 225794},
	{"VATB", 4, 249117},
	{"VATAN", 5, 227347},
	{"VASY", 4, 203116},
	{"VASW", 4, 97859},
	{"VASUDEVAN", 9, 201676},
	{"VASUDEVA", 8, 196210},
	{"VASU", 4, 139568},
	{"VASTUS", 6, 250986},
	{"VASTU", 5, 128579},
	{"VASTNESS", 8, 128112},
	{"VASTLY", 6, 55363},
	{"VASTERS", 7, 176624},
	{"VASTERAS", 8, 257674},
	{"VASTER", 6, 236157},
	{"VASTE", 5, 196134},
	{"VASTA", 5, 219586},
	{"VAST", 4, 6162},
	{"VASSILY", 7, 225024},
	{"VASSILIS", 8, 197078},
	{"VASSEUR", 7, 220849},
	{"VASSE", 5, 260767},
	{"VASSAR", 6, 80046},
	{"VASSALS", 7, 180475},
	{"VASSALLO", 8, 181803},
	{"VASSALBORO", 10, 226949},
	{"VASSAL", 6, 145561},
	{"VASR", 4, 168459},
	{"VASQUEZ", 7, 77358},
	{"VASQUE", 6, 107587},
	{"VASQ", 4, 103694},
	{"VASP", 4, 207811},
	{"VASOTEC", 7, 180363},
	{"VASOSPASM", 9, 192481},
	{"VASOPRO", 7, 211416},
	{"VASOPRESSINS", 12, 240672},
	{"VASOPRESSIN", 11, 114873},
	{"VASOMOTOR", 9, 186053},
	{"VASODILATORS", 12, 217553},
	{"VASODILATOR", 11, 129262},
	{"VASODILATION", 12, 146269},
	{"VASODILATATION", 14, 236874},
	{"VASOCONSTRICTOR", 15, 182663},
	{"VASOCONSTRICTION", 16, 144345},
	{"VASOACTIVE", 10, 146450},
	{"VASM", 4, 149688},
	{"VASL", 4, 156321},
	{"VASK", 4, 147712},
	{"VASILY", 6, 158644},
	{"VASILIY", 7, 259362},
	{"VASILIS", 7, 237048},
	{"VASILIEV", 8, 230458},
	{"VASILI", 6, 176158},
	{"VASILE", 6, 186759},
	{"VASIL", 5, 196505},
	{"VASHTI", 6, 157759},
	{"VASHON", 6, 114232},
	{"VASHI", 5, 249369},
	{"VASHEM", 6, 158556},
	{"VASG", 4, 206625},
	{"VASF", 4, 140717},
	{"VASEY", 5, 176974},
	{"VASES", 5, 51560},
	{"VASELINE", 8, 91321},
	{"VASEL", 5, 204737},
	{"VASED", 5, 174227},
	{"VASECTOMY", 9, 99119},
	{"VASD", 4, 151531},
	{"VASCULITIS", 10, 116783},
	{"VASCULATURE", 11, 145698},
	{"VASCULARITY", 11, 254669},
	{"VASCULAR", 8, 37258},
	{"VASCONCELOS", 11, 184262},
	{"VASCONCELLOS", 12, 230750},
	{"VASCO", 5, 80783},
	{"VASCHE", 6, 224125},
	{"VASCA", 5, 144334},
	{"VASC", 4, 128369},
	{"VASB", 4, 137286},
	{"VASARI", 6, 205238},
	{"VASANTH", 7, 258881},
	{"VASANT", 6, 168563},
	{"VARYING", 7, 34187},
	{"VARY", 4, 7176},
	{"VARW", 4, 170883},
	{"VARVEL", 6, 246870},
	{"VARVATOS", 8, 144950},
	{"VARVARA", 7, 253084},
	{"VARV", 4, 205560},
	{"VARUS", 5, 171149},
	{"VARUNA", 6, 221902},
	{"VARUN", 5, 143715},
	{"VARUKERS", 8, 246250},
	{"VARU", 4, 123396},
	{"VARTAN", 6, 136662},
	{"VARTA", 5, 100275},
	{"VARSITY", 7, 41628},
	{"VARSHA", 6, 257934},
	{"VARS", 4, 55193},
	{"VARROA", 6, 179258},
	{"VARRO", 5, 179034},
	{"VARR", 4, 67231},
	{"VARP", 4, 175497},
	{"VARON", 5, 182675},
	{"VARO", 4, 231944},
	{"VARNUM", 6, 224946},
	{"VARNISHING", 10, 227775},
	{"VARNISHES", 9, 107084},
	{"VARNISHED", 9, 123783},
	{"VARNISH", 7, 68669},
	{"VARNEY", 6, 111508},
	{"VARNER", 6, 122823},
	{"VARNELL", 7, 259554},
	{"VARNAME", 7, 120805},
	{"VARNA", 5, 68047},
	{"VARMUS", 6, 246120},
	{"VARMOD", 6, 142281},
	{"VARMINTS", 8, 248263},
	{"VARMINT", 7, 154358},
	{"VARMA", 5, 96973},
	{"VARM", 4, 100204},
	{"VARLEY", 6, 120628},
	{"VARLA", 5, 182728},
	{"VARL", 4, 144293},
	{"VARKON", 6, 241356},
	{"VARK", 4, 148791},
	{"VARIZOOM", 8, 251337},
	{"VARIUS", 6, 129379},
	{"VARITY", 6, 203388},
	{"VARITEK", 7, 159977},
	{"VARISTORS", 9, 232786},
	{"VARISTOR", 8, 250560},
	{"VARIOUSLY", 9, 82408},
	{"VARIOUS", 7, 2611},
	{"VARIOS", 6, 106508},
	{"VARIOLA", 7, 206792},
	{"VARIOGRAM", 9, 220148},
	{"VARIO", 5, 86564},
	{"VARINA", 6, 123575},
	{"VARILUX", 7, 249728},
	{"VARIG", 5, 147972},
	{"VARIFRANK", 9, 226040},
	{"VARIFOCAL", 9, 210565},
	{"VARIETY", 7, 3414},
	{"VARIETIES", 9, 36606},
	{"VARIETALS", 9, 140387},
	{"VARIETAL", 8, 80220},
	{"VARIES", 6, 34493},
	{"VARIEGATED", 10, 89146},
	{"VARIEGATA", 9, 170523},
	{"VARIED", 6, 32491},
	{"VARIE", 5, 155712},
	{"VARICOSE", 8, 77904},
	{"VARICOCELE", 10, 201284},
	{"VARICK", 6, 210280},
	{"VARICES", 7, 155064},
	{"VARICELLA", 9, 99891},
	{"VARIAX", 6, 220585},
	{"VARIATIONS", 10, 29385},
	{"VARIATIONEN", 11, 192459},
	{"VARIATIONAL", 11, 84575},
	{"VARIATION", 9, 9066},
	{"VARIATES", 8, 237477},
	{"VARIATE", 7, 160012},
	{"VARIAS", 6, 174935},
	{"VARIANTS", 8, 42020},
	{"VARIANTE", 8, 252053},
	{"VARIANT", 7, 37895},
	{"VARIANCES", 9, 62606},
	{"VARIANCE", 8, 35156},
	{"VARIAN", 6, 81814},
	{"VARIABLY", 8, 150291},
	{"VARIABLES", 9, 5085},
	{"VARIABLENAME", 12, 135134},
	{"VARIABLE", 8, 4948},
	{"VARIABILITY", 11, 39158},
	{"VARIABILIS", 10, 207671},
	{"VARIA", 5, 101574},
	{"VARI", 4, 63841},
	{"VARH", 4, 186378},
	{"VARGO", 5, 177528},
	{"VARGHESE", 8, 168510},
	{"VARGAS", 6, 62744},
	{"VARGAONENINTH", 13, 230241},
	{"VARGA", 5, 108561},
	{"VARESE", 6, 103734},
	{"VARER", 5, 256086},
	{"VAREPSILON", 10, 229380},
	{"VARENNES", 8, 234744},
	{"VARELA", 6, 106317},
	{"VAREKAI", 7, 196128},
	{"VARE", 4, 215638},
	{"VARDY", 5, 169153},
	{"VARDS", 5, 198612},
	{"VARDON", 6, 243394},
	{"VARDI", 5, 188630},
	{"VARDENAFIL", 10, 110689},
	{"VARDEN", 6, 174733},
	{"VARDA", 5, 180909},
	{"VARD", 4, 216175},
	{"VARCHAR", 7, 60066},
	{"VARC", 4, 158945},
	{"VARBUSINESS", 11, 82627},
	{"VARBERG", 7, 257694},
	{"VARB", 4, 202759},
	{"VARAS", 5, 217918},
	{"VARARGS", 7, 231884},
	{"VARANASI", 8, 88555},
	{"VARADERO", 8, 85823},
	{"VARADARAJAN", 11, 213721},
	{"VARAD", 5, 227422},
	{"VARA", 4, 95403},
	{"VAR", 3, 4113},
	{"VAQUEROS", 8, 240877},
	{"VAQUERO", 7, 190182},
	{"VAQU", 4, 194348},
	{"VAPU", 4, 217065},
	{"VAPRO", 5, 229472},
	{"VAPR", 4, 114409},
	{"VAPP", 4, 123232},
	{"VAPOURS", 7, 129677},
	{"VAPOUR", 6, 64422},
	{"VAPORWARE", 9, 192183},
	{"VAPORS", 6, 74511},
	{"VAPORIZERS", 10, 147954},
	{"VAPORIZER", 9, 129982},
	{"VAPORIZED", 9, 157357},
	{"VAPORIZE", 8, 183754},
	{"VAPORIZATION", 12, 138344},
	{"VAPORETTO", 9, 246099},
	{"VAPOR", 5, 39705},
	{"VAPOCHILL", 9, 243960},
	{"VAPNIK", 6, 234459},
	{"VAPL", 4, 159801},
	{"VAPID", 5, 151505},
	{"VAPI", 4, 99676},
	{"VAPE", 4, 165241},
	{"VAPA", 4, 127425},
	{"VAOR", 4, 137046},
	{"VAOF", 4, 118843},
	{"VAOC", 4, 194211},
	{"VANZETTI", 8, 204933},
	{"VANZARI", 7, 197730},
	{"VANZANT", 7, 214333},
	{"VANZ", 4, 125306},
	{"VANYA", 5, 176053},
	{"VANW", 4, 62731},
	{"VANV", 4, 108420},
	{"VANUNU", 6, 159042},
	{"VANUIT", 6, 225505},
	{"VANUATU", 7, 36859},
	{"VANTURE", 7, 165687},
	{"VANTIS", 6, 253149},
	{"VANTEC", 6, 83178},
	{"VANTAGEPOINT", 12, 204948},
	{"VANTAGE", 7, 51471},
	{"VANTAA", 6, 147440},
	{"VANTA", 5, 230899},
	{"VANSTONE", 8, 148995},
	{"VANSON", 6, 250795},
	{"VANR", 4, 75357},
	{"VANQUISHING", 11, 256611},
	{"VANQUISHED", 10, 107909},
	{"VANQUISH", 8, 104862},
	{"VANQ", 4, 115993},
	{"VANPOOL", 7, 148320},
	{"VANP", 4, 77954},
	{"VANOZA", 6, 223873},
	{"VANNI", 5, 193134},
	{"VANNEVAR", 8, 237651},
	{"VANNET", 6, 117320},
	{"VANNES", 6, 182801},
	{"VANNELLI", 8, 207894},
	{"VANNA", 5, 148558},
	{"VANMARK", 7, 180359},
	{"VANM", 4, 71256},
	{"VANLINES", 8, 225690},
	{"VANL", 4, 81847},
	{"VANK", 4, 97746},
	{"VANJ", 4, 134022},
	{"VANITY", 6, 38258},
	{"VANITIES", 8, 77761},
	{"VANITA", 6, 256199},
	{"VANISHINGLY", 11, 254994},
	{"VANISHING", 9, 59371},
	{"VANISHES", 8, 74774},
	{"VANISHED", 8, 57695},
	{"VANISH", 6, 31362},
	{"VANIQA", 6, 80196},
	{"VANILLIN", 8, 222127},
	{"VANILLI", 7, 160579},
	{"VANILLE", 7, 122601},
	{"VANILLA", 7, 35820},
	{"VANIER", 6, 115352},
	{"VANIA", 5, 193119},
	{"VANHOOK", 7, 242688},
	{"VANHANEN", 8, 204738},
	{"VANGUARDS", 9, 189363},
	{"VANGUARDIA", 10, 229172},
	{"VANGUARD", 8, 42479},
	{"VANGO", 5, 161678},
	{"VANGELIS", 8, 87464},
	{"VANG", 4, 103067},
	{"VANF", 4, 101547},
	{"VANESSADELRIO", 13, 198311},
	{"VANESSA", 7, 40832},
	{"VANESA", 6, 247683},
	{"VANES", 5, 113330},
	{"VANELLUS", 8, 238392},
	{"VANELLI", 7, 236317},
	{"VANELI", 6, 178513},
	{"VANEK", 5, 181491},
	{"VANEISA", 7, 171514},
	{"VANEGAS", 7, 239218},
	{"VANDYKE", 7, 142465},
	{"VANDY", 5, 145118},
	{"VANDROSS", 8, 106343},
	{"VANDREAD", 8, 190413},
	{"VANDOREN", 8, 167698},
	{"VANDIVER", 8, 193700},
	{"VANDEVENTER", 11, 246723},
	{"VANDERSLICE", 11, 201883},
	{"VANDERPOOL", 10, 166942},
	{"VANDERMEER", 10, 193164},
	{"VANDERMARK", 10, 207657},
	{"VANDERJAGT", 10, 206943},
	{"VANDERHOOF", 10, 162239},
	{"VANDERHEIDEN", 12, 250607},
	{"VANDERGRIFT", 11, 184460},
	{"VANDERBURGH", 11, 130434},
	{"VANDERBILT", 10, 45422},
	{"VANDER", 6, 85168},
	{"VANDENBERG", 10, 103217},
	{"VANDEN", 6, 95074},
	{"VANDELLAS", 9, 249835},
	{"VANDE", 5, 148712},
	{"VANDANA", 7, 148425},
	{"VANDALS", 7, 69266},
	{"VANDALIZING", 11, 248392},
	{"VANDALIZED", 10, 130157},
	{"VANDALIZE", 9, 225295},
	{"VANDALISM", 9, 56721},
	{"VANDALISED", 10, 204065},
	{"VANDALIA", 8, 99163},
	{"VANDAL", 6, 91611},
	{"VANDAAG", 7, 181275},
	{"VANDA", 5, 128108},
	{"VAND", 4, 127863},
	{"VANCOUVER", 9, 5865},
	{"VANCOMYCIN", 10, 104029},
	{"VANCO", 5, 234961},
	{"VANCLEAVE", 9, 185564},
	{"VANCITY", 7, 240635},
	{"VANCEUR", 7, 205366},
	{"VANCES", 6, 232439},
	{"VANCED", 6, 197668},
	{"VANCE", 5, 50189},
	{"VANB", 4, 64649},
	{"VANAGON", 7, 121842},
	{"VANAF", 5, 184683},
	{"VANADYL", 7, 173744},
	{"VANADIUM", 8, 81746},
	{"VANADATE", 8, 225263},
	{"VAMU", 4, 231568},
	{"VAMS", 4, 188131},
	{"VAMPYRES", 8, 255853},
	{"VAMPYRE", 7, 139230},
	{"VAMPYR", 6, 232468},
	{"VAMPS", 5, 158614},
	{"VAMPIRO", 7, 252818},
	{"VAMPIRISM", 9, 200676},
	{"VAMPIRIC", 8, 170460},
	{"VAMPIRESS", 9, 220434},
	{"VAMPIRES", 8, 51988},
	{"VAMPIRELLA", 10, 205816},
	{"VAMPIRE", 7, 34435},
	{"VAMPIR", 6, 258737},
	{"VAMP", 4, 73759},
	{"VAMOSI", 6, 104835},
	{"VAMOS", 5, 103342},
	{"VAMO", 4, 125849},
	{"VAMI", 4, 148047},
	{"VAMES", 5, 223384},
	{"VAME", 4, 235390},
	{"VAMC", 4, 137830},
	{"VAMB", 4, 253540},
	{"VAMA", 4, 99553},
	{"VALY", 4, 148108},
	{"VALW", 4, 51043},
	{"VALVULAR", 8, 135907},
	{"VALVOLINE", 9, 145892},
	{"VALVO", 5, 241244},
	{"VALVING", 7, 246837},
	{"VALVETRAIN", 10, 251535},
	{"VALVES", 6, 35392},
	{"VALVERDE", 8, 150745},
	{"VALVED", 6, 220860},
	{"VALVE", 5, 9726},
	{"VALV", 4, 48186},
	{"VALUTAZIONE", 11, 109222},
	{"VALUTATO", 8, 179846},
	{"VALUTA", 6, 137457},
	{"VALUSOFT", 8, 181991},
	{"VALUING", 7, 68381},
	{"VALUEWEB", 8, 181169},
	{"VALUETYPE", 9, 172520},
	{"VALUESHOP", 9, 258391},
	{"VALUES", 6, 1965},
	{"VALUERS", 7, 100819},
	{"VALUERAM", 8, 129755},
	{"VALUER", 6, 135715},
	{"VALUEPACK", 9, 160006},
	{"VALUEOF", 7, 215913},
	{"VALUENGINE", 10, 115867},
	{"VALUEMAGS", 9, 144344},
	{"VALUELESS", 9, 182125},
	{"VALUEERROR", 10, 168148},
	{"VALUED", 6, 33733},
	{"VALUECLICK", 10, 174178},
	{"VALUE", 5, 1647},
	{"VALUATIONS", 10, 56055},
	{"VALUATION", 9, 32698},
	{"VALUABLES", 9, 76519},
	{"VALUABLE", 8, 8302},
	{"VALU", 4, 118242},
	{"VALTREX", 7, 59857},
	{"VALSE", 5, 131367},
	{"VALSARTAN", 9, 205636},
	{"VALSALVA", 8, 242631},
	{"VALSAD", 6, 99860},
	{"VALS", 4, 105846},
	{"VALRICO", 7, 172815},
	{"VALR", 4, 37039},
	{"VALQ", 4, 225987},
	{"VALPROIC", 8, 134251},
	{"VALPROATE", 9, 150655},
	{"VALPOLICELLA", 12, 218699},
	{"VALPO", 5, 171763},
	{"VALPARAISO", 10, 60003},
	{"VALOUR", 6, 106324},
	{"VALOROUS", 8, 246808},
	{"VALORISATION", 12, 201204},
	{"VALORIE", 7, 196853},
	{"VALORI", 6, 234183},
	{"VALORES", 7, 133698},
	{"VALOREM", 7, 87048},
	{"VALOREBOOKS", 11, 179898},
	{"VALORE", 6, 132479},
	{"VALOR", 5, 57958},
	{"VALOIS", 6, 149297},
	{"VALODA", 6, 215783},
	{"VALO", 4, 141152},
	{"VALN", 4, 97292},
	{"VALMOREL", 8, 168567},
	{"VALMONT", 7, 113443},
	{"VALMIKI", 7, 226815},
	{"VALMEINIER", 10, 215760},
	{"VALM", 4, 64727},
	{"VALLY", 5, 182146},
	{"VALLS", 5, 184655},
	{"VALLONE", 7, 211368},
	{"VALLON", 6, 200506},
	{"VALLOIRE", 8, 225850},
	{"VALLIS", 6, 214659},
	{"VALLIER", 7, 232435},
	{"VALLIANT", 8, 252594},
	{"VALLI", 5, 95503},
	{"VALLHUND", 8, 256395},
	{"VALLEYVIEW", 10, 142540},
	{"VALLEYS", 7, 48023},
	{"VALLEYFIELD", 11, 231705},
	{"VALLEY", 6, 28281},
	{"VALLETTA", 8, 100413},
	{"VALLES", 6, 125596},
	{"VALLEN", 6, 250636},
	{"VALLELY", 7, 221875},
	{"VALLEJO", 7, 60700},
	{"VALLEE", 6, 104357},
	{"VALLECITO", 9, 253962},
	{"VALLE", 5, 57414},
	{"VALLARTA", 8, 47798},
	{"VALLARIO", 8, 227995},
	{"VALLANCE", 8, 204231},
	{"VALLADOLID", 10, 98171},
	{"VALLA", 5, 208479},
	{"VALL", 4, 153369},
	{"VALKYRIES", 9, 175036},
	{"VALKYRIE", 8, 90727},
	{"VALKENBURG", 10, 169156},
	{"VALK", 4, 143926},
	{"VALJEAN", 7, 203562},
	{"VALJ", 4, 105467},
	{"VALIUM", 6, 30910},
	{"VALISE", 6, 192836},
	{"VALIS", 5, 184435},
	{"VALINOR", 7, 239111},
	{"VALINE", 6, 114361},
	{"VALIN", 5, 207875},
	{"VALIGN", 6, 73241},
	{"VALIER", 6, 199425},
	{"VALIE", 5, 188266},
	{"VALIDLY", 7, 99754},
	{"VALIDITY", 8, 32644},
	{"VALIDEA", 7, 246720},
	{"VALIDE", 6, 205957},
	{"VALIDATORS", 10, 131866},
	{"VALIDATOR", 9, 60948},
	{"VALIDATIONS", 11, 124451},
	{"VALIDATION", 10, 30179},
	{"VALIDATING", 10, 61087},
	{"VALIDATES", 9, 75916},
	{"VALIDATED", 9, 42855},
	{"VALIDATE", 8, 39798},
	{"VALID", 5, 34586},
	{"VALIC", 5, 182928},
	{"VALIANTLY", 9, 134569},
	{"VALIANT", 7, 52969},
	{"VALIA", 5, 180589},
	{"VALI", 4, 129540},
	{"VALHALLA", 8, 78128},
	{"VALH", 4, 58461},
	{"VALGUS", 6, 201050},
	{"VALGRIND", 8, 126855},
	{"VALG", 4, 74865},
	{"VALF", 4, 51103},
	{"VALEURS", 7, 144108},
	{"VALEUR", 6, 107547},
	{"VALETTE", 7, 208287},
	{"VALETTA", 7, 230889},
	{"VALETS", 6, 196286},
	{"VALETING", 8, 153614},
	{"VALET", 5, 47973},
	{"VALES", 5, 170687},
	{"VALERY", 6, 93437},
	{"VALERO", 6, 110345},
	{"VALERIY", 7, 206209},
	{"VALERIUS", 8, 151695},
	{"VALERIO", 7, 117676},
	{"VALERIE", 7, 42532},
	{"VALERIANA", 9, 225468},
	{"VALERIAN", 8, 92587},
	{"VALERIA", 7, 95102},
	{"VALERI", 6, 119699},
	{"VALERATE", 8, 217056},
	{"VALERA", 6, 62936},
	{"VALEO", 5, 98070},
	{"VALENZUELA", 10, 113171},
	{"VALENTINO", 9, 51610},
	{"VALENTINIAN", 11, 234559},
	{"VALENTINI", 9, 163185},
	{"VALENTINES", 10, 36784},
	{"VALENTINE", 9, 7087},
	{"VALENTINA", 9, 82716},
	{"VALENTIN", 8, 66209},
	{"VALENTIA", 8, 187643},
	{"VALENTI", 7, 101919},
	{"VALENTE", 7, 119236},
	{"VALENT", 6, 123787},
	{"VALENS", 6, 154181},
	{"VALENCY", 7, 208375},
	{"VALENCIENNES", 12, 166770},
	{"VALENCIANO", 10, 249336},
	{"VALENCIANNAILS", 14, 189644},
	{"VALENCIANA", 10, 162517},
	{"VALENCIAN", 9, 158168},
	{"VALENCIA", 8, 38852},
	{"VALENCE", 7, 69079},
	{"VALEN", 5, 177923},
	{"VALEMOUNT", 9, 186164},
	{"VALEK", 5, 249729},
	{"VALEDICTORY", 11, 211788},
	{"VALEDICTORIAN", 13, 147299},
	{"VALE", 4, 40035},
	{"VALDOSTA", 8, 64053},
	{"VALDIVIA", 8, 155520},
	{"VALDIS", 6, 192306},
	{"VALDIFF", 7, 215533},
	{"VALDEZ", 6, 64891},
	{"VALDESE", 7, 239171},
	{"VALDES", 6, 103064},
	{"VALDERRAMA", 10, 157191},
	{"VALDEMAR", 8, 188549},
	{"VALDECOXIB", 10, 193283},
	{"VALDARNO", 8, 252257},
	{"VALCOMPAGINGPRODUCTS", 20, 236988},
	{"VALCOM", 6, 201728},
	{"VALCO", 5, 185826},
	{"VALC", 4, 50224},
	{"VALBONNE", 8, 230360},
	{"VALB", 4, 54232},
	{"VALASCO", 7, 123512},
	{"VALARRAY", 8, 212777},
	{"VALARIE", 7, 183800},
	{"VALAR", 5, 152429},
	{"VALANCES", 8, 116614},
	{"VALANCE", 7, 59154},
	{"VALAIS", 6, 130162},
	{"VALACYCLOVIR", 12, 192167},
	{"VALA", 4, 178485},
	{"VAL", 3, 9728},
	{"VAKW", 4, 239331},
	{"VAKU", 4, 181124},
	{"VAKT", 4, 243901},
	{"VAKS", 4, 119016},
	{"VAKR", 4, 199353},
	{"VAKP", 4, 213405},
	{"VAKO", 4, 186629},
	{"VAKNIN", 6, 163673},
	{"VAKN", 4, 197741},
	{"VAKL", 4, 247872},
	{"VAKIL", 5, 221639},
	{"VAKI", 4, 59917},
	{"VAKH", 4, 190199},
	{"VAKE", 4, 221505},
	{"VAKD", 4, 155780},
	{"VAKC", 4, 217480},
	{"VAKANTIES", 9, 108657},
	{"VAKANTIEHUISJE", 14, 166041},
	{"VAKANTIE", 8, 88552},
	{"VAJU", 4, 250110},
	{"VAJRAYANA", 9, 214454},
	{"VAJRA", 5, 141312},
	{"VAJR", 4, 144640},
	{"VAJPAYEE", 8, 96789},
	{"VAJP", 4, 214035},
	{"VAJO", 4, 91737},
	{"VAJI", 4, 131734},
	{"VAJDA", 5, 186455},
	{"VAJA", 4, 175685},
	{"VAISNAVA", 8, 257203},
	{"VAISHNAVA", 9, 209805},
	{"VAISHALI", 8, 199289},
	{"VAISALA", 7, 175756},
	{"VAIR", 4, 179027},
	{"VAINLY", 6, 123680},
	{"VAINIO", 6, 220219},
	{"VAINGLORY", 9, 213080},
	{"VAINE", 5, 237585},
	{"VAILLANT", 8, 167123},
	{"VAILLANCOURT", 12, 188088},
	{"VAILE", 5, 177310},
	{"VAILABLE", 8, 213665},
	{"VAIL", 4, 45206},
	{"VAIK", 4, 178521},
	{"VAIDYANATHAN", 12, 212139},
	{"VAIDYA", 6, 160536},
	{"VAIDHYANATHAN", 13, 237617},
	{"VAHL", 4, 232267},
	{"VAHID", 5, 217450},
	{"VAGY", 4, 213657},
	{"VAGUS", 5, 136831},
	{"VAGUEST", 7, 258400},
	{"VAGUENESS", 9, 104537},
	{"VAGUELY", 7, 61414},
	{"VAGUE", 5, 43482},
	{"VAGU", 4, 61534},
	{"VAGRANTS", 8, 192141},
	{"VAGRANT", 7, 106150},
	{"VAGRANCY", 8, 207628},
	{"VAGR", 4, 113294},
	{"VAGOTOMY", 8, 214121},
	{"VAGO", 4, 255857},
	{"VAGL", 4, 246041},
	{"VAGINOSIS", 9, 145188},
	{"VAGINITIS", 9, 131889},
	{"VAGIN", 5, 240913},
	{"VAGI", 4, 80758},
	{"VAGG", 4, 157793},
	{"VAGE", 4, 43352},
	{"VAGAS", 5, 134116},
	{"VAGARIES", 8, 117288},
	{"VAGAL", 5, 155620},
	{"VAGABONDS", 9, 170857},
	{"VAGABOND", 8, 80532},
	{"VAGA", 4, 142809},
	{"VAFT", 4, 156237},
	{"VAFR", 4, 158716},
	{"VAFO", 4, 114693},
	{"VAFL", 4, 142051},
	{"VAFI", 4, 156623},
	{"VAFF", 4, 254598},
	{"VAFE", 4, 227205},
	{"VAFA", 4, 242009},
	{"VAEX", 4, 205561},
	{"VAEV", 4, 251460},
	{"VAERS", 5, 255337},
	{"VAER", 4, 216048},
	{"VAEL", 4, 252144},
	{"VAED", 4, 245437},
	{"VAEC", 4, 204136},
	{"VADY", 4, 261198},
	{"VADV", 4, 176767},
	{"VADUZ", 5, 165468},
	{"VADU", 4, 175498},
	{"VADR", 4, 229743},
	{"VADOSE", 6, 156205},
	{"VADODARA", 8, 139070},
	{"VADO", 4, 181333},
	{"VADNAIS", 7, 215381},
	{"VADIS", 5, 135934},
	{"VADIM", 5, 81013},
	{"VADI", 4, 64513},
	{"VADH", 4, 186503},
	{"VADG", 4, 236340},
	{"VADER", 5, 54826},
	{"VADEN", 5, 216422},
	{"VADEM", 5, 150562},
	{"VADE", 4, 214200},
	{"VADDR", 5, 244414},
	{"VADD", 4, 171957},
	{"VADA", 4, 167366},
	{"VACUVIN", 7, 248047},
	{"VACUUMS", 7, 57143},
	{"VACUUMING", 9, 104343},
	{"VACUUMED", 8, 165410},
	{"VACUUM", 6, 35797},
	{"VACUOUS", 7, 137527},
	{"VACUOLES", 8, 154005},
	{"VACUOLE", 7, 141475},
	{"VACUOLAR", 8, 115593},
	{"VACUO", 5, 215902},
	{"VACUA", 5, 201300},
	{"VACU", 4, 181187},
	{"VACTION", 7, 181734},
	{"VACT", 4, 155100},
	{"VACS", 4, 125476},
	{"VACR", 4, 210101},
	{"VACLAV", 6, 112665},
	{"VACK", 4, 189941},
	{"VACILLATING", 11, 242701},
	{"VACHSS", 6, 238861},
	{"VACHS", 5, 127521},
	{"VACHON", 6, 153803},
	{"VACHERON", 8, 111312},
	{"VACHERIE", 8, 255809},
	{"VACHE", 5, 167304},
	{"VACH", 4, 99973},
	{"VACE", 4, 123560},
	{"VACCUUM", 7, 202840},
	{"VACCINIUM", 9, 145044},
	{"VACCINIA", 8, 113900},
	{"VACCINES", 8, 41575},
	{"VACCINE", 7, 31971},
	{"VACCINATIONS", 12, 64389},
	{"VACCINATION", 11, 44056},
	{"VACCINATING", 11, 171612},
	{"VACCINATED", 10, 70940},
	{"VACCINATE", 9, 118129},
	{"VACCARO", 7, 162640},
	{"VACCA", 5, 199395},
	{"VACC", 4, 197008},
	{"VACAVILLE", 9, 85939},
	{"VACATURES", 9, 146811},
	{"VACATURE", 8, 172104},
	{"VACATIONS", 9, 7019},
	{"VACATIONING", 11, 94672},
	{"VACATIONERS", 11, 103733},
	{"VACATIONER", 10, 192142},
	{"VACATIONED", 10, 237836},
	{"VACATION", 8, 8415},
	{"VACATING", 8, 125452},
	{"VACATES", 7, 237498},
	{"VACATED", 7, 67517},
	{"VACATE", 6, 76412},
	{"VACAS", 5, 258401},
	{"VACANZE", 7, 82347},
	{"VACANZA", 7, 115747},
	{"VACANT", 6, 37636},
	{"VACANSEE", 8, 197655},
	{"VACANCY", 7, 38574},
	{"VACANCIES", 9, 33250},
	{"VACANCES", 8, 67715},
	{"VACACIONES", 10, 98491},
	{"VACA", 4, 115821},
	{"VABU", 4, 153649},
	{"VABR", 4, 164377},
	{"VABO", 4, 146175},
	{"VABL", 4, 42675},
	{"VABI", 4, 127644},
	{"VABH", 4, 251461},
	{"VABE", 4, 113566},
	{"VABA", 4, 129552},
	{"VAASTU", 6, 196871},
	{"VAASA", 5, 138327},
	{"VAAR", 4, 113789},
	{"VAAP", 4, 140369},
	{"VAAM", 4, 251786},
	{"VAAL", 4, 165503},
	{"VAAG", 4, 229501},
	{"VAAF", 4, 215459},
	{"V", 1, 22},
	{"UZZY", 4, 87785},
	{"UZZW", 4, 107842},
	{"UZZT", 4, 149977},
	{"UZZS", 4, 141376},
	{"UZZO", 4, 107488},
	{"UZZL", 4, 45777},
	{"UZZIAH", 6, 260354},
	{"UZZH", 4, 231073},
	{"UZZF", 4, 183721},
	{"UZZE", 4, 74156},
	{"UZZC", 4, 162031},
	{"UZZB", 4, 144731},
	{"UZZA", 4, 81336},
	{"UZZ", 3, 1071},
	{"UZY", 3, 34082},
	{"UZWH", 4, 194212},
	{"UZWA", 4, 183975},
	{"UZW", 3, 32458},
	{"UZV", 3, 62519},
	{"UZUS", 4, 249441},
	{"UZUR", 4, 224407},
	{"UZUMAKI", 7, 257698},
	{"UZUM", 4, 197905},
	{"UZUK", 4, 73235},
	{"UZUB", 4, 226235},
	{"UZU", 3, 3476},
	{"UZTO", 4, 232652},
	{"UZTH", 4, 157969},
	{"UZT", 3, 31435},
	{"UZSA", 4, 176247},
	{"UZQ", 3, 129035},
	{"UZP", 3, 45347},
	{"UZOV", 4, 259280},
	{"UZOU", 4, 239042},
	{"UZOR", 4, 245438},
	{"UZON", 4, 87871},
	{"UZODINMA", 8, 223248},
	{"UZO", 3, 5296},
	{"UZNE", 4, 138436},
	{"UZN", 3, 33595},
	{"UZMO", 4, 245115},
	{"UZMN", 4, 216860},
	{"UZM", 3, 6947},
	{"UZLA", 4, 236341},
	{"UZL", 3, 39609},
	{"UZK", 3, 49701},
	{"UZJ", 3, 69175},
	{"UZIS", 4, 150896},
	{"UZIO", 4, 199024},
	{"UZIN", 4, 122424},
	{"UZIK", 4, 240453},
	{"UZIE", 4, 141157},
	{"UZIA", 4, 208704},
	{"UZHU", 4, 222167},
	{"UZHO", 4, 129553},
	{"UZHN", 4, 222168},
	{"UZHK", 4, 236342},
	{"UZHI", 4, 168183},
	{"UZHE", 4, 164565},
	{"UZHA", 4, 104670},
	{"UZH", 3, 4759},
	{"UZG", 3, 48484},
	{"UZF", 3, 42415},
	{"UZET", 4, 168799},
	{"UZER", 4, 98802},
	{"UZEN", 4, 152925},
	{"UZEL", 4, 127426},
	{"UZEI", 4, 179877},
	{"UZED", 4, 261018},
	{"UZEA", 4, 194085},
	{"UZE", 3, 3190},
	{"UZDE", 4, 203974},
	{"UZD", 3, 37446},
	{"UZCO", 4, 135101},
	{"UZCA", 4, 207925},
	{"UZBEKS", 6, 199892},
	{"UZBEKISTAN", 10, 33377},
	{"UZBEK", 5, 70481},
	{"UZBE", 4, 78646},
	{"UZB", 3, 185602},
	{"UZAW", 4, 193050},
	{"UZAT", 4, 227462},
	{"UZAS", 4, 164980},
	{"UZAR", 4, 185486},
	{"UZAM", 4, 241589},
	{"UZAL", 4, 225077},
	{"UZAK", 4, 98165},
	{"UZAI", 4, 224868},
	{"UZAF", 4, 173256},
	{"UZAD", 4, 239590},
	{"UZAC", 4, 246042},
	{"UZAB", 4, 250111},
	{"UZAA", 4, 197742},
	{"UYZ", 3, 77295},
	{"UYYO", 4, 99239},
	{"UYY", 3, 9599},
	{"UYX", 3, 102706},
	{"UYWO", 4, 153989},
	{"UYWI", 4, 85225},
	{"UYWH", 4, 50246},
	{"UYWE", 4, 149260},
	{"UYWA", 4, 92860},
	{"UYW", 3, 1590},
	{"UYVI", 4, 232653},
	{"UYVE", 4, 148676},
	{"UYV", 3, 32062},
	{"UYUT", 4, 251149},
	{"UYUS", 4, 149325},
	{"UYUP", 4, 137975},
	{"UYUNI", 5, 255790},
	{"UYUN", 4, 165242},
	{"UYUK", 4, 167831},
	{"UYUA", 4, 146400},
	{"UYU", 3, 212864},
	{"UYTW", 4, 205019},
	{"UYTTERHOEVEN", 12, 219363},
	{"UYTR", 4, 168542},
	{"UYTO", 4, 79713},
	{"UYTI", 4, 127531},
	{"UYTH", 4, 44034},
	{"UYTE", 4, 152926},
	{"UYTA", 4, 181824},
	{"UYT", 3, 1337},
	{"UYSY", 4, 142398},
	{"UYSW", 4, 51065},
	{"UYSU", 4, 121333},
	{"UYST", 4, 52909},
	{"UYSS", 4, 77150},
	{"UYSR", 4, 113247},
	{"UYSP", 4, 97689},
	{"UYSO", 4, 64169},
	{"UYSN", 4, 122533},
	{"UYSM", 4, 103313},
	{"UYSL", 4, 79530},
	{"UYSK", 4, 142285},
	{"UYSJ", 4, 162699},
	{"UYSI", 4, 62618},
	{"UYSH", 4, 63338},
	{"UYSG", 4, 95114},
	{"UYSF", 4, 93401},
	{"UYSE", 4, 96509},
	{"UYSD", 4, 88127},
	{"UYSC", 4, 80533},
	{"UYSB", 4, 88503},
	{"UYSA", 4, 46865},
	{"UYRU", 4, 243902},
	{"UYRO", 4, 223991},
	{"UYRI", 4, 176982},
	{"UYRE", 4, 119319},
	{"UYRA", 4, 168184},
	{"UYR", 3, 7434},
	{"UYQ", 3, 73949},
	{"UYPR", 4, 128748},
	{"UYPO", 4, 203975},
	{"UYPL", 4, 204657},
	{"UYPE", 4, 157242},
	{"UYPA", 4, 190631},
	{"UYP", 3, 107575},
	{"UYOU", 4, 54213},
	{"UYOT", 4, 224196},
	{"UYOS", 4, 177174},
	{"UYOR", 4, 101565},
	{"UYOP", 4, 246043},
	{"UYON", 4, 74847},
	{"UYOL", 4, 225795},
	{"UYOF", 4, 144140},
	{"UYO", 3, 1580},
	{"UYNO", 4, 146285},
	{"UYNH", 4, 232654},
	{"UYNE", 4, 106518},
	{"UYNA", 4, 144081},
	{"UYN", 3, 5243},
	{"UYMY", 4, 183976},
	{"UYMU", 4, 215865},
	{"UYMO", 4, 97860},
	{"UYMI", 4, 183373},
	{"UYME", 4, 153249},
	{"UYMA", 4, 124583},
	{"UYM", 3, 4546},
	{"UYLO", 4, 118505},
	{"UYLK", 4, 161027},
	{"UYLI", 4, 101213},
	{"UYLE", 4, 113473},
	{"UYLA", 4, 144461},
	{"UYL", 3, 3915},
	{"UYKE", 4, 232094},
	{"UYK", 3, 37808},
	{"UYJU", 4, 175366},
	{"UYJ", 3, 36981},
	{"UYIW", 4, 242167},
	{"UYIT", 4, 73743},
	{"UYIS", 4, 71818},
	{"UYIN", 4, 33779},
	{"UYIM", 4, 229502},
	{"UYIF", 4, 235210},
	{"UYID", 4, 250464},
	{"UYI", 3, 954},
	{"UYHO", 4, 145624},
	{"UYHI", 4, 108086},
	{"UYHE", 4, 92772},
	{"UYHA", 4, 93527},
	{"UYH", 3, 3451},
	{"UYGUR", 5, 187716},
	{"UYGU", 4, 222633},
	{"UYGR", 4, 193939},
	{"UYGO", 4, 134181},
	{"UYGI", 4, 246624},
	{"UYGHURCHE", 9, 211301},
	{"UYGHUR", 6, 171211},
	{"UYGH", 4, 164566},
	{"UYGE", 4, 140215},
	{"UYGA", 4, 171476},
	{"UYG", 3, 5784},
	{"UYFR", 4, 96472},
	{"UYFO", 4, 94495},
	{"UYFI", 4, 202211},
	{"UYFF", 4, 257392},
	{"UYFA", 4, 199182},
	{"UYEX", 4, 213406},
	{"UYEV", 4, 149641},
	{"UYET", 4, 176559},
	{"UYES", 4, 196610},
	{"UYER", 4, 39472},
	{"UYEO", 4, 229228},
	{"UYEL", 4, 232095},
	{"UYED", 4, 238766},
	{"UYEA", 4, 167832},
	{"UYE", 3, 1154},
	{"UYDR", 4, 207728},
	{"UYDO", 4, 135492},
	{"UYDI", 4, 140815},
	{"UYDE", 4, 153012},
	{"UYDA", 4, 228713},
	{"UYD", 3, 6712},
	{"UYCR", 4, 242449},
	{"UYCO", 4, 100524},
	{"UYCL", 4, 211450},
	{"UYCH", 4, 158045},
	{"UYCA", 4, 101957},
	{"UYC", 3, 4298},
	{"UYBY", 4, 259281},
	{"UYBU", 4, 103387},
	{"UYBR", 4, 144239},
	{"UYBO", 4, 159254},
	{"UYBI", 4, 223066},
	{"UYBE", 4, 119206},
	{"UYBA", 4, 96592},
	{"UYB", 3, 3348},
	{"UYAW", 4, 160104},
	{"UYAV", 4, 224633},
	{"UYAU", 4, 227463},
	{"UYAT", 4, 90025},
	{"UYAS", 4, 77191},
	{"UYAR", 4, 123906},
	{"UYAP", 4, 108620},
	{"UYAO", 4, 185866},
	{"UYAN", 4, 48209},
	{"UYAM", 4, 96220},
	{"UYAL", 4, 94437},
	{"UYAK", 4, 198066},
	{"UYAI", 4, 196002},
	{"UYAH", 4, 79233},
	{"UYAG", 4, 154305},
	{"UYAF", 4, 140046},
	{"UYAD", 4, 137134},
	{"UYAC", 4, 100120},
	{"UYAB", 4, 114243},
	{"UYAA", 4, 164981},
	{"UYA", 3, 1072},
	{"UXZ", 3, 110048},
	{"UXY", 3, 63688},
	{"UXX", 3, 69176},
	{"UXWO", 4, 195693},
	{"UXWI", 4, 150669},
	{"UXWH", 4, 138806},
	{"UXWE", 4, 244805},
	{"UXWA", 4, 129480},
	{"UXVE", 4, 239591},
	{"UXV", 3, 40846},
	{"UXUS", 4, 152528},
	{"UXUR", 4, 44179},
	{"UXUN", 4, 202054},
	{"UXU", 3, 1566},
	{"UXTR", 4, 233227},
	{"UXTO", 4, 103193},
	{"UXTH", 4, 121421},
	{"UXTE", 4, 220803},
	{"UXTA", 4, 106093},
	{"UXT", 3, 4381},
	{"UXSY", 4, 249442},
	{"UXSU", 4, 234893},
	{"UXST", 4, 182272},
	{"UXSO", 4, 205192},
	{"UXSI", 4, 222421},
	{"UXSE", 4, 210102},
	{"UXSC", 4, 252145},
	{"UXSA", 4, 141420},
	{"UXS", 3, 5471},
	{"UXRE", 4, 160037},
	{"UXR", 3, 34299},
	{"UXQ", 3, 86544},
	{"UXPR", 4, 199529},
	{"UXPL", 4, 258153},
	{"UXPA", 4, 155910},
	{"UXP", 3, 28480},
	{"UXOP", 4, 223530},
	{"UXON", 4, 153250},
	{"UXOF", 4, 69957},
	{"UXNO", 4, 231569},
	{"UXNE", 4, 169992},
	{"UXN", 3, 35948},
	{"UXMO", 4, 228714},
	{"UXMAL", 5, 228321},
	{"UXMA", 4, 149689},
	{"UXM", 3, 242073},
	{"UXLI", 4, 258154},
	{"UXLE", 4, 118844},
	{"UXLA", 4, 252146},
	{"UXKL", 4, 154764},
	{"UXKE", 4, 168185},
	{"UXK", 3, 32296},
	{"UXJ", 3, 50468},
	{"UXIU", 4, 252491},
	{"UXIT", 4, 170268},
	{"UXIS", 4, 101581},
	{"UXIN", 4, 97649},
	{"UXIL", 4, 64062},
	{"UXIA", 4, 132623},
	{"UXI", 3, 2117},
	{"UXHE", 4, 261199},
	{"UXHA", 4, 101060},
	{"UXH", 3, 8976},
	{"UXGA", 4, 138837},
	{"UXG", 3, 39937},
	{"UXFR", 4, 185487},
	{"UXFO", 4, 136816},
	{"UXFI", 4, 253890},
	{"UXFA", 4, 149449},
	{"UXF", 3, 8406},
	{"UXET", 4, 242168},
	{"UXER", 4, 188286},
	{"UXEN", 4, 165575},
	{"UXEM", 4, 80370},
	{"UXEL", 4, 234894},
	{"UXEE", 4, 204658},
	{"UXEA", 4, 247554},
	{"UXE", 3, 2857},
	{"UXDO", 4, 249118},
	{"UXDI", 4, 126506},
	{"UXDE", 4, 138862},
	{"UXD", 3, 8374},
	{"UXCO", 4, 123969},
	{"UXCI", 4, 184355},
	{"UXCH", 4, 255988},
	{"UXCA", 4, 166302},
	{"UXC", 3, 7829},
	{"UXBU", 4, 120774},
	{"UXBRIDGE", 8, 71477},
	{"UXBR", 4, 142739},
	{"UXBO", 4, 221227},
	{"UXBE", 4, 201403},
	{"UXBA", 4, 160583},
	{"UXAT", 4, 203617},
	{"UXAS", 4, 172590},
	{"UXAR", 4, 124655},
	{"UXAP", 4, 255989},
	{"UXAN", 4, 79512},
	{"UXAL", 4, 199685},
	{"UXA", 3, 3461},
	{"UWZ", 3, 222262},
	{"UWY", 3, 93961},
	{"UWW", 3, 245948},
	{"UWU", 3, 43888},
	{"UWST", 4, 253176},
	{"UWSP", 4, 148808},
	{"UWRO", 4, 121763},
	{"UWRI", 4, 101566},
	{"UWRE", 4, 254599},
	{"UWQ", 3, 160452},
	{"UWP", 3, 155137},
	{"UWOU", 4, 40744},
	{"UWOR", 4, 65577},
	{"UWON", 4, 52634},
	{"UWOM", 4, 185867},
	{"UWME", 4, 228971},
	{"UWMA", 4, 242719},
	{"UWM", 3, 94054},
	{"UWK", 3, 80784},
	{"UWJO", 4, 217481},
	{"UWJ", 3, 49770},
	{"UWIT", 4, 55224},
	{"UWIS", 4, 85688},
	{"UWIN", 4, 194447},
	{"UWIL", 4, 35263},
	{"UWIC", 4, 192110},
	{"UWHY", 4, 163037},
	{"UWHO", 4, 56793},
	{"UWHI", 4, 67552},
	{"UWHE", 4, 67204},
	{"UWHARRIE", 8, 174833},
	{"UWHA", 4, 78323},
	{"UWH", 3, 1395},
	{"UWG", 3, 224373},
	{"UWF", 3, 152156},
	{"UWEW", 4, 252147},
	{"UWES", 4, 194817},
	{"UWER", 4, 40520},
	{"UWEN", 4, 76253},
	{"UWEL", 4, 128861},
	{"UWEI", 4, 149120},
	{"UWED", 4, 262142},
	{"UWEC", 4, 220254},
	{"UWEA", 4, 117039},
	{"UWD", 3, 63168},
	{"UWCH", 4, 140308},
	{"UWC", 3, 143026},
	{"UWB", 3, 85789},
	{"UWAY", 4, 144767},
	{"UWAT", 4, 79223},
	{"UWAS", 4, 46286},
	{"UWAR", 4, 122233},
	{"UWAN", 4, 31636},
	{"UWAM", 4, 231074},
	{"UWAL", 4, 88661},
	{"UWAK", 4, 159487},
	{"UWAI", 4, 64944},
	{"UWAH", 4, 180875},
	{"UWAB", 4, 255647},
	{"UVZ", 3, 196844},
	{"UVY", 3, 72678},
	{"UVX", 3, 187236},
	{"UVWXYZ", 6, 165992},
	{"UVW", 3, 148415},
	{"UVVIS", 5, 252243},
	{"UVUZ", 4, 167833},
	{"UVULA", 5, 217828},
	{"UVUL", 4, 254225},
	{"UVU", 3, 34318},
	{"UVTH", 4, 218640},
	{"UVST", 4, 227464},
	{"UVSC", 4, 171326},
	{"UVSA", 4, 158717},
	{"UVRI", 4, 196928},
	{"UVRE", 4, 75608},
	{"UVRA", 4, 130405},
	{"UVR", 3, 208281},
	{"UVQ", 3, 250004},
	{"UVP", 3, 201384},
	{"UVOR", 4, 217482},
	{"UVOO", 4, 189284},
	{"UVON", 4, 256663},
	{"UVOL", 4, 183490},
	{"UVOI", 4, 186504},
	{"UVO", 3, 5597},
	{"UVM", 3, 85654},
	{"UVLI", 4, 219947},
	{"UVL", 3, 40718},
	{"UVK", 3, 97265},
	{"UVJ", 3, 135574},
	{"UVIU", 4, 163038},
	{"UVIR", 4, 127018},
	{"UVIO", 4, 224634},
	{"UVIN", 4, 108644},
	{"UVIL", 4, 128088},
	{"UVIG", 4, 132311},
	{"UVIE", 4, 114719},
	{"UVIC", 4, 92272},
	{"UVIA", 4, 73688},
	{"UVG", 3, 67697},
	{"UVF", 3, 194839},
	{"UVEX", 4, 130374},
	{"UVEW", 4, 130619},
	{"UVEU", 4, 248815},
	{"UVET", 4, 112711},
	{"UVER", 4, 37089},
	{"UVEP", 4, 107678},
	{"UVEO", 4, 196152},
	{"UVEN", 4, 43685},
	{"UVEM", 4, 113474},
	{"UVEL", 4, 92748},
	{"UVEJ", 4, 139464},
	{"UVEITIS", 7, 128548},
	{"UVEI", 4, 167240},
	{"UVEH", 4, 93065},
	{"UVEG", 4, 46738},
	{"UVEF", 4, 148953},
	{"UVEE", 4, 99495},
	{"UVED", 4, 99771},
	{"UVEC", 4, 114922},
	{"UVEB", 4, 70800},
	{"UVEAL", 5, 251929},
	{"UVD", 3, 53854},
	{"UVC", 3, 86109},
	{"UVB", 3, 96283},
	{"UVAT", 4, 166812},
	{"UVAS", 4, 133603},
	{"UVAR", 4, 117480},
	{"UVAN", 4, 91360},
	{"UVAM", 4, 250112},
	{"UVALDE", 6, 111867},
	{"UVAL", 4, 70995},
	{"UVAI", 4, 136543},
	{"UVAH", 4, 254600},
	{"UVAG", 4, 233228},
	{"UVAD", 4, 218169},
	{"UVAC", 4, 112485},
	{"UVAA", 4, 189285},
	{"UUZH", 4, 194818},
	{"UUZ", 3, 44257},
	{"UUY", 3, 77877},
	{"UUW", 3, 50117},
	{"UUUU", 4, 155608},
	{"UUU", 3, 140688},
	{"UUTU", 4, 255990},
	{"UUTA", 4, 261570},
	{"UUSU", 4, 150730},
	{"UUSI", 4, 261527},
	{"UUSH", 4, 202055},
	{"UUSE", 4, 61601},
	{"UUSA", 4, 181125},
	{"UURE", 4, 260855},
	{"UURA", 4, 253177},
	{"UUR", 3, 137813},
	{"UUQ", 3, 147241},
	{"UUPT", 4, 174664},
	{"UUPA", 4, 188875},
	{"UUP", 3, 119867},
	{"UUNT", 4, 164737},
	{"UUNNIIVVEERRSSIITTYY", 20, 174585},
	{"UUNL", 4, 192782},
	{"UUNI", 4, 128470},
	{"UUNET", 5, 90927},
	{"UUND", 4, 85226},
	{"UUMW", 4, 213804},
	{"UUMT", 4, 122292},
	{"UUMS", 4, 142286},
	{"UUMP", 4, 205020},
	{"UUMO", 4, 146630},
	{"UUMM", 4, 252492},
	{"UUMI", 4, 136725},
	{"UUMF", 4, 243319},
	{"UUME", 4, 217261},
	{"UUMC", 4, 126876},
	{"UUMB", 4, 210295},
	{"UUMA", 4, 131034},
	{"UUM", 3, 214793},
	{"UULIB", 5, 243422},
	{"UUKY", 4, 161028},
	{"UUKK", 4, 233847},
	{"UUJI", 4, 251462},
	{"UUJ", 3, 49676},
	{"UUID", 4, 102163},
	{"UUG", 3, 196917},
	{"UUF", 3, 65158},
	{"UUENCODED", 9, 192381},
	{"UUENCODE", 8, 178552},
	{"UUDECODE", 8, 212134},
	{"UUD", 3, 38449},
	{"UUCP", 4, 75870},
	{"UUCH", 4, 223067},
	{"UUC", 3, 184039},
	{"UUB", 3, 236912},
	{"UUAN", 4, 171392},
	{"UTZW", 4, 174031},
	{"UTZU", 4, 248491},
	{"UTZT", 4, 161029},
	{"UTZS", 4, 135680},
	{"UTZP", 4, 183123},
	{"UTZO", 4, 152204},
	{"UTZM", 4, 189555},
	{"UTZL", 4, 259650},
	{"UTZI", 4, 121657},
	{"UTZH", 4, 179449},
	{"UTZF", 4, 248158},
	{"UTZE", 4, 108480},
	{"UTZC", 4, 256339},
	{"UTZB", 4, 249119},
	{"UTZA", 4, 109435},
	{"UTYW", 4, 74660},
	{"UTYV", 4, 223298},
	{"UTYU", 4, 125156},
	{"UTYT", 4, 60882},
	{"UTYS", 4, 65387},
	{"UTYR", 4, 110071},
	{"UTYQ", 4, 170442},
	{"UTYP", 4, 63291},
	{"UTYO", 4, 29318},
	{"UTYN", 4, 159341},
	{"UTYM", 4, 79461},
	{"UTYL", 4, 96980},
	{"UTYK", 4, 245116},
	{"UTYJ", 4, 171287},
	{"UTYI", 4, 64082},
	{"UTYH", 4, 97970},
	{"UTYG", 4, 125948},
	{"UTYF", 4, 84966},
	{"UTYE", 4, 47741},
	{"UTYD", 4, 80093},
	{"UTYC", 4, 60126},
	{"UTYB", 4, 99740},
	{"UTYA", 4, 48432},
	{"UTWW", 4, 218415},
	{"UTWR", 4, 89458},
	{"UTWO", 4, 42014},
	{"UTWI", 4, 8543},
	{"UTWH", 4, 5780},
	{"UTWE", 4, 28128},
	{"UTWA", 4, 29069},
	{"UTVS", 4, 246625},
	{"UTVO", 4, 75144},
	{"UTVI", 4, 60050},
	{"UTVE", 4, 65113},
	{"UTVA", 4, 71619},
	{"UTUW", 4, 217705},
	{"UTUT", 4, 133471},
	{"UTUS", 4, 46376},
	{"UTURE", 5, 200717},
	{"UTUR", 4, 4985},
	{"UTUP", 4, 43569},
	{"UTUO", 4, 258535},
	{"UTUN", 4, 41322},
	{"UTUM", 4, 51982},
	{"UTUL", 4, 86678},
	{"UTUK", 4, 206839},
	{"UTUI", 4, 219294},
	{"UTUH", 4, 251787},
	{"UTUG", 4, 234895},
	{"UTUE", 4, 215252},
	{"UTUC", 4, 189016},
	{"UTUB", 4, 51214},
	{"UTUA", 4, 43932},
	{"UTTY", 4, 78091},
	{"UTTW", 4, 42095},
	{"UTTV", 4, 193778},
	{"UTTU", 4, 70976},
	{"UTTR", 4, 43776},
	{"UTTP", 4, 174144},
	{"UTTOXETER", 9, 124567},
	{"UTTON", 5, 196561},
	{"UTTO", 4, 4097},
	{"UTTM", 4, 158286},
	{"UTTLESFORD", 10, 246499},
	{"UTTL", 4, 46031},
	{"UTTK", 4, 228226},
	{"UTTI", 4, 8092},
	{"UTTH", 4, 1159},
	{"UTTG", 4, 90663},
	{"UTTF", 4, 131696},
	{"UTTERS", 6, 121344},
	{"UTTERMOST", 9, 133212},
	{"UTTERLYRICS", 11, 203857},
	{"UTTERLY", 7, 43975},
	{"UTTERING", 8, 110104},
	{"UTTERED", 7, 66637},
	{"UTTERBACK", 9, 185583},
	{"UTTERANCES", 10, 81768},
	{"UTTERANCE", 9, 70320},
	{"UTTER", 5, 47641},
	{"UTTE", 4, 9574},
	{"UTTD", 4, 208500},
	{"UTTB", 4, 150485},
	{"UTTARANCHAL", 11, 101231},
	{"UTTAR", 5, 68488},
	{"UTTAM", 5, 245950},
	{"UTSY", 4, 82473},
	{"UTSW", 4, 48270},
	{"UTSV", 4, 183722},
	{"UTSUNOMIYA", 10, 245237},
	{"UTSU", 4, 39703},
	{"UTSTYR", 6, 261088},
	{"UTSTARCOM", 9, 113727},
	{"UTST", 4, 8419},
	{"UTSR", 4, 94521},
	{"UTSQ", 4, 104908},
	{"UTSP", 4, 43033},
	{"UTSO", 4, 9926},
	{"UTSM", 4, 60243},
	{"UTSL", 4, 65057},
	{"UTSK", 4, 63577},
	{"UTSJ", 4, 162466},
	{"UTSH", 4, 29729},
	{"UTSG", 4, 115523},
	{"UTSF", 4, 58382},
	{"UTSE", 4, 36222},
	{"UTSD", 4, 79480},
	{"UTSC", 4, 243395},
	{"UTSB", 4, 66871},
	{"UTRY", 4, 68541},
	{"UTRU", 4, 55887},
	{"UTRO", 4, 46863},
	{"UTRITION", 8, 206074},
	{"UTRI", 4, 36099},
	{"UTRH", 4, 194349},
	{"UTRECHT", 7, 53560},
	{"UTRE", 4, 28810},
	{"UTRB", 4, 184477},
	{"UTRAN", 5, 127037},
	{"UTRA", 4, 208004},
	{"UTQU", 4, 58389},
	{"UTQ", 3, 3107},
	{"UTPU", 4, 37958},
	{"UTPS", 4, 195403},
	{"UTPR", 4, 37661},
	{"UTPO", 4, 39734},
	{"UTPM", 4, 69786},
	{"UTPL", 4, 48509},
	{"UTPI", 4, 68726},
	{"UTPH", 4, 84674},
	{"UTPE", 4, 31698},
	{"UTPA", 4, 187556},
	{"UTOZ", 4, 182273},
	{"UTOY", 4, 179450},
	{"UTOX", 4, 260856},
	{"UTOW", 4, 69642},
	{"UTOV", 4, 52413},
	{"UTOU", 4, 34193},
	{"UTORRENT", 8, 227289},
	{"UTOR", 4, 28900},
	{"UTOPOLIS", 8, 258641},
	{"UTOPIAS", 7, 164449},
	{"UTOPIANS", 8, 258142},
	{"UTOPIANISM", 10, 230495},
	{"UTOPIAN", 7, 72662},
	{"UTOPIA", 6, 51093},
	{"UTOP", 4, 45181},
	{"UTON", 4, 6042},
	{"UTOM", 4, 28126},
	{"UTOL", 4, 64857},
	{"UTOK", 4, 90766},
	{"UTOJ", 4, 153126},
	{"UTOG", 4, 58416},
	{"UTOF", 4, 2253},
	{"UTOD", 4, 62786},
	{"UTOC", 4, 53204},
	{"UTOB", 4, 41298},
	{"UTNU", 4, 65415},
	{"UTNO", 4, 7264},
	{"UTNB", 4, 256340},
	{"UTMY", 4, 44649},
	{"UTMU", 4, 51423},
	{"UTMT", 4, 228715},
	{"UTMS", 4, 131196},
	{"UTMR", 4, 81879},
	{"UTMP", 4, 157034},
	{"UTMOST", 6, 48516},
	{"UTMO", 4, 32466},
	{"UTMM", 4, 151833},
	{"UTMI", 4, 32965},
	{"UTMF", 4, 231570},
	{"UTME", 4, 41815},
	{"UTMD", 4, 249120},
	{"UTMB", 4, 127227},
	{"UTLY", 4, 88689},
	{"UTLU", 4, 95061},
	{"UTLO", 4, 34535},
	{"UTLI", 4, 36176},
	{"UTLEY", 5, 121587},
	{"UTLE", 4, 29669},
	{"UTLD", 4, 249776},
	{"UTLB", 4, 223531},
	{"UTLA", 4, 35927},
	{"UTKY", 4, 209490},
	{"UTKU", 4, 133708},
	{"UTKR", 4, 152337},
	{"UTKO", 4, 106583},
	{"UTKN", 4, 74829},
	{"UTKM", 4, 56277},
	{"UTKL", 4, 253541},
	{"UTKI", 4, 60540},
	{"UTKH", 4, 208921},
	{"UTKG", 4, 210677},
	{"UTKE", 4, 62007},
	{"UTKA", 4, 78455},
	{"UTJU", 4, 49208},
	{"UTJO", 4, 54843},
	{"UTJI", 4, 131947},
	{"UTJE", 4, 77725},
	{"UTJA", 4, 64317},
	{"UTJ", 3, 1167},
	{"UTIZ", 4, 207546},
	{"UTIW", 4, 47484},
	{"UTIV", 4, 6443},
	{"UTIU", 4, 140105},
	{"UTIT", 4, 3280},
	{"UTIR", 4, 64582},
	{"UTIQ", 4, 75299},
	{"UTIP", 4, 108502},
	{"UTION", 5, 233803},
	{"UTIO", 4, 2178},
	{"UTIN", 4, 2909},
	{"UTIME", 5, 203938},
	{"UTIMCO", 6, 254040},
	{"UTIMACO", 7, 144188},
	{"UTIM", 4, 42145},
	{"UTILS", 5, 29276},
	{"UTILIZZO", 8, 221437},
	{"UTILIZING", 9, 37464},
	{"UTILIZES", 8, 47237},
	{"UTILIZED", 8, 37798},
	{"UTILIZE", 7, 32263},
	{"UTILIZATION", 11, 33770},
	{"UTILIZAR", 8, 178229},
	{"UTILIZANDO", 10, 240100},
	{"UTILIZA", 7, 181525},
	{"UTILITYBANK", 11, 231445},
	{"UTILITY", 7, 8004},
	{"UTILITIES", 9, 4325},
	{"UTILITES", 8, 162594},
	{"UTILITARIANISM", 14, 122722},
	{"UTILITARIAN", 11, 84115},
	{"UTILISING", 9, 72692},
	{"UTILISEZ", 8, 197363},
	{"UTILISES", 8, 107925},
	{"UTILISER", 8, 121372},
	{"UTILISED", 8, 66066},
	{"UTILISE", 7, 65716},
	{"UTILISATION", 11, 51886},
	{"UTILISATEURS", 12, 98536},
	{"UTILISATEUR", 11, 129270},
	{"UTILISANT", 9, 200819},
	{"UTILIDADES", 10, 260569},
	{"UTILICE", 7, 240428},
	{"UTILI", 5, 139846},
	{"UTILES", 6, 208213},
	{"UTILE", 5, 100684},
	{"UTILA", 5, 217539},
	{"UTIL", 4, 47437},
	{"UTIK", 4, 77427},
	{"UTIJ", 4, 101170},
	{"UTIG", 4, 74723},
	{"UTIF", 4, 9010},
	{"UTIE", 4, 35536},
	{"UTID", 4, 41850},
	{"UTICA", 5, 55884},
	{"UTIC", 4, 39071},
	{"UTIB", 4, 94382},
	{"UTHY", 4, 91538},
	{"UTHW", 4, 30129},
	{"UTHV", 4, 72517},
	{"UTHU", 4, 56947},
	{"UTHSCSA", 7, 148651},
	{"UTHSC", 5, 221802},
	{"UTHS", 4, 34768},
	{"UTHR", 4, 49035},
	{"UTHQ", 4, 237679},
	{"UTHP", 4, 45889},
	{"UTHORITY", 8, 208014},
	{"UTHOR", 5, 232209},
	{"UTHO", 4, 3037},
	{"UTHMAN", 6, 164934},
	{"UTHM", 4, 54663},
	{"UTHL", 4, 49006},
	{"UTHK", 4, 47289},
	{"UTHJ", 4, 96697},
	{"UTHI", 4, 4680},
	{"UTHG", 4, 64922},
	{"UTHF", 4, 42302},
	{"UTHER", 5, 169257},
	{"UTHD", 4, 53806},
	{"UTHC", 4, 36378},
	{"UTHB", 4, 41009},
	{"UTHA", 4, 4786},
	{"UTGU", 4, 78971},
	{"UTGR", 4, 49083},
	{"UTGO", 4, 43553},
	{"UTGM", 4, 197575},
	{"UTGL", 4, 99169},
	{"UTGIVARE", 8, 247064},
	{"UTGI", 4, 60348},
	{"UTGH", 4, 243007},
	{"UTGE", 4, 43824},
	{"UTGA", 4, 55420},
	{"UTFU", 4, 62173},
	{"UTFT", 4, 197743},
	{"UTFR", 4, 37682},
	{"UTFO", 4, 8607},
	{"UTFL", 4, 62149},
	{"UTFI", 4, 31923},
	{"UTFE", 4, 45724},
	{"UTFA", 4, 44070},
	{"UTEZ", 4, 185611},
	{"UTEY", 4, 102614},
	{"UTEW", 4, 44656},
	{"UTEV", 4, 34741},
	{"UTEU", 4, 68347},
	{"UTET", 4, 30598},
	{"UTERUS", 6, 53714},
	{"UTERO", 5, 103869},
	{"UTERINE", 7, 56154},
	{"UTERI", 5, 160868},
	{"UTER", 4, 169967},
	{"UTEQ", 4, 101695},
	{"UTEP", 4, 84952},
	{"UTENTI", 6, 105914},
	{"UTENTE", 6, 125809},
	{"UTENSILS", 8, 49206},
	{"UTENSIL", 7, 90426},
	{"UTENA", 5, 127720},
	{"UTEM", 4, 45133},
	{"UTELL", 5, 125356},
	{"UTEL", 4, 33551},
	{"UTEJ", 4, 112840},
	{"UTEG", 4, 77979},
	{"UTEF", 4, 41761},
	{"UTED", 4, 165294},
	{"UTEB", 4, 48704},
	{"UTEA", 4, 32468},
	{"UTDY", 4, 178052},
	{"UTDW", 4, 222858},
	{"UTDU", 4, 52586},
	{"UTDR", 4, 60209},
	{"UTDO", 4, 9753},
	{"UTDI", 4, 37789},
	{"UTDE", 4, 38192},
	{"UTDA", 4, 48426},
	{"UTCY", 4, 183374},
	{"UTCU", 4, 67263},
	{"UTCT", 4, 140106},
	{"UTCR", 4, 47676},
	{"UTCO", 4, 9160},
	{"UTCM", 4, 131479},
	{"UTCL", 4, 51928},
	{"UTCI", 4, 83277},
	{"UTCH", 4, 9544},
	{"UTCF", 4, 236733},
	{"UTCE", 4, 64083},
	{"UTCD", 4, 188287},
	{"UTCB", 4, 245439},
	{"UTCA", 4, 176722},
	{"UTC", 3, 254},
	{"UTBY", 4, 37427},
	{"UTBU", 4, 40262},
	{"UTBR", 4, 41775},
	{"UTBP", 4, 237349},
	{"UTBO", 4, 45234},
	{"UTBL", 4, 69287},
	{"UTBILDNING", 10, 214955},
	{"UTBI", 4, 50680},
	{"UTBE", 4, 31033},
	{"UTBC", 4, 138437},
	{"UTBA", 4, 39161},
	{"UTAZ", 4, 199025},
	{"UTAY", 4, 62010},
	{"UTAW", 4, 49488},
	{"UTAV", 4, 68229},
	{"UTAU", 4, 70326},
	{"UTAT", 4, 7496},
	{"UTARA", 5, 201304},
	{"UTAR", 4, 35560},
	{"UTAQ", 4, 102270},
	{"UTAP", 4, 41240},
	{"UTAMA", 5, 146038},
	{"UTAM", 4, 39465},
	{"UTAL", 4, 6966},
	{"UTAK", 4, 52812},
	{"UTAJ", 4, 117011},
	{"UTAHNS", 6, 240212},
	{"UTAH", 4, 4560},
	{"UTAGAWA", 7, 251006},
	{"UTAG", 4, 40913},
	{"UTAF", 4, 36668},
	{"UTADA", 5, 145252},
	{"UTAD", 4, 41546},
	{"UTAC", 4, 38284},
	{"UTAB", 4, 38363},
	{"USZO", 4, 172062},
	{"USZK", 4, 169268},
	{"USZI", 4, 211999},
	{"USZE", 4, 150785},
	{"USZA", 4, 186630},
	{"USZ", 3, 5426},
	{"USYY", 4, 226498},
	{"USYW", 4, 82014},
	{"USYU", 4, 229229},
	{"USYT", 4, 83035},
	{"USYR", 4, 128687},
	{"USYP", 4, 106841},
	{"USYO", 4, 61758},
	{"USYN", 4, 156692},
	{"USYM", 4, 114118},
	{"USYL", 4, 139414},
	{"USYJ", 4, 243903},
	{"USYI", 4, 110542},
	{"USYH", 4, 143047},
	{"USYG", 4, 198354},
	{"USYF", 4, 121101},
	{"USYE", 4, 48870},
	{"USYD", 4, 183065},
	{"USYC", 4, 118226},
	{"USYB", 4, 109001},
	{"USYA", 4, 72526},
	{"USXM", 4, 173340},
	{"USXI", 4, 130226},
	{"USWR", 4, 86733},
	{"USWO", 4, 44737},
	{"USWITCH", 7, 180143},
	{"USWI", 4, 36982},
	{"USWH", 4, 37127},
	{"USWEST", 6, 166589},
	{"USWE", 4, 43677},
	{"USWD", 4, 261128},
	{"USWA", 4, 203899},
	{"USVS", 4, 226721},
	{"USVO", 4, 80499},
	{"USVI", 4, 114554},
	{"USVE", 4, 62544},
	{"USVA", 4, 74540},
	{"USUT", 4, 171570},
	{"USUSALLY", 8, 214800},
	{"USUS", 4, 241811},
	{"USURY", 5, 116818},
	{"USURPING", 8, 157032},
	{"USURPER", 7, 157480},
	{"USURPED", 7, 129029},
	{"USURPATION", 10, 152691},
	{"USURP", 5, 125124},
	{"USUR", 4, 65609},
	{"USUP", 4, 64528},
	{"USUMACINTA", 10, 185942},
	{"USUM", 4, 115379},
	{"USUK", 4, 106283},
	{"USUI", 4, 141990},
	{"USUG", 4, 120689},
	{"USUFRUCT", 8, 212477},
	{"USUF", 4, 93849},
	{"USUD", 4, 205444},
	{"USUC", 4, 127056},
	{"USUB", 4, 129481},
	{"USUARIOS", 8, 95221},
	{"USUARIO", 7, 100046},
	{"USUARI", 6, 249613},
	{"USUALY", 6, 161068},
	{"USUALLY", 7, 2309},
	{"USUALL", 6, 209629},
	{"USUAL", 5, 7448},
	{"USTY", 4, 41553},
	{"USTW", 4, 28179},
	{"USTV", 4, 66610},
	{"USTU", 4, 40859},
	{"USTT", 4, 5582},
	{"USTRING", 7, 238461},
	{"USTRCMP", 7, 242420},
	{"USTR", 4, 116114},
	{"USTQ", 4, 128471},
	{"USTP", 4, 33417},
	{"USTM", 4, 31410},
	{"USTL", 4, 29451},
	{"USTK", 4, 46910},
	{"USTJ", 4, 77340},
	{"USTINOV", 7, 151932},
	{"USTICE", 6, 224833},
	{"USTH", 4, 4600},
	{"USTG", 4, 34910},
	{"USTF", 4, 31039},
	{"USTER", 5, 241561},
	{"USTEDES", 7, 211771},
	{"USTED", 5, 92083},
	{"USTE", 4, 6065},
	{"USTD", 4, 32365},
	{"USTC", 4, 204073},
	{"USTB", 4, 5692},
	{"USTAR", 5, 104959},
	{"USTAD", 5, 160595},
	{"USSY", 4, 222936},
	{"USSW", 4, 67711},
	{"USSV", 4, 176983},
	{"USST", 4, 31437},
	{"USSSA", 5, 199590},
	{"USSR", 4, 45225},
	{"USSQ", 4, 159416},
	{"USSP", 4, 47501},
	{"USSM", 4, 68006},
	{"USSL", 4, 71121},
	{"USSK", 4, 91267},
	{"USSJ", 4, 188288},
	{"USSITE", 6, 181256},
	{"USSI", 4, 4180},
	{"USSHER", 6, 238854},
	{"USSG", 4, 157941},
	{"USSF", 4, 204899},
	{"USSERY", 6, 225654},
	{"USSE", 4, 7000},
	{"USSD", 4, 184800},
	{"USSC", 4, 182939},
	{"USSB", 4, 91220},
	{"USRY", 4, 214817},
	{"USRU", 4, 68748},
	{"USRS", 4, 211812},
	{"USRP", 4, 234738},
	{"USROWING", 8, 229893},
	{"USROBOTICS", 10, 168665},
	{"USRO", 4, 48040},
	{"USRN", 4, 245397},
	{"USRI", 4, 58800},
	{"USRH", 4, 188132},
	{"USRE", 4, 31699},
	{"USRD", 4, 260017},
	{"USRA", 4, 176401},
	{"USR", 3, 1894},
	{"USQUE", 5, 238060},
	{"USQU", 4, 49484},
	{"USPU", 4, 62210},
	{"USPTO", 5, 77831},
	{"USPT", 4, 191065},
	{"USPSTF", 6, 163093},
	{"USPS", 4, 35986},
	{"USPRIVACY", 9, 218126},
	{"USPR", 4, 34328},
	{"USPQ", 4, 157427},
	{"USPM", 4, 228468},
	{"USPL", 4, 48208},
	{"USPI", 4, 39125},
	{"USPHS", 5, 244175},
	{"USPH", 4, 77307},
	{"USPE", 4, 6852},
	{"USPAP", 5, 182901},
	{"USPA", 4, 255136},
	{"USOY", 4, 250465},
	{"USOX", 4, 188707},
	{"USOW", 4, 92749},
	{"USOV", 4, 78542},
	{"USOU", 4, 56509},
	{"USOR", 4, 43363},
	{"USOP", 4, 48234},
	{"USON", 4, 29235},
	{"USOM", 4, 73611},
	{"USOL", 4, 65604},
	{"USOK", 4, 206626},
	{"USOG", 4, 232951},
	{"USOF", 4, 30368},
	{"USOD", 4, 162032},
	{"USOC", 4, 106559},
	{"USOB", 4, 81585},
	{"USNU", 4, 92491},
	{"USNR", 4, 159062},
	{"USNM", 4, 208030},
	{"USNF", 4, 239592},
	{"USNEWS", 6, 147220},
	{"USND", 4, 236343},
	{"USMU", 4, 61703},
	{"USMS", 4, 138574},
	{"USMR", 4, 164462},
	{"USMO", 4, 40990},
	{"USMLE", 5, 78119},
	{"USMI", 4, 40392},
	{"USME", 4, 43647},
	{"USMD", 4, 227934},
	{"USMC", 4, 64313},
	{"USMARC", 6, 251615},
	{"USMAN", 5, 140595},
	{"USMA", 4, 164774},
	{"USLY", 4, 4116},
	{"USLU", 4, 116884},
	{"USLS", 4, 257393},
	{"USLO", 4, 49513},
	{"USLI", 4, 28906},
	{"USLEEP", 6, 217773},
	{"USLA", 4, 46476},
	{"USKY", 4, 77824},
	{"USKW", 4, 182520},
	{"USKU", 4, 176560},
	{"USKT", 4, 168280},
	{"USKS", 4, 107740},
	{"USKR", 4, 160178},
	{"USKO", 4, 85689},
	{"USKN", 4, 77746},
	{"USKL", 4, 250466},
	{"USKI", 4, 45751},
	{"USKH", 4, 197576},
	{"USKF", 4, 254601},
	{"USKE", 4, 52931},
	{"USKC", 4, 251788},
	{"USKA", 4, 68213},
	{"USJU", 4, 71129},
	{"USJO", 4, 64270},
	{"USJI", 4, 241590},
	{"USJE", 4, 107079},
	{"USJA", 4, 88811},
	{"USIX", 4, 175730},
	{"USIW", 4, 146009},
	{"USIV", 4, 32785},
	{"USIU", 4, 204478},
	{"USITC", 5, 169731},
	{"USIR", 4, 100650},
	{"USIQ", 4, 168888},
	{"USIO", 4, 9714},
	{"USINVESTMENT", 12, 167196},
	{"USING", 5, 953},
	{"USINESS", 7, 122989},
	{"USINE", 5, 162331},
	{"USIM", 4, 165809},
	{"USIL", 4, 74997},
	{"USIK", 4, 113615},
	{"USIG", 4, 99974},
	{"USIF", 4, 72874},
	{"USID", 4, 87962},
	{"USIC", 4, 131447},
	{"USIB", 4, 76802},
	{"USHY", 4, 68629},
	{"USHW", 4, 51760},
	{"USHV", 4, 122745},
	{"USHUAIA", 7, 126655},
	{"USHU", 4, 59976},
	{"USHR", 4, 54042},
	{"USHPIZIN", 8, 177683},
	{"USHP", 4, 68822},
	{"USHOTELS", 8, 186237},
	{"USHOTEL", 7, 186245},
	{"USHORT", 6, 158906},
	{"USHO", 4, 30554},
	{"USHM", 4, 63424},
	{"USHL", 4, 211874},
	{"USHK", 4, 93850},
	{"USHJ", 4, 146631},
	{"USHIP", 5, 65303},
	{"USHIO", 5, 146188},
	{"USHG", 4, 99867},
	{"USHF", 4, 53205},
	{"USHERS", 6, 94875},
	{"USHERING", 8, 131786},
	{"USHERED", 7, 89641},
	{"USHER", 5, 36829},
	{"USHELPSERVICE", 13, 197160},
	{"USHE", 4, 7156},
	{"USHD", 4, 70742},
	{"USHC", 4, 58672},
	{"USHBA", 5, 241079},
	{"USHB", 4, 63757},
	{"USGU", 4, 86274},
	{"USGS", 4, 33089},
	{"USGR", 4, 47498},
	{"USGPO", 5, 123811},
	{"USGO", 4, 45726},
	{"USGL", 4, 112087},
	{"USGH", 4, 261571},
	{"USGENWEB", 8, 60036},
	{"USGE", 4, 59255},
	{"USGBC", 5, 199087},
	{"USGA", 4, 100645},
	{"USFWS", 5, 86765},
	{"USFU", 4, 66470},
	{"USFS", 4, 85608},
	{"USFREEADS", 9, 218568},
	{"USFR", 4, 254698},
	{"USFO", 4, 30948},
	{"USFL", 4, 249291},
	{"USFK", 4, 246133},
	{"USFILTER", 8, 229166},
	{"USFI", 4, 44749},
	{"USFE", 4, 55474},
	{"USFA", 4, 166268},
	{"USEZ", 4, 178650},
	{"USEY", 4, 40524},
	{"USEU", 4, 10012},
	{"USETRADEMARKSCOPYRIGHT", 22, 151713},
	{"USETHREADS", 10, 173535},
	{"USESOCKS", 8, 177558},
	{"USESHRPLIB", 10, 174988},
	{"USESCALE", 8, 205651},
	{"USES", 4, 2372},
	{"USERV", 5, 238315},
	{"USERSPACE", 9, 109197},
	{"USERS", 5, 1228},
	{"USERRA", 6, 158201},
	{"USERPROFILE", 11, 196808},
	{"USERPREFERENCES", 15, 142046},
	{"USERPICS", 8, 69559},
	{"USERPIC", 7, 42614},
	{"USERPASSWORD", 12, 219676},
	{"USERPAGE", 8, 230263},
	{"USERNAMES", 9, 77370},
	{"USERNAME", 8, 3242},
	{"USERMODE", 8, 204243},
	{"USERMIN", 7, 101095},
	{"USERLIST", 8, 178211},
	{"USERLEVEL", 9, 248081},
	{"USERLAND", 8, 61185},
	{"USERINFO", 8, 70377},
	{"USERIDS", 7, 253122},
	{"USERID", 6, 57410},
	{"USERGUIDE", 9, 152153},
	{"USERGROUPSUSERGROUPS", 20, 48615},
	{"USERGROUPS", 10, 60807},
	{"USERGROUP", 9, 84287},
	{"USERFRIENDLY", 12, 155837},
	{"USERFILE", 8, 259130},
	{"USERDICT", 8, 184783},
	{"USERDATA", 8, 104264},
	{"USERCP", 6, 257595},
	{"USERCONTROL", 11, 227592},
	{"USERBASE", 8, 240529},
	{"USERAGENT", 9, 115715},
	{"USERADMIN", 9, 212940},
	{"USERADD", 7, 173559},
	{"USER", 4, 5421},
	{"USEQ", 4, 99720},
	{"USEPOSIX", 8, 175297},
	{"USEPERLIO", 9, 174934},
	{"USEPERL", 7, 207691},
	{"USEPACKAGE", 10, 160561},
	{"USEPA", 5, 75128},
	{"USEP", 4, 36133},
	{"USENIX", 6, 99713},
	{"USENEXT", 7, 150701},
	{"USENET", 6, 39467},
	{"USEMYMALLOC", 11, 174330},
	{"USEMULTIPLICITY", 15, 177341},
	{"USEMOD", 6, 260973},
	{"USELONGDOUBLE", 13, 177401},
	{"USELESSNESS", 11, 187612},
	{"USELESSLY", 9, 173981},
	{"USELESS", 7, 36973},
	{"USELARGEFILES", 13, 176922},
	{"USEL", 4, 36239},
	{"USEK", 4, 61955},
	{"USEJ", 4, 69111},
	{"USEITHREADS", 11, 176701},
	{"USEING", 6, 154401},
	{"USEI", 4, 4527},
	{"USEH", 4, 6157},
	{"USEGOOD", 7, 224750},
	{"USEG", 4, 45469},
	{"USEFULNESS", 10, 46957},
	{"USEFULLY", 8, 92255},
	{"USEFULL", 7, 68588},
	{"USEFUL", 6, 6063},
	{"USEFOR", 6, 233073},
	{"USEFLASHLC", 10, 246502},
	{"USEF", 4, 147494},
	{"USEDOM", 6, 107564},
	{"USEDCAR", 7, 168325},
	{"USED", 4, 5815},
	{"USECS", 5, 222309},
	{"USEC", 4, 97395},
	{"USEB", 4, 35568},
	{"USEAST", 6, 155617},
	{"USEAND", 6, 194427},
	{"USEAGE", 6, 146747},
	{"USEABLE", 7, 75090},
	{"USEABILITY", 10, 201550},
	{"USE", 3, 609},
	{"USDY", 4, 224869},
	{"USDW", 4, 190487},
	{"USDV", 4, 231075},
	{"USDU", 4, 70240},
	{"USDT", 4, 177934},
	{"USDS", 4, 182064},
	{"USDR", 4, 58027},
	{"USDP", 4, 185356},
	{"USDOT", 5, 120222},
	{"USDOE", 5, 143513},
	{"USDOC", 5, 227607},
	{"USDO", 4, 44415},
	{"USDM", 4, 121628},
	{"USDJ", 4, 235211},
	{"USDIN", 5, 216171},
	{"USDI", 4, 184915},
	{"USDH", 4, 250113},
	{"USDF", 4, 208196},
	{"USDE", 4, 189911},
	{"USDC", 4, 198270},
	{"USDB", 4, 149795},
	{"USDAW", 5, 189378},
	{"USDA", 4, 35129},
	{"USD", 3, 4241},
	{"USCY", 4, 120573},
	{"USCW", 4, 133954},
	{"USCU", 4, 51708},
	{"USCS", 4, 150949},
	{"USCR", 4, 41955},
	{"USCP", 4, 193627},
	{"USCONTACT", 9, 126497},
	{"USCOLLEGESEARCH", 15, 204623},
	{"USCN", 4, 257394},
	{"USCL", 4, 38576},
	{"USCITA", 6, 231432},
	{"USCIS", 5, 107520},
	{"USCI", 4, 47906},
	{"USCHO", 5, 210455},
	{"USCHI", 5, 214160},
	{"USCGC", 5, 224042},
	{"USCG", 4, 81936},
	{"USCF", 4, 147510},
	{"USCENSUS", 8, 174903},
	{"USCE", 4, 48941},
	{"USCD", 4, 164891},
	{"USCCB", 5, 180256},
	{"USCCAN", 6, 251090},
	{"USCC", 4, 153880},
	{"USCALL", 6, 252340},
	{"USCA", 4, 101401},
	{"USC", 3, 8475},
	{"USBY", 4, 57815},
	{"USBU", 4, 38994},
	{"USBT", 4, 214219},
	{"USBS", 4, 161030},
	{"USBR", 4, 202807},
	{"USBP", 4, 113313},
	{"USBORNE", 7, 82141},
	{"USBOOKS", 7, 174897},
	{"USBO", 4, 49613},
	{"USBM", 4, 199183},
	{"USBL", 4, 230130},
	{"USBID", 5, 174192},
	{"USBI", 4, 53476},
	{"USBH", 4, 207926},
	{"USBF", 4, 191366},
	{"USBE", 4, 39177},
	{"USBD", 4, 148326},
	{"USBCORE", 7, 260258},
	{"USBC", 4, 174939},
	{"USBB", 4, 239860},
	{"USB", 3, 253},
	{"USAY", 4, 48997},
	{"USAW", 4, 53556},
	{"USAU", 4, 61211},
	{"USATODAYCOM", 11, 231413},
	{"USATODAY", 8, 142529},
	{"USATO", 5, 163755},
	{"USATI", 5, 240309},
	{"USATF", 5, 118634},
	{"USATE", 5, 169328},
	{"USATA", 5, 234282},
	{"USART", 5, 260310},
	{"USARMY", 6, 248028},
	{"USAREUR", 7, 185384},
	{"USARE", 5, 220878},
	{"USAR", 4, 98621},
	{"USAQ", 4, 209491},
	{"USAP", 4, 253081},
	{"USAOPOLY", 8, 150958},
	{"USANDO", 6, 153204},
	{"USANA", 5, 157065},
	{"USAMO", 5, 259787},
	{"USAMA", 5, 127415},
	{"USAM", 4, 49228},
	{"USALLY", 6, 198375},
	{"USAL", 4, 32449},
	{"USAJOBS", 7, 152909},
	{"USAJ", 4, 170348},
	{"USAIR", 5, 224472},
	{"USAID", 5, 46292},
	{"USAHOTELS", 9, 186105},
	{"USAHOTEL", 8, 186246},
	{"USAGI", 5, 91018},
	{"USAGES", 6, 82504},
	{"USAGE", 5, 4837},
	{"USAG", 4, 230825},
	{"USAFE", 5, 193031},
	{"USAFA", 5, 196901},
	{"USAF", 4, 56568},
	{"USADOS", 6, 168784},
	{"USADO", 5, 257869},
	{"USADA", 5, 208403},
	{"USAD", 4, 42137},
	{"USACOPS", 7, 184205},
	{"USACOM", 6, 241459},
	{"USACITYLINK", 11, 227183},
	{"USACE", 5, 94373},
	{"USAC", 4, 104779},
	{"USABOUT", 7, 201258},
	{"USABLE", 6, 41044},
	{"USABILITY", 9, 37693},
	{"USAB", 4, 39406},
	{"USAAF", 5, 170477},
	{"USA", 3, 1056},
	{"URZW", 4, 192627},
	{"URZO", 4, 130582},
	{"URZI", 4, 199184},
	{"URZE", 4, 171870},
	{"URZA", 4, 164149},
	{"URZ", 3, 246727},
	{"URYY", 4, 129874},
	{"URYW", 4, 43908},
	{"URYV", 4, 95755},
	{"URYU", 4, 86025},
	{"URYT", 4, 35456},
	{"URYS", 4, 39296},
	{"URYR", 4, 56174},
	{"URYP", 4, 50031},
	{"URYO", 4, 43712},
	{"URYN", 4, 71088},
	{"URYM", 4, 54869},
	{"URYL", 4, 61707},
	{"URYK", 4, 96735},
	{"URYJ", 4, 110789},
	{"URYI", 4, 41585},
	{"URYH", 4, 50153},
	{"URYG", 4, 80237},
	{"URYF", 4, 53575},
	{"URYE", 4, 31197},
	{"URYD", 4, 56467},
	{"URYC", 4, 47261},
	{"URYB", 4, 44489},
	{"URYA", 4, 33828},
	{"URY", 3, 140082},
	{"URWR", 4, 108980},
	{"URWO", 4, 47313},
	{"URWI", 4, 43454},
	{"URWH", 4, 47655},
	{"URWE", 4, 46377},
	{"URWA", 4, 40753},
	{"URW", 3, 8060},
	{"URVY", 4, 136416},
	{"URVO", 4, 68159},
	{"URVI", 4, 7030},
	{"URVEY", 5, 210036},
	{"URVE", 4, 9551},
	{"URVA", 4, 69232},
	{"URUW", 4, 145523},
	{"URUV", 4, 225078},
	{"URUT", 4, 109842},
	{"URUSEI", 6, 95960},
	{"URUR", 4, 123325},
	{"URUP", 4, 98446},
	{"URUO", 4, 167910},
	{"URUN", 4, 49873},
	{"URUMQI", 6, 135508},
	{"URUM", 4, 259629},
	{"URUL", 4, 111231},
	{"URUK", 4, 138428},
	{"URUJ", 4, 184608},
	{"URUI", 4, 132839},
	{"URUH", 4, 146465},
	{"URUGUAYAN", 9, 81300},
	{"URUGUAY", 7, 31712},
	{"URUG", 4, 64583},
	{"URUF", 4, 148897},
	{"URUD", 4, 133914},
	{"URUC", 4, 176369},
	{"URUBAMBA", 8, 237167},
	{"URUB", 4, 141583},
	{"URUA", 4, 106419},
	{"URU", 3, 121342},
	{"URTZ", 4, 105670},
	{"URTY", 4, 58399},
	{"URTW", 4, 45536},
	{"URTV", 4, 93886},
	{"URTU", 4, 54141},
	{"URTT", 4, 42230},
	{"URTS", 4, 31843},
	{"URTR", 4, 37408},
	{"URTP", 4, 62449},
	{"URTO", 4, 29582},
	{"URTN", 4, 57520},
	{"URTM", 4, 60841},
	{"URTL", 4, 48082},
	{"URTK", 4, 152205},
	{"URTJ", 4, 61656},
	{"URTICARIA", 9, 119341},
	{"URTICA", 6, 212931},
	{"URTI", 4, 30324},
	{"URTH", 4, 80409},
	{"URTG", 4, 95809},
	{"URTF", 4, 55143},
	{"URTEIL", 6, 143481},
	{"URTE", 4, 33232},
	{"URTD", 4, 53899},
	{"URTC", 4, 51771},
	{"URTB", 4, 53425},
	{"URTA", 4, 31739},
	{"URSY", 4, 75832},
	{"URSW", 4, 44825},
	{"URSV", 4, 135025},
	{"URSUS", 5, 134173},
	{"URSULINE", 8, 137084},
	{"URSULA", 6, 62322},
	{"URST", 4, 8449},
	{"URSR", 4, 85196},
	{"URSQ", 4, 59990},
	{"URSP", 4, 46043},
	{"URSO", 4, 171129},
	{"URSN", 4, 85548},
	{"URSM", 4, 55536},
	{"URSL", 4, 53550},
	{"URSK", 4, 73799},
	{"URSJ", 4, 155639},
	{"URSINUS", 7, 123076},
	{"URSINE", 6, 233898},
	{"URSIN", 5, 256721},
	{"URSI", 4, 125332},
	{"URSH", 4, 42306},
	{"URSG", 4, 105167},
	{"URSF", 4, 58452},
	{"URSELF", 6, 147759},
	{"URSE", 4, 2670},
	{"URSD", 4, 7865},
	{"URSC", 4, 46675},
	{"URSB", 4, 51911},
	{"URSA", 4, 114744},
	{"URS", 3, 252},
	{"URRY", 4, 238092},
	{"URRW", 4, 217066},
	{"URRUTIA", 7, 213102},
	{"URRU", 4, 57594},
	{"URRT", 4, 230840},
	{"URRS", 4, 118996},
	{"URRR", 4, 210483},
	{"URRO", 4, 9438},
	{"URRJ", 4, 226975},
	{"URRI", 4, 9456},
	{"URRH", 4, 182868},
	{"URRENT", 6, 204945},
	{"URRE", 4, 2140},
	{"URRB", 4, 115970},
	{"URRA", 4, 36830},
	{"URR", 3, 197101},
	{"URQUHART", 8, 104511},
	{"URQU", 4, 55383},
	{"URQA", 4, 167647},
	{"URQ", 3, 2652},
	{"URPU", 4, 72052},
	{"URPT", 4, 213216},
	{"URPS", 4, 139796},
	{"URPR", 4, 6343},
	{"URPOSE", 6, 256887},
	{"URPO", 4, 7955},
	{"URPMI", 5, 166076},
	{"URPL", 4, 36282},
	{"URPI", 4, 61035},
	{"URPH", 4, 42217},
	{"URPE", 4, 42174},
	{"URPC", 4, 141532},
	{"URPA", 4, 35101},
	{"URP", 3, 176160},
	{"UROZ", 4, 87637},
	{"UROY", 4, 152206},
	{"UROW", 4, 36089},
	{"UROV", 4, 66589},
	{"UROU", 4, 58666},
	{"UROTHELIAL", 10, 234623},
	{"UROT", 4, 55238},
	{"UROS", 4, 153758},
	{"UROR", 4, 40155},
	{"UROQ", 4, 243320},
	{"UROPEAN", 7, 207659},
	{"UROP", 4, 242803},
	{"UROO", 4, 129080},
	{"URON", 4, 41464},
	{"UROM", 4, 88012},
	{"UROLOGY", 7, 51392},
	{"UROLOGISTS", 10, 117156},
	{"UROLOGIST", 9, 130954},
	{"UROLOGICALS", 11, 224362},
	{"UROLOGICAL", 10, 110300},
	{"UROLOGIC", 8, 96140},
	{"UROL", 4, 98908},
	{"UROKINASE", 9, 161433},
	{"UROK", 4, 144768},
	{"UROI", 4, 84275},
	{"UROH", 4, 123127},
	{"UROGRAPHY", 9, 248896},
	{"UROGENITAL", 10, 144375},
	{"UROG", 4, 121216},
	{"UROF", 4, 31490},
	{"UROE", 4, 141326},
	{"URODYNAMIC", 10, 259079},
	{"UROD", 4, 89808},
	{"UROB", 4, 69801},
	{"UROA", 4, 72484},
	{"URNY", 4, 86999},
	{"URNW", 4, 51965},
	{"URNV", 4, 98372},
	{"URNU", 4, 60610},
	{"URNT", 4, 7872},
	{"URNS", 4, 70337},
	{"URNR", 4, 65203},
	{"URNQ", 4, 217483},
	{"URNP", 4, 55445},
	{"URNO", 4, 28153},
	{"URNN", 4, 90958},
	{"URNM", 4, 64517},
	{"URNL", 4, 63839},
	{"URNK", 4, 126806},
	{"URNJ", 4, 124248},
	{"URNI", 4, 5673},
	{"URNH", 4, 45394},
	{"URNG", 4, 88192},
	{"URNF", 4, 44475},
	{"URNE", 4, 2488},
	{"URND", 4, 65935},
	{"URNC", 4, 59057},
	{"URNB", 4, 49316},
	{"URNA", 4, 134433},
	{"URMY", 4, 189804},
	{"URMU", 4, 63463},
	{"URMSTON", 7, 205813},
	{"URMS", 4, 167648},
	{"URMR", 4, 259282},
	{"URMP", 4, 107454},
	{"URMO", 4, 33415},
	{"URMM", 4, 249777},
	{"URMILA", 6, 204444},
	{"URMI", 4, 40093},
	{"URME", 4, 42484},
	{"URMB", 4, 238214},
	{"URMA", 4, 37172},
	{"URM", 3, 172902},
	{"URLY", 4, 64063},
	{"URLW", 4, 250467},
	{"URLU", 4, 94603},
	{"URLTRENDS", 9, 184311},
	{"URLT", 4, 180202},
	{"URLSEARCHHOOK", 13, 257705},
	{"URLS", 4, 35141},
	{"URLPARAM", 8, 109146},
	{"URLO", 4, 41472},
	{"URLL", 4, 212207},
	{"URLID", 5, 119409},
	{"URLICHS", 7, 227924},
	{"URLI", 4, 33685},
	{"URLENCODED", 10, 212505},
	{"URLENCODE", 9, 174409},
	{"URLE", 4, 38680},
	{"URLD", 4, 252493},
	{"URLCOLLECTION", 13, 237208},
	{"URLC", 4, 204479},
	{"URLB", 4, 179878},
	{"URLAUBSFOTOS", 12, 196977},
	{"URLAUBSFICK", 11, 188600},
	{"URLAUBSBILDER", 13, 227391},
	{"URLAUB", 6, 101074},
	{"URLACHER", 8, 167381},
	{"URL", 3, 1520},
	{"URKY", 4, 103293},
	{"URKW", 4, 198514},
	{"URKU", 4, 146928},
	{"URKT", 4, 217949},
	{"URKS", 4, 63833},
	{"URKR", 4, 219050},
	{"URKO", 4, 82638},
	{"URKN", 4, 93757},
	{"URKM", 4, 100901},
	{"URKL", 4, 188559},
	{"URKI", 4, 37647},
	{"URKH", 4, 91992},
	{"URKE", 4, 35830},
	{"URKB", 4, 223532},
	{"URKA", 4, 92000},
	{"URJU", 4, 89618},
	{"URJO", 4, 57366},
	{"URJI", 4, 232952},
	{"URJE", 4, 132669},
	{"URJA", 4, 103209},
	{"URIZ", 4, 78367},
	{"URIY", 4, 134901},
	{"URIW", 4, 88128},
	{"URIV", 4, 99240},
	{"URIU", 4, 139887},
	{"URIT", 4, 5007},
	{"URIS", 4, 73410},
	{"URIR", 4, 85635},
	{"URIP", 4, 74816},
	{"URIO", 4, 37641},
	{"URING", 5, 183688},
	{"URINETOWN", 9, 233121},
	{"URINE", 5, 36914},
	{"URINATION", 9, 77928},
	{"URINATING", 9, 105744},
	{"URINATED", 8, 214297},
	{"URINATE", 7, 106670},
	{"URINARY", 7, 42002},
	{"URINALYSIS", 10, 105148},
	{"URINALS", 7, 108149},
	{"URINAL", 6, 93607},
	{"URIN", 4, 238569},
	{"URIL", 4, 90632},
	{"URIK", 4, 101171},
	{"URIJ", 4, 206627},
	{"URII", 4, 84786},
	{"URIH", 4, 102741},
	{"URIG", 4, 80358},
	{"URIF", 4, 65636},
	{"URIEL", 5, 141721},
	{"URIDINE", 7, 129129},
	{"URID", 4, 59346},
	{"URICH", 5, 178724},
	{"URIC", 4, 107331},
	{"URIBE", 5, 105006},
	{"URIB", 4, 81851},
	{"URIAH", 5, 87680},
	{"URI", 3, 34129},
	{"URHY", 4, 188876},
	{"URHU", 4, 74586},
	{"URHO", 4, 35895},
	{"URHI", 4, 51861},
	{"URHGAN", 6, 237932},
	{"URHE", 4, 40911},
	{"URHA", 4, 39729},
	{"URH", 3, 824},
	{"URGY", 4, 83949},
	{"URGW", 4, 63940},
	{"URGV", 4, 119086},
	{"URGU", 4, 49342},
	{"URGT", 4, 66792},
	{"URGS", 4, 55977},
	{"URGR", 4, 46133},
	{"URGP", 4, 76294},
	{"URGO", 4, 40403},
	{"URGN", 4, 119224},
	{"URGM", 4, 84504},
	{"URGL", 4, 49861},
	{"URGK", 4, 174858},
	{"URGJ", 4, 184970},
	{"URGING", 6, 49195},
	{"URGI", 4, 38475},
	{"URGH", 4, 190993},
	{"URGG", 4, 102943},
	{"URGF", 4, 82567},
	{"URGES", 5, 42309},
	{"URGENTLY", 8, 608},
	{"URGENTE", 7, 222585},
	{"URGENT", 6, 33076},
	{"URGENCY", 7, 46272},
	{"URGENCE", 7, 188916},
	{"URGED", 5, 37385},
	{"URGE", 4, 7193},
	{"URGD", 4, 99477},
	{"URGC", 4, 73389},
	{"URGB", 4, 85205},
	{"URG", 3, 167784},
	{"URFW", 4, 125701},
	{"URFU", 4, 56262},
	{"URFT", 4, 113003},
	{"URFS", 4, 107954},
	{"URFR", 4, 44186},
	{"URFP", 4, 189680},
	{"URFO", 4, 42295},
	{"URFM", 4, 176768},
	{"URFL", 4, 76947},
	{"URFI", 4, 38145},
	{"URFH", 4, 223752},
	{"URFG", 4, 249443},
	{"URFF", 4, 136625},
	{"URFE", 4, 46715},
	{"URFD", 4, 250114},
	{"URFC", 4, 132929},
	{"URFB", 4, 116340},
	{"UREZ", 4, 111905},
	{"UREY", 4, 257270},
	{"UREX", 4, 52205},
	{"UREW", 4, 8740},
	{"UREV", 4, 48733},
	{"UREU", 4, 49145},
	{"URETHRITIS", 10, 169528},
	{"URETHRAL", 8, 103458},
	{"URETHRA", 7, 92183},
	{"URETHANES", 9, 221879},
	{"URETHANE", 8, 73811},
	{"URETERS", 7, 219657},
	{"URETERAL", 8, 141126},
	{"URETER", 6, 129859},
	{"URES", 4, 134790},
	{"URER", 4, 8812},
	{"UREQ", 4, 83931},
	{"UREP", 4, 32372},
	{"UREO", 4, 4441},
	{"UREN", 4, 233355},
	{"UREMIC", 6, 159068},
	{"UREMIA", 6, 194252},
	{"UREM", 4, 30209},
	{"UREL", 4, 28801},
	{"UREK", 4, 60379},
	{"UREJ", 4, 62943},
	{"UREI", 4, 241664},
	{"UREH", 4, 31486},
	{"UREG", 4, 36697},
	{"UREE", 4, 37757},
	{"URED", 4, 206349},
	{"UREC", 4, 28880},
	{"UREB", 4, 32718},
	{"UREASE", 6, 165718},
	{"UREAPLASMA", 10, 255358},
	{"UREA", 4, 59876},
	{"URDY", 4, 78647},
	{"URDW", 4, 126103},
	{"URDV", 4, 222859},
	{"URDU", 4, 55378},
	{"URDT", 4, 134811},
	{"URDS", 4, 79406},
	{"URDR", 4, 59663},
	{"URDP", 4, 216259},
	{"URDO", 4, 45495},
	{"URDN", 4, 208297},
	{"URDM", 4, 243008},
	{"URDL", 4, 51187},
	{"URDJ", 4, 187460},
	{"URDI", 4, 40494},
	{"URDH", 4, 178179},
	{"URDF", 4, 244207},
	{"URDE", 4, 6627},
	{"URDC", 4, 200181},
	{"URDB", 4, 211072},
	{"URD", 3, 151801},
	{"URCY", 4, 99588},
	{"URCU", 4, 51320},
	{"URCR", 4, 57679},
	{"URCO", 4, 9554},
	{"URCL", 4, 56372},
	{"URCK", 4, 247246},
	{"URCI", 4, 50602},
	{"URCHINS", 7, 122997},
	{"URCHIN", 6, 81755},
	{"URCD", 4, 242450},
	{"URCC", 4, 229503},
	{"URC", 3, 107580},
	{"URBZ", 4, 124297},
	{"URBY", 4, 86695},
	{"URBW", 4, 147871},
	{"URBU", 4, 42223},
	{"URBT", 4, 97149},
	{"URBS", 4, 218396},
	{"URBR", 4, 50200},
	{"URBP", 4, 232096},
	{"URBM", 4, 229986},
	{"URBL", 4, 63947},
	{"URBIS", 5, 126767},
	{"URBINO", 6, 138702},
	{"URBINA", 6, 164211},
	{"URBH", 4, 162386},
	{"URBF", 4, 216260},
	{"URBERVILLES", 11, 226060},
	{"URBC", 4, 174760},
	{"URBB", 4, 193940},
	{"URBANWORKS", 10, 116338},
	{"URBANSPECS", 10, 235183},
	{"URBANSCOOTERS", 13, 220474},
	{"URBANO", 6, 137520},
	{"URBANMALL", 9, 183445},
	{"URBANIZING", 10, 251713},
	{"URBANIZED", 9, 88725},
	{"URBANIZATION", 12, 73449},
	{"URBANITY", 8, 187084},
	{"URBANITES", 9, 225045},
	{"URBANIST", 8, 249197},
	{"URBANISM", 8, 95930},
	{"URBANISED", 9, 247119},
	{"URBANISATION", 12, 115034},
	{"URBANI", 6, 246223},
	{"URBANE", 6, 119023},
	{"URBANDALE", 9, 120129},
	{"URBANA", 6, 43516},
	{"URBAN", 5, 4762},
	{"URBAINE", 7, 236242},
	{"URBAIN", 6, 145541},
	{"URBA", 4, 8939},
	{"URB", 3, 81141},
	{"URAZ", 4, 152927},
	{"URAY", 4, 62114},
	{"URAW", 4, 69998},
	{"URAV", 4, 80094},
	{"URAU", 4, 83427},
	{"URATION", 7, 232052},
	{"URATE", 5, 219919},
	{"URAT", 4, 8845},
	{"URAS", 4, 39868},
	{"URAO", 4, 97253},
	{"URANYL", 6, 204924},
	{"URANUS", 6, 64520},
	{"URANTIA", 7, 133686},
	{"URANIUM", 7, 40668},
	{"URANIA", 6, 148406},
	{"URANDOM", 7, 212829},
	{"URAM", 4, 55837},
	{"URALS", 5, 141120},
	{"URALIC", 6, 252253},
	{"URAL", 4, 88701},
	{"URAK", 4, 87230},
	{"URAJ", 4, 120517},
	{"URAI", 4, 50192},
	{"URAH", 4, 78233},
	{"URAG", 4, 8169},
	{"URAF", 4, 70266},
	{"URAE", 4, 126276},
	{"URACIL", 6, 126862},
	{"URAC", 4, 88283},
	{"URABON", 6, 186998},
	{"URAB", 4, 39960},
	{"UR", 2, 251},
	{"UQZ", 3, 262085},
	{"UQY", 3, 262086},
	{"UQW", 3, 87120},
	{"UQV", 3, 222263},
	{"UQUO", 4, 171098},
	{"UQUI", 4, 117612},
	{"UQUE", 4, 58886},
	{"UQUB", 4, 232953},
	{"UQUA", 4, 95925},
	{"UQU", 3, 2143},
	{"UQTA", 4, 244520},
	{"UQR", 3, 106757},
	{"UQQ", 3, 120422},
	{"UQP", 3, 137028},
	{"UQM", 3, 249738},
	{"UQL", 3, 140085},
	{"UQK", 3, 230198},
	{"UQJ", 3, 168978},
	{"UQIN", 4, 211451},
	{"UQI", 3, 35788},
	{"UQG", 3, 214987},
	{"UQF", 3, 147242},
	{"UQD", 3, 83081},
	{"UQC", 3, 121446},
	{"UQB", 3, 61566},
	{"UQAM", 4, 204296},
	{"UPZ", 3, 44806},
	{"UPYT", 4, 94438},
	{"UPYS", 4, 200373},
	{"UPYO", 4, 59668},
	{"UPYM", 4, 256664},
	{"UPYI", 4, 77378},
	{"UPYE", 4, 108022},
	{"UPYA", 4, 88241},
	{"UPY", 3, 1533},
	{"UPX", 3, 165632},
	{"UPWR", 4, 166986},
	{"UPWO", 4, 67970},
	{"UPWIND", 6, 115927},
	{"UPWI", 4, 7839},
	{"UPWH", 4, 43055},
	{"UPWELLING", 9, 112752},
	{"UPWE", 4, 61510},
	{"UPWARDS", 7, 50524},
	{"UPWARDLY", 8, 123866},
	{"UPWARD", 6, 41428},
	{"UPWA", 4, 41089},
	{"UPW", 3, 244326},
	{"UPVO", 4, 128263},
	{"UPVI", 4, 90420},
	{"UPVE", 4, 108110},
	{"UPVC", 4, 105286},
	{"UPVA", 4, 141421},
	{"UPV", 3, 207716},
	{"UPUY", 4, 226236},
	{"UPUT", 4, 67289},
	{"UPUS", 4, 82815},
	{"UPUR", 4, 113567},
	{"UPUN", 4, 50467},
	{"UPUL", 4, 85919},
	{"UPUI", 4, 154306},
	{"UPUB", 4, 165998},
	{"UPU", 3, 125727},
	{"UPTY", 4, 181825},
	{"UPTW", 4, 68969},
	{"UPTV", 4, 240454},
	{"UPTURNED", 8, 131791},
	{"UPTURN", 6, 113057},
	{"UPTU", 4, 69834},
	{"UPTT", 4, 79759},
	{"UPTS", 4, 71870},
	{"UPTREND", 7, 190275},
	{"UPTR", 4, 55273},
	{"UPTP", 4, 105937},
	{"UPTOWN", 6, 51356},
	{"UPTON", 5, 57006},
	{"UPTODATE", 8, 81131},
	{"UPTO", 4, 49648},
	{"UPTN", 4, 210296},
	{"UPTM", 4, 128198},
	{"UPTL", 4, 73649},
	{"UPTIMES", 7, 260189},
	{"UPTIME", 6, 51255},
	{"UPTIGHT", 7, 100011},
	{"UPTICK", 6, 164547},
	{"UPTI", 4, 33447},
	{"UPTHU", 5, 134799},
	{"UPTH", 4, 4879},
	{"UPTG", 4, 160966},
	{"UPTF", 4, 169811},
	{"UPTEMPO", 7, 135882},
	{"UPTD", 4, 153127},
	{"UPTC", 4, 43761},
	{"UPTB", 4, 126104},
	{"UPTAKE", 6, 45381},
	{"UPTA", 4, 53203},
	{"UPSY", 4, 129180},
	{"UPSWING", 7, 115824},
	{"UPSW", 4, 50004},
	{"UPSV", 4, 178651},
	{"UPSURGE", 7, 112802},
	{"UPSU", 4, 63161},
	{"UPSTREAM", 8, 37865},
	{"UPSTATE", 7, 54266},
	{"UPSTARTS", 8, 128344},
	{"UPSTART", 7, 105986},
	{"UPSTANDING", 10, 146478},
	{"UPSTAIRS", 8, 32891},
	{"UPSTAGED", 8, 207858},
	{"UPSTAGE", 7, 177815},
	{"UPST", 4, 35782},
	{"UPSS", 4, 131543},
	{"UPSR", 4, 183810},
	{"UPSQ", 4, 152338},
	{"UPSP", 4, 59393},
	{"UPSON", 5, 135483},
	{"UPSO", 4, 37948},
	{"UPSN", 4, 105806},
	{"UPSM", 4, 73709},
	{"UPSLOPE", 7, 185763},
	{"UPSL", 4, 69808},
	{"UPSK", 4, 134516},
	{"UPSJ", 4, 205919},
	{"UPSILON", 7, 72356},
	{"UPSIDEDOWN", 10, 251721},
	{"UPSIDE", 6, 42984},
	{"UPSI", 4, 39991},
	{"UPSHUR", 6, 125093},
	{"UPSHOT", 6, 108276},
	{"UPSHAW", 6, 157754},
	{"UPSH", 4, 45877},
	{"UPSG", 4, 120876},
	{"UPSF", 4, 65125},
	{"UPSETTING", 9, 81673},
	{"UPSETTERS", 9, 254084},
	{"UPSETS", 6, 77364},
	{"UPSET", 5, 29477},
	{"UPSELL", 6, 191147},
	{"UPSE", 4, 34479},
	{"UPSCALING", 9, 203771},
	{"UPSCALE", 7, 50018},
	{"UPSB", 4, 73601},
	{"UPSALA", 6, 195246},
	{"UPS", 3, 3975},
	{"UPRY", 4, 258894},
	{"UPRU", 4, 91699},
	{"UPRS", 4, 216861},
	{"UPROOTING", 9, 153433},
	{"UPROOTED", 8, 106261},
	{"UPROOT", 6, 148426},
	{"UPROMISE", 8, 162971},
	{"UPROARIOUS", 10, 215777},
	{"UPROARCOM", 9, 233946},
	{"UPROAR", 6, 81824},
	{"UPRO", 4, 45805},
	{"UPRIVER", 7, 140749},
	{"UPRISINGS", 9, 129752},
	{"UPRISING", 8, 60433},
	{"UPRIMA", 6, 149474},
	{"UPRIGHTS", 8, 115300},
	{"UPRIGHTNESS", 11, 206891},
	{"UPRIGHT", 7, 39123},
	{"UPRI", 4, 43174},
	{"UPREGULATION", 12, 143493},
	{"UPREGULATED", 11, 155345},
	{"UPRE", 4, 30439},
	{"UPRATED", 7, 197248},
	{"UPRAISED", 8, 232524},
	{"UPRA", 4, 62268},
	{"UPR", 3, 112653},
	{"UPQU", 4, 68429},
	{"UPQB", 4, 254602},
	{"UPQ", 3, 4599},
	{"UPPU", 4, 96101},
	{"UPPSALA", 7, 62899},
	{"UPPS", 4, 111318},
	{"UPPR", 4, 43077},
	{"UPPORT", 6, 172828},
	{"UPPO", 4, 2162},
	{"UPPM", 4, 165999},
	{"UPPL", 4, 6739},
	{"UPPITY", 6, 139922},
	{"UPPINGHAM", 9, 191566},
	{"UPPING", 6, 111189},
	{"UPPI", 4, 67267},
	{"UPPH", 4, 118948},
	{"UPPERS", 6, 74417},
	{"UPPERPARTS", 10, 191493},
	{"UPPERMOST", 9, 98475},
	{"UPPERCUT", 8, 149560},
	{"UPPERCLASSMEN", 13, 184824},
	{"UPPERCLASS", 10, 214398},
	{"UPPERCASE", 9, 68554},
	{"UPPER", 5, 6067},
	{"UPPED", 5, 99099},
	{"UPPE", 4, 28057},
	{"UPPDATERAD", 10, 222524},
	{"UPPAL", 5, 236942},
	{"UPPA", 4, 60508},
	{"UPP", 3, 98300},
	{"UPOW", 4, 144294},
	{"UPOV", 4, 226565},
	{"UPOU", 4, 69362},
	{"UPOT", 4, 137287},
	{"UPOS", 4, 93033},
	{"UPORTAL", 7, 167231},
	{"UPOR", 4, 53758},
	{"UPOP", 4, 91160},
	{"UPOO", 4, 250115},
	{"UPON", 4, 2175},
	{"UPOL", 4, 83979},
	{"UPOI", 4, 114589},
	{"UPOF", 4, 8539},
	{"UPOE", 4, 212000},
	{"UPOC", 4, 186073},
	{"UPOB", 4, 181956},
	{"UPNU", 4, 157450},
	{"UPNP", 4, 107308},
	{"UPNO", 4, 64236},
	{"UPNI", 4, 115233},
	{"UPNE", 4, 61128},
	{"UPNA", 4, 102880},
	{"UPMYSTREET", 10, 101899},
	{"UPMY", 4, 80507},
	{"UPMU", 4, 97345},
	{"UPMR", 4, 234575},
	{"UPMOST", 6, 252444},
	{"UPMO", 4, 56058},
	{"UPMINSTER", 9, 137808},
	{"UPMI", 4, 78301},
	{"UPME", 4, 61876},
	{"UPMC", 4, 116296},
	{"UPMARKET", 8, 111915},
	{"UPMANN", 6, 186179},
	{"UPMA", 4, 51599},
	{"UPM", 3, 124084},
	{"UPLU", 4, 143307},
	{"UPLT", 4, 179556},
	{"UPLOADS", 7, 41968},
	{"UPLOADING", 9, 43343},
	{"UPLOADERS", 9, 157005},
	{"UPLOADER", 8, 80742},
	{"UPLOADED", 8, 30462},
	{"UPLOAD", 6, 6286},
	{"UPLO", 4, 141963},
	{"UPLL", 4, 195404},
	{"UPLINKS", 7, 180810},
	{"UPLINKFAST", 10, 231660},
	{"UPLINKED", 8, 77362},
	{"UPLINK", 6, 65885},
	{"UPLINE", 6, 211718},
	{"UPLIFTS", 7, 221353},
	{"UPLIFTMENT", 10, 189332},
	{"UPLIFTING", 9, 53804},
	{"UPLIFTED", 8, 79410},
	{"UPLIFT", 6, 68240},
	{"UPLI", 4, 43162},
	{"UPLEVEL", 7, 254492},
	{"UPLE", 4, 5975},
	{"UPLANDS", 7, 89864},
	{"UPLANDER", 8, 152772},
	{"UPLAND", 6, 53187},
	{"UPLA", 4, 43695},
	{"UPL", 3, 160750},
	{"UPKO", 4, 226722},
	{"UPKN", 4, 122385},
	{"UPKI", 4, 95518},
	{"UPKEEP", 6, 79094},
	{"UPKE", 4, 86026},
	{"UPKA", 4, 175823},
	{"UPJU", 4, 75380},
	{"UPJOHN", 6, 124943},
	{"UPJO", 4, 108087},
	{"UPJE", 4, 181126},
	{"UPJA", 4, 142193},
	{"UPIW", 4, 159886},
	{"UPIV", 4, 212620},
	{"UPIT", 4, 47691},
	{"UPIS", 4, 45038},
	{"UPIR", 4, 185488},
	{"UPIP", 4, 255285},
	{"UPINGTON", 8, 177214},
	{"UPING", 5, 194273},
	{"UPIM", 4, 113375},
	{"UPIL", 4, 47667},
	{"UPIK", 4, 211073},
	{"UPII", 4, 172482},
	{"UPIH", 4, 231571},
	{"UPIF", 4, 100387},
	{"UPIE", 4, 38713},
	{"UPID", 4, 40083},
	{"UPIA", 4, 115264},
	{"UPHY", 4, 261949},
	{"UPHU", 4, 114861},
	{"UPHR", 4, 143668},
	{"UPHPU", 5, 228776},
	{"UPHOLSTERY", 10, 44781},
	{"UPHOLSTERING", 12, 261701},
	{"UPHOLSTERERS", 12, 133313},
	{"UPHOLSTERER", 11, 220905},
	{"UPHOLSTERED", 11, 64743},
	{"UPHOLLAND", 9, 208090},
	{"UPHOLDS", 7, 85666},
	{"UPHOLDING", 9, 74179},
	{"UPHOLD", 6, 55992},
	{"UPHO", 4, 48650},
	{"UPHILL", 6, 65433},
	{"UPHI", 4, 39959},
	{"UPHELD", 6, 53126},
	{"UPHEAVALS", 9, 131492},
	{"UPHEAVAL", 8, 85350},
	{"UPHE", 4, 41033},
	{"UPHAM", 5, 148122},
	{"UPHA", 4, 48180},
	{"UPGU", 4, 130695},
	{"UPGRADING", 9, 35771},
	{"UPGRADETWIKI", 12, 261153},
	{"UPGRADES", 8, 28962},
	{"UPGRADER", 8, 215233},
	{"UPGRADED", 8, 36942},
	{"UPGRADEABLE", 11, 98815},
	{"UPGRADE", 7, 3271},
	{"UPGRADATION", 11, 178816},
	{"UPGRADABLE", 10, 127597},
	{"UPGO", 4, 77984},
	{"UPGL", 4, 197112},
	{"UPGI", 4, 121461},
	{"UPGE", 4, 87933},
	{"UPGA", 4, 76617},
	{"UPG", 3, 74283},
	{"UPFU", 4, 119904},
	{"UPFRONT", 7, 59617},
	{"UPFR", 4, 39033},
	{"UPFO", 4, 29897},
	{"UPFL", 4, 129454},
	{"UPFIELD", 7, 243458},
	{"UPFI", 4, 48445},
	{"UPFE", 4, 90671},
	{"UPFA", 4, 78706},
	{"UPF", 3, 132577},
	{"UPEX", 4, 85887},
	{"UPEW", 4, 141282},
	{"UPEV", 4, 66055},
	{"UPEU", 4, 208115},
	{"UPET", 4, 109097},
	{"UPES", 4, 81269},
	{"UPER", 4, 240818},
	{"UPEP", 4, 176655},
	{"UPEO", 4, 76465},
	{"UPENN", 5, 177191},
	{"UPENDED", 7, 226138},
	{"UPEN", 4, 68504},
	{"UPEM", 4, 108596},
	{"UPEL", 4, 101199},
	{"UPEI", 4, 126665},
	{"UPEH", 4, 196611},
	{"UPEG", 4, 256665},
	{"UPEF", 4, 107887},
	{"UPEE", 4, 79772},
	{"UPED", 4, 261779},
	{"UPEC", 4, 149863},
	{"UPEB", 4, 208116},
	{"UPEA", 4, 68623},
	{"UPDY", 4, 224870},
	{"UPDU", 4, 77845},
	{"UPDT", 4, 140972},
	{"UPDRAFT", 7, 193756},
	{"UPDR", 4, 89607},
	{"UPDOWN", 6, 199573},
	{"UPDOS", 5, 169108},
	{"UPDO", 4, 217642},
	{"UPDIKE", 6, 109225},
	{"UPDI", 4, 71620},
	{"UPDE", 4, 58010},
	{"UPDATING", 8, 30120},
	{"UPDATES", 7, 2673},
	{"UPDATERS", 8, 195608},
	{"UPDATER", 7, 74862},
	{"UPDATED", 7, 1451},
	{"UPDATEABLE", 10, 185852},
	{"UPDATE", 6, 35286},
	{"UPDATABLE", 9, 181277},
	{"UPDAT", 5, 206776},
	{"UPDA", 4, 231633},
	{"UPD", 3, 74027},
	{"UPCU", 4, 137730},
	{"UPCR", 4, 95996},
	{"UPCOUNTRY", 9, 185281},
	{"UPCONVERT", 9, 259950},
	{"UPCONVERSION", 12, 214876},
	{"UPCOMMING", 9, 180838},
	{"UPCOMING", 8, 5281},
	{"UPCLOSE", 7, 191469},
	{"UPCL", 4, 74200},
	{"UPCI", 4, 241111},
	{"UPCHURCH", 8, 145878},
	{"UPCH", 4, 59872},
	{"UPCF", 4, 235487},
	{"UPCE", 4, 104754},
	{"UPCARD", 6, 118578},
	{"UPCA", 4, 46439},
	{"UPC", 3, 34959},
	{"UPBY", 4, 41481},
	{"UPBU", 4, 52534},
	{"UPBRINGING", 10, 78335},
	{"UPBR", 4, 69112},
	{"UPBO", 4, 72607},
	{"UPBI", 4, 85335},
	{"UPBEAT", 6, 57891},
	{"UPBE", 4, 41534},
	{"UPBA", 4, 68282},
	{"UPB", 3, 154792},
	{"UPAZILA", 7, 206894},
	{"UPAZ", 4, 210484},
	{"UPAY", 4, 72716},
	{"UPAW", 4, 84147},
	{"UPAV", 4, 118949},
	{"UPAU", 4, 118722},
	{"UPAT", 4, 31363},
	{"UPAQ", 4, 227206},
	{"UPAP", 4, 58912},
	{"UPAO", 4, 203810},
	{"UPANISHADS", 10, 140080},
	{"UPANISHAD", 9, 184470},
	{"UPAN", 4, 6615},
	{"UPAMANYU", 8, 255395},
	{"UPAM", 4, 67837},
	{"UPAL", 4, 43400},
	{"UPAK", 4, 117743},
	{"UPAJ", 4, 180876},
	{"UPAI", 4, 93141},
	{"UPAH", 4, 84511},
	{"UPAG", 4, 44167},
	{"UPAF", 4, 51808},
	{"UPAE", 4, 197255},
	{"UPADHYAY", 8, 258495},
	{"UPAD", 4, 69615},
	{"UPAB", 4, 54333},
	{"UPAA", 4, 123326},
	{"UP", 2, 758},
	{"UOZ", 3, 34967},
	{"UOYU", 4, 254226},
	{"UOYS", 4, 164153},
	{"UOYO", 4, 144409},
	{"UOYE", 4, 120455},
	{"UOYA", 4, 85155},
	{"UOWO", 4, 170704},
	{"UOWN", 4, 109298},
	{"UOWI", 4, 127879},
	{"UOWH", 4, 110470},
	{"UOWE", 4, 75240},
	{"UOWA", 4, 135910},
	{"UOVO", 4, 190923},
	{"UOVI", 4, 255648},
	{"UOVE", 4, 56722},
	{"UOV", 3, 2721},
	{"UOUT", 4, 76832},
	{"UOUSE", 5, 259558},
	{"UOUS", 4, 236565},
	{"UOUR", 4, 205193},
	{"UOUN", 4, 196003},
	{"UOUG", 4, 178300},
	{"UOU", 3, 994},
	{"UOTY", 4, 228716},
	{"UOTW", 4, 89645},
	{"UOTU", 4, 168889},
	{"UOTR", 4, 98429},
	{"UOTP", 4, 120993},
	{"UOTM", 4, 107888},
	{"UOTL", 4, 113039},
	{"UOTK", 4, 108354},
	{"UOTJ", 4, 200374},
	{"UOTG", 4, 97982},
	{"UOTF", 4, 122099},
	{"UOTD", 4, 124656},
	{"UOTC", 4, 107391},
	{"UOTB", 4, 83135},
	{"UOSY", 4, 159178},
	{"UOSW", 4, 69302},
	{"UOSV", 4, 117229},
	{"UOSU", 4, 107931},
	{"UOSR", 4, 71851},
	{"UOSQ", 4, 217484},
	{"UOSP", 4, 61575},
	{"UOSM", 4, 69345},
	{"UOSL", 4, 69454},
	{"UOSK", 4, 156624},
	{"UOSJ", 4, 108938},
	{"UOSG", 4, 73456},
	{"UOSF", 4, 66524},
	{"UOSD", 4, 70020},
	{"UOSC", 4, 60613},
	{"UOSB", 4, 63048},
	{"UORY", 4, 153716},
	{"UORW", 4, 176370},
	{"UORU", 4, 107679},
	{"UORT", 4, 122534},
	{"UORS", 4, 85045},
	{"UORP", 4, 209892},
	{"UORO", 4, 101567},
	{"UORN", 4, 208117},
	{"UORM", 4, 171477},
	{"UORL", 4, 126677},
	{"UORI", 4, 79398},
	{"UORH", 4, 218641},
	{"UORG", 4, 162033},
	{"UORF", 4, 230586},
	{"UORE", 4, 49335},
	{"UORD", 4, 130309},
	{"UORC", 4, 138639},
	{"UORB", 4, 154061},
	{"UORA", 4, 97632},
	{"UOQU", 4, 258536},
	{"UOPT", 4, 172263},
	{"UOPR", 4, 131772},
	{"UOPP", 4, 227465},
	{"UOPO", 4, 150267},
	{"UOPL", 4, 216453},
	{"UOPI", 4, 236079},
	{"UOPE", 4, 96736},
	{"UOPA", 4, 176461},
	{"UOOU", 4, 208501},
	{"UOOR", 4, 187461},
	{"UOOF", 4, 108884},
	{"UONY", 4, 198858},
	{"UONW", 4, 236344},
	{"UONM", 4, 191222},
	{"UONL", 4, 79415},
	{"UONJ", 4, 227466},
	{"UONF", 4, 233507},
	{"UOND", 4, 223299},
	{"UONC", 4, 139993},
	{"UOMY", 4, 218642},
	{"UOMU", 4, 244521},
	{"UOMT", 4, 193779},
	{"UOMS", 4, 152529},
	{"UOMR", 4, 248492},
	{"UOMP", 4, 251789},
	{"UOMO", 4, 86264},
	{"UOMN", 4, 137135},
	{"UOMINI", 6, 188670},
	{"UOMI", 4, 100089},
	{"UOMH", 4, 253542},
	{"UOMG", 4, 172264},
	{"UOME", 4, 255620},
	{"UOMA", 4, 99350},
	{"UOLU", 4, 211813},
	{"UOLO", 4, 113475},
	{"UOLL", 4, 72292},
	{"UOLI", 4, 151783},
	{"UOLE", 4, 150268},
	{"UOLD", 4, 176769},
	{"UOLA", 4, 152014},
	{"UOKI", 4, 237350},
	{"UOKA", 4, 114265},
	{"UOJU", 4, 232655},
	{"UOJI", 4, 200738},
	{"UOJ", 3, 33928},
	{"UOIW", 4, 157045},
	{"UOIR", 4, 140370},
	{"UOIL", 4, 224197},
	{"UOIF", 4, 170811},
	{"UOID", 4, 182869},
	{"UOI", 3, 1922},
	{"UOGU", 4, 210881},
	{"UOGR", 4, 201404},
	{"UOGO", 4, 178522},
	{"UOGE", 4, 254227},
	{"UOGA", 4, 249444},
	{"UOFW", 4, 226237},
	{"UOFU", 4, 208502},
	{"UOFT", 4, 136072},
	{"UOFR", 4, 131697},
	{"UOFP", 4, 155640},
	{"UOFO", 4, 127880},
	{"UOFN", 4, 203811},
	{"UOFM", 4, 207698},
	{"UOFL", 4, 173326},
	{"UOFI", 4, 93597},
	{"UOFH", 4, 195572},
	{"UOFG", 4, 236080},
	{"UOFF", 4, 73161},
	{"UOFE", 4, 130004},
	{"UOFD", 4, 233229},
	{"UOFC", 4, 218031},
	{"UOFB", 4, 161031},
	{"UOFA", 4, 158391},
	{"UOEX", 4, 227207},
	{"UOEV", 4, 210103},
	{"UODS", 4, 225321},
	{"UODR", 4, 211636},
	{"UODO", 4, 155718},
	{"UODL", 4, 176019},
	{"UODI", 4, 171288},
	{"UODH", 4, 229504},
	{"UODE", 4, 115677},
	{"UODB", 4, 158588},
	{"UODA", 4, 130511},
	{"UOD", 3, 3428},
	{"UOCR", 4, 240455},
	{"UOCO", 4, 102822},
	{"UOCL", 4, 207547},
	{"UOCH", 4, 152258},
	{"UOCC", 4, 253891},
	{"UOCA", 4, 142399},
	{"UOBV", 4, 155641},
	{"UOBU", 4, 141158},
	{"UOBR", 4, 182755},
	{"UOBO", 4, 204480},
	{"UOBI", 4, 201225},
	{"UOBE", 4, 143363},
	{"UOBA", 4, 119366},
	{"UOAR", 4, 176248},
	{"UOAL", 4, 144410},
	{"UOAC", 4, 221506},
	{"UNZO", 4, 248493},
	{"UNZIPPING", 9, 139481},
	{"UNZIPPED", 8, 94405},
	{"UNZIP", 5, 61468},
	{"UNZI", 4, 122813},
	{"UNZENSIERT", 10, 122253},
	{"UNZE", 4, 151468},
	{"UNZA", 4, 170705},
	{"UNYU", 4, 217950},
	{"UNYS", 4, 229230},
	{"UNYO", 4, 94300},
	{"UNYIELDING", 10, 130609},
	{"UNYI", 4, 127453},
	{"UNYE", 4, 149505},
	{"UNYA", 4, 82713},
	{"UNXI", 4, 230841},
	{"UNWRITTEN", 9, 74357},
	{"UNWRAPS", 7, 238381},
	{"UNWRAPPING", 10, 165860},
	{"UNWRAPPED", 9, 88074},
	{"UNWRAP", 6, 36534},
	{"UNWR", 4, 101643},
	{"UNWOUND", 7, 160232},
	{"UNWORTHY", 8, 79762},
	{"UNWORTHINESS", 12, 224338},
	{"UNWORN", 6, 150979},
	{"UNWORKABLE", 10, 114564},
	{"UNWO", 4, 74641},
	{"UNWITTINGLY", 11, 87374},
	{"UNWITTING", 9, 123511},
	{"UNWISELY", 8, 195778},
	{"UNWISE", 6, 85426},
	{"UNWIRED", 7, 73453},
	{"UNWINNABLE", 10, 234733},
	{"UNWINDS", 7, 250191},
	{"UNWINDING", 9, 120121},
	{"UNWIND", 6, 60904},
	{"UNWIN", 5, 86995},
	{"UNWILLINGNESS", 13, 83300},
	{"UNWILLINGLY", 11, 135475},
	{"UNWILLING", 9, 51421},
	{"UNWIELDY", 8, 106348},
	{"UNWI", 4, 40629},
	{"UNWHOLESOME", 11, 161412},
	{"UNWH", 4, 61956},
	{"UNWELL", 6, 111196},
	{"UNWELCOME", 9, 77351},
	{"UNWEIGHTED", 10, 92005},
	{"UNWED", 5, 143033},
	{"UNWE", 4, 70389},
	{"UNWAVERING", 10, 97735},
	{"UNWATCHABLE", 11, 229041},
	{"UNWASHED", 8, 117888},
	{"UNWARY", 6, 139197},
	{"UNWARRANTED", 11, 78051},
	{"UNWANTED", 8, 37487},
	{"UNWAITH", 7, 253699},
	{"UNWA", 4, 40278},
	{"UNW", 3, 909},
	{"UNVOICED", 8, 257249},
	{"UNVO", 4, 223533},
	{"UNVIEWED", 8, 241073},
	{"UNVIABLE", 8, 220906},
	{"UNVI", 4, 110653},
	{"UNVESTED", 8, 230100},
	{"UNVERSITY", 9, 173219},
	{"UNVERIFIED", 10, 86557},
	{"UNVERIFIABLE", 12, 194268},
	{"UNVENTED", 8, 231064},
	{"UNVEILS", 7, 48513},
	{"UNVEILING", 9, 75295},
	{"UNVEILED", 8, 46966},
	{"UNVEIL", 6, 69442},
	{"UNVE", 4, 52879},
	{"UNVARNISHED", 11, 183335},
	{"UNVACCINATED", 12, 205436},
	{"UNVA", 4, 109648},
	{"UNUTTERABLE", 11, 179962},
	{"UNUTILIZED", 10, 239746},
	{"UNUT", 4, 203117},
	{"UNUSUALLY", 9, 50899},
	{"UNUSUAL", 7, 6446},
	{"UNUSED", 6, 36664},
	{"UNUSAL", 6, 258293},
	{"UNUSABLE", 8, 74493},
	{"UNUR", 4, 237974},
	{"UNUP", 4, 73010},
	{"UNUN", 4, 88071},
	{"UNUMPROVIDENT", 13, 219149},
	{"UNUM", 4, 110875},
	{"UNUC", 4, 125789},
	{"UNTYPED", 7, 169149},
	{"UNTYING", 7, 204963},
	{"UNTY", 4, 3096},
	{"UNTW", 4, 48758},
	{"UNTV", 4, 86746},
	{"UNTURNED", 8, 144350},
	{"UNTUK", 5, 97839},
	{"UNTU", 4, 63933},
	{"UNTRUTHS", 8, 192172},
	{"UNTRUTHFUL", 10, 188236},
	{"UNTRUTH", 7, 170236},
	{"UNTRUSTWORTHY", 13, 137881},
	{"UNTRUSTED", 9, 102473},
	{"UNTRUE", 6, 67490},
	{"UNTROUBLED", 10, 148154},
	{"UNTRIMMED", 9, 251867},
	{"UNTRIED", 7, 154421},
	{"UNTREATED", 9, 54791},
	{"UNTREATABLE", 11, 240276},
	{"UNTRANSLATED", 12, 68731},
	{"UNTRANSFORMED", 13, 151879},
	{"UNTRAINED", 9, 93379},
	{"UNTRADITIONAL", 13, 254102},
	{"UNTRACKED", 9, 241684},
	{"UNTRACEABLE", 11, 195386},
	{"UNTR", 4, 2237},
	{"UNTPDC", 6, 215212},
	{"UNTP", 4, 60971},
	{"UNTOWARD", 8, 133368},
	{"UNTOUCHED", 9, 61838},
	{"UNTOUCHABLES", 12, 108788},
	{"UNTOUCHABLE", 11, 98530},
	{"UNTOLD", 6, 58753},
	{"UNTO", 4, 29165},
	{"UNTM", 4, 62642},
	{"UNTL", 4, 44388},
	{"UNTJ", 4, 111063},
	{"UNTITLED", 8, 28395},
	{"UNTIRING", 8, 174093},
	{"UNTIMELY", 8, 77319},
	{"UNTIMED", 7, 192038},
	{"UNTILL", 6, 70410},
	{"UNTIL", 5, 1219},
	{"UNTIED", 6, 102931},
	{"UNTIE", 5, 133836},
	{"UNTIDY", 6, 132220},
	{"UNTHREADED", 10, 79349},
	{"UNTHINKING", 10, 157767},
	{"UNTHINKABLE", 11, 77953},
	{"UNTH", 4, 32462},
	{"UNTG", 4, 89908},
	{"UNTF", 4, 43909},
	{"UNTETHERED", 10, 197786},
	{"UNTESTED", 8, 67053},
	{"UNTERTITEL", 10, 137207},
	{"UNTERSUCHUNGEN", 14, 153267},
	{"UNTERSUCHUNG", 12, 174923},
	{"UNTERRICHT", 10, 216004},
	{"UNTERNEHMENSINFO", 16, 244631},
	{"UNTERNEHMEN", 11, 90464},
	{"UNTERMINATED", 12, 196327},
	{"UNTERKUNFT", 10, 144339},
	{"UNTERHALTUNG", 12, 136479},
	{"UNTERGANG", 9, 163756},
	{"UNTER", 5, 65495},
	{"UNTENABLE", 9, 98418},
	{"UNTEN", 5, 190408},
	{"UNTE", 4, 3259},
	{"UNTC", 4, 58634},
	{"UNTB", 4, 56184},
	{"UNTAXED", 7, 158492},
	{"UNTARRING", 9, 189476},
	{"UNTARRED", 8, 255831},
	{"UNTAR", 5, 164760},
	{"UNTAPPED", 8, 86563},
	{"UNTANGLING", 10, 151819},
	{"UNTANGLED", 9, 235404},
	{"UNTANGLE", 8, 158301},
	{"UNTAMED", 7, 97114},
	{"UNTALENTED", 10, 255844},
	{"UNTAINTED", 9, 175601},
	{"UNTAINT", 7, 259147},
	{"UNTAGGED", 8, 127893},
	{"UNTAET", 6, 206032},
	{"UNTA", 4, 5095},
	{"UNSYSTEMATIC", 12, 260433},
	{"UNSYMPATHETIC", 13, 139563},
	{"UNSY", 4, 113568},
	{"UNSWORTH", 8, 150714},
	{"UNSWERVING", 10, 199803},
	{"UNSWEETENED", 11, 115863},
	{"UNSW", 4, 71224},
	{"UNSV", 4, 177266},
	{"UNSUSTAINABLE", 13, 78343},
	{"UNSUSPECTING", 12, 73570},
	{"UNSUSPECTED", 11, 147026},
	{"UNSURPRISINGLY", 14, 104715},
	{"UNSURPRISING", 12, 152879},
	{"UNSURPASSED", 11, 68526},
	{"UNSURE", 6, 41767},
	{"UNSUPPORTED", 11, 50463},
	{"UNSUPPORTABLE", 13, 244894},
	{"UNSUPERVISED", 12, 82832},
	{"UNSUNG", 6, 87728},
	{"UNSULLIED", 9, 240358},
	{"UNSUITED", 8, 151149},
	{"UNSUITABLE", 10, 59431},
	{"UNSUITABILITY", 13, 244161},
	{"UNSUCCESSFULLY", 14, 81162},
	{"UNSUCCESSFUL", 12, 47707},
	{"UNSUBSTITUTED", 13, 227451},
	{"UNSUBSTANTIATED", 15, 95165},
	{"UNSUBSIDIZED", 12, 110778},
	{"UNSUBSCRIPTION", 14, 133791},
	{"UNSUBSCRIBING", 13, 95397},
	{"UNSUBSCRIBED", 12, 143186},
	{"UNSUBSCRIBE", 11, 6431},
	{"UNSUBSC", 7, 239227},
	{"UNSUB", 5, 114559},
	{"UNSU", 4, 147841},
	{"UNSTYLED", 8, 121082},
	{"UNSTUCK", 7, 161327},
	{"UNSTRUNG", 8, 85395},
	{"UNSTRUCTURED", 12, 68228},
	{"UNSTRIPPED", 10, 260988},
	{"UNSTRETCHED", 11, 228510},
	{"UNSTRESSED", 10, 182932},
	{"UNSTOPPABLE", 11, 81766},
	{"UNSTINTING", 10, 257553},
	{"UNSTIMULATED", 12, 220954},
	{"UNSTEADY", 8, 94064},
	{"UNSTEADINESS", 12, 239149},
	{"UNSTEADILY", 10, 239147},
	{"UNSTATED", 8, 152711},
	{"UNSTAINED", 9, 231150},
	{"UNSTABLE", 8, 37374},
	{"UNSR", 4, 88736},
	{"UNSPUN", 6, 215784},
	{"UNSPORTSMANLIKE", 15, 164281},
	{"UNSPOKEN", 8, 84493},
	{"UNSPOILT", 8, 107686},
	{"UNSPOILED", 9, 98794},
	{"UNSPENT", 7, 137270},
	{"UNSPECTACULAR", 13, 219846},
	{"UNSPECIFIED", 11, 41583},
	{"UNSPECIFIC", 10, 204185},
	{"UNSPEC", 6, 179167},
	{"UNSPEAKABLY", 11, 207897},
	{"UNSPEAKABLE", 11, 88395},
	{"UNSP", 4, 224130},
	{"UNSOUND", 7, 99781},
	{"UNSORTED", 8, 81436},
	{"UNSOPHISTICATED", 15, 131829},
	{"UNSOLVED", 8, 74563},
	{"UNSOLVABLE", 10, 170972},
	{"UNSOLICITED", 11, 46958},
	{"UNSOLD", 6, 103386},
	{"UNSOCIABLE", 10, 243295},
	{"UNSL", 4, 80263},
	{"UNSKILLED", 9, 74845},
	{"UNSK", 4, 107741},
	{"UNSJ", 4, 168993},
	{"UNSINKABLE", 10, 161906},
	{"UNSIGNED", 8, 29881},
	{"UNSIGHTLY", 9, 94997},
	{"UNSHIFT", 7, 236907},
	{"UNSHIELDED", 10, 127157},
	{"UNSHAVEN", 8, 88208},
	{"UNSHAVED", 8, 84972},
	{"UNSHARP", 7, 183877},
	{"UNSHARED", 8, 218377},
	{"UNSHAKEN", 8, 233362},
	{"UNSHAKEABLE", 11, 232912},
	{"UNSHAKABLE", 10, 168048},
	{"UNSG", 4, 120942},
	{"UNSF", 4, 51995},
	{"UNSETTLING", 10, 83112},
	{"UNSETTLED", 9, 82381},
	{"UNSETTLE", 8, 233657},
	{"UNSET", 5, 61003},
	{"UNSERVICEABLE", 13, 197637},
	{"UNSERVED", 8, 161799},
	{"UNSERIALIZE", 11, 231230},
	{"UNSERER", 7, 112146},
	{"UNSEREN", 7, 174535},
	{"UNSEREM", 7, 181782},
	{"UNSERE", 6, 76601},
	{"UNSER", 5, 93203},
	{"UNSENTIMENTAL", 13, 226316},
	{"UNSENT", 6, 195173},
	{"UNSENSORED", 10, 252277},
	{"UNSELFISHNESS", 13, 218602},
	{"UNSELFISHLY", 11, 208452},
	{"UNSELFISH", 9, 104642},
	{"UNSELECTED", 10, 136204},
	{"UNSELECT", 8, 127941},
	{"UNSEEN", 6, 50886},
	{"UNSEEMLY", 8, 124466},
	{"UNSEEDED", 8, 170907},
	{"UNSECURED", 9, 37387},
	{"UNSECURE", 8, 113960},
	{"UNSEATED", 8, 249578},
	{"UNSEAT", 6, 144052},
	{"UNSEASONABLY", 12, 169733},
	{"UNSEALED", 8, 110671},
	{"UNSE", 4, 30465},
	{"UNSCRUPULOUS", 12, 82370},
	{"UNSCRIPTED", 10, 134627},
	{"UNSCREWING", 10, 167546},
	{"UNSCREWED", 9, 220359},
	{"UNSCREW", 7, 136813},
	{"UNSCREENED", 10, 209977},
	{"UNSCRAMBLE", 10, 176522},
	{"UNSCR", 5, 242893},
	{"UNSCORED", 8, 233489},
	{"UNSCOM", 6, 131546},
	{"UNSCIENTIFIC", 12, 117941},
	{"UNSCHOOLING", 11, 183290},
	{"UNSCHOOLED", 10, 238928},
	{"UNSCHEDULED", 11, 82185},
	{"UNSCENTED", 9, 95286},
	{"UNSCATHED", 9, 107799},
	{"UNSCALED", 8, 177337},
	{"UNSC", 4, 136582},
	{"UNSB", 4, 63483},
	{"UNSAVOURY", 9, 212981},
	{"UNSAVORY", 8, 128520},
	{"UNSAVED", 7, 125070},
	{"UNSATURATED", 11, 75899},
	{"UNSATISFYING", 12, 147335},
	{"UNSATISFIED", 11, 83798},
	{"UNSATISFIABLE", 13, 207111},
	{"UNSATISFACTORY", 14, 52987},
	{"UNSAT", 5, 156204},
	{"UNSANITARY", 10, 150629},
	{"UNSANCTIONED", 12, 225029},
	{"UNSALTED", 8, 109345},
	{"UNSAID", 6, 133808},
	{"UNSAFE", 6, 47339},
	{"UNRWA", 5, 129387},
	{"UNRW", 4, 248159},
	{"UNRULY", 6, 80860},
	{"UNRUH", 5, 142583},
	{"UNRUFFLED", 9, 227088},
	{"UNRU", 4, 78713},
	{"UNROUNDED", 9, 220901},
	{"UNROLLING", 9, 164496},
	{"UNROLLED", 8, 169412},
	{"UNROLL", 6, 149814},
	{"UNRO", 4, 70330},
	{"UNRIVALLED", 10, 84373},
	{"UNRIVALED", 9, 68040},
	{"UNRISD", 6, 224808},
	{"UNRIPE", 6, 184321},
	{"UNRIGHTEOUSNESS", 15, 153566},
	{"UNRIGHTEOUS", 11, 165092},
	{"UNRI", 4, 61756},
	{"UNRHYW", 6, 91632},
	{"UNREVISED", 9, 186365},
	{"UNREVIEWED", 10, 183718},
	{"UNREVEALED", 10, 223683},
	{"UNREV", 5, 225676},
	{"UNRESTRICTED", 12, 47868},
	{"UNRESTRAINED", 12, 103905},
	{"UNRESTORED", 10, 236199},
	{"UNREST", 6, 58531},
	{"UNRESPONSIVENESS", 16, 237231},
	{"UNRESPONSIVE", 12, 91833},
	{"UNRESOLVED", 10, 42836},
	{"UNRESOLVABLE", 12, 255005},
	{"UNRESERVEDLY", 12, 161817},
	{"UNRESERVED", 10, 120261},
	{"UNRESECTABLE", 12, 188180},
	{"UNREQUITED", 10, 122721},
	{"UNREPRESENTED", 13, 138519},
	{"UNREPRESENTATIVE", 16, 180704},
	{"UNREPORTED", 10, 84905},
	{"UNREPENTANT", 11, 125391},
	{"UNREMITTING", 11, 151523},
	{"UNREMARKABLE", 12, 111800},
	{"UNRELIEVED", 10, 250174},
	{"UNRELIABLE", 10, 55112},
	{"UNRELIABILITY", 13, 139830},
	{"UNRELENTING", 11, 93648},
	{"UNRELEASED", 10, 60538},
	{"UNRELATED", 9, 42865},
	{"UNREINFORCED", 12, 248411},
	{"UNREIMBURSED", 12, 201007},
	{"UNREGULATED", 11, 72525},
	{"UNREGISTERED", 12, 42521},
	{"UNREGISTER", 10, 117571},
	{"UNREGENERATE", 12, 244327},
	{"UNREG", 5, 211426},
	{"UNREFINED", 9, 145138},
	{"UNREFERENCED", 12, 245974},
	{"UNREDUCED", 9, 247495},
	{"UNRECOVERED", 11, 256431},
	{"UNRECOVERABLE", 13, 136973},
	{"UNRECORDED", 10, 125180},
	{"UNRECOGNIZED", 12, 70064},
	{"UNRECOGNIZABLE", 14, 139881},
	{"UNRECOGNISED", 12, 149169},
	{"UNREASONABLY", 12, 74568},
	{"UNREASONABLE", 12, 46067},
	{"UNREASON", 8, 215332},
	{"UNREALSCRIPT", 12, 247054},
	{"UNREALIZED", 10, 75522},
	{"UNREALITY", 9, 156220},
	{"UNREALISTICALLY", 15, 166298},
	{"UNREALISTIC", 11, 56818},
	{"UNREALISED", 10, 149438},
	{"UNREAL", 6, 41589},
	{"UNREADY", 7, 251401},
	{"UNREADABLE", 10, 81510},
	{"UNREAD", 6, 45235},
	{"UNREACTED", 9, 241736},
	{"UNREACHED", 9, 167978},
	{"UNREACHABLE", 11, 75245},
	{"UNRE", 4, 250982},
	{"UNRAVELS", 8, 153970},
	{"UNRAVELLING", 11, 145379},
	{"UNRAVELLED", 10, 196707},
	{"UNRAVELING", 10, 100086},
	{"UNRAVELED", 9, 152645},
	{"UNRAVEL", 7, 77666},
	{"UNRATED", 7, 43826},
	{"UNRAR", 5, 241070},
	{"UNRANKED", 8, 92310},
	{"UNRACED", 7, 224376},
	{"UNRA", 4, 60702},
	{"UNQUOTED", 8, 125318},
	{"UNQUOTE", 7, 129244},
	{"UNQUIET", 7, 179913},
	{"UNQUESTIONINGLY", 15, 251316},
	{"UNQUESTIONING", 13, 182971},
	{"UNQUESTIONED", 12, 128988},
	{"UNQUESTIONABLY", 14, 85190},
	{"UNQUESTIONABLE", 14, 127558},
	{"UNQUENCHABLE", 12, 178879},
	{"UNQUALIFIED", 11, 65822},
	{"UNQU", 4, 71528},
	{"UNPUNISHED", 10, 110730},
	{"UNPUBLISHED", 11, 42937},
	{"UNPUBL", 6, 180538},
	{"UNPUB", 5, 202194},
	{"UNPU", 4, 81460},
	{"UNPROVOKED", 10, 131335},
	{"UNPROVEN", 8, 90736},
	{"UNPROVED", 8, 241658},
	{"UNPROVABLE", 10, 244605},
	{"UNPROTECTED", 11, 61797},
	{"UNPROTECT", 9, 225848},
	{"UNPROMISING", 11, 241379},
	{"UNPROFOR", 8, 212715},
	{"UNPROFITABLE", 12, 102062},
	{"UNPROFESSIONAL", 14, 88530},
	{"UNPRODUCTIVE", 12, 92528},
	{"UNPROCESSED", 11, 93946},
	{"UNPROBLEMATIC", 13, 230976},
	{"UNPRIVILEGED", 12, 168317},
	{"UNPRINTED", 9, 198757},
	{"UNPRINTABLE", 11, 248633},
	{"UNPRINCIPLED", 12, 173554},
	{"UNPRIMED", 8, 248690},
	{"UNPRICED", 8, 201903},
	{"UNPRETENTIOUS", 13, 118755},
	{"UNPREPARED", 10, 77556},
	{"UNPREJUDICED", 12, 251949},
	{"UNPREDICTABLY", 13, 181794},
	{"UNPREDICTABLE", 13, 50301},
	{"UNPREDICTABILITY", 16, 116234},
	{"UNPRECEDENTED", 13, 33905},
	{"UNPR", 4, 39616},
	{"UNPOWERED", 9, 162426},
	{"UNPOSSIBLE", 10, 77241},
	{"UNPOPULATED", 11, 231817},
	{"UNPOPULARITY", 12, 191720},
	{"UNPOPULAR", 9, 66450},
	{"UNPOLLUTED", 10, 198919},
	{"UNPOLISHED", 10, 170682},
	{"UNPOLARIZED", 11, 221466},
	{"UNPM", 4, 172178},
	{"UNPLUGGING", 10, 152848},
	{"UNPLUGGED", 9, 59224},
	{"UNPLUG", 6, 82526},
	{"UNPLEASURABLE", 13, 133577},
	{"UNPLEASANTNESS", 14, 156880},
	{"UNPLEASANTLY", 12, 192680},
	{"UNPLEASANT", 10, 49992},
	{"UNPLAYED", 8, 136439},
	{"UNPLAYABLE", 10, 160356},
	{"UNPLANNED", 9, 69190},
	{"UNPLACED", 8, 222232},
	{"UNPL", 4, 58731},
	{"UNPI", 4, 154447},
	{"UNPHYSICAL", 10, 231246},
	{"UNPH", 4, 119367},
	{"UNPERTURBED", 11, 151371},
	{"UNPERSUASIVE", 12, 205082},
	{"UNPEELED", 8, 224813},
	{"UNPE", 4, 88897},
	{"UNPAVED", 7, 99111},
	{"UNPATRIOTIC", 11, 121389},
	{"UNPATCHED", 9, 89818},
	{"UNPASTEURIZED", 13, 203747},
	{"UNPARSED", 8, 218491},
	{"UNPARDONABLE", 12, 195916},
	{"UNPARALLELED", 12, 53104},
	{"UNPARALLED", 10, 232447},
	{"UNPALATABLE", 11, 154807},
	{"UNPAIRED", 8, 145235},
	{"UNPAINTED", 9, 111191},
	{"UNPAID", 6, 42762},
	{"UNPAGINATED", 11, 239653},
	{"UNPAGED", 7, 240543},
	{"UNPACKS", 7, 238679},
	{"UNPACKING", 9, 69270},
	{"UNPACKED", 8, 92955},
	{"UNPACKAGED", 10, 179051},
	{"UNPACK", 6, 69093},
	{"UNPA", 4, 52932},
	{"UNOZ", 4, 154307},
	{"UNOWNED", 7, 259204},
	{"UNOW", 4, 75225},
	{"UNOV", 4, 75567},
	{"UNOU", 4, 55978},
	{"UNORTHODOX", 10, 82442},
	{"UNORIGINAL", 10, 135056},
	{"UNORGANIZED", 11, 114022},
	{"UNORGANISED", 11, 242615},
	{"UNORDERED", 9, 102952},
	{"UNOR", 4, 59058},
	{"UNOPS", 5, 226451},
	{"UNOPPOSED", 9, 107808},
	{"UNOPENED", 8, 63715},
	{"UNOP", 4, 82474},
	{"UNOMAT", 6, 209723},
	{"UNOM", 4, 137416},
	{"UNOLS", 5, 254666},
	{"UNOL", 4, 153066},
	{"UNOK", 4, 186379},
	{"UNOFFICIALLY", 12, 122093},
	{"UNOFFICIAL", 10, 36779},
	{"UNOFFICAL", 9, 220303},
	{"UNOF", 4, 38065},
	{"UNODC", 5, 173812},
	{"UNOD", 4, 133424},
	{"UNOCCUPIED", 10, 86644},
	{"UNOCAL", 6, 93831},
	{"UNOC", 4, 94862},
	{"UNOBTRUSIVELY", 13, 167023},
	{"UNOBTRUSIVE", 11, 91246},
	{"UNOBTAINABLE", 12, 183827},
	{"UNOBSTRUCTED", 12, 98178},
	{"UNOBSERVED", 10, 98010},
	{"UNOBSERVABLE", 12, 143353},
	{"UNOBLIGATED", 11, 140858},
	{"UNOB", 4, 93018},
	{"UNNW", 4, 125916},
	{"UNNUMBERED", 10, 99946},
	{"UNNU", 4, 153529},
	{"UNNTAK", 6, 159143},
	{"UNNR", 4, 208298},
	{"UNNP", 4, 202760},
	{"UNNOTICED", 9, 69263},
	{"UNNOTICEABLE", 12, 216217},
	{"UNNM", 4, 233230},
	{"UNNL", 4, 233848},
	{"UNNG", 4, 234576},
	{"UNNF", 4, 209104},
	{"UNNERVING", 9, 123301},
	{"UNNERVED", 8, 178409},
	{"UNNEEDED", 8, 89523},
	{"UNNECESSARY", 11, 35626},
	{"UNNECESSARILY", 13, 63813},
	{"UNNECCESSARY", 12, 237017},
	{"UNNE", 4, 7730},
	{"UNND", 4, 219732},
	{"UNNC", 4, 186900},
	{"UNNB", 4, 200015},
	{"UNNATURALLY", 11, 150597},
	{"UNNATURAL", 9, 62942},
	{"UNNAMED", 7, 50067},
	{"UNMY", 4, 175824},
	{"UNMU", 4, 123628},
	{"UNMS", 4, 206434},
	{"UNMOVING", 8, 205789},
	{"UNMOVIC", 7, 163390},
	{"UNMOVED", 7, 130057},
	{"UNMOUNTING", 10, 197862},
	{"UNMOUNTED", 9, 84110},
	{"UNMOUNT", 7, 132763},
	{"UNMOTIVATED", 11, 160936},
	{"UNMONITORED", 11, 187511},
	{"UNMOLESTED", 10, 184436},
	{"UNMODIFIED", 10, 78873},
	{"UNMODERATED", 11, 90137},
	{"UNMO", 4, 68441},
	{"UNMIXED", 7, 141547},
	{"UNMITIGATED", 11, 136428},
	{"UNMISTAKEABLE", 13, 256448},
	{"UNMISTAKABLY", 12, 114809},
	{"UNMISTAKABLE", 12, 80569},
	{"UNMISSABLE", 10, 203784},
	{"UNMINDFUL", 9, 226934},
	{"UNMIL", 5, 226108},
	{"UNMIK", 5, 106369},
	{"UNMI", 4, 67712},
	{"UNMETERED", 9, 125171},
	{"UNMET", 5, 75450},
	{"UNMERITED", 9, 255879},
	{"UNMERCIFULLY", 12, 254422},
	{"UNMENTIONED", 11, 201052},
	{"UNMENTIONABLES", 14, 205609},
	{"UNMENTIONABLE", 13, 214256},
	{"UNMEE", 5, 172402},
	{"UNMEDIATED", 10, 131062},
	{"UNMEASURED", 10, 164067},
	{"UNME", 4, 64571},
	{"UNMC", 4, 214736},
	{"UNMATCHED", 9, 54668},
	{"UNMASKING", 9, 150448},
	{"UNMASKED", 8, 90965},
	{"UNMASK", 6, 72280},
	{"UNMARRIED", 9, 54281},
	{"UNMARKED", 8, 67402},
	{"UNMARK", 6, 200110},
	{"UNMAPPED", 8, 174338},
	{"UNMAP", 5, 222248},
	{"UNMANNED", 8, 71739},
	{"UNMANAGED", 9, 84658},
	{"UNMANAGEABLE", 12, 114150},
	{"UNMAKING", 8, 236166},
	{"UNMAINTAINED", 12, 197458},
	{"UNMADE", 6, 190147},
	{"UNMA", 4, 46965},
	{"UNLV", 4, 65649},
	{"UNLUCKY", 7, 70969},
	{"UNLUCKILY", 9, 238624},
	{"UNLU", 4, 88486},
	{"UNLTD", 5, 128768},
	{"UNLOVED", 7, 138046},
	{"UNLORD", 6, 249588},
	{"UNLOGGED", 8, 116426},
	{"UNLOCKTOPIC", 11, 214579},
	{"UNLOCKS", 7, 95246},
	{"UNLOCKING", 9, 48995},
	{"UNLOCKER", 8, 122283},
	{"UNLOCKED", 8, 45692},
	{"UNLOCKABLES", 11, 179638},
	{"UNLOCKABLE", 10, 141608},
	{"UNLOCK", 6, 34431},
	{"UNLOADS", 7, 160601},
	{"UNLOADING", 9, 59578},
	{"UNLOADER", 8, 225506},
	{"UNLOADED", 8, 74019},
	{"UNLOAD", 6, 64789},
	{"UNLO", 4, 45608},
	{"UNLIT", 5, 162732},
	{"UNLISTED", 8, 59082},
	{"UNLIQUIDATED", 12, 176073},
	{"UNLINKED", 8, 121224},
	{"UNLINK", 6, 83625},
	{"UNLINED", 7, 106716},
	{"UNLIMITEDNET", 12, 169131},
	{"UNLIMITED", 9, 5129},
	{"UNLIM", 5, 170917},
	{"UNLIKELY", 8, 8766},
	{"UNLIKE", 6, 7951},
	{"UNLIGHTED", 9, 261268},
	{"UNLICENSED", 10, 67887},
	{"UNLEY", 5, 180581},
	{"UNLESS", 6, 4137},
	{"UNLEAVENED", 10, 137738},
	{"UNLEASHX", 8, 241439},
	{"UNLEASHING", 10, 97198},
	{"UNLEASHES", 9, 110897},
	{"UNLEASHED", 9, 48314},
	{"UNLEASH", 7, 65802},
	{"UNLEARNING", 10, 226471},
	{"UNLEARNED", 9, 152703},
	{"UNLEARN", 7, 180176},
	{"UNLEADED", 8, 59035},
	{"UNLE", 4, 31399},
	{"UNLAWFULLY", 10, 81745},
	{"UNLAWFUL", 8, 40548},
	{"UNLADEN", 7, 219486},
	{"UNLABELLED", 10, 156805},
	{"UNLABELED", 9, 86164},
	{"UNLA", 4, 58882},
	{"UNKY", 4, 66436},
	{"UNKW", 4, 85398},
	{"UNKV", 4, 247247},
	{"UNKU", 4, 122163},
	{"UNKT", 4, 69796},
	{"UNKS", 4, 49967},
	{"UNKR", 4, 76115},
	{"UNKP", 4, 122386},
	{"UNKOWN", 6, 130762},
	{"UNKO", 4, 58947},
	{"UNKNOWNS", 8, 77636},
	{"UNKNOWN", 7, 9287},
	{"UNKNOWINGLY", 11, 96680},
	{"UNKNOWING", 9, 145659},
	{"UNKNOWABLE", 10, 131414},
	{"UNKNOW", 6, 171057},
	{"UNKN", 4, 165952},
	{"UNKM", 4, 99351},
	{"UNKLE", 5, 118744},
	{"UNKL", 4, 103250},
	{"UNKK", 4, 254603},
	{"UNKJ", 4, 229744},
	{"UNKINDLY", 8, 250656},
	{"UNKIND", 6, 108650},
	{"UNKI", 4, 51710},
	{"UNKH", 4, 93424},
	{"UNKG", 4, 145575},
	{"UNKF", 4, 91221},
	{"UNKEMPT", 7, 149885},
	{"UNKE", 4, 40227},
	{"UNKD", 4, 82520},
	{"UNKC", 4, 98736},
	{"UNKB", 4, 69765},
	{"UNKA", 4, 54877},
	{"UNJUSTLY", 8, 96672},
	{"UNJUSTIFIED", 11, 82283},
	{"UNJUSTIFIABLY", 13, 203076},
	{"UNJUSTIFIABLE", 13, 132341},
	{"UNJUST", 6, 57345},
	{"UNJU", 4, 73403},
	{"UNJO", 4, 138172},
	{"UNJLC", 5, 259755},
	{"UNJI", 4, 136953},
	{"UNJE", 4, 192628},
	{"UNJA", 4, 59987},
	{"UNJ", 3, 1938},
	{"UNIZ", 4, 101750},
	{"UNIY", 4, 222860},
	{"UNIXWARE", 8, 107296},
	{"UNIXODBC", 8, 125122},
	{"UNIXES", 6, 236835},
	{"UNIX", 4, 5196},
	{"UNIWORLD", 8, 159979},
	{"UNIWILL", 7, 137706},
	{"UNIWERSYTET", 11, 252702},
	{"UNIW", 4, 167241},
	{"UNIVISION", 9, 113437},
	{"UNIVESITY", 9, 190053},
	{"UNIVERSUM", 9, 168299},
	{"UNIVERSTY", 9, 234164},
	{"UNIVERSTIY", 10, 198426},
	{"UNIVERSO", 8, 157219},
	{"UNIVERSITYOFPHOENIX", 19, 196725},
	{"UNIVERSITYOF", 12, 223592},
	{"UNIVERSITY", 10, 3531},
	{"UNIVERSITIES", 12, 6291},
	{"UNIVERSITI", 10, 127873},
	{"UNIVERSITETET", 13, 180279},
	{"UNIVERSITET", 11, 94151},
	{"UNIVERSITES", 11, 256933},
	{"UNIVERSITEIT", 12, 66345},
	{"UNIVERSITE", 10, 81228},
	{"UNIVERSITATIS", 13, 167952},
	{"UNIVERSITAT", 11, 72791},
	{"UNIVERSITAS", 11, 153641},
	{"UNIVERSITARIO", 13, 151690},
	{"UNIVERSITARIAS", 14, 250926},
	{"UNIVERSITARIA", 13, 163449},
	{"UNIVERSITAIRES", 14, 146624},
	{"UNIVERSITAIRE", 13, 126049},
	{"UNIVERSITAET", 12, 120350},
	{"UNIVERSITA", 10, 102200},
	{"UNIVERSIT", 9, 90326},
	{"UNIVERSIDADES", 13, 131562},
	{"UNIVERSIDADE", 12, 71336},
	{"UNIVERSIDAD", 11, 51090},
	{"UNIVERSIADE", 11, 217626},
	{"UNIVERSI", 8, 119756},
	{"UNIVERSES", 9, 81341},
	{"UNIVERSELLE", 11, 200528},
	{"UNIVERSEL", 9, 212503},
	{"UNIVERSE", 8, 6572},
	{"UNIVERSALS", 10, 127250},
	{"UNIVERSALLY", 11, 53270},
	{"UNIVERSALITY", 12, 81406},
	{"UNIVERSALISTS", 13, 165903},
	{"UNIVERSALIST", 12, 79118},
	{"UNIVERSALISM", 12, 112196},
	{"UNIVERSALIS", 11, 146816},
	{"UNIVERSAL", 9, 8323},
	{"UNIVERS", 7, 79830},
	{"UNIVERITY", 9, 215703},
	{"UNIVERISTY", 10, 91586},
	{"UNIVERAL", 8, 214168},
	{"UNIVER", 6, 80504},
	{"UNIVEGA", 7, 235246},
	{"UNIVE", 5, 132040},
	{"UNIVARIATE", 10, 95205},
	{"UNIVAC", 6, 190736},
	{"UNIV", 4, 29764},
	{"UNIU", 4, 157314},
	{"UNITY", 5, 30414},
	{"UNITTESTS", 9, 239428},
	{"UNITTEST", 8, 219116},
	{"UNITS", 5, 2347},
	{"UNITRUST", 8, 118353},
	{"UNITRON", 7, 158611},
	{"UNITRIN", 7, 222068},
	{"UNITO", 5, 161247},
	{"UNITLESS", 8, 187696},
	{"UNITIZED", 8, 195159},
	{"UNITING", 7, 64160},
	{"UNITIES", 7, 224245},
	{"UNITI", 5, 128216},
	{"UNITHOLDERS", 11, 117834},
	{"UNITHOLDER", 10, 190050},
	{"UNITES", 6, 70561},
	{"UNITER", 6, 203048},
	{"UNITEL", 6, 210626},
	{"UNITEDSTATES", 12, 185988},
	{"UNITEDLINUX", 11, 229941},
	{"UNITEDHEALTH", 12, 151903},
	{"UNITED", 6, 4397},
	{"UNITECH", 7, 113029},
	{"UNITEC", 6, 144286},
	{"UNITE", 5, 32659},
	{"UNITAS", 6, 153072},
	{"UNITARY", 7, 57263},
	{"UNITARITY", 9, 176182},
	{"UNITARIANS", 10, 179956},
	{"UNITARIANISM", 12, 234839},
	{"UNITARIAN", 9, 63060},
	{"UNITARD", 7, 240134},
	{"UNITAR", 6, 179650},
	{"UNITAL", 6, 223251},
	{"UNITA", 5, 119565},
	{"UNIT", 4, 2895},
	{"UNISYS", 6, 66313},
	{"UNISTS", 6, 71070},
	{"UNISTAR", 7, 202113},
	{"UNISSUED", 8, 129095},
	{"UNISOURCE", 9, 234407},
	{"UNISONIC", 8, 258496},
	{"UNISON", 6, 61529},
	{"UNISOG", 6, 177659},
	{"UNISA", 5, 99800},
	{"UNIROYAL", 8, 156519},
	{"UNIROSS", 7, 89604},
	{"UNIREZ", 6, 140860},
	{"UNIREF", 6, 160374},
	{"UNIQUES", 7, 131545},
	{"UNIQUENESS", 10, 55762},
	{"UNIQUEMENT", 10, 169298},
	{"UNIQUELY", 8, 41369},
	{"UNIQUEID", 8, 229331},
	{"UNIQUE", 6, 5247},
	{"UNIQLO", 6, 256773},
	{"UNIQ", 4, 128756},
	{"UNIPROTKB", 9, 6369},
	{"UNIPROT", 7, 58446},
	{"UNIPROCESSOR", 12, 188866},
	{"UNIPOLAR", 8, 125746},
	{"UNIPHASE", 8, 174322},
	{"UNIONVILLE", 10, 93604},
	{"UNIONTOWN", 9, 93646},
	{"UNIONS", 6, 29563},
	{"UNIONIZED", 9, 103647},
	{"UNIONIZE", 8, 194481},
	{"UNIONIZATION", 12, 136941},
	{"UNIONISTS", 9, 88484},
	{"UNIONIST", 8, 89963},
	{"UNIONISM", 8, 106763},
	{"UNIONISED", 9, 219794},
	{"UNIONGYRCHOL", 12, 247999},
	{"UNIONFS", 7, 186113},
	{"UNIONE", 6, 119189},
	{"UNIONDIAMOND", 12, 196724},
	{"UNIONDALE", 9, 111703},
	{"UNIONCRICKETICE", 15, 260217},
	{"UNION", 5, 5048},
	{"UNINVOLVED", 10, 174514},
	{"UNINVITED", 9, 113700},
	{"UNINTERRUPTIBLE", 15, 100320},
	{"UNINTERRUPTED", 13, 60597},
	{"UNINTERRUPTABLE", 15, 220047},
	{"UNINTERESTING", 13, 98864},
	{"UNINTERESTED", 12, 123464},
	{"UNINTENTIONALLY", 15, 82422},
	{"UNINTENTIONAL", 13, 69300},
	{"UNINTENDED", 10, 61223},
	{"UNINTELLIGIBLE", 14, 88366},
	{"UNINTELLIGENT", 13, 164649},
	{"UNINSURED", 9, 48762},
	{"UNINSURANCE", 11, 244500},
	{"UNINSURABLE", 11, 257923},
	{"UNINSULATED", 11, 179653},
	{"UNINSTALLING", 12, 89315},
	{"UNINSTALLERS", 12, 142314},
	{"UNINSTALLER", 11, 88069},
	{"UNINSTALLED", 11, 93624},
	{"UNINSTALLATION", 14, 163239},
	{"UNINSTALL", 9, 47759},
	{"UNINSPIRING", 11, 145438},
	{"UNINSPIRED", 10, 115176},
	{"UNINJURED", 9, 140017},
	{"UNINITIATED", 11, 111454},
	{"UNINITIALIZED", 13, 72030},
	{"UNINHIBITED", 11, 107477},
	{"UNINHABITED", 11, 105115},
	{"UNINHABITABLE", 13, 155185},
	{"UNINFORMED", 10, 84428},
	{"UNINFORMATIVE", 13, 183561},
	{"UNINFECTED", 10, 120622},
	{"UNINEWS", 7, 203514},
	{"UNINET", 6, 230119},
	{"UNINCORPORATED", 14, 65422},
	{"UNIMPROVED", 10, 121085},
	{"UNIMPRESSIVE", 12, 144311},
	{"UNIMPRESSED", 11, 114679},
	{"UNIMPORTANT", 11, 70072},
	{"UNIMPLEMENTED", 13, 139288},
	{"UNIMPEDED", 9, 137364},
	{"UNIMPEACHABLE", 13, 214259},
	{"UNIMPAIRED", 10, 157575},
	{"UNIMOG", 6, 173811},
	{"UNIMODAL", 8, 197731},
	{"UNIMAX", 6, 242070},
	{"UNIMAGINED", 10, 250204},
	{"UNIMAGINATIVE", 13, 142719},
	{"UNIMAGINABLY", 12, 225616},
	{"UNIMAGINABLE", 12, 90261},
	{"UNILIB", 6, 176696},
	{"UNILEVER", 8, 80277},
	{"UNILATERALLY", 12, 77262},
	{"UNILATERALISM", 13, 148144},
	{"UNILATERAL", 10, 55421},
	{"UNILANG", 7, 217005},
	{"UNIK", 4, 252596},
	{"UNIGRAPHICS", 11, 155698},
	{"UNIGOL", 6, 223405},
	{"UNIGENE", 7, 57247},
	{"UNIGAMES", 8, 247154},
	{"UNIG", 4, 130826},
	{"UNIFYING", 8, 68507},
	{"UNIFY", 5, 73492},
	{"UNIFORMS", 8, 37288},
	{"UNIFORMLY", 9, 50781},
	{"UNIFORMITY", 10, 57051},
	{"UNIFORMED", 9, 65721},
	{"UNIFORME", 8, 244424},
	{"UNIFORM", 7, 9946},
	{"UNIFLAME", 8, 258241},
	{"UNIFIES", 7, 120839},
	{"UNIFIER", 7, 204610},
	{"UNIFIED", 7, 31374},
	{"UNIFICATION", 11, 53621},
	{"UNIFI", 5, 246802},
	{"UNIFEM", 6, 127254},
	{"UNIF", 4, 190553},
	{"UNIES", 5, 158314},
	{"UNIERSITY", 9, 251352},
	{"UNIDROIT", 8, 224234},
	{"UNIDRAW", 7, 207460},
	{"UNIDOS", 6, 78984},
	{"UNIDO", 5, 73116},
	{"UNIDISC", 7, 231881},
	{"UNIDIRECTIONAL", 14, 81204},
	{"UNIDIFF", 7, 88368},
	{"UNIDENTIFIED", 12, 47350},
	{"UNIDENTIFIABLE", 14, 166511},
	{"UNIDEN", 6, 57254},
	{"UNIDATA", 7, 157748},
	{"UNIDAS", 6, 144045},
	{"UNIDADES", 8, 190596},
	{"UNIDAD", 6, 128430},
	{"UNIDA", 5, 161079},
	{"UNID", 4, 186471},
	{"UNICYCLING", 10, 194784},
	{"UNICYCLES", 9, 171643},
	{"UNICYCLE", 8, 125748},
	{"UNICOS", 6, 213152},
	{"UNICORNS", 8, 88475},
	{"UNICORN", 7, 52703},
	{"UNICORE", 7, 110621},
	{"UNICON", 6, 213942},
	{"UNICOM", 6, 108789},
	{"UNICOI", 6, 163611},
	{"UNICODE", 7, 40562},
	{"UNICO", 5, 113048},
	{"UNICITY", 7, 227184},
	{"UNICHROME", 9, 215133},
	{"UNICHEM", 7, 244980},
	{"UNICES", 6, 250725},
	{"UNICENTER", 9, 128111},
	{"UNICENT", 7, 181795},
	{"UNICELLULAR", 11, 165937},
	{"UNICEL", 6, 189584},
	{"UNICEF", 6, 48142},
	{"UNICE", 5, 225401},
	{"UNICAST", 7, 72592},
	{"UNICARE", 7, 154499},
	{"UNICAMP", 7, 199335},
	{"UNICAMERAL", 10, 153889},
	{"UNICA", 5, 128889},
	{"UNIC", 4, 180301},
	{"UNIBRAIN", 8, 204407},
	{"UNIBOND", 7, 198206},
	{"UNIBODY", 7, 223245},
	{"UNIBLUE", 7, 216910},
	{"UNIB", 4, 132267},
	{"UNIAXIAL", 8, 156410},
	{"UNHYGIENIC", 10, 240938},
	{"UNHY", 4, 215866},
	{"UNHURT", 6, 158470},
	{"UNHURRIED", 9, 173956},
	{"UNHU", 4, 115902},
	{"UNHOOKED", 8, 225613},
	{"UNHOOK", 6, 210863},
	{"UNHOLY", 6, 73167},
	{"UNHIP", 5, 241179},
	{"UNHINGED", 8, 112347},
	{"UNHINDERED", 10, 133065},
	{"UNHIDE", 6, 172458},
	{"UNHESITATINGLY", 14, 220030},
	{"UNHERALDED", 10, 184214},
	{"UNHELPFUL", 9, 58946},
	{"UNHEEDED", 8, 159876},
	{"UNHEDGED", 8, 254103},
	{"UNHEATED", 8, 133787},
	{"UNHEARD", 7, 71062},
	{"UNHEALTHY", 9, 58102},
	{"UNHCR", 5, 57447},
	{"UNHC", 4, 159564},
	{"UNHARMED", 8, 112219},
	{"UNHAPPY", 7, 35457},
	{"UNHAPPINESS", 11, 92424},
	{"UNHAPPILY", 9, 120077},
	{"UNHANDLED", 9, 132774},
	{"UNHAMPERED", 10, 259063},
	{"UNGZ", 4, 130651},
	{"UNGY", 4, 87138},
	{"UNGW", 4, 43682},
	{"UNGV", 4, 93571},
	{"UNGULATES", 9, 180906},
	{"UNGULATE", 8, 216994},
	{"UNGUIDED", 8, 165033},
	{"UNGUENTS", 8, 248095},
	{"UNGUARDED", 9, 134720},
	{"UNGU", 4, 54614},
	{"UNGT", 4, 44969},
	{"UNGS", 4, 36078},
	{"UNGROUNDED", 10, 187630},
	{"UNGREASED", 9, 182548},
	{"UNGRATEFUL", 10, 107618},
	{"UNGRAMMATICAL", 13, 210780},
	{"UNGRADED", 8, 106540},
	{"UNGR", 4, 44698},
	{"UNGQ", 4, 142842},
	{"UNGP", 4, 38787},
	{"UNGOVERNABLE", 12, 256308},
	{"UNGODLY", 7, 98254},
	{"UNGN", 4, 84787},
	{"UNGM", 4, 39264},
	{"UNGLUED", 7, 177585},
	{"UNGLAZED", 8, 178640},
	{"UNGL", 4, 42564},
	{"UNGK", 4, 76695},
	{"UNGJ", 4, 84522},
	{"UNGI", 4, 45764},
	{"UNGH", 4, 55302},
	{"UNGG", 4, 51623},
	{"UNGF", 4, 53277},
	{"UNGERLEIDER", 11, 257528},
	{"UNGERER", 7, 221280},
	{"UNGER", 5, 77536},
	{"UNGD", 4, 60420},
	{"UNGC", 4, 44105},
	{"UNGB", 4, 45019},
	{"UNGARO", 6, 97103},
	{"UNGARN", 6, 87758},
	{"UNGAR", 5, 123692},
	{"UNGAINLY", 8, 186033},
	{"UNGA", 4, 164127},
	{"UNFURNISHED", 11, 75816},
	{"UNFURLING", 9, 241725},
	{"UNFURLED", 8, 163609},
	{"UNFURL", 6, 214091},
	{"UNFUNNY", 7, 141451},
	{"UNFUNDED", 8, 76353},
	{"UNFULFILLED", 11, 97958},
	{"UNFU", 4, 82253},
	{"UNFRUITFUL", 10, 232722},
	{"UNFROZEN", 8, 210268},
	{"UNFRIENDLY", 10, 81438},
	{"UNFREEZE", 8, 243123},
	{"UNFREE", 6, 191765},
	{"UNFRAMED", 8, 60216},
	{"UNFRACTIONATED", 14, 246105},
	{"UNFR", 4, 59076},
	{"UNFPA", 5, 85201},
	{"UNFOUNDED", 9, 76620},
	{"UNFORTUNATLY", 12, 113123},
	{"UNFORTUNATLEY", 13, 200108},
	{"UNFORTUNATES", 12, 238559},
	{"UNFORTUNATELY", 13, 6288},
	{"UNFORTUNATE", 11, 40989},
	{"UNFORTU", 7, 248393},
	{"UNFORSEEN", 9, 167898},
	{"UNFORMED", 8, 217554},
	{"UNFORMATTED", 11, 94520},
	{"UNFORMAT", 8, 221923},
	{"UNFORGIVING", 11, 108612},
	{"UNFORGIVEN", 10, 75671},
	{"UNFORGIVABLE", 12, 129786},
	{"UNFORGETTABLE", 13, 49063},
	{"UNFORGETABLE", 12, 174821},
	{"UNFORESEEN", 10, 66057},
	{"UNFORESEEABLE", 13, 152100},
	{"UNFORCED", 8, 154556},
	{"UNFOLDS", 7, 70338},
	{"UNFOLDING", 9, 61123},
	{"UNFOLDED", 8, 73489},
	{"UNFOLD", 6, 34815},
	{"UNFOGGED", 8, 165851},
	{"UNFOCUSED", 9, 131612},
	{"UNFO", 4, 10126},
	{"UNFLINCHINGLY", 13, 231251},
	{"UNFLINCHING", 11, 130367},
	{"UNFLAVORED", 10, 218087},
	{"UNFLATTERING", 12, 150365},
	{"UNFLAPPABLE", 11, 217546},
	{"UNFLAGGING", 10, 224394},
	{"UNFL", 4, 76567},
	{"UNFIXED", 7, 190737},
	{"UNFITNESS", 9, 198296},
	{"UNFIT", 5, 66632},
	{"UNFIRED", 7, 210066},
	{"UNFINISHED", 10, 46009},
	{"UNFILTERED", 10, 84419},
	{"UNFILLED", 8, 99927},
	{"UNFILED", 7, 119074},
	{"UNFI", 4, 46300},
	{"UNFF", 4, 240598},
	{"UNFETTERED", 10, 89365},
	{"UNFERTILIZED", 12, 228803},
	{"UNFEELING", 9, 179052},
	{"UNFEASIBLE", 10, 159671},
	{"UNFE", 4, 80683},
	{"UNFCCC", 6, 108223},
	{"UNFAZED", 7, 155940},
	{"UNFAVOURABLY", 12, 246787},
	{"UNFAVOURABLE", 12, 97201},
	{"UNFAVORABLY", 11, 177469},
	{"UNFAVORABLE", 11, 63319},
	{"UNFATHOMABLE", 12, 123654},
	{"UNFASTENED", 10, 234657},
	{"UNFASHIONABLE", 13, 151852},
	{"UNFAMILIARITY", 13, 185972},
	{"UNFAMILIAR", 10, 49541},
	{"UNFAITHFULNESS", 14, 225464},
	{"UNFAITHFUL", 10, 95805},
	{"UNFAIRNESS", 10, 106609},
	{"UNFAIRLY", 8, 67768},
	{"UNFAIR", 6, 34227},
	{"UNFAILINGLY", 11, 181116},
	{"UNFAILING", 9, 133346},
	{"UNFA", 4, 40996},
	{"UNEZ", 4, 140478},
	{"UNEY", 4, 127382},
	{"UNEXPRESSED", 11, 241854},
	{"UNEXPOSED", 9, 150764},
	{"UNEXPLORED", 10, 96201},
	{"UNEXPLOITED", 11, 234217},
	{"UNEXPLODED", 10, 128190},
	{"UNEXPLAINED", 11, 60416},
	{"UNEXPLAINABLE", 13, 136097},
	{"UNEXPIRED", 9, 92914},
	{"UNEXPENDED", 10, 120629},
	{"UNEXPECTEDLY", 12, 54292},
	{"UNEXPECTED", 10, 30386},
	{"UNEXPANDED", 10, 216967},
	{"UNEXERCISED", 11, 189838},
	{"UNEXCUSED", 9, 110311},
	{"UNEXCITING", 10, 211524},
	{"UNEXCEPTIONAL", 13, 257749},
	{"UNEXAMINED", 10, 146511},
	{"UNEX", 4, 186589},
	{"UNEVENTFUL", 10, 97705},
	{"UNEVENNESS", 10, 200840},
	{"UNEVENLY", 8, 122646},
	{"UNEVEN", 6, 54715},
	{"UNEV", 4, 48681},
	{"UNEU", 4, 87883},
	{"UNETHICAL", 9, 67709},
	{"UNESCORTED", 10, 246711},
	{"UNESCO", 6, 41484},
	{"UNESCAPED", 9, 241948},
	{"UNESCAPE", 8, 159752},
	{"UNESCAP", 7, 199522},
	{"UNERRINGLY", 10, 261825},
	{"UNERRING", 8, 167955},
	{"UNERASE", 7, 175137},
	{"UNER", 4, 36692},
	{"UNEQUIVOCALLY", 13, 89562},
	{"UNEQUIVOCAL", 11, 91089},
	{"UNEQUALLY", 9, 167789},
	{"UNEQUALLED", 10, 135223},
	{"UNEQUALED", 9, 132204},
	{"UNEQUAL", 7, 60465},
	{"UNEQ", 4, 80188},
	{"UNEP", 4, 58000},
	{"UNENVIABLE", 10, 179016},
	{"UNENLIGHTENED", 13, 207343},
	{"UNENFORCEABLE", 13, 72474},
	{"UNENFORCEABILITY", 16, 202360},
	{"UNENDING", 8, 96546},
	{"UNENCRYPTED", 11, 116583},
	{"UNEMPLOYMENT", 12, 29574},
	{"UNEMPLOYED", 10, 39973},
	{"UNEMPLOYABLE", 12, 232181},
	{"UNEMPLOY", 8, 214559},
	{"UNEMP", 5, 228793},
	{"UNEMOTIONAL", 11, 212465},
	{"UNEM", 4, 188976},
	{"UNELECTED", 9, 141240},
	{"UNEL", 4, 65558},
	{"UNEK", 4, 122746},
	{"UNEJ", 4, 79895},
	{"UNEG", 4, 87016},
	{"UNEDUCATED", 10, 90627},
	{"UNEDITED", 8, 77400},
	{"UNEDIG", 6, 180180},
	{"UNED", 4, 153960},
	{"UNECONOMICAL", 12, 196407},
	{"UNECONOMIC", 10, 159364},
	{"UNECESSARY", 10, 198456},
	{"UNECE", 5, 134705},
	{"UNEC", 4, 56633},
	{"UNEB", 4, 58930},
	{"UNEATEN", 7, 251393},
	{"UNEASY", 6, 63868},
	{"UNEASINESS", 10, 113844},
	{"UNEASILY", 8, 143686},
	{"UNEASE", 6, 112888},
	{"UNEARTHS", 8, 214703},
	{"UNEARTHLY", 9, 132900},
	{"UNEARTHING", 10, 159846},
	{"UNEARTHED", 9, 80511},
	{"UNEARTH", 7, 85354},
	{"UNEARNED", 8, 76034},
	{"UNEA", 4, 33151},
	{"UNDZ", 4, 92442},
	{"UNDYING", 7, 99968},
	{"UNDYED", 6, 231261},
	{"UNDW", 4, 30217},
	{"UNDV", 4, 66602},
	{"UNDUPLICATED", 12, 138274},
	{"UNDULY", 6, 71607},
	{"UNDULATUS", 9, 243160},
	{"UNDULATOR", 9, 160612},
	{"UNDULATIONS", 11, 196568},
	{"UNDULATING", 10, 93596},
	{"UNDUE", 5, 55017},
	{"UNDU", 4, 40343},
	{"UNDT", 4, 3073},
	{"UNDS", 4, 239258},
	{"UNDRESSES", 9, 146594},
	{"UNDRESSED", 9, 82829},
	{"UNDRESS", 7, 77228},
	{"UNDRENTIDE", 10, 257897},
	{"UNDRAWN", 7, 257699},
	{"UNDRAINED", 9, 190155},
	{"UNDRAFTED", 9, 214367},
	{"UNDR", 4, 6318},
	{"UNDQ", 4, 83419},
	{"UNDP", 4, 50251},
	{"UNDOUBTEDLY", 11, 43922},
	{"UNDOUBTED", 9, 135488},
	{"UNDOUBTABLY", 11, 240604},
	{"UNDOPED", 7, 239207},
	{"UNDONE", 6, 68218},
	{"UNDOING", 7, 92990},
	{"UNDOES", 6, 201714},
	{"UNDO", 4, 34038},
	{"UNDN", 4, 44705},
	{"UNDM", 4, 35070},
	{"UNDL", 4, 33524},
	{"UNDK", 4, 64351},
	{"UNDJ", 4, 67888},
	{"UNDIVIDED", 9, 82726},
	{"UNDISTURBED", 11, 73617},
	{"UNDISTRIBUTED", 13, 96317},
	{"UNDISTORTED", 11, 218609},
	{"UNDISTINGUISHED", 15, 197353},
	{"UNDISPUTED", 10, 70328},
	{"UNDISGUISED", 11, 229962},
	{"UNDISCOVERED", 12, 66467},
	{"UNDISCOUNTED", 12, 211385},
	{"UNDISCLOSED", 11, 65854},
	{"UNDISCIPLINED", 13, 152893},
	{"UNDISBURSED", 11, 226683},
	{"UNDIRECTED", 10, 120379},
	{"UNDINE", 6, 219700},
	{"UNDIMINISHED", 12, 154549},
	{"UNDILUTED", 9, 125187},
	{"UNDIGNIFIED", 11, 186832},
	{"UNDIGESTED", 10, 193826},
	{"UNDIFFERENTIATED", 16, 86703},
	{"UNDIES", 6, 66100},
	{"UNDID", 5, 142859},
	{"UNDIAGNOSED", 11, 110530},
	{"UNDH", 4, 30546},
	{"UNDEVELOPED", 11, 70324},
	{"UNDETERRED", 10, 154258},
	{"UNDETERMINED", 12, 64589},
	{"UNDETECTED", 10, 83878},
	{"UNDETECTABLE", 12, 86860},
	{"UNDESIRED", 9, 105796},
	{"UNDESIRABLES", 12, 217866},
	{"UNDESIRABLE", 11, 55004},
	{"UNDESIGNATED", 12, 157570},
	{"UNDESERVING", 11, 170225},
	{"UNDESERVED", 10, 136096},
	{"UNDESCRIBED", 11, 184808},
	{"UNDESCENDED", 11, 238343},
	{"UNDERWRITTEN", 12, 93404},
	{"UNDERWRITING", 12, 51605},
	{"UNDERWRITES", 11, 232243},
	{"UNDERWRITERS", 12, 63443},
	{"UNDERWRITER", 11, 66827},
	{"UNDERWRITE", 10, 107563},
	{"UNDERWORLD", 10, 42018},
	{"UNDERWOOD", 9, 48315},
	{"UNDERWIRED", 10, 83748},
	{"UNDERWIRE", 9, 74013},
	{"UNDERWING", 9, 244296},
	{"UNDERWHELMING", 13, 182610},
	{"UNDERWHELMED", 12, 185020},
	{"UNDERWENT", 9, 54085},
	{"UNDERWEIGHT", 11, 102759},
	{"UNDERWEAR", 9, 28237},
	{"UNDERWAY", 8, 39238},
	{"UNDERWATER", 10, 36821},
	{"UNDERWARE", 9, 133284},
	{"UNDERVOTES", 10, 179384},
	{"UNDERVOLTAGE", 12, 222551},
	{"UNDERVALUED", 11, 92742},
	{"UNDERVALUE", 10, 209558},
	{"UNDERUTILIZED", 13, 106591},
	{"UNDERUTILIZATION", 16, 229920},
	{"UNDERUSED", 9, 140508},
	{"UNDERTOW", 8, 126101},
	{"UNDERTOOK", 9, 59481},
	{"UNDERTONES", 10, 100346},
	{"UNDERTONE", 9, 150000},
	{"UNDERTAKINGS", 12, 59350},
	{"UNDERTAKING", 11, 38447},
	{"UNDERTAKES", 10, 64824},
	{"UNDERTAKERS", 11, 155263},
	{"UNDERTAKER", 10, 80891},
	{"UNDERTAKEN", 10, 30970},
	{"UNDERTAKE", 9, 31513},
	{"UNDERSTUDY", 10, 175326},
	{"UNDERSTORY", 10, 114795},
	{"UNDERSTOREY", 11, 213068},
	{"UNDERSTOOD", 10, 9308},
	{"UNDERSTEER", 10, 219555},
	{"UNDERSTATING", 12, 251019},
	{"UNDERSTATES", 11, 218768},
	{"UNDERSTATEMENT", 14, 82545},
	{"UNDERSTATED", 11, 73571},
	{"UNDERSTATE", 10, 155205},
	{"UNDERSTANDS", 11, 38672},
	{"UNDERSTANDINGS", 14, 63107},
	{"UNDERSTANDING", 13, 3704},
	{"UNDERSTANDABLY", 14, 74579},
	{"UNDERSTANDABLE", 14, 48463},
	{"UNDERSTANDABILITY", 17, 238153},
	{"UNDERSTAND", 10, 1312},
	{"UNDERSTAN", 9, 246146},
	{"UNDERSTAFFED", 12, 152052},
	{"UNDERSPEND", 10, 248989},
	{"UNDERSOLD", 9, 181339},
	{"UNDERSIZED", 10, 136344},
	{"UNDERSIGNED", 11, 62418},
	{"UNDERSIDES", 10, 206562},
	{"UNDERSIDE", 9, 69363},
	{"UNDERSHIRTS", 11, 184703},
	{"UNDERSHIRT", 10, 172360},
	{"UNDERSERVED", 11, 70717},
	{"UNDERSECRETARY", 14, 98749},
	{"UNDERSEA", 8, 81738},
	{"UNDERSCORING", 12, 134047},
	{"UNDERSCORES", 11, 69090},
	{"UNDERSCORED", 11, 84897},
	{"UNDERSCORE", 10, 60021},
	{"UNDERS", 6, 147670},
	{"UNDERRUN", 8, 178908},
	{"UNDERREPRESENTED", 16, 82585},
	{"UNDERREPRESENTATION", 19, 226189},
	{"UNDERREPORTING", 14, 183826},
	{"UNDERREPORTED", 13, 168212},
	{"UNDERRATED", 10, 81420},
	{"UNDERPRIVILEGED", 15, 106211},
	{"UNDERPRICING", 12, 214573},
	{"UNDERPOWERED", 12, 164797},
	{"UNDERPLATE", 10, 226337},
	{"UNDERPINS", 9, 112056},
	{"UNDERPINNINGS", 13, 96059},
	{"UNDERPINNING", 12, 75619},
	{"UNDERPINNED", 11, 96766},
	{"UNDERPIN", 8, 81026},
	{"UNDERPERFORMING", 15, 136768},
	{"UNDERPERFORMED", 14, 233161},
	{"UNDERPERFORMANCE", 16, 199344},
	{"UNDERPERFORM", 12, 153751},
	{"UNDERPAYMENTS", 13, 214283},
	{"UNDERPAYMENT", 12, 137238},
	{"UNDERPASSES", 11, 257547},
	{"UNDERPASS", 9, 127268},
	{"UNDERPARTS", 10, 163717},
	{"UNDERPANTS", 10, 94476},
	{"UNDERPAID", 9, 115820},
	{"UNDEROATH", 9, 45797},
	{"UNDERNUTRITION", 14, 212537},
	{"UNDERNOURISHED", 14, 150048},
	{"UNDERNET", 8, 146329},
	{"UNDERNEATH", 10, 41239},
	{"UNDERMOUNT", 10, 138828},
	{"UNDERMINING", 11, 67782},
	{"UNDERMINES", 10, 75156},
	{"UNDERMINER", 10, 142359},
	{"UNDERMINED", 10, 65368},
	{"UNDERMINE", 9, 30472},
	{"UNDERLYING", 10, 32755},
	{"UNDERLY", 7, 227510},
	{"UNDERLINING", 11, 88601},
	{"UNDERLINGS", 10, 182926},
	{"UNDERLING", 9, 202497},
	{"UNDERLINES", 10, 88809},
	{"UNDERLINED", 10, 49233},
	{"UNDERLINE", 9, 51251},
	{"UNDERLIES", 9, 91276},
	{"UNDERLIE", 8, 83211},
	{"UNDERLAYMENT", 12, 158825},
	{"UNDERLAY", 8, 88104},
	{"UNDERLAIN", 9, 173186},
	{"UNDERINSURED", 12, 130435},
	{"UNDERHILL", 9, 90188},
	{"UNDERHANDED", 11, 163622},
	{"UNDERHAND", 9, 174839},
	{"UNDERGROWTH", 11, 119735},
	{"UNDERGROUNDS", 12, 232347},
	{"UNDERGROUNDING", 14, 231622},
	{"UNDERGROUND", 11, 7006},
	{"UNDERGRADUATES", 14, 50735},
	{"UNDERGRADUATE", 13, 34160},
	{"UNDERGRADS", 10, 117470},
	{"UNDERGRAD", 9, 63320},
	{"UNDERGONE", 9, 52890},
	{"UNDERGOING", 10, 45210},
	{"UNDERGOES", 9, 72998},
	{"UNDERGO", 7, 28166},
	{"UNDERGLAZE", 10, 246500},
	{"UNDERGEAR", 9, 136986},
	{"UNDERGARMENTS", 13, 104552},
	{"UNDERGARMENT", 12, 193684},
	{"UNDERFUNDING", 12, 173033},
	{"UNDERFUNDED", 11, 121869},
	{"UNDERFULL", 9, 70285},
	{"UNDERFOOT", 9, 112341},
	{"UNDERFLOW", 9, 126703},
	{"UNDERFLOOR", 10, 120584},
	{"UNDEREXPOSED", 12, 228023},
	{"UNDERESTIMATION", 15, 141944},
	{"UNDERESTIMATING", 15, 134633},
	{"UNDERESTIMATES", 14, 137558},
	{"UNDERESTIMATED", 14, 68524},
	{"UNDERESTIMATE", 13, 64598},
	{"UNDEREMPLOYMENT", 15, 156812},
	{"UNDEREMPLOYED", 13, 136642},
	{"UNDERDRIVE", 10, 254830},
	{"UNDERDOGS", 9, 103071},
	{"UNDERDOG", 8, 63017},
	{"UNDERDEVELOPMENT", 16, 135077},
	{"UNDERDEVELOPED", 14, 86617},
	{"UNDERDARK", 9, 159797},
	{"UNDERCUTTING", 12, 144396},
	{"UNDERCUTS", 9, 159828},
	{"UNDERCUT", 8, 85519},
	{"UNDERCURRENTS", 13, 162090},
	{"UNDERCURRENT", 12, 117689},
	{"UNDERCROFT", 10, 183468},
	{"UNDERCOVER", 10, 51238},
	{"UNDERCOUNTER", 12, 136700},
	{"UNDERCOUNT", 10, 198624},
	{"UNDERCOOKED", 11, 165127},
	{"UNDERCOATING", 12, 239947},
	{"UNDERCOAT", 9, 164372},
	{"UNDERCLASSMEN", 13, 187580},
	{"UNDERCLASSMAN", 13, 107585},
	{"UNDERCLASS", 10, 125037},
	{"UNDERCARRIAGE", 13, 139170},
	{"UNDERCAR", 8, 203957},
	{"UNDERBRUSH", 10, 164551},
	{"UNDERBODY", 9, 160025},
	{"UNDERBELLY", 10, 116931},
	{"UNDERARMS", 9, 176601},
	{"UNDERARMOUR", 11, 226455},
	{"UNDERARM", 8, 107737},
	{"UNDERAPPRECIATED", 16, 131795},
	{"UNDERAGED", 9, 199342},
	{"UNDERAGE", 8, 50196},
	{"UNDERACTIVE", 11, 220785},
	{"UNDERACHIEVING", 14, 177433},
	{"UNDERACHIEVERS", 14, 243481},
	{"UNDERACHIEVER", 13, 222061},
	{"UNDERACHIEVEMENT", 16, 174737},
	{"UNDERACHIEVED", 13, 252403},
	{"UNDER", 5, 1133},
	{"UNDENIABLY", 10, 88708},
	{"UNDENIABLE", 10, 76468},
	{"UNDEMOCRATIC", 12, 111236},
	{"UNDEMANDING", 11, 207101},
	{"UNDELIVERED", 11, 117415},
	{"UNDELIVERABLE", 13, 607},
	{"UNDELETION", 10, 225695},
	{"UNDELETE", 8, 82272},
	{"UNDEGROUND", 10, 260710},
	{"UNDEFINED", 9, 29440},
	{"UNDEFINE", 8, 226472},
	{"UNDEFILED", 9, 213749},
	{"UNDEFENDED", 10, 224101},
	{"UNDEFEATED", 10, 73472},
	{"UNDEF", 5, 44796},
	{"UNDECORATED", 11, 201493},
	{"UNDECLARED", 10, 64938},
	{"UNDECIDED", 9, 60268},
	{"UNDECIDABLE", 11, 157091},
	{"UNDECIDABILITY", 14, 222945},
	{"UNDEAD", 6, 60591},
	{"UNDE", 4, 109624},
	{"UNDD", 4, 40598},
	{"UNDCP", 5, 208980},
	{"UNDC", 4, 36598},
	{"UNDB", 4, 31625},
	{"UNDAUNTED", 9, 117291},
	{"UNDATED", 7, 63499},
	{"UNDANG", 6, 222591},
	{"UNDAMAGED", 9, 96517},
	{"UNDAF", 5, 208237},
	{"UNDA", 4, 201330},
	{"UND", 3, 5656},
	{"UNCYCLOPEDIA", 12, 241820},
	{"UNCY", 4, 137772},
	{"UNCW", 4, 146553},
	{"UNCUT", 5, 39194},
	{"UNCURED", 7, 249319},
	{"UNCULTURED", 10, 177769},
	{"UNCULTIVATED", 12, 186301},
	{"UNCU", 4, 89187},
	{"UNCTUOUS", 8, 245946},
	{"UNCTION", 7, 163076},
	{"UNCTAD", 6, 79243},
	{"UNCS", 4, 175922},
	{"UNCROWDED", 9, 174800},
	{"UNCRITIQUED", 11, 132888},
	{"UNCRITICALLY", 12, 164427},
	{"UNCRITICAL", 10, 137648},
	{"UNCREDITED", 10, 74528},
	{"UNCREATED", 9, 230676},
	{"UNCR", 4, 81626},
	{"UNCP", 4, 219474},
	{"UNCOVERS", 8, 87415},
	{"UNCOVERING", 10, 75952},
	{"UNCOVERED", 9, 46919},
	{"UNCOVER", 7, 34126},
	{"UNCOUTH", 7, 157135},
	{"UNCOUPLING", 10, 153071},
	{"UNCOUPLED", 9, 178092},
	{"UNCOUNTED", 9, 171138},
	{"UNCOUNTABLE", 11, 153034},
	{"UNCOUNT", 7, 218227},
	{"UNCORRUPTED", 11, 228761},
	{"UNCORROBORATED", 14, 204958},
	{"UNCORRELATED", 12, 107973},
	{"UNCORRECTED", 11, 84819},
	{"UNCORKED", 8, 124023},
	{"UNCOORDINATED", 13, 133153},
	{"UNCOOPERATIVE", 13, 121826},
	{"UNCOOL", 6, 133335},
	{"UNCOOKED", 8, 105002},
	{"UNCONVINCING", 12, 126399},
	{"UNCONVINCED", 11, 135762},
	{"UNCONVERTED", 11, 188543},
	{"UNCONVENTIONAL", 14, 62864},
	{"UNCONTROVERSIAL", 15, 185218},
	{"UNCONTROLLED", 12, 58981},
	{"UNCONTROLLABLY", 14, 117425},
	{"UNCONTROLLABLE", 14, 82264},
	{"UNCONTESTED", 11, 94821},
	{"UNCONTAMINATED", 14, 146669},
	{"UNCONSTRAINED", 13, 95622},
	{"UNCONSTITUTIONALLY", 18, 150334},
	{"UNCONSTITUTIONALITY", 19, 220870},
	{"UNCONSTITUTIONAL", 16, 53194},
	{"UNCONSOLIDATED", 14, 112399},
	{"UNCONSCIOUSNESS", 15, 103014},
	{"UNCONSCIOUSLY", 13, 83102},
	{"UNCONSCIOUS", 11, 47445},
	{"UNCONSCIONABLE", 14, 111203},
	{"UNCONSCIONABILITY", 17, 258406},
	{"UNCONQUERED", 11, 236900},
	{"UNCONQUERABLE", 13, 207989},
	{"UNCONNECTED", 11, 98135},
	{"UNCONJUGATED", 12, 122317},
	{"UNCONFORMITY", 12, 220064},
	{"UNCONFIRMED", 11, 73042},
	{"UNCONFINED", 10, 150407},
	{"UNCONFIGURED", 12, 258056},
	{"UNCONDITIONED", 13, 162492},
	{"UNCONDITIONALLY", 15, 73240},
	{"UNCONDITIONAL", 13, 54257},
	{"UNCONCIOUS", 10, 252796},
	{"UNCONCERNED", 11, 119561},
	{"UNCON", 5, 243108},
	{"UNCOMPROMISINGLY", 16, 247926},
	{"UNCOMPROMISING", 14, 80877},
	{"UNCOMPROMISED", 13, 179743},
	{"UNCOMPRESSING", 13, 260964},
	{"UNCOMPRESSED", 12, 64478},
	{"UNCOMPRESS", 10, 127372},
	{"UNCOMPLICATED", 13, 86091},
	{"UNCOMPLETED", 11, 152121},
	{"UNCOMPETITIVE", 13, 173612},
	{"UNCOMPENSATED", 13, 129302},
	{"UNCOMMONLY", 10, 131144},
	{"UNCOMMON", 8, 42922},
	{"UNCOMMITTED", 11, 118170},
	{"UNCOMMENTED", 11, 168261},
	{"UNCOMMENT", 9, 112471},
	{"UNCOMFORTABLY", 13, 109923},
	{"UNCOMFORTABLE", 13, 30605},
	{"UNCOLORED", 9, 246112},
	{"UNCOLLECTIBLE", 13, 150304},
	{"UNCOLLECTED", 11, 135178},
	{"UNCODIFIED", 10, 256780},
	{"UNCODED", 7, 233363},
	{"UNCOATED", 8, 102868},
	{"UNCO", 4, 235672},
	{"UNCLUTTERED", 11, 120635},
	{"UNCLOTHED", 9, 231527},
	{"UNCLOSED", 8, 227788},
	{"UNCLOS", 6, 195208},
	{"UNCLOG", 6, 243288},
	{"UNCLIPPED", 9, 213335},
	{"UNCLES", 6, 79189},
	{"UNCLEARED", 9, 260335},
	{"UNCLEAR", 7, 41136},
	{"UNCLEANNESS", 11, 172529},
	{"UNCLEANED", 9, 236959},
	{"UNCLEAN", 7, 77046},
	{"UNCLE", 5, 28604},
	{"UNCLASSIFIED", 12, 46039},
	{"UNCLASSIFIABLE", 14, 143358},
	{"UNCLAIMED", 9, 60154},
	{"UNCL", 4, 35008},
	{"UNCK", 4, 163766},
	{"UNCIVILIZED", 11, 161931},
	{"UNCIVIL", 7, 139482},
	{"UNCITRAL", 8, 161604},
	{"UNCIRCULATED", 12, 97911},
	{"UNCIAL", 6, 206975},
	{"UNCI", 4, 4740},
	{"UNCHURCHED", 10, 192299},
	{"UNCHS", 5, 250411},
	{"UNCHECKING", 10, 234272},
	{"UNCHECKED", 9, 64103},
	{"UNCHECK", 7, 70116},
	{"UNCHARTED", 9, 97080},
	{"UNCHARITABLE", 12, 261906},
	{"UNCHARGED", 9, 184185},
	{"UNCHARACTERIZED", 15, 111820},
	{"UNCHARACTERISTICALLY", 20, 149752},
	{"UNCHARACTERISTIC", 16, 156160},
	{"UNCHANGING", 10, 103451},
	{"UNCHANGED", 9, 41437},
	{"UNCHANGEABLE", 12, 138429},
	{"UNCHALLENGED", 12, 105383},
	{"UNCHAINED", 9, 106610},
	{"UNCHAIN", 7, 226652},
	{"UNCH", 4, 108198},
	{"UNCG", 4, 142867},
	{"UNCF", 4, 259761},
	{"UNCERTIFIED", 11, 139718},
	{"UNCERTIFICATED", 14, 235163},
	{"UNCERTAINTY", 11, 30595},
	{"UNCERTAINTIES", 13, 43236},
	{"UNCERTAINLY", 11, 185662},
	{"UNCERTAIN", 9, 33562},
	{"UNCEREMONIOUSLY", 15, 155467},
	{"UNCER", 5, 184448},
	{"UNCENSORED", 10, 49142},
	{"UNCENCORED", 10, 213528},
	{"UNCED", 5, 180596},
	{"UNCEASINGLY", 11, 192596},
	{"UNCEASING", 9, 160597},
	{"UNCE", 4, 4420},
	{"UNCDF", 5, 258073},
	{"UNCCD", 5, 188248},
	{"UNCC", 4, 193160},
	{"UNCAUGHT", 8, 195799},
	{"UNCATEGORIZED", 13, 39698},
	{"UNCATEGORIZABLE", 15, 250208},
	{"UNCATEGORISED", 13, 127910},
	{"UNCASVILLE", 10, 166324},
	{"UNCARING", 8, 138381},
	{"UNCARED", 7, 218500},
	{"UNCAPPED", 8, 126307},
	{"UNCANNY", 7, 69504},
	{"UNCANNILY", 9, 196037},
	{"UNCALLED", 8, 145453},
	{"UNCALIBRATED", 12, 177702},
	{"UNCACHED", 8, 253078},
	{"UNCA", 4, 171610},
	{"UNBY", 4, 45636},
	{"UNBUTTONED", 10, 162805},
	{"UNBUTTON", 8, 236015},
	{"UNBURNED", 8, 164734},
	{"UNBURIED", 8, 254185},
	{"UNBUNDLING", 10, 107266},
	{"UNBUNDLED", 9, 88416},
	{"UNBUNDLE", 8, 253448},
	{"UNBUILT", 7, 207192},
	{"UNBUFFERED", 10, 85829},
	{"UNBU", 4, 58113},
	{"UNBROKEN", 8, 73792},
	{"UNBRIDLED", 9, 95454},
	{"UNBREAKABLE", 11, 74315},
	{"UNBREAK", 7, 237573},
	{"UNBRANDED", 9, 59734},
	{"UNBR", 4, 76089},
	{"UNBOXED", 7, 105902},
	{"UNBOX", 5, 257159},
	{"UNBOWED", 7, 257142},
	{"UNBOUNDED", 9, 80880},
	{"UNBOUND", 7, 53893},
	{"UNBOSSED", 8, 176953},
	{"UNBORN", 6, 59491},
	{"UNBONDED", 8, 86423},
	{"UNBO", 4, 65318},
	{"UNBLOCKING", 10, 161720},
	{"UNBLOCKED", 9, 146162},
	{"UNBLOCK", 7, 124595},
	{"UNBLINKING", 10, 240554},
	{"UNBLEMISHED", 11, 161101},
	{"UNBLEACHED", 10, 122638},
	{"UNBL", 4, 87323},
	{"UNBINDING", 9, 246578},
	{"UNBIND", 6, 162743},
	{"UNBILLED", 8, 208040},
	{"UNBIDDEN", 8, 208365},
	{"UNBIBLICAL", 10, 233797},
	{"UNBIASED", 8, 38165},
	{"UNBI", 4, 96784},
	{"UNBENDING", 9, 221791},
	{"UNBELIEVING", 11, 147672},
	{"UNBELIEVERS", 11, 98028},
	{"UNBELIEVER", 10, 135723},
	{"UNBELIEVEABLE", 13, 177536},
	{"UNBELIEVABLY", 12, 68025},
	{"UNBELIEVABLE", 12, 45061},
	{"UNBELIEF", 8, 105132},
	{"UNBEKNOWNST", 11, 124231},
	{"UNBEKANNT", 9, 212251},
	{"UNBEIGE", 7, 255035},
	{"UNBECOMING", 10, 134927},
	{"UNBEATENS", 9, 252324},
	{"UNBEATEN", 8, 80682},
	{"UNBEATABLESALE", 14, 226169},
	{"UNBEATABLE", 10, 54264},
	{"UNBEARABLY", 10, 153415},
	{"UNBEARABLE", 10, 72169},
	{"UNBE", 4, 41121},
	{"UNBC", 4, 195802},
	{"UNBANKED", 8, 237819},
	{"UNBAN", 5, 115516},
	{"UNBALANCED", 10, 64983},
	{"UNBALANCE", 9, 156016},
	{"UNBAKED", 7, 260650},
	{"UNBA", 4, 55507},
	{"UNAY", 4, 138209},
	{"UNAWARES", 8, 158981},
	{"UNAWARENESS", 11, 237051},
	{"UNAWARE", 7, 46762},
	{"UNAW", 4, 44920},
	{"UNAVOIDABLY", 11, 129150},
	{"UNAVOIDABLE", 11, 61440},
	{"UNAVAILING", 10, 170853},
	{"UNAVAILABLE", 11, 29215},
	{"UNAVAILABILITY", 14, 94008},
	{"UNAVAIL", 7, 257359},
	{"UNAV", 4, 57126},
	{"UNAUTHORIZED", 12, 34702},
	{"UNAUTHORISED", 12, 52839},
	{"UNAUTHENTICATED", 15, 166213},
	{"UNAUDITED", 9, 60253},
	{"UNAU", 4, 73691},
	{"UNATTRIBUTED", 12, 221064},
	{"UNATTRACTIVE", 12, 88167},
	{"UNATTENDED", 10, 61237},
	{"UNATTAINABLE", 12, 111799},
	{"UNATTACHED", 10, 60881},
	{"UNATT", 5, 237734},
	{"UNASSUMING", 10, 109427},
	{"UNASSISTED", 10, 80619},
	{"UNASSIGNED", 10, 61298},
	{"UNASSEMBLED", 11, 148162},
	{"UNASSAILABLE", 12, 158171},
	{"UNASKED", 7, 203380},
	{"UNASHAMEDLY", 11, 177898},
	{"UNASHAMED", 9, 179533},
	{"UNARY", 5, 99391},
	{"UNARMED", 7, 74877},
	{"UNAR", 4, 47366},
	{"UNAPPROVED", 10, 90779},
	{"UNAPPROPRIATED", 14, 173947},
	{"UNAPPROACHABLE", 14, 216184},
	{"UNAPPRECIATED", 13, 160294},
	{"UNAPPEALING", 11, 149891},
	{"UNAPOLOGETICALLY", 16, 211133},
	{"UNAPOLOGETIC", 12, 151652},
	{"UNAPIX", 6, 248011},
	{"UNAP", 4, 71399},
	{"UNANTICIPATED", 13, 78350},
	{"UNANSWERED", 10, 49802},
	{"UNANSWERABLE", 12, 175529},
	{"UNANNOUNCED", 11, 96228},
	{"UNANNOTATED", 11, 75710},
	{"UNANIMOUSLY", 11, 42912},
	{"UNANIMOUS", 9, 44881},
	{"UNANIMITY", 9, 105507},
	{"UNANI", 5, 233716},
	{"UNANET", 6, 211226},
	{"UNAMSIL", 7, 195618},
	{"UNAMORTIZED", 11, 175327},
	{"UNAMERICAN", 10, 204812},
	{"UNAMENDED", 9, 246277},
	{"UNAME", 5, 76526},
	{"UNAMBIGUOUSLY", 13, 91348},
	{"UNAMBIGUOUS", 11, 70986},
	{"UNAM", 4, 124131},
	{"UNALTERED", 9, 86629},
	{"UNALTERABLE", 11, 177058},
	{"UNALLOYED", 9, 230215},
	{"UNALLOWABLE", 11, 145656},
	{"UNALLOCATED", 11, 88902},
	{"UNALIGNED", 9, 144943},
	{"UNALIENABLE", 11, 155134},
	{"UNALASKA", 8, 187570},
	{"UNALAKLEET", 10, 197068},
	{"UNAK", 4, 108885},
	{"UNAJ", 4, 243321},
	{"UNAIRED", 7, 226412},
	{"UNAIDS", 6, 82073},
	{"UNAIDED", 7, 113093},
	{"UNAG", 4, 65663},
	{"UNAFRAID", 8, 128700},
	{"UNAFFORDABLE", 12, 140014},
	{"UNAFFILIATED", 12, 92319},
	{"UNAFFECTED", 10, 58235},
	{"UNAF", 4, 62193},
	{"UNADVERTISED", 12, 170399},
	{"UNADULTERATED", 13, 119332},
	{"UNADORNED", 9, 154009},
	{"UNADJUSTED", 10, 102445},
	{"UNADILLA", 8, 156720},
	{"UNADDRESSED", 11, 156677},
	{"UNAD", 4, 77894},
	{"UNACQUAINTED", 12, 212039},
	{"UNACKNOWLEDGED", 14, 130235},
	{"UNACHIEVABLE", 12, 212152},
	{"UNACCUSTOMED", 12, 147642},
	{"UNACCOUNTED", 11, 105948},
	{"UNACCOUNTABLY", 13, 253694},
	{"UNACCOUNTABLE", 13, 121489},
	{"UNACCOMPANIED", 13, 87457},
	{"UNACCEPTABLY", 12, 119346},
	{"UNACCEPTABLE", 12, 42175},
	{"UNAC", 4, 189738},
	{"UNABRIDGED", 10, 48951},
	{"UNABOMBER", 9, 189138},
	{"UNABLE", 6, 6803},
	{"UNABATED", 8, 110362},
	{"UNABASHEDLY", 11, 137922},
	{"UNABASHED", 9, 122441},
	{"UMZ", 3, 42501},
	{"UMYT", 4, 181127},
	{"UMYO", 4, 128898},
	{"UMYE", 4, 152460},
	{"UMYA", 4, 211074},
	{"UMY", 3, 5772},
	{"UMWR", 4, 193476},
	{"UMWO", 4, 84624},
	{"UMWI", 4, 51761},
	{"UMWH", 4, 50105},
	{"UMWELT", 6, 131254},
	{"UMWE", 4, 74767},
	{"UMWA", 4, 222738},
	{"UMW", 3, 150932},
	{"UMVO", 4, 154512},
	{"UMVI", 4, 96250},
	{"UMVE", 4, 77511},
	{"UMVA", 4, 130227},
	{"UMV", 3, 3244},
	{"UMUS", 4, 48862},
	{"UMUR", 4, 140371},
	{"UMUP", 4, 102562},
	{"UMUN", 4, 88183},
	{"UMUL", 4, 44087},
	{"UMUD", 4, 241591},
	{"UMUC", 4, 167121},
	{"UMUA", 4, 217262},
	{"UMTW", 4, 185101},
	{"UMTU", 4, 111750},
	{"UMTS", 4, 62103},
	{"UMTR", 4, 84402},
	{"UMTO", 4, 46527},
	{"UMTI", 4, 97971},
	{"UMTH", 4, 40112},
	{"UMTE", 4, 71461},
	{"UMTATA", 6, 181805},
	{"UMSY", 4, 88254},
	{"UMSW", 4, 62610},
	{"UMSV", 4, 204858},
	{"UMST", 4, 34754},
	{"UMSS", 4, 74821},
	{"UMSR", 4, 95291},
	{"UMSP", 4, 64817},
	{"UMSONST", 7, 98607},
	{"UMSO", 4, 51462},
	{"UMSN", 4, 131419},
	{"UMSM", 4, 95381},
	{"UMSL", 4, 212256},
	{"UMSK", 4, 156952},
	{"UMSJ", 4, 237680},
	{"UMSIC", 5, 213182},
	{"UMSI", 4, 50661},
	{"UMSH", 4, 64016},
	{"UMSF", 4, 66772},
	{"UMSE", 4, 51725},
	{"UMSDOS", 6, 238344},
	{"UMSD", 4, 97890},
	{"UMSC", 4, 65726},
	{"UMSB", 4, 81858},
	{"UMSA", 4, 42242},
	{"UMRU", 4, 145960},
	{"UMRS", 4, 212797},
	{"UMRO", 4, 98698},
	{"UMRI", 4, 110790},
	{"UMRE", 4, 53558},
	{"UMRAH", 5, 151776},
	{"UMRA", 4, 174117},
	{"UMR", 3, 93715},
	{"UMQU", 4, 137089},
	{"UMQI", 4, 246626},
	{"UMQ", 3, 33995},
	{"UMPY", 4, 76211},
	{"UMPW", 4, 75729},
	{"UMPV", 4, 185234},
	{"UMPU", 4, 64470},
	{"UMPTEENTH", 9, 184079},
	{"UMPTEEN", 7, 189899},
	{"UMPT", 4, 33708},
	{"UMPS", 4, 254409},
	{"UMPR", 4, 54612},
	{"UMPQUA", 6, 117216},
	{"UMPQ", 4, 239043},
	{"UMPP", 4, 95857},
	{"UMPO", 4, 49720},
	{"UMPN", 4, 161681},
	{"UMPM", 4, 101568},
	{"UMPL", 4, 66531},
	{"UMPK", 4, 68401},
	{"UMPJ", 4, 170986},
	{"UMPIRING", 8, 147742},
	{"UMPIRES", 7, 72281},
	{"UMPIRE", 6, 67179},
	{"UMPI", 4, 33931},
	{"UMPHREY", 7, 150770},
	{"UMPG", 4, 156238},
	{"UMPF", 4, 75140},
	{"UMPE", 4, 29917},
	{"UMPD", 4, 120644},
	{"UMPC", 4, 85399},
	{"UMPB", 4, 81387},
	{"UMPA", 4, 47877},
	{"UMP", 3, 108534},
	{"UMOX", 4, 172591},
	{"UMOW", 4, 146010},
	{"UMOV", 4, 79570},
	{"UMOUNT", 6, 120804},
	{"UMOU", 4, 44011},
	{"UMOT", 4, 112817},
	{"UMOS", 4, 103770},
	{"UMOR", 4, 249096},
	{"UMOP", 4, 103251},
	{"UMOO", 4, 228972},
	{"UMON", 4, 41565},
	{"UMOM", 4, 201405},
	{"UMOJA", 5, 247379},
	{"UMOI", 4, 216049},
	{"UMOH", 4, 223992},
	{"UMOF", 4, 34372},
	{"UMOD", 4, 162534},
	{"UMOC", 4, 148677},
	{"UMOB", 4, 203976},
	{"UMOA", 4, 176020},
	{"UMNY", 4, 222169},
	{"UMNW", 4, 88678},
	{"UMNU", 4, 76449},
	{"UMNT", 4, 84959},
	{"UMNS", 4, 248372},
	{"UMNR", 4, 147535},
	{"UMNP", 4, 151406},
	{"UMNO", 4, 164455},
	{"UMNN", 4, 220804},
	{"UMNM", 4, 148218},
	{"UMNL", 4, 154641},
	{"UMNI", 4, 41354},
	{"UMNH", 4, 135493},
	{"UMNG", 4, 237064},
	{"UMNF", 4, 96405},
	{"UMNE", 4, 69809},
	{"UMND", 4, 153842},
	{"UMNC", 4, 122504},
	{"UMNB", 4, 119017},
	{"UMNA", 4, 59643},
	{"UMMY", 4, 63554},
	{"UMMU", 4, 106443},
	{"UMMO", 4, 44144},
	{"UMMMM", 5, 123825},
	{"UMMM", 4, 74655},
	{"UMMER", 5, 232047},
	{"UMME", 4, 4925},
	{"UMMC", 4, 207962},
	{"UMMARY", 6, 126409},
	{"UMMAH", 5, 122572},
	{"UMMA", 4, 190322},
	{"UMM", 3, 53785},
	{"UMLU", 4, 219051},
	{"UMLS", 4, 187200},
	{"UMLO", 4, 83734},
	{"UMLI", 4, 72301},
	{"UMLE", 4, 69570},
	{"UMLAUTS", 7, 172413},
	{"UMLAUT", 6, 151284},
	{"UMLA", 4, 72710},
	{"UML", 3, 42643},
	{"UMKU", 4, 232656},
	{"UMKO", 4, 255649},
	{"UMKN", 4, 188289},
	{"UMKLEIDERAUM", 12, 147166},
	{"UMKLEIDEKABINE", 14, 145642},
	{"UMKI", 4, 115471},
	{"UMKE", 4, 178970},
	{"UMKC", 4, 97289},
	{"UMKA", 4, 161849},
	{"UMK", 3, 258752},
	{"UMJU", 4, 139308},
	{"UMJO", 4, 159255},
	{"UMJE", 4, 213615},
	{"UMJA", 4, 163840},
	{"UMJ", 3, 8089},
	{"UMIY", 4, 170093},
	{"UMIX", 4, 195405},
	{"UMIW", 4, 143622},
	{"UMIT", 4, 222482},
	{"UMIST", 5, 112730},
	{"UMIS", 4, 40628},
	{"UMIR", 4, 128089},
	{"UMIP", 4, 131480},
	{"UMIO", 4, 105851},
	{"UMIM", 4, 116495},
	{"UMIL", 4, 52333},
	{"UMIK", 4, 127307},
	{"UMII", 4, 119796},
	{"UMIH", 4, 141422},
	{"UMIG", 4, 43845},
	{"UMIF", 4, 135600},
	{"UMIE", 4, 145676},
	{"UMID", 4, 60490},
	{"UMICORE", 7, 252118},
	{"UMICH", 5, 226860},
	{"UMIC", 4, 113616},
	{"UMIB", 4, 155161},
	{"UMIA", 4, 95062},
	{"UMHY", 4, 150967},
	{"UMHU", 4, 202395},
	{"UMHS", 4, 181069},
	{"UMHO", 4, 81782},
	{"UMHLANGA", 8, 161084},
	{"UMHI", 4, 98430},
	{"UMHE", 4, 65595},
	{"UMHA", 4, 54947},
	{"UMGU", 4, 171775},
	{"UMGR", 4, 97818},
	{"UMGO", 4, 104321},
	{"UMGL", 4, 215460},
	{"UMGI", 4, 166905},
	{"UMGEBUNG", 8, 197954},
	{"UMGE", 4, 122325},
	{"UMGA", 4, 87095},
	{"UMG", 3, 187074},
	{"UMFU", 4, 119543},
	{"UMFRAGEN", 8, 188412},
	{"UMFR", 4, 66733},
	{"UMFO", 4, 48099},
	{"UMFL", 4, 118328},
	{"UMFI", 4, 78988},
	{"UMFE", 4, 83332},
	{"UMFA", 4, 102143},
	{"UMF", 3, 145232},
	{"UMEY", 4, 125016},
	{"UMEX", 4, 86632},
	{"UMEW", 4, 72383},
	{"UMEV", 4, 108481},
	{"UMEU", 4, 149065},
	{"UMET", 4, 43392},
	{"UMESH", 5, 144401},
	{"UMES", 4, 194926},
	{"UMEQ", 4, 234896},
	{"UMEP", 4, 83559},
	{"UMEO", 4, 51495},
	{"UMENT", 5, 249419},
	{"UMEN", 4, 4045},
	{"UMEM", 4, 71462},
	{"UMEL", 4, 79683},
	{"UMEJ", 4, 187462},
	{"UMEI", 4, 57748},
	{"UMEH", 4, 78261},
	{"UMEG", 4, 131158},
	{"UMEF", 4, 80735},
	{"UMEE", 4, 81216},
	{"UMEDA", 5, 194991},
	{"UMED", 4, 32656},
	{"UMEC", 4, 72554},
	{"UMEB", 4, 91526},
	{"UMEA", 4, 167180},
	{"UMDU", 4, 103735},
	{"UMDS", 4, 105899},
	{"UMDR", 4, 118588},
	{"UMDO", 4, 83461},
	{"UMDNJ", 5, 128006},
	{"UMDI", 4, 71030},
	{"UMDE", 4, 63220},
	{"UMDA", 4, 102111},
	{"UMD", 3, 44601},
	{"UMCY", 4, 257395},
	{"UMCU", 4, 130123},
	{"UMCR", 4, 106420},
	{"UMCP", 4, 128521},
	{"UMCOR", 5, 137647},
	{"UMCO", 4, 47463},
	{"UMCL", 4, 91433},
	{"UMCI", 4, 90900},
	{"UMCH", 4, 68165},
	{"UMCE", 4, 127615},
	{"UMCA", 4, 57946},
	{"UMC", 3, 68662},
	{"UMBY", 4, 71317},
	{"UMBW", 4, 146632},
	{"UMBU", 4, 42128},
	{"UMBT", 4, 89627},
	{"UMBRO", 5, 68362},
	{"UMBRIAN", 7, 212961},
	{"UMBRIA", 6, 73067},
	{"UMBRELLO", 8, 168253},
	{"UMBRELLAS", 9, 54062},
	{"UMBRELLA", 8, 38415},
	{"UMBRAL", 6, 219866},
	{"UMBRAGE", 7, 193850},
	{"UMBRA", 5, 96088},
	{"UMBR", 4, 49872},
	{"UMBP", 4, 147932},
	{"UMBO", 4, 53266},
	{"UMBN", 4, 114210},
	{"UMBM", 4, 181000},
	{"UMBL", 4, 30698},
	{"UMBILICUS", 9, 222355},
	{"UMBILICAL", 9, 67475},
	{"UMBH", 4, 151658},
	{"UMBF", 4, 133230},
	{"UMBERTO", 7, 89998},
	{"UMBERGER", 8, 260245},
	{"UMBER", 5, 100425},
	{"UMBE", 4, 2066},
	{"UMBD", 4, 151659},
	{"UMBCTAC", 7, 172829},
	{"UMBC", 4, 93399},
	{"UMBB", 4, 130437},
	{"UMBACH", 6, 227999},
	{"UMBA", 4, 41601},
	{"UMB", 3, 114562},
	{"UMAYYAD", 7, 233351},
	{"UMAY", 4, 41591},
	{"UMAX", 4, 72336},
	{"UMAW", 4, 99270},
	{"UMAV", 4, 152530},
	{"UMAU", 4, 114994},
	{"UMATILLA", 8, 92757},
	{"UMAT", 4, 225248},
	{"UMASS", 5, 56748},
	{"UMASK", 5, 104063},
	{"UMART", 5, 220771},
	{"UMAR", 4, 87688},
	{"UMAO", 4, 117428},
	{"UMANSKY", 7, 186757},
	{"UMANA", 5, 256896},
	{"UMAN", 4, 144289},
	{"UMAMI", 5, 209167},
	{"UMAM", 4, 81274},
	{"UMAL", 4, 56188},
	{"UMAK", 4, 53996},
	{"UMAJ", 4, 209492},
	{"UMAIR", 5, 242853},
	{"UMAINE", 6, 188541},
	{"UMAI", 4, 79096},
	{"UMAH", 4, 98977},
	{"UMAGA", 5, 199256},
	{"UMAF", 4, 90758},
	{"UMAE", 4, 166000},
	{"UMAD", 4, 64705},
	{"UMAC", 4, 255360},
	{"UMAB", 4, 49429},
	{"UMAA", 4, 222717},
	{"ULZI", 4, 254604},
	{"ULZE", 4, 147933},
	{"ULZB", 4, 258537},
	{"ULZA", 4, 171289},
	{"ULZ", 3, 7970},
	{"ULYY", 4, 198212},
	{"ULYW", 4, 51615},
	{"ULYV", 4, 137417},
	{"ULYU", 4, 92382},
	{"ULYT", 4, 40500},
	{"ULYSSES", 7, 61782},
	{"ULYSSE", 6, 110025},
	{"ULYS", 4, 51805},
	{"ULYR", 4, 72057},
	{"ULYP", 4, 65507},
	{"ULYO", 4, 57119},
	{"ULYN", 4, 87705},
	{"ULYM", 4, 70884},
	{"ULYL", 4, 82224},
	{"ULYK", 4, 132148},
	{"ULYJ", 4, 105733},
	{"ULYI", 4, 49537},
	{"ULYH", 4, 60784},
	{"ULYG", 4, 89071},
	{"ULYF", 4, 62658},
	{"ULYE", 4, 67728},
	{"ULYD", 4, 69562},
	{"ULYC", 4, 64067},
	{"ULYB", 4, 56787},
	{"ULYANOVSK", 9, 235686},
	{"ULYA", 4, 37201},
	{"ULY", 3, 155505},
	{"ULWR", 4, 160242},
	{"ULWO", 4, 67695},
	{"ULWI", 4, 58814},
	{"ULWH", 4, 61911},
	{"ULWE", 4, 74834},
	{"ULWA", 4, 58482},
	{"ULW", 3, 1183},
	{"ULVO", 4, 108913},
	{"ULVI", 4, 84590},
	{"ULVERSTONE", 10, 206146},
	{"ULVERSTON", 9, 141306},
	{"ULVER", 5, 230146},
	{"ULVE", 4, 68727},
	{"ULV", 3, 157865},
	{"ULUW", 4, 147268},
	{"ULUT", 4, 91738},
	{"ULUSABA", 7, 222595},
	{"ULURU", 5, 126415},
	{"ULUR", 4, 155911},
	{"ULUP", 4, 134182},
	{"ULUO", 4, 188290},
	{"ULUNDI", 6, 245344},
	{"ULUN", 4, 80763},
	{"ULUL", 4, 144769},
	{"ULUK", 4, 180560},
	{"ULUH", 4, 146128},
	{"ULUG", 4, 221228},
	{"ULUF", 4, 212410},
	{"ULUDAG", 6, 214942},
	{"ULUD", 4, 172773},
	{"ULUC", 4, 143576},
	{"ULUB", 4, 174859},
	{"ULUA", 4, 101751},
	{"ULU", 3, 114032},
	{"ULTZ", 4, 75096},
	{"ULTY", 4, 201116},
	{"ULTW", 4, 44372},
	{"ULTV", 4, 105497},
	{"ULTU", 4, 4616},
	{"ULTT", 4, 29136},
	{"ULTRON", 6, 188656},
	{"ULTRIX", 6, 129421},
	{"ULTRIUM", 7, 93042},
	{"ULTRIK", 6, 177248},
	{"ULTRICES", 8, 259854},
	{"ULTREX", 6, 247783},
	{"ULTRAWIDEBAND", 13, 192259},
	{"ULTRAVOX", 8, 163983},
	{"ULTRAVISION", 11, 222105},
	{"ULTRAVIOLET", 11, 48122},
	{"ULTRATHIN", 9, 153836},
	{"ULTRATECH", 9, 204464},
	{"ULTRATEC", 8, 133697},
	{"ULTRASUEDE", 10, 229728},
	{"ULTRASTRUCTURE", 14, 65634},
	{"ULTRASTRUCTURAL", 15, 110579},
	{"ULTRASTAR", 9, 148838},
	{"ULTRASPARC", 10, 91201},
	{"ULTRASOUNDS", 11, 141036},
	{"ULTRASOUND", 10, 40677},
	{"ULTRASONOGRAPHY", 15, 76698},
	{"ULTRASONOGRAPHIC", 16, 225242},
	{"ULTRASONICS", 11, 128831},
	{"ULTRASONIC", 10, 51711},
	{"ULTRASONE", 9, 186839},
	{"ULTRASOFT", 9, 196098},
	{"ULTRASLIM", 9, 260430},
	{"ULTRASHORT", 10, 202679},
	{"ULTRASHARP", 10, 110193},
	{"ULTRASEEK", 9, 188686},
	{"ULTRASCSI", 9, 245831},
	{"ULTRAS", 6, 172362},
	{"ULTRAPURE", 9, 195635},
	{"ULTRAPRO", 8, 206817},
	{"ULTRAPORTABLE", 13, 148132},
	{"ULTRAMODERN", 11, 181295},
	{"ULTRAMOBILE", 11, 146870},
	{"ULTRAMIX", 8, 177095},
	{"ULTRAMARINE", 11, 124425},
	{"ULTRAMAN", 8, 124013},
	{"ULTRAMAGNETIC", 13, 257901},
	{"ULTRAMAFIC", 10, 196899},
	{"ULTRAM", 6, 36471},
	{"ULTRALOW", 8, 258809},
	{"ULTRALITE", 9, 120082},
	{"ULTRALINK", 9, 173098},
	{"ULTRALINGUA", 11, 218792},
	{"ULTRALIGHTS", 11, 193360},
	{"ULTRALIGHT", 10, 77164},
	{"ULTRALIFE", 9, 166199},
	{"ULTRALAST", 9, 145563},
	{"ULTRALAB", 8, 210846},
	{"ULTRAISO", 8, 199653},
	{"ULTRAHIGH", 9, 153361},
	{"ULTRAFLEX", 9, 187529},
	{"ULTRAFINE", 9, 142471},
	{"ULTRAFILTRATION", 15, 139964},
	{"ULTRAFAST", 9, 114135},
	{"ULTRAEDIT", 9, 131961},
	{"ULTRADNS", 8, 205811},
	{"ULTRADEV", 8, 86442},
	{"ULTRACOMPACT", 12, 190456},
	{"ULTRACOLD", 9, 250281},
	{"ULTRACHROME", 11, 172310},
	{"ULTRACET", 8, 58161},
	{"ULTRACENTRIFUGATION", 19, 205683},
	{"ULTRABEAT", 9, 247649},
	{"ULTRABAY", 8, 171253},
	{"ULTRA", 5, 5550},
	{"ULTR", 4, 235439},
	{"ULTQ", 4, 161447},
	{"ULTP", 4, 58721},
	{"ULTO", 4, 8760},
	{"ULTN", 4, 81783},
	{"ULTM", 4, 56585},
	{"ULTL", 4, 62581},
	{"ULTK", 4, 144141},
	{"ULTJ", 4, 118658},
	{"ULTIMOS", 7, 244613},
	{"ULTIMO", 6, 86864},
	{"ULTIMI", 6, 157566},
	{"ULTIMELE", 8, 249338},
	{"ULTIME", 6, 130422},
	{"ULTIMATUM", 9, 92391},
	{"ULTIMATETV", 10, 241269},
	{"ULTIMATES", 9, 152195},
	{"ULTIMATELY", 10, 5489},
	{"ULTIMATEBET", 11, 199079},
	{"ULTIMATE", 8, 8358},
	{"ULTIMAS", 7, 205652},
	{"ULTIMA", 6, 50471},
	{"ULTI", 4, 129918},
	{"ULTH", 4, 35778},
	{"ULTG", 4, 89721},
	{"ULTF", 4, 42859},
	{"ULTERIOR", 8, 119770},
	{"ULTEGRA", 7, 131190},
	{"ULTE", 4, 30477},
	{"ULTD", 4, 64322},
	{"ULTC", 4, 48914},
	{"ULTB", 4, 52646},
	{"ULTA", 4, 193570},
	{"ULSY", 4, 160486},
	{"ULSW", 4, 95428},
	{"ULSU", 4, 79369},
	{"ULSTER", 6, 49336},
	{"ULST", 4, 48643},
	{"ULSS", 4, 116196},
	{"ULSR", 4, 160885},
	{"ULSP", 4, 77223},
	{"ULSO", 4, 45730},
	{"ULSN", 4, 180443},
	{"ULSM", 4, 109895},
	{"ULSL", 4, 128264},
	{"ULSK", 4, 134770},
	{"ULSH", 4, 64013},
	{"ULSG", 4, 212621},
	{"ULSF", 4, 136251},
	{"ULSE", 4, 41434},
	{"ULSD", 4, 255553},
	{"ULSC", 4, 74167},
	{"ULSB", 4, 128388},
	{"ULSAN", 5, 176335},
	{"ULRY", 4, 239044},
	{"ULRU", 4, 99899},
	{"ULRS", 4, 238491},
	{"ULRO", 4, 73991},
	{"ULRIKE", 6, 131087},
	{"ULRIKA", 6, 174929},
	{"ULRIK", 5, 194884},
	{"ULRICH", 6, 53114},
	{"ULRIC", 5, 181533},
	{"ULRI", 4, 78680},
	{"ULRH", 4, 258895},
	{"ULRE", 4, 53212},
	{"ULRA", 4, 79362},
	{"ULQU", 4, 129970},
	{"ULQA", 4, 213407},
	{"ULQ", 3, 31789},
	{"ULPW", 4, 240144},
	{"ULPU", 4, 108621},
	{"ULPT", 4, 43119},
	{"ULPS", 4, 148219},
	{"ULPR", 4, 54096},
	{"ULPP", 4, 252148},
	{"ULPO", 4, 71884},
	{"ULPM", 4, 152928},
	{"ULPL", 4, 71743},
	{"ULPI", 4, 65651},
	{"ULPH", 4, 82742},
	{"ULPF", 4, 166813},
	{"ULPE", 4, 58818},
	{"ULP", 3, 123250},
	{"ULOW", 4, 103636},
	{"ULOV", 4, 70743},
	{"ULOU", 4, 37437},
	{"ULOT", 4, 114590},
	{"ULOS", 4, 48774},
	{"ULOR", 4, 78370},
	{"ULOP", 4, 101922},
	{"ULOO", 4, 47870},
	{"ULONG", 5, 95360},
	{"ULON", 4, 58550},
	{"ULOM", 4, 146286},
	{"ULOL", 4, 155295},
	{"ULOK", 4, 207927},
	{"ULOI", 4, 122999},
	{"ULOH", 4, 224198},
	{"ULOGD", 5, 212331},
	{"ULOG", 4, 224970},
	{"ULOF", 4, 39087},
	{"ULOD", 4, 185489},
	{"ULOC", 4, 116396},
	{"ULOB", 4, 133741},
	{"ULOA", 4, 124624},
	{"ULNU", 4, 186380},
	{"ULNO", 4, 78181},
	{"ULNI", 4, 130780},
	{"ULNE", 4, 39070},
	{"ULNAR", 5, 136761},
	{"ULNA", 4, 176059},
	{"ULMY", 4, 239332},
	{"ULMUS", 5, 181389},
	{"ULMU", 4, 81637},
	{"ULMO", 4, 61393},
	{"ULMI", 4, 50488},
	{"ULMER", 5, 106574},
	{"ULME", 4, 60159},
	{"ULMC", 4, 103113},
	{"ULMAN", 5, 241380},
	{"ULMA", 4, 52560},
	{"ULM", 3, 68742},
	{"ULLY", 4, 4981},
	{"ULLW", 4, 54100},
	{"ULLV", 4, 89436},
	{"ULLU", 4, 64599},
	{"ULLT", 4, 34494},
	{"ULLSWATER", 9, 158698},
	{"ULLS", 4, 29650},
	{"ULLRICH", 7, 99827},
	{"ULLQ", 4, 173147},
	{"ULLP", 4, 40987},
	{"ULLOA", 5, 214878},
	{"ULLN", 4, 56856},
	{"ULLMANN", 7, 142474},
	{"ULLMAN", 6, 85803},
	{"ULLM", 4, 48181},
	{"ULLL", 4, 53256},
	{"ULLK", 4, 101776},
	{"ULLJ", 4, 143409},
	{"ULLIN", 5, 204085},
	{"ULLI", 4, 179158},
	{"ULLH", 4, 50308},
	{"ULLG", 4, 63854},
	{"ULLF", 4, 45713},
	{"ULLETIN", 7, 243573},
	{"ULLER", 5, 235081},
	{"ULLE", 4, 7841},
	{"ULLD", 4, 39279},
	{"ULLC", 4, 45538},
	{"ULLB", 4, 40273},
	{"ULLAPOOL", 8, 157018},
	{"ULLAMCORPER", 11, 135725},
	{"ULLAH", 5, 203040},
	{"ULLADULLA", 9, 174191},
	{"ULLA", 4, 109975},
	{"ULL", 3, 114181},
	{"ULKY", 4, 108794},
	{"ULKW", 4, 148954},
	{"ULKU", 4, 157046},
	{"ULKT", 4, 151341},
	{"ULKS", 4, 111573},
	{"ULKR", 4, 140574},
	{"ULKP", 4, 206435},
	{"ULKO", 4, 58108},
	{"ULKN", 4, 96009},
	{"ULKM", 4, 195694},
	{"ULKL", 4, 195254},
	{"ULKI", 4, 74450},
	{"ULKH", 4, 99352},
	{"ULKF", 4, 188708},
	{"ULKE", 4, 85336},
	{"ULKD", 4, 205021},
	{"ULKC", 4, 160405},
	{"ULKB", 4, 198213},
	{"ULKA", 4, 72966},
	{"ULJU", 4, 143048},
	{"ULJO", 4, 93758},
	{"ULJE", 4, 182870},
	{"ULJA", 4, 102591},
	{"ULJ", 3, 4145},
	{"ULIZ", 4, 261200},
	{"ULIY", 4, 248816},
	{"ULIW", 4, 154900},
	{"ULIV", 4, 71345},
	{"ULIU", 4, 66819},
	{"ULITSA", 6, 256489},
	{"ULITMATE", 8, 214949},
	{"ULISES", 6, 249668},
	{"ULIR", 4, 167329},
	{"ULIP", 4, 92524},
	{"ULIO", 4, 76770},
	{"ULINE", 5, 163866},
	{"ULIMIT", 6, 170389},
	{"ULIM", 4, 89975},
	{"ULIL", 4, 179664},
	{"ULIKE", 5, 149287},
	{"ULIK", 4, 49585},
	{"ULII", 4, 92759},
	{"ULIH", 4, 153311},
	{"ULIG", 4, 156239},
	{"ULIF", 4, 77341},
	{"ULIE", 4, 43915},
	{"ULID", 4, 118483},
	{"ULIC", 4, 64289},
	{"ULIB", 4, 108421},
	{"ULIA", 4, 38239},
	{"ULHU", 4, 102183},
	{"ULHO", 4, 77487},
	{"ULHI", 4, 96682},
	{"ULHE", 4, 67991},
	{"ULHA", 4, 54661},
	{"ULGU", 4, 124625},
	{"ULGR", 4, 88516},
	{"ULGO", 4, 90720},
	{"ULGL", 4, 216454},
	{"ULGI", 4, 80264},
	{"ULGH", 4, 184478},
	{"ULGE", 4, 52024},
	{"ULGA", 4, 42404},
	{"ULG", 3, 230909},
	{"ULFW", 4, 86054},
	{"ULFU", 4, 71414},
	{"ULFT", 4, 123907},
	{"ULFS", 4, 80405},
	{"ULFR", 4, 78473},
	{"ULFP", 4, 159565},
	{"ULFO", 4, 40472},
	{"ULFN", 4, 246329},
	{"ULFM", 4, 220178},
	{"ULFL", 4, 107800},
	{"ULFI", 4, 39719},
	{"ULFH", 4, 168365},
	{"ULFG", 4, 251463},
	{"ULFF", 4, 125307},
	{"ULFE", 4, 77871},
	{"ULFD", 4, 202761},
	{"ULFC", 4, 70618},
	{"ULFB", 4, 134059},
	{"ULFA", 4, 213340},
	{"ULF", 3, 84759},
	{"ULEZ", 4, 208922},
	{"ULEW", 4, 57768},
	{"ULEV", 4, 251751},
	{"ULEU", 4, 117528},
	{"ULET", 4, 42316},
	{"ULES", 4, 158163},
	{"ULER", 4, 41795},
	{"ULEP", 4, 87503},
	{"ULEO", 4, 45794},
	{"ULEN", 4, 211884},
	{"ULEMA", 5, 202533},
	{"ULEM", 4, 71327},
	{"ULEL", 4, 84038},
	{"ULEK", 4, 160179},
	{"ULEJ", 4, 200913},
	{"ULEI", 4, 48719},
	{"ULEH", 4, 81561},
	{"ULEG", 4, 110543},
	{"ULEF", 4, 60849},
	{"ULED", 4, 225485},
	{"ULEC", 4, 69224},
	{"ULEB", 4, 204578},
	{"ULEAD", 5, 64056},
	{"ULEA", 4, 41582},
	{"ULDY", 4, 41034},
	{"ULDW", 4, 33632},
	{"ULDV", 4, 46001},
	{"ULDU", 4, 42072},
	{"ULDT", 4, 7571},
	{"ULDS", 4, 5572},
	{"ULDR", 4, 8424},
	{"ULDQ", 4, 81925},
	{"ULDP", 4, 9227},
	{"ULDO", 4, 34176},
	{"ULDN", 4, 2695},
	{"ULDM", 4, 30451},
	{"ULDL", 4, 8596},
	{"ULDK", 4, 46867},
	{"ULDJ", 4, 48978},
	{"ULDI", 4, 31109},
	{"ULDH", 4, 3146},
	{"ULDG", 4, 10143},
	{"ULDF", 4, 32133},
	{"ULDE", 4, 7114},
	{"ULDD", 4, 28998},
	{"ULDC", 4, 7806},
	{"ULDB", 4, 1680},
	{"ULDA", 4, 6577},
	{"ULD", 3, 177441},
	{"ULCU", 4, 130888},
	{"ULCR", 4, 91205},
	{"ULCO", 4, 47672},
	{"ULCL", 4, 104706},
	{"ULCI", 4, 98762},
	{"ULCH", 4, 58982},
	{"ULCERS", 6, 55809},
	{"ULCERATIVE", 10, 84008},
	{"ULCERATIONS", 11, 242896},
	{"ULCERATION", 10, 115623},
	{"ULCERATED", 9, 253152},
	{"ULCER", 5, 55618},
	{"ULCE", 4, 86572},
	{"ULCA", 4, 48187},
	{"ULC", 3, 130113},
	{"ULBY", 4, 99402},
	{"ULBW", 4, 238767},
	{"ULBU", 4, 56440},
	{"ULBT", 4, 241866},
	{"ULBS", 4, 77641},
	{"ULBRICH", 7, 244069},
	{"ULBR", 4, 75762},
	{"ULBO", 4, 80396},
	{"ULBL", 4, 104114},
	{"ULBI", 4, 91755},
	{"ULBE", 4, 59610},
	{"ULBA", 4, 66002},
	{"ULB", 3, 148496},
	{"ULAZ", 4, 141006},
	{"ULAV", 4, 111469},
	{"ULAU", 4, 89188},
	{"ULATIONS", 8, 185174},
	{"ULATION", 7, 131445},
	{"ULATED", 6, 244155},
	{"ULAT", 4, 2058},
	{"ULARLY", 6, 237799},
	{"ULAR", 4, 123824},
	{"ULAP", 4, 79471},
	{"ULAO", 4, 63076},
	{"ULAN", 4, 134871},
	{"ULAMA", 5, 174009},
	{"ULAM", 4, 241960},
	{"ULAL", 4, 64989},
	{"ULAK", 4, 106421},
	{"ULAJ", 4, 192344},
	{"ULAI", 4, 59918},
	{"ULAH", 4, 79340},
	{"ULAG", 4, 76367},
	{"ULAF", 4, 69355},
	{"ULAE", 4, 99006},
	{"ULAD", 4, 75358},
	{"ULAC", 4, 53661},
	{"ULAB", 4, 63637},
	{"ULAANBAATAR", 11, 144259},
	{"ULAAN", 5, 236145},
	{"UKZ", 3, 62995},
	{"UKYU", 4, 166001},
	{"UKYO", 4, 232709},
	{"UKYI", 4, 159179},
	{"UKYA", 4, 129482},
	{"UKY", 3, 7716},
	{"UKWW", 4, 223235},
	{"UKWU", 4, 210104},
	{"UKWO", 4, 193780},
	{"UKWI", 4, 115524},
	{"UKWH", 4, 111104},
	{"UKWE", 4, 152661},
	{"UKWA", 4, 114835},
	{"UKW", 3, 255599},
	{"UKVI", 4, 227208},
	{"UKVE", 4, 200182},
	{"UKV", 3, 36542},
	{"UKUY", 4, 241867},
	{"UKUW", 4, 259651},
	{"UKUT", 4, 189286},
	{"UKUS", 4, 110654},
	{"UKUR", 4, 119573},
	{"UKUP", 4, 246939},
	{"UKUO", 4, 131948},
	{"UKUN", 4, 104565},
	{"UKUM", 4, 155781},
	{"UKULELES", 8, 226629},
	{"UKULELE", 7, 82292},
	{"UKUL", 4, 132388},
	{"UKUK", 4, 161970},
	{"UKUI", 4, 173512},
	{"UKUD", 4, 121102},
	{"UKUB", 4, 241868},
	{"UKUA", 4, 171958},
	{"UKU", 3, 261358},
	{"UKTV", 4, 95236},
	{"UKTU", 4, 164011},
	{"UKTR", 4, 188709},
	{"UKTO", 4, 91933},
	{"UKTH", 4, 84181},
	{"UKTE", 4, 179557},
	{"UKTA", 4, 153394},
	{"UKSW", 4, 254923},
	{"UKSU", 4, 163141},
	{"UKST", 4, 133355},
	{"UKSS", 4, 198515},
	{"UKSP", 4, 171099},
	{"UKSO", 4, 155425},
	{"UKSM", 4, 223068},
	{"UKSL", 4, 187994},
	{"UKSI", 4, 101335},
	{"UKSH", 4, 136671},
	{"UKSF", 4, 160487},
	{"UKSE", 4, 104492},
	{"UKSCRAPPERS", 11, 148842},
	{"UKSC", 4, 170884},
	{"UKSB", 4, 216652},
	{"UKRPROMR", 8, 141401},
	{"UKRO", 4, 217263},
	{"UKRI", 4, 152389},
	{"UKRE", 4, 107612},
	{"UKRANIAN", 8, 64257},
	{"UKRAINIANS", 10, 105702},
	{"UKRAINIAN", 9, 38127},
	{"UKRAINE", 7, 7782},
	{"UKRAINA", 7, 171242},
	{"UKRAIN", 6, 189315},
	{"UKRA", 4, 43924},
	{"UKR", 3, 90818},
	{"UKQ", 3, 92783},
	{"UKPU", 4, 244522},
	{"UKPR", 4, 143256},
	{"UKPO", 4, 160886},
	{"UKPE", 4, 221507},
	{"UKPA", 4, 149738},
	{"UKP", 3, 161234},
	{"UKOW", 4, 146011},
	{"UKOV", 4, 90413},
	{"UKOU", 4, 156322},
	{"UKOT", 4, 165243},
	{"UKOS", 4, 135944},
	{"UKOR", 4, 126772},
	{"UKOP", 4, 230587},
	{"UKOO", 4, 257396},
	{"UKOM", 4, 205562},
	{"UKOLN", 5, 215718},
	{"UKOL", 4, 252149},
	{"UKOK", 4, 232657},
	{"UKOI", 4, 157383},
	{"UKOF", 4, 154122},
	{"UKOC", 4, 219052},
	{"UKOA", 4, 193172},
	{"UKO", 3, 1756},
	{"UKNO", 4, 30810},
	{"UKNE", 4, 94544},
	{"UKNA", 4, 189017},
	{"UKMU", 4, 248160},
	{"UKMI", 4, 183491},
	{"UKME", 4, 204659},
	{"UKMA", 4, 120904},
	{"UKM", 3, 191105},
	{"UKLUG", 5, 114027},
	{"UKLU", 4, 145856},
	{"UKLO", 4, 244806},
	{"UKLI", 4, 189167},
	{"UKLE", 4, 179978},
	{"UKL", 3, 163475},
	{"UKKU", 4, 197113},
	{"UKKO", 4, 159887},
	{"UKKI", 4, 217706},
	{"UKKE", 4, 249121},
	{"UKKA", 4, 103695},
	{"UKK", 3, 6251},
	{"UKJ", 3, 42416},
	{"UKIYO", 5, 173790},
	{"UKIY", 4, 175623},
	{"UKIW", 4, 127019},
	{"UKIT", 4, 83766},
	{"UKIS", 4, 71783},
	{"UKIR", 4, 148898},
	{"UKIP", 4, 140939},
	{"UKIO", 4, 140160},
	{"UKIN", 4, 61811},
	{"UKIM", 4, 121737},
	{"UKIL", 4, 85920},
	{"UKIK", 4, 152531},
	{"UKII", 4, 126475},
	{"UKIH", 4, 141096},
	{"UKIG", 4, 239593},
	{"UKIF", 4, 170885},
	{"UKIE", 4, 144688},
	{"UKID", 4, 115774},
	{"UKIC", 4, 129875},
	{"UKIB", 4, 177715},
	{"UKIAH", 5, 86835},
	{"UKIA", 4, 85643},
	{"UKHU", 4, 185612},
	{"UKHT", 4, 187312},
	{"UKHR", 4, 226976},
	{"UKHOTEL", 7, 248702},
	{"UKHK", 4, 209105},
	{"UKHI", 4, 123186},
	{"UKHE", 4, 115472},
	{"UKHA", 4, 75055},
	{"UKGO", 4, 123629},
	{"UKGML", 5, 116167},
	{"UKGE", 4, 190200},
	{"UKGA", 4, 245117},
	{"UKG", 3, 156376},
	{"UKFR", 4, 184609},
	{"UKFO", 4, 123561},
	{"UKFI", 4, 200375},
	{"UKFF", 4, 193734},
	{"UKEY", 4, 169993},
	{"UKEXPERT", 8, 147894},
	{"UKEW", 4, 73282},
	{"UKEV", 4, 175367},
	{"UKET", 4, 79267},
	{"UKERNA", 6, 191170},
	{"UKEP", 4, 110446},
	{"UKEO", 4, 53426},
	{"UKEN", 4, 83031},
	{"UKEM", 4, 70023},
	{"UKELELE", 7, 202038},
	{"UKEL", 4, 108305},
	{"UKEK", 4, 155912},
	{"UKEJ", 4, 168186},
	{"UKEI", 4, 85940},
	{"UKEH", 4, 96186},
	{"UKEG", 4, 117995},
	{"UKEF", 4, 100585},
	{"UKEE", 4, 43075},
	{"UKED", 4, 87928},
	{"UKEC", 4, 97224},
	{"UKEB", 4, 86361},
	{"UKEA", 4, 67226},
	{"UKDU", 4, 254605},
	{"UKDO", 4, 209893},
	{"UKDI", 4, 207203},
	{"UKDE", 4, 156323},
	{"UKDA", 4, 217163},
	{"UKCO", 4, 111490},
	{"UKCI", 4, 233508},
	{"UKCE", 4, 227935},
	{"UKCA", 4, 155642},
	{"UKC", 3, 116171},
	{"UKBY", 4, 206628},
	{"UKBU", 4, 160406},
	{"UKBR", 4, 243009},
	{"UKBOOKS", 7, 206730},
	{"UKBO", 4, 221508},
	{"UKBETTING", 9, 118792},
	{"UKBE", 4, 170987},
	{"UKBA", 4, 115751},
	{"UKAY", 4, 216653},
	{"UKAW", 4, 121360},
	{"UKAV", 4, 204137},
	{"UKAU", 4, 151407},
	{"UKATTRACTION", 12, 227276},
	{"UKAT", 4, 178631},
	{"UKAS", 4, 160464},
	{"UKAR", 4, 80169},
	{"UKAP", 4, 158046},
	{"UKAO", 4, 172688},
	{"UKAN", 4, 54667},
	{"UKAM", 4, 122770},
	{"UKAL", 4, 108333},
	{"UKAK", 4, 133231},
	{"UKAJ", 4, 216654},
	{"UKAI", 4, 225763},
	{"UKAH", 4, 140718},
	{"UKAG", 4, 183492},
	{"UKAF", 4, 175624},
	{"UKAEA", 5, 168505},
	{"UKAE", 4, 193477},
	{"UKAD", 4, 158428},
	{"UKAC", 4, 131849},
	{"UKAB", 4, 144240},
	{"UKAA", 4, 112691},
	{"UK", 2, 1009},
	{"UJZ", 3, 230199},
	{"UJY", 3, 72679},
	{"UJW", 3, 74431},
	{"UJV", 3, 116982},
	{"UJUT", 4, 193781},
	{"UJUS", 4, 46575},
	{"UJUN", 4, 148678},
	{"UJUM", 4, 165510},
	{"UJUE", 4, 236734},
	{"UJUD", 4, 202056},
	{"UJU", 3, 1589},
	{"UJRA", 4, 187173},
	{"UJR", 3, 40869},
	{"UJP", 3, 78101},
	{"UJOU", 4, 153650},
	{"UJOS", 4, 217707},
	{"UJON", 4, 218873},
	{"UJOL", 4, 89139},
	{"UJOI", 4, 141782},
	{"UJOH", 4, 202212},
	{"UJO", 3, 3786},
	{"UJM", 3, 77296},
	{"UJL", 3, 104336},
	{"UJK", 3, 81267},
	{"UJJAIN", 6, 219452},
	{"UJJA", 4, 200183},
	{"UJJ", 3, 45263},
	{"UJIW", 4, 138127},
	{"UJIT", 4, 86362},
	{"UJIS", 4, 142194},
	{"UJIR", 4, 172689},
	{"UJIO", 4, 235488},
	{"UJIN", 4, 85568},
	{"UJIM", 4, 130696},
	{"UJIL", 4, 130265},
	{"UJIK", 4, 177175},
	{"UJII", 4, 167409},
	{"UJIH", 4, 231317},
	{"UJIF", 4, 206629},
	{"UJIC", 4, 231572},
	{"UJIB", 4, 184610},
	{"UJIA", 4, 97301},
	{"UJG", 3, 145367},
	{"UJER", 4, 178854},
	{"UJENA", 5, 179748},
	{"UJE", 3, 30673},
	{"UJD", 3, 59373},
	{"UJC", 3, 208229},
	{"UJB", 3, 82143},
	{"UJAW", 4, 220599},
	{"UJAT", 4, 188710},
	{"UJAS", 4, 178523},
	{"UJAR", 4, 78543},
	{"UJAP", 4, 204481},
	{"UJAN", 4, 116154},
	{"UJAM", 4, 162467},
	{"UJAI", 4, 171959},
	{"UJAH", 4, 84515},
	{"UJAD", 4, 258538},
	{"UJAC", 4, 137323},
	{"UJAA", 4, 188560},
	{"UIZZ", 4, 100924},
	{"UIZW", 4, 194213},
	{"UIZT", 4, 188420},
	{"UIZS", 4, 134230},
	{"UIZO", 4, 166627},
	{"UIZM", 4, 241592},
	{"UIZI", 4, 161032},
	{"UIZH", 4, 172483},
	{"UIZF", 4, 221229},
	{"UIZE", 4, 125399},
	{"UIZD", 4, 248161},
	{"UIZC", 4, 232368},
	{"UIZB", 4, 211261},
	{"UIZA", 4, 123470},
	{"UIZ", 3, 2446},
	{"UIYA", 4, 259652},
	{"UIXO", 4, 141850},
	{"UIWO", 4, 196454},
	{"UIWI", 4, 180877},
	{"UIWH", 4, 169994},
	{"UIWA", 4, 119740},
	{"UIVO", 4, 107680},
	{"UIVI", 4, 223300},
	{"UIVE", 4, 109859},
	{"UIVA", 4, 39895},
	{"UIV", 3, 1262},
	{"UIUC", 4, 88696},
	{"UITZ", 4, 247873},
	{"UITW", 4, 56294},
	{"UITV", 4, 142400},
	{"UITU", 4, 100951},
	{"UITSIG", 6, 227813},
	{"UITR", 4, 78060},
	{"UITOOLKIT", 9, 159931},
	{"UITLATEN", 8, 216980},
	{"UITL", 4, 73814},
	{"UITK", 4, 209493},
	{"UITJ", 4, 96270},
	{"UITI", 4, 33126},
	{"UITGEVERS", 9, 256502},
	{"UITGEVER", 8, 148986},
	{"UITGEBREID", 10, 202265},
	{"UITG", 4, 109351},
	{"UITENHAGE", 9, 213652},
	{"UITD", 4, 85658},
	{"UITC", 4, 50870},
	{"UITB", 4, 62014},
	{"UITA", 4, 8633},
	{"UISY", 4, 258155},
	{"UISX", 4, 83964},
	{"UISW", 4, 79054},
	{"UISV", 4, 53637},
	{"UISU", 4, 112269},
	{"UISR", 4, 79896},
	{"UISM", 4, 60326},
	{"UISL", 4, 82275},
	{"UISK", 4, 153454},
	{"UISJ", 4, 136988},
	{"UISI", 4, 29935},
	{"UISH", 4, 33810},
	{"UISG", 4, 101153},
	{"UISF", 4, 89078},
	{"UISE", 4, 31588},
	{"UISD", 4, 80745},
	{"UISC", 4, 62939},
	{"UISB", 4, 71109},
	{"UIRY", 4, 54012},
	{"UIRW", 4, 227209},
	{"UIRT", 4, 115424},
	{"UIRS", 4, 198696},
	{"UIRR", 4, 70272},
	{"UIRO", 4, 146929},
	{"UIRM", 4, 138918},
	{"UIRK", 4, 71685},
	{"UIRI", 4, 41010},
	{"UIRH", 4, 232369},
	{"UIRF", 4, 257026},
	{"UIRE", 4, 3417},
	{"UIRA", 4, 134517},
	{"UIPU", 4, 250468},
	{"UIPT", 4, 160648},
	{"UIPS", 4, 137047},
	{"UIPR", 4, 172265},
	{"UIPP", 4, 42361},
	{"UIPO", 4, 197256},
	{"UIPM", 4, 30723},
	{"UIPE", 4, 128199},
	{"UIPA", 4, 144689},
	{"UIOR", 4, 226723},
	{"UIOF", 4, 200184},
	{"UIOC", 4, 237065},
	{"UINZ", 4, 251790},
	{"UINY", 4, 145021},
	{"UINW", 4, 101816},
	{"UINV", 4, 98855},
	{"UINU", 4, 181957},
	{"UINTAH", 6, 142876},
	{"UINTA", 5, 131541},
	{"UINR", 4, 124416},
	{"UINQ", 4, 259653},
	{"UINP", 4, 109843},
	{"UINM", 4, 111531},
	{"UINL", 4, 106672},
	{"UINK", 4, 220369},
	{"UINJ", 4, 164811},
	{"UINF", 4, 104376},
	{"UIND", 4, 87547},
	{"UINC", 4, 56258},
	{"UINB", 4, 106326},
	{"UIMP", 4, 126076},
	{"UIMO", 4, 226724},
	{"UIMM", 4, 182274},
	{"UIMI", 4, 218643},
	{"UIME", 4, 181343},
	{"UIMB", 4, 190488},
	{"UILT", 4, 4155},
	{"UILS", 4, 182395},
	{"UILO", 4, 156240},
	{"UILM", 4, 243621},
	{"UILLEANN", 8, 218587},
	{"UILL", 4, 46088},
	{"UILI", 4, 60605},
	{"UILH", 4, 214408},
	{"UILF", 4, 119544},
	{"UILDING", 7, 195834},
	{"UILC", 4, 251464},
	{"UILB", 4, 241869},
	{"UILA", 4, 69337},
	{"UIKS", 4, 196153},
	{"UIKO", 4, 154238},
	{"UIKE", 4, 188421},
	{"UIKA", 4, 237066},
	{"UIK", 3, 8587},
	{"UIJA", 4, 197577},
	{"UIJ", 3, 33188},
	{"UIGO", 4, 208503},
	{"UIGN", 4, 155366},
	{"UIGL", 4, 142338},
	{"UIGI", 4, 98911},
	{"UIGHURS", 7, 234673},
	{"UIGHUR", 6, 117686},
	{"UIGH", 4, 124710},
	{"UIGG", 4, 185744},
	{"UIGA", 4, 135067},
	{"UIFY", 4, 112643},
	{"UIFT", 4, 200914},
	{"UIFO", 4, 181591},
	{"UIFI", 4, 157173},
	{"UIFE", 4, 108088},
	{"UIFA", 4, 185868},
	{"UIER", 4, 125056},
	{"UIEM", 4, 119225},
	{"UIEL", 4, 193628},
	{"UIDY", 4, 243322},
	{"UIDW", 4, 97324},
	{"UIDU", 4, 217264},
	{"UIDT", 4, 103037},
	{"UIDS", 4, 151435},
	{"UIDR", 4, 132179},
	{"UIDP", 4, 111929},
	{"UIDO", 4, 74960},
	{"UIDN", 4, 163039},
	{"UIDM", 4, 117163},
	{"UIDL", 4, 213379},
	{"UIDI", 4, 47488},
	{"UIDH", 4, 133232},
	{"UIDG", 4, 198516},
	{"UIDF", 4, 98651},
	{"UIDELINES", 9, 227332},
	{"UIDE", 4, 156867},
	{"UIDD", 4, 114960},
	{"UIDC", 4, 95839},
	{"UIDB", 4, 135681},
	{"UIDA", 4, 42899},
	{"UICY", 4, 102144},
	{"UICONSTRAINTS", 13, 94867},
	{"UICO", 4, 131897},
	{"UICH", 4, 83320},
	{"UICE", 4, 51078},
	{"UICC", 4, 153763},
	{"UICA", 4, 157315},
	{"UIBU", 4, 237975},
	{"UIBO", 4, 240456},
	{"UIBI", 4, 239333},
	{"UIBE", 4, 172690},
	{"UIBB", 4, 136544},
	{"UIBA", 4, 197906},
	{"UIAR", 4, 153530},
	{"UIAP", 4, 239861},
	{"UIAM", 4, 198067},
	{"UIAL", 4, 86587},
	{"UHYI", 4, 203618},
	{"UHYA", 4, 254228},
	{"UHY", 3, 33498},
	{"UHWA", 4, 233231},
	{"UHURU", 5, 125584},
	{"UHURA", 5, 225469},
	{"UHUR", 4, 146930},
	{"UHUN", 4, 168281},
	{"UHUM", 4, 259283},
	{"UHUA", 4, 183124},
	{"UHTC", 4, 223276},
	{"UHRM", 4, 196154},
	{"UHRICHSVILLE", 12, 257569},
	{"UHRI", 4, 216655},
	{"UHREN", 5, 217565},
	{"UHRE", 4, 194965},
	{"UHRDE", 5, 130074},
	{"UHRA", 4, 181001},
	{"UHOW", 4, 77998},
	{"UHOU", 4, 157604},
	{"UHOR", 4, 229505},
	{"UHOP", 4, 110509},
	{"UHOM", 4, 171290},
	{"UHOL", 4, 106931},
	{"UHOF", 4, 227713},
	{"UHO", 3, 2184},
	{"UHMWPE", 6, 233110},
	{"UHMW", 4, 231760},
	{"UHMM", 4, 250417},
	{"UHMA", 4, 201226},
	{"UHLSPORT", 8, 180007},
	{"UHLS", 4, 244208},
	{"UHLMANN", 7, 228584},
	{"UHLM", 4, 176249},
	{"UHLIG", 5, 214540},
	{"UHLI", 4, 241870},
	{"UHLER", 5, 242653},
	{"UHLENBECK", 9, 248420},
	{"UHLE", 4, 123665},
	{"UHLA", 4, 174761},
	{"UHIR", 4, 139208},
	{"UHIM", 4, 176021},
	{"UHIL", 4, 206840},
	{"UHIK", 4, 162128},
	{"UHIG", 4, 139689},
	{"UHID", 4, 190338},
	{"UHHHH", 5, 203706},
	{"UHFC", 4, 206999},
	{"UHEW", 4, 165915},
	{"UHER", 4, 156516},
	{"UHEM", 4, 252494},
	{"UHEL", 4, 103654},
	{"UHCI", 4, 139923},
	{"UHAY", 4, 210678},
	{"UHAW", 4, 162387},
	{"UHAV", 4, 6731},
	{"UHAUL", 5, 177005},
	{"UHAU", 4, 126984},
	{"UHAR", 4, 72663},
	{"UHAP", 4, 105988},
	{"UHAM", 4, 52663},
	{"UHAL", 4, 144462},
	{"UHAK", 4, 223534},
	{"UHAJ", 4, 249445},
	{"UHAD", 4, 45915},
	{"UGZ", 3, 186603},
	{"UGYO", 4, 171960},
	{"UGY", 3, 36584},
	{"UGX", 3, 173213},
	{"UGWO", 4, 168994},
	{"UGWI", 4, 101274},
	{"UGWH", 4, 107136},
	{"UGWE", 4, 153128},
	{"UGWA", 4, 96553},
	{"UGW", 3, 3490},
	{"UGVI", 4, 207000},
	{"UGUY", 4, 58131},
	{"UGUT", 4, 224635},
	{"UGUST", 5, 196421},
	{"UGUS", 4, 6168},
	{"UGUR", 4, 204225},
	{"UGUP", 4, 127616},
	{"UGUN", 4, 138128},
	{"UGUM", 4, 203280},
	{"UGUL", 4, 131615},
	{"UGUI", 4, 131654},
	{"UGUE", 4, 44961},
	{"UGUD", 4, 254924},
	{"UGUA", 4, 68048},
	{"UGU", 3, 201377},
	{"UGTR", 4, 77333},
	{"UGTO", 4, 93386},
	{"UGTH", 4, 62897},
	{"UGTE", 4, 92994},
	{"UGTA", 4, 157047},
	{"UGSY", 4, 168366},
	{"UGSW", 4, 78137},
	{"UGSU", 4, 123125},
	{"UGST", 4, 57496},
	{"UGSS", 4, 171083},
	{"UGSR", 4, 158718},
	{"UGSP", 4, 113060},
	{"UGSO", 4, 78426},
	{"UGSN", 4, 161213},
	{"UGSM", 4, 102592},
	{"UGSL", 4, 132538},
	{"UGSI", 4, 70629},
	{"UGSH", 4, 81557},
	{"UGSG", 4, 173257},
	{"UGSF", 4, 95226},
	{"UGSE", 4, 110865},
	{"UGSD", 4, 126251},
	{"UGSC", 4, 93589},
	{"UGSB", 4, 82824},
	{"UGSA", 4, 48673},
	{"UGRU", 4, 188877},
	{"UGRO", 4, 104008},
	{"UGRIC", 5, 221271},
	{"UGRI", 4, 124417},
	{"UGRE", 4, 72722},
	{"UGRAVE", 6, 249403},
	{"UGRAD", 5, 219248},
	{"UGRA", 4, 85852},
	{"UGQ", 3, 90595},
	{"UGPU", 4, 230288},
	{"UGPR", 4, 96990},
	{"UGPO", 4, 117613},
	{"UGPM", 4, 173341},
	{"UGPL", 4, 185869},
	{"UGPE", 4, 216261},
	{"UGPA", 4, 103132},
	{"UGOW", 4, 126742},
	{"UGOV", 4, 106363},
	{"UGOU", 4, 68411},
	{"UGOT", 4, 50144},
	{"UGOS", 4, 56002},
	{"UGOR", 4, 108566},
	{"UGOPLAYER", 9, 248697},
	{"UGOP", 4, 145921},
	{"UGOO", 4, 96527},
	{"UGON", 4, 84233},
	{"UGOM", 4, 197114},
	{"UGOL", 4, 143526},
	{"UGOI", 4, 70313},
	{"UGOH", 4, 158047},
	{"UGOG", 4, 177369},
	{"UGOF", 4, 80265},
	{"UGOE", 4, 182171},
	{"UGOD", 4, 126347},
	{"UGOC", 4, 119677},
	{"UGOB", 4, 105082},
	{"UGOA", 4, 92554},
	{"UGNU", 4, 206630},
	{"UGNO", 4, 169625},
	{"UGNI", 4, 166718},
	{"UGNE", 4, 118534},
	{"UGNA", 4, 122847},
	{"UGMU", 4, 233849},
	{"UGMO", 4, 141053},
	{"UGMI", 4, 181128},
	{"UGME", 4, 66469},
	{"UGMC", 4, 240457},
	{"UGM", 3, 53147},
	{"UGLYDOLL", 8, 250736},
	{"UGLY", 4, 28684},
	{"UGLO", 4, 124817},
	{"UGLINESS", 8, 106811},
	{"UGLIEST", 7, 107602},
	{"UGLIES", 6, 223508},
	{"UGLIER", 6, 143281},
	{"UGLI", 4, 72448},
	{"UGLE", 4, 94274},
	{"UGLA", 4, 42289},
	{"UGKI", 4, 199026},
	{"UGJO", 4, 253892},
	{"UGJ", 3, 41133},
	{"UGIV", 4, 71723},
	{"UGIT", 4, 70558},
	{"UGIS", 4, 90421},
	{"UGIR", 4, 163415},
	{"UGIO", 4, 152390},
	{"UGIN", 4, 49261},
	{"UGIM", 4, 202396},
	{"UGIL", 4, 160584},
	{"UGII", 4, 259284},
	{"UGIF", 4, 258896},
	{"UGIE", 4, 140719},
	{"UGIA", 4, 101350},
	{"UGHZ", 4, 154765},
	{"UGHY", 4, 53240},
	{"UGHX", 4, 225547},
	{"UGHW", 4, 32877},
	{"UGHV", 4, 58773},
	{"UGHU", 4, 56999},
	{"UGHT", 4, 1170},
	{"UGHS", 4, 7472},
	{"UGHR", 4, 39723},
	{"UGHQ", 4, 90288},
	{"UGHP", 4, 36549},
	{"UGHO", 4, 5547},
	{"UGHN", 4, 34204},
	{"UGHM", 4, 31612},
	{"UGHL", 4, 29880},
	{"UGHK", 4, 67185},
	{"UGHJ", 4, 53346},
	{"UGHI", 4, 6636},
	{"UGHG", 4, 45330},
	{"UGHF", 4, 33206},
	{"UGHE", 4, 28606},
	{"UGHD", 4, 39565},
	{"UGHC", 4, 34309},
	{"UGHB", 4, 36283},
	{"UGHA", 4, 5649},
	{"UGGY", 4, 97346},
	{"UGGS", 4, 118136},
	{"UGGR", 4, 215461},
	{"UGGO", 4, 199686},
	{"UGGL", 4, 8345},
	{"UGGI", 4, 49138},
	{"UGGE", 4, 5517},
	{"UGGABUGGA", 9, 165089},
	{"UGGA", 4, 67128},
	{"UGG", 3, 53704},
	{"UGFR", 4, 105826},
	{"UGFO", 4, 104285},
	{"UGFL", 4, 228973},
	{"UGFI", 4, 128090},
	{"UGFE", 4, 159566},
	{"UGFA", 4, 235489},
	{"UGEY", 4, 175368},
	{"UGEX", 4, 236081},
	{"UGEW", 4, 77488},
	{"UGEV", 4, 118176},
	{"UGEU", 4, 128200},
	{"UGET", 4, 34333},
	{"UGESKR", 6, 239212},
	{"UGES", 4, 48251},
	{"UGER", 4, 54477},
	{"UGEQ", 4, 209284},
	{"UGEP", 4, 60284},
	{"UGEO", 4, 69341},
	{"UGEM", 4, 73156},
	{"UGEL", 4, 57182},
	{"UGEK", 4, 185102},
	{"UGEJ", 4, 178180},
	{"UGEI", 4, 58787},
	{"UGEH", 4, 73931},
	{"UGEG", 4, 91021},
	{"UGEF", 4, 62819},
	{"UGEE", 4, 44127},
	{"UGED", 4, 62379},
	{"UGEC", 4, 60480},
	{"UGEB", 4, 67411},
	{"UGEA", 4, 54778},
	{"UGDU", 4, 211262},
	{"UGDO", 4, 182521},
	{"UGDI", 4, 142789},
	{"UGDE", 4, 66768},
	{"UGDA", 4, 170349},
	{"UGCR", 4, 199185},
	{"UGCO", 4, 75799},
	{"UGCL", 4, 237681},
	{"UGCH", 4, 126941},
	{"UGCA", 4, 94248},
	{"UGC", 3, 90519},
	{"UGBY", 4, 44834},
	{"UGBU", 4, 120690},
	{"UGBR", 4, 199530},
	{"UGBO", 4, 129137},
	{"UGBL", 4, 219295},
	{"UGBI", 4, 224636},
	{"UGBE", 4, 116056},
	{"UGBA", 4, 145145},
	{"UGB", 3, 207525},
	{"UGAZ", 4, 219053},
	{"UGAY", 4, 192629},
	{"UGAW", 4, 96665},
	{"UGAV", 4, 111848},
	{"UGAU", 4, 228227},
	{"UGAT", 4, 54863},
	{"UGASHIK", 7, 234674},
	{"UGAS", 4, 167110},
	{"UGARTE", 6, 199309},
	{"UGAR", 4, 34353},
	{"UGAP", 4, 168367},
	{"UGAO", 4, 165916},
	{"UGANDANS", 8, 215021},
	{"UGANDAN", 7, 89891},
	{"UGANDA", 6, 30922},
	{"UGAN", 4, 45989},
	{"UGAM", 4, 102854},
	{"UGAL", 4, 44568},
	{"UGAK", 4, 209683},
	{"UGAI", 4, 98728},
	{"UGAH", 4, 190070},
	{"UGAG", 4, 174549},
	{"UGAF", 4, 158048},
	{"UGAD", 4, 69554},
	{"UGAC", 4, 107094},
	{"UGAB", 4, 63958},
	{"UGAA", 4, 134551},
	{"UFY", 3, 55478},
	{"UFX", 3, 130210},
	{"UFWA", 4, 233509},
	{"UFW", 3, 184404},
	{"UFV", 3, 72284},
	{"UFUS", 4, 101130},
	{"UFUR", 4, 211263},
	{"UFUN", 4, 169706},
	{"UFUL", 4, 204859},
	{"UFTW", 4, 96793},
	{"UFTS", 4, 114288},
	{"UFTO", 4, 206841},
	{"UFTI", 4, 150670},
	{"UFTH", 4, 124711},
	{"UFTE", 4, 226725},
	{"UFSD", 4, 192964},
	{"UFSA", 4, 241298},
	{"UFRO", 4, 64365},
	{"UFRI", 4, 188291},
	{"UFRE", 4, 104493},
	{"UFRA", 4, 140720},
	{"UFR", 3, 233804},
	{"UFQ", 3, 175475},
	{"UFPJ", 4, 232440},
	{"UFP", 3, 208833},
	{"UFOU", 4, 95088},
	{"UFOS", 4, 67533},
	{"UFOO", 4, 129800},
	{"UFON", 4, 229987},
	{"UFOLOGY", 7, 207636},
	{"UFOL", 4, 95639},
	{"UFOC", 4, 237885},
	{"UFOA", 4, 220805},
	{"UFNA", 4, 258156},
	{"UFMA", 4, 85842},
	{"UFM", 3, 217325},
	{"UFLY", 4, 236082},
	{"UFLO", 4, 205194},
	{"UFLI", 4, 205738},
	{"UFLE", 4, 165056},
	{"UFLA", 4, 84462},
	{"UFL", 3, 203328},
	{"UFKI", 4, 137590},
	{"UFK", 3, 34731},
	{"UFJ", 3, 179003},
	{"UFIT", 4, 196298},
	{"UFIS", 4, 109373},
	{"UFIR", 4, 96060},
	{"UFIO", 4, 246940},
	{"UFINDUS", 7, 202919},
	{"UFIN", 4, 55885},
	{"UFIM", 4, 224871},
	{"UFIL", 4, 117947},
	{"UFIG", 4, 105970},
	{"UFIE", 4, 141851},
	{"UFIA", 4, 231831},
	{"UFHA", 4, 226499},
	{"UFG", 3, 244495},
	{"UFFY", 4, 47631},
	{"UFFW", 4, 74091},
	{"UFFV", 4, 253893},
	{"UFFU", 4, 118887},
	{"UFFT", 4, 57804},
	{"UFFS", 4, 50807},
	{"UFFR", 4, 75169},
	{"UFFP", 4, 107996},
	{"UFFO", 4, 52458},
	{"UFFN", 4, 151592},
	{"UFFM", 4, 81319},
	{"UFFL", 4, 47230},
	{"UFFJ", 4, 200557},
	{"UFFIZI", 6, 147326},
	{"UFFICIO", 7, 123798},
	{"UFFICIALE", 9, 141076},
	{"UFFI", 4, 245508},
	{"UFFH", 4, 89208},
	{"UFFG", 4, 125559},
	{"UFFF", 4, 92059},
	{"UFFE", 4, 254851},
	{"UFFD", 4, 120813},
	{"UFFC", 4, 103388},
	{"UFFB", 4, 86342},
	{"UFFA", 4, 38902},
	{"UFF", 3, 147628},
	{"UFES", 4, 240458},
	{"UFEN", 4, 151660},
	{"UFEL", 4, 106673},
	{"UFEI", 4, 229745},
	{"UFEE", 4, 50860},
	{"UFEA", 4, 148386},
	{"UFDE", 4, 254925},
	{"UFD", 3, 215328},
	{"UFCW", 4, 154780},
	{"UFCS", 4, 203977},
	{"UFCO", 4, 219296},
	{"UFCI", 4, 200376},
	{"UFCH", 4, 200185},
	{"UFCF", 4, 226977},
	{"UFCC", 4, 245440},
	{"UFCA", 4, 183847},
	{"UFC", 3, 75256},
	{"UFB", 3, 250},
	{"UFAX", 4, 174956},
	{"UFAV", 4, 258539},
	{"UFAU", 4, 163767},
	{"UFAT", 4, 197421},
	{"UFAR", 4, 143623},
	{"UFAN", 4, 92576},
	{"UFAM", 4, 138355},
	{"UFAL", 4, 117206},
	{"UFAI", 4, 115942},
	{"UFAC", 4, 10065},
	{"UEZW", 4, 83775},
	{"UEZT", 4, 112945},
	{"UEZS", 4, 74522},
	{"UEZR", 4, 151719},
	{"UEZP", 4, 166457},
	{"UEZO", 4, 94624},
	{"UEZN", 4, 248162},
	{"UEZM", 4, 161776},
	{"UEZL", 4, 168623},
	{"UEZJ", 4, 247874},
	{"UEZI", 4, 105137},
	{"UEZH", 4, 105252},
	{"UEZG", 4, 206274},
	{"UEZF", 4, 148168},
	{"UEZE", 4, 165511},
	{"UEZD", 4, 138919},
	{"UEZC", 4, 103517},
	{"UEZB", 4, 152585},
	{"UEZA", 4, 77158},
	{"UEZ", 3, 1242},
	{"UEYS", 4, 200016},
	{"UEYO", 4, 91487},
	{"UEYL", 4, 237682},
	{"UEYE", 4, 131273},
	{"UEYA", 4, 174860},
	{"UEY", 3, 3890},
	{"UEXT", 4, 172873},
	{"UEXPRESS", 8, 217175},
	{"UEXP", 4, 62087},
	{"UEXJ", 4, 256341},
	{"UEXI", 4, 221697},
	{"UEXE", 4, 181234},
	{"UEXC", 4, 167730},
	{"UEXA", 4, 183238},
	{"UEWR", 4, 148604},
	{"UEWO", 4, 62637},
	{"UEWI", 4, 39972},
	{"UEWH", 4, 45785},
	{"UEWE", 4, 67029},
	{"UEWA", 4, 45389},
	{"UEW", 3, 894},
	{"UEVO", 4, 99823},
	{"UEVI", 4, 77835},
	{"UEVE", 4, 50702},
	{"UEVA", 4, 66987},
	{"UEV", 3, 1389},
	{"UEUS", 4, 95867},
	{"UEUR", 4, 119436},
	{"UEUP", 4, 127768},
	{"UEUN", 4, 66087},
	{"UEUI", 4, 160733},
	{"UEUE", 4, 75098},
	{"UEU", 3, 1825},
	{"UETY", 4, 165576},
	{"UETW", 4, 80516},
	{"UETU", 4, 139941},
	{"UETR", 4, 72184},
	{"UETP", 4, 212208},
	{"UETO", 4, 3293},
	{"UETM", 4, 218416},
	{"UETL", 4, 239334},
	{"UETH", 4, 28144},
	{"UETF", 4, 150839},
	{"UETD", 4, 238768},
	{"UETC", 4, 144411},
	{"UETB", 4, 142884},
	{"UESY", 4, 80295},
	{"UESW", 4, 39955},
	{"UESV", 4, 118589},
	{"UESU", 4, 58782},
	{"UESTIONS", 8, 237447},
	{"UESS", 4, 29311},
	{"UESR", 4, 56985},
	{"UESQ", 4, 116341},
	{"UESP", 4, 51188},
	{"UESO", 4, 35562},
	{"UESM", 4, 58177},
	{"UESL", 4, 61324},
	{"UESK", 4, 83882},
	{"UESJ", 4, 124985},
	{"UESHIBA", 7, 247146},
	{"UESG", 4, 83071},
	{"UESF", 4, 44908},
	{"UESD", 4, 245890},
	{"UESC", 4, 47258},
	{"UESB", 4, 49652},
	{"UESA", 4, 29281},
	{"UERZ", 4, 249778},
	{"UERY", 4, 77604},
	{"UERW", 4, 97593},
	{"UERV", 4, 250116},
	{"UERU", 4, 99772},
	{"UERT", 4, 45010},
	{"UERS", 4, 54620},
	{"UERR", 4, 50390},
	{"UERQ", 4, 91278},
	{"UERP", 4, 149796},
	{"UERO", 4, 55615},
	{"UERN", 4, 96451},
	{"UERM", 4, 132740},
	{"UERL", 4, 142604},
	{"UERK", 4, 164656},
	{"UERJ", 4, 261572},
	{"UERI", 4, 47207},
	{"UERH", 4, 116197},
	{"UERG", 4, 125400},
	{"UERF", 4, 141159},
	{"UERE", 4, 39866},
	{"UERD", 4, 135068},
	{"UERC", 4, 112841},
	{"UERB", 4, 103160},
	{"UERA", 4, 55225},
	{"UEQU", 4, 111443},
	{"UEPU", 4, 104707},
	{"UEPR", 4, 48683},
	{"UEPP", 4, 248163},
	{"UEPO", 4, 69616},
	{"UEPM", 4, 149261},
	{"UEPL", 4, 56393},
	{"UEPI", 4, 82568},
	{"UEPH", 4, 145625},
	{"UEPE", 4, 68596},
	{"UEPA", 4, 62432},
	{"UEOW", 4, 194350},
	{"UEOV", 4, 99835},
	{"UEOU", 4, 75981},
	{"UEOR", 4, 58673},
	{"UEOP", 4, 78921},
	{"UEOL", 4, 241871},
	{"UEOF", 4, 28336},
	{"UEOC", 4, 163585},
	{"UEOB", 4, 174957},
	{"UEO", 3, 821},
	{"UENZ", 4, 79392},
	{"UENY", 4, 222170},
	{"UENW", 4, 152662},
	{"UENV", 4, 226978},
	{"UENU", 4, 135360},
	{"UENT", 4, 4929},
	{"UENR", 4, 243010},
	{"UENM", 4, 178652},
	{"UENL", 4, 165917},
	{"UENJ", 4, 105886},
	{"UENG", 4, 126436},
	{"UENF", 4, 202575},
	{"UEND", 4, 78402},
	{"UENCE", 5, 198592},
	{"UENC", 4, 4814},
	{"UENB", 4, 185357},
	{"UEMY", 4, 151033},
	{"UEMV", 4, 144196},
	{"UEMURA", 6, 167973},
	{"UEMU", 4, 96143},
	{"UEMP", 4, 142450},
	{"UEMO", 4, 61906},
	{"UEMI", 4, 71212},
	{"UEME", 4, 63180},
	{"UEMC", 4, 220806},
	{"UEMB", 4, 216862},
	{"UEMATSU", 7, 186493},
	{"UEMA", 4, 49645},
	{"UELZ", 4, 225796},
	{"UELY", 4, 62957},
	{"UELW", 4, 66101},
	{"UELV", 4, 129695},
	{"UELU", 4, 117406},
	{"UELT", 4, 44107},
	{"UELS", 4, 42270},
	{"UELR", 4, 85011},
	{"UELP", 4, 61317},
	{"UELO", 4, 55308},
	{"UELN", 4, 126641},
	{"UELM", 4, 75742},
	{"UELL", 4, 46308},
	{"UELK", 4, 151948},
	{"UELJ", 4, 127427},
	{"UELH", 4, 84876},
	{"UELG", 4, 97618},
	{"UELF", 4, 75391},
	{"UELE", 4, 40977},
	{"UELD", 4, 78891},
	{"UELC", 4, 53245},
	{"UELB", 4, 68681},
	{"UELA", 4, 38739},
	{"UEKN", 4, 124381},
	{"UEKE", 4, 147763},
	{"UEKAWA", 6, 159547},
	{"UEKA", 4, 177716},
	{"UEK", 3, 5437},
	{"UEJU", 4, 101377},
	{"UEJO", 4, 116914},
	{"UEJE", 4, 114891},
	{"UEJA", 4, 59511},
	{"UEJ", 3, 2154},
	{"UEIW", 4, 226979},
	{"UEIR", 4, 115359},
	{"UEIN", 4, 31442},
	{"UEIM", 4, 119545},
	{"UEIL", 4, 198517},
	{"UEIG", 4, 245118},
	{"UEIF", 4, 96981},
	{"UEID", 4, 88542},
	{"UEIC", 4, 208299},
	{"UEHU", 4, 144822},
	{"UEHR", 4, 136287},
	{"UEHL", 4, 144522},
	{"UEHARA", 6, 206788},
	{"UEH", 3, 1047},
	{"UEGU", 4, 134183},
	{"UEGR", 4, 59150},
	{"UEGO", 4, 76332},
	{"UEGL", 4, 161448},
	{"UEGI", 4, 92623},
	{"UEGE", 4, 78390},
	{"UEGA", 4, 62955},
	{"UEFU", 4, 99040},
	{"UEFR", 4, 50937},
	{"UEFO", 4, 37769},
	{"UEFL", 4, 102593},
	{"UEFI", 4, 61074},
	{"UEFF", 4, 258540},
	{"UEFE", 4, 77593},
	{"UEFA", 4, 50771},
	{"UEEZ", 4, 54483},
	{"UEEY", 4, 95003},
	{"UEEX", 4, 80726},
	{"UEEV", 4, 91885},
	{"UEER", 4, 95810},
	{"UEEQ", 4, 178855},
	{"UEEP", 4, 180203},
	{"UEEN", 4, 29243},
	{"UEEM", 4, 138438},
	{"UEEL", 4, 123233},
	{"UEEG", 4, 185358},
	{"UEEF", 4, 126942},
	{"UEED", 4, 258451},
	{"UEEC", 4, 185103},
	{"UEDY", 4, 179451},
	{"UEDW", 4, 53788},
	{"UEDV", 4, 152929},
	{"UEDU", 4, 54418},
	{"UEDT", 4, 9065},
	{"UEDS", 4, 61010},
	{"UEDR", 4, 69195},
	{"UEDP", 4, 73696},
	{"UEDO", 4, 49847},
	{"UEDN", 4, 112408},
	{"UEDM", 4, 81053},
	{"UEDL", 4, 95357},
	{"UEDK", 4, 231832},
	{"UEDJ", 4, 169626},
	{"UEDI", 4, 41387},
	{"UEDH", 4, 53699},
	{"UEDG", 4, 108795},
	{"UEDF", 4, 53885},
	{"UEDE", 4, 43704},
	{"UEDD", 4, 79089},
	{"UEDC", 4, 78462},
	{"UEDB", 4, 44165},
	{"UEDA", 4, 113407},
	{"UECY", 4, 213616},
	{"UECU", 4, 80718},
	{"UECR", 4, 72408},
	{"UECO", 4, 40997},
	{"UECL", 4, 77037},
	{"UECKER", 6, 248897},
	{"UECK", 4, 151034},
	{"UECI", 4, 108089},
	{"UECH", 4, 48741},
	{"UECE", 4, 101817},
	{"UECA", 4, 52255},
	{"UEBY", 4, 75602},
	{"UEBU", 4, 52859},
	{"UEBR", 4, 87533},
	{"UEBO", 4, 68671},
	{"UEBL", 4, 63983},
	{"UEBI", 4, 85385},
	{"UEBER", 5, 133500},
	{"UEBE", 4, 38359},
	{"UEBA", 4, 49511},
	{"UEAW", 4, 142650},
	{"UEAV", 4, 137090},
	{"UEAU", 4, 136031},
	{"UEAR", 4, 60310},
	{"UEAP", 4, 76568},
	{"UEAN", 4, 29530},
	{"UEAM", 4, 78862},
	{"UEAL", 4, 58258},
	{"UEAK", 4, 94410},
	{"UEAG", 4, 88063},
	{"UEAF", 4, 80075},
	{"UEAD", 4, 73717},
	{"UEAC", 4, 67369},
	{"UEAB", 4, 73018},
	{"UDZI", 4, 150671},
	{"UDZ", 3, 33242},
	{"UDYY", 4, 254606},
	{"UDYW", 4, 62914},
	{"UDYV", 4, 204322},
	{"UDYU", 4, 147269},
	{"UDYT", 4, 53734},
	{"UDYS", 4, 62492},
	{"UDYR", 4, 90119},
	{"UDYP", 4, 75874},
	{"UDYOG", 5, 177675},
	{"UDYO", 4, 43543},
	{"UDYN", 4, 120391},
	{"UDYM", 4, 91655},
	{"UDYL", 4, 102650},
	{"UDYK", 4, 201406},
	{"UDYJ", 4, 184854},
	{"UDYI", 4, 40194},
	{"UDYH", 4, 81975},
	{"UDYG", 4, 81664},
	{"UDYF", 4, 69381},
	{"UDYE", 4, 103364},
	{"UDYD", 4, 96991},
	{"UDYC", 4, 69991},
	{"UDYB", 4, 70914},
	{"UDYA", 4, 50195},
	{"UDY", 3, 140672},
	{"UDWO", 4, 167137},
	{"UDWI", 4, 60900},
	{"UDWE", 4, 107361},
	{"UDWADIA", 7, 236579},
	{"UDWA", 4, 86696},
	{"UDVO", 4, 194351},
	{"UDVI", 4, 174456},
	{"UDVA", 4, 172179},
	{"UDV", 3, 232070},
	{"UDUS", 4, 161449},
	{"UDUR", 4, 122293},
	{"UDUPI", 5, 187544},
	{"UDUP", 4, 177825},
	{"UDUN", 4, 128899},
	{"UDUM", 4, 174349},
	{"UDUL", 4, 79596},
	{"UDUK", 4, 250820},
	{"UDUD", 4, 182756},
	{"UDUC", 4, 210485},
	{"UDUB", 4, 108355},
	{"UDUA", 4, 248164},
	{"UDU", 3, 250432},
	{"UDTR", 4, 173148},
	{"UDTO", 4, 62933},
	{"UDTH", 4, 59654},
	{"UDTE", 4, 218874},
	{"UDTA", 4, 181461},
	{"UDSW", 4, 117012},
	{"UDSU", 4, 165918},
	{"UDST", 4, 77238},
	{"UDSS", 4, 148792},
	{"UDSR", 4, 207204},
	{"UDSP", 4, 87759},
	{"UDSO", 4, 44718},
	{"UDSM", 4, 96452},
	{"UDSL", 4, 110229},
	{"UDSK", 4, 195255},
	{"UDSI", 4, 115444},
	{"UDSH", 4, 116342},
	{"UDSG", 4, 250821},
	{"UDSF", 4, 161682},
	{"UDSE", 4, 88184},
	{"UDSD", 4, 205022},
	{"UDSC", 4, 123994},
	{"UDSB", 4, 137591},
	{"UDSA", 4, 75972},
	{"UDRU", 4, 146072},
	{"UDRP", 4, 122911},
	{"UDRO", 4, 104274},
	{"UDRI", 4, 81621},
	{"UDRE", 4, 62794},
	{"UDRA", 4, 77690},
	{"UDR", 3, 252557},
	{"UDQ", 3, 72841},
	{"UDPU", 4, 215042},
	{"UDPR", 4, 116541},
	{"UDPO", 4, 168368},
	{"UDPL", 4, 212209},
	{"UDPI", 4, 210297},
	{"UDPE", 4, 191223},
	{"UDPA", 4, 124562},
	{"UDP", 3, 40300},
	{"UDOY", 4, 133815},
	{"UDOW", 4, 71310},
	{"UDOV", 4, 112895},
	{"UDOU", 4, 97347},
	{"UDOT", 4, 200218},
	{"UDOS", 4, 70608},
	{"UDOR", 4, 68892},
	{"UDOP", 4, 140479},
	{"UDOO", 4, 148846},
	{"UDON", 4, 121940},
	{"UDOM", 4, 99836},
	{"UDOL", 4, 66745},
	{"UDOK", 4, 115404},
	{"UDOJ", 4, 233232},
	{"UDOI", 4, 67253},
	{"UDOG", 4, 139690},
	{"UDOF", 4, 44297},
	{"UDOE", 4, 104418},
	{"UDOD", 4, 137630},
	{"UDOCS", 5, 148249},
	{"UDOC", 4, 115796},
	{"UDOB", 4, 117040},
	{"UDOA", 4, 85659},
	{"UDNO", 4, 118329},
	{"UDNI", 4, 159488},
	{"UDNE", 4, 110072},
	{"UDNA", 4, 226500},
	{"UDMU", 4, 137418},
	{"UDMO", 4, 113617},
	{"UDMI", 4, 136817},
	{"UDME", 4, 172774},
	{"UDMA", 4, 120266},
	{"UDM", 3, 163354},
	{"UDLY", 4, 61718},
	{"UDLO", 4, 101696},
	{"UDLI", 4, 79002},
	{"UDLE", 4, 65571},
	{"UDLD", 4, 156853},
	{"UDL", 3, 193413},
	{"UDKN", 4, 240459},
	{"UDKI", 4, 198355},
	{"UDK", 3, 225617},
	{"UDJU", 4, 247555},
	{"UDJO", 4, 190924},
	{"UDJA", 4, 223069},
	{"UDJ", 3, 33307},
	{"UDIY", 4, 224872},
	{"UDIW", 4, 170269},
	{"UDIV", 4, 150968},
	{"UDIU", 4, 108597},
	{"UDIT", 4, 177638},
	{"UDIS", 4, 55612},
	{"UDIR", 4, 108090},
	{"UDIP", 4, 168723},
	{"UDINESE", 7, 155314},
	{"UDINE", 5, 117794},
	{"UDIN", 4, 2632},
	{"UDIM", 4, 93992},
	{"UDIL", 4, 149192},
	{"UDIK", 4, 205384},
	{"UDII", 4, 157794},
	{"UDIH", 4, 231076},
	{"UDIG", 4, 185716},
	{"UDIFF", 5, 231178},
	{"UDIF", 4, 142145},
	{"UDIE", 4, 5360},
	{"UDID", 4, 49738},
	{"UDIC", 4, 38535},
	{"UDIB", 4, 82628},
	{"UDIA", 4, 47848},
	{"UDHU", 4, 139942},
	{"UDHR", 4, 165967},
	{"UDHO", 4, 102321},
	{"UDHI", 4, 110510},
	{"UDHE", 4, 117185},
	{"UDHCPC", 6, 233457},
	{"UDHA", 4, 62124},
	{"UDGY", 4, 226726},
	{"UDGU", 4, 217265},
	{"UDGR", 4, 193478},
	{"UDGO", 4, 188133},
	{"UDGM", 4, 45970},
	{"UDGIVER", 7, 227541},
	{"UDGI", 4, 55288},
	{"UDGET", 5, 216341},
	{"UDGE", 4, 4144},
	{"UDGA", 4, 184855},
	{"UDG", 3, 151565},
	{"UDFS", 4, 232234},
	{"UDFR", 4, 149193},
	{"UDFO", 4, 107820},
	{"UDFL", 4, 149450},
	{"UDFI", 4, 153013},
	{"UDFE", 4, 221933},
	{"UDFA", 4, 152930},
	{"UDF", 3, 88886},
	{"UDEZ", 4, 188422},
	{"UDEY", 4, 113223},
	{"UDEX", 4, 108261},
	{"UDEW", 4, 57262},
	{"UDEV", 4, 83565},
	{"UDEU", 4, 105559},
	{"UDET", 4, 32741},
	{"UDES", 4, 6515},
	{"UDER", 4, 42952},
	{"UDEQ", 4, 169450},
	{"UDEP", 4, 53850},
	{"UDEO", 4, 42393},
	{"UDEN", 4, 182158},
	{"UDELL", 5, 103988},
	{"UDEK", 4, 103771},
	{"UDEJ", 4, 93160},
	{"UDEI", 4, 50865},
	{"UDEH", 4, 59585},
	{"UDEG", 4, 75787},
	{"UDEF", 4, 51068},
	{"UDEE", 4, 65412},
	{"UDED", 4, 241659},
	{"UDEC", 4, 46752},
	{"UDEB", 4, 130827},
	{"UDEA", 4, 34662},
	{"UDDW", 4, 137899},
	{"UDDU", 4, 188292},
	{"UDDT", 4, 174958},
	{"UDDS", 4, 99741},
	{"UDDR", 4, 172775},
	{"UDDP", 4, 261201},
	{"UDDO", 4, 128584},
	{"UDDL", 4, 54654},
	{"UDDIN", 5, 179516},
	{"UDDI", 4, 80928},
	{"UDDH", 4, 40731},
	{"UDDG", 4, 151469},
	{"UDDF", 4, 255650},
	{"UDDERS", 6, 221432},
	{"UDDER", 5, 123786},
	{"UDDE", 4, 31884},
	{"UDDD", 4, 256666},
	{"UDDC", 4, 202397},
	{"UDDB", 4, 247248},
	{"UDDA", 4, 87341},
	{"UDD", 3, 238728},
	{"UDCR", 4, 170270},
	{"UDCO", 4, 73874},
	{"UDCL", 4, 183239},
	{"UDCH", 4, 127350},
	{"UDC", 3, 101341},
	{"UDBY", 4, 176462},
	{"UDBU", 4, 62818},
	{"UDBR", 4, 135026},
	{"UDBO", 4, 141097},
	{"UDBL", 4, 212996},
	{"UDBE", 4, 70885},
	{"UDBA", 4, 105637},
	{"UDB", 3, 79687},
	{"UDAYA", 5, 254509},
	{"UDAY", 4, 113077},
	{"UDAW", 4, 134552},
	{"UDAV", 4, 189556},
	{"UDAU", 4, 188711},
	{"UDATE", 5, 134397},
	{"UDAT", 4, 82501},
	{"UDAS", 4, 69831},
	{"UDAR", 4, 90901},
	{"UDAP", 4, 79642},
	{"UDAO", 4, 181958},
	{"UDAN", 4, 43070},
	{"UDAM", 4, 109337},
	{"UDALL", 5, 104267},
	{"UDAK", 4, 145146},
	{"UDAJ", 4, 238492},
	{"UDAIPUR", 7, 71272},
	{"UDAILY", 6, 216141},
	{"UDAG", 4, 152071},
	{"UDAF", 4, 150155},
	{"UDAE", 4, 170532},
	{"UDAD", 4, 98856},
	{"UDAC", 4, 79434},
	{"UDAB", 4, 94130},
	{"UDAA", 4, 109174},
	{"UCZ", 3, 43073},
	{"UCYW", 4, 154062},
	{"UCYT", 4, 171478},
	{"UCYS", 4, 120518},
	{"UCYR", 4, 204482},
	{"UCYP", 4, 241872},
	{"UCYM", 4, 218170},
	{"UCYL", 4, 201572},
	{"UCYI", 4, 182065},
	{"UCYH", 4, 197422},
	{"UCYF", 4, 260053},
	{"UCYD", 4, 155367},
	{"UCYC", 4, 201227},
	{"UCYB", 4, 197578},
	{"UCYA", 4, 130310},
	{"UCY", 3, 2880},
	{"UCX", 3, 221099},
	{"UCWA", 4, 251150},
	{"UCW", 3, 225514},
	{"UCUT", 4, 134693},
	{"UCUS", 4, 53502},
	{"UCUR", 4, 136085},
	{"UCUL", 4, 148109},
	{"UCU", 3, 184916},
	{"UCTY", 4, 169904},
	{"UCTW", 4, 66895},
	{"UCTV", 4, 190838},
	{"UCTU", 4, 6233},
	{"UCTT", 4, 48876},
	{"UCTS", 4, 119939},
	{"UCTR", 4, 84505},
	{"UCTQ", 4, 228228},
	{"UCTP", 4, 79935},
	{"UCTO", 4, 33578},
	{"UCTN", 4, 128306},
	{"UCTM", 4, 80840},
	{"UCTL", 4, 75770},
	{"UCTK", 4, 234577},
	{"UCTJ", 4, 237351},
	{"UCTI", 4, 2166},
	{"UCTH", 4, 89024},
	{"UCTG", 4, 120994},
	{"UCTF", 4, 82310},
	{"UCTD", 4, 77192},
	{"UCTC", 4, 75725},
	{"UCTB", 4, 80885},
	{"UCTA", 4, 37457},
	{"UCSW", 4, 194086},
	{"UCSU", 4, 250117},
	{"UCST", 4, 187031},
	{"UCSS", 4, 237352},
	{"UCSPI", 5, 182847},
	{"UCSO", 4, 68339},
	{"UCSIMM", 6, 210579},
	{"UCSI", 4, 247875},
	{"UCSH", 4, 220179},
	{"UCSF", 4, 71146},
	{"UCSD", 4, 65814},
	{"UCSC", 4, 70965},
	{"UCSB", 4, 73214},
	{"UCRY", 4, 222422},
	{"UCRO", 4, 125762},
	{"UCRL", 4, 183095},
	{"UCRI", 4, 134267},
	{"UCREL", 5, 195642},
	{"UCRE", 4, 78561},
	{"UCRA", 4, 46469},
	{"UCR", 3, 77693},
	{"UCP", 3, 84042},
	{"UCOW", 4, 217067},
	{"UCOV", 4, 156112},
	{"UCOU", 4, 36409},
	{"UCOT", 4, 214409},
	{"UCOS", 4, 78293},
	{"UCOR", 4, 121393},
	{"UCOP", 4, 196048},
	{"UCOO", 4, 174244},
	{"UCONN", 5, 57368},
	{"UCOL", 4, 165541},
	{"UCOI", 4, 194665},
	{"UCOF", 4, 251151},
	{"UCOC", 4, 209684},
	{"UCOA", 4, 105540},
	{"UCNR", 4, 245742},
	{"UCMJ", 4, 181440},
	{"UCM", 3, 143082},
	{"UCLUELET", 8, 157999},
	{"UCLU", 4, 194504},
	{"UCLO", 4, 134133},
	{"UCLINUX", 7, 74490},
	{"UCLICK", 6, 221766},
	{"UCLIBC", 6, 68108},
	{"UCLI", 4, 76948},
	{"UCLE", 4, 31755},
	{"UCLA", 4, 37677},
	{"UCL", 3, 61238},
	{"UCKY", 4, 32181},
	{"UCKW", 4, 46245},
	{"UCKV", 4, 144882},
	{"UCKU", 4, 79755},
	{"UCKT", 4, 44458},
	{"UCKS", 4, 30343},
	{"UCKR", 4, 77794},
	{"UCKP", 4, 76544},
	{"UCKN", 4, 68854},
	{"UCKM", 4, 65226},
	{"UCKL", 4, 39667},
	{"UCKK", 4, 139691},
	{"UCKJ", 4, 133525},
	{"UCKI", 4, 35958},
	{"UCKH", 4, 57792},
	{"UCKG", 4, 102145},
	{"UCKFIELD", 8, 126261},
	{"UCKF", 4, 63003},
	{"UCKE", 4, 32220},
	{"UCKD", 4, 61232},
	{"UCKC", 4, 68316},
	{"UCKB", 4, 51133},
	{"UCKA", 4, 39115},
	{"UCK", 3, 138876},
	{"UCIV", 4, 110073},
	{"UCIU", 4, 92734},
	{"UCITS", 5, 198503},
	{"UCITA", 5, 172868},
	{"UCISA", 5, 246860},
	{"UCIR", 4, 148532},
	{"UCIP", 4, 225322},
	{"UCIO", 4, 128389},
	{"UCIN", 4, 30249},
	{"UCIL", 4, 92678},
	{"UCIG", 4, 225323},
	{"UCIF", 4, 71852},
	{"UCIE", 4, 82366},
	{"UCID", 4, 91566},
	{"UCIC", 4, 145269},
	{"UCIB", 4, 102899},
	{"UCIA", 4, 38721},
	{"UCHY", 4, 56229},
	{"UCHW", 4, 38563},
	{"UCHV", 4, 76146},
	{"UCHU", 4, 64472},
	{"UCHT", 4, 9441},
	{"UCHS", 4, 31982},
	{"UCHR", 4, 46266},
	{"UCHQ", 4, 112565},
	{"UCHP", 4, 39259},
	{"UCHOD", 5, 243511},
	{"UCHO", 4, 8262},
	{"UCHN", 4, 52335},
	{"UCHM", 4, 29602},
	{"UCHL", 4, 33482},
	{"UCHK", 4, 106722},
	{"UCHJ", 4, 104067},
	{"UCHIYAMA", 8, 203392},
	{"UCHIDA", 6, 113354},
	{"UCHI", 4, 159465},
	{"UCHH", 4, 39178},
	{"UCHG", 4, 52266},
	{"UCHF", 4, 38291},
	{"UCHEL", 5, 207126},
	{"UCHE", 4, 143566},
	{"UCHD", 4, 8674},
	{"UCHB", 4, 37027},
	{"UCHAR", 5, 119417},
	{"UCHAF", 5, 212584},
	{"UCHA", 4, 2092},
	{"UCG", 3, 189044},
	{"UCFV", 4, 188908},
	{"UCFS", 4, 186901},
	{"UCFA", 4, 212001},
	{"UCF", 3, 70140},
	{"UCEY", 4, 108744},
	{"UCEW", 4, 61848},
	{"UCEV", 4, 117553},
	{"UCEU", 4, 108796},
	{"UCET", 4, 36540},
	{"UCERTIFY", 8, 116720},
	{"UCER", 4, 30685},
	{"UCEQ", 4, 257397},
	{"UCEP", 4, 62264},
	{"UCEO", 4, 67329},
	{"UCEN", 4, 67064},
	{"UCEM", 4, 60317},
	{"UCEL", 4, 73678},
	{"UCEK", 4, 145576},
	{"UCEJ", 4, 143951},
	{"UCEI", 4, 59306},
	{"UCEH", 4, 65014},
	{"UCEG", 4, 82777},
	{"UCEF", 4, 70633},
	{"UCEE", 4, 71800},
	{"UCED", 4, 256589},
	{"UCEC", 4, 59728},
	{"UCEB", 4, 66156},
	{"UCDE", 4, 171190},
	{"UCDA", 4, 136210},
	{"UCD", 3, 69040},
	{"UCCU", 4, 69044},
	{"UCCS", 4, 204047},
	{"UCCO", 4, 92513},
	{"UCCNET", 6, 226408},
	{"UCCH", 4, 105295},
	{"UCCELLI", 7, 257985},
	{"UCCE", 4, 246905},
	{"UCC", 3, 57506},
	{"UCBE", 4, 131655},
	{"UCB", 3, 67765},
	{"UCAW", 4, 214604},
	{"UCAU", 4, 122454},
	{"UCASE", 5, 257848},
	{"UCAS", 4, 87405},
	{"UCAR", 4, 114991},
	{"UCAN", 4, 231487},
	{"UCAL", 4, 64455},
	{"UCAI", 4, 148729},
	{"UCAH", 4, 175369},
	{"UCAG", 4, 224637},
	{"UCAD", 4, 188293},
	{"UCABLES", 7, 157137},
	{"UCAB", 4, 200739},
	{"UBZE", 4, 154308},
	{"UBZ", 3, 37195},
	{"UBYW", 4, 186902},
	{"UBYT", 4, 128174},
	{"UBYSSEY", 7, 224532},
	{"UBYS", 4, 126907},
	{"UBYR", 4, 176022},
	{"UBYP", 4, 217068},
	{"UBYO", 4, 157243},
	{"UBYM", 4, 216455},
	{"UBYL", 4, 250469},
	{"UBYI", 4, 197744},
	{"UBYH", 4, 235777},
	{"UBYF", 4, 253543},
	{"UBYE", 4, 196299},
	{"UBYD", 4, 241299},
	{"UBYC", 4, 197579},
	{"UBYB", 4, 221509},
	{"UBYA", 4, 115068},
	{"UBX", 3, 214798},
	{"UBWO", 4, 97108},
	{"UBWI", 4, 68608},
	{"UBWH", 4, 71597},
	{"UBWE", 4, 108091},
	{"UBWA", 4, 50496},
	{"UBVO", 4, 227714},
	{"UBVI", 4, 214605},
	{"UBVE", 4, 83746},
	{"UBVA", 4, 235490},
	{"UBV", 3, 229103},
	{"UBUY", 4, 80954},
	{"UBUT", 4, 62003},
	{"UBUS", 4, 101533},
	{"UBUR", 4, 33991},
	{"UBUQ", 4, 136626},
	{"UBUNTU", 6, 44209},
	{"UBUN", 4, 74390},
	{"UBUL", 4, 102184},
	{"UBUK", 4, 245743},
	{"UBUI", 4, 109123},
	{"UBUD", 4, 88455},
	{"UBUC", 4, 241873},
	{"UBU", 3, 133613},
	{"UBTY", 4, 115644},
	{"UBTW", 4, 97254},
	{"UBTV", 4, 244807},
	{"UBTU", 4, 204138},
	{"UBTT", 4, 50947},
	{"UBTS", 4, 56079},
	{"UBTR", 4, 66778},
	{"UBTP", 4, 187313},
	{"UBTO", 4, 61596},
	{"UBTN", 4, 253544},
	{"UBTM", 4, 147872},
	{"UBTL", 4, 51551},
	{"UBTI", 4, 57429},
	{"UBTH", 4, 53842},
	{"UBTG", 4, 226727},
	{"UBTF", 4, 77232},
	{"UBTE", 4, 50002},
	{"UBTD", 4, 202057},
	{"UBTC", 4, 160243},
	{"UBTB", 4, 115473},
	{"UBTA", 4, 67660},
	{"UBSY", 4, 103114},
	{"UBSW", 4, 66678},
	{"UBSV", 4, 217266},
	{"UBSU", 4, 88821},
	{"UBST", 4, 9577},
	{"UBSS", 4, 75386},
	{"UBSR", 4, 108180},
	{"UBSP", 4, 64542},
	{"UBSO", 4, 66839},
	{"UBSN", 4, 126773},
	{"UBSM", 4, 93611},
	{"UBSL", 4, 102900},
	{"UBSK", 4, 215253},
	{"UBSJ", 4, 247249},
	{"UBSI", 4, 35356},
	{"UBSH", 4, 68990},
	{"UBSG", 4, 127308},
	{"UBSF", 4, 74903},
	{"UBSE", 4, 29964},
	{"UBSD", 4, 109649},
	{"UBSC", 4, 40081},
	{"UBSB", 4, 90449},
	{"UBSA", 4, 45734},
	{"UBRY", 4, 255651},
	{"UBRU", 4, 135240},
	{"UBRO", 4, 75217},
	{"UBRI", 4, 59512},
	{"UBRE", 4, 59729},
	{"UBRA", 4, 86100},
	{"UBR", 3, 122585},
	{"UBQU", 4, 231833},
	{"UBQ", 3, 51667},
	{"UBPU", 4, 238215},
	{"UBPR", 4, 60040},
	{"UBPO", 4, 85282},
	{"UBPM", 4, 201066},
	{"UBPL", 4, 86602},
	{"UBPI", 4, 225324},
	{"UBPE", 4, 163768},
	{"UBPA", 4, 90041},
	{"UBP", 3, 215569},
	{"UBOY", 4, 177608},
	{"UBOX", 4, 228469},
	{"UBOW", 4, 125338},
	{"UBOV", 4, 149739},
	{"UBOUND", 6, 203406},
	{"UBOU", 4, 95468},
	{"UBOT", 4, 94639},
	{"UBOS", 4, 152207},
	{"UBOR", 4, 54444},
	{"UBOP", 4, 132312},
	{"UBOO", 4, 163511},
	{"UBON", 4, 195294},
	{"UBOM", 4, 188294},
	{"UBOL", 4, 217708},
	{"UBOI", 4, 100502},
	{"UBOF", 4, 59605},
	{"UBOE", 4, 258897},
	{"UBOD", 4, 243011},
	{"UBOC", 4, 248165},
	{"UBOB", 4, 229988},
	{"UBOA", 4, 93993},
	{"UBNO", 4, 123761},
	{"UBNI", 4, 193318},
	{"UBNE", 4, 118202},
	{"UBND", 4, 196446},
	{"UBNA", 4, 145410},
	{"UBN", 3, 5445},
	{"UBMU", 4, 189018},
	{"UBMO", 4, 129014},
	{"UBMI", 4, 34878},
	{"UBME", 4, 56332},
	{"UBMA", 4, 43969},
	{"UBM", 3, 256553},
	{"UBLU", 4, 190201},
	{"UBLOG", 5, 220427},
	{"UBLO", 4, 107240},
	{"UBLJ", 4, 170812},
	{"UBLIC", 5, 123109},
	{"UBLI", 4, 1488},
	{"UBLE", 4, 4238},
	{"UBLAS", 5, 226673},
	{"UBLA", 4, 84379},
	{"UBL", 3, 89657},
	{"UBKI", 4, 205563},
	{"UBKH", 4, 254926},
	{"UBK", 3, 31156},
	{"UBJU", 4, 97019},
	{"UBJO", 4, 232370},
	{"UBJE", 4, 8792},
	{"UBJA", 4, 238493},
	{"UBJ", 3, 842},
	{"UBIW", 4, 252495},
	{"UBISOFT", 7, 65304},
	{"UBIS", 4, 53028},
	{"UBIR", 4, 176656},
	{"UBIQUITY", 8, 91610},
	{"UBIQUITOUSLY", 12, 189464},
	{"UBIQUITOUS", 10, 51205},
	{"UBIQUITINATION", 14, 169348},
	{"UBIQUITIN", 9, 73253},
	{"UBIQUINONE", 10, 124526},
	{"UBIQUINOL", 9, 222971},
	{"UBIQUE", 6, 257224},
	{"UBIQ", 4, 80155},
	{"UBIO", 4, 65392},
	{"UBIN", 4, 237735},
	{"UBIM", 4, 166719},
	{"UBIL", 4, 67841},
	{"UBIK", 4, 221451},
	{"UBIG", 4, 181703},
	{"UBIF", 4, 251465},
	{"UBIE", 4, 123471},
	{"UBID", 4, 93261},
	{"UBICOMP", 7, 221110},
	{"UBIA", 4, 81258},
	{"UBHU", 4, 153251},
	{"UBHO", 4, 59415},
	{"UBHI", 4, 127701},
	{"UBHE", 4, 95932},
	{"UBHA", 4, 63992},
	{"UBGR", 4, 82843},
	{"UBGO", 4, 155643},
	{"UBGI", 4, 237683},
	{"UBGE", 4, 115319},
	{"UBGA", 4, 170271},
	{"UBG", 3, 3880},
	{"UBFU", 4, 235212},
	{"UBFR", 4, 108318},
	{"UBFO", 4, 64526},
	{"UBFL", 4, 244209},
	{"UBFI", 4, 110674},
	{"UBFE", 4, 196612},
	{"UBFA", 4, 119347},
	{"UBF", 3, 213178},
	{"UBEY", 4, 205920},
	{"UBEX", 4, 174550},
	{"UBEW", 4, 90653},
	{"UBEV", 4, 99250},
	{"UBEU", 4, 187736},
	{"UBES", 4, 50425},
	{"UBERSITE", 8, 130108},
	{"UBERPLAY", 8, 179542},
	{"UBEROI", 6, 251058},
	{"UBERNOSTRUM", 11, 218032},
	{"UBERGIZMO", 9, 221460},
	{"UBER", 4, 49837},
	{"UBEP", 4, 134771},
	{"UBEO", 4, 111731},
	{"UBEN", 4, 60583},
	{"UBEM", 4, 123501},
	{"UBEL", 4, 56264},
	{"UBEK", 4, 147873},
	{"UBEI", 4, 67906},
	{"UBEH", 4, 117164},
	{"UBEG", 4, 91721},
	{"UBEF", 4, 92514},
	{"UBEE", 4, 87793},
	{"UBED", 4, 102523},
	{"UBEC", 4, 56280},
	{"UBEB", 4, 121690},
	{"UBEA", 4, 62904},
	{"UBDU", 4, 67043},
	{"UBDR", 4, 202213},
	{"UBDO", 4, 132460},
	{"UBDI", 4, 51962},
	{"UBDE", 4, 107932},
	{"UBDA", 4, 199186},
	{"UBD", 3, 120936},
	{"UBCU", 4, 100217},
	{"UBCR", 4, 148048},
	{"UBCO", 4, 49097},
	{"UBCL", 4, 108201},
	{"UBCINTL", 7, 239298},
	{"UBCI", 4, 183375},
	{"UBCH", 4, 92139},
	{"UBCE", 4, 192783},
	{"UBCA", 4, 73750},
	{"UBC", 3, 46379},
	{"UBBY", 4, 77109},
	{"UBBU", 4, 98897},
	{"UBBTHREADS", 10, 155317},
	{"UBBS", 4, 94592},
	{"UBBR", 4, 138976},
	{"UBBO", 4, 63020},
	{"UBBL", 4, 40884},
	{"UBBI", 4, 55407},
	{"UBBFRIEND", 9, 113099},
	{"UBBE", 4, 37952},
	{"UBBCODE", 7, 63178},
	{"UBBA", 4, 59078},
	{"UBB", 3, 83063},
	{"UBAY", 4, 121764},
	{"UBAW", 4, 111213},
	{"UBAV", 4, 165721},
	{"UBAU", 4, 143049},
	{"UBAT", 4, 59252},
	{"UBAS", 4, 60167},
	{"UBAR", 4, 245026},
	{"UBAP", 4, 134645},
	{"UBAO", 4, 141327},
	{"UBAN", 4, 39260},
	{"UBAM", 4, 124755},
	{"UBAL", 4, 69536},
	{"UBAK", 4, 95018},
	{"UBAI", 4, 53494},
	{"UBAH", 4, 111275},
	{"UBAG", 4, 131735},
	{"UBAF", 4, 117116},
	{"UBAE", 4, 200558},
	{"UBAD", 4, 86316},
	{"UBAC", 4, 67364},
	{"UBAB", 4, 116241},
	{"UBAA", 4, 85491},
	{"UAZO", 4, 246330},
	{"UAYW", 4, 149797},
	{"UAYU", 4, 193051},
	{"UAYT", 4, 131481},
	{"UAYS", 4, 117861},
	{"UAYR", 4, 222634},
	{"UAYO", 4, 181002},
	{"UAYN", 4, 243904},
	{"UAYM", 4, 245441},
	{"UAYL", 4, 160038},
	{"UAYI", 4, 148955},
	{"UAYH", 4, 207729},
	{"UAYF", 4, 251466},
	{"UAYE", 4, 199187},
	{"UAYC", 4, 217485},
	{"UAYB", 4, 217709},
	{"UAYA", 4, 79421},
	{"UAY", 3, 2015},
	{"UAWO", 4, 207928},
	{"UAWK", 4, 181129},
	{"UAWI", 4, 134134},
	{"UAWH", 4, 131616},
	{"UAWE", 4, 159888},
	{"UAWA", 4, 92679},
	{"UAVS", 4, 120115},
	{"UAVO", 4, 176561},
	{"UAVI", 4, 174032},
	{"UAVE", 4, 109970},
	{"UAVA", 4, 151246},
	{"UAUT", 4, 189019},
	{"UAUS", 4, 253545},
	{"UAUN", 4, 203441},
	{"UAUH", 4, 243905},
	{"UATW", 4, 212997},
	{"UATU", 4, 138538},
	{"UATR", 4, 106422},
	{"UATP", 4, 251152},
	{"UATM", 4, 232954},
	{"UATL", 4, 132427},
	{"UATION", 6, 169864},
	{"UATI", 4, 4282},
	{"UATC", 4, 158515},
	{"UASY", 4, 199531},
	{"UASW", 4, 126847},
	{"UASU", 4, 197115},
	{"UASP", 4, 135444},
	{"UASM", 4, 164012},
	{"UASL", 4, 206086},
	{"UASK", 4, 66773},
	{"UASF", 4, 218417},
	{"UASD", 4, 226238},
	{"UARU", 4, 220370},
	{"UARTS", 5, 239138},
	{"UART", 4, 87776},
	{"UARS", 4, 219229},
	{"UARR", 4, 55057},
	{"UARO", 4, 113448},
	{"UARN", 4, 186764},
	{"UARL", 4, 164892},
	{"UARK", 4, 109299},
	{"UARI", 4, 49804},
	{"UARG", 4, 180444},
	{"UARE", 4, 4749},
	{"UARD", 4, 6169},
	{"UARA", 4, 35934},
	{"UAQU", 4, 181462},
	{"UAPU", 4, 253178},
	{"UAPR", 4, 139994},
	{"UAPP", 4, 84306},
	{"UAPO", 4, 155368},
	{"UAPL", 4, 220371},
	{"UAPI", 4, 242720},
	{"UAPE", 4, 178653},
	{"UAPA", 4, 133526},
	{"UAOR", 4, 201228},
	{"UAOF", 4, 251791},
	{"UANZ", 4, 115301},
	{"UANY", 4, 80929},
	{"UANX", 4, 187314},
	{"UANW", 4, 91229},
	{"UANV", 4, 221934},
	{"UANU", 4, 131244},
	{"UANT", 4, 35711},
	{"UANR", 4, 115343},
	{"UANP", 4, 80548},
	{"UANM", 4, 88662},
	{"UANL", 4, 124220},
	{"UANK", 4, 176463},
	{"UANJ", 4, 130406},
	{"UANG", 4, 49387},
	{"UANF", 4, 122455},
	{"UANC", 4, 54522},
	{"UANB", 4, 91921},
	{"UAMU", 4, 212998},
	{"UAMT", 4, 251792},
	{"UAMS", 4, 80976},
	{"UAMO", 4, 121492},
	{"UAMM", 4, 190632},
	{"UAMI", 4, 126037},
	{"UAME", 4, 135494},
	{"UAMB", 4, 210882},
	{"UAMA", 4, 87778},
	{"UALZ", 4, 241874},
	{"UALY", 4, 122064},
	{"UALW", 4, 42754},
	{"UALV", 4, 64896},
	{"UALU", 4, 68528},
	{"UALT", 4, 32174},
	{"UALS", 4, 209405},
	{"UALR", 4, 181736},
	{"UALQ", 4, 121658},
	{"UALP", 4, 35766},
	{"UALO", 4, 42886},
	{"UALN", 4, 56112},
	{"UALM", 4, 39179},
	{"UALL", 4, 1811},
	{"UALK", 4, 98857},
	{"UALJ", 4, 95469},
	{"UALITY", 6, 168156},
	{"UALI", 4, 3639},
	{"UALH", 4, 49849},
	{"UALG", 4, 51313},
	{"UALF", 4, 39036},
	{"UALE", 4, 41422},
	{"UALD", 4, 43391},
	{"UALC", 4, 34145},
	{"UALBANY", 7, 188239},
	{"UALB", 4, 43376},
	{"UALA", 4, 31266},
	{"UAKU", 4, 232955},
	{"UAKI", 4, 157729},
	{"UAKE", 4, 40459},
	{"UAKA", 4, 195695},
	{"UAK", 3, 1317},
	{"UAJO", 4, 239862},
	{"UAJI", 4, 257781},
	{"UAJA", 4, 241300},
	{"UAJ", 3, 35426},
	{"UAIR", 4, 248945},
	{"UAIM", 4, 190202},
	{"UAIL", 4, 109033},
	{"UAID", 4, 122346},
	{"UAHU", 4, 116029},
	{"UAHOO", 5, 182598},
	{"UAGU", 4, 223535},
	{"UAGR", 4, 87194},
	{"UAGO", 4, 176891},
	{"UAGM", 4, 157174},
	{"UAGI", 4, 164463},
	{"UAGA", 4, 96666},
	{"UAFT", 4, 114720},
	{"UAFR", 4, 119678},
	{"UAFO", 4, 147201},
	{"UAFI", 4, 176464},
	{"UAFF", 4, 187737},
	{"UAFE", 4, 186381},
	{"UAFA", 4, 169905},
	{"UAED", 4, 259120},
	{"UADW", 4, 83990},
	{"UADV", 4, 145209},
	{"UADU", 4, 188878},
	{"UADT", 4, 80001},
	{"UADS", 4, 64254},
	{"UADR", 4, 38691},
	{"UADP", 4, 146825},
	{"UADO", 4, 64209},
	{"UADN", 4, 205739},
	{"UADM", 4, 107526},
	{"UADL", 4, 129113},
	{"UADJ", 4, 237684},
	{"UADI", 4, 69797},
	{"UADH", 4, 117092},
	{"UADG", 4, 197907},
	{"UADF", 4, 101033},
	{"UADE", 4, 44646},
	{"UADD", 4, 82967},
	{"UADC", 4, 91678},
	{"UADB", 4, 117718},
	{"UADA", 4, 56916},
	{"UACY", 4, 137860},
	{"UACU", 4, 137976},
	{"UACT", 4, 81770},
	{"UACS", 4, 244210},
	{"UACR", 4, 171393},
	{"UACO", 4, 108955},
	{"UACL", 4, 190775},
	{"UACK", 4, 117093},
	{"UACI", 4, 146340},
	{"UACH", 4, 89976},
	{"UACC", 4, 193242},
	{"UACA", 4, 100130},
	{"UABU", 4, 161850},
	{"UABS", 4, 176657},
	{"UABR", 4, 207205},
	{"UABO", 4, 74918},
	{"UABL", 4, 36279},
	{"UABI", 4, 178416},
	{"UABE", 4, 127057},
	{"UABD", 4, 218644},
	{"UABB", 4, 102201},
	{"UABA", 4, 138173},
	{"UAAR", 4, 207730},
	{"UAAP", 4, 257290},
	{"UAAL", 4, 194966},
	{"UAAD", 4, 250822},
	{"UAAC", 4, 233233},
	{"U", 1, 12},
	{"TZY", 3, 30532},
	{"TZWR", 4, 258157},
	{"TZWO", 4, 154513},
	{"TZWI", 4, 109735},
	{"TZWH", 4, 94968},
	{"TZWE", 4, 146568},
	{"TZWA", 4, 80875},
	{"TZW", 3, 2894},
	{"TZVO", 4, 206087},
	{"TZVI", 4, 230927},
	{"TZVA", 4, 135781},
	{"TZV", 3, 28282},
	{"TZUN", 4, 179558},
	{"TZUM", 4, 159019},
	{"TZUC", 4, 221025},
	{"TZTR", 4, 196773},
	{"TZT", 3, 4111},
	{"TZSU", 4, 209494},
	{"TZSR", 4, 248817},
	{"TZSP", 4, 165425},
	{"TZSF", 4, 239863},
	{"TZSC", 4, 89504},
	{"TZRO", 4, 125082},
	{"TZRI", 4, 226728},
	{"TZRE", 4, 112971},
	{"TZRA", 4, 219297},
	{"TZPU", 4, 250118},
	{"TZPR", 4, 166366},
	{"TZPO", 4, 217069},
	{"TZPL", 4, 208923},
	{"TZPI", 4, 244523},
	{"TZPE", 4, 236345},
	{"TZPA", 4, 86959},
	{"TZP", 3, 4607},
	{"TZOW", 4, 228229},
	{"TZOR", 4, 137459},
	{"TZOM", 4, 191224},
	{"TZOL", 4, 202576},
	{"TZOF", 4, 114591},
	{"TZMO", 4, 160180},
	{"TZMI", 4, 209285},
	{"TZME", 4, 197257},
	{"TZMA", 4, 80253},
	{"TZM", 3, 4821},
	{"TZLO", 4, 228717},
	{"TZLI", 4, 203281},
	{"TZLE", 4, 109896},
	{"TZLA", 4, 118147},
	{"TZL", 3, 5870},
	{"TZKY", 4, 95077},
	{"TZKR", 4, 174350},
	{"TZKO", 4, 204660},
	{"TZKI", 4, 96856},
	{"TZKE", 4, 138725},
	{"TZK", 3, 3758},
	{"TZJO", 4, 241301},
	{"TZIP", 4, 148327},
	{"TZIM", 4, 107717},
	{"TZIL", 4, 201407},
	{"TZIK", 4, 254927},
	{"TZIG", 4, 176023},
	{"TZID", 4, 162025},
	{"TZHU", 4, 163416},
	{"TZH", 3, 3574},
	{"TZGR", 4, 172484},
	{"TZGI", 4, 186631},
	{"TZGE", 4, 60862},
	{"TZGA", 4, 241302},
	{"TZG", 3, 2931},
	{"TZFR", 4, 187315},
	{"TZFO", 4, 133472},
	{"TZFI", 4, 196155},
	{"TZFE", 4, 191497},
	{"TZFA", 4, 202058},
	{"TZF", 3, 7513},
	{"TZEX", 4, 240460},
	{"TZEP", 4, 248166},
	{"TZEM", 4, 201753},
	{"TZEL", 4, 72765},
	{"TZEDEK", 6, 234354},
	{"TZEDAKAH", 8, 172253},
	{"TZED", 4, 132313},
	{"TZEB", 4, 200740},
	{"TZDO", 4, 194214},
	{"TZDI", 4, 155032},
	{"TZDE", 4, 148328},
	{"TZCR", 4, 197116},
	{"TZCO", 4, 110601},
	{"TZCL", 4, 221935},
	{"TZCH", 4, 152461},
	{"TZCA", 4, 110074},
	{"TZC", 3, 4818},
	{"TZBU", 4, 147036},
	{"TZBR", 4, 202577},
	{"TZBO", 4, 193319},
	{"TZBE", 4, 121192},
	{"TZBA", 4, 159096},
	{"TZB", 3, 5804},
	{"TZAU", 4, 241593},
	{"TZARA", 5, 237634},
	{"TZAR", 4, 238723},
	{"TZAP", 4, 152391},
	{"TZANEEN", 7, 233139},
	{"TZAM", 4, 155849},
	{"TZAL", 4, 106307},
	{"TZAK", 4, 203812},
	{"TZAG", 4, 200559},
	{"TZAF", 4, 196929},
	{"TZADIK", 6, 143730},
	{"TZADDIK", 7, 261767},
	{"TZAD", 4, 155296},
	{"TZAC", 4, 114670},
	{"TZAB", 4, 186124},
	{"TYZO", 4, 133860},
	{"TYZE", 4, 260454},
	{"TYZ", 3, 29383},
	{"TYYO", 4, 67796},
	{"TYYE", 4, 43724},
	{"TYYA", 4, 142699},
	{"TYWYN", 5, 227089},
	{"TYWYDD", 6, 253455},
	{"TYWR", 4, 117862},
	{"TYWO", 4, 42318},
	{"TYWI", 4, 29491},
	{"TYWH", 4, 30659},
	{"TYWE", 4, 41763},
	{"TYWA", 4, 29831},
	{"TYW", 3, 735},
	{"TYVU", 4, 261573},
	{"TYVS", 4, 214410},
	{"TYVO", 4, 71692},
	{"TYVI", 4, 62495},
	{"TYVEK", 5, 105220},
	{"TYVE", 4, 67433},
	{"TYVA", 4, 67797},
	{"TYV", 3, 1415},
	{"TYUT", 4, 109397},
	{"TYUR", 4, 147934},
	{"TYUP", 4, 94047},
	{"TYUN", 4, 47941},
	{"TYUMEN", 6, 193406},
	{"TYUM", 4, 175177},
	{"TYUL", 4, 215657},
	{"TYUK", 4, 149381},
	{"TYUG", 4, 158791},
	{"TYUC", 4, 241018},
	{"TYUA", 4, 183848},
	{"TYU", 3, 1271},
	{"TYTY", 4, 113338},
	{"TYTW", 4, 68160},
	{"TYTV", 4, 81562},
	{"TYTU", 4, 184836},
	{"TYTR", 4, 48039},
	{"TYTH", 4, 6146},
	{"TYSZ", 4, 256342},
	{"TYSY", 4, 64573},
	{"TYSW", 4, 70404},
	{"TYSV", 4, 121279},
	{"TYSU", 4, 42548},
	{"TYST", 4, 32971},
	{"TYSR", 4, 69908},
	{"TYSQ", 4, 120877},
	{"TYSP", 4, 42384},
	{"TYSONS", 6, 108820},
	{"TYSON", 5, 49116},
	{"TYSM", 4, 59775},
	{"TYSL", 4, 62630},
	{"TYSKLAND", 8, 185579},
	{"TYSJ", 4, 144732},
	{"TYSH", 4, 35966},
	{"TYSG", 4, 87081},
	{"TYSF", 4, 63923},
	{"TYSE", 4, 34292},
	{"TYSD", 4, 72253},
	{"TYSC", 4, 40794},
	{"TYSB", 4, 60471},
	{"TYSABRI", 7, 174750},
	{"TYRY", 4, 229231},
	{"TYRWHITT", 8, 99652},
	{"TYRW", 4, 257398},
	{"TYRUS", 5, 253951},
	{"TYRU", 4, 68067},
	{"TYRT", 4, 240461},
	{"TYRS", 4, 72774},
	{"TYRRHENIAN", 10, 224389},
	{"TYRRELL", 7, 89283},
	{"TYRR", 4, 149864},
	{"TYROSYL", 7, 250983},
	{"TYROSINE", 8, 50411},
	{"TYROSINASE", 10, 195331},
	{"TYROS", 5, 213698},
	{"TYRONE", 6, 52550},
	{"TYRON", 5, 249270},
	{"TYROLIA", 7, 208673},
	{"TYROLEAN", 8, 161469},
	{"TYROL", 5, 94670},
	{"TYRO", 4, 159541},
	{"TYRIE", 5, 192746},
	{"TYRIAN", 6, 260740},
	{"TYRI", 4, 55781},
	{"TYRH", 4, 170094},
	{"TYRESMOKE", 9, 260339},
	{"TYRESE", 6, 124296},
	{"TYRES", 5, 44944},
	{"TYRER", 5, 261472},
	{"TYRELL", 6, 114732},
	{"TYREE", 5, 127150},
	{"TYRE", 4, 49312},
	{"TYRD", 4, 120707},
	{"TYRC", 4, 251153},
	{"TYRANTS", 7, 81635},
	{"TYRANT", 6, 68592},
	{"TYRANNY", 7, 52006},
	{"TYRANNUS", 8, 211150},
	{"TYRANNOSAURUS", 13, 109202},
	{"TYRANNIS", 8, 259386},
	{"TYRANNIES", 9, 201696},
	{"TYRANNICAL", 10, 105893},
	{"TYRAMINE", 8, 204109},
	{"TYRA", 4, 80744},
	{"TYQU", 4, 70683},
	{"TYQ", 3, 4991},
	{"TYPUS", 5, 195473},
	{"TYPS", 4, 161611},
	{"TYPR", 4, 31723},
	{"TYPP", 4, 190925},
	{"TYPOY", 5, 170405},
	{"TYPOS", 5, 60369},
	{"TYPOPHILE", 9, 209433},
	{"TYPOLOGY", 8, 84472},
	{"TYPOLOGIES", 10, 156227},
	{"TYPOLOGICAL", 11, 177450},
	{"TYPOGRAPHY", 10, 63714},
	{"TYPOGRAPHICAL", 13, 52443},
	{"TYPOGRAPHIC", 11, 102751},
	{"TYPO", 4, 49366},
	{"TYPM", 4, 150414},
	{"TYPL", 4, 48889},
	{"TYPISTS", 7, 111992},
	{"TYPIST", 6, 89328},
	{"TYPING", 6, 33263},
	{"TYPIFY", 6, 178234},
	{"TYPIFIES", 8, 162616},
	{"TYPIFIED", 8, 121162},
	{"TYPICALLY", 9, 6047},
	{"TYPICAL", 7, 5664},
	{"TYPI", 4, 167396},
	{"TYPHUS", 6, 135549},
	{"TYPHOONS", 8, 131052},
	{"TYPHOONANUBIS", 13, 166655},
	{"TYPHOON", 7, 54924},
	{"TYPHON", 6, 243602},
	{"TYPHOID", 7, 83133},
	{"TYPHIMURIUM", 11, 93271},
	{"TYPHI", 5, 138744},
	{"TYPHA", 5, 220733},
	{"TYPH", 4, 58950},
	{"TYPEWRITTEN", 11, 114479},
	{"TYPEWRITING", 11, 208893},
	{"TYPEWRITERS", 11, 88785},
	{"TYPEWRITER", 10, 53166},
	{"TYPESTYLER", 10, 229866},
	{"TYPESTYLE", 9, 217613},
	{"TYPESETTING", 11, 83032},
	{"TYPESETTERS", 11, 248344},
	{"TYPESETTER", 10, 179624},
	{"TYPESET", 7, 102083},
	{"TYPESCRIPTS", 11, 224774},
	{"TYPESCRIPT", 10, 94868},
	{"TYPES", 5, 1836},
	{"TYPER", 5, 171618},
	{"TYPEPAD", 7, 39503},
	{"TYPEOF", 6, 92851},
	{"TYPENAME", 8, 82490},
	{"TYPEMAP", 7, 190970},
	{"TYPELIB", 7, 186361},
	{"TYPEKEY", 7, 49946},
	{"TYPEINFO", 8, 147352},
	{"TYPEID", 6, 208210},
	{"TYPEFACES", 9, 111902},
	{"TYPEFACE", 8, 78608},
	{"TYPEERROR", 9, 155464},
	{"TYPEDEFS", 8, 145108},
	{"TYPEDEF", 7, 44985},
	{"TYPED", 5, 39919},
	{"TYPECODE", 8, 190673},
	{"TYPECHECK", 9, 245099},
	{"TYPECAST", 8, 172927},
	{"TYPE", 4, 606},
	{"TYPC", 4, 260857},
	{"TYPA", 4, 253731},
	{"TYOY", 4, 219948},
	{"TYOW", 4, 59149},
	{"TYOV", 4, 57845},
	{"TYOU", 4, 2683},
	{"TYOR", 4, 37262},
	{"TYOP", 4, 67373},
	{"TYON", 4, 35243},
	{"TYOM", 4, 226980},
	{"TYOL", 4, 126038},
	{"TYOK", 4, 123762},
	{"TYOG", 4, 159417},
	{"TYOF", 4, 1806},
	{"TYOD", 4, 206088},
	{"TYOC", 4, 127801},
	{"TYOB", 4, 96878},
	{"TYNY", 4, 173513},
	{"TYNW", 4, 202762},
	{"TYNU", 4, 92888},
	{"TYNJ", 4, 232371},
	{"TYNGSBORO", 9, 156603},
	{"TYNESIDE", 8, 70925},
	{"TYNES", 5, 216925},
	{"TYNER", 5, 112528},
	{"TYNEMOUTH", 9, 170649},
	{"TYNEDALE", 8, 184661},
	{"TYNDAREUS", 9, 261442},
	{"TYNDALL", 7, 98715},
	{"TYNDALE", 7, 97644},
	{"TYND", 4, 118803},
	{"TYNC", 4, 177176},
	{"TYNAN", 5, 118924},
	{"TYMY", 4, 161683},
	{"TYMU", 4, 41665},
	{"TYMS", 4, 244211},
	{"TYMR", 4, 161942},
	{"TYMPANIC", 8, 166660},
	{"TYMPANI", 7, 241066},
	{"TYMP", 4, 157795},
	{"TYMOSHENKO", 10, 141492},
	{"TYMOR", 5, 247846},
	{"TYMO", 4, 43709},
	{"TYMI", 4, 45253},
	{"TYMES", 5, 178031},
	{"TYMERS", 6, 101396},
	{"TYME", 4, 97656},
	{"TYMD", 4, 140721},
	{"TYMC", 4, 127769},
	{"TYMA", 4, 35747},
	{"TYLY", 4, 217267},
	{"TYLU", 4, 89636},
	{"TYLT", 4, 167731},
	{"TYLS", 4, 229506},
	{"TYLOR", 5, 162932},
	{"TYLOON", 6, 220310},
	{"TYLL", 4, 257782},
	{"TYLKO", 5, 132522},
	{"TYLI", 4, 30981},
	{"TYLER", 5, 31734},
	{"TYLENOL", 7, 65275},
	{"TYLENE", 6, 190014},
	{"TYLE", 4, 210179},
	{"TYLDESLEY", 9, 201707},
	{"TYLD", 4, 233234},
	{"TYLC", 4, 185235},
	{"TYLA", 4, 201833},
	{"TYKU", 4, 252837},
	{"TYKR", 4, 189942},
	{"TYKO", 4, 182275},
	{"TYKN", 4, 91868},
	{"TYKI", 4, 67352},
	{"TYKES", 5, 120921},
	{"TYKE", 4, 162819},
	{"TYKA", 4, 101034},
	{"TYJU", 4, 66151},
	{"TYJO", 4, 76666},
	{"TYJI", 4, 236083},
	{"TYJE", 4, 128585},
	{"TYJA", 4, 65038},
	{"TYJ", 3, 1710},
	{"TYIW", 4, 145961},
	{"TYIV", 4, 247250},
	{"TYIS", 4, 7784},
	{"TYIR", 4, 140216},
	{"TYIP", 4, 224873},
	{"TYING", 5, 49209},
	{"TYIN", 4, 4396},
	{"TYIM", 4, 66635},
	{"TYIL", 4, 125949},
	{"TYIG", 4, 217070},
	{"TYIF", 4, 72488},
	{"TYID", 4, 102957},
	{"TYIC", 4, 154309},
	{"TYI", 3, 713},
	{"TYHY", 4, 209286},
	{"TYHU", 4, 79149},
	{"TYHA", 4, 28552},
	{"TYH", 3, 792},
	{"TYGY", 4, 245442},
	{"TYGU", 4, 62912},
	{"TYGR", 4, 48027},
	{"TYGON", 5, 188311},
	{"TYGO", 4, 196277},
	{"TYGL", 4, 130044},
	{"TYGI", 4, 77457},
	{"TYGH", 4, 241414},
	{"TYGER", 5, 134328},
	{"TYGE", 4, 62524},
	{"TYGA", 4, 57504},
	{"TYFU", 4, 62768},
	{"TYFR", 4, 42129},
	{"TYFO", 4, 8131},
	{"TYFL", 4, 76833},
	{"TYFI", 4, 39977},
	{"TYFE", 4, 60375},
	{"TYFC", 4, 180772},
	{"TYFA", 4, 49339},
	{"TYEY", 4, 220600},
	{"TYEX", 4, 49937},
	{"TYEV", 4, 58467},
	{"TYEU", 4, 245119},
	{"TYERS", 5, 157071},
	{"TYEQ", 4, 120483},
	{"TYEP", 4, 153188},
	{"TYEM", 4, 67829},
	{"TYEL", 4, 63062},
	{"TYEG", 4, 161684},
	{"TYEF", 4, 115586},
	{"TYED", 4, 74625},
	{"TYEC", 4, 118093},
	{"TYEA", 4, 2572},
	{"TYDW", 4, 168724},
	{"TYDU", 4, 56051},
	{"TYDR", 4, 69024},
	{"TYDO", 4, 51946},
	{"TYDI", 4, 42559},
	{"TYDFIL", 6, 103232},
	{"TYDA", 4, 56308},
	{"TYCY", 4, 187738},
	{"TYCU", 4, 76550},
	{"TYCR", 4, 55526},
	{"TYCOONS", 7, 177674},
	{"TYCOON", 6, 45392},
	{"TYCOM", 5, 220011},
	{"TYCO", 4, 62443},
	{"TYCL", 4, 50489},
	{"TYCI", 4, 74455},
	{"TYCHO", 5, 105524},
	{"TYCE", 4, 133402},
	{"TYCD", 4, 234578},
	{"TYCC", 4, 250470},
	{"TYBY", 4, 47345},
	{"TYBU", 4, 37100},
	{"TYBR", 4, 59671},
	{"TYBO", 4, 44294},
	{"TYBL", 4, 72812},
	{"TYBI", 4, 65642},
	{"TYBEE", 5, 125138},
	{"TYBE", 4, 37016},
	{"TYBC", 4, 230588},
	{"TYBALT", 6, 246023},
	{"TYBA", 4, 44423},
	{"TYB", 3, 790},
	{"TYAY", 4, 185870},
	{"TYAW", 4, 85211},
	{"TYAV", 4, 91739},
	{"TYAU", 4, 80697},
	{"TYAR", 4, 33929},
	{"TYAP", 4, 58077},
	{"TYAM", 4, 55278},
	{"TYAL", 4, 41621},
	{"TYAK", 4, 129181},
	{"TYAJ", 4, 199354},
	{"TYAGI", 5, 205270},
	{"TYAG", 4, 55847},
	{"TYAF", 4, 54673},
	{"TYAD", 4, 52345},
	{"TYAC", 4, 47031},
	{"TYAB", 4, 57941},
	{"TXVI", 4, 127802},
	{"TXTWORKCOUNTRY", 14, 195239},
	{"TXTUNIQUEMEMBERID", 17, 254443},
	{"TXTHOMECOUNTRY", 14, 195240},
	{"TXT", 3, 286},
	{"TXRA", 4, 169269},
	{"TXOR", 4, 260455},
	{"TXMT", 4, 198969},
	{"TXGENWEB", 8, 229935},
	{"TXER", 4, 252496},
	{"TXDOT", 5, 93838},
	{"TXCN", 4, 238708},
	{"TXBO", 4, 207359},
	{"TXAV", 4, 137861},
	{"TX", 2, 246},
	{"TWYT", 4, 211075},
	{"TWYO", 4, 168543},
	{"TWYN", 4, 173826},
	{"TWYMAN", 6, 219867},
	{"TWYLA", 5, 173566},
	{"TWYFORD", 7, 151361},
	{"TWYFELFONTEIN", 13, 252388},
	{"TWYC", 4, 257027},
	{"TWYA", 4, 239045},
	{"TWWW", 4, 42255},
	{"TWWLY", 5, 193297},
	{"TWWI", 4, 192072},
	{"TWWE", 4, 176770},
	{"TWUR", 4, 222171},
	{"TWTF", 4, 241007},
	{"TWSU", 4, 216863},
	{"TWSP", 4, 219471},
	{"TWSOCKET", 8, 140632},
	{"TWRO", 4, 54593},
	{"TWRISTIAETH", 11, 243558},
	{"TWRE", 4, 69866},
	{"TWRA", 4, 183783},
	{"TWPU", 4, 185805},
	{"TWOZ", 4, 184856},
	{"TWOY", 4, 8684},
	{"TWOW", 4, 28814},
	{"TWOV", 4, 50413},
	{"TWOULD", 6, 260270},
	{"TWOU", 4, 3286},
	{"TWOT", 4, 9221},
	{"TWOSOME", 7, 172241},
	{"TWOR", 4, 2493},
	{"TWOQ", 4, 78403},
	{"TWOP", 4, 135478},
	{"TWOO", 4, 7099},
	{"TWON", 4, 30508},
	{"TWOMEY", 6, 138074},
	{"TWOMBLY", 7, 195188},
	{"TWOM", 4, 7369},
	{"TWOL", 4, 37615},
	{"TWOK", 4, 58448},
	{"TWOJ", 4, 75673},
	{"TWOHY", 5, 256135},
	{"TWOH", 4, 32936},
	{"TWOG", 4, 33272},
	{"TWOFTPD", 7, 157132},
	{"TWOFOLD", 7, 76011},
	{"TWOFISH", 7, 193308},
	{"TWOF", 4, 34211},
	{"TWOD", 4, 28674},
	{"TWOCHANNEL", 10, 104777},
	{"TWOC", 4, 28463},
	{"TWOB", 4, 33136},
	{"TWOA", 4, 31523},
	{"TWO-THIRDS", 10, 34467},
	{"TWO", 3, 362},
	{"TWMA", 4, 223753},
	{"TWIZTID", 7, 51201},
	{"TWIZEL", 6, 232900},
	{"TWIZ", 4, 160181},
	{"TWIXT", 5, 182138},
	{"TWIX", 4, 166962},
	{"TWIV", 4, 254229},
	{"TWITTY", 6, 122636},
	{"TWITTERING", 10, 228536},
	{"TWITS", 5, 191258},
	{"TWITCHY", 7, 175870},
	{"TWITCHING", 9, 98019},
	{"TWITCHGURU", 10, 109239},
	{"TWITCHES", 8, 165383},
	{"TWITCHELL", 9, 202556},
	{"TWITCHED", 8, 151004},
	{"TWITCH", 6, 75483},
	{"TWISTYS", 7, 125553},
	{"TWISTY", 6, 109448},
	{"TWISTS", 6, 56961},
	{"TWISTOR", 7, 260427},
	{"TWISTING", 8, 58044},
	{"TWISTIES", 8, 222552},
	{"TWISTERS", 8, 115785},
	{"TWISTER", 7, 58961},
	{"TWISTED", 7, 33512},
	{"TWISTA", 6, 96184},
	{"TWIST", 5, 30323},
	{"TWISS", 5, 210336},
	{"TWISP", 5, 231718},
	{"TWIRLS", 6, 219336},
	{"TWIRLING", 8, 105817},
	{"TWIRLED", 7, 199155},
	{"TWIRL", 5, 109732},
	{"TWIR", 4, 76194},
	{"TWIP", 4, 120268},
	{"TWINX", 5, 144742},
	{"TWINTALK", 8, 213506},
	{"TWINSTUFF", 9, 169576},
	{"TWINSET", 7, 253449},
	{"TWINSBURG", 9, 147027},
	{"TWINSANITY", 10, 224066},
	{"TWINS", 5, 31235},
	{"TWINROOM", 8, 181745},
	{"TWINPRIME", 9, 231154},
	{"TWINNING", 8, 94572},
	{"TWINNED", 7, 165736},
	{"TWINN", 5, 182591},
	{"TWINMOS", 7, 99911},
	{"TWINLAB", 7, 69975},
	{"TWINKS", 6, 30476},
	{"TWINKLING", 9, 100258},
	{"TWINKLES", 8, 256212},
	{"TWINKLED", 8, 219449},
	{"TWINKLE", 7, 66608},
	{"TWINKIES", 8, 161908},
	{"TWINKIE", 7, 112667},
	{"TWINK", 5, 46015},
	{"TWININGS", 8, 207394},
	{"TWINING", 7, 133104},
	{"TWINHEAD", 8, 101600},
	{"TWINHAN", 7, 202011},
	{"TWINGE", 6, 164205},
	{"TWINED", 6, 201627},
	{"TWINE", 5, 86618},
	{"TWINAX", 6, 176842},
	{"TWIN", 4, 7311},
	{"TWIM", 4, 103219},
	{"TWILLINGATE", 11, 225945},
	{"TWILL", 5, 53521},
	{"TWILIGHT", 8, 36798},
	{"TWILA", 5, 174181},
	{"TWIL", 4, 3039},
	{"TWIKIWEBSTABLE", 14, 232149},
	{"TWIKIWEB", 8, 92229},
	{"TWIKIVARIABLESNTOZ", 18, 149415},
	{"TWIKIVARIABLESATOM", 18, 195444},
	{"TWIKIVARIABLES", 14, 70691},
	{"TWIKIUSERS", 10, 77461},
	{"TWIKIUSERAUTHENTICATION", 23, 163874},
	{"TWIKITUTORIAL", 13, 195225},
	{"TWIKITOPICS", 11, 237850},
	{"TWIKITEMPLATES", 14, 147746},
	{"TWIKISYSTEMREQUIREMENTS", 23, 222303},
	{"TWIKISKINS", 10, 178747},
	{"TWIKISITETOOLS", 14, 180737},
	{"TWIKISITE", 9, 138735},
	{"TWIKISHORTHAND", 14, 261350},
	{"TWIKIROOT", 9, 97341},
	{"TWIKIREGISTRATIONPUB", 20, 219786},
	{"TWIKIREGISTRATION", 17, 112441},
	{"TWIKIPREFERENCES", 16, 69981},
	{"TWIKIPLUGINS", 12, 161263},
	{"TWIKIMETADATA", 13, 135319},
	{"TWIKIINSTALLATIONGUIDE", 22, 141760},
	{"TWIKIHISTORY", 12, 155736},
	{"TWIKIGUEST", 10, 74986},
	{"TWIKIGROUPS", 11, 138948},
	{"TWIKIFUNCMODULE", 15, 175798},
	{"TWIKIFORMS", 10, 104664},
	{"TWIKIFAQ", 8, 192007},
	{"TWIKIDOCGRAPHICS", 16, 159830},
	{"TWIKICONTRIBUTOR", 16, 217444},
	{"TWIKICATEGORYTABLE", 18, 252404},
	{"TWIKIADMINGROUP", 15, 111502},
	{"TWIKIACCESSCONTROL", 18, 82701},
	{"TWIKI", 5, 7825},
	{"TWIK", 4, 141098},
	{"TWIGS", 5, 83557},
	{"TWIGGY", 6, 139826},
	{"TWIGGS", 6, 156076},
	{"TWIGG", 5, 141265},
	{"TWIG", 4, 74709},
	{"TWIF", 4, 69006},
	{"TWIDTH", 6, 230991},
	{"TWIDDLING", 9, 195762},
	{"TWIDDLE", 7, 182322},
	{"TWID", 4, 48724},
	{"TWICKENHAM", 10, 79106},
	{"TWICE", 5, 4392},
	{"TWHY", 4, 49922},
	{"TWHO", 4, 8173},
	{"TWHI", 4, 4653},
	{"TWHE", 4, 4034},
	{"TWHA", 4, 7386},
	{"TWEW", 4, 39011},
	{"TWEV", 4, 52744},
	{"TWEU", 4, 117132},
	{"TWES", 4, 34401},
	{"TWERE", 5, 225047},
	{"TWER", 4, 6735},
	{"TWEP", 4, 76949},
	{"TWENTYSOMETHINGS", 16, 246448},
	{"TWENTYSOMETHING", 15, 167015},
	{"TWENTYONE", 9, 133546},
	{"TWENTYNINE", 10, 124996},
	{"TWENTY", 6, 605},
	{"TWENTIETH", 9, 34743},
	{"TWENTIES", 8, 68421},
	{"TWENTE", 6, 110536},
	{"TWEM", 4, 59209},
	{"TWELVES", 7, 260923},
	{"TWELVE", 6, 604},
	{"TWELFTH", 7, 54400},
	{"TWEL", 4, 29680},
	{"TWEK", 4, 73236},
	{"TWEJ", 4, 99289},
	{"TWEG", 4, 72601},
	{"TWEF", 4, 76078},
	{"TWEEZERS", 8, 82807},
	{"TWEEZERMAN", 10, 102259},
	{"TWEEZER", 7, 136100},
	{"TWEETY", 6, 85415},
	{"TWEETERS", 8, 109314},
	{"TWEETER", 7, 71389},
	{"TWEET", 5, 125965},
	{"TWEENS", 6, 124340},
	{"TWEENING", 8, 241685},
	{"TWEENIES", 8, 140795},
	{"TWEEN", 5, 62315},
	{"TWEEKS", 6, 187701},
	{"TWEEK", 5, 192568},
	{"TWEEDY", 6, 106390},
	{"TWEEDSMUIR", 10, 199832},
	{"TWEEDS", 6, 258437},
	{"TWEEDLE", 7, 197693},
	{"TWEEDIE", 7, 139296},
	{"TWEEDEN", 7, 188502},
	{"TWEEDEHANDS", 11, 191738},
	{"TWEEDE", 6, 172292},
	{"TWEEDDALE", 9, 189154},
	{"TWEED", 5, 51842},
	{"TWED", 4, 38023},
	{"TWEC", 4, 40252},
	{"TWEB", 4, 229634},
	{"TWEAKUI", 7, 258998},
	{"TWEAKTOWN", 9, 209224},
	{"TWEAKS", 6, 56085},
	{"TWEAKING", 8, 62069},
	{"TWEAKERS", 8, 200728},
	{"TWEAKER", 7, 144626},
	{"TWEAKED", 7, 79007},
	{"TWEAK", 5, 51058},
	{"TWEA", 4, 30915},
	{"TWDB", 4, 216185},
	{"TWBA", 4, 242169},
	{"TWAYNE", 6, 201942},
	{"TWAX", 4, 203978},
	{"TWAV", 4, 61395},
	{"TWAU", 4, 200560},
	{"TWATTS", 6, 196269},
	{"TWATT", 5, 195467},
	{"TWATS", 5, 129983},
	{"TWAR", 4, 6722},
	{"TWAP", 4, 258158},
	{"TWANGY", 6, 230232},
	{"TWANG", 5, 107970},
	{"TWAM", 4, 238494},
	{"TWAL", 4, 37937},
	{"TWAK", 4, 87504},
	{"TWAIN", 5, 37718},
	{"TWAG", 4, 83779},
	{"TWAF", 4, 91300},
	{"TWADDLE", 7, 179929},
	{"TWAD", 4, 105734},
	{"TWACOMM", 7, 235124},
	{"TWAC", 4, 129455},
	{"TWAB", 4, 243622},
	{"TVYO", 4, 213408},
	{"TVWO", 4, 115848},
	{"TVWI", 4, 115380},
	{"TVWH", 4, 112946},
	{"TVWE", 4, 144823},
	{"TVWA", 4, 111751},
	{"TVVI", 4, 122747},
	{"TVVE", 4, 195090},
	{"TVV", 3, 28344},
	{"TVUS", 4, 221936},
	{"TVUN", 4, 198068},
	{"TVUL", 4, 89477},
	{"TVTU", 4, 225548},
	{"TVTR", 4, 166458},
	{"TVSY", 4, 211076},
	{"TVSW", 4, 158429},
	{"TVSU", 4, 164893},
	{"TVSR", 4, 209495},
	{"TVSPY", 5, 178362},
	{"TVSP", 4, 102069},
	{"TVSM", 4, 168995},
	{"TVSL", 4, 200017},
	{"TVSF", 4, 186765},
	{"TVSD", 4, 197580},
	{"TVSC", 4, 101475},
	{"TVSB", 4, 185490},
	{"TVRI", 4, 186276},
	{"TVRE", 4, 94879},
	{"TVRADIOWORLD", 12, 251593},
	{"TVRA", 4, 125157},
	{"TVPR", 4, 78215},
	{"TVPO", 4, 244524},
	{"TVPL", 4, 180878},
	{"TVPI", 4, 227936},
	{"TVPG", 4, 204214},
	{"TVPE", 4, 157106},
	{"TVPA", 4, 180319},
	{"TVOY", 4, 152532},
	{"TVOW", 4, 117453},
	{"TVOUT", 5, 259944},
	{"TVOU", 4, 167063},
	{"TVOR", 4, 103802},
	{"TVOP", 4, 250823},
	{"TVOL", 4, 49866},
	{"TVOG", 4, 250824},
	{"TVOF", 4, 190926},
	{"TVOD", 4, 217710},
	{"TVNZ", 4, 129393},
	{"TVNEWSER", 8, 185467},
	{"TVMU", 4, 234897},
	{"TVMO", 4, 92232},
	{"TVMI", 4, 168725},
	{"TVME", 4, 226981},
	{"TVMA", 4, 124487},
	{"TVLO", 4, 210883},
	{"TVLI", 4, 149066},
	{"TVLA", 4, 107208},
	{"TVJO", 4, 261202},
	{"TVIV", 4, 140260},
	{"TVIR", 4, 43445},
	{"TVIP", 4, 220180},
	{"TVIM", 4, 231077},
	{"TVILUM", 6, 201685},
	{"TVIL", 4, 52308},
	{"TVIK", 4, 139360},
	{"TVIJ", 4, 261574},
	{"TVIG", 4, 109517},
	{"TVID", 4, 61669},
	{"TVIC", 4, 42519},
	{"TVIB", 4, 129801},
	{"TVGUIDE", 7, 251637},
	{"TVGU", 4, 91423},
	{"TVGO", 4, 255286},
	{"TVGASM", 6, 222965},
	{"TVGA", 4, 178301},
	{"TVFR", 4, 162295},
	{"TVFO", 4, 109436},
	{"TVFI", 4, 168083},
	{"TVFA", 4, 234296},
	{"TVEX", 4, 159418},
	{"TVEV", 4, 196613},
	{"TVERSKY", 7, 172035},
	{"TVERSKAYA", 9, 251013},
	{"TVER", 4, 185036},
	{"TVEP", 4, 235491},
	{"TVEL", 4, 107997},
	{"TVEJ", 4, 225079},
	{"TVEIT", 5, 240827},
	{"TVEG", 4, 94411},
	{"TVED", 4, 162621},
	{"TVECTOR", 7, 256536},
	{"TVEC", 4, 132180},
	{"TVEB", 4, 225988},
	{"TVDR", 4, 156113},
	{"TVDO", 4, 163142},
	{"TVDI", 4, 154642},
	{"TVDE", 4, 141683},
	{"TVCU", 4, 261575},
	{"TVCR", 4, 163929},
	{"TVCO", 4, 74456},
	{"TVCL", 4, 257028},
	{"TVCI", 4, 257481},
	{"TVCH", 4, 88023},
	{"TVCA", 4, 95782},
	{"TVBU", 4, 137288},
	{"TVBR", 4, 127957},
	{"TVBO", 4, 219054},
	{"TVBGONE", 7, 240977},
	{"TVBE", 4, 141684},
	{"TVBA", 4, 217951},
	{"TVAZ", 4, 251467},
	{"TVAW", 4, 215462},
	{"TVAU", 4, 115281},
	{"TVAR", 4, 43339},
	{"TVAP", 4, 132624},
	{"TVAM", 4, 133013},
	{"TVAG", 4, 157970},
	{"TVAF", 4, 187865},
	{"TVAD", 4, 223661},
	{"TVAB", 4, 247251},
	{"TUZZ", 4, 198518},
	{"TUZLA", 5, 166648},
	{"TUYV", 4, 186766},
	{"TUYEN", 5, 178263},
	{"TUYE", 4, 258898},
	{"TUXTLA", 6, 230800},
	{"TUXPAINT", 8, 199593},
	{"TUXES", 5, 136401},
	{"TUXEDOS", 7, 77498},
	{"TUXEDO", 6, 54087},
	{"TUXE", 4, 112198},
	{"TUWI", 4, 202059},
	{"TUWH", 4, 183849},
	{"TUWE", 4, 258541},
	{"TUWA", 4, 138129},
	{"TUW", 3, 7952},
	{"TUVOK", 5, 178962},
	{"TUVI", 4, 225989},
	{"TUVALUAN", 8, 243788},
	{"TUVALU", 6, 40917},
	{"TUVA", 4, 165325},
	{"TUUM", 4, 224381},
	{"TUULI", 5, 237620},
	{"TUTZ", 4, 196455},
	{"TUTWILER", 8, 209340},
	{"TUTUS", 5, 228854},
	{"TUTU", 4, 87270},
	{"TUTTO", 5, 79051},
	{"TUTTLE", 6, 63344},
	{"TUTTI", 5, 61208},
	{"TUTTE", 5, 83637},
	{"TUTTA", 5, 157781},
	{"TUTSIS", 6, 173990},
	{"TUTSI", 5, 128733},
	{"TUTR", 4, 199687},
	{"TUTOS", 5, 243379},
	{"TUTORS", 6, 45966},
	{"TUTORING", 8, 42503},
	{"TUTORIALS", 9, 6711},
	{"TUTORIALES", 10, 164354},
	{"TUTORIAL", 8, 6692},
	{"TUTORED", 7, 131918},
	{"TUTOR", 5, 37470},
	{"TUTIONS", 7, 189602},
	{"TUTIONAL", 8, 243744},
	{"TUTION", 6, 160779},
	{"TUTICORIN", 9, 207409},
	{"TUTHILL", 7, 161630},
	{"TUTF", 4, 253894},
	{"TUTES", 5, 201660},
	{"TUTELAGE", 8, 121927},
	{"TUTELA", 6, 236167},
	{"TUTD", 4, 220601},
	{"TUTC", 4, 115725},
	{"TUTANKHAMUN", 11, 132240},
	{"TUTANKHAMEN", 11, 177255},
	{"TUSZ", 4, 205385},
	{"TUSY", 4, 217268},
	{"TUSW", 4, 57325},
	{"TUSV", 4, 117667},
	{"TUSU", 4, 47540},
	{"TUSTIN", 6, 77462},
	{"TUSSOCK", 7, 163399},
	{"TUSSLE", 6, 130953},
	{"TUSSIONEX", 9, 255259},
	{"TUSSIN", 6, 179712},
	{"TUSSEN", 6, 125447},
	{"TUSSAUDS", 8, 153932},
	{"TUSSAUD", 7, 184213},
	{"TUSR", 4, 76084},
	{"TUSQ", 4, 74587},
	{"TUSP", 4, 70623},
	{"TUSM", 4, 71554},
	{"TUSL", 4, 84479},
	{"TUSKS", 5, 138297},
	{"TUSKERS", 7, 251245},
	{"TUSKER", 6, 175212},
	{"TUSKEGEE", 8, 84217},
	{"TUSK", 4, 107566},
	{"TUSJ", 4, 146519},
	{"TUSHY", 5, 124007},
	{"TUSHNET", 7, 159521},
	{"TUSHAR", 6, 156792},
	{"TUSG", 4, 98545},
	{"TUSF", 4, 59542},
	{"TUSE", 4, 9794},
	{"TUSCULUM", 8, 159113},
	{"TUSCON", 6, 143924},
	{"TUSCOLA", 7, 118577},
	{"TUSCARORA", 9, 140282},
	{"TUSCARAWAS", 10, 117796},
	{"TUSCANY", 7, 41577},
	{"TUSCAN", 6, 60603},
	{"TUSCALOOSA", 10, 62058},
	{"TUSCADERO", 9, 241440},
	{"TUSC", 4, 259493},
	{"TUSB", 4, 61525},
	{"TURY", 4, 216954},
	{"TURW", 4, 212622},
	{"TURVY", 5, 127225},
	{"TURVILLE", 8, 221609},
	{"TURVEY", 6, 181519},
	{"TURV", 4, 161943},
	{"TURUN", 5, 253830},
	{"TURU", 4, 125888},
	{"TURTURRO", 8, 145318},
	{"TURTON", 6, 142378},
	{"TURTLES", 7, 44607},
	{"TURTLENECKS", 11, 146852},
	{"TURTLENECK", 10, 83324},
	{"TURTLEDOVE", 10, 157212},
	{"TURTLEBACK", 10, 227435},
	{"TURTLE", 6, 36112},
	{"TURT", 4, 53748},
	{"TURSIOPS", 8, 244085},
	{"TURSER", 6, 163723},
	{"TURS", 4, 115344},
	{"TURRIFF", 7, 210732},
	{"TURRETS", 7, 108073},
	{"TURRET", 6, 71494},
	{"TURRENTINE", 10, 211935},
	{"TURRELL", 7, 188786},
	{"TURRAMURRA", 10, 248575},
	{"TURRALL", 7, 211615},
	{"TURR", 4, 64976},
	{"TURQUOISE", 9, 42408},
	{"TURQUIE", 7, 165413},
	{"TURQUESA", 8, 197242},
	{"TURQ", 4, 236596},
	{"TURPITUDE", 9, 152489},
	{"TURPIS", 6, 147815},
	{"TURPIN", 6, 104187},
	{"TURPENTINE", 10, 127411},
	{"TURPAN", 6, 242547},
	{"TURP", 4, 206388},
	{"TUROW", 5, 174319},
	{"TUROK", 5, 129382},
	{"TURNTABLISTS", 12, 153165},
	{"TURNTABLIST", 11, 236302},
	{"TURNTABLISM", 11, 156670},
	{"TURNTABLES", 10, 59587},
	{"TURNTABLE", 9, 54487},
	{"TURNSTONE", 9, 190957},
	{"TURNSTILES", 10, 154413},
	{"TURNSTILE", 9, 157864},
	{"TURNS", 5, 6782},
	{"TURNPIKE", 8, 55779},
	{"TURNOVR", 7, 53681},
	{"TURNOVO", 7, 225262},
	{"TURNOVERS", 9, 62621},
	{"TURNOVER", 8, 36913},
	{"TURNOUTS", 8, 155553},
	{"TURNOUT", 7, 49915},
	{"TURNOFF", 7, 132837},
	{"TURNMILLS", 9, 226907},
	{"TURNKEY", 7, 55070},
	{"TURNIPS", 7, 119153},
	{"TURNIP", 6, 95300},
	{"TURNINGS", 8, 161086},
	{"TURNING", 7, 7270},
	{"TURNIN", 6, 167537},
	{"TURNIER", 7, 235402},
	{"TURNHOUT", 8, 186532},
	{"TURNHAM", 7, 258111},
	{"TURNEY", 6, 150617},
	{"TURNERSVILLE", 12, 233377},
	{"TURNERS", 7, 99144},
	{"TURNER", 6, 28441},
	{"TURNED", 6, 3665},
	{"TURNDOWN", 8, 123777},
	{"TURNCOAT", 8, 228337},
	{"TURNBULL", 8, 67812},
	{"TURNBUCKLES", 11, 228892},
	{"TURNBUCKLE", 10, 157710},
	{"TURNBERRY", 9, 129107},
	{"TURNAROUNDS", 11, 133684},
	{"TURNAROUND", 10, 48888},
	{"TURNAGE", 7, 223821},
	{"TURNABOUT", 9, 160068},
	{"TURN", 4, 999},
	{"TURMOIL", 7, 57335},
	{"TURMERIC", 8, 94464},
	{"TURMEL", 6, 261791},
	{"TURMAN", 6, 214655},
	{"TURLOUGH", 8, 221094},
	{"TURLOCK", 7, 100467},
	{"TURLINGTON", 10, 168349},
	{"TURLEY", 6, 101679},
	{"TURKU", 5, 77178},
	{"TURKS", 5, 36749},
	{"TURKOMAN", 8, 168760},
	{"TURKOGLU", 8, 248019},
	{"TURKMENISTAN", 12, 37375},
	{"TURKMEN", 7, 92342},
	{"TURKLE", 6, 232145},
	{"TURKIYE", 7, 126932},
	{"TURKISTAN", 9, 206690},
	{"TURKISH", 7, 9529},
	{"TURKIJE", 7, 177578},
	{"TURKIC", 6, 130794},
	{"TURKI", 5, 152310},
	{"TURKEYS", 7, 68022},
	{"TURKEY", 6, 30479},
	{"TURKESTAN", 9, 154259},
	{"TURKEL", 6, 218817},
	{"TURKCELL", 8, 241671},
	{"TURKCE", 6, 175406},
	{"TURKANA", 7, 192594},
	{"TURK", 4, 59333},
	{"TURISTICO", 9, 247473},
	{"TURISTICI", 9, 206050},
	{"TURISTICHE", 10, 183659},
	{"TURISTICA", 9, 188815},
	{"TURISTAS", 8, 254555},
	{"TURISTA", 7, 236280},
	{"TURIST", 6, 206031},
	{"TURISMO", 7, 47052},
	{"TURISM", 6, 205797},
	{"TURION", 6, 97881},
	{"TURING", 6, 61190},
	{"TURIN", 5, 50131},
	{"TURI", 4, 167618},
	{"TURH", 4, 193629},
	{"TURGID", 6, 178931},
	{"TURGEON", 7, 164122},
	{"TURGENEV", 8, 197894},
	{"TURG", 4, 54101},
	{"TURFWAY", 7, 197542},
	{"TURFGRASS", 9, 104798},
	{"TURF", 4, 42048},
	{"TURES", 5, 76305},
	{"TURER", 5, 232317},
	{"TUREK", 5, 157264},
	{"TUREEN", 6, 148423},
	{"TURED", 5, 143060},
	{"TURE", 4, 54646},
	{"TURDUS", 6, 169507},
	{"TURDS", 5, 156488},
	{"TURD", 4, 99164},
	{"TURCOTTE", 8, 156808},
	{"TURCO", 5, 118266},
	{"TURCK", 5, 178330},
	{"TURBULENT", 9, 52585},
	{"TURBULENCE", 10, 51596},
	{"TURBOTAX", 8, 86377},
	{"TURBOT", 6, 175573},
	{"TURBOSOUND", 10, 245918},
	{"TURBOS", 6, 113353},
	{"TURBOPROP", 9, 145650},
	{"TURBONET", 8, 256251},
	{"TURBOMACHINERY", 14, 182723},
	{"TURBOLINUX", 10, 110986},
	{"TURBOJET", 8, 208691},
	{"TURBOGRAFX", 10, 102330},
	{"TURBOGEARS", 10, 171418},
	{"TURBOFAN", 8, 222832},
	{"TURBOESPRIT", 11, 187523},
	{"TURBODIESEL", 11, 235414},
	{"TURBOCHARGING", 13, 261857},
	{"TURBOCHARGERS", 13, 164041},
	{"TURBOCHARGER", 12, 119389},
	{"TURBOCHARGED", 12, 122437},
	{"TURBOCAD", 8, 182112},
	{"TURBOCACHE", 10, 256566},
	{"TURBO", 5, 28650},
	{"TURBINES", 8, 53261},
	{"TURBINE", 7, 41588},
	{"TURBIDITY", 9, 70890},
	{"TURBID", 6, 144808},
	{"TURBEVILLE", 10, 246106},
	{"TURBANS", 7, 153697},
	{"TURBAN", 6, 104385},
	{"TURBA", 5, 155670},
	{"TURB", 4, 139779},
	{"TURANGI", 7, 247041},
	{"TURANDOT", 8, 179851},
	{"TURAN", 5, 136069},
	{"TURAL", 5, 108461},
	{"TURABIAN", 8, 173281},
	{"TURA", 4, 146865},
	{"TUPW", 4, 46937},
	{"TUPV", 4, 173627},
	{"TUPU", 4, 93782},
	{"TUPT", 4, 35608},
	{"TUPS", 4, 47127},
	{"TUPR", 4, 81790},
	{"TUPQ", 4, 257029},
	{"TUPPERWARE", 10, 79454},
	{"TUPPER", 6, 114224},
	{"TUPPENCE", 8, 207072},
	{"TUPP", 4, 64767},
	{"TUPOLEV", 7, 160562},
	{"TUPO", 4, 43307},
	{"TUPN", 4, 108319},
	{"TUPM", 4, 78209},
	{"TUPLES", 6, 75321},
	{"TUPLE", 5, 55040},
	{"TUPL", 4, 80841},
	{"TUPK", 4, 195573},
	{"TUPJ", 4, 160649},
	{"TUPH", 4, 66347},
	{"TUPG", 4, 87408},
	{"TUPF", 4, 54463},
	{"TUPELO", 6, 73728},
	{"TUPE", 4, 203403},
	{"TUPD", 4, 67980},
	{"TUPC", 4, 71754},
	{"TUPB", 4, 56110},
	{"TUPAC", 5, 62686},
	{"TUOU", 4, 63845},
	{"TUOTE", 5, 181904},
	{"TUONG", 5, 159516},
	{"TUOMO", 5, 236918},
	{"TUOMINEN", 8, 251904},
	{"TUOMAS", 6, 129520},
	{"TUOLUMNE", 8, 94530},
	{"TUOHY", 5, 212490},
	{"TUOF", 4, 183125},
	{"TUOB", 4, 203118},
	{"TUNYA", 5, 254315},
	{"TUNW", 4, 110951},
	{"TUNV", 4, 160039},
	{"TUNU", 4, 74399},
	{"TUNTURI", 7, 125335},
	{"TUNT", 4, 30371},
	{"TUNSTALL", 8, 88593},
	{"TUNR", 4, 79957},
	{"TUNP", 4, 85326},
	{"TUNNY", 5, 253348},
	{"TUNNING", 7, 60652},
	{"TUNNEY", 6, 134004},
	{"TUNNELS", 7, 47826},
	{"TUNNELLING", 10, 109872},
	{"TUNNELL", 7, 184191},
	{"TUNNELING", 9, 58640},
	{"TUNNELED", 8, 151822},
	{"TUNNEL", 6, 28934},
	{"TUNN", 4, 35664},
	{"TUNM", 4, 121103},
	{"TUNKU", 5, 228381},
	{"TUNKHANNOCK", 11, 190259},
	{"TUNK", 4, 83084},
	{"TUNJ", 4, 224638},
	{"TUNITY", 6, 158384},
	{"TUNITIES", 8, 171843},
	{"TUNISIE", 7, 130601},
	{"TUNISIAN", 8, 70632},
	{"TUNISIA", 7, 32709},
	{"TUNIS", 5, 68810},
	{"TUNINGSTRUCT", 12, 203158},
	{"TUNINGS", 7, 134011},
	{"TUNING", 6, 31727},
	{"TUNICS", 6, 149228},
	{"TUNICK", 6, 239843},
	{"TUNICA", 6, 73035},
	{"TUNIC", 5, 69546},
	{"TUNI", 4, 4683},
	{"TUNGUSKA", 8, 217620},
	{"TUNGSTEN", 8, 39918},
	{"TUNG", 4, 63127},
	{"TUNF", 4, 61759},
	{"TUNEZ", 5, 259782},
	{"TUNEWEAR", 8, 167100},
	{"TUNEUP", 6, 126557},
	{"TUNESIA", 7, 234493},
	{"TUNES", 5, 33191},
	{"TUNERS", 6, 51092},
	{"TUNER", 5, 33970},
	{"TUNEL", 5, 170925},
	{"TUNEFUL", 7, 159006},
	{"TUNED", 5, 39657},
	{"TUNECAST", 8, 205981},
	{"TUNE", 4, 30240},
	{"TUNDRA", 6, 55192},
	{"TUNDE", 5, 257522},
	{"TUND", 4, 10049},
	{"TUNC", 4, 132583},
	{"TUNBRIDGE", 9, 74098},
	{"TUNB", 4, 86552},
	{"TUNAS", 5, 143504},
	{"TUNARE", 6, 247500},
	{"TUNABLE", 7, 84040},
	{"TUMWATER", 8, 136239},
	{"TUMW", 4, 92673},
	{"TUMUT", 5, 181331},
	{"TUMULUS", 7, 261319},
	{"TUMULTUOUS", 10, 90215},
	{"TUMULT", 6, 110298},
	{"TUMU", 4, 86466},
	{"TUMT", 4, 82465},
	{"TUMS", 4, 149625},
	{"TUMR", 4, 167998},
	{"TUMP", 4, 60030},
	{"TUMOURS", 7, 68832},
	{"TUMOUR", 6, 57933},
	{"TUMORS", 6, 39067},
	{"TUMORIGENICITY", 14, 257681},
	{"TUMORIGENIC", 11, 202673},
	{"TUMORIGENESIS", 13, 146956},
	{"TUMOR", 5, 32599},
	{"TUMO", 4, 53280},
	{"TUMNUS", 6, 244958},
	{"TUMN", 4, 51247},
	{"TUMMY", 5, 51271},
	{"TUMMIES", 7, 215296},
	{"TUMM", 4, 83833},
	{"TUML", 4, 142790},
	{"TUMK", 4, 238216},
	{"TUMI", 4, 100514},
	{"TUMH", 4, 130473},
	{"TUMG", 4, 126774},
	{"TUMF", 4, 104213},
	{"TUMESCENT", 9, 160802},
	{"TUMERIC", 7, 247448},
	{"TUMEFACIENS", 11, 150624},
	{"TUME", 4, 44391},
	{"TUMD", 4, 135163},
	{"TUMC", 4, 100283},
	{"TUMBNAILS", 9, 186326},
	{"TUMBNAIL", 8, 233413},
	{"TUMBLING", 8, 69225},
	{"TUMBLIN", 7, 231675},
	{"TUMBLEWEEDS", 11, 197069},
	{"TUMBLEWEED", 10, 102606},
	{"TUMBLES", 7, 141573},
	{"TUMBLERS", 8, 86516},
	{"TUMBLER", 7, 71248},
	{"TUMBLED", 7, 78206},
	{"TUMBLE", 6, 48993},
	{"TUMBA", 5, 204382},
	{"TUMA", 4, 202134},
	{"TULY", 4, 257783},
	{"TULUM", 5, 95631},
	{"TULT", 4, 61558},
	{"TULSI", 5, 182692},
	{"TULSE", 5, 230680},
	{"TULSA", 5, 35737},
	{"TULS", 4, 61386},
	{"TULR", 4, 244808},
	{"TULOGO", 6, 196133},
	{"TULO", 4, 121493},
	{"TULM", 4, 239594},
	{"TULLY", 5, 71876},
	{"TULLOW", 6, 187363},
	{"TULLOCK", 7, 242041},
	{"TULLOCH", 7, 134926},
	{"TULLIUS", 7, 157924},
	{"TULLIS", 6, 192896},
	{"TULLIO", 6, 191275},
	{"TULLE", 5, 94307},
	{"TULLAMORE", 9, 162236},
	{"TULLAMARINE", 11, 166295},
	{"TULLAHOMA", 9, 134973},
	{"TULLA", 5, 250641},
	{"TULL", 4, 74754},
	{"TULKU", 5, 239787},
	{"TULKARM", 7, 259194},
	{"TULKAREM", 8, 251936},
	{"TULIPS", 6, 58764},
	{"TULIPA", 6, 194865},
	{"TULIP", 5, 45550},
	{"TULIO", 5, 261373},
	{"TULIA", 5, 174650},
	{"TULI", 4, 151122},
	{"TULELAKE", 8, 229206},
	{"TULEAR", 6, 221598},
	{"TULE", 4, 147474},
	{"TULBAGH", 7, 190757},
	{"TULAROSA", 8, 223370},
	{"TULARENSIS", 10, 211135},
	{"TULAREMIA", 9, 161756},
	{"TULARE", 6, 73962},
	{"TULANE", 6, 57466},
	{"TULALIP", 7, 198148},
	{"TULA", 4, 115788},
	{"TUKWILA", 7, 111303},
	{"TUKW", 4, 234898},
	{"TUKT", 4, 201408},
	{"TUKR", 4, 126611},
	{"TUKO", 4, 220372},
	{"TUKI", 4, 259939},
	{"TUKH", 4, 187463},
	{"TUKEY", 5, 146111},
	{"TUKA", 4, 120484},
	{"TUJUNGA", 7, 157310},
	{"TUJU", 4, 203979},
	{"TUITIONS", 8, 209995},
	{"TUITION", 7, 28837},
	{"TUINEN", 6, 198301},
	{"TUILERIES", 9, 176078},
	{"TUIL", 4, 205195},
	{"TUHL", 4, 236346},
	{"TUGWELL", 7, 256979},
	{"TUGS", 4, 98790},
	{"TUGRIK", 6, 92222},
	{"TUGO", 4, 128265},
	{"TUGL", 4, 132268},
	{"TUGJOBS", 7, 105898},
	{"TUGJOB", 6, 116132},
	{"TUGH", 4, 193320},
	{"TUGGLE", 6, 207466},
	{"TUGGING", 7, 112860},
	{"TUGGERANONG", 11, 164619},
	{"TUGGED", 6, 119670},
	{"TUGG", 4, 133131},
	{"TUGE", 4, 207206},
	{"TUGBOATS", 8, 214906},
	{"TUGBOAT", 7, 113432},
	{"TUGB", 4, 164464},
	{"TUGA", 4, 50265},
	{"TUFTS", 5, 55101},
	{"TUFTONBORO", 10, 215961},
	{"TUFTING", 7, 259458},
	{"TUFTED", 6, 84467},
	{"TUFTE", 5, 151447},
	{"TUFT", 4, 128955},
	{"TUFO", 4, 222348},
	{"TUFNELL", 7, 199518},
	{"TUFFY", 5, 143517},
	{"TUFFS", 5, 244981},
	{"TUFF", 4, 66888},
	{"TUFC", 4, 139209},
	{"TUFBOY", 6, 158680},
	{"TUFA", 4, 224563},
	{"TUEW", 4, 124986},
	{"TUESDAYS", 8, 50124},
	{"TUESDAY", 7, 1968},
	{"TUER", 4, 198994},
	{"TUEP", 4, 146520},
	{"TUEM", 4, 216456},
	{"TUEL", 4, 158140},
	{"TUEF", 4, 175370},
	{"TUED", 4, 211264},
	{"TUEC", 4, 199688},
	{"TUEBINGEN", 9, 192454},
	{"TUEB", 4, 188712},
	{"TUE", 3, 2128},
	{"TUDY", 4, 148783},
	{"TUDU", 4, 237067},
	{"TUDS", 4, 124189},
	{"TUDORS", 6, 186318},
	{"TUDOR", 5, 53506},
	{"TUDO", 4, 116659},
	{"TUDL", 4, 253546},
	{"TUDJMAN", 7, 222375},
	{"TUDIES", 6, 198322},
	{"TUDF", 4, 216656},
	{"TUDES", 5, 198205},
	{"TUDENTS", 7, 221864},
	{"TUDENT", 6, 173620},
	{"TUDE", 4, 125515},
	{"TUDD", 4, 96804},
	{"TUDB", 4, 225990},
	{"TUDALENNAU", 10, 236981},
	{"TUDALEN", 7, 129196},
	{"TUCU", 4, 209685},
	{"TUCT", 4, 258159},
	{"TUCSON", 6, 30786},
	{"TUCS", 4, 256083},
	{"TUCOWS", 6, 58329},
	{"TUCL", 4, 95626},
	{"TUCKWELL", 8, 240985},
	{"TUCKS", 5, 106247},
	{"TUCKING", 7, 139195},
	{"TUCKERTON", 9, 206378},
	{"TUCKERMAN", 9, 159000},
	{"TUCKER", 6, 38144},
	{"TUCKED", 6, 57329},
	{"TUCKAHOE", 8, 147175},
	{"TUCK", 4, 31846},
	{"TUCI", 4, 182757},
	{"TUCHMAN", 7, 162174},
	{"TUCH", 4, 251876},
	{"TUCF", 4, 212002},
	{"TUCE", 4, 96982},
	{"TUCD", 4, 236347},
	{"TUCCI", 5, 123008},
	{"TUCC", 4, 97602},
	{"TUCB", 4, 216050},
	{"TUCANO", 6, 129722},
	{"TUCAN", 5, 203001},
	{"TUCA", 4, 155231},
	{"TUBW", 4, 208118},
	{"TUBULIN", 7, 87978},
	{"TUBULES", 7, 109267},
	{"TUBULE", 6, 130795},
	{"TUBULARS", 8, 256137},
	{"TUBULAR", 7, 51700},
	{"TUBU", 4, 99773},
	{"TUBT", 4, 196456},
	{"TUBS", 4, 47723},
	{"TUBR", 4, 238495},
	{"TUBOS", 5, 223105},
	{"TUBO", 4, 124432},
	{"TUBMAN", 6, 120447},
	{"TUBM", 4, 213217},
	{"TUBL", 4, 251468},
	{"TUBINGEN", 8, 187251},
	{"TUBING", 6, 40812},
	{"TUBI", 4, 148768},
	{"TUBH", 4, 232097},
	{"TUBF", 4, 256343},
	{"TUBEY", 5, 153867},
	{"TUBES", 5, 31832},
	{"TUBERS", 6, 93644},
	{"TUBEROUS", 8, 139132},
	{"TUBEROSUM", 9, 199083},
	{"TUBEROSE", 8, 178591},
	{"TUBERCULOUS", 11, 147444},
	{"TUBERCULOSIS", 12, 41328},
	{"TUBERCULIN", 10, 130259},
	{"TUBERCLES", 9, 238578},
	{"TUBERCLE", 8, 165017},
	{"TUBERC", 6, 172642},
	{"TUBER", 5, 107818},
	{"TUBELESS", 8, 156279},
	{"TUBED", 5, 192264},
	{"TUBE", 4, 7894},
	{"TUBBY", 5, 102211},
	{"TUBBS", 5, 92050},
	{"TUBB", 4, 141546},
	{"TUBAS", 5, 163894},
	{"TUBAN", 5, 170055},
	{"TUBAL", 5, 76665},
	{"TUBAC", 5, 193976},
	{"TUBA", 4, 65046},
	{"TUB", 3, 29765},
	{"TUAW", 4, 99264},
	{"TUATHA", 6, 243499},
	{"TUATARA", 7, 235427},
	{"TUAT", 4, 5701},
	{"TUAREG", 6, 167931},
	{"TUAR", 4, 39540},
	{"TUAM", 4, 131179},
	{"TUALLY", 6, 181079},
	{"TUALATIN", 8, 89727},
	{"TUAL", 4, 128322},
	{"TUAG", 4, 237652},
	{"TUAF", 4, 232658},
	{"TUAB", 4, 233850},
	{"TU", 2, 245},
	{"TTYY", 4, 182066},
	{"TTYW", 4, 57649},
	{"TTYV", 4, 158516},
	{"TTYU", 4, 119032},
	{"TTYR", 4, 72751},
	{"TTYQ", 4, 115726},
	{"TTYP", 4, 39759},
	{"TTYM", 4, 44214},
	{"TTYL", 4, 111338},
	{"TTYK", 4, 154830},
	{"TTYJ", 4, 151470},
	{"TTYG", 4, 46552},
	{"TTYF", 4, 71067},
	{"TTYD", 4, 68068},
	{"TTYC", 4, 54290},
	{"TTYB", 4, 60858},
	{"TTWR", 4, 159020},
	{"TTVP", 4, 248167},
	{"TTVC", 4, 176562},
	{"TTUR", 4, 32280},
	{"TTUP", 4, 168624},
	{"TTUM", 4, 103490},
	{"TTUL", 4, 104361},
	{"TTUK", 4, 225549},
	{"TTUHSC", 6, 243718},
	{"TTUG", 4, 182637},
	{"TTUF", 4, 186505},
	{"TTUC", 4, 75644},
	{"TTUB", 4, 86186},
	{"TTRY", 4, 40486},
	{"TTRU", 4, 39010},
	{"TTRI", 4, 28566},
	{"TTREE", 5, 197082},
	{"TTRA", 4, 4731},
	{"TTQU", 4, 224874},
	{"TTPW", 4, 61919},
	{"TTPU", 4, 130341},
	{"TTPR", 4, 92647},
	{"TTPP", 4, 178634},
	{"TTPM", 4, 200186},
	{"TTPL", 4, 108622},
	{"TTPG", 4, 248818},
	{"TTPC", 4, 176892},
	{"TTPB", 4, 210486},
	{"TTOW", 4, 9161},
	{"TTOU", 4, 31516},
	{"TTOT", 4, 2976},
	{"TTORNEY", 7, 209641},
	{"TTOR", 4, 5464},
	{"TTOP", 4, 7105},
	{"TTOM", 4, 4883},
	{"TTOL", 4, 29255},
	{"TTOK", 4, 36216},
	{"TTOG", 4, 7935},
	{"TTOF", 4, 29600},
	{"TTOD", 4, 7224},
	{"TTOC", 4, 7687},
	{"TTOB", 4, 4767},
	{"TTMY", 4, 181235},
	{"TTMU", 4, 141685},
	{"TTMKFDIR", 8, 246196},
	{"TTMC", 4, 106444},
	{"TTLWHKR", 7, 247801},
	{"TTLU", 4, 217486},
	{"TTLB", 4, 124601},
	{"TTKU", 4, 229507},
	{"TTJU", 4, 170706},
	{"TTJR", 4, 193173},
	{"TTING", 5, 249094},
	{"TTIN", 4, 1906},
	{"TTIM", 4, 3433},
	{"TTHR", 4, 5187},
	{"TTHI", 4, 2097},
	{"TTHHEE", 6, 133005},
	{"TTHA", 4, 1568},
	{"TTGU", 4, 198069},
	{"TTGR", 4, 108240},
	{"TTGL", 4, 259654},
	{"TTFU", 4, 181959},
	{"TTFR", 4, 87534},
	{"TTFONTS", 7, 220070},
	{"TTFL", 4, 183607},
	{"TTFF", 4, 211352},
	{"TTEN", 4, 2279},
	{"TTEM", 4, 4755},
	{"TTEL", 4, 34906},
	{"TTDU", 4, 150969},
	{"TTDR", 4, 139361},
	{"TTDISPLAY", 9, 193984},
	{"TTCU", 4, 128749},
	{"TTCR", 4, 139157},
	{"TTCP", 4, 221780},
	{"TTCL", 4, 119679},
	{"TTBY", 4, 183240},
	{"TTBU", 4, 90759},
	{"TTBR", 4, 79590},
	{"TTBL", 4, 152462},
	{"TTBB", 4, 228876},
	{"TTAVEL", 6, 257849},
	{"TTASETITEMOFF", 13, 181052},
	{"TTANEXTSIBLING", 14, 211560},
	{"TTANEWELEMENT", 13, 229043},
	{"TTANEWATTRIBUTE", 15, 262014},
	{"TTAL", 4, 29750},
	{"TTAK", 4, 8201},
	{"TTAINSERTSIBLING", 16, 213660},
	{"TTAINSERTFIRSTCHILD", 19, 223145},
	{"TTAGETSSCHEMANAME", 17, 238551},
	{"TTAGETPARENT", 12, 221581},
	{"TTAGETMESSAGE", 13, 128632},
	{"TTAGETMEMORY", 12, 151588},
	{"TTAGETFIRSTCHILD", 16, 214303},
	{"TTAGETELEMENTTYPE", 17, 137157},
	{"TTAGETATTRIBUTE", 15, 199117},
	{"TTAFREEMEMORY", 13, 128621},
	{"TTAERROR", 8, 175204},
	{"TTAATTACHATTRIBUTE", 18, 261546},
	{"TSZYU", 5, 236003},
	{"TSYW", 4, 208300},
	{"TSYU", 4, 138055},
	{"TSYR", 4, 89809},
	{"TSYP", 4, 197581},
	{"TSYM", 4, 63787},
	{"TSYL", 4, 100461},
	{"TSYF", 4, 255991},
	{"TSYD", 4, 106932},
	{"TSYC", 4, 147874},
	{"TSYB", 4, 186125},
	{"TSXC", 4, 225080},
	{"TSXB", 4, 225797},
	{"TSWW", 4, 231834},
	{"TSWU", 4, 194087},
	{"TSWR", 4, 55763},
	{"TSWO", 4, 30229},
	{"TSWI", 4, 4904},
	{"TSWH", 4, 4329},
	{"TSWE", 4, 5479},
	{"TSWANA", 6, 199591},
	{"TSWA", 4, 30163},
	{"TSVU", 4, 253179},
	{"TSVANGIRAI", 10, 179020},
	{"TSUZUKI", 7, 256503},
	{"TSUZ", 4, 92348},
	{"TSUYOSHI", 8, 166091},
	{"TSUY", 4, 113421},
	{"TSUW", 4, 128624},
	{"TSUV", 4, 171394},
	{"TSUU", 4, 208705},
	{"TSUTSUMI", 8, 239698},
	{"TSUTSUI", 7, 218311},
	{"TSUTOMU", 7, 176100},
	{"TSUSHIMA", 8, 227526},
	{"TSUS", 4, 33378},
	{"TSURUMI", 7, 238625},
	{"TSUP", 4, 9780},
	{"TSUNG", 5, 147518},
	{"TSUNEO", 6, 255128},
	{"TSUNAMIS", 8, 87349},
	{"TSUNAMI", 7, 34241},
	{"TSUMURA", 7, 219677},
	{"TSUM", 4, 39221},
	{"TSUL", 4, 77696},
	{"TSUKUBA", 7, 91254},
	{"TSUKINEKO", 9, 243546},
	{"TSUKIHIME", 9, 207253},
	{"TSUKI", 5, 172934},
	{"TSUKASA", 7, 184379},
	{"TSUKAMOTO", 9, 195898},
	{"TSUK", 4, 63745},
	{"TSUJI", 5, 152720},
	{"TSUJ", 4, 159963},
	{"TSUGA", 5, 211325},
	{"TSUG", 4, 50787},
	{"TSUF", 4, 52422},
	{"TSUEN", 5, 137745},
	{"TSUDA", 5, 188229},
	{"TSUD", 4, 74378},
	{"TSUCHIYA", 8, 157417},
	{"TSUC", 4, 29297},
	{"TSUBO", 5, 154927},
	{"TSUBASA", 7, 120955},
	{"TSUBAKI", 7, 247797},
	{"TSUBA", 5, 245018},
	{"TSUB", 4, 37792},
	{"TSTU", 4, 31344},
	{"TSTRING", 7, 177707},
	{"TSTR", 4, 6294},
	{"TSTO", 4, 1911},
	{"TSTMS", 5, 151425},
	{"TSTH", 4, 1897},
	{"TSTCLNT", 7, 258624},
	{"TSSU", 4, 28227},
	{"TSSOP", 5, 116489},
	{"TSRY", 4, 201229},
	{"TSRU", 4, 51557},
	{"TSRE", 4, 6269},
	{"TSRD", 4, 162215},
	{"TSRB", 4, 190776},
	{"TSQU", 4, 41321},
	{"TSQL", 4, 249899},
	{"TSQB", 4, 253180},
	{"TSPY", 4, 141007},
	{"TSPU", 4, 43366},
	{"TSPP", 4, 189681},
	{"TSPO", 4, 9000},
	{"TSPM", 4, 110397},
	{"TSPL", 4, 38172},
	{"TSPE", 4, 6452},
	{"TSPD", 4, 236735},
	{"TSPC", 4, 242288},
	{"TSOW", 4, 29854},
	{"TSORIES", 7, 229278},
	{"TSOR", 4, 9731},
	{"TSONGAS", 7, 247949},
	{"TSONGA", 6, 123868},
	{"TSON", 4, 4184},
	{"TSOM", 4, 4645},
	{"TSOF", 4, 1886},
	{"TSMY", 4, 59128},
	{"TSMU", 4, 42727},
	{"TSMR", 4, 114961},
	{"TSMP", 4, 161612},
	{"TSMO", 4, 9949},
	{"TSMM", 4, 223536},
	{"TSMF", 4, 183319},
	{"TSME", 4, 33955},
	{"TSMD", 4, 116664},
	{"TSMC", 4, 138452},
	{"TSMB", 4, 243323},
	{"TSMA", 4, 7068},
	{"TSLY", 4, 137682},
	{"TSLU", 4, 72087},
	{"TSLO", 4, 32768},
	{"TSLL", 4, 185745},
	{"TSLI", 4, 9902},
	{"TSLE", 4, 33327},
	{"TSLD", 4, 206631},
	{"TSKY", 4, 59479},
	{"TSKU", 4, 141216},
	{"TSKR", 4, 161364},
	{"TSKM", 4, 138579},
	{"TSKL", 4, 258542},
	{"TSKB", 4, 180061},
	{"TSJU", 4, 34202},
	{"TSJR", 4, 248168},
	{"TSITSIKAMMA", 11, 194407},
	{"TSINGHUA", 8, 122230},
	{"TSING", 5, 136832},
	{"TSIMSHATSUI", 11, 257737},
	{"TSILIVI", 7, 196902},
	{"TSHWANE", 7, 197800},
	{"TSHO", 4, 3730},
	{"TSHIRTS", 7, 56889},
	{"TSHIRT", 6, 59268},
	{"TSHIPLEY", 8, 185785},
	{"TSHE", 4, 3211},
	{"TSHA", 4, 4351},
	{"TSGY", 4, 232659},
	{"TSGU", 4, 69548},
	{"TSGR", 4, 38429},
	{"TSGO", 4, 29634},
	{"TSGM", 4, 208924},
	{"TSGL", 4, 189123},
	{"TSGD", 4, 221698},
	{"TSFU", 4, 44631},
	{"TSFR", 4, 7343},
	{"TSFO", 4, 4536},
	{"TSFL", 4, 53014},
	{"TSFI", 4, 10054},
	{"TSFA", 4, 35870},
	{"TSEV", 4, 29021},
	{"TSETSE", 6, 151510},
	{"TSERING", 7, 213489},
	{"TSENG", 5, 104611},
	{"TSEL", 4, 5698},
	{"TSEAVER", 7, 122990},
	{"TSDY", 4, 162388},
	{"TSDW", 4, 189557},
	{"TSDV", 4, 234297},
	{"TSDU", 4, 43954},
	{"TSDR", 4, 50065},
	{"TSDO", 4, 34733},
	{"TSDI", 4, 33787},
	{"TSDE", 4, 28883},
	{"TSDC", 4, 208301},
	{"TSCY", 4, 156172},
	{"TSCU", 4, 41613},
	{"TSCR", 4, 36516},
	{"TSCP", 4, 232098},
	{"TSCO", 4, 4522},
	{"TSCM", 4, 205603},
	{"TSCL", 4, 39404},
	{"TSCHECHISCHE", 12, 171383},
	{"TSCHECHIEN", 10, 87079},
	{"TSCD", 4, 183608},
	{"TSCB", 4, 211077},
	{"TSCALARTYPE", 11, 170568},
	{"TSBY", 4, 37405},
	{"TSBU", 4, 8907},
	{"TSBR", 4, 44561},
	{"TSBL", 4, 58335},
	{"TSBE", 4, 6362},
	{"TSBC", 4, 219298},
	{"TSBB", 4, 228470},
	{"TSAWWASSEN", 10, 147285},
	{"TSAVORITE", 9, 164512},
	{"TSAVO", 5, 162237},
	{"TSARS", 5, 222215},
	{"TSARIST", 7, 175667},
	{"TSAREVO", 7, 259915},
	{"TSANG", 5, 91264},
	{"TSAL", 4, 5891},
	{"TSAG", 4, 33431},
	{"TSAF", 4, 35694},
	{"TSAB", 4, 28884},
	{"TRZVEL", 6, 260006},
	{"TRZE", 4, 180773},
	{"TRYY", 4, 104009},
	{"TRYW", 4, 34238},
	{"TRYV", 4, 93353},
	{"TRYU", 4, 75497},
	{"TRYT", 4, 6788},
	{"TRYST", 5, 115861},
	{"TRYS", 4, 145255},
	{"TRYR", 4, 47978},
	{"TRYQ", 4, 235492},
	{"TRYPTOPHAN", 10, 74906},
	{"TRYPTIC", 7, 175340},
	{"TRYPSIN", 7, 81899},
	{"TRYPANOSOMIASIS", 15, 157475},
	{"TRYPANOSOMES", 12, 235947},
	{"TRYPANOSOMA", 11, 101402},
	{"TRYPAN", 6, 245942},
	{"TRYP", 4, 94557},
	{"TRYOUTS", 7, 81250},
	{"TRYOUT", 6, 87777},
	{"TRYON", 5, 93905},
	{"TRYNA", 5, 192521},
	{"TRYN", 4, 58212},
	{"TRYMEDIA", 8, 155843},
	{"TRYL", 4, 52889},
	{"TRYJ", 4, 107373},
	{"TRYING", 6, 2322},
	{"TRYIN", 5, 60827},
	{"TRYI", 4, 4391},
	{"TRYH", 4, 41708},
	{"TRYGVE", 6, 199879},
	{"TRYG", 4, 62994},
	{"TRYF", 4, 41887},
	{"TRYED", 5, 113345},
	{"TRYD", 4, 46993},
	{"TRYC", 4, 39823},
	{"TRYB", 4, 41866},
	{"TRYAVNA", 7, 198126},
	{"TRYALL", 6, 242387},
	{"TRYA", 4, 8453},
	{"TRY", 3, 914},
	{"TRWY", 4, 136978},
	{"TRWVEL", 6, 261323},
	{"TRWA", 4, 186126},
	{"TRVEL", 5, 241994},
	{"TRVAEL", 6, 255162},
	{"TRUZZI", 6, 150591},
	{"TRUZ", 4, 247556},
	{"TRUYEN", 6, 138404},
	{"TRUY", 4, 140689},
	{"TRUXTON", 7, 235948},
	{"TRUXEDO", 7, 219614},
	{"TRUX", 4, 189534},
	{"TRUVATIV", 8, 122610},
	{"TRUV", 4, 178755},
	{"TRUTHVALUE", 10, 205134},
	{"TRUTHS", 6, 44918},
	{"TRUTHOUT", 8, 110498},
	{"TRUTHINESS", 10, 166445},
	{"TRUTHFULNESS", 12, 95093},
	{"TRUTHFULLY", 10, 78651},
	{"TRUTHFUL", 8, 64452},
	{"TRUTH", 5, 2678},
	{"TRUSURROUND", 11, 244408},
	{"TRUSTY", 6, 79849},
	{"TRUSTWORTHY", 11, 57048},
	{"TRUSTWORTHINESS", 15, 97177},
	{"TRUSTUK", 7, 208258},
	{"TRUSTUDIO", 9, 256722},
	{"TRUSTSEAL", 9, 218610},
	{"TRUSTS", 6, 33895},
	{"TRUSTPASS", 9, 41153},
	{"TRUSTOR", 7, 226200},
	{"TRUSTNET", 8, 144044},
	{"TRUSTMARK", 9, 219191},
	{"TRUSTKILL", 9, 165689},
	{"TRUSTIX", 7, 112995},
	{"TRUSTIVE", 8, 230081},
	{"TRUSTING", 8, 58019},
	{"TRUSTFUL", 8, 214587},
	{"TRUSTEESHIP", 11, 129358},
	{"TRUSTEES", 8, 31812},
	{"TRUSTEE", 7, 34191},
	{"TRUSTEDBSD", 10, 155949},
	{"TRUSTED", 7, 7852},
	{"TRUSTE", 6, 47375},
	{"TRUSTABLE", 9, 260360},
	{"TRUST", 5, 5729},
	{"TRUSSVILLE", 10, 147804},
	{"TRUSSING", 8, 248565},
	{"TRUSSES", 7, 98201},
	{"TRUSSELL", 8, 202515},
	{"TRUSSED", 7, 259779},
	{"TRUSSARDI", 9, 99367},
	{"TRUSS", 5, 53590},
	{"TRUSHKIN", 8, 121908},
	{"TRUSECURE", 9, 194856},
	{"TRUSCOTT", 8, 165953},
	{"TRUS", 4, 152447},
	{"TRURO", 5, 63978},
	{"TRURLIB", 7, 239522},
	{"TRUR", 4, 99868},
	{"TRUP", 4, 104736},
	{"TRUONG", 6, 112919},
	{"TRUO", 4, 199027},
	{"TRUNNION", 8, 230042},
	{"TRUNKS", 6, 52273},
	{"TRUNKLINE", 9, 198630},
	{"TRUNKING", 8, 93320},
	{"TRUNKED", 7, 136685},
	{"TRUNK", 5, 29661},
	{"TRUNGPA", 7, 220084},
	{"TRUNG", 5, 58820},
	{"TRUNDLE", 7, 99425},
	{"TRUNCUS", 7, 241001},
	{"TRUNCATUS", 9, 242427},
	{"TRUNCATULA", 10, 225033},
	{"TRUNCATION", 10, 79098},
	{"TRUNCATING", 10, 152604},
	{"TRUNCATES", 9, 200523},
	{"TRUNCATED", 9, 52689},
	{"TRUNCATE", 8, 86229},
	{"TRUNC", 5, 149370},
	{"TRUN", 4, 245295},
	{"TRUMPS", 6, 75999},
	{"TRUMPINGTON", 11, 235992},
	{"TRUMPF", 6, 246777},
	{"TRUMPETS", 8, 72107},
	{"TRUMPETING", 10, 167792},
	{"TRUMPETERS", 10, 218374},
	{"TRUMPETER", 9, 85258},
	{"TRUMPETED", 9, 160917},
	{"TRUMPET", 7, 40467},
	{"TRUMPER", 7, 197017},
	{"TRUMPED", 7, 107624},
	{"TRUMP", 5, 43062},
	{"TRUMBULL", 8, 76045},
	{"TRUMBO", 6, 200418},
	{"TRUMBLE", 7, 244914},
	{"TRUMANSBURG", 11, 210357},
	{"TRUMANN", 7, 241281},
	{"TRUMAN", 6, 47117},
	{"TRUM", 4, 165899},
	{"TRULY", 5, 5446},
	{"TRULLY", 6, 210572},
	{"TRULLI", 6, 146681},
	{"TRULL", 5, 258001},
	{"TRULIA", 6, 90809},
	{"TRUL", 4, 31481},
	{"TRUK", 4, 126955},
	{"TRUJILLO", 8, 82972},
	{"TRUJ", 4, 133861},
	{"TRUITT", 6, 146059},
	{"TRUISMS", 7, 212719},
	{"TRUISM", 6, 144679},
	{"TRUING", 6, 231980},
	{"TRUI", 4, 76417},
	{"TRUGREEN", 8, 190529},
	{"TRUFFLES", 8, 68952},
	{"TRUFFLE", 7, 78298},
	{"TRUFFAUT", 8, 142327},
	{"TRUF", 4, 95481},
	{"TRUEX", 5, 143687},
	{"TRUETYPE", 8, 62412},
	{"TRUETT", 6, 179591},
	{"TRUETONES", 9, 72872},
	{"TRUETONE", 8, 106321},
	{"TRUETIP", 7, 123717},
	{"TRUEST", 6, 110422},
	{"TRUESPACE", 9, 158344},
	{"TRUESDELL", 9, 242875},
	{"TRUESDALE", 9, 211303},
	{"TRUER", 5, 105916},
	{"TRUEPOWER", 9, 198458},
	{"TRUEMAN", 7, 154530},
	{"TRUELY", 6, 72776},
	{"TRUELOVE", 8, 197149},
	{"TRUELIFE", 8, 223808},
	{"TRUECOLOR", 9, 178476},
	{"TRUEBLOOD", 9, 220348},
	{"TRUEAIR", 7, 262062},
	{"TRUE", 4, 1695},
	{"TRUDY", 5, 83454},
	{"TRUDIE", 6, 242541},
	{"TRUDI", 5, 151324},
	{"TRUDGING", 8, 164216},
	{"TRUDGED", 7, 160533},
	{"TRUDGE", 6, 169784},
	{"TRUDEN", 6, 219453},
	{"TRUDELL", 7, 232167},
	{"TRUDEL", 6, 222474},
	{"TRUDEAU", 7, 80979},
	{"TRUCTURE", 8, 226144},
	{"TRUCS", 5, 182108},
	{"TRUCOS", 6, 79459},
	{"TRUCKSTOP", 9, 192769},
	{"TRUCKS", 6, 8206},
	{"TRUCKLOADS", 10, 148812},
	{"TRUCKLOAD", 9, 98596},
	{"TRUCKING", 8, 41175},
	{"TRUCKIN", 7, 123814},
	{"TRUCKERS", 8, 62857},
	{"TRUCKER", 7, 62435},
	{"TRUCKEE", 7, 79069},
	{"TRUCKED", 7, 167754},
	{"TRUCK", 5, 3680},
	{"TRUCE", 5, 64253},
	{"TRUCCO", 6, 207417},
	{"TRUCCHI", 7, 128381},
	{"TRUC", 4, 133404},
	{"TRUBY", 5, 247785},
	{"TRUBRITE", 8, 197162},
	{"TRUB", 4, 81237},
	{"TRUAX", 5, 162841},
	{"TRUANTS", 7, 251410},
	{"TRUANT", 6, 133925},
	{"TRUANCY", 7, 93994},
	{"TRUA", 4, 90219},
	{"TRSVEL", 6, 252096},
	{"TRSQ", 4, 37851},
	{"TRSP", 4, 212003},
	{"TRSMADOL", 8, 228279},
	{"TRSL", 4, 239335},
	{"TRSC", 4, 128472},
	{"TRRE", 4, 247876},
	{"TRQVEL", 6, 260322},
	{"TRPT", 4, 209803},
	{"TRPM", 4, 99131},
	{"TRPG", 4, 247557},
	{"TRPA", 4, 248903},
	{"TROZ", 4, 170350},
	{"TROYS", 5, 244358},
	{"TROYES", 6, 137107},
	{"TROYER", 6, 149950},
	{"TROYAN", 6, 166350},
	{"TROYA", 5, 187382},
	{"TROY", 4, 31192},
	{"TROXLER", 7, 228533},
	{"TROXELL", 7, 221867},
	{"TROXEL", 6, 176067},
	{"TROWER", 6, 187772},
	{"TROWELS", 7, 159553},
	{"TROWEL", 6, 98709},
	{"TROWD", 5, 152146},
	{"TROWBRIDGE", 10, 84407},
	{"TROWA", 5, 230137},
	{"TROW", 4, 153184},
	{"TROVE", 5, 70529},
	{"TROVATORE", 9, 199940},
	{"TROVATO", 7, 181266},
	{"TROVARE", 7, 188267},
	{"TROVA", 5, 126889},
	{"TROV", 4, 30969},
	{"TROUVILLE", 9, 243768},
	{"TROUVEZ", 7, 210940},
	{"TROUVEREZ", 9, 229868},
	{"TROUVER", 7, 123280},
	{"TROUVE", 6, 132956},
	{"TROUTVILLE", 10, 209732},
	{"TROUTMAN", 8, 123801},
	{"TROUTDALE", 9, 117897},
	{"TROUT", 5, 35952},
	{"TROUSSEAU", 9, 236635},
	{"TROUSERSUITS", 12, 225123},
	{"TROUSERS", 8, 39277},
	{"TROUSER", 7, 69064},
	{"TROUSDALE", 9, 160574},
	{"TROUPES", 7, 152132},
	{"TROUPER", 7, 225907},
	{"TROUPE", 6, 67737},
	{"TROUP", 5, 90662},
	{"TROUNCING", 9, 242572},
	{"TROUNCED", 8, 179830},
	{"TROUNCE", 7, 213999},
	{"TROUGHTON", 9, 190188},
	{"TROUGHS", 7, 98022},
	{"TROUGH", 6, 54780},
	{"TROUBLING", 9, 61046},
	{"TROUBLESOME", 11, 62599},
	{"TROUBLESHOOTING", 15, 33374},
	{"TROUBLESHOOTERS", 15, 193264},
	{"TROUBLESHOOTER", 14, 104797},
	{"TROUBLESHOOT", 12, 63527},
	{"TROUBLES", 8, 42498},
	{"TROUBLEMAN", 10, 235673},
	{"TROUBLEMAKERS", 13, 139653},
	{"TROUBLEMAKER", 12, 133419},
	{"TROUBLED", 8, 35888},
	{"TROUBLE", 7, 2984},
	{"TROUBADOURS", 11, 182435},
	{"TROUBADOUR", 10, 110414},
	{"TROUBADOR", 9, 215383},
	{"TROU", 4, 136273},
	{"TROTZDEM", 8, 209139},
	{"TROTZ", 5, 155666},
	{"TROTWOOD", 8, 165499},
	{"TROTTING", 8, 102829},
	{"TROTTIER", 8, 173715},
	{"TROTTERS", 8, 107153},
	{"TROTTER", 7, 75855},
	{"TROTTED", 7, 125502},
	{"TROTTA", 6, 207499},
	{"TROTT", 5, 110916},
	{"TROTSKYISTS", 11, 240808},
	{"TROTSKYIST", 10, 200129},
	{"TROTSKYISM", 10, 212162},
	{"TROTSKY", 7, 95296},
	{"TROTS", 5, 157633},
	{"TROTMAN", 7, 191172},
	{"TROTH", 5, 175686},
	{"TROST", 5, 148094},
	{"TROSSACHS", 9, 180863},
	{"TROR", 4, 251293},
	{"TROPSCH", 7, 249078},
	{"TROPPO", 6, 126065},
	{"TROPOSPHERIC", 12, 103108},
	{"TROPOSPHERE", 11, 102274},
	{"TROPOS", 6, 200531},
	{"TROPOPAUSE", 10, 157337},
	{"TROPONIN", 8, 123335},
	{"TROPOMYOSIN", 11, 194457},
	{"TROPO", 5, 195377},
	{"TROPIX", 6, 241483},
	{"TROPISM", 7, 192013},
	{"TROPICS", 7, 61550},
	{"TROPICO", 7, 149774},
	{"TROPICANA", 9, 66771},
	{"TROPICALS", 9, 140446},
	{"TROPICALIS", 10, 162846},
	{"TROPICALIA", 10, 248082},
	{"TROPICALE", 9, 199481},
	{"TROPICAL", 8, 32527},
	{"TROPICA", 7, 207886},
	{"TROPIC", 6, 73798},
	{"TROPI", 5, 225245},
	{"TROPHY", 6, 37282},
	{"TROPHOBLASTIC", 13, 184779},
	{"TROPHOBLAST", 11, 183267},
	{"TROPHIES", 8, 52448},
	{"TROPHIC", 7, 89769},
	{"TROPEZ", 6, 70429},
	{"TROPES", 6, 149965},
	{"TROPEA", 6, 215115},
	{"TROPE", 5, 152127},
	{"TROP", 4, 75885},
	{"TROOST", 6, 210190},
	{"TROOPS", 6, 8177},
	{"TROOPERS", 8, 59649},
	{"TROOPER", 7, 54554},
	{"TROOP", 5, 3257},
	{"TROON", 5, 106824},
	{"TROODOS", 7, 257180},
	{"TROO", 4, 7733},
	{"TRONS", 5, 258103},
	{"TRONIX", 6, 188474},
	{"TRONICS", 7, 126699},
	{"TRONIC", 6, 87347},
	{"TRONG", 5, 43015},
	{"TRONDHEIM", 9, 79891},
	{"TROND", 5, 102334},
	{"TRONCO", 6, 231010},
	{"TRONA", 5, 184679},
	{"TROMSO", 6, 144957},
	{"TROMS", 5, 236140},
	{"TROMPETTE", 9, 238173},
	{"TROMPE", 6, 133535},
	{"TROMP", 5, 191184},
	{"TROMEY", 6, 106894},
	{"TROMELIN", 8, 110861},
	{"TROMBONIST", 10, 154955},
	{"TROMBONES", 9, 113823},
	{"TROMBONE", 8, 53841},
	{"TROMBLEY", 8, 243599},
	{"TROMA", 5, 136052},
	{"TROM", 4, 189122},
	{"TROLS", 5, 209564},
	{"TROLLY", 6, 213691},
	{"TROLLTECH", 9, 123713},
	{"TROLLS", 6, 64153},
	{"TROLLOPE", 8, 117931},
	{"TROLLING", 8, 65942},
	{"TROLLIES", 8, 255186},
	{"TROLLEYS", 8, 72793},
	{"TROLLEYBUS", 10, 222227},
	{"TROLLEY", 7, 41825},
	{"TROLLER", 7, 185584},
	{"TROLLED", 7, 135058},
	{"TROLL", 5, 47764},
	{"TROL", 4, 89194},
	{"TROK", 4, 39620},
	{"TROJANS", 7, 49017},
	{"TROJANHUNTER", 12, 191017},
	{"TROJAN", 6, 37354},
	{"TROJ", 4, 96814},
	{"TROIS", 5, 63820},
	{"TROILUS", 7, 149049},
	{"TROIKA", 6, 106984},
	{"TROIE", 5, 157565},
	{"TROIA", 5, 169702},
	{"TROGON", 6, 118024},
	{"TROGLODYTES", 11, 117632},
	{"TROGLODYTE", 10, 227817},
	{"TROGLITAZONE", 12, 235747},
	{"TROGIR", 6, 211568},
	{"TROGGS", 6, 220920},
	{"TROGDOR", 7, 255554},
	{"TROG", 4, 205827},
	{"TROFF", 5, 125931},
	{"TROFEO", 6, 218980},
	{"TROF", 4, 178241},
	{"TROELS", 6, 231524},
	{"TRODE", 5, 225284},
	{"TRODDEN", 7, 113525},
	{"TROD", 4, 123092},
	{"TROCHE", 6, 245897},
	{"TROCAR", 6, 233722},
	{"TROCADERO", 9, 116512},
	{"TROBE", 5, 95243},
	{"TROB", 4, 43032},
	{"TROAN", 5, 157202},
	{"TRNG", 4, 132343},
	{"TRND", 4, 233510},
	{"TRNC", 4, 152092},
	{"TRNAS", 5, 171208},
	{"TRMO", 4, 242170},
	{"TRMM", 4, 160837},
	{"TRMI", 4, 210105},
	{"TRME", 4, 254230},
	{"TRMADOL", 7, 212689},
	{"TRMA", 4, 190927},
	{"TRLOG", 5, 157986},
	{"TRLEFT", 6, 158631},
	{"TRLE", 4, 260858},
	{"TRLA", 4, 251469},
	{"TRKS", 4, 259240},
	{"TRKATTRIBS", 10, 256218},
	{"TRKA", 4, 248923},
	{"TRIZ", 4, 153771},
	{"TRIY", 4, 117207},
	{"TRIXIE", 6, 73981},
	{"TRIX", 4, 94245},
	{"TRIW", 4, 149913},
	{"TRIVVIES", 8, 234370},
	{"TRIVIUM", 7, 43527},
	{"TRIVIALLY", 9, 108455},
	{"TRIVIALIZED", 11, 242431},
	{"TRIVIALIZE", 10, 217783},
	{"TRIVIALITY", 10, 205719},
	{"TRIVIALITIES", 12, 247735},
	{"TRIVIAL", 7, 40534},
	{"TRIVIA", 6, 30939},
	{"TRIVETS", 7, 163791},
	{"TRIVET", 6, 138742},
	{"TRIVEDI", 7, 154617},
	{"TRIVANDRUM", 10, 79793},
	{"TRIVALENT", 9, 157487},
	{"TRIVAGO", 7, 168711},
	{"TRIUNFO", 7, 176015},
	{"TRIUNE", 6, 146590},
	{"TRIUMVIRATE", 11, 137343},
	{"TRIUMPHS", 8, 71855},
	{"TRIUMPHING", 10, 231744},
	{"TRIUMPHED", 9, 117266},
	{"TRIUMPHANTLY", 12, 123937},
	{"TRIUMPHANT", 10, 69114},
	{"TRIUMPHALISM", 12, 258424},
	{"TRIUMPHAL", 9, 130377},
	{"TRIUMPH", 7, 35021},
	{"TRIUMF", 6, 141351},
	{"TRIUM", 5, 70234},
	{"TRIU", 4, 45539},
	{"TRITTON", 7, 168674},
	{"TRITT", 5, 112222},
	{"TRITONS", 7, 228320},
	{"TRITONE", 7, 209771},
	{"TRITON", 6, 58246},
	{"TRITIUM", 7, 76126},
	{"TRITICALE", 9, 148830},
	{"TRITIATED", 9, 242403},
	{"TRITECH", 7, 166956},
	{"TRITE", 5, 100703},
	{"TRISTRAM", 8, 90484},
	{"TRISTEZA", 8, 211595},
	{"TRISTESSE", 9, 247736},
	{"TRISTE", 6, 138998},
	{"TRISTATE", 8, 76256},
	{"TRISTAR", 7, 73593},
	{"TRISTANO", 8, 200827},
	{"TRISTANIA", 9, 166761},
	{"TRISTAN", 7, 49731},
	{"TRISTA", 6, 125783},
	{"TRIST", 5, 251691},
	{"TRISPHOSPHATE", 13, 163349},
	{"TRISOMY", 7, 121097},
	{"TRISOL", 6, 187853},
	{"TRISODIUM", 9, 259473},
	{"TRISKELE", 8, 195241},
	{"TRISHA", 6, 70233},
	{"TRISH", 5, 52094},
	{"TRISA", 5, 252716},
	{"TRIR", 4, 151834},
	{"TRIQUINT", 8, 197053},
	{"TRIPWIRE", 8, 88574},
	{"TRIPURA", 7, 101527},
	{"TRIPUG", 6, 230727},
	{"TRIPTYCH", 8, 117261},
	{"TRIPSO", 6, 187948},
	{"TRIPS", 5, 6778},
	{"TRIPREWARDS", 11, 236803},
	{"TRIPPY", 6, 115783},
	{"TRIPPLITE", 9, 125940},
	{"TRIPPLE", 7, 98252},
	{"TRIPPLANNER", 11, 233822},
	{"TRIPPING", 8, 62293},
	{"TRIPPIN", 7, 102288},
	{"TRIPPI", 6, 151158},
	{"TRIPPERS", 8, 187699},
	{"TRIPPER", 7, 121184},
	{"TRIPPED", 7, 83351},
	{"TRIPPE", 6, 258461},
	{"TRIPP", 5, 52733},
	{"TRIPOS", 6, 183271},
	{"TRIPOLI", 7, 78545},
	{"TRIPODS", 7, 55711},
	{"TRIPOD", 6, 40079},
	{"TRIPLY", 6, 205723},
	{"TRIPLOID", 8, 209542},
	{"TRIPLO", 6, 237945},
	{"TRIPLING", 8, 148302},
	{"TRIPLICATE", 10, 116392},
	{"TRIPLEXES", 9, 190433},
	{"TRIPLEX", 7, 96906},
	{"TRIPLETT", 8, 114159},
	{"TRIPLETS", 8, 77737},
	{"TRIPLET", 7, 74273},
	{"TRIPLES", 7, 63422},
	{"TRIPLER", 7, 218959},
	{"TRIPLED", 7, 80352},
	{"TRIPLECALC", 10, 96330},
	{"TRIPLE", 6, 8986},
	{"TRIPHOSPHATE", 12, 81959},
	{"TRIPHOSPHATASE", 14, 246898},
	{"TRIPHASIL", 9, 95333},
	{"TRIPEL", 6, 257260},
	{"TRIPEAKS", 8, 249203},
	{"TRIPE", 5, 113587},
	{"TRIPATHI", 8, 157226},
	{"TRIPARTITE", 10, 87188},
	{"TRIPADVISOR", 11, 3981},
	{"TRIPACK", 7, 252977},
	{"TRIP", 4, 2932},
	{"TRIOXIDE", 8, 149964},
	{"TRIOS", 5, 88901},
	{"TRION", 5, 174817},
	{"TRIOMPHE", 8, 103744},
	{"TRIODOS", 7, 251059},
	{"TRIODE", 6, 156604},
	{"TRIO", 4, 32149},
	{"TRINUCLEOTIDE", 13, 247932},
	{"TRINTECH", 8, 222147},
	{"TRINTEC", 7, 166326},
	{"TRINNY", 6, 252380},
	{"TRINKIE", 7, 200053},
	{"TRINKETS", 8, 98760},
	{"TRINKET", 7, 80769},
	{"TRINKA", 6, 177984},
	{"TRINITY", 7, 31137},
	{"TRINITRON", 9, 105269},
	{"TRINITARIAN", 11, 142786},
	{"TRINIDADIAN", 11, 204801},
	{"TRINIDAD", 8, 31057},
	{"TRINI", 5, 137559},
	{"TRINH", 5, 133408},
	{"TRINGA", 6, 176822},
	{"TRING", 5, 110715},
	{"TRINET", 6, 232862},
	{"TRINE", 5, 99178},
	{"TRINDER", 7, 254564},
	{"TRINCOMALEE", 11, 159539},
	{"TRINA", 5, 47359},
	{"TRIMSPA", 7, 99213},
	{"TRIMSIZE", 8, 192598},
	{"TRIMS", 5, 60293},
	{"TRIMOX", 6, 254834},
	{"TRIMMERS", 8, 69291},
	{"TRIMMER", 7, 53486},
	{"TRIMMED", 7, 48593},
	{"TRIMM", 5, 236940},
	{"TRIMLINE", 8, 160123},
	{"TRIMIX", 6, 224364},
	{"TRIMITE", 7, 255273},
	{"TRIMETHYL", 9, 165613},
	{"TRIMETHOPRIM", 12, 118636},
	{"TRIMET", 6, 248928},
	{"TRIMESTRE", 9, 237464},
	{"TRIMESTERS", 10, 184261},
	{"TRIMESTER", 9, 57564},
	{"TRIMER", 6, 204624},
	{"TRIMEDICA", 9, 152196},
	{"TRIMBLE", 7, 63419},
	{"TRIMARK", 7, 118173},
	{"TRIMARAN", 8, 213910},
	{"TRIM", 4, 35582},
	{"TRILUG", 6, 128021},
	{"TRILOGY", 7, 39479},
	{"TRILOGIES", 9, 233156},
	{"TRILOBITES", 10, 170382},
	{"TRILOBITE", 9, 174738},
	{"TRILLS", 6, 213089},
	{"TRILLIUM", 8, 87960},
	{"TRILLIONS", 9, 114011},
	{"TRILLION", 8, 47830},
	{"TRILLING", 8, 176361},
	{"TRILLIN", 7, 226461},
	{"TRILLIAN", 8, 82302},
	{"TRILL", 5, 124707},
	{"TRILINOS", 8, 199808},
	{"TRILINGUAL", 10, 172038},
	{"TRILINEAR", 9, 210475},
	{"TRILEPTAL", 9, 186807},
	{"TRILBY", 6, 189596},
	{"TRILATERAL", 10, 115580},
	{"TRIL", 4, 252902},
	{"TRIKKE", 6, 249179},
	{"TRIKES", 6, 78229},
	{"TRIKE", 5, 84130},
	{"TRIKALA", 7, 253157},
	{"TRIJICON", 8, 226643},
	{"TRIJ", 4, 179452},
	{"TRIIODOTHYRONINE", 16, 154339},
	{"TRIHYDRATE", 10, 210762},
	{"TRIHALOMETHANES", 15, 213536},
	{"TRIGUN", 6, 97066},
	{"TRIGUE", 6, 162986},
	{"TRIGRAPHS", 9, 92875},
	{"TRIGRAM", 7, 199074},
	{"TRIGONOMETRY", 12, 80021},
	{"TRIGONOMETRIC", 13, 95058},
	{"TRIGONAL", 8, 208358},
	{"TRIGON", 6, 167287},
	{"TRIGO", 5, 228675},
	{"TRIGLYCERIDES", 13, 79073},
	{"TRIGLYCERIDE", 12, 96315},
	{"TRIGGS", 6, 186735},
	{"TRIGGERS", 8, 45790},
	{"TRIGGERING", 10, 57827},
	{"TRIGGERFISH", 11, 228110},
	{"TRIGGERED", 9, 43318},
	{"TRIGGER", 7, 30653},
	{"TRIGG", 5, 113000},
	{"TRIGEMINAL", 10, 108169},
	{"TRIGEM", 6, 155026},
	{"TRIGA", 5, 239285},
	{"TRIG", 4, 75458},
	{"TRIFORCE", 8, 173785},
	{"TRIFOLIUM", 9, 146485},
	{"TRIFOLD", 7, 148870},
	{"TRIFOCAL", 8, 229017},
	{"TRIFLURALIN", 11, 245711},
	{"TRIFLUOROMETHYL", 15, 187560},
	{"TRIFLUOPERAZINE", 15, 215707},
	{"TRIFLING", 8, 119734},
	{"TRIFLES", 7, 140601},
	{"TRIFLE", 6, 92874},
	{"TRIFFIDS", 8, 194388},
	{"TRIFECTA", 8, 113235},
	{"TRIFARI", 7, 228161},
	{"TRIETHANOLAMINE", 15, 196831},
	{"TRIESTE", 7, 66068},
	{"TRIEST", 6, 259738},
	{"TRIES", 5, 30669},
	{"TRIER", 5, 72089},
	{"TRIENNIUM", 9, 229272},
	{"TRIENNIAL", 9, 103926},
	{"TRIED", 5, 3667},
	{"TRIDIAGONAL", 11, 173761},
	{"TRIDGELL", 8, 245951},
	{"TRIDGE", 6, 159548},
	{"TRIDENTATA", 10, 221663},
	{"TRIDENT", 7, 60160},
	{"TRID", 4, 241514},
	{"TRICYCLIC", 9, 113770},
	{"TRICYCLES", 9, 122974},
	{"TRICYCLEN", 9, 108409},
	{"TRICYCLE", 8, 87948},
	{"TRICUSPID", 9, 154101},
	{"TRICT", 5, 158447},
	{"TRICOT", 6, 114946},
	{"TRICOR", 6, 182441},
	{"TRICOLOUR", 9, 187001},
	{"TRICOLOR", 8, 124692},
	{"TRICO", 5, 155958},
	{"TRICLOSAN", 9, 220995},
	{"TRICKY", 6, 45924},
	{"TRICKSTERS", 10, 198177},
	{"TRICKSTER", 9, 102977},
	{"TRICKS", 6, 28681},
	{"TRICKLING", 9, 121505},
	{"TRICKLES", 8, 186578},
	{"TRICKLED", 8, 148931},
	{"TRICKLE", 7, 69962},
	{"TRICKING", 8, 115670},
	{"TRICKIEST", 9, 221600},
	{"TRICKIER", 8, 134593},
	{"TRICKEY", 7, 245391},
	{"TRICKETT", 8, 185211},
	{"TRICKERY", 8, 103354},
	{"TRICKER", 7, 230683},
	{"TRICKED", 7, 73400},
	{"TRICK", 5, 10069},
	{"TRICITY", 7, 94694},
	{"TRICIA", 6, 65485},
	{"TRICHY", 6, 93122},
	{"TRICHUR", 7, 218498},
	{"TRICHOTILLOMANIA", 16, 219790},
	{"TRICHOPTERA", 11, 194185},
	{"TRICHODERMA", 11, 193530},
	{"TRICHLOROETHYLENE", 17, 132960},
	{"TRICHLOROETHENE", 15, 259020},
	{"TRICHLOROETHANE", 15, 147376},
	{"TRICHLOROACETIC", 15, 223720},
	{"TRICHLORO", 9, 238592},
	{"TRICHLORIDE", 11, 234240},
	{"TRICHINOSIS", 11, 246579},
	{"TRICHINELLA", 11, 245372},
	{"TRICHET", 7, 248764},
	{"TRICERATOPS", 11, 166741},
	{"TRICEPS", 7, 117321},
	{"TRICEP", 6, 164124},
	{"TRICE", 5, 92313},
	{"TRICARE", 7, 72150},
	{"TRICAL", 6, 249959},
	{"TRIC", 4, 135089},
	{"TRIBUTIONS", 10, 173989},
	{"TRIBUTION", 9, 117797},
	{"TRIBUTES", 8, 62563},
	{"TRIBUTED", 8, 129629},
	{"TRIBUTE", 7, 30497},
	{"TRIBUTARY", 9, 65981},
	{"TRIBUTARIES", 11, 66939},
	{"TRIBUS", 6, 80706},
	{"TRIBUNUS", 8, 121054},
	{"TRIBUNES", 8, 218814},
	{"TRIBUNE", 7, 29992},
	{"TRIBUNALS", 9, 63272},
	{"TRIBUNAL", 8, 35436},
	{"TRIBULUS", 8, 108299},
	{"TRIBULATIONS", 12, 86656},
	{"TRIBULATION", 11, 76848},
	{"TRIBU", 5, 183329},
	{"TRIBORO", 7, 194171},
	{"TRIBONACCI", 10, 228055},
	{"TRIBOLOGY", 9, 156846},
	{"TRIBLE", 6, 250433},
	{"TRIBESMEN", 9, 132247},
	{"TRIBESMAN", 9, 219780},
	{"TRIBES", 6, 32760},
	{"TRIBECA", 7, 68450},
	{"TRIBE", 5, 9449},
	{"TRIBBLES", 8, 231962},
	{"TRIBBLE", 7, 136015},
	{"TRIBAND", 7, 124333},
	{"TRIBALS", 7, 130777},
	{"TRIBALLY", 8, 217867},
	{"TRIBALISM", 9, 169216},
	{"TRIBAL", 6, 31589},
	{"TRIB", 4, 71699},
	{"TRIAZOLE", 8, 232624},
	{"TRIAZOLAM", 9, 202448},
	{"TRIAZINE", 8, 163442},
	{"TRIAXIAL", 8, 156212},
	{"TRIAX", 5, 93929},
	{"TRIATHLONS", 10, 153798},
	{"TRIATHLON", 9, 48284},
	{"TRIATHLETES", 11, 147115},
	{"TRIATHLETE", 10, 125179},
	{"TRIATHALON", 10, 235168},
	{"TRIASSIC", 8, 108748},
	{"TRIAS", 5, 167282},
	{"TRIANON", 7, 150989},
	{"TRIANGULATIONS", 14, 165275},
	{"TRIANGULATION", 13, 83340},
	{"TRIANGULATED", 12, 155771},
	{"TRIANGULATE", 11, 236406},
	{"TRIANGULAR", 10, 52897},
	{"TRIANGLES", 9, 54868},
	{"TRIANGLE", 8, 31247},
	{"TRIANG", 6, 169768},
	{"TRIANA", 6, 169857},
	{"TRIAN", 5, 211359},
	{"TRIAMTERENE", 11, 222818},
	{"TRIAMINIC", 9, 245423},
	{"TRIAMCINOLONE", 13, 137437},
	{"TRIALWARE", 9, 127325},
	{"TRIALS", 6, 7453},
	{"TRIALLING", 9, 191276},
	{"TRIALLED", 8, 163005},
	{"TRIALING", 8, 242580},
	{"TRIALED", 7, 232339},
	{"TRIAL", 5, 2713},
	{"TRIAGE", 6, 76973},
	{"TRIADS", 6, 125944},
	{"TRIADIC", 7, 223626},
	{"TRIAD", 5, 53134},
	{"TRIACYLGLYCEROL", 15, 235317},
	{"TRIAC", 5, 166154},
	{"TRIABLE", 7, 238952},
	{"TRHY", 4, 117117},
	{"TREYS", 5, 250541},
	{"TREYNOR", 7, 233372},
	{"TREY", 4, 60751},
	{"TREXLER", 7, 224692},
	{"TREX", 4, 129339},
	{"TREWS", 5, 215387},
	{"TREW", 4, 187581},
	{"TREVOSE", 7, 156796},
	{"TREVOR", 6, 40719},
	{"TREVISO", 7, 92335},
	{"TREVISAN", 8, 211844},
	{"TREVINO", 7, 112301},
	{"TREVILLE", 8, 228871},
	{"TREVI", 5, 105149},
	{"TREVES", 6, 213458},
	{"TREVER", 6, 236173},
	{"TREVELYAN", 9, 147266},
	{"TREVALLY", 8, 210630},
	{"TREVA", 5, 232150},
	{"TREV", 4, 124388},
	{"TREUTLEN", 8, 260033},
	{"TREU", 4, 214917},
	{"TRETYAKOV", 9, 253743},
	{"TRETORN", 7, 182920},
	{"TRETINOIN", 9, 128211},
	{"TRETHEWEY", 9, 238756},
	{"TRETH", 5, 215604},
	{"TRET", 4, 8245},
	{"TRESTLES", 8, 180243},
	{"TRESTLE", 7, 111046},
	{"TRESSES", 7, 140897},
	{"TRESSEL", 7, 252389},
	{"TRESSA", 6, 260942},
	{"TRESS", 5, 125521},
	{"TRESPASSING", 11, 92612},
	{"TRESPASSES", 10, 155197},
	{"TRESPASSERS", 11, 150259},
	{"TRESPASSER", 10, 172914},
	{"TRESPASSED", 10, 247006},
	{"TRESPASS", 8, 71947},
	{"TRESOR", 6, 82030},
	{"TRESHOLD", 8, 260225},
	{"TRESCOTHICK", 11, 197179},
	{"TRESCO", 6, 220107},
	{"TRER", 4, 67964},
	{"TREQ", 4, 36601},
	{"TREPONEMA", 9, 166291},
	{"TREPIDATION", 11, 109252},
	{"TREP", 4, 8001},
	{"TREORCHY", 8, 248102},
	{"TREOCENTRAL", 11, 250316},
	{"TREO", 4, 31913},
	{"TRENZ", 5, 222027},
	{"TRENTY", 6, 261045},
	{"TRENTON", 7, 45012},
	{"TRENTO", 6, 90214},
	{"TRENTINO", 8, 88728},
	{"TRENTHAM", 8, 144896},
	{"TRENTE", 6, 216808},
	{"TRENTBASIN", 10, 180525},
	{"TRENT", 5, 38368},
	{"TRENO", 5, 241186},
	{"TRENHOLM", 8, 259740},
	{"TRENDY", 6, 46385},
	{"TRENDWATCH", 10, 150709},
	{"TRENDWARE", 9, 124708},
	{"TRENDSPOTTING", 13, 248085},
	{"TRENDSETTING", 12, 223618},
	{"TRENDSETTERS", 12, 201992},
	{"TRENDSETTER", 11, 123966},
	{"TRENDS", 6, 4746},
	{"TRENDNET", 8, 84240},
	{"TRENDMICRO", 10, 196201},
	{"TRENDLINES", 10, 221756},
	{"TRENDLINE", 9, 165296},
	{"TRENDING", 8, 91825},
	{"TRENDIEST", 9, 182153},
	{"TRENDED", 7, 188330},
	{"TREND", 5, 5156},
	{"TRENCHLESS", 10, 196081},
	{"TRENCHING", 9, 113959},
	{"TRENCHES", 8, 60869},
	{"TRENCHER", 8, 161398},
	{"TRENCHCOAT", 10, 195787},
	{"TRENCHARD", 9, 233605},
	{"TRENCHANT", 9, 161108},
	{"TRENCH", 6, 51007},
	{"TREMULOUS", 9, 184822},
	{"TREMPER", 7, 210737},
	{"TREMPEALEAU", 11, 145397},
	{"TREMORS", 7, 82586},
	{"TREMOR", 6, 72830},
	{"TREMONTON", 9, 247417},
	{"TREMONT", 7, 83801},
	{"TREMOLO", 7, 104314},
	{"TREMERE", 7, 245609},
	{"TREMENTINA", 10, 187152},
	{"TREMENS", 7, 247414},
	{"TREMENDOUSLY", 12, 61715},
	{"TREMENDOUS", 10, 8888},
	{"TREMELY", 7, 229904},
	{"TREME", 5, 85071},
	{"TREMBLREL", 9, 168681},
	{"TREMBLING", 9, 63050},
	{"TREMBLES", 8, 160692},
	{"TREMBLED", 8, 97994},
	{"TREMBLE", 7, 83395},
	{"TREMBLAY", 8, 88042},
	{"TREMBLANT", 9, 81916},
	{"TREMBL", 6, 8485},
	{"TREMAYNE", 8, 200287},
	{"TREMAINE", 8, 130997},
	{"TREMAIN", 7, 192010},
	{"TREM", 4, 123523},
	{"TRELOAR", 7, 186116},
	{"TRELLISES", 9, 140472},
	{"TRELLIS", 7, 75022},
	{"TRELLIAN", 8, 157151},
	{"TRELLEBORG", 10, 168032},
	{"TRELAWNY", 8, 196398},
	{"TRELAWNEY", 9, 226765},
	{"TREKTODAY", 9, 213929},
	{"TREKSTOR", 8, 213714},
	{"TREKS", 5, 84607},
	{"TREKNATURE", 10, 171797},
	{"TREKLENS", 8, 148981},
	{"TREKKING", 8, 45433},
	{"TREKKIES", 8, 199257},
	{"TREKKIE", 7, 197106},
	{"TREKKERS", 8, 146158},
	{"TREKKER", 7, 92449},
	{"TREKKED", 7, 179642},
	{"TREKING", 7, 231491},
	{"TREKEARTH", 9, 91653},
	{"TREK", 4, 28114},
	{"TREJO", 5, 175816},
	{"TREJ", 4, 75131},
	{"TREISMAN", 8, 249579},
	{"TREIS", 5, 230945},
	{"TREIBER", 7, 107462},
	{"TREHALOSE", 9, 162192},
	{"TREGO", 5, 166899},
	{"TREGARON", 8, 246832},
	{"TREFOIL", 7, 129649},
	{"TREFNIADAU", 10, 240836},
	{"TREFFS", 6, 199462},
	{"TREFFPUNKT", 10, 239996},
	{"TREFFER", 7, 226117},
	{"TREFFEN", 7, 75806},
	{"TREFF", 5, 112837},
	{"TREF", 4, 139192},
	{"TREEWIDTH", 9, 248716},
	{"TREEVIEW", 8, 95406},
	{"TREETOPS", 8, 118584},
	{"TREETOP", 7, 151790},
	{"TREETING", 8, 234253},
	{"TREET", 5, 170416},
	{"TREESTANDS", 10, 218594},
	{"TREES", 5, 4548},
	{"TREEPAD", 7, 223965},
	{"TREENODE", 8, 204644},
	{"TREEN", 5, 205480},
	{"TREEMAP", 7, 260824},
	{"TREELINE", 8, 163476},
	{"TREELESS", 8, 127820},
	{"TREELANG", 8, 223487},
	{"TREEING", 7, 249240},
	{"TREEHUGGER", 10, 117365},
	{"TREEHOUSES", 10, 218247},
	{"TREEHOUSE", 9, 84244},
	{"TREEGR", 6, 231920},
	{"TREEFROG", 8, 204186},
	{"TREED", 5, 173178},
	{"TREECE", 6, 221906},
	{"TREEBEARD", 9, 252005},
	{"TREEBANK", 8, 205107},
	{"TREE", 4, 1919},
	{"TREDINNICK", 10, 248551},
	{"TREDEGAR", 8, 160682},
	{"TRED", 4, 174898},
	{"TRECE", 5, 253038},
	{"TREC", 4, 102173},
	{"TREBUCHET", 9, 96091},
	{"TREBOR", 6, 198897},
	{"TREBLINKA", 9, 197565},
	{"TREBLES", 7, 232810},
	{"TREBLED", 7, 220688},
	{"TREBLE", 6, 61092},
	{"TREB", 4, 223280},
	{"TREATY", 6, 8874},
	{"TREATS", 6, 36710},
	{"TREATMENTS", 10, 9062},
	{"TREATMENT", 9, 2314},
	{"TREATM", 6, 228558},
	{"TREATISES", 9, 101322},
	{"TREATISE", 8, 62093},
	{"TREATING", 8, 32716},
	{"TREATIES", 8, 43766},
	{"TREATERS", 8, 173922},
	{"TREATER", 7, 228386},
	{"TREATED", 7, 5346},
	{"TREATABLE", 9, 100529},
	{"TREATABILITY", 12, 203926},
	{"TREAT", 5, 2945},
	{"TREASURY", 8, 29564},
	{"TREASURIES", 10, 111572},
	{"TREASURES", 9, 36119},
	{"TREASURERS", 10, 103860},
	{"TREASURER", 9, 32014},
	{"TREASURENET", 11, 137127},
	{"TREASURED", 9, 67872},
	{"TREASURE", 8, 32182},
	{"TREASONOUS", 10, 165904},
	{"TREASONABLE", 11, 219387},
	{"TREASON", 7, 58642},
	{"TREAS", 5, 112192},
	{"TREANOR", 7, 200883},
	{"TREAMENT", 8, 210619},
	{"TREADWELL", 9, 118435},
	{"TREADWAY", 8, 143988},
	{"TREADS", 6, 97361},
	{"TREADMILLS", 10, 61769},
	{"TREADMILL", 9, 45157},
	{"TREADLE", 7, 178135},
	{"TREADING", 8, 100508},
	{"TREADER", 7, 175211},
	{"TREADED", 7, 238367},
	{"TREADCLIMBER", 12, 254743},
	{"TREAD", 5, 51411},
	{"TREACY", 6, 119700},
	{"TREACLE", 7, 150283},
	{"TREACHERY", 9, 85475},
	{"TREACHEROUSLY", 13, 220067},
	{"TREACHEROUS", 11, 77564},
	{"TREACHER", 8, 134529},
	{"TRDS", 4, 190489},
	{"TRDA", 4, 200377},
	{"TRCO", 4, 247877},
	{"TRCDSEMBLNEW", 12, 167272},
	{"TRCDSEMBL", 9, 90364},
	{"TRCA", 4, 258810},
	{"TRBS", 4, 239336},
	{"TRBRDRV", 7, 228065},
	{"TRBRDRT", 7, 225446},
	{"TRBRDRR", 7, 225232},
	{"TRBRDRL", 7, 225307},
	{"TRBRDRH", 7, 227419},
	{"TRBRDRB", 7, 225004},
	{"TRBI", 4, 131035},
	{"TRAZODONE", 9, 124839},
	{"TRAYS", 5, 44518},
	{"TRAYNOR", 7, 120599},
	{"TRAYLOR", 7, 132168},
	{"TRAYICON", 8, 242671},
	{"TRAY", 4, 33397},
	{"TRAXXAS", 7, 109815},
	{"TRAXX", 5, 108393},
	{"TRAXLER", 7, 219686},
	{"TRAXION", 7, 205987},
	{"TRAXDATA", 8, 152175},
	{"TRAX", 4, 54707},
	{"TRAWLS", 6, 158101},
	{"TRAWLING", 8, 108270},
	{"TRAWLERS", 8, 121819},
	{"TRAWLER", 7, 103324},
	{"TRAWLED", 7, 210792},
	{"TRAWL", 5, 77387},
	{"TRAWICK", 7, 196878},
	{"TRAW", 4, 42710},
	{"TRAVWL", 6, 258511},
	{"TRAVSL", 6, 259846},
	{"TRAVROUTE", 9, 258995},
	{"TRAVRL", 6, 250705},
	{"TRAVOLTA", 8, 70927},
	{"TRAVLE", 6, 219813},
	{"TRAVL", 5, 229936},
	{"TRAVIS", 6, 35898},
	{"TRAVIESAS", 9, 158655},
	{"TRAVIATA", 8, 125147},
	{"TRAVESTY", 8, 102852},
	{"TRAVESTITO", 10, 237607},
	{"TRAVESTIS", 9, 49567},
	{"TRAVESTIE", 9, 199764},
	{"TRAVESTI", 8, 29837},
	{"TRAVES", 6, 232472},
	{"TRAVERTINE", 10, 111093},
	{"TRAVERSING", 10, 84424},
	{"TRAVERSES", 9, 101065},
	{"TRAVERSED", 9, 85782},
	{"TRAVERSE", 8, 46462},
	{"TRAVERSALS", 10, 233631},
	{"TRAVERSAL", 9, 73673},
	{"TRAVERSABLE", 11, 247458},
	{"TRAVERS", 7, 73820},
	{"TRAVER", 6, 157631},
	{"TRAVEP", 6, 259971},
	{"TRAVEO", 6, 259830},
	{"TRAVELZOOCOM", 12, 206553},
	{"TRAVELZOO", 9, 82891},
	{"TRAVELWORM", 10, 199301},
	{"TRAVELTRAVEL", 12, 173142},
	{"TRAVELTIME", 10, 253781},
	{"TRAVELSUGGEST", 13, 104313},
	{"TRAVELSTAR", 10, 124722},
	{"TRAVELSOUND", 11, 187282},
	{"TRAVELSMITH", 11, 126156},
	{"TRAVELSHOP", 10, 253120},
	{"TRAVELSALE", 10, 231134},
	{"TRAVELS", 7, 35350},
	{"TRAVELPRO", 9, 91942},
	{"TRAVELPOWER", 11, 252996},
	{"TRAVELPOD", 9, 204628},
	{"TRAVELON", 8, 211121},
	{"TRAVELOGUES", 11, 70773},
	{"TRAVELOGUE", 10, 79072},
	{"TRAVELOGS", 9, 245524},
	{"TRAVELOG", 8, 129271},
	{"TRAVELODGES", 11, 166839},
	{"TRAVELODGE", 10, 48802},
	{"TRAVELOCITY", 11, 46006},
	{"TRAVELNOW", 9, 130723},
	{"TRAVELMAX", 9, 224618},
	{"TRAVELMATE", 10, 55348},
	{"TRAVELMALL", 10, 248605},
	{"TRAVELLODGES", 12, 185416},
	{"TRAVELLODGE", 11, 183629},
	{"TRAVELLINKER", 12, 256966},
	{"TRAVELLING", 10, 33902},
	{"TRAVELLIN", 9, 251918},
	{"TRAVELLERSPOINT", 15, 139097},
	{"TRAVELLERS", 10, 38203},
	{"TRAVELLER", 9, 34673},
	{"TRAVELLED", 9, 46270},
	{"TRAVELL", 7, 230167},
	{"TRAVELING", 9, 29058},
	{"TRAVELINE", 9, 199167},
	{"TRAVELIN", 8, 145765},
	{"TRAVELHOTEL", 11, 175037},
	{"TRAVELHERO", 10, 254090},
	{"TRAVELGUIDE", 11, 93382},
	{"TRAVELGOLF", 10, 195036},
	{"TRAVELEX", 8, 182810},
	{"TRAVELERSINTOUCH", 16, 231963},
	{"TRAVELERS", 9, 30511},
	{"TRAVELERMATCH", 13, 247029},
	{"TRAVELER", 8, 31071},
	{"TRAVELED", 8, 37402},
	{"TRAVELDRIVE", 11, 230089},
	{"TRAVELCHAIR", 11, 251536},
	{"TRAVELCARD", 10, 261160},
	{"TRAVELBLOGS", 11, 220061},
	{"TRAVELBLOG", 10, 111008},
	{"TRAVELAPE", 9, 250083},
	{"TRAVEL", 6, 3277},
	{"TRAVEK", 6, 256550},
	{"TRAVEI", 6, 233066},
	{"TRAVE", 5, 134398},
	{"TRAVDL", 6, 259505},
	{"TRAVCOA", 7, 232490},
	{"TRAVAUX", 7, 109985},
	{"TRAVANCORE", 10, 212966},
	{"TRAVAN", 6, 131093},
	{"TRAVAL", 6, 212343},
	{"TRAVAILS", 8, 140945},
	{"TRAVAILLEURS", 12, 197494},
	{"TRAVAILLER", 10, 175948},
	{"TRAVAIL", 7, 67090},
	{"TRAV", 4, 82578},
	{"TRAUTMANN", 9, 254104},
	{"TRAUTMAN", 8, 231057},
	{"TRAURIG", 7, 169111},
	{"TRAUMTITTEN", 11, 186480},
	{"TRAUMATOLOGY", 12, 174509},
	{"TRAUMATIZED", 11, 101008},
	{"TRAUMATISED", 11, 159475},
	{"TRAUMATIC", 9, 45300},
	{"TRAUMAS", 7, 120982},
	{"TRAUMARSCH", 10, 188605},
	{"TRAUMAERSCHE", 12, 187962},
	{"TRAUMAAMBER", 11, 235881},
	{"TRAUMA", 6, 33731},
	{"TRAUM", 5, 133636},
	{"TRAUB", 5, 152556},
	{"TRAU", 4, 255477},
	{"TRATTORIA", 9, 104100},
	{"TRATTA", 6, 208436},
	{"TRATOR", 6, 241422},
	{"TRATIVE", 7, 156018},
	{"TRATIONS", 8, 186055},
	{"TRATION", 7, 106828},
	{"TRATEGY", 7, 251402},
	{"TRATED", 6, 181157},
	{"TRATE", 5, 189707},
	{"TRATATA", 7, 239563},
	{"TRATAMIENTOS", 12, 168761},
	{"TRATAMIENTO", 11, 126245},
	{"TRATADO", 7, 230931},
	{"TRATA", 5, 190037},
	{"TRASTUZUMAB", 11, 181182},
	{"TRASTEVERE", 10, 163024},
	{"TRAST", 5, 186108},
	{"TRASPORTO", 9, 118929},
	{"TRASPORTI", 9, 176035},
	{"TRASK", 5, 93669},
	{"TRASIMENO", 9, 201869},
	{"TRASHY", 6, 53719},
	{"TRASHING", 8, 108170},
	{"TRASHES", 7, 198809},
	{"TRASHED", 7, 88216},
	{"TRASHCAN", 8, 135702},
	{"TRASH", 5, 33883},
	{"TRASER", 6, 222518},
	{"TRARY", 5, 224495},
	{"TRARALGON", 9, 145888},
	{"TRAR", 4, 38922},
	{"TRAQ", 4, 202060},
	{"TRAPT", 5, 118065},
	{"TRAPS", 5, 40102},
	{"TRAPPIST", 8, 193228},
	{"TRAPPINGS", 9, 100105},
	{"TRAPPING", 8, 54482},
	{"TRAPPERS", 8, 113731},
	{"TRAPPER", 7, 86062},
	{"TRAPPED", 7, 39908},
	{"TRAPPE", 6, 175309},
	{"TRAPP", 5, 103358},
	{"TRAPILC", 7, 236798},
	{"TRAPDOOR", 8, 151919},
	{"TRAPANI", 7, 127507},
	{"TRAP", 4, 30116},
	{"TRAORE", 6, 220724},
	{"TRAORDINARY", 11, 163486},
	{"TRANZANDO", 9, 222946},
	{"TRANZ", 5, 168438},
	{"TRANYLCYPROMINE", 15, 161360},
	{"TRANY", 5, 97664},
	{"TRANX", 5, 180482},
	{"TRANVESTITES", 12, 119881},
	{"TRANTER", 7, 185767},
	{"TRANSYLVANIAN", 13, 188683},
	{"TRANSYLVANIA", 12, 80084},
	{"TRANSWORLD", 10, 88191},
	{"TRANSWESTERN", 12, 223174},
	{"TRANSVESTITES", 13, 41819},
	{"TRANSVESTITE", 12, 37863},
	{"TRANSVESTISM", 12, 214700},
	{"TRANSVERSELY", 12, 151362},
	{"TRANSVERSE", 10, 50760},
	{"TRANSVERSALITY", 14, 253506},
	{"TRANSVERSAL", 11, 120928},
	{"TRANSVAAL", 9, 120959},
	{"TRANSURETHRAL", 13, 180002},
	{"TRANSURANIC", 11, 177327},
	{"TRANSUNION", 10, 129298},
	{"TRANSUBSTANTIATION", 18, 217392},
	{"TRANSTHORACIC", 13, 233054},
	{"TRANSTERRESTRIAL", 16, 188494},
	{"TRANSTECH", 9, 207871},
	{"TRANSSHIPMENT", 13, 138880},
	{"TRANSRECTAL", 11, 258777},
	{"TRANSRACIAL", 11, 250449},
	{"TRANSPUTER", 10, 211362},
	{"TRANSPOWER", 10, 188211},
	{"TRANSPOSONS", 11, 208470},
	{"TRANSPOSON", 10, 120236},
	{"TRANSPOSITIONS", 14, 225216},
	{"TRANSPOSITION", 13, 84663},
	{"TRANSPOSING", 11, 158709},
	{"TRANSPOSER", 10, 238087},
	{"TRANSPOSED", 10, 105027},
	{"TRANSPOSE", 9, 80778},
	{"TRANSPOSASE", 11, 134144},
	{"TRANSPOSABLE", 12, 147391},
	{"TRANSPORTS", 10, 55467},
	{"TRANSPORTPLASTICS", 17, 128419},
	{"TRANSPORTING", 12, 47997},
	{"TRANSPORTES", 11, 211159},
	{"TRANSPORTERS", 12, 69607},
	{"TRANSPORTER", 11, 42791},
	{"TRANSPORTED", 11, 42589},
	{"TRANSPORTE", 10, 106203},
	{"TRANSPORTATIONS", 15, 156608},
	{"TRANSPORTATION", 14, 7356},
	{"TRANSPORTAT", 11, 227763},
	{"TRANSPORTABLE", 13, 104996},
	{"TRANSPORTA", 10, 164949},
	{"TRANSPORT", 9, 35026},
	{"TRANSPORATION", 13, 179200},
	{"TRANSPOR", 8, 179961},
	{"TRANSPONDERS", 12, 111060},
	{"TRANSPONDER", 11, 72983},
	{"TRANSPOD", 8, 257966},
	{"TRANSPO", 7, 194574},
	{"TRANSPLANTS", 11, 56243},
	{"TRANSPLANTING", 13, 109221},
	{"TRANSPLANTED", 12, 74024},
	{"TRANSPLANTATION", 15, 41333},
	{"TRANSPLANT", 10, 39462},
	{"TRANSPIRING", 11, 235287},
	{"TRANSPIRES", 10, 162657},
	{"TRANSPIRED", 10, 96205},
	{"TRANSPIRE", 9, 158931},
	{"TRANSPIRATION", 13, 126695},
	{"TRANSPERSONAL", 13, 124151},
	{"TRANSPARENTLY", 13, 80953},
	{"TRANSPARENT", 11, 31128},
	{"TRANSPARENCY", 12, 35897},
	{"TRANSPARENCIES", 14, 69894},
	{"TRANSPARENCE", 12, 241737},
	{"TRANSPACIFIC", 12, 195513},
	{"TRANSPAC", 8, 206695},
	{"TRANSP", 6, 104432},
	{"TRANSONIC", 9, 164783},
	{"TRANSOM", 7, 85966},
	{"TRANSOCEANIC", 12, 219450},
	{"TRANSOCEAN", 10, 244006},
	{"TRANSNISTRIA", 12, 233658},
	{"TRANSNET", 8, 181293},
	{"TRANSNATIONALISM", 16, 235275},
	{"TRANSNATIONAL", 13, 51562},
	{"TRANSMUTED", 10, 203553},
	{"TRANSMUTE", 9, 185389},
	{"TRANSMUTATION", 13, 120605},
	{"TRANSMSN", 8, 243193},
	{"TRANSMONDE", 10, 182691},
	{"TRANSMITTING", 12, 48453},
	{"TRANSMITTERS", 12, 54080},
	{"TRANSMITTER", 11, 37268},
	{"TRANSMITTED", 11, 28764},
	{"TRANSMITTANCE", 13, 124271},
	{"TRANSMITTALS", 12, 255584},
	{"TRANSMITTAL", 11, 69486},
	{"TRANSMITS", 9, 64246},
	{"TRANSMIT", 8, 35572},
	{"TRANSMISSIVITY", 14, 210580},
	{"TRANSMISSIVE", 12, 191328},
	{"TRANSMISSIONS", 13, 45589},
	{"TRANSMISSION", 12, 30387},
	{"TRANSMISSIBLE", 13, 121058},
	{"TRANSMIS", 8, 167356},
	{"TRANSMIGRATION", 14, 169591},
	{"TRANSMETA", 9, 124879},
	{"TRANSMEMBRANE", 13, 63470},
	{"TRANSMEM", 8, 125724},
	{"TRANSMEDIA", 10, 140416},
	{"TRANSMAP", 8, 211600},
	{"TRANSM", 6, 187356},
	{"TRANSLUMINAL", 12, 167812},
	{"TRANSLUCENT", 11, 54272},
	{"TRANSLUCENCY", 12, 169977},
	{"TRANSLUCENCE", 12, 218083},
	{"TRANSLOCATOR", 12, 258452},
	{"TRANSLOCATIONS", 14, 161271},
	{"TRANSLOCATION", 13, 71331},
	{"TRANSLOCATING", 13, 196087},
	{"TRANSLOCATED", 12, 169083},
	{"TRANSLOCASE", 11, 180146},
	{"TRANSLITERATIONS", 16, 237433},
	{"TRANSLITERATION", 15, 97789},
	{"TRANSLITERATED", 14, 145075},
	{"TRANSLIT", 8, 247952},
	{"TRANSLINK", 9, 149940},
	{"TRANSLATUM", 10, 182953},
	{"TRANSLATORS", 11, 37904},
	{"TRANSLATOR", 10, 36527},
	{"TRANSLATIONS", 12, 33045},
	{"TRANSLATIONAL", 13, 70071},
	{"TRANSLATION", 11, 32903},
	{"TRANSLATING", 11, 50199},
	{"TRANSLATES", 10, 48207},
	{"TRANSLATER", 10, 243401},
	{"TRANSLATED", 10, 30879},
	{"TRANSLATE", 9, 8852},
	{"TRANSLATABLE", 12, 174900},
	{"TRANSLA", 7, 239659},
	{"TRANSL", 6, 87357},
	{"TRANSKETOLASE", 13, 257616},
	{"TRANSKEI", 8, 169968},
	{"TRANSITS", 8, 109132},
	{"TRANSITORY", 10, 88929},
	{"TRANSITIVITY", 12, 142520},
	{"TRANSITIVELY", 12, 248972},
	{"TRANSITIVE", 10, 75740},
	{"TRANSITIONS", 11, 38638},
	{"TRANSITIONING", 13, 79217},
	{"TRANSITIONED", 12, 116507},
	{"TRANSITIONAL", 12, 38695},
	{"TRANSITION", 10, 6746},
	{"TRANSITING", 10, 128342},
	{"TRANSITED", 9, 253422},
	{"TRANSIT", 7, 35290},
	{"TRANSISTORS", 11, 59777},
	{"TRANSISTOR", 10, 49661},
	{"TRANSIENTS", 10, 87964},
	{"TRANSIENTLY", 11, 128764},
	{"TRANSIENT", 9, 40518},
	{"TRANSIENCE", 10, 172675},
	{"TRANSI", 6, 148424},
	{"TRANSHUMANIST", 13, 201255},
	{"TRANSHUMANISM", 13, 144179},
	{"TRANSHUMAN", 10, 232880},
	{"TRANSHIPMENT", 12, 196114},
	{"TRANSGRESSORS", 13, 184581},
	{"TRANSGRESSIVE", 13, 173128},
	{"TRANSGRESSIONS", 14, 100896},
	{"TRANSGRESSION", 13, 91910},
	{"TRANSGRESSING", 13, 219636},
	{"TRANSGRESSED", 12, 165118},
	{"TRANSGRESS", 10, 157341},
	{"TRANSGLUTAMINASE", 16, 221399},
	{"TRANSGENICS", 11, 196649},
	{"TRANSGENIC", 10, 52798},
	{"TRANSGENES", 10, 160010},
	{"TRANSGENERATION", 15, 255029},
	{"TRANSGENE", 9, 101906},
	{"TRANSGENDERS", 12, 199836},
	{"TRANSGENDERED", 13, 76711},
	{"TRANSGENDER", 11, 50517},
	{"TRANSFUSIONS", 12, 100409},
	{"TRANSFUSION", 11, 57984},
	{"TRANSFUSED", 10, 191320},
	{"TRANSFRONTIER", 13, 185397},
	{"TRANSFORMS", 10, 48153},
	{"TRANSFORMING", 12, 41363},
	{"TRANSFORMERS", 12, 40105},
	{"TRANSFORMER", 11, 43654},
	{"TRANSFORMED", 11, 36880},
	{"TRANSFORMATOR", 13, 209545},
	{"TRANSFORMATIVE", 14, 90125},
	{"TRANSFORMATIONS", 15, 44104},
	{"TRANSFORMATIONAL", 16, 80754},
	{"TRANSFORMATION", 14, 28417},
	{"TRANSFORMANTS", 13, 152747},
	{"TRANSFORMA", 10, 160945},
	{"TRANSFORM", 9, 6838},
	{"TRANSFOR", 8, 179975},
	{"TRANSFLECTIVE", 13, 104836},
	{"TRANSFLASH", 10, 96506},
	{"TRANSFIXING", 11, 241239},
	{"TRANSFIXED", 10, 139169},
	{"TRANSFIRMER", 11, 192764},
	{"TRANSFINITE", 11, 235759},
	{"TRANSFIGURED", 12, 162611},
	{"TRANSFIGURATION", 15, 113371},
	{"TRANSFIG", 8, 211366},
	{"TRANSFERWARE", 12, 190674},
	{"TRANSFERTS", 10, 242383},
	{"TRANSFERT", 9, 131676},
	{"TRANSFERS", 9, 9670},
	{"TRANSFERRING", 12, 41142},
	{"TRANSFERRIN", 11, 109645},
	{"TRANSFERRED", 11, 9942},
	{"TRANSFERRABLE", 13, 224111},
	{"TRANSFEROR", 10, 94702},
	{"TRANSFERING", 11, 120362},
	{"TRANSFERENCIA", 13, 240519},
	{"TRANSFERENCE", 12, 105178},
	{"TRANSFEREES", 11, 174609},
	{"TRANSFEREE", 10, 78696},
	{"TRANSFERED", 10, 92867},
	{"TRANSFERASES", 12, 155007},
	{"TRANSFERASE", 11, 68538},
	{"TRANSFERABLE", 12, 52079},
	{"TRANSFERABILITY", 15, 111437},
	{"TRANSFER", 8, 7283},
	{"TRANSFECTION", 12, 76589},
	{"TRANSFECTED", 11, 77544},
	{"TRANSFECTANTS", 13, 256112},
	{"TRANSF", 6, 178893},
	{"TRANSESSUALE", 12, 68924},
	{"TRANSESOPHAGEAL", 15, 177864},
	{"TRANSEPT", 8, 192161},
	{"TRANSEN", 7, 72245},
	{"TRANSECTS", 9, 108172},
	{"TRANSECTION", 11, 227348},
	{"TRANSECT", 8, 85579},
	{"TRANSDUCTION", 12, 57777},
	{"TRANSDUCING", 11, 203385},
	{"TRANSDUCIN", 10, 235993},
	{"TRANSDUCERS", 11, 64007},
	{"TRANSDUCER", 10, 56096},
	{"TRANSDUCED", 10, 160400},
	{"TRANSDISCIPLINARY", 17, 177152},
	{"TRANSDERMAL", 11, 94493},
	{"TRANSDERM", 9, 148374},
	{"TRANSCUTANEOUS", 14, 170118},
	{"TRANSCULTURAL", 13, 157627},
	{"TRANSCRIPTS", 11, 36132},
	{"TRANSCRIPTOME", 13, 162662},
	{"TRANSCRIPTIONS", 14, 73136},
	{"TRANSCRIPTIONISTS", 17, 182833},
	{"TRANSCRIPTIONIST", 16, 140634},
	{"TRANSCRIPTIONALLY", 17, 194072},
	{"TRANSCRIPTIONAL", 15, 54568},
	{"TRANSCRIPTION", 13, 32035},
	{"TRANSCRIPTASE", 13, 84445},
	{"TRANSCRIPT", 10, 30246},
	{"TRANSCRIBING", 12, 99287},
	{"TRANSCRIBERS", 12, 112368},
	{"TRANSCRIBER", 11, 92980},
	{"TRANSCRIBED", 11, 49315},
	{"TRANSCRIBE", 10, 93364},
	{"TRANSCRANIAL", 12, 164749},
	{"TRANSCONTINENTAL", 16, 98221},
	{"TRANSCONDUCTANCE", 16, 227903},
	{"TRANSCONA", 9, 239455},
	{"TRANSCOM", 8, 209057},
	{"TRANSCODING", 11, 106351},
	{"TRANSCODER", 10, 132918},
	{"TRANSCODE", 9, 107569},
	{"TRANSCO", 7, 118104},
	{"TRANSCENDS", 10, 82950},
	{"TRANSCENDING", 12, 105272},
	{"TRANSCENDER", 11, 171145},
	{"TRANSCENDENTALISM", 17, 207833},
	{"TRANSCENDENTAL", 14, 73625},
	{"TRANSCENDENT", 12, 83763},
	{"TRANSCENDENCE", 13, 95836},
	{"TRANSCENDED", 11, 126244},
	{"TRANSCENDCOMPLIANCE", 19, 226304},
	{"TRANSCEND", 9, 50531},
	{"TRANSCEIVERS", 12, 75511},
	{"TRANSCEIVER", 11, 244},
	{"TRANSCANADA", 11, 166845},
	{"TRANSBOUNDARY", 13, 89512},
	{"TRANSBORDER", 11, 171905},
	{"TRANSAXLE", 9, 177325},
	{"TRANSATLANTIC", 13, 62050},
	{"TRANSAT", 7, 165478},
	{"TRANSANDO", 9, 78805},
	{"TRANSAMINASES", 13, 220989},
	{"TRANSAMINASE", 12, 129595},
	{"TRANSAMERICA", 12, 76314},
	{"TRANSAM", 7, 213144},
	{"TRANSALTA", 9, 209554},
	{"TRANSACTS", 9, 261515},
	{"TRANSACTIVATION", 15, 142960},
	{"TRANSACTIONS", 12, 5261},
	{"TRANSACTIONAL", 13, 60730},
	{"TRANSACTION", 11, 30945},
	{"TRANSACTING", 11, 130529},
	{"TRANSACTED", 10, 85865},
	{"TRANSACT", 8, 69748},
	{"TRANSAC", 7, 158917},
	{"TRANSA", 6, 156296},
	{"TRANS", 5, 7990},
	{"TRANQUILO", 9, 244156},
	{"TRANQUILLITY", 12, 79181},
	{"TRANQUILLISERS", 14, 237301},
	{"TRANQUILIZING", 13, 232224},
	{"TRANQUILIZERS", 13, 125336},
	{"TRANQUILIZER", 12, 166780},
	{"TRANQUILITY", 11, 60903},
	{"TRANQUIL", 8, 57288},
	{"TRANNIES", 8, 69790},
	{"TRANNIE", 7, 159862},
	{"TRANMS", 6, 108740},
	{"TRANMERE", 8, 123094},
	{"TRANING", 7, 180511},
	{"TRANH", 5, 105210},
	{"TRANGO", 6, 137349},
	{"TRANGIA", 7, 196366},
	{"TRANG", 5, 54557},
	{"TRANFER", 7, 181687},
	{"TRANENT", 7, 247399},
	{"TRANE", 5, 103681},
	{"TRANCHES", 8, 153609},
	{"TRANCHE", 7, 95604},
	{"TRANCES", 7, 241750},
	{"TRANCEIVERS", 11, 207905},
	{"TRANCE", 6, 31862},
	{"TRANADOL", 8, 221868},
	{"TRAMWAYS", 8, 160055},
	{"TRAMWAY", 7, 96617},
	{"TRAMSDOL", 8, 226920},
	{"TRAMS", 5, 77122},
	{"TRAMPS", 6, 105610},
	{"TRAMPOLINING", 12, 212157},
	{"TRAMPOLINES", 11, 69281},
	{"TRAMPOLINE", 10, 63151},
	{"TRAMPLING", 9, 72098},
	{"TRAMPLED", 8, 93297},
	{"TRAMPLE", 7, 79022},
	{"TRAMPING", 8, 128156},
	{"TRAMPED", 7, 244353},
	{"TRAMPAS", 7, 173288},
	{"TRAMP", 5, 59948},
	{"TRAMORE", 7, 183757},
	{"TRAMONTO", 8, 201800},
	{"TRAMONTINA", 10, 255586},
	{"TRAMMELL", 8, 116911},
	{"TRAMMEL", 7, 172929},
	{"TRAMITE", 7, 224182},
	{"TRAMDOL", 7, 211409},
	{"TRAMDOCK", 8, 246485},
	{"TRAMAOL", 7, 219038},
	{"TRAMADOL", 8, 9340},
	{"TRAMADO", 7, 206922},
	{"TRAMADL", 7, 207612},
	{"TRAMADIL", 8, 227406},
	{"TRAMA", 5, 197092},
	{"TRAM", 4, 55271},
	{"TRALFAZ", 7, 257740},
	{"TRALEE", 6, 110000},
	{"TRAL", 4, 132571},
	{"TRAKTOR", 7, 119481},
	{"TRAKL", 5, 123691},
	{"TRAKKER", 7, 225687},
	{"TRAKAI", 6, 257730},
	{"TRAK", 4, 90529},
	{"TRAJET", 6, 206222},
	{"TRAJES", 6, 141372},
	{"TRAJECTORY", 10, 51955},
	{"TRAJECTORIES", 12, 64994},
	{"TRAJE", 5, 170368},
	{"TRAJAN", 6, 137476},
	{"TRAJ", 4, 64673},
	{"TRAIU", 5, 134141},
	{"TRAITS", 6, 41223},
	{"TRAITORS", 8, 87022},
	{"TRAITOROUS", 10, 182248},
	{"TRAITOR", 7, 70663},
	{"TRAITEMENT", 10, 111405},
	{"TRAITE", 6, 193079},
	{"TRAIT", 5, 30181},
	{"TRAIPSING", 9, 245655},
	{"TRAINZ", 6, 171757},
	{"TRAINWRECK", 10, 144670},
	{"TRAINSPOTTING", 13, 107629},
	{"TRAINS", 6, 30530},
	{"TRAINOR", 7, 140198},
	{"TRAINNING", 9, 259230},
	{"TRAINLINE", 9, 204785},
	{"TRAININGS", 9, 61778},
	{"TRAINING", 8, 2455},
	{"TRAININ", 7, 220278},
	{"TRAINI", 6, 226489},
	{"TRAING", 6, 255569},
	{"TRAINERS", 8, 33832},
	{"TRAINER", 7, 33819},
	{"TRAINEESHIPS", 12, 123718},
	{"TRAINEESHIP", 11, 114226},
	{"TRAINEES", 8, 49147},
	{"TRAINEE", 7, 43192},
	{"TRAINED", 7, 8325},
	{"TRAINABLE", 9, 185029},
	{"TRAINA", 6, 218004},
	{"TRAIN", 5, 4739},
	{"TRAILWAYS", 9, 221281},
	{"TRAILSIDE", 9, 207848},
	{"TRAILS", 6, 29288},
	{"TRAILRUNNING", 12, 244439},
	{"TRAILORS", 8, 171178},
	{"TRAILOR", 7, 166757},
	{"TRAILL", 6, 166623},
	{"TRAILING", 8, 47180},
	{"TRAILHEADS", 10, 209440},
	{"TRAILHEAD", 9, 89091},
	{"TRAILERS", 8, 8096},
	{"TRAILERING", 10, 134605},
	{"TRAILER", 7, 32055},
	{"TRAILED", 7, 80807},
	{"TRAILBLAZING", 12, 133619},
	{"TRAILBLAZERS", 12, 104330},
	{"TRAILBLAZER", 11, 76556},
	{"TRAIL", 5, 4928},
	{"TRAIDCRAFT", 10, 198201},
	{"TRAIAN", 6, 196273},
	{"TRAHAN", 6, 162287},
	{"TRAGUS", 6, 240072},
	{"TRAGICALLY", 10, 75975},
	{"TRAGIC", 6, 33353},
	{"TRAGER", 6, 142733},
	{"TRAGEN", 6, 241818},
	{"TRAGEL", 6, 259109},
	{"TRAGEDY", 7, 9324},
	{"TRAGEDIES", 9, 66706},
	{"TRAGEDIA", 8, 250648},
	{"TRAG", 4, 255265},
	{"TRAFTON", 7, 259384},
	{"TRAFICANT", 9, 148272},
	{"TRAFIC", 6, 75861},
	{"TRAFFORD", 8, 66232},
	{"TRAFFICS", 8, 232606},
	{"TRAFFICKING", 11, 41274},
	{"TRAFFICKERS", 11, 83946},
	{"TRAFFICKER", 10, 187882},
	{"TRAFFICKED", 10, 89485},
	{"TRAFFICK", 8, 220214},
	{"TRAFFIC", 7, 5283},
	{"TRAFEL", 6, 258353},
	{"TRAFALGAR", 9, 60092},
	{"TRAF", 4, 127874},
	{"TRAEVL", 6, 255736},
	{"TRAER", 5, 236983},
	{"TRAEL", 5, 245323},
	{"TRAEGER", 7, 250771},
	{"TRADUZIONI", 10, 193238},
	{"TRADUZIONE", 10, 146598},
	{"TRADUZIDAS", 10, 98352},
	{"TRADUZIDA", 9, 129204},
	{"TRADUZCA", 8, 58104},
	{"TRADURRE", 8, 252708},
	{"TRADUIT", 7, 223438},
	{"TRADUIRE", 8, 125150},
	{"TRADUCTORES", 11, 202609},
	{"TRADUCTOR", 9, 246243},
	{"TRADUCTIONS", 11, 210059},
	{"TRADUCTION", 10, 97923},
	{"TRADUCTEUR", 10, 254292},
	{"TRADUCIR", 8, 199946},
	{"TRADUCI", 7, 151405},
	{"TRADUCCIONES", 12, 173176},
	{"TRADUCCION", 10, 256897},
	{"TRADOS", 6, 89716},
	{"TRADOC", 6, 141572},
	{"TRADITONAL", 10, 212740},
	{"TRADITIONS", 10, 31651},
	{"TRADITIONNAL", 12, 242931},
	{"TRADITIONALLY", 13, 30536},
	{"TRADITIONALISTS", 15, 127976},
	{"TRADITIONALIST", 14, 118911},
	{"TRADITIONALISM", 14, 191586},
	{"TRADITIONALFORM", 15, 124334},
	{"TRADITIONAL", 11, 2749},
	{"TRADITION", 9, 3620},
	{"TRADIONAL", 9, 250959},
	{"TRADING", 7, 29195},
	{"TRADIN", 6, 209087},
	{"TRADICIONAL", 11, 235071},
	{"TRADI", 5, 123956},
	{"TRADEWINDS", 10, 99982},
	{"TRADEWIND", 9, 211933},
	{"TRADESTATION", 12, 141511},
	{"TRADESPERSON", 12, 220037},
	{"TRADESPEOPLE", 12, 174916},
	{"TRADESMEN", 9, 94116},
	{"TRADESMAN", 9, 107788},
	{"TRADESKILLS", 11, 209392},
	{"TRADESKILL", 10, 143682},
	{"TRADESIGNALS", 12, 200813},
	{"TRADESHOWS", 10, 87634},
	{"TRADESHOW", 9, 69891},
	{"TRADESCANTIA", 12, 262111},
	{"TRADES", 6, 31120},
	{"TRADERS", 7, 36730},
	{"TRADERONLINE", 12, 150013},
	{"TRADER", 6, 34115},
	{"TRADEOFFS", 9, 84396},
	{"TRADEOFF", 8, 83262},
	{"TRADENET", 8, 233287},
	{"TRADENAMES", 10, 126057},
	{"TRADENAME", 9, 116582},
	{"TRADEMARKS", 10, 2559},
	{"TRADEMARKED", 11, 65766},
	{"TRADEMARK", 9, 4622},
	{"TRADEMANAGER", 12, 65444},
	{"TRADELINE", 9, 210471},
	{"TRADELEADS", 10, 233314},
	{"TRADEEASY", 9, 187414},
	{"TRADED", 6, 38072},
	{"TRADECRAFT", 10, 184502},
	{"TRADECENTRE", 11, 161512},
	{"TRADEABLE", 9, 162512},
	{"TRADE", 5, 2472},
	{"TRADABLE", 8, 104251},
	{"TRADA", 5, 203516},
	{"TRAD", 4, 58825},
	{"TRACY", 5, 34654},
	{"TRACTS", 6, 53838},
	{"TRACTORS", 8, 47355},
	{"TRACTOR", 7, 36529},
	{"TRACTIVE", 8, 226827},
	{"TRACTION", 8, 43974},
	{"TRACTING", 8, 251105},
	{"TRACTED", 7, 213105},
	{"TRACTATUS", 9, 200709},
	{"TRACTATE", 8, 200876},
	{"TRACTABLE", 9, 111610},
	{"TRACTABILITY", 12, 222702},
	{"TRACT", 5, 34751},
	{"TRACS", 5, 213797},
	{"TRACON", 6, 261668},
	{"TRACO", 5, 185793},
	{"TRACKWAY", 8, 190615},
	{"TRACKWARE", 9, 200598},
	{"TRACKTION", 9, 232143},
	{"TRACKSUITS", 10, 115032},
	{"TRACKSUIT", 9, 84264},
	{"TRACKSTAR", 9, 222089},
	{"TRACKSIDE", 9, 120931},
	{"TRACKS", 6, 5089},
	{"TRACKPOINT", 10, 108755},
	{"TRACKPAD", 8, 182702},
	{"TRACKNAME", 9, 237493},
	{"TRACKMANIA", 10, 91383},
	{"TRACKMAN", 8, 196802},
	{"TRACKLISTINGS", 13, 191018},
	{"TRACKLISTING", 12, 82595},
	{"TRACKLIST", 9, 87804},
	{"TRACKLESS", 9, 215190},
	{"TRACKING", 8, 4862},
	{"TRACKERS", 8, 73490},
	{"TRACKER", 7, 9929},
	{"TRACKED", 7, 9404},
	{"TRACKDAYS", 9, 211003},
	{"TRACKDAY", 8, 247019},
	{"TRACKBALLS", 10, 113347},
	{"TRACKBALL", 9, 90676},
	{"TRACKBACKS", 10, 32508},
	{"TRACKBACKED", 11, 168745},
	{"TRACKBACK", 9, 4634},
	{"TRACKAGE", 8, 224275},
	{"TRACKABLE", 9, 146650},
	{"TRACK", 5, 3462},
	{"TRACINGS", 8, 177462},
	{"TRACING", 7, 43154},
	{"TRACIE", 6, 108143},
	{"TRACID", 6, 262115},
	{"TRACIANNA", 9, 197186},
	{"TRACI", 5, 68578},
	{"TRACHTENBERG", 12, 113230},
	{"TRACHOMATIS", 11, 118378},
	{"TRACHOMA", 8, 176501},
	{"TRACHEOTOMY", 11, 187721},
	{"TRACHEOSTOMY", 12, 127667},
	{"TRACHEOPHYTA", 12, 167680},
	{"TRACHEAL", 8, 105629},
	{"TRACHEA", 7, 97701},
	{"TRACH", 5, 183466},
	{"TRACGUIDE", 9, 254126},
	{"TRACFONE", 8, 97419},
	{"TRACEY", 6, 50945},
	{"TRACES", 6, 40602},
	{"TRACERY", 7, 242107},
	{"TRACERT", 7, 213950},
	{"TRACERS", 7, 101146},
	{"TRACERPLUS", 10, 227037},
	{"TRACEROUTE", 10, 78678},
	{"TRACER", 6, 56411},
	{"TRACEL", 6, 256859},
	{"TRACED", 6, 49667},
	{"TRACEBACK", 9, 91774},
	{"TRACEABLE", 9, 80152},
	{"TRACEABILITY", 12, 75379},
	{"TRACE", 5, 10077},
	{"TRACBROWSER", 11, 113637},
	{"TRACADIE", 8, 228647},
	{"TRAC", 4, 37523},
	{"TRABZON", 7, 164071},
	{"TRABUCO", 7, 136536},
	{"TRABEL", 6, 221610},
	{"TRABECULAR", 10, 153551},
	{"TRABANT", 7, 178168},
	{"TRABALHOS", 9, 183880},
	{"TRABALHO", 8, 147929},
	{"TRABALHADORES", 13, 210968},
	{"TRABALHADOR", 11, 248749},
	{"TRABAJOS", 8, 132241},
	{"TRABAJO", 7, 75038},
	{"TRABAJAR", 8, 188759},
	{"TRABAJADORES", 12, 147778},
	{"TRABAJADOR", 10, 257626},
	{"TRAADOL", 7, 218850},
	{"TQWE", 4, 189402},
	{"TQUO", 4, 80664},
	{"TQUI", 4, 36877},
	{"TQUE", 4, 42597},
	{"TQUA", 4, 32129},
	{"TQU", 3, 817},
	{"TQFP", 4, 163012},
	{"TQB", 3, 34221},
	{"TPYR", 4, 161450},
	{"TPYO", 4, 260456},
	{"TPWW", 4, 62681},
	{"TPWH", 4, 259655},
	{"TPWD", 4, 202436},
	{"TPWA", 4, 260054},
	{"TPUZ", 4, 155426},
	{"TPUS", 4, 62110},
	{"TPUR", 4, 45091},
	{"TPUP", 4, 110277},
	{"TPUN", 4, 58560},
	{"TPUM", 4, 85901},
	{"TPUL", 4, 58502},
	{"TPUJ", 4, 129483},
	{"TPUG", 4, 224875},
	{"TPUE", 4, 153129},
	{"TPUD", 4, 238769},
	{"TPUC", 4, 196774},
	{"TPUB", 4, 37171},
	{"TPTP", 4, 163368},
	{"TPTL", 4, 246809},
	{"TPSY", 4, 87835},
	{"TPSU", 4, 254231},
	{"TPRY", 4, 239595},
	{"TPRU", 4, 111276},
	{"TPRI", 4, 28218},
	{"TPRE", 4, 6791},
	{"TPRA", 4, 42657},
	{"TPPR", 4, 207360},
	{"TPPG", 4, 248494},
	{"TPPE", 4, 251154},
	{"TPPA", 4, 218171},
	{"TPOW", 4, 39131},
	{"TPOV", 4, 112320},
	{"TPOU", 4, 47318},
	{"TPOR", 4, 40529},
	{"TPOP", 4, 36765},
	{"TPOM", 4, 138304},
	{"TPOL", 4, 30990},
	{"TPOK", 4, 121691},
	{"TPOI", 4, 30542},
	{"TPOD", 4, 124190},
	{"TPOC", 4, 101454},
	{"TPOB", 4, 252497},
	{"TPMY", 4, 251155},
	{"TPMW", 4, 75663},
	{"TPMU", 4, 156114},
	{"TPMS", 4, 206827},
	{"TPMR", 4, 150731},
	{"TPMP", 4, 110773},
	{"TPMO", 4, 58941},
	{"TPMN", 4, 135682},
	{"TPMM", 4, 83841},
	{"TPML", 4, 152137},
	{"TPMJ", 4, 113422},
	{"TPMI", 4, 72340},
	{"TPMH", 4, 152259},
	{"TPMG", 4, 205023},
	{"TPMF", 4, 71951},
	{"TPME", 4, 77813},
	{"TPMD", 4, 131036},
	{"TPMCAFE", 7, 166409},
	{"TPMB", 4, 120739},
	{"TPMA", 4, 47542},
	{"TPLY", 4, 134729},
	{"TPLU", 4, 58148},
	{"TPLO", 4, 93851},
	{"TPLI", 4, 201067},
	{"TPLE", 4, 48693},
	{"TPLA", 4, 4038},
	{"TPKE", 4, 144512},
	{"TPIZ", 4, 136288},
	{"TPIXEL", 6, 258360},
	{"TPIX", 4, 176771},
	{"TPIV", 4, 220807},
	{"TPIU", 4, 188295},
	{"TPIR", 4, 100075},
	{"TPIP", 4, 95035},
	{"TPIM", 4, 171479},
	{"TPIL", 4, 62485},
	{"TPIK", 4, 168187},
	{"TPIG", 4, 122486},
	{"TPICD", 5, 84884},
	{"TPIC", 4, 39360},
	{"TPHY", 4, 62392},
	{"TPHR", 4, 122487},
	{"TPHCM", 5, 167460},
	{"TPGA", 4, 252634},
	{"TPFO", 4, 236736},
	{"TPFI", 4, 223537},
	{"TPEY", 4, 207001},
	{"TPER", 4, 4711},
	{"TPEP", 4, 95840},
	{"TPEO", 4, 8336},
	{"TPEM", 4, 192345},
	{"TPEL", 4, 90532},
	{"TPEK", 4, 249779},
	{"TPEG", 4, 145524},
	{"TPED", 4, 91488},
	{"TPEC", 4, 140372},
	{"TPEB", 4, 132020},
	{"TPDU", 4, 195318},
	{"TPDF", 4, 185104},
	{"TPCO", 4, 169995},
	{"TPCL", 4, 254607},
	{"TPCI", 4, 223993},
	{"TPCB", 4, 256344},
	{"TPBS", 4, 190705},
	{"TPBI", 4, 225991},
	{"TPAY", 4, 38282},
	{"TPAW", 4, 145525},
	{"TPAV", 4, 100731},
	{"TPAU", 4, 46072},
	{"TPAR", 4, 5589},
	{"TPAP", 4, 59059},
	{"TPAM", 4, 132588},
	{"TPAL", 4, 51046},
	{"TPAK", 4, 79120},
	{"TPAG", 4, 53729},
	{"TPAD", 4, 261536},
	{"TPAB", 4, 237685},
	{"TOZZI", 5, 236200},
	{"TOZZ", 4, 198070},
	{"TOZU", 4, 173063},
	{"TOZER", 5, 147065},
	{"TOYZ", 4, 132690},
	{"TOYU", 4, 94439},
	{"TOYTOWN", 7, 254186},
	{"TOYSRUS", 7, 179833},
	{"TOYSHOP", 7, 258661},
	{"TOYSCAMP", 8, 259520},
	{"TOYS", 4, 1655},
	{"TOYRKIAS", 8, 200319},
	{"TOYRKIA", 7, 170319},
	{"TOYR", 4, 182638},
	{"TOYP", 4, 184857},
	{"TOYOTAS", 7, 181949},
	{"TOYOTA", 6, 7262},
	{"TOYODA", 6, 173331},
	{"TOYNE", 5, 180418},
	{"TOYNBEE", 7, 147117},
	{"TOYNAMI", 7, 228809},
	{"TOYMAKER", 8, 219201},
	{"TOYM", 4, 140575},
	{"TOYLAND", 7, 111159},
	{"TOYL", 4, 128266},
	{"TOYING", 6, 55702},
	{"TOYG", 4, 217269},
	{"TOYFARE", 7, 206753},
	{"TOYF", 4, 164465},
	{"TOYED", 5, 132572},
	{"TOYBOX", 6, 132662},
	{"TOYB", 4, 144733},
	{"TOYAMA", 6, 117222},
	{"TOYAH", 5, 206768},
	{"TOXY", 4, 159256},
	{"TOXX", 4, 145270},
	{"TOXTETH", 7, 231209},
	{"TOXR", 4, 252498},
	{"TOXP", 4, 218875},
	{"TOXOPLASMOSIS", 13, 118981},
	{"TOXOPLASMA", 10, 130613},
	{"TOXOID", 6, 146060},
	{"TOXNET", 6, 163927},
	{"TOXM", 4, 239596},
	{"TOXINS", 6, 51686},
	{"TOXINE", 6, 261076},
	{"TOXIN", 5, 53424},
	{"TOXICS", 6, 71853},
	{"TOXICOLOGY", 10, 47509},
	{"TOXICOLOGISTS", 13, 208197},
	{"TOXICOLOGIST", 12, 155707},
	{"TOXICOLOGICAL", 13, 76714},
	{"TOXICOLOGIC", 11, 232607},
	{"TOXICOL", 7, 84002},
	{"TOXICOGENOMICS", 14, 251404},
	{"TOXICITY", 8, 37263},
	{"TOXICITIES", 10, 132450},
	{"TOXICANTS", 9, 140307},
	{"TOXICANT", 8, 170937},
	{"TOXIC", 5, 32123},
	{"TOXF", 4, 87713},
	{"TOXEMIA", 7, 196260},
	{"TOXC", 4, 194666},
	{"TOXB", 4, 214220},
	{"TOXAPHENE", 9, 200271},
	{"TOWY", 4, 154448},
	{"TOWW", 4, 70122},
	{"TOWV", 4, 232956},
	{"TOWU", 4, 181344},
	{"TOWSON", 6, 65867},
	{"TOWSLEY", 7, 236168},
	{"TOWR", 4, 37023},
	{"TOWPATH", 7, 166120},
	{"TOWP", 4, 152392},
	{"TOWO", 4, 6237},
	{"TOWNSVILLE", 10, 61188},
	{"TOWNSQUARE", 10, 188101},
	{"TOWNSPEOPLE", 11, 113522},
	{"TOWNSON", 7, 189844},
	{"TOWNSMEN", 8, 145189},
	{"TOWNSMAN", 8, 227437},
	{"TOWNSLEY", 8, 176595},
	{"TOWNSITE", 8, 159560},
	{"TOWNSHIPS", 9, 66940},
	{"TOWNSHIP", 8, 9645},
	{"TOWNSHEND", 9, 88888},
	{"TOWNSFOLK", 9, 156985},
	{"TOWNSEND", 8, 42974},
	{"TOWNSCAPE", 9, 185074},
	{"TOWNS", 5, 8476},
	{"TOWNPLACE", 9, 185837},
	{"TOWNLEY", 7, 137119},
	{"TOWNLAND", 8, 157432},
	{"TOWNIES", 7, 214075},
	{"TOWNIE", 6, 232839},
	{"TOWNHOUSES", 10, 61397},
	{"TOWNHOUSE", 9, 48215},
	{"TOWNHOMES", 9, 60492},
	{"TOWNHOME", 8, 83728},
	{"TOWNHALL", 8, 76646},
	{"TOWNES", 6, 96958},
	{"TOWNERS", 7, 164841},
	{"TOWNER", 6, 123529},
	{"TOWNEPLACE", 10, 93293},
	{"TOWNEND", 7, 191131},
	{"TOWNE", 5, 65025},
	{"TOWNCAR", 7, 238641},
	{"TOWN", 4, 1688},
	{"TOWM", 4, 172063},
	{"TOWLES", 6, 250590},
	{"TOWLEROAD", 9, 173471},
	{"TOWLER", 6, 239510},
	{"TOWLE", 5, 96518},
	{"TOWL", 4, 122814},
	{"TOWING", 6, 42399},
	{"TOWI", 4, 5877},
	{"TOWHEE", 6, 170873},
	{"TOWH", 4, 8545},
	{"TOWF", 4, 200741},
	{"TOWERTALK", 9, 81222},
	{"TOWERSTREAM", 11, 197387},
	{"TOWERS", 6, 31784},
	{"TOWERRECORDS", 12, 200942},
	{"TOWERING", 8, 66670},
	{"TOWERGROUP", 10, 205285},
	{"TOWERED", 7, 165010},
	{"TOWER", 5, 7605},
	{"TOWELS", 6, 38362},
	{"TOWELLING", 9, 175342},
	{"TOWELL", 6, 242158},
	{"TOWELING", 8, 229553},
	{"TOWELETTES", 10, 175693},
	{"TOWEL", 5, 30185},
	{"TOWED", 5, 72887},
	{"TOWD", 4, 254608},
	{"TOWCESTER", 9, 154558},
	{"TOWC", 4, 148220},
	{"TOWBOAT", 7, 245184},
	{"TOWBARS", 7, 174208},
	{"TOWBAR", 6, 145065},
	{"TOWB", 4, 161613},
	{"TOWARDS", 7, 6032},
	{"TOWARD", 6, 1408},
	{"TOWANDA", 7, 130866},
	{"TOWAGE", 6, 251132},
	{"TOWABLES", 8, 245668},
	{"TOWABLE", 7, 176093},
	{"TOVW", 4, 195406},
	{"TOVU", 4, 195407},
	{"TOVR", 4, 189403},
	{"TOVM", 4, 254928},
	{"TOVL", 4, 179329},
	{"TOVI", 4, 31707},
	{"TOVEY", 5, 180851},
	{"TOVC", 4, 164657},
	{"TOVAR", 5, 148563},
	{"TOUZ", 4, 248819},
	{"TOUX", 4, 226501},
	{"TOUW", 4, 196775},
	{"TOUTS", 5, 82261},
	{"TOUTPUTIMAGE", 12, 77165},
	{"TOUTPUT", 7, 259340},
	{"TOUTLE", 6, 219274},
	{"TOUTING", 7, 96440},
	{"TOUTES", 6, 71420},
	{"TOUTEFOIS", 9, 198831},
	{"TOUTED", 6, 70917},
	{"TOUTE", 5, 78481},
	{"TOUSSAINT", 9, 103975},
	{"TOUSLED", 7, 234653},
	{"TOUSE", 5, 215708},
	{"TOURVILLE", 9, 223157},
	{"TOURTURE", 8, 223147},
	{"TOURS", 5, 3343},
	{"TOURO", 5, 145952},
	{"TOURNY", 6, 185688},
	{"TOURNIQUET", 10, 112934},
	{"TOURNIER", 8, 249313},
	{"TOURNEYS", 8, 117978},
	{"TOURNEY", 7, 57750},
	{"TOURNEMENT", 10, 248981},
	{"TOURNEAU", 8, 173133},
	{"TOURNAMENTS", 11, 32118},
	{"TOURNAMENT", 10, 8267},
	{"TOURNAI", 7, 191279},
	{"TOURNAGE", 8, 221187},
	{"TOURNA", 6, 229653},
	{"TOURN", 5, 133671},
	{"TOURMALINE", 10, 68501},
	{"TOURISTY", 8, 131507},
	{"TOURISTS", 8, 36674},
	{"TOURISTIQUES", 12, 129158},
	{"TOURISTIQUE", 11, 196351},
	{"TOURISTINFORMATION", 18, 217470},
	{"TOURISTIC", 9, 109745},
	{"TOURISTER", 9, 175107},
	{"TOURIST", 7, 7628},
	{"TOURISMUS", 9, 121504},
	{"TOURISME", 8, 77025},
	{"TOURISM", 7, 34795},
	{"TOURING", 7, 35324},
	{"TOURETTES", 9, 196504},
	{"TOURETTE", 8, 99922},
	{"TOURERS", 7, 208874},
	{"TOURER", 6, 109940},
	{"TOUREN", 6, 209232},
	{"TOURED", 6, 62727},
	{"TOURE", 5, 144836},
	{"TOURDATES", 9, 168439},
	{"TOURCAST", 8, 208199},
	{"TOURBILLON", 10, 241369},
	{"TOURAN", 6, 219909},
	{"TOURAINE", 8, 201631},
	{"TOUR", 4, 4475},
	{"TOUQUET", 7, 177348},
	{"TOUPPER", 7, 180929},
	{"TOUPEES", 7, 219930},
	{"TOUPEE", 6, 158682},
	{"TOUP", 4, 47719},
	{"TOUNGE", 6, 120467},
	{"TOUM", 4, 89437},
	{"TOULOUSE", 8, 49373},
	{"TOULON", 6, 96207},
	{"TOULMIN", 7, 230655},
	{"TOUK", 4, 117481},
	{"TOUJOURS", 8, 94835},
	{"TOUHY", 5, 234682},
	{"TOUGHT", 6, 158564},
	{"TOUGHNESS", 9, 75943},
	{"TOUGHEST", 8, 58199},
	{"TOUGHER", 7, 54039},
	{"TOUGHENING", 10, 204441},
	{"TOUGHENED", 9, 130956},
	{"TOUGHEN", 7, 149089},
	{"TOUGHBOOK", 9, 79171},
	{"TOUGH", 5, 2992},
	{"TOUGALOO", 8, 251523},
	{"TOUG", 4, 9165},
	{"TOUF", 4, 157316},
	{"TOUD", 4, 92617},
	{"TOUCHY", 6, 88359},
	{"TOUCHTONE", 9, 178364},
	{"TOUCHSYSTEMS", 12, 203927},
	{"TOUCHSTONES", 11, 211588},
	{"TOUCHSTONE", 10, 68782},
	{"TOUCHSTAR", 9, 185948},
	{"TOUCHSCREENS", 12, 170667},
	{"TOUCHSCREEN", 11, 69449},
	{"TOUCHPOINT", 10, 115125},
	{"TOUCHPAD", 8, 87531},
	{"TOUCHMAN", 8, 244704},
	{"TOUCHLINE", 9, 165212},
	{"TOUCHLESS", 9, 261404},
	{"TOUCHING", 8, 38571},
	{"TOUCHIN", 7, 232151},
	{"TOUCHEZ", 7, 260034},
	{"TOUCHET", 7, 255242},
	{"TOUCHES", 7, 42839},
	{"TOUCHER", 7, 249025},
	{"TOUCHED", 7, 36562},
	{"TOUCHE", 6, 61691},
	{"TOUCHDOWNS", 10, 66452},
	{"TOUCHDOWN", 9, 31658},
	{"TOUCHBACK", 9, 192574},
	{"TOUCHABLE", 9, 235834},
	{"TOUCH", 5, 3372},
	{"TOUCANS", 7, 211706},
	{"TOUCAN", 6, 93531},
	{"TOUCAM", 6, 193835},
	{"TOUBY", 5, 243716},
	{"TOUAREG", 7, 97697},
	{"TOTURE", 6, 259888},
	{"TOTU", 4, 36085},
	{"TOTTY", 5, 165856},
	{"TOTTORI", 7, 173666},
	{"TOTTON", 6, 195818},
	{"TOTTINGTON", 10, 258675},
	{"TOTTERING", 9, 184875},
	{"TOTTERIDGE", 10, 229848},
	{"TOTTERED", 8, 204551},
	{"TOTTER", 6, 187120},
	{"TOTTENHAM", 9, 61124},
	{"TOTTEN", 6, 92531},
	{"TOTR", 4, 5928},
	{"TOTOWA", 6, 142091},
	{"TOTORO", 6, 119873},
	{"TOTNES", 6, 120440},
	{"TOTING", 6, 108586},
	{"TOTESPORT", 9, 150561},
	{"TOTEMS", 6, 135086},
	{"TOTEMIC", 7, 252359},
	{"TOTEM", 5, 62807},
	{"TOTARA", 6, 231518},
	{"TOTALY", 6, 96386},
	{"TOTALVOL", 8, 244137},
	{"TOTALVIEW", 9, 197354},
	{"TOTALTRIP", 9, 203431},
	{"TOTALTRAVEL", 11, 199947},
	{"TOTALSTORAGE", 12, 128739},
	{"TOTALS", 6, 28402},
	{"TOTALMENTE", 10, 98424},
	{"TOTALLY", 7, 5918},
	{"TOTALLING", 9, 70065},
	{"TOTALLED", 8, 91294},
	{"TOTALJOBS", 9, 142980},
	{"TOTALIZING", 10, 219169},
	{"TOTALIZER", 9, 212737},
	{"TOTALITY", 8, 72666},
	{"TOTALITARIANISM", 15, 95057},
	{"TOTALITARIAN", 12, 75276},
	{"TOTALISATOR", 11, 243832},
	{"TOTALING", 8, 50806},
	{"TOTALI", 6, 188668},
	{"TOTALFINAELF", 12, 237259},
	{"TOTALEMENT", 10, 174129},
	{"TOTALED", 7, 57207},
	{"TOTALE", 6, 120309},
	{"TOTALCHOICE", 11, 151980},
	{"TOTALBET", 8, 138733},
	{"TOTAL", 5, 3061},
	{"TOTAAL", 6, 113264},
	{"TOSU", 4, 5557},
	{"TOSTRING", 8, 55875},
	{"TOSSING", 7, 65754},
	{"TOSSES", 6, 95190},
	{"TOSSED", 6, 49822},
	{"TOSP", 4, 7456},
	{"TOSLINK", 7, 110767},
	{"TOSKANA", 7, 88367},
	{"TOSHIYUKI", 9, 152888},
	{"TOSHIYA", 7, 256592},
	{"TOSHIRO", 7, 180140},
	{"TOSHIO", 6, 139191},
	{"TOSHIKO", 7, 255127},
	{"TOSHIHIRO", 9, 216226},
	{"TOSHIHIKO", 9, 233966},
	{"TOSHIBA", 7, 6335},
	{"TOSHIAKI", 8, 208099},
	{"TOSFEATURES", 11, 146911},
	{"TOSELAND", 8, 212876},
	{"TOSCO", 5, 254852},
	{"TOSCHI", 6, 236608},
	{"TOSCANO", 7, 133738},
	{"TOSCANINI", 9, 180973},
	{"TOSCANA", 7, 77453},
	{"TOSCA", 5, 86167},
	{"TOSATTI", 7, 212499},
	{"TORZ", 4, 134937},
	{"TORY", 4, 48625},
	{"TORX", 4, 100972},
	{"TORW", 4, 29384},
	{"TORVALDS", 8, 59228},
	{"TORVALD", 7, 259181},
	{"TORV", 4, 49044},
	{"TORUS", 5, 79933},
	{"TORUN", 5, 167581},
	{"TORU", 4, 119927},
	{"TORTUROUS", 9, 161758},
	{"TORTURING", 9, 82285},
	{"TORTURES", 8, 103319},
	{"TORTURERS", 9, 157514},
	{"TORTURER", 8, 180746},
	{"TORTURED", 8, 45990},
	{"TORTURE", 7, 9140},
	{"TORTURA", 7, 120827},
	{"TORTUOUS", 8, 124306},
	{"TORTUGUERO", 10, 188475},
	{"TORTUGAS", 8, 125820},
	{"TORTUGA", 7, 103455},
	{"TORTUE", 6, 211605},
	{"TORTS", 5, 68074},
	{"TORTOSA", 7, 259105},
	{"TORTORA", 7, 226067},
	{"TORTOR", 6, 224319},
	{"TORTOLA", 7, 90799},
	{"TORTOISESVN", 11, 165703},
	{"TORTOISESHELL", 13, 175295},
	{"TORTOISES", 9, 110517},
	{"TORTOISE", 8, 59044},
	{"TORTIOUS", 8, 122556},
	{"TORTILLAS", 9, 83096},
	{"TORTILLA", 8, 67760},
	{"TORTIE", 6, 238397},
	{"TORTICOLLIS", 11, 223842},
	{"TORTFEASOR", 10, 211719},
	{"TORTELLINI", 10, 123319},
	{"TORTE", 5, 129793},
	{"TORTA", 5, 163342},
	{"TORSTEN", 7, 90419},
	{"TORSTEIN", 8, 203887},
	{"TORSOS", 6, 201305},
	{"TORSO", 5, 50352},
	{"TORSIONAL", 9, 113164},
	{"TORSION", 7, 65633},
	{"TORSDAG", 7, 172433},
	{"TORRY", 5, 138848},
	{"TORRUS", 6, 247538},
	{"TORROX", 6, 157935},
	{"TORRINI", 7, 154486},
	{"TORRINGTON", 10, 80212},
	{"TORRIE", 6, 84283},
	{"TORRIDON", 8, 257882},
	{"TORRIDGE", 8, 194862},
	{"TORRID", 6, 107687},
	{"TORRICELLI", 10, 143354},
	{"TORRI", 5, 121301},
	{"TORREZ", 6, 226630},
	{"TORREY", 6, 73050},
	{"TORREVIEJA", 10, 90887},
	{"TORRES", 6, 44484},
	{"TORREQUEBRADA", 13, 210537},
	{"TORREON", 7, 190152},
	{"TORRENTY", 8, 203359},
	{"TORRENTSPY", 10, 248316},
	{"TORRENTS", 8, 52235},
	{"TORRENTPORTAL", 13, 255914},
	{"TORRENTIAL", 10, 116051},
	{"TORRENTE", 8, 143699},
	{"TORRENT", 7, 37775},
	{"TORRENS", 7, 116819},
	{"TORRENCE", 8, 150381},
	{"TORREMUELLE", 11, 255510},
	{"TORREMOLINOS", 12, 98470},
	{"TORRE", 5, 59526},
	{"TORRANCE", 8, 55701},
	{"TORR", 4, 93249},
	{"TORQUES", 7, 150263},
	{"TORQUEMADA", 10, 225730},
	{"TORQUE", 6, 38310},
	{"TORQUAY", 7, 61407},
	{"TORQ", 4, 166939},
	{"TORPOR", 6, 165096},
	{"TORPOINT", 8, 202557},
	{"TORPEDOES", 9, 108536},
	{"TORPEDOED", 9, 172472},
	{"TORPEDO", 7, 62585},
	{"TORP", 4, 173672},
	{"TOROS", 5, 137299},
	{"TORONTO", 7, 4103},
	{"TORONADO", 8, 182000},
	{"TOROKHOV", 8, 256768},
	{"TOROK", 5, 245021},
	{"TOROIDS", 7, 235698},
	{"TOROIDAL", 8, 100543},
	{"TOROID", 6, 177113},
	{"TORNO", 5, 242152},
	{"TORNILLO", 8, 215574},
	{"TORNEO", 6, 174726},
	{"TORNEI", 6, 221669},
	{"TORNE", 5, 222326},
	{"TORNADOS", 8, 120660},
	{"TORNADOES", 9, 72168},
	{"TORNADO", 7, 44599},
	{"TORNA", 5, 114270},
	{"TORMOD", 6, 178267},
	{"TORMENTS", 8, 124300},
	{"TORMENTORS", 10, 193991},
	{"TORMENTOR", 9, 143994},
	{"TORMENTING", 10, 146497},
	{"TORMENTED", 9, 82548},
	{"TORMENTA", 8, 203757},
	{"TORMENT", 7, 66001},
	{"TORMEN", 6, 252682},
	{"TORME", 5, 163468},
	{"TORL", 4, 43803},
	{"TORK", 4, 167289},
	{"TORJ", 4, 44979},
	{"TORINO", 6, 45701},
	{"TORING", 6, 179511},
	{"TORIN", 5, 187126},
	{"TORII", 5, 148940},
	{"TORIES", 6, 60447},
	{"TORIE", 5, 250666},
	{"TORICAL", 7, 252659},
	{"TORIC", 5, 71211},
	{"TORGERSON", 9, 201511},
	{"TORGEIR", 7, 243559},
	{"TORG", 4, 146398},
	{"TORFAEN", 7, 108032},
	{"TORF", 4, 32855},
	{"TOREY", 5, 223007},
	{"TOREX", 5, 214468},
	{"TOREROS", 7, 243217},
	{"TORERO", 6, 240595},
	{"TOREN", 5, 196513},
	{"TORELLI", 7, 219564},
	{"TOREADOR", 8, 143934},
	{"TOREAD", 6, 178612},
	{"TORD", 4, 216188},
	{"TORCS", 5, 174687},
	{"TORCHLIGHT", 10, 141191},
	{"TORCHING", 8, 183070},
	{"TORCHIERES", 10, 180172},
	{"TORCHIERE", 9, 129933},
	{"TORCHES", 7, 59883},
	{"TORCHED", 7, 139173},
	{"TORCH", 5, 41103},
	{"TORC", 4, 183196},
	{"TORBOLE", 7, 199398},
	{"TORBJORN", 8, 237954},
	{"TORBERT", 7, 243451},
	{"TORBEN", 6, 132602},
	{"TORBAY", 6, 84188},
	{"TORB", 4, 35648},
	{"TORAY", 5, 167358},
	{"TORANO", 6, 181098},
	{"TORANI", 6, 217542},
	{"TORAND", 6, 253423},
	{"TORANA", 6, 190716},
	{"TORAL", 5, 179792},
	{"TORAH", 5, 43878},
	{"TOQUES", 6, 81231},
	{"TOQUE", 5, 129426},
	{"TOQU", 4, 36469},
	{"TOPXML", 6, 216771},
	{"TOPWRITE", 8, 232290},
	{"TOPW", 4, 47122},
	{"TOPV", 4, 99883},
	{"TOPUP", 5, 247941},
	{"TOPU", 4, 5833},
	{"TOPTOP", 6, 99806},
	{"TOPTON", 6, 235635},
	{"TOPTEN", 6, 158004},
	{"TOPSY", 5, 105833},
	{"TOPSTYLE", 8, 229297},
	{"TOPSPIN", 7, 163962},
	{"TOPSOIL", 7, 90172},
	{"TOPSITES", 8, 59714},
	{"TOPSITE", 7, 95922},
	{"TOPSIDE", 7, 131467},
	{"TOPSHOP", 7, 122938},
	{"TOPSHAM", 7, 128892},
	{"TOPSFIELD", 9, 128654},
	{"TOPSELLERS", 10, 203657},
	{"TOPSELLER", 9, 188544},
	{"TOPSAIL", 7, 129810},
	{"TOPS", 4, 9422},
	{"TOPROL", 6, 157868},
	{"TOPR", 4, 2662},
	{"TOPQ", 4, 117041},
	{"TOPPS", 5, 49910},
	{"TOPPLING", 8, 106561},
	{"TOPPLES", 7, 56231},
	{"TOPPLED", 7, 100431},
	{"TOPPLE", 6, 95434},
	{"TOPPINGS", 8, 85405},
	{"TOPPING", 7, 54268},
	{"TOPPERS", 7, 66817},
	{"TOPPER", 6, 59362},
	{"TOPPEN", 6, 201520},
	{"TOPPED", 6, 45738},
	{"TOPPAGE", 7, 257293},
	{"TOPP", 4, 113502},
	{"TOPOZONE", 8, 127300},
	{"TOPOTECAN", 9, 218284},
	{"TOPOS", 5, 150016},
	{"TOPOLOGY", 8, 41154},
	{"TOPOLOGIES", 10, 82260},
	{"TOPOLOGICALLY", 13, 144229},
	{"TOPOLOGICAL", 11, 59444},
	{"TOPOL", 5, 153835},
	{"TOPOISOMERASES", 14, 228013},
	{"TOPOISOMERASE", 13, 114127},
	{"TOPOINDEX", 9, 236693},
	{"TOPOGRAPHY", 10, 52766},
	{"TOPOGRAPHIES", 12, 260361},
	{"TOPOGRAPHICALLY", 15, 249732},
	{"TOPOGRAPHICAL", 13, 77486},
	{"TOPOGRAPHIC", 11, 51283},
	{"TOPOFF", 6, 199500},
	{"TOPOCK", 6, 252469},
	{"TOPNOTCH", 8, 171734},
	{"TOPNEWS", 7, 237192},
	{"TOPMOST", 7, 106440},
	{"TOPMARGIN", 9, 234671},
	{"TOPM", 4, 34357},
	{"TOPLOADER", 9, 150302},
	{"TOPLOAD", 7, 154848},
	{"TOPLISTS", 8, 156209},
	{"TOPLIST", 7, 72575},
	{"TOPLINKS", 8, 255908},
	{"TOPLINK", 7, 213192},
	{"TOPLINE", 7, 131870},
	{"TOPLEY", 6, 230501},
	{"TOPLEVEL", 8, 110806},
	{"TOPLAYER", 8, 180723},
	{"TOPL", 4, 5033},
	{"TOPKAPI", 7, 170524},
	{"TOPK", 4, 106842},
	{"TOPJOBS", 7, 144781},
	{"TOPJ", 4, 85843},
	{"TOPIX", 5, 93791},
	{"TOPIRAMATE", 10, 162571},
	{"TOPINKA", 7, 236201},
	{"TOPICZ", 6, 232355},
	{"TOPICSWATCHED", 13, 216132},
	{"TOPICSACTIVE", 12, 125506},
	{"TOPICS", 6, 1577},
	{"TOPICPARENT", 11, 86124},
	{"TOPICNAME", 9, 183346},
	{"TOPICMOVED", 10, 113898},
	{"TOPICMAPMAIL", 12, 221467},
	{"TOPICLIST", 9, 101253},
	{"TOPICINFO", 9, 154229},
	{"TOPICCLASSIFICATION", 19, 134321},
	{"TOPICALS", 8, 188270},
	{"TOPICALLY", 9, 123848},
	{"TOPICALITY", 10, 200505},
	{"TOPICAL", 7, 38137},
	{"TOPICACTION", 11, 251885},
	{"TOPICA", 6, 99254},
	{"TOPIC", 5, 5432},
	{"TOPIARY", 7, 92728},
	{"TOPIARIES", 9, 191914},
	{"TOPIA", 5, 238579},
	{"TOPHOMES", 8, 210836},
	{"TOPHER", 6, 136844},
	{"TOPHAT", 6, 222600},
	{"TOPHAM", 6, 189922},
	{"TOPGUN", 6, 217544},
	{"TOPGEAR", 7, 247688},
	{"TOPG", 4, 58508},
	{"TOPFIELD", 8, 148091},
	{"TOPEX", 5, 117570},
	{"TOPER", 5, 248414},
	{"TOPEKA", 6, 49303},
	{"TOPED", 5, 260543},
	{"TOPEAK", 6, 117907},
	{"TOPDOG", 6, 231395},
	{"TOPDIR", 6, 189870},
	{"TOPD", 4, 51331},
	{"TOPCON", 6, 177041},
	{"TOPCODER", 8, 179731},
	{"TOPCOATS", 8, 249306},
	{"TOPCOAT", 7, 138624},
	{"TOPCO", 5, 152126},
	{"TOPCAT", 6, 221549},
	{"TOPC", 4, 43084},
	{"TOPBAND", 7, 115640},
	{"TOPBACK", 7, 134012},
	{"TOPB", 4, 45661},
	{"TOPAZES", 7, 250046},
	{"TOPAZ", 5, 45934},
	{"TOPAS", 5, 199985},
	{"TOPANGA", 7, 81114},
	{"TOPAMAX", 7, 108273},
	{"TOPALOV", 7, 201710},
	{"TOPAD", 5, 254144},
	{"TOP", 3, 2153},
	{"TOOWOOMBA", 9, 75680},
	{"TOOWONG", 7, 197036},
	{"TOOU", 4, 33799},
	{"TOOTSIES", 8, 165312},
	{"TOOTSIE", 7, 97435},
	{"TOOTING", 7, 105334},
	{"TOOTIN", 6, 235944},
	{"TOOTIE", 6, 231286},
	{"TOOTHY", 6, 173970},
	{"TOOTHPICKS", 10, 119769},
	{"TOOTHPICK", 9, 94751},
	{"TOOTHPASTES", 11, 181373},
	{"TOOTHPASTE", 10, 63652},
	{"TOOTHLESS", 9, 114401},
	{"TOOTHFISH", 9, 238179},
	{"TOOTHED", 7, 94699},
	{"TOOTHBRUSHES", 12, 85101},
	{"TOOTHBRUSH", 10, 59992},
	{"TOOTHACHE", 9, 119299},
	{"TOOTH", 5, 5455},
	{"TOORAK", 6, 162671},
	{"TOORA", 5, 236135},
	{"TOONZ", 5, 225027},
	{"TOONTOWN", 8, 188268},
	{"TOONGABBIE", 10, 221764},
	{"TOOND", 5, 250783},
	{"TOONAMI", 7, 217891},
	{"TOOMS", 5, 239272},
	{"TOOMEY", 6, 101760},
	{"TOOMER", 6, 172239},
	{"TOOMBS", 6, 153206},
	{"TOOLZ", 5, 208618},
	{"TOOLTIPS", 8, 112851},
	{"TOOLTIP", 7, 81672},
	{"TOOLTALK", 8, 192202},
	{"TOOLSTATION", 11, 170520},
	{"TOOLSHED", 8, 157746},
	{"TOOLSHAND", 9, 244669},
	{"TOOLSETS", 8, 211321},
	{"TOOLSET", 7, 79499},
	{"TOOLS", 5, 1116},
	{"TOOLROOM", 8, 183268},
	{"TOOLMIX", 7, 243796},
	{"TOOLMAKING", 10, 252113},
	{"TOOLMAKERS", 10, 202528},
	{"TOOLKITS", 8, 71012},
	{"TOOLKIT", 7, 36248},
	{"TOOLING", 7, 54945},
	{"TOOLEY", 6, 152365},
	{"TOOLED", 6, 73463},
	{"TOOLE", 5, 104980},
	{"TOOLCHAIN", 9, 105722},
	{"TOOLBOXES", 9, 139250},
	{"TOOLBOX", 7, 31476},
	{"TOOLBOOK", 8, 168222},
	{"TOOLBARS", 8, 69174},
	{"TOOLBAR", 7, 9001},
	{"TOOL", 4, 3820},
	{"TOOKIE", 6, 94459},
	{"TOOKER", 6, 255966},
	{"TOOKE", 5, 208480},
	{"TOOK", 4, 2052},
	{"TOOHEY", 6, 159745},
	{"TOOGOOD", 7, 243678},
	{"TOOGLE", 6, 195890},
	{"TOOF", 4, 29651},
	{"TOOELE", 6, 103233},
	{"TOODLES", 7, 217992},
	{"TOOD", 4, 29834},
	{"TOOBIN", 6, 184948},
	{"TONYS", 5, 177330},
	{"TONYA", 5, 71275},
	{"TONY", 4, 5076},
	{"TONW", 4, 9394},
	{"TONURI", 6, 197976},
	{"TONT", 4, 3081},
	{"TONSILS", 7, 120436},
	{"TONSILLITIS", 11, 148826},
	{"TONSILLECTOMY", 13, 170261},
	{"TONSIL", 6, 137673},
	{"TONR", 4, 34823},
	{"TONP", 4, 32564},
	{"TONOWANDA", 9, 140335},
	{"TONOPAH", 7, 142491},
	{"TONNY", 5, 197250},
	{"TONNES", 6, 43367},
	{"TONNER", 6, 133704},
	{"TONNEAU", 7, 76707},
	{"TONNAGES", 8, 241946},
	{"TONNAGE", 7, 70040},
	{"TONM", 4, 31354},
	{"TONLE", 5, 219234},
	{"TONL", 4, 5405},
	{"TONKS", 5, 132607},
	{"TONKINESE", 9, 247007},
	{"TONKIN", 6, 102675},
	{"TONKAWA", 7, 216730},
	{"TONKA", 5, 89248},
	{"TONITE", 6, 87173},
	{"TONISE", 6, 165009},
	{"TONINO", 6, 140747},
	{"TONING", 6, 70768},
	{"TONIGHTS", 8, 153423},
	{"TONIGHT", 7, 2568},
	{"TONICS", 6, 131531},
	{"TONIC", 5, 54803},
	{"TONGUING", 8, 222835},
	{"TONGUES", 7, 55128},
	{"TONGUED", 7, 90773},
	{"TONGUE", 6, 8891},
	{"TONGS", 5, 78658},
	{"TONGRO", 6, 155607},
	{"TONGKAT", 7, 216740},
	{"TONGJI", 6, 252399},
	{"TONGEREN", 8, 228772},
	{"TONGE", 5, 155329},
	{"TONGASS", 7, 149495},
	{"TONGARIRO", 9, 176954},
	{"TONGANOXIE", 10, 179824},
	{"TONGAN", 6, 126123},
	{"TONGA", 5, 37108},
	{"TONF", 4, 34545},
	{"TONEY", 5, 101590},
	{"TONEXPRESS", 10, 173415},
	{"TONES", 5, 8454},
	{"TONERS", 6, 59597},
	{"TONER", 5, 28272},
	{"TONELLI", 7, 248905},
	{"TONED", 5, 63086},
	{"TONECLUSTER", 11, 256267},
	{"TONEARM", 7, 208254},
	{"TOND", 4, 33051},
	{"TONC", 4, 7416},
	{"TONBRIDGE", 9, 92053},
	{"TONAWANDA", 9, 80302},
	{"TONASKET", 8, 230751},
	{"TONALITY", 8, 140236},
	{"TONALIN", 7, 221181},
	{"TONALE", 6, 167849},
	{"TONAL", 5, 70334},
	{"TOMZ", 4, 174145},
	{"TOMY", 4, 79125},
	{"TOMW", 4, 62105},
	{"TOMV", 4, 134094},
	{"TOMTOM", 6, 49448},
	{"TOMSON", 6, 216166},
	{"TOMSNETWORKING", 14, 236808},
	{"TOMSK", 5, 140586},
	{"TOMR", 4, 54433},
	{"TOMPKINS", 8, 68271},
	{"TOMP", 4, 50959},
	{"TOMOYUKI", 8, 243551},
	{"TOMOS", 5, 188843},
	{"TOMORROWS", 9, 100928},
	{"TOMORROWLAND", 12, 184641},
	{"TOMORROW", 8, 3844},
	{"TOMOROW", 7, 152694},
	{"TOMOMI", 6, 261122},
	{"TOMOLLO", 7, 247115},
	{"TOMOKO", 6, 152684},
	{"TOMOHIRO", 8, 207311},
	{"TOMOGRAPHY", 10, 54946},
	{"TOMOGRAPHIC", 11, 128250},
	{"TOMOE", 5, 192617},
	{"TOMMYS", 6, 126900},
	{"TOMMY", 5, 29399},
	{"TOMMORROW", 9, 124709},
	{"TOMMOROW", 8, 107402},
	{"TOMMO", 5, 207637},
	{"TOMMIE", 6, 117051},
	{"TOMMI", 5, 126144},
	{"TOMMEE", 6, 187674},
	{"TOMME", 5, 196343},
	{"TOMMASO", 7, 137247},
	{"TOMM", 4, 203348},
	{"TOMLINSON", 9, 64297},
	{"TOMLIN", 6, 87377},
	{"TOMLAB", 6, 209245},
	{"TOML", 4, 44082},
	{"TOMKO", 5, 160324},
	{"TOMKINSON", 9, 248620},
	{"TOMKINS", 7, 125458},
	{"TOMKAT", 6, 228297},
	{"TOMK", 4, 90813},
	{"TOMJ", 4, 113973},
	{"TOMITA", 6, 126155},
	{"TOMISLAV", 8, 202503},
	{"TOMINAGA", 8, 246016},
	{"TOMIE", 5, 149420},
	{"TOMICA", 6, 188200},
	{"TOMIC", 5, 252683},
	{"TOMFOOLERY", 10, 177523},
	{"TOMF", 4, 68187},
	{"TOMES", 5, 111995},
	{"TOMERS", 6, 158480},
	{"TOMER", 5, 123246},
	{"TOMENTOSA", 9, 191987},
	{"TOMEK", 5, 153577},
	{"TOMEI", 5, 136404},
	{"TOMDISPATCH", 11, 240322},
	{"TOMD", 4, 70321},
	{"TOMCATS", 7, 225842},
	{"TOMCAT", 6, 46433},
	{"TOMC", 4, 48773},
	{"TOMBSTONES", 10, 116857},
	{"TOMBSTONE", 9, 64555},
	{"TOMBS", 5, 69035},
	{"TOMBRAIDER", 10, 256955},
	{"TOMBOY", 6, 119918},
	{"TOMBOW", 6, 203593},
	{"TOMBOLA", 7, 245318},
	{"TOMBO", 5, 233699},
	{"TOMBIGBEE", 9, 206550},
	{"TOMBE", 5, 158264},
	{"TOMBAUGH", 8, 244689},
	{"TOMBALL", 7, 96575},
	{"TOMBA", 5, 161507},
	{"TOMB", 4, 39283},
	{"TOMAZ", 5, 245220},
	{"TOMATOS", 7, 212977},
	{"TOMATOMETER", 11, 70549},
	{"TOMATOES", 8, 34683},
	{"TOMATOE", 7, 248680},
	{"TOMATO", 6, 7204},
	{"TOMATILLO", 9, 225683},
	{"TOMATE", 6, 226332},
	{"TOMASZEWSKI", 11, 243782},
	{"TOMASZ", 6, 89247},
	{"TOMASO", 6, 89265},
	{"TOMASI", 6, 183283},
	{"TOMASELLO", 9, 244951},
	{"TOMAS", 5, 54866},
	{"TOMARROW", 8, 202733},
	{"TOMAR", 5, 128467},
	{"TOMAN", 5, 179908},
	{"TOMALES", 7, 167532},
	{"TOMAHAWKS", 9, 212908},
	{"TOMAHAWK", 8, 71412},
	{"TOMAH", 5, 144217},
	{"TOMACHINE", 9, 250957},
	{"TOMAC", 5, 219578},
	{"TOM", 3, 2723},
	{"TOLY", 4, 66033},
	{"TOLWORTH", 8, 248267},
	{"TOLW", 4, 102524},
	{"TOLV", 4, 184356},
	{"TOLUIDINE", 9, 193970},
	{"TOLUENE", 7, 76664},
	{"TOLUCA", 6, 112940},
	{"TOLTERODINE", 11, 238606},
	{"TOLTEC", 6, 132048},
	{"TOLSTOY", 7, 80770},
	{"TOLSON", 6, 192570},
	{"TOLR", 4, 105716},
	{"TOLP", 4, 104883},
	{"TOLOWER", 7, 191533},
	{"TOLMAN", 6, 147234},
	{"TOLM", 4, 107137},
	{"TOLLY", 5, 171760},
	{"TOLLWAY", 7, 137653},
	{"TOLLS", 5, 61892},
	{"TOLLIVER", 8, 160204},
	{"TOLLING", 7, 104749},
	{"TOLLHOUSE", 9, 196680},
	{"TOLLGATE", 8, 176116},
	{"TOLLFREE", 8, 120786},
	{"TOLLEY", 6, 134299},
	{"TOLLESON", 8, 146211},
	{"TOLLES", 6, 232082},
	{"TOLLER", 6, 194951},
	{"TOLLEFSON", 9, 202834},
	{"TOLLEF", 6, 230477},
	{"TOLLED", 6, 157363},
	{"TOLLE", 5, 127636},
	{"TOLLBOOTH", 9, 165877},
	{"TOLLAND", 7, 103276},
	{"TOLL", 4, 34406},
	{"TOLKIEN", 7, 50248},
	{"TOLKEIN", 7, 192201},
	{"TOLIVER", 7, 220483},
	{"TOLIET", 6, 234788},
	{"TOLHURST", 8, 257169},
	{"TOLGA", 5, 217885},
	{"TOLG", 4, 145353},
	{"TOLF", 4, 129668},
	{"TOLEX", 5, 231684},
	{"TOLES", 5, 240976},
	{"TOLERATION", 10, 114887},
	{"TOLERATING", 10, 128924},
	{"TOLERATES", 9, 123843},
	{"TOLERATED", 9, 51276},
	{"TOLERATE", 8, 33758},
	{"TOLERANT", 8, 47295},
	{"TOLERANCING", 11, 219031},
	{"TOLERANCES", 10, 64948},
	{"TOLERANCE", 9, 34578},
	{"TOLERABLY", 9, 166850},
	{"TOLERABLE", 9, 79041},
	{"TOLERABILITY", 12, 125092},
	{"TOLER", 5, 132439},
	{"TOLENTINO", 9, 210056},
	{"TOLEDO", 6, 37600},
	{"TOLDJAH", 7, 186739},
	{"TOLDE", 5, 193039},
	{"TOLD", 4, 2329},
	{"TOLC", 4, 93948},
	{"TOLBUTAMIDE", 11, 214888},
	{"TOLBERT", 7, 118751},
	{"TOLB", 4, 81477},
	{"TOLAR", 5, 78326},
	{"TOLAND", 6, 147619},
	{"TOLAN", 5, 186080},
	{"TOKYU", 5, 135673},
	{"TOKYOPOP", 8, 118548},
	{"TOKYOOFFICE", 11, 240548},
	{"TOKYO", 5, 8214},
	{"TOKW", 4, 140619},
	{"TOKUSHIMA", 9, 146713},
	{"TOKUNAGA", 8, 221998},
	{"TOKUGAWA", 8, 136970},
	{"TOKUDA", 6, 245858},
	{"TOKR", 4, 90878},
	{"TOKP", 4, 193630},
	{"TOKOROA", 7, 237530},
	{"TOKN", 4, 30463},
	{"TOKM", 4, 93893},
	{"TOKL", 4, 78496},
	{"TOKK", 4, 224876},
	{"TOKIO", 5, 101645},
	{"TOKINA", 6, 113214},
	{"TOKICO", 6, 139704},
	{"TOKG", 4, 139023},
	{"TOKF", 4, 202398},
	{"TOKER", 5, 204810},
	{"TOKENS", 6, 44366},
	{"TOKENRING", 9, 210631},
	{"TOKENIZER", 9, 137151},
	{"TOKENIZE", 8, 252581},
	{"TOKEN", 5, 35239},
	{"TOKELAU", 7, 44626},
	{"TOKD", 4, 247558},
	{"TOKC", 4, 189682},
	{"TOKB", 4, 165817},
	{"TOKAY", 5, 202848},
	{"TOKAREV", 7, 231262},
	{"TOKAR", 5, 257957},
	{"TOKAMAKS", 8, 229423},
	{"TOKAMAK", 7, 123965},
	{"TOKAIDO", 7, 248624},
	{"TOKAI", 5, 100328},
	{"TOJU", 4, 33636},
	{"TOJR", 4, 212623},
	{"TOJP", 4, 169451},
	{"TOIVONEN", 8, 191685},
	{"TOIN", 4, 3745},
	{"TOIMPROVE", 9, 180823},
	{"TOIM", 4, 29087},
	{"TOILS", 5, 144492},
	{"TOILING", 7, 125771},
	{"TOILETTENCAM", 12, 143084},
	{"TOILETTE", 8, 47179},
	{"TOILETS", 7, 44148},
	{"TOILETRY", 8, 91908},
	{"TOILETRIES", 10, 61624},
	{"TOILETING", 9, 139110},
	{"TOILET", 6, 31693},
	{"TOILED", 6, 140809},
	{"TOILE", 5, 82287},
	{"TOHRU", 5, 182995},
	{"TOHONO", 6, 195925},
	{"TOHOKU", 6, 102138},
	{"TOHMATSU", 8, 107425},
	{"TOHI", 4, 3064},
	{"TOHE", 4, 3235},
	{"TOHATSU", 7, 202111},
	{"TOHA", 4, 2641},
	{"TOGY", 4, 174351},
	{"TOGW", 4, 161214},
	{"TOGU", 4, 43892},
	{"TOGTHER", 7, 239178},
	{"TOGR", 4, 6229},
	{"TOGP", 4, 145796},
	{"TOGOLESE", 8, 225170},
	{"TOGOLAND", 8, 152688},
	{"TOGM", 4, 137324},
	{"TOGL", 4, 58200},
	{"TOGI", 4, 8599},
	{"TOGGLING", 8, 150480},
	{"TOGGLES", 7, 102367},
	{"TOGGLED", 7, 148203},
	{"TOGGLE", 6, 42140},
	{"TOGG", 4, 132874},
	{"TOGETHERS", 9, 90787},
	{"TOGETHERNESS", 12, 114624},
	{"TOGETHER", 8, 603},
	{"TOGETH", 6, 238757},
	{"TOGET", 5, 249287},
	{"TOGD", 4, 143257},
	{"TOGB", 4, 135445},
	{"TOGAMI", 6, 231478},
	{"TOGAF", 5, 189503},
	{"TOFZ", 4, 98493},
	{"TOFY", 4, 42591},
	{"TOFX", 4, 144142},
	{"TOFW", 4, 10058},
	{"TOFV", 4, 39223},
	{"TOFU", 4, 57446},
	{"TOFTE", 5, 222274},
	{"TOFS", 4, 5967},
	{"TOFRANIL", 8, 184329},
	{"TOFR", 4, 6720},
	{"TOFQ", 4, 73209},
	{"TOFP", 4, 6884},
	{"TOFO", 4, 4352},
	{"TOFN", 4, 34010},
	{"TOFM", 4, 7312},
	{"TOFL", 4, 8388},
	{"TOFK", 4, 45372},
	{"TOFJ", 4, 42688},
	{"TOFINO", 6, 104916},
	{"TOFI", 4, 2590},
	{"TOFH", 4, 5696},
	{"TOFG", 4, 32100},
	{"TOFFS", 5, 192996},
	{"TOFFLER", 7, 193731},
	{"TOFFEES", 7, 231994},
	{"TOFFEE", 6, 81083},
	{"TOFF", 4, 178954},
	{"TOFE", 4, 7446},
	{"TOFD", 4, 30868},
	{"TOFC", 4, 6226},
	{"TOFB", 4, 28558},
	{"TOFA", 4, 2667},
	{"TOEX", 4, 6400},
	{"TOEWS", 5, 144185},
	{"TOEVOEGEN", 9, 154685},
	{"TOEV", 4, 33796},
	{"TOESTELLEN", 10, 238953},
	{"TOESTEL", 7, 231934},
	{"TOERISME", 8, 124880},
	{"TOEPLITZ", 8, 181292},
	{"TOEPFER", 7, 233039},
	{"TOENAILS", 8, 112787},
	{"TOENAIL", 7, 120355},
	{"TOEKOMST", 8, 166274},
	{"TOEING", 6, 244320},
	{"TOEIC", 5, 103477},
	{"TOEHOLD", 7, 261437},
	{"TOEGEVOEGD", 10, 236470},
	{"TOEGANG", 7, 241174},
	{"TOEFL", 5, 61881},
	{"TODY", 4, 216371},
	{"TODW", 4, 110675},
	{"TODV", 4, 140722},
	{"TODU", 4, 47600},
	{"TODR", 4, 28818},
	{"TODOS", 5, 50789},
	{"TODOROV", 7, 195760},
	{"TODORELATOSCOM", 14, 261516},
	{"TODOR", 5, 239788},
	{"TODMORDEN", 9, 157265},
	{"TODM", 4, 169812},
	{"TODJ", 4, 192209},
	{"TODG", 4, 209106},
	{"TODF", 4, 257030},
	{"TODDY", 5, 140065},
	{"TODDLERS", 8, 43138},
	{"TODDLER", 7, 33997},
	{"TODDLE", 6, 226957},
	{"TODD", 4, 28449},
	{"TODC", 4, 134772},
	{"TODB", 4, 211814},
	{"TODAYS", 6, 47660},
	{"TODAY", 5, 1081},
	{"TODAS", 5, 71673},
	{"TODARO", 6, 237173},
	{"TOCZ", 4, 190203},
	{"TOCY", 4, 86144},
	{"TOCW", 4, 211265},
	{"TOCU", 4, 33310},
	{"TOCR", 4, 7824},
	{"TOCQUEVILLE", 11, 108351},
	{"TOCQ", 4, 260457},
	{"TOCOTRIENOLS", 12, 243982},
	{"TOCOPHERYL", 10, 178221},
	{"TOCOPHEROLS", 11, 181323},
	{"TOCOPHEROL", 10, 92365},
	{"TOCOL", 5, 228151},
	{"TOCM", 4, 97724},
	{"TOCL", 4, 28210},
	{"TOCK", 4, 106145},
	{"TOCHTERGESELLSCHAFTEN", 21, 248914},
	{"TOCHTER", 7, 254499},
	{"TOCHNOG", 7, 171182},
	{"TOCHIGI", 7, 155130},
	{"TOCF", 4, 157244},
	{"TOCD", 4, 136818},
	{"TOCCOA", 6, 134374},
	{"TOCCATA", 7, 140234},
	{"TOCCA", 5, 212663},
	{"TOCC", 4, 39439},
	{"TOCB", 4, 129048},
	{"TOCAR", 5, 228794},
	{"TOBYMAC", 7, 237625},
	{"TOBYHANNA", 9, 189728},
	{"TOBY", 4, 44956},
	{"TOBV", 4, 67427},
	{"TOBRUK", 6, 204584},
	{"TOBRAMYCIN", 10, 166330},
	{"TOBR", 4, 7109},
	{"TOBP", 4, 151661},
	{"TOBOGGANS", 9, 232137},
	{"TOBOGGANING", 11, 219591},
	{"TOBOGGAN", 8, 143755},
	{"TOBO", 4, 29131},
	{"TOBM", 4, 216262},
	{"TOBLER", 6, 179160},
	{"TOBL", 4, 35019},
	{"TOBJECT", 7, 124484},
	{"TOBIT", 5, 138027},
	{"TOBIN", 5, 62699},
	{"TOBIAS", 6, 54331},
	{"TOBIANO", 7, 240207},
	{"TOBEY", 5, 86097},
	{"TOBERMORY", 9, 163672},
	{"TOBER", 5, 188024},
	{"TOBC", 4, 112620},
	{"TOBBY", 5, 234667},
	{"TOBB", 4, 133527},
	{"TOBAGOTURKS", 11, 103890},
	{"TOBAGO", 6, 33368},
	{"TOBACK", 6, 260266},
	{"TOBACCOS", 8, 137841},
	{"TOBACCONISTS", 12, 224474},
	{"TOBACCONIST", 11, 233105},
	{"TOBACCO", 7, 9630},
	{"TOBACCIANA", 10, 108682},
	{"TOAV", 4, 30830},
	{"TOASTY", 6, 104463},
	{"TOASTS", 6, 97414},
	{"TOASTMASTERS", 12, 82094},
	{"TOASTMASTER", 11, 99999},
	{"TOASTING", 8, 94748},
	{"TOASTERS", 8, 64638},
	{"TOASTER", 7, 47663},
	{"TOASTED", 7, 64660},
	{"TOARRAY", 7, 241828},
	{"TOAR", 4, 9621},
	{"TOAP", 4, 7467},
	{"TOAM", 4, 28958},
	{"TOAG", 4, 35907},
	{"TOAF", 4, 30708},
	{"TOADY", 5, 194717},
	{"TOADSTOOLS", 10, 237499},
	{"TOADSTOOL", 9, 163916},
	{"TOADS", 5, 87715},
	{"TOADIES", 7, 205298},
	{"TOADFLAX", 8, 258367},
	{"TOAC", 4, 4659},
	{"TOAB", 4, 29830},
	{"TNYU", 4, 233511},
	{"TNYC", 4, 237976},
	{"TNX", 3, 249},
	{"TNUR", 4, 91722},
	{"TNUM", 4, 36316},
	{"TNUL", 4, 241594},
	{"TNUD", 4, 187866},
	{"TNUC", 4, 87809},
	{"TNU", 3, 1000},
	{"TNRCC", 5, 148588},
	{"TNPR", 4, 253181},
	{"TNPC", 4, 251096},
	{"TNOW", 4, 7809},
	{"TNOR", 4, 33815},
	{"TNITAC", 6, 235710},
	{"TNIG", 4, 30042},
	{"TNGU", 4, 215867},
	{"TNFL", 4, 102670},
	{"TNER", 4, 7304},
	{"TNBC", 4, 116726},
	{"TNAME", 5, 244593},
	{"TNAM", 4, 28239},
	{"TMYY", 4, 217071},
	{"TMYW", 4, 85832},
	{"TMYV", 4, 123908},
	{"TMYU", 4, 194215},
	{"TMYT", 4, 75775},
	{"TMYS", 4, 50649},
	{"TMYR", 4, 94288},
	{"TMYP", 4, 72449},
	{"TMYO", 4, 88099},
	{"TMYN", 4, 107539},
	{"TMYM", 4, 78065},
	{"TMYL", 4, 84632},
	{"TMYK", 4, 134646},
	{"TMYJ", 4, 136331},
	{"TMYI", 4, 111254},
	{"TMYH", 4, 72523},
	{"TMYG", 4, 93132},
	{"TMYF", 4, 60832},
	{"TMYE", 4, 69753},
	{"TMYD", 4, 79524},
	{"TMYC", 4, 67449},
	{"TMYB", 4, 75681},
	{"TMYA", 4, 84608},
	{"TMWI", 4, 123879},
	{"TMWH", 4, 215043},
	{"TMWC", 4, 204206},
	{"TMWA", 4, 183241},
	{"TMVP", 4, 166002},
	{"TMUT", 4, 86301},
	{"TMUS", 4, 30887},
	{"TMUR", 4, 60113},
	{"TMUN", 4, 68370},
	{"TMUM", 4, 140576},
	{"TMUL", 4, 58692},
	{"TMUK", 4, 251470},
	{"TMUI", 4, 224199},
	{"TMUH", 4, 107374},
	{"TMUF", 4, 261576},
	{"TMUE", 4, 226502},
	{"TMUD", 4, 139081},
	{"TMUC", 4, 33569},
	{"TMTV", 4, 176772},
	{"TMSW", 4, 213617},
	{"TMSU", 4, 158658},
	{"TMSP", 4, 181236},
	{"TMSM", 4, 200187},
	{"TMSF", 4, 158946},
	{"TMSD", 4, 249122},
	{"TMSC", 4, 168890},
	{"TMSB", 4, 227937},
	{"TMRW", 4, 164154},
	{"TMRT", 4, 162535},
	{"TMRS", 4, 81444},
	{"TMRR", 4, 155297},
	{"TMRP", 4, 143669},
	{"TMRO", 4, 137683},
	{"TMRN", 4, 231078},
	{"TMRM", 4, 112818},
	{"TMRL", 4, 163417},
	{"TMRK", 4, 156115},
	{"TMRJ", 4, 202399},
	{"TMRI", 4, 209894},
	{"TMRH", 4, 148533},
	{"TMRG", 4, 159714},
	{"TMRF", 4, 184858},
	{"TMRE", 4, 169906},
	{"TMRD", 4, 162129},
	{"TMRB", 4, 107821},
	{"TMRA", 4, 143308},
	{"TMPSTR", 6, 213706},
	{"TMPS", 4, 142936},
	{"TMPR", 4, 215254},
	{"TMPP", 4, 254609},
	{"TMPL", 4, 73228},
	{"TMPH", 4, 82985},
	{"TMPGENC", 7, 136794},
	{"TMPG", 4, 195091},
	{"TMPFS", 5, 169537},
	{"TMPFILE", 7, 173885},
	{"TMPF", 4, 165652},
	{"TMPE", 4, 226982},
	{"TMPDIR", 6, 120300},
	{"TMPDEPFILE", 10, 138675},
	{"TMPC", 4, 195626},
	{"TMPA", 4, 210106},
	{"TMP", 3, 34666},
	{"TMOZ", 4, 183012},
	{"TMOY", 4, 198519},
	{"TMOW", 4, 189020},
	{"TMOVINGIMAGE", 12, 190759},
	{"TMOV", 4, 32113},
	{"TMOU", 4, 46764},
	{"TMOS", 4, 9085},
	{"TMOR", 4, 5970},
	{"TMOP", 4, 227210},
	{"TMON", 4, 7127},
	{"TMOM", 4, 47330},
	{"TMOL", 4, 82620},
	{"TMOG", 4, 215658},
	{"TMOF", 4, 122456},
	{"TMOD", 4, 39365},
	{"TMOC", 4, 132055},
	{"TMOBILE", 7, 72824},
	{"TMOB", 4, 62054},
	{"TMNET", 5, 196762},
	{"TMMS", 4, 249123},
	{"TMMO", 4, 190490},
	{"TMMI", 4, 197582},
	{"TMMA", 4, 139737},
	{"TMLW", 4, 228974},
	{"TMLT", 4, 193174},
	{"TMLS", 4, 165818},
	{"TMLO", 4, 121883},
	{"TMLI", 4, 174457},
	{"TMLF", 4, 205196},
	{"TMLE", 4, 203980},
	{"TMLD", 4, 252150},
	{"TMLC", 4, 190777},
	{"TMLB", 4, 170443},
	{"TMLA", 4, 128586},
	{"TMIZ", 4, 186767},
	{"TMIY", 4, 255652},
	{"TMIX", 4, 68402},
	{"TMIR", 4, 73757},
	{"TMIM", 4, 125489},
	{"TMIL", 4, 10001},
	{"TMIK", 4, 63224},
	{"TMIG", 4, 32534},
	{"TMIF", 4, 226239},
	{"TMIC", 4, 256970},
	{"TMHZ", 4, 141099},
	{"TMGM", 4, 190071},
	{"TMFT", 4, 174146},
	{"TMFR", 4, 207929},
	{"TMFO", 4, 224877},
	{"TMEY", 4, 126437},
	{"TMEX", 4, 91391},
	{"TMEW", 4, 77713},
	{"TMEU", 4, 142098},
	{"TMET", 4, 35989},
	{"TMER", 4, 44658},
	{"TMENT", 5, 240126},
	{"TMEN", 4, 1990},
	{"TMEM", 4, 36465},
	{"TMEL", 4, 57399},
	{"TMEK", 4, 108422},
	{"TMEJ", 4, 155850},
	{"TMEG", 4, 69920},
	{"TMEF", 4, 108761},
	{"TMED", 4, 41808},
	{"TMEC", 4, 72058},
	{"TMEB", 4, 87264},
	{"TMEA", 4, 8496},
	{"TMDS", 4, 254137},
	{"TMDLS", 5, 93393},
	{"TMDL", 4, 60228},
	{"TMDI", 4, 251471},
	{"TMDE", 4, 184094},
	{"TMDA", 4, 105797},
	{"TMCXP", 5, 256869},
	{"TMCP", 4, 223110},
	{"TMCO", 4, 197583},
	{"TMCNET", 6, 137608},
	{"TMCN", 4, 113423},
	{"TMCL", 4, 124158},
	{"TMCK", 4, 98447},
	{"TMCI", 4, 175923},
	{"TMCH", 4, 198520},
	{"TMCG", 4, 94090},
	{"TMCF", 4, 186768},
	{"TMCE", 4, 212004},
	{"TMCD", 4, 91361},
	{"TMCC", 4, 188697},
	{"TMCB", 4, 231318},
	{"TMCA", 4, 112177},
	{"TMBU", 4, 246941},
	{"TMBG", 4, 137363},
	{"TMBE", 4, 158792},
	{"TMBA", 4, 181592},
	{"TMAZ", 4, 152072},
	{"TMAY", 4, 8114},
	{"TMAX", 4, 128358},
	{"TMAW", 4, 212798},
	{"TMAV", 4, 201068},
	{"TMAU", 4, 94074},
	{"TMATTERN", 8, 251883},
	{"TMATH", 5, 197214},
	{"TMAT", 4, 28691},
	{"TMAR", 4, 6672},
	{"TMAM", 4, 111388},
	{"TMAL", 4, 47880},
	{"TMAKE", 5, 196245},
	{"TMAK", 4, 6595},
	{"TMAJ", 4, 39600},
	{"TMAG", 4, 49789},
	{"TMAF", 4, 174458},
	{"TMAD", 4, 31643},
	{"TMAC", 4, 190386},
	{"TMAB", 4, 123856},
	{"TLYZ", 4, 228718},
	{"TLYY", 4, 85227},
	{"TLYW", 4, 30420},
	{"TLYV", 4, 68609},
	{"TLYU", 4, 41584},
	{"TLYT", 4, 7254},
	{"TLYR", 4, 32006},
	{"TLYQ", 4, 116343},
	{"TLYP", 4, 36193},
	{"TLYO", 4, 33772},
	{"TLYN", 4, 45237},
	{"TLYM", 4, 38146},
	{"TLYL", 4, 38171},
	{"TLYK", 4, 68799},
	{"TLYJ", 4, 79467},
	{"TLYI", 4, 9931},
	{"TLYH", 4, 34307},
	{"TLYG", 4, 50128},
	{"TLYF", 4, 33958},
	{"TLYE", 4, 39830},
	{"TLYD", 4, 33195},
	{"TLYC", 4, 32369},
	{"TLYB", 4, 29623},
	{"TLYA", 4, 6694},
	{"TLWA", 4, 241303},
	{"TLVS", 4, 203915},
	{"TLUX", 4, 117529},
	{"TLUT", 4, 112692},
	{"TLUS", 4, 144241},
	{"TLUR", 4, 127309},
	{"TLUP", 4, 239864},
	{"TLUO", 4, 237068},
	{"TLUN", 4, 68033},
	{"TLUM", 4, 127428},
	{"TLUL", 4, 189683},
	{"TLUK", 4, 95519},
	{"TLUI", 4, 147480},
	{"TLUF", 4, 239046},
	{"TLUD", 4, 141686},
	{"TLUC", 4, 55616},
	{"TLUB", 4, 181704},
	{"TLTP", 4, 224579},
	{"TLTD", 4, 157048},
	{"TLSU", 4, 117042},
	{"TLSQ", 4, 234899},
	{"TLRS", 4, 211223},
	{"TLOY", 4, 98912},
	{"TLOW", 4, 44483},
	{"TLOV", 4, 46687},
	{"TLOU", 4, 37513},
	{"TLOS", 4, 31943},
	{"TLOR", 4, 68803},
	{"TLOP", 4, 131949},
	{"TLOO", 4, 8853},
	{"TLON", 4, 35909},
	{"TLOM", 4, 147875},
	{"TLOL", 4, 166367},
	{"TLOK", 4, 209287},
	{"TLOG", 4, 65206},
	{"TLOF", 4, 143952},
	{"TLOD", 4, 119437},
	{"TLOC", 4, 36763},
	{"TLOB", 4, 100902},
	{"TLLT", 4, 156460},
	{"TLLS", 4, 170988},
	{"TLLP", 4, 180666},
	{"TLLO", 4, 145626},
	{"TLLN", 4, 259656},
	{"TLLM", 4, 200188},
	{"TLLL", 4, 260458},
	{"TLLH", 4, 155980},
	{"TLLG", 4, 182758},
	{"TLLD", 4, 229232},
	{"TLLC", 4, 125158},
	{"TLLB", 4, 66583},
	{"TLLA", 4, 147536},
	{"TLIZ", 4, 136672},
	{"TLIV", 4, 35097},
	{"TLIU", 4, 151949},
	{"TLIST", 5, 211745},
	{"TLIQ", 4, 103161},
	{"TLIP", 4, 102070},
	{"TLINGIT", 7, 149407},
	{"TLIN", 4, 6221},
	{"TLIM", 4, 48491},
	{"TLIL", 4, 104578},
	{"TLIK", 4, 6086},
	{"TLIG", 4, 40527},
	{"TLIF", 4, 39987},
	{"TLID", 4, 154449},
	{"TLEZ", 4, 163930},
	{"TLEY", 4, 41048},
	{"TLEX", 4, 126220},
	{"TLEW", 4, 32597},
	{"TLEV", 4, 36164},
	{"TLEU", 4, 58707},
	{"TLET", 4, 6385},
	{"TLER", 4, 8376},
	{"TLEQ", 4, 132970},
	{"TLEP", 4, 40981},
	{"TLEO", 4, 9474},
	{"TLEM", 4, 8689},
	{"TLEL", 4, 43090},
	{"TLEK", 4, 62241},
	{"TLEJ", 4, 77033},
	{"TLEI", 4, 31511},
	{"TLEG", 4, 32925},
	{"TLEF", 4, 29732},
	{"TLED", 4, 250670},
	{"TLEC", 4, 35779},
	{"TLEB", 4, 28419},
	{"TLEA", 4, 2793},
	{"TLDS", 4, 95800},
	{"TLDQ", 4, 105735},
	{"TLCO", 4, 209496},
	{"TLCKETS", 7, 235243},
	{"TLCD", 4, 214036},
	{"TLCA", 4, 206842},
	{"TLBF", 4, 166546},
	{"TLBA", 4, 230289},
	{"TLAZ", 4, 127881},
	{"TLAY", 4, 59425},
	{"TLAXCALA", 8, 205328},
	{"TLAX", 4, 171961},
	{"TLAW", 4, 38773},
	{"TLAV", 4, 107122},
	{"TLAU", 4, 44799},
	{"TLAR", 4, 42254},
	{"TLAP", 4, 65140},
	{"TLAN", 4, 5206},
	{"TLAM", 4, 65614},
	{"TLAL", 4, 136726},
	{"TLAG", 4, 99170},
	{"TLAF", 4, 121708},
	{"TLAD", 4, 60289},
	{"TLAC", 4, 54457},
	{"TKYO", 4, 188879},
	{"TKYL", 4, 125429},
	{"TKY", 3, 8337},
	{"TKWIN", 5, 238610},
	{"TKWA", 4, 199188},
	{"TKW", 3, 34900},
	{"TKUW", 4, 256345},
	{"TKUT", 4, 233235},
	{"TKUS", 4, 152015},
	{"TKUR", 4, 104515},
	{"TKUN", 4, 145411},
	{"TKUM", 4, 167242},
	{"TKUL", 4, 203282},
	{"TKUC", 4, 213409},
	{"TKUB", 4, 165577},
	{"TKS", 3, 247},
	{"TKRY", 4, 231079},
	{"TKRU", 4, 169627},
	{"TKRO", 4, 159802},
	{"TKRI", 4, 101697},
	{"TKRE", 4, 149978},
	{"TKRA", 4, 107822},
	{"TKOW", 4, 106094},
	{"TKOV", 4, 124249},
	{"TKOU", 4, 205386},
	{"TKOR", 4, 101504},
	{"TKOP", 4, 183723},
	{"TKOM", 4, 165244},
	{"TKOL", 4, 144463},
	{"TKOK", 4, 210884},
	{"TKOF", 4, 225325},
	{"TKOD", 4, 186903},
	{"TKOC", 4, 186904},
	{"TKOB", 4, 141947},
	{"TKNU", 4, 233851},
	{"TKNO", 4, 5661},
	{"TKMW", 4, 154831},
	{"TKMT", 4, 193782},
	{"TKMS", 4, 95520},
	{"TKMO", 4, 190928},
	{"TKMN", 4, 93232},
	{"TKMM", 4, 140766},
	{"TKMI", 4, 195696},
	{"TKMH", 4, 151035},
	{"TKMF", 4, 125250},
	{"TKME", 4, 166303},
	{"TKMA", 4, 132227},
	{"TKLO", 4, 250471},
	{"TKLI", 4, 178181},
	{"TKLE", 4, 157384},
	{"TKLA", 4, 155298},
	{"TKIW", 4, 259657},
	{"TKIR", 4, 88457},
	{"TKIP", 4, 185983},
	{"TKINTER", 7, 126143},
	{"TKINED", 6, 196422},
	{"TKIN", 4, 31579},
	{"TKIM", 4, 93464},
	{"TKIL", 4, 40610},
	{"TKIF", 4, 261950},
	{"TKID", 4, 55058},
	{"TKIC", 4, 64792},
	{"TKIB", 4, 240462},
	{"TKHZ", 4, 226983},
	{"TKHU", 4, 253547},
	{"TKGATE", 6, 135703},
	{"TKEY", 4, 244444},
	{"TKEW", 4, 216263},
	{"TKEV", 4, 87934},
	{"TKERNEL", 7, 233397},
	{"TKER", 4, 88100},
	{"TKEP", 4, 57851},
	{"TKEM", 4, 127702},
	{"TKEL", 4, 78023},
	{"TKDESK", 6, 231728},
	{"TKAZ", 4, 129554},
	{"TKAY", 4, 135986},
	{"TKAW", 4, 185491},
	{"TKAV", 4, 253182},
	{"TKAU", 4, 156625},
	{"TKAR", 4, 63998},
	{"TKAP", 4, 127617},
	{"TKAM", 4, 104082},
	{"TKAL", 4, 98494},
	{"TKAK", 4, 223994},
	{"TKAG", 4, 177267},
	{"TKAD", 4, 179087},
	{"TKACHUK", 7, 200062},
	{"TKACHENKO", 9, 194947},
	{"TKAC", 4, 151036},
	{"TKAB", 4, 143364},
	{"TJUV", 4, 168544},
	{"TJUTA", 5, 214670},
	{"TJUT", 4, 219505},
	{"TJUS", 4, 6874},
	{"TJUR", 4, 100251},
	{"TJUP", 4, 200378},
	{"TJUN", 4, 53132},
	{"TJUM", 4, 61920},
	{"TJUL", 4, 59662},
	{"TJUI", 4, 119680},
	{"TJUG", 4, 158719},
	{"TJUD", 4, 45531},
	{"TJUB", 4, 250825},
	{"TJUA", 4, 135632},
	{"TJU", 3, 764},
	{"TJRW", 4, 217487},
	{"TJRS", 4, 229989},
	{"TJRO", 4, 248820},
	{"TJRA", 4, 196004},
	{"TJPM", 4, 181705},
	{"TJOY", 4, 97312},
	{"TJOU", 4, 55410},
	{"TJOR", 4, 90501},
	{"TJOL", 4, 164299},
	{"TJOK", 4, 106402},
	{"TJOH", 4, 36201},
	{"TJOG", 4, 248821},
	{"TJOD", 4, 221510},
	{"TJOC", 4, 178053},
	{"TJOB", 4, 39856},
	{"TJO", 3, 809},
	{"TJMA", 4, 223070},
	{"TJIM", 4, 65825},
	{"TJIL", 4, 168188},
	{"TJFK", 4, 234298},
	{"TJEW", 4, 68544},
	{"TJER", 4, 62154},
	{"TJEP", 4, 261951},
	{"TJENESTER", 9, 251729},
	{"TJEM", 4, 208504},
	{"TJEL", 4, 188880},
	{"TJEF", 4, 71311},
	{"TJED", 4, 196614},
	{"TJAZ", 4, 105952},
	{"TJAY", 4, 100205},
	{"TJAW", 4, 179088},
	{"TJAV", 4, 126908},
	{"TJAU", 4, 246331},
	{"TJAR", 4, 102004},
	{"TJAP", 4, 67330},
	{"TJAM", 4, 49791},
	{"TJAL", 4, 158867},
	{"TJAK", 4, 115069},
	{"TJAG", 4, 154643},
	{"TJADER", 6, 209672},
	{"TJAD", 4, 161520},
	{"TJAC", 4, 47321},
	{"TJAB", 4, 148221},
	{"TIZZY", 5, 185550},
	{"TIZZ", 4, 183126},
	{"TIZW", 4, 158589},
	{"TIZIANO", 7, 127253},
	{"TIZIANA", 7, 191609},
	{"TIZE", 4, 7954},
	{"TIZD", 4, 261952},
	{"TIZARD", 6, 261858},
	{"TIZANIDINE", 10, 194621},
	{"TIWR", 4, 131898},
	{"TIWARI", 6, 147071},
	{"TIWA", 4, 35795},
	{"TIVU", 4, 233512},
	{"TIVOTOGO", 8, 226807},
	{"TIVOS", 5, 217609},
	{"TIVOLI", 6, 45587},
	{"TIVL", 4, 253895},
	{"TIVITY", 6, 117337},
	{"TIVITIES", 8, 161069},
	{"TIVES", 5, 91456},
	{"TIVERTON", 8, 91785},
	{"TIVENESS", 8, 193291},
	{"TIVELY", 6, 81689},
	{"TIVA", 4, 6426},
	{"TITW", 4, 6049},
	{"TITUSVILLE", 10, 85126},
	{"TITUS", 5, 46971},
	{"TITULO", 6, 162082},
	{"TITULKY", 7, 168683},
	{"TITULAR", 7, 95831},
	{"TITULAIRE", 9, 223041},
	{"TITTTIES", 8, 198312},
	{"TITTLE", 6, 136265},
	{"TITTIED", 7, 238359},
	{"TITTIE", 6, 156930},
	{"TITTER", 6, 212175},
	{"TITTENSUCHE", 11, 153949},
	{"TITTENSKINDER", 13, 213776},
	{"TITTENS", 7, 36759},
	{"TITTENRESERVIERUNG", 18, 155283},
	{"TITTENKINDERDICKE", 17, 213777},
	{"TITTENKETTEN", 12, 152457},
	{"TITTENHEUDICKE", 14, 213771},
	{"TITTENGUIDE", 11, 152787},
	{"TITTENGRIECHENLAND", 18, 214962},
	{"TITTENFINDER", 12, 155397},
	{"TITTENFICKEN", 12, 187274},
	{"TITTENFICK", 10, 117065},
	{"TITTENBUCHUNG", 13, 214519},
	{"TITTENBILDER", 12, 155080},
	{"TITTEN", 6, 9846},
	{"TITTEL", 6, 114907},
	{"TITTED", 6, 81020},
	{"TITS", 4, 3466},
	{"TITRES", 6, 103485},
	{"TITRE", 5, 71247},
	{"TITRATORS", 9, 251044},
	{"TITRATIONS", 10, 218597},
	{"TITRATION", 9, 87078},
	{"TITRATED", 8, 178346},
	{"TITRATE", 7, 220350},
	{"TITOV", 5, 237919},
	{"TITOLO", 6, 103833},
	{"TITOLI", 6, 182090},
	{"TITMUSS", 7, 135162},
	{"TITMUS", 6, 259741},
	{"TITMOUSE", 8, 179471},
	{"TITLO", 5, 222364},
	{"TITLING", 7, 105128},
	{"TITLEY", 6, 179623},
	{"TITLES", 6, 2854},
	{"TITLERS", 7, 204954},
	{"TITLER", 6, 172546},
	{"TITLEPAGE", 9, 221316},
	{"TITLEIST", 8, 64494},
	{"TITLEINDEX", 10, 168235},
	{"TITLED", 6, 35592},
	{"TITLEBAR", 8, 178473},
	{"TITLEACTION", 11, 230735},
	{"TITLE", 5, 3959},
	{"TITJOBS", 7, 139446},
	{"TITJOB", 6, 195902},
	{"TITIRANGI", 9, 251254},
	{"TITION", 6, 207804},
	{"TITILLATION", 11, 254460},
	{"TITILLATING", 11, 168051},
	{"TITIES", 6, 102318},
	{"TITICACA", 8, 142675},
	{"TITIAN", 6, 127652},
	{"TITHING", 7, 130203},
	{"TITHES", 6, 123059},
	{"TITERS", 6, 111991},
	{"TITER", 5, 105317},
	{"TITELS", 6, 193614},
	{"TITEL", 5, 55501},
	{"TITED", 5, 251050},
	{"TITEC", 5, 193881},
	{"TITCHMARSH", 10, 184451},
	{"TITCHFIELD", 10, 223389},
	{"TITBITS", 7, 249845},
	{"TITBIT", 6, 202670},
	{"TITANS", 6, 9019},
	{"TITANIUM", 8, 33550},
	{"TITANIC", 7, 41419},
	{"TITANIA", 7, 114079},
	{"TITANATE", 8, 182487},
	{"TISZA", 5, 215116},
	{"TISW", 4, 31870},
	{"TISU", 4, 31891},
	{"TISTICAL", 8, 249592},
	{"TISSUS", 6, 246385},
	{"TISSUES", 7, 38042},
	{"TISSUE", 6, 8471},
	{"TISSOT", 6, 80083},
	{"TISSERAND", 9, 191278},
	{"TISR", 4, 30836},
	{"TISL", 4, 29726},
	{"TISHREI", 7, 233627},
	{"TISHOMINGO", 10, 137013},
	{"TISHMAN", 7, 259200},
	{"TISHLER", 7, 238203},
	{"TISF", 4, 9842},
	{"TISDALL", 7, 230701},
	{"TISDALE", 7, 104060},
	{"TISD", 4, 33728},
	{"TISCOVER", 8, 55752},
	{"TISCHLER", 8, 231457},
	{"TISCH", 5, 117308},
	{"TISCALI", 7, 76053},
	{"TISBURY", 7, 134835},
	{"TISB", 4, 30694},
	{"TIRZAH", 6, 257852},
	{"TIRW", 4, 149642},
	{"TIRV", 4, 168891},
	{"TIRUPUR", 7, 96110},
	{"TIRUPATI", 8, 158387},
	{"TIRUNELVELI", 11, 200992},
	{"TIRUMALA", 8, 256758},
	{"TIRUCHIRAPALLI", 14, 212287},
	{"TIRU", 4, 84442},
	{"TIRP", 4, 164738},
	{"TIROS", 5, 242930},
	{"TIROLE", 6, 191907},
	{"TIROL", 5, 72510},
	{"TIRMIDHI", 8, 256107},
	{"TIRM", 4, 206843},
	{"TIRL", 4, 93256},
	{"TIRITH", 6, 189776},
	{"TIRING", 6, 82437},
	{"TIRESOME", 8, 93389},
	{"TIRES", 5, 30965},
	{"TIRELESSLY", 10, 92370},
	{"TIRELESS", 8, 83034},
	{"TIREE", 5, 167804},
	{"TIREDNESS", 9, 88003},
	{"TIRED", 5, 5947},
	{"TIRE", 4, 9009},
	{"TIRB", 4, 228975},
	{"TIRASPOL", 8, 256471},
	{"TIRANE", 6, 202710},
	{"TIRANA", 6, 86815},
	{"TIRAN", 5, 211492},
	{"TIRAMISU", 8, 121370},
	{"TIRAGE", 6, 204533},
	{"TIRADO", 6, 241276},
	{"TIRADES", 7, 185570},
	{"TIRADE", 6, 112698},
	{"TIQUE", 5, 184258},
	{"TIQU", 4, 39084},
	{"TIQ", 3, 1284},
	{"TIPY", 4, 231835},
	{"TIPW", 4, 173258},
	{"TIPU", 4, 213758},
	{"TIPTRONIC", 9, 126394},
	{"TIPTREE", 7, 194491},
	{"TIPTOP", 6, 192136},
	{"TIPTON", 6, 66787},
	{"TIPTOES", 7, 199246},
	{"TIPTOED", 7, 259563},
	{"TIPTOE", 6, 152134},
	{"TIPSY", 5, 101865},
	{"TIPSTERS", 8, 190121},
	{"TIPSTER", 7, 124035},
	{"TIPSHEET", 8, 237921},
	{"TIPS", 4, 1581},
	{"TIPR", 4, 75158},
	{"TIPPY", 5, 147322},
	{"TIPPS", 5, 107185},
	{"TIPPMANN", 8, 103245},
	{"TIPPMAN", 7, 234269},
	{"TIPPLE", 6, 178363},
	{"TIPPINGPOINT", 12, 219899},
	{"TIPPING", 7, 50137},
	{"TIPPIN", 6, 138079},
	{"TIPPIE", 6, 259365},
	{"TIPPI", 5, 238690},
	{"TIPPETT", 7, 121931},
	{"TIPPETS", 7, 260241},
	{"TIPPET", 6, 166209},
	{"TIPPERS", 7, 180486},
	{"TIPPERARY", 9, 69469},
	{"TIPPER", 6, 104610},
	{"TIPPEE", 6, 183823},
	{"TIPPED", 6, 54152},
	{"TIPPECANOE", 10, 116930},
	{"TIPPAH", 6, 228760},
	{"TIPP", 4, 94106},
	{"TIPOS", 5, 109997},
	{"TIPOFF", 6, 214568},
	{"TIPM", 4, 188881},
	{"TIPLER", 6, 228288},
	{"TIPLE", 5, 175416},
	{"TIPL", 4, 28878},
	{"TIPICO", 6, 235654},
	{"TIPICI", 6, 251956},
	{"TIPHYS", 6, 200241},
	{"TIPF", 4, 143309},
	{"TIPD", 4, 247878},
	{"TIPC", 4, 182522},
	{"TIPBC", 5, 209974},
	{"TIPB", 4, 210107},
	{"TIOUS", 5, 247433},
	{"TIONSHIPS", 9, 185387},
	{"TIONSHIP", 8, 152187},
	{"TIONS", 5, 35118},
	{"TIONING", 7, 182418},
	{"TIONG", 5, 213137},
	{"TIONED", 6, 132262},
	{"TIONARY", 7, 174134},
	{"TIONALLY", 8, 153427},
	{"TIONALITY", 9, 250632},
	{"TIONAL", 6, 48883},
	{"TIOMAN", 6, 190163},
	{"TIOGA", 5, 73742},
	{"TINYURL", 7, 252685},
	{"TINYSOFA", 8, 97251},
	{"TINYSEQ", 7, 185336},
	{"TINYS", 5, 191686},
	{"TINYOS", 6, 115553},
	{"TINYMCE", 7, 150933},
	{"TINYINT", 7, 167455},
	{"TINY", 4, 3888},
	{"TINW", 4, 32717},
	{"TINV", 4, 29737},
	{"TINUOUS", 7, 201106},
	{"TINUING", 7, 240249},
	{"TINUES", 6, 247408},
	{"TINUED", 6, 190161},
	{"TINUE", 5, 142238},
	{"TINTORETTO", 10, 238079},
	{"TINTON", 6, 165174},
	{"TINTING", 7, 78594},
	{"TINTIN", 6, 95746},
	{"TINTERN", 7, 213289},
	{"TINTED", 6, 59355},
	{"TINTAGEL", 8, 161477},
	{"TINSLEY", 7, 98490},
	{"TINSELTOWN", 10, 139924},
	{"TINSEL", 6, 102236},
	{"TINPUTIMAGE", 11, 74874},
	{"TINPLATE", 8, 151239},
	{"TINP", 4, 31978},
	{"TINNY", 5, 130522},
	{"TINNITUS", 8, 77124},
	{"TINNEY", 6, 179304},
	{"TINNED", 6, 110462},
	{"TINMAN", 6, 199887},
	{"TINM", 4, 30452},
	{"TINLEY", 6, 96963},
	{"TINKLING", 8, 150228},
	{"TINKLER", 7, 246822},
	{"TINKLE", 6, 158401},
	{"TINKERS", 7, 197026},
	{"TINKERING", 9, 89522},
	{"TINKERER", 8, 253952},
	{"TINKERED", 8, 196053},
	{"TINKERBELL", 10, 86965},
	{"TINKER", 6, 62190},
	{"TINKA", 5, 261051},
	{"TINIEST", 7, 106642},
	{"TINIAN", 6, 131345},
	{"TINGS", 5, 135501},
	{"TINGLY", 6, 189915},
	{"TINGLING", 8, 75695},
	{"TINGLEY", 7, 149028},
	{"TINGLES", 7, 223894},
	{"TINGLED", 7, 249910},
	{"TINGLE", 6, 89311},
	{"TINGGI", 6, 199468},
	{"TINGED", 6, 92192},
	{"TINGE", 5, 111585},
	{"TINGA", 5, 152102},
	{"TINFOIL", 7, 131044},
	{"TINF", 4, 8627},
	{"TINDERSTICKS", 12, 208570},
	{"TINDERBUILD", 11, 135172},
	{"TINDERBOX", 9, 92128},
	{"TINDER", 6, 148636},
	{"TINDALL", 7, 130388},
	{"TINDALE", 7, 218619},
	{"TINDAL", 6, 220753},
	{"TIND", 4, 8263},
	{"TINCTURES", 9, 131767},
	{"TINCTURE", 8, 97236},
	{"TINCT", 5, 245361},
	{"TINCIDUNT", 9, 146203},
	{"TINBERGEN", 9, 169489},
	{"TINB", 4, 34404},
	{"TINACAM", 7, 146215},
	{"TIMY", 4, 194088},
	{"TIMW", 4, 64099},
	{"TIMV", 4, 170533},
	{"TIMUR", 5, 116524},
	{"TIMU", 4, 34908},
	{"TIMSS", 5, 140398},
	{"TIMRES", 6, 71538},
	{"TIMPSON", 7, 202506},
	{"TIMPO", 5, 235030},
	{"TIMPANOGOS", 10, 225597},
	{"TIMPANI", 7, 117635},
	{"TIMP", 4, 125934},
	{"TIMOTHY", 7, 30834},
	{"TIMOTHEUS", 9, 176849},
	{"TIMOSHENKO", 10, 235319},
	{"TIMOROUS", 8, 219716},
	{"TIMORHONG", 9, 103918},
	{"TIMORESE", 8, 108494},
	{"TIMOR", 5, 36893},
	{"TIMONIUM", 8, 123543},
	{"TIMON", 5, 121156},
	{"TIMOLOL", 7, 157161},
	{"TIMOLEON", 8, 261125},
	{"TIMMY", 5, 69583},
	{"TIMMS", 5, 120916},
	{"TIMMONS", 7, 107144},
	{"TIMMINS", 7, 74277},
	{"TIMMERMANS", 10, 185843},
	{"TIMMERMANN", 10, 221821},
	{"TIMMERMAN", 9, 137199},
	{"TIMMER", 6, 172090},
	{"TIMME", 5, 249846},
	{"TIMM", 4, 107120},
	{"TIMLIN", 6, 197822},
	{"TIML", 4, 88288},
	{"TIMKO", 5, 232716},
	{"TIMKEN", 6, 143643},
	{"TIMK", 4, 113851},
	{"TIMISOARA", 9, 126752},
	{"TIMINGS", 7, 75010},
	{"TIMING", 6, 31058},
	{"TIMIKES", 7, 233281},
	{"TIMIDLY", 7, 157992},
	{"TIMIDITY", 8, 109096},
	{"TIMID", 5, 72363},
	{"TIMHOTEL", 8, 196370},
	{"TIMG", 4, 71473},
	{"TIMEZONES", 9, 140404},
	{"TIMEZONE", 8, 49723},
	{"TIMEY", 5, 189984},
	{"TIMEX", 5, 53543},
	{"TIMEWORKS", 9, 242393},
	{"TIMEWISE", 8, 198042},
	{"TIMEWASTING", 11, 202447},
	{"TIMEWASTER", 10, 200067},
	{"TIMEWARP", 8, 207589},
	{"TIMEVAL", 7, 144911},
	{"TIMETRAVEL", 10, 179121},
	{"TIMETABLING", 11, 127478},
	{"TIMETABLES", 10, 58698},
	{"TIMETABLED", 10, 161882},
	{"TIMETABLE", 9, 40269},
	{"TIMESYS", 7, 253964},
	{"TIMESTEP", 8, 149246},
	{"TIMESTEN", 8, 254886},
	{"TIMESTAMPS", 10, 90067},
	{"TIMESTAMPING", 12, 244383},
	{"TIMESTAMP", 9, 46780},
	{"TIMESSELECT", 11, 67628},
	{"TIMESPLITTERS", 13, 124204},
	{"TIMESPEC", 8, 188515},
	{"TIMESPAN", 8, 147219},
	{"TIMESLOTS", 9, 153431},
	{"TIMESLOT", 8, 129362},
	{"TIMESLIPS", 9, 154363},
	{"TIMESLIP", 8, 204314},
	{"TIMESHIFT", 9, 110253},
	{"TIMESHEETS", 10, 110662},
	{"TIMESHEET", 9, 79168},
	{"TIMESHARING", 11, 205115},
	{"TIMESHARES", 10, 50210},
	{"TIMESHARE", 9, 44449},
	{"TIMESERVICESCLASSES", 19, 158850},
	{"TIMESERIES", 10, 210072},
	{"TIMESCALES", 10, 90197},
	{"TIMESCALE", 9, 78027},
	{"TIMESAVING", 10, 138045},
	{"TIMESAVER", 9, 189518},
	{"TIMES", 5, 1067},
	{"TIMERS", 6, 46077},
	{"TIMERANG", 8, 149214},
	{"TIMER", 5, 31718},
	{"TIMEPORT", 8, 102105},
	{"TIMEPOINT", 9, 242515},
	{"TIMEPIECES", 10, 87689},
	{"TIMEPIECE", 9, 103436},
	{"TIMEOUTS", 8, 82388},
	{"TIMEOUT", 7, 38213},
	{"TIMELYWEB", 9, 146559},
	{"TIMELY", 6, 29113},
	{"TIMELINESS", 10, 50595},
	{"TIMELINES", 9, 58678},
	{"TIMELINE", 8, 32831},
	{"TIMELIKE", 8, 230900},
	{"TIMELESSNESS", 12, 172924},
	{"TIMELESS", 8, 44507},
	{"TIMELEFT", 8, 234488},
	{"TIMELAPSE", 9, 251668},
	{"TIMEKILLER", 10, 182624},
	{"TIMEKEEPING", 11, 103353},
	{"TIMEKEEPERS", 11, 199218},
	{"TIMEKEEPER", 10, 114763},
	{"TIMEIPS", 7, 204114},
	{"TIMEINEUROPE", 12, 250250},
	{"TIMEFRAMES", 10, 97453},
	{"TIMEFRAME", 9, 55322},
	{"TIMEFORCE", 9, 246160},
	{"TIMED", 5, 42626},
	{"TIMECODE", 8, 117754},
	{"TIMECLOCK", 9, 182609},
	{"TIMECHECK", 9, 249271},
	{"TIMECARDS", 9, 260388},
	{"TIMECARD", 8, 187159},
	{"TIMEBOMB", 8, 187836},
	{"TIMEBASE", 8, 199409},
	{"TIMEA", 5, 257653},
	{"TIME", 4, 602},
	{"TIMD", 4, 75138},
	{"TIMC", 4, 76495},
	{"TIMBUKTU", 8, 101149},
	{"TIMBUK", 6, 255910},
	{"TIMBRES", 7, 155662},
	{"TIMBRE", 6, 101901},
	{"TIMBO", 5, 175876},
	{"TIMBERWOLVES", 12, 70294},
	{"TIMBERWOLF", 10, 227836},
	{"TIMBERS", 7, 72997},
	{"TIMBERLINE", 10, 87904},
	{"TIMBERLANE", 10, 224230},
	{"TIMBERLANDS", 11, 159109},
	{"TIMBERLAND", 10, 47789},
	{"TIMBERLAKE", 10, 55073},
	{"TIMBERED", 8, 153526},
	{"TIMBER", 6, 35492},
	{"TIMBAVATI", 9, 121418},
	{"TIMBALES", 8, 177209},
	{"TIMBALAND", 9, 146585},
	{"TIMBA", 5, 253305},
	{"TIMARU", 6, 102177},
	{"TIMAH", 5, 198581},
	{"TIMAGE", 6, 154890},
	{"TIMAEUS", 7, 204022},
	{"TILY", 4, 51517},
	{"TILW", 4, 42691},
	{"TILV", 4, 129252},
	{"TILU", 4, 105717},
	{"TILTS", 5, 107446},
	{"TILTON", 6, 91440},
	{"TILTING", 7, 73020},
	{"TILTH", 5, 222223},
	{"TILTER", 6, 254377},
	{"TILTED", 6, 66282},
	{"TILSON", 6, 135589},
	{"TILR", 4, 60360},
	{"TILQ", 4, 255653},
	{"TILOS", 5, 201522},
	{"TILNEY", 6, 226659},
	{"TILMAN", 6, 123829},
	{"TILM", 4, 51286},
	{"TILLY", 5, 74141},
	{"TILLSONBURG", 11, 156029},
	{"TILLS", 5, 158090},
	{"TILLOTSON", 9, 129449},
	{"TILLMANS", 8, 251663},
	{"TILLMAN", 7, 75204},
	{"TILLIS", 6, 146709},
	{"TILLINGHAST", 11, 211716},
	{"TILLING", 7, 140337},
	{"TILLIE", 6, 122979},
	{"TILLICH", 7, 186044},
	{"TILLEY", 6, 90049},
	{"TILLETT", 7, 248741},
	{"TILLERY", 7, 174057},
	{"TILLERS", 7, 129101},
	{"TILLER", 6, 77694},
	{"TILLED", 6, 155117},
	{"TILLE", 5, 158191},
	{"TILLBAKA", 8, 179644},
	{"TILLANDSIA", 10, 260346},
	{"TILLAMOOK", 9, 97798},
	{"TILLAGE", 7, 75905},
	{"TILL", 4, 35196},
	{"TILK", 4, 121217},
	{"TILJ", 4, 58610},
	{"TILINGS", 7, 184468},
	{"TILING", 6, 72901},
	{"TILIA", 5, 127656},
	{"TILI", 4, 7633},
	{"TILH", 4, 35772},
	{"TILGHMAN", 8, 131796},
	{"TILG", 4, 88594},
	{"TILFORD", 7, 220054},
	{"TILF", 4, 63310},
	{"TILESET", 7, 241652},
	{"TILES", 5, 36213},
	{"TILERS", 6, 256425},
	{"TILER", 5, 200829},
	{"TILED", 5, 65234},
	{"TILECALORIMETER", 15, 212868},
	{"TILE", 4, 35358},
	{"TILDES", 6, 240273},
	{"TILDEN", 6, 101211},
	{"TILDE", 5, 93434},
	{"TILDA", 5, 137671},
	{"TILC", 4, 70910},
	{"TILBURY", 7, 107705},
	{"TILBURG", 7, 88374},
	{"TILBUD", 6, 166514},
	{"TILBROOK", 8, 211941},
	{"TILBAKE", 7, 181119},
	{"TILBAGE", 7, 167679},
	{"TILBA", 5, 249585},
	{"TILB", 4, 67254},
	{"TILAPIA", 7, 101597},
	{"TILAK", 5, 157066},
	{"TIL", 3, 242},
	{"TIKVA", 5, 194487},
	{"TIKV", 4, 236084},
	{"TIKU", 4, 179219},
	{"TIKRIT", 6, 124051},
	{"TIKR", 4, 203981},
	{"TIKKUN", 6, 153692},
	{"TIKKI", 5, 176742},
	{"TIKKERS", 7, 247362},
	{"TIKKA", 5, 123697},
	{"TIKK", 4, 157605},
	{"TIKIWIKI", 8, 106531},
	{"TIKHONOV", 8, 225059},
	{"TIKETS", 6, 243237},
	{"TIKET", 5, 138031},
	{"TIKES", 5, 70792},
	{"TIKANGA", 7, 239493},
	{"TIKAL", 5, 139009},
	{"TIJUANA", 7, 62550},
	{"TIJU", 4, 68477},
	{"TIJERAS", 7, 202641},
	{"TIJDSCHRIFT", 11, 170785},
	{"TIJDSCHR", 8, 193165},
	{"TIJDENS", 7, 188461},
	{"TIJD", 4, 134119},
	{"TIING", 5, 205295},
	{"TIGW", 4, 219733},
	{"TIGU", 4, 52429},
	{"TIGRIS", 6, 86647},
	{"TIGRINYA", 8, 173781},
	{"TIGRFAMS", 8, 202248},
	{"TIGRESS", 7, 156769},
	{"TIGRES", 6, 186235},
	{"TIGRE", 5, 86856},
	{"TIGRAY", 6, 218948},
	{"TIGRAN", 6, 200805},
	{"TIGRA", 5, 122220},
	{"TIGR", 4, 94860},
	{"TIGNES", 6, 116767},
	{"TIGNANELLO", 10, 205888},
	{"TIGM", 4, 77282},
	{"TIGL", 4, 104770},
	{"TIGHTY", 6, 254800},
	{"TIGHTWAD", 8, 242864},
	{"TIGHTVNC", 8, 203946},
	{"TIGHTSPLEASE", 12, 144116},
	{"TIGHTS", 6, 48174},
	{"TIGHTROPE", 9, 118673},
	{"TIGHTPOKER", 10, 173225},
	{"TIGHTNESS", 9, 82594},
	{"TIGHTLY", 7, 32195},
	{"TIGHTEST", 8, 124569},
	{"TIGHTER", 7, 57180},
	{"TIGHTENS", 8, 103616},
	{"TIGHTENING", 10, 61743},
	{"TIGHTENED", 9, 68479},
	{"TIGHTEN", 7, 34207},
	{"TIGHT", 5, 8913},
	{"TIGHE", 5, 141818},
	{"TIGGERS", 7, 258013},
	{"TIGGER", 6, 74494},
	{"TIGERT", 6, 261528},
	{"TIGERS", 6, 32513},
	{"TIGERLILY", 9, 153207},
	{"TIGERHAWK", 9, 157118},
	{"TIGEREYE", 8, 236553},
	{"TIGERDIRECT", 11, 69811},
	{"TIGER", 5, 8230},
	{"TIGBLOGS", 8, 125804},
	{"TIGBLOG", 7, 165674},
	{"TIGARD", 6, 91184},
	{"TIGAR", 5, 239814},
	{"TIFY", 4, 167942},
	{"TIFW", 4, 62349},
	{"TIFV", 4, 235493},
	{"TIFU", 4, 32038},
	{"TIFTON", 6, 82042},
	{"TIFP", 4, 96722},
	{"TIFOSI", 6, 186071},
	{"TIFM", 4, 99450},
	{"TIFL", 4, 72747},
	{"TIFK", 4, 202943},
	{"TIFJ", 4, 177935},
	{"TIFIED", 6, 165024},
	{"TIFICATION", 10, 189757},
	{"TIFIC", 5, 190159},
	{"TIFI", 4, 4300},
	{"TIFG", 4, 133915},
	{"TIFFS", 5, 186841},
	{"TIFFIN", 6, 87102},
	{"TIFFEN", 6, 100073},
	{"TIFFANYS", 8, 179817},
	{"TIFFANY", 7, 7257},
	{"TIFFANIE", 8, 247380},
	{"TIFFANI", 7, 122402},
	{"TIFF", 4, 42313},
	{"TIFD", 4, 129407},
	{"TIFC", 4, 101154},
	{"TIFB", 4, 117369},
	{"TIETOENATOR", 11, 213069},
	{"TIETEN", 6, 139663},
	{"TIESTO", 6, 79332},
	{"TIERSEN", 7, 212656},
	{"TIERS", 5, 64390},
	{"TIERRAS", 7, 245404},
	{"TIERRA", 6, 66093},
	{"TIERNEY", 7, 72996},
	{"TIERNAN", 7, 155708},
	{"TIERING", 7, 239410},
	{"TIERGARTEN", 10, 228540},
	{"TIEREN", 6, 107188},
	{"TIERED", 6, 60720},
	{"TIERE", 5, 151492},
	{"TIER", 4, 32359},
	{"TIEPOLO", 7, 218810},
	{"TIENTS", 6, 146972},
	{"TIENG", 5, 129769},
	{"TIENES", 6, 131777},
	{"TIENER", 6, 149936},
	{"TIENEN", 6, 104904},
	{"TIENDAS", 7, 131801},
	{"TIENDA", 6, 97882},
	{"TIEMPOS", 7, 147701},
	{"TIEMPO", 6, 66886},
	{"TIEMANN", 7, 199818},
	{"TIELENS", 7, 256154},
	{"TIEDOWNS", 8, 256076},
	{"TIEDOWN", 7, 249589},
	{"TIEDJE", 6, 254988},
	{"TIEDEMANN", 9, 219214},
	{"TIED", 4, 29100},
	{"TIEBREAKER", 10, 153487},
	{"TIEBACKS", 8, 190462},
	{"TIEBACK", 7, 206080},
	{"TIDYING", 7, 119390},
	{"TIDY", 4, 50331},
	{"TIDWELL", 7, 125720},
	{"TIDW", 4, 162782},
	{"TIDUS", 5, 172464},
	{"TIDU", 4, 152867},
	{"TIDSSKRIFT", 10, 238024},
	{"TIDSSKR", 7, 253746},
	{"TIDR", 4, 98336},
	{"TIDP", 4, 198214},
	{"TIDM", 4, 223995},
	{"TIDL", 4, 97489},
	{"TIDINGS", 7, 80611},
	{"TIDIGARE", 8, 239822},
	{"TIDIED", 6, 159148},
	{"TIDG", 4, 185746},
	{"TIDF", 4, 244525},
	{"TIDEWATER", 9, 87816},
	{"TIDES", 5, 49338},
	{"TIDEPOOL", 8, 243759},
	{"TIDEN", 5, 224993},
	{"TIDELANDS", 9, 187495},
	{"TIDE", 4, 32079},
	{"TIDDLYWIKI", 10, 231719},
	{"TIDC", 4, 183013},
	{"TIDBITS", 7, 54954},
	{"TIDBIT", 6, 95344},
	{"TIDB", 4, 209645},
	{"TIDAL", 5, 46445},
	{"TIDAK", 5, 129493},
	{"TICZ", 4, 186277},
	{"TICY", 4, 96785},
	{"TICW", 4, 42042},
	{"TICV", 4, 47746},
	{"TICULARLY", 9, 165402},
	{"TICULAR", 7, 123610},
	{"TICU", 4, 4573},
	{"TICTAP", 6, 116092},
	{"TICTACTOE", 9, 137306},
	{"TICT", 4, 33190},
	{"TICR", 4, 37280},
	{"TICQ", 4, 112986},
	{"TICP", 4, 29877},
	{"TICOS", 5, 240236},
	{"TICONDEROGA", 11, 124596},
	{"TICM", 4, 38115},
	{"TICLOPIDINE", 11, 207776},
	{"TICLES", 6, 212578},
	{"TICLE", 5, 213677},
	{"TICL", 4, 5328},
	{"TICKY", 5, 248668},
	{"TICKTS", 6, 256192},
	{"TICKS", 5, 58112},
	{"TICKNOR", 7, 190992},
	{"TICKNER", 7, 254310},
	{"TICKLISH", 8, 92215},
	{"TICKLING", 8, 41581},
	{"TICKLES", 7, 119008},
	{"TICKLERS", 8, 149629},
	{"TICKLER", 7, 144714},
	{"TICKLED", 7, 88027},
	{"TICKLE", 6, 55568},
	{"TICKLABEL", 9, 251353},
	{"TICKING", 7, 67018},
	{"TICKETWEB", 9, 119518},
	{"TICKETWATCH", 11, 258121},
	{"TICKETTRIANGLE", 14, 234376},
	{"TICKETSWITCH", 12, 214767},
	{"TICKETSON", 9, 141869},
	{"TICKETSNOW", 10, 161439},
	{"TICKETS", 7, 1546},
	{"TICKETMASTER", 12, 38319},
	{"TICKETLINE", 10, 246908},
	{"TICKETING", 9, 58841},
	{"TICKETFAST", 10, 139426},
	{"TICKETEXCHANGE", 14, 225301},
	{"TICKETED", 8, 123342},
	{"TICKETD", 7, 261396},
	{"TICKETCENTER", 12, 146988},
	{"TICKETALERTS", 12, 167053},
	{"TICKET", 6, 4761},
	{"TICKEST", 7, 255225},
	{"TICKES", 6, 246404},
	{"TICKERS", 7, 108641},
	{"TICKER", 6, 40536},
	{"TICKELL", 7, 227787},
	{"TICKED", 6, 85542},
	{"TICKCO", 6, 152639},
	{"TICKBOXES", 9, 48989},
	{"TICK", 4, 37881},
	{"TICJ", 4, 82065},
	{"TICIPATION", 10, 206783},
	{"TICIPATE", 8, 223399},
	{"TICIPANTS", 9, 183881},
	{"TICINO", 6, 127360},
	{"TICI", 4, 2912},
	{"TICHY", 5, 178722},
	{"TICHENOR", 8, 229411},
	{"TICG", 4, 48547},
	{"TICF", 4, 36717},
	{"TICETS", 6, 230656},
	{"TICES", 5, 144519},
	{"TICD", 4, 37567},
	{"TICC", 4, 29520},
	{"TICB", 4, 39677},
	{"TICATS", 6, 239930},
	{"TICARET", 7, 198419},
	{"TICALLY", 7, 227856},
	{"TICAL", 5, 110578},
	{"TIBY", 4, 195092},
	{"TIBUS", 5, 241779},
	{"TIBURON", 7, 74044},
	{"TIBU", 4, 81519},
	{"TIBSHIRANI", 10, 238828},
	{"TIBR", 4, 100000},
	{"TIBOR", 5, 111028},
	{"TIBOOK", 6, 189487},
	{"TIBM", 4, 132104},
	{"TIBL", 4, 39305},
	{"TIBIALIS", 8, 251585},
	{"TIBIAL", 6, 103322},
	{"TIBIA", 5, 73957},
	{"TIBETANS", 8, 102902},
	{"TIBETAN", 7, 41078},
	{"TIBET", 5, 40771},
	{"TIBERIUS", 8, 85445},
	{"TIBERIAS", 8, 155027},
	{"TIBERIAN", 8, 115770},
	{"TIBER", 5, 139713},
	{"TIBCO", 5, 94127},
	{"TIBBY", 5, 254358},
	{"TIBBS", 5, 167603},
	{"TIBBITTS", 8, 189237},
	{"TIBBETTS", 8, 149446},
	{"TIBB", 4, 134231},
	{"TIAVA", 5, 43935},
	{"TIARE", 5, 212459},
	{"TIARAS", 6, 84496},
	{"TIARA", 5, 63579},
	{"TIANNA", 6, 184343},
	{"TIANJIN", 7, 70406},
	{"TIANANMEN", 9, 93871},
	{"TIAMAT", 6, 129847},
	{"TIALLY", 6, 114329},
	{"TIAHRT", 6, 225181},
	{"TIAGO", 5, 142259},
	{"THZU", 4, 188561},
	{"THYY", 4, 151247},
	{"THYW", 4, 62685},
	{"THYV", 4, 129513},
	{"THYU", 4, 102502},
	{"THYSSENKRUPP", 12, 133420},
	{"THYSSEN", 7, 141923},
	{"THYSELF", 7, 72392},
	{"THYROXINE", 9, 112387},
	{"THYROTROPIN", 11, 134050},
	{"THYROTOXICOSIS", 14, 224962},
	{"THYROIDITIS", 11, 145140},
	{"THYROIDECTOMY", 13, 199583},
	{"THYROID", 7, 39624},
	{"THYROGLOBULIN", 13, 182056},
	{"THYRISTORS", 10, 197001},
	{"THYRISTOR", 9, 155068},
	{"THYRA", 5, 249200},
	{"THYR", 4, 62808},
	{"THYP", 4, 54961},
	{"THYO", 4, 30959},
	{"THYMUS", 6, 76399},
	{"THYMOMA", 7, 178717},
	{"THYMOCYTES", 10, 158327},
	{"THYMOCYTE", 9, 238699},
	{"THYMINE", 7, 152640},
	{"THYMIDYLATE", 11, 189235},
	{"THYMIDINE", 9, 95602},
	{"THYMIC", 6, 131965},
	{"THYMES", 6, 161253},
	{"THYME", 5, 61613},
	{"THYLAKOID", 9, 226624},
	{"THYL", 4, 55770},
	{"THYK", 4, 131004},
	{"THYJ", 4, 131736},
	{"THYG", 4, 82502},
	{"THYF", 4, 55614},
	{"THYD", 4, 63205},
	{"THYC", 4, 59482},
	{"THYB", 4, 60380},
	{"THXP", 4, 246044},
	{"THX", 3, 248},
	{"THWY", 4, 162034},
	{"THWW", 4, 199851},
	{"THWR", 4, 73573},
	{"THWI", 4, 30352},
	{"THWH", 4, 28104},
	{"THWC", 4, 258160},
	{"THWARTS", 7, 177653},
	{"THWARTING", 9, 138632},
	{"THWARTED", 8, 84630},
	{"THWART", 6, 76035},
	{"THWAITES", 8, 153814},
	{"THWACK", 6, 228106},
	{"THWA", 4, 9571},
	{"THVU", 4, 258543},
	{"THVL", 4, 238496},
	{"THUY", 4, 145792},
	{"THUW", 4, 247879},
	{"THUV", 4, 245120},
	{"THUTMOSE", 8, 251120},
	{"THUSLY", 6, 125365},
	{"THUS", 4, 2174},
	{"THURSTON", 8, 64966},
	{"THURSO", 6, 130876},
	{"THURSDAYS", 9, 50376},
	{"THURSDAY", 8, 2018},
	{"THURSBY", 7, 157650},
	{"THURS", 5, 45928},
	{"THURROTT", 8, 154686},
	{"THURROCK", 8, 79825},
	{"THUROW", 6, 202319},
	{"THURMONT", 8, 187524},
	{"THURMOND", 8, 88519},
	{"THURMAN", 7, 64111},
	{"THURLOW", 7, 136295},
	{"THURLES", 7, 198319},
	{"THURINGOWA", 10, 243105},
	{"THURINGIENSIS", 13, 120225},
	{"THURINGIA", 9, 156879},
	{"THURGOOD", 8, 122885},
	{"THURGAU", 7, 230883},
	{"THURBER", 7, 118187},
	{"THURAYA", 7, 153286},
	{"THUR", 4, 60866},
	{"THUP", 4, 65052},
	{"THUONG", 6, 107936},
	{"THUNNUS", 7, 246606},
	{"THUNK", 5, 110592},
	{"THUNE", 5, 122726},
	{"THUNDERSTRUCK", 13, 128297},
	{"THUNDERSTORMS", 13, 54563},
	{"THUNDERSTORM", 12, 61728},
	{"THUNDERSTONE", 12, 120095},
	{"THUNDERS", 8, 114710},
	{"THUNDERPANTS", 12, 258629},
	{"THUNDEROUS", 10, 114858},
	{"THUNDERING", 10, 81143},
	{"THUNDERHEAD", 11, 153570},
	{"THUNDERHAWK", 11, 231423},
	{"THUNDERER", 9, 256834},
	{"THUNDERED", 9, 152292},
	{"THUNDERDOME", 11, 151387},
	{"THUNDERCLAP", 11, 246716},
	{"THUNDERCATS", 11, 105566},
	{"THUNDERCAT", 10, 254673},
	{"THUNDERBOLTS", 12, 147470},
	{"THUNDERBOLT", 11, 82575},
	{"THUNDERBIRDS", 12, 69952},
	{"THUNDERBIRD", 11, 43373},
	{"THUNDERBALL", 11, 146915},
	{"THUNDER", 7, 33315},
	{"THUMPS", 6, 152623},
	{"THUMPERS", 8, 222714},
	{"THUMPER", 7, 108770},
	{"THUMPED", 7, 181306},
	{"THUMP", 5, 83405},
	{"THUMNAILS", 9, 126136},
	{"THUMNAIL", 8, 140878},
	{"THUMBZILLA", 10, 30848},
	{"THUMBUP", 7, 190141},
	{"THUMBSUP", 8, 125224},
	{"THUMBSUCKER", 11, 96890},
	{"THUMBSHOTS", 10, 85580},
	{"THUMBSCREWS", 11, 183462},
	{"THUMBSCREW", 10, 258046},
	{"THUMBS", 6, 9812},
	{"THUMBPRINT", 10, 153304},
	{"THUMBNAILS", 10, 29679},
	{"THUMBNAILPOST", 13, 85717},
	{"THUMBNAILER", 11, 208663},
	{"THUMBNAILED", 11, 141823},
	{"THUMBNAIL", 9, 7989},
	{"THUMBING", 8, 156576},
	{"THUMBELINA", 10, 206008},
	{"THUMBED", 7, 175678},
	{"THUMBDRIVE", 10, 190422},
	{"THUMB", 5, 30618},
	{"THUM", 4, 185335},
	{"THULE", 5, 67924},
	{"THUK", 4, 128862},
	{"THUJA", 5, 149893},
	{"THUJ", 4, 165426},
	{"THUIS", 5, 182660},
	{"THUILE", 6, 186614},
	{"THUGZ", 5, 216232},
	{"THUGS", 5, 55524},
	{"THUGGISH", 8, 237312},
	{"THUGGERY", 8, 216375},
	{"THUG", 4, 52129},
	{"THUF", 4, 171776},
	{"THUD", 4, 88600},
	{"THUCYDIDES", 10, 137244},
	{"THUC", 4, 224802},
	{"THUBAN", 6, 213844},
	{"THUAT", 5, 199339},
	{"THUAN", 5, 177344},
	{"THU", 3, 2179},
	{"THTW", 4, 34484},
	{"THTTPD", 6, 161148},
	{"THSU", 4, 34749},
	{"THRY", 4, 76717},
	{"THRW", 4, 248495},
	{"THRUXTON", 8, 158030},
	{"THRUWAY", 7, 127396},
	{"THRUSTS", 7, 93381},
	{"THRUSTMASTER", 12, 114955},
	{"THRUSTING", 9, 91132},
	{"THRUSTERS", 9, 115166},
	{"THRUSTER", 8, 109449},
	{"THRUST", 6, 40558},
	{"THRUSHES", 8, 179437},
	{"THRUSH", 6, 67045},
	{"THRUS", 5, 197484},
	{"THRUOUT", 7, 237570},
	{"THRUN", 5, 237232},
	{"THRU", 4, 28348},
	{"THRP", 4, 231080},
	{"THROWS", 6, 31681},
	{"THROWRAG", 8, 260168},
	{"THROWN", 6, 34136},
	{"THROWING", 8, 36311},
	{"THROWIN", 7, 200980},
	{"THROWERS", 8, 129573},
	{"THROWER", 7, 84125},
	{"THROWDOWN", 9, 111211},
	{"THROWBACKS", 10, 195887},
	{"THROWBACK", 9, 68627},
	{"THROWAWAY", 9, 126967},
	{"THROWABLE", 9, 116644},
	{"THROW", 5, 2152},
	{"THROUGOUT", 9, 253287},
	{"THROUGHTOUT", 11, 252221},
	{"THROUGHT", 8, 98410},
	{"THROUGHS", 8, 96020},
	{"THROUGHPUTS", 11, 216112},
	{"THROUGHPUT", 10, 41544},
	{"THROUGHOUT", 10, 2951},
	{"THROUGHLY", 9, 132381},
	{"THROUGH", 7, 601},
	{"THROUG", 6, 208990},
	{"THROU", 5, 211417},
	{"THROTTLING", 10, 113916},
	{"THROTTLES", 9, 174536},
	{"THROTTLED", 9, 180484},
	{"THROTTLE", 8, 47428},
	{"THROOP", 6, 172736},
	{"THRONGS", 7, 140203},
	{"THRONGED", 8, 171036},
	{"THRONG", 6, 95253},
	{"THRONES", 7, 66561},
	{"THRONE", 6, 40972},
	{"THROMBUS", 8, 142954},
	{"THROMBOXANE", 11, 144017},
	{"THROMBOTIC", 10, 137704},
	{"THROMBOSPONDIN", 14, 203935},
	{"THROMBOSIS", 10, 63281},
	{"THROMBOPLASTIN", 14, 196238},
	{"THROMBOPHLEBITIS", 16, 173766},
	{"THROMBOPHILIA", 13, 238404},
	{"THROMBOLYTIC", 12, 130423},
	{"THROMBOLYSIS", 12, 146541},
	{"THROMBOEMBOLISM", 15, 128042},
	{"THROMBOEMBOLIC", 14, 165496},
	{"THROMBOCYTOPENIC", 16, 159980},
	{"THROMBOCYTOPENIA", 16, 104345},
	{"THROMBIN", 8, 90848},
	{"THROMBI", 7, 245223},
	{"THROMB", 6, 145445},
	{"THROES", 6, 106867},
	{"THROCKMORTON", 12, 119010},
	{"THROBS", 6, 205052},
	{"THROBBING", 9, 73988},
	{"THROBBED", 8, 176537},
	{"THROB", 5, 114169},
	{"THROATY", 7, 184330},
	{"THROATS", 7, 73325},
	{"THROATED", 8, 75768},
	{"THROAT", 6, 7285},
	{"THRM", 4, 200915},
	{"THRIVING", 8, 52400},
	{"THRIVES", 7, 85409},
	{"THRIVENT", 8, 90327},
	{"THRIVED", 7, 97951},
	{"THRIVE", 6, 34710},
	{"THRISSUR", 8, 153291},
	{"THRIPS", 6, 123601},
	{"THRILLSEEKERS", 13, 252661},
	{"THRILLS", 7, 61218},
	{"THRILLING", 9, 54909},
	{"THRILLERS", 9, 44496},
	{"THRILLER", 8, 35957},
	{"THRILLED", 8, 48043},
	{"THRILL", 6, 43919},
	{"THRIFTYFUN", 10, 196812},
	{"THRIFTY", 7, 57200},
	{"THRIFTS", 7, 152708},
	{"THRIFTLODGE", 11, 240035},
	{"THRIFT", 6, 54948},
	{"THRID", 5, 214863},
	{"THRICE", 6, 41383},
	{"THRI", 4, 29632},
	{"THREW", 5, 37971},
	{"THRESOMES", 9, 112330},
	{"THRESHOLDS", 10, 48994},
	{"THRESHOLDING", 12, 139968},
	{"THRESHOLD", 9, 34644},
	{"THRESHING", 9, 123361},
	{"THRESHHOLD", 10, 225661},
	{"THRESHERS", 9, 258778},
	{"THRESHER", 8, 141274},
	{"THRESH", 6, 120823},
	{"THREONINE", 9, 70542},
	{"THRELKELD", 9, 229061},
	{"THREEWAY", 8, 141623},
	{"THREEWAVE", 9, 254989},
	{"THREESCORE", 10, 203611},
	{"THREESAMES", 10, 112783},
	{"THREES", 6, 104293},
	{"THREEPOINTGAIN", 14, 138522},
	{"THREEPIO", 8, 219463},
	{"THREEPENNY", 10, 223139},
	{"THREEPENCE", 10, 254319},
	{"THREEFOLD", 9, 92277},
	{"THREECHANNEL", 12, 78163},
	{"THREE", 5, 363},
	{"THREDBO", 7, 148411},
	{"THREATSENTRY", 12, 225644},
	{"THREATS", 7, 28846},
	{"THREATENS", 9, 45317},
	{"THREATENINGLY", 13, 252737},
	{"THREATENING", 11, 36456},
	{"THREATENED", 10, 32227},
	{"THREATEN", 8, 4367},
	{"THREAT", 6, 3181},
	{"THREADWATCH", 11, 223667},
	{"THREADSINDEX", 12, 196246},
	{"THREADSDEV", 10, 203414},
	{"THREADSAFE", 10, 235294},
	{"THREADS", 7, 5473},
	{"THREADPREVIOUS", 14, 210154},
	{"THREADPOOL", 10, 259762},
	{"THREADNEXT", 10, 200996},
	{"THREADNEEDLE", 12, 177408},
	{"THREADLESS", 10, 96775},
	{"THREADING", 9, 55635},
	{"THREADID", 8, 141513},
	{"THREADGILL", 10, 249620},
	{"THREADER", 8, 146315},
	{"THREADED", 8, 29233},
	{"THREADBARE", 10, 159321},
	{"THREAD", 6, 35012},
	{"THRD", 4, 168625},
	{"THRC", 4, 182172},
	{"THRB", 4, 112088},
	{"THRAWN", 6, 226085},
	{"THRASHING", 9, 95390},
	{"THRASHERS", 9, 73414},
	{"THRASHER", 8, 84963},
	{"THRASHED", 8, 129794},
	{"THRASH", 6, 64152},
	{"THRANE", 6, 194614},
	{"THRALLS", 7, 185512},
	{"THRALL", 6, 110852},
	{"THRACIANS", 9, 213118},
	{"THRACIAN", 8, 154152},
	{"THRACE", 6, 105046},
	{"THRA", 4, 33868},
	{"THQU", 4, 32997},
	{"THQB", 4, 199189},
	{"THPY", 4, 195408},
	{"THPU", 4, 52956},
	{"THPR", 4, 29931},
	{"THPP", 4, 160887},
	{"THPO", 4, 29807},
	{"THPM", 4, 145147},
	{"THPL", 4, 32835},
	{"THPK", 4, 204483},
	{"THPG", 4, 219506},
	{"THPF", 4, 260459},
	{"THPE", 4, 33287},
	{"THPD", 4, 239865},
	{"THPC", 4, 167560},
	{"THPB", 4, 253896},
	{"THPA", 4, 30902},
	{"THOUSANDTHS", 11, 186494},
	{"THOUSANDTH", 10, 142213},
	{"THOUSANDS", 9, 3278},
	{"THOUSAND", 8, 2136},
	{"THOUS", 5, 174209},
	{"THOUROUGHLY", 11, 247706},
	{"THOUGHTWORKS", 12, 249974},
	{"THOUGHTS", 8, 3328},
	{"THOUGHTLESSLY", 13, 225273},
	{"THOUGHTLESS", 11, 113034},
	{"THOUGHTFULNESS", 14, 121291},
	{"THOUGHTFULLY", 12, 74263},
	{"THOUGHTFUL", 10, 43565},
	{"THOUGHT", 7, 2377},
	{"THOUGHOUT", 9, 170498},
	{"THOUGH", 6, 1174},
	{"THOU", 4, 9500},
	{"THOTTBOT", 8, 130036},
	{"THOTLOCALACTIONS", 16, 225414},
	{"THOTLIB", 7, 86237},
	{"THOTICON", 8, 229591},
	{"THOTCALLBACK", 12, 235918},
	{"THOTBOOL", 8, 89881},
	{"THOSE", 5, 856},
	{"THORUGH", 7, 226300},
	{"THORTON", 7, 172203},
	{"THORSTEN", 8, 88350},
	{"THORSTEIN", 9, 252311},
	{"THORSONS", 8, 199960},
	{"THORSON", 7, 142670},
	{"THORSEN", 7, 159764},
	{"THORS", 5, 217248},
	{"THORPE", 6, 54844},
	{"THORP", 5, 92460},
	{"THOROWGOOD", 10, 231916},
	{"THOROUGHNESS", 12, 115108},
	{"THOROUGHLY", 10, 32681},
	{"THOROUGHGOING", 13, 223372},
	{"THOROUGHFARES", 13, 128022},
	{"THOROUGHFARE", 12, 101524},
	{"THOROUGHBREDS", 13, 150383},
	{"THOROUGHBRED", 12, 64191},
	{"THOROUGH", 8, 36328},
	{"THOROLD", 7, 158750},
	{"THOROGOOD", 9, 130807},
	{"THOROFARE", 9, 204424},
	{"THORNYBUSH", 10, 123827},
	{"THORNY", 6, 93275},
	{"THORNWOOD", 9, 180594},
	{"THORNTONS", 9, 193573},
	{"THORNTON", 8, 42277},
	{"THORNS", 6, 70293},
	{"THORNLEY", 8, 148589},
	{"THORNLEIGH", 10, 259834},
	{"THORNHILL", 9, 82805},
	{"THORNEY", 7, 227328},
	{"THORNES", 7, 152680},
	{"THORNE", 6, 64488},
	{"THORNDON", 8, 249924},
	{"THORNDIKE", 9, 100889},
	{"THORNDALE", 9, 159048},
	{"THORNBURY", 9, 110081},
	{"THORNBURGH", 10, 195909},
	{"THORNBURG", 9, 125012},
	{"THORNBERRYS", 11, 220736},
	{"THORNBERRY", 10, 161003},
	{"THORNABY", 8, 217230},
	{"THORN", 5, 54403},
	{"THORLOS", 7, 227044},
	{"THORLO", 6, 121725},
	{"THORLEY", 7, 189104},
	{"THORIUM", 7, 105707},
	{"THORITY", 7, 228187},
	{"THORIN", 6, 231492},
	{"THORENS", 7, 103796},
	{"THOREN", 6, 216114},
	{"THOREAU", 7, 68858},
	{"THORDIS", 7, 136073},
	{"THORBURN", 8, 144604},
	{"THORAZINE", 9, 175525},
	{"THORAX", 6, 89742},
	{"THORACOTOMY", 11, 198775},
	{"THORACIC", 8, 55921},
	{"THORAC", 6, 136614},
	{"THORA", 5, 115980},
	{"THONGS", 6, 6932},
	{"THONG", 5, 31340},
	{"THOMSONFN", 9, 132923},
	{"THOMSONFLY", 10, 234432},
	{"THOMSON", 7, 29513},
	{"THOMSEN", 7, 105985},
	{"THOMS", 5, 158271},
	{"THOMPSONVILLE", 13, 165682},
	{"THOMPSONS", 9, 135888},
	{"THOMPSON", 8, 7595},
	{"THOMPKINS", 9, 260143},
	{"THOME", 5, 118217},
	{"THOMASVS", 8, 196661},
	{"THOMASVILLE", 11, 65073},
	{"THOMASTOWN", 10, 198448},
	{"THOMASTON", 9, 98477},
	{"THOMASTIK", 9, 200624},
	{"THOMASSON", 9, 172550},
	{"THOMASS", 7, 176362},
	{"THOMASON", 8, 96532},
	{"THOMASNET", 9, 88751},
	{"THOMASINA", 9, 260981},
	{"THOMAS", 6, 2085},
	{"THOMANN", 7, 92529},
	{"THOMAE", 6, 255745},
	{"THOMA", 5, 123087},
	{"THOLE", 5, 170502},
	{"THOL", 4, 6076},
	{"THOF", 4, 3533},
	{"THOENY", 6, 222250},
	{"THOD", 4, 7646},
	{"THNKS", 5, 252819},
	{"THMY", 4, 40969},
	{"THMW", 4, 126678},
	{"THMU", 4, 41639},
	{"THMR", 4, 69467},
	{"THMP", 4, 124287},
	{"THMO", 4, 28697},
	{"THMM", 4, 117512},
	{"THMI", 4, 30642},
	{"THMG", 4, 121140},
	{"THMF", 4, 143624},
	{"THME", 4, 31035},
	{"THMD", 4, 138489},
	{"THMC", 4, 66578},
	{"THMB", 4, 125106},
	{"THMA", 4, 8184},
	{"THLY", 4, 37569},
	{"THLU", 4, 66698},
	{"THLO", 4, 32920},
	{"THLL", 4, 181593},
	{"THLI", 4, 33907},
	{"THLB", 4, 211815},
	{"THLA", 4, 33808},
	{"THKY", 4, 141476},
	{"THKW", 4, 241875},
	{"THKU", 4, 106747},
	{"THKR", 4, 110676},
	{"THKM", 4, 149865},
	{"THKL", 4, 116155},
	{"THJU", 4, 42806},
	{"THJR", 4, 151593},
	{"THJP", 4, 256346},
	{"THJ", 3, 898},
	{"THITHER", 7, 89376},
	{"THISWEEK", 8, 201556},
	{"THISTLES", 8, 134208},
	{"THISTLEDOWN", 11, 239456},
	{"THISTLE", 7, 46199},
	{"THISIS", 6, 197468},
	{"THISFISHFORUM", 13, 199451},
	{"THISDAY", 7, 247685},
	{"THISCATEGORY", 12, 48275},
	{"THIS", 4, 600},
	{"THIRUVANANTHAPURAM", 18, 104590},
	{"THIRU", 5, 211028},
	{"THIRTYTWO", 9, 220436},
	{"THIRTYSOMETHING", 15, 185637},
	{"THIRTYSIX", 9, 260725},
	{"THIRTY", 6, 8915},
	{"THIRTIETH", 9, 115393},
	{"THIRTIES", 8, 79082},
	{"THIRTEENTH", 10, 67359},
	{"THIRTEEN", 8, 599},
	{"THIRSTY", 7, 60232},
	{"THIRSTING", 9, 199838},
	{"THIRST", 6, 55403},
	{"THIRSK", 6, 124970},
	{"THIRDSPHERE", 11, 242620},
	{"THIRDS", 6, 40001},
	{"THIRDPARTY", 10, 132419},
	{"THIRDLY", 7, 67750},
	{"THIRDAGE", 8, 172332},
	{"THIRD", 5, 1907},
	{"THIOUREA", 8, 192131},
	{"THIOSULFATE", 11, 182549},
	{"THIORIDAZINE", 12, 192134},
	{"THIOREDOXIN", 11, 123463},
	{"THIOPHENE", 9, 219020},
	{"THIOPENTAL", 10, 233816},
	{"THIOLS", 6, 213707},
	{"THIOLASE", 8, 259431},
	{"THIOL", 5, 121214},
	{"THIOCYANATE", 11, 176055},
	{"THINSULATE", 10, 125880},
	{"THINNING", 8, 62570},
	{"THINNEST", 8, 123062},
	{"THINNESS", 8, 156998},
	{"THINNERS", 8, 127262},
	{"THINNER", 7, 58408},
	{"THINNED", 7, 108416},
	{"THINLY", 6, 71117},
	{"THINLINE", 8, 211533},
	{"THINKWIKI", 9, 218573},
	{"THINKVISION", 11, 183177},
	{"THINKTANKS", 10, 200339},
	{"THINKTANK", 9, 152626},
	{"THINKSTOCK", 10, 83815},
	{"THINKS", 6, 28667},
	{"THINKQUEST", 10, 138371},
	{"THINKPADS", 9, 164520},
	{"THINKPAD", 8, 35082},
	{"THINKOUTSIDE", 12, 256155},
	{"THINKMATE", 9, 170576},
	{"THINKING", 8, 5204},
	{"THINKIN", 7, 80641},
	{"THINKGEEK", 9, 55085},
	{"THINKFUN", 8, 208179},
	{"THINKFREE", 9, 131626},
	{"THINKFILM", 9, 191613},
	{"THINKEXIST", 10, 123661},
	{"THINKETH", 8, 225268},
	{"THINKERS", 8, 53566},
	{"THINKER", 7, 59014},
	{"THINKE", 6, 132889},
	{"THINKCYCLE", 10, 186486},
	{"THINKCENTRE", 11, 60505},
	{"THINKBABY", 9, 170864},
	{"THINK", 5, 761},
	{"THINGYS", 7, 254123},
	{"THINGY", 6, 68430},
	{"THINGS", 6, 1229},
	{"THINGIES", 8, 135904},
	{"THINGIE", 7, 127551},
	{"THING", 5, 845},
	{"THIMPHU", 7, 168149},
	{"THIMM", 5, 120083},
	{"THIMEROSAL", 10, 115056},
	{"THIMBLES", 8, 122857},
	{"THIMBLEBERRIES", 14, 256272},
	{"THIMBLE", 7, 96159},
	{"THILO", 5, 198594},
	{"THILL", 5, 227886},
	{"THIJS", 5, 173023},
	{"THIGPEN", 7, 148163},
	{"THIGHS", 6, 51193},
	{"THIGH", 5, 32321},
	{"THIEVING", 8, 132864},
	{"THIEVES", 7, 46909},
	{"THIEVERY", 8, 99820},
	{"THIEU", 5, 174450},
	{"THIESSEN", 8, 106883},
	{"THIERS", 6, 192389},
	{"THIERRY", 7, 54234},
	{"THIERER", 7, 249304},
	{"THIER", 5, 54051},
	{"THIENSVILLE", 11, 231957},
	{"THIEMO", 6, 253994},
	{"THIEME", 6, 113911},
	{"THIEMANN", 8, 245200},
	{"THIELEN", 7, 200954},
	{"THIELE", 6, 120303},
	{"THIEL", 5, 97343},
	{"THIEFWARE", 9, 243876},
	{"THIEF", 5, 42656},
	{"THICKNESSES", 11, 94212},
	{"THICKNESS", 9, 32897},
	{"THICKLY", 7, 110218},
	{"THICKETS", 8, 127434},
	{"THICKET", 7, 101304},
	{"THICKEST", 8, 127721},
	{"THICKER", 7, 58268},
	{"THICKENS", 8, 106415},
	{"THICKENING", 10, 84218},
	{"THICKENERS", 10, 201350},
	{"THICKENER", 9, 175764},
	{"THICKENED", 9, 90526},
	{"THICKEN", 7, 110892},
	{"THICKE", 6, 216940},
	{"THICK", 5, 5144},
	{"THICH", 5, 131055},
	{"THIBODEAUX", 10, 166796},
	{"THIBODEAU", 9, 156874},
	{"THIBODAUX", 9, 123520},
	{"THIBEAULT", 9, 207902},
	{"THIBAUT", 7, 215751},
	{"THIBAULT", 8, 113282},
	{"THIBAUDEAU", 10, 219923},
	{"THIAZOLES", 9, 255869},
	{"THIAZIDE", 8, 183348},
	{"THIAMINE", 8, 102312},
	{"THIAMIN", 7, 113429},
	{"THIAGO", 6, 201963},
	{"THIABENDAZOLE", 13, 260007},
	{"THHI", 4, 3879},
	{"THGY", 4, 183609},
	{"THGW", 4, 192346},
	{"THGU", 4, 53522},
	{"THGR", 4, 30660},
	{"THGP", 4, 195574},
	{"THGM", 4, 152393},
	{"THGL", 4, 68778},
	{"THGB", 4, 178302},
	{"THFU", 4, 38308},
	{"THFR", 4, 34474},
	{"THFO", 4, 28789},
	{"THFL", 4, 42604},
	{"THFI", 4, 34766},
	{"THFC", 4, 178054},
	{"THEYVE", 6, 169753},
	{"THEYRE", 6, 85263},
	{"THEYLL", 6, 171629},
	{"THEYD", 5, 203012},
	{"THEYARE", 7, 228128},
	{"THEY'VE", 7, 674},
	{"THEY'RE", 7, 673},
	{"THEY'LL", 7, 672},
	{"THEY'D", 6, 671},
	{"THEY", 4, 707},
	{"THEXTON", 7, 212300},
	{"THEWLIS", 7, 203190},
	{"THEUSCLINICS", 12, 166385},
	{"THEUN", 5, 260828},
	{"THETOP", 6, 236975},
	{"THETIS", 6, 124561},
	{"THETIC", 6, 225507},
	{"THETHIRDI", 9, 159767},
	{"THETFORD", 8, 89312},
	{"THESTREET", 9, 227306},
	{"THESSALY", 8, 149530},
	{"THESSALONIKI", 12, 58206},
	{"THESSALONICA", 12, 189483},
	{"THESSALONIANS", 13, 49646},
	{"THESPUNKER", 10, 254738},
	{"THESPIANS", 9, 201723},
	{"THESPIAN", 8, 157925},
	{"THESITE", 7, 171327},
	{"THESIS", 6, 28346},
	{"THESEUS", 7, 122732},
	{"THESES", 6, 50428},
	{"THESERVERSIDE", 13, 193618},
	{"THESE", 5, 811},
	{"THESCRIPTS", 10, 222365},
	{"THESAURUSLEGEND", 15, 147147},
	{"THESAURUSES", 11, 162317},
	{"THESAURUS", 9, 32286},
	{"THESAURI", 8, 75672},
	{"THESAME", 7, 231739},
	{"THERRIEN", 8, 187799},
	{"THEROUX", 7, 142764},
	{"THEROPOD", 8, 216595},
	{"THERON", 6, 63884},
	{"THERMUS", 7, 157278},
	{"THERMS", 6, 181775},
	{"THERMOTOGA", 10, 192750},
	{"THERMOSTATS", 11, 85364},
	{"THERMOSTATICALLY", 16, 222928},
	{"THERMOSTATIC", 12, 108804},
	{"THERMOSTAT", 10, 55174},
	{"THERMOSTABLE", 12, 216782},
	{"THERMOSPHERE", 12, 219394},
	{"THERMOSETTING", 13, 188968},
	{"THERMOSET", 9, 145591},
	{"THERMOS", 7, 80209},
	{"THERMOREGULATION", 16, 196980},
	{"THERMORE", 8, 204832},
	{"THERMOPYLAE", 11, 248032},
	{"THERMOPOLIS", 11, 165266},
	{"THERMOPLASTICS", 14, 129816},
	{"THERMOPLASTIC", 13, 65007},
	{"THERMOPLASMA", 12, 259961},
	{"THERMOPHYSICAL", 14, 223430},
	{"THERMOPHILUS", 12, 150027},
	{"THERMOPHILIC", 12, 162650},
	{"THERMONUCLEAR", 13, 130806},
	{"THERMOMETRY", 11, 199420},
	{"THERMOMETERS", 12, 60421},
	{"THERMOMETER", 11, 47209},
	{"THERMOMECHANICAL", 16, 231954},
	{"THERMOLIFE", 10, 150559},
	{"THERMOHALINE", 12, 191282},
	{"THERMOGRAPHY", 12, 124521},
	{"THERMOGRAPHIC", 13, 235247},
	{"THERMOGENICS", 12, 201142},
	{"THERMOGENIC", 11, 140739},
	{"THERMOGENESIS", 13, 207663},
	{"THERMOFORMING", 13, 146204},
	{"THERMOFORMED", 12, 209456},
	{"THERMOELECTRIC", 14, 108929},
	{"THERMODYNAMICS", 14, 58980},
	{"THERMODYNAMICALLY", 17, 221276},
	{"THERMODYNAMIC", 13, 68976},
	{"THERMOCOUPLES", 13, 120513},
	{"THERMOCOUPLE", 12, 82196},
	{"THERMOCLINE", 11, 171136},
	{"THERMOCHEMISTRY", 15, 237039},
	{"THERMOCHEMICAL", 14, 205770},
	{"THERMO", 6, 57648},
	{"THERMITE", 8, 223161},
	{"THERMISTORS", 11, 152559},
	{"THERMISTOR", 10, 111903},
	{"THERMIONIC", 10, 192035},
	{"THERMIC", 7, 200435},
	{"THERMAREST", 10, 184527},
	{"THERMALTAKE", 11, 58160},
	{"THERMALS", 8, 110442},
	{"THERMALROCK", 11, 156884},
	{"THERMALRIGHT", 12, 128894},
	{"THERMALON", 9, 220073},
	{"THERMALLY", 9, 82895},
	{"THERMAL", 7, 8022},
	{"THERMAGE", 8, 213261},
	{"THERMADOR", 9, 157447},
	{"THERMACAM", 9, 223884},
	{"THERMA", 6, 149290},
	{"THERM", 5, 80261},
	{"THERIOT", 7, 189796},
	{"THERION", 7, 110611},
	{"THERIAULT", 9, 174786},
	{"THERFORE", 8, 179718},
	{"THEREWITH", 9, 72412},
	{"THEREUPON", 9, 77865},
	{"THEREUNTO", 9, 152315},
	{"THEREUNDER", 10, 76735},
	{"THERETOFORE", 11, 199822},
	{"THERETO", 7, 44936},
	{"THERETHROUGH", 12, 214115},
	{"THERESIA", 8, 164005},
	{"THERESE", 7, 68013},
	{"THERESA", 7, 45961},
	{"THERES", 6, 48347},
	{"THEREON", 7, 48022},
	{"THEREOF", 7, 28477},
	{"THEREMIN", 8, 126025},
	{"THEREIS", 7, 247042},
	{"THEREIN", 7, 37416},
	{"THEREFROM", 9, 72036},
	{"THEREFORE", 9, 3274},
	{"THEREFOR", 8, 61219},
	{"THEREBY", 7, 30707},
	{"THEREBETWEEN", 12, 211050},
	{"THEREAT", 7, 192286},
	{"THEREAFTER", 10, 36254},
	{"THEREABOUTS", 11, 128161},
	{"THERE'S", 7, 670},
	{"THERE", 5, 598},
	{"THERAVADA", 9, 149491},
	{"THERAPY", 7, 6642},
	{"THERAPUTIC", 10, 179050},
	{"THERAPIES", 9, 39143},
	{"THERAPIE", 8, 99182},
	{"THERAP", 6, 223395},
	{"THERA", 5, 94072},
	{"THEPLANET", 9, 224336},
	{"THEPETE", 7, 234943},
	{"THEPEG", 6, 214335},
	{"THEOTOKOS", 9, 170369},
	{"THEOSOPHY", 9, 105031},
	{"THEOSOPHICAL", 12, 120927},
	{"THEORY", 6, 2660},
	{"THEORIZING", 10, 119079},
	{"THEORIZES", 9, 233597},
	{"THEORIZED", 9, 129268},
	{"THEORIZE", 8, 155769},
	{"THEORISTS", 9, 64133},
	{"THEORIST", 8, 86990},
	{"THEORISING", 10, 204839},
	{"THEORIES", 8, 29888},
	{"THEORIE", 7, 127032},
	{"THEORETISCHE", 12, 154224},
	{"THEORETICIANS", 13, 193417},
	{"THEORETICIAN", 12, 228192},
	{"THEORETICALLY", 13, 52417},
	{"THEORETICAL", 11, 29761},
	{"THEORETIC", 9, 71666},
	{"THEORET", 7, 209983},
	{"THEOREMS", 8, 63890},
	{"THEOREMA", 8, 250342},
	{"THEOREM", 7, 30250},
	{"THEORA", 6, 143944},
	{"THEOR", 5, 98513},
	{"THEOPHYLLINE", 12, 99468},
	{"THEOPHILUS", 10, 137384},
	{"THEOPHILE", 9, 202741},
	{"THEONERING", 10, 198626},
	{"THEOLOGYWEB", 11, 114535},
	{"THEOLOGY", 8, 30338},
	{"THEOLOGIES", 10, 159413},
	{"THEOLOGIE", 9, 241490},
	{"THEOLOGICALLY", 13, 129655},
	{"THEOLOGICAL", 11, 34157},
	{"THEOLOGICA", 10, 197364},
	{"THEOLOGIANS", 11, 76782},
	{"THEOLOGIAN", 10, 78618},
	{"THEOL", 5, 222704},
	{"THEODOSIUS", 10, 161987},
	{"THEODOSIA", 9, 229273},
	{"THEODOROS", 9, 214287},
	{"THEODORIC", 9, 211685},
	{"THEODORE", 8, 41459},
	{"THEODORAKIS", 11, 210192},
	{"THEODORA", 8, 131385},
	{"THEODOR", 7, 91347},
	{"THEODOLITE", 10, 220872},
	{"THEODICY", 8, 231405},
	{"THEODEN", 7, 191698},
	{"THEOCRATS", 9, 242334},
	{"THEOCRATIC", 10, 135850},
	{"THEOCRACY", 9, 97665},
	{"THEOBROMINE", 11, 219153},
	{"THEOBALD", 8, 119161},
	{"THENK", 5, 234072},
	{"THENCEFORTH", 11, 194766},
	{"THENCE", 6, 48447},
	{"THEN", 4, 804},
	{"THEMUZICMAN", 11, 179353},
	{"THEMSELVES", 10, 1611},
	{"THEMSELF", 8, 132949},
	{"THEMS", 5, 181612},
	{"THEMODERATEVOICE", 16, 171932},
	{"THEMISTOCLES", 12, 253354},
	{"THEMIS", 6, 118092},
	{"THEMING", 7, 158773},
	{"THEMES", 6, 5976},
	{"THEMEPARK", 9, 186966},
	{"THEMEN", 6, 103327},
	{"THEMED", 6, 43248},
	{"THEME", 5, 5013},
	{"THEMATICS", 9, 157429},
	{"THEMATICALLY", 12, 125622},
	{"THEMATIC", 8, 45605},
	{"THEMAN", 6, 250047},
	{"THEMAINSAIL", 11, 215997},
	{"THEMA", 5, 60487},
	{"THEM", 4, 775},
	{"THELONIUS", 9, 244511},
	{"THELONIOUS", 10, 98064},
	{"THELMA", 6, 70596},
	{"THELIST", 7, 58184},
	{"THELIN", 6, 243482},
	{"THELESS", 7, 239803},
	{"THELEN", 6, 150357},
	{"THELEMA", 7, 166947},
	{"THEKKADY", 8, 258083},
	{"THEIVES", 7, 219355},
	{"THEISTS", 7, 125752},
	{"THEISTIC", 8, 117940},
	{"THEIST", 6, 151973},
	{"THEISS", 6, 228290},
	{"THEISMANN", 9, 120983},
	{"THEISM", 6, 106922},
	{"THEISEN", 7, 192855},
	{"THEIRS", 6, 47654},
	{"THEIR", 5, 727},
	{"THEILER", 7, 244375},
	{"THEIL", 5, 204615},
	{"THEIF", 5, 205843},
	{"THEHUNS", 7, 169843},
	{"THEHUN", 6, 30867},
	{"THEHOTEL", 8, 257602},
	{"THEGUESTBOOK", 12, 256729},
	{"THEGASGIANT", 11, 221656},
	{"THEGAME", 7, 137747},
	{"THEFTS", 6, 80034},
	{"THEFT", 5, 8824},
	{"THEFREEDICTIONARY", 17, 79707},
	{"THEFORUM", 8, 215551},
	{"THEESE", 6, 196986},
	{"THEDRINKSHOP", 12, 150439},
	{"THEDFORD", 8, 235189},
	{"THEDELBOY", 9, 216381},
	{"THEDA", 5, 172569},
	{"THECUS", 6, 159709},
	{"THEBUGS", 7, 245658},
	{"THEBES", 6, 103747},
	{"THEBAN", 6, 195758},
	{"THEATRICS", 9, 169128},
	{"THEATRICALS", 11, 246293},
	{"THEATRICALLY", 12, 164917},
	{"THEATRICALITY", 13, 252435},
	{"THEATRICAL", 10, 39355},
	{"THEATRES", 8, 40495},
	{"THEATREORGANS", 13, 185030},
	{"THEATRELAND", 11, 176179},
	{"THEATRE", 7, 3679},
	{"THEATR", 6, 158708},
	{"THEATERWIDE", 11, 213907},
	{"THEATERS", 8, 29221},
	{"THEATERMANIA", 12, 240018},
	{"THEATER", 7, 4674},
	{"THEANINE", 8, 208880},
	{"THEALE", 6, 223350},
	{"THEAETETUS", 10, 233111},
	{"THEAD", 5, 187061},
	{"THDY", 4, 106748},
	{"THDW", 4, 141852},
	{"THDV", 4, 191225},
	{"THDU", 4, 52109},
	{"THDR", 4, 32054},
	{"THDM", 4, 223996},
	{"THDJ", 4, 158287},
	{"THDI", 4, 32185},
	{"THDF", 4, 258161},
	{"THDD", 4, 229990},
	{"THDC", 4, 178971},
	{"THDB", 4, 236085},
	{"THCU", 4, 52926},
	{"THCR", 4, 44738},
	{"THCP", 4, 185105},
	{"THCO", 4, 6388},
	{"THCM", 4, 198859},
	{"THCL", 4, 41067},
	{"THCH", 4, 31605},
	{"THCF", 4, 214818},
	{"THCE", 4, 5935},
	{"THCD", 4, 151594},
	{"THCC", 4, 156953},
	{"THCB", 4, 125107},
	{"THCA", 4, 5001},
	{"THBY", 4, 44438},
	{"THBU", 4, 37103},
	{"THBR", 4, 36944},
	{"THBP", 4, 169907},
	{"THBO", 4, 34632},
	{"THBM", 4, 214819},
	{"THBL", 4, 47948},
	{"THBF", 4, 170272},
	{"THBC", 4, 196300},
	{"THBB", 4, 139549},
	{"THBA", 4, 33822},
	{"THAYNE", 6, 221680},
	{"THAYERS", 7, 210613},
	{"THAYER", 6, 66749},
	{"THAXTON", 7, 177850},
	{"THAXTED", 7, 252414},
	{"THAWTE", 6, 67936},
	{"THAWS", 5, 201519},
	{"THAWING", 7, 104901},
	{"THAWED", 6, 96200},
	{"THAV", 4, 2502},
	{"THAUVIN", 7, 200702},
	{"THATTHE", 7, 155401},
	{"THATS", 5, 28668},
	{"THATCHING", 9, 224953},
	{"THATCHER", 8, 59613},
	{"THATCHED", 8, 93602},
	{"THATCHAM", 8, 145991},
	{"THATCH", 6, 101259},
	{"THAT'S", 6, 669},
	{"THAT", 4, 695},
	{"THASSOS", 7, 156678},
	{"THARU", 5, 255083},
	{"THARPE", 6, 247625},
	{"THARP", 5, 109817},
	{"THAROOR", 7, 176941},
	{"THAPSIGARGIN", 12, 250765},
	{"THAPAR", 6, 162750},
	{"THAPA", 5, 169981},
	{"THANX", 5, 48530},
	{"THANOS", 6, 152641},
	{"THANKYOU", 8, 60760},
	{"THANKX", 6, 213545},
	{"THANKSGIVING", 12, 33781},
	{"THANKS", 6, 597},
	{"THANKLESS", 9, 152182},
	{"THANKING", 8, 63342},
	{"THANKIES", 8, 219795},
	{"THANKFULNESS", 12, 144341},
	{"THANKFULLY", 10, 52906},
	{"THANKFULL", 9, 208265},
	{"THANKFUL", 8, 47733},
	{"THANKED", 7, 48036},
	{"THANK", 5, 1567},
	{"THANJAVUR", 9, 187687},
	{"THANGS", 6, 174327},
	{"THANGKA", 7, 217993},
	{"THANG", 5, 74920},
	{"THANET", 6, 124556},
	{"THANDIE", 7, 182051},
	{"THANATOS", 8, 161918},
	{"THAN", 4, 795},
	{"THAMMASAT", 9, 259988},
	{"THAMMARAT", 9, 250219},
	{"THAMESMEAD", 10, 165882},
	{"THAMESLINK", 10, 182113},
	{"THAMES", 6, 38462},
	{"THAME", 5, 120100},
	{"THALYS", 6, 249092},
	{"THALMANN", 8, 207695},
	{"THALLUS", 7, 255915},
	{"THALLIUM", 8, 112587},
	{"THALIS", 6, 168680},
	{"THALIDOMIDE", 11, 106010},
	{"THALIANA", 8, 59067},
	{"THALIA", 6, 91511},
	{"THALI", 5, 195746},
	{"THALGO", 6, 231909},
	{"THALES", 6, 88915},
	{"THALER", 6, 111450},
	{"THALE", 5, 229900},
	{"THALASSOTHERAPY", 15, 205549},
	{"THALASSO", 8, 168876},
	{"THALASSIOSIRA", 13, 236271},
	{"THALASSEMIA", 11, 122580},
	{"THALASSAEMIA", 12, 193215},
	{"THALASSA", 8, 200125},
	{"THALAMUS", 8, 113891},
	{"THALAMIC", 8, 137132},
	{"THAKUR", 6, 127725},
	{"THAKSIN", 7, 129833},
	{"THAKKAR", 7, 220533},
	{"THAIR", 5, 248340},
	{"THAIMASSAGE", 11, 198336},
	{"THAILAND", 8, 5082},
	{"THAG", 4, 32646},
	{"THAF", 4, 8522},
	{"THADDEUS", 8, 100800},
	{"THACKERAY", 9, 116184},
	{"THACKER", 7, 108860},
	{"THACHER", 7, 158886},
	{"THACH", 5, 253726},
	{"THAC", 4, 9833},
	{"THABO", 5, 133804},
	{"THAB", 4, 28875},
	{"TGZ", 3, 283},
	{"TGYM", 4, 133132},
	{"TGY", 3, 30380},
	{"TGWU", 4, 242524},
	{"TGWI", 4, 225798},
	{"TGWE", 4, 196457},
	{"TGWA", 4, 226984},
	{"TGUY", 4, 51138},
	{"TGUT", 4, 117719},
	{"TGUS", 4, 128658},
	{"TGUR", 4, 121462},
	{"TGUN", 4, 47784},
	{"TGUM", 4, 148329},
	{"TGUL", 4, 107742},
	{"TGUI", 4, 50500},
	{"TGUE", 4, 69149},
	{"TGUA", 4, 38636},
	{"TGU", 3, 869},
	{"TGSTORES", 8, 209376},
	{"TGRU", 4, 110677},
	{"TGRO", 4, 28319},
	{"TGRI", 4, 57032},
	{"TGRE", 4, 32441},
	{"TGRA", 4, 31139},
	{"TGPS", 4, 134725},
	{"TGP", 3, 30972},
	{"TGOY", 4, 261577},
	{"TGOW", 4, 85039},
	{"TGOV", 4, 38786},
	{"TGOU", 4, 92198},
	{"TGOT", 4, 35853},
	{"TGOR", 4, 72480},
	{"TGOP", 4, 121793},
	{"TGOO", 4, 35667},
	{"TGOM", 4, 49570},
	{"TGOL", 4, 48694},
	{"TGOK", 4, 242171},
	{"TGOI", 4, 29397},
	{"TGOG", 4, 177070},
	{"TGOF", 4, 86960},
	{"TGOD", 4, 51100},
	{"TGOC", 4, 210679},
	{"TGOB", 4, 78382},
	{"TGNR", 4, 257399},
	{"TGMT", 4, 137931},
	{"TGMS", 4, 189684},
	{"TGMI", 4, 258899},
	{"TGMC", 4, 251793},
	{"TGMA", 4, 150732},
	{"TGLY", 4, 218172},
	{"TGLU", 4, 148847},
	{"TGLO", 4, 54904},
	{"TGLI", 4, 101534},
	{"TGLE", 4, 81136},
	{"TGLA", 4, 56204},
	{"TGIV", 4, 30799},
	{"TGIU", 4, 226985},
	{"TGIRLS", 6, 118138},
	{"TGIRL", 5, 102082},
	{"TGIR", 4, 58896},
	{"TGIM", 4, 202578},
	{"TGIL", 4, 72518},
	{"TGIG", 4, 105168},
	{"TGIF", 4, 97579},
	{"TGID", 4, 250700},
	{"TGIB", 4, 95063},
	{"TGHZ", 4, 208505},
	{"TGGCA", 5, 233331},
	{"TGET", 4, 7167},
	{"TGER", 4, 41086},
	{"TGEM", 4, 152792},
	{"TGEL", 4, 143770},
	{"TGED", 4, 245744},
	{"TGEB", 4, 248169},
	{"TGDP", 4, 144972},
	{"TGCGC", 5, 230992},
	{"TGAZ", 4, 101187},
	{"TGAY", 4, 82398},
	{"TGAV", 4, 46733},
	{"TGAR", 4, 43891},
	{"TGAP", 4, 86715},
	{"TGAM", 4, 28170},
	{"TGAL", 4, 51402},
	{"TGAG", 4, 35369},
	{"TGAD", 4, 162700},
	{"TGAB", 4, 110630},
	{"TFWA", 4, 225550},
	{"TFUZ", 4, 213218},
	{"TFUT", 4, 63277},
	{"TFUS", 4, 115706},
	{"TFUR", 4, 50514},
	{"TFUN", 4, 36891},
	{"TFUM", 4, 133916},
	{"TFUL", 4, 31395},
	{"TFUJ", 4, 159021},
	{"TFUG", 4, 201463},
	{"TFUE", 4, 73079},
	{"TFUD", 4, 260055},
	{"TFUC", 4, 158590},
	{"TFTPD", 5, 230099},
	{"TFTPBOOT", 8, 198275},
	{"TFTP", 4, 64593},
	{"TFTM", 4, 203283},
	{"TFSY", 4, 250119},
	{"TFSU", 4, 216657},
	{"TFSAT", 5, 258813},
	{"TFRY", 4, 173431},
	{"TFRU", 4, 74588},
	{"TFRO", 4, 3006},
	{"TFRI", 4, 35987},
	{"TFRE", 4, 33732},
	{"TFRC", 4, 256835},
	{"TFRA", 4, 39231},
	{"TFPSAT", 6, 259044},
	{"TFOX", 4, 80902},
	{"TFOW", 4, 209686},
	{"TFOU", 4, 28682},
	{"TFOR", 4, 250977},
	{"TFOO", 4, 35846},
	{"TFOL", 4, 31004},
	{"TFOG", 4, 184095},
	{"TFOC", 4, 53657},
	{"TFMB", 4, 240331},
	{"TFMA", 4, 222861},
	{"TFLY", 4, 62460},
	{"TFLU", 4, 73697},
	{"TFLO", 4, 37978},
	{"TFLIGHT", 7, 246569},
	{"TFLI", 4, 47975},
	{"TFLE", 4, 58827},
	{"TFLA", 4, 45935},
	{"TFKE", 4, 215463},
	{"TFIZ", 4, 261203},
	{"TFIXEDIMAGE", 11, 195627},
	{"TFIX", 4, 66173},
	{"TFIV", 4, 34972},
	{"TFIR", 4, 8906},
	{"TFIN", 4, 9975},
	{"TFILE", 5, 213722},
	{"TFIL", 4, 35839},
	{"TFIJ", 4, 261953},
	{"TFIID", 5, 206828},
	{"TFIG", 4, 37518},
	{"TFIF", 4, 72066},
	{"TFIE", 4, 34033},
	{"TFID", 4, 139853},
	{"TFIC", 4, 113878},
	{"TFIB", 4, 142885},
	{"TFEW", 4, 34472},
	{"TFEV", 4, 158517},
	{"TFEU", 4, 184096},
	{"TFER", 4, 63697},
	{"TFEM", 4, 63850},
	{"TFEL", 4, 41643},
	{"TFEE", 4, 31358},
	{"TFED", 4, 58038},
	{"TFEB", 4, 82076},
	{"TFEA", 4, 36341},
	{"TFDI", 4, 252838},
	{"TFCO", 4, 253897},
	{"TFC", 3, 241},
	{"TFBI", 4, 249780},
	{"TFAZ", 4, 199689},
	{"TFAY", 4, 183242},
	{"TFAVEL", 6, 259371},
	{"TFAV", 4, 52901},
	{"TFAU", 4, 81412},
	{"TFAR", 4, 41423},
	{"TFAM", 4, 37362},
	{"TFAL", 4, 37254},
	{"TFAK", 4, 144973},
	{"TFAG", 4, 255992},
	{"TFAD", 4, 109628},
	{"TFAC", 4, 35734},
	{"TFAB", 4, 109374},
	{"TEZW", 4, 192912},
	{"TEZUKA", 6, 161563},
	{"TEZU", 4, 131274},
	{"TEZR", 4, 232957},
	{"TEZC", 4, 236348},
	{"TEYW", 4, 210298},
	{"TEYU", 4, 239866},
	{"TEYR", 4, 182639},
	{"TEYM", 4, 221699},
	{"TEYL", 4, 235778},
	{"TEXX", 4, 229746},
	{"TEXW", 4, 154582},
	{"TEXU", 4, 185359},
	{"TEXTY", 5, 201724},
	{"TEXTWIDTH", 9, 233606},
	{"TEXTVERSION", 11, 249187},
	{"TEXTUTILS", 9, 164285},
	{"TEXTUS", 6, 53984},
	{"TEXTURING", 9, 91210},
	{"TEXTURES", 8, 42109},
	{"TEXTURED", 8, 48302},
	{"TEXTURE", 7, 33454},
	{"TEXTURAL", 8, 114419},
	{"TEXTUALLY", 9, 185026},
	{"TEXTUALITY", 10, 235708},
	{"TEXTUAL", 7, 46972},
	{"TEXTTT", 6, 58804},
	{"TEXTSIZE", 8, 236259},
	{"TEXTS", 5, 9210},
	{"TEXTRON", 7, 104700},
	{"TEXTRM", 6, 56945},
	{"TEXTPROC", 8, 113160},
	{"TEXTPHONE", 9, 152194},
	{"TEXTPATTERN", 11, 106398},
	{"TEXTPAD", 7, 198564},
	{"TEXTOS", 6, 141837},
	{"TEXTOR", 6, 249001},
	{"TEXTONLY", 8, 237881},
	{"TEXTO", 5, 86876},
	{"TEXTMATE", 8, 206060},
	{"TEXTIT", 6, 228164},
	{"TEXTISM", 7, 260545},
	{"TEXTING", 7, 110610},
	{"TEXTILES", 8, 36010},
	{"TEXTILE", 7, 33362},
	{"TEXTIL", 6, 182602},
	{"TEXTIEL", 7, 227056},
	{"TEXTFORMATTINGRULES", 19, 107971},
	{"TEXTFORMATTINGFAQ", 17, 157661},
	{"TEXTFILE", 8, 107725},
	{"TEXTFIELD", 9, 118520},
	{"TEXTES", 6, 136435},
	{"TEXTER", 6, 236621},
	{"TEXTEDITOR", 10, 243861},
	{"TEXTEDIT", 8, 191259},
	{"TEXTED", 6, 244297},
	{"TEXTE", 5, 71589},
	{"TEXTDRIVE", 9, 127977},
	{"TEXTDATA", 8, 135480},
	{"TEXTCOLOR", 9, 216015},
	{"TEXTCLICK", 9, 125324},
	{"TEXTBOXES", 9, 216237},
	{"TEXTBOX", 7, 85668},
	{"TEXTBOOKX", 9, 124613},
	{"TEXTBOOKS", 9, 6224},
	{"TEXTBOOK", 8, 33511},
	{"TEXTBF", 6, 220592},
	{"TEXTBASE", 8, 185829},
	{"TEXTAREA", 8, 79210},
	{"TEXTAMERICA", 11, 123961},
	{"TEXTALOUD", 9, 259956},
	{"TEXT", 4, 3596},
	{"TEXSTAR", 7, 227411},
	{"TEXSPORT", 8, 204239},
	{"TEXSHOP", 7, 214095},
	{"TEXSHARE", 8, 226432},
	{"TEXREG", 6, 177550},
	{"TEXR", 4, 219055},
	{"TEXP", 4, 8106},
	{"TEXOMA", 6, 145141},
	{"TEXMF", 5, 58363},
	{"TEXMACS", 7, 89625},
	{"TEXM", 4, 145748},
	{"TEXLIVE", 7, 148773},
	{"TEXL", 4, 233852},
	{"TEXIS", 5, 190877},
	{"TEXINFO", 7, 68220},
	{"TEXIFY", 6, 242159},
	{"TEXIER", 6, 261796},
	{"TEXICAN", 7, 261083},
	{"TEXHAX", 6, 200944},
	{"TEXG", 4, 230589},
	{"TEXF", 4, 186127},
	{"TEXES", 5, 161156},
	{"TEXEL", 5, 156454},
	{"TEXD", 4, 231836},
	{"TEXC", 4, 38139},
	{"TEXB", 4, 198860},
	{"TEXASUSA", 8, 182214},
	{"TEXASS", 6, 260731},
	{"TEXASONLINE", 11, 256225},
	{"TEXASHOLDEM", 11, 204396},
	{"TEXASBESTGROK", 13, 261917},
	{"TEXAS", 5, 1319},
	{"TEXARKANA", 9, 70541},
	{"TEXANS", 6, 51472},
	{"TEXANA", 6, 176746},
	{"TEXAN", 5, 62657},
	{"TEXADA", 6, 203604},
	{"TEXACO", 6, 74674},
	{"TEWW", 4, 81275},
	{"TEWR", 4, 91095},
	{"TEWKSBURY", 9, 100739},
	{"TEWKESBURY", 10, 97532},
	{"TEWK", 4, 141729},
	{"TEWI", 4, 8181},
	{"TEWH", 4, 30804},
	{"TEWARI", 6, 240698},
	{"TEVU", 4, 261578},
	{"TEVION", 6, 167762},
	{"TEVF", 4, 244616},
	{"TEVET", 5, 164277},
	{"TEVES", 5, 235649},
	{"TEVATRON", 8, 123580},
	{"TEUTONIC", 8, 98630},
	{"TEUR", 4, 252119},
	{"TEUP", 4, 68011},
	{"TEUM", 4, 130407},
	{"TEULU", 5, 225153},
	{"TEUL", 4, 174352},
	{"TEUKOLSKY", 9, 260634},
	{"TEUK", 4, 241595},
	{"TEUG", 4, 148330},
	{"TEUFEL", 6, 171175},
	{"TEUF", 4, 221937},
	{"TEUCHOS", 7, 245502},
	{"TEUC", 4, 147481},
	{"TEUBNER", 7, 210445},
	{"TEUB", 4, 141783},
	{"TETSUYA", 7, 145406},
	{"TETSURO", 7, 255339},
	{"TETSUO", 6, 136899},
	{"TETSUJIN", 8, 194462},
	{"TETSU", 5, 199907},
	{"TETRODOTOXIN", 12, 190229},
	{"TETRIX", 6, 219689},
	{"TETRIS", 6, 51930},
	{"TETRINETX", 9, 258708},
	{"TETRAZOLIUM", 11, 207106},
	{"TETRAS", 6, 206726},
	{"TETRAPLOID", 10, 199943},
	{"TETRAODON", 9, 137856},
	{"TETRAMETHYL", 11, 217006},
	{"TETRAMER", 8, 166210},
	{"TETRALOGY", 9, 182267},
	{"TETRAHYMENA", 11, 182579},
	{"TETRAHYDROFURAN", 15, 204258},
	{"TETRAHYDROFOLATE", 16, 239180},
	{"TETRAHYDROCANNABINOL", 20, 194488},
	{"TETRAHYDRO", 10, 183174},
	{"TETRAHEDRON", 11, 92155},
	{"TETRAHEDRAL", 11, 132767},
	{"TETRAHEDRA", 10, 180015},
	{"TETRAGONAL", 10, 176545},
	{"TETRADRACHM", 11, 218970},
	{"TETRADECANOYLPHORBOL", 20, 179177},
	{"TETRAD", 6, 191281},
	{"TETRACYCLINES", 13, 181395},
	{"TETRACYCLINE", 12, 76812},
	{"TETRACHLOROETHYLENE", 19, 184461},
	{"TETRACHLORODIBENZO", 18, 228434},
	{"TETRACHLORIDE", 13, 117489},
	{"TETRACAINE", 10, 258849},
	{"TETRA", 5, 65153},
	{"TETOVO", 6, 229696},
	{"TETONS", 6, 159707},
	{"TETONAS", 7, 154435},
	{"TETONA", 6, 255428},
	{"TETLEY", 6, 151058},
	{"TETHYS", 6, 156733},
	{"TETHERS", 7, 151810},
	{"TETHERING", 9, 189469},
	{"TETHERED", 8, 97937},
	{"TETHERBALL", 10, 258092},
	{"TETHER", 6, 93518},
	{"TETH", 4, 2214},
	{"TETEX", 5, 54025},
	{"TETEVEN", 7, 202668},
	{"TETERBORO", 9, 166583},
	{"TETER", 5, 220351},
	{"TETENAL", 7, 241746},
	{"TETBURY", 7, 166530},
	{"TETANUS", 7, 71530},
	{"TESW", 4, 8179},
	{"TESUQUE", 7, 202653},
	{"TESU", 4, 34937},
	{"TESTZUGANG", 10, 103373},
	{"TESTY", 5, 126364},
	{"TESTUSER", 8, 248387},
	{"TESTUN", 6, 192150},
	{"TESTSUITE", 9, 52446},
	{"TESTS", 5, 3035},
	{"TESTRESULTS", 11, 122618},
	{"TESTOSTERONE", 12, 45032},
	{"TESTORS", 7, 128240},
	{"TESTNG", 6, 239665},
	{"TESTMART", 8, 228146},
	{"TESTLET", 7, 254495},
	{"TESTKING", 8, 118881},
	{"TESTIS", 6, 74489},
	{"TESTINO", 7, 256182},
	{"TESTINGS", 8, 220935},
	{"TESTINGCODE", 11, 226380},
	{"TESTING", 7, 7708},
	{"TESTIN", 6, 251373},
	{"TESTIMONY", 9, 8272},
	{"TESTIMONIES", 11, 62095},
	{"TESTIMONIALS", 12, 7450},
	{"TESTIMONIAL", 11, 53628},
	{"TESTIMONALS", 11, 250029},
	{"TESTIFYING", 10, 77483},
	{"TESTIFY", 7, 8785},
	{"TESTIFIES", 9, 84572},
	{"TESTIFIED", 9, 41505},
	{"TESTICULAR", 10, 67180},
	{"TESTICLES", 9, 68400},
	{"TESTICLE", 8, 94246},
	{"TESTFILE", 8, 257742},
	{"TESTES", 6, 93332},
	{"TESTERS", 7, 41706},
	{"TESTER", 6, 41070},
	{"TESTENV", 7, 134300},
	{"TESTEN", 6, 211787},
	{"TESTED", 6, 5428},
	{"TESTDRIVE", 9, 188974},
	{"TESTDIRECTOR", 12, 205367},
	{"TESTCASES", 9, 90272},
	{"TESTCASE", 8, 93395},
	{"TESTBERICHTE", 12, 161647},
	{"TESTBENCH", 9, 192584},
	{"TESTBEDS", 8, 191059},
	{"TESTBED", 7, 78991},
	{"TESTAVERDE", 10, 189499},
	{"TESTATOR", 8, 110085},
	{"TESTAROSSA", 10, 217338},
	{"TESTAMENTS", 10, 105061},
	{"TESTAMENTARY", 12, 127917},
	{"TESTAMENT", 9, 32077},
	{"TESTABLE", 8, 101681},
	{"TESTABILITY", 11, 147573},
	{"TEST", 4, 240},
	{"TESSMAN", 7, 228362},
	{"TESSLER", 7, 225285},
	{"TESSIER", 7, 147248},
	{"TESSIE", 6, 177795},
	{"TESSERACT", 9, 211610},
	{"TESSERA", 7, 177757},
	{"TESSELLATIONS", 13, 209452},
	{"TESSELLATION", 12, 180404},
	{"TESSCO", 6, 148694},
	{"TESSAR", 6, 171635},
	{"TESP", 4, 29419},
	{"TESORO", 6, 103370},
	{"TESOL", 5, 80624},
	{"TESM", 4, 35080},
	{"TESLA", 5, 59025},
	{"TESKE", 5, 225399},
	{"TESHUVAH", 8, 249551},
	{"TESHUVA", 7, 238748},
	{"TESF", 4, 28851},
	{"TESCOS", 6, 232938},
	{"TESCO", 5, 41030},
	{"TESCH", 5, 230657},
	{"TESB", 4, 31916},
	{"TESAR", 5, 246552},
	{"TERZO", 5, 217222},
	{"TERZA", 5, 222040},
	{"TERZ", 4, 74418},
	{"TERY", 4, 197520},
	{"TERX", 4, 115405},
	{"TERWILLIGER", 11, 161976},
	{"TERW", 4, 2953},
	{"TERVUREN", 8, 143241},
	{"TERVIS", 6, 234675},
	{"TERV", 4, 5475},
	{"TERUMO", 6, 242047},
	{"TERUG", 5, 98844},
	{"TERUEL", 6, 188407},
	{"TERU", 4, 227818},
	{"TERTULLIAN", 10, 148757},
	{"TERTIUS", 7, 250538},
	{"TERTIARY", 8, 44037},
	{"TERTIA", 6, 252568},
	{"TERSELY", 7, 257725},
	{"TERSE", 5, 100666},
	{"TERRYVILLE", 10, 205182},
	{"TERRYTOWN", 9, 221448},
	{"TERRYCLOTH", 10, 208081},
	{"TERRY", 5, 8125},
	{"TERRORS", 7, 87676},
	{"TERRORIZING", 11, 131556},
	{"TERRORIZER", 10, 204301},
	{"TERRORIZED", 10, 120512},
	{"TERRORIZE", 9, 125974},
	{"TERRORISTS", 10, 32199},
	{"TERRORISTIC", 11, 196499},
	{"TERRORIST", 9, 8576},
	{"TERRORISMO", 10, 228912},
	{"TERRORISM", 9, 7671},
	{"TERRORISED", 10, 238148},
	{"TERRORISE", 9, 244417},
	{"TERRORGRUPPE", 12, 238300},
	{"TERRORCRAFT", 11, 217387},
	{"TERROR", 6, 8472},
	{"TERROIR", 7, 156440},
	{"TERRITORY", 9, 6830},
	{"TERRITORIO", 10, 190913},
	{"TERRITORIES", 11, 28338},
	{"TERRITORIE", 10, 249004},
	{"TERRITORIANS", 12, 237461},
	{"TERRITORIALITY", 14, 175489},
	{"TERRITORIAL", 11, 40999},
	{"TERRITOIRES", 11, 189791},
	{"TERRITOIRE", 10, 162243},
	{"TERRITO", 7, 210185},
	{"TERRIS", 6, 164026},
	{"TERRINE", 7, 169326},
	{"TERRILL", 7, 136228},
	{"TERRIGENOUS", 11, 169018},
	{"TERRIGAL", 8, 158031},
	{"TERRIFYINGLY", 12, 250555},
	{"TERRIFYING", 10, 60429},
	{"TERRIFY", 7, 159741},
	{"TERRIFIES", 9, 215897},
	{"TERRIFIED", 9, 60725},
	{"TERRIFICALLY", 12, 197070},
	{"TERRIFIC", 8, 32721},
	{"TERRIERS", 8, 64636},
	{"TERRIER", 7, 37883},
	{"TERRIE", 6, 123207},
	{"TERRIBLY", 8, 35624},
	{"TERRIBLES", 9, 235307},
	{"TERRIBLE", 8, 5936},
	{"TERRI", 5, 41978},
	{"TERRESTRIS", 10, 131307},
	{"TERRESTRIALS", 12, 215908},
	{"TERRESTRIAL", 11, 42385},
	{"TERRESTRE", 9, 205317},
	{"TERRES", 6, 141705},
	{"TERRENO", 7, 172254},
	{"TERRENCE", 8, 65892},
	{"TERRELL", 7, 58623},
	{"TERREL", 6, 255116},
	{"TERREBONNE", 10, 110423},
	{"TERRE", 5, 49493},
	{"TERRAZZO", 8, 114225},
	{"TERRAZAS", 8, 208037},
	{"TERRAZA", 7, 150689},
	{"TERRAVITA", 9, 209936},
	{"TERRATEC", 8, 101503},
	{"TERRASSE", 8, 171152},
	{"TERRASERVER", 11, 71233},
	{"TERRAS", 6, 217845},
	{"TERRARIUMS", 10, 199226},
	{"TERRARIUM", 9, 138528},
	{"TERRAPINS", 9, 85164},
	{"TERRAPIN", 8, 109247},
	{"TERRANS", 7, 176037},
	{"TERRANOVA", 9, 125591},
	{"TERRANO", 7, 169071},
	{"TERRANES", 8, 227398},
	{"TERRANE", 7, 183516},
	{"TERRANCE", 8, 83357},
	{"TERRAN", 6, 91689},
	{"TERRAMAR", 8, 166356},
	{"TERRAINS", 8, 117885},
	{"TERRAIN", 7, 33755},
	{"TERRAGEN", 8, 131216},
	{"TERRAFORMING", 12, 206761},
	{"TERRAE", 6, 247051},
	{"TERRACOTTA", 10, 77786},
	{"TERRACING", 9, 208897},
	{"TERRACES", 8, 65020},
	{"TERRACED", 8, 74445},
	{"TERRACE", 7, 31637},
	{"TERRACAN", 8, 249986},
	{"TERRA", 5, 39699},
	{"TERR", 4, 68147},
	{"TERQ", 4, 57184},
	{"TERPSTRA", 8, 173856},
	{"TERPSICHORE", 11, 254557},
	{"TERPS", 5, 115223},
	{"TERPENES", 8, 207513},
	{"TERPENE", 7, 229661},
	{"TERPANDRUS", 10, 169657},
	{"TERP", 4, 195031},
	{"TERNS", 5, 96030},
	{"TERNI", 5, 181085},
	{"TERNET", 6, 261697},
	{"TERNATIONAL", 11, 162689},
	{"TERNARY", 7, 93842},
	{"TERNAL", 6, 181406},
	{"TERMS", 5, 3738},
	{"TERMPAPERS", 10, 146892},
	{"TERMPAPER", 9, 223978},
	{"TERMOS", 6, 223909},
	{"TERMLY", 6, 168402},
	{"TERMITES", 8, 78616},
	{"TERMITE", 7, 67896},
	{"TERMIOS", 7, 188550},
	{"TERMINUS", 8, 57583},
	{"TERMINOS", 8, 229028},
	{"TERMINOLOGY", 11, 36439},
	{"TERMINOLOGIES", 13, 144998},
	{"TERMINOLOGICAL", 14, 154476},
	{"TERMINO", 7, 224822},
	{"TERMINIX", 8, 167166},
	{"TERMINI", 7, 89150},
	{"TERMING", 7, 249594},
	{"TERMINFO", 8, 104512},
	{"TERMINED", 8, 183904},
	{"TERMINE", 7, 98251},
	{"TERMINATORS", 11, 112792},
	{"TERMINATOR", 10, 47539},
	{"TERMINATIONS", 12, 74972},
	{"TERMINATION", 11, 28468},
	{"TERMINATING", 11, 53778},
	{"TERMINATES", 10, 57349},
	{"TERMINATED", 10, 37197},
	{"TERMINATE", 9, 37419},
	{"TERMINALS", 9, 36481},
	{"TERMINALLY", 10, 78053},
	{"TERMINALIA", 10, 246306},
	{"TERMINAL", 8, 5675},
	{"TERMINABLE", 10, 226354},
	{"TERMINA", 7, 194556},
	{"TERMIN", 6, 177437},
	{"TERMIDOR", 8, 193294},
	{"TERMI", 5, 146604},
	{"TERMES", 6, 143439},
	{"TERMED", 6, 50102},
	{"TERME", 5, 76058},
	{"TERMCAP", 7, 120515},
	{"TERMAN", 6, 208661},
	{"TERM", 4, 2007},
	{"TERLINGUA", 9, 203774},
	{"TERL", 4, 5945},
	{"TERKEL", 6, 195030},
	{"TERK", 4, 88361},
	{"TERJE", 5, 113814},
	{"TERJ", 4, 32688},
	{"TERIYAKI", 8, 95350},
	{"TERISTICS", 9, 179637},
	{"TERING", 6, 162365},
	{"TERIALS", 7, 235898},
	{"TERIAL", 6, 194905},
	{"TERIA", 5, 200503},
	{"TERHUNE", 7, 197802},
	{"TERH", 4, 3509},
	{"TERG", 4, 8810},
	{"TERFENADINE", 11, 230406},
	{"TERFEL", 6, 189118},
	{"TERFACE", 7, 258512},
	{"TERF", 4, 3307},
	{"TEREZIN", 7, 261000},
	{"TEREZA", 6, 199918},
	{"TEREX", 5, 164535},
	{"TEREST", 6, 176109},
	{"TERESITA", 8, 202715},
	{"TERESE", 6, 198449},
	{"TERESA", 6, 40701},
	{"TERES", 5, 209766},
	{"TEREPHTHALATE", 13, 162318},
	{"TERENGGANU", 10, 130194},
	{"TERENCE", 7, 57771},
	{"TERENA", 6, 199880},
	{"TERED", 5, 113306},
	{"TERD", 4, 4758},
	{"TERCERA", 7, 202018},
	{"TERCER", 6, 201821},
	{"TERCENTENARY", 12, 140954},
	{"TERCEL", 6, 124054},
	{"TERC", 4, 203485},
	{"TERBUTALINE", 11, 181228},
	{"TERBIUM", 7, 249333},
	{"TERBINAFINE", 11, 182246},
	{"TERB", 4, 3377},
	{"TERAZOSIN", 9, 198488},
	{"TERAZ", 5, 249328},
	{"TERAYON", 7, 252775},
	{"TERAX", 5, 209587},
	{"TERAVISION", 10, 240958},
	{"TERATOMA", 8, 184684},
	{"TERATOLOGY", 10, 131781},
	{"TERATOGENICITY", 14, 189276},
	{"TERATOGENIC", 11, 144899},
	{"TERASTATION", 11, 260414},
	{"TERASEN", 7, 249741},
	{"TERAPIN", 7, 245588},
	{"TERAPIA", 7, 107607},
	{"TERAN", 5, 219599},
	{"TERAMO", 6, 209755},
	{"TERAI", 5, 182994},
	{"TERAHERTZ", 9, 174780},
	{"TERAH", 5, 238911},
	{"TERAGRID", 8, 206076},
	{"TERAFLOPS", 9, 257961},
	{"TERADYNE", 8, 178338},
	{"TERADATA", 8, 126899},
	{"TERADA", 6, 198940},
	{"TERACTION", 9, 249975},
	{"TERABYTES", 9, 102807},
	{"TERABYTE", 8, 107906},
	{"TERABITHIA", 10, 235887},
	{"TEQUILLA", 8, 242891},
	{"TEQUILA", 7, 59966},
	{"TEQUESTA", 8, 194441},
	{"TEQU", 4, 42190},
	{"TEPY", 4, 202400},
	{"TEPW", 4, 79783},
	{"TEPU", 4, 47328},
	{"TEPPER", 6, 116935},
	{"TEPPANYAKI", 10, 249759},
	{"TEPP", 4, 37566},
	{"TEPO", 4, 35577},
	{"TEPM", 4, 75017},
	{"TEPLICE", 7, 197305},
	{"TEPL", 4, 43048},
	{"TEPID", 5, 112424},
	{"TEPHRA", 6, 205538},
	{"TEPH", 4, 32145},
	{"TEPG", 4, 161944},
	{"TEPF", 4, 55905},
	{"TEPEE", 5, 214954},
	{"TEPD", 4, 70070},
	{"TEPC", 4, 87794},
	{"TEPB", 4, 62647},
	{"TEPA", 4, 32419},
	{"TEOTIHUACAN", 11, 195362},
	{"TEORIA", 6, 155222},
	{"TEOMACOM", 8, 233922},
	{"TEOMAA", 6, 233992},
	{"TEOMA", 5, 69333},
	{"TEOF", 4, 3950},
	{"TEODORO", 7, 165528},
	{"TEODOR", 6, 210622},
	{"TENZING", 7, 239537},
	{"TENZIN", 6, 162197},
	{"TENUTA", 6, 172806},
	{"TENURES", 7, 153041},
	{"TENURED", 7, 77277},
	{"TENURE", 6, 37366},
	{"TENUOUS", 7, 91840},
	{"TENUIS", 6, 238043},
	{"TENUE", 5, 187289},
	{"TENUATE", 7, 52408},
	{"TENTION", 7, 194165},
	{"TENTING", 7, 190685},
	{"TENTIAL", 7, 163625},
	{"TENTHS", 6, 81857},
	{"TENTERFIELD", 11, 235975},
	{"TENTERDEN", 9, 161281},
	{"TENTER", 6, 188488},
	{"TENTED", 6, 65516},
	{"TENTEC", 6, 87132},
	{"TENTATIVELY", 11, 66703},
	{"TENTATIVE", 9, 44666},
	{"TENTANG", 7, 184418},
	{"TENTACLES", 9, 76214},
	{"TENTACLE", 8, 74295},
	{"TENSORS", 7, 122884},
	{"TENSOR", 6, 56388},
	{"TENSIVE", 7, 257233},
	{"TENSIONS", 8, 48714},
	{"TENSIONING", 10, 129644},
	{"TENSIONERS", 10, 152750},
	{"TENSIONER", 9, 125572},
	{"TENSIONED", 9, 133625},
	{"TENSION", 7, 6929},
	{"TENSING", 7, 191999},
	{"TENSILICA", 9, 241799},
	{"TENSILE", 7, 60064},
	{"TENSHI", 6, 167269},
	{"TENSES", 6, 103611},
	{"TENSER", 6, 256197},
	{"TENSELY", 7, 153884},
	{"TENSEI", 6, 190114},
	{"TENSED", 6, 136482},
	{"TENSAS", 6, 202091},
	{"TENROX", 6, 179417},
	{"TENPIN", 6, 211295},
	{"TENOSYNOVITIS", 13, 257354},
	{"TENORS", 6, 98781},
	{"TENORMIN", 8, 156826},
	{"TENORIO", 7, 217012},
	{"TENOR", 5, 45854},
	{"TENOFOVIR", 9, 157773},
	{"TENNYSON", 8, 80272},
	{"TENNY", 5, 230757},
	{"TENNSCO", 7, 232565},
	{"TENNISTENNIS", 12, 196806},
	{"TENNISON", 8, 123876},
	{"TENNISCHAMPION", 14, 206707},
	{"TENNIS", 6, 10124},
	{"TENNILLE", 8, 189072},
	{"TENNIEL", 7, 252009},
	{"TENNEY", 6, 121116},
	{"TENNESSEE", 9, 4187},
	{"TENNESSEANS", 11, 201628},
	{"TENNESSEAN", 10, 104571},
	{"TENNESSE", 8, 134257},
	{"TENNESEE", 8, 150956},
	{"TENNER", 6, 142684},
	{"TENNENT", 7, 155585},
	{"TENNECO", 7, 186600},
	{"TENNCARE", 8, 127188},
	{"TENNANTS", 8, 204238},
	{"TENNANT", 7, 74905},
	{"TENMILE", 7, 235575},
	{"TENKO", 5, 261768},
	{"TENKAICHI", 9, 91836},
	{"TENJHO", 6, 190813},
	{"TENIR", 5, 217768},
	{"TENINO", 6, 236026},
	{"TENIENDO", 8, 141194},
	{"TENIDO", 6, 251712},
	{"TENGU", 5, 182419},
	{"TENGO", 5, 82006},
	{"TENGGARA", 8, 154344},
	{"TENGE", 5, 86375},
	{"TENGAH", 6, 177163},
	{"TENGA", 5, 137722},
	{"TENFOLD", 7, 118381},
	{"TENEX", 5, 171835},
	{"TENETS", 6, 74585},
	{"TENERIFE", 8, 50381},
	{"TENER", 5, 103414},
	{"TENENT", 6, 239736},
	{"TENENS", 6, 189355},
	{"TENENBAUMS", 10, 137661},
	{"TENENBAUM", 9, 165852},
	{"TENEMOS", 7, 151142},
	{"TENEMENTS", 9, 123055},
	{"TENEMENT", 8, 86772},
	{"TENEBRIL", 8, 258276},
	{"TENEBRAE", 8, 229794},
	{"TENDULKAR", 9, 115280},
	{"TENDS", 5, 37007},
	{"TENDRING", 8, 179466},
	{"TENDRILS", 8, 143110},
	{"TENDRIL", 7, 232858},
	{"TENDRE", 6, 170941},
	{"TENDONS", 7, 85403},
	{"TENDONITIS", 10, 117112},
	{"TENDON", 6, 67385},
	{"TENDO", 5, 204949},
	{"TENDLER", 7, 203533},
	{"TENDINITIS", 10, 137273},
	{"TENDING", 7, 66644},
	{"TENDERS", 7, 43297},
	{"TENDERNESS", 10, 62389},
	{"TENDERLY", 8, 84721},
	{"TENDERLOINS", 11, 225036},
	{"TENDERLOIN", 10, 73358},
	{"TENDERIZER", 10, 230084},
	{"TENDERING", 9, 75739},
	{"TENDERFOOT", 10, 206185},
	{"TENDEREST", 9, 253371},
	{"TENDERERS", 9, 117987},
	{"TENDERER", 8, 97252},
	{"TENDERED", 8, 78755},
	{"TENDER", 6, 31562},
	{"TENDENTIOUS", 11, 232541},
	{"TENDENCY", 8, 9596},
	{"TENDENCIES", 10, 53291},
	{"TENDENCI", 8, 192546},
	{"TENDED", 6, 45152},
	{"TENDANCY", 8, 192590},
	{"TENDANCES", 9, 254692},
	{"TENDANCE", 8, 181423},
	{"TENDA", 5, 203693},
	{"TEND", 4, 3097},
	{"TENCY", 5, 225691},
	{"TENCOR", 6, 176234},
	{"TENCHU", 6, 153441},
	{"TENCHI", 6, 75640},
	{"TENCH", 5, 161146},
	{"TENCEL", 6, 193214},
	{"TENCE", 5, 146744},
	{"TENC", 4, 5390},
	{"TENBY", 5, 118662},
	{"TENBURY", 7, 158933},
	{"TENBA", 5, 244770},
	{"TENB", 4, 30919},
	{"TENAYA", 6, 231695},
	{"TENAX", 5, 188413},
	{"TENASCIN", 8, 242851},
	{"TENANTS", 7, 36772},
	{"TENANTED", 8, 202261},
	{"TENANT", 6, 32786},
	{"TENANCY", 7, 58821},
	{"TENANCIES", 9, 109774},
	{"TENANCE", 7, 191021},
	{"TENAGLIA", 8, 235842},
	{"TENAGA", 6, 258064},
	{"TENAFLY", 7, 145224},
	{"TENACITY", 8, 89160},
	{"TENACIOUSLY", 11, 187386},
	{"TENACIOUS", 9, 47474},
	{"TENABLE", 7, 123929},
	{"TEN", 3, 370},
	{"TEMY", 4, 64940},
	{"TEMW", 4, 37653},
	{"TEMV", 4, 115128},
	{"TEMUCO", 6, 247933},
	{"TEMTEC", 6, 253004},
	{"TEMR", 4, 60918},
	{"TEMPUS", 6, 86718},
	{"TEMPURPEDIC", 11, 163172},
	{"TEMPURA", 7, 126562},
	{"TEMPUR", 6, 107106},
	{"TEMPTS", 6, 137768},
	{"TEMPTRESS", 9, 122929},
	{"TEMPTING", 8, 56918},
	{"TEMPTER", 7, 200667},
	{"TEMPTED", 7, 49994},
	{"TEMPTATIONS", 11, 63586},
	{"TEMPTATION", 10, 44801},
	{"TEMPT", 5, 80896},
	{"TEMPS", 5, 46162},
	{"TEMPRANILLO", 11, 172609},
	{"TEMPOS", 6, 131025},
	{"TEMPOROMANDIBULAR", 17, 118284},
	{"TEMPORIS", 8, 243084},
	{"TEMPORE", 7, 91341},
	{"TEMPORARY", 9, 28496},
	{"TEMPORARILY", 11, 596},
	{"TEMPORARIES", 11, 185735},
	{"TEMPORALLY", 10, 98542},
	{"TEMPORALITY", 11, 192679},
	{"TEMPORAL", 8, 36257},
	{"TEMPORADA", 9, 225662},
	{"TEMPOR", 6, 131081},
	{"TEMPO", 5, 41045},
	{"TEMPNAME", 8, 194622},
	{"TEMPLO", 6, 199138},
	{"TEMPLIN", 7, 195755},
	{"TEMPLETON", 9, 63706},
	{"TEMPLET", 7, 213124},
	{"TEMPLESTOWE", 11, 230665},
	{"TEMPLES", 7, 45658},
	{"TEMPLER", 7, 262138},
	{"TEMPLEMAN", 9, 192387},
	{"TEMPLE", 6, 30226},
	{"TEMPLATING", 10, 100550},
	{"TEMPLATES", 9, 6256},
	{"TEMPLATED", 9, 147143},
	{"TEMPLATE", 8, 5097},
	{"TEMPLARS", 8, 121390},
	{"TEMPLAR", 7, 80674},
	{"TEMPL", 5, 206150},
	{"TEMPIO", 6, 227598},
	{"TEMPING", 7, 158676},
	{"TEMPI", 5, 168935},
	{"TEMPFILE", 8, 132645},
	{"TEMPESTUOUS", 11, 167114},
	{"TEMPESTSANS", 11, 165353},
	{"TEMPESTS", 8, 203051},
	{"TEMPEST", 7, 54697},
	{"TEMPERS", 7, 115375},
	{"TEMPERMENT", 10, 194738},
	{"TEMPERLEY", 9, 213684},
	{"TEMPERING", 9, 127194},
	{"TEMPERED", 8, 54993},
	{"TEMPERATURES", 12, 29865},
	{"TEMPERATURE", 11, 4908},
	{"TEMPERATURA", 11, 86323},
	{"TEMPERATUR", 10, 140353},
	{"TEMPERATE", 9, 58130},
	{"TEMPERANCE", 10, 78756},
	{"TEMPERAMENTS", 12, 139516},
	{"TEMPERAMENTAL", 13, 135293},
	{"TEMPERAMENT", 11, 62341},
	{"TEMPERA", 7, 87054},
	{"TEMPER", 6, 50912},
	{"TEMPELHOF", 9, 235919},
	{"TEMPEL", 6, 137788},
	{"TEMPEH", 6, 137803},
	{"TEMPEATURE", 10, 207963},
	{"TEMPE", 5, 48488},
	{"TEMPDIR", 7, 176063},
	{"TEMPAT", 6, 240932},
	{"TEMPA", 5, 215339},
	{"TEMP", 4, 239},
	{"TEMOZOLOMIDE", 12, 230235},
	{"TEMOVATE", 8, 145104},
	{"TEMORA", 6, 259517},
	{"TEMM", 4, 50019},
	{"TEML", 4, 77750},
	{"TEMKIN", 6, 230702},
	{"TEMK", 4, 123049},
	{"TEMJ", 4, 158947},
	{"TEMIC", 5, 194899},
	{"TEMG", 4, 94395},
	{"TEMF", 4, 47726},
	{"TEMESCAL", 8, 195942},
	{"TEMES", 5, 147523},
	{"TEMERITY", 8, 175314},
	{"TEMENOS", 7, 230963},
	{"TEMECULA", 8, 67846},
	{"TEMD", 4, 59939},
	{"TEMC", 4, 44330},
	{"TEMBO", 5, 260021},
	{"TEMBER", 6, 185300},
	{"TEMBEC", 6, 259756},
	{"TEMB", 4, 5931},
	{"TEMAZEPAM", 9, 129189},
	{"TEMAT", 5, 186060},
	{"TEMASEK", 7, 138273},
	{"TEMAS", 5, 95158},
	{"TEMAN", 5, 187138},
	{"TEMAGAMI", 8, 200412},
	{"TEMAER", 6, 218825},
	{"TELW", 4, 59725},
	{"TELV", 4, 109930},
	{"TELUS", 5, 69741},
	{"TELUK", 5, 225949},
	{"TELUGU", 6, 61484},
	{"TELU", 4, 66918},
	{"TELSTRACLEAR", 12, 238338},
	{"TELSTRA", 7, 50184},
	{"TELSTAR", 7, 117361},
	{"TELRAD", 6, 192104},
	{"TELR", 4, 60073},
	{"TELOSYS", 7, 246533},
	{"TELOS", 5, 111918},
	{"TELOPEA", 7, 255813},
	{"TELOMERIC", 9, 159116},
	{"TELOMERES", 9, 145886},
	{"TELOMERE", 8, 112558},
	{"TELOMERASE", 10, 105951},
	{"TELOK", 5, 243194},
	{"TELNETD", 7, 170295},
	{"TELNET", 6, 40448},
	{"TELMO", 5, 203875},
	{"TELMEX", 6, 252624},
	{"TELM", 4, 69675},
	{"TELLY", 5, 80791},
	{"TELLUS", 6, 135016},
	{"TELLURIUM", 9, 164212},
	{"TELLURIDE", 9, 62926},
	{"TELLTALE", 8, 114473},
	{"TELLS", 5, 7419},
	{"TELLO", 5, 164804},
	{"TELLNO", 6, 201469},
	{"TELLIS", 6, 252124},
	{"TELLINGLY", 9, 189931},
	{"TELLING", 7, 8039},
	{"TELLIN", 6, 114400},
	{"TELLIGENT", 9, 84698},
	{"TELLIER", 7, 191305},
	{"TELLICO", 7, 156288},
	{"TELLEZ", 6, 250221},
	{"TELLES", 6, 181285},
	{"TELLERS", 7, 84383},
	{"TELLER", 6, 48667},
	{"TELLE", 5, 148254},
	{"TELLAYE", 7, 193702},
	{"TELLABS", 7, 148164},
	{"TELLA", 5, 233341},
	{"TELL", 4, 852},
	{"TELKWA", 6, 218490},
	{"TELKOM", 6, 90802},
	{"TELK", 4, 119648},
	{"TELJ", 4, 176250},
	{"TELITHROMYCIN", 13, 226589},
	{"TELITAL", 7, 108656},
	{"TELIT", 5, 117241},
	{"TELINDUS", 8, 216573},
	{"TELIGENT", 8, 256518},
	{"TELIC", 5, 184068},
	{"TELIASONERA", 11, 164261},
	{"TELIA", 5, 109893},
	{"TELG", 4, 96221},
	{"TELFROW", 7, 236422},
	{"TELFORD", 7, 56216},
	{"TELFER", 6, 144805},
	{"TELFAIR", 7, 151978},
	{"TELEXON", 7, 182013},
	{"TELEX", 5, 63760},
	{"TELEWORKING", 11, 122257},
	{"TELEWORKERS", 11, 173127},
	{"TELEWORKER", 10, 237550},
	{"TELEWORK", 8, 97234},
	{"TELEWEST", 8, 80868},
	{"TELEVUE", 7, 136860},
	{"TELEVISUAL", 10, 260660},
	{"TELEVISON", 9, 147402},
	{"TELEVISIONS", 11, 35037},
	{"TELEVISIONE", 11, 232223},
	{"TELEVISION", 10, 2474},
	{"TELEVISING", 10, 218552},
	{"TELEVISED", 9, 62204},
	{"TELEVISE", 8, 184032},
	{"TELEVISA", 8, 242360},
	{"TELEVIDEO", 9, 260350},
	{"TELEVANTAGE", 11, 234999},
	{"TELEVANGELIST", 13, 204446},
	{"TELETYPE", 8, 133160},
	{"TELETUBBIES", 11, 98746},
	{"TELETHON", 8, 126658},
	{"TELETEXT", 8, 70279},
	{"TELETECH", 8, 215835},
	{"TELESYSTEMS", 11, 210562},
	{"TELESYN", 7, 82850},
	{"TELESUD", 7, 257160},
	{"TELESTAR", 8, 129396},
	{"TELESIS", 7, 182035},
	{"TELESERVICES", 12, 129223},
	{"TELESEMINARS", 12, 231526},
	{"TELESEMINAR", 11, 173548},
	{"TELESCOPING", 11, 90178},
	{"TELESCOPIC", 10, 71802},
	{"TELESCOPES", 10, 45666},
	{"TELESCOPE", 9, 8217},
	{"TELESCOP", 8, 192867},
	{"TELESAT", 7, 231795},
	{"TELESALES", 9, 89168},
	{"TELES", 5, 212901},
	{"TELERIK", 7, 199948},
	{"TELERECORDER", 12, 223351},
	{"TELERAU", 7, 238122},
	{"TELERAMA", 8, 237426},
	{"TELERADIOLOGY", 13, 219690},
	{"TELEPROMPTER", 12, 193304},
	{"TELEPRESENCE", 12, 190675},
	{"TELEPORTS", 9, 213350},
	{"TELEPORTING", 11, 226134},
	{"TELEPORTER", 10, 189535},
	{"TELEPORTED", 10, 201893},
	{"TELEPORTATION", 13, 123272},
	{"TELEPORT", 8, 86140},
	{"TELEPOPMUSIK", 12, 155774},
	{"TELEPLUS", 8, 250258},
	{"TELEPLAY", 8, 181779},
	{"TELEPHOTO", 9, 60390},
	{"TELEPHONY", 9, 32886},
	{"TELEPHONING", 11, 111949},
	{"TELEPHONICS", 11, 185408},
	{"TELEPHONICALLY", 14, 215962},
	{"TELEPHONIC", 10, 115039},
	{"TELEPHONES", 10, 37657},
	{"TELEPHONENUMBER", 15, 244467},
	{"TELEPHONED", 10, 111568},
	{"TELEPHONE", 9, 595},
	{"TELEPHON", 8, 168741},
	{"TELEPHO", 7, 217853},
	{"TELEPHARMACY", 12, 82625},
	{"TELEPHARMACIES", 14, 121353},
	{"TELEPATHY", 9, 103585},
	{"TELEPATHICALLY", 14, 215727},
	{"TELEPATHIC", 10, 115554},
	{"TELEPATH", 8, 226612},
	{"TELEP", 5, 230678},
	{"TELEOSTEI", 9, 192609},
	{"TELEOST", 7, 226940},
	{"TELEOPERATION", 13, 260253},
	{"TELEOLOGY", 9, 192563},
	{"TELEOLOGICAL", 12, 151691},
	{"TELENOVELAS", 11, 238738},
	{"TELENOVELA", 10, 211517},
	{"TELENOR", 7, 108153},
	{"TELENET", 7, 177219},
	{"TELENCEPHALON", 13, 241403},
	{"TELEMUNDO", 9, 158922},
	{"TELEMETRY", 9, 61671},
	{"TELEMEDICINE", 12, 66263},
	{"TELEMEDIA", 9, 187017},
	{"TELEMECANIQUE", 13, 245553},
	{"TELEMATICS", 10, 76844},
	{"TELEMATIC", 9, 161275},
	{"TELEMARKING", 11, 166657},
	{"TELEMARKETING", 13, 52686},
	{"TELEMARKETERS", 13, 99091},
	{"TELEMARKETER", 12, 135187},
	{"TELEMARK", 8, 78480},
	{"TELEMANN", 8, 136760},
	{"TELEMANIA", 9, 196404},
	{"TELEMANAGEMENT", 14, 198740},
	{"TELEMACHUS", 10, 195358},
	{"TELELOGIC", 9, 165786},
	{"TELEKOMMUNIKATION", 17, 223207},
	{"TELEKOM", 7, 76891},
	{"TELEKINETIC", 11, 227282},
	{"TELEKINESIS", 11, 176280},
	{"TELEIT", 6, 238909},
	{"TELEHEALTH", 10, 106151},
	{"TELEGRAPHY", 10, 142426},
	{"TELEGRAPHS", 10, 184558},
	{"TELEGRAPHIC", 11, 107017},
	{"TELEGRAPHED", 11, 192744},
	{"TELEGRAPH", 9, 37697},
	{"TELEGRAMS", 9, 101669},
	{"TELEGRAM", 8, 57515},
	{"TELEGRAAF", 9, 241277},
	{"TELEGLOBE", 9, 216167},
	{"TELEFUNKEN", 10, 118404},
	{"TELEFOONS", 9, 137198},
	{"TELEFOON", 8, 94657},
	{"TELEFONY", 8, 256728},
	{"TELEFONOS", 9, 190471},
	{"TELEFONO", 8, 84509},
	{"TELEFONIE", 9, 136071},
	{"TELEFONICO", 10, 237007},
	{"TELEFONICA", 10, 96531},
	{"TELEFONIA", 9, 116572},
	{"TELEFONI", 8, 143810},
	{"TELEFONEROTIK", 13, 139328},
	{"TELEFONE", 8, 131563},
	{"TELEFON", 7, 56896},
	{"TELEFLORA", 9, 46713},
	{"TELEFLEX", 8, 132664},
	{"TELEFILM", 8, 151700},
	{"TELEFAX", 7, 76836},
	{"TELEDYNE", 8, 115838},
	{"TELEDU", 6, 257496},
	{"TELECOURSES", 11, 223385},
	{"TELECOURSE", 10, 185282},
	{"TELECONVERTER", 13, 173854},
	{"TELECONFERENCING", 16, 82897},
	{"TELECONFERENCES", 15, 113366},
	{"TELECONFERENCE", 14, 62527},
	{"TELECON", 7, 123822},
	{"TELECOMUNICAZIONI", 17, 213480},
	{"TELECOMUNICATIONS", 17, 229836},
	{"TELECOMUNICACIONES", 18, 187133},
	{"TELECOMS", 8, 45345},
	{"TELECOMMUTING", 13, 76865},
	{"TELECOMMUTERS", 13, 158103},
	{"TELECOMMUTER", 12, 244144},
	{"TELECOMMUTE", 11, 129905},
	{"TELECOMMUNICATIONS", 18, 6834},
	{"TELECOMMUNICATION", 17, 40761},
	{"TELECOMMS", 9, 123753},
	{"TELECOMMAND", 11, 257764},
	{"TELECOMM", 8, 111707},
	{"TELECOM", 7, 8238},
	{"TELECLASSES", 11, 180645},
	{"TELECLASS", 9, 179531},
	{"TELECINE", 8, 165861},
	{"TELECHECK", 9, 186716},
	{"TELECHARGERTELECHARGER", 22, 188367},
	{"TELECHARGER", 11, 36547},
	{"TELECHARGEMENT", 14, 57255},
	{"TELECHARGE", 10, 127864},
	{"TELECENTRES", 11, 170794},
	{"TELECENTRE", 10, 164848},
	{"TELECENTERS", 11, 259160},
	{"TELECENTER", 10, 240926},
	{"TELECEL", 7, 224967},
	{"TELECASTS", 9, 201008},
	{"TELECASTING", 11, 228093},
	{"TELECASTER", 10, 105493},
	{"TELECAST", 8, 98290},
	{"TELECARE", 8, 179641},
	{"TELEADAPT", 9, 140184},
	{"TELDEC", 6, 211327},
	{"TELD", 4, 76032},
	{"TELCOS", 6, 94083},
	{"TELCORDIA", 9, 139790},
	{"TELCON", 6, 238642},
	{"TELCOMM", 7, 134747},
	{"TELCOM", 6, 104248},
	{"TELCO", 5, 59391},
	{"TELCEL", 6, 249397},
	{"TELBEC", 6, 215410},
	{"TELB", 4, 65042},
	{"TELARUS", 7, 136949},
	{"TELARC", 6, 119721},
	{"TELANJANG", 9, 216543},
	{"TELANGIECTASIA", 14, 168705},
	{"TELAMON", 7, 212925},
	{"TELALASKA", 9, 187568},
	{"TELAH", 5, 213869},
	{"TEL", 3, 2215},
	{"TEKY", 4, 244212},
	{"TEKW", 4, 170886},
	{"TEKU", 4, 158659},
	{"TEKTRONIX", 9, 59652},
	{"TEKTRO", 6, 189735},
	{"TEKSYSTEMS", 10, 136134},
	{"TEKSTY", 6, 81037},
	{"TEKSTEN", 7, 189755},
	{"TEKST", 5, 97828},
	{"TEKRAM", 6, 130181},
	{"TEKR", 4, 159964},
	{"TEKP", 4, 227938},
	{"TEKOA", 5, 237439},
	{"TEKNOR", 6, 163612},
	{"TEKNOLOGI", 9, 147730},
	{"TEKNO", 5, 136644},
	{"TEKNISKA", 8, 198666},
	{"TEKNISK", 7, 239275},
	{"TEKNIK", 6, 128341},
	{"TEKNIC", 6, 221391},
	{"TEKM", 4, 217711},
	{"TEKLYNX", 7, 218151},
	{"TEKLOGIX", 8, 189917},
	{"TEKLE", 5, 257291},
	{"TEKLA", 5, 254777},
	{"TEKL", 4, 169541},
	{"TEKKY", 5, 191605},
	{"TEKKEON", 7, 167360},
	{"TEKKEN", 6, 77043},
	{"TEKGERGEDAN", 11, 199006},
	{"TEKES", 5, 164370},
	{"TEKENS", 6, 220338},
	{"TEKENINGEN", 10, 178038},
	{"TEKENING", 8, 193996},
	{"TEKEN", 5, 157928},
	{"TEKELEC", 7, 244008},
	{"TEKC", 4, 225081},
	{"TEKAPO", 6, 190104},
	{"TEKAMAH", 7, 236018},
	{"TEJR", 4, 210885},
	{"TEJON", 5, 177598},
	{"TEJEDA", 6, 231275},
	{"TEJAS", 5, 116689},
	{"TEJANO", 6, 139004},
	{"TEJADA", 6, 103649},
	{"TEIXEIRA", 8, 98222},
	{"TEITL", 5, 244107},
	{"TEITHIO", 7, 239823},
	{"TEITELBAUM", 10, 134341},
	{"TEIRLINCK", 9, 198737},
	{"TEILNEHMER", 10, 251863},
	{"TEILHARD", 8, 178157},
	{"TEILEN", 6, 251269},
	{"TEILE", 5, 170431},
	{"TEIKOKU", 7, 194732},
	{"TEIJIN", 6, 231734},
	{"TEIGNMOUTH", 10, 148745},
	{"TEIGNBRIDGE", 11, 189492},
	{"TEIDE", 5, 219204},
	{"TEICHER", 7, 228414},
	{"TEICH", 5, 176738},
	{"TEHUTI", 6, 242324},
	{"TEHSIL", 6, 198638},
	{"TEHRANI", 7, 165968},
	{"TEHRAN", 6, 46641},
	{"TEHILLIM", 8, 254077},
	{"TEHERAN", 7, 117683},
	{"TEHAMA", 6, 107536},
	{"TEHACHAPI", 9, 119247},
	{"TEGY", 4, 32958},
	{"TEGUISE", 7, 161100},
	{"TEGUCIGALPA", 11, 122494},
	{"TEGU", 4, 66517},
	{"TEGRETOL", 8, 137624},
	{"TEGR", 4, 10075},
	{"TEGP", 4, 249781},
	{"TEGM", 4, 185236},
	{"TEGL", 4, 89753},
	{"TEGI", 4, 33214},
	{"TEGG", 4, 96941},
	{"TEGEN", 5, 126060},
	{"TEGEL", 5, 153679},
	{"TEGAN", 5, 124742},
	{"TEFU", 4, 38951},
	{"TEFR", 4, 35111},
	{"TEFO", 4, 6705},
	{"TEFLON", 6, 58294},
	{"TEFL", 4, 70253},
	{"TEFILLIN", 8, 166418},
	{"TEFFT", 5, 245983},
	{"TEFF", 4, 212501},
	{"TEFC", 4, 162590},
	{"TEFAL", 5, 95095},
	{"TEEVEE", 6, 166506},
	{"TEETHING", 8, 87177},
	{"TEETHERS", 8, 150136},
	{"TEETHER", 7, 205292},
	{"TEETH", 5, 28923},
	{"TEETERS", 7, 197962},
	{"TEETERING", 9, 133972},
	{"TEETER", 6, 108999},
	{"TEESSIDE", 8, 72537},
	{"TEESIDE", 7, 121094},
	{"TEESDALE", 8, 151983},
	{"TEERS", 5, 223617},
	{"TEEPEE", 6, 149317},
	{"TEENZ", 5, 196430},
	{"TEENYS", 6, 219427},
	{"TEENY", 5, 68740},
	{"TEENTITTEN", 10, 188792},
	{"TEENSY", 6, 192140},
	{"TEENSFORCASH", 12, 81323},
	{"TEENSCHLAMPEN", 13, 187903},
	{"TEENSCHLAMPE", 12, 187951},
	{"TEENS", 5, 1943},
	{"TEENREPORT", 10, 190264},
	{"TEENORGIE", 9, 189155},
	{"TEENNUTTEN", 10, 187364},
	{"TEENMUSCHI", 10, 188825},
	{"TEENMOESE", 9, 187638},
	{"TEENMODEL", 9, 175234},
	{"TEENIES", 7, 74368},
	{"TEENIEMOVIES", 12, 231725},
	{"TEENIEFILES", 11, 87492},
	{"TEENIEFICK", 10, 187662},
	{"TEENIE", 6, 64088},
	{"TEENGIRLS", 9, 215733},
	{"TEENGIRL", 8, 159958},
	{"TEENFLAT", 8, 221452},
	{"TEENFIRST", 9, 217432},
	{"TEENFICK", 8, 146619},
	{"TEENEX", 6, 221107},
	{"TEENEROTIK", 10, 188173},
	{"TEENBOYS", 8, 201390},
	{"TEENBOY", 7, 240253},
	{"TEENAGERS", 9, 36760},
	{"TEENAGERN", 9, 221143},
	{"TEENAGER", 8, 7761},
	{"TEENAGED", 8, 114069},
	{"TEENAGE", 7, 31536},
	{"TEEMU", 5, 158896},
	{"TEEMS", 5, 212040},
	{"TEEMIX", 6, 208041},
	{"TEEMING", 7, 93855},
	{"TEEMA", 5, 141442},
	{"TEEING", 6, 200707},
	{"TEEHEE", 6, 198429},
	{"TEECH", 5, 219662},
	{"TEECE", 5, 257617},
	{"TEDZ", 4, 102463},
	{"TEDY", 4, 190179},
	{"TEDX", 4, 147151},
	{"TEDW", 4, 3312},
	{"TEDV", 4, 38289},
	{"TEDU", 4, 29406},
	{"TEDT", 4, 1146},
	{"TEDSTONE", 8, 217536},
	{"TEDR", 4, 9238},
	{"TEDQ", 4, 66117},
	{"TEDP", 4, 5652},
	{"TEDO", 4, 3109},
	{"TEDN", 4, 28313},
	{"TEDM", 4, 6070},
	{"TEDL", 4, 6772},
	{"TEDK", 4, 36571},
	{"TEDJ", 4, 41460},
	{"TEDIUM", 6, 136003},
	{"TEDIOUSLY", 9, 240199},
	{"TEDIOUS", 7, 53264},
	{"TEDH", 4, 4853},
	{"TEDG", 4, 32060},
	{"TEDFORD", 7, 223099},
	{"TEDF", 4, 3068},
	{"TEDESCO", 7, 117715},
	{"TEDESCHI", 8, 106097},
	{"TEDDYS", 6, 241808},
	{"TEDDYBEAR", 9, 216568},
	{"TEDDY", 5, 35413},
	{"TEDDINGTON", 10, 119311},
	{"TEDDIES", 7, 72355},
	{"TEDDIE", 6, 221865},
	{"TEDDIBARRETT", 12, 199497},
	{"TEDDER", 6, 197513},
	{"TEDD", 4, 166116},
	{"TEDC", 4, 6340},
	{"TEDB", 4, 1940},
	{"TECY", 4, 136332},
	{"TECW", 4, 176465},
	{"TECU", 4, 54304},
	{"TECTURE", 7, 206555},
	{"TECTURA", 7, 137607},
	{"TECTONOPHYSICS", 14, 207620},
	{"TECTONICS", 9, 81553},
	{"TECTONIC", 8, 70693},
	{"TECTION", 7, 139429},
	{"TECTED", 6, 169793},
	{"TECRA", 5, 66308},
	{"TECR", 4, 49813},
	{"TECPREVIEW", 10, 161272},
	{"TECPLOT", 7, 247707},
	{"TECP", 4, 188423},
	{"TECNOLOGY", 9, 205493},
	{"TECNOLOGIE", 10, 188845},
	{"TECNOLOGICO", 11, 193910},
	{"TECNOLOGIA", 10, 102587},
	{"TECNO", 5, 220534},
	{"TECNIK", 6, 143371},
	{"TECNIFIBRE", 10, 237287},
	{"TECNICOS", 8, 237333},
	{"TECNICO", 7, 128133},
	{"TECNICHE", 8, 179903},
	{"TECNICAS", 8, 199908},
	{"TECNICA", 7, 90224},
	{"TECMO", 5, 104455},
	{"TECM", 4, 161451},
	{"TECLADOS", 8, 261453},
	{"TECLADO", 7, 234836},
	{"TECLA", 5, 232811},
	{"TECL", 4, 45586},
	{"TECK", 4, 110241},
	{"TECHY", 5, 122175},
	{"TECHWYSE", 8, 140013},
	{"TECHWR", 6, 72110},
	{"TECHWORLD", 9, 85331},
	{"TECHWOOD", 8, 241235},
	{"TECHWHACK", 9, 226551},
	{"TECHWEB", 7, 59806},
	{"TECHWEAR", 8, 235346},
	{"TECHVIBES", 9, 209863},
	{"TECHTV", 6, 142082},
	{"TECHTREE", 8, 212932},
	{"TECHTRACKER", 11, 126829},
	{"TECHTOOL", 8, 261330},
	{"TECHTARGET", 10, 63939},
	{"TECHTALK", 8, 96536},
	{"TECHSUPPORT", 11, 184506},
	{"TECHSTREET", 10, 204442},
	{"TECHSTORE", 9, 249101},
	{"TECHSPOT", 8, 93766},
	{"TECHSOUP", 8, 141134},
	{"TECHSMITH", 9, 162349},
	{"TECHSKILLS", 10, 129741},
	{"TECHS", 5, 49508},
	{"TECHREPUBLIC", 12, 34620},
	{"TECHREPORT", 10, 128074},
	{"TECHRANKINGS", 12, 216311},
	{"TECHPROGUILD", 12, 122153},
	{"TECHPRICESONLINE", 16, 238570},
	{"TECHONWEB", 9, 128990},
	{"TECHONOLOGY", 11, 173694},
	{"TECHONLINE", 10, 107179},
	{"TECHOLOGY", 9, 184196},
	{"TECHOFF", 7, 241478},
	{"TECHO", 5, 211963},
	{"TECHNOWORLD", 11, 111481},
	{"TECHNOTES", 9, 124828},
	{"TECHNOTE", 8, 138756},
	{"TECHNOSONIC", 11, 259110},
	{"TECHNORIDE", 10, 96718},
	{"TECHNORATI", 10, 37543},
	{"TECHNOPARK", 10, 259816},
	{"TECHNOOGIES", 11, 216249},
	{"TECHNOMARINE", 12, 113087},
	{"TECHNOLOY", 9, 206971},
	{"TECHNOLOGY", 10, 1863},
	{"TECHNOLOGISTS", 13, 63852},
	{"TECHNOLOGIST", 12, 62181},
	{"TECHNOLOGIES", 12, 2294},
	{"TECHNOLOGIEN", 12, 220452},
	{"TECHNOLOGIE", 11, 73033},
	{"TECHNOLOGICALLY", 15, 63506},
	{"TECHNOLOGICAL", 13, 30446},
	{"TECHNOLOGIC", 11, 185060},
	{"TECHNOLOGI", 10, 174305},
	{"TECHNOLOG", 9, 114303},
	{"TECHNOLO", 8, 94258},
	{"TECHNOLGY", 9, 163314},
	{"TECHNOLGIES", 11, 203848},
	{"TECHNOLEG", 9, 256612},
	{"TECHNOLAND", 10, 184765},
	{"TECHNOL", 7, 63030},
	{"TECHNOGRAPHICS", 14, 188372},
	{"TECHNOCRATS", 11, 165420},
	{"TECHNOCRATIC", 12, 175040},
	{"TECHNOCRATI", 11, 203428},
	{"TECHNOCRAT", 10, 224084},
	{"TECHNOCRACY", 11, 224039},
	{"TECHNOBABBLE", 12, 132138},
	{"TECHNO", 6, 30493},
	{"TECHNIUM", 8, 211057},
	{"TECHNISCHER", 11, 241261},
	{"TECHNISCHEN", 11, 219364},
	{"TECHNISCHE", 10, 70258},
	{"TECHNISAT", 9, 106001},
	{"TECHNIQUES", 10, 3166},
	{"TECHNIQUE", 9, 3875},
	{"TECHNIP", 7, 251029},
	{"TECHNION", 8, 106086},
	{"TECHNINE", 8, 214072},
	{"TECHNIKON", 9, 168861},
	{"TECHNIKA", 8, 153035},
	{"TECHNIK", 7, 81977},
	{"TECHNIEK", 8, 227076},
	{"TECHNICS", 8, 51522},
	{"TECHNICOLOUR", 12, 249705},
	{"TECHNICOLOR", 11, 91167},
	{"TECHNICIANS", 11, 37332},
	{"TECHNICIAN", 10, 35748},
	{"TECHNICALUSER", 13, 177100},
	{"TECHNICALS", 10, 149959},
	{"TECHNICALLY", 11, 39497},
	{"TECHNICALITY", 12, 128367},
	{"TECHNICALITIES", 14, 104315},
	{"TECHNICAL", 9, 6238},
	{"TECHNICA", 8, 58595},
	{"TECHNIC", 7, 87089},
	{"TECHNIBOND", 10, 189923},
	{"TECHNI", 6, 125928},
	{"TECHNEWSWORLD", 13, 104108},
	{"TECHNEWS", 8, 84416},
	{"TECHNETIUM", 10, 109594},
	{"TECHNET", 7, 77529},
	{"TECHNASIA", 9, 256481},
	{"TECHN", 5, 100465},
	{"TECHMENTOR", 10, 100690},
	{"TECHMEDIA", 9, 131333},
	{"TECHMARKET", 10, 105131},
	{"TECHMARK", 8, 225270},
	{"TECHLINK", 8, 191989},
	{"TECHLIBRARY", 11, 254774},
	{"TECHLAND", 8, 204066},
	{"TECHJOBS", 8, 179709},
	{"TECHINDEX", 9, 160564},
	{"TECHINCAL", 9, 220168},
	{"TECHIMO", 7, 139017},
	{"TECHIES", 7, 95493},
	{"TECHIE", 6, 69872},
	{"TECHICAL", 8, 220486},
	{"TECHGUIDES", 10, 158173},
	{"TECHGENIX", 9, 223586},
	{"TECHFORGE", 9, 252312},
	{"TECHFINDER", 10, 254048},
	{"TECHEXCEL", 9, 98153},
	{"TECHENCYCLOPEDIA", 16, 158345},
	{"TECHENCLAVE", 11, 179028},
	{"TECHED", 6, 103659},
	{"TECHDIS", 7, 174280},
	{"TECHDIRT", 8, 80059},
	{"TECHDEPOT", 9, 230456},
	{"TECHCRUNCH", 10, 132016},
	{"TECHCONNECT", 11, 242135},
	{"TECHCENTRAL", 11, 248709},
	{"TECHCENTER", 10, 170527},
	{"TECHCALENDAR", 12, 234211},
	{"TECHBUY", 7, 124549},
	{"TECHBLOG", 8, 237508},
	{"TECHBARGAINS", 12, 148451},
	{"TECHASSIST", 10, 94680},
	{"TECHART", 7, 233337},
	{"TECHARENA", 9, 225677},
	{"TECH", 4, 1601},
	{"TECF", 4, 249782},
	{"TECD", 4, 185237},
	{"TECCOR", 6, 249005},
	{"TECCHANNEL", 10, 136234},
	{"TECC", 4, 113532},
	{"TECB", 4, 213219},
	{"TECATE", 6, 161806},
	{"TECAN", 5, 260273},
	{"TEBY", 4, 48790},
	{"TEBU", 4, 35997},
	{"TEBR", 4, 44900},
	{"TEBL", 4, 58413},
	{"TEBBUTT", 7, 237635},
	{"TEBB", 4, 123909},
	{"TEAYS", 5, 216631},
	{"TEAWARE", 7, 256571},
	{"TEAVEL", 6, 257529},
	{"TEATRO", 6, 68966},
	{"TEATIME", 7, 179589},
	{"TEATHER", 7, 222219},
	{"TEATER", 6, 223957},
	{"TEASPOONS", 9, 67465},
	{"TEASPOONFULS", 12, 228419},
	{"TEASPOONFUL", 11, 171212},
	{"TEASPOON", 8, 6865},
	{"TEASLEY", 7, 242126},
	{"TEASINGLY", 9, 216393},
	{"TEASING", 7, 53888},
	{"TEASES", 6, 108195},
	{"TEASERS", 7, 79431},
	{"TEASER", 6, 56833},
	{"TEASEL", 6, 256960},
	{"TEASED", 6, 81450},
	{"TEASDALE", 8, 131446},
	{"TEARY", 5, 137584},
	{"TEARSHEETS", 10, 218235},
	{"TEARS", 5, 29467},
	{"TEAROOM", 7, 172896},
	{"TEARJERKER", 10, 224064},
	{"TEARING", 7, 55648},
	{"TEARIN", 6, 252439},
	{"TEARFUND", 8, 207899},
	{"TEARFULLY", 9, 200265},
	{"TEARFUL", 7, 114804},
	{"TEARDROPS", 9, 130416},
	{"TEARDROP", 8, 80244},
	{"TEARDOWN", 8, 119843},
	{"TEAR", 4, 5633},
	{"TEAPOTS", 7, 87067},
	{"TEAPOT", 6, 60312},
	{"TEANNA", 6, 133652},
	{"TEANECK", 7, 113696},
	{"TEAMXBOX", 8, 56458},
	{"TEAMWORKING", 11, 254378},
	{"TEAMWORK", 8, 47768},
	{"TEAMWEAR", 8, 188846},
	{"TEAMWARE", 8, 248277},
	{"TEAMTRACK", 9, 155635},
	{"TEAMTALK", 8, 134216},
	{"TEAMSTERS", 9, 90844},
	{"TEAMSTER", 8, 142173},
	{"TEAMSPEAK", 9, 99864},
	{"TEAMS", 5, 3654},
	{"TEAMMATES", 9, 60787},
	{"TEAMMATE", 8, 32331},
	{"TEAMING", 7, 68611},
	{"TEAMHARMONY", 11, 220977},
	{"TEAMFANSHOP", 11, 206478},
	{"TEAMED", 6, 51569},
	{"TEAMCENTER", 10, 228454},
	{"TEAMBUILDING", 12, 119410},
	{"TEAMADVANTAGE", 13, 210552},
	{"TEAM", 4, 1259},
	{"TEALIGHTS", 9, 145490},
	{"TEALIGHT", 8, 113552},
	{"TEALEAF", 7, 145106},
	{"TEALE", 5, 189830},
	{"TEAKWOOD", 8, 175691},
	{"TEAKETTLE", 9, 196368},
	{"TEAIRRA", 7, 229599},
	{"TEAHOUSE", 8, 148645},
	{"TEAGUE", 6, 83176},
	{"TEAGASC", 7, 194583},
	{"TEAGARDEN", 9, 225770},
	{"TEAGAN", 6, 156534},
	{"TEAD", 4, 3973},
	{"TEACUPS", 7, 146325},
	{"TEACUP", 6, 81206},
	{"TEACHOUT", 8, 163138},
	{"TEACHINGS", 9, 42091},
	{"TEACHING", 8, 4682},
	{"TEACHI", 6, 163552},
	{"TEACHES", 7, 35416},
	{"TEACHERWEB", 10, 136839},
	{"TEACHERVISION", 13, 139402},
	{"TEACHERS", 8, 2637},
	{"TEACHERNET", 10, 170025},
	{"TEACHER", 7, 1343},
	{"TEACHABLE", 9, 143949},
	{"TEACH", 5, 1809},
	{"TEABAGS", 7, 168692},
	{"TEABAG", 6, 194128},
	{"TDYS", 4, 209288},
	{"TDYN", 4, 90302},
	{"TDYL", 4, 196458},
	{"TDYI", 4, 153775},
	{"TDYE", 4, 177071},
	{"TDWI", 4, 255967},
	{"TDWH", 4, 150544},
	{"TDWE", 4, 110631},
	{"TDWA", 4, 116496},
	{"TDVD", 4, 128307},
	{"TDUV", 4, 230290},
	{"TDUT", 4, 74474},
	{"TDUS", 4, 95395},
	{"TDUR", 4, 33673},
	{"TDUQ", 4, 210680},
	{"TDUP", 4, 118776},
	{"TDUO", 4, 198697},
	{"TDUN", 4, 72039},
	{"TDUM", 4, 87795},
	{"TDUL", 4, 146341},
	{"TDUK", 4, 83522},
	{"TDUG", 4, 173432},
	{"TDUF", 4, 185238},
	{"TDUE", 4, 45242},
	{"TDUD", 4, 127618},
	{"TDUC", 4, 105083},
	{"TDUB", 4, 96640},
	{"TDUA", 4, 136032},
	{"TDSY", 4, 249446},
	{"TDSW", 4, 197584},
	{"TDSU", 4, 252499},
	{"TDSL", 4, 200561},
	{"TDSF", 4, 258900},
	{"TDSC", 4, 207361},
	{"TDRY", 4, 92060},
	{"TDRW", 4, 231573},
	{"TDRU", 4, 51845},
	{"TDRT", 4, 246627},
	{"TDRS", 4, 216731},
	{"TDRR", 4, 213618},
	{"TDRP", 4, 203442},
	{"TDRO", 4, 45494},
	{"TDRM", 4, 139738},
	{"TDRL", 4, 231837},
	{"TDRK", 4, 222862},
	{"TDRJ", 4, 186506},
	{"TDRI", 4, 37319},
	{"TDRH", 4, 233236},
	{"TDRG", 4, 226729},
	{"TDRE", 4, 49015},
	{"TDRD", 4, 211452},
	{"TDRC", 4, 195093},
	{"TDRB", 4, 187032},
	{"TDRA", 4, 41673},
	{"TDPR", 4, 202944},
	{"TDPA", 4, 85092},
	{"TDOZ", 4, 116078},
	{"TDOY", 4, 47399},
	{"TDOW", 4, 7529},
	{"TDOV", 4, 111605},
	{"TDOU", 4, 48292},
	{"TDOR", 4, 78740},
	{"TDOP", 4, 128750},
	{"TDOO", 4, 35618},
	{"TDON", 4, 30484},
	{"TDOM", 4, 48939},
	{"TDOL", 4, 71576},
	{"TDOJ", 4, 214221},
	{"TDOG", 4, 55258},
	{"TDOF", 4, 128551},
	{"TDOE", 4, 6619},
	{"TDOD", 4, 90042},
	{"TDOC", 4, 165618},
	{"TDOB", 4, 112199},
	{"TDMONTHLY", 9, 256123},
	{"TDMO", 4, 248496},
	{"TDMI", 4, 135069},
	{"TDMA", 4, 92719},
	{"TDLO", 4, 224408},
	{"TDJO", 4, 250472},
	{"TDJA", 4, 244526},
	{"TDIZ", 4, 249447},
	{"TDIX", 4, 127575},
	{"TDIV", 4, 41287},
	{"TDIS", 4, 7818},
	{"TDIR", 4, 36825},
	{"TDIP", 4, 91589},
	{"TDIMENSION", 10, 195665},
	{"TDIM", 4, 83671},
	{"TDIL", 4, 99146},
	{"TDIG", 4, 66935},
	{"TDID", 4, 8866},
	{"TDIC", 4, 70297},
	{"TDIB", 4, 218173},
	{"TDGA", 4, 171674},
	{"TDFO", 4, 160337},
	{"TDEX", 4, 188134},
	{"TDEW", 4, 159889},
	{"TDEV", 4, 37724},
	{"TDEU", 4, 146129},
	{"TDES", 4, 28968},
	{"TDER", 4, 60151},
	{"TDEM", 4, 39322},
	{"TDEL", 4, 42097},
	{"TDEK", 4, 240734},
	{"TDEJ", 4, 218876},
	{"TDEG", 4, 55154},
	{"TDEFORMATIONFIELD", 17, 235600},
	{"TDEF", 4, 33271},
	{"TDED", 4, 87949},
	{"TDEB", 4, 49539},
	{"TDEA", 4, 34871},
	{"TDDR", 4, 249124},
	{"TDCO", 4, 164894},
	{"TDCJ", 4, 205336},
	{"TDCI", 4, 155356},
	{"TDCH", 4, 242172},
	{"TDCA", 4, 144464},
	{"TDBU", 4, 253183},
	{"TDBE", 4, 93267},
	{"TDBA", 4, 157529},
	{"TDAZ", 4, 204661},
	{"TDAY", 4, 8353},
	{"TDAXP", 5, 257850},
	{"TDAW", 4, 84967},
	{"TDAV", 4, 48190},
	{"TDAU", 4, 70341},
	{"TDAR", 4, 53760},
	{"TDAP", 4, 170610},
	{"TDAM", 4, 53064},
	{"TDAL", 4, 67990},
	{"TDAK", 4, 231319},
	{"TDAG", 4, 158212},
	{"TDAF", 4, 208119},
	{"TDAD", 4, 112604},
	{"TDAC", 4, 175825},
	{"TDAB", 4, 193631},
	{"TCZE", 4, 174665},
	{"TCYW", 4, 162468},
	{"TCYT", 4, 141328},
	{"TCYS", 4, 184233},
	{"TCYR", 4, 128137},
	{"TCYP", 4, 92942},
	{"TCYO", 4, 119496},
	{"TCYN", 4, 154382},
	{"TCYM", 4, 216051},
	{"TCYL", 4, 129049},
	{"TCYJ", 4, 232099},
	{"TCYI", 4, 109300},
	{"TCYH", 4, 255287},
	{"TCYF", 4, 132269},
	{"TCYE", 4, 243012},
	{"TCYD", 4, 260056},
	{"TCYC", 4, 66831},
	{"TCYB", 4, 117013},
	{"TCYA", 4, 97983},
	{"TCWO", 4, 200018},
	{"TCWI", 4, 130474},
	{"TCWH", 4, 110526},
	{"TCWE", 4, 135394},
	{"TCWA", 4, 158660},
	{"TCVR", 4, 243},
	{"TCUW", 4, 236737},
	{"TCUT", 4, 40666},
	{"TCUS", 4, 54071},
	{"TCUR", 4, 42202},
	{"TCUP", 4, 76225},
	{"TCUN", 4, 134023},
	{"TCUL", 4, 54573},
	{"TCUI", 4, 173721},
	{"TCUH", 4, 255654},
	{"TCUG", 4, 242136},
	{"TCUF", 4, 255993},
	{"TCUE", 4, 225799},
	{"TCUD", 4, 216658},
	{"TCUC", 4, 219734},
	{"TCUB", 4, 94677},
	{"TCUA", 4, 184611},
	{"TCTR", 4, 189558},
	{"TCSU", 4, 158049},
	{"TCSC", 4, 196156},
	{"TCRY", 4, 67458},
	{"TCRU", 4, 50974},
	{"TCRS", 4, 257464},
	{"TCRP", 4, 212745},
	{"TCRO", 4, 40946},
	{"TCRI", 4, 36927},
	{"TCRE", 4, 34720},
	{"TCRA", 4, 42191},
	{"TCPXX", 5, 159390},
	{"TCPU", 4, 185106},
	{"TCPS", 4, 248700},
	{"TCPR", 4, 131850},
	{"TCPQUOTA", 8, 198780},
	{"TCPIP", 5, 101014},
	{"TCPI", 4, 145148},
	{"TCPDUMP", 7, 79903},
	{"TCPD", 4, 211334},
	{"TCPAGENT", 8, 227920},
	{"TCPA", 4, 137340},
	{"TCP", 3, 9667},
	{"TCOY", 4, 193941},
	{"TCOX", 4, 172592},
	{"TCOW", 4, 86294},
	{"TCOV", 4, 41981},
	{"TCOU", 4, 4141},
	{"TCOR", 4, 33520},
	{"TCOP", 4, 57545},
	{"TCOM", 4, 146069},
	{"TCOL", 4, 28639},
	{"TCOK", 4, 157451},
	{"TCOG", 4, 148049},
	{"TCOF", 4, 83941},
	{"TCOD", 4, 65582},
	{"TCOC", 4, 85814},
	{"TCOB", 4, 106723},
	{"TCOA", 4, 33844},
	{"TCNJ", 4, 172249},
	{"TCMU", 4, 261204},
	{"TCMSEQ", 6, 70518},
	{"TCMS", 4, 250244},
	{"TCMO", 4, 170989},
	{"TCMI", 4, 162130},
	{"TCME", 4, 216052},
	{"TCMD", 4, 240463},
	{"TCLY", 4, 228976},
	{"TCLX", 4, 209062},
	{"TCLUG", 5, 101224},
	{"TCLU", 4, 42317},
	{"TCLTK", 5, 157499},
	{"TCLP", 4, 168580},
	{"TCLO", 4, 37347},
	{"TCLI", 4, 41251},
	{"TCLE", 4, 36633},
	{"TCLASS", 6, 162234},
	{"TCKS", 4, 260208},
	{"TCKETS", 6, 257695},
	{"TCJU", 4, 261205},
	{"TCIV", 4, 63541},
	{"TCIT", 4, 35209},
	{"TCIR", 4, 53843},
	{"TCINCOTT", 8, 240717},
	{"TCIM", 4, 237353},
	{"TCIG", 4, 146695},
	{"TCIC", 4, 209895},
	{"TCHY", 4, 55332},
	{"TCHW", 4, 38133},
	{"TCHV", 4, 92258},
	{"TCHU", 4, 31553},
	{"TCHT", 4, 28692},
	{"TCHR", 4, 152494},
	{"TCHQ", 4, 190633},
	{"TCHP", 4, 46012},
	{"TCHO", 4, 29752},
	{"TCHM", 4, 44406},
	{"TCHL", 4, 54750},
	{"TCHK", 4, 85972},
	{"TCHJ", 4, 98147},
	{"TCHI", 4, 4029},
	{"TCHF", 4, 39018},
	{"TCHD", 4, 52107},
	{"TCHB", 4, 40762},
	{"TCHAR", 5, 237770},
	{"TCHAIKOVSKY", 11, 69141},
	{"TCHAD", 5, 208858},
	{"TCHA", 4, 4014},
	{"TCFS", 4, 251472},
	{"TCFR", 4, 204139},
	{"TCFO", 4, 125889},
	{"TCFI", 4, 255994},
	{"TCFB", 4, 227939},
	{"TCFA", 4, 232100},
	{"TCEV", 4, 214037},
	{"TCER", 4, 39566},
	{"TCEQ", 4, 130140},
	{"TCEN", 4, 31505},
	{"TCEM", 4, 106284},
	{"TCEL", 4, 48355},
	{"TCED", 4, 119681},
	{"TCEC", 4, 147876},
	{"TCDR", 4, 189559},
	{"TCDO", 4, 175625},
	{"TCDI", 4, 194667},
	{"TCDE", 4, 165057},
	{"TCDD", 4, 117646},
	{"TCDA", 4, 229747},
	{"TCCO", 4, 112486},
	{"TCCH", 4, 187464},
	{"TCCE", 4, 250120},
	{"TCCD", 4, 206319},
	{"TCCC", 4, 180233},
	{"TCBY", 4, 230479},
	{"TCBU", 4, 116699},
	{"TCBE", 4, 168996},
	{"TCBA", 4, 210108},
	{"TCAV", 4, 78013},
	{"TCAU", 4, 36766},
	{"TCAP", 4, 186241},
	{"TCAN", 4, 4007},
	{"TCAM", 4, 209414},
	{"TCAK", 4, 103194},
	{"TCAF", 4, 94531},
	{"TCAB", 4, 68363},
	{"TBYZ", 4, 186278},
	{"TBYY", 4, 132875},
	{"TBYW", 4, 65496},
	{"TBYV", 4, 97952},
	{"TBYU", 4, 81812},
	{"TBYT", 4, 29606},
	{"TBYS", 4, 46821},
	{"TBYR", 4, 59232},
	{"TBYQ", 4, 226730},
	{"TBYP", 4, 52246},
	{"TBYO", 4, 68744},
	{"TBYN", 4, 68605},
	{"TBYM", 4, 52557},
	{"TBYL", 4, 64366},
	{"TBYK", 4, 96832},
	{"TBYJ", 4, 76605},
	{"TBYI", 4, 66157},
	{"TBYH", 4, 54197},
	{"TBYG", 4, 69772},
	{"TBYF", 4, 60696},
	{"TBYE", 4, 67171},
	{"TBYD", 4, 60698},
	{"TBYC", 4, 53386},
	{"TBYB", 4, 59756},
	{"TBYA", 4, 38032},
	{"TBY", 3, 732},
	{"TBWA", 4, 238282},
	{"TBUZ", 4, 129762},
	{"TBUY", 4, 45471},
	{"TBUT", 4, 4529},
	{"TBUS", 4, 35867},
	{"TBUR", 4, 40272},
	{"TBUO", 4, 243906},
	{"TBUN", 4, 82267},
	{"TBUM", 4, 98495},
	{"TBUL", 4, 51084},
	{"TBUI", 4, 38168},
	{"TBUG", 4, 120546},
	{"TBUFFER", 7, 189439},
	{"TBUE", 4, 186507},
	{"TBUD", 4, 55979},
	{"TBUC", 4, 71502},
	{"TBUB", 4, 102281},
	{"TBSP", 4, 56132},
	{"TBSD", 4, 229748},
	{"TBRY", 4, 97302},
	{"TBRU", 4, 63595},
	{"TBRO", 4, 31701},
	{"TBRI", 4, 31360},
	{"TBRE", 4, 33323},
	{"TBRANCH", 7, 247830},
	{"TBRA", 4, 40091},
	{"TBPS", 4, 206632},
	{"TBPC", 4, 227283},
	{"TBPA", 4, 199355},
	{"TBOY", 4, 58262},
	{"TBOX", 4, 146720},
	{"TBOW", 4, 59583},
	{"TBOU", 4, 44364},
	{"TBOT", 4, 33999},
	{"TBOR", 4, 44007},
	{"TBOO", 4, 35237},
	{"TBONE", 5, 243984},
	{"TBOM", 4, 74888},
	{"TBOL", 4, 75682},
	{"TBOKICH", 7, 160712},
	{"TBOGG", 5, 104830},
	{"TBOG", 4, 108423},
	{"TBOF", 4, 215464},
	{"TBODY", 5, 128758},
	{"TBOD", 4, 51735},
	{"TBOC", 4, 171191},
	{"TBOB", 4, 67681},
	{"TBNW", 4, 221073},
	{"TBNID", 5, 226484},
	{"TBMW", 4, 219507},
	{"TBMO", 4, 230590},
	{"TBLY", 4, 242721},
	{"TBLV", 4, 223301},
	{"TBLU", 4, 52564},
	{"TBLSP", 5, 244645},
	{"TBLS", 4, 201657},
	{"TBLOOD", 6, 104312},
	{"TBLOG", 5, 179013},
	{"TBLO", 4, 39270},
	{"TBLI", 4, 76539},
	{"TBLA", 4, 38463},
	{"TBIZ", 4, 153843},
	{"TBIRD", 5, 202492},
	{"TBIR", 4, 52775},
	{"TBIP", 4, 174033},
	{"TBILISI", 7, 74861},
	{"TBIL", 4, 38448},
	{"TBIK", 4, 92090},
	{"TBIG", 4, 42522},
	{"TBID", 4, 70007},
	{"TBIC", 4, 123234},
	{"TBIB", 4, 117800},
	{"TBHU", 4, 240145},
	{"TBEW", 4, 55970},
	{"TBEV", 4, 76244},
	{"TBEU", 4, 54627},
	{"TBET", 4, 7699},
	{"TBES", 4, 33029},
	{"TBEQ", 4, 132228},
	{"TBEP", 4, 44485},
	{"TBEM", 4, 48379},
	{"TBEL", 4, 28526},
	{"TBEK", 4, 89748},
	{"TBEJ", 4, 107138},
	{"TBEI", 4, 28404},
	{"TBEH", 4, 36136},
	{"TBEG", 4, 33978},
	{"TBEF", 4, 9546},
	{"TBEE", 4, 9396},
	{"TBED", 4, 42325},
	{"TBEC", 4, 4816},
	{"TBEB", 4, 52884},
	{"TBEA", 4, 7773},
	{"TBCO", 4, 225551},
	{"TBCH", 4, 239597},
	{"TBCE", 4, 244809},
	{"TBCA", 4, 188562},
	{"TBBC", 4, 142563},
	{"TBAZ", 4, 232101},
	{"TBAY", 4, 57912},
	{"TBAX", 4, 258162},
	{"TBAU", 4, 129802},
	{"TBAP", 4, 85604},
	{"TBAN", 4, 33622},
	{"TBAM", 4, 157668},
	{"TBAL", 4, 3363},
	{"TBAK", 4, 83241},
	{"TBAG", 4, 75218},
	{"TBAF", 4, 193942},
	{"TBAD", 4, 50202},
	{"TBAC", 4, 7518},
	{"TBAB", 4, 75674},
	{"TAZZA", 5, 260138},
	{"TAZZ", 4, 157956},
	{"TAZU", 4, 206633},
	{"TAZEWELL", 8, 98555},
	{"TAYYIP", 6, 201839},
	{"TAYY", 4, 164982},
	{"TAYW", 4, 58883},
	{"TAYV", 4, 236738},
	{"TAYU", 4, 88679},
	{"TAYSIDE", 7, 89723},
	{"TAYR", 4, 115206},
	{"TAYP", 4, 97447},
	{"TAYMOR", 6, 235760},
	{"TAYM", 4, 122234},
	{"TAYLORVILLE", 11, 153115},
	{"TAYLORSVILLE", 12, 104674},
	{"TAYLORS", 7, 76207},
	{"TAYLORMADE", 10, 75459},
	{"TAYLOR", 6, 4633},
	{"TAYLER", 6, 159412},
	{"TAYI", 4, 35408},
	{"TAYG", 4, 218645},
	{"TAYF", 4, 77866},
	{"TAYD", 4, 137862},
	{"TAYC", 4, 80238},
	{"TAYB", 4, 89669},
	{"TAXY", 4, 147877},
	{"TAXW", 4, 73978},
	{"TAXV", 4, 214820},
	{"TAXUS", 5, 164629},
	{"TAXU", 4, 184479},
	{"TAXR", 4, 43423},
	{"TAXPROF", 7, 209252},
	{"TAXPAYING", 9, 232026},
	{"TAXPAYERS", 9, 39309},
	{"TAXPAYER", 8, 10019},
	{"TAXP", 4, 37232},
	{"TAXOTERE", 8, 188661},
	{"TAXONOMY", 8, 40000},
	{"TAXONOMISTS", 11, 202179},
	{"TAXONOMIES", 10, 117709},
	{"TAXONOMIC", 9, 59377},
	{"TAXON", 5, 55661},
	{"TAXOL", 5, 127333},
	{"TAXMAN", 6, 126599},
	{"TAXM", 4, 85984},
	{"TAXL", 4, 76651},
	{"TAXIWAYS", 8, 202383},
	{"TAXIWAY", 7, 136281},
	{"TAXIS", 5, 48110},
	{"TAXING", 6, 56522},
	{"TAXIING", 7, 175666},
	{"TAXIED", 6, 243536},
	{"TAXIDERMY", 9, 85495},
	{"TAXIDERMISTS", 12, 215192},
	{"TAXIDERMIST", 11, 191445},
	{"TAXID", 5, 115862},
	{"TAXICABS", 8, 111845},
	{"TAXICAB", 7, 93995},
	{"TAXI", 4, 32001},
	{"TAXG", 4, 151248},
	{"TAXF", 4, 69971},
	{"TAXES", 5, 3723},
	{"TAXED", 5, 52908},
	{"TAXD", 4, 61172},
	{"TAXCUT", 6, 111783},
	{"TAXCO", 5, 174199},
	{"TAXC", 4, 42810},
	{"TAXBRAIN", 8, 164318},
	{"TAXB", 4, 52212},
	{"TAXATIONWEB", 11, 253128},
	{"TAXATION", 8, 30231},
	{"TAXALMANAC", 10, 223353},
	{"TAXACT", 6, 260969},
	{"TAXABLE", 7, 37766},
	{"TAXABILITY", 10, 245958},
	{"TAX", 3, 1673},
	{"TAWR", 4, 104438},
	{"TAWNYA", 6, 171079},
	{"TAWNY", 5, 74882},
	{"TAWNEY", 6, 212462},
	{"TAWNEE", 6, 41841},
	{"TAWK", 4, 164658},
	{"TAWHID", 6, 199809},
	{"TAWF", 4, 136954},
	{"TAWDRY", 6, 160056},
	{"TAWD", 4, 220181},
	{"TAWB", 4, 126438},
	{"TAWAS", 5, 131237},
	{"TAWANA", 6, 229921},
	{"TAVW", 4, 243907},
	{"TAVU", 4, 149914},
	{"TAVR", 4, 137932},
	{"TAVOLO", 6, 173545},
	{"TAVOLI", 6, 203325},
	{"TAVOLA", 6, 209422},
	{"TAVM", 4, 228719},
	{"TAVISTOCK", 9, 93006},
	{"TAVIS", 5, 138841},
	{"TAVIRA", 6, 186259},
	{"TAVEUNI", 7, 204936},
	{"TAVERNS", 7, 86291},
	{"TAVERNITI", 9, 228666},
	{"TAVERNIER", 9, 136000},
	{"TAVERNER", 8, 211885},
	{"TAVERNE", 7, 251312},
	{"TAVERNAS", 8, 191554},
	{"TAVERNA", 7, 115372},
	{"TAVERN", 6, 43674},
	{"TAVERAS", 7, 248691},
	{"TAVENER", 7, 200359},
	{"TAVEL", 5, 186407},
	{"TAVAREZ", 7, 226093},
	{"TAVARES", 7, 98541},
	{"TAUZIN", 6, 134354},
	{"TAUX", 4, 114553},
	{"TAUTOU", 6, 172165},
	{"TAUTOLOGY", 9, 158473},
	{"TAUTOLOGICAL", 12, 228683},
	{"TAUSSIG", 7, 220940},
	{"TAUSCHER", 8, 179377},
	{"TAURUS", 6, 47277},
	{"TAURO", 5, 256118},
	{"TAURIS", 6, 206488},
	{"TAURINE", 7, 103143},
	{"TAURI", 5, 176584},
	{"TAUREN", 6, 147853},
	{"TAUREAN", 7, 253750},
	{"TAURASI", 7, 234443},
	{"TAURANGA", 8, 81105},
	{"TAUQ", 4, 188882},
	{"TAUPO", 5, 76705},
	{"TAUPIN", 6, 219420},
	{"TAUPE", 5, 71882},
	{"TAUP", 4, 76423},
	{"TAUNUS", 6, 181512},
	{"TAUNTS", 6, 120299},
	{"TAUNTON", 7, 55688},
	{"TAUNTING", 8, 102371},
	{"TAUNTED", 7, 131731},
	{"TAUNT", 5, 99580},
	{"TAUL", 4, 137136},
	{"TAUK", 4, 140528},
	{"TAUGHT", 6, 7201},
	{"TAUG", 4, 32382},
	{"TAUF", 4, 113644},
	{"TAUERNE", 7, 205355},
	{"TAUD", 4, 59804},
	{"TAUCK", 5, 139182},
	{"TAUCHEN", 7, 189182},
	{"TAUC", 4, 72389},
	{"TAUBMAN", 7, 134675},
	{"TAUBER", 6, 131570},
	{"TAUBE", 5, 171426},
	{"TAUB", 4, 133281},
	{"TATYANA", 7, 111883},
	{"TATUS", 5, 209407},
	{"TATUPU", 6, 217886},
	{"TATUNG", 6, 99185},
	{"TATUM", 5, 75670},
	{"TATUAJES", 8, 224323},
	{"TATUAGGI", 8, 238576},
	{"TATTY", 5, 140946},
	{"TATTOS", 6, 245602},
	{"TATTOOS", 7, 39942},
	{"TATTOONOW", 9, 188313},
	{"TATTOOISTS", 10, 185420},
	{"TATTOOING", 9, 93236},
	{"TATTOOED", 8, 74182},
	{"TATTOOD", 7, 168146},
	{"TATTOO", 6, 32794},
	{"TATTON", 6, 174430},
	{"TATTNALL", 8, 209621},
	{"TATTLER", 7, 190323},
	{"TATTLE", 6, 161821},
	{"TATTING", 7, 138475},
	{"TATTERSALL", 10, 146002},
	{"TATTERS", 7, 149223},
	{"TATTERED", 8, 86069},
	{"TATSUYA", 7, 146447},
	{"TATSUO", 6, 174918},
	{"TATSUMI", 7, 206596},
	{"TATSU", 5, 220959},
	{"TATRY", 5, 259389},
	{"TATRO", 5, 239752},
	{"TATRAS", 6, 213704},
	{"TATRA", 5, 128213},
	{"TATOUAGES", 9, 144073},
	{"TATOUAGE", 8, 108893},
	{"TATORNEY", 8, 248871},
	{"TATOR", 5, 259172},
	{"TATOOS", 6, 111567},
	{"TATOOINE", 8, 149995},
	{"TATOOED", 7, 210985},
	{"TATMADAW", 8, 236611},
	{"TATLER", 6, 181685},
	{"TATLAYOKO", 9, 261493},
	{"TATLA", 5, 251705},
	{"TATJANA", 7, 164426},
	{"TATIVE", 6, 173691},
	{"TATIONS", 7, 129643},
	{"TATIONAL", 8, 239436},
	{"TATION", 6, 69139},
	{"TATIANA", 7, 74293},
	{"TATHAM", 6, 177105},
	{"TATHAGATA", 9, 203581},
	{"TATEYAMA", 8, 197409},
	{"TATERS", 6, 215527},
	{"TATER", 5, 117221},
	{"TATEMENT", 8, 213448},
	{"TATED", 5, 245622},
	{"TATCHELL", 8, 218620},
	{"TATARSTAN", 9, 141212},
	{"TATARS", 6, 172940},
	{"TATAR", 5, 96563},
	{"TATAMI", 6, 148831},
	{"TASW", 4, 35848},
	{"TASTY", 5, 40322},
	{"TASTINGS", 8, 89615},
	{"TASTING", 7, 40201},
	{"TASTIEST", 8, 170964},
	{"TASTIER", 7, 193592},
	{"TASTIC", 6, 125552},
	{"TASTES", 6, 40153},
	{"TASTERS", 7, 163496},
	{"TASTER", 6, 94574},
	{"TASTELESS", 9, 71411},
	{"TASTELE", 7, 242280},
	{"TASTEFULLY", 10, 71700},
	{"TASTEFUL", 8, 67619},
	{"TASTED", 6, 55907},
	{"TASTEBUDS", 9, 197243},
	{"TASTE", 5, 6311},
	{"TASTATUR", 8, 220751},
	{"TASSOS", 6, 212574},
	{"TASSLES", 7, 249935},
	{"TASSLE", 6, 224757},
	{"TASSIN", 6, 228600},
	{"TASSIMO", 7, 163114},
	{"TASSIE", 6, 147336},
	{"TASSELS", 7, 102006},
	{"TASSELL", 7, 249987},
	{"TASSEL", 6, 78515},
	{"TASMIN", 6, 240640},
	{"TASMANIANS", 10, 246307},
	{"TASMANIANA", 10, 258785},
	{"TASMANIAN", 9, 58568},
	{"TASMANIA", 8, 38941},
	{"TASMAN", 6, 69727},
	{"TASKSEL", 7, 245700},
	{"TASKS", 5, 5909},
	{"TASKMASTER", 10, 174881},
	{"TASKMANAGER", 11, 253258},
	{"TASKLIST", 8, 184278},
	{"TASKING", 7, 78998},
	{"TASKFORCE", 9, 76780},
	{"TASKER", 6, 118380},
	{"TASKED", 6, 75063},
	{"TASKBAR", 7, 72266},
	{"TASK", 4, 3028},
	{"TASHKENT", 8, 81798},
	{"TASHIRO", 7, 215770},
	{"TASERS", 6, 141084},
	{"TASER", 5, 97135},
	{"TASCO", 5, 100769},
	{"TASCHENGELD", 11, 102923},
	{"TASCHENBUCH", 11, 148818},
	{"TASCHEN", 7, 119893},
	{"TASCHE", 6, 197336},
	{"TASCAM", 6, 69535},
	{"TASCA", 5, 182218},
	{"TARZANA", 7, 110161},
	{"TARZAN", 6, 58728},
	{"TARZ", 4, 95841},
	{"TARYN", 5, 97672},
	{"TARY", 4, 100894},
	{"TARW", 4, 45122},
	{"TARVER", 6, 121679},
	{"TARVEL", 6, 251279},
	{"TARV", 4, 54250},
	{"TARUN", 5, 133799},
	{"TARU", 4, 234654},
	{"TARTUFFE", 8, 201557},
	{"TARTU", 5, 101557},
	{"TARTT", 5, 218529},
	{"TARTS", 5, 70380},
	{"TARTRATE", 8, 115888},
	{"TARTER", 6, 156007},
	{"TARTE", 5, 149898},
	{"TARTARUS", 8, 136640},
	{"TARTARUGHE", 10, 257706},
	{"TARTARUGA", 9, 224856},
	{"TARTARS", 7, 216699},
	{"TARTARIC", 8, 195833},
	{"TARTARE", 7, 197793},
	{"TARTAR", 6, 94237},
	{"TARTANS", 7, 111797},
	{"TARTAN", 6, 58042},
	{"TARTAGLIA", 9, 238067},
	{"TARSUS", 6, 110320},
	{"TARSKI", 6, 147837},
	{"TARSAL", 6, 177990},
	{"TARRYTOWN", 9, 91320},
	{"TARRY", 5, 107813},
	{"TARRING", 7, 242264},
	{"TARRIED", 7, 221981},
	{"TARRIE", 6, 198189},
	{"TARRED", 6, 146195},
	{"TARRANT", 7, 63059},
	{"TARRANI", 7, 237235},
	{"TARRAGONA", 9, 96753},
	{"TARRAGON", 8, 105240},
	{"TARR", 4, 112170},
	{"TARQUINIUS", 10, 243595},
	{"TARQUIN", 7, 193288},
	{"TARQ", 4, 125950},
	{"TARPS", 5, 93408},
	{"TARPORLEY", 9, 215167},
	{"TARPON", 6, 79305},
	{"TARPLEY", 7, 181167},
	{"TARPAULINS", 10, 152448},
	{"TARPAULIN", 9, 147053},
	{"TARP", 4, 85234},
	{"TAROT", 5, 40340},
	{"TARONGA", 7, 222028},
	{"TARNOVO", 7, 115483},
	{"TARNISHING", 10, 165910},
	{"TARNISHED", 9, 96500},
	{"TARNISH", 7, 97323},
	{"TARNG", 5, 185165},
	{"TARNATION", 9, 195370},
	{"TARMO", 5, 244614},
	{"TARMAC", 6, 90967},
	{"TARM", 4, 39625},
	{"TARLTON", 7, 195771},
	{"TARLETON", 8, 117336},
	{"TARLAC", 6, 222690},
	{"TARL", 4, 52658},
	{"TARKOVSKY", 9, 182116},
	{"TARKIO", 6, 260230},
	{"TARKINGTON", 10, 216293},
	{"TARKIN", 6, 261479},
	{"TARKETT", 7, 194908},
	{"TARKAN", 6, 134950},
	{"TARKA", 5, 201325},
	{"TARJETAS", 8, 106943},
	{"TARJETA", 7, 117575},
	{"TARJAN", 6, 192315},
	{"TARJA", 5, 131651},
	{"TARJ", 4, 86352},
	{"TARIQ", 5, 85891},
	{"TARINA", 6, 182101},
	{"TARIN", 5, 202981},
	{"TARIM", 5, 247982},
	{"TARIK", 5, 157517},
	{"TARIH", 5, 255177},
	{"TARIFS", 6, 99865},
	{"TARIFFS", 7, 42602},
	{"TARIFFED", 8, 225424},
	{"TARIFFE", 7, 159517},
	{"TARIFFA", 7, 181065},
	{"TARIFF", 6, 34822},
	{"TARIFE", 6, 255560},
	{"TARIFAS", 7, 148463},
	{"TARIFA", 6, 115671},
	{"TARIF", 5, 121264},
	{"TARHEELS", 8, 165950},
	{"TARHEEL", 7, 187854},
	{"TARGUS", 6, 51647},
	{"TARGUM", 6, 174843},
	{"TARGOVISHTE", 11, 210337},
	{"TARGNAME", 8, 244672},
	{"TARGHEE", 7, 169750},
	{"TARGETTING", 10, 130706},
	{"TARGETTED", 9, 110705},
	{"TARGETSEARCH", 12, 256401},
	{"TARGETS", 7, 7739},
	{"TARGETNAMESPACE", 15, 179380},
	{"TARGETNAME", 10, 237431},
	{"TARGETING", 9, 36882},
	{"TARGETED", 8, 9823},
	{"TARGETDOG", 9, 189751},
	{"TARGET", 6, 3868},
	{"TARGE", 5, 253617},
	{"TARGA", 5, 77733},
	{"TARG", 4, 120053},
	{"TARF", 4, 52319},
	{"TARES", 5, 184802},
	{"TAREQ", 5, 261420},
	{"TARENTUM", 8, 198287},
	{"TAREN", 5, 245968},
	{"TAREK", 5, 125270},
	{"TAREE", 5, 135085},
	{"TARDY", 5, 98469},
	{"TARDIVE", 7, 152766},
	{"TARDIS", 6, 113695},
	{"TARDINESS", 9, 121734},
	{"TARDIF", 6, 189202},
	{"TARDIEU", 7, 258332},
	{"TARDIES", 7, 219395},
	{"TARDE", 5, 143544},
	{"TARD", 4, 117381},
	{"TARCHER", 7, 232848},
	{"TARCEVA", 7, 222066},
	{"TARC", 4, 256888},
	{"TARBOX", 6, 243972},
	{"TARBORO", 7, 140955},
	{"TARBES", 6, 229143},
	{"TARBERT", 7, 164434},
	{"TARBELL", 7, 169754},
	{"TARBALLS", 8, 137804},
	{"TARBALL", 7, 76296},
	{"TARB", 4, 43353},
	{"TARAWERA", 8, 180517},
	{"TARAWA", 6, 147641},
	{"TARAS", 5, 133726},
	{"TARANTULAS", 10, 168530},
	{"TARANTULA", 9, 88883},
	{"TARANTO", 7, 115465},
	{"TARANTINO", 9, 69855},
	{"TARANTELLA", 10, 146714},
	{"TARANGIRE", 9, 198462},
	{"TARANAKI", 8, 72465},
	{"TARAN", 5, 112721},
	{"TARAHUMARA", 10, 201372},
	{"TARAH", 5, 232477},
	{"TARAGO", 6, 238917},
	{"TAQWA", 5, 254702},
	{"TAQUERIA", 8, 133539},
	{"TAQU", 4, 55084},
	{"TAQMAN", 6, 160761},
	{"TAPY", 4, 240464},
	{"TAPWAVE", 7, 104558},
	{"TAPW", 4, 128267},
	{"TAPU", 4, 117933},
	{"TAPSCOTT", 8, 139391},
	{"TAPROOT", 7, 95921},
	{"TAPPS", 5, 251343},
	{"TAPPING", 7, 49359},
	{"TAPPIN", 6, 227109},
	{"TAPPI", 5, 162359},
	{"TAPPET", 6, 232639},
	{"TAPPERS", 7, 244341},
	{"TAPPER", 6, 118575},
	{"TAPPEN", 6, 195603},
	{"TAPPED", 6, 51658},
	{"TAPPAN", 6, 103521},
	{"TAPPAHANNOCK", 12, 208647},
	{"TAPP", 4, 136572},
	{"TAPOS", 5, 215393},
	{"TAPM", 4, 159803},
	{"TAPLOW", 6, 240620},
	{"TAPLINGER", 9, 260668},
	{"TAPLIN", 6, 191489},
	{"TAPLEY", 6, 226190},
	{"TAPL", 4, 41702},
	{"TAPIS", 5, 146794},
	{"TAPIR", 5, 168913},
	{"TAPIOCA", 7, 90712},
	{"TAPIO", 5, 174300},
	{"TAPINGS", 7, 231047},
	{"TAPING", 6, 64718},
	{"TAPIA", 5, 126956},
	{"TAPG", 4, 241596},
	{"TAPF", 4, 178303},
	{"TAPEWORMS", 9, 196984},
	{"TAPEWORM", 8, 142123},
	{"TAPEWARE", 8, 180984},
	{"TAPETY", 6, 64916},
	{"TAPETA", 6, 98632},
	{"TAPESTRY", 8, 44691},
	{"TAPESTRIES", 10, 62049},
	{"TAPES", 5, 28974},
	{"TAPERS", 6, 86136},
	{"TAPERING", 8, 96646},
	{"TAPERED", 7, 59986},
	{"TAPER", 5, 56254},
	{"TAPENADE", 8, 202647},
	{"TAPELESS", 8, 221861},
	{"TAPED", 5, 52947},
	{"TAPE", 4, 4483},
	{"TAPD", 4, 140662},
	{"TAPCO", 5, 164875},
	{"TAPC", 4, 154239},
	{"TAPB", 4, 227211},
	{"TAPATIO", 7, 226789},
	{"TAPAS", 5, 75930},
	{"TAPANI", 6, 253514},
	{"TAPAN", 5, 221010},
	{"TAOYUAN", 7, 172425},
	{"TAORMINA", 8, 94978},
	{"TAONGA", 6, 200060},
	{"TAOIST", 6, 95531},
	{"TAOISM", 6, 87718},
	{"TAOISEACH", 9, 83915},
	{"TANZI", 5, 241270},
	{"TANZER", 6, 219144},
	{"TANZEN", 6, 254298},
	{"TANZANITE", 9, 70090},
	{"TANZANIAN", 9, 72175},
	{"TANZANIA", 8, 29873},
	{"TANYETTE", 8, 238466},
	{"TANYAS", 6, 221175},
	{"TANYARD", 7, 242582},
	{"TANYA", 5, 49726},
	{"TANUKI", 6, 217349},
	{"TANTUS", 6, 141711},
	{"TANTUM", 6, 230102},
	{"TANTRUMS", 8, 107521},
	{"TANTRUM", 7, 101115},
	{"TANTRIX", 7, 189336},
	{"TANTRIC", 7, 80958},
	{"TANTRAMASSAGEN", 14, 189997},
	{"TANTRAMASSAGE", 13, 198279},
	{"TANTRA", 6, 68422},
	{"TANTEK", 6, 174815},
	{"TANTAMOUNT", 10, 97527},
	{"TANTALUS", 8, 169286},
	{"TANTALUM", 8, 98722},
	{"TANTALIZINGLY", 13, 243547},
	{"TANTALIZING", 11, 92683},
	{"TANTALIZE", 9, 218221},
	{"TANTALISING", 11, 176644},
	{"TANSY", 5, 178386},
	{"TANSU", 5, 229869},
	{"TANSLEY", 7, 225397},
	{"TANSEY", 6, 191717},
	{"TANQUE", 6, 220861},
	{"TANNY", 5, 240413},
	{"TANNOY", 6, 96177},
	{"TANNINS", 7, 90040},
	{"TANNINGCAM", 10, 131836},
	{"TANNING", 7, 37494},
	{"TANNIN", 6, 120654},
	{"TANNIC", 6, 158688},
	{"TANNHAUSER", 10, 258617},
	{"TANNERY", 7, 112553},
	{"TANNERSVILLE", 12, 159630},
	{"TANNERS", 7, 128402},
	{"TANNERIES", 9, 213189},
	{"TANNER", 6, 51388},
	{"TANNENBAUM", 10, 134479},
	{"TANNEN", 6, 167813},
	{"TANNEHILL", 9, 222697},
	{"TANNED", 6, 49070},
	{"TANNAHILL", 9, 257149},
	{"TANLINES", 8, 258302},
	{"TANKSLEY", 8, 260336},
	{"TANKS", 5, 30307},
	{"TANKLESS", 8, 104576},
	{"TANKINIS", 8, 251331},
	{"TANKINI", 7, 117278},
	{"TANKING", 7, 177158},
	{"TANKERSLEY", 10, 194880},
	{"TANKERS", 7, 74732},
	{"TANKER", 6, 56501},
	{"TANKED", 6, 163498},
	{"TANKCSAPDA", 10, 153173},
	{"TANKARDS", 8, 155586},
	{"TANKARD", 7, 104458},
	{"TANKA", 5, 134664},
	{"TANK", 4, 5806},
	{"TANJUNG", 7, 132707},
	{"TANJUG", 6, 241195},
	{"TANJORE", 7, 199154},
	{"TANJONG", 7, 190140},
	{"TANJA", 5, 104514},
	{"TANITH", 6, 193011},
	{"TANITA", 6, 86290},
	{"TANISHA", 7, 213737},
	{"TANIMOTO", 8, 253441},
	{"TANIGUCHI", 9, 132959},
	{"TANGY", 5, 94684},
	{"TANGUY", 6, 203908},
	{"TANGUAY", 7, 173706},
	{"TANGSHAN", 8, 235301},
	{"TANGS", 5, 225150},
	{"TANGRAM", 7, 131040},
	{"TANGOWIRE", 9, 133984},
	{"TANGOS", 6, 184958},
	{"TANGO", 5, 43730},
	{"TANGLING", 8, 178133},
	{"TANGLIN", 7, 259865},
	{"TANGLEWOOD", 10, 100916},
	{"TANGLES", 7, 116732},
	{"TANGLED", 7, 60933},
	{"TANGLE", 6, 77336},
	{"TANGLAO", 7, 198893},
	{"TANGIPAHOA", 10, 164267},
	{"TANGIERS", 8, 220055},
	{"TANGIER", 7, 109276},
	{"TANGIBLY", 8, 216433},
	{"TANGIBLE", 8, 42068},
	{"TANGERINES", 10, 155264},
	{"TANGERINE", 9, 61497},
	{"TANGER", 6, 144157},
	{"TANGENTS", 8, 121026},
	{"TANGENTIALLY", 12, 175894},
	{"TANGENTIAL", 10, 90572},
	{"TANGENT", 7, 54695},
	{"TANGENCY", 8, 223444},
	{"TANGELO", 7, 255607},
	{"TANGE", 5, 206589},
	{"TANGATA", 7, 165559},
	{"TANGAS", 6, 185289},
	{"TANGANYIKA", 10, 135188},
	{"TANGA", 5, 104033},
	{"TANEYTOWN", 9, 216434},
	{"TANEY", 5, 142578},
	{"TANER", 5, 242961},
	{"TANENBAUM", 9, 140799},
	{"TANEJA", 6, 213466},
	{"TANDY", 5, 86687},
	{"TANDRIDGE", 9, 202997},
	{"TANDOORI", 8, 107229},
	{"TANDOOR", 7, 219460},
	{"TANDON", 6, 126928},
	{"TANDEN", 6, 168236},
	{"TANDEMS", 7, 139788},
	{"TANDEM", 6, 45451},
	{"TANDBERG", 8, 82869},
	{"TANDARTS", 8, 132122},
	{"TANDARDS", 8, 214768},
	{"TANDARD", 7, 223162},
	{"TANDA", 5, 215972},
	{"TANCREDO", 8, 119940},
	{"TANCREDI", 8, 254665},
	{"TANCES", 6, 244162},
	{"TANCE", 5, 81811},
	{"TANC", 4, 3133},
	{"TANARUS", 7, 210850},
	{"TANANA", 6, 143009},
	{"TANAKH", 6, 180402},
	{"TANAKA", 6, 61556},
	{"TANAGERS", 8, 256765},
	{"TANAGER", 7, 111702},
	{"TANACH", 6, 213791},
	{"TANABE", 6, 106025},
	{"TAMY", 4, 99572},
	{"TAMWORTH", 8, 63901},
	{"TAMW", 4, 70899},
	{"TAMURA", 6, 115918},
	{"TAMU", 4, 99648},
	{"TAMSULOSIN", 10, 248991},
	{"TAMSIN", 6, 154495},
	{"TAMRON", 6, 74152},
	{"TAMRAC", 6, 118040},
	{"TAMRA", 5, 162555},
	{"TAMR", 4, 110109},
	{"TAMPONS", 7, 109091},
	{"TAMPONADE", 9, 204371},
	{"TAMPON", 6, 84912},
	{"TAMPING", 7, 202166},
	{"TAMPINES", 8, 170413},
	{"TAMPICO", 7, 134215},
	{"TAMPERS", 7, 194792},
	{"TAMPERPROOF", 11, 261168},
	{"TAMPERING", 9, 72380},
	{"TAMPERED", 8, 101952},
	{"TAMPERE", 7, 74562},
	{"TAMPER", 6, 71591},
	{"TAMPAX", 6, 219013},
	{"TAMPATOWERSHOTEL", 16, 101392},
	{"TAMPABAYCOM", 11, 256932},
	{"TAMPA", 5, 6646},
	{"TAMP", 4, 161709},
	{"TAMOXIFEN", 9, 74252},
	{"TAMORA", 6, 151223},
	{"TAMMY", 5, 48160},
	{"TAMMUZ", 6, 206821},
	{"TAMMIN", 6, 253821},
	{"TAMMIE", 6, 140962},
	{"TAMMI", 5, 122052},
	{"TAMMANY", 7, 102512},
	{"TAMM", 4, 180389},
	{"TAMLA", 5, 210541},
	{"TAML", 4, 136289},
	{"TAMK", 4, 148222},
	{"TAMJ", 4, 149979},
	{"TAMIYA", 6, 69641},
	{"TAMIR", 5, 189213},
	{"TAMINO", 6, 177579},
	{"TAMING", 6, 76469},
	{"TAMIM", 5, 251448},
	{"TAMILS", 6, 116434},
	{"TAMILNET", 8, 199441},
	{"TAMILNADU", 9, 103260},
	{"TAMIL", 5, 36227},
	{"TAMIKA", 6, 175724},
	{"TAMIFLU", 7, 48552},
	{"TAMIAMI", 7, 123536},
	{"TAMIA", 5, 119517},
	{"TAMG", 4, 165058},
	{"TAMF", 4, 60218},
	{"TAMESIDE", 8, 85650},
	{"TAMES", 5, 149901},
	{"TAMERS", 6, 215583},
	{"TAMERLANE", 9, 236190},
	{"TAMERA", 6, 213331},
	{"TAMER", 5, 92208},
	{"TAMEN", 5, 231377},
	{"TAMED", 5, 108575},
	{"TAMD", 4, 120905},
	{"TAMC", 4, 236162},
	{"TAMBOURINES", 11, 165954},
	{"TAMBOURINE", 10, 96614},
	{"TAMBOUR", 7, 169425},
	{"TAMBORINE", 9, 151192},
	{"TAMBOR", 6, 154207},
	{"TAMBON", 6, 233993},
	{"TAMBO", 5, 177149},
	{"TAMBLYN", 7, 136745},
	{"TAMBIEN", 7, 110687},
	{"TAMBA", 5, 185537},
	{"TAMAYO", 6, 157600},
	{"TAMAULIPAS", 10, 169483},
	{"TAMAS", 5, 130332},
	{"TAMARISK", 8, 185175},
	{"TAMARINDO", 9, 128073},
	{"TAMARIND", 8, 102657},
	{"TAMARIN", 7, 203521},
	{"TAMARI", 6, 191832},
	{"TAMARACK", 8, 98579},
	{"TAMARAC", 7, 126504},
	{"TAMARA", 6, 55646},
	{"TAMAR", 5, 82110},
	{"TAMAQUA", 7, 204105},
	{"TAMANHO", 7, 261814},
	{"TAMAN", 5, 109908},
	{"TAMALPAIS", 9, 173923},
	{"TAMALES", 7, 130915},
	{"TAMALE", 6, 141030},
	{"TAMALA", 6, 246426},
	{"TAMAKI", 6, 123925},
	{"TAMAGOTCHI", 10, 95596},
	{"TAMADOL", 7, 211972},
	{"TALZ", 4, 133773},
	{"TALY", 4, 32247},
	{"TALWIN", 6, 187134},
	{"TALWAR", 6, 231283},
	{"TALW", 4, 29269},
	{"TALV", 4, 55014},
	{"TALUS", 5, 130567},
	{"TALUKA", 6, 243417},
	{"TALUK", 5, 208020},
	{"TALU", 4, 226352},
	{"TALTON", 6, 243375},
	{"TALT", 4, 28986},
	{"TALSORIAN", 9, 176619},
	{"TALR", 4, 35157},
	{"TALQ", 4, 84609},
	{"TALPA", 5, 222801},
	{"TALOS", 5, 236671},
	{"TALONS", 6, 106265},
	{"TALON", 5, 65339},
	{"TALMUDIC", 8, 135409},
	{"TALMUD", 6, 74153},
	{"TALMAN", 6, 200640},
	{"TALMAGE", 7, 133410},
	{"TALMADGE", 8, 144800},
	{"TALM", 4, 33497},
	{"TALLYING", 8, 145735},
	{"TALLYGENICOM", 12, 137946},
	{"TALLY", 5, 49991},
	{"TALLULAH", 8, 120022},
	{"TALLS", 5, 233588},
	{"TALLOW", 6, 108606},
	{"TALLON", 6, 171139},
	{"TALLMAN", 7, 129350},
	{"TALLMADGE", 9, 164100},
	{"TALLIT", 6, 153377},
	{"TALLIS", 6, 126411},
	{"TALLINN", 7, 60834},
	{"TALLIN", 6, 234215},
	{"TALLIES", 7, 101936},
	{"TALLIED", 7, 78259},
	{"TALLI", 5, 245623},
	{"TALLGRASS", 9, 166773},
	{"TALLEYRAND", 10, 223148},
	{"TALLEY", 6, 93239},
	{"TALLEST", 7, 69874},
	{"TALLERES", 8, 219402},
	{"TALLER", 6, 52849},
	{"TALLENT", 7, 192948},
	{"TALLCOOLONE", 11, 214469},
	{"TALLASSEE", 9, 187664},
	{"TALLAPOOSA", 10, 135671},
	{"TALLAHATCHIE", 12, 199072},
	{"TALLAHASSEE", 11, 42612},
	{"TALLAGHT", 8, 138412},
	{"TALLADEGA", 9, 87616},
	{"TALLA", 5, 192728},
	{"TALL", 4, 4550},
	{"TALKY", 5, 218244},
	{"TALKUSERS", 9, 227529},
	{"TALKTIME", 8, 152651},
	{"TALKTALK", 8, 259521},
	{"TALKSWITCH", 10, 215853},
	{"TALKSHOW", 8, 240010},
	{"TALKS", 5, 7438},
	{"TALKLEFT", 8, 99428},
	{"TALKING", 7, 3454},
	{"TALKIN", 6, 59325},
	{"TALKIES", 7, 109662},
	{"TALKIE", 6, 83902},
	{"TALKGOLD", 8, 166294},
	{"TALKERS", 7, 96362},
	{"TALKER", 6, 85969},
	{"TALKEETNA", 9, 145883},
	{"TALKED", 6, 29115},
	{"TALKBACKS", 9, 183305},
	{"TALKBACK", 8, 45620},
	{"TALKATIVE", 9, 99229},
	{"TALKABOUT", 9, 100593},
	{"TALK", 4, 987},
	{"TALJ", 4, 86866},
	{"TALITY", 6, 247024},
	{"TALITHA", 7, 218860},
	{"TALISMANS", 9, 130080},
	{"TALISMAN", 8, 69360},
	{"TALISMA", 7, 231172},
	{"TALISKER", 8, 252043},
	{"TALIS", 5, 156597},
	{"TALINUX", 7, 189585},
	{"TALIN", 5, 244916},
	{"TALIGN", 6, 232419},
	{"TALIESIN", 8, 143757},
	{"TALICOR", 7, 208623},
	{"TALIBAN", 7, 45430},
	{"TALIB", 5, 94097},
	{"TALIAFERRO", 10, 142264},
	{"TALIA", 5, 112401},
	{"TALG", 4, 42576},
	{"TALF", 4, 37919},
	{"TALESE", 6, 204406},
	{"TALES", 5, 9801},
	{"TALER", 5, 237955},
	{"TALENTS", 7, 39228},
	{"TALENTLESS", 10, 188383},
	{"TALENTED", 8, 32304},
	{"TALENT", 6, 6290},
	{"TALEN", 5, 175538},
	{"TALEBAN", 7, 123360},
	{"TALEB", 5, 234167},
	{"TALE", 4, 7154},
	{"TALD", 4, 38259},
	{"TALCOTT", 7, 145392},
	{"TALC", 4, 93817},
	{"TALBOTT", 7, 100879},
	{"TALBOTS", 7, 163107},
	{"TALBOT", 6, 46805},
	{"TALBERT", 7, 123519},
	{"TALB", 4, 30507},
	{"TALAVERA", 8, 131299},
	{"TALAT", 5, 179305},
	{"TALAS", 5, 234681},
	{"TALAN", 5, 256259},
	{"TALAMANCA", 9, 250170},
	{"TALAL", 5, 170560},
	{"TALAGA", 6, 143333},
	{"TALABANI", 8, 133651},
	{"TAKY", 4, 197908},
	{"TAKW", 4, 193783},
	{"TAKUYA", 6, 180794},
	{"TAKURO", 6, 129031},
	{"TAKUO", 5, 211210},
	{"TAKUMI", 6, 149504},
	{"TAKUMA", 6, 204813},
	{"TAKU", 4, 149533},
	{"TAKSIM", 6, 156486},
	{"TAKR", 4, 119825},
	{"TAKOMA", 6, 105863},
	{"TAKM", 4, 186905},
	{"TAKL", 4, 213410},
	{"TAKK", 4, 158692},
	{"TAKIZAWA", 8, 255085},
	{"TAKITANI", 8, 108142},
	{"TAKIS", 5, 204902},
	{"TAKINGS", 7, 96904},
	{"TAKINGITGLOBAL", 14, 77956},
	{"TAKING", 6, 1962},
	{"TAKIN", 5, 89943},
	{"TAKIMATA", 8, 211254},
	{"TAKHT", 5, 257853},
	{"TAKEUCHI", 8, 106429},
	{"TAKETH", 6, 127002},
	{"TAKESHITA", 9, 256743},
	{"TAKESHI", 7, 87211},
	{"TAKES", 5, 2310},
	{"TAKERS", 6, 67271},
	{"TAKER", 5, 73712},
	{"TAKEOVERS", 9, 97243},
	{"TAKEOVER", 8, 49639},
	{"TAKEOUT", 7, 99793},
	{"TAKEOFFS", 8, 182150},
	{"TAKEOFF", 7, 72773},
	{"TAKEO", 5, 143939},
	{"TAKENAKA", 8, 191297},
	{"TAKEN", 5, 1675},
	{"TAKEMURA", 8, 230743},
	{"TAKEMOTO", 8, 224119},
	{"TAKEI", 5, 143286},
	{"TAKEDOWNS", 9, 226855},
	{"TAKEDOWN", 8, 90956},
	{"TAKEDA", 6, 93131},
	{"TAKED", 5, 239390},
	{"TAKEAWAYSULIKE", 14, 243443},
	{"TAKEAWAYS", 9, 108054},
	{"TAKEAWAY", 8, 82380},
	{"TAKE", 4, 778},
	{"TAKB", 4, 234299},
	{"TAKAYUKI", 8, 166578},
	{"TAKAYASU", 8, 258365},
	{"TAKAYAMA", 8, 131609},
	{"TAKAYA", 6, 244131},
	{"TAKATA", 6, 179276},
	{"TAKASHIMA", 9, 209072},
	{"TAKASHI", 7, 72393},
	{"TAKASAKI", 8, 244418},
	{"TAKARA", 6, 96403},
	{"TAKAPUNA", 8, 176820},
	{"TAKAOKA", 7, 237909},
	{"TAKAO", 5, 131013},
	{"TAKANO", 6, 178819},
	{"TAKAMINE", 8, 114345},
	{"TAKAMI", 6, 246205},
	{"TAKAMATSU", 9, 195622},
	{"TAKAKO", 6, 173175},
	{"TAKAKI", 6, 229066},
	{"TAKAKA", 6, 261776},
	{"TAKAI", 5, 222806},
	{"TAKAHIRO", 8, 170011},
	{"TAKAHASHI", 9, 63502},
	{"TAKAGI", 6, 115314},
	{"TAKAFUMI", 8, 189261},
	{"TAKADA", 6, 163485},
	{"TAKACS", 6, 221083},
	{"TAKAAKI", 7, 235083},
	{"TAJU", 4, 76667},
	{"TAJM", 4, 142791},
	{"TAJIRI", 6, 195955},
	{"TAJIMA", 6, 130526},
	{"TAJIKS", 6, 254896},
	{"TAJIKISTAN", 10, 37750},
	{"TAJIK", 5, 91050},
	{"TAIZHOU", 7, 157290},
	{"TAIZE", 5, 241783},
	{"TAIYUAN", 7, 180551},
	{"TAIYO", 5, 96688},
	{"TAIWANESE", 9, 56330},
	{"TAIWAN", 6, 5653},
	{"TAITTINGER", 10, 260008},
	{"TAISHO", 6, 175094},
	{"TAISEN", 6, 184794},
	{"TAIRA", 5, 194878},
	{"TAIPING", 7, 193752},
	{"TAIPEITIMES", 11, 158185},
	{"TAIPEI", 6, 41483},
	{"TAIPANS", 7, 258718},
	{"TAIPAN", 6, 218009},
	{"TAIPA", 5, 260205},
	{"TAINTY", 6, 209856},
	{"TAINTS", 6, 204937},
	{"TAINTING", 8, 198281},
	{"TAINTED", 7, 61286},
	{"TAINMENT", 8, 174025},
	{"TAINLY", 6, 236624},
	{"TAINING", 7, 122077},
	{"TAINER", 6, 222519},
	{"TAINED", 6, 91401},
	{"TAINAN", 6, 129235},
	{"TAINABLE", 8, 236908},
	{"TAILWIND", 8, 173410},
	{"TAILWATER", 9, 203381},
	{"TAILSTOCK", 9, 253233},
	{"TAILSPIN", 8, 179838},
	{"TAILS", 5, 46310},
	{"TAILRANK", 8, 147378},
	{"TAILRACE", 8, 242234},
	{"TAILPIPES", 9, 250549},
	{"TAILPIPE", 8, 135311},
	{"TAILPIECE", 9, 147496},
	{"TAILORS", 7, 78504},
	{"TAILORMADE", 10, 208448},
	{"TAILORING", 9, 62951},
	{"TAILORED", 8, 37658},
	{"TAILOR", 6, 41951},
	{"TAILLIGHTS", 10, 93266},
	{"TAILLIGHT", 9, 107834},
	{"TAILLESS", 8, 252816},
	{"TAILLE", 6, 110838},
	{"TAILINGS", 8, 86492},
	{"TAILING", 7, 122860},
	{"TAILGATING", 10, 95170},
	{"TAILGATES", 9, 191274},
	{"TAILGATER", 9, 134634},
	{"TAILGATE", 8, 59237},
	{"TAILERS", 7, 146755},
	{"TAILER", 6, 157355},
	{"TAILED", 6, 49353},
	{"TAILBONE", 8, 207818},
	{"TAILBACK", 8, 145935},
	{"TAIL", 4, 9587},
	{"TAIKO", 5, 129389},
	{"TAIJIQUAN", 9, 170672},
	{"TAIJI", 5, 136922},
	{"TAIGA", 5, 115080},
	{"TAIEX", 5, 234060},
	{"TAICHUNG", 8, 103780},
	{"TAICHI", 6, 79312},
	{"TAHUN", 5, 154861},
	{"TAHSIS", 6, 212140},
	{"TAHRIR", 6, 170403},
	{"TAHOMA", 6, 81195},
	{"TAHOKA", 6, 235335},
	{"TAHOE", 5, 35803},
	{"TAHLIANA", 8, 200297},
	{"TAHLEQUAH", 9, 118716},
	{"TAHITIAN", 8, 74927},
	{"TAHITI", 6, 50942},
	{"TAHIR", 5, 120663},
	{"TAHINI", 6, 175689},
	{"TAHERI", 6, 237054},
	{"TAHER", 5, 212165},
	{"TAHARI", 6, 129441},
	{"TAHARA", 6, 227904},
	{"TAGZANIA", 8, 190660},
	{"TAGY", 4, 214606},
	{"TAGW", 4, 121494},
	{"TAGUS", 5, 221100},
	{"TAGUNGSDICKE", 12, 114421},
	{"TAGUNG", 6, 220879},
	{"TAGUCHI", 7, 131576},
	{"TAGUBA", 6, 234199},
	{"TAGU", 4, 58931},
	{"TAGSET", 6, 193822},
	{"TAGS", 4, 3359},
	{"TAGR", 4, 35537},
	{"TAGP", 4, 162536},
	{"TAGOUT", 6, 145993},
	{"TAGORE", 6, 110333},
	{"TAGOH", 5, 180532},
	{"TAGNET", 6, 183524},
	{"TAGNAME", 7, 129538},
	{"TAGMARKMAN", 10, 251913},
	{"TAGM", 4, 133641},
	{"TAGLINES", 8, 77369},
	{"TAGLINE", 7, 84583},
	{"TAGLIBS", 7, 142643},
	{"TAGLIB", 6, 131334},
	{"TAGLIATELLE", 11, 248057},
	{"TAGLIAFERRI", 11, 253359},
	{"TAGLIABUE", 9, 193115},
	{"TAGLIA", 6, 237134},
	{"TAGLESS", 7, 176190},
	{"TAGLE", 5, 229967},
	{"TAGL", 4, 63819},
	{"TAGISH", 6, 173201},
	{"TAGINE", 6, 232495},
	{"TAGGING", 7, 45770},
	{"TAGGERS", 7, 212668},
	{"TAGGER", 6, 112125},
	{"TAGGED", 6, 28063},
	{"TAGGART", 7, 99440},
	{"TAGG", 4, 179015},
	{"TAGFACTS", 8, 227175},
	{"TAGF", 4, 121629},
	{"TAGESZUGANG", 11, 193985},
	{"TAGESPASSWORT", 13, 129783},
	{"TAGESGALERIE", 12, 212754},
	{"TAGES", 5, 115654},
	{"TAGER", 5, 261427},
	{"TAGEN", 5, 144006},
	{"TAGEBUCH", 8, 205168},
	{"TAGD", 4, 158720},
	{"TAGCRAWLER", 10, 163378},
	{"TAGCLOUD", 8, 165385},
	{"TAGC", 4, 163243},
	{"TAGBOX", 6, 147455},
	{"TAGBOARD", 8, 110835},
	{"TAGB", 4, 128175},
	{"TAGAYTAY", 8, 200697},
	{"TAGAWA", 6, 248296},
	{"TAGASI", 6, 257258},
	{"TAGAR", 5, 215771},
	{"TAGAN", 5, 167285},
	{"TAGAMET", 7, 157077},
	{"TAGALOG", 7, 58444},
	{"TAFU", 4, 58647},
	{"TAFSIR", 6, 231510},
	{"TAFR", 4, 37811},
	{"TAFOYA", 6, 113194},
	{"TAFG", 4, 105938},
	{"TAFFY", 5, 86975},
	{"TAFFETA", 7, 100152},
	{"TAFF", 4, 98029},
	{"TAFEL", 5, 123977},
	{"TAFC", 4, 215465},
	{"TAFB", 4, 167970},
	{"TAENIA", 6, 234646},
	{"TAEKWONDO", 9, 77396},
	{"TAEKWON", 7, 171519},
	{"TAEJON", 6, 213945},
	{"TAEGU", 5, 218026},
	{"TAEGAN", 6, 180754},
	{"TADY", 4, 133988},
	{"TADWORTH", 8, 222590},
	{"TADW", 4, 145210},
	{"TADV", 4, 39122},
	{"TADU", 4, 67634},
	{"TADSCH", 6, 256450},
	{"TADREAM", 7, 245279},
	{"TADR", 4, 58924},
	{"TADPOLES", 8, 124246},
	{"TADPOLE", 7, 91663},
	{"TADP", 4, 142700},
	{"TADM", 4, 46699},
	{"TADLEY", 6, 217455},
	{"TADL", 4, 126612},
	{"TADJIKISTAN", 11, 112396},
	{"TADJ", 4, 74822},
	{"TADIRAN", 7, 241521},
	{"TADIC", 5, 189314},
	{"TADF", 4, 196459},
	{"TADEUSZ", 7, 148523},
	{"TADEMA", 6, 198796},
	{"TADD", 4, 217893},
	{"TADCASTER", 9, 178395},
	{"TADC", 4, 161290},
	{"TADB", 4, 173064},
	{"TADASHI", 7, 142620},
	{"TADAO", 5, 182559},
	{"TADALAFIL", 9, 62120},
	{"TACY", 4, 255117},
	{"TACX", 4, 139724},
	{"TACUBA", 6, 169150},
	{"TACU", 4, 44365},
	{"TACTS", 5, 261669},
	{"TACTILE", 7, 65173},
	{"TACTICS", 7, 33893},
	{"TACTICK", 7, 229122},
	{"TACTICIAN", 9, 179388},
	{"TACTICALLY", 10, 140199},
	{"TACTICAL", 8, 37077},
	{"TACTIC", 6, 28972},
	{"TACTFULLY", 9, 172021},
	{"TACTFUL", 7, 150068},
	{"TACTEL", 6, 230413},
	{"TACROLIMUS", 10, 131211},
	{"TACRINE", 7, 259028},
	{"TACR", 4, 38652},
	{"TACQ", 4, 71110},
	{"TACOS", 5, 79788},
	{"TACONITE", 8, 210809},
	{"TACONIC", 7, 150367},
	{"TACOMA", 6, 39899},
	{"TACOM", 5, 154602},
	{"TACNA", 5, 259783},
	{"TACM", 4, 204662},
	{"TACL", 4, 36950},
	{"TACKY", 5, 79356},
	{"TACKTICK", 8, 176313},
	{"TACKS", 5, 93911},
	{"TACKLING", 8, 51400},
	{"TACKLES", 7, 51629},
	{"TACKLER", 7, 227274},
	{"TACKLED", 7, 65970},
	{"TACKLE", 6, 32192},
	{"TACKING", 7, 130808},
	{"TACKETT", 7, 151141},
	{"TACKER", 6, 211337},
	{"TACKED", 6, 101804},
	{"TACK", 4, 44745},
	{"TACITUS", 7, 86436},
	{"TACITURN", 8, 180131},
	{"TACITLY", 7, 126870},
	{"TACIT", 5, 75253},
	{"TACIS", 5, 159149},
	{"TACHYON", 7, 120873},
	{"TACHYCARDIA", 11, 84732},
	{"TACHWEDD", 8, 202854},
	{"TACHOMETERS", 11, 179933},
	{"TACHOMETER", 10, 86077},
	{"TACHO", 5, 126994},
	{"TACHIKAWA", 9, 210623},
	{"TACHIKARA", 9, 226566},
	{"TACHIBANA", 9, 169962},
	{"TACHI", 5, 194259},
	{"TACHE", 5, 217456},
	{"TACF", 4, 243324},
	{"TACCHINI", 8, 119977},
	{"TACC", 4, 182238},
	{"TACACS", 6, 88434},
	{"TABY", 4, 194647},
	{"TABW", 4, 135102},
	{"TABUTHEMA", 9, 221217},
	{"TABUS", 5, 191764},
	{"TABULOSE", 8, 195877},
	{"TABULOS", 7, 127142},
	{"TABULATOR", 9, 235874},
	{"TABULATIONS", 11, 106431},
	{"TABULATION", 10, 72079},
	{"TABULATING", 10, 164206},
	{"TABULATES", 9, 225710},
	{"TABULATED", 9, 78356},
	{"TABULATE", 8, 133081},
	{"TABULAS", 7, 202510},
	{"TABULARIUM", 10, 259127},
	{"TABULAR", 7, 61530},
	{"TABULA", 6, 95515},
	{"TABU", 4, 89131},
	{"TABSTRIP", 8, 254983},
	{"TABSTOP", 7, 164132},
	{"TABS", 4, 8141},
	{"TABRIZ", 6, 114080},
	{"TABR", 4, 47449},
	{"TABP", 4, 254929},
	{"TABORT", 6, 199466},
	{"TABORI", 6, 231291},
	{"TABOR", 5, 66026},
	{"TABOOS", 6, 102047},
	{"TABOO", 5, 42221},
	{"TABM", 4, 232372},
	{"TABLOIDS", 8, 107027},
	{"TABLOID", 7, 63517},
	{"TABLISHED", 9, 224794},
	{"TABLING", 7, 106942},
	{"TABLEWIDTH", 10, 224828},
	{"TABLEWARE", 9, 49009},
	{"TABLETS", 7, 31721},
	{"TABLETPC", 8, 165848},
	{"TABLETOPS", 9, 158747},
	{"TABLETOP", 8, 49930},
	{"TABLET", 6, 28216},
	{"TABLESPOONS", 11, 50087},
	{"TABLESPOONFULS", 14, 259243},
	{"TABLESPOONFUL", 13, 249836},
	{"TABLESPOON", 10, 6843},
	{"TABLESPACES", 11, 187305},
	{"TABLESPACE", 10, 105965},
	{"TABLESIDE", 9, 257471},
	{"TABLES", 6, 3491},
	{"TABLEPLUGIN", 11, 126706},
	{"TABLENAME", 9, 129534},
	{"TABLEMOUNTING", 13, 175594},
	{"TABLELESS", 9, 178484},
	{"TABLELANDS", 10, 118109},
	{"TABLELAND", 9, 218544},
	{"TABLEDANCE", 10, 189438},
	{"TABLED", 6, 59291},
	{"TABLECOVER", 10, 204208},
	{"TABLECOL", 8, 232276},
	{"TABLECLOTHS", 11, 94401},
	{"TABLECLOTH", 10, 77051},
	{"TABLEBREAK", 10, 232557},
	{"TABLEBRCOL", 10, 232813},
	{"TABLEBGCOLOR", 12, 232703},
	{"TABLEAUX", 8, 110235},
	{"TABLEAU", 7, 80245},
	{"TABLE", 5, 1769},
	{"TABLATURES", 10, 90310},
	{"TABLATURE", 9, 60047},
	{"TABLAS", 6, 132299},
	{"TABLA", 5, 86195},
	{"TABL", 4, 124842},
	{"TABKE", 5, 241447},
	{"TABITHA", 7, 71653},
	{"TABINDEX", 8, 162972},
	{"TABID", 5, 178005},
	{"TABFIND", 7, 238824},
	{"TABF", 4, 174147},
	{"TABERNACLES", 11, 156382},
	{"TABERNACLE", 10, 65686},
	{"TABER", 5, 93631},
	{"TABELLEN", 8, 206004},
	{"TABELLE", 7, 113051},
	{"TABELLA", 7, 137128},
	{"TABELA", 6, 177639},
	{"TABEL", 5, 182034},
	{"TABCORP", 7, 258042},
	{"TABC", 4, 227573},
	{"TABBY", 5, 80258},
	{"TABBORD", 7, 232572},
	{"TABBING", 7, 151490},
	{"TABBER", 6, 177545},
	{"TABBED", 6, 69822},
	{"TABB", 4, 151146},
	{"TABATHA", 7, 144457},
	{"TABATA", 6, 206509},
	{"TABASCO", 7, 88786},
	{"TABARROK", 8, 215178},
	{"TABARI", 6, 228170},
	{"TABARD", 6, 173314},
	{"TABAK", 5, 143294},
	{"TABACO", 6, 120524},
	{"TABACCO", 7, 180309},
	{"TABAC", 5, 101870},
	{"TAAFFE", 6, 238912},
	{"T-SHIRT", 7, 29677},
	{"T", 1, 1},
	{"SZYN", 4, 182067},
	{"SZYMON", 6, 245389},
	{"SZYMANSKI", 9, 147003},
	{"SZYMANOWSKI", 11, 253718},
	{"SZYM", 4, 205921},
	{"SZY", 3, 31129},
	{"SZWARC", 6, 254568},
	{"SZWA", 4, 237686},
	{"SZUM", 4, 231838},
	{"SZUL", 4, 169524},
	{"SZUKAJ", 6, 136437},
	{"SZUK", 4, 257784},
	{"SZUC", 4, 250473},
	{"SZUB", 4, 259658},
	{"SZTAKI", 6, 169011},
	{"SZOR", 4, 173342},
	{"SZOM", 4, 154123},
	{"SZOL", 4, 232373},
	{"SZO", 3, 3189},
	{"SZMOCY", 6, 258438},
	{"SZMIDT", 6, 181299},
	{"SZLO", 4, 163586},
	{"SZLA", 4, 198215},
	{"SZKO", 4, 133383},
	{"SZKA", 4, 224639},
	{"SZK", 3, 10080},
	{"SZIP", 4, 144641},
	{"SZIM", 4, 139309},
	{"SZILVIA", 7, 227632},
	{"SZILARD", 7, 240369},
	{"SZIL", 4, 215659},
	{"SZIG", 4, 182396},
	{"SZHU", 4, 242451},
	{"SZEW", 4, 135520},
	{"SZEU", 4, 260859},
	{"SZER", 4, 77206},
	{"SZENTENDRE", 10, 231970},
	{"SZENT", 5, 220526},
	{"SZENE", 5, 192685},
	{"SZELL", 5, 256304},
	{"SZEL", 4, 154310},
	{"SZEKELY", 7, 235369},
	{"SZEK", 4, 152394},
	{"SZEGED", 6, 135662},
	{"SZEG", 4, 222863},
	{"SZECHWAN", 8, 214975},
	{"SZECHUAN", 8, 125551},
	{"SZEC", 4, 229233},
	{"SZEB", 4, 234579},
	{"SZCZERBIAK", 10, 169511},
	{"SZCZECIN", 8, 126098},
	{"SZCZAWNICA", 10, 204938},
	{"SZCZ", 4, 109491},
	{"SZC", 3, 28840},
	{"SZAW", 4, 220373},
	{"SZASZ", 5, 179911},
	{"SZAR", 4, 132389},
	{"SZAP", 4, 164083},
	{"SZANALMAS", 9, 210215},
	{"SZAM", 4, 136086},
	{"SZALAY", 6, 239405},
	{"SZAL", 4, 179453},
	{"SZAK", 4, 151835},
	{"SZAG", 4, 168369},
	{"SZAC", 4, 107241},
	{"SZABOLCS", 8, 238200},
	{"SZABO", 5, 94608},
	{"SZAB", 4, 155101},
	{"SYZYGY", 6, 201822},
	{"SYYO", 4, 210886},
	{"SYYE", 4, 196776},
	{"SYXI", 4, 183376},
	{"SYWR", 4, 210109},
	{"SYWO", 4, 99794},
	{"SYWI", 4, 72218},
	{"SYWH", 4, 84985},
	{"SYWE", 4, 124818},
	{"SYWARE", 6, 238726},
	{"SYWA", 4, 71996},
	{"SYVUM", 5, 204939},
	{"SYVO", 4, 219056},
	{"SYVI", 4, 113921},
	{"SYVERSON", 8, 233450},
	{"SYVE", 4, 179665},
	{"SYVA", 4, 237354},
	{"SYV", 3, 8270},
	{"SYUS", 4, 171480},
	{"SYUR", 4, 186906},
	{"SYUP", 4, 251156},
	{"SYUN", 4, 138174},
	{"SYUM", 4, 201069},
	{"SYUK", 4, 124531},
	{"SYUG", 4, 188563},
	{"SYUA", 4, 194352},
	{"SYU", 3, 4115},
	{"SYTY", 4, 247252},
	{"SYTU", 4, 182397},
	{"SYTR", 4, 108023},
	{"SYTEMS", 6, 157285},
	{"SYTEM", 5, 124506},
	{"SYSW", 4, 183493},
	{"SYSVINIT", 8, 132532},
	{"SYSV", 4, 96934},
	{"SYSUTILS", 8, 100372},
	{"SYSU", 4, 103544},
	{"SYSTRAY", 7, 153957},
	{"SYSTRAQ", 7, 195653},
	{"SYSTRAN", 7, 116067},
	{"SYSTOLIC", 8, 75243},
	{"SYSTOLE", 7, 211110},
	{"SYSTM", 5, 205621},
	{"SYSTINET", 8, 160309},
	{"SYSTIMAX", 8, 250351},
	{"SYSTEMY", 7, 194292},
	{"SYSTEMWORKS", 11, 87957},
	{"SYSTEMWIDE", 10, 110992},
	{"SYSTEMVERILOG", 13, 222300},
	{"SYSTEMS", 7, 1025},
	{"SYSTEMROOT", 10, 102518},
	{"SYSTEMIMAGER", 12, 144602},
	{"SYSTEMID", 8, 179612},
	{"SYSTEMICALLY", 12, 145002},
	{"SYSTEMIC", 8, 40783},
	{"SYSTEMHOME", 10, 231681},
	{"SYSTEMES", 8, 138283},
	{"SYSTEMEN", 8, 168142},
	{"SYSTEME", 7, 93741},
	{"SYSTEMC", 7, 150750},
	{"SYSTEMBAU", 9, 254118},
	{"SYSTEMAX", 8, 63744},
	{"SYSTEMATIZED", 12, 209002},
	{"SYSTEMATIZE", 11, 243184},
	{"SYSTEMATICS", 11, 74700},
	{"SYSTEMATICALLY", 14, 48166},
	{"SYSTEMATIC", 10, 33356},
	{"SYSTEMA", 7, 165301},
	{"SYSTEM", 6, 1039},
	{"SYSTEEM", 7, 175784},
	{"SYSTECH", 7, 249532},
	{"SYSTE", 5, 111267},
	{"SYSTAT", 6, 174016},
	{"SYSSTAT", 7, 191399},
	{"SYSSRC", 6, 128771},
	{"SYSRQ", 5, 229384},
	{"SYSROUTED", 9, 130464},
	{"SYSPRO", 6, 146917},
	{"SYSPLEX", 7, 203363},
	{"SYSP", 4, 123397},
	{"SYSOPT", 6, 136262},
	{"SYSOPS", 6, 179726},
	{"SYSOP", 5, 78933},
	{"SYSONCHIP", 9, 239400},
	{"SYSNAME", 7, 226156},
	{"SYSMETRIX", 9, 219621},
	{"SYSM", 4, 191924},
	{"SYSLOGD", 7, 125802},
	{"SYSLOG", 6, 55340},
	{"SYSLINUX", 8, 131888},
	{"SYSL", 4, 197909},
	{"SYSKONNECT", 10, 218521},
	{"SYSKLOGD", 8, 167594},
	{"SYSINTERNALS", 12, 158267},
	{"SYSINSTALL", 10, 191541},
	{"SYSINST", 7, 237472},
	{"SYSINFO", 7, 171384},
	{"SYSFS", 5, 121804},
	{"SYSDIR", 6, 253784},
	{"SYSDEPS", 7, 118811},
	{"SYSDATE", 7, 201722},
	{"SYSCTL", 6, 119125},
	{"SYSCONFIG", 9, 121149},
	{"SYSCONFDIR", 10, 144725},
	{"SYSCONF", 7, 203892},
	{"SYSCO", 5, 139623},
	{"SYSCALLS", 8, 193240},
	{"SYSCALL", 7, 111901},
	{"SYSCA", 5, 199932},
	{"SYSADMINS", 9, 164940},
	{"SYSADMIN", 8, 70111},
	{"SYSADM", 6, 160066},
	{"SYRUS", 5, 224259},
	{"SYRUPY", 6, 167479},
	{"SYRUPS", 6, 87619},
	{"SYRUP", 5, 42112},
	{"SYRU", 4, 75792},
	{"SYRT", 4, 247880},
	{"SYRS", 4, 238770},
	{"SYROS", 5, 145256},
	{"SYRINX", 6, 213292},
	{"SYRINGOMYELIA", 13, 244426},
	{"SYRINGES", 8, 69736},
	{"SYRINGE", 7, 59962},
	{"SYRINGAE", 8, 142910},
	{"SYRINGA", 7, 204905},
	{"SYRIANS", 7, 107990},
	{"SYRIANOZ", 8, 235386},
	{"SYRIANA", 7, 73729},
	{"SYRIAN", 6, 41908},
	{"SYRIAC", 6, 104759},
	{"SYRIA", 5, 30953},
	{"SYRI", 4, 44556},
	{"SYREN", 5, 208633},
	{"SYRE", 4, 77914},
	{"SYRAH", 5, 81830},
	{"SYRACUSE", 8, 36348},
	{"SYQUEST", 7, 215637},
	{"SYQU", 4, 195697},
	{"SYPU", 4, 192784},
	{"SYPR", 4, 106057},
	{"SYPO", 4, 134730},
	{"SYPL", 4, 125430},
	{"SYPI", 4, 136727},
	{"SYPHON", 6, 124102},
	{"SYPHILITIC", 10, 260283},
	{"SYPHILIS", 8, 66998},
	{"SYPHER", 6, 257314},
	{"SYPH", 4, 101310},
	{"SYPE", 4, 132105},
	{"SYPA", 4, 104737},
	{"SYOV", 4, 99950},
	{"SYOU", 4, 3287},
	{"SYOSSET", 7, 124860},
	{"SYORIES", 7, 234363},
	{"SYOR", 4, 89630},
	{"SYOP", 4, 178856},
	{"SYOL", 4, 253898},
	{"SYOK", 4, 220374},
	{"SYOF", 4, 63198},
	{"SYNXIS", 6, 156583},
	{"SYNUCLEIN", 9, 170974},
	{"SYNTRAX", 7, 118277},
	{"SYNTHS", 6, 75112},
	{"SYNTHROID", 9, 99076},
	{"SYNTHPOP", 8, 152850},
	{"SYNTHETICS", 10, 111836},
	{"SYNTHETICALLY", 13, 183446},
	{"SYNTHETIC", 9, 32066},
	{"SYNTHETASES", 11, 194604},
	{"SYNTHETASE", 10, 66475},
	{"SYNTHESIZING", 12, 96263},
	{"SYNTHESIZES", 11, 147969},
	{"SYNTHESIZERS", 12, 80594},
	{"SYNTHESIZER", 11, 56417},
	{"SYNTHESIZED", 11, 57481},
	{"SYNTHESIZE", 10, 73907},
	{"SYNTHESISING", 12, 261451},
	{"SYNTHESISERS", 12, 251638},
	{"SYNTHESISER", 11, 188359},
	{"SYNTHESISED", 11, 143479},
	{"SYNTHESISE", 10, 170697},
	{"SYNTHESIS", 9, 29432},
	{"SYNTHESES", 9, 115819},
	{"SYNTHESE", 8, 207977},
	{"SYNTHELABO", 10, 228688},
	{"SYNTHE", 6, 240095},
	{"SYNTHASES", 9, 195907},
	{"SYNTHASE", 8, 49855},
	{"SYNTH", 5, 51147},
	{"SYNTENY", 7, 213558},
	{"SYNTAXIN", 8, 187697},
	{"SYNTAXES", 8, 148127},
	{"SYNTAX", 6, 7295},
	{"SYNTAGMA", 8, 230068},
	{"SYNTACTICALLY", 13, 114305},
	{"SYNTACTICAL", 11, 140503},
	{"SYNTACTIC", 9, 57400},
	{"SYNTACE", 7, 220079},
	{"SYNPLICITY", 10, 224792},
	{"SYNOVUS", 7, 238626},
	{"SYNOVIUM", 8, 250542},
	{"SYNOVITIS", 9, 205104},
	{"SYNOVIAL", 8, 97901},
	{"SYNOPTICS", 9, 204376},
	{"SYNOPTIC", 8, 82013},
	{"SYNOPSYS", 8, 103992},
	{"SYNOPSIS", 8, 29932},
	{"SYNOPSES", 8, 75312},
	{"SYNOO", 5, 172477},
	{"SYNONYMY", 8, 133455},
	{"SYNONYMS", 8, 46324},
	{"SYNONYMOUSLY", 12, 223911},
	{"SYNONYMOUS", 10, 58948},
	{"SYNONYM", 7, 51208},
	{"SYNON", 5, 206251},
	{"SYNOMONE", 8, 196104},
	{"SYNOLOGY", 8, 179282},
	{"SYNODS", 6, 174537},
	{"SYNODICAL", 9, 235955},
	{"SYNODAL", 7, 237132},
	{"SYNOD", 5, 59785},
	{"SYNNOVE", 7, 192019},
	{"SYNNEX", 6, 257325},
	{"SYNISTER", 8, 207155},
	{"SYNGRESS", 8, 160205},
	{"SYNGENTA", 8, 105349},
	{"SYNGENEIC", 9, 223127},
	{"SYNGE", 5, 193042},
	{"SYNGAS", 6, 207538},
	{"SYNG", 4, 191779},
	{"SYNESTHESIA", 11, 208642},
	{"SYNERTECH", 9, 252891},
	{"SYNERGY", 7, 44219},
	{"SYNERGISTICALLY", 15, 137083},
	{"SYNERGISTIC", 11, 75195},
	{"SYNERGISM", 9, 138012},
	{"SYNERGIES", 9, 74569},
	{"SYNERGIE", 8, 230723},
	{"SYNERGETICS", 11, 250772},
	{"SYNERGETIC", 10, 185061},
	{"SYNERGASIA", 10, 248771},
	{"SYNEPHRINE", 10, 221011},
	{"SYNECHOCYSTIS", 13, 149445},
	{"SYNECHOCOCCUS", 13, 159167},
	{"SYNDROMIC", 9, 194243},
	{"SYNDROMES", 9, 63414},
	{"SYNDROME", 8, 33107},
	{"SYNDROM", 7, 167803},
	{"SYNDR", 5, 232185},
	{"SYNDICATOR", 10, 152983},
	{"SYNDICATIONS", 12, 149613},
	{"SYNDICATION", 11, 28827},
	{"SYNDICATING", 11, 156936},
	{"SYNDICATES", 10, 100158},
	{"SYNDICATED", 10, 49743},
	{"SYNDICATE", 9, 29305},
	{"SYNDICAT", 8, 165810},
	{"SYNDICALIST", 11, 230172},
	{"SYNDICALISM", 11, 209386},
	{"SYNDIC", 6, 153170},
	{"SYNDEL", 6, 197532},
	{"SYND", 4, 186885},
	{"SYNCYTIAL", 9, 132486},
	{"SYNCTEST", 8, 246773},
	{"SYNCS", 5, 143059},
	{"SYNCRUDE", 8, 227534},
	{"SYNCROS", 7, 193449},
	{"SYNCRO", 6, 109216},
	{"SYNCRETISM", 10, 201136},
	{"SYNCOPE", 7, 119661},
	{"SYNCOPATION", 11, 196338},
	{"SYNCOPATED", 10, 162170},
	{"SYNCML", 6, 133464},
	{"SYNCMASTER", 10, 67293},
	{"SYNCING", 7, 95072},
	{"SYNCHROTRON", 11, 72268},
	{"SYNCHRONY", 9, 120170},
	{"SYNCHRONOUSLY", 13, 129191},
	{"SYNCHRONOUS", 11, 48966},
	{"SYNCHRONIZING", 13, 82372},
	{"SYNCHRONIZES", 12, 113685},
	{"SYNCHRONIZER", 12, 109170},
	{"SYNCHRONIZED", 12, 51941},
	{"SYNCHRONIZE", 11, 55625},
	{"SYNCHRONIZATION", 15, 40333},
	{"SYNCHRONISM", 11, 220415},
	{"SYNCHRONISING", 13, 209825},
	{"SYNCHRONISED", 12, 117071},
	{"SYNCHRONISE", 11, 129491},
	{"SYNCHRONISATION", 15, 82668},
	{"SYNCHRONICITY", 13, 102603},
	{"SYNCHRONIC", 10, 195143},
	{"SYNCHRON", 8, 193581},
	{"SYNCHRO", 7, 85704},
	{"SYNCHING", 8, 148238},
	{"SYNCHILLA", 9, 230138},
	{"SYNCHED", 7, 189867},
	{"SYNCH", 5, 74778},
	{"SYNCED", 6, 141314},
	{"SYNCE", 5, 161544},
	{"SYNC", 4, 32883},
	{"SYNAPTOTAGMIN", 13, 252423},
	{"SYNAPTOSOMES", 12, 209549},
	{"SYNAPTICS", 9, 140156},
	{"SYNAPTIC", 8, 58990},
	{"SYNAPSES", 8, 84103},
	{"SYNAPSE", 7, 74409},
	{"SYNANTHSH", 9, 142811},
	{"SYNALAR", 7, 129616},
	{"SYNAGOGUES", 10, 76663},
	{"SYNAGOGUE", 9, 56270},
	{"SYNAESTHESIA", 12, 183469},
	{"SYMUD", 5, 229217},
	{"SYMU", 4, 223302},
	{"SYMTOMS", 7, 157117},
	{"SYMTAB", 6, 229426},
	{"SYMS", 4, 140677},
	{"SYMPTONS", 8, 159916},
	{"SYMPTOMS", 8, 5925},
	{"SYMPTOMATOLOGY", 14, 145729},
	{"SYMPTOMATIC", 11, 65436},
	{"SYMPTOM", 7, 6810},
	{"SYMPOSIUMS", 10, 128496},
	{"SYMPOSIUM", 9, 28747},
	{"SYMPOSIA", 8, 63698},
	{"SYMPORTER", 9, 232932},
	{"SYMPO", 5, 249958},
	{"SYMPLECTIC", 10, 100833},
	{"SYMPHYSODON", 11, 206166},
	{"SYMPHONY", 8, 32541},
	{"SYMPHONIES", 10, 67163},
	{"SYMPHONIE", 9, 129782},
	{"SYMPHONIC", 9, 62963},
	{"SYMPHONIA", 9, 129625},
	{"SYMPATRIC", 9, 199995},
	{"SYMPATICO", 9, 105054},
	{"SYMPATHY", 8, 33333},
	{"SYMPATHOMIMETIC", 15, 194641},
	{"SYMPATHIZING", 12, 227430},
	{"SYMPATHIZERS", 12, 126460},
	{"SYMPATHIZER", 11, 204386},
	{"SYMPATHIZED", 11, 186265},
	{"SYMPATHIZE", 10, 97499},
	{"SYMPATHISERS", 12, 224610},
	{"SYMPATHISE", 10, 150947},
	{"SYMPATHIES", 10, 88907},
	{"SYMPATHETICALLY", 15, 126561},
	{"SYMPATHETIC", 11, 47442},
	{"SYMPATHECTOMY", 13, 250420},
	{"SYMPA", 5, 82574},
	{"SYMP", 4, 71778},
	{"SYMONS", 6, 101017},
	{"SYMONE", 6, 140092},
	{"SYMONDS", 7, 98554},
	{"SYMON", 5, 159464},
	{"SYMO", 4, 81534},
	{"SYMMETRY", 8, 41116},
	{"SYMMETRIX", 9, 175586},
	{"SYMMETRIES", 10, 84688},
	{"SYMMETRICOM", 11, 232210},
	{"SYMMETRICALLY", 13, 124796},
	{"SYMMETRICAL", 11, 65709},
	{"SYMMETRIC", 9, 43801},
	{"SYMMETRA", 8, 206976},
	{"SYMMES", 6, 222100},
	{"SYMM", 4, 240871},
	{"SYMLINKS", 8, 91524},
	{"SYMLINK", 7, 80486},
	{"SYMINGTON", 9, 168123},
	{"SYMI", 4, 196876},
	{"SYMFWNA", 7, 138793},
	{"SYMFONY", 7, 205014},
	{"SYMETRIX", 8, 222898},
	{"SYMES", 5, 168933},
	{"SYME", 4, 132567},
	{"SYMC", 4, 257726},
	{"SYMBOYLIOY", 10, 216578},
	{"SYMBOYLIO", 9, 206818},
	{"SYMBOLS", 7, 8830},
	{"SYMBOLPRINT", 11, 191531},
	{"SYMBOLOGY", 9, 119822},
	{"SYMBOLOGIES", 11, 198271},
	{"SYMBOLIZING", 11, 121667},
	{"SYMBOLIZES", 10, 84171},
	{"SYMBOLIZED", 10, 96078},
	{"SYMBOLIZE", 9, 88154},
	{"SYMBOLIST", 9, 225274},
	{"SYMBOLISM", 9, 58620},
	{"SYMBOLISING", 11, 229971},
	{"SYMBOLISES", 10, 164274},
	{"SYMBOLISED", 10, 195506},
	{"SYMBOLISE", 9, 174447},
	{"SYMBOLICS", 9, 244123},
	{"SYMBOLICALLY", 12, 95161},
	{"SYMBOLICAL", 10, 207442},
	{"SYMBOLIC", 8, 31981},
	{"SYMBOLE", 7, 183715},
	{"SYMBOL", 6, 7318},
	{"SYMBIOTICS", 10, 223805},
	{"SYMBIOTIC", 9, 90218},
	{"SYMBIOSIS", 9, 99011},
	{"SYMBIOS", 7, 168524},
	{"SYMBIONTS", 9, 236288},
	{"SYMBIONT", 8, 166027},
	{"SYMBIO", 6, 219668},
	{"SYMBIANOS", 9, 255903},
	{"SYMBIANONE", 10, 205451},
	{"SYMBIAN", 7, 40858},
	{"SYMB", 4, 142176},
	{"SYMANTEC", 8, 31702},
	{"SYMANT", 6, 235924},
	{"SYMA", 4, 81784},
	{"SYLWEDDOL", 9, 213525},
	{"SYLWADAU", 8, 133445},
	{"SYLW", 4, 143809},
	{"SYLVIE", 6, 86282},
	{"SYLVIAN", 7, 141662},
	{"SYLVIA", 6, 42571},
	{"SYLVESTRIS", 10, 160029},
	{"SYLVESTRE", 9, 135978},
	{"SYLVESTERTHEKAT", 15, 217775},
	{"SYLVESTER", 9, 55354},
	{"SYLVER", 6, 186857},
	{"SYLVATICA", 9, 185268},
	{"SYLVANUS", 8, 223944},
	{"SYLVANIAN", 9, 150662},
	{"SYLVANIA", 8, 56973},
	{"SYLVAN", 6, 62934},
	{"SYLVAIN", 7, 78858},
	{"SYLVA", 5, 130180},
	{"SYLV", 4, 34674},
	{"SYLUM", 5, 234553},
	{"SYLU", 4, 64717},
	{"SYLT", 4, 222409},
	{"SYLPHEED", 8, 102109},
	{"SYLPH", 5, 232745},
	{"SYLO", 4, 124788},
	{"SYLMAR", 6, 120441},
	{"SYLLOGISM", 9, 157022},
	{"SYLLABUSES", 10, 146299},
	{"SYLLABUS", 8, 38847},
	{"SYLLABLES", 9, 72350},
	{"SYLLABLE", 8, 60134},
	{"SYLLABICS", 9, 121453},
	{"SYLLABICATION", 13, 188677},
	{"SYLLABIC", 8, 167877},
	{"SYLLABI", 7, 72193},
	{"SYLLA", 5, 193882},
	{"SYLL", 4, 62856},
	{"SYLI", 4, 101437},
	{"SYLHET", 6, 176830},
	{"SYLH", 4, 251794},
	{"SYLFAENOL", 9, 216321},
	{"SYLACAUGA", 9, 188747},
	{"SYLA", 4, 84463},
	{"SYKORA", 6, 176698},
	{"SYKO", 4, 218174},
	{"SYKN", 4, 236086},
	{"SYKI", 4, 212210},
	{"SYKESVILLE", 10, 164348},
	{"SYKES", 5, 65644},
	{"SYKE", 4, 192162},
	{"SYJU", 4, 207207},
	{"SYJO", 4, 172064},
	{"SYJE", 4, 239867},
	{"SYJ", 3, 31744},
	{"SYIM", 4, 235494},
	{"SYIF", 4, 221230},
	{"SYID", 4, 226503},
	{"SYI", 3, 1738},
	{"SYH", 3, 4428},
	{"SYGU", 4, 220375},
	{"SYGR", 4, 164013},
	{"SYGO", 4, 104068},
	{"SYGI", 4, 207002},
	{"SYGE", 4, 174148},
	{"SYGATE", 6, 116112},
	{"SYGA", 4, 133356},
	{"SYFY", 4, 190072},
	{"SYFU", 4, 248170},
	{"SYFR", 4, 135732},
	{"SYFO", 4, 58688},
	{"SYFL", 4, 204663},
	{"SYFI", 4, 100001},
	{"SYFE", 4, 164739},
	{"SYFA", 4, 151037},
	{"SYEX", 4, 160488},
	{"SYEV", 4, 169184},
	{"SYER", 4, 183014},
	{"SYEM", 4, 195409},
	{"SYEL", 4, 70943},
	{"SYED", 4, 77926},
	{"SYEA", 4, 4229},
	{"SYDU", 4, 150545},
	{"SYDR", 4, 158721},
	{"SYDOW", 5, 171824},
	{"SYDO", 4, 130311},
	{"SYDNI", 5, 189066},
	{"SYDNEY", 6, 4737},
	{"SYDNEE", 6, 124337},
	{"SYDN", 4, 41221},
	{"SYDICATION", 10, 182916},
	{"SYDI", 4, 134851},
	{"SYDENHAM", 8, 104122},
	{"SYDD", 4, 83156},
	{"SYDA", 4, 128138},
	{"SYCU", 4, 226986},
	{"SYCR", 4, 136211},
	{"SYCOPHANTS", 10, 218607},
	{"SYCOPHANTIC", 11, 248946},
	{"SYCOPHANT", 9, 218612},
	{"SYCL", 4, 148679},
	{"SYCK", 4, 232153},
	{"SYCI", 4, 246942},
	{"SYCH", 4, 29608},
	{"SYCAMORES", 9, 133906},
	{"SYCAMORE", 8, 62358},
	{"SYCA", 4, 76375},
	{"SYBY", 4, 148169},
	{"SYBU", 4, 82898},
	{"SYBR", 4, 223480},
	{"SYBO", 4, 129598},
	{"SYBL", 4, 184727},
	{"SYBILLE", 7, 221359},
	{"SYBILLA", 7, 214546},
	{"SYBIL", 5, 93171},
	{"SYBIAN", 6, 106595},
	{"SYBI", 4, 125763},
	{"SYBEX", 5, 117259},
	{"SYBERIA", 7, 157119},
	{"SYBERCOM", 8, 188469},
	{"SYBE", 4, 91790},
	{"SYBASE", 6, 47504},
	{"SYBARI", 6, 231155},
	{"SYAW", 4, 174666},
	{"SYAU", 4, 226240},
	{"SYARIAH", 7, 243410},
	{"SYAR", 4, 43489},
	{"SYAP", 4, 162131},
	{"SYAK", 4, 181826},
	{"SYAG", 4, 181003},
	{"SYAF", 4, 158948},
	{"SYAD", 4, 143205},
	{"SYAC", 4, 85575},
	{"SYAB", 4, 115920},
	{"SXWI", 4, 221700},
	{"SXVI", 4, 131482},
	{"SXVE", 4, 207003},
	{"SXTR", 4, 214038},
	{"SXSW", 4, 87479},
	{"SXREENSAVERS", 12, 236699},
	{"SXRE", 4, 205197},
	{"SXRD", 4, 173765},
	{"SXRA", 4, 168460},
	{"SXPS", 4, 251157},
	{"SXPO", 4, 244810},
	{"SXPA", 4, 203119},
	{"SXOR", 4, 243623},
	{"SXME", 4, 180204},
	{"SXMA", 4, 243325},
	{"SXIV", 4, 115184},
	{"SXIENCE", 7, 235118},
	{"SXGA", 4, 84923},
	{"SXFO", 4, 249125},
	{"SXETIKA", 7, 250437},
	{"SXESEIS", 7, 255781},
	{"SXEMACS", 7, 197789},
	{"SXEDIO", 6, 255250},
	{"SXCO", 4, 180078},
	{"SXBO", 4, 159965},
	{"SXAV", 4, 126544},
	{"SWYO", 4, 214222},
	{"SWYN", 4, 196301},
	{"SWYDDOGION", 10, 250903},
	{"SWYDDOG", 7, 185277},
	{"SWYDDI", 6, 156485},
	{"SWYDDFA", 7, 156718},
	{"SWYDD", 5, 185398},
	{"SWYA", 4, 209497},
	{"SWWW", 4, 99913},
	{"SWWI", 4, 210299},
	{"SWWE", 4, 202579},
	{"SWWA", 4, 230291},
	{"SWUNG", 5, 65063},
	{"SWUN", 4, 80022},
	{"SWUM", 4, 200950},
	{"SWSUSP", 6, 148644},
	{"SWSOFT", 6, 142988},
	{"SWRO", 4, 39622},
	{"SWRI", 4, 190105},
	{"SWRE", 4, 67767},
	{"SWRCB", 5, 136399},
	{"SWRA", 4, 70930},
	{"SWPPP", 5, 165979},
	{"SWPP", 4, 209277},
	{"SWOW", 4, 159489},
	{"SWOV", 4, 175826},
	{"SWOU", 4, 4625},
	{"SWOSU", 5, 250189},
	{"SWORN", 5, 46014},
	{"SWORE", 5, 72067},
	{"SWORDSMEN", 9, 167439},
	{"SWORDSMANSHIP", 13, 210220},
	{"SWORDSMAN", 9, 98653},
	{"SWORDSEARCHER", 13, 224981},
	{"SWORDS", 6, 42621},
	{"SWORDPLAY", 9, 138567},
	{"SWORDFISH", 9, 81466},
	{"SWORD", 5, 31538},
	{"SWOR", 4, 2689},
	{"SWOPE", 5, 137539},
	{"SWOP", 4, 140155},
	{"SWOOSH", 6, 103856},
	{"SWOOPS", 6, 172899},
	{"SWOOPING", 8, 147900},
	{"SWOOPES", 7, 219830},
	{"SWOOPED", 7, 142973},
	{"SWOOP", 5, 82672},
	{"SWOONING", 8, 199787},
	{"SWOONED", 7, 243289},
	{"SWOON", 5, 106947},
	{"SWON", 4, 29488},
	{"SWOM", 4, 38484},
	{"SWOLLEN", 7, 54009},
	{"SWOL", 4, 61399},
	{"SWOK", 4, 163418},
	{"SWOFFORD", 8, 158784},
	{"SWOF", 4, 178182},
	{"SWOBODA", 7, 224179},
	{"SWOB", 4, 193784},
	{"SWNTS", 5, 241067},
	{"SWMP", 4, 241536},
	{"SWMLAC", 6, 253132},
	{"SWMA", 4, 241019},
	{"SWLA", 4, 229234},
	{"SWL", 3, 238},
	{"SWIZZLE", 7, 144623},
	{"SWIZZ", 5, 228334},
	{"SWIZERLAND", 10, 261547},
	{"SWIZ", 4, 148899},
	{"SWIX", 4, 137680},
	{"SWIVELS", 7, 103230},
	{"SWIVELLING", 10, 226094},
	{"SWIVELING", 9, 167044},
	{"SWIVEL", 6, 41617},
	{"SWIV", 4, 95036},
	{"SWITZERLAND", 11, 5434},
	{"SWITZER", 7, 102181},
	{"SWITZ", 5, 194333},
	{"SWITH", 5, 231281},
	{"SWITEL", 6, 217911},
	{"SWITCHYARD", 10, 257584},
	{"SWITCHVIEW", 10, 194381},
	{"SWITCHPORT", 10, 144744},
	{"SWITCHPLATES", 12, 155580},
	{"SWITCHPLATE", 11, 165094},
	{"SWITCHOVER", 10, 111546},
	{"SWITCHING", 9, 28783},
	{"SWITCHGRASS", 11, 215565},
	{"SWITCHGEAR", 10, 101485},
	{"SWITCHFOOT", 10, 43771},
	{"SWITCHES", 8, 9496},
	{"SWITCHERS", 9, 84964},
	{"SWITCHEROO", 10, 220443},
	{"SWITCHER", 8, 68329},
	{"SWITCHED", 8, 36225},
	{"SWITCHCRAFT", 11, 193828},
	{"SWITCHBOXES", 11, 125027},
	{"SWITCHBOX", 9, 179534},
	{"SWITCHBOARDS", 12, 170404},
	{"SWITCHBOARD", 11, 40141},
	{"SWITCHBLADES", 12, 250290},
	{"SWITCHBLADE", 11, 108365},
	{"SWITCHBD", 8, 196265},
	{"SWITCHBACKS", 11, 202814},
	{"SWITCHBACK", 10, 143909},
	{"SWITCHABLE", 10, 90117},
	{"SWITCH", 6, 8373},
	{"SWISSVOICE", 10, 238423},
	{"SWISSPROT", 9, 74287},
	{"SWISSOTEL", 9, 98532},
	{"SWISSMEMORY", 11, 225129},
	{"SWISSMAR", 8, 224742},
	{"SWISSLINE", 9, 175755},
	{"SWISSINFO", 9, 170488},
	{"SWISSCOM", 8, 105301},
	{"SWISSBIT", 8, 171338},
	{"SWISSAIR", 8, 168934},
	{"SWISS", 5, 5663},
	{"SWISHMAX", 8, 204308},
	{"SWISHING", 8, 231958},
	{"SWISHER", 7, 96262},
	{"SWISH", 5, 62952},
	{"SWIRLY", 6, 169959},
	{"SWIRLS", 6, 91964},
	{"SWIRLING", 8, 73885},
	{"SWIRLED", 7, 116107},
	{"SWIRL", 5, 56958},
	{"SWIRE", 5, 158006},
	{"SWIR", 4, 220928},
	{"SWIPL", 5, 188339},
	{"SWIPING", 7, 170799},
	{"SWIPES", 6, 168682},
	{"SWIPED", 6, 133979},
	{"SWIPE", 5, 79083},
	{"SWINTON", 7, 91378},
	{"SWINSTALL", 9, 237609},
	{"SWINSON", 7, 250252},
	{"SWINNEY", 7, 175959},
	{"SWINNERTON", 10, 172428},
	{"SWINK", 5, 200233},
	{"SWINGSET", 8, 218484},
	{"SWINGS", 6, 46597},
	{"SWINGMAN", 8, 126365},
	{"SWINGLINE", 9, 180911},
	{"SWINGLE", 7, 205418},
	{"SWINGING", 8, 40556},
	{"SWINGIN", 7, 90530},
	{"SWINGARM", 8, 147289},
	{"SWING", 5, 7443},
	{"SWINFORD", 8, 180721},
	{"SWINE", 5, 52436},
	{"SWINDON", 7, 48455},
	{"SWINDOLL", 8, 207586},
	{"SWINDLING", 9, 250224},
	{"SWINDLES", 8, 249839},
	{"SWINDLERS", 9, 198162},
	{"SWINDLER", 8, 194075},
	{"SWINDLED", 8, 219562},
	{"SWINDLE", 7, 105745},
	{"SWINDELLS", 9, 242112},
	{"SWINDELL", 8, 183635},
	{"SWINBURNE", 9, 91832},
	{"SWIMWEAR", 8, 40651},
	{"SWIMSUITS", 9, 69155},
	{"SWIMSUIT", 8, 46932},
	{"SWIMS", 5, 88706},
	{"SWIMMINGPOOL", 12, 159860},
	{"SWIMMINGLY", 10, 212475},
	{"SWIMMING", 8, 34040},
	{"SWIMMIN", 7, 242265},
	{"SWIMMERS", 8, 60131},
	{"SWIMMER", 7, 64786},
	{"SWIMING", 7, 193425},
	{"SWIMFAN", 7, 221759},
	{"SWIM", 4, 9103},
	{"SWILLING", 8, 184912},
	{"SWILL", 5, 164538},
	{"SWIKI", 5, 179697},
	{"SWIK", 4, 123899},
	{"SWIGER", 6, 237478},
	{"SWIG", 4, 89961},
	{"SWIFTY", 6, 193450},
	{"SWIFTWATER", 10, 224085},
	{"SWIFTS", 6, 128132},
	{"SWIFTNET", 8, 210410},
	{"SWIFTNESS", 9, 151075},
	{"SWIFTLY", 7, 56801},
	{"SWIFTER", 7, 176836},
	{"SWIFTECH", 8, 158236},
	{"SWIFT", 5, 34837},
	{"SWIFFER", 7, 190678},
	{"SWIF", 4, 8205},
	{"SWIDTH", 6, 112265},
	{"SWID", 4, 37289},
	{"SWICKI", 6, 175409},
	{"SWICK", 5, 211795},
	{"SWHY", 4, 31005},
	{"SWHO", 4, 2158},
	{"SWHI", 4, 2358},
	{"SWHE", 4, 2789},
	{"SWHACK", 6, 130480},
	{"SWHA", 4, 6542},
	{"SWFTEXTFIELD", 12, 193588},
	{"SWFTEXT", 7, 167504},
	{"SWFSPRITE", 9, 260376},
	{"SWFSHAPE", 8, 184289},
	{"SWFS", 4, 224540},
	{"SWFMOVIE", 8, 175697},
	{"SWFDISPLAYITEM", 14, 156514},
	{"SWFBUTTON", 9, 257525},
	{"SWEY", 4, 191780},
	{"SWEX", 4, 224878},
	{"SWEW", 4, 47516},
	{"SWEV", 4, 59890},
	{"SWEU", 4, 123804},
	{"SWETT", 5, 170229},
	{"SWETSWISE", 9, 169894},
	{"SWETS", 5, 173778},
	{"SWERVING", 8, 194781},
	{"SWERVEDRIVER", 12, 225919},
	{"SWERVED", 7, 159631},
	{"SWERVE", 6, 109142},
	{"SWEPT", 5, 44377},
	{"SWENSON", 7, 85200},
	{"SWENSEN", 7, 215598},
	{"SWELTERING", 10, 134282},
	{"SWELLS", 6, 91019},
	{"SWELLINGS", 9, 192122},
	{"SWELLING", 8, 44878},
	{"SWELLENDAM", 10, 193212},
	{"SWELLED", 7, 97785},
	{"SWELL", 5, 35549},
	{"SWEL", 4, 2625},
	{"SWEK", 4, 75550},
	{"SWEJ", 4, 141283},
	{"SWEITZER", 8, 251709},
	{"SWEG", 4, 63897},
	{"SWEF", 4, 83171},
	{"SWEEX", 5, 131391},
	{"SWEETY", 6, 98107},
	{"SWEETWATER", 10, 60260},
	{"SWEETSER", 8, 221128},
	{"SWEETS", 6, 42680},
	{"SWEETPOTATO", 11, 203912},
	{"SWEETPEA", 8, 204415},
	{"SWEETNEY", 8, 232513},
	{"SWEETNESS", 9, 60359},
	{"SWEETNAM", 8, 241576},
	{"SWEETMEATS", 10, 234645},
	{"SWEETMAN", 8, 167083},
	{"SWEETLY", 7, 86795},
	{"SWEETLEAF", 9, 259809},
	{"SWEETLAND", 9, 220663},
	{"SWEETING", 8, 180826},
	{"SWEETIES", 8, 90864},
	{"SWEETIE", 7, 57298},
	{"SWEETHEARTS", 11, 88855},
	{"SWEETHEART", 10, 50372},
	{"SWEETGRASS", 10, 176451},
	{"SWEETEST", 8, 63256},
	{"SWEETER", 7, 78255},
	{"SWEETENS", 8, 243690},
	{"SWEETENING", 10, 163000},
	{"SWEETENERS", 10, 84338},
	{"SWEETENER", 9, 94123},
	{"SWEETENED", 9, 84992},
	{"SWEETEN", 7, 120632},
	{"SWEETCORN", 9, 191747},
	{"SWEET", 5, 4774},
	{"SWEEPSTAKES", 11, 45876},
	{"SWEEPSTAKE", 10, 104266},
	{"SWEEPS", 6, 57622},
	{"SWEEPING", 8, 45220},
	{"SWEEPERS", 8, 103800},
	{"SWEEPER", 7, 57865},
	{"SWEEP", 5, 8413},
	{"SWEENY", 6, 142532},
	{"SWEENEY", 7, 51159},
	{"SWEEDISH", 8, 208667},
	{"SWEEDEN", 7, 172519},
	{"SWEDISH", 7, 8859},
	{"SWEDESBORO", 10, 183565},
	{"SWEDES", 6, 90403},
	{"SWEDENBORG", 10, 143374},
	{"SWEDEN", 6, 4949},
	{"SWEDE", 5, 90328},
	{"SWED", 4, 158352},
	{"SWECO", 5, 254767},
	{"SWECKER", 7, 249925},
	{"SWEC", 4, 47534},
	{"SWEATY", 6, 68663},
	{"SWEATSUIT", 9, 243484},
	{"SWEATSHOPS", 10, 119455},
	{"SWEATSHOP", 9, 102262},
	{"SWEATSHIRTS", 11, 42980},
	{"SWEATSHIRT", 10, 39962},
	{"SWEATS", 6, 68910},
	{"SWEATPANTS", 10, 112740},
	{"SWEATING", 8, 60145},
	{"SWEATIN", 7, 200778},
	{"SWEATERS", 8, 44060},
	{"SWEATER", 7, 34888},
	{"SWEATED", 7, 173555},
	{"SWEATBANDS", 10, 255612},
	{"SWEATBAND", 9, 155093},
	{"SWEAT", 5, 30103},
	{"SWEARS", 6, 95833},
	{"SWEARINGEN", 10, 151164},
	{"SWEARING", 8, 63170},
	{"SWEAR", 5, 28774},
	{"SWCO", 4, 223303},
	{"SWCL", 4, 241597},
	{"SWCH", 4, 191272},
	{"SWCD", 4, 174591},
	{"SWBT", 4, 177416},
	{"SWBC", 4, 260860},
	{"SWBA", 4, 218877},
	{"SWAZILAND", 9, 36604},
	{"SWAZI", 5, 132206},
	{"SWAZ", 4, 156626},
	{"SWAYZE", 6, 122134},
	{"SWAYZAK", 7, 188905},
	{"SWAYS", 5, 180132},
	{"SWAYNE", 6, 180821},
	{"SWAYING", 7, 88164},
	{"SWAYED", 6, 89381},
	{"SWAYBACK", 8, 156436},
	{"SWAY", 4, 52886},
	{"SWAX", 4, 148680},
	{"SWAW", 4, 250826},
	{"SWAV", 4, 81880},
	{"SWAU", 4, 246943},
	{"SWATTING", 8, 229462},
	{"SWATTER", 7, 221161},
	{"SWATTED", 7, 227695},
	{"SWATI", 5, 192184},
	{"SWATHS", 6, 170495},
	{"SWATHNAME", 9, 178011},
	{"SWATHES", 7, 190118},
	{"SWATHED", 7, 198318},
	{"SWATHE", 6, 203717},
	{"SWATH", 5, 84754},
	{"SWATCHES", 8, 95847},
	{"SWATCH", 6, 61340},
	{"SWASHBUCKLING", 13, 142726},
	{"SWASHBUCKLERS", 13, 179631},
	{"SWASHBUCKLER", 12, 161408},
	{"SWASH", 5, 103986},
	{"SWARTZ", 6, 76512},
	{"SWARTHY", 7, 171425},
	{"SWARTHMORE", 10, 85751},
	{"SWART", 5, 128084},
	{"SWAROVSKI", 9, 43529},
	{"SWAROOP", 7, 256213},
	{"SWARMS", 6, 100541},
	{"SWARMING", 8, 96773},
	{"SWARMED", 7, 134995},
	{"SWARM", 5, 58583},
	{"SWARE", 5, 205525},
	{"SWARD", 5, 176506},
	{"SWARCH", 6, 160281},
	{"SWARBRICK", 9, 203889},
	{"SWARAJ", 6, 180550},
	{"SWAR", 4, 31695},
	{"SWAPS", 5, 59733},
	{"SWAPPING", 8, 49982},
	{"SWAPPERS", 8, 129061},
	{"SWAPPER", 7, 125208},
	{"SWAPPED", 7, 73505},
	{"SWAPPABLE", 9, 110531},
	{"SWAPP", 5, 162694},
	{"SWAPO", 5, 243454},
	{"SWAPMEET", 8, 232020},
	{"SWAPING", 7, 243512},
	{"SWAP", 4, 31064},
	{"SWANZEY", 7, 174024},
	{"SWANY", 5, 252733},
	{"SWANWICK", 8, 191713},
	{"SWANTON", 7, 110478},
	{"SWANSTONE", 9, 234540},
	{"SWANSTON", 8, 155359},
	{"SWANSONG", 8, 253049},
	{"SWANSON", 7, 53948},
	{"SWANSEA", 7, 44379},
	{"SWANSBORO", 9, 208811},
	{"SWANS", 5, 60445},
	{"SWANNANOA", 9, 198305},
	{"SWANN", 5, 67200},
	{"SWANMORE", 8, 247918},
	{"SWANLEY", 7, 158123},
	{"SWANKY", 6, 113181},
	{"SWANK", 5, 70828},
	{"SWANEPOEL", 9, 217191},
	{"SWANEE", 6, 213254},
	{"SWANAGE", 7, 130288},
	{"SWANA", 5, 248574},
	{"SWAMY", 5, 152053},
	{"SWAMPY", 6, 119198},
	{"SWAMPSCOTT", 10, 129577},
	{"SWAMPS", 6, 75536},
	{"SWAMPLAND", 9, 231371},
	{"SWAMPING", 8, 226638},
	{"SWAMPER", 7, 255634},
	{"SWAMPED", 7, 91837},
	{"SWAMP", 5, 44591},
	{"SWAMINATHAN", 11, 145589},
	{"SWAMINARAYAN", 12, 238862},
	{"SWAMIJI", 7, 194245},
	{"SWAMI", 5, 64184},
	{"SWAM", 4, 75473},
	{"SWALWELL", 8, 240348},
	{"SWALLOWTAIL", 11, 133755},
	{"SWALLOWS", 8, 62000},
	{"SWALLOWING", 10, 46604},
	{"SWALLOWERS", 10, 146418},
	{"SWALLOWER", 9, 255107},
	{"SWALLOWED", 9, 54104},
	{"SWALLOW", 7, 29463},
	{"SWALL", 5, 194266},
	{"SWALES", 6, 134400},
	{"SWALEDALE", 9, 243132},
	{"SWALE", 5, 117494},
	{"SWAL", 4, 33343},
	{"SWAKOPMUND", 10, 136704},
	{"SWAINSON", 8, 141932},
	{"SWAINSBORO", 10, 184183},
	{"SWAINE", 6, 205235},
	{"SWAIN", 5, 67714},
	{"SWAIM", 5, 170955},
	{"SWAHILI", 7, 59000},
	{"SWAGS", 5, 137456},
	{"SWAGMAN", 7, 221911},
	{"SWAGGERING", 10, 185729},
	{"SWAGGER", 7, 114278},
	{"SWAGGART", 8, 261126},
	{"SWAGELOK", 8, 183949},
	{"SWAGE", 5, 255168},
	{"SWAG", 4, 71987},
	{"SWAFFORD", 8, 184952},
	{"SWAFFHAM", 8, 177670},
	{"SWAF", 4, 165245},
	{"SWADLINCOTE", 11, 160720},
	{"SWADES", 6, 229931},
	{"SWADDLING", 9, 179619},
	{"SWADDLE", 7, 258248},
	{"SWAD", 4, 244064},
	{"SWAC", 4, 132402},
	{"SWABS", 5, 95968},
	{"SWABIAN", 7, 258662},
	{"SWAB", 4, 86148},
	{"SVYI", 4, 142339},
	{"SVWA", 4, 260861},
	{"SVUL", 4, 80787},
	{"SVUI", 4, 186508},
	{"SVSU", 4, 190756},
	{"SVSR", 4, 243908},
	{"SVSP", 4, 201573},
	{"SVSM", 4, 201070},
	{"SVSF", 4, 237355},
	{"SVSD", 4, 255655},
	{"SVSC", 4, 175271},
	{"SVSB", 4, 212411},
	{"SVREENSAVERS", 12, 235356},
	{"SVRE", 4, 206634},
	{"SVPT", 4, 246628},
	{"SVPO", 4, 229235},
	{"SVPA", 4, 248497},
	{"SVOY", 4, 123943},
	{"SVOW", 4, 93325},
	{"SVOU", 4, 235495},
	{"SVOR", 4, 151408},
	{"SVOM", 4, 216457},
	{"SVOL", 4, 42247},
	{"SVOG", 4, 203619},
	{"SVOD", 4, 222172},
	{"SVOBODA", 7, 111996},
	{"SVNSERVE", 8, 240919},
	{"SVNADMIN", 8, 205618},
	{"SVMS", 4, 217448},
	{"SVMA", 4, 259659},
	{"SVLUG", 5, 91775},
	{"SVLA", 4, 148534},
	{"SVIZZERA", 8, 135585},
	{"SVIZ", 4, 163683},
	{"SVIS", 4, 34473},
	{"SVIR", 4, 48967},
	{"SVIP", 4, 172776},
	{"SVILUPPO", 8, 140684},
	{"SVIL", 4, 31364},
	{"SVIK", 4, 120156},
	{"SVIJ", 4, 249448},
	{"SVIG", 4, 103897},
	{"SVIENCE", 7, 235258},
	{"SVIDEO", 6, 177766},
	{"SVIC", 4, 36390},
	{"SVIB", 4, 114367},
	{"SVGALIB", 7, 165914},
	{"SVGA", 4, 63130},
	{"SVETLANA", 8, 80382},
	{"SVETI", 5, 153735},
	{"SVETA", 5, 173562},
	{"SVERRE", 6, 215445},
	{"SVERIGES", 8, 172624},
	{"SVERIGE", 7, 54282},
	{"SVERDRUP", 8, 218118},
	{"SVERDLOVSK", 10, 214390},
	{"SVER", 4, 5611},
	{"SVENSSON", 8, 97659},
	{"SVENSON", 7, 166967},
	{"SVENSKA", 7, 48616},
	{"SVENSK", 6, 53966},
	{"SVENSEN", 7, 230987},
	{"SVENGALI", 8, 219482},
	{"SVENDSEN", 8, 149633},
	{"SVENDOWIDEIT", 12, 215921},
	{"SVEND", 5, 156024},
	{"SVELTE", 6, 155011},
	{"SVEL", 4, 94769},
	{"SVEIN", 5, 175334},
	{"SVEG", 4, 42877},
	{"SVED", 4, 223538},
	{"SVEC", 4, 256735},
	{"SVCS", 4, 60675},
	{"SVCO", 4, 258901},
	{"SVCE", 4, 213036},
	{"SVCDOC", 6, 112144},
	{"SVCD", 4, 52113},
	{"SVCA", 4, 247881},
	{"SVAU", 4, 109259},
	{"SVARTLING", 9, 260780},
	{"SVAR", 4, 145017},
	{"SVAP", 4, 183494},
	{"SVANTE", 6, 226777},
	{"SVAM", 4, 121463},
	{"SVALBARDAND", 11, 255131},
	{"SVALBARD", 8, 46593},
	{"SVAG", 4, 114211},
	{"SVAD", 4, 242173},
	{"SVAC", 4, 68811},
	{"SUZZ", 4, 222245},
	{"SUZYS", 5, 219840},
	{"SUZY", 4, 59707},
	{"SUZUKI", 6, 31051},
	{"SUZUKA", 6, 153796},
	{"SUZU", 4, 68263},
	{"SUZIE", 5, 79179},
	{"SUZI", 4, 91209},
	{"SUZHOU", 6, 91225},
	{"SUZH", 4, 219057},
	{"SUZETTE", 7, 120728},
	{"SUZE", 4, 94620},
	{"SUZANNE", 7, 39513},
	{"SUZANNA", 7, 146912},
	{"SUZANA", 6, 164445},
	{"SUZAN", 5, 125582},
	{"SUZA", 4, 70550},
	{"SUYU", 4, 225992},
	{"SUYO", 4, 199028},
	{"SUYA", 4, 122848},
	{"SUWON", 5, 190135},
	{"SUWO", 4, 146569},
	{"SUWI", 4, 131005},
	{"SUWH", 4, 139500},
	{"SUWE", 4, 173628},
	{"SUWANNEE", 8, 90881},
	{"SUWANEE", 7, 112398},
	{"SUWA", 4, 218789},
	{"SUVW", 4, 192490},
	{"SUVT", 4, 201754},
	{"SUVS", 4, 48384},
	{"SUVO", 4, 186382},
	{"SUVARI", 6, 126246},
	{"SUVA", 4, 101302},
	{"SUURI", 5, 244775},
	{"SUUNTO", 6, 67506},
	{"SUUN", 4, 256347},
	{"SUUM", 4, 220022},
	{"SUUK", 4, 160734},
	{"SUTURING", 8, 174623},
	{"SUTURES", 7, 104817},
	{"SUTURED", 7, 219876},
	{"SUTURE", 6, 77818},
	{"SUTU", 4, 259527},
	{"SUTTONS", 7, 180820},
	{"SUTTON", 6, 37972},
	{"SUTTLE", 6, 157012},
	{"SUTTER", 6, 58023},
	{"SUTTA", 5, 141072},
	{"SUTRO", 5, 204471},
	{"SUTRAS", 6, 119996},
	{"SUTRA", 5, 52420},
	{"SUTR", 4, 98244},
	{"SUTPHIN", 7, 255161},
	{"SUTPHEN", 7, 160210},
	{"SUTOR", 5, 225393},
	{"SUTL", 4, 212005},
	{"SUTHERLIN", 9, 169408},
	{"SUTHERLAND", 10, 45946},
	{"SUTHEP", 6, 243592},
	{"SUTERA", 6, 225497},
	{"SUTER", 5, 116574},
	{"SUTEKH", 6, 217153},
	{"SUTCLIFFE", 9, 91731},
	{"SUTC", 4, 147537},
	{"SUSY", 4, 95508},
	{"SUSW", 4, 58907},
	{"SUSV", 4, 140723},
	{"SUSUMU", 6, 140960},
	{"SUSU", 4, 170322},
	{"SUSTRANS", 8, 176391},
	{"SUSTRAN", 7, 254328},
	{"SUSTIVA", 7, 183166},
	{"SUSTEREN", 8, 209439},
	{"SUSTENANCE", 10, 89446},
	{"SUSTEEN", 7, 192326},
	{"SUSTANON", 8, 128301},
	{"SUSTAINS", 8, 81775},
	{"SUSTAINMENT", 11, 118278},
	{"SUSTAINING", 10, 46187},
	{"SUSTAINERS", 10, 244591},
	{"SUSTAINER", 9, 151329},
	{"SUSTAINED", 9, 32585},
	{"SUSTAINABLY", 11, 109675},
	{"SUSTAINABLE", 11, 35016},
	{"SUSTAINABILITY", 14, 32787},
	{"SUSTAIN", 7, 9668},
	{"SUSSURRI", 8, 247074},
	{"SUSSMAN", 7, 92262},
	{"SUSSKIND", 8, 193582},
	{"SUSSER", 6, 189396},
	{"SUSSE", 5, 247839},
	{"SUSR", 4, 76060},
	{"SUSQUEHANNA", 11, 70376},
	{"SUSQ", 4, 101486},
	{"SUSPIRIA", 8, 155544},
	{"SUSPICIOUSLY", 12, 87212},
	{"SUSPICIOUS", 10, 34835},
	{"SUSPICIONS", 10, 68311},
	{"SUSPICION", 9, 31316},
	{"SUSPERIA", 8, 211850},
	{"SUSPENSIONS", 11, 62005},
	{"SUSPENSION", 10, 8653},
	{"SUSPENSEFUL", 11, 108192},
	{"SUSPENSE", 8, 38538},
	{"SUSPENDS", 8, 89893},
	{"SUSPENDING", 10, 77195},
	{"SUSPENDERS", 10, 74967},
	{"SUSPENDER", 9, 104352},
	{"SUSPENDED", 9, 31592},
	{"SUSPEND", 7, 31238},
	{"SUSPENCE", 8, 228416},
	{"SUSPECTS", 8, 42246},
	{"SUSPECTING", 10, 103703},
	{"SUSPECTED", 9, 34681},
	{"SUSPECTDJ", 9, 153731},
	{"SUSPECT", 7, 6703},
	{"SUSP", 4, 112381},
	{"SUSMAN", 6, 226139},
	{"SUSM", 4, 71474},
	{"SUSL", 4, 89530},
	{"SUSKIND", 7, 180285},
	{"SUSK", 4, 151168},
	{"SUSJ", 4, 152663},
	{"SUSITNA", 7, 158763},
	{"SUSILO", 6, 185965},
	{"SUSIEQ", 6, 244776},
	{"SUSIE", 5, 51358},
	{"SUSHUBH", 7, 223956},
	{"SUSHMITA", 8, 216385},
	{"SUSHMA", 6, 232174},
	{"SUSHIL", 6, 184070},
	{"SUSHI", 5, 40605},
	{"SUSG", 4, 92624},
	{"SUSF", 4, 59752},
	{"SUSEWWW", 7, 120161},
	{"SUSE", 4, 31416},
	{"SUSD", 4, 66353},
	{"SUSCRIBIENDO", 12, 261887},
	{"SUSCRIBE", 8, 175147},
	{"SUSCIPIT", 8, 168606},
	{"SUSCEPTIBLE", 11, 44075},
	{"SUSCEPTIBILITY", 14, 48768},
	{"SUSCEPTIBILITIES", 16, 170144},
	{"SUSCEP", 6, 257333},
	{"SUSB", 4, 52479},
	{"SUSANVILLE", 10, 130957},
	{"SUSANS", 6, 194800},
	{"SUSANNE", 7, 69709},
	{"SUSANNAH", 8, 71419},
	{"SUSANNA", 7, 60688},
	{"SUSANN", 6, 215936},
	{"SUSANA", 6, 87514},
	{"SUSAN", 5, 6649},
	{"SURYA", 5, 97028},
	{"SURW", 4, 225552},
	{"SURVIVORSHIP", 12, 103153},
	{"SURVIVORS", 9, 35919},
	{"SURVIVOR", 8, 9850},
	{"SURVIVING", 9, 38928},
	{"SURVIVIN", 8, 208813},
	{"SURVIVES", 8, 60223},
	{"SURVIVED", 8, 37933},
	{"SURVIVE", 7, 4169},
	{"SURVIVALS", 9, 231548},
	{"SURVIVALIST", 11, 180613},
	{"SURVIVALINK", 11, 187283},
	{"SURVIVAL", 8, 8478},
	{"SURVIVABLE", 10, 154716},
	{"SURVIVABILITY", 13, 98212},
	{"SURVIVA", 7, 213851},
	{"SURVEYS", 7, 6406},
	{"SURVEYORS", 9, 47470},
	{"SURVEYOR", 8, 46753},
	{"SURVEYING", 9, 45036},
	{"SURVEYED", 8, 41676},
	{"SURVEY", 6, 3550},
	{"SURVEX", 6, 230715},
	{"SURVEILLER", 10, 259440},
	{"SURVEILLANCE", 12, 35527},
	{"SURVEILANCE", 11, 233045},
	{"SURVEIL", 7, 232640},
	{"SURV", 4, 103480},
	{"SURU", 4, 237440},
	{"SURTOUT", 7, 170158},
	{"SURTEES", 7, 184768},
	{"SURTAX", 6, 177886},
	{"SURRY", 5, 80340},
	{"SURROUNDS", 9, 51854},
	{"SURROUNDINGS", 12, 40663},
	{"SURROUNDING", 11, 33854},
	{"SURROUNDED", 10, 34254},
	{"SURROUND", 8, 5044},
	{"SURROGATES", 10, 110266},
	{"SURROGATE", 9, 60769},
	{"SURROGACY", 9, 139973},
	{"SURREY", 6, 32955},
	{"SURREPTITIOUSLY", 15, 128299},
	{"SURREPTITIOUS", 13, 163571},
	{"SURRENDERS", 10, 109042},
	{"SURRENDERING", 12, 95534},
	{"SURRENDERED", 11, 60959},
	{"SURRENDER", 9, 38949},
	{"SURREALISTS", 11, 199239},
	{"SURREALISTIC", 12, 155316},
	{"SURREALIST", 10, 105571},
	{"SURREALISM", 10, 82651},
	{"SURREAL", 7, 54209},
	{"SURRATT", 7, 236137},
	{"SURR", 4, 197978},
	{"SURPRIZED", 9, 231431},
	{"SURPRIZE", 8, 202190},
	{"SURPRISINGLY", 12, 29302},
	{"SURPRISING", 10, 9113},
	{"SURPRISES", 9, 45462},
	{"SURPRISED", 9, 5894},
	{"SURPRISE", 8, 5066},
	{"SURPRIS", 7, 194810},
	{"SURPLUSES", 9, 80187},
	{"SURPLUS", 7, 31989},
	{"SURPLICE", 8, 228913},
	{"SURPASSING", 10, 90444},
	{"SURPASSES", 9, 86692},
	{"SURPASSED", 9, 67351},
	{"SURPASS", 7, 68527},
	{"SUROWIECKI", 10, 210074},
	{"SURNAMES", 8, 42897},
	{"SURNAMED", 8, 212726},
	{"SURNAME", 7, 33484},
	{"SURN", 4, 94990},
	{"SURMOUNTING", 11, 229448},
	{"SURMOUNTED", 10, 131228},
	{"SURMOUNT", 8, 159850},
	{"SURMISES", 8, 242141},
	{"SURMISED", 8, 134785},
	{"SURMISE", 7, 116895},
	{"SURMAN", 6, 237531},
	{"SURMA", 5, 220355},
	{"SURM", 4, 78078},
	{"SURLY", 5, 90497},
	{"SURLATABLE", 10, 259959},
	{"SURJIT", 6, 244027},
	{"SURJECTIVE", 10, 145931},
	{"SURJ", 4, 242174},
	{"SURIYAN", 7, 203967},
	{"SURING", 6, 199767},
	{"SURINDER", 8, 199624},
	{"SURINAME", 8, 38167},
	{"SURINAM", 7, 94619},
	{"SURIN", 5, 146320},
	{"SURIMI", 6, 255847},
	{"SURIGAO", 7, 224778},
	{"SURI", 4, 120558},
	{"SURGING", 7, 83459},
	{"SURGICALLY", 10, 85279},
	{"SURGICAL", 8, 28887},
	{"SURGETTE", 8, 248421},
	{"SURGES", 6, 70961},
	{"SURGERYPLASTIC", 14, 185838},
	{"SURGERYCOSMETIC", 15, 257234},
	{"SURGERY", 7, 5561},
	{"SURGERIES", 9, 60402},
	{"SURGEONS", 8, 36425},
	{"SURGEON", 7, 29524},
	{"SURGEMASTER", 11, 103212},
	{"SURGED", 6, 86095},
	{"SURGEARREST", 11, 230131},
	{"SURGE", 5, 35796},
	{"SURG", 4, 52276},
	{"SURFWEAR", 8, 204548},
	{"SURFWAX", 7, 219925},
	{"SURFWATCH", 9, 215852},
	{"SURFTHING", 9, 250891},
	{"SURFSIDE", 8, 87348},
	{"SURFS", 5, 135801},
	{"SURFRIDER", 9, 151715},
	{"SURFRAW", 7, 193964},
	{"SURFPOINT", 9, 232281},
	{"SURFNET", 7, 141937},
	{"SURFMAGIC", 9, 211607},
	{"SURFLINE", 8, 163284},
	{"SURFING", 7, 31499},
	{"SURFIN", 6, 109402},
	{"SURFICIAL", 9, 127051},
	{"SURFERS", 7, 44755},
	{"SURFER", 6, 49779},
	{"SURFEN", 6, 154945},
	{"SURFEIT", 7, 185916},
	{"SURFED", 6, 89906},
	{"SURFDOM", 7, 160523},
	{"SURFCONTROL", 11, 160830},
	{"SURFCAM", 7, 213090},
	{"SURFBOARDS", 10, 77561},
	{"SURFBOARD", 9, 77430},
	{"SURFACTANTS", 11, 91847},
	{"SURFACTANT", 10, 76864},
	{"SURFACING", 9, 72970},
	{"SURFACES", 8, 30203},
	{"SURFACED", 8, 66538},
	{"SURFACE", 7, 3012},
	{"SURF", 4, 9671},
	{"SUREWOOD", 8, 168307},
	{"SURETY", 6, 57282},
	{"SURETIES", 8, 133690},
	{"SURESTORE", 9, 150063},
	{"SURESTART", 9, 245883},
	{"SUREST", 6, 124112},
	{"SURESHOT", 8, 172903},
	{"SURESH", 6, 82669},
	{"SURES", 5, 129197},
	{"SURER", 5, 182232},
	{"SUREPOS", 7, 215539},
	{"SURENDRA", 8, 205873},
	{"SURENDETTEMENT", 14, 220863},
	{"SUREMENTS", 9, 174658},
	{"SUREMENT", 8, 191430},
	{"SURELY", 6, 7623},
	{"SUREGRIP", 8, 260598},
	{"SUREFIT", 7, 218781},
	{"SUREFIRE", 8, 89917},
	{"SURED", 5, 139049},
	{"SURECOM", 7, 179267},
	{"SURE", 4, 1341},
	{"SURCO", 5, 220016},
	{"SURCHARGES", 10, 70954},
	{"SURCHARGED", 10, 241398},
	{"SURCHARGE", 9, 47811},
	{"SURC", 4, 95997},
	{"SURBURBAN", 9, 163132},
	{"SURBL", 5, 220096},
	{"SURBITON", 8, 111766},
	{"SURBER", 6, 156607},
	{"SURB", 4, 79343},
	{"SURATTHANI", 10, 257185},
	{"SURAT", 5, 69239},
	{"SURANCE", 7, 174920},
	{"SURAJ", 5, 180912},
	{"SURAH", 5, 95837},
	{"SURABAYA", 8, 102718},
	{"SURA", 4, 103427},
	{"SUR", 3, 8882},
	{"SUQUAMISH", 9, 217150},
	{"SUQU", 4, 248498},
	{"SUPYBOT", 7, 242922},
	{"SUPY", 4, 150031},
	{"SUPW", 4, 50623},
	{"SUPV", 4, 141300},
	{"SUPUESTO", 8, 213655},
	{"SUPU", 4, 113533},
	{"SUPT", 4, 88385},
	{"SUPRNOVA", 8, 244637},
	{"SUPRISINGLY", 11, 139236},
	{"SUPRISING", 9, 157082},
	{"SUPRISES", 8, 210943},
	{"SUPRISED", 8, 86270},
	{"SUPRISE", 7, 76427},
	{"SUPRIS", 6, 209876},
	{"SUPRGLU", 7, 186327},
	{"SUPRESSION", 10, 218964},
	{"SUPRESSED", 9, 257998},
	{"SUPRESS", 7, 187504},
	{"SUPREMUM", 8, 193965},
	{"SUPREMO", 7, 135764},
	{"SUPREMES", 8, 95463},
	{"SUPREMELY", 9, 96004},
	{"SUPREME", 7, 4760},
	{"SUPREMACY", 9, 58651},
	{"SUPREMACISTS", 12, 168965},
	{"SUPREMACIST", 11, 121609},
	{"SUPREMA", 7, 198249},
	{"SUPRE", 5, 212107},
	{"SUPRAX", 6, 230795},
	{"SUPRAVENTRICULAR", 16, 189501},
	{"SUPRAPHON", 9, 244367},
	{"SUPRANUCLEAR", 12, 235056},
	{"SUPRANATIONAL", 13, 117830},
	{"SUPRAMOLECULAR", 14, 144513},
	{"SUPRACHIASMATIC", 15, 245580},
	{"SUPRA", 5, 38154},
	{"SUPR", 4, 166846},
	{"SUPQ", 4, 228720},
	{"SUPPY", 5, 244060},
	{"SUPPURATIVE", 11, 199146},
	{"SUPPRIMER", 9, 136772},
	{"SUPPRESSORS", 11, 92076},
	{"SUPPRESSOR", 10, 61446},
	{"SUPPRESSIVE", 11, 124244},
	{"SUPPRESSION", 11, 40690},
	{"SUPPRESSING", 11, 73847},
	{"SUPPRESSES", 10, 84021},
	{"SUPPRESSED", 10, 48349},
	{"SUPPRESSANTS", 12, 124120},
	{"SUPPRESSANT", 11, 82765},
	{"SUPPRESS", 8, 47074},
	{"SUPPPORT", 8, 205947},
	{"SUPPOSITORY", 11, 134632},
	{"SUPPOSITORIES", 13, 105110},
	{"SUPPOSITIONS", 12, 186324},
	{"SUPPOSITION", 11, 92106},
	{"SUPPOSING", 9, 86528},
	{"SUPPOSES", 8, 125669},
	{"SUPPOSEDLY", 10, 34758},
	{"SUPPOSED", 8, 3737},
	{"SUPPOSE", 7, 6578},
	{"SUPPORTS", 8, 4336},
	{"SUPPORTPLUS", 11, 204289},
	{"SUPPORTO", 8, 130862},
	{"SUPPORTIVE", 10, 34217},
	{"SUPPORTING", 10, 4984},
	{"SUPPORTERS", 10, 30718},
	{"SUPPORTER", 9, 7593},
	{"SUPPORTED", 9, 3252},
	{"SUPPORTABLE", 11, 143136},
	{"SUPPORTABILITY", 14, 189765},
	{"SUPPORT", 7, 1747},
	{"SUPPOR", 6, 142535},
	{"SUPPO", 5, 172372},
	{"SUPPLYS", 7, 218753},
	{"SUPPLYLINE", 10, 205727},
	{"SUPPLYING", 9, 40734},
	{"SUPPLYHOUSETIMES", 16, 248409},
	{"SUPPLYCHAINER", 13, 243990},
	{"SUPPLY", 6, 4603},
	{"SUPPLT", 6, 168827},
	{"SUPPLIMENTS", 11, 190819},
	{"SUPPLIMENT", 10, 247155},
	{"SUPPLIES", 8, 1822},
	{"SUPPLIERS", 9, 4856},
	{"SUPPLIER", 8, 33354},
	{"SUPPLIED", 8, 3755},
	{"SUPPLIE", 7, 185896},
	{"SUPPLICATIONS", 13, 172544},
	{"SUPPLICATION", 12, 116129},
	{"SUPPLICANT", 10, 173112},
	{"SUPPLI", 6, 241143},
	{"SUPPLEX", 7, 184177},
	{"SUPPLENESS", 10, 179209},
	{"SUPPLEMENTS", 11, 8300},
	{"SUPPLEMENTING", 13, 86406},
	{"SUPPLEMENTHERBAL", 16, 251651},
	{"SUPPLEMENTED", 12, 50050},
	{"SUPPLEMENTATION", 15, 55447},
	{"SUPPLEMENTARY", 13, 38179},
	{"SUPPLEMENTAL", 12, 33900},
	{"SUPPLEMENT", 10, 8676},
	{"SUPPLE", 6, 66623},
	{"SUPPLANTING", 11, 203025},
	{"SUPPLANTED", 10, 122174},
	{"SUPPLANT", 8, 101809},
	{"SUPPL", 5, 50104},
	{"SUPPERS", 7, 137857},
	{"SUPPER", 6, 43819},
	{"SUPPED", 6, 190565},
	{"SUPPAN", 6, 237785},
	{"SUPP", 4, 42820},
	{"SUPOSED", 7, 241522},
	{"SUPOSE", 6, 254069},
	{"SUPORTE", 7, 200454},
	{"SUPORT", 6, 135630},
	{"SUPO", 4, 44124},
	{"SUPN", 4, 110756},
	{"SUPM", 4, 92010},
	{"SUPLS", 5, 131845},
	{"SUPLEX", 6, 161574},
	{"SUPL", 4, 218611},
	{"SUPK", 4, 178055},
	{"SUPJ", 4, 180445},
	{"SUPINE", 6, 117159},
	{"SUPIMA", 6, 202859},
	{"SUPI", 4, 53108},
	{"SUPHP", 5, 248436},
	{"SUPH", 4, 64294},
	{"SUPG", 4, 72499},
	{"SUPF", 4, 51318},
	{"SUPES", 5, 199137},
	{"SUPERZOOM", 9, 245615},
	{"SUPERYACHT", 10, 140843},
	{"SUPERWOMAN", 10, 197462},
	{"SUPERWAREHOUSE", 14, 245497},
	{"SUPERVISORY", 11, 41511},
	{"SUPERVISORS", 11, 36109},
	{"SUPERVISORIAL", 13, 189370},
	{"SUPERVISOR", 10, 30087},
	{"SUPERVISION", 11, 28798},
	{"SUPERVISING", 11, 51821},
	{"SUPERVISES", 10, 75994},
	{"SUPERVISED", 10, 41960},
	{"SUPERVISE", 9, 50099},
	{"SUPERVI", 7, 218339},
	{"SUPERVENIENCE", 13, 260144},
	{"SUPERVALU", 9, 132967},
	{"SUPERUSER", 9, 100563},
	{"SUPERTYPES", 10, 260732},
	{"SUPERTYPE", 9, 205422},
	{"SUPERTRAMP", 10, 102368},
	{"SUPERTONES", 10, 236877},
	{"SUPERTEX", 8, 213162},
	{"SUPERTEK", 8, 163633},
	{"SUPERTEENS", 10, 220263},
	{"SUPERTECH", 9, 195247},
	{"SUPERSYMMETRY", 13, 100330},
	{"SUPERSYMMETRIC", 14, 102933},
	{"SUPERSUCKERS", 12, 178935},
	{"SUPERSTUD", 9, 250235},
	{"SUPERSTRUCTURES", 15, 222899},
	{"SUPERSTRUCTURE", 14, 98960},
	{"SUPERSTRINGS", 12, 207479},
	{"SUPERSTRING", 11, 155629},
	{"SUPERSTORES", 11, 102978},
	{"SUPERSTORE", 10, 38437},
	{"SUPERSTOCK", 10, 101979},
	{"SUPERSTITIOUS", 13, 94679},
	{"SUPERSTITIONS", 13, 91197},
	{"SUPERSTITION", 12, 65588},
	{"SUPERSTATION", 12, 258337},
	{"SUPERSTARS", 10, 60622},
	{"SUPERSTARDOM", 12, 231238},
	{"SUPERSTAR", 9, 44211},
	{"SUPERSTACK", 10, 122544},
	{"SUPERSPRINT", 11, 231952},
	{"SUPERSPORT", 10, 95119},
	{"SUPERSPEEDWAY", 13, 179740},
	{"SUPERSOUND", 10, 260719},
	{"SUPERSONICS", 11, 81485},
	{"SUPERSONIC", 10, 70105},
	{"SUPERSOFT", 9, 168485},
	{"SUPERSLOTS", 10, 235259},
	{"SUPERSLAM", 9, 145042},
	{"SUPERSIZED", 10, 74317},
	{"SUPERSIZE", 9, 107422},
	{"SUPERSITE", 9, 107694},
	{"SUPERSET", 8, 116054},
	{"SUPERSERVER", 11, 227171},
	{"SUPERSEEKER", 11, 161307},
	{"SUPERSEDING", 11, 116037},
	{"SUPERSEDES", 10, 72445},
	{"SUPERSEDED", 10, 57392},
	{"SUPERSEDE", 9, 87834},
	{"SUPERSEARCH", 11, 114992},
	{"SUPERSCRIPTS", 12, 168077},
	{"SUPERSCRIPTBOX", 14, 166940},
	{"SUPERSCRIPT", 11, 93050},
	{"SUPERSCOPE", 10, 251229},
	{"SUPERSCALAR", 11, 157279},
	{"SUPERSAVER", 10, 162024},
	{"SUPERSATURATION", 15, 206414},
	{"SUPERSATURATED", 14, 258348},
	{"SUPERS", 6, 129526},
	{"SUPERPRO", 8, 229884},
	{"SUPERPOWERS", 11, 114788},
	{"SUPERPOWER", 10, 70225},
	{"SUPERPOTENTIAL", 14, 217388},
	{"SUPERPOSITION", 13, 95462},
	{"SUPERPOSED", 10, 180186},
	{"SUPERPOP", 8, 170337},
	{"SUPERPAVE", 9, 182008},
	{"SUPERPASS", 9, 176491},
	{"SUPERPAGES", 10, 50134},
	{"SUPERPACK", 9, 246563},
	{"SUPEROXIDE", 10, 82536},
	{"SUPEROSITY", 10, 170317},
	{"SUPERNUMERARY", 13, 181586},
	{"SUPERNOVAE", 10, 106663},
	{"SUPERNOVA", 9, 63330},
	{"SUPERNET", 8, 225634},
	{"SUPERNATURALLY", 14, 227336},
	{"SUPERNATURAL", 12, 45767},
	{"SUPERNATURA", 11, 240704},
	{"SUPERNATANTS", 12, 136969},
	{"SUPERNATANT", 11, 94200},
	{"SUPERNANNY", 10, 255805},
	{"SUPERNAL", 8, 242535},
	{"SUPERMULTI", 10, 177760},
	{"SUPERMOTO", 9, 137389},
	{"SUPERMOTARD", 11, 212793},
	{"SUPERMODELS", 11, 71949},
	{"SUPERMODEL", 10, 75937},
	{"SUPERMOD", 8, 247531},
	{"SUPERMINI", 9, 255269},
	{"SUPERMICRO", 10, 67651},
	{"SUPERMEN", 8, 217877},
	{"SUPERMEMO", 9, 253608},
	{"SUPERMAX", 8, 217035},
	{"SUPERMATE", 9, 185263},
	{"SUPERMASSIVE", 12, 201504},
	{"SUPERMARKETS", 12, 50172},
	{"SUPERMARKET", 11, 34896},
	{"SUPERMARINE", 11, 202534},
	{"SUPERMAN", 8, 38853},
	{"SUPERMAJORITY", 13, 215217},
	{"SUPERLUMINAL", 12, 226289},
	{"SUPERLITE", 9, 236962},
	{"SUPERLINK", 9, 175765},
	{"SUPERLIGHT", 10, 191142},
	{"SUPERLIGA", 9, 233731},
	{"SUPERLEAGUE", 11, 220709},
	{"SUPERLATTICES", 13, 171447},
	{"SUPERLATTICE", 12, 188350},
	{"SUPERLATIVES", 12, 138298},
	{"SUPERLATIVE", 11, 92151},
	{"SUPERKARAMBA", 12, 214549},
	{"SUPERJOINT", 10, 168070},
	{"SUPERIORS", 9, 78147},
	{"SUPERIORITY", 11, 55672},
	{"SUPERIORES", 10, 182436},
	{"SUPERIORE", 9, 131535},
	{"SUPERIOR", 8, 29389},
	{"SUPERINTERFACES", 15, 228947},
	{"SUPERINTENDING", 14, 204204},
	{"SUPERINTENDENTS", 15, 75709},
	{"SUPERINTENDENT", 14, 34862},
	{"SUPERINTENDENCY", 15, 216017},
	{"SUPERINTENDENCE", 15, 151275},
	{"SUPERINTENDANT", 14, 244094},
	{"SUPERINTEND", 11, 239774},
	{"SUPERIMPOSITION", 15, 222617},
	{"SUPERIMPOSING", 13, 223576},
	{"SUPERIMPOSED", 12, 78334},
	{"SUPERIMPOSE", 11, 179595},
	{"SUPERIEURE", 10, 179806},
	{"SUPERIA", 7, 188508},
	{"SUPERHUMAN", 10, 106700},
	{"SUPERHITS", 9, 254070},
	{"SUPERHIGHWAY", 12, 100839},
	{"SUPERHIGH", 9, 198151},
	{"SUPERHEROS", 10, 204981},
	{"SUPERHEROINE", 12, 223102},
	{"SUPERHEROES", 11, 73795},
	{"SUPERHERO", 9, 54943},
	{"SUPERHEATED", 11, 182428},
	{"SUPERGROUPS", 11, 249425},
	{"SUPERGROUP", 10, 142482},
	{"SUPERGRAVITY", 12, 133463},
	{"SUPERGRASS", 10, 100917},
	{"SUPERGRACE", 10, 188528},
	{"SUPERGLUE", 9, 210467},
	{"SUPERGIRL", 9, 106777},
	{"SUPERGENIUS", 11, 247819},
	{"SUPERFUND", 9, 65117},
	{"SUPERFOODS", 10, 145185},
	{"SUPERFOOD", 9, 214188},
	{"SUPERFLY", 8, 130241},
	{"SUPERFLUOUS", 11, 75238},
	{"SUPERFLUID", 10, 154999},
	{"SUPERFINE", 9, 121971},
	{"SUPERFICIE", 10, 192056},
	{"SUPERFICIALLY", 13, 105981},
	{"SUPERFICIALITY", 14, 203201},
	{"SUPERFICIAL", 11, 51685},
	{"SUPERFI", 7, 220572},
	{"SUPERFEET", 9, 169867},
	{"SUPERFECTA", 10, 212942},
	{"SUPERFAST", 9, 110486},
	{"SUPERFAMILY", 11, 62682},
	{"SUPEREGO", 8, 190106},
	{"SUPERDUPERITEM", 14, 214755},
	{"SUPERDUPERCLUB", 14, 132719},
	{"SUPERDUPER", 10, 260377},
	{"SUPERDRIVE", 10, 87527},
	{"SUPERDOTATI", 11, 205521},
	{"SUPERDOME", 9, 96264},
	{"SUPERDISH", 9, 139703},
	{"SUPERDISC", 9, 238884},
	{"SUPERDAT", 8, 224799},
	{"SUPERCUTS", 9, 246140},
	{"SUPERCROSS", 10, 81071},
	{"SUPERCRITICAL", 13, 100712},
	{"SUPERCREW", 9, 173382},
	{"SUPERCOOLED", 11, 209800},
	{"SUPERCOOL", 9, 93254},
	{"SUPERCONTIG", 11, 175315},
	{"SUPERCONDUCTORS", 15, 91996},
	{"SUPERCONDUCTOR", 14, 103450},
	{"SUPERCONDUCTIVITY", 17, 86933},
	{"SUPERCONDUCTIVE", 15, 261416},
	{"SUPERCONDUCTING", 15, 71769},
	{"SUPERCOMPUTING", 14, 79360},
	{"SUPERCOMPUTERS", 14, 102536},
	{"SUPERCOMPUTER", 13, 75167},
	{"SUPERCOMM", 9, 186981},
	{"SUPERCOLLIDER", 13, 195455},
	{"SUPERCLUBS", 10, 130721},
	{"SUPERCLASSES", 12, 155318},
	{"SUPERCLASS", 10, 87458},
	{"SUPERCILIOUS", 12, 240552},
	{"SUPERCHUNK", 10, 173808},
	{"SUPERCHIPS", 10, 180029},
	{"SUPERCHICKEN", 12, 139196},
	{"SUPERCHARGING", 13, 209767},
	{"SUPERCHARGERS", 13, 143929},
	{"SUPERCHARGER", 12, 94210},
	{"SUPERCHARGED", 12, 78020},
	{"SUPERCHARGE", 11, 149051},
	{"SUPERCENTERS", 12, 221415},
	{"SUPERCENTER", 11, 119767},
	{"SUPERCELLS", 10, 242610},
	{"SUPERCELL", 9, 167862},
	{"SUPERCEDES", 10, 151144},
	{"SUPERCEDED", 10, 130998},
	{"SUPERCEDE", 9, 161239},
	{"SUPERCASE", 9, 210843},
	{"SUPERCARS", 9, 118036},
	{"SUPERCARD", 9, 255036},
	{"SUPERCAR", 8, 99735},
	{"SUPERCAB", 8, 118641},
	{"SUPERBUGS", 9, 257108},
	{"SUPERBUG", 8, 215330},
	{"SUPERBREAK", 10, 127345},
	{"SUPERBRA", 8, 245202},
	{"SUPERBOY", 8, 149102},
	{"SUPERBOWL", 9, 52190},
	{"SUPERBOOKDEALS", 14, 204845},
	{"SUPERBOAT", 9, 191433},
	{"SUPERBLY", 8, 69118},
	{"SUPERBLOCK", 10, 157996},
	{"SUPERBIT", 8, 99944},
	{"SUPERBIKES", 10, 144058},
	{"SUPERBIKE", 9, 75780},
	{"SUPERBE", 7, 181308},
	{"SUPERBALL", 9, 186851},
	{"SUPERBA", 7, 193026},
	{"SUPERB", 6, 31124},
	{"SUPERANNUATION", 14, 50637},
	{"SUPERAMERICA", 12, 236535},
	{"SUPERALLOYS", 11, 255543},
	{"SUPERADS", 8, 155934},
	{"SUPERADMINGROUP", 15, 241949},
	{"SUPER", 5, 8327},
	{"SUPE", 4, 125413},
	{"SUPD", 4, 61903},
	{"SUPC", 4, 70506},
	{"SUPB", 4, 64702},
	{"SUPA", 4, 105681},
	{"SUOZZI", 6, 208816},
	{"SUOU", 4, 184612},
	{"SUONO", 5, 225194},
	{"SUONERIE", 8, 70521},
	{"SUONERIA", 8, 162446},
	{"SUOMINEN", 8, 259752},
	{"SUOMI", 5, 54552},
	{"SUOMEN", 6, 128841},
	{"SUOMEKSI", 8, 111144},
	{"SUOMEA", 6, 140181},
	{"SUOM", 4, 149009},
	{"SUOK", 4, 260862},
	{"SUOF", 4, 167243},
	{"SUNYAC", 6, 211694},
	{"SUNY", 4, 51748},
	{"SUNWEAR", 7, 177212},
	{"SUNWAYS", 7, 223680},
	{"SUNWAY", 6, 155392},
	{"SUNW", 4, 124952},
	{"SUNVTS", 6, 193227},
	{"SUNVISOR", 8, 201746},
	{"SUNV", 4, 79818},
	{"SUNUNU", 6, 155476},
	{"SUNU", 4, 62812},
	{"SUNTV", 5, 160089},
	{"SUNTRUST", 8, 100832},
	{"SUNTOUR", 7, 221989},
	{"SUNTORY", 7, 209039},
	{"SUNTIME", 7, 225950},
	{"SUNTERRA", 8, 144658},
	{"SUNTEC", 6, 177328},
	{"SUNTAN", 6, 121784},
	{"SUNSYSTEMS", 10, 231653},
	{"SUNSUN", 6, 124167},
	{"SUNSTUDIO", 9, 144627},
	{"SUNSTROKE", 9, 210651},
	{"SUNSTOVE", 8, 227392},
	{"SUNSTONE", 8, 154201},
	{"SUNSTEIN", 8, 161442},
	{"SUNSTAR", 7, 129623},
	{"SUNSPREE", 8, 136047},
	{"SUNSPOTS", 8, 122725},
	{"SUNSPOT", 7, 95546},
	{"SUNSPECS", 8, 154855},
	{"SUNSOUT", 7, 251686},
	{"SUNSOURCE", 9, 231743},
	{"SUNSOLVE", 8, 137395},
	{"SUNSOFT", 7, 117316},
	{"SUNSITE", 7, 149929},
	{"SUNSHOWER", 9, 240376},
	{"SUNSHINE", 8, 29578},
	{"SUNSHADES", 9, 195667},
	{"SUNSHADE", 8, 140152},
	{"SUNSETS", 7, 59903},
	{"SUNSET", 6, 9403},
	{"SUNSEEKER", 9, 127629},
	{"SUNSCREENS", 10, 116721},
	{"SUNSCREEN", 9, 61855},
	{"SUNSCAPE", 8, 184011},
	{"SUNSATION", 9, 180636},
	{"SUNSAIL", 7, 225379},
	{"SUNRUNNER", 9, 253639},
	{"SUNRPC", 6, 149468},
	{"SUNROOMS", 8, 131802},
	{"SUNROOM", 7, 110026},
	{"SUNROOFS", 8, 216133},
	{"SUNROOF", 7, 68714},
	{"SUNROCKET", 9, 160844},
	{"SUNRIVER", 8, 139545},
	{"SUNRISES", 8, 123612},
	{"SUNRISE", 7, 32818},
	{"SUNRIDGE", 8, 198268},
	{"SUNREX", 6, 133458},
	{"SUNRESCUE", 9, 154506},
	{"SUNRAYS", 7, 247840},
	{"SUNRAY", 6, 106888},
	{"SUNRACE", 7, 180157},
	{"SUNR", 4, 48242},
	{"SUNQUEST", 8, 245283},
	{"SUNQ", 4, 115474},
	{"SUNPENTOWN", 10, 113783},
	{"SUNPAK", 6, 100701},
	{"SUNP", 4, 56594},
	{"SUNOS", 5, 60638},
	{"SUNON", 5, 234655},
	{"SUNOL", 5, 163403},
	{"SUNOCO", 6, 120886},
	{"SUNNYVALE", 9, 52638},
	{"SUNNYSLOPE", 10, 253001},
	{"SUNNYSIDE", 9, 76648},
	{"SUNNYDALE", 9, 134142},
	{"SUNNYCAM", 8, 144011},
	{"SUNNYBROOK", 10, 133487},
	{"SUNNYBANK", 9, 170566},
	{"SUNNY", 5, 35573},
	{"SUNNIS", 6, 80945},
	{"SUNNINGDALE", 11, 181047},
	{"SUNNING", 7, 140789},
	{"SUNNIEST", 8, 241979},
	{"SUNNIER", 7, 237946},
	{"SUNNI", 5, 53174},
	{"SUNNEYDALE", 10, 246750},
	{"SUNNED", 6, 207133},
	{"SUNNAH", 6, 105881},
	{"SUNNA", 5, 120041},
	{"SUNM", 4, 70866},
	{"SUNLIT", 6, 120382},
	{"SUNLINK", 7, 261139},
	{"SUNLINE", 7, 221982},
	{"SUNLIGHT", 8, 31049},
	{"SUNLESS", 7, 60413},
	{"SUNLAND", 7, 117989},
	{"SUNL", 4, 38005},
	{"SUNKIST", 7, 146004},
	{"SUNKEN", 6, 71959},
	{"SUNK", 4, 57543},
	{"SUNJ", 4, 114592},
	{"SUNIX", 5, 198028},
	{"SUNITA", 6, 174341},
	{"SUNIL", 5, 81890},
	{"SUNHELP", 7, 132901},
	{"SUNGMIN", 7, 212877},
	{"SUNGLASSES", 10, 10094},
	{"SUNGLASS", 8, 72631},
	{"SUNGEI", 6, 260178},
	{"SUNGARD", 7, 104484},
	{"SUNGALE", 7, 177006},
	{"SUNGAI", 6, 168260},
	{"SUNG", 4, 41561},
	{"SUNFLY", 6, 194917},
	{"SUNFLOWERS", 10, 72538},
	{"SUNFLOWER", 9, 47383},
	{"SUNFISH", 7, 105130},
	{"SUNFIRE", 7, 87906},
	{"SUNF", 4, 45207},
	{"SUNEX", 5, 241523},
	{"SUNET", 5, 139068},
	{"SUNDSVALL", 9, 197559},
	{"SUNDSTROM", 9, 192575},
	{"SUNDSTRAND", 10, 253266},
	{"SUNDRY", 6, 72033},
	{"SUNDRIES", 8, 73968},
	{"SUNDRIED", 8, 183568},
	{"SUNDRIE", 7, 165034},
	{"SUNDRIDGE", 9, 238580},
	{"SUNDRESS", 8, 173776},
	{"SUNDRE", 6, 247462},
	{"SUNDQUIST", 9, 200280},
	{"SUNDOWNERS", 10, 229922},
	{"SUNDOWNER", 9, 129706},
	{"SUNDOWN", 7, 79594},
	{"SUNDOG", 6, 235175},
	{"SUNDIN", 6, 136900},
	{"SUNDIALS", 8, 107066},
	{"SUNDIAL", 7, 84465},
	{"SUNDEW", 6, 225672},
	{"SUNDEVILS", 9, 218802},
	{"SUNDERLAND", 10, 47402},
	{"SUNDERED", 8, 217694},
	{"SUNDER", 6, 145994},
	{"SUNDECK", 7, 132332},
	{"SUNDE", 5, 248445},
	{"SUNDBERG", 8, 148260},
	{"SUNDAZED", 8, 209950},
	{"SUNDAYS", 7, 42981},
	{"SUNDAY", 6, 1862},
	{"SUNDARI", 7, 213134},
	{"SUNDARESAN", 10, 243265},
	{"SUNDARAM", 8, 125546},
	{"SUNDAR", 6, 146435},
	{"SUNDANESE", 9, 205767},
	{"SUNDANCER", 9, 169374},
	{"SUNDANCE", 8, 41170},
	{"SUNDAES", 7, 181074},
	{"SUNDAE", 6, 99288},
	{"SUNDA", 5, 171710},
	{"SUND", 4, 167210},
	{"SUNCREST", 8, 225238},
	{"SUNCORP", 7, 174007},
	{"SUNCOR", 6, 178279},
	{"SUNCOOK", 7, 217205},
	{"SUNCOM", 6, 119009},
	{"SUNCOAST", 8, 97886},
	{"SUNCATCHERS", 11, 135078},
	{"SUNCATCHER", 10, 130775},
	{"SUNCAST", 7, 236031},
	{"SUNCARE", 7, 126698},
	{"SUNC", 4, 34760},
	{"SUNBURY", 7, 81324},
	{"SUNBURSTS", 9, 243195},
	{"SUNBURST", 8, 71250},
	{"SUNBURNT", 8, 192049},
	{"SUNBURNS", 8, 215361},
	{"SUNBURNED", 9, 148028},
	{"SUNBURN", 7, 82222},
	{"SUNBUCKLE", 9, 193434},
	{"SUNBRIDGE", 9, 131687},
	{"SUNBRELLA", 9, 117547},
	{"SUNBLOCK", 8, 99154},
	{"SUNBIRD", 7, 95862},
	{"SUNBELT", 7, 86886},
	{"SUNBEDS", 7, 147959},
	{"SUNBED", 6, 144281},
	{"SUNBEAMS", 8, 189913},
	{"SUNBEAM", 7, 60672},
	{"SUNBATHING", 10, 83209},
	{"SUNBATHERS", 10, 261466},
	{"SUNBATHE", 8, 208058},
	{"SUNB", 4, 52162},
	{"SUNAPEE", 7, 128378},
	{"SUNALLIANCE", 11, 216108},
	{"SUN", 3, 3561},
	{"SUMYCIN", 7, 162009},
	{"SUMY", 4, 191463},
	{"SUMW", 4, 137091},
	{"SUMVISION", 9, 190025},
	{"SUMUS", 5, 260284},
	{"SUMU", 4, 110432},
	{"SUMTHING", 8, 197039},
	{"SUMTHIN", 7, 161109},
	{"SUMTER", 6, 65268},
	{"SUMT", 4, 91922},
	{"SUMS", 4, 42441},
	{"SUMRALL", 7, 211355},
	{"SUMR", 4, 187316},
	{"SUMPTUOUSLY", 11, 212395},
	{"SUMPTUOUS", 9, 72463},
	{"SUMPTION", 8, 130454},
	{"SUMPTER", 7, 123433},
	{"SUMPS", 5, 177331},
	{"SUMP", 4, 72419},
	{"SUMO", 4, 59711},
	{"SUMNER", 6, 55236},
	{"SUMN", 4, 90889},
	{"SUMMONSES", 9, 175585},
	{"SUMMONS", 7, 55373},
	{"SUMMONING", 9, 94225},
	{"SUMMONER", 8, 120736},
	{"SUMMONED", 8, 61090},
	{"SUMMON", 6, 66424},
	{"SUMMITVILLE", 11, 205991},
	{"SUMMITT", 7, 159061},
	{"SUMMITS", 7, 72503},
	{"SUMMIT", 6, 28355},
	{"SUMMING", 7, 65016},
	{"SUMMICRON", 9, 260625},
	{"SUMMERY", 7, 142383},
	{"SUMMERVILLE", 11, 85652},
	{"SUMMERVACATION", 14, 148061},
	{"SUMMERTOWN", 10, 189626},
	{"SUMMERTON", 9, 214082},
	{"SUMMERTIME", 10, 60254},
	{"SUMMERSVILLE", 12, 157694},
	{"SUMMERSLAM", 10, 204768},
	{"SUMMERSIDE", 10, 123288},
	{"SUMMERSET", 9, 259106},
	{"SUMMERS", 7, 42220},
	{"SUMMERLIN", 9, 102989},
	{"SUMMERLAND", 10, 94391},
	{"SUMMERHOUSES", 12, 183677},
	{"SUMMERHOUSE", 11, 151404},
	{"SUMMERHILL", 10, 131729},
	{"SUMMERFIELD", 11, 77724},
	{"SUMMERFEST", 10, 145916},
	{"SUMMERDALE", 10, 189246},
	{"SUMMERCLUB", 10, 217047},
	{"SUMMER", 6, 2021},
	{"SUMMED", 6, 59881},
	{"SUMME", 5, 159213},
	{"SUMMATIVE", 9, 96837},
	{"SUMMATIONS", 10, 163391},
	{"SUMMATION", 9, 67521},
	{"SUMMARYLAST", 11, 251986},
	{"SUMMARY", 7, 35104},
	{"SUMMARIZING", 11, 65813},
	{"SUMMARIZES", 10, 49058},
	{"SUMMARIZER", 10, 213538},
	{"SUMMARIZED", 10, 43337},
	{"SUMMARIZE", 9, 47028},
	{"SUMMARIZATION", 13, 107583},
	{"SUMMARISING", 11, 119969},
	{"SUMMARISES", 10, 86986},
	{"SUMMARISED", 10, 65997},
	{"SUMMARISE", 9, 84743},
	{"SUMMARILY", 9, 94087},
	{"SUMMARIES", 9, 36039},
	{"SUMMAR", 6, 218305},
	{"SUMMANDS", 8, 256540},
	{"SUMMAND", 7, 211299},
	{"SUMMA", 5, 77857},
	{"SUMM", 4, 125779},
	{"SUML", 4, 173065},
	{"SUMK", 4, 258902},
	{"SUMITOMO", 8, 90649},
	{"SUMIT", 5, 141606},
	{"SUMISION", 8, 210437},
	{"SUMISAS", 7, 186540},
	{"SUMISA", 6, 225956},
	{"SUMING", 6, 259177},
	{"SUMIKO", 6, 260651},
	{"SUMIDA", 6, 201342},
	{"SUMI", 4, 128603},
	{"SUMH", 4, 209687},
	{"SUMG", 4, 198356},
	{"SUMF", 4, 162537},
	{"SUMERSAULT", 10, 247061},
	{"SUMERS", 6, 196111},
	{"SUMERIANS", 9, 202707},
	{"SUMERIAN", 8, 113725},
	{"SUMER", 5, 102493},
	{"SUMEET", 6, 260807},
	{"SUMED", 5, 179950},
	{"SUMEA", 5, 184028},
	{"SUME", 4, 171381},
	{"SUMDEX", 6, 145330},
	{"SUMD", 4, 196005},
	{"SUMC", 4, 162701},
	{"SUMBUCKETERRORS", 15, 224398},
	{"SUMBRELLA", 9, 141473},
	{"SUMBER", 6, 258515},
	{"SUMBA", 5, 259932},
	{"SUMB", 4, 108567},
	{"SUMATRIPTAN", 11, 133811},
	{"SUMATRAN", 8, 161387},
	{"SUMATRA", 7, 70628},
	{"SUMATERA", 8, 187439},
	{"SUMAS", 5, 160233},
	{"SUMAN", 5, 129938},
	{"SUMAC", 5, 122219},
	{"SUMA", 4, 100119},
	{"SUM", 3, 31261},
	{"SULZER", 6, 133732},
	{"SULZBERGER", 10, 177366},
	{"SULZ", 4, 193175},
	{"SULW", 4, 221026},
	{"SULU", 4, 121570},
	{"SULTS", 5, 114839},
	{"SULTRY", 6, 81501},
	{"SULTING", 7, 195967},
	{"SULTANS", 7, 101747},
	{"SULTANATE", 9, 120854},
	{"SULTANAS", 8, 237782},
	{"SULTANAHMET", 11, 150938},
	{"SULTANA", 7, 129779},
	{"SULTAN", 6, 52601},
	{"SULT", 4, 142217},
	{"SULS", 4, 115406},
	{"SULR", 4, 181463},
	{"SULPICE", 7, 206769},
	{"SULPHURIC", 9, 131348},
	{"SULPHUR", 7, 49636},
	{"SULPHITE", 8, 216981},
	{"SULPHIDES", 9, 210463},
	{"SULPHIDE", 8, 109406},
	{"SULPHATES", 9, 244002},
	{"SULPHATE", 8, 71571},
	{"SULPH", 5, 223666},
	{"SULP", 4, 88527},
	{"SULM", 4, 207004},
	{"SULLY", 5, 83257},
	{"SULLUM", 6, 232939},
	{"SULLIVANS", 9, 167953},
	{"SULLIVAN", 8, 31574},
	{"SULLIED", 7, 201818},
	{"SULLENLY", 8, 220553},
	{"SULLEN", 6, 105960},
	{"SULLE", 5, 140965},
	{"SULLA", 5, 76110},
	{"SULL", 4, 144963},
	{"SULKY", 5, 130116},
	{"SULKING", 7, 185989},
	{"SULK", 4, 166805},
	{"SULINDAC", 8, 208992},
	{"SULIK", 5, 254293},
	{"SULG", 4, 174245},
	{"SULFURIC", 8, 89863},
	{"SULFUR", 6, 44086},
	{"SULFOXIDE", 9, 141500},
	{"SULFOTRANSFERASE", 16, 223595},
	{"SULFONYLUREAS", 13, 257989},
	{"SULFONYLUREA", 12, 182682},
	{"SULFONYL", 8, 199972},
	{"SULFONIC", 8, 155458},
	{"SULFONE", 7, 219903},
	{"SULFONATE", 9, 161344},
	{"SULFONAMIDES", 12, 166178},
	{"SULFONAMIDE", 11, 216001},
	{"SULFOLOBUS", 10, 143122},
	{"SULFITES", 8, 190364},
	{"SULFITE", 7, 135642},
	{"SULFIDES", 8, 135214},
	{"SULFIDE", 7, 71459},
	{"SULFHYDRYL", 10, 153486},
	{"SULFATES", 8, 124767},
	{"SULFATED", 8, 204739},
	{"SULFATE", 7, 44444},
	{"SULFASALAZINE", 13, 192692},
	{"SULFAMETHOXAZOLE", 16, 144430},
	{"SULFADIAZINE", 12, 231984},
	{"SULFA", 5, 174234},
	{"SULEYMAN", 8, 202159},
	{"SULEMAN", 7, 240041},
	{"SULEKHA", 7, 171357},
	{"SULEIMAN", 8, 135476},
	{"SULCUS", 6, 145938},
	{"SULC", 4, 184097},
	{"SULB", 4, 209688},
	{"SULAYMAN", 8, 254541},
	{"SULAWESI", 8, 96462},
	{"SULAIMAN", 8, 175595},
	{"SULA", 4, 107118},
	{"SUKUMAR", 7, 247942},
	{"SUKT", 4, 241598},
	{"SUKS", 4, 225553},
	{"SUKR", 4, 132056},
	{"SUKO", 4, 122065},
	{"SUKKOT", 6, 134073},
	{"SUKKAH", 6, 194623},
	{"SUKK", 4, 170707},
	{"SUKI", 4, 101403},
	{"SUKHUMVIT", 9, 96446},
	{"SUKHOTHAI", 9, 130381},
	{"SUKHOI", 6, 175056},
	{"SUKHDEEP", 8, 233485},
	{"SUKE", 4, 63614},
	{"SUKARNO", 7, 206574},
	{"SUKANTA", 7, 214677},
	{"SUKA", 4, 201875},
	{"SUJETS", 6, 139342},
	{"SUJET", 5, 91028},
	{"SUJATHA", 7, 261870},
	{"SUJATA", 6, 197704},
	{"SUJA", 4, 190491},
	{"SUJ", 3, 30623},
	{"SUIZA", 5, 144536},
	{"SUIW", 4, 211453},
	{"SUIVRE", 6, 173116},
	{"SUIVI", 5, 140487},
	{"SUIVANTS", 8, 164363},
	{"SUIVANTES", 9, 142305},
	{"SUIVANTE", 8, 111381},
	{"SUIVANT", 7, 95345},
	{"SUITWATCH", 9, 227552},
	{"SUITT", 5, 250741},
	{"SUITS", 5, 30997},
	{"SUITORS", 7, 114888},
	{"SUITOR", 6, 118910},
	{"SUITLAND", 8, 169800},
	{"SUITING", 7, 140651},
	{"SUITES", 6, 4656},
	{"SUITER", 6, 129430},
	{"SUITEMEDIA", 10, 177407},
	{"SUITED", 6, 35259},
	{"SUITE", 5, 35066},
	{"SUITCASES", 9, 87263},
	{"SUITCASE", 8, 57092},
	{"SUITABLY", 8, 61135},
	{"SUITABLE", 8, 35133},
	{"SUITABILITY", 11, 45055},
	{"SUITA", 5, 250339},
	{"SUIT", 4, 4278},
	{"SUISUN", 6, 112139},
	{"SUISSE", 6, 55452},
	{"SUIR", 4, 248774},
	{"SUING", 5, 66571},
	{"SUIKODEN", 8, 109694},
	{"SUIKO", 5, 251679},
	{"SUIK", 4, 160338},
	{"SUIG", 4, 196157},
	{"SUIF", 4, 197703},
	{"SUIDPERL", 8, 260950},
	{"SUID", 4, 106333},
	{"SUICIDIO", 8, 223233},
	{"SUICIDES", 8, 67741},
	{"SUICIDEGIRL", 11, 171977},
	{"SUICIDE", 7, 7104},
	{"SUICIDALITY", 11, 211328},
	{"SUICIDAL", 8, 55506},
	{"SUIC", 4, 38506},
	{"SUHRKAMP", 8, 231468},
	{"SUHR", 4, 187808},
	{"SUHARTO", 7, 118989},
	{"SUHALI", 6, 156073},
	{"SUHAIL", 6, 243530},
	{"SUHAIB", 6, 244419},
	{"SUGU", 4, 138685},
	{"SUGR", 4, 192210},
	{"SUGOI", 5, 112070},
	{"SUGLI", 5, 241501},
	{"SUGL", 4, 100903},
	{"SUGIYAMA", 8, 127947},
	{"SUGIURA", 7, 201686},
	{"SUGITA", 6, 247367},
	{"SUGIMOTO", 8, 148365},
	{"SUGIHARA", 8, 235270},
	{"SUGI", 4, 230074},
	{"SUGGS", 5, 127235},
	{"SUGGESTS", 8, 7724},
	{"SUGGESTIVELY", 12, 234051},
	{"SUGGESTIVE", 10, 64970},
	{"SUGGESTIONS", 11, 4023},
	{"SUGGESTION", 10, 8009},
	{"SUGGESTING", 10, 35011},
	{"SUGGESTED", 9, 4809},
	{"SUGGEST", 7, 1529},
	{"SUGGES", 6, 226693},
	{"SUGGERIMENTI", 12, 208767},
	{"SUGG", 4, 121138},
	{"SUGESTIONS", 10, 204447},
	{"SUGERENCIAS", 11, 144902},
	{"SUGER", 5, 200791},
	{"SUGE", 4, 188535},
	{"SUGDEN", 6, 125007},
	{"SUGD", 4, 230842},
	{"SUGAWARA", 8, 203011},
	{"SUGARY", 6, 107114},
	{"SUGARS", 6, 56272},
	{"SUGARPLUM", 9, 211576},
	{"SUGARMAN", 8, 150767},
	{"SUGARLOAF", 9, 97511},
	{"SUGARLESS", 9, 187656},
	{"SUGARLAND", 9, 89766},
	{"SUGARING", 8, 175705},
	{"SUGARHILL", 9, 206543},
	{"SUGARFREE", 9, 174515},
	{"SUGARFORGE", 10, 238433},
	{"SUGARED", 7, 162717},
	{"SUGARDVD", 8, 212572},
	{"SUGARCULT", 9, 136908},
	{"SUGARCUBES", 10, 227688},
	{"SUGARCRM", 8, 134639},
	{"SUGARCREEK", 10, 214193},
	{"SUGARCANE", 9, 85365},
	{"SUGARBUSH", 9, 147139},
	{"SUGARBEET", 9, 223869},
	{"SUGAR", 5, 4695},
	{"SUGANO", 6, 184662},
	{"SUGABABES", 9, 41385},
	{"SUGA", 4, 127099},
	{"SUFR", 4, 173629},
	{"SUFO", 4, 126943},
	{"SUFJAN", 6, 91639},
	{"SUFISM", 6, 108117},
	{"SUFIS", 5, 185711},
	{"SUFIACORP", 9, 115435},
	{"SUFI", 4, 85551},
	{"SUFFUSED", 8, 166513},
	{"SUFFRAGETTE", 11, 187821},
	{"SUFFRAGE", 8, 71850},
	{"SUFFOLK", 7, 37310},
	{"SUFFOCATION", 11, 103574},
	{"SUFFOCATING", 11, 119447},
	{"SUFFOCATED", 10, 145794},
	{"SUFFOCATE", 9, 136307},
	{"SUFFIXES", 8, 82603},
	{"SUFFIXED", 8, 229302},
	{"SUFFIX", 6, 46973},
	{"SUFFIELD", 8, 110319},
	{"SUFFICIENTLY", 12, 36489},
	{"SUFFICIENT", 10, 9891},
	{"SUFFICIENCY", 11, 54992},
	{"SUFFICES", 8, 86851},
	{"SUFFICENT", 9, 251892},
	{"SUFFICED", 8, 150643},
	{"SUFFICE", 7, 53010},
	{"SUFFI", 5, 142966},
	{"SUFFERS", 7, 45874},
	{"SUFFERN", 7, 131250},
	{"SUFFERINGS", 10, 74917},
	{"SUFFERING", 9, 31654},
	{"SUFFERETH", 9, 237631},
	{"SUFFERERS", 9, 63231},
	{"SUFFERER", 8, 99476},
	{"SUFFERED", 8, 30779},
	{"SUFFERANCE", 10, 239148},
	{"SUFFER", 6, 3379},
	{"SUFF", 4, 135957},
	{"SUFC", 4, 215868},
	{"SUFA", 4, 132840},
	{"SUEZ", 4, 79942},
	{"SUEY", 4, 117180},
	{"SUEXEC", 6, 167211},
	{"SUEX", 4, 256348},
	{"SUEW", 4, 50476},
	{"SUEV", 4, 159966},
	{"SUEUR", 5, 145955},
	{"SUEU", 4, 126642},
	{"SUETONIUS", 9, 208489},
	{"SUESSES", 7, 182120},
	{"SUESS", 5, 148710},
	{"SUERTE", 6, 154917},
	{"SUEP", 4, 83776},
	{"SUENOS", 6, 197397},
	{"SUENO", 5, 201861},
	{"SUEM", 4, 80494},
	{"SUELO", 5, 162118},
	{"SUEK", 4, 192347},
	{"SUEJ", 4, 161851},
	{"SUEHPROM", 8, 237593},
	{"SUEHIRO", 7, 257675},
	{"SUEG", 4, 123630},
	{"SUEF", 4, 61744},
	{"SUEDTIROL", 9, 129823},
	{"SUEDED", 6, 171983},
	{"SUEDE", 5, 39162},
	{"SUED", 4, 44854},
	{"SUECIA", 6, 216772},
	{"SUEC", 4, 73199},
	{"SUEB", 4, 65086},
	{"SUDUKO", 6, 194463},
	{"SUDSY", 5, 245024},
	{"SUDS", 4, 106048},
	{"SUDR", 4, 221511},
	{"SUDOKU", 6, 44793},
	{"SUDOKO", 6, 229554},
	{"SUDOERS", 7, 253957},
	{"SUDOCS", 6, 229666},
	{"SUDOC", 5, 140941},
	{"SUDO", 4, 70254},
	{"SUDLEY", 6, 241655},
	{"SUDINI", 6, 190659},
	{"SUDIE", 5, 252926},
	{"SUDHIR", 6, 116493},
	{"SUDHIAN", 7, 138780},
	{"SUDHAKAR", 8, 213778},
	{"SUDHA", 5, 172091},
	{"SUDH", 4, 152931},
	{"SUDEKI", 6, 204025},
	{"SUDEEP", 6, 222601},
	{"SUDE", 4, 102729},
	{"SUDDUTH", 7, 246252},
	{"SUDDENNESS", 10, 199127},
	{"SUDDENLY", 8, 2770},
	{"SUDDEN", 6, 9083},
	{"SUDD", 4, 33849},
	{"SUDBURY", 7, 50013},
	{"SUDB", 4, 66872},
	{"SUDARSHAN", 9, 166119},
	{"SUDANESE", 8, 54131},
	{"SUDAN", 5, 30409},
	{"SUDAMERICANA", 12, 161670},
	{"SUDAH", 5, 170845},
	{"SUDAFED", 7, 140779},
	{"SUDA", 4, 167214},
	{"SUCTIONING", 10, 211360},
	{"SUCTION", 7, 49411},
	{"SUCT", 4, 128091},
	{"SUCS", 4, 243326},
	{"SUCROSE", 7, 72422},
	{"SUCRE", 5, 76510},
	{"SUCRALOSE", 9, 165853},
	{"SUCRALFATE", 10, 213979},
	{"SUCR", 4, 130815},
	{"SUCL", 4, 143258},
	{"SUCKY", 5, 116733},
	{"SUCKS", 5, 31349},
	{"SUCKO", 5, 228359},
	{"SUCKLING", 8, 108231},
	{"SUCKLER", 7, 245713},
	{"SUCKLED", 7, 241441},
	{"SUCKLE", 6, 180055},
	{"SUCKING", 7, 28443},
	{"SUCKIN", 6, 148748},
	{"SUCKERS", 7, 61993},
	{"SUCKERED", 8, 166742},
	{"SUCKER", 6, 53356},
	{"SUCKED", 6, 45175},
	{"SUCKA", 5, 137412},
	{"SUCK", 4, 29908},
	{"SUCI", 4, 200742},
	{"SUCHTEN", 7, 244463},
	{"SUCHT", 5, 83761},
	{"SUCHMASCHINEN", 13, 208907},
	{"SUCHMASCHINE", 12, 106971},
	{"SUCHLIKE", 8, 216423},
	{"SUCHET", 6, 224847},
	{"SUCHERGEBNISSE", 14, 161179},
	{"SUCHEN", 6, 54930},
	{"SUCHE", 5, 49597},
	{"SUCHBEGRIFFE", 12, 222829},
	{"SUCHBEGRIFF", 11, 197735},
	{"SUCHAS", 6, 193044},
	{"SUCHA", 5, 210659},
	{"SUCH", 4, 1024},
	{"SUCEUSE", 7, 140146},
	{"SUCESSFULLY", 11, 153571},
	{"SUCESSFUL", 9, 135894},
	{"SUCESS", 6, 123003},
	{"SUCEAVA", 7, 242079},
	{"SUCCULENTS", 10, 123991},
	{"SUCCULENT", 9, 81152},
	{"SUCCUBUS", 8, 167172},
	{"SUCCOUR", 7, 176222},
	{"SUCCOR", 6, 170777},
	{"SUCCINYLCHOLINE", 15, 248464},
	{"SUCCINYL", 8, 215575},
	{"SUCCINIC", 8, 189891},
	{"SUCCINCTLY", 10, 94435},
	{"SUCCINCT", 8, 83706},
	{"SUCCINATE", 9, 107384},
	{"SUCCHIA", 7, 133810},
	{"SUCCHI", 6, 194930},
	{"SUCCESSORS", 10, 55461},
	{"SUCCESSOR", 9, 41227},
	{"SUCCESSIVO", 10, 178689},
	{"SUCCESSIVELY", 12, 82929},
	{"SUCCESSIVE", 10, 43702},
	{"SUCCESSIVA", 10, 236059},
	{"SUCCESSIONS", 11, 188867},
	{"SUCCESSIONAL", 12, 131341},
	{"SUCCESSION", 10, 42438},
	{"SUCCESSFULY", 11, 261134},
	{"SUCCESSFULLY", 12, 28264},
	{"SUCCESSFULL", 11, 124106},
	{"SUCCESSFUL", 10, 3304},
	{"SUCCESSES", 9, 40109},
	{"SUCCESS", 7, 2425},
	{"SUCCESFULLY", 11, 125469},
	{"SUCCESFULL", 10, 217606},
	{"SUCCESFUL", 9, 101010},
	{"SUCCES", 6, 100074},
	{"SUCCEEDS", 8, 54757},
	{"SUCCEEDING", 10, 52147},
	{"SUCCEEDED", 9, 38920},
	{"SUCCEED", 7, 6305},
	{"SUCCEDED", 8, 246496},
	{"SUCCASUNNA", 10, 214494},
	{"SUCC", 4, 100352},
	{"SUCA", 4, 130005},
	{"SUBZONE", 7, 203742},
	{"SUBZERO", 7, 127006},
	{"SUBZ", 4, 150089},
	{"SUBWORD", 7, 246544},
	{"SUBWOOFERS", 10, 57945},
	{"SUBWOOFER", 9, 43159},
	{"SUBWAYS", 7, 83078},
	{"SUBWAY", 6, 39103},
	{"SUBWATERSHEDS", 13, 257560},
	{"SUBWATERSHED", 12, 184754},
	{"SUBVERTS", 8, 203517},
	{"SUBVERTING", 10, 140755},
	{"SUBVERTED", 9, 138662},
	{"SUBVERT", 7, 96830},
	{"SUBVERSIVES", 11, 226301},
	{"SUBVERSIVE", 10, 75859},
	{"SUBVERSIONS", 11, 193750},
	{"SUBVERSION", 10, 45633},
	{"SUBVENTIONS", 11, 190895},
	{"SUBVENTION", 10, 178150},
	{"SUBV", 4, 83343},
	{"SUBURBS", 7, 36925},
	{"SUBURBIA", 8, 76940},
	{"SUBURBANLODGE", 13, 186242},
	{"SUBURBANIZATION", 15, 248253},
	{"SUBURBANITES", 12, 198504},
	{"SUBURBAN", 8, 29585},
	{"SUBURB", 6, 29859},
	{"SUBUNITS", 8, 63638},
	{"SUBUNIT", 7, 40402},
	{"SUBU", 4, 37333},
	{"SUBTYPING", 9, 131797},
	{"SUBTYPES", 8, 77355},
	{"SUBTYPE", 7, 58197},
	{"SUBTTL", 6, 132993},
	{"SUBTROPICS", 10, 220708},
	{"SUBTROPICAL", 11, 79852},
	{"SUBTREES", 8, 127097},
	{"SUBTREE", 7, 82556},
	{"SUBTRACTS", 9, 152299},
	{"SUBTRACTIVE", 11, 150294},
	{"SUBTRACTIONS", 12, 189128},
	{"SUBTRACTION", 11, 60619},
	{"SUBTRACTING", 11, 72862},
	{"SUBTRACTED", 10, 70426},
	{"SUBTRACT", 8, 53313},
	{"SUBTOTALS", 9, 136880},
	{"SUBTOTAL", 8, 39205},
	{"SUBTOPICS", 9, 114347},
	{"SUBTOPIC", 8, 120359},
	{"SUBTLY", 6, 73415},
	{"SUBTLETY", 8, 85621},
	{"SUBTLETIES", 10, 100096},
	{"SUBTLEST", 8, 253843},
	{"SUBTLER", 7, 152565},
	{"SUBTLE", 6, 29614},
	{"SUBTITULOS", 10, 146383},
	{"SUBTITRARI", 10, 135191},
	{"SUBTITLING", 10, 140676},
	{"SUBTITLES", 9, 43282},
	{"SUBTITLED", 9, 63659},
	{"SUBTITLE", 8, 42743},
	{"SUBTILISIN", 10, 215168},
	{"SUBTILIS", 8, 80401},
	{"SUBTIL", 6, 252777},
	{"SUBTIDAL", 8, 174112},
	{"SUBTHRESHOLD", 12, 215322},
	{"SUBTHREAD", 9, 242552},
	{"SUBTEXT", 7, 111360},
	{"SUBTESTS", 8, 158814},
	{"SUBTEST", 7, 157872},
	{"SUBTERRANEAN", 12, 77292},
	{"SUBTERRANEA", 11, 259238},
	{"SUBTERM", 7, 228209},
	{"SUBTERFUGE", 10, 132484},
	{"SUBTENDED", 9, 231664},
	{"SUBTENANT", 9, 196592},
	{"SUBTASKS", 8, 155705},
	{"SUBTASK", 7, 131086},
	{"SUBTAG", 6, 223462},
	{"SUBTAB", 6, 238361},
	{"SUBSYSTEMS", 10, 60685},
	{"SUBSYSTEM", 9, 43993},
	{"SUBSYS", 6, 210591},
	{"SUBSURFACE", 10, 60000},
	{"SUBSUMPTION", 11, 151904},
	{"SUBSUMES", 8, 173223},
	{"SUBSUMED", 8, 109018},
	{"SUBSUME", 7, 194998},
	{"SUBSUBSECTION", 13, 143555},
	{"SUBSTRUCTURES", 13, 172291},
	{"SUBSTRUCTURE", 12, 107008},
	{"SUBSTRINGS", 10, 146310},
	{"SUBSTRING", 9, 67161},
	{"SUBSTRATUM", 10, 143564},
	{"SUBSTRATES", 10, 51239},
	{"SUBSTRATE", 9, 38107},
	{"SUBSTRATA", 9, 210759},
	{"SUBSTR", 6, 73056},
	{"SUBSTORM", 8, 209135},
	{"SUBSTORES", 9, 245225},
	{"SUBSTITUTIONS", 13, 53226},
	{"SUBSTITUTIONAL", 14, 248388},
	{"SUBSTITUTION", 12, 38782},
	{"SUBSTITUTING", 12, 56525},
	{"SUBSTITUTES", 11, 50569},
	{"SUBSTITUTED", 11, 42422},
	{"SUBSTITUTE", 10, 28435},
	{"SUBSTITUTABLE", 13, 205179},
	{"SUBSTITUTABILITY", 16, 172533},
	{"SUBSTITUENTS", 12, 149224},
	{"SUBSTITUENT", 11, 156809},
	{"SUBSTITUE", 9, 250192},
	{"SUBSTI", 6, 231709},
	{"SUBSTATIONS", 11, 115814},
	{"SUBSTATION", 10, 76508},
	{"SUBSTATE", 8, 188946},
	{"SUBSTANTIVELY", 13, 121649},
	{"SUBSTANTIVE", 11, 42773},
	{"SUBSTANTIATION", 14, 116785},
	{"SUBSTANTIATING", 14, 165000},
	{"SUBSTANTIATES", 13, 200313},
	{"SUBSTANTIATED", 13, 77591},
	{"SUBSTANTIATE", 12, 80667},
	{"SUBSTANTIALLY", 13, 34997},
	{"SUBSTANTIALITY", 14, 252338},
	{"SUBSTANTIAL", 11, 7891},
	{"SUBSTANTIA", 10, 145105},
	{"SUBSTANDARD", 11, 78553},
	{"SUBSTANCES", 10, 7215},
	{"SUBSTANCE", 9, 6800},
	{"SUBSTAN", 7, 157959},
	{"SUBST", 5, 89736},
	{"SUBSPECIES", 10, 78166},
	{"SUBSPECIALTY", 12, 116778},
	{"SUBSPECIALTIES", 14, 184671},
	{"SUBSPACES", 9, 113469},
	{"SUBSPACE", 8, 70565},
	{"SUBSP", 5, 75651},
	{"SUBSONIC", 8, 129757},
	{"SUBSOIL", 7, 120806},
	{"SUBSITES", 8, 187548},
	{"SUBSITE", 7, 158597},
	{"SUBSISTS", 8, 180036},
	{"SUBSISTING", 10, 141761},
	{"SUBSISTENCE", 11, 52759},
	{"SUBSISTED", 9, 231273},
	{"SUBSIST", 7, 132251},
	{"SUBSILVER", 9, 174942},
	{"SUBSIDY", 7, 32960},
	{"SUBSIDIZING", 11, 106299},
	{"SUBSIDIZES", 10, 184063},
	{"SUBSIDIZED", 10, 56438},
	{"SUBSIDIZE", 9, 84451},
	{"SUBSIDIZATION", 13, 149765},
	{"SUBSIDISING", 11, 177687},
	{"SUBSIDISED", 10, 86293},
	{"SUBSIDISE", 9, 140748},
	{"SUBSIDISATION", 13, 220018},
	{"SUBSIDING", 9, 159336},
	{"SUBSIDIES", 9, 39999},
	{"SUBSIDIARY", 10, 32165},
	{"SUBSIDIARITY", 12, 124574},
	{"SUBSIDIARIES", 12, 36218},
	{"SUBSIDES", 8, 135173},
	{"SUBSIDENCE", 10, 89076},
	{"SUBSIDED", 8, 92573},
	{"SUBSIDE", 7, 102107},
	{"SUBSHELL", 8, 203758},
	{"SUBSEVEN", 8, 139392},
	{"SUBSETTING", 10, 219595},
	{"SUBSETS", 7, 53129},
	{"SUBSET", 6, 37968},
	{"SUBSERVIENT", 11, 111377},
	{"SUBSERVIENCE", 12, 189766},
	{"SUBSERIES", 9, 119420},
	{"SUBSEQUENTLY", 12, 32003},
	{"SUBSEQUENT", 10, 28200},
	{"SUBSEQUENCES", 12, 196582},
	{"SUBSEQUENCE", 11, 116743},
	{"SUBSECTORS", 10, 143287},
	{"SUBSECTOR", 9, 87178},
	{"SUBSECTIONS", 11, 50786},
	{"SUBSECTION", 10, 7483},
	{"SUBSECS", 7, 234367},
	{"SUBSEC", 6, 78626},
	{"SUBSEA", 6, 103896},
	{"SUBSE", 5, 146957},
	{"SUBSCRIPTS", 10, 96585},
	{"SUBSCRIPTOR", 11, 117466},
	{"SUBSCRIPTIONSSITES", 18, 178115},
	{"SUBSCRIPTIONS", 13, 6324},
	{"SUBSCRIPTION", 12, 4556},
	{"SUBSCRIPTBOX", 12, 189924},
	{"SUBSCRIPT", 9, 78548},
	{"SUBSCRIBTION", 12, 219680},
	{"SUBSCRIBING", 11, 46420},
	{"SUBSCRIBES", 10, 83404},
	{"SUBSCRIBERS", 11, 28225},
	{"SUBSCRIBER", 10, 9725},
	{"SUBSCRIBED", 10, 42635},
	{"SUBSCRIBE", 9, 1608},
	{"SUBSCALES", 9, 160957},
	{"SUBSCALE", 8, 154756},
	{"SUBSAMPLING", 11, 209218},
	{"SUBSAMPLES", 10, 169889},
	{"SUBSAMPLE", 9, 135142},
	{"SUBSAHARAN", 10, 164843},
	{"SUBS", 4, 45823},
	{"SUBRULE", 7, 159303},
	{"SUBROUTINES", 11, 78165},
	{"SUBROUTINE", 10, 50523},
	{"SUBROGATION", 11, 113259},
	{"SUBRIP", 6, 204195},
	{"SUBREGULATION", 13, 143285},
	{"SUBREGIONS", 10, 153578},
	{"SUBREGIONAL", 11, 108618},
	{"SUBREGION", 9, 108189},
	{"SUBREG", 6, 241742},
	{"SUBRECIPIENTS", 13, 212359},
	{"SUBRECIPIENT", 12, 182556},
	{"SUBRAMANIAN", 11, 120205},
	{"SUBRAMANIAM", 11, 162403},
	{"SUBRAHMANYAM", 12, 205507},
	{"SUBR", 4, 244885},
	{"SUBQUERY", 8, 151991},
	{"SUBQUERIES", 10, 169027},
	{"SUBPROJECTS", 11, 133452},
	{"SUBPROJECT", 10, 118748},
	{"SUBPROGRAMS", 11, 141405},
	{"SUBPROGRAMME", 12, 258231},
	{"SUBPROGRAM", 10, 117853},
	{"SUBPROCESSES", 12, 211586},
	{"SUBPROCESS", 10, 141023},
	{"SUBPROBLEMS", 11, 179943},
	{"SUBPROBLEM", 10, 191298},
	{"SUBPRIME", 8, 95912},
	{"SUBPOPULATIONS", 14, 114687},
	{"SUBPOPULATION", 13, 136805},
	{"SUBPOENAS", 9, 73664},
	{"SUBPOENAED", 10, 114814},
	{"SUBPOENA", 8, 54908},
	{"SUBPLOTS", 8, 145516},
	{"SUBPLOT", 7, 111523},
	{"SUBPIXEL", 8, 237204},
	{"SUBPHYLUM", 9, 156850},
	{"SUBPARTS", 8, 128441},
	{"SUBPART", 7, 44535},
	{"SUBPARAGRAPHS", 13, 99745},
	{"SUBPARAGRAPH", 12, 51360},
	{"SUBPAR", 6, 144920},
	{"SUBPANEL", 8, 260997},
	{"SUBPAGES", 8, 140604},
	{"SUBPAGE", 7, 164855},
	{"SUBPACKAGES", 11, 179507},
	{"SUBPACKAGE", 10, 105118},
	{"SUBP", 4, 136364},
	{"SUBOXONE", 8, 238320},
	{"SUBORDINATION", 13, 91811},
	{"SUBORDINATING", 13, 219890},
	{"SUBORDINATES", 12, 80523},
	{"SUBORDINATED", 12, 71054},
	{"SUBORDINATE", 11, 50364},
	{"SUBORDER", 8, 125645},
	{"SUBORBITAL", 10, 193685},
	{"SUBOPTION", 9, 253067},
	{"SUBOPTIMAL", 10, 110797},
	{"SUBOBJECT", 9, 203082},
	{"SUBO", 4, 56761},
	{"SUBNORMAL", 9, 207978},
	{"SUBNETWORKS", 11, 203173},
	{"SUBNETWORK", 10, 127304},
	{"SUBNETTING", 10, 183932},
	{"SUBNETS", 7, 96008},
	{"SUBNET", 6, 55485},
	{"SUBNATIONAL", 11, 127219},
	{"SUBN", 4, 148387},
	{"SUBMUCOSAL", 10, 244321},
	{"SUBMODULES", 10, 235586},
	{"SUBMODULE", 9, 158331},
	{"SUBMODELS", 9, 177881},
	{"SUBMODEL", 8, 185040},
	{"SUBMODE", 7, 190332},
	{"SUBMITTING", 10, 32324},
	{"SUBMITTERS", 10, 96095},
	{"SUBMITTER", 9, 53103},
	{"SUBMITTED", 9, 2569},
	{"SUBMITTALS", 10, 97736},
	{"SUBMITTAL", 9, 61899},
	{"SUBMITS", 7, 50827},
	{"SUBMITED", 8, 117160},
	{"SUBMIT", 6, 28465},
	{"SUBMISSIVES", 11, 216229},
	{"SUBMISSIVE", 10, 66059},
	{"SUBMISSIONS", 11, 28130},
	{"SUBMISSION", 10, 5484},
	{"SUBMINIATURE", 12, 162770},
	{"SUBMILLIMETER", 13, 178804},
	{"SUBMICRON", 9, 145342},
	{"SUBMERSION", 10, 174487},
	{"SUBMERSIBLES", 12, 229487},
	{"SUBMERSIBLE", 11, 73466},
	{"SUBMERSED", 9, 203910},
	{"SUBMERGING", 10, 209735},
	{"SUBMERGENCE", 11, 174197},
	{"SUBMERGED", 9, 60192},
	{"SUBMERGE", 8, 128620},
	{"SUBMENUS", 8, 152198},
	{"SUBMENU", 7, 73746},
	{"SUBMAXIMAL", 10, 241950},
	{"SUBMATRIX", 9, 193536},
	{"SUBMASTER", 9, 211699},
	{"SUBMARKET", 9, 245542},
	{"SUBMARINES", 10, 62671},
	{"SUBMARINERS", 11, 220229},
	{"SUBMARINER", 10, 100165},
	{"SUBMARINE", 9, 43546},
	{"SUBMANIFOLDS", 12, 227601},
	{"SUBMANIFOLD", 11, 183704},
	{"SUBMANDIBULAR", 13, 185634},
	{"SUBMACHINE", 10, 143338},
	{"SUBM", 4, 218487},
	{"SUBLUXATION", 11, 144743},
	{"SUBLLME", 7, 237524},
	{"SUBLIST", 7, 169065},
	{"SUBLINGUAL", 10, 106263},
	{"SUBLINE", 7, 190866},
	{"SUBLIMITY", 9, 152244},
	{"SUBLIMINALLY", 12, 250209},
	{"SUBLIMINAL", 10, 65842},
	{"SUBLIMELY", 9, 218796},
	{"SUBLIMEDIRECTORYCOM", 19, 237456},
	{"SUBLIMEDIRECTORY", 16, 31930},
	{"SUBLIME", 7, 7831},
	{"SUBLIMATION", 11, 79715},
	{"SUBLIMATED", 10, 182813},
	{"SUBLIM", 6, 176106},
	{"SUBLICENSEES", 12, 183560},
	{"SUBLICENSED", 11, 175892},
	{"SUBLICENSE", 10, 113323},
	{"SUBLEVEL", 8, 218525},
	{"SUBLETTING", 10, 207465},
	{"SUBLETTE", 8, 143157},
	{"SUBLETS", 7, 79347},
	{"SUBLETHAL", 9, 195391},
	{"SUBLET", 6, 84931},
	{"SUBLESSEE", 9, 235753},
	{"SUBLEASES", 9, 146973},
	{"SUBLEASE", 8, 98154},
	{"SUBLAYER", 8, 159524},
	{"SUBLATTICE", 10, 251897},
	{"SUBKINGDOM", 10, 254978},
	{"SUBKEYS", 7, 180120},
	{"SUBKEY", 6, 141659},
	{"SUBJURISDICTION", 15, 216792},
	{"SUBJUNCTIVE", 11, 136602},
	{"SUBJUGATION", 11, 127512},
	{"SUBJUGATED", 10, 152697},
	{"SUBJUGATE", 9, 179324},
	{"SUBJOINED", 9, 262098},
	{"SUBJETIVA", 9, 182148},
	{"SUBJEKTIVE", 10, 222240},
	{"SUBJECTS", 8, 2646},
	{"SUBJECTIVITY", 12, 81355},
	{"SUBJECTIVISM", 12, 218987},
	{"SUBJECTIVELY", 12, 117730},
	{"SUBJECTIVE", 10, 36586},
	{"SUBJECTION", 10, 107854},
	{"SUBJECTING", 10, 94987},
	{"SUBJECTED", 9, 40199},
	{"SUBJECT", 7, 2050},
	{"SUBJ", 4, 58110},
	{"SUBITO", 6, 116717},
	{"SUBITEMS", 8, 224460},
	{"SUBITEM", 7, 154781},
	{"SUBIR", 5, 152751},
	{"SUBINTERFACES", 13, 167765},
	{"SUBINTERFACE", 12, 138204},
	{"SUBIIME", 7, 237604},
	{"SUBIF", 5, 244338},
	{"SUBIC", 5, 151436},
	{"SUBIACO", 7, 118425},
	{"SUBI", 4, 173012},
	{"SUBHUMANS", 9, 175818},
	{"SUBHUMAN", 8, 187576},
	{"SUBHEADINGS", 11, 123321},
	{"SUBHEADING", 10, 89270},
	{"SUBHEAD", 7, 136135},
	{"SUBHASH", 7, 132597},
	{"SUBHAS", 6, 252785},
	{"SUBHARMONIC", 11, 204836},
	{"SUBH", 4, 116242},
	{"SUBGROUPS", 9, 58987},
	{"SUBGROUP", 8, 50336},
	{"SUBGRID", 7, 223047},
	{"SUBGRAPHS", 9, 152525},
	{"SUBGRAPH", 8, 107049},
	{"SUBGRANTS", 9, 231219},
	{"SUBGRANTEES", 11, 251412},
	{"SUBGRANTEE", 10, 214860},
	{"SUBGRANT", 8, 210345},
	{"SUBGRADE", 8, 138333},
	{"SUBGOALS", 8, 186267},
	{"SUBGOAL", 7, 170741},
	{"SUBGLACIAL", 10, 239835},
	{"SUBGENUS", 8, 155701},
	{"SUBGENRES", 9, 229403},
	{"SUBGENRE", 8, 108150},
	{"SUBGENIUS", 9, 160849},
	{"SUBGAME", 7, 204259},
	{"SUBG", 4, 75498},
	{"SUBFRAME", 8, 159300},
	{"SUBFORUMS", 9, 124234},
	{"SUBFORUM", 8, 143283},
	{"SUBFORM", 7, 146533},
	{"SUBFOLDERS", 10, 114254},
	{"SUBFOLDER", 9, 135284},
	{"SUBFLOOR", 8, 171794},
	{"SUBFILE", 7, 194389},
	{"SUBFIELDS", 9, 123621},
	{"SUBFIELD", 8, 106029},
	{"SUBFAMILY", 9, 66183},
	{"SUBFAMILIES", 11, 132252},
	{"SUBF", 4, 102840},
	{"SUBEXPRESSIONS", 14, 215528},
	{"SUBEXPRESSION", 13, 188788},
	{"SUBER", 5, 174825},
	{"SUBENTRY", 8, 154702},
	{"SUBELEMENTS", 11, 219181},
	{"SUBE", 4, 257679},
	{"SUBDURAL", 8, 158746},
	{"SUBDUING", 8, 189786},
	{"SUBDUED", 7, 68304},
	{"SUBDUE", 6, 101002},
	{"SUBDUCTION", 10, 111780},
	{"SUBDREAMER", 10, 185085},
	{"SUBDOMAINS", 10, 79621},
	{"SUBDOMAIN", 9, 77892},
	{"SUBDIVISIONS", 12, 50800},
	{"SUBDIVISION", 11, 32757},
	{"SUBDIVIDING", 11, 175141},
	{"SUBDIVIDERS", 11, 194477},
	{"SUBDIVIDER", 10, 151196},
	{"SUBDIVIDED", 10, 71171},
	{"SUBDIVIDE", 9, 119113},
	{"SUBDIV", 6, 160217},
	{"SUBDISTRICT", 11, 148886},
	{"SUBDISCIPLINES", 14, 244899},
	{"SUBDISCIPLINE", 13, 191687},
	{"SUBDIRS", 7, 114848},
	{"SUBDIRECTORY", 12, 65947},
	{"SUBDIRECTORIES", 14, 71655},
	{"SUBDIR", 6, 86429},
	{"SUBDIALS", 8, 188499},
	{"SUBDIAL", 7, 225728},
	{"SUBD", 4, 72690},
	{"SUBCUTANEOUSLY", 14, 154887},
	{"SUBCUTANEOUS", 12, 76542},
	{"SUBCULTURES", 11, 125614},
	{"SUBCULTURE", 10, 93513},
	{"SUBCULTURAL", 11, 205074},
	{"SUBCRITICAL", 11, 182037},
	{"SUBCRIPTIONS", 12, 182474},
	{"SUBCRIBE", 8, 170508},
	{"SUBCORTICAL", 11, 160398},
	{"SUBCONTRACTS", 12, 87842},
	{"SUBCONTRACTORS", 14, 55555},
	{"SUBCONTRACTOR", 13, 54381},
	{"SUBCONTRACTING", 14, 76773},
	{"SUBCONTRACTED", 13, 122546},
	{"SUBCONTRACT", 11, 68216},
	{"SUBCONTINENT", 12, 84440},
	{"SUBCONSCIOUSLY", 14, 122483},
	{"SUBCONSCIOUS", 12, 68897},
	{"SUBCOMPONENTS", 13, 185222},
	{"SUBCOMPONENT", 12, 186438},
	{"SUBCOMPLEX", 10, 252379},
	{"SUBCOMPACT", 10, 201312},
	{"SUBCOMMITTEES", 13, 79861},
	{"SUBCOMMITTEE", 12, 31414},
	{"SUBCOMMENTS", 11, 204956},
	{"SUBCOMMANDS", 11, 190295},
	{"SUBCOMMAND", 10, 133417},
	{"SUBCOMANDANTE", 13, 241554},
	{"SUBCODE", 7, 188613},
	{"SUBCLUSTID", 10, 208790},
	{"SUBCLONED", 9, 207195},
	{"SUBCLIPSE", 9, 107754},
	{"SUBCLINICAL", 11, 136559},
	{"SUBCLAVIAN", 10, 170486},
	{"SUBCLAUSES", 10, 227553},
	{"SUBCLAUSE", 9, 85375},
	{"SUBCLASSOF", 10, 189210},
	{"SUBCLASSING", 11, 145128},
	{"SUBCLASSES", 10, 62902},
	{"SUBCLASSED", 10, 228832},
	{"SUBCLASS", 8, 45137},
	{"SUBCHRONIC", 10, 184966},
	{"SUBCHAPTERS", 11, 240612},
	{"SUBCHAPTER", 10, 51149},
	{"SUBCHANNEL", 10, 218992},
	{"SUBCELLULAR", 11, 80556},
	{"SUBCATEGORY", 11, 55030},
	{"SUBCATEGORIES", 13, 50006},
	{"SUBCAT", 6, 222456},
	{"SUBCARRIER", 10, 175005},
	{"SUBCARD", 7, 209097},
	{"SUBBUTEO", 8, 145606},
	{"SUBBING", 7, 193402},
	{"SUBBED", 6, 172977},
	{"SUBBASIN", 8, 105837},
	{"SUBBASE", 7, 199403},
	{"SUBBANDS", 8, 241249},
	{"SUBBAND", 7, 155324},
	{"SUBBA", 5, 236500},
	{"SUBB", 4, 100321},
	{"SUBATOMIC", 9, 131114},
	{"SUBASTAS", 8, 221294},
	{"SUBASSEMBLY", 11, 187009},
	{"SUBASSEMBLIES", 13, 157040},
	{"SUBARU", 6, 35816},
	{"SUBARRAY", 8, 233385},
	{"SUBAREAS", 8, 211055},
	{"SUBAREA", 7, 123490},
	{"SUBARCTIC", 9, 165170},
	{"SUBARACHNOID", 12, 126299},
	{"SUBANG", 6, 120557},
	{"SUBALTERN", 9, 188252},
	{"SUBALPINE", 9, 151814},
	{"SUBALGEBRA", 10, 157989},
	{"SUBAGENT", 8, 206175},
	{"SUBADDRESS", 10, 215234},
	{"SUBACUTE", 8, 106789},
	{"SUBACCOUNT", 10, 161248},
	{"S