# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
OPENSUSE_RELEASES += tumbleweed

.PHONY: all
all:: opensuse-cloud-tumbleweed.$(GARDEN_ARCH).qcow2 opensuse-cloud-tumbleweed.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/opensuse/openSUSE-Tumbleweed-Minimal-VM.$(GARDEN_ARCH)-Cloud.qcow2

$(GARDEN_DL_DIR)/opensuse/openSUSE-Tumbleweed-Minimal-VM.aarch64-Cloud.qcow2: | $(GARDEN_DL_DIR)/opensuse
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://download.opensuse.org/repositories/Virtualization:/Appliances:/Images:/openSUSE-Tumbleweed/openSUSE_Tumbleweed_ARM/openSUSE-Tumbleweed-Minimal-VM.aarch64-Cloud.qcow2)

$(GARDEN_DL_DIR)/opensuse/openSUSE-Tumbleweed-Minimal-VM.x86_64-Cloud.qcow2: | $(GARDEN_DL_DIR)/opensuse
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://download.opensuse.org/repositories/Virtualization:/Appliances:/Images:/openSUSE-Tumbleweed/openSUSE_Tumbleweed/openSUSE-Tumbleweed-Minimal-VM.x86_64-Cloud.qcow2)

$(GARDEN_DL_DIR)/opensuse/opensuse-cloud-tumbleweed.x86_64.qcow2: | $(GARDEN_DL_DIR)/opensuse/ $(GARDEN_DL_DIR)/opensuse/openSUSE-Tumbleweed-Minimal-VM.x86_64-Cloud.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/opensuse/opensuse-cloud-tumbleweed.aarch64.qcow2: | $(GARDEN_DL_DIR)/opensuse/ $(GARDEN_DL_DIR)/opensuse/openSUSE-Tumbleweed-Minimal-VM.aarch64-Cloud.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/opensuse/opensuse-cloud-tumbleweed.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/opensuse/openSUSE-Tumbleweed-Minimal-VM.*-Cloud.qcow2
