/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggwidgetkeylineedit.h"


#include "iimage.h"
#include "iimagefactory.h"

#include "iggframe.h"
#include "iggmainwindow.h"

#include "ibgwidgetbuttonsubject.h"

#include "iggsubjectfactory.h"

//
//  templates
//
#include "iarraytemplate.h"
#include "iggwidgetkeyhandlertemplate.h"
#include "iggwidgetkeylineedittemplate.h"


using namespace iParameter;


//
//******************************************
//
//  TextLineEdit class
//
//******************************************
//
iggWidgetKeyTextLineEdit::iggWidgetKeyTextLineEdit(bool readonly, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index, const iObjectKey *indkey) : iggWidgetKeyLineEdit<iString>(false,readonly,label,key,rm,parent,index,indkey)
{
}


void iggWidgetKeyTextLineEdit::ConvertToString(iString val, iString &s) const
{
	s = val;
}


bool iggWidgetKeyTextLineEdit::ConvertFromString(const iString &s, iString &val) const
{
	val = s;
	return true;
}


//
//******************************************
//
//  FloatLineEdit class
//
//******************************************
//
iggWidgetKeyFloatLineEdit::iggWidgetKeyFloatLineEdit(const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index, const iObjectKey *indkey) : iggWidgetKeyLineEdit<float>(true,false,label,key,rm,parent,index,indkey)
{
}


void iggWidgetKeyFloatLineEdit::ConvertToString(float val, iString &s) const
{
	s = iString::FromNumber(val);
}


bool iggWidgetKeyFloatLineEdit::ConvertFromString(const iString &s, float &val) const
{
	bool ok;
	val = s.ToFloat(ok);
	if(!ok) val = 0.0f;
	return ok;
}


//
//******************************************
//
//  GenericPositionLineEdit class
//
//******************************************
//
iggWidgetKeyGenericPositionLineEdit::iggWidgetKeyGenericPositionLineEdit(bool issize, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index, const iObjectKey *indkey) : iggWidgetKeyLineEdit<double>(true,false,label,key,rm,parent,index,indkey)
{
	mIsSize = issize;
	iggWidgetKeyHandlerBase::PositionList().AddUnique(this);
}


iggWidgetKeyGenericPositionLineEdit::~iggWidgetKeyGenericPositionLineEdit()
{
	iggWidgetKeyHandlerBase::PositionList().Remove(this);
}


void iggWidgetKeyGenericPositionLineEdit::ConvertToString(double val, iString &s) const
{
	iDistance d(this->GetShell()->GetControlModule()->GetViewModule(),mIsSize);
	d = val;
	s = iString::FromNumber(d.BoxDistance());
}


bool iggWidgetKeyGenericPositionLineEdit::ConvertFromString(const iString &s, double &val) const
{
	bool ok;
	val = s.ToDouble(ok);
	if(!ok) val = 0.0;

	iDistance d(this->GetShell()->GetControlModule()->GetViewModule(),mIsSize);
	d.SetBoxDistance(val);
	val = d;

	return ok;
}


//
//******************************************
//
//  PositionLineEdit class
//
//******************************************
//
iggWidgetKeyPositionLineEdit::iggWidgetKeyPositionLineEdit(const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index, const iObjectKey *indkey) : iggWidgetKeyGenericPositionLineEdit(false,label,key,rm,parent,index,indkey)
{
}


//
//******************************************
//
//  SizeLineEdit class
//
//******************************************
//
iggWidgetKeySizeLineEdit::iggWidgetKeySizeLineEdit(const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index, const iObjectKey *indkey) : iggWidgetKeyGenericPositionLineEdit(false,label,key,rm,parent,index,indkey)
{
}


//
//******************************************
//
//  FileNameLineEdit class
//
//******************************************
//
#include "icontrolmodule.h"

#include "iggwidgetotherbutton.h"

namespace iggWidgetKeyFileNameLineEdit_Private
{
	class OpenButton : public iggWidgetSimpleButton
	{

	public:

		OpenButton(iggWidgetKeyFileNameLineEdit *owner, iggFrame *parent) : iggWidgetSimpleButton("",parent,true)
		{
			mOwner = owner;
			mWasLaidOut = true;
			this->SetBaloonHelp("Open Load File Dialog");
		}

		ibgWidgetButtonSubject* GetSubject() const { return mSubject; }

	protected:

		virtual void Execute()
		{
			mOwner->OpenLoadFileDialog();
		}

		iggWidgetKeyFileNameLineEdit *mOwner;
	};

	class UnloadButton : public iggWidgetSimpleButton
	{

	public:

		UnloadButton(iggWidgetKeyFileNameLineEdit *owner, iggFrame *parent) : iggWidgetSimpleButton("",parent,true)
		{
			mOwner = owner;
			mWasLaidOut = true;
			this->SetBaloonHelp("Unload the file");
		}

		ibgWidgetButtonSubject* GetSubject() const { return mSubject; }

	protected:

		virtual void Execute()
		{
			mOwner->UnloadFile();
		}

		iggWidgetKeyFileNameLineEdit *mOwner;
	};
};


iggWidgetKeyFileNameLineEdit::iggWidgetKeyFileNameLineEdit(bool render, const iString &header, const iString &location, const iString &selection, bool exists, const iString &label, bool unloadable, const iObjectKey &key, iggFrame *parent, int index, const iObjectKey *indkey) : 	iggWidgetKeyTextLineEdit(true,label,key,RenderMode::NoRender,parent,index,indkey)
{
	mRender = render;
	mHeader = header;
	mLocation = location;
	mSelection = selection;
	mFileExists = exists;
	mUnloadable = unloadable;

	iggWidgetKeyFileNameLineEdit_Private::OpenButton *w1 = new iggWidgetKeyFileNameLineEdit_Private::OpenButton(this,parent); IERROR_ASSERT(w1);
	w1->GetSubject()->SetFlat(true);
	w1->GetSubject()->SetSize(18,18);
	w1->GetSubject()->SetIcon(*iImageFactory::FindIcon("fileopen2.png"));
	this->mSubject->AddButton(w1->GetSubject());

	iggWidgetKeyFileNameLineEdit_Private::UnloadButton *w2 = new iggWidgetKeyFileNameLineEdit_Private::UnloadButton(this,parent); IERROR_ASSERT(w2);
	w2->GetSubject()->SetFlat(true);
	w2->GetSubject()->SetSize(18,18);
	w2->GetSubject()->SetIcon(*iImageFactory::FindIcon(unloadable?"remove.png":"remove2.png"));
	this->mSubject->AddButton(w2->GetSubject());
	w2->Enable(unloadable);

}


void iggWidgetKeyFileNameLineEdit::OnVoid1Body()
{
	this->OpenLoadFileDialog();
}


void iggWidgetKeyFileNameLineEdit::UnloadFile()
{
	if(mUnloadable)
	{
		this->SetText("");
		this->iggWidgetKeyTextLineEdit::ExecuteControl(true);
		this->UpdateWidget();
		this->UpdateDependents();
		if(mRender) this->GetShell()->GetControlModule()->Render(iParameter::RenderOption::All);
	}
}


void iggWidgetKeyFileNameLineEdit::OpenLoadFileDialog()
{
	iString name = this->GetMainWindow()->GetFileName(mHeader,mSubject->GetText().IsEmpty()?mLocation:mSubject->GetText(),mSelection,mFileExists);
	if(!name.IsEmpty() || mUnloadable)
	{
		this->SetText(name);
		this->iggWidgetKeyTextLineEdit::ExecuteControl(true);
		this->UpdateWidget();
		this->UpdateDependents();
		if(mRender) this->GetShell()->GetControlModule()->Render(iParameter::RenderOption::All);
	}
}


void iggWidgetKeyFileNameLineEdit::UpdateWidgetBody()
{
	this->iggWidgetKeyTextLineEdit::UpdateWidgetBody();
	mSubject->ShowTail();
}

#endif
