/***************************************************************************
                          options.cpp  -  description
                             -------------------
    begin                : Tue Jan 8 2002
    copyright            : (C) 1999-2002 by Brian Ashe & Jacques Fortier
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <gtk/gtk.h>
#include "application.h"
#include "options.h"
#include "support.h"

/* Options Dialog -- Displays and adjusts game play options */

GtkWidget *open_opt_dlg(Application *app)
{
	GtkWidget *opt_dlg;
	GtkWidget *dialog_vbox1;
	GtkWidget *table1;
	GtkWidget *frame1;
	GtkWidget *table2;
	GtkWidget *label3;
	GtkWidget *label2;
	GtkWidget *label1;
	GtkWidget *hscale1;
	GtkWidget *hscale2;
	GtkWidget *hscale3;
	GtkWidget *frame3;
	GtkWidget *table3;
	GSList *table3_group = (GSList *) NULL;
	GtkWidget *radiobutton4;
	GtkWidget *radiobutton5;
	GtkWidget *radiobutton6;
	GtkWidget *radiobutton7;
	GtkWidget *pixmap4;
	GtkWidget *pixmap3;
	GtkWidget *pixmap2;
	GtkWidget *pixmap1;
	GtkWidget *frame5;
	GtkWidget *vbox1;
	GSList *vbox1_group = (GSList *) NULL;
	GtkWidget *radiobutton1;
	GtkWidget *radiobutton2;
	GtkWidget *radiobutton3;
	GtkWidget *frame6;
	GtkWidget *vbox2;
	GtkWidget *checkbutton1;
	GtkWidget *checkbutton2;
	GtkWidget *checkbutton3;
	GtkWidget *dialog_action_area1;
	GtkWidget *button1;

	// Add default directories to search for the icons
	add_pixmap_directory("/usr/local/share/gtkpool");
	add_pixmap_directory("/usr/share/gtkpool");
	
	// Set up Dialog
	opt_dlg = gtk_dialog_new ();
	gtk_object_set_data (GTK_OBJECT (opt_dlg), "opt_dlg", opt_dlg);
	gtk_window_set_title (GTK_WINDOW (opt_dlg), _("GTKPool Options"));
	GTK_WINDOW (opt_dlg)->type = GTK_WINDOW_DIALOG;
	gtk_window_set_position (GTK_WINDOW (opt_dlg), GTK_WIN_POS_CENTER);
	gtk_window_set_policy (GTK_WINDOW (opt_dlg), FALSE, TRUE, FALSE);
	gtk_widget_ref (opt_dlg);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "opt_dlg", opt_dlg,
	                          (GtkDestroyNotify) gtk_widget_hide);

	// Main Layout box
	dialog_vbox1 = GTK_DIALOG (opt_dlg)->vbox;
	gtk_object_set_data (GTK_OBJECT (opt_dlg), "dialog_vbox1", dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	// Split sideways for the different options
	table1 = gtk_table_new (1, 5, FALSE);
	gtk_widget_ref (table1);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "table1", table1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), table1, FALSE, FALSE, 0);

	// Set Physics
	frame1 = gtk_frame_new (_("Physics"));
	gtk_widget_ref (frame1);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "frame1", frame1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame1);
	gtk_table_attach (GTK_TABLE (table1), frame1, 0, 2, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
	
	table2 = gtk_table_new (3, 2, FALSE);
	gtk_widget_ref (table2);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "table2", table2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table2);
	gtk_container_add (GTK_CONTAINER (frame1), table2);
	
	// Labels for sliders
	label3 = gtk_label_new (_("Collision Drag"));
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "label3", label3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_table_attach (GTK_TABLE (table2), label3, 0, 1, 2, 3,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (0), 4, 0);
	gtk_misc_set_alignment (GTK_MISC (label3), 0, 0.5);

	label2 = gtk_label_new (_("Bumper Drag"));
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "label2", label2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_table_attach (GTK_TABLE (table2), label2, 0, 1, 1, 2,
                  (GtkAttachOptions) (GTK_FILL),
	              (GtkAttachOptions) (0), 4, 0);
	gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);
	
	label1 = gtk_label_new (_("Friction"));
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "label1", label1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_table_attach (GTK_TABLE (table2), label1, 0, 1, 0, 1,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (0), 4, 0);
	gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);
	
	// Friction Slider
	hscale1 = gtk_hscale_new (GTK_ADJUSTMENT(app->friction_adjustment));
	gtk_widget_ref (hscale1);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "hscale1", hscale1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_scale_set_digits (GTK_SCALE (hscale1), 2);
	gtk_widget_show (hscale1);
	gtk_table_attach (GTK_TABLE (table2), hscale1, 1, 2, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
	
	// Bumber Slider
	hscale2 = gtk_hscale_new (GTK_ADJUSTMENT(app->bumper_drag_adjustment));
	gtk_widget_ref (hscale2);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "hscale2", hscale2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_scale_set_digits (GTK_SCALE (hscale2), 2);
	gtk_widget_show (hscale2);
	gtk_table_attach (GTK_TABLE (table2), hscale2, 1, 2, 1, 2,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
	
	// Collision Slider
	hscale3 = gtk_hscale_new (GTK_ADJUSTMENT (app->collide_drag_adjustment));
	gtk_widget_ref (hscale3);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "hscale3", hscale3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_scale_set_digits (GTK_SCALE (hscale3), 2);
	gtk_widget_show (hscale3);
	gtk_table_attach (GTK_TABLE (table2), hscale3, 1, 2, 2, 3,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
	
	// Select Pool Table
	frame3 = gtk_frame_new (_("Table"));
	gtk_widget_ref (frame3);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "frame3", frame3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame3);
	gtk_table_attach (GTK_TABLE (table1), frame3, 3, 4, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	
	table3 = gtk_table_new (4, 2, FALSE);
	gtk_widget_ref (table3);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "table3", table3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table3);
	gtk_container_add (GTK_CONTAINER (frame3), table3);
	
	radiobutton4 = gtk_radio_button_new_with_label (table3_group, _("Black Pearl"));
	table3_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton4));
	gtk_widget_ref (radiobutton4);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "radiobutton4", radiobutton4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(radiobutton4), "toggled",
	                   GTK_SIGNAL_FUNC(bp_table_toggled_event), app);
	gtk_widget_show (radiobutton4);
	gtk_table_attach (GTK_TABLE (table3), radiobutton4, 1, 2, 3, 4,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	radiobutton5 = gtk_radio_button_new_with_label (table3_group, _("Black Laquer"));
	table3_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton5));
	gtk_widget_ref (radiobutton5);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "radiobutton5", radiobutton5,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(radiobutton5), "toggled",
	                   GTK_SIGNAL_FUNC(bl_table_toggled_event), app);
	gtk_widget_show (radiobutton5);
	gtk_table_attach (GTK_TABLE (table3), radiobutton5, 1, 2, 2, 3,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);
	
	radiobutton6 = gtk_radio_button_new_with_label (table3_group, _("Maple Burl"));
	table3_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton6));
	gtk_widget_ref (radiobutton6);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "radiobutton6", radiobutton6,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(radiobutton6), "toggled",
	                   GTK_SIGNAL_FUNC(mb_table_toggled_event), app);
	gtk_widget_show (radiobutton6);
	gtk_table_attach (GTK_TABLE (table3), radiobutton6, 1, 2, 1, 2,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	radiobutton7 = gtk_radio_button_new_with_label (table3_group, _("Mahogany"));
	table3_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton7));
	gtk_widget_ref (radiobutton7);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "radiobutton7", radiobutton7,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(radiobutton7), "toggled",
	                   GTK_SIGNAL_FUNC(ma_table_toggled_event), app);
	gtk_widget_show (radiobutton7);
	gtk_table_attach (GTK_TABLE (table3), radiobutton7, 1, 2, 0, 1,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton7), TRUE);
	
	pixmap4 = create_pixmap (opt_dlg, "blpl-icon.xpm");
	gtk_widget_ref (pixmap4);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "pixmap4", pixmap4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap4);
	gtk_table_attach (GTK_TABLE (table3), pixmap4, 0, 1, 3, 4,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 2);

	pixmap3 = create_pixmap (opt_dlg, "bllq-icon.xpm");
	gtk_widget_ref (pixmap3);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "pixmap3", pixmap3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap3);
	gtk_table_attach (GTK_TABLE (table3), pixmap3, 0, 1, 2, 3,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 2);

	pixmap2 = create_pixmap (opt_dlg, "mabl-icon.xpm");
	gtk_widget_ref (pixmap2);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "pixmap2", pixmap2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap2);
	gtk_table_attach (GTK_TABLE (table3), pixmap2, 0, 1, 1, 2,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 2);

	pixmap1 = create_pixmap (opt_dlg, "maho-icon.xpm");
	gtk_widget_ref (pixmap1);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "pixmap1", pixmap1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap1);
	gtk_table_attach (GTK_TABLE (table3), pixmap1, 0, 1, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 2);

	// Select Game Type
	frame5 = gtk_frame_new (_("Game"));
	gtk_widget_ref (frame5);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "frame5", frame5,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame5);
	gtk_table_attach (GTK_TABLE (table1), frame5, 2, 3, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "vbox1", vbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (frame5), vbox1);

	// 8-Ball Button
	radiobutton1 = gtk_radio_button_new_with_label (vbox1_group, _("8 - Ball"));
	vbox1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton1));
	gtk_widget_ref (radiobutton1);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "radiobutton1", radiobutton1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(radiobutton1), "toggled",
	                   GTK_SIGNAL_FUNC(eb_toggled_event), app);
	gtk_widget_show (radiobutton1);
	gtk_box_pack_start (GTK_BOX (vbox1), radiobutton1, TRUE, TRUE, 0);

	// 9-Ball Button
	radiobutton2 = gtk_radio_button_new_with_label (vbox1_group, _("9 - Ball"));
	vbox1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton2));
	gtk_widget_ref (radiobutton2);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "radiobutton2", radiobutton2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(radiobutton2), "toggled",
	                   GTK_SIGNAL_FUNC(nb_toggled_event), app);
	gtk_widget_show (radiobutton2);
	gtk_box_pack_start (GTK_BOX (vbox1), radiobutton2, TRUE, TRUE, 0);

	// Rotation Button
	radiobutton3 = gtk_radio_button_new_with_label (vbox1_group, _("Rotation"));
	vbox1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton3));
	gtk_widget_ref (radiobutton3);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "radiobutton3", radiobutton3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(radiobutton3), "toggled",
	                   GTK_SIGNAL_FUNC(ro_toggled_event), app);
	gtk_widget_show (radiobutton3);
	gtk_box_pack_start (GTK_BOX (vbox1), radiobutton3, TRUE, TRUE, 0);

	// No Rules Button
	radiobutton3 = gtk_radio_button_new_with_label (vbox1_group, _("No Rules"));
	vbox1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton3));
	gtk_widget_ref (radiobutton3);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "radiobutton3", radiobutton3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(radiobutton3), "toggled",
	                   GTK_SIGNAL_FUNC(nr_toggled_event), app);
	gtk_widget_show (radiobutton3);
	gtk_box_pack_start (GTK_BOX (vbox1), radiobutton3, TRUE, TRUE, 0);

	// Set Other Options
	frame6 = gtk_frame_new (_("Other"));
	gtk_widget_ref (frame6);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "frame6", frame6,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame6);
	gtk_table_attach (GTK_TABLE (table1), frame6, 4, 5, 0, 1,
	                  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "vbox2", vbox2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_container_add (GTK_CONTAINER (frame6), vbox2);

	// Sound Off
	checkbutton1 = gtk_check_button_new_with_label (_("No Sound"));
	gtk_widget_ref (checkbutton1);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "checkbutton1", checkbutton1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(checkbutton1), "toggled",
	                   GTK_SIGNAL_FUNC(sound_toggled_event), app);
	gtk_widget_show (checkbutton1);
	gtk_box_pack_start (GTK_BOX (vbox2), checkbutton1, TRUE, TRUE, 0);

	// Aiming Line Off
	checkbutton1 = gtk_check_button_new_with_label (_("No Aiming line"));
	gtk_widget_ref (checkbutton1);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "checkbutton1", checkbutton1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(checkbutton1), "toggled",
	                   GTK_SIGNAL_FUNC(aimline_toggled_event), app);
	gtk_widget_show (checkbutton1);
	gtk_box_pack_start (GTK_BOX (vbox2), checkbutton1, TRUE, TRUE, 0);

	// Superhuman Shots
	checkbutton2 = gtk_check_button_new_with_label (_("Superhuman Shots"));
	gtk_widget_ref (checkbutton2);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "checkbutton2", checkbutton2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(checkbutton2), "toggled",
	                   GTK_SIGNAL_FUNC(superhuman_toggled_event), app);
	gtk_widget_show (checkbutton2);
	gtk_box_pack_start (GTK_BOX (vbox2), checkbutton2, TRUE, TRUE, 0);

	// Moving Balls
	checkbutton3 = gtk_check_button_new_with_label (_("Can Hit Moving Balls"));
	gtk_widget_ref (checkbutton3);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "checkbutton3", checkbutton3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(checkbutton2), "toggled",
	                   GTK_SIGNAL_FUNC(moving_toggled_event), app);
	gtk_widget_show (checkbutton3);
	gtk_box_pack_start (GTK_BOX (vbox2), checkbutton3, TRUE, TRUE, 0);

	dialog_action_area1 = GTK_DIALOG (opt_dlg)->action_area;
	gtk_object_set_data (GTK_OBJECT (opt_dlg), "dialog_action_area1", dialog_action_area1);
	gtk_widget_show (dialog_action_area1);
	gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

	// Close Button
	button1 = gtk_button_new_with_label (_("Close"));
	gtk_widget_ref (button1);
	gtk_object_set_data_full (GTK_OBJECT (opt_dlg), "button1", button1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_signal_connect(GTK_OBJECT(button1), "clicked",
	                   GTK_SIGNAL_FUNC(od_close_event), opt_dlg);
	gtk_widget_show (button1);
	gtk_box_pack_start (GTK_BOX (dialog_action_area1), button1, TRUE, TRUE, 0);

	return opt_dlg;
}

// Close Window
void od_close_event(GtkWidget *widget, gpointer data)
{
	gtk_widget_hide(GTK_WIDGET(data));
}

// Toggle Sound
void sound_toggled_event(GtkWidget *widget, gpointer data)
{
	Application *app = (Application *)data;
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->sound = false;
	else
		app->sound = true;
}

// Toggle Hit Moving Balls
void moving_toggled_event(GtkWidget *widget, gpointer data)
{
	Application *app = (Application *)data;
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->hit_moving = true;
	else
		app->hit_moving = false;
}

// Toggle Superhuman
void aimline_toggled_event(GtkWidget *widget, gpointer data)
{
	Application *app = (Application *)data;
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->aimlineoff = true;
	else
		app->aimlineoff = false;
}

// Toggle Superhuman
void superhuman_toggled_event(GtkWidget *widget, gpointer data)
{
	Application *app = (Application *)data;
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->superhuman = true;
	else
		app->superhuman = false;
}

// Toggle Game
void eb_toggled_event(GtkWidget *widget, Application *app)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->game_name = eight_ball;
		app->resetTable();
}

void nb_toggled_event(GtkWidget *widget, Application *app)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->game_name = nine_ball;
		app->resetTable();
}

void ro_toggled_event(GtkWidget *widget, Application *app)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->game_name = rotation;
		app->resetTable();
}

void nr_toggled_event(GtkWidget *widget, Application *app)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->game_name = no_rules;
		app->resetTable();
}

// Toggle Table
void bp_table_toggled_event(GtkWidget *widget, Application *app)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->table_choice = 3;
		refresh_table(app->drawing_area, app);
}

void bl_table_toggled_event(GtkWidget *widget, Application *app)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->table_choice = 2;
		refresh_table(app->drawing_area, app);
}

void mb_table_toggled_event(GtkWidget *widget, Application *app)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->table_choice = 1;
		refresh_table(app->drawing_area, app);
}

void ma_table_toggled_event(GtkWidget *widget, Application *app)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		app->table_choice = 0;
		refresh_table(app->drawing_area, app);
}

bool refresh_table(GtkWidget *widget, Application *app)
{
   	if(app->buf_pixmap)
   		gdk_pixmap_unref(app->buf_pixmap);
			
   	app->buf_pixmap = gdk_pixmap_new(widget->window, widget->allocation.width,
   	                                widget->allocation.height, -1);
   	app->gc = gdk_gc_new(widget->window);
   	gdk_gc_set_foreground(app->gc, app->black);
   	gdk_draw_rectangle(app->buf_pixmap, app->gc, 1, 0, 0,
   	                   widget->allocation.width, widget->allocation.height);
   	app->paint(app->buf_pixmap, app->gc);
   	gdk_gc_unref(app->gc);
   	app->update_table();
	return TRUE;
}
