// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/cloud/functions/v1beta2/functions.proto

package functions

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Describes the current stage of a deployment.
type CloudFunctionStatus int32

const (
	// Status not specified.
	CloudFunctionStatus_STATUS_UNSPECIFIED CloudFunctionStatus = 0
	// Successfully deployed.
	CloudFunctionStatus_READY CloudFunctionStatus = 1
	// Not deployed correctly - behavior is undefined. The item should be updated
	// or deleted to move it out of this state.
	CloudFunctionStatus_FAILED CloudFunctionStatus = 2
	// Creation or update in progress.
	CloudFunctionStatus_DEPLOYING CloudFunctionStatus = 3
	// Deletion in progress.
	CloudFunctionStatus_DELETING CloudFunctionStatus = 4
)

// Enum value maps for CloudFunctionStatus.
var (
	CloudFunctionStatus_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "READY",
		2: "FAILED",
		3: "DEPLOYING",
		4: "DELETING",
	}
	CloudFunctionStatus_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"READY":              1,
		"FAILED":             2,
		"DEPLOYING":          3,
		"DELETING":           4,
	}
)

func (x CloudFunctionStatus) Enum() *CloudFunctionStatus {
	p := new(CloudFunctionStatus)
	*p = x
	return p
}

func (x CloudFunctionStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudFunctionStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v1beta2_functions_proto_enumTypes[0].Descriptor()
}

func (CloudFunctionStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v1beta2_functions_proto_enumTypes[0]
}

func (x CloudFunctionStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudFunctionStatus.Descriptor instead.
func (CloudFunctionStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{0}
}

// Describes a Cloud Function that contains user computation executed in
// response to an event. It encapsulate function and triggers configurations.
type CloudFunction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A user-defined name of the function. Function names must be unique
	// globally and match pattern `projects/*/locations/*/functions/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The location of the function source code.
	//
	// Types that are assignable to SourceCode:
	//	*CloudFunction_SourceArchiveUrl
	//	*CloudFunction_SourceRepository
	//	*CloudFunction_SourceRepositoryUrl
	//	*CloudFunction_SourceUploadUrl
	SourceCode isCloudFunction_SourceCode `protobuf_oneof:"source_code"`
	// An event that triggers the function.
	//
	// Types that are assignable to Trigger:
	//	*CloudFunction_HttpsTrigger
	//	*CloudFunction_EventTrigger
	Trigger isCloudFunction_Trigger `protobuf_oneof:"trigger"`
	// Output only. Status of the function deployment.
	Status CloudFunctionStatus `protobuf:"varint,7,opt,name=status,proto3,enum=google.cloud.functions.v1beta2.CloudFunctionStatus" json:"status,omitempty"`
	// Output only. Name of the most recent operation modifying the function. If
	// the function status is `DEPLOYING` or `DELETING`, then it points to the
	// active operation.
	LatestOperation string `protobuf:"bytes,8,opt,name=latest_operation,json=latestOperation,proto3" json:"latest_operation,omitempty"`
	// The name of the function (as defined in source code) that will be
	// executed. Defaults to the resource name suffix, if not specified. For
	// backward compatibility, if function with given name is not found, then the
	// system will try to use function named "function".
	// For Node.js this is name of a function exported by the module specified
	// in `source_location`.
	EntryPoint string `protobuf:"bytes,9,opt,name=entry_point,json=entryPoint,proto3" json:"entry_point,omitempty"`
	// The runtime in which to run the function. Required when deploying a new
	// function, optional when updating an existing function. For a complete
	// list of possible choices, see the
	// [`gcloud` command
	// reference](/sdk/gcloud/reference/functions/deploy#--runtime).
	Runtime string `protobuf:"bytes,23,opt,name=runtime,proto3" json:"runtime,omitempty"`
	// The function execution timeout. Execution is considered failed and
	// can be terminated if the function is not completed at the end of the
	// timeout period. Defaults to 60 seconds.
	Timeout *duration.Duration `protobuf:"bytes,10,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The amount of memory in MB available for a function.
	// Defaults to 256MB.
	AvailableMemoryMb int32 `protobuf:"varint,11,opt,name=available_memory_mb,json=availableMemoryMb,proto3" json:"available_memory_mb,omitempty"`
	// The email of the function's service account. If empty, defaults to
	// `{project_id}@appspot.gserviceaccount.com`.
	ServiceAccount string `protobuf:"bytes,13,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Output only. The last update timestamp of a Cloud Function.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,15,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The version identifier of the Cloud Function. Each deployment attempt
	// results in a new version of a function being created.
	VersionId int64 `protobuf:"varint,20,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	// Labels associated with this Cloud Function.
	Labels map[string]string `protobuf:"bytes,21,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Environment variables that shall be available during function execution.
	EnvironmentVariables map[string]string `protobuf:"bytes,22,rep,name=environment_variables,json=environmentVariables,proto3" json:"environment_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The limit on the maximum number of function instances that may coexist at a
	// given time.
	MaxInstances int32 `protobuf:"varint,24,opt,name=max_instances,json=maxInstances,proto3" json:"max_instances,omitempty"`
	// The VPC Network that this cloud function can connect to. It can be
	// either the fully-qualified URI, or the short name of the network resource.
	// If the short network name is used, the network must belong to the same
	// project. Otherwise, it must belong to a project within the same
	// organization. The format of this field is either
	// `projects/{project}/global/networks/{network}` or `{network}`, where
	// {project} is a project id where the network is defined, and {network} is
	// the short name of the network.
	//
	// This field is mutually exclusive with `vpc_connector` and will be replaced
	// by it.
	//
	// See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
	// more information on connecting Cloud projects.
	Network string `protobuf:"bytes,25,opt,name=network,proto3" json:"network,omitempty"`
	// The VPC Network Connector that this cloud function can connect to. It can
	// be either the fully-qualified URI, or the short name of the network
	// connector resource. The format of this field is
	// `projects/*/locations/*/connectors/*`
	//
	// This field is mutually exclusive with `network` field and will eventually
	// replace it.
	//
	// See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
	// more information on connecting Cloud projects.
	VpcConnector string `protobuf:"bytes,26,opt,name=vpc_connector,json=vpcConnector,proto3" json:"vpc_connector,omitempty"`
}

func (x *CloudFunction) Reset() {
	*x = CloudFunction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudFunction) ProtoMessage() {}

func (x *CloudFunction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudFunction.ProtoReflect.Descriptor instead.
func (*CloudFunction) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{0}
}

func (x *CloudFunction) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *CloudFunction) GetSourceCode() isCloudFunction_SourceCode {
	if m != nil {
		return m.SourceCode
	}
	return nil
}

func (x *CloudFunction) GetSourceArchiveUrl() string {
	if x, ok := x.GetSourceCode().(*CloudFunction_SourceArchiveUrl); ok {
		return x.SourceArchiveUrl
	}
	return ""
}

func (x *CloudFunction) GetSourceRepository() *SourceRepository {
	if x, ok := x.GetSourceCode().(*CloudFunction_SourceRepository); ok {
		return x.SourceRepository
	}
	return nil
}

func (x *CloudFunction) GetSourceRepositoryUrl() string {
	if x, ok := x.GetSourceCode().(*CloudFunction_SourceRepositoryUrl); ok {
		return x.SourceRepositoryUrl
	}
	return ""
}

func (x *CloudFunction) GetSourceUploadUrl() string {
	if x, ok := x.GetSourceCode().(*CloudFunction_SourceUploadUrl); ok {
		return x.SourceUploadUrl
	}
	return ""
}

func (m *CloudFunction) GetTrigger() isCloudFunction_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (x *CloudFunction) GetHttpsTrigger() *HTTPSTrigger {
	if x, ok := x.GetTrigger().(*CloudFunction_HttpsTrigger); ok {
		return x.HttpsTrigger
	}
	return nil
}

func (x *CloudFunction) GetEventTrigger() *EventTrigger {
	if x, ok := x.GetTrigger().(*CloudFunction_EventTrigger); ok {
		return x.EventTrigger
	}
	return nil
}

func (x *CloudFunction) GetStatus() CloudFunctionStatus {
	if x != nil {
		return x.Status
	}
	return CloudFunctionStatus_STATUS_UNSPECIFIED
}

func (x *CloudFunction) GetLatestOperation() string {
	if x != nil {
		return x.LatestOperation
	}
	return ""
}

func (x *CloudFunction) GetEntryPoint() string {
	if x != nil {
		return x.EntryPoint
	}
	return ""
}

func (x *CloudFunction) GetRuntime() string {
	if x != nil {
		return x.Runtime
	}
	return ""
}

func (x *CloudFunction) GetTimeout() *duration.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *CloudFunction) GetAvailableMemoryMb() int32 {
	if x != nil {
		return x.AvailableMemoryMb
	}
	return 0
}

func (x *CloudFunction) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *CloudFunction) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *CloudFunction) GetVersionId() int64 {
	if x != nil {
		return x.VersionId
	}
	return 0
}

func (x *CloudFunction) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CloudFunction) GetEnvironmentVariables() map[string]string {
	if x != nil {
		return x.EnvironmentVariables
	}
	return nil
}

func (x *CloudFunction) GetMaxInstances() int32 {
	if x != nil {
		return x.MaxInstances
	}
	return 0
}

func (x *CloudFunction) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *CloudFunction) GetVpcConnector() string {
	if x != nil {
		return x.VpcConnector
	}
	return ""
}

type isCloudFunction_SourceCode interface {
	isCloudFunction_SourceCode()
}

type CloudFunction_SourceArchiveUrl struct {
	// The Google Cloud Storage URL, starting with gs://, pointing to the zip
	// archive which contains the function.
	SourceArchiveUrl string `protobuf:"bytes,14,opt,name=source_archive_url,json=sourceArchiveUrl,proto3,oneof"`
}

type CloudFunction_SourceRepository struct {
	// The hosted repository where the function is defined.
	SourceRepository *SourceRepository `protobuf:"bytes,3,opt,name=source_repository,json=sourceRepository,proto3,oneof"`
}

type CloudFunction_SourceRepositoryUrl struct {
	// The URL pointing to the hosted repository where the function is defined.
	// There are supported Cloud Source Repository URLs in the following
	// formats:
	//
	// To refer to a specific commit:
	// `https://source.developers.google.com/projects/*/repos/*/revisions/*/paths/*`
	// To refer to a moveable alias (branch):
	// `https://source.developers.google.com/projects/*/repos/*/moveable-aliases/*/paths/*`
	// In particular, to refer to HEAD use `master` moveable alias.
	// To refer to a specific fixed alias (tag):
	// `https://source.developers.google.com/projects/*/repos/*/fixed-aliases/*/paths/*`
	//
	// You may omit `paths/*` if you want to use the main directory.
	SourceRepositoryUrl string `protobuf:"bytes,18,opt,name=source_repository_url,json=sourceRepositoryUrl,proto3,oneof"`
}

type CloudFunction_SourceUploadUrl struct {
	// The Google Cloud Storage signed URL used for source uploading, generated
	// by [google.cloud.functions.v1beta2.GenerateUploadUrl][]
	SourceUploadUrl string `protobuf:"bytes,16,opt,name=source_upload_url,json=sourceUploadUrl,proto3,oneof"`
}

func (*CloudFunction_SourceArchiveUrl) isCloudFunction_SourceCode() {}

func (*CloudFunction_SourceRepository) isCloudFunction_SourceCode() {}

func (*CloudFunction_SourceRepositoryUrl) isCloudFunction_SourceCode() {}

func (*CloudFunction_SourceUploadUrl) isCloudFunction_SourceCode() {}

type isCloudFunction_Trigger interface {
	isCloudFunction_Trigger()
}

type CloudFunction_HttpsTrigger struct {
	// An HTTPS endpoint type of source that can be triggered via URL.
	HttpsTrigger *HTTPSTrigger `protobuf:"bytes,6,opt,name=https_trigger,json=httpsTrigger,proto3,oneof"`
}

type CloudFunction_EventTrigger struct {
	// A source that fires events in response to a condition in another service.
	EventTrigger *EventTrigger `protobuf:"bytes,12,opt,name=event_trigger,json=eventTrigger,proto3,oneof"`
}

func (*CloudFunction_HttpsTrigger) isCloudFunction_Trigger() {}

func (*CloudFunction_EventTrigger) isCloudFunction_Trigger() {}

// Describes HTTPSTrigger, could be used to connect web hooks to function.
type HTTPSTrigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The deployed url for the function.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *HTTPSTrigger) Reset() {
	*x = HTTPSTrigger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPSTrigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPSTrigger) ProtoMessage() {}

func (x *HTTPSTrigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPSTrigger.ProtoReflect.Descriptor instead.
func (*HTTPSTrigger) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{1}
}

func (x *HTTPSTrigger) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// Describes EventTrigger, used to request events be sent from another
// service.
type EventTrigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `event_type` names contain the service that is sending an event and the
	// kind of event that was fired. Must be of the form
	// `providers/*/eventTypes/*` e.g. Directly handle a Message published to
	// Google Cloud Pub/Sub `providers/cloud.pubsub/eventTypes/topic.publish`.
	//
	// Handle an object changing in Google Cloud Storage:
	// `providers/cloud.storage/eventTypes/object.change`
	//
	// Handle a write to the Firebase Realtime Database:
	// `providers/google.firebase.database/eventTypes/ref.write`
	EventType string `protobuf:"bytes,1,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// Which instance of the source's service should send events. E.g. for Pub/Sub
	// this would be a Pub/Sub topic at `projects/*/topics/*`. For Google Cloud
	// Storage this would be a bucket at `projects/*/buckets/*`. For any source
	// that only supports one instance per-project, this should be the name of the
	// project (`projects/*`)
	Resource string `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	// The hostname of the service that should be observed.
	//
	// If no string is provided, the default service implementing the API will
	// be used. For example, `storage.googleapis.com` is the default for all
	// event types in the `google.storage` namespace.
	Service string `protobuf:"bytes,6,opt,name=service,proto3" json:"service,omitempty"`
	// Specifies policy for failed executions.
	FailurePolicy *FailurePolicy `protobuf:"bytes,5,opt,name=failure_policy,json=failurePolicy,proto3" json:"failure_policy,omitempty"`
}

func (x *EventTrigger) Reset() {
	*x = EventTrigger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventTrigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventTrigger) ProtoMessage() {}

func (x *EventTrigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventTrigger.ProtoReflect.Descriptor instead.
func (*EventTrigger) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{2}
}

func (x *EventTrigger) GetEventType() string {
	if x != nil {
		return x.EventType
	}
	return ""
}

func (x *EventTrigger) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *EventTrigger) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *EventTrigger) GetFailurePolicy() *FailurePolicy {
	if x != nil {
		return x.FailurePolicy
	}
	return nil
}

// Describes the location of the function source in a remote repository.
type SourceRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URL to the hosted repository where the function is defined. Only paths in
	// https://source.developers.google.com domain are supported. The path should
	// contain the name of the repository.
	RepositoryUrl string `protobuf:"bytes,1,opt,name=repository_url,json=repositoryUrl,proto3" json:"repository_url,omitempty"`
	// The path within the repository where the function is defined. The path
	// should point to the directory where Cloud Functions files are located. Use
	// "/" if the function is defined directly in the root directory of a
	// repository.
	SourcePath string `protobuf:"bytes,2,opt,name=source_path,json=sourcePath,proto3" json:"source_path,omitempty"`
	// The version of a function. Defaults to the latest version of the master
	// branch.
	//
	// Types that are assignable to Version:
	//	*SourceRepository_Branch
	//	*SourceRepository_Tag
	//	*SourceRepository_Revision
	Version isSourceRepository_Version `protobuf_oneof:"version"`
	// Output only. The id of the revision that was resolved at the moment of
	// function creation or update. For example when a user deployed from a
	// branch, it will be the revision id of the latest change on this branch at
	// that time. If user deployed from revision then this value will be always
	// equal to the revision specified by the user.
	DeployedRevision string `protobuf:"bytes,6,opt,name=deployed_revision,json=deployedRevision,proto3" json:"deployed_revision,omitempty"`
}

func (x *SourceRepository) Reset() {
	*x = SourceRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceRepository) ProtoMessage() {}

func (x *SourceRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceRepository.ProtoReflect.Descriptor instead.
func (*SourceRepository) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{3}
}

func (x *SourceRepository) GetRepositoryUrl() string {
	if x != nil {
		return x.RepositoryUrl
	}
	return ""
}

func (x *SourceRepository) GetSourcePath() string {
	if x != nil {
		return x.SourcePath
	}
	return ""
}

func (m *SourceRepository) GetVersion() isSourceRepository_Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (x *SourceRepository) GetBranch() string {
	if x, ok := x.GetVersion().(*SourceRepository_Branch); ok {
		return x.Branch
	}
	return ""
}

func (x *SourceRepository) GetTag() string {
	if x, ok := x.GetVersion().(*SourceRepository_Tag); ok {
		return x.Tag
	}
	return ""
}

func (x *SourceRepository) GetRevision() string {
	if x, ok := x.GetVersion().(*SourceRepository_Revision); ok {
		return x.Revision
	}
	return ""
}

func (x *SourceRepository) GetDeployedRevision() string {
	if x != nil {
		return x.DeployedRevision
	}
	return ""
}

type isSourceRepository_Version interface {
	isSourceRepository_Version()
}

type SourceRepository_Branch struct {
	// The name of the branch from which the function should be fetched.
	Branch string `protobuf:"bytes,3,opt,name=branch,proto3,oneof"`
}

type SourceRepository_Tag struct {
	// The name of the tag that captures the state of the repository from
	// which the function should be fetched.
	Tag string `protobuf:"bytes,4,opt,name=tag,proto3,oneof"`
}

type SourceRepository_Revision struct {
	// The id of the revision that captures the state of the repository from
	// which the function should be fetched.
	Revision string `protobuf:"bytes,5,opt,name=revision,proto3,oneof"`
}

func (*SourceRepository_Branch) isSourceRepository_Version() {}

func (*SourceRepository_Tag) isSourceRepository_Version() {}

func (*SourceRepository_Revision) isSourceRepository_Version() {}

// Describes the policy in case of function's execution failure.
// If empty, then defaults to ignoring failures (i.e. not retrying them).
type FailurePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines the action taken in case of a function execution failure.
	//
	// Types that are assignable to Action:
	//	*FailurePolicy_Retry_
	Action isFailurePolicy_Action `protobuf_oneof:"action"`
}

func (x *FailurePolicy) Reset() {
	*x = FailurePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FailurePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FailurePolicy) ProtoMessage() {}

func (x *FailurePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FailurePolicy.ProtoReflect.Descriptor instead.
func (*FailurePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{4}
}

func (m *FailurePolicy) GetAction() isFailurePolicy_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *FailurePolicy) GetRetry() *FailurePolicy_Retry {
	if x, ok := x.GetAction().(*FailurePolicy_Retry_); ok {
		return x.Retry
	}
	return nil
}

type isFailurePolicy_Action interface {
	isFailurePolicy_Action()
}

type FailurePolicy_Retry_ struct {
	// If specified, then the function will be retried in case of a failure.
	Retry *FailurePolicy_Retry `protobuf:"bytes,1,opt,name=retry,proto3,oneof"`
}

func (*FailurePolicy_Retry_) isFailurePolicy_Action() {}

// Request for the `CreateFunction` method.
type CreateFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location in which the function should be created, specified
	// in the format `projects/*/locations/*`
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Required. Function to be created.
	Function *CloudFunction `protobuf:"bytes,2,opt,name=function,proto3" json:"function,omitempty"`
}

func (x *CreateFunctionRequest) Reset() {
	*x = CreateFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFunctionRequest) ProtoMessage() {}

func (x *CreateFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFunctionRequest.ProtoReflect.Descriptor instead.
func (*CreateFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{5}
}

func (x *CreateFunctionRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *CreateFunctionRequest) GetFunction() *CloudFunction {
	if x != nil {
		return x.Function
	}
	return nil
}

// Request for the `UpdateFunction` method.
type UpdateFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the function to be updated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. New version of the function.
	Function *CloudFunction `protobuf:"bytes,2,opt,name=function,proto3" json:"function,omitempty"`
}

func (x *UpdateFunctionRequest) Reset() {
	*x = UpdateFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFunctionRequest) ProtoMessage() {}

func (x *UpdateFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFunctionRequest.ProtoReflect.Descriptor instead.
func (*UpdateFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateFunctionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateFunctionRequest) GetFunction() *CloudFunction {
	if x != nil {
		return x.Function
	}
	return nil
}

// Request for the `GetFunction` method.
type GetFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the function which details should be obtained.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFunctionRequest) Reset() {
	*x = GetFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFunctionRequest) ProtoMessage() {}

func (x *GetFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFunctionRequest.ProtoReflect.Descriptor instead.
func (*GetFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{7}
}

func (x *GetFunctionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `ListFunctions` method.
type ListFunctionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the function should be listed,
	// specified in the format `projects/*/locations/*`
	// If you want to list functions in all locations, use "-" in place of a
	// location. When listing functions in all locations, if one or more
	// location(s) are unreachable, the response will contain functions from all
	// reachable locations along with the names of any unreachable locations.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Maximum number of functions to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last
	// `ListFunctionsResponse`; indicates that
	// this is a continuation of a prior `ListFunctions` call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListFunctionsRequest) Reset() {
	*x = ListFunctionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFunctionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFunctionsRequest) ProtoMessage() {}

func (x *ListFunctionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFunctionsRequest.ProtoReflect.Descriptor instead.
func (*ListFunctionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{8}
}

func (x *ListFunctionsRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *ListFunctionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFunctionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the `ListFunctions` method.
type ListFunctionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The functions that match the request.
	Functions []*CloudFunction `protobuf:"bytes,1,rep,name=functions,proto3" json:"functions,omitempty"`
	// If not empty, indicates that there may be more functions that match
	// the request; this value should be passed in a new
	// [google.cloud.functions.v1beta2.ListFunctionsRequest][google.cloud.functions.v1beta2.ListFunctionsRequest]
	// to get more functions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached. The response does not include any
	// functions from these locations.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListFunctionsResponse) Reset() {
	*x = ListFunctionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFunctionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFunctionsResponse) ProtoMessage() {}

func (x *ListFunctionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFunctionsResponse.ProtoReflect.Descriptor instead.
func (*ListFunctionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{9}
}

func (x *ListFunctionsResponse) GetFunctions() []*CloudFunction {
	if x != nil {
		return x.Functions
	}
	return nil
}

func (x *ListFunctionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListFunctionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for the `DeleteFunction` method.
type DeleteFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the function which should be deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteFunctionRequest) Reset() {
	*x = DeleteFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFunctionRequest) ProtoMessage() {}

func (x *DeleteFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFunctionRequest.ProtoReflect.Descriptor instead.
func (*DeleteFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{10}
}

func (x *DeleteFunctionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `CallFunction` method.
type CallFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the function to be called.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Input to be passed to the function.
	Data string `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *CallFunctionRequest) Reset() {
	*x = CallFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CallFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallFunctionRequest) ProtoMessage() {}

func (x *CallFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallFunctionRequest.ProtoReflect.Descriptor instead.
func (*CallFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{11}
}

func (x *CallFunctionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CallFunctionRequest) GetData() string {
	if x != nil {
		return x.Data
	}
	return ""
}

// Response of `CallFunction` method.
type CallFunctionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Execution id of function invocation.
	ExecutionId string `protobuf:"bytes,1,opt,name=execution_id,json=executionId,proto3" json:"execution_id,omitempty"`
	// Result populated for successful execution of synchronous function. Will
	// not be populated if function does not return a result through context.
	Result string `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
	// Either system or user-function generated error. Set if execution
	// was not successful.
	Error string `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *CallFunctionResponse) Reset() {
	*x = CallFunctionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CallFunctionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallFunctionResponse) ProtoMessage() {}

func (x *CallFunctionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallFunctionResponse.ProtoReflect.Descriptor instead.
func (*CallFunctionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{12}
}

func (x *CallFunctionResponse) GetExecutionId() string {
	if x != nil {
		return x.ExecutionId
	}
	return ""
}

func (x *CallFunctionResponse) GetResult() string {
	if x != nil {
		return x.Result
	}
	return ""
}

func (x *CallFunctionResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

// Request of `GenerateUploadUrl` method.
type GenerateUploadUrlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project and location in which the Google Cloud Storage signed URL
	// should be generated, specified in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *GenerateUploadUrlRequest) Reset() {
	*x = GenerateUploadUrlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateUploadUrlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateUploadUrlRequest) ProtoMessage() {}

func (x *GenerateUploadUrlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateUploadUrlRequest.ProtoReflect.Descriptor instead.
func (*GenerateUploadUrlRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{13}
}

func (x *GenerateUploadUrlRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Response of `GenerateUploadUrl` method.
type GenerateUploadUrlResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The generated Google Cloud Storage signed URL that should be used for a
	// function source code upload. The uploaded file should be a zip archive
	// which contains a function.
	UploadUrl string `protobuf:"bytes,1,opt,name=upload_url,json=uploadUrl,proto3" json:"upload_url,omitempty"`
}

func (x *GenerateUploadUrlResponse) Reset() {
	*x = GenerateUploadUrlResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateUploadUrlResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateUploadUrlResponse) ProtoMessage() {}

func (x *GenerateUploadUrlResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateUploadUrlResponse.ProtoReflect.Descriptor instead.
func (*GenerateUploadUrlResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{14}
}

func (x *GenerateUploadUrlResponse) GetUploadUrl() string {
	if x != nil {
		return x.UploadUrl
	}
	return ""
}

// Request of `GenerateDownloadUrl` method.
type GenerateDownloadUrlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of function for which source code Google Cloud Storage signed
	// URL should be generated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The optional version of function.
	VersionId uint64 `protobuf:"varint,2,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
}

func (x *GenerateDownloadUrlRequest) Reset() {
	*x = GenerateDownloadUrlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateDownloadUrlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateDownloadUrlRequest) ProtoMessage() {}

func (x *GenerateDownloadUrlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateDownloadUrlRequest.ProtoReflect.Descriptor instead.
func (*GenerateDownloadUrlRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{15}
}

func (x *GenerateDownloadUrlRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GenerateDownloadUrlRequest) GetVersionId() uint64 {
	if x != nil {
		return x.VersionId
	}
	return 0
}

// Response of `GenerateDownloadUrl` method.
type GenerateDownloadUrlResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The generated Google Cloud Storage signed URL that should be used for
	// function source code download.
	DownloadUrl string `protobuf:"bytes,1,opt,name=download_url,json=downloadUrl,proto3" json:"download_url,omitempty"`
}

func (x *GenerateDownloadUrlResponse) Reset() {
	*x = GenerateDownloadUrlResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateDownloadUrlResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateDownloadUrlResponse) ProtoMessage() {}

func (x *GenerateDownloadUrlResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateDownloadUrlResponse.ProtoReflect.Descriptor instead.
func (*GenerateDownloadUrlResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{16}
}

func (x *GenerateDownloadUrlResponse) GetDownloadUrl() string {
	if x != nil {
		return x.DownloadUrl
	}
	return ""
}

// Describes the retry policy in case of function's execution failure.
// A function execution will be retried on any failure.
// A failed execution will be retried up to 7 days with an exponential backoff
// (capped at 10 seconds).
// Retried execution is charged as any other execution.
type FailurePolicy_Retry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *FailurePolicy_Retry) Reset() {
	*x = FailurePolicy_Retry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FailurePolicy_Retry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FailurePolicy_Retry) ProtoMessage() {}

func (x *FailurePolicy_Retry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1beta2_functions_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FailurePolicy_Retry.ProtoReflect.Descriptor instead.
func (*FailurePolicy_Retry) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP(), []int{4, 0}
}

var File_google_cloud_functions_v1beta2_functions_proto protoreflect.FileDescriptor

var file_google_cloud_functions_v1beta2_functions_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32,
	0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb6, 0x0b, 0x0a, 0x0d, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x2e, 0x0a, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76,
	0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x10, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x55, 0x72, 0x6c, 0x12,
	0x5f, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x10,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x12, 0x34, 0x0a, 0x15, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x13, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x55, 0x72, 0x6c, 0x12, 0x2c, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x55, 0x72, 0x6c, 0x12, 0x53, 0x0a, 0x0d, 0x68, 0x74, 0x74, 0x70, 0x73, 0x5f, 0x74, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x48, 0x54, 0x54,
	0x50, 0x53, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x48, 0x01, 0x52, 0x0c, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x53, 0x0a, 0x0d, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x32, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x48, 0x01,
	0x52, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x50,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x2e, 0x0a, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0f, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x69, 0x6e,
	0x74, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x17, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x07, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x12, 0x2e, 0x0a, 0x13, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6d, 0x62, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x61,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4d, 0x62,
	0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x14, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x51, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x15, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x7c, 0x0a, 0x15, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x16, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x32, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x14, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x23, 0x0a, 0x0d, 0x76, 0x70, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x18, 0x1a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x76, 0x70, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0x47, 0x0a, 0x19, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x6e, 0xea, 0x41, 0x6b, 0x0a, 0x2b, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0x0d, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x22, 0x25, 0x0a, 0x0c, 0x48, 0x54, 0x54, 0x50, 0x53, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x22, 0xb9, 0x01, 0x0a, 0x0c, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x54, 0x0a, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0xe3, 0x01, 0x0a, 0x10, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x55, 0x72,
	0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x18, 0x0a, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x12, 0x0a, 0x03,
	0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x74, 0x61, 0x67,
	0x12, 0x1c, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x30,
	0x0a, 0x11, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x42, 0x09, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0x0a, 0x0d, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x4b, 0x0a, 0x05,
	0x72, 0x65, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x46, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79,
	0x48, 0x00, 0x52, 0x05, 0x72, 0x65, 0x74, 0x72, 0x79, 0x1a, 0x07, 0x0a, 0x05, 0x52, 0x65, 0x74,
	0x72, 0x79, 0x42, 0x08, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xae, 0x01, 0x0a,
	0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a,
	0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb0, 0x01,
	0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x4e, 0x0a, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x32, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x5d, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x99, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xae, 0x01, 0x0a, 0x15,
	0x4c, 0x69, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x09, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x60, 0x0a, 0x15,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x77,
	0x0a, 0x13, 0x43, 0x61, 0x6c, 0x6c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0x67, 0x0a, 0x14, 0x43, 0x61, 0x6c, 0x6c, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x22, 0x32, 0x0a, 0x18, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x22, 0x3a, 0x0a, 0x19, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c,
	0x22, 0x4f, 0x0a, 0x1a, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x22, 0x40, 0x0a, 0x1b, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x75, 0x72, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64,
	0x55, 0x72, 0x6c, 0x2a, 0x61, 0x0a, 0x13, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54,
	0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x45, 0x50,
	0x4c, 0x4f, 0x59, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x32, 0xb2, 0x0e, 0x0a, 0x15, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0xc5, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x47, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x32, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xb3, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x41, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xef,
	0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x86, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40,
	0x22, 0x34, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0xda, 0x41, 0x11, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0xca, 0x41, 0x29, 0x0a, 0x0d, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x32,
	0x12, 0xe9, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3e, 0x1a, 0x32, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0xda, 0x41, 0x0d, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0xca, 0x41, 0x29, 0x0a, 0x0d, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x18, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x32, 0x12, 0xdd, 0x01, 0x0a,
	0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x2a, 0x32, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x31, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x18, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x32, 0x12, 0xc9, 0x01, 0x0a,
	0x0c, 0x43, 0x61, 0x6c, 0x6c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x43,
	0x61, 0x6c, 0x6c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x32, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c,
	0x22, 0x37, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6c, 0x6c, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x09, 0x6e,
	0x61, 0x6d, 0x65, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x12, 0xd9, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x4f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x22, 0x44, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72,
	0x6c, 0x3a, 0x01, 0x2a, 0x12, 0xe1, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x22, 0x46, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x55, 0x72, 0x6c, 0x3a, 0x01, 0x2a, 0x1a, 0x51, 0xca, 0x41, 0x1d, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x85, 0x01, 0x0a, 0x22,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x32, 0x42, 0x0e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x32, 0x3b, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xa2, 0x02, 0x03,
	0x47, 0x43, 0x46, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_functions_v1beta2_functions_proto_rawDescOnce sync.Once
	file_google_cloud_functions_v1beta2_functions_proto_rawDescData = file_google_cloud_functions_v1beta2_functions_proto_rawDesc
)

func file_google_cloud_functions_v1beta2_functions_proto_rawDescGZIP() []byte {
	file_google_cloud_functions_v1beta2_functions_proto_rawDescOnce.Do(func() {
		file_google_cloud_functions_v1beta2_functions_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_functions_v1beta2_functions_proto_rawDescData)
	})
	return file_google_cloud_functions_v1beta2_functions_proto_rawDescData
}

var file_google_cloud_functions_v1beta2_functions_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_functions_v1beta2_functions_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_functions_v1beta2_functions_proto_goTypes = []interface{}{
	(CloudFunctionStatus)(0),            // 0: google.cloud.functions.v1beta2.CloudFunctionStatus
	(*CloudFunction)(nil),               // 1: google.cloud.functions.v1beta2.CloudFunction
	(*HTTPSTrigger)(nil),                // 2: google.cloud.functions.v1beta2.HTTPSTrigger
	(*EventTrigger)(nil),                // 3: google.cloud.functions.v1beta2.EventTrigger
	(*SourceRepository)(nil),            // 4: google.cloud.functions.v1beta2.SourceRepository
	(*FailurePolicy)(nil),               // 5: google.cloud.functions.v1beta2.FailurePolicy
	(*CreateFunctionRequest)(nil),       // 6: google.cloud.functions.v1beta2.CreateFunctionRequest
	(*UpdateFunctionRequest)(nil),       // 7: google.cloud.functions.v1beta2.UpdateFunctionRequest
	(*GetFunctionRequest)(nil),          // 8: google.cloud.functions.v1beta2.GetFunctionRequest
	(*ListFunctionsRequest)(nil),        // 9: google.cloud.functions.v1beta2.ListFunctionsRequest
	(*ListFunctionsResponse)(nil),       // 10: google.cloud.functions.v1beta2.ListFunctionsResponse
	(*DeleteFunctionRequest)(nil),       // 11: google.cloud.functions.v1beta2.DeleteFunctionRequest
	(*CallFunctionRequest)(nil),         // 12: google.cloud.functions.v1beta2.CallFunctionRequest
	(*CallFunctionResponse)(nil),        // 13: google.cloud.functions.v1beta2.CallFunctionResponse
	(*GenerateUploadUrlRequest)(nil),    // 14: google.cloud.functions.v1beta2.GenerateUploadUrlRequest
	(*GenerateUploadUrlResponse)(nil),   // 15: google.cloud.functions.v1beta2.GenerateUploadUrlResponse
	(*GenerateDownloadUrlRequest)(nil),  // 16: google.cloud.functions.v1beta2.GenerateDownloadUrlRequest
	(*GenerateDownloadUrlResponse)(nil), // 17: google.cloud.functions.v1beta2.GenerateDownloadUrlResponse
	nil,                                 // 18: google.cloud.functions.v1beta2.CloudFunction.LabelsEntry
	nil,                                 // 19: google.cloud.functions.v1beta2.CloudFunction.EnvironmentVariablesEntry
	(*FailurePolicy_Retry)(nil),         // 20: google.cloud.functions.v1beta2.FailurePolicy.Retry
	(*duration.Duration)(nil),           // 21: google.protobuf.Duration
	(*timestamp.Timestamp)(nil),         // 22: google.protobuf.Timestamp
	(*longrunning.Operation)(nil),       // 23: google.longrunning.Operation
}
var file_google_cloud_functions_v1beta2_functions_proto_depIdxs = []int32{
	4,  // 0: google.cloud.functions.v1beta2.CloudFunction.source_repository:type_name -> google.cloud.functions.v1beta2.SourceRepository
	2,  // 1: google.cloud.functions.v1beta2.CloudFunction.https_trigger:type_name -> google.cloud.functions.v1beta2.HTTPSTrigger
	3,  // 2: google.cloud.functions.v1beta2.CloudFunction.event_trigger:type_name -> google.cloud.functions.v1beta2.EventTrigger
	0,  // 3: google.cloud.functions.v1beta2.CloudFunction.status:type_name -> google.cloud.functions.v1beta2.CloudFunctionStatus
	21, // 4: google.cloud.functions.v1beta2.CloudFunction.timeout:type_name -> google.protobuf.Duration
	22, // 5: google.cloud.functions.v1beta2.CloudFunction.update_time:type_name -> google.protobuf.Timestamp
	18, // 6: google.cloud.functions.v1beta2.CloudFunction.labels:type_name -> google.cloud.functions.v1beta2.CloudFunction.LabelsEntry
	19, // 7: google.cloud.functions.v1beta2.CloudFunction.environment_variables:type_name -> google.cloud.functions.v1beta2.CloudFunction.EnvironmentVariablesEntry
	5,  // 8: google.cloud.functions.v1beta2.EventTrigger.failure_policy:type_name -> google.cloud.functions.v1beta2.FailurePolicy
	20, // 9: google.cloud.functions.v1beta2.FailurePolicy.retry:type_name -> google.cloud.functions.v1beta2.FailurePolicy.Retry
	1,  // 10: google.cloud.functions.v1beta2.CreateFunctionRequest.function:type_name -> google.cloud.functions.v1beta2.CloudFunction
	1,  // 11: google.cloud.functions.v1beta2.UpdateFunctionRequest.function:type_name -> google.cloud.functions.v1beta2.CloudFunction
	1,  // 12: google.cloud.functions.v1beta2.ListFunctionsResponse.functions:type_name -> google.cloud.functions.v1beta2.CloudFunction
	9,  // 13: google.cloud.functions.v1beta2.CloudFunctionsService.ListFunctions:input_type -> google.cloud.functions.v1beta2.ListFunctionsRequest
	8,  // 14: google.cloud.functions.v1beta2.CloudFunctionsService.GetFunction:input_type -> google.cloud.functions.v1beta2.GetFunctionRequest
	6,  // 15: google.cloud.functions.v1beta2.CloudFunctionsService.CreateFunction:input_type -> google.cloud.functions.v1beta2.CreateFunctionRequest
	7,  // 16: google.cloud.functions.v1beta2.CloudFunctionsService.UpdateFunction:input_type -> google.cloud.functions.v1beta2.UpdateFunctionRequest
	11, // 17: google.cloud.functions.v1beta2.CloudFunctionsService.DeleteFunction:input_type -> google.cloud.functions.v1beta2.DeleteFunctionRequest
	12, // 18: google.cloud.functions.v1beta2.CloudFunctionsService.CallFunction:input_type -> google.cloud.functions.v1beta2.CallFunctionRequest
	14, // 19: google.cloud.functions.v1beta2.CloudFunctionsService.GenerateUploadUrl:input_type -> google.cloud.functions.v1beta2.GenerateUploadUrlRequest
	16, // 20: google.cloud.functions.v1beta2.CloudFunctionsService.GenerateDownloadUrl:input_type -> google.cloud.functions.v1beta2.GenerateDownloadUrlRequest
	10, // 21: google.cloud.functions.v1beta2.CloudFunctionsService.ListFunctions:output_type -> google.cloud.functions.v1beta2.ListFunctionsResponse
	1,  // 22: google.cloud.functions.v1beta2.CloudFunctionsService.GetFunction:output_type -> google.cloud.functions.v1beta2.CloudFunction
	23, // 23: google.cloud.functions.v1beta2.CloudFunctionsService.CreateFunction:output_type -> google.longrunning.Operation
	23, // 24: google.cloud.functions.v1beta2.CloudFunctionsService.UpdateFunction:output_type -> google.longrunning.Operation
	23, // 25: google.cloud.functions.v1beta2.CloudFunctionsService.DeleteFunction:output_type -> google.longrunning.Operation
	13, // 26: google.cloud.functions.v1beta2.CloudFunctionsService.CallFunction:output_type -> google.cloud.functions.v1beta2.CallFunctionResponse
	15, // 27: google.cloud.functions.v1beta2.CloudFunctionsService.GenerateUploadUrl:output_type -> google.cloud.functions.v1beta2.GenerateUploadUrlResponse
	17, // 28: google.cloud.functions.v1beta2.CloudFunctionsService.GenerateDownloadUrl:output_type -> google.cloud.functions.v1beta2.GenerateDownloadUrlResponse
	21, // [21:29] is the sub-list for method output_type
	13, // [13:21] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_functions_v1beta2_functions_proto_init() }
func file_google_cloud_functions_v1beta2_functions_proto_init() {
	if File_google_cloud_functions_v1beta2_functions_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudFunction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPSTrigger); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventTrigger); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FailurePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFunctionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFunctionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CallFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CallFunctionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateUploadUrlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateUploadUrlResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateDownloadUrlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateDownloadUrlResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1beta2_functions_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FailurePolicy_Retry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_functions_v1beta2_functions_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*CloudFunction_SourceArchiveUrl)(nil),
		(*CloudFunction_SourceRepository)(nil),
		(*CloudFunction_SourceRepositoryUrl)(nil),
		(*CloudFunction_SourceUploadUrl)(nil),
		(*CloudFunction_HttpsTrigger)(nil),
		(*CloudFunction_EventTrigger)(nil),
	}
	file_google_cloud_functions_v1beta2_functions_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*SourceRepository_Branch)(nil),
		(*SourceRepository_Tag)(nil),
		(*SourceRepository_Revision)(nil),
	}
	file_google_cloud_functions_v1beta2_functions_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*FailurePolicy_Retry_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_functions_v1beta2_functions_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_functions_v1beta2_functions_proto_goTypes,
		DependencyIndexes: file_google_cloud_functions_v1beta2_functions_proto_depIdxs,
		EnumInfos:         file_google_cloud_functions_v1beta2_functions_proto_enumTypes,
		MessageInfos:      file_google_cloud_functions_v1beta2_functions_proto_msgTypes,
	}.Build()
	File_google_cloud_functions_v1beta2_functions_proto = out.File
	file_google_cloud_functions_v1beta2_functions_proto_rawDesc = nil
	file_google_cloud_functions_v1beta2_functions_proto_goTypes = nil
	file_google_cloud_functions_v1beta2_functions_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudFunctionsServiceClient is the client API for CloudFunctionsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudFunctionsServiceClient interface {
	// Returns a list of functions that belong to the requested project.
	ListFunctions(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error)
	// Returns a function with the given name from the requested project.
	GetFunction(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*CloudFunction, error)
	// Creates a new function. If a function with the given name already exists in
	// the specified project, the long running operation will return
	// `ALREADY_EXISTS` error.
	CreateFunction(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates existing function.
	UpdateFunction(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a function with the given name from the specified project. If the
	// given function is used by some trigger, the trigger will be updated to
	// remove this function.
	DeleteFunction(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Synchronously invokes a deployed Cloud Function. To be used for testing
	// purposes as very limited traffic is allowed. For more information on
	// the actual limits refer to [API Calls](
	// https://cloud.google.com/functions/quotas#rate_limits).
	CallFunction(ctx context.Context, in *CallFunctionRequest, opts ...grpc.CallOption) (*CallFunctionResponse, error)
	// Returns a signed URL for uploading a function source code.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls
	// Once the function source code upload is complete, the used signed
	// URL should be provided in CreateFunction or UpdateFunction request
	// as a reference to the function source code.
	//
	// When uploading source code to the generated signed URL, please follow
	// these restrictions:
	//
	// * Source file type should be a zip file.
	// * Source file size should not exceed 100MB limit.
	// * No credentials should be attached - the signed URLs provide access to the
	//   target bucket using internal service identity; if credentials were
	//   attached, the identity from the credentials would be used, but that
	//   identity does not have permissions to upload files to the URL.
	//
	// When making a HTTP PUT request, these two headers need to be specified:
	//
	// * `content-type: application/zip`
	// * `x-goog-content-length-range: 0,104857600`
	//
	// And this header SHOULD NOT be specified:
	//
	// * `Authorization: Bearer YOUR_TOKEN`
	GenerateUploadUrl(ctx context.Context, in *GenerateUploadUrlRequest, opts ...grpc.CallOption) (*GenerateUploadUrlResponse, error)
	// Returns a signed URL for downloading deployed function source code.
	// The URL is only valid for a limited period and should be used within
	// minutes after generation.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls
	GenerateDownloadUrl(ctx context.Context, in *GenerateDownloadUrlRequest, opts ...grpc.CallOption) (*GenerateDownloadUrlResponse, error)
}

type cloudFunctionsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudFunctionsServiceClient(cc grpc.ClientConnInterface) CloudFunctionsServiceClient {
	return &cloudFunctionsServiceClient{cc}
}

func (c *cloudFunctionsServiceClient) ListFunctions(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error) {
	out := new(ListFunctionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/ListFunctions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GetFunction(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*CloudFunction, error) {
	out := new(CloudFunction)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/GetFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) CreateFunction(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/CreateFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) UpdateFunction(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/UpdateFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) DeleteFunction(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/DeleteFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) CallFunction(ctx context.Context, in *CallFunctionRequest, opts ...grpc.CallOption) (*CallFunctionResponse, error) {
	out := new(CallFunctionResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/CallFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GenerateUploadUrl(ctx context.Context, in *GenerateUploadUrlRequest, opts ...grpc.CallOption) (*GenerateUploadUrlResponse, error) {
	out := new(GenerateUploadUrlResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/GenerateUploadUrl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GenerateDownloadUrl(ctx context.Context, in *GenerateDownloadUrlRequest, opts ...grpc.CallOption) (*GenerateDownloadUrlResponse, error) {
	out := new(GenerateDownloadUrlResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/GenerateDownloadUrl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudFunctionsServiceServer is the server API for CloudFunctionsService service.
type CloudFunctionsServiceServer interface {
	// Returns a list of functions that belong to the requested project.
	ListFunctions(context.Context, *ListFunctionsRequest) (*ListFunctionsResponse, error)
	// Returns a function with the given name from the requested project.
	GetFunction(context.Context, *GetFunctionRequest) (*CloudFunction, error)
	// Creates a new function. If a function with the given name already exists in
	// the specified project, the long running operation will return
	// `ALREADY_EXISTS` error.
	CreateFunction(context.Context, *CreateFunctionRequest) (*longrunning.Operation, error)
	// Updates existing function.
	UpdateFunction(context.Context, *UpdateFunctionRequest) (*longrunning.Operation, error)
	// Deletes a function with the given name from the specified project. If the
	// given function is used by some trigger, the trigger will be updated to
	// remove this function.
	DeleteFunction(context.Context, *DeleteFunctionRequest) (*longrunning.Operation, error)
	// Synchronously invokes a deployed Cloud Function. To be used for testing
	// purposes as very limited traffic is allowed. For more information on
	// the actual limits refer to [API Calls](
	// https://cloud.google.com/functions/quotas#rate_limits).
	CallFunction(context.Context, *CallFunctionRequest) (*CallFunctionResponse, error)
	// Returns a signed URL for uploading a function source code.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls
	// Once the function source code upload is complete, the used signed
	// URL should be provided in CreateFunction or UpdateFunction request
	// as a reference to the function source code.
	//
	// When uploading source code to the generated signed URL, please follow
	// these restrictions:
	//
	// * Source file type should be a zip file.
	// * Source file size should not exceed 100MB limit.
	// * No credentials should be attached - the signed URLs provide access to the
	//   target bucket using internal service identity; if credentials were
	//   attached, the identity from the credentials would be used, but that
	//   identity does not have permissions to upload files to the URL.
	//
	// When making a HTTP PUT request, these two headers need to be specified:
	//
	// * `content-type: application/zip`
	// * `x-goog-content-length-range: 0,104857600`
	//
	// And this header SHOULD NOT be specified:
	//
	// * `Authorization: Bearer YOUR_TOKEN`
	GenerateUploadUrl(context.Context, *GenerateUploadUrlRequest) (*GenerateUploadUrlResponse, error)
	// Returns a signed URL for downloading deployed function source code.
	// The URL is only valid for a limited period and should be used within
	// minutes after generation.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls
	GenerateDownloadUrl(context.Context, *GenerateDownloadUrlRequest) (*GenerateDownloadUrlResponse, error)
}

// UnimplementedCloudFunctionsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCloudFunctionsServiceServer struct {
}

func (*UnimplementedCloudFunctionsServiceServer) ListFunctions(context.Context, *ListFunctionsRequest) (*ListFunctionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFunctions not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) GetFunction(context.Context, *GetFunctionRequest) (*CloudFunction, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) CreateFunction(context.Context, *CreateFunctionRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) UpdateFunction(context.Context, *UpdateFunctionRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) DeleteFunction(context.Context, *DeleteFunctionRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) CallFunction(context.Context, *CallFunctionRequest) (*CallFunctionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CallFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) GenerateUploadUrl(context.Context, *GenerateUploadUrlRequest) (*GenerateUploadUrlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateUploadUrl not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) GenerateDownloadUrl(context.Context, *GenerateDownloadUrlRequest) (*GenerateDownloadUrlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateDownloadUrl not implemented")
}

func RegisterCloudFunctionsServiceServer(s *grpc.Server, srv CloudFunctionsServiceServer) {
	s.RegisterService(&_CloudFunctionsService_serviceDesc, srv)
}

func _CloudFunctionsService_ListFunctions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).ListFunctions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/ListFunctions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).ListFunctions(ctx, req.(*ListFunctionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GetFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GetFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/GetFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GetFunction(ctx, req.(*GetFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_CreateFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).CreateFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/CreateFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).CreateFunction(ctx, req.(*CreateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_UpdateFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).UpdateFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/UpdateFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).UpdateFunction(ctx, req.(*UpdateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_DeleteFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).DeleteFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/DeleteFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).DeleteFunction(ctx, req.(*DeleteFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_CallFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CallFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).CallFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/CallFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).CallFunction(ctx, req.(*CallFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GenerateUploadUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateUploadUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GenerateUploadUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/GenerateUploadUrl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GenerateUploadUrl(ctx, req.(*GenerateUploadUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GenerateDownloadUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateDownloadUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GenerateDownloadUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/GenerateDownloadUrl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GenerateDownloadUrl(ctx, req.(*GenerateDownloadUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudFunctionsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.functions.v1beta2.CloudFunctionsService",
	HandlerType: (*CloudFunctionsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListFunctions",
			Handler:    _CloudFunctionsService_ListFunctions_Handler,
		},
		{
			MethodName: "GetFunction",
			Handler:    _CloudFunctionsService_GetFunction_Handler,
		},
		{
			MethodName: "CreateFunction",
			Handler:    _CloudFunctionsService_CreateFunction_Handler,
		},
		{
			MethodName: "UpdateFunction",
			Handler:    _CloudFunctionsService_UpdateFunction_Handler,
		},
		{
			MethodName: "DeleteFunction",
			Handler:    _CloudFunctionsService_DeleteFunction_Handler,
		},
		{
			MethodName: "CallFunction",
			Handler:    _CloudFunctionsService_CallFunction_Handler,
		},
		{
			MethodName: "GenerateUploadUrl",
			Handler:    _CloudFunctionsService_GenerateUploadUrl_Handler,
		},
		{
			MethodName: "GenerateDownloadUrl",
			Handler:    _CloudFunctionsService_GenerateDownloadUrl_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/functions/v1beta2/functions.proto",
}
