// Code generated by genlib2. DO NOT EDIT.

package tensor

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

var onesTests = []struct {
	of      Dtype
	shape   Shape
	correct interface{}
}{
	{Int, ScalarShape(), int(1)},
	{Int, Shape{2, 2}, []int{1, 1, 1, 1}},
	{Int8, ScalarShape(), int8(1)},
	{Int8, Shape{2, 2}, []int8{1, 1, 1, 1}},
	{Int16, ScalarShape(), int16(1)},
	{Int16, Shape{2, 2}, []int16{1, 1, 1, 1}},
	{Int32, ScalarShape(), int32(1)},
	{Int32, Shape{2, 2}, []int32{1, 1, 1, 1}},
	{Int64, ScalarShape(), int64(1)},
	{Int64, Shape{2, 2}, []int64{1, 1, 1, 1}},
	{Uint, ScalarShape(), uint(1)},
	{Uint, Shape{2, 2}, []uint{1, 1, 1, 1}},
	{Uint8, ScalarShape(), uint8(1)},
	{Uint8, Shape{2, 2}, []uint8{1, 1, 1, 1}},
	{Uint16, ScalarShape(), uint16(1)},
	{Uint16, Shape{2, 2}, []uint16{1, 1, 1, 1}},
	{Uint32, ScalarShape(), uint32(1)},
	{Uint32, Shape{2, 2}, []uint32{1, 1, 1, 1}},
	{Uint64, ScalarShape(), uint64(1)},
	{Uint64, Shape{2, 2}, []uint64{1, 1, 1, 1}},
	{Float32, ScalarShape(), float32(1)},
	{Float32, Shape{2, 2}, []float32{1, 1, 1, 1}},
	{Float64, ScalarShape(), float64(1)},
	{Float64, Shape{2, 2}, []float64{1, 1, 1, 1}},
	{Complex64, ScalarShape(), complex64(1)},
	{Complex64, Shape{2, 2}, []complex64{1, 1, 1, 1}},
	{Complex128, ScalarShape(), complex128(1)},
	{Complex128, Shape{2, 2}, []complex128{1, 1, 1, 1}},
	{Bool, ScalarShape(), true},
	{Bool, Shape{2, 2}, []bool{true, true, true, true}},
}

func TestOnes(t *testing.T) {
	assert := assert.New(t)
	for _, ot := range onesTests {
		T := Ones(ot.of, ot.shape...)
		assert.True(ot.shape.Eq(T.Shape()))
		assert.Equal(ot.correct, T.Data())
	}
}

// yes, it's a pun on eye tests, stop asking and go see your optometrist
var eyeTests = []struct {
	E       Dtype
	R, C, K int

	correct interface{}
}{
	{Int, 4, 4, 0, []int{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1}},
	{Int, 4, 4, 1, []int{0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}},
	{Int, 4, 4, 2, []int{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int, 4, 4, 3, []int{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int, 4, 4, 4, []int{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int, 4, 4, -1, []int{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0}},
	{Int, 4, 4, -2, []int{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}},
	{Int, 4, 4, -3, []int{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}},
	{Int, 4, 4, -4, []int{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int, 4, 5, 0, []int{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}},
	{Int, 4, 5, 1, []int{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}},
	{Int, 4, 5, -1, []int{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}},
	{Int8, 4, 4, 0, []int8{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1}},
	{Int8, 4, 4, 1, []int8{0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}},
	{Int8, 4, 4, 2, []int8{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int8, 4, 4, 3, []int8{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int8, 4, 4, 4, []int8{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int8, 4, 4, -1, []int8{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0}},
	{Int8, 4, 4, -2, []int8{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}},
	{Int8, 4, 4, -3, []int8{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}},
	{Int8, 4, 4, -4, []int8{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int8, 4, 5, 0, []int8{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}},
	{Int8, 4, 5, 1, []int8{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}},
	{Int8, 4, 5, -1, []int8{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}},
	{Int16, 4, 4, 0, []int16{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1}},
	{Int16, 4, 4, 1, []int16{0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}},
	{Int16, 4, 4, 2, []int16{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int16, 4, 4, 3, []int16{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int16, 4, 4, 4, []int16{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int16, 4, 4, -1, []int16{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0}},
	{Int16, 4, 4, -2, []int16{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}},
	{Int16, 4, 4, -3, []int16{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}},
	{Int16, 4, 4, -4, []int16{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int16, 4, 5, 0, []int16{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}},
	{Int16, 4, 5, 1, []int16{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}},
	{Int16, 4, 5, -1, []int16{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}},
	{Int32, 4, 4, 0, []int32{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1}},
	{Int32, 4, 4, 1, []int32{0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}},
	{Int32, 4, 4, 2, []int32{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int32, 4, 4, 3, []int32{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int32, 4, 4, 4, []int32{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int32, 4, 4, -1, []int32{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0}},
	{Int32, 4, 4, -2, []int32{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}},
	{Int32, 4, 4, -3, []int32{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}},
	{Int32, 4, 4, -4, []int32{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int32, 4, 5, 0, []int32{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}},
	{Int32, 4, 5, 1, []int32{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}},
	{Int32, 4, 5, -1, []int32{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}},
	{Int64, 4, 4, 0, []int64{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1}},
	{Int64, 4, 4, 1, []int64{0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}},
	{Int64, 4, 4, 2, []int64{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int64, 4, 4, 3, []int64{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int64, 4, 4, 4, []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int64, 4, 4, -1, []int64{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0}},
	{Int64, 4, 4, -2, []int64{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}},
	{Int64, 4, 4, -3, []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}},
	{Int64, 4, 4, -4, []int64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Int64, 4, 5, 0, []int64{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}},
	{Int64, 4, 5, 1, []int64{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}},
	{Int64, 4, 5, -1, []int64{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}},
	{Uint, 4, 4, 0, []uint{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1}},
	{Uint, 4, 4, 1, []uint{0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}},
	{Uint, 4, 4, 2, []uint{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint, 4, 4, 3, []uint{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint, 4, 4, 4, []uint{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint, 4, 4, -1, []uint{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0}},
	{Uint, 4, 4, -2, []uint{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}},
	{Uint, 4, 4, -3, []uint{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}},
	{Uint, 4, 4, -4, []uint{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint, 4, 5, 0, []uint{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}},
	{Uint, 4, 5, 1, []uint{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}},
	{Uint, 4, 5, -1, []uint{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}},
	{Uint8, 4, 4, 0, []uint8{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1}},
	{Uint8, 4, 4, 1, []uint8{0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}},
	{Uint8, 4, 4, 2, []uint8{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint8, 4, 4, 3, []uint8{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint8, 4, 4, 4, []uint8{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint8, 4, 4, -1, []uint8{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0}},
	{Uint8, 4, 4, -2, []uint8{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}},
	{Uint8, 4, 4, -3, []uint8{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}},
	{Uint8, 4, 4, -4, []uint8{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint8, 4, 5, 0, []uint8{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}},
	{Uint8, 4, 5, 1, []uint8{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}},
	{Uint8, 4, 5, -1, []uint8{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}},
	{Uint16, 4, 4, 0, []uint16{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1}},
	{Uint16, 4, 4, 1, []uint16{0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}},
	{Uint16, 4, 4, 2, []uint16{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint16, 4, 4, 3, []uint16{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint16, 4, 4, 4, []uint16{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint16, 4, 4, -1, []uint16{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0}},
	{Uint16, 4, 4, -2, []uint16{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}},
	{Uint16, 4, 4, -3, []uint16{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}},
	{Uint16, 4, 4, -4, []uint16{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint16, 4, 5, 0, []uint16{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}},
	{Uint16, 4, 5, 1, []uint16{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}},
	{Uint16, 4, 5, -1, []uint16{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}},
	{Uint32, 4, 4, 0, []uint32{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1}},
	{Uint32, 4, 4, 1, []uint32{0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}},
	{Uint32, 4, 4, 2, []uint32{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint32, 4, 4, 3, []uint32{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint32, 4, 4, 4, []uint32{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint32, 4, 4, -1, []uint32{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0}},
	{Uint32, 4, 4, -2, []uint32{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}},
	{Uint32, 4, 4, -3, []uint32{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}},
	{Uint32, 4, 4, -4, []uint32{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint32, 4, 5, 0, []uint32{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}},
	{Uint32, 4, 5, 1, []uint32{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}},
	{Uint32, 4, 5, -1, []uint32{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}},
	{Uint64, 4, 4, 0, []uint64{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1}},
	{Uint64, 4, 4, 1, []uint64{0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}},
	{Uint64, 4, 4, 2, []uint64{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint64, 4, 4, 3, []uint64{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint64, 4, 4, 4, []uint64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint64, 4, 4, -1, []uint64{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0}},
	{Uint64, 4, 4, -2, []uint64{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}},
	{Uint64, 4, 4, -3, []uint64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}},
	{Uint64, 4, 4, -4, []uint64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Uint64, 4, 5, 0, []uint64{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}},
	{Uint64, 4, 5, 1, []uint64{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}},
	{Uint64, 4, 5, -1, []uint64{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}},
	{Float32, 4, 4, 0, []float32{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1}},
	{Float32, 4, 4, 1, []float32{0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}},
	{Float32, 4, 4, 2, []float32{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Float32, 4, 4, 3, []float32{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Float32, 4, 4, 4, []float32{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Float32, 4, 4, -1, []float32{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0}},
	{Float32, 4, 4, -2, []float32{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}},
	{Float32, 4, 4, -3, []float32{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}},
	{Float32, 4, 4, -4, []float32{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Float32, 4, 5, 0, []float32{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}},
	{Float32, 4, 5, 1, []float32{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}},
	{Float32, 4, 5, -1, []float32{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}},
	{Float64, 4, 4, 0, []float64{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1}},
	{Float64, 4, 4, 1, []float64{0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}},
	{Float64, 4, 4, 2, []float64{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Float64, 4, 4, 3, []float64{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Float64, 4, 4, 4, []float64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Float64, 4, 4, -1, []float64{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0}},
	{Float64, 4, 4, -2, []float64{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}},
	{Float64, 4, 4, -3, []float64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}},
	{Float64, 4, 4, -4, []float64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Float64, 4, 5, 0, []float64{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}},
	{Float64, 4, 5, 1, []float64{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}},
	{Float64, 4, 5, -1, []float64{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}},
	{Complex64, 4, 4, 0, []complex64{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1}},
	{Complex64, 4, 4, 1, []complex64{0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}},
	{Complex64, 4, 4, 2, []complex64{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Complex64, 4, 4, 3, []complex64{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Complex64, 4, 4, 4, []complex64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Complex64, 4, 4, -1, []complex64{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0}},
	{Complex64, 4, 4, -2, []complex64{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}},
	{Complex64, 4, 4, -3, []complex64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}},
	{Complex64, 4, 4, -4, []complex64{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Complex64, 4, 5, 0, []complex64{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}},
	{Complex64, 4, 5, 1, []complex64{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}},
	{Complex64, 4, 5, -1, []complex64{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}},
	{Complex128, 4, 4, 0, []complex128{1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1}},
	{Complex128, 4, 4, 1, []complex128{0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}},
	{Complex128, 4, 4, 2, []complex128{0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Complex128, 4, 4, 3, []complex128{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Complex128, 4, 4, 4, []complex128{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Complex128, 4, 4, -1, []complex128{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0}},
	{Complex128, 4, 4, -2, []complex128{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0}},
	{Complex128, 4, 4, -3, []complex128{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}},
	{Complex128, 4, 4, -4, []complex128{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{Complex128, 4, 5, 0, []complex128{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0}},
	{Complex128, 4, 5, 1, []complex128{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}},
	{Complex128, 4, 5, -1, []complex128{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0}},
}

func TestI(t *testing.T) {
	assert := assert.New(t)
	var T Tensor

	for i, it := range eyeTests {
		T = I(it.E, it.R, it.C, it.K)
		assert.True(Shape{it.R, it.C}.Eq(T.Shape()))
		assert.Equal(it.correct, T.Data(), "Test %d-R: %d, C: %d K: %d", i, it.R, it.C, it.K)
	}

}
