// +build !windows

package mssql

import (
	"encoding/hex"
	"testing"
)

func TestLMOWFv1(t *testing.T) {
	hash := lmHash("Password")
	val := [21]byte{
		0xe5, 0x2c, 0xac, 0x67, 0x41, 0x9a, 0x9a, 0x22,
		0x4a, 0x3b, 0x10, 0x8f, 0x3f, 0xa6, 0xcb, 0x6d,
		0, 0, 0, 0, 0,
	}
	if hash != val {
		t.Errorf("got:\n%sexpected:\n%s", hex.Dump(hash[:]), hex.Dump(val[:]))
	}
}

func TestNTLMOWFv1(t *testing.T) {
	hash := ntlmHash("Password")
	val := [21]byte{
		0xa4, 0xf4, 0x9c, 0x40, 0x65, 0x10, 0xbd, 0xca, 0xb6, 0x82, 0x4e, 0xe7, 0xc3, 0x0f, 0xd8, 0x52,
		0, 0, 0, 0, 0,
	}
	if hash != val {
		t.Errorf("got:\n%sexpected:\n%s", hex.Dump(hash[:]), hex.Dump(val[:]))
	}
}

func TestNTLMv1Response(t *testing.T) {
	challenge := [8]byte{
		0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
	}
	nt := ntResponse(challenge, "Password")
	val := [24]byte{
		0x67, 0xc4, 0x30, 0x11, 0xf3, 0x02, 0x98, 0xa2, 0xad, 0x35, 0xec, 0xe6, 0x4f, 0x16, 0x33, 0x1c,
		0x44, 0xbd, 0xbe, 0xd9, 0x27, 0x84, 0x1f, 0x94,
	}
	if nt != val {
		t.Errorf("got:\n%sexpected:\n%s", hex.Dump(nt[:]), hex.Dump(val[:]))
	}
}

func TestLMv1Response(t *testing.T) {
	challenge := [8]byte{
		0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
	}
	nt := lmResponse(challenge, "Password")
	val := [24]byte{
		0x98, 0xde, 0xf7, 0xb8, 0x7f, 0x88, 0xaa, 0x5d, 0xaf, 0xe2, 0xdf, 0x77, 0x96, 0x88, 0xa1, 0x72,
		0xde, 0xf1, 0x1c, 0x7d, 0x5c, 0xcd, 0xef, 0x13,
	}
	if nt != val {
		t.Errorf("got:\n%sexpected:\n%s", hex.Dump(nt[:]), hex.Dump(val[:]))
	}
}

func TestNTLMSessionResponse(t *testing.T) {
	challenge := [8]byte{
		0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef,
	}
	nonce := [8]byte{
		0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
	}
	nt := ntlmSessionResponse(nonce, challenge, "Password")
	val := [24]byte{
		0x75, 0x37, 0xf8, 0x03, 0xae, 0x36, 0x71, 0x28, 0xca, 0x45, 0x82, 0x04, 0xbd, 0xe7, 0xca, 0xf8,
		0x1e, 0x97, 0xed, 0x26, 0x83, 0x26, 0x72, 0x32,
	}
	if nt != val {
		t.Errorf("got:\n%sexpected:\n%s", hex.Dump(nt[:]), hex.Dump(val[:]))
	}
}
