// Code generated by smithy-go-codegen DO NOT EDIT.

package snowball

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/snowball/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a job to import or export data between Amazon S3 and your on-premises
// data center. Your Amazon Web Services account must have the right trust policies
// and permissions in place to create a job for a Snow device. If you're creating a
// job for a node in a cluster, you only need to provide the clusterId value; the
// other job attributes are inherited from the cluster.
//
// Only the Snowball; Edge device type is supported when ordering clustered jobs.
//
// The device capacity is optional.
//
// Availability of device types differ by Amazon Web Services Region. For more
// information about Region availability, see [Amazon Web Services Regional Services].
//
// Snow Family devices and their capacities.
//
//   - Device type: SNC1_SSD
//
//   - Capacity: T14
//
//   - Description: Snowcone
//
//   - Device type: SNC1_HDD
//
//   - Capacity: T8
//
//   - Description: Snowcone
//
//   - Device type: EDGE_S
//
//   - Capacity: T98
//
//   - Description: Snowball Edge Storage Optimized for data transfer only
//
//   - Device type: EDGE_CG
//
//   - Capacity: T42
//
//   - Description: Snowball Edge Compute Optimized with GPU
//
//   - Device type: EDGE_C
//
//   - Capacity: T42
//
//   - Description: Snowball Edge Compute Optimized without GPU
//
//   - Device type: EDGE
//
//   - Capacity: T100
//
//   - Description: Snowball Edge Storage Optimized with EC2 Compute
//
// This device is replaced with T98.
//
//   - Device type: STANDARD
//
//   - Capacity: T50
//
//   - Description: Original Snowball device
//
// This device is only available in the Ningxia, Beijing, and Singapore Amazon Web
//
//	Services Region
//
//	- Device type: STANDARD
//
//	- Capacity: T80
//
//	- Description: Original Snowball device
//
// This device is only available in the Ningxia, Beijing, and Singapore Amazon Web
//
//	Services Region.
//
//	- Snow Family device type: RACK_5U_C
//
//	- Capacity: T13
//
//	- Description: Snowblade.
//
//	- Device type: V3_5S
//
//	- Capacity: T240
//
//	- Description: Snowball Edge Storage Optimized 210TB
//
// [Amazon Web Services Regional Services]: https://aws.amazon.com/about-aws/global-infrastructure/regional-product-services/?p=ngi&loc=4
func (c *Client) CreateJob(ctx context.Context, params *CreateJobInput, optFns ...func(*Options)) (*CreateJobOutput, error) {
	if params == nil {
		params = &CreateJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateJob", params, optFns, c.addOperationCreateJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateJobInput struct {

	// The ID for the address that you want the Snow device shipped to.
	AddressId *string

	// The ID of a cluster. If you're creating a job for a node in a cluster, you need
	// to provide only this clusterId value. The other job attributes are inherited
	// from the cluster.
	ClusterId *string

	// Defines an optional description of this specific job, for example Important
	// Photos 2016-08-11 .
	Description *string

	// Defines the device configuration for an Snowcone job.
	//
	// For more information, see
	// "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide or
	// "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide.
	DeviceConfiguration *types.DeviceConfiguration

	// The forwarding address ID for a job. This field is not supported in most
	// Regions.
	ForwardingAddressId *string

	// The highest impact level of data that will be stored or processed on the
	// device, provided at job creation.
	ImpactLevel types.ImpactLevel

	// Defines the type of job that you're creating.
	JobType types.JobType

	// The KmsKeyARN that you want to associate with this job. KmsKeyARN s are created
	// using the [CreateKey]Key Management Service (KMS) API action.
	//
	// [CreateKey]: https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html
	KmsKeyARN *string

	// The ID of the long-term pricing type for the device.
	LongTermPricingId *string

	// Defines the Amazon Simple Notification Service (Amazon SNS) notification
	// settings for this job.
	Notification *types.Notification

	// Specifies the service or services on the Snow Family device that your
	// transferred data will be exported from or imported into. Amazon Web Services
	// Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web
	// Services Storage Gateway service Tape Gateway type.
	OnDeviceServiceConfiguration *types.OnDeviceServiceConfiguration

	// Information identifying the person picking up the device.
	PickupDetails *types.PickupDetails

	// Allows you to securely operate and manage Snowcone devices remotely from
	// outside of your internal network. When set to INSTALLED_AUTOSTART , remote
	// management will automatically be available when the device arrives at your
	// location. Otherwise, you need to use the Snowball Edge client to manage the
	// device. When set to NOT_INSTALLED , remote management will not be available on
	// the device.
	RemoteManagement types.RemoteManagement

	// Defines the Amazon S3 buckets associated with this job.
	//
	// With IMPORT jobs, you specify the bucket or buckets that your transferred data
	// will be imported into.
	//
	// With EXPORT jobs, you specify the bucket or buckets that your transferred data
	// will be exported from. Optionally, you can also specify a KeyRange value. If
	// you choose to export a range, you define the length of the range by providing
	// either an inclusive BeginMarker value, an inclusive EndMarker value, or both.
	// Ranges are UTF-8 binary sorted.
	Resources *types.JobResource

	// The RoleARN that you want to associate with this job. RoleArn s are created
	// using the [CreateRole]Identity and Access Management (IAM) API action.
	//
	// [CreateRole]: https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html
	RoleARN *string

	// The shipping speed for this job. This speed doesn't dictate how soon you'll get
	// the Snow device, rather it represents how quickly the Snow device moves to its
	// destination while in transit. Regional shipping speeds are as follows:
	//
	//   - In Australia, you have access to express shipping. Typically, Snow devices
	//   shipped express are delivered in about a day.
	//
	//   - In the European Union (EU), you have access to express shipping. Typically,
	//   Snow devices shipped express are delivered in about a day. In addition, most
	//   countries in the EU have access to standard shipping, which typically takes less
	//   than a week, one way.
	//
	//   - In India, Snow devices are delivered in one to seven days.
	//
	//   - In the US, you have access to one-day shipping and two-day shipping.
	ShippingOption types.ShippingOption

	// If your job is being created in one of the US regions, you have the option of
	// specifying what size Snow device you'd like for this job. In all other regions,
	// Snowballs come with 80 TB in storage capacity.
	//
	// For more information, see
	// "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide or
	// "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide.
	SnowballCapacityPreference types.SnowballCapacity

	// The type of Snow Family devices to use for this job.
	//
	// For cluster jobs, Amazon Web Services Snow Family currently supports only the
	// EDGE device type.
	//
	// The type of Amazon Web Services Snow device to use for this job. Currently, the
	// only supported device type for cluster jobs is EDGE .
	//
	// For more information, see [Snowball Edge Device Options] in the Snowball Edge Developer Guide.
	//
	// For more information, see
	// "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide or
	// "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html"
	// (Snow Family Devices and Capacity) in the Snowcone User Guide.
	//
	// [Snowball Edge Device Options]: https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html
	SnowballType types.SnowballType

	// The tax documents required in your Amazon Web Services Region.
	TaxDocuments *types.TaxDocuments

	noSmithyDocumentSerde
}

type CreateJobOutput struct {

	// The automatically generated ID for a job, for example
	// JID123e4567-e89b-12d3-a456-426655440000 .
	JobId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateJob",
	}
}
