// Code generated by smithy-go-codegen DO NOT EDIT.

package pipes

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/pipes/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreatePipe struct {
}

func (*awsRestjson1_serializeOpCreatePipe) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePipe) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePipeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/pipes/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreatePipeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePipeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePipeInput(v *CreatePipeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePipeInput(v *CreatePipeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if len(v.DesiredState) > 0 {
		ok := object.Key("DesiredState")
		ok.String(string(v.DesiredState))
	}

	if v.Enrichment != nil {
		ok := object.Key("Enrichment")
		ok.String(*v.Enrichment)
	}

	if v.EnrichmentParameters != nil {
		ok := object.Key("EnrichmentParameters")
		if err := awsRestjson1_serializeDocumentPipeEnrichmentParameters(v.EnrichmentParameters, ok); err != nil {
			return err
		}
	}

	if v.LogConfiguration != nil {
		ok := object.Key("LogConfiguration")
		if err := awsRestjson1_serializeDocumentPipeLogConfigurationParameters(v.LogConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.Source != nil {
		ok := object.Key("Source")
		ok.String(*v.Source)
	}

	if v.SourceParameters != nil {
		ok := object.Key("SourceParameters")
		if err := awsRestjson1_serializeDocumentPipeSourceParameters(v.SourceParameters, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Target != nil {
		ok := object.Key("Target")
		ok.String(*v.Target)
	}

	if v.TargetParameters != nil {
		ok := object.Key("TargetParameters")
		if err := awsRestjson1_serializeDocumentPipeTargetParameters(v.TargetParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePipe struct {
}

func (*awsRestjson1_serializeOpDeletePipe) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePipe) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePipeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/pipes/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePipeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePipeInput(v *DeletePipeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribePipe struct {
}

func (*awsRestjson1_serializeOpDescribePipe) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribePipe) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribePipeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/pipes/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribePipeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribePipeInput(v *DescribePipeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListPipes struct {
}

func (*awsRestjson1_serializeOpListPipes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPipes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPipesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/pipes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPipesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPipesInput(v *ListPipesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.CurrentState) > 0 {
		encoder.SetQuery("CurrentState").String(string(v.CurrentState))
	}

	if len(v.DesiredState) > 0 {
		encoder.SetQuery("DesiredState").String(string(v.DesiredState))
	}

	if v.Limit != nil {
		encoder.SetQuery("Limit").Integer(*v.Limit)
	}

	if v.NamePrefix != nil {
		encoder.SetQuery("NamePrefix").String(*v.NamePrefix)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	if v.SourcePrefix != nil {
		encoder.SetQuery("SourcePrefix").String(*v.SourcePrefix)
	}

	if v.TargetPrefix != nil {
		encoder.SetQuery("TargetPrefix").String(*v.TargetPrefix)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartPipe struct {
}

func (*awsRestjson1_serializeOpStartPipe) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartPipe) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartPipeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/pipes/{Name}/start")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartPipeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartPipeInput(v *StartPipeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopPipe struct {
}

func (*awsRestjson1_serializeOpStopPipe) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopPipe) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopPipeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/pipes/{Name}/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopPipeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopPipeInput(v *StopPipeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdatePipe struct {
}

func (*awsRestjson1_serializeOpUpdatePipe) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdatePipe) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePipeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/pipes/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdatePipeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdatePipeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdatePipeInput(v *UpdatePipeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdatePipeInput(v *UpdatePipeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if len(v.DesiredState) > 0 {
		ok := object.Key("DesiredState")
		ok.String(string(v.DesiredState))
	}

	if v.Enrichment != nil {
		ok := object.Key("Enrichment")
		ok.String(*v.Enrichment)
	}

	if v.EnrichmentParameters != nil {
		ok := object.Key("EnrichmentParameters")
		if err := awsRestjson1_serializeDocumentPipeEnrichmentParameters(v.EnrichmentParameters, ok); err != nil {
			return err
		}
	}

	if v.LogConfiguration != nil {
		ok := object.Key("LogConfiguration")
		if err := awsRestjson1_serializeDocumentPipeLogConfigurationParameters(v.LogConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.SourceParameters != nil {
		ok := object.Key("SourceParameters")
		if err := awsRestjson1_serializeDocumentUpdatePipeSourceParameters(v.SourceParameters, ok); err != nil {
			return err
		}
	}

	if v.Target != nil {
		ok := object.Key("Target")
		ok.String(*v.Target)
	}

	if v.TargetParameters != nil {
		ok := object.Key("TargetParameters")
		if err := awsRestjson1_serializeDocumentPipeTargetParameters(v.TargetParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsVpcConfiguration(v *types.AwsVpcConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AssignPublicIp) > 0 {
		ok := object.Key("AssignPublicIp")
		ok.String(string(v.AssignPublicIp))
	}

	if v.SecurityGroups != nil {
		ok := object.Key("SecurityGroups")
		if err := awsRestjson1_serializeDocumentSecurityGroups(v.SecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.Subnets != nil {
		ok := object.Key("Subnets")
		if err := awsRestjson1_serializeDocumentSubnets(v.Subnets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchArrayProperties(v *types.BatchArrayProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Size != nil {
		ok := object.Key("Size")
		ok.Integer(*v.Size)
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchContainerOverrides(v *types.BatchContainerOverrides, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Command != nil {
		ok := object.Key("Command")
		if err := awsRestjson1_serializeDocumentStringList(v.Command, ok); err != nil {
			return err
		}
	}

	if v.Environment != nil {
		ok := object.Key("Environment")
		if err := awsRestjson1_serializeDocumentBatchEnvironmentVariableList(v.Environment, ok); err != nil {
			return err
		}
	}

	if v.InstanceType != nil {
		ok := object.Key("InstanceType")
		ok.String(*v.InstanceType)
	}

	if v.ResourceRequirements != nil {
		ok := object.Key("ResourceRequirements")
		if err := awsRestjson1_serializeDocumentBatchResourceRequirementsList(v.ResourceRequirements, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchDependsOn(v []types.BatchJobDependency, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBatchJobDependency(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBatchEnvironmentVariable(v *types.BatchEnvironmentVariable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchEnvironmentVariableList(v []types.BatchEnvironmentVariable, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBatchEnvironmentVariable(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBatchJobDependency(v *types.BatchJobDependency, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchParametersMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentBatchResourceRequirement(v *types.BatchResourceRequirement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchResourceRequirementsList(v []types.BatchResourceRequirement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBatchResourceRequirement(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBatchRetryStrategy(v *types.BatchRetryStrategy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attempts != nil {
		ok := object.Key("Attempts")
		ok.Integer(*v.Attempts)
	}

	return nil
}

func awsRestjson1_serializeDocumentCapacityProviderStrategy(v []types.CapacityProviderStrategyItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCapacityProviderStrategyItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCapacityProviderStrategyItem(v *types.CapacityProviderStrategyItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Base != 0 {
		ok := object.Key("base")
		ok.Integer(v.Base)
	}

	if v.CapacityProvider != nil {
		ok := object.Key("capacityProvider")
		ok.String(*v.CapacityProvider)
	}

	if v.Weight != 0 {
		ok := object.Key("weight")
		ok.Integer(v.Weight)
	}

	return nil
}

func awsRestjson1_serializeDocumentCloudwatchLogsLogDestinationParameters(v *types.CloudwatchLogsLogDestinationParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LogGroupArn != nil {
		ok := object.Key("LogGroupArn")
		ok.String(*v.LogGroupArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentDeadLetterConfig(v *types.DeadLetterConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	return nil
}

func awsRestjson1_serializeDocumentDimensionMapping(v *types.DimensionMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DimensionName != nil {
		ok := object.Key("DimensionName")
		ok.String(*v.DimensionName)
	}

	if v.DimensionValue != nil {
		ok := object.Key("DimensionValue")
		ok.String(*v.DimensionValue)
	}

	if len(v.DimensionValueType) > 0 {
		ok := object.Key("DimensionValueType")
		ok.String(string(v.DimensionValueType))
	}

	return nil
}

func awsRestjson1_serializeDocumentDimensionMappings(v []types.DimensionMapping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDimensionMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEcsContainerOverride(v *types.EcsContainerOverride, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Command != nil {
		ok := object.Key("Command")
		if err := awsRestjson1_serializeDocumentStringList(v.Command, ok); err != nil {
			return err
		}
	}

	if v.Cpu != nil {
		ok := object.Key("Cpu")
		ok.Integer(*v.Cpu)
	}

	if v.Environment != nil {
		ok := object.Key("Environment")
		if err := awsRestjson1_serializeDocumentEcsEnvironmentVariableList(v.Environment, ok); err != nil {
			return err
		}
	}

	if v.EnvironmentFiles != nil {
		ok := object.Key("EnvironmentFiles")
		if err := awsRestjson1_serializeDocumentEcsEnvironmentFileList(v.EnvironmentFiles, ok); err != nil {
			return err
		}
	}

	if v.Memory != nil {
		ok := object.Key("Memory")
		ok.Integer(*v.Memory)
	}

	if v.MemoryReservation != nil {
		ok := object.Key("MemoryReservation")
		ok.Integer(*v.MemoryReservation)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ResourceRequirements != nil {
		ok := object.Key("ResourceRequirements")
		if err := awsRestjson1_serializeDocumentEcsResourceRequirementsList(v.ResourceRequirements, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEcsContainerOverrideList(v []types.EcsContainerOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEcsContainerOverride(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEcsEnvironmentFile(v *types.EcsEnvironmentFile, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentEcsEnvironmentFileList(v []types.EcsEnvironmentFile, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEcsEnvironmentFile(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEcsEnvironmentVariable(v *types.EcsEnvironmentVariable, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentEcsEnvironmentVariableList(v []types.EcsEnvironmentVariable, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEcsEnvironmentVariable(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEcsEphemeralStorage(v *types.EcsEphemeralStorage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SizeInGiB != nil {
		ok := object.Key("sizeInGiB")
		ok.Integer(*v.SizeInGiB)
	}

	return nil
}

func awsRestjson1_serializeDocumentEcsInferenceAcceleratorOverride(v *types.EcsInferenceAcceleratorOverride, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceName != nil {
		ok := object.Key("deviceName")
		ok.String(*v.DeviceName)
	}

	if v.DeviceType != nil {
		ok := object.Key("deviceType")
		ok.String(*v.DeviceType)
	}

	return nil
}

func awsRestjson1_serializeDocumentEcsInferenceAcceleratorOverrideList(v []types.EcsInferenceAcceleratorOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEcsInferenceAcceleratorOverride(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEcsResourceRequirement(v *types.EcsResourceRequirement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentEcsResourceRequirementsList(v []types.EcsResourceRequirement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEcsResourceRequirement(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEcsTaskOverride(v *types.EcsTaskOverride, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerOverrides != nil {
		ok := object.Key("ContainerOverrides")
		if err := awsRestjson1_serializeDocumentEcsContainerOverrideList(v.ContainerOverrides, ok); err != nil {
			return err
		}
	}

	if v.Cpu != nil {
		ok := object.Key("Cpu")
		ok.String(*v.Cpu)
	}

	if v.EphemeralStorage != nil {
		ok := object.Key("EphemeralStorage")
		if err := awsRestjson1_serializeDocumentEcsEphemeralStorage(v.EphemeralStorage, ok); err != nil {
			return err
		}
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("ExecutionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.InferenceAcceleratorOverrides != nil {
		ok := object.Key("InferenceAcceleratorOverrides")
		if err := awsRestjson1_serializeDocumentEcsInferenceAcceleratorOverrideList(v.InferenceAcceleratorOverrides, ok); err != nil {
			return err
		}
	}

	if v.Memory != nil {
		ok := object.Key("Memory")
		ok.String(*v.Memory)
	}

	if v.TaskRoleArn != nil {
		ok := object.Key("TaskRoleArn")
		ok.String(*v.TaskRoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentEventBridgeEventResourceList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFilter(v *types.Filter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Pattern != nil {
		ok := object.Key("Pattern")
		ok.String(*v.Pattern)
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterCriteria(v *types.FilterCriteria, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsRestjson1_serializeDocumentFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterList(v []types.Filter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFirehoseLogDestinationParameters(v *types.FirehoseLogDestinationParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryStreamArn != nil {
		ok := object.Key("DeliveryStreamArn")
		ok.String(*v.DeliveryStreamArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentHeaderParametersMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentIncludeExecutionData(v []types.IncludeExecutionDataOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentKafkaBootstrapServers(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentMQBrokerAccessCredentials(v types.MQBrokerAccessCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.MQBrokerAccessCredentialsMemberBasicAuth:
		av := object.Key("BasicAuth")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentMSKAccessCredentials(v types.MSKAccessCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.MSKAccessCredentialsMemberClientCertificateTlsAuth:
		av := object.Key("ClientCertificateTlsAuth")
		av.String(uv.Value)

	case *types.MSKAccessCredentialsMemberSaslScram512Auth:
		av := object.Key("SaslScram512Auth")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentMultiMeasureAttributeMapping(v *types.MultiMeasureAttributeMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MeasureValue != nil {
		ok := object.Key("MeasureValue")
		ok.String(*v.MeasureValue)
	}

	if len(v.MeasureValueType) > 0 {
		ok := object.Key("MeasureValueType")
		ok.String(string(v.MeasureValueType))
	}

	if v.MultiMeasureAttributeName != nil {
		ok := object.Key("MultiMeasureAttributeName")
		ok.String(*v.MultiMeasureAttributeName)
	}

	return nil
}

func awsRestjson1_serializeDocumentMultiMeasureAttributeMappings(v []types.MultiMeasureAttributeMapping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMultiMeasureAttributeMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMultiMeasureMapping(v *types.MultiMeasureMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MultiMeasureAttributeMappings != nil {
		ok := object.Key("MultiMeasureAttributeMappings")
		if err := awsRestjson1_serializeDocumentMultiMeasureAttributeMappings(v.MultiMeasureAttributeMappings, ok); err != nil {
			return err
		}
	}

	if v.MultiMeasureName != nil {
		ok := object.Key("MultiMeasureName")
		ok.String(*v.MultiMeasureName)
	}

	return nil
}

func awsRestjson1_serializeDocumentMultiMeasureMappings(v []types.MultiMeasureMapping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMultiMeasureMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentNetworkConfiguration(v *types.NetworkConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsvpcConfiguration != nil {
		ok := object.Key("awsvpcConfiguration")
		if err := awsRestjson1_serializeDocumentAwsVpcConfiguration(v.AwsvpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPathParameterList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentPipeEnrichmentHttpParameters(v *types.PipeEnrichmentHttpParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HeaderParameters != nil {
		ok := object.Key("HeaderParameters")
		if err := awsRestjson1_serializeDocumentHeaderParametersMap(v.HeaderParameters, ok); err != nil {
			return err
		}
	}

	if v.PathParameterValues != nil {
		ok := object.Key("PathParameterValues")
		if err := awsRestjson1_serializeDocumentPathParameterList(v.PathParameterValues, ok); err != nil {
			return err
		}
	}

	if v.QueryStringParameters != nil {
		ok := object.Key("QueryStringParameters")
		if err := awsRestjson1_serializeDocumentQueryStringParametersMap(v.QueryStringParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeEnrichmentParameters(v *types.PipeEnrichmentParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HttpParameters != nil {
		ok := object.Key("HttpParameters")
		if err := awsRestjson1_serializeDocumentPipeEnrichmentHttpParameters(v.HttpParameters, ok); err != nil {
			return err
		}
	}

	if v.InputTemplate != nil {
		ok := object.Key("InputTemplate")
		ok.String(*v.InputTemplate)
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeLogConfigurationParameters(v *types.PipeLogConfigurationParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudwatchLogsLogDestination != nil {
		ok := object.Key("CloudwatchLogsLogDestination")
		if err := awsRestjson1_serializeDocumentCloudwatchLogsLogDestinationParameters(v.CloudwatchLogsLogDestination, ok); err != nil {
			return err
		}
	}

	if v.FirehoseLogDestination != nil {
		ok := object.Key("FirehoseLogDestination")
		if err := awsRestjson1_serializeDocumentFirehoseLogDestinationParameters(v.FirehoseLogDestination, ok); err != nil {
			return err
		}
	}

	if v.IncludeExecutionData != nil {
		ok := object.Key("IncludeExecutionData")
		if err := awsRestjson1_serializeDocumentIncludeExecutionData(v.IncludeExecutionData, ok); err != nil {
			return err
		}
	}

	if len(v.Level) > 0 {
		ok := object.Key("Level")
		ok.String(string(v.Level))
	}

	if v.S3LogDestination != nil {
		ok := object.Key("S3LogDestination")
		if err := awsRestjson1_serializeDocumentS3LogDestinationParameters(v.S3LogDestination, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeSourceActiveMQBrokerParameters(v *types.PipeSourceActiveMQBrokerParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.Credentials != nil {
		ok := object.Key("Credentials")
		if err := awsRestjson1_serializeDocumentMQBrokerAccessCredentials(v.Credentials, ok); err != nil {
			return err
		}
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	if v.QueueName != nil {
		ok := object.Key("QueueName")
		ok.String(*v.QueueName)
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeSourceDynamoDBStreamParameters(v *types.PipeSourceDynamoDBStreamParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.DeadLetterConfig != nil {
		ok := object.Key("DeadLetterConfig")
		if err := awsRestjson1_serializeDocumentDeadLetterConfig(v.DeadLetterConfig, ok); err != nil {
			return err
		}
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	if v.MaximumRecordAgeInSeconds != nil {
		ok := object.Key("MaximumRecordAgeInSeconds")
		ok.Integer(*v.MaximumRecordAgeInSeconds)
	}

	if v.MaximumRetryAttempts != nil {
		ok := object.Key("MaximumRetryAttempts")
		ok.Integer(*v.MaximumRetryAttempts)
	}

	if len(v.OnPartialBatchItemFailure) > 0 {
		ok := object.Key("OnPartialBatchItemFailure")
		ok.String(string(v.OnPartialBatchItemFailure))
	}

	if v.ParallelizationFactor != nil {
		ok := object.Key("ParallelizationFactor")
		ok.Integer(*v.ParallelizationFactor)
	}

	if len(v.StartingPosition) > 0 {
		ok := object.Key("StartingPosition")
		ok.String(string(v.StartingPosition))
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeSourceKinesisStreamParameters(v *types.PipeSourceKinesisStreamParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.DeadLetterConfig != nil {
		ok := object.Key("DeadLetterConfig")
		if err := awsRestjson1_serializeDocumentDeadLetterConfig(v.DeadLetterConfig, ok); err != nil {
			return err
		}
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	if v.MaximumRecordAgeInSeconds != nil {
		ok := object.Key("MaximumRecordAgeInSeconds")
		ok.Integer(*v.MaximumRecordAgeInSeconds)
	}

	if v.MaximumRetryAttempts != nil {
		ok := object.Key("MaximumRetryAttempts")
		ok.Integer(*v.MaximumRetryAttempts)
	}

	if len(v.OnPartialBatchItemFailure) > 0 {
		ok := object.Key("OnPartialBatchItemFailure")
		ok.String(string(v.OnPartialBatchItemFailure))
	}

	if v.ParallelizationFactor != nil {
		ok := object.Key("ParallelizationFactor")
		ok.Integer(*v.ParallelizationFactor)
	}

	if len(v.StartingPosition) > 0 {
		ok := object.Key("StartingPosition")
		ok.String(string(v.StartingPosition))
	}

	if v.StartingPositionTimestamp != nil {
		ok := object.Key("StartingPositionTimestamp")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartingPositionTimestamp))
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeSourceManagedStreamingKafkaParameters(v *types.PipeSourceManagedStreamingKafkaParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.ConsumerGroupID != nil {
		ok := object.Key("ConsumerGroupID")
		ok.String(*v.ConsumerGroupID)
	}

	if v.Credentials != nil {
		ok := object.Key("Credentials")
		if err := awsRestjson1_serializeDocumentMSKAccessCredentials(v.Credentials, ok); err != nil {
			return err
		}
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	if len(v.StartingPosition) > 0 {
		ok := object.Key("StartingPosition")
		ok.String(string(v.StartingPosition))
	}

	if v.TopicName != nil {
		ok := object.Key("TopicName")
		ok.String(*v.TopicName)
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeSourceParameters(v *types.PipeSourceParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActiveMQBrokerParameters != nil {
		ok := object.Key("ActiveMQBrokerParameters")
		if err := awsRestjson1_serializeDocumentPipeSourceActiveMQBrokerParameters(v.ActiveMQBrokerParameters, ok); err != nil {
			return err
		}
	}

	if v.DynamoDBStreamParameters != nil {
		ok := object.Key("DynamoDBStreamParameters")
		if err := awsRestjson1_serializeDocumentPipeSourceDynamoDBStreamParameters(v.DynamoDBStreamParameters, ok); err != nil {
			return err
		}
	}

	if v.FilterCriteria != nil {
		ok := object.Key("FilterCriteria")
		if err := awsRestjson1_serializeDocumentFilterCriteria(v.FilterCriteria, ok); err != nil {
			return err
		}
	}

	if v.KinesisStreamParameters != nil {
		ok := object.Key("KinesisStreamParameters")
		if err := awsRestjson1_serializeDocumentPipeSourceKinesisStreamParameters(v.KinesisStreamParameters, ok); err != nil {
			return err
		}
	}

	if v.ManagedStreamingKafkaParameters != nil {
		ok := object.Key("ManagedStreamingKafkaParameters")
		if err := awsRestjson1_serializeDocumentPipeSourceManagedStreamingKafkaParameters(v.ManagedStreamingKafkaParameters, ok); err != nil {
			return err
		}
	}

	if v.RabbitMQBrokerParameters != nil {
		ok := object.Key("RabbitMQBrokerParameters")
		if err := awsRestjson1_serializeDocumentPipeSourceRabbitMQBrokerParameters(v.RabbitMQBrokerParameters, ok); err != nil {
			return err
		}
	}

	if v.SelfManagedKafkaParameters != nil {
		ok := object.Key("SelfManagedKafkaParameters")
		if err := awsRestjson1_serializeDocumentPipeSourceSelfManagedKafkaParameters(v.SelfManagedKafkaParameters, ok); err != nil {
			return err
		}
	}

	if v.SqsQueueParameters != nil {
		ok := object.Key("SqsQueueParameters")
		if err := awsRestjson1_serializeDocumentPipeSourceSqsQueueParameters(v.SqsQueueParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeSourceRabbitMQBrokerParameters(v *types.PipeSourceRabbitMQBrokerParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.Credentials != nil {
		ok := object.Key("Credentials")
		if err := awsRestjson1_serializeDocumentMQBrokerAccessCredentials(v.Credentials, ok); err != nil {
			return err
		}
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	if v.QueueName != nil {
		ok := object.Key("QueueName")
		ok.String(*v.QueueName)
	}

	if v.VirtualHost != nil {
		ok := object.Key("VirtualHost")
		ok.String(*v.VirtualHost)
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeSourceSelfManagedKafkaParameters(v *types.PipeSourceSelfManagedKafkaParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalBootstrapServers != nil {
		ok := object.Key("AdditionalBootstrapServers")
		if err := awsRestjson1_serializeDocumentKafkaBootstrapServers(v.AdditionalBootstrapServers, ok); err != nil {
			return err
		}
	}

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.ConsumerGroupID != nil {
		ok := object.Key("ConsumerGroupID")
		ok.String(*v.ConsumerGroupID)
	}

	if v.Credentials != nil {
		ok := object.Key("Credentials")
		if err := awsRestjson1_serializeDocumentSelfManagedKafkaAccessConfigurationCredentials(v.Credentials, ok); err != nil {
			return err
		}
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	if v.ServerRootCaCertificate != nil {
		ok := object.Key("ServerRootCaCertificate")
		ok.String(*v.ServerRootCaCertificate)
	}

	if len(v.StartingPosition) > 0 {
		ok := object.Key("StartingPosition")
		ok.String(string(v.StartingPosition))
	}

	if v.TopicName != nil {
		ok := object.Key("TopicName")
		ok.String(*v.TopicName)
	}

	if v.Vpc != nil {
		ok := object.Key("Vpc")
		if err := awsRestjson1_serializeDocumentSelfManagedKafkaAccessConfigurationVpc(v.Vpc, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeSourceSqsQueueParameters(v *types.PipeSourceSqsQueueParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeTargetBatchJobParameters(v *types.PipeTargetBatchJobParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ArrayProperties != nil {
		ok := object.Key("ArrayProperties")
		if err := awsRestjson1_serializeDocumentBatchArrayProperties(v.ArrayProperties, ok); err != nil {
			return err
		}
	}

	if v.ContainerOverrides != nil {
		ok := object.Key("ContainerOverrides")
		if err := awsRestjson1_serializeDocumentBatchContainerOverrides(v.ContainerOverrides, ok); err != nil {
			return err
		}
	}

	if v.DependsOn != nil {
		ok := object.Key("DependsOn")
		if err := awsRestjson1_serializeDocumentBatchDependsOn(v.DependsOn, ok); err != nil {
			return err
		}
	}

	if v.JobDefinition != nil {
		ok := object.Key("JobDefinition")
		ok.String(*v.JobDefinition)
	}

	if v.JobName != nil {
		ok := object.Key("JobName")
		ok.String(*v.JobName)
	}

	if v.Parameters != nil {
		ok := object.Key("Parameters")
		if err := awsRestjson1_serializeDocumentBatchParametersMap(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.RetryStrategy != nil {
		ok := object.Key("RetryStrategy")
		if err := awsRestjson1_serializeDocumentBatchRetryStrategy(v.RetryStrategy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeTargetCloudWatchLogsParameters(v *types.PipeTargetCloudWatchLogsParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LogStreamName != nil {
		ok := object.Key("LogStreamName")
		ok.String(*v.LogStreamName)
	}

	if v.Timestamp != nil {
		ok := object.Key("Timestamp")
		ok.String(*v.Timestamp)
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeTargetEcsTaskParameters(v *types.PipeTargetEcsTaskParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityProviderStrategy != nil {
		ok := object.Key("CapacityProviderStrategy")
		if err := awsRestjson1_serializeDocumentCapacityProviderStrategy(v.CapacityProviderStrategy, ok); err != nil {
			return err
		}
	}

	if v.EnableECSManagedTags {
		ok := object.Key("EnableECSManagedTags")
		ok.Boolean(v.EnableECSManagedTags)
	}

	if v.EnableExecuteCommand {
		ok := object.Key("EnableExecuteCommand")
		ok.Boolean(v.EnableExecuteCommand)
	}

	if v.Group != nil {
		ok := object.Key("Group")
		ok.String(*v.Group)
	}

	if len(v.LaunchType) > 0 {
		ok := object.Key("LaunchType")
		ok.String(string(v.LaunchType))
	}

	if v.NetworkConfiguration != nil {
		ok := object.Key("NetworkConfiguration")
		if err := awsRestjson1_serializeDocumentNetworkConfiguration(v.NetworkConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Overrides != nil {
		ok := object.Key("Overrides")
		if err := awsRestjson1_serializeDocumentEcsTaskOverride(v.Overrides, ok); err != nil {
			return err
		}
	}

	if v.PlacementConstraints != nil {
		ok := object.Key("PlacementConstraints")
		if err := awsRestjson1_serializeDocumentPlacementConstraints(v.PlacementConstraints, ok); err != nil {
			return err
		}
	}

	if v.PlacementStrategy != nil {
		ok := object.Key("PlacementStrategy")
		if err := awsRestjson1_serializeDocumentPlacementStrategies(v.PlacementStrategy, ok); err != nil {
			return err
		}
	}

	if v.PlatformVersion != nil {
		ok := object.Key("PlatformVersion")
		ok.String(*v.PlatformVersion)
	}

	if len(v.PropagateTags) > 0 {
		ok := object.Key("PropagateTags")
		ok.String(string(v.PropagateTags))
	}

	if v.ReferenceId != nil {
		ok := object.Key("ReferenceId")
		ok.String(*v.ReferenceId)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TaskCount != nil {
		ok := object.Key("TaskCount")
		ok.Integer(*v.TaskCount)
	}

	if v.TaskDefinitionArn != nil {
		ok := object.Key("TaskDefinitionArn")
		ok.String(*v.TaskDefinitionArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeTargetEventBridgeEventBusParameters(v *types.PipeTargetEventBridgeEventBusParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DetailType != nil {
		ok := object.Key("DetailType")
		ok.String(*v.DetailType)
	}

	if v.EndpointId != nil {
		ok := object.Key("EndpointId")
		ok.String(*v.EndpointId)
	}

	if v.Resources != nil {
		ok := object.Key("Resources")
		if err := awsRestjson1_serializeDocumentEventBridgeEventResourceList(v.Resources, ok); err != nil {
			return err
		}
	}

	if v.Source != nil {
		ok := object.Key("Source")
		ok.String(*v.Source)
	}

	if v.Time != nil {
		ok := object.Key("Time")
		ok.String(*v.Time)
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeTargetHttpParameters(v *types.PipeTargetHttpParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HeaderParameters != nil {
		ok := object.Key("HeaderParameters")
		if err := awsRestjson1_serializeDocumentHeaderParametersMap(v.HeaderParameters, ok); err != nil {
			return err
		}
	}

	if v.PathParameterValues != nil {
		ok := object.Key("PathParameterValues")
		if err := awsRestjson1_serializeDocumentPathParameterList(v.PathParameterValues, ok); err != nil {
			return err
		}
	}

	if v.QueryStringParameters != nil {
		ok := object.Key("QueryStringParameters")
		if err := awsRestjson1_serializeDocumentQueryStringParametersMap(v.QueryStringParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeTargetKinesisStreamParameters(v *types.PipeTargetKinesisStreamParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PartitionKey != nil {
		ok := object.Key("PartitionKey")
		ok.String(*v.PartitionKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeTargetLambdaFunctionParameters(v *types.PipeTargetLambdaFunctionParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InvocationType) > 0 {
		ok := object.Key("InvocationType")
		ok.String(string(v.InvocationType))
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeTargetParameters(v *types.PipeTargetParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchJobParameters != nil {
		ok := object.Key("BatchJobParameters")
		if err := awsRestjson1_serializeDocumentPipeTargetBatchJobParameters(v.BatchJobParameters, ok); err != nil {
			return err
		}
	}

	if v.CloudWatchLogsParameters != nil {
		ok := object.Key("CloudWatchLogsParameters")
		if err := awsRestjson1_serializeDocumentPipeTargetCloudWatchLogsParameters(v.CloudWatchLogsParameters, ok); err != nil {
			return err
		}
	}

	if v.EcsTaskParameters != nil {
		ok := object.Key("EcsTaskParameters")
		if err := awsRestjson1_serializeDocumentPipeTargetEcsTaskParameters(v.EcsTaskParameters, ok); err != nil {
			return err
		}
	}

	if v.EventBridgeEventBusParameters != nil {
		ok := object.Key("EventBridgeEventBusParameters")
		if err := awsRestjson1_serializeDocumentPipeTargetEventBridgeEventBusParameters(v.EventBridgeEventBusParameters, ok); err != nil {
			return err
		}
	}

	if v.HttpParameters != nil {
		ok := object.Key("HttpParameters")
		if err := awsRestjson1_serializeDocumentPipeTargetHttpParameters(v.HttpParameters, ok); err != nil {
			return err
		}
	}

	if v.InputTemplate != nil {
		ok := object.Key("InputTemplate")
		ok.String(*v.InputTemplate)
	}

	if v.KinesisStreamParameters != nil {
		ok := object.Key("KinesisStreamParameters")
		if err := awsRestjson1_serializeDocumentPipeTargetKinesisStreamParameters(v.KinesisStreamParameters, ok); err != nil {
			return err
		}
	}

	if v.LambdaFunctionParameters != nil {
		ok := object.Key("LambdaFunctionParameters")
		if err := awsRestjson1_serializeDocumentPipeTargetLambdaFunctionParameters(v.LambdaFunctionParameters, ok); err != nil {
			return err
		}
	}

	if v.RedshiftDataParameters != nil {
		ok := object.Key("RedshiftDataParameters")
		if err := awsRestjson1_serializeDocumentPipeTargetRedshiftDataParameters(v.RedshiftDataParameters, ok); err != nil {
			return err
		}
	}

	if v.SageMakerPipelineParameters != nil {
		ok := object.Key("SageMakerPipelineParameters")
		if err := awsRestjson1_serializeDocumentPipeTargetSageMakerPipelineParameters(v.SageMakerPipelineParameters, ok); err != nil {
			return err
		}
	}

	if v.SqsQueueParameters != nil {
		ok := object.Key("SqsQueueParameters")
		if err := awsRestjson1_serializeDocumentPipeTargetSqsQueueParameters(v.SqsQueueParameters, ok); err != nil {
			return err
		}
	}

	if v.StepFunctionStateMachineParameters != nil {
		ok := object.Key("StepFunctionStateMachineParameters")
		if err := awsRestjson1_serializeDocumentPipeTargetStateMachineParameters(v.StepFunctionStateMachineParameters, ok); err != nil {
			return err
		}
	}

	if v.TimestreamParameters != nil {
		ok := object.Key("TimestreamParameters")
		if err := awsRestjson1_serializeDocumentPipeTargetTimestreamParameters(v.TimestreamParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeTargetRedshiftDataParameters(v *types.PipeTargetRedshiftDataParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Database != nil {
		ok := object.Key("Database")
		ok.String(*v.Database)
	}

	if v.DbUser != nil {
		ok := object.Key("DbUser")
		ok.String(*v.DbUser)
	}

	if v.SecretManagerArn != nil {
		ok := object.Key("SecretManagerArn")
		ok.String(*v.SecretManagerArn)
	}

	if v.Sqls != nil {
		ok := object.Key("Sqls")
		if err := awsRestjson1_serializeDocumentSqls(v.Sqls, ok); err != nil {
			return err
		}
	}

	if v.StatementName != nil {
		ok := object.Key("StatementName")
		ok.String(*v.StatementName)
	}

	if v.WithEvent {
		ok := object.Key("WithEvent")
		ok.Boolean(v.WithEvent)
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeTargetSageMakerPipelineParameters(v *types.PipeTargetSageMakerPipelineParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PipelineParameterList != nil {
		ok := object.Key("PipelineParameterList")
		if err := awsRestjson1_serializeDocumentSageMakerPipelineParameterList(v.PipelineParameterList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeTargetSqsQueueParameters(v *types.PipeTargetSqsQueueParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MessageDeduplicationId != nil {
		ok := object.Key("MessageDeduplicationId")
		ok.String(*v.MessageDeduplicationId)
	}

	if v.MessageGroupId != nil {
		ok := object.Key("MessageGroupId")
		ok.String(*v.MessageGroupId)
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeTargetStateMachineParameters(v *types.PipeTargetStateMachineParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InvocationType) > 0 {
		ok := object.Key("InvocationType")
		ok.String(string(v.InvocationType))
	}

	return nil
}

func awsRestjson1_serializeDocumentPipeTargetTimestreamParameters(v *types.PipeTargetTimestreamParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DimensionMappings != nil {
		ok := object.Key("DimensionMappings")
		if err := awsRestjson1_serializeDocumentDimensionMappings(v.DimensionMappings, ok); err != nil {
			return err
		}
	}

	if len(v.EpochTimeUnit) > 0 {
		ok := object.Key("EpochTimeUnit")
		ok.String(string(v.EpochTimeUnit))
	}

	if v.MultiMeasureMappings != nil {
		ok := object.Key("MultiMeasureMappings")
		if err := awsRestjson1_serializeDocumentMultiMeasureMappings(v.MultiMeasureMappings, ok); err != nil {
			return err
		}
	}

	if v.SingleMeasureMappings != nil {
		ok := object.Key("SingleMeasureMappings")
		if err := awsRestjson1_serializeDocumentSingleMeasureMappings(v.SingleMeasureMappings, ok); err != nil {
			return err
		}
	}

	if len(v.TimeFieldType) > 0 {
		ok := object.Key("TimeFieldType")
		ok.String(string(v.TimeFieldType))
	}

	if v.TimestampFormat != nil {
		ok := object.Key("TimestampFormat")
		ok.String(*v.TimestampFormat)
	}

	if v.TimeValue != nil {
		ok := object.Key("TimeValue")
		ok.String(*v.TimeValue)
	}

	if v.VersionValue != nil {
		ok := object.Key("VersionValue")
		ok.String(*v.VersionValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentPlacementConstraint(v *types.PlacementConstraint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Expression != nil {
		ok := object.Key("expression")
		ok.String(*v.Expression)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentPlacementConstraints(v []types.PlacementConstraint, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPlacementConstraint(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPlacementStrategies(v []types.PlacementStrategy, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPlacementStrategy(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPlacementStrategy(v *types.PlacementStrategy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Field != nil {
		ok := object.Key("field")
		ok.String(*v.Field)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentQueryStringParametersMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentS3LogDestinationParameters(v *types.S3LogDestinationParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("BucketName")
		ok.String(*v.BucketName)
	}

	if v.BucketOwner != nil {
		ok := object.Key("BucketOwner")
		ok.String(*v.BucketOwner)
	}

	if len(v.OutputFormat) > 0 {
		ok := object.Key("OutputFormat")
		ok.String(string(v.OutputFormat))
	}

	if v.Prefix != nil {
		ok := object.Key("Prefix")
		ok.String(*v.Prefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentSageMakerPipelineParameter(v *types.SageMakerPipelineParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentSageMakerPipelineParameterList(v []types.SageMakerPipelineParameter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSageMakerPipelineParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSecurityGroups(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSelfManagedKafkaAccessConfigurationCredentials(v types.SelfManagedKafkaAccessConfigurationCredentials, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.SelfManagedKafkaAccessConfigurationCredentialsMemberBasicAuth:
		av := object.Key("BasicAuth")
		av.String(uv.Value)

	case *types.SelfManagedKafkaAccessConfigurationCredentialsMemberClientCertificateTlsAuth:
		av := object.Key("ClientCertificateTlsAuth")
		av.String(uv.Value)

	case *types.SelfManagedKafkaAccessConfigurationCredentialsMemberSaslScram256Auth:
		av := object.Key("SaslScram256Auth")
		av.String(uv.Value)

	case *types.SelfManagedKafkaAccessConfigurationCredentialsMemberSaslScram512Auth:
		av := object.Key("SaslScram512Auth")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentSelfManagedKafkaAccessConfigurationVpc(v *types.SelfManagedKafkaAccessConfigurationVpc, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroup != nil {
		ok := object.Key("SecurityGroup")
		if err := awsRestjson1_serializeDocumentSecurityGroupIds(v.SecurityGroup, ok); err != nil {
			return err
		}
	}

	if v.Subnets != nil {
		ok := object.Key("Subnets")
		if err := awsRestjson1_serializeDocumentSubnetIds(v.Subnets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSingleMeasureMapping(v *types.SingleMeasureMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MeasureName != nil {
		ok := object.Key("MeasureName")
		ok.String(*v.MeasureName)
	}

	if v.MeasureValue != nil {
		ok := object.Key("MeasureValue")
		ok.String(*v.MeasureValue)
	}

	if len(v.MeasureValueType) > 0 {
		ok := object.Key("MeasureValueType")
		ok.String(string(v.MeasureValueType))
	}

	return nil
}

func awsRestjson1_serializeDocumentSingleMeasureMappings(v []types.SingleMeasureMapping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSingleMeasureMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSqls(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSubnetIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSubnets(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentUpdatePipeSourceActiveMQBrokerParameters(v *types.UpdatePipeSourceActiveMQBrokerParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.Credentials != nil {
		ok := object.Key("Credentials")
		if err := awsRestjson1_serializeDocumentMQBrokerAccessCredentials(v.Credentials, ok); err != nil {
			return err
		}
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdatePipeSourceDynamoDBStreamParameters(v *types.UpdatePipeSourceDynamoDBStreamParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.DeadLetterConfig != nil {
		ok := object.Key("DeadLetterConfig")
		if err := awsRestjson1_serializeDocumentDeadLetterConfig(v.DeadLetterConfig, ok); err != nil {
			return err
		}
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	if v.MaximumRecordAgeInSeconds != nil {
		ok := object.Key("MaximumRecordAgeInSeconds")
		ok.Integer(*v.MaximumRecordAgeInSeconds)
	}

	if v.MaximumRetryAttempts != nil {
		ok := object.Key("MaximumRetryAttempts")
		ok.Integer(*v.MaximumRetryAttempts)
	}

	if len(v.OnPartialBatchItemFailure) > 0 {
		ok := object.Key("OnPartialBatchItemFailure")
		ok.String(string(v.OnPartialBatchItemFailure))
	}

	if v.ParallelizationFactor != nil {
		ok := object.Key("ParallelizationFactor")
		ok.Integer(*v.ParallelizationFactor)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdatePipeSourceKinesisStreamParameters(v *types.UpdatePipeSourceKinesisStreamParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.DeadLetterConfig != nil {
		ok := object.Key("DeadLetterConfig")
		if err := awsRestjson1_serializeDocumentDeadLetterConfig(v.DeadLetterConfig, ok); err != nil {
			return err
		}
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	if v.MaximumRecordAgeInSeconds != nil {
		ok := object.Key("MaximumRecordAgeInSeconds")
		ok.Integer(*v.MaximumRecordAgeInSeconds)
	}

	if v.MaximumRetryAttempts != nil {
		ok := object.Key("MaximumRetryAttempts")
		ok.Integer(*v.MaximumRetryAttempts)
	}

	if len(v.OnPartialBatchItemFailure) > 0 {
		ok := object.Key("OnPartialBatchItemFailure")
		ok.String(string(v.OnPartialBatchItemFailure))
	}

	if v.ParallelizationFactor != nil {
		ok := object.Key("ParallelizationFactor")
		ok.Integer(*v.ParallelizationFactor)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdatePipeSourceManagedStreamingKafkaParameters(v *types.UpdatePipeSourceManagedStreamingKafkaParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.Credentials != nil {
		ok := object.Key("Credentials")
		if err := awsRestjson1_serializeDocumentMSKAccessCredentials(v.Credentials, ok); err != nil {
			return err
		}
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdatePipeSourceParameters(v *types.UpdatePipeSourceParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActiveMQBrokerParameters != nil {
		ok := object.Key("ActiveMQBrokerParameters")
		if err := awsRestjson1_serializeDocumentUpdatePipeSourceActiveMQBrokerParameters(v.ActiveMQBrokerParameters, ok); err != nil {
			return err
		}
	}

	if v.DynamoDBStreamParameters != nil {
		ok := object.Key("DynamoDBStreamParameters")
		if err := awsRestjson1_serializeDocumentUpdatePipeSourceDynamoDBStreamParameters(v.DynamoDBStreamParameters, ok); err != nil {
			return err
		}
	}

	if v.FilterCriteria != nil {
		ok := object.Key("FilterCriteria")
		if err := awsRestjson1_serializeDocumentFilterCriteria(v.FilterCriteria, ok); err != nil {
			return err
		}
	}

	if v.KinesisStreamParameters != nil {
		ok := object.Key("KinesisStreamParameters")
		if err := awsRestjson1_serializeDocumentUpdatePipeSourceKinesisStreamParameters(v.KinesisStreamParameters, ok); err != nil {
			return err
		}
	}

	if v.ManagedStreamingKafkaParameters != nil {
		ok := object.Key("ManagedStreamingKafkaParameters")
		if err := awsRestjson1_serializeDocumentUpdatePipeSourceManagedStreamingKafkaParameters(v.ManagedStreamingKafkaParameters, ok); err != nil {
			return err
		}
	}

	if v.RabbitMQBrokerParameters != nil {
		ok := object.Key("RabbitMQBrokerParameters")
		if err := awsRestjson1_serializeDocumentUpdatePipeSourceRabbitMQBrokerParameters(v.RabbitMQBrokerParameters, ok); err != nil {
			return err
		}
	}

	if v.SelfManagedKafkaParameters != nil {
		ok := object.Key("SelfManagedKafkaParameters")
		if err := awsRestjson1_serializeDocumentUpdatePipeSourceSelfManagedKafkaParameters(v.SelfManagedKafkaParameters, ok); err != nil {
			return err
		}
	}

	if v.SqsQueueParameters != nil {
		ok := object.Key("SqsQueueParameters")
		if err := awsRestjson1_serializeDocumentUpdatePipeSourceSqsQueueParameters(v.SqsQueueParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdatePipeSourceRabbitMQBrokerParameters(v *types.UpdatePipeSourceRabbitMQBrokerParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.Credentials != nil {
		ok := object.Key("Credentials")
		if err := awsRestjson1_serializeDocumentMQBrokerAccessCredentials(v.Credentials, ok); err != nil {
			return err
		}
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdatePipeSourceSelfManagedKafkaParameters(v *types.UpdatePipeSourceSelfManagedKafkaParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.Credentials != nil {
		ok := object.Key("Credentials")
		if err := awsRestjson1_serializeDocumentSelfManagedKafkaAccessConfigurationCredentials(v.Credentials, ok); err != nil {
			return err
		}
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	if v.ServerRootCaCertificate != nil {
		ok := object.Key("ServerRootCaCertificate")
		ok.String(*v.ServerRootCaCertificate)
	}

	if v.Vpc != nil {
		ok := object.Key("Vpc")
		if err := awsRestjson1_serializeDocumentSelfManagedKafkaAccessConfigurationVpc(v.Vpc, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdatePipeSourceSqsQueueParameters(v *types.UpdatePipeSourceSqsQueueParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchSize != nil {
		ok := object.Key("BatchSize")
		ok.Integer(*v.BatchSize)
	}

	if v.MaximumBatchingWindowInSeconds != nil {
		ok := object.Key("MaximumBatchingWindowInSeconds")
		ok.Integer(*v.MaximumBatchingWindowInSeconds)
	}

	return nil
}
