static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 1997 Miles O'Neal <meo@rru.com>  http://www.rru.com/~meo/        \n"
" * Copyright 2012 Maxime Nicco <maxime.nicco@gmail.com>                       \n"
" */                                                                           \n"
"                                                                              \n"
"/*                                                                            \n"
" *  HURL Operation                                                            \n"
" *      We just assign a random value at the current pixel                    \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"                                                                              \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (pct_random, _(\"Randomization (%)\"), 50.0)                  \n"
"    value_range (0.0, 100.0)                                                  \n"
"                                                                              \n"
"property_int   (repeat, _(\"Repeat\"), 1)                                     \n"
"   value_range (1, 100)                                                       \n"
"                                                                              \n"
"property_seed (seed, _(\"Random seed\"), rand)                                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_C_SOURCE noise-hurl.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\" , babl_format (\"R'G'B'A float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o       = GEGL_PROPERTIES (operation);                      \n"
"  gfloat         *in_pix  = in_buf;                                           \n"
"  gfloat         *out_pix = out_buf;                                          \n"
"  GeglRectangle  *whole_region;                                               \n"
"  gint            total_size, cnt;                                            \n"
"  gint            x, y;                                                       \n"
"                                                                              \n"
"  whole_region = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"  total_size   = whole_region->width * whole_region->height;                  \n"
"                                                                              \n"
"  for (y = roi->y; y < roi->y + roi->height; y++)                             \n"
"    for (x = roi->x; x < roi->x + roi->width; x++)                            \n"
"      {                                                                       \n"
"        gfloat red, green, blue, alpha;                                       \n"
"        gint   idx = x + whole_region->width * y;                             \n"
"                                                                              \n"
"        red   = in_pix[0];                                                    \n"
"        green = in_pix[1];                                                    \n"
"        blue  = in_pix[2];                                                    \n"
"        alpha = in_pix[3];                                                    \n"
"                                                                              \n"
"        for (cnt = o->repeat - 1; cnt >= 0; cnt--)                            \n"
"          {                                                                   \n"
"            gint n = 4 * (idx + cnt * total_size);                            \n"
"                                                                              \n"
"            if (gegl_random_float_range (o->rand, x, y, 0, n, 0.0, 100.0) <=  \n"
"                o->pct_random)                                                \n"
"              {                                                               \n"
"                red   = gegl_random_float (o->rand, x, y, 0, n+1);            \n"
"                green = gegl_random_float (o->rand, x, y, 0, n+2);            \n"
"                blue  = gegl_random_float (o->rand, x, y, 0, n+3);            \n"
"                break;                                                        \n"
"              }                                                               \n"
"          }                                                                   \n"
"                                                                              \n"
"        out_pix[0] = red;                                                     \n"
"        out_pix[1] = green;                                                   \n"
"        out_pix[2] = blue;                                                    \n"
"        out_pix[3] = alpha;                                                   \n"
"                                                                              \n"
"        out_pix += 4;                                                         \n"
"        in_pix  += 4;                                                         \n"
"      }                                                                       \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"opencl/noise-hurl.cl.h\"                                           \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            cl_mem              in,                                           \n"
"            cl_mem              out,                                          \n"
"            size_t              global_worksize,                              \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                level)                                        \n"
"{                                                                             \n"
"  GeglProperties    *o          = GEGL_PROPERTIES (operation);                \n"
"  GeglRectangle *wr         = gegl_operation_source_get_bounding_box (operation,\n"
"                                                                      \"input\");\n"
"  cl_int      cl_err           = 0;                                           \n"
"  cl_mem      cl_random_data   = NULL;                                        \n"
"  cl_float    pct_random       = o->pct_random;                               \n"
"  cl_int      x_offset         = roi->x;                                      \n"
"  cl_int      y_offset         = roi->y;                                      \n"
"  cl_int      roi_width        = roi->width;                                  \n"
"  cl_int      wr_width         = wr->width;                                   \n"
"  int         total_size       = wr->width*wr->height;                        \n"
"  cl_int      offset;                                                         \n"
"  int         it;                                                             \n"
"  cl_ushort4  rand;                                                           \n"
"                                                                              \n"
"  gegl_cl_random_get_ushort4 (o->rand, &rand);                                \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"  {                                                                           \n"
"    const char *kernel_name[] ={\"cl_noise_hurl\", NULL};                     \n"
"    cl_data = gegl_cl_compile_and_build(noise_hurl_cl_source, kernel_name);   \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    return TRUE;                                                              \n"
"                                                                              \n"
"  {                                                                           \n"
"  cl_random_data = gegl_cl_load_random_data (&cl_err);                        \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueCopyBuffer (gegl_cl_get_command_queue(),             \n"
"                                     in , out , 0 , 0 ,                       \n"
"                                     global_worksize * sizeof(cl_float4),     \n"
"                                     0, NULL, NULL);                          \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  gegl_cl_set_kernel_args (cl_data->kernel[0],                                \n"
"                           sizeof(cl_mem),   &out,                            \n"
"                           sizeof(cl_mem),   &cl_random_data,                 \n"
"                           sizeof(cl_int),   &x_offset,                       \n"
"                           sizeof(cl_int),   &y_offset,                       \n"
"                           sizeof(cl_int),   &roi_width,                      \n"
"                           sizeof(cl_int),   &wr_width,                       \n"
"                           sizeof(cl_ushort4), &rand,                         \n"
"                           sizeof(cl_float), &pct_random,                     \n"
"                           NULL);                                             \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  offset = 0;                                                                 \n"
"                                                                              \n"
"  for(it = 0; it < o->repeat; ++it)                                           \n"
"    {                                                                         \n"
"      cl_err = gegl_clSetKernelArg (cl_data->kernel[0], 8, sizeof(cl_int),    \n"
"                                    (void*)&offset);                          \n"
"      CL_CHECK;                                                               \n"
"      cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),     \n"
"                                            cl_data->kernel[0], 1,            \n"
"                                            NULL, &global_worksize, NULL,     \n"
"                                            0, NULL, NULL);                   \n"
"      CL_CHECK;                                                               \n"
"                                                                              \n"
"      offset += total_size;                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  cl_err = gegl_clFinish (gegl_cl_get_command_queue ());                      \n"
"  CL_CHECK;                                                                   \n"
"  }                                                                           \n"
"                                                                              \n"
"  return  FALSE;                                                              \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  operation_class->prepare    = prepare;                                      \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"  point_filter_class->process = process;                                      \n"
"  point_filter_class->cl_process = cl_process;                                \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",       \"gegl:noise-hurl\",                                      \n"
"    \"title\",      _(\"Randomly Shuffle Pixels\"),                           \n"
"    \"categories\", \"noise\",                                                \n"
"    \"description\", _(\"Completely randomize a fraction of pixels\"),        \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
