"""
 * Copyright (C) 2008 Varun Hiremath.
 * Copyright (C) 2008 A Venkattraman.
 * Copyright (C) 2008 C Shyam Sundar.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * Authors: Varun Hiremath, Venkattraman A, Shyam Sundar C

"""


from gastables.Isothermal import Isothermal
from scipy import arange

def get_allValues_from_M(M,gamma) :
    iso = Isothermal(gamma)
    VALUES = {}
    VALUES["M"] = M
    VALUES["P/P*(ref)"] = iso.get_P_by_Pstarref_from_M(M)
    VALUES["r*(ref)/r"] = iso.get_rhostarref_by_rho_from_M(M)
    VALUES["To/To*(ref)"] = iso.get_To_by_Tostarref_from_M(M)
    VALUES["Po/Po*(ref)"] = iso.get_Po_by_Postarref_from_M(M)
    VALUES["4fLmax/D"] = iso.get_4fLmax_by_D_from_M(M)
    
    return VALUES
 
def get_allValues_from_P_by_Pstarref(P_by_Pstarref,gamma):
    iso = Isothermal(gamma)
    return get_allValues_from_M(iso.get_M_from_P_by_Pstarref(P_by_Pstarref),gamma)
 
def get_allValues_from_rhostarref_by_rho(rhostarref_by_rho,gamma):
    iso = Isothermal(gamma)
    return get_allValues_from_M(iso.get_M_from_rhostarref_by_rho(rhostarref_by_rho),gamma)
   
def get_allValues_from_To_by_Tostarref(To_by_Tostarref,gamma):
    iso = Isothermal(gamma)
    return get_allValues_from_M(iso.get_M_from_To_by_Tostarref(To_by_Tostarref),gamma)

def get_allValues_from_Po_by_Postarref(Po_by_Postarref,gamma):
    iso = Isothermal(gamma)
    VALUES = {}
    SECOND_VALUES = None
    Mach_Nos = iso.get_M_from_Po_by_Postarref(Po_by_Postarref)
    if(type(Mach_Nos) == tuple):
	    M1 = Mach_Nos[0]
	    M2 = Mach_Nos[1]
	    VALUES = get_allValues_from_M(M1, gamma)
	    SECOND_VALUES = get_allValues_from_M(M2, gamma)
	
    else:
	    VALUES = get_allValues_from_M(Mach_Nos, gamma)

    return VALUES, SECOND_VALUES
 
def get_allValues_from_4fLmax_by_D(fLmax_by_D,gamma):
	iso = Isothermal(gamma)
	VALUES = {}
    	SECOND_VALUES = None
    	Mach_Nos = iso.get_M_from_4fLmax_by_D(fLmax_by_D)
    	#print Mach_Nos
    	if(type(Mach_Nos) == tuple):
		M1 = Mach_Nos[0]
	    	M2 = Mach_Nos[1]
	    	VALUES = get_allValues_from_M(M1, gamma)
	    	SECOND_VALUES = get_allValues_from_M(M2, gamma)
	else:
		VALUES = get_allValues_from_M(Mach_Nos, gamma)

    	return VALUES, SECOND_VALUES
  
def get_plotData_from_M(gamma):
	MRange = arange(0.1,5.01,0.1)
	VALUES = {"M" : MRange, "P/P*(ref)" : [], "r*(ref)/r": [], "To/To*(ref)" : [],
	 "Po/Po*(ref)" : [] , "4fLmax/D" : [] }
    	iso = Isothermal(gamma)
    
    	for M in MRange:
        	VALUES["P/P*(ref)"].append(iso.get_P_by_Pstarref_from_M(M))
        	VALUES["r*(ref)/r"].append(iso.get_rhostarref_by_rho_from_M(M))
		VALUES["To/To*(ref)"].append(iso.get_To_by_Tostarref_from_M(M))
        	VALUES["Po/Po*(ref)"].append(iso.get_Po_by_Postarref_from_M(M))
        	VALUES["4fLmax/D"].append(iso.get_4fLmax_by_D_from_M(M))

    	return VALUES
