# Define ONLY_CLIENT to only make the ipa-client and ipa-python subpackages
%{!?ONLY_CLIENT:%global ONLY_CLIENT 0}

%global plugin_dir %{_libdir}/dirsrv/plugins
%global POLICYCOREUTILSVER 2.1.12-5
%global gettext_domain ipa

%if (0%{?fedora} > 15 || 0%{?rhel} >= 7)
%define _hardened_build 1
%endif

Name:           freeipa
Version:        3.3.4
Release:        0%{?dist}
Summary:        The Identity, Policy and Audit system

Group:          System Environment/Base
License:        GPLv3+
URL:            http://www.freeipa.org/
Source0:        freeipa-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%if ! %{ONLY_CLIENT}
BuildRequires:  389-ds-base-devel >= 1.3.1.3
BuildRequires:  svrcore-devel
BuildRequires:  policycoreutils >= %{POLICYCOREUTILSVER}
BuildRequires:  systemd-units
%if 0%{?fedora} >= 18
BuildRequires:  samba-devel >= 2:4.0.5-1
BuildRequires:  samba-python
BuildRequires:  libwbclient-devel
%else
BuildRequires:  samba4-devel >= 4.0.0-139
BuildRequires:  samba4-python
%endif
BuildRequires:  libtalloc-devel
BuildRequires:  libtevent-devel
%endif # ONLY_CLIENT
BuildRequires:  nspr-devel
BuildRequires:  nss-devel
BuildRequires:  openssl-devel
BuildRequires:  openldap-devel
BuildRequires:  krb5-devel >= 1.11
BuildRequires:  krb5-workstation
BuildRequires:  libuuid-devel
BuildRequires:  libcurl-devel >= 7.21.7-2
BuildRequires:  xmlrpc-c-devel >= 1.27.4
BuildRequires:  popt-devel
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  m4
BuildRequires:  libtool
BuildRequires:  gettext
BuildRequires:  python-devel
BuildRequires:  python-ldap
BuildRequires:  python-setuptools
BuildRequires:  python-krbV
BuildRequires:  python-nss
BuildRequires:  python-netaddr
BuildRequires:  python-kerberos
BuildRequires:  python-rhsm
BuildRequires:  pyOpenSSL
BuildRequires:  pylint
BuildRequires:  python-polib
BuildRequires:  libipa_hbac-python
BuildRequires:  python-memcached
BuildRequires:  sssd >= 1.9.2
BuildRequires:  python-lxml
BuildRequires:  python-pyasn1 >= 0.0.9a
BuildRequires:  python-dns
BuildRequires:  m2crypto
BuildRequires:  check
BuildRequires:  libsss_idmap-devel
BuildRequires:  libsss_nss_idmap-devel
BuildRequires:  java-1.7.0-openjdk
BuildRequires:  libverto-devel
BuildRequires:  systemd
BuildRequires:  libunistring-devel

# Find out Kerberos middle version to infer ABI changes in DAL driver
# We cannot load DAL driver into KDC with wrong ABI.
# This is also needed to support ipa-devel repository where krb5 1.11 is available for F18
%global krb5_dal_version %{expand:%(echo "#include <kdb.h>"|cpp -dM|grep KRB5_KDB_DAL_MAJOR_VERSION|cut -d' ' -f3)}

%description
IPA is an integrated solution to provide centrally managed Identity (machine,
user, virtual machines, groups, authentication credentials), Policy
(configuration settings, access control information) and Audit (events,
logs, analysis thereof).

%if ! %{ONLY_CLIENT}
%package server
Summary: The IPA authentication server
Group: System Environment/Base
Requires: %{name}-python = %{version}-%{release}
Requires: %{name}-client = %{version}-%{release}
Requires: %{name}-admintools = %{version}-%{release}
Requires: 389-ds-base >= 1.3.1.3
Requires: openldap-clients > 2.4.35-4
%if 0%{?fedora} == 18
Requires: nss >= 3.14.3-2
Requires: nss-tools >= 3.14.3-2
%else
Requires: nss >= 3.14.3-12.0
Requires: nss-tools >= 3.14.3-12.0
%endif
%if 0%{?krb5_dal_version} >= 4
Requires: krb5-server >= 1.11.2-1
%else
%if 0%{krb5_dal_version} == 3
# krb5 1.11 bumped DAL interface major version, a rebuild is needed
Requires: krb5-server < 1.11
Requires: krb5-server >= 1.10
%else
Requires: krb5-server >= 1.10
%endif
%endif
Requires: krb5-pkinit-openssl
Requires: cyrus-sasl-gssapi%{?_isa}
Requires: ntp
Requires: httpd
Requires: mod_wsgi
%if 0%{?fedora} >= 18
Requires: mod_auth_kerb >= 5.4-16
%else
Requires: mod_auth_kerb >= 5.4-8
%endif
Requires: mod_nss >= 1.0.8-24
Requires: python-ldap
Requires: python-krbV
Requires: acl
Requires: python-pyasn1
Requires: memcached
Requires: python-memcached
Requires: systemd-units >= 38
Requires(pre): systemd-units
Requires(post): systemd-units
Requires: selinux-policy >= 3.12.1-65
Requires(post): selinux-policy-base
Requires: slapi-nis >= 0.47.7
Requires: pki-ca >= 10.0.4
Requires: dogtag-pki-server-theme
%if 0%{?rhel}
Requires: subscription-manager
%endif
Requires(preun): python systemd-units
Requires(postun): python systemd-units
Requires: python-dns
Requires: zip
Requires: policycoreutils >= %{POLICYCOREUTILSVER}
Requires: tar
Requires(pre): certmonger >= 0.65
Requires(pre): 389-ds-base >= 1.3.1.3

# With FreeIPA 3.3, package freeipa-server-selinux was obsoleted as the
# entire SELinux policy is stored in the system policy
Obsoletes: freeipa-server-selinux < 3.3.0

# We have a soft-requires on bind. It is an optional part of
# IPA but if it is configured we need a way to require versions
# that work for us.
%if 0%{?fedora} >= 18
Conflicts: bind-dyndb-ldap < 3.5
%else
Conflicts: bind-dyndb-ldap < 1.1.0-0.12.rc1
%endif
Conflicts: bind < 9.8.2-0.4.rc2

# Versions of nss-pam-ldapd < 0.8.4 require a mapping from uniqueMember to
# member.
Conflicts: nss-pam-ldapd < 0.8.4

Obsoletes: ipa-server >= 1.0

%description server
IPA is an integrated solution to provide centrally managed Identity (machine,
user, virtual machines, groups, authentication credentials), Policy
(configuration settings, access control information) and Audit (events,
logs, analysis thereof). If you are installing an IPA server you need
to install this package (in other words, most people should NOT install
this package).


%package server-trust-ad
Summary: Virtual package to install packages required for Active Directory trusts
Group: System Environment/Base
Requires: %{name}-server = %version-%release
Requires: m2crypto
%if 0%{?fedora} >= 18
Requires: samba-python
Requires: samba >= 2:4.0.5-1
Requires: samba-winbind
%else
Requires: samba4-python
Requires: samba4
Requires: samba4-winbind
%endif
Requires: libsss_idmap
%if 0%{?fedora} >= 19
Requires: libsss_nss_idmap-python
%endif
# We use alternatives to divert winbind_krb5_locator.so plugin to libkrb5
# on the installes where server-trust-ad subpackage is installed because
# IPA AD trusts cannot be used at the same time with the locator plugin
# since Winbindd will be configured in a different mode
Requires(post): %{_sbindir}/update-alternatives
Requires(post): python
Requires(postun): %{_sbindir}/update-alternatives
Requires(preun): %{_sbindir}/update-alternatives

%description server-trust-ad
Cross-realm trusts with Active Directory in IPA require working Samba 4
installation. This package is provided for convenience to install all required
dependencies at once.

%endif # ONLY_CLIENT


%package client
Summary: IPA authentication for use on clients
Group: System Environment/Base
Requires: %{name}-python = %{version}-%{release}
Requires: python-ldap
Requires: cyrus-sasl-gssapi%{?_isa}
Requires: ntp
Requires: krb5-workstation
Requires: authconfig
Requires: pam_krb5
Requires: wget
Requires: libcurl >= 7.21.7-2
Requires: xmlrpc-c >= 1.27.4
Requires: sssd >= 1.11.1
Requires: certmonger >= 0.65
Requires: nss-tools
Requires: bind-utils
Requires: oddjob-mkhomedir
Requires: python-krbV
Requires: python-dns
Requires: libsss_autofs
Requires: autofs
Requires: libnfsidmap
Requires: nfs-utils
Requires(post): policycoreutils

Obsoletes: ipa-client >= 1.0

%description client
IPA is an integrated solution to provide centrally managed Identity (machine,
user, virtual machines, groups, authentication credentials), Policy
(configuration settings, access control information) and Audit (events,
logs, analysis thereof). If your network uses IPA for authentication,
this package should be installed on every client machine.


%if ! %{ONLY_CLIENT}
%package admintools
Summary: IPA administrative tools
Group: System Environment/Base
Requires: %{name}-python = %{version}-%{release}
Requires: %{name}-client = %{version}-%{release}
Requires: python-krbV
Requires: python-ldap

Obsoletes: ipa-admintools >= 1.0

%description admintools
IPA is an integrated solution to provide centrally managed Identity (machine,
user, virtual machines, groups, authentication credentials), Policy
(configuration settings, access control information) and Audit (events,
logs, analysis thereof). This package provides command-line tools for
IPA administrators.
%endif # ONLY_CLIENT

%package python
Summary: Python libraries used by IPA
Group: System Environment/Libraries
Requires: python-kerberos
Requires: gnupg
Requires: iproute
Requires: keyutils
Requires: pyOpenSSL
Requires: python-nss
Requires: python-lxml
Requires: python-netaddr
Requires: libipa_hbac-python

Obsoletes: ipa-python >= 1.0

%description python
IPA is an integrated solution to provide centrally managed Identity (machine,
user, virtual machines, groups, authentication credentials), Policy
(configuration settings, access control information) and Audit (events,
logs, analysis thereof). If you are using IPA you need to install this
package.

%if ! %{ONLY_CLIENT}
%package tests
Summary: IPA tests and test tools
Requires: %{name}-client = %{version}-%{release}
Requires: %{name}-python = %{version}-%{release}
Requires: tar
Requires: xz
Requires: python-nose
Requires: python-paste
Requires: python-coverage
Requires: python-polib
Requires: python-paramiko >= 1.7.7

%description tests
IPA is an integrated solution to provide centrally managed Identity (machine,
user, virtual machines, groups, authentication credentials), Policy
(configuration settings, access control information) and Audit (events,
logs, analysis thereof).
This package contains tests that verify IPA functionality.

%endif # ONLY_CLIENT


%prep
%setup -n freeipa-%{version} -q

%build
%ifarch ppc %{power64} s390 s390x
# UI compilation segfaulted on some arches when the stack was lower (#1040576)
export JAVA_STACK_SIZE="8m"
%endif
export CFLAGS="$CFLAGS %{optflags}"
export CPPFLAGS="$CPPFLAGS %{optflags}"
%if 0%{?fedora} >= 18
# use fedora18 platform which is based on fedora16 platform with systemd
# support + fedora18 changes
export SUPPORTED_PLATFORM=fedora18
%else
export SUPPORTED_PLATFORM=fedora16
%endif
# Force re-generate of platform support
rm -f ipapython/services.py
make version-update
cd ipa-client; ../autogen.sh --prefix=%{_usr} --sysconfdir=%{_sysconfdir} --localstatedir=%{_localstatedir} --libdir=%{_libdir} --mandir=%{_mandir}; cd ..
%if ! %{ONLY_CLIENT}
cd daemons; ../autogen.sh --prefix=%{_usr} --sysconfdir=%{_sysconfdir} --localstatedir=%{_localstatedir} --libdir=%{_libdir} --mandir=%{_mandir} --with-openldap; cd ..
cd install; ../autogen.sh --prefix=%{_usr} --sysconfdir=%{_sysconfdir} --localstatedir=%{_localstatedir} --libdir=%{_libdir} --mandir=%{_mandir}; cd ..
%endif # ONLY_CLIENT

%if ! %{ONLY_CLIENT}
make IPA_VERSION_IS_GIT_SNAPSHOT=no %{?_smp_mflags} all
%else
make IPA_VERSION_IS_GIT_SNAPSHOT=no %{?_smp_mflags} client
%endif # ONLY_CLIENT

%install
rm -rf %{buildroot}
%if 0%{?fedora} >= 18
# use fedora18 platform which is based on fedora16 platform with systemd
# support + fedora18 changes
export SUPPORTED_PLATFORM=fedora18
%else
export SUPPORTED_PLATFORM=fedora16
%endif
# Force re-generate of platform support
rm -f ipapython/services.py
%if ! %{ONLY_CLIENT}
make install DESTDIR=%{buildroot}
%else
make client-install DESTDIR=%{buildroot}
%endif # ONLY_CLIENT
%find_lang %{gettext_domain}


%if ! %{ONLY_CLIENT}
# Remove .la files from libtool - we don't want to package
# these files
rm %{buildroot}/%{plugin_dir}/libipa_pwd_extop.la
rm %{buildroot}/%{plugin_dir}/libipa_enrollment_extop.la
rm %{buildroot}/%{plugin_dir}/libipa_winsync.la
rm %{buildroot}/%{plugin_dir}/libipa_repl_version.la
rm %{buildroot}/%{plugin_dir}/libipa_uuid.la
rm %{buildroot}/%{plugin_dir}/libipa_modrdn.la
rm %{buildroot}/%{plugin_dir}/libipa_lockout.la
rm %{buildroot}/%{plugin_dir}/libipa_cldap.la
rm %{buildroot}/%{plugin_dir}/libipa_dns.la
rm %{buildroot}/%{plugin_dir}/libipa_sidgen.la
rm %{buildroot}/%{plugin_dir}/libipa_sidgen_task.la
rm %{buildroot}/%{plugin_dir}/libipa_extdom_extop.la
rm %{buildroot}/%{plugin_dir}/libipa_range_check.la
rm %{buildroot}/%{_libdir}/krb5/plugins/kdb/ipadb.la
rm %{buildroot}/%{_libdir}/samba/pdb/ipasam.la

# Some user-modifiable HTML files are provided. Move these to /etc
# and link back.
mkdir -p %{buildroot}/%{_sysconfdir}/ipa/html
mkdir -p %{buildroot}/%{_localstatedir}/cache/ipa/sysrestore
mkdir -p %{buildroot}/%{_localstatedir}/cache/ipa/sysupgrade
mkdir %{buildroot}%{_usr}/share/ipa/html/
ln -s ../../../..%{_sysconfdir}/ipa/html/ffconfig.js \
    %{buildroot}%{_usr}/share/ipa/html/ffconfig.js
ln -s ../../../..%{_sysconfdir}/ipa/html/ffconfig_page.js \
    %{buildroot}%{_usr}/share/ipa/html/ffconfig_page.js
ln -s ../../../..%{_sysconfdir}/ipa/html/ssbrowser.html \
    %{buildroot}%{_usr}/share/ipa/html/ssbrowser.html
ln -s ../../../..%{_sysconfdir}/ipa/html/unauthorized.html \
    %{buildroot}%{_usr}/share/ipa/html/unauthorized.html
ln -s ../../../..%{_sysconfdir}/ipa/html/browserconfig.html \
    %{buildroot}%{_usr}/share/ipa/html/browserconfig.html
ln -s ../../../..%{_sysconfdir}/ipa/html/ipa_error.css \
    %{buildroot}%{_usr}/share/ipa/html/ipa_error.css

# So we can own our Apache configuration
mkdir -p %{buildroot}%{_sysconfdir}/httpd/conf.d/
/bin/touch %{buildroot}%{_sysconfdir}/httpd/conf.d/ipa.conf
/bin/touch %{buildroot}%{_sysconfdir}/httpd/conf.d/ipa-pki-proxy.conf
/bin/touch %{buildroot}%{_sysconfdir}/httpd/conf.d/ipa-rewrite.conf
mkdir -p %{buildroot}%{_usr}/share/ipa/html/
/bin/touch %{buildroot}%{_usr}/share/ipa/html/ca.crt
/bin/touch %{buildroot}%{_usr}/share/ipa/html/configure.jar
/bin/touch %{buildroot}%{_usr}/share/ipa/html/kerberosauth.xpi
/bin/touch %{buildroot}%{_usr}/share/ipa/html/krb.con
/bin/touch %{buildroot}%{_usr}/share/ipa/html/krb.js
/bin/touch %{buildroot}%{_usr}/share/ipa/html/krb5.ini
/bin/touch %{buildroot}%{_usr}/share/ipa/html/krbrealm.con
/bin/touch %{buildroot}%{_usr}/share/ipa/html/preferences.html
mkdir -p %{buildroot}%{_initrddir}
mkdir %{buildroot}%{_sysconfdir}/sysconfig/
install -m 644 init/ipa_memcached.conf %{buildroot}%{_sysconfdir}/sysconfig/ipa_memcached

# Web UI plugin dir
mkdir -p %{buildroot}%{_usr}/share/ipa/ui/js/plugins

# NOTE: systemd specific section
mkdir -p %{buildroot}%{_prefix}/lib/tmpfiles.d
install -m 0644 init/systemd/ipa.conf.tmpfiles %{buildroot}%{_prefix}/lib/tmpfiles.d/%{name}.conf
# END

mkdir -p %{buildroot}%{_localstatedir}/run/
install -d -m 0700 %{buildroot}%{_localstatedir}/run/ipa_memcached/
install -d -m 0700 %{buildroot}%{_localstatedir}/run/ipa/

mkdir -p %{buildroot}%{_libdir}/krb5/plugins/libkrb5
touch %{buildroot}%{_libdir}/krb5/plugins/libkrb5/winbind_krb5_locator.so

# NOTE: systemd specific section
mkdir -p %{buildroot}%{_unitdir}
install -m 644 init/systemd/ipa.service %{buildroot}%{_unitdir}/ipa.service
install -m 644 init/systemd/ipa_memcached.service %{buildroot}%{_unitdir}/ipa_memcached.service
# END
mkdir -p %{buildroot}/%{_localstatedir}/lib/ipa/backup
%endif # ONLY_CLIENT

mkdir -p %{buildroot}%{_sysconfdir}/ipa/
/bin/touch %{buildroot}%{_sysconfdir}/ipa/default.conf
/bin/touch %{buildroot}%{_sysconfdir}/ipa/ca.crt
mkdir -p %{buildroot}/%{_localstatedir}/lib/ipa-client/sysrestore

%if ! %{ONLY_CLIENT}
mkdir -p %{buildroot}%{_sysconfdir}/bash_completion.d
install -pm 644 contrib/completion/ipa.bash_completion %{buildroot}%{_sysconfdir}/bash_completion.d/ipa
mkdir -p %{buildroot}%{_sysconfdir}/cron.d

(cd %{buildroot}/%{python_sitelib}/ipaserver && find . -type f  | \
    grep -v dcerpc | grep -v adtrustinstance | \
    sed -e 's,\.py.*$,.*,g' | sort -u | \
    sed -e 's,\./,%%{python_sitelib}/ipaserver/,g' ) >server-python.list

(cd %{buildroot}/%{python_sitelib}/ipatests && find . -type f  | \
    sed -e 's,\.py.*$,.*,g' | sort -u | \
    sed -e 's,\./,%%{python_sitelib}/ipatests/,g' ) >tests-python.list
%endif # ONLY_CLIENT

%clean
rm -rf %{buildroot}

%if ! %{ONLY_CLIENT}
%post server
# NOTE: systemd specific section
    /bin/systemctl --system daemon-reload 2>&1 || :
# END
if [ $1 -gt 1 ] ; then
    /bin/systemctl condrestart certmonger.service 2>&1 || :
fi

%posttrans server
# This must be run in posttrans so that updates from previous
# execution that may no longer be shipped are not applied.
/usr/sbin/ipa-ldap-updater --upgrade --quiet >/dev/null || :
/usr/sbin/ipa-upgradeconfig --quiet >/dev/null || :

# Restart IPA processes. This must be also run in postrans so that plugins
# and software is in consistent state
python -c "import sys; from ipaserver.install import installutils; sys.exit(0 if installutils.is_ipa_configured() else 1);" > /dev/null 2>&1
# NOTE: systemd specific section
if [  $? -eq 0 ]; then
    /bin/systemctl try-restart ipa.service >/dev/null 2>&1 || :
fi
# END

%preun server
if [ $1 = 0 ]; then
# NOTE: systemd specific section
    /bin/systemctl --quiet stop ipa.service || :
    /bin/systemctl --quiet disable ipa.service || :
# END
fi

%pre server
# Stop ipa_kpasswd if it exists before upgrading so we don't have a
# zombie process when we're done.
if [ -e /usr/sbin/ipa_kpasswd ]; then
# NOTE: systemd specific section
    /bin/systemctl stop ipa_kpasswd.service >/dev/null 2>&1 || :
# END
fi

%postun server-trust-ad
if [ "$1" -ge "1" ]; then
    if [ "`readlink %{_sysconfdir}/alternatives/winbind_krb5_locator.so`" == "/dev/null" ]; then
        %{_sbindir}/alternatives --set winbind_krb5_locator.so /dev/null
    fi
fi

%post server-trust-ad
%{_sbindir}/update-alternatives --install %{_libdir}/krb5/plugins/libkrb5/winbind_krb5_locator.so \
        winbind_krb5_locator.so /dev/null 90

%posttrans server-trust-ad
python -c "import sys; from ipaserver.install import installutils; sys.exit(0 if installutils.is_ipa_configured() else 1);" > /dev/null 2>&1
if [  $? -eq 0 ]; then
# NOTE: systemd specific section
    /bin/systemctl try-restart httpd.service >/dev/null 2>&1 || :
# END
fi

%preun server-trust-ad
if [ $1 -eq 0 ]; then
    %{_sbindir}/update-alternatives --remove winbind_krb5_locator.so /dev/null
fi
%endif # ONLY_CLIENT

%post client
if [ $1 -gt 1 ] ; then
    # Has the client been configured?
    restore=0
    test -f '/var/lib/ipa-client/sysrestore/sysrestore.index' && restore=$(wc -l '/var/lib/ipa-client/sysrestore/sysrestore.index' | awk '{print $1}')

    if [ -f '/etc/sssd/sssd.conf' -a $restore -ge 2 ]; then
        if ! grep -E -q '/var/lib/sss/pubconf/krb5.include.d/' /etc/krb5.conf  2>/dev/null ; then
            echo "includedir /var/lib/sss/pubconf/krb5.include.d/" > /etc/krb5.conf.ipanew
            cat /etc/krb5.conf >> /etc/krb5.conf.ipanew
            mv /etc/krb5.conf.ipanew /etc/krb5.conf
            /sbin/restorecon /etc/krb5.conf
        fi
    fi

    if [ -f '/etc/sysconfig/ntpd' -a $restore -ge 2 ]; then
        if grep -E -q 'OPTIONS=.*-u ntp:ntp' /etc/sysconfig/ntpd 2>/dev/null; then
            sed -r '/OPTIONS=/ { s/\s+-u ntp:ntp\s+/ /; s/\s*-u ntp:ntp\s*// }' /etc/sysconfig/ntpd >/etc/sysconfig/ntpd.ipanew
            mv /etc/sysconfig/ntpd.ipanew /etc/sysconfig/ntpd
            /sbin/restorecon /etc/sysconfig/ntpd

            /bin/systemctl condrestart ntpd.service 2>&1 || :
        fi
    fi
fi

%triggerin -n freeipa-client -- openssh-server
# Has the client been configured?
restore=0
test -f '/var/lib/ipa-client/sysrestore/sysrestore.index' && restore=$(wc -l '/var/lib/ipa-client/sysrestore/sysrestore.index' | awk '{print $1}')

if [ -f '/etc/ssh/sshd_config' -a $restore -ge 2 ]; then
    if grep -E -q '^(AuthorizedKeysCommand /usr/bin/sss_ssh_authorizedkeys|PubKeyAgent /usr/bin/sss_ssh_authorizedkeys %u)$' /etc/ssh/sshd_config 2>/dev/null; then
        sed -r '
            /^(AuthorizedKeysCommand(User|RunAs)|PubKeyAgentRunAs)[ \t]/ d
        ' /etc/ssh/sshd_config >/etc/ssh/sshd_config.ipanew

        if /usr/sbin/sshd -t -f /dev/null -o 'AuthorizedKeysCommand=/usr/bin/sss_ssh_authorizedkeys' -o 'AuthorizedKeysCommandUser=nobody'; then
            sed -ri '
                s/^PubKeyAgent (.+) %u$/AuthorizedKeysCommand \1/
                s/^AuthorizedKeysCommand .*$/\0\nAuthorizedKeysCommandUser nobody/
            ' /etc/ssh/sshd_config.ipanew
        elif /usr/sbin/sshd -t -f /dev/null -o 'AuthorizedKeysCommand=/usr/bin/sss_ssh_authorizedkeys' -o 'AuthorizedKeysCommandRunAs=nobody'; then
            sed -ri '
                s/^PubKeyAgent (.+) %u$/AuthorizedKeysCommand \1/
                s/^AuthorizedKeysCommand .*$/\0\nAuthorizedKeysCommandRunAs nobody/
            ' /etc/ssh/sshd_config.ipanew
        elif /usr/sbin/sshd -t -f /dev/null -o 'PubKeyAgent=/usr/bin/sss_ssh_authorizedkeys %u' -o 'PubKeyAgentRunAs=nobody'; then
            sed -ri '
                s/^AuthorizedKeysCommand (.+)$/PubKeyAgent \1 %u/
                s/^PubKeyAgent .*$/\0\nPubKeyAgentRunAs nobody/
            ' /etc/ssh/sshd_config.ipanew
        fi

        mv /etc/ssh/sshd_config.ipanew /etc/ssh/sshd_config
        /sbin/restorecon /etc/ssh/sshd_config
        chmod 600 /etc/ssh/sshd_config

        /bin/systemctl condrestart sshd.service 2>&1 || :
    fi
fi

%if ! %{ONLY_CLIENT}
%files server -f server-python.list
%defattr(-,root,root,-)
%doc COPYING README Contributors.txt
%{_sbindir}/ipa-backup
%{_sbindir}/ipa-restore
%{_sbindir}/ipa-ca-install
%{_sbindir}/ipa-dns-install
%{_sbindir}/ipa-server-install
%{_sbindir}/ipa-replica-conncheck
%{_sbindir}/ipa-replica-install
%{_sbindir}/ipa-replica-prepare
%{_sbindir}/ipa-replica-manage
%{_sbindir}/ipa-csreplica-manage
%{_sbindir}/ipa-server-certinstall
%{_sbindir}/ipa-ldap-updater
%{_sbindir}/ipa-compat-manage
%{_sbindir}/ipa-nis-manage
%{_sbindir}/ipa-managed-entries
%{_sbindir}/ipactl
%{_sbindir}/ipa-upgradeconfig
%{_sbindir}/ipa-advise
%{_libexecdir}/certmonger/dogtag-ipa-retrieve-agent-submit
%{_libexecdir}/ipa-otpd
%config(noreplace) %{_sysconfdir}/sysconfig/ipa_memcached
%dir %attr(0700,apache,apache) %{_localstatedir}/run/ipa_memcached/
%dir %attr(0700,root,root) %{_localstatedir}/run/ipa/
# NOTE: systemd specific section
%{_prefix}/lib/tmpfiles.d/%{name}.conf
%attr(644,root,root) %{_unitdir}/ipa.service
%attr(644,root,root) %{_unitdir}/ipa_memcached.service
%attr(644,root,root) %{_unitdir}/ipa-otpd.socket
%attr(644,root,root) %{_unitdir}/ipa-otpd@.service
# END
%dir %{python_sitelib}/ipaserver
%dir %{python_sitelib}/ipaserver/install
%dir %{python_sitelib}/ipaserver/install/plugins
%dir %{python_sitelib}/ipaserver/advise
%dir %{python_sitelib}/ipaserver/advise/plugins
%dir %{python_sitelib}/ipaserver/plugins
%dir %{_libdir}/ipa/certmonger
%attr(755,root,root) %{_libdir}/ipa/certmonger/*
%dir %{_usr}/share/ipa
%{_usr}/share/ipa/wsgi.py*
%{_usr}/share/ipa/copy-schema-to-ca.py*
%{_usr}/share/ipa/*.ldif
%{_usr}/share/ipa/*.uldif
%{_usr}/share/ipa/*.template
%dir %{_usr}/share/ipa/advise
%dir %{_usr}/share/ipa/advise/legacy
%{_usr}/share/ipa/advise/legacy/*.template
%dir %{_usr}/share/ipa/ffextension
%{_usr}/share/ipa/ffextension/bootstrap.js
%{_usr}/share/ipa/ffextension/install.rdf
%{_usr}/share/ipa/ffextension/chrome.manifest
%dir %{_usr}/share/ipa/ffextension/chrome
%dir %{_usr}/share/ipa/ffextension/chrome/content
%{_usr}/share/ipa/ffextension/chrome/content/kerberosauth.js
%{_usr}/share/ipa/ffextension/chrome/content/kerberosauth_overlay.xul
%dir %{_usr}/share/ipa/ffextension/locale
%dir %{_usr}/share/ipa/ffextension/locale/en-US
%{_usr}/share/ipa/ffextension/locale/en-US/kerberosauth.properties
%dir %{_usr}/share/ipa/html
%{_usr}/share/ipa/html/ffconfig.js
%{_usr}/share/ipa/html/ffconfig_page.js
%{_usr}/share/ipa/html/ssbrowser.html
%{_usr}/share/ipa/html/browserconfig.html
%{_usr}/share/ipa/html/unauthorized.html
%{_usr}/share/ipa/html/ipa_error.css
%dir %{_usr}/share/ipa/migration
%{_usr}/share/ipa/migration/error.html
%{_usr}/share/ipa/migration/index.html
%{_usr}/share/ipa/migration/invalid.html
%{_usr}/share/ipa/migration/migration.py*
%dir %{_usr}/share/ipa/ui
%{_usr}/share/ipa/ui/index.html
%{_usr}/share/ipa/ui/login.html
%{_usr}/share/ipa/ui/logout.html
%{_usr}/share/ipa/ui/reset_password.html
%{_usr}/share/ipa/ui/*.ico
%{_usr}/share/ipa/ui/*.css
%{_usr}/share/ipa/ui/*.js
%{_usr}/share/ipa/ui/*.eot
%{_usr}/share/ipa/ui/*.svg
%{_usr}/share/ipa/ui/*.ttf
%{_usr}/share/ipa/ui/*.woff
%dir %{_usr}/share/ipa/ui/js
%dir %{_usr}/share/ipa/ui/js/dojo
%{_usr}/share/ipa/ui/js/dojo/dojo.js
%dir %{_usr}/share/ipa/ui/js/libs
%{_usr}/share/ipa/ui/js/libs/*.js
%dir %{_usr}/share/ipa/ui/js/freeipa
%{_usr}/share/ipa/ui/js/freeipa/app.js
%dir %{_usr}/share/ipa/ui/js/plugins
%dir %{_usr}/share/ipa/ui/images
%{_usr}/share/ipa/ui/images/*.png
%{_usr}/share/ipa/ui/images/*.gif
%dir %{_usr}/share/ipa/wsgi
%{_usr}/share/ipa/wsgi/plugins.py*
%dir %{_sysconfdir}/ipa
%dir %{_sysconfdir}/ipa/html
%config(noreplace) %{_sysconfdir}/ipa/html/ffconfig.js
%config(noreplace) %{_sysconfdir}/ipa/html/ffconfig_page.js
%config(noreplace) %{_sysconfdir}/ipa/html/ssbrowser.html
%config(noreplace) %{_sysconfdir}/ipa/html/ipa_error.css
%config(noreplace) %{_sysconfdir}/ipa/html/unauthorized.html
%config(noreplace) %{_sysconfdir}/ipa/html/browserconfig.html
%ghost %attr(0644,root,apache) %config(noreplace) %{_sysconfdir}/httpd/conf.d/ipa-rewrite.conf
%ghost %attr(0644,root,apache) %config(noreplace) %{_sysconfdir}/httpd/conf.d/ipa.conf
%ghost %attr(0644,root,apache) %config(noreplace) %{_sysconfdir}/httpd/conf.d/ipa-pki-proxy.conf
%{_usr}/share/ipa/ca_renewal
%{_usr}/share/ipa/ipa.conf
%{_usr}/share/ipa/ipa-rewrite.conf
%{_usr}/share/ipa/ipa-pki-proxy.conf
%ghost %attr(0644,root,apache) %config(noreplace) %{_usr}/share/ipa/html/ca.crt
%ghost %attr(0644,root,apache) %{_usr}/share/ipa/html/configure.jar
%ghost %attr(0644,root,apache) %{_usr}/share/ipa/html/kerberosauth.xpi
%ghost %attr(0644,root,apache) %{_usr}/share/ipa/html/krb.con
%ghost %attr(0644,root,apache) %{_usr}/share/ipa/html/krb.js
%ghost %attr(0644,root,apache) %{_usr}/share/ipa/html/krb5.ini
%ghost %attr(0644,root,apache) %{_usr}/share/ipa/html/krbrealm.con
%ghost %attr(0644,root,apache) %{_usr}/share/ipa/html/preferences.html
%dir %{_usr}/share/ipa/updates/
%{_usr}/share/ipa/updates/*
%attr(755,root,root) %{plugin_dir}/libipa_pwd_extop.so
%attr(755,root,root) %{plugin_dir}/libipa_enrollment_extop.so
%attr(755,root,root) %{plugin_dir}/libipa_winsync.so
%attr(755,root,root) %{plugin_dir}/libipa_repl_version.so
%attr(755,root,root) %{plugin_dir}/libipa_uuid.so
%attr(755,root,root) %{plugin_dir}/libipa_modrdn.so
%attr(755,root,root) %{plugin_dir}/libipa_lockout.so
%attr(755,root,root) %{plugin_dir}/libipa_cldap.so
%attr(755,root,root) %{plugin_dir}/libipa_dns.so
%attr(755,root,root) %{plugin_dir}/libipa_range_check.so
%dir %{_localstatedir}/lib/ipa
%attr(700,root,root) %dir %{_localstatedir}/lib/ipa/backup
%attr(700,root,root) %dir %{_localstatedir}/lib/ipa/sysrestore
%attr(700,root,root) %dir %{_localstatedir}/lib/ipa/sysupgrade
%attr(755,root,root) %dir %{_localstatedir}/lib/ipa/pki-ca
%ghost %{_localstatedir}/lib/ipa/pki-ca/publish
%attr(755,root,root) %{_libdir}/krb5/plugins/kdb/ipadb.so
%{_mandir}/man1/ipa-replica-conncheck.1.gz
%{_mandir}/man1/ipa-replica-install.1.gz
%{_mandir}/man1/ipa-replica-manage.1.gz
%{_mandir}/man1/ipa-csreplica-manage.1.gz
%{_mandir}/man1/ipa-replica-prepare.1.gz
%{_mandir}/man1/ipa-server-certinstall.1.gz
%{_mandir}/man1/ipa-server-install.1.gz
%{_mandir}/man1/ipa-dns-install.1.gz
%{_mandir}/man1/ipa-ca-install.1.gz
%{_mandir}/man1/ipa-compat-manage.1.gz
%{_mandir}/man1/ipa-nis-manage.1.gz
%{_mandir}/man1/ipa-managed-entries.1.gz
%{_mandir}/man1/ipa-ldap-updater.1.gz
%{_mandir}/man8/ipactl.8.gz
%{_mandir}/man8/ipa-upgradeconfig.8.gz
%{_mandir}/man1/ipa-backup.1.gz
%{_mandir}/man1/ipa-restore.1.gz
%{_mandir}/man1/ipa-advise.1.gz

%files server-trust-ad
%{_sbindir}/ipa-adtrust-install
%attr(755,root,root) %{plugin_dir}/libipa_extdom_extop.so
%{_usr}/share/ipa/smb.conf.empty
%attr(755,root,root) %{_libdir}/samba/pdb/ipasam.so
%attr(755,root,root) %{plugin_dir}/libipa_sidgen.so
%attr(755,root,root) %{plugin_dir}/libipa_sidgen_task.so
%{_mandir}/man1/ipa-adtrust-install.1.gz
%{python_sitelib}/ipaserver/dcerpc*
%{python_sitelib}/ipaserver/install/adtrustinstance*
%ghost %{_libdir}/krb5/plugins/libkrb5/winbind_krb5_locator.so
%endif # ONLY_CLIENT

%files client
%defattr(-,root,root,-)
%doc COPYING README Contributors.txt
%{_sbindir}/ipa-client-install
%{_sbindir}/ipa-client-automount
%{_sbindir}/ipa-getkeytab
%{_sbindir}/ipa-rmkeytab
%{_sbindir}/ipa-join
%dir %{_usr}/share/ipa
%dir %{_usr}/share/ipa/ipaclient
%dir %{_localstatedir}/lib/ipa-client
%dir %{_localstatedir}/lib/ipa-client/sysrestore
%{_usr}/share/ipa/ipaclient/ipa.cfg
%{_usr}/share/ipa/ipaclient/ipa.js
%dir %{python_sitelib}/ipaclient
%{python_sitelib}/ipaclient/*.py*
%{_mandir}/man1/ipa-getkeytab.1.gz
%{_mandir}/man1/ipa-rmkeytab.1.gz
%{_mandir}/man1/ipa-client-install.1.gz
%{_mandir}/man1/ipa-client-automount.1.gz
%{_mandir}/man1/ipa-join.1.gz
%{_mandir}/man5/default.conf.5.gz

%if ! %{ONLY_CLIENT}
%files admintools
%defattr(-,root,root,-)
%doc COPYING README Contributors.txt
%{_bindir}/ipa
%config %{_sysconfdir}/bash_completion.d
%{_mandir}/man1/ipa.1.gz
%endif # ONLY_CLIENT

%files python -f %{gettext_domain}.lang
%defattr(-,root,root,-)
%doc COPYING README Contributors.txt
%dir %{python_sitelib}/ipapython
%dir %{python_sitelib}/ipapython/platform
%dir %{python_sitelib}/ipapython/platform/base
%dir %{python_sitelib}/ipapython/platform/fedora16
%dir %{python_sitelib}/ipapython/platform/fedora18
%dir %{python_sitelib}/ipapython/platform/redhat
%{python_sitelib}/ipapython/*.py*
%{python_sitelib}/ipapython/platform/*.py*
%{python_sitelib}/ipapython/platform/base/*.py*
%{python_sitelib}/ipapython/platform/fedora16/*.py*
%{python_sitelib}/ipapython/platform/fedora18/*.py*
%{python_sitelib}/ipapython/platform/redhat/*.py*
%dir %{python_sitelib}/ipalib
%{python_sitelib}/ipalib/*
%attr(0644,root,root) %{python_sitearch}/default_encoding_utf8.so
%{python_sitelib}/ipapython-*.egg-info
%{python_sitelib}/freeipa-*.egg-info
%{python_sitearch}/python_default_encoding-*.egg-info
%dir %attr(0755,root,root) %{_sysconfdir}/ipa/
%ghost %attr(0644,root,apache) %config(noreplace) %{_sysconfdir}/ipa/default.conf
%ghost %attr(0644,root,apache) %config(noreplace) %{_sysconfdir}/ipa/ca.crt

%if ! %{ONLY_CLIENT}
%files tests -f tests-python.list
%defattr(-,root,root,-)
%doc COPYING README Contributors.txt
%dir %{python_sitelib}/ipatests
%dir %{python_sitelib}/ipatests/test_cmdline
%dir %{python_sitelib}/ipatests/test_install
%dir %{python_sitelib}/ipatests/test_ipalib
%dir %{python_sitelib}/ipatests/test_ipapython
%dir %{python_sitelib}/ipatests/test_ipaserver
%dir %{python_sitelib}/ipatests/test_ipaserver/install
%dir %{python_sitelib}/ipatests/test_pkcs10
%dir %{python_sitelib}/ipatests/test_webui
%dir %{python_sitelib}/ipatests/test_xmlrpc
%{_bindir}/ipa-run-tests
%{_bindir}/ipa-test-config
%{_bindir}/ipa-test-task
%{python_sitelib}/ipatests-*.egg-info
%{_mandir}/man1/ipa-run-tests.1.gz
%{_mandir}/man1/ipa-test-config.1.gz
%{_mandir}/man1/ipa-test-task.1.gz
%endif # ONLY_CLIENT

%changelog
* Fri Oct 25 2013 Martin Kosek <mkosek@redhat.com> - 3.3.2-1
- Remove mod_ssl conflict, it can now live with mod_nss installed

* Wed Sep 4 2013 Ana Krivokapic <akrivoka@redhat.com> - 3.3.0-3
- Conform to tmpfiles.d packaging guidelines

* Wed Aug 28 2013 Petr Viktorin <pviktori@redhat.com> - 3.3.0-2
- Add man pages to the tests subpackage

* Mon Aug 12 2013 Petr Viktorin <pviktori@redhat.com> - 3.3.0-1
- Downgrade required version of python-paramiko for the tests subpackage

* Thu Aug 8 2013 Martin Kosek <mkosek@redhat.com> - 3.2.99-13
- Require slapi-nis 0.47.7 and sssd 1.11.0-0.1.beta2 required for core
  features of 3.3.0 release

* Fri Jul 26 2013 Martin Kosek <mkosek@redhat.com> - 3.2.99-12
- Require pki-ca 10.0.4 which fixes external CA installation (#986901)

* Wed Jul 24 2013 Petr Viktorin <pviktori@redhat.com> - 3.2.99-11
- Add tar and xz dependencies to freeipa-tests

* Wed Jul 24 2013 Tomas Babej <tbabej@redhat.com> - 3.2.99-10
- Move requirement for keyutils from freeipa-server to freeipa-python

* Wed Jul 24 2013 Martin Kosek <mkosek@redhat.com> - 3.2.99-9
- Bump minimum version of sssd to 1.10.92 to pick up latest SSSD 1.11 Beta
  development

* Thu Jul 18 2013 Ana Krivokapic <akrivoka@redhat.com> - 3.2.99-8
- Bump minimum version of sssd to 1.10.90 for the 'ipa_server_mode' option.

* Wed Jul 17 2013 Martin Kosek <mkosek@redhat.com> - 3.2.99-7
- Require selinux-policy 3.12.1-65 containing missing policy after removal of
  freeipa-server-selinux subpackage

* Tue Jul 16 2013 Tomas Babej <tbabej@redhat.com> - 3.2.99-6
- Do not create /var/lib/ipa/pki-ca/publish, retain reference as ghost

* Thu Jul 11 2013 Martin Kosek <mkosek@redhat.com> - 3.2.99-5
- Run ipa-upgradeconfig and server restart in posttrans to avoid inconsistency
  issues when there are still old parts of software (like entitlements plugin)

* Wed Jul 10 2013 Ana Krivokapic <akrivoka@redhat.com> - 3.2.99-4
- Bump minimum version of 389-ds-base to 1.3.1.3 for user password change fix.

* Wed Jun 26 2013 Jan Cholasta <jcholast@redhat.com> - 3.2.99-3
- Bump minimum version of 389-ds-base to 1.3.1.1 for SASL mapping priority
  support.

* Mon Jun 17 2013 Petr Viktorin <pviktori@redhat.com> - 3.2.99-2
- Add the freeipa-tests subpackage

* Thu Jun 13 2013 Martin Kosek <mkosek@redhat.com> - 3.2.99-1
- Drop freeipa-server-selinux subpackage
- Drop redundant directory /var/cache/ipa/sessions

* Fri May 10 2013 Martin Kosek <mkosek@redhat.com> - 3.1.99-13
- Add requires for openldap-2.4.35-4 to pickup fixed SASL_NOCANON behavior for
  socket based connections (#960222)

* Tue May  7 2013 Petr Viktorin <pviktori@redhat.com> - 3.1.99-12
- Require libsss_nss_idmap-python in Fedora 19+

* Mon May  6 2013 Petr Vobornik <pvoborni@redhat.com> - 3.1.99-11
- Web UI plugins

* Fri May  3 2013 Rob Crittenden <rcritten@redhat.com> - 3.1.99-10
- Require pki-ca 10.0.2 for 501 response code on find for d9 -> d10 upgrades

* Tue Apr 30 2013 Rob Crittenden <rcritten@redhat.com> - 3.1.99-9
- Add Conflicts on nss-pam-ldapd < 0.8.4. The mapping from uniqueMember to
  member is now done automatically and having it in the config file raises
  an error.

* Tue Apr 30 2013 Jan Cholasta <jcholast@redhat.com> - 3.1.99-8
- Add triggerin scriptlet to update sshd_config on openssh-server update

* Thu Apr 25 2013 Rob Crittenden <rcritten@redhat.com> - 3.1.99-7
- Update nss and nss-tools dependency to fix certutil problem (#872761)

* Mon Apr 15 2013 Martin Kosek <mkosek@redhat.com> - 3.1.99-6
- Require samba 4.0.5, includes new passdb API
- Require krb5 1.11.2-1, fixes missing PAC issue
- Change permissions on backup dir to 700

* Fri Apr  5 2013 Rob Crittenden <rcritten@redhat.com> - 3.1.99-5
- Add backup and restore
- Own /var/lib/ipa/backup

* Thu Apr  4 2013 Alexander Bokovoy <abokovoy@redhat.com> - 3.1.99-4
- Make sure build against Krb5 1.11 in Fedora 18 environment creates proper dependencies

* Tue Apr  2 2013 Martin Kosek <mkosek@redhat.com> - 3.1.99-3
- Require 389-base-base >= 1.3.0.5 to pull the following fixes:
- upgrade deadlock caused by DNA plugin reconfiguration
- CVE-2013-1897: unintended information exposure when
  nsslapd-allow-anonymous-access is set to rootdse

* Wed Mar 27 2013 Martin Kosek <mkosek@redhat.com> - 3.1.99-2
- Remove conflict with krb5-server > 1.11 as ipa-kdb is compatible
- ipa-ldap-updater show produce errors only
- update policycoreutils version to 2.1.12-5 to match Requires in Fedora
- require at least systemd 38 which provides the journal (we no longer
  need to require syslog.target)

* Thu Mar 21 2013 Martin Kosek <mkosek@redhat.com> - 3.1.99-1
- Require selinux-policy 3.11.1-86 to fix Fedora 17 to 18 upgrade issue

* Tue Jan 29 2013 Petr Viktorin <pviktori@redhat.com> - 3.0.99-14
- Use ipa-ldap-updater --quiet instead of redirecting to /dev/null

* Tue Jan 29 2013 Rob Crittenden <rcritten@redhat.com> - 3.0.99-13
- Set certmonger minimum version to 0.65 for NSS locking during
  renewal
- Set selinux-policy to 3.11.1-73 so certmonger can run in post
  scriptlet

* Thu Jan 24 2013 Rob Crittenden <rcritten@redhat.com> - 3.0.99-12
- Add certmonger condrestart to server post scriptlet
- Make certmonger a (pre) Requires on the server subpackage

* Tue Jan 22 2013 Petr Vobornik <pvoborni@redhat.com> - 3.0.99-11
- dependency fix
- Add BuildRequires: java-1.7.0-openjdk.
- Removed BuildRequires: rhino

* Fri Jan 18 2013 Petr Vobornik <pvoborni@redhat.com> - 3.0.99-10
- Add Web UI layer JS files in ui/js/{dojo,freeipa,libs} directories
- Add BuildRequires: rhino

* Fri Dec 7 2012 Endi S. Dewata <edewata@redhat.com> - 3.0.99-9
- Bump minimum version of pki-ca to 10.0.0-0.54.b3

* Fri Dec 7 2012 Martin Kosek <mkosek@redhat.com> - 3.0.99-8
- Bump minimum version of 389-ds-base to 1.3.0 to get transaction support

* Thu Dec  6 2012 Rob Crittenden <rcritten@redhat.com> - 3.0.99-7
- Set min for selinux-policy to 3.11.1-60 to fix errors including sssd
  domain mapping in krb5.conf (#873429)

* Wed Nov 21 2012 Alexander Bokovoy <abokovoy@redhat.com> - 3.0.99-6
- Replace python-crypto by m2crypto dependency

* Fri Nov 16 2012 Rob Crittenden <rcritten@redhat.com> - 3.0.99-5
- Bump minimum version of slapi-nis to 0.44

* Wed Nov 14 2012 Martin Kosek <mkosek@redhat.com> - 3.0.99-4
- Remove compatibility definitions for unsupported Fedora versions (Fedora 16 and lower)
  - Do not require specific package version when the package was available in Fedora 17
  - Remove old SysV initscript compatibility code - we run on systemd now
- Add Requires for the new Dogtag 10 and dogtag-pki-server-theme
- Remove Requires on tomcat6 for Fedora 18 and later, Dogtag 10 pulls tomcat7 itself
- Add Requires for tar (used by ipa-replica-prepare)

* Fri Nov 09 2012 Martin Kosek <mkosek@redhat.com> - 3.0.99-3
- Set min for bind-dyndb-ldap to 2.3-2 to pick up disabling global
  forwarder per-zone

* Fri Oct 26 2012 Sumit Bose <sbose@redhat.com> - 3.0.99-2
- Restart httpd in post install of server-trust-ad

* Wed Oct 24 2012 Martin Kosek <mkosek@redhat.com> - 3.0.99-1
- Add strict Requires for 389-ds-base and policycoreutils to avoid user
  removing them during package lifetime

* Wed Oct 17 2012 Martin Kosek <mkosek@redhat.com> - 2.99.0-51
- Print ipa-upgradeconfig errors during RPM update

* Wed Oct 10 2012 Alexander Bokovoy <abokovoy@redhat.com> - 2.99.0-50
- Make sure server-trust-ad subpackage alternates winbind_krb5_locator.so
  plugin to /dev/null since they cannot be used when trusts are configured

* Wed Oct 10 2012 Petr Viktorin <pviktori@redhat.com> - 2.99.0-49
- Add zip dependency, needed for creating unsigned Firefox extensions

* Mon Oct  8 2012 Martin Kosek <mkosek@redhat.com> - 2.99.0-48
- Add directory /var/lib/ipa/pki-ca/publish for CRL published by pki-ca

* Mon Oct  1 2012 Martin Kosek <mkosek@redhat.com> - 2.99.0-47
- Require samba packages instead of samba4 packages obsoleted in Fedora 18 and later
- Add libwbclient-devel BuildRequires to pick up libwbclient.h on Fedora 18 and later

* Tue Sep 18 2012 Petr Viktorin <pviktori@redhat.com> - 2.99.0-46
- Set certmonger minimum version to 0.60 for Dogtag 10 support.

* Mon Sep 17 2012 Rob Crittenden <rcritten@redhat.com> - 2.99.0-45
- Set min for 389-ds-base to 1.2.11.14-1 on F17+ to pull in updated
  RUV code and nsslapd-readonly schema.

* Fri Sep 14 2012 Sumit Bose <sbose@redhat.com> - 2.99.0-44
- Updated samba4-devel dependency due to API change

* Mon Aug 20 2012 Rob Crittenden <rcritten@redhat.com> - 2.99.0-43
- Set min for 389-ds-base to 1.2.11.9-1 on F17+ to pull in warning about
  low nsslapd-cachememsize.

* Mon Aug 20 2012 Tomas Babej <tbabej@redhat.com> - 2.99.0-42
- Add samba4-winbind to build dependencies for AD server-side code

* Fri Aug 17 2012 Martin Kosek <mkosek@redhat.com> - 2.99.0-41
- Set min for bind-dyndb-ldap to 1.1.0-0.16.rc1 to pick up complete zone transfer
  support

* Thu Aug 2 2012 Martin Kosek <mkosek@redhat.com> - 2.99.0-40
- Set min for bind-dyndb-ldap to 1.1.0-0.15.rc1 to pick up SOA serial autoincrement
  feature

* Tue Jul 24 2012 Rob Crittenden <rcritten@redhat.com> - 2.99.0-39
- Set minimum certmonger to 0.58 for dogtag cert renewal

* Wed Jul 18 2012 Alexander Bokovoy <abokovoy@redhat.com> - 2.99.0-38
- Require samba4-devel >= 4.0.0-128 due to passdb API change in beta4

* Fri Jun 29 2012 Rob Crittenden <rcritten@redhat.com> - 2.99.0-37
- Add Requires on openssl
- Set minimum tomcat6 to 6.0.35-4 in F-18
- Set minimum mod_auth_kerb to 5.4-16 in F-18

* Thu Jun 21 2012 Sumit Bose <sbose@redhat.com> - 2.99.0-36
- Add extdom extop plugin

* Thu Jun 21 2012 Rob Crittenden <rcritten@redhat.com> - 2.99.0-35
- Add client requires on libsss-autofs, autofs, libnfsidmap and nfs-utils
  for configuring automount and NFS.

* Thu Jun 21 2012 Petr Vobornik <pvoborni@redhat.com> - 2.99.0-34
- Add Web UI reset password pages

* Wed Jun 20 2012 Ondrej Hamada <ohamada@redhat.com> - 2.99.0-33
- Set min for 389-ds-base to 1.2.11.5-1 on F17 to fix installation issue
- Set min for 389-ds-base to 1.2.10.10-1 on F16 (and lower) to fix CN case persistence

* Fri Jun 8 2012 Martin Kosek <mkosek@redhat.com> - 2.99.0-32
- Add directory /var/lib/ipa/sysupgrade for package upgrade metadata
- Set min for bind-dyndb-ldap to 1.1.0-0.12.rc1 to pick up persistent search
  related bug fixes

* Mon Jun  4 2012 Alexander Bokovoy <abokovoy@redhat.com> - 2.99.0-31
- Add python-crypto to build dependencies for AD server-side code

* Tue May 29 2012 Alexander Bokovoy <abokovoy@redhat.com> - 2.99.0-30
- Add freeipa-server-trust-ad virtual package to capture all required dependencies
  for Active Directory trust management

* Fri May 11 2012 Martin Kosek <mkosek@redhat.com> - 2.99.0-29
- Replace used DNS client library (acutil) with python-dns

* Tue Apr 10 2012 Rob Crittenden <rcritten@redhat.com> - 2.99.0-28
- Set min for selinux-policy to 3.10.0-110 on F-17 to pick up certmonger
  policy for restarting services.
- Set min for certmonger to 0.53 so we have the -C option to set restart
  commands.

* Thu Apr  5 2012 Rob Crittenden <rcritten@redhat.com> - 2.99.0-27
- Bump minimum version of slapi-nis to 0.40

* Tue Mar 27 2012 Rob Crittenden <rcritten@redhat.com> - 2.99.0-26
- Add python-krbV Requires on client package

* Mon Mar 26 2012 Rob Crittenden <rcritten@redhat.com> - 2.99.0-25
- Set min for 389-ds-base to 1.2.10.4-2 to fix upgrade issue

* Fri Mar 23 2012 Petr Viktorin <pviktori@redhat.com> - 2.99.0-24
- Add python-lxml and python-pyasn1 to BuildRequires

* Mon Mar 19 2012 Martin Kosek <mkosek@redhat.com> - 2.99.0-23
- Set min for bind-dyndb-ldap and bind to pick up new features and bug fixes

* Thu Mar 1 2012 Jan Cholasta <jcholast@redhat.com> - 2.99.0-22
- Set min nvr of sssd to 1.8.0 for SSH support
- Add BuildRequires on sssd >= 1.8.0

* Wed Feb 29 2012 Petr Vobornik <pvoborni@redhat.com> - 2.99.0-21
- Add Web UI form based login page
- Removed ipa_migration.css

* Wed Feb 29 2012 Petr Vobornik <pvoborni@redhat.com> - 2.99.0-20
- Add Web UI logout page

* Mon Feb 27 2012 Rob Crittenden <rcritten@redhat.com> - 2.99.0-19
- Add Requires to ipa-client on oddjob-mkhomedir

* Fri Feb 24 2012 Martin Kosek <mkosek@redhat.com> - 2.99.0-18
- Set min for bind-dyndb-ldap to 1.1.0-0.8.a2 to pick up new features

* Thu Feb 23 2012 Rob Crittenden <rcritten@redhat.com> - 2.99.0-17
- Add Conflicts on mod_ssl

* Thu Feb 16 2012 Rob Crittenden <rcritten@redhat.com> - 2.99.0-16
- Set min for 389-ds-base to 1.2.10.1-1 to fix install segfault,
  schema replication.

* Tue Jan 31 2012 Rob Crittenden <rcritten@redhat.com> - 2.99.0-15
- Set min for krb5-server to 1.9.2-6 to pick up needed s4u2proxy patches

* Wed Jan 11 2012 Rob Crittenden <rcritten@redhat.com> - 2.99.0-14
- Set min for mod_auth_kerb to 5.4-8 to pick up s4u2proxy support

* Fri Dec 9 2011 Alexander Bokovoy <abokovoy@redhat.com> - 2.99.0-13
- Fix dependency for samba4-devel package

* Thu Nov 17 2011 Simo Sorce <simo@redhat.com> - 2.99.0-12
- Add CLDAP plugin
- Set min nvr of 389-ds-base to 1.2.10-0.5.a5 for SLAPI_PLUGIN_CONFIG_ENTRY
  support

* Mon Nov 14 2011 Endi S. Dewata <edewata@redhat.com> - 2.99.0-11
- Make sure changes to extension.js are not removed.

* Wed Oct 26 2011 Endi S. Dewata <edewata@redhat.com> - 2.99.0-10
- Moved UI images into install/ui/images

* Mon Oct 24 2011 Endi S. Dewata <edewata@redhat.com> - 2.99.0-9
- Removed hbac-deny-remove.html

* Fri Oct 21 2011 Alexander Bokovoy <abokovoy@redhat.com> - 2.99.0-8
- Default to systemd for Fedora 16 and onwards

* Fri Oct 14 2011 Rob Crittenden <rcritten@redhat.com> - 2.99.0-7
- Set min nvr of 389-ds-base to 1.2.10-0.4.a4 for limits fixes (740942, 742324)

* Fri Oct  7 2011 Adam Young <ayoung@redhat.com> - 2.99.0-6
- Add explicit dependency on pki-setup.

* Tue Sep 13 2011 Alexander Bokovoy <abokovoy@redhat.com> - 2.99.0-5
- Make sure platform adaptation is packaged in -python sub-package

* Fri Sep 9 2011 Martin Kosek <mkosek@redhat.com> - 2.99.0-4
- Add soft dependency for bind and bind-dyndb-ldap required versions

* Wed Aug 31 2011 Rob Crittenden <rcritten@redhat.com> - 2.99.0-3
- Set min nvr of 389-ds-base to 1.2.9.7-1 for BZ 728605

* Mon Aug 29 2011 Rob Crittenden <rcritten@redhat.com> - 2.99.0-2
- Set min nvr of pki-ca to 9.0.12 for fix in BZ 700505

* Thu Aug 25 2011 Simo Sorce <ssorce#redhat.com> - 2.99.0-1
- Remove ipa_kpasswd.

* Tue Aug 23 2011 Jan Cholasta <jcholast@redhat.com> - 2.1.0-1
- Add subscription-manager dependency for RHEL.

* Thu Aug 11 2011 Martin Kosek <mkosek@redhat.com> - 2.0.90-12
- Set min nvr of 389-ds-base to 1.2.9.6 for fix in BZ 725743,
  723937, and 725542
- Set min nvr of pki-ca to 9.0.11 for fix in BZ 728332

* Thu Aug 11 2011 Martin Kosek <mkosek@redhat.com> - 2.0.90-11
- Set min nvr of xmlrpc-c and libcurl to make sure GSSAPI delegation
  support is in

* Tue Aug 2 2011 Endi S. Dewata <edewata@redhat.com> - 2.0.90-10
- Add *.ico files

* Fri Jul 29 2011 Alexander Bokovoy <abokovoy@redhat.com> - 2.0.90-9
- Add libipa_hbac-python dependency for hbactest plugin

* Thu Jul 28 2011 Rob Crittenden <rcritten@redhat.com> - 2.0.90-8
- Set min nvr of pki-ca to 9.0.10 on F-15+ to pick up updated
  caIPAserviceCert.cfg profile

* Wed Jul 20 2011 Rob Crittenden <rcritten@redhat.com> - 2.0.90-7
- Make cyrus-sasl-gssapi requires arch-specific

* Thu Jul 14 2011 Rob Crittenden <rcritten@redhat.com> - 2.0.90-6
- Add ipa-csreplica-manage tool.

* Wed Jul  6 2011 Adam Young <ayoung@redhat.com> - 2.0.90-5
- Add HTML file describing issues with HBAC deny rules

* Fri Jun 17 2011 Rob Crittenden <rcritten@redhat.com> - 2.0.90-4
- Ship ipa-ca-install utility

* Thu May 12 2011 Rob Crittenden <rcritten@redhat.com> - 2.0.90-3
- Set min nvr of selinux-policy to 3.9.16-18 on F-15+
- Set min nvr of pki-ca to 9.0.7 on F-15+

* Thu May  5 2011 Martin Kosek <mkosek@redhat.com> - 2.0.90-2
- Add BuildRequires on pylint, python-rhsm to enable a build with enforced
  pylint check

* Tue May  3 2011 Rob Crittenden <rcritten@redhat.com> - 2.0.90-1
- Bump version to 2.0.90

* Tue Apr  5 2011 Rob Crittenden <rcritten@redhat.com> - 1.99-47
- Set min version of 389-ds-base to 1.2.8.0-1 for fix in BZ 693466.

* Thu Mar 17 2011 Rob Crittenden <rcritten@redhat.com> - 1.99-46
- Automatically apply updates when the package is upgraded.

* Thu Feb 17 2011 Jakub Hrozek <jhrozek@redhat.com> - 1.99-45
- Set minimum version of python-nss to 0.11 to make sure IPv6 support is in

* Wed Feb  9 2011 Rob Crittenden <rcritten@redhat.com> - 1.99-44
- Set minimum version of sssd to 1.5.1

* Wed Feb  2 2011 Rob Crittenden <rcritten@redhat.com> - 1.99-43
- Set min version of 389-ds-base to 1.2.8
- Set min version of mod_nss 1.0.8-10
- Set min version of selinux-policy to 3.9.7-27

* Thu Jan 27 2011 Rob Crittenden <rcritten@redhat.com> - 1.99-42
- Apply changes discovered in Fedora package review process (#672986)

* Tue Jan 25 2011 Rob Crittenden <rcritten@redhat.com> - 1.99-41
- Re-arrange doc and defattr to clean up rpmlint warnings
- Remove conditionals on older releases
- Move some man pages into admintools subpackage
- Remove some explicit Requires in client that aren't needed
- Consistent use of buildroot vs RPM_BUILD_ROOT

* Wed Jan 19 2011 Adam Young <ayoung@redhat.com> - 1.99-40
- Moved directory install/static to install/ui

* Thu Jan 13 2011 Simo Sorce <ssorce@redhat.com> - 1.99-39
- Remove dependency on nss_ldap/nss-pam-ldapd
- The official client is sssd and that's what we use by default.

* Thu Jan 13 2011 Simo Sorce <ssorce@redhat.com> - 1.99-38
- Remove radius subpackages

* Thu Jan 13 2011 Rob Crittenden <rcritten@redhat.com> - 1.99-37
- Set minimum pki-ca and pki-silent versions to 9.0.0

* Wed Jan 12 2011 Rob Crittenden <rcritten@redhat.com> - 1.99-36
- Drop BuildRequires on mozldap-devel

* Mon Dec 13 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-35
- Add Requires on krb5-pkinit-openssl

* Fri Dec 10 2010 Jr Aquino <jr.aquino@citrix.com> - 1.99-34
- Add ipa-host-net-manage script

* Tue Dec  7 2010 Simo Sorce <ssorce@redhat.com> - 1.99-33
- Add ipa init script

* Fri Nov 19 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-32
- Set minimum level of 389-ds-base to 1.2.7 for enhanced memberof plugin

* Wed Nov  3 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-31
- remove ipa-fix-CVE-2008-3274

* Wed Oct  6 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-30
- Remove duplicate %%files entries on share/ipa/static
- Add python default encoding shared library

* Mon Sep 20 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-29
- Drop requires on python-configobj (not used any more)
- Drop ipa-ldap-updater message, upgrades are done differently now

* Wed Sep  8 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-28
- Drop conflicts on mod_nss
- Require nss-pam-ldapd on F-14 or higher instead of nss_ldap (#606847)
- Drop a slew of conditionals on older Fedora releases (< 12)
- Add a few conditionals against RHEL 6
- Add Requires of nss-tools on ipa-client

* Fri Aug 13 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-27
- Set minimum version of certmonger to 0.26 (to pck up #621670)
- Set minimum version of pki-silent to 1.3.4 (adds -key_algorithm)
- Set minimum version of pki-ca to 1.3.6
- Set minimum version of sssd to 1.2.1

* Tue Aug 10 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-26
- Add BuildRequires for authconfig

* Mon Jul 19 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-25
- Bump up minimum version of python-nss to pick up nss_is_initialize() API

* Thu Jun 24 2010 Adam Young <ayoung@redhat.com> - 1.99-24
- Removed python-asset based webui

* Thu Jun 24 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-23
- Change Requires from fedora-ds-base to 389-ds-base
- Set minimum level of 389-ds-base to 1.2.6 for the replication
  version plugin.

* Tue Jun  1 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-22
- Drop Requires of python-krbV on ipa-client

* Mon May 17 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-21
- Load ipa_dogtag.pp in post install

* Mon Apr 26 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-20
- Set minimum level of sssd to 1.1.1 to pull in required hbac fixes.

* Thu Mar  4 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-19
- No need to create /var/log/ipa_error.log since we aren't using
  TurboGears any more.

* Mon Mar 1 2010 Jason Gerard DeRose <jderose@redhat.com> - 1.99-18
- Fixed share/ipa/wsgi.py so .pyc, .pyo files are included

* Wed Feb 24 2010 Jason Gerard DeRose <jderose@redhat.com> - 1.99-17
- Added Require mod_wsgi, added share/ipa/wsgi.py

* Thu Feb 11 2010 Jason Gerard DeRose <jderose@redhat.com> - 1.99-16
- Require python-wehjit >= 0.2.2

* Wed Feb  3 2010 Rob Crittenden <rcritten@redhat.com> - 1.99-15
- Add sssd and certmonger as a Requires on ipa-client

* Wed Jan 27 2010 Jason Gerard DeRose <jderose@redhat.com> - 1.99-14
- Require python-wehjit >= 0.2.0

* Fri Dec  4 2009 Rob Crittenden <rcritten@redhat.com> - 1.99-13
- Add ipa-rmkeytab tool

* Tue Dec  1 2009 Rob Crittenden <rcritten@redhat.com> - 1.99-12
- Set minimum of python-pyasn1 to 0.0.9a so we have support for the ASN.1
  Any type

* Wed Nov 25 2009 Rob Crittenden <rcritten@redhat.com> - 1.99-11
- Remove v1-style /etc/ipa/ipa.conf, replacing with /etc/ipa/default.conf

* Fri Nov 13 2009 Rob Crittenden <rcritten@redhat.com> - 1.99-10
- Add bash completion script and own /etc/bash_completion.d in case it
  doesn't already exist

* Tue Nov  3 2009 Rob Crittenden <rcritten@redhat.com> - 1.99-9
- Remove ipa_webgui, its functions rolled into ipa_httpd

* Mon Oct 12 2009 Jason Gerard DeRose <jderose@redhat.com> - 1.99-8
- Removed python-cherrypy from BuildRequires and Requires
- Added Requires python-assets, python-wehjit

* Mon Aug 24 2009 Rob Crittenden <rcritten@redhat.com> - 1.99-7
- Added httpd SELinux policy so CRLs can be read

* Thu May 21 2009 Rob Crittenden <rcritten@redhat.com> - 1.99-6
- Move ipalib to ipa-python subpackage
- Bump minimum version of slapi-nis to 0.15

* Wed May  6 2009 Rob Crittenden <rcritten@redhat.com> - 1.99-5
- Set 0.14 as minimum version for slapi-nis

* Wed Apr 22 2009 Rob Crittenden <rcritten@redhat.com> - 1.99-4
- Add Requires: python-nss to ipa-python sub-package

* Thu Mar  5 2009 Rob Crittenden <rcritten@redhat.com> - 1.99-3
- Remove the IPA DNA plugin, use the DS one

* Wed Mar  4 2009 Rob Crittenden <rcritten@redhat.com> - 1.99-2
- Build radius separately
- Fix a few minor issues

* Tue Feb  3 2009 Rob Crittenden <rcritten@redhat.com> - 1.99-1
- Replace TurboGears requirement with python-cherrypy

* Sat Jan 17 2009 Tomas Mraz <tmraz@redhat.com> - 1.2.1-3
- rebuild with new openssl

* Fri Dec 19 2008 Dan Walsh <dwalsh@redhat.com> - 1.2.1-2
- Fix SELinux code

* Mon Dec 15 2008 Simo Sorce <ssorce@redhat.com> - 1.2.1-1
- Fix breakage caused by python-kerberos update to 1.1

* Fri Dec 5 2008 Simo Sorce <ssorce@redhat.com> - 1.2.1-0
- New upstream release 1.2.1

* Sat Nov 29 2008 Ignacio Vazquez-Abrams <ivazqueznet+rpm@gmail.com> - 1.2.0-4
- Rebuild for Python 2.6

* Fri Nov 14 2008 Simo Sorce <ssorce@redhat.com> - 1.2.0-3
- Respin after the tarball has been re-released upstream
  New hash is 506c9c92dcaf9f227cba5030e999f177

* Thu Nov 13 2008 Simo Sorce <ssorce@redhat.com> - 1.2.0-2
- Conditionally restart also dirsrv and httpd when upgrading

* Wed Oct 29 2008 Rob Crittenden <rcritten@redhat.com> - 1.2.0-1
- Update to upstream version 1.2.0
- Set fedora-ds-base minimum version to 1.1.3 for winsync header
- Set the minimum version for SELinux policy
- Remove references to Fedora 7

* Wed Jul 23 2008 Simo Sorce <ssorce@redhat.com> - 1.1.0-3
- Fix for CVE-2008-3274
- Fix segfault in ipa-kpasswd in case getifaddrs returns a NULL interface
- Add fix for bug #453185
- Rebuild against openldap libraries, mozldap ones do not work properly
- TurboGears is currently broken in rawhide. Added patch to not build
  the UI locales and removed them from the ipa-server files section.

* Wed Jun 18 2008 Rob Crittenden <rcritten@redhat.com> - 1.1.0-2
- Add call to /usr/sbin/upgradeconfig to post install

* Wed Jun 11 2008 Rob Crittenden <rcritten@redhat.com> - 1.1.0-1
- Update to upstream version 1.1.0
- Patch for indexing memberof attribute
- Patch for indexing uidnumber and gidnumber
- Patch to change DNA default values for replicas
- Patch to fix uninitialized variable in ipa-getkeytab

* Fri May 16 2008 Rob Crittenden <rcritten@redhat.com> - 1.0.0-5
- Set fedora-ds-base minimum version to 1.1.0.1-4 and mod_nss minimum
  version to 1.0.7-4 so we pick up the NSS fixes.
- Add selinux-policy-base(post) to Requires (446496)

* Tue Apr 29 2008 Rob Crittenden <rcritten@redhat.com> - 1.0.0-4
- Add missing entry for /var/cache/ipa/kpasswd (444624)
- Added patch to fix permissions problems with the Apache NSS database.
- Added patch to fix problem with DNS querying where the query could be
  returned as the answer.
- Fix spec error where patch1 was in the wrong section

* Fri Apr 25 2008 Rob Crittenden <rcritten@redhat.com> - 1.0.0-3
- Added patch to fix problem reported by ldapmodify

* Fri Apr 25 2008 Rob Crittenden <rcritten@redhat.com> - 1.0.0-2
- Fix Requires for krb5-server that was missing for Fedora versions > 9
- Remove quotes around test for fedora version to package egg-info

* Fri Apr 18 2008 Rob Crittenden <rcritten@redhat.com> - 1.0.0-1
- Update to upstream version 1.0.0

* Tue Mar 18 2008 Rob Crittenden <rcritten@redhat.com> 0.99-12
- Pull upstream changelog 722
- Add Conflicts mod_ssl (435360)

* Fri Feb 29 2008 Rob Crittenden <rcritten@redhat.com> 0.99-11
- Pull upstream changelog 698
- Fix ownership of /var/log/ipa_error.log during install (435119)
- Add pwpolicy command and man page

* Thu Feb 21 2008 Rob Crittenden <rcritten@redhat.com> 0.99-10
- Pull upstream changelog 678
- Add new subpackage, ipa-server-selinux
- Add Requires: authconfig to ipa-python (bz #433747)
- Package i18n files

* Mon Feb 18 2008 Rob Crittenden <rcritten@redhat.com> 0.99-9
- Pull upstream changelog 641
- Require minimum version of krb5-server on F-7 and F-8
- Package some new files

* Thu Jan 31 2008 Rob Crittenden <rcritten@redhat.com> 0.99-8
- Marked with wrong license. IPA is GPLv2.

* Tue Jan 29 2008 Rob Crittenden <rcritten@redhat.com> 0.99-7
- Ensure that /etc/ipa exists before moving user-modifiable html files there
- Put html files into /etc/ipa/html instead of /etc/ipa

* Tue Jan 29 2008 Rob Crittenden <rcritten@redhat.com> 0.99-6
- Pull upstream changelog 608 which renamed several files

* Thu Jan 24 2008 Rob Crittenden <rcritten@redhat.com> 0.99-5
- package the sessions dir /var/cache/ipa/sessions
- Pull upstream changelog 597

* Thu Jan 24 2008 Rob Crittenden <rcritten@redhat.com> 0.99-4
- Updated upstream pull (596) to fix bug in ipa_webgui that was causing the
  UI to not start.

* Thu Jan 24 2008 Rob Crittenden <rcritten@redhat.com> 0.99-3
- Included LICENSE and README in all packages for documentation
- Move user-modifiable content to /etc/ipa and linked back to
  /usr/share/ipa/html
- Changed some references to /usr to the {_usr} macro and /etc
  to {_sysconfdir}
- Added popt-devel to BuildRequires for Fedora 8 and higher and
  popt for Fedora 7
- Package the egg-info for Fedora 9 and higher for ipa-python

* Tue Jan 22 2008 Rob Crittenden <rcritten@redhat.com> 0.99-2
- Added auto* BuildRequires

* Mon Jan 21 2008 Rob Crittenden <rcritten@redhat.com> 0.99-1
- Unified spec file

* Thu Jan 17 2008 Rob Crittenden <rcritten@redhat.com> - 0.6.0-2
- Fixed License in specfile
- Include files from /usr/lib/python*/site-packages/ipaserver

* Fri Dec 21 2007 Karl MacMillan <kmacmill@redhat.com> - 0.6.0-1
- Version bump for release

* Wed Nov 21 2007 Karl MacMillan <kmacmill@mentalrootkit.com> - 0.5.0-1
- Preverse mode on ipa-keytab-util
- Version bump for relase and rpm name change

* Thu Nov 15 2007 Rob Crittenden <rcritten@redhat.com> - 0.4.1-2
- Broke invididual Requires and BuildRequires onto separate lines and
  reordered them
- Added python-tgexpandingformwidget as a dependency
- Require at least fedora-ds-base 1.1

* Thu Nov  1 2007 Karl MacMillan <kmacmill@redhat.com> - 0.4.1-1
- Version bump for release

* Wed Oct 31 2007 Karl MacMillan <kmacmill@redhat.com> - 0.4.0-6
- Add dep for freeipa-admintools and acl

* Wed Oct 24 2007 Rob Crittenden <rcritten@redhat.com> - 0.4.0-5
- Add dependency for python-krbV

* Fri Oct 19 2007 Rob Crittenden <rcritten@redhat.com> - 0.4.0-4
- Require mod_nss-1.0.7-2 for mod_proxy fixes

* Thu Oct 18 2007 Karl MacMillan <kmacmill@redhat.com> - 0.4.0-3
- Convert to autotools-based build

* Tue Sep 25 2007 Karl MacMillan <kmacmill@redhat.com> - 0.4.0-2

* Fri Sep 7 2007 Karl MacMillan <kmacmill@redhat.com> - 0.3.0-1
- Added support for libipa-dna-plugin

* Fri Aug 10 2007 Karl MacMillan <kmacmill@redhat.com> - 0.2.0-1
- Added support for ipa_kpasswd and ipa_pwd_extop

* Sun Aug  5 2007 Rob Crittenden <rcritten@redhat.com> - 0.1.0-3
- Abstracted client class to work directly or over RPC

* Wed Aug  1 2007 Rob Crittenden <rcritten@redhat.com> - 0.1.0-2
- Add mod_auth_kerb and cyrus-sasl-gssapi to Requires
- Remove references to admin server in ipa-server-setupssl
- Generate a client certificate for the XML-RPC server to connect to LDAP with
- Create a keytab for Apache
- Create an ldif with a test user
- Provide a certmap.conf for doing SSL client authentication

* Fri Jul 27 2007 Karl MacMillan <kmacmill@redhat.com> - 0.1.0-1
- Initial rpm version
