/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.Data;
import visad.ErrorEstimate;
import visad.FlatField;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.data.DataCacheManager;
import visad.data.DataRange;

public class CachedFlatField
extends FlatField {
    private Object cacheId;
    private boolean inCache = false;
    protected transient Object MUTEX = new Object();
    DataRange[] ranges;
    DataRange[] sampleRanges;
    private CachedFlatField parent;
    static int cnt = 0;
    public final int mycnt = cnt++;

    public CachedFlatField(FunctionType type, Set domainSet) throws VisADException {
        this(type, domainSet, (CoordinateSystem)null, (Set[])null, (Unit[])null, (float[][])null);
    }

    public CachedFlatField(FunctionType type, float[][] floats) throws VisADException {
        this(type, type.getDomain().getDefaultSet(), (CoordinateSystem)null, (Set[])null, (Unit[])null, floats);
    }

    public CachedFlatField(FunctionType type, Set domainSet, float[][] floats) throws VisADException {
        this(type, domainSet, (CoordinateSystem)null, (Set[])null, (Unit[])null, floats);
    }

    public CachedFlatField(FunctionType type, Set domainSet, CoordinateSystem rangeCoordSys, Set[] rangeSets, Unit[] units, float[][] floats) throws VisADException {
        this(type, domainSet, rangeCoordSys, null, rangeSets, units, floats);
    }

    public CachedFlatField(FunctionType type, Set domainSet, CoordinateSystem rangeCoordSys, CoordinateSystem[] rangeCoordSyses, Set[] rangeSets, Unit[] units, float[][] floats) throws VisADException {
        super(type, domainSet, rangeCoordSys, null, rangeSets, units);
        this.initCache(floats);
    }

    public CachedFlatField(CachedFlatField that, boolean copy, FunctionType type, Set domainSet, CoordinateSystem rangeCoordSys, CoordinateSystem[] rangeCoordSysArray, Set[] rangeSets, Unit[] units) throws VisADException {
        super(type, domainSet, rangeCoordSys, rangeCoordSysArray, rangeSets, units);
        this.ranges = that.ranges;
        this.sampleRanges = that.sampleRanges;
        this.cacheId = null;
        this.inCache = false;
        if (that.haveData()) {
            float[][] values = that.unpackFloats(true);
            if (values == null) {
                this.parent = that;
            }
            this.initCache(values);
        } else {
            this.parent = that;
            this.clearMissing();
        }
    }

    public CachedFlatField cloneMe(boolean copy, FunctionType type, Set domainSet, CoordinateSystem rangeCoordSys, CoordinateSystem[] rangeCoordSysArray, Set[] rangeSets, Unit[] units) throws VisADException {
        CachedFlatField ccf = new CachedFlatField(this, copy, type, domainSet, rangeCoordSys, rangeCoordSysArray, rangeSets, units);
        return ccf;
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.cacheId != null) {
            DataCacheManager.getCacheManager().removeFromCache(this.cacheId);
        }
    }

    public void setSamples(float[][] values, ErrorEstimate[] errors, boolean copy) throws VisADException, RemoteException {
        float[][] myFloatValues = new float[values.length][];
        for (int i = 0; i < myFloatValues.length; ++i) {
            myFloatValues[i] = copy ? (float[])values[i].clone() : values[i];
        }
        this.setRangeErrors(errors);
        if (this.inCache) {
            DataCacheManager.getCacheManager().updateData(this.cacheId, myFloatValues);
        } else {
            this.initCache(myFloatValues);
        }
    }

    public Object clone() {
        try {
            CachedFlatField ccf = (CachedFlatField)super.clone();
            ccf.cacheId = null;
            float[][] newValues = ccf.unpackFloats(false);
            ccf.nullRanges();
            ccf.initCache(newValues);
            return ccf;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new RuntimeException(exc);
        }
    }

    protected void initCache(float[][] data) throws VisADException {
        if (data != null) {
            if (this.cacheId != null) {
                DataCacheManager.getCacheManager().updateData(this.cacheId, data);
            } else {
                this.cacheId = DataCacheManager.getCacheManager().addToCache(this.getClass().getSimpleName(), data);
            }
            this.inCache = true;
        }
        if (this.ranges == null) {
            this.getRanges(data);
        }
        this.clearMissing();
    }

    public void setSampleRanges(DataRange[] sampleRanges) {
        this.sampleRanges = sampleRanges;
    }

    public void clearCachedRange() {
        this.sampleRanges = null;
        this.ranges = null;
    }

    public DataRange[] getRanges() throws VisADException {
        return this.getRanges(false);
    }

    public DataRange[] getRanges(boolean force) throws VisADException {
        if (force) {
            this.sampleRanges = null;
        }
        if (this.ranges != null) {
            return this.ranges;
        }
        if (this.sampleRanges != null) {
            return this.sampleRanges;
        }
        return this.getRanges(this.unpackFloats(false));
    }

    public DataRange[] getRanges(float[][] values) throws VisADException {
        this.sampleRanges = null;
        if (values == null) {
            return null;
        }
        this.ranges = new DataRange[values.length];
        for (int rangeIdx = 0; rangeIdx < values.length; ++rangeIdx) {
            float pMin = Float.POSITIVE_INFINITY;
            float pMax = Float.NEGATIVE_INFINITY;
            for (float value : values[rangeIdx]) {
                if (pMax < value) {
                    pMax = value;
                }
                if (!(pMin > value)) continue;
                pMin = value;
            }
            this.ranges[rangeIdx] = new DataRange(pMin, pMax);
        }
        return this.ranges;
    }

    public float[][] readData() {
        return null;
    }

    public void msg(String s) {
    }

    private float[][] getMyValues() throws VisADException {
        if (this.inCache) {
            if (this.cacheId == null) {
                return null;
            }
            return DataCacheManager.getCacheManager().getFloatArray2D(this.cacheId);
        }
        float[][] values = null;
        if (this.parent != null) {
            values = this.parent.unpackFloats(true);
            this.readValuesFromParent(this.parent);
            this.parent = null;
        }
        if (values == null) {
            values = this.readData();
        }
        if (values == null) {
            return null;
        }
        this.initCache(values);
        return values;
    }

    public boolean haveData() {
        return this.inCache;
    }

    protected void readValuesFromParent(CachedFlatField parent) throws VisADException {
    }

    public Data getSample(int index) throws VisADException, RemoteException {
        float[][] values = this.getMyValues();
        if (values == null) {
            return null;
        }
        MathType Type2 = this.getType();
        ErrorEstimate[] RangeErrors = this.getRangeErrors();
        if (this.isMissing() || index < 0 || index >= this.getLength()) {
            return ((FunctionType)Type2).getRange().missingData();
        }
        double[][] range = new double[this.TupleDimension][1];
        for (int i = 0; i < this.TupleDimension; ++i) {
            range[i][0] = values[i][index];
        }
        MathType RangeType = ((FunctionType)Type2).getRange();
        if (RangeType instanceof RealType) {
            return new Real((RealType)RangeType, range[0][0], this.RangeUnits[0], RangeErrors[0]);
        }
        if (RangeType instanceof RealTupleType) {
            Real[] reals = new Real[this.TupleDimension];
            for (int j = 0; j < this.TupleDimension; ++j) {
                MathType type = ((RealTupleType)RangeType).getComponent(j);
                reals[j] = new Real((RealType)type, range[j][0], this.RangeUnits[j], RangeErrors[j]);
            }
            return new RealTuple((RealTupleType)RangeType, reals, this.RangeCoordinateSystem);
        }
        int n = ((TupleType)RangeType).getDimension();
        int j = 0;
        Data[] datums = new Data[n];
        for (int i = 0; i < n; ++i) {
            MathType type = ((TupleType)RangeType).getComponent(i);
            if (type instanceof RealType) {
                datums[i] = new Real((RealType)type, range[j][0], this.RangeUnits[j], RangeErrors[j]);
                ++j;
                continue;
            }
            int m = ((RealTupleType)type).getDimension();
            Real[] reals = new Real[m];
            for (int k = 0; k < m; ++k) {
                RealType ctype = (RealType)((RealTupleType)type).getComponent(k);
                reals[k] = new Real(ctype, range[j][0], this.RangeUnits[j], RangeErrors[j]);
                ++j;
            }
            datums[i] = new RealTuple((RealTupleType)type, reals, this.RangeCoordinateSystems[i]);
        }
        return new Tuple(datums, false);
    }

    protected double[][] unpackValues(boolean copy) throws VisADException {
        float[][] values = this.unpackFloats(false);
        if (values == null) {
            this.msg("unpackValues: ccf: values are null ");
            return null;
        }
        double[][] doubles = new double[values.length][];
        for (int i = 0; i < values.length; ++i) {
            float[] values_i = values[i];
            double[] doubles_i = new double[values_i.length];
            doubles[i] = doubles_i;
            for (int j = 0; j < values_i.length; ++j) {
                doubles_i[j] = values_i[j];
            }
        }
        return doubles;
    }

    public float[][] unpackFloats(boolean copy) throws VisADException {
        float[][] values = this.getMyValues();
        if (values == null) {
            return super.unpackFloats(copy);
        }
        Object result = null;
        result = new float[values.length][];
        for (int i = 0; i < ((float[][])result).length; ++i) {
            result[i] = copy ? (float[])values[i].clone() : values[i];
        }
        return result;
    }

    protected float[] unpackFloats(int s_index) throws VisADException {
        float[][] values = this.getMyValues();
        if (values == null) {
            return null;
        }
        float[] range = new float[values.length];
        for (int i = 0; i < this.TupleDimension; ++i) {
            range[i] = values[i][s_index];
        }
        return range;
    }
}

