/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.ui.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thredds.catalog.CollectionType;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import thredds.catalog.dl.ADNWriter;
import thredds.catalog.dl.DIFWriter;
import thredds.catalog.ui.CatalogChooser;
import thredds.catalog.ui.CatalogTreeView;
import thredds.datatype.prefs.DateField;
import thredds.datatype.prefs.DurationField;
import thredds.ui.BAMutil;
import thredds.ui.IndependentWindow;
import thredds.ui.ProgressMonitor;
import thredds.ui.ProgressMonitorTask;
import thredds.ui.TextGetPutPane;
import thredds.ui.TextHistoryPane;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.units.DateType;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;
import ucar.util.prefs.ui.BeanTableSorted;
import ucar.util.prefs.ui.Field;
import ucar.util.prefs.ui.PersistentBean;
import ucar.util.prefs.ui.PrefPanel;

public class CatalogEnhancer
extends JPanel {
    private static final String SOURCE_WINDOW_SIZE = "SourceWindowSize";
    private static final String STATUS_WINDOW_SIZE = "StatusWindowSize";
    private PreferencesExt prefs;
    private Component myParent;
    private CatalogChooser catalogChooser;
    private CatalogTreeView tree;
    private BeanTableSorted dsTable;
    private BeanTableSorted daTable;
    private JTabbedPane tabbedPane;
    private PrefPanel.Dialog datasetEditorDialog;
    private JSplitPane splitV;
    private ArrayList tables = new ArrayList();
    private IndependentWindow sourceWindow = null;
    private IndependentWindow statusWindow = null;
    private TextGetPutPane sourcePane;
    private TextHistoryPane statusPane;
    private ArrayList daList = new ArrayList();
    private ArrayList dsList = new ArrayList();
    private InvCatalogImpl currentCatalog = null;
    private DatasetBean currentBean = null;
    private DIFWriter difWriter = new DIFWriter();
    private ADNWriter adnWriter = new ADNWriter();
    private boolean debugEvents = false;
    private boolean debugBeans = false;
    private boolean debugCheckUrl = false;

    public CatalogEnhancer(PreferencesExt prefs, Component parent) {
        this.prefs = prefs;
        this.myParent = parent;
        PreferencesExt node = prefs == null ? null : (PreferencesExt)prefs.node("catChooser");
        this.catalogChooser = new CatalogChooser(node, true, false, true);
        this.catalogChooser.setCatrefEvents(true);
        this.catalogChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                InvCatalog cat;
                String orgURLs;
                if (CatalogEnhancer.this.debugEvents) {
                    System.out.println("CatalogEnhancer chooser propertyChange= " + e.getPropertyName());
                }
                if (e.getPropertyName().equals("Catalog") && (orgURLs = (cat = CatalogEnhancer.this.catalogChooser.getCurrentCatalog()).findProperty("CatalogGenConfigOrigURL")) != null) {
                    try {
                        URI orgURL = cat.resolveUri(orgURLs);
                        orgURLs = orgURL.toString();
                        if (orgURLs.equals(cat.getUriString())) {
                            return;
                        }
                        int val = JOptionPane.showConfirmDialog(CatalogEnhancer.this.myParent, "This catalog was created by the Catalog Generator program\nIf you want to change it you should change the catgen config file\nDo you want to edit the catgen config file instead?", "WARNING - generated file; will be overrwritten", 0);
                        if (val == 0) {
                            CatalogEnhancer.this.catalogChooser.setCatalog(orgURLs);
                        }
                    }
                    catch (URISyntaxException se) {
                        return;
                    }
                }
            }
        });
        this.tree = this.catalogChooser.getTreeView();
        this.tree.setOpenCatalogReferences(false);
        this.tree.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (CatalogEnhancer.this.debugEvents) {
                    System.out.println("CatalogEnhancer tree propertyChange= " + e.getPropertyName());
                }
                if (e.getPropertyName().equals("Catalog")) {
                    CatalogEnhancer.this.daList = new ArrayList();
                    CatalogEnhancer.this.dsList = new ArrayList();
                    CatalogEnhancer.this.dsTable.setBeans(CatalogEnhancer.this.dsList);
                    CatalogEnhancer.this.daTable.setBeans(CatalogEnhancer.this.daList);
                } else if (e.getPropertyName().equals("TreeNode")) {
                    InvDatasetImpl ds = (InvDatasetImpl)e.getNewValue();
                    CatalogEnhancer.this.addDataset(ds);
                    CatalogEnhancer.this.addDatasetAccess(ds);
                } else if (e.getPropertyName().equals("Selection")) {
                    InvDatasetImpl ds = (InvDatasetImpl)e.getNewValue();
                    DatasetBean dsBean = CatalogEnhancer.this.findDatasetBean(ds);
                    CatalogEnhancer.this.dsTable.setSelectedBean(dsBean);
                }
            }
        });
        this.dsTable = new BeanTableSorted(DatasetBean.class, (PreferencesExt)prefs.node("dsBeans"), false);
        this.dsTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DatasetBean bean = (DatasetBean)CatalogEnhancer.this.dsTable.getSelectedBean();
                InvDatasetImpl selectedDataset = bean.dataset();
                CatalogEnhancer.this.catalogChooser.setSelectedDataset(selectedDataset);
            }
        });
        this.daTable = new BeanTableSorted(AccessBean.class, (PreferencesExt)prefs.node("dsBeans"), false);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.addTab("Datasets", this.dsTable);
        this.tabbedPane.addTab("Access", this.daTable);
        this.splitV = new JSplitPane(0, false, this.catalogChooser, this.tabbedPane);
        this.splitV.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitV, "Center");
        JPanel buttPanel = new JPanel();
        this.add((Component)buttPanel, "South");
        JButton edit = new JButton("Edit");
        buttPanel.add(edit);
        edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CatalogEnhancer.this.currentBean = (DatasetBean)CatalogEnhancer.this.dsTable.getSelectedBean();
                if (CatalogEnhancer.this.currentBean == null) {
                    JOptionPane.showMessageDialog(CatalogEnhancer.this.myParent, "You must first connect to a catalog and select a dataset");
                    return;
                }
                CatalogEnhancer.this.datasetEditorDialog = CatalogEnhancer.this.makeDatasetEditor(CatalogEnhancer.this.currentBean.dataset());
                CatalogEnhancer.this.datasetEditorDialog.getPrefPanel().addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CatalogEnhancer.this.currentBean.dataset().finish();
                        CatalogEnhancer.this.currentBean.synch();
                        CatalogEnhancer.this.dsTable.setSelectedBean(CatalogEnhancer.this.currentBean);
                        for (BeanTable table : CatalogEnhancer.this.tables) {
                            table.saveState(false);
                        }
                    }
                });
                CatalogEnhancer.this.datasetEditorDialog.show();
            }
        });
        this.statusPane = new TextHistoryPane(false);
        this.statusWindow = new IndependentWindow("Digital Library Status", BAMutil.getImage("thredds"), this.statusPane);
        this.statusWindow.setBounds((Rectangle)prefs.getBean(STATUS_WINDOW_SIZE, new Rectangle(50, 50, 725, 450)));
        JButton status = new JButton("Status DL");
        buttPanel.add(status);
        status.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatasetBean b = (DatasetBean)CatalogEnhancer.this.dsTable.getSelectedBean();
                CatalogEnhancer.this.statusPane.setText(b.status());
                CatalogEnhancer.this.statusWindow.show();
            }
        });
        this.sourcePane = new TextGetPutPane((PreferencesExt)prefs.node("getputPane"));
        this.sourceWindow = new IndependentWindow("Source", BAMutil.getImage("thredds"), this.sourcePane);
        this.sourceWindow.setBounds((Rectangle)prefs.getBean(SOURCE_WINDOW_SIZE, new Rectangle(50, 50, 725, 450)));
        JButton catSource = new JButton("Save");
        catSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InvCatalogImpl cat = (InvCatalogImpl)CatalogEnhancer.this.catalogChooser.getCurrentCatalog();
                if (cat == null) {
                    return;
                }
                String catURL = CatalogEnhancer.this.catalogChooser.getCurrentURL();
                try {
                    CatalogEnhancer.this.sourcePane.setCatalog(cat.getBaseURI().toString(), cat);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                CatalogEnhancer.this.sourcePane.gotoTop();
                CatalogEnhancer.this.sourceWindow.show();
            }
        });
        buttPanel.add(catSource);
        JButton openAllButton = new JButton("Open All");
        buttPanel.add(openAllButton);
        openAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CatalogEnhancer.this.tree.openAll(false);
            }
        });
        JButton checkButton = new JButton("Check access URLs");
        buttPanel.add(checkButton);
        checkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CatalogEnhancer.this.tabbedPane.setSelectedComponent(CatalogEnhancer.this.daTable);
                CheckURLsTask task = new CheckURLsTask();
                ProgressMonitor pm = new ProgressMonitor(task, 100, 100);
                pm.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CatalogEnhancer.this.daTable.revalidate();
                        CatalogEnhancer.this.daTable.repaint();
                    }
                });
                pm.start(CatalogEnhancer.this, "Checking URLs", task.getTaskLength());
            }
        });
    }

    private void writeCatalog(InvCatalogImpl catalog, String filename, InvCatalogFactory catFactory) {
        this.collapseCatalogRefs(catalog.getDataset());
        try {
            catFactory.writeXML(catalog, filename);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.myParent, "Catalog failed to write to file= " + filename + "\n" + e.getMessage());
        }
        JOptionPane.showMessageDialog(this.myParent, "Catalog written to file= " + filename);
    }

    private void collapseCatalogRefs(InvDataset ds) {
        ArrayList dlist = (ArrayList)ds.getDatasets();
        for (int i = 0; i < dlist.size(); ++i) {
            InvDataset dds = (InvDataset)dlist.get(i);
            if (dds instanceof InvCatalogRef) {
                InvCatalogRef catRef = (InvCatalogRef)dds;
                if (!catRef.isRead()) continue;
                dlist.remove(dds);
                dlist.add(i, catRef.getProxyDataset());
                System.out.println(" collapsed " + catRef.getName());
            }
            this.collapseCatalogRefs(dds);
        }
    }

    public void save() {
        this.prefs.putInt("splitPos", this.splitV.getDividerLocation());
        this.catalogChooser.save();
        this.dsTable.saveState(false);
        this.daTable.saveState(false);
    }

    private PrefPanel.Dialog makeDatasetEditor(InvDatasetImpl ds) {
        PreferencesExt prefNode = (PreferencesExt)this.prefs.node("datasetEditor");
        PersistentBean persBean = new PersistentBean(ds);
        PrefPanel.Dialog d = new PrefPanel.Dialog(null, true, "Edit Catalog Dataset", prefNode, persBean);
        PrefPanel pp = d.getPrefPanel();
        int row = 0;
        pp.addHeading("Basic", row++);
        pp.addTextField("name", "Name", "", 0, row++, "8,1");
        pp.addTextField("ID", "ID", "", 0, row, null);
        pp.addTextField("localMetadata.authority", "Authority", "", 2, row++, null);
        pp.addEnumComboField("localMetadata.dataFormatType", "Data format", DataFormatType.getAllTypes(), true, 0, row, null);
        pp.addEnumComboField("localMetadata.dataType", "Data type", Arrays.asList(FeatureType.values()), true, 2, row, null);
        pp.addEnumComboField("collectionType", "Collection type", CollectionType.getAllTypes(), true, 4, row++, null);
        pp.addHeading("GeoSpatial / Temporal Coverage", row++);
        pp.addCheckBoxField("localMetadata.geospatialCoverage.global", "Global", false, 0, row++);
        pp.addDoubleField("localMetadata.geospatialCoverage.latStart", "Starting Latitude", 0.0, 0, row, null);
        pp.addDoubleField("localMetadata.geospatialCoverage.latExtent", "Size", 0.0, 2, row, null);
        pp.addDoubleField("localMetadata.geospatialCoverage.latResolution", "Resolution", 0.0, 4, row, null);
        pp.addTextField("localMetadata.geospatialCoverage.latUnits", "Units", "", 6, row, null);
        pp.addDoubleField("localMetadata.geospatialCoverage.lonStart", "Starting Longitude", 0.0, 0, row + 1, null);
        pp.addDoubleField("localMetadata.geospatialCoverage.lonExtent", "Size", 0.0, 2, row + 1, null);
        pp.addDoubleField("localMetadata.geospatialCoverage.lonResolution", "Resolution", 0.0, 4, row + 1, null);
        pp.addTextField("localMetadata.geospatialCoverage.lonUnits", "Units", "", 6, row + 1, null);
        pp.addDoubleField("localMetadata.geospatialCoverage.heightStart", "Starting Height", 0.0, 0, row + 2, null);
        pp.addDoubleField("localMetadata.geospatialCoverage.heightExtent", "Size", 0.0, 2, row + 2, null);
        pp.addDoubleField("localMetadata.geospatialCoverage.heightResolution", "Resolution", 0.0, 4, row + 2, null);
        pp.addTextField("localMetadata.geospatialCoverage.heightUnits", "Units", "", 6, row + 2, null);
        pp.addTextField("localMetadata.geospatialCoverage.ZPositive", "Z is Positive", "up", 6, row + 3, null);
        pp.addField(new DateField("localMetadata.timeCoverage.start", "Start Date", null, persBean), 0, row += 4, null);
        pp.addField(new DateField("localMetadata.timeCoverage.end", "End Date", null, persBean), 2, row, null);
        pp.addField(new DurationField("localMetadata.timeCoverage.duration", "Duration", null, persBean), 4, row, null);
        pp.addField(new DurationField("localMetadata.timeCoverage.resolution", "Resolution", null, persBean), 6, row++, null);
        pp.addHeading("Digital Library Info", row++);
        pp.addCheckBoxField("harvest", "Harvest", false, 0, row++);
        pp.addTextAreaField("localMetadata.summary", "Summary", null, 7, 0, row, "3,1");
        pp.addTextAreaField("localMetadata.rights", "Rights", null, 7, 4, row++, "3,1");
        pp.addTextAreaField("localMetadata.history", "History", null, 7, 0, row, "3,1");
        pp.addTextAreaField("localMetadata.processing", "Process", null, 7, 4, row++, "3,1");
        pp.addEmptyRow(row++, 10);
        JTabbedPane tabPane = new JTabbedPane();
        pp.addComponent(tabPane, 0, row++, "8,1");
        this.tables = new ArrayList();
        Field.BeanTable creators = new Field.BeanTable("localMetadata.creators", "Creators", null, ThreddsMetadata.Source.class, (PreferencesExt)this.prefs.node("creators"), persBean);
        tabPane.addTab("Creators", creators.getEditComponent());
        this.tables.add(creators.getEditComponent());
        Field.BeanTable publishers = new Field.BeanTable("localMetadata.publishers", "Publishers", null, ThreddsMetadata.Source.class, (PreferencesExt)this.prefs.node("publishers"), persBean);
        tabPane.addTab("Publishers", publishers.getEditComponent());
        this.tables.add(publishers.getEditComponent());
        Field.BeanTable projects = new Field.BeanTable("localMetadata.projects", "Projects", null, ThreddsMetadata.Vocab.class, (PreferencesExt)this.prefs.node("projects"), persBean);
        tabPane.addTab("Projects", projects.getEditComponent());
        this.tables.add(projects.getEditComponent());
        Field.BeanTable keywords = new Field.BeanTable("localMetadata.keywords", "Keywords", null, ThreddsMetadata.Vocab.class, (PreferencesExt)this.prefs.node("keywords"), persBean);
        tabPane.addTab("Keywords", keywords.getEditComponent());
        this.tables.add(keywords.getEditComponent());
        Field.BeanTable dates = new Field.BeanTable("localMetadata.dates", "Dates", null, DateType.class, (PreferencesExt)this.prefs.node("dates"), persBean);
        tabPane.addTab("Dates", dates.getEditComponent());
        this.tables.add(dates.getEditComponent());
        Field.BeanTable contributors = new Field.BeanTable("localMetadata.contributors", "Contributors", null, ThreddsMetadata.Contributor.class, (PreferencesExt)this.prefs.node("contributors"), persBean);
        tabPane.addTab("Contributors", contributors.getEditComponent());
        this.tables.add(contributors.getEditComponent());
        d.finish();
        return d;
    }

    private String checkURL(String urlString) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            System.out.println(" BAD url " + urlString + " = " + e.getMessage());
            return "BAD";
        }
        try {
            InputStream is = url.openStream();
            is.close();
        }
        catch (IOException ioe) {
            System.out.println(" BAD connection " + urlString + " = " + ioe.getMessage());
            return "MISS";
        }
        return "OK";
    }

    private String makeURL(InvAccess access) {
        String urlString = access.getStandardUrlName();
        if (access.getService().getServiceType() == ServiceType.DODS) {
            urlString = urlString + ".dds";
        }
        return urlString;
    }

    public void clear() {
        this.daList = new ArrayList();
        this.dsList = new ArrayList();
    }

    public ArrayList getDatasetAccessBeans() {
        return this.daList;
    }

    public ArrayList getDatasetBeans() {
        return this.dsList;
    }

    private void addDatasets(InvDatasetImpl ds) {
        InvCatalogRef catRef;
        this.addDataset(ds);
        if (ds instanceof InvCatalogRef && !(catRef = (InvCatalogRef)ds).isRead()) {
            return;
        }
        if (ds.hasAccess()) {
            Iterator<InvAccess> iter = ds.getAccess().iterator();
            while (iter.hasNext()) {
                this.daList.add(new AccessBean(iter.next()));
            }
        }
        List<InvDataset> dlist = ds.getDatasets();
        for (int i = 0; i < dlist.size(); ++i) {
            InvDatasetImpl dds = (InvDatasetImpl)dlist.get(i);
            this.addDatasets(dds);
        }
    }

    public void addDataset(InvDatasetImpl ds) {
        DatasetBean bean = new DatasetBean(ds);
        this.dsTable.addBean(bean);
    }

    public void addDatasetAccess(InvDatasetImpl ds) {
        Iterator<InvAccess> iter = ds.getAccess().iterator();
        while (iter.hasNext()) {
            AccessBean beana = new AccessBean(iter.next());
            this.daTable.addBean(beana);
        }
    }

    public DatasetBean findDatasetBean(InvDataset ds) {
        for (DatasetBean item : this.dsList) {
            if (item.dataset() != ds) continue;
            return item;
        }
        return null;
    }

    public AccessBean findAccessBean(InvDataset ds) {
        for (AccessBean item : this.daList) {
            if (item.dataset() != ds) continue;
            return item;
        }
        return null;
    }

    public AccessBean findOrAddBean(InvAccess access) {
        for (AccessBean item : this.daList) {
            if (item.access != access) continue;
            return item;
        }
        AccessBean newBean = new AccessBean(access);
        this.daList.add(newBean);
        return newBean;
    }

    public class AccessBean {
        private InvAccess access;
        private String name;
        private String url;
        private String URLok = "";
        private FeatureType dataType;
        private DataFormatType dataFormatType;
        private ServiceType serviceType;
        private int ngrids;
        private int readTime;
        private boolean hasBoundingBox;
        private boolean hasTimeRange;
        private boolean hasStandardQuantities;

        public AccessBean() {
        }

        public AccessBean(InvAccess access) {
            this.access = access;
            InvDataset ds = access.getDataset();
            this.setName(ds.getName());
            this.setServiceType(access.getService().getServiceType());
            this.setUrl(access.getStandardUrlName());
            this.dataFormatType = access.getDataFormatType();
        }

        public InvDataset dataset() {
            return this.access.getDataset();
        }

        public InvAccess access() {
            return this.access;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getServiceType() {
            return this.serviceType.toString();
        }

        public void setServiceType(ServiceType serviceType) {
            this.serviceType = serviceType;
        }

        public String getFormat() {
            return this.dataFormatType == null ? "" : this.dataFormatType.toString();
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUrlOk() {
            return this.URLok;
        }

        public void setUrlOk(String URLok) {
            this.URLok = URLok;
        }
    }

    public class DatasetBean {
        private InvDatasetImpl ds;
        private boolean adn;
        private boolean dif;
        private boolean summary;
        private boolean rights;
        private String difMessages;

        public DatasetBean() {
        }

        public DatasetBean(InvDatasetImpl ds) {
            this.ds = ds;
            this.synch();
        }

        public void synch() {
            String s = this.ds.getDocumentation("summary");
            this.summary = s != null;
            s = this.ds.getDocumentation("rights");
            this.rights = s != null;
            StringBuffer sbuff = new StringBuffer();
            sbuff.append("DIF:\n");
            this.dif = CatalogEnhancer.this.difWriter.isDatasetUseable(this.ds, sbuff);
            sbuff.append("\nADN:\n");
            this.adn = CatalogEnhancer.this.adnWriter.isDatasetUseable(this.ds, sbuff);
            this.difMessages = sbuff.toString();
        }

        public InvDatasetImpl dataset() {
            return this.ds;
        }

        public String status() {
            return this.difMessages;
        }

        public String getId() {
            return this.ds.getID() == null ? "" : this.ds.getID();
        }

        public String getName() {
            return this.ds.getName();
        }

        public boolean isAdn() {
            return this.adn;
        }

        public boolean isDif() {
            return this.dif;
        }

        public boolean isHarvest() {
            return this.ds.isHarvest();
        }

        public boolean isGeo() {
            ThreddsMetadata.GeospatialCoverage geo = this.ds.getGeospatialCoverage();
            return geo != null && geo.isValid();
        }

        public boolean isTime() {
            return this.ds.getTimeCoverage() != null;
        }

        public boolean isVars() {
            return this.ds.getVariables().size() > 0;
        }

        public boolean isPublish() {
            return this.ds.getPublishers().size() > 0;
        }

        public boolean isRights() {
            return this.rights;
        }

        public boolean isSummary() {
            return this.summary;
        }
    }

    private class CheckURLsTask
    extends ProgressMonitorTask {
        int taskLength = 0;
        int count = 0;

        private CheckURLsTask() {
        }

        public void run() {
            for (AccessBean bean : CatalogEnhancer.this.getDatasetAccessBeans()) {
                String urlOK = bean.getUrlOk();
                if (urlOK.length() > 0) continue;
                if (this.cancel) break;
                InvAccess access = bean.access();
                if (CatalogEnhancer.this.debugCheckUrl) {
                    System.out.print("Try to open " + access.getStandardUrlName());
                }
                String status = CatalogEnhancer.this.checkURL(CatalogEnhancer.this.makeURL(access));
                if (CatalogEnhancer.this.debugCheckUrl) {
                    System.out.println(" " + status);
                }
                ++this.count;
                bean.setUrlOk(status);
            }
            this.success = !this.cancel && !this.isError();
            this.done = true;
        }

        public String getNote() {
            return this.count + " URLs out of " + this.taskLength;
        }

        public int getProgress() {
            return this.count;
        }

        public int getTaskLength() {
            this.taskLength = 0;
            for (AccessBean bean : CatalogEnhancer.this.getDatasetAccessBeans()) {
                if (bean.getUrlOk().length() > 0) continue;
                this.taskLength += bean.dataset().getAccess().size();
            }
            return this.taskLength;
        }
    }
}

