/* $Id: sig_cs.h,v 1.16 2012-03-06 14:46:49 siflkres Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_CS_H_INCLUDED
#define __SIG_CS_H_INCLUDED

#include <inttypes.h>

#include "sig_gen.h"

struct sig_cs_funcs {
	/* Slave functions. */
	int (*readb)(void *s, uint8_t *valp, unsigned long addr);
	int (*readw)(void *s, uint16_t *valp, unsigned long addr);
	int (*readl)(void *s, uint32_t *valp, unsigned long addr);
	int (*writeb)(void *s, uint8_t val, unsigned long addr);
	int (*writew)(void *s, uint16_t val, unsigned long addr);
	int (*writel)(void *s, uint32_t val, unsigned long addr);

	int (*read)(void *s, uint32_t addr, unsigned int bs, uint32_t *valp);
	int (*write)(void *s, uint32_t addr, unsigned int bs, uint32_t val);

	int (*map)(void *s, unsigned long addr,
			char **haddr_mr_p, char **haddr_mw_p);

	/* Master functions. */
	int (*unmap)(void *s, unsigned long pa, unsigned long len);
};

struct sig_cs {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_cs_funcs *f;
	} member[16];
	int nmembers;
};

struct sig_cs_merge {
	struct sig_cs *s0;
	struct sig_cs *s1;
};

extern int
sig_cs_readb(struct sig_cs *b, void *s,
		uint8_t *valp, unsigned long addr);
extern int
sig_cs_readw(struct sig_cs *b, void *s,
		uint16_t *valp, unsigned long addr);
extern int
sig_cs_readl(struct sig_cs *b, void *s,
		uint32_t *valp, unsigned long addr);
extern int
sig_cs_writeb(struct sig_cs *b, void *s,
		uint8_t val, unsigned long addr);
extern int
sig_cs_writew(struct sig_cs *b, void *s,
		uint16_t val, unsigned long addr);
extern int
sig_cs_writel(struct sig_cs *b, void *s,
		uint32_t val, unsigned long addr);

extern int
sig_cs_read(struct sig_cs *b, void *s,
		uint32_t addr, unsigned int bs, uint32_t *valp);
extern int
sig_cs_write(struct sig_cs *b, void *s,
		uint32_t addr, unsigned int bs, uint32_t val);

extern int
sig_cs_map(struct sig_cs *b, void *s, unsigned long addr,
		char **haddr_mr_p, char **haddr_mw_p);

extern int
sig_cs_unmap(struct sig_cs *b, void *s,
		unsigned long pa, unsigned long len);

extern void
sig_cs_connect(struct sig_cs *b, void *s, const struct sig_cs_funcs *f);

extern struct sig_cs_merge *
sig_cs_merge(
	struct sig_cs *s0,
	struct sig_cs *s1
);
extern void
sig_cs_split(struct sig_cs_merge *m);

extern struct sig_cs *
sig_cs_create(const char *name);
extern void
sig_cs_destroy(struct sig_cs *bus);

extern void
sig_cs_suspend(struct sig_cs *b, FILE *fSig);
extern void
sig_cs_resume(struct sig_cs *b, FILE *fSig);

#endif /* __SIG_CS_H_INCLUDED */
