/* $Id: VarDeclaration.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __VAR_DECLARATION_HPP_INCLUDED
#define __VAR_DECLARATION_HPP_INCLUDED

#include "frontend/ast/ValDeclaration.hpp"
#include "frontend/visitor/Visitor.hpp"
#include "frontend/ast/Expression.hpp"

namespace ast {
	
//! A VHDL variable declaration.
/** This class represents a declaration of a VHDL variable.
 */
class VarDeclaration : public ValDeclaration {
public:
	/** c'tor
	 *  @param accessMode mode of the Signal (in, out, inout).
	 *  @param declName the declared name 
	 *  @param varInit initializer Expression for the variable.
	 *  @param subtype subtype indication of the variable.
	 *  @param loc Location of the declaration.
	 */
	VarDeclaration(
		enum ValDeclaration::Mode accessMode,
		std::string *declName,
		Expression *varInit,
		SubtypeIndication *subtype,
		Location loc
		) :	ValDeclaration(accessMode, declName, varInit, 
					subtype, 
					ValDeclaration::OBJ_CLASS_VARIABLE,
					loc) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor &visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name != NULL);
		stream << "VARIABLE " << *this->name << " : "
			<< this->subtypeIndic;

		if (this->init != NULL) {
			stream << " := " << *this->init;
		}
		stream << ';';
	}
};

}; /* namespace ast */

#endif /* __VAR_DECLARATION_HPP_INCLUDED */
