#!/bin/sh

# Taken from the X Strike Force Build System

set -e

if ! [ -d debian/prune ]; then
	exit 0
fi

if [ "x$1" != x--upstream-version ]; then
	exit 1
fi

version="$2"
filename="$3"
source="fabulous"


if [ -z "$version" ] || ! [ -f "$filename" ]; then
	exit 1
fi

dir="$(pwd)"
tempdir="$(mktemp -d)"

cd "$tempdir"
tar xf "$dir/$filename"
cat "$dir"/debian/prune/* | while read file; do rm -rf */$file; done

tar czf "$dir/$source_$version+dfsg1.orig.tar.gz" *
cd "$dir"
rm -rf "$tempdir"
echo "Done pruning upstream tarball"

exit 0
