/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ColorWindow {
    private double[] rgb = new double[3];
    private JFrame frame;
    private JPanel colorPanel;
    private JTextArea rgbvalues;
    private JTextArea rgbhexvalues;
    private JSlider amountBar;
    private JSlider brightnessBar;
    private Box graphBox;
    private double AMOUNT = 0.5;
    private double BRIGHTNESS = 0.0;
    private Boolean GAMMA = false;
    private Boolean MERGE = false;
    private String SPECTRUMFILE = "";
    private String PREV_SPECTRUMFILE = "";
    private ColorCalculator cc = null;

    public ColorWindow() {
        this.initComponents();
        this.cc = new ColorCalculator();
    }

    public static void main(String[] args) {
        new ColorWindow();
    }

    private double applyGamma(double c) {
        if (c > 1.0) {
            c = 1.0;
        }
        double a = 0.055;
        c = c < 0.0031308 ? (c *= 12.92) : (1.0 + a) * Math.pow(c, 0.4166666666666667) - a;
        if (c > 1.0) {
            c = 1.0;
        }
        return c;
    }

    private void initComponents() {
        this.frame = new JFrame();
        this.frame.setLayout(new BorderLayout());
        JCheckBox gammayesno = new JCheckBox("Use Gamma Correction", (boolean)this.GAMMA);
        gammayesno.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorWindow.this.GAMMA = ((JCheckBox)e.getSource()).isSelected();
                ColorWindow.this.action_calculateColor();
            }
        });
        JCheckBox merge = new JCheckBox("Merge graphs", (boolean)this.MERGE);
        merge.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorWindow.this.MERGE = ((JCheckBox)e.getSource()).isSelected();
                ColorWindow.this.drawGraphs(true);
            }
        });
        Box toolsBox = Box.createHorizontalBox();
        toolsBox.add(gammayesno);
        toolsBox.add(merge);
        this.amountBar = new JSlider(0, 1000, 500);
        this.amountBar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    ColorWindow.this.AMOUNT = (double)source.getModel().getValue() / 1000.0;
                }
                ColorWindow.this.action_calculateColor();
            }
        });
        this.amountBar.setPaintLabels(true);
        this.brightnessBar = new JSlider(1, -100, 100, 0);
        this.brightnessBar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    ColorWindow.this.BRIGHTNESS = (double)source.getModel().getValue() / 1000.0;
                }
                ColorWindow.this.action_calculateColor();
            }
        });
        JList folderList = GUITools.getFolderList(null);
        JPanel listPanel = new JPanel();
        listPanel.add(folderList);
        folderList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ColorWindow.this.PREV_SPECTRUMFILE = ColorWindow.this.SPECTRUMFILE;
                ColorWindow.this.SPECTRUMFILE = ((JList)e.getSource()).getSelectedValue().toString();
                ColorWindow.this.action_calculateColor();
            }
        });
        JScrollPane scroll = new JScrollPane(listPanel);
        scroll.setAutoscrolls(true);
        scroll.setPreferredSize(new Dimension(125, 500));
        Box amBox = Box.createHorizontalBox();
        amBox.add(new JLabel("Amount"));
        amBox.add(this.amountBar);
        Box rightBox = Box.createVerticalBox();
        this.rgbvalues = new JTextArea();
        this.rgbhexvalues = new JTextArea();
        rightBox.add(this.rgbvalues);
        rightBox.add(this.rgbhexvalues);
        this.colorPanel = new JPanel();
        this.colorPanel.setMinimumSize(new Dimension(100, 100));
        this.colorPanel.setPreferredSize(new Dimension(150, 400));
        rightBox.add(this.colorPanel);
        this.graphBox = Box.createVerticalBox();
        this.frame.setMinimumSize(new Dimension(600, 400));
        this.frame.getContentPane().add((Component)rightBox, "East");
        this.frame.getContentPane().add((Component)toolsBox, "North");
        this.frame.getContentPane().add((Component)this.graphBox, "Center");
        this.frame.getContentPane().add((Component)amBox, "South");
        this.frame.getContentPane().add((Component)scroll, "West");
        this.frame.setTitle("Color viewer version 4");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void action_calculateColor() {
        int i;
        if (!this.SPECTRUMFILE.equals(this.PREV_SPECTRUMFILE)) {
            this.cc.loadAbsorbSpectrum(this.SPECTRUMFILE);
        }
        this.rgb = this.cc.calculateIlluminatedColor(this.AMOUNT, this.BRIGHTNESS);
        System.out.println("Amount: " + this.AMOUNT + " , BRIGHTNESS: " + this.BRIGHTNESS + " GAMMA correction: " + this.GAMMA);
        if (this.GAMMA.booleanValue()) {
            i = 0;
            while (i < 3) {
                this.rgb[i] = this.applyGamma(this.rgb[i]);
                ++i;
            }
        }
        i = 0;
        while (i < this.rgb.length) {
            if (this.rgb[i] < 0.0) {
                this.rgb[i] = 0.0;
            }
            if (this.rgb[i] > 1.0) {
                this.rgb[i] = 1.0;
            }
            ++i;
        }
        Color color = new Color((float)this.rgb[0], (float)this.rgb[1], (float)this.rgb[2]);
        this.colorPanel.setBackground(color);
        this.rgbvalues.setText("RGB: " + color.getRed() + " " + color.getGreen() + " " + color.getBlue());
        this.rgbhexvalues.setText("RGB: #" + Integer.toHexString(color.getRed()).toUpperCase() + Integer.toHexString(color.getGreen()).toUpperCase() + Integer.toHexString(color.getBlue()).toUpperCase());
        this.drawGraphs(false);
        this.frame.validate();
    }

    private void drawGraphs(Boolean validate) {
        this.graphBox.removeAll();
        if (this.MERGE.booleanValue()) {
            this.graphBox.add(this.cc.createGraph());
        } else {
            this.graphBox.add(this.cc.createAbsorbptionGraph());
            this.graphBox.add(this.cc.createResultLightGraph());
        }
        if (validate.booleanValue()) {
            this.frame.validate();
        }
    }
}

