/*
Copyright (C) 2002 Pedro Zorzenon Neto <pzn@vztech.com.br>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Do not forget to visit Free Software Foundation site: http://fsf.org

$Id: conf.c,v 1.2 2003/06/30 17:20:24 pzn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"

#define LINESIZE 1024

unsigned long int parport_baseaddress(void) {
  FILE *f;
  char l[LINESIZE];
  unsigned long int pp=0;

#ifdef __dos__
  f=fopen("/eep24c/eep24c.cfg","r");
  if (f==NULL) {
    f=fopen("eep24c.cfg","r");
    if (f==NULL) {
      fprintf(stderr,"could not open configuration file. tryed to open "
	      "file eep24c.cfg in directory \\eep24c\\ and also in the "
	      "current directory ");
      perror("");
      abort();
    }
  }
#else
  f=fopen("/etc/eep24c/eep24c.cfg","r");
  if (f==NULL) {
    perror("could not open configuration file /etc/eep24c/eep24c.cfg");
    abort();
  }
#endif

  /* parse config file */
  fgets(l, LINESIZE-1, f);
  while ( feof(f)==0 ) {
    if (strncmp(l,"parport_address",15)==0) {
      pp=strtoul(l+15,NULL,16);
    }
    fgets(l, LINESIZE-1, f);
  }

  if (pp==0) {
    fprintf(stderr,"did not understand config file.\n"
	    "configuration must have a line similar with the line below:\n"
	    "parport_address 378\n");
    abort();
  }
  return pp;
}
