#ifndef RPCSOCKET_H
#define RPCSOCKET_H

namespace rpc {
	
	class SocketException 
{
public:
	SocketException(char* aReason) : reason(aReason) {}
	char* getReason() const {return reason;}
private:
	char* reason;
};

class SocketListener;

/**
@author Rikard Bjorklind <olof@linux.nu>
 */
class Socket{
public:
	
	Socket(SocketListener*);
	
	// Interface for mortals
	
	void listen(int port) throw(SocketException);
	Socket* accept(SocketListener*) throw(SocketException);
	int read(void* buf,int len) throw(SocketException);
	int write(const void *buf,int len) throw(SocketException);
	void connect(const char* addr,int port);
	void disconnect();
	int getFd() {return fd;}
	void setFd(int f) {fd=f;}
	int getId() {return fd;}
	bool getIsServer() const { return isServer; }
	
	// SocketManager interface - never call these
	
	//! Called by the socketmanager when select() indicates readable
	void onRead();
	
    ~Socket();
private:
		SocketListener* listener;
	bool isServer;
	bool isConnected;
	int fd;
};

}

#endif
