/*  =========================================================================
    zhttp_response - Http response that can be received from zhttp_client or sent to zhttp_server.
Class can be reused between send & recv calls.
Headers and Content is being destroyed after every send call.

    Copyright (c) the Contributors as noted in the AUTHORS file.
    This file is part of CZMQ, the high-level C binding for 0MQ:
    http://czmq.zeromq.org.

    This Source Code Form is subject to the terms of the Mozilla Public
    License, v. 2.0. If a copy of the MPL was not distributed with this
    file, You can obtain one at http://mozilla.org/MPL/2.0/.
    =========================================================================
*/

#ifndef ZHTTP_RESPONSE_H_INCLUDED
#define ZHTTP_RESPONSE_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

//  @warning THE FOLLOWING @INTERFACE BLOCK IS AUTO-GENERATED BY ZPROJECT
//  @warning Please edit the model at "api/zhttp_response.api" to make changes.
//  @interface
//  This is a draft class, and may change without notice. It is disabled in
//  stable builds by default. If you use this in applications, please ask
//  for it to be pushed to stable state. Use --enable-drafts to enable.
#ifdef CZMQ_BUILD_DRAFT_API
//  *** Draft method, for development use, may change without warning ***
//  Create a new zhttp_response.
CZMQ_EXPORT zhttp_response_t *
    zhttp_response_new (void);

//  *** Draft method, for development use, may change without warning ***
//  Destroy the zhttp_response.
CZMQ_EXPORT void
    zhttp_response_destroy (zhttp_response_t **self_p);

//  *** Draft method, for development use, may change without warning ***
//  Send a response to a request.
//  Returns 0 if successful and -1 otherwise.
CZMQ_EXPORT int
    zhttp_response_send (zhttp_response_t *self, zsock_t *sock, void **connection);

//  *** Draft method, for development use, may change without warning ***
//  Receive a response from zhttp_client.
//  On success return 0, -1 otherwise.
//
//  Recv returns the two user arguments which was provided with the request.
//  The reason for two, is to be able to pass around the server connection when forwarding requests or both a callback function and an argument.
CZMQ_EXPORT int
    zhttp_response_recv (zhttp_response_t *self, zhttp_client_t *client, void **arg, void **arg2);

//  *** Draft method, for development use, may change without warning ***
//  Get the response content type
CZMQ_EXPORT const char *
    zhttp_response_content_type (zhttp_response_t *self);

//  *** Draft method, for development use, may change without warning ***
//  Set the content type of the response.
CZMQ_EXPORT void
    zhttp_response_set_content_type (zhttp_response_t *self, const char *value);

//  *** Draft method, for development use, may change without warning ***
//  Get the status code of the response.
CZMQ_EXPORT uint32_t
    zhttp_response_status_code (zhttp_response_t *self);

//  *** Draft method, for development use, may change without warning ***
//  Set the status code of the response.
CZMQ_EXPORT void
    zhttp_response_set_status_code (zhttp_response_t *self, uint32_t status_code);

//  *** Draft method, for development use, may change without warning ***
//  Get the headers of the response.
CZMQ_EXPORT zhash_t *
    zhttp_response_headers (zhttp_response_t *self);

//  *** Draft method, for development use, may change without warning ***
//  Get the content length of the response
CZMQ_EXPORT size_t
    zhttp_response_content_length (zhttp_response_t *self);

//  *** Draft method, for development use, may change without warning ***
//  Get the content of the response.
CZMQ_EXPORT const char *
    zhttp_response_content (zhttp_response_t *self);

//  *** Draft method, for development use, may change without warning ***
//  Get the content of the response.
//  Caller owns return value and must destroy it when done.
CZMQ_EXPORT char *
    zhttp_response_get_content (zhttp_response_t *self);

//  *** Draft method, for development use, may change without warning ***
//  Set the content of the response.
//  Content must by dynamically allocated string.
//  Takes ownership of the content.
CZMQ_EXPORT void
    zhttp_response_set_content (zhttp_response_t *self, char **content);

//  *** Draft method, for development use, may change without warning ***
//  Set the content of the response.
//  The content is assumed to be constant-memory and will therefore not be copied or deallocated in any way.
CZMQ_EXPORT void
    zhttp_response_set_content_const (zhttp_response_t *self, const char *content);

//  *** Draft method, for development use, may change without warning ***
//  Set the content to NULL
CZMQ_EXPORT void
    zhttp_response_reset_content (zhttp_response_t *self);

//  *** Draft method, for development use, may change without warning ***
//  Self test of this class.
CZMQ_EXPORT void
    zhttp_response_test (bool verbose);

#endif // CZMQ_BUILD_DRAFT_API
//  @end

#ifdef __cplusplus
}
#endif

#endif
