<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"
	    encoding="UTF-8"
	    doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"/>

<xsl:template match="/">
  <html>
    <head>
      <title>XR Status Overview</title>
      <style type="text/css">
	h1 {
	  font-family: Verdana,Helvetica;
	  font-size: 12pt;
	  color: blue;
	}
	body {
	  font-family: Verdana,Helvetica;
	  font-size: 8pt;
	}
	table {
	  border-collapse: collapse;
	  border-style: hidden;
	}
	td {
	  font-family: Verdana,Helvetica;
	  font-size: 8pt;
	  background-color: #ffff99;
	  border: 1px solid #f0f090;
	}
	input {
	  font-family: Verdana,Helvetica;
	  font-size: 8pt;
	}
	.header  { background-color: #f3f399; }
	.footer  { color: gray; }
      </style>
      <script type="text/javascript">
	function goto(uri, input) {
	  if (input == '')
	    document.location = uri;
	  else {
	    var el = document.getElementById(input);
	    if (el) {
	      var value = el.value;
	      if (value != "")
	        document.location = uri + encodeURIComponent(value);
	      else
	        document.location = uri;
	    }
	  }
	}
      </script>
    </head>
    <body>
      <h1>
	XR Status Overview
	<xsl:apply-templates select="/status/server/webinterfacename"/>
      </h1>
      <hr/>
      <xsl:apply-templates/>
    </body>
  </html>
</xsl:template>

<xsl:template match="/status/server/webinterfacename">
  <xsl:if test="/status/server/webinterfacename != ''">
    <font color="red">
      service: <xsl:value-of select="/status/server/webinterfacename"/>
    </font>
  </xsl:if>
</xsl:template>

<xsl:template match="/status">
  <table>
    <tr>
      <td valign="top">
	<!-- This is the left hand detailed status view -->
	<table>
	  <tr>
	    <td colspan="4"><b>Detailed Status</b></td>
	  </tr>
	  <tr>
	    <td colspan="4"><hr/></td>
	  </tr>
	  <xsl:apply-templates select="/status/server"/>
	  <xsl:apply-templates select="/status/backend"/>
	  
	  <tr> <td colspan="4"><hr/></td></tr>
	  <tr>
	    <td class="header" colspan="2">
	      <b>Add back end ip:port</b>
	    </td>
	    <td class="header" colspan="2" align="right">
	      <input type="text" size="30" name="addbackend" id="addbackend"
		     onchange="goto('/server/addbackend/', 'addbackend');"/>
	    </td>
	  </tr>
	  <tr> <td colspan="4"><hr/></td></tr>
    
	</table>
	<xsl:apply-templates select="/status/id"/>
      </td>
      <td valign="top">
	<!-- This is the right-hand overview -->
	<table width="100%">
	  <tr>
	    <td colspan="2"><b>Quick Overview</b></td>
	  </tr>
	  <tr>
	    <td colspan="2"><hr/></td>
	  </tr>
	  <xsl:for-each select="/status/backend">
	    <tr>
	      <td>
		<b>Back end
		  <a href="#{nr}"><xsl:value-of select="address"/></a>
		</b>
	      </td>
	      <td>
		<xsl:value-of select="up"/>,
		<xsl:value-of select="live"/>,
		<xsl:value-of select="available"/>,
		<xsl:value-of select="connections"/> connections
	      </td>
	    </tr>
	  </xsl:for-each>
	</table>
	<!-- This is the activity overview -->
	<table width="100%">
	  <tr>
	    <td colspan="5"><hr/></td>
	  </tr>
	  <tr>
	    <td colspan="5"><b>Activity</b></td>
	  </tr>
	  <tr>
	    <td colspan="5"><hr/></td>
	  </tr>
	  <tr>
	    <td colspan="3">Number of threads</td>
	    <td><xsl:value-of select="/status/activity/threadcount"/></td>
	    <td></td>
	  </tr>
	  <tr>
	    <td colspan="3">Used file descriptors (approx.)</td>
	    <td><xsl:value-of select="/status/activity/openfiles"/></td>
	    <td></td>
	  </tr>
	  <tr>
	    <td colspan="3">File descriptor limit</td>
	    <td><xsl:value-of select="/status/activity/maxopenfiles"/></td>
	    <td></td>
	  </tr>
	  <tr>
	    <td><b>Thread</b></td>
	    <td><b>Description</b></td>
	    <td><b>Back end</b></td>
	    <td><b>Duration</b></td>
	    <td></td>
	  </tr>
	  <xsl:apply-templates select="/status/activity/threadlist/thread">
	    <xsl:sort select="duration" data-type="number"/>
	  </xsl:apply-templates>
	</table>
      </td>
    </tr>
  </table>
</xsl:template>

<xsl:template match="/status/activity/threadlist/thread">
  <tr>
    <td><xsl:value-of select="id"/></td>
    <td>
      <xsl:value-of select="description"/>
      <xsl:if test="clientip != '0.0.0.0'">
	(client <xsl:value-of select="clientip"/>)
      </xsl:if>      
    </td>
    <xsl:choose>
      <xsl:when test="backend = -1">
	<td></td>
      </xsl:when>
      <xsl:otherwise>
	<td><xsl:value-of select="address"/></td>
      </xsl:otherwise>
    </xsl:choose>
    <td><xsl:value-of select="duration"/></td>
    <xsl:choose>
      <xsl:when test="backend = -1">
	<td></td>
      </xsl:when>
      <xsl:otherwise>
	<td><input type="button" value="Kill"
		   onclick="goto('/thread/kill/{id}', '');"/>
	</td>
      </xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="/status/id">
  <i>
    Powered by Crossroads V<xsl:value-of select="version"/>.
    Visit
    <a href="{distsite}" 
       target="_blank"><xsl:value-of select="distsite"/></a>
    for more info.
  </i>
</xsl:template>

<xsl:template match="/status/server">
  <tr>
    <td class="header" colspan="3">
      <b>Server <xsl:value-of select="address"/> </b>
    </td>
    <td class="header">
      <input type="button" onclick="goto('/', '');" value="Refresh"/>
    </td>
  </tr>
  <tr>
    <td>Status</td>
    <td colspan="3">
      <xsl:choose>
	<xsl:when test="terminating = 0">
	  Accepting connections,
	  <xsl:value-of select="connections"/> concurrent client(s),
	</xsl:when>
	<xsl:otherwise>
	  <font color="red">
	    Terminating, still serving
	    <xsl:value-of select="connections"/> connections,
	  </font>
	</xsl:otherwise>
      </xsl:choose>
      <xsl:value-of select="backends"/> defined back ends
    </td>
  </tr>
  <tr>
    <td>Dispatch mode</td>
    <td colspan="3"> <xsl:value-of select="dispatchmode"/> </td>
  </tr>
  <tr>
    <td>Type</td>
    <td colspan="2"></td>
    <td>
      <xsl:choose>
	<xsl:when test="type = 'http'">
	  <select onchange="goto('/server/type/tcp', '');">
	    <option value="tcp">tcp</option>
	    <option value="http" selected="1">http</option>
	  </select>
	</xsl:when>
	<xsl:otherwise>
	  <select onchange="goto('/server/type/http', '');">
	    <option value="tcp" selected="1">tcp</option>
	    <option value="http">http</option>
	  </select>
	</xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
  <tr>
    <td>Checks</td>
    <td>Wakeup interval</td>
    <td>
      <xsl:choose>
	<xsl:when test="checks/wakeupinterval = 0">
	  off
	</xsl:when>
	<xsl:otherwise>
	  sec
	</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <input type="text" size="8" name="wakeupinterval"
	     id="wakeupinterval" value="{checks/wakeupinterval}"
	     onchange="goto('/server/wakeupinterval/', 'wakeupinterval');"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>Checkup interval</td>
    <td>
      <xsl:choose>
	<xsl:when test="checks/checkupinterval = 0">
	  off
	</xsl:when>
	<xsl:otherwise>
	  sec
	</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <input type="text" size="8" name="checkupinterval"
	     id="checkupinterval" value="{checks/checkupinterval}"
	     onchange="goto('/server/checkupinterval/', 'checkupinterval');"/>
    </td>
  </tr>
  <tr>
    <td>Timeouts</td>
    <td>Client read</td>
    <td>
      <xsl:choose>
	<xsl:when test="clientreadtimeout = 0">
	  unlimited
	</xsl:when>
	<xsl:otherwise>
	  sec
	</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <input type="text" size="8" name="clientreadtimeout"
	     id="clientreadtimeout" value="{clientreadtimeout}"
	     onchange="goto('/server/clientreadtimeout/', 'clientreadtimeout');"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>Client write</td>
    <td>
      <xsl:choose>
	<xsl:when test="clientwritetimeout = 0">
	  unlimited
	</xsl:when>
	<xsl:otherwise>
	  sec
	</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <input type="text" size="8" name="clientwritetimeout"
	     id="clientwritetimeout" value="{clientwritetimeout}"
	     onchange="goto('/server/clientwritetimeout/', 'clientwritetimeout');"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>Back end read</td>
    <td>
      <xsl:choose>
	<xsl:when test="backendreadtimeout = 0">
	  unlimited
	</xsl:when>
	<xsl:otherwise>
	  sec
	</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <input type="text" size="8" name="backendreadtimeout"
	     id="backendreadtimeout" value="{backendreadtimeout}"
	     onchange="goto('/server/backendreadtimeout/', 'backendreadtimeout');"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>Back end write</td>
    <td>
      <xsl:choose>
	<xsl:when test="backendwritetimeout = 0">
	  unlimited
	</xsl:when>
	<xsl:otherwise>
	  sec
	</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <input type="text" size="8" name="backendwritetimeout"
	     id="backendwritetimeout" value="{backendwritetimeout}"
	     onchange="goto('/server/backendwritetimeout/', 'backendwritetimeout');"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>DNS cache validity</td>
    <td>
      <xsl:choose>
	<xsl:when test="dnscachetimeout = 0">
	  unused
	</xsl:when>
	<xsl:otherwise>
	  sec
	</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <input type="text" size="8" name="dnscachetimeout"
	     id="dnscachetimeout" value="{dnscachetimeout}"
	     onchange="goto('/server/dnscachetimeout/', 'dnscachetimeout');"/>
    </td>
  </tr>
  
  <tr>
    <td>Fast sockets closing</td>
    <td colspan="2">eliminates TIME_WAIT state</td>
    <td>
      <xsl:choose>
	<xsl:when test="closesocketsfast = 0">
	  <select onchange="goto('/server/closesocketsfast/on', '');">
	    <option value="yes">yes</option>
	    <option value="no" selected="1">no</option>
	  </select>
	</xsl:when>
	<xsl:otherwise>
	  <select onchange="goto('/server/closesocketsfast/off', '');">
	    <option value="yes" selected="1">yes</option>
	    <option value="no">no</option>
	  </select>
	</xsl:otherwise>
      </xsl:choose>      
    </td>
  </tr>
  <tr>
    <td>Debugging</td>
    <td colspan="2">Verbose logging</td>
    <td>
      <xsl:choose>
	<xsl:when test="debugging/verbose = 0">
	  <select onchange="goto('/server/verbose/on', '');">
	    <option value="yes">yes</option>
	    <option value="no" selected="1">no</option>
	  </select>
	</xsl:when>
	<xsl:otherwise>
	  <select onchange="goto('/server/verbose/off', '');">
	    <option value="yes" selected="1">yes</option>
	    <option value="no">no</option>
	  </select>
	</xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
  <tr>
    <td></td>
    <td colspan="2">Debug logging</td>
    <td>
      <xsl:choose>
	<xsl:when test="debugging/debug = 0">
	  <select onchange="goto('/server/debug/on', '');">
	    <option value="yes">yes</option>
	    <option value="no" selected="1">no</option>
	  </select>
	</xsl:when>
	<xsl:otherwise>
	  <select onchange="goto('/server/debug/off', '');">
	    <option value="yes" selected="1">yes</option>
	    <option value="no">no</option>
	  </select>
	</xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>Traffic log directory</td>
    <td colspan="2" align="right">
      <input type="text" size="30" name="logtrafficdir" id="logtrafficdir"
	     value="{debugging/logtrafficdir}"
	     onchange="goto('/server/logtrafficdir/', 'logtrafficdir');"/>
    </td>
  </tr>
  <tr>
    <td>Activity scripts</td>
    <td>Onstart command</td>
    <td colspan="2" align="right">
      <input type="text" size="30" name="onstart" id="onstart"
	     value="{onstart}"
	     onchange="goto('/server/onstart/', 'onstart');"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>Onend command</td>
    <td colspan="2" align="right">
      <input type="text" size="30" name="onend" id="onend"
	     value="{onend}"
	     onchange="goto('/server/onend/', 'onend');"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>Onfail command</td>
    <td colspan="2" align="right">
      <input type="text" size="30" name="onfail" id="onfail"
	     value="{onfail}"
	     onchange="goto('/server/onfail/', 'onfail');"/>
    </td>
  </tr>
  <tr>
    <td>Network buffer size</td>
    <td colspan="2">bytes</td>
    <td>
      <input type="text" size="8" name="serverbufsz" id="serverbufsz"
	     value="{buffersize}"
	     onchange="goto('/server/buffersize/', 'serverbufsz');"/>
    </td>
  </tr>
  <tr>
    <td>DOS Protection</td>
    <td>Max. connections </td>
    <td>
      <xsl:choose>
	<xsl:when test="/dosprotection/maxconnections = 0">
	  unlimited
	</xsl:when>
	<xsl:otherwise>
	  maximum value (0 for unlimited)
	</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <input type="text" size="8" name="setservermaxcon" class="input"
	     id="setservermaxcon" value="{dosprotection/maxconnections}"
	     onchange="goto('/server/maxconnections/', 'setservermaxcon');"/>
    </td>
  </tr>
  
  <tr>
    <td></td>
    <td>Sample duration</td>
    <td>sec</td>
    <td>
      <input type="text" size="8" name="timeinterval" class="input"
	     id="timeinterval" value="{dosprotection/timeinterval}"
	     onchange="goto('/server/timeinterval/', 'timeinterval');"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>Hard max connection rate</td>
    <td>
      <xsl:choose>
	<xsl:when test="/dosprotection/hardmaxconnrate = 0">
	  unlimited
	</xsl:when>
	<xsl:otherwise>
	  sessions per sample (0 for unlimited)
	</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <input type="text" size="8" name="hardmaxconnrate" class="input"
	     id="hardmaxconnrate" value="{dosprotection/hardmaxconnrate}"
	     onchange="goto('/server/hardmaxconnrate/', 'hardmaxconnrate');"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>Soft max connection rate</td>
    <td>
      <xsl:choose>
	<xsl:when test="/dosprotection/softmaxconnrate = 0">
	  unlimited
	</xsl:when>
	<xsl:otherwise>
	  sessions per sample (0 for unlimited)
	</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <input type="text" size="8" name="softmaxconnrate" class="input"
	     id="softmaxconnrate" value="{dosprotection/softmaxconnrate}"
	     onchange="goto('/server/softmaxconnrate/', 'softmaxconnrate');"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>Defer time</td>
    <td>in microsec, 1.000.000 = 1 sec</td>
    <td>
      <input type="text" size="8" name="defertime" class="input"
	     id="defertime" value="{dosprotection/defertime}"
	     onchange="goto('/server/defertime/', 'defertime');"/>
    </td>
  </tr>

  <tr>
    <td></td>
    <td>Hard excess signal program</td>
    <td colspan="2" align="right">
      <input type="text" size="30" name="hardexcess" class="input"
	     id="hardexcess" value="{dosprotection/hardmaxconnexcess}"
	     onchange="goto('/server/hardmaxconnexcess/', 'hardexcess');"/>
    </td>
  </tr>
  
  <tr>
    <td></td>
    <td>Soft excess signal program</td>
    <td colspan="2" align="right">
      <input type="text" size="30" name="softexcess" class="input"
	     id="softexcess" value="{dosprotection/softmaxconnexcess}"
	     onchange="goto('/server/softmaxconnexcess/', 'softexcess');"/>
    </td>
  </tr>
  
  <tr>
    <td>Access Control Lists</td>
    <td>New allow-from</td>
    <td colspan="2" align="right">
      <input type="text" size="30" name="addallowfrom" class="input"
	     id="addallowfrom"
	     onchange="goto('/server/addallowfrom/', 'addallowfrom');"/>
    </td>
  </tr>
  <xsl:apply-templates select="/status/server/acl/allow"/>
  <tr>
    <td></td>
    <td>New deny-from</td>
    <td colspan="2" align="right">
      <input type="text" size="30" name="adddenyfrom" class="input"
	     id="adddenyfrom"
	     onchange="goto('/server/adddenyfrom/', 'adddenyfrom');"/>
    </td>
  </tr>
  <xsl:apply-templates select="/status/server/acl/deny"/>

  <tr>
    <td>Web interface credentials</td>
    <td>Format username:password</td>
    <td colspan="2" align="right">
	<input type="text" size="30" name="webinterfaceauth" class="input"
	       id="webinterfaceauth" value="{webinterfaceauth}"
	       onchange="goto('/server/webinterfaceauth/', 'webinterfaceauth');"/>
    </td>
  </tr>
  
  <xsl:if test="/status/server/type = 'http'">
    <xsl:apply-templates select="/status/server/http"/>
  </xsl:if>
</xsl:template>

<xsl:template match="/status/backend">
  <tr> <td colspan="4"><hr/></td></tr>
  <tr>
    <td class="header" colspan="3">
      <a name="{nr}"/>
      <b> Back end <xsl:value-of select="address"/> </b>
    </td>
    <td class="header">
      <input type="button" value="Delete"
	     onclick="goto('/server/deletebackend/{nr}', '');"/>
    </td>      
  </tr>
  <tr>
    <td><b>State</b></td>
    <td>Health</td>
    <td colspan="2">
      <xsl:value-of select="live"/>,
      <xsl:value-of select="available"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>Connections</td>
    <td colspan="2">
      <xsl:value-of select="connections"/>
      <xsl:if test="anticipated &gt; 0">
	(anticipating <xsl:value-of select="anticipated"/>)
      </xsl:if>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>Connect failures</td>
    <td colspan="2">
      <xsl:value-of select="connecterrors"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>Served</td>
    <td colspan="2">
      <xsl:value-of select="bytesserved"/> bytes,
      <xsl:value-of select="clientsserved"/> clients
    </td>
  </tr>
  <tr>
    <td><b>Options</b></td>
    <td colspan="2">Weight</td>
    <td>
      <input type="text" size="8" name="setbackendweight{nr}"
	     id="setbackendweight{nr}" value="{weight}"
	     onchange="goto('/backend/{nr}/weight/', 'setbackendweight{nr}');"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td>Max. connections</td>
    <td>
      <xsl:choose>
	<xsl:when test="maxconnections = 0">
	  unlimited
	</xsl:when>
	<xsl:otherwise>
	  maximum value (0 for unlimited)
	</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <input type="text" size="8" name="setbackendmaxcon{nr}" class="input"
	     id="setbackendmaxcon{nr}" value="{maxconnections}"
	     onchange="goto('/backend/{nr}/maxconnections/', 'setbackendmaxcon{nr}');"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td colspan="2">Load average</td>
    <td>
      <input type="text" size="8" name="setloadaverage{nr}"
	     id="setloadaverage{nr}" value="{loadavg}"
	     onchange="goto('/backend/{nr}/loadavg/', 'setloadaverage{nr}');"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td colspan="2">Backend check (. to reset)</td>
    <td>
      <input type="text" size="8" name="backendcheck{nr}"
	     id="backendcheck{nr}" value="{backendcheck}"
	     onchange="goto('/backend/{nr}/backendcheck/', 'backendcheck{nr}');"/>
    </td>
  </tr>
  <xsl:if test="/status/server/type = 'http'">
    <tr>
      <td></td>
      <td>Host match</td>
      <td>
	<xsl:choose>
	  <xsl:when test="hostmatch = '.'">
	    any host request
	  </xsl:when>
	  <xsl:otherwise>
	    (. for any host)
	  </xsl:otherwise>
	</xsl:choose>
      </td>
      <td>
	<input type="text" size="8" name="sethostmatch{nr}"
	       id="sethostmatch{nr}" value="{hostmatch}"
	       onchange="goto('/backend/{nr}/hostmatch/',
			      'sethostmatch{nr}');"/>
	</td>
    </tr>
    <tr>
      <td></td>
      <td>URL match</td>
      <td>
	<xsl:choose>
	  <xsl:when test="urlmatch = '.'">
	    any url request
	  </xsl:when>
	  <xsl:otherwise>
	    (. for any url)
	  </xsl:otherwise>
	</xsl:choose>
      </td>
      <td>
	<input type="text" size="8" name="seturlmatch{nr}"
	       id="seturlmatch{nr}" value="{urlmatch}"
	       onchange="goto('/backend/{nr}/urlmatch/',
			      'seturlmatch{nr}');"/>
	</td>
    </tr>
  </xsl:if>
  <tr>
    <td></td>
    <td colspan="2">Up state</td>
    <td>
      <xsl:choose>
	<xsl:when test="up = 'up'">
	  <select onchange="goto('/backend/{nr}/up/off', '');">
	    <option value="yes" selected="1">yes</option>
	    <option value="no">no</option>
	  </select>
	</xsl:when>
	<xsl:otherwise>
	  <select onchange="goto('/backend/{nr}/up/on', '');">
	    <option value="yes">yes</option>
	    <option value="no" selected="1">no</option>
	  </select>
	</xsl:otherwise>
      </xsl:choose>
    </td>    
  </tr>
  <tr>
    <td></td>
    <td colspan="2">Stop all connections</td>
    <td>
      <input type="button" value="Stop now"
	     onclick="goto('/backend/{nr}/stopconnections', '');"/>
    </td>
  </tr>
</xsl:template>

<xsl:template match="/status/server/http">
  <tr>
    <td>HTTP Goodies</td>
    <td colspan="2">Add X-Forwarded-For</td>
    <td>
      <xsl:choose>
	<xsl:when test="addxforwardedfor = 0">
	  <select onchange="goto('/server/addxforwardedfor/on', '');">
	    <option value="yes">yes</option>
	    <option value="no" selected="1">no</option>
	  </select>
	</xsl:when>
	<xsl:otherwise>
	  <select onchange="goto('/server/addxforwardedfor/off', '');">
	    <option value="yes" selected="1">yes</option>
	    <option value="no">no</option>
	  </select>
	</xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
  <tr>
    <td></td>
    <td colspan="2">Sticky HTTP</td>
    <td>
      <xsl:choose>
	<xsl:when test="stickyhttp = 0">
	  <select onchange="goto('/server/stickyhttp/on', '');">
	    <option value="yes">yes</option>
	    <option value="no" selected="1">no</option>
	  </select>
	</xsl:when>
	<xsl:otherwise>
	  <select onchange="goto('/server/stickyhttp/off', '');">
	    <option value="yes" selected="1">yes</option>
	    <option value="no">no</option>
	  </select>
	</xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
  <tr>
    <td></td>
    <td colspan="2">Replace Host: headers</td>
    <td>
      <xsl:choose>
	<xsl:when test="replacehostheader = 0">
	  <select onchange="goto('/server/replacehostheader/on', '');">
	    <option value="yes">yes</option>
	    <option value="no" selected="1">no</option>
	  </select>
	</xsl:when>
	<xsl:otherwise>
	  <select onchange="goto('/server/replacehostheader/off', '');">
	    <option value="yes" selected="1">yes</option>
	    <option value="no">no</option>
	  </select>
	</xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
  <xsl:apply-templates select="/status/server/http/serverheaders"/>
</xsl:template>

<xsl:template match="/status/server/acl/allow">
  <xsl:for-each select="allowfrom">
    <tr>
      <td></td>
      <td>Allow from</td>
      <td colspan="2" align="right">
	<input type="text" size="30" name="allowfrom{nr}"
	       id="allowfrom{nr}" value="{mask}"
	       onchange="goto('/server/allowfrom/{nr}/', 'allowfrom{nr}');"/>
      </td>
    </tr>
  </xsl:for-each>
</xsl:template>

<xsl:template match="/status/server/acl/deny">
  <xsl:for-each select="denyfrom">
    <tr>
      <td></td>
      <td>Deny from</td>
      <td colspan="2" align="right">
	<input type="text" size="30" name="denyfrom{nr}"
	       id="denyfrom{nr}" value="{mask}"
	       onchange="goto('/server/denyfrom/{nr}/', 'denyfrom{nr}');"/>
      </td>
    </tr>
  </xsl:for-each>
</xsl:template>

<xsl:template match="/status/server/http/serverheaders">
  <xsl:for-each select="serverheader">
    <tr>
      <td></td>
      <td>Server header</td>
      <td colspan="2" align="right">
	<input type="text" size="30" name="serverheader{nr}"
	       id="serverheader{nr}" value="{header}"
	       onchange="goto('/server/changeheader/{nr}/', 'serverheader{nr}');"/>
      </td>
    </tr>
  </xsl:for-each>
  <tr>
    <td></td>
    <td>New server header</td>
    <td colspan="2" align="right">
      <input type="text" size="30" name="newserverheader"
	     id="newserverheader"
	     onchange="goto('/server/newheader/', 'newserverheader');"/>
    </td>
  </tr>
</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>
