struct cpuinfo_mock_file filesystem[] = {
#if CPUINFO_ARCH_ARM64
	{
		.path = "/proc/cpuinfo",
		.size = 398,
		.content =
			"Processor\t: AArch64 Processor rev 0 (aarch64)\n"
			"processor\t: 0\n"
			"processor\t: 1\n"
			"processor\t: 2\n"
			"processor\t: 3\n"
			"processor\t: 4\n"
			"processor\t: 5\n"
			"processor\t: 6\n"
			"processor\t: 7\n"
			"Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32 \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 8\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd08\n"
			"CPU revision\t: 0\n"
			"\n"
			"Hardware\t: Qualcomm Technologies, Inc MSM8976\n"
			"Revision\t: 0009\n"
			"Serial\t\t: 00007fc7000046a9\n",
	},
#elif CPUINFO_ARCH_ARM
	{
		.path = "/proc/cpuinfo",
		.size = 483,
		.content =
			"Processor\t: AArch64 Processor rev 0 (aarch64)\r\n"
			"processor\t: 0\r\n"
			"processor\t: 1\r\n"
			"processor\t: 2\r\n"
			"processor\t: 3\r\n"
			"processor\t: 4\r\n"
			"processor\t: 5\r\n"
			"processor\t: 6\r\n"
			"processor\t: 7\r\n"
			"Features\t: fp asimd evtstrm aes pmull sha1 sha2 crc32 wp half thumb fastmult vfp edsp neon vfpv3 tlsi vfpv4 idiva idivt \r\n"
			"CPU implementer\t: 0x41\r\n"
			"CPU architecture: 8\r\n"
			"CPU variant\t: 0x0\r\n"
			"CPU part\t: 0xd08\r\n"
			"CPU revision\t: 0\r\n"
			"\r\n"
			"Hardware\t: Qualcomm Technologies, Inc MSM8976\r\n"
			"Revision\t: 0009\r\n"
			"Serial\t\t: 00007fc7000046a9\r\n",
	},
#endif
	{
		.path = "/system/build.prop",
		.size = 9787,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=MMB29M\n"
			"ro.build.display.id=MMB29M.C9000ZHU1APC1\n"
			"ro.build.version.incremental=C9000ZHU1APC1\n"
			"ro.build.version.sdk=23\n"
			"ro.build.version.preview_sdk=0\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=6.0.1\n"
			"ro.build.version.security_patch=2017-03-01\n"
			"ro.build.version.base_os=\n"
			"ro.build.date=Fri Mar 10 16:45:59 KST 2017\n"
			"ro.build.date.utc=1489131959\n"
			"ro.build.type=user\n"
			"ro.build.user=dpi\n"
			"ro.build.host=SWDG5215\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=c9ltezh-user\n"
			"ro.product.model=SM-C9000\n"
			"ro.product.brand=samsung\n"
			"ro.product.name=c9ltezh\n"
			"ro.product.device=c9ltechn\n"
			"ro.product.board=MSM8976\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=arm64-v8a\n"
			"ro.product.cpu.abilist=arm64-v8a,armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=arm64-v8a\n"
			"ro.product.manufacturer=samsung\n"
			"ro.product.locale=en-GB\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=msm8952\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=c9ltechn\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=c9ltezh-user 6.0.1 MMB29M C9000ZHU1APC1 release-keys\n"
			"ro.build.fingerprint=samsung/c9ltezh/c9ltechn:6.0.1/MMB29M/C9000ZHU1APC1:user/release-keys\n"
			"ro.build.characteristics=phone\n"
			"# Samsung Specific Properties\n"
			"ro.build.PDA=C9000ZHU1APC1\n"
			"ro.build.hidden_ver=C9000ZHU1APC1\n"
			"ro.config.rm_preload_enabled=0\n"
			"ro.build.changelist=10182499\n"
			"ro.product_ship=true\n"
			"ro.build.official.release=true\n"
			"ro.chipname=MSM8976\n"
			"# end build properties\n"
			"\n"
			"#\n"
			"# HWUI_BUILD_PROPERTIES\n"
			"#\n"
			"ro.hwui.texture_cache_size=50\n"
			"ro.hwui.layer_cache_size=34\n"
			"ro.hwui.path_cache_size=10\n"
			"ro.hwui.texture_cache_flushrate=0.4\n"
			"ro.hwui.shape_cache_size=4\n"
			"ro.hwui.gradient_cache_size=2\n"
			"ro.hwui.drop_shadow_cache_size=6\n"
			"ro.hwui.r_buffer_cache_size=4\n"
			"ro.hwui.text_small_cache_width=1024\n"
			"ro.hwui.text_small_cache_height=1024\n"
			"ro.hwui.text_large_cache_width=2048\n"
			"ro.hwui.text_large_cache_height=1024\n"
			"#\n"
			"# from device/samsung/c9ltechn/system.prop\n"
			"#\n"
			"#\n"
			"# system.prop for msm8952_32\n"
			"#\n"
			"\n"
			"debug.sf.hw=1\n"
			"debug.egl.hw=1\n"
			"persist.hwc.mdpcomp.enable=true\n"
			"debug.mdpcomp.logs=0\n"
			"dalvik.vm.heapsize=36m\n"
			"dev.pm.dyn_samplingrate=1\n"
			"persist.demo.hdmirotationlock=false\n"
			"debug.enable.sglscale=1\n"
			"\n"
			"#ro.hdmi.enable=true\n"
			"#tunnel.decode=true\n"
			"#tunnel.audiovideo.decode=true\n"
			"#lpa.decode=false\n"
			"#lpa.use-stagefright=true\n"
			"#persist.speaker.prot.enable=false\n"
			"qcom.hw.aac.encoder=true\n"
			"\n"
			"#\n"
			"# system props for the cne module\n"
			"#\n"
			"#persist.cne.feature=1\n"
			"\n"
			"#system props for the MM modules\n"
			"media.msm8956hw=0\n"
			"media.msm8956.version=0\n"
			"mm.enable.smoothstreaming=true\n"
			"mmp.enable.3g2=true\n"
			"media.aac_51_output_enabled=true\n"
			"#codecs:(PARSER_)AAC AC3 AMR_NB AMR_WB ASF AVI DTS FLV 3GP 3G2 MKV MP2PS MP2TS MP3 OGG QCP WAV FLAC AIFF APE\n"
			"mm.enable.qcom_parser=1048575\n"
			"\n"
			"# Additional buffers shared between Camera and Video\n"
			"vidc.enc.dcvs.extra-buff-count=2\n"
			"\n"
			"#Audio voice concurrency related flags\n"
			"voice.playback.conc.disabled=true\n"
			"voice.record.conc.disabled=false\n"
			"voice.voip.conc.disabled=true\n"
			"#Decides the audio fallback path during voice call, deep-buffer and fast are the two allowed fallback paths now.\n"
			"voice.conc.fallbackpath=deep-buffer\n"
			"\n"
			"#parser input buffer size(256kb) in byte stream mode\n"
			"audio.parser.ip.buffer.size=262144\n"
			"#\n"
			"# system props for the data modules\n"
			"#\n"
			"#ro.use_data_netmgrd=true\n"
			"#persist.data.netmgrd.qos.enable=true\n"
			"#persist.data.mode=concurrent\n"
			"\n"
			"#system props for time-services\n"
			"persist.timed.enable=true\n"
			"\n"
			"#\n"
			"# system prop for opengles version\n"
			"#\n"
			"# 131072 is decimal for 0x20000 to report version 2\n"
			"# 196608 is decimal for 0x30000 to report major/minor versions as 3/0\n"
			"# 196609 is decimal for 0x30001 to report major/minor versions as 3/1\n"
			"ro.opengles.version=196609\n"
			"\n"
			"# System property for cabl\n"
			"ro.qualcomm.cabl=2\n"
			"\n"
			"#\n"
			"# System props for bluetooh\n"
			"# System prop to turn on hfp client\n"
			"bluetooth.hfp.client=1\n"
			"\n"
			"#Simulate sdcard on /data/media\n"
			"#\n"
			"persist.fuse_sdcard=true\n"
			"\n"
			"#\n"
			"#snapdragon value add features\n"
			"#\n"
			"ro.qc.sdk.audio.ssr=false\n"
			"##fluencetype can be \"fluence\" or \"fluencepro\" or \"none\"\n"
			"ro.qc.sdk.audio.fluencetype=none\n"
			"persist.audio.fluence.voicecall=true\n"
			"persist.audio.fluence.voicerec=false\n"
			"persist.audio.fluence.speaker=true\n"
			"#Set for msm8952\n"
			"tunnel.audio.encode = false\n"
			"#Buffer size in kbytes for compress offload playback\n"
			"audio.offload.buffer.size.kb=64\n"
			"#Enable offload audio video playback by default\n"
			"audio.offload.video=true\n"
			"\n"
			"#Enable PCM offload by default\n"
			"audio.offload.pcm.16bit.enable=true\n"
			"audio.offload.pcm.24bit.enable=true\n"
			"\n"
			"#Enable music through deep buffer\n"
			"audio.deep_buffer.media=true\n"
			"\n"
			"#enable voice path for PCM VoIP by default\n"
			"use.voice.path.for.pcm.voip=true\n"
			"\n"
			"#enable downsampling for multi-channel content > 48Khz\n"
			"audio.playback.mch.downsample=true\n"
			"\n"
			"#\n"
			"#System property for FM transmitter\n"
			"#\n"
			"ro.fm.transmitter=false\n"
			"#enable dsp gapless mode by default\n"
			"audio.offload.gapless.enabled=false\n"
			"\n"
			"#multi offload\n"
			"audio.offload.multiple.enabled=false\n"
			"\n"
			"#enable pbe effects\n"
			"audio.safx.pbe.enabled=true\n"
			"#property for AudioSphere Post processing\n"
			"audio.pp.asphere.enabled=false\n"
			"\n"
			"# set max background services\n"
			"ro.config.max_starting_bg=8\n"
			"\n"
			"#property to enable user to access Google WFD settings\n"
			"persist.debug.wfd.enable=1\n"
			"#propery to enable VDS WFD solution\n"
			"persist.hwc.enable_vds=1\n"
			"\n"
			"#selects CoreSight configuration to enable\n"
			"persist.debug.coresight.config=stm-events\n"
			"\n"
			"#property for vendor specific library\n"
			"ro.vendor.gt_library=libqti-gt.so\n"
			"\n"
			"#property to enable narrow search range for video encoding\n"
			"vidc.enc.narrow.searchrange=1\n"
			"\n"
			"#property to enable fingerprint\n"
			"persist.qfp=false\n"
			"\n"
			"#property to enable DS2 dap\n"
			"audio.dolby.ds2.enabled=true\n"
			"#min/max cpu in core control\n"
			"ro.core_ctl_min_cpu=2\n"
			"ro.core_ctl_max_cpu=4\n"
			"\n"
			"#HWUI properties\n"
			"ro.hwui.texture_cache_size=72\n"
			"ro.hwui.layer_cache_size=48\n"
			"ro.hwui.r_buffer_cache_size=8\n"
			"ro.hwui.path_cache_size=32\n"
			"ro.hwui.gradient_cache_size=1\n"
			"ro.hwui.drop_shadow_cache_size=6\n"
			"ro.hwui.texture_cache_flushrate=0.4\n"
			"ro.hwui.text_small_cache_width=1024\n"
			"ro.hwui.text_small_cache_height=1024\n"
			"ro.hwui.text_large_cache_width=2048\n"
			"ro.hwui.text_large_cache_height=2048\n"
			"\n"
			"#Enable B service adj transition by default\n"
			"ro.sys.fw.bservice_enable=true\n"
			"ro.sys.fw.bservice_limit=5\n"
			"ro.sys.fw.bservice_age=5000\n"
			"\n"
			"#Enable delay service restart\n"
			"ro.am.reschedule_service=true\n"
			"\n"
			"#Trim properties\n"
			"ro.sys.fw.use_trim_settings=true\n"
			"ro.sys.fw.empty_app_percent=50\n"
			"ro.sys.fw.trim_empty_percent=100\n"
			"ro.sys.fw.trim_cache_percent=100\n"
			"ro.sys.fw.trim_enable_memory=2147483648\n"
			"\n"
			"#Optimal dex2oat threads for faster app installation\n"
			"ro.sys.fw.dex2oat_thread_count=4\n"
			"\n"
			"# set cutoff voltage to 3200mV\n"
			"ro.cutoff_voltage_mv=3200\n"
			"\n"
			"#set texture cache size\n"
			"ro.hwui.texture_cache_size=40\n"
			"\n"
			"#force HAL1 for below packages\n"
			"camera.hal1.packagelist=com.skype.raider,com.google.android.talk\n"
			"\n"
			"#properties for limiting preview size in camera\n"
			"camera.display.umax=1920x1080\n"
			"camera.display.lmax=1280x720\n"
			"\n"
			"#low power mode for camera\n"
			"camera.lowpower.record.enable=1\n"
			"\n"
			"# LCD Density\n"
			"ro.sf.lcd_density=420\n"
			"\n"
			"#Status of softsim\n"
			"persist.sys.softsim.status=default,default\n"
			"\n"
			"# Qcom patch RTSP keep video damaged au\n"
			"rtsp.video.keep-damaged-au=video/3gp\n"
			"\n"
			"#Status of softsim\n"
			"persist.sys.softsim.status=default,default\n"
			"persist.sys.softsim.netmode=3g\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.astcenc.astcsupport=1\n"
			"ro.mct.compressiontype=ETC1\n"
			"ro.config.dmverity=True\n"
			"ro.config.kap=true\n"
			"ro.multisim.simslotcount=2\n"
			"ro.use_data_netmgrd=true\n"
			"persist.radio.sib16_support=0\n"
			"telephony.lteOnCdmaDevice=1\n"
			"persist.radio.tdscdma_present=1\n"
			"ro.telephony.default_network=9,1\n"
			"dalvik.vm.heapstartsize=8m\n"
			"dalvik.vm.heapgrowthlimit=256m\n"
			"dalvik.vm.heapsize=512m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapminfree=2m\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"keyguard.no_require_sim=true\n"
			"ro.carrier=unknown\n"
			"ro.security.icd.flagmode=multi\n"
			"ro.com.google.clientidbase=android-samsung\n"
			"ro.vendor.extension_library=libqti-perfd-client.so\n"
			"persist.radio.apm_sim_not_pwdn=1\n"
			"persist.radio.custom_ecc=1\n"
			"af.fast_track_multiplier=1\n"
			"audio_hal.period_size=192\n"
			"ro.build.scafe.version=2016B\n"
			"ro.build.scafe.size=short\n"
			"ro.build.scafe.shot=double\n"
			"ro.build.scafe.cream=white\n"
			"ro.security.vpnpp.ver=1.4\n"
			"ro.security.vpnpp.release=7.0\n"
			"security.mdpp.mass=skmm\n"
			"ro.hdcp2.rx=tz\n"
			"ro.config.dha_cached_min=5\n"
			"ro.config.dha_cached_max=20\n"
			"ro.config.dha_empty_init=40\n"
			"ro.config.dha_empty_max=40\n"
			"ro.config.dha_pwhitelist_enable=1\n"
			"ro.config.dha_lmk_scale=0.414\n"
			"ro.sec.fle.encryption=true\n"
			"ro.error.receiver.default=com.samsung.receiver.error\n"
			"ro.frp.pst=/dev/block/persistent\n"
			"sys.config.bigdata_enable=true\n"
			"sys.config.bigdata_mem_enable=true\n"
			"ro.config.ringtone=Over_the_Horizon.ogg\n"
			"ro.config.notification_sound=Grace_Note.ogg\n"
			"ro.config.alarm_alert=Morning_Flower.ogg\n"
			"ro.config.media_sound=Media_preview_Touch_the_light.ogg\n"
			"ro.config.ringtone_2=Basic_Bell.ogg\n"
			"ro.config.notification_sound_2=S_Charming_Bell.ogg\n"
			"ro.setupwizard.mode=OPTIONAL\n"
			"ro.com.google.gmsversion=6.0_r10\n"
			"ro.com.google.clientidbase.gmm=android-samsung\n"
			"persist.sys.dalvik.vm.lib.2=libart.so\n"
			"dalvik.vm.isa.arm64.variant=generic\n"
			"dalvik.vm.isa.arm64.features=default\n"
			"dalvik.vm.isa.arm.variant=cortex-a53\n"
			"dalvik.vm.isa.arm.features=default\n"
			"ro.build.selinux=1\n"
			"ro.config.knox=v30\n"
			"ro.config.iccc_version=1.0\n"
			"ro.config.tima=1\n"
			"ro.config.timaversion=3.0\n"
			"ro.kernel.qemu=0\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"persist.gps.qc_nlp_in_use=1\n"
			"persist.loc.nlp_name=com.qualcomm.location\n"
			"ro.gps.agps_provider=1\n"
			"ro.mdtp.package_name2=com.qualcomm.qti.securemsm.mdtp.MdtpDemo\n"
			"ro.build.version.sdl=2302\n"
			"ro.expect.recovery_id=0x454562f52b6f636ba11d93f9c9d35111660f9482000000000000000000000000\n"
			"ro.product.locale.language=en\n"
			"ro.product.locale.region=US\n"
			"persist.sys.language=en\n"
			"persist.sys.country=US\n"
			"ro.com.google.gmsversion=6.0_r6\n"
			"ro.com.google.clientidbase=android-samsung\n"
			"ro.com.google.clientidbase.gmm=android-samsung\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/bus_split",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/default_pwrlevel",
		.size = 3,
		.content = "5\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/dev",
		.size = 7,
		.content = "238:0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/available_frequencies",
		.size = 101,
		.content = "133333333 200000000 266666667 300000000 366670000 432000000 480000000 550000000 600000000 621330000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/available_governors",
		.size = 122,
		.content = "spdm_bw_hyp cache_hwmon bw_hwmon bw_vbif gpubw_mon msm-adreno-tz cpufreq userspace powersave performance simple_ondemand\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/cur_freq",
		.size = 11,
		.content = "266666667\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/governor",
		.size = 15,
		.content = "msm-adreno-tz\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/max_freq",
		.size = 11,
		.content = "621330000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/min_freq",
		.size = 11,
		.content = "266666667\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/polling_interval",
		.size = 4,
		.content = "10\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/target_freq",
		.size = 11,
		.content = "266666667\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/trans_stat",
		.size = 542,
		.content =
			"   From  :   To\r\n"
			"         :621330000550000000480000000432000000300000000266666667   time(ms)\r\n"
			" 621330000:       0       0       0       0       0       1       330\r\n"
			" 550000000:       0       0       0       0       0       0         0\r\n"
			" 480000000:       0       0       0       0       0       1      1340\r\n"
			" 432000000:       0       0       0       0       0       0         0\r\n"
			" 300000000:       0       0       0       0       0       0         0\r\n"
			"*266666667:       1       0       1       0       0       0     54400\r\n"
			"Total transition : 4\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_fast_hang_detect",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_hang_intr_status",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_long_ib_detect",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_pagefault_policy",
		.size = 5,
		.content = "0x0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_policy",
		.size = 6,
		.content = "0xC2\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/gpu_available_frequencies",
		.size = 62,
		.content = "621330000 550000000 480000000 432000000 300000000 266666667 \r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/gpubusy",
		.size = 17,
		.content = "      0       0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/gpuclk",
		.size = 11,
		.content = "266666667\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/idle_timer",
		.size = 4,
		.content = "80\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/lm",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/max_gpuclk",
		.size = 11,
		.content = "621330000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/max_pwrlevel",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/min_pwrlevel",
		.size = 3,
		.content = "5\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/num_pwrlevels",
		.size = 3,
		.content = "6\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/pmqos_active_latency",
		.size = 5,
		.content = "401\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/popp",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/reset_count",
		.size = 4,
		.content = "43\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/sptp_pc",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/thermal_pwrlevel",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/wake_nice",
		.size = 4,
		.content = "-7\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/wake_timeout",
		.size = 5,
		.content = "100\r\n",
	},
	{
		.path = "/sys/devices/soc0/accessory_chip",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/soc0/build_id",
		.size = 25,
		.content = "8976A-EAASANAZA-40000000\n",
	},
	{
		.path = "/sys/devices/soc0/foundry_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/soc0/hw_platform",
		.size = 4,
		.content = "MTP\n",
	},
	{
		.path = "/sys/devices/soc0/image_crm_version",
		.size = 5,
		.content =
			"REL\n"
			"\n",
	},
	{
		.path = "/sys/devices/soc0/image_variant",
		.size = 14,
		.content =
			"c9ltezh-user\n"
			"\n",
	},
	{
		.path = "/sys/devices/soc0/image_version",
		.size = 25,
		.content =
			"10:MMB29M:C9000ZHU1APC1\n"
			"\n",
	},
	{
		.path = "/sys/devices/soc0/machine",
		.size = 11,
		.content = "Snapdragon\n",
	},
	{
		.path = "/sys/devices/soc0/platform_subtype",
		.size = 8,
		.content = "Unknown\n",
	},
	{
		.path = "/sys/devices/soc0/platform_subtype_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/soc0/platform_version",
		.size = 6,
		.content = "65536\n",
	},
	{
		.path = "/sys/devices/soc0/pmic_die_revision",
		.size = 7,
		.content = "131072\n",
	},
	{
		.path = "/sys/devices/soc0/pmic_model",
		.size = 6,
		.content = "65552\n",
	},
	{
		.path = "/sys/devices/soc0/raw_id",
		.size = 5,
		.content = "2448\n",
	},
	{
		.path = "/sys/devices/soc0/raw_version",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/soc0/revision",
		.size = 4,
		.content = "1.1\n",
	},
	{
		.path = "/sys/devices/soc0/select_image",
		.size = 3,
		.content = "10\n",
	},
	{
		.path = "/sys/devices/soc0/soc_id",
		.size = 4,
		.content = "278\n",
	},
	{
		.path = "/sys/devices/soc0/vendor",
		.size = 9,
		.content = "Qualcomm\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "7\n",
	},
	{
		.path = "/sys/devices/system/cpu/modalias",
		.size = 66,
		.content = "cpu:type:aarch64:feature:,0000,0001,0002,0003,0004,0005,0006,0007\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 2,
		.content = "6\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 6,
		.content = "0-5,7\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 847,
		.content =
			"freq\t\tcpu0\t\tcpu1\t\tcpu2\t\tcpu3\t\tcpu4\t\tcpu5\t\tcpu6\t\tcpu7\t\t\n"
			"400000\t\t0\t\t0\t\t0\t\t0\t\t0\t\t0\t\t0\t\tN/A\t\t\n"
			"691200\t\t464\t\t0\t\t0\t\t0\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t\n"
			"806400\t\t683\t\t0\t\t0\t\t0\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t\n"
			"883200\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t236\t\t1717\t\t429\t\tN/A\t\t\n"
			"940800\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t1\t\t12\t\t13\t\tN/A\t\t\n"
			"998400\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t1\t\t10\t\t4\t\tN/A\t\t\n"
			"1017600\t\t409\t\t0\t\t0\t\t0\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t\n"
			"1056000\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t3\t\t0\t\t2\t\tN/A\t\t\n"
			"1113600\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t1\t\t0\t\t9\t\tN/A\t\t\n"
			"1190400\t\t360\t\t0\t\t0\t\t0\t\t98\t\t101\t\t180\t\tN/A\t\t\n"
			"1248000\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t7\t\t2\t\t5\t\tN/A\t\t\n"
			"1305600\t\t116\t\t0\t\t0\t\t0\t\t0\t\t0\t\t12\t\tN/A\t\t\n"
			"1382400\t\t202\t\t0\t\t0\t\t0\t\t89\t\t35\t\t140\t\tN/A\t\t\n"
			"1401600\t\t3561\t\t0\t\t0\t\t0\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t\n"
			"1612800\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t20\t\t31\t\t22\t\tN/A\t\t\n"
			"1747200\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t3\t\t0\t\t3\t\tN/A\t\t\n"
			"1804800\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t147\t\t151\t\t0\t\tN/A\t\t\n"
			"1958400\t\tN/A\t\tN/A\t\tN/A\t\tN/A\t\t1536\t\t88\t\t9\t\tN/A\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/current_in_state",
		.size = 426,
		.content =
			"CPU4:400000=0 883200=0 940800=0 998400=0 1056000=0 1113600=0 1190400=0 1248000=0 1305600=0 1382400=0 1612800=0 1747200=0 1804800=0 1958400=0 \n"
			"CPU5:400000=0 883200=0 940800=0 998400=0 1056000=0 1113600=0 1190400=0 1248000=0 1305600=0 1382400=0 1612800=0 1747200=0 1804800=0 1958400=0 \n"
			"CPU6:400000=0 883200=0 940800=0 998400=0 1056000=0 1113600=0 1190400=0 1248000=0 1305600=0 1382400=0 1612800=0 1747200=0 1804800=0 1958400=0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/cpufreq_limit/big_cpu_num",
		.size = 4,
		.content = "4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/cpufreq_limit/big_max_freq",
		.size = 8,
		.content = "1958400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/cpufreq_limit/big_min_freq",
		.size = 7,
		.content = "883200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/cpufreq_limit/hmp_boost_type",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/busy_up_thres",
		.size = 9,
		.content = "0 0 0 0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/busy_down_thres",
		.size = 9,
		.content = "0 0 0 0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/global_state",
		.size = 678,
		.content =
			"CPU0\n"
			"\tCPU: 0\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 88\n"
			"\tIs busy: 1\n"
			"\tNr running: 5\n"
			"\tAvail CPUs: 4\n"
			"\tNeed CPUs: 5\n"
			"CPU1\n"
			"\tCPU: 1\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 100\n"
			"\tIs busy: 1\n"
			"CPU2\n"
			"\tCPU: 2\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 31\n"
			"\tIs busy: 1\n"
			"CPU3\n"
			"\tCPU: 3\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 100\n"
			"\tIs busy: 1\n"
			"CPU4\n"
			"\tCPU: 4\n"
			"\tOnline: 0\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 4\n"
			"\tBusy%: 0\n"
			"\tIs busy: 0\n"
			"\tNr running: 0\n"
			"\tAvail CPUs: 4\n"
			"\tNeed CPUs: 0\n"
			"CPU5\n"
			"\tCPU: 5\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 4\n"
			"\tBusy%: 0\n"
			"\tIs busy: 0\n"
			"CPU6\n"
			"\tCPU: 6\n"
			"\tOnline: 0\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 4\n"
			"\tBusy%: 0\n"
			"\tIs busy: 0\n"
			"CPU7\n"
			"\tCPU: 7\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 4\n"
			"\tBusy%: 0\n"
			"\tIs busy: 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/is_big_cluster",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/max_cpus",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/min_cpus",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/need_cpus",
		.size = 2,
		.content = "5\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/not_preferred",
		.size = 36,
		.content =
			"\tCPU:0 0\n"
			"\tCPU:1 0\n"
			"\tCPU:2 0\n"
			"\tCPU:3 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/offline_delay_ms",
		.size = 4,
		.content = "100\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/core_ctl/task_thres",
		.size = 11,
		.content = "4294967295\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1401600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "400000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 62,
		.content = "400000 691200 806400 1017600 1190400 1305600 1382400 1401600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1401600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "691200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 92,
		.content =
			"400000 0\n"
			"691200 464\n"
			"806400 683\n"
			"1017600 409\n"
			"1190400 360\n"
			"1305600 122\n"
			"1382400 206\n"
			"1401600 3683\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 4,
		.content = "883\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 3,
		.content = "01\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1401600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "400000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 62,
		.content = "400000 691200 806400 1017600 1190400 1305600 1382400 1401600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1401600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "691200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 92,
		.content =
			"400000 0\n"
			"691200 464\n"
			"806400 696\n"
			"1017600 425\n"
			"1190400 376\n"
			"1305600 127\n"
			"1382400 222\n"
			"1401600 3873\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 4,
		.content = "902\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 3,
		.content = "02\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1401600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "400000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 62,
		.content = "400000 691200 806400 1017600 1190400 1305600 1382400 1401600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1401600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "691200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 92,
		.content =
			"400000 0\n"
			"691200 476\n"
			"806400 714\n"
			"1017600 446\n"
			"1190400 398\n"
			"1305600 132\n"
			"1382400 241\n"
			"1401600 3996\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 4,
		.content = "926\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 3,
		.content = "04\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1401600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "400000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 62,
		.content = "400000 691200 806400 1017600 1190400 1305600 1382400 1401600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1401600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "691200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 92,
		.content =
			"400000 0\n"
			"691200 476\n"
			"806400 721\n"
			"1017600 459\n"
			"1190400 432\n"
			"1305600 136\n"
			"1382400 258\n"
			"1401600 4149\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 4,
		.content = "944\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings",
		.size = 3,
		.content = "08\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings_list",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/busy_up_thres",
		.size = 13,
		.content = "68 68 68 68 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/busy_down_thres",
		.size = 13,
		.content = "40 40 40 40 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/global_state",
		.size = 674,
		.content =
			"CPU0\n"
			"\tCPU: 0\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 2\n"
			"\tIs busy: 1\n"
			"\tNr running: 2\n"
			"\tAvail CPUs: 4\n"
			"\tNeed CPUs: 4\n"
			"CPU1\n"
			"\tCPU: 1\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 0\n"
			"\tIs busy: 1\n"
			"CPU2\n"
			"\tCPU: 2\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 40\n"
			"\tIs busy: 1\n"
			"CPU3\n"
			"\tCPU: 3\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 0\n"
			"\tBusy%: 0\n"
			"\tIs busy: 1\n"
			"CPU4\n"
			"\tCPU: 4\n"
			"\tOnline: 0\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 4\n"
			"\tBusy%: 0\n"
			"\tIs busy: 0\n"
			"\tNr running: 1\n"
			"\tAvail CPUs: 4\n"
			"\tNeed CPUs: 1\n"
			"CPU5\n"
			"\tCPU: 5\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 4\n"
			"\tBusy%: 0\n"
			"\tIs busy: 0\n"
			"CPU6\n"
			"\tCPU: 6\n"
			"\tOnline: 0\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 4\n"
			"\tBusy%: 0\n"
			"\tIs busy: 0\n"
			"CPU7\n"
			"\tCPU: 7\n"
			"\tOnline: 1\n"
			"\tRejected: 0\n"
			"\tFirst CPU: 4\n"
			"\tBusy%: 70\n"
			"\tIs busy: 1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/is_big_cluster",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/max_cpus",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/min_cpus",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/need_cpus",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/not_preferred",
		.size = 36,
		.content =
			"\tCPU:4 0\n"
			"\tCPU:5 0\n"
			"\tCPU:6 0\n"
			"\tCPU:7 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/offline_delay_ms",
		.size = 4,
		.content = "100\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/core_ctl/task_thres",
		.size = 11,
		.content = "4294967295\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu4/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/affected_cpus",
		.size = 4,
		.content = "5 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1958400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "400000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/related_cpus",
		.size = 8,
		.content = "4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_available_frequencies",
		.size = 109,
		.content = "400000 883200 940800 998400 1056000 1113600 1190400 1248000 1305600 1382400 1612800 1747200 1804800 1958400 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "883200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1958400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "883200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/stats/time_in_state",
		.size = 154,
		.content =
			"400000 0\n"
			"883200 3515\n"
			"940800 43\n"
			"998400 15\n"
			"1056000 5\n"
			"1113600 11\n"
			"1190400 507\n"
			"1248000 15\n"
			"1305600 16\n"
			"1382400 279\n"
			"1612800 81\n"
			"1747200 6\n"
			"1804800 298\n"
			"1958400 2300\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/cpufreq/stats/total_trans",
		.size = 4,
		.content = "956\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_siblings",
		.size = 3,
		.content = "f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/core_siblings_list",
		.size = 4,
		.content = "4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/thread_siblings",
		.size = 3,
		.content = "20\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu5/topology/thread_siblings_list",
		.size = 2,
		.content = "5\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu6/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/affected_cpus",
		.size = 4,
		.content = "5 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1958400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "400000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/related_cpus",
		.size = 8,
		.content = "4 5 6 7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_available_frequencies",
		.size = 109,
		.content = "400000 883200 940800 998400 1056000 1113600 1190400 1248000 1305600 1382400 1612800 1747200 1804800 1958400 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "883200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_max_freq",
		.size = 8,
		.content = "1958400\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "883200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/stats/time_in_state",
		.size = 154,
		.content =
			"400000 0\n"
			"883200 4006\n"
			"940800 43\n"
			"998400 15\n"
			"1056000 5\n"
			"1113600 11\n"
			"1190400 511\n"
			"1248000 15\n"
			"1305600 16\n"
			"1382400 279\n"
			"1612800 81\n"
			"1747200 6\n"
			"1804800 298\n"
			"1958400 2300\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/cpufreq/stats/total_trans",
		.size = 4,
		.content = "958\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/core_siblings",
		.size = 3,
		.content = "f0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/core_siblings_list",
		.size = 4,
		.content = "4-7\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/physical_package_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/thread_siblings",
		.size = 3,
		.content = "80\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu7/topology/thread_siblings_list",
		.size = 2,
		.content = "7\n",
	},
	{ NULL },
};
#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "af.fast_track_multiplier",
		.value = "1",
	},
	{
		.key = "audio.deep_buffer.media",
		.value = "true",
	},
	{
		.key = "audio.dolby.ds2.enabled",
		.value = "true",
	},
	{
		.key = "audio.offload.buffer.size.kb",
		.value = "64",
	},
	{
		.key = "audio.offload.gapless.enabled",
		.value = "false",
	},
	{
		.key = "audio.offload.multiple.enabled",
		.value = "false",
	},
	{
		.key = "audio.offload.pcm.16bit.enable",
		.value = "true",
	},
	{
		.key = "audio.offload.pcm.24bit.enable",
		.value = "true",
	},
	{
		.key = "audio.offload.video",
		.value = "true",
	},
	{
		.key = "audio.parser.ip.buffer.size",
		.value = "262144",
	},
	{
		.key = "audio.playback.mch.downsample",
		.value = "true",
	},
	{
		.key = "audio.pp.asphere.enabled",
		.value = "false",
	},
	{
		.key = "audio.safx.pbe.enabled",
		.value = "true",
	},
	{
		.key = "audio_hal.period_size",
		.value = "192",
	},
	{
		.key = "audioflinger.bootsnd",
		.value = "0",
	},
	{
		.key = "bluetooth.hciattach",
		.value = "true",
	},
	{
		.key = "bluetooth.hfp.client",
		.value = "1",
	},
	{
		.key = "bluetooth.status",
		.value = "on",
	},
	{
		.key = "boot.sfbootcomplete",
		.value = "0",
	},
	{
		.key = "camera.display.lmax",
		.value = "1280x720",
	},
	{
		.key = "camera.display.umax",
		.value = "1920x1080",
	},
	{
		.key = "camera.hal1.packagelist",
		.value = "com.skype.raider,com.google.android.talk",
	},
	{
		.key = "camera.lowpower.record.enable",
		.value = "1",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "2m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm.variant",
		.value = "cortex-a53",
	},
	{
		.key = "dalvik.vm.isa.arm64.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm64.variant",
		.value = "generic",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.atrace.tags.enableflags",
		.value = "0",
	},
	{
		.key = "debug.egl.hw",
		.value = "1",
	},
	{
		.key = "debug.enable.sglscale",
		.value = "1",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.mdpcomp.logs",
		.value = "0",
	},
	{
		.key = "debug.sf.hw",
		.value = "1",
	},
	{
		.key = "debug.sf.layerdump",
		.value = "0",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "dev.kies.deviceowner",
		.value = "0",
	},
	{
		.key = "dev.kies.drivedisplay",
		.value = "0",
	},
	{
		.key = "dev.kies.drivedisplay.trust",
		.value = "1",
	},
	{
		.key = "dev.kies.sommode",
		.value = "TRUE",
	},
	{
		.key = "dev.kiessupport",
		.value = "TRUE",
	},
	{
		.key = "dev.knoxapp.running",
		.value = "false",
	},
	{
		.key = "dev.pm.dyn_samplingrate",
		.value = "1",
	},
	{
		.key = "dev.ssrm.appsync3p",
		.value = "true",
	},
	{
		.key = "dev.ssrm.dex2oat.affinity",
		.value = "",
	},
	{
		.key = "dev.ssrm.gamelevel",
		.value = "-4,5,-1,2",
	},
	{
		.key = "dev.ssrm.init",
		.value = "1",
	},
	{
		.key = "dev.ssrm.live_thumbnail",
		.value = "1",
	},
	{
		.key = "dev.ssrm.lpc_ver",
		.value = "1.0.21",
	},
	{
		.key = "dev.ssrm.mode",
		.value = "",
	},
	{
		.key = "dev.ssrm.pst",
		.value = "320",
	},
	{
		.key = "dev.ssrm.smart_switch",
		.value = "true",
	},
	{
		.key = "dhcp.wlan0.dns1",
		.value = "208.67.222.222",
	},
	{
		.key = "dhcp.wlan0.dns2",
		.value = "208.67.220.220",
	},
	{
		.key = "dhcp.wlan0.dns3",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.dns4",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.domain",
		.value = "tfbnw.net",
	},
	{
		.key = "dhcp.wlan0.gateway",
		.value = "172.22.192.1",
	},
	{
		.key = "dhcp.wlan0.ipaddress",
		.value = "172.22.221.19",
	},
	{
		.key = "dhcp.wlan0.leasetime",
		.value = "1800",
	},
	{
		.key = "dhcp.wlan0.mask",
		.value = "255.255.224.0",
	},
	{
		.key = "dhcp.wlan0.mtu",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.pid",
		.value = "2425",
	},
	{
		.key = "dhcp.wlan0.reason",
		.value = "ROUTERADVERT",
	},
	{
		.key = "dhcp.wlan0.result",
		.value = "ok",
	},
	{
		.key = "dhcp.wlan0.roaming",
		.value = "0",
	},
	{
		.key = "dhcp.wlan0.server",
		.value = "192.168.47.185",
	},
	{
		.key = "dhcp.wlan0.vendorInfo",
		.value = "",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1,1",
	},
	{
		.key = "gsm.current.vsid",
		.value = "0",
	},
	{
		.key = "gsm.current.vsid2",
		.value = "1",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown,Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "us",
	},
	{
		.key = "gsm.operator.ispsroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "310410",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = ",",
	},
	{
		.key = "gsm.sim.sixmode",
		.value = "GSM,GSM",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT,ABSENT",
	},
	{
		.key = "gsm.version.baseband",
		.value = "C9000ZHU1AQC1",
	},
	{
		.key = "gsm.version.baseband1",
		.value = "C9000ZHU1AQC1",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "Samsung RIL v3.0",
	},
	{
		.key = "init.svc.BCS-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.DR-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.RIDL",
		.value = "stopped",
	},
	{
		.key = "init.svc.SIDESYNC_service",
		.value = "running",
	},
	{
		.key = "init.svc.SMD-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.TvoutService_C",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.adsprpcd",
		.value = "running",
	},
	{
		.key = "init.svc.apaservice",
		.value = "running",
	},
	{
		.key = "init.svc.at_distributor",
		.value = "stopped",
	},
	{
		.key = "init.svc.atfwd",
		.value = "running",
	},
	{
		.key = "init.svc.audiod",
		.value = "running",
	},
	{
		.key = "init.svc.auditd",
		.value = "running",
	},
	{
		.key = "init.svc.bms-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootchecker",
		.value = "running",
	},
	{
		.key = "init.svc.ccm",
		.value = "running",
	},
	{
		.key = "init.svc.cnss-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.config_bluetooth",
		.value = "stopped",
	},
	{
		.key = "init.svc.config_bt_addr",
		.value = "stopped",
	},
	{
		.key = "init.svc.cs-early-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.cs-post-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.cs_service",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd64",
		.value = "running",
	},
	{
		.key = "init.svc.defaultcrypto",
		.value = "stopped",
	},
	{
		.key = "init.svc.dhcpcd_wlan0",
		.value = "running",
	},
	{
		.key = "init.svc.diag_uart_log",
		.value = "stopped",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.edmaudit",
		.value = "running",
	},
	{
		.key = "init.svc.epmlogd",
		.value = "stopped",
	},
	{
		.key = "init.svc.fingerprintd",
		.value = "running",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.gatekeeperd",
		.value = "running",
	},
	{
		.key = "init.svc.hciattach",
		.value = "stopped",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.icd",
		.value = "stopped",
	},
	{
		.key = "init.svc.imsd",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.insthk",
		.value = "stopped",
	},
	{
		.key = "init.svc.irsc_util",
		.value = "stopped",
	},
	{
		.key = "init.svc.jackservice",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.loc_launcher",
		.value = "running",
	},
	{
		.key = "init.svc.macloader",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mobex-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.msm_irqbal_lb",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netmgrd",
		.value = "running",
	},
	{
		.key = "init.svc.otp",
		.value = "running",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.per_mgr",
		.value = "running",
	},
	{
		.key = "init.svc.per_proxy",
		.value = "running",
	},
	{
		.key = "init.svc.perfd",
		.value = "running",
	},
	{
		.key = "init.svc.powersnd",
		.value = "stopped",
	},
	{
		.key = "init.svc.prepare_param",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcamerasvr",
		.value = "running",
	},
	{
		.key = "init.svc.qcom-c_core-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-c_main-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-post-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-usb-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qfintverify",
		.value = "stopped",
	},
	{
		.key = "init.svc.qmuxd",
		.value = "running",
	},
	{
		.key = "init.svc.qseecomd",
		.value = "running",
	},
	{
		.key = "init.svc.qseeproxydaemon",
		.value = "running",
	},
	{
		.key = "init.svc.qti",
		.value = "running",
	},
	{
		.key = "init.svc.qti-testscripts",
		.value = "stopped",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon1",
		.value = "running",
	},
	{
		.key = "init.svc.rmt_storage",
		.value = "running",
	},
	{
		.key = "init.svc.run-mobicore",
		.value = "running",
	},
	{
		.key = "init.svc.scs",
		.value = "stopped",
	},
	{
		.key = "init.svc.sdp_cryptod",
		.value = "running",
	},
	{
		.key = "init.svc.seemp_healthd",
		.value = "running",
	},
	{
		.key = "init.svc.sem_daemon",
		.value = "stopped",
	},
	{
		.key = "init.svc.sensorhubservice",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.swapon",
		.value = "stopped",
	},
	{
		.key = "init.svc.tbaseLoader",
		.value = "stopped",
	},
	{
		.key = "init.svc.tftp_server",
		.value = "running",
	},
	{
		.key = "init.svc.thermal-engine",
		.value = "running",
	},
	{
		.key = "init.svc.time_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.tunman",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.wcnss-service",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "init.svc.zygote_secondary",
		.value = "running",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "logd.auditd",
		.value = "false",
	},
	{
		.key = "logd.klogd",
		.value = "false",
	},
	{
		.key = "media.aac_51_output_enabled",
		.value = "true",
	},
	{
		.key = "media.msm8956.version",
		.value = "1",
	},
	{
		.key = "media.msm8956hw",
		.value = "1",
	},
	{
		.key = "media.settings.xml",
		.value = "/etc/media_profiles_8956.xml",
	},
	{
		.key = "mm.enable.qcom_parser",
		.value = "1048575",
	},
	{
		.key = "mm.enable.smoothstreaming",
		.value = "true",
	},
	{
		.key = "mmp.enable.3g2",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.dns2",
	},
	{
		.key = "net.dns1",
		.value = "208.67.222.222",
	},
	{
		.key = "net.dns2",
		.value = "208.67.220.220",
	},
	{
		.key = "net.hostname",
		.value = "android-7d0bfcb5c3382974",
	},
	{
		.key = "net.iptype",
		.value = "502:v4v6v6",
	},
	{
		.key = "net.knox.shareddevice.version",
		.value = "2.6.0",
	},
	{
		.key = "net.knoxscep.version",
		.value = "2.1.0",
	},
	{
		.key = "net.knoxsso.version",
		.value = "2.5.0",
	},
	{
		.key = "net.knoxvpn.version",
		.value = "2.3.0",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.smart_switch.disabled",
		.value = "1",
	},
	{
		.key = "net.tcp.2g_init_rwnd",
		.value = "10",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "4096,87380,524288,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "4093,26280,35040,4096,16384,35040",
	},
	{
		.key = "net.tcp.buffersize.evdo",
		.value = "4094,87380,524288,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "4092,8760,11680,4096,8760,11680",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "2097152,4194304,8388608,262144,524288,1048576",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "4094,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,2097152,4194304,262144,524288,1048576",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "nfc.delay.boot",
		.value = "0",
	},
	{
		.key = "nfc.fw.dfl_areacode",
		.value = "DEF",
	},
	{
		.key = "nfc.fw.downloadmode_force",
		.value = "0",
	},
	{
		.key = "nfc.fw.rfreg_display_ver",
		.value = "1",
	},
	{
		.key = "nfc.fw.rfreg_mode",
		.value = "normal",
	},
	{
		.key = "nfc.fw.rfreg_ver",
		.value = "16/12/5/17.52.10",
	},
	{
		.key = "nfc.smartcard.binded",
		.value = "true",
	},
	{
		.key = "persist.audio.allsoundmute",
		.value = "0",
	},
	{
		.key = "persist.audio.cpufreq",
		.value = "350000",
	},
	{
		.key = "persist.audio.finemediavolume",
		.value = "1",
	},
	{
		.key = "persist.audio.fluence.speaker",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicecall",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicerec",
		.value = "false",
	},
	{
		.key = "persist.audio.globaleffect",
		.value = "1",
	},
	{
		.key = "persist.audio.headsetsysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.hphonesysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.k2hd",
		.value = "1",
	},
	{
		.key = "persist.audio.mpseek",
		.value = "0",
	},
	{
		.key = "persist.audio.mysound",
		.value = "1",
	},
	{
		.key = "persist.audio.ringermode",
		.value = "2",
	},
	{
		.key = "persist.audio.sales_code",
		.value = "TGY",
	},
	{
		.key = "persist.audio.soundalivefxsec",
		.value = "1",
	},
	{
		.key = "persist.audio.stereospeaker",
		.value = "0",
	},
	{
		.key = "persist.audio.sysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.uhqa",
		.value = "1",
	},
	{
		.key = "persist.audio.voipcpufreq",
		.value = "350000",
	},
	{
		.key = "persist.camera.c2d.debug.mask",
		.value = "1",
	},
	{
		.key = "persist.camera.cpp.debug.mask",
		.value = "1",
	},
	{
		.key = "persist.camera.debug.logfile",
		.value = "0",
	},
	{
		.key = "persist.camera.global.debug",
		.value = "1",
	},
	{
		.key = "persist.camera.hal.debug",
		.value = "1",
	},
	{
		.key = "persist.camera.iface.logs",
		.value = "1",
	},
	{
		.key = "persist.camera.imglib.logs",
		.value = "1",
	},
	{
		.key = "persist.camera.isp.debug",
		.value = "1",
	},
	{
		.key = "persist.camera.mct.debug",
		.value = "1",
	},
	{
		.key = "persist.camera.mmstill.logs",
		.value = "1",
	},
	{
		.key = "persist.camera.pproc.debug.mask",
		.value = "1",
	},
	{
		.key = "persist.camera.sensor.debug",
		.value = "1",
	},
	{
		.key = "persist.camera.stats.debug.mask",
		.value = "1",
	},
	{
		.key = "persist.cne.feature",
		.value = "0",
	},
	{
		.key = "persist.data.dpm.enable",
		.value = "true",
	},
	{
		.key = "persist.data.dropssdp",
		.value = "false",
	},
	{
		.key = "persist.data.mode",
		.value = "concurrent",
	},
	{
		.key = "persist.data.netmgrd.qos.enable",
		.value = "true",
	},
	{
		.key = "persist.debug.coresight.config",
		.value = "stm-events",
	},
	{
		.key = "persist.debug.wfd.enable",
		.value = "1",
	},
	{
		.key = "persist.demo.hdmirotationlock",
		.value = "false",
	},
	{
		.key = "persist.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "persist.gps.qc_nlp_in_use",
		.value = "1",
	},
	{
		.key = "persist.hwc.enable_vds",
		.value = "1",
	},
	{
		.key = "persist.hwc.mdpcomp.enable",
		.value = "true",
	},
	{
		.key = "persist.loc.nlp_name",
		.value = "com.qualcomm.location",
	},
	{
		.key = "persist.qfp",
		.value = "false",
	},
	{
		.key = "persist.radio.add_power_save",
		.value = "1",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.custom_ecc",
		.value = "1",
	},
	{
		.key = "persist.radio.initphone-type",
		.value = "1,1",
	},
	{
		.key = "persist.radio.last.phonetype",
		.value = "1,1",
	},
	{
		.key = "persist.radio.latest-modeltype",
		.value = "2",
	},
	{
		.key = "persist.radio.lte_vrte_ltd",
		.value = "1",
	},
	{
		.key = "persist.radio.multisim.config",
		.value = "dsds",
	},
	{
		.key = "persist.radio.multisim.stackid",
		.value = "0,1",
	},
	{
		.key = "persist.radio.plmnname",
		.value = ",",
	},
	{
		.key = "persist.radio.sib16_support",
		.value = "0",
	},
	{
		.key = "persist.radio.silent-reset",
		.value = "2",
	},
	{
		.key = "persist.radio.sim.onoff",
		.value = "1,1",
	},
	{
		.key = "persist.radio.tdscdma_present",
		.value = "1",
	},
	{
		.key = "persist.ril.dfm.srlte",
		.value = "false",
	},
	{
		.key = "persist.ril.ims.eutranParam",
		.value = "0",
	},
	{
		.key = "persist.ril.ims.utranParam",
		.value = "0",
	},
	{
		.key = "persist.ril.modem.board",
		.value = "MSM8976",
	},
	{
		.key = "persist.ril.radiocapa.tdscdma",
		.value = "true",
	},
	{
		.key = "persist.security.ams.enforcing",
		.value = "3",
	},
	{
		.key = "persist.security.tlc.ccm",
		.value = "0",
	},
	{
		.key = "persist.security.tlc.otp",
		.value = "0",
	},
	{
		.key = "persist.service.bdroid.version",
		.value = "4.2",
	},
	{
		.key = "persist.sys.SUWRebootReason",
		.value = "",
	},
	{
		.key = "persist.sys.bpmsetting.enable",
		.value = "1",
	},
	{
		.key = "persist.sys.ccm.date",
		.value = "Fri Mar 10 16:45:59 KST 2017",
	},
	{
		.key = "persist.sys.country",
		.value = "",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.drs.date",
		.value = "Fri Mar 10 16:45:59 KST 2017",
	},
	{
		.key = "persist.sys.ims.supportmmtel1",
		.value = "0",
	},
	{
		.key = "persist.sys.ims.supportmmtel2",
		.value = "0",
	},
	{
		.key = "persist.sys.kap.date",
		.value = "Fri Mar 10 16:45:59 KST 2017",
	},
	{
		.key = "persist.sys.kap.status",
		.value = "NONE",
	},
	{
		.key = "persist.sys.language",
		.value = "",
	},
	{
		.key = "persist.sys.locale",
		.value = "en-US",
	},
	{
		.key = "persist.sys.localedefault",
		.value = "en-US",
	},
	{
		.key = "persist.sys.localevar",
		.value = "",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.sb.setting.enabled",
		.value = "false",
	},
	{
		.key = "persist.sys.setupwizard",
		.value = "FINISH",
	},
	{
		.key = "persist.sys.sm_mode",
		.value = "1",
	},
	{
		.key = "persist.sys.softsim.netmode",
		.value = "3g",
	},
	{
		.key = "persist.sys.softsim.status",
		.value = "default,default",
	},
	{
		.key = "persist.sys.ssrm_unbox_cnt",
		.value = "0",
	},
	{
		.key = "persist.sys.storage_preload",
		.value = "2",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/New_York",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.sys.usb.config.extra",
		.value = "none",
	},
	{
		.key = "persist.sys.usb.dualrole",
		.value = "false",
	},
	{
		.key = "persist.timed.enable",
		.value = "true",
	},
	{
		.key = "qcom.hw.aac.encoder",
		.value = "true",
	},
	{
		.key = "qemu.hw.mainkeys",
		.value = "0",
	},
	{
		.key = "ril.CompleteMsg",
		.value = "OK",
	},
	{
		.key = "ril.ICC_TYPE",
		.value = "0,0",
	},
	{
		.key = "ril.IsCSIM",
		.value = "0,0",
	},
	{
		.key = "ril.RildInit",
		.value = "1,1",
	},
	{
		.key = "ril.airplane.mode",
		.value = "0",
	},
	{
		.key = "ril.approved_codever",
		.value = "none",
	},
	{
		.key = "ril.approved_cscver",
		.value = "none",
	},
	{
		.key = "ril.approved_modemver",
		.value = "none",
	},
	{
		.key = "ril.atd_status",
		.value = "1_0_0",
	},
	{
		.key = "ril.backoffstate",
		.value = "1024",
	},
	{
		.key = "ril.cold_sim",
		.value = "0",
	},
	{
		.key = "ril.cs_svc",
		.value = "1",
	},
	{
		.key = "ril.dds.socket_num",
		.value = "-1",
	},
	{
		.key = "ril.debug_modemfactory",
		.value = "CSC Feature State: IMS ON, EPDG OFF",
	},
	{
		.key = "ril.ecclist0",
		.value = "911,*911,#911,112,000,08,110,999,118,119",
	},
	{
		.key = "ril.ecclist00",
		.value = "112,911,999,000,110,118,119",
	},
	{
		.key = "ril.ecclist10",
		.value = "112,911,999,000,08,110,118,119,120,122",
	},
	{
		.key = "ril.ecclist_net0",
		.value = "",
	},
	{
		.key = "ril.ecclist_net1",
		.value = "",
	},
	{
		.key = "ril.eri_num",
		.value = "1",
	},
	{
		.key = "ril.eri_ver_1",
		.value = "E:None ",
	},
	{
		.key = "ril.hasisim",
		.value = "0,0",
	},
	{
		.key = "ril.hw_ver",
		.value = "REV01",
	},
	{
		.key = "ril.ims.ecsupport",
		.value = "0",
	},
	{
		.key = "ril.initPB",
		.value = "0",
	},
	{
		.key = "ril.initPB2",
		.value = "0",
	},
	{
		.key = "ril.isctc",
		.value = "0,0",
	},
	{
		.key = "ril.modem.board",
		.value = "MSM8976",
	},
	{
		.key = "ril.official_cscver",
		.value = "C9000ZZH1AQC1",
	},
	{
		.key = "ril.product_code",
		.value = "SM-C9000ZKATGY",
	},
	{
		.key = "ril.radiostate",
		.value = "10",
	},
	{
		.key = "ril.rfcal_date",
		.value = "2017.03.01",
	},
	{
		.key = "ril.serialnumber",
		.value = "R28J3003TQE",
	},
	{
		.key = "ril.servicestate",
		.value = "2",
	},
	{
		.key = "ril.simoperator",
		.value = ",",
	},
	{
		.key = "ril.ss.routing",
		.value = "0,0",
	},
	{
		.key = "ril.subinfo",
		.value = "0:2147483643,1:2147483644",
	},
	{
		.key = "ril.sw_ver",
		.value = "C9000ZHU1AQC1",
	},
	{
		.key = "ril.timezoneID",
		.value = "",
	},
	{
		.key = "ril.twwan911Timer",
		.value = "40",
	},
	{
		.key = "ril.voicecapable",
		.value = "true",
	},
	{
		.key = "rild.libpath",
		.value = "/system/lib64/libsec-ril.so",
	},
	{
		.key = "rild.libpath2",
		.value = "/system/lib64/libsec-ril-dsds.so",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.alarm_boot",
		.value = "false",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.am.reschedule_service",
		.value = "true",
	},
	{
		.key = "ro.astcenc.astcsupport",
		.value = "1",
	},
	{
		.key = "ro.baseband",
		.value = "msm",
	},
	{
		.key = "ro.bluetooth.dun",
		.value = "true",
	},
	{
		.key = "ro.bluetooth.hfp.ver",
		.value = "1.7",
	},
	{
		.key = "ro.bluetooth.sap",
		.value = "true",
	},
	{
		.key = "ro.board.platform",
		.value = "msm8952",
	},
	{
		.key = "ro.boot.baseband",
		.value = "msm",
	},
	{
		.key = "ro.boot.boot_recovery",
		.value = "0",
	},
	{
		.key = "ro.boot.bootdevice",
		.value = "7824900.sdhci",
	},
	{
		.key = "ro.boot.bootloader",
		.value = "C9000ZHU1AQC1",
	},
	{
		.key = "ro.boot.cp_debug_level",
		.value = "0x55FF",
	},
	{
		.key = "ro.boot.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.boot.em.did",
		.value = "2990c4ffb93f",
	},
	{
		.key = "ro.boot.em.model",
		.value = "SM-C9000",
	},
	{
		.key = "ro.boot.em.status",
		.value = "0x0",
	},
	{
		.key = "ro.boot.emmc",
		.value = "true",
	},
	{
		.key = "ro.boot.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.boot.revision",
		.value = "9",
	},
	{
		.key = "ro.boot.sec_atd.tty",
		.value = "/dev/ttyHSL0",
	},
	{
		.key = "ro.boot.security_mode",
		.value = "1526595584",
	},
	{
		.key = "ro.boot.serialno",
		.value = "7fc746a9",
	},
	{
		.key = "ro.boot.sku_theme",
		.value = "SM-C9000ZKACHC",
	},
	{
		.key = "ro.boot.skutheme_offset",
		.value = "9437224",
	},
	{
		.key = "ro.boot.ucs_mode",
		.value = "0",
	},
	{
		.key = "ro.boot.warranty_bit",
		.value = "1",
	},
	{
		.key = "ro.boot_recovery",
		.value = "0",
	},
	{
		.key = "ro.bootimage.build.date",
		.value = "Fri Mar 10 16:46:11 KST 2017",
	},
	{
		.key = "ro.bootimage.build.date.utc",
		.value = "1489131971",
	},
	{
		.key = "ro.bootimage.build.fingerprint",
		.value = "samsung/c9ltezh/c9ltechn:6.0.1/MMB29M/C9000ZHU1AQC1:user/test-keys",
	},
	{
		.key = "ro.bootloader",
		.value = "C9000ZHU1AQC1",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.bt.bdaddr_path",
		.value = "/efs/bluetooth/bt_addr",
	},
	{
		.key = "ro.build.PDA",
		.value = "C9000ZHU1APC1",
	},
	{
		.key = "ro.build.changelist",
		.value = "10182499",
	},
	{
		.key = "ro.build.characteristics",
		.value = "phone",
	},
	{
		.key = "ro.build.date",
		.value = "Fri Mar 10 16:45:59 KST 2017",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1489131959",
	},
	{
		.key = "ro.build.description",
		.value = "c9ltezh-user 6.0.1 MMB29M C9000ZHU1APC1 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "MMB29M.C9000ZHU1APC1",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "samsung/c9ltezh/c9ltechn:6.0.1/MMB29M/C9000ZHU1APC1:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "c9ltezh-user",
	},
	{
		.key = "ro.build.hidden_ver",
		.value = "C9000ZHU1APC1",
	},
	{
		.key = "ro.build.host",
		.value = "SWDG5215",
	},
	{
		.key = "ro.build.id",
		.value = "MMB29M",
	},
	{
		.key = "ro.build.official.release",
		.value = "true",
	},
	{
		.key = "ro.build.product",
		.value = "c9ltechn",
	},
	{
		.key = "ro.build.scafe.cream",
		.value = "white",
	},
	{
		.key = "ro.build.scafe.shot",
		.value = "double",
	},
	{
		.key = "ro.build.scafe.size",
		.value = "short",
	},
	{
		.key = "ro.build.scafe.version",
		.value = "2016B",
	},
	{
		.key = "ro.build.selinux",
		.value = "1",
	},
	{
		.key = "ro.build.selinux.enforce",
		.value = "1",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "dpi",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "C9000ZHU1APC1",
	},
	{
		.key = "ro.build.version.preview_sdk",
		.value = "0",
	},
	{
		.key = "ro.build.version.release",
		.value = "6.0.1",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "23",
	},
	{
		.key = "ro.build.version.sdl",
		.value = "2302",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2017-03-01",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.chipname",
		.value = "MSM8976",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.clientidbase.gmm",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "6.0_r10",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Morning_Flower.ogg",
	},
	{
		.key = "ro.config.dha_cached_max",
		.value = "20",
	},
	{
		.key = "ro.config.dha_cached_min",
		.value = "5",
	},
	{
		.key = "ro.config.dha_empty_init",
		.value = "40",
	},
	{
		.key = "ro.config.dha_empty_max",
		.value = "40",
	},
	{
		.key = "ro.config.dha_lmk_scale",
		.value = "0.414",
	},
	{
		.key = "ro.config.dha_pwhitelist_enable",
		.value = "1",
	},
	{
		.key = "ro.config.dmverity",
		.value = "True",
	},
	{
		.key = "ro.config.iccc_version",
		.value = "1.0",
	},
	{
		.key = "ro.config.kap",
		.value = "true",
	},
	{
		.key = "ro.config.knox",
		.value = "v30",
	},
	{
		.key = "ro.config.max_starting_bg",
		.value = "8",
	},
	{
		.key = "ro.config.media_sound",
		.value = "Media_preview_Touch_the_light.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Grace_Note.ogg",
	},
	{
		.key = "ro.config.notification_sound_2",
		.value = "S_Charming_Bell.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Over_the_Horizon.ogg",
	},
	{
		.key = "ro.config.ringtone_2",
		.value = "Basic_Bell.ogg",
	},
	{
		.key = "ro.config.rm_preload_enabled",
		.value = "0",
	},
	{
		.key = "ro.config.tima",
		.value = "1",
	},
	{
		.key = "ro.config.timaversion",
		.value = "3.0",
	},
	{
		.key = "ro.core_ctl_max_cpu",
		.value = "4",
	},
	{
		.key = "ro.core_ctl_min_cpu",
		.value = "2",
	},
	{
		.key = "ro.cp_debug_level",
		.value = "0x55FF",
	},
	{
		.key = "ro.crypto.default.encrypted",
		.value = "true",
	},
	{
		.key = "ro.crypto.fs_crypto_blkdev",
		.value = "/dev/block/dm-0",
	},
	{
		.key = "ro.crypto.state",
		.value = "encrypted",
	},
	{
		.key = "ro.crypto.type",
		.value = "block",
	},
	{
		.key = "ro.csc.country_code",
		.value = "Hong Kong",
	},
	{
		.key = "ro.csc.countryiso_code",
		.value = "HK",
	},
	{
		.key = "ro.csc.sales_code",
		.value = "TGY",
	},
	{
		.key = "ro.cutoff_voltage_mv",
		.value = "3200",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.em.did",
		.value = "2990c4ffb93f",
	},
	{
		.key = "ro.em.model",
		.value = "SM-C9000",
	},
	{
		.key = "ro.em.status",
		.value = "0x0",
	},
	{
		.key = "ro.error.receiver.default",
		.value = "com.samsung.receiver.error",
	},
	{
		.key = "ro.expect.recovery_id",
		.value = "0x454562f52b6f636ba11d93f9c9d35111660f9482000000000000000000000000",
	},
	{
		.key = "ro.fm.transmitter",
		.value = "false",
	},
	{
		.key = "ro.frp.pst",
		.value = "/dev/block/persistent",
	},
	{
		.key = "ro.gps.agps_provider",
		.value = "1",
	},
	{
		.key = "ro.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.hdcp2.rx",
		.value = "tz",
	},
	{
		.key = "ro.hwui.drop_shadow_cache_size",
		.value = "6",
	},
	{
		.key = "ro.hwui.gradient_cache_size",
		.value = "2",
	},
	{
		.key = "ro.hwui.layer_cache_size",
		.value = "34",
	},
	{
		.key = "ro.hwui.path_cache_size",
		.value = "10",
	},
	{
		.key = "ro.hwui.r_buffer_cache_size",
		.value = "4",
	},
	{
		.key = "ro.hwui.shape_cache_size",
		.value = "4",
	},
	{
		.key = "ro.hwui.text_large_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_large_cache_width",
		.value = "2048",
	},
	{
		.key = "ro.hwui.text_small_cache_height",
		.value = "1024",
	},
	{
		.key = "ro.hwui.text_small_cache_width",
		.value = "1024",
	},
	{
		.key = "ro.hwui.texture_cache_flushrate",
		.value = "0.4",
	},
	{
		.key = "ro.hwui.texture_cache_size",
		.value = "50",
	},
	{
		.key = "ro.kernel.qemu",
		.value = "0",
	},
	{
		.key = "ro.mct.compressiontype",
		.value = "ETC1",
	},
	{
		.key = "ro.mdtp.package_name2",
		.value = "com.qualcomm.qti.securemsm.mdtp.MdtpDemo",
	},
	{
		.key = "ro.mst.support",
		.value = "0",
	},
	{
		.key = "ro.multisim.simslotcount",
		.value = "2",
	},
	{
		.key = "ro.opengles.version",
		.value = "196609",
	},
	{
		.key = "ro.product.board",
		.value = "MSM8976",
	},
	{
		.key = "ro.product.brand",
		.value = "samsung",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "arm64-v8a,armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.device",
		.value = "c9ltechn",
	},
	{
		.key = "ro.product.locale",
		.value = "en-GB",
	},
	{
		.key = "ro.product.locale.language",
		.value = "en",
	},
	{
		.key = "ro.product.locale.region",
		.value = "US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "samsung",
	},
	{
		.key = "ro.product.model",
		.value = "SM-C9000",
	},
	{
		.key = "ro.product.name",
		.value = "c9ltezh",
	},
	{
		.key = "ro.product_ship",
		.value = "true",
	},
	{
		.key = "ro.qc.sdk.audio.fluencetype",
		.value = "none",
	},
	{
		.key = "ro.qc.sdk.audio.ssr",
		.value = "false",
	},
	{
		.key = "ro.qualcomm.bluetooth.ftp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hfp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hsp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.map",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.nap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.opp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.pbap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bt.hci_transport",
		.value = "smd",
	},
	{
		.key = "ro.qualcomm.cabl",
		.value = "2",
	},
	{
		.key = "ro.revision",
		.value = "9",
	},
	{
		.key = "ro.ril.svdo",
		.value = "false",
	},
	{
		.key = "ro.ril.svlte1x",
		.value = "false",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "1524183528031",
	},
	{
		.key = "ro.sec.fle.encryption",
		.value = "true",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.security.ese.cosname",
		.value = "UT2.0_01000002",
	},
	{
		.key = "ro.security.esest",
		.value = "per0201exi",
	},
	{
		.key = "ro.security.icd.flagmode",
		.value = "multi",
	},
	{
		.key = "ro.security.reactive.version",
		.value = "2.0.11",
	},
	{
		.key = "ro.security.vpnpp.release",
		.value = "7.0",
	},
	{
		.key = "ro.security.vpnpp.ver",
		.value = "1.4",
	},
	{
		.key = "ro.security_mode",
		.value = "1526595584",
	},
	{
		.key = "ro.serialno",
		.value = "7fc746a9",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "420",
	},
	{
		.key = "ro.sku.param.offset",
		.value = "9437224",
	},
	{
		.key = "ro.sku_theme",
		.value = "SM-C9000ZKACHC",
	},
	{
		.key = "ro.sys.fw.bservice_age",
		.value = "5000",
	},
	{
		.key = "ro.sys.fw.bservice_enable",
		.value = "true",
	},
	{
		.key = "ro.sys.fw.bservice_limit",
		.value = "5",
	},
	{
		.key = "ro.sys.fw.dex2oat_thread_count",
		.value = "4",
	},
	{
		.key = "ro.sys.fw.empty_app_percent",
		.value = "50",
	},
	{
		.key = "ro.sys.fw.trim_cache_percent",
		.value = "100",
	},
	{
		.key = "ro.sys.fw.trim_empty_percent",
		.value = "100",
	},
	{
		.key = "ro.sys.fw.trim_enable_memory",
		.value = "2147483648",
	},
	{
		.key = "ro.sys.fw.use_trim_settings",
		.value = "true",
	},
	{
		.key = "ro.telephony.call_ring.multiple",
		.value = "false",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "9,1",
	},
	{
		.key = "ro.use_data_netmgrd",
		.value = "true",
	},
	{
		.key = "ro.vendor.extension_library",
		.value = "libqti-perfd-client.so",
	},
	{
		.key = "ro.vendor.gt_library",
		.value = "libqti-gt.so",
	},
	{
		.key = "ro.vold.forceencryption",
		.value = "1",
	},
	{
		.key = "ro.warranty_bit",
		.value = "1",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote",
		.value = "zygote64_32",
	},
	{
		.key = "rtsp.video.keep-damaged-au",
		.value = "video/3gp",
	},
	{
		.key = "rw.km_fips_status",
		.value = "ready",
	},
	{
		.key = "sec.fle.encryption.status",
		.value = "Dec NewFile IncludeMedia",
	},
	{
		.key = "secmm.player.gp.url",
		.value = "true",
	},
	{
		.key = "secmm.player.uhqamode",
		.value = "True",
	},
	{
		.key = "security.ASKS.policy_version",
		.value = "161011",
	},
	{
		.key = "security.mdpp.mass",
		.value = "skmm",
	},
	{
		.key = "security.perf_harden",
		.value = "1",
	},
	{
		.key = "security.semdaemonfinish",
		.value = "1",
	},
	{
		.key = "selinux.policy_version",
		.value = "SEPF_SECMOBILE_6.0.1_0033",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "0",
	},
	{
		.key = "service.camera.hdmi_preview",
		.value = "0",
	},
	{
		.key = "service.camera.rec.running",
		.value = "0",
	},
	{
		.key = "service.camera.running",
		.value = "0",
	},
	{
		.key = "service.camera.running_0",
		.value = "0",
	},
	{
		.key = "service.camera.running_1",
		.value = "0",
	},
	{
		.key = "service.camera.samsung.enabled",
		.value = "0",
	},
	{
		.key = "service.media.powersnd",
		.value = "1",
	},
	{
		.key = "storage.efs_sync.done",
		.value = "0",
	},
	{
		.key = "storage.mmc.size",
		.value = "62537072640",
	},
	{
		.key = "storage.support.sdcard",
		.value = "1",
	},
	{
		.key = "storage.support.usb",
		.value = "1",
	},
	{
		.key = "sys.adaptivedisplay.eadon",
		.value = "true",
	},
	{
		.key = "sys.bartender.batterystats.ver",
		.value = "11",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.cameramode.blackbox",
		.value = "0",
	},
	{
		.key = "sys.cameramode.vtcall",
		.value = "0",
	},
	{
		.key = "sys.config.bigdata_enable",
		.value = "true",
	},
	{
		.key = "sys.config.bigdata_mem_enable",
		.value = "true",
	},
	{
		.key = "sys.config.mars_version",
		.value = "1.00",
	},
	{
		.key = "sys.dockstate",
		.value = "0",
	},
	{
		.key = "sys.enterprise.billing.version",
		.value = "1.2.0",
	},
	{
		.key = "sys.enterprise.otp.version",
		.value = "2.6.0",
	},
	{
		.key = "sys.ims.service_started",
		.value = "true",
	},
	{
		.key = "sys.isdumpstaterunning",
		.value = "0",
	},
	{
		.key = "sys.keyguard.connected",
		.value = "true",
	},
	{
		.key = "sys.keymaster.loaded",
		.value = "true",
	},
	{
		.key = "sys.knox.store",
		.value = "0",
	},
	{
		.key = "sys.listeners.registered",
		.value = "true",
	},
	{
		.key = "sys.mdniecontrolservice.mscon",
		.value = "true",
	},
	{
		.key = "sys.mobicore.loaded",
		.value = "true",
	},
	{
		.key = "sys.mobicoredaemon.enable",
		.value = "true",
	},
	{
		.key = "sys.nfc.support",
		.value = "1",
	},
	{
		.key = "sys.oem_unlock_allowed",
		.value = "0",
	},
	{
		.key = "sys.qseecomd.enable",
		.value = "true",
	},
	{
		.key = "sys.reset_reason",
		.value = "N|NP",
	},
	{
		.key = "sys.settings_global_version",
		.value = "5",
	},
	{
		.key = "sys.settings_secure_version",
		.value = "1",
	},
	{
		.key = "sys.settings_system_version",
		.value = "8",
	},
	{
		.key = "sys.siop.level",
		.value = "-3",
	},
	{
		.key = "sys.skip_lockscreen",
		.value = "0",
	},
	{
		.key = "sys.ssrm.mdnie",
		.value = "-1",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "24300",
	},
	{
		.key = "sys.sysctl.tcp_adv_win_scale",
		.value = "1",
	},
	{
		.key = "sys.sysctl.tcp_def_init_rwnd",
		.value = "60",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.configfs",
		.value = "0",
	},
	{
		.key = "sys.usb.ffs.ready",
		.value = "1",
	},
	{
		.key = "sys.usb.rps_mask",
		.value = "2",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "system.camera.CC.disable",
		.value = "0",
	},
	{
		.key = "telephony.lteOnCdmaDevice",
		.value = "1",
	},
	{
		.key = "tunman.protocol",
		.value = "1",
	},
	{
		.key = "tunnel.audio.encode",
		.value = "false",
	},
	{
		.key = "use.voice.path.for.pcm.voip",
		.value = "true",
	},
	{
		.key = "vidc.enc.dcvs.extra-buff-count",
		.value = "2",
	},
	{
		.key = "vidc.enc.narrow.searchrange",
		.value = "1",
	},
	{
		.key = "voice.conc.fallbackpath",
		.value = "deep-buffer",
	},
	{
		.key = "voice.playback.conc.disabled",
		.value = "true",
	},
	{
		.key = "voice.record.conc.disabled",
		.value = "false",
	},
	{
		.key = "voice.voip.conc.disabled",
		.value = "true",
	},
	{
		.key = "vold.crypt.type",
		.value = "default",
	},
	{
		.key = "vold.decrypt",
		.value = "trigger_restart_framework",
	},
	{
		.key = "vold.encrypt_progress",
		.value = "",
	},
	{
		.key = "vold.has_adoptable",
		.value = "0",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "vzw.os.rooted",
		.value = "false",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.ath",
		.value = "0",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{
		.key = "wlan.p2p.chkintent",
		.value = "8",
	},
	{
		.key = "wlan.wfd.status",
		.value = "disconnected",
	},
	{ NULL },
};
#endif /* __ANDROID__ */
