/*
 * Copyright (C) 2003  Robert Collins  <robertc@squid-cache.org>
 *               2004  Rob Weir <rweir@ertius.org>
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * DO NOT ALTER THE NEXT LINE
 * arch-tag: 0bcbff6a-adf1-499e-b7b3-a4f1c7eabdad
 * 
 */

#ifndef   _CM_CONFIGSVNSOURCE_H_
#define   _CM_CONFIGSVNSOURCE_H_

#include <stdexcept>
#include <getopt++/StringOption.h>
#include "ConfigSource.h"

class ConfigSVNSource : public ConfigSource
{

public:
  static ConfigSVNSource* Create(Path const &location,ConfigSource const *mayBeParent) throw (std::exception *);
  ConfigSVNSource();
  ConfigSVNSource(std::string const &url);
  virtual std::string url(bool const &) const;

  virtual void get (std::string const &) const throw (std::exception *);
  virtual void update (std::string const &) const throw(std::exception *);
  virtual int changes (std::string const &) const throw(std::exception *);
  virtual int missing (std::string const &) const throw(std::exception *);
  virtual void ignore (ConfigSource const *, std::string const &) const throw (std::exception *);

  virtual std::string treeVersion(std::string const &where) const;

private:
    static std::string schemeFromRepository(std::string &result);
    void processRepository();
    std::string getOneLineFile(std::string const &where) const;
    std::string getRoot(std::string const &where) const;
    std::string getRepository(std::string const &where) const;
    static std::string urlScheme(std::string const &);

    std::string theUrl;

    std::string real_url;

    std::string fake_url;

    std::string module;

  std::string tag;

  std::string urlPart;
};


#endif /* _CM_CONFIGSVNSOURCE_H_ */
