/*
    Jonathan "lonesock" Dummer
    Signed Distance Font Tool

    C header
    font: "Bitstream Vera Sans Mono"
*/

#ifndef HEADER_SIGNED_DISTANCE_FONT_XXX
#define HEADER_SIGNED_DISTANCE_FONT_XXX

/* array size information */
const int sdf_tex_width = 128;
const int sdf_tex_height = 128;
const int sdf_num_chars = 95;
/* 'unsigned char sdf_data[]' is defined last */

/*
    The following array holds the spacing info for rendering.
    Note that the final 3 values need sub-pixel accuracy, so
    they are multiplied by a scaling factor.  Make sure to
    divide by scale_factor before using the 'offset' and
    'advance' values.

    Here is the data order in the following array:
    [0] Unicode character ID
    [1] X position in this texture
    [2] Y position in this texture
    [3] Width of this glyph in the texture
    [4] Height of this glyph in the texture
    [5] X Offset * scale_factor  | Draw the glyph at X,Y offset
    [6] Y Offset * scale_factor  | relative to the cursor, then
    [7] X Advance * scale_factor | advance the cursor by this.
*/
const float scale_factor = 1000.000000;
const int sdf_spacing[] = {
  32,109,124,4,4,-1500,1500,9625,
  33,122,76,6,15,2250,13187,9625,
  34,0,90,10,8,312,13250,9625,
  35,48,46,13,15,-1437,13062,9625,
  36,37,16,11,18,-250,13687,9625,
  37,61,46,13,15,-1250,12750,9625,
  38,25,0,13,16,-1187,13375,9625,
  39,0,118,6,8,2312,13250,9625,
  40,13,18,8,18,1500,13687,9625,
  41,13,36,8,18,875,13687,9625,
  42,0,42,11,11,-562,13375,9625,
  43,73,0,12,12,-1000,10875,9625,
  44,0,103,7,9,1312,4375,9625,
  45,0,112,8,6,875,7312,9625,
  46,6,118,6,6,2000,4375,9625,
  47,98,92,11,17,-625,13250,9625,
  48,25,97,11,16,-562,13375,9625,
  49,85,46,11,15,-62,13250,9625,
  50,96,46,11,15,-625,13437,9625,
  51,49,0,11,16,-500,13375,9625,
  52,87,61,12,15,-687,13187,9625,
  53,61,31,11,15,-375,13187,9625,
  54,38,0,11,16,-500,13437,9625,
  55,94,31,11,15,-437,13250,9625,
  56,25,81,11,16,-500,13437,9625,
  57,25,49,11,16,-625,13312,9625,
  58,121,0,6,12,2000,9875,9625,
  59,120,92,7,14,1375,9875,9625,
  60,85,0,12,12,-812,10750,9625,
  61,0,53,12,9,-812,9250,9625,
  62,97,0,12,12,-812,10750,9625,
  63,118,16,10,15,312,13437,9625,
  64,0,0,13,17,-1437,12437,9625,
  65,48,16,13,15,-1250,13187,9625,
  66,110,76,12,15,-500,13250,9625,
  67,48,93,11,16,-312,13375,9625,
  68,83,16,11,15,-437,13187,9625,
  69,72,16,11,15,-187,13250,9625,
  70,61,16,11,15,-62,13250,9625,
  71,48,77,11,16,-562,13375,9625,
  72,116,31,11,15,-437,13187,9625,
  73,118,46,10,15,-187,13250,9625,
  74,105,31,11,15,-687,13187,9625,
  75,86,107,12,15,-562,13187,9625,
  76,83,31,11,15,250,13250,9625,
  77,74,92,12,15,-812,13187,9625,
  78,72,31,11,15,-562,13187,9625,
  79,86,76,12,16,-812,13375,9625,
  80,107,46,11,15,-250,13187,9625,
  81,13,0,12,18,-812,13375,9625,
  82,99,61,12,15,-437,13187,9625,
  83,48,109,11,16,-500,13437,9625,
  84,111,61,12,15,-812,13187,9625,
  85,74,107,12,15,-687,13187,9625,
  86,86,92,12,15,-1062,13250,9625,
  87,74,61,13,15,-1500,13187,9625,
  88,61,61,13,15,-1312,13187,9625,
  89,48,31,13,15,-1437,13250,9625,
  90,109,109,12,15,-625,13250,9625,
  91,13,54,8,18,1812,13687,9625,
  92,109,92,11,17,-687,13250,9625,
  93,121,109,7,18,875,13687,9625,
  94,0,82,12,8,-1062,13250,9625,
  95,0,98,13,5,-1500,-812,9625,
  96,74,122,8,6,0,14312,9625,
  97,13,111,11,13,-750,10500,9625,
  98,37,34,11,16,-312,13687,9625,
  99,37,114,11,13,-187,10500,9625,
  100,48,61,11,16,-812,13687,9625,
  101,106,16,12,13,-812,10500,9625,
  102,37,50,11,16,-125,13687,9625,
  103,37,66,11,16,-750,10500,9625,
  104,37,82,11,16,-187,13687,9625,
  105,25,16,12,17,-375,14562,9625,
  106,61,94,9,20,-437,14562,9625,
  107,98,76,12,16,-125,13687,9625,
  108,25,65,11,16,-812,13687,9625,
  109,61,114,12,13,-875,10500,9625,
  110,13,98,11,13,-187,10500,9625,
  111,94,16,12,13,-750,10500,9625,
  112,25,33,11,16,-312,10500,9625,
  113,37,98,11,16,-812,10500,9625,
  114,0,29,10,13,750,10500,9625,
  115,13,72,11,13,-187,10500,9625,
  116,74,46,11,15,-625,12812,9625,
  117,13,85,11,13,-250,10250,9625,
  118,25,113,12,12,-875,10312,9625,
  119,60,0,13,12,-1500,10312,9625,
  120,109,0,12,12,-1125,10312,9625,
  121,74,76,12,16,-1062,10312,9625,
  122,0,17,11,12,-250,10312,9625,
  123,61,76,10,18,-187,13687,9625,
  124,0,62,5,20,2437,13750,9625,
  125,98,109,10,18,-125,13687,9625,
  126,86,122,12,6,-812,7875,9625,
  0
};

/* Signed Distance Field: edges are at 127.5 */
const unsigned char sdf_data[] = {
  0,0,0,0,0,19,31,32,26,8,0,0,0,0,0,0,0,21,32,32,22,2,0,0,0,0,0,0,0,13,
  28,32,31,21,4,0,0,0,0,0,0,0,13,27,32,28,18,0,0,0,0,9,22,31,32,28,17,0,
  0,0,0,27,32,32,24,0,0,0,3,31,32,32,15,0,0,0,0,17,32,32,30,0,0,0,0,0,0,
  0,0,0,0,0,0,0,22,26,0,0,23,25,3,0,0,0,0,0,0,0,0,0,19,32,32,32,25,0,29,
  32,32,32,13,0,27,32,32,32,15,0,0,0,0,24,56,81,93,96,87,67,33,0,0,0,0,
  18,54,82,95,96,83,59,23,0,0,0,0,0,40,72,91,96,93,83,60,8,0,0,0,0,9,45,
  73,90,96,92,79,58,13,0,43,70,84,92,96,92,78,52,15,0,27,82,96,96,76,19,
  0,0,44,92,96,96,60,0,0,0,4,63,96,96,90,38,0,0,0,0,0,0,0,0,0,10,34,58,
  81,86,36,25,80,85,62,38,15,0,0,0,0,0,0,8,67,96,96,96,80,37,88,96,96,96,
  56,27,82,96,96,96,60,0,0,0,29,74,111,142,159,163,151,122,80,31,0,0,11,
  63,108,143,159,160,145,111,68,18,0,0,0,35,85,131,154,163,159,147,84,20,
  0,0,0,5,54,97,133,154,163,158,142,96,32,8,72,135,149,159,163,157,139,
  105,60,9,29,91,155,158,92,30,12,12,57,120,163,131,65,0,0,0,8,72,139,163,
  108,44,0,0,0,0,0,0,0,23,47,69,93,116,142,108,44,32,96,145,120,97,74,51,
  28,4,0,0,0,8,67,119,163,163,113,67,122,163,163,110,56,32,96,163,163,135,
  68,0,0,15,68,119,164,154,131,124,144,173,119,63,4,0,44,99,153,198,168,
  165,193,160,106,51,0,0,0,61,120,178,167,143,147,151,84,20,0,0,0,38,93,
  147,188,164,151,156,163,96,32,8,72,139,169,159,155,168,195,153,95,38,
  17,80,144,167,102,70,76,76,67,131,180,116,53,0,4,8,8,72,139,175,108,44,
  8,8,0,0,12,36,58,82,106,131,154,177,170,108,44,32,96,163,182,158,135,
  110,86,63,40,17,0,0,30,82,136,187,145,97,156,179,124,73,21,32,96,163,
  199,135,68,0,0,45,102,159,147,99,68,76,90,145,147,83,22,7,67,131,188,
  156,108,102,150,194,135,74,13,0,4,68,135,199,135,79,82,104,81,19,0,0,
  3,63,122,182,153,105,85,92,115,96,32,8,72,124,106,92,88,111,165,179,115,
  52,6,68,135,176,112,108,143,143,80,142,168,104,42,17,63,72,72,72,139,
  175,108,72,72,72,43,21,70,95,119,143,167,176,154,133,110,86,36,25,80,
  106,131,151,172,170,147,122,99,76,31,0,0,45,97,151,176,131,186,142,88,
  37,0,32,96,151,151,135,68,0,8,68,131,169,110,85,122,143,135,131,159,92,
  28,20,83,147,196,135,70,63,124,188,154,91,28,0,0,62,122,185,151,93,39,
  45,37,0,0,0,19,81,144,183,120,79,84,77,58,56,13,0,43,64,47,56,57,91,155,
  179,115,52,0,58,120,184,120,120,185,158,93,151,158,93,31,32,96,139,139,
  139,144,177,139,139,139,131,64,32,96,156,179,160,139,115,93,70,49,28,
  0,0,24,45,67,88,110,135,156,177,160,108,44,0,0,9,60,113,167,191,159,104,
  52,0,0,22,73,84,84,84,53,0,22,84,148,147,85,131,178,147,147,160,159,92,
  28,28,92,158,187,120,58,50,112,179,164,100,36,0,6,51,97,154,182,124,73,
  20,28,28,25,0,28,92,156,171,111,143,151,140,111,68,18,0,0,28,91,120,120,
  139,179,150,93,36,0,46,108,173,135,135,142,168,107,160,147,82,19,32,96,
  163,175,175,177,195,175,175,175,131,64,32,96,163,169,136,113,92,70,49,
  28,7,0,0,2,24,45,67,88,110,133,159,175,108,44,0,0,0,47,99,153,202,144,
  91,39,0,0,13,56,64,64,64,40,0,30,92,159,135,93,157,144,88,85,140,159,
  92,28,32,96,163,183,116,52,44,108,175,171,104,40,0,43,94,144,182,177,
  163,108,65,92,92,84,33,32,96,163,177,159,165,167,194,160,104,47,0,0,28,
  92,159,187,168,124,97,57,7,0,35,97,163,143,149,124,154,120,171,135,71,
  8,30,90,108,108,108,139,175,108,108,108,108,61,28,85,116,140,164,176,
  154,133,108,87,65,25,15,60,83,104,124,149,170,169,145,120,94,39,0,0,31,
  83,136,188,152,181,131,76,22,0,32,96,131,131,131,68,0,32,96,163,131,100,
  167,131,64,60,124,159,92,28,32,96,163,183,116,52,44,108,175,171,104,40,
  14,73,133,186,136,136,190,144,88,139,159,104,40,32,96,163,206,149,102,
  104,151,192,131,67,0,0,28,92,139,139,152,178,144,95,40,0,24,87,151,152,
  163,112,139,135,180,122,60,0,0,38,44,44,72,139,175,108,44,44,44,22,0,
  33,57,79,103,131,152,176,170,149,108,44,32,96,145,167,179,156,133,108,
  85,62,38,4,0,16,68,119,174,156,110,167,165,111,59,7,32,96,163,195,135,
  68,0,32,95,159,135,96,162,139,78,74,135,159,92,28,28,92,159,187,120,57,
  49,112,179,167,100,36,29,92,156,168,104,99,154,179,122,142,165,100,37,
  29,92,159,191,124,63,66,131,192,143,76,0,4,13,61,72,72,94,147,185,124,
  62,0,13,75,139,193,160,97,124,184,175,111,48,0,0,0,0,8,72,139,175,108,
  44,0,0,0,0,0,0,21,44,67,91,115,139,163,108,44,32,96,163,144,119,95,72,
  49,25,2,0,0,0,52,105,159,179,122,78,135,190,150,95,43,32,96,163,183,135,
  68,0,24,87,151,143,81,140,170,131,131,167,159,92,28,21,83,147,194,133,
  69,62,124,187,155,91,29,32,96,163,168,104,65,116,172,160,158,149,87,26,
  24,87,151,191,124,60,63,124,191,143,76,17,63,63,40,28,25,68,135,199,135,
  68,0,2,64,124,147,147,83,110,147,147,100,37,0,0,0,0,8,72,135,135,108,
  44,0,0,0,0,0,0,0,0,8,32,56,78,102,104,43,31,93,106,83,59,36,13,0,0,0,
  0,0,27,88,144,147,147,92,45,101,147,147,133,77,31,93,116,116,116,67,0,
  11,72,135,163,102,99,142,163,154,131,151,92,28,8,68,131,189,154,102,99,
  147,197,139,76,15,27,90,153,188,136,91,83,139,194,173,119,63,6,11,73,
  135,196,139,85,86,142,192,131,68,32,96,122,102,92,88,105,153,190,131,
  64,0,0,45,80,80,80,57,74,80,80,70,21,0,0,0,0,0,46,68,68,65,25,0,0,0,0,
  0,0,0,0,0,0,0,19,43,49,15,6,45,47,24,0,0,0,0,0,0,0,0,17,68,80,80,80,57,
  15,65,80,80,80,60,6,45,52,52,52,31,0,0,51,108,165,140,91,83,96,91,84,
  84,71,19,0,45,101,156,195,163,162,190,164,110,53,0,10,68,122,175,181,
  152,147,167,183,177,122,69,15,0,53,110,167,178,145,147,178,164,108,49,
  32,96,163,167,157,155,165,195,161,106,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,76,124,173,144,115,101,104,
  122,120,63,6,0,14,65,111,147,163,164,179,116,72,26,0,0,34,82,122,153,
  167,163,147,122,155,155,102,45,0,24,74,119,154,168,168,153,119,73,21,
  32,96,139,155,163,167,160,144,111,68,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,82,122,154,176,167,168,172,
  145,88,24,0,0,20,59,86,99,113,164,164,116,67,6,0,0,34,67,91,100,98,85,
  83,88,88,85,38,0,0,29,67,91,104,104,92,65,29,0,13,56,77,91,98,100,96,
  82,58,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,32,67,95,112,120,120,108,86,56,8,0,0,0,3,25,36,71,119,144,
  102,61,3,0,0,0,10,29,36,36,24,22,24,24,23,0,0,0,0,10,30,40,40,31,10,0,
  0,0,0,15,28,36,36,32,21,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,34,49,56,56,47,28,1,0,0,0,0,0,0,
  0,30,79,91,52,14,0,0,0,0,0,30,32,32,28,0,0,0,0,0,0,0,0,27,32,28,0,0,0,
  0,0,0,0,0,24,32,32,32,25,0,0,0,0,0,27,32,32,32,32,32,32,32,31,3,0,27,
  32,32,32,32,32,32,32,31,3,0,27,32,32,32,30,21,5,0,0,0,0,0,0,1,21,32,32,
  22,1,0,0,0,0,0,0,0,21,32,32,25,8,0,0,0,0,0,4,22,32,32,24,6,0,0,0,22,32,
  32,32,32,32,32,32,29,0,0,0,0,0,0,0,0,0,0,28,33,2,0,0,0,0,0,38,90,96,96,
  85,30,0,0,0,0,0,0,27,82,96,85,30,0,0,0,0,0,0,19,76,96,96,96,80,23,0,0,
  0,27,82,96,96,96,96,96,96,96,92,42,27,82,96,96,96,96,96,96,96,92,42,27,
  82,96,96,96,92,83,65,37,0,0,0,0,22,58,83,95,96,83,58,23,0,0,0,0,21,56,
  82,95,96,87,65,33,0,0,0,37,63,83,95,96,86,63,29,0,15,73,96,96,96,96,96,
  96,96,88,34,0,0,0,0,0,15,32,32,29,0,0,0,0,0,0,0,0,44,108,163,163,100,
  36,0,0,0,0,0,4,32,96,163,100,36,18,0,0,0,0,0,36,97,160,163,163,101,40,
  0,0,0,32,96,163,163,163,163,163,163,163,112,48,32,96,163,163,163,163,
  163,163,163,112,48,32,96,163,163,163,159,147,122,88,46,0,0,20,68,111,
  144,159,160,145,113,71,22,0,0,20,68,111,144,159,163,151,122,82,34,0,29,
  88,122,147,159,160,149,119,74,24,20,84,151,163,163,163,163,163,163,104,
  40,0,0,0,0,9,62,96,96,88,34,0,0,0,0,0,0,0,44,108,175,167,100,36,0,0,0,
  0,18,59,88,100,163,104,95,79,42,0,0,0,0,52,113,177,175,181,116,57,0,0,
  0,32,96,163,190,163,163,163,163,163,112,48,32,96,163,190,163,163,163,
  163,163,112,48,32,96,163,190,163,165,185,179,136,83,28,0,54,108,161,184,
  155,154,184,163,111,56,0,0,53,108,161,179,151,147,167,175,124,69,11,32,
  96,163,164,151,155,184,167,110,49,20,84,143,143,143,143,143,193,171,104,
  40,0,0,0,0,42,97,153,151,93,36,0,0,0,0,0,0,12,44,108,139,139,100,36,0,
  0,0,3,58,108,149,167,181,169,159,124,60,0,0,0,8,68,131,187,122,183,136,
  73,11,0,0,32,96,163,179,112,96,96,96,96,92,42,32,96,163,179,112,96,96,
  96,96,92,42,32,96,163,179,112,100,131,177,172,111,52,17,78,140,197,144,
  94,93,142,197,142,81,19,16,78,139,194,136,90,83,116,176,154,92,31,32,
  96,133,102,86,93,149,189,124,60,8,60,76,76,76,108,159,178,131,80,29,0,
  0,0,15,72,131,183,122,65,7,0,0,0,0,0,39,75,76,76,76,76,69,22,0,0,0,24,
  85,147,182,140,164,135,148,124,60,0,0,0,24,86,148,172,108,168,153,90,
  28,0,0,32,96,163,179,112,60,60,60,60,45,3,32,96,163,179,112,60,60,60,
  60,45,3,32,96,163,179,112,48,90,152,193,131,68,28,92,157,183,119,57,54,
  116,179,159,95,32,28,92,157,179,120,120,120,120,167,170,104,42,24,76,
  79,45,49,96,153,177,116,55,0,4,12,54,102,153,184,136,85,38,0,0,0,0,40,
  99,160,160,98,39,0,0,0,0,0,0,56,120,143,143,143,143,100,36,0,0,0,32,96,
  163,163,96,163,100,86,111,58,0,0,0,40,102,164,159,95,154,169,106,44,0,
  0,32,96,163,179,124,124,124,124,124,80,16,32,96,163,179,124,124,124,124,
  124,80,16,32,96,163,179,112,48,74,139,203,143,76,32,96,163,179,112,48,
  44,108,175,167,100,36,32,96,163,204,183,183,183,183,183,175,108,44,0,
  19,20,48,94,142,187,140,88,33,0,1,49,96,147,189,142,91,45,0,0,0,0,0,62,
  122,183,139,77,17,0,0,0,0,0,0,56,120,163,163,187,167,100,36,0,0,0,31,
  92,157,176,122,163,100,74,48,23,0,0,0,57,119,181,144,80,139,186,122,61,
  0,0,32,96,163,210,191,191,191,191,147,80,16,32,96,163,210,191,191,191,
  191,147,80,16,32,96,163,179,112,48,68,135,199,147,80,31,92,159,180,116,
  53,51,112,179,160,96,32,31,93,159,179,116,116,116,116,116,116,104,43,
  0,0,31,86,139,185,139,94,49,0,0,43,91,142,188,147,97,50,28,25,0,0,0,16,
  78,142,187,122,61,0,0,0,0,0,0,0,49,95,96,108,175,167,100,36,0,0,0,15,
  72,131,174,181,181,156,135,99,53,1,0,11,73,136,192,131,104,124,188,140,
  78,16,0,32,96,163,180,135,135,135,135,135,80,16,32,96,163,180,135,135,
  135,135,135,80,16,32,96,163,179,112,48,70,135,199,147,80,20,82,144,196,
  136,83,82,135,193,147,83,22,21,82,145,189,131,83,68,73,91,119,84,20,0,
  0,51,112,176,149,94,48,4,0,28,85,136,183,153,102,92,92,92,84,33,0,0,27,
  90,155,176,112,48,0,0,0,0,0,0,0,8,32,44,108,175,167,100,36,0,0,0,0,37,
  82,116,143,171,168,190,144,86,28,0,29,90,153,205,171,171,171,202,157,
  95,33,0,32,96,163,179,112,68,68,68,68,51,1,32,96,163,179,112,68,68,68,
  68,51,1,32,96,163,179,112,48,79,143,202,139,74,1,60,115,170,175,143,142,
  175,171,116,62,3,2,60,116,170,173,144,135,139,153,151,84,20,0,0,56,120,
  187,139,72,8,0,0,32,96,163,206,160,159,159,159,159,104,40,0,0,32,96,163,
  171,104,42,0,0,0,0,0,0,0,0,0,44,108,175,167,100,36,0,0,0,11,58,62,60,
  96,163,108,160,169,104,42,0,45,106,169,165,147,147,147,162,173,111,49,
  0,32,96,163,179,112,48,4,4,4,0,0,32,96,163,179,112,52,52,52,52,50,18,
  32,96,163,179,112,62,101,160,187,124,63,0,28,77,122,156,172,172,157,122,
  80,29,0,0,28,77,119,153,169,175,171,159,140,84,20,0,0,56,120,143,139,
  72,8,0,0,32,96,147,147,147,147,147,147,147,104,40,0,0,32,96,163,171,104,
  40,0,0,0,0,0,0,0,8,12,44,108,175,167,100,36,12,7,0,28,92,116,90,96,163,
  100,151,173,108,44,0,62,122,186,147,83,80,81,144,190,131,66,4,32,96,163,
  179,112,48,0,0,0,0,0,32,96,163,179,116,116,116,116,116,108,47,32,96,163,
  179,120,124,149,192,160,102,44,0,0,32,69,95,108,108,95,70,33,0,0,0,0,
  31,65,91,104,108,104,95,78,53,4,0,0,55,113,116,116,70,7,0,0,21,70,80,
  80,80,80,80,80,80,74,28,0,0,28,92,157,175,108,47,0,0,0,0,0,0,19,67,76,
  76,108,175,167,100,76,76,65,15,28,92,159,152,135,164,140,178,154,95,34,
  16,78,142,194,133,69,16,66,131,190,145,82,21,32,96,163,179,112,48,0,0,
  0,0,0,32,96,163,204,183,183,183,183,179,112,48,32,96,163,203,187,188,
  185,160,119,70,17,0,0,0,12,34,44,44,34,13,0,0,0,0,0,0,8,30,41,44,41,34,
  18,0,0,0,0,56,120,183,139,72,8,0,0,0,15,20,20,19,21,32,32,19,0,0,0,0,
  19,81,145,183,120,58,0,0,0,0,0,0,32,96,143,143,143,178,170,143,143,143,
  92,28,28,91,136,157,168,184,167,151,111,65,10,32,95,143,143,116,54,0,
  50,112,143,143,98,36,32,96,143,143,112,48,0,0,0,0,0,32,96,143,143,143,
  143,143,143,143,112,48,32,96,139,139,139,135,122,101,70,29,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,120,155,139,72,8,0,0,22,
  73,84,84,81,82,96,95,79,49,0,0,0,5,66,131,189,135,73,11,0,0,0,0,0,32,
  96,163,163,163,163,163,163,163,159,92,28,7,51,76,93,104,163,100,90,61,
  20,0,19,67,76,76,73,32,0,29,72,76,76,69,22,19,67,76,76,73,32,0,0,0,0,
  0,19,67,76,76,76,76,76,76,76,73,32,17,63,72,72,72,68,60,42,15,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,87,88,88,59,2,0,0,
  32,96,151,151,112,142,160,159,140,76,0,0,0,0,45,104,165,154,92,33,0,0,
  0,0,0,27,82,96,96,96,96,96,96,96,96,80,23,0,0,15,32,96,163,100,36,6,0,
  0,0,27,32,32,32,10,0,0,27,32,32,32,10,0,17,32,32,32,32,32,32,32,19,0,
  0,27,32,32,32,10,6,31,32,32,19,0,27,32,32,31,3,0,0,0,0,0,0,27,32,32,32,
  32,32,32,32,31,6,0,0,0,28,32,32,32,32,32,27,0,0,27,32,32,31,3,22,32,32,
  32,10,0,32,96,163,180,142,165,155,159,143,76,0,0,0,0,22,79,139,177,116,
  58,0,0,0,0,0,0,27,32,32,32,32,32,32,32,32,25,0,0,0,0,32,96,131,100,36,
  0,0,0,27,82,96,96,95,54,0,27,82,96,96,95,53,4,63,96,96,96,96,96,96,96,
  67,8,27,82,96,96,95,54,45,93,96,96,67,27,82,96,96,92,42,0,0,0,0,0,27,
  82,96,96,96,96,96,96,96,93,45,0,0,30,85,96,96,96,96,96,82,27,27,82,96,
  96,92,42,73,96,96,95,53,0,32,96,163,202,147,106,88,95,124,76,0,0,0,0,
  0,50,105,161,144,86,29,0,0,0,0,0,15,20,20,19,25,32,27,8,0,0,0,0,0,0,13,
  56,64,58,16,0,0,0,27,85,144,163,140,81,24,54,111,163,163,111,54,8,72,
  139,163,163,163,163,163,143,76,12,32,96,163,163,139,77,52,116,163,143,
  76,32,96,163,163,112,48,0,0,0,0,0,32,96,163,163,163,163,163,163,163,116,
  52,0,0,36,100,163,163,163,163,163,96,32,32,96,163,163,112,48,84,151,163,
  124,60,0,32,96,163,183,116,58,26,36,67,48,0,0,0,0,0,18,71,112,112,99,
  38,0,0,0,0,22,73,84,84,81,86,96,90,65,26,0,0,0,27,32,32,31,3,0,0,0,0,
  0,0,56,111,170,169,110,52,82,142,199,142,83,26,8,72,139,187,163,163,163,
  163,143,76,12,32,96,163,220,160,99,52,116,183,143,76,32,96,163,179,112,
  48,0,0,0,0,0,32,96,163,163,163,163,163,184,181,116,52,0,0,36,100,163,
  163,163,190,163,96,32,32,96,163,179,112,48,84,151,191,124,60,0,32,96,
  163,179,112,48,0,0,3,0,0,0,0,0,0,0,28,48,48,44,9,0,0,0,0,32,96,151,151,
  112,147,163,152,116,71,17,0,27,82,96,96,92,42,0,0,0,0,0,0,26,83,142,195,
  139,79,110,169,169,111,54,0,8,72,139,175,108,96,96,96,96,67,8,32,96,163,
  187,183,122,62,116,183,143,76,32,96,163,179,112,48,0,0,0,0,0,27,82,96,
  96,96,96,116,179,158,97,38,0,0,30,85,96,96,112,179,163,96,32,32,96,163,
  179,112,48,84,151,191,124,60,0,32,96,163,179,112,48,0,0,0,0,0,0,0,0,25,
  32,32,21,0,0,0,0,0,0,0,32,96,163,181,144,152,158,195,161,102,45,0,32,
  96,163,163,112,48,0,0,0,0,0,0,0,54,111,170,167,106,139,197,140,81,24,
  0,8,72,139,175,108,96,91,72,42,19,0,32,96,163,163,149,145,85,116,183,
  143,76,32,96,163,179,112,48,0,0,0,0,0,0,27,32,32,32,82,143,194,135,74,
  15,0,0,0,28,32,48,112,179,163,96,32,32,96,163,179,112,68,84,151,191,124,
  60,0,32,96,163,179,112,48,0,0,0,0,0,0,0,23,80,96,96,71,19,0,0,0,0,0,0,
  32,96,163,198,140,90,102,158,188,124,63,0,32,96,163,179,112,48,20,15,
  0,0,0,0,0,26,83,142,193,136,167,169,110,53,0,0,8,72,139,181,153,163,155,
  131,93,46,0,32,96,163,163,124,168,107,116,183,143,76,32,96,163,179,112,
  48,0,0,0,0,0,0,0,0,0,45,104,165,170,110,51,0,0,0,0,0,0,48,112,179,163,
  96,32,32,96,163,180,135,135,135,153,191,124,60,0,32,96,163,179,112,48,
  0,0,0,0,0,0,0,24,83,140,162,106,52,0,0,0,0,0,0,32,96,163,181,116,55,74,
  139,201,139,72,0,32,96,163,179,112,74,84,77,54,18,0,0,0,0,54,111,169,
  186,197,140,81,24,0,0,8,72,139,164,155,159,179,184,139,83,26,32,96,163,
  163,102,163,131,116,183,143,76,32,96,163,179,112,48,0,0,0,0,0,0,0,0,10,
  69,131,189,148,87,28,0,0,0,0,0,0,48,112,179,163,96,32,32,96,163,210,191,
  191,191,196,191,124,60,0,32,96,159,159,112,48,0,0,0,0,0,0,0,0,54,111,
  172,140,83,26,0,0,0,0,0,32,96,163,179,112,48,68,135,199,143,76,0,32,96,
  163,179,112,135,151,140,108,63,10,0,0,0,24,81,140,197,167,110,53,0,0,
  0,8,72,124,101,88,93,124,174,170,108,46,32,96,163,163,96,140,153,116,
  183,143,76,32,96,163,179,112,48,0,0,0,0,0,0,0,0,33,92,153,185,122,63,
  4,0,0,0,0,0,0,48,112,179,163,96,32,32,96,163,179,124,124,124,151,191,
  124,60,0,25,80,92,92,88,40,0,0,0,0,0,0,0,0,28,87,148,170,110,51,0,0,0,
  0,0,32,96,163,180,116,54,73,139,200,139,75,0,32,96,163,179,136,168,173,
  197,153,97,40,0,0,0,0,56,120,187,155,88,24,0,0,0,0,43,63,40,27,35,88,
  152,185,120,56,32,96,163,163,96,116,176,116,183,143,76,32,96,163,179,
  112,48,0,0,0,0,0,0,0,0,56,115,176,160,99,40,0,0,15,60,60,18,0,48,112,
  179,163,96,32,32,96,163,179,112,60,84,151,191,124,60,0,0,23,28,28,27,
  0,0,0,0,0,0,0,0,0,5,66,124,189,135,73,11,0,0,0,0,32,96,163,197,139,88,
  99,156,190,131,66,0,32,96,163,204,150,104,113,165,185,122,61,0,0,0,0,
  56,120,187,155,88,24,0,0,0,17,63,65,43,32,40,91,154,183,120,56,32,96,
  163,163,96,95,156,139,184,143,76,32,96,163,179,112,52,52,52,52,49,15,
  0,0,20,79,140,197,139,77,17,0,0,32,96,108,69,44,53,116,180,159,92,31,
  32,96,163,179,112,48,84,151,191,124,60,0,0,0,0,0,22,32,32,13,0,0,0,0,
  0,0,0,49,111,175,153,90,27,0,0,0,0,32,96,163,183,151,148,154,192,165,
  107,48,0,32,96,163,185,120,61,79,143,200,139,72,0,0,0,0,56,120,187,155,
  88,24,0,0,0,32,96,124,104,96,102,131,177,167,104,44,32,96,163,163,96,
  72,133,192,207,143,76,32,96,163,179,116,116,116,116,116,104,43,0,0,43,
  102,163,174,112,53,0,0,0,32,96,159,124,108,108,144,197,151,87,24,32,96,
  163,179,112,48,84,151,191,124,60,0,0,0,16,15,73,96,96,56,9,13,0,0,0,0,
  0,37,100,164,167,100,38,0,0,0,0,32,96,163,179,112,153,171,160,122,76,
  21,0,32,96,163,179,112,48,68,135,199,143,76,0,0,0,0,56,120,187,155,88,
  24,0,0,0,32,96,163,168,163,167,185,175,131,78,22,32,96,163,163,96,49,
  108,170,203,143,76,32,96,163,204,183,183,183,183,175,108,44,0,8,67,124,
  186,151,90,30,0,0,0,32,96,163,187,172,172,193,178,124,68,8,32,96,163,
  179,112,48,84,151,191,124,60,0,0,45,80,57,84,151,131,64,67,74,28,0,0,
  0,0,30,92,159,174,108,44,0,0,0,0,32,96,163,179,112,93,104,96,72,32,0,
  0,32,96,163,179,112,51,70,135,199,142,76,0,0,0,0,56,120,143,143,88,24,
  0,0,0,32,95,131,147,155,155,143,119,83,40,0,32,96,139,139,96,32,86,139,
  139,139,76,32,96,143,143,143,143,143,143,143,108,44,0,27,90,143,143,124,
  66,7,0,0,0,28,85,116,139,151,155,147,124,85,38,0,32,96,139,139,112,48,
  84,139,139,124,60,0,19,74,133,113,84,151,131,92,122,113,58,0,0,0,0,28,
  92,159,175,108,44,0,0,0,0,32,96,163,179,112,48,40,34,15,0,0,0,32,96,163,
  190,131,72,88,149,194,131,68,0,0,0,0,39,75,76,76,62,12,0,0,0,8,49,68,
  81,88,88,80,62,32,0,0,17,63,72,72,63,17,54,72,72,72,51,19,67,76,76,76,
  76,76,76,76,72,29,0,15,65,76,76,75,39,0,0,0,0,0,33,57,76,87,88,82,65,
  36,0,0,17,63,72,72,69,30,57,72,72,72,40,0,31,93,135,164,140,151,131,149,
  156,124,74,0,0,0,0,36,98,163,168,104,40,0,0,0,0,32,96,163,179,112,48,
  0,0,0,0,0,0,32,96,163,188,162,131,136,179,172,112,53,0,0,0,0,3,31,32,
  32,25,32,32,21,0,0,0,4,26,32,25,3,0,0,0,0,0,0,0,0,0,21,32,32,32,13,0,
  0,0,0,0,4,18,32,32,32,21,0,0,0,0,0,5,21,31,32,28,15,0,0,0,0,27,32,32,
  32,32,28,18,0,0,0,0,27,32,32,32,32,32,32,32,24,6,47,76,106,136,188,173,
  131,97,67,37,0,0,0,0,46,108,172,157,92,31,0,0,0,0,31,92,112,112,105,46,
  0,0,0,0,0,0,32,96,163,171,119,167,187,174,136,83,28,0,0,0,0,42,92,96,
  95,80,96,96,70,11,0,18,59,87,96,86,57,15,0,0,0,0,0,0,0,11,70,96,96,96,
  56,0,0,0,0,45,66,80,95,96,96,70,11,0,0,0,42,67,83,92,96,92,76,49,12,0,
  27,82,96,96,96,96,92,80,58,25,0,27,82,96,96,96,96,96,96,96,76,25,80,111,
  142,161,156,144,163,133,102,65,0,0,0,0,62,122,186,139,77,16,0,0,0,0,3,
  42,48,48,46,15,0,0,0,0,0,0,29,88,104,104,99,108,120,112,85,43,0,0,0,0,
  0,59,120,163,116,101,163,139,76,14,4,59,108,149,163,147,105,56,0,0,0,
  0,0,0,0,16,80,147,163,131,64,0,0,0,20,83,131,143,159,163,147,80,16,0,
  0,16,79,131,147,159,163,156,136,102,57,6,32,96,163,163,163,163,156,143,
  113,71,21,32,96,163,163,163,163,163,163,155,88,28,86,144,136,102,151,
  131,113,145,124,69,0,0,0,22,82,143,176,116,57,0,0,0,0,0,0,0,0,10,27,32,
  30,17,0,0,0,0,0,34,40,40,38,48,56,51,29,0,0,0,1,33,36,74,139,164,101,
  116,180,120,59,16,26,87,149,150,120,153,144,83,22,0,0,0,0,10,53,60,80,
  147,195,131,64,60,60,32,20,84,151,179,167,203,147,80,16,0,0,16,80,147,
  167,151,147,163,192,149,92,34,32,96,163,186,155,155,164,195,164,108,51,
  32,96,163,163,167,208,164,163,155,88,0,56,103,79,84,151,131,64,88,94,
  39,0,0,0,47,106,165,149,90,33,0,0,0,0,0,0,0,36,69,90,96,92,78,50,9,0,
  0,0,0,0,0,4,23,32,32,32,28,0,0,36,91,100,100,154,148,100,135,168,104,
  100,58,32,96,163,120,61,124,159,92,28,40,60,34,0,32,95,124,124,147,195,
  131,124,124,122,60,20,84,133,116,124,191,147,80,16,0,0,16,80,133,106,
  87,82,111,169,177,112,50,32,96,163,179,112,88,104,156,193,131,67,27,82,
  96,96,143,199,135,96,96,76,0,17,40,24,83,120,120,63,31,37,4,0,0,19,76,
  135,171,115,60,4,0,0,0,0,0,0,33,82,124,153,163,158,139,99,54,2,0,0,0,
  0,20,61,86,96,96,96,85,30,0,40,104,167,167,181,170,167,169,181,167,131,
  64,26,87,149,147,120,151,144,83,76,99,124,67,8,32,96,163,179,183,213,
  179,179,179,124,60,6,57,69,60,124,191,147,80,16,0,0,4,57,74,47,25,30,
  92,159,182,116,52,32,96,163,179,112,48,76,143,203,139,72,0,27,32,76,143,
  199,135,68,32,24,0,0,0,0,43,56,56,32,0,0,0,0,0,27,88,112,112,81,28,0,
  0,0,0,0,0,7,65,122,175,167,143,153,192,145,88,31,0,0,0,2,60,111,148,160,
  163,163,100,36,0,40,104,135,135,179,135,135,168,139,135,131,64,4,60,108,
  149,163,147,105,111,136,149,124,82,19,31,92,112,112,147,195,131,112,112,
  111,58,0,0,7,60,124,191,147,80,16,0,0,0,2,11,0,9,60,113,172,164,103,42,
  32,96,163,179,112,72,91,151,196,135,68,0,0,12,76,143,199,135,68,4,0,0,
  27,32,32,32,32,32,32,32,32,30,0,0,0,40,48,48,35,0,0,0,0,0,0,0,24,86,149,
  182,122,79,99,158,174,112,52,0,0,0,19,81,144,201,153,143,143,100,36,0,
  30,63,75,139,164,100,116,180,120,68,68,40,0,22,60,87,98,122,147,139,111,
  88,65,40,0,3,42,48,80,147,195,131,64,48,48,23,0,0,0,60,124,191,147,80,
  16,0,0,0,0,0,6,52,99,150,183,133,76,21,32,96,163,181,139,139,149,184,
  173,115,56,0,0,12,76,143,199,135,68,4,0,27,82,96,96,96,96,96,96,96,96,
  90,38,0,0,27,32,32,32,32,25,0,0,0,0,0,32,96,160,171,104,42,80,147,192,
  131,65,0,15,60,68,88,155,187,120,76,76,69,22,28,85,100,100,154,148,100,
  135,168,104,100,65,5,2,63,110,135,149,124,101,124,147,139,105,60,7,0,
  0,16,80,147,195,131,64,0,0,0,0,0,0,60,124,191,147,80,16,0,0,0,0,4,49,
  96,144,187,139,91,41,0,32,96,163,201,179,179,172,158,124,82,29,0,0,12,
  76,143,199,135,68,4,0,32,96,163,163,163,163,163,163,163,163,108,44,0,
  27,82,96,96,96,96,80,23,0,0,0,0,32,96,163,172,108,46,83,147,202,139,72,
  0,32,96,135,135,157,188,135,135,135,100,36,32,96,163,167,181,170,167,
  169,181,167,139,72,8,0,59,119,112,88,68,124,170,139,153,150,93,33,0,0,
  16,80,147,195,131,64,0,0,0,0,0,0,60,124,191,147,80,16,0,0,0,1,46,94,142,
  187,142,94,48,1,0,32,96,163,179,112,112,108,95,72,37,0,0,0,12,76,143,
  199,135,68,4,0,32,96,151,151,151,151,151,151,151,151,108,44,0,32,96,163,
  163,163,159,92,28,0,0,0,0,26,87,151,190,135,98,113,167,207,143,76,0,32,
  96,163,171,179,202,171,171,167,100,36,32,96,135,135,179,135,135,168,142,
  135,135,72,8,0,31,67,53,29,80,147,139,79,111,173,108,44,0,0,16,80,147,
  195,131,64,60,60,32,6,45,52,60,124,191,147,80,52,51,20,0,43,91,139,184,
  142,94,49,40,39,14,32,96,163,179,112,48,44,34,14,0,0,6,45,52,76,143,199,
  135,68,52,42,22,73,84,84,84,84,84,84,84,84,79,33,0,32,96,163,163,124,
  124,91,28,0,0,0,0,9,69,124,178,183,163,170,155,197,143,76,0,29,88,104,
  104,155,187,120,104,104,91,33,15,60,75,139,164,100,116,179,120,68,68,
  46,0,0,0,3,0,13,76,139,153,110,131,164,102,40,0,0,12,75,139,201,153,124,
  124,122,60,31,93,116,116,124,191,147,116,116,111,51,29,88,136,181,142,
  104,104,104,104,102,52,32,96,163,179,112,48,0,0,0,0,0,31,93,116,116,143,
  199,135,116,116,86,32,95,124,124,124,124,124,124,124,124,107,44,0,32,
  96,163,163,96,60,51,7,0,0,0,0,0,37,85,124,151,155,140,124,191,139,72,
  0,0,34,40,88,155,187,120,56,40,36,1,0,29,91,154,148,85,133,169,106,44,
  4,0,0,0,0,0,0,0,53,105,151,174,164,124,76,21,0,0,0,57,113,158,175,179,
  179,124,60,32,96,163,183,183,207,187,183,183,116,52,32,96,163,205,171,
  171,171,171,171,120,56,32,96,163,179,112,48,0,0,0,0,0,32,96,163,183,186,
  207,184,183,155,88,32,96,163,187,187,187,187,187,187,175,108,44,0,32,
  96,163,163,96,32,0,0,0,0,0,0,0,26,59,69,85,88,78,139,188,124,63,0,0,0,
  24,88,155,187,120,56,0,0,0,0,40,104,131,131,84,131,131,91,29,0,0,0,0,
  0,0,0,0,15,60,93,108,102,76,34,0,0,0,0,23,68,97,108,112,112,111,58,32,
  96,143,143,143,143,143,143,143,116,52,32,96,155,155,155,155,155,155,155,
  120,56,32,96,139,139,112,48,0,0,0,0,0,32,96,143,143,143,143,143,143,143,
  88,32,95,120,120,120,120,120,120,120,120,106,43,0,32,96,163,163,96,32,
  0,0,0,0,0,0,0,52,115,102,83,84,113,165,167,106,45,0,0,0,24,88,155,187,
  120,56,0,0,0,0,19,59,64,64,50,64,64,52,6,0,0,0,0,0,0,0,0,0,8,34,44,40,
  21,0,0,0,0,0,0,13,36,45,48,48,48,23,19,67,76,76,76,76,76,76,76,74,36,
  24,76,88,88,88,88,88,88,88,87,45,17,63,72,72,69,30,0,0,0,0,0,19,67,76,
  76,76,76,76,76,76,62,8,49,56,56,56,56,56,56,56,56,53,17,0,32,96,163,163,
  96,32,0,0,0,0,0,0,0,52,116,163,147,148,169,181,133,79,22,0,0,0,24,88,
  155,187,120,56,0,0,0,0,0,0,0,0,0,15,32,32,32,19,0,0,0,24,32,32,32,10,
  0,3,31,32,32,28,0,0,27,32,32,25,0,0,0,8,32,32,32,15,0,0,0,0,0,17,32,32,
  32,21,0,0,0,27,32,32,32,32,29,19,1,0,0,0,0,27,32,32,32,32,32,32,32,32,
  30,0,0,0,0,0,0,0,27,32,32,19,0,0,0,0,0,0,0,0,32,96,163,163,96,32,0,0,
  0,0,0,0,0,52,116,153,164,165,153,124,88,42,0,0,0,0,24,88,155,187,120,
  56,0,0,0,0,0,0,0,0,0,60,96,96,96,67,0,0,19,76,96,96,95,54,0,44,92,96,
  96,85,30,27,82,96,96,80,23,0,0,51,95,96,96,60,0,0,0,0,9,63,96,96,96,70,
  11,0,27,82,96,96,96,96,92,82,60,26,0,0,27,82,96,96,96,96,96,96,96,96,
  90,38,0,0,0,0,0,27,82,96,96,67,0,0,0,0,0,0,0,0,32,96,163,163,96,32,0,
  0,0,0,0,0,0,33,70,90,100,100,91,69,39,0,0,0,0,0,24,88,155,171,120,56,
  0,0,0,0,0,0,0,0,4,68,135,163,143,76,0,0,19,78,135,163,144,86,31,76,133,
  163,145,88,30,30,92,159,163,96,34,0,0,60,124,163,131,67,0,0,0,0,43,97,
  153,163,147,80,16,0,32,96,163,163,163,163,159,144,115,71,20,0,32,96,163,
  163,163,163,163,163,163,163,108,44,0,0,0,0,0,32,96,163,143,76,0,0,0,0,
  0,0,0,0,32,96,163,163,96,32,0,0,0,0,0,0,0,0,10,27,36,36,28,11,0,0,0,0,
  0,0,21,81,104,104,102,52,0,0,0,0,0,0,4,19,20,68,135,199,143,76,0,0,0,
  45,101,158,175,119,63,108,165,169,111,57,2,22,84,151,168,104,40,32,32,
  66,131,187,120,59,0,0,0,24,78,133,186,211,147,80,16,0,32,96,163,186,155,
  155,164,198,163,106,47,0,32,96,159,159,159,179,185,159,159,159,108,44,
  0,0,0,0,0,32,96,163,143,76,0,0,0,0,0,0,0,0,32,96,163,163,96,32,0,0,0,
  0,0,0,0,27,32,32,32,32,32,15,0,0,0,0,0,0,0,31,40,40,39,14,0,0,0,0,0,30,
  63,81,84,68,135,199,143,76,0,0,0,14,69,124,181,151,94,142,192,136,80,
  25,0,15,77,143,175,108,88,96,96,72,135,179,115,52,0,0,5,59,111,167,136,
  188,147,80,16,0,32,96,163,179,112,88,105,162,188,124,61,0,25,80,92,92,
  100,167,175,108,92,92,86,36,0,0,0,0,0,32,96,163,143,76,0,0,0,0,0,0,0,
  0,32,96,163,163,96,32,0,0,0,0,0,0,27,82,96,96,96,96,96,60,0,0,0,0,0,0,
  0,13,30,32,22,16,16,16,6,0,28,77,119,145,149,124,135,199,143,76,0,0,0,
  0,37,92,149,183,124,172,160,102,49,0,0,7,69,135,181,116,112,163,151,86,
  143,172,108,44,0,0,39,93,147,154,120,187,147,80,16,0,32,96,163,179,112,
  48,84,151,195,131,64,0,0,23,28,36,100,167,175,108,44,28,26,0,0,0,0,0,
  0,32,96,163,143,76,0,0,0,0,0,0,0,0,32,96,163,163,96,44,36,0,0,0,0,0,32,
  96,163,163,163,163,135,68,4,0,0,0,0,0,37,72,92,96,81,80,80,80,60,0,58,
  115,170,193,168,173,135,199,143,76,0,0,0,0,5,60,115,172,183,184,131,72,
  17,0,0,0,62,124,187,120,124,187,163,99,147,165,100,36,0,19,73,131,174,
  119,120,187,147,80,16,0,32,96,163,179,112,88,106,162,179,119,57,0,0,0,
  0,36,100,167,175,108,44,0,0,0,0,0,0,0,0,32,96,163,143,76,0,0,0,0,0,0,
  0,0,32,96,163,163,108,108,86,26,0,0,0,0,32,96,143,143,150,199,135,68,
  4,0,0,0,0,31,82,124,156,162,140,131,147,147,80,18,80,143,202,149,104,
  115,167,207,143,76,0,0,0,0,0,28,83,140,200,153,95,40,0,0,0,0,54,116,183,
  131,136,147,173,112,151,159,92,30,0,54,108,163,140,84,120,187,147,80,
  16,0,32,96,163,186,155,155,164,165,139,91,35,0,0,0,0,36,100,167,175,108,
  44,0,0,0,0,0,0,0,0,32,96,163,143,76,0,0,0,0,0,0,0,0,32,96,163,179,175,
  159,92,28,0,0,0,0,19,67,76,76,143,199,135,68,4,0,0,0,3,62,119,173,181,
  152,158,144,197,147,80,28,92,157,184,120,61,79,143,204,143,76,0,0,0,0,
  0,45,101,158,213,170,113,58,2,0,0,0,47,108,175,135,147,135,160,124,155,
  151,85,23,29,88,144,159,104,84,120,187,147,84,76,26,32,96,163,190,163,
  168,188,144,96,46,1,0,0,0,0,36,100,167,175,108,44,0,0,0,0,0,0,0,0,32,
  96,163,143,76,0,0,0,0,0,0,0,0,31,92,112,112,112,112,88,27,0,0,0,0,0,8,
  12,76,143,199,135,68,4,0,0,0,20,83,145,198,140,91,102,156,211,147,80,
  32,96,163,179,112,48,68,135,199,143,76,0,0,0,0,22,78,135,190,152,187,
  145,88,33,0,0,0,39,101,167,143,159,120,147,140,160,143,79,16,32,96,163,
  154,151,151,151,192,159,151,100,36,32,96,163,179,112,108,158,185,131,
  70,13,0,0,0,0,36,100,167,175,108,44,0,0,0,0,0,0,0,0,32,96,163,143,76,
  0,0,0,0,0,0,0,0,3,42,48,48,48,48,40,0,0,0,0,0,0,0,12,76,143,199,135,68,
  4,0,0,0,31,92,159,181,116,55,72,135,199,147,80,32,96,160,179,112,51,70,
  135,199,143,76,0,0,0,0,54,110,167,167,110,156,177,120,65,10,0,0,31,93,
  159,148,171,107,133,154,169,135,72,8,32,96,163,171,171,171,171,202,176,
  167,100,36,32,96,163,179,112,68,124,183,158,99,42,0,0,0,0,36,100,167,
  175,108,44,0,0,0,0,0,0,0,0,32,96,163,143,76,0,0,0,0,0,0,0,0,0,0,0,18,
  30,32,30,20,5,0,0,0,0,0,12,76,143,199,135,68,4,0,0,0,32,96,163,179,112,
  48,64,131,195,147,80,25,88,152,190,131,72,90,149,207,143,76,0,0,0,31,
  86,144,190,135,78,122,179,154,97,42,0,0,23,86,151,198,159,95,116,182,
  191,131,64,0,29,88,104,104,104,104,120,187,147,104,91,33,32,96,163,179,
  112,48,97,156,186,131,70,13,0,0,0,36,100,167,175,108,44,0,0,0,0,0,0,0,
  0,32,96,163,143,76,0,0,0,0,0,0,0,0,0,12,51,78,92,96,92,83,66,29,0,0,0,
  0,12,76,143,199,135,68,4,0,0,0,30,92,159,183,119,58,74,139,200,147,80,
  11,72,133,190,164,131,136,160,206,143,76,0,0,8,63,119,175,158,101,45,
  90,147,186,131,74,19,0,16,79,143,203,145,81,104,168,185,120,56,0,0,34,
  40,40,40,56,120,187,147,80,36,1,32,96,163,179,112,48,69,124,186,158,99,
  42,0,0,0,36,100,167,175,108,44,0,0,0,0,0,0,0,0,32,96,163,143,76,0,0,0,
  0,0,0,0,0,1,56,102,139,158,163,159,147,116,52,0,0,0,0,12,76,143,199,135,
  68,4,0,0,0,19,81,143,201,145,97,108,160,211,147,80,0,45,99,150,181,183,
  153,135,171,143,76,0,0,28,91,139,139,124,70,15,59,113,139,139,103,40,
  0,8,71,135,139,133,68,91,139,139,112,49,0,0,0,0,0,0,56,120,143,143,80,
  16,0,32,96,139,139,112,48,42,99,139,139,131,67,0,0,0,36,100,139,139,108,
  44,0,0,0,0,0,0,0,0,32,96,163,143,76,0,0,0,0,0,0,0,0,24,85,145,192,151,
  139,143,160,116,52,0,0,0,0,12,76,143,199,135,68,4,4,0,0,0,58,115,167,
  187,160,165,140,196,147,80,0,11,57,95,116,119,99,104,104,104,70,0,0,13,
  61,72,72,71,37,0,27,68,72,72,67,24,0,0,46,72,72,72,43,59,72,72,69,30,
  0,0,0,0,0,0,39,75,76,76,57,4,0,17,63,72,72,69,30,13,61,72,72,72,46,0,
  0,0,20,65,72,72,68,27,0,0,0,0,0,0,0,0,32,96,163,143,76,0,0,0,0,0,0,0,
  0,32,96,163,171,104,72,79,99,115,52,0,0,0,0,11,73,139,201,139,78,68,68,
  53,0,0,26,74,116,145,151,133,131,195,147,80,0,0,8,38,54,56,42,40,40,40,
  26,0,0,0,0,0,0,0,18,29,32,32,22,0,0,0,0,25,32,32,32,8,0,19,32,32,32,19,
  0,0,0,0,21,32,32,22,2,0,0,0,0,27,32,32,31,3,0,0,0,0,0,0,0,27,32,32,32,
  32,32,23,5,0,0,0,0,27,32,32,27,0,32,96,163,143,76,0,0,0,0,0,0,0,0,28,
  91,154,192,153,131,112,93,63,26,0,0,0,0,1,63,124,184,170,139,135,135,
  84,0,0,34,93,97,80,84,83,140,201,139,74,0,0,0,0,10,27,32,31,19,0,0,0,
  0,0,0,0,9,52,79,92,96,96,73,0,0,0,23,80,96,96,95,51,8,67,96,96,96,67,
  0,0,18,54,82,95,96,83,59,23,0,0,27,82,96,96,92,42,0,0,0,0,0,0,27,82,96,
  96,96,96,95,85,65,32,0,0,27,82,96,96,82,27,32,96,163,143,76,0,0,0,0,0,
  0,0,0,10,67,116,156,178,190,176,153,111,61,4,0,0,0,0,40,94,142,165,171,
  171,151,84,0,0,36,100,157,139,135,142,175,177,120,59,0,0,3,41,70,88,96,
  93,81,58,23,0,0,0,0,0,42,97,140,158,163,151,84,0,0,0,25,85,145,163,135,
  72,28,88,151,163,131,69,0,11,63,108,143,159,160,145,111,68,18,0,32,96,
  163,163,112,48,0,0,0,0,0,0,32,96,163,163,163,163,159,148,120,80,29,0,
  32,96,163,163,96,32,32,96,163,143,76,0,0,0,0,0,0,0,0,0,42,68,95,115,131,
  153,195,148,86,23,0,0,0,0,6,51,83,100,104,104,104,78,0,0,36,100,160,172,
  179,175,163,133,88,35,0,0,49,93,131,152,163,159,143,113,58,0,0,0,0,0,
  62,124,186,156,124,124,83,0,0,0,2,62,120,182,156,93,48,108,170,168,106,
  47,0,44,99,153,198,168,165,193,160,106,51,0,32,96,163,179,112,48,4,8,
  8,8,0,0,32,96,163,181,151,151,155,184,172,116,57,0,32,96,163,163,96,32,
  27,82,96,96,67,0,0,0,0,0,0,0,0,23,86,106,81,65,68,108,175,159,92,28,0,
  0,0,0,0,0,24,38,40,40,40,29,0,0,26,76,96,108,112,111,100,78,43,0,0,35,
  88,142,184,183,164,164,181,124,60,0,0,0,0,4,68,135,196,135,68,60,47,0,
  0,0,0,38,98,160,176,115,68,131,190,145,85,24,7,67,131,188,156,108,102,
  150,194,135,74,13,32,96,163,179,112,48,63,72,72,72,54,3,32,96,163,175,
  108,84,92,145,198,135,69,7,32,96,163,163,96,32,0,27,32,32,19,0,0,0,0,
  0,0,0,0,24,88,155,143,131,124,144,190,147,85,23,0,0,0,0,9,26,32,30,18,
  0,0,0,0,0,0,19,34,44,48,48,38,20,0,0,2,61,120,177,173,124,100,100,122,
  124,60,0,0,0,0,4,68,135,195,131,64,0,0,0,0,0,0,15,74,136,195,136,88,151,
  183,120,62,2,20,83,147,196,135,70,63,124,188,154,91,28,32,96,163,179,
  112,63,110,139,139,133,79,16,32,96,163,175,108,60,75,139,196,135,68,6,
  32,96,163,163,96,32,0,0,0,0,17,32,32,31,6,0,0,0,0,24,88,145,162,171,175,
  168,151,111,60,4,0,0,0,34,67,87,96,92,79,52,15,0,0,0,27,32,32,31,3,0,
  0,0,0,0,18,80,143,203,143,83,38,38,71,107,57,0,0,0,0,4,68,135,195,131,
  64,0,0,0,0,0,0,0,52,111,172,158,108,170,160,99,39,0,28,92,158,187,120,
  58,50,112,179,164,100,36,32,96,163,179,112,105,156,178,133,85,43,0,32,
  96,163,175,124,124,131,164,162,111,54,0,32,96,163,163,96,32,0,0,0,14,
  63,96,96,93,48,0,0,0,0,10,60,83,97,104,108,104,90,61,20,0,0,0,32,82,122,
  151,163,159,140,104,58,6,0,27,82,96,96,92,42,0,0,0,0,0,28,91,155,188,
  124,62,56,56,56,56,45,0,0,6,45,52,77,139,192,131,64,0,0,0,0,0,0,0,29,
  88,149,179,131,190,139,77,18,0,32,96,163,183,116,52,44,108,175,171,104,
  40,32,96,163,179,112,150,178,133,85,40,0,0,32,96,163,204,187,187,189,
  131,113,81,37,0,32,95,159,159,95,32,0,0,3,52,102,156,163,139,88,37,0,
  0,0,0,4,21,35,43,44,40,29,6,0,0,0,3,63,120,174,173,151,158,192,149,92,
  32,0,32,96,163,163,112,48,0,0,0,0,0,32,96,163,183,116,75,120,120,120,
  120,87,0,0,31,93,116,124,165,167,113,53,0,0,0,0,0,0,0,5,65,124,185,187,
  176,115,54,0,0,32,96,163,183,116,52,44,108,175,171,104,40,32,96,163,182,
  147,192,133,85,40,0,0,0,32,96,163,175,120,120,124,153,172,124,70,11,24,
  88,155,155,88,25,0,0,42,92,144,187,164,178,124,77,26,0,0,0,27,32,32,31,
  3,31,32,32,27,0,0,16,79,143,186,124,87,101,156,174,108,47,0,32,96,163,
  179,112,48,20,14,0,0,0,32,96,163,183,116,76,143,187,187,155,88,0,0,32,
  96,163,177,157,120,85,33,0,0,0,0,0,0,0,0,42,101,162,213,153,92,33,0,0,
  28,92,159,187,120,57,49,112,179,167,100,36,32,96,163,221,179,176,156,
  101,47,0,0,0,32,96,163,175,108,56,63,119,182,154,91,28,19,82,147,148,
  84,20,0,31,81,133,183,142,108,156,167,116,66,15,0,27,82,96,96,92,42,92,
  96,96,82,27,0,16,80,147,179,112,50,81,147,177,112,48,0,32,96,163,179,
  112,76,84,76,50,9,0,28,92,156,188,124,76,131,131,168,155,88,0,0,29,88,
  104,115,159,176,116,56,0,0,0,0,0,0,0,8,19,78,139,190,131,69,10,0,0,21,
  83,147,194,133,69,62,124,187,155,91,29,32,96,163,182,131,139,190,136,
  81,28,0,0,32,96,163,175,108,44,51,113,179,163,96,32,15,65,88,88,65,15,
  17,70,119,172,139,94,63,108,153,156,105,54,0,32,96,163,163,112,48,112,
  163,163,96,32,0,7,67,124,178,139,106,116,165,156,97,37,0,32,96,163,179,
  112,139,151,139,99,50,0,19,81,144,202,142,81,64,100,167,155,88,0,0,0,
  34,40,73,139,193,131,64,0,0,0,0,0,0,40,72,72,102,162,169,107,48,0,0,0,
  8,68,131,189,154,102,99,147,196,139,76,14,32,96,163,179,112,105,162,171,
  115,61,8,0,32,96,163,175,108,104,108,139,193,154,91,28,32,96,135,135,
  96,32,27,90,116,116,91,48,18,60,105,116,116,74,0,32,96,163,179,112,48,
  112,179,163,96,32,0,0,38,85,124,167,171,177,144,110,65,12,0,32,96,163,
  179,139,163,176,192,139,77,16,3,62,120,179,171,122,95,100,167,155,88,
  0,0,0,0,4,68,135,195,131,64,0,0,0,0,0,0,60,124,139,151,192,142,83,25,
  0,0,0,0,45,102,156,195,163,162,190,162,108,53,0,32,96,163,179,112,73,
  131,185,151,95,42,0,32,96,163,192,171,171,173,192,171,124,70,11,32,96,
  163,163,96,32,2,44,52,52,42,1,0,15,49,52,52,36,0,32,96,163,179,112,48,
  112,179,163,96,32,0,6,62,113,159,164,143,149,176,142,92,38,0,32,96,163,
  193,136,96,131,188,156,92,28,0,37,91,144,187,177,159,163,189,155,88,0,
  0,0,0,4,68,135,195,131,64,12,4,0,0,0,0,60,124,167,167,149,105,53,0,0,
  0,0,0,14,66,111,147,163,164,149,115,71,20,0,32,96,163,171,112,48,96,153,
  171,131,76,20,32,96,143,143,143,143,142,133,113,80,36,0,32,96,139,139,
  96,32,0,27,32,32,25,27,32,32,25,0,0,0,0,32,96,163,179,112,48,112,179,
  163,96,32,0,26,87,149,173,115,78,90,140,182,120,61,0,32,96,163,179,113,
  52,112,179,163,96,32,0,2,51,96,135,157,167,163,145,113,74,0,0,0,0,4,68,
  135,196,135,80,76,60,0,0,0,0,54,99,100,100,90,58,15,0,0,0,0,0,0,20,59,
  86,99,100,88,63,26,0,0,29,88,104,104,99,44,65,104,104,104,84,25,19,67,
  76,76,76,76,76,68,53,28,0,0,17,63,72,72,63,17,27,82,96,96,80,82,96,96,
  80,23,0,0,0,32,96,163,179,112,48,112,179,163,96,32,0,32,96,163,163,96,
  32,60,124,191,135,68,0,32,96,163,179,112,48,112,179,163,96,32,0,0,6,45,
  74,93,100,96,83,58,25,0,0,0,0,0,59,120,179,167,143,143,84,0,0,0,0,14,
  36,36,36,29,4,0,0,0,0,0,0,0,0,3,25,36,36,27,6,0,0,0,0,34,40,40,38,9,21,
  40,40,40,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,96,163,159,92,96,
  163,159,92,28,0,0,0,32,96,163,179,112,52,115,179,163,96,32,0,30,92,157,
  173,115,78,90,142,192,131,65,0,32,96,163,179,112,48,112,179,163,96,32,
  0,0,0,0,15,31,36,34,23,1,0,0,0,0,0,0,35,88,124,143,147,147,84,0,0,0,0,
  27,32,32,32,19,13,32,32,32,31,3,0,27,32,32,31,3,0,15,32,32,32,19,0,0,
  0,0,0,0,0,24,32,32,22,0,25,32,32,21,0,0,0,0,0,0,0,8,32,32,32,30,0,0,32,
  96,163,159,92,96,163,159,92,28,0,0,0,31,93,159,185,122,88,135,192,163,
  96,32,0,15,76,135,187,164,143,149,181,164,108,49,0,32,96,163,179,112,
  48,112,179,163,96,32,0,0,0,0,10,27,32,32,21,2,0,0,0,0,0,0,0,39,65,76,
  80,80,63,0,0,0,27,82,96,96,96,68,56,96,96,96,92,42,27,82,96,96,92,42,
  2,60,96,96,96,67,0,0,0,0,0,0,20,76,96,96,73,23,80,96,96,70,13,0,0,0,0,
  0,0,49,95,96,96,90,38,0,32,96,163,159,92,96,163,159,92,28,0,0,0,20,82,
  143,198,169,155,140,179,163,96,32,0,0,45,94,136,160,171,167,152,119,74,
  22,0,32,96,163,179,112,48,112,179,163,96,32,0,0,4,42,70,88,96,95,82,60,
  20,0,0,0,0,0,0,21,32,32,32,13,0,0,0,0,32,96,163,163,152,88,74,139,163,
  163,112,48,28,90,154,163,120,59,15,77,142,163,135,71,0,0,0,0,0,0,47,104,
  163,135,76,24,83,142,158,97,40,0,0,0,0,0,0,56,120,163,163,108,44,0,32,
  96,163,159,92,96,163,159,92,28,0,0,0,0,56,105,147,159,145,112,147,147,
  96,32,0,0,4,45,78,97,104,102,90,65,29,0,0,32,96,163,171,112,48,112,171,
  163,96,32,0,0,49,94,131,153,163,159,145,107,44,0,0,0,0,0,11,70,96,96,
  96,56,0,0,0,0,32,96,163,195,168,104,91,154,189,179,112,48,13,75,139,197,
  135,71,28,91,155,182,119,57,0,0,0,0,0,15,74,133,165,106,49,0,56,113,174,
  124,67,9,0,0,0,0,0,56,120,187,175,108,44,0,31,93,116,116,90,93,116,116,
  90,27,0,0,0,0,15,58,85,92,83,77,80,80,70,21,0,0,0,0,18,35,40,39,29,8,
  0,0,0,29,88,104,104,99,44,99,104,104,88,29,0,35,90,142,184,181,163,167,
  175,108,44,0,0,0,0,0,16,80,147,163,131,64,0,0,0,0,32,96,163,159,158,120,
  107,170,143,179,112,48,0,61,122,186,148,84,41,104,168,168,104,41,0,0,
  0,0,0,42,101,160,139,79,22,0,29,86,147,153,93,36,0,0,0,0,0,56,120,151,
  151,108,44,0,6,45,52,52,44,45,52,52,44,2,0,0,0,0,0,3,23,28,22,15,16,16,
  11,0,0,0,0,0,3,24,32,31,18,0,0,0,0,0,34,40,40,38,9,38,40,40,34,0,2,62,
  120,179,173,124,99,102,131,108,44,0,0,0,0,0,16,80,147,195,131,64,0,0,
  0,0,32,96,163,159,143,140,124,159,143,179,112,48,0,46,108,172,162,97,
  55,116,180,153,88,27,0,0,0,0,12,69,131,170,110,53,0,0,3,60,119,177,120,
  63,4,0,0,0,0,43,83,84,84,79,33,0,0,27,32,32,32,32,32,32,32,32,32,32,15,
  0,15,20,20,19,26,32,27,4,0,0,0,0,0,23,60,86,96,93,78,48,6,0,0,0,0,0,15,
  31,32,19,20,20,20,8,18,80,143,203,144,84,38,42,77,93,39,0,0,0,0,13,16,
  80,139,139,131,64,0,0,0,0,32,96,163,159,124,157,142,144,143,179,112,48,
  0,31,93,157,174,111,67,131,193,139,74,13,0,0,0,0,38,95,156,144,83,26,
  0,0,0,33,92,151,149,90,31,0,0,0,0,32,63,64,64,61,22,0,27,82,96,96,96,
  96,96,96,96,96,96,96,60,22,73,84,84,81,87,96,88,61,18,0,0,0,17,68,113,
  147,163,159,136,96,49,0,0,0,0,40,74,93,96,78,84,84,84,60,28,92,156,188,
  124,63,0,0,26,34,3,0,0,0,24,72,80,80,80,80,80,48,0,0,0,0,32,96,163,159,
  111,174,164,131,143,179,112,48,0,16,79,143,187,124,80,144,185,120,59,
  0,0,0,0,8,65,124,174,115,56,0,0,0,0,6,65,122,176,116,58,1,0,0,0,56,120,
  131,131,108,44,0,32,96,163,163,163,163,163,163,163,163,163,135,68,32,
  96,151,151,112,149,163,149,108,56,0,0,0,47,104,159,187,156,163,189,140,
  83,25,0,0,35,85,131,158,160,136,135,151,143,76,32,96,163,183,116,53,0,
  0,0,0,0,0,0,0,36,100,147,147,147,147,131,64,0,0,0,0,32,96,163,159,96,
  160,176,112,143,179,112,48,0,2,64,124,189,139,93,158,170,107,45,0,0,0,
  0,35,92,152,147,88,29,0,0,0,0,0,38,95,154,145,85,28,0,0,0,56,120,187,
  175,108,44,0,32,95,124,124,124,124,124,124,124,124,124,124,68,32,96,163,
  181,144,151,165,199,143,81,19,0,9,69,131,190,145,94,111,169,169,107,46,
  0,4,63,122,177,181,152,158,139,200,143,76,32,96,163,183,116,52,0,0,0,
  0,0,0,0,0,36,100,159,159,165,195,131,64,0,0,0,0,32,96,163,159,92,120,
  120,97,143,179,112,48,0,0,49,111,175,151,107,170,156,92,31,0,0,0,3,62,
  119,177,119,62,3,0,0,0,0,0,10,69,124,172,111,54,0,0,0,58,120,187,172,
  108,44,0,10,53,60,60,60,60,60,60,60,60,60,60,37,32,96,163,189,131,85,
  122,185,159,92,28,0,22,84,148,188,124,62,86,149,187,124,60,0,21,83,147,
  197,140,90,102,158,207,143,76,28,92,157,188,124,61,0,0,22,30,0,0,0,0,
  29,82,92,92,147,195,131,64,0,0,0,0,32,96,163,159,92,56,56,76,143,179,
  112,48,0,0,34,96,160,164,120,183,142,78,15,0,0,0,30,88,147,151,92,34,
  0,0,0,0,0,0,0,42,99,160,140,81,24,0,8,70,135,196,144,85,28,0,0,0,30,32,
  32,30,0,0,0,0,0,0,0,32,96,163,179,112,49,112,179,163,96,32,0,28,92,159,
  179,116,91,83,142,197,135,68,0,31,92,159,181,116,55,74,139,201,143,76,
  19,81,144,202,142,81,33,38,74,90,38,0,0,0,0,24,28,80,147,195,131,64,0,
  0,0,0,32,96,163,159,92,28,12,76,143,179,112,48,0,0,20,82,145,177,135,
  188,124,63,1,0,0,0,58,115,174,122,65,8,0,0,0,0,0,0,0,15,72,133,168,108,
  51,0,20,83,147,170,111,54,0,0,0,38,90,96,96,90,38,0,0,0,0,0,0,32,96,163,
  179,112,48,112,179,163,96,32,0,32,96,163,179,112,153,136,139,203,139,
  72,0,32,96,163,179,112,48,68,135,199,143,76,3,63,122,181,171,122,95,98,
  124,108,44,0,0,0,0,0,16,80,147,195,131,64,0,0,0,0,32,96,163,159,92,28,
  12,76,143,179,112,48,0,0,6,67,131,192,184,174,110,48,0,0,0,26,85,144,
  156,95,38,0,0,0,0,0,0,0,0,0,45,103,163,136,78,19,32,95,135,135,83,26,
  0,0,0,44,108,163,163,108,44,0,0,0,0,0,0,32,96,163,179,112,48,112,179,
  163,96,32,0,32,96,163,179,112,153,136,139,203,139,72,0,32,95,159,180,
  116,54,74,139,200,143,76,0,37,92,144,188,177,159,162,175,108,44,0,0,0,
  0,0,16,80,147,195,131,64,0,0,0,0,32,96,139,139,92,28,12,76,139,139,112,
  48,0,0,0,53,115,143,143,143,95,34,0,0,0,53,111,170,131,69,12,0,0,0,0,
  0,0,0,0,0,19,77,136,163,104,45,15,60,68,68,48,0,0,0,0,44,108,175,175,
  108,44,0,0,0,0,0,0,32,96,163,179,112,48,112,179,163,96,32,0,28,92,159,
  179,115,91,83,140,198,135,68,0,23,85,149,196,139,86,99,156,207,143,76,
  0,3,51,96,135,157,167,163,149,108,44,0,0,0,0,0,16,80,147,195,131,64,0,
  0,0,0,17,63,72,72,61,13,0,51,72,72,69,30,0,0,0,32,73,76,76,76,65,15,0,
  0,22,79,140,160,101,42,0,0,0,0,0,0,0,0,0,0,0,49,108,167,133,73,0,0,0,
  0,0,0,0,0,0,54,116,179,158,99,40,0,0,0,0,0,0,32,96,163,179,112,48,112,
  179,163,96,32,0,22,84,149,187,124,61,85,148,188,124,61,0,7,67,124,182,
  178,148,154,149,202,143,76,0,0,6,45,74,92,100,98,86,63,22,0,0,0,0,0,16,
  80,147,195,131,64,0,0,0,0,0,27,32,32,31,3,6,31,32,32,25,0,0,27,32,32,
  31,3,0,29,32,32,32,10,30,90,108,108,72,15,0,0,0,0,0,0,0,0,0,0,0,23,81,
  108,108,83,0,0,0,0,0,0,0,0,9,70,135,186,131,70,13,0,0,0,0,0,0,32,96,159,
  159,112,48,112,159,159,96,32,0,10,70,133,192,144,91,108,167,170,108,47,
  0,0,39,91,139,165,168,142,135,199,143,76,0,0,0,0,15,31,36,36,25,5,0,0,
  0,0,0,0,16,80,147,195,131,64,0,0,0,0,27,82,96,96,92,42,45,93,96,96,80,
  23,27,82,96,96,92,42,40,88,96,96,95,53,0,38,44,44,29,0,0,0,0,0,0,0,0,
  0,0,0,0,0,33,44,44,35,0,0,0,0,0,0,0,0,24,86,149,156,97,42,0,0,0,0,0,0,
  0,25,80,92,92,88,40,88,92,92,80,25,0,0,49,106,161,184,152,160,192,142,
  85,27,0,0,1,46,81,100,104,86,135,199,143,76,0,0,0,10,27,32,32,22,5,0,
  0,0,0,8,49,56,56,86,151,190,124,60,0,0,0,0,32,96,163,163,112,48,52,116,
  163,159,92,28,32,96,163,163,112,48,80,131,163,156,105,53,0,27,32,32,28,
  15,0,0,0,0,0,0,22,32,32,32,32,32,32,32,32,27,0,0,27,32,32,32,32,24,24,
  82,100,100,69,12,0,0,0,0,0,0,0,0,23,28,28,27,0,27,28,28,23,0,0,0,19,71,
  116,151,167,163,140,99,51,0,0,0,0,0,23,38,40,68,135,199,143,76,0,0,39,
  70,88,96,95,83,66,42,0,0,0,32,95,120,120,131,172,177,115,52,0,0,0,0,32,
  96,163,179,112,48,52,116,183,159,92,28,32,96,163,179,112,68,119,170,167,
  113,65,15,27,82,96,96,91,76,45,0,0,0,0,15,73,96,96,96,96,96,96,96,96,
  82,27,27,82,96,96,96,96,76,0,29,36,36,22,0,0,0,0,0,0,0,0,0,0,0,14,27,
  32,32,27,11,0,0,0,0,0,26,63,90,100,97,81,51,9,0,0,0,0,0,0,0,4,68,135,
  179,143,76,0,40,88,124,153,163,159,147,124,88,27,0,0,32,96,163,183,183,
  174,142,90,33,0,0,0,0,32,96,163,179,112,48,52,116,183,159,92,28,32,96,
  163,179,112,108,159,175,124,74,25,0,32,96,163,163,155,135,88,31,0,0,0,
  20,84,151,163,163,163,163,163,163,163,96,32,32,96,163,163,163,155,88,
  0,27,32,32,32,32,32,24,0,0,0,0,0,0,17,56,76,88,96,96,88,72,42,1,0,0,0,
  0,6,28,36,35,22,0,0,0,0,0,0,0,0,0,3,66,112,112,112,73,14,72,131,181,176,
  156,156,170,159,92,28,0,0,31,93,116,116,116,111,88,51,2,0,0,0,0,32,96,
  163,179,112,48,52,116,183,159,92,28,32,96,163,179,112,147,186,136,85,
  35,0,0,32,95,124,131,165,174,112,50,0,0,0,20,84,151,163,163,163,163,169,
  219,163,96,32,32,95,124,124,171,155,88,27,82,96,96,96,96,96,76,0,0,0,
  0,0,0,40,103,139,154,163,163,153,131,91,39,0,0,27,32,32,31,3,0,25,32,
  32,31,6,0,0,0,0,0,0,28,48,48,48,32,29,92,156,183,124,92,92,108,139,92,
  28,0,0,6,45,52,52,52,48,31,2,0,0,0,0,0,32,96,163,179,112,48,52,116,183,
  159,92,28,32,96,163,179,139,187,148,94,45,0,0,0,10,53,60,80,145,187,120,
  56,0,0,0,15,73,96,96,96,96,105,160,187,135,81,25,10,53,60,104,171,155,
  88,32,96,163,163,163,163,155,88,0,0,0,0,0,0,40,104,170,151,139,140,162,
  182,124,67,0,27,82,96,96,92,42,24,80,96,96,93,45,0,0,0,0,19,30,32,27,
  11,0,0,32,96,163,179,113,67,40,51,83,77,22,0,0,0,15,20,20,28,32,17,27,
  32,23,0,0,0,32,96,163,179,112,48,52,116,183,159,92,28,32,96,163,210,192,
  189,173,115,60,3,0,0,0,0,12,76,143,187,120,56,0,0,0,0,22,32,32,36,88,
  144,196,150,96,45,0,0,0,40,104,171,155,88,32,96,163,179,179,179,155,88,
  0,0,0,0,0,0,40,104,110,87,80,80,122,187,147,82,0,28,88,151,163,122,61,
  41,102,163,163,108,48,0,0,20,54,79,92,96,88,72,45,2,27,88,152,202,156,
  124,101,78,49,22,0,0,0,22,73,84,84,90,96,74,88,96,83,46,0,0,32,96,163,
  179,112,48,52,116,183,159,92,28,32,96,163,213,164,139,193,147,90,33,0,
  0,0,0,12,76,143,187,120,56,0,0,0,0,0,0,19,72,124,179,167,113,60,8,0,0,
  0,40,104,171,155,88,31,92,112,112,112,112,112,85,0,0,0,0,0,0,40,85,119,
  139,147,147,147,190,155,88,0,9,69,131,192,140,77,58,120,182,152,88,28,
  0,19,66,108,142,159,163,153,133,90,27,8,65,116,160,192,185,162,136,102,
  60,10,0,0,32,96,151,139,149,160,122,147,163,139,86,27,0,32,96,163,179,
  112,48,52,116,183,159,92,28,32,96,163,181,122,106,165,177,119,63,8,0,
  0,0,12,76,142,191,124,66,52,40,0,0,0,2,54,108,162,182,131,76,24,0,0,0,
  0,40,104,171,155,88,3,42,48,48,48,48,48,38,0,0,0,0,0,17,76,133,176,182,
  160,155,155,193,155,88,0,0,51,111,173,157,95,75,139,193,131,69,9,0,53,
  108,159,193,162,151,157,159,92,28,0,26,70,104,133,157,179,192,151,99,
  42,0,0,32,96,163,165,143,171,163,145,159,169,104,43,0,30,92,159,179,116,
  56,61,120,185,152,88,24,32,96,163,179,112,76,135,192,151,93,38,0,0,0,
  3,65,124,174,156,122,116,82,0,0,0,38,91,144,197,145,92,40,0,0,0,0,0,40,
  104,171,155,88,0,27,32,32,25,0,0,27,32,32,32,15,0,31,92,158,194,136,96,
  88,120,187,155,88,0,0,31,92,154,174,111,91,155,173,111,51,0,17,78,139,
  197,149,102,84,95,122,92,28,0,25,29,47,73,95,122,167,186,124,62,0,0,32,
  96,163,153,88,149,168,104,135,179,112,48,0,20,82,145,201,147,112,113,
  153,199,139,77,15,32,96,163,179,112,48,102,162,181,124,68,12,0,0,0,43,
  94,124,168,175,151,84,0,0,20,73,124,181,162,108,56,4,0,0,0,0,0,40,104,
  171,155,88,27,82,96,96,80,23,27,82,96,96,96,60,0,32,96,163,187,120,58,
  78,135,196,155,88,0,0,11,72,135,190,131,108,172,154,92,32,0,28,92,157,
  183,120,60,21,35,70,65,15,23,80,88,53,28,36,79,143,199,135,68,0,0,32,
  96,163,151,84,147,167,100,131,183,116,52,0,2,62,116,170,197,176,177,201,
  167,113,56,0,32,96,163,179,112,48,74,131,188,156,97,42,0,0,6,67,131,184,
  149,111,104,78,0,4,57,108,163,177,124,71,52,52,52,48,12,0,0,40,104,171,
  155,88,32,96,163,159,92,28,32,96,163,163,135,68,0,24,86,147,201,150,116,
  131,168,199,155,88,0,0,0,53,113,176,147,124,188,135,73,11,0,32,96,163,
  179,112,48,0,0,10,7,0,28,92,142,110,88,80,97,152,192,131,65,0,0,32,96,
  163,151,84,147,167,100,131,183,116,52,0,0,29,77,116,143,155,154,142,113,
  74,25,0,32,96,139,139,112,48,44,101,139,139,131,67,0,0,12,76,143,188,
  124,62,40,29,0,31,92,147,199,142,116,116,116,116,116,101,39,0,0,40,104,
  171,155,88,32,96,163,159,92,28,32,96,163,199,135,68,0,3,59,111,151,171,
  172,153,120,159,155,88,0,0,0,34,95,157,163,143,177,115,53,0,0,31,92,159,
  181,116,55,9,24,59,52,7,28,92,159,170,153,147,157,189,165,108,51,0,0,
  32,96,163,151,84,147,167,100,131,183,116,52,0,0,0,29,60,80,88,88,79,58,
  26,0,0,17,63,72,72,69,30,15,61,72,72,72,46,0,0,12,76,143,187,120,56,0,
  0,0,32,96,163,207,185,183,183,183,183,171,104,40,0,0,40,104,171,155,88,
  32,96,163,159,92,28,32,96,151,151,135,68,0,0,20,62,92,107,108,93,91,92,
  92,74,0,0,0,15,76,139,193,183,158,95,34,0,0,20,82,144,199,142,92,72,82,
  111,91,28,27,90,131,153,167,171,165,151,119,74,22,0,0,32,96,163,151,84,
  147,167,100,131,183,116,52,0,0,25,32,32,31,3,0,0,0,0,0,0,0,0,9,24,28,
  22,4,0,0,19,26,0,0,8,12,76,143,187,120,56,0,0,0,32,96,143,143,143,143,
  143,143,143,143,104,40,0,38,44,104,171,155,88,32,96,163,159,92,28,22,
  73,84,84,84,53,0,0,0,6,32,44,44,33,28,28,28,20,0,0,0,0,57,116,147,147,
  139,76,15,0,0,1,60,115,169,184,151,139,144,159,92,28,2,45,70,90,100,104,
  100,88,63,29,0,0,0,32,96,163,151,84,147,167,100,131,183,116,52,0,23,80,
  96,96,92,45,0,0,0,0,0,0,0,37,67,87,92,83,63,39,39,72,86,36,19,67,76,85,
  147,184,120,56,0,0,0,19,67,76,76,76,76,76,76,76,76,70,26,30,90,108,108,
  171,155,88,31,93,116,116,90,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,35,77,80,80,80,51,0,0,0,0,27,77,119,154,171,175,165,144,92,28,0,
  0,10,28,38,40,37,27,6,0,0,0,0,32,96,159,151,84,147,159,100,131,159,116,
  52,0,23,80,124,163,136,82,32,0,0,0,0,0,28,85,124,151,159,147,120,100,
  100,124,108,44,32,96,143,147,175,169,108,47,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,32,96,163,175,179,155,88,6,45,52,52,44,2,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,67,92,104,108,101,85,56,
  9,0,0,0,0,0,0,0,0,0,0,0,0,0,25,80,92,92,71,92,92,82,92,92,90,44,0,0,34,
  80,124,173,120,70,19,0,0,0,0,32,96,163,151,147,160,181,164,164,173,108,
  44,32,96,147,147,140,120,79,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,92,112,
  112,112,112,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,10,32,43,44,39,24,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,23,28,28,19,28,28,24,28,28,27,2,0,0,0,34,80,124,155,108,52,0,0,
  0,0,32,96,116,88,81,97,120,140,139,116,82,33,21,70,80,80,76,61,32,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,42,48,48,48,48,38,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,81,88,
  87,45,0,0,0,0,17,63,65,29,19,38,62,76,74,58,29,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  255
};

#endif /* HEADER_SIGNED_DISTANCE_FONT_XXX */
